PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE version (id TEXT NOT NULL) STRICT;
INSERT INTO version VALUES('v0.3.22');
CREATE TABLE metadata (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  doi TEXT DEFAULT '',
  title TEXT NOT NULL,
  alias TEXT DEFAULT '',
  description TEXT DEFAULT '',
  issued TEXT DEFAULT '',
  version TEXT DEFAULT '',
  keywords TEXT DEFAULT '',
  geographic_scope TEXT DEFAULT '',
  taxonomic_scope TEXT DEFAULT '',
  temporal_scope TEXT DEFAULT '',
  confidence INTEGER DEFAULT NULL,
  completeness INTEGER DEFAULT NULL,
  license TEXT DEFAULT '',
  url TEXT DEFAULT '',
  logo TEXT DEFAULT '',
  label TEXT DEFAULT '',
  citation TEXT DEFAULT '',
  private INTEGER DEFAULT NULL -- bool 
) STRICT;
INSERT INTO metadata VALUES(1,'10.5886/zw3aqw','Database of Vascular Plants of Canada (VASCAN)','VASCAN',replace('The Database of Vascular Plants of Canada or VASCAN (http://data.canadensys.net/vascan) is a comprehensive and curated checklist of all vascular plants reported in Canada, Greenland (Denmark), and Saint Pierre and Miquelon (France). VASCAN was developed at the Université de Montréal Biodiversity Centre and is maintained by a group of editors and contributors. For every core taxon in the checklist (species, subspecies, or variety), VASCAN provides the accepted scientific name, the accepted French and English vernacular names, and their synonyms/alternatives in Canada, as well as the distribution status (native, introduced, ephemeral, excluded, extirpated, doubtful or absent) of the plant for each province or territory, and the habit (tree, shrub, herb and/or vine) of the plant in Canada. For reported hybrids (nothotaxa or hybrid formulas) VASCAN also provides the hybrid parents, except if the parents of the hybrid do not occur in Canada. All taxa are linked to a classification. VASCAN refers to a source for all name, classification and distribution information.\n\nAll data have been released to the public domain under a CC0 waiver and are available through Canadensys and the Global Biodiversity Information Facility (GBIF). VASCAN is a service to the scientific community and the general public, including administrations, companies, and non-governmental organizations.','\n',char(10)),'2024-08-29','2024-08-29','','The checklist covers all vascular plants reported in Canada, Greenland (Denmark), and Saint Pierre and Miquelon (France). The latter two regions are added because their floras are intimately related to that of Canada and it is useful for Canadians and others to know about them. Provincial distributions are provided to help Canadians visualize the relationship among the floras of their provinces and territories. VASCAN does not intend to replace regional or provincial lists but to act as a complement to them. The covered regions are, in alphabetical order: Alberta, British Columbia, Greenland, Labrador, Manitoba, New Brunswick, Newfoundland, Northwest Territories, Nova Scotia, Nunavut, Ontario, Prince Edward Island, Quebec, Saint Pierre and Miquelon, Saskatchewan, and Yukon. The distribution status of the plant is indicated per region. These can be grouped as present (native, introduced or ephemeral), previously reported but currently considered absent (excluded, extirpated), doubtful or not reported (absent). The latter status is not recorded in the database (null value). Excluded taxa are those considered not currently occurring in a region, due either to non-recurring ephemeralness, misidentification, lack of supporting documentation, or when specimens are old and the taxon has not been observed again in more than 50 years. All distribution statuses are defined at http://data.canadensys.net/vascan/about/#distribution. The VASCAN website (http://data.canadensys.net/vascan) provides a distribution map for each taxon. For higher taxa, these are calculated based on lower taxa, with the distribution statuses ordered as such: native, introduced, ephemeral, excluded, extirpated, doubtful, absent. E.g., if two species within the same genus are respectively native and doubtful in a certain region, the genus is considered native for that region. The website also provides a checklist builder (http://data.canadensys.net/vascan/checklist), where users can generate their own list of taxa based on several criteria (taxonomy, region, distribution status, or a combination of these) and download this as a Darwin Core Archive or text file.','This checklist covers all vascular plants (Equisetopsida, Tracheophyta) reported in the area described in the section ''Geographic Coverage''. The core taxa considered are species, subspecies or varieties, and their hybrids. For these taxa, we provide synonyms, the accepted and alternative French and English vernacular names, and the habit (tree, shrub, herb and/or vine) of the plant in Canada. For reported hybrids (nothotaxa or hybrid formulas) we also indicate the hybrid parents, except if the parents of the hybrid do not occur in Canada. This core information is not provided for higher taxa, although the calculated distribution based on lower taxa can be consulted and downloaded from the VASCAN website (http://data.canadensys.net/vascan). All taxa are linked to a classification: Chase & Reveal (2009) for the higher classification, Christenhusz et al. (2011a) for lycophytes, Smith et al. (2006) for monilophytes (modified in Rothfells et al. 2012), Christenhusz et al. (2011b) for the gymnosperms, and the Angiosperm Phylogeny Group (2009) for flowering plants. At the generic level and below, the Flora of North America Editorial Committee (1993+) is the main source of classification, unless taxonomic literature more recent than the volume published for a given taxon provides a taxonomy more reflective of current data. The source used is indicated for each taxon in the dataset. The classification includes 16 ranks. They are, in hierarchical order: class, subclass, superorder, order, family, subfamily, tribe, subtribe, genus, subgenus, section, subsection, series, species, subspecies and variety. Varieties within subspecies are accepted, so quadrinomial names are present, but forms are not included.','',NULL,NULL,'cc0','http://data.canadensys.net/vascan/','http://data.canadensys.net/ipt/logo.do?r=vascan','','',0);
CREATE TABLE contact (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  metadata_id INTEGER DEFAULT 1,
  orcid TEXT DEFAULT '',
  given TEXT NOT NULL,
  family TEXT NOT NULL,
  rorid TEXT DEFAULT '',
  organisation TEXT DEFAULT '',
  email TEXT NOT NULL,
  url TEXT DEFAULT '',
  note TEXT DEFAULT ''
) STRICT;
INSERT INTO contact VALUES(1,1,'','Luc','Brouillet','','Université de Montréal Biodiversity Centre','luc.brouillet@umontreal.ca','http://www.irbv.umontreal.ca/luc-brouillet','');
CREATE TABLE editor (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  metadata_id INTEGER DEFAULT 1,
  orcid TEXT DEFAULT '',
  given TEXT NOT NULL,
  family TEXT NOT NULL,
  rorid TEXT DEFAULT '',
  organisation TEXT DEFAULT '',
  email TEXT DEFAULT '',
  url TEXT DEFAULT '',
  note TEXT DEFAULT ''
) STRICT;
INSERT INTO editor VALUES(1,1,'','Luc','Brouillet','','Université de Montréal Biodiversity Centre','luc.brouillet@umontreal.ca','http://www.irbv.umontreal.ca/luc-brouillet','');
INSERT INTO editor VALUES(2,1,'','Frédéric','Coursol','','Montreal Botanical Garden','frederic.coursol@ville.montreal.qc.ca','','');
INSERT INTO editor VALUES(3,1,'','Susan','Meades','','Northern Ontario Plant Database','herbaria@nrcan.gc.ca','http://www.northernontarioflora.ca','');
INSERT INTO editor VALUES(4,1,'','Marc','Favreau','','Translation Bureau (Government of Canada)','marc.favreau@tpsgc-pwgsc.gc.ca','','');
INSERT INTO editor VALUES(5,1,'','Marilyn','Anions','','NatureServe Canada','manions@natureserve.ca','','');
CREATE TABLE creator (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  metadata_id INTEGER DEFAULT 1,
  orcid TEXT DEFAULT '',
  given TEXT NOT NULL,
  family TEXT NOT NULL,
  rorid TEXT DEFAULT '',
  organisation TEXT DEFAULT '',
  email TEXT DEFAULT '',
  url TEXT DEFAULT '',
  note TEXT DEFAULT ''
) STRICT;
INSERT INTO creator VALUES(1,1,'','Luc','Brouillet','','Université de Montréal Biodiversity Centre','luc.brouillet@umontreal.ca','http://www.irbv.umontreal.ca/luc-brouillet','');
CREATE TABLE publisher (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  metadata_id INTEGER DEFAULT 1,
  orcid TEXT DEFAULT '',
  given TEXT DEFAULT '',
  family TEXT DEFAULT '',
  rorid TEXT DEFAULT '',
  organisation TEXT DEFAULT '',
  email TEXT DEFAULT '',
  url TEXT DEFAULT '',
  note TEXT DEFAULT ''
) STRICT;
INSERT INTO publisher VALUES(1,1,'','','','','Université de Montréal Biodiversity Centre','','','Host');
CREATE TABLE contributor (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  metadata_id INTEGER DEFAULT 1,
  orcid TEXT DEFAULT '',
  given TEXT NOT NULL,
  family TEXT NOT NULL,
  rorid TEXT DEFAULT '',
  organisation TEXT DEFAULT '',
  email TEXT DEFAULT '',
  url TEXT DEFAULT '',
  note TEXT DEFAULT ''
) STRICT;
INSERT INTO contributor VALUES(1,1,'','Jérémy','Goimard','','Université de Montréal Biodiversity Centre','canadensys.network@gmail.com','','programmer');
CREATE TABLE source (
  id TEXT PRIMARY KEY,
  metadata_id INTEGER DEFAULT 1,
  type TEXT DEFAULT '',
  title TEXT DEFAULT '',
  authors TEXT DEFAULT '',
  issued TEXT DEFAULT '',
  isbn TEXT DEFAULT ''
) STRICT;
CREATE TABLE author (
  id TEXT PRIMARY KEY,
  source_id TEXT REFERENCES source DEFAULT '',
  alternative_id TEXT DEFAULT '', -- sep by ','
  given TEXT DEFAULT '',
  family TEXT NOT NULL,
  -- f. for filius,  Jr., etc
  suffix TEXT DEFAULT '',
  abbreviation_botany TEXT DEFAULT '',
  alternative_names TEXT DEFAULT '', -- separated by '|'
  sex_id TEXT REFERENCES sex DEFAULT '',
  country TEXT DEFAULT '',
  birth TEXT DEFAULT '',
  birth_place TEXT DEFAULT '',
  death TEXT DEFAULT '',
  affiliation TEXT DEFAULT '',
  interest TEXT DEFAULT '',
  reference_id TEXT DEFAULT '', -- sep by ','
  -- url
  link TEXT DEFAULT '',
  remarks TEXT DEFAULT '',
  modified TEXT DEFAULT '',
  modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE reference (
  id TEXT PRIMARY KEY,
  alternative_id TEXT DEFAULT '', -- sep by ',', scope:id, id, URI/URN
  gn_local_id TEXT default '', -- used by GNverifier for links
  gn_global_id TEXT default '', -- used by GNverifier for links
  source_id TEXT REFERENCES source DEFAULT '',
  citation TEXT DEFAULT '',
  type TEXT REFERENCES reference_type DEFAULT '',
  -- author/s in format of either
  -- family1, given1; family2, given2; ..
  -- or
  -- given1 family1, given2 family2, ...
  author TEXT DEFAULT '',
  author_id TEXT DEFAULT '', -- 'ref' author, sep ','
  editor TEXT DEFAULT '', -- 'ref' author, sep ','
  editor_id TEXT DEFAULT '', -- 'ref' author, sep ','
  title TEXT DEFAULT '',
  title_short TEXT DEFAULT '',
  -- container_author is an author or a parent volume (book, journal) 
  container_author TEXT DEFAULT '',
  -- container_title of the parent container
  container_title TEXT DEFAULT '',
  -- container_title_short of the parent container
  container_title_short TEXT DEFAULT '',
  issued TEXT DEFAULT '', -- yyyy-mm-dd
  accessed TEXT DEFAULT '', -- yyyy-mm-dd
  -- collection_title of the parent volume
  collection_title TEXT DEFAULT '',
  -- collection_editor of the parent volume
  collection_editor TEXT DEFAULT '',
  volume TEXT DEFAULT '',
  issue TEXT DEFAULT '',
  -- edition number
  edition TEXT DEFAULT '',
  -- page number
  page TEXT DEFAULT '',
  publisher TEXT DEFAULT '',
  publisher_place TEXT DEFAULT '',
  -- version of the reference
  version TEXT DEFAULT '',
  isbn TEXT DEFAULT '',
  issn TEXT DEFAULT '',
  doi TEXT DEFAULT '',
  link TEXT DEFAULT '',
  remarks TEXT DEFAULT '',
  modified TEXT DEFAULT '',
  modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE name (
  id TEXT PRIMARY KEY,
  alternative_id TEXT DEFAULT '',
  source_id TEXT DEFAULT '',
  -- basionym_id TEXT DEFAULT '', -- use name_relation instead
  gn_scientific_name_string TEXT NOT NULL, -- full name with authorship (if given)
  scientific_name TEXT NOT NULL, -- full canonical form
  authorship TEXT DEFAULT '', -- verbatim authorship
  rank_id TEXT REFERENCES rank DEFAULT '',
  uninomial TEXT DEFAULT '',
  genus TEXT DEFAULT '',
  infrageneric_epithet TEXT DEFAULT '',
  specific_epithet TEXT DEFAULT '',
  infraspecific_epithet TEXT DEFAULT '',
  cultivar_epithet TEXT DEFAULT '',
  notho_id TEXT DEFAULT '', -- ref name_part
  original_spelling INTEGER DEFAULT NULL, -- bool
  combination_authorship TEXT DEFAULT '', -- separated by '|'
  combination_authorship_id TEXT DEFAULT '', -- separated by '|'
  combination_ex_authorship TEXT DEFAULT '', -- separated by '|'
  combination_ex_authorship_id TEXT DEFAULT '', -- separated by '|'
  combination_authorship_year TEXT DEFAULT '',
  basionym_authorship TEXT DEFAULT '', -- separated by '|'
  basionym_authorship_id TEXT DEFAULT '', -- separated by '|'
  basionym_ex_authorship TEXT DEFAULT '', -- separated by '|'
  basionym_ex_authorship_id TEXT DEFAULT '', -- separated by '|'
  basionym_authorship_year TEXT DEFAULT '',
  code_id TEXT REFERENCES nom_code DEFAULT '',
  status_id TEXT REFERENCES nom_status DEFAULT '',
  reference_id TEXT DEFAULT '', -- refs about taxon sep ','
  published_in_year TEXT DEFAULT '',
  published_in_page TEXT DEFAULT '',
  published_in_page_link TEXT DEFAULT '',
  gender_id TEXT REFERENCES gender DEFAULT '',
  gender_agreement INTEGER DEFAULT NULL, -- bool
  etymology TEXT DEFAULT '',
  link TEXT DEFAULT '',
  remarks TEXT DEFAULT '',
  modified TEXT DEFAULT '',
  modified_by TEXT DEFAULT ''
) STRICT;
INSERT INTO name VALUES('73','','','Equisetopsida C. Agardh','Equisetopsida','C. Agardh','CLASS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('48','','','Ophioglossidae Klinge','Ophioglossidae','Klinge','SUBCLASS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('47','','','Ophioglossales Link','Ophioglossales','Link','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('180','','','Ophioglossaceae Martinov','Ophioglossaceae','Martinov','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31526','','','Ophioglossoideae C. Presl','Ophioglossoideae','C. Presl','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1483','','','Ophioglossum Linnaeus','Ophioglossum','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6831','','','Ophioglossum azoricum C. Presl','Ophioglossum azoricum','C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6832','','','Ophioglossum pusillum Rafinesque','Ophioglossum pusillum','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17572','','','Ophioglossum vulgatum var. pseudopodum (S.F. Blake) Farwell','Ophioglossum vulgatum var. pseudopodum','(S.F. Blake) Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31527','','','Botrychioideae C. Presl','Botrychioideae','C. Presl','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('906','','','Botrychium Swartz','Botrychium','Swartz','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3862','','','Botrychium paradoxum W.H. Wagner','Botrychium paradoxum','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3863','','','Botrychium pedunculosum W.H. Wagner','Botrychium pedunculosum','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3864','','','Botrychium pseudopinnatum W.H. Wagner','Botrychium pseudopinnatum','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3865','','','Botrychium simplex E. Hitchcock','Botrychium simplex','E. Hitchcock','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27738','','','Botrychium simplex var. compositum (Lasch) Milde','Botrychium simplex var. compositum','(Lasch) Milde','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27739','','','Botrychium simplex var. simplex E. Hitchcock','Botrychium simplex var. simplex','E. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28932','','','Botrychium simplex subsp. simplex E. Hitchcock','Botrychium simplex subsp. simplex','E. Hitchcock','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3858','','','Botrychium minganense Victorin','Botrychium minganense','Victorin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12945','','','Botrychium lunaria var. minganense (Victorin) Dole','Botrychium lunaria var. minganense','(Victorin) Dole','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3859','','','Botrychium montanum W.H. Wagner','Botrychium montanum','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3860','','','Botrychium mormo W.H. Wagner','Botrychium mormo','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3861','','','Botrychium pallidum W.H. Wagner','Botrychium pallidum','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9840','','','Botrychium alaskense W.H. Wagner & J.R. Grant','Botrychium alaskense','W.H. Wagner & J.R. Grant','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9866','','','Botrychium tunux Stensvold & Farrar','Botrychium tunux','Stensvold & Farrar','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9867','','','Botrychium yaaxudakeit Stensvold & Farrar','Botrychium yaaxudakeit','Stensvold & Farrar','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3847','','','Botrychium boreale Milde','Botrychium boreale','Milde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3846','','','Botrychium boreale subsp. boreale Milde','Botrychium boreale subsp. boreale','Milde','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3866','','','Botrychium spathulatum W.H. Wagner','Botrychium spathulatum','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3867','','','Botrychium × watertonense W.H. Wagner','Botrychium × watertonense','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3845','','','Botrychium ascendens W.H. Wagner','Botrychium ascendens','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3849','','','Botrychium campestre W.H. Wagner & Farrar','Botrychium campestre','W.H. Wagner & Farrar','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32584','','','Botrychium campestre var. lineare (W.H. Wagner) D.R. Farrar','Botrychium campestre var. lineare','(W.H. Wagner) D.R. Farrar','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3855','','','Botrychium lineare W.H. Wagner','Botrychium lineare','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32583','','','Botrychium campestre var. campestre W.H. Wagner & Farrar','Botrychium campestre var. campestre','W.H. Wagner & Farrar','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3848','','','Botrychium pinnatum H. St.John','Botrychium pinnatum','H. St.John','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12941','','','Botrychium boreale subsp. obtusilobum (Ruprecht) Clausen','Botrychium boreale subsp. obtusilobum','(Ruprecht) Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3856','','','Botrychium lunaria (Linnaeus) Swartz','Botrychium lunaria','(Linnaeus) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28933','','','Botrychium lunaria var. lunaria (Linnaeus) Swartz','Botrychium lunaria var. lunaria','(Linnaeus) Swartz','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26182','','','Botrychium lunaria var. onondagense (Underwood) House','Botrychium lunaria var. onondagense','(Underwood) House','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21979','','','Osmunda lunaria Linnaeus','Osmunda lunaria','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30344','','','Botrychium lunaria var. melzeri Stensvold & Farrar','Botrychium lunaria var. melzeri','Stensvold & Farrar','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3857','','','Botrychium matricariifolium (Retzius) A. Braun ex W.D.J. Koch','Botrychium matricariifolium','(Retzius) A. Braun ex W.D.J. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29103','','','Osmunda lunaria var. matricariifolia Retzius','Osmunda lunaria var. matricariifolia','Retzius','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28945','','','Botrychium ramosum (Roth) Ascherson','Botrychium ramosum','(Roth) Ascherson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28958','','','Botrychium neglectum Alph. Wood','Botrychium neglectum','Alph. Wood','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21980','','','Botrychium lunaria var. matricariifolium (Retzius) Döll','Botrychium lunaria var. matricariifolium','(Retzius) Döll','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3844','','','Botrychium acuminatum W.H. Wagner','Botrychium acuminatum','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3851','','','Botrychium hesperium (Maxon & R.T. Clausen) W.H. Wagner & Lellinger','Botrychium hesperium','(Maxon & R.T. Clausen) W.H. Wagner & Lellinger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12942','','','Botrychium matricariifolium subsp. hesperium Maxon & R.T. Clausen','Botrychium matricariifolium subsp. hesperium','Maxon & R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3850','','','Botrychium crenulatum W.H. Wagner','Botrychium crenulatum','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12947','','','Botrychium tenebrosum A.A. Eaton','Botrychium tenebrosum','A.A. Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12946','','','Botrychium simplex var. tenebrosum (A.A. Eaton) R.T. Clausen','Botrychium simplex var. tenebrosum','(A.A. Eaton) R.T. Clausen','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3853','','','Botrychium lanceolatum (S.G. Gmelin) Angström','Botrychium lanceolatum','(S.G. Gmelin) Angström','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3854','','','Botrychium lanceolatum subsp. lanceolatum (S.G. Gmelin) Angström','Botrychium lanceolatum subsp. lanceolatum','(S.G. Gmelin) Angström','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28943','','','Botrychium lanceolatum subsp. typicum R.T. Clausen nom. inval.','Botrychium lanceolatum subsp. typicum','R.T. Clausen nom. inval.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12944','','','Botrychium lanceolatum var. lanceolatum (S.G. Gmelin) Angström','Botrychium lanceolatum var. lanceolatum','(S.G. Gmelin) Angström','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3852','','','Botrychium lanceolatum subsp. angustisegmentum (Pease & A.H. Moore) R.T. Clausen','Botrychium lanceolatum subsp. angustisegmentum','(Pease & A.H. Moore) R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25721','','','Botrychium angustisegmentum (Pease & A.H. Moore) Fernald','Botrychium angustisegmentum','(Pease & A.H. Moore) Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12943','','','Botrychium lanceolatum var. angustisegmentum Pease & A.H. Moore','Botrychium lanceolatum var. angustisegmentum','Pease & A.H. Moore','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30345','','','Botrychium neolunaria Stensvold & Farrar','Botrychium neolunaria','Stensvold & Farrar','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26181','','','Botrychium onondagense Underwood','Botrychium onondagense','Underwood','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29081','','','Botrychium echo W.H. Wagner','Botrychium echo','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29422','','','Botrychium michiganense W.H. Wagner ex A.V. Gilman, Farrar & Zika','Botrychium michiganense','W.H. Wagner ex A.V. Gilman, Farrar & Zika','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27737','','','Sceptridium Lyon','Sceptridium','Lyon','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12951','','','Sceptridium dissectum (Sprengel) Lyon','Sceptridium dissectum','(Sprengel) Lyon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28944','','','Botrychium obliquum var. dissectum (Sprengel) Prantl','Botrychium obliquum var. dissectum','(Sprengel) Prantl','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27193','','','Botrychium dissectum var. dissectum Sprengel','Botrychium dissectum var. dissectum','Sprengel','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26184','','','Osmunda obliqua (Muhlenberg) Poiret','Osmunda obliqua','(Muhlenberg) Poiret','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26183','','','Sceptridium obliquum (Muhlenberg) Lyon','Sceptridium obliquum','(Muhlenberg) Lyon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26186','','','Botrychium obliquum var. elongatum Gilbert & Haberer','Botrychium obliquum var. elongatum','Gilbert & Haberer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26185','','','Botrychium dissectum var. elongatum (Gilbert & Haberer) Farwell','Botrychium dissectum var. elongatum','(Gilbert & Haberer) Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21981','','','Botrychium obliquum Muhlenberg','Botrychium obliquum','Muhlenberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12953','','','Botrychium ternatum var. dissectum (Sprengel) D.C. Eaton','Botrychium ternatum var. dissectum','(Sprengel) D.C. Eaton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12954','','','Botrychium ternatum var. obliquum (Muhlenberg) Milde','Botrychium ternatum var. obliquum','(Muhlenberg) Milde','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12952','','','Botrychium dissectum var. obliquum (Muhlenberg) Clute','Botrychium dissectum var. obliquum','(Muhlenberg) Clute','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3869','','','Botrychium dissectum Sprengel','Botrychium dissectum','Sprengel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12961','','','Sceptridium rugulosum (W.H. Wagner) Skoda & Holub','Sceptridium rugulosum','(W.H. Wagner) Skoda & Holub','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12962','','','Botrychium ternatum','Botrychium ternatum','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3872','','','Botrychium rugulosum W.H. Wagner','Botrychium rugulosum','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12955','','','Sceptridium multifidum (S.G. Gmelin) M. Nishida','Sceptridium multifidum','(S.G. Gmelin) M. Nishida','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28024','','','Botrychium multifidum var. multifidum (S.G. Gmelin) Ruprecht','Botrychium multifidum var. multifidum','(S.G. Gmelin) Ruprecht','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28954','','','Botrychium matricariae (Schrank) Sprengel','Botrychium matricariae','(Schrank) Sprengel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28953','','','Botrychium multifidum subsp. typicum R.T. Clausen nom. inval.','Botrychium multifidum subsp. typicum','R.T. Clausen nom. inval.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28957','','','Sceptridium silaifolium (C. Presl) Lyon','Sceptridium silaifolium','(C. Presl) Lyon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23495','','','Botrychium multifidum var. silaifolium (C. Presl.) M. Broun','Botrychium multifidum var. silaifolium','(C. Presl.) M. Broun','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23496','','','Botrychium multifidum subsp. silaifolium (C. Presl) R.T. Clausen','Botrychium multifidum subsp. silaifolium','(C. Presl) R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21982','','','Osmunda multifida S.G. Gmelin','Osmunda multifida','S.G. Gmelin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12957','','','Botrychium multifidum var. intermedium (D.C. Eaton) Farwell','Botrychium multifidum var. intermedium','(D.C. Eaton) Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12956','','','Botrychium silaifolium C. Presl','Botrychium silaifolium','C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3870','','','Botrychium multifidum (S.G. Gmelin) Ruprecht','Botrychium multifidum','(S.G. Gmelin) Ruprecht','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12958','','','Sceptridium oneidense (Gilbert) Holub','Sceptridium oneidense','(Gilbert) Holub','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25722','','','Botrychium obliquum var. oneidense (Gilbert) Waters','Botrychium obliquum var. oneidense','(Gilbert) Waters','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25723','','','Sceptridium obliquum var. oneidense (Gilbert) Lyon','Sceptridium obliquum var. oneidense','(Gilbert) Lyon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21983','','','Botrychium dissectum var. oneidense (Gilbert) Farwell','Botrychium dissectum var. oneidense','(Gilbert) Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12960','','','Botrychium multifidum var. oneidense (Gilbert) Farwell','Botrychium multifidum var. oneidense','(Gilbert) Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12959','','','Botrychium ternatum var. oneidense Gilbert','Botrychium ternatum var. oneidense','Gilbert','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3871','','','Botrychium oneidense (Gilbert) House','Botrychium oneidense','(Gilbert) House','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27736','','','Botrypus Michaux','Botrypus','Michaux','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12948','','','Botrypus virginianus (Linnaeus) Michaux','Botrypus virginianus','(Linnaeus) Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28956','','','Botrychium virginianum subsp. typicum R.T. Clausen nom. inval.','Botrychium virginianum subsp. typicum','R.T. Clausen nom. inval.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26188','','','Osmundopteris virginiana (Linnaeus) Small','Osmundopteris virginiana','(Linnaeus) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26187','','','Japanobotrychium virginianum (Linnaeus) M. Nishida','Japanobotrychium virginianum','(Linnaeus) M. Nishida','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26190','','','Botrychium virginianum var. laurentianum Butters','Botrychium virginianum var. laurentianum','Butters','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26189','','','Botrychium virginianum subsp. virginianum (Linnaeus) Swartz','Botrychium virginianum subsp. virginianum','(Linnaeus) Swartz','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21938','','','Osmunda virginiana Linnaeus','Osmunda virginiana','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12950','','','Botrychium virginianum var. virginianum (Linnaeus) Swartz','Botrychium virginianum var. virginianum','(Linnaeus) Swartz','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12949','','','Botrychium virginianum var. europaeum Angström','Botrychium virginianum var. europaeum','Angström','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3868','','','Botrychium virginianum (Linnaeus) Swartz','Botrychium virginianum','(Linnaeus) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('53','','','Pinidae Cronquist, Takhtajan & Zimmermann','Pinidae','Cronquist, Takhtajan & Zimmermann','SUBCLASS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('52','','','Pinales Gorozhankin','Pinales','Gorozhankin','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('189','','','Pinaceae Sprengel ex F. Rudolphi','Pinaceae','Sprengel ex F. Rudolphi','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32761','','','Pinoideae W. Hochstetter','Pinoideae','W. Hochstetter','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1553','','','Pinus Linnaeus','Pinus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~7P','','','Pinus (Pinus)','Pinus (Pinus)','','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32757','','','Pinus sect. Trifoliae Duhamel du Monceau','Pinus sect. Trifoliae','Duhamel du Monceau','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32760','','','Pinus subsect. Contortae Critchfield & Little','Pinus subsect. Contortae','Critchfield & Little','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7197','','','Pinus virginiana Miller','Pinus virginiana','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7181','','','Pinus banksiana Lambert','Pinus banksiana','Lambert','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30794','','','Pinus divaricata (Aiton) Sudworth nom. illeg.','Pinus divaricata','(Aiton) Sudworth nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22136','','','Pinus sylvestris var. divaricata Aiton','Pinus sylvestris var. divaricata','Aiton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17915','','','Pinus hudsonia Poiret','Pinus hudsonia','Poiret','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17914','','','Pinus divaricata (Aiton) Dumont de Courset','Pinus divaricata','(Aiton) Dumont de Courset','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17917','','','Pinus rupestris F. Michaux','Pinus rupestris','F. Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17916','','','Pinus hudsonica Parlatore','Pinus hudsonica','Parlatore','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7198','','','Pinus × murraybanksiana Righter & Stockwell','Pinus × murraybanksiana','Righter & Stockwell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7184','','','Pinus contorta Douglas ex Loudon','Pinus contorta','Douglas ex Loudon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7185','','','Pinus contorta var. latifolia Engelmann','Pinus contorta var. latifolia','Engelmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17919','','','Pinus contorta subsp. latifolia (Engelmann) Critchfield','Pinus contorta subsp. latifolia','(Engelmann) Critchfield','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7183','','','Pinus contorta var. contorta Douglas ex Loudon','Pinus contorta var. contorta','Douglas ex Loudon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9833','','','Pinus contorta var. yukonensis W.L. Strong','Pinus contorta var. yukonensis','W.L. Strong','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32758','','','Pinus subsect. Australes Loudon','Pinus subsect. Australes','Loudon','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7194','','','Pinus rigida P. Miller','Pinus rigida','P. Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32759','','','Pinus subsect. Ponderosae Loudon','Pinus subsect. Ponderosae','Loudon','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7191','','','Pinus ponderosa Douglas ex Lawson & C. Lawson','Pinus ponderosa','Douglas ex Lawson & C. Lawson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7190','','','Pinus ponderosa var. ponderosa Douglas ex Lawson & C. Lawson','Pinus ponderosa var. ponderosa','Douglas ex Lawson & C. Lawson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7192','','','Pinus ponderosa var. scopulorum Engelmann','Pinus ponderosa var. scopulorum','Engelmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22138','','','Pinus scopulorum (Engelmann) Lemmon','Pinus scopulorum','(Engelmann) Lemmon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32755','','','Pinus sect. Pinus','Pinus sect. Pinus','','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32756','','','Pinus subsect. Pinus','Pinus subsect. Pinus','','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7196','','','Pinus sylvestris Linnaeus','Pinus sylvestris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22137','','','Pinus sylvestris var. sylvestris Linnaeus','Pinus sylvestris var. sylvestris','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7188','','','Pinus mugo Turra','Pinus mugo','Turra','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7189','','','Pinus nigra J.F. Arnold','Pinus nigra','J.F. Arnold','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7193','','','Pinus resinosa Aiton','Pinus resinosa','Aiton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2020','','','Pinus subgen. Pinus','Pinus subgen. Pinus','','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2019','','','Pinus subgen. Strobus (D. Don) Lemon','Pinus subgen. Strobus','(D. Don) Lemon','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7195','','','Pinus strobus Linnaeus','Pinus strobus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22135','','','Strobus strobus (Linnaeus) Small nom. inval.','Strobus strobus','(Linnaeus) Small nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7187','','','Pinus monticola Douglas ex D. Don','Pinus monticola','Douglas ex D. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22134','','','Strobus monticola (Douglas ex D. Don) Rydberg','Strobus monticola','(Douglas ex D. Don) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7186','','','Pinus flexilis E. James','Pinus flexilis','E. James','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22133','','','Alpinus flexilis (E. James) Rydberg','Alpinus flexilis','(E. James) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7182','','','Pinus cembra Linnaeus','Pinus cembra','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7180','','','Pinus albicaulis Engelmann','Pinus albicaulis','Engelmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22132','','','Apinus albicaulis (Engelmann) Rydberg','Apinus albicaulis','(Engelmann) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32762','','','Piceoideae Frankis','Piceoideae','Frankis','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1547','','','Picea A. Dietrich','Picea','A. Dietrich','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7176','','','Picea pungens Engelmann','Picea pungens','Engelmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7175','','','Picea mariana × Picea rubens','Picea mariana × Picea rubens','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7178','','','Picea sitchensis (Bongard) Carrière','Picea sitchensis','(Bongard) Carrière','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22130','','','Picea menziesii (Douglas ex D. Don) Carrière','Picea menziesii','(Douglas ex D. Don) Carrière','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22131','','','Pinus menziesii Douglas ex D. Don','Pinus menziesii','Douglas ex D. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22128','','','Abies menziesii (Douglas ex D. Don) Lindley','Abies menziesii','(Douglas ex D. Don) Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22129','','','Picea falcata (Rafinesque) Suringar','Picea falcata','(Rafinesque) Suringar','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22126','','','Pinus sitchensis Bongard','Pinus sitchensis','Bongard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22127','','','Abie falcata Rafinesque','Abie falcata','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7177','','','Picea rubens Sargent','Picea rubens','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22123','','','Picea australis Small','Picea australis','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22124','','','Picea nigra var. rubra (DuRoi) Engelmann','Picea nigra var. rubra','(DuRoi) Engelmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22125','','','Picea rubra (DuRoi) Link nom. illeg.','Picea rubra','(DuRoi) Link nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7171','','','Picea engelmannii Engelmann','Picea engelmannii','Engelmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7170','','','Picea engelmannii var. engelmannii Engelmann','Picea engelmannii var. engelmannii','Engelmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17911','','','Picea glauca subsp. engelmannii (Engelmann) T.M.C. Taylor','Picea glauca subsp. engelmannii','(Engelmann) T.M.C. Taylor','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17910','','','Picea glauca var. engelmannii (Engelmann) B. Boivin','Picea glauca var. engelmannii','(Engelmann) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7179','','','Picea × lutzii Little','Picea × lutzii','Little','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22114','','','Picea × albertiana S. Brown','Picea × albertiana','S. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32840','','','Picea × albertiana subsp. ogilvei Strong & Hills','Picea × albertiana subsp. ogilvei','Strong & Hills','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32839','','','Picea × albertiana var. porsildii (Raup) Strong & Hills','Picea × albertiana var. porsildii','(Raup) Strong & Hills','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32838','','','Picea × albertiana var. densata (Bailey) Strong & Hills','Picea × albertiana var. densata','(Bailey) Strong & Hills','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32837','','','Picea glauca subsp. albertiana (S. Brown) P.A. Schmidt','Picea glauca subsp. albertiana','(S. Brown) P.A. Schmidt','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32836','','','Picea canadensis var. albertiana (S. Brown) Rehder','Picea canadensis var. albertiana','(S. Brown) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32835','','','Picea × albertiana subsp. albertiana S. Brown','Picea × albertiana subsp. albertiana','S. Brown','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22117','','','Picea glauca var. densata L.H. Bailey','Picea glauca var. densata','L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22112','','','Picea alba var. albertiana (S. Brown) Beissner','Picea alba var. albertiana','(S. Brown) Beissner','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17913','','','Picea glauca var. porsildii Raup','Picea glauca var. porsildii','Raup','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17912','','','Picea glauca var. albertiana (S. Brown) Sargent','Picea glauca var. albertiana','(S. Brown) Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7169','','','Picea abies (Linnaeus) H. Karsten','Picea abies','(Linnaeus) H. Karsten','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22109','','','Pinus abies Linnaeus','Pinus abies','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7174','','','Picea mariana (Miller) Britton, Sterns & Poggenburgh','Picea mariana','(Miller) Britton, Sterns & Poggenburgh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22121','','','Picea mariana var. brevifolia (Peck) Rehder','Picea mariana var. brevifolia','(Peck) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22120','','','Picea brevifolia Peck','Picea brevifolia','Peck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22122','','','Picea nigra (Aiton) Link','Picea nigra','(Aiton) Link','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22119','','','Abies mariana Miller','Abies mariana','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7173','','','Picea glauca (Moench) Voss','Picea glauca','(Moench) Voss','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31244','','','Picea alba (Castiglioni) Link','Picea alba','(Castiglioni) Link','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22116','','','Picea canadensis var. glauca (Moench) Sudworth','Picea canadensis var. glauca','(Moench) Sudworth','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22118','','','Pinus alba Aiton nom. illeg.','Pinus alba','Aiton nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22111','','','Abies canadensis (Linnaeus) Miller','Abies canadensis','(Linnaeus) Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22115','','','Picea canadensis (Miller) Britton, Sterns & Poggenburg nom. inval.','Picea canadensis','(Miller) Britton, Sterns & Poggenburg nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22113','','','Picea alba (Aiton) Link','Picea alba','(Aiton) Link','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22110','','','Pinus glauca Moench','Pinus glauca','Moench','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33589','','','Picea × darwyniana Björk & Goward','Picea × darwyniana','Björk & Goward','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7172','','','Picea engelmannii var. engelmannii × Picea glauca','Picea engelmannii var. engelmannii × Picea glauca','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32764','','','Abietoideae Sweet','Abietoideae','Sweet','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1796','','','Tsuga (Endler) Carrière','Tsuga','(Endler) Carrière','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7205','','','Tsuga × jeffreyi (Henry) Henry','Tsuga × jeffreyi','(Henry) Henry','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7204','','','Tsuga mertensiana (Bongard) Carrière','Tsuga mertensiana','(Bongard) Carrière','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22103','','','Pinus mertensiana Bongard','Pinus mertensiana','Bongard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22104','','','Hesperopeuce mertensiana (Bongard) Rydberg','Hesperopeuce mertensiana','(Bongard) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7203','','','Tsuga heterophylla (Rafinesque) Sargent','Tsuga heterophylla','(Rafinesque) Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22102','','','Abies heterophylla Rafinesque','Abies heterophylla','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7202','','','Tsuga canadensis (Linnaeus) Carrière','Tsuga canadensis','(Linnaeus) Carrière','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22101','','','Pinus canadensis Linnaeus','Pinus canadensis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('764','','','Abies Miller','Abies','Miller','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2211','','','Abies sect. Grandis Engelmann','Abies sect. Grandis','Engelmann','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7161','','','Abies grandis (Douglas ex D. Don) Lindley','Abies grandis','(Douglas ex D. Don) Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22108','','','Pinus grandis Douglas ex D. Don','Pinus grandis','Douglas ex D. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17905','','','Abies excelsior Franco','Abies excelsior','Franco','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17904','','','Abies grandis var. grandis (Douglas ex D. Don) Lindley','Abies grandis var. grandis','(Douglas ex D. Don) Lindley','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2210','','','Abies sect. Balsamea Engelmann','Abies sect. Balsamea','Engelmann','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2367','','','Abies subsect. Laterales Patschke','Abies subsect. Laterales','Patschke','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7162','','','Abies lasiocarpa (Hooker) Nuttall','Abies lasiocarpa','(Hooker) Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22107','','','Pinus lasiocarpa Hooker','Pinus lasiocarpa','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17906','','','Abies lasiocarpa var. lasiocarpa (Hooker) Nuttall','Abies lasiocarpa var. lasiocarpa','(Hooker) Nuttall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7160','','','Abies bifolia A. Murray','Abies bifolia','A. Murray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17903','','','Abies subalpina Engelmann','Abies subalpina','Engelmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7159','','','Abies balsamea (Linnaeus) Miller','Abies balsamea','(Linnaeus) Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17900','','','Abies balsamea var. phanerolepis Fernald','Abies balsamea var. phanerolepis','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26228','','','Abies balsamea subsp. phanerolepis (Fernald) A.E. Murray','Abies balsamea subsp. phanerolepis','(Fernald) A.E. Murray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17901','','','Abies × phanerolepis (Fernald) T.S. Liu','Abies × phanerolepis','(Fernald) T.S. Liu','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32803','','','Abies balsamea var. balsamea (Linnaeus) Miller','Abies balsamea var. balsamea','(Linnaeus) Miller','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26227','','','Abies hudsonia Bosc ex Jacques','Abies hudsonia','Bosc ex Jacques','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17902','','','Pinus balsamea Linnaeus','Pinus balsamea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2209','','','Abies sect. Amabilis (Matzenko) Farjon & Rushforth','Abies sect. Amabilis','(Matzenko) Farjon & Rushforth','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7158','','','Abies amabilis Douglas ex J. Forbes','Abies amabilis','Douglas ex J. Forbes','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32763','','','Laricoideae Riedl','Laricoideae','Riedl','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1596','','','Pseudotsuga Carrière','Pseudotsuga','Carrière','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7200','','','Pseudotsuga menziesii (Mirbel) Franco','Pseudotsuga menziesii','(Mirbel) Franco','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7199','','','Pseudotsuga menziesii var. glauca (Beissner) Franco','Pseudotsuga menziesii var. glauca','(Beissner) Franco','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22105','','','Pseudotsuga douglasii var. glauca (Beissner) Mayr','Pseudotsuga douglasii var. glauca','(Beissner) Mayr','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7201','','','Pseudotsuga menziesii var. menziesii (Mirbel) Franco','Pseudotsuga menziesii var. menziesii','(Mirbel) Franco','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31453','','','Abies taxifolia (Lambert) Poiret nom. illeg.','Abies taxifolia','(Lambert) Poiret nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31454','','','Pinus taxifolia Lambert nom. illeg.','Pinus taxifolia','Lambert nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31451','','','Abies menziesii Mirbel','Abies menziesii','Mirbel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31452','','','Abies mucronata Rafinesque','Abies mucronata','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31450','','','Pseudotsuga mucronata (Rafinesque) Sudworth','Pseudotsuga mucronata','(Rafinesque) Sudworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17920','','','Pseudotsuga taxifolia (Lambert) Britton','Pseudotsuga taxifolia','(Lambert) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17921','','','Pseudotsuga douglasii (Sabine ex D. Don) Carrière','Pseudotsuga douglasii','(Sabine ex D. Don) Carrière','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1318','','','Larix Miller','Larix','Miller','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2214','','','Larix sect. Multiseriales Patschke','Larix sect. Multiseriales','Patschke','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7167','','','Larix lyallii Parlatore','Larix lyallii','Parlatore','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7168','','','Larix occidentalis Nuttall','Larix occidentalis','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2213','','','Larix sect. Larix','Larix sect. Larix','','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7166','','','Larix laricina (Du Roi) K. Koch','Larix laricina','(Du Roi) K. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32267','','','Larix americana Michaux','Larix americana','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28332','','','Larix intermedia Loddiges ex J. Forbes','Larix intermedia','Loddiges ex J. Forbes','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28685','','','Larix laricina subsp. alaskensis (W. Wight) Silba','Larix laricina subsp. alaskensis','(W. Wight) Silba','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28684','','','Larix laricina var. alaskensis (W. Wight) Raup','Larix laricina var. alaskensis','(W. Wight) Raup','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22106','','','Pinus laricina Du Roi','Pinus laricina','Du Roi','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17909','','','Larix alaskensis W. Wight','Larix alaskensis','W. Wight','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7164','','','Larix decidua Miller','Larix decidua','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7165','','','Larix kaempferi (Lambert) Carrière','Larix kaempferi','(Lambert) Carrière','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17908','','','Larix leptolepis (Siebold & Zuccarini) Gordon','Larix leptolepis','(Siebold & Zuccarini) Gordon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24669','','','Cupressales Link','Cupressales','Link','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('227','','','Taxaceae Gray','Taxaceae','Gray','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1741','','','Taxus Linnaeus','Taxus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9400','','','Taxus brevifolia Nuttall','Taxus brevifolia','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22093','','','Taxus baccata subsp. brevifolia (Nuttall) Pilger','Taxus baccata subsp. brevifolia','(Nuttall) Pilger','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22094','','','Taxus baccata var. brevifolia (Nuttall) Koehne','Taxus baccata var. brevifolia','(Nuttall) Koehne','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9401','','','Taxus canadensis Marshall','Taxus canadensis','Marshall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22095','','','Taxus baccata subsp. canadensis (Marshall) Pilger','Taxus baccata subsp. canadensis','(Marshall) Pilger','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22096','','','Taxus baccata var. minor Michaux','Taxus baccata var. minor','Michaux','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22097','','','Taxus minor (Michaux) Britton','Taxus minor','(Michaux) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22098','','','Taxus procumbens Loddiges ex Loudon','Taxus procumbens','Loddiges ex Loudon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('119','','','Cupressaceae Gray','Cupressaceae','Gray','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1757','','','Thuja Linnaeus','Thuja','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4711','','','Thuja occidentalis Linnaeus','Thuja occidentalis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4712','','','Thuja plicata Donn ex D. Don','Thuja plicata','Donn ex D. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14925','','','Thuja gigantea Nuttall','Thuja gigantea','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14924','','','Thuja occidentalis var. plicata (Donn ex D. Don) Loudon ex Hoopes','Thuja occidentalis var. plicata','(Donn ex D. Don) Loudon ex Hoopes','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14926','','','Thuja menziesii Douglas ex Endlicher','Thuja menziesii','Douglas ex Endlicher','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1299','','','Juniperus Linnaeus','Juniperus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33513','','','Juniperus sect. Sabina Spach','Juniperus sect. Sabina','Spach','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4707','','','Juniperus scopulorum Sargent','Juniperus scopulorum','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28047','','','Juniperus virginiana var. montana Vasey','Juniperus virginiana var. montana','Vasey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28046','','','Juniperus excelsa Pursh nom. illeg.','Juniperus excelsa','Pursh nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28049','','','Juniperus scopulorum subsp. scopulorum (Sargent) A.E. Murray','Juniperus scopulorum subsp. scopulorum','(Sargent) A.E. Murray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28048','','','Juniperus virginiana var. scopulorum (Sargent) Lemmon','Juniperus virginiana var. scopulorum','(Sargent) Lemmon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28054','','','Juniperus virginiana subsp. scopulorum (Sargent) A.E. Murray','Juniperus virginiana subsp. scopulorum','(Sargent) A.E. Murray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28050','','','Juniperus occidentalis var. pleiosperma Engelmann','Juniperus occidentalis var. pleiosperma','Engelmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28053','','','Juniperus scopulorum var. columnaris Fassett','Juniperus scopulorum var. columnaris','Fassett','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28052','','','Juniperus fassettii B. Boivin','Juniperus fassettii','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22099','','','Sabina scopulorum (Sargent) Rydberg','Sabina scopulorum','(Sargent) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4706','','','Juniperus sabina Michaux','Juniperus sabina','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4709','','','Juniperus virginiana Linnaeus','Juniperus virginiana','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4708','','','Juniperus virginiana var. virginiana Linnaeus','Juniperus virginiana var. virginiana','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28045','','','Juniperus virginiana var. ambigens Fassett','Juniperus virginiana var. ambigens','Fassett','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22100','','','Sabina virginiana (Linnaeus) Antoine','Sabina virginiana','(Linnaeus) Antoine','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14923','','','Juniperus virginiana subsp. crebra (Fernald & Griscom) A.E. Murray','Juniperus virginiana subsp. crebra','(Fernald & Griscom) A.E. Murray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14922','','','Juniperus virginiana var. crebra Fernald & Griscom','Juniperus virginiana var. crebra','Fernald & Griscom','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4705','','','Juniperus horizontalis Moench','Juniperus horizontalis','Moench','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28043','','','Juniperus sabina var. procumbens Pursh','Juniperus sabina var. procumbens','Pursh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28042','','','Sabina prostrata (Persoon) Antoine','Sabina prostrata','(Persoon) Antoine','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28044','','','Juniperus sabina var. humilis Hooker','Juniperus sabina var. humilis','Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28040','','','Sabina horizontalis (Moench) Rydberg','Sabina horizontalis','(Moench) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28041','','','Juniperus virginiana var. prostrata (Persoon) Torrey','Juniperus virginiana var. prostrata','(Persoon) Torrey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14921','','','Juniperus prostrata Persoon','Juniperus prostrata','Persoon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4710','','','Juniperus × fassettii B. Boivin','Juniperus × fassettii','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28051','','','Juniperus scopulorum var. patens Fassett','Juniperus scopulorum var. patens','Fassett','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9715','','','Juniperus maritima R.P. Adams','Juniperus maritima','R.P. Adams','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33512','','','Juniperus sect. Juniperus Linnaeus','Juniperus sect. Juniperus','Linnaeus','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4702','','','Juniperus communis Linnaeus','Juniperus communis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4703','','','Juniperus communis var. megistocarpa Fernald & H. St.John','Juniperus communis var. megistocarpa','Fernald & H. St.John','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14914','','','Juniperus communis subsp. megistocarpa (Fernald & H. St.John) Silba','Juniperus communis subsp. megistocarpa','(Fernald & H. St.John) Silba','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4704','','','Juniperus communis var. saxatilis Pallas','Juniperus communis var. saxatilis','Pallas','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28033','','','Juniperus sibirica Burgsdorff','Juniperus sibirica','Burgsdorff','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28038','','','Juniperus montana (Aiton) Lindley & Gordon','Juniperus montana','(Aiton) Lindley & Gordon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28039','','','Juniperus communis subsp. pygmaea (K. Koch) Imkhanitskaya','Juniperus communis subsp. pygmaea','(K. Koch) Imkhanitskaya','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28034','','','Juniperus nana Willdenow','Juniperus nana','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28035','','','Juniperus alpina Gray','Juniperus alpina','Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28036','','','Juniperus nana var. alpina (Suter) Endlicher','Juniperus nana var. alpina','(Suter) Endlicher','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28037','','','Juniperus pygmaea K. Koch','Juniperus pygmaea','K. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14916','','','Juniperus communis var. alpina Suter','Juniperus communis var. alpina','Suter','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14917','','','Juniperus communis var. nana (Willdenow) Baumgarten','Juniperus communis var. nana','(Willdenow) Baumgarten','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14915','','','Juniperus communis var. montana Aiton','Juniperus communis var. montana','Aiton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14920','','','Juniperus communis subsp. saxatilis (Pallas) A.E. Murray','Juniperus communis subsp. saxatilis','(Pallas) A.E. Murray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14918','','','Juniperus communis subsp. alpina (Suter) Celakovsky','Juniperus communis subsp. alpina','(Suter) Celakovsky','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14919','','','Juniperus communis subsp. nana (Willdenow) Syme','Juniperus communis subsp. nana','(Willdenow) Syme','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9865','','','Juniperus communis var. charlottensis R.P. Adams','Juniperus communis var. charlottensis','R.P. Adams','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32817','','','Juniperus communis var. kelleyi R.P. Adams','Juniperus communis var. kelleyi','R.P. Adams','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4701','','','Juniperus communis var. depressa Pursh','Juniperus communis var. depressa','Pursh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28032','','','Juniperus communis var. jackii Rehder','Juniperus communis var. jackii','Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14912','','','Juniperus canadensis Loddiges ex Burgsdorff','Juniperus canadensis','Loddiges ex Burgsdorff','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14913','','','Juniperus depressa (Pursh) Rafinesque','Juniperus depressa','(Pursh) Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14910','','','Juniperus communis subsp. depressa (Pursh) Franco','Juniperus communis subsp. depressa','(Pursh) Franco','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14911','','','Juniperus communis var. canadensis (Loddiges ex Burgsdorff) Loudon','Juniperus communis var. canadensis','(Loddiges ex Burgsdorff) Loudon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('979','','','Callitropsis Oersted','Callitropsis','Oersted','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4700','','','Callitropsis nootkatensis (D. Don) Oersted ex D.P. Little','Callitropsis nootkatensis','(D. Don) Oersted ex D.P. Little','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14908','','','Chamaecyparis nootkatensis (D. Don) Spach','Chamaecyparis nootkatensis','(D. Don) Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14909','','','Xanthocyparis nootkatensis (D. Don) Farjon & D. Harder','Xanthocyparis nootkatensis','(D. Don) Farjon & D. Harder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14907','','','Cupressus nootkatensis D. Don','Cupressus nootkatensis','D. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33','','','Polypodiidae Cronquist, Takhtajan & Zimmermann','Polypodiidae','Cronquist, Takhtajan & Zimmermann','SUBCLASS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('56','','','Polypodiales Link','Polypodiales','Link','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('179','','','Onocleaceae Pichi Sermolli','Onocleaceae','Pichi Sermolli','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1398','','','Matteuccia Todaro','Matteuccia','Todaro','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21998','','','Matteuccia pensylvanica (Willdenow) Raymond','Matteuccia pensylvanica','(Willdenow) Raymond','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21997','','','Struthiopteris pensylvanica Willdenow','Struthiopteris pensylvanica','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15803','','','Pteretis pensylvanica (Willdenow) Fernald','Pteretis pensylvanica','(Willdenow) Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15801','','','Onoclea struthiopteris var. pensylvanica (Willdenow) B. Boivin','Onoclea struthiopteris var. pensylvanica','(Willdenow) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15800','','','Matteuccia struthiopteris var. pubescens (Terry) Clute','Matteuccia struthiopteris var. pubescens','(Terry) Clute','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5421','','','Matteuccia struthiopteris var. pensylvanica (Willdenow) C.V. Morton','Matteuccia struthiopteris var. pensylvanica','(Willdenow) C.V. Morton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1479','','','Onoclea Linnaeus','Onoclea','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5423','','','Onoclea sensibilis Linnaeus','Onoclea sensibilis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('198','','','Polypodiaceae J. Presl & C. Presl','Polypodiaceae','J. Presl & C. Presl','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('375','','','Polypodioideae B.K. Nayar','Polypodioideae','B.K. Nayar','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('656','','','Polypodieae Hooker & Lindley ex Duby','Polypodieae','Hooker & Lindley ex Duby','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1579','','','Polypodium Linnaeus','Polypodium','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8235','','','Polypodium amorphum Suksdorf','Polypodium amorphum','Suksdorf','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22000','','','Polypodium montense F.A. Lang','Polypodium montense','F.A. Lang','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8239','','','Polypodium scouleri Hooker & Greville','Polypodium scouleri','Hooker & Greville','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8238','','','Polypodium hesperium Maxon','Polypodium hesperium','Maxon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22001','','','Polypodium vulgare var. hesperium (Maxon) A. Nelson & J.F. Macbride','Polypodium vulgare var. hesperium','(Maxon) A. Nelson & J.F. Macbride','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19282','','','Polypodium vulgare var. columbianum Gilbert','Polypodium vulgare var. columbianum','Gilbert','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19283','','','Polypodium vulgare subsp. columbianum (Gilbert) Hultén','Polypodium vulgare subsp. columbianum','(Gilbert) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8237','','','Polypodium glycyrrhiza D.C. Eaton','Polypodium glycyrrhiza','D.C. Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19281','','','Polypodium vulgare var. occidentale Hooker','Polypodium vulgare var. occidentale','Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8236','','','Polypodium appalachianum Haufler & Windham','Polypodium appalachianum','Haufler & Windham','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26143','','','Polypodium × incognitum Cusick','Polypodium × incognitum','Cusick','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8240','','','Polypodium sibiricum Siplivinski','Polypodium sibiricum','Siplivinski','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8241','','','Polypodium virginianum Linnaeus','Polypodium virginianum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26471','','','Polypodium virginianum var. virginianum Linnaeus','Polypodium virginianum var. virginianum','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22003','','','Polypodium vinlandicum Á. Löve & D. Löve','Polypodium vinlandicum','Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22002','','','Polypodium vulgare var. americanum Hooker','Polypodium vulgare var. americanum','Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19285','','','Polypodium vulgare var. virginianum (Linnaeus) D.C. Eaton','Polypodium vulgare var. virginianum','(Linnaeus) D.C. Eaton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19286','','','Polypodium vulgare subsp. virginianum (Linnaeus) Hultén','Polypodium vulgare subsp. virginianum','(Linnaeus) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('203','','','Pteridaceae E.D.M. Kirchner','Pteridaceae','E.D.M. Kirchner','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('287','','','Cheilanthoideae W.C. Schieh','Cheilanthoideae','W.C. Schieh','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1516','','','Pellaea Link','Pellaea','Link','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30803','','','Pellaea breweri D.C. Eaton','Pellaea breweri','D.C. Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8391','','','Pellaea atropurpurea (Linnaeus) Link','Pellaea atropurpurea','(Linnaeus) Link','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25568','','','Pellaea atropurpurea var. atropurpurea (Linnaeus) Link','Pellaea atropurpurea var. atropurpurea','(Linnaeus) Link','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22008','','','Pteris atropurpurea Linnaeus','Pteris atropurpurea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19475','','','Pellaea atropurpurea var. cristata Trelease','Pellaea atropurpurea var. cristata','Trelease','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8392','','','Pellaea gastonyi Windham','Pellaea gastonyi','Windham','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8394','','','Pellaea glabella Mettenius ex Kuhn','Pellaea glabella','Mettenius ex Kuhn','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8395','','','Pellaea glabella subsp. occidentalis (E.E. Nelson) Windham','Pellaea glabella subsp. occidentalis','(E.E. Nelson) Windham','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19481','','','Pellaea pumila Rydberg','Pellaea pumila','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19480','','','Pellaea occidentalis (E.E. Nelson) Rydberg','Pellaea occidentalis','(E.E. Nelson) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19479','','','Pellaea glabella var. occidentalis (E.E. Nelson) Butters','Pellaea glabella var. occidentalis','(E.E. Nelson) Butters','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19478','','','Pellaea glabella var. nana (Richardson) Cody','Pellaea glabella var. nana','(Richardson) Cody','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19477','','','Pellaea atropurpurea var. occidentalis elson E.E. elson','Pellaea atropurpurea var. occidentalis elson','E.E. elson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8396','','','Pellaea glabella subsp. simplex (Butters) Á. Löve & D. Löve','Pellaea glabella subsp. simplex','(Butters) Á. Löve & D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19485','','','Pellaea suksdorfiana Butters','Pellaea suksdorfiana','Butters','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19484','','','Pellaea occidentalis subsp. simplex (Butters) Gastony','Pellaea occidentalis subsp. simplex','(Butters) Gastony','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19483','','','Pellaea atropurpurea var. simplex (Butters) C.V. Morton','Pellaea atropurpurea var. simplex','(Butters) C.V. Morton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19482','','','Pellaea glabella var. simplex Butters','Pellaea glabella var. simplex','Butters','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8393','','','Pellaea glabella subsp. glabella Mettenius ex Kuhn','Pellaea glabella subsp. glabella','Mettenius ex Kuhn','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25569','','','Pellaea glabella var. glabella Mettenius ex Kuhn','Pellaea glabella var. glabella','Mettenius ex Kuhn','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19476','','','Pellaea atropurpurea var. bushii Mackenzie','Pellaea atropurpurea var. bushii','Mackenzie','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('869','','','Aspidotis (Nuttall ex Hooker) Copeland','Aspidotis','(Nuttall ex Hooker) Copeland','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8384','','','Aspidotis densa (Brackenridge) Lellinger','Aspidotis densa','(Brackenridge) Lellinger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26381','','','Cryptogramma crispa var. castanea Farwell','Cryptogramma crispa var. castanea','Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26380','','','Cheilanthes densa (Brackenridge) H. St.John','Cheilanthes densa','(Brackenridge) H. St.John','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26379','','','Allosorus densus (Brackenridge) Kuntze','Allosorus densus','(Brackenridge) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26378','','','Cryptogramma densa (Brackenridge) Diels','Cryptogramma densa','(Brackenridge) Diels','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19468','','','Pellaea densa (Brackenridge) Hooker','Pellaea densa','(Brackenridge) Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19469','','','Cheilanthes siliquosa Maxon','Cheilanthes siliquosa','Maxon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19470','','','Onychium densum Brackenridge','Onychium densum','Brackenridge','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1519','','','Pentagramma Yatskievych, Windham & E. Wollenweber','Pentagramma','Yatskievych, Windham & E. Wollenweber','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8398','','','Pentagramma triangularis (Kaulfuss) Yatskievych, Windham & E. Wollenweber','Pentagramma triangularis','(Kaulfuss) Yatskievych, Windham & E. Wollenweber','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8397','','','Pentagramma triangularis subsp. triangularis (Kaulfuss) Yatskievych, Windham & E. Wollenweber','Pentagramma triangularis subsp. triangularis','(Kaulfuss) Yatskievych, Windham & E. Wollenweber','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22009','','','Gymnogramma triangularis Kaulfuss','Gymnogramma triangularis','Kaulfuss','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19486','','','Pityrogramma triangularis (Kaulfuss) Maxon','Pityrogramma triangularis','(Kaulfuss) Maxon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28387','','','Myriopteris Fée','Myriopteris','Fée','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28388','','','Myriopteris gracilis Fée','Myriopteris gracilis','Fée','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28389','','','Cheilanthes gracilis (Fée) Mettenius ex Riehl nom. illeg.','Cheilanthes gracilis','(Fée) Mettenius ex Riehl nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28390','','','Myriopteris lanuginosa J. Smith nom. illeg.','Myriopteris lanuginosa','J. Smith nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8385','','','Cheilanthes feei T. Moore','Cheilanthes feei','T. Moore','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22005','','','Myriopteris gracillima (D.C. Eaton) J. Smith','Myriopteris gracillima','(D.C. Eaton) J. Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8386','','','Cheilanthes gracillima D.C. Eaton','Cheilanthes gracillima','D.C. Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('251','','','Vittarioideae (C. Presl) Crabbe','Vittarioideae','(C. Presl) Crabbe','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('778','','','Adiantum Linnaeus','Adiantum','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8382','','','Adiantum pedatum Linnaeus','Adiantum pedatum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26229','','','Adiantum pedatum subsp. pedatum Linnaeus','Adiantum pedatum subsp. pedatum','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26230','','','Adiantum pedatum var. pedatum Linnaeus','Adiantum pedatum var. pedatum','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8383','','','Adiantum viridimontanum Paris','Adiantum viridimontanum','Paris','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8381','','','Adiantum capillus-veneris Linnaeus','Adiantum capillus-veneris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8380','','','Adiantum aleuticum (Ruprecht) C.A. Paris','Adiantum aleuticum','(Ruprecht) C.A. Paris','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25140','','','Adiantum aleuticum var. aleuticum (Ruprecht) C.A. Paris','Adiantum aleuticum var. aleuticum','(Ruprecht) C.A. Paris','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19464','','','Adiantum pedatum var. aleuticum Ruprecht','Adiantum pedatum var. aleuticum','Ruprecht','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19465','','','Adiantum pedatum subsp. aleuticum (Ruprecht) Calder & Roy L. Taylor','Adiantum pedatum subsp. aleuticum','(Ruprecht) Calder & Roy L. Taylor','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19466','','','Adiantum pedatum subsp. calderi Cody','Adiantum pedatum subsp. calderi','Cody','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25139','','','Adiantum aleuticum var. subpumilum (W.H. Wagner) E.R. Alverson','Adiantum aleuticum var. subpumilum','(W.H. Wagner) E.R. Alverson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22004','','','Adiantum pedatum subsp. subpumilum (W.H. Wagner) Lellinger','Adiantum pedatum subsp. subpumilum','(W.H. Wagner) Lellinger','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19467','','','Adiantum pedatum var. subpumilum W.H. Wagner & Boydston','Adiantum pedatum var. subpumilum','W.H. Wagner & Boydston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31530','','','Cryptogrammoideae S. Lindsay','Cryptogrammoideae','S. Lindsay','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1055','','','Cryptogramma R. Brown','Cryptogramma','R. Brown','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8387','','','Cryptogramma acrostichoides R. Brown','Cryptogramma acrostichoides','R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19471','','','Cryptogramma crispa subsp. acrostichoides (R. Brown) Hultén','Cryptogramma crispa subsp. acrostichoides','(R. Brown) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19472','','','Cryptogramma crispa var. acrostichoides (R. Brown) C.B. Clarke','Cryptogramma crispa var. acrostichoides','(R. Brown) C.B. Clarke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8389','','','Cryptogramma sitchensis (Ruprecht) T. Moore','Cryptogramma sitchensis','(Ruprecht) T. Moore','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22007','','','Allosorus sitchensis Ruprecht','Allosorus sitchensis','Ruprecht','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19473','','','Cryptogramma acrostichoides var. sitchensis (Ruprecht) C. Christensen','Cryptogramma acrostichoides var. sitchensis','(Ruprecht) C. Christensen','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19474','','','Cryptogramma crispa var. sitchensis (Ruprecht) C. Christensen','Cryptogramma crispa var. sitchensis','(Ruprecht) C. Christensen','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8388','','','Cryptogramma cascadensis E.R. Alverson','Cryptogramma cascadensis','E.R. Alverson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8390','','','Cryptogramma stelleri (S.G. Gmelin) Prantl','Cryptogramma stelleri','(S.G. Gmelin) Prantl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22006','','','Pteris stelleri S.G. Gmelin','Pteris stelleri','S.G. Gmelin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('125','','','Dryopteridaceae Herter','Dryopteridaceae','Herter','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24668','','','Dryopteridoideae B.K. Nayar','Dryopteridoideae','B.K. Nayar','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1829','','','× Dryostichum W.H. Wagner','× Dryostichum','W.H. Wagner','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5454','','','× Dryostichum singulare W.H. Wagner','× Dryostichum singulare','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1581','','','Polystichum Roth','Polystichum','Roth','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5433','','','Polystichum lonchitis (Linnaeus) Roth','Polystichum lonchitis','(Linnaeus) Roth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26266','','','Aspidium lonchitis (Linnaeus) Swartz','Aspidium lonchitis','(Linnaeus) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22053','','','Polypodium lonchitis Linnaeus','Polypodium lonchitis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5434','','','Polystichum munitum (Kaulfuss) C. Presl','Polystichum munitum','(Kaulfuss) C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22054','','','Aspidium munitum Kaulfuss','Aspidium munitum','Kaulfuss','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5435','','','Polystichum scopulinum (D.C. Eaton) Maxon','Polystichum scopulinum','(D.C. Eaton) Maxon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22055','','','Aspidium aculeatum var. scopulinum D.C. Eaton','Aspidium aculeatum var. scopulinum','D.C. Eaton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15811','','','Polystichum mohrioides var. scopulinum (Eaton) Fernald','Polystichum mohrioides var. scopulinum','(Eaton) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5436','','','Polystichum setigerum (C.B. Presl) C.B. Presl','Polystichum setigerum','(C.B. Presl) C.B. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22057','','','Polystichum braunii subsp. alaskense (Maxon) Calder & Roy L. Taylor','Polystichum braunii subsp. alaskense','(Maxon) Calder & Roy L. Taylor','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22056','','','Nephrodium setigerum C.B. Presl','Nephrodium setigerum','C.B. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22058','','','Polystichum braunii var. alaskense (Maxon) Hultén','Polystichum braunii var. alaskense','(Maxon) Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5437','','','Polystichum × hagenahii Cody','Polystichum × hagenahii','Cody','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5438','','','Polystichum × potteri Barrington','Polystichum × potteri','Barrington','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5429','','','Polystichum imbricans (D.C. Eaton) D.H. Wagner','Polystichum imbricans','(D.C. Eaton) D.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5428','','','Polystichum imbricans subsp. imbricans (D.C. Eaton) D.H. Wagner','Polystichum imbricans subsp. imbricans','(D.C. Eaton) D.H. Wagner','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22060','','','Polystichum munitum subsp. imbricans (D.C. Eaton) Munz','Polystichum munitum subsp. imbricans','(D.C. Eaton) Munz','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22059','','','Aspidium munitum var. imbricans D.C. Eaton','Aspidium munitum var. imbricans','D.C. Eaton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15808','','','Polystichum munitum subsp. nudatum (Kaulfuss) K. Presl','Polystichum munitum subsp. nudatum','(Kaulfuss) K. Presl','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15809','','','Polystichum munitum var. imbricans (D.C. Eaton) Maxon','Polystichum munitum var. imbricans','(D.C. Eaton) Maxon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5424','','','Polystichum acrostichoides (Michaux) Schott','Polystichum acrostichoides','(Michaux) Schott','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31567','','','Aspidium acrostichoides var. incisum A. Gray','Aspidium acrostichoides var. incisum','A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31467','','','Aspidium acrostichoides (Michaux) Swartz','Aspidium acrostichoides','(Michaux) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22048','','','Nephrodium acrostichoides Michaux','Nephrodium acrostichoides','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15804','','','Polystichum acrostichoides var. acrostichoides (Michaux) Schott','Polystichum acrostichoides var. acrostichoides','(Michaux) Schott','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5425','','','Polystichum andersonii M. Hopkins','Polystichum andersonii','M. Hopkins','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22049','','','Polystichum braunii subsp. andersonii (M. Hopkins) Calder & Roy L. Taylor','Polystichum braunii subsp. andersonii','(M. Hopkins) Calder & Roy L. Taylor','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15805','','','Polystichum braunii var. andersonii (Hopkins) Calder & Taylor','Polystichum braunii var. andersonii','(Hopkins) Calder & Taylor','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5426','','','Polystichum braunii (Spenner) Fée','Polystichum braunii','(Spenner) Fée','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31888','','','Polystichum aculeatum var. braunii (Spenner) Davenport','Polystichum aculeatum var. braunii','(Spenner) Davenport','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22050','','','Aspidium braunii Spenner','Aspidium braunii','Spenner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15807','','','Polystichum braunii subsp. purshii (Fernald) Calder & Roy L. Taylor','Polystichum braunii subsp. purshii','(Fernald) Calder & Roy L. Taylor','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15806','','','Polystichum braunii var. purshii Fernald','Polystichum braunii var. purshii','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5427','','','Polystichum californicum (D.C. Eaton) Diels','Polystichum californicum','(D.C. Eaton) Diels','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22051','','','Aspidium californicum D.C. Eaton','Aspidium californicum','D.C. Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22052','','','Polystichum aculeatum var. californicum (D.C. Eaton) Jepson','Polystichum aculeatum var. californicum','(D.C. Eaton) Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5430','','','Polystichum kruckebergii W.H. Wagner','Polystichum kruckebergii','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5431','','','Polystichum kwakiutlii D.H. Wagner','Polystichum kwakiutlii','D.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5432','','','Polystichum lemmonii Underwood','Polystichum lemmonii','Underwood','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15810','','','Polystichum mohrioides var. lemmonii (Underwood) Fernald','Polystichum mohrioides var. lemmonii','(Underwood) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1112','','','Dryopteris Adanson','Dryopteris','Adanson','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5411','','','Dryopteris × triploidea Wherry','Dryopteris × triploidea','Wherry','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28950','','','Nephrodium spinulosum var. fructuosum Gilbert','Nephrodium spinulosum var. fructuosum','Gilbert','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28949','','','Dryopteris intermedia var. fructuosa (Gilbert) Wherry','Dryopteris intermedia var. fructuosa','(Gilbert) Wherry','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15789','','','Dryopteris austriaca var. fructuosa (Gilbert) C.V. Morton','Dryopteris austriaca var. fructuosa','(Gilbert) C.V. Morton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15788','','','Dryopteris spinulosa var. fructuosa (Gilbert) Trudell','Dryopteris spinulosa var. fructuosa','(Gilbert) Trudell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5410','','','Dryopteris × slossoniae (Davenport) Wherry ex Lellinger','Dryopteris × slossoniae','(Davenport) Wherry ex Lellinger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33561','','','Nephrodium cristatum var. slossoniae Davenport','Nephrodium cristatum var. slossoniae','Davenport','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33560','','','Dryopteris clintoniana var. slossoniae (Davenport) Burnham','Dryopteris clintoniana var. slossoniae','(Davenport) Burnham','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5393','','','Dryopteris filix-mas (Linnaeus) Schott','Dryopteris filix-mas','(Linnaeus) Schott','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5392','','','Dryopteris filix-mas subsp. brittonii Fraser-Jenkins & Widen','Dryopteris filix-mas subsp. brittonii','Fraser-Jenkins & Widen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9756','','','Dryopteris filix-mas subsp. filix-mas (Linnaeus) Schott','Dryopteris filix-mas subsp. filix-mas','(Linnaeus) Schott','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25508','','','Filix filix-mas (Linnaeus) Farwell','Filix filix-mas','(Linnaeus) Farwell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25509','','','Lastrea filix-mas (Linnaeus) C. Presl','Lastrea filix-mas','(Linnaeus) C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25507','','','Thelypteris filix-mas (Linnaeus) Nieuwland','Thelypteris filix-mas','(Linnaeus) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25510','','','Nephrodium filix-mas (Linnaeus) Richard','Nephrodium filix-mas','(Linnaeus) Richard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25511','','','Polystichum filix-mas (Linnaeus) Roth','Polystichum filix-mas','(Linnaeus) Roth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26265','','','Aspidium filix-mas (Linnaeus) Swartz','Aspidium filix-mas','(Linnaeus) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22069','','','Polypodium filix-mas Linnaeus','Polypodium filix-mas','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28392','','','Dryopteris campyloptera × Dryopteris marginalis','Dryopteris campyloptera × Dryopteris marginalis','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33552','','','Dryopteris arguta (Kaulfuss) Watt','Dryopteris arguta','(Kaulfuss) Watt','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33553','','','Aspidium rigidum var. argutum (Kaulfuss) D.C. Eaton','Aspidium rigidum var. argutum','(Kaulfuss) D.C. Eaton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22061','','','Aspidium argutum Kaulfuss','Aspidium argutum','Kaulfuss','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5383','','','Dryopteris arguta (Kaulfuss) Maxon nom. illeg.','Dryopteris arguta','(Kaulfuss) Maxon nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28522','','','Dryopteris carthusiana × Dryopteris cristata','Dryopteris carthusiana × Dryopteris cristata','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5412','','','Dryopteris × uliginosa','Dryopteris × uliginosa','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5403','','','Dryopteris × boottii (Tuckerman) Underwood','Dryopteris × boottii','(Tuckerman) Underwood','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33554','','','Thelypteris × boottii (Tuckerman) Nieuwland','Thelypteris × boottii','(Tuckerman) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30600','','','Aspidium × boottii Tuckerman','Aspidium × boottii','Tuckerman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31263','','','Aspidium spinulosum var. boottii A. Gray','Aspidium spinulosum var. boottii','A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5402','','','Dryopteris × benedictii (Farwell) Wherry','Dryopteris × benedictii','(Farwell) Wherry','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5405','','','Dryopteris × burgessii B. Boivin','Dryopteris × burgessii','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5404','','','Dryopteris × brathaica Fraser-Jenkins & Reichstein','Dryopteris × brathaica','Fraser-Jenkins & Reichstein','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5407','','','Dryopteris × mickelii Peck','Dryopteris × mickelii','Peck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5406','','','Dryopteris × dowellii (Farwell) Wherry','Dryopteris × dowellii','(Farwell) Wherry','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5409','','','Dryopteris × pittsfordensis Slosson','Dryopteris × pittsfordensis','Slosson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5408','','','Dryopteris × neowherryi W.H. Wagner','Dryopteris × neowherryi','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5384','','','Dryopteris campyloptera (Kunze) Clarkson','Dryopteris campyloptera','(Kunze) Clarkson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15775','','','Dryopteris austriaca p.p. (Jacquin) Woynar ex Schinz & Thellung p.p.','Dryopteris austriaca p.p.','(Jacquin) Woynar ex Schinz & Thellung p.p.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15774','','','Dryopteris spinulosa var. americana p.p. (Fischer ex Kunze) Fernald p.p.','Dryopteris spinulosa var. americana p.p.','(Fischer ex Kunze) Fernald p.p.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15773','','','Aspidium campylopterum Kunze','Aspidium campylopterum','Kunze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5400','','','Dryopteris marginalis (Linnaeus) A. Gray','Dryopteris marginalis','(Linnaeus) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28371','','','Nephrodium marginale (Linnaeus) Michaux','Nephrodium marginale','(Linnaeus) Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28582','','','Filix-mas marginalis (Linnaeus) Farwell','Filix-mas marginalis','(Linnaeus) Farwell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28583','','','Filix marginalis (Linnaeus) Farwell','Filix marginalis','(Linnaeus) Farwell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28580','','','Polystichum marginale (Linnaeus) Keyserling','Polystichum marginale','(Linnaeus) Keyserling','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28581','','','Lastrea marginalis (Linnaeus) C. Presl','Lastrea marginalis','(Linnaeus) C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28584','','','Aspidium filix-mas var. marginale (Linnaeus) Christ','Aspidium filix-mas var. marginale','(Linnaeus) Christ','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28578','','','Dryopteris marginalis var. elegans (J. Robinson) Carhart','Dryopteris marginalis var. elegans','(J. Robinson) Carhart','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28579','','','Nephrodium marginale var. elegans (J. Robinson) Gilbert','Nephrodium marginale var. elegans','(J. Robinson) Gilbert','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28577','','','Aspidium marginale var. elegans J. Robinson','Aspidium marginale var. elegans','J. Robinson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26267','','','Aspidium marginale (Linnaeus) Swartz','Aspidium marginale','(Linnaeus) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22068','','','Polypodium marginale Linnaeus','Polypodium marginale','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15787','','','Thelypteris marginalis (Linnaeus) Nieuwland','Thelypteris marginalis','(Linnaeus) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5401','','','Dryopteris × algonquinensis D.M. Britton','Dryopteris × algonquinensis','D.M. Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5399','','','Dryopteris intermedia × Dryopteris marginalis','Dryopteris intermedia × Dryopteris marginalis','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5397','','','Dryopteris goldieana × Dryopteris intermedia','Dryopteris goldieana × Dryopteris intermedia','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5398','','','Dryopteris intermedia (Muhlenberg ex Willdenow) A. Gray','Dryopteris intermedia','(Muhlenberg ex Willdenow) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34116','','','Dryopteris intermedia subsp. intermedia (Muhlenberg ex Willdenow) A. Gray','Dryopteris intermedia subsp. intermedia','(Muhlenberg ex Willdenow) A. Gray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33273','','','Aspidium spinulosum var. intermedium D.C. Eaton','Aspidium spinulosum var. intermedium','D.C. Eaton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25652','','','Thelypteris spinulosa var. intermedia (Muhlenberg ex Willdenow) Nieuwland','Thelypteris spinulosa var. intermedia','(Muhlenberg ex Willdenow) Nieuwland','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22067','','','Aspidium intermedium Muhlenberg ex Willdenow','Aspidium intermedium','Muhlenberg ex Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15786','','','Dryopteris austriaca var. intermedia (Muhlenberg ex Willdenow) C.V. Morton','Dryopteris austriaca var. intermedia','(Muhlenberg ex Willdenow) C.V. Morton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15785','','','Dryopteris spinulosa var. intermedia (Muhlenberg ex Willdenow) Underwood','Dryopteris spinulosa var. intermedia','(Muhlenberg ex Willdenow) Underwood','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5395','','','Dryopteris fragrans (Linnaeus) Schott','Dryopteris fragrans','(Linnaeus) Schott','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33433','','','Nephrodium fragrans var. remotiuscula Komarov','Nephrodium fragrans var. remotiuscula','Komarov','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30602','','','Aspidium fragrans (Linnaeus) Swartz','Aspidium fragrans','(Linnaeus) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28567','','','Dryopteris fragrans var. fragrans (Linnaeus) Schott','Dryopteris fragrans var. fragrans','(Linnaeus) Schott','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28571','','','Nephrodium fragrans (Linnaeus) Richardson','Nephrodium fragrans','(Linnaeus) Richardson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28570','','','Polystichum fragrans (Linnaeus) Roth','Polystichum fragrans','(Linnaeus) Roth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28569','','','Thelypteris fragrans var. hookeriana Fernald','Thelypteris fragrans var. hookeriana','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28568','','','Dryopteris fragrans var. hookeriana (Fernald) A. Prince ex Weatherby','Dryopteris fragrans var. hookeriana','(Fernald) A. Prince ex Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28574','','','Filix fragrans (Linnaeus) Farwell','Filix fragrans','(Linnaeus) Farwell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28575','','','Filix aquilonaris (Maxon) Farwell','Filix aquilonaris','(Maxon) Farwell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28572','','','Lastrea fragrans (Linnaeus) C. Presl','Lastrea fragrans','(Linnaeus) C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28573','','','Filix-mas fragrans (Linnaeus) Farwell','Filix-mas fragrans','(Linnaeus) Farwell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28576','','','Dryopteris aquilonaris Maxon','Dryopteris aquilonaris','Maxon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26473','','','Nephrodium fragrans (Linnaeus) Desvaux nom. illeg.','Nephrodium fragrans','(Linnaeus) Desvaux nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26472','','','Polystichum fragrans (Linnaeus) Ledebour nom. illeg.','Polystichum fragrans','(Linnaeus) Ledebour nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15783','','','Dryopteris fragrans var. remotiuscula (Komarov) Komarov','Dryopteris fragrans var. remotiuscula','(Komarov) Komarov','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15784','','','Thelypteris fragrans (Linnaeus) Nieuwland','Thelypteris fragrans','(Linnaeus) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15782','','','Polypodium fragrans Linnaeus','Polypodium fragrans','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5396','','','Dryopteris goldieana (Hooker ex Goldie) A. Gray','Dryopteris goldieana','(Hooker ex Goldie) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32203','','','Aspidium americanum Torrey','Aspidium americanum','Torrey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32202','','','Aspidium filix-mas var. goldieanum (Hooker ex Goldie) C. Christensen','Aspidium filix-mas var. goldieanum','(Hooker ex Goldie) C. Christensen','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32201','','','Nephrodium goldieanum (Hooker ex Goldie) Hooker & Greville','Nephrodium goldieanum','(Hooker ex Goldie) Hooker & Greville','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32200','','','Polystichum goldieanum (Hooker ex Goldie) Keyserling','Polystichum goldieanum','(Hooker ex Goldie) Keyserling','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32199','','','Lastrea goldieana (Hooker ex Goldie) C. Presl','Lastrea goldieana','(Hooker ex Goldie) C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32198','','','Filix-mas goldieana (Hooker ex Goldie) Farwell','Filix-mas goldieana','(Hooker ex Goldie) Farwell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32197','','','Filix goldieana (Hooker ex Goldie) Farwell','Filix goldieana','(Hooker ex Goldie) Farwell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26501','','','Thelypteris goldieana (Hooker ex Goldie) Nieuwland','Thelypteris goldieana','(Hooker ex Goldie) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22066','','','Aspidium goldieanum Hooker ex Goldie','Aspidium goldieanum','Hooker ex Goldie','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5391','','','Dryopteris expansa (C. Presl) Fraser-Jenkins & Jermy','Dryopteris expansa','(C. Presl) Fraser-Jenkins & Jermy','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25651','','','Thelypteris spinulosa var. americana (Fischer ex Kunze) Weatherby','Thelypteris spinulosa var. americana','(Fischer ex Kunze) Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23498','','','Aspidium spinulosum var. americanum Fischer ex Kunze','Aspidium spinulosum var. americanum','Fischer ex Kunze','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23497','','','Nephrodium expansum C. Presl','Nephrodium expansum','C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15781','','','Dryopteris dilatata subsp. americana (Fischer ex Kunze) Hultén','Dryopteris dilatata subsp. americana','(Fischer ex Kunze) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15780','','','Dryopteris assimilis S. Walker','Dryopteris assimilis','S. Walker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15774-d3af56a3-cce6-4a25-9c9a-6df573fc9263','','','Dryopteris spinulosa var. americana p.p. (Fischer ex Kunze) Fernald p.p.','Dryopteris spinulosa var. americana p.p.','(Fischer ex Kunze) Fernald p.p.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5394','','','Dryopteris × montgomeryi Fraser-Jenkins & Widen','Dryopteris × montgomeryi','Fraser-Jenkins & Widen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5389','','','Dryopteris clintoniana × Dryopteris cristata','Dryopteris clintoniana × Dryopteris cristata','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5390','','','Dryopteris cristata (Linnaeus) A. Gray','Dryopteris cristata','(Linnaeus) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30601','','','Aspidium cristatum (Linnaeus) Swartz','Aspidium cristatum','(Linnaeus) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28000','','','Dryopteris cristata var. cristata (Linnaeus) A. Gray','Dryopteris cristata var. cristata','(Linnaeus) A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25512','','','Thelypteris cristata (Linnaeus) Nieuwland','Thelypteris cristata','(Linnaeus) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22065','','','Polypodium cristatum Linnaeus','Polypodium cristatum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5387','','','Dryopteris carthusiana (Villars) H.P. Fuchs','Dryopteris carthusiana','(Villars) H.P. Fuchs','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31210','','','Thelypteris spinulosa (O.F. Mueller) Nieuwland','Thelypteris spinulosa','(O.F. Mueller) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22062','','','Polypodium carthusianum Villars','Polypodium carthusianum','Villars','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22063','','','Polypodium spinulosum O.F. Müller','Polypodium spinulosum','O.F. Müller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15777','','','Dryopteris spinulosa var. spinulosa (O.F. Müller) Watt','Dryopteris spinulosa var. spinulosa','(O.F. Müller) Watt','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15778','','','Dryopteris austriaca var. spinulosa (O.F. Müller) Fiori','Dryopteris austriaca var. spinulosa','(O.F. Müller) Fiori','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15776','','','Dryopteris spinulosa (O.F. Müller) Watt','Dryopteris spinulosa','(O.F. Müller) Watt','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5388','','','Dryopteris clintoniana (D.C. Eaton) Dowell','Dryopteris clintoniana','(D.C. Eaton) Dowell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33236','','','Dryopteris clintoniana var. genuina Wherry','Dryopteris clintoniana var. genuina','Wherry','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25506','','','Thelypteris clintoniana (D.C. Eaton) House','Thelypteris clintoniana','(D.C. Eaton) House','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26502','','','Thelypteris cristata var. clintoniana (D.C. Eaton) Weatherby','Thelypteris cristata var. clintoniana','(D.C. Eaton) Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22064','','','Aspidium cristatum var. clintonianum D.C. Eaton','Aspidium cristatum var. clintonianum','D.C. Eaton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15779','','','Dryopteris cristata var. clintoniana (D.C. Eaton) Underwood','Dryopteris cristata var. clintoniana','(D.C. Eaton) Underwood','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5385','','','Dryopteris campyloptera × Dryopteris cristata','Dryopteris campyloptera × Dryopteris cristata','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5386','','','Dryopteris campyloptera × Dryopteris intermedia','Dryopteris campyloptera × Dryopteris intermedia','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('121','','','Dennstaedtiaceae Lotsy','Dennstaedtiaceae','Lotsy','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33491','','','Hypolepidoideae','Hypolepidoideae','','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1600','','','Pteridium Gleditsch ex Scopoli','Pteridium','Gleditsch ex Scopoli','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5349','','','Pteridium aquilinum (Linnaeus) Kuhn','Pteridium aquilinum','(Linnaeus) Kuhn','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32217','','','Pteridium aquilinum subsp. pubescens (Underw.) J.A. Thomson, Mickel & Mehltreter','Pteridium aquilinum subsp. pubescens','(Underw.) J.A. Thomson, Mickel & Mehltreter','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28370','','','Pteridium aquilinum var. lanuginosum (Bongard) Fernald','Pteridium aquilinum var. lanuginosum','(Bongard) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21995','','','Pteris aquilina var. pubescens (Underwood) Clute','Pteris aquilina var. pubescens','(Underwood) Clute','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15740','','','Pteridium aquilinum subsp. lanuginosum (Bongard) Hultén','Pteridium aquilinum subsp. lanuginosum','(Bongard) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5350','','','Pteridium aquilinum var. pubescens Underwood','Pteridium aquilinum var. pubescens','Underwood','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32214','','','Pteridium aquilinum subsp. latiusculum (Desvaux) Hultén ex R.T. Clausen','Pteridium aquilinum subsp. latiusculum','(Desvaux) Hultén ex R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32215','','','Pteridium aquilinum subsp. latiusculum (Desvaux) W.C. Shieh nom. illeg.','Pteridium aquilinum subsp. latiusculum','(Desvaux) W.C. Shieh nom. illeg.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32216','','','Pteridium aquilinum subsp. latiusculum (Desvaux) Hultén nom. inval.','Pteridium aquilinum subsp. latiusculum','(Desvaux) Hultén nom. inval.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21993','','','Pteris latiuscula Desvaux','Pteris latiuscula','Desvaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21994','','','Pteridium latiusculum (Desvaux) Hieronymus ex R.E. Fries','Pteridium latiusculum','(Desvaux) Hieronymus ex R.E. Fries','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15739','','','Pteridium aquilinum var. champlainense B. Boivin','Pteridium aquilinum var. champlainense','B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15738','','','Pteridium aquilinum subsp. latiusculum (Desvaux) C.N. Page nom. illeg.','Pteridium aquilinum subsp. latiusculum','(Desvaux) C.N. Page nom. illeg.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5348','','','Pteridium aquilinum var. latiusculum (Desvaux) Underwood ex A. Heller','Pteridium aquilinum var. latiusculum','(Desvaux) Underwood ex A. Heller','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33490','','','Dennstaedtioidae','Dennstaedtioidae','','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33492','','','Sitobolium Desvaux','Sitobolium','Desvaux','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33493','','','Sitobolium punctilobulum (Michaux) Desvaux','Sitobolium punctilobulum','(Michaux) Desvaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28363','','','Adectum pilosiusculum (Willdenow) Link','Adectum pilosiusculum','(Willdenow) Link','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28362','','','Dicksonia pilosiuscula Willdenow','Dicksonia pilosiuscula','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28360','','','Aspidium punctilobum (Michaux) Swartz','Aspidium punctilobum','(Michaux) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21996','','','Nephrodium punctilobulum Michaux','Nephrodium punctilobulum','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15737','','','Dicksonia punctilobula (Michaux) Kunze','Dicksonia punctilobula','(Michaux) Kunze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5347','','','Dennstaedtia punctilobula (Michaux) T. Moore','Dennstaedtia punctilobula','(Michaux) T. Moore','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('90','','','Aspleniaceae Newman','Aspleniaceae','Newman','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('870','','','Asplenium Linnaeus','Asplenium','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2750','','','Asplenium adulterinum J. Milde','Asplenium adulterinum','J. Milde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2752','','','Asplenium rhizophyllum Linnaeus','Asplenium rhizophyllum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28428','','','Scolopendrium rhizophyllum (Linnaeus) Endlicher','Scolopendrium rhizophyllum','(Linnaeus) Endlicher','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10235','','','Camptosorus rhizophyllus (Linnaeus) Link','Camptosorus rhizophyllus','(Linnaeus) Link','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2751','','','Asplenium platyneuron (Linnaeus) Britton, Sterns & Poggenburgh','Asplenium platyneuron','(Linnaeus) Britton, Sterns & Poggenburgh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28429','','','Asplenium platyneuron var. incisum (E.C. Howe) Robinson','Asplenium platyneuron var. incisum','(E.C. Howe) Robinson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28430','','','Asplenium platyneuron var. serratum (E.S. Miller) Britton, Sterns & Poggenburgh','Asplenium platyneuron var. serratum','(E.S. Miller) Britton, Sterns & Poggenburgh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28431','','','Asplenium ebeneum var. serratum E.S. Miller','Asplenium ebeneum var. serratum','E.S. Miller','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21987','','','Acrostichum platyneuron Linnaeus','Acrostichum platyneuron','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10234','','','Asplenium platyneuron var. bacculum-rubrum (Fernald) Fernald','Asplenium platyneuron var. bacculum-rubrum','(Fernald) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2759','','','Asplenium trichomanes Linnaeus','Asplenium trichomanes','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21988','','','Asplenium melanocaulon Willdenow','Asplenium melanocaulon','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2760','','','Asplenium trichomanes subsp. trichomanes Linnaeus','Asplenium trichomanes subsp. trichomanes','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34096','','','Asplenium quadrivalens (D.E. Meyer) Landolt','Asplenium quadrivalens','(D.E. Meyer) Landolt','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2758','','','Asplenium trichomanes subsp. quadrivalens D.E. Meyer','Asplenium trichomanes subsp. quadrivalens','D.E. Meyer','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2761','','','Asplenium viride Hudson','Asplenium viride','Hudson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26169','','','Asplenium viride var. robustum Goode','Asplenium viride var. robustum','Goode','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10238','','','Asplenium trichomanes-ramosum Linnaeus','Asplenium trichomanes-ramosum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2754','','','Asplenium ruta-muraria Linnaeus','Asplenium ruta-muraria','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2753','','','Asplenium ruta-muraria var. cryptolepis (Fernald) Wherry','Asplenium ruta-muraria var. cryptolepis','(Fernald) Wherry','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10236','','','Asplenium cryptolepis Fernald','Asplenium cryptolepis','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2756','','','Asplenium scolopendrium Linnaeus','Asplenium scolopendrium','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33627','','','Asplenium scolopendrium subsp. scolopendrium Linnaeus','Asplenium scolopendrium subsp. scolopendrium','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2757','','','Asplenium scolopendrium var. scolopendrium Linnaeus','Asplenium scolopendrium var. scolopendrium','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33628','','','Asplenium scolopendrium subsp. americanum (Fernald) N. Heo','Asplenium scolopendrium subsp. americanum','(Fernald) N. Heo','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21985','','','Phyllitis fernaldiana Á. Löve','Phyllitis fernaldiana','Á. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21986','','','Phyllitis japonica subsp. americana (Fernald) Á. Löve & D. Löve','Phyllitis japonica subsp. americana','(Fernald) Á. Löve & D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10237','','','Phyllitis scolopendrium var. americana Fernald','Phyllitis scolopendrium var. americana','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2755','','','Asplenium scolopendrium var. americanum (Fernald) Kartesz & Gandhi','Asplenium scolopendrium var. americanum','(Fernald) Kartesz & Gandhi','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('96','','','Blechnaceae Newman','Blechnaceae','Newman','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31268','','','Woodwardioideae Gasper, V.A.O. Dittrich & Salino','Woodwardioideae','Gasper, V.A.O. Dittrich & Salino','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31270','','','Lorinseria C. Presl','Lorinseria','C. Presl','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12872','','','Lorinseria areolata (Linnaeus) C. Presl','Lorinseria areolata','(Linnaeus) C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32019','','','Woodwardia angustifolia Smith','Woodwardia angustifolia','Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12871','','','Acrostichum areolata Linnaeus','Acrostichum areolata','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12873','','','Woodwardia onocleoides Willdenow','Woodwardia onocleoides','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3734','','','Woodwardia areolata (Linnaeus) T. Moore','Woodwardia areolata','(Linnaeus) T. Moore','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1828','','','Woodwardia Smith','Woodwardia','Smith','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3735','','','Woodwardia fimbriata Smith','Woodwardia fimbriata','Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32020','','','Woodwardia chamissoi Brackenridge','Woodwardia chamissoi','Brackenridge','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32021','','','Woodwardia paradoxa C.H. Wright','Woodwardia paradoxa','C.H. Wright','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31269','','','Anchistea C. Presl','Anchistea','C. Presl','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21992','','','Anchistea virginica (Linnaeus) C. Presl','Anchistea virginica','(Linnaeus) C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21991','','','Blechnum virginicum Linnaeus','Blechnum virginicum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3736','','','Woodwardia virginica (Linnaeus) Smith','Woodwardia virginica','(Linnaeus) Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('293','','','Blechnoideae','Blechnoideae','','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31267','','','Struthiopteris Scopoli','Struthiopteris','Scopoli','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21990','','','Struthiopteris spicant (Linnaeus) Weis','Struthiopteris spicant','(Linnaeus) Weis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31973','','','Blechnum boreale Swartz','Blechnum boreale','Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31974','','','Lomaria spicant (Linnaeus) Desvaux','Lomaria spicant','(Linnaeus) Desvaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31978','','','Blechnum spicant (Linnaeus) Withering nom. illeg.','Blechnum spicant','(Linnaeus) Withering nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28386','','','Blechnum spicant (Linnaeus) Roth','Blechnum spicant','(Linnaeus) Roth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21989','','','Osmunda spicant Linnaeus','Osmunda spicant','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3733','','','Blechnum spicant (Linnaeus) Smith nom. inval.','Blechnum spicant','(Linnaeus) Smith nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26383','','','Athyriaceae Alston','Athyriaceae','Alston','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('874','','','Athyrium Roth','Athyrium','Roth','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22017','','','Athyrium angustum (Willdenow) C. Presl','Athyrium angustum','(Willdenow) C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27557','','','Athyrium angustum var. rubellum (Gilbert) Butters','Athyrium angustum var. rubellum','(Gilbert) Butters','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27558','','','Athyrium filix-femina var. rubellum Gilbert','Athyrium filix-femina var. rubellum','Gilbert','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28515','','','Athyrium angustum var. laurentianum Butters','Athyrium angustum var. laurentianum','Butters','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29170','','','Athyrium angustum var. elatius (Link) Butters','Athyrium angustum var. elatius','(Link) Butters','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29169','','','Athyrium michauxii (Sprengel) Fée','Athyrium michauxii','(Sprengel) Fée','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22018','','','Aspidium angustum Willdenow','Aspidium angustum','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15762','','','Athyrium filix-femina var. michauxii (Sprengel) Farwell','Athyrium filix-femina var. michauxii','(Sprengel) Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15761','','','Athyrium filix-femina subsp. angustum (Willdenow) R.T. Clausen','Athyrium filix-femina subsp. angustum','(Willdenow) R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5372','','','Athyrium filix-femina var. angustum (Willdenow) G. Lawson','Athyrium filix-femina var. angustum','(Willdenow) G. Lawson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23535','','','Athyrium cyclosorum Ruprecht','Athyrium cyclosorum','Ruprecht','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29168','','','Athyrium filix-femina var. sitchense Ruprecht','Athyrium filix-femina var. sitchense','Ruprecht','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23536','','','Athyrium filix-femina subsp. sitchense (Ruprecht) Tzvelev','Athyrium filix-femina subsp. sitchense','(Ruprecht) Tzvelev','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22016','','','Athyrium alpestre var. cyclosorum (Ruprecht) T. Moore','Athyrium alpestre var. cyclosorum','(Ruprecht) T. Moore','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15764','','','Athyrium sitchense Ruprecht','Athyrium sitchense','Ruprecht','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15763','','','Athyrium filix-femina subsp. cyclosorum (Ruprecht) C. Christensen','Athyrium filix-femina subsp. cyclosorum','(Ruprecht) C. Christensen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5374','','','Athyrium filix-femina var. cyclosorum (Ruprecht) T. Moore','Athyrium filix-femina var. cyclosorum','(Ruprecht) T. Moore','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1085','','','Deparia Hooker & Greville','Deparia','Hooker & Greville','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32506','','','Deparia sect. Lunathyrium (Koidzumi) M. Kato','Deparia sect. Lunathyrium','(Koidzumi) M. Kato','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5381','','','Deparia acrostichoides (Swartz) M. Kato','Deparia acrostichoides','(Swartz) M. Kato','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28656','','','Asplenium thelypterioides Michaux','Asplenium thelypterioides','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28658','','','Diplazium thelypterioides (Michaux) Beddome nom. illeg.','Diplazium thelypterioides','(Michaux) Beddome nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28657','','','Diplazium thelypterioides (Michaux) C. Presl','Diplazium thelypterioides','(Michaux) C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22020','','','Athyrium acrostichoides (Swartz) Diels','Athyrium acrostichoides','(Swartz) Diels','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22021','','','Diplazium acrostichoides (Swartz) Butters','Diplazium acrostichoides','(Swartz) Butters','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22019','','','Asplenium acrostichoides Swartz','Asplenium acrostichoides','Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15771','','','Athyrium thelypterioides (Michaux) Desvaux','Athyrium thelypterioides','(Michaux) Desvaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34090','','','Pseudathyrium Newman','Pseudathyrium','Newman','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34091','','','Pseudathyrium alpestre (Hoppe) Newman','Pseudathyrium alpestre','(Hoppe) Newman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34092','','','Pseudathyrium alpestre subsp. americanum (Butters) ined.','Pseudathyrium alpestre subsp. americanum','(Butters) ined.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22013','','','Athyrium alpestre var. gaspense Fernald','Athyrium alpestre var. gaspense','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22014','','','Athyrium americanum (Butters) Maxon','Athyrium americanum','(Butters) Maxon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22015','','','Athyrium distentifolium subsp. americanum (Butters) Hultén','Athyrium distentifolium subsp. americanum','(Butters) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15760','','','Athyrium distentifolium var. americanum (Butters) B. Boivin','Athyrium distentifolium var. americanum','(Butters) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15759','','','Athyrium alpestre var. americanum Butters','Athyrium alpestre var. americanum','Butters','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5370','','','Athyrium alpestre subsp. americanum (Butters) Lellinger','Athyrium alpestre subsp. americanum','(Butters) Lellinger','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26952','','','Diplaziopsidaceae X.C. Zhang & Christenhusz','Diplaziopsidaceae','X.C. Zhang & Christenhusz','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26953','','','Homalosorus Small ex Pichi Sermolli','Homalosorus','Small ex Pichi Sermolli','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26954','','','Homalosorus pycnocarpos (Sprengel) Pichi Sermolli','Homalosorus pycnocarpos','(Sprengel) Pichi Sermolli','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34117','','','Diplaziopsis pycnocarpos (Sprengel) M.G. Price','Diplaziopsis pycnocarpos','(Sprengel) M.G. Price','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26172','','','Diplazium angustifolium (Michaux) Butters','Diplazium angustifolium','(Michaux) Butters','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26170','','','Athyrium angustifolium (Michaux) Milde','Athyrium angustifolium','(Michaux) Milde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26171','','','Asplenium angustifolium Michaux','Asplenium angustifolium','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22022','','','Asplenium pycnocarpon Sprengel','Asplenium pycnocarpon','Sprengel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15772','','','Athyrium pycnocarpon (Sprengel) Tidestrom','Athyrium pycnocarpon','(Sprengel) Tidestrom','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5382','','','Diplazium pycnocarpon (Sprengel) M. Broun','Diplazium pycnocarpon','(Sprengel) M. Broun','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('238','','','Woodsiaceae Herter','Woodsiaceae','Herter','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1827','','','Woodsia R. Brown','Woodsia','R. Brown','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5452','','','Woodsia × maxonii R. Tryon','Woodsia × maxonii','R. Tryon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5453','','','Woodsia × tryonis B. Boivin','Woodsia × tryonis','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5450','','','Woodsia × abbeae Butters','Woodsia × abbeae','Butters','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5451','','','Woodsia × gracilis (G. Lawson) Butters','Woodsia × gracilis','(G. Lawson) Butters','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23506','','','Woodsia ilvensis var. gracilis G. Lawson','Woodsia ilvensis var. gracilis','G. Lawson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5440','','','Woodsia glabella R. Brown ex Richardson','Woodsia glabella','R. Brown ex Richardson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22043','','','Woodsia hyperborea var. glabella (R. Brown ex Richardson) Watt','Woodsia hyperborea var. glabella','(R. Brown ex Richardson) Watt','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22042','','','Woodsia alpina var. glabella (R. Brown ex Richardson) D.C. Eaton','Woodsia alpina var. glabella','(R. Brown ex Richardson) D.C. Eaton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5441','','','Woodsia ilvensis (Linnaeus) R. Brown','Woodsia ilvensis','(Linnaeus) R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28283','','','Woodsia ilvensis var. rufidula (Michaux) Ascherson & P. Graebner','Woodsia ilvensis var. rufidula','(Michaux) Ascherson & P. Graebner','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28282','','','Woodsia hyperborea var. rufidula (Michaux) W.D.J. Koch','Woodsia hyperborea var. rufidula','(Michaux) W.D.J. Koch','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28281','','','Notholaena rufidula (Michaux) Desvaux','Notholaena rufidula','(Michaux) Desvaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28280','','','Athyrium rufidulum (Michaux) A.A. Eaton','Athyrium rufidulum','(Michaux) A.A. Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28284','','','Polypodium ilvense (Linnaeus) Villars','Polypodium ilvense','(Linnaeus) Villars','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28278','','','Woodsia rufidula (Michaux) L.C. Beck','Woodsia rufidula','(Michaux) L.C. Beck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28279','','','Aspidium rufidulum (Michaux) Swartz','Aspidium rufidulum','(Michaux) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15812','','','Acrostichum ilvense Linnaeus','Acrostichum ilvense','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15813','','','Nephrodium rufidulum Michaux','Nephrodium rufidulum','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5439','','','Woodsia alpina (Bolton) Gray','Woodsia alpina','(Bolton) Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23504','','','Woodsia glabella var. bellii G. Lawson','Woodsia glabella var. bellii','G. Lawson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23505','','','Woodsia alpina subsp. bellii (G. Lawson) Á. Löve & D. Löve','Woodsia alpina subsp. bellii','(G. Lawson) Á. Löve & D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22037','','','Acrostichum alpinum Bolton','Acrostichum alpinum','Bolton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22038','','','Woodsia alpina var. bellii (G. Lawson) G. Lawson','Woodsia alpina var. bellii','(G. Lawson) G. Lawson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22039','','','Woodsia bellii (G. Lawson) A.E. Porsild','Woodsia bellii','(G. Lawson) A.E. Porsild','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22040','','','Woodsia hyperborea (Liljeblad) R. Brown','Woodsia hyperborea','(Liljeblad) R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22041','','','Woodsia ilvensis var. alpina (Bolton) Watt','Woodsia ilvensis var. alpina','(Bolton) Watt','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5448','','','Woodsia scopulina D. C. Eaton','Woodsia scopulina','D. C. Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5449','','','Woodsia scopulina subsp. scopulina D.C. Eaton','Woodsia scopulina subsp. scopulina','D.C. Eaton','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28315','','','Woodsia obtusa var. lyallii Hooker','Woodsia obtusa var. lyallii','Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28314','','','Woodsia oregana var. lyallii (Hooker) B. Boivin','Woodsia oregana var. lyallii','(Hooker) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5447','','','Woodsia scopulina subsp. laurentiana Windham','Woodsia scopulina subsp. laurentiana','Windham','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5445','','','Woodsia oregana D.C. Eaton','Woodsia oregana','D.C. Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5446','','','Woodsia oregana subsp. oregana D.C. Eaton','Woodsia oregana subsp. oregana','D.C. Eaton','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5444','','','Woodsia oregana subsp. cathcartiana (B.L. Robinson) Windham','Woodsia oregana subsp. cathcartiana','(B.L. Robinson) Windham','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22045','','','Woodsia cathcartiana B.L. Robinson','Woodsia cathcartiana','B.L. Robinson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22047','','','Woodsia pusilla var. cathcartiana (B.L. Robinson) T.M.C. Taylor','Woodsia pusilla var. cathcartiana','(B.L. Robinson) T.M.C. Taylor','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22046','','','Woodsia oregana var. cathcartiana (B.L. Robinson) C.V. Morton','Woodsia oregana var. cathcartiana','(B.L. Robinson) C.V. Morton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5443','','','Woodsia obtusa (Sprengel) Torrey','Woodsia obtusa','(Sprengel) Torrey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5442','','','Woodsia obtusa subsp. obtusa (Sprengel) Torrey','Woodsia obtusa subsp. obtusa','(Sprengel) Torrey','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22044','','','Polypodium obtusum Sprengel','Polypodium obtusum','Sprengel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26382','','','Cystopteridaceae (Payer) Shmakov','Cystopteridaceae','(Payer) Shmakov','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1221','','','Gymnocarpium Newman','Gymnocarpium','Newman','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5413','','','Gymnocarpium disjunctum (Ruprecht) Ching','Gymnocarpium disjunctum','(Ruprecht) Ching','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22029','','','Polypodium dryopteris var. disjunctum Ruprecht','Polypodium dryopteris var. disjunctum','Ruprecht','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22030','','','Gymnocarpium dryopteris subsp. disjunctum (Ruprecht) Sarvela','Gymnocarpium dryopteris subsp. disjunctum','(Ruprecht) Sarvela','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22031','','','Dryopteris disjuncta (Ruprecht) C.V. Morton','Dryopteris disjuncta','(Ruprecht) C.V. Morton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22032','','','Gymnocarpium dryopteris var. disjunctum (Ruprecht) Ching','Gymnocarpium dryopteris var. disjunctum','(Ruprecht) Ching','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5414','','','Gymnocarpium dryopteris (Linnaeus) Newman','Gymnocarpium dryopteris','(Linnaeus) Newman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32874','','','Dryopteris disjuncta','Dryopteris disjuncta','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28337','','','Polypodium pulchellum Salisbury','Polypodium pulchellum','Salisbury','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28335','','','Aspidium dryopteris (Linnaeus) Baumgardten','Aspidium dryopteris','(Linnaeus) Baumgardten','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28336','','','Dryopteris pulchella (Salisbury) Hayek','Dryopteris pulchella','(Salisbury) Hayek','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25879','','','Gymnocarpium dryopteris subsp. dryopteris (Linnaeus) Newman','Gymnocarpium dryopteris subsp. dryopteris','(Linnaeus) Newman','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25880','','','Gymnocarpium dryopteris var. dryopteris (Linnaeus) Newman','Gymnocarpium dryopteris var. dryopteris','(Linnaeus) Newman','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25881','','','Phegopteris dryopteris (Linnaeus) Fée','Phegopteris dryopteris','(Linnaeus) Fée','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23502','','','Dryopteris dryopteris (Linnaeus) Christ nom. inval.','Dryopteris dryopteris','(Linnaeus) Christ nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22033','','','Lastraea dryopteris (Linnaeus) Bory','Lastraea dryopteris','(Linnaeus) Bory','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15795','','','Nephrodium dryopteris (Linnaeus) Michaux','Nephrodium dryopteris','(Linnaeus) Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15794','','','Dryopteris linnaeana C. Christensen','Dryopteris linnaeana','C. Christensen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15797','','','Thelypteris dryopteris (Linnaeus) Slosson','Thelypteris dryopteris','(Linnaeus) Slosson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15796','','','Phegopteris dryopteris subsp. dryopteris (Linnaeus) Fée','Phegopteris dryopteris subsp. dryopteris','(Linnaeus) Fée','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15790','','','Polypodium dryopteris Linnaeus','Polypodium dryopteris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15792','','','Currania dryopteris (Linnaeus) Wherry','Currania dryopteris','(Linnaeus) Wherry','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15791','','','Carpogymnia dryopteris (Linnaeus) Á. Löve & D. Löve','Carpogymnia dryopteris','(Linnaeus) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5417','','','Gymnocarpium robertianum (Hoffmann) Newman','Gymnocarpium robertianum','(Hoffmann) Newman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30792','','','Phegopteris calcarea Fée','Phegopteris calcarea','Fée','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23503','','','Gymnocarpium dryopteris var. pumilum (de Candolle) B. Boivin','Gymnocarpium dryopteris var. pumilum','(de Candolle) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22034','','','Polypodium robertianum Hoffmann','Polypodium robertianum','Hoffmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22035','','','Phegopteris robertiana (Hoffmann) A.Braun ex Ascherson','Phegopteris robertiana','(Hoffmann) A.Braun ex Ascherson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15799','','','Thelypteris robertiana (Hoffmann) Slosson','Thelypteris robertiana','(Hoffmann) Slosson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15798','','','Dryopteris robertiana (Hoffmann) C. Christensen','Dryopteris robertiana','(Hoffmann) C. Christensen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5418','','','Gymnocarpium × achriosporum Sarvela','Gymnocarpium × achriosporum','Sarvela','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5419','','','Gymnocarpium × brittonianum (Sarvela) Pryer & Haufler','Gymnocarpium × brittonianum','(Sarvela) Pryer & Haufler','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28334','','','Gymnocarpium dryopteris nothosubsp. brittonianum Sarvela','Gymnocarpium dryopteris nothosubsp. brittonianum','Sarvela','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5420','','','Gymnocarpium × intermedium Sarvela','Gymnocarpium × intermedium','Sarvela','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22036','','','Gymnocarpium continentale (Petrov) Pojarkova','Gymnocarpium continentale','(Petrov) Pojarkova','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5415','','','Gymnocarpium jessoense subsp. parvulum Sarvela','Gymnocarpium jessoense subsp. parvulum','Sarvela','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1071','','','Cystopteris Bernhardi','Cystopteris','Bernhardi','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5380','','','Cystopteris tenuis (Michaux) Desvaux','Cystopteris tenuis','(Michaux) Desvaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22027','','','Nephrodium tenue Michaux','Nephrodium tenue','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15770','','','Cystopteris fragilis var. mackayi G. Lawson','Cystopteris fragilis var. mackayi','G. Lawson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5379','','','Cystopteris protrusa (Weatherby) Blasdell','Cystopteris protrusa','(Weatherby) Blasdell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22026','','','Cystopteris fragilis var. protrusa Weatherby','Cystopteris fragilis var. protrusa','Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5378','','','Cystopteris montana (Lamarck) Bernhardi ex Desvaux','Cystopteris montana','(Lamarck) Bernhardi ex Desvaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22024','','','Polypodium montanum Lamarck','Polypodium montanum','Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15769','','','Rhizomatopteris montana (Lamarck) A.P. Khokhrjakov','Rhizomatopteris montana','(Lamarck) A.P. Khokhrjakov','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5377','','','Cystopteris laurentiana (Weatherby) Blasdell','Cystopteris laurentiana','(Weatherby) Blasdell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15768','','','Cystopteris fragilis var. laurentiana Weatherby','Cystopteris fragilis var. laurentiana','Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5376','','','Cystopteris fragilis (Linnaeus) Bernhardi','Cystopteris fragilis','(Linnaeus) Bernhardi','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28339','','','Cystopteris fragilis var. dickieana (R. Sim) T. Moore','Cystopteris fragilis var. dickieana','(R. Sim) T. Moore','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28338','','','Cystopteris fragilis var. dickieana (R. Sim) Lindberg nom. illeg.','Cystopteris fragilis var. dickieana','(R. Sim) Lindberg nom. illeg.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28366','','','Cystopteris fragilis subsp. eu-fragilis Ascherson & Graebner nom. inval.','Cystopteris fragilis subsp. eu-fragilis','Ascherson & Graebner nom. inval.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28677','','','Filix fragilis (Linnaeus) Underwood','Filix fragilis','(Linnaeus) Underwood','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25780','','','Cystopteris fragilis var. fragilis (Linnaeus) Bernhardi','Cystopteris fragilis var. fragilis','(Linnaeus) Bernhardi','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25779','','','Cystopteris fragilis subsp. fragilis (Linnaeus) Bernhardi','Cystopteris fragilis subsp. fragilis','(Linnaeus) Bernhardi','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22028','','','Polypodium fragile Linnaeus','Polypodium fragile','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15767','','','Cystopteris fragilis var. woodsioides (Christ) Rouy','Cystopteris fragilis var. woodsioides','(Christ) Rouy','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15766','','','Cystopteris fragilis subsp. dickieana (R. Sim) Hylander','Cystopteris fragilis subsp. dickieana','(R. Sim) Hylander','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15765','','','Cystopteris dickieana R. Sim','Cystopteris dickieana','R. Sim','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5375','','','Cystopteris bulbifera (Linnaeus) Bernhardi','Cystopteris bulbifera','(Linnaeus) Bernhardi','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28317','','','Athyrium bulbiferum (Linnaeus) A.A. Eaton','Athyrium bulbiferum','(Linnaeus) A.A. Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28318','','','Cystea bulbifera (Linnaeus) Watt','Cystea bulbifera','(Linnaeus) Watt','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28316','','','Filix bulbifera (Linnaeus) Underwood','Filix bulbifera','(Linnaeus) Underwood','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22025','','','Polypodium bulbiferum Linnaeus','Polypodium bulbiferum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('228','','','Thelypteridaceae Pichi Sermolli','Thelypteridaceae','Pichi Sermolli','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31531','','','Phegopteridoideae Salino, A.R. Smith & T.E. Almeida','Phegopteridoideae','Salino, A.R. Smith & T.E. Almeida','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1532','','','Phegopteris (C. Presl) Fée','Phegopteris','(C. Presl) Fée','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9403','','','Phegopteris hexagonoptera (Michaux) Fée','Phegopteris hexagonoptera','(Michaux) Fée','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21417','','','Thelypteris hexagonoptera (Michaux) Weatherby','Thelypteris hexagonoptera','(Michaux) Weatherby','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21416','','','Dryopteris hexagonoptera (Michaux) C. Christensen','Dryopteris hexagonoptera','(Michaux) C. Christensen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22012','','','Polypodium hexagonopterum Michaux','Polypodium hexagonopterum','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9402','','','Phegopteris connectilis (Michaux) Watt','Phegopteris connectilis','(Michaux) Watt','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29420','','','Phegopteris phegopteris (Linnaeus) Keyserling nom. illeg.','Phegopteris phegopteris','(Linnaeus) Keyserling nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26468','','','Lastrea phegopteris (Linnaeus) Bory','Lastrea phegopteris','(Linnaeus) Bory','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26467','','','Gymnocarpium phegopteris (Linnaeus) Newman','Gymnocarpium phegopteris','(Linnaeus) Newman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26466','','','Aspidium phegopteris (Linnaeus) Baumgardten','Aspidium phegopteris','(Linnaeus) Baumgardten','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26465','','','Polypodium phegopteris Linnaeus','Polypodium phegopteris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26470','','','Polystichum phegopteris (Linnaeus) Roth','Polystichum phegopteris','(Linnaeus) Roth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26469','','','Nephrodium phegopteris (Linnaeus) Prantl','Nephrodium phegopteris','(Linnaeus) Prantl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21415','','','Thelypteris phegopteris (Linnaeus) Slosson','Thelypteris phegopteris','(Linnaeus) Slosson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21414','','','Dryopteris phegopteris (Linnaeus) C. Christensen','Dryopteris phegopteris','(Linnaeus) C. Christensen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22011','','','Phegopteris polypodioides Fée','Phegopteris polypodioides','Fée','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22010','','','Polypodium connectile Michaux','Polypodium connectile','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32269','','','Phegopteris excelsior N. Patel & A.V. Gilman','Phegopteris excelsior','N. Patel & A.V. Gilman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31532','','','Thelypteridoideae C.F. Reed','Thelypteridoideae','C.F. Reed','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32927','','','Amauropelta Kunze','Amauropelta','Kunze','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~7R','','','Amauropelta (Nibaa) S.E.Fawcett & A.R.Smith','Amauropelta (Nibaa)','S.E.Fawcett & A.R.Smith','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32929','','','Amauropelta nevadensis (Baker) S.E. Fawcett & A.R. Smith','Amauropelta nevadensis','(Baker) S.E. Fawcett & A.R. Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27596','','','Dryopteris oregana C. Christensen','Dryopteris oregana','C. Christensen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27597','','','Parathelypteris nevadensis (Baker) Holttum','Parathelypteris nevadensis','(Baker) Holttum','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27598','','','Lastrea oregana (C. Christensen) Copeland','Lastrea oregana','(C. Christensen) Copeland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27595','','','Dryopteris nevadensis (Baker) Underwood','Dryopteris nevadensis','(Baker) Underwood','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27594','','','Nephrodium nevadense Baker','Nephrodium nevadense','Baker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9404','','','Thelypteris nevadensis (Baker) Clute ex Morton','Thelypteris nevadensis','(Baker) Clute ex Morton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32930','','','Amauropelta noveboracensis (Linnaeus) S.E. Fawcett & A.R. Smith','Amauropelta noveboracensis','(Linnaeus) S.E. Fawcett & A.R. Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27600','','','Parathelypteris noveboracensis (Linnaeus) Ching','Parathelypteris noveboracensis','(Linnaeus) Ching','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27601','','','Thelypteris thelypterioides (Michaux) Holub','Thelypteris thelypterioides','(Michaux) Holub','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27602','','','Nephrodium thelypterioides Michaux','Nephrodium thelypterioides','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27599','','','Polypodium noveboracense Linnaeus','Polypodium noveboracense','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29415','','','Nephrodiuma noveboracense (Linnaeus) Desvaux','Nephrodiuma noveboracense','(Linnaeus) Desvaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29414','','','Aspidium noveboracense (Linnaeus) Swartz','Aspidium noveboracense','(Linnaeus) Swartz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21418','','','Dryopteris noveboracensis (Linnaeus) A. Gray','Dryopteris noveboracensis','(Linnaeus) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9405','','','Thelypteris noveboracensis (Linnaeus) Nieuwland','Thelypteris noveboracensis','(Linnaeus) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32928','','','Amauropelta subgen. Nibaa S.E. Fawcett & A.R. Smith','Amauropelta subgen. Nibaa','S.E. Fawcett & A.R. Smith','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29416','','','Oreopteris Holub','Oreopteris','Holub','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21422','','','Oreopteris quelpartensis (Christ) Holub','Oreopteris quelpartensis','(Christ) Holub','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30293','','','Oreopteris limbosperma','Oreopteris limbosperma','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27608','','','Polypodium limbospermum','Polypodium limbospermum','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29418','','','Ctenitis quelpartensis (Christ) H. Itô','Ctenitis quelpartensis','(Christ) H. Itô','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29419','','','Lastrea quelpartensis (Christ) Copeland','Lastrea quelpartensis','(Christ) Copeland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29417','','','Athyrium quelpartense (Christ) Ching','Athyrium quelpartense','(Christ) Ching','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21423','','','Dryopteris quelpartensis Christ','Dryopteris quelpartensis','Christ','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21421','','','Thelypteris limbosperma','Thelypteris limbosperma','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9408','','','Thelypteris quelpartensis (Christ) Ching','Thelypteris quelpartensis','(Christ) Ching','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31533','','','Coryphopteris Holttum','Coryphopteris','Holttum','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31534','','','Coryphopteris simulata (Davenport) S.E. Fawcett','Coryphopteris simulata','(Davenport) S.E. Fawcett','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27604','','','Parathelypteris simulata (Davenport) Holttum','Parathelypteris simulata','(Davenport) Holttum','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27605','','','Filix simulata (Davenport) Farwell','Filix simulata','(Davenport) Farwell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27606','','','Wagneriopteris simulata (Davenport) Á. Löve & D. Löve','Wagneriopteris simulata','(Davenport) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27607','','','Nephrodium simulatum Davenport','Nephrodium simulatum','Davenport','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27603','','','Aspidium simulatum Davenport','Aspidium simulatum','Davenport','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21424','','','Dryopteris simulata Davenport','Dryopteris simulata','Davenport','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9409','','','Thelypteris simulata (Davenport) Nieuwland','Thelypteris simulata','(Davenport) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1753','','','Thelypteris Schmidel','Thelypteris','Schmidel','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9407','','','Thelypteris palustris Schott','Thelypteris palustris','Schott','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29608','','','Thelypteris palustris subsp. pubescens (G. Lawson) Holub','Thelypteris palustris subsp. pubescens','(G. Lawson) Holub','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27593','','','Thelypteris palustris var. haleana Fernald','Thelypteris palustris var. haleana','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27592','','','Dryopteris thelypteris var. pubescens (G. Lawson) Weatherby','Dryopteris thelypteris var. pubescens','(G. Lawson) Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27591','','','Lastrea thelypteris var. pubescens G. Lawson','Lastrea thelypteris var. pubescens','G. Lawson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29421','','','Dryopteris tremula Christ','Dryopteris tremula','Christ','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9406','','','Thelypteris palustris var. pubescens (G. Lawson) Fernald','Thelypteris palustris var. pubescens','(G. Lawson) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('49','','','Osmundales Link','Osmundales','Link','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('183','','','Osmundaceae Martinov','Osmundaceae','Martinov','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31528','','','Claytosmunda (Y. Yatabe, N. Murakami & K. Iwatsuki) Metzgar & Rouhan','Claytosmunda','(Y. Yatabe, N. Murakami & K. Iwatsuki) Metzgar & Rouhan','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31529','','','Claytosmunda claytoniana (Linnaeus) Metzgar & Rouhan','Claytosmunda claytoniana','(Linnaeus) Metzgar & Rouhan','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31492','','','Osmunda interrupta Michaux','Osmunda interrupta','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7075','','','Osmunda claytoniana Linnaeus','Osmunda claytoniana','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1493','','','Osmunda Linnaeus','Osmunda','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21984','','','Osmunda spectabilis Willdenow','Osmunda spectabilis','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25565','','','Osmunda regalis subsp. spectabilis (Willdenow) Á. Löve & D. Löve','Osmunda regalis subsp. spectabilis','(Willdenow) Á. Löve & D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7076','','','Osmunda regalis var. spectabilis (Willdenow) A. Gray','Osmunda regalis var. spectabilis','(Willdenow) A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1863','','','Osmundastrum C. Presl','Osmundastrum','C. Presl','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7074','','','Osmundastrum cinnamomeum (Linnaeus) C. Presl','Osmundastrum cinnamomeum','(Linnaeus) C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17828','','','Osmunda cinnamomea Linnaeus','Osmunda cinnamomea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('62','','','Salviniales Link','Salviniales','Link','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('164','','','Marsileaceae Mirbel','Marsileaceae','Mirbel','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1396','','','Marsilea Linnaeus','Marsilea','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6647','','','Marsilea vestita Hooker & Greville','Marsilea vestita','Hooker & Greville','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6646','','','Marsilea quadrifolia Linnaeus','Marsilea quadrifolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('212','','','Salviniaceae Martinov','Salviniaceae','Martinov','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('882','','','Azolla Lamarck','Azolla','Lamarck','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9191','','','Azolla filiculoides Lamarck','Azolla filiculoides','Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9190','','','Azolla caroliniana Willdenow','Azolla caroliniana','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9192','','','Azolla mexicana Schlechtendal & Chamisso ex C. Presl','Azolla mexicana','Schlechtendal & Chamisso ex C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('68','','','Schizaeales Schimper','Schizaeales','Schimper','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('218','','','Schizaeaceae Kaulfuss','Schizaeaceae','Kaulfuss','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1662','','','Schizaea Smith','Schizaea','Smith','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9318','','','Schizaea pusilla Pursh','Schizaea pusilla','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21345','','','Microschizaea pusilla (Pursh) C.F. Reed','Microschizaea pusilla','(Pursh) C.F. Reed','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32','','','Hymenophyllales A.B. Frank','Hymenophyllales','A.B. Frank','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('144','','','Hymenophyllaceae Martius','Hymenophyllaceae','Martius','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33274','','','Crepidomanes (C. Presl) C. Presl','Crepidomanes','(C. Presl) C. Presl','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33275','','','Crepidomanes intricatum (Farrar) Ebihara & Weakley','Crepidomanes intricatum','(Farrar) Ebihara & Weakley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33276','','','Trichomanes intricatum Farrar','Trichomanes intricatum','Farrar','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1272','','','Hymenophyllum Smith','Hymenophyllum','Smith','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6147','','','Hymenophyllum wrightii Bosch','Hymenophyllum wrightii','Bosch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16583','','','Mecodium wrightii (Bosch) Copeland','Mecodium wrightii','(Bosch) Copeland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8','','','Magnoliidae Novák ex Takhtajan','Magnoliidae','Novák ex Takhtajan','SUBCLASS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('64','','','Santalanae Thorne ex Reveal','Santalanae','Thorne ex Reveal','SUPERORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('63','','','Santalales Lindley','Santalales','Lindley','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33420','','','Viscaceae Batsch','Viscaceae','Batsch','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('843','','','Arceuthobium Bieberstein','Arceuthobium','Bieberstein','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6570','','','Arceuthobium americanum Nuttall ex Engelmann','Arceuthobium americanum','Nuttall ex Engelmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30189','','','Razoumofskya americana (Nuttall ex Engelmann) Kuntze','Razoumofskya americana','(Nuttall ex Engelmann) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6571','','','Arceuthobium campylopodum Engelmann','Arceuthobium campylopodum','Engelmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28073','','','Arceuthobium campylopodum subsp. laricis (M.E. Jones) Nickrent','Arceuthobium campylopodum subsp. laricis','(M.E. Jones) Nickrent','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28072','','','Razoumofskya laricis (M.E. Jones) Piper','Razoumofskya laricis','(M.E. Jones) Piper','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28074','','','Arceuthobium douglasii var. laricis M.E. Jones','Arceuthobium douglasii var. laricis','M.E. Jones','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17143','','','Arceuthobium laricis (M.E. Jones) H. St.John','Arceuthobium laricis','(M.E. Jones) H. St.John','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30193','','','Arceuthobium campylopodum subsp. tsugense (Rosendahl) Nickrent','Arceuthobium campylopodum subsp. tsugense','(Rosendahl) Nickrent','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30194','','','Razoumofskya tsugensis Rosendahl','Razoumofskya tsugensis','Rosendahl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30195','','','Razoumofskya douglasii subsp. tsugensis (Rosendahl) Piper','Razoumofskya douglasii subsp. tsugensis','(Rosendahl) Piper','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17151','','','Arceuthobium tsugense subsp. contortae Wass & Mathiasen','Arceuthobium tsugense subsp. contortae','Wass & Mathiasen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17150','','','Arceuthobium tsugense subsp. amabilae Mathiasen & C.M. Daugherty','Arceuthobium tsugense subsp. amabilae','Mathiasen & C.M. Daugherty','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17152','','','Arceuthobium tsugense subsp. mertensianae Hawksworth & Nickrent','Arceuthobium tsugense subsp. mertensianae','Hawksworth & Nickrent','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17149','','','Arceuthobium tsugense (Rosendahl) G.N. Jones','Arceuthobium tsugense','(Rosendahl) G.N. Jones','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6572','','','Arceuthobium douglasii Engelmann','Arceuthobium douglasii','Engelmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30190','','','Razoumofskya douglasii (Engelmann) Kuntze','Razoumofskya douglasii','(Engelmann) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6573','','','Arceuthobium pusillum Peck','Arceuthobium pusillum','Peck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30191','','','Razoumofskya pusilla (Peck) Kuntze','Razoumofskya pusilla','(Peck) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30192','','','Arceuthobium minutum Engelmann nom. inval.','Arceuthobium minutum','Engelmann nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1950','','','Viscum Linnaeus','Viscum','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9757','','','Viscum album Linnaeus','Viscum album','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33422','','','Comandraceae Nickrent & Der','Comandraceae','Nickrent & Der','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1018','','','Comandra Nuttall','Comandra','Nuttall','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9194','','','Comandra umbellata (Linnaeus) Nuttall','Comandra umbellata','(Linnaeus) Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9193','','','Comandra umbellata subsp. californica (Eastwood ex Rydberg) Piehl','Comandra umbellata subsp. californica','(Eastwood ex Rydberg) Piehl','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21071','','','Comandra umbellata var. californica (Eastwood ex Rydberg) C.L. Hitchcock','Comandra umbellata var. californica','(Eastwood ex Rydberg) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21072','','','Comandra californica Eastwood ex Rydberg','Comandra californica','Eastwood ex Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9195','','','Comandra umbellata subsp. pallida (A. de Candolle) Piehl','Comandra umbellata subsp. pallida','(A. de Candolle) Piehl','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21073','','','Comandra umbellata var. pallida (A. de Candolle) M.E. Jones','Comandra umbellata var. pallida','(A. de Candolle) M.E. Jones','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21074','','','Comandra pallida A. de Candolle','Comandra pallida','A. de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9196','','','Comandra umbellata subsp. umbellata (Linnaeus) Nuttall','Comandra umbellata subsp. umbellata','(Linnaeus) Nuttall','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30187','','','Comandra umbellata subsp. richardsiana (Fernald) Á. Löve & D. Löve','Comandra umbellata subsp. richardsiana','(Fernald) Á. Löve & D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23760','','','Thesium umbellatum Linnaeus','Thesium umbellatum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21075','','','Comandra umbellata var. umbellata (Linnaeus) Nuttall','Comandra umbellata var. umbellata','(Linnaeus) Nuttall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21076','','','Comandra richardsiana Fernald','Comandra richardsiana','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1202','','','Geocaulon Fernald','Geocaulon','Fernald','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9197','','','Geocaulon lividum (Richardson) Fernald','Geocaulon lividum','(Richardson) Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30724','','','Hamiltonia sarmentosa Sprengel','Hamiltonia sarmentosa','Sprengel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21077','','','Comandra livida Richardson','Comandra livida','Richardson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33421','','','Thesiaceae Vest','Thesiaceae','Vest','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27198','','','Thesium Linnaeus','Thesium','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30188','','','Thesium ramosum Hayne','Thesium ramosum','Hayne','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27199','','','Thesium arvense Horvátovszky nom. illeg.','Thesium arvense','Horvátovszky nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('67','','','Saxifraganae Reveal','Saxifraganae','Reveal','SUPERORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('66','','','Saxifragales Berchtold & J. Presl','Saxifragales','Berchtold & J. Presl','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('117','','','Crassulaceae J. St-Hilaire','Crassulaceae','J. St-Hilaire','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('347','','','Sempervivoideae','Sempervivoideae','','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('585','','','Sedeae','Sedeae','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1619','','','Rhodiola Linnaeus','Rhodiola','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4659','','','Rhodiola integrifolia Rafinesque','Rhodiola integrifolia','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4658','','','Rhodiola integrifolia subsp. integrifolia Rafinesque','Rhodiola integrifolia subsp. integrifolia','Rafinesque','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26606','','','Sedum rosea subsp. integrifolium (Rafinesque) Hultén','Sedum rosea subsp. integrifolium','(Rafinesque) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22630','','','Tolmachevia integrifolia (Rafinesque) Á. Löve & D. Löve','Tolmachevia integrifolia','(Rafinesque) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22628','','','Rhodiola rosea var. integrifolia (Rafinesque) Jepson','Rhodiola rosea var. integrifolia','(Rafinesque) Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22629','','','Sedum rosea var. integrifolia (Rafinesque) A. Berger','Sedum rosea var. integrifolia','(Rafinesque) A. Berger','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14871','','','Sedum integrifolium (Rafinesque) A. Nelson','Sedum integrifolium','(Rafinesque) A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14870','','','Rhodiola rosea subsp. integrifolia (Rafinesque) H. Hara','Rhodiola rosea subsp. integrifolia','(Rafinesque) H. Hara','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14872','','','Sedum integrifolium subsp. integrifolium (Rafinesque) A. Nelson','Sedum integrifolium subsp. integrifolium','(Rafinesque) A. Nelson','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4660','','','Rhodiola rosea Linnaeus','Rhodiola rosea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25452','','','Sedum rosea subsp. rosea (Linnaeus) Scopoli','Sedum rosea subsp. rosea','(Linnaeus) Scopoli','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25453','','','Sedum rosea var. rosea (Linnaeus) Scopoli','Sedum rosea var. rosea','(Linnaeus) Scopoli','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22624','','','Sedum rhodiola de Candolle','Sedum rhodiola','de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22625','','','Rhodiola roanensis (Britton) Britton','Rhodiola roanensis','(Britton) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22626','','','Sedum roanense Britton','Sedum roanense','Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22627','','','Sedum rosea var. roanense (Britton) A. Berger','Sedum rosea var. roanense','(Britton) A. Berger','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14873','','','Sedum rosea (Linnaeus) Scopoli','Sedum rosea','(Linnaeus) Scopoli','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1270','','','Hylotelephium H. Ohba','Hylotelephium','H. Ohba','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33352','','','Hylotelephium erythrostictum (Miquel) H. Ohba','Hylotelephium erythrostictum','(Miquel) H. Ohba','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33354','','','Sedum alboroseum Baker','Sedum alboroseum','Baker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33353','','','Sedum erythrostictum Miquel','Sedum erythrostictum','Miquel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4657','','','Hylotelephium telephium (Linnaeus) H. Ohba','Hylotelephium telephium','(Linnaeus) H. Ohba','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22622','','','Sedum telephium Linnaeus','Sedum telephium','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14869','','','Hylotelephium telephium subsp. telephium (Linnaeus) H. Ohba','Hylotelephium telephium subsp. telephium','(Linnaeus) H. Ohba','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14868','','','Sedum triphyllum (Haworth) Gray','Sedum triphyllum','(Haworth) Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14867','','','Sedum purpureum (Linnaeus) Schultes','Sedum purpureum','(Linnaeus) Schultes','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14866','','','Sedum fabaria W.D.J. Koch','Sedum fabaria','W.D.J. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14865','','','Sedum telephium subsp. fabaria (W.D.J. Koch) Kirschleger','Sedum telephium subsp. fabaria','(W.D.J. Koch) Kirschleger','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28376','','','Hylotelephium spectabile (Boreau) H. Ohba','Hylotelephium spectabile','(Boreau) H. Ohba','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28377','','','Sedum spectabile Boreau','Sedum spectabile','Boreau','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4682','','','Hylotelephium telephioides (Michaux) H. Ohba','Hylotelephium telephioides','(Michaux) H. Ohba','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22623','','','Anacampseros telephioides (Michaux) Haworth','Anacampseros telephioides','(Michaux) Haworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14895','','','Sedum telephioides Michaux','Sedum telephioides','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1673','','','Sedum Linnaeus','Sedum','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4664','','','Sedum annuum Linnaeus','Sedum annuum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22632','','','Etiosedum annuum (Linnaeus) Á. Löve & D. Löve','Etiosedum annuum','(Linnaeus) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4665','','','Sedum divergens S. Watson','Sedum divergens','S. Watson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14877','','','Amerosedum divergens (S. Watson) Á. Löve & D. Löve','Amerosedum divergens','(S. Watson) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4666','','','Sedum hispanicum Linnaeus','Sedum hispanicum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4674','','','Sedum sarmentosum Bunge','Sedum sarmentosum','Bunge','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4661','','','Sedum acre Linnaeus','Sedum acre','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22631','','','Sedum elrodii M.E. Jones','Sedum elrodii','M.E. Jones','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4663','','','Sedum album Linnaeus','Sedum album','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14876','','','Oreosedum album (Linnaeus) Grulich','Oreosedum album','(Linnaeus) Grulich','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4672','','','Sedum oreganum Nuttall','Sedum oreganum','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4671','','','Sedum oreganum var. oreganum Nuttall','Sedum oreganum var. oreganum','Nuttall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26609','','','Cotyledon oregana (Nuttall) Fedde','Cotyledon oregana','(Nuttall) Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26610','','','Echeveria oregana (Nuttall) A. Nelson & J.F. Macbride','Echeveria oregana','(Nuttall) A. Nelson & J.F. Macbride','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26608','','','Breitungia oregana (Nuttall) Á. Löve & D. Löve','Breitungia oregana','(Nuttall) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14883','','','Gormania oregana (Nuttall) Britton','Gormania oregana','(Nuttall) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9700','','','Sedum oreganum var. tenue (R.T. Clausen) H. Ohba','Sedum oreganum var. tenue','(R.T. Clausen) H. Ohba','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22634','','','Sedum oreganum subsp. tenue R.T. Clausen','Sedum oreganum subsp. tenue','R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4675','','','Sedum sexangulare Linnaeus','Sedum sexangulare','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4683','','','Sedum ternatum Michaux','Sedum ternatum','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22635','','','Clausenella ternata (Michaux) Á. Löve & D. Löve','Clausenella ternata','(Michaux) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4684','','','Sedum villosum Linnaeus','Sedum villosum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4669','','','Sedum lanceolatum Torrey','Sedum lanceolatum','Torrey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4668','','','Sedum lanceolatum var. lanceolatum Torrey','Sedum lanceolatum var. lanceolatum','Torrey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14880','','','Sedum lanceolatum var. subalpinum (Fröderström) H. Ohba','Sedum lanceolatum var. subalpinum','(Fröderström) H. Ohba','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14878','','','Amerosedum lanceolatum (Torrey) Á. Löve & D. Löve','Amerosedum lanceolatum','(Torrey) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14879','','','Sedum stenopetalum var. subalpinum Fröderström','Sedum stenopetalum var. subalpinum','Fröderström','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4670','','','Sedum lanceolatum var. nesioticum (G.N. Jones) C.L. Hitchcock','Sedum lanceolatum var. nesioticum','(G.N. Jones) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26607','','','Sedum lanceolatum subsp. nesioticum (G.N. Jones) R.T. Clausen','Sedum lanceolatum subsp. nesioticum','(G.N. Jones) R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22633','','','Sedum nesioticum G.N. Jones','Sedum nesioticum','G.N. Jones','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14881','','','Amerosedum nesioticum (G.N. Jones) Á. Löve & D. Löve','Amerosedum nesioticum','(G.N. Jones) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28664','','','Sedum thartii L.P. Hébert','Sedum thartii','L.P. Hébert','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4681','','','Sedum stenopetalum Pursh','Sedum stenopetalum','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29962','','','Sedum stenopetalum var. monanthum (Suksdorf) H. Ohba','Sedum stenopetalum var. monanthum','(Suksdorf) H. Ohba','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29965','','','Sedum uniflorum Howell nom. illeg.','Sedum uniflorum','Howell nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29963','','','Sedum monanthum Suksdorf','Sedum monanthum','Suksdorf','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29964','','','Sedum stenopetalum subsp. monanthum (Suksdorf) R.T. Clausen','Sedum stenopetalum subsp. monanthum','(Suksdorf) R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4680','','','Sedum stenopetalum var. stenopetalum Pursh','Sedum stenopetalum var. stenopetalum','Pursh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14894','','','Amerosedum stenopetalum (Pursh) Á. Löve & D. Löve','Amerosedum stenopetalum','(Pursh) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14893','','','Sedum douglasii Hooker','Sedum douglasii','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4677','','','Sedum spathulifolium Hooker','Sedum spathulifolium','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4678','','','Sedum spathulifolium var. spathulifolium Hooker','Sedum spathulifolium var. spathulifolium','Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26613','','','Gormania anomala Britton','Gormania anomala','Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26611','','','Cotyledon anomala (Britton) Fedde','Cotyledon anomala','(Britton) Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26612','','','Sedum anomalum (Britton) Britton','Sedum anomalum','(Britton) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14890','','','Sedum spathulifolium subsp. purdyi (Jepson) R.T. Clausen','Sedum spathulifolium subsp. purdyi','(Jepson) R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14889','','','Sedum purdyi Jepson','Sedum purdyi','Jepson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14891','','','Sedum spathulifolium subsp. yosemitense (Britton) R.T. Clausen','Sedum spathulifolium subsp. yosemitense','(Britton) R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14887','','','Sedum spathulifolium subsp. anomalum (Britton) R.T. Clausen & C.H. Uhl','Sedum spathulifolium subsp. anomalum','(Britton) R.T. Clausen & C.H. Uhl','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14888','','','Gormania spathulifolia (Hooker) Á. Löve & D. Löve','Gormania spathulifolia','(Hooker) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4676','','','Sedum spathulifolium var. pruinosum (Britton) B. Boivin','Sedum spathulifolium var. pruinosum','(Britton) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14885','','','Sedum pruinosum Britton','Sedum pruinosum','Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14886','','','Sedum spathulifolium subsp. pruinosum (Britton) R.T. Clausen & C.H. Uhl','Sedum spathulifolium subsp. pruinosum','(Britton) R.T. Clausen & C.H. Uhl','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31419','','','Petrosedum Grulich','Petrosedum','Grulich','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31420','','','Petrosedum rupestre (Linnaeus) P.V. Heath','Petrosedum rupestre','(Linnaeus) P.V. Heath','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31422','','','Petrosedum reflexum (Linnaeus) Grulich','Petrosedum reflexum','(Linnaeus) Grulich','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14884','','','Sedum reflexum','Sedum reflexum','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4673','','','Sedum rupestre Linnaeus','Sedum rupestre','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31421','','','Petrosedum ochroleucum (Chaix) Niederle','Petrosedum ochroleucum','(Chaix) Niederle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28804','','','Sedum ochroleucum Chaix','Sedum ochroleucum','Chaix','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28663','','','Petrosedum forsterianum (Smith) Grulich','Petrosedum forsterianum','(Smith) Grulich','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28661','','','Sedum rupestre var. forsterianum (Smith) Fiori','Sedum rupestre var. forsterianum','(Smith) Fiori','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28662','','','Sedum pruinatum subsp. forsterianum (Smith) Nyman','Sedum pruinatum subsp. forsterianum','(Smith) Nyman','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28659','','','Sedum forsterianum Smith','Sedum forsterianum','Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28660','','','Sedum rupestre subsp. forsterianum (Smith) R.L. Evans','Sedum rupestre subsp. forsterianum','(Smith) R.L. Evans','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1914','','','Phedimus Rafinesque','Phedimus','Rafinesque','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23486','','','Phedimus hybridus (Linnaeus) ''t Hart','Phedimus hybridus','(Linnaeus) ''t Hart','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26605','','','Aizopsis hybrida (Linnaeus) Grulich','Aizopsis hybrida','(Linnaeus) Grulich','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4667','','','Sedum hybridum Linnaeus','Sedum hybridum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4679','','','Phedimus spurius (M. von Bieberstein) ‘t Hart','Phedimus spurius','(M. von Bieberstein) ‘t Hart','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26603','','','Asterosedum spurium (M. von Bieberstein) Grulich','Asterosedum spurium','(M. von Bieberstein) Grulich','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26604','','','Spathulata spuria (M. von Bieberstein) Á. Löve & D. Löve','Spathulata spuria','(M. von Bieberstein) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14892','','','Sedum spurium M. von Bieberstein','Sedum spurium','M. von Bieberstein','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4662','','','Phedimus aizoon (Linnaeus) ‘t Hart','Phedimus aizoon','(Linnaeus) ‘t Hart','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26601','','','Aizopsis aizoon (Linnaeus) Grulich','Aizopsis aizoon','(Linnaeus) Grulich','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26602','','','Anacampseros aizoon (Linnaeus) Haworth','Anacampseros aizoon','(Linnaeus) Haworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14874','','','Sedum aizoon Linnaeus','Sedum aizoon','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14875','','','Sedum kamtshcaticum subsp. ellacombeanum R.T. Clausen nom. inval.','Sedum kamtshcaticum subsp. ellacombeanum','R.T. Clausen nom. inval.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1675','','','Sempervivum Linnaeus','Sempervivum','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4685','','','Sempervivum tectorum Linnaeus','Sempervivum tectorum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('384','','','Crassuloideae','Crassuloideae','','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1762','','','Crassula Linnaeus','Crassula','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4688','','','Crassula tillaea Lester-Garland','Crassula tillaea','Lester-Garland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14902','','','Tillaea muscosa Linnaeus','Tillaea muscosa','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29082','','','Crassula viridis (S. Watson) Fedde','Crassula viridis','(S. Watson) Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4686','','','Crassula aquatica (Linnaeus) Schönland','Crassula aquatica','(Linnaeus) Schönland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22636','','','Crassula saginoides (Maximowicz) M. Bywater & Wickens','Crassula saginoides','(Maximowicz) M. Bywater & Wickens','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22637','','','Tillaeastrum aquaticum (Linnaeus) Britton','Tillaeastrum aquaticum','(Linnaeus) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14903','','','Tillaea saginoides Maximowicz','Tillaea saginoides','Maximowicz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14896','','','Tillaea aquatica Linnaeus','Tillaea aquatica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4687','','','Crassula connata (Ruíz & Pavon) A. Berger','Crassula connata','(Ruíz & Pavon) A. Berger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22639','','','Crassula connata var. eremica (Jepson) M. Bywater & Wickens','Crassula connata var. eremica','(Jepson) M. Bywater & Wickens','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22638','','','Crassula connata var. erectoides M. Bywater & Wickens','Crassula connata var. erectoides','M. Bywater & Wickens','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22640','','','Crassula connata var. subsimplex (S. Watson) M. Bywater & Wickens','Crassula connata var. subsimplex','(S. Watson) M. Bywater & Wickens','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14901','','','Tillaea minima Gay','Tillaea minima','Gay','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14898','','','Tillaea erecta Hooker & Arnott','Tillaea erecta','Hooker & Arnott','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14897','','','Tillaea connata Ruiz & Pavon','Tillaea connata','Ruiz & Pavon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14900','','','Tillaea leptopetala Bentham','Tillaea leptopetala','Bentham','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14899','','','Crassula erecta (Hooker & Arnott) A. Berger','Crassula erecta','(Hooker & Arnott) A. Berger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('137','','','Grossulariaceae de Candolle','Grossulariaceae','de Candolle','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1623','','','Ribes Linnaeus','Ribes','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6062','','','Ribes diacanthum Pallas','Ribes diacanthum','Pallas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6065','','','Ribes glandulosum Grauer','Ribes glandulosum','Grauer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28480','','','Ribes resinosum Pursh','Ribes resinosum','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16511','','','Ribes rigens Michaux','Ribes rigens','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16512','','','Ribes prostratum L''Héritier','Ribes prostratum','L''Héritier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6058','','','Ribes bracteosum Douglas ex Hooker','Ribes bracteosum','Douglas ex Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6061','','','Ribes cynosbati Linnaeus','Ribes cynosbati','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16508','','','Grossularia cynosbati (Linnaeus) Miller','Grossularia cynosbati','(Linnaeus) Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16510','','','Ribes cynosbati var. glabratum Fernald','Ribes cynosbati var. glabratum','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16509','','','Ribes cynosbati var. atrox Fernald','Ribes cynosbati var. atrox','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6054','','','Ribes acerifolium T.J. Howell','Ribes acerifolium','T.J. Howell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16501','','','Ribes howellii Greene','Ribes howellii','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6055','','','Ribes americanum Miller','Ribes americanum','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16502','','','Ribes floridum L''Héritier nom. illeg.','Ribes floridum','L''Héritier nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6087','','','Ribes triste Pallas','Ribes triste','Pallas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28482','','','Ribes triste var. albinervium (Michaux) Fernald','Ribes triste var. albinervium','(Michaux) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28481','','','Ribes rubrum var. alaskanum (Berger) B. Boivin','Ribes rubrum var. alaskanum','(Berger) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28483','','','Ribes albinervium Michaux','Ribes albinervium','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16542','','','Ribes propinquum Turczaninow','Ribes propinquum','Turczaninow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16541','','','Ribes rubrum var. propinquum (Turczaninow) Trautvetter & C.A. Meyer','Ribes rubrum var. propinquum','(Turczaninow) Trautvetter & C.A. Meyer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6088','','','Ribes uva-crispa Linnaeus','Ribes uva-crispa','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16543','','','Ribes grossularia Linnaeus','Ribes grossularia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6091','','','Ribes watsonianum Koehne','Ribes watsonianum','Koehne','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16544','','','Grossularia watsoniana (Koehne) Coville & Britton','Grossularia watsoniana','(Koehne) Coville & Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9652','','','Ribes alpinum Linnaeus','Ribes alpinum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6057','','','Ribes aureum Pursh','Ribes aureum','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6056','','','Ribes aureum var. aureum Pursh','Ribes aureum var. aureum','Pursh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16503','','','Chrysobotrya aurea (Pursh) Rydberg','Chrysobotrya aurea','(Pursh) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6078','','','Ribes aureum var. villosum de Candolle','Ribes aureum var. villosum','de Candolle','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16529','','','Ribes odoratum H. Wendland','Ribes odoratum','H. Wendland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6060','','','Ribes cereum Douglas','Ribes cereum','Douglas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6059','','','Ribes cereum var. cereum Douglas','Ribes cereum var. cereum','Douglas','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22641','','','Ribes cereum var. pedicellare A. Gray','Ribes cereum var. pedicellare','A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16504','','','Ribes cereum var. inebrians (Lindley) C.L. Hitchcock','Ribes cereum var. inebrians','(Lindley) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16506','','','Ribes reniforme Nuttall','Ribes reniforme','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16505','','','Ribes inebrians Lindley','Ribes inebrians','Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16507','','','Ribes viscidulum Berger','Ribes viscidulum','Berger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6066','','','Ribes hirtellum Michaux','Ribes hirtellum','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16519','','','Ribes oxyacanthoides var. saxosum (Hooker) Coville','Ribes oxyacanthoides var. saxosum','(Hooker) Coville','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16517','','','Ribes oxyacanthoides var. calcicola Fernald','Ribes oxyacanthoides var. calcicola','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16518','','','Ribes oxyacanthoides var. hirtellum (Michaux) Scoggan','Ribes oxyacanthoides var. hirtellum','(Michaux) Scoggan','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16515','','','Ribes hirtellum var. calcicola (Fernald) Fernald','Ribes hirtellum var. calcicola','(Fernald) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16516','','','Ribes hirtellum var. saxosum (Hooker) Fernald','Ribes hirtellum var. saxosum','(Hooker) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16513','','','Ribes huronense Rydberg','Ribes huronense','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16514','','','Ribes triflorum Bigelow','Ribes triflorum','Bigelow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6072','','','Ribes lacustre (Persoon) Poiret','Ribes lacustre','(Persoon) Poiret','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28484','','','Ribes lacustre var. parvulum A. Gray','Ribes lacustre var. parvulum','A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28486','','','Limnobotrya parvula (A. Gray) Rydberg','Limnobotrya parvula','(A. Gray) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28485','','','Ribes parvulum (A. Gray) Rydberg','Ribes parvulum','(A. Gray) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28487','','','Limnobotrya lacustris (Persoon) Rydberg','Limnobotrya lacustris','(Persoon) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16524','','','Ribes oxyacanthoides var. lacustre Persoon','Ribes oxyacanthoides var. lacustre','Persoon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6073','','','Ribes laxiflorum Pursh','Ribes laxiflorum','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16525','','','Ribes coloradoense Coville','Ribes coloradoense','Coville','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6074','','','Ribes lobbii A. Gray','Ribes lobbii','A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16526','','','Grossularia lobbii (A. Gray) Coville & Britton','Grossularia lobbii','(A. Gray) Coville & Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6075','','','Ribes missouriense Nuttall','Ribes missouriense','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16528','','','Ribes missouriense var. ozarkanum Fassett','Ribes missouriense var. ozarkanum','Fassett','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16527','','','Grossularia missouriensis (Nuttall) Coville & Britton','Grossularia missouriensis','(Nuttall) Coville & Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6076','','','Ribes montigenum McClatchie','Ribes montigenum','McClatchie','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28488','','','Ribes lacustre var. molle A. Gray','Ribes lacustre var. molle','A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28491','','','Ribes lacustre var. lentum M.E. Jones','Ribes lacustre var. lentum','M.E. Jones','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28490','','','Ribes lentum (M.E. Jones) Coville & Rose','Ribes lentum','(M.E. Jones) Coville & Rose','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28489','','','Limnobotrya montigena (McClatchie) Rydberg','Limnobotrya montigena','(McClatchie) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22643','','','Ribes nubigenum McClatchie nom. illeg.','Ribes nubigenum','McClatchie nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6077','','','Ribes nigrum Linnaeus','Ribes nigrum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6083','','','Ribes rubrum Linnaeus','Ribes rubrum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25417','','','Ribes vulgare Lamarck','Ribes vulgare','Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16537','','','Ribes sylvestre (Lamarck) Mertens & W.D.J. Koch','Ribes sylvestre','(Lamarck) Mertens & W.D.J. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16536','','','Ribes sativum (Reichenbach) Syme','Ribes sativum','(Reichenbach) Syme','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16535','','','Ribes rubrum var. sativum Reichenbach','Ribes rubrum var. sativum','Reichenbach','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6085','','','Ribes sanguineum Pursh','Ribes sanguineum','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6084','','','Ribes sanguineum var. sanguineum Pursh','Ribes sanguineum var. sanguineum','Pursh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16539','','','Ribes sanguineum var. melanocarpum (Greene) Jepson','Ribes sanguineum var. melanocarpum','(Greene) Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16538','','','Ribes sanguineum var. deductum Jepson','Ribes sanguineum var. deductum','Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6090','','','Ribes viscosissimum Pursh','Ribes viscosissimum','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6089','','','Ribes viscosissimum var. viscosissimum Pursh','Ribes viscosissimum var. viscosissimum','Pursh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6080','','','Ribes oxyacanthoides Linnaeus','Ribes oxyacanthoides','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22644','','','Ribes oxyacanthoides var. oxyacanthoides Linnaeus','Ribes oxyacanthoides var. oxyacanthoides','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6082','','','Ribes oxyacanthoides subsp. oxyacanthoides Linnaeus','Ribes oxyacanthoides subsp. oxyacanthoides','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22646','','','Ribes oxyacanthoides var. setosum (Lindley) Dorn','Ribes oxyacanthoides var. setosum','(Lindley) Dorn','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16540','','','Ribes setosum Lindley','Ribes setosum','Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6086','','','Ribes oxyacanthoides subsp. setosum (Lindley) Q.P. Sinnot','Ribes oxyacanthoides subsp. setosum','(Lindley) Q.P. Sinnot','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22645','','','Ribes oxyacanthoides var. irriguum (Douglas) Janczewski','Ribes oxyacanthoides var. irriguum','(Douglas) Janczewski','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16534','','','Grossularia irrigua (Douglas) Coville & Britton','Grossularia irrigua','(Douglas) Coville & Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16533','','','Ribes irriguum Douglas','Ribes irriguum','Douglas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6081','','','Ribes oxyacanthoides subsp. irriguum (Douglas) Q.P. Sinnott','Ribes oxyacanthoides subsp. irriguum','(Douglas) Q.P. Sinnott','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23853','','','Ribes oxyacanthoides var. cognatum (Greene) Morin','Ribes oxyacanthoides var. cognatum','(Greene) Morin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16531','','','Grossularia cognata (Greene) Coville & Britton','Grossularia cognata','(Greene) Coville & Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16530','','','Ribes cognatum Greene','Ribes cognatum','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6079','','','Ribes oxyacanthoides subsp. cognatum (Greene) Q.P. Sinnott','Ribes oxyacanthoides subsp. cognatum','(Greene) Q.P. Sinnott','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6064','','','Ribes divaricatum Douglas','Ribes divaricatum','Douglas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6063','','','Ribes divaricatum var. divaricatum Douglas','Ribes divaricatum var. divaricatum','Douglas','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22642','','','Grossularia divaricata (Douglas) Coville & Britton','Grossularia divaricata','(Douglas) Coville & Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6068','','','Ribes hudsonianum Richardson','Ribes hudsonianum','Richardson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6069','','','Ribes hudsonianum var. petiolare (Douglas) Janczewski','Ribes hudsonianum var. petiolare','(Douglas) Janczewski','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16520','','','Ribes petiolare Douglas','Ribes petiolare','Douglas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6067','','','Ribes hudsonianum var. hudsonianum Richardson','Ribes hudsonianum var. hudsonianum','Richardson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6071','','','Ribes inerme Rydberg','Ribes inerme','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6070','','','Ribes inerme var. inerme Rydberg','Ribes inerme var. inerme','Rydberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16523','','','Ribes divaricatum var. inerme (Rydberg) McMinn','Ribes divaricatum var. inerme','(Rydberg) McMinn','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16521','','','Ribes hirtellum var. inerme (Rydberg) Smiley','Ribes hirtellum var. inerme','(Rydberg) Smiley','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16522','','','Grossularia inermis (Rydberg) Coville & Britton','Grossularia inermis','(Rydberg) Coville & Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('139','','','Haloragaceae R. Brown','Haloragaceae','R. Brown','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1448','','','Myriophyllum Linnaeus','Myriophyllum','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~7M','','','Myriophyllum Brachytheca Schindler','Myriophyllum Brachytheca','Schindler','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27001','','','Myriophyllum sect. Tessaronia Schindler','Myriophyllum sect. Tessaronia','Schindler','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27002','','','Myriophyllum subsect. Spondylastrum Schindler','Myriophyllum subsect. Spondylastrum','Schindler','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6096','','','Myriophyllum farwellii Morong','Myriophyllum farwellii','Morong','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6104','','','Myriophyllum tenellum Bigelow','Myriophyllum tenellum','Bigelow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6100','','','Myriophyllum pinnatum (Walter) Britton, Sterns & Poggenburgh','Myriophyllum pinnatum','(Walter) Britton, Sterns & Poggenburgh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27019','','','Potamogeton pinnatum Walter','Potamogeton pinnatum','Walter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27020','','','Myriophyllum scabratum Michaux','Myriophyllum scabratum','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6099','','','Myriophyllum humile (Rafinesque) Morong','Myriophyllum humile','(Rafinesque) Morong','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27017','','','Myriophyllum ambiguum var. limosum Nuttall','Myriophyllum ambiguum var. limosum','Nuttall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27018','','','Myriophyllum procumbens Bigelow','Myriophyllum procumbens','Bigelow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16547','','','Burshia humilis Rafinesque','Burshia humilis','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6098','','','Myriophyllum hippuroides Nuttall ex Torrey & A. Gray','Myriophyllum hippuroides','Nuttall ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6097','','','Myriophyllum heterophyllum Michaux','Myriophyllum heterophyllum','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27003','','','Myriophyllum sect. Pentapteris de Candolle','Myriophyllum sect. Pentapteris','de Candolle','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27004','','','Myriophyllum subsect. Nudiflorum M.L. Moody & Les','Myriophyllum subsect. Nudiflorum','M.L. Moody & Les','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6105','','','Myriophyllum ussuriense (Regel) Maximowicz','Myriophyllum ussuriense','(Regel) Maximowicz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27016','','','Myriophyllum verticillatum var. ussuriense Regel','Myriophyllum verticillatum var. ussuriense','Regel','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27000','','','Myriophyllum subgen. Brachytheca Schindler','Myriophyllum subgen. Brachytheca','Schindler','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~7K','','','Myriophyllum (Myriophyllum) Linnaeus','Myriophyllum (Myriophyllum)','Linnaeus','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26996','','','Myriophyllum sect. Myriophyllum Linnaeus','Myriophyllum sect. Myriophyllum','Linnaeus','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26998','','','Myriophyllum subsect. Isophylleae (Schindler) M.L. Moody & Les','Myriophyllum subsect. Isophylleae','(Schindler) M.L. Moody & Les','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6106','','','Myriophyllum verticillatum Linnaeus','Myriophyllum verticillatum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32892','','','Myriophyllum pectinatum de Candolle','Myriophyllum pectinatum','de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32893','','','Myriophyllum verticillatum subsp. pectinatum (de Candolle) Arcangeli','Myriophyllum verticillatum subsp. pectinatum','(de Candolle) Arcangeli','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27008','','','Myriophyllum limosum Hectot ex de Candolle','Myriophyllum limosum','Hectot ex de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27009','','','Myriophyllum verticillatum var. cheneyi Fassett','Myriophyllum verticillatum var. cheneyi','Fassett','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27010','','','Myriophyllum verticillatum var. intermedium W.D.J. Koch','Myriophyllum verticillatum var. intermedium','W.D.J. Koch','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27011','','','Myriophyllum verticillatum subsp. pectinatum (Wallroth) Piper & Beattie nom. illeg.','Myriophyllum verticillatum subsp. pectinatum','(Wallroth) Piper & Beattie nom. illeg.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27012','','','Myriophyllum verticillatum var. pectinatum Wallroth','Myriophyllum verticillatum var. pectinatum','Wallroth','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26997','','','Myriophyllum subsect. Myriophyllum Linnaeus','Myriophyllum subsect. Myriophyllum','Linnaeus','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6102','','','Myriophyllum sibiricum Komarov','Myriophyllum sibiricum','Komarov','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27005','','','Myriophyllum spicatum var. capillaceum Lange','Myriophyllum spicatum var. capillaceum','Lange','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27006','','','Myriophyllum spicatum var. exalbescens (Fernald) Jepson','Myriophyllum spicatum var. exalbescens','(Fernald) Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27007','','','Myriophyllum spicatum var. muricatum Maximovicz','Myriophyllum spicatum var. muricatum','Maximovicz','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25399','','','Myriophyllum magdalenense Fernald','Myriophyllum magdalenense','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16549','','','Myriophyllum exalbescens Fernald','Myriophyllum exalbescens','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16550','','','Myriophyllum spicatum var. squamosum Laestadius ex Hartman','Myriophyllum spicatum var. squamosum','Laestadius ex Hartman','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16551','','','Myriophyllum spicatum subsp. exalbescens (Fernald) Hultén','Myriophyllum spicatum subsp. exalbescens','(Fernald) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6103','','','Myriophyllum spicatum Linnaeus','Myriophyllum spicatum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6094','','','Myriophyllum alterniflorum de Candolle','Myriophyllum alterniflorum','de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25400','','','Myriophyllum alterniflorum var. alterniflorum de Candolle','Myriophyllum alterniflorum var. alterniflorum','de Candolle','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25401','','','Myriophyllum alterniflorum var. americanum Pugsley','Myriophyllum alterniflorum var. americanum','Pugsley','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6101','','','Myriophyllum quitense Kunth','Myriophyllum quitense','Kunth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16548','','','Myriophyllum elatinoides Gaudichaud-Beaupré','Myriophyllum elatinoides','Gaudichaud-Beaupré','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26999','','','Myriophyllum sect. Pectinatum M.L. Moody & Les','Myriophyllum sect. Pectinatum','M.L. Moody & Les','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6095','','','Myriophyllum aquaticum (Vellozo) Verdcourt','Myriophyllum aquaticum','(Vellozo) Verdcourt','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27013','','','Enydria aquatica Vellozo','Enydria aquatica','Vellozo','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27014','','','Myriophyllum brasiliense Cambessèdes','Myriophyllum brasiliense','Cambessèdes','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27015','','','Myriophyllum proserpinacoides Gillies ex Hooker & Arnott','Myriophyllum proserpinacoides','Gillies ex Hooker & Arnott','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26995','','','Myriophyllum subgen. Myriophyllum Linnaeus','Myriophyllum subgen. Myriophyllum','Linnaeus','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1591','','','Proserpinaca Linnaeus','Proserpinaca','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6107','','','Proserpinaca intermedia Mackenzie','Proserpinaca intermedia','Mackenzie','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6108','','','Proserpinaca palustris Linnaeus','Proserpinaca palustris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27021','','','Proserpinaca palustris var. amblyogona Fernald','Proserpinaca palustris var. amblyogona','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16552','','','Proserpinaca palustris var. crebra Fernald & Griscom','Proserpinaca palustris var. crebra','Fernald & Griscom','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16553','','','Proserpinaca palustris var. palustris Linnaeus','Proserpinaca palustris var. palustris','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6109','','','Proserpinaca pectinata Lamarck','Proserpinaca pectinata','Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('216','','','Saxifragaceae de Jussieu','Saxifragaceae','de Jussieu','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('908','','','Boykinia Nuttall','Boykinia','Nuttall','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9225','','','Boykinia occidentalis Torrey & A. Gray','Boykinia occidentalis','Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21103','','','Saxifraga elata Nuttall','Saxifraga elata','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21102','','','Boykinia vancouverensis (Rydberg) F.K.G. Fedde','Boykinia vancouverensis','(Rydberg) F.K.G. Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21101','','','Boykinia occidentalis var. elata (Nuttall) A. Gray','Boykinia occidentalis var. elata','(Nuttall) A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21100','','','Boykinia occidentalis var. cincinnata (C.O. Rosendahl & Rydberg) C.O. Rosendahl','Boykinia occidentalis var. cincinnata','(C.O. Rosendahl & Rydberg) C.O. Rosendahl','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21107','','','Therofon vancouverense Rydberg','Therofon vancouverense','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21106','','','Therofon cincinnatum C.O. Rosendahl & Rydberg','Therofon cincinnatum','C.O. Rosendahl & Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21105','','','Therofon occidentalis Kuntze','Therofon occidentalis','Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21104','','','Therofon elatum (Nuttall) Greene','Therofon elatum','(Nuttall) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21095','','','Boykinia cincinnata (C.O. Rosendahl & P.A. Rydberg) F.K.G. Fedde','Boykinia cincinnata','(C.O. Rosendahl & P.A. Rydberg) F.K.G. Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21099','','','Boykinia nuttallii J.M. Macoun','Boykinia nuttallii','J.M. Macoun','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21098','','','Boykinia elata var. occidentalis C.O. Rosendahl ex H.G.A. Engler','Boykinia elata var. occidentalis','C.O. Rosendahl ex H.G.A. Engler','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21097','','','Boykinia elata var. cincinnata (C.O. Rosendahl & Rydberg) C.O. Rosendahl ex H.G.A. Engler','Boykinia elata var. cincinnata','(C.O. Rosendahl & Rydberg) C.O. Rosendahl ex H.G.A. Engler','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21096','','','Boykinia elata (Nuttall) E.L. Greene','Boykinia elata','(Nuttall) E.L. Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9226','','','Boykinia richardsonii (W.J. Hooker) J.T. Rothrock','Boykinia richardsonii','(W.J. Hooker) J.T. Rothrock','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21110','','','Therofon richardsonii (Hooker) Kuntze','Therofon richardsonii','(Hooker) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21108','','','Saxifraga richardsonii Hooker','Saxifraga richardsonii','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21109','','','Hemieva richardsonii (Hooker) Rafinesque','Hemieva richardsonii','(Hooker) Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('992','','','Chrysosplenium Linnaeus','Chrysosplenium','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9632','','','Chrysosplenium rosendahlii Packer','Chrysosplenium rosendahlii','Packer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21651','','','Chrysosplenium alternifolium var. rosendahlii (J.G. Packer) B. Boivin','Chrysosplenium alternifolium var. rosendahlii','(J.G. Packer) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9228','','','Chrysosplenium iowense Rydberg','Chrysosplenium iowense','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21111','','','Chrysosplenium alternifolium var. iowense (Rydberg) B. Boivin','Chrysosplenium alternifolium var. iowense','(Rydberg) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9227','','','Chrysosplenium americanum Schweinitz ex Hooker','Chrysosplenium americanum','Schweinitz ex Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9230','','','Chrysosplenium wrightii Franchet & Savatier','Chrysosplenium wrightii','Franchet & Savatier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21114','','','Chrysosplenium wrightii var. wrightii Franchet & Savatier','Chrysosplenium wrightii var. wrightii','Franchet & Savatier','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21115','','','Chrysosplenium wrightii var. beeringianum (Rose) Hara','Chrysosplenium wrightii var. beeringianum','(Rose) Hara','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9229','','','Chrysosplenium tetrandrum Th. Fries','Chrysosplenium tetrandrum','Th. Fries','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21112','','','Chrysosplenium alternifolium subsp. tetrandrum (Th. Fries) Hultén','Chrysosplenium alternifolium subsp. tetrandrum','(Th. Fries) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21113','','','Chrysosplenium alternifolium var. tetrandrum N. Lund ex Malmgren','Chrysosplenium alternifolium var. tetrandrum','N. Lund ex Malmgren','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1247','','','Heuchera Linnaeus','Heuchera','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9240','','','Heuchera parvifolia Nuttall ex Torrey & A. Gray','Heuchera parvifolia','Nuttall ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28992','','','Heuchera parvifolia var. dissecta M.E. Jones','Heuchera parvifolia var. dissecta','M.E. Jones','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21144','','','Heuchera parvifolia var. nivalis (Rosendahl, Butters & Lakela) Á. Löve, D. Löve & Kapoor','Heuchera parvifolia var. nivalis','(Rosendahl, Butters & Lakela) Á. Löve, D. Löve & Kapoor','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21145','','','Heuchera parvifolia var. utahensis (Rydberg) Garrett','Heuchera parvifolia var. utahensis','(Rydberg) Garrett','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21146','','','Heuchera utahensis Rydberg','Heuchera utahensis','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21140','','','Heuchera flavescens Rydberg','Heuchera flavescens','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21141','','','Heuchera nivalis Rosendahl, Butters & Lakela','Heuchera nivalis','Rosendahl, Butters & Lakela','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21142','','','Heuchera parvifolia var. arizonica Rosendahl, Butters & Lakela','Heuchera parvifolia var. arizonica','Rosendahl, Butters & Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21143','','','Heuchera parvifolia var. flavescens (Rydberg) Rosendahl, Butters & Lakela','Heuchera parvifolia var. flavescens','(Rydberg) Rosendahl, Butters & Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21137','','','Heuchera duranii Bacigalupi','Heuchera duranii','Bacigalupi','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21139','','','Heuchera flabellifolia var. subsecta Rosendahl, Butters & Lakela','Heuchera flabellifolia var. subsecta','Rosendahl, Butters & Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21138','','','Heuchera flabellifolia Rydberg','Heuchera flabellifolia','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9237','','','Heuchera glabra Willdenow ex Roemer & Schultes','Heuchera glabra','Willdenow ex Roemer & Schultes','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9234','','','Heuchera americana Linnaeus','Heuchera americana','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9233','','','Heuchera americana var. americana Linnaeus','Heuchera americana var. americana','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21125','','','Heuchera curtisii Torrey & A. Gray','Heuchera curtisii','Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21124','','','Heuchera calycosa Small','Heuchera calycosa','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21127','','','Heuchera lancipetala Rydberg','Heuchera lancipetala','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21126','','','Heuchera curtisii var. crenata Rydberg','Heuchera curtisii var. crenata','Rydberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21122','','','Heuchera americana var. heteradenia Fernald','Heuchera americana var. heteradenia','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21123','','','Heuchera americana var. subtruncata Fernald','Heuchera americana var. subtruncata','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21121','','','Heuchera americana var. brevipetala Rosendahl, Butters & Lakela','Heuchera americana var. brevipetala','Rosendahl, Butters & Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9241','','','Heuchera richardsonii R. Brown','Heuchera richardsonii','R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21148','','','Heuchera richardsonii var. affinis Rosendahl, Butters & Lakela','Heuchera richardsonii var. affinis','Rosendahl, Butters & Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21149','','','Heuchera richardsonii var. grayana Rosendahl, Butters & Lakela','Heuchera richardsonii var. grayana','Rosendahl, Butters & Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21150','','','Heuchera richardsonii var. hispidior Rosendahl, Butters & Lakela','Heuchera richardsonii var. hispidior','Rosendahl, Butters & Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21147','','','Heuchera hispida','Heuchera hispida','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9236','','','Heuchera cylindrica Douglas','Heuchera cylindrica','Douglas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21133','','','Heuchera woodsiaphila P.J. Alexander','Heuchera woodsiaphila','P.J. Alexander','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21132','','','Heuchera ovalifolia Torrey & A. Gray','Heuchera ovalifolia','Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21134','','','Heuchera cylindrica var. septentrionalis Rosendahl, Butters & Lakela','Heuchera cylindrica var. septentrionalis','Rosendahl, Butters & Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21129','','','Heuchera cylindrica var. glabella (Torrey & A. Gray) Wheelock','Heuchera cylindrica var. glabella','(Torrey & A. Gray) Wheelock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21128','','','Heuchera cylindrica var. alpina S. Watson','Heuchera cylindrica var. alpina','S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21131','','','Heuchera glabella Torrey & A. Gray','Heuchera glabella','Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21130','','','Heuchera cylindrica var. orbicularis (Rosendahl, Butters & Lakela) Calder & Savile','Heuchera cylindrica var. orbicularis','(Rosendahl, Butters & Lakela) Calder & Savile','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9235','','','Heuchera chlorantha Piper','Heuchera chlorantha','Piper','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9239','','','Heuchera micrantha Douglas ex Lindley','Heuchera micrantha','Douglas ex Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9238','','','Heuchera micrantha var. diversifolia (Rydberg) Rosendahl, Butters & Lakela','Heuchera micrantha var. diversifolia','(Rydberg) Rosendahl, Butters & Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21136','','','Heuchera micrantha var. pacifica Rosendahl, Butters & Lakela','Heuchera micrantha var. pacifica','Rosendahl, Butters & Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21135','','','Heuchera diversifolia Rydberg','Heuchera diversifolia','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1022','','','Conimitella Rydberg','Conimitella','Rydberg','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9231','','','Conimitella williamsii (D.C. Eaton) Rydberg','Conimitella williamsii','(D.C. Eaton) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21116','','','Heuchera williamsii D.C. Eaton','Heuchera williamsii','D.C. Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21117','','','Lithophragma williamsii Greene','Lithophragma williamsii','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1131','','','Elmera Rydberg','Elmera','Rydberg','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9232','','','Elmera racemosa (S. Watson) Rydberg','Elmera racemosa','(S. Watson) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21118','','','Heuchera racemosa S. Watson','Heuchera racemosa','S. Watson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21119','','','Tellima racemosa Greene','Tellima racemosa','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21120','','','Elmera racemosa var. puberulenta C.L. Hitchcock','Elmera racemosa var. puberulenta','C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1655','','','Saxifraga Linnaeus','Saxifraga','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2326','','','Saxifraga sect. Saxifraga','Saxifraga sect. Saxifraga','','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9737','','','Saxifraga rosacea Moench','Saxifraga rosacea','Moench','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9284','','','Saxifraga cespitosa Linnaeus','Saxifraga cespitosa','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30261','','','Saxifraga cespitosa subsp. cespitosa Linnaeus','Saxifraga cespitosa subsp. cespitosa','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29329','','','Saxifraga cespitosa var. uniflora (R. Brown) Hooker & Arnott','Saxifraga cespitosa var. uniflora','(R. Brown) Hooker & Arnott','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23605','','','Muscaria cespitosa subsp. exaratoides (Simmons) Á. Löve & D. Löve','Muscaria cespitosa subsp. exaratoides','(Simmons) Á. Löve & D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23606','','','Muscaria cespitosa (Linnaeus) Haworth','Muscaria cespitosa','(Linnaeus) Haworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21287','','','Saxifraga cespitosa var. minima Blankinship','Saxifraga cespitosa var. minima','Blankinship','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21288','','','Saxifraga cespitosa subsp. monticola (Small) A.E. Porsild','Saxifraga cespitosa subsp. monticola','(Small) A.E. Porsild','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21289','','','Saxifraga cespitosa subsp. sileneflora (Sternberg ex Chamisso) Hultén','Saxifraga cespitosa subsp. sileneflora','(Sternberg ex Chamisso) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21290','','','Saxifraga cespitosa subsp. subgemmifera Engler & Irmscher','Saxifraga cespitosa subsp. subgemmifera','Engler & Irmscher','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21291','','','Saxifraga cespitosa var. subgemmifera (Engler & Irmscher) C.L. Hitchcock','Saxifraga cespitosa var. subgemmifera','(Engler & Irmscher) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21292','','','Saxifraga cespitosa subsp. uniflora (R. Brown) A.E. Porsild','Saxifraga cespitosa subsp. uniflora','(R. Brown) A.E. Porsild','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21293','','','Saxifraga groenlandica Linnaeus','Saxifraga groenlandica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21282','','','Saxifraga cespitosa subsp. decipiens (Ehrhart) Engler & Irmscher','Saxifraga cespitosa subsp. decipiens','(Ehrhart) Engler & Irmscher','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21281','','','Muscaria monticola Small','Muscaria monticola','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21280','','','Muscaria micropetala Small','Muscaria micropetala','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21279','','','Muscaria delicatula Small','Muscaria delicatula','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21286','','','Saxifraga cespitosa var. lemmonii Engler & Irmscher','Saxifraga cespitosa var. lemmonii','Engler & Irmscher','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21285','','','Saxifraga cespitosa subsp. laxiuscula (Engler & Irmscher) Á. Löve & D. Löve','Saxifraga cespitosa subsp. laxiuscula','(Engler & Irmscher) Á. Löve & D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21284','','','Saxifraga cespitosa subsp. exaratoides (Simmons) Engler & Irmscher','Saxifraga cespitosa subsp. exaratoides','(Simmons) Engler & Irmscher','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21283','','','Saxifraga cespitosa var. emarginata (Small) Rosendahl','Saxifraga cespitosa var. emarginata','(Small) Rosendahl','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9306','','','Saxifraga tridactylites Linnaeus','Saxifraga tridactylites','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9278','','','Saxifraga adscendens Linnaeus','Saxifraga adscendens','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21267','','','Saxifraga adscendens var. oregonensis (Rafinesque) Breitung','Saxifraga adscendens var. oregonensis','(Rafinesque) Breitung','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21268','','','Saxifraga oregonensis (Rafinesque) A. Nelson','Saxifraga oregonensis','(Rafinesque) A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21265','','','Muscaria adscendens (Linnaeus) Small','Muscaria adscendens','(Linnaeus) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21266','','','Saxifraga adscendens subsp. oregonensis (Rafinesque) Bacigalupi','Saxifraga adscendens subsp. oregonensis','(Rafinesque) Bacigalupi','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2330','','','Saxifraga sect. Ciliatae Haworth','Saxifraga sect. Ciliatae','Haworth','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9288','','','Saxifraga flagellaris Willdenow','Saxifraga flagellaris','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9287','','','Saxifraga flagellaris subsp. platysepala (Trautvetter) A.E. Porsild','Saxifraga flagellaris subsp. platysepala','(Trautvetter) A.E. Porsild','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21300','','','Saxifraga platysepala (Trautvetter) Tolmie','Saxifraga platysepala','(Trautvetter) Tolmie','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21301','','','Saxifraga flagellaris var. platysepala (Trautvetter) A.T. von Middendorff','Saxifraga flagellaris var. platysepala','(Trautvetter) A.T. von Middendorff','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9289','','','Saxifraga flagellaris subsp. setigera (Pursh) Tolmatchev','Saxifraga flagellaris subsp. setigera','(Pursh) Tolmatchev','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21302','','','Saxifraga setigera Pursh','Saxifraga setigera','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9285','','','Saxifraga eschscholtzii Sternberg','Saxifraga eschscholtzii','Sternberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9303','','','Saxifraga serpyllifolia Pursh','Saxifraga serpyllifolia','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21323','','','Saxifraga serpyllifolia var. purpurea Hultén','Saxifraga serpyllifolia var. purpurea','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9290','','','Saxifraga hirculus Linnaeus','Saxifraga hirculus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21304','','','Saxifraga hirculus subsp. coloradensis O. Hedberg','Saxifraga hirculus subsp. coloradensis','O. Hedberg','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21303','','','Leptasea hirculus (Linnaeus) Small','Leptasea hirculus','(Linnaeus) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21306','','','Saxifraga hirculus subsp. propinqua (R. Brown) Á. Löve & D. Löve','Saxifraga hirculus subsp. propinqua','(R. Brown) Á. Löve & D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21305','','','Saxifraga hirculus subsp. compacta O. Hedberg','Saxifraga hirculus subsp. compacta','O. Hedberg','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21308','','','Leptasea alaskana Small','Leptasea alaskana','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21307','','','Saxifraga hirculus var. propinqua (R. Brown) Simmons','Saxifraga hirculus var. propinqua','(R. Brown) Simmons','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2329','','','Saxifraga sect. Mesogyne Sternberg','Saxifraga sect. Mesogyne','Sternberg','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9738','','','Saxifraga sibirica Linnaeus','Saxifraga sibirica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9302','','','Saxifraga rivularis Linnaeus','Saxifraga rivularis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9826','','','Saxifraga rivularis subsp. arctolitoralis (Jurtzev & V.V. Petrovsky) M.H. Jørgensen & Elven','Saxifraga rivularis subsp. arctolitoralis','(Jurtzev & V.V. Petrovsky) M.H. Jørgensen & Elven','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21879','','','Saxifraga arctolitoralis Jurtzev & V.V. Petrovsky','Saxifraga arctolitoralis','Jurtzev & V.V. Petrovsky','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9301','','','Saxifraga rivularis subsp. rivularis Linnaeus','Saxifraga rivularis subsp. rivularis','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9299','','','Saxifraga radiata Small','Saxifraga radiata','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21321','','','Saxifraga exilis Stephan ex Sternberg','Saxifraga exilis','Stephan ex Sternberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9291','','','Saxifraga hyperborea R. Brown','Saxifraga hyperborea','R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21310','','','Saxifraga rivularis var. flexuosa (Sternberg) Engler & Irmscher','Saxifraga rivularis var. flexuosa','(Sternberg) Engler & Irmscher','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21309','','','Saxifraga flexuosa Sternberg','Saxifraga flexuosa','Sternberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21312','','','Saxifraga rivularis var. hyperborea (R. Brown) Hooker','Saxifraga rivularis var. hyperborea','(R. Brown) Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21311','','','Saxifraga rivularis subsp. hyperborea (R. Brown) Dorn','Saxifraga rivularis subsp. hyperborea','(R. Brown) Dorn','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21313','','','Saxifraga rivularis var. purpurascens Lange','Saxifraga rivularis var. purpurascens','Lange','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9283','','','Saxifraga cernua Linnaeus','Saxifraga cernua','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26217','','','Saxifraga cernua var. latibracteata Fernald & Weatherby','Saxifraga cernua var. latibracteata','Fernald & Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33508','','','Saxifraga sect. Gymnopera D. Don ex Lindley','Saxifraga sect. Gymnopera','D. Don ex Lindley','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9739','','','Saxifraga umbrosa Linnaeus','Saxifraga umbrosa','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9735','','','Saxifraga × geum Linnaeus','Saxifraga × geum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21755','','','Micranthes geum (Linnaeus) Small','Micranthes geum','(Linnaeus) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9736','','','Saxifraga hirsuta Linnaeus','Saxifraga hirsuta','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2331','','','Saxifraga sect. Irregulares Haworth','Saxifraga sect. Irregulares','Haworth','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9292','','','Saxifraga mertensiana Bongard','Saxifraga mertensiana','Bongard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21314','','','Saxifraga mertensiana var. eastwoodiae (Small) Engler & Irmscher','Saxifraga mertensiana var. eastwoodiae','(Small) Engler & Irmscher','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2332','','','Saxifraga sect. Porphyrion Tausch','Saxifraga sect. Porphyrion','Tausch','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9295','','','Saxifraga oppositifolia Linnaeus','Saxifraga oppositifolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9296','','','Saxifraga oppositifolia subsp. smalliana (Engler & Irmscher) Hultén','Saxifraga oppositifolia subsp. smalliana','(Engler & Irmscher) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22687','','','Saxifraga pulvinata Small','Saxifraga pulvinata','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21317','','','Saxifraga oppositifolia subsp. glandulisepala Hultén','Saxifraga oppositifolia subsp. glandulisepala','Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9294','','','Saxifraga oppositifolia subsp. oppositifolia Linnaeus','Saxifraga oppositifolia subsp. oppositifolia','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21316','','','Antiphylla oppositifolia (Linnaeus) Fourreau','Antiphylla oppositifolia','(Linnaeus) Fourreau','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9293','','','Saxifraga nathorstii (Dusén) Hayek','Saxifraga nathorstii','(Dusén) Hayek','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21315','','','Saxifraga oppositifolia var. nathorstii Dusén','Saxifraga oppositifolia var. nathorstii','Dusén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9279','','','Saxifraga aizoides Linnaeus','Saxifraga aizoides','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21269','','','Saxifraga van-bruntiae Small','Saxifraga van-bruntiae','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2327','','','Saxifraga sect. Xanthizoon Grisebach','Saxifraga sect. Xanthizoon','Grisebach','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2333','','','Saxifraga sect. Ligulatae Haworth','Saxifraga sect. Ligulatae','Haworth','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9298','','','Saxifraga paniculata Miller','Saxifraga paniculata','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9297','','','Saxifraga paniculata subsp. laestadii (Neuman) T. Karlsson','Saxifraga paniculata subsp. laestadii','(Neuman) T. Karlsson','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21320','','','Saxifraga paniculata subsp. neogaea (Butters) D. Löve','Saxifraga paniculata subsp. neogaea','(Butters) D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21319','','','Saxifraga aizoon var. neogaea Butters','Saxifraga aizoon var. neogaea','Butters','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21318','','','Saxifraga aizoon','Saxifraga aizoon','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33507','','','Saxifraga sect. Bronchiales DeChaine','Saxifraga sect. Bronchiales','DeChaine','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9281','','','Saxifraga bronchialis Linnaeus','Saxifraga bronchialis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9304','','','Saxifraga taylorii Calder & Savile','Saxifraga taylorii','Calder & Savile','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21278','','','Saxifraga funstonii (Small) Fedde','Saxifraga funstonii','(Small) Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30478','','','Saxifraga firma Litvinov ex Losinskaja','Saxifraga firma','Litvinov ex Losinskaja','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21273','','','Leptasea funstonii Small','Leptasea funstonii','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21277','','','Saxifraga codyana Zhmylev','Saxifraga codyana','Zhmylev','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21276','','','Saxifraga bronchialis var. purpureomaculata Hultén','Saxifraga bronchialis var. purpureomaculata','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21275','','','Saxifraga bronchialis var. funstonii (Small) Rosendahl','Saxifraga bronchialis var. funstonii','(Small) Rosendahl','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21274','','','Saxifraga bronchialis subsp. codyana (Zhmylev) Cody','Saxifraga bronchialis subsp. codyana','(Zhmylev) Cody','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9282','','','Saxifraga bronchialis subsp. funstonii (Small) Hultén','Saxifraga bronchialis subsp. funstonii','(Small) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21270','','','Saxifraga austromontana Wiegand','Saxifraga austromontana','Wiegand','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21272','','','Saxifraga bronchialis var. austromontana (Wiegand) M. Peck','Saxifraga bronchialis var. austromontana','(Wiegand) M. Peck','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21271','','','Ciliaria austromontana (Wiegand) W.A. Weber','Ciliaria austromontana','(Wiegand) W.A. Weber','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9280','','','Saxifraga bronchialis subsp. austromontana (Wiegand) Piper','Saxifraga bronchialis subsp. austromontana','(Wiegand) Piper','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9305','','','Saxifraga tricuspidata Rottbøll','Saxifraga tricuspidata','Rottbøll','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30479','','','Saxifraga tricuspidata var. micrantha Sternberg','Saxifraga tricuspidata var. micrantha','Sternberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30480','','','Saxifraga tricuspidata var. subintegrifolia Abromeit','Saxifraga tricuspidata var. subintegrifolia','Abromeit','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21324','','','Leptasea tricuspidata (Rottbøll) Haworth','Leptasea tricuspidata','(Rottbøll) Haworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30481','','','Saxifraga cherlerioides D. Don','Saxifraga cherlerioides','D. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30483','','','Saxifraga bronchialis subsp. cherlerioides (D. Don) Hultén','Saxifraga bronchialis subsp. cherlerioides','(D. Don) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30484','','','Saxifraga bronchialis var. cherlerioides (D. Don) Engler','Saxifraga bronchialis var. cherlerioides','(D. Don) Engler','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30485','','','Saxifraga pseudoburseriana Fischer ex Torrey & A. Gray','Saxifraga pseudoburseriana','Fischer ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30482','','','Leptasea cherlerioides (D. Don) Small','Leptasea cherlerioides','(D. Don) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1426','','','Mitella Linnaeus','Mitella','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9274','','','Mitella nuda Linnaeus','Mitella nuda','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21258','','','Mitella prostrata Michaux','Mitella prostrata','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9277','','','Mitella trifida Graham','Mitella trifida','Graham','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21263','','','Ozomelis trifida (Graham) Rydberg','Ozomelis trifida','(Graham) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21264','','','Mitella trifida var. violacea (Rydberg) Rosendahl','Mitella trifida var. violacea','(Rydberg) Rosendahl','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21261','','','Ozomelis anomola (Piper) Rydberg','Ozomelis anomola','(Piper) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21262','','','Ozomelis micrantha (Piper) Rydberg','Ozomelis micrantha','(Piper) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9272','','','Mitella caulescens Nuttall','Mitella caulescens','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21257','','','Mitellastra caulescens (Nuttall) Howell','Mitellastra caulescens','(Nuttall) Howell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9273','','','Mitella diphylla Linnaeus','Mitella diphylla','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1358','','','Lithophragma (Nuttall) Torrey & A. Gray','Lithophragma','(Nuttall) Torrey & A. Gray','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9245','','','Lithophragma tenellum Nuttall ex Torrey & A. Gray','Lithophragma tenellum','Nuttall ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21166','','','Tellima tenella (Nuttall) Steudel','Tellima tenella','(Nuttall) Steudel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21165','','','Lithophragma thompsonni Hoover','Lithophragma thompsonni','Hoover','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21164','','','Lithophragma tenellum var. thompsonii (Hoover) C.L. Hitchcock','Lithophragma tenellum var. thompsonii','(Hoover) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21163','','','Lithophragma rupicola Greene','Lithophragma rupicola','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21162','','','Lithophragma brevilobum Rydberg','Lithophragma brevilobum','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21161','','','Lithophragma australe Rydberg','Lithophragma australe','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9243','','','Lithophragma glabrum Nuttall ex Torrey & A. Gray','Lithophragma glabrum','Nuttall ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21152','','','Lithophragma bulbiferum Rydberg','Lithophragma bulbiferum','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21153','','','Lithophragma glabrum var. bulbiferum (Rydberg) Jepson','Lithophragma glabrum var. bulbiferum','(Rydberg) Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21154','','','Lithophragma tenellum var. floridum Suksdorf','Lithophragma tenellum var. floridum','Suksdorf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21155','','','Tellima bulbifera (Rydberg) Fedde','Tellima bulbifera','(Rydberg) Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21156','','','Tellima glabra (Nuttall) Steudel','Tellima glabra','(Nuttall) Steudel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9244','','','Lithophragma parviflorum (Hooker) Nuttall ex Torrey & A. Gray','Lithophragma parviflorum','(Hooker) Nuttall ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30002','','','Lithophragma parviflorum var. parviflorum (Hooker) Nuttall ex Torrey & A. Gray','Lithophragma parviflorum var. parviflorum','(Hooker) Nuttall ex Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21160','','','Pleurendotria reniformis Rafinesque','Pleurendotria reniformis','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21159','','','Lithophragma austromontanum A. Heller','Lithophragma austromontanum','A. Heller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21158','','','Lithophragma anemonoides Greene','Lithophragma anemonoides','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21157','','','Tellima parviflora Hooker','Tellima parviflora','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1329','','','Leptarrhena R. Brown','Leptarrhena','R. Brown','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9242','','','Leptarrhena pyrolifolia (D. Don) R. Brown ex Seringe','Leptarrhena pyrolifolia','(D. Don) R. Brown ex Seringe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21151','','','Saxifraga pyrolifolia D. Don','Saxifraga pyrolifolia','D. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1730','','','Suksdorfia A. Gray','Suksdorfia','A. Gray','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9307','','','Suksdorfia ranunculifolia (Hooker) Engler','Suksdorfia ranunculifolia','(Hooker) Engler','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21326','','','Hemieva ranunculifolia (Hooker) Rafinesque','Hemieva ranunculifolia','(Hooker) Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21325','','','Saxifraga ranunculifolia Hooker','Saxifraga ranunculifolia','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9308','','','Suksdorfia violacea A. Gray','Suksdorfia violacea','A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1744','','','Tellima R. Brown','Tellima','R. Brown','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9310','','','Tellima grandiflora (Pursh) Douglas ex Lindley','Tellima grandiflora','(Pursh) Douglas ex Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21333','','','Tellima odorata Howell','Tellima odorata','Howell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21332','','','Mitella grandiflora Pursh','Mitella grandiflora','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1743','','','Telesonix Rafinesque','Telesonix','Rafinesque','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9309','','','Telesonix heucheriformis (Rydberg) Rydberg','Telesonix heucheriformis','(Rydberg) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21331','','','Telesonix jamesii var. heucheriforme (P.A. Rydberg) R.C.F. Bacigalupi','Telesonix jamesii var. heucheriforme','(P.A. Rydberg) R.C.F. Bacigalupi','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21330','','','Saxifraga heucheriforme (P.A. Rydberg) M.E. Jones','Saxifraga heucheriforme','(P.A. Rydberg) M.E. Jones','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21329','','','Boykinia jamesii var. heucheriformis (P.A. Rydberg) H.G.A. Engler','Boykinia jamesii var. heucheriformis','(P.A. Rydberg) H.G.A. Engler','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21328','','','Boykinia heucheriformis (P.A. Rydberg) C.O. Rosendahl','Boykinia heucheriformis','(P.A. Rydberg) C.O. Rosendahl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21327','','','Therofon heucheriforme P.A. Rydberg','Therofon heucheriforme','P.A. Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1760','','','Tiarella Linnaeus','Tiarella','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9311','','','Tiarella cordifolia Linnaeus','Tiarella cordifolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21334','','','Tiarella cordifolia var. austrina Lakela','Tiarella cordifolia var. austrina','Lakela','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21337','','','Tiarella macrophylla Small','Tiarella macrophylla','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21336','','','Tiarella cordifolia var. collina Wherry','Tiarella cordifolia var. collina','Wherry','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9313','','','Tiarella trifoliata Linnaeus','Tiarella trifoliata','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9312','','','Tiarella trifoliata var. laciniata (Hooker) Wheelock','Tiarella trifoliata var. laciniata','(Hooker) Wheelock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21338','','','Tiarella laciniata Hooker','Tiarella laciniata','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9315','','','Tiarella trifoliata var. unifoliata (Hooker) Kurtz','Tiarella trifoliata var. unifoliata','(Hooker) Kurtz','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21341','','','Tiarella trifoliata subsp. unifoliata (Hooker) P.M. Keru','Tiarella trifoliata subsp. unifoliata','(Hooker) P.M. Keru','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21339','','','Tiarella unifoliata Hooker','Tiarella unifoliata','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21340','','','Tiarella californica (Kellogg) Rydberg','Tiarella californica','(Kellogg) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9314','','','Tiarella trifoliata var. trifoliata Linnaeus','Tiarella trifoliata var. trifoliata','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32794','','','Tiarella stolonifera G.L. Nesom','Tiarella stolonifera','G.L. Nesom','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21335','','','Tiarella cordifolia var. bracteata Farwell','Tiarella cordifolia var. bracteata','Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1764','','','Tolmiea Torrey & A. Gray','Tolmiea','Torrey & A. Gray','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9316','','','Tolmiea menziesii (Pursh) Torrey & A. Gray','Tolmiea menziesii','(Pursh) Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21342','','','Tiarella menziesii Pursh','Tiarella menziesii','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1851','','','Micranthes Hawort','Micranthes','Hawort','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33503','','','Micranthes sect. Intermediae (Engler & Irmscher) Tkach','Micranthes sect. Intermediae','(Engler & Irmscher) Tkach','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9269','','','Micranthes tolmiei (Torrey & A. Gray) Brouillet & Gornall','Micranthes tolmiei','(Torrey & A. Gray) Brouillet & Gornall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21252','','','Saxifraga tolmiei var. ledifolia (Greene) Engler & Irmscher','Saxifraga tolmiei var. ledifolia','(Greene) Engler & Irmscher','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21251','','','Saxifraga tolmiei Torrey & A. Gray','Saxifraga tolmiei','Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33504','','','Micranthes sect. Stellares (Engler & Irmscher) Tkach','Micranthes sect. Stellares','(Engler & Irmscher) Tkach','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9246','','','Micranthes foliolosa (R. Brown) Gornall','Micranthes foliolosa','(R. Brown) Gornall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27258','','','Saxifraga foliolosa var. foliolosa R. Brown','Saxifraga foliolosa var. foliolosa','R. Brown','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21172','','','Saxifraga comosa (Retzius) J. Fellman','Saxifraga comosa','(Retzius) J. Fellman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21171','','','Spatularia foliolosa (R. Brown) Small','Spatularia foliolosa','(R. Brown) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21170','','','Saxifraga stellaris subsp. comosa (Retzius) Braun-Blanquet','Saxifraga stellaris subsp. comosa','(Retzius) Braun-Blanquet','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21169','','','Saxifraga stellaris var. comosa Retzius','Saxifraga stellaris var. comosa','Retzius','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21168','','','Saxifraga foliolosa var. multiflora Hultén','Saxifraga foliolosa var. multiflora','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21167','','','Saxifraga foliolosa R. Brown','Saxifraga foliolosa','R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9266','','','Micranthes stellaris (Linnaeus) Galasso, Banfi & Soldano','Micranthes stellaris','(Linnaeus) Galasso, Banfi & Soldano','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21247','','','Spatularia stellaris (Linnaeus) Haworth','Spatularia stellaris','(Linnaeus) Haworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21246','','','Saxifraga stellaris Linnaeus','Saxifraga stellaris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9286','','','Micranthes ferruginea (Graham) Brouillet & Gornall','Micranthes ferruginea','(Graham) Brouillet & Gornall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21294','','','Saxifraga ferruginea Graham','Saxifraga ferruginea','Graham','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21295','','','Spatularia ferruginea (Graham) Small','Spatularia ferruginea','(Graham) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21296','','','Saxifraga ferruginea var. ferruginea Graham','Saxifraga ferruginea var. ferruginea','Graham','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21297','','','Saxifraga ferruginea var. vreelandii (Small) Engler','Saxifraga ferruginea var. vreelandii','(Small) Engler','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21298','','','Saxifraga ferruginea var. macounii Engler & Irmscher','Saxifraga ferruginea var. macounii','Engler & Irmscher','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21299','','','Saxifraga newcombei (Small) Engler & Irmscher','Saxifraga newcombei','(Small) Engler & Irmscher','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2324','','','Micranthes sect. Micranthes (Haworth) D. Don','Micranthes sect. Micranthes','(Haworth) D. Don','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9262','','','Micranthes pensylvanica (Linnaeus) Haworth','Micranthes pensylvanica','(Linnaeus) Haworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22688','','','Micranthes pensylvanica var. purpuripetala (A.M. Johnson) Bush','Micranthes pensylvanica var. purpuripetala','(A.M. Johnson) Bush','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21232','','','Saxifraga pensylvanica subsp. interior G.W. Burns','Saxifraga pensylvanica subsp. interior','G.W. Burns','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21233','','','Saxifraga pensylvanica subsp. tenuirostrata G.W. Burns','Saxifraga pensylvanica subsp. tenuirostrata','G.W. Burns','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21234','','','Saxifraga pensylvanica var. purpuripetala (A.M. Johnson) Bush','Saxifraga pensylvanica var. purpuripetala','(A.M. Johnson) Bush','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21235','','','Saxifraga purpuripetala A.M. Johnson','Saxifraga purpuripetala','A.M. Johnson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21229','','','Saxifraga pensylvanica Linnaeus','Saxifraga pensylvanica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21230','','','Saxifraga forbesii Vasey','Saxifraga forbesii','Vasey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21231','','','Saxifraga pensylvanica var. forbesii (Vasey) Engler & Irmscher','Saxifraga pensylvanica var. forbesii','(Vasey) Engler & Irmscher','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9247','','','Micranthes gaspensis (Fernald) Small','Micranthes gaspensis','(Fernald) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21174','','','Saxifraga nivalis var. gaspensis (Fernald) B. Boivin','Saxifraga nivalis var. gaspensis','(Fernald) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21173','','','Saxifraga gaspensis Fernald','Saxifraga gaspensis','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9258','','','Micranthes nivalis (Linnaeus) Small','Micranthes nivalis','(Linnaeus) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25422','','','Saxifraga nivalis var. nivalis Linnaeus','Saxifraga nivalis var. nivalis','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21211','','','Saxifraga nivalis Linnaeus','Saxifraga nivalis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9259','','','Micranthes occidentalis (S. Watson) Small','Micranthes occidentalis','(S. Watson) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21220','','','Saxifraga saximontana E. Nelson','Saxifraga saximontana','E. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21219','','','Saxifraga reflexa subsp. occidentalis (S. Watson) Hultén','Saxifraga reflexa subsp. occidentalis','(S. Watson) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21218','','','Saxifraga allenii (Small) Fedde','Saxifraga allenii','(Small) Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21217','','','Saxifraga occidentalis var. wallowensis Peck','Saxifraga occidentalis var. wallowensis','Peck','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21216','','','Saxifraga occidentalis var. allenii (Small) C.L. Hitchcock','Saxifraga occidentalis var. allenii','(Small) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21215','','','Saxifraga occidentalis var. occidentalis S. Watson','Saxifraga occidentalis var. occidentalis','S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21214','','','Saxifraga occidentalis S. Watson','Saxifraga occidentalis','S. Watson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9263','','','Micranthes reflexa (Hooker) Small','Micranthes reflexa','(Hooker) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21237','','','Micranthes yukonensis Small','Micranthes yukonensis','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21236','','','Saxifraga reflexa Hooker','Saxifraga reflexa','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9264','','','Micranthes rufidula Small','Micranthes rufidula','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21241','','','Saxifraga occidentalis subsp. rufidula (Small) Bacigalupi','Saxifraga occidentalis subsp. rufidula','(Small) Bacigalupi','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21240','','','Micranthes aequidentata Small','Micranthes aequidentata','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21242','','','Saxifraga occidentalis var. rufidula (Small) Hitchcock','Saxifraga occidentalis var. rufidula','(Small) Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21239','','','Saxifraga aequidentata (Small) Rosendahl','Saxifraga aequidentata','(Small) Rosendahl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21238','','','Saxifraga rufidula (Small) Macoun','Saxifraga rufidula','(Small) Macoun','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9267','','','Micranthes tenuis (Wahlenberg) Small','Micranthes tenuis','(Wahlenberg) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21249','','','Saxifraga nivalis var. tenuis Wahlenberg','Saxifraga nivalis var. tenuis','Wahlenberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21248','','','Saxifraga tenuis (Wahlenberg) Harry Smith ex Lindman','Saxifraga tenuis','(Wahlenberg) Harry Smith ex Lindman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9268','','','Micranthes tischii (Skelly) Brouillet & Gornall','Micranthes tischii','(Skelly) Brouillet & Gornall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21250','','','Saxifraga tischii Skelly','Saxifraga tischii','Skelly','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9270','','','Micranthes virginiensis (Michaux) Small','Micranthes virginiensis','(Michaux) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21254','','','Saxifraga virginiensis var. virginiensis Michaux','Saxifraga virginiensis var. virginiensis','Michaux','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21255','','','Spatularia virginiensis (Michaux) Á. Löve & D. Löve','Spatularia virginiensis','(Michaux) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21253','','','Saxifraga virginiensis Michaux','Saxifraga virginiensis','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30407','','','Micranthes rufopilosa (Hultén) D.F. Murray & Elven','Micranthes rufopilosa','(Hultén) D.F. Murray & Elven','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21213','','','Saxifraga rufopilosa (Hultén) A.E. Porsild','Saxifraga rufopilosa','(Hultén) A.E. Porsild','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21212','','','Saxifraga nivalis var. rufopilosa Hultén','Saxifraga nivalis var. rufopilosa','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9758','','','Micranthes idahoensis (Piper) Brouillet & Gornall','Micranthes idahoensis','(Piper) Brouillet & Gornall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21791','','','Saxifraga occidentalis var. idahoensis (Piper) C.L. Hitchcock','Saxifraga occidentalis var. idahoensis','(Piper) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21790','','','Saxifraga marshallii var. idahoensis (Piper) Engler & Irmscher','Saxifraga marshallii var. idahoensis','(Piper) Engler & Irmscher','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21789','','','Saxifraga marshallii subsp. idahoensis (Piper) D.L. Krause & Beamish','Saxifraga marshallii subsp. idahoensis','(Piper) D.L. Krause & Beamish','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21788','','','Saxifraga idahoensis Piper','Saxifraga idahoensis','Piper','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9248','','','Micranthes hieraciifolia (Waldstein & Kitaibel ex Willdenow) Haworth','Micranthes hieraciifolia','(Waldstein & Kitaibel ex Willdenow) Haworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21178','','','Saxifraga hieraciifolia var. hieraciifolia Waldstein & Kitaibel ex Willdenow','Saxifraga hieraciifolia var. hieraciifolia','Waldstein & Kitaibel ex Willdenow','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21179','','','Saxifraga plantaginifolia Hooker','Saxifraga plantaginifolia','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21176','','','Saxifraga hieraciifolia var. angusticapsula Hultén','Saxifraga hieraciifolia var. angusticapsula','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21177','','','Saxifraga hieraciifolia var. rufopilosa Hultén','Saxifraga hieraciifolia var. rufopilosa','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21175','','','Saxifraga hieraciifolia Waldstein & Kitaibel ex Willdenow','Saxifraga hieraciifolia','Waldstein & Kitaibel ex Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9257','','','Micranthes nidifica (Greene) Small','Micranthes nidifica','(Greene) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21203','','','Saxifraga nidifica Greene','Saxifraga nidifica','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21210','','','Saxifraga plantaginea Small','Saxifraga plantaginea','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21209','','','Micranthes plantaginea (Small) Small','Micranthes plantaginea','(Small) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21208','','','Saxifraga montana (Small) Fedde','Saxifraga montana','(Small) Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21207','','','Saxifraga integrifolia var. leptopetala (Suksdorf) Engler & Irmscher','Saxifraga integrifolia var. leptopetala','(Suksdorf) Engler & Irmscher','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21206','','','Saxifraga integrifolia var. columbiana (Piper) C.L. Hitchcock','Saxifraga integrifolia var. columbiana','(Piper) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21205','','','Saxifraga columbiana Piper','Saxifraga columbiana','Piper','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21204','','','Saxifraga nidifica var. nidifica Greene','Saxifraga nidifica var. nidifica','Greene','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9261','','','Micranthes oregana (J.T. Howell) Small','Micranthes oregana','(J.T. Howell) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21225','','','Saxifraga oregana J.T. Howell','Saxifraga oregana','J.T. Howell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21226','','','Saxifraga oregana var. montanensis (Small) C.L. Hitchcock','Saxifraga oregana var. montanensis','(Small) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21227','','','Saxifraga montanensis Small','Saxifraga montanensis','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21228','','','Micranthes montanensis (Small) Small','Micranthes montanensis','(Small) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9249','','','Micranthes integrifolia (Hooker) Small','Micranthes integrifolia','(Hooker) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21182','','','Micranthes bidens Small','Micranthes bidens','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21180','','','Saxifraga integrifolia Hooker','Saxifraga integrifolia','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21181','','','Saxifraga integrifolia var. integrifolia Hooker','Saxifraga integrifolia var. integrifolia','Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2379','','','Micranthes subsect. Micranthes (Haworth) Gornall','Micranthes subsect. Micranthes','(Haworth) Gornall','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2421','','','Micranthes ser. Micranthes (Haworth) Gornall','Micranthes ser. Micranthes','(Haworth) Gornall','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33506','','','Micranthes sect. Rotundifoliatae (A.M. Johnson) Tkach','Micranthes sect. Rotundifoliatae','(A.M. Johnson) Tkach','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9253','','','Micranthes nelsoniana (D. Don) Small','Micranthes nelsoniana','(D. Don) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9256','','','Micranthes nelsoniana var. porsildiana (Calder & Savile) Gornall & H. Ohba','Micranthes nelsoniana var. porsildiana','(Calder & Savile) Gornall & H. Ohba','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22690','','','Saxifraga punctata subsp. porsildiana Calder & Savile','Saxifraga punctata subsp. porsildiana','Calder & Savile','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22694','','','Saxifraga punctata var. pacifica (Hultén) S.L. Welsh','Saxifraga punctata var. pacifica','(Hultén) S.L. Welsh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22693','','','Saxifraga nelsoniana var. porsildiana (Calder & Savile) H. Ohba','Saxifraga nelsoniana var. porsildiana','(Calder & Savile) H. Ohba','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22692','','','Saxifraga nelsoniana subsp. pacifica (Hultén) Hultén','Saxifraga nelsoniana subsp. pacifica','(Hultén) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22691','','','Micranthes porsildiana (Calder & Savile) Elven & D.F. Murray','Micranthes porsildiana','(Calder & Savile) Elven & D.F. Murray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21202','','','Saxifraga porsildiana (Calder & Savile) Jurtzev & V.V. Petrovsky','Saxifraga porsildiana','(Calder & Savile) Jurtzev & V.V. Petrovsky','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21200','','','Saxifraga punctata var. porsildiana (Calder & Saville) S.L. Welsh','Saxifraga punctata var. porsildiana','(Calder & Saville) S.L. Welsh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21201','','','Micranthes nelsoniana var. pacifica (Hultén) Gornall & H. Ohba','Micranthes nelsoniana var. pacifica','(Hultén) Gornall & H. Ohba','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21198','','','Saxifraga pacifica (Hultén) Zhmylev & V.V. Petrovsky','Saxifraga pacifica','(Hultén) Zhmylev & V.V. Petrovsky','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21199','','','Saxifraga nelsoniana subsp. porsildiana (Calder & Saville) Hultén','Saxifraga nelsoniana subsp. porsildiana','(Calder & Saville) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21196','','','Saxifraga nelsoniana var. pacifica (Hultén) Hultén','Saxifraga nelsoniana var. pacifica','(Hultén) Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21197','','','Saxifraga punctata subsp. pacifica Hultén','Saxifraga punctata subsp. pacifica','Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9255','','','Micranthes nelsoniana var. nelsoniana (D. Don) Small','Micranthes nelsoniana var. nelsoniana','(D. Don) Small','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22689','','','Saxifraga nelsoniana D. Don','Saxifraga nelsoniana','D. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21194','','','Saxifraga punctata subsp. nelsoniana (D. Don) Hultén','Saxifraga punctata subsp. nelsoniana','(D. Don) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21195','','','Saxifraga punctata var. nelsoniana (D. Don) Macoun','Saxifraga punctata var. nelsoniana','(D. Don) Macoun','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21193','','','Saxifraga nelsoniana subsp. nelsoniana D. Don','Saxifraga nelsoniana subsp. nelsoniana','D. Don','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9254','','','Micranthes nelsoniana var. cascadensis (Calder & Savile) Gornall & H. Ohba','Micranthes nelsoniana var. cascadensis','(Calder & Savile) Gornall & H. Ohba','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21192','','','Saxifraga punctata var. cascadensis (Calder & Saville) C.L. Hitchcock','Saxifraga punctata var. cascadensis','(Calder & Saville) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21190','','','Saxifraga nelsoniana subsp. cascadensis (Calder & Savile) Hultén','Saxifraga nelsoniana subsp. cascadensis','(Calder & Savile) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21191','','','Saxifraga punctata subsp. cascadensis Calder & Savile','Saxifraga punctata subsp. cascadensis','Calder & Savile','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9252','','','Micranthes nelsoniana var. carlottae (Calder & Savile) Gornall & H. Ohba','Micranthes nelsoniana var. carlottae','(Calder & Savile) Gornall & H. Ohba','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21188','','','Saxifraga punctata subsp. carlottae Calder & Savile','Saxifraga punctata subsp. carlottae','Calder & Savile','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21189','','','Saxifraga punctata var. carlottae (Calder & Savile) B. Boivin','Saxifraga punctata var. carlottae','(Calder & Savile) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21187','','','Saxifraga nelsoniana subsp. carlottae (Calder & Savile) Hultén','Saxifraga nelsoniana subsp. carlottae','(Calder & Savile) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9265','','','Micranthes spicata (D. Don) Small','Micranthes spicata','(D. Don) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21243','','','Saxifraga spicata D. Don','Saxifraga spicata','D. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21245','','','Micranthes galacifolia (Small) Small','Micranthes galacifolia','(Small) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21244','','','Saxifraga galacifolia Small','Saxifraga galacifolia','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9260','','','Micranthes odontoloma (Piper) A. Heller','Micranthes odontoloma','(Piper) A. Heller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21224','','','Saxifraga odontophylla Piper','Saxifraga odontophylla','Piper','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21221','','','Saxifraga odontoloma Piper','Saxifraga odontoloma','Piper','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21222','','','Saxifraga punctata subsp. arguta Hultén','Saxifraga punctata subsp. arguta','Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21223','','','Saxifraga arguta','Saxifraga arguta','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9251','','','Micranthes lyallii × Micranthes odontoloma','Micranthes lyallii × Micranthes odontoloma','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9250','','','Micranthes lyallii (Engler) Small','Micranthes lyallii','(Engler) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21186','','','Saxifraga lyallii subsp. hultenii (Calder & Savile) Calder & Roy L. Taylor','Saxifraga lyallii subsp. hultenii','(Calder & Savile) Calder & Roy L. Taylor','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21184','','','Saxifraga lyallii subsp. lyallii Engler','Saxifraga lyallii subsp. lyallii','Engler','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21185','','','Saxifraga lyallii var. hultenii Calder & Savile','Saxifraga lyallii var. hultenii','Calder & Savile','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21183','','','Saxifraga lyallii Engler','Saxifraga lyallii','Engler','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2380','','','Micranthes subsect. Rotundifoliatae A.M. Johnson','Micranthes subsect. Rotundifoliatae','A.M. Johnson','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33505','','','Micranthes sect. Cuneifoliatae (A.M. Johnson) Tkach','Micranthes sect. Cuneifoliatae','(A.M. Johnson) Tkach','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9300','','','Micranthes razshivinii (Zhmylev) Brouillet & Gornall','Micranthes razshivinii','(Zhmylev) Brouillet & Gornall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21322','','','Saxifraga razshivinii Zhmylev','Saxifraga razshivinii','Zhmylev','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2388','','','Micranthes subsect. Cuneifoliatae A.M. Johnson','Micranthes subsect. Cuneifoliatae','A.M. Johnson','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32865','','','Pectiantia Rafinesque','Pectiantia','Rafinesque','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32866','','','Pectiantia pentandra (Hooker) Rydberg','Pectiantia pentandra','(Hooker) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9276','','','Mitella pentandra Hooker','Mitella pentandra','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32862','','','Brewerimitella (Engler) R.A. Folk & Y. Okuyama','Brewerimitella','(Engler) R.A. Folk & Y. Okuyama','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32864','','','Brewerimitella ovalis (Greene) R.A. Folk & Y. Okuyama','Brewerimitella ovalis','(Greene) R.A. Folk & Y. Okuyama','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21259','','','Pectiantia ovalis (Greene) Rydberg','Pectiantia ovalis','(Greene) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9275','','','Mitella ovalis Greene','Mitella ovalis','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32863','','','Brewerimitella breweri (A. Gray) R.A. Folk & Y. Okuyama','Brewerimitella breweri','(A. Gray) R.A. Folk & Y. Okuyama','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21256','','','Pectiantia breweri (A. Gray) Rydberg','Pectiantia breweri','(A. Gray) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9271','','','Mitella breweri A. Gray','Mitella breweri','A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('185','','','Paeoniaceae Rafinesque','Paeoniaceae','Rafinesque','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1513','','','Paeonia Linnaeus','Paeonia','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7084','','','Paeonia lactiflora Pallas','Paeonia lactiflora','Pallas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7085','','','Paeonia officinalis Linnaeus','Paeonia officinalis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('140','','','Hamamelidaceae R. Brown','Hamamelidaceae','R. Brown','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('338','','','Hamamelidoideae','Hamamelidoideae','','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('571','','','Hamamelideae','Hamamelideae','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1227','','','Hamamelis Linnaeus','Hamamelis','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6110','','','Hamamelis virginiana Linnaeus','Hamamelis virginiana','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16556','','','Hamamelis dioica Walter','Hamamelis dioica','Walter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16557','','','Hamamelis macrophylla Pursh','Hamamelis macrophylla','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16558','','','Hamamelis virginiana var. angustifolia Nieuwland','Hamamelis virginiana var. angustifolia','Nieuwland','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16559','','','Hamamelis virginica var. orbiculata Nieuwland','Hamamelis virginica var. orbiculata','Nieuwland','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16554','','','Hamamelis androgyna Walter','Hamamelis androgyna','Walter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16555','','','Hamamelis corylifolia Moench','Hamamelis corylifolia','Moench','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16568','','','Trilopus virginica (Linnaeus) Rafinesque','Trilopus virginica','(Linnaeus) Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16565','','','Trilopus nigra var. catesbiana Rafinesque','Trilopus nigra var. catesbiana','Rafinesque','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16564','','','Trilopus nigra Rafinesque','Trilopus nigra','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16567','','','Trilopus rotundifolia Rafinesque','Trilopus rotundifolia','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16566','','','Trilopus parvifolia (Nuttall) Rafinesque','Trilopus parvifolia','(Nuttall) Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16561','','','Hamamelis virginica var. parvifolia Nuttall','Hamamelis virginica var. parvifolia','Nuttall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16560','','','Hamamelis virginiana var. macrophylla (Pursh) Nuttall','Hamamelis virginiana var. macrophylla','(Pursh) Nuttall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16563','','','Trilopus estivalis Rafinesque','Trilopus estivalis','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16562','','','Trilopus dentata Rafinesque','Trilopus dentata','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31446','','','Cercidiphyllaceae Engler','Cercidiphyllaceae','Engler','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31447','','','Cercidiphyllum Siebold & Zuccarini','Cercidiphyllum','Siebold & Zuccarini','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31448','','','Cercidiphyllum japonicum Siebold & Zuccarini ex J.J. Hoffmann & J.H. Schultes bis','Cercidiphyllum japonicum','Siebold & Zuccarini ex J.J. Hoffmann & J.H. Schultes bis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26548','','','Penthoraceae Rydberg ex Britton','Penthoraceae','Rydberg ex Britton','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1520','','','Penthorum Linnaeus','Penthorum','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7135','','','Penthorum sedoides Linnaeus','Penthorum sedoides','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32943','','','Myrothamnanae Takhtajan','Myrothamnanae','Takhtajan','SUPERORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32944','','','Gunnerales Takhtajan ex Reveal','Gunnerales','Takhtajan ex Reveal','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32945','','','Gunneraceae Meisner','Gunneraceae','Meisner','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32946','','','Gunnera Linnaeus','Gunnera','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32947','','','Gunnera tinctoria (Molina) Mirbel','Gunnera tinctoria','(Molina) Mirbel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32948','','','Panke tinctoria Molina','Panke tinctoria','Molina','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32949','','','Gunnera chilensis Lamarck','Gunnera chilensis','Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11','','','Rosanae Takhtajan','Rosanae','Takhtajan','SUPERORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('71','','','Vitales Berchtold & J. Presl','Vitales','Berchtold & J. Presl','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('237','','','Vitaceae de Jussieu','Vitaceae','de Jussieu','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1509','','','Parthenocissus Planchon nom. cons.','Parthenocissus','Planchon nom. cons.','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9539','','','Parthenocissus quinquefolia (Linnaeus) Planchon','Parthenocissus quinquefolia','(Linnaeus) Planchon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28651','','','Parthenocissus quinquefolia var. murorum (Focke) Rehder','Parthenocissus quinquefolia var. murorum','(Focke) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28650','','','Parthenocissus hirsuta (Donn) Graebner','Parthenocissus hirsuta','(Donn) Graebner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28653','','','Vitis quinquefolia (Linnaeus) Lamarck','Vitis quinquefolia','(Linnaeus) Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28652','','','Psedera quinquefolia (Linnaeus) Greene','Psedera quinquefolia','(Linnaeus) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21587','','','Ampelopsis quinquefolia (Linnaeus) Michaux','Ampelopsis quinquefolia','(Linnaeus) Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21586','','','Hedera quinquefolia Linnaeus','Hedera quinquefolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21585','','','Vitis inserta A. Kerner','Vitis inserta','A. Kerner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9538','','','Parthenocissus inserta (A. Kerner) Fritsch','Parthenocissus inserta','(A. Kerner) Fritsch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9540','','','Parthenocissus tricuspidata (Siebold & Zuccarini) Planchon','Parthenocissus tricuspidata','(Siebold & Zuccarini) Planchon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28641','','','Ampelopsis tricuspidata Siebold & Zuccarini','Ampelopsis tricuspidata','Siebold & Zuccarini','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21584','','','Parthenocissus vitacea (Knerr) Hitchcock','Parthenocissus vitacea','(Knerr) Hitchcock','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28643','','','Parthenocissus inserta var. laciniata (Planchon) Rehder','Parthenocissus inserta var. laciniata','(Planchon) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28642','','','Ampelopsis quinquefolia var. vitacea Knerr','Ampelopsis quinquefolia var. vitacea','Knerr','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28645','','','Parthenocissus quinquefolia var. vitacea (Knerr) L.H. Bailey','Parthenocissus quinquefolia var. vitacea','(Knerr) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28644','','','Parthenocissus laciniata (Planchon) Small','Parthenocissus laciniata','(Planchon) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28647','','','Parthenocissus vitacea var. laciniata (Planchon) Rehder','Parthenocissus vitacea var. laciniata','(Planchon) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28646','','','Parthenocissus vitacea var. dubia Rehder','Parthenocissus vitacea var. dubia','Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28649','','','Psedera vitacea (Knerr) Greene','Psedera vitacea','(Knerr) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28648','','','Parthenocissus vitacea var. macrophylla (Lauche) Rehder','Parthenocissus vitacea var. macrophylla','(Lauche) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1823','','','Vitis Linnaeus','Vitis','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~7H','','','Vitis (Vitis) Linnaeus','Vitis (Vitis)','Linnaeus','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33418','','','Vitis × alexanderi Prince ex Jacques','Vitis × alexanderi','Prince ex Jacques','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33419','','','Vitis × labruscana L.H. Bailey','Vitis × labruscana','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9542','','','Vitis labrusca Linnaeus','Vitis labrusca','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28613','','','Vitis labrusca var. alba W.R. Prince','Vitis labrusca var. alba','W.R. Prince','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28614','','','Vitis labrusca var. labruscoides Eaton','Vitis labrusca var. labruscoides','Eaton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28615','','','Vitis labrusca var. rosea W.R. Prince','Vitis labrusca var. rosea','W.R. Prince','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28616','','','Vitis labrusca var. subedentata Fernald','Vitis labrusca var. subedentata','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28654','','','Vitis × novae-angliae Fernald','Vitis × novae-angliae','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9543','','','Vitis riparia Michaux','Vitis riparia','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28618','','','Vitis riparia var. praecox Engelmann ex L.H. Bailey','Vitis riparia var. praecox','Engelmann ex L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28619','','','Vitis riparia var. syrticola (Fernald & Wiegand) Fernald','Vitis riparia var. syrticola','(Fernald & Wiegand) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28620','','','Vitis vulpina subsp. riparia (Michaux) R.T. Clausen','Vitis vulpina subsp. riparia','(Michaux) R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28621','','','Vitis vulpina var. syrticola Fernald & Wiegand','Vitis vulpina var. syrticola','Fernald & Wiegand','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28617','','','Vitis cordifolia var. riparia (Michaux) A. Gray','Vitis cordifolia var. riparia','(Michaux) A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9545','','','Vitis vulpina Linnaeus','Vitis vulpina','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28622','','','Vitis cordifolia var. sempervirens Munson','Vitis cordifolia var. sempervirens','Munson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28623','','','Vitis illex L.H. Bailey','Vitis illex','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28624','','','Vitis pullaria J. Le Conte','Vitis pullaria','J. Le Conte','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21589','','','Vitis cordifolia Michaux','Vitis cordifolia','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9544','','','Vitis vinifera Linnaeus','Vitis vinifera','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9541','','','Vitis aestivalis Michaux','Vitis aestivalis','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28625','','','Vitis aestivalis var. argentifolia (Munson ex L.H. Bailey) Fernald','Vitis aestivalis var. argentifolia','(Munson ex L.H. Bailey) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28634','','','Vitis labrusca var. aestivalis (Michaux) Regel','Vitis labrusca var. aestivalis','(Michaux) Regel','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28635','','','Vitis linsecomii Buckley','Vitis linsecomii','Buckley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28636','','','Vitis linsecomii var. glauca Munson','Vitis linsecomii var. glauca','Munson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28637','','','Vitis rufotomentosa Small','Vitis rufotomentosa','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28638','','','Vitis sinuata (Pursh) G. Don','Vitis sinuata','(Pursh) G. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28639','','','Vitis smalliana L.H. Bailey','Vitis smalliana','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28640','','','Vitis vinifera var. aestivalis (Michaux) Kuntze','Vitis vinifera var. aestivalis','(Michaux) Kuntze','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28626','','','Vitis aestivalis var. bicolor Deam','Vitis aestivalis var. bicolor','Deam','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28627','','','Vitis aestivalis var. linsecomii (Buckley) Munson','Vitis aestivalis var. linsecomii','(Buckley) Munson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28628','','','Vitis aestivalis var. sinuata Pursh','Vitis aestivalis var. sinuata','Pursh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28629','','','Vitis aestivalis subsp. smalliana (L.H. Bailey) W.M. Rogers','Vitis aestivalis subsp. smalliana','(L.H. Bailey) W.M. Rogers','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28630','','','Vitis aestivalis var. smalliana (L.H. Bailey) Comeaux','Vitis aestivalis var. smalliana','(L.H. Bailey) Comeaux','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28631','','','Vitis araneosa J. Le Conte','Vitis araneosa','J. Le Conte','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28632','','','Vitis argentifolia Munson ex L.H. Bailey','Vitis argentifolia','Munson ex L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28633','','','Vitis gigas Fennell','Vitis gigas','Fennell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30177','','','Vitis subgen. Vitis Linnaeus','Vitis subgen. Vitis','Linnaeus','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28978','','','Ampelopsis Michaux','Ampelopsis','Michaux','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28979','','','Ampelopsis glandulosa (Wallich) Momiyama','Ampelopsis glandulosa','(Wallich) Momiyama','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28980','','','Vitis glandulosa Wallich','Vitis glandulosa','Wallich','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28981','','','Ampelopsis brevipedunculata (Maximowicz) Trautvetter','Ampelopsis brevipedunculata','(Maximowicz) Trautvetter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28982','','','Ampelopsis brevipedunculata var. citrulloides (Lebas) L.H. Bailey','Ampelopsis brevipedunculata var. citrulloides','(Lebas) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28983','','','Ampelopsis brevipedunculata var. maximowiczii (Regel) Rehder','Ampelopsis brevipedunculata var. maximowiczii','(Regel) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28984','','','Ampelopsis heterophylla Siebold & Zuccarini nom. illeg.','Ampelopsis heterophylla','Siebold & Zuccarini nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28985','','','Cissus brevipedunculata Maximowicz','Cissus brevipedunculata','Maximowicz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('72','','','Zygophyllales Link','Zygophyllales','Link','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('241','','','Zygophyllaceae R. Brown','Zygophyllaceae','R. Brown','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('385','','','Tribuloideae','Tribuloideae','','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1777','','','Tribulus Linnaeus','Tribulus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9556','','','Tribulus terrestris Linnaeus','Tribulus terrestris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('43','','','Malvales Lindley','Malvales','Lindley','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('163','','','Malvaceae de Jussieu','Malvaceae','de Jussieu','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('242','','','Malvoideae','Malvoideae','','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('578','','','Hibisceae','Hibisceae','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1248','','','Hibiscus Linnaeus','Hibiscus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6619','','','Hibiscus laevis Allioni','Hibiscus laevis','Allioni','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23803','','','Hibiscus coccineus var. virginicus Hochreutiner','Hibiscus coccineus var. virginicus','Hochreutiner','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17257','','','Hibiscus militaris Cavanilles','Hibiscus militaris','Cavanilles','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6621','','','Hibiscus moscheutos Linnaeus','Hibiscus moscheutos','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6620','','','Hibiscus moscheutos subsp. moscheutos Linnaeus','Hibiscus moscheutos subsp. moscheutos','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29266','','','Hibiscus moscheutos subsp. incanus (J.C. Wendland) H.E. Ahles','Hibiscus moscheutos subsp. incanus','(J.C. Wendland) H.E. Ahles','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29265','','','Hibiscus incanus J.C. Wendland','Hibiscus incanus','J.C. Wendland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29268','','','Hibiscus oculiroseus Britton','Hibiscus oculiroseus','Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29267','','','Hibiscus moscheutos subsp. palustris (Linnaeus) R.T. Clausen','Hibiscus moscheutos subsp. palustris','(Linnaeus) R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17259','','','Hibiscus moscheutos var. purpurescens Sweet','Hibiscus moscheutos var. purpurescens','Sweet','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17260','','','Hibiscus opulifolius Greene','Hibiscus opulifolius','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17258','','','Hibiscus palustris Linnaeus','Hibiscus palustris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6622','','','Hibiscus trionum Linnaeus','Hibiscus trionum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('390','','','Malveae','Malveae','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('805','','','Althaea Linnaeus','Althaea','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6616','','','Althaea hirsuta Linnaeus','Althaea hirsuta','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17248','','','Althaea hispida Moench nom. illeg.','Althaea hispida','Moench nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6617','','','Althaea officinalis Linnaeus','Althaea officinalis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17251','','','Malva officinalis (Linnaeus) Schimper & Spenner','Malva officinalis','(Linnaeus) Schimper & Spenner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17250','','','Althaea taurinensis de Candolle','Althaea taurinensis','de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17249','','','Althaea sublobata Stokes','Althaea sublobata','Stokes','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('825','','','Anoda Cavanilles','Anoda','Cavanilles','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6618','','','Anoda cristata (Linnaeus) Schlechtendal','Anoda cristata','(Linnaeus) Schlechtendal','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17252','','','Anoda lavateroides Medikus nom. illeg.','Anoda lavateroides','Medikus nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17256','','','Sida cristata Linnaeus','Sida cristata','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17255','','','Anoda triangularis (Willdenow) de Candolle','Anoda triangularis','(Willdenow) de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17254','','','Anoda hastata Cavanilles','Anoda hastata','Cavanilles','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17253','','','Anoda arizonica A. Gray','Anoda arizonica','A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1283','','','Iliamna Greene','Iliamna','Greene','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6624','','','Iliamna rivularis (Douglas) Greene','Iliamna rivularis','(Douglas) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29271','','','Sphaeralcea rivularis var. diversa A. Nelson','Sphaeralcea rivularis var. diversa','A. Nelson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29270','','','Iliamna rivularis var. diversa (A. Nelson) C.L. Hitchcock','Iliamna rivularis var. diversa','(A. Nelson) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29269','','','Iliamna rivularis subsp. diversa (A. Nelson) Wiggins','Iliamna rivularis subsp. diversa','(A. Nelson) Wiggins','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17265','','','Phymosia acerifolia (Nuttall ex Torrey & A. Gray) Rydberg','Phymosia acerifolia','(Nuttall ex Torrey & A. Gray) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17266','','','Phymosia rivularis (Douglas) Rydberg','Phymosia rivularis','(Douglas) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17261','','','Malva rivularis Douglas','Malva rivularis','Douglas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17262','','','Iliamna acerifolia (Nuttall ex Torrey & A. Gray) Greene','Iliamna acerifolia','(Nuttall ex Torrey & A. Gray) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17267','','','Sphaeralcea acerifolia Nuttall ex Torrey & A. Gray','Sphaeralcea acerifolia','Nuttall ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17268','','','Sphaeralcea rivularis (Douglas) Torrey nom. inval.','Sphaeralcea rivularis','(Douglas) Torrey nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6623','','','Iliamna rivularis var. rivularis (Douglas) Greene','Iliamna rivularis var. rivularis','(Douglas) Greene','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1321','','','Lavatera Linnaeus','Lavatera','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6625','','','Lavatera thuringiaca Linnaeus','Lavatera thuringiaca','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17270','','','Althaea ambigua (de Candolle) Alefeld','Althaea ambigua','(de Candolle) Alefeld','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17271','','','Althaea vitifolia (Schur) Borbás','Althaea vitifolia','(Schur) Borbás','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17272','','','Malva thuringiaca (Linnaeus) Visiani','Malva thuringiaca','(Linnaeus) Visiani','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9822','','','Lavatera trimestris Linnaeus','Lavatera trimestris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29272','','','Stegia trimestris (Linnaeus) T. Luque & Devesa','Stegia trimestris','(Linnaeus) T. Luque & Devesa','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21877','','','Althaea trimestris (Linnaeus) Kuntze','Althaea trimestris','(Linnaeus) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1393','','','Malva Linnaeus','Malva','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6626','','','Malva alcea Linnaeus','Malva alcea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17273','','','Malva alcea var. fastigiata (Cavanilles) K. Koch','Malva alcea var. fastigiata','(Cavanilles) K. Koch','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6627','','','Malva moschata Linnaeus','Malva moschata','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6628','','','Malva neglecta Wallroth','Malva neglecta','Wallroth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17274','','','Malva rotundifolia Linnaeus nom. rej.','Malva rotundifolia','Linnaeus nom. rej.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6629','','','Malva parviflora Linnaeus','Malva parviflora','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6631','','','Malva sylvestris Linnaeus','Malva sylvestris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17275','','','Malva mauritiana Linnaeus','Malva mauritiana','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17276','','','Malva sylvestris var. mauritiana (Linnaeus) Boissier','Malva sylvestris var. mauritiana','(Linnaeus) Boissier','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6630','','','Malva pusilla Smith','Malva pusilla','Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17274-039b6ac5-450d-4a93-853f-514d9d94ebff','','','Malva rotundifolia Linnaeus nom. rej.','Malva rotundifolia','Linnaeus nom. rej.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6632','','','Malva verticillata Linnaeus','Malva verticillata','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29273','','','Malva verticillata subsp. crispa (Linnaeus) Tzvelev','Malva verticillata subsp. crispa','(Linnaeus) Tzvelev','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17279','','','Malva verticillata var. crispa Linnaeus','Malva verticillata var. crispa','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17277','','','Malva crispa (Linnaeus) Linnaeus','Malva crispa','(Linnaeus) Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17278','','','Malva verticillata var. chinensis (Miller) S.Y. Hu','Malva verticillata var. chinensis','(Miller) S.Y. Hu','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1684','','','Sida Linnaeus','Sida','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6634','','','Sida spinosa Linnaeus','Sida spinosa','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29274','','','Sida alnifolia Linnaeus','Sida alnifolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17283','','','Sida angustifolia Miller','Sida angustifolia','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17284','','','Sida heterocarpa Engelmann ex A. Gray','Sida heterocarpa','Engelmann ex A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17282','','','Sida alba Linnaeus','Sida alba','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1685','','','Sidalcea A. Gray','Sidalcea','A. Gray','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6636','','','Sidalcea oregana (Nuttall ex Torrey & A. Gray) A. Gray','Sidalcea oregana','(Nuttall ex Torrey & A. Gray) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29183','','','Sidalcea oregana subsp. oregana (Nuttall ex Torrey & A. Gray) A. Gray','Sidalcea oregana subsp. oregana','(Nuttall ex Torrey & A. Gray) A. Gray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17291','','','Sidalcea oregana var. procera C.L. Hitchcock','Sidalcea oregana var. procera','C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17287','','','Sidalcea nervata A. Nelson','Sidalcea nervata','A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17288','','','Sidalcea oregana var. calva C.L. Hitchcock','Sidalcea oregana var. calva','C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17289','','','Sidalcea oregana var. maxima (M. Peck) C.L. Hitchcock','Sidalcea oregana var. maxima','(M. Peck) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17290','','','Sidalcea oregana var. nevadensis C.L. Hitchcock','Sidalcea oregana var. nevadensis','C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17285','','','Sida oregana Nuttall ex Torrey & A. Gray','Sida oregana','Nuttall ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17286','','','Sidalcea maxima M. Peck','Sidalcea maxima','M. Peck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6635','','','Sidalcea hendersonii S. Watson','Sidalcea hendersonii','S. Watson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1707','','','Sphaeralcea A. St.-Hilaire','Sphaeralcea','A. St.-Hilaire','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6638','','','Sphaeralcea coccinea (Nuttall) Rydberg','Sphaeralcea coccinea','(Nuttall) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6637','','','Sphaeralcea coccinea var. coccinea (Nuttall) Rydberg','Sphaeralcea coccinea var. coccinea','(Nuttall) Rydberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29279','','','Nototriche coccinea (Nuttall) Nieuwland & Lunell nom. illeg.','Nototriche coccinea','(Nuttall) Nieuwland & Lunell nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29278','','','Malveopsis coccinea (Nuttall) Kuntze','Malveopsis coccinea','(Nuttall) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23864','','','Malvastrum coccineum var. dissectum (Nuttall ex Torrey & A. Gray) A. Gray','Malvastrum coccineum var. dissectum','(Nuttall ex Torrey & A. Gray) A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23865','','','Sida dissecta Nuttall ex Torrey & A. Gray','Sida dissecta','Nuttall ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17300','','','Sphaeralcea coccinea var. dissecta (Nuttall ex Torrey & A. Gray) Kearney','Sphaeralcea coccinea var. dissecta','(Nuttall ex Torrey & A. Gray) Kearney','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17299','','','Sphaeralcea coccinea subsp. dissecta (Nuttall ex Torrey & A. Gray) Kearney','Sphaeralcea coccinea subsp. dissecta','(Nuttall ex Torrey & A. Gray) Kearney','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17296','','','Malvastrum dissectum var. cockerellii (A. Nelson) A. Nelson','Malvastrum dissectum var. cockerellii','(A. Nelson) A. Nelson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17295','','','Sida coccinea (Nuttall) de Candolle','Sida coccinea','(Nuttall) de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17298','','','Sphaeralcea dissecta Nuttall ex Torrey & A. Gray','Sphaeralcea dissecta','Nuttall ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17297','','','Malvastrum cockerellii A. Nelson','Malvastrum cockerellii','A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17292','','','Malva coccinea Nuttall','Malva coccinea','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17294','','','Malvastrum coccineum (Nuttall) A. Gray','Malvastrum coccineum','(Nuttall) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17293','','','Cristaria coccinea (Nuttall) Pursh nom. illeg.','Cristaria coccinea','(Nuttall) Pursh nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6639','','','Sphaeralcea munroana (Douglas ex Lindley) Spach ex A. Gray','Sphaeralcea munroana','(Douglas ex Lindley) Spach ex A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29275','','','Malva creeana Graham','Malva creeana','Graham','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29276','','','Sphaeralcea creeana (Graham) Sprague & Sandwith','Sphaeralcea creeana','(Graham) Sprague & Sandwith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29277','','','Malvastrum munroanum (Douglas ex Lindley) A. Gray','Malvastrum munroanum','(Douglas ex Lindley) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17304','','','Malvastrum munroanum (Douglas ex Lindley) A. Gray','Malvastrum munroanum','(Douglas ex Lindley) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17303','','','Nuttallia munroana (Douglas ex Lindley) Nuttall','Nuttallia munroana','(Douglas ex Lindley) Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17306','','','Sphaeralcea munroana var. subrhomboidea (Rydberg) Kearney','Sphaeralcea munroana var. subrhomboidea','(Rydberg) Kearney','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17305','','','Sphaeralcea munroana subsp. subrhomboidea (Rydberg) Kearney','Sphaeralcea munroana subsp. subrhomboidea','(Rydberg) Kearney','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17302','','','Malveopsis munroana (Douglas ex Lindley) Kuntze','Malveopsis munroana','(Douglas ex Lindley) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17301','','','Malva munroana Douglas ex Lindley','Malva munroana','Douglas ex Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17307','','','Sphaeralcea subrhomboidea Rydberg','Sphaeralcea subrhomboidea','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31185','','','Ripariosida Weakley & D.B. Poindexter','Ripariosida','Weakley & D.B. Poindexter','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31186','','','Ripariosida hermaphrodita (Linnaeus) Weakley & B.D. Poindexter','Ripariosida hermaphrodita','(Linnaeus) Weakley & B.D. Poindexter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17280','','','Napaea hermaphrodita Linnaeus','Napaea hermaphrodita','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17281','','','Sida napaea Cavanilles nom. illeg.','Sida napaea','Cavanilles nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6633','','','Sida hermaphrodita (Linnaeus) Rusby','Sida hermaphrodita','(Linnaeus) Rusby','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('796','','','Alcea Linnaeus','Alcea','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6615','','','Alcea rosea Linnaeus','Alcea rosea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17244','','','Althaea mexicana Kunze','Althaea mexicana','Kunze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17243','','','Althaea ficifolia (Linnaeus) Cavanilles','Althaea ficifolia','(Linnaeus) Cavanilles','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17242','','','Alcea ficifolia Linnaeus','Alcea ficifolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17247','','','Althaea sinensis Cavanilles','Althaea sinensis','Cavanilles','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17246','','','Althaea rosea var. sinensis (Cavanilles) S.Y. Hu','Althaea rosea var. sinensis','(Cavanilles) S.Y. Hu','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17245','','','Althaea rosea (Linnaeus) Cavanilles','Althaea rosea','(Linnaeus) Cavanilles','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6614','','','Alcea pallida (Waldstein & Kitaibel ex Willdenow) Waldstein & Kitaibel','Alcea pallida','(Waldstein & Kitaibel ex Willdenow) Waldstein & Kitaibel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17241','','','Althaea pallida Waldstein & Kitaibel ex Willdenow','Althaea pallida','Waldstein & Kitaibel ex Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('766','','','Abutilon Miller','Abutilon','Miller','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6613','','','Abutilon theophrasti Medikus','Abutilon theophrasti','Medikus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29264','','','Abutilon abutilon (Linnaeus) Huth nom. inval.','Abutilon abutilon','(Linnaeus) Huth nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17239','','','Sida abutilon Linnaeus','Sida abutilon','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17240','','','Abutilon avicennae Gaertner','Abutilon avicennae','Gaertner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('383','','','Tilioideae','Tilioideae','','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1761','','','Tilia Linnaeus','Tilia','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6641','','','Tilia cordata Miller','Tilia cordata','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6640','','','Tilia americana Linnaeus','Tilia americana','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29263','','','Tilia × stellata Hartig','Tilia × stellata','Hartig','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29260','','','Tilia americana var. neglecta (Spach) Fosberg','Tilia americana var. neglecta','(Spach) Fosberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29262','','','Tilia caroliniana subsp. occidentalis (Rose) Pigott','Tilia caroliniana subsp. occidentalis','(Rose) Pigott','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29261','','','Tilia caroliniana subsp. heterophylla (Ventenat) Pigott','Tilia caroliniana subsp. heterophylla','(Ventenat) Pigott','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26687','','','Tilia floridana Small','Tilia floridana','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26688','','','Tilia georgiana Sargent','Tilia georgiana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26685','','','Tilia caroliniana subsp. floridana (Small) A.E. Murray','Tilia caroliniana subsp. floridana','(Small) A.E. Murray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26686','','','Tilia eburnea Ashe','Tilia eburnea','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26683','','','Tilia australis Small','Tilia australis','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26684','','','Tilia floridana var. australis (Small) Sargent','Tilia floridana var. australis','(Small) Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26681','','','Tilia americana var. caroliniana (Miller) Castiglioni','Tilia americana var. caroliniana','(Miller) Castiglioni','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26682','','','Tilia caroliniana Miller','Tilia caroliniana','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26695','','','Tilia truncata Spach','Tilia truncata','Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26696','','','Tilia americana var. americana Linnaeus','Tilia americana var. americana','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26693','','','Tilia monticola Sargent','Tilia monticola','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26694','','','Tilia porracea Ashe','Tilia porracea','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26691','','','Tilia littoralis Sargent','Tilia littoralis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26692','','','Tilia michauxii Nuttall nom. inval.','Tilia michauxii','Nuttall nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26689','','','Tilia lasioclada Sargent','Tilia lasioclada','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26690','','','Tilia leucocarpa Ashe','Tilia leucocarpa','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17311','','','Tilia pubescens Aiton nom. illeg.','Tilia pubescens','Aiton nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17312','','','Tilia americana var. heterophylla (Ventenat) Loudon','Tilia americana var. heterophylla','(Ventenat) Loudon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17309','','','Tilia canadensis Michaux','Tilia canadensis','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17310','','','Tilia glabra Ventenat nom. inval.','Tilia glabra','Ventenat nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17308','','','Tilia neglecta Spach','Tilia neglecta','Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6642','','','Tilia heterophylla Ventenat','Tilia heterophylla','Ventenat','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6644','','','Tilia tomentosa Moench','Tilia tomentosa','Moench','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6643','','','Tilia platyphyllos Scopoli','Tilia platyphyllos','Scopoli','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17313','','','Tilia × europaea Linnaeus','Tilia × europaea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6645','','','Tilia × vulgaris Hayne','Tilia × vulgaris','Hayne','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('109','','','Cistaceae de Jussieu','Cistaceae','de Jussieu','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('582','','','Hudsonieae','Hudsonieae','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1260','','','Hudsonia Linnaeus','Hudsonia','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4574','','','Hudsonia ericoides Linnaeus','Hudsonia ericoides','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23873','','','Hudsonia ericoides subsp. andersonii N.H. Nickerson & J.E. Skog','Hudsonia ericoides subsp. andersonii','N.H. Nickerson & J.E. Skog','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4575','','','Hudsonia tomentosa Nuttall','Hudsonia tomentosa','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25537','','','Hudsonia tomentosa var. tomentosa Nuttall','Hudsonia tomentosa var. tomentosa','Nuttall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14805','','','Hudsonia ericoides subsp. intermedia (Peck) N.H. Nickerson & J.E. Skog','Hudsonia ericoides subsp. intermedia','(Peck) N.H. Nickerson & J.E. Skog','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14804','','','Hudsonia ericoides subsp. tomentosa (Nuttall) N.H. Nickerson & J.E. Skog','Hudsonia ericoides subsp. tomentosa','(Nuttall) N.H. Nickerson & J.E. Skog','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14806','','','Hudsonia tomentosa var. intermedia Peck','Hudsonia tomentosa var. intermedia','Peck','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4576','','','Hudsonia × intermedia (Peck) Erskine','Hudsonia × intermedia','(Peck) Erskine','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34111','','','Hudsonia ericoides × Hudsonia tomentosa','Hudsonia ericoides × Hudsonia tomentosa','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24868','','','Crocanthemum Spach','Crocanthemum','Spach','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24869','','','Crocanthemum canadense (Linnaeus) Britton','Crocanthemum canadense','(Linnaeus) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24871','','','Helianthemum canadense var. sabulonum Fernald','Helianthemum canadense var. sabulonum','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25340','','','Heteromeris major (Linnaeus) Ponzo','Heteromeris major','(Linnaeus) Ponzo','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25338','','','Halimium majus (Linnaeus) Grossheim','Halimium majus','(Linnaeus) Grossheim','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25339','','','Helianthemum major (Linnaeus) Britton, Sterns & Poggenburgh','Helianthemum major','(Linnaeus) Britton, Sterns & Poggenburgh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25336','','','Heteromeris canadensis (Linnaeus) Spach','Heteromeris canadensis','(Linnaeus) Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25337','','','Crocanthemum majus (Linnaeus) Britton','Crocanthemum majus','(Linnaeus) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25335','','','Halimium canadense (Linnaeus) Grosser','Halimium canadense','(Linnaeus) Grosser','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25334','','','Lechea major Linnaeus','Lechea major','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14803','','','Cistus canadensis Linnaeus','Cistus canadensis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4573','','','Helianthemum canadense (Linnaeus) Michaux','Helianthemum canadense','(Linnaeus) Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24870','','','Crocanthemum bicknellii (Fernald) Janchen','Crocanthemum bicknellii','(Fernald) Janchen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24872','','','Helianthemum canadense var. walkerae W.H. Evans','Helianthemum canadense var. walkerae','W.H. Evans','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4572','','','Helianthemum bicknellii Fernald','Helianthemum bicknellii','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('601','','','Lechidieae','Lechidieae','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1322','','','Lechea Linnaeus','Lechea','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4580','','','Lechea maritima Leggett','Lechea maritima','Leggett','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14807','','','Lechea maritima var. subcylindrica Hodgdon','Lechea maritima var. subcylindrica','Hodgdon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4583','','','Lechea stricta Leggett ex Britton','Lechea stricta','Leggett ex Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4581','','','Lechea minor Linnaeus','Lechea minor','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14808','','','Lechea thymifolia Michaux','Lechea thymifolia','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4582','','','Lechea pulchella Rafinesque','Lechea pulchella','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26736','','','Lechea pulchella var. moniliformis (E.P. Bicknell) Mohlenbrock','Lechea pulchella var. moniliformis','(E.P. Bicknell) Mohlenbrock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26738','','','Lechea leggettii var. moniliformis (E.P. Bicknell) Hodgdon','Lechea leggettii var. moniliformis','(E.P. Bicknell) Hodgdon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26737','','','Lechea moniliformis E.P. Bicknell','Lechea moniliformis','E.P. Bicknell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4578','','','Lechea intermedia Leggett ex Britton','Lechea intermedia','Leggett ex Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26729','','','Lechea intermedia var. juniperina (E.P. Bicknell) B.L. Robinson','Lechea intermedia var. juniperina','(E.P. Bicknell) B.L. Robinson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26730','','','Lechea juniperina E.P. Bicknell','Lechea juniperina','E.P. Bicknell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4579','','','Lechea intermedia var. intermedia Leggett ex Britton','Lechea intermedia var. intermedia','Leggett ex Britton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4577','','','Lechea intermedia var. depauperata Hodgdon','Lechea intermedia var. depauperata','Hodgdon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26731','','','Lechea intermedia var. laurentiana Hodgdon','Lechea intermedia var. laurentiana','Hodgdon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26724','','','Lechea mucronata Rafinesque','Lechea mucronata','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26725','','','Lechea villosa var. macrotheca Hodgdon','Lechea villosa var. macrotheca','Hodgdon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26726','','','Lechea villosa var. schaffneri Hodgdon','Lechea villosa var. schaffneri','Hodgdon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26727','','','Lechea major var. villosa (Elliott) Grossheim','Lechea major var. villosa','(Elliott) Grossheim','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26728','','','Lechea villosa var. villosa Rafinesque','Lechea villosa var. villosa','Rafinesque','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14810','','','Lechea minor var. villosa (Elliott) B. Boivin','Lechea minor var. villosa','(Elliott) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4584','','','Lechea villosa Elliott','Lechea villosa','Elliott','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29031','','','Cisteae de Jussieu','Cisteae','de Jussieu','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29032','','','Cistus Linnaeus','Cistus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29033','','','Cistus creticus Linnaeus','Cistus creticus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29036','','','Cistus villosus subsp. creticus (Linnaeus) Nyman','Cistus villosus subsp. creticus','(Linnaeus) Nyman','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29034','','','Cistus incanus subsp. creticus (Linnaeus) Heywood','Cistus incanus subsp. creticus','(Linnaeus) Heywood','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29035','','','Cistus villosus var. creticus (Linnaeus) Boissier','Cistus villosus var. creticus','(Linnaeus) Boissier','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('229','','','Thymelaeaceae de Jussieu','Thymelaeaceae','de Jussieu','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('326','','','Thymelaeoideae','Thymelaeoideae','','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('533','','','Daphneae','Daphneae','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1102','','','Dirca Linnaeus','Dirca','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9413','','','Dirca palustris Linnaeus','Dirca palustris','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1933','','','Thymelaea Miller','Thymelaea','Miller','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9414','','','Thymelaea passerina (Linnaeus) Cosson & Germain','Thymelaea passerina','(Linnaeus) Cosson & Germain','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29280','','','Ligia passerina (Linnaeus) Fasano','Ligia passerina','(Linnaeus) Fasano','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21427','','','Stellera passerina Linnaeus','Stellera passerina','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1077','','','Daphne Linnaeus','Daphne','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9411','','','Daphne laureola Linnaeus','Daphne laureola','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29282','','','Thymelaea laureola (Linnaeus) Scopoli','Thymelaea laureola','(Linnaeus) Scopoli','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9412','','','Daphne mezereum Linnaeus','Daphne mezereum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29281','','','Thymelaea mezereum (Linnaeus) Scopoli','Thymelaea mezereum','(Linnaeus) Scopoli','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('61','','','Rosales Lindley','Rosales','Lindley','ORDER','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('104','','','Cannabaceae Martinov','Cannabaceae','Martinov','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('945','','','Cannabis Linnaeus','Cannabis','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4191','','','Cannabis sativa Linnaeus','Cannabis sativa','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('965','','','Celtis Linnaeus','Celtis','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4193','','','Celtis tenuifolia Nuttall','Celtis tenuifolia','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26583','','','Celtis occidentalis subsp. georgiana (Small) A.E. Murray','Celtis occidentalis subsp. georgiana','(Small) A.E. Murray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14141','','','Celtis tenuifolia var. georgiana (Small) Fernald & B.G. Schubert','Celtis tenuifolia var. georgiana','(Small) Fernald & B.G. Schubert','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14142','','','Celtis tenuifolia var. soperi B. Boivin','Celtis tenuifolia var. soperi','B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14139','','','Celtis occidentalis var. georgiana (Small) H.E. Ahles','Celtis occidentalis var. georgiana','(Small) H.E. Ahles','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14140','','','Celtis pumila var. georgiana (Small) Sargent','Celtis pumila var. georgiana','(Small) Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14138','','','Celtis georgiana Small','Celtis georgiana','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4192','','','Celtis occidentalis Linnaeus','Celtis occidentalis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31910','','','Celtis canina Rafinesque','Celtis canina','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31909','','','Celtis crassifolia Lamarck','Celtis crassifolia','Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25364','','','Celtis occidentalis var. occidentalis Linnaeus','Celtis occidentalis var. occidentalis','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14135','','','Celtis occidentalis var. pumila (Pursh) A. Gray','Celtis occidentalis var. pumila','(Pursh) A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14136','','','Celtis pumila Pursh','Celtis pumila','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14133','','','Celtis occidentalis var. canina (Rafinesque) Sargent','Celtis occidentalis var. canina','(Rafinesque) Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14134','','','Celtis occidentalis var. crassifolia (Lamarck) A. Gray','Celtis occidentalis var. crassifolia','(Lamarck) A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14137','','','Celtis pumila var. deamii Sargent','Celtis pumila var. deamii','Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1261','','','Humulus Linnaeus','Humulus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4196','','','Humulus lupulus Linnaeus','Humulus lupulus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4195','','','Humulus lupulus var. lupuloides E. Small','Humulus lupulus var. lupuloides','E. Small','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14144','','','Humulus americanus Nuttall','Humulus americanus','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4198','','','Humulus lupulus var. neomexicanus A. Nelson & Cockerell','Humulus lupulus var. neomexicanus','A. Nelson & Cockerell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31934','','','Humulus neomexicanus (A. Nelson & Cockerell) Rydberg','Humulus neomexicanus','(A. Nelson & Cockerell) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4197','','','Humulus lupulus var. lupulus Linnaeus','Humulus lupulus var. lupulus','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4194','','','Humulus japonicus Siebold & Zuccarini','Humulus japonicus','Siebold & Zuccarini','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14143','','','Humulus scandens (Loureiro) Merrill','Humulus scandens','(Loureiro) Merrill','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('206','','','Rhamnaceae de Jussieu','Rhamnaceae','de Jussieu','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('491','','','incertae sedis','incertae sedis','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('963','','','Ceanothus Linnaeus','Ceanothus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~6Z','','','Ceanothus (Ceanothus) Linnaeus','Ceanothus (Ceanothus)','Linnaeus','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8587','','','Ceanothus americanus Linnaeus','Ceanothus americanus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19764','','','Ceanothus americanus var. intermedius (Pursh) Torrey & A. Gray','Ceanothus americanus var. intermedius','(Pursh) Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19766','','','Ceanothus intermedius Pursh','Ceanothus intermedius','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19765','','','Ceanothus americanus var. pitcheri Torrey & A. Gray','Ceanothus americanus var. pitcheri','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8588','','','Ceanothus herbaceus Rafinesque','Ceanothus herbaceus','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24756','','','Ceanothus herbaceus var. herbaceus Rafinesque','Ceanothus herbaceus var. herbaceus','Rafinesque','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24755','','','Ceanothus ovatus var. pubescens S. Watson','Ceanothus ovatus var. pubescens','S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19767','','','Ceanothus herbaceus var. pubescens (S. Watson) Shinners','Ceanothus herbaceus var. pubescens','(S. Watson) Shinners','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19768','','','Ceanothus pubescens (S. Watson) Rydberg ex Small nom. illeg.','Ceanothus pubescens','(S. Watson) Rydberg ex Small nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19769','','','Ceanothus ovatus Desfontaines','Ceanothus ovatus','Desfontaines','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8589','','','Ceanothus sanguineus Pursh','Ceanothus sanguineus','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19770','','','Ceanothus oreganus Nuttall','Ceanothus oreganus','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8591','','','Ceanothus velutinus Douglas','Ceanothus velutinus','Douglas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8590','','','Ceanothus velutinus var. laevigatus Torrey & A. Gray','Ceanothus velutinus var. laevigatus','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19771','','','Ceanothus laevigatus Hooker','Ceanothus laevigatus','Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19772','','','Ceanothus velutinus var. hookeri M.C. Johnston nom. illeg.','Ceanothus velutinus var. hookeri','M.C. Johnston nom. illeg.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19773','','','Ceanothus velutinus subsp. hookeri (M.C. Johnston) C. Schmidt','Ceanothus velutinus subsp. hookeri','(M.C. Johnston) C. Schmidt','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8592','','','Ceanothus velutinus var. velutinus Douglas','Ceanothus velutinus var. velutinus','Douglas','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19774','','','Ceanothus velutinus subsp. velutinus Douglas','Ceanothus velutinus subsp. velutinus','Douglas','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30178','','','Ceanothus subgen. Ceanothus Linnaeus','Ceanothus subgen. Ceanothus','Linnaeus','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('665','','','Rhamneae','Rhamneae','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30390','','','Endotropis Rafinesque','Endotropis','Rafinesque','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30391','','','Endotropis alnifolia (L''Héritier) Hauenschild','Endotropis alnifolia','(L''Héritier) Hauenschild','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30392','','','Girtanneria lineata Necker nom. inval.','Girtanneria lineata','Necker nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29897','','','Apetlorhamnus alnifolia (L''Héritier) Nieuwland','Apetlorhamnus alnifolia','(L''Héritier) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29898','','','Ventia alnifolia (L''Héritier) Hauenschild nom. illeg.','Ventia alnifolia','(L''Héritier) Hauenschild nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8596','','','Rhamnus alnifolia L''Héritier','Rhamnus alnifolia','L''Héritier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1615','','','Rhamnus Linnaeus','Rhamnus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8597','','','Rhamnus cathartica Linnaeus','Rhamnus cathartica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8598','','','Rhamnus davurica Pallas','Rhamnus davurica','Pallas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23852','','','Rhamnus davurica subsp. davurica Pallas','Rhamnus davurica subsp. davurica','Pallas','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19777','','','Rhamnus cathartica var. dahurica (Pallas) Maximowicz','Rhamnus cathartica var. dahurica','(Pallas) Maximowicz','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19778','','','Rhamnus citrifolia (Weston) W. J. Hess & Stearn nom. illeg.','Rhamnus citrifolia','(Weston) W. J. Hess & Stearn nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1891','','','Frangula Miller','Frangula','Miller','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8595','','','Frangula purshiana (de Candolle) A. Gray ex J.G. Cooper','Frangula purshiana','(de Candolle) A. Gray ex J.G. Cooper','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8594','','','Frangula purshiana subsp. purshiana (de Candolle) A. Gray ex J.G. Cooper','Frangula purshiana subsp. purshiana','(de Candolle) A. Gray ex J.G. Cooper','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19776','','','Rhamnus purshiana de Candolle','Rhamnus purshiana','de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8593','','','Frangula alnus Miller','Frangula alnus','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19775','','','Rhamnus frangula Linnaeus','Rhamnus frangula','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('126','','','Elaeagnaceae de Jussieu','Elaeagnaceae','de Jussieu','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1250','','','Hippophae Linnaeus','Hippophae','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5459','','','Hippophae rhamnoides Linnaeus','Hippophae rhamnoides','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23694','','','Elaeagnus rhamnoides (Linnaeus) A. Nelson','Elaeagnus rhamnoides','(Linnaeus) A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1125','','','Elaeagnus Hill','Elaeagnus','Hill','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5457','','','Elaeagnus multiflora Thunberg','Elaeagnus multiflora','Thunberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5458','','','Elaeagnus umbellata Thunberg','Elaeagnus umbellata','Thunberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23692','','','Elaeagnus parvifolia Wallich ex Royle','Elaeagnus parvifolia','Wallich ex Royle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23693','','','Elaeagnus umbellata var. parvifolia (Wallich ex Royle) C.K. Schneider','Elaeagnus umbellata var. parvifolia','(Wallich ex Royle) C.K. Schneider','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5455','','','Elaeagnus angustifolia Linnaeus','Elaeagnus angustifolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5456','','','Elaeagnus commutata Bernhardi ex Rydberg','Elaeagnus commutata','Bernhardi ex Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15815','','','Elaeagnus veteris-castelli Lepage','Elaeagnus veteris-castelli','Lepage','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15814','','','Elaeagnus argentea Pursh nom. illeg.','Elaeagnus argentea','Pursh nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1680','','','Shepherdia Nuttall','Shepherdia','Nuttall','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5461','','','Shepherdia canadensis (Linnaeus) Nuttall','Shepherdia canadensis','(Linnaeus) Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15817','','','Hippophae canadensis Linnaeus','Hippophae canadensis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15818','','','Elaeagnus canadensis (Linnaeus) A. Nelson','Elaeagnus canadensis','(Linnaeus) A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15819','','','Lepargyraea canadensis (Linnaeus) Greene','Lepargyraea canadensis','(Linnaeus) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5460','','','Shepherdia argentea (Pursh) Nuttall','Shepherdia argentea','(Pursh) Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23696','','','Lepargyrea argentea (Pursh) Greene','Lepargyrea argentea','(Pursh) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23695','','','Hippophae argentea Pursh','Hippophae argentea','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15816','','','Elaeagnus utilis A. Nelson','Elaeagnus utilis','A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('172','','','Moraceae Link','Moraceae','Link','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28708','','','Ficus Linnaeus','Ficus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28709','','','Ficus carica Linnaeus','Ficus carica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('617','','','Moreae','Moreae','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1438','','','Morus Linnaeus','Morus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27919','','','Morus alba × Morus rubra','Morus alba × Morus rubra','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6677','','','Morus rubra Linnaeus','Morus rubra','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17368','','','Morus rubra var. tomentosa (Rafinesque) Bureau','Morus rubra var. tomentosa','(Rafinesque) Bureau','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6676','','','Morus alba Linnaeus','Morus alba','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17367','','','Morus tatarica Linnaeus','Morus tatarica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17366','','','Morus alba var. tatarica (Linnaeus) Seringe','Morus alba var. tatarica','(Linnaeus) Seringe','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1387','','','Maclura Nuttall','Maclura','Nuttall','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6675','','','Maclura pomifera (Rafinesque) C.K. Schneider','Maclura pomifera','(Rafinesque) C.K. Schneider','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17364','','','Ioxylon aurantiacum (Nuttall) Rafinesque','Ioxylon aurantiacum','(Nuttall) Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17363','','','Ioxylon pomiferum Rafinesque','Ioxylon pomiferum','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17365','','','Maclura aurantiaca Nuttall','Maclura aurantiaca','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('207','','','Rosaceae de Jussieu','Rosaceae','de Jussieu','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('328','','','Dryadoideae Sweet','Dryadoideae','Sweet','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('542','','','Dryadeae Lamarck & de Candolle','Dryadeae','Lamarck & de Candolle','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1111','','','Dryas Linnaeus','Dryas','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20035','','','Dryas punctata Juzepczuk','Dryas punctata','Juzepczuk','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8743','','','Dryas octopetala subsp. punctata (Juzepczuk) Hultén','Dryas octopetala subsp. punctata','(Juzepczuk) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20034','','','Dryas hookeriana Juzepczuk','Dryas hookeriana','Juzepczuk','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26393','','','Dryas octopetala var. hookeriana (Juzepczuk) Breitung','Dryas octopetala var. hookeriana','(Juzepczuk) Breitung','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26392','','','Dryas octopetala var. angustifolia C.L. Hitchcock','Dryas octopetala var. angustifolia','C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8740','','','Dryas octopetala subsp. hookeriana (Juzepczuk) Hultén','Dryas octopetala subsp. hookeriana','(Juzepczuk) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26394','','','Dryas ajanensis Juzepczuk','Dryas ajanensis','Juzepczuk','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26395','','','Dryas ajanensis subsp. beringensis Jurtzev','Dryas ajanensis subsp. beringensis','Jurtzev','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26396','','','Dryas octopetala var. kamtschatica (Juzepczuk) Hultén','Dryas octopetala var. kamtschatica','(Juzepczuk) Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26397','','','Dryas octopetala var. luteola Hultén','Dryas octopetala var. luteola','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26398','','','Dryas octopetala var. viscida Hultén','Dryas octopetala var. viscida','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20036','','','Dryas × lewinii Rouleau','Dryas × lewinii','Rouleau','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8745','','','Dryas × wyssiana Beauverd nom. inval.','Dryas × wyssiana','Beauverd nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8736','','','Dryas integrifolia Vahl','Dryas integrifolia','Vahl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8735','','','Dryas integrifolia subsp. integrifolia Vahl','Dryas integrifolia subsp. integrifolia','Vahl','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27233','','','Dryas chamissonis Jurtzev nom. illeg.','Dryas chamissonis','Jurtzev nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26388','','','Dryas integrifolia var. canescens Simmons','Dryas integrifolia var. canescens','Simmons','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26389','','','Dryas integrifolia var. subintegrifolia Hultén','Dryas integrifolia var. subintegrifolia','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20030','','','Dryas integrifolia subsp. chamissonis (Sprengel ex Juzepczuk) Scoggan','Dryas integrifolia subsp. chamissonis','(Sprengel ex Juzepczuk) Scoggan','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8729','','','Dryas chamissonis Sprengel ex Juzepczuk','Dryas chamissonis','Sprengel ex Juzepczuk','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8737','','','Dryas integrifolia subsp. sylvatica (Hultén) Hultén','Dryas integrifolia subsp. sylvatica','(Hultén) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27161','','','Dryas integrifolia var. sylvatica Hultén','Dryas integrifolia var. sylvatica','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20032','','','Dryas sylvatica (Hultén) A.E. Porsild','Dryas sylvatica','(Hultén) A.E. Porsild','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8744','','','Dryas × suendermannii Kellerer ex Sundermann','Dryas × suendermannii','Kellerer ex Sundermann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8732','','','Dryas drummondii Richardson ex Hooker','Dryas drummondii','Richardson ex Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23765','','','Dryas octopetala var. drummondii (Richardson ex Hooker) S. Watson','Dryas octopetala var. drummondii','(Richardson ex Hooker) S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8731','','','Dryas drummondii var. drummondii Richardson ex Hooker','Dryas drummondii var. drummondii','Richardson ex Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8733','','','Dryas drummondii var. eglandulosa Porsild','Dryas drummondii var. eglandulosa','Porsild','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8734','','','Dryas drummondii var. tomentosa (Farr) L.O. Williams','Dryas drummondii var. tomentosa','(Farr) L.O. Williams','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23772','','','Dryas incisa Juzepczuk','Dryas incisa','Juzepczuk','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20031','','','Dryas integrifolia subsp. crenulata','Dryas integrifolia subsp. crenulata','','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8730','','','Dryas crenulata','Dryas crenulata','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20033','','','Dryas alaskensis A.E. Porsild','Dryas alaskensis','A.E. Porsild','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26391','','','Dryas punctata subsp. alaskensis (A. E. Porsild) Jurtzev','Dryas punctata subsp. alaskensis','(A. E. Porsild) Jurtzev','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26390','','','Dryas octopetala var. glabrata Hultén','Dryas octopetala var. glabrata','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8738','','','Dryas octopetala subsp. alaskensis (A.E. Porsild) Hultén','Dryas octopetala subsp. alaskensis','(A.E. Porsild) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8739','','','Dryas octopetala Linnaeus','Dryas octopetala','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8742','','','Dryas octopetala subsp. octopetala Linnaeus','Dryas octopetala subsp. octopetala','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8741','','','Dryas octopetala var. octopetala Linnaeus','Dryas octopetala var. octopetala','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1604','','','Purshia de Candolle ex Poiret','Purshia','de Candolle ex Poiret','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8883','','','Purshia tridentata (Pursh) de Candolle','Purshia tridentata','(Pursh) de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23847','','','Tigarea tridentata Pursh','Tigarea tridentata','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('257','','','Rosoideae Arnott','Rosoideae','Arnott','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('668','','','Roseae Lamarck & de Candolle','Roseae','Lamarck & de Candolle','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1627','','','Rosa Linnaeus','Rosa','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~73','','','Rosa (Rosa)','Rosa (Rosa)','','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2282','','','Rosa sect. Rosa','Rosa sect. Rosa','','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8888','','','Rosa arkansana Porter','Rosa arkansana','Porter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23877','','','Rosa alcea Greene','Rosa alcea','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20300','','','Rosa arkansana var. suffulta (Greene) Cockerell','Rosa arkansana var. suffulta','(Greene) Cockerell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20302','','','Rosa suffulta Greene','Rosa suffulta','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20301','','','Rosa conjuncta Rydberg','Rosa conjuncta','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8889','','','Rosa blanda Aiton','Rosa blanda','Aiton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28286','','','Rosa subblanda Rydberg','Rosa subblanda','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28666','','','Rosa blanda var. hispida Farwell','Rosa blanda var. hispida','Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25912','','','Rosa rousseauiorum var. chrysocarpa B. Boivin','Rosa rousseauiorum var. chrysocarpa','B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20304','','','Rosa blanda var. glabra Crépin','Rosa blanda var. glabra','Crépin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20303','','','Rosa blanda var. blanda Aiton','Rosa blanda var. blanda','Aiton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20306','','','Rosa rousseauiorum B. Boivin','Rosa rousseauiorum','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20305','','','Rosa williamsii Fernald','Rosa williamsii','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20307','','','Rosa johannensis Fernald','Rosa johannensis','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8893','','','Rosa cinnamomea Linnaeus','Rosa cinnamomea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28806','','','Rosa majalis Hermann','Rosa majalis','Hermann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8897','','','Rosa gymnocarpa Nuttall','Rosa gymnocarpa','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23887','','','Rosa gymnocarpa var. gymnocarpa Nuttall','Rosa gymnocarpa var. gymnocarpa','Nuttall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23891','','','Rosa piscatoria Greene','Rosa piscatoria','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23890','','','Rosa myriadenia Greene','Rosa myriadenia','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23889','','','Rosa helleri Greene','Rosa helleri','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23888','','','Rosa abietorum Greene','Rosa abietorum','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20314','','','Rosa leucopsis Greene','Rosa leucopsis','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20313','','','Rosa apiculata Greene','Rosa apiculata','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8915','','','Rosa virginiana Miller, nom. cons.','Rosa virginiana','Miller, nom. cons.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30357','','','Rosa virginiana subsp. virginiana Miller','Rosa virginiana subsp. virginiana','Miller','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27160','','','Rosa lucida var. lamprophylla (Rehder) P.V. Heath','Rosa lucida var. lamprophylla','(Rehder) P.V. Heath','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23907','','','Rosa nanella Rydberg','Rosa nanella','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23906','','','Rosa virginiana var. lamprophylla Rehder','Rosa virginiana var. lamprophylla','Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23905','','','Rosa lucida Ehrhart','Rosa lucida','Ehrhart','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20334','','','Rosa virginiana var. virginiana Miller','Rosa virginiana var. virginiana','Miller','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30358','','','Rosa virginiana subsp. minidentata W.H. Lewis','Rosa virginiana subsp. minidentata','W.H. Lewis','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8919','','','Rosa × dulcissima Lunell','Rosa × dulcissima','Lunell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8901','','','Rosa nitida Willdenow','Rosa nitida','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8906','','','Rosa palustris Marshall','Rosa palustris','Marshall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28285','','','Rosa gemella Willdenow ex Elliot','Rosa gemella','Willdenow ex Elliot','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23898','','','Rosa palustris var. dasistema (Rafinesque) E.J. Palmer & Steyermark','Rosa palustris var. dasistema','(Rafinesque) E.J. Palmer & Steyermark','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20323','','','Rosa floridana Rydberg','Rosa floridana','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20324','','','Rosa lancifolia Small','Rosa lancifolia','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20325','','','Rosa obtusiuscula Rydberg','Rosa obtusiuscula','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8911','','','Rosa rugosa Thunberg','Rosa rugosa','Thunberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8917','','','Rosa woodsii Lindley','Rosa woodsii','Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8916','','','Rosa woodsii subsp. ultramontana (S. Watson) Roy L. Taylor & MacBryde','Rosa woodsii subsp. ultramontana','(S. Watson) Roy L. Taylor & MacBryde','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23916','','','Rosa rotundata Rydberg','Rosa rotundata','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23917','','','Rosa salictorum Rydberg','Rosa salictorum','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23918','','','Rosa ultramontana (S. Watson) A. Heller','Rosa ultramontana','(S. Watson) A. Heller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23912','','','Rosa grosseserrata E.E. Nelson','Rosa grosseserrata','E.E. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23913','','','Rosa lapwaiensis H. St.John','Rosa lapwaiensis','H. St.John','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23914','','','Rosa pisocarpa var. ultramontana (S. Watson) M. Peck','Rosa pisocarpa var. ultramontana','(S. Watson) M. Peck','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23915','','','Rosa pyrifera Rydberg','Rosa pyrifera','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20336','','','Rosa californica var. ultramontana S. Watson','Rosa californica var. ultramontana','S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20335','','','Rosa woodsii var. ultramontana (S. Watson) Jepson','Rosa woodsii var. ultramontana','(S. Watson) Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8918','','','Rosa woodsii subsp. woodsii Lindley','Rosa woodsii subsp. woodsii','Lindley','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26481','','','Rosa woodsii var. woodsii Lindley','Rosa woodsii var. woodsii','Lindley','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23908','','','Rosa adenosepala Wooton & Standley','Rosa adenosepala','Wooton & Standley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23909','','','Rosa demareei E.J. Palmer','Rosa demareei','E.J. Palmer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23910','','','Rosa woodsii var. fendleri (Crépin) Rydberg','Rosa woodsii var. fendleri','(Crépin) Rydberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23911','','','Rosa woodsii var. terrens (Lunell) Breitung','Rosa woodsii var. terrens','(Lunell) Breitung','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20337','','','Rosa fendleri Crépin','Rosa fendleri','Crépin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20338','','','Rosa macounii Greene','Rosa macounii','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8887','','','Rosa acicularis Lindley','Rosa acicularis','Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8886','','','Rosa acicularis subsp. sayi (Schweinitz) W.H. Lewis','Rosa acicularis subsp. sayi','(Schweinitz) W.H. Lewis','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25609','','','Rosa acicularis var. sayi (Schweinitz) Rehder','Rosa acicularis var. sayi','(Schweinitz) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23876','','','Rosa butleri Rydberg','Rosa butleri','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20298','','','Rosa acicularis var. bourgeauiana Crépin','Rosa acicularis var. bourgeauiana','Crépin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20297','','','Rosa sayi Schweinitz','Rosa sayi','Schweinitz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9744','','','Rosa × warleyensis Baker','Rosa × warleyensis','Baker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8892','','','Rosa carolina Linnaeus','Rosa carolina','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9743','','','Rosa carolina subsp. subserrulata (Rydberg) W.H. Lewis','Rosa carolina subsp. subserrulata','(Rydberg) W.H. Lewis','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23885','','','Rosa rudiuscula Greene','Rosa rudiuscula','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23886','','','Rosa texarkana Rydberg','Rosa texarkana','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23884','','','Rosa palmeri Rydberg','Rosa palmeri','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21757','','','Rosa subserrulata Rydberg','Rosa subserrulata','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8891','','','Rosa carolina subsp. carolina Linnaeus','Rosa carolina subsp. carolina','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23881','','','Rosa carolina var. villosa (Best) Rehder','Rosa carolina var. villosa','(Best) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23882','','','Rosa humilis Marshall','Rosa humilis','Marshall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23879','','','Rosa aucuparia Rydberg','Rosa aucuparia','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23880','','','Rosa carolina var. grandiflora (Baker) Rehder','Rosa carolina var. grandiflora','(Baker) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23883','','','Rosa parviflora Ehrhart','Rosa parviflora','Ehrhart','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20308','','','Rosa lyonii Pursh','Rosa lyonii','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20309','','','Rosa serrulata Rafinesque','Rosa serrulata','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8908','','','Rosa pisocarpa A. Gray','Rosa pisocarpa','A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8907','','','Rosa pisocarpa subsp. pisocarpa A. Gray','Rosa pisocarpa subsp. pisocarpa','A. Gray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28287','','','Rosa pisocarpa var. pisocarpa A. Gray','Rosa pisocarpa var. pisocarpa','A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20326','','','Rosa pisocarpa var. rivalis (Eastwood) Jepson','Rosa pisocarpa var. rivalis','(Eastwood) Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20327','','','Rosa rivalis Eastwood','Rosa rivalis','Eastwood','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30359','','','Rosa × canadensis W.H. Lewis','Rosa × canadensis','W.H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20329','','','Rosa glauca Pourret','Rosa glauca','Pourret','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8910','','','Rosa rubrifolia Villars','Rosa rubrifolia','Villars','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8903','','','Rosa nutkana C. Presl','Rosa nutkana','C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8904','','','Rosa nutkana subsp. nutkana C. Presl','Rosa nutkana subsp. nutkana','C. Presl','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28288','','','Rosa nutkana var. nutkana C. Presl','Rosa nutkana var. nutkana','C. Presl','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23897','','','Rosa aleutensis Crépin','Rosa aleutensis','Crépin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20321','','','Rosa nutkana var. muriculata C. Presl','Rosa nutkana var. muriculata','C. Presl','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20320','','','Rosa durandii Crépin','Rosa durandii','Crépin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20315','','','Rosa nutkana var. setosa G.N. Jones','Rosa nutkana var. setosa','G.N. Jones','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8902','','','Rosa nutkana subsp. macdougalii (Holzinger) Piper','Rosa nutkana subsp. macdougalii','(Holzinger) Piper','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20317','','','Rosa nutkana var. hispida Fernald','Rosa nutkana var. hispida','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20318','','','Rosa rainierensis G.N. Jones','Rosa rainierensis','G.N. Jones','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20319','','','Rosa spaldingii Crépin ex Rydberg','Rosa spaldingii','Crépin ex Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20316','','','Rosa macdougalii Holzinger','Rosa macdougalii','Holzinger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30364','','','Rosa × hainesii W. H. Lewis','Rosa × hainesii','W. H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30363','','','Rosa × gilmaniana W.H. Lewis','Rosa × gilmaniana','W.H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30366','','','Rosa × hodgdonii W.H. Lewis','Rosa × hodgdonii','W.H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30365','','','Rosa × harmsiana W.H. Lewis','Rosa × harmsiana','W.H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20296','','','Rosa × engelmannii S. Watson','Rosa × engelmannii','S. Watson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30362','','','Rosa × engelmannii subsp. occidentalis W.H. Lewis','Rosa × engelmannii subsp. occidentalis','W.H. Lewis','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30361','','','Rosa × engelmannii subsp. britannicae-columbiae W. H. Lewis','Rosa × engelmannii subsp. britannicae-columbiae','W. H. Lewis','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30360','','','Rosa × churchillii W.H. Lewis','Rosa × churchillii','W.H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30368','','','Rosa × per-axeliana W.H. Lewis','Rosa × per-axeliana','W.H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30367','','','Rosa × oldhamii W.H. Lewis','Rosa × oldhamii','W.H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30369','','','Rosa × victoriana W.H. Lewis','Rosa × victoriana','W.H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2283','','','Rosa sect. Caninae de Candolle ex Seringe','Rosa sect. Caninae','de Candolle ex Seringe','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8909','','','Rosa rubiginosa Linnaeus','Rosa rubiginosa','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23893','','','Rosa rubiginosa var. nemoralis (Léman) Thory','Rosa rubiginosa var. nemoralis','(Léman) Thory','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23896','','','Rosa rubiginosa var. micrantha (Borrer) Lindley','Rosa rubiginosa var. micrantha','(Borrer) Lindley','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23895','','','Rosa nemoralis Léman','Rosa nemoralis','Léman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8899','','','Rosa micrantha Borrer','Rosa micrantha','Borrer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23892','','','Rosa rubiginosa var. rubiginosa Linnaeus','Rosa rubiginosa var. rubiginosa','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23894','','','Rosa suaveolens Pursh','Rosa suaveolens','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20328','','','Rosa eglanteria Linnaeus nom. rej.','Rosa eglanteria','Linnaeus nom. rej.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8890','','','Rosa canina Linnaeus','Rosa canina','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23878','','','Rosa montezumae Humboldt & Bonpland ex Thory','Rosa montezumae','Humboldt & Bonpland ex Thory','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8894','','','Rosa corymbifera Borkhausen','Rosa corymbifera','Borkhausen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8895','','','Rosa dumetorum Thuillier','Rosa dumetorum','Thuillier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8914','','','Rosa tomentosa Smith','Rosa tomentosa','Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20333','','','Rosa tomentosa var. globulosa Rouy','Rosa tomentosa var. globulosa','Rouy','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2285','','','Rosa sect. Systylae de Candolle','Rosa sect. Systylae','de Candolle','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8900','','','Rosa multiflora Thunberg','Rosa multiflora','Thunberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2286','','','Rosa sect. Pimpinellifoliae de Candolle ex Seringe','Rosa sect. Pimpinellifoliae','de Candolle ex Seringe','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8913','','','Rosa spinosissima Linnaeus','Rosa spinosissima','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23903','','','Rosa illinoiensis Baker','Rosa illinoiensis','Baker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23904','','','Rosa lutescens Pursh','Rosa lutescens','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20332','','','Rosa pimpinellifolia Linnaeus','Rosa pimpinellifolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8898','','','Rosa hugonis Hemsley','Rosa hugonis','Hemsley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2284','','','Rosa sect. Gallicae Crépin','Rosa sect. Gallicae','Crépin','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20311','','','Rosa × centifolia Linnaeus','Rosa × centifolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8896','','','Rosa gallica Linnaeus','Rosa gallica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20310','','','Rosa austriaca Crantz','Rosa austriaca','Crantz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20312','','','Rosa × damascena Miller','Rosa × damascena','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30858','','','Rosa gallica var. damascena Voss','Rosa gallica var. damascena','Voss','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28805','','','Rosa hemisphaerica Herrmann','Rosa hemisphaerica','Herrmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30356','','','Rosa sect. Americanae W.H. Lewis','Rosa sect. Americanae','W.H. Lewis','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8912','','','Rosa setigera Michaux','Rosa setigera','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23902','','','Rosa setigera var. elatior Persoon','Rosa setigera var. elatior','Persoon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23901','','','Rosa setigera var. glabra Torrey & A. Gray','Rosa setigera var. glabra','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20330','','','Rosa rubifolia R. Brown','Rosa rubifolia','R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20331','','','Rosa setigera var. tomentosa Torrey & A. Gray','Rosa setigera var. tomentosa','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23900','','','Rosa sect. Chinenses de Candolle ex Seringe','Rosa sect. Chinenses','de Candolle ex Seringe','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8905','','','Rosa × odorata (Andrews) Sweet','Rosa × odorata','(Andrews) Sweet','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20322','','','Rosa indica var. odorata Andrews','Rosa indica var. odorata','Andrews','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2052','','','Rosa subgen. Rosa','Rosa subgen. Rosa','','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('564','','','Colurieae Rydberg','Colurieae','Rydberg','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1204','','','Geum Linnaeus','Geum','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8772','','','Geum rivale Linnaeus','Geum rivale','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8770','','','Geum peckii Pursh','Geum peckii','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20089','','','Geum radiatum var. peckii (Pursh) A. Gray','Geum radiatum var. peckii','(Pursh) A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8776','','','Geum urbanum Linnaeus','Geum urbanum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8773','','','Geum schofieldii Calder & Roy L. Taylor','Geum schofieldii','Calder & Roy L. Taylor','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20095','','','Geum × macranthum','Geum × macranthum','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8778','','','Geum virginianum Linnaeus','Geum virginianum','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20098','','','Geum hirsutum Muhlenberg ex Link','Geum hirsutum','Muhlenberg ex Link','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20097','','','Geum flavum (Porter) E.P. Bicknell','Geum flavum','(Porter) E.P. Bicknell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8777','','','Geum vernum (Rafinesque) Torrey & A. Gray','Geum vernum','(Rafinesque) Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20096','','','Stylypus vernus Rafinesque','Stylypus vernus','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8780','','','Geum × catlingii J.-P. Bernard & R. Gauthier','Geum × catlingii','J.-P. Bernard & R. Gauthier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8779','','','Geum × aurantiacum Fries ex Scheutz','Geum × aurantiacum','Fries ex Scheutz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8763','','','Geum aleppicum Jacquin','Geum aleppicum','Jacquin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23867','','','Geum strictum var. decurrens (Rydberg) Kearney & Peebles','Geum strictum var. decurrens','(Rydberg) Kearney & Peebles','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23866','','','Geum decurrens Rydberg','Geum decurrens','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20077','','','Geum aleppicum subsp. strictum (Aiton) R.T. Clausen','Geum aleppicum subsp. strictum','(Aiton) R.T. Clausen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20078','','','Geum aleppicum var. strictum (Aiton) Fernald','Geum aleppicum var. strictum','(Aiton) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20079','','','Geum strictum Aiton nom. illeg.','Geum strictum','Aiton nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8599','','','Geum rossii (R. Brown) Seringe','Geum rossii','(R. Brown) Seringe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30001','','','Geum rossii var. rossii (R. Brown) Seringe','Geum rossii var. rossii','(R. Brown) Seringe','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19779','','','Geum rossii var. depressum (Greene) C.L. Hitchcock','Geum rossii var. depressum','(Greene) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19780','','','Geum rossii var. turbinatum (Rydberg) C.L. Hitchcock','Geum rossii var. turbinatum','(Rydberg) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19781','','','Sieversia rossii R. Brown','Sieversia rossii','R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19782','','','Acomastylis rossii (R. Brown) Greene','Acomastylis rossii','(R. Brown) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19784','','','Sieversia gracilipes (Piper) Greene','Sieversia gracilipes','(Piper) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19783','','','Geum turbinatum Rydberg','Geum turbinatum','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8765','','','Geum canadense Jacquin','Geum canadense','Jacquin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20081','','','Geum canadense var. camporum (Rydberg) Fernald & Weatherby','Geum canadense var. camporum','(Rydberg) Fernald & Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20082','','','Geum canadense var. grimesii Fernald & Weatherby','Geum canadense var. grimesii','Fernald & Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20083','','','Geum canadense var. texanum Fernald & Weatherby','Geum canadense var. texanum','Fernald & Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20084','','','Geum album J.F. Gmelin','Geum album','J.F. Gmelin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20080','','','Geum canadense var. brevipes Fernald','Geum canadense var. brevipes','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20085','','','Geum camporum Rydberg','Geum camporum','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8764','','','Geum calthifolium Menzies ex Smith','Geum calthifolium','Menzies ex Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8767','','','Geum laciniatum Murray','Geum laciniatum','Murray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31266','','','Geum laciniatum var. laciniatum Murray','Geum laciniatum var. laciniatum','Murray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20088','','','Geum laciniatum var. trichocarpum Fernald','Geum laciniatum var. trichocarpum','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8766','','','Geum glaciale Adams ex Fischer & C.A. Meyer','Geum glaciale','Adams ex Fischer & C.A. Meyer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20086','','','Novosierversia glacialis (Adams ex Fischer & C.A. Meyer) F. Bolle','Novosierversia glacialis','(Adams ex Fischer & C.A. Meyer) F. Bolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20087','','','Sieversia glacialis (Adams ex Fischer & C. A. Meyer) R. Brown','Sieversia glacialis','(Adams ex Fischer & C. A. Meyer) R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8775','','','Geum triflorum Pursh','Geum triflorum','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8774','','','Geum triflorum var. triflorum Pursh','Geum triflorum var. triflorum','Pursh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23868','','','Erythrocoma triflora (Pursh) Greene','Erythrocoma triflora','(Pursh) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23869','','','Sieversia triflora (Pursh) R. Brown','Sieversia triflora','(Pursh) R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9595','','','Geum triflorum var. ciliatum (Pursh) Fassett','Geum triflorum var. ciliatum','(Pursh) Fassett','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21640','','','Sieversia ciliata (Pursh) G. Don','Sieversia ciliata','(Pursh) G. Don','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21639','','','Sieversia canescens (Greene) Rydberg','Sieversia canescens','(Greene) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21638','','','Sieversia campanulata (Greene) Rydberg','Sieversia campanulata','(Greene) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21637','','','Geum canescens (Greene) Munz','Geum canescens','(Greene) Munz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21636','','','Geum ciliatum Pursh','Geum ciliatum','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21635','','','Geum triflorum var. canescens (Greene) Kartesz & Gandhi','Geum triflorum var. canescens','(Greene) Kartesz & Gandhi','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21634','','','Geum triflorum var. campanulatum (Greene) C.L. Hitchcock','Geum triflorum var. campanulatum','(Greene) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32579','','','Geum aleppicum × Geum canadense','Geum aleppicum × Geum canadense','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8781','','','Geum × pulchrum Fernald','Geum × pulchrum','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8990','','','Geum fragarioides (Michaux) Smedmark','Geum fragarioides','(Michaux) Smedmark','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23870','','','Waldsteinia doniana Trattinnick','Waldsteinia doniana','Trattinnick','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23871','','','Waldsteinia fragarioides subsp. doniana (Trattinnick) Teppner','Waldsteinia fragarioides subsp. doniana','(Trattinnick) Teppner','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20735','','','Dalibarda fragarioides Michaux','Dalibarda fragarioides','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20736','','','Waldsteinia fragarioides subsp. fragarioides (Michaux) Trattinnick','Waldsteinia fragarioides subsp. fragarioides','(Michaux) Trattinnick','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20734','','','Waldsteinia fragarioides (Michaux) Trattinnick','Waldsteinia fragarioides','(Michaux) Trattinnick','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9596','','','Geum × macranthum (Kearney) B. Boivin','Geum × macranthum','(Kearney) B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9598','','','Geum × macneillii J.-P. Bernard & R. Gauthier','Geum × macneillii','J.-P. Bernard & R. Gauthier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9599','','','Geum × pervale B. Boivin','Geum × pervale','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8769','','','Geum macrophyllum Willdenow','Geum macrophyllum','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8768','','','Geum macrophyllum var. macrophyllum Willdenow','Geum macrophyllum var. macrophyllum','Willdenow','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27291','','','Geum macrophyllum subsp. macrophyllum Willdenow','Geum macrophyllum subsp. macrophyllum','Willdenow','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8771','','','Geum macrophyllum var. perincisum (Rydberg) Raup','Geum macrophyllum var. perincisum','(Rydberg) Raup','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20090','','','Geum perincisum Rydberg','Geum perincisum','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20091','','','Geum macrophyllum subsp. perincisum (Rydberg) Hultén','Geum macrophyllum subsp. perincisum','(Rydberg) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20092','','','Geum macrophyllum var. rydbergii Farwell','Geum macrophyllum var. rydbergii','Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20094','','','Geum perincisum var. intermedium B. Boivin','Geum perincisum var. intermedium','B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20093','','','Geum oregonense (Scheutz) Rydberg','Geum oregonense','(Scheutz) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('409','','','Potentilleae Sweet','Potentilleae','Sweet','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1682','','','Sibbaldia Linnaeus','Sibbaldia','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8960','','','Sibbaldia procumbens Linnaeus','Sibbaldia procumbens','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20655','','','Potentilla sibbaldi Haller f.','Potentilla sibbaldi','Haller f.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8961','','','Sibbaldia tridentata (Aiton) Paule & Soják','Sibbaldia tridentata','(Aiton) Paule & Soják','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28968','','','Potentilla retusa O.F. Müller nom. rej.','Potentilla retusa','O.F. Müller nom. rej.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28967','','','Sibbaldia retusa (O.F. Müller) T. Eriksson nom. rej.','Sibbaldia retusa','(O.F. Müller) T. Eriksson nom. rej.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20656','','','Potentilla tridentata Aiton','Potentilla tridentata','Aiton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20657','','','Sibbaldiopsis tridentata (Aiton) Rydberg','Sibbaldiopsis tridentata','(Aiton) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1884','','','Drymocallis Fourreau ex Rydberg','Drymocallis','Fourreau ex Rydberg','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32872','','','Drymocallis fissa (Nuttall) Rydberg','Drymocallis fissa','(Nuttall) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8816','','','Potentilla fissa Nuttall','Potentilla fissa','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8821','','','Drymocallis pseudorupestris (Rydberg) Rydberg','Drymocallis pseudorupestris','(Rydberg) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8820','','','Drymocallis pseudorupestris var. saxicola Ertter','Drymocallis pseudorupestris var. saxicola','Ertter','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8819','','','Drymocallis glandulosa (Lindley) Rydberg','Drymocallis glandulosa','(Lindley) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8818','','','Drymocallis glandulosa var. glandulosa (Lindley) Rydberg','Drymocallis glandulosa var. glandulosa','(Lindley) Rydberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23773','','','Potentilla glandulosa Lindley','Potentilla glandulosa','Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20182','','','Potentilla glandulosa var. glandulosa Lindley','Potentilla glandulosa var. glandulosa','Lindley','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8799','','','Drymocallis convallaria (Rydberg) Rydberg','Drymocallis convallaria','(Rydberg) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20165','','','Potentilla arguta var. convallaria (Rydberg) Th. Wolf','Potentilla arguta var. convallaria','(Rydberg) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20163','','','Potentilla convallaria Rydberg','Potentilla convallaria','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20164','','','Potentilla arguta subsp. convallaria (Rydberg) D.D. Keck','Potentilla arguta subsp. convallaria','(Rydberg) D.D. Keck','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8798','','','Drymocallis arguta (Pursh) Rydberg','Drymocallis arguta','(Pursh) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20161','','','Potentilla arguta Pursh','Potentilla arguta','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20162','','','Drymocallis agrimonioides (Pursh) Rydberg','Drymocallis agrimonioides','(Pursh) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33511','','','Argentina Hill','Argentina','Hill','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26148','','','Argentina pacifica (Howell) Rydberg','Argentina pacifica','(Howell) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26147','','','Potentilla rolandii B. Boivin','Potentilla rolandii','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26150','','','Argentina litoralis Rydberg','Argentina litoralis','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26149','','','Potentilla anserina var. rolandii (B. Boivin) B. Boivin','Potentilla anserina var. rolandii','(B. Boivin) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21765','','','Argentina occidentalis Rydberg','Argentina occidentalis','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21764','','','Potentilla pacifica Howell','Potentilla pacifica','Howell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21766','','','Potentilla anserina var. grandis Torrey & A. Gray','Potentilla anserina var. grandis','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21767','','','Potentilla egedei subsp. grandis (Torrey & A. Gray) Hultén','Potentilla egedei subsp. grandis','(Torrey & A. Gray) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21768','','','Potentilla egedei subsp. pacifica (Howell) L.A. Sergienko','Potentilla egedei subsp. pacifica','(Howell) L.A. Sergienko','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9748','','','Potentilla anserina subsp. pacifica (Howell) Rousi','Potentilla anserina subsp. pacifica','(Howell) Rousi','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21761','','','Argentina subarctica Rydberg','Argentina subarctica','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21760','','','Potentilla yukonensis Hultén','Potentilla yukonensis','Hultén','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21763','','','Potentilla egedei subsp. yukonensis (Hultén) Hultén','Potentilla egedei subsp. yukonensis','(Hultén) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21762','','','Potentilla anserina var. yukonensis (Hultén) B. Boivin','Potentilla anserina var. yukonensis','(Hultén) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9747','','','Potentilla anserina subsp. yukonensis (Hultén) Soják ex Elven & D.F. Murray','Potentilla anserina subsp. yukonensis','(Hultén) Soják ex Elven & D.F. Murray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23585','','','Argentina anserina (Linnaeus) Rydberg','Argentina anserina','(Linnaeus) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19833','','','Argentina anserina subsp. groenlandica (Trattinnick) Á. Löve','Argentina anserina subsp. groenlandica','(Trattinnick) Á. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19834','','','Potentilla egedei Wormskjöld ex Hornemann','Potentilla egedei','Wormskjöld ex Hornemann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19835','','','Argentina anserina subsp. egedei (Wormskjöld ex Hornemann) Á. Löve & Ritchie','Argentina anserina subsp. egedei','(Wormskjöld ex Hornemann) Á. Löve & Ritchie','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19836','','','Argentina egedei (Wormskjöld ex Hornemann) Rydberg','Argentina egedei','(Wormskjöld ex Hornemann) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19831','','','Potentilla egedei var. groenlandica (Trattinnick) Polunin','Potentilla egedei var. groenlandica','(Trattinnick) Polunin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8634','','','Potentilla anserina subsp. groenlandica Trattinnick','Potentilla anserina subsp. groenlandica','Trattinnick','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8635','','','Potentilla anserina subsp. egedei (Wormskjöld ex Hornemann) Hiitonen','Potentilla anserina subsp. egedei','(Wormskjöld ex Hornemann) Hiitonen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19830','','','Argentina anserina subsp. anserina (Linnaeus) Rydberg','Argentina anserina subsp. anserina','(Linnaeus) Rydberg','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28089','','','Potentilla pratincola B. Boivin','Potentilla pratincola','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28088','','','Argentina argentea Rydberg','Argentina argentea','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19829','','','Potentilla anserina var. sericea Hayne','Potentilla anserina var. sericea','Hayne','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8633','','','Potentilla anserina Linnaeus','Potentilla anserina','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8632','','','Potentilla anserina subsp. anserina Linnaeus','Potentilla anserina subsp. anserina','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2263','','','Potentilla sect. Anserinae Gaudin','Potentilla sect. Anserinae','Gaudin','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('833','','','Aphanes Linnaeus','Aphanes','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8631','','','Aphanes australis Rydberg','Aphanes australis','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28755','','','Aphanes microcarpa','Aphanes microcarpa','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19828','','','Aphanes inexspectata W. Lippert','Aphanes inexspectata','W. Lippert','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8630','','','Aphanes arvensis Linnaeus','Aphanes arvensis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19827','','','Alchemilla arvensis (Linnaeus) Scopoli','Alchemilla arvensis','(Linnaeus) Scopoli','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9768','','','Aphanes occidentalis (Nuttall) Rydberg','Aphanes occidentalis','(Nuttall) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21808','','','Aphanes macrosepala Rydberg','Aphanes macrosepala','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21806','','','Alchemilla occidentalis Nuttall','Alchemilla occidentalis','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21807','','','Aphanes cuneifolia (Nuttall) Rydberg','Aphanes cuneifolia','(Nuttall) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1180','','','Fragaria Linnaeus','Fragaria','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8758','','','Fragaria virginiana Miller','Fragaria virginiana','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8759','','','Fragaria virginiana subsp. platypetala (Rydberg) Staudt','Fragaria virginiana subsp. platypetala','(Rydberg) Staudt','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20067','','','Fragaria sibbaldifolia Rydberg','Fragaria sibbaldifolia','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20066','','','Fragaria platypetala Rydberg','Fragaria platypetala','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20069','','','Fragaria truncata Rydberg','Fragaria truncata','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20068','','','Fragaria suksdorfii Rydberg','Fragaria suksdorfii','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20070','','','Fragaria virginiana var. platypetala (Rydberg) H.M. Hall','Fragaria virginiana var. platypetala','(Rydberg) H.M. Hall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8757','','','Fragaria virginiana subsp. glauca (S. Watson) Staudt','Fragaria virginiana subsp. glauca','(S. Watson) Staudt','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20065','','','Fragaria virginiana var. terrae-novae (Rydberg) Fernald & Wiegand','Fragaria virginiana var. terrae-novae','(Rydberg) Fernald & Wiegand','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20064','','','Fragaria terrae-novae Rydberg','Fragaria terrae-novae','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20061','','','Fragaria virginiana var. glauca S. Watson','Fragaria virginiana var. glauca','S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20063','','','Fragaria multicipita Fernald','Fragaria multicipita','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20062','','','Fragaria glauca (S. Watson) Rydberg','Fragaria glauca','(S. Watson) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8760','','','Fragaria virginiana subsp. virginiana Miller','Fragaria virginiana subsp. virginiana','Miller','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29985','','','Potentilla virginiana (Miller) E.H.L. Krause','Potentilla virginiana','(Miller) E.H.L. Krause','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31544','','','Fragaria canadensis Michaux nom. illeg.','Fragaria canadensis','Michaux nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20073','','','Fragaria virginiana var. canadensis (Michaux) Farwell','Fragaria virginiana var. canadensis','(Michaux) Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20072','','','Fragaria virginiana var. australis Rydberg','Fragaria virginiana var. australis','Rydberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20071','','','Fragaria australis (Rydberg) Rydberg','Fragaria australis','(Rydberg) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33258','','','Fragaria virginiana Duchesne nom. inval.','Fragaria virginiana','Duchesne nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8755','','','Fragaria vesca Linnaeus','Fragaria vesca','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9745','','','Fragaria vesca subsp. vesca Linnaeus','Fragaria vesca subsp. vesca','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8754','','','Fragaria vesca subsp. americana (Porter) Staudt','Fragaria vesca subsp. americana','(Porter) Staudt','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20054','','','Fragaria americana (Porter) Britton','Fragaria americana','(Porter) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20055','','','Fragaria vesca var. americana Porter','Fragaria vesca var. americana','Porter','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8756','','','Fragaria vesca subsp. bracteata (A. Heller) Staudt','Fragaria vesca subsp. bracteata','(A. Heller) Staudt','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20058','','','Fragaria crinita Rydberg','Fragaria crinita','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20059','','','Fragaria helleri Holzinger','Fragaria helleri','Holzinger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20056','','','Fragaria bracteata A. Heller','Fragaria bracteata','A. Heller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20057','','','Fragaria vesca var. bracteata (A. Heller) R.J. Davis','Fragaria vesca var. bracteata','(A. Heller) R.J. Davis','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20060','','','Fragaria vesca var. crinita (Rydberg) C.L. Hitchcock','Fragaria vesca var. crinita','(Rydberg) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8752','','','Fragaria chiloensis (Linnaeus) Miller','Fragaria chiloensis','(Linnaeus) Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8753','','','Fragaria chiloensis subsp. pacifica Staudt','Fragaria chiloensis subsp. pacifica','Staudt','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8751','','','Fragaria chiloensis subsp. lucida (E. Vilmorin ex J. Gay) Staudt','Fragaria chiloensis subsp. lucida','(E. Vilmorin ex J. Gay) Staudt','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20053','','','Fragaria lucida E. Vilmorin ex J. Gay','Fragaria lucida','E. Vilmorin ex J. Gay','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8762','','','Fragaria × ananassa Duchesne ex Rozier','Fragaria × ananassa','Duchesne ex Rozier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32437','','','Fragaria × ananassa subsp. ananassa Duchesne ex Rozier','Fragaria × ananassa subsp. ananassa','Duchesne ex Rozier','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8761','','','Fragaria × ananassa subsp. cuneifolia (Nuttall ex Howell) Staudt','Fragaria × ananassa subsp. cuneifolia','(Nuttall ex Howell) Staudt','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20076','','','Fragaria × ananassa var. cuneifolia (Nuttall ex Howell) Staudt','Fragaria × ananassa var. cuneifolia','(Nuttall ex Howell) Staudt','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20075','','','Fragaria cuneifolia Nuttall ex Howell','Fragaria cuneifolia','Nuttall ex Howell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1078','','','Dasiphora Rafinesque','Dasiphora','Rafinesque','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8728','','','Dasiphora fruticosa (Linnaeus) Rydberg','Dasiphora fruticosa','(Linnaeus) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24151','','','Dasiphora fruticosa var. tenuifolia (Willdenow ex Schlechtendahl) Rydberg','Dasiphora fruticosa var. tenuifolia','(Willdenow ex Schlechtendahl) Rydberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20022','','','Dasiphora fruticosa subsp. floribunda (Pursh) Kartesz','Dasiphora fruticosa subsp. floribunda','(Pursh) Kartesz','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20026','','','Pentaphylloides fruticosa (Linnaeus) O. Schwarz nom. illeg.','Pentaphylloides fruticosa','(Linnaeus) O. Schwarz nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20025','','','Pentaphylloides floribunda (Pursh) Á. Löve nom. illeg.','Pentaphylloides floribunda','(Pursh) Á. Löve nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20024','','','Dasiphora floribunda (Pursh) Rafinesque','Dasiphora floribunda','(Pursh) Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20023','','','Potentilla fruticosa Linnaeus','Potentilla fruticosa','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20029','','','Potentilla fruticosa var. tenuifolia Lehmann','Potentilla fruticosa var. tenuifolia','Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20028','','','Potentilla fruticosa subsp. floribunda (Pursh) Elkington','Potentilla fruticosa subsp. floribunda','(Pursh) Elkington','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20027','','','Potentilla floribunda Pursh','Potentilla floribunda','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1019','','','Comarum Linnaeus','Comarum','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8643','','','Comarum palustre Linnaeus','Comarum palustre','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29984','','','Potentilla comarum Nestler','Potentilla comarum','Nestler','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19863','','','Fragaria palustris (Linnaeus) Crantz','Fragaria palustris','(Linnaeus) Crantz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19864','','','Potentilla palustris (Linnaeus) Scopoli','Potentilla palustris','(Linnaeus) Scopoli','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19865','','','Potentilla palustris var. palustris (Linnaeus) Scopoli','Potentilla palustris var. palustris','(Linnaeus) Scopoli','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19867','','','Potentilla palustris var. villosa (Persoon) Lehmann','Potentilla palustris var. villosa','(Persoon) Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19866','','','Potentilla palustris var. parvifolia (Rafinesque) Fernald & B.H. Long','Potentilla palustris var. parvifolia','(Rafinesque) Fernald & B.H. Long','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19869','','','Comarum palustre subsp. arcticum (Gandoger) Tzvelev','Comarum palustre subsp. arcticum','(Gandoger) Tzvelev','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19868','','','Comarum palustre subsp. angustifolium (Rafinesque) Tzvelev','Comarum palustre subsp. angustifolium','(Rafinesque) Tzvelev','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('982','','','Chamaerhodos Bunge','Chamaerhodos','Bunge','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8642','','','Chamaerhodos erecta (Linnaeus) Bunge','Chamaerhodos erecta','(Linnaeus) Bunge','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19859','','','Sibbaldia erecta Linnaeus','Sibbaldia erecta','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19860','','','Chamaerhodos erecta subsp. nuttallii (Pickering ex Rydberg) Hultén','Chamaerhodos erecta subsp. nuttallii','(Pickering ex Rydberg) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19861','','','Chamaerhodos erecta var. parviflora (Nuttall) C.L. Hitchcock','Chamaerhodos erecta var. parviflora','(Nuttall) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19862','','','Chamaerhodos nuttallii Pickering ex Rydberg','Chamaerhodos nuttallii','Pickering ex Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1586','','','Potentilla Linnaeus','Potentilla','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2281','','','Potentilla sect. Subjugae (Rydberg) A. Nelson','Potentilla sect. Subjugae','(Rydberg) A. Nelson','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8851','','','Potentilla subjuga Rydberg','Potentilla subjuga','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20254','','','Potentilla osterhoutiana Th. Wolf','Potentilla osterhoutiana','Th. Wolf','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28090','','','Potentilla sect. Lupinoides Tausch','Potentilla sect. Lupinoides','Tausch','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8849','','','Potentilla sterilis (Linnaeus) Garcke','Potentilla sterilis','(Linnaeus) Garcke','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20250','','','Fragaria sterilis Linnaeus','Fragaria sterilis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8857','','','Potentilla × tundricola Soják','Potentilla × tundricola','Soják','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20038','','','Potentilla indica (Andrews) Th. Wolf','Potentilla indica','(Andrews) Th. Wolf','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27751','','','Potentilla indica var. indica (Andrews) Th. Wolf','Potentilla indica var. indica','(Andrews) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20037','','','Fragaria indica Andrews','Fragaria indica','Andrews','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8747','','','Duchesnea indica (Andrews) Focke','Duchesnea indica','(Andrews) Focke','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8746','','','Duchesnea indica var. indica (Andrews) Focke','Duchesnea indica var. indica','(Andrews) Focke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2272','','','Potentilla sect. Concinnae (Rydberg) A. Nelson','Potentilla sect. Concinnae','(Rydberg) A. Nelson','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8828','','','Potentilla macounii Rydberg','Potentilla macounii','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20193','','','Potentilla concinna var. macounii (Rydberg) C.L. Hitchcock','Potentilla concinna var. macounii','(Rydberg) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8806','','','Potentilla concinna Richardson','Potentilla concinna','Richardson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8805','','','Potentilla concinna var. concinna Richardson','Potentilla concinna var. concinna','Richardson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20167','','','Potentilla humifusa Nuttall nom. illeg.','Potentilla humifusa','Nuttall nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9770','','','Potentilla concinna var. divisa Rydberg','Potentilla concinna var. divisa','Rydberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21810','','','Potentilla divisa (Rydberg) Rydberg','Potentilla divisa','(Rydberg) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28792','','','Potentilla multisecta (S. Watson) Rydberg','Potentilla multisecta','(S. Watson) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28793','','','Potentilla diversifolia var. multisecta S. Watson','Potentilla diversifolia var. multisecta','S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28794','','','Potentilla dissecta var. multisecta (S. Watson) S. Watson','Potentilla dissecta var. multisecta','(S. Watson) S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2273','','','Potentilla sect. Graciles (Rydberg) A. Nelson','Potentilla sect. Graciles','(Rydberg) A. Nelson','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8810','','','Potentilla drummondii Lehmann','Potentilla drummondii','Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28124','','','Potentilla cascadensis Rydberg','Potentilla cascadensis','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28125','','','Potentilla drummondii var. cascadensis (Rydberg) Th. Wolf','Potentilla drummondii var. cascadensis','(Rydberg) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8842','','','Potentilla pulcherrima Lehmann','Potentilla pulcherrima','Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28120','','','Potentilla filipes Rydberg','Potentilla filipes','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28122','','','Potentilla pulcherrima var. filipes (Rydberg) Th. Wolf','Potentilla pulcherrima var. filipes','(Rydberg) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28121','','','Potentilla pulcherrima var. condensata Th. Wolf','Potentilla pulcherrima var. condensata','Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28123','','','Potentilla pulcherrima var. wardii (Greene) Soják','Potentilla pulcherrima var. wardii','(Greene) Soják','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20234','','','Potentilla gracilis var. filipes (Rydbgerg) B. Boivin','Potentilla gracilis var. filipes','(Rydbgerg) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20232','','','Potentilla camporum Rydberg','Potentilla camporum','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20233','','','Potentilla gracilis var. pulcherrima (Lehmann) Fernald','Potentilla gracilis var. pulcherrima','(Lehmann) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8823','','','Potentilla gracilis Douglas ex Hooker','Potentilla gracilis','Douglas ex Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9815','','','Potentilla gracilis var. elmeri (Rydberg) Jepson','Potentilla gracilis var. elmeri','(Rydberg) Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28116','','','Potentilla bakeri Rydberg','Potentilla bakeri','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28118','','','Potentilla pectinisecta Rydberg','Potentilla pectinisecta','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28117','','','Potentilla flabelliformis var. inyoensis Jepson','Potentilla flabelliformis var. inyoensis','Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28119','','','Potentilla pectinisecta var. comosa (Rydberg) Soják','Potentilla pectinisecta var. comosa','(Rydberg) Soják','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21867','','','Potentilla elmeri Rydberg','Potentilla elmeri','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9789','','','Potentilla gracilis var. fastigiata (Nuttall) S. Watson','Potentilla gracilis var. fastigiata','(Nuttall) S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28114','','','Potentilla nuttallii Lehmann','Potentilla nuttallii','Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28113','','','Potentilla jucunda A. Nelson','Potentilla jucunda','A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28115','','','Potentilla nuttallii var. glabrata Lehmann','Potentilla nuttallii var. glabrata','Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28108','','','Potentilla angustata Rydberg','Potentilla angustata','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28109','','','Potentilla blaschkeana var. permollis (Rydberg) Th. Wolf','Potentilla blaschkeana var. permollis','(Rydberg) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28110','','','Potentilla etomentosa Rydberg ex B.T. Butler','Potentilla etomentosa','Rydberg ex B.T. Butler','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28111','','','Potentilla etomentosa subsp. hallii (Rydberg) Abrams','Potentilla etomentosa subsp. hallii','(Rydberg) Abrams','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28112','','','Potentilla gracilis var. rigida S. Watson nom. nud.','Potentilla gracilis var. rigida','S. Watson nom. nud.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21828','','','Potentilla fastigiata Nuttall','Potentilla fastigiata','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21827','','','Potentilla indiges M. Peck','Potentilla indiges','M. Peck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21836','','','Potentilla gracilis subsp. nuttallii (Lehmann) D.D. Keck','Potentilla gracilis subsp. nuttallii','(Lehmann) D.D. Keck','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21837','','','Potentilla gracilis var. nuttallii (Lehmann) E. Sheldon','Potentilla gracilis var. nuttallii','(Lehmann) E. Sheldon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21838','','','Potentilla gracilis var. permollis (Rydberg) C.L. Hitchcock','Potentilla gracilis var. permollis','(Rydberg) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21831','','','Potentilla fastigiata var. jucunda (A. Nelson) Soják','Potentilla fastigiata var. jucunda','(A. Nelson) Soják','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21832','','','Potentilla fastigiata var. permollis (Rydberg) Soják','Potentilla fastigiata var. permollis','(Rydberg) Soják','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21834','','','Potentilla gracilis var. glabrata (Lehmann) C.L. Hitchcock','Potentilla gracilis var. glabrata','(Lehmann) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21835','','','Potentilla gracilis var. hallii (Rydberg) Th. Wolf','Potentilla gracilis var. hallii','(Rydberg) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9788','','','Potentilla gracilis var. flabelliformis (Lehmann) Nuttall ex Torrey & A. Gray','Potentilla gracilis var. flabelliformis','(Lehmann) Nuttall ex Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21826','','','Potentilla gracilis var. ctenophora (Rydberg) B. Boivin','Potentilla gracilis var. ctenophora','(Rydberg) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21825','','','Potentilla flabelliformis var. ctenophora Rydberg','Potentilla flabelliformis var. ctenophora','Rydberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21824','','','Potentilla flabelliformis Lehmann','Potentilla flabelliformis','Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8822','','','Potentilla gracilis var. gracilis Douglas ex Hooker','Potentilla gracilis var. gracilis','Douglas ex Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28107','','','Potentilla blaschkeana var. Turczaninow ex Lehmann','Potentilla blaschkeana var.','Turczaninow ex Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21829','','','Potentilla alaskana Rydberg','Potentilla alaskana','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8808','','','Potentilla glaucophylla Lehmann','Potentilla glaucophylla','Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8809','','','Potentilla glaucophylla var. glaucophylla Lehmann','Potentilla glaucophylla var. glaucophylla','Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20173','','','Potentilla diversifolia var. glaucophylla (Lehmann) Lehmann','Potentilla diversifolia var. glaucophylla','(Lehmann) Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20170','','','Potentilla ranunculus Lange','Potentilla ranunculus','Lange','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20171','','','Potentilla diversifolia subsp. ranunculus (Lange) A.E. Porsild','Potentilla diversifolia subsp. ranunculus','(Lange) A.E. Porsild','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20172','','','Potentilla diversifolia var. ranunculus (Lange) B. Boivin','Potentilla diversifolia var. ranunculus','(Lange) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8807','','','Potentilla glaucophylla var. perdissecta (Rydberg) Soják','Potentilla glaucophylla var. perdissecta','(Rydberg) Soják','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20169','','','Potentilla diversifolia var. perdissecta (Rydberg) C.L. Hitchcock','Potentilla diversifolia var. perdissecta','(Rydberg) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20168','','','Potentilla perdissecta Rydberg','Potentilla perdissecta','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29968','','','Potentilla brunnescens Rydberg','Potentilla brunnescens','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29969','','','Potentilla gracilis var. brunnescens (Rydberg) C.L. Hitchcock','Potentilla gracilis var. brunnescens','(Rydberg) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2274','','','Potentilla sect. Leucophyllae (Rydberg) A. Nelson','Potentilla sect. Leucophyllae','(Rydberg) A. Nelson','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8812','','','Potentilla effusa Douglas ex Lehmann','Potentilla effusa','Douglas ex Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8811','','','Potentilla effusa var. effusa Douglas ex Lehmann','Potentilla effusa var. effusa','Douglas ex Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28127','','','Potentilla hippiana subsp. effusa (Douglas ex Lehmann) Dorn','Potentilla hippiana subsp. effusa','(Douglas ex Lehmann) Dorn','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20177','','','Potentilla hippiana var. filicaulis (Nuttall) B. Boivin','Potentilla hippiana var. filicaulis','(Nuttall) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20174','','','Potentilla hippiana var. effusa (Douglas ex Lehmann) Dorn','Potentilla hippiana var. effusa','(Douglas ex Lehmann) Dorn','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20175','','','Potentilla effusa var. filicaulis Nuttall','Potentilla effusa var. filicaulis','Nuttall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20176','','','Potentilla effusa var. gossypina Nuttall ex Torrey & A. Gray','Potentilla effusa var. gossypina','Nuttall ex Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8824','','','Potentilla hippiana Lehmann','Potentilla hippiana','Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28126','','','Potentilla effusa var. argyrea (Rydberg) Soják','Potentilla effusa var. argyrea','(Rydberg) Soják','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20187','','','Potentilla hippiana var. diffusa Lehmann','Potentilla hippiana var. diffusa','Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20186','','','Potentilla hippiana var. argyrea (Rydberg) B. Boivin','Potentilla hippiana var. argyrea','(Rydberg) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20188','','','Potentilla propinqua Rydberg','Potentilla propinqua','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20183','','','Potentilla hippiana var. hippiana Lehmann','Potentilla hippiana var. hippiana','Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20185','','','Potentilla argyrea Rydberg','Potentilla argyrea','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20184','','','Potentilla leucophylla Torrey nom. illeg.','Potentilla leucophylla','Torrey nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2275','','','Potentilla sect. Aureae (Rydberg) Juzepczuk','Potentilla sect. Aureae','(Rydberg) Juzepczuk','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8817','','','Potentilla flabellifolia Hooker ex Torrey & A. Gray','Potentilla flabellifolia','Hooker ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8813','','','Potentilla elegans Chamisso & Schlechtendal','Potentilla elegans','Chamisso & Schlechtendal','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8830','','','Potentilla hyparctica Malte','Potentilla hyparctica','Malte','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8829','','','Potentilla hyparctica subsp. elatior (Abromeit) Elven & D.F. Murray','Potentilla hyparctica subsp. elatior','(Abromeit) Elven & D.F. Murray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27162','','','Potentilla fragaria var. emarginata Seringe','Potentilla fragaria var. emarginata','Seringe','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26146','','','Potentilla emarginata Pursh nom. illeg.','Potentilla emarginata','Pursh nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20196','','','Potentilla hyparctica var. elatior (Abromeit) Fernald','Potentilla hyparctica var. elatior','(Abromeit) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20194','','','Potentilla emarginata var. elatior Abromeit','Potentilla emarginata var. elatior','Abromeit','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20195','','','Potentilla flabellifolia var. emarginata (Seringe) B. Boivin','Potentilla flabellifolia var. emarginata','(Seringe) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9773','','','Potentilla hyparctica subsp. hyparctica Malte','Potentilla hyparctica subsp. hyparctica','Malte','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21814','','','Potentilla robbinsiana subsp. hyparctica (Malte) D. Löve','Potentilla robbinsiana subsp. hyparctica','(Malte) D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9772','','','Potentilla nana Willdenow ex Schlechtendal','Potentilla nana','Willdenow ex Schlechtendal','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28134','','','Potentilla hyparctica subsp. nana (Willdenow ex Schlechtendal) Hultén','Potentilla hyparctica subsp. nana','(Willdenow ex Schlechtendal) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21813','','','Potentilla emarginata subsp. nana (Willdenow ex Schlechtendal) Hultén','Potentilla emarginata subsp. nana','(Willdenow ex Schlechtendal) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9771','','','Potentilla verna Linnaeus','Potentilla verna','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21812','','','Potentilla neumanniana','Potentilla neumanniana','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21811','','','Potentilla tabernaemontani Ascherson','Potentilla tabernaemontani','Ascherson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8831','','','Potentilla crantzii (Crantz) Beck ex Fritsch','Potentilla crantzii','(Crantz) Beck ex Fritsch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30823','','','Potentilla salisburgensis Haenke','Potentilla salisburgensis','Haenke','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28133','','','Potentilla crantzii var. hirta (Lange) Malte','Potentilla crantzii var. hirta','(Lange) Malte','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20181','','','Potentilla flabellifolia var. hirta (Lange) B. Boivin','Potentilla flabellifolia var. hirta','(Lange) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20197','','','Fragaria crantzii Crantz','Fragaria crantzii','Crantz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20200','','','Potentilla maculata Pourret','Potentilla maculata','Pourret','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20198','','','Potentilla alpestris Haller f.','Potentilla alpestris','Haller f.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20199','','','Potentilla langeana Rydberg','Potentilla langeana','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2276','','','Potentilla sect. Niveae (Rydberg) A. Nelson','Potentilla sect. Niveae','(Rydberg) A. Nelson','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8832','','','Potentilla nivea Linnaeus','Potentilla nivea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20202','','','Potentilla prostrata subsp. prostrata Rottbøll','Potentilla prostrata subsp. prostrata','Rottbøll','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20203','','','Potentilla nivea subsp. nivea Linnaeus','Potentilla nivea subsp. nivea','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20201','','','Potentilla prostrata subsp. floccosa Soják','Potentilla prostrata subsp. floccosa','Soják','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8853','','','Potentilla uniflora Ledebour','Potentilla uniflora','Ledebour','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20258','','','Potentilla ledebouriana A.E. Porsild','Potentilla ledebouriana','A.E. Porsild','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8854','','','Potentilla vahliana Lehmann','Potentilla vahliana','Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20259','','','Potentilla hirsuta Vahl ex Hornemann nom. illeg.','Potentilla hirsuta','Vahl ex Hornemann nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8855','','','Potentilla villosula Jurtzev','Potentilla villosula','Jurtzev','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20261','','','Potentilla villosula subsp. congesta Jurtzev','Potentilla villosula subsp. congesta','Jurtzev','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20260','','','Potentilla villosa','Potentilla villosa','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9777','','','Potentilla × tikhomirovii Jurtzev','Potentilla × tikhomirovii','Jurtzev','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9778','','','Potentilla villosa Pallas ex Pursh','Potentilla villosa','Pallas ex Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28139','','','Potentilla villosa var. villosa Pallas ex Pursh','Potentilla villosa var. villosa','Pallas ex Pursh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28138','','','Potentilla villosa var. parviflora C.L. Hitchcock','Potentilla villosa var. parviflora','C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21817','','','Potentilla nivea var. villosa (Pallas ex Pursh) Regel & Tiling','Potentilla nivea var. villosa','(Pallas ex Pursh) Regel & Tiling','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9779','','','Potentilla vulcanicola Juzepczuk','Potentilla vulcanicola','Juzepczuk','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9780','','','Potentilla subvahliana Jurtzev','Potentilla subvahliana','Jurtzev','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9781','','','Potentilla subgorodkovii Jurtzev','Potentilla subgorodkovii','Jurtzev','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8826','','','Potentilla arenosa (Turczaninow) Juzepczuk','Potentilla arenosa','(Turczaninow) Juzepczuk','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8825','','','Potentilla arenosa subsp. chamissonis (Hultén) Elven & D.F. Murray','Potentilla arenosa subsp. chamissonis','(Hultén) Elven & D.F. Murray','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21816','','','Potentilla nivea var. nipharga (Rydberg) Soják','Potentilla nivea var. nipharga','(Rydberg) Soják','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21815','','','Potentilla nipharga Rydberg','Potentilla nipharga','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20191','','','Potentilla nivea subsp. chamissonis (Hultén) Hiitonen','Potentilla nivea subsp. chamissonis','(Hultén) Hiitonen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20190','','','Potentilla chamissonis Hultén','Potentilla chamissonis','Hultén','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20189','','','Potentilla hookeriana subsp. chamissonis (Hultén) Hultén','Potentilla hookeriana subsp. chamissonis','(Hultén) Hultén','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9776','','','Potentilla arenosa subsp. arenosa (Turczaninow) Juzepczuk','Potentilla arenosa subsp. arenosa','(Turczaninow) Juzepczuk','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28137','','','Potentilla nivea var. arenosa Turczaninow','Potentilla nivea var. arenosa','Turczaninow','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9775','','','Potentilla crebridens Juzepczuk','Potentilla crebridens','Juzepczuk','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9774','','','Potentilla crebridens subsp. hemicryophila Jurtzev','Potentilla crebridens subsp. hemicryophila','Jurtzev','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28136','','','Potentilla matsuokana subsp. hemicryophila (Jurtzev) Soják','Potentilla matsuokana subsp. hemicryophila','(Jurtzev) Soják','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26942','','','Potentilla arenosa subsp. chamissonis × Potentilla nivea','Potentilla arenosa subsp. chamissonis × Potentilla nivea','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28372','','','Potentilla × prostrata Rottbøll','Potentilla × prostrata','Rottbøll','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2277','','','Potentilla sect. Multijugae (Rydberg) A. Nelson','Potentilla sect. Multijugae','(Rydberg) A. Nelson','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8835','','','Potentilla ovina J.M. Macoun','Potentilla ovina','J.M. Macoun','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29970','','','Potentilla ovina var. decurrens (S. Watson) S.L. Welsh & B.C. Johnston','Potentilla ovina var. decurrens','(S. Watson) S.L. Welsh & B.C. Johnston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29972','','','Potentilla decurrens (S. Watson) Rydberg','Potentilla decurrens','(S. Watson) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29973','','','Potentilla diversifolia var. decurrens (S. Watson) Th. Wolf','Potentilla diversifolia var. decurrens','(S. Watson) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29971','','','Potentilla dissecta S. Watson','Potentilla dissecta','S. Watson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29974','','','Potentilla nelsoniana Rydberg','Potentilla nelsoniana','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8834','','','Potentilla ovina var. ovina J.M. Macoun','Potentilla ovina var. ovina','J.M. Macoun','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28131','','','Potentilla pensylvanica var. glabrata (Lehmann) S. Watson','Potentilla pensylvanica var. glabrata','(Lehmann) S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28129','','','Potentilla pinnatisecta (S. Watson) A. Nelson','Potentilla pinnatisecta','(S. Watson) A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28130','','','Potentilla plattensis var. pinnatisecta (S. Watson) J.M. Macoun','Potentilla plattensis var. pinnatisecta','(S. Watson) J.M. Macoun','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28128','','','Potentilla diversifolia var. pinnatisecta S. Watson','Potentilla diversifolia var. pinnatisecta','S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20212','','','Potentilla wyomingensis A. Nelson','Potentilla wyomingensis','A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20211','','','Potentilla monidensis A. Nelson','Potentilla monidensis','A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20210','','','Potentilla glabrella Rydberg','Potentilla glabrella','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20209','','','Potentilla bipinnatifida var. glabrata (Lehmann) Kohli & Packer','Potentilla bipinnatifida var. glabrata','(Lehmann) Kohli & Packer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8840','','','Potentilla plattensis Nuttall','Potentilla plattensis','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28132','','','Potentilla diversifolia var. madsenii S.L. Welsh & N.D. Atwood','Potentilla diversifolia var. madsenii','S.L. Welsh & N.D. Atwood','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20227','','','Potentilla plattensis var. pedicillata A. Nelson','Potentilla plattensis var. pedicillata','A. Nelson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2278','','','Potentilla sect. Rectae (Th. Wolf) Juzepczuk','Potentilla sect. Rectae','(Th. Wolf) Juzepczuk','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8843','','','Potentilla recta Linnaeus','Potentilla recta','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28103','','','Potentilla recta subsp. obscura (Willdenow) Arcangeli','Potentilla recta subsp. obscura','(Willdenow) Arcangeli','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28104','','','Potentilla recta var. obscura (Willdenow) Poiret','Potentilla recta var. obscura','(Willdenow) Poiret','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28105','','','Potentilla recta ssp. ex Rothmaler (Willdenow ex Poiret) Reichenbach f. ex Rothmaler','Potentilla recta ssp. ex Rothmaler','(Willdenow ex Poiret) Reichenbach f. ex Rothmaler','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28106','','','Potentilla recta var. pilosa Willdenow ex Poiret','Potentilla recta var. pilosa','Willdenow ex Poiret','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20235','','','Potentilla recta var. sulphurea (Lamarck) de Candolle','Potentilla recta var. sulphurea','(Lamarck) de Candolle','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20237','','','Potentilla sulphurea Lamarck','Potentilla sulphurea','Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2279','','','Potentilla sect. Chrysanthae (Th. Wolf) Juzepczuk','Potentilla sect. Chrysanthae','(Th. Wolf) Juzepczuk','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8846','','','Potentilla rubella T.J. Sørensen','Potentilla rubella','T.J. Sørensen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20242','','','Potentilla rubelloides V.V. Petrovsky','Potentilla rubelloides','V.V. Petrovsky','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8852','','','Potentilla thuringiaca Bernhardi ex Link','Potentilla thuringiaca','Bernhardi ex Link','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20257','','','Potentilla nestleriana Trattinnick','Potentilla nestleriana','Trattinnick','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20256','','','Potentilla goldbachii Ruprecht','Potentilla goldbachii','Ruprecht','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20255','','','Potentilla chrysantha subsp. thuringiaca (Bernhardi ex Link) Simonkai','Potentilla chrysantha subsp. thuringiaca','(Bernhardi ex Link) Simonkai','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8850','','','Potentilla stipularis Linnaeus','Potentilla stipularis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20251','','','Potentilla stipularis var. groenlandica T.J. Sørensen','Potentilla stipularis var. groenlandica','T.J. Sørensen','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2280','','','Potentilla sect. Rubricaules (Rydberg) A. Nelson','Potentilla sect. Rubricaules','(Rydberg) A. Nelson','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30160','','','Potentilla psychrophila Soják','Potentilla psychrophila','Soják','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31309','','','Potentilla hudsonii Ertter','Potentilla hudsonii','Ertter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9784','','','Potentilla pedersenii (Rydberg) Rydberg','Potentilla pedersenii','(Rydberg) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28141','','','Potentilla subquinata var. pedersenii Rydberg ex Small','Potentilla subquinata var. pedersenii','Rydberg ex Small','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21820','','','Potentilla tolmatchevii Jurtzev & Soják','Potentilla tolmatchevii','Jurtzev & Soják','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20243','','','Potentilla hookeriana Lehmann','Potentilla hookeriana','Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28140','','','Potentilla nivea var. hookeriana (Lehmann) Th. Wolf','Potentilla nivea var. hookeriana','(Lehmann) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25597','','','Potentilla hookeriana var. hookeriana Lehmann','Potentilla hookeriana var. hookeriana','Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25596','','','Potentilla hookeriana subsp. hookeriana Lehmann','Potentilla hookeriana subsp. hookeriana','Lehmann','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20246','','','Potentilla nivea subsp. hookeriana (Lehmann) Hiitonen','Potentilla nivea subsp. hookeriana','(Lehmann) Hiitonen','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9782','','','Potentilla furcata A.E. Porsild','Potentilla furcata','A.E. Porsild','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21819','','','Potentilla rubricaulis var. furcata (A.E. Porsild) Soják','Potentilla rubricaulis var. furcata','(A.E. Porsild) Soják','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21818','','','Potentilla hookeriana var. furcata (A.E. Porsild) Hultén','Potentilla hookeriana var. furcata','(A.E. Porsild) Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9783','','','Potentilla uschakovii Jurtzev','Potentilla uschakovii','Jurtzev','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8847','','','Potentilla rubricaulis Lehmann','Potentilla rubricaulis','Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2267','','','Potentilla sect. Terminales Grenier & Godron','Potentilla sect. Terminales','Grenier & Godron','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8827','','','Potentilla intermedia Linnaeus','Potentilla intermedia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20192','','','Potentilla heidenreichii Zimmeter','Potentilla heidenreichii','Zimmeter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8797','','','Potentilla argentea Linnaeus','Potentilla argentea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8856','','','Potentilla inclinata Villars','Potentilla inclinata','Villars','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20263','','','Potentilla intermedia var. canescens (Besser) Ruprecht','Potentilla intermedia var. canescens','(Besser) Ruprecht','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20262','','','Potentilla canescens Besser','Potentilla canescens','Besser','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2266','','','Potentilla sect. Potentilla','Potentilla sect. Potentilla','','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8848','','','Potentilla simplex Michaux','Potentilla simplex','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28097','','','Callionia simplex (Michaux) Greene','Callionia simplex','(Michaux) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20247','','','Potentilla canadensis var. simplex (Michaux) Torrey & A. Gray','Potentilla canadensis var. simplex','(Michaux) Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20249','','','Potentilla simplex var. calvescens Fernald','Potentilla simplex var. calvescens','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20248','','','Potentilla simplex var. argyrisma Fernald','Potentilla simplex var. argyrisma','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8804','','','Potentilla canadensis Linnaeus','Potentilla canadensis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28096','','','Callionia canadensis (Linnaeus) Greene','Callionia canadensis','(Linnaeus) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28095','','','Potentilla canadensis var. canadensis Linnaeus','Potentilla canadensis var. canadensis','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28094','','','Potentilla pumila Poiret','Potentilla pumila','Poiret','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28093','','','Potentilla caroliniana Poiret','Potentilla caroliniana','Poiret','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28092','','','Potentilla canadensis var. villosissima Fernald','Potentilla canadensis var. villosissima','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28091','','','Potentilla canadensis var. pumila (Poiret) Torrey & A. Gray','Potentilla canadensis var. pumila','(Poiret) Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8796','','','Potentilla anglica Laicharding','Potentilla anglica','Laicharding','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28098','','','Potentilla procumbens Sibthorp nom. illeg.','Potentilla procumbens','Sibthorp nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8844','','','Potentilla reptans Linnaeus','Potentilla reptans','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8814','','','Potentilla erecta (Linnaeus) Raeuschel','Potentilla erecta','(Linnaeus) Raeuschel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28099','','','Potentilla tormentilla Necker nom. illeg.','Potentilla tormentilla','Necker nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20178','','','Tormentilla erecta Linnaeus','Tormentilla erecta','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2270','','','Potentilla sect. Biflorae (Rydberg) Schiman-Czeika','Potentilla sect. Biflorae','(Rydberg) Schiman-Czeika','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8802','','','Potentilla biflora Willdenow ex Schlechtendal','Potentilla biflora','Willdenow ex Schlechtendal','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2271','','','Potentilla sect. Pensylvanicae Poeverlein','Potentilla sect. Pensylvanicae','Poeverlein','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9786','','','Potentilla bipinnatifida Douglas nom. cons.','Potentilla bipinnatifida','Douglas nom. cons.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28142','','','Pentaphyllum bipinnatifidum (Douglas) Lunell','Pentaphyllum bipinnatifidum','(Douglas) Lunell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21823','','','Potentilla pensylvanica var. bipinnatifida (Douglas) Torrey & A. Gray','Potentilla pensylvanica var. bipinnatifida','(Douglas) Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8841','','','Potentilla pulchella R. Brown','Potentilla pulchella','R. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25406','','','Potentilla pulchella var. pulchella R. Brown ex Ross','Potentilla pulchella var. pulchella','R. Brown ex Ross','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20228','','','Potentilla pulchella var. elatior Lange','Potentilla pulchella var. elatior','Lange','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20229','','','Potentilla pulchella subsp. gracilicaulis (A.E. Porsild) Jurtzev','Potentilla pulchella subsp. gracilicaulis','(A.E. Porsild) Jurtzev','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20230','','','Potentilla pulchella var. gracilicaulis A.E. Porsild','Potentilla pulchella var. gracilicaulis','A.E. Porsild','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20231','','','Potentilla usticapensis Fernald','Potentilla usticapensis','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9785','','','Potentilla jepsonii Ertter','Potentilla jepsonii','Ertter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21822','','','Potentilla litoralis var. ovium (Jepson) Soják','Potentilla litoralis var. ovium','(Jepson) Soják','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21821','','','Potentilla pensylvanica var. ovium Jepson','Potentilla pensylvanica var. ovium','Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8803','','','Potentilla bimundorum Soják','Potentilla bimundorum','Soják','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28143','','','Potentilla multifida subsp. bimundorum (Soják) Soják','Potentilla multifida subsp. bimundorum','(Soják) Soják','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20166','','','Potentilla multifida','Potentilla multifida','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8815','','','Potentilla lasiodonta Rydberg','Potentilla lasiodonta','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20180','','','Potentilla finitima Kohli & Packer','Potentilla finitima','Kohli & Packer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8838','','','Potentilla litoralis Rydberg','Potentilla litoralis','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20221','','','Potentilla pectinata Rafinesque nom. illeg.','Potentilla pectinata','Rafinesque nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20220','','','Potentilla virgulata A. Nelson','Potentilla virgulata','A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20219','','','Potentilla pensylvanica var. virgulata (A. Nelson) Th. Wolf','Potentilla pensylvanica var. virgulata','(A. Nelson) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20218','','','Potentilla pensylvanica var. pectinata Lepage','Potentilla pensylvanica var. pectinata','Lepage','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20217','','','Potentilla pensylvanica var. litoralis (Rydberg) B. Boivin','Potentilla pensylvanica var. litoralis','(Rydberg) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8839','','','Potentilla pensylvanica Linnaeus','Potentilla pensylvanica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32311','','','Potentilla pensylvanica var. atrovirens (Rydberg) Th. Wolf','Potentilla pensylvanica var. atrovirens','(Rydberg) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20226','','','Potentilla sibirica Th. Wolf','Potentilla sibirica','Th. Wolf','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20225','','','Potentilla pensylvanica var. brevipila Soják','Potentilla pensylvanica var. brevipila','Soják','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20224','','','Potentilla pensylvanica var. arida B. Boivin','Potentilla pensylvanica var. arida','B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20223','','','Potentilla brooksensis Jurtzev','Potentilla brooksensis','Jurtzev','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20222','','','Potentilla atrovirens Rydberg','Potentilla atrovirens','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2268','','','Potentilla sect. Haematochri (Rydberg) B.C. Johnston','Potentilla sect. Haematochri','(Rydberg) B.C. Johnston','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8800','','','Potentilla atrosanguinea Loddiges, G. Loddiges & W. Loddiges','Potentilla atrosanguinea','Loddiges, G. Loddiges & W. Loddiges','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2269','','','Potentilla sect. Rivales Poeverlein','Potentilla sect. Rivales','Poeverlein','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8801','','','Potentilla biennis Greene','Potentilla biennis','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8833','','','Potentilla norvegica Linnaeus','Potentilla norvegica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28101','','','Potentilla labradorica Lehmann','Potentilla labradorica','Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28102','','','Potentilla flexuosa Rafinesque','Potentilla flexuosa','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25405','','','Potentilla norvegica subsp. norvegica Linnaeus','Potentilla norvegica subsp. norvegica','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25404','','','Potentilla norvegica var. norvegica Linnaeus','Potentilla norvegica var. norvegica','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20204','','','Potentilla monspeliensis Linnaeus','Potentilla monspeliensis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20205','','','Potentilla norvegica subsp. hirsuta (Michaux) Hylander','Potentilla norvegica subsp. hirsuta','(Michaux) Hylander','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20208','','','Potentilla norvegica subsp. monspeliensis (Linnaeus) Ascherson & Graebner','Potentilla norvegica subsp. monspeliensis','(Linnaeus) Ascherson & Graebner','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20206','','','Potentilla norvegica var. hirsuta (Michaux) Lehmann','Potentilla norvegica var. hirsuta','(Michaux) Lehmann','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20207','','','Potentilla norvegica var. labradorica (Lehmann) Fernald','Potentilla norvegica var. labradorica','(Lehmann) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8845','','','Potentilla rivalis Nuttall','Potentilla rivalis','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28100','','','Potentilla rivalis var. rivalis Nuttall','Potentilla rivalis var. rivalis','Nuttall','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20238','','','Potentilla millegrana Engelmann ex Lehmann','Potentilla millegrana','Engelmann ex Lehmann','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20239','','','Potentilla pentandra Engelmann ex Torrey & A. Gray','Potentilla pentandra','Engelmann ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20240','','','Potentilla rivalis var. millegrana (Engelmann ex Lehmann) S. Watson','Potentilla rivalis var. millegrana','(Engelmann ex Lehmann) S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20241','','','Potentilla rivalis var. pentandra (Engelmann ex Torrey & A. Gray) S. Watson','Potentilla rivalis var. pentandra','(Engelmann ex Torrey & A. Gray) S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8837','','','Potentilla supina Linnaeus','Potentilla supina','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8836','','','Potentilla supina subsp. paradoxa (Nuttall) Soják','Potentilla supina subsp. paradoxa','(Nuttall) Soják','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20213','','','Potentilla paradoxa Nuttall','Potentilla paradoxa','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20216','','','Potentilla supina var. paradoxa (Nuttall) Th. Wolf','Potentilla supina var. paradoxa','(Nuttall) Th. Wolf','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20215','','','Potentilla supina var. nicolletii S. Watson','Potentilla supina var. nicolletii','S. Watson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20214','','','Potentilla nicolletii (S. Watson) E. Sheldon','Potentilla nicolletii','(S. Watson) E. Sheldon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('797','','','Alchemilla Linnaeus','Alchemilla','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29115','','','Alchemilla acutiloba Opiz','Alchemilla acutiloba','Opiz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8608','','','Alchemilla filicaulis Buser','Alchemilla filicaulis','Buser','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8609','','','Alchemilla filicaulis subsp. vestita (Buser) M.E. Bradshaw','Alchemilla filicaulis subsp. vestita','(Buser) M.E. Bradshaw','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19801','','','Alchemilla vulgaris var. vestita (Buser) Fernald & Wiegand','Alchemilla vulgaris var. vestita','(Buser) Fernald & Wiegand','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19802','','','Alchemilla vestita (Buser) Raunkiaer','Alchemilla vestita','(Buser) Raunkiaer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8607','','','Alchemilla filicaulis subsp. filicaulis Buser','Alchemilla filicaulis subsp. filicaulis','Buser','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26240','','','Alchemilla filicaulis var. filicaulis Buser','Alchemilla filicaulis var. filicaulis','Buser','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19800','','','Alchemilla vulgaris var. filicaulis (Buser) Fernald & Wiegand','Alchemilla vulgaris var. filicaulis','(Buser) Fernald & Wiegand','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9823','','','Alchemilla mollis (Buser) Rothmaler','Alchemilla mollis','(Buser) Rothmaler','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23714','','','Alchemilla acutiloba var. mollis Buser','Alchemilla acutiloba var. mollis','Buser','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9699','','','Alchemilla xanthochlora Rothmaler','Alchemilla xanthochlora','Rothmaler','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9698','','','Alchemilla micans Buser','Alchemilla micans','Buser','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9697','','','Alchemilla glaucescens Wallroth','Alchemilla glaucescens','Wallroth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30595','','','Alchemilla minor Hudson','Alchemilla minor','Hudson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8615','','','Alchemilla wichurae (Buser) Stefánsson','Alchemilla wichurae','(Buser) Stefánsson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19811','','','Alchemilla vulgaris var. wichurae (Buser) B. Boivin','Alchemilla vulgaris var. wichurae','(Buser) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19810','','','Alchemilla acutidens p.p. Buser p.p.','Alchemilla acutidens p.p.','Buser p.p.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8614','','','Alchemilla venosa Juzepczuk','Alchemilla venosa','Juzepczuk','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8613','','','Alchemilla subcrenata Buser','Alchemilla subcrenata','Buser','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8612','','','Alchemilla monticola Opiz','Alchemilla monticola','Opiz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19809','','','Alchemilla pastoralis Buser','Alchemilla pastoralis','Buser','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19808','','','Alchemilla vulgaris var. pastoralis (Buser) B. Boivin','Alchemilla vulgaris var. pastoralis','(Buser) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8611','','','Alchemilla glomerulans Buser','Alchemilla glomerulans','Buser','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19806','','','Alchemilla vulgaris var. comosa (Brenner) Fernald & Wiegand','Alchemilla vulgaris var. comosa','(Brenner) Fernald & Wiegand','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19807','','','Alchemilla obtusa var. comosa Brenner','Alchemilla obtusa var. comosa','Brenner','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8606','','','Alchemilla alpina Linnaeus','Alchemilla alpina','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8610','','','Alchemilla glabra Neygenfind','Alchemilla glabra','Neygenfind','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19805','','','Alchemilla alpestris (F.W. Schmidt) Buser','Alchemilla alpestris','(F.W. Schmidt) Buser','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19803','','','Alchemilla vulgaris var. grandis Blytt','Alchemilla vulgaris var. grandis','Blytt','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19804','','','Alchemilla vulgaris var. alpestris F.W. Schmidt','Alchemilla vulgaris var. alpestris','F.W. Schmidt','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('669','','','Rubeae Dumortier','Rubeae','Dumortier','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1629','','','Rubus Linnaeus nom. cons.','Rubus','Linnaeus nom. cons.','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~75','','','Rubus (Chamaerubus) Kuntze','Rubus (Chamaerubus)','Kuntze','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8943','','','Rubus pedatus Smith','Rubus pedatus','Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20569','','','Psychrobatia pedata (Smith) Greene','Psychrobatia pedata','(Smith) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20568','','','Dalibarda pedata (Smith) Stephan','Dalibarda pedata','(Smith) Stephan','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20567','','','Comaropsis pedata (Smith) de Candolle','Comaropsis pedata','(Smith) de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20566','','','Ametron pedatum (Smith) Rafinesque','Ametron pedatum','(Smith) Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8928','','','Rubus chamaemorus Linnaeus','Rubus chamaemorus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20374','','','Chamaemorus anglica Greene','Chamaemorus anglica','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20375','','','Chamaemorus norwegica Greene','Chamaemorus norwegica','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33639','','','Rubus subgen. Chamaerubus Kuntze','Rubus subgen. Chamaerubus','Kuntze','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~77','','','Rubus (Rubus) Linnaeus','Rubus (Rubus)','Linnaeus','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8936','','','Rubus laciniatus Willdenow','Rubus laciniatus','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8939','','','Rubus nivalis Douglas ex Hooker','Rubus nivalis','Douglas ex Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20539','','','Cardiobatus nivalis (Douglas ex Hooker) Greene','Cardiobatus nivalis','(Douglas ex Hooker) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8929','','','Rubus flagellaris Willdenow','Rubus flagellaris','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33120','','','Rubus flagellaris var. invisus (L.H. Bailey) L.H. Bailey','Rubus flagellaris var. invisus','(L.H. Bailey) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28018','','','Rubus villosus var. michiganensis F.W. Card ex L.H. Bailey','Rubus villosus var. michiganensis','F.W. Card ex L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27346','','','Rubus cordialis L.H. Bailey','Rubus cordialis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27345','','','Rubus connixus L.H. Bailey','Rubus connixus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27348','','','Rubus dives L.H. Bailey','Rubus dives','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27347','','','Rubus currulis L.H. Bailey','Rubus currulis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27350','','','Rubus fandus L.H. Bailey','Rubus fandus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27349','','','Rubus exemptus L.H. Bailey','Rubus exemptus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27352','','','Rubus flagellaris var. occidualis L.H. Bailey','Rubus flagellaris var. occidualis','L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27351','','','Rubus flagellaris var. almus L.H. Bailey nom. illeg.','Rubus flagellaris var. almus','L.H. Bailey nom. illeg.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27354','','','Rubus hancinianus L.H. Bailey','Rubus hancinianus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27353','','','Rubus foliaceus L.H. Bailey','Rubus foliaceus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27356','','','Rubus ignarus L.H. Bailey','Rubus ignarus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27355','','','Rubus housei L.H. Bailey','Rubus housei','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27358','','','Rubus jaysmithii var. angustior L.H. Bailey','Rubus jaysmithii var. angustior','L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27357','','','Rubus inobvius L.H. Bailey','Rubus inobvius','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27360','','','Rubus oligospermus Thornber ex Rydberg nom. illeg.','Rubus oligospermus','Thornber ex Rydberg nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27359','','','Rubus lassus L.H. Bailey','Rubus lassus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27329','','','Rubus alacer L.H. Bailey','Rubus alacer','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27334','','','Rubus austrinus L.H. Bailey','Rubus austrinus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27335','','','Rubus bollianus L.H. Bailey','Rubus bollianus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27336','','','Rubus bonus L.H. Bailey','Rubus bonus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27337','','','Rubus botruosus L.H. Bailey','Rubus botruosus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27338','','','Rubus bretonis L.H. Bailey','Rubus bretonis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27339','','','Rubus brevipedalis L.H. Bailey nom. illeg.','Rubus brevipedalis','L.H. Bailey nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27340','','','Rubus camurus L.H. Bailey nom. illeg.','Rubus camurus','L.H. Bailey nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27341','','','Rubus census L.H. Bailey ex Britton','Rubus census','L.H. Bailey ex Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27342','','','Rubus clairbrownii L.H. Bailey nom. illeg.','Rubus clairbrownii','L.H. Bailey nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27343','','','Rubus clandestinus L.H. Bailey','Rubus clandestinus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27344','','','Rubus coloniatus L.H. Bailey','Rubus coloniatus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20446','','','Rubus scambens L.H. Bailey','Rubus scambens','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20447','','','Rubus schoolcraftianus L.H. Bailey','Rubus schoolcraftianus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20444','','','Rubus sailori L.H. Bailey','Rubus sailori','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20445','','','Rubus satis L.H. Bailey','Rubus satis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20442','','','Rubus rosagnetis L.H. Bailey','Rubus rosagnetis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20443','','','Rubus russeus L.H. Bailey','Rubus russeus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20440','','','Rubus redundans L.H. Bailey','Rubus redundans','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20441','','','Rubus roribaccus (L.H. Bailey) Rydberg','Rubus roribaccus','(L.H. Bailey) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20437','','','Rubus profusiflorus L.H. Bailey','Rubus profusiflorus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20438','','','Rubus pronus L.H. Bailey','Rubus pronus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20435','','','Rubus plexus Fernald','Rubus plexus','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20436','','','Rubus plicatifolius Blanchard','Rubus plicatifolius','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20433','','','Rubus pernagaeus Fernald','Rubus pernagaeus','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20434','','','Rubus pityophilus S.J. Smith ex L.H. Bailey','Rubus pityophilus','S.J. Smith ex L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20432','','','Rubus peracer L.H. Bailey','Rubus peracer','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20458','','','Rubus whartoniae L.H. Bailey','Rubus whartoniae','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20457','','','Rubus vixalacer L.H. Bailey','Rubus vixalacer','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20456','','','Rubus uvidus L.H. Bailey','Rubus uvidus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20455','','','Rubus tetricus L.H. Bailey','Rubus tetricus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20454','','','Rubus terraltanus L.H. Bailey','Rubus terraltanus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20453','','','Rubus tenuicaulis L.H. Bailey','Rubus tenuicaulis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20452','','','Rubus temerarius L.H. Bailey','Rubus temerarius','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20451','','','Rubus tantulus L.H. Bailey','Rubus tantulus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20450','','','Rubus subinnoxius Fernald','Rubus subinnoxius','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20449','','','Rubus steelei L.H. Bailey','Rubus steelei','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20448','','','Rubus sewardianus Fernald','Rubus sewardianus','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20411','','','Rubus iniens L.H. Bailey','Rubus iniens','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20412','','','Rubus injunctus L.H. Bailey','Rubus injunctus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20413','','','Rubus invisus (L.H. Bailey) Britton','Rubus invisus','(L.H. Bailey) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20414','','','Rubus ithacanus L.H. Bailey','Rubus ithacanus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20407','','','Rubus geophilus Blanchard','Rubus geophilus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20408','','','Rubus grimesii L.H. Bailey','Rubus grimesii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20409','','','Rubus imperiorum Fernald','Rubus imperiorum','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20381','','','Rubus arizonensis Focke','Rubus arizonensis','Focke','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20382','','','Rubus arundelanus Blanchard','Rubus arundelanus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20379','','','Rubus aptatus L.H. Bailey','Rubus aptatus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20380','','','Rubus arenicola Blanchard','Rubus arenicola','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20377','','','Rubus almus (L.H. Bailey) L.H. Bailey','Rubus almus','(L.H. Bailey) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20378','','','Rubus apogaeus L.H. Bailey','Rubus apogaeus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20376','','','Rubus aboriginum Rydberg','Rubus aboriginum','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20398','','','Rubus eflagellaris L.H. Bailey','Rubus eflagellaris','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20397','','','Rubus depavitus L.H. Bailey','Rubus depavitus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20396','','','Rubus decor L.H. Bailey','Rubus decor','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20395','','','Rubus deamii L.H. Bailey','Rubus deamii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20394','','','Rubus curtipes L.H. Bailey','Rubus curtipes','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20393','','','Rubus cordifrons (L.H. Bailey) L.H. Bailey','Rubus cordifrons','(L.H. Bailey) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20392','','','Rubus conabilis L.H. Bailey','Rubus conabilis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20391','','','Rubus complex L.H. Bailey','Rubus complex','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20390','','','Rubus clarus L.H. Bailey','Rubus clarus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20389','','','Rubus centralis L.H. Bailey','Rubus centralis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20388','','','Rubus celer L.H. Bailey','Rubus celer','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20387','','','Rubus cathartium Fernald','Rubus cathartium','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20386','','','Rubus cacaponensis H.A. Davis & T. Davis','Rubus cacaponensis','H.A. Davis & T. Davis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20385','','','Rubus baileyanus Britton','Rubus baileyanus','Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20384','','','Rubus ashei L.H. Bailey','Rubus ashei','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20383','','','Rubus arundelanus var. jecklyanus (Blanchard) L.H. Bailey','Rubus arundelanus var. jecklyanus','(Blanchard) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20417','','','Rubus kentuckiensis L.H. Bailey','Rubus kentuckiensis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20418','','','Rubus leviculus L.H. Bailey','Rubus leviculus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20415','','','Rubus jactus L.H. Bailey','Rubus jactus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20416','','','Rubus jaysmithii L.H. Bailey','Rubus jaysmithii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20421','','','Rubus meracus L.H. Bailey','Rubus meracus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20422','','','Rubus michiganensis (F.W. Card ex L.H. Bailey) L.H. Bailey','Rubus michiganensis','(F.W. Card ex L.H. Bailey) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20419','','','Rubus mainensis L.H. Bailey','Rubus mainensis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20420','','','Rubus maltei L.H. Bailey','Rubus maltei','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20425','','','Rubus mundus L.H. Bailey','Rubus mundus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20426','','','Rubus nefrens L.H. Bailey','Rubus nefrens','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20423','','','Rubus minnesotanus L.H. Bailey','Rubus minnesotanus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20424','','','Rubus multifer L.H. Bailey','Rubus multifer','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20429','','','Rubus occidualis (L.H. Bailey) L.H. Bailey','Rubus occidualis','(L.H. Bailey) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20430','','','Rubus particeps L.H. Bailey','Rubus particeps','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20427','','','Rubus obsessus L.H. Bailey','Rubus obsessus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20428','','','Rubus obvius L.H. Bailey','Rubus obvius','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20402','','','Rubus fecundus L.H. Bailey','Rubus fecundus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20401','','','Rubus exutus L.H. Bailey','Rubus exutus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20400','','','Rubus exsularis L.H. Bailey','Rubus exsularis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20399','','','Rubus enslenii Trattinnick','Rubus enslenii','Trattinnick','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20406','','','Rubus frustratus L.H. Bailey','Rubus frustratus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20405','','','Rubus folioflorus L.H. Bailey','Rubus folioflorus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20404','','','Rubus florenceae L.H. Bailey','Rubus florenceae','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20403','','','Rubus felix L.H. Bailey','Rubus felix','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20410','','','Rubus indianensis L.H. Bailey','Rubus indianensis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8931','','','Rubus hispidus Linnaeus','Rubus hispidus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28767','','','Rubus pervarius (L.H. Bailey) L.H. Bailey','Rubus pervarius','(L.H. Bailey) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23624','','','Rubus hispidus var. cupulifer L.H. Bailey','Rubus hispidus var. cupulifer','L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23623','','','Rubus hispidus var. blanchardianus L.H. Bailey','Rubus hispidus var. blanchardianus','L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20463','','','Rubus fassettii L.H. Bailey','Rubus fassettii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20462','','','Rubus davisiorum L.H. Bailey','Rubus davisiorum','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20461','','','Rubus cubitans Blanchard','Rubus cubitans','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20460','','','Rubus compos L.H. Bailey','Rubus compos','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20459','','','Rubus blanchardianus (L.H. Bailey) L.H. Bailey','Rubus blanchardianus','(L.H. Bailey) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20472','','','Rubus signatus L.H. Bailey','Rubus signatus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20473','','','Rubus trifrons var. pudens (L.H. Bailey) Fernald','Rubus trifrons var. pudens','(L.H. Bailey) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20474','','','Rubus vagulus L.H. Bailey','Rubus vagulus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20475','','','Rubus vigil L.H. Bailey','Rubus vigil','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20464','','','Rubus hispidus var. obovalis (Michaux) Fernald','Rubus hispidus var. obovalis','(Michaux) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20465','','','Rubus huttonii L.H. Bailey','Rubus huttonii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20466','','','Rubus paganus L.H. Bailey','Rubus paganus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20467','','','Rubus plus L.H. Bailey','Rubus plus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20468','','','Rubus porteri L.H. Bailey','Rubus porteri','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20469','','','Rubus provincialis L.H. Bailey','Rubus provincialis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20470','','','Rubus pudens L.H. Bailey','Rubus pudens','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20471','','','Rubus rowleei L.H. Bailey','Rubus rowleei','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8926','','','Rubus caesius Linnaeus','Rubus caesius','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8927','','','Rubus canadensis Linnaeus','Rubus canadensis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23622','','','Rubus laetabilis L.H. Bailey','Rubus laetabilis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23621','','','Rubus illustris L.H. Bailey','Rubus illustris','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23619','','','Rubus besseyi L.H. Bailey','Rubus besseyi','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23620','','','Rubus canadensis var. imus L.H. Bailey','Rubus canadensis var. imus','L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23618','','','Rubus argutus var. randii (L.H. Bailey) L.H. Bailey','Rubus argutus var. randii','(L.H. Bailey) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20367','','','Rubus montensis L.H. Bailey','Rubus montensis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20366','','','Rubus miscix L.H. Bailey','Rubus miscix','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20369','','','Rubus ulterior L.H. Bailey','Rubus ulterior','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20372','','','Rubus pergratus var. terrae-novae Fernald','Rubus pergratus var. terrae-novae','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20370','','','Rubus randii (L.H. Bailey) Rybderg','Rubus randii','(L.H. Bailey) Rybderg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20373','','','Rubus canadensis var. terrae-novae (Fernald) L.H. Bailey','Rubus canadensis var. terrae-novae','(Fernald) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20365','','','Rubus kennedyanus Fernald','Rubus kennedyanus','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8925','','','Rubus bifrons Vest','Rubus bifrons','Vest','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28776','','','Rubus discolor','Rubus discolor','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28820','','','Rubus thyrsoideus Wimmer nom. illeg.','Rubus thyrsoideus','Wimmer nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23617','','','Rubus linkianus Seringe','Rubus linkianus','Seringe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20361','','','Rubus armeniacus Focke','Rubus armeniacus','Focke','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20362','','','Rubus procerus P.J. Müller ex Genevier','Rubus procerus','P.J. Müller ex Genevier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8920','','','Rubus allegheniensis Porter','Rubus allegheniensis','Porter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27289','','','Rubus montpelierensis Blanchard ex L.H. Bailey','Rubus montpelierensis','Blanchard ex L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23615','','','Rubus licitus L.H. Bailey','Rubus licitus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23613','','','Rubus impos L.H. Bailey','Rubus impos','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23614','','','Rubus irregularis L.H. Bailey','Rubus irregularis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23607','','','Rubus montanus (Porter) Porter','Rubus montanus','(Porter) Porter','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23608','','','Rubus acadiensis L.H. Bailey','Rubus acadiensis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23611','','','Rubus auroralis L.H. Bailey','Rubus auroralis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23612','','','Rubus campester L.H. Bailey','Rubus campester','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23609','','','Rubus allegheniensis var. calycosus (Fernald) Fernald','Rubus allegheniensis var. calycosus','(Fernald) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23610','','','Rubus apianus L.H. Bailey','Rubus apianus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20352','','','Rubus rosa L.H. Bailey','Rubus rosa','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20353','','','Rubus saltuensis L.H. Bailey','Rubus saltuensis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20350','','','Rubus paulus L.H. Bailey','Rubus paulus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20351','','','Rubus pugnax L.H. Bailey','Rubus pugnax','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20354','','','Rubus sceleratus Brainerd ex Fernald','Rubus sceleratus','Brainerd ex Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20341','','','Rubus allegheniensis var. neoscoticus (Fernald) L.H. Bailey','Rubus allegheniensis var. neoscoticus','(Fernald) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20340','','','Rubus allegheniensis var. gravesii (Fernald) Fernald','Rubus allegheniensis var. gravesii','(Fernald) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20339','','','Rubus villosus var. montanus Porter','Rubus villosus var. montanus','Porter','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20345','','','Rubus attractus L.H. Bailey','Rubus attractus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20344','','','Rubus alumnus L.H. Bailey','Rubus alumnus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20343','','','Rubus allegheniensis var. populifolius Fernald','Rubus allegheniensis var. populifolius','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20342','','','Rubus allegheniensis var. plausus L.H. Bailey','Rubus allegheniensis var. plausus','L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20349','','','Rubus nuperus L.H. Bailey','Rubus nuperus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20348','','','Rubus inclinis L.H. Bailey','Rubus inclinis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20347','','','Rubus glandicaulis Blanchard','Rubus glandicaulis','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20346','','','Rubus concameratus H.A. Davis & T. Davis','Rubus concameratus','H.A. Davis & T. Davis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27237','','','Rubus × jacens Blanchard','Rubus × jacens','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27375','','','Rubus × grandidens L.H. Bailey','Rubus × grandidens','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27376','','','Rubus × harmonicus L.H. Bailey','Rubus × harmonicus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27377','','','Rubus × tholiformis Fernald','Rubus × tholiformis','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27243','','','Rubus × zaplutus L.H. Bailey','Rubus × zaplutus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27242','','','Rubus × spiculosus Fernald','Rubus × spiculosus','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27241','','','Rubus × tardatus Blanchard','Rubus × tardatus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27240','','','Rubus × trifrons Blanchard','Rubus × trifrons','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27239','','','Rubus × parlinii L.H. Bailey','Rubus × parlinii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27238','','','Rubus × adjacens Fernald','Rubus × adjacens','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8930','','','Rubus × frondisentis Blanchard','Rubus × frondisentis','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30995','','','Rubus × crux Ashe','Rubus × crux','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30999','','','Rubus canadensis var. elegantulus (Blanchard) Farwell','Rubus canadensis var. elegantulus','(Blanchard) Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30998','','','Rubus × amabilis Blanchard nom. illeg.','Rubus × amabilis','Blanchard nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31000','','','Rubus canadensis var. pergratus (Blanchard) L.H. Bailey','Rubus canadensis var. pergratus','(Blanchard) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30997','','','Rubus × noveboracus L.H. Bailey','Rubus × noveboracus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30996','','','Rubus × multilicius L.H. Bailey','Rubus × multilicius','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20368','','','Rubus × pergratus Blanchard','Rubus × pergratus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20364','','','Rubus × elegantulus Blanchard','Rubus × elegantulus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20363','','','Rubus × amicalis Blanchard','Rubus × amicalis','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27318','','','Rubus × biformispinus Blanchard','Rubus × biformispinus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27322','','','Rubus × severus Brainerd ex Fernald','Rubus × severus','Brainerd ex Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27321','','','Rubus × bigelovianus L.H. Bailey','Rubus × bigelovianus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27320','','','Rubus × arcuans Fernald & H. St.John','Rubus × arcuans','Fernald & H. St.John','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27319','','','Rubus × multiformis Blanchard','Rubus × multiformis','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27326','','','Rubus × laevior (L.H. Bailey) Fernald','Rubus × laevior','(L.H. Bailey) Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27325','','','Rubus × bracteolifer Fernald','Rubus × bracteolifer','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27324','','','Rubus × adenocaulis Fernald','Rubus × adenocaulis','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27323','','','Rubus × aculifer Fernald','Rubus × aculifer','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27327','','','Rubus × alter L.H. Bailey','Rubus × alter','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27328','','','Rubus × setospinosus L.H. Bailey','Rubus × setospinosus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9763','','','Rubus vestitus Weihe & Nees','Rubus vestitus','Weihe & Nees','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8950','','','Rubus ursinus Chamisso & Schlechtendal','Rubus ursinus','Chamisso & Schlechtendal','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20635','','','Rubus ursinus var. sirbenus (L.H. Bailey) J.T. Howell','Rubus ursinus var. sirbenus','(L.H. Bailey) J.T. Howell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20634','','','Rubus ursinus var. pentaphyllus S.W. Brown','Rubus ursinus var. pentaphyllus','S.W. Brown','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20633','','','Rubus ursinus var. medusae S.W. Brown','Rubus ursinus var. medusae','S.W. Brown','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20632','','','Rubus ursinus var. macropetalus (Douglas ex Hooker) S.W. Brown','Rubus ursinus var. macropetalus','(Douglas ex Hooker) S.W. Brown','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20639','','','Rubus vitifolius var. eastwoodianus (Rydberg) Munz','Rubus vitifolius var. eastwoodianus','(Rydberg) Munz','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20638','','','Rubus vitifolius subsp. ursinus (Chamisso & Schlechtendal) Abrams','Rubus vitifolius subsp. ursinus','(Chamisso & Schlechtendal) Abrams','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20637','','','Rubus vitifolius Chamisso & Schlechtendal','Rubus vitifolius','Chamisso & Schlechtendal','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20636','','','Rubus ursinus var. vitifolius (Chamisso & Schlechtendal) Focke','Rubus ursinus var. vitifolius','(Chamisso & Schlechtendal) Focke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20640','','','Rubus vitifolius var. titanus (L.H. Bailey) L.H. Bailey','Rubus vitifolius var. titanus','(L.H. Bailey) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20625','','','Rubus helleri Rydberg','Rubus helleri','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20626','','','Rubus eastwoodianus Rydberg','Rubus eastwoodianus','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20627','','','Rubus lemurum S.W. Brown','Rubus lemurum','S.W. Brown','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20628','','','Rubus macropetalus Douglas ex Hooker','Rubus macropetalus','Douglas ex Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20629','','','Rubus sirbenus L.H. Bailey','Rubus sirbenus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20630','','','Rubus titanus L.H. Bailey','Rubus titanus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20631','','','Rubus ursinus var. eastwoodianus (Rydberg) J.T. Howell','Rubus ursinus var. eastwoodianus','(Rydberg) J.T. Howell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8949','','','Rubus ursinus subsp. macropetalus (Douglas ex Hooker) Roy L. Taylor & MacBryde','Rubus ursinus subsp. macropetalus','(Douglas ex Hooker) Roy L. Taylor & MacBryde','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8947','','','Rubus setosus Bigelow','Rubus setosus','Bigelow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31007','','','Rubus fulleri L.H. Bailey','Rubus fulleri','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31006','','','Rubus exter L.H. Bailey nom. illeg.','Rubus exter','L.H. Bailey nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31009','','','Rubus viridifrons L.H. Bailey','Rubus viridifrons','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31008','','','Rubus sp. L.H. Bailey','Rubus sp.','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31003','','','Rubus boottianus L.H. Bailey','Rubus boottianus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31002','','','Rubus apparatus L.H. Bailey','Rubus apparatus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31005','','','Rubus deaneanus L.H. Bailey','Rubus deaneanus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31004','','','Rubus condignus L.H. Bailey','Rubus condignus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31001','','','Rubus hispidus var. suberectus Peck','Rubus hispidus var. suberectus','Peck','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28765','','','Rubus gulosus L.H. Bailey','Rubus gulosus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20590','','','Rubus beatus L.H. Bailey','Rubus beatus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20591','','','Rubus benneri L.H. Bailey','Rubus benneri','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20588','','','Rubus weatherbyi L.H. Bailey','Rubus weatherbyi','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20589','','','Rubus quebecensis L.H. Bailey','Rubus quebecensis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20587','','','Rubus nigricans Rydberg','Rubus nigricans','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20598','','','Rubus hispidoides L.H. Bailey','Rubus hispidoides','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20599','','','Rubus jejunus L.H. Bailey','Rubus jejunus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20596','','','Rubus electus L.H. Bailey','Rubus electus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20597','','','Rubus groutianus Blanchard','Rubus groutianus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20594','','','Rubus dissensus L.H. Bailey','Rubus dissensus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20595','','','Rubus dissimilis L.H. Bailey','Rubus dissimilis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20592','','','Rubus bicknellii L.H. Bailey','Rubus bicknellii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20593','','','Rubus discretus L.H. Bailey','Rubus discretus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20601','','','Rubus lawrencei L.H. Bailey','Rubus lawrencei','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20600','','','Rubus junceus Blanchard','Rubus junceus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20603','','','Rubus navus L.H. Bailey','Rubus navus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20602','','','Rubus mediocris L.H. Bailey','Rubus mediocris','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20605','','','Rubus notatus L.H. Bailey','Rubus notatus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20604','','','Rubus nocivus L.H. Bailey','Rubus nocivus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20607','','','Rubus perdebilis L.H. Bailey','Rubus perdebilis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20606','','','Rubus ortivus (L.H. Bailey) L.H. Bailey','Rubus ortivus','(L.H. Bailey) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20609','','','Rubus racemiger L.H. Bailey','Rubus racemiger','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20608','','','Rubus perinvisus L.H. Bailey','Rubus perinvisus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20611','','','Rubus reravus L.H. Bailey','Rubus reravus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20610','','','Rubus regionalis (L.H. Bailey) L.H. Bailey','Rubus regionalis','(L.H. Bailey) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20613','','','Rubus schneideri L.H. Bailey','Rubus schneideri','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20612','','','Rubus rotundior (L.H. Bailey) L.H. Bailey','Rubus rotundior','(L.H. Bailey) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20615','','','Rubus spectatus L.H. Bailey','Rubus spectatus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20614','','','Rubus semisetosus Blanchard','Rubus semisetosus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20616','','','Rubus stipulatus L.H. Bailey','Rubus stipulatus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20617','','','Rubus superioris L.H. Bailey','Rubus superioris','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20618','','','Rubus uniformis L.H. Bailey','Rubus uniformis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20619','','','Rubus univocus L.H. Bailey','Rubus univocus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20620','','','Rubus vermontanus Blanchard','Rubus vermontanus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20621','','','Rubus wheeleri (L.H. Bailey) L.H. Bailey','Rubus wheeleri','(L.H. Bailey) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8944','','','Rubus pensilvanicus Poiret','Rubus pensilvanicus','Poiret','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27385','','','Rubus ablatus L.H. Bailey','Rubus ablatus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27384','','','Rubus abactus L.H. Bailey','Rubus abactus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27387','','','Rubus amnicola Blanchard','Rubus amnicola','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27386','','','Rubus abundiflorus L.H. Bailey','Rubus abundiflorus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27389','','','Rubus argutus Link','Rubus argutus','Link','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27388','','','Rubus andrewsianus Blanchard','Rubus andrewsianus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27391','','','Rubus associus Hanes ex L.H. Bailey','Rubus associus','Hanes ex L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27390','','','Rubus arvensis L.H. Bailey','Rubus arvensis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27393','','','Rubus betulifolius Small','Rubus betulifolius','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27392','','','Rubus barbarus L.H. Bailey','Rubus barbarus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27395','','','Rubus bractealis L.H. Bailey nom. illeg.','Rubus bractealis','L.H. Bailey nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27394','','','Rubus blakei L.H. Bailey','Rubus blakei','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27397','','','Rubus bushii L.H. Bailey','Rubus bushii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27396','','','Rubus burnhamii L.H. Bailey','Rubus burnhamii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27399','','','Rubus condensiflorus L.H. Bailey nom. illeg.','Rubus condensiflorus','L.H. Bailey nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27398','','','Rubus cardianus L.H. Bailey','Rubus cardianus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27419','','','Rubus louisianus A. Berger','Rubus louisianus','A. Berger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27418','','','Rubus libratus L.H. Bailey','Rubus libratus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27417','','','Rubus leggii H.A. Davis & T. Davis','Rubus leggii','H.A. Davis & T. Davis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20570','','','Rubus bellobatus L.H. Bailey','Rubus bellobatus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20431','','','Rubus pauper L.H. Bailey','Rubus pauper','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25914','','','Rubus insons L.H. Bailey','Rubus insons','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25913','','','Rubus frondosus Bigelow','Rubus frondosus','Bigelow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28766','','','Rubus heterophyllus Willdenow','Rubus heterophyllus','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28768','','','Rubus recurvans Blanchard','Rubus recurvans','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27443','','','Rubus wahlii L.H. Bailey','Rubus wahlii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27442','','','Rubus vixargutus L.H. Bailey','Rubus vixargutus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27441','','','Rubus virilis L.H. Bailey','Rubus virilis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27440','','','Rubus ucetanus L.H. Bailey','Rubus ucetanus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27444','','','Rubus wiegandii L.H. Bailey','Rubus wiegandii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27435','','','Rubus saepescandens L.H. Bailey','Rubus saepescandens','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27434','','','Rubus prestonensis H.A. Davis & T. Davis','Rubus prestonensis','H.A. Davis & T. Davis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27433','','','Rubus pratensis L.H. Bailey','Rubus pratensis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27432','','','Rubus praepes L.H. Bailey','Rubus praepes','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27439','','','Rubus tygartensis H.A. Davis & T. Davis','Rubus tygartensis','H.A. Davis & T. Davis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27438','','','Rubus suus L.H. Bailey','Rubus suus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27437','','','Rubus subtractus L.H. Bailey','Rubus subtractus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27436','','','Rubus subsolanus L.H. Bailey','Rubus subsolanus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27413','','','Rubus jugosus L.H. Bailey','Rubus jugosus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27412','','','Rubus jennisonii L.H. Bailey','Rubus jennisonii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27415','','','Rubus latifoliolus L.H. Bailey','Rubus latifoliolus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27414','','','Rubus kelloggii L.H. Bailey','Rubus kelloggii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27409','','','Rubus independens L.H. Bailey','Rubus independens','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27408','','','Rubus impar L.H. Bailey','Rubus impar','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27411','','','Rubus interioris L.H. Bailey','Rubus interioris','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27410','','','Rubus insulanus L.H. Bailey','Rubus insulanus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27405','','','Rubus facetus L.H. Bailey','Rubus facetus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27404','','','Rubus densissimus H.A. Davis & T. Davis','Rubus densissimus','H.A. Davis & T. Davis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27407','','','Rubus humilior L.H. Bailey','Rubus humilior','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27406','','','Rubus fatuus L.H. Bailey','Rubus fatuus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27401','','','Rubus cupressorum Fernald','Rubus cupressorum','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27400','','','Rubus congruus L.H. Bailey','Rubus congruus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27403','','','Rubus densipubens L.H. Bailey','Rubus densipubens','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27402','','','Rubus defectionis Fernald','Rubus defectionis','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27428','','','Rubus perfoliosus L.H. Bailey','Rubus perfoliosus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27429','','','Rubus perpauper L.H. Bailey','Rubus perpauper','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27430','','','Rubus persistens Rydberg','Rubus persistens','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27431','','','Rubus philadelphicus Blanchard','Rubus philadelphicus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27424','','','Rubus originalis L.H. Bailey','Rubus originalis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27425','','','Rubus paludivagus Fernald','Rubus paludivagus','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27426','','','Rubus pauxillus L.H. Bailey','Rubus pauxillus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27427','','','Rubus penetrans L.H. Bailey','Rubus penetrans','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27420','','','Rubus missouricus L.H. Bailey','Rubus missouricus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27421','','','Rubus mollior L.H. Bailey','Rubus mollior','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27422','','','Rubus multispinus Blanchard','Rubus multispinus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27423','','','Rubus oklahomus L.H. Bailey','Rubus oklahomus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27416','','','Rubus laudatus A. Berger','Rubus laudatus','A. Berger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20371','','','Rubus × lepagei L.H. Bailey','Rubus × lepagei','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27331','','','Rubus × rixosus L.H. Bailey','Rubus × rixosus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28772','','','Rubus × ostryifolius Rydberg','Rubus × ostryifolius','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28775','','','Rubus × fraternus Brainerd & Peitersen nom. illeg.','Rubus × fraternus','Brainerd & Peitersen nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28774','','','Rubus × licens L.H. Bailey','Rubus × licens','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28773','','','Rubus × fraternalis L.H. Bailey','Rubus × fraternalis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28769','','','Rubus × permixtus Blanchard','Rubus × permixtus','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28771','','','Rubus × emeritus L.H. Bailey','Rubus × emeritus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28770','','','Rubus × segnis L.H. Bailey','Rubus × segnis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20439','','','Rubus × recurvicaulis Blanchard','Rubus × recurvicaulis','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27370','','','Rubus × janssonii L.H. Bailey','Rubus × janssonii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27371','','','Rubus × akermanii Fernald','Rubus × akermanii','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27372','','','Rubus × darlingtonii L.H. Bailey','Rubus × darlingtonii','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27373','','','Rubus × hypolasius Fernald & Brackett','Rubus × hypolasius','Fernald & Brackett','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27374','','','Rubus × largus L.H. Bailey','Rubus × largus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28819','','','Rubus mananensis L.H. Bailey ex Weatherby & J. Adams','Rubus mananensis','L.H. Bailey ex Weatherby & J. Adams','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31170','','','Rubus × wisconsinensis L.H. Bailey','Rubus × wisconsinensis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31171','','','Rubus pensilvanicus × Rubus setosus','Rubus pensilvanicus × Rubus setosus','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33641','','','Rubus subgen. Rubus Linnaeus','Rubus subgen. Rubus','Linnaeus','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~79','','','Rubus (Idaeobatus) Focke','Rubus (Idaeobatus)','Focke','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8933','','','Rubus idaeus Linnaeus','Rubus idaeus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8932','','','Rubus idaeus subsp. idaeus Linnaeus','Rubus idaeus subsp. idaeus','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8934','','','Rubus idaeus subsp. strigosus (Michaux) Focke','Rubus idaeus subsp. strigosus','(Michaux) Focke','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27165','','','Rubus strigosus var. eucyclus (Fernald & Weatherby) L.H. Bailey','Rubus strigosus var. eucyclus','(Fernald & Weatherby) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27164','','','Batidea peramoena (Greene) Fedde','Batidea peramoena','(Greene) Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20506','','','Rubus idaeus var. caudatus (B.L. Robinson & H. Schrenk) Fernald & B.G. Schubert','Rubus idaeus var. caudatus','(B.L. Robinson & H. Schrenk) Fernald & B.G. Schubert','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20507','','','Rubus idaeus var. egglestonii (Blanchard) Fernald','Rubus idaeus var. egglestonii','(Blanchard) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20504','','','Rubus idaeus var. arizonicus (Greene) Fernald','Rubus idaeus var. arizonicus','(Greene) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20486','','','Batidea laetissima Greene','Batidea laetissima','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20487','','','Batidea peramoena Greene nom. illeg.','Batidea peramoena','Greene nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20484','','','Batidea heterodoxa Greene','Batidea heterodoxa','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20485','','','Batidea itascica Greene','Batidea itascica','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20482','','','Batidea elegantula Greene','Batidea elegantula','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20483','','','Batidea filipendula Greene','Batidea filipendula','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20480','','','Batidea cataphracta Greene','Batidea cataphracta','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20481','','','Batidea dacotica Greene','Batidea dacotica','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20494','','','Rubus aliceae L.H. Bailey','Rubus aliceae','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20495','','','Rubus arizonicus (Greene) Rydberg','Rubus arizonicus','(Greene) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20492','','','Batidea viburnifolia Greene','Batidea viburnifolia','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20493','','','Rubus acalyphaceus (Greene) Rydberg','Rubus acalyphaceus','(Greene) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20490','','','Batidea subcordata Greene','Batidea subcordata','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20491','','','Batidea unicolor Greene','Batidea unicolor','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20488','','','Batidea strigosa (Michaux) Greene','Batidea strigosa','(Michaux) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20489','','','Batidea subarctica Greene','Batidea subarctica','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20479','','','Batidea arizonica Greene','Batidea arizonica','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20478','','','Batidea amplissima Greene','Batidea amplissima','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20477','','','Batidea acalyphacea Greene','Batidea acalyphacea','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20476','','','Rubus strigosus Michaux','Rubus strigosus','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20516','','','Rubus melanolasius Dieck','Rubus melanolasius','Dieck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20517','','','Rubus melanotrachys (Focke) Rydberg','Rubus melanotrachys','(Focke) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20518','','','Rubus peramoenus (Greene) Rydberg','Rubus peramoenus','(Greene) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20519','','','Rubus setosissimus Focke','Rubus setosissimus','Focke','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20512','','','Rubus idaeus var. melanotrachys (Focke) Fernald','Rubus idaeus var. melanotrachys','(Focke) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20513','','','Rubus idaeus var. peramoenus (Greene) Fernald','Rubus idaeus var. peramoenus','(Greene) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20514','','','Rubus idaeus var. strigosus (Michaux) Maximowicz','Rubus idaeus var. strigosus','(Michaux) Maximowicz','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20515','','','Rubus idaeus var. viburnifolius (Greene) Greene ex A. Berger','Rubus idaeus var. viburnifolius','(Greene) Greene ex A. Berger','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20524','','','Rubus strigosus var. caudatus B.L. Robinson & H. Schrenk','Rubus strigosus var. caudatus','B.L. Robinson & H. Schrenk','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20525','','','Rubus strigosus var. tonsus (Fernald) L.H. Bailey','Rubus strigosus var. tonsus','(Fernald) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20526','','','Rubus subarcticus (Greene) Rydberg','Rubus subarcticus','(Greene) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20520','','','Rubus strigosus var. acalyphaceus (Greene) L.H. Bailey','Rubus strigosus var. acalyphaceus','(Greene) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20521','','','Rubus strigosus var. albus Fuller ex L.H. Bailey','Rubus strigosus var. albus','Fuller ex L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20522','','','Rubus strigosus var. arizonicus (Greene) Kearney & Peebles','Rubus strigosus var. arizonicus','(Greene) Kearney & Peebles','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20523','','','Rubus strigosus var. canadensis (Richardson ex Fernald) House','Rubus strigosus var. canadensis','(Richardson ex Fernald) House','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20501','','','Rubus idaeus subsp. sachalinensis (H. Léveillé) Focke','Rubus idaeus subsp. sachalinensis','(H. Léveillé) Focke','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20500','','','Rubus idaeus subsp. melanotrachys Focke','Rubus idaeus subsp. melanotrachys','Focke','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20503','','','Rubus idaeus var. aculeatissimus Regel & Tiling','Rubus idaeus var. aculeatissimus','Regel & Tiling','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20502','','','Rubus idaeus var. acalyphaceus (Greene) Fernald','Rubus idaeus var. acalyphaceus','(Greene) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20497','','','Rubus egglestonii Blanchard','Rubus egglestonii','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20496','','','Rubus carolinianus Rydberg','Rubus carolinianus','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20499','','','Rubus idaeus subsp. melanolasius (Dieck) Focke','Rubus idaeus subsp. melanolasius','(Dieck) Focke','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20498','','','Rubus greeneanus L.H. Bailey','Rubus greeneanus','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20509','','','Rubus idaeus var. gracilipes M.E. Jones','Rubus idaeus var. gracilipes','M.E. Jones','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20508','','','Rubus idaeus var. eucyclus Fernald & Weatherby','Rubus idaeus var. eucyclus','Fernald & Weatherby','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20511','','','Rubus idaeus var. melanolasius (Dieck) R. J. Davis','Rubus idaeus var. melanolasius','(Dieck) R. J. Davis','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20510','','','Rubus idaeus var. heterolasius Fernald','Rubus idaeus var. heterolasius','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20505','','','Rubus idaeus var. canadensis Richardson ex Fernald','Rubus idaeus var. canadensis','Richardson ex Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27234','','','Rubus phoenicolasius Maximowicz','Rubus phoenicolasius','Maximowicz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33642','','','Rubus subgen. Idaeobatus Focke','Rubus subgen. Idaeobatus','Focke','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33638','','','Rubus subgen. Dalibarda (Focke) Focke','Rubus subgen. Dalibarda','(Focke) Focke','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8937','','','Rubus lasiococcus A. Gray','Rubus lasiococcus','A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20527','','','Comarobatia lasiococca (A. Gray) Greene','Comarobatia lasiococca','(A. Gray) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8727','','','Rubus repens (Linnaeus) Kuntze','Rubus repens','(Linnaeus) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20020','','','Dalibarda repens Linnaeus','Dalibarda repens','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20021','','','Rubus dalibarda Linnaeus nom. illeg.','Rubus dalibarda','Linnaeus nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8951','','','Rubus × neglectus Peck','Rubus × neglectus','Peck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33640','','','Rubus subgen. Anoplobatus (Focke) E.H.L. Krause','Rubus subgen. Anoplobatus','(Focke) E.H.L. Krause','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8942','','','Rubus parviflorus Nuttall nom. cons.','Rubus parviflorus','Nuttall nom. cons.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27158','','','Rubacer tomentosum Rydberg','Rubacer tomentosum','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27157','','','Rubacer velutinum (W.H. Brewer) A. Heller','Rubacer velutinum','(W.H. Brewer) A. Heller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27156','','','Bossekia parviflora (Nuttall) Greene','Bossekia parviflora','(Nuttall) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27155','','','Rubus nutkanus var. parviflorus (Nuttall) Focke','Rubus nutkanus var. parviflorus','(Nuttall) Focke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20565','','','Rubus parviflorus var. velutinus (W.H. Brewer) Greene','Rubus parviflorus var. velutinus','(W.H. Brewer) Greene','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20564','','','Rubus parviflorus subsp. velutinus (W.H. Brewer) Roy L. Taylor & MacBryde','Rubus parviflorus subsp. velutinus','(W.H. Brewer) Roy L. Taylor & MacBryde','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20563','','','Rubus parviflorus var. scopulorum (Greene ex Focke) Fernald','Rubus parviflorus var. scopulorum','(Greene ex Focke) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20553','','','Rubacer parviflorum (Nuttall) Rydberg','Rubacer parviflorum','(Nuttall) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20559','','','Rubus parviflorus var. fraserianus J.K. Henry','Rubus parviflorus var. fraserianus','J.K. Henry','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20560','','','Rubus parviflorus var. grandiflorus Farwell nom. illeg.','Rubus parviflorus var. grandiflorus','Farwell nom. illeg.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20561','','','Rubus parviflorus var. heteradenius Fernald','Rubus parviflorus var. heteradenius','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20562','','','Rubus parviflorus var. hypomalacus Fernald','Rubus parviflorus var. hypomalacus','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20555','','','Rubus velutinus Hooker & Arnott nom. illeg.','Rubus velutinus','Hooker & Arnott nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20556','','','Rubus nutkanus Mociño ex Seringe','Rubus nutkanus','Mociño ex Seringe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20557','','','Rubus nutkanus var. velutinus W.H. Brewer','Rubus nutkanus var. velutinus','W.H. Brewer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20558','','','Rubus parviflorus var. bifarius Fernald','Rubus parviflorus var. bifarius','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8941','','','Rubus odoratus Linnaeus','Rubus odoratus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20545','','','Bossekia odorata (Linnaeus) Greene','Bossekia odorata','(Linnaeus) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20550','','','Rubus odoratus var. columbianus Millspaugh','Rubus odoratus var. columbianus','Millspaugh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20551','','','Rubus odoratus var. malachophyllus Fernald','Rubus odoratus var. malachophyllus','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20552','','','Rubus quinquelobus Stokes','Rubus quinquelobus','Stokes','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20546','','','Rubacer columbianum (Millspaugh) Rydberg','Rubacer columbianum','(Millspaugh) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20547','','','Rubacer odoratum (Linnaeus) Rydberg','Rubacer odoratum','(Linnaeus) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20548','','','Rubus columbianus (Millspaugh) Rydberg','Rubus columbianus','(Millspaugh) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20549','','','Rubus odoratus var. albidus L.H. Bailey','Rubus odoratus var. albidus','L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33643','','','Rubus subgen. Cylactis (Rafinesque) Focke','Rubus subgen. Cylactis','(Rafinesque) Focke','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8922','','','Rubus arcticus Linnaeus','Rubus arcticus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8923','','','Rubus arcticus subsp. arcticus Linnaeus','Rubus arcticus subsp. arcticus','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20358','','','Rubus arcticus var. pentaphylloides Hultén','Rubus arcticus var. pentaphylloides','Hultén','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8921','','','Rubus arcticus subsp. acaulis (Michaux) Focke','Rubus arcticus subsp. acaulis','(Michaux) Focke','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29467','','','Rubus arcticus var. acaulis (Michaux) B. Boivin','Rubus arcticus var. acaulis','(Michaux) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23616','','','Rubus arcticus var. grandiflorus Ledebour','Rubus arcticus var. grandiflorus','Ledebour','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20356','','','Rubus arcticus var. acaulis (Michaux) B. Boivin','Rubus arcticus var. acaulis','(Michaux) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20357','','','Cylactis arcticus subsp. acaulis (Michaux) W. A. Weber','Cylactis arcticus subsp. acaulis','(Michaux) W. A. Weber','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20355','','','Rubus acaulis Michaux','Rubus acaulis','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8924','','','Rubus arcticus subsp. stellatus (J.E. Smith) B. Boivin','Rubus arcticus subsp. stellatus','(J.E. Smith) B. Boivin','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29468','','','Rubus arcticus var. stellatus (J.E. Smith) B. Boivin','Rubus arcticus var. stellatus','(J.E. Smith) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20360','','','Rubus arcticus var. stellatus (Smith) B. Boivin','Rubus arcticus var. stellatus','(Smith) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20359','','','Rubus stellatus Smith','Rubus stellatus','Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8945','','','Rubus pubescens Rafinesque','Rubus pubescens','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27445','','','Cylactis pubescens (Rafinesque) W.A. Weber','Cylactis pubescens','(Rafinesque) W.A. Weber','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27446','','','Rubus pubescens var. pubescens Rafinesque','Rubus pubescens var. pubescens','Rafinesque','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20583','','','Rubus pubescens var. scius L.H. Bailey','Rubus pubescens var. scius','L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20582','','','Rubus pubescens var. pilosifolius A.F. Hill','Rubus pubescens var. pilosifolius','A.F. Hill','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20580','','','Rubus mucronatus Seringe','Rubus mucronatus','Seringe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20579','','','Rubus americanus (Persoon) Britton','Rubus americanus','(Persoon) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20577','','','Rubus aegopodioides Seringe','Rubus aegopodioides','Seringe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20576','','','Cylactis montana Rafinesque','Cylactis montana','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20575','','','Cylactis lyncemontana Rafinesque','Cylactis lyncemontana','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20574','','','Rubus saxatilis var. canadensis Michaux','Rubus saxatilis var. canadensis','Michaux','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20586','','','Rubus triflorus Richardson','Rubus triflorus','Richardson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20584','','','Rubus saxatilis var. americanus Persoon','Rubus saxatilis var. americanus','Persoon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20585','','','Rubus transmontanus Focke','Rubus transmontanus','Focke','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8952','','','Rubus × paracaulis L.H. Bailey','Rubus × paracaulis','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33644','','','Rubus subgen. Batothamnus (Focke) E.H.I. Krause','Rubus subgen. Batothamnus','(Focke) E.H.I. Krause','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8935','','','Rubus illecebrosus Focke','Rubus illecebrosus','Focke','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8948','','','Rubus spectabilis Pursh','Rubus spectabilis','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20622','','','Rubus franciscanus Rydberg','Rubus franciscanus','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20623','','','Rubus spectabilis var. franciscanus (Rydberg) J.T. Howell','Rubus spectabilis var. franciscanus','(Rydberg) J.T. Howell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20624','','','Rubus stenopetalus Chamisso','Rubus stenopetalus','Chamisso','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33645','','','Rubus subgen. Melanobatus (Greene) House','Rubus subgen. Melanobatus','(Greene) House','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8938','','','Rubus leucodermis Douglas ex Torrey & A. Gray','Rubus leucodermis','Douglas ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27383','','','Rubus leucodermis var. leucodermis Douglas ex Torrey & A. Gray','Rubus leucodermis var. leucodermis','Douglas ex Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20533','','','Rubus leucodermis var. bernardinus (Greene) Jepson','Rubus leucodermis var. bernardinus','(Greene) Jepson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20532','','','Rubus leucodermis subsp. bernardinus (Greene) Thorne','Rubus leucodermis subsp. bernardinus','(Greene) Thorne','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20537','','','Rubus occidentalis var. leucodermis (Douglas ex Torrey & A. Gray) Focke','Rubus occidentalis var. leucodermis','(Douglas ex Torrey & A. Gray) Focke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20535','','','Rubus leucodermis var. trinitatis A. Berger','Rubus leucodermis var. trinitatis','A. Berger','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20529','','','Melanobatus bernardinus Greene','Melanobatus bernardinus','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20528','','','Batidea sandbergii Greene','Batidea sandbergii','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20531','','','Rubus bernardinus (Greene) Fedde','Rubus bernardinus','(Greene) Fedde','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20530','','','Melanobatus leucodermis (Douglas ex Torrey & A. Gray) Greene','Melanobatus leucodermis','(Douglas ex Torrey & A. Gray) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20538','','','Rubus trinitatis (A. Berger) L.H. Bailey','Rubus trinitatis','(A. Berger) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8940','','','Rubus occidentalis Linnaeus','Rubus occidentalis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20543','','','Rubus occidentalis var. flavobaccus Blanchard','Rubus occidentalis var. flavobaccus','Blanchard','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20542','','','Rubus idaeus var. americanus Torrey','Rubus idaeus var. americanus','Torrey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20544','','','Rubus occidentalis var. pallidus L.H. Bailey','Rubus occidentalis var. pallidus','L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20541','','','Melanobatus occidentalis (Linnaeus) Greene','Melanobatus occidentalis','(Linnaeus) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20540','','','Melanobatus michiganus Greene','Melanobatus michiganus','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8946','','','Rubus saxatilis Linnaeus','Rubus saxatilis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27447','','','Cylactis saxatilis (Linnaeus) Á. Löve','Cylactis saxatilis','(Linnaeus) Á. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('557','','','Ulmarieae Lamarck & de Candolle','Ulmarieae','Lamarck & de Candolle','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1175','','','Filipendula Miller','Filipendula','Miller','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8750','','','Filipendula vulgaris Moench','Filipendula vulgaris','Moench','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20051','','','Spiraea filipendula Linnaeus','Spiraea filipendula','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20052','','','Filipendula hexapetala Gilibert nom. rej.','Filipendula hexapetala','Gilibert nom. rej.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8748','','','Filipendula rubra (Hill) B.L. Robinson','Filipendula rubra','(Hill) B.L. Robinson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20039','','','Ulmaria rubra Hill','Ulmaria rubra','Hill','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20043','','','Thecanisia lobata (Gronovius ex Jacquin) Rafinesque','Thecanisia lobata','(Gronovius ex Jacquin) Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20042','','','Thecanisia angustifolia Rafinesque','Thecanisia angustifolia','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20041','','','Spiraea rubra (Hill) Britton','Spiraea rubra','(Hill) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20040','','','Filipendula lobata (Gronovius ex Jacquin) Maximowicz','Filipendula lobata','(Gronovius ex Jacquin) Maximowicz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20044','','','Thecanisia purpurea Rafinesque','Thecanisia purpurea','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8749','','','Filipendula ulmaria (Linnaeus) Maximowicz','Filipendula ulmaria','(Linnaeus) Maximowicz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20046','','','Filipendula denudata (J. Presl & C. Presl) Fritsch','Filipendula denudata','(J. Presl & C. Presl) Fritsch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20047','','','Filipendula ulmaria subsp. denudata (J. Presl & C. Presl) Hayek','Filipendula ulmaria subsp. denudata','(J. Presl & C. Presl) Hayek','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20045','','','Spiraea ulmaria Linnaeus','Spiraea ulmaria','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20050','','','Thecanisia ulmaria (Linnaeus) Rafinesque','Thecanisia ulmaria','(Linnaeus) Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20048','','','Spiraea denudata J. Presl & C. Presl','Spiraea denudata','J. Presl & C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('405','','','Sanguisorbeae de Candolle','Sanguisorbeae','de Candolle','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1645','','','Sanguisorba Linnaeus','Sanguisorba','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8959','','','Sanguisorba officinalis Linnaeus','Sanguisorba officinalis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20654','','','Sanguisorba officinalis subsp. microcephala (C. Presl) Calder & Roy L. Taylor','Sanguisorba officinalis subsp. microcephala','(C. Presl) Calder & Roy L. Taylor','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20652','','','Poterium officinale (Linnaeus) A. Gray','Poterium officinale','(Linnaeus) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20653','','','Sanguisorba microcephala C. Presl','Sanguisorba microcephala','C. Presl','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8956','','','Sanguisorba menziesii Rydberg','Sanguisorba menziesii','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8955','','','Sanguisorba stipulata Rafinesque','Sanguisorba stipulata','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20643','','','Sanguisorba canadensis subsp. latifolia (Hooker) Calder & Roy L. Taylor','Sanguisorba canadensis subsp. latifolia','(Hooker) Calder & Roy L. Taylor','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20646','','','Sanguisorba sitchensis C.A. Meyer','Sanguisorba sitchensis','C.A. Meyer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20645','','','Sanguisorba canadensis var. sitchensis (C.A. Meyer) Koidzumi','Sanguisorba canadensis var. sitchensis','(C.A. Meyer) Koidzumi','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20644','','','Sanguisorba canadensis var. latifolia Hooker','Sanguisorba canadensis var. latifolia','Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8954','','','Sanguisorba canadensis Linnaeus','Sanguisorba canadensis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32237','','','Poterium canadense (Linnaeus) A. Gray','Poterium canadense','(Linnaeus) A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25655','','','Sanguisorba canadensis subsp. canadensis Linnaeus','Sanguisorba canadensis subsp. canadensis','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1866','','','Poteridium Spach','Poteridium','Spach','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9750','','','Poteridium occidentale Rydberg','Poteridium occidentale','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21776','','','Sanguisorba occidentalis Nuttall ex Torrey & A. Gray','Sanguisorba occidentalis','Nuttall ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8953','','','Poteridium annuum (Nuttall ex Hooker) Spach','Poteridium annuum','(Nuttall ex Hooker) Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20642','','','Sanguisorba annua (Nuttall ex Hooker) Torrey & A. Gray','Sanguisorba annua','(Nuttall ex Hooker) Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20641','','','Poterium annuum Nuttall ex Hooker','Poterium annuum','Nuttall ex Hooker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1865','','','Poterium Linnaeus','Poterium','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8958','','','Poterium sanguisorba Linnaeus','Poterium sanguisorba','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23736','','','Poterium sanguisorba var. polygamum (Waldstein & Kitaibel) Visiani','Poterium sanguisorba var. polygamum','(Waldstein & Kitaibel) Visiani','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20647','','','Poterium polygamum Waldstein & Kitaibel','Poterium polygamum','Waldstein & Kitaibel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20650','','','Sanguisorba minor subsp. balearica (Bourgeau ex Nyman) Muñoz Garmendia & C. Navarro','Sanguisorba minor subsp. balearica','(Bourgeau ex Nyman) Muñoz Garmendia & C. Navarro','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20651','','','Sanguisorba minor subsp. muricata (Spach) Briquet','Sanguisorba minor subsp. muricata','(Spach) Briquet','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20648','','','Poterium balearicum (Bourgeau ex Nyman) Bourgeau ex Porta','Poterium balearicum','(Bourgeau ex Nyman) Bourgeau ex Porta','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20649','','','Poterium sanguisorba subsp. muricatum (Spach) Rouy','Poterium sanguisorba subsp. muricatum','(Spach) Rouy','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('789','','','Agrimonia Linnaeus','Agrimonia','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8605','','','Agrimonia striata Michaux','Agrimonia striata','Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19799','','','Agrimonia brittoniana E.P. Bicknell','Agrimonia brittoniana','E.P. Bicknell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19798','','','Agrimonia striata var. campanulata Fernald','Agrimonia striata var. campanulata','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8604','','','Agrimonia pubescens Wallroth','Agrimonia pubescens','Wallroth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19797','','','Agrimonia platycarpa Wallroth','Agrimonia platycarpa','Wallroth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19796','','','Agrimonia mollis var. bicknellii Kearney','Agrimonia mollis var. bicknellii','Kearney','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19795','','','Agrimonia mollis (Torrey & A. Gray) Britton','Agrimonia mollis','(Torrey & A. Gray) Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19794','','','Agrimonia eupatoria var. mollis Torrey & A. Gray','Agrimonia eupatoria var. mollis','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19793','','','Agrimonia bicknellii (Kearney) Rydberg','Agrimonia bicknellii','(Kearney) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8603','','','Agrimonia parviflora Aiton','Agrimonia parviflora','Aiton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19790','','','Agrimonia polyphylla Urban','Agrimonia polyphylla','Urban','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19792','','','Agrimonia serrifolia Wallroth','Agrimonia serrifolia','Wallroth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19791','','','Agrimonia suaveolens Pursh','Agrimonia suaveolens','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8600','','','Agrimonia eupatoria Linnaeus','Agrimonia eupatoria','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8601','','','Agrimonia gryposepala Wallroth','Agrimonia gryposepala','Wallroth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19788','','','Eupatorium gryposepalum (Wallroth) Lunell nom. illeg.','Eupatorium gryposepalum','(Wallroth) Lunell nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19787','','','Agrimonia parviflora var. macrocarpa Focke','Agrimonia parviflora var. macrocarpa','Focke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19786','','','Agrimonia macrocarpa (Focke) Rydberg','Agrimonia macrocarpa','(Focke) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19785','','','Agrimonia eupatoria var. parviflora (Aiton) Hooker','Agrimonia eupatoria var. parviflora','(Aiton) Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8602','','','Agrimonia repens Linnaeus','Agrimonia repens','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19789','','','Agrimonia odorata Miller','Agrimonia odorata','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('264','','','Amygdaloideae Arnott','Amygdaloideae','Arnott','SUBFAMILY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('416','','','Maleae Small','Maleae','Small','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('809','','','Amelanchier Medikus','Amelanchier','Medikus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8618','','','Amelanchier arborea (F. Michaux) Fernald','Amelanchier arborea','(F. Michaux) Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19813','','','Mespilus arborea F. Michaux','Mespilus arborea','F. Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19814','','','Amelanchier arborea var. arborea (F. Michaux) Fernald','Amelanchier arborea var. arborea','(F. Michaux) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8619','','','Amelanchier bartramiana (Tausch) M. Roemer','Amelanchier bartramiana','(Tausch) M. Roemer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30721','','','Amelanchier arguta Nuttall ex Britton','Amelanchier arguta','Nuttall ex Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30722','','','Amelanchier quebecensis M. Bertrand','Amelanchier quebecensis','M. Bertrand','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30719','','','Mespilus canadensis var. oligocarpa Michaux','Mespilus canadensis var. oligocarpa','Michaux','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30720','','','Amelanchier oligocarpa (Michaux) M. Roemer','Amelanchier oligocarpa','(Michaux) M. Roemer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30718','','','Aronia praecox J.C. Neumann ex Tausch nom. inval.','Aronia praecox','J.C. Neumann ex Tausch nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19815','','','Pyrus bartramiana Tausch','Pyrus bartramiana','Tausch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8621','','','Amelanchier fernaldii Wiegand','Amelanchier fernaldii','Wiegand','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8622','','','Amelanchier laevis Wiegand','Amelanchier laevis','Wiegand','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23740','','','Amelanchier laevis var. nitida (Wiegand) Fernald','Amelanchier laevis var. nitida','(Wiegand) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23739','','','Amelanchier arborea subsp. laevis (Wiegand) S.M. McKay ex P. Landry','Amelanchier arborea subsp. laevis','(Wiegand) S.M. McKay ex P. Landry','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19818','','','Amelanchier arborea var. cordifolia (Ashe) B. Boivin','Amelanchier arborea var. cordifolia','(Ashe) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19817','','','Amelanchier arborea var. laevis (Wiegand) H.E. Ahles','Amelanchier arborea var. laevis','(Wiegand) H.E. Ahles','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8620','','','Amelanchier canadensis (Linnaeus) Medikus','Amelanchier canadensis','(Linnaeus) Medikus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23738','','','Amelanchier canadensis var. canadensis (Linnaeus) Medikus','Amelanchier canadensis var. canadensis','(Linnaeus) Medikus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25276','','','Amelanchier canadensis var. oblongifolia Torrey & A. Gray','Amelanchier canadensis var. oblongifolia','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25274','','','Amelanchier oblongifolia (Torrey & A. Gray) M. Roemer','Amelanchier oblongifolia','(Torrey & A. Gray) M. Roemer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25275','','','Amelanchier canadensis var. subintegra Fernald','Amelanchier canadensis var. subintegra','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25272','','','Pyrus botryapium Linnaeus f.','Pyrus botryapium','Linnaeus f.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25273','','','Amelanchier canadensis var. .)Torrey&A.Gray (Linnaeus f.) Torrey & A. Gray','Amelanchier canadensis var. .)Torrey&A.Gray','(Linnaeus f.) Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25271','','','Amelanchier botryapium de Candolle nom. illeg.','Amelanchier botryapium','de Candolle nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19816','','','Mespilus canadensis Linnaeus','Mespilus canadensis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8625','','','Amelanchier spicata (Lamarck) K. Koch','Amelanchier spicata','(Lamarck) K. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25277','','','Amelanchier canadensis subsp. spicata (Lamarck) Á. Löve & D. Löve','Amelanchier canadensis subsp. spicata','(Lamarck) Á. Löve & D. Löve','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25280','','','Amelanchier stolonifera var. lucida Fernald','Amelanchier stolonifera var. lucida','Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25278','','','Amelanchier canadensis var. stolonifera (Wiegand) P. Landry','Amelanchier canadensis var. stolonifera','(Wiegand) P. Landry','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25279','','','Amelanchier spicata var. spicata (Lamarck) K. Koch','Amelanchier spicata var. spicata','(Lamarck) K. Koch','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23741','','','Amelanchier arborea var. austromontana (Ashe) H.E. Ahles','Amelanchier arborea var. austromontana','(Ashe) H.E. Ahles','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23742','','','Amelanchier austromontana Ashe','Amelanchier austromontana','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19822','','','Crataegus spicata Lamarck','Crataegus spicata','Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19824','','','Amelanchier lucida (Fernald) Fernald','Amelanchier lucida','(Fernald) Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19823','','','Amelanchier stolonifera Wiegand','Amelanchier stolonifera','Wiegand','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19825','','','Amelanchier spicata var. stolonifera (Wiegand) Cinq-Mars','Amelanchier spicata var. stolonifera','(Wiegand) Cinq-Mars','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8626','','','Amelanchier intermedia Spach','Amelanchier intermedia','Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8623','','','Amelanchier nantucketensis E.P. Bicknell','Amelanchier nantucketensis','E.P. Bicknell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19819','','','Amelanchier oblongifolia var. micropetala B.L. Robinson','Amelanchier oblongifolia var. micropetala','B.L. Robinson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8624','','','Amelanchier sanguinea (Pursh) de Candolle','Amelanchier sanguinea','(Pursh) de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28158','','','Amelanchier sanguinea var. sanguinea (Pursh) de Candolle','Amelanchier sanguinea var. sanguinea','(Pursh) de Candolle','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19820','','','Amelanchier huronensis Wiegand','Amelanchier huronensis','Wiegand','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19821','','','Pyrus sanguinea Pursh','Pyrus sanguinea','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26248','','','Amelanchier bartramiana × Amelanchier spicata','Amelanchier bartramiana × Amelanchier spicata','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26249','','','Amelanchier laevis × Amelanchier spicata','Amelanchier laevis × Amelanchier spicata','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8617','','','Amelanchier alnifolia (Nuttall) Nuttall ex M. Roemer','Amelanchier alnifolia','(Nuttall) Nuttall ex M. Roemer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8616','','','Amelanchier alnifolia var. alnifolia (Nuttall) Nuttall ex M. Roemer','Amelanchier alnifolia var. alnifolia','(Nuttall) Nuttall ex M. Roemer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19812','','','Aronia alnifolia Nuttall','Aronia alnifolia','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9648','','','Amelanchier alnifolia var. semiintegrifolia (Hooker) C.L. Hitchcock','Amelanchier alnifolia var. semiintegrifolia','(Hooker) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23737','','','Amelanchier ovalis var. semiintegrifolia Hooker','Amelanchier ovalis var. semiintegrifolia','Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21669','','','Amelanchier florida var. humptulipensis G.N. Jones','Amelanchier florida var. humptulipensis','G.N. Jones','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21670','','','Amelanchier alnifolia var. humptulipensis (G.N. Jones) C.L. Hitchcock','Amelanchier alnifolia var. humptulipensis','(G.N. Jones) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9716','','','Amelanchier alnifolia var. pumila (Torrey & A. Gray) A. Nelson','Amelanchier alnifolia var. pumila','(Torrey & A. Gray) A. Nelson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21753','','','Amelanchier canadensis var. pumila Torrey & A. Gray','Amelanchier canadensis var. pumila','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9649','','','Amelanchier cusickii Fernald','Amelanchier cusickii','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30717','','','Amelanchier florida var. cusickii (Fernald) B. Boivin','Amelanchier florida var. cusickii','(Fernald) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21671','','','Amelanchier alnifolia var. cusickii (Fernald) C.L. Hitchcock','Amelanchier alnifolia var. cusickii','(Fernald) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21672','','','Amelanchier basalticola Piper','Amelanchier basalticola','Piper','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9650','','','Amelanchier gaspensis (Wiegand) Fernald & Weatherby','Amelanchier gaspensis','(Wiegand) Fernald & Weatherby','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21673','','','Amelanchier sanguinea var. gaspensis Wiegand','Amelanchier sanguinea var. gaspensis','Wiegand','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9651','','','Amelanchier amabilis Wiegand','Amelanchier amabilis','Wiegand','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21674','','','Amelanchier sanguinea var. grandiflora (Wiegand) Rehder','Amelanchier sanguinea var. grandiflora','(Wiegand) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9764','','','Amelanchier × lamarckii F.G. Schroeder','Amelanchier × lamarckii','F.G. Schroeder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8627','','','Amelanchier × neglecta Eggleston ex K.R. Cushman, M.B. Burgess, E.T. Doucette & C.S. Campbell','Amelanchier × neglecta','Eggleston ex K.R. Cushman, M.B. Burgess, E.T. Doucette & C.S. Campbell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30716','','','Amelanchier canadensis var. pauciflora Farwell','Amelanchier canadensis var. pauciflora','Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8628','','','Amelanchier × quinti-martii Louis-Marie','Amelanchier × quinti-martii','Louis-Marie','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8629','','','Amelanchier interior E.L. Nielsen','Amelanchier interior','E.L. Nielsen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19826','','','Amelanchier wiegandii E.L. Nielsen','Amelanchier wiegandii','E.L. Nielsen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9647','','','Amelanchier humilis Wiegand','Amelanchier humilis','Wiegand','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21667','','','Amelanchier humilis var. compacta E.L. Nielsen','Amelanchier humilis var. compacta','E.L. Nielsen','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21666','','','Amelanchier humilis var. campestris E.L. Nielsen','Amelanchier humilis var. campestris','E.L. Nielsen','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21668','','','Amelanchier humilis var. exserrata E.L. Nielsen','Amelanchier humilis var. exserrata','E.L. Nielsen','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21665','','','Amelanchier mucronata E.L. Nielsen','Amelanchier mucronata','E.L. Nielsen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1047','','','Crataegus Linnaeus nom. cons.','Crataegus','Linnaeus nom. cons.','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2264','','','Crataegus sect. Coccineae Loudon','Crataegus sect. Coccineae','Loudon','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2408','','','Crataegus ser. Rotundifoliae (Eggleston) Rehder','Crataegus ser. Rotundifoliae','(Eggleston) Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8685','','','Crataegus irrasa Sargent','Crataegus irrasa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19945','','','Crataegus noveboracensis Sargent','Crataegus noveboracensis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8691','','','Crataegus lumaria Ashe','Crataegus lumaria','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19949','','','Crataegus dodgei var. lumaria (Ashe) Sargent','Crataegus dodgei var. lumaria','(Ashe) Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9664','','','Crataegus jackii Sargent','Crataegus jackii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9727','','','Crataegus sheila-phippsiae J.B. Phipps & O''Kennon','Crataegus sheila-phippsiae','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9726','','','Crataegus sheila-phippsiae var. saskatchewanensis J.B. Phipps & O''Kennon','Crataegus sheila-phippsiae var. saskatchewanensis','J.B. Phipps & O''Kennon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24167','','','Crataegus sheila-phippsiae var. sheila-phippsiae J.B. Phipps & O''Kennon','Crataegus sheila-phippsiae var. sheila-phippsiae','J.B. Phipps & O''Kennon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8673','','','Crataegus dodgei Ashe','Crataegus dodgei','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25777','','','Crataegus rotundifolia Moench nom. illeg.','Crataegus rotundifolia','Moench nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19915','','','Crataegus crassifolia Sargent','Crataegus crassifolia','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19914','','','Crataegus chrysocarpa var. dodgei (Ashe) E.J. Palmer','Crataegus chrysocarpa var. dodgei','(Ashe) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19916','','','Crataegus delosii Sargent','Crataegus delosii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19917','','','Crataegus rotundata Sargent','Crataegus rotundata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19918','','','Crataegus rotundifolia var. rotundifolia Moench','Crataegus rotundifolia var. rotundifolia','Moench','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19919','','','Crataegus dodgei var. flavida (Sargent) P. Smith & J.B. Phipps','Crataegus dodgei var. flavida','(Sargent) P. Smith & J.B. Phipps','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8672','','','Crataegus dodgei var. dodgei Ashe','Crataegus dodgei var. dodgei','Ashe','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8674','','','Crataegus flavida Sargent','Crataegus flavida','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8657','','','Crataegus chrysocarpa Ashe','Crataegus chrysocarpa','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28718','','','Crataegus chrysocarpa var. phoeniceoides J.B. Phipps & Sennikov','Crataegus chrysocarpa var. phoeniceoides','J.B. Phipps & Sennikov','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8659','','','Crataegus chrysocarpa var. phoenicea E.J. Palmer ex J.B. Phipps nom. illeg.','Crataegus chrysocarpa var. phoenicea','E.J. Palmer ex J.B. Phipps nom. illeg.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23944','','','Crataegus chrysocarpa var. subrotundifolia (Sargent) J.B. Phipps','Crataegus chrysocarpa var. subrotundifolia','(Sargent) J.B. Phipps','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19883','','','Crataegus coccinata Sargent','Crataegus coccinata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19884','','','Crataegus subrotundifolia Sargent','Crataegus subrotundifolia','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9717','','','Crataegus chrysocarpa var. vigintistamina J.B. Phipps','Crataegus chrysocarpa var. vigintistamina','J.B. Phipps','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9676','','','Crataegus chrysocarpa var. vernonensis J.B. Phipps & O''Kennon','Crataegus chrysocarpa var. vernonensis','J.B. Phipps & O''Kennon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9675','','','Crataegus chrysocarpa var. faxonii (Sargent) Eggleston','Crataegus chrysocarpa var. faxonii','(Sargent) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21710','','','Crataegus rotundifolia var. faxonii (Sargent) Eggleston','Crataegus rotundifolia var. faxonii','(Sargent) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21709','','','Crataegus faxonii Sargent','Crataegus faxonii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9663','','','Crataegus chrysocarpa var. blanchardii (Sargent) J.B. Phipps','Crataegus chrysocarpa var. blanchardii','(Sargent) J.B. Phipps','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21698','','','Crataegus irrasa var. blanchardii (Sargent) Eggleston','Crataegus irrasa var. blanchardii','(Sargent) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21697','','','Crataegus blanchardii Sargent','Crataegus blanchardii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8660','','','Crataegus chrysocarpa var. piperi (Britton) Kruschke','Crataegus chrysocarpa var. piperi','(Britton) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19892','','','Crataegus columbiana var. piperi (Britton) Eggleston','Crataegus columbiana var. piperi','(Britton) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19890','','','Crataegus piperi Britton','Crataegus piperi','Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8658','','','Crataegus chrysocarpa var. chrysocarpa Ashe','Crataegus chrysocarpa var. chrysocarpa','Ashe','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19885','','','Crataegus coloradoides Ramalay','Crataegus coloradoides','Ramalay','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19886','','','Crataegus columbiana var. chrysocarpa (Ashe) Dorn','Crataegus columbiana var. chrysocarpa','(Ashe) Dorn','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19889','','','Crataegus rotundifolia var. pubera Sargent','Crataegus rotundifolia var. pubera','Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19887','','','Crataegus doddsii Ramalay','Crataegus doddsii','Ramalay','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19888','','','Crataegus rotundifolia var. chrysocarpa (Ashe) Eggleston','Crataegus rotundifolia var. chrysocarpa','(Ashe) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9728','','','Crataegus ursopedensis J.B. Phipps & O''Kennon','Crataegus ursopedensis','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8697','','','Crataegus margarettae Ashe','Crataegus margarettae','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23980','','','Crataegus margarettae var. angustifolia E.J. Palmer','Crataegus margarettae var. angustifolia','E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23979','','','Crataegus margarettae var. margarettae Ashe','Crataegus margarettae var. margarettae','Ashe','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2409','','','Crataegus ser. Coccineae (Loudon) Rehder','Crataegus ser. Coccineae','(Loudon) Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8662','','','Crataegus coccinea Linnaeus','Crataegus coccinea','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8681','','','Crataegus coccinea var. fulleriana (Sargent) Kruschke','Crataegus coccinea var. fulleriana','(Sargent) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19930','','','Crataegus fulleriana Sargent','Crataegus fulleriana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19931','','','Crataegus chippewaensis Sargent','Crataegus chippewaensis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19932','','','Crataegus confragosa Sargent','Crataegus confragosa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19933','','','Crataegus illecebrosa Sargent','Crataegus illecebrosa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8710','','','Crataegus coccinea var. pringlei (Sargent) J.A. Macklin & J.B. Phipps','Crataegus coccinea var. pringlei','(Sargent) J.A. Macklin & J.B. Phipps','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19996','','','Crataegus pringlei Sargent','Crataegus pringlei','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19998','','','Crataegus gloriosa Sargent','Crataegus gloriosa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19997','','','Crataegus exclusa Sargent','Crataegus exclusa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8661','','','Crataegus coccinea var. coccinea Linnaeus','Crataegus coccinea var. coccinea','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19894','','','Crataegus delecta Sargent','Crataegus delecta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19895','','','Crataegus digna Sargent','Crataegus digna','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19893','','','Crataegus acclivis Sargent','Crataegus acclivis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19896','','','Crataegus pedicellata Sargent','Crataegus pedicellata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19897','','','Crataegus uticaensis Sargent','Crataegus uticaensis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8683','','','Crataegus holmesiana Ashe','Crataegus holmesiana','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23978','','','Crataegus holmesiana var. villipes Ashe','Crataegus holmesiana var. villipes','Ashe','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19938','','','Crataegus pura Sargent','Crataegus pura','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19937','','','Crataegus miranda Sargent','Crataegus miranda','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19940','','','Crataegus tardipes Sargent','Crataegus tardipes','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19939','','','Crataegus sertata Sargent','Crataegus sertata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19934','','','Crataegus anomala Sargent','Crataegus anomala','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19936','','','Crataegus elongata Sargent','Crataegus elongata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19935','','','Crataegus eamesii Sargent','Crataegus eamesii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8696','','','Crataegus magniflora Sargent','Crataegus magniflora','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19978','','','Crataegus macounii Sargent','Crataegus macounii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19977','','','Crataegus hillii Sargent','Crataegus hillii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19976','','','Crataegus dayana Sargent','Crataegus dayana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8666','','','Crataegus corusca Sargent','Crataegus corusca','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2416','','','Crataegus ser. Molles (Sargent) Rehder','Crataegus ser. Molles','(Sargent) Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8718','','','Crataegus submollis Sargent','Crataegus submollis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20012','','','Crataegus arnoldiana Sargent','Crataegus arnoldiana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20014','','','Crataegus champlainensis Sargent','Crataegus champlainensis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8699','','','Crataegus mollis (Torrey & A. Gray) Scheele','Crataegus mollis','(Torrey & A. Gray) Scheele','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8698','','','Crataegus mollis var. mollis (Torrey & A. Gray) Scheele','Crataegus mollis var. mollis','(Torrey & A. Gray) Scheele','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19985','','','Crataegus invisa Sargent','Crataegus invisa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19984','','','Crataegus berlandieri Sargent','Crataegus berlandieri','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19983','','','Crataegus arkansana Sargent','Crataegus arkansana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19982','','','Crataegus coccinea var. mollis Torrey & A. Gray','Crataegus coccinea var. mollis','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19987','','','Crataegus meridionalis Sargent','Crataegus meridionalis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19986','','','Crataegus limaria Sargent','Crataegus limaria','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19990','','','Crataegus subvillosa Schrader ex Torrey & A. Gray','Crataegus subvillosa','Schrader ex Torrey & A. Gray','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19989','','','Crataegus sera Sargent','Crataegus sera','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23981','','','Crataegus mollis var. incisifolia Kruschke ex J. B. Phipps','Crataegus mollis var. incisifolia','Kruschke ex J. B. Phipps','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29105','','','Crataegus pennsylvanica Ashe','Crataegus pennsylvanica','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29106','','','Crataegus tatnalliana Sargent','Crataegus tatnalliana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20013','','','Crataegus canadensis Sargent','Crataegus canadensis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2413','','','Crataegus ser. Tenuifoliae (Sargent) Rehder','Crataegus ser. Tenuifoliae','(Sargent) Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8677','','','Crataegus flabellata (Bosc ex Spach) K. Koch','Crataegus flabellata','(Bosc ex Spach) K. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28321','','','Crataegus flabellata var. grayana (Eggleston) E.J. Palmer','Crataegus flabellata var. grayana','(Eggleston) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25775','','','Crataegus flabellata var. flabellata (Bosc ex Spach) Rydberg','Crataegus flabellata var. flabellata','(Bosc ex Spach) Rydberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19920','','','Mespilus flabellata Bosc ex Spach','Mespilus flabellata','Bosc ex Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19921','','','Crataegus crudelis Sargent','Crataegus crudelis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19922','','','Crataegus densiflora Sargent nom. illeg.','Crataegus densiflora','Sargent nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19923','','','Crataegus grayana Eggleston','Crataegus grayana','Eggleston','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8695','','','Crataegus macrosperma Ashe','Crataegus macrosperma','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28320','','','Crataegus macrosperma var. acutiloba (Sargent) Eggleston','Crataegus macrosperma var. acutiloba','(Sargent) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19974','','','Crataegus roanensis Ashe','Crataegus roanensis','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19973','','','Crataegus pentandra Sargent','Crataegus pentandra','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19972','','','Crataegus pastorum Sargent','Crataegus pastorum','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19971','','','Crataegus matura Sargent','Crataegus matura','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19970','','','Crataegus iracunda var. brumalis (Ashe) Kruschke','Crataegus iracunda var. brumalis','(Ashe) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19969','','','Crataegus demissa Sargent','Crataegus demissa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19968','','','Crataegus brumalis Ashe','Crataegus brumalis','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19967','','','Crataegus acutiloba Sargent','Crataegus acutiloba','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8717','','','Crataegus schuettei Ashe','Crataegus schuettei','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8716','','','Crataegus schuettei var. schuettei Ashe','Crataegus schuettei var. schuettei','Ashe','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20010','','','Crataegus basilica Beadle','Crataegus basilica','Beadle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8679','','','Crataegus fluviatilis Sargent','Crataegus fluviatilis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19926','','','Crataegus apiomorpha Sargent','Crataegus apiomorpha','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19927','','','Crataegus apiomorpha var. cyanophylla (Sargent) Kruschke','Crataegus apiomorpha var. cyanophylla','(Sargent) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19928','','','Crataegus cyanophylla Sargent','Crataegus cyanophylla','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2415','','','Crataegus ser. Punctatae (Loudon) Rehder','Crataegus ser. Punctatae','(Loudon) Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8686','','','Crataegus jonesiae Sargent','Crataegus jonesiae','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8713','','','Crataegus punctata Jacquin','Crataegus punctata','Jacquin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31568','','','Crataegus punctata var. microphylla Sargent','Crataegus punctata var. microphylla','Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9674','','','Crataegus punctata var. aurea Aiton','Crataegus punctata var. aurea','Aiton','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8712','','','Crataegus punctata var. punctata Jacquin','Crataegus punctata var. punctata','Jacquin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2419','','','Crataegus ser. Populneae J.B. Phipps','Crataegus ser. Populneae','J.B. Phipps','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9666','','','Crataegus stolonifera Sargent','Crataegus stolonifera','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21700','','','Crataegus iracunda var. stolonifera (Sargent) Krushke','Crataegus iracunda var. stolonifera','(Sargent) Krushke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8709','','','Crataegus populnea Ashe','Crataegus populnea','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19994','','','Crataegus iracunda var. populnea (Ashe) Kruschke','Crataegus iracunda var. populnea','(Ashe) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19993','','','Crataegus compta Sargent','Crataegus compta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19995','','','Crataegus luxuriosa Sargent','Crataegus luxuriosa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29477','','','Crataegus jesupii Sargent','Crataegus jesupii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8652','','','Crataegus beata Sargent','Crataegus beata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30737','','','Crataegus prona Ashe','Crataegus prona','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30738','','','Crataegus gravis Ashe','Crataegus gravis','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2411','','','Crataegus ser. Pruinosae Sargent ex Rehder','Crataegus ser. Pruinosae','Sargent ex Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8706','','','Crataegus perjucunda Sargent','Crataegus perjucunda','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8665','','','Crataegus compacta Sargent','Crataegus compacta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8680','','','Crataegus formosa Sargent','Crataegus formosa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19929','','','Crataegus pruinosa var. grandiflora Kruschke nom. inval.','Crataegus pruinosa var. grandiflora','Kruschke nom. inval.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8719','','','Crataegus suborbiculata Sargent','Crataegus suborbiculata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8664','','','Crataegus cognata Sargent','Crataegus cognata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19907','','','Crataegus pruinosa var. cognata (Sargent) J.B. Phipps','Crataegus pruinosa var. cognata','(Sargent) J.B. Phipps','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19906','','','Crataegus patrum Sargent','Crataegus patrum','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19905','','','Crataegus decorata Sargent','Crataegus decorata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19904','','','Crataegus aperta Sargent','Crataegus aperta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8671','','','Crataegus pruinosa (H.L. Wendland) K. Koch','Crataegus pruinosa','(H.L. Wendland) K. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8670','','','Crataegus pruinosa var. dissona (Sargent) Eggleston','Crataegus pruinosa var. dissona','(Sargent) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19911','','','Crataegus disjuncta Sargent','Crataegus disjuncta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19910','','','Crataegus brachypoda Sargent','Crataegus brachypoda','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19913','','','Crataegus rigida Sargent','Crataegus rigida','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19912','','','Crataegus dissona Sargent','Crataegus dissona','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24156','','','Crataegus pruinosa var. parvula (Sargent) J.B. Phipps','Crataegus pruinosa var. parvula','(Sargent) J.B. Phipps','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20005','','','Crataegus parvula Sargent','Crataegus parvula','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8711','','','Crataegus pruinosa var. pruinosa (H.L. Wendland) K. Koch','Crataegus pruinosa var. pruinosa','(H.L. Wendland) K. Koch','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24155','','','Crataegus tumida Sargent','Crataegus tumida','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24154','','','Crataegus bracteata Sargent','Crataegus bracteata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20000','','','Crataegus conjuncta Sargent','Crataegus conjuncta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19999','','','Crataegus caerulescens Sargent','Crataegus caerulescens','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20002','','','Crataegus horridula Sargent','Crataegus horridula','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20001','','','Crataegus gracilis Sargent','Crataegus gracilis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20004','','','Crataegus longipedunculata Sargent','Crataegus longipedunculata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20006','','','Crataegus porteri Britton','Crataegus porteri','Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20007','','','Crataegus prominens Sargent','Crataegus prominens','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20008','','','Mespilus pruinosa Wendland f.','Mespilus pruinosa','Wendland f.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8650','','','Crataegus ater Ashe','Crataegus ater','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24162','','','Crataegus pruinosa var. virella (Ashe) Kruschke','Crataegus pruinosa var. virella','(Ashe) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24163','','','Crataegus virella Ashe','Crataegus virella','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24157','','','Crataegus pruinosa var. rugosa (Ashe) Kruschke','Crataegus pruinosa var. rugosa','(Ashe) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24159','','','Crataegus rubicundula Sargent','Crataegus rubicundula','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24158','','','Crataegus rugosa Ashe','Crataegus rugosa','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24161','','','Crataegus seducta Sargent','Crataegus seducta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24160','','','Crataegus seclusa Sargent','Crataegus seclusa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20003','','','Crataegus leiophylla Sargent','Crataegus leiophylla','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2265','','','Crataegus sect. Crataegus','Crataegus sect. Crataegus','','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2417','','','Crataegus ser. Crataegus','Crataegus ser. Crataegus','','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8724','','','Crataegus × media Bechstein','Crataegus × media','Bechstein','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8689','','','Crataegus laevigata (Poiret) de Candolle','Crataegus laevigata','(Poiret) de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19947','','','Crataegus oxyacanthoides Thuillier','Crataegus oxyacanthoides','Thuillier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19946','','','Mespilus laevigata Poiret','Mespilus laevigata','Poiret','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19948','','','Crataegus palmstruchii Lindman','Crataegus palmstruchii','Lindman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8700','','','Crataegus monogyna Jacquin','Crataegus monogyna','Jacquin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23982','','','Crataegus monogyna var. monogyna Jacquin','Crataegus monogyna var. monogyna','Jacquin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2418','','','Crataegus ser. Cordatae (Beadle) Rehder','Crataegus ser. Cordatae','(Beadle) Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8707','','','Crataegus phaenopyrum (Linnaeus f.) Medikus','Crataegus phaenopyrum','(Linnaeus f.) Medikus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19992','','','Crataegus youngii Sargent','Crataegus youngii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19991','','','Mespilus phaenopyrum Linnaeus f.','Mespilus phaenopyrum','Linnaeus f.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2430','','','Crataegus ser. Montaninsulae J.B. Phipps & O''Kennon','Crataegus ser. Montaninsulae','J.B. Phipps & O''Kennon','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9722','','','Crataegus rivuloadamensis J.B. Phipps & O''Kennon','Crataegus rivuloadamensis','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9724','','','Crataegus rivulopugnensis J.B. Phipps & O''Kennon','Crataegus rivulopugnensis','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9723','','','Crataegus purpurella J.B. Phipps & O''Kennon','Crataegus purpurella','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2414','','','Crataegus ser. Intricatae (Sargent) Rehder','Crataegus ser. Intricatae','(Sargent) Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8684','','','Crataegus intricata Lange','Crataegus intricata','Lange','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31908','','','Crataegus douglasii Macoun nom. illeg.','Crataegus douglasii','Macoun nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19943','','','Crataegus foetida Ashe','Crataegus foetida','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19942','','','Crataegus boyntonii Beadle','Crataegus boyntonii','Beadle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19944','','','Crataegus intricata var. boyntonii (Beadle) Kruschke','Crataegus intricata var. boyntonii','(Beadle) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8690','','','Crataegus lemingtonensis Sargent','Crataegus lemingtonensis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8688','','','Crataegus × knieskerniana Sargent','Crataegus × knieskerniana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2410','','','Crataegus ser. Dilatatae','Crataegus ser. Dilatatae','','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8663','','','Crataegus coccinioides Ashe','Crataegus coccinioides','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19898','','','Crataegus callicarpa Sargent','Crataegus callicarpa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19899','','','Crataegus conspecta Sargent','Crataegus conspecta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19903','','','Crataegus speciosa Sargent','Crataegus speciosa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19902','','','Crataegus locuples Sargent','Crataegus locuples','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19901','','','Crataegus dilatata Sargent','Crataegus dilatata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19900','','','Crataegus declivitatis Sargent','Crataegus declivitatis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2412','','','Crataegus ser. Crus-galli (Loudon) Rehder','Crataegus ser. Crus-galli','(Loudon) Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8668','','','Crataegus crus-galli Linnaeus','Crataegus crus-galli','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8667','','','Crataegus crus-galli var. crus-galli Linnaeus','Crataegus crus-galli var. crus-galli','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23946','','','Crataegus albanthera Sargent','Crataegus albanthera','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23945','','','Crataegus acutifolia Sargent','Crataegus acutifolia','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23948','','','Crataegus barrettiana Sargent','Crataegus barrettiana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23947','','','Crataegus arborea Beadle','Crataegus arborea','Beadle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23974','','','Crataegus tenuispina Sargent','Crataegus tenuispina','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23975','','','Crataegus truncata Sargent','Crataegus truncata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23965','','','Crataegus polyclada Sargent','Crataegus polyclada','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23966','','','Crataegus regalis Beadle','Crataegus regalis','Beadle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23967','','','Crataegus rubrifolia Sargent','Crataegus rubrifolia','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23968','','','Crataegus rudis Sargent','Crataegus rudis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23969','','','Crataegus severa Sargent','Crataegus severa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23970','','','Crataegus strongylophylla Sargent','Crataegus strongylophylla','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23971','','','Crataegus tantula Sargent','Crataegus tantula','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23972','','','Crataegus tardiflora Sargent','Crataegus tardiflora','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23958','','','Crataegus ludoviciensis Sargent','Crataegus ludoviciensis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23957','','','Crataegus leptophylla Sargent','Crataegus leptophylla','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23960','','','Crataegus pachyphylla Sargent','Crataegus pachyphylla','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23959','','','Crataegus monosperma Sargent','Crataegus monosperma','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23962','','','Crataegus parkiae Sargent','Crataegus parkiae','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23961','','','Crataegus paradoxa Sargent','Crataegus paradoxa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23964','','','Crataegus phaneroneura Sargent','Crataegus phaneroneura','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23963','','','Crataegus permera Sargent','Crataegus permera','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23950','','','Crataegus candens Sargent','Crataegus candens','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23949','','','Crataegus calophylla Sargent','Crataegus calophylla','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23952','','','Crataegus consueta Sargent','Crataegus consueta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23951','','','Crataegus cherokeenis Sargent','Crataegus cherokeenis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23954','','','Crataegus hamata Sargent','Crataegus hamata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23953','','','Crataegus crus-galli var. oblongata Sargent','Crataegus crus-galli var. oblongata','Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23956','','','Crataegus infera Sargent','Crataegus infera','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23955','','','Crataegus hannibalensis E.J. Palmer','Crataegus hannibalensis','E.J. Palmer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19909','','','Crataegus tenax Ashe','Crataegus tenax','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19908','','','Crataegus arduennae Sargent','Crataegus arduennae','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8725','','','Crataegus persimilis Sargent','Crataegus persimilis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27167','','','Crataegus cerasina Sargent','Crataegus cerasina','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27170','','','Crataegus robusta Sargent','Crataegus robusta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27168','','','Crataegus laetifica Sargent','Crataegus laetifica','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27169','','','Crataegus livoniana Sargent','Crataegus livoniana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23660','','','Crataegus prunifolia Persoon nom. illeg.','Crataegus prunifolia','Persoon nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23663','','','Crataegus heldebergensis Sargent','Crataegus heldebergensis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23661','','','Mespilus prunifolia Poiret nom. illeg.','Mespilus prunifolia','Poiret nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23662','','','Crataegus crus-galli var. prunifolia Torrey & A. Gray','Crataegus crus-galli var. prunifolia','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28436','','','Crataegus × ninae-celottiae K.I. Christensen & T.A. Dickinson','Crataegus × ninae-celottiae','K.I. Christensen & T.A. Dickinson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24168','','','Crataegus sect. Douglasia Loudon','Crataegus sect. Douglasia','Loudon','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2407','','','Crataegus ser. Douglasianae Rehder','Crataegus ser. Douglasianae','Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20019','','','Crataegus gaylussacia A. Heller','Crataegus gaylussacia','A. Heller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8722','','','Crataegus suksdorfii (Sargent) Kruschke','Crataegus suksdorfii','(Sargent) Kruschke','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20017','','','Crataegus douglasii var. suksdorfii Sargent','Crataegus douglasii var. suksdorfii','Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20018','','','Crataegus punctata var. brevispina Douglas ex Hooker','Crataegus punctata var. brevispina','Douglas ex Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8704','','','Crataegus okennonii J.B. Phipps','Crataegus okennonii','J.B. Phipps','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9668','','','Crataegus shuswapensis J.B. Phipps & O''Kennon','Crataegus shuswapensis','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8655','','','Crataegus castlegarensis J.B. Phipps & O''Kennon','Crataegus castlegarensis','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8675','','','Crataegus douglasii Lindley','Crataegus douglasii','Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23976','','','Crataegus columbiana Howell','Crataegus columbiana','Howell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23977','','','Crataegus tennowana A. Nelson','Crataegus tennowana','A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2404','','','Crataegus ser. Purpureofructae J.B. Phipps & O''Kennon','Crataegus ser. Purpureofructae','J.B. Phipps & O''Kennon','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8703','','','Crataegus okanaganensis J.B. Phipps & O''Kennon','Crataegus okanaganensis','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8702','','','Crataegus okanaganensis var. okanaganensis J.B. Phipps & O''Kennon','Crataegus okanaganensis var. okanaganensis','J.B. Phipps & O''Kennon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23983','','','Crataegus okanaganensis var. wellsii J.B. Phipps & O''Kennon','Crataegus okanaganensis var. wellsii','J.B. Phipps & O''Kennon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9720','','','Crataegus cupressocollina J.B. Phipps & O''Kennon','Crataegus cupressocollina','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8705','','','Crataegus orbicularis J.B. Phipps & O''Kennon','Crataegus orbicularis','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8676','','','Crataegus enderbyensis J.B. Phipps & O''Kennon','Crataegus enderbyensis','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9721','','','Crataegus aquacervensis J.B. Phipps & O''Kennon','Crataegus aquacervensis','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8708','','','Crataegus phippsii O''Kennon','Crataegus phippsii','O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8651','','','Crataegus atrovirens J.B. Phipps & O''Kennon','Crataegus atrovirens','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24152','','','Crataegus sect. Macracanthae Loudon','Crataegus sect. Macracanthae','Loudon','','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2406','','','Crataegus ser. Macracanthae (Loudon) Rehder','Crataegus ser. Macracanthae','(Loudon) Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8693','','','Crataegus macracantha Loddiges ex Loudon','Crataegus macracantha','Loddiges ex Loudon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29887','','','Crataegus rhombifolia Sargent','Crataegus rhombifolia','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29889','','','Crataegus succulenta var. rhombifolia (Sargent) Eggleston','Crataegus succulenta var. rhombifolia','(Sargent) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29888','','','Crataegus macracantha var. rhombifolia (Sargent) Eggleston','Crataegus macracantha var. rhombifolia','(Sargent) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29110','','','Crataegus laneyi Sargent','Crataegus laneyi','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29111','','','Crataegus macracantha var. pertomentosa (Ashe) Kruschke','Crataegus macracantha var. pertomentosa','(Ashe) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29112','','','Crataegus pertomentosa Ashe','Crataegus pertomentosa','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29114','','','Mespilus macracantha (Loddiges ex Loudon) Wenzig','Mespilus macracantha','(Loddiges ex Loudon) Wenzig','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29113','','','Crataegus succulenta var. pertomentosa (Ashe) E.J. Palmer','Crataegus succulenta var. pertomentosa','(Ashe) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24153','','','Crataegus succulenta var. macracantha (Loddiges ex Loudon) Eggleston','Crataegus succulenta var. macracantha','(Loddiges ex Loudon) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25776','','','Crataegus integriloba Sargent','Crataegus integriloba','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21701','','','Crataegus divida Sargent','Crataegus divida','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19964','','','Crataegus columbiana var. occidentalis (Britton) Dorn','Crataegus columbiana var. occidentalis','(Britton) Dorn','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19965','','','Crataegus occidentalis Britton','Crataegus occidentalis','Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19962','','','Crataegus colorado Ashe','Crataegus colorado','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19963','','','Crataegus coloradensis A. Nelson','Crataegus coloradensis','A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19960','','','Crataegus praeclara Sargent','Crataegus praeclara','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19961','','','Crataegus prinoides Sargent','Crataegus prinoides','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19958','','','Crataegus microsperma Sargent','Crataegus microsperma','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19959','','','Crataegus paramoena Sargent','Crataegus paramoena','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19956','','','Crataegus flammea Sargent','Crataegus flammea','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19957','','','Crataegus fulgida Sargent','Crataegus fulgida','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19954','','','Crataegus ferentaria Sargent','Crataegus ferentaria','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19955','','','Crataegus fertilis Sargent','Crataegus fertilis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19952','','','Crataegus debilis Sargent','Crataegus debilis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19953','','','Crataegus delectabilis Sargent','Crataegus delectabilis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19950','','','Crataegus armigera Sargent','Crataegus armigera','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19951','','','Crataegus coccinea var. macracantha (Loddiges ex Loudon) Dudley','Crataegus coccinea var. macracantha','(Loddiges ex Loudon) Dudley','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19966','','','Crataegus succulenta var. occidentalis (Britton) E.J. Palmer','Crataegus succulenta var. occidentalis','(Britton) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9669','','','Crataegus macracantha var. divida (Sargent) Kruschke','Crataegus macracantha var. divida','(Sargent) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9718','','','Crataegus macracantha var. integriloba (Sargent) Kruschke','Crataegus macracantha var. integriloba','(Sargent) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8692','','','Crataegus macracantha var. macracantha Loddiges ex Loudon','Crataegus macracantha var. macracantha','Loddiges ex Loudon','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8694','','','Crataegus macracantha var. occidentalis (Britton) Eggleston','Crataegus macracantha var. occidentalis','(Britton) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9725','','','Crataegus rubribracteolata J.B. Phipps & O''Kennon','Crataegus rubribracteolata','J.B. Phipps & O''Kennon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8654','','','Crataegus calpodendron (Ehrhart) Medikus','Crataegus calpodendron','(Ehrhart) Medikus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23941','','','Crataegus calpodendron var. microcarpa (Chapman) E.J. Palmer','Crataegus calpodendron var. microcarpa','(Chapman) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23940','','','Crataegus calpodendron var. hispidula (Sargent) E.J. Palmer','Crataegus calpodendron var. hispidula','(Sargent) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23943','','','Crataegus calpodendron var. gigantea Kruschke nom. inval.','Crataegus calpodendron var. gigantea','Kruschke nom. inval.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23942','','','Crataegus calpodendron var. mollicula (Sargent) E.J. Palmer','Crataegus calpodendron var. mollicula','(Sargent) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23939','','','Crataegus calpodendron var. globosa (Sargent) E.J. Palmer','Crataegus calpodendron var. globosa','(Sargent) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19875','','','Crataegus hispidula Sargent','Crataegus hispidula','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19874','','','Crataegus globosa Sargent','Crataegus globosa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19877','','','Crataegus mollicula Sargent','Crataegus mollicula','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19876','','','Crataegus insperata Sargent','Crataegus insperata','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19879','','','Crataegus obscura Sargent','Crataegus obscura','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19878','','','Crataegus mollita Sargent','Crataegus mollita','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19881','','','Crataegus tomentosa var. microcarpa Chapman','Crataegus tomentosa var. microcarpa','Chapman','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19880','','','Crataegus spinulosa Sargent','Crataegus spinulosa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19873','','','Mespilus calpodendron Ehrhart','Mespilus calpodendron','Ehrhart','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9665','','','Crataegus sheridana A. Nelson','Crataegus sheridana','A. Nelson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8721','','','Crataegus succulenta Schrader ex Link','Crataegus succulenta','Schrader ex Link','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9719','','','Crataegus succulenta var. gemmosa (Sargent) Kruschke','Crataegus succulenta var. gemmosa','(Sargent) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21754','','','Crataegus gemmosa Sargent','Crataegus gemmosa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9670','','','Crataegus succulenta var. michiganensis (Ashe) E.J. Palmer','Crataegus succulenta var. michiganensis','(Ashe) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21702','','','Crataegus michiganensis Ashe','Crataegus michiganensis','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8720','','','Crataegus succulenta var. succulenta Schrader ex Link','Crataegus succulenta var. succulenta','Schrader ex Link','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29983','','','Crataegus membranacea Sargent','Crataegus membranacea','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20016','','','Crataegus vaga Sargent','Crataegus vaga','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2405','','','Crataegus ser. Anomalae (Sargent ex Eggleston) Rehder','Crataegus ser. Anomalae','(Sargent ex Eggleston) Rehder','SERIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8687','','','Crataegus × kingstonensis Sargent','Crataegus × kingstonensis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8715','','','Crataegus scabrida Sargent','Crataegus scabrida','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24164','','','Crataegus scabrida var. asperifolia (Sargent) Kruschke','Crataegus scabrida var. asperifolia','(Sargent) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24166','','','Crataegus brainerdii var. asperifolia (Sargent) Eggleston','Crataegus brainerdii var. asperifolia','(Sargent) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24165','','','Crataegus asperifolia Sargent','Crataegus asperifolia','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9672','','','Crataegus scabrida var. egglestonii (Sargent) Kruschke','Crataegus scabrida var. egglestonii','(Sargent) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21706','','','Crataegus scabrida var. honesta (Sargent) Kruschke','Crataegus scabrida var. honesta','(Sargent) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21705','','','Crataegus honesta Sargent','Crataegus honesta','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21704','','','Crataegus brainerdii var. egglestonii (Sargent) B.L. Robinson','Crataegus brainerdii var. egglestonii','(Sargent) B.L. Robinson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21703','','','Crataegus egglestonii Sargent','Crataegus egglestonii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9673','','','Crataegus scabrida var. cyclophylla (Sargent) Kruschke','Crataegus scabrida var. cyclophylla','(Sargent) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21708','','','Crataegus brainerdii var. cyclophylla (Sargent) E.J. Palmer','Crataegus brainerdii var. cyclophylla','(Sargent) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21707','','','Crataegus cyclophylla Sargent','Crataegus cyclophylla','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8714','','','Crataegus scabrida var. scabrida Sargent','Crataegus scabrida var. scabrida','Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20009','','','Crataegus brainerdii var. scabrida (Sargent) Eggleston','Crataegus brainerdii var. scabrida','(Sargent) Eggleston','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8678','','','Crataegus florifera Sargent','Crataegus florifera','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19924','','','Crataegus celsa Sargent','Crataegus celsa','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8653','','','Crataegus brainerdii Sargent','Crataegus brainerdii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9671','','','Crataegus × laurentiana Sargent','Crataegus × laurentiana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28519','','','Crataegus laurentiana var. dissimilifolia Kruschke','Crataegus laurentiana var. dissimilifolia','Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28517','','','Crataegus chrysocarpa var. fernaldii (Sargent) E.J. Palmer','Crataegus chrysocarpa var. fernaldii','(Sargent) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28518','','','Crataegus laurentiana var. brunetiana (Sargent) Kruschke','Crataegus laurentiana var. brunetiana','(Sargent) Kruschke','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28516','','','Crataegus brunetiana Sargent','Crataegus brunetiana','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21745','','','Crataegus brunetiana var. fernaldii (Sargent) E.J. Palmer','Crataegus brunetiana var. fernaldii','(Sargent) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9709','','','Crataegus × fernaldii Sargent','Crataegus × fernaldii','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8723','','','Crataegus × disperma Ashe','Crataegus × disperma','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31885','','','Crataegus × pausiaca Ashe','Crataegus × pausiaca','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28439','','','Crataegus punctata var. pausiaca (Ashe) E.J. Palmer','Crataegus punctata var. pausiaca','(Ashe) E.J. Palmer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28438','','','Crataegus peoriensis Sargent','Crataegus peoriensis','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28437','','','Crataegus cuneiformis (Marshall) Eggleston','Crataegus cuneiformis','(Marshall) Eggleston','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8682','','','Crataegus grandis Ashe','Crataegus grandis','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8701','','','Crataegus nitidula Sargent','Crataegus nitidula','Sargent','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('862','','','Aronia Medikus','Aronia','Medikus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8636','','','Aronia arbutifolia (Linnaeus) Persoon','Aronia arbutifolia','(Linnaeus) Persoon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23755','','','Aronia glabrescens Spach','Aronia glabrescens','Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19838','','','Mespilus arbutifolia Linnaeus','Mespilus arbutifolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19839','','','Pyrus arbutifolia (Linnaeus) Linnaeus f.','Pyrus arbutifolia','(Linnaeus) Linnaeus f.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19840','','','Sorbus arbutifolia (Linnaeus) Heynhold','Sorbus arbutifolia','(Linnaeus) Heynhold','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19841','','','Aronia pubens Spach','Aronia pubens','Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19837','','','Photinia pyrifolia (Lamarck) K.R. Robertson & J.B. Phipps','Photinia pyrifolia','(Lamarck) K.R. Robertson & J.B. Phipps','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19842','','','Aronia pumila M. Roemer','Aronia pumila','M. Roemer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19843','','','Aronia pyrifolia (Lamarck) Persoon','Aronia pyrifolia','(Lamarck) Persoon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19844','','','Crataegus pyrifolia Lamarck','Crataegus pyrifolia','Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19845','','','Halmia tomentosa var. pyrifolia (Lamarck) M. Roemer','Halmia tomentosa var. pyrifolia','(Lamarck) M. Roemer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8638','','','Aronia × prunifolia (Marshall) Rehder','Aronia × prunifolia','(Marshall) Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24673','','','Aronia floribunda (Lindley) Sweet','Aronia floribunda','(Lindley) Sweet','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24672','','','Adenorachis atropurpurea (Britton) Nieuwland','Adenorachis atropurpurea','(Britton) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24675','','','Pyrus melanocarpa var. atropurpurea (Britton) Farwell','Pyrus melanocarpa var. atropurpurea','(Britton) Farwell','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24674','','','Pyrus atropurpurea (Britton) L.H. Bailey','Pyrus atropurpurea','(Britton) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24671','','','Mespilus prunifolia Marshall','Mespilus prunifolia','Marshall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24676','','','Sorbus arbutifolia var. atropurpurea (Britton) C.K. Schneider','Sorbus arbutifolia var. atropurpurea','(Britton) C.K. Schneider','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19851','','','Photinia floribunda (Lindley) K.R. Robertson & Phipps','Photinia floribunda','(Lindley) K.R. Robertson & Phipps','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19852','','','Aronia atropurpurea Britton','Aronia atropurpurea','Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19853','','','Pyrus floribunda Lindley','Pyrus floribunda','Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19854','','','Aronia arbutifolia var. atropurpurea (Britton) F. Seymour','Aronia arbutifolia var. atropurpurea','(Britton) F. Seymour','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19855','','','Pyrus arbutifolia var. atropurpurea (Britton) B.L. Robinson','Pyrus arbutifolia var. atropurpurea','(Britton) B.L. Robinson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8637','','','Aronia melanocarpa (Michaux) Elliott','Aronia melanocarpa','(Michaux) Elliott','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30580','','','Pyrus arbutifolia var. melanocarpa (Michaux) Hooker','Pyrus arbutifolia var. melanocarpa','(Michaux) Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23754','','','Aronia nigra (Willdenow) Koehne','Aronia nigra','(Willdenow) Koehne','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19850','','','Sorbus melanocarpa (Michaux) Heynhold','Sorbus melanocarpa','(Michaux) Heynhold','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19846','','','Photinia melanocarpa (Michaux) K.R. Robertson & J.B. Phipps','Photinia melanocarpa','(Michaux) K.R. Robertson & J.B. Phipps','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19847','','','Mespilus arbutifolia var. melanocarpa Michaux','Mespilus arbutifolia var. melanocarpa','Michaux','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19848','','','Pyrus melanocarpa (Michaux) Willdenow','Pyrus melanocarpa','(Michaux) Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19849','','','Pyrus arbutifolia var. nigra Willdenow','Pyrus arbutifolia var. nigra','Willdenow','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1045','','','Cotoneaster Medikus','Cotoneaster','Medikus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('~7C','','','Cotoneaster (Cotoneaster)','Cotoneaster (Cotoneaster)','','UNRANKED','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9686','','','Cotoneaster franchetii Bois','Cotoneaster franchetii','Bois','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8645','','','Cotoneaster bullatus Bois','Cotoneaster bullatus','Bois','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9684','','','Cotoneaster divaricatus Rehder & E.H. Wilson','Cotoneaster divaricatus','Rehder & E.H. Wilson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24815','','','Cotoneaster dammeri C.K. Schneider','Cotoneaster dammeri','C.K. Schneider','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8644','','','Cotoneaster lucidus Schlechtendal','Cotoneaster lucidus','Schlechtendal','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19870','','','Cotoneaster acutifolius var. lucidus (Schlechtendal) L.T. Lu','Cotoneaster acutifolius var. lucidus','(Schlechtendal) L.T. Lu','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8649','','','Cotoneaster simonsii Baker','Cotoneaster simonsii','Baker','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33355','','','Cotoneaster hjelmqvistii Flinck & B. Hylmö','Cotoneaster hjelmqvistii','Flinck & B. Hylmö','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9687','','','Cotoneaster qungbixiensis J. Fryer & B. Hylmö','Cotoneaster qungbixiensis','J. Fryer & B. Hylmö','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9685','','','Cotoneaster rehderi Pojarkova','Cotoneaster rehderi','Pojarkova','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21711','','','Cotoneaster bullatus var. macrophyllus Rehder & E.H. Wilson','Cotoneaster bullatus var. macrophyllus','Rehder & E.H. Wilson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9688','','','Cotoneaster sternianus (Turrill) Boom','Cotoneaster sternianus','(Turrill) Boom','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21712','','','Cotoneaster franchetii var. sternianus Turrill','Cotoneaster franchetii var. sternianus','Turrill','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9689','','','Cotoneaster dielsianus E. Pritzel ex Diels','Cotoneaster dielsianus','E. Pritzel ex Diels','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8646','','','Cotoneaster horizontalis Decaisne','Cotoneaster horizontalis','Decaisne','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2051','','','Cotoneaster subgen. Cotoneaster','Cotoneaster subgen. Cotoneaster','','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33356','','','Cotoneaster × watereri Exell','Cotoneaster × watereri','Exell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8648','','','Cotoneaster racemiflorus (Desfontaines) K. Koch','Cotoneaster racemiflorus','(Desfontaines) K. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19872','','','Mespilus racemiflora Desfontaines','Mespilus racemiflora','Desfontaines','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27153','','','Cotoneaster laxiflorus Jacquin ex Lindley','Cotoneaster laxiflorus','Jacquin ex Lindley','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27149','','','Mespilus cotoneaster var. niger Wahlberg','Mespilus cotoneaster var. niger','Wahlberg','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27152','','','Cotoneaster peduncularis Boissier','Cotoneaster peduncularis','Boissier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27151','','','Cotoneaster orientalis A. Kerner','Cotoneaster orientalis','A. Kerner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27150','','','Cotoneaster vulgaris var. melanocarpus (Loddiges, G. Loddiges & W. Loddiges) Ledebour','Cotoneaster vulgaris var. melanocarpus','(Loddiges, G. Loddiges & W. Loddiges) Ledebour','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19871','','','Cotoneaster niger (Wahlberg) Fries','Cotoneaster niger','(Wahlberg) Fries','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8647','','','Cotoneaster melanocarpus Loddiges, G. Loddiges & W. Loddiges nom. illeg.','Cotoneaster melanocarpus','Loddiges, G. Loddiges & W. Loddiges nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2062','','','Cotoneaster subgen. Chaenopetalum (Koehne) G. Klotz','Cotoneaster subgen. Chaenopetalum','(Koehne) G. Klotz','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9679','','','Cotoneaster multiflorus Bunge','Cotoneaster multiflorus','Bunge','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9680','','','Cotoneaster salicifolius Franchet','Cotoneaster salicifolius','Franchet','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9682','','','Cotoneaster lacteus W.W. Smith','Cotoneaster lacteus','W.W. Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9683','','','Cotoneaster × suecicus G. Klotz','Cotoneaster × suecicus','G. Klotz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9681','','','Cotoneaster crispii Exell','Cotoneaster crispii','Exell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1700','','','Sorbus Linnaeus','Sorbus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8963','','','Sorbus americana Marshall','Sorbus americana','Marshall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20662','','','Sorbus micrantha Dumont de Courset','Sorbus micrantha','Dumont de Courset','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20663','','','Sorbus microcarpa Pursh','Sorbus microcarpa','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20661','','','Pyrus americana (Marshall) Sprengel','Pyrus americana','(Marshall) Sprengel','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20664','','','Sorbus riparia Rafinesque','Sorbus riparia','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8964','','','Sorbus aucuparia Linnaeus','Sorbus aucuparia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20666','','','Aucuparia sylvestris Medikus','Aucuparia sylvestris','Medikus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20667','','','Aucuparia subvestita (Greene) Nieuwland','Aucuparia subvestita','(Greene) Nieuwland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20665','','','Pyrus aucuparia (Linnaeus) Gaertner','Pyrus aucuparia','(Linnaeus) Gaertner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20669','','','Sorbus sibirica Hedlund','Sorbus sibirica','Hedlund','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8965','','','Sorbus decora (Sargent) C.K. Schneider','Sorbus decora','(Sargent) C.K. Schneider','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20672','','','Sorbus americana var. decora (Sargent) Sargent','Sorbus americana var. decora','(Sargent) Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20673','','','Pyrus decora (Sargent) Hyland','Pyrus decora','(Sargent) Hyland','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20671','','','Pyrus americana var. decora Sargent','Pyrus americana var. decora','Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20676','','','Sorbus decora var. groenlandica (C.K. Schneider) G.N. Jones','Sorbus decora var. groenlandica','(C.K. Schneider) G.N. Jones','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20677','','','Pyrus decora var. groenlandica (C.K. Schneider) Fernald','Pyrus decora var. groenlandica','(C.K. Schneider) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20674','','','Sorbus americana var. groenlandica C.K. Schneider','Sorbus americana var. groenlandica','C.K. Schneider','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20675','','','Sorbus groenlandica (C.K. Schneider) Á. Löve & D. Löve','Sorbus groenlandica','(C.K. Schneider) Á. Löve & D. Löve','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20678','','','Pyrus groenlandica (C.K. Schneider) K.R. Robertson','Pyrus groenlandica','(C.K. Schneider) K.R. Robertson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30610','','','Sorbus × splendida Hedlund','Sorbus × splendida','Hedlund','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30611','','','Sorbus americana × Sorbus aucuparia','Sorbus americana × Sorbus aucuparia','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8966','','','Sorbus scopulina Greene','Sorbus scopulina','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30558','','','Pyrus dumosa (Greene) Fernald','Pyrus dumosa','(Greene) Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20680','','','Sorbus angustifolia Rydberg','Sorbus angustifolia','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20681','','','Sorbus alaskana G.N. Jones nom. superfl.','Sorbus alaskana','G.N. Jones nom. superfl.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20679','','','Sorbus dumosa Greene','Sorbus dumosa','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20684','','','Sorbus scopulina var. cascadensis (G.N. Jones) C.L. Hitchcock','Sorbus scopulina var. cascadensis','(G.N. Jones) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20683','','','Sorbus cascadensis G.N. Jones','Sorbus cascadensis','G.N. Jones','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20682','','','Sorbus andersonii G.N. Jones','Sorbus andersonii','G.N. Jones','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8970','','','Sorbus hybrida Linnaeus','Sorbus hybrida','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20693','','','Pyrus hybrida (Linnaeus) Smith','Pyrus hybrida','(Linnaeus) Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20697','','','Pyrus pinnatifida Ehrhart','Pyrus pinnatifida','Ehrhart','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20696','','','Pyrus fennica (Kalm) Babington','Pyrus fennica','(Kalm) Babington','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20695','','','Sorbus fennica (Kalm) Fries','Sorbus fennica','(Kalm) Fries','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20694','','','Crataegus fennica Kalm','Crataegus fennica','Kalm','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20698','','','Sorbus auriculata Persoon','Sorbus auriculata','Persoon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8968','','','Sorbus sitchensis M. Roemer','Sorbus sitchensis','M. Roemer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8969','','','Sorbus sitchensis var. sitchensis M. Roemer','Sorbus sitchensis var. sitchensis','M. Roemer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30582','','','Sorbus sitchensis subsp. sitchensis M. Roemer','Sorbus sitchensis subsp. sitchensis','M. Roemer','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23919','','','Pyrus sitchensis (M. Roemer) Piper','Pyrus sitchensis','(M. Roemer) Piper','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23920','','','Sorbus americana var. sitchensis (M. Roemer) Sudworth','Sorbus americana var. sitchensis','(M. Roemer) Sudworth','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23921','','','Sorbus tilingii Gandoger','Sorbus tilingii','Gandoger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8967','','','Sorbus sitchensis var. grayi (Wenzig) C.L. Hitchcock','Sorbus sitchensis var. grayi','(Wenzig) C.L. Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20685','','','Sorbus sambucifolia var. grayi Wenzig','Sorbus sambucifolia var. grayi','Wenzig','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20689','','','Sorbus sambucifolia var. pumila (Rafinesque) Koehne','Sorbus sambucifolia var. pumila','(Rafinesque) Koehne','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20688','','','Pyrus sambucifolia var. pumila (Rafinesque) Sargent','Pyrus sambucifolia var. pumila','(Rafinesque) Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20687','','','Sorbus pumilus Rafinesque','Sorbus pumilus','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20686','','','Sorbus sitchensis subsp. grayi (Wenzig) Calder & Roy L. Taylor','Sorbus sitchensis subsp. grayi','(Wenzig) Calder & Roy L. Taylor','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20692','','','Sorbus occidentalis (S. Watson) Greene','Sorbus occidentalis','(S. Watson) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20691','','','Pyrus occidentalis S. Watson','Pyrus occidentalis','S. Watson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20690','','','Sorbus humifusa S. Watson nom. nud.','Sorbus humifusa','S. Watson nom. nud.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1608','','','Pyrus Linnaeus','Pyrus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8885','','','Pyrus communis Linnaeus','Pyrus communis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23848','','','Pyrus × amphigenea Domin ex Dostálek','Pyrus × amphigenea','Domin ex Dostálek','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23849','','','Pyrus caucasica Fedorov','Pyrus caucasica','Fedorov','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23851','','','Pyrus sativa de Candolle','Pyrus sativa','de Candolle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23850','','','Pyrus pyraster (Linnaeus) Du Roi','Pyrus pyraster','(Linnaeus) Du Roi','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1831','','','× Sorbaronia C.K. Schneider','× Sorbaronia','C.K. Schneider','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8991','','','× Sorbaronia arsenii (Britton ex L. Arsène) G.N. Jones','× Sorbaronia arsenii','(Britton ex L. Arsène) G.N. Jones','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20737','','','Pyrus arsenii (Britton ex L. Arsène) L. Arsène','Pyrus arsenii','(Britton ex L. Arsène) L. Arsène','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20738','','','Sorbus × arsenii Britton ex L. Arsène','Sorbus × arsenii','Britton ex L. Arsène','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8992','','','× Sorbaronia jackii Rehder','× Sorbaronia jackii','Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1062','','','Cydonia Miller','Cydonia','Miller','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8726','','','Cydonia oblonga Miller','Cydonia oblonga','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1392','','','Malus Miller','Malus','Miller','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29127','','','Malus toringo (Siebold) Siebold ex de Vriese','Malus toringo','(Siebold) Siebold ex de Vriese','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30579','','','Malus sieboldii var. arborescens Rehder','Malus sieboldii var. arborescens','Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27935','','','Crataegus taquetii H. Léveillé','Crataegus taquetii','H. Léveillé','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27936','','','Malus baccata subsp. toringo (K. Koch) Koidzumi','Malus baccata subsp. toringo','(K. Koch) Koidzumi','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27937','','','Malus sieboldii var. toringo (K. Koch) Siebold ex C. K. Schneider','Malus sieboldii var. toringo','(K. Koch) Siebold ex C. K. Schneider','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27938','','','Malus sargentii Rehder','Malus sargentii','Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27939','','','Photinia rubrolutea H. Léveillé','Photinia rubrolutea','H. Léveillé','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27940','','','Pyrus esquirolii H. Léveillé & Vaniot','Pyrus esquirolii','H. Léveillé & Vaniot','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27941','','','Pyrus subcrataegifolia H. Léveillé','Pyrus subcrataegifolia','H. Léveillé','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27942','','','Sorbus toringo K. Koch','Sorbus toringo','K. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27932','','','Malus sieboldii (Regel) Rehder nom. illeg.','Malus sieboldii','(Regel) Rehder nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27933','','','Pyrus sieboldii Regel & Tiling nom. illeg.','Pyrus sieboldii','Regel & Tiling nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27934','','','Crataegus cavaleriei H. Léveillé & Vaniot','Crataegus cavaleriei','H. Léveillé & Vaniot','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20142','','','Malus domestica (Suckow) Borkhausen nom. cons.','Malus domestica','(Suckow) Borkhausen nom. cons.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30169','','','Malus malus (Linnaeus) Britton nom. illeg.','Malus malus','(Linnaeus) Britton nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32705','','','Pyrus malus var. domestica Suckow','Pyrus malus var. domestica','Suckow','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20146','','','Pyrus malus var. paradisiaca Linnaeus','Pyrus malus var. paradisiaca','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20145','','','Malus communis Poiret nom. illeg.','Malus communis','Poiret nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20143','','','Malus sylvestris Miller','Malus sylvestris','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20141','','','Pyrus malus Linnaeus','Pyrus malus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8790','','','Malus pumila Miller','Malus pumila','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8787','','','Malus coronaria (Linnaeus) Miller','Malus coronaria','(Linnaeus) Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30577','','','Malus angustifolia var. puberula (Rehder) Rehder','Malus angustifolia var. puberula','(Rehder) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30578','','','Malus platycarpa var. hoopesii (Rehder) Rehder','Malus platycarpa var. hoopesii','(Rehder) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20132','','','Pyrus coronaria var. lancifolia (Rehder) Fernald','Pyrus coronaria var. lancifolia','(Rehder) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20130','','','Pyrus coronaria var. dasycalyx (Rehder) Fernald','Pyrus coronaria var. dasycalyx','(Rehder) Fernald','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20131','','','Pyrus coronaria var. elongata (Rehder) L.H. Bailey','Pyrus coronaria var. elongata','(Rehder) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20128','','','Malus platycarpa Rehder','Malus platycarpa','Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20129','','','Pyrus bracteata (Rehder) L.H. Bailey','Pyrus bracteata','(Rehder) L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20126','','','Malus glaucescens Rehder','Malus glaucescens','Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20127','','','Malus lancifolia Rehder','Malus lancifolia','Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20115','','','Malus coronaria var. glabrata (Rehder) Likhonos','Malus coronaria var. glabrata','(Rehder) Likhonos','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20116','','','Malus coronaria var. glaucescens (Rehder) Likhonos','Malus coronaria var. glaucescens','(Rehder) Likhonos','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20113','','','Malus coronaria var. dasycalyx Rehder','Malus coronaria var. dasycalyx','Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20114','','','Malus coronaria var. elongata (Rehder) Rehder','Malus coronaria var. elongata','(Rehder) Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20111','','','Malus carolinensis Ashe','Malus carolinensis','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20112','','','Malus coronaria var. bracteata (Rehder) Likhonos','Malus coronaria var. bracteata','(Rehder) Likhonos','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20109','','','Pyrus coronaria Linnaeus','Pyrus coronaria','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20110','','','Malus bracteata Rehder','Malus bracteata','Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20124','','','Malus fragrans Rehder','Malus fragrans','Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20125','','','Malus glabrata Rehder','Malus glabrata','Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20121','','','Malus coronaria var. puberula Rehder','Malus coronaria var. puberula','Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20123','','','Malus elongata (Rehder) Ashe','Malus elongata','(Rehder) Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20119','','','Malus coronaria var. platycarpa (Rehder) Likhonos','Malus coronaria var. platycarpa','(Rehder) Likhonos','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20120','','','Malus coronaria var. plena C.K. Schneider','Malus coronaria var. plena','C.K. Schneider','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20117','','','Malus coronaria var. hoopesii Rehder','Malus coronaria var. hoopesii','Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20118','','','Malus coronaria var. lancifolia (Rehder) C.F. Reed','Malus coronaria var. lancifolia','(Rehder) C.F. Reed','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8786','','','Malus baccata (Linnaeus) Borkhausen','Malus baccata','(Linnaeus) Borkhausen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20108','','','Pyrus baccata Linnaeus','Pyrus baccata','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8789','','','Malus prunifolia (Willdenow) Borkhausen','Malus prunifolia','(Willdenow) Borkhausen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20140','','','Pyrus prunifolia Willdenow','Pyrus prunifolia','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8788','','','Malus fusca (Rafinesque) C.K. Schneider','Malus fusca','(Rafinesque) C.K. Schneider','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20138','','','Pyrus diversifolia Bongard','Pyrus diversifolia','Bongard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20139','','','Pyrus rivularis Douglas','Pyrus rivularis','Douglas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20136','','','Malus fusca var. levipes (Nuttall) C.K. Schneider','Malus fusca var. levipes','(Nuttall) C.K. Schneider','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20137','','','Malus rivularis (Douglas) M. Roemer','Malus rivularis','(Douglas) M. Roemer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20134','','','Malus diversifolia (Bongard) M. Roemer','Malus diversifolia','(Bongard) M. Roemer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20135','','','Malus fusca var. diversifolia (Bongard) C.K. Schneider','Malus fusca var. diversifolia','(Bongard) C.K. Schneider','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20133','','','Pyrus fusca Rafinesque','Pyrus fusca','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1923','','','Pyracantha M. Roemer','Pyracantha','M. Roemer','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33359','','','Pyracantha fortuneana (Maximowicz) H. L. Li','Pyracantha fortuneana','(Maximowicz) H. L. Li','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33363','','','Pyracantha rogersiana (A.B. Jackson) Bean','Pyracantha rogersiana','(A.B. Jackson) Bean','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33364','','','Pyracantha yunnanensis (M. Vilmorin ex Mottet) Chittenden','Pyracantha yunnanensis','(M. Vilmorin ex Mottet) Chittenden','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33361','','','Pyracantha crenatoserrata (Hance) Rehder','Pyracantha crenatoserrata','(Hance) Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33362','','','Pyracantha crenulata var. rogersiana A.B. Jackson','Pyracantha crenulata var. rogersiana','A.B. Jackson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33360','','','Photinia fortuneana Maximowicz','Photinia fortuneana','Maximowicz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8884','','','Pyracantha coccinea M. Roemer','Pyracantha coccinea','M. Roemer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20295','','','Cotoneaster pyracantha (Linnaeus) Spach','Cotoneaster pyracantha','(Linnaeus) Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20293','','','Crataegus pyracantha (Linnaeus) Medikus','Crataegus pyracantha','(Linnaeus) Medikus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20294','','','Mespilus pyracantha Linnaeus','Mespilus pyracantha','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1876','','','Chaenomeles Lindley','Chaenomeles','Lindley','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8641','','','Chaenomeles japonica (Thunberg) Lindley ex Spach','Chaenomeles japonica','(Thunberg) Lindley ex Spach','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19858','','','Cydonia japonica (Thunberg) Persoon','Cydonia japonica','(Thunberg) Persoon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19857','','','Pyrus japonica Thunberg','Pyrus japonica','Thunberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31882','','','Scandosorbus Sennikov','Scandosorbus','Sennikov','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31883','','','Scandosorbus intermedia (Ehrhart) Sennikov','Scandosorbus intermedia','(Ehrhart) Sennikov','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27863','','','Pyrus intermedia Ehrhart','Pyrus intermedia','Ehrhart','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27862','','','Sorbus intermedia (Ehrhart) Persoon','Sorbus intermedia','(Ehrhart) Persoon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33357','','','Aria (Persoon) Host','Aria','(Persoon) Host','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33358','','','Aria edulis (Willdenow) M. Roemer','Aria edulis','(Willdenow) M. Roemer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('661','','','Amygdaleae de Candolle','Amygdaleae','de Candolle','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1593','','','Prunus Linnaeus','Prunus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8858','','','Prunus americana Marshall','Prunus americana','Marshall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8859','','','Prunus avium (Linnaeus) Linnaeus','Prunus avium','(Linnaeus) Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20264','','','Prunus cerasus var. avium Linnaeus','Prunus cerasus var. avium','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8860','','','Prunus cerasifera Ehrhart','Prunus cerasifera','Ehrhart','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8861','','','Prunus cerasus Linnaeus','Prunus cerasus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8864','','','Prunus emarginata (Douglas) Eaton','Prunus emarginata','(Douglas) Eaton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20271','','','Prunus pensylvanica var. mollis (Douglas) B. Boivin','Prunus pensylvanica var. mollis','(Douglas) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20270','','','Prunus emarginata var. mollis (Douglas) W.H. Brewer','Prunus emarginata var. mollis','(Douglas) W.H. Brewer','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20269','','','Prunus emarginata var. crenulata (Greene) Kearney & Peebles','Prunus emarginata var. crenulata','(Greene) Kearney & Peebles','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20268','','','Cerasus emarginata Douglas','Cerasus emarginata','Douglas','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8865','','','Prunus glandulosa Thunberg','Prunus glandulosa','Thunberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8866','','','Prunus laurocerasus Linnaeus','Prunus laurocerasus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8867','','','Prunus mahaleb Linnaeus','Prunus mahaleb','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8868','','','Prunus maritima Marshall','Prunus maritima','Marshall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20273','','','Prunus maritima var. gravesii (Small) G.J. Anderson','Prunus maritima var. gravesii','(Small) G.J. Anderson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20272','','','Prunus gravesii Small','Prunus gravesii','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8869','','','Prunus nigra Aiton','Prunus nigra','Aiton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29975','','','Prunus lusitanica Linnaeus','Prunus lusitanica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28716','','','Prunus × cistena N. E. Hansen ex Koehne','Prunus × cistena','N. E. Hansen ex Koehne','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27973','','','Prunus armeniaca Linnaeus','Prunus armeniaca','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27974','','','Armeniaca vulgaris Lamarck','Armeniaca vulgaris','Lamarck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26476','','','Prunus × pugetensis Jacobson & Zika','Prunus × pugetensis','Jacobson & Zika','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8876','','','Prunus serotina Ehrhart','Prunus serotina','Ehrhart','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24772','','','Prunus serotina var. serotina Ehrhart','Prunus serotina var. serotina','Ehrhart','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31518','','','Cerasus serotina (Ehrhart) Loiseleur-Deslongchamps','Cerasus serotina','(Ehrhart) Loiseleur-Deslongchamps','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31519','','','Padus serotina (Ehrhart) Borkhausen','Padus serotina','(Ehrhart) Borkhausen','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24774','','','Prunus serotina var. eximia (Small) Little','Prunus serotina var. eximia','(Small) Little','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24773','','','Prunus serotina subsp. eximia (Small) McVaugh','Prunus serotina subsp. eximia','(Small) McVaugh','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24776','','','Padus eximia (Small) Small','Padus eximia','(Small) Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24775','','','Prunus eximia Small','Prunus eximia','Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23875','','','Padus virginiana Miller','Padus virginiana','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8875','','','Prunus serotina subsp. serotina Ehrhart','Prunus serotina subsp. serotina','Ehrhart','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8863','','','Prunus domestica Linnaeus','Prunus domestica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20267','','','Prunus insititia Linnaeus','Prunus insititia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20266','','','Prunus domestica var. insititia (Linnaeus) Fiori & Paoletti','Prunus domestica var. insititia','(Linnaeus) Fiori & Paoletti','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20265','','','Prunus domestica subsp. insititia (Linnaeus) C. K. Schneider','Prunus domestica subsp. insititia','(Linnaeus) C. K. Schneider','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8862','','','Prunus domestica subsp. domestica Linnaeus','Prunus domestica subsp. domestica','Linnaeus','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8881','','','Prunus virginiana Linnaeus','Prunus virginiana','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8882','','','Prunus virginiana var. virginiana Linnaeus','Prunus virginiana var. virginiana','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31517','','','Cerasus virginiana (Linnaeus) Michaux','Cerasus virginiana','(Linnaeus) Michaux','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26916','','','Prunus canadensis Linnaeus','Prunus canadensis','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20292','','','Prunus virginiana var. deamii (G.N. Jones) B. Boivin','Prunus virginiana var. deamii','(G.N. Jones) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8880','','','Prunus virginiana var. demissa (Nuttall) Torrey','Prunus virginiana var. demissa','(Nuttall) Torrey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20287','','','Prunus demissa var. melanocarpa (A. Nelson) A. Nelson','Prunus demissa var. melanocarpa','(A. Nelson) A. Nelson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20288','','','Prunus melanocarpa (A. Nelson) Rydberg','Prunus melanocarpa','(A. Nelson) Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20285','','','Prunus demissa (Nuttall) D. Dietrich','Prunus demissa','(Nuttall) D. Dietrich','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20286','','','Prunus demissa subsp. demissa (Nuttall) D. Dietrich','Prunus demissa subsp. demissa','(Nuttall) D. Dietrich','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20283','','','Cerasus demissa Nuttall','Cerasus demissa','Nuttall','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20284','','','Cerasus demissa var. melanocarpa A. Nelson','Cerasus demissa var. melanocarpa','A. Nelson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20291','','','Prunus virginiana var. melanocarpa (A. Nelson) Sargent','Prunus virginiana var. melanocarpa','(A. Nelson) Sargent','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20289','','','Prunus virginiana subsp. demissa (Nuttall) Roy L. Taylor & MacBride','Prunus virginiana subsp. demissa','(Nuttall) Roy L. Taylor & MacBride','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20290','','','Prunus virginiana subsp. melanocarpa (A. Nelson) Roy L. Taylor & MacBride','Prunus virginiana subsp. melanocarpa','(A. Nelson) Roy L. Taylor & MacBride','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8879','','','Prunus tomentosa Thunberg','Prunus tomentosa','Thunberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8874','','','Prunus pumila Linnaeus','Prunus pumila','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9656','','','Prunus pumila var. pumila Linnaeus','Prunus pumila var. pumila','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20280','','','Prunus pumila var. susquehanae (Willdenow) H. Jaeger','Prunus pumila var. susquehanae','(Willdenow) H. Jaeger','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20281','','','Prunus cuneata Rafinesque','Prunus cuneata','Rafinesque','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20282','','','Prunus pumila var. cuneata (Rafinesque) L.H. Bailey','Prunus pumila var. cuneata','(Rafinesque) L.H. Bailey','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8878','','','Prunus susquehanae Willdenow','Prunus susquehanae','Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8873','','','Prunus pumila var. depressa (Pursh) Bean','Prunus pumila var. depressa','(Pursh) Bean','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20279','','','Prunus depressa Pursh','Prunus depressa','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9655','','','Prunus pumila var. besseyi (L.H. Bailey) Waugh','Prunus pumila var. besseyi','(L.H. Bailey) Waugh','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21678','','','Prunus besseyi L.H. Bailey','Prunus besseyi','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8872','','','Prunus persica (Linnaeus) Batsch','Prunus persica','(Linnaeus) Batsch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20278','','','Persica vulgaris Miller','Persica vulgaris','Miller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20277','','','Amygdalus persica Linnaeus','Amygdalus persica','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8877','','','Prunus spinosa Linnaeus','Prunus spinosa','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8870','','','Prunus padus Linnaeus','Prunus padus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8871','','','Prunus pensylvanica Linnaeus f.','Prunus pensylvanica','Linnaeus f.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25607','','','Prunus pensylvanica subsp. pensylvanica Linnaeus f.','Prunus pensylvanica subsp. pensylvanica','Linnaeus f.','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23874','','','Prunus pensylvanica subsp. corymbulosa (Rydberg) W. Wight','Prunus pensylvanica subsp. corymbulosa','(Rydberg) W. Wight','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20276','','','Prunus corymbulosa Rydberg','Prunus corymbulosa','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20275','','','Prunus pensylvanica var. saximontana Rehder','Prunus pensylvanica var. saximontana','Rehder','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20274','','','Prunus pensylvanica var. pensylvanica Linnaeus f.','Prunus pensylvanica var. pensylvanica','Linnaeus f.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('635','','','Osmaronieae Rydberg','Osmaronieae','Rydberg','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1472','','','Oemleria Reichenbach','Oemleria','Reichenbach','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8791','','','Oemleria cerasiformis (Torrey & A. Gray ex Hooker & Arnott) J.W. Landon','Oemleria cerasiformis','(Torrey & A. Gray ex Hooker & Arnott) J.W. Landon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20149','','','Osmaronia cerasiformis var. lancifolia Greene','Osmaronia cerasiformis var. lancifolia','Greene','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20148','','','Osmaronia cerasiformis (Torrey & A. Gray ex Hooker & Arnott) Greene','Osmaronia cerasiformis','(Torrey & A. Gray ex Hooker & Arnott) Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20147','','','Nuttallia cerasiformis Torrey & Gray ex Hooker & Arnott','Nuttallia cerasiformis','Torrey & Gray ex Hooker & Arnott','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('646','','','Neillieae Maximowicz','Neillieae','Maximowicz','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1544','','','Physocarpus (Cambessèdes) Rafinesque','Physocarpus','(Cambessèdes) Rafinesque','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8792','','','Physocarpus capitatus (Pursh) Kuntze','Physocarpus capitatus','(Pursh) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20151','','','Spiraea capitata Pursh','Spiraea capitata','Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20150','','','Physocarpus opulifolius var. tomentellus (Seringe) B. Boivin','Physocarpus opulifolius var. tomentellus','(Seringe) B. Boivin','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8793','','','Physocarpus malvaceus (Greene) Kuntze','Physocarpus malvaceus','(Greene) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24009','','','Spiraea opulifolia var. pauciflora Torrey & A. Gray','Spiraea opulifolia var. pauciflora','Torrey & A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24008','','','Physocarpus pauciflorus (Torrey & A. Gray) Piper','Physocarpus pauciflorus','(Torrey & A. Gray) Piper','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24007','','','Opulaster pauciflorus (Torrey & A. Gray) A. Heller','Opulaster pauciflorus','(Torrey & A. Gray) A. Heller','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20152','','','Neillia malvacea Greene','Neillia malvacea','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8794','','','Physocarpus opulifolius (Linnaeus) Maximowicz','Physocarpus opulifolius','(Linnaeus) Maximowicz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25573','','','Physocarpus opulifolius var. opulifolius (Linnaeus) Maximowicz','Physocarpus opulifolius var. opulifolius','(Linnaeus) Maximowicz','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20158','','','Opulaster stellatus Rydberg ex Small','Opulaster stellatus','Rydberg ex Small','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20157','','','Opulaster opulifolius (Linnaeus) Kuntze','Opulaster opulifolius','(Linnaeus) Kuntze','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20156','','','Opulaster australis Rydberg','Opulaster australis','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20155','','','Opulaster alabamensis Rydberg','Opulaster alabamensis','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20154','','','Spiraea opulifolia Linnaeus','Spiraea opulifolia','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9746','','','Physocarpus intermedius (Rydberg) C.K. Schneider','Physocarpus intermedius','(Rydberg) C.K. Schneider','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21759','','','Physocarpus opulifolius var. intermedius (Rydberg) B.L. Robinson','Physocarpus opulifolius var. intermedius','(Rydberg) B.L. Robinson','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21758','','','Opulaster intermedius Rydberg','Opulaster intermedius','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('579','','','Spiraeeae de Candolle','Spiraeeae','de Candolle','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1864','','','Aruncus Linnaeus','Aruncus','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8640','','','Aruncus dioicus (Walter) Fernald','Aruncus dioicus','(Walter) Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8639','','','Aruncus dioicus var. acuminatus (Rydberg) H. Hara','Aruncus dioicus var. acuminatus','(Rydberg) H. Hara','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19856','','','Aruncus acuminatus Rydberg','Aruncus acuminatus','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9762','','','Aruncus dioicus var. vulgaris (Maximowicz) H. Hara','Aruncus dioicus var. vulgaris','(Maximowicz) H. Hara','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23756','','','Aruncus sylvester Kosteletzky ex Maximowicz','Aruncus sylvester','Kosteletzky ex Maximowicz','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21797','','','Spiraea aruncus Linnaeus','Spiraea aruncus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21796','','','Aruncus sylvester var. vulgaris Maximowicz','Aruncus sylvester var. vulgaris','Maximowicz','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1711','','','Spiraea Linnaeus','Spiraea','Linnaeus','GENUS','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8983','','','Spiraea splendens Baumann ex K. Koch','Spiraea splendens','Baumann ex K. Koch','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9767','','','Spiraea splendens var. rosea (A. Gray) Kartesz & Gandhi','Spiraea splendens var. rosea','(A. Gray) Kartesz & Gandhi','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21804','','','Spiraea helleri Rydberg','Spiraea helleri','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21805','','','Spiraea lucida var. rosea (A. Gray) Greene','Spiraea lucida var. rosea','(A. Gray) Greene','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21802','','','Spiraea arbuscula Greene','Spiraea arbuscula','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21803','','','Spiraea betulifolia var. rosea A. Gray','Spiraea betulifolia var. rosea','A. Gray','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20726','','','Spiraea densiflora Nuttall ex Rydberg, nom. illeg.','Spiraea densiflora','Nuttall ex Rydberg, nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8982','','','Spiraea splendens var. splendens Baumann ex K. Koch','Spiraea splendens var. splendens','Baumann ex K. Koch','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23701','','','Spiraea densiflora subsp. splendens (Baumann ex K. Koch) Abrams','Spiraea densiflora subsp. splendens','(Baumann ex K. Koch) Abrams','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20727','','','Spiraea densiflora var. splendens (Baumann ex K. Koch) Hitchcock','Spiraea densiflora var. splendens','(Baumann ex K. Koch) Hitchcock','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8987','','','Spiraea tomentosa Linnaeus','Spiraea tomentosa','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8986','','','Spiraea tomentosa var. tomentosa Linnaeus','Spiraea tomentosa var. tomentosa','Linnaeus','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','','','','','','',NULL,'','','','','');
INSERT INTO name 