PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE version (id TEXT NOT NULL) STRICT;
INSERT INTO version VALUES('v0.3.33');
CREATE TABLE metadata (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__doi TEXT DEFAULT '',
  col__title TEXT NOT NULL,
  col__alias TEXT DEFAULT '',
  col__description TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__version TEXT DEFAULT '',
  col__keywords TEXT DEFAULT '',
  col__geographic_scope TEXT DEFAULT '',
  col__taxonomic_scope TEXT DEFAULT '',
  col__temporal_scope TEXT DEFAULT '',
  col__confidence INTEGER DEFAULT NULL,
  col__completeness INTEGER DEFAULT NULL,
  col__license TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__logo TEXT DEFAULT '',
  col__label TEXT DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__private INTEGER DEFAULT NULL -- bool 
) STRICT;
INSERT INTO metadata VALUES(1,'','Database of Vascular Plants of Canada (VASCAN)','',unistr('The Database of Vascular Plants of Canada or VASCAN (http://data.canadensys.net/vascan) is a comprehensive and curated checklist of all vascular plants reported in Canada, Greenland (Denmark), and Saint Pierre and Miquelon (France). VASCAN was developed at the Université de Montréal Biodiversity Centre and is maintained by a group of editors and contributors. For every core taxon in the checklist (species, subspecies, or variety), VASCAN provides the accepted scientific name, the accepted French and English vernacular names, and their synonyms/alternatives in Canada, as well as the distribution status (native, introduced, ephemeral, excluded, extirpated, doubtful or absent) of the plant for each province or territory, and the habit (tree, shrub, herb and/or vine) of the plant in Canada. For reported hybrids (nothotaxa or hybrid formulas) VASCAN also provides the hybrid parents, except if the parents of the hybrid do not occur in Canada. All taxa are linked to a classification. VASCAN refers to a source for all name, classification and distribution information.\u000a\u000aAll data have been released to the public domain under a CC0 waiver and are available through Canadensys and the Global Biodiversity Information Facility (GBIF). VASCAN is a service to the scientific community and the general public, including administrations, companies, and non-governmental organizations.'),'','','','','','',0,0,'','','','','',0);
CREATE TABLE contact (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT NOT NULL,
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
INSERT INTO contact VALUES(1,1,'','Luc','Brouillet','','','Université de Montréal Biodiversity Centre','','','','luc.brouillet@umontreal.ca','','');
CREATE TABLE editor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE creator (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
INSERT INTO creator VALUES(1,1,'','Luc','Brouillet','','','Université de Montréal Biodiversity Centre','','','','luc.brouillet@umontreal.ca','','');
CREATE TABLE publisher (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT DEFAULT '',
  col__family TEXT DEFAULT '',
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE contributor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE source (
  col__id TEXT PRIMARY KEY,
  col__metadata_id INTEGER DEFAULT 1,
  col__type TEXT DEFAULT '',
  col__title TEXT DEFAULT '',
  col__authors TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__isbn TEXT DEFAULT ''
) STRICT;
CREATE TABLE author (
  col__id TEXT PRIMARY KEY,
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__alternative_id TEXT DEFAULT '', -- sep by ','
  col__given TEXT DEFAULT '',
  col__family TEXT NOT NULL,
  -- f. for filius,  Jr., etc
  col__suffix TEXT DEFAULT '',
  col__abbreviation_botany TEXT DEFAULT '',
  col__alternative_names TEXT DEFAULT '', -- separated by '|'
  col__sex_id TEXT REFERENCES sex DEFAULT '',
  col__country TEXT DEFAULT '',
  col__birth TEXT DEFAULT '',
  col__birth_place TEXT DEFAULT '',
  col__death TEXT DEFAULT '',
  col__affiliation TEXT DEFAULT '',
  col__interest TEXT DEFAULT '',
  col__reference_id TEXT DEFAULT '', -- sep by ','
  -- url
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE reference (
  col__id TEXT PRIMARY KEY,
  col__alternative_id TEXT DEFAULT '', -- sep by ',', scope:id, id, URI/URN
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__type_id TEXT REFERENCES reference_type DEFAULT '',
  -- author/s in format of either
  -- family1, given1; family2, given2; ..
  -- or
  -- given1 family1, given2 family2, ...
  col__author TEXT DEFAULT '',
  col__author_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__title TEXT DEFAULT '',
  col__title_short TEXT DEFAULT '',
  -- container_author is an author or a parent volume (book, journal) 
  col__container_author TEXT DEFAULT '',
  -- container_title of the parent container
  col__container_title TEXT DEFAULT '',
  -- container_title_short of the parent container
  col__container_title_short TEXT DEFAULT '',
  col__issued TEXT DEFAULT '', -- yyyy-mm-dd
  col__accessed TEXT DEFAULT '', -- yyyy-mm-dd
  -- collection_title of the parent volume
  col__collection_title TEXT DEFAULT '',
  -- collection_editor of the parent volume
  col__collection_editor TEXT DEFAULT '',
  col__volume TEXT DEFAULT '',
  col__issue TEXT DEFAULT '',
  -- edition number
  col__edition TEXT DEFAULT '',
  -- page number
  col__page TEXT DEFAULT '',
  col__publisher TEXT DEFAULT '',
  col__publisher_place TEXT DEFAULT '',
  -- version of the reference
  col__version TEXT DEFAULT '',
  col__isbn TEXT DEFAULT '',
  col__issn TEXT DEFAULT '',
  col__doi TEXT DEFAULT '',
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE name (
  col__id TEXT PRIMARY KEY,
  col__alternative_id TEXT DEFAULT '',
  col__source_id TEXT DEFAULT '',
  -- basionym_id TEXT DEFAULT '', -- use name_relation instead
  gn__scientific_name_string TEXT NOT NULL, -- full name with authorship (if given)
  gn__parse_quality INTEGER DEFAULT NULL,
  gn__canonical_simple TEXT DEFAULT '',
  gn__canonical_full TEXT DEFAULT '',
  gn__canonical_stemmed TEXT DEFAULT '',
  gn__cardinality INTEGER DEFAULT NULL,
  gn__virus INTEGER DEFAULT NULL, -- bool
  gn__hybrid TEXT DEFAULT '',
  gn__surrogate TEXT DEFAULT '',
  gn__authors TEXT DEFAULT '', -- separated by '|'
  gn__id TEXT DEFAULT '', -- UUID v5 generated for GN from name-string
  col__scientific_name TEXT NOT NULL, -- full canonical form
  col__authorship TEXT DEFAULT '', -- verbatim authorship
  col__rank_id TEXT REFERENCES rank DEFAULT '',
  col__uninomial TEXT DEFAULT '',
  col__genus TEXT DEFAULT '',
  col__infrageneric_epithet TEXT DEFAULT '',
  col__specific_epithet TEXT DEFAULT '',
  col__infraspecific_epithet TEXT DEFAULT '',
  col__cultivar_epithet TEXT DEFAULT '',
  col__notho_id TEXT DEFAULT '', -- ref name_part
  col__original_spelling INTEGER DEFAULT NULL, -- bool
  col__combination_authorship TEXT DEFAULT '', -- separated by '|'
  col__combination_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__combination_ex_authorship TEXT DEFAULT '', -- separated by '|'
  col__combination_ex_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__combination_authorship_year TEXT DEFAULT '',
  col__basionym_authorship TEXT DEFAULT '', -- separated by '|'
  col__basionym_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__basionym_ex_authorship TEXT DEFAULT '', -- separated by '|'
  col__basionym_ex_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__basionym_authorship_year TEXT DEFAULT '',
  col__code_id TEXT REFERENCES nom_code DEFAULT '',
  col__status_id TEXT REFERENCES nom_status DEFAULT '',
  col__reference_id TEXT DEFAULT '', -- refs about taxon sep ','
  col__published_in_year TEXT DEFAULT '',
  col__published_in_page TEXT DEFAULT '',
  col__published_in_page_link TEXT DEFAULT '',
  col__gender_id TEXT REFERENCES gender DEFAULT '',
  col__gender_agreement INTEGER DEFAULT NULL, -- bool
  col__etymology TEXT DEFAULT '',
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
INSERT INTO name VALUES('25','','','Equisetales de Candolle ex Berchtold & J. Presl',2,'Equisetales','Equisetales','Equisetales',1,0,'','','de Candolle|Berchtold|J. Presl','b9a2946f-a396-5d12-8ab9-29dae1433e81','Equisetales de Candolle ex Berchtold & J. Presl','de Candolle ex Berchtold & J. Presl','ORDER','Equisetales','','','','','','',NULL,'','','','','','de Candolle','','Berchtold & J. Presl','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6222','','','Isoetes occidentalis L.F. Henderson',1,'Isoetes occidentalis','Isoetes occidentalis','Isoetes occidental',2,0,'','','L. F. Henderson','d776565e-2326-545f-9b0f-27a7ffefbd07','Isoetes occidentalis L.F. Henderson','L.F. Henderson','SPECIES','','Isoetes','','occidentalis','','','',NULL,'','','','','','L. F. Henderson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31971','','','Isoetes tuckermanii A. Braun ex Engelmann subsp. tuckermanii',2,'Isoetes tuckermanii tuckermanii','Isoetes tuckermanii subsp. tuckermanii','Isoetes tuckerman tuckerman',3,0,'','','','a783f8eb-fdf8-513c-a36a-439540588560','Isoetes tuckermanii A. Braun ex Engelmann subsp. tuckermanii','A. Braun ex Engelmann','SUBSPECIES','','Isoetes','','tuckermanii','tuckermanii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6233','','','Isoetes ×pseudotruncata D.M. Britton & D.F. Brunton',3,'','','',NULL,NULL,'','','','','Isoetes ×pseudotruncata D.M. Britton & D.F. Brunton','D.M. Britton & D.F. Brunton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29176','','','Isoetes septentrionalis D.F. Brunton',1,'Isoetes septentrionalis','Isoetes septentrionalis','Isoetes septentrional',2,0,'','','D. F. Brunton','c79f64e0-393a-5f23-a4ec-040bb9b15d4f','Isoetes septentrionalis D.F. Brunton','D.F. Brunton','SPECIES','','Isoetes','','septentrionalis','','','',NULL,'','','','','','D. F. Brunton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6220','','','Isoetes minima A.A. Eaton',1,'Isoetes minima','Isoetes minima','Isoetes minim',2,0,'','','A. A. Eaton','a43b5672-d70b-5d2c-bce9-07ab0f70bd78','Isoetes minima A.A. Eaton','A.A. Eaton','SPECIES','','Isoetes','','minima','','','',NULL,'','','','','','A. A. Eaton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6583','','','Huperzia appressa (Desvaux) Á. Löve & D. Löve',1,'Huperzia appressa','Huperzia appressa','Huperzia appress',2,0,'','','Desvaux|Á. Löve|D. Löve','e36a406a-c1a8-5db1-9e8e-bdd11eef29ee','Huperzia appressa (Desvaux) Á. Löve & D. Löve','(Desvaux) Á. Löve & D. Löve','SPECIES','','Huperzia','','appressa','','','',NULL,'Á. Löve & D. Löve','','','','','Desvaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6588','','','Huperzia selago (Linnaeus) Bernhardi ex Schrank & Martius',2,'Huperzia selago','Huperzia selago','Huperzia selag',2,0,'','','Linnaeus|Bernhardi|Schrank|Martius','e54aa192-5f27-5fb6-a8f8-3dce63def544','Huperzia selago (Linnaeus) Bernhardi ex Schrank & Martius','(Linnaeus) Bernhardi ex Schrank & Martius','SPECIES','','Huperzia','','selago','','','',NULL,'Bernhardi','','Schrank & Martius','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30495','','','Huperzia continentalis Testo, A. Haines & A.V. Gilman',1,'Huperzia continentalis','Huperzia continentalis','Huperzia continental',2,0,'','','Testo|A. Haines|A. V. Gilman','99f4e1cb-bf37-5344-9ba2-37275d9a4f1e','Huperzia continentalis Testo, A. Haines & A.V. Gilman','Testo, A. Haines & A.V. Gilman','SPECIES','','Huperzia','','continentalis','','','',NULL,'','','','','','Testo, A. Haines & A. V. Gilman','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31524','','','Lycopodioideae W.H. Wagner & Beitel ex B. Øllgaard',2,'Lycopodioideae','Lycopodioideae','Lycopodioideae',1,0,'','','W. H. Wagner|Beitel|B. Øllgaard','23778162-de2a-58d2-98b4-4f02cfa6cf93','Lycopodioideae W.H. Wagner & Beitel ex B. Øllgaard','W.H. Wagner & Beitel ex B. Øllgaard','SUBFAMILY','Lycopodioideae','','','','','','',NULL,'','','','','','W. H. Wagner & Beitel','','B. Øllgaard','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6576','','','Diphasiastrum digitatum (Dillenius ex A. Braun) Holub',2,'Diphasiastrum digitatum','Diphasiastrum digitatum','Diphasiastrum digitat',2,0,'','','Dillenius|A. Braun|Holub','90778ff7-e22a-5d1e-9fd9-cda8f546fed8','Diphasiastrum digitatum (Dillenius ex A. Braun) Holub','(Dillenius ex A. Braun) Holub','SPECIES','','Diphasiastrum','','digitatum','','','',NULL,'Holub','','','','','Dillenius','','A. Braun','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27750','','','Diphasiastrum ×verecundum A.V. Gilman',3,'','','',NULL,NULL,'','','','','Diphasiastrum ×verecundum A.V. Gilman','A.V. Gilman','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29465','','','Dendrolycopodium A. Haines',1,'Dendrolycopodium','Dendrolycopodium','Dendrolycopodium',1,0,'','','A. Haines','cfa0985b-6942-545d-a43a-4ae939bcfc85','Dendrolycopodium A. Haines','A. Haines','GENUS','Dendrolycopodium','','','','','','',NULL,'','','','','','A. Haines','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23526','','','Dendrolycopodium dendroideum (Michaux) A. Haines',1,'Dendrolycopodium dendroideum','Dendrolycopodium dendroideum','Dendrolycopodium dendroide',2,0,'','','Michaux|A. Haines','da21a328-01f0-58c4-9660-93338982e365','Dendrolycopodium dendroideum (Michaux) A. Haines','(Michaux) A. Haines','SPECIES','','Dendrolycopodium','','dendroideum','','','',NULL,'A. Haines','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31525','','','Spinulum A. Haines',1,'Spinulum','Spinulum','Spinulum',1,0,'','','A. Haines','049e132d-266e-5f40-b457-6abaf5fdfdd7','Spinulum A. Haines','A. Haines','GENUS','Spinulum','','','','','','',NULL,'','','','','','A. Haines','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23529','','','Spinulum annotinum (Linnaeus) A. Haines',1,'Spinulum annotinum','Spinulum annotinum','Spinulum annotin',2,0,'','','Linnaeus|A. Haines','0b9179b6-cc5b-599d-93c1-7becc64b6684','Spinulum annotinum (Linnaeus) A. Haines','(Linnaeus) A. Haines','SPECIES','','Spinulum','','annotinum','','','',NULL,'A. Haines','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('69','','','Selaginellales Prantl',1,'Selaginellales','Selaginellales','Selaginellales',1,0,'','','Prantl','241debac-90b1-537f-9f39-f80627a8d2b5','Selaginellales Prantl','Prantl','ORDER','Selaginellales','','','','','','',NULL,'','','','','','Prantl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1674','','','Selaginella Palisot de Beauvois',1,'Selaginella','Selaginella','Selaginella',1,0,'','','Palisot de Beauvois','52c86a89-32cc-59c8-9bb2-719cf575cd92','Selaginella Palisot de Beauvois','Palisot de Beauvois','GENUS','Selaginella','','','','','','',NULL,'','','','','','Palisot de Beauvois','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34126','','','Selaginella subg. Rupestrae Weststrand & Korall',2,'Rupestrae','Selaginella subgen. Rupestrae','Rupestrae',1,0,'','','Weststrand|Korall','3bf318d3-a953-5746-8c3c-bf09ac3272e2','Selaginella subg. Rupestrae Weststrand & Korall','Weststrand & Korall','SUBGENUS','Rupestrae','','','','','','',NULL,'','','','','','Weststrand & Korall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9335','','','Selaginella rupestris (Linnaeus) Spring',1,'Selaginella rupestris','Selaginella rupestris','Selaginella rupestr',2,0,'','','Linnaeus|Spring','6d827c70-7f04-5a97-ac56-889896d9ffab','Selaginella rupestris (Linnaeus) Spring','(Linnaeus) Spring','SPECIES','','Selaginella','','rupestris','','','',NULL,'Spring','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9340','','','Selaginella wallacei Hieronymus',1,'Selaginella wallacei','Selaginella wallacei','Selaginella wallace',2,0,'','','Hieronymus','c4303f23-bd27-5607-9861-15eb52e4bb2a','Selaginella wallacei Hieronymus','Hieronymus','SPECIES','','Selaginella','','wallacei','','','',NULL,'','','','','','Hieronymus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1526','','','Petroselinum Hill',1,'Petroselinum','Petroselinum','Petroselinum',1,0,'','','Hill','4ac2de28-e8a1-5032-b7b6-43ccf382927f','Petroselinum Hill','Hill','GENUS','Petroselinum','','','','','','',NULL,'','','','','','Hill','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2531','','','Anethum graveolens Linnaeus',1,'Anethum graveolens','Anethum graveolens','Anethum graueolens',2,0,'','','Linnaeus','36f90cff-9a4a-5002-a9e5-5504e93e3dbb','Anethum graveolens Linnaeus','Linnaeus','SPECIES','','Anethum','','graveolens','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('978','','','Chaerophyllum Linnaeus',1,'Chaerophyllum','Chaerophyllum','Chaerophyllum',1,0,'','','Linnaeus','7b1c270f-1b3a-5bd2-bfe7-3fb2394b2a99','Chaerophyllum Linnaeus','Linnaeus','GENUS','Chaerophyllum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2555','','','Chaerophyllum temulum Linnaeus',1,'Chaerophyllum temulum','Chaerophyllum temulum','Chaerophyllum temul',2,0,'','','Linnaeus','2a4fc479-10fd-5544-b63c-b969db80bafc','Chaerophyllum temulum Linnaeus','Linnaeus','SPECIES','','Chaerophyllum','','temulum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2617','','','Myrrhis odorata (Linnaeus) Scopoli',1,'Myrrhis odorata','Myrrhis odorata','Myrrhis odorat',2,0,'','','Linnaeus|Scopoli','a75996fb-23a2-5789-afc8-70c67f1e6071','Myrrhis odorata (Linnaeus) Scopoli','(Linnaeus) Scopoli','SPECIES','','Myrrhis','','odorata','','','',NULL,'Scopoli','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2620','','','Osmorhiza claytonii (Michaux) C.B. Clarke',1,'Osmorhiza claytonii','Osmorhiza claytonii','Osmorhiza clayton',2,0,'','','Michaux|C. B. Clarke','7cce991b-e6a9-5a16-a061-54c777fbff6c','Osmorhiza claytonii (Michaux) C.B. Clarke','(Michaux) C.B. Clarke','SPECIES','','Osmorhiza','','claytonii','','','',NULL,'C. B. Clarke','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2624','','','Osmorhiza purpurea (J.M. Coulter & Rose) Suksdorf',1,'Osmorhiza purpurea','Osmorhiza purpurea','Osmorhiza purpure',2,0,'','','J. M. Coulter|Rose|Suksdorf','7e8642a2-06ab-5dad-a790-7ab2e718dc5e','Osmorhiza purpurea (J.M. Coulter & Rose) Suksdorf','(J.M. Coulter & Rose) Suksdorf','SPECIES','','Osmorhiza','','purpurea','','','',NULL,'Suksdorf','','','','','J. M. Coulter & Rose','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2572','','','Daucus pusillus Michaux',1,'Daucus pusillus','Daucus pusillus','Daucus pusill',2,0,'','','Michaux','9f37e915-0471-5d3f-9fe6-dae93c3d214e','Daucus pusillus Michaux','Michaux','SPECIES','','Daucus','','pusillus','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2652','','','Torilis arvensis (Hudson) Link',1,'Torilis arvensis','Torilis arvensis','Torilis aruens',2,0,'','','Hudson|Link','5308009c-989f-5281-be59-b312cce59a92','Torilis arvensis (Hudson) Link','(Hudson) Link','SPECIES','','Torilis','','arvensis','','','',NULL,'Link','','','','','Hudson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31893','','','Conopodium majus (Gouan) Loret',1,'Conopodium majus','Conopodium majus','Conopodium ma',2,0,'','','Gouan|Loret','8db05cb8-7cb1-5ab1-962b-1568e6c079ab','Conopodium majus (Gouan) Loret','(Gouan) Loret','SPECIES','','Conopodium','','majus','','','',NULL,'Loret','','','','','Gouan','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('567','','','Erigenieae',1,'Erigenieae','Erigenieae','Erigenieae',1,0,'','','','7ce2b827-c8a7-5c78-9495-35da61965c36','Erigenieae','','TRIBE','Erigenieae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2573','','','Erigenia bulbosa (Michaux) Nuttall',1,'Erigenia bulbosa','Erigenia bulbosa','Erigenia bulbos',2,0,'','','Michaux|Nuttall','0c7c5c27-0ea1-57df-877e-9d70696c204b','Erigenia bulbosa (Michaux) Nuttall','(Michaux) Nuttall','SPECIES','','Erigenia','','bulbosa','','','',NULL,'Nuttall','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2583','','','Heracleum maximum W. Bartram',1,'Heracleum maximum','Heracleum maximum','Heracleum maxim',2,0,'','','W. Bartram','4024e7a9-4e25-508e-9313-bba937b507a9','Heracleum maximum W. Bartram','W. Bartram','SPECIES','','Heracleum','','maximum','','','',NULL,'','','','','','W. Bartram','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29094','','','Bupleureae Sprengel',1,'Bupleureae','Bupleureae','Bupleureae',1,0,'','','Sprengel','f7836173-822e-5875-b942-dbf5764c6164','Bupleureae Sprengel','Sprengel','TRIBE','Bupleureae','','','','','','',NULL,'','','','','','Sprengel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29095','','','Careae Baillon',1,'Careae','Careae','Careae',1,0,'','','Baillon','6ab391af-eba2-5143-a6a4-92ce0a1236c3','Careae Baillon','Baillon','TRIBE','Careae','','','','','','',NULL,'','','','','','Baillon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('954','','','Carum Linnaeus',1,'Carum','Carum','Carum',1,0,'','','Linnaeus','ef5ed5f1-dc7e-5425-8a82-87d69f54cdba','Carum Linnaeus','Linnaeus','GENUS','Carum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2551','','','Carum carvi Linnaeus',1,'Carum carvi','Carum carvi','Carum caru',2,0,'','','Linnaeus','32b1d2e1-a25c-58c9-a86b-d1cbf16292e2','Carum carvi Linnaeus','Linnaeus','SPECIES','','Carum','','carvi','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29096','','','Oenantheae Dumortier',1,'Oenantheae','Oenantheae','Oenantheae',1,0,'','','Dumortier','2ee8663b-831f-50d6-bc3c-6ada29f2e472','Oenantheae Dumortier','Dumortier','TRIBE','Oenantheae','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('895','','','Berula W.D.J. Koch',1,'Berula','Berula','Berula',1,0,'','','W. D. J. Koch','a7013434-6c14-53a6-b0c0-8c3aafbd61a3','Berula W.D.J. Koch','W.D.J. Koch','GENUS','Berula','','','','','','',NULL,'','','','','','W. D. J. Koch','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2562','','','Cicuta virosa Linnaeus',1,'Cicuta virosa','Cicuta virosa','Cicuta uiros',2,0,'','','Linnaeus','0c1ce44e-e312-5cfd-a3d6-c71426ad23c7','Cicuta virosa Linnaeus','Linnaeus','SPECIES','','Cicuta','','virosa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2560','','','Cicuta maculata Linnaeus var. maculata',1,'Cicuta maculata maculata','Cicuta maculata var. maculata','Cicuta maculat maculat',3,0,'','','','2fb1108a-513f-5bca-990e-4b6c5d387bc3','Cicuta maculata Linnaeus var. maculata','Linnaeus','VARIETY','','Cicuta','','maculata','maculata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2596','','','Lilaeopsis occidentalis J.M. Coulter & Rose',1,'Lilaeopsis occidentalis','Lilaeopsis occidentalis','Lilaeopsis occidental',2,0,'','','J. M. Coulter|Rose','518ec19e-9c24-5e8d-a780-33c2a680fac5','Lilaeopsis occidentalis J.M. Coulter & Rose','J.M. Coulter & Rose','SPECIES','','Lilaeopsis','','occidentalis','','','',NULL,'','','','','','J. M. Coulter & Rose','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33311','','','Perideridia montana (Rydberg) Dorn',1,'Perideridia montana','Perideridia montana','Perideridia montan',2,0,'','','Rydberg|Dorn','d3c6d968-e6d8-5303-9776-4cbdf4a77a7d','Perideridia montana (Rydberg) Dorn','(Rydberg) Dorn','SPECIES','','Perideridia','','montana','','','',NULL,'Dorn','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1550','','','Pimpinella Linnaeus',1,'Pimpinella','Pimpinella','Pimpinella',1,0,'','','Linnaeus','cc4aa02a-c975-5499-933c-f86d4c79d35b','Pimpinella Linnaeus','Linnaeus','GENUS','Pimpinella','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('784','','','Aethusa Linnaeus',1,'Aethusa','Aethusa','Aethusa',1,0,'','','Linnaeus','2a3cd47f-4313-51bd-a725-6268a3fa8735','Aethusa Linnaeus','Linnaeus','GENUS','Aethusa','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2534','','','Angelica arguta Nuttall',1,'Angelica arguta','Angelica arguta','Angelica argut',2,0,'','','Nuttall','21f7e39d-620d-5bc8-bb62-1fea49e7bd48','Angelica arguta Nuttall','Nuttall','SPECIES','','Angelica','','arguta','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2538','','','Angelica lucida Linnaeus',1,'Angelica lucida','Angelica lucida','Angelica lucid',2,0,'','','Linnaeus','5563175a-176f-5f74-af42-5cede4d24a6a','Angelica lucida Linnaeus','Linnaeus','SPECIES','','Angelica','','lucida','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2533','','','Angelica archangelica Linnaeus',1,'Angelica archangelica','Angelica archangelica','Angelica archangelic',2,0,'','','Linnaeus','88ab9931-c02e-5c48-b7a0-e617987ac8c3','Angelica archangelica Linnaeus','Linnaeus','SPECIES','','Angelica','','archangelica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1211','','','Glehnia F. Schmidt',1,'Glehnia','Glehnia','Glehnia',1,0,'','','F. Schmidt','e5b19c40-0208-50ff-bef0-0465a65c2ea5','Glehnia F. Schmidt','F. Schmidt','GENUS','Glehnia','','','','','','',NULL,'','','','','','F. Schmidt','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1528','','','Imperatoria Linnaeus',1,'Imperatoria','Imperatoria','Imperatoria',1,0,'','','Linnaeus','e15e2532-06e8-55e1-bc4d-17f00a4a06bd','Imperatoria Linnaeus','Linnaeus','GENUS','Imperatoria','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2598','','','Lomatium brandegeei (J.M. Coulter & Rose) J.F. Macbride',1,'Lomatium brandegeei','Lomatium brandegeei','Lomatium brandegee',2,0,'','','J. M. Coulter|Rose|J. F. Macbride','3c0f2a90-7b0e-5b96-b698-0c9af2e3a4e3','Lomatium brandegeei (J.M. Coulter & Rose) J.F. Macbride','(J.M. Coulter & Rose) J.F. Macbride','SPECIES','','Lomatium','','brandegeei','','','',NULL,'J. F. Macbride','','','','','J. M. Coulter & Rose','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2607','','','Lomatium grayi (J.M. Coulter & Rose) J.M. Coulter & Rose',1,'Lomatium grayi','Lomatium grayi','Lomatium gray',2,0,'','','J. M. Coulter|Rose','f31f2325-6c08-59a2-b710-49583d6e97bc','Lomatium grayi (J.M. Coulter & Rose) J.M. Coulter & Rose','(J.M. Coulter & Rose) J.M. Coulter & Rose','SPECIES','','Lomatium','','grayi','','','',NULL,'J. M. Coulter & Rose','','','','','J. M. Coulter & Rose','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2612','','','Lomatium sandbergii (J.M. Coulter & Rose) J.M. Coulter & Rose',1,'Lomatium sandbergii','Lomatium sandbergii','Lomatium sandberg',2,0,'','','J. M. Coulter|Rose','57e3c7eb-d707-5962-abc5-f8907bae1754','Lomatium sandbergii (J.M. Coulter & Rose) J.M. Coulter & Rose','(J.M. Coulter & Rose) J.M. Coulter & Rose','SPECIES','','Lomatium','','sandbergii','','','',NULL,'J. M. Coulter & Rose','','','','','J. M. Coulter & Rose','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2604','','','Lomatium foeniculaceum (Nuttall) J.M. Coulter & Rose',1,'Lomatium foeniculaceum','Lomatium foeniculaceum','Lomatium foeniculace',2,0,'','','Nuttall|J. M. Coulter|Rose','3b603caa-b9d7-50e5-9267-85df98e11c37','Lomatium foeniculaceum (Nuttall) J.M. Coulter & Rose','(Nuttall) J.M. Coulter & Rose','SPECIES','','Lomatium','','foeniculaceum','','','',NULL,'J. M. Coulter & Rose','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31542','','','Lomatium papilioniferum J.A. Alexander & W. Whaley',1,'Lomatium papilioniferum','Lomatium papilioniferum','Lomatium papilionifer',2,0,'','','J. A. Alexander|W. Whaley','b2afc176-a42e-5aab-9f51-bb4077f71122','Lomatium papilioniferum J.A. Alexander & W. Whaley','J.A. Alexander & W. Whaley','SPECIES','','Lomatium','','papilioniferum','','','',NULL,'','','','','','J. A. Alexander & W. Whaley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1441','','','Musineon Rafinesque',1,'Musineon','Musineon','Musineon',1,0,'','','Rafinesque','536527a2-a8c3-5907-8a7e-bdbd88d274e8','Musineon Rafinesque','Rafinesque','GENUS','Musineon','','','','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2616','','','Musineon divaricatum (Pursh) Nuttall',1,'Musineon divaricatum','Musineon divaricatum','Musineon diuaricat',2,0,'','','Pursh|Nuttall','08e8a24a-5b57-5ddc-9ebc-abc7f40515b1','Musineon divaricatum (Pursh) Nuttall','(Pursh) Nuttall','SPECIES','','Musineon','','divaricatum','','','',NULL,'Nuttall','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2631','','','Podistera macounii (J.M. Coulter & Rose) Mathias & Constance',1,'Podistera macounii','Podistera macounii','Podistera macoun',2,0,'','','J. M. Coulter|Rose|Mathias|Constance','8e04cb9b-2cb7-56c0-9a4e-bbfc81af5cb4','Podistera macounii (J.M. Coulter & Rose) Mathias & Constance','(J.M. Coulter & Rose) Mathias & Constance','SPECIES','','Podistera','','macounii','','','',NULL,'Mathias & Constance','','','','','J. M. Coulter & Rose','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1737','','','Taenidia Drude',1,'Taenidia','Taenidia','Taenidia',1,0,'','','Drude','80a854d7-27b2-5c5f-9ef7-3dc7f818b81a','Taenidia Drude','Drude','GENUS','Taenidia','','','','','','',NULL,'','','','','','Drude','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1750','','','Thaspium Nuttall',1,'Thaspium','Thaspium','Thaspium',1,0,'','','Nuttall','fcfbc0de-3196-536b-b877-6fc8910cbc72','Thaspium Nuttall','Nuttall','GENUS','Thaspium','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2648','','','Thaspium barbinode (Michaux) Nuttall',1,'Thaspium barbinode','Thaspium barbinode','Thaspium barbinod',2,0,'','','Michaux|Nuttall','162c2983-c9a2-5b1c-9f71-44ceedaa7c61','Thaspium barbinode (Michaux) Nuttall','(Michaux) Nuttall','SPECIES','','Thaspium','','barbinode','','','',NULL,'Nuttall','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2649','','','Thaspium trifoliatum var. aureum Britton',1,'Thaspium trifoliatum aureum','Thaspium trifoliatum var. aureum','Thaspium trifoliat aure',3,0,'','','Britton','876cd2ff-2a28-5962-b96f-aac620a61227','Thaspium trifoliatum var. aureum Britton','Britton','VARIETY','','Thaspium','','trifoliatum','aureum','','',NULL,'','','','','','Britton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10102','','','Zizia aptera var. occidentalis Fernald',1,'Zizia aptera occidentalis','Zizia aptera var. occidentalis','Zizia apter occidental',3,0,'','','Fernald','05a65fe2-6731-5028-a4a0-5cafd0f84864','Zizia aptera var. occidentalis Fernald','Fernald','VARIETY','','Zizia','','aptera','occidentalis','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33573','','','Vesper R.L. Hartman & G.L. Nesom',1,'Vesper','Vesper','Vesper',1,0,'','','R. L. Hartman|G. L. Nesom','4dfe0de9-3d7f-558e-8a50-0dcd1ad524ed','Vesper R.L. Hartman & G.L. Nesom','R.L. Hartman & G.L. Nesom','GENUS','Vesper','','','','','','',NULL,'','','','','','R. L. Hartman & G. L. Nesom','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29100','','','Conioselinum chinense clade',4,'','','',NULL,NULL,'','','','','Conioselinum chinense clade','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2587','','','Ligusticum apiifolium (Nuttall ex Torrey & A. Gray) A. Gray',2,'Ligusticum apiifolium','Ligusticum apiifolium','Ligusticum apiifoli',2,0,'','','Nuttall|Torrey|A. Gray','62c0ec8b-0091-5dcf-b368-ce33c9f8ec6c','Ligusticum apiifolium (Nuttall ex Torrey & A. Gray) A. Gray','(Nuttall ex Torrey & A. Gray) A. Gray','SPECIES','','Ligusticum','','apiifolium','','','',NULL,'A. Gray','','','','','Nuttall','','Torrey & A. Gray','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2590','','','Ligusticum grayi J.M. Coulter & Rose',1,'Ligusticum grayi','Ligusticum grayi','Ligusticum gray',2,0,'','','J. M. Coulter|Rose','8c2234b9-6f88-5351-a628-aae3acdc99e8','Ligusticum grayi J.M. Coulter & Rose','J.M. Coulter & Rose','SPECIES','','Ligusticum','','grayi','','','',NULL,'','','','','','J. M. Coulter & Rose','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2592','','','Ligusticum scoticum Linnaeus',1,'Ligusticum scoticum','Ligusticum scoticum','Ligusticum scotic',2,0,'','','Linnaeus','35366a4a-33b2-5b2f-822a-cb5c3071b624','Ligusticum scoticum Linnaeus','Linnaeus','SPECIES','','Ligusticum','','scoticum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29101','','','Conium clade',4,'','','',NULL,NULL,'','','','','Conium clade','','TRIBE','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1024','','','Conium Linnaeus',1,'Conium','Conium','Conium',1,0,'','','Linnaeus','0ea161e8-1328-58db-9f31-f5d9f78facd9','Conium Linnaeus','Linnaeus','GENUS','Conium','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29102','','','Pyramidoptereae Boissier',1,'Pyramidoptereae','Pyramidoptereae','Pyramidoptereae',1,0,'','','Boissier','39e687ad-0054-5849-bc04-56c48a7301aa','Pyramidoptereae Boissier','Boissier','TRIBE','Pyramidoptereae','','','','','','',NULL,'','','','','','Boissier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('873','','','Astrantia Linnaeus',1,'Astrantia','Astrantia','Astrantia',1,0,'','','Linnaeus','d8198318-5666-5220-bf1e-8a9b158458b9','Astrantia Linnaeus','Linnaeus','GENUS','Astrantia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1158','','','Eryngium Linnaeus',1,'Eryngium','Eryngium','Eryngium',1,0,'','','Linnaeus','cf6886eb-d86c-5864-b84c-737fad47986c','Eryngium Linnaeus','Linnaeus','GENUS','Eryngium','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2576','','','Eryngium campestre Linnaeus',1,'Eryngium campestre','Eryngium campestre','Eryngium campestr',2,0,'','','Linnaeus','b318247b-09b4-5e19-b001-3a515318f141','Eryngium campestre Linnaeus','Linnaeus','SPECIES','','Eryngium','','campestre','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1646','','','Sanicula Linnaeus',1,'Sanicula','Sanicula','Sanicula',1,0,'','','Linnaeus','2440b30b-d641-5d03-a1ba-0d4ea4ff95d7','Sanicula Linnaeus','Linnaeus','GENUS','Sanicula','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2640','','','Sanicula crassicaulis Poeppig ex de Candolle',2,'Sanicula crassicaulis','Sanicula crassicaulis','Sanicula crassicaul',2,0,'','','Poeppig|de Candolle','aed8b5ed-afbc-59b0-ac86-f13f824dee6b','Sanicula crassicaulis Poeppig ex de Candolle','Poeppig ex de Candolle','SPECIES','','Sanicula','','crassicaulis','','','',NULL,'','','','','','Poeppig','','de Candolle','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2638','','','Sanicula canadensis var. grandis Fernald',1,'Sanicula canadensis grandis','Sanicula canadensis var. grandis','Sanicula canadens grand',3,0,'','','Fernald','4ad2e557-b379-51ef-8ef3-3f52f38fef5c','Sanicula canadensis var. grandis Fernald','Fernald','VARIETY','','Sanicula','','canadensis','grandis','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2683','','','Aralia hispida Ventenat',1,'Aralia hispida','Aralia hispida','Aralia hispid',2,0,'','','Ventenat','b0a19a5e-2ad5-58f2-b23f-d3a96eaa8c28','Aralia hispida Ventenat','Ventenat','SPECIES','','Aralia','','hispida','','','',NULL,'','','','','','Ventenat','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('572','','','Hedereae',1,'Hedereae','Hedereae','Hedereae',1,0,'','','','005cbef1-e0e2-5ce3-a27f-30cb3d8513d3','Hedereae','','TRIBE','Hedereae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1230','','','Hedera Linnaeus',1,'Hedera','Hedera','Hedera',1,0,'','','Linnaeus','9069aef6-e939-5efc-88ac-784515f50932','Hedera Linnaeus','Linnaeus','GENUS','Hedera','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('637','','','Schefflereae',1,'Schefflereae','Schefflereae','Schefflereae',1,0,'','','','d34c0c46-3b29-54e9-bc59-ffe86f5ac56c','Schefflereae','','TRIBE','Schefflereae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1970','','','Kalopanax Miquel',1,'Kalopanax','Kalopanax','Kalopanax',1,0,'','','Miquel','43f714f5-9d31-5986-bc9d-4e4c1bf4e7d3','Kalopanax Miquel','Miquel','GENUS','Kalopanax','','','','','','',NULL,'','','','','','Miquel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2695','','','Panax trifolius Linnaeus',1,'Panax trifolius','Panax trifolius','Panax trifol',2,0,'','','Linnaeus','7b24414d-d9ce-5962-a87e-32325cff8ec2','Panax trifolius Linnaeus','Linnaeus','SPECIES','','Panax','','trifolius','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33370','','','Hydrocotyle sibthorpioides Lamarck',1,'Hydrocotyle sibthorpioides','Hydrocotyle sibthorpioides','Hydrocotyle sibthorpioid',2,0,'','','Lamarck','882fb5d5-b8c2-5271-ade5-a5a38f990a29','Hydrocotyle sibthorpioides Lamarck','Lamarck','SPECIES','','Hydrocotyle','','sibthorpioides','','','',NULL,'','','','','','Lamarck','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2666','','','Ilex aquifolium Linnaeus',1,'Ilex aquifolium','Ilex aquifolium','Ilex aquifoli',2,0,'','','Linnaeus','8a03b171-82c1-5d19-a99b-891a8e1f3d0b','Ilex aquifolium Linnaeus','Linnaeus','SPECIES','','Ilex','','aquifolium','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2670','','','Ilex opaca Aiton',1,'Ilex opaca','Ilex opaca','Ilex opac',2,0,'','','Aiton','a51050ce-1c7a-54ab-93dc-5a4bcd35ad5a','Ilex opaca Aiton','Aiton','SPECIES','','Ilex','','opaca','','','',NULL,'','','','','','Aiton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7','','','Asterales Lindley',1,'Asterales','Asterales','Asterales',1,0,'','','Lindley','39d28a21-f5ea-58f2-bae3-625a7ee9133b','Asterales Lindley','Lindley','ORDER','Asterales','','','','','','',NULL,'','','','','','Lindley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4164','','','Campanula lasiocarpa Chamisso',1,'Campanula lasiocarpa','Campanula lasiocarpa','Campanula lasiocarp',2,0,'','','Chamisso','dfaf618c-6fc7-55d1-a07d-8e1af6016fa6','Campanula lasiocarpa Chamisso','Chamisso','SPECIES','','Campanula','','lasiocarpa','','','',NULL,'','','','','','Chamisso','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4161','','','Campanula glomerata Linnaeus subsp. glomerata',1,'Campanula glomerata glomerata','Campanula glomerata subsp. glomerata','Campanula glomerat glomerat',3,0,'','','','fd13ce91-7e86-5a13-b72a-0e47b9ea1159','Campanula glomerata Linnaeus subsp. glomerata','Linnaeus','SUBSPECIES','','Campanula','','glomerata','glomerata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4169','','','Campanula persicifolia Linnaeus',1,'Campanula persicifolia','Campanula persicifolia','Campanula persicifol',2,0,'','','Linnaeus','7c33c7e3-7b28-554b-b0ea-13403ff6cd02','Campanula persicifolia Linnaeus','Linnaeus','SPECIES','','Campanula','','persicifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1206','','','Githopsis Nuttall',1,'Githopsis','Githopsis','Githopsis',1,0,'','','Nuttall','08589adb-233c-5efc-b2bf-a305714b006a','Githopsis Nuttall','Nuttall','GENUS','Githopsis','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4179','','','Heterocodon rariflorus Nuttall',1,'Heterocodon rariflorus','Heterocodon rariflorus','Heterocodon rariflor',2,0,'','','Nuttall','b90f721d-a9aa-5761-8e43-79cc174de76b','Heterocodon rariflorus Nuttall','Nuttall','SPECIES','','Heterocodon','','rariflorus','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1900','','','Jasione Linnaeus',1,'Jasione','Jasione','Jasione',1,0,'','','Linnaeus','b039d79b-6e14-5640-bb34-98ec6c3feae2','Jasione Linnaeus','Linnaeus','GENUS','Jasione','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30804','','','Campanulastrum Small',1,'Campanulastrum','Campanulastrum','Campanulastrum',1,0,'','','Small','c9027b9b-8bdd-5558-8fc2-beac42bbc65c','Campanulastrum Small','Small','GENUS','Campanulastrum','','','','','','',NULL,'','','','','','Small','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32523','','','Palustricodon Morin',1,'Palustricodon','Palustricodon','Palustricodon',1,0,'','','Morin','dd44defd-3177-5537-9245-4a0eb6b405dd','Palustricodon Morin','Morin','GENUS','Palustricodon','','','','','','',NULL,'','','','','','Morin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32525','','','Palustricodon aparinoides (Pursh) Morin var. aparinoides',1,'Palustricodon aparinoides aparinoides','Palustricodon aparinoides var. aparinoides','Palustricodon aparinoid aparinoid',3,0,'','','','7919a8c0-5ae4-53db-8b1f-a11143c4d8e3','Palustricodon aparinoides (Pursh) Morin var. aparinoides','(Pursh) Morin','VARIETY','','Palustricodon','','aparinoides','aparinoides','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32323','','','Lobelia sect. Lobelia Linnaeus',2,'Lobelia','Lobelia sect. Lobelia','Lobelia',1,0,'','','Linnaeus','1171850d-a1d5-555b-bd55-ae64e23e91db','Lobelia sect. Lobelia Linnaeus','Linnaeus','SECTION','Lobelia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4185','','','Lobelia kalmii Linnaeus',1,'Lobelia kalmii','Lobelia kalmii','Lobelia kalm',2,0,'','','Linnaeus','4edd8da7-fc05-5030-b289-638d55979376','Lobelia kalmii Linnaeus','Linnaeus','SPECIES','','Lobelia','','kalmii','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34114','','','Lobelia sect. Stenotum (C. Presl) Lammers',2,'Stenotum','Lobelia sect. Stenotum','Stenotum',1,0,'','','C. Presl|Lammers','231a36e8-faed-5044-93ff-787ab9c9a6be','Lobelia sect. Stenotum (C. Presl) Lammers','(C. Presl) Lammers','SECTION','Stenotum','','','','','','',NULL,'Lammers','','','','','C. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34115','','','Lobelia erinus Linnaeus',1,'Lobelia erinus','Lobelia erinus','Lobelia erin',2,0,'','','Linnaeus','932905b5-a70d-520e-b7fb-d845edc65e8b','Lobelia erinus Linnaeus','Linnaeus','SPECIES','','Lobelia','','erinus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('169','','','Menyanthaceae Berchtold & J. Presl',1,'Menyanthaceae','Menyanthaceae','Menyanthaceae',1,0,'','','Berchtold|J. Presl','879c3080-0928-54ec-9954-611c1a9dc85f','Menyanthaceae Berchtold & J. Presl','Berchtold & J. Presl','FAMILY','Menyanthaceae','','','','','','',NULL,'','','','','','Berchtold & J. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6672','','','Nymphoides cordata (Elliott) Fernald',1,'Nymphoides cordata','Nymphoides cordata','Nymphoides cordat',2,0,'','','Elliott|Fernald','10ddf3e9-69d6-550c-a9b6-a0f553e51517','Nymphoides cordata (Elliott) Fernald','(Elliott) Fernald','SPECIES','','Nymphoides','','cordata','','','',NULL,'Fernald','','','','','Elliott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31424','','','Asteraceae Berchtold & J. Presl nom. cons.',4,'','','',NULL,NULL,'','','','','Asteraceae Berchtold & J. Presl nom. cons.','Berchtold & J. Presl nom. cons.','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32466','','','Cotulineae Kittel',1,'Cotulineae','Cotulineae','Cotulineae',1,0,'','','Kittel','824e7843-d683-53fd-a86e-04178194d0d8','Cotulineae Kittel','Kittel','SUBTRIBE','Cotulineae','','','','','','',NULL,'','','','','','Kittel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3021','','','Cotula coronopifolia Linnaeus',1,'Cotula coronopifolia','Cotula coronopifolia','Cotula coronopifol',2,0,'','','Linnaeus','92f6690c-7bfd-5bb0-b142-7058c88bbeb6','Cotula coronopifolia Linnaeus','Linnaeus','SPECIES','','Cotula','','coronopifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32467','','','Artemisiinae Lessing',1,'Artemisiinae','Artemisiinae','Artemisiinae',1,0,'','','Lessing','abff0122-defa-54f9-9e5d-f1a3adbb13e8','Artemisiinae Lessing','Lessing','SUBTRIBE','Artemisiinae','','','','','','',NULL,'','','','','','Lessing','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2879','','','Artemisia alaskana Rydberg',1,'Artemisia alaskana','Artemisia alaskana','Artemisia alaskan',2,0,'','','Rydberg','9216e121-3860-55c5-9b36-5d1b31349d3c','Artemisia alaskana Rydberg','Rydberg','SPECIES','','Artemisia','','alaskana','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2910','','','Artemisia stelleriana Besser',1,'Artemisia stelleriana','Artemisia stelleriana','Artemisia stellerian',2,0,'','','Besser','5c6d83a3-9215-569e-9bcc-a7de0b737239','Artemisia stelleriana Besser','Besser','SPECIES','','Artemisia','','stelleriana','','','',NULL,'','','','','','Besser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2918','','','Artemisia vulgaris Linnaeus',1,'Artemisia vulgaris','Artemisia vulgaris','Artemisia uulgar',2,0,'','','Linnaeus','a11a08c7-5937-51e3-b224-117b9f2b0452','Artemisia vulgaris Linnaeus','Linnaeus','SPECIES','','Artemisia','','vulgaris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2896','','','Artemisia laciniata Willdenow subsp. laciniata',1,'Artemisia laciniata laciniata','Artemisia laciniata subsp. laciniata','Artemisia laciniat laciniat',3,0,'','','','203ed2f0-0483-5a3b-9f3f-dad1c39d4ff9','Artemisia laciniata Willdenow subsp. laciniata','Willdenow','SUBSPECIES','','Artemisia','','laciniata','laciniata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2899','','','Artemisia ludoviciana subsp. candicans (Rydberg) D.D. Keck',1,'Artemisia ludoviciana candicans','Artemisia ludoviciana subsp. candicans','Artemisia ludouician candicans',3,0,'','','Rydberg|D. D. Keck','39ffb43f-e952-5dd5-bf60-008fd53990a8','Artemisia ludoviciana subsp. candicans (Rydberg) D.D. Keck','(Rydberg) D.D. Keck','SUBSPECIES','','Artemisia','','ludoviciana','candicans','','',NULL,'D. D. Keck','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2903','','','Artemisia ludoviciana subsp. mexicana (Willdenow ex Sprengel) D.D. Keck',2,'Artemisia ludoviciana mexicana','Artemisia ludoviciana subsp. mexicana','Artemisia ludouician mexican',3,0,'','','Willdenow|Sprengel|D. D. Keck','1b5a3a4f-c9ee-5e84-8d3c-3c0dacf79d43','Artemisia ludoviciana subsp. mexicana (Willdenow ex Sprengel) D.D. Keck','(Willdenow ex Sprengel) D.D. Keck','SUBSPECIES','','Artemisia','','ludoviciana','mexicana','','',NULL,'D. D. Keck','','','','','Willdenow','','Sprengel','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2890','','','Artemisia dracunculus Linnaeus',1,'Artemisia dracunculus','Artemisia dracunculus','Artemisia dracuncul',2,0,'','','Linnaeus','0f683446-5ced-5c96-a638-25020f2fbf0d','Artemisia dracunculus Linnaeus','Linnaeus','SPECIES','','Artemisia','','dracunculus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2885','','','Artemisia campestris Linnaeus',1,'Artemisia campestris','Artemisia campestris','Artemisia campestr',2,0,'','','Linnaeus','2af139a0-6963-5cf3-a101-966ad98f0ae4','Artemisia campestris Linnaeus','Linnaeus','SPECIES','','Artemisia','','campestris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2905','','','Artemisia norvegica subsp. saxatilis (Besser) H.M. Hall & Clements',1,'Artemisia norvegica saxatilis','Artemisia norvegica subsp. saxatilis','Artemisia noruegic saxatil',3,0,'','','Besser|H. M. Hall|Clements','af43fd67-53f4-56f8-8963-a646a3187211','Artemisia norvegica subsp. saxatilis (Besser) H.M. Hall & Clements','(Besser) H.M. Hall & Clements','SUBSPECIES','','Artemisia','','norvegica','saxatilis','','',NULL,'H. M. Hall & Clements','','','','','Besser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2915','','','Artemisia tridentata subsp. vaseyana (Rydberg) Beetle',1,'Artemisia tridentata vaseyana','Artemisia tridentata subsp. vaseyana','Artemisia tridentat uaseyan',3,0,'','','Rydberg|Beetle','ea9b56b3-5b29-5aab-a6c8-aa5008c721c1','Artemisia tridentata subsp. vaseyana (Rydberg) Beetle','(Rydberg) Beetle','SUBSPECIES','','Artemisia','','tridentata','vaseyana','','',NULL,'Beetle','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2881','','','Artemisia biennis Willdenow',1,'Artemisia biennis','Artemisia biennis','Artemisia bienn',2,0,'','','Willdenow','75493d18-d4b7-5cb2-882b-056dc93e72b3','Artemisia biennis Willdenow','Willdenow','SPECIES','','Artemisia','','biennis','','','',NULL,'','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('991','','','Chrysanthemum Linnaeus',1,'Chrysanthemum','Chrysanthemum','Chrysanthemum',1,0,'','','Linnaeus','f1166a89-fa33-52bf-9353-2361bc69057d','Chrysanthemum Linnaeus','Linnaeus','GENUS','Chrysanthemum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23265','','','Chrysanthemum arcticum Linnaeus',1,'Chrysanthemum arcticum','Chrysanthemum arcticum','Chrysanthemum arctic',2,0,'','','Linnaeus','e9183b79-1cba-5e21-9a6b-457cda444428','Chrysanthemum arcticum Linnaeus','Linnaeus','SPECIES','','Chrysanthemum','','arcticum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10628','','','Chrysanthemum arcticum subsp. polare Hultén',1,'Chrysanthemum arcticum polare','Chrysanthemum arcticum subsp. polare','Chrysanthemum arctic polar',3,0,'','','Hultén','134304a8-bd60-53aa-818f-dc5bba85682f','Chrysanthemum arcticum subsp. polare Hultén','Hultén','SUBSPECIES','','Chrysanthemum','','arcticum','polare','','',NULL,'','','','','','Hultén','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32468','','','Matricariinae Willkomm',1,'Matricariinae','Matricariinae','Matricariinae',1,0,'','','Willkomm','0225a2dd-0d6e-52a3-9133-035065c800fa','Matricariinae Willkomm','Willkomm','SUBTRIBE','Matricariinae','','','','','','',NULL,'','','','','','Willkomm','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2764','','','Achillea filipendulina Lamarck',1,'Achillea filipendulina','Achillea filipendulina','Achillea filipendulin',2,0,'','','Lamarck','d6c02e72-7e4c-502b-ad70-95c9d109de0c','Achillea filipendulina Lamarck','Lamarck','SPECIES','','Achillea','','filipendulina','','','',NULL,'','','','','','Lamarck','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2771','','','Achillea setacea Waldstein & Kitaibel',1,'Achillea setacea','Achillea setacea','Achillea setace',2,0,'','','Waldstein|Kitaibel','02685958-361f-542b-a686-6324d23ffd14','Achillea setacea Waldstein & Kitaibel','Waldstein & Kitaibel','SPECIES','','Achillea','','setacea','','','',NULL,'','','','','','Waldstein & Kitaibel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1739','','','Tanacetum Linnaeus',1,'Tanacetum','Tanacetum','Tanacetum',1,0,'','','Linnaeus','15f78e66-d02f-54f4-ac2c-a6d6f780d1ba','Tanacetum Linnaeus','Linnaeus','GENUS','Tanacetum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12589','','','Tanacetum bipinnatum subsp. huronense (Nuttall) Breitung',1,'Tanacetum bipinnatum huronense','Tanacetum bipinnatum subsp. huronense','Tanacetum bipinnat huronens',3,0,'','','Nuttall|Breitung','1842d0cf-089b-5219-83e8-14c5fddd70f3','Tanacetum bipinnatum subsp. huronense (Nuttall) Breitung','(Nuttall) Breitung','SUBSPECIES','','Tanacetum','','bipinnatum','huronense','','',NULL,'Breitung','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1791','','','Tripleurospermum Schultz-Bipontinus',1,'Tripleurospermum','Tripleurospermum','Tripleurospermum',1,0,'','','Schultz-Bipontinus','a3ff871c-2459-57be-b6e0-1203860cd066','Tripleurospermum Schultz-Bipontinus','Schultz-Bipontinus','GENUS','Tripleurospermum','','','','','','',NULL,'','','','','','Schultz-Bipontinus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3642','','','Tripleurospermum maritimum subsp. phaeocephalum (Ruprecht) Hämet-Ahti',1,'Tripleurospermum maritimum phaeocephalum','Tripleurospermum maritimum subsp. phaeocephalum','Tripleurospermum maritim phaeocephal',3,0,'','','Ruprecht|Hämet-Ahti','8f964a8a-0093-5b9b-991e-737800f90238','Tripleurospermum maritimum subsp. phaeocephalum (Ruprecht) Hämet-Ahti','(Ruprecht) Hämet-Ahti','SUBSPECIES','','Tripleurospermum','','maritimum','phaeocephalum','','',NULL,'Hämet-Ahti','','','','','Ruprecht','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1334','','','Leucanthemum Miller',1,'Leucanthemum','Leucanthemum','Leucanthemum',1,0,'','','Miller','480d95dd-fc3f-5933-89f8-a0fa91fd79b8','Leucanthemum Miller','Miller','GENUS','Leucanthemum','','','','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32471','','','Santolininae Willkomm',1,'Santolininae','Santolininae','Santolininae',1,0,'','','Willkomm','413a17f0-d620-5e06-ab06-dda2a24eca4d','Santolininae Willkomm','Willkomm','SUBTRIBE','Santolininae','','','','','','',NULL,'','','','','','Willkomm','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2982','','','Glebionis coronaria (Linnaeus) Cassini ex Spach',2,'Glebionis coronaria','Glebionis coronaria','Glebionis coronar',2,0,'','','Linnaeus|Cassini|Spach','2bf52180-197e-57d9-a502-5ec3053cbaa6','Glebionis coronaria (Linnaeus) Cassini ex Spach','(Linnaeus) Cassini ex Spach','SPECIES','','Glebionis','','coronaria','','','',NULL,'Cassini','','Spach','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2920','','','Aster alpinus Linnaeus',1,'Aster alpinus','Aster alpinus','Aster alpin',2,0,'','','Linnaeus','0e203792-d886-57bc-8f79-f0f1c82fb384','Aster alpinus Linnaeus','Linnaeus','SPECIES','','Aster','','alpinus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('892','','','Bellis Linnaeus',1,'Bellis','Bellis','Bellis',1,0,'','','Linnaeus','3c557ea6-a4e0-55d2-a8b4-ad6216f197fb','Bellis Linnaeus','Linnaeus','GENUS','Bellis','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2925','','','Bellis perennis Linnaeus',1,'Bellis perennis','Bellis perennis','Bellis perenn',2,0,'','','Linnaeus','c2743dbd-3bc8-5867-820c-93e3020d6a03','Bellis perennis Linnaeus','Linnaeus','SPECIES','','Bellis','','perennis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2944','','','Boltonia asteroides (Linnaeus) L''Héritier',1,'Boltonia asteroides','Boltonia asteroides','Boltonia asteroid',2,0,'','','Linnaeus|L''Héritier','26258b40-9fb0-56ca-ba45-b374c849d490','Boltonia asteroides (Linnaeus) L''Héritier','(Linnaeus) L''Héritier','SPECIES','','Boltonia','','asteroides','','','',NULL,'L''Héritier','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2984','','','Chrysothamnus viscidiflorus (Hooker) Nuttall',1,'Chrysothamnus viscidiflorus','Chrysothamnus viscidiflorus','Chrysothamnus uiscidiflor',2,0,'','','Hooker|Nuttall','8fa85c63-0726-566b-b892-b9822bd59399','Chrysothamnus viscidiflorus (Hooker) Nuttall','(Hooker) Nuttall','SPECIES','','Chrysothamnus','','viscidiflorus','','','',NULL,'Nuttall','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1850','','','Dieteria Nuttall',1,'Dieteria','Dieteria','Dieteria',1,0,'','','Nuttall','5f4af3f4-ee90-5971-89e3-9dd1f04119bd','Dieteria Nuttall','Nuttall','GENUS','Dieteria','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3052','','','Doellingeria umbellata var. pubens (A. Gray) Britton',1,'Doellingeria umbellata pubens','Doellingeria umbellata var. pubens','Doellingeria umbellat pubens',3,0,'','','A. Gray|Britton','38c0bc0c-d4ec-5351-ae9c-58dc7176d75b','Doellingeria umbellata var. pubens (A. Gray) Britton','(A. Gray) Britton','VARIETY','','Doellingeria','','umbellata','pubens','','',NULL,'Britton','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1147','','','Ericameria Nuttall',1,'Ericameria','Ericameria','Ericameria',1,0,'','','Nuttall','0541ff70-2a61-516c-b3bb-4539dd991844','Ericameria Nuttall','Nuttall','GENUS','Ericameria','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3066','','','Ericameria bloomeri (A. Gray) J.F. Macbride',1,'Ericameria bloomeri','Ericameria bloomeri','Ericameria bloomer',2,0,'','','A. Gray|J. F. Macbride','118d6d71-b76b-5a64-939f-4f341903d752','Ericameria bloomeri (A. Gray) J.F. Macbride','(A. Gray) J.F. Macbride','SPECIES','','Ericameria','','bloomeri','','','',NULL,'J. F. Macbride','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3069','','','Ericameria nauseosa (Pallas ex Pursh) G.L. Nesom &  G.I. Baird var. nauseosa',2,'Ericameria nauseosa nauseosa','Ericameria nauseosa var. nauseosa','Ericameria nauseos nauseos',3,0,'','','','cc8e221d-5fb6-5615-ba88-55c332a95ceb','Ericameria nauseosa (Pallas ex Pursh) G.L. Nesom &  G.I. Baird var. nauseosa','(Pallas ex Pursh) G.L. Nesom &  G.I. Baird','VARIETY','','Ericameria','','nauseosa','nauseosa','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3076','','','Erigeron aureus Greene',1,'Erigeron aureus','Erigeron aureus','Erigeron aure',2,0,'','','Greene','e0eac746-ea2a-5452-88fd-e570f4c10e76','Erigeron aureus Greene','Greene','SPECIES','','Erigeron','','aureus','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3078','','','Erigeron caespitosus Nuttall',1,'Erigeron caespitosus','Erigeron caespitosus','Erigeron caespitos',2,0,'','','Nuttall','c27fe87d-b071-5853-8780-f557dd0caf8e','Erigeron caespitosus Nuttall','Nuttall','SPECIES','','Erigeron','','caespitosus','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3080','','','Erigeron corymbosus Nuttall',1,'Erigeron corymbosus','Erigeron corymbosus','Erigeron corymbos',2,0,'','','Nuttall','f7f7b18e-414c-536a-bd82-1b3287123d8e','Erigeron corymbosus Nuttall','Nuttall','SPECIES','','Erigeron','','corymbosus','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3087','','','Erigeron filifolius (Hooker) Nuttall',1,'Erigeron filifolius','Erigeron filifolius','Erigeron filifol',2,0,'','','Hooker|Nuttall','977c9b13-0a3e-54e0-b731-8fb77cfe80c1','Erigeron filifolius (Hooker) Nuttall','(Hooker) Nuttall','SPECIES','','Erigeron','','filifolius','','','',NULL,'Nuttall','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3096','','','Erigeron hyssopifolius Michaux',1,'Erigeron hyssopifolius','Erigeron hyssopifolius','Erigeron hyssopifol',2,0,'','','Michaux','68758474-61b4-5e1d-816e-64698d8ab1ac','Erigeron hyssopifolius Michaux','Michaux','SPECIES','','Erigeron','','hyssopifolius','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3102','','','Erigeron muirii A. Gray',1,'Erigeron muirii','Erigeron muirii','Erigeron muir',2,0,'','','A. Gray','1745d88d-bdaa-5012-b94c-4f249dd6f9ed','Erigeron muirii A. Gray','A. Gray','SPECIES','','Erigeron','','muirii','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3123','','','Erigeron radicatus Hooker',1,'Erigeron radicatus','Erigeron radicatus','Erigeron radicat',2,0,'','','Hooker','41cf6486-9782-5c8f-aee7-233859d892c6','Erigeron radicatus Hooker','Hooker','SPECIES','','Erigeron','','radicatus','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3085','','','Erigeron uniflorus Linnaeus',1,'Erigeron uniflorus','Erigeron uniflorus','Erigeron uniflor',2,0,'','','Linnaeus','dcb3aa21-7383-595c-96b0-f252a708d034','Erigeron uniflorus Linnaeus','Linnaeus','SPECIES','','Erigeron','','uniflorus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3090','','','Erigeron glabellus Nuttall var. glabellus',1,'Erigeron glabellus glabellus','Erigeron glabellus var. glabellus','Erigeron glabell glabell',3,0,'','','','828ff60f-6b3a-5e88-a9d2-5e835bf15b7a','Erigeron glabellus Nuttall var. glabellus','Nuttall','VARIETY','','Erigeron','','glabellus','glabellus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3108','','','Erigeron peregrinus (Banks ex Pursh) Greene var. peregrinus',2,'Erigeron peregrinus peregrinus','Erigeron peregrinus var. peregrinus','Erigeron peregrin peregrin',3,0,'','','','664cb008-48c0-5882-bc8f-6d19138b6518','Erigeron peregrinus (Banks ex Pursh) Greene var. peregrinus','(Banks ex Pursh) Greene','VARIETY','','Erigeron','','peregrinus','peregrinus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3114','','','Erigeron philadelphicus var. provancheri (Victorin & J. Rousseau) B. Boivin',1,'Erigeron philadelphicus provancheri','Erigeron philadelphicus var. provancheri','Erigeron philadelphic prouancher',3,0,'','','Victorin|J. Rousseau|B. Boivin','ad8a3264-3f58-5b74-bf72-5d285e8e7ef9','Erigeron philadelphicus var. provancheri (Victorin & J. Rousseau) B. Boivin','(Victorin & J. Rousseau) B. Boivin','VARIETY','','Erigeron','','philadelphicus','provancheri','','',NULL,'B. Boivin','','','','','Victorin & J. Rousseau','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3127','','','Erigeron strigosus Muhlenberg ex Willdenow',2,'Erigeron strigosus','Erigeron strigosus','Erigeron strigos',2,0,'','','Muhlenberg|Willdenow','142ed906-9424-5519-88a7-b6b4ae43ea88','Erigeron strigosus Muhlenberg ex Willdenow','Muhlenberg ex Willdenow','SPECIES','','Erigeron','','strigosus','','','',NULL,'','','','','','Muhlenberg','','Willdenow','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3150','','','Eurybia merita (A. Nelson) G.L. Nesom',1,'Eurybia merita','Eurybia merita','Eurybia merit',2,0,'','','A. Nelson|G. L. Nesom','7788d790-dd8b-54aa-9332-fd8b647a8ed5','Eurybia merita (A. Nelson) G.L. Nesom','(A. Nelson) G.L. Nesom','SPECIES','','Eurybia','','merita','','','',NULL,'G. L. Nesom','','','','','A. Nelson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3159','','','Euthamia occidentalis Nuttall',1,'Euthamia occidentalis','Euthamia occidentalis','Euthamia occidental',2,0,'','','Nuttall','24a4f037-a40d-57f2-9f1f-f4244234c4ad','Euthamia occidentalis Nuttall','Nuttall','SPECIES','','Euthamia','','occidentalis','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32720','','','Grindelia humilis Hooker & Arnott',1,'Grindelia humilis','Grindelia humilis','Grindelia humil',2,0,'','','Hooker|Arnott','8dc177a2-2daa-5d5d-8af3-5c0366316149','Grindelia humilis Hooker & Arnott','Hooker & Arnott','SPECIES','','Grindelia','','humilis','','','',NULL,'','','','','','Hooker & Arnott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3217','','','Heterotheca villosa var. minor (Hooker) Semple',1,'Heterotheca villosa minor','Heterotheca villosa var. minor','Heterotheca uillos minor',3,0,'','','Hooker|Semple','d88b97ff-6dff-5d3d-9167-5106a1dfc802','Heterotheca villosa var. minor (Hooker) Semple','(Hooker) Semple','VARIETY','','Heterotheca','','villosa','minor','','',NULL,'Semple','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3296','','','Machaeranthera tanacetifolia (Kunth) Nees',1,'Machaeranthera tanacetifolia','Machaeranthera tanacetifolia','Machaeranthera tanacetifol',2,0,'','','Kunth|Nees','a861958a-8adc-5aeb-9346-e1f3d2df0e22','Machaeranthera tanacetifolia (Kunth) Nees','(Kunth) Nees','SPECIES','','Machaeranthera','','tanacetifolia','','','',NULL,'Nees','','','','','Kunth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3314','','','Oclemena nemoralis (Aiton) Greene',1,'Oclemena nemoralis','Oclemena nemoralis','Oclemena nemoral',2,0,'','','Aiton|Greene','6c64a0ea-5819-5d8b-8f8f-e45bcc2567f8','Oclemena nemoralis (Aiton) Greene','(Aiton) Greene','SPECIES','','Oclemena','','nemoralis','','','',NULL,'Greene','','','','','Aiton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1607','','','Pyrrocoma Hooker',1,'Pyrrocoma','Pyrrocoma','Pyrrocoma',1,0,'','','Hooker','54b716af-8f9b-5994-b003-0470f4e128ea','Pyrrocoma Hooker','Hooker','GENUS','Pyrrocoma','','','','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3375','','','Pyrrocoma carthamoides Hooker var. carthamoides',1,'Pyrrocoma carthamoides carthamoides','Pyrrocoma carthamoides var. carthamoides','Pyrrocoma carthamoid carthamoid',3,0,'','','','f5e2267f-7620-5aa9-86c7-8bea1dd15352','Pyrrocoma carthamoides Hooker var. carthamoides','Hooker','VARIETY','','Pyrrocoma','','carthamoides','carthamoides','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1677','','','Sericocarpus Nees',1,'Sericocarpus','Sericocarpus','Sericocarpus',1,0,'','','Nees','37a1553c-612c-58c1-b382-60273209e325','Sericocarpus Nees','Nees','GENUS','Sericocarpus','','','','','','',NULL,'','','','','','Nees','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1697','','','Solidago Linnaeus',1,'Solidago','Solidago','Solidago',1,0,'','','Linnaeus','4cb86267-d56d-5286-9f7a-883825626433','Solidago Linnaeus','Linnaeus','GENUS','Solidago','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32698','','','Solidago subsect. Erectae (D. Don) Semple & J.B. Beck',2,'Erectae','Solidago subsect. Erectae','Erectae',1,0,'','','D. Don|Semple|J. B. Beck','394d3594-f17b-5cbb-b137-eb554ad38be9','Solidago subsect. Erectae (D. Don) Semple & J.B. Beck','(D. Don) Semple & J.B. Beck','SUBSECTION','Erectae','','','','','','',NULL,'Semple & J. B. Beck','','','','','D. Don','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26656','','','Solidago pallida (Porter) Rydberg',1,'Solidago pallida','Solidago pallida','Solidago pallid',2,0,'','','Porter|Rydberg','64033d18-2983-50f8-a215-1df0c22d3abe','Solidago pallida (Porter) Rydberg','(Porter) Rydberg','SPECIES','','Solidago','','pallida','','','',NULL,'Rydberg','','','','','Porter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25632','','','Solidago hispida Muhlenberg ex Willdenow var. hispida',2,'Solidago hispida hispida','Solidago hispida var. hispida','Solidago hispid hispid',3,0,'','','','4afd0ce6-41d5-555f-b2cb-5da91012b0ee','Solidago hispida Muhlenberg ex Willdenow var. hispida','Muhlenberg ex Willdenow','VARIETY','','Solidago','','hispida','hispida','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3474','','','Solidago puberula Nuttall',1,'Solidago puberula','Solidago puberula','Solidago puberul',2,0,'','','Nuttall','f3b0c7bc-1e7c-559e-809d-5e83d8715e85','Solidago puberula Nuttall','Nuttall','SPECIES','','Solidago','','puberula','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12250','','','Solidago gillmanii (A. Gray) Steele',1,'Solidago gillmanii','Solidago gillmanii','Solidago gillman',2,0,'','','A. Gray|Steele','7937ea32-f260-5526-98b7-677af842f7e2','Solidago gillmanii (A. Gray) Steele','(A. Gray) Steele','SPECIES','','Solidago','','gillmanii','','','',NULL,'Steele','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32700','','','Solidago sect. Squarrosae A. Gray',2,'Squarrosae','Solidago sect. Squarrosae','Squarrosae',1,0,'','','A. Gray','dbc08326-152a-5e4f-b66f-d96968991f4b','Solidago sect. Squarrosae A. Gray','A. Gray','SECTION','Squarrosae','','','','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3471','','','Solidago petiolaris Aiton',1,'Solidago petiolaris','Solidago petiolaris','Solidago petiolar',2,0,'','','Aiton','1c3471aa-6ca7-536c-a92b-765f17eb36ac','Solidago petiolaris Aiton','Aiton','SPECIES','','Solidago','','petiolaris','','','',NULL,'','','','','','Aiton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3477','','','Solidago rigida subsp. humilis (Porter) Heard & Semple',1,'Solidago rigida humilis','Solidago rigida subsp. humilis','Solidago rigid humil',3,0,'','','Porter|Heard|Semple','fef948a5-29f8-50ae-8506-2f3877b431a2','Solidago rigida subsp. humilis (Porter) Heard & Semple','(Porter) Heard & Semple','SUBSPECIES','','Solidago','','rigida','humilis','','',NULL,'Heard & Semple','','','','','Porter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3479','','','Solidago rigida Linnaeus subsp. rigida',1,'Solidago rigida rigida','Solidago rigida subsp. rigida','Solidago rigid rigid',3,0,'','','','aaffe219-74fa-5935-8f08-1216837f66ad','Solidago rigida Linnaeus subsp. rigida','Linnaeus','SUBSPECIES','','Solidago','','rigida','rigida','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3508','','','Solidago ×lutescens (Lindley ex de Candolle) B. Boivin',3,'','','',NULL,NULL,'','','','','Solidago ×lutescens (Lindley ex de Candolle) B. Boivin','(Lindley ex de Candolle) B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3507','','','Solidago ×krotkovii B. Boivin',3,'','','',NULL,NULL,'','','','','Solidago ×krotkovii B. Boivin','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12209','','','Solidago ×bernardii B. Boivin',3,'','','',NULL,NULL,'','','','','Solidago ×bernardii B. Boivin','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3443','','','Solidago caesia Linnaeus',1,'Solidago caesia','Solidago caesia','Solidago caes',2,0,'','','Linnaeus','ebd65552-25e1-5bcc-b69d-60fb1a67450d','Solidago caesia Linnaeus','Linnaeus','SPECIES','','Solidago','','caesia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12304','','','Solidago uliginosa var. peracuta (Fernald) Friesner',1,'Solidago uliginosa peracuta','Solidago uliginosa var. peracuta','Solidago uliginos peracut',3,0,'','','Fernald|Friesner','b75b3bfc-c76a-55b9-82ba-10830800490e','Solidago uliginosa var. peracuta (Fernald) Friesner','(Fernald) Friesner','VARIETY','','Solidago','','uliginosa','peracuta','','',NULL,'Friesner','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12305','','','Solidago uliginosa var. terrae-novae (Torrey & A. Gray) Fernald',1,'Solidago uliginosa terrae-novae','Solidago uliginosa var. terrae-novae','Solidago uliginos terrae-nou',3,0,'','','Torrey|A. Gray|Fernald','2c5a8719-5604-5979-a7a0-ebf22847340b','Solidago uliginosa var. terrae-novae (Torrey & A. Gray) Fernald','(Torrey & A. Gray) Fernald','VARIETY','','Solidago','','uliginosa','terrae-novae','','',NULL,'Fernald','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9881','','','Solidago arguta Aiton',1,'Solidago arguta','Solidago arguta','Solidago argut',2,0,'','','Aiton','90629931-dc33-5036-8b63-db8ce01d379d','Solidago arguta Aiton','Aiton','SPECIES','','Solidago','','arguta','','','',NULL,'','','','','','Aiton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32684','','','Solidago subsect. Ulmifoliae (Mackenzie) Semple & J.B. Beck',2,'Ulmifoliae','Solidago subsect. Ulmifoliae','Ulmifoliae',1,0,'','','Mackenzie|Semple|J. B. Beck','34b40d0f-3156-573f-aa05-ae26df6c9140','Solidago subsect. Ulmifoliae (Mackenzie) Semple & J.B. Beck','(Mackenzie) Semple & J.B. Beck','SUBSECTION','Ulmifoliae','','','','','','',NULL,'Semple & J. B. Beck','','','','','Mackenzie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32686','','','Solidago sect. Unilaterales D. Don',2,'Unilaterales','Solidago sect. Unilaterales','Unilaterales',1,0,'','','D. Don','f1f508ac-3b73-592e-a9a1-c9848cb2fd06','Solidago sect. Unilaterales D. Don','D. Don','SECTION','Unilaterales','','','','','','',NULL,'','','','','','D. Don','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3446','','','Solidago canadensis var. hargeri Fernald',1,'Solidago canadensis hargeri','Solidago canadensis var. hargeri','Solidago canadens harger',3,0,'','','Fernald','26baae8a-28a5-5b6d-8300-dc0152e87582','Solidago canadensis var. hargeri Fernald','Fernald','VARIETY','','Solidago','','canadensis','hargeri','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12042','','','Solidago altissima Linnaeus var. altissima',1,'Solidago altissima altissima','Solidago altissima var. altissima','Solidago altissim altissim',3,0,'','','','7eed4d4b-58d1-5160-a9b2-1005857096c2','Solidago altissima Linnaeus var. altissima','Linnaeus','VARIETY','','Solidago','','altissima','altissima','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3451','','','Solidago juncea Aiton',1,'Solidago juncea','Solidago juncea','Solidago iunce',2,0,'','','Aiton','4e87ee9e-fea7-5f0a-9c4b-fc19ea75e9ba','Solidago juncea Aiton','Aiton','SPECIES','','Solidago','','juncea','','','',NULL,'','','','','','Aiton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32692','','','Solidago subsect. Serotinae (Rydberg) Semple & J.B. Beck',2,'Serotinae','Solidago subsect. Serotinae','Serotinae',1,0,'','','Rydberg|Semple|J. B. Beck','80fa38a9-5baf-5cca-97c0-78a1c33659a8','Solidago subsect. Serotinae (Rydberg) Semple & J.B. Beck','(Rydberg) Semple & J.B. Beck','SUBSECTION','Serotinae','','','','','','',NULL,'Semple & J. B. Beck','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32671','','','Solidago subg. Nemorales (Mackenzie) Semple & J.B. Beck',2,'Nemorales','Solidago subgen. Nemorales','Nemorales',1,0,'','','Mackenzie|Semple|J. B. Beck','e9b2aa9c-4cc6-5130-8042-f48f241d2367','Solidago subg. Nemorales (Mackenzie) Semple & J.B. Beck','(Mackenzie) Semple & J.B. Beck','SUBGENUS','Nemorales','','','','','','',NULL,'Semple & J. B. Beck','','','','','Mackenzie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3502','','','Solidago ×asperula Desfontaines',3,'','','',NULL,NULL,'','','','','Solidago ×asperula Desfontaines','Desfontaines','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32703','','','Solidago subg. Triactis Rafinesque',2,'Triactis','Solidago subgen. Triactis','Triactis',1,0,'','','Rafinesque','1ec7e25a-85f0-5bf5-a2fc-43d86f739f64','Solidago subg. Triactis Rafinesque','Rafinesque','SUBGENUS','Triactis','','','','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1733','','','Symphyotrichum Nees',1,'Symphyotrichum','Symphyotrichum','Symphyotrichum',1,0,'','','Nees','2447ff75-59d1-58a2-ad5f-20afdd3586e9','Symphyotrichum Nees','Nees','GENUS','Symphyotrichum','','','','','','',NULL,'','','','','','Nees','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3531','','','Symphyotrichum dumosum (Linnaeus) G.L. Nesom',1,'Symphyotrichum dumosum','Symphyotrichum dumosum','Symphyotrichum dumos',2,0,'','','Linnaeus|G. L. Nesom','d8220c65-6fa3-539a-b30a-4fc0af227446','Symphyotrichum dumosum (Linnaeus) G.L. Nesom','(Linnaeus) G.L. Nesom','SPECIES','','Symphyotrichum','','dumosum','','','',NULL,'G. L. Nesom','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3584','','','Symphyotrichum shortii (Lindley ex Hooker) G.L. Nesom',2,'Symphyotrichum shortii','Symphyotrichum shortii','Symphyotrichum short',2,0,'','','Lindley|Hooker|G. L. Nesom','9a3b8292-8e27-52c3-b578-352be0cd765a','Symphyotrichum shortii (Lindley ex Hooker) G.L. Nesom','(Lindley ex Hooker) G.L. Nesom','SPECIES','','Symphyotrichum','','shortii','','','',NULL,'G. L. Nesom','','','','','Lindley','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3544','','','Symphyotrichum laeve subsp. laeve var. geyeri (A. Gray) G.L. Nesom',1,'Symphyotrichum laeve laeve geyeri','Symphyotrichum laeve subsp. laeve var. geyeri','Symphyotrichum laeu laeu geyer',4,0,'','','A. Gray|G. L. Nesom','91828284-98b2-5868-80b7-35051a6cee79','Symphyotrichum laeve subsp. laeve var. geyeri (A. Gray) G.L. Nesom','(A. Gray) G.L. Nesom','VARIETY','','','','','','','',NULL,'G. L. Nesom','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3556','','','Symphyotrichum lateriflorum var. hirsuticaule (Lindley ex De Candolle) G.L. Nesom',2,'Symphyotrichum lateriflorum hirsuticaule','Symphyotrichum lateriflorum var. hirsuticaule','Symphyotrichum lateriflor hirsuticaul',3,0,'','','Lindley|De Candolle|G. L. Nesom','e65eef80-9d37-5fb0-95b4-95522bf7e824','Symphyotrichum lateriflorum var. hirsuticaule (Lindley ex De Candolle) G.L. Nesom','(Lindley ex De Candolle) G.L. Nesom','VARIETY','','Symphyotrichum','','lateriflorum','hirsuticaule','','',NULL,'G. L. Nesom','','','','','Lindley','','De Candolle','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3562','','','Symphyotrichum novi-belgii var. crenifolium (Fernald) Labrecque & Brouillet',1,'Symphyotrichum novi-belgii crenifolium','Symphyotrichum novi-belgii var. crenifolium','Symphyotrichum noui-belg crenifoli',3,0,'','','Fernald|Labrecque|Brouillet','6092044d-10e5-54ce-add7-d705e7cd6b01','Symphyotrichum novi-belgii var. crenifolium (Fernald) Labrecque & Brouillet','(Fernald) Labrecque & Brouillet','VARIETY','','Symphyotrichum','','novi-belgii','crenifolium','','',NULL,'Labrecque & Brouillet','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3566','','','Symphyotrichum novi-belgii var. villicaule (A. Gray) Labrecque & Brouillet',1,'Symphyotrichum novi-belgii villicaule','Symphyotrichum novi-belgii var. villicaule','Symphyotrichum noui-belg uillicaul',3,0,'','','A. Gray|Labrecque|Brouillet','2a89873f-058f-50f5-8ad3-53b0f61db5c1','Symphyotrichum novi-belgii var. villicaule (A. Gray) Labrecque & Brouillet','(A. Gray) Labrecque & Brouillet','VARIETY','','Symphyotrichum','','novi-belgii','villicaule','','',NULL,'Labrecque & Brouillet','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3569','','','Symphyotrichum ontarionis (Wiegand) G.L. Nesom var. ontarionis',1,'Symphyotrichum ontarionis ontarionis','Symphyotrichum ontarionis var. ontarionis','Symphyotrichum ontarion ontarion',3,0,'','','','211f491e-549f-5011-b51a-f8a02b03cc33','Symphyotrichum ontarionis (Wiegand) G.L. Nesom var. ontarionis','(Wiegand) G.L. Nesom','VARIETY','','Symphyotrichum','','ontarionis','ontarionis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3580','','','Symphyotrichum puniceum (Linnaeus) Á. Löve & D. Löve',1,'Symphyotrichum puniceum','Symphyotrichum puniceum','Symphyotrichum punice',2,0,'','','Linnaeus|Á. Löve|D. Löve','dd9675d1-2818-5d02-bb68-e53e6015f9ea','Symphyotrichum puniceum (Linnaeus) Á. Löve & D. Löve','(Linnaeus) Á. Löve & D. Löve','SPECIES','','Symphyotrichum','','puniceum','','','',NULL,'Á. Löve & D. Löve','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3551','','','Symphyotrichum lanceolatum subsp. lanceolatum var. interior (Wiegand) G.L. Nesom',1,'Symphyotrichum lanceolatum lanceolatum interior','Symphyotrichum lanceolatum subsp. lanceolatum var. interior','Symphyotrichum lanceolat lanceolat interior',4,0,'','','Wiegand|G. L. Nesom','80c25a9c-ad16-5ce4-b01e-feecb1be91ff','Symphyotrichum lanceolatum subsp. lanceolatum var. interior (Wiegand) G.L. Nesom','(Wiegand) G.L. Nesom','VARIETY','','','','','','','',NULL,'G. L. Nesom','','','','','Wiegand','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26945','','','Symphyotrichum lanceolatum subsp. lanceolatum × Symphyotrichum lateriflorum',2,'Symphyotrichum lanceolatum lanceolatum × Symphyotrichum lateriflorum','Symphyotrichum lanceolatum subsp. lanceolatum × Symphyotrichum lateriflorum','Symphyotrichum lanceolat lanceolat × Symphyotrichum lateriflor',0,0,'HYBRID_FORMULA','','','34959aec-d2bf-5de4-9565-0e47394a9f2f','Symphyotrichum lanceolatum subsp. lanceolatum × Symphyotrichum lateriflorum','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32709','','','Symphyotrichum lateriflorum × Symphyotrichum puniceum var. puniceum',2,'Symphyotrichum lateriflorum × Symphyotrichum puniceum puniceum','Symphyotrichum lateriflorum × Symphyotrichum puniceum var. puniceum','Symphyotrichum lateriflor × Symphyotrichum punice punice',0,0,'HYBRID_FORMULA','','','1ac733a1-88aa-5d57-a636-926dae0bb640','Symphyotrichum lateriflorum × Symphyotrichum puniceum var. puniceum','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32713','','','Symphyotrichum lanceolatum subsp. lanceolatum var. lanceolatum × Symphyotrichum novi-belgii var. novi-belgii',2,'Symphyotrichum lanceolatum lanceolatum lanceolatum × Symphyotrichum novi-belgii novi-belgii','Symphyotrichum lanceolatum subsp. lanceolatum var. lanceolatum × Symphyotrichum novi-belgii var. novi-belgii','Symphyotrichum lanceolat lanceolat lanceolat × Symphyotrichum noui-belg noui-belg',0,0,'HYBRID_FORMULA','','','26a89ace-899a-505d-aac0-be7da8b593d7','Symphyotrichum lanceolatum subsp. lanceolatum var. lanceolatum × Symphyotrichum novi-belgii var. novi-belgii','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3528','','','Symphyotrichum ciliatum (Ledebour) G.L. Nesom',1,'Symphyotrichum ciliatum','Symphyotrichum ciliatum','Symphyotrichum ciliat',2,0,'','','Ledebour|G. L. Nesom','42d6f8bd-fafa-5cca-912f-e88f580700df','Symphyotrichum ciliatum (Ledebour) G.L. Nesom','(Ledebour) G.L. Nesom','SPECIES','','Symphyotrichum','','ciliatum','','','',NULL,'G. L. Nesom','','','','','Ledebour','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3585','','','Symphyotrichum spathulatum var. intermedium (A. Gray) G.L. Nesom',1,'Symphyotrichum spathulatum intermedium','Symphyotrichum spathulatum var. intermedium','Symphyotrichum spathulat intermedi',3,0,'','','A. Gray|G. L. Nesom','570dc7d1-896c-5757-a5f8-092404c2fd1e','Symphyotrichum spathulatum var. intermedium (A. Gray) G.L. Nesom','(A. Gray) G.L. Nesom','VARIETY','','Symphyotrichum','','spathulatum','intermedium','','',NULL,'G. L. Nesom','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3541','','','Symphyotrichum foliaceum var. parryi (D.C.  Eaton) G.L. Nesom',1,'Symphyotrichum foliaceum parryi','Symphyotrichum foliaceum var. parryi','Symphyotrichum foliace parry',3,0,'','','D. C. Eaton|G. L. Nesom','57aa4046-fd4b-51db-85e5-11de64869468','Symphyotrichum foliaceum var. parryi (D.C.  Eaton) G.L. Nesom','(D.C.  Eaton) G.L. Nesom','VARIETY','','Symphyotrichum','','foliaceum','parryi','','',NULL,'G. L. Nesom','','','','','D. C. Eaton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9872','','','Symphyotrichum cusickii',1,'Symphyotrichum cusickii','Symphyotrichum cusickii','Symphyotrichum cusick',2,0,'','','','bd162d3f-3a33-5fac-b1b3-f3476d4b510b','Symphyotrichum cusickii','','SPECIES','','Symphyotrichum','','cusickii','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1984','','','Symphyotrichum subg. Ascendentes (P.A. Rydberg) J.C. Semple',2,'Ascendentes','Symphyotrichum subgen. Ascendentes','Ascendentes',1,0,'','','P. A. Rydberg|J. C. Semple','ee178fdc-bedb-57df-b40f-d3a066fc33a3','Symphyotrichum subg. Ascendentes (P.A. Rydberg) J.C. Semple','(P.A. Rydberg) J.C. Semple','SUBGENUS','Ascendentes','','','','','','',NULL,'J. C. Semple','','','','','P. A. Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3594','','','Symphyotrichum ×amethystinum (Nuttall) G.L. Nesom',3,'','','',NULL,NULL,'','','','','Symphyotrichum ×amethystinum (Nuttall) G.L. Nesom','(Nuttall) G.L. Nesom','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3525','','','Symphyotrichum campestre (Nuttall) G.L. Nesom var. campestre',1,'Symphyotrichum campestre campestre','Symphyotrichum campestre var. campestre','Symphyotrichum campestr campestr',3,0,'','','','622e1dc3-3526-5229-b5f5-1de8f2e3ebcb','Symphyotrichum campestre (Nuttall) G.L. Nesom var. campestre','(Nuttall) G.L. Nesom','VARIETY','','Symphyotrichum','','campestre','campestre','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1766','','','Tonestus A. Nelson',1,'Tonestus','Tonestus','Tonestus',1,0,'','','A. Nelson','ded86b5b-1329-551a-8587-4af6bda33022','Tonestus A. Nelson','A. Nelson','GENUS','Tonestus','','','','','','',NULL,'','','','','','A. Nelson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3632','','','Townsendia parryi D.C. Eaton',1,'Townsendia parryi','Townsendia parryi','Townsendia parry',2,0,'','','D. C. Eaton','09fe8f99-55c7-5d77-9b88-58eb212cbca2','Townsendia parryi D.C. Eaton','D.C. Eaton','SPECIES','','Townsendia','','parryi','','','',NULL,'','','','','','D. C. Eaton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3134','','','Xanthisma spinulosum (Pursh) D.R. Morgan & R.L. Hartman var. spinulosum',1,'Xanthisma spinulosum spinulosum','Xanthisma spinulosum var. spinulosum','Xanthisma spinulos spinulos',3,0,'','','','db0df118-b29a-55d9-b498-4352aae3f92d','Xanthisma spinulosum (Pursh) D.R. Morgan & R.L. Hartman var. spinulosum','(Pursh) D.R. Morgan & R.L. Hartman','VARIETY','','Xanthisma','','spinulosum','spinulosum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3354','','','Picradeniopsis oppositifolia (Nuttall) Rydberg ex Britton',2,'Picradeniopsis oppositifolia','Picradeniopsis oppositifolia','Picradeniopsis oppositifol',2,0,'','','Nuttall|Rydberg|Britton','af4d0a8c-f6c7-5f38-a7ce-a68ad4ce1ca7','Picradeniopsis oppositifolia (Nuttall) Rydberg ex Britton','(Nuttall) Rydberg ex Britton','SPECIES','','Picradeniopsis','','oppositifolia','','','',NULL,'Rydberg','','Britton','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('976','','','Chaenactis de Candolle',1,'Chaenactis','Chaenactis','Chaenactis',1,0,'','','de Candolle','d853afbf-8adc-5b53-9050-e7258f289b47','Chaenactis de Candolle','de Candolle','GENUS','Chaenactis','','','','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2979','','','Chaenactis douglasii (Hooker) Hooker & Arnott var. douglasii',1,'Chaenactis douglasii douglasii','Chaenactis douglasii var. douglasii','Chaenactis douglas douglas',3,0,'','','','8da9a31d-8366-5c0f-9924-73514c1e824f','Chaenactis douglasii (Hooker) Hooker & Arnott var. douglasii','(Hooker) Hooker & Arnott','VARIETY','','Chaenactis','','douglasii','douglasii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2928','','','Bidens beckii Torrey ex Sprengel',2,'Bidens beckii','Bidens beckii','Bidens beck',2,0,'','','Torrey|Sprengel','616ee8b9-6918-5ff7-a56e-ff54afad437b','Bidens beckii Torrey ex Sprengel','Torrey ex Sprengel','SPECIES','','Bidens','','beckii','','','',NULL,'','','','','','Torrey','','Sprengel','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2933','','','Bidens eatonii Fernald',1,'Bidens eatonii','Bidens eatonii','Bidens eaton',2,0,'','','Fernald','9cfd177b-cca6-5581-8e7c-c5405bf1538a','Bidens eatonii Fernald','Fernald','SPECIES','','Bidens','','eatonii','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2937','','','Bidens pilosa Linnaeus',1,'Bidens pilosa','Bidens pilosa','Bidens pilos',2,0,'','','Linnaeus','0c669e20-2e48-50a2-bb63-691321e70eb9','Bidens pilosa Linnaeus','Linnaeus','SPECIES','','Bidens','','pilosa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10883','','','Bidens infirma Fernald',1,'Bidens infirma','Bidens infirma','Bidens infirm',2,0,'','','Fernald','9c6f11eb-08a8-55d0-a9f9-c476d00dc30a','Bidens infirma Fernald','Fernald','SPECIES','','Bidens','','infirma','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3012','','','Coreopsis grandiflora Hogg ex Sweet',2,'Coreopsis grandiflora','Coreopsis grandiflora','Coreopsis grandiflor',2,0,'','','Hogg|Sweet','3cf85d14-9c0a-5103-875a-6ba9770ee0fd','Coreopsis grandiflora Hogg ex Sweet','Hogg ex Sweet','SPECIES','','Coreopsis','','grandiflora','','','',NULL,'','','','','','Hogg','','Sweet','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3014','','','Coreopsis rosea Nuttall',1,'Coreopsis rosea','Coreopsis rosea','Coreopsis rose',2,0,'','','Nuttall','91d6db31-bf86-51f4-8d41-9b4545cdac05','Coreopsis rosea Nuttall','Nuttall','SPECIES','','Coreopsis','','rosea','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3627','','','Thelesperma subnudum A. Gray',1,'Thelesperma subnudum','Thelesperma subnudum','Thelesperma subnud',2,0,'','','A. Gray','8a77e6d8-bbe6-5849-8601-9b8f9e323901','Thelesperma subnudum A. Gray','A. Gray','SPECIES','','Thelesperma','','subnudum','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('913','','','Brickellia Elliott',1,'Brickellia','Brickellia','Brickellia',1,0,'','','Elliott','1eb67988-dbb2-5d0e-97a8-7fb110ec4757','Brickellia Elliott','Elliott','GENUS','Brickellia','','','','','','',NULL,'','','','','','Elliott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3009','','','Conoclinium coelestinum (Linnaeus) A. P. de Candolle',1,'Conoclinium coelestinum','Conoclinium coelestinum','Conoclinium coelestin',2,0,'','','Linnaeus|A. P. de Candolle','438ab050-ca54-59ec-b120-d69f08a7e953','Conoclinium coelestinum (Linnaeus) A. P. de Candolle','(Linnaeus) A. P. de Candolle','SPECIES','','Conoclinium','','coelestinum','','','',NULL,'A. P. de Candolle','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3161','','','Eutrochium fistulosum (Barratt) E.E. Lamont',1,'Eutrochium fistulosum','Eutrochium fistulosum','Eutrochium fistulos',2,0,'','','Barratt|E. E. Lamont','8d64eda1-6aae-5053-be9a-f07d198217eb','Eutrochium fistulosum (Barratt) E.E. Lamont','(Barratt) E.E. Lamont','SPECIES','','Eutrochium','','fistulosum','','','',NULL,'E. E. Lamont','','','','','Barratt','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3166','','','Eutrochium purpureum (Linnaeus) E.E. Lamont var. purpureum',1,'Eutrochium purpureum purpureum','Eutrochium purpureum var. purpureum','Eutrochium purpure purpure',3,0,'','','','494af236-c346-52da-a007-66388c776af3','Eutrochium purpureum (Linnaeus) E.E. Lamont var. purpureum','(Linnaeus) E.E. Lamont','VARIETY','','Eutrochium','','purpureum','purpureum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3287','','','Liatris punctata Hooker',1,'Liatris punctata','Liatris punctata','Liatris punctat',2,0,'','','Hooker','84cddeae-e8a4-5678-a4bc-85ab1cf73765','Liatris punctata Hooker','Hooker','SPECIES','','Liatris','','punctata','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1417','','','Mikania Willdenow',1,'Mikania','Mikania','Mikania',1,0,'','','Willdenow','be33fa3a-0708-5d33-b44e-387bef7d4740','Mikania Willdenow','Willdenow','GENUS','Mikania','','','','','','',NULL,'','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('826','','','Antennaria Gaertner',1,'Antennaria','Antennaria','Antennaria',1,0,'','','Gaertner','52803c61-093f-5682-ab42-38bbba36f57d','Antennaria Gaertner','Gaertner','GENUS','Antennaria','','','','','','',NULL,'','','','','','Gaertner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10353','','','Antennaria alpina (Linnaeus) Gaertner subsp. alpina',1,'Antennaria alpina alpina','Antennaria alpina subsp. alpina','Antennaria alpin alpin',3,0,'','','','c7cb4555-a382-5167-a0c7-f9d175966205','Antennaria alpina (Linnaeus) Gaertner subsp. alpina','(Linnaeus) Gaertner','SUBSPECIES','','Antennaria','','alpina','alpina','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2802','','','Antennaria corymbosa E.E. Nelson',1,'Antennaria corymbosa','Antennaria corymbosa','Antennaria corymbos',2,0,'','','E. E. Nelson','873e1d2e-43e0-5ced-8764-4fd89ea2be0e','Antennaria corymbosa E.E. Nelson','E.E. Nelson','SPECIES','','Antennaria','','corymbosa','','','',NULL,'','','','','','E. E. Nelson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2808','','','Antennaria friesiana (Trautvetter) E. Ekman subsp. friesiana',1,'Antennaria friesiana friesiana','Antennaria friesiana subsp. friesiana','Antennaria friesian friesian',3,0,'','','','2b62373c-bbc8-50f6-90c3-502a3ccf9388','Antennaria friesiana (Trautvetter) E. Ekman subsp. friesiana','(Trautvetter) E. Ekman','SUBSPECIES','','Antennaria','','friesiana','friesiana','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2815','','','Antennaria lanata (Hooker) Greene',1,'Antennaria lanata','Antennaria lanata','Antennaria lanat',2,0,'','','Hooker|Greene','40898b3d-b9df-5f25-8bdc-3ad4a386d709','Antennaria lanata (Hooker) Greene','(Hooker) Greene','SPECIES','','Antennaria','','lanata','','','',NULL,'Greene','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2821','','','Antennaria monocephala de Candolle',1,'Antennaria monocephala','Antennaria monocephala','Antennaria monocephal',2,0,'','','de Candolle','52e98d63-9af0-5d07-a3e4-d22b9911eb39','Antennaria monocephala de Candolle','de Candolle','SPECIES','','Antennaria','','monocephala','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2827','','','Antennaria parvifolia Nuttall',1,'Antennaria parvifolia','Antennaria parvifolia','Antennaria paruifol',2,0,'','','Nuttall','e3bb8aaa-84ac-50c3-9c92-d367d88e819e','Antennaria parvifolia Nuttall','Nuttall','SPECIES','','Antennaria','','parvifolia','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2833','','','Antennaria racemosa Hooker',1,'Antennaria racemosa','Antennaria racemosa','Antennaria racemos',2,0,'','','Hooker','24fbb7a7-84e0-5b07-8ff7-bf40b7a978e2','Antennaria racemosa Hooker','Hooker','SPECIES','','Antennaria','','racemosa','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2837','','','Antennaria rosea subsp. pulvinata (Greene) R.J. Bayer',1,'Antennaria rosea pulvinata','Antennaria rosea subsp. pulvinata','Antennaria rose puluinat',3,0,'','','Greene|R. J. Bayer','56563c31-fd3e-5c98-879b-e6b2eff87302','Antennaria rosea subsp. pulvinata (Greene) R.J. Bayer','(Greene) R.J. Bayer','SUBSPECIES','','Antennaria','','rosea','pulvinata','','',NULL,'R. J. Bayer','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11683','','','Filago arvensis Linnaeus',1,'Filago arvensis','Filago arvensis','Filago aruens',2,0,'','','Linnaeus','eda560b6-23ed-5ca3-b695-9a9bb68f4397','Filago arvensis Linnaeus','Linnaeus','SPECIES','','Filago','','arvensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3177','','','Gamochaeta ustulata (Nuttall) J. Holub',1,'Gamochaeta ustulata','Gamochaeta ustulata','Gamochaeta ustulat',2,0,'','','Nuttall|J. Holub','ddbb62fa-3d27-5fd2-991d-a3ab7eb04a4a','Gamochaeta ustulata (Nuttall) J. Holub','(Nuttall) J. Holub','SPECIES','','Gamochaeta','','ustulata','','','',NULL,'J. Holub','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1476','','','Omalotheca Cassini',1,'Omalotheca','Omalotheca','Omalotheca',1,0,'','','Cassini','93fc2a6d-5b17-5c73-975f-5ea46b9fa646','Omalotheca Cassini','Cassini','GENUS','Omalotheca','','','','','','',NULL,'','','','','','Cassini','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3367','','','Pseudognaphalium macounii (Greene) Kartesz',1,'Pseudognaphalium macounii','Pseudognaphalium macounii','Pseudognaphalium macoun',2,0,'','','Greene|Kartesz','72daf66f-78d4-5e97-9b17-43db5bfdd7c5','Pseudognaphalium macounii (Greene) Kartesz','(Greene) Kartesz','SPECIES','','Pseudognaphalium','','macounii','','','',NULL,'Kartesz','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32922','','','Pseudognaphalium luteoalbum (Linnaeus) Hilliard & B.L. Burtt',1,'Pseudognaphalium luteoalbum','Pseudognaphalium luteoalbum','Pseudognaphalium luteoalb',2,0,'','','Linnaeus|Hilliard|B. L. Burtt','d68e6426-0da6-51e5-96d6-51a9103a681b','Pseudognaphalium luteoalbum (Linnaeus) Hilliard & B.L. Burtt','(Linnaeus) Hilliard & B.L. Burtt','SPECIES','','Pseudognaphalium','','luteoalbum','','','',NULL,'Hilliard & B. L. Burtt','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1187','','','Gaillardia Fougeroux',1,'Gaillardia','Gaillardia','Gaillardia',1,0,'','','Fougeroux','4b6c14e6-9213-5096-a608-2cfb942e3262','Gaillardia Fougeroux','Fougeroux','GENUS','Gaillardia','','','','','','',NULL,'','','','','','Fougeroux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1273','','','Hymenoxys Cassini',1,'Hymenoxys','Hymenoxys','Hymenoxys',1,0,'','','Cassini','f427f0e6-a692-59e2-858f-2dd9d1c71f37','Hymenoxys Cassini','Cassini','GENUS','Hymenoxys','','','','','','',NULL,'','','','','','Cassini','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3626','','','Tetraneuris herbacea Greene',1,'Tetraneuris herbacea','Tetraneuris herbacea','Tetraneuris herbace',2,0,'','','Greene','bfe52e92-ab3a-526f-831b-57252e83148f','Tetraneuris herbacea Greene','Greene','SPECIES','','Tetraneuris','','herbacea','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('768','','','Acanthospermum Schrank',1,'Acanthospermum','Acanthospermum','Acanthospermum',1,0,'','','Schrank','961f7cff-e6b2-578c-a7b8-2f7645376217','Acanthospermum Schrank','Schrank','GENUS','Acanthospermum','','','','','','',NULL,'','','','','','Schrank','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2792','','','Ambrosia artemisiifolia Linnaeus',1,'Ambrosia artemisiifolia','Ambrosia artemisiifolia','Ambrosia artemisiifol',2,0,'','','Linnaeus','dd504f1f-5508-50e6-a565-e6fa3f27d8da','Ambrosia artemisiifolia Linnaeus','Linnaeus','SPECIES','','Ambrosia','','artemisiifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('885','','','Balsamorhiza Hooker',1,'Balsamorhiza','Balsamorhiza','Balsamorhiza',1,0,'','','Hooker','f437971c-8a2a-5937-b797-718e1b5fa0cc','Balsamorhiza Hooker','Hooker','GENUS','Balsamorhiza','','','','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2923','','','Balsamorhiza hookeri Nuttall',1,'Balsamorhiza hookeri','Balsamorhiza hookeri','Balsamorhiza hooker',2,0,'','','Nuttall','a1524a7a-b9db-585f-9725-6d708794e0c0','Balsamorhiza hookeri Nuttall','Nuttall','SPECIES','','Balsamorhiza','','hookeri','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1117','','','Echinacea Moench',1,'Echinacea','Echinacea','Echinacea',1,0,'','','Moench','c6d84124-5d2d-5c81-9c24-74af4cdb6296','Echinacea Moench','Moench','GENUS','Echinacea','','','','','','',NULL,'','','','','','Moench','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1122','','','Eclipta Linnaeus',1,'Eclipta','Eclipta','Eclipta',1,0,'','','Linnaeus','cfa55919-4d2d-5d8f-a697-93fae602727e','Eclipta Linnaeus','Linnaeus','GENUS','Eclipta','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3173','','','Galinsoga parviflora Cavanilles var. parviflora',1,'Galinsoga parviflora parviflora','Galinsoga parviflora var. parviflora','Galinsoga paruiflor paruiflor',3,0,'','','','e8879c2c-646d-5895-98ef-ef819ab98658','Galinsoga parviflora Cavanilles var. parviflora','Cavanilles','VARIETY','','Galinsoga','','parviflora','parviflora','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1233','','','Helianthella Torrey & A. Gray',1,'Helianthella','Helianthella','Helianthella',1,0,'','','Torrey|A. Gray','d2da3623-bf90-513d-80bd-19594ec9ed13','Helianthella Torrey & A. Gray','Torrey & A. Gray','GENUS','Helianthella','','','','','','',NULL,'','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3193','','','Helianthus giganteus Linnaeus',1,'Helianthus giganteus','Helianthus giganteus','Helianthus gigante',2,0,'','','Linnaeus','bbaad761-451b-5c19-b494-148820583575','Helianthus giganteus Linnaeus','Linnaeus','SPECIES','','Helianthus','','giganteus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3195','','','Helianthus hirsutus Rafinesque',1,'Helianthus hirsutus','Helianthus hirsutus','Helianthus hirsut',2,0,'','','Rafinesque','67e281a2-31c6-5dab-87c0-dc97fb3be23e','Helianthus hirsutus Rafinesque','Rafinesque','SPECIES','','Helianthus','','hirsutus','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3208','','','Helianthus ×laetiflorus Persoon',3,'','','',NULL,NULL,'','','','','Helianthus ×laetiflorus Persoon','Persoon','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3202','','','Helianthus pauciflorus Nuttall',1,'Helianthus pauciflorus','Helianthus pauciflorus','Helianthus pauciflor',2,0,'','','Nuttall','a6f4049a-164e-5975-9500-8975b494e13d','Helianthus pauciflorus Nuttall','Nuttall','SPECIES','','Helianthus','','pauciflorus','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3205','','','Helianthus petiolaris Nuttall',1,'Helianthus petiolaris','Helianthus petiolaris','Helianthus petiolar',2,0,'','','Nuttall','63a52927-9124-5684-871c-f8a72a79d8bb','Helianthus petiolaris Nuttall','Nuttall','SPECIES','','Helianthus','','petiolaris','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3210','','','Heliopsis helianthoides (Linnaeus) Sweet',1,'Heliopsis helianthoides','Heliopsis helianthoides','Heliopsis helianthoid',2,0,'','','Linnaeus|Sweet','36b60375-7f06-5200-b982-cf20a3c89472','Heliopsis helianthoides (Linnaeus) Sweet','(Linnaeus) Sweet','SPECIES','','Heliopsis','','helianthoides','','','',NULL,'Sweet','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1613','','','Ratibida Rafinesque',1,'Ratibida','Ratibida','Ratibida',1,0,'','','Rafinesque','3958b375-f24c-531e-9e34-8e975a78aba0','Ratibida Rafinesque','Rafinesque','GENUS','Ratibida','','','','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3386','','','Rudbeckia grandiflora (Sweet) C.C. Gmelin ex de Candolle',2,'Rudbeckia grandiflora','Rudbeckia grandiflora','Rudbeckia grandiflor',2,0,'','','Sweet|C. C. Gmelin|de Candolle','9cfe9c0e-9c94-55b7-ba28-c1f9752342d9','Rudbeckia grandiflora (Sweet) C.C. Gmelin ex de Candolle','(Sweet) C.C. Gmelin ex de Candolle','SPECIES','','Rudbeckia','','grandiflora','','','',NULL,'C. C. Gmelin','','de Candolle','','','Sweet','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2074','','','Rudbeckia sect. Macrocline Torrey',2,'Macrocline','Rudbeckia sect. Macrocline','Macrocline',1,0,'','','Torrey','e5964b3e-3e6b-5bf6-843e-a6608f9d7489','Rudbeckia sect. Macrocline Torrey','Torrey','SECTION','Macrocline','','','','','','',NULL,'','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1687','','','Silphium Linnaeus',1,'Silphium','Silphium','Silphium',1,0,'','','Linnaeus','301fd125-1dfa-54dc-9e71-bfd9e6dea7db','Silphium Linnaeus','Linnaeus','GENUS','Silphium','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3431','','','Silphium perfoliatum Linnaeus',1,'Silphium perfoliatum','Silphium perfoliatum','Silphium perfoliat',2,0,'','','Linnaeus','647417d3-620a-5b01-864b-7673a3648310','Silphium perfoliatum Linnaeus','Linnaeus','SPECIES','','Silphium','','perfoliatum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1815','','','Verbesina Linnaeus',1,'Verbesina','Verbesina','Verbesina',1,0,'','','Linnaeus','2627bfc4-5396-5139-85f6-3f7b820185d7','Verbesina Linnaeus','Linnaeus','GENUS','Verbesina','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3645','','','Verbesina alternifolia (Linnaeus) Britton ex Kearney',2,'Verbesina alternifolia','Verbesina alternifolia','Verbesina alternifol',2,0,'','','Linnaeus|Britton|Kearney','93e34042-16fb-55af-b674-80eef020ecd1','Verbesina alternifolia (Linnaeus) Britton ex Kearney','(Linnaeus) Britton ex Kearney','SPECIES','','Verbesina','','alternifolia','','','',NULL,'Britton','','Kearney','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3652','','','Xanthium spinosum Linnaeus',1,'Xanthium spinosum','Xanthium spinosum','Xanthium spinos',2,0,'','','Linnaeus','f958f56b-fbeb-562d-b4d8-1240706b80b4','Xanthium spinosum Linnaeus','Linnaeus','SPECIES','','Xanthium','','spinosum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1564','','','Pluchea Cassini',1,'Pluchea','Pluchea','Pluchea',1,0,'','','Cassini','34606d97-2f35-5daf-a18d-2d9cd7c1224b','Pluchea Cassini','Cassini','GENUS','Pluchea','','','','','','',NULL,'','','','','','Cassini','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('446','','','Madieae',1,'Madieae','Madieae','Madieae',1,0,'','','','b494e34f-577c-52c9-96fe-7a55a9767f24','Madieae','','TRIBE','Madieae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1867','','','Anisocarpus Nuttall',1,'Anisocarpus','Anisocarpus','Anisocarpus',1,0,'','','Nuttall','07d8784c-6221-5502-b360-fd1279af24fc','Anisocarpus Nuttall','Nuttall','GENUS','Anisocarpus','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2855','','','Arnica chamissonis Lessing',1,'Arnica chamissonis','Arnica chamissonis','Arnica chamisson',2,0,'','','Lessing','c8643980-1ed1-5e91-a270-b226162f9b46','Arnica chamissonis Lessing','Lessing','SPECIES','','Arnica','','chamissonis','','','',NULL,'','','','','','Lessing','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2866','','','Arnica lessingii (Torrey & A. Gray) Greene',1,'Arnica lessingii','Arnica lessingii','Arnica lessing',2,0,'','','Torrey|A. Gray|Greene','486b996f-46be-5c7c-b8bc-bdf475d51a1a','Arnica lessingii (Torrey & A. Gray) Greene','(Torrey & A. Gray) Greene','SPECIES','','Arnica','','lessingii','','','',NULL,'Greene','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2872','','','Arnica parryi A. Gray',1,'Arnica parryi','Arnica parryi','Arnica parry',2,0,'','','A. Gray','c78b7ba7-fda5-5bf8-af5c-62991ab4df6a','Arnica parryi A. Gray','A. Gray','SPECIES','','Arnica','','parryi','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2860','','','Arnica griscomii Fernald',1,'Arnica griscomii','Arnica griscomii','Arnica griscom',2,0,'','','Fernald','b05781e9-6778-5fe0-99ee-1c2c14c7d226','Arnica griscomii Fernald','Fernald','SPECIES','','Arnica','','griscomii','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2862','','','Arnica lanceolata subsp. prima (Maguire) Strother & S.J. Wolf',1,'Arnica lanceolata prima','Arnica lanceolata subsp. prima','Arnica lanceolat prim',3,0,'','','Maguire|Strother|S. J. Wolf','c0c83492-4537-5e86-bf0a-e9104901f61a','Arnica lanceolata subsp. prima (Maguire) Strother & S.J. Wolf','(Maguire) Strother & S.J. Wolf','SUBSPECIES','','Arnica','','lanceolata','prima','','',NULL,'Strother & S. J. Wolf','','','','','Maguire','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1153','','','Eriophyllum Lagasca',1,'Eriophyllum','Eriophyllum','Eriophyllum',1,0,'','','Lagasca','1e48bf0b-d396-5c38-8b97-5a7b04f94b26','Eriophyllum Lagasca','Lagasca','GENUS','Eriophyllum','','','','','','',NULL,'','','','','','Lagasca','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3139','','','Eriophyllum lanatum var. leucophyllum (de Candolle) W.R. Carter',1,'Eriophyllum lanatum leucophyllum','Eriophyllum lanatum var. leucophyllum','Eriophyllum lanat leucophyll',3,0,'','','de Candolle|W. R. Carter','cf86d891-182a-5447-bcc7-884739a7b246','Eriophyllum lanatum var. leucophyllum (de Candolle) W.R. Carter','(de Candolle) W.R. Carter','VARIETY','','Eriophyllum','','lanatum','leucophyllum','','',NULL,'W. R. Carter','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1319','','','Lasthenia Cassini',1,'Lasthenia','Lasthenia','Lasthenia',1,0,'','','Cassini','8eb00d04-4e7e-58ce-bedd-acc6b0bd778c','Lasthenia Cassini','Cassini','GENUS','Lasthenia','','','','','','',NULL,'','','','','','Cassini','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3274','','','Layia glandulosa (Hooker) Hooker & Arnott',1,'Layia glandulosa','Layia glandulosa','Layia glandulos',2,0,'','','Hooker|Arnott','11d1202e-5b46-5439-a561-87551f8fc9f2','Layia glandulosa (Hooker) Hooker & Arnott','(Hooker) Hooker & Arnott','SPECIES','','Layia','','glandulosa','','','',NULL,'Hooker & Arnott','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3299','','','Madia glomerata Hooker',1,'Madia glomerata','Madia glomerata','Madia glomerat',2,0,'','','Hooker','471cbe42-910e-50b9-b53f-9841dbc9e18f','Madia glomerata Hooker','Hooker','SPECIES','','Madia','','glomerata','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('447','','','Senecioneae',1,'Senecioneae','Senecioneae','Senecioneae',1,0,'','','','ac7217ba-78bd-53d0-a5b0-329874c8df80','Senecioneae','','TRIBE','Senecioneae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('925','','','Cacaliopsis A. Gray',1,'Cacaliopsis','Cacaliopsis','Cacaliopsis',1,0,'','','A. Gray','ed15bf79-3077-5661-ac1f-bfb1db82c85c','Cacaliopsis A. Gray','A. Gray','GENUS','Cacaliopsis','','','','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1145','','','Erechtites Rafinesque',1,'Erechtites','Erechtites','Erechtites',1,0,'','','Rafinesque','7362629e-4826-52ea-919b-8f9f2c3f1bf6','Erechtites Rafinesque','Rafinesque','GENUS','Erechtites','','','','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1899','','','Jacobaea Miller',1,'Jacobaea','Jacobaea','Jacobaea',1,0,'','','Miller','4d4cda04-a3b8-58bb-b1ec-8db905235088','Jacobaea Miller','Miller','GENUS','Jacobaea','','','','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1373','','','Luina Bentham',1,'Luina','Luina','Luina',1,0,'','','Bentham','afa01913-1451-5440-9fb3-644138002e4b','Luina Bentham','Bentham','GENUS','Luina','','','','','','',NULL,'','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3321','','','Packera aurea (Linnaeus) Á. Löve & D. Löve',1,'Packera aurea','Packera aurea','Packera aure',2,0,'','','Linnaeus|Á. Löve|D. Löve','4e81f854-3886-54eb-a600-d28d418e7620','Packera aurea (Linnaeus) Á. Löve & D. Löve','(Linnaeus) Á. Löve & D. Löve','SPECIES','','Packera','','aurea','','','',NULL,'Á. Löve & D. Löve','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3329','','','Packera indecora (Greene) Á. Löve & D. Löve',1,'Packera indecora','Packera indecora','Packera indecor',2,0,'','','Greene|Á. Löve|D. Löve','e844e06c-df6b-5abb-8543-64577cc9613a','Packera indecora (Greene) Á. Löve & D. Löve','(Greene) Á. Löve & D. Löve','SPECIES','','Packera','','indecora','','','',NULL,'Á. Löve & D. Löve','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3333','','','Packera pauciflora (Pursh) Á. Löve & D. Löve',1,'Packera pauciflora','Packera pauciflora','Packera pauciflor',2,0,'','','Pursh|Á. Löve|D. Löve','1dd4ebea-f957-5107-aac1-59d4909842cf','Packera pauciflora (Pursh) Á. Löve & D. Löve','(Pursh) Á. Löve & D. Löve','SPECIES','','Packera','','pauciflora','','','',NULL,'Á. Löve & D. Löve','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30511','','','Packera paupercula var. savannarum R. Kowal',1,'Packera paupercula savannarum','Packera paupercula var. savannarum','Packera paupercul sauannar',3,0,'','','R. Kowal','4438eef6-6d94-5575-a28a-54543938b54b','Packera paupercula var. savannarum R. Kowal','R. Kowal','VARIETY','','Packera','','paupercula','savannarum','','',NULL,'','','','','','R. Kowal','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3335','','','Packera plattensis (Nuttall) W.A. Weber & Á. Löve',1,'Packera plattensis','Packera plattensis','Packera plattens',2,0,'','','Nuttall|W. A. Weber|Á. Löve','b7defb6a-26f4-54b9-9826-a1419b8ef679','Packera plattensis (Nuttall) W.A. Weber & Á. Löve','(Nuttall) W.A. Weber & Á. Löve','SPECIES','','Packera','','plattensis','','','',NULL,'W. A. Weber & Á. Löve','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3336','','','Packera pseudaurea (Rydberg) W.A. Weber & Á. Löve var. pseudaurea',1,'Packera pseudaurea pseudaurea','Packera pseudaurea var. pseudaurea','Packera pseudaure pseudaure',3,0,'','','','e3138157-4009-57ed-a1f9-82742a7e9369','Packera pseudaurea (Rydberg) W.A. Weber & Á. Löve var. pseudaurea','(Rydberg) W.A. Weber & Á. Löve','VARIETY','','Packera','','pseudaurea','pseudaurea','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31159','','','Packera heterophylla (Fischer) E. Wiebe',1,'Packera heterophylla','Packera heterophylla','Packera heterophyll',2,0,'','','Fischer|E. Wiebe','36e78416-f0f4-59e7-83bc-739a5e4b089c','Packera heterophylla (Fischer) E. Wiebe','(Fischer) E. Wiebe','SPECIES','','Packera','','heterophylla','','','',NULL,'E. Wiebe','','','','','Fischer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3350','','','Petasites frigidus var. palmatus (Aiton) Cronquist',1,'Petasites frigidus palmatus','Petasites frigidus var. palmatus','Petasites frigid palmat',3,0,'','','Aiton|Cronquist','7f0bbd23-6e0b-55fb-b8d2-417f13d463f7','Petasites frigidus var. palmatus (Aiton) Cronquist','(Aiton) Cronquist','VARIETY','','Petasites','','frigidus','palmatus','','',NULL,'Cronquist','','','','','Aiton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3352','','','Petasites frigidus var. ×vitifolius (Greene) Cherniawsky',4,'','','',NULL,NULL,'','','','','Petasites frigidus var. ×vitifolius (Greene) Cherniawsky','(Greene) Cherniawsky','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3407','','','Senecio hydrophiloides Rydberg',1,'Senecio hydrophiloides','Senecio hydrophiloides','Senecio hydrophiloid',2,0,'','','Rydberg','d35bab2a-f7c0-593d-baa1-a1918519de36','Senecio hydrophiloides Rydberg','Rydberg','SPECIES','','Senecio','','hydrophiloides','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3417','','','Senecio pseudoarnica Lessing',1,'Senecio pseudoarnica','Senecio pseudoarnica','Senecio pseudoarnic',2,0,'','','Lessing','7c7a61a1-9d95-5af4-8c40-bb5fad71bcf6','Senecio pseudoarnica Lessing','Lessing','SPECIES','','Senecio','','pseudoarnica','','','',NULL,'','','','','','Lessing','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3421','','','Senecio sylvaticus Linnaeus',1,'Senecio sylvaticus','Senecio sylvaticus','Senecio syluatic',2,0,'','','Linnaeus','cb2988e9-16a9-5602-98ea-436dd224851f','Senecio sylvaticus Linnaeus','Linnaeus','SPECIES','','Senecio','','sylvaticus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3423','','','Senecio viscosus Linnaeus',1,'Senecio viscosus','Senecio viscosus','Senecio uiscos',2,0,'','','Linnaeus','f1a829e9-3e43-5004-9b17-1234a07fe24e','Senecio viscosus Linnaeus','Linnaeus','SPECIES','','Senecio','','viscosus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3409','','','Senecio integerrimus var. exaltatus (Nuttall) Cronquist',1,'Senecio integerrimus exaltatus','Senecio integerrimus var. exaltatus','Senecio integerrim exaltat',3,0,'','','Nuttall|Cronquist','6410b0f2-bf34-5bf4-b0a3-8ace4d6d44fd','Senecio integerrimus var. exaltatus (Nuttall) Cronquist','(Nuttall) Cronquist','VARIETY','','Senecio','','integerrimus','exaltatus','','',NULL,'Cronquist','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3412','','','Senecio integerrimus var. ochroleucus (A. Gray) Cronquist',1,'Senecio integerrimus ochroleucus','Senecio integerrimus var. ochroleucus','Senecio integerrim ochroleuc',3,0,'','','A. Gray|Cronquist','23969e3b-3440-55c4-86ef-fa1773915533','Senecio integerrimus var. ochroleucus (A. Gray) Cronquist','(A. Gray) Cronquist','VARIETY','','Senecio','','integerrimus','ochroleucus','','',NULL,'Cronquist','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1745','','','Tephroseris (Reichenbach) Reichenbach',2,'Tephroseris','Tephroseris','Tephroseris',1,0,'','','Reichenbach','7261394a-5784-571a-a5c5-d6fa8e5e03a2','Tephroseris (Reichenbach) Reichenbach','(Reichenbach) Reichenbach','GENUS','Tephroseris','','','','','','',NULL,'Reichenbach','','','','','Reichenbach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3621','','','Tephroseris palustris (Linnaeus) Reichenbach',1,'Tephroseris palustris','Tephroseris palustris','Tephroseris palustr',2,0,'','','Linnaeus|Reichenbach','ad219a33-db24-5268-95f3-b281464f3afa','Tephroseris palustris (Linnaeus) Reichenbach','(Linnaeus) Reichenbach','SPECIES','','Tephroseris','','palustris','','','',NULL,'Reichenbach','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1798','','','Tussilago Linnaeus',1,'Tussilago','Tussilago','Tussilago',1,0,'','','Linnaeus','78815137-082c-52ca-9790-1cc8ed1f5535','Tussilago Linnaeus','Linnaeus','GENUS','Tussilago','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1738','','','Tagetes Linnaeus',1,'Tagetes','Tagetes','Tagetes',1,0,'','','Linnaeus','57e771bd-8fb4-5951-b3b9-b84851ff530b','Tagetes Linnaeus','Linnaeus','GENUS','Tagetes','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('249','','','Carduoideae',1,'Carduoideae','Carduoideae','Carduoideae',1,0,'','','','ba4d1926-ce8c-591d-a019-d28cfcdbfbce','Carduoideae','','SUBFAMILY','Carduoideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('775','','','Rhaponticum Ludwig',1,'Rhaponticum','Rhaponticum','Rhaponticum',1,0,'','','Ludwig','3790b06b-69d9-52ce-8ce8-e227f49a2a31','Rhaponticum Ludwig','Ludwig','GENUS','Rhaponticum','','','','','','',NULL,'','','','','','Ludwig','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2849','','','Arctium tomentosum Miller',1,'Arctium tomentosum','Arctium tomentosum','Arctium tomentos',2,0,'','','Miller','ab663db0-801f-5d52-ac16-bb6c7a46f561','Arctium tomentosum Miller','Miller','SPECIES','','Arctium','','tomentosum','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2953','','','Carduus acanthoides Linnaeus',1,'Carduus acanthoides','Carduus acanthoides','Carduus acanthoid',2,0,'','','Linnaeus','3fd1cab4-d500-5620-94b1-1ca523c42e76','Carduus acanthoides Linnaeus','Linnaeus','SPECIES','','Carduus','','acanthoides','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2957','','','Carduus nutans Linnaeus subsp. nutans',1,'Carduus nutans nutans','Carduus nutans subsp. nutans','Carduus nutans nutans',3,0,'','','','caaa76b2-ca06-5628-88db-2d1c5a2ea129','Carduus nutans Linnaeus subsp. nutans','Linnaeus','SUBSPECIES','','Carduus','','nutans','nutans','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2959','','','Carthamus creticus Linnaeus',1,'Carthamus creticus','Carthamus creticus','Carthamus cretic',2,0,'','','Linnaeus','babcb74e-962c-5dca-a98a-b34968326204','Carthamus creticus Linnaeus','Linnaeus','SPECIES','','Carthamus','','creticus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2969','','','Centaurea nigra Linnaeus',1,'Centaurea nigra','Centaurea nigra','Centaurea nigr',2,0,'','','Linnaeus','b2be27b2-9846-5584-ac49-b885090d3a83','Centaurea nigra Linnaeus','Linnaeus','SPECIES','','Centaurea','','nigra','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2971','','','Centaurea scabiosa Linnaeus',1,'Centaurea scabiosa','Centaurea scabiosa','Centaurea scabios',2,0,'','','Linnaeus','82503994-936d-5dc8-8438-063121169dde','Centaurea scabiosa Linnaeus','Linnaeus','SPECIES','','Centaurea','','scabiosa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2976','','','Centaurea ×psammogena Gáyer',3,'','','',NULL,NULL,'','','','','Centaurea ×psammogena Gáyer','Gáyer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('999','','','Cirsium Miller',1,'Cirsium','Cirsium','Cirsium',1,0,'','','Miller','ce9de4c8-3c8d-598d-9267-50b2ffd3c3de','Cirsium Miller','Miller','GENUS','Cirsium','','','','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2994','','','Cirsium flodmanii (Rydberg) Arthur',1,'Cirsium flodmanii','Cirsium flodmanii','Cirsium flodman',2,0,'','','Rydberg|Arthur','4c712cb4-91a3-51c7-8141-6d4ee2a2d481','Cirsium flodmanii (Rydberg) Arthur','(Rydberg) Arthur','SPECIES','','Cirsium','','flodmanii','','','',NULL,'Arthur','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2997','','','Cirsium hookerianum Nuttall',1,'Cirsium hookerianum','Cirsium hookerianum','Cirsium hookerian',2,0,'','','Nuttall','06a80e89-5f08-5644-803f-73db9aec6539','Cirsium hookerianum Nuttall','Nuttall','SPECIES','','Cirsium','','hookerianum','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2993','','','Cirsium edule Nuttall',1,'Cirsium edule','Cirsium edule','Cirsium edul',2,0,'','','Nuttall','a48e8a50-1530-514c-be07-09cfdaaa0506','Cirsium edule Nuttall','Nuttall','SPECIES','','Cirsium','','edule','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1120','','','Echinops Linnaeus',1,'Echinops','Echinops','Echinops',1,0,'','','Linnaeus','9c2c0e63-c69b-5507-b50a-eeb929c0ef19','Echinops Linnaeus','Linnaeus','GENUS','Echinops','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3062','','','Echinops sphaerocephalus Linnaeus',1,'Echinops sphaerocephalus','Echinops sphaerocephalus','Echinops sphaerocephal',2,0,'','','Linnaeus','fb67b6b5-c403-5604-977c-363a774dbe29','Echinops sphaerocephalus Linnaeus','Linnaeus','SPECIES','','Echinops','','sphaerocephalus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3397','','','Saussurea americana D.C. Eaton',1,'Saussurea americana','Saussurea americana','Saussurea american',2,0,'','','D. C. Eaton','1075dacf-421a-5b63-b749-c5b82c09ac1f','Saussurea americana D.C. Eaton','D.C. Eaton','SPECIES','','Saussurea','','americana','','','',NULL,'','','','','','D. C. Eaton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3399','','','Saussurea angustifolia (Linnaeus) de Candolle',1,'Saussurea angustifolia','Saussurea angustifolia','Saussurea angustifol',2,0,'','','Linnaeus|de Candolle','54c5e2c9-6ccb-5b4d-a169-9fefe01e15fa','Saussurea angustifolia (Linnaeus) de Candolle','(Linnaeus) de Candolle','SPECIES','','Saussurea','','angustifolia','','','',NULL,'de Candolle','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1856','','','Amberboa (Persoon) Lessing',2,'Amberboa','Amberboa','Amberboa',1,0,'','','Persoon|Lessing','7f1bd85f-2450-5430-adfe-e17562f1570f','Amberboa (Persoon) Lessing','(Persoon) Lessing','GENUS','Amberboa','','','','','','',NULL,'Lessing','','','','','Persoon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('256','','','Cichorioideae',1,'Cichorioideae','Cichorioideae','Cichorioideae',1,0,'','','','269f4d95-0d85-5768-bc0c-100595d2add7','Cichorioideae','','SUBFAMILY','Cichorioideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('788','','','Agoseris Rafinesque',1,'Agoseris','Agoseris','Agoseris',1,0,'','','Rafinesque','7f189b0d-48cc-5558-a74f-32f435f622ef','Agoseris Rafinesque','Rafinesque','GENUS','Agoseris','','','','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2780','','','Agoseris glauca var. dasycephala (Torrey & A. Gray) Jepson',1,'Agoseris glauca dasycephala','Agoseris glauca var. dasycephala','Agoseris glauc dasycephal',3,0,'','','Torrey|A. Gray|Jepson','43894144-242b-59d2-b9a7-5774bc3cf5e6','Agoseris glauca var. dasycephala (Torrey & A. Gray) Jepson','(Torrey & A. Gray) Jepson','VARIETY','','Agoseris','','glauca','dasycephala','','',NULL,'Jepson','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2980','','','Chondrilla juncea Linnaeus',1,'Chondrilla juncea','Chondrilla juncea','Chondrilla iunce',2,0,'','','Linnaeus','e0c42126-3ee3-53cf-b124-d20d040c5786','Chondrilla juncea Linnaeus','Linnaeus','SPECIES','','Chondrilla','','juncea','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3024','','','Crepis biennis Linnaeus',1,'Crepis biennis','Crepis biennis','Crepis bienn',2,0,'','','Linnaeus','783a7809-216f-5539-903e-228edc8635d5','Crepis biennis Linnaeus','Linnaeus','SPECIES','','Crepis','','biennis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3027','','','Crepis intermedia A. Gray',1,'Crepis intermedia','Crepis intermedia','Crepis intermed',2,0,'','','A. Gray','e2c75cf6-11a3-522d-8de5-ba5616072b1a','Crepis intermedia A. Gray','A. Gray','SPECIES','','Crepis','','intermedia','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3033','','','Crepis occidentalis subsp. conjuncta Babcock & Stebbins',1,'Crepis occidentalis conjuncta','Crepis occidentalis subsp. conjuncta','Crepis occidental coniunct',3,0,'','','Babcock|Stebbins','4ff8e3ab-50ef-5e52-a1c3-4eb071cdcc05','Crepis occidentalis subsp. conjuncta Babcock & Stebbins','Babcock & Stebbins','SUBSPECIES','','Crepis','','occidentalis','conjuncta','','',NULL,'','','','','','Babcock & Stebbins','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3042','','','Crepis runcinata (E. James) Torrey & A. Gray subsp. runcinata',1,'Crepis runcinata runcinata','Crepis runcinata subsp. runcinata','Crepis runcinat runcinat',3,0,'','','','261a731e-2d31-5392-98d0-65029f0f4359','Crepis runcinata (E. James) Torrey & A. Gray subsp. runcinata','(E. James) Torrey & A. Gray','SUBSPECIES','','Crepis','','runcinata','runcinata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3219','','','Hieracium albiflorum Hooker',1,'Hieracium albiflorum','Hieracium albiflorum','Hieracium albiflor',2,0,'','','Hooker','784c104e-c158-5b1f-ba10-b3c33b028a5d','Hieracium albiflorum Hooker','Hooker','SPECIES','','Hieracium','','albiflorum','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3226','','','Hieracium longipilum Torrey ex Hooker',2,'Hieracium longipilum','Hieracium longipilum','Hieracium longipil',2,0,'','','Torrey|Hooker','e7251e2e-891d-5191-a384-02f13ed33d81','Hieracium longipilum Torrey ex Hooker','Torrey ex Hooker','SPECIES','','Hieracium','','longipilum','','','',NULL,'','','','','','Torrey','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3236','','','Hieracium scouleri Hooker',1,'Hieracium scouleri','Hieracium scouleri','Hieracium scouler',2,0,'','','Hooker','aa2a2a6f-da07-5a0f-ab58-a78ee051a903','Hieracium scouleri Hooker','Hooker','SPECIES','','Hieracium','','scouleri','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29117','','','Hieracium ×fassettii Lepage',3,'','','',NULL,NULL,'','','','','Hieracium ×fassettii Lepage','Lepage','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30727','','','Hieracium laevigatum subsp. tridentatum (Fries) Čelakovský',1,'Hieracium laevigatum tridentatum','Hieracium laevigatum subsp. tridentatum','Hieracium laeuigat tridentat',3,0,'','','Fries|Čelakovský','7b9e5ee5-e862-5103-b276-17d52e196c75','Hieracium laevigatum subsp. tridentatum (Fries) Čelakovský','(Fries) Čelakovský','SUBSPECIES','','Hieracium','','laevigatum','tridentatum','','',NULL,'Čelakovský','','','','','Fries','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1276','','','Hypochaeris Linnaeus',1,'Hypochaeris','Hypochaeris','Hypochaeris',1,0,'','','Linnaeus','42ac35be-0301-5981-96f4-42c42e4c80db','Hypochaeris Linnaeus','Linnaeus','GENUS','Hypochaeris','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3250','','','Hypochaeris glabra Linnaeus',1,'Hypochaeris glabra','Hypochaeris glabra','Hypochaeris glabr',2,0,'','','Linnaeus','03adda57-dd75-53fc-b552-e5794c390445','Hypochaeris glabra Linnaeus','Linnaeus','SPECIES','','Hypochaeris','','glabra','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3251','','','Hypochaeris radicata Linnaeus',1,'Hypochaeris radicata','Hypochaeris radicata','Hypochaeris radicat',2,0,'','','Linnaeus','dd906068-ec7f-5a77-80ec-5a37414f16bb','Hypochaeris radicata Linnaeus','Linnaeus','SPECIES','','Hypochaeris','','radicata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1312','','','Lactuca Linnaeus',1,'Lactuca','Lactuca','Lactuca',1,0,'','','Linnaeus','813d3bfc-01dc-567c-9afc-fa0e6f75c185','Lactuca Linnaeus','Linnaeus','GENUS','Lactuca','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3262','','','Lactuca biennis (Moench) Fernald',1,'Lactuca biennis','Lactuca biennis','Lactuca bienn',2,0,'','','Moench|Fernald','dfc60d5b-6499-5ec3-9e05-4a5add9cddff','Lactuca biennis (Moench) Fernald','(Moench) Fernald','SPECIES','','Lactuca','','biennis','','','',NULL,'Fernald','','','','','Moench','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3264','','','Lactuca floridana (Linnaeus) Gaertner',1,'Lactuca floridana','Lactuca floridana','Lactuca floridan',2,0,'','','Linnaeus|Gaertner','42bdba4f-2afa-5df4-9bbb-0ba4b1b78928','Lactuca floridana (Linnaeus) Gaertner','(Linnaeus) Gaertner','SPECIES','','Lactuca','','floridana','','','',NULL,'Gaertner','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1326','','','Leontodon Linnaeus',1,'Leontodon','Leontodon','Leontodon',1,0,'','','Linnaeus','83a63304-2e25-5353-ba34-617ed6dbe4db','Leontodon Linnaeus','Linnaeus','GENUS','Leontodon','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1414','','','Microseris D. Don',1,'Microseris','Microseris','Microseris',1,0,'','','D. Don','3eb9ce6c-ff68-559e-abb7-2e8a3056c3a9','Microseris D. Don','D. Don','GENUS','Microseris','','','','','','',NULL,'','','','','','D. Don','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1464','','','Nothocalais (A. Gray) Greene',1,'Nothocalais','Nothocalais','Nothocalais',1,0,'','','A. Gray|Greene','ab310669-1fb3-5621-b9f2-235759a94e77','Nothocalais (A. Gray) Greene','(A. Gray) Greene','GENUS','Nothocalais','','','','','','',NULL,'Greene','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3361','','','Nabalus albus (Linnaeus) Hooker',1,'Nabalus albus','Nabalus albus','Nabalus alb',2,0,'','','Linnaeus|Hooker','8adb606c-7d60-52b4-b8c3-7b53bc0e5203','Nabalus albus (Linnaeus) Hooker','(Linnaeus) Hooker','SPECIES','','Nabalus','','albus','','','',NULL,'Hooker','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3366','','','Nabalus trifoliolatus Cassini',1,'Nabalus trifoliolatus','Nabalus trifoliolatus','Nabalus trifoliolat',2,0,'','','Cassini','6fec1181-0e9a-5d9a-b5d0-6153e2504b0f','Nabalus trifoliolatus Cassini','Cassini','SPECIES','','Nabalus','','trifoliolatus','','','',NULL,'','','','','','Cassini','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3515','','','Sonchus palustris Linnaeus',1,'Sonchus palustris','Sonchus palustris','Sonchus palustr',2,0,'','','Linnaeus','080b7a3e-45be-55f6-a851-3da12b6fc662','Sonchus palustris Linnaeus','Linnaeus','SPECIES','','Sonchus','','palustris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3518','','','Stephanomeria lactucina A. Gray',1,'Stephanomeria lactucina','Stephanomeria lactucina','Stephanomeria lactucin',2,0,'','','A. Gray','4fd15bbc-36e7-5c00-bdaf-bbbc335cdce2','Stephanomeria lactucina A. Gray','A. Gray','SPECIES','','Stephanomeria','','lactucina','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3520','','','Stephanomeria tenuifolia (Rafinesque) H.M. Hall',1,'Stephanomeria tenuifolia','Stephanomeria tenuifolia','Stephanomeria tenuifol',2,0,'','','Rafinesque|H. M. Hall','362dff40-6d2b-598e-840b-685af4388d29','Stephanomeria tenuifolia (Rafinesque) H.M. Hall','(Rafinesque) H.M. Hall','SPECIES','','Stephanomeria','','tenuifolia','','','',NULL,'H. M. Hall','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3607','','','Taraxacum carneocoloratum A. Nelson',1,'Taraxacum carneocoloratum','Taraxacum carneocoloratum','Taraxacum carneocolorat',2,0,'','','A. Nelson','5f72044b-cd5c-5428-8043-5889577568b9','Taraxacum carneocoloratum A. Nelson','A. Nelson','SPECIES','','Taraxacum','','carneocoloratum','','','',NULL,'','','','','','A. Nelson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3611','','','Taraxacum hyparcticum Dahlstedt',1,'Taraxacum hyparcticum','Taraxacum hyparcticum','Taraxacum hyparctic',2,0,'','','Dahlstedt','1a381c48-446e-5158-b779-ab3f0dd6ab3f','Taraxacum hyparcticum Dahlstedt','Dahlstedt','SPECIES','','Taraxacum','','hyparcticum','','','',NULL,'','','','','','Dahlstedt','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3614','','','Taraxacum laurentianum Fernald',1,'Taraxacum laurentianum','Taraxacum laurentianum','Taraxacum laurentian',2,0,'','','Fernald','d53e5b70-dc78-53f2-b0bf-6f4b4bf581c5','Taraxacum laurentianum Fernald','Fernald','SPECIES','','Taraxacum','','laurentianum','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9561','','','Taraxacum scopulorum (A. Gray) Rydberg',1,'Taraxacum scopulorum','Taraxacum scopulorum','Taraxacum scopulor',2,0,'','','A. Gray|Rydberg','17b79666-4815-5871-b093-378e816d270d','Taraxacum scopulorum (A. Gray) Rydberg','(A. Gray) Rydberg','SPECIES','','Taraxacum','','scopulorum','','','',NULL,'Rydberg','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3633','','','Tragopogon dubius Scopoli',1,'Tragopogon dubius','Tragopogon dubius','Tragopogon dub',2,0,'','','Scopoli','980921e3-0c74-5b2a-b65b-c420009f1d17','Tragopogon dubius Scopoli','Scopoli','SPECIES','','Tragopogon','','dubius','','','',NULL,'','','','','','Scopoli','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3308','','','Mulgedium pulchellum (Pursh) G. Don',1,'Mulgedium pulchellum','Mulgedium pulchellum','Mulgedium pulchell',2,0,'','','Pursh|G. Don','396cfd7a-cdd5-521e-a419-ad16eb604119','Mulgedium pulchellum (Pursh) G. Don','(Pursh) G. Don','SPECIES','','Mulgedium','','pulchellum','','','',NULL,'G. Don','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1938','','','Uropappus Nuttall',1,'Uropappus','Uropappus','Uropappus',1,0,'','','Nuttall','87a9d3ce-9809-5db1-b99e-e42e47f88686','Uropappus Nuttall','Nuttall','GENUS','Uropappus','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1963','','','Pilosella Hill',1,'Pilosella','Pilosella','Pilosella',1,0,'','','Hill','9ae4b4ae-83f0-58e9-9ac5-1e77d1ce939f','Pilosella Hill','Hill','GENUS','Pilosella','','','','','','',NULL,'','','','','','Hill','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3221','','','Pilosella aurantiaca (Linnaeus) F.W. Schultz & Schultz Bipontinus',1,'Pilosella aurantiaca','Pilosella aurantiaca','Pilosella aurantiac',2,0,'','','Linnaeus|F. W. Schultz|Schultz Bipontinus','fa9c6f3f-bacb-5889-92a3-00331857cbe5','Pilosella aurantiaca (Linnaeus) F.W. Schultz & Schultz Bipontinus','(Linnaeus) F.W. Schultz & Schultz Bipontinus','SPECIES','','Pilosella','','aurantiaca','','','',NULL,'F. W. Schultz & Schultz Bipontinus','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26589','','','Pilosella piloselloides (Villars) Soják subsp. piloselloides',1,'Pilosella piloselloides piloselloides','Pilosella piloselloides subsp. piloselloides','Pilosella piloselloid piloselloid',3,0,'','','','7a606858-240d-57bb-82a0-18bf65d8a66d','Pilosella piloselloides (Villars) Soják subsp. piloselloides','(Villars) Soják','SUBSPECIES','','Pilosella','','piloselloides','piloselloides','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('398','','','Mutisieae',1,'Mutisieae','Mutisieae','Mutisieae',1,0,'','','','16231ae7-7f82-5149-97be-e960fbef243b','Mutisieae','','TRIBE','Mutisieae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2775','','','Adenocaulon bicolor Hooker',1,'Adenocaulon bicolor','Adenocaulon bicolor','Adenocaulon bicolor',2,0,'','','Hooker','57d69862-9465-52bd-9f41-1ffae566cf84','Adenocaulon bicolor Hooker','Hooker','SPECIES','','Adenocaulon','','bicolor','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('97','','','Boraginaceae de Jussieu',1,'Boraginaceae','Boraginaceae','Boraginaceae',1,0,'','','de Jussieu','2097889d-58bf-5d8f-94a7-8299934d6946','Boraginaceae de Jussieu','de Jussieu','FAMILY','Boraginaceae','','','','','','',NULL,'','','','','','de Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3743','','','Anchusa arvensis (Linnaeus) M. Bieberstein',1,'Anchusa arvensis','Anchusa arvensis','Anchusa aruens',2,0,'','','Linnaeus|M. Bieberstein','cbcaccb8-854a-599a-98e8-d4e9bfe90eef','Anchusa arvensis (Linnaeus) M. Bieberstein','(Linnaeus) M. Bieberstein','SPECIES','','Anchusa','','arvensis','','','',NULL,'M. Bieberstein','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1734','','','Symphytum Necker',1,'Symphytum','Symphytum','Symphytum',1,0,'','','Necker','fc14df93-0743-52cb-9a2a-ee20d78b4998','Symphytum Necker','Necker','GENUS','Symphytum','','','','','','',NULL,'','','','','','Necker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3841','','','Symphytum officinale Linnaeus',1,'Symphytum officinale','Symphytum officinale','Symphytum officinal',2,0,'','','Linnaeus','19b38002-9a0d-5bd3-9d13-feacb6453c8f','Symphytum officinale Linnaeus','Linnaeus','SPECIES','','Symphytum','','officinale','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3748','','','Buglossoides arvensis (Linnaeus) I.M. Johnston',1,'Buglossoides arvensis','Buglossoides arvensis','Buglossoides aruens',2,0,'','','Linnaeus|I. M. Johnston','d84eb6aa-308c-5fa1-bf01-70357a78f905','Buglossoides arvensis (Linnaeus) I.M. Johnston','(Linnaeus) I.M. Johnston','SPECIES','','Buglossoides','','arvensis','','','',NULL,'I. M. Johnston','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3786','','','Lithospermum latifolium Michaux',1,'Lithospermum latifolium','Lithospermum latifolium','Lithospermum latifoli',2,0,'','','Michaux','818a48f8-2851-56a3-be81-a5fa45f6d80b','Lithospermum latifolium Michaux','Michaux','SPECIES','','Lithospermum','','latifolium','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25481','','','Lithospermum occidentale (Mackenzie) Weakley, Witsell & D. Estes',1,'Lithospermum occidentale','Lithospermum occidentale','Lithospermum occidental',2,0,'','','Mackenzie|Weakley|Witsell|D. Estes','5b6ccc6f-38c5-52dd-9fcf-b8ff95ea0303','Lithospermum occidentale (Mackenzie) Weakley, Witsell & D. Estes','(Mackenzie) Weakley, Witsell & D. Estes','SPECIES','','Lithospermum','','occidentale','','','',NULL,'Weakley, Witsell & D. Estes','','','','','Mackenzie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3811','','','Omphalodes linifolia (Linnaeus) Moench',1,'Omphalodes linifolia','Omphalodes linifolia','Omphalodes linifol',2,0,'','','Linnaeus|Moench','3e60e181-d04c-50b5-8a98-904ec74104b4','Omphalodes linifolia (Linnaeus) Moench','(Linnaeus) Moench','SPECIES','','Omphalodes','','linifolia','','','',NULL,'Moench','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32229','','','Eritrichium arctisibiricum (V.V. Petrovsky) Khokhryakov',1,'Eritrichium arctisibiricum','Eritrichium arctisibiricum','Eritrichium arctisibiric',2,0,'','','V. V. Petrovsky|Khokhryakov','ef706789-1ad0-587e-a764-75f4fca60cd6','Eritrichium arctisibiricum (V.V. Petrovsky) Khokhryakov','(V.V. Petrovsky) Khokhryakov','SPECIES','','Eritrichium','','arctisibiricum','','','',NULL,'Khokhryakov','','','','','V. V. Petrovsky','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3772','','','Hackelia diffusa (Lehmann) I.M. Johnston',1,'Hackelia diffusa','Hackelia diffusa','Hackelia diffus',2,0,'','','Lehmann|I. M. Johnston','c38081b5-51a7-54e8-a8c4-16266d1f8b92','Hackelia diffusa (Lehmann) I.M. Johnston','(Lehmann) I.M. Johnston','SPECIES','','Hackelia','','diffusa','','','',NULL,'I. M. Johnston','','','','','Lehmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3780','','','Lappula occidentalis (Watson) Greene var. occidentalis',1,'Lappula occidentalis occidentalis','Lappula occidentalis var. occidentalis','Lappula occidental occidental',3,0,'','','','3ac2d94c-b45b-5878-955f-c0f3d4e7622d','Lappula occidentalis (Watson) Greene var. occidentalis','(Watson) Greene','VARIETY','','Lappula','','occidentalis','occidentalis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3746','','','Asperugo procumbens Linnaeus',1,'Asperugo procumbens','Asperugo procumbens','Asperugo procumbens',2,0,'','','Linnaeus','c99e8080-72b2-5692-8846-28889568e708','Asperugo procumbens Linnaeus','Linnaeus','SPECIES','','Asperugo','','procumbens','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3791','','','Mertensia lanceolata (Pursh) A. de Candolle',1,'Mertensia lanceolata','Mertensia lanceolata','Mertensia lanceolat',2,0,'','','Pursh|A. de Candolle','9848c81d-0ef7-582d-b6bb-02e931531e86','Mertensia lanceolata (Pursh) A. de Candolle','(Pursh) A. de Candolle','SPECIES','','Mertensia','','lanceolata','','','',NULL,'A. de Candolle','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3797','','','Mertensia paniculata var. borealis (J.F. Macbride) L.O. Williams',1,'Mertensia paniculata borealis','Mertensia paniculata var. borealis','Mertensia paniculat boreal',3,0,'','','J. F. Macbride|L. O. Williams','d612d49a-1694-53af-9394-a7f0c75a35d0','Mertensia paniculata var. borealis (J.F. Macbride) L.O. Williams','(J.F. Macbride) L.O. Williams','VARIETY','','Mertensia','','paniculata','borealis','','',NULL,'L. O. Williams','','','','','J. F. Macbride','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3802','','','Myosotis discolor Persoon',1,'Myosotis discolor','Myosotis discolor','Myosotis discolor',2,0,'','','Persoon','ff321f97-3c6b-51a3-be3e-3b324fd61aee','Myosotis discolor Persoon','Persoon','SPECIES','','Myosotis','','discolor','','','',NULL,'','','','','','Persoon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3806','','','Myosotis stricta Link ex Roemer & Schultes',2,'Myosotis stricta','Myosotis stricta','Myosotis strict',2,0,'','','Link|Roemer|Schultes','95a8433a-fac6-5f9a-a301-c49004b58b6d','Myosotis stricta Link ex Roemer & Schultes','Link ex Roemer & Schultes','SPECIES','','Myosotis','','stricta','','','',NULL,'','','','','','Link','','Roemer & Schultes','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29171','','','Andersonglossum J.I. Cohen',1,'Andersonglossum','Andersonglossum','Andersonglossum',1,0,'','','J. I. Cohen','1297115b-9307-5db0-b2d8-578c4ff7cc06','Andersonglossum J.I. Cohen','J.I. Cohen','GENUS','Andersonglossum','','','','','','',NULL,'','','','','','J. I. Cohen','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3741','','','Amsinckia spectabilis Fischer & C.A. Meyer',1,'Amsinckia spectabilis','Amsinckia spectabilis','Amsinckia spectabil',2,0,'','','Fischer|C. A. Meyer','838a7171-ff48-556a-b932-ca969357184f','Amsinckia spectabilis Fischer & C.A. Meyer','Fischer & C.A. Meyer','SPECIES','','Amsinckia','','spectabilis','','','',NULL,'','','','','','Fischer & C. A. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3754','','','Cryptantha intermedia (A. Gray) Greene',1,'Cryptantha intermedia','Cryptantha intermedia','Cryptantha intermed',2,0,'','','A. Gray|Greene','56c318f1-ca38-5196-98af-9f00ea7da80a','Cryptantha intermedia (A. Gray) Greene','(A. Gray) Greene','SPECIES','','Cryptantha','','intermedia','','','',NULL,'Greene','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32557','','','Cryptantha torreyana (A. Gray) Greene var. torreyana',1,'Cryptantha torreyana torreyana','Cryptantha torreyana var. torreyana','Cryptantha torreyan torreyan',3,0,'','','','07e46f74-5308-534b-97fd-278afb223e69','Cryptantha torreyana (A. Gray) Greene var. torreyana','(A. Gray) Greene','VARIETY','','Cryptantha','','torreyana','torreyana','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3837','','','Plagiobothrys tenellus (Nuttall ex Hooker) A. Gray',2,'Plagiobothrys tenellus','Plagiobothrys tenellus','Plagiobothrys tenell',2,0,'','','Nuttall|Hooker|A. Gray','553d1e7a-147b-54ae-8f36-b49b54a34f3d','Plagiobothrys tenellus (Nuttall ex Hooker) A. Gray','(Nuttall ex Hooker) A. Gray','SPECIES','','Plagiobothrys','','tenellus','','','',NULL,'A. Gray','','','','','Nuttall','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3833','','','Plagiobothrys figuratus (Piper) I.M. Johnston ex M. Peck',2,'Plagiobothrys figuratus','Plagiobothrys figuratus','Plagiobothrys figurat',2,0,'','','Piper|I. M. Johnston|M. Peck','b76a3523-6b97-5c53-a734-bcae0340ed6b','Plagiobothrys figuratus (Piper) I.M. Johnston ex M. Peck','(Piper) I.M. Johnston ex M. Peck','SPECIES','','Plagiobothrys','','figuratus','','','',NULL,'I. M. Johnston','','M. Peck','','','Piper','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31408','','','Hydrophyllaceae R. Brown',1,'Hydrophyllaceae','Hydrophyllaceae','Hydrophyllaceae',1,0,'','','R. Brown','27fb7d35-04c5-52a6-a748-7f83d5238125','Hydrophyllaceae R. Brown','R. Brown','FAMILY','Hydrophyllaceae','','','','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1269','','','Hydrophyllum Linnaeus',1,'Hydrophyllum','Hydrophyllum','Hydrophyllum',1,0,'','','Linnaeus','05ab5edf-9d84-5712-b273-399302b83f5a','Hydrophyllum Linnaeus','Linnaeus','GENUS','Hydrophyllum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6136','','','Hydrophyllum capitatum Douglas ex Bentham',2,'Hydrophyllum capitatum','Hydrophyllum capitatum','Hydrophyllum capitat',2,0,'','','Douglas|Bentham','da537efa-475e-536a-8adc-249b5cf4a6f6','Hydrophyllum capitatum Douglas ex Bentham','Douglas ex Bentham','SPECIES','','Hydrophyllum','','capitatum','','','',NULL,'','','','','','Douglas','','Bentham','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6141','','','Nemophila breviflora A. Gray',1,'Nemophila breviflora','Nemophila breviflora','Nemophila breuiflor',2,0,'','','A. Gray','e482f496-d2af-5745-b913-e85a6c1e2792','Nemophila breviflora A. Gray','A. Gray','SPECIES','','Nemophila','','breviflora','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1529','','','Phacelia Jussieu',1,'Phacelia','Phacelia','Phacelia',1,0,'','','Jussieu','3a712014-5fbe-5581-b5a6-09174a5d4db7','Phacelia Jussieu','Jussieu','GENUS','Phacelia','','','','','','',NULL,'','','','','','Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3824','','','Phacelia linearis (Pursh) Holzinger',1,'Phacelia linearis','Phacelia linearis','Phacelia linear',2,0,'','','Pursh|Holzinger','32e473c1-fdef-5229-ba05-a8904a9f0f78','Phacelia linearis (Pursh) Holzinger','(Pursh) Holzinger','SPECIES','','Phacelia','','linearis','','','',NULL,'Holzinger','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3825','','','Phacelia lyallii (A. Gray) Rydberg',1,'Phacelia lyallii','Phacelia lyallii','Phacelia lyall',2,0,'','','A. Gray|Rydberg','06949e19-b8af-535c-89a2-326e89fb36bf','Phacelia lyallii (A. Gray) Rydberg','(A. Gray) Rydberg','SPECIES','','Phacelia','','lyallii','','','',NULL,'Rydberg','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3829','','','Phacelia sericea (Graham) A. Gray',1,'Phacelia sericea','Phacelia sericea','Phacelia serice',2,0,'','','Graham|A. Gray','cdc860b1-91e7-5aff-a811-d08bf912bb45','Phacelia sericea (Graham) A. Gray','(Graham) A. Gray','SPECIES','','Phacelia','','sericea','','','',NULL,'A. Gray','','','','','Graham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3821','','','Phacelia hastata Douglas ex Lehmann',2,'Phacelia hastata','Phacelia hastata','Phacelia hastat',2,0,'','','Douglas|Lehmann','b2a2662f-c18c-564c-8ec2-a5e099081d9e','Phacelia hastata Douglas ex Lehmann','Douglas ex Lehmann','SPECIES','','Phacelia','','hastata','','','',NULL,'','','','','','Douglas','','Lehmann','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31409','','','Heliotropiaceae Schrader',1,'Heliotropiaceae','Heliotropiaceae','Heliotropiaceae',1,0,'','','Schrader','45b41c2b-f6f6-555c-b629-7a4f6a1080d4','Heliotropiaceae Schrader','Schrader','FAMILY','Heliotropiaceae','','','','','','',NULL,'','','','','','Schrader','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4654','','','Cornus ×acadiensis Fernald',3,'','','',NULL,NULL,'','','','','Cornus ×acadiensis Fernald','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28159','','','Cornus subg. Cynoxylon (Rafinesque) ) Rafinesque',4,'','','',NULL,NULL,'','','','','Cornus subg. Cynoxylon (Rafinesque) ) Rafinesque','(Rafinesque) ) Rafinesque','SUBGENUS','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4646','','','Cornus florida Linnaeus',1,'Cornus florida','Cornus florida','Cornus florid',2,0,'','','Linnaeus','5cd2d1c4-aa8b-58d4-8967-38c09a666359','Cornus florida Linnaeus','Linnaeus','SPECIES','','Cornus','','florida','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4652','','','Cornus suecica Linnaeus',1,'Cornus suecica','Cornus suecica','Cornus suecic',2,0,'','','Linnaeus','1efd0a60-d841-5a36-8bb4-aa773a095fb0','Cornus suecica Linnaeus','Linnaeus','SPECIES','','Cornus','','suecica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4650','','','Cornus rugosa Lamarck',1,'Cornus rugosa','Cornus rugosa','Cornus rugos',2,0,'','','Lamarck','49f0196e-871c-5ab8-bc27-3700d0556b62','Cornus rugosa Lamarck','Lamarck','SPECIES','','Cornus','','rugosa','','','',NULL,'','','','','','Lamarck','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14855','','','Cornus obliqua Rafinesque',1,'Cornus obliqua','Cornus obliqua','Cornus obliqu',2,0,'','','Rafinesque','02d27cb4-fbc4-5012-8048-76e563953fa8','Cornus obliqua Rafinesque','Rafinesque','SPECIES','','Cornus','','obliqua','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29966','','','Cornus sanguinea Linnaeus',1,'Cornus sanguinea','Cornus sanguinea','Cornus sanguine',2,0,'','','Linnaeus','eec3a0f6-6ab4-5d20-babe-5d3a17e5a94d','Cornus sanguinea Linnaeus','Linnaeus','SPECIES','','Cornus','','sanguinea','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('343','','','Hydrangeoideae',1,'Hydrangeoideae','Hydrangeoideae','Hydrangeoideae',1,0,'','','','3232998d-fa16-5e28-9aca-ff52235765e2','Hydrangeoideae','','SUBFAMILY','Hydrangeoideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6111','','','Hydrangea arborescens Linnaeus',1,'Hydrangea arborescens','Hydrangea arborescens','Hydrangea arborescens',2,0,'','','Linnaeus','707a50ea-18a2-585b-bf0b-7775fcec1415','Hydrangea arborescens Linnaeus','Linnaeus','SPECIES','','Hydrangea','','arborescens','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1534','','','Philadelphus Linnaeus',1,'Philadelphus','Philadelphus','Philadelphus',1,0,'','','Linnaeus','164463fd-9d70-5ab8-9702-5ebf043851f9','Philadelphus Linnaeus','Linnaeus','GENUS','Philadelphus','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6114','','','Philadelphus inodorus Linnaeus',1,'Philadelphus inodorus','Philadelphus inodorus','Philadelphus inodor',2,0,'','','Linnaeus','42f9cae6-0bd9-5fc8-b65e-724d95a7654f','Philadelphus inodorus Linnaeus','Linnaeus','SPECIES','','Philadelphus','','inodorus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28533','','','Mentzelia sect. Bartonia Torrey & A. Gray',2,'Bartonia','Mentzelia sect. Bartonia','Bartonia',1,0,'','','Torrey|A. Gray','9add12bf-32c4-55f7-95a5-a798b4751fc0','Mentzelia sect. Bartonia Torrey & A. Gray','Torrey & A. Gray','SECTION','Bartonia','','','','','','',NULL,'','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6567','','','Mentzelia laevicaulis (Douglas) Torrey & A. Gray var. laevicaulis',1,'Mentzelia laevicaulis laevicaulis','Mentzelia laevicaulis var. laevicaulis','Mentzelia laeuicaul laeuicaul',3,0,'','','','7b0e0ef8-314e-59b6-92d7-7d98bc110db2','Mentzelia laevicaulis (Douglas) Torrey & A. Gray var. laevicaulis','(Douglas) Torrey & A. Gray','VARIETY','','Mentzelia','','laevicaulis','laevicaulis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1368','','','Lonicera Linnaeus',1,'Lonicera','Lonicera','Lonicera',1,0,'','','Linnaeus','c5d13dd5-f943-5d93-8ee6-b8b4729081bd','Lonicera Linnaeus','Linnaeus','GENUS','Lonicera','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4206','','','Lonicera caprifolium Linnaeus',1,'Lonicera caprifolium','Lonicera caprifolium','Lonicera caprifoli',2,0,'','','Linnaeus','ce62f548-fb38-570b-b962-ef6b7c58aab2','Lonicera caprifolium Linnaeus','Linnaeus','SPECIES','','Lonicera','','caprifolium','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4213','','','Lonicera etrusca Santi',1,'Lonicera etrusca','Lonicera etrusca','Lonicera etrusc',2,0,'','','Santi','49cd5477-6c26-5fef-b740-7ebb3db80355','Lonicera etrusca Santi','Santi','SPECIES','','Lonicera','','etrusca','','','',NULL,'','','','','','Santi','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4222','','','Lonicera periclymenum Linnaeus',1,'Lonicera periclymenum','Lonicera periclymenum','Lonicera periclymen',2,0,'','','Linnaeus','465a2fe1-b600-5b30-9117-2f4c56f1b27f','Lonicera periclymenum Linnaeus','Linnaeus','SPECIES','','Lonicera','','periclymenum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4218','','','Lonicera japonica Thunberg',1,'Lonicera japonica','Lonicera japonica','Lonicera iaponic',2,0,'','','Thunberg','4a13746c-88d8-5a9c-be84-4a559685b348','Lonicera japonica Thunberg','Thunberg','SPECIES','','Lonicera','','japonica','','','',NULL,'','','','','','Thunberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4219','','','Lonicera maackii (Ruprecht) Maximowicz',1,'Lonicera maackii','Lonicera maackii','Lonicera maack',2,0,'','','Ruprecht|Maximowicz','75a9b8e8-6d99-587f-a2ad-4ac2d2e9aa32','Lonicera maackii (Ruprecht) Maximowicz','(Ruprecht) Maximowicz','SPECIES','','Lonicera','','maackii','','','',NULL,'Maximowicz','','','','','Ruprecht','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33403','','','Lonicera acuminata Wallich',1,'Lonicera acuminata','Lonicera acuminata','Lonicera acuminat',2,0,'','','Wallich','abb576d5-965d-566e-adbb-218e1a6034f6','Lonicera acuminata Wallich','Wallich','SPECIES','','Lonicera','','acuminata','','','',NULL,'','','','','','Wallich','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4233','','','Symphoricarpos albus (Linnaeus) S.F. Blake',1,'Symphoricarpos albus','Symphoricarpos albus','Symphoricarpos alb',2,0,'','','Linnaeus|S. F. Blake','d144463a-e1ed-5eb3-b525-ccda63b5f89a','Symphoricarpos albus (Linnaeus) S.F. Blake','(Linnaeus) S.F. Blake','SPECIES','','Symphoricarpos','','albus','','','',NULL,'S. F. Blake','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25866','','','Symphoricarpos rotundifolius var. vaccinioides (Rydberg) A. Nelson',1,'Symphoricarpos rotundifolius vaccinioides','Symphoricarpos rotundifolius var. vaccinioides','Symphoricarpos rotundifol uaccinioid',3,0,'','','Rydberg|A. Nelson','43a6cf18-e7e2-58e0-b741-5ca491712080','Symphoricarpos rotundifolius var. vaccinioides (Rydberg) A. Nelson','(Rydberg) A. Nelson','VARIETY','','Symphoricarpos','','rotundifolius','vaccinioides','','',NULL,'A. Nelson','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4242','','','Triosteum aurantiacum E.P. Bicknell',1,'Triosteum aurantiacum','Triosteum aurantiacum','Triosteum aurantiac',2,0,'','','E. P. Bicknell','3f57f9eb-41b4-586a-9277-eb38b068bd6a','Triosteum aurantiacum E.P. Bicknell','E.P. Bicknell','SPECIES','','Triosteum','','aurantiacum','','','',NULL,'','','','','','E. P. Bicknell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9897','','','Sambucus melanocarpa A. Gray',1,'Sambucus melanocarpa','Sambucus melanocarpa','Sambucus melanocarp',2,0,'','','A. Gray','a6dba928-5488-55bc-931d-de961c910fe0','Sambucus melanocarpa A. Gray','A. Gray','SPECIES','','Sambucus','','melanocarpa','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2444','','','Viburnum edule (Michaux) Rafinesque',1,'Viburnum edule','Viburnum edule','Viburnum edul',2,0,'','','Michaux|Rafinesque','27ed6665-7822-5326-b3c4-a4bc7b76c342','Viburnum edule (Michaux) Rafinesque','(Michaux) Rafinesque','SPECIES','','Viburnum','','edule','','','',NULL,'Rafinesque','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32063','','','Viburnum sect. Pseudotinus C.B. Clarke',2,'Pseudotinus','Viburnum sect. Pseudotinus','Pseudotinus',1,0,'','','C. B. Clarke','832e7746-74e2-5783-ac1f-bac8d6e41e77','Viburnum sect. Pseudotinus C.B. Clarke','C.B. Clarke','SECTION','Pseudotinus','','','','','','',NULL,'','','','','','C. B. Clarke','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9901','','','Viburnum cassinoides Linnaeus',1,'Viburnum cassinoides','Viburnum cassinoides','Viburnum cassinoid',2,0,'','','Linnaeus','e98acc3e-1e46-5947-8929-a52c2d135781','Viburnum cassinoides Linnaeus','Linnaeus','SPECIES','','Viburnum','','cassinoides','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29474','','','Weigela floribunda (Siebold & Zuccarini) K. Koch',1,'Weigela floribunda','Weigela floribunda','Weigela floribund',2,0,'','','Siebold|Zuccarini|K. Koch','3e749fd0-c537-54b0-8b46-85dbb7da416c','Weigela floribunda (Siebold & Zuccarini) K. Koch','(Siebold & Zuccarini) K. Koch','SPECIES','','Weigela','','floribunda','','','',NULL,'K. Koch','','','','','Siebold & Zuccarini','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1303','','','Knautia Linnaeus',1,'Knautia','Knautia','Knautia',1,0,'','','Linnaeus','fb4189ca-9d0b-54fc-9199-cb769ccacee6','Knautia Linnaeus','Linnaeus','GENUS','Knautia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33624','','','Valerianaceae Batsch',1,'Valerianaceae','Valerianaceae','Valerianaceae',1,0,'','','Batsch','2cd78c35-820b-5897-83de-fcbae9dccecc','Valerianaceae Batsch','Batsch','FAMILY','Valerianaceae','','','','','','',NULL,'','','','','','Batsch','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9441','','','Plectritis congesta subsp. brachystemon (Fischer & C.A. Meyer) Morey',1,'Plectritis congesta brachystemon','Plectritis congesta subsp. brachystemon','Plectritis congest brachystemon',3,0,'','','Fischer|C. A. Meyer|Morey','7a988d36-019e-5867-8908-0ca09e9ce2e7','Plectritis congesta subsp. brachystemon (Fischer & C.A. Meyer) Morey','(Fischer & C.A. Meyer) Morey','SUBSPECIES','','Plectritis','','congesta','brachystemon','','',NULL,'Morey','','','','','Fischer & C. A. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9451','','','Valeriana officinalis Linnaeus',1,'Valeriana officinalis','Valeriana officinalis','Valeriana officinal',2,0,'','','Linnaeus','8d5dacd1-a91d-548b-8d02-8dba07baec3c','Valeriana officinalis Linnaeus','Linnaeus','SPECIES','','Valeriana','','officinalis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9450','','','Valeriana edulis Nuttall subsp. edulis',1,'Valeriana edulis edulis','Valeriana edulis subsp. edulis','Valeriana edul edul',3,0,'','','','33cb683f-4e06-567a-8071-14c92a4751eb','Valeriana edulis Nuttall subsp. edulis','Nuttall','SUBSPECIES','','Valeriana','','edulis','edulis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27705','','','Kolkwitzia amabilis Graebner',1,'Kolkwitzia amabilis','Kolkwitzia amabilis','Kolkwitzia amabil',2,0,'','','Graebner','006c8667-0f67-5468-adf3-a7b5c18ae05e','Kolkwitzia amabilis Graebner','Graebner','SPECIES','','Kolkwitzia','','amabilis','','','',NULL,'','','','','','Graebner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4200','','','Linnaea borealis Linnaeus subsp. borealis',1,'Linnaea borealis borealis','Linnaea borealis subsp. borealis','Linnaea boreal boreal',3,0,'','','','254e15ff-cc61-5348-891f-092fc0f62ff0','Linnaea borealis Linnaeus subsp. borealis','Linnaeus','SUBSPECIES','','Linnaea','','borealis','borealis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('92','','','Balsaminaceae Berchtold & J. Presl',1,'Balsaminaceae','Balsaminaceae','Balsaminaceae',1,0,'','','Berchtold|J. Presl','4d4e70ee-e01d-5e94-b3c5-b6faa3283bfd','Balsaminaceae Berchtold & J. Presl','Berchtold & J. Presl','FAMILY','Balsaminaceae','','','','','','',NULL,'','','','','','Berchtold & J. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26578','','','Impatiens balfourii Hooker f.',1,'Impatiens balfourii','Impatiens balfourii','Impatiens balfour',2,0,'','','Hooker fil.','b23e264e-2ff9-5255-95ee-44d76bd5439f','Impatiens balfourii Hooker f.','Hooker f.','SPECIES','','Impatiens','','balfourii','','','',NULL,'','','','','','Hooker fil.','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5526','','','Hemitomes congestum A. Gray',1,'Hemitomes congestum','Hemitomes congestum','Hemitomes congest',2,0,'','','A. Gray','c9ed2075-01ec-5e49-9d6a-5152b604e242','Hemitomes congestum A. Gray','A. Gray','SPECIES','','Hemitomes','','congestum','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('504','','','Pyroleae',1,'Pyroleae','Pyroleae','Pyroleae',1,0,'','','','8dc9735d-f200-5c4b-bacd-058a9fefe77e','Pyroleae','','TRIBE','Pyroleae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5505','','','Chimaphila maculata (Linnaeus) Pursh',1,'Chimaphila maculata','Chimaphila maculata','Chimaphila maculat',2,0,'','','Linnaeus|Pursh','76088e09-befa-5b4a-acae-d577ac8066c0','Chimaphila maculata (Linnaeus) Pursh','(Linnaeus) Pursh','SPECIES','','Chimaphila','','maculata','','','',NULL,'Pursh','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5536','','','Moneses uniflora (Linnaeus) A. Gray',1,'Moneses uniflora','Moneses uniflora','Moneses uniflor',2,0,'','','Linnaeus|A. Gray','e5e72797-9490-5a75-8159-5c483fa81e67','Moneses uniflora (Linnaeus) A. Gray','(Linnaeus) A. Gray','SPECIES','','Moneses','','uniflora','','','',NULL,'A. Gray','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5551','','','Pyrola grandiflora Radius',1,'Pyrola grandiflora','Pyrola grandiflora','Pyrola grandiflor',2,0,'','','Radius','7d436199-ef5e-5459-ac13-bb6d62d84cd4','Pyrola grandiflora Radius','Radius','SPECIES','','Pyrola','','grandiflora','','','',NULL,'','','','','','Radius','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32511','','','Pyrola ser. Ellipticae (Andres) Křísa',2,'Ellipticae','Pyrola ser. Ellipticae','Ellipticae',1,0,'','','Andres|Křísa','d23da03e-15f9-5ab1-aa3f-fa2909a56f37','Pyrola ser. Ellipticae (Andres) Křísa','(Andres) Křísa','SERIES','Ellipticae','','','','','','',NULL,'Křísa','','','','','Andres','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5550','','','Pyrola elliptica Nuttall',1,'Pyrola elliptica','Pyrola elliptica','Pyrola elliptic',2,0,'','','Nuttall','fa13e4fd-a3c0-50aa-bf3a-a065f325506b','Pyrola elliptica Nuttall','Nuttall','SPECIES','','Pyrola','','elliptica','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32513','','','Pyrola ser. Chloranthae Křísa',2,'Chloranthae','Pyrola ser. Chloranthae','Chloranthae',1,0,'','','Křísa','dd65834b-6750-526d-b222-c3d2f9f31e9f','Pyrola ser. Chloranthae Křísa','Křísa','SERIES','Chloranthae','','','','','','',NULL,'','','','','','Křísa','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('663','','','Pterosporeae',1,'Pterosporeae','Pterosporeae','Pterosporeae',1,0,'','','','c8f81724-132d-5870-aace-c8d3fd22b260','Pterosporeae','','TRIBE','Pterosporeae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1601','','','Pterospora Nuttall',1,'Pterospora','Pterospora','Pterospora',1,0,'','','Nuttall','ebb8ee12-3eb5-524c-8615-da28798746b6','Pterospora Nuttall','Nuttall','GENUS','Pterospora','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('269','','','Vaccinioideae',1,'Vaccinioideae','Vaccinioideae','Vaccinioideae',1,0,'','','','999e1924-449e-5e77-ad6e-6faa0b6793d9','Vaccinioideae','','SUBFAMILY','Vaccinioideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('980','','','Chamaedaphne Moench',1,'Chamaedaphne','Chamaedaphne','Chamaedaphne',1,0,'','','Moench','f23330c7-c5ef-5b81-a283-6a788a4ec983','Chamaedaphne Moench','Moench','GENUS','Chamaedaphne','','','','','','',NULL,'','','','','','Moench','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5520','','','Gaultheria procumbens Linnaeus',1,'Gaultheria procumbens','Gaultheria procumbens','Gaultheria procumbens',2,0,'','','Linnaeus','1c151aff-0c99-5b03-ab8f-4b8d04bddb26','Gaultheria procumbens Linnaeus','Linnaeus','SPECIES','','Gaultheria','','procumbens','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5567','','','Vaccinium boreale I.V. Hall & Aalders',1,'Vaccinium boreale','Vaccinium boreale','Vaccinium boreal',2,0,'','','I. V. Hall|Aalders','899e4e93-853b-54c1-a6da-de677690441b','Vaccinium boreale I.V. Hall & Aalders','I.V. Hall & Aalders','SPECIES','','Vaccinium','','boreale','','','',NULL,'','','','','','I. V. Hall & Aalders','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5572','','','Vaccinium membranaceum Douglas ex Torrey',2,'Vaccinium membranaceum','Vaccinium membranaceum','Vaccinium membranace',2,0,'','','Douglas|Torrey','f47e5cc7-b477-5f42-8c83-2ebfac4ae95c','Vaccinium membranaceum Douglas ex Torrey','Douglas ex Torrey','SPECIES','','Vaccinium','','membranaceum','','','',NULL,'','','','','','Douglas','','Torrey','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16042','','','Vaccinium microcarpum (Turczaninow ex Ruprecht) Schmalhausen',2,'Vaccinium microcarpum','Vaccinium microcarpum','Vaccinium microcarp',2,0,'','','Turczaninow|Ruprecht|Schmalhausen','8863f15b-6e2c-50ad-b924-033aeaa77d64','Vaccinium microcarpum (Turczaninow ex Ruprecht) Schmalhausen','(Turczaninow ex Ruprecht) Schmalhausen','SPECIES','','Vaccinium','','microcarpum','','','',NULL,'Schmalhausen','','','','','Turczaninow','','Ruprecht','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23766','','','Lyonieae Kron & Judd',1,'Lyonieae','Lyonieae','Lyonieae',1,0,'','','Kron|Judd','885c845e-57c5-5378-a8e3-aef2233d5b7d','Lyonieae Kron & Judd','Kron & Judd','TRIBE','Lyonieae','','','','','','',NULL,'','','','','','Kron & Judd','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5490','','','Arbutus menziesii Pursh',1,'Arbutus menziesii','Arbutus menziesii','Arbutus menzies',2,0,'','','Pursh','b69e1791-b526-59c0-9818-4897fa878cb2','Arbutus menziesii Pursh','Pursh','SPECIES','','Arbutus','','menziesii','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('848','','','Arctous Niedenzu',1,'Arctous','Arctous','Arctous',1,0,'','','Niedenzu','20955dda-bd48-5791-a028-8078f52a54e6','Arctous Niedenzu','Niedenzu','GENUS','Arctous','','','','','','',NULL,'','','','','','Niedenzu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('297','','','Ericoideae',1,'Ericoideae','Ericoideae','Ericoideae',1,0,'','','','b21f1929-96d1-5154-bb2d-12ee3c0d248a','Ericoideae','','SUBFAMILY','Ericoideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1136','','','Empetrum Linnaeus',1,'Empetrum','Empetrum','Empetrum',1,0,'','','Linnaeus','640f6e0d-7a94-543a-ab7d-064d16769dd6','Empetrum Linnaeus','Linnaeus','GENUS','Empetrum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5512','','','Empetrum eamesii Fernald & Wiegand',1,'Empetrum eamesii','Empetrum eamesii','Empetrum eames',2,0,'','','Fernald|Wiegand','3ba8b5b8-7672-51d2-af4e-b09373699872','Empetrum eamesii Fernald & Wiegand','Fernald & Wiegand','SPECIES','','Empetrum','','eamesii','','','',NULL,'','','','','','Fernald & Wiegand','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1139','','','Epigaea Linnaeus',1,'Epigaea','Epigaea','Epigaea',1,0,'','','Linnaeus','061ecce0-e23c-5aa5-bc76-3e2b0712187a','Epigaea Linnaeus','Linnaeus','GENUS','Epigaea','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5529','','','Kalmia angustifolia Linnaeus',1,'Kalmia angustifolia','Kalmia angustifolia','Kalmia angustifol',2,0,'','','Linnaeus','6bae26bc-2c88-5762-8631-4b3677596703','Kalmia angustifolia Linnaeus','Linnaeus','SPECIES','','Kalmia','','angustifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5531','','','Kalmia microphylla (Hooker) A. Heller var. microphylla',1,'Kalmia microphylla microphylla','Kalmia microphylla var. microphylla','Kalmia microphyll microphyll',3,0,'','','','8bff4cef-c19e-5967-9ebf-a5e17a58498a','Kalmia microphylla (Hooker) A. Heller var. microphylla','(Hooker) A. Heller','VARIETY','','Kalmia','','microphylla','microphylla','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1620','','','Rhododendron Linnaeus',1,'Rhododendron','Rhododendron','Rhododendron',1,0,'','','Linnaeus','d2525ed5-0ade-532f-88da-854704148e39','Rhododendron Linnaeus','Linnaeus','GENUS','Rhododendron','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5559','','','Rhododendron macrophyllum D. Don ex G. Don',2,'Rhododendron macrophyllum','Rhododendron macrophyllum','Rhododendron macrophyll',2,0,'','','D. Don|G. Don','ed1097ed-69c1-5515-8da0-cd74750f7d44','Rhododendron macrophyllum D. Don ex G. Don','D. Don ex G. Don','SPECIES','','Rhododendron','','macrophyllum','','','',NULL,'','','','','','D. Don','','G. Don','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('702','','','Ericeae',1,'Ericeae','Ericeae','Ericeae',1,0,'','','','f57dd976-db11-574f-bc2e-68836488112f','Ericeae','','TRIBE','Ericeae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('933','','','Calluna Salisbury',1,'Calluna','Calluna','Calluna',1,0,'','','Salisbury','ec1c24e8-d47c-5a22-861d-d15d63dd4e4b','Calluna Salisbury','Salisbury','GENUS','Calluna','','','','','','',NULL,'','','','','','Salisbury','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5501','','','Cassiope tetragona (Linnaeus) D. Don',1,'Cassiope tetragona','Cassiope tetragona','Cassiope tetragon',2,0,'','','Linnaeus|D. Don','a515c9a4-1570-5df3-ad4a-7e94f4162851','Cassiope tetragona (Linnaeus) D. Don','(Linnaeus) D. Don','SPECIES','','Cassiope','','tetragona','','','',NULL,'D. Don','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5524','','','Harrimanella hypnoides (Linnaeus) Coville',1,'Harrimanella hypnoides','Harrimanella hypnoides','Harrimanella hypnoid',2,0,'','','Linnaeus|Coville','f1e097c9-b6f6-58ad-97cf-c4e97faa2124','Harrimanella hypnoides (Linnaeus) Coville','(Linnaeus) Coville','SPECIES','','Harrimanella','','hypnoides','','','',NULL,'Coville','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1016','','','Collomia Nuttall',1,'Collomia','Collomia','Collomia',1,0,'','','Nuttall','a453663b-b1b2-5e39-b8ef-46bad165b438','Collomia Nuttall','Nuttall','GENUS','Collomia','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8035','','','Collomia linearis Nuttall',1,'Collomia linearis','Collomia linearis','Collomia linear',2,0,'','','Nuttall','7b10a4dd-7167-5212-aa4c-7e4c4ba16b70','Collomia linearis Nuttall','Nuttall','SPECIES','','Collomia','','linearis','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33998','','','Gilia achilleifolia Bentham',1,'Gilia achilleifolia','Gilia achilleifolia','Gilia achilleifol',2,0,'','','Bentham','90e870d2-7978-5492-91c7-5990bf64e9bf','Gilia achilleifolia Bentham','Bentham','SPECIES','','Gilia','','achilleifolia','','','',NULL,'','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8051','','','Navarretia divaricata Greene',1,'Navarretia divaricata','Navarretia divaricata','Navarretia diuaricat',2,0,'','','Greene','3bc1d4fc-09c2-5f5a-98df-2b040e553a0e','Navarretia divaricata Greene','Greene','SPECIES','','Navarretia','','divaricata','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32887','','','Navarretia propinqua Suksdorf',1,'Navarretia propinqua','Navarretia propinqua','Navarretia propinqu',2,0,'','','Suksdorf','fa936622-bdb7-5df4-99e9-e684d91aa39c','Navarretia propinqua Suksdorf','Suksdorf','SPECIES','','Navarretia','','propinqua','','','',NULL,'','','','','','Suksdorf','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('591','','','Loeselieae',1,'Loeselieae','Loeselieae','Loeselieae',1,0,'','','','f0091846-d354-5f2e-bdff-765db461afe9','Loeselieae','','TRIBE','Loeselieae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32870','','','Ipomopsis aggregata (Pursh) V.E. Grant subsp. aggregata',1,'Ipomopsis aggregata aggregata','Ipomopsis aggregata subsp. aggregata','Ipomopsis aggregat aggregat',3,0,'','','','decd4786-238a-508b-91eb-35e128a8a079','Ipomopsis aggregata (Pursh) V.E. Grant subsp. aggregata','(Pursh) V.E. Grant','SUBSPECIES','','Ipomopsis','','aggregata','aggregata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31845','','','Linanthus pungens subsp. hookeri (Douglas ex Hooker) J.M. Porter & R. Patterson',2,'Linanthus pungens hookeri','Linanthus pungens subsp. hookeri','Linanthus pungens hooker',3,0,'','','Douglas|Hooker|J. M. Porter|R. Patterson','fd90e7c7-bff3-5e6c-880b-3bffb47fc95a','Linanthus pungens subsp. hookeri (Douglas ex Hooker) J.M. Porter & R. Patterson','(Douglas ex Hooker) J.M. Porter & R. Patterson','SUBSPECIES','','Linanthus','','pungens','hookeri','','',NULL,'J. M. Porter & R. Patterson','','','','','Douglas','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8061','','','Phlox drummondii Hooker',1,'Phlox drummondii','Phlox drummondii','Phlox drummond',2,0,'','','Hooker','01e028c8-ee40-59c8-bf40-8d82f2439382','Phlox drummondii Hooker','Hooker','SPECIES','','Phlox','','drummondii','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8063','','','Phlox longifolia Nuttall',1,'Phlox longifolia','Phlox longifolia','Phlox longifol',2,0,'','','Nuttall','3087783f-6209-5dc9-9f4c-ce9a149c9717','Phlox longifolia Nuttall','Nuttall','SPECIES','','Phlox','','longifolia','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8073','','','Phlox speciosa Pursh',1,'Phlox speciosa','Phlox speciosa','Phlox specios',2,0,'','','Pursh','da8443c5-6b95-5e3f-9d3a-6343c4f7495b','Phlox speciosa Pursh','Pursh','SPECIES','','Phlox','','speciosa','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28756','','','Leptosiphon Bentham',1,'Leptosiphon','Leptosiphon','Leptosiphon',1,0,'','','Bentham','09ae0208-f2d2-5367-be45-8571600fc72b','Leptosiphon Bentham','Bentham','GENUS','Leptosiphon','','','','','','',NULL,'','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8079','','','Polemonium boreale Adams',1,'Polemonium boreale','Polemonium boreale','Polemonium boreal',2,0,'','','Adams','b28f2373-7ca4-5b8d-8147-a10285e71c3a','Polemonium boreale Adams','Adams','SPECIES','','Polemonium','','boreale','','','',NULL,'','','','','','Adams','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8085','','','Polemonium pulcherrimum Hooker',1,'Polemonium pulcherrimum','Polemonium pulcherrimum','Polemonium pulcherrim',2,0,'','','Hooker','d1699be7-f3ff-559b-bd76-57069a034ab2','Polemonium pulcherrimum Hooker','Hooker','SPECIES','','Polemonium','','pulcherrimum','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8087','','','Polemonium reptans Linnaeus',1,'Polemonium reptans','Polemonium reptans','Polemonium reptans',2,0,'','','Linnaeus','6fdcad75-bcca-5285-96ba-31b0b696494b','Polemonium reptans Linnaeus','Linnaeus','SPECIES','','Polemonium','','reptans','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('268','','','Lysimachioideae',1,'Lysimachioideae','Lysimachioideae','Lysimachioideae',1,0,'','','','decc09ac-05dd-5592-b37e-8bc50c883754','Lysimachioideae','','SUBFAMILY','Lysimachioideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6687','','','Lysimachia hybrida Michaux',1,'Lysimachia hybrida','Lysimachia hybrida','Lysimachia hybrid',2,0,'','','Michaux','28fbca5b-947d-57f6-aa2f-cb6687f8a115','Lysimachia hybrida Michaux','Michaux','SPECIES','','Lysimachia','','hybrida','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6690','','','Lysimachia punctata Linnaeus',1,'Lysimachia punctata','Lysimachia punctata','Lysimachia punctat',2,0,'','','Linnaeus','7b6adeb1-71b4-52c8-9f84-ce333d2850a6','Lysimachia punctata Linnaeus','Linnaeus','SPECIES','','Lysimachia','','punctata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6693','','','Lysimachia terrestris (Linnaeus) Britton, Sterns & Poggenberg',1,'Lysimachia terrestris','Lysimachia terrestris','Lysimachia terrestr',2,0,'','','Linnaeus|Britton|Sterns|Poggenberg','2c90a0ec-0202-543d-ba31-88f6264c99dc','Lysimachia terrestris (Linnaeus) Britton, Sterns & Poggenberg','(Linnaeus) Britton, Sterns & Poggenberg','SPECIES','','Lysimachia','','terrestris','','','',NULL,'Britton, Sterns & Poggenberg','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28275','','','Lysimachia borealis (Rafinesque) U. Manns & Anderberg',1,'Lysimachia borealis','Lysimachia borealis','Lysimachia boreal',2,0,'','','Rafinesque|U. Manns|Anderberg','edbb5311-14fe-55b3-8ea7-dbca346ad103','Lysimachia borealis (Rafinesque) U. Manns & Anderberg','(Rafinesque) U. Manns & Anderberg','SPECIES','','Lysimachia','','borealis','','','',NULL,'U. Manns & Anderberg','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('271','','','Primuloideae',1,'Primuloideae','Primuloideae','Primuloideae',1,0,'','','','c5404195-855b-5c9f-a89b-085d9ff581af','Primuloideae','','SUBFAMILY','Primuloideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8346','','','Androsace chamaejasme Wulfén ex Host',2,'Androsace chamaejasme','Androsace chamaejasme','Androsace chamaeiasm',2,0,'','','Wulfén|Host','1a12a79f-b545-5d6b-a965-7fbc91be8484','Androsace chamaejasme Wulfén ex Host','Wulfén ex Host','SPECIES','','Androsace','','chamaejasme','','','',NULL,'','','','','','Wulfén','','Host','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8367','','','Douglasia ochotensis (Roemer & Schultes) Hultén',1,'Douglasia ochotensis','Douglasia ochotensis','Douglasia ochotens',2,0,'','','Roemer|Schultes|Hultén','b1a11b3f-52f5-59e2-b6ca-4cecc4e75d0b','Douglasia ochotensis (Roemer & Schultes) Hultén','(Roemer & Schultes) Hultén','SPECIES','','Douglasia','','ochotensis','','','',NULL,'Hultén','','','','','Roemer & Schultes','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22665','','','Primula subg. Aleuritia (Duby) Wendelbo',2,'Aleuritia','Primula subgen. Aleuritia','Aleuritia',1,0,'','','Duby|Wendelbo','f50d8dd2-6a05-5952-a315-4f14b598ee2f','Primula subg. Aleuritia (Duby) Wendelbo','(Duby) Wendelbo','SUBGENUS','Aleuritia','','','','','','',NULL,'Wendelbo','','','','','Duby','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8377','','','Primula stricta Hornemann',1,'Primula stricta','Primula stricta','Primula strict',2,0,'','','Hornemann','5f58e908-ce17-56e5-8c47-d997335c14a1','Primula stricta Hornemann','Hornemann','SPECIES','','Primula','','stricta','','','',NULL,'','','','','','Hornemann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8376','','','Primula nutans Georgi',1,'Primula nutans','Primula nutans','Primula nutans',2,0,'','','Georgi','daafcbac-c7e4-5737-9dde-1f79f3bd6492','Primula nutans Georgi','Georgi','SPECIES','','Primula','','nutans','','','',NULL,'','','','','','Georgi','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9791','','','Primula ×morissetii Lepage',3,'','','',NULL,NULL,'','','','','Primula ×morissetii Lepage','Lepage','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8350','','','Primula conjugens (Greene) A.R. Mast & Reveal var. conjugens',1,'Primula conjugens conjugens','Primula conjugens var. conjugens','Primula coniugens coniugens',3,0,'','','','9b39971b-0b18-5e26-9afd-64192d4993d2','Primula conjugens (Greene) A.R. Mast & Reveal var. conjugens','(Greene) A.R. Mast & Reveal','VARIETY','','Primula','','conjugens','conjugens','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8354','','','Primula pauciflora (Greene) A.R. Mast & Reveal',1,'Primula pauciflora','Primula pauciflora','Primula pauciflor',2,0,'','','Greene|A. R. Mast|Reveal','8f0c9490-03e7-5a22-9553-3a6054c71a62','Primula pauciflora (Greene) A.R. Mast & Reveal','(Greene) A.R. Mast & Reveal','SPECIES','','Primula','','pauciflora','','','',NULL,'A. R. Mast & Reveal','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2247','','','Primula sect. Cuneifolia Balfour',2,'Cuneifolia','Primula sect. Cuneifolia','Cuneifolia',1,0,'','','Balfour','1e74f933-a9c3-5fb3-b4a2-085cf0651726','Primula sect. Cuneifolia Balfour','Balfour','SECTION','Cuneifolia','','','','','','',NULL,'','','','','','Balfour','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23711','','','Primula sect. Primula Linnaeus',2,'Primula','Primula sect. Primula','Primula',1,0,'','','Linnaeus','6bf12c4c-329b-5f58-a2c7-7a1ce3bae290','Primula sect. Primula Linnaeus','Linnaeus','SECTION','Primula','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29471','','','Primula sect. Proliferae Pax',2,'Proliferae','Primula sect. Proliferae','Proliferae',1,0,'','','Pax','09c21d3c-12e2-551e-b3e3-4190cd814866','Primula sect. Proliferae Pax','Pax','SECTION','Proliferae','','','','','','',NULL,'','','','','','Pax','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1897','','','Hottonia Linnaeus',1,'Hottonia','Hottonia','Hottonia',1,0,'','','Linnaeus','770ee143-02f1-574d-bf82-4a0a8ff1bdc9','Hottonia Linnaeus','Linnaeus','GENUS','Hottonia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29037','','','Cyclamen',1,'Cyclamen','Cyclamen','Cyclamen',1,0,'','','','4d956171-c61e-5a17-9191-c6261a682cd9','Cyclamen','','GENUS','Cyclamen','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9223','','','Sarracenia purpurea Linnaeus',1,'Sarracenia purpurea','Sarracenia purpurea','Sarracenia purpure',2,0,'','','Linnaeus','c6cb60f4-6e8d-50ad-ad3f-7f7d7f951b45','Sarracenia purpurea Linnaeus','Linnaeus','SPECIES','','Sarracenia','','purpurea','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9565','','','Darlingtonia californica Torrey',1,'Darlingtonia californica','Darlingtonia californica','Darlingtonia californic',2,0,'','','Torrey','8343e2f8-cd91-5bfc-aca4-b84099f8e667','Darlingtonia californica Torrey','Torrey','SPECIES','','Darlingtonia','','californica','','','',NULL,'','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2663','','','Apocynum ×floribundum Greene',3,'','','',NULL,NULL,'','','','','Apocynum ×floribundum Greene','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2659','','','Apocynum androsaemifolium Linnaeus',1,'Apocynum androsaemifolium','Apocynum androsaemifolium','Apocynum androsaemifoli',2,0,'','','Linnaeus','29667230-ef33-5db8-84a2-9dfe081ae81a','Apocynum androsaemifolium Linnaeus','Linnaeus','SPECIES','','Apocynum','','androsaemifolium','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2706','','','Asclepias ovalifolia Decaisne',1,'Asclepias ovalifolia','Asclepias ovalifolia','Asclepias oualifol',2,0,'','','Decaisne','d32b59c7-d3bd-5979-bddb-29e9b9ade016','Asclepias ovalifolia Decaisne','Decaisne','SPECIES','','Asclepias','','ovalifolia','','','',NULL,'','','','','','Decaisne','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2714','','','Asclepias variegata Linnaeus',1,'Asclepias variegata','Asclepias variegata','Asclepias uariegat',2,0,'','','Linnaeus','40220abf-2bd2-59c6-a53d-21f451cdd375','Asclepias variegata Linnaeus','Linnaeus','SPECIES','','Asclepias','','variegata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10139','','','Asclepias tuberosa subsp. interior Woodson',1,'Asclepias tuberosa interior','Asclepias tuberosa subsp. interior','Asclepias tuberos interior',3,0,'','','Woodson','3f941a52-eff0-5a87-afea-f6e1382b33a9','Asclepias tuberosa subsp. interior Woodson','Woodson','SUBSPECIES','','Asclepias','','tuberosa','interior','','',NULL,'','','','','','Woodson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30258','','','Vincetoxicum Wolf',1,'Vincetoxicum','Vincetoxicum','Vincetoxicum',1,0,'','','Wolf','9554e798-d7b6-54c8-b00b-1845662d304a','Vincetoxicum Wolf','Wolf','GENUS','Vincetoxicum','','','','','','',NULL,'','','','','','Wolf','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('386','','','Rauvolfioideae',1,'Rauvolfioideae','Rauvolfioideae','Rauvolfioideae',1,0,'','','','645574f8-5bfc-543d-b2a6-973db0b8fe5b','Rauvolfioideae','','SUBFAMILY','Rauvolfioideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('135','','','Gentianaceae de Jussieu',1,'Gentianaceae','Gentianaceae','Gentianaceae',1,0,'','','de Jussieu','8ae5c0b3-0fa0-58ce-95a7-7eaf629c3ea6','Gentianaceae de Jussieu','de Jussieu','FAMILY','Gentianaceae','','','','','','',NULL,'','','','','','de Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1182','','','Frasera Walter',1,'Frasera','Frasera','Frasera',1,0,'','','Walter','805e22cc-897d-5d49-842e-11c6157b3bc1','Frasera Walter','Walter','GENUS','Frasera','','','','','','',NULL,'','','','','','Walter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6011','','','Gentianella aurea (Linnaeus) Harry Smith ex Hylander',2,'Gentianella aurea','Gentianella aurea','Gentianella aure',2,0,'','','Linnaeus|Harry Smith|Hylander','98c84664-f69a-5d1a-b83b-1c897922544c','Gentianella aurea (Linnaeus) Harry Smith ex Hylander','(Linnaeus) Harry Smith ex Hylander','SPECIES','','Gentianella','','aurea','','','',NULL,'Harry Smith','','Hylander','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1201','','','Gentianopsis Ma',1,'Gentianopsis','Gentianopsis','Gentianopsis',1,0,'','','Ma','ad84e46a-7935-5643-bc0e-b6785ce9b8d7','Gentianopsis Ma','Ma','GENUS','Gentianopsis','','','','','','',NULL,'','','','','','Ma','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6021','','','Gentianopsis detonsa subsp. nesophila (Holm) J.S. Pringle',1,'Gentianopsis detonsa nesophila','Gentianopsis detonsa subsp. nesophila','Gentianopsis detons nesophil',3,0,'','','Holm|J. S. Pringle','80e3b955-77aa-53a1-ba4c-4f4e837c9aa3','Gentianopsis detonsa subsp. nesophila (Holm) J.S. Pringle','(Holm) J.S. Pringle','SUBSPECIES','','Gentianopsis','','detonsa','nesophila','','',NULL,'J. S. Pringle','','','','','Holm','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6026','','','Gentianopsis virgata (Rafinesque) Holub',1,'Gentianopsis virgata','Gentianopsis virgata','Gentianopsis uirgat',2,0,'','','Rafinesque|Holub','75fc008d-88e2-526e-b85a-cd677bd0c5d2','Gentianopsis virgata (Rafinesque) Holub','(Rafinesque) Holub','SPECIES','','Gentianopsis','','virgata','','','',NULL,'Holub','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6029','','','Halenia deflexa (Smith) Grisebach',1,'Halenia deflexa','Halenia deflexa','Halenia deflex',2,0,'','','Smith|Grisebach','1cd0b521-e888-5e39-9618-a6fb85037222','Halenia deflexa (Smith) Grisebach','(Smith) Grisebach','SPECIES','','Halenia','','deflexa','','','',NULL,'Grisebach','','','','','Smith','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1960','','','Comastoma (Wettstein) Toyokuni',2,'Comastoma','Comastoma','Comastoma',1,0,'','','Wettstein|Toyokuni','b9edf7ba-10ef-515c-932b-acd11d339110','Comastoma (Wettstein) Toyokuni','(Wettstein) Toyokuni','GENUS','Comastoma','','','','','','',NULL,'Toyokuni','','','','','Wettstein','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6017','','','Comastoma tenellum (Rottbøll) Toyokuni',1,'Comastoma tenellum','Comastoma tenellum','Comastoma tenell',2,0,'','','Rottbøll|Toyokuni','673dd560-e8fe-5930-907f-7b5c3a4d32b4','Comastoma tenellum (Rottbøll) Toyokuni','(Rottbøll) Toyokuni','SPECIES','','Comastoma','','tenellum','','','',NULL,'Toyokuni','','','','','Rottbøll','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6001','','','Gentiana nivalis Linnaeus',1,'Gentiana nivalis','Gentiana nivalis','Gentiana niual',2,0,'','','Linnaeus','92057358-03ea-5649-8701-35cfa9e1f93e','Gentiana nivalis Linnaeus','Linnaeus','SPECIES','','Gentiana','','nivalis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5998','','','Gentiana fremontii Torrey',1,'Gentiana fremontii','Gentiana fremontii','Gentiana fremont',2,0,'','','Torrey','13432843-da8b-5287-9bfa-b6151bd26405','Gentiana fremontii Torrey','Torrey','SPECIES','','Gentiana','','fremontii','','','',NULL,'','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33689','','','Gentiana sect. Pneumonanthe Gaudin',2,'Pneumonanthe','Gentiana sect. Pneumonanthe','Pneumonanthe',1,0,'','','Gaudin','da85736e-64fb-5533-a3c9-d6d8c61a0e5d','Gentiana sect. Pneumonanthe Gaudin','Gaudin','SECTION','Pneumonanthe','','','','','','',NULL,'','','','','','Gaudin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5994','','','Gentiana andrewsii Grisebach',1,'Gentiana andrewsii','Gentiana andrewsii','Gentiana andrews',2,0,'','','Grisebach','393b0128-7c4f-564c-b44e-7ffb51ffcf75','Gentiana andrewsii Grisebach','Grisebach','SPECIES','','Gentiana','','andrewsii','','','',NULL,'','','','','','Grisebach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6004','','','Gentiana puberulenta J.S. Pringle',1,'Gentiana puberulenta','Gentiana puberulenta','Gentiana puberulent',2,0,'','','J. S. Pringle','a795b595-13ee-5553-91a0-02abfadfffc9','Gentiana puberulenta J.S. Pringle','J.S. Pringle','SPECIES','','Gentiana','','puberulenta','','','',NULL,'','','','','','J. S. Pringle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5988','','','Centaurium pulchellum (Swartz) Druce',1,'Centaurium pulchellum','Centaurium pulchellum','Centaurium pulchell',2,0,'','','Swartz|Druce','b0e1ce79-1d25-5299-bee7-f3ebad32d943','Centaurium pulchellum (Swartz) Druce','(Swartz) Druce','SPECIES','','Centaurium','','pulchellum','','','',NULL,'Druce','','','','','Swartz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26790','','','Zeltnera muehlenbergii (Grisebach) G. Mansion',1,'Zeltnera muehlenbergii','Zeltnera muehlenbergii','Zeltnera muehlenberg',2,0,'','','Grisebach|G. Mansion','609f4d8e-095d-505f-9627-8c66d305fc29','Zeltnera muehlenbergii (Grisebach) G. Mansion','(Grisebach) G. Mansion','SPECIES','','Zeltnera','','muehlenbergii','','','',NULL,'G. Mansion','','','','','Grisebach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8997','','','Galium bifolium S. Watson',1,'Galium bifolium','Galium bifolium','Galium bifoli',2,0,'','','S. Watson','fe829b07-553e-5459-8bd5-5238a7ce91ed','Galium bifolium S. Watson','S. Watson','SPECIES','','Galium','','bifolium','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9002','','','Galium concinnum Torrey & A. Gray',1,'Galium concinnum','Galium concinnum','Galium concinn',2,0,'','','Torrey|A. Gray','6a8d74d4-7388-5b36-9c54-1077ba01c024','Galium concinnum Torrey & A. Gray','Torrey & A. Gray','SPECIES','','Galium','','concinnum','','','',NULL,'','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9009','','','Galium mollugo Linnaeus',1,'Galium mollugo','Galium mollugo','Galium mollug',2,0,'','','Linnaeus','d460b153-d67e-504c-9ec8-132fbe1eedc2','Galium mollugo Linnaeus','Linnaeus','SPECIES','','Galium','','mollugo','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9013','','','Galium palustre Linnaeus',1,'Galium palustre','Galium palustre','Galium palustr',2,0,'','','Linnaeus','cefa8193-c604-5c63-819c-1379c8c0352e','Galium palustre Linnaeus','Linnaeus','SPECIES','','Galium','','palustre','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9018','','','Galium spurium Linnaeus',1,'Galium spurium','Galium spurium','Galium spuri',2,0,'','','Linnaeus','b1f30e93-4870-5c38-add6-9afaa60b49f1','Galium spurium Linnaeus','Linnaeus','SPECIES','','Galium','','spurium','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9020','','','Galium tinctorium Linnaeus',1,'Galium tinctorium','Galium tinctorium','Galium tinctori',2,0,'','','Linnaeus','948b552b-2b9e-5e70-baba-5f60b594e33d','Galium tinctorium Linnaeus','Linnaeus','SPECIES','','Galium','','tinctorium','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9031','','','Galium ×pomeranicum Retzius',3,'','','',NULL,NULL,'','','','','Galium ×pomeranicum Retzius','Retzius','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9023','','','Galium trifidum Linnaeus',1,'Galium trifidum','Galium trifidum','Galium trifid',2,0,'','','Linnaeus','b4559596-5a38-5922-8d61-282e2c2c0b8a','Galium trifidum Linnaeus','Linnaeus','SPECIES','','Galium','','trifidum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9026','','','Galium trifidum Linnaeus subsp. trifidum',1,'Galium trifidum trifidum','Galium trifidum subsp. trifidum','Galium trifid trifid',3,0,'','','','c80e4540-106a-521b-9f2e-6354ffc7ff20','Galium trifidum Linnaeus subsp. trifidum','Linnaeus','SUBSPECIES','','Galium','','trifidum','trifidum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1425','','','Mitchella Linnaeus',1,'Mitchella','Mitchella','Mitchella',1,0,'','','Linnaeus','78cc20f1-90b0-5a95-a96c-a66bfe9f54f3','Mitchella Linnaeus','Linnaeus','GENUS','Mitchella','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1259','','','Houstonia Linnaeus',1,'Houstonia','Houstonia','Houstonia',1,0,'','','Linnaeus','2ce5bea5-977f-5ffe-9089-7a1dbd752b32','Houstonia Linnaeus','Linnaeus','GENUS','Houstonia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('970','','','Cephalanthus Linnaeus',1,'Cephalanthus','Cephalanthus','Cephalanthus',1,0,'','','Linnaeus','9a8b9bc8-2a3b-5edc-ac37-def32298a791','Cephalanthus Linnaeus','Linnaeus','GENUS','Cephalanthus','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('740','','','Justiciinae',1,'Justiciinae','Justiciinae','Justiciinae',1,0,'','','','f39c0364-b51f-506b-ab78-fe6cb9edb44f','Justiciinae','','SUBTRIBE','Justiciinae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2431','','','Justicia americana (Linnaeus) Vahl',1,'Justicia americana','Justicia americana','Justicia american',2,0,'','','Linnaeus|Vahl','376bb247-739f-5737-b5f5-6ac24ac71e1e','Justicia americana (Linnaeus) Vahl','(Linnaeus) Vahl','SPECIES','','Justicia','','americana','','','',NULL,'Vahl','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3732','','','Catalpa ×erubescens Carrière',3,'','','',NULL,NULL,'','','','','Catalpa ×erubescens Carrière','Carrière','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('152','','','Lamiaceae Martinov',1,'Lamiaceae','Lamiaceae','Lamiaceae',1,0,'','','Martinov','1fe2ae12-04da-5133-99ec-941832434a9c','Lamiaceae Martinov','Martinov','FAMILY','Lamiaceae','','','','','','',NULL,'','','','','','Martinov','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6353','','','Agastache scrophulariifolia (Willdenow) Kuntze',1,'Agastache scrophulariifolia','Agastache scrophulariifolia','Agastache scrophulariifol',2,0,'','','Willdenow|Kuntze','458361b0-11e0-560f-b00f-6098b6922eab','Agastache scrophulariifolia (Willdenow) Kuntze','(Willdenow) Kuntze','SPECIES','','Agastache','','scrophulariifolia','','','',NULL,'Kuntze','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1209','','','Glechoma Linnaeus',1,'Glechoma','Glechoma','Glechoma',1,0,'','','Linnaeus','df32f409-efa6-50c7-8f21-fa3692fc7660','Glechoma Linnaeus','Linnaeus','GENUS','Glechoma','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6427','','','Nepeta grandiflora Bieberstein',1,'Nepeta grandiflora','Nepeta grandiflora','Nepeta grandiflor',2,0,'','','Bieberstein','6ff188f4-b155-546f-b4d1-4df62a30977d','Nepeta grandiflora Bieberstein','Bieberstein','SPECIES','','Nepeta','','grandiflora','','','',NULL,'','','','','','Bieberstein','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1009','','','Clinopodium Linnaeus',1,'Clinopodium','Clinopodium','Clinopodium',1,0,'','','Linnaeus','ec2f8ac0-54bd-59de-923c-d17b3592dde6','Clinopodium Linnaeus','Linnaeus','GENUS','Clinopodium','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6368','','','Clinopodium vulgare Linnaeus',1,'Clinopodium vulgare','Clinopodium vulgare','Clinopodium uulgar',2,0,'','','Linnaeus','cb1c20c3-4494-5209-8f36-84db25cb5e53','Clinopodium vulgare Linnaeus','Linnaeus','SPECIES','','Clinopodium','','vulgare','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6364','','','Clinopodium menthifolium subsp. ascendens (Jordan) Govaerts',1,'Clinopodium menthifolium ascendens','Clinopodium menthifolium subsp. ascendens','Clinopodium menthifoli ascendens',3,0,'','','Jordan|Govaerts','add3f688-dbeb-5ce8-b4d7-b4eb1734f83f','Clinopodium menthifolium subsp. ascendens (Jordan) Govaerts','(Jordan) Govaerts','SUBSPECIES','','Clinopodium','','menthifolium','ascendens','','',NULL,'Govaerts','','','','','Jordan','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6378','','','Hedeoma hispida Pursh',1,'Hedeoma hispida','Hedeoma hispida','Hedeoma hispid',2,0,'','','Pursh','a6eaca1d-f692-5458-baf0-9b94fc564978','Hedeoma hispida Pursh','Pursh','SPECIES','','Hedeoma','','hispida','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6393','','','Lycopus europaeus Linnaeus',1,'Lycopus europaeus','Lycopus europaeus','Lycopus europae',2,0,'','','Linnaeus','d7dc45ff-0ca4-58d8-97a2-510c189653b7','Lycopus europaeus Linnaeus','Linnaeus','SPECIES','','Lycopus','','europaeus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23626','','','Lycopus rubellus Moench',1,'Lycopus rubellus','Lycopus rubellus','Lycopus rubell',2,0,'','','Moench','48a389c3-aa0a-5205-80e0-67a5b27aea75','Lycopus rubellus Moench','Moench','SPECIES','','Lycopus','','rubellus','','','',NULL,'','','','','','Moench','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32742','','','Mentha sect. Mentha Linnaeus',2,'Mentha','Mentha sect. Mentha','Mentha',1,0,'','','Linnaeus','9046e25e-c2cd-5dec-b4cc-c3e18320d642','Mentha sect. Mentha Linnaeus','Linnaeus','SECTION','Mentha','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6406','','','Mentha suaveolens Ehrhart',1,'Mentha suaveolens','Mentha suaveolens','Mentha suaueolens',2,0,'','','Ehrhart','9fcbe11a-e8e9-57c6-9480-a5da81ee649e','Mentha suaveolens Ehrhart','Ehrhart','SPECIES','','Mentha','','suaveolens','','','',NULL,'','','','','','Ehrhart','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6412','','','Mentha ×villosa Hudson',3,'','','',NULL,NULL,'','','','','Mentha ×villosa Hudson','Hudson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16998','','','Mentha ×gracilis Sole',3,'','','',NULL,NULL,'','','','','Mentha ×gracilis Sole','Sole','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32654','','','Monarda subg. Monarda Linnaeus',2,'Monarda','Monarda subgen. Monarda','Monarda',1,0,'','','Linnaeus','0ad2444d-1d7c-5bc9-8bef-9b4a6721c2ba','Monarda subg. Monarda Linnaeus','Linnaeus','SUBGENUS','Monarda','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6418','','','Monarda fistulosa var. menthifolia (Graham) Fernald',1,'Monarda fistulosa menthifolia','Monarda fistulosa var. menthifolia','Monarda fistulos menthifol',3,0,'','','Graham|Fernald','771ee9b6-5870-5273-beda-f1dfaa2cf1e8','Monarda fistulosa var. menthifolia (Graham) Fernald','(Graham) Fernald','VARIETY','','Monarda','','fistulosa','menthifolia','','',NULL,'Fernald','','','','','Graham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6423','','','Monardella odoratissima Bentham subsp. odoratissima',1,'Monardella odoratissima odoratissima','Monardella odoratissima subsp. odoratissima','Monardella odoratissim odoratissim',3,0,'','','','74b069ec-f357-534f-96e2-c61ef12e3a1b','Monardella odoratissima Bentham subsp. odoratissima','Bentham','SUBSPECIES','','Monardella','','odoratissima','odoratissima','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6437','','','Prunella vulgaris Linnaeus',1,'Prunella vulgaris','Prunella vulgaris','Prunella uulgar',2,0,'','','Linnaeus','a612b4f4-7909-513f-a1d9-90a670460fa9','Prunella vulgaris Linnaeus','Linnaeus','SPECIES','','Prunella','','vulgaris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1605','','','Pycnanthemum G. Don',1,'Pycnanthemum','Pycnanthemum','Pycnanthemum',1,0,'','','G. Don','db8a3f0c-854e-5d56-9a12-cfe154c6d36a','Pycnanthemum G. Don','G. Don','GENUS','Pycnanthemum','','','','','','',NULL,'','','','','','G. Don','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6445','','','Pycnanthemum virginianum (Linnaeus) B.L. Robinson & Fernald',1,'Pycnanthemum virginianum','Pycnanthemum virginianum','Pycnanthemum uirginian',2,0,'','','Linnaeus|B. L. Robinson|Fernald','b0e26a16-68b8-5679-8528-1996414dba4a','Pycnanthemum virginianum (Linnaeus) B.L. Robinson & Fernald','(Linnaeus) B.L. Robinson & Fernald','SPECIES','','Pycnanthemum','','virginianum','','','',NULL,'B. L. Robinson & Fernald','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31502','','','Thymus praecox subsp. britannicus (Ronniger) Holub',1,'Thymus praecox britannicus','Thymus praecox subsp. britannicus','Thymus praecox britannic',3,0,'','','Ronniger|Holub','27947305-0b65-532b-8800-722801ac6fe8','Thymus praecox subsp. britannicus (Ronniger) Holub','(Ronniger) Holub','SUBSPECIES','','Thymus','','praecox','britannicus','','',NULL,'Holub','','','','','Ronniger','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6448','','','Salvia pratensis Linnaeus',1,'Salvia pratensis','Salvia pratensis','Salvia pratens',2,0,'','','Linnaeus','74365a3e-208a-59dd-8974-944044394cea','Salvia pratensis Linnaeus','Linnaeus','SPECIES','','Salvia','','pratensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1406','','','Melissa Linnaeus',1,'Melissa','Melissa','Melissa',1,0,'','','Linnaeus','5376d8de-dda0-573a-8d02-0784104e7cfd','Melissa Linnaeus','Linnaeus','GENUS','Melissa','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6398','','','Melissa officinalis Linnaeus subsp. officinalis',1,'Melissa officinalis officinalis','Melissa officinalis subsp. officinalis','Melissa officinal officinal',3,0,'','','','1005737c-9ba5-5d78-bcb0-e33fd720ad9a','Melissa officinalis Linnaeus subsp. officinalis','Linnaeus','SUBSPECIES','','Melissa','','officinalis','officinalis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6355','','','Ajuga genevensis Linnaeus',1,'Ajuga genevensis','Ajuga genevensis','Ajuga geneuens',2,0,'','','Linnaeus','7b347f74-1049-546c-bf4b-099343dc5639','Ajuga genevensis Linnaeus','Linnaeus','SPECIES','','Ajuga','','genevensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6476','','','Teucrium canadense Linnaeus',1,'Teucrium canadense','Teucrium canadense','Teucrium canadens',2,0,'','','Linnaeus','db2bb2a3-2ef5-5b06-a742-16423907c786','Teucrium canadense Linnaeus','Linnaeus','SPECIES','','Teucrium','','canadense','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17037','','','Teucrium canadense var. occidentale (A. Gray) E.M. McClintock & Epling',1,'Teucrium canadense occidentale','Teucrium canadense var. occidentale','Teucrium canadens occidental',3,0,'','','A. Gray|E. M. McClintock|Epling','3cb8b0eb-0de5-5458-9a40-a3cb037dd1b8','Teucrium canadense var. occidentale (A. Gray) E.M. McClintock & Epling','(A. Gray) E.M. McClintock & Epling','VARIETY','','Teucrium','','canadense','occidentale','','',NULL,'E. M. McClintock & Epling','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6484','','','Trichostema dichotomum Linnaeus',1,'Trichostema dichotomum','Trichostema dichotomum','Trichostema dichotom',2,0,'','','Linnaeus','ea67b049-1fbd-54d5-a9bc-63db8509156b','Trichostema dichotomum Linnaeus','Linnaeus','SPECIES','','Trichostema','','dichotomum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('884','','','Ballota Linnaeus',1,'Ballota','Ballota','Ballota',1,0,'','','Linnaeus','4f8c81ac-f73f-500d-873b-b00a9c63f331','Ballota Linnaeus','Linnaeus','GENUS','Ballota','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1395','','','Marrubium Linnaeus',1,'Marrubium','Marrubium','Marrubium',1,0,'','','Linnaeus','5a578aa8-2ab3-5a59-b77e-9a0cc2cea472','Marrubium Linnaeus','Linnaeus','GENUS','Marrubium','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1314','','','Lamium Linnaeus',1,'Lamium','Lamium','Lamium',1,0,'','','Linnaeus','0381ae85-fd2b-54fa-93ec-8dc1dc9c6cab','Lamium Linnaeus','Linnaeus','GENUS','Lamium','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32270','','','Lamium galeobdolon (Linnaeus) Linnaeus',1,'Lamium galeobdolon','Lamium galeobdolon','Lamium galeobdolon',2,0,'','','Linnaeus','0457077a-2025-5de8-a661-ec17c95d617c','Lamium galeobdolon (Linnaeus) Linnaeus','(Linnaeus) Linnaeus','SPECIES','','Lamium','','galeobdolon','','','',NULL,'Linnaeus','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1545','','','Physostegia Bentham',1,'Physostegia','Physostegia','Physostegia',1,0,'','','Bentham','65fd8b2a-8c6f-50a3-8352-8a4d88c491be','Physostegia Bentham','Bentham','GENUS','Physostegia','','','','','','',NULL,'','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9888','','','Physostegia virginiana (Linnaeus) Bentham',1,'Physostegia virginiana','Physostegia virginiana','Physostegia uirginian',2,0,'','','Linnaeus|Bentham','bb5f60fa-6012-504f-9566-6cacf43425d2','Physostegia virginiana (Linnaeus) Bentham','(Linnaeus) Bentham','SPECIES','','Physostegia','','virginiana','','','',NULL,'Bentham','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1715','','','Stachys Linnaeus',1,'Stachys','Stachys','Stachys',1,0,'','','Linnaeus','8319c726-666d-533e-909d-e596096336f9','Stachys Linnaeus','Linnaeus','GENUS','Stachys','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6465','','','Stachys germanica Linnaeus',1,'Stachys germanica','Stachys germanica','Stachys germanic',2,0,'','','Linnaeus','03b8f95d-5c26-55bb-a827-271b1970738e','Stachys germanica Linnaeus','Linnaeus','SPECIES','','Stachys','','germanica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6464','','','Stachys chamissonis Bentham',1,'Stachys chamissonis','Stachys chamissonis','Stachys chamisson',2,0,'','','Bentham','a1d02125-d6f0-5b34-8791-3c9cef61f21f','Stachys chamissonis Bentham','Bentham','SPECIES','','Stachys','','chamissonis','','','',NULL,'','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6472','','','Stachys pilosa Nuttall var. pilosa',1,'Stachys pilosa pilosa','Stachys pilosa var. pilosa','Stachys pilos pilos',3,0,'','','','dd9371f3-ba73-56fd-a6bb-1b5ee1e5a82b','Stachys pilosa Nuttall var. pilosa','Nuttall','VARIETY','','Stachys','','pilosa','pilosa','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6373','','','Galeopsis bifida Boenninghausen',1,'Galeopsis bifida','Galeopsis bifida','Galeopsis bifid',2,0,'','','Boenninghausen','189c5d7f-2fe1-5315-8260-b9a2dfc69d33','Galeopsis bifida Boenninghausen','Boenninghausen','SPECIES','','Galeopsis','','bifida','','','',NULL,'','','','','','Boenninghausen','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1671','','','Scutellaria Linnaeus',1,'Scutellaria','Scutellaria','Scutellaria',1,0,'','','Linnaeus','45f62b10-39fe-58f6-93fe-32d5554bf218','Scutellaria Linnaeus','Linnaeus','GENUS','Scutellaria','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33972','','','Scutellaria angustifolia Pursh var. angustifolia',1,'Scutellaria angustifolia angustifolia','Scutellaria angustifolia var. angustifolia','Scutellaria angustifol angustifol',3,0,'','','','50c343df-8f45-52bc-96fa-f2f7f8a80e44','Scutellaria angustifolia Pursh var. angustifolia','Pursh','VARIETY','','Scutellaria','','angustifolia','angustifolia','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6455','','','Scutellaria galericulata Linnaeus',1,'Scutellaria galericulata','Scutellaria galericulata','Scutellaria galericulat',2,0,'','','Linnaeus','11726a12-6c0a-5f29-af7c-6bbaaca6f107','Scutellaria galericulata Linnaeus','Linnaeus','SPECIES','','Scutellaria','','galericulata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9863','','','Pinguicula vulgaris subsp. macroceras (Pallas ex Link) Calder & Roy L. Taylor',2,'Pinguicula vulgaris macroceras','Pinguicula vulgaris subsp. macroceras','Pinguicula uulgar macrocer',3,0,'','','Pallas|Link|Calder|Roy L. Taylor','ef0f788f-07f9-5bfa-a589-74712568b93e','Pinguicula vulgaris subsp. macroceras (Pallas ex Link) Calder & Roy L. Taylor','(Pallas ex Link) Calder & Roy L. Taylor','SUBSPECIES','','Pinguicula','','vulgaris','macroceras','','',NULL,'Calder & Roy L. Taylor','','','','','Pallas','','Link','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6512','','','Utricularia ochroleuca R.W. Hartman',1,'Utricularia ochroleuca','Utricularia ochroleuca','Utricularia ochroleuc',2,0,'','','R. W. Hartman','1b6bf489-7fe6-5368-ac9d-c352c443a6e2','Utricularia ochroleuca R.W. Hartman','R.W. Hartman','SPECIES','','Utricularia','','ochroleuca','','','',NULL,'','','','','','R. W. Hartman','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1351','','','Lindernia Allioni',1,'Lindernia','Lindernia','Lindernia',1,0,'','','Allioni','d3b7e6bd-5a58-52fe-8881-d4e9f93575f8','Lindernia Allioni','Allioni','GENUS','Lindernia','','','','','','',NULL,'','','','','','Allioni','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7255','','','Lindernia dubia (Linnaeus) Pennell',1,'Lindernia dubia','Lindernia dubia','Lindernia dub',2,0,'','','Linnaeus|Pennell','3f5db235-5dae-5984-8cd7-dea15325b537','Lindernia dubia (Linnaeus) Pennell','(Linnaeus) Pennell','SPECIES','','Lindernia','','dubia','','','',NULL,'Pennell','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('177','','','Oleaceae Hoffmannsegg & Link',1,'Oleaceae','Oleaceae','Oleaceae',1,0,'','','Hoffmannsegg|Link','d46146f8-ea9b-5f85-afeb-fe33d6b4e983','Oleaceae Hoffmannsegg & Link','Hoffmannsegg & Link','FAMILY','Oleaceae','','','','','','',NULL,'','','','','','Hoffmannsegg & Link','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9657','','','Forsythia suspensa (Thunberg) Vahl',1,'Forsythia suspensa','Forsythia suspensa','Forsythia suspens',2,0,'','','Thunberg|Vahl','c6557b8c-c79f-5432-8d58-02b21708477f','Forsythia suspensa (Thunberg) Vahl','(Thunberg) Vahl','SPECIES','','Forsythia','','suspensa','','','',NULL,'Vahl','','','','','Thunberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6731','','','Fraxinus profunda (Bush) Bush',1,'Fraxinus profunda','Fraxinus profunda','Fraxinus profund',2,0,'','','Bush','6954f3cd-5e57-55b8-8a68-7f7bfb5886d6','Fraxinus profunda (Bush) Bush','(Bush) Bush','SPECIES','','Fraxinus','','profunda','','','',NULL,'Bush','','','','','Bush','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6733','','','Ligustrum ovalifolium Hasskarl',1,'Ligustrum ovalifolium','Ligustrum ovalifolium','Ligustrum oualifoli',2,0,'','','Hasskarl','30ff56e6-b4dd-5c84-8e90-2755f51d86c7','Ligustrum ovalifolium Hasskarl','Hasskarl','SPECIES','','Ligustrum','','ovalifolium','','','',NULL,'','','','','','Hasskarl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1736','','','Syringa Linnaeus',1,'Syringa','Syringa','Syringa',1,0,'','','Linnaeus','5b73f360-ed58-505a-bde5-76822ebb806a','Syringa Linnaeus','Linnaeus','GENUS','Syringa','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23670','','','Syringa reticulata (Blume) H. Hara subsp. reticulata',1,'Syringa reticulata reticulata','Syringa reticulata subsp. reticulata','Syringa reticulat reticulat',3,0,'','','','083b0714-3860-576d-9c44-1dff69a1c6d4','Syringa reticulata (Blume) H. Hara subsp. reticulata','(Blume) H. Hara','SUBSPECIES','','Syringa','','reticulata','reticulata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('473','','','Buchnereae',1,'Buchnereae','Buchnereae','Buchnereae',1,0,'','','','a1392dbe-e0f4-5bf9-8367-d4f12ceb3deb','Buchnereae','','TRIBE','Buchnereae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('917','','','Buchnera Linnaeus',1,'Buchnera','Buchnera','Buchnera',1,0,'','','Linnaeus','a04a65b8-4ea4-5cea-8d05-3d214785d121','Buchnera Linnaeus','Linnaeus','GENUS','Buchnera','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('489','','','Castillejeae',1,'Castillejeae','Castillejeae','Castillejeae',1,0,'','','','aaf81c83-008a-59b8-981b-7810e2b343c5','Castillejeae','','TRIBE','Castillejeae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6976','','','Castilleja ambigua Hooker & Arnott',1,'Castilleja ambigua','Castilleja ambigua','Castilleja ambigu',2,0,'','','Hooker|Arnott','1c4991f7-25e2-5545-9446-7e7b9e66cdb1','Castilleja ambigua Hooker & Arnott','Hooker & Arnott','SPECIES','','Castilleja','','ambigua','','','',NULL,'','','','','','Hooker & Arnott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6981','','','Castilleja coccinea (Linnaeus) Sprengel',1,'Castilleja coccinea','Castilleja coccinea','Castilleja coccine',2,0,'','','Linnaeus|Sprengel','e118e088-dd27-5603-aa96-828042ca9e0c','Castilleja coccinea (Linnaeus) Sprengel','(Linnaeus) Sprengel','SPECIES','','Castilleja','','coccinea','','','',NULL,'Sprengel','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27572','','','Castilleja miniata var. fulva (Pennell) J.M. Egger',1,'Castilleja miniata fulva','Castilleja miniata var. fulva','Castilleja miniat fulu',3,0,'','','Pennell|J. M. Egger','7345168c-1768-5c68-9ab7-07302c472b4b','Castilleja miniata var. fulva (Pennell) J.M. Egger','(Pennell) J.M. Egger','VARIETY','','Castilleja','','miniata','fulva','','',NULL,'J. M. Egger','','','','','Pennell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29200','','','Castilleja miniata var. dixonii (Fernald) A. Nelson & J.F. Macbride',1,'Castilleja miniata dixonii','Castilleja miniata var. dixonii','Castilleja miniat dixon',3,0,'','','Fernald|A. Nelson|J. F. Macbride','803a0108-8c47-5547-8a83-0ebe6a35344d','Castilleja miniata var. dixonii (Fernald) A. Nelson & J.F. Macbride','(Fernald) A. Nelson & J.F. Macbride','VARIETY','','Castilleja','','miniata','dixonii','','',NULL,'A. Nelson & J. F. Macbride','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29211','','','Castilleja parviflora var. olympica (G.N. Jones) Ownbey',1,'Castilleja parviflora olympica','Castilleja parviflora var. olympica','Castilleja paruiflor olympic',3,0,'','','G. N. Jones|Ownbey','1cb29db1-6456-571d-a0f7-5b95de69b266','Castilleja parviflora var. olympica (G.N. Jones) Ownbey','(G.N. Jones) Ownbey','VARIETY','','Castilleja','','parviflora','olympica','','',NULL,'Ownbey','','','','','G. N. Jones','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7006','','','Castilleja unalaschcensis (Chamisso & Schlechtendal) Malte',1,'Castilleja unalaschcensis','Castilleja unalaschcensis','Castilleja unalaschcens',2,0,'','','Chamisso|Schlechtendal|Malte','812ff72a-6b23-5dd2-9a0c-05fef97d024d','Castilleja unalaschcensis (Chamisso & Schlechtendal) Malte','(Chamisso & Schlechtendal) Malte','SPECIES','','Castilleja','','unalaschcensis','','','',NULL,'Malte','','','','','Chamisso & Schlechtendal','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1490','','','Orthocarpus Nuttall',1,'Orthocarpus','Orthocarpus','Orthocarpus',1,0,'','','Nuttall','f8359ccd-e901-5046-982d-5d6760f6e708','Orthocarpus Nuttall','Nuttall','GENUS','Orthocarpus','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7037','','','Orthocarpus bracteosus Bentham',1,'Orthocarpus bracteosus','Orthocarpus bracteosus','Orthocarpus bracteos',2,0,'','','Bentham','bb5c61d7-0d7c-56f5-b0bd-019ae4ba7502','Orthocarpus bracteosus Bentham','Bentham','SPECIES','','Orthocarpus','','bracteosus','','','',NULL,'','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1515','','','Pedicularis Linnaeus',1,'Pedicularis','Pedicularis','Pedicularis',1,0,'','','Linnaeus','1ff6954d-3e31-564c-9d67-81ccdc05472b','Pedicularis Linnaeus','Linnaeus','GENUS','Pedicularis','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7047','','','Pedicularis capitata Adams',1,'Pedicularis capitata','Pedicularis capitata','Pedicularis capitat',2,0,'','','Adams','8a884182-fdf6-5041-9a78-5f4828a6449c','Pedicularis capitata Adams','Adams','SPECIES','','Pedicularis','','capitata','','','',NULL,'','','','','','Adams','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7053','','','Pedicularis labradorica Wirsing',1,'Pedicularis labradorica','Pedicularis labradorica','Pedicularis labradoric',2,0,'','','Wirsing','ce9a05d0-5118-5a45-aa8a-1715f478c13c','Pedicularis labradorica Wirsing','Wirsing','SPECIES','','Pedicularis','','labradorica','','','',NULL,'','','','','','Wirsing','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7058','','','Pedicularis lapponica Linnaeus',1,'Pedicularis lapponica','Pedicularis lapponica','Pedicularis lapponic',2,0,'','','Linnaeus','836d6fba-25e9-5e33-aeff-9a6dc801ae88','Pedicularis lapponica Linnaeus','Linnaeus','SPECIES','','Pedicularis','','lapponica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27515','','','Pedicularis palustris Linnaeus subsp. palustris',1,'Pedicularis palustris palustris','Pedicularis palustris subsp. palustris','Pedicularis palustr palustr',3,0,'','','','c4b461db-a739-548f-8399-f24d62c6326f','Pedicularis palustris Linnaeus subsp. palustris','Linnaeus','SUBSPECIES','','Pedicularis','','palustris','palustris','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7044','','','Pedicularis bracteosa Bentham',1,'Pedicularis bracteosa','Pedicularis bracteosa','Pedicularis bracteos',2,0,'','','Bentham','69384f0a-78a4-5577-85f8-3774e8111574','Pedicularis bracteosa Bentham','Bentham','SPECIES','','Pedicularis','','bracteosa','','','',NULL,'','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7056','','','Pedicularis langsdorffii subsp. arctica (R. Brown) Pennell ex Hultén',2,'Pedicularis langsdorffii arctica','Pedicularis langsdorffii subsp. arctica','Pedicularis langsdorff arctic',3,0,'','','R. Brown|Pennell|Hultén','8b613837-738e-54a6-bb5e-dbfdd80772bf','Pedicularis langsdorffii subsp. arctica (R. Brown) Pennell ex Hultén','(R. Brown) Pennell ex Hultén','SUBSPECIES','','Pedicularis','','langsdorffii','arctica','','',NULL,'Pennell','','Hultén','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7071','','','Triphysaria pusilla (Bentham) T.I. Chuang & Heckard',1,'Triphysaria pusilla','Triphysaria pusilla','Triphysaria pusill',2,0,'','','Bentham|T. I. Chuang|Heckard','ec0a8dcf-651f-5d4d-ad50-c1fb95e56cf4','Triphysaria pusilla (Bentham) T.I. Chuang & Heckard','(Bentham) T.I. Chuang & Heckard','SPECIES','','Triphysaria','','pusilla','','','',NULL,'T. I. Chuang & Heckard','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6956','','','Agalinis gattingeri (Small) Small',1,'Agalinis gattingeri','Agalinis gattingeri','Agalinis gattinger',2,0,'','','Small','236d288f-6a14-5a0b-8ab8-4e4bdd9568fe','Agalinis gattingeri (Small) Small','(Small) Small','SPECIES','','Agalinis','','gattingeri','','','',NULL,'Small','','','','','Small','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27502','','','Agalinis purpurea (Linnaeus) Pennell var. purpurea',1,'Agalinis purpurea purpurea','Agalinis purpurea var. purpurea','Agalinis purpure purpure',3,0,'','','','129dc5b6-f05b-52ed-a335-b4185e4eef81','Agalinis purpurea (Linnaeus) Pennell var. purpurea','(Linnaeus) Pennell','VARIETY','','Agalinis','','purpurea','purpurea','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('878','','','Aureolaria Rafinesque',1,'Aureolaria','Aureolaria','Aureolaria',1,0,'','','Rafinesque','5b47ddb7-478a-5ef0-ac0f-11e53a4c5bf1','Aureolaria Rafinesque','Rafinesque','GENUS','Aureolaria','','','','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6970','','','Aureolaria virginica (Linnaeus) Pennell',1,'Aureolaria virginica','Aureolaria virginica','Aureolaria uirginic',2,0,'','','Linnaeus|Pennell','1e3822ee-a49d-5a0d-8e15-b32654b4b896','Aureolaria virginica (Linnaeus) Pennell','(Linnaeus) Pennell','SPECIES','','Aureolaria','','virginica','','','',NULL,'Pennell','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('905','','','Boschniakia C.A. Meyer ex Bongard',2,'Boschniakia','Boschniakia','Boschniakia',1,0,'','','C. A. Meyer|Bongard','f3513155-bcde-5ddc-a183-20836ae0306a','Boschniakia C.A. Meyer ex Bongard','C.A. Meyer ex Bongard','GENUS','Boschniakia','','','','','','',NULL,'','','','','','C. A. Meyer','','Bongard','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1488','','','Orobanche Linnaeus',1,'Orobanche','Orobanche','Orobanche',1,0,'','','Linnaeus','49290012-d67e-5e2d-954b-5e2710f0a060','Orobanche Linnaeus','Linnaeus','GENUS','Orobanche','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31310','','','Aphyllon Mitchell',1,'Aphyllon','Aphyllon','Aphyllon',1,0,'','','Mitchell','9ffcb62d-0fea-5166-95e1-a7e19011e003','Aphyllon Mitchell','Mitchell','GENUS','Aphyllon','','','','','','',NULL,'','','','','','Mitchell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30147','','','Aphyllon purpureum (A. Heller) Holub',1,'Aphyllon purpureum','Aphyllon purpureum','Aphyllon purpure',2,0,'','','A. Heller|Holub','e4a642a9-c22e-5d80-b6a8-7947a15d4159','Aphyllon purpureum (A. Heller) Holub','(A. Heller) Holub','SPECIES','','Aphyllon','','purpureum','','','',NULL,'Holub','','','','','A. Heller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31316','','','Aphyllon californicum (Chamisso & Schlechtendal) A. Gray subsp. californicum',1,'Aphyllon californicum californicum','Aphyllon californicum subsp. californicum','Aphyllon californic californic',3,0,'','','','ce7bc6ac-b9d4-59c6-97ab-9b39fc9634da','Aphyllon californicum (Chamisso & Schlechtendal) A. Gray subsp. californicum','(Chamisso & Schlechtendal) A. Gray','SUBSPECIES','','Aphyllon','','californicum','californicum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30528','','','Aphyllon pinorum (Geyer ex Hooker) A. Gray',2,'Aphyllon pinorum','Aphyllon pinorum','Aphyllon pinor',2,0,'','','Geyer|Hooker|A. Gray','31a4ed39-8b9e-5b4d-a246-8d89adfd2e02','Aphyllon pinorum (Geyer ex Hooker) A. Gray','(Geyer ex Hooker) A. Gray','SPECIES','','Aphyllon','','pinorum','','','',NULL,'A. Gray','','','','','Geyer','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7014','','','Euphrasia oakesii Wettstein',1,'Euphrasia oakesii','Euphrasia oakesii','Euphrasia oakes',2,0,'','','Wettstein','1b1132f7-2d96-588f-8a50-3096575262e0','Euphrasia oakesii Wettstein','Wettstein','SPECIES','','Euphrasia','','oakesii','','','',NULL,'','','','','','Wettstein','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31188','','','Euphrasia oakesii Wettstein var. oakesii',1,'Euphrasia oakesii oakesii','Euphrasia oakesii var. oakesii','Euphrasia oakes oakes',3,0,'','','','bc6ff7bc-60db-5bf2-acb3-35f5efed41d6','Euphrasia oakesii Wettstein var. oakesii','Wettstein','VARIETY','','Euphrasia','','oakesii','oakesii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31966','','','Euphrasia stricta var. brevipila (Burnat & Gremli) Hartl',1,'Euphrasia stricta brevipila','Euphrasia stricta var. brevipila','Euphrasia strict breuipil',3,0,'','','Burnat|Gremli|Hartl','fa4580e3-8ee4-5b32-9c5c-5324c79ab13d','Euphrasia stricta var. brevipila (Burnat & Gremli) Hartl','(Burnat & Gremli) Hartl','VARIETY','','Euphrasia','','stricta','brevipila','','',NULL,'Hartl','','','','','Burnat & Gremli','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7021','','','Euphrasia vinacea P.D. Sell & Yeo',1,'Euphrasia vinacea','Euphrasia vinacea','Euphrasia uinace',2,0,'','','P. D. Sell|Yeo','bab200bc-04a0-500b-84da-b9365692adca','Euphrasia vinacea P.D. Sell & Yeo','P.D. Sell & Yeo','SPECIES','','Euphrasia','','vinacea','','','',NULL,'','','','','','P. D. Sell & Yeo','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31959','','','Euphrasia arctica Lange ex Rostrup',2,'Euphrasia arctica','Euphrasia arctica','Euphrasia arctic',2,0,'','','Lange|Rostrup','a9824306-8ba7-55e8-bba7-effba60f5b5a','Euphrasia arctica Lange ex Rostrup','Lange ex Rostrup','SPECIES','','Euphrasia','','arctica','','','',NULL,'','','','','','Lange','','Rostrup','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1471','','','Odontites Ludwig',1,'Odontites','Odontites','Odontites',1,0,'','','Ludwig','044564cb-e2bb-5652-a5a2-9c3a0c61a9b8','Odontites Ludwig','Ludwig','GENUS','Odontites','','','','','','',NULL,'','','','','','Ludwig','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31941','','','Bellardia Allioni',1,'Bellardia','Bellardia','Bellardia',1,0,'','','Allioni','ea5b098e-78aa-53d3-8c35-5ac8dcbfab10','Bellardia Allioni','Allioni','GENUS','Bellardia','','','','','','',NULL,'','','','','','Allioni','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7148','','','Mimulus ringens var. colpophilus Fernald',1,'Mimulus ringens colpophilus','Mimulus ringens var. colpophilus','Mimulus ringens colpophil',3,0,'','','Fernald','8c8add47-32b3-5c5e-a1eb-e2bc789fe78c','Mimulus ringens var. colpophilus Fernald','Fernald','VARIETY','','Mimulus','','ringens','colpophilus','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7155','','','Phryma leptostachya Linnaeus',1,'Phryma leptostachya','Phryma leptostachya','Phryma leptostachy',2,0,'','','Linnaeus','a32ba396-6847-55b5-8f2f-a887e16a882d','Phryma leptostachya Linnaeus','Linnaeus','SPECIES','','Phryma','','leptostachya','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26889','','','Erythranthe sect. Monimanthe (Pennell) G.L. Nesom & N.S. Fraga',2,'Monimanthe','Erythranthe sect. Monimanthe','Monimanthe',1,0,'','','Pennell|G. L. Nesom|N. S. Fraga','cfa15e52-012f-5064-b7a4-b2e927afc153','Erythranthe sect. Monimanthe (Pennell) G.L. Nesom & N.S. Fraga','(Pennell) G.L. Nesom & N.S. Fraga','SECTION','Monimanthe','','','','','','',NULL,'G. L. Nesom & N. S. Fraga','','','','','Pennell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26892','','','Erythranthe sect. Erythranthe Spach',2,'Erythranthe','Erythranthe sect. Erythranthe','Erythranthe',1,0,'','','Spach','cc835a08-de9d-56b2-b3f0-2cb7e44a2851','Erythranthe sect. Erythranthe Spach','Spach','SECTION','Erythranthe','','','','','','',NULL,'','','','','','Spach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26899','','','Erythranthe breviflora (Piper) G.L. Nesom',1,'Erythranthe breviflora','Erythranthe breviflora','Erythranthe breuiflor',2,0,'','','Piper|G. L. Nesom','fd7bbcc9-8a13-5620-9b59-67446f9c8cf3','Erythranthe breviflora (Piper) G.L. Nesom','(Piper) G.L. Nesom','SPECIES','','Erythranthe','','breviflora','','','',NULL,'G. L. Nesom','','','','','Piper','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29012','','','Erythranthe patula (Pennell) G.L. Nesom',1,'Erythranthe patula','Erythranthe patula','Erythranthe patul',2,0,'','','Pennell|G. L. Nesom','0106a29b-4890-50d9-985f-84248b9081e6','Erythranthe patula (Pennell) G.L. Nesom','(Pennell) G.L. Nesom','SPECIES','','Erythranthe','','patula','','','',NULL,'G. L. Nesom','','','','','Pennell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26907','','','Erythranthe guttata (de Candolle) G.L. Nesom',1,'Erythranthe guttata','Erythranthe guttata','Erythranthe guttat',2,0,'','','de Candolle|G. L. Nesom','47e78021-2074-50f3-a90d-31839039573c','Erythranthe guttata (de Candolle) G.L. Nesom','(de Candolle) G.L. Nesom','SPECIES','','Erythranthe','','guttata','','','',NULL,'G. L. Nesom','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30692','','','Erythranthe microphylla (Bentham) G.L. Nesom',1,'Erythranthe microphylla','Erythranthe microphylla','Erythranthe microphyll',2,0,'','','Bentham|G. L. Nesom','92573747-6546-5c65-9082-3f54e42b1ef0','Erythranthe microphylla (Bentham) G.L. Nesom','(Bentham) G.L. Nesom','SPECIES','','Erythranthe','','microphylla','','','',NULL,'G. L. Nesom','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('977','','','Chaenorhinum (de Candolle) Reichenbach',1,'Chaenorhinum','Chaenorhinum','Chaenorhinum',1,0,'','','de Candolle|Reichenbach','2b216989-aa57-5842-b80a-86dad9fd6466','Chaenorhinum (de Candolle) Reichenbach','(de Candolle) Reichenbach','GENUS','Chaenorhinum','','','','','','',NULL,'Reichenbach','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7238','','','Kickxia elatine (Linnaeus) Dumortier',1,'Kickxia elatine','Kickxia elatine','Kickxia elatin',2,0,'','','Linnaeus|Dumortier','13bf3d41-5eec-5c44-bea8-a6d9839f377f','Kickxia elatine (Linnaeus) Dumortier','(Linnaeus) Dumortier','SPECIES','','Kickxia','','elatine','','','',NULL,'Dumortier','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7249','','','Linaria pinifolia (Poiret) Thellung',1,'Linaria pinifolia','Linaria pinifolia','Linaria pinifol',2,0,'','','Poiret|Thellung','39c9951d-2100-54e6-a0c0-d12fe1572cb1','Linaria pinifolia (Poiret) Thellung','(Poiret) Thellung','SPECIES','','Linaria','','pinifolia','','','',NULL,'Thellung','','','','','Poiret','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7252','','','Linaria vulgaris Miller',1,'Linaria vulgaris','Linaria vulgaris','Linaria uulgar',2,0,'','','Miller','23a2949b-5491-507a-a151-00f1e39cc7c9','Linaria vulgaris Miller','Miller','SPECIES','','Linaria','','vulgaris','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24822','','','Linaria dalmatica (Linnaeus) Miller subsp. dalmatica',1,'Linaria dalmatica dalmatica','Linaria dalmatica subsp. dalmatica','Linaria dalmatic dalmatic',3,0,'','','','c361307a-097a-5d6b-9eab-51f1a14de4f7','Linaria dalmatica (Linnaeus) Miller subsp. dalmatica','(Linnaeus) Miller','SUBSPECIES','','Linaria','','dalmatica','dalmatica','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('932','','','Callitriche Linnaeus',1,'Callitriche','Callitriche','Callitriche',1,0,'','','Linnaeus','2bc8af42-9286-5721-80cb-8de0ae478b39','Callitriche Linnaeus','Linnaeus','GENUS','Callitriche','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7217','','','Callitriche stagnalis Scopoli',1,'Callitriche stagnalis','Callitriche stagnalis','Callitriche stagnal',2,0,'','','Scopoli','6457278c-c8ef-5272-aa7c-6c26af9f898e','Callitriche stagnalis Scopoli','Scopoli','SPECIES','','Callitriche','','stagnalis','','','',NULL,'','','','','','Scopoli','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7235','','','Hippuris montana Ledebour ex Reichenbach',2,'Hippuris montana','Hippuris montana','Hippuris montan',2,0,'','','Ledebour|Reichenbach','0399923a-d995-56f6-a418-63e4eca2a341','Hippuris montana Ledebour ex Reichenbach','Ledebour ex Reichenbach','SPECIES','','Hippuris','','montana','','','',NULL,'','','','','','Ledebour','','Reichenbach','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1014','','','Collinsia Nuttall',1,'Collinsia','Collinsia','Collinsia',1,0,'','','Nuttall','960cee4d-a976-50c9-a091-33a0ee177bed','Collinsia Nuttall','Nuttall','GENUS','Collinsia','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17938','','','Collinsia grandiflora Douglas ex Lindley',2,'Collinsia grandiflora','Collinsia grandiflora','Collinsia grandiflor',2,0,'','','Douglas|Lindley','800ebd37-dfe5-5f8c-aa4f-6a03f389a01d','Collinsia grandiflora Douglas ex Lindley','Douglas ex Lindley','SPECIES','','Collinsia','','grandiflora','','','',NULL,'','','','','','Douglas','','Lindley','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24884','','','Penstemon subg. Dasanthera (Rafinesque) Pennell',2,'Dasanthera','Penstemon subgen. Dasanthera','Dasanthera',1,0,'','','Rafinesque|Pennell','3218c07e-6db3-58ff-9160-3d2cea21b3d0','Penstemon subg. Dasanthera (Rafinesque) Pennell','(Rafinesque) Pennell','SUBGENUS','Dasanthera','','','','','','',NULL,'Pennell','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7279','','','Penstemon fruticosus var. scouleri (Lindley) Cronquist',1,'Penstemon fruticosus scouleri','Penstemon fruticosus var. scouleri','Penstemon fruticos scouler',3,0,'','','Lindley|Cronquist','7b137ef1-e3fb-5a68-b48b-7cb5480c1ec2','Penstemon fruticosus var. scouleri (Lindley) Cronquist','(Lindley) Cronquist','VARIETY','','Penstemon','','fruticosus','scouleri','','',NULL,'Cronquist','','','','','Lindley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7270','','','Penstemon davidsonii Greene var. davidsonii',1,'Penstemon davidsonii davidsonii','Penstemon davidsonii var. davidsonii','Penstemon dauidson dauidson',3,0,'','','','18acdc9a-a6d5-57cc-b71f-c84b49ee4f93','Penstemon davidsonii Greene var. davidsonii','Greene','VARIETY','','Penstemon','','davidsonii','davidsonii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24892','','','Penstemon sect. Cristati (Rydberg) Pennell',2,'Cristati','Penstemon sect. Cristati','Cristati',1,0,'','','Rydberg|Pennell','00de7f48-12c6-53a7-b41c-e727e1c877cf','Penstemon sect. Cristati (Rydberg) Pennell','(Rydberg) Pennell','SECTION','Cristati','','','','','','',NULL,'Pennell','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7267','','','Penstemon albidus Nuttall',1,'Penstemon albidus','Penstemon albidus','Penstemon albid',2,0,'','','Nuttall','3cbf1461-f4ee-569b-b63b-15eea0b0e4ff','Penstemon albidus Nuttall','Nuttall','SPECIES','','Penstemon','','albidus','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7282','','','Penstemon hirsutus (Linnaeus) Willdenow',1,'Penstemon hirsutus','Penstemon hirsutus','Penstemon hirsut',2,0,'','','Linnaeus|Willdenow','fedb3107-d651-56d7-99be-f9680144fe65','Penstemon hirsutus (Linnaeus) Willdenow','(Linnaeus) Willdenow','SPECIES','','Penstemon','','hirsutus','','','',NULL,'Willdenow','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7291','','','Penstemon pruinosus Douglas ex Lindley',2,'Penstemon pruinosus','Penstemon pruinosus','Penstemon pruinos',2,0,'','','Douglas|Lindley','7747d9dd-f353-59e7-a709-2fbf1a13d008','Penstemon pruinosus Douglas ex Lindley','Douglas ex Lindley','SPECIES','','Penstemon','','pruinosus','','','',NULL,'','','','','','Douglas','','Lindley','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7294','','','Penstemon serrulatus Menzies ex Smith',2,'Penstemon serrulatus','Penstemon serrulatus','Penstemon serrulat',2,0,'','','Menzies|Smith','01be5c30-ac3f-59c9-b42f-93afc5eac07d','Penstemon serrulatus Menzies ex Smith','Menzies ex Smith','SPECIES','','Penstemon','','serrulatus','','','',NULL,'','','','','','Menzies','','Smith','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7229','','','Digitalis purpurea Linnaeus',1,'Digitalis purpurea','Digitalis purpurea','Digitalis purpure',2,0,'','','Linnaeus','550d1ce5-5cce-5235-ac5c-d276105110d4','Digitalis purpurea Linnaeus','Linnaeus','SPECIES','','Digitalis','','purpurea','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26095','','','Gratiola lutea Rafinesque',1,'Gratiola lutea','Gratiola lutea','Gratiola lute',2,0,'','','Rafinesque','024dbbfb-6645-5ca6-83ee-befbf10b084a','Gratiola lutea Rafinesque','Rafinesque','SPECIES','','Gratiola','','lutea','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('597','','','Veroniceae',1,'Veroniceae','Veroniceae','Veroniceae',1,0,'','','','3b7fe793-cf41-5fca-9a76-71e387ae0dd7','Veroniceae','','TRIBE','Veroniceae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1817','','','Veronica Linnaeus',1,'Veronica','Veronica','Veronica',1,0,'','','Linnaeus','f901cb86-7297-56d8-aeb6-230328a4960f','Veronica Linnaeus','Linnaeus','GENUS','Veronica','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7315','','','Veronica alaskensis M.M. Martinéz Ortega & Albach',1,'Veronica alaskensis','Veronica alaskensis','Veronica alaskens',2,0,'','','M. M. Martinéz Ortega|Albach','deab6289-a456-50fa-af91-29e05a7c0488','Veronica alaskensis M.M. Martinéz Ortega & Albach','M.M. Martinéz Ortega & Albach','SPECIES','','Veronica','','alaskensis','','','',NULL,'','','','','','M. M. Martinéz Ortega & Albach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7337','','','Veronica persica Poiret',1,'Veronica persica','Veronica persica','Veronica persic',2,0,'','','Poiret','4c68d35b-23fd-55d1-9826-b4b2eefed069','Veronica persica Poiret','Poiret','SPECIES','','Veronica','','persica','','','',NULL,'','','','','','Poiret','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7333','','','Veronica officinalis Linnaeus',1,'Veronica officinalis','Veronica officinalis','Veronica officinal',2,0,'','','Linnaeus','7935176b-a126-5980-b719-b771ff4cb827','Veronica officinalis Linnaeus','Linnaeus','SPECIES','','Veronica','','officinalis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2027','','','Veronica subg. Beccabunga (Hill) M.M. Martinéz-Ortega, Albach & M.A. Fischer',2,'Beccabunga','Veronica subgen. Beccabunga','Beccabunga',1,0,'','','Hill|M. M. Martinéz-Ortega|Albach|M. A. Fischer','89bab336-7e78-578c-a40b-e885a6ed1095','Veronica subg. Beccabunga (Hill) M.M. Martinéz-Ortega, Albach & M.A. Fischer','(Hill) M.M. Martinéz-Ortega, Albach & M.A. Fischer','SUBGENUS','Beccabunga','','','','','','',NULL,'M. M. Martinéz-Ortega, Albach & M. A. Fischer','','','','','Hill','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7320','','','Veronica anagallis-aquatica Linnaeus',1,'Veronica anagallis-aquatica','Veronica anagallis-aquatica','Veronica anagallis-aquatic',2,0,'','','Linnaeus','d4493da8-2337-566e-b6d7-762d5dc96887','Veronica anagallis-aquatica Linnaeus','Linnaeus','SPECIES','','Veronica','','anagallis-aquatica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7336','','','Veronica peregrina subsp. xalapensis (Kunth) Pennell',1,'Veronica peregrina xalapensis','Veronica peregrina subsp. xalapensis','Veronica peregrin xalapens',3,0,'','','Kunth|Pennell','dd67dda0-e25a-596c-bcdc-018c750da9aa','Veronica peregrina subsp. xalapensis (Kunth) Pennell','(Kunth) Pennell','SUBSPECIES','','Veronica','','peregrina','xalapensis','','',NULL,'Pennell','','','','','Kunth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7319','','','Veronica americana (Rafinesque) Schweinitz ex Bentham',2,'Veronica americana','Veronica americana','Veronica american',2,0,'','','Rafinesque|Schweinitz|Bentham','5e9f66e3-22c9-520f-be75-ce2350e92e9b','Veronica americana (Rafinesque) Schweinitz ex Bentham','(Rafinesque) Schweinitz ex Bentham','SPECIES','','Veronica','','americana','','','',NULL,'Schweinitz','','Bentham','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7323','','','Veronica austriaca Linnaeus',1,'Veronica austriaca','Veronica austriaca','Veronica austriac',2,0,'','','Linnaeus','4c80c599-0eb5-58c2-911c-1ad569021f9f','Veronica austriaca Linnaeus','Linnaeus','SPECIES','','Veronica','','austriaca','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17987','','','Veronica teucrium Linnaeus',1,'Veronica teucrium','Veronica teucrium','Veronica teucri',2,0,'','','Linnaeus','cc63aa64-23f2-598c-81a9-e9021a983226','Veronica teucrium Linnaeus','Linnaeus','SPECIES','','Veronica','','teucrium','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2032','','','Veronica subg. Pseudolysimachium (W.D.J. Koch) M.M. Martinéz-Ortega, Albach & M.A. Fischer',2,'Pseudolysimachium','Veronica subgen. Pseudolysimachium','Pseudolysimachium',1,0,'','','W. D. J. Koch|M. M. Martinéz-Ortega|Albach|M. A. Fischer','82ee96e5-468b-53ef-b4b2-4dc239221b88','Veronica subg. Pseudolysimachium (W.D.J. Koch) M.M. Martinéz-Ortega, Albach & M.A. Fischer','(W.D.J. Koch) M.M. Martinéz-Ortega, Albach & M.A. Fischer','SUBGENUS','Pseudolysimachium','','','','','','',NULL,'M. M. Martinéz-Ortega, Albach & M. A. Fischer','','','','','W. D. J. Koch','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31931','','','Veronica incana Linnaeus',1,'Veronica incana','Veronica incana','Veronica incan',2,0,'','','Linnaeus','5e587e4d-540f-5bcb-a3d5-02d5ba22a103','Veronica incana Linnaeus','Linnaeus','SPECIES','','Veronica','','incana','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1360','','','Littorella P.J. Bergius',1,'Littorella','Littorella','Littorella',1,0,'','','P. J. Bergius','09ad4089-16c6-5690-87a1-6d912c53aa1c','Littorella P.J. Bergius','P.J. Bergius','GENUS','Littorella','','','','','','',NULL,'','','','','','P. J. Bergius','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7305','','','Plantago eriopoda Torrey',1,'Plantago eriopoda','Plantago eriopoda','Plantago eriopod',2,0,'','','Torrey','8668e9ed-a780-54bc-a481-a0088dc6fd16','Plantago eriopoda Torrey','Torrey','SPECIES','','Plantago','','eriopoda','','','',NULL,'','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7303','','','Plantago elongata Pursh',1,'Plantago elongata','Plantago elongata','Plantago elongat',2,0,'','','Pursh','d63a5002-84d7-56b2-a4ed-decbf849b321','Plantago elongata Pursh','Pursh','SPECIES','','Plantago','','elongata','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7244','','','Limosella australis R. Brown',1,'Limosella australis','Limosella australis','Limosella austral',2,0,'','','R. Brown','e12d2084-b8b8-512b-a469-b2129c020724','Limosella australis R. Brown','R. Brown','SPECIES','','Limosella','','australis','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9320','','','Scrophularia lanceolata Pursh',1,'Scrophularia lanceolata','Scrophularia lanceolata','Scrophularia lanceolat',2,0,'','','Pursh','fcb3bab1-318a-5cee-8a5b-354dbf69e523','Scrophularia lanceolata Pursh','Pursh','SPECIES','','Scrophularia','','lanceolata','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9331','','','Verbascum virgatum Stokes',1,'Verbascum virgatum','Verbascum virgatum','Verbascum uirgat',2,0,'','','Stokes','f2ca9329-cfe4-5db7-b8f9-30386efc2305','Verbascum virgatum Stokes','Stokes','SPECIES','','Verbascum','','virgatum','','','',NULL,'','','','','','Stokes','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('234','','','Verbenaceae J. St-Hilaire',1,'Verbenaceae','Verbenaceae','Verbenaceae',1,0,'','','J. St-Hilaire','0809b73b-bc95-5d58-b5ad-17a6383fc205','Verbenaceae J. St-Hilaire','J. St-Hilaire','FAMILY','Verbenaceae','','','','','','',NULL,'','','','','','J. St-Hilaire','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1540','','','Phyla Loureiro',1,'Phyla','Phyla','Phyla',1,0,'','','Loureiro','181b78db-672b-5ffe-a07f-cb97fed64a4b','Phyla Loureiro','Loureiro','GENUS','Phyla','','','','','','',NULL,'','','','','','Loureiro','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9468','','','Verbena ×deamii Moldenke',3,'','','',NULL,NULL,'','','','','Verbena ×deamii Moldenke','Moldenke','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9467','','','Verbena urticifolia Linnaeus',1,'Verbena urticifolia','Verbena urticifolia','Verbena urticifol',2,0,'','','Linnaeus','cd17d8c6-7e3c-5e17-add7-c8ad20f3c045','Verbena urticifolia Linnaeus','Linnaeus','SPECIES','','Verbena','','urticifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4611','','','Calystegia sepium (Linnaeus) R. Brown',1,'Calystegia sepium','Calystegia sepium','Calystegia sepi',2,0,'','','Linnaeus|R. Brown','66ce2943-d54a-57b7-ac1b-8ae39e622c86','Calystegia sepium (Linnaeus) R. Brown','(Linnaeus) R. Brown','SPECIES','','Calystegia','','sepium','','','',NULL,'R. Brown','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4615','','','Calystegia silvatica (Kitaibel) Grisebach',1,'Calystegia silvatica','Calystegia silvatica','Calystegia siluatic',2,0,'','','Kitaibel|Grisebach','592e8388-da8e-5cf8-8e02-66f20eb1b167','Calystegia silvatica (Kitaibel) Grisebach','(Kitaibel) Grisebach','SPECIES','','Calystegia','','silvatica','','','',NULL,'Grisebach','','','','','Kitaibel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31190','','','Calystegia spithamaea subsp. stans (Michaux) Brummitt',1,'Calystegia spithamaea stans','Calystegia spithamaea subsp. stans','Calystegia spithamae stans',3,0,'','','Michaux|Brummitt','0ee3bb66-3020-5438-983a-d6cbb35da74d','Calystegia spithamaea subsp. stans (Michaux) Brummitt','(Michaux) Brummitt','SUBSPECIES','','Calystegia','','spithamaea','stans','','',NULL,'Brummitt','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4619','','','Convolvulus arvensis Linnaeus',1,'Convolvulus arvensis','Convolvulus arvensis','Convolvulus aruens',2,0,'','','Linnaeus','1526ce23-87a8-50ae-b24f-a2ef65d8f5fe','Convolvulus arvensis Linnaeus','Linnaeus','SPECIES','','Convolvulus','','arvensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4626','','','Cuscuta epithymum (Linnaeus) Linnaeus',1,'Cuscuta epithymum','Cuscuta epithymum','Cuscuta epithym',2,0,'','','Linnaeus','88b9dde1-159c-5d97-859e-1d98248f7459','Cuscuta epithymum (Linnaeus) Linnaeus','(Linnaeus) Linnaeus','SPECIES','','Cuscuta','','epithymum','','','',NULL,'Linnaeus','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4632','','','Cuscuta pentagona Engelmann',1,'Cuscuta pentagona','Cuscuta pentagona','Cuscuta pentagon',2,0,'','','Engelmann','a50d2877-f404-5417-8612-595131caf065','Cuscuta pentagona Engelmann','Engelmann','SPECIES','','Cuscuta','','pentagona','','','',NULL,'','','','','','Engelmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9706','','','Cuscuta campestris Yuncker',1,'Cuscuta campestris','Cuscuta campestris','Cuscuta campestr',2,0,'','','Yuncker','eaed997a-78b8-5971-b286-304e8b007024','Cuscuta campestris Yuncker','Yuncker','SPECIES','','Cuscuta','','campestris','','','',NULL,'','','','','','Yuncker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4621','','','Cuscuta cephalanthi Engelmann',1,'Cuscuta cephalanthi','Cuscuta cephalanthi','Cuscuta cephalanth',2,0,'','','Engelmann','ae8d722e-c242-566e-8db7-aa1174c2a385','Cuscuta cephalanthi Engelmann','Engelmann','SPECIES','','Cuscuta','','cephalanthi','','','',NULL,'','','','','','Engelmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4631','','','Cuscuta umbrosa Beyrich ex Hooker',2,'Cuscuta umbrosa','Cuscuta umbrosa','Cuscuta umbros',2,0,'','','Beyrich|Hooker','b73c284e-076d-5d02-8f10-c9e2b194a8fd','Cuscuta umbrosa Beyrich ex Hooker','Beyrich ex Hooker','SPECIES','','Cuscuta','','umbrosa','','','',NULL,'','','','','','Beyrich','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29393','','','Cuscuta pacifica Costea & M.A.R. Wright var. pacifica',1,'Cuscuta pacifica pacifica','Cuscuta pacifica var. pacifica','Cuscuta pacific pacific',3,0,'','','','e719cdee-bbae-51ae-ba9a-a297026a3424','Cuscuta pacifica Costea & M.A.R. Wright var. pacifica','Costea & M.A.R. Wright','VARIETY','','Cuscuta','','pacifica','pacifica','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('223','','','Solanaceae de Jussieu',1,'Solanaceae','Solanaceae','Solanaceae',1,0,'','','de Jussieu','bed5d6f0-1527-50ba-8e3b-10e7f46ee6ca','Solanaceae de Jussieu','de Jussieu','FAMILY','Solanaceae','','','','','','',NULL,'','','','','','de Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9351','','','Hyoscyamus albus Linnaeus',1,'Hyoscyamus albus','Hyoscyamus albus','Hyoscyamus alb',2,0,'','','Linnaeus','ea031364-378c-5f94-8b5e-60f78427b326','Hyoscyamus albus Linnaeus','Linnaeus','SPECIES','','Hyoscyamus','','albus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1696','','','Solanum Linnaeus',1,'Solanum','Solanum','Solanum',1,0,'','','Linnaeus','550b73c9-4c6d-51c7-afd4-f876c1b9f074','Solanum Linnaeus','Linnaeus','GENUS','Solanum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31279','','','Solanum carolinense Linnaeus var. carolinense',1,'Solanum carolinense carolinense','Solanum carolinense var. carolinense','Solanum carolinens carolinens',3,0,'','','','17aaef9e-52f6-5b3c-a10f-42db5551a326','Solanum carolinense Linnaeus var. carolinense','Linnaeus','VARIETY','','Solanum','','carolinense','carolinense','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9381','','','Solanum nigrum Linnaeus',1,'Solanum nigrum','Solanum nigrum','Solanum nigr',2,0,'','','Linnaeus','4fcf2ca4-a899-5b91-9ab6-0c3e7504a254','Solanum nigrum Linnaeus','Linnaeus','SPECIES','','Solanum','','nigrum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9386','','','Solanum triflorum Nuttall',1,'Solanum triflorum','Solanum triflorum','Solanum triflor',2,0,'','','Nuttall','864b8221-0043-5fe9-b21e-c14626e0ad2a','Solanum triflorum Nuttall','Nuttall','SPECIES','','Solanum','','triflorum','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31276','','','Solanum emulans Rafinesque',1,'Solanum emulans','Solanum emulans','Solanum emulans',2,0,'','','Rafinesque','c192d514-d709-5bde-bf33-0910713355b5','Solanum emulans Rafinesque','Rafinesque','SPECIES','','Solanum','','emulans','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1460','','','Nicandra Adanson',1,'Nicandra','Nicandra','Nicandra',1,0,'','','Adanson','771ef72e-51b9-5718-82f2-21b3a49d274b','Nicandra Adanson','Adanson','GENUS','Nicandra','','','','','','',NULL,'','','','','','Adanson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1543','','','Physalis Linnaeus',1,'Physalis','Physalis','Physalis',1,0,'','','Linnaeus','b8a665a2-5940-5432-88f1-03481a358fc3','Physalis Linnaeus','Linnaeus','GENUS','Physalis','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9369','','','Physalis peruviana Linnaeus',1,'Physalis peruviana','Physalis peruviana','Physalis peruuian',2,0,'','','Linnaeus','661dd123-55b7-570c-952f-3d3f9afa3492','Physalis peruviana Linnaeus','Linnaeus','SPECIES','','Physalis','','peruviana','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9367','','','Physalis longifolia var. subglabrata (Mackenzie & Bush) Cronquist',1,'Physalis longifolia subglabrata','Physalis longifolia var. subglabrata','Physalis longifol subglabrat',3,0,'','','Mackenzie|Bush|Cronquist','040a0af0-97c8-5f1b-9d97-9d45fd026759','Physalis longifolia var. subglabrata (Mackenzie & Bush) Cronquist','(Mackenzie & Bush) Cronquist','VARIETY','','Physalis','','longifolia','subglabrata','','',NULL,'Cronquist','','','','','Mackenzie & Bush','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29354','','','Alkekengi officinarum Moench',1,'Alkekengi officinarum','Alkekengi officinarum','Alkekengi officinar',2,0,'','','Moench','cab4b131-4500-570b-927a-be9dbe6ab6ed','Alkekengi officinarum Moench','Moench','SPECIES','','Alkekengi','','officinarum','','','',NULL,'','','','','','Moench','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9360','','','Nicotiana rustica Linnaeus',1,'Nicotiana rustica','Nicotiana rustica','Nicotiana rustic',2,0,'','','Linnaeus','6bf68883-929a-5a54-8a4c-970cef4cd4c5','Nicotiana rustica Linnaeus','Linnaeus','SPECIES','','Nicotiana','','rustica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29107','','','Petunia integrifolia (Hooker) Schinz & Thellung',1,'Petunia integrifolia','Petunia integrifolia','Petunia integrifol',2,0,'','','Hooker|Schinz|Thellung','cbc195da-ff6b-5791-a10e-3b4e311d19a7','Petunia integrifolia (Hooker) Schinz & Thellung','(Hooker) Schinz & Thellung','SPECIES','','Petunia','','integrifolia','','','',NULL,'Schinz & Thellung','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('15','','','Caryophyllanae Takhtajan',1,'Caryophyllanae','Caryophyllanae','Caryophyllanae',1,0,'','','Takhtajan','558c44a3-51e9-5574-b139-d85a72d8f77f','Caryophyllanae Takhtajan','Takhtajan','SUPERORDER','Caryophyllanae','','','','','','',NULL,'','','','','','Takhtajan','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('415','','','Amarantheae',1,'Amarantheae','Amarantheae','Amarantheae',1,0,'','','','7fa75991-1e3d-5d72-903e-52a9db01928c','Amarantheae','','TRIBE','Amarantheae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('807','','','Amaranthus Adanson',1,'Amaranthus','Amaranthus','Amaranthus',1,0,'','','Adanson','6531486c-c9f9-52a0-a5b3-ab907eb94abb','Amaranthus Adanson','Adanson','GENUS','Amaranthus','','','','','','',NULL,'','','','','','Adanson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2498','','','Amaranthus albus Linnaeus',1,'Amaranthus albus','Amaranthus albus','Amaranthus alb',2,0,'','','Linnaeus','73176670-4031-52e4-9096-05ea5cebe425','Amaranthus albus Linnaeus','Linnaeus','SPECIES','','Amaranthus','','albus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1972','','','Amaranthus subg. Amaranthus',2,'Amaranthus','Amaranthus subgen. Amaranthus','Amaranthus',1,0,'','','','ed9d7138-a65f-5109-ac1b-2ba78240310a','Amaranthus subg. Amaranthus','','SUBGENUS','Amaranthus','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2503','','','Amaranthus hybridus Linnaeus',1,'Amaranthus hybridus','Amaranthus hybridus','Amaranthus hybrid',2,0,'','','Linnaeus','19e31071-f810-59cc-a4d6-d0632dc67fc9','Amaranthus hybridus Linnaeus','Linnaeus','SPECIES','','Amaranthus','','hybridus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27774','','','Amaranthus hypochondriacus Linnaeus',1,'Amaranthus hypochondriacus','Amaranthus hypochondriacus','Amaranthus hypochondriac',2,0,'','','Linnaeus','b2efdedd-8537-5f0d-a704-e737e51408a4','Amaranthus hypochondriacus Linnaeus','Linnaeus','SPECIES','','Amaranthus','','hypochondriacus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2504','','','Amaranthus palmeri S. Watson',1,'Amaranthus palmeri','Amaranthus palmeri','Amaranthus palmer',2,0,'','','S. Watson','33b4f371-c685-5eba-8ab3-69aed6827862','Amaranthus palmeri S. Watson','S. Watson','SPECIES','','Amaranthus','','palmeri','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9814','','','Amaranthus tuberculatus var. rudis (J.D. Sauer) Costea & Tardif',1,'Amaranthus tuberculatus rudis','Amaranthus tuberculatus var. rudis','Amaranthus tuberculat rud',3,0,'','','J. D. Sauer|Costea|Tardif','b22228c5-f3d4-51f3-99d6-dae1ec921447','Amaranthus tuberculatus var. rudis (J.D. Sauer) Costea & Tardif','(J.D. Sauer) Costea & Tardif','VARIETY','','Amaranthus','','tuberculatus','rudis','','',NULL,'Costea & Tardif','','','','','J. D. Sauer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('876','','','Atriplex Linnaeus',1,'Atriplex','Atriplex','Atriplex',1,0,'','','Linnaeus','e909342e-d6dd-5577-9a57-f8270e6a46c8','Atriplex Linnaeus','Linnaeus','GENUS','Atriplex','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4465','','','Atriplex argentea Nuttall',1,'Atriplex argentea','Atriplex argentea','Atriplex argente',2,0,'','','Nuttall','d26486e3-53ad-57b9-a61c-a47346890681','Atriplex argentea Nuttall','Nuttall','SPECIES','','Atriplex','','argentea','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4485','','','Atriplex powellii S. Watson var. powellii',1,'Atriplex powellii powellii','Atriplex powellii var. powellii','Atriplex powell powell',3,0,'','','','8a2dc64e-4ab9-5b90-bec6-278334bc1819','Atriplex powellii S. Watson var. powellii','S. Watson','VARIETY','','Atriplex','','powellii','powellii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22204','','','Atriplex canescens (Pursh) Nuttall var. canescens',1,'Atriplex canescens canescens','Atriplex canescens var. canescens','Atriplex canescens canescens',3,0,'','','','55c16539-c5a3-5c50-84b9-f9bd59f592ab','Atriplex canescens (Pursh) Nuttall var. canescens','(Pursh) Nuttall','VARIETY','','Atriplex','','canescens','canescens','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1989','','','Atriplex subg. Atriplex',2,'Atriplex','Atriplex subgen. Atriplex','Atriplex',1,0,'','','','bda04079-4f7f-542b-b9a6-ce021bb6327a','Atriplex subg. Atriplex','','SUBGENUS','Atriplex','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4483','','','Atriplex oblongifolia Waldstein & Kitaibel',1,'Atriplex oblongifolia','Atriplex oblongifolia','Atriplex oblongifol',2,0,'','','Waldstein|Kitaibel','ffce4bd7-706f-5c23-b005-0602271e4412','Atriplex oblongifolia Waldstein & Kitaibel','Waldstein & Kitaibel','SPECIES','','Atriplex','','oblongifolia','','','',NULL,'','','','','','Waldstein & Kitaibel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4476','','','Atriplex gmelinii C.A. Meyer ex Bongard',2,'Atriplex gmelinii','Atriplex gmelinii','Atriplex gmelin',2,0,'','','C. A. Meyer|Bongard','60710520-d0de-5f24-86c3-c2df6dc49ecd','Atriplex gmelinii C.A. Meyer ex Bongard','C.A. Meyer ex Bongard','SPECIES','','Atriplex','','gmelinii','','','',NULL,'','','','','','C. A. Meyer','','Bongard','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2082','','','Atriplex sect. Sclerocalymma (Ascherson) Ascherson & Graebner',2,'Sclerocalymma','Atriplex sect. Sclerocalymma','Sclerocalymma',1,0,'','','Ascherson|Graebner','0c2ee84e-8dc1-5b72-a190-b209fd1781cd','Atriplex sect. Sclerocalymma (Ascherson) Ascherson & Graebner','(Ascherson) Ascherson & Graebner','SECTION','Sclerocalymma','','','','','','',NULL,'Ascherson & Graebner','','','','','Ascherson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('987','','','Chenopodium Linnaeus',1,'Chenopodium','Chenopodium','Chenopodium',1,0,'','','Linnaeus','438336c3-cf6f-5772-ab26-5e50af554c03','Chenopodium Linnaeus','Linnaeus','GENUS','Chenopodium','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2351','','','Chenopodium subsect. Chenopodium',2,'Chenopodium','Chenopodium subsect. Chenopodium','Chenopodium',1,0,'','','','8f104130-3bba-510d-ba79-b2aac2bf46b6','Chenopodium subsect. Chenopodium','','SUBSECTION','Chenopodium','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4494','','','Chenopodium atrovirens Rydberg',1,'Chenopodium atrovirens','Chenopodium atrovirens','Chenopodium atrouirens',2,0,'','','Rydberg','05a99d08-dd83-5a32-bdcf-83557e217d92','Chenopodium atrovirens Rydberg','Rydberg','SPECIES','','Chenopodium','','atrovirens','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4506','','','Chenopodium foggii Wahl',1,'Chenopodium foggii','Chenopodium foggii','Chenopodium fogg',2,0,'','','Wahl','d29712ba-b70d-5cc6-b524-d9b75121cd87','Chenopodium foggii Wahl','Wahl','SPECIES','','Chenopodium','','foggii','','','',NULL,'','','','','','Wahl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2353','','','Chenopodium subsect. Favosa (Aellen) Mosyakin & Clemants',2,'Favosa','Chenopodium subsect. Favosa','Favosa',1,0,'','','Aellen|Mosyakin|Clemants','eac10b09-be8b-5e7e-a7fa-aa9aa5ec35b0','Chenopodium subsect. Favosa (Aellen) Mosyakin & Clemants','(Aellen) Mosyakin & Clemants','SUBSECTION','Favosa','','','','','','',NULL,'Mosyakin & Clemants','','','','','Aellen','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4505','','','Chenopodium ficifolium Smith',1,'Chenopodium ficifolium','Chenopodium ficifolium','Chenopodium ficifoli',2,0,'','','Smith','4b9faae2-8257-5853-ba91-8b232141e5d2','Chenopodium ficifolium Smith','Smith','SPECIES','','Chenopodium','','ficifolium','','','',NULL,'','','','','','Smith','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27653','','','Chenopodiastrum S. Fuentes, Uotila & Borsch',1,'Chenopodiastrum','Chenopodiastrum','Chenopodiastrum',1,0,'','','S. Fuentes|Uotila|Borsch','369ed204-69b7-5dbb-92c7-7942f5f3d3ea','Chenopodiastrum S. Fuentes, Uotila & Borsch','S. Fuentes, Uotila & Borsch','GENUS','Chenopodiastrum','','','','','','',NULL,'','','','','','S. Fuentes, Uotila & Borsch','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27655','','','Chenopodiastrum simplex (Torrey) S. Fuentes, Uotila & Borsch',1,'Chenopodiastrum simplex','Chenopodiastrum simplex','Chenopodiastrum simplex',2,0,'','','Torrey|S. Fuentes|Uotila|Borsch','0076c076-b3c4-5f12-86fb-c62a91c7f9f4','Chenopodiastrum simplex (Torrey) S. Fuentes, Uotila & Borsch','(Torrey) S. Fuentes, Uotila & Borsch','SPECIES','','Chenopodiastrum','','simplex','','','',NULL,'S. Fuentes, Uotila & Borsch','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27658','','','Oxybasis Karelin & Kirilov',1,'Oxybasis','Oxybasis','Oxybasis',1,0,'','','Karelin|Kirilov','63fb4258-c6da-5166-bb31-9ec20c5057e8','Oxybasis Karelin & Kirilov','Karelin & Kirilov','GENUS','Oxybasis','','','','','','',NULL,'','','','','','Karelin & Kirilov','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30402','','','Oxybasis sect. Pseudoblitum (Hooker f.) Mosyakin',2,'Pseudoblitum','Oxybasis sect. Pseudoblitum','Pseudoblitum',1,0,'','','Hooker fil.|Mosyakin','08c25e7c-3558-56b5-8546-344105c4ec08','Oxybasis sect. Pseudoblitum (Hooker f.) Mosyakin','(Hooker f.) Mosyakin','SECTION','Pseudoblitum','','','','','','',NULL,'Mosyakin','','','','','Hooker fil.','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27673','','','Oxybasis rubra var. humilis (Hooker) Mosyakin',1,'Oxybasis rubra humilis','Oxybasis rubra var. humilis','Oxybasis rubr humil',3,0,'','','Hooker|Mosyakin','1366e418-aa4d-5878-9b06-9995fcfdc978','Oxybasis rubra var. humilis (Hooker) Mosyakin','(Hooker) Mosyakin','VARIETY','','Oxybasis','','rubra','humilis','','',NULL,'Mosyakin','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27660','','','Oxybasis glauca (Linnaeus) S. Fuentes, Uotila & Borsch',1,'Oxybasis glauca','Oxybasis glauca','Oxybasis glauc',2,0,'','','Linnaeus|S. Fuentes|Uotila|Borsch','04470e85-b4db-50bc-9d9f-a7d7092cbe1c','Oxybasis glauca (Linnaeus) S. Fuentes, Uotila & Borsch','(Linnaeus) S. Fuentes, Uotila & Borsch','SPECIES','','Oxybasis','','glauca','','','',NULL,'S. Fuentes, Uotila & Borsch','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14765','','','Blitum nuttallianum Schultes',1,'Blitum nuttallianum','Blitum nuttallianum','Blitum nuttallian',2,0,'','','Schultes','99d6b3bc-c627-5458-b03d-797ecff554f8','Blitum nuttallianum Schultes','Schultes','SPECIES','','Blitum','','nuttallianum','','','',NULL,'','','','','','Schultes','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1885','','','Dysphania R. Brown',1,'Dysphania','Dysphania','Dysphania',1,0,'','','R. Brown','9010e240-84a9-5313-b8e1-4adf9f357a33','Dysphania R. Brown','R. Brown','GENUS','Dysphania','','','','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32800','','','Dysphania atriplicifolia (Sprengel) G. Kadereit, Sukhorukov & Uotila',1,'Dysphania atriplicifolia','Dysphania atriplicifolia','Dysphania atriplicifol',2,0,'','','Sprengel|G. Kadereit|Sukhorukov|Uotila','fb9e8317-06c4-56eb-9baa-2875a11ec660','Dysphania atriplicifolia (Sprengel) G. Kadereit, Sukhorukov & Uotila','(Sprengel) G. Kadereit, Sukhorukov & Uotila','SPECIES','','Dysphania','','atriplicifolia','','','',NULL,'G. Kadereit, Sukhorukov & Uotila','','','','','Sprengel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4552','','','Krascheninnikovia lanata (Pursh) A. Meeuse & A. Smit',1,'Krascheninnikovia lanata','Krascheninnikovia lanata','Krascheninnikovia lanat',2,0,'','','Pursh|A. Meeuse|A. Smit','e3f63e28-b0f7-5f43-906a-b71fa5de2b75','Krascheninnikovia lanata (Pursh) A. Meeuse & A. Smit','(Pursh) A. Meeuse & A. Smit','SPECIES','','Krascheninnikovia','','lanata','','','',NULL,'A. Meeuse & A. Smit','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4535','','','Corispermum americanum (Nuttall) Nuttall var. americanum',1,'Corispermum americanum americanum','Corispermum americanum var. americanum','Corispermum american american',3,0,'','','','0f4f7301-61c7-5e84-8cb2-093b3f0113fe','Corispermum americanum (Nuttall) Nuttall var. americanum','(Nuttall) Nuttall','VARIETY','','Corispermum','','americanum','americanum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9585','','','Corispermum ochotense var. alaskanum Mosyakin',1,'Corispermum ochotense alaskanum','Corispermum ochotense var. alaskanum','Corispermum ochotens alaskan',3,0,'','','Mosyakin','8a1b0d22-e0c7-5e09-b00c-daf41cf062a7','Corispermum ochotense var. alaskanum Mosyakin','Mosyakin','VARIETY','','Corispermum','','ochotense','alaskanum','','',NULL,'','','','','','Mosyakin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4555','','','Polycnemum majus A. Braun',1,'Polycnemum majus','Polycnemum majus','Polycnemum ma',2,0,'','','A. Braun','df1113ab-1c03-585a-bfaa-6c9947817326','Polycnemum majus A. Braun','A. Braun','SPECIES','','Polycnemum','','majus','','','',NULL,'','','','','','A. Braun','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('14782','','','Salicornia perennis Miller',1,'Salicornia perennis','Salicornia perennis','Salicornia perenn',2,0,'','','Miller','be387dfe-180d-52b8-a7b3-daf8df9fac7b','Salicornia perennis Miller','Miller','SPECIES','','Salicornia','','perennis','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29009','','','Salicornia pacifica Standley',1,'Salicornia pacifica','Salicornia pacifica','Salicornia pacific',2,0,'','','Standley','5ab436a8-f70e-56c5-a22a-6afc0e32aeab','Salicornia pacifica Standley','Standley','SPECIES','','Salicornia','','pacifica','','','',NULL,'','','','','','Standley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4567','','','Suaeda calceoliformis (Hooker) Moquin-Tandon',1,'Suaeda calceoliformis','Suaeda calceoliformis','Suaeda calceoliform',2,0,'','','Hooker|Moquin-Tandon','1f80f26c-beb8-550d-a501-ee160db99210','Suaeda calceoliformis (Hooker) Moquin-Tandon','(Hooker) Moquin-Tandon','SPECIES','','Suaeda','','calceoliformis','','','',NULL,'Moquin-Tandon','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33983','','','Suaeda linifolia Pallas',1,'Suaeda linifolia','Suaeda linifolia','Suaeda linifol',2,0,'','','Pallas','133accda-8064-58ee-a88b-c58845576a30','Suaeda linifolia Pallas','Pallas','SPECIES','','Suaeda','','linifolia','','','',NULL,'','','','','','Pallas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('102','','','Cactaceae de Jussieu',1,'Cactaceae','Cactaceae','Cactaceae',1,0,'','','de Jussieu','cca779db-87c6-5e3d-b5c1-055011f47225','Cactaceae de Jussieu','de Jussieu','FAMILY','Cactaceae','','','','','','',NULL,'','','','','','de Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('521','','','Cacteae',1,'Cacteae','Cacteae','Cacteae',1,0,'','','','525519bd-5988-5b97-8643-55d84b2dce47','Cacteae','','TRIBE','Cacteae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34093','','','Pelecyphora C. Ehrenberg',1,'Pelecyphora','Pelecyphora','Pelecyphora',1,0,'','','C. Ehrenberg','f9fdf124-2d95-55c6-a916-033b58033eec','Pelecyphora C. Ehrenberg','C. Ehrenberg','GENUS','Pelecyphora','','','','','','',NULL,'','','','','','C. Ehrenberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4148','','','Opuntia ×columbiana Griffiths',3,'','','',NULL,NULL,'','','','','Opuntia ×columbiana Griffiths','Griffiths','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4145','','','Opuntia humifusa (Rafinesque) Rafinesque',1,'Opuntia humifusa','Opuntia humifusa','Opuntia humifus',2,0,'','','Rafinesque','67819987-0456-5f0a-8f95-99d9b4f23e63','Opuntia humifusa (Rafinesque) Rafinesque','(Rafinesque) Rafinesque','SPECIES','','Opuntia','','humifusa','','','',NULL,'Rafinesque','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30348','','','Opuntia cespitosa Rafinesque',1,'Opuntia cespitosa','Opuntia cespitosa','Opuntia cespitos',2,0,'','','Rafinesque','a4658929-f57f-5473-ae68-eb49d6635e09','Opuntia cespitosa Rafinesque','Rafinesque','SPECIES','','Opuntia','','cespitosa','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4245','','','Agrostemma githago Linnaeus',1,'Agrostemma githago','Agrostemma githago','Agrostemma githag',2,0,'','','Linnaeus','2569ec17-2135-536f-8d25-eb305516903f','Agrostemma githago Linnaeus','Linnaeus','SPECIES','','Agrostemma','','githago','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4395','','','Silene repens Patrin',1,'Silene repens','Silene repens','Silene repens',2,0,'','','Patrin','edafb1e5-993b-5d59-851a-0cc4082efce2','Silene repens Patrin','Patrin','SPECIES','','Silene','','repens','','','',NULL,'','','','','','Patrin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32820','','','Silene sect. Lychnis (Linnaeus) Greuter',2,'Lychnis','Silene sect. Lychnis','Lychnis',1,0,'','','Linnaeus|Greuter','244ec396-c86b-5ef7-a6c8-3289bb29d614','Silene sect. Lychnis (Linnaeus) Greuter','(Linnaeus) Greuter','SECTION','Lychnis','','','','','','',NULL,'Greuter','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32822','','','Silene subg. Behenantha (Otth) Torrey & A. Gray',2,'Behenantha','Silene subgen. Behenantha','Behenantha',1,0,'','','Otth|Torrey|A. Gray','afad11f6-c101-5f49-ae52-86e754071e7f','Silene subg. Behenantha (Otth) Torrey & A. Gray','(Otth) Torrey & A. Gray','SUBGENUS','Behenantha','','','','','','',NULL,'Torrey & A. Gray','','','','','Otth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32824','','','Silene sect. Melandrium (Röhling) Rabeler',2,'Melandrium','Silene sect. Melandrium','Melandrium',1,0,'','','Röhling|Rabeler','ae3ccc1e-2aec-56d3-9b4e-05fd773d83a0','Silene sect. Melandrium (Röhling) Rabeler','(Röhling) Rabeler','SECTION','Melandrium','','','','','','',NULL,'Rabeler','','','','','Röhling','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4411','','','Silene ×hampeana Meusel & K. Werner',3,'','','',NULL,NULL,'','','','','Silene ×hampeana Meusel & K. Werner','Meusel & K. Werner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4390','','','Silene menziesii Hooker',1,'Silene menziesii','Silene menziesii','Silene menzies',2,0,'','','Hooker','3f72524c-82cd-5f0c-bbd3-d5a737368fca','Silene menziesii Hooker','Hooker','SPECIES','','Silene','','menziesii','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4375','','','Silene dichotoma Ehrhart',1,'Silene dichotoma','Silene dichotoma','Silene dichotom',2,0,'','','Ehrhart','9e16f347-1b41-5b8d-841e-a55b849243be','Silene dichotoma Ehrhart','Ehrhart','SPECIES','','Silene','','dichotoma','','','',NULL,'','','','','','Ehrhart','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4409','','','Silene vulgaris (Moench) Garcke',1,'Silene vulgaris','Silene vulgaris','Silene uulgar',2,0,'','','Moench|Garcke','852c90d2-2fdb-5dcc-b7c0-f839760a841d','Silene vulgaris (Moench) Garcke','(Moench) Garcke','SPECIES','','Silene','','vulgaris','','','',NULL,'Garcke','','','','','Moench','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4378','','','Silene douglasii Hooker',1,'Silene douglasii','Silene douglasii','Silene douglas',2,0,'','','Hooker','14a23ecc-bb25-5da4-9b85-1a75cb1db9e2','Silene douglasii Hooker','Hooker','SPECIES','','Silene','','douglasii','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4393','','','Silene parryi (S. Watson) C.L. Hitchcock & Maguire',1,'Silene parryi','Silene parryi','Silene parry',2,0,'','','S. Watson|C. L. Hitchcock|Maguire','7914e5c7-891b-554b-be3f-f8e4e54cfee7','Silene parryi (S. Watson) C.L. Hitchcock & Maguire','(S. Watson) C.L. Hitchcock & Maguire','SPECIES','','Silene','','parryi','','','',NULL,'C. L. Hitchcock & Maguire','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4402','','','Silene stellata (Linnaeus) W.T. Aiton',1,'Silene stellata','Silene stellata','Silene stellat',2,0,'','','Linnaeus|W. T. Aiton','e984ba91-1b05-5618-a54f-e8e6da5ea66a','Silene stellata (Linnaeus) W.T. Aiton','(Linnaeus) W.T. Aiton','SPECIES','','Silene','','stellata','','','',NULL,'W. T. Aiton','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21661','','','Silene soczavana (Schischkin) Bocquet',1,'Silene soczavana','Silene soczavana','Silene soczauan',2,0,'','','Schischkin|Bocquet','db05d047-f31a-56f5-bdf0-68801ac33b69','Silene soczavana (Schischkin) Bocquet','(Schischkin) Bocquet','SPECIES','','Silene','','soczavana','','','',NULL,'Bocquet','','','','','Schischkin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32832','','','Silene sect. Sclerophyllae (Chowdhuri) F. Jafari',2,'Sclerophyllae','Silene sect. Sclerophyllae','Sclerophyllae',1,0,'','','Chowdhuri|F. Jafari','a811cbd9-dd21-5eeb-a133-3ebdc668ec0e','Silene sect. Sclerophyllae (Chowdhuri) F. Jafari','(Chowdhuri) F. Jafari','SECTION','Sclerophyllae','','','','','','',NULL,'F. Jafari','','','','','Chowdhuri','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27711','','','Atocion Adanson',1,'Atocion','Atocion','Atocion',1,0,'','','Adanson','e267577a-26a2-5ccf-86ea-651e8a6324cf','Atocion Adanson','Adanson','GENUS','Atocion','','','','','','',NULL,'','','','','','Adanson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4246','','','Arenaria humifusa Wahlenberg',1,'Arenaria humifusa','Arenaria humifusa','Arenaria humifus',2,0,'','','Wahlenberg','73b93678-189f-5dbe-b1ed-ee4eb016ee36','Arenaria humifusa Wahlenberg','Wahlenberg','SPECIES','','Arenaria','','humifusa','','','',NULL,'','','','','','Wahlenberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4250','','','Arenaria serpyllifolia Linnaeus',1,'Arenaria serpyllifolia','Arenaria serpyllifolia','Arenaria serpyllifol',2,0,'','','Linnaeus','840c41fb-bd77-52b8-8f94-ab1917d114ce','Arenaria serpyllifolia Linnaeus','Linnaeus','SPECIES','','Arenaria','','serpyllifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4251','','','Cerastium aleuticum Hultén',1,'Cerastium aleuticum','Cerastium aleuticum','Cerastium aleutic',2,0,'','','Hultén','88791e3e-995d-5c25-b479-4dcdcb4605fc','Cerastium aleuticum Hultén','Hultén','SPECIES','','Cerastium','','aleuticum','','','',NULL,'','','','','','Hultén','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4260','','','Cerastium bialynickii Tolmatchew',1,'Cerastium bialynickii','Cerastium bialynickii','Cerastium bialynick',2,0,'','','Tolmatchew','4363ef00-6565-56d6-8b67-f33cf1192975','Cerastium bialynickii Tolmatchew','Tolmatchew','SPECIES','','Cerastium','','bialynickii','','','',NULL,'','','','','','Tolmatchew','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4263','','','Cerastium cerastoides (Linnaeus) Britton',1,'Cerastium cerastoides','Cerastium cerastoides','Cerastium cerastoid',2,0,'','','Linnaeus|Britton','d577d961-b857-5f43-bc29-d903e3bfdebc','Cerastium cerastoides (Linnaeus) Britton','(Linnaeus) Britton','SPECIES','','Cerastium','','cerastoides','','','',NULL,'Britton','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4274','','','Cerastium semidecandrum Linnaeus',1,'Cerastium semidecandrum','Cerastium semidecandrum','Cerastium semidecandr',2,0,'','','Linnaeus','6d5ceb8e-669b-553c-93e7-61e2bcb36fc6','Cerastium semidecandrum Linnaeus','Linnaeus','SPECIES','','Cerastium','','semidecandrum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4270','','','Cerastium nutans Rafinesque var. nutans',1,'Cerastium nutans nutans','Cerastium nutans var. nutans','Cerastium nutans nutans',3,0,'','','','d130bc11-278c-52a7-8de8-7630216ad7c1','Cerastium nutans Rafinesque var. nutans','Rafinesque','VARIETY','','Cerastium','','nutans','nutans','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4254','','','Cerastium alpinum subsp. lanatum (Lamarck) Cesati',1,'Cerastium alpinum lanatum','Cerastium alpinum subsp. lanatum','Cerastium alpin lanat',3,0,'','','Lamarck|Cesati','5d7e2dc5-3854-544e-ac30-83334a365093','Cerastium alpinum subsp. lanatum (Lamarck) Cesati','(Lamarck) Cesati','SUBSPECIES','','Cerastium','','alpinum','lanatum','','',NULL,'Cesati','','','','','Lamarck','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4308','','','Holosteum umbellatum Linnaeus',1,'Holosteum umbellatum','Holosteum umbellatum','Holosteum umbellat',2,0,'','','Linnaeus','c4d0e48d-a032-518b-88b3-f88f52cdd14c','Holosteum umbellatum Linnaeus','Linnaeus','SPECIES','','Holosteum','','umbellatum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4336','','','Myosoton aquaticum (Linnaeus) Moench',1,'Myosoton aquaticum','Myosoton aquaticum','Myosoton aquatic',2,0,'','','Linnaeus|Moench','22ee94df-5872-5e13-add1-de8253924456','Myosoton aquaticum (Linnaeus) Moench','(Linnaeus) Moench','SPECIES','','Myosoton','','aquaticum','','','',NULL,'Moench','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4429','','','Stellaria calycantha (Ledebour) Bongard',1,'Stellaria calycantha','Stellaria calycantha','Stellaria calycanth',2,0,'','','Ledebour|Bongard','24582dc7-5a12-5969-b869-f709bd0dc2c7','Stellaria calycantha (Ledebour) Bongard','(Ledebour) Bongard','SPECIES','','Stellaria','','calycantha','','','',NULL,'Bongard','','','','','Ledebour','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4434','','','Stellaria holostea Linnaeus',1,'Stellaria holostea','Stellaria holostea','Stellaria holoste',2,0,'','','Linnaeus','b75f7986-d144-504e-b452-4d386545f5ea','Stellaria holostea Linnaeus','Linnaeus','SPECIES','','Stellaria','','holostea','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4440','','','Stellaria media (Linnaeus) Villars',1,'Stellaria media','Stellaria media','Stellaria med',2,0,'','','Linnaeus|Villars','8ab31866-1d00-5c93-8591-0a3a73c090e6','Stellaria media (Linnaeus) Villars','(Linnaeus) Villars','SPECIES','','Stellaria','','media','','','',NULL,'Villars','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4427','','','Stellaria borealis Bigelow',1,'Stellaria borealis','Stellaria borealis','Stellaria boreal',2,0,'','','Bigelow','57886126-1329-52c6-bece-c4e982d1d777','Stellaria borealis Bigelow','Bigelow','SPECIES','','Stellaria','','borealis','','','',NULL,'','','','','','Bigelow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4438','','','Stellaria longipes Goldie',1,'Stellaria longipes','Stellaria longipes','Stellaria longip',2,0,'','','Goldie','157f514b-0b17-518c-96e8-efa6880322bb','Stellaria longipes Goldie','Goldie','SPECIES','','Stellaria','','longipes','','','',NULL,'','','','','','Goldie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4280','','','Corrigiola litoralis Linnaeus',1,'Corrigiola litoralis','Corrigiola litoralis','Corrigiola litoral',2,0,'','','Linnaeus','b51e097d-445e-5234-aac3-8e0bb0b2f810','Corrigiola litoralis Linnaeus','Linnaeus','SPECIES','','Corrigiola','','litoralis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4286','','','Dianthus chinensis Linnaeus',1,'Dianthus chinensis','Dianthus chinensis','Dianthus chinens',2,0,'','','Linnaeus','4858e1b6-b887-52e2-b29d-5c005088803d','Dianthus chinensis Linnaeus','Linnaeus','SPECIES','','Dianthus','','chinensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4292','','','Dianthus repens Willdenow',1,'Dianthus repens','Dianthus repens','Dianthus repens',2,0,'','','Willdenow','d479f719-5da3-52e1-9faa-478d1217c6bc','Dianthus repens Willdenow','Willdenow','SPECIES','','Dianthus','','repens','','','',NULL,'','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4288','','','Dianthus deltoides Linnaeus',1,'Dianthus deltoides','Dianthus deltoides','Dianthus deltoid',2,0,'','','Linnaeus','b65a9841-8439-5b11-85c5-1dddcf3445ff','Dianthus deltoides Linnaeus','Linnaeus','SPECIES','','Dianthus','','deltoides','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4291','','','Dianthus plumarius Linnaeus',1,'Dianthus plumarius','Dianthus plumarius','Dianthus plumar',2,0,'','','Linnaeus','fea42017-8537-5e73-b6ee-41653e98ced9','Dianthus plumarius Linnaeus','Linnaeus','SPECIES','','Dianthus','','plumarius','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4303','','','Gypsophila paniculata Linnaeus',1,'Gypsophila paniculata','Gypsophila paniculata','Gypsophila paniculat',2,0,'','','Linnaeus','bc86f383-3843-5254-a35a-e4d05b735c74','Gypsophila paniculata Linnaeus','Linnaeus','SPECIES','','Gypsophila','','paniculata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9579','','','Petrorhagia nanteuilii (Burnat) P.W. Ball & Heywood',1,'Petrorhagia nanteuilii','Petrorhagia nanteuilii','Petrorhagia nanteuil',2,0,'','','Burnat|P. W. Ball|Heywood','d9427647-735d-5667-b2cd-4debdd4acb44','Petrorhagia nanteuilii (Burnat) P.W. Ball & Heywood','(Burnat) P.W. Ball & Heywood','SPECIES','','Petrorhagia','','nanteuilii','','','',NULL,'P. W. Ball & Heywood','','','','','Burnat','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1241','','','Herniaria Linnaeus',1,'Herniaria','Herniaria','Herniaria',1,0,'','','Linnaeus','7399eb87-9d9a-50be-b7dd-888b1b61a6d2','Herniaria Linnaeus','Linnaeus','GENUS','Herniaria','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4339','','','Paronychia fastigiata (Rafinesque) Fernald',1,'Paronychia fastigiata','Paronychia fastigiata','Paronychia fastigiat',2,0,'','','Rafinesque|Fernald','e4b2fcc6-89f4-5ce2-b8b5-4292c1cf0c0b','Paronychia fastigiata (Rafinesque) Fernald','(Rafinesque) Fernald','SPECIES','','Paronychia','','fastigiata','','','',NULL,'Fernald','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4364','','','Scleranthus annuus Linnaeus',1,'Scleranthus annuus','Scleranthus annuus','Scleranthus annu',2,0,'','','Linnaeus','b813cc27-37b3-51db-9b4a-952c2299c560','Scleranthus annuus Linnaeus','Linnaeus','SPECIES','','Scleranthus','','annuus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4365','','','Scleranthus perennis Linnaeus subsp. perennis',1,'Scleranthus perennis perennis','Scleranthus perennis subsp. perennis','Scleranthus perenn perenn',3,0,'','','','06dc8285-5af2-5859-9219-4adc6f441637','Scleranthus perennis Linnaeus subsp. perennis','Linnaeus','SUBSPECIES','','Scleranthus','','perennis','perennis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30499','','','Cherleria Linnaeus',1,'Cherleria','Cherleria','Cherleria',1,0,'','','Linnaeus','0f1f3344-4ab2-542e-a1da-b4509826786c','Cherleria Linnaeus','Linnaeus','GENUS','Cherleria','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30501','','','Cherleria biflora (Linnaeus) A.J. Moore & Dillenberger',1,'Cherleria biflora','Cherleria biflora','Cherleria biflor',2,0,'','','Linnaeus|A. J. Moore|Dillenberger','d3fc3d51-6bfb-50ec-9f1b-e9abfbd0665f','Cherleria biflora (Linnaeus) A.J. Moore & Dillenberger','(Linnaeus) A.J. Moore & Dillenberger','SPECIES','','Cherleria','','biflora','','','',NULL,'A. J. Moore & Dillenberger','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('671','','','Sagineae',1,'Sagineae','Sagineae','Sagineae',1,0,'','','','049adef7-5b22-5f2a-8e14-c55b18bf03b1','Sagineae','','TRIBE','Sagineae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4346','','','Sagina apetala P. Arduino',1,'Sagina apetala','Sagina apetala','Sagina apetal',2,0,'','','P. Arduino','ea75685e-595a-5ea8-86ae-27f498444352','Sagina apetala P. Arduino','P. Arduino','SPECIES','','Sagina','','apetala','','','',NULL,'','','','','','P. Arduino','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4355','','','Sagina nivalis (Lindblom) Fries',1,'Sagina nivalis','Sagina nivalis','Sagina niual',2,0,'','','Lindblom|Fries','4f624898-fc7d-52c8-b9cf-d06038a028b6','Sagina nivalis (Lindblom) Fries','(Lindblom) Fries','SPECIES','','Sagina','','nivalis','','','',NULL,'Fries','','','','','Lindblom','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4348','','','Sagina decumbens (Elliott) Torrey & A. Gray subsp. decumbens',1,'Sagina decumbens decumbens','Sagina decumbens subsp. decumbens','Sagina decumbens decumbens',3,0,'','','','2e855ec4-7bac-51a5-bc99-bc8d3b59913c','Sagina decumbens (Elliott) Torrey & A. Gray subsp. decumbens','(Elliott) Torrey & A. Gray','SUBSPECIES','','Sagina','','decumbens','decumbens','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4356','','','Sagina nodosa subsp. borealis G.E. Crow',1,'Sagina nodosa borealis','Sagina nodosa subsp. borealis','Sagina nodos boreal',3,0,'','','G. E. Crow','88f6eaa4-0260-5ead-ad0f-2ea0cf2a7c8b','Sagina nodosa subsp. borealis G.E. Crow','G.E. Crow','SUBSPECIES','','Sagina','','nodosa','borealis','','',NULL,'','','','','','G. E. Crow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28305','','','Sabulina pusilla (S. Watson) Dillenberger & Kadereit',1,'Sabulina pusilla','Sabulina pusilla','Sabulina pusill',2,0,'','','S. Watson|Dillenberger|Kadereit','152ab091-25b6-5e1b-970f-ba6d8de0d2c9','Sabulina pusilla (S. Watson) Dillenberger & Kadereit','(S. Watson) Dillenberger & Kadereit','SPECIES','','Sabulina','','pusilla','','','',NULL,'Dillenberger & Kadereit','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('681','','','Sperguleae',1,'Sperguleae','Sperguleae','Sperguleae',1,0,'','','','7ab06ab8-1259-5e48-a98d-907d503aeaf4','Sperguleae','','TRIBE','Sperguleae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1706','','','Spergularia (Persoon) J. Presl & C. Presl',2,'Spergularia','Spergularia','Spergularia',1,0,'','','Persoon|J. Presl|C. Presl','25c2cf72-45f2-5bf6-954c-2d8730deaf92','Spergularia (Persoon) J. Presl & C. Presl','(Persoon) J. Presl & C. Presl','GENUS','Spergularia','','','','','','',NULL,'J. Presl & C. Presl','','','','','Persoon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4415','','','Spergularia canadensis var. occidentalis R.P. Rossbach',1,'Spergularia canadensis occidentalis','Spergularia canadensis var. occidentalis','Spergularia canadens occidental',3,0,'','','R. P. Rossbach','66b705fa-14a3-592a-a658-4a2fe354aa74','Spergularia canadensis var. occidentalis R.P. Rossbach','R.P. Rossbach','VARIETY','','Spergularia','','canadensis','occidentalis','','',NULL,'','','','','','R. P. Rossbach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4419','','','Spergularia media (Linnaeus) C. Presl var. media',1,'Spergularia media media','Spergularia media var. media','Spergularia med med',3,0,'','','','5233cdd9-3a77-5b98-8679-b5e309828da5','Spergularia media (Linnaeus) C. Presl var. media','(Linnaeus) C. Presl','VARIETY','','Spergularia','','media','media','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4296','','','Eremogone capillaris (Poiret) Fenzl',1,'Eremogone capillaris','Eremogone capillaris','Eremogone capillar',2,0,'','','Poiret|Fenzl','f28efa65-dcf3-566a-be16-79b18d1f1cc3','Eremogone capillaris (Poiret) Fenzl','(Poiret) Fenzl','SPECIES','','Eremogone','','capillaris','','','',NULL,'Fenzl','','','','','Poiret','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5363','','','Drosera intermedia Hayne',1,'Drosera intermedia','Drosera intermedia','Drosera intermed',2,0,'','','Hayne','5c96ee80-eb02-5b87-bdf4-3d637bdcf601','Drosera intermedia Hayne','Hayne','SPECIES','','Drosera','','intermedia','','','',NULL,'','','','','','Hayne','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5369','','','Drosera ×woodii Gauthier & Gervais',3,'','','',NULL,NULL,'','','','','Drosera ×woodii Gauthier & Gervais','Gauthier & Gervais','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5980','','','Frankenia pulverulenta Linnaeus',1,'Frankenia pulverulenta','Frankenia pulverulenta','Frankenia puluerulent',2,0,'','','Linnaeus','faa8fa81-8cba-5650-87e4-8602bb8ab376','Frankenia pulverulenta Linnaeus','Linnaeus','SPECIES','','Frankenia','','pulverulenta','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8247','','','Cistanthe umbellata (Torrey) Hershkovitz',1,'Cistanthe umbellata','Cistanthe umbellata','Cistanthe umbellat',2,0,'','','Torrey|Hershkovitz','73abe639-10df-50d4-898e-c50c7d1fe474','Cistanthe umbellata (Torrey) Hershkovitz','(Torrey) Hershkovitz','SPECIES','','Cistanthe','','umbellata','','','',NULL,'Hershkovitz','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8257','','','Claytonia ogilviensis McNeill',1,'Claytonia ogilviensis','Claytonia ogilviensis','Claytonia ogiluiens',2,0,'','','McNeill','80be4626-df1d-5573-ab89-cff75cf5ac69','Claytonia ogilviensis McNeill','McNeill','SPECIES','','Claytonia','','ogilviensis','','','',NULL,'','','','','','McNeill','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8268','','','Claytonia sibirica Linnaeus',1,'Claytonia sibirica','Claytonia sibirica','Claytonia sibiric',2,0,'','','Linnaeus','5ac7e87b-88e4-5e73-b560-f6deb38bdf10','Claytonia sibirica Linnaeus','Linnaeus','SPECIES','','Claytonia','','sibirica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8250','','','Claytonia exigua Douglas ex Torrey & A. Gray subsp. exigua',2,'Claytonia exigua exigua','Claytonia exigua subsp. exigua','Claytonia exigu exigu',3,0,'','','','de67ed67-aac1-5af3-aacd-37f27a860162','Claytonia exigua Douglas ex Torrey & A. Gray subsp. exigua','Douglas ex Torrey & A. Gray','SUBSPECIES','','Claytonia','','exigua','exigua','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8264','','','Claytonia rubra (Howell) Tidestrom',1,'Claytonia rubra','Claytonia rubra','Claytonia rubr',2,0,'','','Howell|Tidestrom','74e8a7d1-f39e-5ba6-bffe-5a7afb84ccc7','Claytonia rubra (Howell) Tidestrom','(Howell) Tidestrom','SPECIES','','Claytonia','','rubra','','','',NULL,'Tidestrom','','','','','Howell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8275','','','Lewisia pygmaea (A. Gray) B.L. Robinson',1,'Lewisia pygmaea','Lewisia pygmaea','Lewisia pygmae',2,0,'','','A. Gray|B. L. Robinson','2c1ee6da-20f0-5cd1-95bc-92c706cdcb69','Lewisia pygmaea (A. Gray) B.L. Robinson','(A. Gray) B.L. Robinson','SPECIES','','Lewisia','','pygmaea','','','',NULL,'B. L. Robinson','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8272','','','Lewisia columbiana (Howell ex A. Gray) B.L. Robinson var. columbiana',2,'Lewisia columbiana columbiana','Lewisia columbiana var. columbiana','Lewisia columbian columbian',3,0,'','','','11de82fe-2d2c-5069-a273-22f9bc451ca7','Lewisia columbiana (Howell ex A. Gray) B.L. Robinson var. columbiana','(Howell ex A. Gray) B.L. Robinson','VARIETY','','Lewisia','','columbiana','columbiana','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8284','','','Montia howellii S. Watson',1,'Montia howellii','Montia howellii','Montia howell',2,0,'','','S. Watson','23fe6bcf-5314-51ce-8559-9b53faf59f4d','Montia howellii S. Watson','S. Watson','SPECIES','','Montia','','howellii','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26644','','','Lewisiopsis Govaerts',1,'Lewisiopsis','Lewisiopsis','Lewisiopsis',1,0,'','','Govaerts','4f9c549f-a618-5b5c-b46e-62520af34a20','Lewisiopsis Govaerts','Govaerts','GENUS','Lewisiopsis','','','','','','',NULL,'','','','','','Govaerts','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19294','','','Lewisiopsis tweedyi (A. Gray) Govaerts',1,'Lewisiopsis tweedyi','Lewisiopsis tweedyi','Lewisiopsis tweedy',2,0,'','','A. Gray|Govaerts','53900624-b3af-5695-98d5-b899a4d8e76c','Lewisiopsis tweedyi (A. Gray) Govaerts','(A. Gray) Govaerts','SPECIES','','Lewisiopsis','','tweedyi','','','',NULL,'Govaerts','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('765','','','Abronia Jussieu',1,'Abronia','Abronia','Abronia',1,0,'','','Jussieu','3e2593e4-7033-504d-bada-1dadb77005c3','Abronia Jussieu','Jussieu','GENUS','Abronia','','','','','','',NULL,'','','','','','Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6710','','','Tripterocalyx micranthus (Torrey) Hooker',1,'Tripterocalyx micranthus','Tripterocalyx micranthus','Tripterocalyx micranth',2,0,'','','Torrey|Hooker','fc4bbad4-f894-5332-89ae-be3c847dabfe','Tripterocalyx micranthus (Torrey) Hooker','(Torrey) Hooker','SPECIES','','Tripterocalyx','','micranthus','','','',NULL,'Hooker','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('372','','','Phytolaccoideae',1,'Phytolaccoideae','Phytolaccoideae','Phytolaccoideae',1,0,'','','','08d8f314-ee38-5204-b1cc-3e3826b0d5d3','Phytolaccoideae','','SUBFAMILY','Phytolaccoideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1546','','','Phytolacca Linnaeus',1,'Phytolacca','Phytolacca','Phytolacca',1,0,'','','Linnaeus','477ceaf2-896e-54ff-8279-ccbbf280f43f','Phytolacca Linnaeus','Linnaeus','GENUS','Phytolacca','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7156','','','Phytolacca americana Linnaeus var. americana',1,'Phytolacca americana americana','Phytolacca americana var. americana','Phytolacca american american',3,0,'','','','42ad6373-c990-50d3-89f6-7c575b9b91e9','Phytolacca americana Linnaeus var. americana','Linnaeus','VARIETY','','Phytolacca','','americana','americana','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7353','','','Armeria maritima subsp. interior (Raup) A.E. Porsild',1,'Armeria maritima interior','Armeria maritima subsp. interior','Armeria maritim interior',3,0,'','','Raup|A. E. Porsild','7de18e1f-f6cb-5b86-9b88-b43a2878efd4','Armeria maritima subsp. interior (Raup) A.E. Porsild','(Raup) A.E. Porsild','SUBSPECIES','','Armeria','','maritima','interior','','',NULL,'A. E. Porsild','','','','','Raup','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('555','','','Persicarieae Dumortier',1,'Persicarieae','Persicarieae','Persicarieae',1,0,'','','Dumortier','c696d4b3-d0a4-5fed-868d-27b5b5fb0c4a','Persicarieae Dumortier','Dumortier','TRIBE','Persicarieae','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1307','','','Koenigia Linnaeus',1,'Koenigia','Koenigia','Koenigia',1,0,'','','Linnaeus','25600642-73af-5a8f-8370-15ef4e534e43','Koenigia Linnaeus','Linnaeus','GENUS','Koenigia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31368','','','Koenigia polystachya (Wallich ex Meisner) T.M. Schuster & Reveal',2,'Koenigia polystachya','Koenigia polystachya','Koenigia polystachy',2,0,'','','Wallich|Meisner|T. M. Schuster|Reveal','e6eb9a56-b142-51cd-bbc4-4cf6cec32d2a','Koenigia polystachya (Wallich ex Meisner) T.M. Schuster & Reveal','(Wallich ex Meisner) T.M. Schuster & Reveal','SPECIES','','Koenigia','','polystachya','','','',NULL,'T. M. Schuster & Reveal','','','','','Wallich','','Meisner','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8157','','','Persicaria sagittata (Linnaeus) H. Gross',1,'Persicaria sagittata','Persicaria sagittata','Persicaria sagittat',2,0,'','','Linnaeus|H. Gross','9a51b021-2ab1-5584-9d9a-ef55ad6b33f7','Persicaria sagittata (Linnaeus) H. Gross','(Linnaeus) H. Gross','SPECIES','','Persicaria','','sagittata','','','',NULL,'H. Gross','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8147','','','Persicaria lapathifolia (Linnaeus) Delarbre',1,'Persicaria lapathifolia','Persicaria lapathifolia','Persicaria lapathifol',2,0,'','','Linnaeus|Delarbre','4fe9280e-d27d-58b8-bd68-2ba24a2380dd','Persicaria lapathifolia (Linnaeus) Delarbre','(Linnaeus) Delarbre','SPECIES','','Persicaria','','lapathifolia','','','',NULL,'Delarbre','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2244','','','Persicaria sect. Cephalophilon (Meisner) H. Gross',2,'Cephalophilon','Persicaria sect. Cephalophilon','Cephalophilon',1,0,'','','Meisner|H. Gross','23def58e-c375-5cb7-9d3a-cef8251255f5','Persicaria sect. Cephalophilon (Meisner) H. Gross','(Meisner) H. Gross','SECTION','Cephalophilon','','','','','','',NULL,'H. Gross','','','','','Meisner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2245','','','Persicaria sect. Tovara (Adanson) H. Gross',2,'Tovara','Persicaria sect. Tovara','Tovara',1,0,'','','Adanson|H. Gross','a1965c3c-2cc9-54e0-98fc-71b08688639e','Persicaria sect. Tovara (Adanson) H. Gross','(Adanson) H. Gross','SECTION','Tovara','','','','','','',NULL,'H. Gross','','','','','Adanson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('556','','','Polygoneae Reichenbach',1,'Polygoneae','Polygoneae','Polygoneae',1,0,'','','Reichenbach','575ed904-68cb-5eaa-bdfd-08a75d4baceb','Polygoneae Reichenbach','Reichenbach','TRIBE','Polygoneae','','','','','','',NULL,'','','','','','Reichenbach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8131','','','Fallopia dumetorum (Linnaeus) Holub',1,'Fallopia dumetorum','Fallopia dumetorum','Fallopia dumetor',2,0,'','','Linnaeus|Holub','fb2e87b6-3c22-5324-868e-c782a7dac943','Fallopia dumetorum (Linnaeus) Holub','(Linnaeus) Holub','SPECIES','','Fallopia','','dumetorum','','','',NULL,'Holub','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24864','','','Polygonum sect. Duravia S. Watson',2,'Duravia','Polygonum sect. Duravia','Duravia',1,0,'','','S. Watson','bdc60948-788d-5c14-940a-40444e52de00','Polygonum sect. Duravia S. Watson','S. Watson','SECTION','Duravia','','','','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8194','','','Polygonum sawatchense subsp. oblivium Costea & Tardif',1,'Polygonum sawatchense oblivium','Polygonum sawatchense subsp. oblivium','Polygonum sawatchens obliui',3,0,'','','Costea|Tardif','f8898fd6-f27c-55d4-a66c-f0c9556b3e3f','Polygonum sawatchense subsp. oblivium Costea & Tardif','Costea & Tardif','SUBSPECIES','','Polygonum','','sawatchense','oblivium','','',NULL,'','','','','','Costea & Tardif','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8198','','','Polygonum tenue Michaux',1,'Polygonum tenue','Polygonum tenue','Polygonum tenu',2,0,'','','Michaux','60a77bea-46f2-5246-831d-c56e281edcf1','Polygonum tenue Michaux','Michaux','SPECIES','','Polygonum','','tenue','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8186','','','Polygonum paronychia Chamisso & Schlechtendal',1,'Polygonum paronychia','Polygonum paronychia','Polygonum paronych',2,0,'','','Chamisso|Schlechtendal','d7c2c907-c456-5cd5-93e2-a74327403ebb','Polygonum paronychia Chamisso & Schlechtendal','Chamisso & Schlechtendal','SPECIES','','Polygonum','','paronychia','','','',NULL,'','','','','','Chamisso & Schlechtendal','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24865','','','Polygonum sect. Polygonum Linnaeus',2,'Polygonum','Polygonum sect. Polygonum','Polygonum',1,0,'','','Linnaeus','bccd996f-64a4-576c-9eaa-520f2fe1f03e','Polygonum sect. Polygonum Linnaeus','Linnaeus','SECTION','Polygonum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8175','','','Polygonum fowleri subsp. fowleri × Polygonum fowleri subsp. hudsonianum',2,'Polygonum fowleri fowleri × Polygonum fowleri hudsonianum','Polygonum fowleri subsp. fowleri × Polygonum fowleri subsp. hudsonianum','Polygonum fowler fowler × Polygonum fowler hudsonian',0,0,'HYBRID_FORMULA','','','9e2595ee-a32e-559e-a4dd-cedbf4cffe27','Polygonum fowleri subsp. fowleri × Polygonum fowleri subsp. hudsonianum','','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8177','','','Polygonum humifusum subsp. caurianum (B.L. Robinson) Costea & Tardif',1,'Polygonum humifusum caurianum','Polygonum humifusum subsp. caurianum','Polygonum humifus caurian',3,0,'','','B. L. Robinson|Costea|Tardif','7b28890b-facc-59f8-af92-7456c9db28d6','Polygonum humifusum subsp. caurianum (B.L. Robinson) Costea & Tardif','(B.L. Robinson) Costea & Tardif','SUBSPECIES','','Polygonum','','humifusum','caurianum','','',NULL,'Costea & Tardif','','','','','B. L. Robinson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8168','','','Polygonum aviculare subsp. neglectum (Besser)  Arcangeli',1,'Polygonum aviculare neglectum','Polygonum aviculare subsp. neglectum','Polygonum auicular neglect',3,0,'','','Besser|Arcangeli','9dbff898-3530-5be8-911a-9b434f3913e4','Polygonum aviculare subsp. neglectum (Besser)  Arcangeli','(Besser)  Arcangeli','SUBSPECIES','','Polygonum','','aviculare','neglectum','','',NULL,'Arcangeli','','','','','Besser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26456','','','Polygonum aviculare subsp. boreale (Lange) Karlsson',1,'Polygonum aviculare boreale','Polygonum aviculare subsp. boreale','Polygonum auicular boreal',3,0,'','','Lange|Karlsson','930e4860-ed3a-5bff-8e66-63c1f2a0721f','Polygonum aviculare subsp. boreale (Lange) Karlsson','(Lange) Karlsson','SUBSPECIES','','Polygonum','','aviculare','boreale','','',NULL,'Karlsson','','','','','Lange','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8162','','','Polygonum achoreum S.F. Blake',1,'Polygonum achoreum','Polygonum achoreum','Polygonum achore',2,0,'','','S. F. Blake','b4ef252f-e09b-5d54-9a0d-f3aebcfd704b','Polygonum achoreum S.F. Blake','S.F. Blake','SPECIES','','Polygonum','','achoreum','','','',NULL,'','','','','','S. F. Blake','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('639','','','Rumiceae Dumortier',1,'Rumiceae','Rumiceae','Rumiceae',1,0,'','','Dumortier','9a9a944c-6cb0-50d3-bbf2-895aaca1b2df','Rumiceae Dumortier','Dumortier','TRIBE','Rumiceae','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8201','','','Rumex acetosella Linnaeus',1,'Rumex acetosella','Rumex acetosella','Rumex acetosell',2,0,'','','Linnaeus','51dddf43-9072-5115-8568-e54b6b15724f','Rumex acetosella Linnaeus','Linnaeus','SPECIES','','Rumex','','acetosella','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8208','','','Rumex crispus Linnaeus',1,'Rumex crispus','Rumex crispus','Rumex crisp',2,0,'','','Linnaeus','e38d4aa7-a9e3-53f6-9aab-bb4f2e02a126','Rumex crispus Linnaeus','Linnaeus','SPECIES','','Rumex','','crispus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8209','','','Rumex dentatus Linnaeus',1,'Rumex dentatus','Rumex dentatus','Rumex dentat',2,0,'','','Linnaeus','f4953478-4ff3-5655-a318-92bfcf7f6552','Rumex dentatus Linnaeus','Linnaeus','SPECIES','','Rumex','','dentatus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8214','','','Rumex maritimus Linnaeus',1,'Rumex maritimus','Rumex maritimus','Rumex maritim',2,0,'','','Linnaeus','f3f34ea7-bcc3-5e8b-b89e-03fcf2e34dfa','Rumex maritimus Linnaeus','Linnaeus','SPECIES','','Rumex','','maritimus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8219','','','Rumex paucifolius Nuttall',1,'Rumex paucifolius','Rumex paucifolius','Rumex paucifol',2,0,'','','Nuttall','afb722b0-05be-5ad5-9d23-72a3e60f5c20','Rumex paucifolius Nuttall','Nuttall','SPECIES','','Rumex','','paucifolius','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8222','','','Rumex sanguineus Linnaeus',1,'Rumex sanguineus','Rumex sanguineus','Rumex sanguine',2,0,'','','Linnaeus','c6849ad8-6cfc-5b74-80c9-f52d46cfe233','Rumex sanguineus Linnaeus','Linnaeus','SPECIES','','Rumex','','sanguineus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8226','','','Rumex thyrsiflorus Fingerhuth',1,'Rumex thyrsiflorus','Rumex thyrsiflorus','Rumex thyrsiflor',2,0,'','','Fingerhuth','b16d2181-d9bc-582d-93a6-3033c78be009','Rumex thyrsiflorus Fingerhuth','Fingerhuth','SPECIES','','Rumex','','thyrsiflorus','','','',NULL,'','','','','','Fingerhuth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8228','','','Rumex triangulivalvis (Danser) Rechinger f.',1,'Rumex triangulivalvis','Rumex triangulivalvis','Rumex trianguliualu',2,0,'','','Danser|Rechinger fil.','c3a8b412-0e0b-5417-aeca-aa2c8d041545','Rumex triangulivalvis (Danser) Rechinger f.','(Danser) Rechinger f.','SPECIES','','Rumex','','triangulivalvis','','','',NULL,'Rechinger fil.','','','','','Danser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9628','','','Rumex beringensis Yurtsev & V.V. Pertrovsky',1,'Rumex beringensis','Rumex beringensis','Rumex beringens',2,0,'','','Yurtsev|V. V. Pertrovsky','7d7cf7c7-2d99-5742-bafc-b46b1b14f2cb','Rumex beringensis Yurtsev & V.V. Pertrovsky','Yurtsev & V.V. Pertrovsky','SPECIES','','Rumex','','beringensis','','','',NULL,'','','','','','Yurtsev & V. V. Pertrovsky','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2040','','','Eriogonum subg. Oligogonum Nuttall',2,'Oligogonum','Eriogonum subgen. Oligogonum','Oligogonum',1,0,'','','Nuttall','45104f3c-622b-5252-a0c7-336fbdd7030f','Eriogonum subg. Oligogonum Nuttall','Nuttall','SUBGENUS','Oligogonum','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8111','','','Eriogonum flavum var. piperi (Greene) M.E. Jones',1,'Eriogonum flavum piperi','Eriogonum flavum var. piperi','Eriogonum flau piper',3,0,'','','Greene|M. E. Jones','e1557c3a-6c10-58dd-b89f-738fc641b695','Eriogonum flavum var. piperi (Greene) M.E. Jones','(Greene) M.E. Jones','VARIETY','','Eriogonum','','flavum','piperi','','',NULL,'M. E. Jones','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8126','','','Eriogonum umbellatum Torrey var. umbellatum',1,'Eriogonum umbellatum umbellatum','Eriogonum umbellatum var. umbellatum','Eriogonum umbellat umbellat',3,0,'','','','8480db82-3090-5c81-8476-1d1b84ca18f1','Eriogonum umbellatum Torrey var. umbellatum','Torrey','VARIETY','','Eriogonum','','umbellatum','umbellatum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32316','','','Eriogonum ovalifolium var. depressum Blankinship',1,'Eriogonum ovalifolium depressum','Eriogonum ovalifolium var. depressum','Eriogonum oualifoli depress',3,0,'','','Blankinship','cc7a0329-93af-5397-b486-e004851fa8b4','Eriogonum ovalifolium var. depressum Blankinship','Blankinship','VARIETY','','Eriogonum','','ovalifolium','depressum','','',NULL,'','','','','','Blankinship','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8288','','','Portulaca grandiflora Hooker',1,'Portulaca grandiflora','Portulaca grandiflora','Portulaca grandiflor',2,0,'','','Hooker','9f74e538-f229-5976-a3e0-c4329f63e51f','Portulaca grandiflora Hooker','Hooker','SPECIES','','Portulaca','','grandiflora','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9714','','','Tamarix ramosissima Ledebour',1,'Tamarix ramosissima','Tamarix ramosissima','Tamarix ramosissim',2,0,'','','Ledebour','ea050067-5e4c-52a3-8bcf-b175958908f9','Tamarix ramosissima Ledebour','Ledebour','SPECIES','','Tamarix','','ramosissima','','','',NULL,'','','','','','Ledebour','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4463','','','Ceratophyllum muricatum Chamisso',1,'Ceratophyllum muricatum','Ceratophyllum muricatum','Ceratophyllum muricat',2,0,'','','Chamisso','581bea5d-e3b3-5742-bd60-4824018228a9','Ceratophyllum muricatum Chamisso','Chamisso','SPECIES','','Ceratophyllum','','muricatum','','','',NULL,'','','','','','Chamisso','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('774','','','Acorus Linnaeus',1,'Acorus','Acorus','Acorus',1,0,'','','Linnaeus','05908653-23fb-5ad9-b8e7-b527cd86ffc3','Acorus Linnaeus','Linnaeus','GENUS','Acorus','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2461','','','Alisma subcordatum Rafinesque',1,'Alisma subcordatum','Alisma subcordatum','Alisma subcordat',2,0,'','','Rafinesque','48c75f2e-81e0-5fd6-a57c-2adf2deee908','Alisma subcordatum Rafinesque','Rafinesque','SPECIES','','Alisma','','subcordatum','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2466','','','Sagittaria cuneata E. Sheldon',1,'Sagittaria cuneata','Sagittaria cuneata','Sagittaria cuneat',2,0,'','','E. Sheldon','47413816-1dd2-54f7-8be2-bba0026b4899','Sagittaria cuneata E. Sheldon','E. Sheldon','SPECIES','','Sagittaria','','cuneata','','','',NULL,'','','','','','E. Sheldon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2473','','','Sagittaria rigida Pursh',1,'Sagittaria rigida','Sagittaria rigida','Sagittaria rigid',2,0,'','','Pursh','4ed29a40-b6b7-5a60-8c90-f5315192b290','Sagittaria rigida Pursh','Pursh','SPECIES','','Sagittaria','','rigida','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('86','','','Araceae de Jussieu',1,'Araceae','Araceae','Araceae',1,0,'','','de Jussieu','0da225dd-75fa-5cbc-9b6c-7644af9cd620','Araceae de Jussieu','de Jussieu','FAMILY','Araceae','','','','','','',NULL,'','','','','','de Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2672','','','Arisaema dracontium (Linnaeus) Schott',1,'Arisaema dracontium','Arisaema dracontium','Arisaema draconti',2,0,'','','Linnaeus|Schott','5a81f0cc-4b99-5d0b-a52a-500c0a2b591b','Arisaema dracontium (Linnaeus) Schott','(Linnaeus) Schott','SPECIES','','Arisaema','','dracontium','','','',NULL,'Schott','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('643','','','Peltandreae',1,'Peltandreae','Peltandreae','Peltandreae',1,0,'','','','fc6fa067-58b9-5751-abfc-e939c41618db','Peltandreae','','TRIBE','Peltandreae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27976','','','Pistia stratiotes Linnaeus',1,'Pistia stratiotes','Pistia stratiotes','Pistia stratiot',2,0,'','','Linnaeus','dc1c1702-20a0-55d9-ac11-c2cd54765ddd','Pistia stratiotes Linnaeus','Linnaeus','SPECIES','','Pistia','','stratiotes','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('353','','','Lemnoideae',1,'Lemnoideae','Lemnoideae','Lemnoideae',1,0,'','','','16c7a92e-e33b-5e1d-aeea-57420faac368','Lemnoideae','','SUBFAMILY','Lemnoideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6489','','','Lemna minor Linnaeus',1,'Lemna minor','Lemna minor','Lemna minor',2,0,'','','Linnaeus','de2579d7-e993-5186-a452-466776ea68a0','Lemna minor Linnaeus','Linnaeus','SPECIES','','Lemna','','minor','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6494','','','Wolffia arrhiza (Linnaeus) Horkel ex Wimmer',2,'Wolffia arrhiza','Wolffia arrhiza','Wolffia arrhiz',2,0,'','','Linnaeus|Horkel|Wimmer','808731a6-5aa1-506a-a66f-0a9e11931c28','Wolffia arrhiza (Linnaeus) Horkel ex Wimmer','(Linnaeus) Horkel ex Wimmer','SPECIES','','Wolffia','','arrhiza','','','',NULL,'Horkel','','Wimmer','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2678','','','Lysichiton americanus Hultén & H. St.John',1,'Lysichiton americanus','Lysichiton americanus','Lysichiton american',2,0,'','','Hultén|H. St. John','6d8bbc59-ecea-5709-9da4-bcdb3a21aa11','Lysichiton americanus Hultén & H. St.John','Hultén & H. St.John','SPECIES','','Lysichiton','','americanus','','','',NULL,'','','','','','Hultén & H. St. John','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4138','','','Butomus umbellatus Linnaeus',1,'Butomus umbellatus','Butomus umbellatus','Butomus umbellat',2,0,'','','Linnaeus','025c9935-59b6-5cf7-9689-92541b94a2af','Butomus umbellatus Linnaeus','Linnaeus','SPECIES','','Butomus','','umbellatus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1123','','','Egeria Planchon',1,'Egeria','Egeria','Egeria',1,0,'','','Planchon','3b52c1a5-f52a-5c30-8ea4-e55e719b6390','Egeria Planchon','Planchon','GENUS','Egeria','','','','','','',NULL,'','','','','','Planchon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6119','','','Elodea canadensis Michaux',1,'Elodea canadensis','Elodea canadensis','Elodea canadens',2,0,'','','Michaux','b6ed0e54-f9a7-55aa-903b-28e114b73714','Elodea canadensis Michaux','Michaux','SPECIES','','Elodea','','canadensis','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6127','','','Najas marina Linnaeus',1,'Najas marina','Najas marina','Najas marin',2,0,'','','Linnaeus','1caf6a08-f8fd-5452-bccc-92141742df6d','Najas marina Linnaeus','Linnaeus','SPECIES','','Najas','','marina','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1810','','','Vallisneria Linnaeus',1,'Vallisneria','Vallisneria','Vallisneria',1,0,'','','Linnaeus','e455a5f2-1444-5eab-b2e9-d3d5543b3974','Vallisneria Linnaeus','Linnaeus','GENUS','Vallisneria','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6129','','','Vallisneria americana Michaux',1,'Vallisneria americana','Vallisneria americana','Vallisneria american',2,0,'','','Michaux','59e57531-d58a-5298-ab61-5de8c6172edc','Vallisneria americana Michaux','Michaux','SPECIES','','Vallisneria','','americana','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6121','','','Hydrocharis morsus-ranae Linnaeus',1,'Hydrocharis morsus-ranae','Hydrocharis morsus-ranae','Hydrocharis morsus-ran',2,0,'','','Linnaeus','7afeadb8-d5d2-5ec7-a87e-69a0d4682d8a','Hydrocharis morsus-ranae Linnaeus','Linnaeus','SPECIES','','Hydrocharis','','morsus-ranae','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6349','','','Triglochin palustris Linnaeus',1,'Triglochin palustris','Triglochin palustris','Triglochin palustr',2,0,'','','Linnaeus','d24ec9d2-f4ad-500b-b15a-9eec0ded4ada','Triglochin palustris Linnaeus','Linnaeus','SPECIES','','Triglochin','','palustris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8292','','','Potamogeton bicupulatus Fernald',1,'Potamogeton bicupulatus','Potamogeton bicupulatus','Potamogeton bicupulat',2,0,'','','Fernald','0153bdb3-1e4e-5b76-867c-58f69160b626','Potamogeton bicupulatus Fernald','Fernald','SPECIES','','Potamogeton','','bicupulatus','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8301','','','Potamogeton gramineus Linnaeus',1,'Potamogeton gramineus','Potamogeton gramineus','Potamogeton gramine',2,0,'','','Linnaeus','156cb904-ed52-51da-a094-f66597b3affa','Potamogeton gramineus Linnaeus','Linnaeus','SPECIES','','Potamogeton','','gramineus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8306','','','Potamogeton nodosus Poiret',1,'Potamogeton nodosus','Potamogeton nodosus','Potamogeton nodos',2,0,'','','Poiret','e497d29a-ed59-5603-bf51-dd052af1d9ce','Potamogeton nodosus Poiret','Poiret','SPECIES','','Potamogeton','','nodosus','','','',NULL,'','','','','','Poiret','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8311','','','Potamogeton perfoliatus Linnaeus',1,'Potamogeton perfoliatus','Potamogeton perfoliatus','Potamogeton perfoliat',2,0,'','','Linnaeus','fb41da63-4f3e-58d2-aec5-eac61c213935','Potamogeton perfoliatus Linnaeus','Linnaeus','SPECIES','','Potamogeton','','perfoliatus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8324','','','Potamogeton ×cognatus Ascherson & Graebner',3,'','','',NULL,NULL,'','','','','Potamogeton ×cognatus Ascherson & Graebner','Ascherson & Graebner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8325','','','Potamogeton ×faxonii Morong',3,'','','',NULL,NULL,'','','','','Potamogeton ×faxonii Morong','Morong','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8326','','','Potamogeton ×griffithii A. Bennett',3,'','','',NULL,NULL,'','','','','Potamogeton ×griffithii A. Bennett','A. Bennett','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8327','','','Potamogeton ×hagstroemii A. Bennett',3,'','','',NULL,NULL,'','','','','Potamogeton ×hagstroemii A. Bennett','A. Bennett','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8330','','','Potamogeton ×nitens Weber',3,'','','',NULL,NULL,'','','','','Potamogeton ×nitens Weber','Weber','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8298','','','Potamogeton foliosus Rafinesque',1,'Potamogeton foliosus','Potamogeton foliosus','Potamogeton folios',2,0,'','','Rafinesque','e41452e5-24a2-5743-acaa-16bab3a60fcf','Potamogeton foliosus Rafinesque','Rafinesque','SPECIES','','Potamogeton','','foliosus','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30811','','','Potamogeton berchtoldii subsp. gemmiparus (J.W. Robbins) Les & Tippery',1,'Potamogeton berchtoldii gemmiparus','Potamogeton berchtoldii subsp. gemmiparus','Potamogeton berchtold gemmipar',3,0,'','','J. W. Robbins|Les|Tippery','17592fbe-a83b-5f33-9acb-f35d704a464f','Potamogeton berchtoldii subsp. gemmiparus (J.W. Robbins) Les & Tippery','(J.W. Robbins) Les & Tippery','SUBSPECIES','','Potamogeton','','berchtoldii','gemmiparus','','',NULL,'Les & Tippery','','','','','J. W. Robbins','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33384','','','Stuckenia vaginata (Magnin) Holub',1,'Stuckenia vaginata','Stuckenia vaginata','Stuckenia uaginat',2,0,'','','Magnin|Holub','a600ee2f-e3c5-5fcd-aefd-947f36719494','Stuckenia vaginata (Magnin) Holub','(Magnin) Holub','SPECIES','','Stuckenia','','vaginata','','','',NULL,'Holub','','','','','Magnin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('209','','','Ruppiaceae Horaninow',1,'Ruppiaceae','Ruppiaceae','Ruppiaceae',1,0,'','','Horaninow','552cd8cf-a07d-5034-b7a9-cf1a4fb62d68','Ruppiaceae Horaninow','Horaninow','FAMILY','Ruppiaceae','','','','','','',NULL,'','','','','','Horaninow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1659','','','Scheuchzeria Linnaeus',1,'Scheuchzeria','Scheuchzeria','Scheuchzeria',1,0,'','','Linnaeus','32e18049-bedc-53be-9414-79222dcb4d9c','Scheuchzeria Linnaeus','Linnaeus','GENUS','Scheuchzeria','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9415','','','Tofieldia coccinea Richardson',1,'Tofieldia coccinea','Tofieldia coccinea','Tofieldia coccine',2,0,'','','Richardson','8d319f0f-009f-5971-8cf1-248158a6c0ad','Tofieldia coccinea Richardson','Richardson','SPECIES','','Tofieldia','','coccinea','','','',NULL,'','','','','','Richardson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1776','','','Triantha Nuttall',1,'Triantha','Triantha','Triantha',1,0,'','','Nuttall','f3dbb715-724b-5027-83d5-a7d1e7dfbc60','Triantha Nuttall','Nuttall','GENUS','Triantha','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9552','','','Phyllospadix serrulatus Ruprecht ex Ascherson',2,'Phyllospadix serrulatus','Phyllospadix serrulatus','Phyllospadix serrulat',2,0,'','','Ruprecht|Ascherson','3ba547d7-0f9a-5a3c-914e-451b5f5d65a5','Phyllospadix serrulatus Ruprecht ex Ascherson','Ruprecht ex Ascherson','SPECIES','','Phyllospadix','','serrulatus','','','',NULL,'','','','','','Ruprecht','','Ascherson','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6','','','Asparagales Link',1,'Asparagales','Asparagales','Asparagales',1,0,'','','Link','b40fdae5-61f0-5528-8bbb-65bfb89100ed','Asparagales Link','Link','ORDER','Asparagales','','','','','','',NULL,'','','','','','Link','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('260','','','Allioideae',1,'Allioideae','Allioideae','Allioideae',1,0,'','','','e3b28bdb-45ca-59dd-9176-119cb4b0fd4a','Allioideae','','SUBFAMILY','Allioideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2479','','','Allium crenulatum Wiegand',1,'Allium crenulatum','Allium crenulatum','Allium crenulat',2,0,'','','Wiegand','cf0b7d5c-e340-57ad-be3f-1252013b2cf3','Allium crenulatum Wiegand','Wiegand','SPECIES','','Allium','','crenulatum','','','',NULL,'','','','','','Wiegand','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2496','','','Allium vineale Linnaeus',1,'Allium vineale','Allium vineale','Allium uineal',2,0,'','','Linnaeus','36ef25b2-dba7-56ef-a41a-0baee3b84795','Allium vineale Linnaeus','Linnaeus','SPECIES','','Allium','','vineale','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2485','','','Allium sativum Linnaeus var. sativum',1,'Allium sativum sativum','Allium sativum var. sativum','Allium satiu satiu',3,0,'','','','831e9e83-f082-5635-8508-7a5b5a71620e','Allium sativum Linnaeus var. sativum','Linnaeus','VARIETY','','Allium','','sativum','sativum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31444','','','Allium tuberosum Rottler ex Sprengel',2,'Allium tuberosum','Allium tuberosum','Allium tuberos',2,0,'','','Rottler|Sprengel','5459685f-84ec-5434-b041-2c8a9ebb7189','Allium tuberosum Rottler ex Sprengel','Rottler ex Sprengel','SPECIES','','Allium','','tuberosum','','','',NULL,'','','','','','Rottler','','Sprengel','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2497','','','Nothoscordum bivalve (Linnaeus) Britton',1,'Nothoscordum bivalve','Nothoscordum bivalve','Nothoscordum biualu',2,0,'','','Linnaeus|Britton','1641b967-c057-5784-a4b9-99d7be4e13d5','Nothoscordum bivalve (Linnaeus) Britton','(Linnaeus) Britton','SPECIES','','Nothoscordum','','bivalve','','','',NULL,'Britton','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2512','','','Narcissus jonquilla Linnaeus',1,'Narcissus jonquilla','Narcissus jonquilla','Narcissus ionquill',2,0,'','','Linnaeus','e4270c7a-31e8-5b42-a295-84d40c498768','Narcissus jonquilla Linnaeus','Linnaeus','SPECIES','','Narcissus','','jonquilla','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2730','','','Camassia scilloides (Rafinesque) Cory',1,'Camassia scilloides','Camassia scilloides','Camassia scilloid',2,0,'','','Rafinesque|Cory','9f23c8e5-8cf6-57bc-9617-aba5a40d907c','Camassia scilloides (Rafinesque) Cory','(Rafinesque) Cory','SPECIES','','Camassia','','scilloides','','','',NULL,'Cory','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2728','','','Camassia quamash subsp. maxima Gould',1,'Camassia quamash maxima','Camassia quamash subsp. maxima','Camassia quamash maxim',3,0,'','','Gould','efd1c2ce-83d1-5c28-81c2-ff8c41dc823f','Camassia quamash subsp. maxima Gould','Gould','SUBSPECIES','','Camassia','','quamash','maxima','','',NULL,'','','','','','Gould','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2729','','','Camassia quamash (Pursh) Greene subsp. quamash',1,'Camassia quamash quamash','Camassia quamash subsp. quamash','Camassia quamash quamash',3,0,'','','','2f75183f-aaed-5050-9f5c-edddeadef0f6','Camassia quamash (Pursh) Greene subsp. quamash','(Pursh) Greene','SUBSPECIES','','Camassia','','quamash','quamash','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2458','','','Yucca flaccida Haworth',1,'Yucca flaccida','Yucca flaccida','Yucca flaccid',2,0,'','','Haworth','420e9afb-21c8-502a-84d8-0e00f7a66303','Yucca flaccida Haworth','Haworth','SPECIES','','Yucca','','flaccida','','','',NULL,'','','','','','Haworth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2721','','','Asparagus officinalis Linnaeus',1,'Asparagus officinalis','Asparagus officinalis','Asparagus officinal',2,0,'','','Linnaeus','090cc5a7-6a73-5ae2-b415-bd5ad37a429b','Asparagus officinalis Linnaeus','Linnaeus','SPECIES','','Asparagus','','officinalis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2748','','','Triteleia grandiflora Lindley',1,'Triteleia grandiflora','Triteleia grandiflora','Triteleia grandiflor',2,0,'','','Lindley','eac05629-70bb-5ef8-82ef-16fe319b5f40','Triteleia grandiflora Lindley','Lindley','SPECIES','','Triteleia','','grandiflora','','','',NULL,'','','','','','Lindley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('359','','','Convallarioideae',1,'Convallarioideae','Convallarioideae','Convallarioideae',1,0,'','','','7cef5b46-0e26-5eb5-b430-c28b93bcb23b','Convallarioideae','','SUBFAMILY','Convallarioideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2741','','','Maianthemum trifolium (Linnaeus) Sloboda',1,'Maianthemum trifolium','Maianthemum trifolium','Maianthemum trifoli',2,0,'','','Linnaeus|Sloboda','840d77fc-963c-577a-8d79-b62990bf0225','Maianthemum trifolium (Linnaeus) Sloboda','(Linnaeus) Sloboda','SPECIES','','Maianthemum','','trifolium','','','',NULL,'Sloboda','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4605','','','Convallaria majalis Linnaeus var. majalis',1,'Convallaria majalis majalis','Convallaria majalis var. majalis','Convallaria maial maial',3,0,'','','','fc25aefc-671e-5c12-b0e8-23afcc486e99','Convallaria majalis Linnaeus var. majalis','Linnaeus','VARIETY','','Convallaria','','majalis','majalis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2731','','','Hyacinthoides hispanica (Miller) Rothmaler',1,'Hyacinthoides hispanica','Hyacinthoides hispanica','Hyacinthoides hispanic',2,0,'','','Miller|Rothmaler','61acdf84-a8d6-501f-9d6c-12e878c6ce97','Hyacinthoides hispanica (Miller) Rothmaler','(Miller) Rothmaler','SPECIES','','Hyacinthoides','','hispanica','','','',NULL,'Rothmaler','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4607','','','Polygonatum multiflorum (Linnaeus) Allioni',1,'Polygonatum multiflorum','Polygonatum multiflorum','Polygonatum multiflor',2,0,'','','Linnaeus|Allioni','77090f1b-a01e-5479-91c4-8db729d001da','Polygonatum multiflorum (Linnaeus) Allioni','(Linnaeus) Allioni','SPECIES','','Polygonatum','','multiflorum','','','',NULL,'Allioni','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2743','','','Muscari botryoides (Linnaeus) Miller',1,'Muscari botryoides','Muscari botryoides','Muscari botryoid',2,0,'','','Linnaeus|Miller','fda24b95-5f6c-58d2-9da7-e2abb0cf15c6','Muscari botryoides (Linnaeus) Miller','(Linnaeus) Miller','SPECIES','','Muscari','','botryoides','','','',NULL,'Miller','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27865','','','Scilla luciliae (Boissier) Speta',1,'Scilla luciliae','Scilla luciliae','Scilla lucili',2,0,'','','Boissier|Speta','0f5938f9-4483-517b-ae31-06ccfbcf2915','Scilla luciliae (Boissier) Speta','(Boissier) Speta','SPECIES','','Scilla','','luciliae','','','',NULL,'Speta','','','','','Boissier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('146','','','Hypoxidaceae R. Brown',1,'Hypoxidaceae','Hypoxidaceae','Hypoxidaceae',1,0,'','','R. Brown','032b84da-7d59-56b1-ba2c-beb191f2199f','Hypoxidaceae R. Brown','R. Brown','FAMILY','Hypoxidaceae','','','','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1289','','','Iris Linnaeus',1,'Iris','Iris','Iris',1,0,'','','Linnaeus','6c0d7739-f246-57d1-bbcf-8cb8176e1d14','Iris Linnaeus','Linnaeus','GENUS','Iris','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6181','','','Iris missouriensis Nuttall',1,'Iris missouriensis','Iris missouriensis','Iris missouriens',2,0,'','','Nuttall','b1ec57e5-2da1-56f5-9896-e096d88c9535','Iris missouriensis Nuttall','Nuttall','SPECIES','','Iris','','missouriensis','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2399','','','Iris ser. Laevigatae (Diels) G.H.M. Lawrence',2,'Laevigatae','Iris ser. Laevigatae','Laevigatae',1,0,'','','Diels|G. H. M. Lawrence','051ea1e8-0e90-59cb-aa42-80c23739dec0','Iris ser. Laevigatae (Diels) G.H.M. Lawrence','(Diels) G.H.M. Lawrence','SERIES','Laevigatae','','','','','','',NULL,'G. H. M. Lawrence','','','','','Diels','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6191','','','Iris ×robusta E.S. Anderson',3,'','','',NULL,NULL,'','','','','Iris ×robusta E.S. Anderson','E.S. Anderson','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2400','','','Iris ser. Sibirica (Diels) G.H.M. Lawrence',2,'Sibirica','Iris ser. Sibirica','Sibirica',1,0,'','','Diels|G. H. M. Lawrence','847ff2d0-7501-52de-9df6-eca7bd955312','Iris ser. Sibirica (Diels) G.H.M. Lawrence','(Diels) G.H.M. Lawrence','SERIES','Sibirica','','','','','','',NULL,'G. H. M. Lawrence','','','','','Diels','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6186','','','Iris setosa Pallas',1,'Iris setosa','Iris setosa','Iris setos',2,0,'','','Pallas','b4badd71-1c6d-5996-b43c-66c32611932a','Iris setosa Pallas','Pallas','SPECIES','','Iris','','setosa','','','',NULL,'','','','','','Pallas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2178','','','Iris sect. Lophiris Tausch',2,'Lophiris','Iris sect. Lophiris','Lophiris',1,0,'','','Tausch','744737d6-9950-55ed-bd85-dc17e1aae3df','Iris sect. Lophiris Tausch','Tausch','SECTION','Lophiris','','','','','','',NULL,'','','','','','Tausch','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2007','','','Iris subg. Iris Linnaeus',2,'Iris','Iris subgen. Iris','Iris',1,0,'','','Linnaeus','b0202046-cd9d-5516-922e-2ad7cdf2f85c','Iris subg. Iris Linnaeus','Linnaeus','SUBGENUS','Iris','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('636','','','Sisyrinchieae',1,'Sisyrinchieae','Sisyrinchieae','Sisyrinchieae',1,0,'','','','980f4c06-deb5-55d3-9fd7-db19a9b187aa','Sisyrinchieae','','TRIBE','Sisyrinchieae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6194','','','Olsynium douglasii (A. Dietrich) E.P. Bicknell',1,'Olsynium douglasii','Olsynium douglasii','Olsynium douglas',2,0,'','','A. Dietrich|E. P. Bicknell','ac05cb86-c34a-5de9-afb4-71d5c4fc9106','Olsynium douglasii (A. Dietrich) E.P. Bicknell','(A. Dietrich) E.P. Bicknell','SPECIES','','Olsynium','','douglasii','','','',NULL,'E. P. Bicknell','','','','','A. Dietrich','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6198','','','Sisyrinchium atlanticum E.P. Bicknell',1,'Sisyrinchium atlanticum','Sisyrinchium atlanticum','Sisyrinchium atlantic',2,0,'','','E. P. Bicknell','52a2b7e8-9829-5671-9740-54dda1832726','Sisyrinchium atlanticum E.P. Bicknell','E.P. Bicknell','SPECIES','','Sisyrinchium','','atlanticum','','','',NULL,'','','','','','E. P. Bicknell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31271','','','Sisyrinchium sect. Hydastylus (Dryander ex Salisbury) Ravenna',2,'Hydastylus','Sisyrinchium sect. Hydastylus','Hydastylus',1,0,'','','Dryander|Salisbury|Ravenna','7f515082-2e9f-5ba3-9e8c-98ee9069dd85','Sisyrinchium sect. Hydastylus (Dryander ex Salisbury) Ravenna','(Dryander ex Salisbury) Ravenna','SECTION','Hydastylus','','','','','','',NULL,'Ravenna','','','','','Dryander','','Salisbury','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6207','','','Sisyrinchium littorale Greene',1,'Sisyrinchium littorale','Sisyrinchium littorale','Sisyrinchium littoral',2,0,'','','Greene','8ef635b8-2484-5d75-9ea2-920d7b07ac25','Sisyrinchium littorale Greene','Greene','SPECIES','','Sisyrinchium','','littorale','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('181','','','Orchidaceae de Jussieu',1,'Orchidaceae','Orchidaceae','Orchidaceae',1,0,'','','de Jussieu','7ff7fb47-d7c6-5083-ab13-31ae141a9b72','Orchidaceae de Jussieu','de Jussieu','FAMILY','Orchidaceae','','','','','','',NULL,'','','','','','de Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6858','','','Cypripedium guttatum Swartz',1,'Cypripedium guttatum','Cypripedium guttatum','Cypripedium guttat',2,0,'','','Swartz','876c0558-4973-5083-a4d3-e03373e457aa','Cypripedium guttatum Swartz','Swartz','SPECIES','','Cypripedium','','guttatum','','','',NULL,'','','','','','Swartz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('495','','','Neottieae',1,'Neottieae','Neottieae','Neottieae',1,0,'','','','a57065f6-be58-5804-8fbb-1ce384fbc573','Neottieae','','TRIBE','Neottieae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('969','','','Cephalanthera Richard',1,'Cephalanthera','Cephalanthera','Cephalanthera',1,0,'','','Richard','ac981e5c-6d6e-5cc7-a2c7-703be2678810','Cephalanthera Richard','Richard','GENUS','Cephalanthera','','','','','','',NULL,'','','','','','Richard','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1141','','','Epipactis Zinn',1,'Epipactis','Epipactis','Epipactis',1,0,'','','Zinn','0d100d96-0ead-5712-9bfa-e027dceded3b','Epipactis Zinn','Zinn','GENUS','Epipactis','','','','','','',NULL,'','','','','','Zinn','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27904','','','Neottia bifolia (Rafinesque) Baumbach',1,'Neottia bifolia','Neottia bifolia','Neottia bifol',2,0,'','','Rafinesque|Baumbach','dcdb6f5a-ab34-5dac-a8bd-67071e01df7e','Neottia bifolia (Rafinesque) Baumbach','(Rafinesque) Baumbach','SPECIES','','Neottia','','bifolia','','','',NULL,'Baumbach','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('612','','','Malaxideae',1,'Malaxideae','Malaxideae','Malaxideae',1,0,'','','','7f47fb1f-d3dd-5594-b3b7-d7b244c5e9dd','Malaxideae','','TRIBE','Malaxideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6879','','','Liparis liliifolia (Linnaeus) Richard ex Lindley',2,'Liparis liliifolia','Liparis liliifolia','Liparis liliifol',2,0,'','','Linnaeus|Richard|Lindley','4a22cf9f-277a-5f1a-ac8a-0dfbec44bc90','Liparis liliifolia (Linnaeus) Richard ex Lindley','(Linnaeus) Richard ex Lindley','SPECIES','','Liparis','','liliifolia','','','',NULL,'Richard','','Lindley','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6894','','','Malaxis monophyllos (Linnaeus) Swartz var. monophyllos',1,'Malaxis monophyllos monophyllos','Malaxis monophyllos var. monophyllos','Malaxis monophyll monophyll',3,0,'','','','9ff4d1c0-1941-55cb-afee-f9b7cc14da1f','Malaxis monophyllos (Linnaeus) Swartz var. monophyllos','(Linnaeus) Swartz','VARIETY','','Malaxis','','monophyllos','monophyllos','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6838','','','Calypso bulbosa var. americana (R. Brown) Luer',1,'Calypso bulbosa americana','Calypso bulbosa var. americana','Calypso bulbos american',3,0,'','','R. Brown|Luer','b310ade9-50f0-5cdb-82f7-a207d40af5ce','Calypso bulbosa var. americana (R. Brown) Luer','(R. Brown) Luer','VARIETY','','Calypso','','bulbosa','americana','','',NULL,'Luer','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6844','','','Corallorhiza maculata (Rafinesque) Rafinesque',1,'Corallorhiza maculata','Corallorhiza maculata','Corallorhiza maculat',2,0,'','','Rafinesque','7624f32a-b2ed-511b-a88d-a3920f53eef5','Corallorhiza maculata (Rafinesque) Rafinesque','(Rafinesque) Rafinesque','SPECIES','','Corallorhiza','','maculata','','','',NULL,'Rafinesque','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6852','','','Corallorhiza striata var. vreelandii (Rydberg) L.O. Williams',1,'Corallorhiza striata vreelandii','Corallorhiza striata var. vreelandii','Corallorhiza striat ureeland',3,0,'','','Rydberg|L. O. Williams','24557330-cd0e-56c6-adfc-1a598ab441f1','Corallorhiza striata var. vreelandii (Rydberg) L.O. Williams','(Rydberg) L.O. Williams','VARIETY','','Corallorhiza','','striata','vreelandii','','',NULL,'L. O. Williams','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('324','','','Orchidoideae',1,'Orchidoideae','Orchidoideae','Orchidoideae',1,0,'','','','f4d004c2-77ac-539f-b22e-877bcc4c6d8e','Orchidoideae','','SUBFAMILY','Orchidoideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30174','','','Dactylorhiza praetermissa (Druce) Soó subsp. praetermissa var. praetermissa',1,'Dactylorhiza praetermissa praetermissa praetermissa','Dactylorhiza praetermissa subsp. praetermissa var. praetermissa','Dactylorhiza praetermiss praetermiss praetermiss',4,0,'','','','b3bc33ab-d696-5218-8544-0adf38a75dbc','Dactylorhiza praetermissa (Druce) Soó subsp. praetermissa var. praetermissa','(Druce) Soó','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6901','','','Platanthera transversa (Suksdorf) R.M. Bateman',1,'Platanthera transversa','Platanthera transversa','Platanthera transuers',2,0,'','','Suksdorf|R. M. Bateman','7e6e682e-763b-5d6d-87b6-42b14750a2ac','Platanthera transversa (Suksdorf) R.M. Bateman','(Suksdorf) R.M. Bateman','SPECIES','','Platanthera','','transversa','','','',NULL,'R. M. Bateman','','','','','Suksdorf','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6907','','','Platanthera ciliaris (Linnaeus) Lindley',1,'Platanthera ciliaris','Platanthera ciliaris','Platanthera ciliar',2,0,'','','Linnaeus|Lindley','4243a1ce-3073-5514-9828-d7c12317dc63','Platanthera ciliaris (Linnaeus) Lindley','(Linnaeus) Lindley','SPECIES','','Platanthera','','ciliaris','','','',NULL,'Lindley','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6926','','','Platanthera praeclara Sheviak & M.L. Bowles',1,'Platanthera praeclara','Platanthera praeclara','Platanthera praeclar',2,0,'','','Sheviak|M. L. Bowles','34eb0f3c-c3e5-54ee-bfcd-90b82b34c130','Platanthera praeclara Sheviak & M.L. Bowles','Sheviak & M.L. Bowles','SPECIES','','Platanthera','','praeclara','','','',NULL,'','','','','','Sheviak & M. L. Bowles','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6931','','','Platanthera grandiflora × Platanthera lacera',2,'Platanthera grandiflora × Platanthera lacera','Platanthera grandiflora × Platanthera lacera','Platanthera grandiflor × Platanthera lacer',0,0,'HYBRID_FORMULA','','','c2d31f44-8ce2-5242-9610-1161d428db6c','Platanthera grandiflora × Platanthera lacera','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6914','','','Platanthera flava (Linnaeus) Lindley',1,'Platanthera flava','Platanthera flava','Platanthera flau',2,0,'','','Linnaeus|Lindley','a1f81cbd-a281-59f1-a2e7-ed6fff102eac','Platanthera flava (Linnaeus) Lindley','(Linnaeus) Lindley','SPECIES','','Platanthera','','flava','','','',NULL,'Lindley','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32473','','','Platanthera shriveri P.M. Brown',1,'Platanthera shriveri','Platanthera shriveri','Platanthera shriuer',2,0,'','','P. M. Brown','ac062fa3-c7fe-5660-bae0-6491bc24be6e','Platanthera shriveri P.M. Brown','P.M. Brown','SPECIES','','Platanthera','','shriveri','','','',NULL,'','','','','','P. M. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6918','','','Platanthera huronensis (Nuttall) Lindley',1,'Platanthera huronensis','Platanthera huronensis','Platanthera huronens',2,0,'','','Nuttall|Lindley','50ea0065-039d-50c0-8828-9708133ff669','Platanthera huronensis (Nuttall) Lindley','(Nuttall) Lindley','SPECIES','','Platanthera','','huronensis','','','',NULL,'Lindley','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6925','','','Platanthera orbiculata (Pursh) Lindley',1,'Platanthera orbiculata','Platanthera orbiculata','Platanthera orbiculat',2,0,'','','Pursh|Lindley','195d1cb0-7b6f-58c5-84cc-2c46eb97da11','Platanthera orbiculata (Pursh) Lindley','(Pursh) Lindley','SPECIES','','Platanthera','','orbiculata','','','',NULL,'Lindley','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6906','','','Platanthera chorisiana (Chamisso) Reichenbach',1,'Platanthera chorisiana','Platanthera chorisiana','Platanthera chorisian',2,0,'','','Chamisso|Reichenbach','dd9fdca7-75fa-5068-b6f3-14c1e9c858b8','Platanthera chorisiana (Chamisso) Reichenbach','(Chamisso) Reichenbach','SPECIES','','Platanthera','','chorisiana','','','',NULL,'Reichenbach','','','','','Chamisso','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6875','','','Goodyera repens (Linnaeus) R. Brown',1,'Goodyera repens','Goodyera repens','Goodyera repens',2,0,'','','Linnaeus|R. Brown','77991e96-520a-50fa-8b6d-fbddefd0fb97','Goodyera repens (Linnaeus) R. Brown','(Linnaeus) R. Brown','SPECIES','','Goodyera','','repens','','','',NULL,'R. Brown','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6945','','','Spiranthes magnicamporum Sheviak',1,'Spiranthes magnicamporum','Spiranthes magnicamporum','Spiranthes magnicampor',2,0,'','','Sheviak','21cac9e2-2d02-5beb-9db6-924a9d047260','Spiranthes magnicamporum Sheviak','Sheviak','SPECIES','','Spiranthes','','magnicamporum','','','',NULL,'','','','','','Sheviak','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6939','','','Spiranthes casei var. novaescotiae Catling',1,'Spiranthes casei novaescotiae','Spiranthes casei var. novaescotiae','Spiranthes case nouaescoti',3,0,'','','Catling','82e4305e-2b76-5a38-a715-d52feb3d011b','Spiranthes casei var. novaescotiae Catling','Catling','VARIETY','','Spiranthes','','casei','novaescotiae','','',NULL,'','','','','','Catling','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6947','','','Spiranthes ovalis var. erostellata Catling',1,'Spiranthes ovalis erostellata','Spiranthes ovalis var. erostellata','Spiranthes oual erostellat',3,0,'','','Catling','98613903-f180-5d0d-bdb9-0aacf2cc695a','Spiranthes ovalis var. erostellata Catling','Catling','VARIETY','','Spiranthes','','ovalis','erostellata','','',NULL,'','','','','','Catling','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1293','','','Isotria Rafinesque',1,'Isotria','Isotria','Isotria',1,0,'','','Rafinesque','c6aaa9ea-ba2b-5ada-a167-83870150971a','Isotria Rafinesque','Rafinesque','GENUS','Isotria','','','','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32754','','','Asphodelaceae de Jussieu nom. cons.',4,'','','',NULL,NULL,'','','','','Asphodelaceae de Jussieu nom. cons.','de Jussieu nom. cons.','FAMILY','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9546','','','Hemerocallis fulva (Linnaeus) Linnaeus',1,'Hemerocallis fulva','Hemerocallis fulva','Hemerocallis fulu',2,0,'','','Linnaeus','2cb6d043-f0f9-55b1-969b-3ad463f00325','Hemerocallis fulva (Linnaeus) Linnaeus','(Linnaeus) Linnaeus','SPECIES','','Hemerocallis','','fulva','','','',NULL,'Linnaeus','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('688','','','Tradescantieae',1,'Tradescantieae','Tradescantieae','Tradescantieae',1,0,'','','','8d2cac27-b609-568c-bed8-d3796981e6d6','Tradescantieae','','TRIBE','Tradescantieae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4601','','','Tradescantia occidentalis (Britton) Smyth var. occidentalis',1,'Tradescantia occidentalis occidentalis','Tradescantia occidentalis var. occidentalis','Tradescantia occidental occidental',3,0,'','','','0f7ec837-4de6-52de-8a44-3e3556db7db0','Tradescantia occidentalis (Britton) Smyth var. occidentalis','(Britton) Smyth','VARIETY','','Tradescantia','','occidentalis','occidentalis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1244','','','Heteranthera Ruiz & Pavon',1,'Heteranthera','Heteranthera','Heteranthera',1,0,'','','Ruiz|Pavon','0a84b9f2-8eea-5bff-a735-13d68a8b524e','Heteranthera Ruiz & Pavon','Ruiz & Pavon','GENUS','Heteranthera','','','','','','',NULL,'','','','','','Ruiz & Pavon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5353','','','Dioscorea villosa Linnaeus',1,'Dioscorea villosa','Dioscorea villosa','Dioscorea uillos',2,0,'','','Linnaeus','847df9fd-49e3-5a62-ab52-c0d6c4742cc6','Dioscorea villosa Linnaeus','Linnaeus','SPECIES','','Dioscorea','','villosa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9398','','','Aletris farinosa Linnaeus',1,'Aletris farinosa','Aletris farinosa','Aletris farinos',2,0,'','','Linnaeus','1949ad4d-4b91-5b09-9bef-9d67dcb3e6af','Aletris farinosa Linnaeus','Linnaeus','SPECIES','','Aletris','','farinosa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('376','','','Uvularioideae',1,'Uvularioideae','Uvularioideae','Uvularioideae',1,0,'','','','80a931d3-e1fb-5aaf-933c-c738344c9a97','Uvularioideae','','SUBFAMILY','Uvularioideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4598','','','Uvularia perfoliata Linnaeus',1,'Uvularia perfoliata','Uvularia perfoliata','Uvularia perfoliat',2,0,'','','Linnaeus','b176c17c-d867-5561-8fca-974cc76afa92','Uvularia perfoliata Linnaeus','Linnaeus','SPECIES','','Uvularia','','perfoliata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4149','','','Calochortus apiculatus Baker',1,'Calochortus apiculatus','Calochortus apiculatus','Calochortus apiculat',2,0,'','','Baker','935b3749-739a-546c-b1ec-8b0aef6527c1','Calochortus apiculatus Baker','Baker','SPECIES','','Calochortus','','apiculatus','','','',NULL,'','','','','','Baker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4152','','','Calochortus macrocarpus Douglas',1,'Calochortus macrocarpus','Calochortus macrocarpus','Calochortus macrocarp',2,0,'','','Douglas','4b0d831f-4575-5c43-a5a2-48639a072c00','Calochortus macrocarpus Douglas','Douglas','SPECIES','','Calochortus','','macrocarpus','','','',NULL,'','','','','','Douglas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6522','','','Erythronium revolutum Smith',1,'Erythronium revolutum','Erythronium revolutum','Erythronium reuolut',2,0,'','','Smith','4dbd310e-5d86-5ae0-9dc6-3e717022f9de','Erythronium revolutum Smith','Smith','SPECIES','','Erythronium','','revolutum','','','',NULL,'','','','','','Smith','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1797','','','Tulipa Linnaeus',1,'Tulipa','Tulipa','Tulipa',1,0,'','','Linnaeus','cb342621-3b08-5c84-a965-49f192af766c','Tulipa Linnaeus','Linnaeus','GENUS','Tulipa','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32925','','','Gagea serotina (Linnaeus) Ker Gawler',1,'Gagea serotina','Gagea serotina','Gagea serotin',2,0,'','','Linnaeus|Ker Gawler','3d6269f7-9308-516e-b07e-0c0fd21536d0','Gagea serotina (Linnaeus) Ker Gawler','(Linnaeus) Ker Gawler','SPECIES','','Gagea','','serotina','','','',NULL,'Ker Gawler','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6524','','','Fritillaria affinis (Schultes & Schultes) Sealy',1,'Fritillaria affinis','Fritillaria affinis','Fritillaria affin',2,0,'','','Schultes|Sealy','e677f7ab-4efd-5999-87b9-9dd355f4362f','Fritillaria affinis (Schultes & Schultes) Sealy','(Schultes & Schultes) Sealy','SPECIES','','Fritillaria','','affinis','','','',NULL,'Sealy','','','','','Schultes & Schultes','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6534','','','Lilium philadelphicum Linnaeus',1,'Lilium philadelphicum','Lilium philadelphicum','Lilium philadelphic',2,0,'','','Linnaeus','645173dc-d943-5792-ad88-1a79e32d56be','Lilium philadelphicum Linnaeus','Linnaeus','SPECIES','','Lilium','','philadelphicum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6514','','','Clintonia uniflora (Menzies ex Schultes) Kunth',2,'Clintonia uniflora','Clintonia uniflora','Clintonia uniflor',2,0,'','','Menzies|Schultes|Kunth','2162f98c-38e7-5f28-b2dc-a2a22e1829d7','Clintonia uniflora (Menzies ex Schultes) Kunth','(Menzies ex Schultes) Kunth','SPECIES','','Clintonia','','uniflora','','','',NULL,'Kunth','','','','','Menzies','','Schultes','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4153','','','Prosartes hookeri Torrey',1,'Prosartes hookeri','Prosartes hookeri','Prosartes hooker',2,0,'','','Torrey','61bd2ab4-a02e-5e9c-beb6-1dbf9fb3866f','Prosartes hookeri Torrey','Torrey','SPECIES','','Prosartes','','hookeri','','','',NULL,'','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4156','','','Prosartes trachycarpa S. Watson',1,'Prosartes trachycarpa','Prosartes trachycarpa','Prosartes trachycarp',2,0,'','','S. Watson','6e428691-d69f-58c4-9f05-59b0771c7c6d','Prosartes trachycarpa S. Watson','S. Watson','SPECIES','','Prosartes','','trachycarpa','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4592','','','Streptopus lanceolatus (Aiton) Reveal',1,'Streptopus lanceolatus','Streptopus lanceolatus','Streptopus lanceolat',2,0,'','','Aiton|Reveal','ed02f5a6-4305-59a5-8b1c-212e67a7526b','Streptopus lanceolatus (Aiton) Reveal','(Aiton) Reveal','SPECIES','','Streptopus','','lanceolatus','','','',NULL,'Reveal','','','','','Aiton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4595','','','Streptopus streptopoides (Ledebour) Frye & Rigg',1,'Streptopus streptopoides','Streptopus streptopoides','Streptopus streptopoid',2,0,'','','Ledebour|Frye|Rigg','d6bbc384-df4d-5638-b797-913b5eb0fbaf','Streptopus streptopoides (Ledebour) Frye & Rigg','(Ledebour) Frye & Rigg','SPECIES','','Streptopus','','streptopoides','','','',NULL,'Frye & Rigg','','','','','Ledebour','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('166','','','Melanthiaceae Batsch',1,'Melanthiaceae','Melanthiaceae','Melanthiaceae',1,0,'','','Batsch','f1fbf5f4-1393-523b-9779-6fa559d93ae6','Melanthiaceae Batsch','Batsch','FAMILY','Melanthiaceae','','','','','','',NULL,'','','','','','Batsch','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6657','','','Trillium flexipes Rafinesque',1,'Trillium flexipes','Trillium flexipes','Trillium flexip',2,0,'','','Rafinesque','bfc0d748-5ac2-55f4-8228-df8c88886ad7','Trillium flexipes Rafinesque','Rafinesque','SPECIES','','Trillium','','flexipes','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32302','','','Trillium hibbersonii (T.M.C. Taylor & Szczawinski) D. O''Neill & S.B. Farmer',1,'Trillium hibbersonii','Trillium hibbersonii','Trillium hibberson',2,0,'','','T. M. C. Taylor|Szczawinski|D. O''Neill|S. B. Farmer','f43ddbd5-a27a-5033-af7d-8e560d6db072','Trillium hibbersonii (T.M.C. Taylor & Szczawinski) D. O''Neill & S.B. Farmer','(T.M.C. Taylor & Szczawinski) D. O''Neill & S.B. Farmer','SPECIES','','Trillium','','hibbersonii','','','',NULL,'D. O''Neill & S. B. Farmer','','','','','T. M. C. Taylor & Szczawinski','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31537','','','Chionographideae Nakai',1,'Chionographideae','Chionographideae','Chionographideae',1,0,'','','Nakai','e4ce3245-e4b1-529a-8aca-88dcd9289ab3','Chionographideae Nakai','Nakai','TRIBE','Chionographideae','','','','','','',NULL,'','','','','','Nakai','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1812','','','Veratrum Linnaeus',1,'Veratrum','Veratrum','Veratrum',1,0,'','','Linnaeus','5ab0c444-d9c6-5f9c-a221-7ff985804815','Veratrum Linnaeus','Linnaeus','GENUS','Veratrum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6665','','','Veratrum viride Aiton',1,'Veratrum viride','Veratrum viride','Veratrum uirid',2,0,'','','Aiton','422f89f8-7e2a-5389-9baf-215a0eda1a2a','Veratrum viride Aiton','Aiton','SPECIES','','Veratrum','','viride','','','',NULL,'','','','','','Aiton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6653','','','Toxicoscordion venenosum (S. Watson) Rydberg',1,'Toxicoscordion venenosum','Toxicoscordion venenosum','Toxicoscordion uenenos',2,0,'','','S. Watson|Rydberg','ee66914b-97bc-59b4-a179-c2aed9d80c51','Toxicoscordion venenosum (S. Watson) Rydberg','(S. Watson) Rydberg','SPECIES','','Toxicoscordion','','venenosum','','','',NULL,'Rydberg','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('222','','','Smilacaceae Ventenat',1,'Smilacaceae','Smilacaceae','Smilacaceae',1,0,'','','Ventenat','5f42a84d-9c22-5b67-9cf0-4755df2d689a','Smilacaceae Ventenat','Ventenat','FAMILY','Smilacaceae','','','','','','',NULL,'','','','','','Ventenat','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9343','','','Smilax herbacea Linnaeus',1,'Smilax herbacea','Smilax herbacea','Smilax herbace',2,0,'','','Linnaeus','0f0282cc-7ef8-5ac7-b4b2-feb29baec67f','Smilax herbacea Linnaeus','Linnaeus','SPECIES','','Smilax','','herbacea','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('120','','','Cyperaceae de Jussieu',1,'Cyperaceae','Cyperaceae','Cyperaceae',1,0,'','','de Jussieu','bec84de4-0b25-580b-b7d6-14ad9324b6c9','Cyperaceae de Jussieu','de Jussieu','FAMILY','Cyperaceae','','','','','','',NULL,'','','','','','de Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('476','','','Abildgaardieae Lye',1,'Abildgaardieae','Abildgaardieae','Abildgaardieae',1,0,'','','Lye','adac1a91-1545-55e1-ba16-4d9fcc4f2f9b','Abildgaardieae Lye','Lye','TRIBE','Abildgaardieae','','','','','','',NULL,'','','','','','Lye','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5291','','','Fimbristylis puberula (Michaux) Vahl',1,'Fimbristylis puberula','Fimbristylis puberula','Fimbristylis puberul',2,0,'','','Michaux|Vahl','bbde0196-692f-50d7-abbc-3b0f9a08275a','Fimbristylis puberula (Michaux) Vahl','(Michaux) Vahl','SPECIES','','Fimbristylis','','puberula','','','',NULL,'Vahl','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('528','','','Cypereae Dumortier',1,'Cypereae','Cypereae','Cypereae',1,0,'','','Dumortier','528c3035-5597-538a-b000-d3939974b631','Cypereae Dumortier','Dumortier','TRIBE','Cypereae','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32304','','','Cyperus odoratus var. squarrosus (Britton) Gilly',1,'Cyperus odoratus squarrosus','Cyperus odoratus var. squarrosus','Cyperus odorat squarros',3,0,'','','Britton|Gilly','512d30e2-ff07-5e70-b9ee-5fdde712049d','Cyperus odoratus var. squarrosus (Britton) Gilly','(Britton) Gilly','VARIETY','','Cyperus','','odoratus','squarrosus','','',NULL,'Gilly','','','','','Britton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5219','','','Cyperus schweinitzii Torrey',1,'Cyperus schweinitzii','Cyperus schweinitzii','Cyperus schweinitz',2,0,'','','Torrey','01204488-6d76-5b0e-8855-d8deef29e72e','Cyperus schweinitzii Torrey','Torrey','SPECIES','','Cyperus','','schweinitzii','','','',NULL,'','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5220','','','Cyperus squarrosus Linnaeus',1,'Cyperus squarrosus','Cyperus squarrosus','Cyperus squarros',2,0,'','','Linnaeus','95d5e331-da59-5c0e-87f1-45b5fecf4ad8','Cyperus squarrosus Linnaeus','Linnaeus','SPECIES','','Cyperus','','squarrosus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5216','','','Cyperus lupulinus (Sprengel) Marcks',1,'Cyperus lupulinus','Cyperus lupulinus','Cyperus lupulin',2,0,'','','Sprengel|Marcks','e1ddb0ee-53d4-5bd8-be77-1c4fe4f7064e','Cyperus lupulinus (Sprengel) Marcks','(Sprengel) Marcks','SPECIES','','Cyperus','','lupulinus','','','',NULL,'Marcks','','','','','Sprengel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5206','','','Cyperus dentatus Torrey',1,'Cyperus dentatus','Cyperus dentatus','Cyperus dentat',2,0,'','','Torrey','4d96a641-7e33-52f0-ac9e-34317c3eff91','Cyperus dentatus Torrey','Torrey','SPECIES','','Cyperus','','dentatus','','','',NULL,'','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5213','','','Cyperus fuscus Linnaeus',1,'Cyperus fuscus','Cyperus fuscus','Cyperus fusc',2,0,'','','Linnaeus','2ee19443-ccb3-5c97-a853-1039d197bc27','Cyperus fuscus Linnaeus','Linnaeus','SPECIES','','Cyperus','','fuscus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5207','','','Cyperus diandrus Torrey',1,'Cyperus diandrus','Cyperus diandrus','Cyperus diandr',2,0,'','','Torrey','925e9d19-b4a5-5f62-bc77-5c4a34671cfa','Cyperus diandrus Torrey','Torrey','SPECIES','','Cyperus','','diandrus','','','',NULL,'','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33970','','','Cyperus difformis Linnaeus',1,'Cyperus difformis','Cyperus difformis','Cyperus difform',2,0,'','','Linnaeus','01ab94a4-9fbf-5b49-a78a-3ae1ab3498fb','Cyperus difformis Linnaeus','Linnaeus','SPECIES','','Cyperus','','difformis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('900','','','Blysmopsis Oteng-Yeboah',1,'Blysmopsis','Blysmopsis','Blysmopsis',1,0,'','','Oteng-Yeboah','bcda9dcf-440a-5e9e-bde0-f971e4d6d529','Blysmopsis Oteng-Yeboah','Oteng-Yeboah','GENUS','Blysmopsis','','','','','','',NULL,'','','','','','Oteng-Yeboah','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5224','','','Dulichium arundinaceum (Linnaeus) Britton',1,'Dulichium arundinaceum','Dulichium arundinaceum','Dulichium arundinace',2,0,'','','Linnaeus|Britton','59bca0f2-d36b-53b2-a929-6c5785bac3cb','Dulichium arundinaceum (Linnaeus) Britton','(Linnaeus) Britton','SPECIES','','Dulichium','','arundinaceum','','','',NULL,'Britton','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1997','','','Eleocharis subg. Eleocharis',2,'Eleocharis','Eleocharis subgen. Eleocharis','Eleocharis',1,0,'','','','1c7ce8d5-f33b-5bda-91f3-9d163097e545','Eleocharis subg. Eleocharis','','SUBGENUS','Eleocharis','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2157','','','Eleocharis sect. Eleocharis',2,'Eleocharis','Eleocharis sect. Eleocharis','Eleocharis',1,0,'','','','38200cae-494a-5963-949e-5d8bf5e81bd1','Eleocharis sect. Eleocharis','','SECTION','Eleocharis','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5228','','','Eleocharis ambigens Fernald',1,'Eleocharis ambigens','Eleocharis ambigens','Eleocharis ambigens',2,0,'','','Fernald','dc6c3c34-33d3-5a06-bb7a-0bebd05b78ae','Eleocharis ambigens Fernald','Fernald','SPECIES','','Eleocharis','','ambigens','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5238','','','Eleocharis erythropoda Steudel',1,'Eleocharis erythropoda','Eleocharis erythropoda','Eleocharis erythropod',2,0,'','','Steudel','30c7bee8-fe1c-57de-8f93-bff15e0f80ab','Eleocharis erythropoda Steudel','Steudel','SPECIES','','Eleocharis','','erythropoda','','','',NULL,'','','','','','Steudel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5246','','','Eleocharis mamillata (H. Lindberg) H. Lindberg subsp. mamillata',1,'Eleocharis mamillata mamillata','Eleocharis mamillata subsp. mamillata','Eleocharis mamillat mamillat',3,0,'','','','8a8546e5-1028-5bd2-9784-29ab502bc833','Eleocharis mamillata (H. Lindberg) H. Lindberg subsp. mamillata','(H. Lindberg) H. Lindberg','SUBSPECIES','','Eleocharis','','mamillata','mamillata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2395','','','Eleocharis ser. Rostellatae S. Gonzalez & P.M. Peterson',2,'Rostellatae','Eleocharis ser. Rostellatae','Rostellatae',1,0,'','','S. Gonzalez|P. M. Peterson','13cd5205-d1bf-5368-8ea6-713759b05f30','Eleocharis ser. Rostellatae S. Gonzalez & P.M. Peterson','S. Gonzalez & P.M. Peterson','SERIES','Rostellatae','','','','','','',NULL,'','','','','','S. Gonzalez & P. M. Peterson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2393','','','Eleocharis ser. Maculosae Svenson',2,'Maculosae','Eleocharis ser. Maculosae','Maculosae',1,0,'','','Svenson','7638b95e-1db9-509d-a90d-689907af46c7','Eleocharis ser. Maculosae Svenson','Svenson','SERIES','Maculosae','','','','','','',NULL,'','','','','','Svenson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5240','','','Eleocharis flavescens var. olivacea (Torrey) Gleason',1,'Eleocharis flavescens olivacea','Eleocharis flavescens var. olivacea','Eleocharis flauescens oliuace',3,0,'','','Torrey|Gleason','e95346bd-a6a2-52b5-8c0b-34eb8e24a173','Eleocharis flavescens var. olivacea (Torrey) Gleason','(Torrey) Gleason','VARIETY','','Eleocharis','','flavescens','olivacea','','',NULL,'Gleason','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5227','','','Eleocharis aestuum Hines ex A. Haines',2,'Eleocharis aestuum','Eleocharis aestuum','Eleocharis aestu',2,0,'','','Hines|A. Haines','75f5afea-169f-5cbe-a022-08b2ae955993','Eleocharis aestuum Hines ex A. Haines','Hines ex A. Haines','SPECIES','','Eleocharis','','aestuum','','','',NULL,'','','','','','Hines','','A. Haines','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5264','','','Eleocharis ×macounii Fernald',3,'','','',NULL,NULL,'','','','','Eleocharis ×macounii Fernald','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5255','','','Eleocharis robbinsii Oakes',1,'Eleocharis robbinsii','Eleocharis robbinsii','Eleocharis robbins',2,0,'','','Oakes','b57f2454-c146-506c-8995-b13d466e0e56','Eleocharis robbinsii Oakes','Oakes','SPECIES','','Eleocharis','','robbinsii','','','',NULL,'','','','','','Oakes','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5226','','','Eleocharis acicularis (Linnaeus) Roemer & Schultes',1,'Eleocharis acicularis','Eleocharis acicularis','Eleocharis acicular',2,0,'','','Linnaeus|Roemer|Schultes','d073e72b-47c6-5389-ab11-0f6b8c8f1d16','Eleocharis acicularis (Linnaeus) Roemer & Schultes','(Linnaeus) Roemer & Schultes','SPECIES','','Eleocharis','','acicularis','','','',NULL,'Roemer & Schultes','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('466','','','Fuireneae Reichenbach ex Fenzl',2,'Fuireneae','Fuireneae','Fuireneae',1,0,'','','Reichenbach|Fenzl','c50d9e44-3d51-51fe-be70-a1d60c626381','Fuireneae Reichenbach ex Fenzl','Reichenbach ex Fenzl','TRIBE','Fuireneae','','','','','','',NULL,'','','','','','Reichenbach','','Fenzl','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('814','','','Amphiscirpus Oteng-Yeboah',1,'Amphiscirpus','Amphiscirpus','Amphiscirpus',1,0,'','','Oteng-Yeboah','f8d2a48a-f9af-5310-a199-e6e0c300bcc4','Amphiscirpus Oteng-Yeboah','Oteng-Yeboah','GENUS','Amphiscirpus','','','','','','',NULL,'','','','','','Oteng-Yeboah','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1152','','','Eriophorum Linnaeus',1,'Eriophorum','Eriophorum','Eriophorum',1,0,'','','Linnaeus','fee6ad07-4ad3-5f62-be39-e7fd0bc4c03d','Eriophorum Linnaeus','Linnaeus','GENUS','Eriophorum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2001','','','Eriophorum subg. Eriophorum Linnaeus',2,'Eriophorum','Eriophorum subgen. Eriophorum','Eriophorum',1,0,'','','Linnaeus','2aa9f9a8-659a-50b5-9901-b6d38cc19b58','Eriophorum subg. Eriophorum Linnaeus','Linnaeus','SUBGENUS','Eriophorum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5270','','','Eriophorum chamissonis C.A. Meyer',1,'Eriophorum chamissonis','Eriophorum chamissonis','Eriophorum chamisson',2,0,'','','C. A. Meyer','c1ff11f6-3ba4-56f9-a4f5-63f51cabe9f7','Eriophorum chamissonis C.A. Meyer','C.A. Meyer','SPECIES','','Eriophorum','','chamissonis','','','',NULL,'','','','','','C. A. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5281','','','Eriophorum vaginatum Linnaeus',1,'Eriophorum vaginatum','Eriophorum vaginatum','Eriophorum uaginat',2,0,'','','Linnaeus','7793996f-3c83-564c-82f5-c1ef8b598d35','Eriophorum vaginatum Linnaeus','Linnaeus','SPECIES','','Eriophorum','','vaginatum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9838','','','Eriophorum vaginatum Linnaeus subsp. vaginatum',1,'Eriophorum vaginatum vaginatum','Eriophorum vaginatum subsp. vaginatum','Eriophorum uaginat uaginat',3,0,'','','','b595f295-d5aa-5886-9624-0455accd1c33','Eriophorum vaginatum Linnaeus subsp. vaginatum','Linnaeus','SUBSPECIES','','Eriophorum','','vaginatum','vaginatum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2002','','','Eriophorum subg. Erioscirpus (Palla) Raymond',2,'Erioscirpus','Eriophorum subgen. Erioscirpus','Erioscirpus',1,0,'','','Palla|Raymond','130d561d-6775-5fe3-9762-127a4aac05d9','Eriophorum subg. Erioscirpus (Palla) Raymond','(Palla) Raymond','SUBGENUS','Erioscirpus','','','','','','',NULL,'Raymond','','','','','Palla','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5326','','','Scirpus atrocinctus Fernald',1,'Scirpus atrocinctus','Scirpus atrocinctus','Scirpus atrocinct',2,0,'','','Fernald','e6f5af5c-30bc-5a83-a206-7c80fcd198b0','Scirpus atrocinctus Fernald','Fernald','SPECIES','','Scirpus','','atrocinctus','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5329','','','Scirpus expansus Fernald',1,'Scirpus expansus','Scirpus expansus','Scirpus expans',2,0,'','','Fernald','0d49bc0f-d70b-5bee-be67-cd0bf3576964','Scirpus expansus Fernald','Fernald','SPECIES','','Scirpus','','expansus','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5334','','','Scirpus pallidus (Britton) Fernald',1,'Scirpus pallidus','Scirpus pallidus','Scirpus pallid',2,0,'','','Britton|Fernald','3e3f999d-2400-57b9-bcb0-a4124bd1f98b','Scirpus pallidus (Britton) Fernald','(Britton) Fernald','SPECIES','','Scirpus','','pallidus','','','',NULL,'Fernald','','','','','Britton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4715','','','Bolboschoenus fluviatilis (Torrey) Soják',1,'Bolboschoenus fluviatilis','Bolboschoenus fluviatilis','Bolboschoenus fluuiatil',2,0,'','','Torrey|Soják','2de60e56-5b5c-5b5e-997a-96b2142f723c','Bolboschoenus fluviatilis (Torrey) Soják','(Torrey) Soják','SPECIES','','Bolboschoenus','','fluviatilis','','','',NULL,'Soják','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31391','','','Bolboschoenus maritimus × Bolboschoenus robustus',2,'Bolboschoenus maritimus × Bolboschoenus robustus','Bolboschoenus maritimus × Bolboschoenus robustus','Bolboschoenus maritim × Bolboschoenus robust',0,0,'HYBRID_FORMULA','','','d129bd6c-d969-59e0-9796-e1e17be4ded9','Bolboschoenus maritimus × Bolboschoenus robustus','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5339','','','Scleria pauciflora Muhlenberg ex Willdenow',2,'Scleria pauciflora','Scleria pauciflora','Scleria pauciflor',2,0,'','','Muhlenberg|Willdenow','54d1f08d-af27-5fe7-a97a-4b2d38a8fd06','Scleria pauciflora Muhlenberg ex Willdenow','Muhlenberg ex Willdenow','SPECIES','','Scleria','','pauciflora','','','',NULL,'','','','','','Muhlenberg','','Willdenow','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27884','','','Schoenoplectiella mucronata (Linnaeus) J. Jung & H.K. Choi',1,'Schoenoplectiella mucronata','Schoenoplectiella mucronata','Schoenoplectiella mucronat',2,0,'','','Linnaeus|J. Jung|H. K. Choi','b0373734-3dad-5386-9e55-83ce0108b14a','Schoenoplectiella mucronata (Linnaeus) J. Jung & H.K. Choi','(Linnaeus) J. Jung & H.K. Choi','SPECIES','','Schoenoplectiella','','mucronata','','','',NULL,'J. Jung & H. K. Choi','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27891','','','Schoenoplectiella smithii (A. Gray) Hayasaka var. smithii',1,'Schoenoplectiella smithii smithii','Schoenoplectiella smithii var. smithii','Schoenoplectiella smith smith',3,0,'','','','0764a668-1dab-5859-a55d-08b0a7b5ebcc','Schoenoplectiella smithii (A. Gray) Hayasaka var. smithii','(A. Gray) Hayasaka','VARIETY','','Schoenoplectiella','','smithii','smithii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2159','','','Schoenoplectus sect. Schoenoplectus',2,'Schoenoplectus','Schoenoplectus sect. Schoenoplectus','Schoenoplectus',1,0,'','','','b60e35bd-5b10-5803-842f-7ae7eda549c1','Schoenoplectus sect. Schoenoplectus','','SECTION','Schoenoplectus','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5305','','','Schoenoplectus acutus (Muhlenberg ex Bigelow) Á. Löve & D. Löve',2,'Schoenoplectus acutus','Schoenoplectus acutus','Schoenoplectus acut',2,0,'','','Muhlenberg|Bigelow|Á. Löve|D. Löve','cd684d44-011c-53e3-bac2-f1a7541567c2','Schoenoplectus acutus (Muhlenberg ex Bigelow) Á. Löve & D. Löve','(Muhlenberg ex Bigelow) Á. Löve & D. Löve','SPECIES','','Schoenoplectus','','acutus','','','',NULL,'Á. Löve & D. Löve','','','','','Muhlenberg','','Bigelow','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5310','','','Schoenoplectus pungens var. badius (J. Presl & C. Presl) S.G. Smith',1,'Schoenoplectus pungens badius','Schoenoplectus pungens var. badius','Schoenoplectus pungens bad',3,0,'','','J. Presl|C. Presl|S. G. Smith','1ef0079c-f51b-515d-864b-b67b83fda319','Schoenoplectus pungens var. badius (J. Presl & C. Presl) S.G. Smith','(J. Presl & C. Presl) S.G. Smith','VARIETY','','Schoenoplectus','','pungens','badius','','',NULL,'S. G. Smith','','','','','J. Presl & C. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29072','','','Schoenoplectus triquetrer (Linnaeus) Palla',1,'Schoenoplectus triquetrer','Schoenoplectus triquetrer','Schoenoplectus triquetrer',2,0,'','','Linnaeus|Palla','d4a2ec65-b2f0-5398-8ef0-775a6f64569c','Schoenoplectus triquetrer (Linnaeus) Palla','(Linnaeus) Palla','SPECIES','','Schoenoplectus','','triquetrer','','','',NULL,'Palla','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5344','','','Trichophorum clintonii (A. Gray) S.G. Smith',1,'Trichophorum clintonii','Trichophorum clintonii','Trichophorum clinton',2,0,'','','A. Gray|S. G. Smith','e0390c07-288b-5fdd-877f-9266bac5af84','Trichophorum clintonii (A. Gray) S.G. Smith','(A. Gray) S.G. Smith','SPECIES','','Trichophorum','','clintonii','','','',NULL,'S. G. Smith','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2099','','','Carex sect. Acrocystis Dumortier',2,'Acrocystis','Carex sect. Acrocystis','Acrocystis',1,0,'','','Dumortier','3d12455f-2a32-5253-a369-9b21c1b69aff','Carex sect. Acrocystis Dumortier','Dumortier','SECTION','Acrocystis','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4813','','','Carex communis L.H. Bailey var. communis',1,'Carex communis communis','Carex communis var. communis','Carex commun commun',3,0,'','','','c9477619-5bd1-5d21-9bff-66b1a55046cb','Carex communis L.H. Bailey var. communis','L.H. Bailey','VARIETY','','Carex','','communis','communis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4916','','','Carex inops L.H. Bailey subsp. inops',1,'Carex inops inops','Carex inops subsp. inops','Carex inops inops',3,0,'','','','94ef685e-b86a-5260-a740-6aec9cbc6380','Carex inops L.H. Bailey subsp. inops','L.H. Bailey','SUBSPECIES','','Carex','','inops','inops','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5058','','','Carex rossii Boott',1,'Carex rossii','Carex rossii','Carex ross',2,0,'','','Boott','72fab8d3-e79b-5fac-b482-0e18be5979e2','Carex rossii Boott','Boott','SPECIES','','Carex','','rossii','','','',NULL,'','','','','','Boott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5119','','','Carex tonsa (Fernald) E.P. Bicknell var. tonsa',1,'Carex tonsa tonsa','Carex tonsa var. tonsa','Carex tons tons',3,0,'','','','3630867f-ac4b-5cd6-a740-cbf4d16d1513','Carex tonsa (Fernald) E.P. Bicknell var. tonsa','(Fernald) E.P. Bicknell','VARIETY','','Carex','','tonsa','tonsa','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2154','','','Carex sect. Ammoglochin Dumortier',2,'Ammoglochin','Carex sect. Ammoglochin','Ammoglochin',1,0,'','','Dumortier','261f34ca-18d4-52f6-9de3-6b5cd09c4609','Carex sect. Ammoglochin Dumortier','Dumortier','SECTION','Ammoglochin','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4736','','','Carex amplifolia Boott',1,'Carex amplifolia','Carex amplifolia','Carex amplifol',2,0,'','','Boott','26f404d0-348a-5a80-9c00-7ba59bfd676a','Carex amplifolia Boott','Boott','SPECIES','','Carex','','amplifolia','','','',NULL,'','','','','','Boott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2111','','','Carex sect. Aulocystis Dumortier',2,'Aulocystis','Carex sect. Aulocystis','Aulocystis',1,0,'','','Dumortier','102906c8-e304-5cf7-a8d2-1d607bc08df7','Carex sect. Aulocystis Dumortier','Dumortier','SECTION','Aulocystis','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5032','','','Carex petricosa Dewey var. petricosa',1,'Carex petricosa petricosa','Carex petricosa var. petricosa','Carex petricos petricos',3,0,'','','','017f6bd6-e413-559e-a12a-be8189ee0677','Carex petricosa Dewey var. petricosa','Dewey','VARIETY','','Carex','','petricosa','petricosa','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4804','','','Carex capitata Linnaeus',1,'Carex capitata','Carex capitata','Carex capitat',2,0,'','','Linnaeus','29f0808a-6fd3-517b-ba6f-9ec334aaff22','Carex capitata Linnaeus','Linnaeus','SPECIES','','Carex','','capitata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4901','','','Carex hirta Linnaeus',1,'Carex hirta','Carex hirta','Carex hirt',2,0,'','','Linnaeus','e42359a5-0fbb-56f0-85d8-a019104ac5a0','Carex hirta Linnaeus','Linnaeus','SPECIES','','Carex','','hirta','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2119','','','Carex sect. Careyanae',2,'Careyanae','Carex sect. Careyanae','Careyanae',1,0,'','','','6646be96-8f62-5321-9335-9bc70981e2d8','Carex sect. Careyanae','','SECTION','Careyanae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4935','','','Carex laxiculmis var. copulata (L.H. Bailey) Fernald',1,'Carex laxiculmis copulata','Carex laxiculmis var. copulata','Carex laxiculm copulat',3,0,'','','L. H. Bailey|Fernald','a0211436-edbd-56a3-9657-5fcd4e5f5f66','Carex laxiculmis var. copulata (L.H. Bailey) Fernald','(L.H. Bailey) Fernald','VARIETY','','Carex','','laxiculmis','copulata','','',NULL,'Fernald','','','','','L. H. Bailey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2124','','','Carex sect. Ceratocystis Dumortier',2,'Ceratocystis','Carex sect. Ceratocystis','Ceratocystis',1,0,'','','Dumortier','7ddb276a-1877-56e2-9506-dbf2c9b6f98b','Carex sect. Ceratocystis Dumortier','Dumortier','SECTION','Ceratocystis','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4868','','','Carex flava Linnaeus',1,'Carex flava','Carex flava','Carex flau',2,0,'','','Linnaeus','ac4cdd07-941b-519f-975b-6c38b2798f3e','Carex flava Linnaeus','Linnaeus','SPECIES','','Carex','','flava','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5144','','','Carex viridula Michaux subsp. viridula',1,'Carex viridula viridula','Carex viridula subsp. viridula','Carex uiridul uiridul',3,0,'','','','1f7488b7-1455-5375-8386-f9db160c7e48','Carex viridula Michaux subsp. viridula','Michaux','SUBSPECIES','','Carex','','viridula','viridula','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4803','','','Carex capillaris Linnaeus',1,'Carex capillaris','Carex capillaris','Carex capillar',2,0,'','','Linnaeus','eab8e826-2381-5f25-bb15-ce8ca327bcda','Carex capillaris Linnaeus','Linnaeus','SPECIES','','Carex','','capillaris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2121','','','Carex sect. Chordorrhizae (Heuffel) Meinshausen',2,'Chordorrhizae','Carex sect. Chordorrhizae','Chordorrhizae',1,0,'','','Heuffel|Meinshausen','4642e60b-cf73-51d3-bc56-4e4eef2c5953','Carex sect. Chordorrhizae (Heuffel) Meinshausen','(Heuffel) Meinshausen','SECTION','Chordorrhizae','','','','','','',NULL,'Meinshausen','','','','','Heuffel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4811','','','Carex chordorrhiza Linnaeus f.',1,'Carex chordorrhiza','Carex chordorrhiza','Carex chordorrhiz',2,0,'','','Linnaeus fil.','3dda6a7d-8e69-5eb2-9af5-5f9110c7dfae','Carex chordorrhiza Linnaeus f.','Linnaeus f.','SPECIES','','Carex','','chordorrhiza','','','',NULL,'','','','','','Linnaeus fil.','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4812','','','Carex circinata C.A. Meyer',1,'Carex circinata','Carex circinata','Carex circinat',2,0,'','','C. A. Meyer','e5785e15-ab2a-5ad2-9d41-f428b103412b','Carex circinata C.A. Meyer','C.A. Meyer','SPECIES','','Carex','','circinata','','','',NULL,'','','','','','C. A. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5056','','','Carex richardsonii R. Brown',1,'Carex richardsonii','Carex richardsonii','Carex richardson',2,0,'','','R. Brown','fc8621ea-3d60-57e2-bdff-a5f5c4e06d69','Carex richardsonii R. Brown','R. Brown','SPECIES','','Carex','','richardsonii','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4838','','','Carex deweyana var. collectanea Fernald',1,'Carex deweyana collectanea','Carex deweyana var. collectanea','Carex deweyan collectane',3,0,'','','Fernald','d0afabb9-c0e6-5199-822b-f4e8823f8242','Carex deweyana var. collectanea Fernald','Fernald','VARIETY','','Carex','','deweyana','collectanea','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9630','','','Carex infirminervia Naczi',1,'Carex infirminervia','Carex infirminervia','Carex infirmineru',2,0,'','','Naczi','107e86d7-df70-5c76-b6ad-a65c9794a641','Carex infirminervia Naczi','Naczi','SPECIES','','Carex','','infirminervia','','','',NULL,'','','','','','Naczi','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4848','','','Carex douglasii Boott',1,'Carex douglasii','Carex douglasii','Carex douglas',2,0,'','','Boott','3a7dd12a-1523-5ae7-a898-374c7453ad96','Carex douglasii Boott','Boott','SPECIES','','Carex','','douglasii','','','',NULL,'','','','','','Boott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5089','','','Carex simulata Mackenzie',1,'Carex simulata','Carex simulata','Carex simulat',2,0,'','','Mackenzie','ec45dee5-f6ce-5d2b-b676-095c65cbfa4e','Carex simulata Mackenzie','Mackenzie','SPECIES','','Carex','','simulata','','','',NULL,'','','','','','Mackenzie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5001','','','Carex nigricans C.A. Meyer',1,'Carex nigricans','Carex nigricans','Carex nigricans',2,0,'','','C. A. Meyer','b4a29c1e-73be-5250-aa7c-06826c3c50f4','Carex nigricans C.A. Meyer','C.A. Meyer','SPECIES','','Carex','','nigricans','','','',NULL,'','','','','','C. A. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2135','','','Carex sect. Firmiculmes (Kükenthal) Mackenzie',2,'Firmiculmes','Carex sect. Firmiculmes','Firmiculmes',1,0,'','','Kükenthal|Mackenzie','844274d5-b835-5a7b-ae07-327432802fe5','Carex sect. Firmiculmes (Kükenthal) Mackenzie','(Kükenthal) Mackenzie','SECTION','Firmiculmes','','','','','','',NULL,'Mackenzie','','','','','Kükenthal','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4750','','','Carex arcta Boott',1,'Carex arcta','Carex arcta','Carex arct',2,0,'','','Boott','aa6edafb-ffd8-56bc-b3eb-8a450dd5e1d4','Carex arcta Boott','Boott','SPECIES','','Carex','','arcta','','','',NULL,'','','','','','Boott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4791','','','Carex brunnescens (Persoon) Poiret',1,'Carex brunnescens','Carex brunnescens','Carex brunnescens',2,0,'','','Persoon|Poiret','a4324735-343c-5770-8f70-802923fa3302','Carex brunnescens (Persoon) Poiret','(Persoon) Poiret','SPECIES','','Carex','','brunnescens','','','',NULL,'Poiret','','','','','Persoon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4882','','','Carex glareosa Wahlenberg',1,'Carex glareosa','Carex glareosa','Carex glareos',2,0,'','','Wahlenberg','e5253e16-ecd1-5fee-8a80-34978a2b63ed','Carex glareosa Wahlenberg','Wahlenberg','SPECIES','','Carex','','glareosa','','','',NULL,'','','','','','Wahlenberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4953','','','Carex loliacea Linnaeus',1,'Carex loliacea','Carex loliacea','Carex loliace',2,0,'','','Linnaeus','63a87b20-2267-5bbf-ac85-53c89bce92a0','Carex loliacea Linnaeus','Linnaeus','SPECIES','','Carex','','loliacea','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5114','','','Carex tenuiflora Wahlenberg',1,'Carex tenuiflora','Carex tenuiflora','Carex tenuiflor',2,0,'','','Wahlenberg','987e45e8-44fa-50e5-91b9-12d737e68ea1','Carex tenuiflora Wahlenberg','Wahlenberg','SPECIES','','Carex','','tenuiflora','','','',NULL,'','','','','','Wahlenberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5151','','','Carex ×clausa Holmberg',3,'','','',NULL,NULL,'','','','','Carex ×clausa Holmberg','Holmberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5164','','','Carex ×kyyhkynenii Hidén',3,'','','',NULL,NULL,'','','','','Carex ×kyyhkynenii Hidén','Hidén','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5199','','','Carex ×trichina Fernald',3,'','','',NULL,NULL,'','','','','Carex ×trichina Fernald','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4888','','','Carex granularis Muhlenberg ex Willdenow',2,'Carex granularis','Carex granularis','Carex granular',2,0,'','','Muhlenberg|Willdenow','78c6c7d8-dbde-5801-a246-443bc89f75da','Carex granularis Muhlenberg ex Willdenow','Muhlenberg ex Willdenow','SPECIES','','Carex','','granularis','','','',NULL,'','','','','','Muhlenberg','','Willdenow','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5009','','','Carex oligocarpa Willdenow',1,'Carex oligocarpa','Carex oligocarpa','Carex oligocarp',2,0,'','','Willdenow','c1fdc35c-8492-5e15-939b-26fb0de6c12d','Carex oligocarpa Willdenow','Willdenow','SPECIES','','Carex','','oligocarpa','','','',NULL,'','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4831','','','Carex cusickii Mackenzie ex Piper & Beattie',2,'Carex cusickii','Carex cusickii','Carex cusick',2,0,'','','Mackenzie|Piper|Beattie','20c79f5c-2df0-5a3e-b422-3284ca1e1f9c','Carex cusickii Mackenzie ex Piper & Beattie','Mackenzie ex Piper & Beattie','SPECIES','','Carex','','cusickii','','','',NULL,'','','','','','Mackenzie','','Piper & Beattie','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4751','','','Carex arctata Boott',1,'Carex arctata','Carex arctata','Carex arctat',2,0,'','','Boott','32f1a1d8-2961-55dd-9bce-49b3c6da100c','Carex arctata Boott','Boott','SPECIES','','Carex','','arctata','','','',NULL,'','','','','','Boott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4834','','','Carex debilis Michaux',1,'Carex debilis','Carex debilis','Carex debil',2,0,'','','Michaux','f4fc39be-d130-517c-93a3-4f261ade4dc1','Carex debilis Michaux','Michaux','SPECIES','','Carex','','debilis','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4858','','','Carex engelmannii L.H. Bailey',1,'Carex engelmannii','Carex engelmannii','Carex engelmann',2,0,'','','L. H. Bailey','fb2fc7a1-6355-5eba-a644-70eeebd00da7','Carex engelmannii L.H. Bailey','L.H. Bailey','SPECIES','','Carex','','engelmannii','','','',NULL,'','','','','','L. H. Bailey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4925','','','Carex lachenalii × Carex parallela',2,'Carex lachenalii × Carex parallela','Carex lachenalii × Carex parallela','Carex lachenal × Carex parallel',0,0,'HYBRID_FORMULA','','','a1bb3455-18b1-508a-99ae-41dac5745238','Carex lachenalii × Carex parallela','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5175','','','Carex ×neomiliaris Lepage',3,'','','',NULL,NULL,'','','','','Carex ×neomiliaris Lepage','Lepage','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5183','','','Carex ×quebecensis Lepage',3,'','','',NULL,NULL,'','','','','Carex ×quebecensis Lepage','Lepage','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5190','','','Carex ×soerensenii Lepage',3,'','','',NULL,NULL,'','','','','Carex ×soerensenii Lepage','Lepage','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28391','','','Carex ×cayouettei A. Bergeron',3,'','','',NULL,NULL,'','','','','Carex ×cayouettei A. Bergeron','A. Bergeron','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34034','','','Carex rostrata × Carex saxatilis',2,'Carex rostrata × Carex saxatilis','Carex rostrata × Carex saxatilis','Carex rostrat × Carex saxatil',0,0,'HYBRID_FORMULA','','','75ad6c13-f1a7-53bb-9a30-63f2916f2352','Carex rostrata × Carex saxatilis','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2100','','','Carex sect. Laxiflorae (Kunth) Mackenzie',2,'Laxiflorae','Carex sect. Laxiflorae','Laxiflorae',1,0,'','','Kunth|Mackenzie','92147f5c-94c2-5fa8-afd3-f67e92048320','Carex sect. Laxiflorae (Kunth) Mackenzie','(Kunth) Mackenzie','SECTION','Laxiflorae','','','','','','',NULL,'Mackenzie','','','','','Kunth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4899','','','Carex hendersonii L.H. Bailey',1,'Carex hendersonii','Carex hendersonii','Carex henderson',2,0,'','','L. H. Bailey','18b21e72-ffcf-5a59-b568-8b1b34038cfe','Carex hendersonii L.H. Bailey','L.H. Bailey','SPECIES','','Carex','','hendersonii','','','',NULL,'','','','','','L. H. Bailey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2143','','','Carex sect. Leptocephalae L.H. Bailey',2,'Leptocephalae','Carex sect. Leptocephalae','Leptocephalae',1,0,'','','L. H. Bailey','d71c0ed8-0785-53ab-a140-f12c453d0150','Carex sect. Leptocephalae L.H. Bailey','L.H. Bailey','SECTION','Leptocephalae','','','','','','',NULL,'','','','','','L. H. Bailey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2147','','','Carex sect. Leucoglochin Dumortier',2,'Leucoglochin','Carex sect. Leucoglochin','Leucoglochin',1,0,'','','Dumortier','047c508c-dd30-5bf0-be4b-3899a239f858','Carex sect. Leucoglochin Dumortier','Dumortier','SECTION','Leucoglochin','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4951','','','Carex limosa Linnaeus',1,'Carex limosa','Carex limosa','Carex limos',2,0,'','','Linnaeus','50d18ee7-63fe-56c1-98de-60ac17f62a03','Carex limosa Linnaeus','Linnaeus','SPECIES','','Carex','','limosa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5050','','','Carex rariflora (Wahlenberg) Smith',1,'Carex rariflora','Carex rariflora','Carex rariflor',2,0,'','','Wahlenberg|Smith','63de26ab-eb60-5da0-a957-a0431344ee5e','Carex rariflora (Wahlenberg) Smith','(Wahlenberg) Smith','SPECIES','','Carex','','rariflora','','','',NULL,'Smith','','','','','Wahlenberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4920','','','Carex intumescens Rudge',1,'Carex intumescens','Carex intumescens','Carex intumescens',2,0,'','','Rudge','6e2a4c7b-e202-5baa-b5cd-8cdeabb52a3b','Carex intumescens Rudge','Rudge','SPECIES','','Carex','','intumescens','','','',NULL,'','','','','','Rudge','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4957','','','Carex lupuliformis Sartwell ex Dewey',2,'Carex lupuliformis','Carex lupuliformis','Carex lupuliform',2,0,'','','Sartwell|Dewey','456b6694-a9de-599c-92b9-e7f538fb421e','Carex lupuliformis Sartwell ex Dewey','Sartwell ex Dewey','SPECIES','','Carex','','lupuliformis','','','',NULL,'','','','','','Sartwell','','Dewey','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4733','','','Carex alma L.H. Bailey',1,'Carex alma','Carex alma','Carex alm',2,0,'','','L. H. Bailey','b2449363-355a-516a-bafb-32d64b0c98f9','Carex alma L.H. Bailey','L.H. Bailey','SPECIES','','Carex','','alma','','','',NULL,'','','','','','L. H. Bailey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2097','','','Carex sect. Ovales Kunth',2,'Ovales','Carex sect. Ovales','Ovales',1,0,'','','Kunth','77e05fb3-c366-5a9d-a0aa-0e90b90ef093','Carex sect. Ovales Kunth','Kunth','SECTION','Ovales','','','','','','',NULL,'','','','','','Kunth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4786','','','Carex brevior (Dewey) Mackenzie ex Lunell',2,'Carex brevior','Carex brevior','Carex breuior',2,0,'','','Dewey|Mackenzie|Lunell','08006613-4923-54cf-aa12-e1486fea3081','Carex brevior (Dewey) Mackenzie ex Lunell','(Dewey) Mackenzie ex Lunell','SPECIES','','Carex','','brevior','','','',NULL,'Mackenzie','','Lunell','','','Dewey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4869','','','Carex foenea Willdenow',1,'Carex foenea','Carex foenea','Carex foene',2,0,'','','Willdenow','e71eee4f-4028-5e2c-82bd-3d5cc0efc47a','Carex foenea Willdenow','Willdenow','SPECIES','','Carex','','foenea','','','',NULL,'','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4871','','','Carex foenea × Carex tenera var. tenera',2,'Carex foenea × Carex tenera tenera','Carex foenea × Carex tenera var. tenera','Carex foene × Carex tener tener',0,0,'HYBRID_FORMULA','','','6aee5a26-dce1-5385-bd38-b0b095d5a513','Carex foenea × Carex tenera var. tenera','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4966','','','Carex macloviana d''Urville',1,'Carex macloviana','Carex macloviana','Carex maclouian',2,0,'','','d''Urville','822e8fd9-e67c-5d7f-813e-6ed779e2ccbf','Carex macloviana d''Urville','d''Urville','SPECIES','','Carex','','macloviana','','','',NULL,'','','','','','d''Urville','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4996','','','Carex muskingumensis Schweinitz',1,'Carex muskingumensis','Carex muskingumensis','Carex muskingumens',2,0,'','','Schweinitz','169e41f8-ac96-566a-8abe-15e11b8d4a0b','Carex muskingumensis Schweinitz','Schweinitz','SPECIES','','Carex','','muskingumensis','','','',NULL,'','','','','','Schweinitz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5112','','','Carex tenera Dewey',1,'Carex tenera','Carex tenera','Carex tener',2,0,'','','Dewey','1b357dcf-91a2-51f2-aa43-db319dd9eb98','Carex tenera Dewey','Dewey','SPECIES','','Carex','','tenera','','','',NULL,'','','','','','Dewey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5123','','','Carex tribuloides Wahlenberg',1,'Carex tribuloides','Carex tribuloides','Carex tribuloid',2,0,'','','Wahlenberg','cd1579fe-852a-577e-8d06-50b97d4c0282','Carex tribuloides Wahlenberg','Wahlenberg','SPECIES','','Carex','','tribuloides','','','',NULL,'','','','','','Wahlenberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30569','','','Carex leporina Linnaeus',1,'Carex leporina','Carex leporina','Carex leporin',2,0,'','','Linnaeus','799f7ab9-2e87-5e16-b053-17533d3a7ea4','Carex leporina Linnaeus','Linnaeus','SPECIES','','Carex','','leporina','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4933','','','Carex lasiocarpa Ehrhart',1,'Carex lasiocarpa','Carex lasiocarpa','Carex lasiocarp',2,0,'','','Ehrhart','b8cc0215-5d29-5443-8aad-02f68eb6d966','Carex lasiocarpa Ehrhart','Ehrhart','SPECIES','','Carex','','lasiocarpa','','','',NULL,'','','','','','Ehrhart','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4934','','','Carex laxa Wahlenberg',1,'Carex laxa','Carex laxa','Carex lax',2,0,'','','Wahlenberg','fe46438a-142a-5d77-9558-4cc217234847','Carex laxa Wahlenberg','Wahlenberg','SPECIES','','Carex','','laxa','','','',NULL,'','','','','','Wahlenberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5115','','','Carex tetanica Schkuhr ex Willdenow',2,'Carex tetanica','Carex tetanica','Carex tetanic',2,0,'','','Schkuhr|Willdenow','86f90b3a-68d1-5139-8b5c-e984a703dd9f','Carex tetanica Schkuhr ex Willdenow','Schkuhr ex Willdenow','SPECIES','','Carex','','tetanica','','','',NULL,'','','','','','Schkuhr','','Willdenow','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2106','','','Carex sect. Phacocystis Dumortier',2,'Phacocystis','Carex sect. Phacocystis','Phacocystis',1,0,'','','Dumortier','e993fe94-7f4e-5256-ba1c-79b3dc9a85d8','Carex sect. Phacocystis Dumortier','Dumortier','SECTION','Phacocystis','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4741','','','Carex aquatilis Wahlenberg var. aquatilis',1,'Carex aquatilis aquatilis','Carex aquatilis var. aquatilis','Carex aquatil aquatil',3,0,'','','','27f4608b-44b6-5b94-8c4e-bcdc7226cd01','Carex aquatilis Wahlenberg var. aquatilis','Wahlenberg','VARIETY','','Carex','','aquatilis','aquatilis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4775','','','Carex bigelowii Torrey ex Schweinitz',2,'Carex bigelowii','Carex bigelowii','Carex bigelow',2,0,'','','Torrey|Schweinitz','91b8e3cd-b9b5-56e0-807d-1c28e1327d41','Carex bigelowii Torrey ex Schweinitz','Torrey ex Schweinitz','SPECIES','','Carex','','bigelowii','','','',NULL,'','','','','','Torrey','','Schweinitz','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4777','','','Carex bigelowii subsp. lugens × Carex scopulorum',2,'Carex bigelowii lugens × Carex scopulorum','Carex bigelowii subsp. lugens × Carex scopulorum','Carex bigelow lugens × Carex scopulor',0,0,'HYBRID_FORMULA','','','a6d70816-e3e9-5d46-94de-22d3cdcda26d','Carex bigelowii subsp. lugens × Carex scopulorum','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4822','','','Carex crinita Lamarck var. crinita',1,'Carex crinita crinita','Carex crinita var. crinita','Carex crinit crinit',3,0,'','','','bcfd0381-36e4-5edd-beb3-69d6604c2475','Carex crinita Lamarck var. crinita','Lamarck','VARIETY','','Carex','','crinita','crinita','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4941','','','Carex lenticularis Michaux',1,'Carex lenticularis','Carex lenticularis','Carex lenticular',2,0,'','','Michaux','b96b8040-af11-59e3-a414-dcc1bc197b78','Carex lenticularis Michaux','Michaux','SPECIES','','Carex','','lenticularis','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5014','','','Carex paleacea Schreber ex Wahlenberg',2,'Carex paleacea','Carex paleacea','Carex paleace',2,0,'','','Schreber|Wahlenberg','38d8a278-d0c3-54b3-bc57-9c85599e02ef','Carex paleacea Schreber ex Wahlenberg','Schreber ex Wahlenberg','SPECIES','','Carex','','paleacea','','','',NULL,'','','','','','Schreber','','Wahlenberg','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5084','','','Carex scopulorum var. prionophylla (Holm) L.A. Standley',1,'Carex scopulorum prionophylla','Carex scopulorum var. prionophylla','Carex scopulor prionophyll',3,0,'','','Holm|L. A. Standley','01a04c50-21df-5010-908c-56396c5a6528','Carex scopulorum var. prionophylla (Holm) L.A. Standley','(Holm) L.A. Standley','VARIETY','','Carex','','scopulorum','prionophylla','','',NULL,'L. A. Standley','','','','','Holm','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5150','','','Carex ×arctophila Nylander',3,'','','',NULL,NULL,'','','','','Carex ×arctophila Nylander','Nylander','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5153','','','Carex ×crinitoides Lepage',3,'','','',NULL,NULL,'','','','','Carex ×crinitoides Lepage','Lepage','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5154','','','Carex ×dumanii Lepage',3,'','','',NULL,NULL,'','','','','Carex ×dumanii Lepage','Lepage','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5157','','','Carex ×flavicans (F. Nylander) F. Nylander',3,'','','',NULL,NULL,'','','','','Carex ×flavicans (F. Nylander) F. Nylander','(F. Nylander) F. Nylander','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5167','','','Carex ×limula Fries',3,'','','',NULL,NULL,'','','','','Carex ×limula Fries','Fries','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5188','','','Carex ×saxenii Raymond',3,'','','',NULL,NULL,'','','','','Carex ×saxenii Raymond','Raymond','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5160','','','Carex ×groenlandica Lange',3,'','','',NULL,NULL,'','','','','Carex ×groenlandica Lange','Lange','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4984','','','Carex microchaeta Holm',1,'Carex microchaeta','Carex microchaeta','Carex microchaet',2,0,'','','Holm','667ccfd3-09df-585a-bdcd-cfc507620590','Carex microchaeta Holm','Holm','SPECIES','','Carex','','microchaeta','','','',NULL,'','','','','','Holm','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23221','','','Carex kelloggii W. Boott',1,'Carex kelloggii','Carex kelloggii','Carex kellogg',2,0,'','','W. Boott','e354766e-8b3d-50bf-92a3-99aa966dbf3f','Carex kelloggii W. Boott','W. Boott','SPECIES','','Carex','','kelloggii','','','',NULL,'','','','','','W. Boott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30854','','','Carex kelloggii W. Boott var. kelloggii',1,'Carex kelloggii kelloggii','Carex kelloggii var. kelloggii','Carex kellogg kellogg',3,0,'','','','e8362689-5f20-5e7a-8007-efa26fd78c42','Carex kelloggii W. Boott var. kelloggii','W. Boott','VARIETY','','Carex','','kelloggii','kelloggii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4809','','','Carex cephaloidea (Dewey) Dewey',1,'Carex cephaloidea','Carex cephaloidea','Carex cephaloide',2,0,'','','Dewey','db2df686-b398-5711-8c13-b43f1faf40c8','Carex cephaloidea (Dewey) Dewey','(Dewey) Dewey','SPECIES','','Carex','','cephaloidea','','','',NULL,'Dewey','','','','','Dewey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4981','','','Carex mesochorea Mackenzie',1,'Carex mesochorea','Carex mesochorea','Carex mesochore',2,0,'','','Mackenzie','cb63ecfa-b76f-50da-bff4-decf24dd4184','Carex mesochorea Mackenzie','Mackenzie','SPECIES','','Carex','','mesochorea','','','',NULL,'','','','','','Mackenzie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4994','','','Carex muricata subsp. lamprocarpa Celakovsky',1,'Carex muricata lamprocarpa','Carex muricata subsp. lamprocarpa','Carex muricat lamprocarp',3,0,'','','Celakovsky','068bb1e2-52e7-5a78-8a67-055b285c57e7','Carex muricata subsp. lamprocarpa Celakovsky','Celakovsky','SUBSPECIES','','Carex','','muricata','lamprocarpa','','',NULL,'','','','','','Celakovsky','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5092','','','Carex spicata Hudson',1,'Carex spicata','Carex spicata','Carex spicat',2,0,'','','Hudson','62d9e419-f76b-55dd-8b70-2302cc4a0ebe','Carex spicata Hudson','Hudson','SPECIES','','Carex','','spicata','','','',NULL,'','','','','','Hudson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4819','','','Carex cordillerana Saarela & B.A. Ford',1,'Carex cordillerana','Carex cordillerana','Carex cordilleran',2,0,'','','Saarela|B. A. Ford','5d29fe50-13b9-5397-9360-0b2f2a08b358','Carex cordillerana Saarela & B.A. Ford','Saarela & B.A. Ford','SPECIES','','Carex','','cordillerana','','','',NULL,'','','','','','Saarela & B. A. Ford','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4893','','','Carex gynocrates Wormskjold ex Drejer',2,'Carex gynocrates','Carex gynocrates','Carex gynocrat',2,0,'','','Wormskjold|Drejer','960917f9-3309-5649-8d0a-6302fac59762','Carex gynocrates Wormskjold ex Drejer','Wormskjold ex Drejer','SPECIES','','Carex','','gynocrates','','','',NULL,'','','','','','Wormskjold','','Drejer','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4900','','','Carex hirsutella Mackenzie',1,'Carex hirsutella','Carex hirsutella','Carex hirsutell',2,0,'','','Mackenzie','d511d445-e0b6-5316-b0dc-6a087ee2a288','Carex hirsutella Mackenzie','Mackenzie','SPECIES','','Carex','','hirsutella','','','',NULL,'','','','','','Mackenzie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4723','','','Carex adelostoma V.I. Kreczetowicz',1,'Carex adelostoma','Carex adelostoma','Carex adelostom',2,0,'','','V. I. Kreczetowicz','2e597af3-3edd-51a4-805d-1350eea5d311','Carex adelostoma V.I. Kreczetowicz','V.I. Kreczetowicz','SPECIES','','Carex','','adelostoma','','','',NULL,'','','','','','V. I. Kreczetowicz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4764','','','Carex atrosquama × Carex media',2,'Carex atrosquama × Carex media','Carex atrosquama × Carex media','Carex atrosquam × Carex med',0,0,'HYBRID_FORMULA','','','649867cf-9848-58a9-8264-b468193ccd69','Carex atrosquama × Carex media','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4859','','','Carex epapillosa Mackenzie',1,'Carex epapillosa','Carex epapillosa','Carex epapillos',2,0,'','','Mackenzie','4a450c9c-2f19-5970-9a96-f35ae397bfc0','Carex epapillosa Mackenzie','Mackenzie','SPECIES','','Carex','','epapillosa','','','',NULL,'','','','','','Mackenzie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5051','','','Carex raynoldsii Dewey',1,'Carex raynoldsii','Carex raynoldsii','Carex raynolds',2,0,'','','Dewey','4c2f6f9c-2c76-5eb6-a43e-13328b488ea1','Carex raynoldsii Dewey','Dewey','SPECIES','','Carex','','raynoldsii','','','',NULL,'','','','','','Dewey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2151','','','Carex sect. Rupestres (Tuckerman) Meinschausen',2,'Rupestres','Carex sect. Rupestres','Rupestres',1,0,'','','Tuckerman|Meinschausen','582aea28-5352-531e-a74c-9647abdec514','Carex sect. Rupestres (Tuckerman) Meinschausen','(Tuckerman) Meinschausen','SECTION','Rupestres','','','','','','',NULL,'Meinschausen','','','','','Tuckerman','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5074','','','Carex scirpoidea Michaux',1,'Carex scirpoidea','Carex scirpoidea','Carex scirpoide',2,0,'','','Michaux','27ca75ec-28e8-5033-b9f8-52936745015f','Carex scirpoidea Michaux','Michaux','SPECIES','','Carex','','scirpoidea','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5076','','','Carex scirpoidea Michaux subsp. scirpoidea',1,'Carex scirpoidea scirpoidea','Carex scirpoidea subsp. scirpoidea','Carex scirpoide scirpoide',3,0,'','','','ad49fe1d-1ee7-5315-8a4f-c0de2b7918fc','Carex scirpoidea Michaux subsp. scirpoidea','Michaux','SUBSPECIES','','Carex','','scirpoidea','scirpoidea','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4876','','','Carex frankii Kunth',1,'Carex frankii','Carex frankii','Carex frank',2,0,'','','Kunth','e4761891-cc30-5954-b03e-9e96b84f438e','Carex frankii Kunth','Kunth','SPECIES','','Carex','','frankii','','','',NULL,'','','','','','Kunth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4759','','','Carex atlantica subsp. capillacea (L.H. Bailey) Reznicek',1,'Carex atlantica capillacea','Carex atlantica subsp. capillacea','Carex atlantic capillace',3,0,'','','L. H. Bailey|Reznicek','00178618-89ed-5a18-be55-7e3183705a0d','Carex atlantica subsp. capillacea (L.H. Bailey) Reznicek','(L.H. Bailey) Reznicek','SUBSPECIES','','Carex','','atlantica','capillacea','','',NULL,'Reznicek','','','','','L. H. Bailey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4854','','','Carex echinata subsp. phyllomanica (W. Boott) Reznicek',1,'Carex echinata phyllomanica','Carex echinata subsp. phyllomanica','Carex echinat phyllomanic',3,0,'','','W. Boott|Reznicek','d6feecd1-01bf-5b7c-9186-05e606583c71','Carex echinata subsp. phyllomanica (W. Boott) Reznicek','(W. Boott) Reznicek','SUBSPECIES','','Carex','','echinata','phyllomanica','','',NULL,'Reznicek','','','','','W. Boott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5095','','','Carex sterilis Willdenow',1,'Carex sterilis','Carex sterilis','Carex steril',2,0,'','','Willdenow','21fafe5e-4315-5493-8536-22bbb1d419ba','Carex sterilis Willdenow','Willdenow','SPECIES','','Carex','','sterilis','','','',NULL,'','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4862','','','Carex exsiccata × Carex rostrata',2,'Carex exsiccata × Carex rostrata','Carex exsiccata × Carex rostrata','Carex exsiccat × Carex rostrat',0,0,'HYBRID_FORMULA','','','bdf49ffd-31f1-558e-8ff7-0c2b95c51d96','Carex exsiccata × Carex rostrata','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4911','','','Carex hystericina Muhlenberg ex Willdenow',2,'Carex hystericina','Carex hystericina','Carex hystericin',2,0,'','','Muhlenberg|Willdenow','cb63b74e-c0ba-592c-9345-3a6311f0900a','Carex hystericina Muhlenberg ex Willdenow','Muhlenberg ex Willdenow','SPECIES','','Carex','','hystericina','','','',NULL,'','','','','','Muhlenberg','','Willdenow','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5055','','','Carex retrorsa Schweinitz',1,'Carex retrorsa','Carex retrorsa','Carex retrors',2,0,'','','Schweinitz','6a76ca6b-7bf9-58f5-89ea-a29ed9c75367','Carex retrorsa Schweinitz','Schweinitz','SPECIES','','Carex','','retrorsa','','','',NULL,'','','','','','Schweinitz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5072','','','Carex schweinitzii Dewey ex Schweinitz',2,'Carex schweinitzii','Carex schweinitzii','Carex schweinitz',2,0,'','','Dewey|Schweinitz','a42b708b-3f6f-56f3-9d1e-44952483ce82','Carex schweinitzii Dewey ex Schweinitz','Dewey ex Schweinitz','SPECIES','','Carex','','schweinitzii','','','',NULL,'','','','','','Dewey','','Schweinitz','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32272','','','Carex ×hartii Dewey',3,'','','',NULL,NULL,'','','','','Carex ×hartii Dewey','Dewey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4734','','','Carex alopecoidea Tuckerman',1,'Carex alopecoidea','Carex alopecoidea','Carex alopecoide',2,0,'','','Tuckerman','d7513605-8e2c-5ce5-9a40-34476202284a','Carex alopecoidea Tuckerman','Tuckerman','SPECIES','','Carex','','alopecoidea','','','',NULL,'','','','','','Tuckerman','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5096','','','Carex stipata Muhlenberg ex Willdenow var. stipata',2,'Carex stipata stipata','Carex stipata var. stipata','Carex stipat stipat',3,0,'','','','7e75c236-3c82-5184-998c-16658be528a8','Carex stipata Muhlenberg ex Willdenow var. stipata','Muhlenberg ex Willdenow','VARIETY','','Carex','','stipata','stipata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32774','','','Cladieae Nees',1,'Cladieae','Cladieae','Cladieae',1,0,'','','Nees','494c89b2-32b9-55ec-bd1f-779390adc925','Cladieae Nees','Nees','TRIBE','Cladieae','','','','','','',NULL,'','','','','','Nees','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1622','','','Rhynchospora Vahl',1,'Rhynchospora','Rhynchospora','Rhynchospora',1,0,'','','Vahl','1a765e06-39db-509d-88cd-2ebf989890fb','Rhynchospora Vahl','Vahl','GENUS','Rhynchospora','','','','','','',NULL,'','','','','','Vahl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('130','','','Eriocaulaceae Martinov',1,'Eriocaulaceae','Eriocaulaceae','Eriocaulaceae',1,0,'','','Martinov','3e575086-4692-5c76-b9ec-97750bab3bff','Eriocaulaceae Martinov','Martinov','FAMILY','Eriocaulaceae','','','','','','',NULL,'','','','','','Martinov','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1298','','','Juncus Linnaeus',1,'Juncus','Juncus','Juncus',1,0,'','','Linnaeus','b98c3f21-4bbd-59ba-a20b-e33d4be96b34','Juncus Linnaeus','Linnaeus','GENUS','Juncus','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6271','','','Juncus covillei Piper var. covillei',1,'Juncus covillei covillei','Juncus covillei var. covillei','Juncus couille couille',3,0,'','','','21063e3b-523d-5a89-a433-9ed1369315ac','Juncus covillei Piper var. covillei','Piper','VARIETY','','Juncus','','covillei','covillei','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6301','','','Juncus regelii Buchenau',1,'Juncus regelii','Juncus regelii','Juncus regel',2,0,'','','Buchenau','46daab3e-16c6-577e-b70f-be0d9e70c86d','Juncus regelii Buchenau','Buchenau','SPECIES','','Juncus','','regelii','','','',NULL,'','','','','','Buchenau','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25143','','','Juncus triglumis Linnaeus subsp. triglumis',1,'Juncus triglumis triglumis','Juncus triglumis subsp. triglumis','Juncus triglum triglum',3,0,'','','','34362749-79bf-58c3-a515-b47d2ebb1d91','Juncus triglumis Linnaeus subsp. triglumis','Linnaeus','SUBSPECIES','','Juncus','','triglumis','triglumis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25146','','','Juncus sect. Iridifolii Snogerup & Kirchner',2,'Iridifolii','Juncus sect. Iridifolii','Iridifolii',1,0,'','','Snogerup|Kirchner','ff2c6655-9b5f-5f05-877f-96c699b1b5fb','Juncus sect. Iridifolii Snogerup & Kirchner','Snogerup & Kirchner','SECTION','Iridifolii','','','','','','',NULL,'','','','','','Snogerup & Kirchner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6278','','','Juncus ensifolius Wikström',1,'Juncus ensifolius','Juncus ensifolius','Juncus ensifol',2,0,'','','Wikström','45ccaef5-2c35-5e98-abbb-70b5dbcbd197','Juncus ensifolius Wikström','Wikström','SPECIES','','Juncus','','ensifolius','','','',NULL,'','','','','','Wikström','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6300','','','Juncus pelocarpus E. Meyer',1,'Juncus pelocarpus','Juncus pelocarpus','Juncus pelocarp',2,0,'','','E. Meyer','877e9dfc-5347-583b-afa1-c2460bf4291a','Juncus pelocarpus E. Meyer','E. Meyer','SPECIES','','Juncus','','pelocarpus','','','',NULL,'','','','','','E. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6263','','','Juncus caesariensis Coville',1,'Juncus caesariensis','Juncus caesariensis','Juncus caesariens',2,0,'','','Coville','13ce1c07-940e-53bb-ab4e-42165c6b2c45','Juncus caesariensis Coville','Coville','SPECIES','','Juncus','','caesariensis','','','',NULL,'','','','','','Coville','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6295','','','Juncus nodosus Linnaeus',1,'Juncus nodosus','Juncus nodosus','Juncus nodos',2,0,'','','Linnaeus','50069a9c-a227-5ce3-a543-d7b09893882a','Juncus nodosus Linnaeus','Linnaeus','SPECIES','','Juncus','','nodosus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25213','','','Juncus acutiflorus Ehrhart ex Hoffman subsp. acutiflorus',2,'Juncus acutiflorus acutiflorus','Juncus acutiflorus subsp. acutiflorus','Juncus acutiflor acutiflor',3,0,'','','','d465409d-69b5-5375-885c-909831c49fe5','Juncus acutiflorus Ehrhart ex Hoffman subsp. acutiflorus','Ehrhart ex Hoffman','SUBSPECIES','','Juncus','','acutiflorus','acutiflorus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6247','','','Juncus alpinoarticulatus Chaix',1,'Juncus alpinoarticulatus','Juncus alpinoarticulatus','Juncus alpinoarticulat',2,0,'','','Chaix','7826144b-c366-5cd0-8ec3-cdfbe3f25957','Juncus alpinoarticulatus Chaix','Chaix','SPECIES','','Juncus','','alpinoarticulatus','','','',NULL,'','','','','','Chaix','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6320','','','Juncus ×nodosiformis Fernald',3,'','','',NULL,NULL,'','','','','Juncus ×nodosiformis Fernald','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6317','','','Juncus ×fulvescens Fernald',3,'','','',NULL,NULL,'','','','','Juncus ×fulvescens Fernald','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25234','','','Juncus gerardi Loiseleur-Deslongchamps subsp. gerardi',1,'Juncus gerardi gerardi','Juncus gerardi subsp. gerardi','Juncus gerard gerard',3,0,'','','','44498070-0691-5f09-ba3e-d9993a9136f8','Juncus gerardi Loiseleur-Deslongchamps subsp. gerardi','Loiseleur-Deslongchamps','SUBSPECIES','','Juncus','','gerardi','gerardi','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6302','','','Juncus secundus P. Beauvois ex Poiret',2,'Juncus secundus','Juncus secundus','Juncus secund',2,0,'','','P. Beauvois|Poiret','062e549a-ef1c-5986-b734-3ed5ac079592','Juncus secundus P. Beauvois ex Poiret','P. Beauvois ex Poiret','SPECIES','','Juncus','','secundus','','','',NULL,'','','','','','P. Beauvois','','Poiret','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25242','','','Juncus sect. Juncotypus Dumortier',2,'Juncotypus','Juncus sect. Juncotypus','Juncotypus',1,0,'','','Dumortier','54a1d7d4-59de-5ac4-815e-6b2471058b27','Juncus sect. Juncotypus Dumortier','Dumortier','SECTION','Juncotypus','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6250','','','Juncus arcticus Willdenow',1,'Juncus arcticus','Juncus arcticus','Juncus arctic',2,0,'','','Willdenow','0f67e6d0-6098-5648-812b-cdd1e6d00262','Juncus arcticus Willdenow','Willdenow','SPECIES','','Juncus','','arcticus','','','',NULL,'','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6258','','','Juncus breweri Engelmann',1,'Juncus breweri','Juncus breweri','Juncus brewer',2,0,'','','Engelmann','d1388d9f-32c3-53ec-a288-ddb299d01296','Juncus breweri Engelmann','Engelmann','SPECIES','','Juncus','','breweri','','','',NULL,'','','','','','Engelmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25005','','','Juncus effusus Linnaeus subsp. effusus',1,'Juncus effusus effusus','Juncus effusus subsp. effusus','Juncus effus effus',3,0,'','','','6696f519-290c-5cb9-bdd8-5b664a9a3812','Juncus effusus Linnaeus subsp. effusus','Linnaeus','SUBSPECIES','','Juncus','','effusus','effusus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25244','','','Juncus balticus subsp. littoralis (Engelmann) Snogerup',1,'Juncus balticus littoralis','Juncus balticus subsp. littoralis','Juncus baltic littoral',3,0,'','','Engelmann|Snogerup','a2557fae-4261-5f23-8da3-b12df683e556','Juncus balticus subsp. littoralis (Engelmann) Snogerup','(Engelmann) Snogerup','SUBSPECIES','','Juncus','','balticus','littoralis','','',NULL,'Snogerup','','','','','Engelmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16783','','','Juncus pylaei Laharpe',1,'Juncus pylaei','Juncus pylaei','Juncus pylae',2,0,'','','Laharpe','424e7618-3504-578b-a20c-5a3b8d860d7e','Juncus pylaei Laharpe','Laharpe','SPECIES','','Juncus','','pylaei','','','',NULL,'','','','','','Laharpe','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6343','','','Luzula spicata (Linnaeus) de Candolle',1,'Luzula spicata','Luzula spicata','Luzula spicat',2,0,'','','Linnaeus|de Candolle','46df7724-16c3-5dbf-bd9c-f35a212743ed','Luzula spicata (Linnaeus) de Candolle','(Linnaeus) de Candolle','SPECIES','','Luzula','','spicata','','','',NULL,'de Candolle','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25285','','','Luzula parviflora (Ehrhart) Desvaux subsp. parviflora',1,'Luzula parviflora parviflora','Luzula parviflora subsp. parviflora','Luzula paruiflor paruiflor',3,0,'','','','fdaa9207-856b-5843-8ae2-8c4a6a36b6ed','Luzula parviflora (Ehrhart) Desvaux subsp. parviflora','(Ehrhart) Desvaux','SUBSPECIES','','Luzula','','parviflora','parviflora','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6323','','','Luzula arcuata (Wahlenberg) Swartz subsp. arcuata',1,'Luzula arcuata arcuata','Luzula arcuata subsp. arcuata','Luzula arcuat arcuat',3,0,'','','','a8cba348-8f27-5ef0-9ab4-5a13564ebb5a','Luzula arcuata (Wahlenberg) Swartz subsp. arcuata','(Wahlenberg) Swartz','SUBSPECIES','','Luzula','','arcuata','arcuata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9677','','','Luzula echinata (Small) F.J. Hermann',1,'Luzula echinata','Luzula echinata','Luzula echinat',2,0,'','','Small|F. J. Hermann','ff20ffee-51b8-5ced-8842-9fe0c88c1c0d','Luzula echinata (Small) F.J. Hermann','(Small) F.J. Hermann','SPECIES','','Luzula','','echinata','','','',NULL,'F. J. Hermann','','','','','Small','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6327','','','Luzula comosa E. Meyer',1,'Luzula comosa','Luzula comosa','Luzula comos',2,0,'','','E. Meyer','58101adf-6d2d-594b-8503-1c1845e69bbd','Luzula comosa E. Meyer','E. Meyer','SPECIES','','Luzula','','comosa','','','',NULL,'','','','','','E. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2014','','','Luzula subg. Pterodes (Grisebach) Buchenau',2,'Pterodes','Luzula subgen. Pterodes','Pterodes',1,0,'','','Grisebach|Buchenau','0a92c6bf-b253-50df-bd0c-2667360478fa','Luzula subg. Pterodes (Grisebach) Buchenau','(Grisebach) Buchenau','SUBGENUS','Pterodes','','','','','','',NULL,'Buchenau','','','','','Grisebach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25125','','','Luzula rufescens Fisher ex E. Meyer var. rufescens',2,'Luzula rufescens rufescens','Luzula rufescens var. rufescens','Luzula rufescens rufescens',3,0,'','','','b5b672fb-f98f-5797-b327-ac5ff93cea56','Luzula rufescens Fisher ex E. Meyer var. rufescens','Fisher ex E. Meyer','VARIETY','','Luzula','','rufescens','rufescens','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28015','','','Oreojuncus Záveská Drábková & Kirschner',1,'Oreojuncus','Oreojuncus','Oreojuncus',1,0,'','','Záveská Drábková|Kirschner','1b137426-8474-5f88-995e-3e62ab6367ab','Oreojuncus Záveská Drábková & Kirschner','Záveská Drábková & Kirschner','GENUS','Oreojuncus','','','','','','',NULL,'','','','','','Záveská Drábková & Kirschner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7424','','','Aristida longespica Poiret',1,'Aristida longespica','Aristida longespica','Aristida longespic',2,0,'','','Poiret','41d22424-37fa-548e-9d58-1aceb9014268','Aristida longespica Poiret','Poiret','SPECIES','','Aristida','','longespica','','','',NULL,'','','','','','Poiret','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7423','','','Aristida longespica var. geniculata (Rafinesque) Fernald',1,'Aristida longespica geniculata','Aristida longespica var. geniculata','Aristida longespic geniculat',3,0,'','','Rafinesque|Fernald','65f40448-c8fb-559d-bbbf-5dd5b8aed815','Aristida longespica var. geniculata (Rafinesque) Fernald','(Rafinesque) Fernald','VARIETY','','Aristida','','longespica','geniculata','','',NULL,'Fernald','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7430','','','Aristida purpurea Nuttall',1,'Aristida purpurea','Aristida purpurea','Aristida purpure',2,0,'','','Nuttall','b05306d6-6053-595a-9916-54c1b1dbee9b','Aristida purpurea Nuttall','Nuttall','SPECIES','','Aristida','','purpurea','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('363','','','Arundinoideae Burmeister',1,'Arundinoideae','Arundinoideae','Arundinoideae',1,0,'','','Burmeister','7359c009-f26e-5786-a5ab-fdc0f82fd883','Arundinoideae Burmeister','Burmeister','SUBFAMILY','Arundinoideae','','','','','','',NULL,'','','','','','Burmeister','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7828','','','Phragmites australis (Cavanilles) Trinius ex Steudel subsp. australis',2,'Phragmites australis australis','Phragmites australis subsp. australis','Phragmites austral austral',3,0,'','','','5bab55ae-e18e-5864-8e52-2ad60209758b','Phragmites australis (Cavanilles) Trinius ex Steudel subsp. australis','(Cavanilles) Trinius ex Steudel','SUBSPECIES','','Phragmites','','australis','australis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30298','','','Bouteloua sect. Bouteloua Lagasca',2,'Bouteloua','Bouteloua sect. Bouteloua','Bouteloua',1,0,'','','Lagasca','71af01d7-4f07-54ca-942b-e813312a7ffe','Bouteloua sect. Bouteloua Lagasca','Lagasca','SECTION','Bouteloua','','','','','','',NULL,'','','','','','Lagasca','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9797','','','Bouteloua hirsuta Lagasca',1,'Bouteloua hirsuta','Bouteloua hirsuta','Bouteloua hirsut',2,0,'','','Lagasca','ef97e0fa-874a-58cf-98ae-007022e17fed','Bouteloua hirsuta Lagasca','Lagasca','SPECIES','','Bouteloua','','hirsuta','','','',NULL,'','','','','','Lagasca','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1103','','','Distichlis Rafinesque',1,'Distichlis','Distichlis','Distichlis',1,0,'','','Rafinesque','cfe9238f-de73-526c-b6bd-abf8e4375a35','Distichlis Rafinesque','Rafinesque','GENUS','Distichlis','','','','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('733','','','Eleusininiae Dumortier',1,'Eleusininiae','Eleusininiae','Eleusininiae',1,0,'','','Dumortier','cf115b5c-797c-57d2-a70e-235409934293','Eleusininiae Dumortier','Dumortier','SUBTRIBE','Eleusininiae','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7582','','','Eleusine indica (Linnaeus) Gaertner',1,'Eleusine indica','Eleusine indica','Eleusine indic',2,0,'','','Linnaeus|Gaertner','eef7207a-83a7-5901-9bbd-1dbbfd0b077b','Eleusine indica (Linnaeus) Gaertner','(Linnaeus) Gaertner','SPECIES','','Eleusine','','indica','','','',NULL,'Gaertner','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27726','','','Diplachne fusca subsp. fascicularis (Lamarck) P.M. Peterson & N. Snow',1,'Diplachne fusca fascicularis','Diplachne fusca subsp. fascicularis','Diplachne fusc fascicular',3,0,'','','Lamarck|P. M. Peterson|N. Snow','bf89ff8c-87b7-55ca-a691-c49b11f97487','Diplachne fusca subsp. fascicularis (Lamarck) P.M. Peterson & N. Snow','(Lamarck) P.M. Peterson & N. Snow','SUBSPECIES','','Diplachne','','fusca','fascicularis','','',NULL,'P. M. Peterson & N. Snow','','','','','Lamarck','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7778','','','Muhlenbergia cuspidata (Torrey ex Hooker) Rydberg',2,'Muhlenbergia cuspidata','Muhlenbergia cuspidata','Muhlenbergia cuspidat',2,0,'','','Torrey|Hooker|Rydberg','6374468a-a469-519f-bbed-066ac8fe34de','Muhlenbergia cuspidata (Torrey ex Hooker) Rydberg','(Torrey ex Hooker) Rydberg','SPECIES','','Muhlenbergia','','cuspidata','','','',NULL,'Rydberg','','','','','Torrey','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7787','','','Muhlenbergia schreberi J.F. Gmelin',1,'Muhlenbergia schreberi','Muhlenbergia schreberi','Muhlenbergia schreber',2,0,'','','J. F. Gmelin','537628fe-d351-515b-be5e-716731d2965a','Muhlenbergia schreberi J.F. Gmelin','J.F. Gmelin','SPECIES','','Muhlenbergia','','schreberi','','','',NULL,'','','','','','J. F. Gmelin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7790','','','Muhlenbergia tenuiflora (Willdenow) Britton, Sterns & Poggenburgh',1,'Muhlenbergia tenuiflora','Muhlenbergia tenuiflora','Muhlenbergia tenuiflor',2,0,'','','Willdenow|Britton|Sterns|Poggenburgh','42a4a0a9-ccd1-55be-85c5-25086e029c9b','Muhlenbergia tenuiflora (Willdenow) Britton, Sterns & Poggenburgh','(Willdenow) Britton, Sterns & Poggenburgh','SPECIES','','Muhlenbergia','','tenuiflora','','','',NULL,'Britton, Sterns & Poggenburgh','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7784','','','Muhlenbergia mexicana (Linnaeus) Trinius var. mexicana',1,'Muhlenbergia mexicana mexicana','Muhlenbergia mexicana var. mexicana','Muhlenbergia mexican mexican',3,0,'','','','d99bb266-84d5-592d-a436-03cbc7ef8342','Muhlenbergia mexicana (Linnaeus) Trinius var. mexicana','(Linnaeus) Trinius','VARIETY','','Muhlenbergia','','mexicana','mexicana','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1790','','','Triplasis P. Beauvois',1,'Triplasis','Triplasis','Triplasis',1,0,'','','P. Beauvois','082f51f9-46f0-53dd-9ed6-0ca98725eb9b','Triplasis P. Beauvois','P. Beauvois','GENUS','Triplasis','','','','','','',NULL,'','','','','','P. Beauvois','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7986','','','Triplasis purpurea (Walter) Chapman var. purpurea',1,'Triplasis purpurea purpurea','Triplasis purpurea var. purpurea','Triplasis purpure purpure',3,0,'','','','69528ce9-08cf-5539-add2-c99243721fce','Triplasis purpurea (Walter) Chapman var. purpurea','(Walter) Chapman','VARIETY','','Triplasis','','purpurea','purpurea','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7627','','','Eragrostis cilianensis (Allioni) Vignolo ex Janchen',2,'Eragrostis cilianensis','Eragrostis cilianensis','Eragrostis cilianens',2,0,'','','Allioni|Vignolo|Janchen','232df282-2975-5bc4-b78a-9ab0cc8d8072','Eragrostis cilianensis (Allioni) Vignolo ex Janchen','(Allioni) Vignolo ex Janchen','SPECIES','','Eragrostis','','cilianensis','','','',NULL,'Vignolo','','Janchen','','','Allioni','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7635','','','Eragrostis pectinacea (Michaux) Nees',1,'Eragrostis pectinacea','Eragrostis pectinacea','Eragrostis pectinace',2,0,'','','Michaux|Nees','916b7cff-9a90-5c72-a95d-187a988ae9d5','Eragrostis pectinacea (Michaux) Nees','(Michaux) Nees','SPECIES','','Eragrostis','','pectinacea','','','',NULL,'Nees','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7638','','','Eragrostis pilosa (Linnaeus) Palisot de Beauvois',1,'Eragrostis pilosa','Eragrostis pilosa','Eragrostis pilos',2,0,'','','Linnaeus|Palisot de Beauvois','ce9dae7c-23ae-5204-865f-a8c5d9fe8def','Eragrostis pilosa (Linnaeus) Palisot de Beauvois','(Linnaeus) Palisot de Beauvois','SPECIES','','Eragrostis','','pilosa','','','',NULL,'Palisot de Beauvois','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30308','','','Sporobolus subsect. Floridani P.M. Peterson',2,'Floridani','Sporobolus subsect. Floridani','Floridani',1,0,'','','P. M. Peterson','d912b75c-8f76-5d27-a4f9-84613d2ac3fd','Sporobolus subsect. Floridani P.M. Peterson','P.M. Peterson','SUBSECTION','Floridani','','','','','','',NULL,'','','','','','P. M. Peterson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30304','','','Sporobolus sect. Clandestini P.M. Peterson',2,'Clandestini','Sporobolus sect. Clandestini','Clandestini',1,0,'','','P. M. Peterson','982a6794-57a9-5c1b-bd72-9acaccf6931c','Sporobolus sect. Clandestini P.M. Peterson','P.M. Peterson','SECTION','Clandestini','','','','','','',NULL,'','','','','','P. M. Peterson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7976','','','Sporobolus vaginiflorus (Torrey ex A. Gray) Alph. Wood var. vaginiflorus',2,'Sporobolus vaginiflorus vaginiflorus','Sporobolus vaginiflorus var. vaginiflorus','Sporobolus uaginiflor uaginiflor',3,0,'','','','2f2126b2-51ab-5912-9ed7-e95acd92e3bf','Sporobolus vaginiflorus (Torrey ex A. Gray) Alph. Wood var. vaginiflorus','(Torrey ex A. Gray) Alph. Wood','VARIETY','','Sporobolus','','vaginiflorus','vaginiflorus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30306','','','Sporobolus sect. Cryptandri P.M. Peterson',2,'Cryptandri','Sporobolus sect. Cryptandri','Cryptandri',1,0,'','','P. M. Peterson','84b1de95-b162-5449-887c-5bb71bd6da2d','Sporobolus sect. Cryptandri P.M. Peterson','P.M. Peterson','SECTION','Cryptandri','','','','','','',NULL,'','','','','','P. M. Peterson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30315','','','Sporobolus subsect. Alterniflori P.M. Peterson & Saarela',2,'Alterniflori','Sporobolus subsect. Alterniflori','Alterniflori',1,0,'','','P. M. Peterson|Saarela','36cb51ef-fb8a-55eb-aaef-f034be49f028','Sporobolus subsect. Alterniflori P.M. Peterson & Saarela','P.M. Peterson & Saarela','SUBSECTION','Alterniflori','','','','','','',NULL,'','','','','','P. M. Peterson & Saarela','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30319','','','Sporobolus ×townsendii (H. Groves & J. Groves) P.M. Peterson & Saarela',3,'','','',NULL,NULL,'','','','','Sporobolus ×townsendii (H. Groves & J. Groves) P.M. Peterson & Saarela','(H. Groves & J. Groves) P.M. Peterson & Saarela','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30323','','','Sporobolus pumilus (Roth) P.M. Peterson & Saarela',1,'Sporobolus pumilus','Sporobolus pumilus','Sporobolus pumil',2,0,'','','Roth|P. M. Peterson|Saarela','11a79542-4dc9-5a9a-ab59-690556bd6336','Sporobolus pumilus (Roth) P.M. Peterson & Saarela','(Roth) P.M. Peterson & Saarela','SPECIES','','Sporobolus','','pumilus','','','',NULL,'P. M. Peterson & Saarela','','','','','Roth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('532','','','Danthonieae Zotov',1,'Danthonieae','Danthonieae','Danthonieae',1,0,'','','Zotov','db8ea44c-e350-53f2-84ec-5798c68d4e73','Danthonieae Zotov','Zotov','TRIBE','Danthonieae','','','','','','',NULL,'','','','','','Zotov','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7521','','','Danthonia decumbens (Linnaeus) de Candolle',1,'Danthonia decumbens','Danthonia decumbens','Danthonia decumbens',2,0,'','','Linnaeus|de Candolle','418b9ed5-31a2-52fb-b49a-6c6a472448fe','Danthonia decumbens (Linnaeus) de Candolle','(Linnaeus) de Candolle','SPECIES','','Danthonia','','decumbens','','','',NULL,'de Candolle','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7523','','','Danthonia intermedia Vasey',1,'Danthonia intermedia','Danthonia intermedia','Danthonia intermed',2,0,'','','Vasey','f767159c-0847-5185-8586-26b99a2a0bfd','Danthonia intermedia Vasey','Vasey','SPECIES','','Danthonia','','intermedia','','','',NULL,'','','','','','Vasey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('426','','','Andropogoneae Dumortier',1,'Andropogoneae','Andropogoneae','Andropogoneae',1,0,'','','Dumortier','d409e7a3-86cc-5adb-a2b9-5db9da00a4cb','Andropogoneae Dumortier','Dumortier','TRIBE','Andropogoneae','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('820','','','Andropogon Linnaeus',1,'Andropogon','Andropogon','Andropogon',1,0,'','','Linnaeus','3b81c3cc-d31a-5a97-81fb-b95d4b1d0c35','Andropogon Linnaeus','Linnaeus','GENUS','Andropogon','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7944','','','Schizachyrium scoparium (Michaux) Nash',1,'Schizachyrium scoparium','Schizachyrium scoparium','Schizachyrium scopari',2,0,'','','Michaux|Nash','c190b818-470d-5ce5-9c17-34a8457e22ca','Schizachyrium scoparium (Michaux) Nash','(Michaux) Nash','SPECIES','','Schizachyrium','','scoparium','','','',NULL,'Nash','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34118','','','Microstegium Nees',1,'Microstegium','Microstegium','Microstegium',1,0,'','','Nees','be8817f4-5f6a-5c82-ba60-7fe940508831','Microstegium Nees','Nees','GENUS','Microstegium','','','','','','',NULL,'','','','','','Nees','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('753','','','Sorghinae Clayton & Renvoize',1,'Sorghinae','Sorghinae','Sorghinae',1,0,'','','Clayton|Renvoize','a557cb33-5e7e-5f86-83d9-1ffdaecaedac','Sorghinae Clayton & Renvoize','Clayton & Renvoize','SUBTRIBE','Sorghinae','','','','','','',NULL,'','','','','','Clayton & Renvoize','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('757','','','Tripsacinae Dumortier',1,'Tripsacinae','Tripsacinae','Tripsacinae',1,0,'','','Dumortier','bcccd3e4-4a50-542b-9482-d1d795de451e','Tripsacinae Dumortier','Dumortier','SUBTRIBE','Tripsacinae','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('493','','','Paniceae R. Brown',1,'Paniceae','Paniceae','Paniceae',1,0,'','','R. Brown','4f78202a-d531-588c-a5d3-c6d14262b78d','Paniceae R. Brown','R. Brown','TRIBE','Paniceae','','','','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1093','','','Dichanthelium (Hitchcock & Chase) Gould',1,'Dichanthelium','Dichanthelium','Dichanthelium',1,0,'','','Hitchcock|Chase|Gould','185815f0-97c0-5653-93e0-fa5206bafade','Dichanthelium (Hitchcock & Chase) Gould','(Hitchcock & Chase) Gould','GENUS','Dichanthelium','','','','','','',NULL,'Gould','','','','','Hitchcock & Chase','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7559','','','Dichanthelium oligosanthes (Schultes) Gould',1,'Dichanthelium oligosanthes','Dichanthelium oligosanthes','Dichanthelium oligosanth',2,0,'','','Schultes|Gould','4697e775-bed4-5cb5-9e01-21246ef6baac','Dichanthelium oligosanthes (Schultes) Gould','(Schultes) Gould','SPECIES','','Dichanthelium','','oligosanthes','','','',NULL,'Gould','','','','','Schultes','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7542','','','Dichanthelium acuminatum (Swartz) Gould & C.A. Clark',1,'Dichanthelium acuminatum','Dichanthelium acuminatum','Dichanthelium acuminat',2,0,'','','Swartz|Gould|C. A. Clark','8fdf42a4-3ac1-5df1-9d60-78cd02bf822a','Dichanthelium acuminatum (Swartz) Gould & C.A. Clark','(Swartz) Gould & C.A. Clark','SPECIES','','Dichanthelium','','acuminatum','','','',NULL,'Gould & C. A. Clark','','','','','Swartz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30443','','','Dichanthelium meridionale (Ashe) Freckmann',1,'Dichanthelium meridionale','Dichanthelium meridionale','Dichanthelium meridional',2,0,'','','Ashe|Freckmann','08d86f87-e451-5d4f-972e-c81e72efc4b3','Dichanthelium meridionale (Ashe) Freckmann','(Ashe) Freckmann','SPECIES','','Dichanthelium','','meridionale','','','',NULL,'Freckmann','','','','','Ashe','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('18325','','','Dichanthelium spretum (Schultes) Freckmann',1,'Dichanthelium spretum','Dichanthelium spretum','Dichanthelium spret',2,0,'','','Schultes|Freckmann','4bdbde26-1752-5fa0-98b8-880df1f39095','Dichanthelium spretum (Schultes) Freckmann','(Schultes) Freckmann','SPECIES','','Dichanthelium','','spretum','','','',NULL,'Freckmann','','','','','Schultes','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31393','','','Dichanthelium portoricense (Desvaux ex Hamilton) B.F. Hansen & Wunderlin',2,'Dichanthelium portoricense','Dichanthelium portoricense','Dichanthelium portoricens',2,0,'','','Desvaux|Hamilton|B. F. Hansen|Wunderlin','18785277-8538-512a-8566-36fc6949aa52','Dichanthelium portoricense (Desvaux ex Hamilton) B.F. Hansen & Wunderlin','(Desvaux ex Hamilton) B.F. Hansen & Wunderlin','SPECIES','','Dichanthelium','','portoricense','','','',NULL,'B. F. Hansen & Wunderlin','','','','','Desvaux','','Hamilton','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7565','','','Dichanthelium sphaerocarpon (Elliott) Gould',1,'Dichanthelium sphaerocarpon','Dichanthelium sphaerocarpon','Dichanthelium sphaerocarpon',2,0,'','','Elliott|Gould','0128c362-13d9-5b0c-a7b0-e4785e573508','Dichanthelium sphaerocarpon (Elliott) Gould','(Elliott) Gould','SPECIES','','Dichanthelium','','sphaerocarpon','','','',NULL,'Gould','','','','','Elliott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7573','','','Echinochloa colona (Linnaeus) Link',1,'Echinochloa colona','Echinochloa colona','Echinochloa colon',2,0,'','','Linnaeus|Link','5e4b4308-ff13-5e02-be34-026667c1bae0','Echinochloa colona (Linnaeus) Link','(Linnaeus) Link','SPECIES','','Echinochloa','','colona','','','',NULL,'Link','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7577','','','Echinochloa frumentacea Link',1,'Echinochloa frumentacea','Echinochloa frumentacea','Echinochloa frumentace',2,0,'','','Link','51f2b1e2-ae87-5a09-8a98-039c57616706','Echinochloa frumentacea Link','Link','SPECIES','','Echinochloa','','frumentacea','','','',NULL,'','','','','','Link','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7578','','','Echinochloa muricata var. microstachya Wiegand',1,'Echinochloa muricata microstachya','Echinochloa muricata var. microstachya','Echinochloa muricat microstachy',3,0,'','','Wiegand','1b6da362-f678-5c4a-92b3-8fbb22146598','Echinochloa muricata var. microstachya Wiegand','Wiegand','VARIETY','','Echinochloa','','muricata','microstachya','','',NULL,'','','','','','Wiegand','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7580','','','Echinochloa muricata (Palisot de Beauvois) Fernald var. muricata',1,'Echinochloa muricata muricata','Echinochloa muricata var. muricata','Echinochloa muricat muricat',3,0,'','','','7564c4e3-33e5-5031-8fd0-f2eb86a1c3e3','Echinochloa muricata (Palisot de Beauvois) Fernald var. muricata','(Palisot de Beauvois) Fernald','VARIETY','','Echinochloa','','muricata','muricata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30570','','','Panicum miliaceum subsp. ruderale (Kitagawa) Tzvelev',1,'Panicum miliaceum ruderale','Panicum miliaceum subsp. ruderale','Panicum miliace ruderal',3,0,'','','Kitagawa|Tzvelev','0b94d06e-d3b4-5197-975c-a704cbd858b7','Panicum miliaceum subsp. ruderale (Kitagawa) Tzvelev','(Kitagawa) Tzvelev','SUBSPECIES','','Panicum','','miliaceum','ruderale','','',NULL,'Tzvelev','','','','','Kitagawa','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7804','','','Panicum hirticaule subsp. sonorum (Beal) Freckmann & Lelong',1,'Panicum hirticaule sonorum','Panicum hirticaule subsp. sonorum','Panicum hirticaul sonor',3,0,'','','Beal|Freckmann|Lelong','215c3f70-fa93-54e8-9398-d340a9d09a38','Panicum hirticaule subsp. sonorum (Beal) Freckmann & Lelong','(Beal) Freckmann & Lelong','SUBSPECIES','','Panicum','','hirticaule','sonorum','','',NULL,'Freckmann & Lelong','','','','','Beal','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24000','','','Panicum sect. Repentia Stapf',2,'Repentia','Panicum sect. Repentia','Repentia',1,0,'','','Stapf','4a6b333c-23aa-500a-9266-0bd515f32fb8','Panicum sect. Repentia Stapf','Stapf','SECTION','Repentia','','','','','','',NULL,'','','','','','Stapf','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25637','','','Coleataenia longifolia (Torrey) Soreng',1,'Coleataenia longifolia','Coleataenia longifolia','Coleataenia longifol',2,0,'','','Torrey|Soreng','d6556118-329c-5bd4-a0ba-381909586698','Coleataenia longifolia (Torrey) Soreng','(Torrey) Soreng','SPECIES','','Coleataenia','','longifolia','','','',NULL,'Soreng','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1096','','','Digitaria Haller',1,'Digitaria','Digitaria','Digitaria',1,0,'','','Haller','8d74e1d8-b844-51e9-aadc-599e4277e1ff','Digitaria Haller','Haller','GENUS','Digitaria','','','','','','',NULL,'','','','','','Haller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('748','','','Paspalinae Grisebach',1,'Paspalinae','Paspalinae','Paspalinae',1,0,'','','Grisebach','04c40df2-4746-5a99-922f-2ad920f3127e','Paspalinae Grisebach','Grisebach','SUBTRIBE','Paspalinae','','','','','','',NULL,'','','','','','Grisebach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7816','','','Paspalum setaceum var. muhlenbergii (Nash) D.J. Banks',1,'Paspalum setaceum muhlenbergii','Paspalum setaceum var. muhlenbergii','Paspalum setace muhlenberg',3,0,'','','Nash|D. J. Banks','11fe2cb0-125a-54ee-9952-3bf9f6eeaf8d','Paspalum setaceum var. muhlenbergii (Nash) D.J. Banks','(Nash) D.J. Banks','VARIETY','','Paspalum','','setaceum','muhlenbergii','','',NULL,'D. J. Banks','','','','','Nash','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9636','','','Setaria verticilliformis Dumortier',1,'Setaria verticilliformis','Setaria verticilliformis','Setaria uerticilliform',2,0,'','','Dumortier','2dcd4081-c2fd-5dc5-8424-4576b09949a3','Setaria verticilliformis Dumortier','Dumortier','SPECIES','','Setaria','','verticilliformis','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7949','','','Setaria italica (Linnaeus) Palisot de Beauvois',1,'Setaria italica','Setaria italica','Setaria italic',2,0,'','','Linnaeus|Palisot de Beauvois','6d1c64c6-06c9-5c1e-abf3-231820dc767e','Setaria italica (Linnaeus) Palisot de Beauvois','(Linnaeus) Palisot de Beauvois','SPECIES','','Setaria','','italica','','','',NULL,'Palisot de Beauvois','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9627','','','Eriochloa villosa (Thunberg) Kunth',1,'Eriochloa villosa','Eriochloa villosa','Eriochloa uillos',2,0,'','','Thunberg|Kunth','120964ea-194f-5dd9-857b-0fe35cff8f0a','Eriochloa villosa (Thunberg) Kunth','(Thunberg) Kunth','SPECIES','','Eriochloa','','villosa','','','',NULL,'Kunth','','','','','Thunberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('258','','','Pooideae Bentham',1,'Pooideae','Pooideae','Pooideae',1,0,'','','Bentham','01d96919-31d0-5d2c-893d-fa2922090012','Pooideae Bentham','Bentham','SUBFAMILY','Pooideae','','','','','','',NULL,'','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('909','','','Brachyelytrum P. Beauvois',1,'Brachyelytrum','Brachyelytrum','Brachyelytrum',1,0,'','','P. Beauvois','87f1858f-43bd-5d4d-883e-b4411d24bc69','Brachyelytrum P. Beauvois','P. Beauvois','GENUS','Brachyelytrum','','','','','','',NULL,'','','','','','P. Beauvois','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1967','','','Brachypodium P. Beauvois',1,'Brachypodium','Brachypodium','Brachypodium',1,0,'','','P. Beauvois','db7d193f-906e-57cd-9b0e-08a878c374d8','Brachypodium P. Beauvois','P. Beauvois','GENUS','Brachypodium','','','','','','',NULL,'','','','','','P. Beauvois','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2217','','','Bromus sect. Ceratochloa (P. Beauvais) Grisebach',2,'Ceratochloa','Bromus sect. Ceratochloa','Ceratochloa',1,0,'','','P. Beauvais|Grisebach','8bf09e48-4253-5f5b-8ee1-daa28f83152b','Bromus sect. Ceratochloa (P. Beauvais) Grisebach','(P. Beauvais) Grisebach','SECTION','Ceratochloa','','','','','','',NULL,'Grisebach','','','','','P. Beauvais','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('18153','','','Bromus sitchensis Trinius var. sitchensis',1,'Bromus sitchensis sitchensis','Bromus sitchensis var. sitchensis','Bromus sitchens sitchens',3,0,'','','','a80192c8-7a3e-50fe-aa2e-553c5188edf0','Bromus sitchensis Trinius var. sitchensis','Trinius','VARIETY','','Bromus','','sitchensis','sitchensis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30334','','','Bromus sitchensis var. polyanthus (Scribner ex Shear) R.E. Brainerd & Otting',2,'Bromus sitchensis polyanthus','Bromus sitchensis var. polyanthus','Bromus sitchens polyanth',3,0,'','','Scribner|Shear|R. E. Brainerd|Otting','f7a55e67-9b75-5b96-8a97-72961ba79d24','Bromus sitchensis var. polyanthus (Scribner ex Shear) R.E. Brainerd & Otting','(Scribner ex Shear) R.E. Brainerd & Otting','VARIETY','','Bromus','','sitchensis','polyanthus','','',NULL,'R. E. Brainerd & Otting','','','','','Scribner','','Shear','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7478','','','Bromus secalinus Linnaeus',1,'Bromus secalinus','Bromus secalinus','Bromus secalin',2,0,'','','Linnaeus','03086fe7-7132-536b-953d-2f0371b8e9a3','Bromus secalinus Linnaeus','Linnaeus','SPECIES','','Bromus','','secalinus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7459','','','Bromus hordeaceus Linnaeus',1,'Bromus hordeaceus','Bromus hordeaceus','Bromus hordeace',2,0,'','','Linnaeus','26f4a0e3-c1da-5d8d-99f4-d14fc319dec0','Bromus hordeaceus Linnaeus','Linnaeus','SPECIES','','Bromus','','hordeaceus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7458','','','Bromus hordeaceus Linnaeus subsp. hordeaceus',1,'Bromus hordeaceus hordeaceus','Bromus hordeaceus subsp. hordeaceus','Bromus hordeace hordeace',3,0,'','','','64f1ca12-c5ee-5718-beed-19657411f8a2','Bromus hordeaceus Linnaeus subsp. hordeaceus','Linnaeus','SUBSPECIES','','Bromus','','hordeaceus','hordeaceus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2219','','','Bromus sect. Bromopsis Dumortier',2,'Bromopsis','Bromus sect. Bromopsis','Bromopsis',1,0,'','','Dumortier','1096e704-c156-5fb2-bf98-9ef84bdab01a','Bromus sect. Bromopsis Dumortier','Dumortier','SECTION','Bromopsis','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7453','','','Bromus ciliatus Linnaeus',1,'Bromus ciliatus','Bromus ciliatus','Bromus ciliat',2,0,'','','Linnaeus','9917ba99-9f89-5edb-8bde-dedd11462eb6','Bromus ciliatus Linnaeus','Linnaeus','SPECIES','','Bromus','','ciliatus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7466','','','Bromus latiglumis (Scribner ex Shear) Hitchcock',2,'Bromus latiglumis','Bromus latiglumis','Bromus latiglum',2,0,'','','Scribner|Shear|Hitchcock','431d602b-f17a-5393-9c0f-16acbe203b96','Bromus latiglumis (Scribner ex Shear) Hitchcock','(Scribner ex Shear) Hitchcock','SPECIES','','Bromus','','latiglumis','','','',NULL,'Hitchcock','','','','','Scribner','','Shear','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7476','','','Bromus richardsonii Link',1,'Bromus richardsonii','Bromus richardsonii','Bromus richardson',2,0,'','','Link','af3a4e3a-4098-52ad-8671-bafb914fb772','Bromus richardsonii Link','Link','SPECIES','','Bromus','','richardsonii','','','',NULL,'','','','','','Link','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28785','','','Bromus riparius Rehmann',1,'Bromus riparius','Bromus riparius','Bromus ripar',2,0,'','','Rehmann','31e24915-8445-556c-8fac-24d917a5e779','Bromus riparius Rehmann','Rehmann','SPECIES','','Bromus','','riparius','','','',NULL,'','','','','','Rehmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7481','','','Bromus sterilis Linnaeus',1,'Bromus sterilis','Bromus sterilis','Bromus steril',2,0,'','','Linnaeus','7814625a-9728-5c4a-8086-fa3104a9525b','Bromus sterilis Linnaeus','Linnaeus','SPECIES','','Bromus','','sterilis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('568','','','Meliceae (Link) Endlicher',2,'Meliceae','Meliceae','Meliceae',1,0,'','','Link|Endlicher','037208c4-31c2-50aa-8580-cd7640a34a5d','Meliceae (Link) Endlicher','(Link) Endlicher','TRIBE','Meliceae','','','','','','',NULL,'Endlicher','','','','','Link','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7696','','','Glyceria declinata Brébisson',1,'Glyceria declinata','Glyceria declinata','Glyceria declinat',2,0,'','','Brébisson','ac463474-a4a1-5f02-afd6-9d8813cf215b','Glyceria declinata Brébisson','Brébisson','SPECIES','','Glyceria','','declinata','','','',NULL,'','','','','','Brébisson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7697','','','Glyceria elata (Nash) M.E. Jones',1,'Glyceria elata','Glyceria elata','Glyceria elat',2,0,'','','Nash|M. E. Jones','e6d3a9ff-f17a-535c-9fa5-98cfa5adec66','Glyceria elata (Nash) M.E. Jones','(Nash) M.E. Jones','SPECIES','','Glyceria','','elata','','','',NULL,'M. E. Jones','','','','','Nash','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7694','','','Glyceria canadensis (Michaux) Trinius var. canadensis',1,'Glyceria canadensis canadensis','Glyceria canadensis var. canadensis','Glyceria canadens canadens',3,0,'','','','17235f0f-cd43-5fd2-8c7b-e5786ed608dc','Glyceria canadensis (Michaux) Trinius var. canadensis','(Michaux) Trinius','VARIETY','','Glyceria','','canadensis','canadensis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7700','','','Glyceria grandis S. Watson',1,'Glyceria grandis','Glyceria grandis','Glyceria grand',2,0,'','','S. Watson','85d52699-a11c-5b18-8f46-b7fe9fa9e138','Glyceria grandis S. Watson','S. Watson','SPECIES','','Glyceria','','grandis','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7764','','','Melica bulbosa Geyer ex Porter & J.M. Coulter',2,'Melica bulbosa','Melica bulbosa','Melica bulbos',2,0,'','','Geyer|Porter|J. M. Coulter','5a895a22-6bed-543f-83a3-749e2deeea58','Melica bulbosa Geyer ex Porter & J.M. Coulter','Geyer ex Porter & J.M. Coulter','SPECIES','','Melica','','bulbosa','','','',NULL,'','','','','','Geyer','','Porter & J. M. Coulter','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1563','','','Pleuropogon R. Brown',1,'Pleuropogon','Pleuropogon','Pleuropogon',1,0,'','','R. Brown','5f7db210-12ac-5e81-b683-719120acc3ae','Pleuropogon R. Brown','R. Brown','GENUS','Pleuropogon','','','','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('628','','','Nardeae W.D.J. Koch',1,'Nardeae','Nardeae','Nardeae',1,0,'','','W. D. J. Koch','4b41ba5c-d15a-5c39-a54d-d09518b5319f','Nardeae W.D.J. Koch','W.D.J. Koch','TRIBE','Nardeae','','','','','','',NULL,'','','','','','W. D. J. Koch','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7794','','','Nardus stricta Linnaeus',1,'Nardus stricta','Nardus stricta','Nardus strict',2,0,'','','Linnaeus','5556ed55-f96d-519a-8856-dcb5a042936b','Nardus stricta Linnaeus','Linnaeus','SPECIES','','Nardus','','stricta','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7376','','','Agrostis vinealis Schreber',1,'Agrostis vinealis','Agrostis vinealis','Agrostis uineal',2,0,'','','Schreber','2c8d02fb-5447-55ef-bf23-956da66dd6a7','Agrostis vinealis Schreber','Schreber','SPECIES','','Agrostis','','vinealis','','','',NULL,'','','','','','Schreber','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7379','','','Agrostis microphylla Steudel',1,'Agrostis microphylla','Agrostis microphylla','Agrostis microphyll',2,0,'','','Steudel','eac07229-a4f5-5cfc-a6d9-08e4dac31f58','Agrostis microphylla Steudel','Steudel','SPECIES','','Agrostis','','microphylla','','','',NULL,'','','','','','Steudel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7383','','','Agrostis scabra Willdenow',1,'Agrostis scabra','Agrostis scabra','Agrostis scabr',2,0,'','','Willdenow','cd1a100d-841f-5155-b9ee-43b1fe51ec6d','Agrostis scabra Willdenow','Willdenow','SPECIES','','Agrostis','','scabra','','','',NULL,'','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7491','','','Calamagrostis deschampsioides Trinius',1,'Calamagrostis deschampsioides','Calamagrostis deschampsioides','Calamagrostis deschampsioid',2,0,'','','Trinius','a887ffff-f1c2-5c41-8fa7-242d4f284558','Calamagrostis deschampsioides Trinius','Trinius','SPECIES','','Calamagrostis','','deschampsioides','','','',NULL,'','','','','','Trinius','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7495','','','Calamagrostis nutkaensis (J. Presl) Steudel',1,'Calamagrostis nutkaensis','Calamagrostis nutkaensis','Calamagrostis nutkaens',2,0,'','','J. Presl|Steudel','09edaf36-ff0e-500e-a806-e1a01a2459c1','Calamagrostis nutkaensis (J. Presl) Steudel','(J. Presl) Steudel','SPECIES','','Calamagrostis','','nutkaensis','','','',NULL,'Steudel','','','','','J. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7487','','','Calamagrostis canadensis (Michaux) Palisot de Beauvois',1,'Calamagrostis canadensis','Calamagrostis canadensis','Calamagrostis canadens',2,0,'','','Michaux|Palisot de Beauvois','54cb2d54-7cf8-597e-98ae-68fa4c86513b','Calamagrostis canadensis (Michaux) Palisot de Beauvois','(Michaux) Palisot de Beauvois','SPECIES','','Calamagrostis','','canadensis','','','',NULL,'Palisot de Beauvois','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7501','','','Calamagrostis stricta (Timm) Koeler',1,'Calamagrostis stricta','Calamagrostis stricta','Calamagrostis strict',2,0,'','','Timm|Koeler','f42bd94a-1ab6-567c-8437-cf0589aaeed6','Calamagrostis stricta (Timm) Koeler','(Timm) Koeler','SPECIES','','Calamagrostis','','stricta','','','',NULL,'Koeler','','','','','Timm','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1580','','','Polypogon Desfontaines',1,'Polypogon','Polypogon','Polypogon',1,0,'','','Desfontaines','42fefd76-f46e-5589-ba6b-d8f322ba7356','Polypogon Desfontaines','Desfontaines','GENUS','Polypogon','','','','','','',NULL,'','','','','','Desfontaines','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7918','','','Polypogon viridis (Gouan) Breistroffer',1,'Polypogon viridis','Polypogon viridis','Polypogon uirid',2,0,'','','Gouan|Breistroffer','2ae3d681-9735-5920-8145-6d4bb524b189','Polypogon viridis (Gouan) Breistroffer','(Gouan) Breistroffer','SPECIES','','Polypogon','','viridis','','','',NULL,'Breistroffer','','','','','Gouan','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7915','','','Podagrostis aequivalvis (Trinius) Scribner & Merrill',1,'Podagrostis aequivalvis','Podagrostis aequivalvis','Podagrostis aequiualu',2,0,'','','Trinius|Scribner|Merrill','a6358775-479e-5264-95ba-f15a375556cd','Podagrostis aequivalvis (Trinius) Scribner & Merrill','(Trinius) Scribner & Merrill','SPECIES','','Podagrostis','','aequivalvis','','','',NULL,'Scribner & Merrill','','','','','Trinius','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8013','','','×Agropogon lutosus (Poiret) P. Fournier',3,'','','',NULL,NULL,'','','','','×Agropogon lutosus (Poiret) P. Fournier','(Poiret) P. Fournier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('794','','','Aira Linnaeus',1,'Aira','Aira','Aira',1,0,'','','Linnaeus','a9c8aaf8-bb17-5f0d-beb0-6e4ae8f40bf4','Aira Linnaeus','Linnaeus','GENUS','Aira','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7387','','','Aira praecox Linnaeus',1,'Aira praecox','Aira praecox','Aira praecox',2,0,'','','Linnaeus','e44d03d2-97ea-5d3b-acd3-e724163819a9','Aira praecox Linnaeus','Linnaeus','SPECIES','','Aira','','praecox','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7537','','','Deschampsia mackenzieana Raup',1,'Deschampsia mackenzieana','Deschampsia mackenzieana','Deschampsia mackenziean',2,0,'','','Raup','7074fca4-e9d7-5fe1-8a76-54cddeb9cb18','Deschampsia mackenzieana Raup','Raup','SPECIES','','Deschampsia','','mackenzieana','','','',NULL,'','','','','','Raup','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32795','','','Deschampsia cespitosa subsp. neoalpina Chiapella, Xue & Greimler',1,'Deschampsia cespitosa neoalpina','Deschampsia cespitosa subsp. neoalpina','Deschampsia cespitos neoalpin',3,0,'','','Chiapella|Xue|Greimler','55d50530-3b99-5342-abe2-c0e4a95c93cb','Deschampsia cespitosa subsp. neoalpina Chiapella, Xue & Greimler','Chiapella, Xue & Greimler','SUBSPECIES','','Deschampsia','','cespitosa','neoalpina','','',NULL,'','','','','','Chiapella, Xue & Greimler','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7438','','','Avenula pubescens (Hudson) Dumortier',1,'Avenula pubescens','Avenula pubescens','Avenula pubescens',2,0,'','','Hudson|Dumortier','b7e7c0d4-6276-555b-9340-464a293ba23f','Avenula pubescens (Hudson) Dumortier','(Hudson) Dumortier','SPECIES','','Avenula','','pubescens','','','',NULL,'Dumortier','','','','','Hudson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30295','','','Helictochloa hookeri (Scribner) Romero Zarco',1,'Helictochloa hookeri','Helictochloa hookeri','Helictochloa hooker',2,0,'','','Scribner|Romero Zarco','5097d6b2-4a19-58c9-820d-50d34f1bfaa3','Helictochloa hookeri (Scribner) Romero Zarco','(Scribner) Romero Zarco','SPECIES','','Helictochloa','','hookeri','','','',NULL,'Romero Zarco','','','','','Scribner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7392','','','Alopecurus carolinianus Walter',1,'Alopecurus carolinianus','Alopecurus carolinianus','Alopecurus carolinian',2,0,'','','Walter','446ffb19-f457-5977-9c55-4317b7020c8b','Alopecurus carolinianus Walter','Walter','SPECIES','','Alopecurus','','carolinianus','','','',NULL,'','','','','','Walter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7439','','','Beckmannia syzigachne (Steudel) Fernald',1,'Beckmannia syzigachne','Beckmannia syzigachne','Beckmannia syzigachn',2,0,'','','Steudel|Fernald','7b916898-e79c-53ef-b1b3-05a8d0fbc59c','Beckmannia syzigachne (Steudel) Fernald','(Steudel) Fernald','SPECIES','','Beckmannia','','syzigachne','','','',NULL,'Fernald','','','','','Steudel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7406','','','Anthoxanthum aristatum Boissier subsp. aristatum',1,'Anthoxanthum aristatum aristatum','Anthoxanthum aristatum subsp. aristatum','Anthoxanthum aristat aristat',3,0,'','','','f0156c67-1e6b-5466-8037-a1808ec06c63','Anthoxanthum aristatum Boissier subsp. aristatum','Boissier','SUBSPECIES','','Anthoxanthum','','aristatum','aristatum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7410','','','Anthoxanthum monticola (Bigelow) Veldkamp subsp. monticola',1,'Anthoxanthum monticola monticola','Anthoxanthum monticola subsp. monticola','Anthoxanthum monticol monticol',3,0,'','','','8547c61c-c129-5a8b-9ba8-c782883da91e','Anthoxanthum monticola (Bigelow) Veldkamp subsp. monticola','(Bigelow) Veldkamp','SUBSPECIES','','Anthoxanthum','','monticola','monticola','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7818','','','Phalaris arundinacea Linnaeus',1,'Phalaris arundinacea','Phalaris arundinacea','Phalaris arundinace',2,0,'','','Linnaeus','f414fb7f-1f79-5216-939c-22d7e301e4d3','Phalaris arundinacea Linnaeus','Linnaeus','SPECIES','','Phalaris','','arundinacea','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7819','','','Phalaris canariensis Linnaeus',1,'Phalaris canariensis','Phalaris canariensis','Phalaris canariens',2,0,'','','Linnaeus','b4d4a272-d6e4-5e9d-b237-caf614014373','Phalaris canariensis Linnaeus','Linnaeus','SPECIES','','Phalaris','','canariensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7416','','','Arctagrostis latifolia subsp. arundinacea (Trinius) Tzelev',1,'Arctagrostis latifolia arundinacea','Arctagrostis latifolia subsp. arundinacea','Arctagrostis latifol arundinace',3,0,'','','Trinius|Tzelev','9bf5965f-ab2f-5640-b376-484e65842938','Arctagrostis latifolia subsp. arundinacea (Trinius) Tzelev','(Trinius) Tzelev','SUBSPECIES','','Arctagrostis','','latifolia','arundinacea','','',NULL,'Tzelev','','','','','Trinius','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7572','','','Dupontia fisheri R. Brown',1,'Dupontia fisheri','Dupontia fisheri','Dupontia fisher',2,0,'','','R. Brown','62d745ab-bf3a-5a90-b7dc-07bcc2fab6ae','Dupontia fisheri R. Brown','R. Brown','SPECIES','','Dupontia','','fisheri','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7882','','','Poa lettermanii Vasey',1,'Poa lettermanii','Poa lettermanii','Poa letterman',2,0,'','','Vasey','1f95ea08-6db1-52c0-bb2b-328c76b444cd','Poa lettermanii Vasey','Vasey','SPECIES','','Poa','','lettermanii','','','',NULL,'','','','','','Vasey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7839','','','Poa abbreviata R. Brown',1,'Poa abbreviata','Poa abbreviata','Poa abbreuiat',2,0,'','','R. Brown','ec54d9b8-947c-5d48-aa36-ab6b1861239d','Poa abbreviata R. Brown','R. Brown','SPECIES','','Poa','','abbreviata','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31510','','','Poa flexuosa subsp. consauliae J.L. Gillespie & Soreng',1,'Poa flexuosa consauliae','Poa flexuosa subsp. consauliae','Poa flexuos consauli',3,0,'','','J. L. Gillespie|Soreng','7c936015-6d28-5084-96aa-28669f86fad3','Poa flexuosa subsp. consauliae J.L. Gillespie & Soreng','J.L. Gillespie & Soreng','SUBSPECIES','','Poa','','flexuosa','consauliae','','',NULL,'','','','','','J. L. Gillespie & Soreng','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7842','','','Poa alpina Linnaeus',1,'Poa alpina','Poa alpina','Poa alpin',2,0,'','','Linnaeus','06a40c9e-3cc7-5243-a03c-42c196bc052e','Poa alpina Linnaeus','Linnaeus','SPECIES','','Poa','','alpina','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2230','','','Poa sect. Sylvestres V.L. Marsh ex Soreng',2,'Sylvestres','Poa sect. Sylvestres','Sylvestres',1,0,'','','V. L. Marsh|Soreng','2c177fae-27f3-5b67-b897-c69a1c5a1013','Poa sect. Sylvestres V.L. Marsh ex Soreng','V.L. Marsh ex Soreng','SECTION','Sylvestres','','','','','','',NULL,'','','','','','V. L. Marsh','','Soreng','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7901','','','Poa saltuensis Fernald & Wiegand subsp. saltuensis',1,'Poa saltuensis saltuensis','Poa saltuensis subsp. saltuensis','Poa saltuens saltuens',3,0,'','','','62443f9c-0716-5152-b04e-970ab352c3b2','Poa saltuensis Fernald & Wiegand subsp. saltuensis','Fernald & Wiegand','SUBSPECIES','','Poa','','saltuensis','saltuensis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9878','','','Poa supina Schrader',1,'Poa supina','Poa supina','Poa supin',2,0,'','','Schrader','2ff93a95-ed54-57b0-b086-697a7502cb33','Poa supina Schrader','Schrader','SPECIES','','Poa','','supina','','','',NULL,'','','','','','Schrader','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7845','','','Poa arctica R. Brown subsp. arctica',1,'Poa arctica arctica','Poa arctica subsp. arctica','Poa arctic arctic',3,0,'','','','97a1b820-d7fe-5ccb-8326-444354f40d29','Poa arctica R. Brown subsp. arctica','R. Brown','SUBSPECIES','','Poa','','arctica','arctica','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7895','','','Poa pratensis subsp. angustifolia (Linnaeus) Lejeune',1,'Poa pratensis angustifolia','Poa pratensis subsp. angustifolia','Poa pratens angustifol',3,0,'','','Linnaeus|Lejeune','e62bf96d-0335-531f-9feb-925f021dca6f','Poa pratensis subsp. angustifolia (Linnaeus) Lejeune','(Linnaeus) Lejeune','SUBSPECIES','','Poa','','pratensis','angustifolia','','',NULL,'Lejeune','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7853','','','Poa bulbosa subsp. vivipara (Koeler) Arcangeli',1,'Poa bulbosa vivipara','Poa bulbosa subsp. vivipara','Poa bulbos uiuipar',3,0,'','','Koeler|Arcangeli','6a293858-e6e2-5ded-9cb1-e07c26cc04cf','Poa bulbosa subsp. vivipara (Koeler) Arcangeli','(Koeler) Arcangeli','SUBSPECIES','','Poa','','bulbosa','vivipara','','',NULL,'Arcangeli','','','','','Koeler','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9571','','','Poa ×nematophylla Rydberg',3,'','','',NULL,NULL,'','','','','Poa ×nematophylla Rydberg','Rydberg','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7866','','','Poa fendleriana subsp. longiligula (Scribner & T.A. Williams) Soreng',1,'Poa fendleriana longiligula','Poa fendleriana subsp. longiligula','Poa fendlerian longiligul',3,0,'','','Scribner|T. A. Williams|Soreng','c8647307-04c0-598a-9847-a3edb38d0cec','Poa fendleriana subsp. longiligula (Scribner & T.A. Williams) Soreng','(Scribner & T.A. Williams) Soreng','SUBSPECIES','','Poa','','fendleriana','longiligula','','',NULL,'Soreng','','','','','Scribner & T. A. Williams','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7887','','','Poa nervosa (Hooker) Vasey',1,'Poa nervosa','Poa nervosa','Poa neruos',2,0,'','','Hooker|Vasey','1371fd8c-3d0b-5e9e-986e-3ac8e63e73a5','Poa nervosa (Hooker) Vasey','(Hooker) Vasey','SPECIES','','Poa','','nervosa','','','',NULL,'Vasey','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7886','','','Poa nemoralis Linnaeus',1,'Poa nemoralis','Poa nemoralis','Poa nemoral',2,0,'','','Linnaeus','c4430159-6da3-5d21-abe6-e0c56263f8a0','Poa nemoralis Linnaeus','Linnaeus','SPECIES','','Poa','','nemoralis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7871','','','Poa hartzii Gandoger',1,'Poa hartzii','Poa hartzii','Poa hartz',2,0,'','','Gandoger','aab2855b-2e0e-58b3-ae0d-1d7eb10303a8','Poa hartzii Gandoger','Gandoger','SPECIES','','Poa','','hartzii','','','',NULL,'','','','','','Gandoger','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7905','','','Poa secunda J. Presl subsp. secunda',1,'Poa secunda secunda','Poa secunda subsp. secunda','Poa secund secund',3,0,'','','','4031f24a-415a-5176-bca0-4ee4d2600e24','Poa secunda J. Presl subsp. secunda','J. Presl','SUBSPECIES','','Poa','','secunda','secunda','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2241','','','Poa sect. Pandemos Ascherson & Graebner',2,'Pandemos','Poa sect. Pandemos','Pandemos',1,0,'','','Ascherson|Graebner','6ca22cd5-f857-5fc4-a306-528accb742eb','Poa sect. Pandemos Ascherson & Graebner','Ascherson & Graebner','SECTION','Pandemos','','','','','','',NULL,'','','','','','Ascherson & Graebner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7851','','','Poa arida Vasey',1,'Poa arida','Poa arida','Poa arid',2,0,'','','Vasey','6c9b8b86-2b80-51df-98a7-ca427e322aaa','Poa arida Vasey','Vasey','SPECIES','','Poa','','arida','','','',NULL,'','','','','','Vasey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1943','','','×Arctodupontia Tzvelev',3,'','','',NULL,NULL,'','','','','×Arctodupontia Tzvelev','Tzvelev','GENUS','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1953','','','Eremopoa Roshevitz',1,'Eremopoa','Eremopoa','Eremopoa',1,0,'','','Roshevitz','f101552a-40f2-5c22-9e24-d629a4f3816c','Eremopoa Roshevitz','Roshevitz','GENUS','Eremopoa','','','','','','',NULL,'','','','','','Roshevitz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8015','','','×Duarctopoa labradorica (Steudel) Soreng & L.J. Gillespie',3,'','','',NULL,NULL,'','','','','×Duarctopoa labradorica (Steudel) Soreng & L.J. Gillespie','(Steudel) Soreng & L.J. Gillespie','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7431','','','Arrhenatherum elatius (Linnaeus) P. Beauvois ex J. Presl & C. Presl subsp. elatius',2,'Arrhenatherum elatius elatius','Arrhenatherum elatius subsp. elatius','Arrhenatherum elat elat',3,0,'','','','bf4093d5-cb17-53d9-9b41-e01fa1456c3f','Arrhenatherum elatius (Linnaeus) P. Beauvois ex J. Presl & C. Presl subsp. elatius','(Linnaeus) P. Beauvois ex J. Presl & C. Presl','SUBSPECIES','','Arrhenatherum','','elatius','elatius','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7436','','','Avena sterilis Linnaeus',1,'Avena sterilis','Avena sterilis','Avena steril',2,0,'','','Linnaeus','ba3caca3-3a70-566c-86c4-9a785b6313a3','Avena sterilis Linnaeus','Linnaeus','SPECIES','','Avena','','sterilis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7965','','','Sphenopholis intermedia (Rydberg) Rydberg',1,'Sphenopholis intermedia','Sphenopholis intermedia','Sphenopholis intermed',2,0,'','','Rydberg','c364d65d-c0c5-58b4-b6ef-9361f3368543','Sphenopholis intermedia (Rydberg) Rydberg','(Rydberg) Rydberg','SPECIES','','Sphenopholis','','intermedia','','','',NULL,'Rydberg','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31877','','','Trisetum flavescens (Linnaeus) P. Beauvois subsp. flavescens',1,'Trisetum flavescens flavescens','Trisetum flavescens subsp. flavescens','Trisetum flauescens flauescens',3,0,'','','','a98a2e77-b1e4-5fa1-8481-6c2c85b30946','Trisetum flavescens (Linnaeus) P. Beauvois subsp. flavescens','(Linnaeus) P. Beauvois','SUBSPECIES','','Trisetum','','flavescens','flavescens','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7738','','','Lagurus ovatus Linnaeus',1,'Lagurus ovatus','Lagurus ovatus','Lagurus ouat',2,0,'','','Linnaeus','1742786e-9783-5cb9-9bf3-b02bf901ad4a','Lagurus ovatus Linnaeus','Linnaeus','SPECIES','','Lagurus','','ovatus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24105','','','Graphephorum wolfii (Vasey) Vasey ex Coulter',2,'Graphephorum wolfii','Graphephorum wolfii','Graphephorum wolf',2,0,'','','Vasey|Coulter','500caa7d-fb85-5802-9d63-20ef5778c5dd','Graphephorum wolfii (Vasey) Vasey ex Coulter','(Vasey) Vasey ex Coulter','SPECIES','','Graphephorum','','wolfii','','','',NULL,'Vasey','','Coulter','','','Vasey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32212','','','Sibirotrisetum sibiricum subsp. litorale (Ruprecht ex Roshevitz) Barberá',2,'Sibirotrisetum sibiricum litorale','Sibirotrisetum sibiricum subsp. litorale','Sibirotrisetum sibiric litoral',3,0,'','','Ruprecht|Roshevitz|Barberá','cffec932-64b0-59e7-ab33-0e92090a8568','Sibirotrisetum sibiricum subsp. litorale (Ruprecht ex Roshevitz) Barberá','(Ruprecht ex Roshevitz) Barberá','SUBSPECIES','','Sibirotrisetum','','sibiricum','litorale','','',NULL,'Barberá','','','','','Ruprecht','','Roshevitz','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7445','','','Briza maxima Linnaeus',1,'Briza maxima','Briza maxima','Briza maxim',2,0,'','','Linnaeus','42ebd06f-1672-5a26-ae9c-01a10d2ffaec','Briza maxima Linnaeus','Linnaeus','SPECIES','','Briza','','maxima','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('960','','','Catabrosa P. Beauvois',1,'Catabrosa','Catabrosa','Catabrosa',1,0,'','','P. Beauvois','0f89593a-72a8-5bd4-a3d9-cbc717d99f7c','Catabrosa P. Beauvois','P. Beauvois','GENUS','Catabrosa','','','','','','',NULL,'','','','','','P. Beauvois','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7822','','','Phippsia concinna (Th. Fries) Lindeberg',1,'Phippsia concinna','Phippsia concinna','Phippsia concinn',2,0,'','','Th. Fries|Lindeberg','8f03db59-420c-5418-9681-2d4eda24ca78','Phippsia concinna (Th. Fries) Lindeberg','(Th. Fries) Lindeberg','SPECIES','','Phippsia','','concinna','','','',NULL,'Lindeberg','','','','','Th. Fries','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7926','','','Puccinellia distans (Jacquin) Parlatore',1,'Puccinellia distans','Puccinellia distans','Puccinellia distans',2,0,'','','Jacquin|Parlatore','484c44c0-ac02-5a46-b2e2-3000371c3fa1','Puccinellia distans (Jacquin) Parlatore','(Jacquin) Parlatore','SPECIES','','Puccinellia','','distans','','','',NULL,'Parlatore','','','','','Jacquin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7931','','','Puccinellia lemmonii (Vasey) Scribner',1,'Puccinellia lemmonii','Puccinellia lemmonii','Puccinellia lemmon',2,0,'','','Vasey|Scribner','cc7971a5-60e3-5af2-94c2-aff10925d864','Puccinellia lemmonii (Vasey) Scribner','(Vasey) Scribner','SPECIES','','Puccinellia','','lemmonii','','','',NULL,'Scribner','','','','','Vasey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7936','','','Puccinellia vahliana (Liebmann) Scribner & Merrill',1,'Puccinellia vahliana','Puccinellia vahliana','Puccinellia uahlian',2,0,'','','Liebmann|Scribner|Merrill','a6c50845-d9f6-5ce5-ae0e-5b0981625214','Puccinellia vahliana (Liebmann) Scribner & Merrill','(Liebmann) Scribner & Merrill','SPECIES','','Puccinellia','','vahliana','','','',NULL,'Scribner & Merrill','','','','','Liebmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7929','','','Puccinellia tenella subsp. langeana (Berlin) Tzvelev',1,'Puccinellia tenella langeana','Puccinellia tenella subsp. langeana','Puccinellia tenell langean',3,0,'','','Berlin|Tzvelev','c2c3c517-1797-5d91-8ddc-c8333ab70608','Puccinellia tenella subsp. langeana (Berlin) Tzvelev','(Berlin) Tzvelev','SUBSPECIES','','Puccinellia','','tenella','langeana','','',NULL,'Tzvelev','','','','','Berlin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8022','','','×Pucciphippsia vacillans (Th. Fries) Tzvelev',3,'','','',NULL,NULL,'','','','','×Pucciphippsia vacillans (Th. Fries) Tzvelev','(Th. Fries) Tzvelev','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7511','','','Coleanthus subtilis (Trattinnick) Seidl',1,'Coleanthus subtilis','Coleanthus subtilis','Coleanthus subtil',2,0,'','','Trattinnick|Seidl','e9079f4f-a3cd-5340-b74b-7d72eeecd542','Coleanthus subtilis (Trattinnick) Seidl','(Trattinnick) Seidl','SPECIES','','Coleanthus','','subtilis','','','',NULL,'Seidl','','','','','Trattinnick','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1073','','','Dactylis Linnaeus',1,'Dactylis','Dactylis','Dactylis',1,0,'','','Linnaeus','cd5570dd-1853-5b4f-8297-a7f45c9716b9','Dactylis Linnaeus','Linnaeus','GENUS','Dactylis','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7650','','','Festuca campestris Rydberg',1,'Festuca campestris','Festuca campestris','Festuca campestr',2,0,'','','Rydberg','2c93ccc6-5fd1-518a-9e0e-0bcb8fc025a9','Festuca campestris Rydberg','Rydberg','SPECIES','','Festuca','','campestris','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7645','','','Festuca auriculata Drobow',1,'Festuca auriculata','Festuca auriculata','Festuca auriculat',2,0,'','','Drobow','a9d62444-8f52-5f5d-9c32-5cb9b1923d60','Festuca auriculata Drobow','Drobow','SPECIES','','Festuca','','auriculata','','','',NULL,'','','','','','Drobow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7652','','','Festuca filiformis Pourret',1,'Festuca filiformis','Festuca filiformis','Festuca filiform',2,0,'','','Pourret','b4a5db43-2177-5b65-aa3b-1eae9d605344','Festuca filiformis Pourret','Pourret','SPECIES','','Festuca','','filiformis','','','',NULL,'','','','','','Pourret','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7656','','','Festuca hyperborea Holmen ex Frederiksen',2,'Festuca hyperborea','Festuca hyperborea','Festuca hyperbore',2,0,'','','Holmen|Frederiksen','2c22455d-1717-56a7-a086-bf11039a25e4','Festuca hyperborea Holmen ex Frederiksen','Holmen ex Frederiksen','SPECIES','','Festuca','','hyperborea','','','',NULL,'','','','','','Holmen','','Frederiksen','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7666','','','Festuca pseudovivipara (Pavlick) Pavlick',1,'Festuca pseudovivipara','Festuca pseudovivipara','Festuca pseudouiuipar',2,0,'','','Pavlick','60ce1851-5a6c-5146-868b-5cf2518e76ef','Festuca pseudovivipara (Pavlick) Pavlick','(Pavlick) Pavlick','SPECIES','','Festuca','','pseudovivipara','','','',NULL,'Pavlick','','','','','Pavlick','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7663','','','Festuca prolifera var. lasiolepis Fernald',1,'Festuca prolifera lasiolepis','Festuca prolifera var. lasiolepis','Festuca prolifer lasiolep',3,0,'','','Fernald','8fd67de4-a9e5-5071-8b6f-cc6e589e7672','Festuca prolifera var. lasiolepis Fernald','Fernald','VARIETY','','Festuca','','prolifera','lasiolepis','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7679','','','Festuca saximontana var. purpusiana (Saint-Yves) Frederiksen & Pavlick',1,'Festuca saximontana purpusiana','Festuca saximontana var. purpusiana','Festuca saximontan purpusian',3,0,'','','Saint-Yves|Frederiksen|Pavlick','0d203862-c8dc-5508-8f8a-d891bda24c41','Festuca saximontana var. purpusiana (Saint-Yves) Frederiksen & Pavlick','(Saint-Yves) Frederiksen & Pavlick','VARIETY','','Festuca','','saximontana','purpusiana','','',NULL,'Frederiksen & Pavlick','','','','','Saint-Yves','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7670','','','Festuca rubra subsp. arctica (Hackel) Govorov',1,'Festuca rubra arctica','Festuca rubra subsp. arctica','Festuca rubr arctic',3,0,'','','Hackel|Govorov','767ea383-88ff-51ca-aedd-26647f59a3c0','Festuca rubra subsp. arctica (Hackel) Govorov','(Hackel) Govorov','SUBSPECIES','','Festuca','','rubra','arctica','','',NULL,'Govorov','','','','','Hackel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7671','','','Festuca rubra subsp. aucta (V.I.Krecz. & Bobrov) Hultén',1,'Festuca rubra aucta','Festuca rubra subsp. aucta','Festuca rubr auct',3,0,'','','V. I. Krecz.|Bobrov|Hultén','269414c0-db17-5553-84d9-b11a9e212ef6','Festuca rubra subsp. aucta (V.I.Krecz. & Bobrov) Hultén','(V.I.Krecz. & Bobrov) Hultén','SUBSPECIES','','Festuca','','rubra','aucta','','',NULL,'Hultén','','','','','V. I. Krecz. & Bobrov','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7677','','','Festuca rubra subsp. secunda (J. Presl) Pavlick',1,'Festuca rubra secunda','Festuca rubra subsp. secunda','Festuca rubr secund',3,0,'','','J. Presl|Pavlick','f681a6b3-2f8c-5fae-8250-80214aabc31c','Festuca rubra subsp. secunda (J. Presl) Pavlick','(J. Presl) Pavlick','SUBSPECIES','','Festuca','','rubra','secunda','','',NULL,'Pavlick','','','','','J. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28781','','','Festuca heterophylla Lamarck',1,'Festuca heterophylla','Festuca heterophylla','Festuca heterophyll',2,0,'','','Lamarck','57cd778f-4d42-5544-a488-ab128fa0d47c','Festuca heterophylla Lamarck','Lamarck','SPECIES','','Festuca','','heterophylla','','','',NULL,'','','','','','Lamarck','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2224','','','Festuca sect. Subuliflorae (E.B. Alexeev) Darbyshire',2,'Subuliflorae','Festuca sect. Subuliflorae','Subuliflorae',1,0,'','','E. B. Alexeev|Darbyshire','cc32dd3e-88d4-5429-a1bb-3485e90e944e','Festuca sect. Subuliflorae (E.B. Alexeev) Darbyshire','(E.B. Alexeev) Darbyshire','SECTION','Subuliflorae','','','','','','',NULL,'Darbyshire','','','','','E. B. Alexeev','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7755','','','Lolium multiflorum Lamarck',1,'Lolium multiflorum','Lolium multiflorum','Lolium multiflor',2,0,'','','Lamarck','316ff6e1-1d41-50f5-a22d-de7940c9b16e','Lolium multiflorum Lamarck','Lamarck','SPECIES','','Lolium','','multiflorum','','','',NULL,'','','','','','Lamarck','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('18809','','','Lolium arundinaceum (Schreber) Darbyshire',1,'Lolium arundinaceum','Lolium arundinaceum','Lolium arundinace',2,0,'','','Schreber|Darbyshire','effe6f03-daea-560e-899b-5bc799ca43b5','Lolium arundinaceum (Schreber) Darbyshire','(Schreber) Darbyshire','SPECIES','','Lolium','','arundinaceum','','','',NULL,'Darbyshire','','','','','Schreber','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8009','','','Vulpia octoflora (Walter) Rydberg',1,'Vulpia octoflora','Vulpia octoflora','Vulpia octoflor',2,0,'','','Walter|Rydberg','50069855-ae56-515a-b5bf-8cb64ef4d3b0','Vulpia octoflora (Walter) Rydberg','(Walter) Rydberg','SPECIES','','Vulpia','','octoflora','','','',NULL,'Rydberg','','','','','Walter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1252','','','Holcus Linnaeus',1,'Holcus','Holcus','Holcus',1,0,'','','Linnaeus','0bef618d-7785-5d54-8ac5-cfc5eec5e595','Holcus Linnaeus','Linnaeus','GENUS','Holcus','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1418','','','Milium Linnaeus',1,'Milium','Milium','Milium',1,0,'','','Linnaeus','7601647a-107d-50c2-ae36-272a61891c67','Milium Linnaeus','Linnaeus','GENUS','Milium','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7981','','','Torreyochloa pallida (Torrey) G.L. Church',1,'Torreyochloa pallida','Torreyochloa pallida','Torreyochloa pallid',2,0,'','','Torrey|G. L. Church','ebeda084-2751-5bef-a902-6fe6b7ddbe0e','Torreyochloa pallida (Torrey) G.L. Church','(Torrey) G.L. Church','SPECIES','','Torreyochloa','','pallida','','','',NULL,'G. L. Church','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7770','','','Mibora minima (Linnaeus) Desvaux',1,'Mibora minima','Mibora minima','Mibora minim',2,0,'','','Linnaeus|Desvaux','7dccdbe9-2902-5196-8e5e-9b3a71a40f90','Mibora minima (Linnaeus) Desvaux','(Linnaeus) Desvaux','SPECIES','','Mibora','','minima','','','',NULL,'Desvaux','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1536','','','Phleum Linnaeus',1,'Phleum','Phleum','Phleum',1,0,'','','Linnaeus','7a0e1b29-4ec2-5a7e-8c59-4abc64289836','Phleum Linnaeus','Linnaeus','GENUS','Phleum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7824','','','Phleum alpinum Linnaeus',1,'Phleum alpinum','Phleum alpinum','Phleum alpin',2,0,'','','Linnaeus','17157cc4-2111-5df9-ab6b-1e92275ef6eb','Phleum alpinum Linnaeus','Linnaeus','SPECIES','','Phleum','','alpinum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7795','','','Nassella viridula (Trinius) Barkworth',1,'Nassella viridula','Nassella viridula','Nassella uiridul',2,0,'','','Trinius|Barkworth','a61937ef-515d-528b-a3e0-3ec899666822','Nassella viridula (Trinius) Barkworth','(Trinius) Barkworth','SPECIES','','Nassella','','viridula','','','',NULL,'Barkworth','','','','','Trinius','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7713','','','Hesperostipa comata (Trinius & Ruprecht) Barkworth subsp. comata',1,'Hesperostipa comata comata','Hesperostipa comata subsp. comata','Hesperostipa comat comat',3,0,'','','','7906c6e5-e2c2-5085-8336-f521ae38670d','Hesperostipa comata (Trinius & Ruprecht) Barkworth subsp. comata','(Trinius & Ruprecht) Barkworth','SUBSPECIES','','Hesperostipa','','comata','comata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8012','','','×Achnella caduca Barkworth',3,'','','',NULL,NULL,'','','','','×Achnella caduca Barkworth','Barkworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24842','','','Piptatheropsis canadensis (Poiret) Romaschenko, P.M. Peterson & Soreng',1,'Piptatheropsis canadensis','Piptatheropsis canadensis','Piptatheropsis canadens',2,0,'','','Poiret|Romaschenko|P. M. Peterson|Soreng','b03c1243-46ef-56d1-b47c-abc6d1523282','Piptatheropsis canadensis (Poiret) Romaschenko, P.M. Peterson & Soreng','(Poiret) Romaschenko, P.M. Peterson & Soreng','SPECIES','','Piptatheropsis','','canadensis','','','',NULL,'Romaschenko, P. M. Peterson & Soreng','','','','','Poiret','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30708','','','Eriocoma Nuttall',1,'Eriocoma','Eriocoma','Eriocoma',1,0,'','','Nuttall','dbcd99db-0c67-5407-bca8-c259a62bc5e1','Eriocoma Nuttall','Nuttall','GENUS','Eriocoma','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32450','','','Eriocoma lemmonii (Vasey) Romaschenko',1,'Eriocoma lemmonii','Eriocoma lemmonii','Eriocoma lemmon',2,0,'','','Vasey|Romaschenko','5c28c032-d3c6-5cd3-b07b-36631d78e6a0','Eriocoma lemmonii (Vasey) Romaschenko','(Vasey) Romaschenko','SPECIES','','Eriocoma','','lemmonii','','','',NULL,'Romaschenko','','','','','Vasey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32461','','','Eriocoma richardsonii (Link) Romaschenko',1,'Eriocoma richardsonii','Eriocoma richardsonii','Eriocoma richardson',2,0,'','','Link|Romaschenko','ab589a96-3c6f-5c12-896b-c1336950f40d','Eriocoma richardsonii (Link) Romaschenko','(Link) Romaschenko','SPECIES','','Eriocoma','','richardsonii','','','',NULL,'Romaschenko','','','','','Link','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('406','','','Triticeae Dumortier',1,'Triticeae','Triticeae','Triticeae',1,0,'','','Dumortier','d08547e0-abb4-5934-8e26-3b330e769d9c','Triticeae Dumortier','Dumortier','TRIBE','Triticeae','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('709','','','Hordeinae Dumortier',1,'Hordeinae','Hordeinae','Hordeinae',1,0,'','','Dumortier','dfe2dbba-c052-5841-821a-e1f9497237a8','Hordeinae Dumortier','Dumortier','SUBTRIBE','Hordeinae','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7369','','','Agropyron fragile (Roth) P. Candargy',1,'Agropyron fragile','Agropyron fragile','Agropyron fragil',2,0,'','','Roth|P. Candargy','2ae43250-cb26-51b9-941c-978bdcadffba','Agropyron fragile (Roth) P. Candargy','(Roth) P. Candargy','SPECIES','','Agropyron','','fragile','','','',NULL,'P. Candargy','','','','','Roth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7601','','','Elymus macrourus (Turczaninow) Tzvelev',1,'Elymus macrourus','Elymus macrourus','Elymus macrour',2,0,'','','Turczaninow|Tzvelev','7c67a04a-f03d-5f52-89dc-f49eba0e050e','Elymus macrourus (Turczaninow) Tzvelev','(Turczaninow) Tzvelev','SPECIES','','Elymus','','macrourus','','','',NULL,'Tzvelev','','','','','Turczaninow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7605','','','Elymus sibiricus Linnaeus',1,'Elymus sibiricus','Elymus sibiricus','Elymus sibiric',2,0,'','','Linnaeus','3d145173-d211-543a-82aa-5060ff02a355','Elymus sibiricus Linnaeus','Linnaeus','SPECIES','','Elymus','','sibiricus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7621','','','Elymus ×maltei Bowden',3,'','','',NULL,NULL,'','','','','Elymus ×maltei Bowden','Bowden','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7624','','','Elymus ×saundersii Vasey',3,'','','',NULL,NULL,'','','','','Elymus ×saundersii Vasey','Vasey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9578','','','Elymus canadensis var. brachystachys (Scribner & C.R. Ball) Farwell',1,'Elymus canadensis brachystachys','Elymus canadensis var. brachystachys','Elymus canadens brachystachys',3,0,'','','Scribner|C. R. Ball|Farwell','7a6e1d7a-fb4e-50f8-b844-1b75f527d34f','Elymus canadensis var. brachystachys (Scribner & C.R. Ball) Farwell','(Scribner & C.R. Ball) Farwell','VARIETY','','Elymus','','canadensis','brachystachys','','',NULL,'Farwell','','','','','Scribner & C. R. Ball','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7584','','','Elymus alaskanus (Scribner & Merrill) Á. Löve',1,'Elymus alaskanus','Elymus alaskanus','Elymus alaskan',2,0,'','','Scribner|Merrill|Á. Löve','42b06684-39c4-5de5-bac0-54500b76e432','Elymus alaskanus (Scribner & Merrill) Á. Löve','(Scribner & Merrill) Á. Löve','SPECIES','','Elymus','','alaskanus','','','',NULL,'Á. Löve','','','','','Scribner & Merrill','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7592','','','Elymus elymoides (Rafinesque) Swezey subsp. elymoides',1,'Elymus elymoides elymoides','Elymus elymoides subsp. elymoides','Elymus elymoid elymoid',3,0,'','','','d082156d-be2f-5e37-a176-7a968c5da305','Elymus elymoides (Rafinesque) Swezey subsp. elymoides','(Rafinesque) Swezey','SUBSPECIES','','Elymus','','elymoides','elymoides','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7607','','','Elymus trachycaulus (Link) Gould ex Shinners',2,'Elymus trachycaulus','Elymus trachycaulus','Elymus trachycaul',2,0,'','','Link|Gould|Shinners','6365ad03-7ce5-5cf8-b2d8-4f486badbf83','Elymus trachycaulus (Link) Gould ex Shinners','(Link) Gould ex Shinners','SPECIES','','Elymus','','trachycaulus','','','',NULL,'Gould','','Shinners','','','Link','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7611','','','Elymus trachycaulus subsp. virescens (Lange) Á. Löve & D. Löve',1,'Elymus trachycaulus virescens','Elymus trachycaulus subsp. virescens','Elymus trachycaul uirescens',3,0,'','','Lange|Á. Löve|D. Löve','59988ba4-d980-56d0-a072-b082ba19386d','Elymus trachycaulus subsp. virescens (Lange) Á. Löve & D. Löve','(Lange) Á. Löve & D. Löve','SUBSPECIES','','Elymus','','trachycaulus','virescens','','',NULL,'Á. Löve & D. Löve','','','','','Lange','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1256','','','Hordeum Linnaeus',1,'Hordeum','Hordeum','Hordeum',1,0,'','','Linnaeus','f8b99ac9-9be4-541a-8f74-4e42613eb0bc','Hordeum Linnaeus','Linnaeus','GENUS','Hordeum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28367','','','Hordeum vulgare Linnaeus subsp. vulgare',1,'Hordeum vulgare vulgare','Hordeum vulgare subsp. vulgare','Hordeum uulgar uulgar',3,0,'','','','88c411c7-b8a0-524c-9d86-a64df6f23024','Hordeum vulgare Linnaeus subsp. vulgare','Linnaeus','SUBSPECIES','','Hordeum','','vulgare','vulgare','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7727','','','Hordeum marinum subsp. gussoneanum (Parlatore) Thellung',1,'Hordeum marinum gussoneanum','Hordeum marinum subsp. gussoneanum','Hordeum marin gussonean',3,0,'','','Parlatore|Thellung','e1c54e9e-83c5-5eec-9806-e49d5ce80463','Hordeum marinum subsp. gussoneanum (Parlatore) Thellung','(Parlatore) Thellung','SUBSPECIES','','Hordeum','','marinum','gussoneanum','','',NULL,'Thellung','','','','','Parlatore','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7732','','','Hordeum murinum Linnaeus subsp. murinum',1,'Hordeum murinum murinum','Hordeum murinum subsp. murinum','Hordeum murin murin',3,0,'','','','35bc5f4d-d24c-59e7-b083-d3ffee349154','Hordeum murinum Linnaeus subsp. murinum','Linnaeus','SUBSPECIES','','Hordeum','','murinum','murinum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7746','','','Leymus cinereus (Scribner & Merrill) Á. Löve',1,'Leymus cinereus','Leymus cinereus','Leymus cinere',2,0,'','','Scribner|Merrill|Á. Löve','673bd7aa-72f7-5acc-b826-034aea7d1cbe','Leymus cinereus (Scribner & Merrill) Á. Löve','(Scribner & Merrill) Á. Löve','SPECIES','','Leymus','','cinereus','','','',NULL,'Á. Löve','','','','','Scribner & Merrill','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7752','','','Leymus mollis subsp. villosissimus (Scribner) Á. Löve & D. Löve',1,'Leymus mollis villosissimus','Leymus mollis subsp. villosissimus','Leymus moll uillosissim',3,0,'','','Scribner|Á. Löve|D. Löve','15b22f22-54ee-5d40-8178-92d1962b3242','Leymus mollis subsp. villosissimus (Scribner) Á. Löve & D. Löve','(Scribner) Á. Löve & D. Löve','SUBSPECIES','','Leymus','','mollis','villosissimus','','',NULL,'Á. Löve & D. Löve','','','','','Scribner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1912','','','Pascopyrum Á. Löve',1,'Pascopyrum','Pascopyrum','Pascopyrum',1,0,'','','Á. Löve','a66f7801-3e7b-5878-899d-c2d4ff09ec18','Pascopyrum Á. Löve','Á. Löve','GENUS','Pascopyrum','','','','','','',NULL,'','','','','','Á. Löve','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7920','','','Pseudoroegneria spicata (Pursh) Á. Löve',1,'Pseudoroegneria spicata','Pseudoroegneria spicata','Pseudoroegneria spicat',2,0,'','','Pursh|Á. Löve','f7f06d18-90f2-5f5d-84c4-2826c645f92d','Pseudoroegneria spicata (Pursh) Á. Löve','(Pursh) Á. Löve','SPECIES','','Pseudoroegneria','','spicata','','','',NULL,'Á. Löve','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9702','','','×Elyleymus ontariensis (Lepage) Barkworth',3,'','','',NULL,NULL,'','','','','×Elyleymus ontariensis (Lepage) Barkworth','(Lepage) Barkworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9705','','','×Leydeum littorale (H.J. Hodgson & W.W. Mitchell) Barkworth',3,'','','',NULL,NULL,'','','','','×Leydeum littorale (H.J. Hodgson & W.W. Mitchell) Barkworth','(H.J. Hodgson & W.W. Mitchell) Barkworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24140','','','Thinopyrum intermedium subsp. barbulatum (Schur) Barkworth & D.R. Dewey',1,'Thinopyrum intermedium barbulatum','Thinopyrum intermedium subsp. barbulatum','Thinopyrum intermedi barbulat',3,0,'','','Schur|Barkworth|D. R. Dewey','2aa4f9a9-c975-5ed6-a5e4-dfc77d2ae0fa','Thinopyrum intermedium subsp. barbulatum (Schur) Barkworth & D.R. Dewey','(Schur) Barkworth & D.R. Dewey','SUBSPECIES','','Thinopyrum','','intermedium','barbulatum','','',NULL,'Barkworth & D. R. Dewey','','','','','Schur','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29976','','','Bambusoideae Luerssen',1,'Bambusoideae','Bambusoideae','Bambusoideae',1,0,'','','Luerssen','f2897e45-228c-5251-ae01-59013720b0bc','Bambusoideae Luerssen','Luerssen','SUBFAMILY','Bambusoideae','','','','','','',NULL,'','','','','','Luerssen','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29977','','','Arundinarieae Ascherson & Graebner',1,'Arundinarieae','Arundinarieae','Arundinarieae',1,0,'','','Ascherson|Graebner','f849396a-8875-57c3-b417-444926eb1602','Arundinarieae Ascherson & Graebner','Ascherson & Graebner','TRIBE','Arundinarieae','','','','','','',NULL,'','','','','','Ascherson & Graebner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('741','','','Oryzinae (Reichenbach) Grisebach',2,'Oryzinae','Oryzinae','Oryzinae',1,0,'','','Reichenbach|Grisebach','df1d4b57-79cb-5f30-9f88-21e70b93e3a3','Oryzinae (Reichenbach) Grisebach','(Reichenbach) Grisebach','SUBTRIBE','Oryzinae','','','','','','',NULL,'Grisebach','','','','','Reichenbach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7739','','','Leersia oryzoides (Linnaeus) Swartz',1,'Leersia oryzoides','Leersia oryzoides','Leersia oryzoid',2,0,'','','Linnaeus|Swartz','b0dd8206-94f1-59a1-8ec8-35135efa43fa','Leersia oryzoides (Linnaeus) Swartz','(Linnaeus) Swartz','SPECIES','','Leersia','','oryzoides','','','',NULL,'Swartz','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8027','','','Zizania aquatica var. brevis Fassett',1,'Zizania aquatica brevis','Zizania aquatica var. brevis','Zizania aquatic breu',3,0,'','','Fassett','6aa6b80c-0a86-57cf-81b3-af8122dfdf91','Zizania aquatica var. brevis Fassett','Fassett','VARIETY','','Zizania','','aquatica','brevis','','',NULL,'','','','','','Fassett','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33646','','','Sparganium subg. Xanthosparganium Holmberg',2,'Xanthosparganium','Sparganium subgen. Xanthosparganium','Xanthosparganium',1,0,'','','Holmberg','cb28f4f6-70ee-5067-8889-062bd3b7ffdc','Sparganium subg. Xanthosparganium Holmberg','Holmberg','SUBGENUS','Xanthosparganium','','','','','','',NULL,'','','','','','Holmberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9393','','','Sparganium fluctuans (Morong) B.L. Robinson',1,'Sparganium fluctuans','Sparganium fluctuans','Sparganium fluctuans',2,0,'','','Morong|B. L. Robinson','0c827050-d460-56d9-9f72-7f3f37c4b5af','Sparganium fluctuans (Morong) B.L. Robinson','(Morong) B.L. Robinson','SPECIES','','Sparganium','','fluctuans','','','',NULL,'B. L. Robinson','','','','','Morong','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9392','','','Sparganium eurycarpum Engelmann',1,'Sparganium eurycarpum','Sparganium eurycarpum','Sparganium eurycarp',2,0,'','','Engelmann','f0765870-60aa-5c55-9d50-b74cd32e6a1b','Sparganium eurycarpum Engelmann','Engelmann','SPECIES','','Sparganium','','eurycarpum','','','',NULL,'','','','','','Engelmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('239','','','Xyridaceae C. Agardh',1,'Xyridaceae','Xyridaceae','Xyridaceae',1,0,'','','C. Agardh','49b02ee9-df9a-5b81-875e-9fc5d96aa93a','Xyridaceae C. Agardh','C. Agardh','FAMILY','Xyridaceae','','','','','','',NULL,'','','','','','C. Agardh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9548','','','Xyris difformis Chapman var. difformis',1,'Xyris difformis difformis','Xyris difformis var. difformis','Xyris difform difform',3,0,'','','','2d08cc67-733d-54c3-8e71-1c557198774a','Xyris difformis Chapman var. difformis','Chapman','VARIETY','','Xyris','','difformis','difformis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('153','','','Lauraceae de Jussieu',1,'Lauraceae','Lauraceae','Lauraceae',1,0,'','','de Jussieu','8de4d62a-79e3-51b5-8808-6a9d006317a8','Lauraceae de Jussieu','de Jussieu','FAMILY','Lauraceae','','','','','','',NULL,'','','','','','de Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6486','','','Lindera benzoin (Linnaeus) Blume',1,'Lindera benzoin','Lindera benzoin','Lindera benzoin',2,0,'','','Linnaeus|Blume','2f36680a-f25f-5595-bef3-da51386274f9','Lindera benzoin (Linnaeus) Blume','(Linnaeus) Blume','SPECIES','','Lindera','','benzoin','','','',NULL,'Blume','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('284','','','Annonoideae',1,'Annonoideae','Annonoideae','Annonoideae',1,0,'','','','7dd7cdd2-1271-5163-bcab-37965a40c335','Annonoideae','','SUBFAMILY','Annonoideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1356','','','Liriodendron Linnaeus',1,'Liriodendron','Liriodendron','Liriodendron',1,0,'','','Linnaeus','75a80c4d-940b-5f9e-9f02-2689cfd4cde0','Liriodendron Linnaeus','Linnaeus','GENUS','Liriodendron','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('88','','','Aristolochiaceae de Jussieu',1,'Aristolochiaceae','Aristolochiaceae','Aristolochiaceae',1,0,'','','de Jussieu','99148181-cd48-5177-a0ed-ed7c7ae3ac26','Aristolochiaceae de Jussieu','de Jussieu','FAMILY','Aristolochiaceae','','','','','','',NULL,'','','','','','de Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('282','','','Asaroideae',1,'Asaroideae','Asaroideae','Asaroideae',1,0,'','','','22a30508-a905-529e-8fed-4cc7e71a6306','Asaroideae','','SUBFAMILY','Asaroideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('863','','','Asarum Linnaeus',1,'Asarum','Asarum','Asarum',1,0,'','','Linnaeus','bd7d46a7-da8d-5d2e-9e6b-c1bc3c2574ad','Asarum Linnaeus','Linnaeus','GENUS','Asarum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('215','','','Saururaceae Martinov',1,'Saururaceae','Saururaceae','Saururaceae',1,0,'','','Martinov','9b28792d-e60a-56ff-9834-66fa2b309fce','Saururaceae Martinov','Martinov','FAMILY','Saururaceae','','','','','','',NULL,'','','','','','Martinov','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('101','','','Cabombaceae Richard ex A. Richard',2,'Cabombaceae','Cabombaceae','Cabombaceae',1,0,'','','Richard|A. Richard','f83b93c6-acfe-5b17-8b45-c8c9363217b4','Cabombaceae Richard ex A. Richard','Richard ex A. Richard','FAMILY','Cabombaceae','','','','','','',NULL,'','','','','','Richard','','A. Richard','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('176','','','Nymphaeaceae Salisbury',1,'Nymphaeaceae','Nymphaeaceae','Nymphaeaceae',1,0,'','','Salisbury','2c9d5929-2272-5e91-86b5-b2faafb06f33','Nymphaeaceae Salisbury','Salisbury','FAMILY','Nymphaeaceae','','','','','','',NULL,'','','','','','Salisbury','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6714','','','Nuphar polysepala Engelmann',1,'Nuphar polysepala','Nuphar polysepala','Nuphar polysepal',2,0,'','','Engelmann','0cbc5557-abbf-592e-bbe0-5e8d39378888','Nuphar polysepala Engelmann','Engelmann','SPECIES','','Nuphar','','polysepala','','','',NULL,'','','','','','Engelmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6711','','','Nuphar advena (Aiton) W.T. Aiton subsp. advena',1,'Nuphar advena advena','Nuphar advena subsp. advena','Nuphar aduen aduen',3,0,'','','','115f7e1c-92e4-5671-a30c-462f230c2cd6','Nuphar advena (Aiton) W.T. Aiton subsp. advena','(Aiton) W.T. Aiton','SUBSPECIES','','Nuphar','','advena','advena','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6717','','','Nymphaea alba Linnaeus',1,'Nymphaea alba','Nymphaea alba','Nymphaea alb',2,0,'','','Linnaeus','f2203ba8-b8fc-504e-bb1c-38782700e83c','Nymphaea alba Linnaeus','Linnaeus','SPECIES','','Nymphaea','','alba','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6723','','','Nymphaea tetragona Georgi',1,'Nymphaea tetragona','Nymphaea tetragona','Nymphaea tetragon',2,0,'','','Georgi','2b7868c5-710b-5653-a7a8-9728e3dd1f4a','Nymphaea tetragona Georgi','Georgi','SPECIES','','Nymphaea','','tetragona','','','',NULL,'','','','','','Georgi','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6720','','','Nymphaea odorata Aiton subsp. odorata',1,'Nymphaea odorata odorata','Nymphaea odorata subsp. odorata','Nymphaea odorat odorat',3,0,'','','','116daf1c-6502-5770-a3b8-8c40c99b36d7','Nymphaea odorata Aiton subsp. odorata','Aiton','SUBSPECIES','','Nymphaea','','odorata','odorata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6702','','','Nelumbo lutea (Willdenow) Persoon',1,'Nelumbo lutea','Nelumbo lutea','Nelumbo lute',2,0,'','','Willdenow|Persoon','84d548b0-6a25-5af1-94d8-0d9e4228a4ef','Nelumbo lutea (Willdenow) Persoon','(Willdenow) Persoon','SPECIES','','Nelumbo','','lutea','','','',NULL,'Persoon','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('59','','','Ranunculales Lindley',1,'Ranunculales','Ranunculales','Ranunculales',1,0,'','','Lindley','d0ea4796-8593-51df-baa8-4c45f41fd118','Ranunculales Lindley','Lindley','ORDER','Ranunculales','','','','','','',NULL,'','','','','','Lindley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('771','','','Achlys de Candolle',1,'Achlys','Achlys','Achlys',1,0,'','','de Candolle','79a54fe2-efa4-5444-a763-32f6ebb68ea1','Achlys de Candolle','de Candolle','GENUS','Achlys','','','','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3666','','','Berberis thunbergii de Candolle',1,'Berberis thunbergii','Berberis thunbergii','Berberis thunberg',2,0,'','','de Candolle','ba3f4af0-e40e-57a8-890a-a61a161533fe','Berberis thunbergii de Candolle','de Candolle','SPECIES','','Berberis','','thunbergii','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1939','','','Vancouveria C. Morren & Decaisne',1,'Vancouveria','Vancouveria','Vancouveria',1,0,'','','C. Morren|Decaisne','71d53883-b97c-568a-8329-b091e360309c','Vancouveria C. Morren & Decaisne','C. Morren & Decaisne','GENUS','Vancouveria','','','','','','',NULL,'','','','','','C. Morren & Decaisne','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12781','','','Mahonia repens (Lindley) G. Don',1,'Mahonia repens','Mahonia repens','Mahonia repens',2,0,'','','Lindley|G. Don','a6fbcc0c-7dc9-5c91-b89f-567eeefe7a42','Mahonia repens (Lindley) G. Don','(Lindley) G. Don','SPECIES','','Mahonia','','repens','','','',NULL,'G. Don','','','','','Lindley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1407','','','Menispermum Linnaeus',1,'Menispermum','Menispermum','Menispermum',1,0,'','','Linnaeus','cd93a3f9-78e8-5e4a-87a4-6481f0a276fc','Menispermum Linnaeus','Linnaeus','GENUS','Menispermum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('252','','','Fumarioideae',1,'Fumarioideae','Fumarioideae','Fumarioideae',1,0,'','','','62eb3ccd-b2c2-5f6a-b16e-a1af70cb049d','Fumarioideae','','SUBFAMILY','Fumarioideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7088','','','Capnoides sempervirens (Linnaeus) Borkhausen',1,'Capnoides sempervirens','Capnoides sempervirens','Capnoides semperuirens',2,0,'','','Linnaeus|Borkhausen','5afd4622-9c77-54b7-ab30-087975457961','Capnoides sempervirens (Linnaeus) Borkhausen','(Linnaeus) Borkhausen','SPECIES','','Capnoides','','sempervirens','','','',NULL,'Borkhausen','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7095','','','Corydalis solida (Linnaeus) Clairville',1,'Corydalis solida','Corydalis solida','Corydalis solid',2,0,'','','Linnaeus|Clairville','aa68aec1-2552-5e49-abcd-692c01afd2b7','Corydalis solida (Linnaeus) Clairville','(Linnaeus) Clairville','SPECIES','','Corydalis','','solida','','','',NULL,'Clairville','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7101','','','Dicentra uniflora Kellogg',1,'Dicentra uniflora','Dicentra uniflora','Dicentra uniflor',2,0,'','','Kellogg','206d1047-feae-525e-8389-258cb8273fe9','Dicentra uniflora Kellogg','Kellogg','SPECIES','','Dicentra','','uniflora','','','',NULL,'','','','','','Kellogg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7100','','','Dicentra formosa (Andrews) Walpers',1,'Dicentra formosa','Dicentra formosa','Dicentra formos',2,0,'','','Andrews|Walpers','eba78dba-7a70-5c86-8f53-d3e55daf5090','Dicentra formosa (Andrews) Walpers','(Andrews) Walpers','SPECIES','','Dicentra','','formosa','','','',NULL,'Walpers','','','','','Andrews','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23632','','','Fumaria reuteri Boissier',1,'Fumaria reuteri','Fumaria reuteri','Fumaria reuter',2,0,'','','Boissier','b80e1a39-f545-5fdc-b25b-4b84ad9888c4','Fumaria reuteri Boissier','Boissier','SPECIES','','Fumaria','','reuteri','','','',NULL,'','','','','','Boissier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1503','','','Papaver Linnaeus',1,'Papaver','Papaver','Papaver',1,0,'','','Linnaeus','2773635f-b67f-5938-b57b-46651b8e722b','Papaver Linnaeus','Linnaeus','GENUS','Papaver','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7127','','','Papaver walpolei A.E. Porsild',1,'Papaver walpolei','Papaver walpolei','Papaver walpole',2,0,'','','A. E. Porsild','b05da904-890f-5935-938d-e688640c2812','Papaver walpolei A.E. Porsild','A.E. Porsild','SPECIES','','Papaver','','walpolei','','','',NULL,'','','','','','A. E. Porsild','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7116','','','Papaver nudicaule Linnaeus',1,'Papaver nudicaule','Papaver nudicaule','Papaver nudicaul',2,0,'','','Linnaeus','0e2bfc3f-b17a-5b32-b3e7-4a6795af42da','Papaver nudicaule Linnaeus','Linnaeus','SPECIES','','Papaver','','nudicaule','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7124','','','Papaver radicatum Rottbøll',1,'Papaver radicatum','Papaver radicatum','Papaver radicat',2,0,'','','Rottbøll','7ef22fd7-fcc9-587e-9609-f63547914f02','Papaver radicatum Rottbøll','Rottbøll','SPECIES','','Papaver','','radicatum','','','',NULL,'','','','','','Rottbøll','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28022','','','Papaver croceum Ledebour',1,'Papaver croceum','Papaver croceum','Papaver croce',2,0,'','','Ledebour','ff65560f-1ff1-5074-9a8a-e47fe07d1a59','Papaver croceum Ledebour','Ledebour','SPECIES','','Papaver','','croceum','','','',NULL,'','','','','','Ledebour','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7105','','','Glaucium flavum Crantz',1,'Glaucium flavum','Glaucium flavum','Glaucium flau',2,0,'','','Crantz','b521e722-5d4c-53dc-b0f8-97d149edf19d','Glaucium flavum Crantz','Crantz','SPECIES','','Glaucium','','flavum','','','',NULL,'','','','','','Crantz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7128','','','Sanguinaria canadensis Linnaeus',1,'Sanguinaria canadensis','Sanguinaria canadensis','Sanguinaria canadens',2,0,'','','Linnaeus','1b99f8e7-1f61-57b4-84d0-6ffef14194e8','Sanguinaria canadensis Linnaeus','Linnaeus','SPECIES','','Sanguinaria','','canadensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1134','','','Eschscholzia Chamisso',1,'Eschscholzia','Eschscholzia','Eschscholzia',1,0,'','','Chamisso','e1c90866-43f3-5f06-b98e-67a5f522ce34','Eschscholzia Chamisso','Chamisso','GENUS','Eschscholzia','','','','','','',NULL,'','','','','','Chamisso','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('436','','','Isopyreae Schrödinger',1,'Isopyreae','Isopyreae','Isopyreae',1,0,'','','Schrödinger','9d7908c5-9ed0-590c-917e-a1ef09835bd3','Isopyreae Schrödinger','Schrödinger','TRIBE','Isopyreae','','','','','','',NULL,'','','','','','Schrödinger','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2258','','','Thalictrum sect. Thalictrum',2,'Thalictrum','Thalictrum sect. Thalictrum','Thalictrum',1,0,'','','','5fd7fdc2-3eb1-56c0-ba1e-b4cfe35835ea','Thalictrum sect. Thalictrum','','SECTION','Thalictrum','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8571','','','Thalictrum confine Fernald',1,'Thalictrum confine','Thalictrum confine','Thalictrum confin',2,0,'','','Fernald','df7c648a-7a6b-56f0-88d2-74607ce9d9b3','Thalictrum confine Fernald','Fernald','SPECIES','','Thalictrum','','confine','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19751','','','Thalictrum amphibolum Greene',1,'Thalictrum amphibolum','Thalictrum amphibolum','Thalictrum amphibol',2,0,'','','Greene','e9e75c36-8444-523d-99ce-a48bc1acc56f','Thalictrum amphibolum Greene','Greene','SPECIES','','Thalictrum','','amphibolum','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8578','','','Thalictrum thalictroides (Linnaeus) A.J. Eames & B. Boivin',1,'Thalictrum thalictroides','Thalictrum thalictroides','Thalictrum thalictroid',2,0,'','','Linnaeus|A. J. Eames|B. Boivin','2d02b6f4-def8-5f16-b78c-d4f07dfb8fbd','Thalictrum thalictroides (Linnaeus) A.J. Eames & B. Boivin','(Linnaeus) A.J. Eames & B. Boivin','SPECIES','','Thalictrum','','thalictroides','','','',NULL,'A. J. Eames & B. Boivin','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('399','','','Adonideae Horaninow',1,'Adonideae','Adonideae','Adonideae',1,0,'','','Horaninow','7c1d698c-a6ff-5aab-bb89-4b8371ba81bc','Adonideae Horaninow','Horaninow','TRIBE','Adonideae','','','','','','',NULL,'','','','','','Horaninow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8582','','','Trollius europaeus Linnaeus',1,'Trollius europaeus','Trollius europaeus','Trollius europae',2,0,'','','Linnaeus','d4301a2b-df64-52a8-a741-92f8dbb29bd6','Trollius europaeus Linnaeus','Linnaeus','SPECIES','','Trollius','','europaeus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8420','','','Anemone cylindrica A. Gray',1,'Anemone cylindrica','Anemone cylindrica','Anemone cylindric',2,0,'','','A. Gray','d97830a3-2da7-58eb-b362-bbb0cb8998db','Anemone cylindrica A. Gray','A. Gray','SPECIES','','Anemone','','cylindrica','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8421','','','Anemone drummondii S. Watson var. drummondii',1,'Anemone drummondii drummondii','Anemone drummondii var. drummondii','Anemone drummond drummond',3,0,'','','','78c76ccb-379f-5f9d-9ad5-f2bd06c336e2','Anemone drummondii S. Watson var. drummondii','S. Watson','VARIETY','','Anemone','','drummondii','drummondii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8436','','','Anemone quinquefolia Linnaeus',1,'Anemone quinquefolia','Anemone quinquefolia','Anemone quinquefol',2,0,'','','Linnaeus','9286f8c1-0ffa-52ed-9112-7542b63fb9a8','Anemone quinquefolia Linnaeus','Linnaeus','SPECIES','','Anemone','','quinquefolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8442','','','Anemone virginiana Linnaeus var. virginiana',1,'Anemone virginiana virginiana','Anemone virginiana var. virginiana','Anemone uirginian uirginian',3,0,'','','','52f9e103-3493-5302-a840-c454e606f9e0','Anemone virginiana Linnaeus var. virginiana','Linnaeus','VARIETY','','Anemone','','virginiana','virginiana','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33339','','','Anemone narcissiflora Linnaeus',1,'Anemone narcissiflora','Anemone narcissiflora','Anemone narcissiflor',2,0,'','','Linnaeus','b0d1e998-00d6-5208-880e-8c26d79c4ac7','Anemone narcissiflora Linnaeus','Linnaeus','SPECIES','','Anemone','','narcissiflora','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8459','','','Clematis orientalis Linnaeus',1,'Clematis orientalis','Clematis orientalis','Clematis oriental',2,0,'','','Linnaeus','a05971b4-ac87-52eb-956b-894c415c0b51','Clematis orientalis Linnaeus','Linnaeus','SPECIES','','Clematis','','orientalis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8465','','','Clematis virginiana Linnaeus',1,'Clematis virginiana','Clematis virginiana','Clematis uirginian',2,0,'','','Linnaeus','37858d38-e372-546c-adc4-10390da52293','Clematis virginiana Linnaeus','Linnaeus','SPECIES','','Clematis','','virginiana','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2044','','','Clematis subg. Atragene (Linnaeus) Torrey & A. Gray',2,'Atragene','Clematis subgen. Atragene','Atragene',1,0,'','','Linnaeus|Torrey|A. Gray','75e03f39-e868-50b8-956e-29f9ed625f44','Clematis subg. Atragene (Linnaeus) Torrey & A. Gray','(Linnaeus) Torrey & A. Gray','SUBGENUS','Atragene','','','','','','',NULL,'Torrey & A. Gray','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2046','','','Clematis subg. Viticella (Moench) Keener & W. M. Dennis',2,'Viticella','Clematis subgen. Viticella','Viticella',1,0,'','','Moench|Keener|W. M. Dennis','5898889d-53a6-5cbe-ae2b-4e6805e3df85','Clematis subg. Viticella (Moench) Keener & W. M. Dennis','(Moench) Keener & W. M. Dennis','SUBGENUS','Viticella','','','','','','',NULL,'Keener & W. M. Dennis','','','','','Moench','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8454','','','Clematis integrifolia Linnaeus',1,'Clematis integrifolia','Clematis integrifolia','Clematis integrifol',2,0,'','','Linnaeus','fafb0878-e846-553f-808f-b1faf07057e2','Clematis integrifolia Linnaeus','Linnaeus','SPECIES','','Clematis','','integrifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30375','','','Anemonastrum canadense (Linnaeus) Mosyakin',1,'Anemonastrum canadense','Anemonastrum canadense','Anemonastrum canadens',2,0,'','','Linnaeus|Mosyakin','fe26724f-b73e-537d-a94b-7d3ba3b71883','Anemonastrum canadense (Linnaeus) Mosyakin','(Linnaeus) Mosyakin','SPECIES','','Anemonastrum','','canadense','','','',NULL,'Mosyakin','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30372','','','Hepatica Miller',1,'Hepatica','Hepatica','Hepatica',1,0,'','','Miller','b9c6af82-2105-575e-9ca6-59e9d9554d51','Hepatica Miller','Miller','GENUS','Hepatica','','','','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19508','','','Hepatica acutiloba de Candolle',1,'Hepatica acutiloba','Hepatica acutiloba','Hepatica acutilob',2,0,'','','de Candolle','ea9ed17e-89c4-54ad-abb1-0a088bce2c4a','Hepatica acutiloba de Candolle','de Candolle','SPECIES','','Hepatica','','acutiloba','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8493','','','Myosurus minimus Linnaeus',1,'Myosurus minimus','Myosurus minimus','Myosurus minim',2,0,'','','Linnaeus','9aa99816-44e1-50eb-b5d6-952ed814e858','Myosurus minimus Linnaeus','Linnaeus','SPECIES','','Myosurus','','minimus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8491','','','Myosurus apetalus Gay',1,'Myosurus apetalus','Myosurus apetalus','Myosurus apetal',2,0,'','','Gay','fb7d8fdf-1e04-55b4-aad1-3ea2d7d86b74','Myosurus apetalus Gay','Gay','SPECIES','','Myosurus','','apetalus','','','',NULL,'','','','','','Gay','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2047','','','Ranunculus subg. Ranunculus',2,'Ranunculus','Ranunculus subgen. Ranunculus','Ranunculus',1,0,'','','','c3f930e6-0899-54e2-a246-04e43d828181','Ranunculus subg. Ranunculus','','SUBGENUS','Ranunculus','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8495','','','Ranunculus abortivus Linnaeus',1,'Ranunculus abortivus','Ranunculus abortivus','Ranunculus abortiu',2,0,'','','Linnaeus','74bdee28-7069-588a-a30c-9f5691fc7e5c','Ranunculus abortivus Linnaeus','Linnaeus','SPECIES','','Ranunculus','','abortivus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8542','','','Ranunculus nivalis Linnaeus',1,'Ranunculus nivalis','Ranunculus nivalis','Ranunculus niual',2,0,'','','Linnaeus','4bb8f453-42a8-587b-a726-4894765e69ab','Ranunculus nivalis Linnaeus','Linnaeus','SPECIES','','Ranunculus','','nivalis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8558','','','Ranunculus rhomboideus Goldie',1,'Ranunculus rhomboideus','Ranunculus rhomboideus','Ranunculus rhomboide',2,0,'','','Goldie','42c64cec-766f-597b-8e4e-7b3bf03fc687','Ranunculus rhomboideus Goldie','Goldie','SPECIES','','Ranunculus','','rhomboideus','','','',NULL,'','','','','','Goldie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8511','','','Ranunculus eschscholtzii Schlechtendal',1,'Ranunculus eschscholtzii','Ranunculus eschscholtzii','Ranunculus eschscholtz',2,0,'','','Schlechtendal','362ee9e0-4129-5976-b2be-79ec6891a779','Ranunculus eschscholtzii Schlechtendal','Schlechtendal','SPECIES','','Ranunculus','','eschscholtzii','','','',NULL,'','','','','','Schlechtendal','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8536','','','Ranunculus inamoenus Greene',1,'Ranunculus inamoenus','Ranunculus inamoenus','Ranunculus inamoen',2,0,'','','Greene','44a7b082-8971-5eb3-b59d-f255fc256ee1','Ranunculus inamoenus Greene','Greene','SPECIES','','Ranunculus','','inamoenus','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8539','','','Ranunculus macounii Britton',1,'Ranunculus macounii','Ranunculus macounii','Ranunculus macoun',2,0,'','','Britton','4121f2b3-db14-5b5c-b850-f39aaeaaff89','Ranunculus macounii Britton','Britton','SPECIES','','Ranunculus','','macounii','','','',NULL,'','','','','','Britton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8532','','','Ranunculus hispidus Michaux var. hispidus',1,'Ranunculus hispidus hispidus','Ranunculus hispidus var. hispidus','Ranunculus hispid hispid',3,0,'','','','84d3f2cb-15fd-5b9f-ba3b-401b402ac373','Ranunculus hispidus Michaux var. hispidus','Michaux','VARIETY','','Ranunculus','','hispidus','hispidus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8548','','','Ranunculus orthorhynchus Hooker',1,'Ranunculus orthorhynchus','Ranunculus orthorhynchus','Ranunculus orthorhynch',2,0,'','','Hooker','558cf353-6999-5c80-ac04-bab613bae4f1','Ranunculus orthorhynchus Hooker','Hooker','SPECIES','','Ranunculus','','orthorhynchus','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8505','','','Ranunculus californicus var. cuneatus Greene',1,'Ranunculus californicus cuneatus','Ranunculus californicus var. cuneatus','Ranunculus californic cuneat',3,0,'','','Greene','8880f623-2b2b-5784-b9e5-76897aad6a65','Ranunculus californicus var. cuneatus Greene','Greene','VARIETY','','Ranunculus','','californicus','cuneatus','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8497','','','Ranunculus alismifolius Geyer ex Bentham var. alismifolius',2,'Ranunculus alismifolius alismifolius','Ranunculus alismifolius var. alismifolius','Ranunculus alismifol alismifol',3,0,'','','','d54d709f-a736-5dab-8fb3-4370c4931c74','Ranunculus alismifolius Geyer ex Bentham var. alismifolius','Geyer ex Bentham','VARIETY','','Ranunculus','','alismifolius','alismifolius','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8527','','','Ranunculus gmelinii de Candolle',1,'Ranunculus gmelinii','Ranunculus gmelinii','Ranunculus gmelin',2,0,'','','de Candolle','9d470068-5972-59a7-bbdd-f900dda28a2f','Ranunculus gmelinii de Candolle','de Candolle','SPECIES','','Ranunculus','','gmelinii','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8551','','','Ranunculus parviflorus Linnaeus',1,'Ranunculus parviflorus','Ranunculus parviflorus','Ranunculus paruiflor',2,0,'','','Linnaeus','d1ba3f36-f959-527d-ad9e-76595fddb4c1','Ranunculus parviflorus Linnaeus','Linnaeus','SPECIES','','Ranunculus','','parviflorus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('19646','','','Ranunculus trichophyllus Chaix',1,'Ranunculus trichophyllus','Ranunculus trichophyllus','Ranunculus trichophyll',2,0,'','','Chaix','a80dcac7-db5e-5236-a1b1-3daf4123654e','Ranunculus trichophyllus Chaix','Chaix','SPECIES','','Ranunculus','','trichophyllus','','','',NULL,'','','','','','Chaix','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30158','','','Ranunculus codyanus B. Boivin',1,'Ranunculus codyanus','Ranunculus codyanus','Ranunculus codyan',2,0,'','','B. Boivin','473c25ba-84f4-54b8-adfb-7991c514f007','Ranunculus codyanus B. Boivin','B. Boivin','SPECIES','','Ranunculus','','codyanus','','','',NULL,'','','','','','B. Boivin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8525','','','Ranunculus glacialis Linnaeus var. glacialis',1,'Ranunculus glacialis glacialis','Ranunculus glacialis var. glacialis','Ranunculus glacial glacial',3,0,'','','','37c45352-d987-5da7-ae1a-1332c86b6db7','Ranunculus glacialis Linnaeus var. glacialis','Linnaeus','VARIETY','','Ranunculus','','glacialis','glacialis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8550','','','Coptidium pallasii (Schlechtendal) Tzvelev',1,'Coptidium pallasii','Coptidium pallasii','Coptidium pallas',2,0,'','','Schlechtendal|Tzvelev','fec3368b-496b-5d7b-a403-4c5004950287','Coptidium pallasii (Schlechtendal) Tzvelev','(Schlechtendal) Tzvelev','SPECIES','','Coptidium','','pallasii','','','',NULL,'Tzvelev','','','','','Schlechtendal','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1968','','','Halerpestes Greene',1,'Halerpestes','Halerpestes','Halerpestes',1,0,'','','Greene','74e884df-49e9-54c6-aacf-aac710dce8d3','Halerpestes Greene','Greene','GENUS','Halerpestes','','','','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33342','','','Arcteranthis Greene',1,'Arcteranthis','Arcteranthis','Arcteranthis',1,0,'','','Greene','d101fc36-bee6-575c-86a6-d5900077a1f9','Arcteranthis Greene','Greene','GENUS','Arcteranthis','','','','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8404','','','Aconitum lycoctonum Linnaeus',1,'Aconitum lycoctonum','Aconitum lycoctonum','Aconitum lycocton',2,0,'','','Linnaeus','2820a1c0-ef76-5a91-adf9-298ad4db38b5','Aconitum lycoctonum Linnaeus','Linnaeus','SPECIES','','Aconitum','','lycoctonum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8402','','','Aconitum delphiniifolium de Candolle',1,'Aconitum delphiniifolium','Aconitum delphiniifolium','Aconitum delphiniifoli',2,0,'','','de Candolle','4f67f52a-a5fd-59fd-898b-67f023172cba','Aconitum delphiniifolium de Candolle','de Candolle','SPECIES','','Aconitum','','delphiniifolium','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2250','','','Delphinium sect. Diedropetala Huth',2,'Diedropetala','Delphinium sect. Diedropetala','Diedropetala',1,0,'','','Huth','330af660-bd6b-55b2-91af-d742defa837d','Delphinium sect. Diedropetala Huth','Huth','SECTION','Diedropetala','','','','','','',NULL,'','','','','','Huth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8480','','','Delphinium glareosum Greene',1,'Delphinium glareosum','Delphinium glareosum','Delphinium glareos',2,0,'','','Greene','9a0b090c-b9dd-56e8-a0fa-2630351b266e','Delphinium glareosum Greene','Greene','SPECIES','','Delphinium','','glareosum','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8481','','','Delphinium glaucum S. Watson',1,'Delphinium glaucum','Delphinium glaucum','Delphinium glauc',2,0,'','','S. Watson','957c9c11-2d3f-5324-ba65-4d24c2719840','Delphinium glaucum S. Watson','S. Watson','SPECIES','','Delphinium','','glaucum','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8478','','','Delphinium distichum Geyer ex Hooker',2,'Delphinium distichum','Delphinium distichum','Delphinium distich',2,0,'','','Geyer|Hooker','1a4fde32-a5b3-5924-87da-a0108db6d4a2','Delphinium distichum Geyer ex Hooker','Geyer ex Hooker','SPECIES','','Delphinium','','distichum','','','',NULL,'','','','','','Geyer','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2376','','','Delphinium subsect. Elata W.T. Wang',2,'Elata','Delphinium subsect. Elata','Elata',1,0,'','','W. T. Wang','c095d1f5-6ac1-5c22-93c4-2266f9a5a511','Delphinium subsect. Elata W.T. Wang','W.T. Wang','SUBSECTION','Elata','','','','','','',NULL,'','','','','','W. T. Wang','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8408','','','Actaea elata (Nuttall) Prantl',1,'Actaea elata','Actaea elata','Actaea elat',2,0,'','','Nuttall|Prantl','c2e26edf-ff3c-5dd4-8f28-0b9a117dce9e','Actaea elata (Nuttall) Prantl','(Nuttall) Prantl','SPECIES','','Actaea','','elata','','','',NULL,'Prantl','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8413','','','Actaea rubra (Aiton) Willdenow subsp. rubra',1,'Actaea rubra rubra','Actaea rubra subsp. rubra','Actaea rubr rubr',3,0,'','','','a560f5c1-0bae-540a-bd8e-73e2a71bd97e','Actaea rubra (Aiton) Willdenow subsp. rubra','(Aiton) Willdenow','SUBSPECIES','','Actaea','','rubra','rubra','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('633','','','Nigelleae Schrödinger',1,'Nigelleae','Nigelleae','Nigelleae',1,0,'','','Schrödinger','f782bc83-f280-5a18-8eff-c95bf589b5fd','Nigelleae Schrödinger','Schrödinger','TRIBE','Nigelleae','','','','','','',NULL,'','','','','','Schrödinger','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8452','','','Caltha palustris Linnaeus',1,'Caltha palustris','Caltha palustris','Caltha palustr',2,0,'','','Linnaeus','26403860-9185-5c49-9b84-1f59dcfaaaf6','Caltha palustris Linnaeus','Linnaeus','SPECIES','','Caltha','','palustris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1031','','','Coptis Salisbury',1,'Coptis','Coptis','Coptis',1,0,'','','Salisbury','5cfe474b-a25f-58e3-abcc-ded1e1be7eba','Coptis Salisbury','Salisbury','GENUS','Coptis','','','','','','',NULL,'','','','','','Salisbury','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('410','','','Thlaspideae de Candolle',1,'Thlaspideae','Thlaspideae','Thlaspideae',1,0,'','','de Candolle','f5f8373f-3e92-5e6c-8ca4-cee00a4c797c','Thlaspideae de Candolle','de Candolle','TRIBE','Thlaspideae','','','','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33346','','','Pachyphragma macrophyllum (Hoffmann) N. Bush',1,'Pachyphragma macrophyllum','Pachyphragma macrophyllum','Pachyphragma macrophyll',2,0,'','','Hoffmann|N. Bush','b8de1b6e-790e-5ed1-b355-b78ef9b16f35','Pachyphragma macrophyllum (Hoffmann) N. Bush','(Hoffmann) N. Bush','SPECIES','','Pachyphragma','','macrophyllum','','','',NULL,'N. Bush','','','','','Hoffmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('879','','','Aurinia Desvaux',1,'Aurinia','Aurinia','Aurinia',1,0,'','','Desvaux','4ca41686-f49f-5883-bc5f-2ed26f92ff25','Aurinia Desvaux','Desvaux','GENUS','Aurinia','','','','','','',NULL,'','','','','','Desvaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('894','','','Berteroa de Candolle',1,'Berteroa','Berteroa','Berteroa',1,0,'','','de Candolle','6ef0adc2-f40b-59b7-8715-e64acd007d27','Berteroa de Candolle','de Candolle','GENUS','Berteroa','','','','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31327','','','Odontarrhena muralis (Waldstein & Kitaibel) Endlicher',1,'Odontarrhena muralis','Odontarrhena muralis','Odontarrhena mural',2,0,'','','Waldstein|Kitaibel|Endlicher','49cd03b7-b302-5511-a16a-ed733e88406d','Odontarrhena muralis (Waldstein & Kitaibel) Endlicher','(Waldstein & Kitaibel) Endlicher','SPECIES','','Odontarrhena','','muralis','','','',NULL,'Endlicher','','','','','Waldstein & Kitaibel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3880','','','Arabidopsis lyrata (Linnaeus) O''Kane & Al-Shehbaz',1,'Arabidopsis lyrata','Arabidopsis lyrata','Arabidopsis lyrat',2,0,'','','Linnaeus|O''Kane|Al-Shehbaz','8023a026-0702-5dbc-b125-bd481e5753cb','Arabidopsis lyrata (Linnaeus) O''Kane & Al-Shehbaz','(Linnaeus) O''Kane & Al-Shehbaz','SPECIES','','Arabidopsis','','lyrata','','','',NULL,'O''Kane & Al-Shehbaz','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('940','','','Camelina Crantz',1,'Camelina','Camelina','Camelina',1,0,'','','Crantz','ec2f347a-eb15-51a3-9f9e-00d6905f1884','Camelina Crantz','Crantz','GENUS','Camelina','','','','','','',NULL,'','','','','','Crantz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3943','','','Capsella bursa-pastoris (Linnaeus) Medikus',1,'Capsella bursa-pastoris','Capsella bursa-pastoris','Capsella bursa-pastor',2,0,'','','Linnaeus|Medikus','eef023af-e2b4-5152-8c49-75d014d577a0','Capsella bursa-pastoris (Linnaeus) Medikus','(Linnaeus) Medikus','SPECIES','','Capsella','','bursa-pastoris','','','',NULL,'Medikus','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3887','','','Arabis caucasica Willdenow',1,'Arabis caucasica','Arabis caucasica','Arabis caucasic',2,0,'','','Willdenow','f47853a9-3535-537d-8093-f3e549091f28','Arabis caucasica Willdenow','Willdenow','SPECIES','','Arabis','','caucasica','','','',NULL,'','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3895','','','Arabis hirsuta (Linnaeus) Scopoli var. hirsuta',1,'Arabis hirsuta hirsuta','Arabis hirsuta var. hirsuta','Arabis hirsut hirsut',3,0,'','','','8823069c-753d-5065-86b3-4b73cd671770','Arabis hirsuta (Linnaeus) Scopoli var. hirsuta','(Linnaeus) Scopoli','VARIETY','','Arabis','','hirsuta','hirsuta','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3991','','','Draba alpina Linnaeus',1,'Draba alpina','Draba alpina','Draba alpin',2,0,'','','Linnaeus','640258ec-fa3f-5d2c-acf8-dad63c3eae62','Draba alpina Linnaeus','Linnaeus','SPECIES','','Draba','','alpina','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3995','','','Draba aurea Vahl ex Hornemann',2,'Draba aurea','Draba aurea','Draba aure',2,0,'','','Vahl|Hornemann','186785c5-4924-5f2a-9403-6fe4f90e37b9','Draba aurea Vahl ex Hornemann','Vahl ex Hornemann','SPECIES','','Draba','','aurea','','','',NULL,'','','','','','Vahl','','Hornemann','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3998','','','Draba cinerea Adams',1,'Draba cinerea','Draba cinerea','Draba cinere',2,0,'','','Adams','8aeda381-944b-5655-ab02-354ce3392e16','Draba cinerea Adams','Adams','SPECIES','','Draba','','cinerea','','','',NULL,'','','','','','Adams','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4007','','','Draba grandis Langsdorff ex de Candolle',2,'Draba grandis','Draba grandis','Draba grand',2,0,'','','Langsdorff|de Candolle','7af44ab3-31d1-5d1b-9aea-d5126452769e','Draba grandis Langsdorff ex de Candolle','Langsdorff ex de Candolle','SPECIES','','Draba','','grandis','','','',NULL,'','','','','','Langsdorff','','de Candolle','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4015','','','Draba nemorosa Linnaeus',1,'Draba nemorosa','Draba nemorosa','Draba nemoros',2,0,'','','Linnaeus','e9d4d445-b6a9-5527-9ad9-c58b775f56bc','Draba nemorosa Linnaeus','Linnaeus','SPECIES','','Draba','','nemorosa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4018','','','Draba oblongata R. Brown ex de Candolle',2,'Draba oblongata','Draba oblongata','Draba oblongat',2,0,'','','R. Brown|de Candolle','c3cc69da-32b2-592e-a116-bac5cb8a1861','Draba oblongata R. Brown ex de Candolle','R. Brown ex de Candolle','SPECIES','','Draba','','oblongata','','','',NULL,'','','','','','R. Brown','','de Candolle','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4028','','','Draba scotteri G.A. Mulligan',1,'Draba scotteri','Draba scotteri','Draba scotter',2,0,'','','G. A. Mulligan','8c25823c-7113-5f22-9df6-f02077722ad5','Draba scotteri G.A. Mulligan','G.A. Mulligan','SPECIES','','Draba','','scotteri','','','',NULL,'','','','','','G. A. Mulligan','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4032','','','Draba subcapitata Simmons',1,'Draba subcapitata','Draba subcapitata','Draba subcapitat',2,0,'','','Simmons','702c37ff-bb33-5ab4-8a32-f274c2a51b61','Draba subcapitata Simmons','Simmons','SPECIES','','Draba','','subcapitata','','','',NULL,'','','','','','Simmons','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24807','','','Draba chamissonis G. Don',1,'Draba chamissonis','Draba chamissonis','Draba chamisson',2,0,'','','G. Don','a7d38464-008b-598b-acbc-68ab4a22a339','Draba chamissonis G. Don','G. Don','SPECIES','','Draba','','chamissonis','','','',NULL,'','','','','','G. Don','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28005','','','Draba franktonii G.A. Mulligan & Al-Shehbaz',1,'Draba franktonii','Draba franktonii','Draba frankton',2,0,'','','G. A. Mulligan|Al-Shehbaz','2d857514-fb63-5c7e-b07a-2315907c72fc','Draba franktonii G.A. Mulligan & Al-Shehbaz','G.A. Mulligan & Al-Shehbaz','SPECIES','','Draba','','franktonii','','','',NULL,'','','','','','G. A. Mulligan & Al-Shehbaz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29609','','','Draba aleutica Ekman',1,'Draba aleutica','Draba aleutica','Draba aleutic',2,0,'','','Ekman','a6bbbd21-3a9e-56d6-bfc2-622f38bec90e','Draba aleutica Ekman','Ekman','SPECIES','','Draba','','aleutica','','','',NULL,'','','','','','Ekman','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33243','','','Draba shehbazii G.A. Mulligan',1,'Draba shehbazii','Draba shehbazii','Draba shehbaz',2,0,'','','G. A. Mulligan','f6437f4a-8af9-55dd-8a75-592678fa9761','Draba shehbazii G.A. Mulligan','G.A. Mulligan','SPECIES','','Draba','','shehbazii','','','',NULL,'','','','','','G. A. Mulligan','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('445','','','Cardamineae',1,'Cardamineae','Cardamineae','Cardamineae',1,0,'','','','191807bc-e6d7-5367-b588-ce7de135907e','Cardamineae','','TRIBE','Cardamineae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('887','','','Barbarea W.T. Aiton',1,'Barbarea','Barbarea','Barbarea',1,0,'','','W. T. Aiton','d5ee02e3-9ac0-51f6-be25-ce85194b91b0','Barbarea W.T. Aiton','W.T. Aiton','GENUS','Barbarea','','','','','','',NULL,'','','','','','W. T. Aiton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3906','','','Barbarea verna (Miller) Ascherson',1,'Barbarea verna','Barbarea verna','Barbarea uern',2,0,'','','Miller|Ascherson','60488509-5e1d-5cb5-a2a4-ad45a009908c','Barbarea verna (Miller) Ascherson','(Miller) Ascherson','SPECIES','','Barbarea','','verna','','','',NULL,'Ascherson','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3945','','','Cardamine bellidifolia Linnaeus',1,'Cardamine bellidifolia','Cardamine bellidifolia','Cardamine bellidifol',2,0,'','','Linnaeus','fb1bd52c-5dd7-5a15-ac2a-e182c116befc','Cardamine bellidifolia Linnaeus','Linnaeus','SPECIES','','Cardamine','','bellidifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3950','','','Cardamine digitata Richardson',1,'Cardamine digitata','Cardamine digitata','Cardamine digitat',2,0,'','','Richardson','6da1d743-6663-5e18-b57a-a5539653c5da','Cardamine digitata Richardson','Richardson','SPECIES','','Cardamine','','digitata','','','',NULL,'','','','','','Richardson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3952','','','Cardamine douglassii Britton',1,'Cardamine douglassii','Cardamine douglassii','Cardamine douglass',2,0,'','','Britton','bfc8956c-ae7f-5b74-abaa-ed8de30397ad','Cardamine douglassii Britton','Britton','SPECIES','','Cardamine','','douglassii','','','',NULL,'','','','','','Britton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3959','','','Cardamine umbellata Greene',1,'Cardamine umbellata','Cardamine umbellata','Cardamine umbellat',2,0,'','','Greene','e536fa1a-a987-5e48-8d6a-99f9db6c5737','Cardamine umbellata Greene','Greene','SPECIES','','Cardamine','','umbellata','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3960','','','Cardamine oligosperma Nuttall',1,'Cardamine oligosperma','Cardamine oligosperma','Cardamine oligosperm',2,0,'','','Nuttall','4ae24293-d04e-5732-87f3-f1dbcb8fdf4f','Cardamine oligosperma Nuttall','Nuttall','SPECIES','','Cardamine','','oligosperma','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3966','','','Cardamine purpurea Chamisso & Schlechtendal',1,'Cardamine purpurea','Cardamine purpurea','Cardamine purpure',2,0,'','','Chamisso|Schlechtendal','b206379b-0fc8-5c19-8994-37d7b85d90d2','Cardamine purpurea Chamisso & Schlechtendal','Chamisso & Schlechtendal','SPECIES','','Cardamine','','purpurea','','','',NULL,'','','','','','Chamisso & Schlechtendal','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4109','','','Rorippa curvisiliqua (Hooker) Bessey ex Britton',2,'Rorippa curvisiliqua','Rorippa curvisiliqua','Rorippa curuisiliqu',2,0,'','','Hooker|Bessey|Britton','0ca68e96-ec58-57a3-aa60-b4b0d8793771','Rorippa curvisiliqua (Hooker) Bessey ex Britton','(Hooker) Bessey ex Britton','SPECIES','','Rorippa','','curvisiliqua','','','',NULL,'Bessey','','Britton','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9659','','','Rorippa indica (Linnaeus) Hiern',1,'Rorippa indica','Rorippa indica','Rorippa indic',2,0,'','','Linnaeus|Hiern','b9405784-377f-5da9-9bd2-7959df4116dd','Rorippa indica (Linnaeus) Hiern','(Linnaeus) Hiern','SPECIES','','Rorippa','','indica','','','',NULL,'Hiern','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32182','','','Rorippa alpina (S. Watson) Rydberg',1,'Rorippa alpina','Rorippa alpina','Rorippa alpin',2,0,'','','S. Watson|Rydberg','bd58680d-3f75-5121-9cab-f062f9cac1ac','Rorippa alpina (S. Watson) Rydberg','(S. Watson) Rydberg','SPECIES','','Rorippa','','alpina','','','',NULL,'Rydberg','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('911','','','Brassica Linnaeus',1,'Brassica','Brassica','Brassica',1,0,'','','Linnaeus','7d33c346-8380-5c80-b12d-4b9adcdac6f0','Brassica Linnaeus','Linnaeus','GENUS','Brassica','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3939','','','Cakile maritima Scopoli',1,'Cakile maritima','Cakile maritima','Cakile maritim',2,0,'','','Scopoli','e46d35ad-a877-559c-97fd-334badff0360','Cakile maritima Scopoli','Scopoli','SPECIES','','Cakile','','maritima','','','',NULL,'','','','','','Scopoli','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3935','','','Cakile edentula (Bigelow) Hooker subsp. edentula var. edentula',1,'Cakile edentula edentula edentula','Cakile edentula subsp. edentula var. edentula','Cakile edentul edentul edentul',4,0,'','','','d538ef73-a0a2-542a-9ece-019a7980bfe8','Cakile edentula (Bigelow) Hooker subsp. edentula var. edentula','(Bigelow) Hooker','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4037','','','Eruca vesicaria (Linnaeus) Cavanilles',1,'Eruca vesicaria','Eruca vesicaria','Eruca uesicar',2,0,'','','Linnaeus|Cavanilles','454f66af-270f-5a37-9abb-b2c6c83c5ddf','Eruca vesicaria (Linnaeus) Cavanilles','(Linnaeus) Cavanilles','SPECIES','','Eruca','','vesicaria','','','',NULL,'Cavanilles','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4100','','','Raphanus raphanistrum Linnaeus',1,'Raphanus raphanistrum','Raphanus raphanistrum','Raphanus raphanistr',2,0,'','','Linnaeus','38370819-dc89-5c0d-bbb0-7b4f1377bb86','Raphanus raphanistrum Linnaeus','Linnaeus','SPECIES','','Raphanus','','raphanistrum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4102','','','Rapistrum perenne (Linnaeus) Allioni',1,'Rapistrum perenne','Rapistrum perenne','Rapistrum perenn',2,0,'','','Linnaeus|Allioni','5da561ff-c358-5d6e-a862-b0609e40ff5c','Rapistrum perenne (Linnaeus) Allioni','(Linnaeus) Allioni','SPECIES','','Rapistrum','','perenne','','','',NULL,'Allioni','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4118','','','Sinapis alba Linnaeus',1,'Sinapis alba','Sinapis alba','Sinapis alb',2,0,'','','Linnaeus','c5bf5128-999c-52cf-b4c0-65424d17e647','Sinapis alba Linnaeus','Linnaeus','SPECIES','','Sinapis','','alba','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('912','','','Braya Sternberg & Hoppe',1,'Braya','Braya','Braya',1,0,'','','Sternberg|Hoppe','a354f353-831b-539d-a6ed-f94e9666fc9a','Braya Sternberg & Hoppe','Sternberg & Hoppe','GENUS','Braya','','','','','','',NULL,'','','','','','Sternberg & Hoppe','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3933','','','Braya thorild-wulffii Ostenfeld',1,'Braya thorild-wulffii','Braya thorild-wulffii','Braya thorild-wulff',2,0,'','','Ostenfeld','501dcbac-fa2b-502d-aa1b-3fb86a54068c','Braya thorild-wulffii Ostenfeld','Ostenfeld','SPECIES','','Braya','','thorild-wulffii','','','',NULL,'','','','','','Ostenfeld','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9591','','','Braya humilis subsp. maccallae J.G. Harris',1,'Braya humilis maccallae','Braya humilis subsp. maccallae','Braya humil maccall',3,0,'','','J. G. Harris','b957fb18-4b5d-5273-918a-8e794aa8d240','Braya humilis subsp. maccallae J.G. Harris','J.G. Harris','SUBSPECIES','','Braya','','humilis','maccallae','','',NULL,'','','','','','J. G. Harris','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('477','','','Anchonieae de Candolle',1,'Anchonieae','Anchonieae','Anchonieae',1,0,'','','de Candolle','29537c51-f5dd-5caa-a9bc-58fc44b3767d','Anchonieae de Candolle','de Candolle','TRIBE','Anchonieae','','','','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('505','','','Chorisporeae Ledebour, C.A. Meyer & Bunge',1,'Chorisporeae','Chorisporeae','Chorisporeae',1,0,'','','Ledebour|C. A. Meyer|Bunge','0750d4cd-4820-598f-b914-00f9a01a4e47','Chorisporeae Ledebour, C.A. Meyer & Bunge','Ledebour, C.A. Meyer & Bunge','TRIBE','Chorisporeae','','','','','','',NULL,'','','','','','Ledebour, C. A. Meyer & Bunge','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4090','','','Parrya nudicaulis (Linnaeus) Regel',1,'Parrya nudicaulis','Parrya nudicaulis','Parrya nudicaul',2,0,'','','Linnaeus|Regel','f70da76c-fb4d-5e63-b525-3197882892f6','Parrya nudicaulis (Linnaeus) Regel','(Linnaeus) Regel','SPECIES','','Parrya','','nudicaulis','','','',NULL,'Regel','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33344','','','Cochlearia danica Linnaeus',1,'Cochlearia danica','Cochlearia danica','Cochlearia danic',2,0,'','','Linnaeus','f47b3ddb-7a46-5b15-b9ee-0537ef267125','Cochlearia danica Linnaeus','Linnaeus','SPECIES','','Cochlearia','','danica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28808','','','Ionopsidium Reichenbach',1,'Ionopsidium','Ionopsidium','Ionopsidium',1,0,'','','Reichenbach','a0f3df78-f92d-581f-9c9d-3042b74680fb','Ionopsidium Reichenbach','Reichenbach','GENUS','Ionopsidium','','','','','','',NULL,'','','','','','Reichenbach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1087','','','Descurainia Webb & Berthelot',1,'Descurainia','Descurainia','Descurainia',1,0,'','','Webb|Berthelot','109ea7c6-eba1-580c-b3ca-2947cb4c3f0d','Descurainia Webb & Berthelot','Webb & Berthelot','GENUS','Descurainia','','','','','','',NULL,'','','','','','Webb & Berthelot','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3984','','','Descurainia sophia (Linnaeus) Webb ex Prantl',2,'Descurainia sophia','Descurainia sophia','Descurainia soph',2,0,'','','Linnaeus|Webb|Prantl','6f626fdf-d431-5458-9260-3893d3399aa6','Descurainia sophia (Linnaeus) Webb ex Prantl','(Linnaeus) Webb ex Prantl','SPECIES','','Descurainia','','sophia','','','',NULL,'Webb','','Prantl','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3982','','','Descurainia pinnata (Walter) Britton',1,'Descurainia pinnata','Descurainia pinnata','Descurainia pinnat',2,0,'','','Walter|Britton','2c4d18ae-61dd-5f5b-af2a-17ddabe510d6','Descurainia pinnata (Walter) Britton','(Walter) Britton','SPECIES','','Descurainia','','pinnata','','','',NULL,'Britton','','','','','Walter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1257','','','Hornungia Reichenbach',1,'Hornungia','Hornungia','Hornungia',1,0,'','','Reichenbach','359011e8-9e0e-5601-923b-d4e4f9eea63a','Hornungia Reichenbach','Reichenbach','GENUS','Hornungia','','','','','','',NULL,'','','','','','Reichenbach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('554','','','Eutremeae Al-Shehbaz, Beilstein & E. A. Kellogg',1,'Eutremeae','Eutremeae','Eutremeae',1,0,'','','Al-Shehbaz|Beilstein|E. A. Kellogg','57f478b0-1966-512d-a567-89895a55e032','Eutremeae Al-Shehbaz, Beilstein & E. A. Kellogg','Al-Shehbaz, Beilstein & E. A. Kellogg','TRIBE','Eutremeae','','','','','','',NULL,'','','','','','Al-Shehbaz, Beilstein & E. A. Kellogg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4057','','','Iberis umbellata Linnaeus',1,'Iberis umbellata','Iberis umbellata','Iberis umbellat',2,0,'','','Linnaeus','b15236fb-b82b-5b7c-b38a-41b8679f6542','Iberis umbellata Linnaeus','Linnaeus','SPECIES','','Iberis','','umbellata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4059','','','Isatis tinctoria Linnaeus',1,'Isatis tinctoria','Isatis tinctoria','Isatis tinctor',2,0,'','','Linnaeus','f704bb94-9c56-575e-bacd-06421e6a9f78','Isatis tinctoria Linnaeus','Linnaeus','SPECIES','','Isatis','','tinctoria','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3969','','','Lepidium chalepense Linnaeus',1,'Lepidium chalepense','Lepidium chalepense','Lepidium chalepens',2,0,'','','Linnaeus','038a13f1-7901-5872-ae29-af30a32e0e69','Lepidium chalepense Linnaeus','Linnaeus','SPECIES','','Lepidium','','chalepense','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4060','','','Lepidium aucheri Boissier',1,'Lepidium aucheri','Lepidium aucheri','Lepidium aucher',2,0,'','','Boissier','f249ef78-4e2c-5cbc-9d91-abb3e85e4d91','Lepidium aucheri Boissier','Boissier','SPECIES','','Lepidium','','aucheri','','','',NULL,'','','','','','Boissier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4065','','','Lepidium oxycarpum Torrey & A. Gray',1,'Lepidium oxycarpum','Lepidium oxycarpum','Lepidium oxycarp',2,0,'','','Torrey|A. Gray','e5afd44f-0a51-5412-856d-ca45a98d0694','Lepidium oxycarpum Torrey & A. Gray','Torrey & A. Gray','SPECIES','','Lepidium','','oxycarpum','','','',NULL,'','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('605','','','Physarieae B.L. Robinson',1,'Physarieae','Physarieae','Physarieae',1,0,'','','B. L. Robinson','c179ed41-f1bd-5d1c-be1a-b288e5e09ea1','Physarieae B.L. Robinson','B.L. Robinson','TRIBE','Physarieae','','','','','','',NULL,'','','','','','B. L. Robinson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4099','','','Physaria spatulata (Rydberg) Grady & O''Kane',1,'Physaria spatulata','Physaria spatulata','Physaria spatulat',2,0,'','','Rydberg|Grady|O''Kane','a6388474-30d8-548c-9c49-53c655c311a2','Physaria spatulata (Rydberg) Grady & O''Kane','(Rydberg) Grady & O''Kane','SPECIES','','Physaria','','spatulata','','','',NULL,'Grady & O''Kane','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4093','','','Physaria arenosa (Richardson) O''Kane & Al-Shehbaz',1,'Physaria arenosa','Physaria arenosa','Physaria arenos',2,0,'','','Richardson|O''Kane|Al-Shehbaz','259ebe75-a6cb-5f58-969e-8671f0d24a14','Physaria arenosa (Richardson) O''Kane & Al-Shehbaz','(Richardson) O''Kane & Al-Shehbaz','SPECIES','','Physaria','','arenosa','','','',NULL,'O''Kane & Al-Shehbaz','','','','','Richardson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4097','','','Physaria douglasii (S. Watson) O''Kane & Al-Shehbaz subsp. douglasii',1,'Physaria douglasii douglasii','Physaria douglasii subsp. douglasii','Physaria douglas douglas',3,0,'','','','6f11bbcb-92ff-5ae9-b00f-e301d74ba01e','Physaria douglasii (S. Watson) O''Kane & Al-Shehbaz subsp. douglasii','(S. Watson) O''Kane & Al-Shehbaz','SUBSPECIES','','Physaria','','douglasii','douglasii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('678','','','Sisymbrieae de Candolle',1,'Sisymbrieae','Sisymbrieae','Sisymbrieae',1,0,'','','de Candolle','125070b1-525b-5a8d-aa19-014727326f9b','Sisymbrieae de Candolle','de Candolle','TRIBE','Sisymbrieae','','','','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1694','','','Smelowskia C.A. Meyer',1,'Smelowskia','Smelowskia','Smelowskia',1,0,'','','C. A. Meyer','519ceefd-3c1b-57d4-b559-764632ef706f','Smelowskia C.A. Meyer','C.A. Meyer','GENUS','Smelowskia','','','','','','',NULL,'','','','','','C. A. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('685','','','Thelypodieae Prantl',1,'Thelypodieae','Thelypodieae','Thelypodieae',1,0,'','','Prantl','201874f9-7e0d-5a84-9411-68cbfe8daece','Thelypodieae Prantl','Prantl','TRIBE','Thelypodieae','','','','','','',NULL,'','','','','','Prantl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4136','','','Thysanocarpus curvipes Hooker',1,'Thysanocarpus curvipes','Thysanocarpus curvipes','Thysanocarpus curuip',2,0,'','','Hooker','296267ff-d094-53ea-a66a-e70c8a636bd2','Thysanocarpus curvipes Hooker','Hooker','SPECIES','','Thysanocarpus','','curvipes','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3890','','','Boechera drepanoloba (Greene) Windham & Al-Shehbaz',1,'Boechera drepanoloba','Boechera drepanoloba','Boechera drepanolob',2,0,'','','Greene|Windham|Al-Shehbaz','ffed32d6-dd5b-5995-aa3a-0889541a1fd5','Boechera drepanoloba (Greene) Windham & Al-Shehbaz','(Greene) Windham & Al-Shehbaz','SPECIES','','Boechera','','drepanoloba','','','',NULL,'Windham & Al-Shehbaz','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3910','','','Boechera collinsii (Fernald) Á. Löve & D. Löve',1,'Boechera collinsii','Boechera collinsii','Boechera collins',2,0,'','','Fernald|Á. Löve|D. Löve','56536b45-091a-5685-a16c-eb4b045586d2','Boechera collinsii (Fernald) Á. Löve & D. Löve','(Fernald) Á. Löve & D. Löve','SPECIES','','Boechera','','collinsii','','','',NULL,'Á. Löve & D. Löve','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3916','','','Boechera lyallii (S. Watson) Dorn',1,'Boechera lyallii','Boechera lyallii','Boechera lyall',2,0,'','','S. Watson|Dorn','cc4fd7f6-48e1-5a08-884c-a2a5e668bee6','Boechera lyallii (S. Watson) Dorn','(S. Watson) Dorn','SPECIES','','Boechera','','lyallii','','','',NULL,'Dorn','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9654','','','Boechera consanguinea (Greene) Windham & Al-Shehbaz',1,'Boechera consanguinea','Boechera consanguinea','Boechera consanguine',2,0,'','','Greene|Windham|Al-Shehbaz','9c29db79-d73c-5d68-8af6-051f687e9629','Boechera consanguinea (Greene) Windham & Al-Shehbaz','(Greene) Windham & Al-Shehbaz','SPECIES','','Boechera','','consanguinea','','','',NULL,'Windham & Al-Shehbaz','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9692','','','Boechera quebecensis Windham & Al-Shehbaz',1,'Boechera quebecensis','Boechera quebecensis','Boechera quebecens',2,0,'','','Windham|Al-Shehbaz','7b72d808-3cf5-5c13-893a-60f5d323f6fe','Boechera quebecensis Windham & Al-Shehbaz','Windham & Al-Shehbaz','SPECIES','','Boechera','','quebecensis','','','',NULL,'','','','','','Windham & Al-Shehbaz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4053','','','Sandbergia whitedii (Piper) Greene',1,'Sandbergia whitedii','Sandbergia whitedii','Sandbergia whited',2,0,'','','Piper|Greene','1da2753e-d3eb-5ffd-9b0d-0812111a4cfb','Sandbergia whitedii (Piper) Greene','(Piper) Greene','SPECIES','','Sandbergia','','whitedii','','','',NULL,'Greene','','','','','Piper','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4058','','','Idahoa scapigera (Hooker) A. Nelson & J.F. MacBride',1,'Idahoa scapigera','Idahoa scapigera','Idahoa scapiger',2,0,'','','Hooker|A. Nelson|J. F. MacBride','80e8141c-676f-55fd-b56c-2fb34836fd6f','Idahoa scapigera (Hooker) A. Nelson & J.F. MacBride','(Hooker) A. Nelson & J.F. MacBride','SPECIES','','Idahoa','','scapigera','','','',NULL,'A. Nelson & J. F. MacBride','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3934','','','Bunias orientalis Linnaeus',1,'Bunias orientalis','Bunias orientalis','Bunias oriental',2,0,'','','Linnaeus','3388d90c-8d15-5a4f-9bd1-adf01baf0090','Bunias orientalis Linnaeus','Linnaeus','SPECIES','','Bunias','','orientalis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4041','','','Erysimum arenicola S. Watson',1,'Erysimum arenicola','Erysimum arenicola','Erysimum arenicol',2,0,'','','S. Watson','a57ab10a-daaf-5439-b9f0-2d25763f1b0c','Erysimum arenicola S. Watson','S. Watson','SPECIES','','Erysimum','','arenicola','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4039','','','Erysimum capitatum var. purshii (Durand) Rollins',1,'Erysimum capitatum purshii','Erysimum capitatum var. purshii','Erysimum capitat pursh',3,0,'','','Durand|Rollins','79773b2b-cd38-53a4-b225-8d0874cfe017','Erysimum capitatum var. purshii (Durand) Rollins','(Durand) Rollins','VARIETY','','Erysimum','','capitatum','purshii','','',NULL,'Rollins','','','','','Durand','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4073','','','Lobularia maritima (Linnaeus) Desvaux',1,'Lobularia maritima','Lobularia maritima','Lobularia maritim',2,0,'','','Linnaeus|Desvaux','11ce048b-35c2-5cca-a27c-b492e7bbbdce','Lobularia maritima (Linnaeus) Desvaux','(Linnaeus) Desvaux','SPECIES','','Lobularia','','maritima','','','',NULL,'Desvaux','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22564','','','Aphragmeae D.A. German & Al-Shehbaz',1,'Aphragmeae','Aphragmeae','Aphragmeae',1,0,'','','D. A. German|Al-Shehbaz','d96d14c3-aaf9-5d7e-af36-993b243203ba','Aphragmeae D.A. German & Al-Shehbaz','D.A. German & Al-Shehbaz','TRIBE','Aphragmeae','','','','','','',NULL,'','','','','','D. A. German & Al-Shehbaz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4137','','','Turritis glabra Linnaeus',1,'Turritis glabra','Turritis glabra','Turritis glabr',2,0,'','','Linnaeus','27def70d-93c4-5ebc-832d-acfb1fe4c7fe','Turritis glabra Linnaeus','Linnaeus','SPECIES','','Turritis','','glabra','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31175','','','Crucihimalaya Al-Shehbaz, O''Kane & R.A. Price',1,'Crucihimalaya','Crucihimalaya','Crucihimalaya',1,0,'','','Al-Shehbaz|O''Kane|R. A. Price','48508476-6849-5db3-b528-84ae4f880f74','Crucihimalaya Al-Shehbaz, O''Kane & R.A. Price','Al-Shehbaz, O''Kane & R.A. Price','GENUS','Crucihimalaya','','','','','','',NULL,'','','','','','Al-Shehbaz, O''Kane & R. A. Price','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4129','','','Subularia aquatica Linnaeus',1,'Subularia aquatica','Subularia aquatica','Subularia aquatic',2,0,'','','Linnaeus','0b995c38-3bb6-54e4-a7a2-358cba69fce1','Subularia aquatica Linnaeus','Linnaeus','SPECIES','','Subularia','','aquatica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1570','','','Polanisia Rafinesque',1,'Polanisia','Polanisia','Polanisia',1,0,'','','Rafinesque','0418b21f-cbaa-540c-bd04-78e2e0ee371d','Polanisia Rafinesque','Rafinesque','GENUS','Polanisia','','','','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9631','','','Polanisia dodecandra subsp. trachysperma (Torrey & A. Gray) H.H. Iltis',1,'Polanisia dodecandra trachysperma','Polanisia dodecandra subsp. trachysperma','Polanisia dodecandr trachysperm',3,0,'','','Torrey|A. Gray|H. H. Iltis','a6dbae6f-f179-5419-a4b4-0e49f3546d0f','Polanisia dodecandra subsp. trachysperma (Torrey & A. Gray) H.H. Iltis','(Torrey & A. Gray) H.H. Iltis','SUBSPECIES','','Polanisia','','dodecandra','trachysperma','','',NULL,'H. H. Iltis','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1177','','','Floerkea Willdenow',1,'Floerkea','Floerkea','Floerkea',1,0,'','','Willdenow','e1c3350e-6e0d-549b-8e6c-710d4e1045dc','Floerkea Willdenow','Willdenow','GENUS','Floerkea','','','','','','',NULL,'','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('205','','','Resedaceae Berchtold & J. Presl',1,'Resedaceae','Resedaceae','Resedaceae',1,0,'','','Berchtold|J. Presl','09636cbf-1511-5fc5-952a-57124af12bc4','Resedaceae Berchtold & J. Presl','Berchtold & J. Presl','FAMILY','Resedaceae','','','','','','',NULL,'','','','','','Berchtold & J. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('492','','','Celastreae',1,'Celastreae','Celastreae','Celastreae',1,0,'','','','1ee5e741-4280-5dcf-8aa8-ed88382f6ed3','Celastreae','','TRIBE','Celastreae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4448','','','Celastrus orbiculatus Thunberg',1,'Celastrus orbiculatus','Celastrus orbiculatus','Celastrus orbiculat',2,0,'','','Thunberg','baa0592a-e00d-55cf-88aa-32df55471d30','Celastrus orbiculatus Thunberg','Thunberg','SPECIES','','Celastrus','','orbiculatus','','','',NULL,'','','','','','Thunberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1162','','','Euonymus Linnaeus',1,'Euonymus','Euonymus','Euonymus',1,0,'','','Linnaeus','a1abc66d-2508-5cef-adce-6ce9c51374d1','Euonymus Linnaeus','Linnaeus','GENUS','Euonymus','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4455','','','Euonymus nanus Bieberstein',1,'Euonymus nanus','Euonymus nanus','Euonymus nan',2,0,'','','Bieberstein','439b90cf-38d2-5c79-89e3-5729be8723d7','Euonymus nanus Bieberstein','Bieberstein','SPECIES','','Euonymus','','nanus','','','',NULL,'','','','','','Bieberstein','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1506','','','Parnassia Linnaeus',1,'Parnassia','Parnassia','Parnassia',1,0,'','','Linnaeus','8325468c-0684-5f94-962f-143cbfde6b80','Parnassia Linnaeus','Linnaeus','GENUS','Parnassia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9397','','','Staphylea trifolia Linnaeus',1,'Staphylea trifolia','Staphylea trifolia','Staphylea trifol',2,0,'','','Linnaeus','56984055-0a9e-552e-8a84-298fa6d41036','Staphylea trifolia Linnaeus','Linnaeus','SPECIES','','Staphylea','','trifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4692','','','Citrullus colocynthis (Linnaeus) Schrader',1,'Citrullus colocynthis','Citrullus colocynthis','Citrullus colocynth',2,0,'','','Linnaeus|Schrader','3dbaf8dc-4efc-5d5f-b3d9-52f5fd0b886a','Citrullus colocynthis (Linnaeus) Schrader','(Linnaeus) Schrader','SPECIES','','Citrullus','','colocynthis','','','',NULL,'Schrader','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24785','','','Cucumis melo Linnaeus subsp. melo',1,'Cucumis melo melo','Cucumis melo subsp. melo','Cucumis mel mel',3,0,'','','','cda4d127-2e8d-55e3-9b47-7ef94000805a','Cucumis melo Linnaeus subsp. melo','Linnaeus','SUBSPECIES','','Cucumis','','melo','melo','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23859','','','Cucurbita pepo Linnaeus subsp. pepo',1,'Cucurbita pepo pepo','Cucurbita pepo subsp. pepo','Cucurbita pep pep',3,0,'','','','b7db66ad-03c5-55aa-b324-2e3a439fc6ba','Cucurbita pepo Linnaeus subsp. pepo','Linnaeus','SUBSPECIES','','Cucurbita','','pepo','pepo','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4697','','','Marah oregana (Torrey & S. Watson) Howell',1,'Marah oregana','Marah oregana','Marah oregan',2,0,'','','Torrey|S. Watson|Howell','40c9f66d-6903-58d1-93d4-922fc4d2a6e8','Marah oregana (Torrey & S. Watson) Howell','(Torrey & S. Watson) Howell','SPECIES','','Marah','','oregana','','','',NULL,'Howell','','','','','Torrey & S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('132','','','Fabaceae Lindley',1,'Fabaceae','Fabaceae','Fabaceae',1,0,'','','Lindley','71a7705d-cf24-5590-a3ba-0c2680b1aa5f','Fabaceae Lindley','Lindley','FAMILY','Fabaceae','','','','','','',NULL,'','','','','','Lindley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5622','','','Amorpha nana Nuttall',1,'Amorpha nana','Amorpha nana','Amorpha nan',2,0,'','','Nuttall','73893263-fceb-5d77-b4fa-cf4106b30862','Amorpha nana Nuttall','Nuttall','SPECIES','','Amorpha','','nana','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5715','','','Dalea villosa (Nuttall) Sprengel var. villosa',1,'Dalea villosa villosa','Dalea villosa var. villosa','Dalea uillos uillos',3,0,'','','','79de2742-2951-5405-b466-10dbfbb63076','Dalea villosa (Nuttall) Sprengel var. villosa','(Nuttall) Sprengel','VARIETY','','Dalea','','villosa','villosa','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5732','','','Glycine max (Linnaeus) Merrill',1,'Glycine max','Glycine max','Glycine max',2,0,'','','Linnaeus|Merrill','df4f8a25-ad64-575b-b113-01298247db81','Glycine max (Linnaeus) Merrill','(Linnaeus) Merrill','SPECIES','','Glycine','','max','','','',NULL,'Merrill','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5886','','','Phaseolus lunatus Linnaeus',1,'Phaseolus lunatus','Phaseolus lunatus','Phaseolus lunat',2,0,'','','Linnaeus','325bb991-a8dd-59b2-b08d-47e8c46f669b','Phaseolus lunatus Linnaeus','Linnaeus','SPECIES','','Phaseolus','','lunatus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1722','','','Strophostyles Elliott',1,'Strophostyles','Strophostyles','Strophostyles',1,0,'','','Elliott','1f22ff2e-b1be-5b1a-9160-e91b792e1a41','Strophostyles Elliott','Elliott','GENUS','Strophostyles','','','','','','',NULL,'','','','','','Elliott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5893','','','Pueraria montana var. lobata (Willdenow) Maesen & S.M. Almeida ex Sanjappa & Predeep',2,'Pueraria montana lobata','Pueraria montana var. lobata','Pueraria montan lobat',3,0,'','','Willdenow|Maesen|S. M. Almeida|Sanjappa|Predeep','1fe598df-1c70-5037-882a-6f5f973703db','Pueraria montana var. lobata (Willdenow) Maesen & S.M. Almeida ex Sanjappa & Predeep','(Willdenow) Maesen & S.M. Almeida ex Sanjappa & Predeep','VARIETY','','Pueraria','','montana','lobata','','',NULL,'Maesen & S. M. Almeida','','Sanjappa & Predeep','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5708','','','Securigera varia (Linnaeus) Lassen',1,'Securigera varia','Securigera varia','Securigera uar',2,0,'','','Linnaeus|Lassen','0b80bf47-8bfb-5a40-b3f1-7974163e45c6','Securigera varia (Linnaeus) Lassen','(Linnaeus) Lassen','SPECIES','','Securigera','','varia','','','',NULL,'Lassen','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5777','','','Acmispon parviflorus (Bentham) D.D. Sokoloff',1,'Acmispon parviflorus','Acmispon parviflorus','Acmispon paruiflor',2,0,'','','Bentham|D. D. Sokoloff','337e57b2-bad6-591d-b5f3-a2823e2f7376','Acmispon parviflorus (Bentham) D.D. Sokoloff','(Bentham) D.D. Sokoloff','SPECIES','','Acmispon','','parviflorus','','','',NULL,'D. D. Sokoloff','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1861','','','Hosackia Douglas ex Bentham',2,'Hosackia','Hosackia','Hosackia',1,0,'','','Douglas|Bentham','0a765011-ad19-5246-aad5-87ab006badbc','Hosackia Douglas ex Bentham','Douglas ex Bentham','GENUS','Hosackia','','','','','','',NULL,'','','','','','Douglas','','Bentham','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('452','','','Galegeae',1,'Galegeae','Galegeae','Galegeae',1,0,'','','','7c8bfeaf-ed53-52df-a07b-85f2ab04b9e9','Galegeae','','TRIBE','Galegeae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5692','','','Astragalus umbellatus Bunge',1,'Astragalus umbellatus','Astragalus umbellatus','Astragalus umbellat',2,0,'','','Bunge','451cd92e-302f-525e-86f2-8ee5a57d9c16','Astragalus umbellatus Bunge','Bunge','SPECIES','','Astragalus','','umbellatus','','','',NULL,'','','','','','Bunge','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5653','','','Astragalus eucosmus B.L. Robinson',1,'Astragalus eucosmus','Astragalus eucosmus','Astragalus eucosm',2,0,'','','B. L. Robinson','5acfaf31-8f2a-5192-a86c-c8edfcb3e56a','Astragalus eucosmus B.L. Robinson','B.L. Robinson','SPECIES','','Astragalus','','eucosmus','','','',NULL,'','','','','','B. L. Robinson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33921','','','Astragalus sect. Hemiphaca Karelin & Kirilov',2,'Hemiphaca','Astragalus sect. Hemiphaca','Hemiphaca',1,0,'','','Karelin|Kirilov','ca092593-405a-5e5e-88a6-55be9e527f7c','Astragalus sect. Hemiphaca Karelin & Kirilov','Karelin & Kirilov','SECTION','Hemiphaca','','','','','','',NULL,'','','','','','Karelin & Kirilov','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5669','','','Astragalus miser Douglas',1,'Astragalus miser','Astragalus miser','Astragalus miser',2,0,'','','Douglas','68548306-c5ea-54bf-92cc-707057103b40','Astragalus miser Douglas','Douglas','SPECIES','','Astragalus','','miser','','','',NULL,'','','','','','Douglas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33925','','','Astragalus sect. Drabella (Torrey & A. Gray) Barneby',2,'Drabella','Astragalus sect. Drabella','Drabella',1,0,'','','Torrey|A. Gray|Barneby','c33c04a8-0296-52c6-8f82-266e61e7d6e9','Astragalus sect. Drabella (Torrey & A. Gray) Barneby','(Torrey & A. Gray) Barneby','SECTION','Drabella','','','','','','',NULL,'Barneby','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33931','','','Astragalus sect. Cusickiani (Rydberg) Barneby',2,'Cusickiani','Astragalus sect. Cusickiani','Cusickiani',1,0,'','','Rydberg|Barneby','f2948031-cbe7-5026-9af5-24ab5a6c477e','Astragalus sect. Cusickiani (Rydberg) Barneby','(Rydberg) Barneby','SECTION','Cusickiani','','','','','','',NULL,'Barneby','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33932','','','Astragalus sect. Ervoidei (Torrey & A. Gray) Barneby',2,'Ervoidei','Astragalus sect. Ervoidei','Ervoidei',1,0,'','','Torrey|A. Gray|Barneby','21f06283-45dc-5d0e-917b-cbd8c01262a3','Astragalus sect. Ervoidei (Torrey & A. Gray) Barneby','(Torrey & A. Gray) Barneby','SECTION','Ervoidei','','','','','','',NULL,'Barneby','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5694','','','Astragalus vexilliflexus E. Sheldon',1,'Astragalus vexilliflexus','Astragalus vexilliflexus','Astragalus uexilliflex',2,0,'','','E. Sheldon','67471450-fbc1-56d7-8d04-06c6d8f4fea2','Astragalus vexilliflexus E. Sheldon','E. Sheldon','SPECIES','','Astragalus','','vexilliflexus','','','',NULL,'','','','','','E. Sheldon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33942','','','Astragalus sect. Gynophoraria (Rydberg) Barneby',2,'Gynophoraria','Astragalus sect. Gynophoraria','Gynophoraria',1,0,'','','Rydberg|Barneby','dfd74709-8531-5502-a057-fa74b92934c7','Astragalus sect. Gynophoraria (Rydberg) Barneby','(Rydberg) Barneby','SECTION','Gynophoraria','','','','','','',NULL,'Barneby','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5674','','','Astragalus nutzotinensis J. Rousseau',1,'Astragalus nutzotinensis','Astragalus nutzotinensis','Astragalus nutzotinens',2,0,'','','J. Rousseau','d6d3a533-753a-5dcc-b18e-dbd6ad1bb2a1','Astragalus nutzotinensis J. Rousseau','J. Rousseau','SPECIES','','Astragalus','','nutzotinensis','','','',NULL,'','','','','','J. Rousseau','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5679','','','Astragalus racemosus Pursh var. racemosus',1,'Astragalus racemosus racemosus','Astragalus racemosus var. racemosus','Astragalus racemos racemos',3,0,'','','','a8ba0b9a-00bd-5b95-bee3-c710b64708e3','Astragalus racemosus Pursh var. racemosus','Pursh','VARIETY','','Astragalus','','racemosus','racemosus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33946','','','Astragalus sect. Drummondiani Barneby',2,'Drummondiani','Astragalus sect. Drummondiani','Drummondiani',1,0,'','','Barneby','bee8f01d-8cac-514f-b7fb-752aa232d48a','Astragalus sect. Drummondiani Barneby','Barneby','SECTION','Drummondiani','','','','','','',NULL,'','','','','','Barneby','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5643','','','Astragalus canadensis Linnaeus',1,'Astragalus canadensis','Astragalus canadensis','Astragalus canadens',2,0,'','','Linnaeus','b7f0a3a3-5c44-5951-80ff-c807b824efa6','Astragalus canadensis Linnaeus','Linnaeus','SPECIES','','Astragalus','','canadensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33950','','','Astragalus sect. Onobrychoidei de Candolle',2,'Onobrychoidei','Astragalus sect. Onobrychoidei','Onobrychoidei',1,0,'','','de Candolle','5b403096-da1d-5151-9fce-815f80248370','Astragalus sect. Onobrychoidei de Candolle','de Candolle','SECTION','Onobrychoidei','','','','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5646','','','Astragalus cicer Linnaeus',1,'Astragalus cicer','Astragalus cicer','Astragalus cicer',2,0,'','','Linnaeus','9326785c-d4de-5ac6-b8e8-c8a6efbe0c40','Astragalus cicer Linnaeus','Linnaeus','SPECIES','','Astragalus','','cicer','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5676','','','Astragalus purshii var. glareosus (Douglas) Barneby',1,'Astragalus purshii glareosus','Astragalus purshii var. glareosus','Astragalus pursh glareos',3,0,'','','Douglas|Barneby','5e4ed4db-6808-506c-93d5-73b725134b57','Astragalus purshii var. glareosus (Douglas) Barneby','(Douglas) Barneby','VARIETY','','Astragalus','','purshii','glareosus','','',NULL,'Barneby','','','','','Douglas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5637','','','Astragalus beckwithii Torrey & A. Gray',1,'Astragalus beckwithii','Astragalus beckwithii','Astragalus beckwith',2,0,'','','Torrey|A. Gray','570c34b4-1faa-50f0-8ebd-a941f7db6ffc','Astragalus beckwithii Torrey & A. Gray','Torrey & A. Gray','SPECIES','','Astragalus','','beckwithii','','','',NULL,'','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5687','','','Astragalus spaldingii A. Gray',1,'Astragalus spaldingii','Astragalus spaldingii','Astragalus spalding',2,0,'','','A. Gray','b6fda2ea-ddba-57d4-b5ea-52dcabca8e63','Astragalus spaldingii A. Gray','A. Gray','SPECIES','','Astragalus','','spaldingii','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33962','','','Astragalus sect. Orophaca (Torrey & A. Gray) Barneby',2,'Orophaca','Astragalus sect. Orophaca','Orophaca',1,0,'','','Torrey|A. Gray|Barneby','9464b623-3b68-5924-840d-f381a381b057','Astragalus sect. Orophaca (Torrey & A. Gray) Barneby','(Torrey & A. Gray) Barneby','SECTION','Orophaca','','','','','','',NULL,'Barneby','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5691','','','Astragalus trichopodus (Nuttall) A. Gray',1,'Astragalus trichopodus','Astragalus trichopodus','Astragalus trichopod',2,0,'','','Nuttall|A. Gray','08b87d60-f013-58e9-8504-2a1136cc6380','Astragalus trichopodus (Nuttall) A. Gray','(Nuttall) A. Gray','SPECIES','','Astragalus','','trichopodus','','','',NULL,'A. Gray','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5733','','','Glycyrrhiza lepidota Pursh',1,'Glycyrrhiza lepidota','Glycyrrhiza lepidota','Glycyrrhiza lepidot',2,0,'','','Pursh','edd34323-b118-57bd-98d7-fc4084579933','Glycyrrhiza lepidota Pursh','Pursh','SPECIES','','Glycyrrhiza','','lepidota','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5873','','','Oxytropis mertensiana Turczaninow',1,'Oxytropis mertensiana','Oxytropis mertensiana','Oxytropis mertensian',2,0,'','','Turczaninow','e695df28-21d8-56ad-83d6-67636de41be7','Oxytropis mertensiana Turczaninow','Turczaninow','SPECIES','','Oxytropis','','mertensiana','','','',NULL,'','','','','','Turczaninow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5850','','','Oxytropis borealis var. hudsonica (Greene) S.L. Welsh',1,'Oxytropis borealis hudsonica','Oxytropis borealis var. hudsonica','Oxytropis boreal hudsonic',3,0,'','','Greene|S. L. Welsh','cba1828e-1bb5-5aa7-b9a9-f5d0c1fbc411','Oxytropis borealis var. hudsonica (Greene) S.L. Welsh','(Greene) S.L. Welsh','VARIETY','','Oxytropis','','borealis','hudsonica','','',NULL,'S. L. Welsh','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5856','','','Oxytropis campestris var. davisii S.L. Welsh',1,'Oxytropis campestris davisii','Oxytropis campestris var. davisii','Oxytropis campestr dauis',3,0,'','','S. L. Welsh','75e7e2e4-bf43-5f43-8cee-a9b778ec4cc4','Oxytropis campestris var. davisii S.L. Welsh','S.L. Welsh','VARIETY','','Oxytropis','','campestris','davisii','','',NULL,'','','','','','S. L. Welsh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9810','','','Oxytropis campestris var. dispar (A. Nelson) Barneby',1,'Oxytropis campestris dispar','Oxytropis campestris var. dispar','Oxytropis campestr dispar',3,0,'','','A. Nelson|Barneby','020b776f-7b27-599f-ae90-befce1e61196','Oxytropis campestris var. dispar (A. Nelson) Barneby','(A. Nelson) Barneby','VARIETY','','Oxytropis','','campestris','dispar','','',NULL,'Barneby','','','','','A. Nelson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5869','','','Oxytropis lambertii Pursh',1,'Oxytropis lambertii','Oxytropis lambertii','Oxytropis lambert',2,0,'','','Pursh','bedcb058-e0a9-5171-afb2-d56326d7b2cf','Oxytropis lambertii Pursh','Pursh','SPECIES','','Oxytropis','','lambertii','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23635','','','Oxytropis nigrescens var. uniflora (Hooker) Barneby',1,'Oxytropis nigrescens uniflora','Oxytropis nigrescens var. uniflora','Oxytropis nigrescens uniflor',3,0,'','','Hooker|Barneby','88d1dcc0-3aee-5f91-9614-0c1ab9173661','Oxytropis nigrescens var. uniflora (Hooker) Barneby','(Hooker) Barneby','VARIETY','','Oxytropis','','nigrescens','uniflora','','',NULL,'Barneby','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5883','','','Oxytropis sericea Nuttall',1,'Oxytropis sericea','Oxytropis sericea','Oxytropis serice',2,0,'','','Nuttall','24fc3165-dab9-5031-9be7-5c31d4ee1796','Oxytropis sericea Nuttall','Nuttall','SPECIES','','Oxytropis','','sericea','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31230','','','Oxytropis sericea var. speciosa (Torrey & A. Gray) S.L. Welsh',1,'Oxytropis sericea speciosa','Oxytropis sericea var. speciosa','Oxytropis serice specios',3,0,'','','Torrey|A. Gray|S. L. Welsh','62195b10-5545-5a99-8c2f-dfdf7ef74c92','Oxytropis sericea var. speciosa (Torrey & A. Gray) S.L. Welsh','(Torrey & A. Gray) S.L. Welsh','VARIETY','','Oxytropis','','sericea','speciosa','','',NULL,'S. L. Welsh','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('459','','','Thermopsideae',1,'Thermopsideae','Thermopsideae','Thermopsideae',1,0,'','','','6bfcfcb7-837f-5083-9d35-b2a4e2bf2950','Thermopsideae','','TRIBE','Thermopsideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('886','','','Baptisia Ventenat',1,'Baptisia','Baptisia','Baptisia',1,0,'','','Ventenat','4b16228f-6943-5f0c-9920-cb2f1d1913f3','Baptisia Ventenat','Ventenat','GENUS','Baptisia','','','','','','',NULL,'','','','','','Ventenat','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5696','','','Baptisia alba (Linnaeus) R. Brown',1,'Baptisia alba','Baptisia alba','Baptisia alb',2,0,'','','Linnaeus|R. Brown','0507c7af-bab2-5ed5-bf5b-f330929c6813','Baptisia alba (Linnaeus) R. Brown','(Linnaeus) R. Brown','SPECIES','','Baptisia','','alba','','','',NULL,'R. Brown','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31355','','','Baptisia lactea (Rafinesque) Thieret var. lactea',1,'Baptisia lactea lactea','Baptisia lactea var. lactea','Baptisia lacte lacte',3,0,'','','','e056318e-c750-51f2-ac96-92f3b46db4a3','Baptisia lactea (Rafinesque) Thieret var. lactea','(Rafinesque) Thieret','VARIETY','','Baptisia','','lactea','lactea','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26580','','','Thermopsis montana var. ovata (B.L. Robinson ex Piper) H. St.John',2,'Thermopsis montana ovata','Thermopsis montana var. ovata','Thermopsis montan ouat',3,0,'','','B. L. Robinson|Piper|H. St. John','aa3b22f5-fb4e-5678-bbd6-4aab0d47644e','Thermopsis montana var. ovata (B.L. Robinson ex Piper) H. St.John','(B.L. Robinson ex Piper) H. St.John','VARIETY','','Thermopsis','','montana','ovata','','',NULL,'H. St. John','','','','','B. L. Robinson','','Piper','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32636','','','Caragana halodendron (Pallas) Dumont de Courset',1,'Caragana halodendron','Caragana halodendron','Caragana halodendron',2,0,'','','Pallas|Dumont de Courset','765e13b1-21ea-50a0-8f2e-27046f12839c','Caragana halodendron (Pallas) Dumont de Courset','(Pallas) Dumont de Courset','SPECIES','','Caragana','','halodendron','','','',NULL,'Dumont de Courset','','','','','Pallas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5739','','','Hedysarum boreale subsp. mackenziei (Richardson) S.L. Welsh',1,'Hedysarum boreale mackenziei','Hedysarum boreale subsp. mackenziei','Hedysarum boreal mackenzie',3,0,'','','Richardson|S. L. Welsh','b4f149c3-d450-5158-858a-e5c25adbe1f8','Hedysarum boreale subsp. mackenziei (Richardson) S.L. Welsh','(Richardson) S.L. Welsh','SUBSPECIES','','Hedysarum','','boreale','mackenziei','','',NULL,'S. L. Welsh','','','','','Richardson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('506','','','Cicereae',1,'Cicereae','Cicereae','Cicereae',1,0,'','','','a2bb4a78-0419-57e7-8ebc-c867a16e6f87','Cicereae','','TRIBE','Cicereae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('994','','','Cicer Linnaeus',1,'Cicer','Cicer','Cicer',1,0,'','','Linnaeus','ab60e008-ff15-5607-8a3c-afb4600d3565','Cicer Linnaeus','Linnaeus','GENUS','Cicer','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5704','','','Cicer arietinum Linnaeus',1,'Cicer arietinum','Cicer arietinum','Cicer arietin',2,0,'','','Linnaeus','963a067e-31e3-5d8e-afb0-76188c9c0c46','Cicer arietinum Linnaeus','Linnaeus','SPECIES','','Cicer','','arietinum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5705','','','Cladrastis kentukea (Dumont de Courset) Rudd',1,'Cladrastis kentukea','Cladrastis kentukea','Cladrastis kentuke',2,0,'','','Dumont de Courset|Rudd','b5d82edb-54a6-5872-8806-adc9ce5149b5','Cladrastis kentukea (Dumont de Courset) Rudd','(Dumont de Courset) Rudd','SPECIES','','Cladrastis','','kentukea','','','',NULL,'Rudd','','','','','Dumont de Courset','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5730','','','Genista tinctoria Linnaeus',1,'Genista tinctoria','Genista tinctoria','Genista tinctor',2,0,'','','Linnaeus','5037c601-a21c-57da-b334-9ce73f96b584','Genista tinctoria Linnaeus','Linnaeus','SPECIES','','Genista','','tinctoria','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5743','','','Laburnum anagyroides Medikus',1,'Laburnum anagyroides','Laburnum anagyroides','Laburnum anagyroid',2,0,'','','Medikus','2d2f2f43-164e-56f3-b35e-77816fea8586','Laburnum anagyroides Medikus','Medikus','SPECIES','','Laburnum','','anagyroides','','','',NULL,'','','','','','Medikus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5807','','','Lupinus lepidus Douglas ex Lindley',2,'Lupinus lepidus','Lupinus lepidus','Lupinus lepid',2,0,'','','Douglas|Lindley','f3ff17f9-cc5f-591f-93e8-05f00c7acac9','Lupinus lepidus Douglas ex Lindley','Douglas ex Lindley','SPECIES','','Lupinus','','lepidus','','','',NULL,'','','','','','Douglas','','Lindley','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5819','','','Lupinus polyphyllus Lindley',1,'Lupinus polyphyllus','Lupinus polyphyllus','Lupinus polyphyll',2,0,'','','Lindley','1abb44fa-39e5-52a8-994d-52bfb49b04c0','Lupinus polyphyllus Lindley','Lindley','SPECIES','','Lupinus','','polyphyllus','','','',NULL,'','','','','','Lindley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5824','','','Lupinus sulphureus Douglas ex Hooker',2,'Lupinus sulphureus','Lupinus sulphureus','Lupinus sulphure',2,0,'','','Douglas|Hooker','cff3d6da-933b-5224-9d2f-3aa3547c1a00','Lupinus sulphureus Douglas ex Hooker','Douglas ex Hooker','SPECIES','','Lupinus','','sulphureus','','','',NULL,'','','','','','Douglas','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5813','','','Lupinus nootkatensis Donn ex Sims',2,'Lupinus nootkatensis','Lupinus nootkatensis','Lupinus nootkatens',2,0,'','','Donn|Sims','9d8e14ab-dd9c-56b3-85e7-e3975db65ff6','Lupinus nootkatensis Donn ex Sims','Donn ex Sims','SPECIES','','Lupinus','','nootkatensis','','','',NULL,'','','','','','Donn','','Sims','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33751','','','Lupinus pusillus Pursh var. pusillus',1,'Lupinus pusillus pusillus','Lupinus pusillus var. pusillus','Lupinus pusill pusill',3,0,'','','','b47a3fec-9f9f-574e-9998-179b4952e9ff','Lupinus pusillus Pursh var. pusillus','Pursh','VARIETY','','Lupinus','','pusillus','pusillus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9887','','','Lupinus argenteus Pursh',1,'Lupinus argenteus','Lupinus argenteus','Lupinus argente',2,0,'','','Pursh','ac9df969-b598-5918-b688-4ed8a25080c8','Lupinus argenteus Pursh','Pursh','SPECIES','','Lupinus','','argenteus','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33758','','','Lupinus argenteus var. rubricaulis (Greene) S.L. Welsh',1,'Lupinus argenteus rubricaulis','Lupinus argenteus var. rubricaulis','Lupinus argente rubricaul',3,0,'','','Greene|S. L. Welsh','eefe2ac9-eef8-51a2-ab5b-d49f4e518f36','Lupinus argenteus var. rubricaulis (Greene) S.L. Welsh','(Greene) S.L. Welsh','VARIETY','','Lupinus','','argenteus','rubricaulis','','',NULL,'S. L. Welsh','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33787','','','Spartium junceum Linnaeus',1,'Spartium junceum','Spartium junceum','Spartium iunce',2,0,'','','Linnaeus','c77fc80d-2cfe-5927-99da-706369cd79bc','Spartium junceum Linnaeus','Linnaeus','SPECIES','','Spartium','','junceum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5724','','','Desmodium marilandicum (Linnaeus) de Candolle',1,'Desmodium marilandicum','Desmodium marilandicum','Desmodium marilandic',2,0,'','','Linnaeus|de Candolle','6f0e0f28-2641-5608-b19b-8483149631c6','Desmodium marilandicum (Linnaeus) de Candolle','(Linnaeus) de Candolle','SPECIES','','Desmodium','','marilandicum','','','',NULL,'de Candolle','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5728','','','Desmodium sessilifolium (Torrey) Torrey & A. Gray',1,'Desmodium sessilifolium','Desmodium sessilifolium','Desmodium sessilifoli',2,0,'','','Torrey|A. Gray','88f9ee79-b37f-5e8c-b086-30867c10afe0','Desmodium sessilifolium (Torrey) Torrey & A. Gray','(Torrey) Torrey & A. Gray','SPECIES','','Desmodium','','sessilifolium','','','',NULL,'Torrey & A. Gray','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5773','','','Lespedeza ×nuttallii Darlington',3,'','','',NULL,NULL,'','','','','Lespedeza ×nuttallii Darlington','Darlington','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5763','','','Lespedeza capitata Michaux',1,'Lespedeza capitata','Lespedeza capitata','Lespedeza capitat',2,0,'','','Michaux','21ef1d50-c722-57cc-a853-3e088fdaeb2a','Lespedeza capitata Michaux','Michaux','SPECIES','','Lespedeza','','capitata','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28827','','','Lespedeza frutescens (Linnaeus) Hornemann',1,'Lespedeza frutescens','Lespedeza frutescens','Lespedeza frutescens',2,0,'','','Linnaeus|Hornemann','e766e369-fef9-5a15-b23c-194d833dffe2','Lespedeza frutescens (Linnaeus) Hornemann','(Linnaeus) Hornemann','SPECIES','','Lespedeza','','frutescens','','','',NULL,'Hornemann','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27747','','','Hylodesmum nudiflorum (Linnaeus) H. Ohashi & R.R. Mill',1,'Hylodesmum nudiflorum','Hylodesmum nudiflorum','Hylodesmum nudiflor',2,0,'','','Linnaeus|H. Ohashi|R. R. Mill','fc6cc2f4-11ee-5a7b-9ae1-a0bfd517ce71','Hylodesmum nudiflorum (Linnaeus) H. Ohashi & R.R. Mill','(Linnaeus) H. Ohashi & R.R. Mill','SPECIES','','Hylodesmum','','nudiflorum','','','',NULL,'H. Ohashi & R. R. Mill','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5752','','','Lathyrus ochroleucus Hooker',1,'Lathyrus ochroleucus','Lathyrus ochroleucus','Lathyrus ochroleuc',2,0,'','','Hooker','9c55808b-e661-5f27-8d53-0ca79560d32d','Lathyrus ochroleucus Hooker','Hooker','SPECIES','','Lathyrus','','ochroleucus','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5757','','','Lathyrus sphaericus Retzius',1,'Lathyrus sphaericus','Lathyrus sphaericus','Lathyrus sphaeric',2,0,'','','Retzius','2ff4b4c5-e8cc-57a8-ac22-dad79c3f3307','Lathyrus sphaericus Retzius','Retzius','SPECIES','','Lathyrus','','sphaericus','','','',NULL,'','','','','','Retzius','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9886','','','Lathyrus nevadensis S. Watson',1,'Lathyrus nevadensis','Lathyrus nevadensis','Lathyrus neuadens',2,0,'','','S. Watson','fd14a891-21e2-51e0-9219-2be41e8ac50f','Lathyrus nevadensis S. Watson','S. Watson','SPECIES','','Lathyrus','','nevadensis','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1820','','','Vicia Linnaeus',1,'Vicia','Vicia','Vicia',1,0,'','','Linnaeus','86986f5f-3a74-5af2-a151-c93485b5eed6','Vicia Linnaeus','Linnaeus','GENUS','Vicia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28407','','','Vicia americana Muhlenberg ex Willdenow var. americana',2,'Vicia americana americana','Vicia americana var. americana','Vicia american american',3,0,'','','','b8bbe30c-dee7-578d-bdec-609268e5bd84','Vicia americana Muhlenberg ex Willdenow var. americana','Muhlenberg ex Willdenow','VARIETY','','Vicia','','americana','americana','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5955','','','Vicia villosa Roth',1,'Vicia villosa','Vicia villosa','Vicia uillos',2,0,'','','Roth','065f2b7b-865f-54e8-a983-67da1f26f646','Vicia villosa Roth','Roth','SPECIES','','Vicia','','villosa','','','',NULL,'','','','','','Roth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5949','','','Vicia sativa Linnaeus',1,'Vicia sativa','Vicia sativa','Vicia satiu',2,0,'','','Linnaeus','d168fb7e-16d6-58f1-929f-e5b59169733c','Vicia sativa Linnaeus','Linnaeus','SPECIES','','Vicia','','sativa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5835','','','Medicago sativa Linnaeus',1,'Medicago sativa','Medicago sativa','Medicago satiu',2,0,'','','Linnaeus','19279af6-eab5-5a34-ab59-372c60670353','Medicago sativa Linnaeus','Linnaeus','SPECIES','','Medicago','','sativa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5831','','','Medicago orbicularis (Linnaeus) Bartalini',1,'Medicago orbicularis','Medicago orbicularis','Medicago orbicular',2,0,'','','Linnaeus|Bartalini','d568a5ed-1849-5443-b20a-538d01969818','Medicago orbicularis (Linnaeus) Bartalini','(Linnaeus) Bartalini','SPECIES','','Medicago','','orbicularis','','','',NULL,'Bartalini','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5832','','','Medicago polymorpha Linnaeus',1,'Medicago polymorpha','Medicago polymorpha','Medicago polymorph',2,0,'','','Linnaeus','a48c5be7-7793-50a3-8d80-66ac4e86b6b6','Medicago polymorpha Linnaeus','Linnaeus','SPECIES','','Medicago','','polymorpha','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5842','','','Melilotus suaveolens Ledebourg',1,'Melilotus suaveolens','Melilotus suaveolens','Melilotus suaueolens',2,0,'','','Ledebourg','99fad8d9-92f2-592c-b6b1-af043837eea9','Melilotus suaveolens Ledebourg','Ledebourg','SPECIES','','Melilotus','','suaveolens','','','',NULL,'','','','','','Ledebourg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5845','','','Ononis spinosa subsp. hircina (Jacquin) Gams',1,'Ononis spinosa hircina','Ononis spinosa subsp. hircina','Ononis spinos hircin',3,0,'','','Jacquin|Gams','a35866bc-962a-5196-a7ed-bf840f9c5eb4','Ononis spinosa subsp. hircina (Jacquin) Gams','(Jacquin) Gams','SUBSPECIES','','Ononis','','spinosa','hircina','','',NULL,'Gams','','','','','Jacquin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5934','','','Trifolium subterraneum Linnaeus',1,'Trifolium subterraneum','Trifolium subterraneum','Trifolium subterrane',2,0,'','','Linnaeus','6ec5adcf-e429-5db6-a457-2e86c4c88939','Trifolium subterraneum Linnaeus','Linnaeus','SPECIES','','Trifolium','','subterraneum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5929','','','Trifolium pratense Linnaeus',1,'Trifolium pratense','Trifolium pratense','Trifolium pratens',2,0,'','','Linnaeus','bf972e75-27d0-5476-8cb3-1d278157ad65','Trifolium pratense Linnaeus','Linnaeus','SPECIES','','Trifolium','','pratense','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5933','','','Trifolium striatum Linnaeus',1,'Trifolium striatum','Trifolium striatum','Trifolium striat',2,0,'','','Linnaeus','43bcd957-2290-50c9-8a2e-68a55e43357f','Trifolium striatum Linnaeus','Linnaeus','SPECIES','','Trifolium','','striatum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5932','','','Trifolium resupinatum Linnaeus',1,'Trifolium resupinatum','Trifolium resupinatum','Trifolium resupinat',2,0,'','','Linnaeus','b93b4a19-fef3-59cc-96b3-0f3d79fa98e3','Trifolium resupinatum Linnaeus','Linnaeus','SPECIES','','Trifolium','','resupinatum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33869','','','Trifolium sect. Involucrarium Hooker ex Lojacono',2,'Involucrarium','Trifolium sect. Involucrarium','Involucrarium',1,0,'','','Hooker|Lojacono','3eb2977f-01a3-58fb-817e-a3720b91544d','Trifolium sect. Involucrarium Hooker ex Lojacono','Hooker ex Lojacono','SECTION','Involucrarium','','','','','','',NULL,'','','','','','Hooker','','Lojacono','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5917','','','Trifolium dichotomum Hooker & Arnott',1,'Trifolium dichotomum','Trifolium dichotomum','Trifolium dichotom',2,0,'','','Hooker|Arnott','6945c903-9f81-5ff5-9b50-a09de3c43944','Trifolium dichotomum Hooker & Arnott','Hooker & Arnott','SPECIES','','Trifolium','','dichotomum','','','',NULL,'','','','','','Hooker & Arnott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5925','','','Trifolium microdon Hooker & Arnott',1,'Trifolium microdon','Trifolium microdon','Trifolium microdon',2,0,'','','Hooker|Arnott','1b505c38-1af7-55df-87a3-9f4c0dbad3a5','Trifolium microdon Hooker & Arnott','Hooker & Arnott','SPECIES','','Trifolium','','microdon','','','',NULL,'','','','','','Hooker & Arnott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5938','','','Trigonella caerulea (Linnaeus) Seringe',1,'Trigonella caerulea','Trigonella caerulea','Trigonella caerule',2,0,'','','Linnaeus|Seringe','dadd27c8-f927-5d43-a76b-3b2613d9ab17','Trigonella caerulea (Linnaeus) Seringe','(Linnaeus) Seringe','SPECIES','','Trigonella','','caerulea','','','',NULL,'Seringe','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5900','','','Rupertia physodes (Douglas ex Hooker) J.W. Grimes',2,'Rupertia physodes','Rupertia physodes','Rupertia physod',2,0,'','','Douglas|Hooker|J. W. Grimes','8b7f31ff-11c1-56fe-9bab-d856ec2dca68','Rupertia physodes (Douglas ex Hooker) J.W. Grimes','(Douglas ex Hooker) J.W. Grimes','SPECIES','','Rupertia','','physodes','','','',NULL,'J. W. Grimes','','','','','Douglas','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5899','','','Robinia ×margaretta Ashe',3,'','','',NULL,NULL,'','','','','Robinia ×margaretta Ashe','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('684','','','Millettieae',1,'Millettieae','Millettieae','Millettieae',1,0,'','','','3ed67db0-fed5-56ad-a7de-d595096058f0','Millettieae','','TRIBE','Millettieae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('956','','','Chamaecrista Linnaeus',1,'Chamaecrista','Chamaecrista','Chamaecrista',1,0,'','','Linnaeus','b2202f87-b6bb-5e10-8caf-fb068fe1da58','Chamaecrista Linnaeus','Linnaeus','GENUS','Chamaecrista','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5731','','','Gleditsia triacanthos Linnaeus',1,'Gleditsia triacanthos','Gleditsia triacanthos','Gleditsia triacanth',2,0,'','','Linnaeus','65af189d-1465-5b3b-be57-7eed43954428','Gleditsia triacanthos Linnaeus','Linnaeus','SPECIES','','Gleditsia','','triacanthos','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('654','','','Polygaleae Fries',1,'Polygaleae','Polygaleae','Polygaleae',1,0,'','','Fries','44cdc758-be60-573e-bb91-087c0a5108c2','Polygaleae Fries','Fries','TRIBE','Polygaleae','','','','','','',NULL,'','','','','','Fries','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8100','','','Polygala vulgaris Linnaeus',1,'Polygala vulgaris','Polygala vulgaris','Polygala uulgar',2,0,'','','Linnaeus','711ed916-408f-546a-b87d-e5cba8b516b0','Polygala vulgaris Linnaeus','Linnaeus','SPECIES','','Polygala','','vulgaris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34035','','','Senega Spach',1,'Senega','Senega','Senega',1,0,'','','Spach','bd251afc-2213-5339-8b04-7e44a15e30d6','Senega Spach','Spach','GENUS','Senega','','','','','','',NULL,'','','','','','Spach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34038','','','Senega polygama (Walter) J.F.B. Pastore & J.R. Abbott',1,'Senega polygama','Senega polygama','Senega polygam',2,0,'','','Walter|J. F. B. Pastore|J. R. Abbott','44151330-b78e-5412-9bf1-1ba6300d2bcd','Senega polygama (Walter) J.F.B. Pastore & J.R. Abbott','(Walter) J.F.B. Pastore & J.R. Abbott','SPECIES','','Senega','','polygama','','','',NULL,'J. F. B. Pastore & J. R. Abbott','','','','','Walter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34042','','','Senega sect. Sanguineae J.F.B. Pastore & J.R. Abbott',2,'Sanguineae','Senega sect. Sanguineae','Sanguineae',1,0,'','','J. F. B. Pastore|J. R. Abbott','7cf1c7f0-b60d-5dc5-817d-e9bf9f843c26','Senega sect. Sanguineae J.F.B. Pastore & J.R. Abbott','J.F.B. Pastore & J.R. Abbott','SECTION','Sanguineae','','','','','','',NULL,'','','','','','J. F. B. Pastore & J. R. Abbott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34044','','','Senega sect. Verticillatae J.F.B. Pastore & J.R. Abbott',2,'Verticillatae','Senega sect. Verticillatae','Verticillatae',1,0,'','','J. F. B. Pastore|J. R. Abbott','58a55e4a-8f60-5a27-bbe5-612846a39243','Senega sect. Verticillatae J.F.B. Pastore & J.R. Abbott','J.F.B. Pastore & J.R. Abbott','SECTION','Verticillatae','','','','','','',NULL,'','','','','','J. F. B. Pastore & J. R. Abbott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3674','','','Alnus glutinosa (Linnaeus) Gaertner',1,'Alnus glutinosa','Alnus glutinosa','Alnus glutinos',2,0,'','','Linnaeus|Gaertner','ed5d60e2-fb4c-5dce-be7d-9de91c1a1568','Alnus glutinosa (Linnaeus) Gaertner','(Linnaeus) Gaertner','SPECIES','','Alnus','','glutinosa','','','',NULL,'Gaertner','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3675','','','Alnus incana subsp. rugosa (Du Roi) R.T. Clausen',1,'Alnus incana rugosa','Alnus incana subsp. rugosa','Alnus incan rugos',3,0,'','','Du Roi|R. T. Clausen','884512fa-3882-5cf6-a688-6410da8c9fdb','Alnus incana subsp. rugosa (Du Roi) R.T. Clausen','(Du Roi) R.T. Clausen','SUBSPECIES','','Alnus','','incana','rugosa','','',NULL,'R. T. Clausen','','','','','Du Roi','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29223','','','Alnus alnobetula (Ehrhart) K. Koch',1,'Alnus alnobetula','Alnus alnobetula','Alnus alnobetul',2,0,'','','Ehrhart|K. Koch','60130fe6-4b84-5d66-b3d2-243c5ccea881','Alnus alnobetula (Ehrhart) K. Koch','(Ehrhart) K. Koch','SPECIES','','Alnus','','alnobetula','','','',NULL,'K. Koch','','','','','Ehrhart','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3685','','','Betula alleghaniensis Britton',1,'Betula alleghaniensis','Betula alleghaniensis','Betula alleghaniens',2,0,'','','Britton','275fcf87-8ad8-5a3e-adac-2346ac4e6246','Betula alleghaniensis Britton','Britton','SPECIES','','Betula','','alleghaniensis','','','',NULL,'','','','','','Britton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33636','','','Betula sect. Betula Linnaeus',2,'Betula','Betula sect. Betula','Betula',1,0,'','','Linnaeus','941b0717-189b-5719-88a7-971f9c34de3b','Betula sect. Betula Linnaeus','Linnaeus','SECTION','Betula','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3698','','','Betula pendula Roth',1,'Betula pendula','Betula pendula','Betula pendul',2,0,'','','Roth','e3796294-800e-56c5-bdc7-de0cfb8b25ff','Betula pendula Roth','Roth','SPECIES','','Betula','','pendula','','','',NULL,'','','','','','Roth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3707','','','Betula ×caerulea-grandis Blanchard',3,'','','',NULL,NULL,'','','','','Betula ×caerulea-grandis Blanchard','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3700','','','Betula pubescens Ehrhart subsp. pubescens',1,'Betula pubescens pubescens','Betula pubescens subsp. pubescens','Betula pubescens pubescens',3,0,'','','','2dc729f0-6e1b-5ef7-84fb-44a0cdac32a2','Betula pubescens Ehrhart subsp. pubescens','Ehrhart','SUBSPECIES','','Betula','','pubescens','pubescens','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3718','','','Betula ×winteri Dugle',3,'','','',NULL,NULL,'','','','','Betula ×winteri Dugle','Dugle','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33637','','','Betula sect. Apterocaryon Spach',2,'Apterocaryon','Betula sect. Apterocaryon','Apterocaryon',1,0,'','','Spach','96ea177d-9529-59fb-a744-52ef37669614','Betula sect. Apterocaryon Spach','Spach','SECTION','Apterocaryon','','','','','','',NULL,'','','','','','Spach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3687','','','Betula glandulosa Michaux',1,'Betula glandulosa','Betula glandulosa','Betula glandulos',2,0,'','','Michaux','01367e5f-48a6-581b-bc55-98dab58c566b','Betula glandulosa Michaux','Michaux','SPECIES','','Betula','','glandulosa','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3704','','','Betula pumila Linnaeus',1,'Betula pumila','Betula pumila','Betula pumil',2,0,'','','Linnaeus','f88e4d3d-7564-5ca9-8be1-6f95ecc8a4a9','Betula pumila Linnaeus','Linnaeus','SPECIES','','Betula','','pumila','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3708','','','Betula ×dugleana Lepage',3,'','','',NULL,NULL,'','','','','Betula ×dugleana Lepage','Lepage','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27145','','','Betula ×borggreveana Zabel ex H.J.P. Winkler',3,'','','',NULL,NULL,'','','','','Betula ×borggreveana Zabel ex H.J.P. Winkler','Zabel ex H.J.P. Winkler','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3722','','','Corylus avellana Linnaeus',1,'Corylus avellana','Corylus avellana','Corylus auellan',2,0,'','','Linnaeus','fd71aa15-ed31-5357-b12f-1ac42a88e6c7','Corylus avellana Linnaeus','Linnaeus','SPECIES','','Corylus','','avellana','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3727','','','Ostrya virginiana (Miller) K. Koch',1,'Ostrya virginiana','Ostrya virginiana','Ostrya uirginian',2,0,'','','Miller|K. Koch','d17f59c5-ec10-5cba-910f-3aa2da344eb6','Ostrya virginiana (Miller) K. Koch','(Miller) K. Koch','SPECIES','','Ostrya','','virginiana','','','',NULL,'K. Koch','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5965','','','Quercus macrocarpa Michaux',1,'Quercus macrocarpa','Quercus macrocarpa','Quercus macrocarp',2,0,'','','Michaux','91004b1b-28c2-5301-b8c4-03b0a3cb5ac2','Quercus macrocarpa Michaux','Michaux','SPECIES','','Quercus','','macrocarpa','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5974','','','Quercus ×deamii Trelease',3,'','','',NULL,NULL,'','','','','Quercus ×deamii Trelease','Trelease','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5962','','','Quercus garryana Douglas ex Hooker var. garryana',2,'Quercus garryana garryana','Quercus garryana var. garryana','Quercus garryan garryan',3,0,'','','','c5da4dc6-d944-559a-b90b-0b21bb4b3c77','Quercus garryana Douglas ex Hooker var. garryana','Douglas ex Hooker','VARIETY','','Quercus','','garryana','garryana','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5970','','','Quercus rubra Linnaeus',1,'Quercus rubra','Quercus rubra','Quercus rubr',2,0,'','','Linnaeus','86269295-2157-526d-bb11-e7d2286d2c48','Quercus rubra Linnaeus','Linnaeus','SPECIES','','Quercus','','rubra','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5975','','','Quercus ×hawkinsii Sudworth',3,'','','',NULL,NULL,'','','','','Quercus ×hawkinsii Sudworth','Sudworth','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5957','','','Fagus grandifolia Ehrhart',1,'Fagus grandifolia','Fagus grandifolia','Fagus grandifol',2,0,'','','Ehrhart','1c55c67b-f2cf-57c0-b8b6-2180b84b00d0','Fagus grandifolia Ehrhart','Ehrhart','SPECIES','','Fagus','','grandifolia','','','',NULL,'','','','','','Ehrhart','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('955','','','Carya Nuttall',1,'Carya','Carya','Carya',1,0,'','','Nuttall','55a8e8cb-7d21-58fa-9594-129b69392f36','Carya Nuttall','Nuttall','GENUS','Carya','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6237','','','Carya laciniosa (F. Michaux) G. Don',1,'Carya laciniosa','Carya laciniosa','Carya lacinios',2,0,'','','F. Michaux|G. Don','fa90fe1e-5b10-533b-9ddc-57e4262bba9f','Carya laciniosa (F. Michaux) G. Don','(F. Michaux) G. Don','SPECIES','','Carya','','laciniosa','','','',NULL,'G. Don','','','','','F. Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6243','','','Juglans nigra Linnaeus',1,'Juglans nigra','Juglans nigra','Juglans nigr',2,0,'','','Linnaeus','db48576f-0321-5e81-82bf-085e8ca13299','Juglans nigra Linnaeus','Linnaeus','SPECIES','','Juglans','','nigra','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('316','','','Myricoideae',1,'Myricoideae','Myricoideae','Myricoideae',1,0,'','','','c2da1f5d-664c-5318-8af6-867617964e88','Myricoideae','','SUBFAMILY','Myricoideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6681','','','Morella pensylvanica (Mirbel) Kartesz',1,'Morella pensylvanica','Morella pensylvanica','Morella pensyluanic',2,0,'','','Mirbel|Kartesz','93bff0f2-2145-562a-9e66-d90e9e495e2d','Morella pensylvanica (Mirbel) Kartesz','(Mirbel) Kartesz','SPECIES','','Morella','','pensylvanica','','','',NULL,'Kartesz','','','','','Mirbel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6038','','','Geranium carolinianum Linnaeus',1,'Geranium carolinianum','Geranium carolinianum','Geranium carolinian',2,0,'','','Linnaeus','2ca4271b-c1a2-5b3e-8633-5c164a7d1dd5','Geranium carolinianum Linnaeus','Linnaeus','SPECIES','','Geranium','','carolinianum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6044','','','Geranium oreganum Howell',1,'Geranium oreganum','Geranium oreganum','Geranium oregan',2,0,'','','Howell','0a07055b-85df-53bb-84b2-a71c5d254a28','Geranium oreganum Howell','Howell','SPECIES','','Geranium','','oreganum','','','',NULL,'','','','','','Howell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6052','','','Geranium sylvaticum Linnaeus',1,'Geranium sylvaticum','Geranium sylvaticum','Geranium syluatic',2,0,'','','Linnaeus','84a50267-aadb-5b3d-9eb6-4c5a560e2c3d','Geranium sylvaticum Linnaeus','Linnaeus','SPECIES','','Geranium','','sylvaticum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29055','','','Geranium lucidum Linnaeus',1,'Geranium lucidum','Geranium lucidum','Geranium lucid',2,0,'','','Linnaeus','6fe4a0f9-c1ec-5513-ae0a-d689bbc8dd7b','Geranium lucidum Linnaeus','Linnaeus','SPECIES','','Geranium','','lucidum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33367','','','Geranium ibericum Cavanilles',1,'Geranium ibericum','Geranium ibericum','Geranium iberic',2,0,'','','Cavanilles','a029914c-46f3-58e8-9939-a0036d32c9ed','Geranium ibericum Cavanilles','Cavanilles','SPECIES','','Geranium','','ibericum','','','',NULL,'','','','','','Cavanilles','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('127','','','Elatinaceae Dumortier',1,'Elatinaceae','Elatinaceae','Elatinaceae',1,0,'','','Dumortier','01eaa763-ab08-5e88-bf48-4fca03e2ef7c','Elatinaceae Dumortier','Dumortier','FAMILY','Elatinaceae','','','','','','',NULL,'','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9710','','','Elatine brachysperma A. Gray',1,'Elatine brachysperma','Elatine brachysperma','Elatine brachysperm',2,0,'','','A. Gray','8daf1c69-667c-5afd-9db8-ca2ce822917c','Elatine brachysperma A. Gray','A. Gray','SPECIES','','Elatine','','brachysperma','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1412','','','Mercurialis Linnaeus',1,'Mercurialis','Mercurialis','Mercurialis',1,0,'','','Linnaeus','63f195de-8997-5c2c-8a64-573644ac4c16','Mercurialis Linnaeus','Linnaeus','GENUS','Mercurialis','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1164','','','Euphorbia Linnaeus',1,'Euphorbia','Euphorbia','Euphorbia',1,0,'','','Linnaeus','c3f5bfae-bb33-5990-95b0-960e353bd588','Euphorbia Linnaeus','Linnaeus','GENUS','Euphorbia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5608','','','Euphorbia esula Linnaeus',1,'Euphorbia esula','Euphorbia esula','Euphorbia esul',2,0,'','','Linnaeus','9a7ad6cf-a3f6-5b58-9a4f-ac15ae157044','Euphorbia esula Linnaeus','Linnaeus','SPECIES','','Euphorbia','','esula','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5614','','','Euphorbia myrsinites Linnaeus',1,'Euphorbia myrsinites','Euphorbia myrsinites','Euphorbia myrsinit',2,0,'','','Linnaeus','0307aaaa-44b7-5977-928f-2a068775393f','Euphorbia myrsinites Linnaeus','Linnaeus','SPECIES','','Euphorbia','','myrsinites','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5612','','','Euphorbia lucida Waldstein & Kitamura',1,'Euphorbia lucida','Euphorbia lucida','Euphorbia lucid',2,0,'','','Waldstein|Kitamura','c4e52aaf-2e6b-558f-83f8-56d5d3820b31','Euphorbia lucida Waldstein & Kitamura','Waldstein & Kitamura','SPECIES','','Euphorbia','','lucida','','','',NULL,'','','','','','Waldstein & Kitamura','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5590','','','Euphorbia glyptosperma Engelmann',1,'Euphorbia glyptosperma','Euphorbia glyptosperma','Euphorbia glyptosperm',2,0,'','','Engelmann','694d12aa-a901-5a19-8a1d-707395dad5c0','Euphorbia glyptosperma Engelmann','Engelmann','SPECIES','','Euphorbia','','glyptosperma','','','',NULL,'','','','','','Engelmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5593','','','Euphorbia nutans Lagasca',1,'Euphorbia nutans','Euphorbia nutans','Euphorbia nutans',2,0,'','','Lagasca','48181b1b-421e-5a25-a3ac-0246cdf0bb5a','Euphorbia nutans Lagasca','Lagasca','SPECIES','','Euphorbia','','nutans','','','',NULL,'','','','','','Lagasca','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5597','','','Euphorbia serpillifolia Persoon',1,'Euphorbia serpillifolia','Euphorbia serpillifolia','Euphorbia serpillifol',2,0,'','','Persoon','da734b5b-2dbc-55f6-abcd-657ee28a5980','Euphorbia serpillifolia Persoon','Persoon','SPECIES','','Euphorbia','','serpillifolia','','','',NULL,'','','','','','Persoon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5613','','','Euphorbia marginata Pursh',1,'Euphorbia marginata','Euphorbia marginata','Euphorbia marginat',2,0,'','','Pursh','27c119e9-21fa-5903-b08f-9801bf691b8a','Euphorbia marginata Pursh','Pursh','SPECIES','','Euphorbia','','marginata','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('587','','','Hypericeae',1,'Hypericeae','Hypericeae','Hypericeae',1,0,'','','','ab09ab9f-bcbc-5077-8d25-3e2b9c3307a1','Hypericeae','','TRIBE','Hypericeae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2172','','','Hypericum sect. Brathys (Mutis ex Linnaeus f.) Choisy',2,'Brathys','Hypericum sect. Brathys','Brathys',1,0,'','','Mutis|Linnaeus fil.|Choisy','141f0fce-153c-5476-86d8-e47dfffab1e9','Hypericum sect. Brathys (Mutis ex Linnaeus f.) Choisy','(Mutis ex Linnaeus f.) Choisy','SECTION','Brathys','','','','','','',NULL,'Choisy','','','','','Mutis','','Linnaeus fil.','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6169','','','Hypericum ×dissimulatum E.P. Bicknell',3,'','','',NULL,NULL,'','','','','Hypericum ×dissimulatum E.P. Bicknell','E.P. Bicknell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6160','','','Hypericum mutilum Linnaeus',1,'Hypericum mutilum','Hypericum mutilum','Hypericum mutil',2,0,'','','Linnaeus','f50c943c-a622-5448-88fe-b0bd56d842ed','Hypericum mutilum Linnaeus','Linnaeus','SPECIES','','Hypericum','','mutilum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('16605','','','Hypericum boreale (Britton) E.P. Bicknell',1,'Hypericum boreale','Hypericum boreale','Hypericum boreal',2,0,'','','Britton|E. P. Bicknell','2d7ac6f4-63ca-5e3c-af0c-5987447576dc','Hypericum boreale (Britton) E.P. Bicknell','(Britton) E.P. Bicknell','SPECIES','','Hypericum','','boreale','','','',NULL,'E. P. Bicknell','','','','','Britton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6153','','','Hypericum ellipticum Hooker',1,'Hypericum ellipticum','Hypericum ellipticum','Hypericum elliptic',2,0,'','','Hooker','77cead05-88c7-506d-bfc5-c27c2e0dfcf2','Hypericum ellipticum Hooker','Hooker','SPECIES','','Hypericum','','ellipticum','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9570','','','Hypericum frondosum Michaux',1,'Hypericum frondosum','Hypericum frondosum','Hypericum frondos',2,0,'','','Michaux','3a5b5733-8b21-5cc3-b523-00d92f6acf45','Hypericum frondosum Michaux','Michaux','SPECIES','','Hypericum','','frondosum','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6163','','','Hypericum perforatum Linnaeus',1,'Hypericum perforatum','Hypericum perforatum','Hypericum perforat',2,0,'','','Linnaeus','23cdcead-7b97-5a2e-8484-8e874de5363c','Hypericum perforatum Linnaeus','Linnaeus','SPECIES','','Hypericum','','perforatum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('25892','','','Hypericum hirsutum Linnaeus',1,'Hypericum hirsutum','Hypericum hirsutum','Hypericum hirsut',2,0,'','','Linnaeus','0e328676-0d1f-578b-a2ca-bd1bdcd05617','Hypericum hirsutum Linnaeus','Linnaeus','SPECIES','','Hypericum','','hirsutum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('157','','','Linaceae de Candolle ex Perleb',2,'Linaceae','Linaceae','Linaceae',1,0,'','','de Candolle|Perleb','93121c1a-f7bf-55f6-91f0-9e71e0fac7a7','Linaceae de Candolle ex Perleb','de Candolle ex Perleb','FAMILY','Linaceae','','','','','','',NULL,'','','','','','de Candolle','','Perleb','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9796','','','Linum pratense (Norton) Small',1,'Linum pratense','Linum pratense','Linum pratens',2,0,'','','Norton|Small','4f89d52e-824e-5382-9aa5-020306802951','Linum pratense (Norton) Small','(Norton) Small','SPECIES','','Linum','','pratense','','','',NULL,'Small','','','','','Norton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17115','','','Linum lewisii Pursh var. lewisii',1,'Linum lewisii lewisii','Linum lewisii var. lewisii','Linum lewis lewis',3,0,'','','','0236d8fe-8f63-5f1d-9fb4-7e024d6ac465','Linum lewisii Pursh var. lewisii','Pursh','VARIETY','','Linum','','lewisii','lewisii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6553','','','Linum medium (Planchon) Britton var. medium',1,'Linum medium medium','Linum medium var. medium','Linum medi medi',3,0,'','','','7647b5f1-11e8-5c70-85a7-17aa3a0873c9','Linum medium (Planchon) Britton var. medium','(Planchon) Britton','VARIETY','','Linum','','medium','medium','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28788','','','Linum compactum A. Nelson',1,'Linum compactum','Linum compactum','Linum compact',2,0,'','','A. Nelson','54c594a8-1f27-51cb-9770-eb2fd612acf2','Linum compactum A. Nelson','A. Nelson','SPECIES','','Linum','','compactum','','','',NULL,'','','','','','A. Nelson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17127','','','Radiola linoides Roth',1,'Radiola linoides','Radiola linoides','Radiola linoid',2,0,'','','Roth','5cb85dc1-4bbe-555b-bcf4-fdaac11ad695','Radiola linoides Roth','Roth','SPECIES','','Radiola','','linoides','','','',NULL,'','','','','','Roth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1568','','','Podostemum Michaux',1,'Podostemum','Podostemum','Podostemum',1,0,'','','Michaux','913132b3-61d7-5b20-b124-4e409ce49eae','Podostemum Michaux','Michaux','GENUS','Podostemum','','','','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9052','','','Populus nigra Linnaeus',1,'Populus nigra','Populus nigra','Populus nigr',2,0,'','','Linnaeus','d69ea401-e788-5cde-be7b-2a08678996ce','Populus nigra Linnaeus','Linnaeus','SPECIES','','Populus','','nigra','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2292','','','Populus sect. Intersectional',2,'Intersectional','Populus sect. Intersectional','Intersectional',1,0,'','','','7862759a-22c2-5da5-9992-ff20d7ebacc8','Populus sect. Intersectional','','SECTION','Intersectional','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9058','','','Populus ×canescens (Aiton) Smith',3,'','','',NULL,NULL,'','','','','Populus ×canescens (Aiton) Smith','(Aiton) Smith','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2290','','','Populus sect. Populus',2,'Populus','Populus sect. Populus','Populus',1,0,'','','','374ac205-5e29-535e-84c4-f4c305cf6843','Populus sect. Populus','','SECTION','Populus','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2288','','','Populus sect. Tacamahaca Spach',2,'Tacamahaca','Populus sect. Tacamahaca','Tacamahaca',1,0,'','','Spach','439bad66-70e3-5307-945f-ae400e0ff7ce','Populus sect. Tacamahaca Spach','Spach','SECTION','Tacamahaca','','','','','','',NULL,'','','','','','Spach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9045','','','Populus trichocarpa Torrey & A. Gray',1,'Populus trichocarpa','Populus trichocarpa','Populus trichocarp',2,0,'','','Torrey|A. Gray','17953e67-453f-58ca-ad6e-70d4a4bcb9fc','Populus trichocarpa Torrey & A. Gray','Torrey & A. Gray','SPECIES','','Populus','','trichocarpa','','','',NULL,'','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9608','','','Salix barclayi × Salix glauca subsp. glabrescens',2,'Salix barclayi × Salix glauca glabrescens','Salix barclayi × Salix glauca subsp. glabrescens','Salix barclay × Salix glauc glabrescens',0,0,'HYBRID_FORMULA','','','4da64732-20b7-5a60-b8b1-6495f0398539','Salix barclayi × Salix glauca subsp. glabrescens','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9611','','','Salix eriocephala × Salix petiolaris',2,'Salix eriocephala × Salix petiolaris','Salix eriocephala × Salix petiolaris','Salix eriocephal × Salix petiolar',0,0,'HYBRID_FORMULA','','','eadc0773-cb5d-5f48-bdef-bd0e0d716ea1','Salix eriocephala × Salix petiolaris','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2056','','','Salix subg. Chamaetia (Dumortier) Nasarov',2,'Chamaetia','Salix subgen. Chamaetia','Chamaetia',1,0,'','','Dumortier|Nasarov','1b050395-f096-57b0-a2bb-a95c11931668','Salix subg. Chamaetia (Dumortier) Nasarov','(Dumortier) Nasarov','SUBGENUS','Chamaetia','','','','','','',NULL,'Nasarov','','','','','Dumortier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9853','','','Salix glauca var. cordifolia × Salix pedicellaris',2,'Salix glauca cordifolia × Salix pedicellaris','Salix glauca var. cordifolia × Salix pedicellaris','Salix glauc cordifol × Salix pedicellar',0,0,'HYBRID_FORMULA','','','1385ae64-41d3-5e4e-9237-7a58f6ddfc90','Salix glauca var. cordifolia × Salix pedicellaris','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9069','','','Salix arctica Pallas',1,'Salix arctica','Salix arctica','Salix arctic',2,0,'','','Pallas','56c550dd-eedc-5bd1-ad19-8061a7fe14fa','Salix arctica Pallas','Pallas','SPECIES','','Salix','','arctica','','','',NULL,'','','','','','Pallas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9132','','','Salix niphoclada Rydberg',1,'Salix niphoclada','Salix niphoclada','Salix niphoclad',2,0,'','','Rydberg','4df094e4-6226-526b-a930-984b679c40ea','Salix niphoclada Rydberg','Rydberg','SPECIES','','Salix','','niphoclada','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9109','','','Salix glauca var. acutifolia (Hooker) C.K. Schneider',1,'Salix glauca acutifolia','Salix glauca var. acutifolia','Salix glauc acutifol',3,0,'','','Hooker|C. K. Schneider','7fe15ce1-c85a-5911-a36c-38c694c4cca8','Salix glauca var. acutifolia (Hooker) C.K. Schneider','(Hooker) C.K. Schneider','VARIETY','','Salix','','glauca','acutifolia','','',NULL,'C. K. Schneider','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2313','','','Salix sect. Herbella Seringe',2,'Herbella','Salix sect. Herbella','Herbella',1,0,'','','Seringe','3b6d5614-9aeb-5b28-b1cb-129c6ce43cdd','Salix sect. Herbella Seringe','Seringe','SECTION','Herbella','','','','','','',NULL,'','','','','','Seringe','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9156','','','Salix rotundifolia Trautvetter var. rotundifolia',1,'Salix rotundifolia rotundifolia','Salix rotundifolia var. rotundifolia','Salix rotundifol rotundifol',3,0,'','','','464a0404-525f-52b4-a7fb-389f87d2bbb8','Salix rotundifolia Trautvetter var. rotundifolia','Trautvetter','VARIETY','','Salix','','rotundifolia','rotundifolia','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9151','','','Salix raupii Argus',1,'Salix raupii','Salix raupii','Salix raup',2,0,'','','Argus','0b7e779f-d127-5439-b9ba-75cc12bd6916','Salix raupii Argus','Argus','SPECIES','','Salix','','raupii','','','',NULL,'','','','','','Argus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9177','','','Salix ×gaspeensis C.K. Schneider',3,'','','',NULL,NULL,'','','','','Salix ×gaspeensis C.K. Schneider','C.K. Schneider','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9603','','','Salix ×hebecarpa (Fernald) Fernald',3,'','','',NULL,NULL,'','','','','Salix ×hebecarpa (Fernald) Fernald','(Fernald) Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9107','','','Salix fuscescens Andersson',1,'Salix fuscescens','Salix fuscescens','Salix fuscescens',2,0,'','','Andersson','a9374dd8-ea67-5e98-848f-b62612fef442','Salix fuscescens Andersson','Andersson','SPECIES','','Salix','','fuscescens','','','',NULL,'','','','','','Andersson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9164','','','Salix stolonifera Coville',1,'Salix stolonifera','Salix stolonifera','Salix stolonifer',2,0,'','','Coville','92ed9fe2-a579-5f60-819c-8dd3d6715b25','Salix stolonifera Coville','Coville','SPECIES','','Salix','','stolonifera','','','',NULL,'','','','','','Coville','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2321','','','Salix sect. Setchellianae Argus',2,'Setchellianae','Salix sect. Setchellianae','Setchellianae',1,0,'','','Argus','6c5c043b-16b0-5257-89b5-68f4d48eb772','Salix sect. Setchellianae Argus','Argus','SECTION','Setchellianae','','','','','','',NULL,'','','','','','Argus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9604','','','Salix ×argusii B. Boivin',3,'','','',NULL,NULL,'','','','','Salix ×argusii B. Boivin','B. Boivin','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9102','','','Salix exigua Nuttall',1,'Salix exigua','Salix exigua','Salix exigu',2,0,'','','Nuttall','005a19ed-7d4d-53c4-948b-32b2c242c522','Salix exigua Nuttall','Nuttall','SPECIES','','Salix','','exigua','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28350','','','Salix exigua var. hindsiana (Bentham) Dorn',1,'Salix exigua hindsiana','Salix exigua var. hindsiana','Salix exigu hindsian',3,0,'','','Bentham|Dorn','e37247a2-3df6-58cd-8cd7-0c160aef02d7','Salix exigua var. hindsiana (Bentham) Dorn','(Bentham) Dorn','VARIETY','','Salix','','exigua','hindsiana','','',NULL,'Dorn','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9131','','','Salix nigra Marshall',1,'Salix nigra','Salix nigra','Salix nigr',2,0,'','','Marshall','8e4eba27-9459-5884-a8c3-a3c3f113714d','Salix nigra Marshall','Marshall','SPECIES','','Salix','','nigra','','','',NULL,'','','','','','Marshall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9122','','','Salix lasiandra Bentham',1,'Salix lasiandra','Salix lasiandra','Salix lasiandr',2,0,'','','Bentham','102ce779-0b26-5e78-a295-918db0baff74','Salix lasiandra Bentham','Bentham','SPECIES','','Salix','','lasiandra','','','',NULL,'','','','','','Bentham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9075','','','Salix babylonica Linnaeus',1,'Salix babylonica','Salix babylonica','Salix babylonic',2,0,'','','Linnaeus','ac05bc4e-9be0-51ff-aab1-849d37c491db','Salix babylonica Linnaeus','Linnaeus','SPECIES','','Salix','','babylonica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9622','','','Salix alaxensis var. alaxensis × Salix calcicola var. calcicola',2,'Salix alaxensis alaxensis × Salix calcicola calcicola','Salix alaxensis var. alaxensis × Salix calcicola var. calcicola','Salix alaxens alaxens × Salix calcicol calcicol',0,0,'HYBRID_FORMULA','','','f6357f3b-d939-5f38-ba15-553bc1cf2397','Salix alaxensis var. alaxensis × Salix calcicola var. calcicola','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9624','','','Salix barrattiana × Salix commutata',2,'Salix barrattiana × Salix commutata','Salix barrattiana × Salix commutata','Salix barrattian × Salix commutat',0,0,'HYBRID_FORMULA','','','c7611cbe-8072-54a4-845d-2440187bdf89','Salix barrattiana × Salix commutata','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9626','','','Salix geyeriana × Salix lemmonii',2,'Salix geyeriana × Salix lemmonii','Salix geyeriana × Salix lemmonii','Salix geyerian × Salix lemmon',0,0,'HYBRID_FORMULA','','','600274dc-c324-5902-ac39-a8e9fd2e6078','Salix geyeriana × Salix lemmonii','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2309','','','Salix sect. Canae A. Kerner',2,'Canae','Salix sect. Canae','Canae',1,0,'','','A. Kerner','95bc598e-b5a6-5f76-9507-a41bef370b95','Salix sect. Canae A. Kerner','A. Kerner','SECTION','Canae','','','','','','',NULL,'','','','','','A. Kerner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2301','','','Salix sect. Cinerella Seringe',2,'Cinerella','Salix sect. Cinerella','Cinerella',1,0,'','','Seringe','9b5b50d0-de94-5166-9eef-6b137169d7e5','Salix sect. Cinerella Seringe','Seringe','SECTION','Cinerella','','','','','','',NULL,'','','','','','Seringe','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9093','','','Salix cinerea Linnaeus',1,'Salix cinerea','Salix cinerea','Salix cinere',2,0,'','','Linnaeus','a81c528b-2951-5534-b0eb-ed1ef21aed7d','Salix cinerea Linnaeus','Linnaeus','SPECIES','','Salix','','cinerea','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9116','','','Salix hookeriana Barratt ex Hooker',2,'Salix hookeriana','Salix hookeriana','Salix hookerian',2,0,'','','Barratt|Hooker','298de989-b570-5420-8d82-0ee270d1d3e4','Salix hookeriana Barratt ex Hooker','Barratt ex Hooker','SPECIES','','Salix','','hookeriana','','','',NULL,'','','','','','Barratt','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9125','','','Salix lutea Nuttall',1,'Salix lutea','Salix lutea','Salix lute',2,0,'','','Nuttall','0444a310-d384-5c54-a0db-c547b0524046','Salix lutea Nuttall','Nuttall','SPECIES','','Salix','','lutea','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9079','','','Salix bebbiana Sargent',1,'Salix bebbiana','Salix bebbiana','Salix bebbian',2,0,'','','Sargent','678d961f-b267-5a7e-84f3-efcce5c93091','Salix bebbiana Sargent','Sargent','SPECIES','','Salix','','bebbiana','','','',NULL,'','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9120','','','Salix lemmonii Bebb',1,'Salix lemmonii','Salix lemmonii','Salix lemmon',2,0,'','','Bebb','331bfe69-a3d3-5048-80e6-8cc28330f3ba','Salix lemmonii Bebb','Bebb','SPECIES','','Salix','','lemmonii','','','',NULL,'','','','','','Bebb','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9158','','','Salix sericea Marshall',1,'Salix sericea','Salix sericea','Salix serice',2,0,'','','Marshall','3fbb4546-fbde-5ac8-9601-18c3aca9196f','Salix sericea Marshall','Marshall','SPECIES','','Salix','','sericea','','','',NULL,'','','','','','Marshall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9105','','','Salix farriae C.R. Ball',1,'Salix farriae','Salix farriae','Salix farri',2,0,'','','C. R. Ball','462e22f4-8b01-5605-8763-10d654f0eb06','Salix farriae C.R. Ball','C.R. Ball','SPECIES','','Salix','','farriae','','','',NULL,'','','','','','C. R. Ball','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2306','','','Salix sect. Lanatae (Andersson) Koehne',2,'Lanatae','Salix sect. Lanatae','Lanatae',1,0,'','','Andersson|Koehne','74f29c55-bff3-52e2-9b06-3bc6c7610819','Salix sect. Lanatae (Andersson) Koehne','(Andersson) Koehne','SECTION','Lanatae','','','','','','',NULL,'Koehne','','','','','Andersson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9084','','','Salix calcicola Fernald & Wiegand var. calcicola',1,'Salix calcicola calcicola','Salix calcicola var. calcicola','Salix calcicol calcicol',3,0,'','','','7c290042-6aee-59ad-ba17-528d25903eeb','Salix calcicola Fernald & Wiegand var. calcicola','Fernald & Wiegand','VARIETY','','Salix','','calcicola','calcicola','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2308','','','Salix sect. Phylicifoliae (Fries) Andersson',2,'Phylicifoliae','Salix sect. Phylicifoliae','Phylicifoliae',1,0,'','','Fries|Andersson','528528c0-e6b5-5b5f-aec6-8263938e8cd9','Salix sect. Phylicifoliae (Fries) Andersson','(Fries) Andersson','SECTION','Phylicifoliae','','','','','','',NULL,'Andersson','','','','','Fries','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9148','','','Salix pulchra Chamisso',1,'Salix pulchra','Salix pulchra','Salix pulchr',2,0,'','','Chamisso','fc5d2797-aa31-5ba8-a319-364e3fe78655','Salix pulchra Chamisso','Chamisso','SPECIES','','Salix','','pulchra','','','',NULL,'','','','','','Chamisso','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2293','','','Salix sect. Villosae (Andersson) Rouy',2,'Villosae','Salix sect. Villosae','Villosae',1,0,'','','Andersson|Rouy','b90b8f64-4d0e-5743-94a2-b177897b879e','Salix sect. Villosae (Andersson) Rouy','(Andersson) Rouy','SECTION','Villosae','','','','','','',NULL,'Rouy','','','','','Andersson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9063','','','Salix alaxensis (Andersson) Coville var. alaxensis',1,'Salix alaxensis alaxensis','Salix alaxensis var. alaxensis','Salix alaxens alaxens',3,0,'','','','de5485f1-79fb-52b4-9ae9-597adb55e627','Salix alaxensis (Andersson) Coville var. alaxensis','(Andersson) Coville','VARIETY','','Salix','','alaxensis','alaxensis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9173','','','Salix ×bebbii Gandoger',3,'','','',NULL,NULL,'','','','','Salix ×bebbii Gandoger','Gandoger','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9187','','','Salix ×simulans Fernald',3,'','','',NULL,NULL,'','','','','Salix ×simulans Fernald','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29084','','','Salix ×hudsonensis C.K. Schneider',3,'','','',NULL,NULL,'','','','','Salix ×hudsonensis C.K. Schneider','C.K. Schneider','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1822','','','Viola Linnaeus',1,'Viola','Viola','Viola',1,0,'','','Linnaeus','83b96cc2-6f84-5f5b-8309-ddf7c86c4215','Viola Linnaeus','Linnaeus','GENUS','Viola','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9639','','','Viola adunca var. bellidifolia (Greene) H.D. Harrington',1,'Viola adunca bellidifolia','Viola adunca var. bellidifolia','Viola adunc bellidifol',3,0,'','','Greene|H. D. Harrington','0d70a04a-c72c-56b8-8188-a2f3154a803f','Viola adunca var. bellidifolia (Greene) H.D. Harrington','(Greene) H.D. Harrington','VARIETY','','Viola','','adunca','bellidifolia','','',NULL,'H. D. Harrington','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9532','','','Viola ×eclipes H.E. Ballard',3,'','','',NULL,NULL,'','','','','Viola ×eclipes H.E. Ballard','H.E. Ballard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29340','','','Viola riviniana Reichenbach',1,'Viola riviniana','Viola riviniana','Viola riuinian',2,0,'','','Reichenbach','530079a3-8f40-5d6b-8f47-121ce394c0ae','Viola riviniana Reichenbach','Reichenbach','SPECIES','','Viola','','riviniana','','','',NULL,'','','','','','Reichenbach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21570','','','Viola fimbriatula Smith',1,'Viola fimbriatula','Viola fimbriatula','Viola fimbriatul',2,0,'','','Smith','70d5057c-2216-56c6-84cd-8b576ac3050c','Viola fimbriatula Smith','Smith','SPECIES','','Viola','','fimbriatula','','','',NULL,'','','','','','Smith','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29320','','','Viola palmata Linnaeus var. palmata',1,'Viola palmata palmata','Viola palmata var. palmata','Viola palmat palmat',3,0,'','','','f2cbad90-deb0-5fe5-826e-72576a9d50eb','Viola palmata Linnaeus var. palmata','Linnaeus','VARIETY','','Viola','','palmata','palmata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9534','','','Viola ×melissifolia Greene',3,'','','',NULL,NULL,'','','','','Viola ×melissifolia Greene','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29344','','','Viola subsinuata (Greene) Greene',1,'Viola subsinuata','Viola subsinuata','Viola subsinuat',2,0,'','','Greene','930b58f1-963a-525b-ad5d-2011729b1802','Viola subsinuata (Greene) Greene','(Greene) Greene','SPECIES','','Viola','','subsinuata','','','',NULL,'Greene','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9504','','','Viola pedata Linnaeus var. pedata',1,'Viola pedata pedata','Viola pedata var. pedata','Viola pedat pedat',3,0,'','','','bee1b2a4-3fbb-5418-a5f6-9d64b82127e3','Viola pedata Linnaeus var. pedata','Linnaeus','VARIETY','','Viola','','pedata','pedata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9489','','','Viola howellii A. Gray',1,'Viola howellii','Viola howellii','Viola howell',2,0,'','','A. Gray','23555132-dcdb-53d2-93a8-3b2412fe2e44','Viola howellii A. Gray','A. Gray','SPECIES','','Viola','','howellii','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9528','','','Viola tricolor Linnaeus',1,'Viola tricolor','Viola tricolor','Viola tricolor',2,0,'','','Linnaeus','73e119d0-6867-534d-ace8-0cd37d1a733f','Viola tricolor Linnaeus','Linnaeus','SPECIES','','Viola','','tricolor','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21515','','','Viola rafinesquei Greene',1,'Viola rafinesquei','Viola rafinesquei','Viola rafinesque',2,0,'','','Greene','f429965c-fe75-5f24-82a5-8354dc575a75','Viola rafinesquei Greene','Greene','SPECIES','','Viola','','rafinesquei','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9503','','','Viola palustris Linnaeus',1,'Viola palustris','Viola palustris','Viola palustr',2,0,'','','Linnaeus','4521848c-c3a9-5d57-975f-133b52d9ffcc','Viola palustris Linnaeus','Linnaeus','SPECIES','','Viola','','palustris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9523','','','Viola selkirkii Pursh ex Goldie',2,'Viola selkirkii','Viola selkirkii','Viola selkirk',2,0,'','','Pursh|Goldie','44b093c9-380b-542f-b996-58113b511b18','Viola selkirkii Pursh ex Goldie','Pursh ex Goldie','SPECIES','','Viola','','selkirkii','','','',NULL,'','','','','','Pursh','','Goldie','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9524','','','Viola sempervirens Greene',1,'Viola sempervirens','Viola sempervirens','Viola semperuirens',2,0,'','','Greene','9420ff06-62e7-544f-a5d7-7d748b10f196','Viola sempervirens Greene','Greene','SPECIES','','Viola','','sempervirens','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27559','','','Viola vallicola A. Nelson var. vallicola',1,'Viola vallicola vallicola','Viola vallicola var. vallicola','Viola uallicol uallicol',3,0,'','','','b5d7a195-b865-518c-9e6f-5e487dab85ae','Viola vallicola A. Nelson var. vallicola','A. Nelson','VARIETY','','Viola','','vallicola','vallicola','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9509','','','Viola praemorsa Douglas ex Lindley',2,'Viola praemorsa','Viola praemorsa','Viola praemors',2,0,'','','Douglas|Lindley','24b3fdd6-23a6-5974-9c1a-60b15964f3ee','Viola praemorsa Douglas ex Lindley','Douglas ex Lindley','SPECIES','','Viola','','praemorsa','','','',NULL,'','','','','','Douglas','','Lindley','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29352','','','Viola biflora var. carlottae × Viola glabella',2,'Viola biflora carlottae × Viola glabella','Viola biflora var. carlottae × Viola glabella','Viola biflor carlott × Viola glabell',0,0,'HYBRID_FORMULA','','','e9641a11-b179-5eee-9e2d-ef9a4b11c23a','Viola biflora var. carlottae × Viola glabella','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32663','','','Cubelium Rafinesque ex Britton & A. Brown',2,'Cubelium','Cubelium','Cubelium',1,0,'','','Rafinesque|Britton|A. Brown','840f79ed-356e-5eb1-8e3e-f6e345740fdc','Cubelium Rafinesque ex Britton & A. Brown','Rafinesque ex Britton & A. Brown','GENUS','Cubelium','','','','','','',NULL,'','','','','','Rafinesque','','Britton & A. Brown','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('43','','','Malvales Lindley',1,'Malvales','Malvales','Malvales',1,0,'','','Lindley','6c32e8c0-60a2-5f0e-8f05-8b5d6f88d81a','Malvales Lindley','Lindley','ORDER','Malvales','','','','','','',NULL,'','','','','','Lindley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1260','','','Hudsonia Linnaeus',1,'Hudsonia','Hudsonia','Hudsonia',1,0,'','','Linnaeus','cc8d44e7-4721-56e4-81cc-054078ba757e','Hudsonia Linnaeus','Linnaeus','GENUS','Hudsonia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34111','','','Hudsonia ericoides × Hudsonia tomentosa',2,'Hudsonia ericoides × Hudsonia tomentosa','Hudsonia ericoides × Hudsonia tomentosa','Hudsonia ericoid × Hudsonia tomentos',0,0,'HYBRID_FORMULA','','','f5bbed20-b80e-5a23-865e-0a70f6b737b7','Hudsonia ericoides × Hudsonia tomentosa','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('601','','','Lechidieae',1,'Lechidieae','Lechidieae','Lechidieae',1,0,'','','','2c88f787-e55a-5878-ac47-50b1a3977b9b','Lechidieae','','TRIBE','Lechidieae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4581','','','Lechea minor Linnaeus',1,'Lechea minor','Lechea minor','Lechea minor',2,0,'','','Linnaeus','5d81e843-fcbd-5641-aec0-50134ffa91bc','Lechea minor Linnaeus','Linnaeus','SPECIES','','Lechea','','minor','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26724','','','Lechea mucronata Rafinesque',1,'Lechea mucronata','Lechea mucronata','Lechea mucronat',2,0,'','','Rafinesque','8d1659f4-aed7-5ba9-aae6-32cc23a5e984','Lechea mucronata Rafinesque','Rafinesque','SPECIES','','Lechea','','mucronata','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29033','','','Cistus creticus Linnaeus',1,'Cistus creticus','Cistus creticus','Cistus cretic',2,0,'','','Linnaeus','32c1bf99-48cf-5ba0-b0d6-a17cb09ef9cc','Cistus creticus Linnaeus','Linnaeus','SPECIES','','Cistus','','creticus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('805','','','Althaea Linnaeus',1,'Althaea','Althaea','Althaea',1,0,'','','Linnaeus','c2b364d8-9de6-56e8-9454-b808c618c0ee','Althaea Linnaeus','Linnaeus','GENUS','Althaea','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6618','','','Anoda cristata (Linnaeus) Schlechtendal',1,'Anoda cristata','Anoda cristata','Anoda cristat',2,0,'','','Linnaeus|Schlechtendal','86ea8bce-34c2-5ece-8310-3c04d0292d6e','Anoda cristata (Linnaeus) Schlechtendal','(Linnaeus) Schlechtendal','SPECIES','','Anoda','','cristata','','','',NULL,'Schlechtendal','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6628','','','Malva neglecta Wallroth',1,'Malva neglecta','Malva neglecta','Malva neglect',2,0,'','','Wallroth','ae6b7378-930b-58f4-90a9-5f78aeb20323','Malva neglecta Wallroth','Wallroth','SPECIES','','Malva','','neglecta','','','',NULL,'','','','','','Wallroth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6631','','','Malva sylvestris Linnaeus',1,'Malva sylvestris','Malva sylvestris','Malva syluestr',2,0,'','','Linnaeus','ce6e9c52-b4e9-5c11-8235-f2bac2c4c3ef','Malva sylvestris Linnaeus','Linnaeus','SPECIES','','Malva','','sylvestris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6634','','','Sida spinosa Linnaeus',1,'Sida spinosa','Sida spinosa','Sida spinos',2,0,'','','Linnaeus','0b667c4f-6dd1-5c9d-b48f-3c5467d7149a','Sida spinosa Linnaeus','Linnaeus','SPECIES','','Sida','','spinosa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6638','','','Sphaeralcea coccinea (Nuttall ) Rydberg',1,'Sphaeralcea coccinea','Sphaeralcea coccinea','Sphaeralcea coccine',2,0,'','','Nuttall|Rydberg','2f9f9d9c-79cc-52d8-9e11-411bd458c559','Sphaeralcea coccinea (Nuttall ) Rydberg','(Nuttall ) Rydberg','SPECIES','','Sphaeralcea','','coccinea','','','',NULL,'Rydberg','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31185','','','Ripariosida Weakley & D.B. Poindexter',1,'Ripariosida','Ripariosida','Ripariosida',1,0,'','','Weakley|D. B. Poindexter','023dc649-5c42-5220-8488-134cf1f7d7d5','Ripariosida Weakley & D.B. Poindexter','Weakley & D.B. Poindexter','GENUS','Ripariosida','','','','','','',NULL,'','','','','','Weakley & D. B. Poindexter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6622','','','Hibiscus trionum Linnaeus',1,'Hibiscus trionum','Hibiscus trionum','Hibiscus trion',2,0,'','','Linnaeus','f65f5825-e72f-5ab7-92f1-df2f3aa74bc5','Hibiscus trionum Linnaeus','Linnaeus','SPECIES','','Hibiscus','','trionum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1761','','','Tilia Linnaeus',1,'Tilia','Tilia','Tilia',1,0,'','','Linnaeus','3cae578f-63dd-5730-881d-16522443f3ee','Tilia Linnaeus','Linnaeus','GENUS','Tilia','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6644','','','Tilia tomentosa Moench',1,'Tilia tomentosa','Tilia tomentosa','Tilia tomentos',2,0,'','','Moench','06d72a6e-8c4c-549a-b4b0-a9a8579bde36','Tilia tomentosa Moench','Moench','SPECIES','','Tilia','','tomentosa','','','',NULL,'','','','','','Moench','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9412','','','Daphne mezereum Linnaeus',1,'Daphne mezereum','Daphne mezereum','Daphne mezere',2,0,'','','Linnaeus','43ac3762-6147-54c6-910d-c965dfe615ce','Daphne mezereum Linnaeus','Linnaeus','SPECIES','','Daphne','','mezereum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('44','','','Myrtales Reichenbach',1,'Myrtales','Myrtales','Myrtales',1,0,'','','Reichenbach','afd17e4b-9173-5461-944a-1737f9970398','Myrtales Reichenbach','Reichenbach','ORDER','Myrtales','','','','','','',NULL,'','','','','','Reichenbach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('161','','','Lythraceae J. St-Hilaire',1,'Lythraceae','Lythraceae','Lythraceae',1,0,'','','J. St-Hilaire','0fe75ad3-2e6b-5dc3-95b6-d8bacca61ce3','Lythraceae J. St-Hilaire','J. St-Hilaire','FAMILY','Lythraceae','','','','','','',NULL,'','','','','','J. St-Hilaire','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9749','','','Ammannia coccinea Rottbøll',1,'Ammannia coccinea','Ammannia coccinea','Ammannia coccine',2,0,'','','Rottbøll','2d60caec-9d21-5526-9b31-5cc347b8d1f8','Ammannia coccinea Rottbøll','Rottbøll','SPECIES','','Ammannia','','coccinea','','','',NULL,'','','','','','Rottbøll','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1081','','','Decodon J.F. Gmelin',1,'Decodon','Decodon','Decodon',1,0,'','','J. F. Gmelin','872807fa-793a-53e7-bcec-8e025108c8a7','Decodon J.F. Gmelin','J.F. Gmelin','GENUS','Decodon','','','','','','',NULL,'','','','','','J. F. Gmelin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6603','','','Lythrum alatum Pursh var. alatum',1,'Lythrum alatum alatum','Lythrum alatum var. alatum','Lythrum alat alat',3,0,'','','','6a278080-02b0-5afe-a332-2a1ed7650f25','Lythrum alatum Pursh var. alatum','Pursh','VARIETY','','Lythrum','','alatum','alatum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6609','','','Trapa natans Linnaeus',1,'Trapa natans','Trapa natans','Trapa natans',2,0,'','','Linnaeus','2c9f04a7-72fb-5f39-92dd-4068749cf13a','Trapa natans Linnaeus','Linnaeus','SPECIES','','Trapa','','natans','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('666','','','Rhexieae de Candolle',1,'Rhexieae','Rhexieae','Rhexieae',1,0,'','','de Candolle','b0cf424f-a6cd-5bfd-801e-26154cc1a10d','Rhexieae de Candolle','de Candolle','TRIBE','Rhexieae','','','','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('941','','','Camissonia Link',1,'Camissonia','Camissonia','Camissonia',1,0,'','','Link','c8635bc5-5355-5496-9718-1ff47e02164b','Camissonia Link','Link','GENUS','Camissonia','','','','','','',NULL,'','','','','','Link','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6753','','','Clarkia amoena subsp. lindleyi (Douglas) F.H. Lewis & M.E. Lewis',1,'Clarkia amoena lindleyi','Clarkia amoena subsp. lindleyi','Clarkia amoen lindley',3,0,'','','Douglas|F. H. Lewis|M. E. Lewis','96fda4c9-0add-5ce2-be95-cb66683c3d94','Clarkia amoena subsp. lindleyi (Douglas) F.H. Lewis & M.E. Lewis','(Douglas) F.H. Lewis & M.E. Lewis','SUBSPECIES','','Clarkia','','amoena','lindleyi','','',NULL,'F. H. Lewis & M. E. Lewis','','','','','Douglas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9645','','','Clarkia gracilis (Piper) A. Nelson & J.F. Macbride subsp. gracilis',1,'Clarkia gracilis gracilis','Clarkia gracilis subsp. gracilis','Clarkia gracil gracil',3,0,'','','','3ca2e68f-60e1-594a-97e5-72c1f2a22be0','Clarkia gracilis (Piper) A. Nelson & J.F. Macbride subsp. gracilis','(Piper) A. Nelson & J.F. Macbride','SUBSPECIES','','Clarkia','','gracilis','gracilis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6758','','','Clarkia rhomboidea Douglas',1,'Clarkia rhomboidea','Clarkia rhomboidea','Clarkia rhomboide',2,0,'','','Douglas','459eaed1-b6ac-5cde-98c3-105ad472f70d','Clarkia rhomboidea Douglas','Douglas','SPECIES','','Clarkia','','rhomboidea','','','',NULL,'','','','','','Douglas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6799','','','Gayophytum diffusum subsp. parviflorum F.H. Lewis & Szweykowski',1,'Gayophytum diffusum parviflorum','Gayophytum diffusum subsp. parviflorum','Gayophytum diffus paruiflor',3,0,'','','F. H. Lewis|Szweykowski','3e60af49-3b7b-589e-b40b-f77a5e39fd65','Gayophytum diffusum subsp. parviflorum F.H. Lewis & Szweykowski','F.H. Lewis & Szweykowski','SUBSPECIES','','Gayophytum','','diffusum','parviflorum','','',NULL,'','','','','','F. H. Lewis & Szweykowski','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1474','','','Oenothera Linnaeus',1,'Oenothera','Oenothera','Oenothera',1,0,'','','Linnaeus','3ea66b03-f57b-55cf-9d31-226daa406e68','Oenothera Linnaeus','Linnaeus','GENUS','Oenothera','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2361','','','Oenothera subsect. Gaura (Linnaeus) W.L. Wagner & Hoch',2,'Gaura','Oenothera subsect. Gaura','Gaura',1,0,'','','Linnaeus|W. L. Wagner|Hoch','3f3c235d-f20d-54f1-a4bf-1e6fb9d7887f','Oenothera subsect. Gaura (Linnaeus) W.L. Wagner & Hoch','(Linnaeus) W.L. Wagner & Hoch','SUBSECTION','Gaura','','','','','','',NULL,'W. L. Wagner & Hoch','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33229','','','Oenothera subsect. Schizocarya (Spach) W.L. Wagner & Hoch',2,'Schizocarya','Oenothera subsect. Schizocarya','Schizocarya',1,0,'','','Spach|W. L. Wagner|Hoch','e51ac840-29c2-53f8-ad25-408707a5bbd7','Oenothera subsect. Schizocarya (Spach) W.L. Wagner & Hoch','(Spach) W.L. Wagner & Hoch','SUBSECTION','Schizocarya','','','','','','',NULL,'W. L. Wagner & Hoch','','','','','Spach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6816','','','Oenothera glazioviana Micheli',1,'Oenothera glazioviana','Oenothera glazioviana','Oenothera glaziouian',2,0,'','','Micheli','909d02c1-76d0-592f-9fc3-7f4e5803ba2f','Oenothera glazioviana Micheli','Micheli','SPECIES','','Oenothera','','glazioviana','','','',NULL,'','','','','','Micheli','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6819','','','Oenothera nutans G.F. Atkinson & Bartlett',1,'Oenothera nutans','Oenothera nutans','Oenothera nutans',2,0,'','','G. F. Atkinson|Bartlett','80049416-2635-5cd0-9c91-dac753798721','Oenothera nutans G.F. Atkinson & Bartlett','G.F. Atkinson & Bartlett','SPECIES','','Oenothera','','nutans','','','',NULL,'','','','','','G. F. Atkinson & Bartlett','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2364','','','Oenothera subsect. Candela (W. Dietrich & W.L. Wagner) W.L. Wagner & Hoch',2,'Candela','Oenothera subsect. Candela','Candela',1,0,'','','W. Dietrich|W. L. Wagner|Hoch','3da95423-82f2-529c-93da-1defd8e5c2c3','Oenothera subsect. Candela (W. Dietrich & W.L. Wagner) W.L. Wagner & Hoch','(W. Dietrich & W.L. Wagner) W.L. Wagner & Hoch','SUBSECTION','Candela','','','','','','',NULL,'W. L. Wagner & Hoch','','','','','W. Dietrich & W. L. Wagner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('17557','','','Oenothera cespitosa Nuttall subsp. cespitosa',1,'Oenothera cespitosa cespitosa','Oenothera cespitosa subsp. cespitosa','Oenothera cespitos cespitos',3,0,'','','','01c17c2a-0101-5350-94f0-42c554236b9e','Oenothera cespitosa Nuttall subsp. cespitosa','Nuttall','SUBSPECIES','','Oenothera','','cespitosa','cespitosa','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6815','','','Oenothera fruticosa Linnaeus',1,'Oenothera fruticosa','Oenothera fruticosa','Oenothera fruticos',2,0,'','','Linnaeus','1f737621-aabe-5491-8abf-89201eea708d','Oenothera fruticosa Linnaeus','Linnaeus','SPECIES','','Oenothera','','fruticosa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6823','','','Oenothera pallida Lindley',1,'Oenothera pallida','Oenothera pallida','Oenothera pallid',2,0,'','','Lindley','d92e4de8-3e47-56cc-8953-d60e10666a43','Oenothera pallida Lindley','Lindley','SPECIES','','Oenothera','','pallida','','','',NULL,'','','','','','Lindley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33004','','','Camissoniopsis W.L. Wagner & Hoch',1,'Camissoniopsis','Camissoniopsis','Camissoniopsis',1,0,'','','W. L. Wagner|Hoch','1bb28227-c8c1-5364-9017-30b7b206d044','Camissoniopsis W.L. Wagner & Hoch','W.L. Wagner & Hoch','GENUS','Camissoniopsis','','','','','','',NULL,'','','','','','W. L. Wagner & Hoch','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6768','','','Epilobium clavatum Trelease',1,'Epilobium clavatum','Epilobium clavatum','Epilobium clauat',2,0,'','','Trelease','adea8d7d-14b5-5f6b-af4c-68116226dc2b','Epilobium clavatum Trelease','Trelease','SPECIES','','Epilobium','','clavatum','','','',NULL,'','','','','','Trelease','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6776','','','Epilobium hirsutum Linnaeus',1,'Epilobium hirsutum','Epilobium hirsutum','Epilobium hirsut',2,0,'','','Linnaeus','d3bc8c7b-b661-5d39-881a-0e4a297fc0dd','Epilobium hirsutum Linnaeus','Linnaeus','SPECIES','','Epilobium','','hirsutum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6765','','','Epilobium ciliatum subsp. glandulosum (Lehmann) Hoch & P.H. Raven',1,'Epilobium ciliatum glandulosum','Epilobium ciliatum subsp. glandulosum','Epilobium ciliat glandulos',3,0,'','','Lehmann|Hoch|P. H. Raven','ada66d9a-dd25-5289-bde7-d6404d33509b','Epilobium ciliatum subsp. glandulosum (Lehmann) Hoch & P.H. Raven','(Lehmann) Hoch & P.H. Raven','SUBSPECIES','','Epilobium','','ciliatum','glandulosum','','',NULL,'Hoch & P. H. Raven','','','','','Lehmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6778','','','Epilobium hornemannii Reichenbach',1,'Epilobium hornemannii','Epilobium hornemannii','Epilobium hornemann',2,0,'','','Reichenbach','8e06b383-d32c-59f0-b613-1b0ac2c2c515','Epilobium hornemannii Reichenbach','Reichenbach','SPECIES','','Epilobium','','hornemannii','','','',NULL,'','','','','','Reichenbach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6777','','','Epilobium hornemannii subsp. behringianum (Haussknecht) Hoch & P.H. Raven',1,'Epilobium hornemannii behringianum','Epilobium hornemannii subsp. behringianum','Epilobium hornemann behringian',3,0,'','','Haussknecht|Hoch|P. H. Raven','e6d4644c-879e-54df-9789-20f15c21496c','Epilobium hornemannii subsp. behringianum (Haussknecht) Hoch & P.H. Raven','(Haussknecht) Hoch & P.H. Raven','SUBSPECIES','','Epilobium','','hornemannii','behringianum','','',NULL,'Hoch & P. H. Raven','','','','','Haussknecht','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29046','','','Epilobium tetragonum Linnaeus',1,'Epilobium tetragonum','Epilobium tetragonum','Epilobium tetragon',2,0,'','','Linnaeus','089bb094-ddfd-5e07-a945-2e35818a0246','Epilobium tetragonum Linnaeus','Linnaeus','SPECIES','','Epilobium','','tetragonum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32974','','','Epilobium davuricum Fischer ex Sprengel',2,'Epilobium davuricum','Epilobium davuricum','Epilobium dauuric',2,0,'','','Fischer|Sprengel','67e4ab61-3f98-55d3-965b-d8267b8dc24e','Epilobium davuricum Fischer ex Sprengel','Fischer ex Sprengel','SPECIES','','Epilobium','','davuricum','','','',NULL,'','','','','','Fischer','','Sprengel','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6772','','','Epilobium foliosum (Torrey & A. Gray) Suksdorf',1,'Epilobium foliosum','Epilobium foliosum','Epilobium folios',2,0,'','','Torrey|A. Gray|Suksdorf','7ddef827-339d-56c2-8a2d-8f33af3b1887','Epilobium foliosum (Torrey & A. Gray) Suksdorf','(Torrey & A. Gray) Suksdorf','SPECIES','','Epilobium','','foliosum','','','',NULL,'Suksdorf','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29483','','','Chamaenerion sect. Chamaenerion Séguier',2,'Chamaenerion','Chamaenerion sect. Chamaenerion','Chamaenerion',1,0,'','','Séguier','2e1433dd-a6d5-5ef5-a7e4-e5c39183202e','Chamaenerion sect. Chamaenerion Séguier','Séguier','SECTION','Chamaenerion','','','','','','',NULL,'','','','','','Séguier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29498','','','Chamaenerion angustifolium subsp. circumvagum (Mosquin) Moldenke',1,'Chamaenerion angustifolium circumvagum','Chamaenerion angustifolium subsp. circumvagum','Chamaenerion angustifoli circumuag',3,0,'','','Mosquin|Moldenke','243c7325-0c1f-5982-bb6a-9ddef2f92855','Chamaenerion angustifolium subsp. circumvagum (Mosquin) Moldenke','(Mosquin) Moldenke','SUBSPECIES','','Chamaenerion','','angustifolium','circumvagum','','',NULL,'Moldenke','','','','','Mosquin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6749','','','Circaea canadensis (Linnaeus) Hill',1,'Circaea canadensis','Circaea canadensis','Circaea canadens',2,0,'','','Linnaeus|Hill','a5097153-a23c-5362-ab1b-6de78cdff171','Circaea canadensis (Linnaeus) Hill','(Linnaeus) Hill','SPECIES','','Circaea','','canadensis','','','',NULL,'Hill','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6805','','','Ludwigia alternifolia Linnaeus',1,'Ludwigia alternifolia','Ludwigia alternifolia','Ludwigia alternifol',2,0,'','','Linnaeus','7cb3d0bc-7599-5f1a-8978-186258c6b8c6','Ludwigia alternifolia Linnaeus','Linnaeus','SPECIES','','Ludwigia','','alternifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33248','','','Ludwigia peploides (Kunth) P.H. Raven',1,'Ludwigia peploides','Ludwigia peploides','Ludwigia peploid',2,0,'','','Kunth|P. H. Raven','9bee4665-48e5-5464-a797-fb8e4cc91ef5','Ludwigia peploides (Kunth) P.H. Raven','(Kunth) P.H. Raven','SPECIES','','Ludwigia','','peploides','','','',NULL,'P. H. Raven','','','','','Kunth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1495','','','Oxalis Linnaeus',1,'Oxalis','Oxalis','Oxalis',1,0,'','','Linnaeus','70173687-f127-5096-9b11-472920ef35c7','Oxalis Linnaeus','Linnaeus','GENUS','Oxalis','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('104','','','Cannabaceae Martinov',1,'Cannabaceae','Cannabaceae','Cannabaceae',1,0,'','','Martinov','c8bb51d0-4ccc-50b5-85e3-783b1e80b0cf','Cannabaceae Martinov','Martinov','FAMILY','Cannabaceae','','','','','','',NULL,'','','','','','Martinov','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4191','','','Cannabis sativa Linnaeus',1,'Cannabis sativa','Cannabis sativa','Cannabis satiu',2,0,'','','Linnaeus','a8a40fe9-0663-5d2b-b49b-907390f99922','Cannabis sativa Linnaeus','Linnaeus','SPECIES','','Cannabis','','sativa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4194','','','Humulus japonicus Siebold & Zuccarini',1,'Humulus japonicus','Humulus japonicus','Humulus iaponic',2,0,'','','Siebold|Zuccarini','4af359df-5bc0-5877-ba2f-087f21ef0045','Humulus japonicus Siebold & Zuccarini','Siebold & Zuccarini','SPECIES','','Humulus','','japonicus','','','',NULL,'','','','','','Siebold & Zuccarini','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5455','','','Elaeagnus angustifolia Linnaeus',1,'Elaeagnus angustifolia','Elaeagnus angustifolia','Elaeagnus angustifol',2,0,'','','Linnaeus','e2abe61f-a4b9-5937-8b0b-7099533482fc','Elaeagnus angustifolia Linnaeus','Linnaeus','SPECIES','','Elaeagnus','','angustifolia','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5457','','','Elaeagnus multiflora Thunberg',1,'Elaeagnus multiflora','Elaeagnus multiflora','Elaeagnus multiflor',2,0,'','','Thunberg','f799cdfb-a95a-52ec-bb3c-184a7f4fa724','Elaeagnus multiflora Thunberg','Thunberg','SPECIES','','Elaeagnus','','multiflora','','','',NULL,'','','','','','Thunberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5461','','','Shepherdia canadensis (Linnaeus) Nuttall',1,'Shepherdia canadensis','Shepherdia canadensis','Shepherdia canadens',2,0,'','','Linnaeus|Nuttall','10f370b5-4d8e-563d-a572-935e0aaed1bc','Shepherdia canadensis (Linnaeus) Nuttall','(Linnaeus) Nuttall','SPECIES','','Shepherdia','','canadensis','','','',NULL,'Nuttall','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28708','','','Ficus Linnaeus',1,'Ficus','Ficus','Ficus',1,0,'','','Linnaeus','de293a74-0c8e-5da8-838e-d65880401ad3','Ficus Linnaeus','Linnaeus','GENUS','Ficus','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30178','','','Ceanothus subg. Ceanothus Linnaeus',2,'Ceanothus','Ceanothus subgen. Ceanothus','Ceanothus',1,0,'','','Linnaeus','d2e07bef-f02b-5bc8-9fb8-e7e178535936','Ceanothus subg. Ceanothus Linnaeus','Linnaeus','SUBGENUS','Ceanothus','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8590','','','Ceanothus velutinus var. laevigatus Torrey & A. Gray',1,'Ceanothus velutinus laevigatus','Ceanothus velutinus var. laevigatus','Ceanothus uelutin laeuigat',3,0,'','','Torrey|A. Gray','76fc4ce7-6c02-56a7-b998-f68ae667769b','Ceanothus velutinus var. laevigatus Torrey & A. Gray','Torrey & A. Gray','VARIETY','','Ceanothus','','velutinus','laevigatus','','',NULL,'','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8593','','','Frangula alnus Miller',1,'Frangula alnus','Frangula alnus','Frangula aln',2,0,'','','Miller','9f69ab2a-6fd8-51d2-9270-a8203058ab92','Frangula alnus Miller','Miller','SPECIES','','Frangula','','alnus','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30391','','','Endotropis alnifolia (L''Héritier) Hauenschild',1,'Endotropis alnifolia','Endotropis alnifolia','Endotropis alnifol',2,0,'','','L''Héritier|Hauenschild','d2100eb7-6bbd-595f-870a-76d34795d3d4','Endotropis alnifolia (L''Héritier) Hauenschild','(L''Héritier) Hauenschild','SPECIES','','Endotropis','','alnifolia','','','',NULL,'Hauenschild','','','','','L''Héritier','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1111','','','Dryas Linnaeus',1,'Dryas','Dryas','Dryas',1,0,'','','Linnaeus','015a0fdb-9355-5c59-becd-d71e55c4fa33','Dryas Linnaeus','Linnaeus','GENUS','Dryas','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8739','','','Dryas octopetala Linnaeus',1,'Dryas octopetala','Dryas octopetala','Dryas octopetal',2,0,'','','Linnaeus','f6e9bd01-bbc4-5345-bac4-932174ceca02','Dryas octopetala Linnaeus','Linnaeus','SPECIES','','Dryas','','octopetala','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26395','','','Dryas ajanensis subsp. beringensis Jurtzev',1,'Dryas ajanensis beringensis','Dryas ajanensis subsp. beringensis','Dryas aianens beringens',3,0,'','','Jurtzev','b987cb84-4994-5795-aeb2-2ea5fbb2ea01','Dryas ajanensis subsp. beringensis Jurtzev','Jurtzev','SUBSPECIES','','Dryas','','ajanensis','beringensis','','',NULL,'','','','','','Jurtzev','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1204','','','Geum Linnaeus',1,'Geum','Geum','Geum',1,0,'','','Linnaeus','53135aab-c188-5bb1-bbc5-e6690a7d51f5','Geum Linnaeus','Linnaeus','GENUS','Geum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8766','','','Geum glaciale Adams ex Fischer & C.A. Meyer',2,'Geum glaciale','Geum glaciale','Geum glacial',2,0,'','','Adams|Fischer|C. A. Meyer','f870ee88-9c72-549c-b950-49bb4bb98a4c','Geum glaciale Adams ex Fischer & C.A. Meyer','Adams ex Fischer & C.A. Meyer','SPECIES','','Geum','','glaciale','','','',NULL,'','','','','','Adams','','Fischer & C. A. Meyer','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8781','','','Geum ×pulchrum Fernald',3,'','','',NULL,NULL,'','','','','Geum ×pulchrum Fernald','Fernald','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8771','','','Geum macrophyllum var. perincisum (Rydberg) Raup',1,'Geum macrophyllum perincisum','Geum macrophyllum var. perincisum','Geum macrophyll perincis',3,0,'','','Rydberg|Raup','b6dff6d3-f06b-5a2a-83f1-5f7a792089dc','Geum macrophyllum var. perincisum (Rydberg) Raup','(Rydberg) Raup','VARIETY','','Geum','','macrophyllum','perincisum','','',NULL,'Raup','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8611','','','Alchemilla glomerulans Buser',1,'Alchemilla glomerulans','Alchemilla glomerulans','Alchemilla glomerulans',2,0,'','','Buser','26b1c84e-96b4-5824-afdf-5b53fb22fe2e','Alchemilla glomerulans Buser','Buser','SPECIES','','Alchemilla','','glomerulans','','','',NULL,'','','','','','Buser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9698','','','Alchemilla micans Buser',1,'Alchemilla micans','Alchemilla micans','Alchemilla micans',2,0,'','','Buser','5e7fbc52-c733-5f64-b1d5-5f66fc93269f','Alchemilla micans Buser','Buser','SPECIES','','Alchemilla','','micans','','','',NULL,'','','','','','Buser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8609','','','Alchemilla filicaulis subsp. vestita (Buser) M.E. Bradshaw',1,'Alchemilla filicaulis vestita','Alchemilla filicaulis subsp. vestita','Alchemilla filicaul uestit',3,0,'','','Buser|M. E. Bradshaw','adcf6428-6863-5f1b-8c67-a3db169f8356','Alchemilla filicaulis subsp. vestita (Buser) M.E. Bradshaw','(Buser) M.E. Bradshaw','SUBSPECIES','','Alchemilla','','filicaulis','vestita','','',NULL,'M. E. Bradshaw','','','','','Buser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8642','','','Chamaerhodos erecta (Linnaeus) Bunge',1,'Chamaerhodos erecta','Chamaerhodos erecta','Chamaerhodos erect',2,0,'','','Linnaeus|Bunge','3f893890-0f76-585c-96b7-de589e6e4741','Chamaerhodos erecta (Linnaeus) Bunge','(Linnaeus) Bunge','SPECIES','','Chamaerhodos','','erecta','','','',NULL,'Bunge','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8751','','','Fragaria chiloensis subsp. lucida (E. Vilmorin ex J. Gay) Staudt',2,'Fragaria chiloensis lucida','Fragaria chiloensis subsp. lucida','Fragaria chiloens lucid',3,0,'','','E. Vilmorin|J. Gay|Staudt','e04c21b3-fb51-58ee-9278-d5d8388e2f5d','Fragaria chiloensis subsp. lucida (E. Vilmorin ex J. Gay) Staudt','(E. Vilmorin ex J. Gay) Staudt','SUBSPECIES','','Fragaria','','chiloensis','lucida','','',NULL,'Staudt','','','','','E. Vilmorin','','J. Gay','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8756','','','Fragaria vesca subsp. bracteata (A. Heller) Staudt',1,'Fragaria vesca bracteata','Fragaria vesca subsp. bracteata','Fragaria uesc bracteat',3,0,'','','A. Heller|Staudt','2ceada49-2b66-5fc2-b127-a481dc05e12e','Fragaria vesca subsp. bracteata (A. Heller) Staudt','(A. Heller) Staudt','SUBSPECIES','','Fragaria','','vesca','bracteata','','',NULL,'Staudt','','','','','A. Heller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9745','','','Fragaria vesca Linnaeus subsp. vesca',1,'Fragaria vesca vesca','Fragaria vesca subsp. vesca','Fragaria uesc uesc',3,0,'','','','9d1f21d4-0d34-53c5-b459-94e0e08f47e4','Fragaria vesca Linnaeus subsp. vesca','Linnaeus','SUBSPECIES','','Fragaria','','vesca','vesca','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8762','','','Fragaria ×ananassa Duchesne ex Rozier',3,'','','',NULL,NULL,'','','','','Fragaria ×ananassa Duchesne ex Rozier','Duchesne ex Rozier','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8761','','','Fragaria ×ananassa subsp. cuneifolia (Nuttall ex Howell) Staudt',3,'','','',NULL,NULL,'','','','','Fragaria ×ananassa subsp. cuneifolia (Nuttall ex Howell) Staudt','(Nuttall ex Howell) Staudt','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1586','','','Potentilla Linnaeus',1,'Potentilla','Potentilla','Potentilla',1,0,'','','Linnaeus','8a2e448b-af77-5206-b222-0e304f6423bd','Potentilla Linnaeus','Linnaeus','GENUS','Potentilla','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2267','','','Potentilla sect. Terminales Grenier & Godron',2,'Terminales','Potentilla sect. Terminales','Terminales',1,0,'','','Grenier|Godron','a6a429c8-b2ef-5081-ad19-6346bc3bd993','Potentilla sect. Terminales Grenier & Godron','Grenier & Godron','SECTION','Terminales','','','','','','',NULL,'','','','','','Grenier & Godron','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2268','','','Potentilla sect. Haematochri (Rydberg) B.C. Johnston',2,'Haematochri','Potentilla sect. Haematochri','Haematochri',1,0,'','','Rydberg|B. C. Johnston','4c1bcc36-37b9-5f3a-8589-97bbc5230f96','Potentilla sect. Haematochri (Rydberg) B.C. Johnston','(Rydberg) B.C. Johnston','SECTION','Haematochri','','','','','','',NULL,'B. C. Johnston','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8845','','','Potentilla rivalis Nuttall',1,'Potentilla rivalis','Potentilla rivalis','Potentilla riual',2,0,'','','Nuttall','09ff7ba9-8639-5476-b3b0-ae98bfa72b05','Potentilla rivalis Nuttall','Nuttall','SPECIES','','Potentilla','','rivalis','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8836','','','Potentilla supina subsp. paradoxa (Nuttall) Soják',1,'Potentilla supina paradoxa','Potentilla supina subsp. paradoxa','Potentilla supin paradox',3,0,'','','Nuttall|Soják','ab92efba-3183-54f0-80f2-64f95fb975d0','Potentilla supina subsp. paradoxa (Nuttall) Soják','(Nuttall) Soják','SUBSPECIES','','Potentilla','','supina','paradoxa','','',NULL,'Soják','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8838','','','Potentilla litoralis Rydberg',1,'Potentilla litoralis','Potentilla litoralis','Potentilla litoral',2,0,'','','Rydberg','cb298281-940c-56b9-b648-80c908610bd7','Potentilla litoralis Rydberg','Rydberg','SPECIES','','Potentilla','','litoralis','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9786','','','Potentilla bipinnatifida Douglas nom. cons.',4,'','','',NULL,NULL,'','','','','Potentilla bipinnatifida Douglas nom. cons.','Douglas nom. cons.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2273','','','Potentilla sect. Graciles (Rydberg) A. Nelson',2,'Graciles','Potentilla sect. Graciles','Graciles',1,0,'','','Rydberg|A. Nelson','0e93c19e-9879-5754-986e-cc4bed50ee85','Potentilla sect. Graciles (Rydberg) A. Nelson','(Rydberg) A. Nelson','SECTION','Graciles','','','','','','',NULL,'A. Nelson','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8810','','','Potentilla drummondii Lehmann',1,'Potentilla drummondii','Potentilla drummondii','Potentilla drummond',2,0,'','','Lehmann','684b6651-c068-5944-ad11-3585081fa686','Potentilla drummondii Lehmann','Lehmann','SPECIES','','Potentilla','','drummondii','','','',NULL,'','','','','','Lehmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8809','','','Potentilla glaucophylla Lehmann var. glaucophylla',1,'Potentilla glaucophylla glaucophylla','Potentilla glaucophylla var. glaucophylla','Potentilla glaucophyll glaucophyll',3,0,'','','','861660a4-3047-5f04-8b99-f71a09fee587','Potentilla glaucophylla Lehmann var. glaucophylla','Lehmann','VARIETY','','Potentilla','','glaucophylla','glaucophylla','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29968','','','Potentilla brunnescens Rydberg',1,'Potentilla brunnescens','Potentilla brunnescens','Potentilla brunnescens',2,0,'','','Rydberg','e899f89b-3d18-5a80-9f21-15c8def74e17','Potentilla brunnescens Rydberg','Rydberg','SPECIES','','Potentilla','','brunnescens','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8824','','','Potentilla hippiana Lehmann',1,'Potentilla hippiana','Potentilla hippiana','Potentilla hippian',2,0,'','','Lehmann','21c3ca9c-28f5-505e-bed0-c3f91b2e2870','Potentilla hippiana Lehmann','Lehmann','SPECIES','','Potentilla','','hippiana','','','',NULL,'','','','','','Lehmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8813','','','Potentilla elegans Chamisso & Schlechtendal',1,'Potentilla elegans','Potentilla elegans','Potentilla elegans',2,0,'','','Chamisso|Schlechtendal','15e5e356-1693-5d6c-95d1-a56273f72c48','Potentilla elegans Chamisso & Schlechtendal','Chamisso & Schlechtendal','SPECIES','','Potentilla','','elegans','','','',NULL,'','','','','','Chamisso & Schlechtendal','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8829','','','Potentilla hyparctica subsp. elatior (Abromeit) Elven & D.F. Murray',1,'Potentilla hyparctica elatior','Potentilla hyparctica subsp. elatior','Potentilla hyparctic elatior',3,0,'','','Abromeit|Elven|D. F. Murray','9734f2ed-86b7-5e71-bcb0-d81f531e8dcd','Potentilla hyparctica subsp. elatior (Abromeit) Elven & D.F. Murray','(Abromeit) Elven & D.F. Murray','SUBSPECIES','','Potentilla','','hyparctica','elatior','','',NULL,'Elven & D. F. Murray','','','','','Abromeit','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9780','','','Potentilla subvahliana Jurtzev',1,'Potentilla subvahliana','Potentilla subvahliana','Potentilla subuahlian',2,0,'','','Jurtzev','6807d730-6205-5fbb-b929-fb3f27233e5c','Potentilla subvahliana Jurtzev','Jurtzev','SPECIES','','Potentilla','','subvahliana','','','',NULL,'','','','','','Jurtzev','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8825','','','Potentilla arenosa subsp. chamissonis (Hultén) Elven & D.F. Murray',1,'Potentilla arenosa chamissonis','Potentilla arenosa subsp. chamissonis','Potentilla arenos chamisson',3,0,'','','Hultén|Elven|D. F. Murray','a00ab4f0-72d3-56b9-9029-467d889a7aca','Potentilla arenosa subsp. chamissonis (Hultén) Elven & D.F. Murray','(Hultén) Elven & D.F. Murray','SUBSPECIES','','Potentilla','','arenosa','chamissonis','','',NULL,'Elven & D. F. Murray','','','','','Hultén','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8840','','','Potentilla plattensis Nuttall',1,'Potentilla plattensis','Potentilla plattensis','Potentilla plattens',2,0,'','','Nuttall','e2c6272f-f6c0-56ad-8905-bc1f2b9139f9','Potentilla plattensis Nuttall','Nuttall','SPECIES','','Potentilla','','plattensis','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8843','','','Potentilla recta Linnaeus',1,'Potentilla recta','Potentilla recta','Potentilla rect',2,0,'','','Linnaeus','cf3edc66-6bb9-5a7b-95c6-1be0cd5ac638','Potentilla recta Linnaeus','Linnaeus','SPECIES','','Potentilla','','recta','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8847','','','Potentilla rubricaulis Lehmann',1,'Potentilla rubricaulis','Potentilla rubricaulis','Potentilla rubricaul',2,0,'','','Lehmann','7b1c6732-b8f8-5854-8ea7-de548e4c948d','Potentilla rubricaulis Lehmann','Lehmann','SPECIES','','Potentilla','','rubricaulis','','','',NULL,'','','','','','Lehmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30160','','','Potentilla psychrophila Soják',1,'Potentilla psychrophila','Potentilla psychrophila','Potentilla psychrophil',2,0,'','','Soják','16321626-ed62-5c68-a336-f847c1d69a27','Potentilla psychrophila Soják','Soják','SPECIES','','Potentilla','','psychrophila','','','',NULL,'','','','','','Soják','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27751','','','Potentilla indica (Andrews) Th. Wolf var. indica',1,'Potentilla indica indica','Potentilla indica var. indica','Potentilla indic indic',3,0,'','','','b479df29-6412-5994-a63b-605c8e1b359a','Potentilla indica (Andrews) Th. Wolf var. indica','(Andrews) Th. Wolf','VARIETY','','Potentilla','','indica','indica','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8799','','','Drymocallis convallaria (Rydberg) Rydberg',1,'Drymocallis convallaria','Drymocallis convallaria','Drymocallis conuallar',2,0,'','','Rydberg','4b62a9cc-98fb-5b24-b7ac-cfa5ab937cbf','Drymocallis convallaria (Rydberg) Rydberg','(Rydberg) Rydberg','SPECIES','','Drymocallis','','convallaria','','','',NULL,'Rydberg','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8821','','','Drymocallis pseudorupestris (Rydberg) Rydberg',1,'Drymocallis pseudorupestris','Drymocallis pseudorupestris','Drymocallis pseudorupestr',2,0,'','','Rydberg','6711f609-9644-5187-90cf-243046bd9cac','Drymocallis pseudorupestris (Rydberg) Rydberg','(Rydberg) Rydberg','SPECIES','','Drymocallis','','pseudorupestris','','','',NULL,'Rydberg','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23585','','','Argentina anserina (Linnaeus) Rydberg',1,'Argentina anserina','Argentina anserina','Argentina anserin',2,0,'','','Linnaeus|Rydberg','c546fdb0-f93f-515c-8734-292d508e0d7b','Argentina anserina (Linnaeus) Rydberg','(Linnaeus) Rydberg','SPECIES','','Argentina','','anserina','','','',NULL,'Rydberg','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('668','','','Roseae Lamarck & de Candolle',1,'Roseae','Roseae','Roseae',1,0,'','','Lamarck|de Candolle','f25a6f74-2a38-574e-ac12-7aa26387df38','Roseae Lamarck & de Candolle','Lamarck & de Candolle','TRIBE','Roseae','','','','','','',NULL,'','','','','','Lamarck & de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23887','','','Rosa gymnocarpa Nuttall var. gymnocarpa',1,'Rosa gymnocarpa gymnocarpa','Rosa gymnocarpa var. gymnocarpa','Rosa gymnocarp gymnocarp',3,0,'','','','4b832d2e-16dc-55ee-a159-2ef2c6a323bf','Rosa gymnocarpa Nuttall var. gymnocarpa','Nuttall','VARIETY','','Rosa','','gymnocarpa','gymnocarpa','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8886','','','Rosa acicularis subsp. sayi (Schweinitz) W.H. Lewis',1,'Rosa acicularis sayi','Rosa acicularis subsp. sayi','Rosa acicular say',3,0,'','','Schweinitz|W. H. Lewis','431f96c6-2105-5526-b917-404e0c5e8a5e','Rosa acicularis subsp. sayi (Schweinitz) W.H. Lewis','(Schweinitz) W.H. Lewis','SUBSPECIES','','Rosa','','acicularis','sayi','','',NULL,'W. H. Lewis','','','','','Schweinitz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8916','','','Rosa woodsii subsp. ultramontana (S. Watson) Roy L. Taylor & MacBryde',1,'Rosa woodsii ultramontana','Rosa woodsii subsp. ultramontana','Rosa woods ultramontan',3,0,'','','S. Watson|Roy L. Taylor|MacBryde','e11ecffb-c88b-5acf-ad4a-960993e2f73e','Rosa woodsii subsp. ultramontana (S. Watson) Roy L. Taylor & MacBryde','(S. Watson) Roy L. Taylor & MacBryde','SUBSPECIES','','Rosa','','woodsii','ultramontana','','',NULL,'Roy L. Taylor & MacBryde','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8918','','','Rosa woodsii Lindley subsp. woodsii',1,'Rosa woodsii woodsii','Rosa woodsii subsp. woodsii','Rosa woods woods',3,0,'','','','f08ec32f-44c3-5d17-9db4-4b042e0164db','Rosa woodsii Lindley subsp. woodsii','Lindley','SUBSPECIES','','Rosa','','woodsii','woodsii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8908','','','Rosa pisocarpa A. Gray',1,'Rosa pisocarpa','Rosa pisocarpa','Rosa pisocarp',2,0,'','','A. Gray','e767025f-206d-59de-abfe-b3aacf20597c','Rosa pisocarpa A. Gray','A. Gray','SPECIES','','Rosa','','pisocarpa','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30359','','','Rosa ×canadensis W.H. Lewis',3,'','','',NULL,NULL,'','','','','Rosa ×canadensis W.H. Lewis','W.H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30363','','','Rosa ×gilmaniana W.H. Lewis',3,'','','',NULL,NULL,'','','','','Rosa ×gilmaniana W.H. Lewis','W.H. Lewis','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8909','','','Rosa rubiginosa Linnaeus',1,'Rosa rubiginosa','Rosa rubiginosa','Rosa rubiginos',2,0,'','','Linnaeus','fbfbffa8-f459-5ea3-adca-7d0c891d1ae4','Rosa rubiginosa Linnaeus','Linnaeus','SPECIES','','Rosa','','rubiginosa','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2284','','','Rosa sect. Gallicae Crépin',2,'Gallicae','Rosa sect. Gallicae','Gallicae',1,0,'','','Crépin','6e44e491-9c95-5b76-9a50-f5c19552c004','Rosa sect. Gallicae Crépin','Crépin','SECTION','Gallicae','','','','','','',NULL,'','','','','','Crépin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8898','','','Rosa hugonis Hemsley',1,'Rosa hugonis','Rosa hugonis','Rosa hugon',2,0,'','','Hemsley','9259c019-3bde-515f-959d-9fa5cacd3239','Rosa hugonis Hemsley','Hemsley','SPECIES','','Rosa','','hugonis','','','',NULL,'','','','','','Hemsley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30356','','','Rosa sect. Americanae W.H. Lewis',2,'Americanae','Rosa sect. Americanae','Americanae',1,0,'','','W. H. Lewis','e96f4db5-7900-5036-b011-35afe0f97466','Rosa sect. Americanae W.H. Lewis','W.H. Lewis','SECTION','Americanae','','','','','','',NULL,'','','','','','W. H. Lewis','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8943','','','Rubus pedatus Smith',1,'Rubus pedatus','Rubus pedatus','Rubus pedat',2,0,'','','Smith','133e6355-d85d-5518-8305-27ff808427e0','Rubus pedatus Smith','Smith','SPECIES','','Rubus','','pedatus','','','',NULL,'','','','','','Smith','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8942','','','Rubus parviflorus Nuttall nom. cons.',4,'','','',NULL,NULL,'','','','','Rubus parviflorus Nuttall nom. cons.','Nuttall nom. cons.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8939','','','Rubus nivalis Douglas ex Hooker',2,'Rubus nivalis','Rubus nivalis','Rubus niual',2,0,'','','Douglas|Hooker','294e3d02-8b00-5466-8428-d957f98056f0','Rubus nivalis Douglas ex Hooker','Douglas ex Hooker','SPECIES','','Rubus','','nivalis','','','',NULL,'','','','','','Douglas','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8930','','','Rubus ×frondisentis Blanchard',3,'','','',NULL,NULL,'','','','','Rubus ×frondisentis Blanchard','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20371','','','Rubus ×lepagei L.H. Bailey',3,'','','',NULL,NULL,'','','','','Rubus ×lepagei L.H. Bailey','L.H. Bailey','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20439','','','Rubus ×recurvicaulis Blanchard',3,'','','',NULL,NULL,'','','','','Rubus ×recurvicaulis Blanchard','Blanchard','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33643','','','Rubus subg. Cylactis (Rafinesque) Focke',2,'Cylactis','Rubus subgen. Cylactis','Cylactis',1,0,'','','Rafinesque|Focke','7bf652e9-d4bf-549a-94c1-2a89b3372e88','Rubus subg. Cylactis (Rafinesque) Focke','(Rafinesque) Focke','SUBGENUS','Cylactis','','','','','','',NULL,'Focke','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8923','','','Rubus arcticus Linnaeus subsp. arcticus',1,'Rubus arcticus arcticus','Rubus arcticus subsp. arcticus','Rubus arctic arctic',3,0,'','','','963ec905-e8b2-5b55-80e8-58c6a838bd2b','Rubus arcticus Linnaeus subsp. arcticus','Linnaeus','SUBSPECIES','','Rubus','','arcticus','arcticus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27383','','','Rubus leucodermis Douglas ex Torrey & A. Gray var. leucodermis',2,'Rubus leucodermis leucodermis','Rubus leucodermis var. leucodermis','Rubus leucoderm leucoderm',3,0,'','','','cca056af-238f-5366-bb45-b980d9bf9e25','Rubus leucodermis Douglas ex Torrey & A. Gray var. leucodermis','Douglas ex Torrey & A. Gray','VARIETY','','Rubus','','leucodermis','leucodermis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8605','','','Agrimonia striata Michaux',1,'Agrimonia striata','Agrimonia striata','Agrimonia striat',2,0,'','','Michaux','565d8cea-5c5c-5249-8321-99b7f60cab50','Agrimonia striata Michaux','Michaux','SPECIES','','Agrimonia','','striata','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8959','','','Sanguisorba officinalis Linnaeus',1,'Sanguisorba officinalis','Sanguisorba officinalis','Sanguisorba officinal',2,0,'','','Linnaeus','1524d43d-3eba-5212-95c5-fee6f653248c','Sanguisorba officinalis Linnaeus','Linnaeus','SPECIES','','Sanguisorba','','officinalis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8953','','','Poteridium annuum (Nuttall ex Hooker) Spach',2,'Poteridium annuum','Poteridium annuum','Poteridium annu',2,0,'','','Nuttall|Hooker|Spach','7e73b1fb-1310-5890-a9c7-3c3625446dd8','Poteridium annuum (Nuttall ex Hooker) Spach','(Nuttall ex Hooker) Spach','SPECIES','','Poteridium','','annuum','','','',NULL,'Spach','','','','','Nuttall','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('416','','','Maleae Small',1,'Maleae','Maleae','Maleae',1,0,'','','Small','dd6e7a3b-99b4-5eb0-8abd-e4c48064ac76','Maleae Small','Small','TRIBE','Maleae','','','','','','',NULL,'','','','','','Small','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8620','','','Amelanchier canadensis (Linnaeus) Medikus',1,'Amelanchier canadensis','Amelanchier canadensis','Amelanchier canadens',2,0,'','','Linnaeus|Medikus','cfa760fc-7620-551d-9ba9-da5626c7822e','Amelanchier canadensis (Linnaeus) Medikus','(Linnaeus) Medikus','SPECIES','','Amelanchier','','canadensis','','','',NULL,'Medikus','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8621','','','Amelanchier fernaldii Wiegand',1,'Amelanchier fernaldii','Amelanchier fernaldii','Amelanchier fernald',2,0,'','','Wiegand','04fa4331-f7b5-5bc2-9374-29563f54be4c','Amelanchier fernaldii Wiegand','Wiegand','SPECIES','','Amelanchier','','fernaldii','','','',NULL,'','','','','','Wiegand','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8629','','','Amelanchier interior E.L. Nielsen',1,'Amelanchier interior','Amelanchier interior','Amelanchier interior',2,0,'','','E. L. Nielsen','a287cba9-6594-54a9-a021-10c18346b47c','Amelanchier interior E.L. Nielsen','E.L. Nielsen','SPECIES','','Amelanchier','','interior','','','',NULL,'','','','','','E. L. Nielsen','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9764','','','Amelanchier ×lamarckii F.G. Schroeder',3,'','','',NULL,NULL,'','','','','Amelanchier ×lamarckii F.G. Schroeder','F.G. Schroeder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8617','','','Amelanchier alnifolia (Nuttall) Nuttall ex M. Roemer',2,'Amelanchier alnifolia','Amelanchier alnifolia','Amelanchier alnifol',2,0,'','','Nuttall|M. Roemer','a357ce9b-370e-5b4e-b950-94be7165368a','Amelanchier alnifolia (Nuttall) Nuttall ex M. Roemer','(Nuttall) Nuttall ex M. Roemer','SPECIES','','Amelanchier','','alnifolia','','','',NULL,'Nuttall','','M. Roemer','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26248','','','Amelanchier bartramiana × Amelanchier spicata',2,'Amelanchier bartramiana × Amelanchier spicata','Amelanchier bartramiana × Amelanchier spicata','Amelanchier bartramian × Amelanchier spicat',0,0,'HYBRID_FORMULA','','','eb7ad181-aa0d-5a74-a8d6-37faaf9ae3a7','Amelanchier bartramiana × Amelanchier spicata','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('862','','','Aronia Medikus',1,'Aronia','Aronia','Aronia',1,0,'','','Medikus','6e8844b3-a5ff-5170-867a-5cb3d1e8723c','Aronia Medikus','Medikus','GENUS','Aronia','','','','','','',NULL,'','','','','','Medikus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8638','','','Aronia ×prunifolia (Marshall) Rehder',3,'','','',NULL,NULL,'','','','','Aronia ×prunifolia (Marshall) Rehder','(Marshall) Rehder','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9688','','','Cotoneaster sternianus (Turrill) Boom',1,'Cotoneaster sternianus','Cotoneaster sternianus','Cotoneaster sternian',2,0,'','','Turrill|Boom','3dc37f41-dda0-5a38-ad5a-90f005788f59','Cotoneaster sternianus (Turrill) Boom','(Turrill) Boom','SPECIES','','Cotoneaster','','sternianus','','','',NULL,'Boom','','','','','Turrill','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8646','','','Cotoneaster horizontalis Decaisne',1,'Cotoneaster horizontalis','Cotoneaster horizontalis','Cotoneaster horizontal',2,0,'','','Decaisne','9bb81c49-d69c-589a-9252-0a3201ff1653','Cotoneaster horizontalis Decaisne','Decaisne','SPECIES','','Cotoneaster','','horizontalis','','','',NULL,'','','','','','Decaisne','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24815','','','Cotoneaster dammeri C.K. Schneider',1,'Cotoneaster dammeri','Cotoneaster dammeri','Cotoneaster dammer',2,0,'','','C. K. Schneider','d06ac772-2bde-56e0-8440-d362db84c886','Cotoneaster dammeri C.K. Schneider','C.K. Schneider','SPECIES','','Cotoneaster','','dammeri','','','',NULL,'','','','','','C. K. Schneider','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9681','','','Cotoneaster crispii Exell',1,'Cotoneaster crispii','Cotoneaster crispii','Cotoneaster crisp',2,0,'','','Exell','059d5f9d-4220-58e9-b4da-6e0bd3c1ebd1','Cotoneaster crispii Exell','Exell','SPECIES','','Cotoneaster','','crispii','','','',NULL,'','','','','','Exell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33356','','','Cotoneaster ×watereri Exell',3,'','','',NULL,NULL,'','','','','Cotoneaster ×watereri Exell','Exell','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2408','','','Crataegus ser. Rotundifoliae (Eggleston) Rehder',2,'Rotundifoliae','Crataegus ser. Rotundifoliae','Rotundifoliae',1,0,'','','Eggleston|Rehder','32e0a75e-7732-5f24-9977-f15eca4efba9','Crataegus ser. Rotundifoliae (Eggleston) Rehder','(Eggleston) Rehder','SERIES','Rotundifoliae','','','','','','',NULL,'Rehder','','','','','Eggleston','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8657','','','Crataegus chrysocarpa Ashe',1,'Crataegus chrysocarpa','Crataegus chrysocarpa','Crataegus chrysocarp',2,0,'','','Ashe','6847543d-5856-53a9-9674-3d0f94c03c1b','Crataegus chrysocarpa Ashe','Ashe','SPECIES','','Crataegus','','chrysocarpa','','','',NULL,'','','','','','Ashe','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8658','','','Crataegus chrysocarpa Ashe var. chrysocarpa',1,'Crataegus chrysocarpa chrysocarpa','Crataegus chrysocarpa var. chrysocarpa','Crataegus chrysocarp chrysocarp',3,0,'','','','079a485e-2d19-564a-b834-f59a043a9470','Crataegus chrysocarpa Ashe var. chrysocarpa','Ashe','VARIETY','','Crataegus','','chrysocarpa','chrysocarpa','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9717','','','Crataegus chrysocarpa var. vigintistamina J.B. Phipps',1,'Crataegus chrysocarpa vigintistamina','Crataegus chrysocarpa var. vigintistamina','Crataegus chrysocarp uigintistamin',3,0,'','','J. B. Phipps','0fe92b23-df60-517b-8908-bfa30879ff8e','Crataegus chrysocarpa var. vigintistamina J.B. Phipps','J.B. Phipps','VARIETY','','Crataegus','','chrysocarpa','vigintistamina','','',NULL,'','','','','','J. B. Phipps','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8673','','','Crataegus dodgei Ashe',1,'Crataegus dodgei','Crataegus dodgei','Crataegus dodge',2,0,'','','Ashe','ef31e724-c5a9-5d81-b483-f38177176908','Crataegus dodgei Ashe','Ashe','SPECIES','','Crataegus','','dodgei','','','',NULL,'','','','','','Ashe','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2413','','','Crataegus ser. Tenuifoliae (Sargent) Rehder',2,'Tenuifoliae','Crataegus ser. Tenuifoliae','Tenuifoliae',1,0,'','','Sargent|Rehder','efc86976-954a-51c5-8a0e-671236dce9e4','Crataegus ser. Tenuifoliae (Sargent) Rehder','(Sargent) Rehder','SERIES','Tenuifoliae','','','','','','',NULL,'Rehder','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8716','','','Crataegus schuettei Ashe var. schuettei',1,'Crataegus schuettei schuettei','Crataegus schuettei var. schuettei','Crataegus schuette schuette',3,0,'','','','e9be7852-2c81-5ca4-ac31-10eae4ab5d90','Crataegus schuettei Ashe var. schuettei','Ashe','VARIETY','','Crataegus','','schuettei','schuettei','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2415','','','Crataegus ser. Punctatae (Loudon) Rehder',2,'Punctatae','Crataegus ser. Punctatae','Punctatae',1,0,'','','Loudon|Rehder','716e56d2-11b1-52c9-9c40-793c807f958a','Crataegus ser. Punctatae (Loudon) Rehder','(Loudon) Rehder','SERIES','Punctatae','','','','','','',NULL,'Rehder','','','','','Loudon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23981','','','Crataegus mollis var. incisifolia Kruschke ex J. B. Phipps',2,'Crataegus mollis incisifolia','Crataegus mollis var. incisifolia','Crataegus moll incisifol',3,0,'','','Kruschke|J. B. Phipps','d5779046-5f8b-59ca-9fe1-dc50c0e14905','Crataegus mollis var. incisifolia Kruschke ex J. B. Phipps','Kruschke ex J. B. Phipps','VARIETY','','Crataegus','','mollis','incisifolia','','',NULL,'','','','','','Kruschke','','J. B. Phipps','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('29477','','','Crataegus jesupii Sargent',1,'Crataegus jesupii','Crataegus jesupii','Crataegus iesup',2,0,'','','Sargent','e0bfd74c-408e-502a-8dc8-0865dfadc303','Crataegus jesupii Sargent','Sargent','SPECIES','','Crataegus','','jesupii','','','',NULL,'','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8664','','','Crataegus cognata Sargent',1,'Crataegus cognata','Crataegus cognata','Crataegus cognat',2,0,'','','Sargent','7c9ebaa5-e78b-5f47-a279-915d09e8fba6','Crataegus cognata Sargent','Sargent','SPECIES','','Crataegus','','cognata','','','',NULL,'','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8670','','','Crataegus pruinosa var. dissona (Sargent) Eggleston',1,'Crataegus pruinosa dissona','Crataegus pruinosa var. dissona','Crataegus pruinos disson',3,0,'','','Sargent|Eggleston','e1065e78-dbda-5cd1-bb02-2bd0423811d9','Crataegus pruinosa var. dissona (Sargent) Eggleston','(Sargent) Eggleston','VARIETY','','Crataegus','','pruinosa','dissona','','',NULL,'Eggleston','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8665','','','Crataegus compacta Sargent',1,'Crataegus compacta','Crataegus compacta','Crataegus compact',2,0,'','','Sargent','6a8d3761-f1b8-5182-95a7-1b5aed14d209','Crataegus compacta Sargent','Sargent','SPECIES','','Crataegus','','compacta','','','',NULL,'','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8683','','','Crataegus holmesiana Ashe',1,'Crataegus holmesiana','Crataegus holmesiana','Crataegus holmesian',2,0,'','','Ashe','baa517aa-e21f-520b-a83e-a2e4d4e16ce0','Crataegus holmesiana Ashe','Ashe','SPECIES','','Crataegus','','holmesiana','','','',NULL,'','','','','','Ashe','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8662','','','Crataegus coccinea Linnaeus',1,'Crataegus coccinea','Crataegus coccinea','Crataegus coccine',2,0,'','','Linnaeus','8646d276-8729-572a-bd9b-e29c75dec513','Crataegus coccinea Linnaeus','Linnaeus','SPECIES','','Crataegus','','coccinea','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23982','','','Crataegus monogyna Jacquin var. monogyna',1,'Crataegus monogyna monogyna','Crataegus monogyna var. monogyna','Crataegus monogyn monogyn',3,0,'','','','11ecaa63-bd2f-5ff8-853e-ef279ea274b0','Crataegus monogyna Jacquin var. monogyna','Jacquin','VARIETY','','Crataegus','','monogyna','monogyna','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8725','','','Crataegus persimilis Sargent',1,'Crataegus persimilis','Crataegus persimilis','Crataegus persimil',2,0,'','','Sargent','164cf479-5f2b-5931-a3ad-e3e4fe142b92','Crataegus persimilis Sargent','Sargent','SPECIES','','Crataegus','','persimilis','','','',NULL,'','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2430','','','Crataegus ser. Montaninsulae J.B. Phipps & O''Kennon',2,'Montaninsulae','Crataegus ser. Montaninsulae','Montaninsulae',1,0,'','','J. B. Phipps|O''Kennon','4e8a55af-4d24-5119-b0da-982ddc1bfd2f','Crataegus ser. Montaninsulae J.B. Phipps & O''Kennon','J.B. Phipps & O''Kennon','SERIES','Montaninsulae','','','','','','',NULL,'','','','','','J. B. Phipps & O''Kennon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9722','','','Crataegus rivuloadamensis J.B. Phipps & O''Kennon',1,'Crataegus rivuloadamensis','Crataegus rivuloadamensis','Crataegus riuuloadamens',2,0,'','','J. B. Phipps|O''Kennon','faaea9dc-e6e7-506d-8817-35d1e74d1fbe','Crataegus rivuloadamensis J.B. Phipps & O''Kennon','J.B. Phipps & O''Kennon','SPECIES','','Crataegus','','rivuloadamensis','','','',NULL,'','','','','','J. B. Phipps & O''Kennon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8723','','','Crataegus ×disperma Ashe',3,'','','',NULL,NULL,'','','','','Crataegus ×disperma Ashe','Ashe','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2406','','','Crataegus ser. Macracanthae (Loudon) Rehder',2,'Macracanthae','Crataegus ser. Macracanthae','Macracanthae',1,0,'','','Loudon|Rehder','dcd0e7cc-b68d-5585-97f2-abce97851418','Crataegus ser. Macracanthae (Loudon) Rehder','(Loudon) Rehder','SERIES','Macracanthae','','','','','','',NULL,'Rehder','','','','','Loudon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8720','','','Crataegus succulenta Schrader ex Link var. succulenta',2,'Crataegus succulenta succulenta','Crataegus succulenta var. succulenta','Crataegus succulent succulent',3,0,'','','','2613e8dc-8bb3-54a6-ad20-34b5faa10727','Crataegus succulenta Schrader ex Link var. succulenta','Schrader ex Link','VARIETY','','Crataegus','','succulenta','succulenta','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9670','','','Crataegus succulenta var. michiganensis (Ashe) E.J. Palmer',1,'Crataegus succulenta michiganensis','Crataegus succulenta var. michiganensis','Crataegus succulent michiganens',3,0,'','','Ashe|E. J. Palmer','ee1df39b-e89d-5771-a34b-3f183c2fe81c','Crataegus succulenta var. michiganensis (Ashe) E.J. Palmer','(Ashe) E.J. Palmer','VARIETY','','Crataegus','','succulenta','michiganensis','','',NULL,'E. J. Palmer','','','','','Ashe','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8678','','','Crataegus florifera Sargent',1,'Crataegus florifera','Crataegus florifera','Crataegus florifer',2,0,'','','Sargent','ef273324-3fc5-5f11-a13d-d953278eb977','Crataegus florifera Sargent','Sargent','SPECIES','','Crataegus','','florifera','','','',NULL,'','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8714','','','Crataegus scabrida Sargent var. scabrida',1,'Crataegus scabrida scabrida','Crataegus scabrida var. scabrida','Crataegus scabrid scabrid',3,0,'','','','e586fb9b-542e-54c7-a405-571c6b569cc0','Crataegus scabrida Sargent var. scabrida','Sargent','VARIETY','','Crataegus','','scabrida','scabrida','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9668','','','Crataegus shuswapensis J.B. Phipps & O''Kennon',1,'Crataegus shuswapensis','Crataegus shuswapensis','Crataegus shuswapens',2,0,'','','J. B. Phipps|O''Kennon','73fd5ef6-6617-56cf-8440-d5e3ad9c05dd','Crataegus shuswapensis J.B. Phipps & O''Kennon','J.B. Phipps & O''Kennon','SPECIES','','Crataegus','','shuswapensis','','','',NULL,'','','','','','J. B. Phipps & O''Kennon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8708','','','Crataegus phippsii O''Kennon',1,'Crataegus phippsii','Crataegus phippsii','Crataegus phipps',2,0,'','','O''Kennon','a0334787-10f4-5719-b9f5-23d62c780cfd','Crataegus phippsii O''Kennon','O''Kennon','SPECIES','','Crataegus','','phippsii','','','',NULL,'','','','','','O''Kennon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8703','','','Crataegus okanaganensis J.B. Phipps & O''Kennon',1,'Crataegus okanaganensis','Crataegus okanaganensis','Crataegus okanaganens',2,0,'','','J. B. Phipps|O''Kennon','d6090a1f-6145-5683-9070-90e1e10871fc','Crataegus okanaganensis J.B. Phipps & O''Kennon','J.B. Phipps & O''Kennon','SPECIES','','Crataegus','','okanaganensis','','','',NULL,'','','','','','J. B. Phipps & O''Kennon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8726','','','Cydonia oblonga Miller',1,'Cydonia oblonga','Cydonia oblonga','Cydonia oblong',2,0,'','','Miller','021c7734-9de1-5745-9e0f-3b84753a5c34','Cydonia oblonga Miller','Miller','SPECIES','','Cydonia','','oblonga','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8788','','','Malus fusca (Rafinesque) C.K. Schneider',1,'Malus fusca','Malus fusca','Malus fusc',2,0,'','','Rafinesque|C. K. Schneider','0b787255-9de6-5f51-8d81-b015935b74af','Malus fusca (Rafinesque) C.K. Schneider','(Rafinesque) C.K. Schneider','SPECIES','','Malus','','fusca','','','',NULL,'C. K. Schneider','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8885','','','Pyrus communis Linnaeus',1,'Pyrus communis','Pyrus communis','Pyrus commun',2,0,'','','Linnaeus','17a76bf1-02c0-537f-a0c1-a164680ac3d0','Pyrus communis Linnaeus','Linnaeus','SPECIES','','Pyrus','','communis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8968','','','Sorbus sitchensis M. Roemer',1,'Sorbus sitchensis','Sorbus sitchensis','Sorbus sitchens',2,0,'','','M. Roemer','8e7ff6b4-7a7d-58e8-b80e-febce055115e','Sorbus sitchensis M. Roemer','M. Roemer','SPECIES','','Sorbus','','sitchensis','','','',NULL,'','','','','','M. Roemer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8991','','','×Sorbaronia arsenii (Britton ex L. Arsène) G.N. Jones',3,'','','',NULL,NULL,'','','','','×Sorbaronia arsenii (Britton ex L. Arsène) G.N. Jones','(Britton ex L. Arsène) G.N. Jones','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31882','','','Scandosorbus Sennikov',1,'Scandosorbus','Scandosorbus','Scandosorbus',1,0,'','','Sennikov','afcea790-7acf-5120-b218-a9da2c72f717','Scandosorbus Sennikov','Sennikov','GENUS','Scandosorbus','','','','','','',NULL,'','','','','','Sennikov','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31883','','','Scandosorbus intermedia (Ehrhart) Sennikov',1,'Scandosorbus intermedia','Scandosorbus intermedia','Scandosorbus intermed',2,0,'','','Ehrhart|Sennikov','0f8c1f6c-9b74-5f70-97fc-8e3f7e15dc01','Scandosorbus intermedia (Ehrhart) Sennikov','(Ehrhart) Sennikov','SPECIES','','Scandosorbus','','intermedia','','','',NULL,'Sennikov','','','','','Ehrhart','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8783','','','Holodiscus discolor (Pursh) Maximowicz',1,'Holodiscus discolor','Holodiscus discolor','Holodiscus discolor',2,0,'','','Pursh|Maximowicz','c9a75285-1430-5fe7-a5be-e6cce3c1e07b','Holodiscus discolor (Pursh) Maximowicz','(Pursh) Maximowicz','SPECIES','','Holodiscus','','discolor','','','',NULL,'Maximowicz','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1711','','','Spiraea Linnaeus',1,'Spiraea','Spiraea','Spiraea',1,0,'','','Linnaeus','79ea2d0c-b5a3-525d-8903-4e2145d7b6de','Spiraea Linnaeus','Linnaeus','GENUS','Spiraea','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('20699','','','Spiraea alba Du Roi var. alba',1,'Spiraea alba alba','Spiraea alba var. alba','Spiraea alb alb',3,0,'','','','af518e52-acba-5b66-a7b3-8e0bcaf6625e','Spiraea alba Du Roi var. alba','Du Roi','VARIETY','','Spiraea','','alba','alba','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8980','','','Spiraea prunifolia Siebold & Zuccarini',1,'Spiraea prunifolia','Spiraea prunifolia','Spiraea prunifol',2,0,'','','Siebold|Zuccarini','397b9930-475e-5a49-b28e-eb57158508ad','Spiraea prunifolia Siebold & Zuccarini','Siebold & Zuccarini','SPECIES','','Spiraea','','prunifolia','','','',NULL,'','','','','','Siebold & Zuccarini','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8988','','','Spiraea ×pyramidata Greene',3,'','','',NULL,NULL,'','','','','Spiraea ×pyramidata Greene','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8977','','','Spiraea douglasii Hooker',1,'Spiraea douglasii','Spiraea douglasii','Spiraea douglas',2,0,'','','Hooker','cd33aec0-a974-5a29-a676-3eac89a7fb53','Spiraea douglasii Hooker','Hooker','SPECIES','','Spiraea','','douglasii','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9767','','','Spiraea splendens var. rosea (A. Gray) Kartesz & Gandhi',1,'Spiraea splendens rosea','Spiraea splendens var. rosea','Spiraea splendens rose',3,0,'','','A. Gray|Kartesz|Gandhi','e2306505-1015-5f26-94bf-72d2c6776899','Spiraea splendens var. rosea (A. Gray) Kartesz & Gandhi','(A. Gray) Kartesz & Gandhi','VARIETY','','Spiraea','','splendens','rosea','','',NULL,'Kartesz & Gandhi','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8640','','','Aruncus dioicus (Walter) Fernald',1,'Aruncus dioicus','Aruncus dioicus','Aruncus dioic',2,0,'','','Walter|Fernald','e1ae7e12-a362-5741-99ae-a7e34ce251a6','Aruncus dioicus (Walter) Fernald','(Walter) Fernald','SPECIES','','Aruncus','','dioicus','','','',NULL,'Fernald','','','','','Walter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1544','','','Physocarpus (Cambessèdes) Rafinesque',2,'Physocarpus','Physocarpus','Physocarpus',1,0,'','','Cambessèdes|Rafinesque','3f91f614-15fd-5461-9e9c-1699eefabe7f','Physocarpus (Cambessèdes) Rafinesque','(Cambessèdes) Rafinesque','GENUS','Physocarpus','','','','','','',NULL,'Rafinesque','','','','','Cambessèdes','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8794','','','Physocarpus opulifolius (Linnaeus) Maximowicz',1,'Physocarpus opulifolius','Physocarpus opulifolius','Physocarpus opulifol',2,0,'','','Linnaeus|Maximowicz','6b1b2473-ef67-5e0c-bee5-cc70b983c056','Physocarpus opulifolius (Linnaeus) Maximowicz','(Linnaeus) Maximowicz','SPECIES','','Physocarpus','','opulifolius','','','',NULL,'Maximowicz','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8859','','','Prunus avium (Linnaeus) Linnaeus',1,'Prunus avium','Prunus avium','Prunus aui',2,0,'','','Linnaeus','4247434a-bd21-596c-8636-1a953589b81e','Prunus avium (Linnaeus) Linnaeus','(Linnaeus) Linnaeus','SPECIES','','Prunus','','avium','','','',NULL,'Linnaeus','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8870','','','Prunus padus Linnaeus',1,'Prunus padus','Prunus padus','Prunus pad',2,0,'','','Linnaeus','02d9a179-0d04-5717-a90b-5acedb228aa1','Prunus padus Linnaeus','Linnaeus','SPECIES','','Prunus','','padus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9656','','','Prunus pumila Linnaeus var. pumila',1,'Prunus pumila pumila','Prunus pumila var. pumila','Prunus pumil pumil',3,0,'','','','9af6cc43-8657-57ba-a507-32769362b106','Prunus pumila Linnaeus var. pumila','Linnaeus','VARIETY','','Prunus','','pumila','pumila','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27973','','','Prunus armeniaca Linnaeus',1,'Prunus armeniaca','Prunus armeniaca','Prunus armeniac',2,0,'','','Linnaeus','28ad15e9-d121-5837-bed5-de77451b77f6','Prunus armeniaca Linnaeus','Linnaeus','SPECIES','','Prunus','','armeniaca','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8962','','','Sorbaria sorbifolia (Linnaeus) A. Braun',1,'Sorbaria sorbifolia','Sorbaria sorbifolia','Sorbaria sorbifol',2,0,'','','Linnaeus|A. Braun','52c837d0-c87e-51e7-b230-a62581c7ad40','Sorbaria sorbifolia (Linnaeus) A. Braun','(Linnaeus) A. Braun','SPECIES','','Sorbaria','','sorbifolia','','','',NULL,'A. Braun','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('705','','','Gillenieae Maximowicz',1,'Gillenieae','Gillenieae','Gillenieae',1,0,'','','Maximowicz','fb684178-d0ab-553d-a5e2-456acdfe6c76','Gillenieae Maximowicz','Maximowicz','TRIBE','Gillenieae','','','','','','',NULL,'','','','','','Maximowicz','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28725','','','Exochordeae Schulze-Menz ex Reveal',2,'Exochordeae','Exochordeae','Exochordeae',1,0,'','','Schulze-Menz|Reveal','061d0e5a-6b8c-5008-979a-420d1668b58d','Exochordeae Schulze-Menz ex Reveal','Schulze-Menz ex Reveal','TRIBE','Exochordeae','','','','','','',NULL,'','','','','','Schulze-Menz','','Reveal','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9425','','','Ulmus glabra Hudson',1,'Ulmus glabra','Ulmus glabra','Ulmus glabr',2,0,'','','Hudson','a51354bb-7b7f-5bd1-aaaf-0d0682ae012e','Ulmus glabra Hudson','Hudson','SPECIES','','Ulmus','','glabra','','','',NULL,'','','','','','Hudson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9430','','','Ulmus rubra Muhlenberg',1,'Ulmus rubra','Ulmus rubra','Ulmus rubr',2,0,'','','Muhlenberg','eeaec964-b0e6-5b43-a9ec-83eda273bf90','Ulmus rubra Muhlenberg','Muhlenberg','SPECIES','','Ulmus','','rubra','','','',NULL,'','','','','','Muhlenberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9431','','','Ulmus thomasii Sargent',1,'Ulmus thomasii','Ulmus thomasii','Ulmus thomas',2,0,'','','Sargent','c4ac5eae-170c-5313-bb80-68888fc676e1','Ulmus thomasii Sargent','Sargent','SPECIES','','Ulmus','','thomasii','','','',NULL,'','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9432','','','Boehmeria cylindrica (Linnaeus) Swartz',1,'Boehmeria cylindrica','Boehmeria cylindrica','Boehmeria cylindric',2,0,'','','Linnaeus|Swartz','29b14e8b-5b64-5d84-a544-2adfd52b5ea9','Boehmeria cylindrica (Linnaeus) Swartz','(Linnaeus) Swartz','SPECIES','','Boehmeria','','cylindrica','','','',NULL,'Swartz','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9438','','','Urtica dioica Linnaeus',1,'Urtica dioica','Urtica dioica','Urtica dioic',2,0,'','','Linnaeus','c05b7b80-25fc-55b2-8ad5-1664b64132b4','Urtica dioica Linnaeus','Linnaeus','SPECIES','','Urtica','','dioica','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1505','','','Parietaria Linnaeus',1,'Parietaria','Parietaria','Parietaria',1,0,'','','Linnaeus','e367535f-94f6-5617-95c6-9f2f823e9f74','Parietaria Linnaeus','Linnaeus','GENUS','Parietaria','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9435','','','Pilea fontana (Lunell) Rydberg',1,'Pilea fontana','Pilea fontana','Pilea fontan',2,0,'','','Lunell|Rydberg','ffbb4bf9-7262-5de5-973b-ab388ee8fa95','Pilea fontana (Lunell) Rydberg','(Lunell) Rydberg','SPECIES','','Pilea','','fontana','','','',NULL,'Rydberg','','','','','Lunell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('522','','','Rhoeae',1,'Rhoeae','Rhoeae','Rhoeae',1,0,'','','','de4f08c0-e3bb-517e-9582-6b7cd0c4ff12','Rhoeae','','TRIBE','Rhoeae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1044','','','Cotinus Miller',1,'Cotinus','Cotinus','Cotinus',1,0,'','','Miller','a165c832-0705-5c54-bd7a-9841d6c43fdb','Cotinus Miller','Miller','GENUS','Cotinus','','','','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2515','','','Cotinus coggygria Scopoli',1,'Cotinus coggygria','Cotinus coggygria','Cotinus coggygr',2,0,'','','Scopoli','6d09c6b4-f557-5e90-9c67-b0ead8151628','Cotinus coggygria Scopoli','Scopoli','SPECIES','','Cotinus','','coggygria','','','',NULL,'','','','','','Scopoli','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2516','','','Rhus aromatica Aiton var. aromatica',1,'Rhus aromatica aromatica','Rhus aromatica var. aromatica','Rhus aromatic aromatic',3,0,'','','','083aff0d-4269-5cef-ba83-aac6f98bd220','Rhus aromatica Aiton var. aromatica','Aiton','VARIETY','','Rhus','','aromatica','aromatica','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('23680','','','Rhus copallinum Linnaeus var. copallinum',1,'Rhus copallinum copallinum','Rhus copallinum var. copallinum','Rhus copallin copallin',3,0,'','','','927c6a86-1d51-5026-93ea-6dd57686d9a7','Rhus copallinum Linnaeus var. copallinum','Linnaeus','VARIETY','','Rhus','','copallinum','copallinum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('377','','','Rutoideae Arnott',1,'Rutoideae','Rutoideae','Rutoideae',1,0,'','','Arnott','66bf31cd-1879-5a7c-89b5-33b733e659ec','Rutoideae Arnott','Arnott','SUBFAMILY','Rutoideae','','','','','','',NULL,'','','','','','Arnott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9039','','','Ptelea trifoliata Linnaeus',1,'Ptelea trifoliata','Ptelea trifoliata','Ptelea trifoliat',2,0,'','','Linnaeus','f7ca7127-e60b-5e50-a483-b9278fe701da','Ptelea trifoliata Linnaeus','Linnaeus','SPECIES','','Ptelea','','trifoliata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9041','','','Zanthoxylum americanum Miller',1,'Zanthoxylum americanum','Zanthoxylum americanum','Zanthoxylum american',2,0,'','','Miller','23cf6ef2-2042-585e-a9f6-db62d895997e','Zanthoxylum americanum Miller','Miller','SPECIES','','Zanthoxylum','','americanum','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('213','','','Sapindaceae de Jussieu',1,'Sapindaceae','Sapindaceae','Sapindaceae',1,0,'','','de Jussieu','915ee5b1-6a8b-57db-9951-8cb710da1193','Sapindaceae de Jussieu','de Jussieu','FAMILY','Sapindaceae','','','','','','',NULL,'','','','','','de Jussieu','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('769','','','Acer Linnaeus',1,'Acer','Acer','Acer',1,0,'','','Linnaeus','a448670a-0aac-5e11-a688-6cee4a3fbb41','Acer Linnaeus','Linnaeus','GENUS','Acer','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32293','','','Acer sect. Macrantha Pax',2,'Macrantha','Acer sect. Macrantha','Macrantha',1,0,'','','Pax','6f3f3e8b-8f8d-5817-9c00-bfbd0cd88555','Acer sect. Macrantha Pax','Pax','SECTION','Macrantha','','','','','','',NULL,'','','','','','Pax','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32294','','','Acer sect. Glabra Pax',2,'Glabra','Acer sect. Glabra','Glabra',1,0,'','','Pax','55e5dc4b-9e5b-5762-b6e0-440b05f173e3','Acer sect. Glabra Pax','Pax','SECTION','Glabra','','','','','','',NULL,'','','','','','Pax','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21082','','','Acer negundo Linnaeus var. negundo',1,'Acer negundo negundo','Acer negundo var. negundo','Acer negund negund',3,0,'','','','a6ca4ca7-20cc-5649-8bea-2ddad4b1ba21','Acer negundo Linnaeus var. negundo','Linnaeus','VARIETY','','Acer','','negundo','negundo','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32278','','','Acer negundo var. texanum Pax',1,'Acer negundo texanum','Acer negundo var. texanum','Acer negund texan',3,0,'','','Pax','92c2f4f3-8c9c-5eeb-ad9b-04c94ad9d4d4','Acer negundo var. texanum Pax','Pax','VARIETY','','Acer','','negundo','texanum','','',NULL,'','','','','','Pax','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32297','','','Acer sect. Ginnala Nakai',2,'Ginnala','Acer sect. Ginnala','Ginnala',1,0,'','','Nakai','7aab183d-8ee3-56c9-80c7-097fd0565148','Acer sect. Ginnala Nakai','Nakai','SECTION','Ginnala','','','','','','',NULL,'','','','','','Nakai','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32298','','','Acer sect. Rubra Pax',2,'Rubra','Acer sect. Rubra','Rubra',1,0,'','','Pax','96fe4257-1e40-5cac-8f0e-5547975fdb08','Acer sect. Rubra Pax','Pax','SECTION','Rubra','','','','','','',NULL,'','','','','','Pax','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21088','','','Acer rubrum var. trilobum Torrey & A. Gray ex K. Koch',2,'Acer rubrum trilobum','Acer rubrum var. trilobum','Acer rubr trilob',3,0,'','','Torrey|A. Gray|K. Koch','4c67ef31-a452-5484-829b-6d2e2770e119','Acer rubrum var. trilobum Torrey & A. Gray ex K. Koch','Torrey & A. Gray ex K. Koch','VARIETY','','Acer','','rubrum','trilobum','','',NULL,'','','','','','Torrey & A. Gray','','K. Koch','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24399','','','Hippocastaneae (de Candolle) Dumortier',1,'Hippocastaneae','Hippocastaneae','Hippocastaneae',1,0,'','','de Candolle|Dumortier','8be231f5-ef1e-56a4-bfe9-09675ba3bda4','Hippocastaneae (de Candolle) Dumortier','(de Candolle) Dumortier','TRIBE','Hippocastaneae','','','','','','',NULL,'Dumortier','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9217','','','Aesculus glabra Willdenow var. glabra',1,'Aesculus glabra glabra','Aesculus glabra var. glabra','Aesculus glabr glabr',3,0,'','','','b31e185b-5f2f-53e9-88f2-b81b7ff9856f','Aesculus glabra Willdenow var. glabra','Willdenow','VARIETY','','Aesculus','','glabra','glabra','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('71','','','Vitales Berchtold & J. Presl',1,'Vitales','Vitales','Vitales',1,0,'','','Berchtold|J. Presl','cbe0e626-3797-561c-83eb-c07e6f8565f0','Vitales Berchtold & J. Presl','Berchtold & J. Presl','ORDER','Vitales','','','','','','',NULL,'','','','','','Berchtold & J. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9540','','','Parthenocissus tricuspidata (Siebold & Zuccarini) Planchon',1,'Parthenocissus tricuspidata','Parthenocissus tricuspidata','Parthenocissus tricuspidat',2,0,'','','Siebold|Zuccarini|Planchon','993f687c-e014-586c-8c59-9fdd3d08054e','Parthenocissus tricuspidata (Siebold & Zuccarini) Planchon','(Siebold & Zuccarini) Planchon','SPECIES','','Parthenocissus','','tricuspidata','','','',NULL,'Planchon','','','','','Siebold & Zuccarini','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9542','','','Vitis labrusca Linnaeus',1,'Vitis labrusca','Vitis labrusca','Vitis labrusc',2,0,'','','Linnaeus','adb97bbe-7390-5d80-90ee-b50dd1061f71','Vitis labrusca Linnaeus','Linnaeus','SPECIES','','Vitis','','labrusca','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28979','','','Ampelopsis glandulosa (Wallich) Momiyama',1,'Ampelopsis glandulosa','Ampelopsis glandulosa','Ampelopsis glandulos',2,0,'','','Wallich|Momiyama','506c89d5-0633-554a-99a3-2099ef9d0b7e','Ampelopsis glandulosa (Wallich) Momiyama','(Wallich) Momiyama','SPECIES','','Ampelopsis','','glandulosa','','','',NULL,'Momiyama','','','','','Wallich','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('63','','','Santalales Lindley',1,'Santalales','Santalales','Santalales',1,0,'','','Lindley','fce45957-d5fb-5ab7-8789-2b8c5ce6adca','Santalales Lindley','Lindley','ORDER','Santalales','','','','','','',NULL,'','','','','','Lindley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('30193','','','Arceuthobium campylopodum subsp. tsugense (Rosendahl) Nickrent',1,'Arceuthobium campylopodum tsugense','Arceuthobium campylopodum subsp. tsugense','Arceuthobium campylopod tsugens',3,0,'','','Rosendahl|Nickrent','9339ec33-2999-52bb-8b93-71ef25cdfc3f','Arceuthobium campylopodum subsp. tsugense (Rosendahl) Nickrent','(Rosendahl) Nickrent','SUBSPECIES','','Arceuthobium','','campylopodum','tsugense','','',NULL,'Nickrent','','','','','Rosendahl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33422','','','Comandraceae Nickrent & Der',1,'Comandraceae','Comandraceae','Comandraceae',1,0,'','','Nickrent|Der','b2d07511-350d-57f5-a6fb-c1e84105a8d0','Comandraceae Nickrent & Der','Nickrent & Der','FAMILY','Comandraceae','','','','','','',NULL,'','','','','','Nickrent & Der','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9197','','','Geocaulon lividum (Richardson) Fernald',1,'Geocaulon lividum','Geocaulon lividum','Geocaulon liuid',2,0,'','','Richardson|Fernald','1a4f686e-e1e1-522f-ab3a-2cc947705541','Geocaulon lividum (Richardson) Fernald','(Richardson) Fernald','SPECIES','','Geocaulon','','lividum','','','',NULL,'Fernald','','','','','Richardson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('585','','','Sedeae',1,'Sedeae','Sedeae','Sedeae',1,0,'','','','bb1bf8ff-d578-5563-9912-c4e6d1afadae','Sedeae','','TRIBE','Sedeae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4682','','','Hylotelephium telephioides (Michaux) H. Ohba',1,'Hylotelephium telephioides','Hylotelephium telephioides','Hylotelephium telephioid',2,0,'','','Michaux|H. Ohba','dc05e470-3d65-553b-8c8c-cddd1d160c7f','Hylotelephium telephioides (Michaux) H. Ohba','(Michaux) H. Ohba','SPECIES','','Hylotelephium','','telephioides','','','',NULL,'H. Ohba','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1673','','','Sedum Linnaeus',1,'Sedum','Sedum','Sedum',1,0,'','','Linnaeus','48d6b1d7-36b8-58de-bfc2-dbc6edc84d92','Sedum Linnaeus','Linnaeus','GENUS','Sedum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4663','','','Sedum album Linnaeus',1,'Sedum album','Sedum album','Sedum alb',2,0,'','','Linnaeus','ee777e59-3b92-5d74-b960-8ad2d783673b','Sedum album Linnaeus','Linnaeus','SPECIES','','Sedum','','album','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4674','','','Sedum sarmentosum Bunge',1,'Sedum sarmentosum','Sedum sarmentosum','Sedum sarmentos',2,0,'','','Bunge','9ff524cd-3071-587c-9c9e-4ecd7cd47480','Sedum sarmentosum Bunge','Bunge','SPECIES','','Sedum','','sarmentosum','','','',NULL,'','','','','','Bunge','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4668','','','Sedum lanceolatum Torrey var. lanceolatum',1,'Sedum lanceolatum lanceolatum','Sedum lanceolatum var. lanceolatum','Sedum lanceolat lanceolat',3,0,'','','','e6389edf-2b5a-5f64-aa13-ff0c06e64dd5','Sedum lanceolatum Torrey var. lanceolatum','Torrey','VARIETY','','Sedum','','lanceolatum','lanceolatum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4677','','','Sedum spathulifolium Hooker',1,'Sedum spathulifolium','Sedum spathulifolium','Sedum spathulifoli',2,0,'','','Hooker','3e5a16d4-0579-574a-9e83-e6c9789d704e','Sedum spathulifolium Hooker','Hooker','SPECIES','','Sedum','','spathulifolium','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28664','','','Sedum thartii L.P. Hébert',1,'Sedum thartii','Sedum thartii','Sedum thart',2,0,'','','L. P. Hébert','bfdc09df-4dff-5de9-b7ce-4da6a3e4cd3e','Sedum thartii L.P. Hébert','L.P. Hébert','SPECIES','','Sedum','','thartii','','','',NULL,'','','','','','L. P. Hébert','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31421','','','Petrosedum ochroleucum (Chaix) Niederle',1,'Petrosedum ochroleucum','Petrosedum ochroleucum','Petrosedum ochroleuc',2,0,'','','Chaix|Niederle','817b31cb-f8e2-5138-977a-3e16bae28203','Petrosedum ochroleucum (Chaix) Niederle','(Chaix) Niederle','SPECIES','','Petrosedum','','ochroleucum','','','',NULL,'Niederle','','','','','Chaix','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1762','','','Crassula Linnaeus',1,'Crassula','Crassula','Crassula',1,0,'','','Linnaeus','411e3397-25b4-5c19-8bf4-63e2ff06ab48','Crassula Linnaeus','Linnaeus','GENUS','Crassula','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('137','','','Grossulariaceae de Candolle',1,'Grossulariaceae','Grossulariaceae','Grossulariaceae',1,0,'','','de Candolle','960a5c3a-47bb-5f09-b780-44db0409ef33','Grossulariaceae de Candolle','de Candolle','FAMILY','Grossulariaceae','','','','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6055','','','Ribes americanum Miller',1,'Ribes americanum','Ribes americanum','Ribes american',2,0,'','','Miller','e7b6a4fe-d656-5288-b5e3-064f641edfd1','Ribes americanum Miller','Miller','SPECIES','','Ribes','','americanum','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6072','','','Ribes lacustre (Persoon) Poiret',1,'Ribes lacustre','Ribes lacustre','Ribes lacustr',2,0,'','','Persoon|Poiret','aff02bcf-9575-58c5-8c98-150f52fb073c','Ribes lacustre (Persoon) Poiret','(Persoon) Poiret','SPECIES','','Ribes','','lacustre','','','',NULL,'Poiret','','','','','Persoon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6077','','','Ribes nigrum Linnaeus',1,'Ribes nigrum','Ribes nigrum','Ribes nigr',2,0,'','','Linnaeus','df249764-57f5-571e-8467-24a6fd4899c4','Ribes nigrum Linnaeus','Linnaeus','SPECIES','','Ribes','','nigrum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6057','','','Ribes aureum Pursh',1,'Ribes aureum','Ribes aureum','Ribes aure',2,0,'','','Pursh','d09afe92-90e7-5529-b868-41aa1fa6a472','Ribes aureum Pursh','Pursh','SPECIES','','Ribes','','aureum','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6059','','','Ribes cereum Douglas var. cereum',1,'Ribes cereum cereum','Ribes cereum var. cereum','Ribes cere cere',3,0,'','','','10c4a2a6-336f-5aa7-b643-022d0fb3a554','Ribes cereum Douglas var. cereum','Douglas','VARIETY','','Ribes','','cereum','cereum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6063','','','Ribes divaricatum Douglas var. divaricatum',1,'Ribes divaricatum divaricatum','Ribes divaricatum var. divaricatum','Ribes diuaricat diuaricat',3,0,'','','','0ea47775-cacb-5e04-a388-b99cab3f3da1','Ribes divaricatum Douglas var. divaricatum','Douglas','VARIETY','','Ribes','','divaricatum','divaricatum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6085','','','Ribes sanguineum Pursh',1,'Ribes sanguineum','Ribes sanguineum','Ribes sanguine',2,0,'','','Pursh','d0861c68-3bc6-55f3-8943-2781f683c58f','Ribes sanguineum Pursh','Pursh','SPECIES','','Ribes','','sanguineum','','','',NULL,'','','','','','Pursh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6080','','','Ribes oxyacanthoides Linnaeus',1,'Ribes oxyacanthoides','Ribes oxyacanthoides','Ribes oxyacanthoid',2,0,'','','Linnaeus','f87bc109-87de-593f-b0aa-0ad321f35f36','Ribes oxyacanthoides Linnaeus','Linnaeus','SPECIES','','Ribes','','oxyacanthoides','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('139','','','Haloragaceae R. Brown',1,'Haloragaceae','Haloragaceae','Haloragaceae',1,0,'','','R. Brown','b2698827-e138-5ab9-9661-895454b64dea','Haloragaceae R. Brown','R. Brown','FAMILY','Haloragaceae','','','','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26998','','','Myriophyllum subsect. Isophylleae (Schindler) M.L. Moody & Les',2,'Isophylleae','Myriophyllum subsect. Isophylleae','Isophylleae',1,0,'','','Schindler|M. L. Moody|Les','95f37d43-b50a-5f32-8bd5-a99db16ace84','Myriophyllum subsect. Isophylleae (Schindler) M.L. Moody & Les','(Schindler) M.L. Moody & Les','SUBSECTION','Isophylleae','','','','','','',NULL,'M. L. Moody & Les','','','','','Schindler','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26999','','','Myriophyllum sect. Pectinatum M.L. Moody & Les',2,'Pectinatum','Myriophyllum sect. Pectinatum','Pectinatum',1,0,'','','M. L. Moody|Les','abdaa842-38da-5865-86d4-1fe533e5d9fc','Myriophyllum sect. Pectinatum M.L. Moody & Les','M.L. Moody & Les','SECTION','Pectinatum','','','','','','',NULL,'','','','','','M. L. Moody & Les','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6097','','','Myriophyllum heterophyllum Michaux',1,'Myriophyllum heterophyllum','Myriophyllum heterophyllum','Myriophyllum heterophyll',2,0,'','','Michaux','a545e29c-774d-5ef1-9ba2-06dea696de4f','Myriophyllum heterophyllum Michaux','Michaux','SPECIES','','Myriophyllum','','heterophyllum','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6104','','','Myriophyllum tenellum Bigelow',1,'Myriophyllum tenellum','Myriophyllum tenellum','Myriophyllum tenell',2,0,'','','Bigelow','c13e73c3-55de-5ab5-b6e5-d0fed7fcada0','Myriophyllum tenellum Bigelow','Bigelow','SPECIES','','Myriophyllum','','tenellum','','','',NULL,'','','','','','Bigelow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('27004','','','Myriophyllum subsect. Nudiflorum M.L. Moody & Les',2,'Nudiflorum','Myriophyllum subsect. Nudiflorum','Nudiflorum',1,0,'','','M. L. Moody|Les','d03b2569-88fe-5d3c-94ff-91d7f2c4e50d','Myriophyllum subsect. Nudiflorum M.L. Moody & Les','M.L. Moody & Les','SUBSECTION','Nudiflorum','','','','','','',NULL,'','','','','','M. L. Moody & Les','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('338','','','Hamamelidoideae',1,'Hamamelidoideae','Hamamelidoideae','Hamamelidoideae',1,0,'','','','8430e457-e236-5771-be42-f6776ef985b3','Hamamelidoideae','','SUBFAMILY','Hamamelidoideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6110','','','Hamamelis virginiana Linnaeus',1,'Hamamelis virginiana','Hamamelis virginiana','Hamamelis uirginian',2,0,'','','Linnaeus','a03a4f6d-7958-57ad-b878-c1a138533545','Hamamelis virginiana Linnaeus','Linnaeus','SPECIES','','Hamamelis','','virginiana','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7085','','','Paeonia officinalis Linnaeus',1,'Paeonia officinalis','Paeonia officinalis','Paeonia officinal',2,0,'','','Linnaeus','37e4886a-60ce-5ccc-b12f-06ab51dcfc86','Paeonia officinalis Linnaeus','Linnaeus','SPECIES','','Paeonia','','officinalis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('908','','','Boykinia Nuttall',1,'Boykinia','Boykinia','Boykinia',1,0,'','','Nuttall','e49c05f1-9af9-5dc5-8b6d-46b1134c4b67','Boykinia Nuttall','Nuttall','GENUS','Boykinia','','','','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9229','','','Chrysosplenium tetrandrum Th. Fries',1,'Chrysosplenium tetrandrum','Chrysosplenium tetrandrum','Chrysosplenium tetrandr',2,0,'','','Th. Fries','56adb573-5479-5097-97bf-897eb0bbce80','Chrysosplenium tetrandrum Th. Fries','Th. Fries','SPECIES','','Chrysosplenium','','tetrandrum','','','',NULL,'','','','','','Th. Fries','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1131','','','Elmera Rydberg',1,'Elmera','Elmera','Elmera',1,0,'','','Rydberg','8badab78-7dcf-57db-9de4-584d0c35a67a','Elmera Rydberg','Rydberg','GENUS','Elmera','','','','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9236','','','Heuchera cylindrica Douglas',1,'Heuchera cylindrica','Heuchera cylindrica','Heuchera cylindric',2,0,'','','Douglas','20ca3499-f3f0-5283-b683-4ac422af020d','Heuchera cylindrica Douglas','Douglas','SPECIES','','Heuchera','','cylindrica','','','',NULL,'','','','','','Douglas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9233','','','Heuchera americana Linnaeus var. americana',1,'Heuchera americana americana','Heuchera americana var. americana','Heuchera american american',3,0,'','','','1f7a8bde-0eb5-589a-b6d1-a6cf968b70b4','Heuchera americana Linnaeus var. americana','Linnaeus','VARIETY','','Heuchera','','americana','americana','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9239','','','Heuchera micrantha Douglas ex Lindley',2,'Heuchera micrantha','Heuchera micrantha','Heuchera micranth',2,0,'','','Douglas|Lindley','c752da3b-09e0-5261-a6f8-4c01485cf42d','Heuchera micrantha Douglas ex Lindley','Douglas ex Lindley','SPECIES','','Heuchera','','micrantha','','','',NULL,'','','','','','Douglas','','Lindley','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9242','','','Leptarrhena pyrolifolia (D. Don) R. Brown ex Seringe',2,'Leptarrhena pyrolifolia','Leptarrhena pyrolifolia','Leptarrhena pyrolifol',2,0,'','','D. Don|R. Brown|Seringe','13701f45-994d-553f-8da2-d6182788e280','Leptarrhena pyrolifolia (D. Don) R. Brown ex Seringe','(D. Don) R. Brown ex Seringe','SPECIES','','Leptarrhena','','pyrolifolia','','','',NULL,'R. Brown','','Seringe','','','D. Don','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9272','','','Mitella caulescens Nuttall',1,'Mitella caulescens','Mitella caulescens','Mitella caulescens',2,0,'','','Nuttall','a0dd5b5f-4559-5cc4-8041-edcb1cb8a84a','Mitella caulescens Nuttall','Nuttall','SPECIES','','Mitella','','caulescens','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9277','','','Mitella trifida Graham',1,'Mitella trifida','Mitella trifida','Mitella trifid',2,0,'','','Graham','f5a932b8-cac1-5519-b030-4d7e97256cb5','Mitella trifida Graham','Graham','SPECIES','','Mitella','','trifida','','','',NULL,'','','','','','Graham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1655','','','Saxifraga Linnaeus',1,'Saxifraga','Saxifraga','Saxifraga',1,0,'','','Linnaeus','94722677-7ee2-595a-aba2-c02a9e831266','Saxifraga Linnaeus','Linnaeus','GENUS','Saxifraga','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9737','','','Saxifraga rosacea Moench',1,'Saxifraga rosacea','Saxifraga rosacea','Saxifraga rosace',2,0,'','','Moench','830e04a1-8123-5b49-848a-7e9574080f7e','Saxifraga rosacea Moench','Moench','SPECIES','','Saxifraga','','rosacea','','','',NULL,'','','','','','Moench','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2329','','','Saxifraga sect. Mesogyne Sternberg',2,'Mesogyne','Saxifraga sect. Mesogyne','Mesogyne',1,0,'','','Sternberg','b8d421bf-63bc-5135-bef0-3a7b46c2cf7e','Saxifraga sect. Mesogyne Sternberg','Sternberg','SECTION','Mesogyne','','','','','','',NULL,'','','','','','Sternberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9301','','','Saxifraga rivularis Linnaeus subsp. rivularis',1,'Saxifraga rivularis rivularis','Saxifraga rivularis subsp. rivularis','Saxifraga riuular riuular',3,0,'','','','24b783fc-144d-5be3-a929-bb743c89b53a','Saxifraga rivularis Linnaeus subsp. rivularis','Linnaeus','SUBSPECIES','','Saxifraga','','rivularis','rivularis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9826','','','Saxifraga rivularis subsp. arctolitoralis (Jurtzev & V.V. Petrovsky) M.H. Jørgensen & Elven',1,'Saxifraga rivularis arctolitoralis','Saxifraga rivularis subsp. arctolitoralis','Saxifraga riuular arctolitoral',3,0,'','','Jurtzev|V. V. Petrovsky|M. H. Jørgensen|Elven','438b3b82-14bb-5858-b4c6-d3025a1a86a8','Saxifraga rivularis subsp. arctolitoralis (Jurtzev & V.V. Petrovsky) M.H. Jørgensen & Elven','(Jurtzev & V.V. Petrovsky) M.H. Jørgensen & Elven','SUBSPECIES','','Saxifraga','','rivularis','arctolitoralis','','',NULL,'M. H. Jørgensen & Elven','','','','','Jurtzev & V. V. Petrovsky','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9287','','','Saxifraga flagellaris subsp. platysepala (Trautvetter) A.E. Porsild',1,'Saxifraga flagellaris platysepala','Saxifraga flagellaris subsp. platysepala','Saxifraga flagellar platysepal',3,0,'','','Trautvetter|A. E. Porsild','fd198360-0182-545f-9e48-afec0536636a','Saxifraga flagellaris subsp. platysepala (Trautvetter) A.E. Porsild','(Trautvetter) A.E. Porsild','SUBSPECIES','','Saxifraga','','flagellaris','platysepala','','',NULL,'A. E. Porsild','','','','','Trautvetter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9292','','','Saxifraga mertensiana Bongard',1,'Saxifraga mertensiana','Saxifraga mertensiana','Saxifraga mertensian',2,0,'','','Bongard','130e195f-b565-5190-843c-c2f5b6df9dc3','Saxifraga mertensiana Bongard','Bongard','SPECIES','','Saxifraga','','mertensiana','','','',NULL,'','','','','','Bongard','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9293','','','Saxifraga nathorstii (Dusén) Hayek',1,'Saxifraga nathorstii','Saxifraga nathorstii','Saxifraga nathorst',2,0,'','','Dusén|Hayek','409b810d-4199-57c9-b2ba-5c35d26278b2','Saxifraga nathorstii (Dusén) Hayek','(Dusén) Hayek','SPECIES','','Saxifraga','','nathorstii','','','',NULL,'Hayek','','','','','Dusén','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21278','','','Saxifraga funstonii (Small) Fedde',1,'Saxifraga funstonii','Saxifraga funstonii','Saxifraga funston',2,0,'','','Small|Fedde','55d7a949-92da-5979-a6f1-023befeccfc7','Saxifraga funstonii (Small) Fedde','(Small) Fedde','SPECIES','','Saxifraga','','funstonii','','','',NULL,'Fedde','','','','','Small','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9735','','','Saxifraga ×geum Linnaeus',3,'','','',NULL,NULL,'','','','','Saxifraga ×geum Linnaeus','Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1730','','','Suksdorfia A. Gray',1,'Suksdorfia','Suksdorfia','Suksdorfia',1,0,'','','A. Gray','12053b28-1c21-5afa-af09-ae8c5baec4c0','Suksdorfia A. Gray','A. Gray','GENUS','Suksdorfia','','','','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1760','','','Tiarella Linnaeus',1,'Tiarella','Tiarella','Tiarella',1,0,'','','Linnaeus','b182e7fa-ace7-515f-9410-934ad36531dd','Tiarella Linnaeus','Linnaeus','GENUS','Tiarella','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9312','','','Tiarella trifoliata var. laciniata (Hooker) Wheelock',1,'Tiarella trifoliata laciniata','Tiarella trifoliata var. laciniata','Tiarella trifoliat laciniat',3,0,'','','Hooker|Wheelock','17a8c735-5204-5d73-89bb-01374abff660','Tiarella trifoliata var. laciniata (Hooker) Wheelock','(Hooker) Wheelock','VARIETY','','Tiarella','','trifoliata','laciniata','','',NULL,'Wheelock','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32794','','','Tiarella stolonifera G.L. Nesom',1,'Tiarella stolonifera','Tiarella stolonifera','Tiarella stolonifer',2,0,'','','G. L. Nesom','2e960d12-78d2-5ac4-9a0d-a21b5b6c1292','Tiarella stolonifera G.L. Nesom','G.L. Nesom','SPECIES','','Tiarella','','stolonifera','','','',NULL,'','','','','','G. L. Nesom','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9257','','','Micranthes nidifica (Greene) Small',1,'Micranthes nidifica','Micranthes nidifica','Micranthes nidific',2,0,'','','Greene|Small','0ebfbfcd-be54-54af-9795-297cbec6d4c8','Micranthes nidifica (Greene) Small','(Greene) Small','SPECIES','','Micranthes','','nidifica','','','',NULL,'Small','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9262','','','Micranthes pensylvanica (Linnaeus) Haworth',1,'Micranthes pensylvanica','Micranthes pensylvanica','Micranthes pensyluanic',2,0,'','','Linnaeus|Haworth','288527e2-5499-5a2a-9b53-eabb2e43aae5','Micranthes pensylvanica (Linnaeus) Haworth','(Linnaeus) Haworth','SPECIES','','Micranthes','','pensylvanica','','','',NULL,'Haworth','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9264','','','Micranthes rufidula Small',1,'Micranthes rufidula','Micranthes rufidula','Micranthes rufidul',2,0,'','','Small','8a5b4751-2f77-5614-8315-e829dd588cff','Micranthes rufidula Small','Small','SPECIES','','Micranthes','','rufidula','','','',NULL,'','','','','','Small','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9268','','','Micranthes tischii (Skelly) Brouillet & Gornall',1,'Micranthes tischii','Micranthes tischii','Micranthes tisch',2,0,'','','Skelly|Brouillet|Gornall','a38ff16a-f567-5ec6-b9e7-b1376c66682b','Micranthes tischii (Skelly) Brouillet & Gornall','(Skelly) Brouillet & Gornall','SPECIES','','Micranthes','','tischii','','','',NULL,'Brouillet & Gornall','','','','','Skelly','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33504','','','Micranthes sect. Stellares (Engler & Irmscher) Tkach',2,'Stellares','Micranthes sect. Stellares','Stellares',1,0,'','','Engler|Irmscher|Tkach','c49eb2b4-0a7c-5479-b150-8ced519de1a7','Micranthes sect. Stellares (Engler & Irmscher) Tkach','(Engler & Irmscher) Tkach','SECTION','Stellares','','','','','','',NULL,'Tkach','','','','','Engler & Irmscher','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9266','','','Micranthes stellaris (Linnaeus) Galasso, Banfi & Soldano',1,'Micranthes stellaris','Micranthes stellaris','Micranthes stellar',2,0,'','','Linnaeus|Galasso|Banfi|Soldano','c44e9962-201d-5349-85eb-54c27fbbb6e8','Micranthes stellaris (Linnaeus) Galasso, Banfi & Soldano','(Linnaeus) Galasso, Banfi & Soldano','SPECIES','','Micranthes','','stellaris','','','',NULL,'Galasso, Banfi & Soldano','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9260','','','Micranthes odontoloma (Piper) A. Heller',1,'Micranthes odontoloma','Micranthes odontoloma','Micranthes odontolom',2,0,'','','Piper|A. Heller','54f42396-fe99-5990-9741-d26db6fdcd96','Micranthes odontoloma (Piper) A. Heller','(Piper) A. Heller','SPECIES','','Micranthes','','odontoloma','','','',NULL,'A. Heller','','','','','Piper','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9256','','','Micranthes nelsoniana var. porsildiana (Calder & Savile) Gornall & H. Ohba',1,'Micranthes nelsoniana porsildiana','Micranthes nelsoniana var. porsildiana','Micranthes nelsonian porsildian',3,0,'','','Calder|Savile|Gornall|H. Ohba','bf6d6462-9579-574d-ab4e-6868504434e0','Micranthes nelsoniana var. porsildiana (Calder & Savile) Gornall & H. Ohba','(Calder & Savile) Gornall & H. Ohba','VARIETY','','Micranthes','','nelsoniana','porsildiana','','',NULL,'Gornall & H. Ohba','','','','','Calder & Savile','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32864','','','Brewerimitella ovalis (Greene) R.A. Folk & Y. Okuyama',1,'Brewerimitella ovalis','Brewerimitella ovalis','Brewerimitella oual',2,0,'','','Greene|R. A. Folk|Y. Okuyama','4817720b-9e9f-5060-b1ed-351f9c7b8e71','Brewerimitella ovalis (Greene) R.A. Folk & Y. Okuyama','(Greene) R.A. Folk & Y. Okuyama','SPECIES','','Brewerimitella','','ovalis','','','',NULL,'R. A. Folk & Y. Okuyama','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31447','','','Cercidiphyllum Siebold & Zuccarini',1,'Cercidiphyllum','Cercidiphyllum','Cercidiphyllum',1,0,'','','Siebold|Zuccarini','22e14b1e-2804-54a4-9d8c-f3051c66fd44','Cercidiphyllum Siebold & Zuccarini','Siebold & Zuccarini','GENUS','Cercidiphyllum','','','','','','',NULL,'','','','','','Siebold & Zuccarini','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32946','','','Gunnera Linnaeus',1,'Gunnera','Gunnera','Gunnera',1,0,'','','Linnaeus','c938e591-f43b-5891-9f43-a7d81a3dadd5','Gunnera Linnaeus','Linnaeus','GENUS','Gunnera','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32947','','','Gunnera tinctoria (Molina) Mirbel',1,'Gunnera tinctoria','Gunnera tinctoria','Gunnera tinctor',2,0,'','','Molina|Mirbel','ec7390b0-d397-5adf-92d1-f29f4d6ae9c5','Gunnera tinctoria (Molina) Mirbel','(Molina) Mirbel','SPECIES','','Gunnera','','tinctoria','','','',NULL,'Mirbel','','','','','Molina','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31526','','','Ophioglossoideae C. Presl',1,'Ophioglossoideae','Ophioglossoideae','Ophioglossoideae',1,0,'','','C. Presl','72a03fa9-6be9-598f-835c-3c2cb4521a37','Ophioglossoideae C. Presl','C. Presl','SUBFAMILY','Ophioglossoideae','','','','','','',NULL,'','','','','','C. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6832','','','Ophioglossum pusillum Rafinesque',1,'Ophioglossum pusillum','Ophioglossum pusillum','Ophioglossum pusill',2,0,'','','Rafinesque','9be87bc8-2bb3-5f89-8cee-96d403781da6','Ophioglossum pusillum Rafinesque','Rafinesque','SPECIES','','Ophioglossum','','pusillum','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3848','','','Botrychium pinnatum H. St.John',1,'Botrychium pinnatum','Botrychium pinnatum','Botrychium pinnat',2,0,'','','H. St. John','c514cdb7-6b1b-5f01-a0d0-a2d4258392cd','Botrychium pinnatum H. St.John','H. St.John','SPECIES','','Botrychium','','pinnatum','','','',NULL,'','','','','','H. St. John','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3851','','','Botrychium hesperium (Maxon & R.T. Clausen) W.H. Wagner & Lellinger',1,'Botrychium hesperium','Botrychium hesperium','Botrychium hesperi',2,0,'','','Maxon|R. T. Clausen|W. H. Wagner|Lellinger','0650a02b-963a-57ef-ac2a-3a6f5324ef92','Botrychium hesperium (Maxon & R.T. Clausen) W.H. Wagner & Lellinger','(Maxon & R.T. Clausen) W.H. Wagner & Lellinger','SPECIES','','Botrychium','','hesperium','','','',NULL,'W. H. Wagner & Lellinger','','','','','Maxon & R. T. Clausen','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3859','','','Botrychium montanum W.H. Wagner',1,'Botrychium montanum','Botrychium montanum','Botrychium montan',2,0,'','','W. H. Wagner','a0bc1684-a238-5653-b771-f3664f377a0b','Botrychium montanum W.H. Wagner','W.H. Wagner','SPECIES','','Botrychium','','montanum','','','',NULL,'','','','','','W. H. Wagner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3862','','','Botrychium paradoxum W.H. Wagner',1,'Botrychium paradoxum','Botrychium paradoxum','Botrychium paradox',2,0,'','','W. H. Wagner','c5348cf4-bd63-53f6-ace2-2cac60a12603','Botrychium paradoxum W.H. Wagner','W.H. Wagner','SPECIES','','Botrychium','','paradoxum','','','',NULL,'','','','','','W. H. Wagner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3867','','','Botrychium ×watertonense W.H. Wagner',3,'','','',NULL,NULL,'','','','','Botrychium ×watertonense W.H. Wagner','W.H. Wagner','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3847','','','Botrychium boreale Milde',1,'Botrychium boreale','Botrychium boreale','Botrychium boreal',2,0,'','','Milde','b33af8e4-4cad-5ec1-9975-fbb3748bc3d8','Botrychium boreale Milde','Milde','SPECIES','','Botrychium','','boreale','','','',NULL,'','','','','','Milde','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12947','','','Botrychium tenebrosum A.A. Eaton',1,'Botrychium tenebrosum','Botrychium tenebrosum','Botrychium tenebros',2,0,'','','A. A. Eaton','701aab51-c8b8-559d-b117-a77bbe258116','Botrychium tenebrosum A.A. Eaton','A.A. Eaton','SPECIES','','Botrychium','','tenebrosum','','','',NULL,'','','','','','A. A. Eaton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26181','','','Botrychium onondagense Underwood',1,'Botrychium onondagense','Botrychium onondagense','Botrychium onondagens',2,0,'','','Underwood','c7250756-108e-557a-8428-02291311c09a','Botrychium onondagense Underwood','Underwood','SPECIES','','Botrychium','','onondagense','','','',NULL,'','','','','','Underwood','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12951','','','Sceptridium dissectum (Sprengel) Lyon',1,'Sceptridium dissectum','Sceptridium dissectum','Sceptridium dissect',2,0,'','','Sprengel|Lyon','f8239a46-5b49-5d8b-839c-190fb9997c9c','Sceptridium dissectum (Sprengel) Lyon','(Sprengel) Lyon','SPECIES','','Sceptridium','','dissectum','','','',NULL,'Lyon','','','','','Sprengel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12961','','','Sceptridium rugulosum (W.H. Wagner) Skoda & Holub',1,'Sceptridium rugulosum','Sceptridium rugulosum','Sceptridium rugulos',2,0,'','','W. H. Wagner|Skoda|Holub','737fc0f6-a1f3-5c35-83ee-3d049509c766','Sceptridium rugulosum (W.H. Wagner) Skoda & Holub','(W.H. Wagner) Skoda & Holub','SPECIES','','Sceptridium','','rugulosum','','','',NULL,'Skoda & Holub','','','','','W. H. Wagner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7182','','','Pinus cembra Linnaeus',1,'Pinus cembra','Pinus cembra','Pinus cembr',2,0,'','','Linnaeus','04fc49a7-35cc-5029-8076-dc0444e4d7c8','Pinus cembra Linnaeus','Linnaeus','SPECIES','','Pinus','','cembra','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32756','','','Pinus subsect. Pinus',2,'Pinus','Pinus subsect. Pinus','Pinus',1,0,'','','','14e69ad8-45e9-57e3-ab50-6be018e4b551','Pinus subsect. Pinus','','SUBSECTION','Pinus','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7196','','','Pinus sylvestris Linnaeus',1,'Pinus sylvestris','Pinus sylvestris','Pinus syluestr',2,0,'','','Linnaeus','877f7a8e-e16c-5faa-bfc0-2aaf5d47b002','Pinus sylvestris Linnaeus','Linnaeus','SPECIES','','Pinus','','sylvestris','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32757','','','Pinus sect. Trifoliae Duhamel du Monceau',2,'Trifoliae','Pinus sect. Trifoliae','Trifoliae',1,0,'','','Duhamel du Monceau','95efb6eb-b33f-5700-8cb4-acbf93a26fb8','Pinus sect. Trifoliae Duhamel du Monceau','Duhamel du Monceau','SECTION','Trifoliae','','','','','','',NULL,'','','','','','Duhamel du Monceau','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32758','','','Pinus subsect. Australes Loudon',2,'Australes','Pinus subsect. Australes','Australes',1,0,'','','Loudon','454215d9-4b7d-5884-b1c3-d775eac8d1e3','Pinus subsect. Australes Loudon','Loudon','SUBSECTION','Australes','','','','','','',NULL,'','','','','','Loudon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7190','','','Pinus ponderosa Douglas ex Lawson & C. Lawson var. ponderosa',2,'Pinus ponderosa ponderosa','Pinus ponderosa var. ponderosa','Pinus ponderos ponderos',3,0,'','','','eb7c562c-cb93-5d0e-931b-8aa388f4e73b','Pinus ponderosa Douglas ex Lawson & C. Lawson var. ponderosa','Douglas ex Lawson & C. Lawson','VARIETY','','Pinus','','ponderosa','ponderosa','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7183','','','Pinus contorta Douglas ex Loudon var. contorta',2,'Pinus contorta contorta','Pinus contorta var. contorta','Pinus contort contort',3,0,'','','','acf21d32-e8cd-5e13-aed3-c71d14b6d48c','Pinus contorta Douglas ex Loudon var. contorta','Douglas ex Loudon','VARIETY','','Pinus','','contorta','contorta','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7169','','','Picea abies (Linnaeus) H. Karsten',1,'Picea abies','Picea abies','Picea abi',2,0,'','','Linnaeus|H. Karsten','41c7af81-f605-560f-bb51-d0edfbec5f9b','Picea abies (Linnaeus) H. Karsten','(Linnaeus) H. Karsten','SPECIES','','Picea','','abies','','','',NULL,'H. Karsten','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7177','','','Picea rubens Sargent',1,'Picea rubens','Picea rubens','Picea rubens',2,0,'','','Sargent','c7f3af58-89e9-5edc-9e2f-f3ee600f4dd9','Picea rubens Sargent','Sargent','SPECIES','','Picea','','rubens','','','',NULL,'','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7179','','','Picea ×lutzii Little',3,'','','',NULL,NULL,'','','','','Picea ×lutzii Little','Little','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1318','','','Larix Miller',1,'Larix','Larix','Larix',1,0,'','','Miller','5c5bf619-3b9a-53c9-aa78-c8fbcf699211','Larix Miller','Miller','GENUS','Larix','','','','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2213','','','Larix sect. Larix',2,'Larix','Larix sect. Larix','Larix',1,0,'','','','9e2959aa-319f-53da-b926-6d4e5ec29098','Larix sect. Larix','','SECTION','Larix','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7167','','','Larix lyallii Parlatore',1,'Larix lyallii','Larix lyallii','Larix lyall',2,0,'','','Parlatore','6f3bf67f-85ae-52a5-b2e2-f4e8fdad9770','Larix lyallii Parlatore','Parlatore','SPECIES','','Larix','','lyallii','','','',NULL,'','','','','','Parlatore','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32764','','','Abietoideae Sweet',1,'Abietoideae','Abietoideae','Abietoideae',1,0,'','','Sweet','82865ca9-6e95-5935-8ecf-3f304fa0bd28','Abietoideae Sweet','Sweet','SUBFAMILY','Abietoideae','','','','','','',NULL,'','','','','','Sweet','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2210','','','Abies sect. Balsamea Engelmann emend. Farjon & Rushforth',2,'Balsamea','Abies sect. Balsamea','Balsamea',1,0,'','','Engelmann','f6ee1296-59c5-54f2-b2d1-0128408aaa48','Abies sect. Balsamea Engelmann emend. Farjon & Rushforth','Engelmann emend. Farjon & Rushforth','SECTION','Balsamea','','','','','','',NULL,'','','','','','Engelmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7162','','','Abies lasiocarpa (Hooker) Nuttall',1,'Abies lasiocarpa','Abies lasiocarpa','Abies lasiocarp',2,0,'','','Hooker|Nuttall','3c8ff145-a083-56f8-877a-6e583c1976ec','Abies lasiocarpa (Hooker) Nuttall','(Hooker) Nuttall','SPECIES','','Abies','','lasiocarpa','','','',NULL,'Nuttall','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7202','','','Tsuga canadensis (Linnaeus) Carrière',1,'Tsuga canadensis','Tsuga canadensis','Tsuga canadens',2,0,'','','Linnaeus|Carrière','8e9dddba-c1b6-5f9f-a1a5-b0bc8ddca806','Tsuga canadensis (Linnaeus) Carrière','(Linnaeus) Carrière','SPECIES','','Tsuga','','canadensis','','','',NULL,'Carrière','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7205','','','Tsuga ×jeffreyi (Henry) Henry',3,'','','',NULL,NULL,'','','','','Tsuga ×jeffreyi (Henry) Henry','(Henry) Henry','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1299','','','Juniperus Linnaeus',1,'Juniperus','Juniperus','Juniperus',1,0,'','','Linnaeus','8255c135-43d6-567c-9975-7471407654e1','Juniperus Linnaeus','Linnaeus','GENUS','Juniperus','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9865','','','Juniperus communis var. charlottensis R.P. Adams',1,'Juniperus communis charlottensis','Juniperus communis var. charlottensis','Juniperus commun charlottens',3,0,'','','R. P. Adams','b0288fca-a0c6-5d4c-bf0c-4a44ff4be1be','Juniperus communis var. charlottensis R.P. Adams','R.P. Adams','VARIETY','','Juniperus','','communis','charlottensis','','',NULL,'','','','','','R. P. Adams','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33513','','','Juniperus sect. Sabina Spach',2,'Sabina','Juniperus sect. Sabina','Sabina',1,0,'','','Spach','eb575355-4632-56a1-9fe6-bf065a440739','Juniperus sect. Sabina Spach','Spach','SECTION','Sabina','','','','','','',NULL,'','','','','','Spach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9715','','','Juniperus maritima R.P. Adams',1,'Juniperus maritima','Juniperus maritima','Juniperus maritim',2,0,'','','R. P. Adams','729d36d2-024a-518b-9872-008ff8c5b347','Juniperus maritima R.P. Adams','R.P. Adams','SPECIES','','Juniperus','','maritima','','','',NULL,'','','','','','R. P. Adams','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('227','','','Taxaceae Gray',1,'Taxaceae','Taxaceae','Taxaceae',1,0,'','','Gray','8d13e173-b7d3-54db-9831-be3d1737cf5d','Taxaceae Gray','Gray','FAMILY','Taxaceae','','','','','','',NULL,'','','','','','Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32','','','Hymenophyllales A.B. Frank',1,'Hymenophyllales','Hymenophyllales','Hymenophyllales',1,0,'','','A. B. Frank','5e3d4bb3-8762-59e1-8d30-fd66be9d43b2','Hymenophyllales A.B. Frank','A.B. Frank','ORDER','Hymenophyllales','','','','','','',NULL,'','','','','','A. B. Frank','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('56','','','Polypodiales Link',1,'Polypodiales','Polypodiales','Polypodiales',1,0,'','','Link','3a3b0759-bfde-5f85-9421-33c958647f52','Polypodiales Link','Link','ORDER','Polypodiales','','','','','','',NULL,'','','','','','Link','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('870','','','Asplenium Linnaeus',1,'Asplenium','Asplenium','Asplenium',1,0,'','','Linnaeus','a5ad906c-ed6e-5ce3-8c1b-3b5c0582f9f3','Asplenium Linnaeus','Linnaeus','GENUS','Asplenium','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2751','','','Asplenium platyneuron (Linnaeus) Britton, Sterns & Poggenburgh',1,'Asplenium platyneuron','Asplenium platyneuron','Asplenium platyneuron',2,0,'','','Linnaeus|Britton|Sterns|Poggenburgh','6ede9565-2902-5a5b-82b0-865356352282','Asplenium platyneuron (Linnaeus) Britton, Sterns & Poggenburgh','(Linnaeus) Britton, Sterns & Poggenburgh','SPECIES','','Asplenium','','platyneuron','','','',NULL,'Britton, Sterns & Poggenburgh','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34096','','','Asplenium quadrivalens (D.E. Meyer) Landolt',1,'Asplenium quadrivalens','Asplenium quadrivalens','Asplenium quadriualens',2,0,'','','D. E. Meyer|Landolt','2bdef190-dd48-55e8-a7a5-dcbf8bbdf8be','Asplenium quadrivalens (D.E. Meyer) Landolt','(D.E. Meyer) Landolt','SPECIES','','Asplenium','','quadrivalens','','','',NULL,'Landolt','','','','','D. E. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1828','','','Woodwardia Smith',1,'Woodwardia','Woodwardia','Woodwardia',1,0,'','','Smith','6ec2766a-6895-5191-85a5-44579be4bd96','Woodwardia Smith','Smith','GENUS','Woodwardia','','','','','','',NULL,'','','','','','Smith','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('31270','','','Lorinseria C. Presl',1,'Lorinseria','Lorinseria','Lorinseria',1,0,'','','C. Presl','6181518a-fcd5-56e6-9c81-6b8832ee083a','Lorinseria C. Presl','C. Presl','GENUS','Lorinseria','','','','','','',NULL,'','','','','','C. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('33491','','','Hypolepidoideae',1,'Hypolepidoideae','Hypolepidoideae','Hypolepidoideae',1,0,'','','','0c072263-e164-57bb-a4fe-9ddf19e49fb3','Hypolepidoideae','','SUBFAMILY','Hypolepidoideae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1600','','','Pteridium Gleditsch ex Scopoli',2,'Pteridium','Pteridium','Pteridium',1,0,'','','Gleditsch|Scopoli','a5ceaa85-c2ce-5728-bcf2-3cac78bf3b4b','Pteridium Gleditsch ex Scopoli','Gleditsch ex Scopoli','GENUS','Pteridium','','','','','','',NULL,'','','','','','Gleditsch','','Scopoli','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('24668','','','Dryopteridoideae B.K. Nayar',1,'Dryopteridoideae','Dryopteridoideae','Dryopteridoideae',1,0,'','','B. K. Nayar','e4d7950d-30a5-5b5e-b04b-f45ed4d7fb8d','Dryopteridoideae B.K. Nayar','B.K. Nayar','SUBFAMILY','Dryopteridoideae','','','','','','',NULL,'','','','','','B. K. Nayar','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5388','','','Dryopteris clintoniana (D.C. Eaton) Dowell',1,'Dryopteris clintoniana','Dryopteris clintoniana','Dryopteris clintonian',2,0,'','','D. C. Eaton|Dowell','0c4633ca-08eb-5089-8ec3-5793d25c3da3','Dryopteris clintoniana (D.C. Eaton) Dowell','(D.C. Eaton) Dowell','SPECIES','','Dryopteris','','clintoniana','','','',NULL,'Dowell','','','','','D. C. Eaton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5395','','','Dryopteris fragrans (Linnaeus) Schott',1,'Dryopteris fragrans','Dryopteris fragrans','Dryopteris fragrans',2,0,'','','Linnaeus|Schott','3f3d844e-02cd-5366-a8d8-7f6f34967ad0','Dryopteris fragrans (Linnaeus) Schott','(Linnaeus) Schott','SPECIES','','Dryopteris','','fragrans','','','',NULL,'Schott','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5399','','','Dryopteris intermedia × Dryopteris marginalis',2,'Dryopteris intermedia × Dryopteris marginalis','Dryopteris intermedia × Dryopteris marginalis','Dryopteris intermed × Dryopteris marginal',0,0,'HYBRID_FORMULA','','','2eea8c3c-60a4-58a5-a4f7-726d593a574b','Dryopteris intermedia × Dryopteris marginalis','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5401','','','Dryopteris ×algonquinensis D.M. Britton',3,'','','',NULL,NULL,'','','','','Dryopteris ×algonquinensis D.M. Britton','D.M. Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5407','','','Dryopteris ×mickelii Peck',3,'','','',NULL,NULL,'','','','','Dryopteris ×mickelii Peck','Peck','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28392','','','Dryopteris campyloptera × Dryopteris marginalis',2,'Dryopteris campyloptera × Dryopteris marginalis','Dryopteris campyloptera × Dryopteris marginalis','Dryopteris campylopter × Dryopteris marginal',0,0,'HYBRID_FORMULA','','','5f43b5dc-d5e1-5268-995c-f3ff0ce7894e','Dryopteris campyloptera × Dryopteris marginalis','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5424','','','Polystichum acrostichoides (Michaux) Schott',1,'Polystichum acrostichoides','Polystichum acrostichoides','Polystichum acrostichoid',2,0,'','','Michaux|Schott','e1ed3ce8-15c0-504a-84f1-27b886b97649','Polystichum acrostichoides (Michaux) Schott','(Michaux) Schott','SPECIES','','Polystichum','','acrostichoides','','','',NULL,'Schott','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5434','','','Polystichum munitum (Kaulfuss) C. Presl',1,'Polystichum munitum','Polystichum munitum','Polystichum munit',2,0,'','','Kaulfuss|C. Presl','8b60cf12-e754-5b2d-8d3a-a4dc29615e02','Polystichum munitum (Kaulfuss) C. Presl','(Kaulfuss) C. Presl','SPECIES','','Polystichum','','munitum','','','',NULL,'C. Presl','','','','','Kaulfuss','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5429','','','Polystichum imbricans (D.C. Eaton) D.H. Wagner',1,'Polystichum imbricans','Polystichum imbricans','Polystichum imbricans',2,0,'','','D. C. Eaton|D. H. Wagner','294bc889-6606-5876-b91c-bdc15922ad88','Polystichum imbricans (D.C. Eaton) D.H. Wagner','(D.C. Eaton) D.H. Wagner','SPECIES','','Polystichum','','imbricans','','','',NULL,'D. H. Wagner','','','','','D. C. Eaton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('21998','','','Matteuccia pensylvanica (Willdenow) Raymond',1,'Matteuccia pensylvanica','Matteuccia pensylvanica','Matteuccia pensyluanic',2,0,'','','Willdenow|Raymond','98803ee5-d900-5caa-a9b3-7510e2154c98','Matteuccia pensylvanica (Willdenow) Raymond','(Willdenow) Raymond','SPECIES','','Matteuccia','','pensylvanica','','','',NULL,'Raymond','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8237','','','Polypodium glycyrrhiza D.C. Eaton',1,'Polypodium glycyrrhiza','Polypodium glycyrrhiza','Polypodium glycyrrhiz',2,0,'','','D. C. Eaton','e72decbe-ac4a-5f00-8f79-75c9cf561a92','Polypodium glycyrrhiza D.C. Eaton','D.C. Eaton','SPECIES','','Polypodium','','glycyrrhiza','','','',NULL,'','','','','','D. C. Eaton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26143','','','Polypodium ×incognitum Cusick',3,'','','',NULL,NULL,'','','','','Polypodium ×incognitum Cusick','Cusick','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('203','','','Pteridaceae E.D.M. Kirchner',1,'Pteridaceae','Pteridaceae','Pteridaceae',1,0,'','','E. D. M. Kirchner','e83ed49f-5c65-5846-a1f5-00439b0d17dd','Pteridaceae E.D.M. Kirchner','E.D.M. Kirchner','FAMILY','Pteridaceae','','','','','','',NULL,'','','','','','E. D. M. Kirchner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8380','','','Adiantum aleuticum (Ruprecht) C.A. Paris',1,'Adiantum aleuticum','Adiantum aleuticum','Adiantum aleutic',2,0,'','','Ruprecht|C. A. Paris','64892317-39dc-54f2-ad9f-c81167f7ee4a','Adiantum aleuticum (Ruprecht) C.A. Paris','(Ruprecht) C.A. Paris','SPECIES','','Adiantum','','aleuticum','','','',NULL,'C. A. Paris','','','','','Ruprecht','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('287','','','Cheilanthoideae W.C. Schieh',1,'Cheilanthoideae','Cheilanthoideae','Cheilanthoideae',1,0,'','','W. C. Schieh','8862db0c-2d7b-517d-a162-b3b921d0b6e0','Cheilanthoideae W.C. Schieh','W.C. Schieh','SUBFAMILY','Cheilanthoideae','','','','','','',NULL,'','','','','','W. C. Schieh','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8392','','','Pellaea gastonyi Windham',1,'Pellaea gastonyi','Pellaea gastonyi','Pellaea gastony',2,0,'','','Windham','d9b717d2-ba41-58ba-b82c-9664e16b7584','Pellaea gastonyi Windham','Windham','SPECIES','','Pellaea','','gastonyi','','','',NULL,'','','','','','Windham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8394','','','Pellaea glabella Mettenius ex Kuhn',2,'Pellaea glabella','Pellaea glabella','Pellaea glabell',2,0,'','','Mettenius|Kuhn','8067b456-f1da-5853-991e-a5954811967e','Pellaea glabella Mettenius ex Kuhn','Mettenius ex Kuhn','SPECIES','','Pellaea','','glabella','','','',NULL,'','','','','','Mettenius','','Kuhn','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1519','','','Pentagramma Yatskievych, Windham & E. Wollenweber',1,'Pentagramma','Pentagramma','Pentagramma',1,0,'','','Yatskievych|Windham|E. Wollenweber','8c91889c-53aa-5613-ab7f-f4a7e16a7ad4','Pentagramma Yatskievych, Windham & E. Wollenweber','Yatskievych, Windham & E. Wollenweber','GENUS','Pentagramma','','','','','','',NULL,'','','','','','Yatskievych, Windham & E. Wollenweber','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('28388','','','Myriopteris gracilis Fée',1,'Myriopteris gracilis','Myriopteris gracilis','Myriopteris gracil',2,0,'','','Fée','a30db441-8e3f-5779-b9dc-dc230cee89ce','Myriopteris gracilis Fée','Fée','SPECIES','','Myriopteris','','gracilis','','','',NULL,'','','','','','Fée','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1055','','','Cryptogramma R. Brown',1,'Cryptogramma','Cryptogramma','Cryptogramma',1,0,'','','R. Brown','ac87c421-d179-55c7-a2cf-48b0093d229b','Cryptogramma R. Brown','R. Brown','GENUS','Cryptogramma','','','','','','',NULL,'','','','','','R. Brown','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('228','','','Thelypteridaceae Pichi Sermolli',1,'Thelypteridaceae','Thelypteridaceae','Thelypteridaceae',1,0,'','','Pichi Sermolli','399d9777-59f4-5a10-9c1a-d5492eeb1ab0','Thelypteridaceae Pichi Sermolli','Pichi Sermolli','FAMILY','Thelypteridaceae','','','','','','',NULL,'','','','','','Pichi Sermolli','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9403','','','Phegopteris hexagonoptera (Michaux) Fée',1,'Phegopteris hexagonoptera','Phegopteris hexagonoptera','Phegopteris hexagonopter',2,0,'','','Michaux|Fée','58c736dd-b3d7-5273-97d6-04928d6df138','Phegopteris hexagonoptera (Michaux) Fée','(Michaux) Fée','SPECIES','','Phegopteris','','hexagonoptera','','','',NULL,'Fée','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9407','','','Thelypteris palustris Schott',1,'Thelypteris palustris','Thelypteris palustris','Thelypteris palustr',2,0,'','','Schott','85bd48a9-02ac-53ba-99e8-caad96614286','Thelypteris palustris Schott','Schott','SPECIES','','Thelypteris','','palustris','','','',NULL,'','','','','','Schott','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32927','','','Amauropelta Kunze',1,'Amauropelta','Amauropelta','Amauropelta',1,0,'','','Kunze','d89177c2-cd26-5185-95e0-5385b5e2e150','Amauropelta Kunze','Kunze','GENUS','Amauropelta','','','','','','',NULL,'','','','','','Kunze','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('32930','','','Amauropelta noveboracensis (Linnaeus) S.E. Fawcett & A.R. Smith',1,'Amauropelta noveboracensis','Amauropelta noveboracensis','Amauropelta noueboracens',2,0,'','','Linnaeus|S. E. Fawcett|A. R. Smith','d3bc8c44-0977-57c7-9f9c-6cbb7dbdded5','Amauropelta noveboracensis (Linnaeus) S.E. Fawcett & A.R. Smith','(Linnaeus) S.E. Fawcett & A.R. Smith','SPECIES','','Amauropelta','','noveboracensis','','','',NULL,'S. E. Fawcett & A. R. Smith','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5443','','','Woodsia obtusa (Sprengel) Torrey',1,'Woodsia obtusa','Woodsia obtusa','Woodsia obtus',2,0,'','','Sprengel|Torrey','c3804cf6-1529-5ba9-b067-0e2bfba4bc5f','Woodsia obtusa (Sprengel) Torrey','(Sprengel) Torrey','SPECIES','','Woodsia','','obtusa','','','',NULL,'Torrey','','','','','Sprengel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5447','','','Woodsia scopulina subsp. laurentiana Windham',1,'Woodsia scopulina laurentiana','Woodsia scopulina subsp. laurentiana','Woodsia scopulin laurentian',3,0,'','','Windham','f85077c5-1bd5-5dc5-98b6-69c7de2a6b52','Woodsia scopulina subsp. laurentiana Windham','Windham','SUBSPECIES','','Woodsia','','scopulina','laurentiana','','',NULL,'','','','','','Windham','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1071','','','Cystopteris Bernhardi',1,'Cystopteris','Cystopteris','Cystopteris',1,0,'','','Bernhardi','fe77f0bd-b583-572d-ab67-44e9c6312961','Cystopteris Bernhardi','Bernhardi','GENUS','Cystopteris','','','','','','',NULL,'','','','','','Bernhardi','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5377','','','Cystopteris laurentiana (Weatherby) Blasdell',1,'Cystopteris laurentiana','Cystopteris laurentiana','Cystopteris laurentian',2,0,'','','Weatherby|Blasdell','4c0e5d8c-e1ec-5b20-8a01-f5ae9cab0aac','Cystopteris laurentiana (Weatherby) Blasdell','(Weatherby) Blasdell','SPECIES','','Cystopteris','','laurentiana','','','',NULL,'Blasdell','','','','','Weatherby','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5417','','','Gymnocarpium robertianum (Hoffmann) Newman',1,'Gymnocarpium robertianum','Gymnocarpium robertianum','Gymnocarpium robertian',2,0,'','','Hoffmann|Newman','5d163cc9-151d-5202-9a88-cebbf62eb9b7','Gymnocarpium robertianum (Hoffmann) Newman','(Hoffmann) Newman','SPECIES','','Gymnocarpium','','robertianum','','','',NULL,'Newman','','','','','Hoffmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('22017','','','Athyrium angustum (Willdenow) C. Presl',1,'Athyrium angustum','Athyrium angustum','Athyrium angust',2,0,'','','Willdenow|C. Presl','8188992f-1a5e-55ba-92bd-520c46a8a6d8','Athyrium angustum (Willdenow) C. Presl','(Willdenow) C. Presl','SPECIES','','Athyrium','','angustum','','','',NULL,'C. Presl','','','','','Willdenow','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('34090','','','Pseudathyrium Newman',1,'Pseudathyrium','Pseudathyrium','Pseudathyrium',1,0,'','','Newman','0fc4071a-c356-55d7-9f28-831e1c277f1b','Pseudathyrium Newman','Newman','GENUS','Pseudathyrium','','','','','','',NULL,'','','','','','Newman','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('26954','','','Homalosorus pycnocarpos (Sprengel) Pichi Sermolli',1,'Homalosorus pycnocarpos','Homalosorus pycnocarpos','Homalosorus pycnocarp',2,0,'','','Sprengel|Pichi Sermolli','79646de3-ba9d-5d9d-93b3-d5b3242a856a','Homalosorus pycnocarpos (Sprengel) Pichi Sermolli','(Sprengel) Pichi Sermolli','SPECIES','','Homalosorus','','pycnocarpos','','','',NULL,'Pichi Sermolli','','','','','Sprengel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6647','','','Marsilea vestita Hooker & Greville',1,'Marsilea vestita','Marsilea vestita','Marsilea uestit',2,0,'','','Hooker|Greville','ab132a0a-27be-5752-a13a-a8675f5ab52c','Marsilea vestita Hooker & Greville','Hooker & Greville','SPECIES','','Marsilea','','vestita','','','',NULL,'','','','','','Hooker & Greville','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('68','','','Schizaeales Schimper',1,'Schizaeales','Schizaeales','Schizaeales',1,0,'','','Schimper','a2a8d181-c397-5318-b73b-1cf4f20a1f1e','Schizaeales Schimper','Schimper','ORDER','Schizaeales','','','','','','',NULL,'','','','','','Schimper','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('218','','','Schizaeaceae Kaulfuss',1,'Schizaeaceae','Schizaeaceae','Schizaeaceae',1,0,'','','Kaulfuss','33ba7851-a9cd-5b50-84fa-1ce20def94e0','Schizaeaceae Kaulfuss','Kaulfuss','FAMILY','Schizaeaceae','','','','','','',NULL,'','','','','','Kaulfuss','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('77','','','Adoxaceae E. Meyer',1,'Adoxaceae','Adoxaceae','Adoxaceae',1,0,'','','E. Meyer','0dbbdf16-39db-560a-aa97-b225572ed5c1','Adoxaceae E. Meyer','E. Meyer','FAMILY','Adoxaceae','','','','','','',NULL,'','','','','','E. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('421','','','Eritrichieae Gürke',1,'Eritrichieae','Eritrichieae','Eritrichieae',1,0,'','','Gürke','098913d8-95ea-587f-a71d-90dde192f9e2','Eritrichieae Gürke','Gürke','TRIBE','Eritrichieae','','','','','','',NULL,'','','','','','Gürke','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('773','','','Aconogonon (Meisner) Reichenbach',2,'Aconogonon','Aconogonon','Aconogonon',1,0,'','','Meisner|Reichenbach','18b8af93-f21d-51f4-875d-6f69344efb29','Aconogonon (Meisner) Reichenbach','(Meisner) Reichenbach','GENUS','Aconogonon','','','','','','',NULL,'Reichenbach','','','','','Meisner','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1325','','','Lens Miller',1,'Lens','Lens','Lens',1,0,'','','Miller','70e8df44-297f-5fea-b506-eabb2b3474c0','Lens Miller','Miller','GENUS','Lens','','','','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1962','','','Lamiastrum Linnaeus',1,'Lamiastrum','Lamiastrum','Lamiastrum',1,0,'','','Linnaeus','0bde4a82-a70a-54fe-b16e-4e46edc6322e','Lamiastrum Linnaeus','Linnaeus','GENUS','Lamiastrum','','','','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2345','','','Solidago subsect. Thyrsiflorae (A. Gray) A. Gray',2,'Thyrsiflorae','Solidago subsect. Thyrsiflorae','Thyrsiflorae',1,0,'','','A. Gray','2a57e642-35b2-5ab0-94a8-ae87c07d68e7','Solidago subsect. Thyrsiflorae (A. Gray) A. Gray','(A. Gray) A. Gray','SUBSECTION','Thyrsiflorae','','','','','','',NULL,'A. Gray','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2450','','','Viburnum opulus Linnaeus subsp. opulus',1,'Viburnum opulus opulus','Viburnum opulus subsp. opulus','Viburnum opul opul',3,0,'','','','d0a2088e-2c02-5ae6-bda8-0e69ac9addff','Viburnum opulus Linnaeus subsp. opulus','Linnaeus','SUBSPECIES','','Viburnum','','opulus','opulus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2522','','','Rhus ×pulvinata Greene',3,'','','',NULL,NULL,'','','','','Rhus ×pulvinata Greene','Greene','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2552','','','Chaerophyllum procumbens (Linnaeus) Crantz var. procumbens',1,'Chaerophyllum procumbens procumbens','Chaerophyllum procumbens var. procumbens','Chaerophyllum procumbens procumbens',3,0,'','','','90aa33fe-2ead-52aa-9e9a-a41ef82d3f1f','Chaerophyllum procumbens (Linnaeus) Crantz var. procumbens','(Linnaeus) Crantz','VARIETY','','Chaerophyllum','','procumbens','procumbens','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2600','','','Lomatium dissectum (Nuttall) Mathias & Constance var. dissectum',1,'Lomatium dissectum dissectum','Lomatium dissectum var. dissectum','Lomatium dissect dissect',3,0,'','','','30d1f21b-c7a4-5472-92c8-fd5a0b02ee28','Lomatium dissectum (Nuttall) Mathias & Constance var. dissectum','(Nuttall) Mathias & Constance','VARIETY','','Lomatium','','dissectum','dissectum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2660','','','Apocynum androsaemifolium subsp. pumilum (A. Gray) B. Boivin',1,'Apocynum androsaemifolium pumilum','Apocynum androsaemifolium subsp. pumilum','Apocynum androsaemifoli pumil',3,0,'','','A. Gray|B. Boivin','34c12b23-2509-5223-aecc-3a0038bd5cb8','Apocynum androsaemifolium subsp. pumilum (A. Gray) B. Boivin','(A. Gray) B. Boivin','SUBSPECIES','','Apocynum','','androsaemifolium','pumilum','','',NULL,'B. Boivin','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2680','','','Pinellia ternata (Thunberg) Tenore ex Breitenberg nom. inval.',4,'','','',NULL,NULL,'','','','','Pinellia ternata (Thunberg) Tenore ex Breitenberg nom. inval.','(Thunberg) Tenore ex Breitenberg nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2737','','','Maianthemum racemosum subsp. amplexicaule (Nuttall) LaFrankie',1,'Maianthemum racemosum amplexicaule','Maianthemum racemosum subsp. amplexicaule','Maianthemum racemos amplexicaul',3,0,'','','Nuttall|La Frankie','51917a71-ba97-59fd-8956-389d79d50362','Maianthemum racemosum subsp. amplexicaule (Nuttall) LaFrankie','(Nuttall) LaFrankie','SUBSPECIES','','Maianthemum','','racemosum','amplexicaule','','',NULL,'La Frankie','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2765','','','Achillea millefolium var. lanulosa (Nuttall) Piper',1,'Achillea millefolium lanulosa','Achillea millefolium var. lanulosa','Achillea millefoli lanulos',3,0,'','','Nuttall|Piper','9606607d-e5b6-5589-93cf-8634052bfcbe','Achillea millefolium var. lanulosa (Nuttall) Piper','(Nuttall) Piper','VARIETY','','Achillea','','millefolium','lanulosa','','',NULL,'Piper','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2886','','','Artemisia campestris subsp. scouleriana (Besser) L.M.  Shultz',1,'Artemisia campestris scouleriana','Artemisia campestris subsp. scouleriana','Artemisia campestr scoulerian',3,0,'','','Besser|L. M. Shultz','f44f1d19-0a1e-52e6-9e07-7817f5fe7032','Artemisia campestris subsp. scouleriana (Besser) L.M.  Shultz','(Besser) L.M.  Shultz','SUBSPECIES','','Artemisia','','campestris','scouleriana','','',NULL,'L. M. Shultz','','','','','Besser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('2975','','','Centaurea ×moncktonii C.E. Britton',3,'','','',NULL,NULL,'','','','','Centaurea ×moncktonii C.E. Britton','C.E. Britton','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3126','','','Erigeron strigosus var. septentrionalis (Fernald & Wiegand) Fernald',1,'Erigeron strigosus septentrionalis','Erigeron strigosus var. septentrionalis','Erigeron strigos septentrional',3,0,'','','Fernald|Wiegand','0c0fe52f-0ef8-532e-979a-db221c71ac9d','Erigeron strigosus var. septentrionalis (Fernald & Wiegand) Fernald','(Fernald & Wiegand) Fernald','VARIETY','','Erigeron','','strigosus','septentrionalis','','',NULL,'Fernald','','','','','Fernald & Wiegand','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3231','','','Pilosella praealta (Villars ex Gochnat) F.W. Schultz & Schultz Bipontinus',2,'Pilosella praealta','Pilosella praealta','Pilosella praealt',2,0,'','','Villars|Gochnat|F. W. Schultz|Schultz Bipontinus','ac4a9823-55af-599d-b9d3-262f88d7b11e','Pilosella praealta (Villars ex Gochnat) F.W. Schultz & Schultz Bipontinus','(Villars ex Gochnat) F.W. Schultz & Schultz Bipontinus','SPECIES','','Pilosella','','praealta','','','',NULL,'F. W. Schultz & Schultz Bipontinus','','','','','Villars','','Gochnat','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3340','','','Packera streptanthifolia var. borealis (Torrey & A. Gray) Trock',1,'Packera streptanthifolia borealis','Packera streptanthifolia var. borealis','Packera streptanthifol boreal',3,0,'','','Torrey|A. Gray|Trock','06db232b-79d4-505d-8be5-8ef5457ad606','Packera streptanthifolia var. borealis (Torrey & A. Gray) Trock','(Torrey & A. Gray) Trock','VARIETY','','Packera','','streptanthifolia','borealis','','',NULL,'Trock','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3436','','','Solidago altissima Linnaeus subsp. altissima',1,'Solidago altissima altissima','Solidago altissima subsp. altissima','Solidago altissim altissim',3,0,'','','','9bc0c477-6ad1-5f2b-93d4-c8bcf76bda1c','Solidago altissima Linnaeus subsp. altissima','Linnaeus','SUBSPECIES','','Solidago','','altissima','altissima','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3465','','','Solidago nemoralis Aiton subsp. nemoralis',1,'Solidago nemoralis nemoralis','Solidago nemoralis subsp. nemoralis','Solidago nemoral nemoral',3,0,'','','','0bbe4e05-8f41-502b-830a-3d0c28521600','Solidago nemoralis Aiton subsp. nemoralis','Aiton','SUBSPECIES','','Solidago','','nemoralis','nemoralis','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3473','','','Solidago puberula Nuttall subsp. puberula',1,'Solidago puberula puberula','Solidago puberula subsp. puberula','Solidago puberul puberul',3,0,'','','','764e64f1-a1a6-5534-b485-9ee96e8957c6','Solidago puberula Nuttall subsp. puberula','Nuttall','SUBSPECIES','','Solidago','','puberula','puberula','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3489','','','Solidago simplex var. monticola (Porter) G.S. Ringius',1,'Solidago simplex monticola','Solidago simplex var. monticola','Solidago simplex monticol',3,0,'','','Porter|G. S. Ringius','182b5de6-fa03-58a0-9eaa-623f0760ea2c','Solidago simplex var. monticola (Porter) G.S. Ringius','(Porter) G.S. Ringius','VARIETY','','Solidago','','simplex','monticola','','',NULL,'G. S. Ringius','','','','','Porter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3490','','','Solidago simplex subsp. randii var. ontarioensis (G.S. Ringius) G.S. Ringius',1,'Solidago simplex randii ontarioensis','Solidago simplex subsp. randii var. ontarioensis','Solidago simplex rand ontarioens',4,0,'','','G. S. Ringius','bbf2e53d-f751-5547-bb43-314a606a735b','Solidago simplex subsp. randii var. ontarioensis (G.S. Ringius) G.S. Ringius','(G.S. Ringius) G.S. Ringius','VARIETY','','','','','','','',NULL,'G. S. Ringius','','','','','G. S. Ringius','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3495','','','Solidago simplex auct. non Kunth var. simplex',4,'','','',NULL,NULL,'','','','','Solidago simplex auct. non Kunth var. simplex','auct. non Kunth','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3524','','','Symphyotrichum eatonii (A. Gray) G.L. Nesom',1,'Symphyotrichum eatonii','Symphyotrichum eatonii','Symphyotrichum eaton',2,0,'','','A. Gray|G. L. Nesom','02e761f8-aa5e-5721-b53a-073bb9cec8d2','Symphyotrichum eatonii (A. Gray) G.L. Nesom','(A. Gray) G.L. Nesom','SPECIES','','Symphyotrichum','','eatonii','','','',NULL,'G. L. Nesom','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3683','','','Alnus viridis subsp. fruticosa (Ruprecht) Nyman',1,'Alnus viridis fruticosa','Alnus viridis subsp. fruticosa','Alnus uirid fruticos',3,0,'','','Ruprecht|Nyman','2b6bcc1e-c17e-59d8-9362-92691b510b42','Alnus viridis subsp. fruticosa (Ruprecht) Nyman','(Ruprecht) Nyman','SUBSPECIES','','Alnus','','viridis','fruticosa','','',NULL,'Nyman','','','','','Ruprecht','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3695','','','Betula neoalaskana Sargent',1,'Betula neoalaskana','Betula neoalaskana','Betula neoalaskan',2,0,'','','Sargent','d897858d-3d12-5bc7-bc52-bbf5e5fe26c6','Betula neoalaskana Sargent','Sargent','SPECIES','','Betula','','neoalaskana','','','',NULL,'','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3733','','','Blechnum spicant (Linnaeus) Smith nom. inval.',4,'','','',NULL,NULL,'','','','','Blechnum spicant (Linnaeus) Smith nom. inval.','(Linnaeus) Smith nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3757','','','Cryptantha nubigena (Greene) Payson',1,'Cryptantha nubigena','Cryptantha nubigena','Cryptantha nubigen',2,0,'','','Greene|Payson','9f1b98c4-04e8-5417-8d4f-9b2460a1d677','Cryptantha nubigena (Greene) Payson','(Greene) Payson','SPECIES','','Cryptantha','','nubigena','','','',NULL,'Payson','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3815','','','Onosmodium bejariense var. occidentale (Mackenzie) B.L. Turner',1,'Onosmodium bejariense occidentale','Onosmodium bejariense var. occidentale','Onosmodium beiariens occidental',3,0,'','','Mackenzie|B. L. Turner','a4a86c80-b2e8-53ce-bb4d-f4994b3abe18','Onosmodium bejariense var. occidentale (Mackenzie) B.L. Turner','(Mackenzie) B.L. Turner','VARIETY','','Onosmodium','','bejariense','occidentale','','',NULL,'B. L. Turner','','','','','Mackenzie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3871','','','Botrychium oneidense (Gilbert) House',1,'Botrychium oneidense','Botrychium oneidense','Botrychium oneidens',2,0,'','','Gilbert|House','9538b0b7-51ad-55a6-af7a-cb1e11b3e1b5','Botrychium oneidense (Gilbert) House','(Gilbert) House','SPECIES','','Botrychium','','oneidense','','','',NULL,'House','','','','','Gilbert','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3897','','','Arabis pycnocarpa M. Hopkins var. pycnocarpa',1,'Arabis pycnocarpa pycnocarpa','Arabis pycnocarpa var. pycnocarpa','Arabis pycnocarp pycnocarp',3,0,'','','','312c9306-dc98-5c5b-b407-205cfafa072b','Arabis pycnocarpa M. Hopkins var. pycnocarpa','M. Hopkins','VARIETY','','Arabis','','pycnocarpa','pycnocarpa','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('3975','','','Conringia orientalis (Linnaeus) Dumortier nom. illeg.',4,'','','',NULL,NULL,'','','','','Conringia orientalis (Linnaeus) Dumortier nom. illeg.','(Linnaeus) Dumortier nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4045','','','Erysimum hieraciifolium auct. non Linnaeus',4,'','','',NULL,NULL,'','','','','Erysimum hieraciifolium auct. non Linnaeus','auct. non Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4051','','','Transberingia bursifolia (de Candolle) Al-Shehbaz & O''Kane',1,'Transberingia bursifolia','Transberingia bursifolia','Transberingia bursifol',2,0,'','','de Candolle|Al-Shehbaz|O''Kane','648d72dd-61bf-5585-8f5e-664d4c89a986','Transberingia bursifolia (de Candolle) Al-Shehbaz & O''Kane','(de Candolle) Al-Shehbaz & O''Kane','SPECIES','','Transberingia','','bursifolia','','','',NULL,'Al-Shehbaz & O''Kane','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4119','','','Sinapis arvensis Linnaeus',1,'Sinapis arvensis','Sinapis arvensis','Sinapis aruens',2,0,'','','Linnaeus','00468ff5-652d-502b-a5ec-67741ccc02d7','Sinapis arvensis Linnaeus','Linnaeus','SPECIES','','Sinapis','','arvensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4189','','','Triodanis perfoliata (Linnaeus) Nieuwland subsp. perfoliata',1,'Triodanis perfoliata perfoliata','Triodanis perfoliata subsp. perfoliata','Triodanis perfoliat perfoliat',3,0,'','','','39c3db82-43d3-5036-895b-53bffb60e0d5','Triodanis perfoliata (Linnaeus) Nieuwland subsp. perfoliata','(Linnaeus) Nieuwland','SUBSPECIES','','Triodanis','','perfoliata','perfoliata','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4295','','','Eremogone capillaris subsp. americana (Maguire) R.L. Hartman & Rabeler',1,'Eremogone capillaris americana','Eremogone capillaris subsp. americana','Eremogone capillar american',3,0,'','','Maguire|R. L. Hartman|Rabeler','77e197bf-cc63-53d7-8cca-8c4dd130b81e','Eremogone capillaris subsp. americana (Maguire) R.L. Hartman & Rabeler','(Maguire) R.L. Hartman & Rabeler','SUBSPECIES','','Eremogone','','capillaris','americana','','',NULL,'R. L. Hartman & Rabeler','','','','','Maguire','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4313','','','Minuartia arctica (Steven ex Seringe) Graebner',2,'Minuartia arctica','Minuartia arctica','Minuartia arctic',2,0,'','','Steven|Seringe|Graebner','53284104-1b57-5ef2-9f06-1ade39473119','Minuartia arctica (Steven ex Seringe) Graebner','(Steven ex Seringe) Graebner','SPECIES','','Minuartia','','arctica','','','',NULL,'Graebner','','','','','Steven','','Seringe','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4319','','','Minuartia litorea (Fernald) House',1,'Minuartia litorea','Minuartia litorea','Minuartia litore',2,0,'','','Fernald|House','da54ee26-5c23-58d2-b57f-f41cbc5d742e','Minuartia litorea (Fernald) House','(Fernald) House','SPECIES','','Minuartia','','litorea','','','',NULL,'House','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4323','','','Minuartia nuttallii (Pax) Briquet subsp. nuttallii',1,'Minuartia nuttallii nuttallii','Minuartia nuttallii subsp. nuttallii','Minuartia nuttall nuttall',3,0,'','','','982abe9e-0adc-5458-898d-41dfb4eb1dc7','Minuartia nuttallii (Pax) Briquet subsp. nuttallii','(Pax) Briquet','SUBSPECIES','','Minuartia','','nuttallii','nuttallii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4328','','','Minuartia rubella (Wahlenberg) Hiern',1,'Minuartia rubella','Minuartia rubella','Minuartia rubell',2,0,'','','Wahlenberg|Hiern','87d4af48-0bd6-56da-82d7-651e88f7f45e','Minuartia rubella (Wahlenberg) Hiern','(Wahlenberg) Hiern','SPECIES','','Minuartia','','rubella','','','',NULL,'Hiern','','','','','Wahlenberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4331','','','Minuartia yukonensis Hultén',1,'Minuartia yukonensis','Minuartia yukonensis','Minuartia yukonens',2,0,'','','Hultén','f78dd9c6-4652-5aae-bbe6-1b852ef61c02','Minuartia yukonensis Hultén','Hultén','SPECIES','','Minuartia','','yukonensis','','','',NULL,'','','','','','Hultén','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4446','','','Vaccaria hispanica (Miller) Rauschert',1,'Vaccaria hispanica','Vaccaria hispanica','Vaccaria hispanic',2,0,'','','Miller|Rauschert','26f680ca-ca8c-5a2c-817c-2c8ea8e43994','Vaccaria hispanica (Miller) Rauschert','(Miller) Rauschert','SPECIES','','Vaccaria','','hispanica','','','',NULL,'Rauschert','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4502','','','Chenopodium chenopodioides (Linnaeus) Aellen',1,'Chenopodium chenopodioides','Chenopodium chenopodioides','Chenopodium chenopodioid',2,0,'','','Linnaeus|Aellen','58538703-f050-561a-9611-54c1cff53686','Chenopodium chenopodioides (Linnaeus) Aellen','(Linnaeus) Aellen','SPECIES','','Chenopodium','','chenopodioides','','','',NULL,'Aellen','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4511','','','Chenopodium glaucum subsp. salinum (Standley) Aellen',1,'Chenopodium glaucum salinum','Chenopodium glaucum subsp. salinum','Chenopodium glauc salin',3,0,'','','Standley|Aellen','a653bd6f-2ef3-5c34-84ea-8ff88c595cb5','Chenopodium glaucum subsp. salinum (Standley) Aellen','(Standley) Aellen','SUBSPECIES','','Chenopodium','','glaucum','salinum','','',NULL,'Aellen','','','','','Standley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4520','','','Chenopodium polyspermum Linnaeus',1,'Chenopodium polyspermum','Chenopodium polyspermum','Chenopodium polysperm',2,0,'','','Linnaeus','c708e19c-46f5-5b73-8262-4ce3288c47e3','Chenopodium polyspermum Linnaeus','Linnaeus','SPECIES','','Chenopodium','','polyspermum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4527','','','Chenopodium simplex (Torrey) Rafinesque',1,'Chenopodium simplex','Chenopodium simplex','Chenopodium simplex',2,0,'','','Torrey|Rafinesque','644c76ba-f6e0-5788-8138-537c382c2350','Chenopodium simplex (Torrey) Rafinesque','(Torrey) Rafinesque','SPECIES','','Chenopodium','','simplex','','','',NULL,'Rafinesque','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4562','','','Salsola kali Linnaeus',1,'Salsola kali','Salsola kali','Salsola kal',2,0,'','','Linnaeus','113e2161-e1e4-58a8-9116-a3c85a34b85c','Salsola kali Linnaeus','Linnaeus','SPECIES','','Salsola','','kali','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4565','','','Sarcocornia perennis (Miller) A.J. Scott',1,'Sarcocornia perennis','Sarcocornia perennis','Sarcocornia perenn',2,0,'','','Miller|A. J. Scott','422034ca-d101-5a7e-b570-5131805575ba','Sarcocornia perennis (Miller) A.J. Scott','(Miller) A.J. Scott','SPECIES','','Sarcocornia','','perennis','','','',NULL,'A. J. Scott','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4622','','','Cuscuta compacta Jussieu ex Choisy var. compacta',2,'Cuscuta compacta compacta','Cuscuta compacta var. compacta','Cuscuta compact compact',3,0,'','','','2a885566-4336-53c8-bab8-3b28a5d0fd76','Cuscuta compacta Jussieu ex Choisy var. compacta','Jussieu ex Choisy','VARIETY','','Cuscuta','','compacta','compacta','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4667','','','Sedum hybridum Linnaeus',1,'Sedum hybridum','Sedum hybridum','Sedum hybrid',2,0,'','','Linnaeus','43bb2662-235d-5a7e-84d0-3191fa16acd2','Sedum hybridum Linnaeus','Linnaeus','SPECIES','','Sedum','','hybridum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4746','','','Carex aquatilis var. dives × Carex lenticularis var. lipocarpa',2,'Carex aquatilis dives × Carex lenticularis lipocarpa','Carex aquatilis var. dives × Carex lenticularis var. lipocarpa','Carex aquatil diu × Carex lenticular lipocarp',0,0,'HYBRID_FORMULA','','','014141e9-e647-5aac-b1c7-fe6e4de4c0d8','Carex aquatilis var. dives × Carex lenticularis var. lipocarpa','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4790','','','Carex canescens var. brunnescens (Persoon) W.D.J. Koch',1,'Carex canescens brunnescens','Carex canescens var. brunnescens','Carex canescens brunnescens',3,0,'','','Persoon|W. D. J. Koch','8e22952c-c18d-5acd-8fa9-d6055f9a3e9e','Carex canescens var. brunnescens (Persoon) W.D.J. Koch','(Persoon) W.D.J. Koch','VARIETY','','Carex','','canescens','brunnescens','','',NULL,'W. D. J. Koch','','','','','Persoon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4944','','','Carex lenticularis var. limnophila (Holm) Cronquist',1,'Carex lenticularis limnophila','Carex lenticularis var. limnophila','Carex lenticular limnophil',3,0,'','','Holm|Cronquist','99c092ae-826b-5d51-85ad-2dff61c377dd','Carex lenticularis var. limnophila (Holm) Cronquist','(Holm) Cronquist','VARIETY','','Carex','','lenticularis','limnophila','','',NULL,'Cronquist','','','','','Holm','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('4986','','','Carex microglochin Wahlenberg subsp. microglochin',1,'Carex microglochin microglochin','Carex microglochin subsp. microglochin','Carex microglochin microglochin',3,0,'','','','b504824b-e0a7-59cf-9ff9-3ea1d08fdbc5','Carex microglochin Wahlenberg subsp. microglochin','Wahlenberg','SUBSPECIES','','Carex','','microglochin','microglochin','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5049','','','Carex rariflora (Wahlenberg) Smith var. rariflora',1,'Carex rariflora rariflora','Carex rariflora var. rariflora','Carex rariflor rariflor',3,0,'','','','f2b66c95-0fff-517c-a442-f098a61f55e8','Carex rariflora (Wahlenberg) Smith var. rariflora','(Wahlenberg) Smith','VARIETY','','Carex','','rariflora','rariflora','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5295','','','Kobresia myosuroides (Villars) Fiori',1,'Kobresia myosuroides','Kobresia myosuroides','Kobresia myosuroid',2,0,'','','Villars|Fiori','9ee44490-bc43-565e-adcb-ce78f8b3bffe','Kobresia myosuroides (Villars) Fiori','(Villars) Fiori','SPECIES','','Kobresia','','myosuroides','','','',NULL,'Fiori','','','','','Villars','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5309','','','Schoenoplectus mucronatus (Linnaeus) Palla',1,'Schoenoplectus mucronatus','Schoenoplectus mucronatus','Schoenoplectus mucronat',2,0,'','','Linnaeus|Palla','dfd477b8-ac98-5029-bf07-1ab96f1294c9','Schoenoplectus mucronatus (Linnaeus) Palla','(Linnaeus) Palla','SPECIES','','Schoenoplectus','','mucronatus','','','',NULL,'Palla','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5315','','','Schoenoplectus purshianus (Fernald) M.T. Strong',1,'Schoenoplectus purshianus','Schoenoplectus purshianus','Schoenoplectus purshian',2,0,'','','Fernald|M. T. Strong','4aeff3d9-90ff-5a24-9809-8fabc56f0351','Schoenoplectus purshianus (Fernald) M.T. Strong','(Fernald) M.T. Strong','SPECIES','','Schoenoplectus','','purshianus','','','',NULL,'M. T. Strong','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5350','','','Pteridium aquilinum var. pubescens Underwood',1,'Pteridium aquilinum pubescens','Pteridium aquilinum var. pubescens','Pteridium aquilin pubescens',3,0,'','','Underwood','959229ef-e372-50b7-9cfd-eec06c836090','Pteridium aquilinum var. pubescens Underwood','Underwood','VARIETY','','Pteridium','','aquilinum','pubescens','','',NULL,'','','','','','Underwood','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5415','','','Gymnocarpium jessoense subsp. parvulum Sarvela',1,'Gymnocarpium jessoense parvulum','Gymnocarpium jessoense subsp. parvulum','Gymnocarpium iessoens paruul',3,0,'','','Sarvela','8dc454c2-cbce-5c3f-9729-9acd44e03095','Gymnocarpium jessoense subsp. parvulum Sarvela','Sarvela','SUBSPECIES','','Gymnocarpium','','jessoense','parvulum','','',NULL,'','','','','','Sarvela','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5479','','','Equisetum variegatum Schleicher ex F. Weber & D. Mohr subsp. variegatum',2,'Equisetum variegatum variegatum','Equisetum variegatum subsp. variegatum','Equisetum uariegat uariegat',3,0,'','','','908a500b-4576-5fde-9c62-fcf6a051c410','Equisetum variegatum Schleicher ex F. Weber & D. Mohr subsp. variegatum','Schleicher ex F. Weber & D. Mohr','SUBSPECIES','','Equisetum','','variegatum','variegatum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5681','','','Astragalus aboriginorum var. richardsonii (E. Sheldon) B. Boivin',1,'Astragalus aboriginorum richardsonii','Astragalus aboriginorum var. richardsonii','Astragalus aboriginor richardson',3,0,'','','E. Sheldon|B. Boivin','6b55bc9e-23d8-5fd6-aa7c-abfd5a08d844','Astragalus aboriginorum var. richardsonii (E. Sheldon) B. Boivin','(E. Sheldon) B. Boivin','VARIETY','','Astragalus','','aboriginorum','richardsonii','','',NULL,'B. Boivin','','','','','E. Sheldon','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5735','','','Halimodendron halodendron (Pallas) Druce',1,'Halimodendron halodendron','Halimodendron halodendron','Halimodendron halodendron',2,0,'','','Pallas|Druce','95641e95-97c4-5e3b-b50b-8e1e2834ce91','Halimodendron halodendron (Pallas) Druce','(Pallas) Druce','SPECIES','','Halimodendron','','halodendron','','','',NULL,'Druce','','','','','Pallas','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5750','','','Lathyrus nevadensis subsp. lanceolatus (Howell) C.L. Hitchcock',1,'Lathyrus nevadensis lanceolatus','Lathyrus nevadensis subsp. lanceolatus','Lathyrus neuadens lanceolat',3,0,'','','Howell|C. L. Hitchcock','928b9807-f8ef-5cf4-8810-2aacde2e6dd3','Lathyrus nevadensis subsp. lanceolatus (Howell) C.L. Hitchcock','(Howell) C.L. Hitchcock','SUBSPECIES','','Lathyrus','','nevadensis','lanceolatus','','',NULL,'C. L. Hitchcock','','','','','Howell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5764','','','Lespedeza juncea var. sericea F.B. Forbes & Hemsley',1,'Lespedeza juncea sericea','Lespedeza juncea var. sericea','Lespedeza iunce serice',3,0,'','','F. B. Forbes|Hemsley','8b7ff6e3-62d4-57d6-97fd-b6e0ae2440a4','Lespedeza juncea var. sericea F.B. Forbes & Hemsley','F.B. Forbes & Hemsley','VARIETY','','Lespedeza','','juncea','sericea','','',NULL,'','','','','','F. B. Forbes & Hemsley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5791','','','Lupinus arbustus subsp. pseudoparviflorus (Rydberg) D.B. Dunn',1,'Lupinus arbustus pseudoparviflorus','Lupinus arbustus subsp. pseudoparviflorus','Lupinus arbust pseudoparuiflor',3,0,'','','Rydberg|D. B. Dunn','69f3427c-2e52-564b-8012-9c448a150838','Lupinus arbustus subsp. pseudoparviflorus (Rydberg) D.B. Dunn','(Rydberg) D.B. Dunn','SUBSPECIES','','Lupinus','','arbustus','pseudoparviflorus','','',NULL,'D. B. Dunn','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5797','','','Lupinus argenteus subsp. argenteus var. laxiflorus (Douglas ex Lindley) Dorn',2,'Lupinus argenteus argenteus laxiflorus','Lupinus argenteus subsp. argenteus var. laxiflorus','Lupinus argente argente laxiflor',4,0,'','','Douglas|Lindley|Dorn','ea818d3f-fcc2-52f6-bf57-07167c17e5ff','Lupinus argenteus subsp. argenteus var. laxiflorus (Douglas ex Lindley) Dorn','(Douglas ex Lindley) Dorn','VARIETY','','','','','','','',NULL,'Dorn','','','','','Douglas','','Lindley','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5820','','','Lupinus pusillus Pursh subsp. pusillus',1,'Lupinus pusillus pusillus','Lupinus pusillus subsp. pusillus','Lupinus pusill pusill',3,0,'','','','49f7f076-fee7-5d7c-9b5b-a034b4e7a0e7','Lupinus pusillus Pursh subsp. pusillus','Pursh','SUBSPECIES','','Lupinus','','pusillus','pusillus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5841','','','Melilotus officinalis (Linnaeus) Pallas nom. inval.',4,'','','',NULL,NULL,'','','','','Melilotus officinalis (Linnaeus) Pallas nom. inval.','(Linnaeus) Pallas nom. inval.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5849','','','Oxytropis bellii (Britton) Palibin',1,'Oxytropis bellii','Oxytropis bellii','Oxytropis bell',2,0,'','','Britton|Palibin','d3604161-a48f-5491-97ff-5c5acaad5f29','Oxytropis bellii (Britton) Palibin','(Britton) Palibin','SPECIES','','Oxytropis','','bellii','','','',NULL,'Palibin','','','','','Britton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5919','','','Trifolium fragiferum subsp. bonannii (C. Presl) Soják',1,'Trifolium fragiferum bonannii','Trifolium fragiferum subsp. bonannii','Trifolium fragifer bonann',3,0,'','','C. Presl|Soják','ccc24d9a-dcb6-513d-944d-999f8d475bf0','Trifolium fragiferum subsp. bonannii (C. Presl) Soják','(C. Presl) Soják','SUBSPECIES','','Trifolium','','fragiferum','bonannii','','',NULL,'Soják','','','','','C. Presl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('5953','','','Vicia tenuifolia Roth',1,'Vicia tenuifolia','Vicia tenuifolia','Vicia tenuifol',2,0,'','','Roth','0cbf410a-1595-5769-b7ef-a96b483980d7','Vicia tenuifolia Roth','Roth','SPECIES','','Vicia','','tenuifolia','','','',NULL,'','','','','','Roth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6034','','','Erodium cicutarium (Linnaeus) L''Héritier ex Aiton subsp. cicutarium',2,'Erodium cicutarium cicutarium','Erodium cicutarium subsp. cicutarium','Erodium cicutari cicutari',3,0,'','','','ce397044-34e6-5bb8-899d-61f403dcefb5','Erodium cicutarium (Linnaeus) L''Héritier ex Aiton subsp. cicutarium','(Linnaeus) L''Héritier ex Aiton','SUBSPECIES','','Erodium','','cicutarium','cicutarium','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6170','','','Triadenum fraseri (Spach) Gleason',1,'Triadenum fraseri','Triadenum fraseri','Triadenum fraser',2,0,'','','Spach|Gleason','bee06cc0-6082-5680-bbb4-196006466268','Triadenum fraseri (Spach) Gleason','(Spach) Gleason','SPECIES','','Triadenum','','fraseri','','','',NULL,'Gleason','','','','','Spach','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6241','','','Juglans ailantifolia Carrière',1,'Juglans ailantifolia','Juglans ailantifolia','Juglans ailantifol',2,0,'','','Carrière','1579075e-b24a-5916-b5be-80fcedf3d1b2','Juglans ailantifolia Carrière','Carrière','SPECIES','','Juglans','','ailantifolia','','','',NULL,'','','','','','Carrière','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6261','','','Juncus bufonius var. halophilus Buchenau & Fernald',1,'Juncus bufonius halophilus','Juncus bufonius var. halophilus','Juncus bufon halophil',3,0,'','','Buchenau|Fernald','73741bad-04fe-5b95-9b6f-829cc52377d2','Juncus bufonius var. halophilus Buchenau & Fernald','Buchenau & Fernald','VARIETY','','Juncus','','bufonius','halophilus','','',NULL,'','','','','','Buchenau & Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6311','','','Juncus trifidus Linnaeus',1,'Juncus trifidus','Juncus trifidus','Juncus trifid',2,0,'','','Linnaeus','fd10cca8-fc33-5986-9eef-d5a9799ece30','Juncus trifidus Linnaeus','Linnaeus','SPECIES','','Juncus','','trifidus','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6345','','','Lilaea scilloides (Poiret) Hauman',1,'Lilaea scilloides','Lilaea scilloides','Lilaea scilloid',2,0,'','','Poiret|Hauman','f77e48d2-0804-5038-9fa5-a8388519fb07','Lilaea scilloides (Poiret) Hauman','(Poiret) Hauman','SPECIES','','Lilaea','','scilloides','','','',NULL,'Hauman','','','','','Poiret','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6408','','','Mentha gentilis auct. non Linnaeus',4,'','','',NULL,NULL,'','','','','Mentha gentilis auct. non Linnaeus','auct. non Linnaeus','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6435','','','Physostegia virginiana var. granulosa (Fassett) Fernald',1,'Physostegia virginiana granulosa','Physostegia virginiana var. granulosa','Physostegia uirginian granulos',3,0,'','','Fassett|Fernald','8d65d07d-4180-5601-8cfd-2adf288d8e2e','Physostegia virginiana var. granulosa (Fassett) Fernald','(Fassett) Fernald','VARIETY','','Physostegia','','virginiana','granulosa','','',NULL,'Fernald','','','','','Fassett','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6477','','','Teucrium canadense subsp. viscidum (Piper) Roy L. Taylor & MacBryde',1,'Teucrium canadense viscidum','Teucrium canadense subsp. viscidum','Teucrium canadens uiscid',3,0,'','','Piper|Roy L. Taylor|MacBryde','a19df0a6-c87d-5526-8ade-ec5163eac3a8','Teucrium canadense subsp. viscidum (Piper) Roy L. Taylor & MacBryde','(Piper) Roy L. Taylor & MacBryde','SUBSPECIES','','Teucrium','','canadense','viscidum','','',NULL,'Roy L. Taylor & MacBryde','','','','','Piper','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6552','','','Linum lewisii Pursh subsp. lewisii',1,'Linum lewisii lewisii','Linum lewisii subsp. lewisii','Linum lewis lewis',3,0,'','','','a5a9b61c-5ba9-53ff-b7e7-18e4cc70bc5a','Linum lewisii Pursh subsp. lewisii','Pursh','SUBSPECIES','','Linum','','lewisii','lewisii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6594','','','Lycopodium annotinum Linnaeus',1,'Lycopodium annotinum','Lycopodium annotinum','Lycopodium annotin',2,0,'','','Linnaeus','90c250cc-ea38-59cd-9d6a-e16fa9a87008','Lycopodium annotinum Linnaeus','Linnaeus','SPECIES','','Lycopodium','','annotinum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6597','','','Lycopodium hickeyi W.H. Wagner, Beitel & R.C. Moran',1,'Lycopodium hickeyi','Lycopodium hickeyi','Lycopodium hickey',2,0,'','','W. H. Wagner|Beitel|R. C. Moran','9859d8aa-f5ac-5c8b-a8fd-3ffbca86342e','Lycopodium hickeyi W.H. Wagner, Beitel & R.C. Moran','W.H. Wagner, Beitel & R.C. Moran','SPECIES','','Lycopodium','','hickeyi','','','',NULL,'','','','','','W. H. Wagner, Beitel & R. C. Moran','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6682','','','Anagallis arvensis Linnaeus',1,'Anagallis arvensis','Anagallis arvensis','Anagallis aruens',2,0,'','','Linnaeus','a7a7b922-95b3-5d72-930c-e500ede65248','Anagallis arvensis Linnaeus','Linnaeus','SPECIES','','Anagallis','','arvensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6698','','','Trientalis borealis Rafinesque',1,'Trientalis borealis','Trientalis borealis','Trientalis boreal',2,0,'','','Rafinesque','030e9bca-cdbd-53fe-bcbe-7f517a110372','Trientalis borealis Rafinesque','Rafinesque','SPECIES','','Trientalis','','borealis','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6741','','','Chamerion angustifolium (Linnaeus) Holub',1,'Chamerion angustifolium','Chamerion angustifolium','Chamerion angustifoli',2,0,'','','Linnaeus|Holub','4f42b5e8-b943-599a-98ec-b1a082b5c244','Chamerion angustifolium (Linnaeus) Holub','(Linnaeus) Holub','SPECIES','','Chamerion','','angustifolium','','','',NULL,'Holub','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6814','','','Oenothera fruticosa subsp. glauca (Michaux) Straley',1,'Oenothera fruticosa glauca','Oenothera fruticosa subsp. glauca','Oenothera fruticos glauc',3,0,'','','Michaux|Straley','4af3d450-8a89-555c-82f6-92acbf6c554f','Oenothera fruticosa subsp. glauca (Michaux) Straley','(Michaux) Straley','SUBSPECIES','','Oenothera','','fruticosa','glauca','','',NULL,'Straley','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6867','','','Dactylorhiza majalis subsp. praetermissa var. junialis (Vermeulen) Senghas',1,'Dactylorhiza majalis praetermissa junialis','Dactylorhiza majalis subsp. praetermissa var. junialis','Dactylorhiza maial praetermiss iunial',4,0,'','','Vermeulen|Senghas','c6122538-889b-51f0-8613-f3ea63588cbc','Dactylorhiza majalis subsp. praetermissa var. junialis (Vermeulen) Senghas','(Vermeulen) Senghas','VARIETY','','','','','','','',NULL,'Senghas','','','','','Vermeulen','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6883','','','Listera borealis Morong',1,'Listera borealis','Listera borealis','Listera boreal',2,0,'','','Morong','adaf8a66-344d-580c-ab78-550c3402860f','Listera borealis Morong','Morong','SPECIES','','Listera','','borealis','','','',NULL,'','','','','','Morong','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6888','','','Listera cordata var. nephrophylla (Rydberg) Hultén',1,'Listera cordata nephrophylla','Listera cordata var. nephrophylla','Listera cordat nephrophyll',3,0,'','','Rydberg|Hultén','15f0c089-9e84-5b8f-b1ea-66d5b9f4b33b','Listera cordata var. nephrophylla (Rydberg) Hultén','(Rydberg) Hultén','VARIETY','','Listera','','cordata','nephrophylla','','',NULL,'Hultén','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6932','','','Platanthera ×media (Rydberg) Luer',3,'','','',NULL,NULL,'','','','','Platanthera ×media (Rydberg) Luer','(Rydberg) Luer','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6961','','','Agalinis paupercula (A. Gray) Britton var. paupercula',1,'Agalinis paupercula paupercula','Agalinis paupercula var. paupercula','Agalinis paupercul paupercul',3,0,'','','','888e7c32-3557-5338-b5c9-16a4b850c3c2','Agalinis paupercula (A. Gray) Britton var. paupercula','(A. Gray) Britton','VARIETY','','Agalinis','','paupercula','paupercula','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6979','','','Castilleja caudata (Pennell) Rebristaya',1,'Castilleja caudata','Castilleja caudata','Castilleja caudat',2,0,'','','Pennell|Rebristaya','a33241b5-de16-582b-9719-70fb86cd8da3','Castilleja caudata (Pennell) Rebristaya','(Pennell) Rebristaya','SPECIES','','Castilleja','','caudata','','','',NULL,'Rebristaya','','','','','Pennell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('6986','','','Castilleja hispida Bentham subsp. hispida',1,'Castilleja hispida hispida','Castilleja hispida subsp. hispida','Castilleja hispid hispid',3,0,'','','','f71fc21f-bf3f-581c-8815-148861d81da7','Castilleja hispida Bentham subsp. hispida','Bentham','SUBSPECIES','','Castilleja','','hispida','hispida','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7028','','','Orobanche corymbosa subsp. mutabilis Heckard',1,'Orobanche corymbosa mutabilis','Orobanche corymbosa subsp. mutabilis','Orobanche corymbos mutabil',3,0,'','','Heckard','0468e7ca-93d7-5167-b629-3bea6d9debff','Orobanche corymbosa subsp. mutabilis Heckard','Heckard','SUBSPECIES','','Orobanche','','corymbosa','mutabilis','','',NULL,'','','','','','Heckard','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7035','','','Orobanche uniflora Linnaeus',1,'Orobanche uniflora','Orobanche uniflora','Orobanche uniflor',2,0,'','','Linnaeus','582af259-c516-5b83-9ade-a0875281e90a','Orobanche uniflora Linnaeus','Linnaeus','SPECIES','','Orobanche','','uniflora','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7059','','','Pedicularis macrodontis Richardson',1,'Pedicularis macrodontis','Pedicularis macrodontis','Pedicularis macrodont',2,0,'','','Richardson','76985ba5-ef95-54fb-82b1-e9cb9ae48778','Pedicularis macrodontis Richardson','Richardson','SPECIES','','Pedicularis','','macrodontis','','','',NULL,'','','','','','Richardson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7078','','','Oxalis acetosella subsp. montana (Rafinesque) Hultén',1,'Oxalis acetosella montana','Oxalis acetosella subsp. montana','Oxalis acetosell montan',3,0,'','','Rafinesque|Hultén','627e138f-4ee2-55c8-b13b-0371788f6637','Oxalis acetosella subsp. montana (Rafinesque) Hultén','(Rafinesque) Hultén','SUBSPECIES','','Oxalis','','acetosella','montana','','',NULL,'Hultén','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7137','','','Mimulus alsinoides Douglas ex Bentham',2,'Mimulus alsinoides','Mimulus alsinoides','Mimulus alsinoid',2,0,'','','Douglas|Bentham','890d4a9a-4406-5d1c-aa4f-85e24a0a9bb0','Mimulus alsinoides Douglas ex Bentham','Douglas ex Bentham','SPECIES','','Mimulus','','alsinoides','','','',NULL,'','','','','','Douglas','','Bentham','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7146','','','Mimulus moschatus Douglas ex Lindley var. moschatus',2,'Mimulus moschatus moschatus','Mimulus moschatus var. moschatus','Mimulus moschat moschat',3,0,'','','','82718148-7f8d-5042-ac28-0a867d5301a0','Mimulus moschatus Douglas ex Lindley var. moschatus','Douglas ex Lindley','VARIETY','','Mimulus','','moschatus','moschatus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7213','','','Callitriche intermedia subsp. hamulata (Kützing ex W.D.J. Koch) Clapham',2,'Callitriche intermedia hamulata','Callitriche intermedia subsp. hamulata','Callitriche intermed hamulat',3,0,'','','Kützing|W. D. J. Koch|Clapham','dbccf72e-ffb3-5cd1-a7f1-6d1cf91f558e','Callitriche intermedia subsp. hamulata (Kützing ex W.D.J. Koch) Clapham','(Kützing ex W.D.J. Koch) Clapham','SUBSPECIES','','Callitriche','','intermedia','hamulata','','',NULL,'Clapham','','','','','Kützing','','W. D. J. Koch','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7232','','','Gratiola neglecta var. glaberrima (Fernald) Fernald',1,'Gratiola neglecta glaberrima','Gratiola neglecta var. glaberrima','Gratiola neglect glaberrim',3,0,'','','Fernald','3eda500b-791c-5eb3-9ded-76fe8eb701c0','Gratiola neglecta var. glaberrima (Fernald) Fernald','(Fernald) Fernald','VARIETY','','Gratiola','','neglecta','glaberrima','','',NULL,'Fernald','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7257','','','Lindernia dubia var. inundata (Pennell) Pennell',1,'Lindernia dubia inundata','Lindernia dubia var. inundata','Lindernia dub inundat',3,0,'','','Pennell','3b79c33c-7606-595b-a9e8-2f40ab32f62c','Lindernia dubia var. inundata (Pennell) Pennell','(Pennell) Pennell','VARIETY','','Lindernia','','dubia','inundata','','',NULL,'Pennell','','','','','Pennell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7296','','','Plantago arenaria Waldstein & Kitaibel',1,'Plantago arenaria','Plantago arenaria','Plantago arenar',2,0,'','','Waldstein|Kitaibel','54bd5392-50c6-5f65-a71c-01f8b6737c52','Plantago arenaria Waldstein & Kitaibel','Waldstein & Kitaibel','SPECIES','','Plantago','','arenaria','','','',NULL,'','','','','','Waldstein & Kitaibel','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7322','','','Veronica austriaca subsp. teucrium (Linnaeus) D.A. Webb',1,'Veronica austriaca teucrium','Veronica austriaca subsp. teucrium','Veronica austriac teucri',3,0,'','','Linnaeus|D. A. Webb','3fe4a41c-d267-5eda-a663-01df73d1a21d','Veronica austriaca subsp. teucrium (Linnaeus) D.A. Webb','(Linnaeus) D.A. Webb','SUBSPECIES','','Veronica','','austriaca','teucrium','','',NULL,'D. A. Webb','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7358','','','Achnatherum hymenoides (Roemer & Schultes) Barkworth',1,'Achnatherum hymenoides','Achnatherum hymenoides','Achnatherum hymenoid',2,0,'','','Roemer|Schultes|Barkworth','bda06ee4-ef5a-5a55-88b9-1fc976a85e8e','Achnatherum hymenoides (Roemer & Schultes) Barkworth','(Roemer & Schultes) Barkworth','SPECIES','','Achnatherum','','hymenoides','','','',NULL,'Barkworth','','','','','Roemer & Schultes','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7363','','','Achnatherum nelsonii (Scribner) Barkworth subsp. nelsonii',1,'Achnatherum nelsonii nelsonii','Achnatherum nelsonii subsp. nelsonii','Achnatherum nelson nelson',3,0,'','','','8017da82-f9b3-5509-851b-ab1b0dcc4c9d','Achnatherum nelsonii (Scribner) Barkworth subsp. nelsonii','(Scribner) Barkworth','SUBSPECIES','','Achnatherum','','nelsonii','nelsonii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7398','','','Ammophila arenaria (Linnaeus) Link subsp. arenaria',1,'Ammophila arenaria arenaria','Ammophila arenaria subsp. arenaria','Ammophila arenar arenar',3,0,'','','','eb58e696-271b-5702-8807-429bfc6d9480','Ammophila arenaria (Linnaeus) Link subsp. arenaria','(Linnaeus) Link','SUBSPECIES','','Ammophila','','arenaria','arenaria','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7448','','','Bromus aleutensis Trinius ex Grisebach',2,'Bromus aleutensis','Bromus aleutensis','Bromus aleutens',2,0,'','','Trinius|Grisebach','1ee4531c-fc80-502d-95cb-df0a14a1477f','Bromus aleutensis Trinius ex Grisebach','Trinius ex Grisebach','SPECIES','','Bromus','','aleutensis','','','',NULL,'','','','','','Trinius','','Grisebach','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7503','','','Calamovilfa longifolia (Hooker) Hackel ex Scribner & Southworth var. longifolia',2,'Calamovilfa longifolia longifolia','Calamovilfa longifolia var. longifolia','Calamovilfa longifol longifol',3,0,'','','','f8e5c023-9910-530e-b018-0a746f6fce94','Calamovilfa longifolia (Hooker) Hackel ex Scribner & Southworth var. longifolia','(Hooker) Hackel ex Scribner & Southworth','VARIETY','','Calamovilfa','','longifolia','longifolia','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7546','','','Dichanthelium acuminatum subsp. lindheimeri (Nash) Freckmann & Lelong',1,'Dichanthelium acuminatum lindheimeri','Dichanthelium acuminatum subsp. lindheimeri','Dichanthelium acuminat lindheimer',3,0,'','','Nash|Freckmann|Lelong','2abb842c-fb17-54cb-b8b7-dbcf5b29b4f1','Dichanthelium acuminatum subsp. lindheimeri (Nash) Freckmann & Lelong','(Nash) Freckmann & Lelong','SUBSPECIES','','Dichanthelium','','acuminatum','lindheimeri','','',NULL,'Freckmann & Lelong','','','','','Nash','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7612','','','Elymus villosus Muhlenberg ex Willdenow var. villosus',2,'Elymus villosus villosus','Elymus villosus var. villosus','Elymus uillos uillos',3,0,'','','','aadc8d98-e079-5bd3-a4f1-9535f8b6f87e','Elymus villosus Muhlenberg ex Willdenow var. villosus','Muhlenberg ex Willdenow','VARIETY','','Elymus','','villosus','villosus','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7810','','','Panicum rigidulum Bosc ex Nees',2,'Panicum rigidulum','Panicum rigidulum','Panicum rigidul',2,0,'','','Bosc|Nees','25c866d4-92c5-5c8c-bdd6-76561651f942','Panicum rigidulum Bosc ex Nees','Bosc ex Nees','SPECIES','','Panicum','','rigidulum','','','',NULL,'','','','','','Bosc','','Nees','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7834','','','Piptatherum racemosum (Smith) Eaton',1,'Piptatherum racemosum','Piptatherum racemosum','Piptatherum racemos',2,0,'','','Smith|Eaton','60fb8db6-6926-567b-a7ab-21e1f73a1507','Piptatherum racemosum (Smith) Eaton','(Smith) Eaton','SPECIES','','Piptatherum','','racemosum','','','',NULL,'Eaton','','','','','Smith','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7940','','','Schedonorus giganteus (Linnaeus) Holub',1,'Schedonorus giganteus','Schedonorus giganteus','Schedonorus gigante',2,0,'','','Linnaeus|Holub','04bf7bbf-f94d-5616-a628-ef3a78931de5','Schedonorus giganteus (Linnaeus) Holub','(Linnaeus) Holub','SPECIES','','Schedonorus','','giganteus','','','',NULL,'Holub','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7963','','','Spartina pectinata Link',1,'Spartina pectinata','Spartina pectinata','Spartina pectinat',2,0,'','','Link','6d340aab-2156-521e-addc-be4bf1003d4c','Spartina pectinata Link','Link','SPECIES','','Spartina','','pectinata','','','',NULL,'','','','','','Link','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7978','','','Thinopyrum ponticum (Podpěra) Barkworth & D.R. Dewey',1,'Thinopyrum ponticum','Thinopyrum ponticum','Thinopyrum pontic',2,0,'','','Podpěra|Barkworth|D. R. Dewey','2da3a62b-d085-5986-9486-b7fa06f449d9','Thinopyrum ponticum (Podpěra) Barkworth & D.R. Dewey','(Podpěra) Barkworth & D.R. Dewey','SPECIES','','Thinopyrum','','ponticum','','','',NULL,'Barkworth & D. R. Dewey','','','','','Podpěra','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('7997','','','Trisetum wolfii Vasey',1,'Trisetum wolfii','Trisetum wolfii','Trisetum wolf',2,0,'','','Vasey','6c9d1d4a-ee75-54e8-aca0-0c83e7425a1e','Trisetum wolfii Vasey','Vasey','SPECIES','','Trisetum','','wolfii','','','',NULL,'','','','','','Vasey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8046','','','Linanthus harknessii (Curran) Greene',1,'Linanthus harknessii','Linanthus harknessii','Linanthus harkness',2,0,'','','Curran|Greene','26c1a131-00ef-53ce-98fa-cb01e26f5d08','Linanthus harknessii (Curran) Greene','(Curran) Greene','SPECIES','','Linanthus','','harknessii','','','',NULL,'Greene','','','','','Curran','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8071','','','Phlox richardsonii Hooker var. richardsonii',1,'Phlox richardsonii richardsonii','Phlox richardsonii var. richardsonii','Phlox richardson richardson',3,0,'','','','c2d3f834-0d3d-588c-aa4e-56da48a64689','Phlox richardsonii Hooker var. richardsonii','Hooker','VARIETY','','Phlox','','richardsonii','richardsonii','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8096','','','Polygala senega Linnaeus',1,'Polygala senega','Polygala senega','Polygala seneg',2,0,'','','Linnaeus','049968ce-849d-5e3b-8766-65362a07cdb4','Polygala senega Linnaeus','Linnaeus','SPECIES','','Polygala','','senega','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8101','','','Aconogonon alaskanum (Small) Soják',1,'Aconogonon alaskanum','Aconogonon alaskanum','Aconogonon alaskan',2,0,'','','Small|Soják','4a77e0af-5de7-5b3f-ae52-d5b6377a24ae','Aconogonon alaskanum (Small) Soják','(Small) Soják','SPECIES','','Aconogonon','','alaskanum','','','',NULL,'Soják','','','','','Small','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8134','','','Fallopia sachalinensis (F. Schmidt) Ronse-Decraene',1,'Fallopia sachalinensis','Fallopia sachalinensis','Fallopia sachalinens',2,0,'','','F. Schmidt|Ronse-Decraene','904d8fdb-40be-5a43-b622-ea6de46e0e3e','Fallopia sachalinensis (F. Schmidt) Ronse-Decraene','(F. Schmidt) Ronse-Decraene','SPECIES','','Fallopia','','sachalinensis','','','',NULL,'Ronse-Decraene','','','','','F. Schmidt','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8242','','','Eichhornia crassipes (C. Martius) Solms-Laubach',1,'Eichhornia crassipes','Eichhornia crassipes','Eichhornia crassip',2,0,'','','C. Martius|Solms-Laubach','77669492-d0dc-5215-8319-c0a4477707e1','Eichhornia crassipes (C. Martius) Solms-Laubach','(C. Martius) Solms-Laubach','SPECIES','','Eichhornia','','crassipes','','','',NULL,'Solms-Laubach','','','','','C. Martius','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8337','','','Stuckenia filiformis subsp. alpina (Blytt) R.R. Haynes, Les & M. Král',1,'Stuckenia filiformis alpina','Stuckenia filiformis subsp. alpina','Stuckenia filiform alpin',3,0,'','','Blytt|R. R. Haynes|Les|M. Král','88f8f59d-da55-541c-8ee9-7df3253475c2','Stuckenia filiformis subsp. alpina (Blytt) R.R. Haynes, Les & M. Král','(Blytt) R.R. Haynes, Les & M. Král','SUBSPECIES','','Stuckenia','','filiformis','alpina','','',NULL,'R. R. Haynes, Les & M. Král','','','','','Blytt','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8386','','','Cheilanthes gracillima D.C. Eaton',1,'Cheilanthes gracillima','Cheilanthes gracillima','Cheilanthes gracillim',2,0,'','','D. C. Eaton','c28e1bc8-5450-5bcc-9439-3b56175d8c15','Cheilanthes gracillima D.C. Eaton','D.C. Eaton','SPECIES','','Cheilanthes','','gracillima','','','',NULL,'','','','','','D. C. Eaton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8430','','','Anemone occidentalis S. Watson',1,'Anemone occidentalis','Anemone occidentalis','Anemone occidental',2,0,'','','S. Watson','9cc30fbb-bb7a-5640-b2b3-4c64b44da4e6','Anemone occidentalis S. Watson','S. Watson','SPECIES','','Anemone','','occidentalis','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8469','','','Consolida regalis Gray',1,'Consolida regalis','Consolida regalis','Consolida regal',2,0,'','','Gray','6fba56fc-2f44-5388-9b20-bdcd1e8961b8','Consolida regalis Gray','Gray','SPECIES','','Consolida','','regalis','','','',NULL,'','','','','','Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8508','','','Ranunculus cooleyae Vasey & Rose ex Rose',2,'Ranunculus cooleyae','Ranunculus cooleyae','Ranunculus cooley',2,0,'','','Vasey|Rose','70ca66df-9d47-537a-9dcf-3b921247b440','Ranunculus cooleyae Vasey & Rose ex Rose','Vasey & Rose ex Rose','SPECIES','','Ranunculus','','cooleyae','','','',NULL,'','','','','','Vasey & Rose','','Rose','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8647','','','Cotoneaster melanocarpus Loddiges,  G. Loddiges & W. Loddiges nom. illeg.',4,'','','',NULL,NULL,'','','','','Cotoneaster melanocarpus Loddiges,  G. Loddiges & W. Loddiges nom. illeg.','Loddiges,  G. Loddiges & W. Loddiges nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8729','','','Dryas chamissonis Sprengel ex Juzepczuk',2,'Dryas chamissonis','Dryas chamissonis','Dryas chamisson',2,0,'','','Sprengel|Juzepczuk','a7d67d7e-2237-5666-8916-4d6b41289c88','Dryas chamissonis Sprengel ex Juzepczuk','Sprengel ex Juzepczuk','SPECIES','','Dryas','','chamissonis','','','',NULL,'','','','','','Sprengel','','Juzepczuk','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8742','','','Dryas octopetala Linnaeus subsp. octopetala',1,'Dryas octopetala octopetala','Dryas octopetala subsp. octopetala','Dryas octopetal octopetal',3,0,'','','','5baf95c8-cc7a-54f8-bf97-abc56d9fd71d','Dryas octopetala Linnaeus subsp. octopetala','Linnaeus','SUBSPECIES','','Dryas','','octopetala','octopetala','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8790','','','Malus pumila Miller',1,'Malus pumila','Malus pumila','Malus pumil',2,0,'','','Miller','01f60fcb-9f8c-5137-a718-095df145149d','Malus pumila Miller','Miller','SPECIES','','Malus','','pumila','','','',NULL,'','','','','','Miller','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8862','','','Prunus domestica Linnaeus subsp. domestica',1,'Prunus domestica domestica','Prunus domestica subsp. domestica','Prunus domestic domestic',3,0,'','','','dc3fd5fb-3182-59eb-ad2c-ed78c6f3bd94','Prunus domestica Linnaeus subsp. domestica','Linnaeus','SUBSPECIES','','Prunus','','domestica','domestica','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('8949','','','Rubus ursinus subsp. macropetalus (Douglas ex Hooker) Roy L. Taylor & MacBryde',2,'Rubus ursinus macropetalus','Rubus ursinus subsp. macropetalus','Rubus ursin macropetal',3,0,'','','Douglas|Hooker|Roy L. Taylor|MacBryde','6d8ac256-30c9-5be0-8054-ca3f28988968','Rubus ursinus subsp. macropetalus (Douglas ex Hooker) Roy L. Taylor & MacBryde','(Douglas ex Hooker) Roy L. Taylor & MacBryde','SUBSPECIES','','Rubus','','ursinus','macropetalus','','',NULL,'Roy L. Taylor & MacBryde','','','','','Douglas','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9276','','','Mitella pentandra Hooker',1,'Mitella pentandra','Mitella pentandra','Mitella pentandr',2,0,'','','Hooker','4fdd5806-1ed3-53cb-832d-beed91434d64','Mitella pentandra Hooker','Hooker','SPECIES','','Mitella','','pentandra','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9364','','','Physalis alkekengi Linnaeus',1,'Physalis alkekengi','Physalis alkekengi','Physalis alkekeng',2,0,'','','Linnaeus','4acb54df-55de-51fc-a375-fccdf8dfb8a8','Physalis alkekengi Linnaeus','Linnaeus','SPECIES','','Physalis','','alkekengi','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9383','','','Solanum ptychanthum Dunal',1,'Solanum ptychanthum','Solanum ptychanthum','Solanum ptychanth',2,0,'','','Dunal','6448cc90-edd6-5a2c-9d11-b4780b6badfb','Solanum ptychanthum Dunal','Dunal','SPECIES','','Solanum','','ptychanthum','','','',NULL,'','','','','','Dunal','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9439','','','Urtica dioica subsp. gracilis (Aiton) Selander',1,'Urtica dioica gracilis','Urtica dioica subsp. gracilis','Urtica dioic gracil',3,0,'','','Aiton|Selander','ffc10311-4046-55f7-9875-beebb45ab41e','Urtica dioica subsp. gracilis (Aiton) Selander','(Aiton) Selander','SUBSPECIES','','Urtica','','dioica','gracilis','','',NULL,'Selander','','','','','Aiton','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9472','','','Hybanthus concolor (T.F. Forster) Sprengel',1,'Hybanthus concolor','Hybanthus concolor','Hybanthus concolor',2,0,'','','T. F. Forster|Sprengel','edb2fafc-5a4d-5e52-897e-8c5ba082cd17','Hybanthus concolor (T.F. Forster) Sprengel','(T.F. Forster) Sprengel','SPECIES','','Hybanthus','','concolor','','','',NULL,'Sprengel','','','','','T. F. Forster','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9513','','','Viola pubescens var. scabriuscula Torrey & A. Gray',1,'Viola pubescens scabriuscula','Viola pubescens var. scabriuscula','Viola pubescens scabriuscul',3,0,'','','Torrey|A. Gray','a6ed7022-5434-5993-bd3c-67be19d23d94','Viola pubescens var. scabriuscula Torrey & A. Gray','Torrey & A. Gray','VARIETY','','Viola','','pubescens','scabriuscula','','',NULL,'','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9575','','','Elymus virginicus var. jejunus (Ramaley) Bush',1,'Elymus virginicus jejunus','Elymus virginicus var. jejunus','Elymus uirginic ieiun',3,0,'','','Ramaley|Bush','fcf89109-036f-5a46-9761-618bf002f8c5','Elymus virginicus var. jejunus (Ramaley) Bush','(Ramaley) Bush','VARIETY','','Elymus','','virginicus','jejunus','','',NULL,'Bush','','','','','Ramaley','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9577','','','Elymus villosus var. arkansanus (Scribner & C.R. Ball) J.J.N. Campell',1,'Elymus villosus arkansanus','Elymus villosus var. arkansanus','Elymus uillos arkansan',3,0,'','','Scribner|C. R. Ball|J. J. N. Campell','6f7bc7c0-3d7e-5ce2-b71c-8e10c01a8401','Elymus villosus var. arkansanus (Scribner & C.R. Ball) J.J.N. Campell','(Scribner & C.R. Ball) J.J.N. Campell','VARIETY','','Elymus','','villosus','arkansanus','','',NULL,'J. J. N. Campell','','','','','Scribner & C. R. Ball','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9664','','','Crataegus jackii Sargent',1,'Crataegus jackii','Crataegus jackii','Crataegus iack',2,0,'','','Sargent','be55ed57-b819-5ae7-b0bd-0bd1ea6addc8','Crataegus jackii Sargent','Sargent','SPECIES','','Crataegus','','jackii','','','',NULL,'','','','','','Sargent','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9711','','','Mimulus suksdorfii A. Gray',1,'Mimulus suksdorfii','Mimulus suksdorfii','Mimulus suksdorf',2,0,'','','A. Gray','f54ff26b-a8e0-51e5-a2b0-2d83abde47bd','Mimulus suksdorfii A. Gray','A. Gray','SPECIES','','Mimulus','','suksdorfii','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9755','','','Campanula alaskana (A. Gray) W. Wight ex J.P. Anderson',2,'Campanula alaskana','Campanula alaskana','Campanula alaskan',2,0,'','','A. Gray|W. Wight|J. P. Anderson','a4215010-67fc-5d82-bbf9-f3d3024721cd','Campanula alaskana (A. Gray) W. Wight ex J.P. Anderson','(A. Gray) W. Wight ex J.P. Anderson','SPECIES','','Campanula','','alaskana','','','',NULL,'W. Wight','','J. P. Anderson','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9816','','','Lamiastrum galeobdolon (Linnaeus) Ehrendorfer & Polatschek',1,'Lamiastrum galeobdolon','Lamiastrum galeobdolon','Lamiastrum galeobdolon',2,0,'','','Linnaeus|Ehrendorfer|Polatschek','20bc9e9e-8175-5413-ba6d-620dceb994c5','Lamiastrum galeobdolon (Linnaeus) Ehrendorfer & Polatschek','(Linnaeus) Ehrendorfer & Polatschek','SPECIES','','Lamiastrum','','galeobdolon','','','',NULL,'Ehrendorfer & Polatschek','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9845','','','Salix euxina I.V. Belyaeva',1,'Salix euxina','Salix euxina','Salix euxin',2,0,'','','I. V. Belyaeva','baf05783-3181-518f-9058-6793019602af','Salix euxina I.V. Belyaeva','I.V. Belyaeva','SPECIES','','Salix','','euxina','','','',NULL,'','','','','','I. V. Belyaeva','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9895','','','Sambucus pubens var. arborescens Torrey & A. Gray',1,'Sambucus pubens arborescens','Sambucus pubens var. arborescens','Sambucus pubens arborescens',3,0,'','','Torrey|A. Gray','6db208fe-1a93-5470-b0ac-eafd8146a17e','Sambucus pubens var. arborescens Torrey & A. Gray','Torrey & A. Gray','VARIETY','','Sambucus','','pubens','arborescens','','',NULL,'','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9906','','','Alisma gramineum var. wahlenbergii (Holmberg) Raymond & Kucyniak',1,'Alisma gramineum wahlenbergii','Alisma gramineum var. wahlenbergii','Alisma gramine wahlenberg',3,0,'','','Holmberg|Raymond|Kucyniak','eed1087e-0bee-53cd-bb2c-4d1d8ab6dccf','Alisma gramineum var. wahlenbergii (Holmberg) Raymond & Kucyniak','(Holmberg) Raymond & Kucyniak','VARIETY','','Alisma','','gramineum','wahlenbergii','','',NULL,'Raymond & Kucyniak','','','','','Holmberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9913','','','Sagittaria cycloptera (J.G. Smith) C. Mohr',1,'Sagittaria cycloptera','Sagittaria cycloptera','Sagittaria cyclopter',2,0,'','','J. G. Smith|C. Mohr','8cfdd84c-88f8-5d4a-909d-7138b0a0a107','Sagittaria cycloptera (J.G. Smith) C. Mohr','(J.G. Smith) C. Mohr','SPECIES','','Sagittaria','','cycloptera','','','',NULL,'C. Mohr','','','','','J. G. Smith','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9917','','','Sagittaria latifolia var. pubescens (Torrey) J.G. Smith',1,'Sagittaria latifolia pubescens','Sagittaria latifolia var. pubescens','Sagittaria latifol pubescens',3,0,'','','Torrey|J. G. Smith','7e564157-0cd3-5cc1-b626-7028877a930f','Sagittaria latifolia var. pubescens (Torrey) J.G. Smith','(Torrey) J.G. Smith','VARIETY','','Sagittaria','','latifolia','pubescens','','',NULL,'J. G. Smith','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9924','','','Sagittaria calycina var. spongiosa Engelmann',1,'Sagittaria calycina spongiosa','Sagittaria calycina var. spongiosa','Sagittaria calycin spongios',3,0,'','','Engelmann','4a16af91-4b80-5b1d-9e11-5c3aed305f63','Sagittaria calycina var. spongiosa Engelmann','Engelmann','VARIETY','','Sagittaria','','calycina','spongiosa','','',NULL,'','','','','','Engelmann','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9930','','','Allium attenuifolium Kellogg',1,'Allium attenuifolium','Allium attenuifolium','Allium attenuifoli',2,0,'','','Kellogg','71fecfb6-f6a8-5aad-a549-6ac3b2bb7461','Allium attenuifolium Kellogg','Kellogg','SPECIES','','Allium','','attenuifolium','','','',NULL,'','','','','','Kellogg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9935','','','Allium canadense var. ovoideum Farwell',1,'Allium canadense ovoideum','Allium canadense var. ovoideum','Allium canadens ouoide',3,0,'','','Farwell','5ebd9818-b3f0-59d5-8b46-2f19b454a0b3','Allium canadense var. ovoideum Farwell','Farwell','VARIETY','','Allium','','canadense','ovoideum','','',NULL,'','','','','','Farwell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9943','','','Allium burdickii (Hanes) A.G. Jones',1,'Allium burdickii','Allium burdickii','Allium burdick',2,0,'','','Hanes|A. G. Jones','f71bd4e3-097c-53fa-8ecb-e9bc9c2b4452','Allium burdickii (Hanes) A.G. Jones','(Hanes) A.G. Jones','SPECIES','','Allium','','burdickii','','','',NULL,'A. G. Jones','','','','','Hanes','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9950','','','Amaranthus microphyllus Shinners',1,'Amaranthus microphyllus','Amaranthus microphyllus','Amaranthus microphyll',2,0,'','','Shinners','df3555e6-7843-519b-a0c8-ce619f350774','Amaranthus microphyllus Shinners','Shinners','SPECIES','','Amaranthus','','microphyllus','','','',NULL,'','','','','','Shinners','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9954','','','Amaranthus bracteosus Uline & W.L. Bray',1,'Amaranthus bracteosus','Amaranthus bracteosus','Amaranthus bracteos',2,0,'','','Uline|W. L. Bray','b9457914-7cbb-5fea-8f2b-77aabc19955c','Amaranthus bracteosus Uline & W.L. Bray','Uline & W.L. Bray','SPECIES','','Amaranthus','','bracteosus','','','',NULL,'','','','','','Uline & W. L. Bray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9959','','','Acnida altissima var. prostrata (Uline & W.L. Bray) Fernald',1,'Acnida altissima prostrata','Acnida altissima var. prostrata','Acnida altissim prostrat',3,0,'','','Uline|W. L. Bray|Fernald','35b5f465-b558-5130-800e-024f48780b42','Acnida altissima var. prostrata (Uline & W.L. Bray) Fernald','(Uline & W.L. Bray) Fernald','VARIETY','','Acnida','','altissima','prostrata','','',NULL,'Fernald','','','','','Uline & W. L. Bray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9966','','','Leucojum aestivum Linnaeus subsp. aestivum',1,'Leucojum aestivum aestivum','Leucojum aestivum subsp. aestivum','Leucojum aestiu aestiu',3,0,'','','','0f040725-7c8e-5c4c-8ef6-6826deb825a9','Leucojum aestivum Linnaeus subsp. aestivum','Linnaeus','SUBSPECIES','','Leucojum','','aestivum','aestivum','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9968','','','Rhus aromatica var. arenaria (Greene) Fernald',1,'Rhus aromatica arenaria','Rhus aromatica var. arenaria','Rhus aromatic arenar',3,0,'','','Greene|Fernald','5c4547fd-853f-5aa4-afbc-c6429c1d11b8','Rhus aromatica var. arenaria (Greene) Fernald','(Greene) Fernald','VARIETY','','Rhus','','aromatica','arenaria','','',NULL,'Fernald','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9970','','','Rhus aromatica var. illinoensis (Greene) Rehder',1,'Rhus aromatica illinoensis','Rhus aromatica var. illinoensis','Rhus aromatic illinoens',3,0,'','','Greene|Rehder','2f711fb5-3ecf-5bf1-9d97-8c05a1777618','Rhus aromatica var. illinoensis (Greene) Rehder','(Greene) Rehder','VARIETY','','Rhus','','aromatica','illinoensis','','',NULL,'Rehder','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9981','','','Toxicodendron oxycarpum Greene',1,'Toxicodendron oxycarpum','Toxicodendron oxycarpum','Toxicodendron oxycarp',2,0,'','','Greene','0803e4ce-c29d-5251-9dc9-832d5b91dec5','Toxicodendron oxycarpum Greene','Greene','SPECIES','','Toxicodendron','','oxycarpum','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9982','','','Toxicodendron radicans subsp. diversilobum (Torrey & A. Gray) Thorne',1,'Toxicodendron radicans diversilobum','Toxicodendron radicans subsp. diversilobum','Toxicodendron radicans diuersilob',3,0,'','','Torrey|A. Gray|Thorne','28e0f5d6-9bbd-5fd2-a7cb-c384d0cb0803','Toxicodendron radicans subsp. diversilobum (Torrey & A. Gray) Thorne','(Torrey & A. Gray) Thorne','SUBSPECIES','','Toxicodendron','','radicans','diversilobum','','',NULL,'Thorne','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9986','','','Rhus floridana Mearns',1,'Rhus floridana','Rhus floridana','Rhus floridan',2,0,'','','Mearns','ddda142b-bff1-5d7a-88a0-4f7e34bb5b1f','Rhus floridana Mearns','Mearns','SPECIES','','Rhus','','floridana','','','',NULL,'','','','','','Mearns','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9994','','','Toxicodendron radicans (Linnaeus) Kuntze subsp. radicans',1,'Toxicodendron radicans radicans','Toxicodendron radicans subsp. radicans','Toxicodendron radicans radicans',3,0,'','','','514bb6d3-2f76-5f01-bfdf-86e54d4d8a91','Toxicodendron radicans (Linnaeus) Kuntze subsp. radicans','(Linnaeus) Kuntze','SUBSPECIES','','Toxicodendron','','radicans','radicans','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('9998','','','Rhus radicans var. rydbergii (Small ex Rydberg) Rehder',2,'Rhus radicans rydbergii','Rhus radicans var. rydbergii','Rhus radicans rydberg',3,0,'','','Small|Rydberg|Rehder','44d000e1-4bf3-5708-b3d8-eeee5081361d','Rhus radicans var. rydbergii (Small ex Rydberg) Rehder','(Small ex Rydberg) Rehder','VARIETY','','Rhus','','radicans','rydbergii','','',NULL,'Rehder','','','','','Small','','Rydberg','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10003','','','Annona pendula Salisbury',1,'Annona pendula','Annona pendula','Annona pendul',2,0,'','','Salisbury','79f10805-5c0b-516e-bfec-f0fdb71ba994','Annona pendula Salisbury','Salisbury','SPECIES','','Annona','','pendula','','','',NULL,'','','','','','Salisbury','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10005','','','Porcelia triloba (Linnaeus) Persoon',1,'Porcelia triloba','Porcelia triloba','Porcelia trilob',2,0,'','','Linnaeus|Persoon','920c474d-a32a-5e1a-929b-17923af0b333','Porcelia triloba (Linnaeus) Persoon','(Linnaeus) Persoon','SPECIES','','Porcelia','','triloba','','','',NULL,'Persoon','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10011','','','Coelopleurum lucidum (Linnaeus) Fernald',1,'Coelopleurum lucidum','Coelopleurum lucidum','Coelopleurum lucid',2,0,'','','Linnaeus|Fernald','31733d2e-a55a-52b4-958a-6d732aa3b4d7','Coelopleurum lucidum (Linnaeus) Fernald','(Linnaeus) Fernald','SPECIES','','Coelopleurum','','lucidum','','','',NULL,'Fernald','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10016','','','Chaerophyllum sylvestre Linnaeus',1,'Chaerophyllum sylvestre','Chaerophyllum sylvestre','Chaerophyllum syluestr',2,0,'','','Linnaeus','b73d8037-6e73-5e1f-b93b-b7fe27a0ea7c','Chaerophyllum sylvestre Linnaeus','Linnaeus','SPECIES','','Chaerophyllum','','sylvestre','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10023','','','Carum bulbocastanum (Linnaeus) W.D.J. Koch',1,'Carum bulbocastanum','Carum bulbocastanum','Carum bulbocastan',2,0,'','','Linnaeus|W. D. J. Koch','508557d4-6e3d-5df0-9630-012868afad7b','Carum bulbocastanum (Linnaeus) W.D.J. Koch','(Linnaeus) W.D.J. Koch','SPECIES','','Carum','','bulbocastanum','','','',NULL,'W. D. J. Koch','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10034','','','Athamanta chinensis Linnaeus',1,'Athamanta chinensis','Athamanta chinensis','Athamanta chinens',2,0,'','','Linnaeus','a1abfd48-fa6f-51c8-8bb3-c2a0b4600a5d','Athamanta chinensis Linnaeus','Linnaeus','SPECIES','','Athamanta','','chinensis','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10036','','','Selinum pacificum S. Watson',1,'Selinum pacificum','Selinum pacificum','Selinum pacific',2,0,'','','S. Watson','bd10b8fb-1a3b-5efb-9b1a-79040f2eb2dc','Selinum pacificum S. Watson','S. Watson','SPECIES','','Selinum','','pacificum','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10042','','','Heracleum lanatum Michaux',1,'Heracleum lanatum','Heracleum lanatum','Heracleum lanat',2,0,'','','Michaux','3cdbbe52-e6ee-5ab0-b59a-24425b72fbfe','Heracleum lanatum Michaux','Michaux','SPECIES','','Heracleum','','lanatum','','','',NULL,'','','','','','Michaux','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10045','','','Ligusticum levisticum Linnaeus',1,'Ligusticum levisticum','Ligusticum levisticum','Ligusticum leuistic',2,0,'','','Linnaeus','b7b3c95b-b153-55fa-b74f-376f8adb58d7','Ligusticum levisticum Linnaeus','Linnaeus','SPECIES','','Ligusticum','','levisticum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10049','','','Peucedanum ambiguum (Nuttall) Nuttall ex Torrey & A. Gray',2,'Peucedanum ambiguum','Peucedanum ambiguum','Peucedanum ambigu',2,0,'','','Nuttall|Torrey|A. Gray','21b26f9f-5555-5b4c-99a7-21b72889da54','Peucedanum ambiguum (Nuttall) Nuttall ex Torrey & A. Gray','(Nuttall) Nuttall ex Torrey & A. Gray','SPECIES','','Peucedanum','','ambiguum','','','',NULL,'Nuttall','','Torrey & A. Gray','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10057','','','Lomatium macrocarpum var. ellipticum (Torrey & A. Gray) Jepson',1,'Lomatium macrocarpum ellipticum','Lomatium macrocarpum var. ellipticum','Lomatium macrocarp elliptic',3,0,'','','Torrey|A. Gray|Jepson','85eb3354-195b-5bd1-8ff5-66fc8f3e23b4','Lomatium macrocarpum var. ellipticum (Torrey & A. Gray) Jepson','(Torrey & A. Gray) Jepson','VARIETY','','Lomatium','','macrocarpum','ellipticum','','',NULL,'Jepson','','','','','Torrey & A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10062','','','Lomatium angustatum (J.M. Coulter & Rose) H. St.John',1,'Lomatium angustatum','Lomatium angustatum','Lomatium angustat',2,0,'','','J. M. Coulter|Rose|H. St. John','bedc21a3-be6f-5a63-aea4-edf29c215abc','Lomatium angustatum (J.M. Coulter & Rose) H. St.John','(J.M. Coulter & Rose) H. St.John','SPECIES','','Lomatium','','angustatum','','','',NULL,'H. St. John','','','','','J. M. Coulter & Rose','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10071','','','Musineon trachyspermum Nuttall',1,'Musineon trachyspermum','Musineon trachyspermum','Musineon trachysperm',2,0,'','','Nuttall','1f69605c-2594-510a-b4b4-b30f15e762f0','Musineon trachyspermum Nuttall','Nuttall','SPECIES','','Musineon','','trachyspermum','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10076','','','Osmorhiza aristata var. brevistylis (de Candolle) B. Boivin',1,'Osmorhiza aristata brevistylis','Osmorhiza aristata var. brevistylis','Osmorhiza aristat breuistyl',3,0,'','','de Candolle|B. Boivin','dc5254f9-8c86-5699-8ce3-3aaf38965ca2','Osmorhiza aristata var. brevistylis (de Candolle) B. Boivin','(de Candolle) B. Boivin','VARIETY','','Osmorhiza','','aristata','brevistylis','','',NULL,'B. Boivin','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10080','','','Osmorhiza aristata var. longistylis (Torrey) B. Boivin',1,'Osmorhiza aristata longistylis','Osmorhiza aristata var. longistylis','Osmorhiza aristat longistyl',3,0,'','','Torrey|B. Boivin','f260b65b-9ceb-525e-9cb1-d2c0c62f849e','Osmorhiza aristata var. longistylis (Torrey) B. Boivin','(Torrey) B. Boivin','VARIETY','','Osmorhiza','','aristata','longistylis','','',NULL,'B. Boivin','','','','','Torrey','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10083','','','Osmorhiza chilensis var. purpurea (J.M. Coulter & Rose) B. Boivin',1,'Osmorhiza chilensis purpurea','Osmorhiza chilensis var. purpurea','Osmorhiza chilens purpure',3,0,'','','J. M. Coulter|Rose|B. Boivin','277c251c-49e1-55de-ab62-1948379f32eb','Osmorhiza chilensis var. purpurea (J.M. Coulter & Rose) B. Boivin','(J.M. Coulter & Rose) B. Boivin','VARIETY','','Osmorhiza','','chilensis','purpurea','','',NULL,'B. Boivin','','','','','J. M. Coulter & Rose','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10090','','','Sanicula howellii (J.M. Coulter & Rose) Shan & Constance',1,'Sanicula howellii','Sanicula howellii','Sanicula howell',2,0,'','','J. M. Coulter|Rose|Shan|Constance','682863bb-d1b2-59a9-9446-e47560297890','Sanicula howellii (J.M. Coulter & Rose) Shan & Constance','(J.M. Coulter & Rose) Shan & Constance','SPECIES','','Sanicula','','howellii','','','',NULL,'Shan & Constance','','','','','J. M. Coulter & Rose','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10099','','','Sium cicutifolium Schrank',1,'Sium cicutifolium','Sium cicutifolium','Sium cicutifoli',2,0,'','','Schrank','2f373b39-a543-51fd-b33e-ebfe38f7ff61','Sium cicutifolium Schrank','Schrank','SPECIES','','Sium','','cicutifolium','','','',NULL,'','','','','','Schrank','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10104','','','Apocynum androsaemifolium var. pumilum Gray',1,'Apocynum androsaemifolium pumilum','Apocynum androsaemifolium var. pumilum','Apocynum androsaemifoli pumil',3,0,'','','Gray','76cb9c83-aeb2-50d3-9248-c0a488074121','Apocynum androsaemifolium var. pumilum Gray','Gray','VARIETY','','Apocynum','','androsaemifolium','pumilum','','',NULL,'','','','','','Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10108','','','Apocynum cannabinum var. glaberrimum A. de Candolle',1,'Apocynum cannabinum glaberrimum','Apocynum cannabinum var. glaberrimum','Apocynum cannabin glaberrim',3,0,'','','A. de Candolle','8c123114-d3b0-569f-a970-c754256c446a','Apocynum cannabinum var. glaberrimum A. de Candolle','A. de Candolle','VARIETY','','Apocynum','','cannabinum','glaberrimum','','',NULL,'','','','','','A. de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10112','','','Vaccinium mucronatum Linnaeus',1,'Vaccinium mucronatum','Vaccinium mucronatum','Vaccinium mucronat',2,0,'','','Linnaeus','abf1f2a8-5ff8-57a8-9f7e-5c72a77f0f40','Vaccinium mucronatum Linnaeus','Linnaeus','SPECIES','','Vaccinium','','mucronatum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10123','','','Dracontinum foetidum Linnaeus',1,'Dracontinum foetidum','Dracontinum foetidum','Dracontinum foetid',2,0,'','','Linnaeus','ec6795b3-9a84-592e-82f7-15f5c90f732f','Dracontinum foetidum Linnaeus','Linnaeus','SPECIES','','Dracontinum','','foetidum','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10127','','','Asarum acuminatum (Ashe) E.P. Bicknell',1,'Asarum acuminatum','Asarum acuminatum','Asarum acuminat',2,0,'','','Ashe|E. P. Bicknell','36a04151-eeef-53ad-bddb-875fcdb945ff','Asarum acuminatum (Ashe) E.P. Bicknell','(Ashe) E.P. Bicknell','SPECIES','','Asarum','','acuminatum','','','',NULL,'E. P. Bicknell','','','','','Ashe','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10132','','','Asarum rubrocinctum Peattie',1,'Asarum rubrocinctum','Asarum rubrocinctum','Asarum rubrocinct',2,0,'','','Peattie','27639e07-3936-5b7b-8dc9-91f399c97a2f','Asarum rubrocinctum Peattie','Peattie','SPECIES','','Asarum','','rubrocinctum','','','',NULL,'','','','','','Peattie','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10137','','','Asclepias syriaca var. kansana (Vail) E.J. Palmer & Steyermark',1,'Asclepias syriaca kansana','Asclepias syriaca var. kansana','Asclepias syriac kansan',3,0,'','','Vail|E. J. Palmer|Steyermark','51d8688d-7e85-5e0f-a772-ba47bf1bb925','Asclepias syriaca var. kansana (Vail) E.J. Palmer & Steyermark','(Vail) E.J. Palmer & Steyermark','VARIETY','','Asclepias','','syriaca','kansana','','',NULL,'E. J. Palmer & Steyermark','','','','','Vail','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10144','','','Cynanchum nigrum (Linnaeus) Persoon nom. illeg.',4,'','','',NULL,NULL,'','','','','Cynanchum nigrum (Linnaeus) Persoon nom. illeg.','(Linnaeus) Persoon nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10151','','','Camassia quamash subsp. teapeae (H. St.John) H. St.John',1,'Camassia quamash teapeae','Camassia quamash subsp. teapeae','Camassia quamash teape',3,0,'','','H. St. John','9a466f29-7340-5b66-b3cf-1b6492eb7f3e','Camassia quamash subsp. teapeae (H. St.John) H. St.John','(H. St.John) H. St.John','SUBSPECIES','','Camassia','','quamash','teapeae','','',NULL,'H. St. John','','','','','H. St. John','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10153','','','Camassia teapeae St.John',1,'Camassia teapeae','Camassia teapeae','Camassia teape',2,0,'','','St. John','dec9deb3-0c76-55ac-809b-91643bc3b81d','Camassia teapeae St.John','St.John','SPECIES','','Camassia','','teapeae','','','',NULL,'','','','','','St. John','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10163','','','Camassia esculenta (Ker Gawler) B.L. Robinson nom. illeg.',4,'','','',NULL,NULL,'','','','','Camassia esculenta (Ker Gawler) B.L. Robinson nom. illeg.','(Ker Gawler) B.L. Robinson nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10170','','','Scilla esculenta Ker Gawler',1,'Scilla esculenta','Scilla esculenta','Scilla esculent',2,0,'','','Ker Gawler','98138e04-c400-59ce-a0af-f96027172d12','Scilla esculenta Ker Gawler','Ker Gawler','SPECIES','','Scilla','','esculenta','','','',NULL,'','','','','','Ker Gawler','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10177','','','Smilacina canadensis (Desfontaines) Pursh',1,'Smilacina canadensis','Smilacina canadensis','Smilacina canadens',2,0,'','','Desfontaines|Pursh','c64cfef7-ee4a-5d9d-bffc-d1f73f7ddf86','Smilacina canadensis (Desfontaines) Pursh','(Desfontaines) Pursh','SPECIES','','Smilacina','','canadensis','','','',NULL,'Pursh','','','','','Desfontaines','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10182','','','Smilacina amplexicaulis Nuttall',1,'Smilacina amplexicaulis','Smilacina amplexicaulis','Smilacina amplexicaul',2,0,'','','Nuttall','183dc4a1-0705-50ab-8a24-fe828019e46b','Smilacina amplexicaulis Nuttall','Nuttall','SPECIES','','Smilacina','','amplexicaulis','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10185','','','Vagnera pallescens Greene',1,'Vagnera pallescens','Vagnera pallescens','Vagnera pallescens',2,0,'','','Greene','35c85646-ba22-56da-81a9-cb112d9ecbd0','Vagnera pallescens Greene','Greene','SPECIES','','Vagnera','','pallescens','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10189','','','Smilacina ciliata Desfontaines',1,'Smilacina ciliata','Smilacina ciliata','Smilacina ciliat',2,0,'','','Desfontaines','ffc55663-a0d4-5534-b2c8-47bd601d7abe','Smilacina ciliata Desfontaines','Desfontaines','SPECIES','','Smilacina','','ciliata','','','',NULL,'','','','','','Desfontaines','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10194','','','Vagnera racemosa (Linnaeus) Morong ex Kearney',2,'Vagnera racemosa','Vagnera racemosa','Vagnera racemos',2,0,'','','Linnaeus|Morong|Kearney','ced425e6-acae-533a-99be-6c66ef37f5e3','Vagnera racemosa (Linnaeus) Morong ex Kearney','(Linnaeus) Morong ex Kearney','SPECIES','','Vagnera','','racemosa','','','',NULL,'Morong','','Kearney','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10198','','','Convallaria stellata Linnaeus',1,'Convallaria stellata','Convallaria stellata','Convallaria stellat',2,0,'','','Linnaeus','11d9a269-abf4-5cc6-8670-e489fe04f7c4','Convallaria stellata Linnaeus','Linnaeus','SPECIES','','Convallaria','','stellata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10203','','','Tovaria sessilifolia Baker',1,'Tovaria sessilifolia','Tovaria sessilifolia','Tovaria sessilifol',2,0,'','','Baker','b2bc5c72-37b3-57ec-9f35-26e42c280a3e','Tovaria sessilifolia Baker','Baker','SPECIES','','Tovaria','','sessilifolia','','','',NULL,'','','','','','Baker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10208','','','Vagnera angustifolia Rafinesque',1,'Vagnera angustifolia','Vagnera angustifolia','Vagnera angustifol',2,0,'','','Rafinesque','becdcd22-7d62-5bf9-a052-24da9e4aba2f','Vagnera angustifolia Rafinesque','Rafinesque','SPECIES','','Vagnera','','angustifolia','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10212','','','Vagnera stellata (Linnaeus) Morong',1,'Vagnera stellata','Vagnera stellata','Vagnera stellat',2,0,'','','Linnaeus|Morong','9bdbd5ff-331d-5e42-9927-3f2d76ff7fe7','Vagnera stellata (Linnaeus) Morong','(Linnaeus) Morong','SPECIES','','Vagnera','','stellata','','','',NULL,'Morong','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10217','','','Tovaria trifolia (Linnaeus) Necker ex Baker',2,'Tovaria trifolia','Tovaria trifolia','Tovaria trifol',2,0,'','','Linnaeus|Necker|Baker','c6c57e97-0674-5c37-8d46-d0bae8d70f42','Tovaria trifolia (Linnaeus) Necker ex Baker','(Linnaeus) Necker ex Baker','SPECIES','','Tovaria','','trifolia','','','',NULL,'Necker','','Baker','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10222','','','Polygonatum canaliculatum auct. non (Muhlenberg ex Willdenow) Pursh',4,'','','',NULL,NULL,'','','','','Polygonatum canaliculatum auct. non (Muhlenberg ex Willdenow) Pursh','auct. non (Muhlenberg ex Willdenow) Pursh','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10223','','','Polygonatum commutatum (Schultes f.) A. Dietrich',1,'Polygonatum commutatum','Polygonatum commutatum','Polygonatum commutat',2,0,'','','Schultes fil.|A. Dietrich','216901fc-aa7b-54f4-8de1-7d8071be5eed','Polygonatum commutatum (Schultes f.) A. Dietrich','(Schultes f.) A. Dietrich','SPECIES','','Polygonatum','','commutatum','','','',NULL,'A. Dietrich','','','','','Schultes fil.','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10228','','','Triteleia howellii (S. Watson) Greene',1,'Triteleia howellii','Triteleia howellii','Triteleia howell',2,0,'','','S. Watson|Greene','68bd3d41-ddb2-5ed7-b37e-187a22b6a010','Triteleia howellii (S. Watson) Greene','(S. Watson) Greene','SPECIES','','Triteleia','','howellii','','','',NULL,'Greene','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10234','','','Asplenium platyneuron var. bacculum-rubrum (Fernald) Fernald',1,'Asplenium platyneuron bacculum-rubrum','Asplenium platyneuron var. bacculum-rubrum','Asplenium platyneuron bacculum-rubr',3,0,'','','Fernald','b2ce148f-9a49-50a4-8670-3e6a50f903bd','Asplenium platyneuron var. bacculum-rubrum (Fernald) Fernald','(Fernald) Fernald','VARIETY','','Asplenium','','platyneuron','bacculum-rubrum','','',NULL,'Fernald','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10244','','','Achillea millefolium var. nigrescens E. Meyer',1,'Achillea millefolium nigrescens','Achillea millefolium var. nigrescens','Achillea millefoli nigrescens',3,0,'','','E. Meyer','0120a817-9d7c-59a4-956d-3a30fd41abd8','Achillea millefolium var. nigrescens E. Meyer','E. Meyer','VARIETY','','Achillea','','millefolium','nigrescens','','',NULL,'','','','','','E. Meyer','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10250','','','Achillea multiflora Hooker',1,'Achillea multiflora','Achillea multiflora','Achillea multiflor',2,0,'','','Hooker','8e1959ad-98e4-55a7-af5a-0937c25d5eae','Achillea multiflora Hooker','Hooker','SPECIES','','Achillea','','multiflora','','','',NULL,'','','','','','Hooker','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10256','','','Eupatorium rugosum Houttuyn',1,'Eupatorium rugosum','Eupatorium rugosum','Eupatorium rugos',2,0,'','','Houttuyn','4102fad9-f708-5277-9252-497c05edcbf4','Eupatorium rugosum Houttuyn','Houttuyn','SPECIES','','Eupatorium','','rugosum','','','',NULL,'','','','','','Houttuyn','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10261','','','Eupatorium urticifolium var. tomentellum B.L. Robinson',1,'Eupatorium urticifolium tomentellum','Eupatorium urticifolium var. tomentellum','Eupatorium urticifoli tomentell',3,0,'','','B. L. Robinson','ab5aa4b9-62cd-5cee-9fdf-4441cb3a79b4','Eupatorium urticifolium var. tomentellum B.L. Robinson','B.L. Robinson','VARIETY','','Eupatorium','','urticifolium','tomentellum','','',NULL,'','','','','','B. L. Robinson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10266','','','Agoseris gaspensis Fernald',1,'Agoseris gaspensis','Agoseris gaspensis','Agoseris gaspens',2,0,'','','Fernald','c9eb561c-4478-5e28-9121-ea62be2754a1','Agoseris gaspensis Fernald','Fernald','SPECIES','','Agoseris','','gaspensis','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10272','','','Agoseris arachnoidea Rydberg',1,'Agoseris arachnoidea','Agoseris arachnoidea','Agoseris arachnoide',2,0,'','','Rydberg','33c260eb-d10b-5b7e-9760-f532c1eef0af','Agoseris arachnoidea Rydberg','Rydberg','SPECIES','','Agoseris','','arachnoidea','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10278','','','Agoseris nana Rydberg',1,'Agoseris nana','Agoseris nana','Agoseris nan',2,0,'','','Rydberg','ef7e26eb-6905-5145-91b2-f626abcc727e','Agoseris nana Rydberg','Rydberg','SPECIES','','Agoseris','','nana','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10280','','','Agoseris subalpina G.N. Jones',1,'Agoseris subalpina','Agoseris subalpina','Agoseris subalpin',2,0,'','','G. N. Jones','8c142d9d-6221-57b2-a246-559ac059635a','Agoseris subalpina G.N. Jones','G.N. Jones','SPECIES','','Agoseris','','subalpina','','','',NULL,'','','','','','G. N. Jones','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10286','','','Agoseris glauca subsp. scorzonerifolia (Schrader) Piper',1,'Agoseris glauca scorzonerifolia','Agoseris glauca subsp. scorzonerifolia','Agoseris glauc scorzonerifol',3,0,'','','Schrader|Piper','b37b43eb-3f20-5885-8244-dbf4837a8d36','Agoseris glauca subsp. scorzonerifolia (Schrader) Piper','(Schrader) Piper','SUBSPECIES','','Agoseris','','glauca','scorzonerifolia','','',NULL,'Piper','','','','','Schrader','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10293','','','Agoseris leontodon var. pygmaea Rydberg',1,'Agoseris leontodon pygmaea','Agoseris leontodon var. pygmaea','Agoseris leontodon pygmae',3,0,'','','Rydberg','aee43221-1158-53d8-9438-70441df0a125','Agoseris leontodon var. pygmaea Rydberg','Rydberg','VARIETY','','Agoseris','','leontodon','pygmaea','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10295','','','Agoseris pubescens Rydberg',1,'Agoseris pubescens','Agoseris pubescens','Agoseris pubescens',2,0,'','','Rydberg','41cb9f84-84c6-5d45-b829-8e461166ac65','Agoseris pubescens Rydberg','Rydberg','SPECIES','','Agoseris','','pubescens','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10299','','','Agoseris vestita Greene',1,'Agoseris vestita','Agoseris vestita','Agoseris uestit',2,0,'','','Greene','daae298b-50c6-5fa9-bde8-c8cef46f7d0f','Agoseris vestita Greene','Greene','SPECIES','','Agoseris','','vestita','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10303','','','Agoseris lapathifolia Greene',1,'Agoseris lapathifolia','Agoseris lapathifolia','Agoseris lapathifol',2,0,'','','Greene','2e04eb46-f3f7-5f31-925a-849526a3184b','Agoseris lapathifolia Greene','Greene','SPECIES','','Agoseris','','lapathifolia','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10312','','','Agoseris heterophylla subsp. normalis Piper',1,'Agoseris heterophylla normalis','Agoseris heterophylla subsp. normalis','Agoseris heterophyll normal',3,0,'','','Piper','12b7c174-0f28-50e2-9c64-43f36c6ed60a','Agoseris heterophylla subsp. normalis Piper','Piper','SUBSPECIES','','Agoseris','','heterophylla','normalis','','',NULL,'','','','','','Piper','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10318','','','Agoseris tenuifolia (A. Gray) Rydberg',1,'Agoseris tenuifolia','Agoseris tenuifolia','Agoseris tenuifol',2,0,'','','A. Gray|Rydberg','f3df89bf-aa10-5fa0-ae30-28442dd95afa','Agoseris tenuifolia (A. Gray) Rydberg','(A. Gray) Rydberg','SPECIES','','Agoseris','','tenuifolia','','','',NULL,'Rydberg','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10325','','','Centaurea moschata Linnaeus',1,'Centaurea moschata','Centaurea moschata','Centaurea moschat',2,0,'','','Linnaeus','2f3f71b5-9397-5e2e-8aec-125a89814aab','Centaurea moschata Linnaeus','Linnaeus','SPECIES','','Centaurea','','moschata','','','',NULL,'','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10331','','','Ambrosia monophylla (Walter) Rydberg',1,'Ambrosia monophylla','Ambrosia monophylla','Ambrosia monophyll',2,0,'','','Walter|Rydberg','bc2e5c2c-4fa1-58a5-9dc2-4edd93dea6a0','Ambrosia monophylla (Walter) Rydberg','(Walter) Rydberg','SPECIES','','Ambrosia','','monophylla','','','',NULL,'Rydberg','','','','','Walter','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10340','','','Ambrosia rugelii Rydberg',1,'Ambrosia rugelii','Ambrosia rugelii','Ambrosia rugel',2,0,'','','Rydberg','e51fd21f-4e5d-53b7-b9a5-e7e646bed8e0','Ambrosia rugelii Rydberg','Rydberg','SPECIES','','Ambrosia','','rugelii','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10342','','','Ambrosia trifida Linnaeus var. trifida',1,'Ambrosia trifida trifida','Ambrosia trifida var. trifida','Ambrosia trifid trifid',3,0,'','','','3c389027-91d3-5c80-9b70-671ba20ba3ae','Ambrosia trifida Linnaeus var. trifida','Linnaeus','VARIETY','','Ambrosia','','trifida','trifida','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10345','','','Ambrosia aptera de Candolle',1,'Ambrosia aptera','Ambrosia aptera','Ambrosia apter',2,0,'','','de Candolle','e2b3eb42-67d1-5430-92d2-86d2b8aebb1d','Ambrosia aptera de Candolle','de Candolle','SPECIES','','Ambrosia','','aptera','','','',NULL,'','','','','','de Candolle','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10351','','','Madia madioides (Nuttall) Greene',1,'Madia madioides','Madia madioides','Madia madioid',2,0,'','','Nuttall|Greene','dda01d60-36eb-5b22-8dd0-346d2140dd29','Madia madioides (Nuttall) Greene','(Nuttall) Greene','SPECIES','','Madia','','madioides','','','',NULL,'Greene','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10357','','','Antennaria alpina var. cana Fernald & Wiegand',1,'Antennaria alpina cana','Antennaria alpina var. cana','Antennaria alpin can',3,0,'','','Fernald|Wiegand','8b5825dd-69f7-56b0-9504-bd5996fe6a21','Antennaria alpina var. cana Fernald & Wiegand','Fernald & Wiegand','VARIETY','','Antennaria','','alpina','cana','','',NULL,'','','','','','Fernald & Wiegand','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10360','','','Antennaria alpina var. glabrata J. Vahl',1,'Antennaria alpina glabrata','Antennaria alpina var. glabrata','Antennaria alpin glabrat',3,0,'','','J. Vahl','a88f35ff-8091-54e5-b130-536a145393ee','Antennaria alpina var. glabrata J. Vahl','J. Vahl','VARIETY','','Antennaria','','alpina','glabrata','','',NULL,'','','','','','J. Vahl','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10362','','','Antennaria alpina var. porsildii (E. Ekman) T.J. Sørensen',1,'Antennaria alpina porsildii','Antennaria alpina var. porsildii','Antennaria alpin porsild',3,0,'','','E. Ekman|T. J. Sørensen','96f64fa8-25d2-5283-ac62-20c54bee8d0a','Antennaria alpina var. porsildii (E. Ekman) T.J. Sørensen','(E. Ekman) T.J. Sørensen','VARIETY','','Antennaria','','alpina','porsildii','','',NULL,'T. J. Sørensen','','','','','E. Ekman','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10371','','','Antennaria brunnescens Fernald',1,'Antennaria brunnescens','Antennaria brunnescens','Antennaria brunnescens',2,0,'','','Fernald','37412061-cd1c-53dd-a0fc-ee651a0175e3','Antennaria brunnescens Fernald','Fernald','SPECIES','','Antennaria','','brunnescens','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10379','','','Antennaria confusa Fernald',1,'Antennaria confusa','Antennaria confusa','Antennaria confus',2,0,'','','Fernald','c58cc02d-0865-586d-b195-1911061317d2','Antennaria confusa Fernald','Fernald','SPECIES','','Antennaria','','confusa','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10387','','','Antennaria media subsp. compacta (Malte) Chmielewski',1,'Antennaria media compacta','Antennaria media subsp. compacta','Antennaria med compact',3,0,'','','Malte|Chmielewski','69fcf035-56c1-5be8-9fc3-db408de77ec8','Antennaria media subsp. compacta (Malte) Chmielewski','(Malte) Chmielewski','SUBSPECIES','','Antennaria','','media','compacta','','',NULL,'Chmielewski','','','','','Malte','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10389','','','Antennaria pedunculata A.E. Porsild',1,'Antennaria pedunculata','Antennaria pedunculata','Antennaria pedunculat',2,0,'','','A. E. Porsild','e6252c25-92e9-50c8-8138-85ef58ddb9ed','Antennaria pedunculata A.E. Porsild','A.E. Porsild','SPECIES','','Antennaria','','pedunculata','','','',NULL,'','','','','','A. E. Porsild','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10397','','','Antennaria anaphaloides var. straminea B. Boivin',1,'Antennaria anaphaloides straminea','Antennaria anaphaloides var. straminea','Antennaria anaphaloid stramine',3,0,'','','B. Boivin','865e5ea0-fe1c-5792-b73d-e7ed218fa93c','Antennaria anaphaloides var. straminea B. Boivin','B. Boivin','VARIETY','','Antennaria','','anaphaloides','straminea','','',NULL,'','','','','','B. Boivin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10400','','','Antennaria acuta Rydberg',1,'Antennaria acuta','Antennaria acuta','Antennaria acut',2,0,'','','Rydberg','284e6b51-e3f7-56a7-986d-008df577a018','Antennaria acuta Rydberg','Rydberg','SPECIES','','Antennaria','','acuta','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10403','','','Antennaria nardina Greene',1,'Antennaria nardina','Antennaria nardina','Antennaria nardin',2,0,'','','Greene','7692bcfe-5b8e-5b9c-b1ec-d9e7edf50fd4','Antennaria nardina Greene','Greene','SPECIES','','Antennaria','','nardina','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10408','','','Antennaria latisquama Piper',1,'Antennaria latisquama','Antennaria latisquama','Antennaria latisquam',2,0,'','','Piper','08f0e2b4-ca74-5576-8db4-f789274b22f1','Antennaria latisquama Piper','Piper','SPECIES','','Antennaria','','latisquama','','','',NULL,'','','','','','Piper','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10413','','','Antennaria friesiana var. beringensis Hultén',1,'Antennaria friesiana beringensis','Antennaria friesiana var. beringensis','Antennaria friesian beringens',3,0,'','','Hultén','9de2b21d-fbc4-5a5f-9b5b-4861462256be','Antennaria friesiana var. beringensis Hultén','Hultén','VARIETY','','Antennaria','','friesiana','beringensis','','',NULL,'','','','','','Hultén','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10420','','','Antennaria canadensis var. spathulata Fernald',1,'Antennaria canadensis spathulata','Antennaria canadensis var. spathulata','Antennaria canadens spathulat',3,0,'','','Fernald','2cee8409-7444-551b-ba2b-bc5ef3d32a39','Antennaria canadensis var. spathulata Fernald','Fernald','VARIETY','','Antennaria','','canadensis','spathulata','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10424','','','Antennaria spathulata (Fernald) Fernald',1,'Antennaria spathulata','Antennaria spathulata','Antennaria spathulat',2,0,'','','Fernald','8dd09339-42c4-5a5f-bd7f-1b77e83cd50c','Antennaria spathulata (Fernald) Fernald','(Fernald) Fernald','SPECIES','','Antennaria','','spathulata','','','',NULL,'Fernald','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10429','','','Antennaria neodioica subsp. howellii (Greene) R. J. Bayer',1,'Antennaria neodioica howellii','Antennaria neodioica subsp. howellii','Antennaria neodioic howell',3,0,'','','Greene|R. J. Bayer','88239f13-b838-584b-a6c3-95a437a59222','Antennaria neodioica subsp. howellii (Greene) R. J. Bayer','(Greene) R. J. Bayer','SUBSPECIES','','Antennaria','','neodioica','howellii','','',NULL,'R. J. Bayer','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10434','','','Antennaria neglecta var. neodioica (Greene) Cronquist',1,'Antennaria neglecta neodioica','Antennaria neglecta var. neodioica','Antennaria neglect neodioic',3,0,'','','Greene|Cronquist','5cf40591-8e4f-59c2-9df7-6a15103ff309','Antennaria neglecta var. neodioica (Greene) Cronquist','(Greene) Cronquist','VARIETY','','Antennaria','','neglecta','neodioica','','',NULL,'Cronquist','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10435','','','Antennaria neodioica Greene subsp. neodioica',1,'Antennaria neodioica neodioica','Antennaria neodioica subsp. neodioica','Antennaria neodioic neodioic',3,0,'','','','e10b39d7-5e5b-55ff-b1bc-35e10de6a3fb','Antennaria neodioica Greene subsp. neodioica','Greene','SUBSPECIES','','Antennaria','','neodioica','neodioica','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10440','','','Antennaria neodioica Greene var. neodioica',1,'Antennaria neodioica neodioica','Antennaria neodioica var. neodioica','Antennaria neodioic neodioic',3,0,'','','','28ab5ab9-3327-5b23-b0b8-9cfd0a3dd3a0','Antennaria neodioica Greene var. neodioica','Greene','VARIETY','','Antennaria','','neodioica','neodioica','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10442','','','Antennaria neodioica var. typica Fernald nom. inval.',4,'','','',NULL,NULL,'','','','','Antennaria neodioica var. typica Fernald nom. inval.','Fernald nom. inval.','VARIETY','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10449','','','Antennaria neodioica subsp. petaloidea (Fernald) R. J. Bayer & Stebbins',1,'Antennaria neodioica petaloidea','Antennaria neodioica subsp. petaloidea','Antennaria neodioic petaloide',3,0,'','','Fernald|R. J. Bayer|Stebbins','41a572cb-5a58-5a8a-9e2a-b07888e762ce','Antennaria neodioica subsp. petaloidea (Fernald) R. J. Bayer & Stebbins','(Fernald) R. J. Bayer & Stebbins','SUBSPECIES','','Antennaria','','neodioica','petaloidea','','',NULL,'R. J. Bayer & Stebbins','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10457','','','Antennaria stenolepis Greene',1,'Antennaria stenolepis','Antennaria stenolepis','Antennaria stenolep',2,0,'','','Greene','096aae70-cc04-5d48-ae39-83d60c7f7cad','Antennaria stenolepis Greene','Greene','SPECIES','','Antennaria','','stenolepis','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10461','','','Antennaria microcephala A. Gray',1,'Antennaria microcephala','Antennaria microcephala','Antennaria microcephal',2,0,'','','A. Gray','e4e8c546-e12d-5574-98f7-3c4eea9cd041','Antennaria microcephala A. Gray','A. Gray','SPECIES','','Antennaria','','microcephala','','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10468','','','Antennaria microphylla var. solstitialis (Lunell) Lunell',1,'Antennaria microphylla solstitialis','Antennaria microphylla var. solstitialis','Antennaria microphyll solstitial',3,0,'','','Lunell','8e94736d-87b6-58bb-ab08-899b9811ad6a','Antennaria microphylla var. solstitialis (Lunell) Lunell','(Lunell) Lunell','VARIETY','','Antennaria','','microphylla','solstitialis','','',NULL,'Lunell','','','','','Lunell','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10481','','','Antennaria tansleyi Polunin',1,'Antennaria tansleyi','Antennaria tansleyi','Antennaria tansley',2,0,'','','Polunin','7a32c254-dc45-5326-aca8-223085e9aad9','Antennaria tansleyi Polunin','Polunin','SPECIES','','Antennaria','','tansleyi','','','',NULL,'','','','','','Polunin','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10485','','','Antennaria monocephala var. latisquamea Hultén',1,'Antennaria monocephala latisquamea','Antennaria monocephala var. latisquamea','Antennaria monocephal latisquame',3,0,'','','Hultén','295939d2-be7a-5032-8785-112098d3a54e','Antennaria monocephala var. latisquamea Hultén','Hultén','VARIETY','','Antennaria','','monocephala','latisquamea','','',NULL,'','','','','','Hultén','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10487','','','Antennaria exilis Greene',1,'Antennaria exilis','Antennaria exilis','Antennaria exil',2,0,'','','Greene','67a6268e-fbae-5a0a-8516-b67be2e2aba8','Antennaria exilis Greene','Greene','SPECIES','','Antennaria','','exilis','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10492','','','Antennaria neglecta var. campestris (Rydberg) Steyermark',1,'Antennaria neglecta campestris','Antennaria neglecta var. campestris','Antennaria neglect campestr',3,0,'','','Rydberg|Steyermark','5217af42-7bc9-5c45-8790-7b899e31740c','Antennaria neglecta var. campestris (Rydberg) Steyermark','(Rydberg) Steyermark','VARIETY','','Antennaria','','neglecta','campestris','','',NULL,'Steyermark','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10496','','','Antennaria campestris Rydberg',1,'Antennaria campestris','Antennaria campestris','Antennaria campestr',2,0,'','','Rydberg','2977aa25-997b-5baa-aa67-7b0a8b986c4e','Antennaria campestris Rydberg','Rydberg','SPECIES','','Antennaria','','campestris','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10502','','','Antennaria longifolia Greene',1,'Antennaria longifolia','Antennaria longifolia','Antennaria longifol',2,0,'','','Greene','e651aad2-055b-51d3-976f-20d2069649aa','Antennaria longifolia Greene','Greene','SPECIES','','Antennaria','','longifolia','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10507','','','Antennaria fallax Greene',1,'Antennaria fallax','Antennaria fallax','Antennaria fallax',2,0,'','','Greene','49a7ffdf-3116-542c-92d4-264057258060','Antennaria fallax Greene','Greene','SPECIES','','Antennaria','','fallax','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10512','','','Antennaria arnoglossa var. ambigens Greene',1,'Antennaria arnoglossa ambigens','Antennaria arnoglossa var. ambigens','Antennaria arnogloss ambigens',3,0,'','','Greene','0dc03ac8-843d-5911-9ed9-72f6ad76ba49','Antennaria arnoglossa var. ambigens Greene','Greene','VARIETY','','Antennaria','','arnoglossa','ambigens','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10517','','','Antennaria fallax var. calophylla (Greene) Fernald',1,'Antennaria fallax calophylla','Antennaria fallax var. calophylla','Antennaria fallax calophyll',3,0,'','','Greene|Fernald','046be729-0553-572f-a126-6cf41ef20d28','Antennaria fallax var. calophylla (Greene) Fernald','(Greene) Fernald','VARIETY','','Antennaria','','fallax','calophylla','','',NULL,'Fernald','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10526','','','Antennaria umbellata Greene',1,'Antennaria umbellata','Antennaria umbellata','Antennaria umbellat',2,0,'','','Greene','d992ec69-7b84-5a32-ba21-5591d6cb7baa','Antennaria umbellata Greene','Greene','SPECIES','','Antennaria','','umbellata','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10530','','','Antennaria plantaginifolia var. arnoglossa (Greene) Cronquist',1,'Antennaria plantaginifolia arnoglossa','Antennaria plantaginifolia var. arnoglossa','Antennaria plantaginifol arnogloss',3,0,'','','Greene|Cronquist','00df3dad-9f20-5cee-9bab-e9b0d7981958','Antennaria plantaginifolia var. arnoglossa (Greene) Cronquist','(Greene) Cronquist','VARIETY','','Antennaria','','plantaginifolia','arnoglossa','','',NULL,'Cronquist','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10538','','','Antennaria latisquamea Greene',1,'Antennaria latisquamea','Antennaria latisquamea','Antennaria latisquame',2,0,'','','Greene','adfa0fbc-7b13-5c73-bcbd-450e571b3e07','Antennaria latisquamea Greene','Greene','SPECIES','','Antennaria','','latisquamea','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10540','','','Antennaria recurva Greene',1,'Antennaria recurva','Antennaria recurva','Antennaria recuru',2,0,'','','Greene','b3d9e996-9634-52ad-93f0-72eaae103935','Antennaria recurva Greene','Greene','SPECIES','','Antennaria','','recurva','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10545','','','Antennaria caroliniana Rydberg',1,'Antennaria caroliniana','Antennaria caroliniana','Antennaria carolinian',2,0,'','','Rydberg','9e6f96bd-172f-5d86-ba0a-1c3522ae959d','Antennaria caroliniana Rydberg','Rydberg','SPECIES','','Antennaria','','caroliniana','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10548','','','Antennaria nemoralis Greene',1,'Antennaria nemoralis','Antennaria nemoralis','Antennaria nemoral',2,0,'','','Greene','3aaa92dc-4df6-5d4e-955d-3ef71c30da0c','Antennaria nemoralis Greene','Greene','SPECIES','','Antennaria','','nemoralis','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10551','','','Antennaria media subsp. ciliata E.E. Nelson',1,'Antennaria media ciliata','Antennaria media subsp. ciliata','Antennaria med ciliat',3,0,'','','E. E. Nelson','7b413d41-495e-5b23-b5ef-6bad80e49a1f','Antennaria media subsp. ciliata E.E. Nelson','E.E. Nelson','SUBSPECIES','','Antennaria','','media','ciliata','','',NULL,'','','','','','E. E. Nelson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10559','','','Antennaria petasites Greene',1,'Antennaria petasites','Antennaria petasites','Antennaria petasit',2,0,'','','Greene','3e74762e-e646-50b5-b022-a751b12b8b8e','Antennaria petasites Greene','Greene','SPECIES','','Antennaria','','petasites','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10566','','','Antennaria rosea var. angustifolia (Rydberg) E.E. Nelson',1,'Antennaria rosea angustifolia','Antennaria rosea var. angustifolia','Antennaria rose angustifol',3,0,'','','Rydberg|E. E. Nelson','48d1965c-add5-57b3-a29f-232c3ab9bfc8','Antennaria rosea var. angustifolia (Rydberg) E.E. Nelson','(Rydberg) E.E. Nelson','VARIETY','','Antennaria','','rosea','angustifolia','','',NULL,'E. E. Nelson','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10571','','','Antennaria breitungii A.E. Porsild',1,'Antennaria breitungii','Antennaria breitungii','Antennaria breitung',2,0,'','','A. E. Porsild','19975cc8-b652-5ef1-a1c7-ec54793a2881','Antennaria breitungii A.E. Porsild','A.E. Porsild','SPECIES','','Antennaria','','breitungii','','','',NULL,'','','','','','A. E. Porsild','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10577','','','Antennaria incarnata A.E. Porsild',1,'Antennaria incarnata','Antennaria incarnata','Antennaria incarnat',2,0,'','','A. E. Porsild','1451c3f1-7dd6-5af5-a1b8-1abf16728d7b','Antennaria incarnata A.E. Porsild','A.E. Porsild','SPECIES','','Antennaria','','incarnata','','','',NULL,'','','','','','A. E. Porsild','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10582','','','Antennaria sedoides Greene',1,'Antennaria sedoides','Antennaria sedoides','Antennaria sedoid',2,0,'','','Greene','6474f2eb-1546-584d-9146-e3dd2c0b796e','Antennaria sedoides Greene','Greene','SPECIES','','Antennaria','','sedoides','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10588','','','Antennaria albescens (E.E. Nelson) Rydberg',1,'Antennaria albescens','Antennaria albescens','Antennaria albescens',2,0,'','','E. E. Nelson|Rydberg','4edcbb64-fbfd-5ddf-b705-cc0b682c2aa1','Antennaria albescens (E.E. Nelson) Rydberg','(E.E. Nelson) Rydberg','SPECIES','','Antennaria','','albescens','','','',NULL,'Rydberg','','','','','E. E. Nelson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10596','','','Antennaria neglecta var. gaspensis (Fernald) Cronquist',1,'Antennaria neglecta gaspensis','Antennaria neglecta var. gaspensis','Antennaria neglect gaspens',3,0,'','','Fernald|Cronquist','129a0628-455a-5591-bcfa-2704a8fddbad','Antennaria neglecta var. gaspensis (Fernald) Cronquist','(Fernald) Cronquist','VARIETY','','Antennaria','','neglecta','gaspensis','','',NULL,'Cronquist','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10601','','','Antennaria sansonii Greene',1,'Antennaria sansonii','Antennaria sansonii','Antennaria sanson',2,0,'','','Greene','6419e591-b56a-559b-b12e-7b39113d56be','Antennaria sansonii Greene','Greene','SPECIES','','Antennaria','','sansonii','','','',NULL,'','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10605','','','Antennaria alborosea A.E. Porsild ex Porsild',2,'Antennaria alborosea','Antennaria alborosea','Antennaria alborose',2,0,'','','A. E. Porsild|Porsild','afe51729-ee94-5999-9996-510a2ebe3e07','Antennaria alborosea A.E. Porsild ex Porsild','A.E. Porsild ex Porsild','SPECIES','','Antennaria','','alborosea','','','',NULL,'','','','','','A. E. Porsild','','Porsild','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10613','','','Antennaria speciosa E.E. Nelson',1,'Antennaria speciosa','Antennaria speciosa','Antennaria specios',2,0,'','','E. E. Nelson','f9008570-7f49-5e5e-9f4e-39f4bcf50cb4','Antennaria speciosa E.E. Nelson','E.E. Nelson','SPECIES','','Antennaria','','speciosa','','','',NULL,'','','','','','E. E. Nelson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10620','','','Anthemis arvensis var. agrestis (Wallroth) de Candolle',1,'Anthemis arvensis agrestis','Anthemis arvensis var. agrestis','Anthemis aruens agrest',3,0,'','','Wallroth|de Candolle','a70b3878-228e-5843-a6bf-6b13fc03029f','Anthemis arvensis var. agrestis (Wallroth) de Candolle','(Wallroth) de Candolle','VARIETY','','Anthemis','','arvensis','agrestis','','',NULL,'de Candolle','','','','','Wallroth','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10623','','','Anthemis foetida Lamarck nom. illeg.',4,'','','',NULL,NULL,'','','','','Anthemis foetida Lamarck nom. illeg.','Lamarck nom. illeg.','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10627','','','Leucanthemum arcticum (Linnaeus) de Candolle',1,'Leucanthemum arcticum','Leucanthemum arcticum','Leucanthemum arctic',2,0,'','','Linnaeus|de Candolle','d8083d36-f433-54f9-9847-61901e505181','Leucanthemum arcticum (Linnaeus) de Candolle','(Linnaeus) de Candolle','SPECIES','','Leucanthemum','','arcticum','','','',NULL,'de Candolle','','','','','Linnaeus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10633','','','Arctium vulgare (Hill) Druce',1,'Arctium vulgare','Arctium vulgare','Arctium uulgar',2,0,'','','Hill|Druce','198980dd-bf03-5a6d-954e-427a5d60797f','Arctium vulgare (Hill) Druce','(Hill) Druce','SPECIES','','Arctium','','vulgare','','','',NULL,'Druce','','','','','Hill','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10639','','','Arnica alpina subsp. iljnii Maguire',1,'Arnica alpina iljnii','Arnica alpina subsp. iljnii','Arnica alpin ilin',3,0,'','','Maguire','d44469d7-7d7a-5f4c-91d0-f18e7315bb41','Arnica alpina subsp. iljnii Maguire','Maguire','SUBSPECIES','','Arnica','','alpina','iljnii','','',NULL,'','','','','','Maguire','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10646','','','Arnica sornborgeri Fernald',1,'Arnica sornborgeri','Arnica sornborgeri','Arnica sornborger',2,0,'','','Fernald','59088c1d-6b7f-50d3-a287-d714e75fa4fc','Arnica sornborgeri Fernald','Fernald','SPECIES','','Arnica','','sornborgeri','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10649','','','Arnica alpina var. vestita Hultén',1,'Arnica alpina vestita','Arnica alpina var. vestita','Arnica alpin uestit',3,0,'','','Hultén','b4009ae2-bfac-5275-b907-b0a2b9beceed','Arnica alpina var. vestita Hultén','Hultén','VARIETY','','Arnica','','alpina','vestita','','',NULL,'','','','','','Hultén','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10652','','','Arnica chamissonis var. interior Maguire',1,'Arnica chamissonis interior','Arnica chamissonis var. interior','Arnica chamisson interior',3,0,'','','Maguire','d604332c-b820-57a9-b806-f6cd4fb2cdf0','Arnica chamissonis var. interior Maguire','Maguire','VARIETY','','Arnica','','chamissonis','interior','','',NULL,'','','','','','Maguire','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10659','','','Arnica foliosa Nuttall',1,'Arnica foliosa','Arnica foliosa','Arnica folios',2,0,'','','Nuttall','20a0713f-3b5e-54bb-a477-79774a936a53','Arnica foliosa Nuttall','Nuttall','SPECIES','','Arnica','','foliosa','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10663','','','Arnica fulgens Pursh var. fulgens',1,'Arnica fulgens fulgens','Arnica fulgens var. fulgens','Arnica fulgens fulgens',3,0,'','','','bd70b6d0-5eae-53c5-b9c0-b8682a7c349d','Arnica fulgens Pursh var. fulgens','Pursh','VARIETY','','Arnica','','fulgens','fulgens','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10671','','','Arnica louiseana var. pilosa Maguire',1,'Arnica louiseana pilosa','Arnica louiseana var. pilosa','Arnica louisean pilos',3,0,'','','Maguire','c915f84c-b693-5d4d-b9cd-b816032b1a30','Arnica louiseana var. pilosa Maguire','Maguire','VARIETY','','Arnica','','louiseana','pilosa','','',NULL,'','','','','','Maguire','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10674','','','Arnica amplexicaulis subsp. prima (Maguire) Maguire',1,'Arnica amplexicaulis prima','Arnica amplexicaulis subsp. prima','Arnica amplexicaul prim',3,0,'','','Maguire','f7b54f80-b6b4-5c24-8cf8-0c041463c89a','Arnica amplexicaulis subsp. prima (Maguire) Maguire','(Maguire) Maguire','SUBSPECIES','','Arnica','','amplexicaulis','prima','','',NULL,'Maguire','','','','','Maguire','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10681','','','Arnica lessingii subsp. norbergii Hultén & Maguire',1,'Arnica lessingii norbergii','Arnica lessingii subsp. norbergii','Arnica lessing norberg',3,0,'','','Hultén|Maguire','60bf72b0-593f-57fe-b06a-1dee0d931f4b','Arnica lessingii subsp. norbergii Hultén & Maguire','Hultén & Maguire','SUBSPECIES','','Arnica','','lessingii','norbergii','','',NULL,'','','','','','Hultén & Maguire','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10687','','','Arnica chionopappa Fernald',1,'Arnica chionopappa','Arnica chionopappa','Arnica chionopapp',2,0,'','','Fernald','a09c1c78-70bf-5206-b386-46ad25b75d05','Arnica chionopappa Fernald','Fernald','SPECIES','','Arnica','','chionopappa','','','',NULL,'','','','','','Fernald','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10693','','','Arnica latifolia var. viscidula A. Gray',1,'Arnica latifolia viscidula','Arnica latifolia var. viscidula','Arnica latifol uiscidul',3,0,'','','A. Gray','533ea548-7651-521a-8be7-62c6899c8714','Arnica latifolia var. viscidula A. Gray','A. Gray','VARIETY','','Arnica','','latifolia','viscidula','','',NULL,'','','','','','A. Gray','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10695','','','Arnica parryi var. sonnei (Greene) Cronquist',1,'Arnica parryi sonnei','Arnica parryi var. sonnei','Arnica parry sonne',3,0,'','','Greene|Cronquist','3c6c6d9e-cc90-5d71-bbd0-904d2af18a10','Arnica parryi var. sonnei (Greene) Cronquist','(Greene) Cronquist','VARIETY','','Arnica','','parryi','sonnei','','',NULL,'Cronquist','','','','','Greene','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10702','','','Mesadenia plantaginea Rafinesque',1,'Mesadenia plantaginea','Mesadenia plantaginea','Mesadenia plantagine',2,0,'','','Rafinesque','4d6557f6-9d80-588f-9bd2-f8b89d194565','Mesadenia plantaginea Rafinesque','Rafinesque','SPECIES','','Mesadenia','','plantaginea','','','',NULL,'','','','','','Rafinesque','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10704','','','Senecio nuttallii Schultz-Bipontinus',1,'Senecio nuttallii','Senecio nuttallii','Senecio nuttall',2,0,'','','Schultz-Bipontinus','290c6b16-b0a3-5d4d-a6d7-054b3aa30c6f','Senecio nuttallii Schultz-Bipontinus','Schultz-Bipontinus','SPECIES','','Senecio','','nuttallii','','','',NULL,'','','','','','Schultz-Bipontinus','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10708','','','Artemisia chamomilla C. Winkler',1,'Artemisia chamomilla','Artemisia chamomilla','Artemisia chamomill',2,0,'','','C. Winkler','710f99cf-dfba-5bc9-93e6-e9342d137e5c','Artemisia chamomilla C. Winkler','C. Winkler','SPECIES','','Artemisia','','chamomilla','','','',NULL,'','','','','','C. Winkler','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10715','','','Artemisia purshii Besser',1,'Artemisia purshii','Artemisia purshii','Artemisia pursh',2,0,'','','Besser','d326055c-2225-5146-91a1-ddd4d27dd49d','Artemisia purshii Besser','Besser','SPECIES','','Artemisia','','purshii','','','',NULL,'','','','','','Besser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10721','','','Artemisia camporum Rydberg',1,'Artemisia camporum','Artemisia camporum','Artemisia campor',2,0,'','','Rydberg','a19ca514-b3ca-55b4-b1d8-0e8e1b3305cc','Artemisia camporum Rydberg','Rydberg','SPECIES','','Artemisia','','camporum','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10726','','','Artemisia forwoodii S. Watson',1,'Artemisia forwoodii','Artemisia forwoodii','Artemisia forwood',2,0,'','','S. Watson','6e921872-5999-5cef-98aa-ddc6b1676481','Artemisia forwoodii S. Watson','S. Watson','SPECIES','','Artemisia','','forwoodii','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10736','','','Artemisia desertorum var. douglasiana Besser ex Hooker',2,'Artemisia desertorum douglasiana','Artemisia desertorum var. douglasiana','Artemisia desertor douglasian',3,0,'','','Besser|Hooker','b7fbcea8-1cee-59b4-a687-c9517e12e93c','Artemisia desertorum var. douglasiana Besser ex Hooker','Besser ex Hooker','VARIETY','','Artemisia','','desertorum','douglasiana','','',NULL,'','','','','','Besser','','Hooker','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10742','','','Artemisia dracunculina S. Watson',1,'Artemisia dracunculina','Artemisia dracunculina','Artemisia dracunculin',2,0,'','','S. Watson','9fde4eb8-1b67-5844-a1ba-891e4d7cd333','Artemisia dracunculina S. Watson','S. Watson','SPECIES','','Artemisia','','dracunculina','','','',NULL,'','','','','','S. Watson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10746','','','Artemisia glauca auct. non Pallas ex Willdenow',4,'','','',NULL,NULL,'','','','','Artemisia glauca auct. non Pallas ex Willdenow','auct. non Pallas ex Willdenow','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10750','','','Artemisia frigida var. gmeliniana (Besser) Besser',1,'Artemisia frigida gmeliniana','Artemisia frigida var. gmeliniana','Artemisia frigid gmelinian',3,0,'','','Besser','b5b27b69-f670-50dd-8c40-93a6aa35b822','Artemisia frigida var. gmeliniana (Besser) Besser','(Besser) Besser','VARIETY','','Artemisia','','frigida','gmeliniana','','',NULL,'Besser','','','','','Besser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10754','','','Artemisia furcata var. heterophylla (Besser) Hultén',1,'Artemisia furcata heterophylla','Artemisia furcata var. heterophylla','Artemisia furcat heterophyll',3,0,'','','Besser|Hultén','9bfdb54e-6e67-5483-a9cb-924f8da9ceca','Artemisia furcata var. heterophylla (Besser) Hultén','(Besser) Hultén','VARIETY','','Artemisia','','furcata','heterophylla','','',NULL,'Hultén','','','','','Besser','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10761','','','Artemisia laciniatiformis Komarov',1,'Artemisia laciniatiformis','Artemisia laciniatiformis','Artemisia laciniatiform',2,0,'','','Komarov','a6be6b06-a391-5533-a454-23cfb0ba6c5a','Artemisia laciniatiformis Komarov','Komarov','SPECIES','','Artemisia','','laciniatiformis','','','',NULL,'','','','','','Komarov','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10763','','','Artemisia ludoviciana var. integrifolia A. Nelson',1,'Artemisia ludoviciana integrifolia','Artemisia ludoviciana var. integrifolia','Artemisia ludouician integrifol',3,0,'','','A. Nelson','099abdc2-6683-5ea3-adf0-862dc267615e','Artemisia ludoviciana var. integrifolia A. Nelson','A. Nelson','VARIETY','','Artemisia','','ludoviciana','integrifolia','','',NULL,'','','','','','A. Nelson','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10769','','','Artemisia candicans Rydberg',1,'Artemisia candicans','Artemisia candicans','Artemisia candicans',2,0,'','','Rydberg','bc6b93d6-2a5b-5259-9bbc-24e931c0a103','Artemisia candicans Rydberg','Rydberg','SPECIES','','Artemisia','','candicans','','','',NULL,'','','','','','Rydberg','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10773','','','Artemisia incompta Nuttall',1,'Artemisia incompta','Artemisia incompta','Artemisia incompt',2,0,'','','Nuttall','a86429e7-2e2b-5eec-a44f-57c5a16036c4','Artemisia incompta Nuttall','Nuttall','SPECIES','','Artemisia','','incompta','','','',NULL,'','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10778','','','Artemisia ludoviciana var. gnaphalodes (Nuttall) Torrey & A. Gray',1,'Artemisia ludoviciana gnaphalodes','Artemisia ludoviciana var. gnaphalodes','Artemisia ludouician gnaphalod',3,0,'','','Nuttall|Torrey|A. Gray','ed8c087b-9aa4-588f-bb50-bb9abe84c443','Artemisia ludoviciana var. gnaphalodes (Nuttall) Torrey & A. Gray','(Nuttall) Torrey & A. Gray','VARIETY','','Artemisia','','ludoviciana','gnaphalodes','','',NULL,'Torrey & A. Gray','','','','','Nuttall','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10787','','','Artemisia lindheimeriana Scheele',1,'Artemisia lindheimeriana','Artemisia lindheimeriana','Artemisia lindheimerian',2,0,'','','Scheele','e5603d32-9a3e-5f88-b8b8-05f0c16bf5ab','Artemisia lindheimeriana Scheele','Scheele','SPECIES','','Artemisia','','lindheimeriana','','','',NULL,'','','','','','Scheele','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10792','','','Artemisia rhizomata A. Nelson',1,'Artemisia rhizomata','Artemisia rhizomata','Artemisia rhizomat',2,0,'','','A. Nelson','38751203-fb67