PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE version (id TEXT NOT NULL) STRICT;
INSERT INTO version VALUES('v0.3.33');
CREATE TABLE metadata (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__doi TEXT DEFAULT '',
  col__title TEXT NOT NULL,
  col__alias TEXT DEFAULT '',
  col__description TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__version TEXT DEFAULT '',
  col__keywords TEXT DEFAULT '',
  col__geographic_scope TEXT DEFAULT '',
  col__taxonomic_scope TEXT DEFAULT '',
  col__temporal_scope TEXT DEFAULT '',
  col__confidence INTEGER DEFAULT NULL,
  col__completeness INTEGER DEFAULT NULL,
  col__license TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__logo TEXT DEFAULT '',
  col__label TEXT DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__private INTEGER DEFAULT NULL -- bool 
) STRICT;
INSERT INTO metadata VALUES(1,'','USDA National Plant Germplasm System','GRIN Plant Taxonomy',replace('The USDA National Plant Germplasm System (NPGS), often referred to through its associated database, the Germplasm Resources Information Network (GRIN), is a vital resource for preserving and providing access to plant genetic diversity.\n\nThe Germplasm Resources Information Network (GRIN) provides information about the United States Department of Agriculture (USDA national collections of animal, microbial, and plant genetic resources (germplasm) important for food and agricultural production. GRIN documents these collections through informational pages, searchable databases, and links to USDA-ARS projects that curate the collections. ','\n',char(10)),'2025-05-21','','','','','',0,0,'','https://npgsweb.ars-grin.gov/gringlobal/taxon/abouttaxonomy','','','',0);
CREATE TABLE contact (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT NOT NULL,
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE editor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE creator (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE publisher (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT DEFAULT '',
  col__family TEXT DEFAULT '',
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE contributor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE source (
  col__id TEXT PRIMARY KEY,
  col__metadata_id INTEGER DEFAULT 1,
  col__type TEXT DEFAULT '',
  col__title TEXT DEFAULT '',
  col__authors TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__isbn TEXT DEFAULT ''
) STRICT;
CREATE TABLE author (
  col__id TEXT PRIMARY KEY,
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__alternative_id TEXT DEFAULT '', -- sep by ','
  col__given TEXT DEFAULT '',
  col__family TEXT NOT NULL,
  -- f. for filius,  Jr., etc
  col__suffix TEXT DEFAULT '',
  col__abbreviation_botany TEXT DEFAULT '',
  col__alternative_names TEXT DEFAULT '', -- separated by '|'
  col__sex_id TEXT REFERENCES sex DEFAULT '',
  col__country TEXT DEFAULT '',
  col__birth TEXT DEFAULT '',
  col__birth_place TEXT DEFAULT '',
  col__death TEXT DEFAULT '',
  col__affiliation TEXT DEFAULT '',
  col__interest TEXT DEFAULT '',
  col__reference_id TEXT DEFAULT '', -- sep by ','
  -- url
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE reference (
  col__id TEXT PRIMARY KEY,
  col__alternative_id TEXT DEFAULT '', -- sep by ',', scope:id, id, URI/URN
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__type_id TEXT REFERENCES reference_type DEFAULT '',
  -- author/s in format of either
  -- family1, given1; family2, given2; ..
  -- or
  -- given1 family1, given2 family2, ...
  col__author TEXT DEFAULT '',
  col__author_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__title TEXT DEFAULT '',
  col__title_short TEXT DEFAULT '',
  -- container_author is an author or a parent volume (book, journal) 
  col__container_author TEXT DEFAULT '',
  -- container_title of the parent container
  col__container_title TEXT DEFAULT '',
  -- container_title_short of the parent container
  col__container_title_short TEXT DEFAULT '',
  col__issued TEXT DEFAULT '', -- yyyy-mm-dd
  col__accessed TEXT DEFAULT '', -- yyyy-mm-dd
  -- collection_title of the parent volume
  col__collection_title TEXT DEFAULT '',
  -- collection_editor of the parent volume
  col__collection_editor TEXT DEFAULT '',
  col__volume TEXT DEFAULT '',
  col__issue TEXT DEFAULT '',
  -- edition number
  col__edition TEXT DEFAULT '',
  -- page number
  col__page TEXT DEFAULT '',
  col__publisher TEXT DEFAULT '',
  col__publisher_place TEXT DEFAULT '',
  -- version of the reference
  col__version TEXT DEFAULT '',
  col__isbn TEXT DEFAULT '',
  col__issn TEXT DEFAULT '',
  col__doi TEXT DEFAULT '',
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
INSERT INTO reference VALUES('5333e83f-92a0-5ff9-8c57-08b8eccdfc95','','','C. S. Sargent, Pl. wilson. 1:122.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fc428a4-72d3-595f-b4b6-acd427c1513d','','','Linnaea 12:491.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('884db266-fee1-5b2b-aaf6-da935e4a0db2','','','Proc. Biol. Soc. Washington 29:10.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0c5311d-14f7-5e68-b06e-2ca1d0a56b03','','','Fl. helv. 1:287.  1828, nom. inval.  "<I>Festuca rubra commutata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8aaafcb8-3447-5eed-a750-b5803003bef7','','','Repert. Spec. Nov. Regni Veg. 2:22.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53012b42-260c-59fd-a0ae-64d44dc8ad1d','','','Revis. tribe Antirrhineae 321.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4955afd9-942a-5577-ad3f-3292fb7f4dbf','','','J. B. Stevenson, Sp. Rhodod. 836.  1930 (Notes Roy. Bot. Gard. Edinburgh 16:192.  1931)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93f86099-6d90-5943-8e41-d54e85fc8184','','','Enum. pl. 1:44.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ddc34f6-1c42-5044-8a8d-9600b2f7f4f7','','','Věstn. Tiflissk. Bot. Sada 18:20.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('680a78d8-af4d-518f-8da7-a095d5bb150d','','','Brittonia 15:95.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7abf934-d94d-55a5-b37c-ee60a2ebdb1f','','','Webbia 16:65, fig. 48.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7db60735-7831-5ce1-9398-6d70d0753b8a','','','D. Oliver, Fl. trop. Afr. 2:572.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3a9584a-babf-5ed7-82a0-b8b175dd4b11','','','Phytologia 86:123.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('230457e5-fd08-5c4c-8801-2995d32ac2e6','','','Syst. nat. ed. 12, 2:300.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79f1cd66-2fa3-5470-b3ca-b178df921de3','','','Philipp. J. Sci., C 7:394.  1913 ("1912")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5aaf2d5f-1e28-5094-aef4-ad06058f1dab','','','Techn. Bull. U.S.D.A. 1268:31, fig. 9.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95e00b64-85d4-5f8d-9ab2-a8ea4a099143','','','Bot. Jahrb. Syst. 26:518.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89ddb396-a0b3-51fa-b6a2-83e2ddaf4756','','','Hist. pl. Guiane suppl. 4, t. 370.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('734f030f-97dc-5936-93eb-9027aa42504a','','','Adansonia 6:179.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ede29d30-2712-5886-b3f1-0a5d443932e5','','','Med. Repos. ser. 2, 5:354.  1808 "<I>Potamogiton diversifolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7491213-256f-5c56-a888-488efd2f124e','','','Mant. 1:348.  1822 "<I>Anthodus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c96968fb-5376-512a-a0de-81b3250d005d','','','Anales Jard. Bot. Madrid 40:71.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fae9ec2-b5c7-53ed-b680-4adb2d268a13','','','Tabl. encycl. 1:161.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12605356-cf18-580d-882e-a323b8bc96e3','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 7:139[folio]; 7:182[quarto].  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6dbf64b-5f2a-55e1-96b9-155dd00c3c91','','','C. L. Hitchcock et al., Univ. Washington Publ. Biol. 17(3):445.  1961 (Vasc. pl. Pacif. N.W.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c9d8da3-419e-5f15-a05f-b3046b3bedae','','','Nouv. Arch. Mus. Hist. Nat. 10:178.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b71956d-ac09-55d8-bcab-9634626a2adc','','','Repert. Spec. Nov. Regni Veg. 10:228.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05d7a783-25ba-5eef-acd5-9cba609ae1c8','','','Tea Sci. Res. J. (China) 1983:16.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4222db46-f279-51e9-9fa3-f4220562a6ea','','','Biol. cent.-amer., Bot. 3:361.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3a9c541-08a5-5973-a546-01fa3b10cdb7','','','Icon. pl. rar. 2: t. 386.  1791 Jan-Jun ("1786-1793"); Collectanea 3:244.  1791 late ("1789")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8e99dbe-38f9-5dd4-abc3-52f4aac23247','','','J. Bot. 13:331, t. 170.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df48b555-9519-500e-a5e4-584dcc24ec52','','','Syst. nat. 1:448.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a580d310-3c0a-58a2-8cfe-9186581dc981','','','Caesalpinia 148.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b273c7b4-228c-5a8b-830f-f226cdd6e694','','','Methodus 155.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e882a209-67f9-5f58-8159-5bdfb5825336','','','W. G. Walpers, Repert. bot. syst. 5:594.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe1b03e5-e9b3-52d2-96a6-a5010feac97a','','','Hist. nat. palm. 3:320.  1853 "<I>miraguano</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d02bbc97-4972-595c-894a-5fb2141f7d2c','','','Rhododendron Year Book 6:71.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cbea065-e7bf-513e-a543-e2a0a3ec85d3','','','Cyclamen Soc. J. 14:50.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45bfa550-8079-5646-85d6-8008b425f222','','','Gard. dict. ed. 8: <I>Hedysarum</I> no. 17.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be745dc5-c13b-5ac8-948c-3ec38353d23c','','','Fl. bor.-amer. 1:264.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b93f0cf-23df-5471-a9d8-5eb94b98cd4b','','','Pl. Espagne n. 5378, in sched.  1925 (Mem. Real Acad. Ci. Barcelona ser. 3, 20(14):8.  1928)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17e4f563-b48d-5ceb-90d4-61a558e2bc7c','','','A. Guillemin et al., Fl. Seneg. tent. 1:249.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6860e43-3de0-5f55-913b-8edbd11ff54f','','','Bull. Div. Agrostol. U.S.D.A. 21:27.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24d3c8c3-9385-5ecc-bd6a-112842759a65','','','Proc. Roy. Soc. W. Australia 22:126.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecbcf3a1-a1ef-59a7-94bc-dacfb5033d82','','','N. Wallich, Pl. asiat. rar. 1:64.  1830 (non Cav. 1802)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2addd93b-3288-5684-9e39-03d833bba69c','','','J. G. C. Lehmann, Pl. Preiss. 1:72.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30c43f83-a0d7-5de5-8b62-00ad0d24100c','','','L. Diels, Bot. Jahrb. Syst. 29:465.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2a0b4d5-9153-5571-956c-f8a2a3e03ce9','','','Bothalia 7:452.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b3cde26-3f62-52bd-a5d7-07a1ce3a24c0','','','Mém. Soc. Acad. Maine Loire 20:167.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6e05ed8-e9e5-5e76-887b-68bd78514696','','','Sp. gram. stipac. 164.  1842 (Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 7,5(1-2):164.  1843)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51027101-a6b0-5f21-a60d-148653d151d8','','','Bot. Jahrb. Syst. 84:358.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('660cb4d3-6323-5356-a63f-16f91ae3906e','','','Pl. Coromandel 1: t. 22.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d2d01c1-dc29-50e1-b0eb-0739a948991e','','','Anales Hist. Nat. 1:226.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f701d39b-df15-5f5d-8e0e-750268844698','','','Kongl. Vetensk. Acad. Nya Handl. 31:190.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('639e4e3b-f483-5292-a1af-29a27e17a0c7','','','Arq. Bot. Estado São Paulo 1:54, t. 67.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf324215-7de1-534b-b4a1-9ae2306a563c','','','Fl. ind. 1:448.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f6b8263-71af-5e17-b198-e7ba3ed60884','','','Trans. Roy. Soc. South Australia 69:310.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36049503-e08b-5750-af8e-792657312f96','','','Sp. pl. 2:1025.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c45b401f-d9fc-5d58-9afa-511ef17a30f5','','','Orchid Rev. 81:220.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08578a9b-3669-5de5-bf33-0d3264998a9c','','','Bot. Zeitung (Berlin) 2:356.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('810127cb-61df-5562-806a-57756cf8809f','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:218[folio]; 6:276[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9769d0d4-3333-5d49-bb8e-58b1cfce867c','','','Prodr. 2:131.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a81fc0db-02c8-5d2b-9a83-6b439c727e20','','','Suppl. prodr. fl. Nov. Holl. 19.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d60c8d9b-3f90-53a4-b89b-5000d4b75cf4','','','Symb. antill. 5:93.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7935bb65-76ef-5643-86ff-69b7fc85521b','','','Austrobaileya 2:358.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1aa39ae-7555-5fe5-8f36-a74af803a964','','','Fl. helv. 3:439.  1828 "<I>Nupharis Spenneriani</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0459e17f-5073-59d9-ac9c-ef1ee544ca8f','','','Eriogonum 74.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b06532f-ab7a-55f7-8952-49f4657d33ae','','','Mem. New York Bot. Gard. 74(1):57.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64a042f6-893d-5fe3-9918-aac3b7f8dfd9','','','Bull. Soc. Bot. France 58(Mém. 3f):561.  1911, nom. inval. (Plantae Brasiliae centralis a Glaziou lectae)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('797a625f-293c-5d1e-8820-d4c4dd07e8b7','','','Fl. sicul. syn. 2:292.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf820037-ba43-5bca-803a-37fb971492d8','','','Icon. Pl. 2: t. 198.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2034210a-867b-5f94-9278-29598abe2bc1','','','Mem. New York Bot. Gard. 10(4):67, t. 46.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('487713e2-2a49-538b-a1e1-f260c1207e51','','','Austral. J. Bot. 36:129.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5e4ba1a-8914-516c-b453-17ef0a0184b3','','','A. Gray, Syn. fl. N. Amer. 1(1):417.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66bc5720-4176-5b16-a233-5865c98b21da','','','Meded. Rijks-Herb. 1:2.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3127c76f-5704-5938-9ea5-f2c9d3a1df57','','','J. J. Roemer & J. A. Schultes, Syst. veg. 2:401.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29655b16-3371-504b-8d2a-6abd925bb4f6','','','Elench. pl. 34.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f01e832-ea73-53c6-b0ae-1f2cfda84376','','','Syn. pl. succ. 195.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e31fb76-efe2-5527-ae5b-63d230f20a2b','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 9:264.  1859 (Prim. fl. amur.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20f4810d-77a0-59c4-b36f-dc28d21cc83b','','','Hort. kew. 2:244.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8c19de4-0b53-5d72-9bd1-b9f5c5aa077b','','','Martens, Gartenbohnen 62, t. 4, fig. 14-15.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad21a41a-68d5-5742-b637-7964802280f6','','','Taxon 27:515.  1979 ("1978")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7c641a1-9a50-537c-8e6a-a506f7393466','','','Pacif. Railr. Rep. 4(5,1):130.  1857 ("1856")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f6abf39-3bd1-5efa-989f-25efc3f2cb24','','','Allg. Bot. Z. Syst. 12:54.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80db913c-ebfd-51fa-bb3d-29e7cc75834a','','','Fl. trop. Afr. 2:346.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('488148e0-7890-57d6-914b-b6826940090a','','','Ann. Sci. Nat., Bot. sér. 3, 19:254.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acb392dd-a47a-5bd3-89a5-ac9765857d16','','','J. Bot. Agric. 1:77.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65c9605a-b877-56f1-b381-073b51beff7f','','','Phytologia 12:250.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84c68400-3421-52c0-93cd-6938de02cee6','','','Trans. Linn. Soc. London 30:253.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d71c5cc-6924-5f99-9a92-93538ba882a7','','','Austrobaileya 5:163.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5493b1cb-48b3-555c-b831-cbf9b920cd48','','','Gymnocalycium 4:48.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfaedd0a-1226-516d-887c-7dce5b9b2745','','','Bot. cult. 3:282.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77066592-9625-5b24-9da2-3b941fe13351','','','Sp. pl. 1:507.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9a7aecc-66db-57e3-9827-20765d24cb91','','','Bot. Misc. 3:310.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54bf4a20-345e-5d2b-8cde-428cb3029582','','','Hickenia 1:58, fig. 1.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('995b8327-09fb-5918-8b25-c400743edc2f','','','Prodr. fl. nepal. 73.  1825 Jan 26 - Feb 1','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d97f4920-cb90-54a5-9e4f-30641e17a7d1','','','Monogr. Festuc. eur. 154.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('863cb619-25aa-5c95-8d5e-9580fcdba57c','','','Trans. Roy. Soc. South Africa 5(1):30, t. 10-11.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('938ca2fa-42e9-519c-83bf-c34d2cc279b8','','','Sp. pl. 3(3):1911.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7a6d061-093c-53a2-9cf5-865cbcde7e61','','','Acta Univ. Lund., 2, 2:20.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9235545-968e-52a7-aef5-7afdb9a62cde','','','Bull. Mus. Hist. Nat. (Paris) 9:173, t. 4.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a055488e-3eee-550d-bdb6-fe5665abfef0','','','Fl. reipubl. popularis sin. 38:76.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c0799de-9fbc-54bc-8962-c5048171561f','','','Frugm. 5:88.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9522af6-ebd0-53e2-8c7a-9d8a04166cd7','','','Trans. Linn. Soc. London 30:150.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73976767-4acb-54e1-a2e7-32ef6d93ffa7','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 21:357.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d95ecf2-2bde-58f6-a87b-675d9142a4f9','','','Cat. 90:10.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ef26141-9e41-55af-a0f8-144fe1ac32db','','','J. Adelaide Bot. Gard. 7:314.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81fc7bcb-3268-537a-bf67-2bccc2b49a05','','','Man. orchid. pl. 7:35.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad9fe67c-d040-5227-a45d-3cee99a3f66c','','','Univ. Calif. Publ. Bot. 55:59.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8866fb8d-a321-5224-b48a-848092141c9a','','','Sp. pl. ed. 2, 2:975.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30a7644b-0c75-55f1-977c-093b3f00ce47','','','Descr. pl. nouv. ad t. 41.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('664563dd-ccc1-56b9-802f-a8e0db3c91b9','','','Prodr. fl. Ind. orient. 449.  1834 (p. 208: "<I>Notonia wightii</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55b9fb82-728f-58f2-afce-a1991dcfc303','','','Descr. pl. aliq. nov. 26, t. 1.  1766','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('826966c1-fc9f-5e22-bb09-33cf78d2a2f3','','','Vilm. Blumengärtn. ed. 3, 1:172.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c048375-141d-5134-9ceb-23df089e2465','','','Repert. Spec. Nov. Regni Veg. 8:22.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('252e7e0f-ee71-5f94-a638-30af3fc49fb0','','','Sp. gram. stipac. 80.  1842 (Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 7,5(1-2):80.  1843)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('392f9497-4a3a-5968-b371-f3be7bdba101','','','Rev. gen. <I>Camellia</I> 139.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e67e43e-8e95-5cf7-bca0-901222f368fb','','','Notizbl. Bot. Gart. Berlin-Dahlem 10:438.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc23f647-d452-50fc-9feb-d00aad953d5f','','','Autik. bot. 193.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a54ff82-4018-5c5b-9f8f-d6fecb68661d','','','Fl. flumin. 250.  1829 ("1825"); icon. 6: t. 43.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcf566bf-27dc-5d37-b0cb-3d8dd1f2bb57','','','A. Rees, Cycl. 36: <I>Vaccinium</I> no. 7.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2db28092-f665-517e-acb2-924e1f43b710','','','Traité gén. conif. 279.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7043ec6-2844-5649-95f1-650c665da8c1','','','Mém. Acad. Roy. Sci. (Turin) 5:411.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85cfe7e7-4ac7-59c2-9b39-c5ab17294c49','','','Bot. Centralbl. 26:163.  1886 (S. Sci. Rec. n. s. 2(2):?, in obs.  1886 Feb.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79bd6742-0d09-5ead-bbd2-bcb70b669862','','','Nomencl. bot. ed. 2, 2:54.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('608dc317-fa4b-5a4c-9536-289364bb35c4','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 6:675.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9a3b3fe-9b25-57c6-995a-2f4ddbe659be','','','J. voy. n.-w. passage, Bot. 191.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00305e30-7bdc-5a75-99d4-bc34c51ab0a0','','','Fl. N. Amer. 1:250.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63324f16-34db-5a2f-bd4c-0a01f4b0caf8','','','Ill. Himal. pl. t. 12.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae6afa29-14ee-518f-804a-2e7986b6944a','','','Bull. Herb. Boissier sér. 2, 7:247.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfb25f9d-a33a-58e1-9a4a-440ba81edcff','','','Kew Bull. 1950:510.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16449ddd-0f79-5712-a87f-da60c57e38e8','','','J. Bot. Suppl. 62:27.  1924 "<I>albo-rubra</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f108b2d3-0b3b-5f70-9208-0bc4ebd2f644','','','Trudy Bot. Inst. (Baku) 2:307.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa841cc3-5aca-507a-ba3a-5f4813a44396','','','Proc. Amer. Acad. Arts 18:194.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d887525b-0a8b-5364-93b0-07b1b3c2fc06','','','J. Bot. Res. Inst. Texas 5:469.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c5e7a73-ac86-5b08-a3a3-7ca45ffcb7bf','','','Kew Bull. 13:52.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58ef90c6-ebfc-5055-9520-32a40bf86550','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:173[folio]; 3:221[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f359e75-75f5-5471-8748-2ae3386236eb','','','H. G. A. Engler & C. G. O. Drude, Veg. Erde 9(III,1):524.  1915 (Pflanzenw. Afrikas)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('003457d7-e554-5432-86be-493ef5bf2a3a','','','Anz. Akad. Wiss. Wien, Math.-Naturwiss. Kl. 61:163.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('937e6dfa-c17f-5d91-acdb-e2c786aa4a8a','','','J. F. Royle, Ill. bot. Himal. Mts. 1(11):388.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6abafad-0950-5d58-827c-8fc9ae6bfc82','','','Fl. Brit. India 6:353.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd6c38af-aa8e-5a8c-baa6-d34ce74cb4c8','','','Rhodora 35:192.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d238d63a-cd24-50ab-adb7-631c2e8b3ead','','','Folia Geobot. Phytotax. 3:407.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('081ce022-1ae4-5b52-911d-44b02e240073','','','J. Jap. Bot. 42:347.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('877c80df-9644-598e-ae02-ca6248a1c054','','','Succulentes (Monte Carlo) 1996(4):10.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68fff276-7c3c-575c-8f22-5126e5808d88','','','C. F. P. von Martius, Fl. bras. 6(4):318.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa8157a5-58b3-5434-a28a-0e2382b51ddb','','','Aliso 5:345.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34faf2b9-c4c3-534c-a3bd-94ce0d0bc530','','','Bull. Herb. Boissier 3:36.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1fa6e05-2334-5e92-9aec-bdb4fdbf903b','','','Aliso 28:66-67.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4a98214-9941-586a-8e3e-acc04437f61f','','','J. Matsumura, Icon. pl. koisik. 4:75, t. 250.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7366d75-c76f-5f2d-a7ee-def22c7a95bb','','','Natl. Cact. Succ. J. 28:4.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('924db38c-5185-5f68-ab8e-4d6ccd52064a','','','Amer. J. Bot. 48:572.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aeaf7c3b-33d6-5d85-81f0-cc4f3f049dde','','','J. Bot. Agric. 3:19.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f244f9a-81b4-593a-8d9e-768f1379434e','','','Verz. Cact. 8.  1867 (Sencke ex J. N. Haage, Preisverzeichniss Cact. Succ. 23.  1860, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c0dc278-de93-566f-b129-f985c1b11c66','','','Ann. Soc. Linn. Lyon sér. 2, 17:147.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29b7d61e-cf1c-5618-82a1-9aa0e6548053','','','Monatsber. Königl. Preuss. Akad. Wiss. Berlin 1857:47.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4654aee4-59e0-533c-9730-6afb76a90df5','','','Arq. Serv. Florest. 2:22, t. 2.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('145e4e85-40e9-5935-a6b1-8c561a5f6c07','','','Proc. Amer. Acad. Arts 6:76.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0123a7c2-61c7-57a1-84a1-9b644848760b','','','J. C. Röhling, Deutschl. Fl. ed. 3, 5:199.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73eb4317-a01e-5981-8ac2-e5967e270cf5','','','Fl. bor.-amer. 2:150.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43e68992-f026-581b-836e-6233ed273d11','','','J. Linn. Soc., Bot. 22:455.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d488cb77-6713-5741-bf70-bc9172a42bea','','','W. J. Hooker, Fl. bor.-amer. 2:6.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37307f2b-4d9d-5bbb-a361-79081d82dc2d','','','Fl. ind. ed. 1832, 3:384.  1832 (Hort. bengal. 57.  1814, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95ca12aa-cca7-5815-952a-6a26adee6ccc','','','Prodr. 4:245.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57c3b256-6755-5b33-928b-49646f2b4771','','','Brittonia 47:165.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a4ee49b-469e-56f0-8f05-a83323582899','','','Natur Naturschutz Mecklenburg 13:21.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('242c2ae2-9abd-5c66-9d42-9daab822754f','','','Pl. asiat. rar. 3:63.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f16b3da4-a7b1-5cc4-a878-2115de3f5a6c','','','Index sem. hort. petrop. 1866:77.  1867 "<I>viridi-striata</I>" (Siebold ex André, Ill. Hort. 19:319, t. 108.  1872)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b60bfaf-e96f-505b-840f-63359257b80d','','','Bot. Reg. 8: t. 663.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b533f51-1bf3-519b-bfbf-a5243a2ed7da','','','Bull. Bur. Forest. Philipp. Islands 35:57.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de0c06cd-e901-5bfe-b3d4-2e812dcd8f2d','','','Castanea 10:45.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3787f9f5-b35d-57c2-a827-8a470fdd72ee','','','Pflanzenr. IV. 23F(Heft 73):173.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2f8163d-e6fe-555a-bb01-12d3f30a5483','','','Sert. angl. 9.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fe9b5c6-50ae-5116-9481-b8cb5fe65b99','','','Mém. Soc. Phys. Genève 9:281, t. 4, fig. 2.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce0469fa-c95b-5497-ab9f-06d9a8c5d50b','','','Phytologia 58:380.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fab6f751-bdc7-5749-9a1d-cd02b4133663','','','Bot. voy. Sulphur 136.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18922853-ce74-5e10-befa-3976acab7ad7','','','Bergens Mus. Årbok 2:46.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc684f6e-493f-5fc5-8dd2-a928c7fda6cc','','','Contr. fl. atl. 40.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cba7793c-2188-523b-9a34-1eb8845d523a','','','Bull. Soc. Bot. France 57:55.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82eeb159-3105-5008-bbde-607f8fb71a5c','','','Beih. Bot. Centralbl., Abt. 2, 49:472.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8723fd3e-e045-5eb7-a310-5ff631123c1e','','','W. T. Thiselton-Dyer, Fl. cap. 7:654.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f06a7f8-146c-5104-b2b5-9dc70821ab0c','','','Fl. Brit. W. I. 226.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22fb282e-812c-54d3-9b6d-e950360ffd83','','','Vict. Naturalist 73:173.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('101f4c95-8696-5391-ac8d-eba17721e3b7','','','Proc. Davenport Acad. Nat. Sci. 4:39.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78e18ed5-51a4-52dd-ad1e-16c4a7b3b008','','','Abh. Königl. Akad. Wiss. Berlin 1816-1817:370.  1819 (Allg. Uebers. Fl. Canar. Ins.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f43a8632-6480-597f-a400-164cc713f246','','','Kulturnaya Fl. SSSR 1:309.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ff29bd1-9491-568f-8eda-0639099af2fd','','','Bull. Torrey Bot. Club 20:476.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('327659bc-ac87-51c4-afa0-2d6e8c979d1e','','','N. Amer. Sylv. 1:48.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('130f6bdb-97b7-5455-92cb-93521d218fca','','','Observ. bot. 20, t. 2, fig. 2.  1772','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2ac4460-e379-5c2f-9840-c2f6d2039641','','','Sargentia 7:166.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('681c7f80-b5d1-5c23-9459-a7fc2ac87e00','','','Hortus kew. ed. 2, 1:127.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21b6732b-b069-50c1-be93-e05310d39538','','','Proc. Amer. Philos. Soc. 60:33.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce40ec60-58e3-512d-9f04-e78fbd06a07a','','','Pl. Arnem. 2: t. 47.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4847e0d-0b12-50df-9db1-7e087bfa8271','','','Bull. Torrey Bot. Club 31:408.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('467860e4-87ca-5b5f-83b1-5255831c88c1','','','Varied. Trad. Frut. Cuenca Río Segura Cat. Etnobot. 181.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14ad78f4-fe40-55e7-a50a-e94fac4fc1d7','','','J. S. African Bot. 35:19.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5d79747-5829-5d6d-aedc-dcab2c70e683','','','Bull. Charleston Mus. 13:26.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41a18ae1-54ef-5212-bcb1-1fa67645bcfd','','','Syst. nat. ed. 12, 2:246.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbd1938b-fe8b-5593-8479-eabd629ccb77','','','Trans. Linn. Soc. London 17:133.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcca37cf-68fd-5467-855c-ee9e16ba8f48','','','A. Rees, Cycl. 30: <I>Rubus</I> no. 16.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5782252f-4294-5890-b383-83fd3245dc6d','','','Rep. (Annual) Missouri Bot. Gard. 5:99, t. 11.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a3300bc-ef48-52af-9c88-97877bd06674','','','Bull. Assoc. Parcs Bot. France 37:52.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('199086db-4f06-55e5-bedc-5719323e659a','','','Bull. Soc. Bot. France 53:19.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6131b1ea-9eb2-59f1-a0c4-7fb458b915bb','','','Thes. bot. 5, t. 12.  1805-1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4840e1bc-15f6-5a74-8f82-f17e3a294b26','','','N. Amer. fl. 16:40.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74ab6673-851b-5276-a96e-85385e7065f8','','','Syn. pl. 1:174.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab513c8a-5e34-5569-a2ca-71ba1405be36','','','Pl. hort. schoenbr. 1:28, t. 55.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23d46cb8-eb33-5e72-b099-327e58be8903','','','Enumeratio plantarum 236.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d99d917-7519-56be-9a44-31620c68a70b','','','Cact. Succ. J. (Los Angeles) 47:214.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2cecd73-d785-5699-94f4-5a767a13ef22','','','Ann. Sci. Nat., Bot. sér. 4, 11:142.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3275b27d-7def-5608-9c62-afeba30dea2b','','','Trans. Acad. Sci. St. Louis 2:590.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6db9b56-7484-522e-96e4-8bda009c35bb','','','Mitt. Bot. Staatssamml. München 28:372.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74bb7439-d2e7-5fc5-a550-d47bf0e2b426','','','Syn. Stirp. Aragon. 117, t. 8.  1779','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b214bfc-d3c5-561c-9beb-bc321a588449','','','P. M. Zhukovsky, Zemledel''cheskia Turtsiia 705, 805.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b39d3bd-3b66-5bfa-92e0-dd1351847751','','','Beitr. Amarantac. 107.  1825 (Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 13:315.  1826)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3f196bd-e645-594e-8e13-0a1c07c0b818','','','Abh. Naturwiss. Verein Bremen 24:410.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9d15228-2993-549d-accc-6d1175d0733b','','','Syn. mitteleur. Fl. 2(1):679.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d56063f-8432-5dee-bbf8-b73718cd1b9e','','','Taxon 39:609.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62533ef1-8e03-5aa6-b781-19145869503e','','','Linnaea 11:196.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29097583-b997-514d-b42a-d87319d22ac3','','','Notes Roy. Bot. Gard. Edinburgh 42:211.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('960edfa9-d2de-575b-8924-e3922f818573','','','Guihaia 8:129.  1988, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6851d1e-9868-5483-9094-df7db95c7cd8','','','Acta Sci. Nat. Univ. Sunyatseni 20:118.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9c4fcd4-2493-5bb7-be9a-7148c773c4dd','','','F. Mason, Burma ed. W. Theob. 2:451.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3b58d5a-bded-5bf6-9d69-6677cdc2a669','','','Syst. nat. ed. 10, 2:850.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfad5021-d8a3-5d27-925e-bef741449b8a','','','Notes Roy. Bot. Gard. Edinburgh 8:205.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be829d33-61d8-59ff-ae12-af4740591d28','','','Fl. bras. icon. descr. 1:62.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('222e6e6d-4b2c-5673-8b4e-06da473b036d','','','Fl. Neotrop. Monogr. 13:62.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55b68140-6ff3-5f02-b828-444cdc08e16a','','','Kulturnaya Fl. SSSR 1:303.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ae7fdcf-8b2a-515b-a8c3-858430baeb3d','','','Suppl. pl. 206.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('560df4bd-4bce-561c-8964-8d3ca44e1a59','','','Bull. Torrey Bot. Club 35:562.  1909 ("1908"), nom. cons. prop.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49c2e54b-b0c0-5924-af27-c65abc88cdc7','','','Bull. Misc. Inform. Kew 1922:789.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c05186c-781f-50e6-8cd5-42c61c14d722','','','Revista Soc. Geogr. Cuba 4:53.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f024cd0-814e-5586-b372-17687573e290','','','Abh. Königl. Ges. Wiss. Göttingen 24:63.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29163a56-bfb4-5e68-b383-4af376970101','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:225[folio]; 1:283[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('625ccfe5-fdbf-5171-af85-a5d1a0925c15','','','Gentes Herbarum 2:263.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23c3e791-35ca-57da-bf10-9d02051d6a5e','','','Ann. Soc. Sci. Bruxelles 19(2):140.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('247b9e75-e842-55ac-aeed-aa9afd2f91f4','','','Austral. J. Bot. 8:359.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51068d37-fc98-5a3b-91d2-26f05cb605c8','','','Publ. Bur. Sci. Gov. Lab. 35:24.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2958f242-110a-5e82-8286-17027045184a','','','Fl. South. U.S. 318.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b4268fe-5159-58f4-90df-e235dbf382c1','','','W. Aiton, Hort. kew. 2:433.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('805e609b-1c01-5927-b367-8e807c1db3ab','','','Ann. K. K. Naturhist. Hofmus. 22:26.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa3dc1c6-b6b7-596a-9ad6-65db69401b04','','','Bull. Mens. Soc. Linn. Paris 2:1255.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a384647e-9390-5bef-bbbe-f88a2b4c8771','','','Bot. Mag. (Tokyo) 28:26.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('757b7fea-231d-5597-ba96-55a60c03e216','','','Ark. Bot. new ser, 7:100.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79907ebc-34e8-51ce-a2ca-2024dfa8d45b','','','Pl. hartw. 166.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21230a25-62e0-58ae-9566-8973680c10ef','','','W. Roxburgh, Fl. ind. 2:97.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8242d6a5-0f34-5c9e-ab55-479151f2960a','','','Bull. Torrey Bot. Club 37:246.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4e2037b-e06a-580b-bd7d-9b1ba5a1fc20','','','Tea Sci. Res. J. (China) 1983:4.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e4eebf5-e258-5798-a871-7f85d4a28a6a','','','Trans. Linn. Soc. London, Bot. 9:179.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da9e81c5-9c1e-57d6-9f44-9185ab6088f5','','','Ann. Mus. Bot. Lugduno-Batavi 3:158.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e59b2005-1c82-5429-a81c-eb524bd637c0','','','Jaarb. Ned. Dendrol. Ver. 20:81.  1957 "<I>sterniana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e877e4c5-4fc6-557d-bb19-c88452c3dcce','','','Syst. nat. 2:22.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87b5947b-787d-59a0-8f45-64ad46424dc7','','','Prodr. 2:220.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e4351a6-38ff-56f1-ac57-b313ed84db62','','','Revista Pharm., Buenos Aires 3:7.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ad04485-c6d0-5459-b42a-50fa3052de03','','','Ann. Lyceum Nat. Hist. New York 1:67.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11806c9a-df17-5cd1-8e7f-667568e083d7','','','Notes Roy. Bot. Gard. Edinburgh 29:321.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c347569c-8508-59cb-9ca4-3a54941044d4','','','C. A. Patze, E. H. F. Meyer & L. Elkan, Fl. Preussen 91.  1848; Enum. pl. Transsilv. 645.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('488b3e65-b848-5de3-8b3c-fbf5eafa889d','','','A. L. P. P. de Candolle, Prodr. 15(2):159.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e9e7092-37bb-535d-8404-29bd2e36c18a','','','Prodr. 6:115.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d16384a-b977-556e-8901-0d34e678cab2','','','Proc. Linn. Soc. New South Wales 20:541.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05e2e353-6ba2-524d-926c-3542a5b8842d','','','Trans. Linn. Soc. London 30:543.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1dc3226-a24b-56f1-9abc-165a0f685454','','','Kew Bull. 25:31.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6b3fdeb-52ec-50b8-a493-7008ebf5e490','','','Voy. Bonite, Bot. (Atlas) 3: t. 135.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32c7f059-b1ce-5cd0-bca7-028482ddf06a','','','Trans. & Proc. Roy. Soc. South Australia 60:166.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('519599e0-f25a-522a-87b9-ae3b70b8f491','','','Forest fl. N.S.W. 1:131.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f29b0d5-d1f0-5c03-814d-26f9b2fb8e44','','','Sp. pl. 2:746.  1753 "<I>nummularifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c47ba3d2-75b3-5066-9925-b26f1200a1ad','','','sensu Pedley, Austrobaileya 2:345.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95d6a2ee-912b-5646-b05c-d75ff188035f','','','Nat. arr. Brit. pl. 2:269.  1822 ("1821"), nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('464187bd-44f6-53c7-8c17-842bd25eed16','','','Chenop. monogr. enum. 111.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38604ddd-b963-5f00-b334-16200249a7f1','','','Syst. veg. 2:318.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd248098-1334-55d5-a843-a43d27b073f3','','','Gen. pl. 1:481.  1865 "<I>caramanico</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09726742-02da-5039-8138-15df48a95139','','','Ges. Naturf. Freunde Berlin Mag. Neuesten Entdeck. Gesammten Naturk. 2:172.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4feb75c7-1530-5398-99b8-799d9e984fc0','','','Aliso 2:18.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52c86382-6a25-5a4f-8975-9b7404b32b2d','','','J. Arnold Arbor. 6:208.  1925 "<I>flavo-purpurascens</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45c4c14d-d083-55b9-939d-4f5dfb81c867','','','Great Basin Naturalist 43:215.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f6bd5f4-b936-535f-8ee7-435389ecb2fa','','','Zoë 5:47.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33a65edc-55e7-5d3f-9bf3-ede7c2486b95','','','Phytologia 4:22.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ca64549-b8e9-5d7a-afba-65130a6f2d50','','','Garcia de Orta, Ser. Bot. 7:11.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d492c06f-c1de-57ca-9ec4-bf47a3bfd03f','','','Taxon 55:162.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ec0109e-b405-5d50-a8f8-a1c55ab3829d','','','Madroño 9:251.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b93b114-a7a2-5492-b0ed-7e95491e6372','','','Kakteen And. Sukk. 15:92.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92acc85d-5495-5227-bfb8-237d209f5a42','','','Fam. Bromel. 39.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb179e08-fb68-5f33-bc3f-61493d147bf7','','','Gard. & Forest 5:90.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('268caa00-e355-54f7-9847-43244ea49836','','','J. Agric. Soc. India 3:145.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc654929-c3bf-5cec-be77-01fe6ac48084','','','Pl. Grass. Pl. 51.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f82a7eb-93e2-581b-9338-22d1083a7dd8','','','Sp. pl. 3(3):2341.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8940e2f5-5a25-5e86-96ea-e2b557f4f323','','','Bot. Mag. 41: t. 1724.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6dc83b08-6703-50bc-b65a-65de88d65527','','','Gard. Chron. ser. 2, 18:134.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4fe1b16-3bf3-5065-9a53-18769a965a66','','','Bijdr. 493.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e7fc561-15e9-5a5a-a3f6-8d3a41e2c32c','','','Natuurk. Tijdschr. Ned.-Indië 27:58.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d1f4c18-170e-5341-a86c-cebc73d87f82','','','Repert. Spec. Nov. Regni Veg. Beih. 43:643.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0eb8695e-0a71-5675-902e-382342c478f5','','','New Phytol. 46:135.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59dade07-162a-589f-b22f-fdbec071e23d','','','Voy. Bonite, Bot. Atlas 161, t. 94.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05e17f4b-cd0a-572f-b296-b9cd34a2d3c0','','','M. Nee et al., Brittonia 58:350, fig. 12.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fc1f79a-7f80-5c72-832c-8a5accb0fe1c','','','Sitzungsber. Ges. Naturf. Freunde Berlin 1869:4.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70de6375-2a88-577a-9b02-ebef1b3e795e','','','Syst. veg. 5:451.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f6cc4c2-d430-58f3-9e37-d8fafd090b54','','','Sp. pl. 2:975.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79146770-b10a-5478-9efb-9a3cd6e8f671','','','Compos. ind. 147.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12977000-bcf0-5908-b64a-794b3e356885','','','J. Arnold Arbor. 6:150.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aefe9575-be5e-5e6d-9d07-ae46532b2314','','','Proc. Amer. Acad. Arts 19:40.  1883 "<I>lemmoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('409e7d86-036b-56eb-b7cc-4681ff29a0b9','','','Revis. gen. pl. 2:537.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c11f95c-1580-5f65-a732-54c01d48ad3e','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 8:216.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aed1a74b-e23d-57da-9357-216fefb426a2','','','Brittonia 46:168.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8c4eea4-c2d0-5435-b6ff-e5add4a77d08','','','Syn. fl. N. Amer. 1(2):300.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ab44e46-eaa3-5e76-b028-51827df4eb90','','','Repert. Spec. Nov. Regni Veg. 6:99.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('faff1ce9-6cd8-5d4b-b8cc-6ef465614760','','','Mém. Soc. Phys. Genève 5:200, t. 2, fig. b.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9ae13e6-e102-52a9-8fb2-400c56adbdb9','','','Fl. austral. 4:511.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d63822d-dfef-5171-84a4-37f64c8b605d','','','Bull. Torrey Bot. Club 26:108.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fb895b3-fff2-5c16-85ba-a3745b715f3b','','','Bot. Zeitung (Berlin) 19:137.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0b17a12-54a3-5656-965a-92913727828f','','','Hort. berol. 2:267.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00e4ad0e-acb4-5b92-a028-20919b36d4a1','','','Notul. Syst. (Paris) 4:93.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('146c8115-90f6-5dbc-9707-e2852672610c','','','Ann. Lyceum Nat. Hist. New York 3:406.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c67c07ff-290d-5293-8502-f599327e13c1','','','Pittonia 1:165.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65ae41cf-b4d9-5e91-9e91-e00460fc7c82','','','Haseltonia 3:4.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('975a07d6-194c-54e8-bb53-8c9b82076dfd','','','W. T. Thiselton-Dyer, Fl. cap. 6:179.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('968782cf-49bb-5288-9868-730225d8679e','','','Syn. pl. 2(1):165.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94981214-5536-512d-af11-b94b8823df0e','','','Ann. Sci. Nat., Bot. sér. 2, 3:265.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34c6ee61-4137-59f6-a522-3c1973ac1d06','','','Icon. pl. rar. 2: t. 398.  1794 ("1786-1793"); Collectanea 5:60.  1797 ("1796")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0add6ec0-fb2a-500f-b9dd-a9b35ddf72f4','','','Prodr. 504.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6dafe431-0b8d-5c33-b862-949480b17dcb','','','P. Davis, ed., Flora of Turkey 4:167.  1972 "<I>elaeagnifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ceff5790-ea57-549d-9f4e-01c02ae2740b','','','Bull. Torrey Bot. Club 90:191.  1963 (non R. Br. 1897)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('366edb92-cf08-5246-8a24-12f0e44f7ce0','','','Verh. Naturwiss. Vereins Hamburg ser. 3, 13:39.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69301be4-9226-5218-96ec-5df2e292afa7','','','D. Prain, Fl. trop. Afr. 9:504.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d50ccd3-9ee6-51b6-8b6e-1fd57c35da1d','','','Diagn. pl. orient. ser. 1, 9:32.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08a4f1e0-f28b-5a9c-8224-2981549bee44','','','London J. Bot. 6:217.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e81079b4-3b54-5928-bfaf-5a23f294295d','','','Gard. dict. ed. 8 n. 4.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d2f6154-9a27-5586-b19a-c16ddc6080ed','','','Phytologia 20:206.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19ff82e5-4783-5667-92fe-0ff520b818b5','','','Formes Grecques de Blé 36.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7b82192-d886-5b1e-8e5b-052644088715','','','Notizbl. Bot. Gart. Berlin-Dahlem 13:432.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66dc6455-d3c0-56fc-93e3-ea66b4a5e9cd','','','Bot. Gaz. 47:431.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20675cb0-96bc-52e3-b2de-58a6aceae3e1','','','Abh. Königl. Ges. Wiss. Göttingen 19:149; Pl. lorentz. 101.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e2e9672-f288-53fc-bc0a-9cdd4d014e2b','','','Fl. taur.-caucas. 1:381.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bbf2081-8b12-5b21-9ee9-50bd78ad8600','','','Amer. J. Bot. 30:55.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('103f6705-f251-545c-80e4-e6ea6c2c0520','','','H. L. Duhamel du Monceau, Traité arbr. arbust. nouv. ed., 5:33.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ed149f0-d958-5af4-8940-72331e95943a','','','J. Chem. Tox. 10:1, t. 2.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61ce0b0a-6a75-552b-8822-d114ba689434','','','Comp. fl. ital. 456.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a4fa6ab-0942-558e-9f72-2ecb94e7dafc','','','Encycl. 1:89.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3191df4-0ca8-5973-95d1-29c120af708d','','','Nov. pl. sp. 214.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3501b780-3254-5527-b205-38512dcc90e7','','','Bot. Jahrb. Syst. 40:217.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3011f476-5811-5d80-ae22-ea6c9adf93c4','','','J. Bot. 68:79.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3551d97a-6fdd-56db-923d-ad2d362ebf79','','','Proc. Amer. Acad. Arts 47:215.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3632841c-3410-5ded-ad92-16b9e70ee553','','','Bull. Jard. Bot. Buitenzorg sér. 2, 13:30.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b041dfb5-03bd-5b81-af7b-991246509bc0','','','Fl. Pl. South Africa 13: t. 707.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc469ec2-b302-53a0-8ed9-762e911a327c','','','Abh. Königl. Böhm. Ges. Wiss. ser. 5, 6:455; Epimel. bot. 95.  1851 ("1849")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9114aca-fb61-5e74-a884-a77e91fc8641','','','Bull. Herb. Boissier 2:114.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66d713e5-44e5-5dc2-806c-4e269e73f8d3','','','Amer. Fern J. 92:100.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6280441b-1738-5667-9d17-cb14612e57a8','','','Bot. Centralbl. 60:387.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec10e64a-eead-5c62-b205-ef1b4fa54dcd','','','Acta Phytotax. Sin. 11:437.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a60378c5-b170-58f6-a5bc-7cfab6cd0d6e','','','F. W. Andrews, Flowering plants of the Anglo-Egyptian Sudan 2:461.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d591001-698f-5a89-8646-ba80d9ded9c9','','','this combination has not yet been made','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d3915b1-6c35-5fde-a555-1ddd9bf46af0','','','Hort. berol. 1: t. 72.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2eadea9b-0ebc-5614-95af-fd451ad91637','','','J. Adelaide Bot. Gard. 12:198.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83e770dc-0a5c-5770-9c53-7f93c7bc3c85','','','Phytologia 68:25.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bc48ecc-d334-5fca-8d28-fb481558b93d','','','J. Bot. 71:341.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('570c0339-6c3a-5ce0-aa66-f4d433e0a640','','','H. G. A. Engler, Pflanzenr. IV. 38. III, II(Heft 33):290.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('275ffbd1-de1a-5216-b78a-aa5f9a7f92e9','','','C. L. von Buch, Phys. Beschr. Canar. Ins. 151.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a1be5fd-80d2-5d30-924c-13366d82af20','','','Icon. fl. germ. helv. 2:20.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50d52adb-ac11-51a4-b2b6-47d951560f36','','','P. E. Boissier, Diagn. pl. orient. ser. 2, 6:119.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4a221a2-ca6e-52d1-96b2-775b63b436c5','','','Syn. pl. 2(1):204.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31e8184b-575b-54ef-b46e-3c19a1241803','','','Tabl. encycl. 1:196.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9f25180-7a88-524f-be8d-8bcc888c785f','','','Notul. Syst. (Paris) 6:76.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d708b5b-1dad-5f8f-8f37-56025644f150','','','Kakteen And. Sukk. 21:30.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c0ff6cf-dac3-5ca0-9d6b-f80d1c8d3a5e','','','Observ. pl. Angers 152.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ede8bf80-2493-50a8-87f6-7d60680e9626','','','J. Linn. Soc., Bot. 21:426.  1885 ("1886")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65f92575-9ef8-5432-a2b0-53914d027b82','','','Kulturnaya Fl. SSSR 1:339.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abbecb57-6866-53a7-ab41-0be206e551e8','','','Fl. U.S.S.R. 6:721.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f83ed641-4f6d-5dd9-9f19-2c343a788ef6','','','Ervas forrag. 117.  1962 "<I>sampaiana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcfc498f-15ec-5e1d-98f0-013368f44820','','','Bot. Mag. 138: t. 8458.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f92ce33-cff4-5f12-bd18-fdee15738dae','','','I. B. Balfour, Notes Roy. Bot. Gard. Edinburgh 9:38.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5ac1f30-ab2a-5803-a332-5a0ca4448083','','','Feddes Repert. Spec. Nov. Regni Veg. 53:144.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e76f356-a1eb-54a3-8848-62b951cda5cf','','','Huitieme Congr. Int. Bot. Paris, Compt. Rend. Séances Rapp. & Commun. sect. 4:74.  1956 ("1954")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68dd4913-2b1e-500e-bd9f-0b487f22f522','','','Herb. amb. 18.  1754 (Amoen. acad. 4:128.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8d19d5c-6c0b-5020-89a7-7c9d6edb4c34','','','Fl. reipubl. popularis sin. 49(2):228, 315.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c01dde62-a7f8-58cc-bc59-7e55414f72d8','','','Agric. Ledger 1906: 78, 91, 102, 105, 128, 139, 140, 147.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d58361f4-3fcb-5a47-8ba8-216f032eb7cb','','','G. Engelmann, Proc. Amer. Acad. Arts 3:305.  1856 (Pacif. Railr. Rep. 4:49.  1857)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33ba3674-f9b0-52fc-8afb-c34f47642f3a','','','Repert. Spec. Nov. Regni Veg. 3:179.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90ddacb4-a3b6-546b-ba82-b5eca812e8dd','','','Fl. orient. 2:91.  1872-1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3ace46f-d006-5bb5-a551-d8eb2caab07b','','','Begonian 21:300.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('007f650a-627a-5255-ad4a-da5d29da13bd','','','Arq. Inst. Biol. Veg. 4:7.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6adb7a86-1e9e-5e60-808c-47f9980db8ee','','','Trans. Amer. Philos. Soc. ser. 2, 7:341.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d661e70c-297d-5534-a00c-a54794df0f00','','','Ann. Mus. Goulandris 1:42.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('192418d0-47d5-5a24-bda5-ba47874b0a2b','','','Acta Phytotax. Geobot. 1:14.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b819d60b-eb06-5f35-b67c-abb7372be592','','','Encycl. 2:355.  1786 "<I>Embothrion</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0526602-0b77-5a0c-8660-6cac668340d4','','','Kakteenkunde 1937:4.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe7eaee8-cef1-52df-a445-f62be8e06171','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1858:19.  1859 "<I>costaricanas</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('188e2c8d-aff4-56f9-97a3-37a40ccce6b3','','','Philipp. J. Sci., C 3:227.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e37beb32-c5b7-5904-9d4a-4971c9771307','','','Repert. Spec. Nov. Regni Veg. 17:75.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec431bc5-3245-5b59-ad4e-07241ce98659','','','Fl. Oware 1:70, t. 42.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62323f3f-8ba5-586c-bb3e-3a03c8078882','','','Tent. fl. Germ. 1:309.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('378f889b-51f7-55d7-9c59-881f1effa3e9','','','Syst. Bemerk. 31.  1854 (Abh. Königl. Ges. Wiss. Göttingen 6:119.  1856)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf0f792a-d76a-5c70-8406-ce1cf9495336','','','Indian Forester 80:41.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67e43a62-0695-50ab-806b-0fa1100f2c30','','','Bot. Jahrb. Syst. 31:100.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21c8b960-bac0-51d4-8bf2-41d42bcb1812','','','Rubi Germanici 38.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2fa3b59-f0e9-56b8-87da-224279ddfe4b','','','Sp. pl. 4(2):337.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78800b42-8a9b-5dc8-91c3-23e32bc121c6','','','Carniv. Pl. Newslett. 32:87.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('817b6206-c5f6-5823-8967-cde8aaa48770','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(7):88.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea72d782-d9cd-5640-b8e4-2e1c549dbfe2','','','Pl. hort. schoenbr. 3:77. t. 397, 398.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74706ab5-1562-52ae-9c26-8a4a07f60e59','','','Allg. Gartenzeitung 2:245.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0e5cc0a-37a1-5bb6-9063-f469d2e2cd4f','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(3):155.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc0f2210-4332-5fd0-89f2-60324564af70','','','Gard. dict. ed. 8: <I>Canna</I> no. 3.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75f6ae93-5deb-52ab-9169-1be0fe225500','','','Prodr. 3:475.  1828 (Haw., Syn. pl. succ. 199 (in obs.).  1812, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30627848-71e8-540b-8947-99542d6b65a7','','','Boissiera 9:357.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e66bb582-a91c-5374-b0b7-31b6bd60e871','','','J. K. Small, Fl. s.e. U.S. 1010.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0dbba56b-c348-5622-ae57-a8472ae63570','','','Brit. fl. gard. 2: t. 174.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7446d60f-dd8e-58b2-8c47-4a2ecaa20404','','','Orchideen 598.  1914 ("1915")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bafd59ac-ebbc-559d-aba4-dd8a3b39fa4d','','','Abh. Königl. Böhm. Ges. Wiss. ser. 5, 3:532.  1845 (Bot. Bemerk. 102.  1846)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bd6fbc9-6df5-5820-9dd4-191032439944','','','Fl. ind. ed. 1832, 2:509.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('222d6457-3353-524a-a613-52ff4525e961','','','Fl. japan 101.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37e0b035-8b76-5a82-8b3a-c46ffee142d3','','','Fl. siam. 1:223.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3e28117-6e94-5612-82ce-e699c0fb4be1','','','Mem. Coll. Sci. Kyoto Imp. Univ., Ser. B, Biol. 13:354.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d7bf1c1-328e-554c-a71c-e3476f097319','','','Cactaceae 1:116, 219, fig. 288, 289.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22ad5ef3-04c0-53e1-aafa-4ef3385bc23c','','','Prodr. fl. nepal. 97.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68ef4ce1-8790-5b35-9f73-1bfbb85b5b48','','','Trans. Acad. Sci. St. Louis 3:319.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3d67b17-4fae-5fad-901d-ab8081cbfa68','','','Amer. J. Sci. ser. 4, 17:312.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3181eca7-628e-5844-aa2e-a084e6ab4001','','','Enum. pl. 1:71.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd1050e6-c080-5c4f-a34d-34a649c8bcc8','','','Curr. Sci. 42:692.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fdc85da-d093-5ac3-b2ea-44378953c0e9','','','Fl. Australia 8:392.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61d48319-e8e7-5d00-aedf-3c651993d935','','','S. Watson et al., Botany [fortieth parallel] 17.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c15b1d2d-6791-5088-8d13-dc9b6f8de64d','','','J. Coll. Sci. Imp. Univ. Tokyo 43:36.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c17f49c-b1fe-5c41-9880-e0e5d3e492b6','','','Enum. hort. berol. alt. 2:64.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('110038aa-3cca-596c-bd02-09bd1347b616','','','Diagn. pl. orient. ser. 1, 9:84.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('555abd47-5f72-5ef1-864a-deee0911a00f','','','Nat. hist. 14:68, t. 95, fig. 2.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a50881b2-c747-54d2-98a4-a34ffac0bfae','','','Gen. Amer. bor. 2:130, t. 151.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4121993f-5959-5a99-b1d2-7ab5c8dea80c','','','Bull. Soc. Bot. France 49:259.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af0af704-0833-53b6-a491-ad6c70865145','','','J. Bot. (Hooker) 3:34.  1840 ("1841")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82f60ffb-ceb6-51f6-be27-959a2daede9b','','','Sp. pl. 1:60.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdd07636-8509-505d-ab87-b97816d31b54','','','Sp. pl. 1:313.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5b719d3-1cf4-5cc1-b893-22681d5618c4','','','Syst. nat. ed. 10, 2:1180.  1759, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc1dae4e-8e54-5d87-8f37-95580586601d','','','Estud., Ensai. & Docum. 12:59.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92e150dc-981d-5fa5-9f06-03bde4d77392','','','Novon 14:92.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('890a5c10-13ea-59f9-9ec5-0a2d1cdc3465','','','Flora 12:341.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d024c3d3-1079-519d-98d8-6c6016770c25','','','Fl. cab. 2:149.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1bc654d-d22f-52fd-a346-effc301d14e6','','','J. Bot. (Morot) 9:450.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db5c18ff-d532-51ae-b740-cb6dba75f2cf','','','J. Indian Bot. 2:124.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97de5f69-dbb7-58f3-8708-ca1663ed5414','','','Fl. N. Amer. 1:555.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07372a96-8b58-554d-b1ce-45769c07441c','','','Bonplandia 8:81.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf3b49dc-23b4-5c86-823f-3224c80290a6','','','Fl. atlant. 2:48.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b586bbdf-e6f8-52a6-b905-50b6dcd55e86','','','Trans. Linn. Soc. London 10:167.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d812edbf-8b99-5c21-b704-451c6ffb7af8','','','Prodr. pl. Ind. occid. 4.  1825 "<I>tiliaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6dfc129-ecf0-541e-9969-405ead665625','','','Sp. pl. 1:121.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e42bcf2-4356-5cfa-a83a-b7d47212c56b','','','Sp. pl. 2:726.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a84a316-37cf-5967-8cca-667743e56378','','','Linnaea 12:70.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfb30907-aaa5-5d55-a899-d3f0d5e4b4b2','','','Monogr. Digitaria 458.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('624ca807-e922-53b2-ac74-7a8f9bc46585','','','Prodr. 6:222.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48cda114-8da4-5dda-a887-798066248da6','','','Prodr. fl. Ind. orient. 59.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f7ca082-5449-5dbf-9e7c-bed6ff4f7b31','','','Linnaea 25:50.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08942209-0ba7-5e65-b3a5-c322b894b661','','','Brittonia 30:265, fig.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b18645d5-2ba5-5219-a0c8-96bde084072e','','','Fl. carniol. ed. 2, 1:385.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b070607f-4b83-5854-8d05-94efd9b49573','','','Bull. Jard. Bot. Buitenzorg sér. 3, 9:314, fig. 11.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e9b7cb2-04d8-5d39-9f8a-6a736af0907e','','','Bonplandia 22:93.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f22c586a-0ef3-512a-82f4-c6ca93ced1f0','','','Descr. pl. nouv. ad t. 51.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46904aaf-12f5-5cf2-b646-40668df765e0','','','Bot. Jahrb. Syst. 30:462.  1901 "<I>lanceifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a24d701c-eb88-5a47-ae6e-cbad070a9f4d','','','Bot. Jahrb. Syst. 49:603.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14cad3e2-d816-5d6d-a442-fddebae00fa4','','','Mém. Soc. Phys. Genève 3(2):60, t. 2.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb3cbc85-4596-5e72-8a19-3cc006dbb0b2','','','Illustriertes Handb. Laubholzk. 1:688.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6f1d3a5-e38a-587a-b648-9cd8db1ac1b5','','','Hochgebirgsfl. Afrika 258.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e284404-cb8e-58b3-9cbd-99cdc45853ac','','','Fl. Amer. sept. 2:586.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5338011b-80a7-5381-b524-7c829f6c7dcc','','','Bull. Bot. Res., Harbin 20:122.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e97e4adf-8296-5b86-b24d-79373e4d483c','','','Diagn. pl. orient. ser. 1, 11:34.  1849 (non Crantz 1766)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42e662a0-c8ce-5bb2-802b-8a8018fe22ca','','','Bull. Torrey Bot. Club 27:516.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31b74df6-e385-533c-9b38-d64a53338aee','','','Trudy Prikl. Bot. 5(2):145.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c36c7abf-05cb-5d43-b25b-de6b03ee19d6','','','Anales Univ. Chile, I, Mem. Ci. Lit. 91:425.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea8dfc8f-869c-5a19-8ff3-84e4c0d006b1','','','Bull. Torrey Bot. Club 28:360.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c14be1cd-9c9e-5c26-9834-256779475db0','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 4:53[folio].  1818; 4:68[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c09e6e5-7deb-59c6-90ec-74fe200257e7','','','Gard. Chron. ser. 3, 97:376.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1571939f-bfcd-5ae8-a4ea-819383c9d8eb','','','Cat. afr. pl. 1:1010.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e7e500d-d3b9-58b3-995c-4b624f8cb833','','','Prodr. 2:405.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60d7c299-3434-58e6-8d31-57b1725b3793','','','K. Mayebara, Fl. austro-higo. 84.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43490fd0-5e11-5e9c-a47f-133da7717a8a','','','J. Jap. Bot. 57:313.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0419ec66-ef39-5146-a60b-1188fdc2a384','','','Bull. Jard. Bot. État Bruxelles 24:438.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55a51edf-c9d9-5514-8857-70f4e8b7b007','','','Linnaea 5(Lit.):54.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57ac3a33-a909-55f3-9d73-1fc5d0de2680','','','Mém. Soc. Phys. Genève 31:168, t. 21.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e8ddca0-b9f6-54da-b83c-e4e68aee2d4c','','','Fl. bor.-amer. 2:11-12.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de6e3996-1c3c-5066-86cc-5030f1595943','','','Muhlenbergia 1:5.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25d7df66-24b3-5198-8f67-6a7e30ceeeef','','','Trans. & Proc. Bot. Soc. Edinburgh 20:65.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('405edd7f-90c8-5c10-9b1d-835bc7d4baa3','','','Lemnac. 127.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bfaf12f-bed8-5185-93cf-2dbac51b9114','','','J. S. African Bot. 42:429.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ce8bb2f-2deb-5387-aab7-905e1c082826','','','Z. Sukkulentenk. 2:203.  1926 "<I>hugo-schlecteri</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df78e33f-bc60-5c7b-a04c-2b880fad8cb4','','','Prodr. Fl. Ind. Orient. 1:245.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cda7e624-31e2-5e5e-bbfc-580d0833f749','','','Prodr. 5:430.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6111b105-79a2-524d-9a62-3cb94838244e','','','Trans. Hort. Soc. London 1:338.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ace29b1b-22cc-566a-ac5b-5a52ac29bd6f','','','Fl. carniol. ed. 2, 1:319.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02487ecf-681e-5535-8d76-f8385a320d86','','','Baileya 15:29.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1138613e-de2c-5299-9e87-43e37bfb87fa','','','Bothalia 1:121.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a4ef187-d65e-5617-8b1b-5962362285f2','','','Kakteen And. Sukk. 30:257.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14614d06-d94c-5d62-acf6-4988ff64e70e','','','Leafl. W. Bot. 5:125.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f9f7889-fe0a-508f-aabd-facb263de34f','','','Chem. & Druggist (Australas.) suppl. 5:94.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd797af4-6a68-53d2-a329-543185ed7982','','','Agric. Univ. Wageningen Pap. 85-4:129.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4810d554-acbf-5ba1-a807-b36c2d86e9c1','','','Taxon 64:750.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffc21cd7-62d0-5b88-80e0-7902b82c3702','','','Asclepiadeae 68.  1810 (Mem. Wern. Nat. Hist. Soc. 1:68.  1811)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e43cd978-9062-51c6-9cd5-8e9172315f94','','','Trees shrubs Japan ed. 2. 582, t. 261. 1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0175b9e7-fca5-5e6b-a98c-af0c2de1e937','','','Bot. Jahrb. Syst. 15:97.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89776586-e343-517f-9ecd-0c101822a406','','','Voy. rech. Pérouse 1:156, t. 14.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('495bdbb9-bd43-58de-8acd-955fce1a8a67','','','Madroño 7:113.  1943 "<I>youngae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9b15535-6cc3-540b-83e0-ea3c5fd9f034','','','Fl. Brit. W. I. 306.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72f2f5fa-c1d3-5b0a-89e4-7d73d3f893ec','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 2:337.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa40be3d-5ccd-54d7-801c-70ed2ffa6cd3','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 7:16[folio]; 7:20[quarto], t. 609.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb29b0f0-9629-59ed-b5ad-7961078231af','','','Kongl. Svenska Vetensk. Acad. Handl. ser. 2, 6(1):172.  1867 (Monogr. Salicum)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2514687-bc5d-52e7-bd25-34efe355e9b5','','','Gen. pl. 3:690.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('938c79de-24bd-5e44-9518-2f1b3aaa2934','','','Linnaea 26:352.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fbe6030-5fdf-5a37-9470-4affb188d44f','','','Kew Bull. 1952:189.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9300146f-3011-52c0-b90a-a99692980006','','','Biol. Skr. 14(4):67.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66de4417-c8ee-58d6-ae61-73825106a6cd','','','Smithsonian Contr. Bot. 45:29.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0c12a87-e1b3-5fcb-987e-e1813472d928','','','Biblioth. Bot. 17(Heft 72):102.  1910 (Sp. rub. 102.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5fc3676-1449-546a-ab82-9e26d7011560','','','Bot. Jahrb. Syst. 34:357.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aee8c675-279c-5b09-a30a-df7d9774906e','','','Revis. gen. pl. 1:159.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f48eda9-7632-5a02-a789-3702e2bb09b8','','','Atti Soc. Ital. Sci. Nat. Mus. Civico Storia Nat. Milano 146:230.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d80ea3b-11c1-508a-86be-4dabb8ccff6d','','','Reinwardtia 5:211.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcefb4f5-538b-5c65-bdd4-b9fb86e35e81','','','Erythea 3:62.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c25574dc-f8e6-5395-8076-64b0c794a4c9','','','Stud. sp. Campanula 60.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8dad06e-c72e-5687-9a4c-b747e37ce8f4','','','Bull. Torrey Bot. Club 32:609.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('989d7972-34a0-50e0-b742-279faae1e398','','','Succulenta (Netherlands) 73:135-137.  1994 "<I>fickeisenii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75d9962f-a299-57d5-82c3-d389d8597438','','','Gard. & Forest 4:51.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f854728a-c662-56af-8583-eebe9d8ef160','','','Gen. Hosta 316.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c736219-c24a-5490-b5df-abd1f3006932','','','Orchids Borneo 2:37.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19f84cfa-ccc1-5079-93d5-e02aa8ebe943','','','Fl. Indo-Chine 1:1052.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b66b08b-59e9-52ea-ae51-9da9fa51c0c1','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 2(5):158.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05926c13-a880-5b2d-b6e1-9d2e71d1024e','','','Bot. Zeitung 21:53.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30673760-a748-5da3-b8cd-4e5fb22c0228','','','Pittonia 3:163.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4d4de33-79d9-503b-a567-34b765f8d721','','','Bull. Torrey Bot. Club 25:620.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('879ffda8-fb57-5766-ae59-965b35849dfb','','','Rev. Int. Bot. Appl. Agric. Trop. 33:309.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f993e6d2-0159-50fc-9369-e139b07a8d7e','','','Syst. veg. 4(2):235.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('242a4228-36aa-5ca1-a08a-90207a942898','','','P. J. Redouté, Liliac. 8: t. 486.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d72dd01-5425-5549-8673-11d5bb8bce89','','','Kurtziana 5:394, fig. 1a-h.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49702290-8199-5abb-a4b0-a7cc3c855281','','','Hort. kew. 316.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fa2286e-778b-5cf8-af7b-b118a5ab9d9c','','','Pittonia 3:204.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c93e7d19-331b-571a-819f-234472824be7','','','Feddes Repert. Spec. Nov. Regni Veg. 63:311.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a388d28e-e42f-5a3e-8af8-f07e06d16c54','','','Bull. Misc. Inform. Kew 1936:297.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3376fb96-f6f1-5cff-8a0d-ba50d380aa75','','','Landw. Fl. 329.  1866 "<I>miltura</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('406c6e8f-b94f-56ba-aed9-bb4c28e42f65','','','Prodr. fl. Ind. orient. 257.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('185e6585-6d3d-5e68-b17a-31ebd832950a','','','Enum. pl. 2:172.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1700024-5229-512f-9d2e-329a0f3df9a9','','','S. African J. Bot. 112:419.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f822663-dcb3-57c9-b4b9-18522c77b03b','','','Vict. Naturalist 68:49.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('991b8c0a-ec1f-53fe-b60b-1cac9cb61d7a','','','Rev. Bot. Appl. Agric. Trop. 20:322, t. 8.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad5e336a-6d61-5c1f-a0fb-3adf35e42f24','','','Adansonia sér. 2, 1:39.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd3cdc73-6c59-5c89-aa99-49806baf1293','','','Hooker''s Icon. Pl. 39: t. 3852.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35d6ba50-dda0-52f8-853d-56d026b22a14','','','Repert. Spec. Nov. Regni Veg. Beih. 1:832.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ede287b4-17ce-5b6c-bd7c-7da6274fe2ee','','','Linnaea 33:246.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b984cae5-8a5c-52de-97c7-a0b7aadaf4f1','','','Trans. & Proc. New Zealand Inst. 57:38.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab0662f0-d953-5de2-8db6-09ac378ae0b9','','','R. Wight, Cat. Ind. pl. 105.  1834 (Nees in W. J. Hooker & G. A. W. Arnott, Bot. Beechey Voy. 251.  1838)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('199a9941-5063-52f1-8397-91edf226a514','','','Sp. pl. 1:27.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8df61b94-f979-5609-bbd0-8c828297a3b5','','','V. L. Komarov, Fl. URSS  15:123.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0a5126e-35ea-53ed-84b2-4b92347a4924','','','Fl. pis. 2:241.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe649d65-5c29-5c65-9e2d-fc4a513a7159','','','A. Gremli, Excursionsfl. Schweiz ed. 4:64.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d79b567-0fd0-5ca1-8d94-d3dee364dae8','','','Fl. sardoa 1:548, t. 68B.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f04c4c0-dcc1-5825-9f23-5512f561b056','','','Orchid Digest 35:122.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c78fc21d-8718-50ea-8d63-72de5c8975d1','','','J. Acad. Nat. Sci. Philadelphia 2:123.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b8339a3-c310-5474-8cde-219f19d80f29','','','Enum. semin. 1863:24.  1863 (A. L. P. P. de Candolle, Prodr. 16(2):448.  1868)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9389cf6a-cb19-52a4-963c-25ab9e86890f','','','Izv. Imp. Acad. Nauk ser. 5, 14:92.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c94c3d2e-24e6-5b8b-97f9-02eb80b90e4c','','','Fl. peruv. 2:47, t. 186.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fcbb1b7-af30-5164-b5e2-ea6a925b20fd','','','Fl. ins. austr. 76.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7048a76a-1bcd-5b6f-bac7-828b9aab07d1','','','Rhodora 61:169.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('868e88aa-c86a-5000-b737-760058b9210f','','','Arch. Bot. Mém. 7:81.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e409aa75-fc20-52f9-acf7-47711d20310c','','','Étude Euphorb. 543.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('884bafa5-c774-50eb-9089-a02b6af5d1be','','','Kew Bull. 56:787.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a4b8cc8-3ea3-5608-8e6c-5c637001a759','','','Bot. Mag. 85: t. 5128.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0101a8e5-3126-539f-a641-0520b4defb3d','','','Abh. Königl. Ges. Wiss. Göttingen 24:285.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('989fbc6b-d269-5405-91ac-2303a658ad51','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 29:98; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 11:690.  1883 (Diagn. pl. nov. asiat.) (non K. Koch 1876)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4eed3249-c072-5afe-95b7-8b4bf3d324c4','','','Ann. Soc. Linn. Lyon sér. 2, 70:89.  1924 ("1923")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efb1f350-3b4b-5fc3-b76f-b5206c1b9b1e','','','Kew Bull. 19:229.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6733e479-6d84-528d-ad8b-643a357d71d4','','','Bull. Soc. Imp. Naturalistes Moscou 15(3):579.  1842 (Fl. baical.-dahur. 1:209.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a0f2fe7-99e5-5f08-9e7b-7d76b47f5b47','','','Pl. hartw. 298.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6b3f41e-1e5e-57c5-a9c9-c7d508b71fb2','','','Bot. J. Linn. Soc. 140:72.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29f69fd4-f57a-576c-afd4-3333a63568a1','','','Hist. nat. Iles Canaries 3(2,3):44.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f47c9e9-3972-58d4-88f4-7337468c3afa','','','Fl. s.e. U.S. 1011, 1337.  1903 "<I>ambrosifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a17b85ac-0b45-5cec-90dc-6bbcef2d1479','','','Mém. Mus. Hist. Nat. 5:37, t. 2.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('823c1ff2-77d1-54d0-bfd5-648b3c4940f1','','','Ann. Sci. Nat., Bot. sér. 2, 19:48.  1843; Ill. Pl. Orient. 1:115.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fea69271-ae73-5f49-b55f-3b839ff01368','','','Bot. Mag. (Tokyo) 30:325.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9311a82-479f-56b4-8bb6-f3e5035a1f50','','','Ann. Missouri Bot. Gard. 14:281.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d07989c3-f528-5e50-9c09-cca5c949cf4e','','','Acta Phytotax. Sin. 20:210.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58b81750-0d1b-5705-95f0-32c319076c4c','','','Traité arb. arbust. nouv. ed., 5:33.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e52f8451-cbba-57de-9569-4f2cb7751285','','','C. S. Sargent, Pl. wilson. 2:330.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31540283-f642-53a2-83df-a5db4b9c2c8a','','','Svensk Bot. Tidskr. 16:401.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba36c9b5-b000-5c0c-9811-db2ede20b1e3','','','Linnaea 4:501.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0133469c-be2e-508f-b367-53fe2b45522c','','','Encycl. suppl. 2:14.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ba58889-1024-5359-a0ad-13df9fd251ff','','','Monogr. Serjania 136.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd48adf5-3a97-5dd6-a972-bab531601e5c','','','Taxon 4:44.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0589f990-1971-5966-80a8-0276a9c9bc9e','','','Meded. Bot. Mus. Herb. Rijks Univ. Utrecht 65:521; Recueil Trav. Bot. Néerl. 36:521.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b800ce60-86bc-5be4-8125-90ac4ca050fa','','','Revista Argent. Agron. 16:68.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('840dade8-0d63-5263-8104-8a85137d1850','','','Rev. Bot. Recueil Mens. 2:434.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70520285-361c-57f7-9c89-f84b183cc75c','','','Aliso 6:68.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb7ccdeb-95c5-5f18-9171-56bd8da19f02','','','Gen. sp. Aster. 153.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95b1e606-cbeb-51fb-b5bf-bbc264275cd9','','','Bothalia 6:223.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00a1388e-2b15-5f84-8e94-2ea66ef865cb','','','Gard. dict. ed. 8: <I>Ananas</I> no. 4.  1768, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34990ab2-9653-598a-a34e-6cb291c1a8aa','','','Trans. New York Acad. Sci. 9:8.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58febc4c-88c3-5883-a48d-755a4241c613','','','Malayan Misc. 1(1):25.  1820 (repr. Bot. Misc. 2:74.  1831)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0320240e-0fe5-5e1b-9a31-1acc97acdd01','','','Rep. (Annual) Missouri Bot. Gard. 19:264.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62b604dd-f793-5fc2-b2d3-48eac2c9cf09','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 13:32.  1950 "<I>cinnabarina</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d72646e9-df94-5bcf-8148-0ff1808d819f','','','F. J. H. von Mueller, Fragm. 4:84.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7f2dd93-fe18-55d6-9186-516a2ec4e512','','','Reis. Amur-Land., Bot. 42.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45650971-f083-54c0-bb7a-0139812a1633','','','Notul. Syst. (Paris) 3:329.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07474568-920f-5724-a640-94f0af0fd857','','','Kirkia 5:76.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c1cbad2-f185-5b51-87bc-17e8bd32dc1a','','','J. Nanjing Univ., Nat. Sci. Ed. 1:99.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc708ace-9d95-545c-8774-85e4b4f049ce','','','Fl. francisc. 53.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0bd76bc-2312-5e4f-855b-4deac0e6f9a6','','','Ann. Sci. Nat., Bot. sér. 3, 8:91.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f4ba75c-07b7-5a6c-810c-ff79bbd2a45a','','','J. D. Hooker, Fl. Brit. India 2:723.  1879 (B. Seemann, J. Bot. 6:134.  1868, nom. nudum)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7cc8f06e-8915-58e2-8f03-b849ef850ef0','','','Sp. pl. 2:914.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('385b49c7-d228-5708-bb45-2cd14581cf60','','','Deut. Dendrol. 317.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a09c1c3-437f-5a30-842c-bc85b7426a2f','','','J. Adelaide Bot. Gard. 5:215.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce84ed8f-e8f3-593b-a495-a3cba4163bbe','','','Trudy In-ta Polevod. 8:23.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52b0924e-24a7-5187-8b53-f8bfabf0a2bd','','','Jahresber. Schles. Ges. Vaterl. Cult. 89(Abt. 2b):1.  1911 "<I>huberti</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5fe1d49-49f4-5436-a4c3-632125de7991','','','Repert. Spec. Nov. Regni Veg. Beih. 1:860.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfce249e-9550-569f-b49c-c78fad7a0081','','','Bibl. cult. trees 599.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1656f8e3-58bb-5484-99d0-cf98ac3e00b8','','','Ann. Lyceum Nat. Hist. New York 2:211.  1827 "<I>baldwini</I>" (Acct. pl. Rocky Mts.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1be1e1d1-a47c-5a3d-a8a3-4a29c05063dc','','','The potatoes of South America: Bolivia 170.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b131cff4-9564-59d2-8f19-f804346eee65','','','Acta Bot. Neerl. 1:444.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('483a2791-833b-5043-a7fb-64cadc8eab1c','','','Ann. Mus. Bot. Lugduno-Batavi 2:254, t. 8.  1866 "<I>subintegerrimum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b32ff7f1-447e-5b16-977f-31a969eaa791','','','J. Bot. 6:134.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88212524-b720-5df6-9679-f3290c605f32','','','Revis. pl. vasc. filip. 24.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e92ada9-4df8-5b5f-a3e1-6315254f2bb4','','','Hooker''s Icon. Pl. 20: t. 1943.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c85701fd-928b-5072-95f8-59372782242e','','','Bull. Jard. Bot. État Bruxelles 19:402.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8889ba35-abbf-556e-bdb5-e8b8f11f4f25','','','Bot. Jahrb. Syst. 74:620.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('505bb18c-1dfc-57aa-8579-6a7870bdfb43','','','Sp. pl. 2:1077.  1753 <I>"orientale"</I>; Sp. pl. ed. 2, 2:1534.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6fea6b7-a6b0-52a0-90ec-4932f46b3ebf','','','Fl. Ned. Ind., Eerste bijv. 411.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4585b36a-f2b1-5594-89bd-215c145cfa6d','','','Darwiniana 5:96.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('515f7d03-aeb8-5a8e-b0ac-6372eb16fe2c','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:334[folio]; 3:428[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4859066c-db61-58fd-b275-8b6a2fd2bd31','','','W. L. Wagner et al., Bishop Mus. Occas. Pap. 29:104.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3472712f-e6db-5786-a355-cf4399615c82','','','D. Oliver, Fl. trop. Afr. 2:528.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3be11168-3ba2-5358-968d-1593bcdd1922','','','Edwards''s Bot. Reg. 30: misc. 72.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5882e255-73d3-5ce0-a990-14eb0e9d969a','','','Agric. Univ. Wageningen Pap. 91-4:137.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c800a853-0cc9-5df4-b6b6-c70d73979a70','','','Linnaea 15:251.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d204ba94-ee83-5d12-8dd3-062bbc0f84c7','','','Congr. Sci. France 19 Sess. (Toulouse) 1:280.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f726e74e-b462-56a9-8cdc-497bc78875f4','','','Hist. pl. 2:142, 163.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7318d291-a866-5ab9-9c88-8d56bb9540ee','','','Bot. Zeitung (Berlin) 23.146.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5faf9e1e-8d5e-5c3f-900c-18e22f991301','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 19:251.  1874 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ea58f46-0bde-5a8b-9e1b-b094ebb536cf','','','Prodr. 8:255.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b6104a7-b9c2-5c66-bf27-1f0035d41c5c','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 5:221.  1883  (Pl. david. 1:69.  1884)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef6d4c16-ae0e-514d-b132-d9b382f67b50','','','London J. Bot. 1:23.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcef7f2b-905c-57b8-9695-5cc0227f12ca','','','Enum. pl. Jap. 2:488.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f38b27d3-b198-5b4a-ac17-3b31e17f761f','','','Syn. mitteleur. Fl. 2(1):583.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08d932ca-0edb-5b6f-9c2a-ce14cfb324ed','','','Kew Bull. 24:248.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fda22c0-a68c-545d-be0a-d0ae592524df','','','Acta Bot. Yunnan. 13:264.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96f7dafe-de9a-59ad-b51e-0fbb4fe40b57','','','Ziergehölze Gärt. Parkanl. 3:241.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9321644c-c905-56f8-be92-d949a58b983e','','','Blumea 51:27.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06da1b62-75ef-50cd-bbe1-ae4a88621506','','','Madroño 14:20.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e55dacd-5d93-5dd1-8737-7b8ad45e5e12','','','Fl. bor.-amer. 1:65.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cb6d978-44b0-5a82-a74f-320715568746','','','Pl. delavay. 223.  1890 "<I>pannosa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfb7bbaf-68c0-5003-8ffa-a3a614c390da','','','Consp. fl. graec. 1:351.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22de99db-46d4-58a1-9a0f-494ed81a99ea','','','Theor. prakt. Handb. Forstbot. 2:1269.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff5476ca-a985-54df-8eab-6654927990f2','','','Ann. Sci. Nat., Bot. sér. 2, 13:335.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3818b1bd-1f67-5b13-a56b-5cb0981de259','','','Estud. tax. <I>Lonchocarpus</I> e <I>Deguelia</I> no Brasil. Ph.D. Diss., Univ. Est. Campinas 86.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de47600f-8dcd-58d5-9650-85728fbc60c7','','','Hooker''s Icon. Pl. 30: t. 2953.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed7f70a1-62b5-5181-9558-7b2bd8e7db84','','','Bull. Torrey Bot. Club 27:508.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a204c432-d8e2-5d3e-ae73-86c17be2c9a4','','','J. Bot. (Morot) 7:299.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e31dad0e-400f-58d0-ab9b-43b997130a10','','','J. M. A. Franco, Nova Fl. Portugal 1:159, 551.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('552a7db6-c60c-5350-aa5b-e107ecc5122c','','','D. Oliver, Fl. trop. Afr. 2:106.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e683366-fc29-5e02-9b3e-66305ff361f7','','','Compt. Rend. Hebd. Séances Acad. Sci. 133:241.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db99a611-a455-537e-963d-43e003fdfb42','','','Rhodora 13:240.  1911 "<I>eatoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ad30360-4c58-55fb-8f6c-4b4ec8087be8','','','Proc. Amer. Acad. Arts 17:372.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f5b54d7-827d-5e27-aa8e-220f3a1ede22','','','F. Cuvier, Dict. sci. nat. 26:159.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('517abe75-9507-511f-8ef7-55ff53f8f769','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 3:158.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55a4e972-0399-590d-8b3c-96fa431cdae1','','','Phytologia 2:475.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53114451-f0b0-5aff-a388-8d5b6011dc8c','','','Compan. Bot. Mag. 2:363.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a93550d6-3373-5d36-8eb2-0f31d73423bc','','','Pl. wright. 2:528.  1862 (Mem. Amer. Acad. Arts ser. 2, 8:528.  1863)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98faefc1-8d7f-5de2-b62a-d4856ee329be','','','Bull. Herb. Boissier 2:711.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d33adaed-dafb-5b41-94fc-8a9fa1f5b072','','','Malayan Misc. 2(7):88.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74f32753-5719-5278-82a0-89d88b4a7b6f','','','Hochgebirgsfl. Afrika 158.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db82a9e3-f3bb-5eab-8ed4-d85887d63a49','','','Verh. Batav. Genootsch. Kunsten 2:474.  1780','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9379e348-1a35-5720-bcb7-8252e374ad39','','','Ark. Bot. 29A(11):22.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a9ea293-e0ee-56f2-97af-a24f2399942b','','','Arch. Bot. Mém. 7:11.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed451197-0956-57ef-b78e-62fb84b93ad4','','','Fl. atlant. 1:243, t. 63.  1798 (non Mill. 1768)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62bb375e-dd31-5409-8e22-aabe1c432063','','','A. L. P. P. de Candolle, Prodr. 13(1):701.  1852 "<I>drummondi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12abf42b-9ea7-5ab1-8e2f-db8b1d2cb58b','','','C. S. Sargent, Pl. wilson. 1:370.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d75f721d-c955-545f-8ed3-fc2a1fc5995a','','','Proc. Acad. Nat. Sci. Philadelphia 1861[13]:460.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea88f409-6f17-56d5-80dd-5e44f2ce18ee','','','Compan. Bot. Mag. 2:44.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee37c8b9-20f9-5d3b-8931-cb936877dad5','','','Tabl. école bot. 43.  1804, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f6b3d11-a6a7-53ea-a7da-9cf14740bde5','','','Bot. Mag. 27: sub t. 1089.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49599e53-b5eb-5cb0-a9ac-2f998b7fab43','','','Bot. Zeitung (Berlin) 12:652.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95d364ca-ae35-5266-94ca-53989d5e8e6b','','','Pl. bequaert. 1:352.  1922 "<I>angusti-calcarata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('906be090-02f1-5326-a351-e3573f924a9f','','','Prim. fl. amur. 83.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bad0810-b71b-5fd9-a4d8-3a6f77a6e179','','','Fl. nov.-zel. 1:136.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e98b9ff-5feb-5850-87ed-98d1a44b88e4','','','Bol. Soc. Brot. sér. 2, 32:53.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05841229-9a4a-5550-9b4f-4ac75973f793','','','Enum. syst. pl. 14.  1760','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b535c6b-c17a-5c9b-a1e8-773bdd7269eb','','','W. H. Brewer et al., Bot. California 1:557.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('622a3835-7527-5f99-abed-8332a7088420','','','J. C. Hasskarl, Flora 49:435.  1866 (J. E. Teysmann & S. Binnendyk, Natuurk. Tijdschr. Ned.-Indië 29:246.  1867)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('265aa5aa-bb64-5888-afcd-d9be6e2f5157','','','Mém. Inst. Sci. Madagascar, Sér. B, Biol. Vég. 5:132.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('510fc9f4-07eb-5c52-bd32-76515d5d4bdc','','','Fl. Calif. 2:521.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97b450d4-c9a2-568c-a68b-dc7b0e41a85c','','','Cat. pl. horti monsp. 78.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad118ee4-0fa3-5ed5-acb4-fb83ed8710a2','','','Syst. nat. ed. 10, 2:1305.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d861368e-a8e8-5ea3-bf70-eafc1b033bcd','','','Prodr. 3:235.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d7f0605-4e5e-5cfb-8d4d-94cabf6b4bbe','','','Sp. pl. 1:493.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98dc626e-3956-5b9a-a010-abe21343cafa','','','Autik. bot. 94.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('389c4f66-2bca-5978-bf3c-2ad846efb652','','','Sida 14:110.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5614ba51-7b8f-55be-a133-ddf771950885','','','Proc. Roy. Soc. Victoria ser. 2, 35:101.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a0a4fb2-5c96-5f44-a63f-a44390774b3a','','','Pl. wright. 164.  1860 (Mem. Amer. Acad. Arts ser. 2, 8:164.  1861)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec4237ca-1727-5bf2-998c-c54f0236cfdf','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 9:350.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6201eeee-3285-5c0d-8b75-6cce0876d873','','','E. H. F. Meyer & J. F. Drège, Comm. pl. Afr. austr. 147.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b81b7fd7-e2cf-5bf4-8331-3b4d55d8f484','','','B. A. Fedchenko, Fl. Asiat. Ross. 8:62.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cef7c1f-83c5-56a9-9476-3921e649a470','','','Bot. Jahrb. Syst. 50(Beibl. 111):17.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3174fa09-1698-5ebb-a2d6-f1c5f1c75ff7','','','A. L. P. P. de Candolle, Prodr. 14:20.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('826d5c54-ddd6-59ec-9930-742458a84b59','','','Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 27:508.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13ae0a7b-95ea-577f-8d21-b7c07330e367','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:156[folio].  1823; 6:198[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b63e5b66-1ab5-5560-bf0b-7a412e15492f','','','Mant. pl. 1:41.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b44d965-85ca-50ea-8bff-4fcf309bc6e5','','','Hort. kew. 3:251.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f063d701-ef0f-51a6-8e24-170268a5f2d2','','','Nova Acta Acad. Sci. Imp. Petrop. Hist. Acad. 7:357.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d4d05f9-d122-5d30-b0dc-a7a9f3958c65','','','N. Amer. fl. 25:75.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9f07b96-c871-5e0e-ba02-7df645f822ac','','','Revista Jard. Bot. Nac. Univ. Habana 20:167.  1999, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94ba06a7-cf61-5613-8ea9-1f1cc8a3559e','','','Bull. Mus. Natl. Hist. Nat. sér. 2, 4:124.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0625c5b0-a510-5090-8548-f3c49c745965','','','Linnaea 8:513.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c09634b8-3008-56a3-9798-f96d719170c5','','','J. Bot. (Morot) 4:142.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14609aa0-5497-588c-a742-6c348805539c','','','Hort. brit. ed. 1:322.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ad7d652-56f5-545b-9068-055408dd3263','','','Bot. Mag. 39: t. 1604.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8c2b68f-f3df-5ec9-9480-7372396f6f8c','','','Bull. Herb. Boissier sér. 2, 7:162, fig.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('595ddcd3-71b9-5a4c-89af-a498132e000b','','','Amer. J. Bot. 26:539.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7143291-f8f4-5cd8-b606-100235c97569','','','Novon 28:151.  2020','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7f0aa03-4453-51a9-9249-d3732c8fd265','','','Gard. Chron. 1873:6.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f897dd27-9188-50ca-bc35-bd4fd7ecdb4c','','','A. L. P. P. de Candolle, Prodr. 13(1):316.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31018d6b-8605-5aef-a1d4-ffb186c2bd85','','','F. Parlatore, Fl. ital. 6:482.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc42f83a-9717-5710-85fb-490e09afeb44','','','Crit. revis. Eucalyptus 4:43.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5e94322-6a35-58ad-ae69-39f27337983c','','','Bull. Calif. Acad. Sci. 1(2-4):66.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0e2ae83-5354-5b72-8f80-7d7d2ca23916','','','Repert. Spec. Nov. Regni Veg. 11:167.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('793c7ecb-dd10-5e8b-b9e9-57e6c85476ee','','','Sp. pl. 1:318.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e4c6dbb-5083-5aac-8247-b3b410942496','','','Prodr. fl. Corse 2(1):48.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47edd10c-4ada-58f5-ab65-7543958607e6','','','Linnaea 23:634.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03375d3a-f227-5d51-ab5e-ac0522bdeaa2','','','Feddes Repert. Spec. Nov. Regni Veg. 58:250.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4950bd4b-4205-5c13-8960-cab37bd8e087','','','Telopea 13:234.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab3bcfef-30ec-59a4-ac6c-de8b9f371a12','','','Bol. Inst. Nac. Invest. Agron. 9(20):199.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('759442fc-71a0-5311-8e5c-b3c6d8c9f8e8','','','Proc. Amer. Acad. Arts 25:160.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c1560eb-ed59-5af9-930f-baa3fd1b8eb0','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 40:58.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('904efc08-f35a-5131-a72c-36b033413e96','','','Bothalia 4:956.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00958c34-69f8-5c2a-abca-24474f1f3f7b','','','W. B. Hemsley, Biol. cent.-amer., Bot. 3:195.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5051929-9dcb-50b3-935b-7fb1cfc5e408','','','Ann. Sci. Nat., Bot. sér. 3, 14:72.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a31c908-2185-54de-ba53-482476ec6760','','','Ann. Sci. Phys. Nat. Lyon 38.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1b18ba7-36cb-5062-a0ee-a3ec0fc351e7','','','Notizbl. Königl. Bot. Gart. Berlin 6:76.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82b43eb9-f3f0-5f80-8bde-fcdb136e04a8','','','Oesterr. Bot. Z. 106:368.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8260b715-45de-50f9-9d94-24158c0028a1','','','Nova Acta Acad. Caes. Leop.-Carol. German. Nat. Cur. 68:220.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44cfd551-b325-5c46-9b9d-abc948b567a7','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 329.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f2fc779-a680-5fe6-a485-3b07f8c04738','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. ed. 2, 18a:446.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20946bb2-aa77-5e9a-9e93-0cc2d0b01b65','','','Ann. Missouri Bot. Gard. 14:259.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('805d555f-5836-5191-a4ba-29b4c831fa36','','','Bull. Cl. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 10:322.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98968206-7f0d-578b-a47b-7d90104a7a4c','','','Syn. gen. Compos. 143.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee361d9c-37d6-5473-a785-79a4a474010a','','','Vollst. Pflanzensyst. 1:618.  1777 "<I>aurantifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcbf04a7-d7b9-5847-8e57-34bb83a11986','','','Telopea 9:447.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0dab08c9-ca0c-5fbc-8aa1-ff7079a7ea8f','','','Mitt. Bot. Staatssamml. München 23:432.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb738874-4a61-55a5-a4d6-7565c465b98b','','','Fl. angl. 328.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8269777-d3ab-51df-8dc3-b424f7b692d9','','','Sp. pl. 2:1002.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a69f98c-bd9a-5ddf-b648-4d5eed872e86','','','Rumphia 2:97.  1839 ("1836") "<I>filamentosa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99fcca21-a573-5c35-ac59-a3186f4c7036','','','C. F. P. von Martius, Fl. bras. 3(1):27.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37e9f56d-c65c-5de9-8c66-88f4ffb2c5a9','','','Bot. Bull. Acad. Sin. ser. 2, 41:159.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7d8e3df-ae1c-5a5f-b302-658fbeabe00a','','','Harvard Pap. Bot. 9:157.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('feea5b1f-b400-5e8e-bc26-11302873c6b7','','','Sida 8:317.  1980 (non Thuill. 1799)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1478e5bf-2c0e-51bc-8dd5-16faab3c72a0','','','Bot. Gaz. 125:108.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16949bb4-0268-5a8a-8e78-eb5b4c6deeed','','','Vilm. Blumengärtn. ed. 3, 1:1086.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5b96eb2-9cd7-5516-9bd8-a3df9542d460','','','Syst. nat. 2(1):370.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d27285ae-d220-5826-9c34-d97f4e009216','','','Bothalia 11:387.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2606445-f29b-5f31-a550-287e514eecc9','','','Landw. Fl. 31.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce0bbf91-95d5-54df-ac10-b50f413ae9ca','','','Taiwania 5:39.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a97dec5d-e312-57c3-a56f-852ee035443b','','','Mem. Acad. Sci. (Paris) 1786:5.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('282ba187-6f93-5c44-8c52-426668e5594a','','','Mem. New York Bot. Gard. 1:330.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b58d5e00-40ef-5cee-bf50-957c9e34f413','','','Ill. lign. pl. N.-E. Chin. 316.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('887021c9-0e48-5935-874b-d3d27c2c4af6','','','H. G. A. Engler, Pflanzenr. IV. 147. II(Heft 44):57.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a7bbade-85af-534d-9ba7-936156b78afe','','','Repert. Spec. Nov. Regni Veg. 23:224.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acbe8e3b-6e50-5e29-b0b9-7dc90ec5298c','','','Haworthia revisited 62.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efd35286-4044-5cff-b7fc-35186a2ab3f9','','','J. Jap. Bot. 51:132.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a32e668-06df-5d78-93da-fa7476de089f','','','Torreya 7:236.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67b04a6f-51e6-5c5f-b946-86cbd3de041e','','','Fl. Serres Jard. Eur. 6:111, 136.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70ec741a-3871-5938-9364-65070ce15b3d','','','Deutsche Bot. Monatsschr. 18:132.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5cedc3b-8fd2-5301-82be-36092cd867e9','','','Repert. Spec. Nov. Regni Veg. 11:132.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94af17fd-3fa5-5f79-8001-5de38dd58233','','','H. G. A. Engler, Pflanzenr. IV. 38. III, II(Heft 33):206.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1ad2f2a-9ff3-5c92-ae0a-a3e359b51eab','','','Cact. J. (Croydon) 7:56, fig. 14.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d5edb71-8d9c-5fe9-886f-ee6f91c94a35','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 4:205.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad61f0ce-2109-509b-9cfb-0a13cee6f605','','','Bull. Soc. Bot. France 55:649.  1909 ("1908")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19a4f09b-e9fd-5a72-9d2a-adaf2696f3ee','','','J. Arnold Arbor. 19:276.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9c99baa-2d26-568d-a615-99fcb5414cf6','','','L. Sitgreaves, Rep. exped. Zuni & Colorado Rivers 168, t. 8.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a4a4b28-d498-5e76-95a4-41a64b63b557','','','Adansonia 12:75.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e280da0-1c26-559c-92c8-a181b7e92f95','','','Contr. U.S. Natl. Herb. 20:181.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdc3ef79-a85c-526a-86bb-4414e2ad4234','','','<I>Ficus</I> 6, 12.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4dfb20e-164f-5282-96a9-982571e2f926','','','Fl. s.e. U.S. 379.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('931473e8-e2fe-5aa4-8356-f6fd8f1d004f','','','Acta Bot. Yunnan. 13:265.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09623c74-bc24-5151-8f4d-7229bf5c4c96','','','Austrobaileya 2:235, 236, t. 1.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b67cd8ab-d3ca-53b4-bafd-e850f232b5cb','','','Bull. Soc. Roy. Bot. Belgique 110:14.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59c85036-8baf-51a4-a8af-a1fbcd8f0570','','','Mitt. Bot. Staatssamml. München 28:335.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('527bb6b4-62d7-57c9-9dab-961ff42a03eb','','','J. N. Nicollet, Rep. ill. map. hydrogr. basin Upper Mississippi R. 157.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('414389d3-2542-5037-878c-cdc53dc258c8','','','Abh. Königl. Böhm. Ges. Wiss. ser. 5, 5:326.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71940a9e-8f7e-5e40-9911-558a152de454','','','Reinwardtia 5:122.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a88f9293-3e78-516a-b725-e73c7a4c7688','','','Notizbl. Bot. Gart. Berlin-Dahlem 15:523.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bc7a9dc-639c-5fbe-bca6-c5dfb8c2b7bd','','','Hooker''s J. Bot. Kew Gard. Misc. 1:244.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8e77c0c-2260-56ce-ba00-89fbbe085241','','','Fl. N. Amer. 2:430.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eea644ae-9d7d-5b27-b4da-f826e719c4c7','','','Skr. Naturhist.-Selsk. 1:20.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d8a6cff-b6f5-5dd8-a41a-dae227be62c0','','','Alsogr. amer. 56.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ce600ee-2371-5261-affb-2c18f2567efe','','','Amer. Fern J. 68:100.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d732b2b-927c-59fb-aca4-8727aa446c53','','','Pl. min. cogn. pug. 2:10.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d9726aa-b153-5960-acb1-e52518465d01','','','Bull. Jard. Bot. Buitenzorg sér. 3, 1:379.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f44877f4-b1e7-55c1-a405-64288ad575da','','','Bull. Univ. Forest. Kyushu Imp. Univ. 1:76.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bfd77f9-5d51-5204-a491-5e2053280454','','','Contr. U.S. Natl. Herb. 32:61.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c01b5350-267a-5d74-aee6-db78aa431812','','','Gram. panic. 242.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f1e57db-bed8-519a-be0f-994ed9667e0d','','','Fl. bor.-amer. 1:88.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d7e2227-436a-5db2-bee4-f94d90b0bdb4','','','Contr. Gray Herb. 104:73, t. 3.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e588b3e-5455-552a-b531-85d798cb5d88','','','Prodr. 2:453.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a15dc69e-7649-500c-b19f-5f95675138cb','','','Mitt. Deutsch. Dendrol. Ges. 3:51.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('513c458e-ed33-5708-9362-2820cf234704','','','Beskr. Guin. pl. 203.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ce10789-cc60-5edd-a8d1-3ebaeb750514','','','Suppl. pl. 421.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9ae41d9-38a2-5d95-9b7c-9e024d48a777','','','Boll. Reale Orto Bot. Palermo 7:106.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9afce520-02db-5273-945c-37513d5d55b4','','','Engl. bot. ed. 3[B], 8:275, t. 1383.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f248a6f-97fe-5c98-8993-654b0f59e594','','','E. Wilson & Rehder, Monogr. Azaleas 138.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('315f5773-8063-5fdb-998b-b0eb29e4efe0','','','Syst. Bot. 16:243.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb60cd83-36e4-5f47-9d48-43247479ab58','','','Sp. pl. 1:62.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdac733b-6182-592a-bbd0-5fd8f630a502','','','Hist. pl. 12:166.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b05dc7a3-d7cf-529e-adb4-1fe4399ad600','','','H. G. A. Engler, Pflanzenr. IV. 129(Heft 53):207.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31695d3c-5085-58e5-a5d3-ac2c3948a27e','','','Syll. fl. Eur. 365.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b07e3f9-93ff-5dd0-bf1e-9b74e6f79589','','','J. Washington Acad. Sci. 45:110, fig. 1(a-h).  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ad5d6d1-a66e-5ec1-9d05-0d0f472a127f','','','Monogr. Fam. Caricaceae 143.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8894d514-a7c9-56b6-8829-89064ce78617','','','Arch. Jard. Bot. Rio de Janeiro 3:41.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('960500b3-9ca2-5bca-96c8-d823d1cf3bab','','','Syst. veg. 3:516.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e89fe04-f068-5b8f-96a1-2643eab885ed','','','Sp. pl. 2:668.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b385c524-ea4d-59f0-acec-cfe9f770a230','','','Fl. carniol. ed. 2, 1:207.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cd5eff9-4225-5028-8962-452e718645cf','','','Syst. Bot. 7:331.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7cb98f1-21a8-58fd-bbab-5cfd88fca94c','','','Aroideana 8:112.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ff7c4de-3db4-5ecf-91fa-36f2da09462f','','','Compt. Rend. Hebd. Séances Acad. 140:1612.  1905 (Ann. Mus. Colon. Marseille sér. 2, 7:74.  1909)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09ef7452-2cdb-5d2b-bc53-321017b62ea0','','','C. F. P. von Martius et al., Fl. bras. enum. pl. 2(1):248.  1829 (Agrost. bras.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9361bb2b-6bd9-5f71-9468-a46b08b5985f','','','Allg. Bot. Z. Syst. 12:97.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ce9c94e-93d0-5561-9a56-c6e3f21b44c1','','','Rev. Jard. Bot. Nacion. Univ. Habana 12:43.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbbad8a6-f824-524b-943a-49cae938af29','','','Kew Bull. 36:79, fig. 3(32), 7C.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aefdcefe-4e26-5c8d-af0b-3e299373b544','','','Bull. Herb. Boissier sér. 2, 5:108.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d1ffd50-a8f9-5974-aee5-788afd98c4fa','','','Darwiniana 15:104.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53f19457-1b92-5f50-9528-366fd290bf35','','','J. Elisha Mitchell Sci. Soc. 15:55.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f538dc06-0b33-530b-be57-218b8d015208','','','Bull. Mens. Soc. Linn. Paris 1:254.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd475cee-63a7-5405-ae7d-00ee4157d998','','','Trans. Linn. Soc. London 20:211.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f13a90d-306b-5ff1-9947-751ee714c371','','','Bot. Gaz. 21:133.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('385a2f74-ab7b-562e-9b6b-fde0121a4e2f','','','Contr. Gray Herb. 129:8.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cf4dcda-73dd-543d-9560-86a53518cff5','','','Bot. Mag. 122: t. 7457.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d41657cf-a9dd-5545-97a7-6504a3b026f2','','','Ark. Bot. ser. 2, 1:321, t. 19.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14f85c11-ff04-58a7-8e60-504425b59b54','','','Fl. trop. Afr. 9:434.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11321c50-d7ac-50ec-8d4a-e6cfba87303c','','','Madroño 43:453.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68a8ae48-52fb-59d4-b0be-d29a2ac4727a','','','Sp. pl. 4(2):918.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc780797-6a76-5ae5-a516-c1028a235e95','','','Gard. Chron. 1854:836.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6518968-0004-571f-a13f-210e13c471be','','','J. D. Hooker, Fl. Brit. India 2:495.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77d2da2a-2ea9-5666-9180-c2cb66a13f06','','','R. K. F. Pilger, Verh. Bot. Vereins Prov. Brandenburg 47:120.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34017932-5067-591d-9a66-375f098a167a','','','Astragalogia 119.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e9447a3-531f-527d-8cbe-68b5835c265d','','','Scroph. ind. 50.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c95ff79-38fe-5187-a5d7-6819927d3459','','','J. B. A. P. M. de Lamarck, Encycl. 4:696.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cf70948-03d0-51df-82fd-1e93647eb61d','','','Tabl. encycl. 1:181.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1447faa6-2edf-54ac-8701-9d90adfa3755','','','Sp. pl. ed. 2, 2:1672.  1763 "<I>laevigatum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28c3988a-2089-588d-ae82-0ff677debee9','','','Bradleya 9:91.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2889749b-1f59-5d7c-89a4-67abdb76cff8','','','Occas. Pap. Bernice Pauahi Bishop Mus. 13:75, fig. 1.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('437c80cf-e999-5177-ab36-b7a6266c90f8','','','C. F. P. von Martius, Fl. bras. 15(1A):72.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('173f2b73-31f3-5d19-9fb2-5a67a620dcac','','','Gen. sp. orchid. pl. 66.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8040a76-80ce-5f74-8fbb-ff49feab1b9a','','','Rep. (Annual) Missouri Bot. Gard. 22:62.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e909da28-6e2b-50e2-918f-34623ef7a3dc','','','Diagn. pl. nov. 1:9.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2589a6d3-802b-5e9a-bc3a-9c47a1d7d76f','','','Handb. Skand. fl. 182.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d303c8a7-1116-5cb7-8fdb-bf325c3e6bea','','','J. Bot. 21:203.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c549e57-c100-50f9-801a-115d1acb99f4','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 5:313.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f982e99d-8a15-5b4d-af01-6a7d754296cf','','','S. African Gard. 24:71, 82, fig. B.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c38b191f-d1b5-5bf8-b737-5cb28a6d8946','','','Prodr. 2:342.  1825 (non Schangin ex Pallas 1793)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eaa32513-4902-5c98-90c9-edaef71db8c4','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:82[folio]; 6:104[quarto].  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab448c70-9aff-52d8-8b9c-8f4eccb4a0a6','','','Ann. Sci. Nat., Bot. sér. 2, 7:286.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f28f3a2-3af6-5e57-850f-8df653566448','','','Linnaea 2:156.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('734aa3cb-60e0-576e-b51c-ec1dfed68791','','','Pug. pl. nov. Syr. 16.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93bbc226-6f3c-5076-b6de-6f571264e518','','','Victoria regia 3.  1837, pro syn. (Edwards''s Bot. Reg. 24: misc. 11.  1838, pro syn.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae8ef772-9683-5a41-a186-6502ddd133e5','','','Acta Phytotax. Sin. 34:98, fig. 1.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cf59998-aa4e-55dd-8c40-c54b8747f4eb','','','Baenitz, Herbarium europaeum 9550.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29c12054-f6d0-5166-b817-606fa028bf4d','','','J. Linn. Soc., Bot. 39:408.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d10fed10-3c2f-5cb3-903b-2ccce2da524d','','','Nov. gen. pl. 3:59.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc237aa2-a7d2-58b0-b1bb-62e094e5c440','','','H. G. A. Engler, Pflanzenr. IV. 165(Heft 98d):927.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dafc7e67-330e-56d9-aa69-1c29403a6b27','','','J. Torrey in W. H. Emory, Rep. U.S. Mex. bound. 2(1):84.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e809640c-4d9e-52fd-8136-ff16c2069c64','','','Prodr. 2:160.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a03bfe0-ab70-572e-bebe-40171330869b','','','Arch. Biontol. 2:431.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55b9c286-0c68-5dcf-a52d-37d4934f552a','','','Icon. Pl. 4: t. 322.  1840 "<I>betulaefolius</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8515ccd-b409-5f7e-8d10-2ac000601940','','','Bull. Misc. Inform. Kew 1915:208.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3247d4d1-3479-50c7-843c-36b41756457e','','','Gentes Herbarum 8:501.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76e2e299-9912-5319-9306-35004a3607a3','','','Prodr. 4:138.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9efe0c44-39be-5cb2-b33d-75c6ada86f89','','','Syn. fil. 127.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67af4dad-fabd-5943-8319-593db6af3d07','','','J. Roy. Hort. Soc. 58:61.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e34ef96-51f6-5eae-a025-38e7ecadac0c','','','Phytologia Mem. 7:33.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eaf999da-3f7a-55a6-b5bf-dd98302e33b1','','','Bull. Torrey Bot. Club 45:409, t. 10, 11, fig. 4.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('933cb303-765a-517b-b5cc-79f2365bc537','','','Bol. Acad. Nac. Ci. Republ. Argent. 3:337.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfc8e716-3c82-5fb4-bb36-2eb2e55a3fb4','','','Notes Roy. Bot. Gard. Edinburgh 11:161.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91176493-3fae-5ad6-aa98-334ba4fe6557','','','Bull. Misc. Inform. Kew 1921:14.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4182e94-9475-555e-8ca3-799b4979c940','','','Baileya 5:195.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e52583e-981b-5552-9c85-1b701a87d2a1','','','Fl. N. Amer. 1:32.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb003993-31db-52c1-bab2-1eb437922f8f','','','Giorn. Fis. Chim. Storia Nat. Med. Arti dec. 2, 3: t. 6.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('919ed87a-eec0-55b3-9b6f-bf8acb4f1ef3','','','Bot. Beechey Voy. 64, t. 13.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88667069-5e1f-5311-a376-97cf7e138e8f','','','Cult. Prot. 107.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2e5b333-c18c-5deb-a974-5dc0e3e7632a','','','Begonian 38:29.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7dc80f9e-0ff3-5129-9222-1d9f7c57a101','','','Bot. Mater. Gerb. Inst. Bot. Akad. Nauk Uzbeksk. S.S.R. 19:58.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0d0b21b-7fe5-5410-9d93-c98b63fa72f1','','','Novon 22:118.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('014709b7-3693-5000-a08c-757eca967eda','','','Man. bot. San Francisco 64.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c2b6894-c2b0-51b0-8724-eb8e44aab5d6','','','Bull. Torrey Bot. Club 21:172.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27a3725a-36ac-5599-aca8-d2a232dab4b0','','','Ann. Mus. Bot. Lugduno-Batavi 1:251.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('966bd6fa-7acd-54ef-b300-a32846d7b4b3','','','Trans. Med. Soc. Calcutta 8:10.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c28e5ae-7bd3-53e2-bac8-908625048675','','','C. F. P. von Martius, Fl. bras. 15(1):194.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('971d69e7-8bc4-5347-8261-8cdadf7788d1','','','Leafl. W. Bot. 5:189.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('675faca4-9f82-5368-b4bc-7bedb1286929','','','J. Bot. 22:365.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59ad20aa-2c5d-579b-8e82-c50516570bf5','','','Fl. Kamtchatka 1:239.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e7c11b7-d265-5312-94aa-a9044bb595c0','','','Mem. New York Bot. Gard. 74(3):141.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13cb4639-cc70-57d5-941d-6263a6128d60','','','Lilloa 23:23.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eef11a7d-6b96-578f-98d9-cfaacfbaea5c','','','Bull. Torrey Bot. Club 68:124.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a6a67ec-9ab1-5bd7-8845-dd5c8599ae42','','','Pl. rar. hort. monac. t. 11.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94db553b-8132-5dde-b88d-cd6a94e12b0b','','','Proc. Biol. Soc. Washington 41:163.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adec29b2-fbce-5e00-927e-5c49e6ffde95','','','Icon. Pl. 6: t. 561.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc01890e-dea4-51ff-8a98-7ed932fb2787','','','Contr. U.S. Natl. Herb. 13:299.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c3e92a8-6231-5cf7-9553-8594510b9e06','','','Fl. New York 2:302.  1843 (H. Muhlenberg, Cat. pl. Amer. sept. 92.  1813, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b9527f7-4215-561d-98a1-ac2c7d87e9da','','','H. G. A. Engler, Pflanzenr. IV. 129(Heft 53):77.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e4769cb-1eae-590c-9a0c-d219c4e1b39e','','','J. Jap. Bot. 2:7.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfec9ba1-caea-5cfd-b320-674937a8349a','','','Dansk Bot. Ark. 33(3):192.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e6bf054-1123-5cca-84a6-09c2b0b22a4a','','','Proc. Biol. Soc. Washington 21:7.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69592c80-cbf6-5ffa-9d96-ddcc4ba84cc1','','','C. Gay, Fl. chil. 6:436.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3c0de6c-0617-55e6-b71f-8a03ef8e59cb','','','Phillip. J. Sci. 60:234.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e201c33d-35c9-5e72-bb90-7f37688b03dc','','','Herb. amb. 15.  1754, nom. inval. (Amoen. acad. 4:125.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c5b2db5-11dc-5df2-b86d-8f2f43853b57','','','Sp. pl. 2(2):1154.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1729704d-9fd1-5c98-9743-03691289fc03','','','Sp. pl. 1:464.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e978eb8c-4ccf-51f6-809a-0cf296701001','','','Haseltonia 5:18.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f58a3036-08c6-5050-b6e3-12880fd13013','','','R. F. Hohenacker, Algae mar. sicc. no. 426.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44193ec9-89ae-5f3a-b3fe-2b5786c568f7','','','V. L. Komarov, Fl. URSS 4:468.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33386509-1d3c-512c-ae70-17c4aed8c000','','','J. Bot. 74:40.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40f59d8b-8a01-5212-aefe-b5ec10fd05b7','','','Természettud. Közl. 29:208.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cba35fd9-f0d8-5020-af68-a4cfd58e1662','','','Tent. fl. abyss. 2:388.  1850-1851 (Flora 24(1, Intell. 2):19.  1841, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29b02605-b741-52fa-b646-5b05892cdbd3','','','Biblioth. Bot. 17(Heft 72):140, fig. 59.  1911 Jun (Sp. rub. 140.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('410ef996-b709-5e92-bc27-81762c65d1c3','','','Syst. Verz. 20, 44.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97cd1128-7184-52c9-8e54-788d275e58b2','','','Ill. Hort. 20:171.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcfc1409-2ef9-55a1-b05d-c08d5e2b632f','','','Fragm. 5:183.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1c00af5-ef21-5c19-8188-5679275a7613','','','Annuario Reale Ist. Bot. Roma 6(3):186.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('caf54b1e-922d-5a37-aafc-8fc00838a5b4','','','Mem. New York Bot. Gard. 8(4):425.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88455aed-1042-55b2-be40-2e7409cb6fb8','','','J. Linn. Soc., Bot. 9:128.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73a035db-2fce-526e-9edf-d5a995aa9e09','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(3):230.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e56b3443-b94a-5e42-a8c7-e0ec8340b627','','','Labiat. gen. spec. 551.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4dfae849-c034-56fc-ab5d-049c2d437ff0','','','Bot. Zeitung (Berlin) 16:145.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c38a178-7d5b-5c6e-826a-29ccd7bd2511','','','Philos. Mag. Ann. Chem. 2:350.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7703dc5a-6445-59b4-8900-fd9aac8bc2aa','','','Queensland Agric. J. 15:899.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0f6d2b6-305b-5799-99d3-f53c5b410f02','','','J. Proc. Linn. Soc., Bot. 3:91.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b95eeaa2-74cc-5b2c-a674-232d903c64da','','','Fl. flumin. icon. 10: t. 121.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e0026ad-5af4-53e0-8373-a889d04ffdfb','','','Abh. K.K. Zool.-Bot. Ges. Wien 4(5):25.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73692a7a-18fa-534e-bb21-6bb2a0cd06e5','','','Erythea 7:6.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('629c16c1-7c63-5cba-9763-43e2bdde8c7f','','','Mem. New York Bot. Gard. 27:83.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ae659a1-19a7-5f60-9ba9-0fc9688666d3','','','Contr. fl. Brit. New Guinea 1, cum t.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14e6569a-7206-5fb8-a1be-fdce652c66d2','','','Rhodora 47:401.  1945 "<I>alismaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('989331f9-f1a0-5a0c-b0e8-520b0d381c9c','','','New Plantsman 6:132.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b1e28b1-9d41-5cc6-9528-95680333cdd1','','','Fl. ind. 1(2):194.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a8174f3-2daa-577f-af87-b86297afe766','','','Erythea 3:117.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92f824a1-12eb-5e15-aa00-31ff6f3c4d0d','','','Hort. Belge 3:322, t. 68.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5023ff5-9e95-5b95-8f10-cae56e4b3a93','','','L. Diels, Bot. Jahrb. Syst. 29:594.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d04f08a-aa58-5298-94e6-4d93922bfd0a','','','Notizbl. Königl. Bot. Gart. Berlin 2:127.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aeedd5f8-f1d1-5a32-b179-86e77ced2ae1','','','Trav. Inst. Sci. Cherifien, Ser. Gen. 19:447.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2be53cf8-0a70-5e41-aff3-edcd1fc07835','','','L. Diels, Bot. Jahrb. Syst. 29:455.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('192a63b3-8703-5091-b304-72a62afc9107','','','Kongl. Vetensk. Acad. Handl. 1827:64.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4665d59a-62b4-517f-ac55-75f56119fcbd','','','Bull. Torrey Bot. Club 24:512.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad7a0e8c-127c-56d9-b589-b328a38f76ca','','','Hist. nat. méd. Casses 112, t. 2.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('461b2510-67ee-577b-9773-e09e2f299f36','','','Hist. nat. palm. 2:4.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f505251e-d1c6-5a4d-aafd-e499509e11bb','','','New Zealand J. Bot. 1:123.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e1cbbad-ac07-57d4-bd0a-c9c2a82fafc2','','','J. Linn. Soc., Bot. 37:437.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f05ad7c-ba16-5c40-a479-1b9edef7e572','','','Darwiniana 4:326.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92126308-3d88-52eb-b364-156c4af5e6cf','','','Kew Bull. 55:409.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0d939cc-35a6-502a-b7fc-dfc677ac6099','','','Bradleya 21:89.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4e67e7c-1af6-5a35-8b26-4b6659e12fae','','','Icon. pl. Syr. 3:15, t. 10.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdefe5ae-9bb6-5356-a614-94948a0cd50a','','','Trans. Roy. Soc. Edinburgh 22:310, t. 16, 17.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0be38a3-76c7-5852-a8dc-a94f992e2e92','','','J. M. Coulter & A. Nelson, New man. bot. c. Rocky Mts. 169.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f72005e-6018-557a-8895-873d1a07108c','','','F. R. Fosberg et al., Micronesica 15:275.  1979 (Smithsonian Contr. Bot. 45:29.  1980)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a5a93e3-77f4-591e-86d4-b86938043d44','','','Kew Bull. 15:6.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fec2c544-e5dd-577b-8b22-0743bbe60d42','','','Fl. Brandenburg 1(2):544.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c6f175a-4e60-51e6-8cc1-f12a205fb646','','','C. Wilkes, U.S. Expl. Exped., Phan. 15:309.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bb3b413-7040-5c72-8ac9-f6fcd8fd3815','','','Gard. Chron. 1856:301.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de81834a-6d0b-5b22-9057-f5e13abd307c','','','Erst. Beitr. Fl. hercyn. 287.  1840 (Linnaea 14:657.  1841)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c3c992a-4f0e-5cc8-883e-ffe53c68689a','','','Encycl. 3:584.  1792 "<I>persicaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e71796d1-29ef-5aae-b599-228ab5ca101e','','','Phytologia 21:296.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('009da076-b469-5032-936b-0a5789a234f9','','','Fruct. sem. pl. 2:98, t. 102.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b491a45-b3db-59d2-a04f-4c511680610a','','','E. Nasir & S. I. Ali, Fl. Pakistan 143:618.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16e4f0df-3fef-537f-9220-1c5d074ce20f','','','F. Schreve & I. L. Wiggins, Veg. fl. Sonoran Desert 1:709.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb30a803-8315-5ccf-ad26-89d67ecb810e','','','Nov. pl. expos. 32.  1933; Tijdschr. Natuurl. Gesch. Physiol. 1:162.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01056be1-44fa-528d-b647-b9d61cdb7aa0','','','W. H. Emory, Rep. U.S. Mex. bound. 2(1):225.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4da444fa-9ee3-5b53-97e9-103e649b5a30','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 5(2):408.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9470d368-3118-58c2-a0ba-65985b6c13f2','','','Gen. sp. orchid. 178.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65e41295-12d0-50f9-bbae-fe20315a47ef','','','Hist. pl. 1:159.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65ccefe4-fdc1-59a9-ac3d-ee253ea4788b','','','Fl. austral. 6:171.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a705782b-a99d-58d4-af06-0b185d2bbec2','','','Bot. Reg. 3: t. 215.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94e4511e-db56-522e-ae26-4c7e0b13e140','','','A. L. P. P. de Candolle, Prodr. 10:324.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e52f3e7-8ce4-5fd8-bbda-f69a2da24d42','','','Man. bot. San Francisco 313.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a41854a-25be-5f0d-af3b-bb2079783a50','','','Kew Bull. 38:485.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('334a8915-2ec8-5eec-936a-767f7ad3016a','','','Hist. pl. 2:466.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('512a3c73-578d-56d9-af48-feb4087e148b','','','J. Bot. 55:40.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f85dc479-cc46-54a9-b624-40956a1c4f1b','','','A. Guillemin et al., Fl. Seneg. tent. 1:70.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cc2ef13-cb16-5de2-a0be-da1788a6d937','','','Sp. pl. 3(1):651.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6b9ccec-9bdd-5fab-950e-b10b6225f480','','','Linnaea 3:23.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c2f2259-a8bf-57dd-a90a-3cfc9bdc5835','','','J. Roy. Hort. Soc. 76:217.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f985e680-a980-531b-99cf-322f5aaaed98','','','Kulturnaya Fl. SSSR 1:249, 250.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40c92bcf-d2b7-575c-b56d-7401e4e183ac','','','Bot. Zeitung (Berlin) 24:376.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40f16bb3-d495-5222-9f0c-be5b5eb4ab73','','','Bot. Mag. (Tokyo) 12:37.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a39865cd-020f-5631-801b-14d828410814','','','Fl. Amer. sept. 1:333.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ed8c02d-c24c-5339-8e5f-2844c6e7621c','','','Man. pl. Transvaal 2:xxxiv, 421.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c5dc526-e226-5fc1-83ad-50483dfb2328','','','Univ. Calif. Publ. Bot. 13:38.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fed80569-35a4-5832-9b33-5de673d093d1','','','Amer. J. Sci. Arts ser. 2, 6:81.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f18384d5-26b9-5cf6-bd29-31a62c058bc8','','','Notes Roy. Bot. Gard. Edinburgh 5:230.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa0c714c-1401-5231-beed-d4f01b83976f','','','Notizbl. Bot. Gart. Berlin-Dahlem 11:268.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4337b10-72b6-5e1d-b31f-dc28f1c6cb7d','','','J. Arnold Arbor. 24:51, t. 4f-g.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8484384-4fa5-515a-8bd2-ffb8410ce89d','','','Fl. Pl. South Africa 22: t. 853.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8faeb38b-a09f-53ea-80a2-6d1e83ca481e','','','Pl. bras. icon. descr. 1:38.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49d88b66-3b59-5e4c-808d-ba3c50429160','','','Bull. Gov. Forest Exp. Sta. 57:157.  1952 (J. Jap. Bot. 31:152.  1954)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa727b30-367b-5ebc-bc48-9354aa9ced88','','','Bot. Reg. 12: t. 965.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afdd7e62-c836-50e0-b53e-172a5a65f17c','','','Bot. Mater. Gerb. Glavn. Bot. Sada R.S.F.S.R. 4:18.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcc07523-823a-5c7f-a5ed-3d5d45fdd9b8','','','Bijdr. 742.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6993c527-fa22-536e-9ee0-744ac812d0e4','','','Bull. Mus. Nat. Hist. Nat., Sér. 3, Bot. 35:15.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('943902f3-666c-5d4b-8948-2b95adb05499','','','Pl. wright. 2:72.  1853 (Smithsonian Contr. Knowl. 5, Art. 6) "<I>betonicaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12f4231b-1e99-556b-be61-0b1058d04778','','','Ess. Agrostogr. 102, 146, 180.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd2e5b74-8cdf-5d5f-a9fa-c68514c98057','','','Bot. Zeitung (Berlin) 18:104.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('decb17fc-dfa4-5bf3-86b7-039c86a75998','','','Linnaea 43:105.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79e7d357-fb1b-530a-b99d-522061c43c62','','','Pl. bras. icon. descr. 1:18, t. 10.  1826 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c03438cc-4381-5097-a382-9ae70fb82f53','','','Bot. Jahrb. Syst. 46:129.  1911 (non C. B. Clarke 1882)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d25e43ff-2087-5037-96e8-42b2d76eaa65','','','Phytologia 1:138.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfbcaab5-c9f6-50d3-a130-6b5c55bc972a','','','Agric. Ledger 5:36.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6ab80f3-438d-5ea0-a0f7-1b40b512310c','','','Sp. pl. 2:753.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecf174d7-bd23-5e5c-83df-1c36b5b01d37','','','Sag. stor. nat. Chili 168.  1782','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c9e0dc0-b833-52bf-b78a-2ae395f02523','','','J. Bot. Agric. 3:163.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae4fa9b1-397a-5424-8b2e-b62f16b86f8a','','','Saxifrag. enum. 2:5.  1821 (Revis. pl. succ.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6557c237-0eb9-5fde-a46f-bae99e73a2bf','','','Repert. Spec. Nov. Regni Veg. 31:140.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b47bf3c-3178-53fa-b561-997f6f499320','','','Ill. fl. jap. rev. ed.:362.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad8aba55-3369-53fa-8f5c-124956c41aeb','','','New Zealand J. Bot. 33:196.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2205f25c-4456-5609-b424-70299c3dc431','','','K. M. Schumann & C. A. G. Lauterbach, Fl. Schutzgeb. Südsee 130.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4d5ca0d-5151-5e30-8968-3735aa6b9ed9','','','Fl. ajan. 79, no. 85.  1858 (Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 4(2):52.  1861)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5804a8df-f38f-5e27-8ebb-b65fc985c39e','','','J. Acad. Nat. Sci. Philadelphia 7:74.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e3fad69-346e-5750-97cc-ed68eb98b5fd','','','Rosetum gallicum 106.  1828 "<I>borboniana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b9a61da-6231-5f0d-90d0-de839dab67b7','','','Bull. Misc. Inform. Kew 1892:85.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e30a0ccb-0b80-565f-ae1c-a8a174ed594e','','','Syn. fl. N. Amer. 1(2):404.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43e352a3-6de2-5c30-9fc8-e6fba16922bc','','','Univ. Calif. Publ. Bot. 4:218.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44b507fa-cd07-50e4-85bc-ef73ff24eee3','','','J. Malayan Branch Roy. Asiat. Soc. 11:89.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e05a937-ac20-57bc-a2a9-bb6a9fbe9bba','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 5:314.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c1087f9-8e72-5cb8-9fcf-bf210af41ddd','','','Fl. peruv. 1:18.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69f9d58f-d374-506e-a078-ed1a12b4520b','','','Trudy Prikl. Bot. Prilož. 47:441.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1ab4a95-3a08-5465-9f50-3f19a29f6bb5','','','Notes Roy. Bot. Gard. Edinburgh 11:135.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91112509-4b5f-5cfe-a570-1124d13700a5','','','Cactography 5.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d23c770c-b148-5774-bfc8-ddedb87699a9','','','F. L. E. Diels & E. Pritzel, Bot. Jahrb. Syst. 35:426.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0d37c60-4113-5d8f-b109-b663dc2189fd','','','Ann. Sci. Nat., Bot. sér. 2, 4:80.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b073892a-129c-5e1c-aaa2-eadb471af24e','','','Trans. Amer. Philos. Soc. 3:174.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('baf683fa-9c76-536a-9c16-e4f193b40d8c','','','Rep. Gov. Bot. Bot. Director Bot. Zool. Gard. 1962-1963:12.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('126c6a22-58dc-5245-920d-7c40139716ee','','','Sp. pl. ed. 2, 2:1082.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1aa9636-ff92-54af-9d3c-8e962ad0dde6','','','Fl. N. Amer. 1:642.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4929c76-2d05-5cb8-870a-1322066a39a7','','','A. Grandidier, Hist. phys. Madagascar 35(tome 5, Atlas 3): t. 170A.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcfa1a62-2ee7-58f7-bebb-9d045fe4a3df','','','Blumea 21:53-55.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e704c3cc-49e3-5465-ba3b-8dff0bd8c1cb','','','Stand. cycl. hort. 4:1932.  1916 "<I>Lycopersicum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4eba804-c120-5fd8-b672-1bbb47c26c1c','','','J. Arnold Arbor. 16:33.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78326859-b1b7-51b3-8d3e-6ceabcda04a7','','','Fl. reipubl. popularis sin. 49(2):267, 323.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb987f18-d184-5f0f-8436-f27ac7d03ae8','','','Novon 6:390.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fca92f3-d24a-5a46-8484-320300427540','','','Jahrb. Königl. Bot. Gart. Berlin 5:166.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcff858c-a8de-5527-b4ab-e9ea3b3f944f','','','Fragm. 2:120.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8731a416-e392-51ab-8b01-865dd9cbc289','','','Notizbl. Bot. Gart. Berlin-Dahlem 8:275.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efd9c637-730d-59f2-acd1-e04124000174','','','J. Jap. Bot. 14:443.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6275d6c3-9ffc-5971-98de-2aee7df03646','','','Bull. Int. Acad. Sci. Cracovie, Cl. Sci. Math. 1904:303.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ef09b0c-b5e5-5635-bf04-9e1d70cc29ae','','','Trans. Linn. Soc. London 27:69, t. 23.  1870 ("1869")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b792708c-9b3d-57c4-9917-df456ae163b3','','','Bull. Torrey Bot. Club 27:253.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a02e4442-ca92-5d70-94d4-d67384299ebb','','','Bull. Misc. Inform. Kew 1935:235.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17f82f7e-3f18-5677-9c1e-42c54dfb447d','','','J. G. C. Lehmann, Pl. Preiss. 1:23.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0e1346c-dc80-580a-92d4-98dbcf86da79','','','Fl. Bras. merid. 1:124.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e911194e-fba2-5aa9-bdff-25beddc674a1','','','J. Linn. Soc., Bot. 29:50.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4b60da7-d9d2-51f0-836c-c3c7d1587c4d','','','Svensk Bot. Tidskr. 24:133.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2d931ac-e2e8-5f1d-b9ab-6e5b6f4a856b','','','Ann. Mus. Bot. Lugduno-Batavi 2:185.  1866, pro syn.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5428725b-87ea-5700-bd26-21440960dd2d','','','Repert. Pl. Succ. 22:10.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0645fcb-c1cd-5b9e-9fda-ffaa9b909980','','','Bull. Acad. Roy. Sci. Bruxelles 11(2):188.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19e0053c-9e34-5d66-b80c-7976188047a8','','','Occas. Pap. Bernice Pauahi Bishop Mus. 20:82.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d50f62d7-ee06-5ff3-8424-ccadfc4cefc1','','','Catal. bot. 1:18.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bdc5e1f-78e1-5a5c-92f9-3e01eb10ee1f','','','Fl. Franç. 2: 623.  1779','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('742b3c06-09b6-5fcc-80de-1b578f586208','','','Webbia 9:490.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e82720b4-b141-547f-aefd-a8749a4ee75f','','','J. D. Hooker, Fl. Brit. India 2:99.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35a49e08-8d18-53c0-b17f-060bca49551a','','','Nov. gen. sp. pl. 3:77.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a0b1c82-0b30-5f08-891e-13ec5a349c81','','','Gard. Chron. 1873:777.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72b7549b-28a3-5d32-b210-9b5bf5d97181','','','Gartenflora 47:131, fig. 38.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9198c5cb-c4da-5db8-97a9-5a76977fc25e','','','Prodr. 7(2):601.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1aeaaee-f880-5431-bdc0-6bbd12ceba77','','','J. Bot. 45(suppl.):84.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab264d56-c2aa-5dd3-8300-2f5a22008dab','','','Fl. E. Himalaya 1:69.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('429f6a0a-6f5b-59e4-babb-051df25e330d','','','Syn. mitteleur. Fl. 6(2):626.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5437d14a-4395-5806-9bde-1bd769f38f0e','','','Bull. Jard. Bot. Natl. Belg. 56:487.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67253316-0b1f-50d6-b564-d1e9e0901940','','','Holm. Decad. Pl. Bras. 3:30.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff1e5143-c5e2-5c4a-beb5-991f5e73c75f','','','Syn. pl. glumac. 1:285.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d7eefbc-54ef-533e-946b-6fbde402bb0c','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:203.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9267928-a977-5eb5-b861-a69b2c0a63de','','','Fl. ind. 2:49.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a732d7b-de6d-54ce-8c3f-e00c29d9bbbb','','','Nov. gen. pl. 10:147.  1800 Jun; Prodr. pl. cap. 123.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3b4fc17-6306-5848-9c07-0a368d7976f2','','','Sp. pl. 2:1052.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('970a6bcc-7f6d-5914-a3db-524b266ddbf9','','','Bot. mat. med. 2:164.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f907a4d-df61-54d6-9756-111a6c46ecb1','','','Sp. pl. 1:524.  1753, pro sp.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80d19ba2-6c1f-5543-9981-c45515563b89','','','D. Prain, Fl. trop. Afr. 9:487.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e19df607-d8f0-53d2-a72b-833efe515ce3','','','Trans. Linn. Soc. 1:77, t. 2, fig. 2.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8b8f310-3d27-5268-8dbd-c65a3b18b7bf','','','Fl. Rocky Mts. 364, 1062.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f36b618-88b8-565e-a28a-78f79c2aff21','','','Acta Bot. Yunnan. 14:128.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ce90f27-97a8-57ab-9d65-9ecfce101fb7','','','S. Elliott, Sketch bot. S. Carolina 1:455.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46646dd2-ab4d-5bec-bf12-7efa848a38a7','','','Iconograph of Japanese Citrus fruits (Nippon Kankitsu Zufu)1:199.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a4ce3c2-f270-533d-80ba-b925d4fe1438','','','Cat. arbres, arbustes 35.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af6915af-0b93-556a-8203-aec093eefd1e','','','C. S. Sargent, Pl. wilson. 1:453.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0edba86-d428-55df-9788-b9c267608eee','','','Syn. fil. 182.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83e56bb2-8ae7-55d9-b8ff-fdae89e96a10','','','S. Watson, Proc. Amer. Acad. Arts 22:428.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d707ed0c-9b0e-52cb-b7bf-dde89b0a02e2','','','Phytologia 57:8.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bd84ed9-4de3-56f6-b732-cf0161799459','','','Bull. Jard. Bot. Natl. Belg. 60:301.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e39fb6f-f03c-53a0-8eb1-59fdd03cd021','','','Sp. pl. 1:446.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8365f8e-ab33-5fcd-921e-19086442690a','','','Hortus kew. ed. 2, 4:121.  1812 "<I>Mathiola</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99a28a86-1caf-5fab-9c4f-a8a0717fce3e','','','Linnaea 22:254.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23cf0c7c-5874-5e99-8efa-7e62d9c33bc3','','','Bot. Mag. 70: t. 4131.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('283983cd-7903-5d2b-ad2b-ec758c3c6c55','','','Fl. gén. env. Paris 2:898.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c9685a1-5ba5-56e1-bdce-6d4a1f671b96','','','Darwiniana 11:116.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4360ba7-38a3-55bb-83ac-b1134e381756','','','Fl. Ned. Ind. 1(1):694.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96e63ba0-8b34-5475-ad29-6ee1a79c8c94','','','Gard. dict. ed. 8: <I>Malpighia</I> no. 9.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ed077e0-a21f-5907-a9cb-06cc726027d6','','','Hort. berol. 2:281.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb4ab86b-1e08-54ea-a1b6-f9a59b2dcbd2','','','L. H. Bailey, Stand. cycl. hort. 5:2841.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b688e59-976e-5ccc-9ab4-c4433d7e279b','','','New keys Jap. trees 470.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6e89cea-84c9-5dfb-8745-abbc8e4a9865','','','J. Bot. (Hooker) 4:400.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57f9c6d1-8967-5d31-96d9-3a3a9f862fd5','','','Bull. Soc. Bot. France 61:131.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bffc5fa-66f7-5845-9189-bb86002ca539','','','Sp. pl. 2:655.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97a232eb-cf20-54b8-ae04-23dae89d660d','','','J. Coll. Sci. Imp. Univ. Tokyo 26:276.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ddb60e5-2aea-5e0c-8f26-2069e605ebcb','','','Anales Hist. Nat. 2:118.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28ced513-67e7-5b3d-b336-5a69b8896b67','','','Sp. pl. 1:265.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12600b5c-aa93-5ac4-a426-5ee92ee7e052','','','Nov. gen. sp. pl. 2:146.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ef0c7b7-297f-5bce-b475-741c9e8116fd','','','J. Chosen Nat. Hist. Soc. 2:91.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c734aef-1d8d-51be-8f5a-b7a0cc9fbd8b','','','Proc. Biol. Soc. Washington 35:175.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1bf0aba-36c4-597d-b093-49e26c6c8dbe','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 31:16; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 12:420.  1886 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8ffb85f-da9f-5b98-820a-e189ac17b4dd','','','Philipp. J. Sci. 26:47.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91622cc0-20ac-57e6-9714-8574c30a5dde','','','Bull. Jard. Bot. Buitenzorg sér. 3, 7:167.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e46622d2-3409-53cc-a39a-533215ab1f93','','','Prodr. 6:120.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03e900f2-5e27-546b-8687-54205adbaaa5','','','Ann. Jard. Bot. Buitenzorg 6:232.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a01a0c9-a83f-5b7b-874b-45f89eaf4fcf','','','Cat. pl. horti monsp. 127.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4558270d-e97c-5087-af3c-e9eda3d286ac','','','Compan. Bot. Mag. 1:240.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18fdcc43-2e9f-5a6a-b93c-0d9609f5dd46','','','J. S. African Bot. 33:295.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4ee296c-797e-5674-9321-12da937644b5','','','J. Malayan Branch Roy. Asiat. Soc. 5:269.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7c5b688-c0ef-5416-8835-e7bdabc75ad4','','','Bull. Misc. Inform. Kew 1910:363.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c16228b5-ae48-5b40-a58b-d0efca60ab39','','','Nov. pl. sp. 238.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acdbb1b3-4700-5d4d-89d1-d0174b3a1f3b','','','Fl. austral. 2:170.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e6f58a9-12b2-56c9-bde4-1cfa9801ec68','','','Beih. Bot. Centralbl., Abt. 2, 34(2):248.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('882ea18e-1285-587a-a12a-90add067bf34','','','Symb. bot. 3:44.  1794 "<I>tomentosa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('358797be-683f-59ad-b6e4-e917a4b5e478','','','Spec. bot. Geran. 28, t. 1, fig. 26.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c77a468-cf6f-5c6b-8252-cb3bda27b208','','','Linnaea 6:141.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97c580f4-c6a7-5e27-89ef-637e95207ff0','','','Fl. caucasi 47.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c47d8497-594e-54c0-a877-4c2c31f27580','','','Nordic J. Bot. 2:193.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab9e2e89-ea61-51c4-8c6c-a1090cf505eb','','','Labiat. gen. spec. 88.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cf57f2d-da29-5ac3-be66-d5e786b36d55','','','Mém. Mus. Hist. Nat. 13:75.  1825 "<I>cupressina</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0021e4d2-8b2b-5052-bb3b-a5bd36066a1b','','','Edwards''s Bot. Reg. 28: misc. 22.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('387cd22f-0958-5d28-b45f-65dda39263a7','','','A. L. P. P. de Candolle, Prodr. 13(2):421.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d836e77e-2762-5aee-bbdb-aeb97469ff1e','','','Bull. Soc. Natl. Acclim. France sér. 3, 8:442.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afd1862f-2cc3-5714-90bf-5771a3132c62','','','Suppl. pl. 88.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4732f5ca-196e-5b94-990e-f93fb62e5912','','','A. Rees, Cycl. 31: <I>Sclerocarpus</I> no. 3.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8afb7329-c5e6-57e5-9d94-e224ed130f3f','','','Mem. New York Bot. Gard. 35:156.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('052f1cf2-7ca9-5222-8aad-93913a3c4339','','','Prodr. 4:437.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92ca2c50-9d8b-57e8-a9c7-64c035d7ad77','','','Woody fl. Taiwan 700.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4af0cd3b-db3d-5369-82c2-204651dc9457','','','Trudy Prikl. Bot. 16(2):77.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d33e3d2-3e5d-565a-832f-7b307fec6b73','','','Voy. Barbarie 2:142.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('941ab131-8e53-57ff-a71f-a497ce51db26','','','Verz. Art. Aloe (French ed.) 29, 62.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f4d0661-c2cc-5584-ae6b-486fbf5e54cc','','','Trans. Amer. Philos. Soc. ser. 2, 7:330.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b97caf2f-ff50-5535-8232-3a88992776ce','','','Fl. Brit. W. I. 474.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f9b87aa-06cf-5fc1-a4a6-de0b439ce230','','','Gen. Cass. syn. 66.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('972662ca-e0d3-5f6d-b796-91d4c3495059','','','Mem. New York Bot. Gard. 27:519.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cf8bd49-f24b-5b36-99e9-7bb0f66c0d53','','','Bull. Jard. Bot. Buitenzorg sér. 3, 7:168.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d03030d-6721-525f-9292-1d45f9e81573','','','Fl. Cab. 2:131, t. 77.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3865aa11-4e5b-54a4-9c4b-5128419efb15','','','Fl. bor.-amer. 2:75.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3fb2abd-f5ae-56ad-80e4-1968f44b6c50','','','Proc. Amer. Acad. Arts 12:271.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39dfdcd5-0fdd-5362-b374-8d2d27d5baac','','','Kew Bull. 40:811.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e5f97bf-1168-5f8b-a550-fb947bd2a9da','','','Gard. dict. ed. 8: <I>Phlomis</I> no. 9.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e510fec-e9b7-5817-9984-ccafc2495484','','','Fl. jap. 920.  1965, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c20e8441-6378-5555-9f09-7cff49f82671','','','Trans. San Diego Soc. Nat. Hist. 15(4):40.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57e4cb2b-e61b-5d96-9436-b3bc20c7831b','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 26:386.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36ded396-05e3-591a-a89f-7b6602c53b90','','','Bonplandia 8:42.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d71438a7-6de3-5fae-ad1b-50afc832721c','','','Bull. Torrey Bot. Club 29:468.  1902, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7687cde3-d0a9-5d40-ba16-9475196116fc','','','J. Jap. Bot. 62:368, fig. 2F.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c0786c1-f064-5362-a4a1-f9a8248ff955','','','Rev. Hort. (Paris) 85:527.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92ce4fb4-cda9-59e4-87f6-4bbbfc892bfb','','','Kakteen And. Sukk. 24:99.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c8efbc1-57f3-5e7a-b477-3c03095c98fb','','','Cact. Succ. J. (Los Angeles) 58:124.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67ddbfd6-dedf-5850-9094-3349ee66907b','','','Gen. N. Amer. pl. 1:197.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f2b64af-3458-5dfc-8169-f521713ecc88','','','Gartenkalender 4:195.  1784 (Beitr. Naturk. 4:19.  1789)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb983f87-ec52-52c1-9f23-8d8e697977c1','','','J. Washington Acad. Sci. 25:35, 44.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3af4a508-95a9-5fb3-b0bd-d17b7e9f0771','','','Sitzungsber. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. München 8:401.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('564cd469-4d7c-533c-92a1-62bf42ca60a6','','','Fl. cochinch. 1:171.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6060107d-64e0-52dd-a94d-59a4e715d429','','','Rhodora 21:188.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cddcad0-f55b-50de-bffd-373689bc8939','','','Mem. Reale Accad. Sci. Torino ser. 2, 16:20.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6207b762-9999-5595-a603-df9b2802ecd8','','','J. Jap. Bot. 55:97.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1ecf707-fccc-5d1a-967b-05d5f6cede7e','','','Symb. sin. 7(5):1271.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('106620a2-f805-5d28-a329-cc5aeadebba5','','','Ark. Bot. ser. 2, 1(5):309.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c90a02e-5c64-5486-83f6-f574befc1fe5','','','Flora 26:458.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe701e60-a08e-5937-9709-c8f98bb84dbe','','','Z. Gesammte Brauw. 5:202.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e36a0ff5-f8cf-5466-9310-a2b616bd80f5','','','Flora 21:715.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('340302ad-03fe-5aa2-8c8e-903254af1298','','','Novon 28:146.  2020','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2a11bb1-1069-5811-9524-9dfa4a7b3d17','','','Bot. Reg. 3: t. 255.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9c129e1-ce57-5d7a-ae34-16a9c89136e4','','','Bull. Misc. Inform. Kew 1914:277.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59fd0262-1bb5-5e3d-b04e-7921ce4061f6','','','Gard. Chron. ser. 3, 37:49.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('882e2322-4d28-581f-a426-f99e33f531b9','','','Rev. Hort. Belge Etrangère 19:167, t. 35.  1893 "<I>Baptisti</I>" (Wiener Ill. Gart.-Zeitung 18:264.  1893)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e9e192d-4cb8-5b70-a35b-4a450418bbb1','','','Mém. Inst. Égypt. 4(2):232.  1901 "<I>aegyptiaca</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a095759-4f43-51de-8b97-1b8038cc1e55','','','Mem. Cornell Univ. Agric. Exp. Sta. 335:40.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20030179-f7e7-5104-8309-da2b19188fd2','','','Syst. veg. 3:224.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a5ca3da-d47a-53f1-84eb-49ef6bcb2f91','','','Handb. N. Zeal. fl. 1:49.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ffa50db-f97a-5e61-8455-397c063f1a60','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 22:433.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4ff94b7-3816-5146-811a-4a8c44efd54f','','','Encycl. 2:394.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d7aa9e3-0ceb-5399-ae56-863e628de136','','','Bull. Bot. Res., Harbin 4(3):191.  1984 Jul','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20d679f9-0016-53ea-b634-5e52894e0113','','','Acta Phytotax. Sin. 33:262.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b25974f8-85bf-57e2-9967-1fc18d8ffdc4','','','Ann. Bot. (Rome) 9:318.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be4839fa-d080-5cd4-bc2e-d0c89cdceb11','','','Kew Bull. 42:738.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cfc37ac-dc68-53c0-b564-c5d70206e545','','','Sp. pl. 1:240.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19a643d9-926d-56a3-ba04-516acc42cf92','','','Bot. Mag. (Tokyo) 11:443.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a759e467-bf27-5d89-952e-6f1f8cf4b2d5','','','Prim. fl. esseq. 198.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5364175-21c6-5b0b-bf60-a2708544a67a','','','Baileya 3:171.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd6bcfed-1938-57c1-ae91-d3ca819e8e74','','','S. African J. Bot. 112:428.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e48baf3-1f64-5ac9-bc25-57c51365214f','','','Bot. Mag. 66: t. 3773.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d74da53-841c-59c5-bd94-6713bc2774a1','','','Bull. Herb. Boissier sér. 2, 5:431.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('964fdd61-bdc6-59d3-920f-3437cbed1457','','','Taxon 46:18.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('753dbcd8-e808-5b2e-9497-8a02649b32a2','','','Bull. New York Bot. Gard. 4:342.  1907 (non Rydb. 1907)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c5a30b2-76e4-5dc4-acc4-6fd5516b2013','','','Monogr. Campan. 303.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc083693-1bf5-57b8-9407-4c8a3da81aaf','','','Fl. indica 176, t. 58, fig. 2.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9b40d81-1399-59bb-8384-e43067161b9f','','','Fl. peruv. 2:31, t. 159.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1665fad9-c895-50c9-968f-aa059dc6b8cc','','','Euphorb. gen. 109.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efcf1d36-0543-5e6c-baf7-26e183e3dedf','','','Ann. Mus. Bot. Lugduno-Batavi 3:150.  1867 Jul (Verslagen Meded. Afd. Natuurk. Kon. Akad. Wetensch. ser. 2, 2:87.  1868) "<I>sieboldi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba5a8708-a814-5243-a866-1ec5db8733b3','','','Jordanoff, Fl. reipubl. popularis bulgar. 6:94.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bba24cd-8b6d-504a-9378-5fd64aa8f66c','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 1:41.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34ff0b9c-4783-5581-ba13-a31b188589b7','','','Hist. nat. pl. 14:334.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d34d70d7-eda0-50a4-9926-16b8c4535c65','','','Acta Phytotax. Sin. 22:71.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a13582a-86b4-5ec1-8094-0f98db41443f','','','Trans. Linn. Soc. London, Bot. 1:264.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5b1a37c-957b-527e-a82d-375f5fa020d7','','','Sp. pl. 1:158.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ea616dd-9f24-5558-856a-d3f98f4e62c7','','','Pl. asiat. rar. 2:46.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93f6ce1b-95cd-532e-a28e-a63201502018','','','Monogr. Gatt. Ephedr. 100.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59fe1dc5-7f52-5d1a-8ba2-421af91cc6ac','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 3:25, t. 166.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd878ced-c517-582a-a2c0-f93d2651637d','','','Gard. Chron. 1869:529.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af68e068-bd05-5c69-88f6-e52d0e54b34e','','','Bot. Gaz. 28:409.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc879a88-2e97-589b-b54c-012c9daaf002','','','Bull. Herb. Boissier 5:791.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8cba8e5-b682-5fe1-8592-fd10ad934ea0','','','Bot. J. Linn. Soc. 67:281.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22fe5fe1-bc56-5ad2-9071-91c5660592d3','','','Novon 5:294.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75292e58-a21f-580b-b91f-3f60dc4b4771','','','Bull. Soc. Bot. France 4:16.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('945a820f-d244-51aa-bbb6-5d6aec39fcba','','','Enum. pl. 2:40.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9b88f08-7582-53da-9692-2039d1c2bd75','','','Gard. Chron. ser. 3, 34:325.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fae0dd91-2d99-58ff-bcc6-63727d901efe','','','Trans. & Proc. Victorian Inst. Advancem. Sci. 1854-1855:134.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69b05480-cfed-542f-9213-29d173ea6b76','','','Proc. Linn. Soc. New South Wales 24:448.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26c3540f-e6bf-52aa-8dad-da785f701007','','','N. L. Britton, Man. fl. n. states 407.  1901 (non Gand. 1884)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af970348-302a-5ca3-bf38-ffad6a623d22','','','Ann. Missouri Bot. Gard. 66:782.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2d79cb5-5d56-595d-b2d7-3ac94e98972d','','','Systematic pomology (Kwaju Bunruigaku) 139.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16c0e4a9-0310-5a5e-b290-c978c54c8cd7','','','Rep. (Annual) Missouri Bot. Gard. 19:260, t. 23.  1908, pro sp.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fc05ea4-aabc-54bf-b714-c0ebdc7e2175','','','Contr. New South Wales Natl. Herb. 3:93.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33fef663-0abb-5c83-a342-6362a1857237','','','Cact. 3:30, t. 3, fig. 2.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f41af3e5-eed6-5ee1-be5b-ab80b51afd12','','','Fl. Ned. Ind., Eerste bijv. 492, 192.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62494a03-00f3-5bf4-907a-3940b5720377','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 1:224, t. 13.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20bec390-88d7-56f5-b876-284db74b0e6f','','','Fl. iberica 3:353.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d61396ea-9be3-5b5b-817a-f51a458d6716','','','Bamboo gen. <I>Chimonobambusa</I> 42.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe90fb90-c7d9-5aae-a957-d0b88b1193be','','','Trans. Linn. Soc. London 1:253.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9128c4c6-3d84-5dbf-a328-709ec3606267','','','Orchideen 602.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f535b1ef-2695-5126-9c4b-f923d15ae806','','','Torreya 27:104.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c98b194-48d5-53a1-af72-bcdccc1507e4','','','Bijdr. 560.  1826 "<I>Litsaea</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38cdf0de-eba0-5676-935f-96301e0a4f11','','','Fl. ind. ed. 1832, 2:193.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('079c1dc5-e8be-5bf3-be55-c5cf1414583f','','','J. Bot. 34:36.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27817061-1e60-510f-b83c-a9c6b90a509f','','','Deutsch. Fl. 94.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('651586d8-6394-51ff-a7e3-76a47fc2aec1','','','Madroño 37:55.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c507a0c-6061-5a0d-abbc-ccbf6c032722','','','Linnaea 21:456.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cf6865b-56ef-5b75-a9dd-eb5b68081424','','','Amer. centr. 16, t. 10.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70dfc315-b986-54e3-94ef-132fa3e58f3c','','','J. Bot. (Hooker) 2:92.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7cca9533-4c13-518b-901d-b971bf6b9a07','','','Syst. Bot. 29:908.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21a88200-7efa-55a0-b54a-40ceee158f55','','','Linnaea 43:323.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b5ec40f-d89f-57af-911d-b59a01a7e51f','','','J. Coll. Sci. Imp. Univ. Tokyo 30:65.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef8bc93f-fbb8-550c-b84a-7e89ed1d2b8a','','','Gen. N. Amer. pl. 2:200.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bcc1a78-27fb-56f5-8d68-3b2bc13045b4','','','Linnaea 6:522.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edcae139-20ec-5519-a486-ce76d1b5a547','','','Fl. Amer. sept. 1:200.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc3d9f90-4afd-5a75-9b29-e2820069a521','','','Novon 19:201.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5ab80fd-9836-5408-8958-753dff57fe36','','','Fl. boem. 2:29.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1c771ba-a6db-53ac-8a3c-f07be87f5162','','','Trudy Prikl. Bot. 53:163.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b915976-b822-5b8d-85cd-0c57b5c4d355','','','Mem. Torrey Bot. Club 5:143.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46d2c42b-f152-563e-b2ef-c2de2b600748','','','Bull. Soc. Imp. Naturalistes Moscou 4(1):260.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7a0671f-2e7e-50fc-af0c-f6a27a15de33','','','Bih. Kongl. Svenska Vetensk.-Akad. Handl. 24(3,7):17, t. 2.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6462a91f-ee8c-518d-aa42-f3a8624fb7d3','','','Fragm. 8:65.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21d34706-95b5-5ddd-a769-fbf22485d875','','','S. L. Endlicher et al., Enum. pl. 65.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('833795b5-a67f-5f47-b6ab-c6a9e523cec9','','','Diagn. pl. orient. ser. 2, 6:64.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9bb13f4-a48f-55a1-9478-7f35cc9f79f1','','','Enum. hort. berol. alt. 2:62.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d9deb29-d786-5c6c-b9d4-edb755ee6e74','','','Bull. Torrey Bot. Club 43:457.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d40f38fe-d691-5431-86fa-4c8b7f99ed80','','','Proc. Biol. Soc. Washington 27:61.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9032014e-66d9-5aa6-bd7e-83c8053e823b','','','N. Amer. fl. 24:11.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c89515d-8ff7-5282-b54f-06bbaccc80ff','','','Pl. hort. schoenbr. 1:32.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58e7758f-e6e9-5682-89fb-6faff7eb2c16','','','A. P. de Candolle, Prodr. 1:268.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a09e86b8-0715-51ec-9dda-2358be55a5ad','','','Bot. Mag. 72: t. 4271.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42547dba-b8aa-5800-bc32-6b1b27307d61','','','J. L. M. Poiret, Encycl. suppl. 3:756.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('666227c7-6777-500d-a95f-2a82e0454580','','','J. Bot. 23:102.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('381478fa-3a3a-509e-9c7c-82dd89cface1','','','Mus. bot. 1:25.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07c60d7a-ecf5-5ea8-8b97-abae881d8590','','','Proc. Amer. Acad. Arts 20:295.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6bfbca9-0319-5fca-91e4-b9ef6a9c2ec2','','','Repert. Spec. Nov. Regni Veg. 11:208.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0558cd8d-64c4-51e2-8463-713b176c7885','','','Kew Bull. 33:641.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aafdc752-52fd-5f39-b7f8-62345dae4830','','','Leafl. W. Bot. 1:136.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16044f96-aa16-5ba1-b6d4-fec9d840737b','','','Revis. gen. pl. 3(3):49.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d62adef9-1e73-50c4-b165-9284268b44ee','','','Sp. pl. 1:80.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38ee3bc0-c259-5124-9cd4-74ff9b807fac','','','Bull. Bur. Pl. Industr. U.S.D.A. 248:61.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f2b696a-42ed-5bd5-893c-db54f3e531fe','','','Contr. U.S. Natl. Herb. 16:126.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8792166e-3950-532f-9241-fc1ae2c55ffa','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:30[folio]; 2:37[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2e444d2-7702-5856-81cb-47c0d6859f89','','','A. Grandidier, Hist. phys. Madagascar 30(tome 1):134.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec4e14ec-bd36-5677-b7bd-f92d13e22477','','','Meded. Rijks-Herb. 23:6.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d91c6bdc-3e37-53ba-ac69-7ded923100cb','','','Preslia 69:364.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('366aa562-5641-5701-acb5-08a452a1fb91','','','Vilm. Blumengärtn. ed. 3, 1:775.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05bf1287-0dee-5013-b3a7-153aa7afe5fe','','','Rhodora 52:154.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d079833-c4d5-588f-ae9a-911bf8103e49','','','Fl. Brit. W. I. 238.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9627b9e2-e964-5d62-9cf9-3b42e4b3a1a6','','','Methodus 342.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90ad1e03-e193-5c43-b0ae-1bf6bef1e34f','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(2):141.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5831296-7c16-5f3d-8064-f06cb30c54b2','','','Fl. bulg. Suppl. 1:111.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69d38a75-1b2c-56e6-9575-42449b341866','','','Rhodora 60:256.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a781a021-6f11-5cc4-a3d4-557c1d0bb6a8','','','J. Jap. Bot. 37:235.  1962 "<I>purpureo-suffusus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffb9e0a4-d991-5384-8ea0-82038f526073','','','Bot. Mag. 152: t. 9133.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09216565-5182-5ce6-b1e0-2bf913e742ea','','','Bot. Mag. 36: t. 1483.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d461ce12-0e10-54af-bc06-4cebde4d59d4','','','Muhlenbergia 4(5):68.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b984757d-36bf-56f4-a6bc-7f06f8abdc4d','','','Kew Bull. 11:132.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86e85599-4b1a-5d22-ae1a-f77dc0e6cd71','','','J. Adelaide Bot. Gard. 1:230.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01dcfbd4-d227-579e-9e26-e846fe9c7c99','','','Elench. pl. [24]; Gen. sp. pl. [24].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f44c5b1f-74a4-5f62-908b-6966c8afa0f8','','','Proc. Amer. Acad. Arts 8:534, 541.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57d32244-de18-5951-98f4-6c7784e71d30','','','Bull. Herb. Boissier sér. 2, 4:1058.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2341448d-544b-572a-9bd4-e5befea8bf29','','','Bull. Soc. Bot. France 52(Mém. 4):43.  1906 ("1905")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8529676b-85ba-5234-9133-036ed3882b24','','','Mem. New York Bot. Gard. 35:888.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a7b2b0d-d730-5fa3-9907-749d90c492cf','','','Gard. & Forest 2:471.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0852a7fe-b1a7-5b71-b794-bfd5e206a42f','','','Sp. pl. 4(2):1056.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13221d0c-b161-5113-961f-1cb2f93e3d2a','','','A. Rees, Cycl. 25: <I>Nuphar</I> no. 5.  1813 "<I>longifolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('088a8277-cb90-51d9-9146-f868965e8dad','','','J. Arnold Arbor. 60:102.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02a945d3-19f5-55b9-be86-e66a7edee9bc','','','Rev. Hort. (Paris) 62:164.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb9dcb54-ee67-5cae-8905-1c9da66236f8','','','Bot. Mus. Leafl. 6:98.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b43a898e-a74f-5875-8675-68c1899b55ff','','','Lindleyana 11:229.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bb282fd-6548-58c9-920d-9c6a8ab9b6b9','','','Uchen. Zap. Khar''kovsk. Gosud. Univ. Gor''kogo 22:205.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b110253-387e-56da-9c51-ba2c4dc48e0a','','','Fl. taur.-caucas. 2:199.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6f37c79-ecf8-5f34-aa2d-04aece234e62','','','Acta Phytotax. Geobot. 3:26.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('311b73e5-f175-52ca-a957-5d57eca38af0','','','Ann. Missouri Bot. Gard. 37:401.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d498796-d215-58bc-8f98-e8c5dcaf6d44','','','Notizbl. Bot. Gart. Berlin-Dahlem 15:42.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fa0e865-f654-57c5-83ce-76c880efabd7','','','Edwards''s Bot. Reg. 30:71, misc. 65.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cc5c60d-8e91-5b91-ae77-919875926503','','','J. Torrey in W. H. Emory, Rep. U.S. Mex. bound. 2(1):89.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5915b4a8-a600-5680-8247-885dfaf0cc9f','','','Nord. Kärlväxtfl. 1:369.  1953 "<I>litorea</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9eb84d77-f31c-5f15-8175-359af1fc53fa','','','Ann. K. K. Naturhist. Hofmus. 11:64.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aedb5641-154f-5649-815b-a8378add038c','','','Revista Fac. Agron. Univ. Nac. La Plata 3:510.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb3643c5-2c64-5f43-aa6e-8afb4af4edf9','','','Repert. bot. syst. 2:946.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d584672-b048-5306-822d-d4a6c23adf0b','','','F. E. L. Fischer et al., Index sem. hort. petrop. 4:37.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ceb03d6-cc08-5744-a211-aa2a4c28eb6a','','','Adansonia sér. 2, 19:21.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4dfd0f3-41b8-5ac5-8b9e-4f14ce668f91','','','Fl. bor.-amer. 1:333, t. 116.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22151447-e463-5044-a4b2-f502d03c8699','','','Kongl. Svenska Vetensk. Akad. Handl. ser. 3, 8(2):35.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b97352f0-ad54-5c8d-ac7a-574e2695d22f','','','Handb. N. Zeal. Fl. 736.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e060894-5885-5103-883c-65cd63cee5da','','','Acta Univ. Lund. Afd. 2. 33(12):64.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b381ef43-dfa0-5bbf-9f51-15830ba5cec4','','','Austrobaileya 2:351.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1bbe8be-0de6-587a-b009-0aef04c8ce8d','','','Sp. pl. 1:176.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('420abd00-caae-5fcf-b3c2-b858acdc6d48','','','Quart. J. Taiwan Mus. 12:41.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3b926d3-7d94-5fa9-be8f-7975c97c105f','','','Repert. Spec. Nov. Regni Veg. Beih. 1:748.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af837fdb-2795-5c46-9ef5-c364c53b09d8','','','Hist. nat. palm. 2:122, t. 88, fig. 1-2.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('058104aa-734e-5855-b0e6-8cd1d9cc872c','','','I. B. Balfour, Notes Roy. Bot. Gard. Edinburgh 9:274.  1916 "<I>sino-grande</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4cfb6ad-db4c-54e1-9a22-e8b0db619d5e','','','Bot. Abh. Beobacht. 45.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb459ef8-62e4-576a-bfe6-03e5aecf8b0d','','','Kew Bull. 24:259.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc1b5319-e008-501b-be77-1435c7dd456e','','','Curr. Sci. 44:622.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d672eb5-b424-5165-8abb-f40a37fb51e9','','','Neue Schriften Naturf. Ges. Halle 2:27.  1813 (Pl. umbell. prodr.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e720929-9309-596a-8d65-f2df84727ede','','','Abh. Königl. Ges. Wiss. Göttingen 24:18.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f802331b-fa9c-57b0-bd52-0d78e8e9778a','','','Tent. fl. abyss. 1:310.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('292ba529-e7f5-58b6-81b1-4b4122a55c7c','','','Pl. aequinoct. 2:18, t. 73.  1808 ("1809")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb3c4091-6469-57f8-b7e2-4efc947bcfe6','','','Nova Acta Acad. Sci. Imp. Petrop. Hist. Acad. 12:104.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('406039f6-bd3b-5df5-977b-10d9a4f33665','','','Bot. Zhurn. (Moscow & Leningrad) 82:113.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b48c3ad0-79b8-58da-be4f-2a7c038d6281','','','J. Soc. Trop. Agric. 2:33.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5143609a-a2ba-51d1-bd73-3456c9a0e0bd','','','Nomencl. bot. ed. 2, 2:600.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a47c28d2-aa15-5164-92eb-35812efcda64','','','New Zealand J. Agric. 23:146.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b144a823-ee0a-5ce0-a2fe-d1c3ee510502','','','Hort. dendrol. 284, t. 75.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccace3cd-d958-59fc-8383-e607076baa17','','','Linnaea 20:653.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('594e2586-cba5-5a91-89fa-27cabc441e87','','','Gard. dict. ed. 8: <I>Ribes</I> no. 4.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02bf6bbf-2ccd-5d55-8066-786597777ae8','','','Rhodora 80:78.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eff39c02-d7f4-599d-a557-891292739d7d','','','Syst. veg. 2:356.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d92753ca-c4c2-5691-9673-dab2461d3f0e','','','Philipp. J. Sci. 4:601.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2fbff9cd-cbf7-516a-8882-67d166c230f9','','','Novon 15:294.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fe85144-569f-5ba8-bf8a-677b48e76fbe','','','Ann. Mus. Bot. Lugduno-Batavi 2:138.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6af1bded-268c-5506-9a01-8d0ea329914c','','','Nuytsia 8:386.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33d0bbed-f84a-5782-86fe-632c4677fbf2','','','Suppl. Fl. N. O. Celebes 3:9.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fb8d926-aa2e-5ea9-bbd0-178c3316e817','','','Alpine fl. New Guinea 2:1185.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb60922f-bd66-54e8-a977-5dc139fcebe9','','','Die Hauptsachlichsten Formen der Saatgerste 6, 10, no. 51.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36c741e7-d900-56fa-a7a5-7b275aa437f9','','','U.S. Expl. Exped., Phan. 1:312, t. 29, fig. D.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('914c623a-7957-5b7b-a556-81b39ebcb61d','','','Succulenta (Netherlands) 55:82.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10621bcd-c5f5-5426-a015-f2b74a8d4c9e','','','Orchidées Côte D''Ivoire 214.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b13f7be-eea8-5be8-be89-cf8ca6e85453','','','Mem. New York Bot. Gard. 35:157.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f2df032-3e66-5213-8a82-40d8c5b3c5f2','','','A. L. P. P. de Candolle, Prodr. 9:380.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ca22aad-9042-581f-a1ff-c3d926584183','','','C. F. P. von Martius, Fl. bras. 12(1):377.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aa3ceb5-0ecc-5731-ae60-c484bad73d43','','','Hooker''s J. Bot. Kew Gard. Misc. 2:52.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d59c535f-9b4a-5614-b325-9d7d98a772b9','','','Proc. Amer. Acad. Arts 8:165.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e38073e-cd40-565d-8177-67834e7a05eb','','','Dansk Bot. Ark. 33(3):140.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5089292e-65fd-5988-9579-713edf808072','','','Kew handlist of trees & shrubs ed. 4:315.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34e3f02e-0fea-5c75-8a2b-c12cc4155832','','','Beih. Bot. Centralbl., Abt. 2, 26:334.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffed723c-70af-572d-b5d9-5f03f7d035b3','','','Bot. Not. 126:494.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfc30444-5fdd-51c8-86c3-563819233e94','','','Bot. Mag. 37: t. 1508.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29ba8187-1fac-5c6c-b298-1ea4d2e0dd61','','','Bot. Mag. 61: t. 3304.  1834 "<I>purpureo-rosea</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d5b8b52-fb1a-58d8-8b0e-2342ec915a8c','','','Oesterr. Bot. Z. 25:11.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0af7005-a1fa-5fb2-bb83-40723f2fbdfe','','','J. Bot. (Morot) 13:202.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('200c04f8-c3c0-517c-8525-f915b1dd3745','','','G. H. K. Thwaites & J. D. Hooker, Enum. pl. zeyl. 33.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9702075a-e917-596c-9d23-1d20aaa48cc8','','','Mant. 1:65.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e80286e-398d-5ffe-a362-4a0b90836401','','','Fl. Brit. India 6:293.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba085d9c-9c39-5005-acab-702e7091b82d','','','S. Watson et al., Bot. California 2:240.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15b81c7e-88d8-5b26-9c32-8e8ea2b890db','','','J. Indian Bot. Soc. 42:649.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5121d19-4d81-5701-88ea-c268b4c7c282','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:180.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5756f929-3016-5c0d-bf8b-7f60de1eeaab','','','Rheedea 1:72.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9a73095-f916-5d67-8cfc-725f2efa4fc5','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Hist. Acad. 3:295.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c719c281-459c-5b20-987f-f594efcf9391','','','A. L. P. P. de Candolle, Prodr. 8:585.  1844 "<I>caeruleum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d46467e-4c72-58b2-baa9-16779ef273db','','','Hist. nat. Iles Canaries 3(2,2):43.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01cb6c45-0099-5ac1-b2ed-d76036e540a1','','','Prodr. 10:594.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f95c8a35-0bc6-5f56-b19c-67f3bb9a0097','','','Pl. asiat. rar. 3:116.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d71bd6b4-7e20-51b3-91a5-e24baa22dbef','','','Ann. Mus. Congo Belge, Bot. sér. 5, 1:139.  1904 (Études fl. Bas- Moyen-Congo)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0af012be-4854-5f69-8ba4-6902337476a4','','','Repert. Spec. Nov. Regni Veg. 44:237.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a50cd2fb-ca92-5b51-b69c-579f55dffd66','','','Trans. & Proc. New Zealand Inst. 21:97.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1072eaaf-d046-5b1f-9f2e-d4851db1a8c4','','','Mus. bot. 1:212.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5074cdb1-306a-5924-9793-f9c709cd7d96','','','Ann. Nat. Hist. 3:112.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96f252e8-e44f-5d16-89d5-fb4324b84fba','','','Syst. veg. 1:303.  1824 ("1825")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11ec8524-e0d7-50c6-80ec-f49493da1b67','','','Contr. Gray Herb. 95:7.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abaf1292-1030-5e1d-b295-73665d2a0b95','','','Prodr. 4:427.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('634ece38-a98d-5051-ada3-63c6b5dc3dda','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 2:284.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cdc55bb-5435-5f22-ac47-882132c0c205','','','N. J. B. G. Guibourt & G. Planchon, Hist. nat. drogues simples ed. 6, 3:646.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6dfd6491-0c2d-5511-ac1b-1c1d7cd33b92','','','Gard. Bull. Singapore 15:349.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e8bb9d9-10ff-5f20-8245-79ced6b952b4','','','Fl. germ. 1:289.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64eebf94-3295-5f78-9c54-06776ce482c5','','','Baileya 18:15.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8dbab45-18bf-5389-a1fc-f2c3a4aa864a','','','Izv. Imp. Obshch. Lyubit. Estestv. Moskovsk. Univ. 26(2):247.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29a90388-9290-5e15-ae02-dee999159b17','','','Mém. Inst. Sci. Madagascar, Sér. B, Biol. Vég. 5:182.  1955 ("1954")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('751461e2-6e22-5ad9-a4d8-58c88d35847e','','','Fl. reipubl. popularis sin. 74:234.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0761eca2-0b18-52e2-a3e2-8c71bc6e7d4c','','','Bull. Misc. Inform. Kew 1907:316.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25d45888-8789-5952-8108-90f0ad855cb3','','','Contr. U.S. Natl. Herb. 1:100.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a8974b7-3366-5d9f-b2c3-e68ea349a109','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 15(1):216.  1869 (Gen. Astragali)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c80e6b59-4b23-59a3-ac85-c46dde046530','','','J. Indian Bot. Soc. 16:237.  1937 "<I>lycopersicaeformis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07eaa9cd-6aaa-547c-87ef-93e2dcf56fbb','','','Mém. foug. 3:28.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48397566-05eb-531f-b1ca-9deb8c643cf4','','','I. Urban, Symb. antill. 1:262.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acbcd9ff-0b2d-5a65-80b8-1168ebdf3c84','','','Notes Roy. Bot. Gard. Edinburgh 45:246.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('858e8665-e584-5ebe-816d-f047d303ecaa','','','Bot. Jahrb. Syst. 37:506.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41bf502d-fd7c-55bb-b1c4-436dfba58f47','','','J. Jap. Bot. 63:60.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10c1015a-9418-533d-a416-c20a5606aeba','','','Linnaea 12:315.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a35716e-bfb7-5236-a789-94fde1c082cc','','','Acta Phytotax. Sin. 18:184.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a46d7dd-e06a-52da-a46b-d608e31edcd2','','','Trudy Bot. Muz. Imp. Akad. Nauk 11:53.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ac45b98-2fdf-5fab-80d3-96604bf6a833','','','J. D. Hooker, Fl. Brit. India 3:481.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cd3ebef-ece9-5f4b-9e63-074ad94425d6','','','Handb. Irid. 32.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93bb9ceb-e969-5839-9830-de113b30397f','','','Ceiba 3:38.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('530e21f1-5494-5c41-85de-7ebe04045257','','','A. E. Pease, Edmund Loder, naturalist, horticulturalist, traveller and sportsman 305.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('070e8467-b594-54b7-9756-cd639b413911','','','Austral. Syst. Bot. 13:135.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2baf26f-ee12-54d5-af76-126f37b8b451','','','Vieraea 17:358.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3d2130e-921f-527a-838f-461ba5d511c3','','','J. J. Bennett & R. Brown, Pl. jav. rar. 192.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb96a3ba-5966-57d4-a253-c0e78fe1bb52','','','Trans. Linn. Soc. London 14:124.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('765fa676-a06c-5bf1-a826-22155e4e2674','','','Acta Phytotax. Geobot. 49:15.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee95b533-f512-53c4-9ec5-edfc05078fab','','','I. B. Balfour, Notes Roy. Bot. Gard. Edinburgh 9:256.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7bd0cd7-27cb-5ea9-bc56-285b1e03ad33','','','Mant. pl. 2:226.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46f260d3-cb60-504a-a38a-674753de03e5','','','Fl. orient. 5:674.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('514e476e-cffd-58b9-8d49-5753fc73f59c','','','Bot. Gaz. 65:448.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7ec2588-20c0-5970-9aa0-c24931243f37','','','Trans. Nat. Hist. Soc. Taiwan 22:431.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce5a7504-dbb2-531d-bbea-e1b5623534c6','','','N. L. Britton & E. P. Killip, Ann. New York Acad. Sci. 35:185.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77827d0e-3f8b-5465-add4-dd0c192f37c7','','','J. Adelaide Bot. Gard. 17:181.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dab077cd-d977-5d20-9250-39c628d5706c','','','Mem. Fac. Sc. & Agric. Taihoku Imp. Univ. 2:304.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10439fc8-15be-50d3-862c-4786d4cb7bb5','','','Trav. S. Africa 1:219.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d723769-8431-5423-9a84-76fd6e40f982','','','Bull. Torrey Bot. Club 37:475.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5010248e-8a3c-5bee-bc9a-df0b11f135d0','','','Acta Soc. Sci. Fenn. 10:130, t.5.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49334e24-7ea8-5626-9237-de0c464b8e49','','','Sovetsk. Bot. 1:28.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53c29b46-4328-582c-a672-1b13b4b7980f','','','Gen. fil. 145.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa78bf15-a086-5b6f-88f8-48025b16dd49','','','Sp. pl. 1:259.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90649fdc-04f0-513c-b1eb-000f2ba5d0a9','','','Gard. Chron. ser. 2, 16:748, fig. 148.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('baf8e96b-634c-5372-b341-b4a5058d2c9d','','','Encycl. 6:245.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffc1abcc-5bb0-5c2d-847f-9245c67bd5f5','','','Rev. Hort. (Paris) 75:473, fig. 194.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05209746-2515-5ea1-bcd9-898ee2256214','','','Rumphia 3:178.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('937d9166-9440-5632-85fa-05ffa9e7572d','','','Fl. Brit. India 5:137.  1886 "<I>clarkeana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('707c0b4c-3541-50a6-b966-42edcd8aeae1','','','Austral. Syst Bot. 13:34.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d5eaaf6-aa2d-55d5-b0e7-f2baaf2883c9','','','Pittonia 3:45.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c1a8fae-8008-58e6-8dab-44f622006f64','','','Bol. Mus. Paraense Hist. Nat. 4:543.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9c206e4-7495-5e99-9f9c-709e2a73eb80','','','P. J. Redouté, Roses 1:43.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b366c1e9-9db8-5bd2-91be-c447bd0fe60f','','','Hort. kew. 1:286.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4ab7fa2-1298-50f0-96c1-090ff802a45f','','','Mém. Soc. Phys. Genève 1:457.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1af6ec0-40ac-5b60-ba47-5b80c1a462f6','','','Pacific Sci. 25:65.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('225fa140-9847-540c-86f0-0a7323907684','','','Fragm. 5:143.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffd025e0-ed20-57c1-bed7-cc87a6734c7d','','','Abh. K.K. Zool.-Bot. Ges. Wien 1(3):39.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38ebd397-04fc-504c-a249-dc50c2a0f993','','','Bot. Beechey Voy. 326.  1838 "<I>grossulariaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b49fa09-0783-558e-893d-b4d247b126a1','','','T. J. V. Stuckert, Anales Mus. Nac. Buenos Aires 21(ser. 3, 14):171.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c0764ad-a743-5162-85b2-a56d6df04cf6','','','N. J. Jacquin, Collectanea 2:79.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47bc887e-7f7a-5934-a675-7dff30d5a04f','','','Trans. & Proc. New Zealand Inst. 17:272.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae304396-4f0b-5487-9531-d7f97bcb13a6','','','Proc. Biol. Soc. Washington 30:52.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1da8f742-4df0-574d-bb6e-fc7900f9c8a2','','','Cat. pl. horti monsp. 122.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccf202e8-c6f1-5da1-a5e8-aebf12c18ce1','','','Flora 48:274.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc37b3b6-c917-5d50-9fb8-f58fdcec773e','','','Bull. New York Bot. Gard. 4:143.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3a8cefc-dba7-525e-84d8-e84ccf763a1d','','','Bol. Mus. Paraense Hist. Nat. 3:443.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc70b0c4-deea-5569-9024-ef4561f4a077','','','Arbor. frutic. brit. 4:2489.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92326cbc-d9b9-5638-a757-64ef6085ce5b','','','Repert. Spec. Nov. Regni Veg. 18:290.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('daffc6b9-42a4-53e7-b20e-e4b02f031fd1','','','Hort. bengal. 40.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92e88590-4d7f-52e3-ad41-fe6e1d9ad3e7','','','Linnaea 7:653.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4aedfd4f-d8e5-54f0-8a49-0f97be62d08a','','','Rev. Bot. Appl. Agric. Trop. 13:569.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9361247-5aa4-55d9-a6c4-c9c0cea85ce3','','','Fl. orient. 4:551.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('811e10ae-a483-5d82-9eb2-076ecf0f6846','','','Syn. pl. 1:291.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('925d0c28-770d-5c11-a256-51a2667c967f','','','Repert. Spec. Nov. Regni Veg. 11:139.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43c847fc-5d8f-5610-9160-ff9c9503063d','','','Stand. cycl. hort. 1010.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ed59cbe-2ff5-5f06-9c25-7d97e087244c','','','Gen. N. Amer. pl. 2:113.  1818 Jul  (S. Elliott, J. Acad. Nat. Sci. Philadelphia 1:373.  1818 Sep)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02de8197-6824-54cc-8981-9b48d5eedc67','','','Bot. J. Linn. Soc. 75:369.  1977 ("1978")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45f29c8f-8e5c-58fc-8497-e17fb8e7747d','','','Bot. Jahrb. Syst. 38:50.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e2b816e-b015-5a2c-a95f-d1065988548e','','','Gartenflora 31:98.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9833ce2-c281-5891-8210-a207a6906f16','','','W. N. Amer. Naturalist 73:113.  2013 "<I>gina-glenneae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4b1821a-265c-5a86-889c-6986122ae37c','','','Agric. Colon. 10(2):447, 455, t. 1-3.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ac2ab1e-ba05-5618-8733-3a8e8524d643','','','Pl. delavay. 167.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c531ab3-1558-568b-8722-b6e0f37bbcaa','','','Bot. Not. 1930:334.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74c1ff25-b18c-5c26-b145-971cf776cb81','','','Biol. Zhurn. Armenii 23(2):90.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61cf3f67-915c-5a42-aabd-a2072df22c1f','','','Notes Roy. Bot. Gard. Edinburgh 36:4.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3eed82b4-b869-5156-a5ce-2ee58f693d36','','','Proc. Amer. Acad. Arts 17:352.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89e7a59e-d5fa-5bac-a2b9-787555872a99','','','Anales Jard. Bot. Madrid 59:381.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7cf130e-8eca-5c93-9bf6-fc070116696e','','','Madroño 8:78.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2ca5dd4-45ab-5c09-9dea-2f19e4a1431b','','','Pacif. Railr. Rep. 4(5,1):144.  1857 ("1856")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf6fe995-a6fe-5806-aea0-44d92d42bed8','','','Austral. Syst. Bot. 12:18.  1999 "<I>aphyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ae36d7d-a6ea-5d89-8d57-5fa98e205f0d','','','Acta Horti Gothob. 10:160.  1936 ("1935")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b180f250-475d-5c8e-b711-41e471475180','','','J. Arnold Arbor. 19:59.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72456d18-cc0d-5ca3-974b-0c7b901cad5b','','','Contr. Univ. Michigan Herb. 20:252.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b9bfd96-2d4f-5a2f-a3d0-fc1c81a634f5','','','Trans. & Proc. Bot. Soc. Edinburgh 22:434.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68d7febf-c8f7-537f-b04c-2d92587bfd59','','','Linnaea 1:408.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('646915da-511a-5838-a94f-d1ecb7f49d10','','','Gard. dict. ed. 8: <I>Limonium</I> no. 4.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5aae0f5-0c43-58a5-a6d2-10cee6836368','','','Linnaea 27:251.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('841c751c-f309-5204-a5e3-e8cd9208dc30','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 18:442.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32883249-2187-571a-bb91-56e37fab028b','','','Sp. pl. 1:538.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d78fbf8-23d9-5e49-9dee-13f0d8cb8a90','','','Fl. ins. austr. 53.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d89634ca-f0ba-5b55-9524-d31105208111','','','Fl. Bermuda 135.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79b925ee-05e0-5b1c-b89f-2a417d24d4e8','','','J. Linn. Soc., Bot. 26:300.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a6f98d3-a6e1-56da-98f5-298e3f6bf7d7','','','Edwards''s Bot. Reg. 24: misc. 21.  1838 "<I>Bolbophyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06eda2a1-4674-523d-b1e1-84279a659a7f','','','Repert. Spec. Nov. Regni Veg. Beih. 1:820.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3e11120-ebaa-5334-aaff-c1040def23b2','','','Ann. Bot. (König & Sims) 2:72.  1805 Jun? (Parad. lond. 1(1): sub t. 14.  1805 Oct)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1daf79eb-34fa-5dde-bbe9-f0db00b9f6e1','','','Abh. Königl. Ges. Wiss. Göttingen 24:75.  1879 (Symb. fl. argent.) "<I>Sarmienti</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4125d425-a57c-57a6-9ae6-0c7625665260','','','D. Prain, Fl. trop. Afr. 9:601.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('805d2622-3533-5b7e-b70c-91c0b0175f46','','','Nordic J. Bot. 2:52.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44438970-643d-5eb3-9f42-6dae52ed83ce','','','Phytologia 54:494.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a247148-becb-592f-aa74-2439337716f8','','','Prodr. fl. Ind. orient. 139.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d6eada7-18c5-5766-921a-3dbc65f83b05','','','Kew Bull. 1950:141.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0240760-eaf1-5456-a3c2-98e9d45c1d6b','','','Elench. pl. nov. 74.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e68c3eb3-6f2d-5fdb-907c-50afea7cb202','','','Contr. U.S. Natl. Herb. 16:78.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7f73d8b-03d0-5c2c-a24c-ff9f01a8d3be','','','Enum. pl. Jap. 2:288.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d30f1e7-1172-529e-884d-94fa81a5817c','','','Fl. tellur. 4:124.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1125db70-58b8-5214-879b-62a57e8c2e26','','','N. Amer. fl. 21:89.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab8e18b0-dd9c-5403-95f8-ea6701d3773b','','','Phytotaxa 275:207.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8a9fa57-20d0-52f8-94b4-973c00e29ac4','','','Hort. kew. 1:15.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('902820c2-d680-5e87-b7e1-96dadd7bdee5','','','Methodus 183.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18e02cd6-2763-5bbf-9f9f-83f26e50cdc8','','','Bull. Bur. Pl. Industr. U.S.D.A. 142:67.  1909, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd59d7a4-de7c-5da7-91d0-c995ea2d2f37','','','Prodr. pl. cap. 123.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('048d0f8a-2181-593c-bbe5-750ff660ec9d','','','J. Straits Branch Roy. Asiat. Soc. 75:35.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02fb3e32-1c5e-59b2-aca9-510d3e92b7a3','','','Ukrayins''k. Bot. Zhurn. 70:514.  2013 (Introduktsiya Roslyn (Pl. Introd.) 2009(4):42.  2009, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59fdd9c7-6f70-5a93-a5c5-6ecb6fbe6163','','','Bull. Jard. Bot. Natl. Belg. 58:71.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0b63ce7-3215-5acb-b688-d1ebe127508d','','','Kew Bull. 1949:219.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e2995a6-cd8c-5dd5-b7c0-a05d893526a8','','','Madroño 31:251.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('650aa84c-4318-5917-8576-4f6b5c07a107','','','Lilloa 4:192.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08ddad26-9b7a-565b-9353-3883938e9beb','','','Vestn. Akad. Nauk Kazakhsk. S.S.R. 1950, 3(60):27.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5fb063f-9160-54e4-bb47-1b35ff210fe3','','','C. F. P. von Martius, Fl. bras. 6(3):276.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ad8842d-e5f5-509f-bb55-3459b8dcda2a','','','Mem. New York Bot. Gard. 35:814.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2cd5656-3828-5f44-b081-c2c11969f681','','','Bot. Stud. 12:101.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10f11bba-0587-577f-933c-f1116286297f','','','C. F. P. von Martius, Fl. bras. 15(1):72.  1859 "<I>psoraleaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1932fed-15d4-575d-96f5-fc5bb54dfa7f','','','Enum. pl. afric. austral. 239.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee2bcbb0-4b8c-5852-a564-9097c30bb851','','','Syst. Verz. 140.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0543ac39-8639-5c53-8bc9-e94697650372','','','Hooker''s Icon. Pl. 26: t. 2518.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e710926-5257-5eaf-ba49-b3973c7de4c2','','','Feddes Repert. 95:456.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37e14b78-d7fd-5b36-8894-c3ba12803c08','','','Bot. Reg. 14: t. 1149.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e37528a8-44b0-5b23-b773-81558535b977','','','Trans. Linn. Soc. London 20:212.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3d77b17-b2f0-5a2d-92df-c36e4a3da273','','','Brit. fl. gard. 2: t. 152.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7394b9ca-d13c-5ed0-8075-e77a623f1db5','','','Coll. bot. t. 11.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a2ba078-21c1-5c14-b386-7ed987bfb2a4','','','Fl. germ. excurs. 246.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75277479-51bc-557b-a455-3da596c77533','','','Gen. hist. 2:440.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e44a320f-5d78-586c-8ca7-1f37ae2ba6a2','','','Arch. Biontol. 2:409.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69653668-a5ac-5c5e-b6f1-e8b4b98b3b78','','','Acta Phytotax. Geobot. 2:29.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e9fc603-349a-5211-9f6f-7dc4b58998cf','','','Trans. Linn. Soc. London 17:116.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('269bb0b6-4e59-56df-ba95-0eff64ceaee3','','','Denkschr. Kaiserl. Akad. Wiss. Wien, Math.-Naturwiss. Kl. 79:81.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d03fa54b-f900-57f9-b0a1-b48396f05213','','','Sp. pl. 1:477.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e99e5a74-fbc7-5e62-9ae6-d47978f79fcd','','','Gram. panic. 227.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cac1669e-7d08-5514-9739-9ef73f243d11','','','Fl. Steiermark 2(1):455.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8dbafec-9468-585b-ab1f-48be5acbe34a','','','Notes Roy. Bot. Gard. Edinburgh 23:463.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a498d75c-8dbc-57e1-bc4c-dd30647ffe5b','','','Trans. Amer. Philos. Soc. ser. 2, 7:288.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abf427ba-6f11-5362-821f-4ac90ab742e3','','','Trans. Amer. Philos. Soc. ser. 2, 2:173.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f437067-ce12-5d99-91c2-d03874994ea4','','','Fl. reipubl. popularis sin. 49(2):259, 322.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb8a964f-45e6-555d-8d45-fad80642650e','','','Gen. hist. 2:467.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a78d9f0a-5aa1-5352-b6c9-433bdb9a1239','','','Beih. Bot. Centralbl., Abt. 2, 44(2):204.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1a54f53-3001-54bd-ae89-e4d72312c033','','','J. Arnold Arbor. 5:215.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('715c4fdf-71ff-5ba0-8ff4-a786ce9ee847','','','Kew Bull. 41:461.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25f56795-87cc-5a57-bb6a-5162ccb0d6d0','','','Contr. Texas Res. Found., Bot. Stud. 1:40, t. 11.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('329a6828-e272-5c13-8b83-22d518f359d9','','','Hist. pl. Guiane 23.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb3a2daf-6941-5af9-bfa6-cd68ce561358','','','Ann. Mag. Nat. Hist. ser. 3, 5:351.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3f88370-0a94-58e3-9f00-6adab606fbc3','','','R. de la Sagra, Hist. phys. Cuba, Bot. Pl. vasc. 311.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52de468c-8961-5117-a2f4-965744df86db','','','Syst. veg. ed. 15b, 6:198.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87a7a936-a0f9-5c18-b331-c61415147f1d','','','S. Snogerup et al., Preslia 74:256.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97aafba0-a739-523a-8400-9d141adf1fc1','','','Za Limeca v B"lgarija 209.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f01daa7a-9214-5769-8594-dbc924fe6aed','','','Observ. pl. France 17.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46a5c9c8-f7a4-58f3-a71b-a72ea578a5cc','','','Bull. Acad. Int. Géogr. Bot. 20(Mém.):144.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d047365b-be32-59d4-b444-5c298d6a5c91','','','Bot. Mag. 37: t. 1509.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c52a5e4-8d2b-57ce-93b5-951aefea5927','','','Mem. Coll. Sci. Kyoto Imp. Univ., Ser. B, Biol. 5(3):281.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16d15429-227c-51b0-bdd9-8119062e658a','','','N. Amer. fl. 22:220.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d88abd24-f27d-5b7f-bf0c-649450aea465','','','Bull. Misc. Inform. Kew 1930:410.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88e70cb4-b715-5677-aa94-9bcd30ec352e','','','Fragm. 4:128.  1864 "<I>dalrympliana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b24b3c2-ca77-5cbb-a80c-4e2fb1ad60ae','','','PhytoKeys 205:171-172.  2022','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e5fb936-1282-521c-a849-a2cf2d59f105','','','Feddes Repert. 79:51.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4e0da93-0618-5f5b-a128-27f50f3d0a2b','','','Bot. Jahrb. Syst. 31:98.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8964af9c-a878-512e-acc5-14c5014b22d2','','','Recueil Trav. Bot. Néerl. 31:305.  1934 "<I>ocimifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3898d6b3-32e0-59b9-a984-40c1626723ce','','','Ber. Deutsch. Bot. Ges. 1:351.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6aa3907e-647f-56d8-b0c3-8b49d3abedac','','','Sp. pl. 1:43.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c9d6b03-5755-54d7-b5c8-bb9c4ee32ecc','','','Bul. Grad. Bot. Univ. Cluj 7:87.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f575ac4-6a78-5353-ad17-d985b0d1d3fb','','','J. Coll. Sci. Imp. Univ. Tokyo 25(Art. 19):220.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7bed3c8-6a98-52f4-9e0c-58203e1aebed','','','Bothalia 2:257, 273, pl. 3.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0266b5cc-4a86-5f8b-a7e1-348fb3d44490','','','Repert. bot. syst. 2:947.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1b412f3-b737-59d4-9e77-1b7cbe4453e7','','','Cact. 4:1945.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('291ca626-8565-516e-99f8-eb9bd5c6a0b0','','','Observ. bot. 101.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('290d2aa4-abe8-5666-97af-c030ff93772f','','','Proc. Amer. Acad. Arts 7:353.  1868 (non Michx. 1803)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8d1d90a-41ae-5282-be32-18a242b93ffd','','','Fl. sicul. prodr. 1:322.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bd2c2e0-d46b-5bbf-9cab-dd91782e7f61','','','Ill. Handb. Laubholzk. 2:113.  1907 "<I>maximowiczi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f17f3a2-eed1-5e80-9a77-afc73c69989b','','','Symb. antill. 4:505.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68b8b59c-76b1-5cae-ba1f-f5464fe97882','','','Exot. fl. 2: t. 88.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d5da7f8-e92b-5e70-96a4-3b6bc4b14b5b','','','Fl. dalmat. 3:258.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23fbb5a9-dcf3-5aa7-8571-f813ce021780','','','J. Arnold Arbor. 67:112.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e78706b6-8127-5169-9a75-f67eb1134f7c','','','Contr. W. Bot. 10:56.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b647aff2-c315-5465-b5a2-871daa4d14bb','','','Trudy Prikl. Bot. 19(1):97, fig. 32.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2688544a-1cb9-50d3-b8a1-0bf9f8f8700b','','','Fl. oxon. 44.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0f262ea-7e77-5f64-b8dd-7d83e9350d19','','','J. Jap. Bot. 9:223, t. 25.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c9a1205-0824-59da-9892-3d574ccf6fec','','','J. Elisha Mitchell Sci. Soc. 37:175.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27dd6d5e-3cc0-5c2f-8a5b-c433441fa359','','','Proc. Amer. Acad. Arts 7:359.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b06d72b7-e05d-5f8e-9217-28c4f6f01815','','','Prodr. 5:460.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35132c81-94ef-5739-9b25-43f2d4800d97','','','Repert. Spec. Nov. Regni Veg. 36:50.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aabac52-f10f-59c6-aeb4-76ee12c6e4cf','','','Sp. pl. 3(1):464.  1800 (non L. 1753)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5332958-8466-5474-aca8-5b79724da962','','','Syst. veg. 2:761.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3dc1466c-d653-516a-8082-e1830488ec26','','','Leafl. Philipp. Bot. 1:273.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('941af20a-dc5f-50e4-a346-9ebfb4e1513e','','','C. F. P. von Martius, Fl. bras. 14(2):213.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d774366d-a3d6-5c5f-b720-b2fac1b2cfc9','','','Ann. Mus. Bot. Lugduno-Batavi 1:211.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b62b97f-20e3-51e4-a831-7d9f78e32fd3','','','Cat. pl. Cub. 82, 284.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('903eeb56-5376-59d0-8804-c4672d191b31','','','Cact. 4:287.1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cceae06d-52b2-5dd4-90f3-d7caeed53724','','','J. Washington Acad. Sci. 16:339.  1926 "<I>morrilli</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7c1d37a-9cbd-5ef7-a311-d62fd995046e','','','Ann. Missouri Bot. Gard. 19:48.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf3ccf33-7ae4-5a1a-ab48-7ec070ef8d0c','','','Fl. Males. ser. 1, 5:302.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('581c27e6-e1bc-51ae-bbbf-ddb2b787d494','','','Kakteen And. Sukk. 26:121.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83e77ce1-85d0-5e03-92e1-3a4efbba341e','','','Catal. pl. Banda 47. 1851 (J. Asiat. Soc. Bengal 21:170.  1852)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bec3981-3537-56c5-8a6a-823f88400f0c','','','Phytologia 72:97.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea09a092-a0f6-5f09-9e02-0389b2778f72','','','Fl. peruv. 2:47, t. 187.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3097f60-e3a9-52a4-a9bd-b497f890868d','','','Rep. (Annual) Missouri Bot. Gard. 22:94.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52be08ba-9ef7-566a-a738-145c28aad160','','','Adansonia 4:351.  1864 "<I>nitrariaefolius</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('804fb004-cf7c-5dfe-8a85-e246c0e420ed','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:121[folio]; 6:152[quarto].  1823; t. 547 bis.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea2226c2-dada-5cb9-a084-46e04bc65d01','','','Sert. hannov. 2:17, t. 9.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc32083f-1517-58f7-9955-05f8ce8fa59f','','','London J. Bot. 2:573.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c75c5553-136c-511e-b169-940f843de3d0','','','Linnaea 6:150.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('924cb67c-7dc2-5d3d-8f09-7c3e5dd259ca','','','Fl. Ned. Ind. 2:713.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('701f52ec-8837-5b7e-ad28-155ae5a43457','','','Mesembr. Portulac. 269.  1908 "<I>Mesembrianthemum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c034f25b-77f6-51ff-9bac-ddd89102144f','','','Dendrologie 2(2):233.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb6ebd32-769d-5f9a-b8e6-b6e0f33b651e','','','Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 5,3(3):87.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7f09fc7-c9e2-51f8-b947-e0b45b63c18b','','','Field & Lab. 18:35.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3aa63b4-f5ab-52d8-ba35-6d49128dd602','','','Prodr. 2:435.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c1ba458-4799-53cc-ab8a-094a24199382','','','Notes Roy. Bot. Gard. Edinburgh 13:196.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8ec43e9-01d3-56b0-9b0a-f505124123c8','','','Phytotaxa 24:33.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b17d2064-55f9-5890-9013-a8791a6cecf0','','','Reinwardtia 2:355.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fef94f65-3889-5ceb-b1f3-9132261f1f48','','','Bot. Mag. (Tokyo) 34:274.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6ea2e54-de88-5502-9b8b-56db2689ffaf','','','Novi Comment. Soc. Regiae Sci. Gott. 3:66.  1773','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5de28e90-c68e-5fef-ab6b-3addd325e0bd','','','Fl. Yunnan. 1:60.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf350f93-0299-5f0c-9de7-6c38df0c735f','','','Brit. Fern Gaz. 11:338.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cfb5cde-a472-57c1-9190-e30193fecfa1','','','Nomencl. bot. ed. 2, 1:179.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59ab7b26-26a9-5027-85fe-db65d282835f','','','Handb. Laubholzk. 2:204.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7b889a6-5000-57c0-ba6c-74fbc7987b91','','','A. P. de Candolle, Prodr. 4:653.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b02ea34d-7862-5a19-93c3-08efbe711980','','','Fl. Brandenburg 1(1):85.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88ab36a7-dc31-5fb9-b0df-5855d3932bb7','','','Notizbl. Bot. Gart. Berlin-Dahlem 11:615.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('956367f1-e201-5762-a60b-3002e40fcf3c','','','Proc. Roy. Hort. Soc. 2:121.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70a0456b-d814-5378-a892-7d064f6195cc','','','C. F. P. von Martius, Fl. bras. 4(2):177 "<I>tenuinervia</I>"; t. 36.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d912a2c1-367d-53fb-a256-9cebb9df52b4','','','Expos. fam. nat. pl. 1:317.  1805 (A. L. Jussieu, Gen. pl. 138.  1789, nom. inval.; A. H. R. Grisebach, Fl. Brit. W. I. 5:446.  1862)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f47d6f43-af73-5285-8740-a599b66937ce','','','Hist. nat. vég. 11:331.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25f3eace-c30f-503d-81b2-2f9e5cea7c08','','','Bull. Torrey Bot. Club 101:244.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c7e31c7-2b2b-54b1-a557-5d495acf7e2d','','','Darwiniana 13:397.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25c499a4-1e74-5272-ac2a-8ba7f2eeaa32','','','V. L. Komarov, Fl. URSS 5:466 ("<I>tianschanicus</I>), 716 ("<I>thjanschanicus)</I>"), index ("<I>tianschanicus</I>.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fd260b5-af41-51fb-bf36-53c58cc68fca','','','Fragm. 8:220.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4905e56-a5b6-5f7a-9649-a59aa6f4adfb','','','Revis. gen. pl. 2:783.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6111054e-ba0a-5be9-8f05-b99079b9d83b','','','Bull. Jard. Bot. État Bruxelles 24:337.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17b79e83-fa5f-54d1-9b1a-d35c6598e5d5','','','Bot. Zhurn. S.S.S.R. 30:46.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1efce6ef-a80a-5055-a616-03c8c608cd8a','','','Ann. Missouri Bot. Gard. 91:698.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8b4ff71-82da-522b-934b-93f81e141354','','','Mitth. Thüring. Bot. Vereins, n.s. 6:40.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6e9f7d5-a2ee-55ca-87e3-7b759dac4bb1','','','Contr. Gray Herb. 54:111.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45d639be-6420-561f-9c84-516c95da72fb','','','Sukkulenty 3:37.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b894e18-5b82-5df9-b803-df1e86c11f39','','','London J. Bot. 2:476.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e811d95e-90f6-5f12-a0c5-603ae43cf1c0','','','P. E. Boissier, Diagn. pl. orient. ser. 2, 5:23.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9dfb5c8-9012-53e8-ad23-195da4e130a6','','','Hymenophyllaceae 34.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a40a5008-75f1-5476-b73d-8cd3c9f7a050','','','Sp. pl. ed. 2, 2:1320.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96adce3a-181f-5639-b796-b21c8ae3bb1a','','','Ann. Sci. Nat., Bot. sér. 6, 2:142.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f62b623-d000-5cf5-9bbc-3ee62b14ac0b','','','Kew Bull. 52:725.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f689aed4-dbe4-5d60-a620-295eb6670c2c','','','Bull. Bot. Res., Harbin 6(2):50, 60.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('615eb38b-772c-510a-85d8-493d458a4810','','','Bull. Soc. Bot. France 11:314.  1865 ("1864")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aeea44aa-e594-5ba5-a4ee-fa330a80e344','','','Sp. pl. 1:321.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5b2b46a-621e-5c73-8439-ecfb2966c416','','','Hamburger Garten- Blumenzeitung 22:213.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('877093c4-3134-590b-8fc7-3efa54d6ba20','','','Sp. pl. 1:76.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d12784c3-2705-5cca-879e-6df02a0bc363','','','Fl. Amer. sept. 1:81.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1950b94-357e-5a45-a06f-1f11c5e6d0e1','','','Blumea 42:33, fig. 4.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fde99cef-5731-51a1-a544-32e0d888bffe','','','Svensk Bot. Tidskr. 91:249.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8107ad39-005e-5c31-8824-4bcb7d5b4f81','','','Trans. Linn. Soc. London 30:204.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49e9f5fd-a0e2-5952-bba7-2198855361c3','','','Bot. Jahrb. Syst. 44:176.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e39c9a68-2348-5a6b-8483-1c930ec60478','','','Tentamen fl. napal. 26, t. 18.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2c73493-9185-54b5-ab48-012c948aa026','','','J. Jap. Bot. 13:781.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cb8306d-c473-5611-95a2-fd21d2b84b52','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1881:102.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e82e69c-e04b-5a7b-9d2e-007d6436c1f3','','','Fl. carniol. ed. 2, 2:160.  1772 "<I>polymorphum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4166d6bc-f38a-5cf1-96d6-e63241774418','','','Revista Acad. Colomb. Ci. Exact. 17(65):321.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c28976f-a183-5a3b-8d75-0fa529bfe325','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3a):300.  1897 "<I>Satureia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00851cdf-538d-5b22-b4d1-7b6dcb263659','','','Flora 24(1, Intell.):24.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab2c1d3d-31a4-599c-80ba-402e9b5b64ff','','','Bot. Jahrb. Syst. 25:437.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0af399eb-8c43-592b-9fc5-ab5caf9c6e36','','','Notes Roy. Bot. Gard. Edinburgh 24:32.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a7a9582-bac8-56a5-ab6b-7f46baeaec2b','','','Acta Phytotax. Geobot. 28:31.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8231738c-d00d-560e-b0a0-fdc0e9eeb643','','','Novon 14:424.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1f20173-e970-56e5-82bb-57d8f2f4d935','','','Gard. Mag. & Reg. Rural Domest. Improv. 17:317.  1841 "<I>phyllacantha</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f761bcab-5b3c-5949-98db-c0cd36d73a00','','','Catalogus 65.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2fac9a80-9958-5118-97c2-c9ef5e6b5857','','','Fl. austral. 1:414.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('378501d5-6ea1-5a9a-8ca3-6670de172940','','','Cat. hort. neapol. 1813 app. 1:58.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8527ead1-029f-5c6a-9294-de96e150998a','','','Bot. Leafl. 7:22.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('343133bc-02e1-554c-aa72-42a8028c2bad','','','Proc. Amer. Acad. Arts 11:124.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd212a97-ecdd-5e00-8d06-82e379088707','','','Mant. pl. 1:68.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8a14385-b270-5f93-a526-5ac7db260f21','','','Sp. pl. 1:245.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b45635c-ba69-50de-82dd-ac84f9c20f17','','','Opera Bot. 105:44.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe867546-d9a2-5c32-a239-5ee4a9dd56ee','','','Mem. New York Bot. Gard. 35:91.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c7d28b4-01a2-547c-aeef-9b511a58b5e4','','','Bull. New York Agric. Exp. Sta. Geneva 4:181.  1885 (Gard. Chron. 2:443.  1883, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77ce7570-1fcb-55b9-975b-3ba065d5be54','','','Novon 19:267.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7c89bf2-5bc7-53b2-9a1c-05a62e6c46fd','','','Gard. Chron. ser. 3, 6:154.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('609a97a5-9871-50c5-9164-4e856b6d469d','','','Enum. Spermat. Jap. 3:77.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f24628b3-017b-51c9-a967-6689245af3bd','','','Bot. Not. 111:549.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f632f388-912b-53af-acb0-c57cddf327e2','','','Bull. Natl. Sci. Mus. Tokyo, B 26:39.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bff5c2d-3451-550e-b725-0aba745a18a2','','','C. F. P. von Martius, Fl. bras. 6(4):76.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3335b90c-0654-5476-8e67-6ecf2e5039e5','','','M. Kim, Korean J. Pl. Taxon. 34:13, fig. 1-4.  2004 (M. Kim & S. Lee, Korean J. Pl. Taxon. 21:127.  1991, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1e5eb51-52b4-5b80-941a-ae0d04c095f2','','','Nuova Racc. Opusc. Aut. Sicil. 6:251.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71a2ffa7-79b8-502a-8c43-135fb2b434cb','','','Beih. Bot. Centralbl., Abt. 2, 34:330.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54148619-ff7c-5d10-9c5e-504eef97d0bd','','','Bot. Mag. 159: t. 9458.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe22c5ca-3ef2-5c34-b228-9faa115a292b','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 27:521; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 11:294.  1882 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0efa1d9-6808-5873-9af1-259ebb46edd6','','','J. Jap. Bot. 16:527.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ce37d66-409c-5df7-bfa4-9fa776f3350b','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 9:481.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5abac5d1-5472-5ee3-8bd5-0dcbfe99095e','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 13:383.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32528573-21b2-5631-9167-968e60b9177a','','','De <I>Lavandula</I> 11.  1780','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f25ab397-159e-58bf-82fd-9dfeecb00cea','','','J. S. African Bot. 33:305.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('790aea24-802d-50d4-8582-6039b3634c78','','','Taxon 60:74.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7ca859c-1565-5509-adda-00e41f94ebee','','','London J. Bot. 3:499.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('023e9ed2-2f5c-5841-b225-4f49e2f15204','','','Gard. Chron. ser. 3, 39:146.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b026123-3225-50c3-afd7-f13686b9688c','','','Cent. pl. I:12.  1755 (Amoen. acad. 4:273.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a0ff0b1-4740-51f8-a5be-65e68ee4bdfe','','','Linnaea 12:274.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc91e2f6-f824-531c-936d-2e7b9776ea5e','','','Rhodora 83:149.  1981 "<I>aminta</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27e8eedb-5dfb-5a01-83c3-3bf19b4e3792','','','Bull. Soc. Bot. France 33:413.  1887 ("1886")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7f054ba-e195-5676-b12b-705f645db564','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 12:230.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fac30403-de6d-53ca-90c0-84be3706d917','','','Opera Bot. 91:77.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb6c0bd5-1fa0-5f9c-86d8-3fa03dcb5fe4','','','Canad. Field-Naturalist 45:201.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3c27f0e-1eb2-5add-a7b6-9945c197c75c','','','Syn. pl. succ. 314.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6634fa0-867a-5efe-85b2-f1f5ac73f6cf','','','Bull. Acad. Int. Géogr. Bot. 9:46.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edb12ba2-5012-5101-a86c-40c734b1ddb4','','','Nov. Actorum Acad. Caes. Leop.-Carol. Nat. Cur. 11(1):88.  1823 "<I>ferrugineum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('787c792d-110a-5599-bd80-9dd366098f8d','','','R. de la Sagra, Hist. fis. Cuba, Bot. 11:104.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70c3e82f-1bc4-52b1-aba8-a713cca03290','','','W. J. Hooker & J. G. Baker, Syn. fil. ed. 2:475.  1874 "<I>lidgatii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a26a6831-0e26-5d1d-a8c6-0eb2d30680f0','','','Bull. Soc. Sci. Phys. Algérie 11:2.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('293e94c9-f5ee-5a63-a22b-52f2bd4811ca','','','Bot. Jahrb. Syst. 34:135.  1904 "<I>emini</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a955b47-a1a0-5532-a0b2-548a51a8f72d','','','Bot. Jahrb. Syst. 51:258, 300.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9261071c-953d-5da7-aa36-9724ec68423e','','','Fl. orient. 2:562.  1872-1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48de472d-0303-5f93-9054-dae4d4f12982','','','Brittonia 20:9.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('deaa0124-d1ce-570a-9ec3-6a1739c70e6f','','','J. Hort. Soc. London 4:221.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ddd55c6-21a8-58a3-a61d-b5963ea31692','','','Brittonia 2:244.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd22d626-3df5-501b-be21-b777ed6d8809','','','C. S. Sargent, Pl. wilson. 1:66.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc8e257c-782f-5997-acaa-c26e4056ffc6','','','Not. bot. fl. españ. 2:14.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('528da783-47ba-5e0f-a453-bb3c2c37b2cc','','','Proc. Amer. Acad. Arts 25:141.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63bb8753-972c-57ef-9c35-77355cb84119','','','Ann. Sci. Nat., Bot. sér. 4, 8:226.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c41c5dd-3799-5745-9c9a-dbb9d2163416','','','Sitzungsber. Königl. Böhm. Ges. Wiss., Math.-Naturwiss. Cl. 1892:373.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8480a9bf-0745-58c4-b4ee-78762b82765e','','','Cact. Succ. J. Gr. Brit. 38:66.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('436a39bf-b515-5023-8523-9b822dec0b0d','','','Contr. U.S. Natl. Herb. 2:550.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7bc6437-a986-5a74-8b13-8aee304d709d','','','Nordic J. Bot. 1:236.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('645b7158-b197-5dd6-b049-b24c302f0391','','','M. V. Dechy et al., Kaukasus 3:99.  1907; Repert. Spec. Nov. Regni Veg. 7:184.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f183a96-1656-5701-bea2-60b8d26a4610','','','J. Torrey & A. Gray, Fl. N. Amer. 1:31.  1838 "<I>ochroleuca</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('952e3cfe-d271-5b32-b413-f80a7cb3403c','','','Phytologia 59:87.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62fde4c6-6d3a-57c3-b0cc-68783099c734','','','Sp. pl. 1:301.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6a549a6-8fa2-5e96-afd4-786cf4e049c8','','','Fl. taur.-caucas. 3:93.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a1183d7-0f7c-5b65-8cfa-8fc39322c124','','','J. Bot. 10:257.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb5df91c-6e18-5c7d-87e9-c4757a41a891','','','Fl. sicul. prodr. 2:494.  1828-1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd252896-f8ce-580c-afee-adb988ce86b0','','','Bot. Zhurn. S.S.S.R. 32:267.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f586ec5-22cb-55a6-82ed-dcae1237014d','','','Bot. Jahrb. Syst. 23:144.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca33c7b8-dc9d-5b61-9ecd-babcfc69bb43','','','Gard. Chron. ser. 2, 16:524.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d23be93-0894-5b5b-9f98-89cadcc5b35e','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3b):213.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3b1cc6c-e1fa-5501-9162-5587bd85403a','','','Biota 11:97.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c47e3df3-114a-5507-8dfb-d9821388c04c','','','Contr. U.S. Natl. Herb. 1:66.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('188cf311-79aa-5066-a0bf-52f24718abf6','','','Repert. Spec. Nov. Regni Veg. 33:358.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1064c1dd-5875-5e2a-9d08-f9901a0f00f3','','','J. G. C. Lehmann, Pl. Preiss. 1:644.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34d8b1f8-a89f-50b2-9d41-91ca6068ddd2','','','Bot. Zap. 2:20.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2a1a2f8-a342-58b7-9150-cd9443903be8','','','Cact. 3:140.1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe0b7380-cdc0-57fb-ae2f-2b92ea0d42e3','','','Bull. Soc. Dendrol. France 2:86.  1906 "<I>kamaonia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e6790ce-3643-5ea6-93b4-cdcb19abb154','','','Contr. U.S. Natl. Herb. 24:275.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee1c0e12-355a-5f4d-81e7-602637e12fb1','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:54[folio]; 1:66[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fa6809e-a776-52e7-9c61-cfb908529ece','','','H. G. A. Engler, Pflanzenr. IV. 5(Heft 18):112.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('658fec93-83e8-5912-b6ae-2916914a56ff','','','Proc. Linn. Soc. New South Wales 48:351.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36ff76a2-aa5d-50e3-a345-963750ea6bcf','','','Fl. ind. ed. 1832, 2:380.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c89b7a8-3469-5892-89b8-0a12a9d4b0df','','','Mitt. Bot. Staatssamml. München 19:15.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f85d8913-6ed9-592c-aeb0-d23525c6f07c','','','Species lupinorum 13:197.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bbb29f2-4857-5a06-8bc1-762148ecc341','','','Tent. fl. abyss. 1:116.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97f98450-5d86-504b-b851-0aa735b465b8','','','Bot. Közlem. 37:40.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c79eb1d-4e8f-565e-bbc7-d54722be3cf1','','','F. Cuvier, Dict. sci. nat. 37:491.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c29cb5d-4de6-5f15-b4e4-df057e6adb14','','','Ann. Sci. Nat. (Paris) 4:92.  1824 Jan (Prodr. 2:264.  1825 Nov)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7d50469-e2aa-55b8-97b2-ee727317644f','','','Trans. & Proc. Roy. Soc. South Australia 39:835.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad529b94-6d97-55b8-a35d-13955a3556aa','','','Proc. Roy. Soc. Queensland 50:76.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7558abfb-8c71-5822-99c1-99d9a670e994','','','Sp. pl. 2:954.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da7fc015-6f5e-5d96-b412-f8c54876e13b','','','Cat. pl. Yun-Nan 159.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3766d9f-730f-5f92-97ea-506083809993','','','Prodr. 3:8.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80c0f62b-047c-5836-9d70-dcf6db3af736','','','Ann. Nat. Hist. 3:432.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abc0981e-9757-5c33-befe-95b77fad7f4f','','','Novit. fl. suec. alt. 273.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1994f036-72d4-5a24-8616-8d6bbe4f87a6','','','Bull. Soc. Bot. France 44:321.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9e3ab3b-810c-5225-96b0-ca14a459fd96','','','Amer. Midl. Naturalist 19:433.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f43bc82-9721-529b-aeda-62d396c6e651','','','Bull. Mens. Soc. Linn. Paris 2:931.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86da5ce5-b0c5-5451-bd76-0d0212145c9c','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 23:265.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49fa1daf-a364-5d5b-8447-7b67a1d5f1d0','','','Pl. Syst. Evol. 166:249.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16119e96-27a8-57a0-bf4e-b41c49feec78','','','Fruct. sem. pl. 2:298, t. 143, fig. 9.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01d676cb-a7df-5f52-8ed8-d8c7eb03ff71','','','Fl. ind. ed. 1832, 3:838.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('378fdc6d-fece-5cb1-8741-68afef9b1af6','','','Proc. Amer. Acad. Arts 17:348.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3871422-387a-52a5-9f6c-530808b8445b','','','Contr. New South Wales Natl. Herb. 3:161.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac248434-fa04-5314-a4e2-7bd80b6fe71e','','','Select. stirp. amer. hist. 99.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9f1c8e7-6244-5d92-aa14-82e31f98cf33','','','Ned. Kruidk. Arch. 3:384.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('807f9c7f-825a-5528-961e-33a80089c7d1','','','Pl. hartw. 46.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15b53fe1-c193-5a3e-8689-8a1087331e02','','','Fl. N.W. Amer. 108.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2061e696-bf69-5b3d-a413-aa5e1017e7a2','','','Gartenbohnen 26, t. 1, fig. 1.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f2938e6-783d-5682-bcf3-320f89e3efa5','','','Veg. mater. med. U.S. 1:17.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9080bf73-b8a3-5b95-b5ea-13549e45ce64','','','Prodr. fl. cap. 6.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b06237f5-a8e7-593d-b744-bacbbafff3cc','','','Abh. Königl. Ges. Wiss. Göttingen 19:227; Pl. lorentz. 179.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ae308a6-57d3-546f-9891-49a3b3c05c64','','','J. Arnold Arbor. 50:355.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a47d12e8-d31d-5002-bd99-ef9745848474','','','Bull. Jard. Bot. État Bruxelles 19:401.  1949 "<I>hymenaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85aa22f4-f39a-566c-8079-de82dd286117','','','Adansonia 10:183.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7e006f8-2dd0-52dd-972f-045a93b75d38','','','Sp. pl. 3:1746.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41de6d9d-ec20-5e09-93df-a3b1c3d210ef','','','Minnesota Bot. Stud. 1:870.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d24ad37f-bed9-5c05-ae20-e7e56f56676e','','','Mem. Wern. Nat. Hist. Soc. 1:45.  1811 ("1809")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3ad5bf1-0d94-5fd1-8c90-0d3e88f8248c','','','Trans. Linn. Soc. London 10:72.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f598e097-1778-57d3-b263-971a572db60f','','','Hort. brit. ed. 1:491.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cec53aba-c133-5938-9e0c-35a7434c13a3','','','Actes Soc. Linn. Bordeaux 33:87.  1879 ("<I>carmichaeli</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50b2e4e5-213f-506d-b4a0-759e123532de','','','Notes Roy. Bot. Gard. Edinburgh 21:42.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('812ecaec-9528-5e74-bce4-aac189e788e3','','','Bull. Misc. Inform. Kew 1923:323.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ea44aef-798a-59dd-a8a3-de197da5c1fc','','','J. A. Murray, Syst. veg. ed. 14:476.  1784 May-Jun (Fl. jap. 217.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3a9ea83-d3f0-5db6-bd6a-47450d3e6bb9','','','H. G. A. Engler, Pflanzenr. IV. 276b(Heft 106):88.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea5bcea9-b8f1-5964-a021-a9caafa1b289','','','Amer. Fern J. 41:19.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bed61906-c5c9-5ffe-b3f9-8bbfdc2d3ff5','','','Proc. Amer. Acad. Arts 22:409.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5ee59b4-af06-5abd-9c8a-39ad07cc31de','','','Erythea 1:111.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41428622-00de-508b-b86b-9730efd2bfa9','','','Amaryllidaceae 105. t. 8, fig. 1.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('449ec653-5705-52fa-af52-fd85a25575a1','','','Blumea 13:102.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94ddb0b2-5220-5e53-9f07-6585cafda5da','','','Caldasia 2:65.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c6e8284-9682-5c47-962f-57a2bce8755c','','','W. H. Brewer et al., Bot. California 1:110.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43c2becf-5326-5022-8d12-4beb172aa33b','','','Misc. bot. 1:18.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53218ce3-a5d3-5939-89bd-663540f5cfe4','','','Syst. Bot. 3:218.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dedeefe3-9a87-585b-b91c-5eb4e9c1ad8a','','','Bothalia 20:2.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fd17a96-ad3d-57ce-839a-51d0a434d7e1','','','Z. Sukkulentenk. 2:177.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0d6bfef-40c9-5db8-9c72-f21685c0a0a7','','','Fl. ind. ed. 1832, 2:501.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bf20a3d-74ad-5c06-97cf-e81471423816','','','Bull. Bur. Pl. Industr. U.S.D.A. 242:38.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c80f1f6-584c-557f-98e0-90fa10e41666','','','Prodr. 5:452.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('079e9391-cd72-5cf8-acd5-7bb05b3aa8fd','','','Gard. Bull. Singapore 19:270.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('958c52d3-f45c-5ec1-8d48-e64f108a4cf3','','','Bull. Mus. Natl. Hist. Nat., B, Adansonia 10:148.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe1ed0b0-b2c1-591c-93f6-6a9004ffeef9','','','Kew Bull. 70(3)-31:18.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69486639-2485-597a-8dbe-c793eb5f21b6','','','Folia Geobot. Phytotax. 8:392.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db7b8c02-4217-56cc-beca-b50560bdbd0e','','','Mitth. Thüring. Bot. Vereins 20:19.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1f31ca6-0cb2-57c0-9987-76f7c5dccb32','','','Arch. Jard. Bot. Rio de Janeiro 15:38.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cf24542-b7e1-5070-a1ea-430ff69d0d6b','','','Bot. Stud. 49:161.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53c5bb4f-6825-56ee-accb-c3269035ea6c','','','Index sem. hort. petrop. 6:60.  1840 (Select. sem. hort. Erfurt. n. 8.  1832, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('274ff358-d555-53c2-bf5f-d05035342f91','','','Bot. Jahrb. Syst. 43:104.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc9fe2e8-bfc8-5bae-a50f-3108fec4328e','','','C. S. Sargent, Pl. wilson. 3:99.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48b0e757-33bb-5f45-a8ed-179d8cecc824','','','Bull. Misc. Inform. Kew 1895:264.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf60a471-fe2f-54d6-b4ab-870b27edb204','','','Methodus 225.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2585221e-2495-57b4-a4a2-864a076c838d','','','Fl. ross. 3:117.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('809cfd93-90cd-54e5-aaab-69819b3a3886','','','Legumes Bahia 164.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3aa90bb7-6c7c-5b52-90a7-b3eb02cefb2d','','','Leafl. W. Bot. 2:128.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d419141a-2300-5bba-9af5-db8094d706cf','','','Exot. bot. 1:33, t. 18.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24920099-9ea8-5e6b-8402-92ea91ace6a9','','','Repert. Spec. Nov. Regni Veg. 10:119.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efa0a029-e30c-52cb-bddc-fc99b568befe','','','Contr. U.S. Natl. Herb. 18:276.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70afa7d4-9619-5ba0-8c56-cb3d53c1cdb6','','','Sp. pl. 2:1119.  1753 "<I>variegatum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d56925d-2572-59a5-a0fd-ec483349c555','','','Fl. n. middle United States 94.  1823 (non Poir. 1816)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bea90bdc-7eff-5977-91c1-178c07c11558','','','Mem. New York Bot. Gard. 1:131.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7179d40-9a9e-53df-ad9a-181f43038139','','','Bull. Mens. Soc. Linn. Paris sér. 2, 1:24.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52b6716e-cbd3-5476-b9ec-8199bb99948b','','','J. Roy. Hort. Soc.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3147d753-8b8a-57ee-8fdf-d19536b77799','','','Acta Bot. Venez. 10:273.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f3d31e1-9cac-5e81-b787-a4527f0805ec','','','Syst. Bot. Monogr. 83:207.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96fdd1f8-4709-5c89-812e-48e72a0e1e56','','','J. Franklin, Narr. journey Polar Sea 759.  1823 (Bot. App. 20)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4e3e677-0014-51a4-b037-cdf56d85ba3f','','','Acta Phytotax. Sin. 20:305.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e86f22b-7963-5886-b652-5959d3b6df06','','','Sag. stor. nat. Chili ed. 2:130, 284.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6da2a305-376c-5418-96fa-e24a8d82c7d5','','','Neolin. fl. manshur. 237.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01cba72b-7594-5c41-9a2e-f113735bdd66','','','A. L. P. P. de Candolle, Prodr. 15(1):216.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e48a18fa-e9c4-5371-a9ba-6f7acee5188e','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:404.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b6773b2-eb35-5fde-8f91-4f502740479a','','','Trans. Linn. Soc. London, Bot. 9:188.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6340787-ce6e-5388-8f49-1dbaa0179043','','','Saxifrag. enum. 2:55.  1821 (Revis. pl. succ.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71d64ff7-b77e-53ee-9f8e-e3edab229af7','','','J. G. Hawkes, Rec. Scott. Pl. Breed. Sta. 146.  1963 (pro sp.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b9c0aa1-3595-5780-bec9-ad8f8776974a','','','Parad. lond. 2(2): t. 96.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6635a392-e01b-5be0-86ca-0235d783b950','','','Mém. Acad. Imp. Sci. St.-Pétersbourg, Sér. 6, Sci. Math. 2(2):145.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2885d7c-f3be-5ec5-b765-cacc99b6b2a2','','','Notizbl. Königl. Bot. Gart. Berlin 5:260.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71048c81-b062-5fe8-94c7-c75a1c64860c','','','Revis. gen. pl. 2:218.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4088fd7-af97-50f8-bc93-da57be064cff','','','Fl. Kavkaza 3:104.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('160d50f2-0807-5437-91e6-49b39a717792','','','Linnaea 21:576.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb75fddc-994a-5239-a41a-08859305185c','','','Mitt. Deutsch. Dendrol. Ges. 1915(24):214.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bed1ab19-81c6-508a-bf78-475b4169e1f2','','','Encycl. 1:369.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89e7a4e3-725d-55c3-84e5-95a468bb4052','','','Bot. Reg. 11: t. 883.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe3e16d9-a710-5a6a-b3c8-096b80f8bb6b','','','Cat. vasc. pl. S. Tomé 186.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e907fe6-8d69-5896-99f6-ba400e773936','','','Bonplandia 30:170.  2021','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8710b796-42ef-5afb-80c8-2e84d0acab99','','','Bot. Mag. 125: t. 7655.  1899 (Gard. Chron. ser. 2, 11:216, 12:525.  1879, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae44790f-1886-5ed4-89e1-e6195ac13337','','','Rec. Albany Mus. 2:256.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a0ab0bf-c730-5912-bb49-9a85e0d40854','','','Jahresber. Naturf. Ges. Graubündens 2(23-24):93.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c51a9958-dc2e-52a8-aaf5-dc79636f822d','','','Hort. brit. ed. 1:53.  1826 (non Panz. 1797)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f196a178-31d0-5070-8ddf-0fbdd596dc9b','','','Bot. Zeitung (Berlin) 3:345.  1845 "<I>guianense</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('611e01d7-803e-594c-8282-3b22d936d04b','','','Novon 9:375.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('134bc4c1-0dcc-57bd-9f53-4fe2f4374dcd','','','F. Henkel et al., Das Buch der Nymphaeaceen oder Seerosengewächse 68, fig.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef590d30-1077-53bd-94e3-11a929cc08f2','','','Fl. N. Amer. 2:216.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27a056f5-1ab4-5840-b9c2-da67d56e4368','','','A flora of North America 1:230.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26dc203b-3321-5ada-add4-c5bcdbdfd9f0','','','Pittonia 4:286.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e162f6d0-4076-517c-859a-9d4a994a81dc','','','Repert. Spec. Nov. Regni Veg. 21:11.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78ac9bf3-faec-5aba-891a-0b89008f262d','','','Muelleria 11:118.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('181fd1ff-b637-5741-8906-fad82ca72e17','','','C. C. Lacaita, J. Bot. 67:151.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e9dc032-24bd-5b79-be1b-a75f68e1576e','','','Sp. gram. stipac. 173.  1842 (Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 7,5(1-2):173.  1843)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('924d955d-fc78-5823-b64a-0e9b45c81d4d','','','Prodr. stirp. Chap. Allerton 91.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('119960f4-d6cd-5e3d-8a0d-20cb405b46b2','','','Gard. Bull. Singapore 26:155.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('743d7248-a03b-5a88-a2b7-ec41d631700c','','','Bull. Soc. Hist. Nat. Afrique N. 29:447.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff20428d-bb43-54a1-9a90-5a26d662b24d','','','Bull. Calif. Acad. Sci. 1(2-4):157.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f965908a-94b2-57b1-a832-b94f271b2bcc','','','Jaarb. Ned. Dendrol. Ver. 21:99.  1959 (Boomkweker 12:39.  1956, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dad2a66-d1f1-543a-b0c3-7207caf598d3','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 12:121.  1824 (Gen. pl. Umbell.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('147caee1-8a5a-50a5-bddc-fd671a569eed','','','Pl. rar. Sicil. 1:13.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3ec9606-4426-5cef-b8e4-b48fff3dd5bb','','','Pl. nouv. Amér. 34, t. 23.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e58af115-b1e6-5b5e-b8fb-e82d609f9a10','','','Enum. pl. 1:565.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cb613b2-a2d8-5830-b4cc-94d896a505fb','','','Proc. Amer. Acad. Arts 8:537.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('134e593c-389b-528d-8dc6-69a1763cd8f9','','','Publ. Arnold Arbor. 1:19.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abc034df-9b30-5f28-939d-103b7ce58c7a','','','Cyperus 154, t. 6.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85f9471b-e63c-5d43-8ed0-31ee7954d3b8','','','Mem. New York Bot. Gard. 27:36.  1977 "<I>simplifolius</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96c8bfe2-6abc-5c24-8d4d-5ad46de00aa6','','','Nov. gen. pl. 10:149.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2367f325-f465-5df5-8567-b1f827f08afe','','','Syst. nat. ed. 10, 2:897.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bb0a9f1-f195-5ce3-8f87-2f6d7f010c9d','','','Icon. descr. gram. austriac. 2:69, t. 97.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10237f3d-b38f-53db-bcc2-98b7ce82f909','','','Kongel. Danske Vidensk. Selsk. Skr., Naturvidensk. Math. Afd. ser. 5, 2:319.  1851 (Mexic. neldeagt. pl.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a37f22d1-a6bf-582b-98f8-c249a7a31de4','','','Bot. J. Linn. Soc. 80:198.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3ceb894-aebd-5f3d-a569-871d2942bf10','','','Bot. Gaz. 30:336.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5415748-128f-5291-a8df-4e32dae10790','','','Rocky mountain flowers 183.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24107d7e-9109-50bc-86a4-972082c5375d','','','Oesterr. Bot. Z. 35:189.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f07a311-6d72-5834-a125-ad7e6f422ffa','','','Bull. Misc. Inform. Kew 1928:73.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e3810cb-2b3b-5a16-b070-51ec3fa77e6c','','','Brittonia 65:6.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('190c8f7a-125b-5035-8cfd-f78925597782','','','Mem. New York Bot. Gard. 35:258.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82984a4c-3fa3-520a-962b-44f08a6bff08','','','Gard. Chron. 1873:608.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec0443b5-a7ed-52b7-975d-2ddb2b648a54','','','Cact. Suc. Mex. 25:65.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04a32b1c-3797-50a9-b91b-b8b310977144','','','Great Basin Naturalist 30:125.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('424d42c1-5b06-5472-af54-b6e8ed5db467','','','Syst. nat. ed. 10, 2:1148.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41013cb1-e3c6-5e19-8b97-8e86633e1860','','','Bol. Soc. Brot. 10:124.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cebdfd6b-40c9-59c6-880b-f75bd0b3d3af','','','J. Bot. 37:428.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73442a14-b3bc-5a5f-8e79-83e0dabe8f4d','','','Pl. hartw. 295.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aef95c9e-50f4-5f74-805e-d2797cb413f7','','','Hist. nat. Iles Canaries 3(2,1): t. 9.  1836; 102.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df6e5ae7-035d-58fc-a1e1-0154db9c9bde','','','Byull. Moskovsk. Obshch. Isp. Prir., Otd. Biol. 52(3):57.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bb935f3-f03f-53d4-9eec-d6689128f7f7','','','S. Watson et al., Bot. California 2:233.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91d71d00-2967-59a9-b306-f0b7b3638bc0','','','Linnaea 32:49.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7829a05b-149b-5798-bec7-2d074edc5e22','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3a):328.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c521f37-2fc8-5f28-b988-cf64d2b14671','','','Nova Acta Acad. Caes. Leop.-Carol. German. Nat. Cur. 68:305.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b6b97ff-915d-5392-b7c4-5bb2c03df214','','','Proc. Amer. Acad. Arts 18:128.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30e3420c-4764-555e-aa0b-ce667bc6d0a7','','','Deut. Fl. 324.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6075473-3d7f-55ba-9f19-78c65c2fb5c8','','','Ann. Sci. Nat., Bot. sér. 6, 18:221.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd3e7843-68fe-588a-bf18-ad5caf5215b0','','','Lyonia 2:6.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58c684c3-6c52-5deb-b5d9-a89c5620dc18','','','C. F. P. von Martius, Fl. bras. 15(1):69.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4954d4f-22d2-5c16-bca0-e8b4847d7935','','','Proc. & Trans. Roy. Soc. Canada 6:112.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0797642-a7ed-5de6-a104-8c3df8caf889','','','Taxon 60:135.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1905f2e9-8a38-50ee-ac43-833bc1d1f6d4','','','Notes <I>Mesembrianthemum</I> 3:335.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a70766c5-3e2d-5266-a13d-0d59d5d341d8','','','M. M. A. Lesson & A. Richard in J. S. C. Dumont d''Urville, Voy. Astrolabe 1:246.  1832 (Ess. fl. Nouv.-Zél.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7098f2ab-274b-5663-99c9-30a5675d3626','','','Contr. U.S. Natl. Herb. 20:111.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cd97883-d2d1-5f7c-9416-79860b833fce','','','Trans. Linn. Soc. London 10:194, t. 2.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94a4f3eb-f18a-5db9-bfe7-abba4b3b3c00','','','Syll. fl. Eur., suppl. 73.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e63b4b72-1bff-55f0-ae51-3e0efcf45dc7','','','Pl. delavay. 186.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0488894-9a31-5412-a9a2-bba9471881fe','','','J. Arnold Arbor. 10:97.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6ca1daf-c133-57cc-b724-2b8c6a960466','','','J. Arnold Arbor. 26:474.  1945 "<I>rubro-marginata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c82d9068-18be-54e3-b0c8-218b84237a16','','','Ann. Mus. Bot. Lugduno-Batavi 2:97.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0975ba48-1c0a-540a-9399-023124fe3d62','','','Trees shrubs Japan 13, fig. 4.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b930698-5ba3-5e9b-a974-410ecfb822a0','','','N. Amer. fl. 22:27.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('270b42a6-8a92-5cc5-80de-51aec118d571','','','Bull. Herb. Boissier sér. 2, 2:947.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26a0394d-dfee-5b32-87e2-caf7c6d1ed92','','','Edwards''s Bot. Reg. 24: misc. 90.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be9be35e-1ef0-5bb5-86c1-c6c15553329c','','','Bull. Mens. Soc. Linn. Paris 1:763.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6970738-dc45-5005-90ee-7893bd7ac8c3','','','The genus <I>Paphiopedilum</I> 131.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de62ad6e-ba71-5870-a9bc-d9cffa820cac','','','Proc. Calif. Acad. Sci. ser. 2, 2:220.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c253fe6f-286d-5240-9595-3ee3ae71b18c','','','Sp. pl. 1:470.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eef150ca-b3dc-5319-83da-0a463601702a','','','Bol. Soc. Brot. 6:45.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a326419e-8b72-58ca-b5e3-ff196c4ca192','','','Syn. pl. glumac. 1:132.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd6f8300-5219-5684-bbec-4a3e8408b9d3','','','Mém. Soc. Acad. Maine Loire 6:37.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bed8891-52e1-5573-ba98-b71090c73b36','','','Torreya 11:260.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a89ee2c-ab5e-505f-8318-aa319df06842','','','Enum. pl. suppl. 34.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37206f31-19f8-5ea1-b7fa-c0c46e7a4ae5','','','Flora carniolica ed. 2, 1:269.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d1ee12c-deab-55b1-9371-21b134764f66','','','Y. L. Keng & S. L. Chen, Acta Univ. Nankin. Sci. Nat. 1963(1):76.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37abd730-fd60-5caf-a00c-56ef30a06610','','','Fl. South. U.S. ed. 2:603.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59b2ecb1-86fb-511a-8e95-3baa3d06ba7a','','','The potato: evol. biodivers. genet. res. 188.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55c57266-c4dd-5fc8-a0c7-59a7c412364d','','','Fl. ind. ed. 1832, 2:441.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('880f69fd-ca98-563b-9e00-1b7248f294aa','','','Bull. Misc. Inform. Kew 1936:270.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9aca701-9141-5f25-ba77-a8fabcaeeef3','','','Gard. Chron. ser. 3, 2:126.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71be1311-21a3-5ed3-b24a-32b59df64174','','','C. Wilkes, U.S. Expl. Exped., Phan. 15:504.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78e3ac91-0b0e-5665-8cce-fff11b0eb53c','','','Gard. dict. ed. 8: <I>Robinia</I> no. 8.  1768 (non Jacq. 1760)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de5139cf-79ee-5d85-812b-21f1a530cca6','','','Fl. bor.-amer. 1:135.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04bd92ac-99df-51e6-8a0f-2c338b78873a','','','Zoh. & D. Heller, The genus Trifolium 173.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10abd5f8-dc89-5849-bb8a-00bc603ded95','','','Handb. Laubholzk. 3:343.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd98a469-7541-5700-84df-685b8ef27c5b','','','öfvers. Kongl. Vetensk.-Akad. Förh. 41(7):79.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df54c392-e59c-5469-a5e0-02e9f148b5af','','','Linnaea 43:326.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8673097-421b-5891-83db-1470b2701623','','','Boston J. Nat. Hist. 6:177.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('926dd46c-851b-59e2-a348-e5deaeb2f9b7','','','Ann. Sci. Nat., Bot. sér. 3, 12:170.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98be5586-1880-5684-930f-5fd0959c49a6','','','Opred. Rast. Sred. Azii 10:131.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cbdbd98-515d-5988-9b7b-ad19d1fb23d2','','','J. Jap. Bot. 15:317.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f78abfc-77d9-5a5a-a19a-b7c699e0f602','','','Hort. kew. 3:146.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbbd2f20-5701-5b7f-ba4a-66176bd53457','','','Za Limeca v B"lgarija 218.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ed5eb9c-5743-5ed6-953a-3a675f6955d6','','','Contr. U.S. Natl. Herb. 15:66, fig. 48.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e01c07e8-82d3-58e5-bf87-a15194b49244','','','Notes Roy. Bot. Gard. Edinburgh 5:242.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f20b59e-0d75-5408-9264-898d9f70ce1e','','','Bot. Reg. 4: t. 346, in text.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc193f77-70a0-551d-9be5-0e1955e6fb3c','','','Fl. Filip. 174.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83d6ba31-4675-5fe6-9141-6945db8a1718','','','J. Arnold Arbor. 20:95.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8f90af1-0f5d-5c26-8ad2-cbe43ef0acca','','','Prodr. 103.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be2615b2-0985-5645-ae24-54b28bd894b9','','','Mem. Wern. Nat. Hist. Soc. 3:409.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f11523b9-3679-527b-8e59-0873174b8e8d','','','Bull. Misc. Inform. Kew 1928:333.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('724dc61c-4d77-522e-8209-9d9f712c82c4','','','H. G. A. Engler & C. G. O. Drude, Veg. Erde 9(III,2):262.  1921 (Pflanzenw. Afrikas)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c9972e9-d223-5f54-b9f8-c3f6040e4124','','','Bull. Misc. Inform. Kew 1909:143.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bd34464-8180-5d78-8e7a-996d573efaef','','','Tabl. encycl. 1:211.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c93e5197-a895-5704-9d84-6d789b5a80bf','','','Gard. Chron. ser. 3, 84:253.  1928 (E. P. Phillips, Gen. S. Afr. fl. pl. 247.  1926, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56b4e2f5-1a47-58fd-914a-fae8d277052f','','','Acta Bot. Yunnan. 5:275.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97aa54df-f8a3-578a-b85e-3c3c4ea43276','','','Gard. Chron. ser. 2, 17:44.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a6c106a-6313-5106-81cb-e198bd0207d9','','','Gard. Chron. ser. 3, 57:175.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28245c6a-ae54-5744-a3d5-81eb24ff2318','','','Bot. Jahrb. Syst. 45:305.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('982742d0-8147-5be3-a97e-0360dc2a47b1','','','Bot. J. Linn. Soc. 102:383.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b91dff22-9695-56b6-aa50-ea735de4210c','','','Fl. germ. excurs. 524.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b9253cb-c861-5604-b4d8-918e6a559afc','','','Bijdr. 475.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('909b6336-dc76-5e38-a12f-0c27e1125286','','','Bot. Mag. (Tokyo) 30:17.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('853d5dcf-7d21-5936-befa-a586c4eb6301','','','Bot. Gaz. 31:399.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2630566f-130a-57ec-9ef4-b092f8e4b995','','','Linnaea 7:395.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17cc9803-9433-5491-9a97-87627d7e8e7b','','','Pl. bequaert. 1:355.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fdde7a0-b5b6-5a2c-9457-3063515d604b','','','Formosan trees (ed. rev) 527.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c417b29-160c-5bb3-9cf8-dd6e59fcc260','','','Bot. mat. med. 3:243.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0b4091f-fe99-591e-9546-43a50b50aa82','','','Repert. Spec. Nov. Regni Veg. 18:157.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('234ee832-6ec8-5415-b014-1869d1348ee1','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 17:160.  1872 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f9931cd-6c68-519f-a826-07d1f4077dc9','','','Rhodora 68:422.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f638da4d-aad0-5f0a-b87a-4080cef29bf7','','','Bijdr. 119.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61a80d64-4de1-5961-bbd1-d60140239110','','','Bot. Mag. 140: t. 8591.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2380ac74-4d58-591a-9ada-5253960a7dd4','','','J. Arnold Arbor. 37:182.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13c31e6b-b1ab-50d2-9979-e80f708dab2f','','','Fl. orient. 1:587.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ff20ffb-0122-556f-aaed-84ceb24a685d','','','Gard. Chron. ser. 3, 71:307.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b42666f-061d-5165-92a8-693e84b5c075','','','Bot. nomencl. 247.  1794 (C. L. Willdenow, Sp. pl. 2(1):540.  1799)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29034042-7920-5a83-9929-d4f25fcee114','','','N. L. Britton & A. Brown, Ill. fl. n. U.S. 2:306.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('119e2256-f18a-5333-b21c-af74dfdd3843','','','Bot. Cab. 7: t.  681.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11a5223b-8385-52e7-8405-57a3baeb8a59','','','H. G. A. Engler, Pflanzenr. IV. 45(Heft 1):22.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1324c50-5abf-5314-b777-674a72a6e58c','','','C. S. Sargent, Pl. wilson. 4:134.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68933db1-f7f3-5f76-8518-4a9def7035d0','','','Fl. Amer. sept. 2:520.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ac8f380-a146-564a-89f9-c34fd0cbcb1b','','','Izv. Glavn. Bot. Sada S.S.S.R. 29:541.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bf7f88a-c755-5ec6-aa8a-2853002ba1b1','','','Great Basin Naturalist 44:190.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5914164d-6c9e-5e1a-ad00-a1873b6669a3','','','Rec. Bot. Surv. India 4:265.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb097315-e1a1-5ac2-8411-079854b721e1','','','Proc. Amer. Acad. Arts 23:224.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b02ae13-40f7-5439-b840-17c05110cfc0','','','Bull. Soc. Bot. France 75:42.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae943856-5658-525c-86d4-402b0abbdb26','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 214, in adnot.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f42839e7-84e6-5a9f-887d-566baab9ea41','','','Proc. Roy. Soc. Queensland 80:64.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c702d41a-37dd-5572-a543-9c911fcd273c','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(5):406.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f998504-2615-5adc-b86b-491da8e6d1db','','','Pl. rar. 202.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('473d084a-cf1f-59e5-a07a-f409d0f3a139','','','Ann. Sci. Nat., Bot. sér. 2, 17:45.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9b6f1a8-bc36-5564-ae40-8b431783a856','','','Gard. Chron. ser. 3, 79:194.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06d57443-5e5e-5bac-8b99-96b48c7268c7','','','Muelleria 6:359.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d57cca7-d4dd-5682-b6e4-b5fe3b5c9cd7','','','Contr. U.S. Natl. Herb. 7:220.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93c4443b-8567-5d8d-a8d8-347685f3c903','','','Brittonia 60:235.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c75efc2-e496-51b3-a64a-cf4f52dbfd50','','','Repert. Spec. Nov. Regni Veg. 23:200.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aa58b00-4aec-5eaa-b33f-9f31ff78ee0f','','','J. Roy. Soc. Western Australia 22:123.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09b5bb08-9f57-5e0c-932d-2f715d2c2645','','','Nov. Holl. pl. 2:31, t. 173.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0578e925-e406-5222-a731-afd18b75564a','','','Ill. fl. Égypte 169.  1887 (Mém. Inst. Égypt. 2:169.  1889)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9676e49-b25e-508f-ab09-4f0059a45ac6','','','Bot. Jahrb. Syst. 45(3):394.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6e4a3a4-5c2a-5b9a-ac63-aa246920e84f','','','Taxon 34:702.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b711a0b-13fd-58a0-b4e2-10143de1baeb','','','Trans. Amer. Philos. Soc. ser. 2, 24(2):334.  1935, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67bfba4b-082d-5bd4-b3f0-f4abf4815a12','','','Jahrb. Gewächsk. 1(3):24.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89b9b564-a548-5fca-be3b-934c07025cb4','','','Repert. Spec. Nov. Regni Veg. Beih. 33:251.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('658b937f-22e6-5ee7-a912-1614310b0ecc','','','Gen. hist. 4:82.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d7beb49-76ad-518a-be0a-137bfeda7e1e','','','Trans. Linn. Soc. London 30:208, t. 47.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da63b164-9925-55ae-ad29-aa5fd26dfff2','','','Kew Bull. 1950:27.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cba02999-d138-5b5e-9b44-b3a123042e9f','','','Gard. Chron. ser. 2, 17:525, fig. 81.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1cf703e-e702-597a-8b4f-3c5cf6db64b2','','','Sp. pl. 1:363.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cfba68e-d22b-572f-b55f-4be3a895a81e','','','Sp. pl. ed. 2, 1:77.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcdd2fca-91e6-5313-b8bb-212caf1c9bc7','','','Diagn. pl. orient. ser. 1, 11:67.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57b634c3-52a1-5e1a-9e46-b3517c140d16','','','Repert. Spec. Nov. Regni Veg. 15:85.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfe6c31a-f348-57e4-8e9c-69a5ffa4c8dd','','','Bot. Repos. 8: t. 532.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fba66257-5b36-5c63-a578-e29b2a3c4aa7','','','V. L. Komarov, Fl. URSS 2:770.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25fdf35f-13a3-5d70-8107-62e01f85704a','','','Bull. Jard. Bot. Buitenzorg sér. 3, 9:288, fig. 6.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d74c10a0-c9fe-5026-b242-1a70889a7da2','','','J. Franklin et al., Narr. journey Polar Sea 731.  1823 (J. Richardson, Bot. App.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9f8eef3-7ea7-557d-9393-a496033690ae','','','Trudy Prikl. Bot. Prilož. 47:514.  1930;  Izv. Akad. Nauk S.S.S.R., Ser. Biol. 2:310.  1937, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2da56d2-90fd-51fd-89bb-2865d54cb004','','','Linnaea 6:507.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abc3d87d-54bb-5e8e-bbb2-b12647a1d5c0','','','Icon. pl. japon. 1(4):1.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddec9261-0435-588c-bbe0-53eaa455e366','','','J. Torrey & A. Gray, Fl. N. Amer. 1:64.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cf85643-fb02-52a5-8ca8-adee7f05c5f3','','','Symb. antill. 2:292.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b58d5ac-4579-5c35-8771-f033b29baa12','','','Index sem. hort. petrop. 6:56.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0fa4984-29b3-5502-a2d9-4243ffb56c9a','','','Sag. stor. nat. Chili 132, 161, 330.  1782','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd28b26f-47ee-57b1-916d-f32243a49ef5','','','J. Proc. Roy. Soc. New South Wales 45:288, t. 13.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e37aed34-af1b-5f4c-af7a-57a2389f27b7','','','Acta Phytotax. Sin. 16:73.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27dd4f29-0c37-5111-8964-e8b75882938b','','','Nordic J. Bot. 27:4.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5ca8a8c-4ca0-5c41-93d8-0a7657322e30','','','Enum. pl. 1:190.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94fab08e-b912-5bac-8653-0d070efcdaf7','','','J. Bot. (Morot) 10:310.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e470c1f-d1d7-5ebd-b619-e3d9c8d748e9','','','Bull. Mus. Natl. Hist. Nat. sér. 2, 10:629.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7a4b9bb-e01f-5d0d-ac13-d7a806456b06','','','Tent. fl. abyss. 1:172.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('884af419-5206-54bf-b8e2-2561cb31f20e','','','Gentes Herbarum 7:106.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fcf48fe-8a15-54b2-a95b-8a3127ce9583','','','J. Coll. Sci. Imp. Univ. Tokyo 30(1):125.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37763dae-e308-5cca-a345-d52e156d4d01','','','Orchidaceae 5:176.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcc2e1fe-6d22-5a61-8b2d-38d3283d1d96','','','Ann. Storia Nat. 2:359.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ea99d04-35b7-53b1-b62d-87c797e6bb6f','','','Contr. Gray Herb. 154:26, fig. 1.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e1ebecb-0b17-581b-936c-d781f5d5f271','','','Updated checkl. orchids Vietnam 71.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df833647-b5f8-52d8-915d-7062d22edf61','','','Compos. ind. 59.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbaf9dce-d9fa-5723-9688-1cf9a89d90d7','','','Repert. Spec. Nov. Regni Veg. 15:318.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f877bea0-a565-5b99-9d47-7120355c6b48','','','Not. fl. France 141.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61ed8eb2-d894-5314-8b30-bb76d512b9b9','','','Acta Phytotax. Sin. 26:386.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37364b7d-c9ce-5101-b539-df2a21283f8f','','','C. F. P. von Martius, Fl. bras. 11(1):343.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78748341-e22a-5828-8c6f-69be9924fb35','','','Cat. pl. Pyrenees 102.  1826 (non All. 1785)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ccc0c7e-b3bb-55a9-88b6-823fd5003516','','','Prodr. Fl. Böhmen 3:492.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a594117-92da-5ce0-a816-8b9f195fbf5f','','','Prodr. fl. nepal. 115.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2fad5293-8083-5d32-8085-e289b38af23a','','','Ann. Mag. Nat. Hist. ser. 3, 4:136.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed948417-4f51-5315-b7d3-476db599e71a','','','Bot. Mag. 67: sub t. 3803.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70f1f24e-5fde-5e20-8f6c-fc0e6d6f52db','','','Bot. Mag. (Tokyo) 29:66.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('754eb855-3fa3-5934-9743-db8968ad730a','','','Rep. (Annual) Missouri Bot. Gard. 13:59, t. 28, 29, 83, fig. 10, 93, fig. 1.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f38af191-0482-5191-9c8c-b94dd21d976d','','','Symb. bot. 3:39, t. 55.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3c12b63-d7ce-5e00-bf92-11178942886a','','','Pittonia 1:112.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f996718f-c26b-5ff1-9d7f-b940503f59b9','','','Nuovo Giorn. Bot. Ital. n.s., 16:106.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ada18ef7-cc31-59f2-ae39-de4de22f1949','','','Diagn. pl. orient. ser. 1, 2:86.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f772cd2-c821-5b9b-ad2c-efd2065d1317','','','Fragm. 2:70.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37287f14-9ada-5b9d-9de5-fa778a25c688','','','Rhododendrons 219.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e19d75e8-9948-57e5-868d-aa61dca7ed42','','','K. B. Presl, Reliq. haenk. 1:200.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e31fec67-cb58-5cdb-85ec-e8b36d91fa54','','','Beih. Bot. Centralbl., Abt. 2, 28:226.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e39aa0d3-b8f9-592c-a808-4904d68c5b38','','','Sitzungsber. Ges. Naturf. Freunde Berlin 1868:19.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5af5353-c457-5c87-a929-3571379fd38a','','','Mem. Amer. Acad. Arts ser. 2, 4:58.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21c25dd7-c8c8-5b43-9efa-09e18cfc717b','','','Bull. Herb. Boissier sér. 2, 7:972.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e13d351-0c5d-5cf3-9cf2-6c833e00cd13','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 18:43, in observ.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b518c38c-2c7a-5fd0-a1e9-b3912880d1ed','','','Methodus 349.  1794, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e9919d8-35e7-5708-9dd4-1958ab632462','','','Fl. lapp. 103.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3f5bf82-3b02-5e83-93c3-6b4ae727bd0b','','','Fl. N. Amer. 2:23.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30f6e25e-dd28-5edd-85b4-c41e28403aa3','','','Fl. ind. ed. 1832, 3:516.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdc1332a-4e49-524a-a72e-5cc31a028337','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 5:227.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81000cec-5e44-5fc1-af44-713345eaa7ef','','','Amer. Midl. Naturalist 18:807.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65fd4db8-eb2f-52b9-b87c-eca2140b759d','','','C. Wilkes, U.S. Expl. Exped., Phan. 15:141.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53c4f3a3-779f-51cb-9e15-448698135d8f','','','C. L. Hitchcock et al., Univ. Washington Publ. Biol. 17(4):385.  1959 (Vasc. pl. Pacif. N.W.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70d59e03-43ca-51a2-8572-734fe01727bb','','','Descr. Egypte, Hist. nat. 263.  1813-1814 ("1812")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d877924-979e-50cf-8ee1-b24ab7c79c02','','','Mem. New York Bot. Gard. 65:668.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55e0feb8-2feb-52e9-972d-3f78cf167430','','','Webbia 8:113.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0274280-d881-529e-ba82-6a7a1eb9c5b0','','','Anales Soc. Ci. Argent. 99:97.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48a5c810-e4d6-53ab-8334-478bd92e18c5','','','Brit. fl. gard. 3:54, t. 276.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7710152-f89f-5aef-9c4a-b256ef923740','','','Biol. cent.-amer., Bot. 1:304.  1880, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8607096b-92f1-5c8a-870e-7d065b3773a4','','','C. Gay, Fl. chil. 6:273.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f646648-66be-5297-be93-dd6392732ef4','','','Fl. carol. 159.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('266a2b61-a088-52f1-9631-d1c482241648','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 5(2):547.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95e13be7-f23a-52d6-9f18-9017cc75ee65','','','Pl. hort. schoenbr. 1:55.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f6ad0a2-615e-578d-abbd-0ffece29859b','','','Ann. Bolus Herb. 3:8.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a08b3ed6-3f3c-5906-acf9-a863ec5b06a6','','','Eur. J. Tax. 360:19.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5ba7d24-5119-5f32-8e1e-6b9839393042','','','Cat. Hort. Dorp. 3.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('534511bd-b369-503b-9375-9bd57138f441','','','Tabl. synopt. pl. vasc. France 86.  1894 (J. F. A. P. Gaudin, Fl. helv. 4:507.  1829 "<I>V. cracca tenuifolia</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2153490b-11af-555e-b685-9c085a2f2527','','','Fl. nov.-zel. 1:81, t. 20.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a09e80f-f14c-570c-8ebb-0d0b3725aa04','','','Linnaea 15:170.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11c3be89-71f3-509f-a6c2-6c8b2e01f090','','','Repert. Spec. Nov. Regni Veg. Beih. 1:798.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a88dd008-709b-50d4-a5c8-8a6d82b60017','','','Philipp. J. Sci., C 10:306.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f946fb09-549f-5835-ad87-50c6ac356eb0','','','Hort. berol. 1:137.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f650c53-ca52-54e0-b7f9-ab5f19122eaf','','','Hannover. Mag. 22:132.  1784','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c470a25-e3be-5a84-8d0d-6e668906dfcf','','','Repert. Spec. Nov. Regni Veg. 41:200.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d4d8ffd-2440-5a8f-8868-dad672ebe44d','','','Leafl. Bot. Observ. Crit. 1:206.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1052452c-25b9-5e47-80b1-19516a826154','','','Bot. Gaz. 70:102.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec2664d7-51a4-50e0-8475-b1a1bdf8ca2e','','','Pl. wright. 1:75.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4a80583-7dd0-5c4d-bebe-2a464ea3cbe2','','','J. Linn. Soc., Bot. 48:35.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81fd1b17-6a36-5e5b-8399-c858acc48848','','','Monogr. Comis. Invest. Ci. Prov. Buenos Aires 13:38.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('034fd8a1-5d83-5d88-bd2e-7d174868ac59','','','Fl. helv. 3:245.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('291157e2-1111-5618-a9d7-dd3aaf5b3720','','','Hooker''s J. Bot. Kew Gard. Misc. 3:332.  1851 (non Medikus 1784)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('856578bf-4ba8-57c1-99ff-c5e020f19515','','','Mém. Cl. Sci. Math. Inst. Natl. France 1:17; Choix pl. ad t. 36.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dab867a2-a3ac-5e15-add0-eaea857799e1','','','Rhodora 16:119.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2145c884-2dd9-5ff9-b07c-55e78381e78f','','','Bull. Reale Soc. Tosc. Ortic. 12:17, t. 1-2.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fd26c6a-9947-55cf-a9f0-e6ed44440dca','','','Bull. Jard. Bot. Natl. Belg. 47(3-4):483.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b804be3b-eabb-56a2-bd5b-3920a2064993','','','Occas. Pap. Bernice Pauahi Bishop Mus. 29:106.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92a56a91-931c-584c-b1d2-511ed4e1fa28','','','Reinwardtia 7:53.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49a510f3-ee19-50bc-bd3d-b7573948004d','','','Dendrol. Fl. 43.  1822 (Guimpel et al., Abbild. fremd. Holzart. 25, t. 22.  1821?)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2fcb1ae6-04d1-5f25-9286-c4590dd28745','','','Syn. conif. 151.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea4c0f84-d5b0-583e-8ff5-2ae245516f93','','','Sp. pl. 2:1087.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbe8a6e3-c5fd-593b-9ef2-d51b98f53fc6','','','Symb. antill. 2:453.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85fedae1-9236-5409-bf7d-d48ac0356440','','','Bull. S. Calif. Acad. Sci. 31:64.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc34e1aa-8538-5d60-90ff-dc6467bf1642','','','Diagn. pl. orient. ser. 2, 4:115.  1859 (non G. Don 1827)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0929ff41-567a-52b8-91de-904147884f23','','','H. G. A. Engler, Pflanzenr. IV. 83(Heft 39):76.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('525eb02a-b49a-500f-8a7b-d43b8f4bacbc','','','P. E. Boissier, Diagn. pl. orient. ser. 1, 13:42.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19ba4ec2-e7ea-5371-b342-9f94359e451b','','','Fl. pedem. 1:131.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('491d3226-e35d-5e35-bb84-8375c2aac348','','','Suppl. Duthie''s fl. Upper Gangetic Plain 5:47.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1166cabc-002f-55fe-a773-8a86ab9339e7','','','Sp. pl. 2:1061.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f111bc1d-c951-5d05-a83b-1a0d43af4eb8','','','F. A. Sauvalle, Anales Acad. Ci. Méd. Habana 10:97.  1873 (Fl. cub.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20acb32c-152a-5934-8ecb-eeaf90ca8c7e','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:37[folio]; 3:47[quarto].  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49f695da-2ddd-5a3f-889d-5ee79deaaa8e','','','Ann. K. K. Naturhist. Hofmus. 11:163.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c964ac2-ceeb-57e8-b887-c124eeef8a18','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:111[folio]; 2:140[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0c7cfaf-2bed-5e65-80d0-cdc07905ea8f','','','J. Washington Acad. Sci. 35:285.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b82f0c2-9106-5615-8156-f385251993d0','','','Fruct. sem. pl. 2:219.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('594e8c2d-fcdd-58aa-85b8-66fcdbf37d0e','','','Baileya 13:148.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7647bc9c-890a-5661-a80f-acd0f128a1ff','','','Bol. Soc. Argent. Bot. 14:330, fig. 1, 2.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d73a6ec9-a516-512b-8fa3-865eaf1b3593','','','Bull. Torrey Bot. Club 28:22.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb0c40e9-5e9e-5175-8b92-f64018496a66','','','Fl. Iranica 66:197.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d4bfbfd-9b32-5129-810d-2add4bdddc8e','','','Trans. Linn. Soc. London 2:83, t. 16.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c3ac0a1-f715-59d8-901f-477d933eeb25','','','Sert. angl. 28.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3773c617-892b-5f3f-9a37-e09629517712','','','New Man. Bot. Centr. Rocky Mt. 146.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('731b984d-684a-5363-bc9a-0dce171fdafe','','','Phytologia Mem. 7:44.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3de1603f-12db-5e4e-95cd-3114038e2d0d','','','Pittonia 2:239.  1892 "<I>Pentstemon</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5f15dc3-e489-54d4-b299-7320051e9a1e','','','J. G. Boerlage, Icon. bogor. 3:187, t. 271.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad85207a-09de-5f2e-ba21-01e5511da3cd','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(3):132.  1846 "<I>hispidum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7e981be-9519-53c7-bf24-86d384b802db','','','Bot. Gaz. 63:404.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c342a90-0687-518e-8c9d-0b2258dfd9b4','','','Biblioth. Bot. 26(Heft 106):21, 25.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30da1a4a-44e9-54dc-b258-508378774e46','','','Bull. Torrey Bot. Club 69:305.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('671ea65c-7bbb-541f-b914-a2550232a9f5','','','Proc. Amer. Acad. Arts 71:66.  1936; Contr. Gray Herb. 112:66.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36723dc4-f469-5ffd-a912-2ef4e36d97ee','','','Contr. Gray Herb. 81:81.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9f36f8d-e2e0-5c22-990b-61d37e320769','','','Reliq. haenk. 1:172.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a88356a9-c3f2-57c7-9f0a-b5d4ac1cac83','','','Fl. atlant. 2:360.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be0cc679-ee36-5b9e-b827-cf64f951082a','','','PhytoKeys 144:74.  2020','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a135aacf-6ca0-5fb0-8cb3-c5a0628d5ea0','','','Legum. Caatinga 128.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acf98554-cda7-5697-b661-35ca3096f755','','','Flora 21(2, Beibl.):74.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b8e6b27-21b2-580e-8e62-4bb4147783f5','','','Geraniaceae 2: t. 118.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7f75813-74e3-5df8-ac68-b071dc86ca13','','','Texas Agric. Exp. Sta., Bull. 39:829.  1896, pro syn.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('749a5c06-83d2-5cb6-8924-39f7bc09b07d','','','N. Amer. fl. 25:140.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a75dd42-ba3f-59f6-b988-bfa472ca62e6','','','J. Bot. 72:341.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c7c1969-29ca-530c-ba73-8638449a9255','','','Flora 28:500.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f165cb63-2ce3-520a-8a5e-88b59221eb71','','','Contr. Gray Herb. 200:46.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c80f8aa-4f7c-5722-8c39-26d58aa135b2','','','Monogr. Pulmon. 36.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ce110f5-03f6-57fe-b715-22b3dff04eaa','','','Fl. ind. 1:433.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84256651-8a6e-53ef-be19-cf30d4d951df','','','Sp. pl. 4(2):765.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('899e6476-b368-552d-ad0d-e4f688bda7c5','','','Prelim. rep. surv. Texas 1.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0dffbd71-e669-50e9-ba28-2df37509f80f','','','Repert. Spec. Nov. Regni Veg. 28:8.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f758d2f8-b4f7-5d37-b18c-64f8213b14ff','','','Brittonia 30:158.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10656b72-71dc-5771-99f0-0a62a4a4a63e','','','Trudy Prikl. Bot. Prilož. 38:260.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff8f49e0-55b8-5764-9da4-e7e9bb299e5a','','','Gattung <I>Frailea</I> 133.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6071ec60-89a5-5272-8171-2a9038762115','','','Fl. atacam. 24; Viage al desierto de Atacama 198.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3e383b9-0107-5d92-abd6-1dc27f611350','','','Rev. fl. Spa 115.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77120b8d-d55f-54ff-814f-aa6689342081','','','Trans. Amer. Philos. Soc. ser. 2, 7:307.  1840 "<I>caespitosum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55a6d9f7-fd50-583c-a7ca-015fd4ed3f69','','','J. D. Hooker, Fl. nov.-zel. 1:164.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46d42508-c402-56c3-b375-c924e5f82c1c','','','Trans. Linn. Soc. London 3:260.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4387da8-a97d-5491-8f38-23089e834e27','','','J. Sibthorp & J. E. Smith, Fl. Graec. prodr. 2:263.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('403b3569-ea24-5322-bb3e-74ec2ce21e28','','','Acta Phytotax. Sin. 6:128.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('044145d0-5820-503c-bb70-81b7810db324','','','Bull. Jard. Bot. Buitenzorg sér. 2, 8:24.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbd1c052-1356-5976-a061-c579eb4afbdb','','','Ann. Sci. Nat., Bot. sér. 4, 1:76.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f676c123-ac2d-5e47-ae59-b94b41e9cf1a','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 3:439.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5436b131-3f98-5f9f-8b41-22a6a12487b8','','','Boll. Reale Orto Bot. Palermo n.s. 1:App. 273.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4128ea04-64b0-5b0b-9729-cdb5307d38e5','','','Fl. Japan 658; Bull. Natl. Hist. Mus. Tokyo 33:76.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ccf61cc-29a6-5eaa-b82a-9c20a6de9c2b','','','Cat. arbor. zesch. 26.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f97edce-4471-589f-8780-77f765718565','','','W. A. Silveus, Texas grass. 737.  1933 (A. S. Hitchcock, Amer. J. Bot. 21:139.  1934)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0e0cdd1-0714-50f7-ad77-39d37d08ab36','','','Trees shrubs hardy Brit. Isles 1:278.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b5d019c-4f6c-5092-b169-4f812cfef494','','','Hort. brit. ed. 1:170.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7829dd2-aa0f-52a5-aa4e-ae53ba755ca4','','','Bot. Jahrb. Syst. 29:323.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50251bf5-2fa0-584c-ac2f-52db4dc4add7','','','Nuytsia 4:53.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94d19790-f15a-56a9-82a7-75b1682e3ef9','','','Hort. bot. hafn. 2:613.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ab49e07-89fb-5282-ad18-55780fdb019d','','','J. A. Murray, Syst. veg. ed. 14:602.  1784 May-Jun (Fl. jap. 262.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b910c42-99d9-5d19-9272-940ed43993b4','','','Bot. Gaz. 62:145.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d927060-6b75-5935-bf71-fab955490459','','','Proc. Biol. Soc. Washington 40:84.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('167a7720-d367-5b5c-a22c-6d31d2a01531','','','Fl. Turkey 4:491.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c28e7c8-caea-5959-bc7a-4be91627c7d0','','','Gard. Companion Florists'' Guide 1:122.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c512b7c9-6254-5573-ae8a-f27e0ed06176','','','Bot. Jahrb. Syst. 26:391.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c646d24-d91e-55be-9748-7307ac8d8c9a','','','Cruciferae cont. N. Amer. 482.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db3555a0-e747-52fd-a6d1-fd869483b38c','','','Univ. Washington Publ. Biol. 13:40.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95dc8a53-daed-5ded-9b34-a621678aa355','','','Key Eucalypts 164.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb4b0857-2965-50fd-900c-1faa230013a8','','','Rhodora 95(883/884):399.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a49ee025-c781-59c3-a02c-234169d19c2f','','','Selbyana 5:373.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a663713-0eb1-5380-a179-0d3096f0927f','','','Prodr. 5:641.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2a3d8e2-7f3b-559d-bfed-1f30e69922a3','','','Sp. astragal. 11.  1800-1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cea575a-d0d3-58bd-bc5c-891af189af61','','','P. R. Reitz, Fl. ilustr. catarin. 1. Begoniác. 35, t. 10.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f5b5460-7a23-5b36-9f3e-36f11a2efa39','','','J. Bot. 40:284.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1462b397-5962-5294-bc3f-e97272ff8a00','','','Pacif. Railr. Rep. 6(3):87, t. 16.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a6574b5-55ef-5e39-ae9b-41cc3aad7955','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 62:256.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('401272db-e752-5ef6-bf7f-e80de747c1e5','','','Sp. pl. 2:721.  1753, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7e9c93c-f3b1-5a97-9022-5d50d959575f','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 2:316.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f759a15c-720c-5a8f-a243-3be0e8c0030a','','','Kew Bull. 1957:261.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72cfdf3e-c232-53f2-8088-660e72249135','','','P. B. Webb & S. Berthelot, Hist. nat. Iles Canaries 3(2,2):262.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5db201f-02a1-591e-b0d4-00b61c9ceb98','','','Bijdr. 1101.  Oct 1826-Nov 1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d43a1f8-49ea-52e0-9390-9040cbb317fc','','','Kew Bull. 55:89.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1588e243-109a-52df-ac72-0457fd469f83','','','Repert. Spec. Nov. Regni Veg. 27:280.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80b69f5a-743b-5e7f-9bf0-183b01225352','','','Lazaroa 8:57.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2223737c-2fb1-5e05-bff5-21d1cf73819e','','','Vict. Naturalist 60:175.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3612a5a-954e-5024-9720-05bc52c11d63','','','Proc. Roy. Hort. Soc. London 3:364.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da74d948-9ca5-5ad4-8f5f-1484286cee7a','','','Gen. N. Amer. pl. 1:23.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78cd754e-1237-55e3-a691-80bded7349ee','','','J. H. Maiden, Crit. revis. Eucalyptus 8:38.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d86098e-aafe-58cf-b2c1-e64bfb27e7cd','','','Spisok Rast. Gerb. Fl. SSSR Bot. Inst. Vsesoyuzn. Akad. Nauk 8:83.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('791a1f96-4fb9-5e5c-8140-ec19496126bd','','','Field & Lab. 21:157.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79369579-43b6-5141-a7d7-30e808deef6b','','','Mém. Soc. Linn. Paris 6(3):224.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5418e20-951f-5f90-88b8-b28287f26634','','','Repert. Spec. Nov. Regni Veg. Beih. 30(1):247.  1924 (Prodr. fl. penins. Balcan.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('870b4777-bdc8-5c9d-8349-eed36f949e32','','','Hedrick, Veg. of New York 1(2):11.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce582353-95ce-5567-bdca-958ad43904f7','','','Pittonia 2:148.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b716f000-30b1-5b74-ad57-11fd97157cdf','','','J. S. Presl & C. Presl, Delic. prag. 59.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79a0949c-2e01-5bc5-9c83-ca7e25764aee','','','Bot. Mag. (Tokyo) 23:188.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d0f3286-71bc-5217-b830-4df3ef369764','','','Pl. asiat. rar. 3:67, t. 289.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('766c9dec-b299-5e74-9bb4-392e7fa30016','','','J. Proc. Linn. Soc., Bot. 3:85.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4a757df-a3bd-51ca-b653-4d418820097e','','','Caldasia 2:67.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('904ffbf1-c26a-5bd4-a309-bf8742cb5499','','','Invent. Seeds U.S.D.A. Bur. Pl. Industr. 31:68.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4ed222b-db38-50aa-91d2-6431ce869ade','','','J. Jap. Bot. 31:59.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3db3976d-343e-53d5-9b73-8b4b7aa9bec6','','','Fl. Sard. comp. 72.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6e9f0dd-f4e7-53fd-982d-54a9001188f1','','','Ann. Sci. Nat., Bot. sér. 2, 18:31.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b38e8afb-5a82-5886-90c1-772edde3e87b','','','Syn. pl. glumac. 1:347.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c602fa3-0fbf-554b-a8ac-979ac62f5b0f','','','Trudy Tiflissk. Bot. Inst. 1:113.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ba42914-9715-5b2d-b245-6c50e25db190','','','Ill. Hort. 19:3,  t. 88.  1872 "<I>lindeni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5bd99f5-6517-5154-a23e-53a3fda79f73','','','Fl. n. middle United States 47.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d80d30c-5458-5ea3-b68f-e8944805af0d','','','Bull. Cl. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 10:340.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2d27d9f-dc84-5cd1-ac18-749f8871018d','','','Bol. Soc. Argent. Bot. 26:243, fig. 1.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86361222-4724-5508-b980-20b461959611','','','Rodriguésia 20:165.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b26e3125-cead-5cbf-91f7-6b634466c679','','','Gard. Chron. ser. 3, 5:553.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8dd1c16-b07b-5bf5-937a-ef42e72e7180','','','Bol. Soc. Aragonesa Ci. Nat. 15:95.  1916, pro. syn.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('261808c2-574d-56de-92b2-af7aac605667','','','Species lupinorum 44:768.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a91068cc-e318-5995-adab-2600ece0918c','','','Cactus (Paris) 38:250.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad95acd3-936a-5f7f-adbe-35c23680e390','','','Icon. pl. Ind. orient. 5(2):29, t. 1907.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfec8370-9433-567a-802f-2fdbec687e4c','','','Fl. orient. 4:585.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be02f8f6-7afd-5d75-a52d-7b52c97d1262','','','Rumphia 3:110.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c43511e7-7026-55b3-8db0-dc5e4384925b','','','Arch. Jard. Bot. Rio de Janeiro 3:76, t. 4.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('207d782e-e022-56ea-873c-9ec7655c2f88','','','Fl. columb. 1:129.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a585efbf-4d30-5e0d-b8b6-ecbd815f7691','','','F. W. Andrews, Fl. pl. Anglo-Egypt. Sudan 3:62.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('946e4ec4-9a59-5c8e-8482-fafec4722652','','','M. Keraudren-Aymonin & G. Aymonin, Fl. Madag. Comores, fam. 144:100.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7daa4286-b76a-58a7-bfcc-9328d088785e','','','Contr. Gray Herb. 49:42.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce486b73-9d76-50d7-94a5-6c7efc5a6fb2','','','Notizbl. Bot. Gart. Berlin-Dahlem 15:436.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc37a53a-5eb2-55c5-a36f-938ebe02eebf','','','Kew Bull. 42:905.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7680e661-a6a3-5798-9bb4-65b297d2b227','','','Ess. Agrostogr. 53, 161, 171.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b418f966-8ecf-5116-b941-e69fc0ebc6b2','','','Enum. syst. pl. 18.  1760 "<I>brownii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31591e15-ebaf-5db5-8dc2-68be68bf0e5f','','','Flora 55:42.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de6b209c-4ed9-5a5a-85d3-327f13b93559','','','Bull. Misc. Inform. Kew 1901:120.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48758428-fd95-5a99-9482-ddf75affe30d','','','J. Linn. Soc., Bot. 45:167.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('187289c8-90dd-5fa1-bdf9-90962e6004c5','','','Consp. fl. Asiae Mediae 2:138.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c41cedba-7b92-5759-8a76-b3e048919a3a','','','A. Cronquist et al., Intermountain fl. 4:539.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f0ed701-fcaa-5870-96c8-49403d4211a7','','','Syn. fl. N. Amer. ed. 2, 2(1):446.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a369998-0cec-51da-8668-9e30224fe62f','','','Fl. Antarct. 1:383.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('350785b2-bcc1-5393-9f35-004b1413e48d','','','Pl. hartw. 173.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acee1447-68d3-5e5d-a126-db15bd21ea11','','','R. Mansfeld, Verz. Landwirtsch. u. Gartn. Kulturpfl., Auf. 2, ed. J. Schultze-Motel, 1:302.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04188345-ec33-581b-ac09-906b3aa96740','','','Cat. N. Amer. pl. ed. 3:17.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fafa9943-b2aa-5812-9496-e7b72666b0df','','','Orchid Digest 57:35.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87283f56-ef8d-53dc-bc09-d9a71fab2571','','','Fl. australas.  t. 13.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13257254-78de-581f-ab6f-305e541350bb','','','Bot. Mag. 42: t. 1761.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87124071-3f02-5dc4-9c32-b70aa09e6d6e','','','M. M. A. Lesson & A. Richard in J. S. C. Dumont d''Urville, Voy. Astrolabe 1:336, t. 37.  1832 (Ess. fl. Nouv.-Zél.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff19b239-6219-53a4-8471-7372f9383e30','','','S. Sci. Rec. 2:149.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2eeae83-b485-58f6-8c35-bd1b88d46a4f','','','W. H. Harvey & O. W. Sonder, Fl. cap. 1:523.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08a38370-5d99-53f1-a625-a604c606ea69','','','Tea Sci. Res. J. (China) 1983:11.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('315b95dd-e775-5a38-9b51-4889ab366f48','','','Mem. Torrey Bot. Club 3(3):26.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a41ce20-0ffd-5792-a313-92b2512da604','','','Pl. hartw. 131.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('503a490d-9642-5b7b-8f7f-0364c9f80ea3','','','Verh. Bot. Vereins Prov. Brandenburg 30:167.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46f7ec72-bee5-566e-9097-d4790b035e29','','','Selbyana 5:334.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98be64cf-3411-592f-9ec2-c8f915e2db6f','','','Madroño 6:186.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d8e883e-49c1-5d4a-8903-ea58dd715ff4','','','J. Bot. Agric. 3:173.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e43eaef-65b3-57a6-8a78-67fba7c115ef','','','Mitt. Deutsch. Dendrol. Ges. 24:222.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06940fd0-0d1b-5270-b86d-ae2dbdaf5044','','','Repert. Spec. Nov. Regni Veg. 27:132.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36265e0e-78a9-537b-9cfc-ab17f10a76d9','','','J. Jap. Bot. 9:249.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8f875d9-d1cb-581d-91ff-96890fe71e42','','','Contr. Univ. Michigan Herb. 19:46.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef799f98-ab70-5900-9216-9010cedf5fff','','','Skr. Naturhist.-Selsk. 6:460.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c85efab-13e2-502e-9ced-3bd059df5145','','','D. Prain, Fl. trop. Afr. 9:285.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4cbe2df-75a5-5c3c-972e-5e73dd893f8b','','','N. L. Britton, Fl. Bermuda 256.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85b9635c-544c-5d5a-8f0c-ef3c981ee2a3','','','Cult. Prot. 93.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96000cdb-79ad-54c4-9e73-8c3b7ffbbcea','','','Taylor, Ann. Nat. Hist. 3:432.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11ca1193-526d-5a6a-bc8d-9a4d99005d5d','','','Gen. pl. 3:352.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f340b05-f120-5150-b079-0424d654227f','','','Neodiversity 5:11.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cd5395b-93fe-5abf-bc00-497fb6ae9aa6','','','C. A. M. Lindman, Sv. fanerogamfl. 97.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76a47204-4261-5aa6-a538-09f836bc6d79','','','Sp. pl. 4(2):1065.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09e4c245-1a8b-5c30-ba72-9d5e3154ada7','','','Syst. veg. 1:21, 563.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('086d7719-784b-58f1-bbe8-4dd29ffbee7b','','','Syst. veg. fl. peruv. chil. 137.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d485935a-4a7b-5e7f-a542-32c96dd5a917','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 26:80.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('237109fd-d8fd-5184-9afb-5537486dc860','','','Bot. Jahrb. Syst. 41:361.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d876370a-b734-5ddb-80cf-ad80e9d5a8e1','','','Fl. atlant. 1:346.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78520186-7ea2-518f-a8b2-74e6fab38619','','','Biol. cent.-amer., Bot. 2:196.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54317813-b1e0-5bb5-9eea-884dba3bde9c','','','Vég. util. Afr. trop. franç. 9:270, 443, t. 21.  1917 (Bois du Gabon)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13025cd3-531c-5223-b576-9e052d1e799a','','','Gard. dict. ed. 8: <I>Cassia</I> no. 5.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f81a17f-96bc-5436-9053-2973fa919415','','','Jahreskat. Wiener Bot. Tauschvereins 1904:226.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69ba1ece-42e0-5f94-8be1-107add25d194','','','Sp. pl. ed. 2, 2:1261.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a921433-24b1-516e-a3f2-3460d8e8e500','','','Amer. J. Sci. Arts ser. 2, 22:285.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f85ad8c7-7e59-5b39-afb3-cecb8fe22c79','','','Bull. Soc. Imp. Naturalistes Moscou 5:191.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10bd39a4-9b01-5683-96bb-c669924ca115','','','Kew Bull. 15:356.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea224800-0508-5570-b9f1-4da37d505566','','','Mem. Tokyo Univ. Agric. 32:80.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('185de49d-fbcd-5aba-a9bc-9b1144bb686e','','','S. African J. Sci. 27:337.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('973a88cb-126d-5f21-a1a2-251e6648605e','','','J. C. Loudon, Hort. brit. ed. 1:309.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('639e990c-5b93-5763-a87a-6dd401aa4ee3','','','Gard. Chron. ser. 2, 14:198.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcb276cc-c7ca-591d-a54a-038ce405da1f','','','Sp. pl. 2:1103.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b0ae1f2-ccd0-5be5-8367-3ac28da87582','','','Hort. brit. ed. 1:481.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a658ce3-6748-55b9-9ed2-bba68c6f8396','','','Giorn. Sci. Lett. Accad. Ital. Sci. 1:48.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f592c5ad-637b-580f-a4b4-7970635e5dce','','','Syn. Brit. fl. 94.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7f8167d-29a6-55ff-bfaa-a6a102242bbd','','','Bothalia 7:454.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03385eec-24f0-59bf-a69a-ed5f83e2d2ad','','','Blumea 51:55.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('925bfb8d-e7e0-5379-b529-65db7c3a4b29','','','Kew Bull. 1950:364.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0805a074-417e-5d57-90a6-908907586d4e','','','Fl. lusit. 2:167.  1805  "<I>cymbaecarpos</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d71e77c-6b4c-5cea-ba37-d68bc0e524e9','','','Fl. Bras. merid. 1:387.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9644e381-dc4e-56bb-bd1c-2f2847885258','','','C. S. Sargent, Trees & shrubs 1:129, t. 65.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b587a4f4-f53c-52a9-bb9e-f7990c621ccd','','','Fruct. sem. pl. 2:317, t. 148, fig. 4.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52a6cc51-2d03-59b5-a09c-def006d92ff1','','','Syst. nat. 2:584.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47ecd5b1-9d26-5c66-8345-5d8da739cdef','','','Enum. pl. 2:288.  1805 "<I>aestivale</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e8109aa-24dd-5b58-8d22-70b85d7c3886','','','Repert. Spec. Nov. Regni Veg. 14:311.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('843b2c4d-0516-588f-a3f8-f4f1cc0c4150','','','Linnaea 23:740.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('911aabbc-df78-5369-b994-12a3eb6fe2cb','','','Gentes Herbarum 9:252.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9506740a-f252-5c7f-9f36-5bb9a8e5eff5','','','Fl. Neotrop. Monogr. 8:52.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3be416f8-d5ac-5d50-aed1-578b21465257','','','Abh. Königl. Ges. Wiss. Göttingen 19:47.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('833f8ccd-4754-5108-ab15-a8c382871403','','','Anales Soc. Ci. Argent. 5:209; Contr. fl. Paraguay 58.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d96ca080-7b7d-5ef9-adb4-5fefb8ca3b31','','','Fl. zambes. 4:522.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26e33eaf-44a8-5eb3-847b-6ab162a09956','','','Beih. Bot. Centralbl., Abt. 2, 39(2):5.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('896076de-29cb-53e4-a30d-142d46714728','','','Gen. Cass. syn. 39.  1837; Linnaea 11:648.  1837-1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('416a6290-8de6-5496-a552-92fa29b02827','','','Linnaea 25:464.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('102db7f9-87cf-5b73-a19d-ead3d7f5a4ff','','','Gard. dict. ed. 8: <I>Angelica</I> no. 1.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ee302ef-7ec3-5f7a-bac4-dae471f8d598','','','Pl. Coromandel 1:43, t. 58.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef5a69db-872a-5606-9b0b-ccae693115d6','','','Syst. veg. 7(1):549.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acc236b0-9eb0-5231-a7eb-b1a11754ceb6','','','Monogr. gen. <I>Toona</I> (Meliac.) 78.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00da89c6-9fce-54e2-8d74-bdd4c7c1fae2','','','J. Bot. 36:98.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29315019-dff5-5b0c-b5b8-b960cb730538','','','Symb. bot. 1:64, t. 41.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0279732-570f-5ee5-bf47-659e410e4828','','','Adansonia sér. 3, 22:170.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af7b65a0-713f-52f7-8204-e64989a80027','','','Sp. nov. min. cogn. 1852:2.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9c1f49c-a2ee-527d-8006-a8a0e3646970','','','J. K. Small, Fl. s.e. U.S. 66, 1326.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe078550-4d83-50bd-973a-1b09e871d601','','','Rev. Hort. (Paris) sér. 2, 4:240.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5b62078-f792-5142-8533-1a32fe3ca7b7','','','Smithsonian Misc. Collect. 68(5):5.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd9df228-fc07-5a8a-a5a1-30e0fc4fd786','','','Bot. Mag. 98: t. 5975.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f8083bb-1f38-59b2-9e30-eeb751442972','','','Notes Roy. Bot. Gard. Edinburgh 39:372.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('432db264-4404-581e-9109-43b63d185d0b','','','A. L. P. P. de Candolle, Prodr. 12:124.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b95f1db1-355e-5ea2-9c87-badef9ae1e4d','','','Fl. Afr. austral. ill. 27.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c6862b9-e275-53e1-9b5b-ca40e2d09346','','','Gard. Chron. ser. 3, 70:336.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c204afe7-99df-56a6-a3cb-10d8c9826185','','','Bull. Misc. Inform. Kew 1932:406.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5317b1e5-41c8-5e7f-8b3e-6e0b0ff2ae0d','','','Fl. E. Himalaya 3:78.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3051aab4-74ff-5d52-8136-c4483c4e313b','','','Mém. Soc. Agric. Angers 1:177.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2acc25a2-b80e-5ba6-bdd8-3e9b3f78af0d','','','Sunyatsenia 7:70.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('020804e8-a33a-59ba-adbe-ec1dd20d7e3a','','','Allg. Gartenzeitung 18:161.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33785b82-2fbd-5c9c-931d-94cb7fc81d34','','','Voy. bot. Espagne 2:490, t. 139B.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24f35b09-336e-5f56-afed-953d3e218e3b','','','F. W. H. A. von Humboldt & A. J. A. Bonpland, Monogr. Melast. 1:3, t. 7.  1807 "<I>caudata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f10b811-b314-5ee5-8b16-2212cc8381d6','','','Spisok Rast. Gerb. Russk. Fl. Bot. Muz. Imp. Akad. Nauk 6:128.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('080ea48d-2667-5e94-b62e-fe1ab658c8bb','','','Bull. Div. Agrostol. U.S.D.A. 11:46.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45804c49-5377-5123-bf7c-16e5d4d007de','','','Oesterr. Bot. Z. 47:408.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c568ecb-06f2-5c23-a3a7-5357c2e23a36','','','Mazama 1:196.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f7c94a6-8fcc-5fad-873b-2b8cdbf00a65','','','Repert. Spec. Nov. Regni Veg. Beih. 1:866.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddd91a69-6d6b-5540-b949-f6810a6b673e','','','J. Bot. 2:339.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cef70e2-eaec-5cdc-9db0-fbe68cbdc9da','','','Bull. Torrey Bot. Club 35:69.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5512c82b-ca31-5006-88cb-fedef92565e3','','','Erythea 1:123.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6eddf413-12e7-522f-a0da-74b0f3770b19','','','Trans. & Proc. New Zealand Inst. 53:364.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43fc2677-cf1d-5018-bec9-91682505f4ab','','','Sida 16:572.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('597c2cba-e89b-5e5d-b4c0-f4bf0c34cf19','','','Telopea 4:258.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('feb3b6bd-6ae2-5c38-b0c7-479d6af646f7','','','Phytoneuron 2011-28:5.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e23c64a-f162-5ac1-8f88-d2d22f8dc8dc','','','Brittonia 36:59.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e891220f-9d57-5f4d-8f8a-4be574b948ed','','','Fl. peruv. 2:17.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a80db834-bebb-5feb-9d34-d80b1cda901b','','','J. A. Murray, Syst. veg. ed. 14:57.  1784 May-Jun (Fl. jap. 19, t. 3.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10a017e5-8f93-5722-9502-688d62d1f520','','','Sp. pl. ed. 2, 1:16.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8905fa74-2ffe-5487-b58f-ba6f224fcb00','','','Mém. Mus. Hist. Nat. 7:377.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcf67ef2-da35-54e2-b399-eb60f39c26ba','','','Izv. Glavn. Bot. Sada S.S.S.R. 25:69, fig. 4.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fbba3f6-3fb5-5151-80c8-b89c3b34375a','','','Bonplandia 10:192.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8e02965-8817-55a7-aca2-f47334d117cf','','','Gard. Year Book 1865:39.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fb19cfc-c0c2-531b-94a8-a9c28f5e46a8','','','J. Bot. 79(suppl.):24.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f69c2c6-c36f-578c-8eef-4b6159139f3a','','','Nov. pl. sp. 234.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a64804d9-b897-5ba2-af34-afb3860bbaf7','','','C. F. von Ledebour, Fl. ross. 4:384.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('330f3948-d5e4-5c87-8e85-07958c57afe7','','','Bot. Jahrb. Syst. 46:129.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('902e9f47-08db-59c4-83a7-711d69a036dc','','','Fragm. 5:154.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7564e31d-8258-5ec9-95b0-086b0039a87e','','','Kew Bull. 77:899.  2022','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9e25785-09cb-5e18-b579-da4297963f4a','','','Blumenbachia 48.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02fa4a97-f77b-5979-b7c5-639b7861696e','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 2:376.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2ffd7d2-4497-5a77-bb08-3141f4e325f3','','','I. Urban, Symb. antill. 1:275.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9880a47f-d9b4-505a-a072-bbd71689f5fe','','','Proc. Acad. Nat. Sci. Philadelphia 1885[37]:44.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9d00a4a-ab14-5965-a5d9-286e93af7ce1','','','Bull. Misc. Inform. Kew 1907:412.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12ebc3b6-9706-5677-825f-380dd6642bbc','','','Prodr. 10:43.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82fa19f0-b60a-55d6-9928-bfb0bf1244b1','','','Bijdr. 908.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bd70804-a56e-5a81-b954-c97b3970001d','','','C. F. P. von Martius, Fl. bras. 6(6):196.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13037ee3-738b-55f7-ab14-ed81af463991','','','Bothalia 3:151.  1930 (non A. Camus 1927)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ffa51ee-90aa-5222-9806-842bfb168525','','','Torreya 34:7.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a711039f-312a-55d6-9d58-b01c02cd6fb9','','','Sp. pl. 2:630.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66b540d7-04f3-597e-a109-18f398dbffa7','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 7:95, 96, t. 12.  1884  (Pl. david. 1:285.  1884)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c1829fe-500a-5937-86fd-3e0073ff8c65','','','Madroño 32:49, fig. 1.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a91eadc7-6424-50af-904a-fa44774c3872','','','A. L. P. P. de Candolle, Prodr. 16(2):449.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ad44b54-a4ad-5f00-a678-49602b45e866','','','Gen. N. Amer. pl. 1:146.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35e56c59-4652-59e8-9cac-a9fe160ba1a1','','','Bull. Mus. Natl. Hist. Nat., B, Adansonia 12:240.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ebf4440-6aec-56ef-9704-f8bdd820406f','','','Revista Argent. Agron. 11:94.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1e94fd1-71ee-53a0-a611-1ecb69cf7d71','','','Eclog. Amer. 2:49.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2107016-5174-516b-8dc3-2cb4e37e682e','','','Gram. bonaer. ed. 5, 120.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c90ce75-b7b4-5516-9432-75de120b0140','','','Trudy Bot. Muz. Imp. Akad. Nauk 14:133.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f17c2b75-6de5-5e15-ace8-2fcf3909869f','','','Taxon 48:58.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04bc36dd-8fc1-563f-a2b1-0430c8ecb675','','','Bull. Torrey Bot. Club 57:613.  1931 ("1930")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d57cfa8-4ece-51a8-a5d4-d258f97eda76','','','Fl. N. Amer. 2:239.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a2a6760-988f-5f47-8830-0f1c6d1aa5a8','','','S. Watson et al., Bot. California 2:428.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11b0bea7-2789-5578-abf3-be140c7acca5','','','Fl. cochinch. 1:70.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfc293f2-6aba-5b6b-8d3b-065c3f43fab5','','','Notes Roy. Bot. Gard. Edinburgh 13:302.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a29b1739-f9fb-5ad6-a9c4-fd17e844b09f','','','Oesterr. Bot. Z. 19:325.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f54aacd6-37b6-5cea-a7b8-eae9e8dd3cc5','','','Sp. pl. 1:339.  1753 "<I>maritimum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('428e10ae-2ae5-5712-9161-7ac5e8ef0eda','','','Ann. Missouri Bot. Gard. 30:47.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c26fc961-77f8-5290-b28f-cbc5337351a2','','','Novon 9:282.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e244dd6c-9437-577f-8d64-98f9dad8acda','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 22:377.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0e79569-947b-5473-b9b0-b26760011f7d','','','Fl. ind. 2:475.  1824 Mar-June','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7202cf48-000d-5d56-9f46-7ea776c8cd46','','','Sp. pl. 1:389.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('595babff-3377-573d-a4cc-3f123fa0f0bf','','','Repert. Spec. Nov. Regni Veg. Beih. 30(1):246.  1924 (Prodr. fl. penins. Balcan.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b4fafee-d393-5c49-ab61-f38a14308535','','','J. Bot. 13:225.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a53e7aa7-2405-59fd-be40-36e062441676','','','Legumes Bahia 162.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fef516af-55f1-5ed4-869e-272002ef1691','','','Bot. Gaz. 37:272.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fd160b2-4ee6-5bf6-9dad-92804081b321','','','Mem. New York Bot. Gard. 108:200.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('190b052d-7564-5618-b552-515e8238e194','','','Syst. veg. 1:313.  1824 ("1825")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3109c544-fc01-50b1-8cc3-9ec2f2e58d70','','','Prodr. 1:456.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd9de48c-8d7b-5cfb-8b4e-f712dd50bcfb','','','Contr. Gray Herb. 211:110.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('375462ae-254e-5ca8-be36-fb8f08758aed','','','H. G. A. Engler, Pflanzenr. IV. 147. V(Heft 52):221.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f863c8ae-c28f-58bc-b3f2-bc529ae168e9','','','Occas. Pap. Bernice Pauahi Bishop Mus. 16:66.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7f57f9c-d998-5738-8a21-af7375e04427','','','Gesamtbeschr. Kakt. 752.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a88a68df-da10-5050-a0fd-13b8a06f0e94','','','Fl. ind. ed. 1832, 3:393.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6a9d25f-af4c-5ba5-9533-022dc02c20ef','','','Voy. bot. Espagne 2:665.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26aaf0a4-2d54-526a-9fdc-60c9bda80e8e','','','Pittonia 1:157.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d45332a-bf57-5195-8b88-5b808fa99813','','','Hist. nat. palm. 3:242.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d504d494-9fd7-5892-97e3-e56a8f360887','','','D. Prain, Fl. trop. Afr. 9:134.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('326cfdd7-366f-5a01-8cbd-ff21c215d749','','','Bull. S. Calif. Acad. Sci. 48:105, fig. 13, 14, 16.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8009b1bb-2e4e-5380-8d6a-0e64e692ec58','','','Zoë 3:296.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f12ae4b8-626f-5df1-a0c4-4c46e742b104','','','Bull. Torrey Bot. Club 34:434.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa951e17-ed03-570f-a749-98077929db26','','','Proc. Roy. Soc. Queensland 1:89.  1884 "<I>bowkettae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a73b2547-bd4d-5c14-a9b5-a5f9546f8e6c','','','Syn. pl. 2:424.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd7f1248-7a66-567c-968f-4ec5e60c4bff','','','Bull. Misc. Inform. Kew 1910:360.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd3289c9-fcd3-5061-9453-4c83fb76a6c8','','','Arch. Mus. Hist. Nat. 8:416.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd8b13c5-fcda-589a-9824-dc79d04ccaa6','','','Icon. pict. pl. rar. t. 16.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a98d195-b4d9-5de4-8f25-64393c3515ec','','','J. Arnold Arbor. 20:431.  1939 (Man. cult. pl. ed. 2:850.  1940)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7c854a7-27e6-5791-bca3-08414c126644','','','Descr. S. Amer. pl. 64.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06286f45-6a14-515e-bbf0-c7f4da7678f5','','','Phytologia 70:220.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b4c2339-2a5c-5069-97c6-edc313b22487','','','Bol. Soc. Brot. 6:68.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2865b90b-688b-55f4-a715-604c6d6d0ca9','','','Voy. bot. Espagne 2:525.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b362b8a-4989-501d-b2a0-7689bdaf9f6f','','','Phytologia 7:172.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8dc3826d-85c0-5df5-93b9-7f8ba58b1e0e','','','Bol. Soc. Brot. sér. 2, 42:167.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4dfb10a-8317-5f37-916f-770de3a8517b','','','Gen. hist. 4:211.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fea0aac0-21c3-501d-aabb-3852f8589c06','','','Trans. Amer. Philos. Soc. ser. 2, 7:287.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da9f6391-a359-52ff-8ba0-4f3127fc4524','','','Bot. Jahrb. Syst. 48:17, figs. 1-8.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cd114f5-80d8-5126-9ba2-972de08a5977','','','Gen. hist. 2:215.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d186ebc-a153-5b33-bd54-65210d23bc55','','','Indian Forester 1:340.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df806dfb-f55f-524b-a7bf-14da58e01b4c','','','Publ. Carnegie Inst. Washington 248(2):142.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4dcb387-a9b4-525b-8e83-ac5d74384887','','','Webbia 1:347.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('701e4922-0992-589d-9519-8ea32cd66067','','','Notizbl. Königl. Bot. Gart. Berlin 3:96.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('004d8f0d-a122-5733-abff-8eb4173e03d1','','','C. F. von Ledebour, Fl. ross 4:469.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('777c5097-e47f-580e-b8f6-37606a9445fa','','','P. de La Llave & J. M. de Lexarza, Nov. veg. descr. fasc. 1:21.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31b9248f-c01c-5168-9d68-e323a6d87679','','','Gartenflora 42:104, t. 19, fig. 1-3.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('551b67f9-97f6-5bc2-b134-00e9be9cad83','','','Bull. Soc. Bot. France 55:655.  1909 ("1908")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bc6ab10-db2f-598a-933f-1e3a763637aa','','','Ann. Mus. Hist. Nat. 7:466, t. 27.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4ce411a-ac8c-54af-b389-9a29f7395c42','','','Reise russ. Reich. 1:485.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00e1ff4a-6f27-52e4-aaa5-423166ea9771','','','Sp. pl. 1:293.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7d61251-d8ca-5836-a07c-5c00b520bc4b','','','Rhodora 24:35.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bf1ef10-2706-5a5a-8015-6ba34be8753d','','','Mém. Soc. Phys. Genève 28(7):18.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0f09ec6-b0d0-5904-a883-1e0c455404bd','','','J. Jap. Bot. 11:2.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('274ca291-d054-5386-94a6-b20f088808ad','','','Fl. bor.-amer. 2:127.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f476f5e8-5f48-51ed-aecf-ccac54ee4111','','','Notes Roy. Bot. Gard. Edinburgh 46:257.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c7e63de-9420-5091-875e-84c83664c7f6','','','W. T. Thiselton-Dyer, Fl. cap. 5(2):286.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7846fe8-fc85-5258-82e7-fade257e62c9','','','Izv. Azerbaidzhansk. Fil. 10:22.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('023a760a-6630-5364-b839-13b922365fc2','','','Gard. Chron. ser. 3, 13:414.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99a3c6ac-a017-5bbc-bfb8-d20c6da7be85','','','Prelim. cat. 20.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d633ad54-f9a5-53d7-a469-cf15d94891a1','','','Hort. reg. monac. 3.  1829 (J. H. F. Link, Fil. spec. 158.  1841)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27363cf2-64e2-5650-b311-d859d768bed4','','','Mém. Acad. Roy. Sci. Hist. (Berlin) 1798:89.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5bd9f17-ba05-524a-9c6d-2c8b37573ed4','','','Bull. Nat. Sci. Mus. new ser., 4(no. 45):401.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07ee94f4-44a4-5fff-8fae-63fe72069ece','','','Hort. bot. hafn. 1:267.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dc5c625-0cea-575d-9317-f78bd6ad8c2c','','','N. T. Liou et al., Fl. pl. herb. Chin. bor.-orient. 3:228, t. 59, fig. 4-6.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68bc79e9-dea4-567a-933e-6f823e3ddf32','','','Fl. Plains N. Amer. 626.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55f66a62-879a-5994-a543-66f8093a3b28','','','Rev. Hort. (Paris) 67:45(54).  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70967816-affe-5641-b78e-43075915185a','','','W. C. H. Peters, Naturw. Reise Mossambique 6(1):232.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c68fe93-c4e7-52ec-9422-cc5b477b9166','','','J. M. J. de Wet et al., Amer. J. Bot. 68:272, fig. 4.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('340420a1-bc4d-5084-a31f-706ddac79924','','','J. A. Murray, Syst. veg. ed. 14:430.  1784 May-Jun (Fl. jap. 187.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('baba9062-25de-59b9-9509-77525290cbda','','','Bot. Jahrb. Syst. 68:640.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51bc474d-35b4-59db-8719-8734aea20c06','','','Proc. Acad. Nat. Sci. Philadelphia 1848[4]:22.  1848 Mar-Apr (J. Acad. Nat. Sci. Philadelphia ser. 2, 1:178.  1848 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('feef7d18-4e42-5be5-9628-9e6c60ef4d60','','','Florist & Pomol. 1883:108.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8ecfa35-1ef0-5c71-8c46-cb4f80cc7d09','','','Fl. Brit. India 5:108.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4e09651-9042-5a0b-a3d5-20ef3bdde08b','','','Rev. Hort. (Paris) 71:403.  1899 Sep (ex Bellair, Rev. Hort. (Paris) 71:482.  1899 Oct)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d1de982-40b0-5d63-aedd-ab12430d75c3','','','Rev. Hort. (Paris) 69:280.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c054aa89-ec0a-540c-afd3-d54f518b5c1e','','','Mant. 3:669.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e483d757-a5cb-5e90-844e-722745de951d','','','Methodus 663.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c54668c-c4af-5b26-b67b-003090a1a49e','','','Repert. Spec. Nov. Regni Veg. 11:369.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('659039ab-5ee6-5370-8951-719575406a21','','','Anais Soc. Bot. Brasil XXVIII Cong. 89-90.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8165b1bb-56ff-588d-a157-3a3bba50f37d','','','Blumea 48:139.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26b136d9-b475-5bd2-bf6f-ba40da897192','','','Bull. Misc. Inform. Kew 1893:211.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e1fc4d6-b66b-51d7-9817-6838242df2ac','','','Man. gen. pl. 4:30.  1862 (A. P. de Candolle, Prodr. 15:471.  1864)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f760ef9d-659a-5b95-bb5c-2b3941b124ec','','','Mem. Amer. Acad. Arts ser. 2, 4:23.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7d34d62-c1a2-53f1-8399-8b8d870af84d','','','Bothalia 11:23.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ef9d6e6-c41a-5d98-a716-638dccdd2069','','','N. Amer. fl. 23:79.  1928 "<I>brevispicata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7eb7d19-9b20-510a-975d-45944477a49a','','','Symb. antill. 3:389.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff9394d2-27db-55d7-84a2-66b4108a5d43','','','Gard. Chron. 1871:1257.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a3667be-6c3d-5243-ac0f-10a150f07515','','','Mem. New York Bot. Gard. 1:441.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73a1830e-061b-5b81-ac3a-f29ce7999727','','','Philos. Mag. Ann. Chem. 10:419.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2a1d3ed-4288-534f-b3d3-17ad2b23f383','','','Erythea 3:107.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a80a0a8e-a161-5208-a27a-bfe7c9c99a00','','','Aliso 5:326.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8eaf417e-f040-5646-b073-44254fc28f73','','','Erst. Beitr. Fl. hercyn. 203.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4904ef85-9024-59c1-8537-476922fe5edb','','','Allertonia 4:80.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e517024-564d-5f74-a595-655803fd21cc','','','Rhodora 32:22.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f3743c3-fe51-5c24-8168-2f191c33313f','','','Züchter 21(1/2):53.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e999c1d4-8373-554c-ad89-8fb42a542fcf','','','Verh. Bot. Vereins Prov. Brandenburg 30:176.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90f1ac2b-895c-5dca-b692-54d5adae0c7f','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 3(3):435.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ee0e8dc-35ca-5afb-acd0-c5aba616b878','','','J. Coll. Sci. Imp. Univ. Tokyo 34:125.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7626d89-4a1a-5898-bf65-f9fb91204e8f','','','O. Degener, Fl. Hawaiiensis 169c.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5886fd0e-69a9-5c25-90e3-15f67b32e1ac','','','Candollea 9:308.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2007b52a-3f25-5a14-96cb-595ccb35edb1','','','Univ. Calif. Publ. Bot. 16:111.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca406d7f-2745-58d7-a0b8-7036cc88559b','','','Madroño 1:150.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9b9fcb5-12f2-50d9-aa4a-64b79a6be042','','','Linnaea 26:610.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e690a5fa-240a-574f-ab68-ff613ba2f582','','','J. Roy. Hort. Soc. 95:490.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4e79b7d-1819-5065-8733-169fb5568383','','','Linnaea 17:241.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cced0167-8d59-508a-927d-8eb942aa536e','','','J. Linn. Soc., Bot. 25:26, t. 13.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd4db4ff-0bac-57ec-b469-8dc7d4fdb48f','','','Nov. gen. sp. pl. 3:21.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31f45965-86ce-530e-bde6-f22a1487cee0','','','Char. gen. pl., ed. 2:128, t 64.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da1cd545-5111-5e21-b221-0c4f3a258298','','','K. E. I. Eichwald, Pl. nov. 35, t. 26.  1835 ("1833")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35369b33-72d7-5e4e-9c73-de1ea64a195a','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 6:664.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2feb2b03-013c-52b5-b462-d41c86c5e5b0','','','Fl. Mag. (London) 5: t. 277.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a7623f1-0acc-5d35-bafa-885cc3bcafdc','','','Kew Bull. 1957:65.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('602ca1d3-afbc-5849-845d-45b33c787cbb','','','C. Gay, Fl. chil. 6:467.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('456b4dc7-eb63-5a4d-a614-875029543366','','','Anales Inst. Biol. Univ. Nac. México 17:79.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f75e5d10-063c-51f2-a4a1-5fd3df686e31','','','J. Proc. Linn. Soc., Bot. 4:146.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2838ead-19c4-5ec0-8c2e-d1fb9f7fbd32','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 64:42.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef1a84ab-0561-5162-9fac-9da6a39018d2','','','J. Bot. 71:69.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1bddd5b-3a38-560e-992f-1417b329269c','','','Acta Horti Gothob. 23:163.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11b93efb-88f4-5730-9cf3-15e7fdb8a05f','','','J. Roy. Soc. Western Australia 13:3.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7c10c59-917f-5b46-9495-d7e6106674e2','','','Mitt. Bot. Staatssamml. München 11:243.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcdd355e-fccd-551a-96e2-5cb8f932d631','','','J. Asiatic Soc. Bengal 44:206.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df05d712-bf09-50ac-be78-5a8391c96992','','','Fl. carol. 92.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('113830f8-bff1-5990-a47e-45f0ca4e2e44','','','Fedde, Repert. Sp. Nov. Beih. 1:371.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85cd4699-f302-5141-a615-2cfea54b1dfe','','','Hort. kew. 2:201.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bd90fb2-b9c1-547c-9df8-2c04f557f8d7','','','Flore de la Nouvelle Caledonie 4:56.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75005cf9-a994-588d-9c7a-e0e1cba03064','','','Acta Horti Gothob. 5:29.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0a1872b-ae23-539e-98d2-013b2960ad1a','','','A. Moritzi et al., Syst. Verz. 14.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9511fed9-1e33-565b-ae7a-29fbaef6faef','','','Telopea 7:134.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6568f420-af45-51b9-9c8c-bfb25c74665f','','','Proc. Biol. Soc. Washington 48:39.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('663c1121-e5d6-58af-8038-5b08a45a2a66','','','Observ. Mesembryanthemum 2:138.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dd9fc2f-6516-512b-ad66-9bfe6996015e','','','Nov. Holl. pl. 2:38, t. 181.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('552f43f9-91bb-5395-8650-6bd3a7942c83','','','J. D. Hooker, Fl. Brit. India 1:223.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('479625fe-5ba2-512d-a586-8932d099c229','','','Amoen. acad. 3:51.  1756 (Syst. nat. ed. 10, 2:1147.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a18df79-2402-529d-b0a8-908362055e7c','','','Abh. Königl. Ges. Wiss. Göttingen 24:174.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c231db2-46a2-5d15-b258-c836763ceffc','','','Trans. Linn. Soc. London 13:103.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5c56a58-b663-5f12-ba1c-979c95de1861','','','Intermount. Fl. 5:246.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c7a8195-76c6-544b-8266-53adf07c1c4e','','','London J. Bot. 5:556.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d6faa3e-99b9-564a-b13e-0f3d71730d43','','','C. F. Hornschuch, Syll. pl. nov. 2:6.  1825 (C. L. Blume, Catalogus 110.  1823, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb1537f8-47ad-5eb3-949d-fa36b8977a5a','','','Account exped. Pittsburgh (ed. Philadelphia) 2:3.  31 Dec 1822.  1823 "<I>caespitose</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81f7b239-ddfd-5ec2-98de-1012fe0c6739','','','Sp. pl. 4(2):943.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd41747b-060e-5b98-9962-5c4aae09585e','','','Physis (Buenos Aires) 11:498.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb9eb8ec-82cf-5ce0-9414-f184960307e4','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(3):218.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e9e7b90-b12f-519c-9ee9-921072839cad','','','Miss. Em. Laurent 122.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('077e8b19-f801-509c-b119-3b6c0f903ffe','','','Linnaea 6:523.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6378898-7d47-5354-8812-7b2623b3b6c8','','','Beitr. Naturk. 7:149.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da8c3d54-297c-5db6-877b-824a286542fd','','','Gard. Chron. ser. 2, 17:298.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4f75eb5-ca6e-52ff-8df7-03f70df7ade0','','','Fl. altaic. 4:202.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca36cfd6-5e34-5a71-bf43-dd3698d738dd','','','Flora 29:116.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf4d19b2-9c2e-50a4-b14f-c9a47d641de3','','','Descr. icon. pl. Hung. 1:1, t. 1.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7a31e72-c73b-54de-8db7-bce775c91037','','','H. G. A. Engler, Pflanzenr. IV. 9(Heft 3):48.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1842534-478a-5508-89a1-b849058b31ea','','','Man. New Zealand fl. 1134.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ae6677c-7010-576c-a79d-f3be4e415aa9','','','V. Jacquemont, Voy. Inde 4(Bot.):99, t. 107.  1835-1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e742393-dfb1-50a5-8edf-e4fd8c9efe55','','','Bijdr. 936.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c17fff17-7f3f-57f1-b0dc-dac89997cff2','','','Jordanoff, Fl. reipubl. popularis bulgar. 6:85.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('572dfdbd-6c48-5c7b-84b9-2d183f237c2a','','','Jap. J. Bot. 4:331.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f826d69-38d4-5635-bed4-dadb8eba0c9f','','','J. G. C. Lehmann, Pl. Preiss. 1:97.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7abf6362-30d8-5097-845a-f907103af66c','','','C. S. Sargent, Pl. wilson. 2:326.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8803e003-debe-5256-887e-861ffa89e4ce','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 2:353.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('959acd3e-0203-5719-ab9f-f60390c0c58c','','','Syst. nat. 1:324.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('401d4006-95fe-50e5-a002-b0ac143d5ca6','','','Icon. fl. Eur. 3:4.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8dd13248-7eef-56a7-9c1f-94b7d309c495','','','J. J. Roemer & J. A. Schultes, Syst. veg. 4:212.  1819 (A. W. Roth, Nov. pl. sp. 115.  1821)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9a4f6b0-d861-5b3c-b76c-f26320d0e286','','','C. S. Sargent, Pl. wilson. 1:194.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e210521a-e8e8-5aaf-b0e7-4849f72ad491','','','Novosti Sist. Vyssh. Rast. 6:267.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87dd0618-cc68-5e64-9d75-1ef2f7464a0b','','','Bull. Misc. Inform. Kew 1921:294.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7d60cea-0ae3-5939-a837-3df98cd84eeb','','','Ber. Deutsch. Bot. Ges. 44:429.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('571149c8-268e-5f2f-ba37-9a8b531b8bc3','','','Bot. Mag. (Tokyo) 29:157.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('800b77e0-b672-534e-a569-656a69633a76','','','Acta Sci. Nat. Univ. Sunyatseni 22:60.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a8aa336-ebdf-5743-85fa-a503c9e8b7db','','','Madroño 66:95.  2019','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8bb50c9-8b72-5bef-aaf7-402abf25e3b2','','','Ann. Mus. Bot. Lugduno-Batavi 2:87.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2774368-c1f1-572b-aabc-3b4220090d06','','','Sp. pl. 1:141.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bde16b77-9029-5947-8f65-3309398ba932','','','Oesterr. Bot. Wochenbl. 4:417.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36afa9c6-25bf-53b6-8abc-755818695f56','','','Fl. ind. 1:417.  1820 (Hort. bengal. 10.  1814, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b136ba48-5b59-57a1-81d3-8d4a14309d01','','','Philipp. J. Sci., C 7:237.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd97d100-e2a7-52f7-bc59-cea2a82516b5','','','Proc. Linn. Soc. New South Wales 84:108.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c9e0f88-be75-567b-9a27-d12606e2575e','','','Kew Bull. 20:185.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68907a37-6467-5a77-aba8-c8ae5cb9d25f','','','Austral. Paniceae 248.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60d0f582-fb8c-5275-94ed-425b663097c3','','','Bull. Mens. Soc. Linn. Paris 2:1271.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('206e1db4-ad75-5c0a-852c-4e3cf7f88c65','','','Mém. Acad. Sci. (Paris) 67:4.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78e1794f-cf03-5de8-b931-6f09154756ef','','','Beitr. Sukkulentenk. Sukkulentenpflege 1939(2):34.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3c59845-2e76-5fef-9b8b-f8141c32bcc1','','','Pl. nov. Hisp. 73.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2846967-12d7-516a-be53-8f06f2dcec62','','','Man. fl. pl. Calif. 618.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef8464d9-c463-5a19-bc05-f363627053fe','','','Icon. pl. rar. 45, t. 23.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('124319bc-ff00-5cd8-9ca4-d55412aac756','','','Kongl. Svenska Vetensk. Akad. Handl. ser. 2, 46(5):35.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9587672f-d6cb-58f9-8d73-26fa658c0bbf','','','Proc. Amer. Acad. Arts 8:251.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dceab86-4502-5463-8a62-5386b0bcf496','','','Smithsonian Contr. Bot. 1:50.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4daca433-db7d-5e2d-a1ce-b49190307fd3','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:220[folio]; 5:283[quarto].  1822 "<I>sidaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81020dff-e1a3-5f5d-8e14-b00609f2e1c6','','','Edwards''s Bot. Reg. 15: t. 1229.  1829 "<I>obtusa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9518efbd-ef05-50d8-9fe0-de945ea562ea','','','Fragm. 4:50.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18e99a88-8797-5326-aa7e-2b99bbecf019','','','N. Amer. fl. 23:126.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27f180e3-294d-5081-9752-c754219f6441','','','Sp. pl. 1:193.  1753 "<I>catharticus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bccb8e80-f0ed-58db-85a4-d1dfbfa59948','','','Castanea 63:75.  1998 (Yates & Heiser, Proc. Indiana Acad. Sci. 88:371.  1979, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f52ccec9-61fc-5898-acbf-8c11f97765bf','','','Beitr. Fl. Russl. 322.  1852 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 7:498.  1854)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf1871aa-a0b8-54e4-86de-0265d21eb36c','','','Univ. Calif. Publ. Bot. 6:193.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6bf0cf4-0338-5cd9-b076-9cb17d479b68','','','Front. Pl. Sci. 10-1731:10.  2020','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de77f3b7-eaec-5e84-be43-ea81f1737049','','','Crit. revis. Eucalyptus 2:45.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b03f05f3-5af6-5793-8e77-718a4fee8728','','','Index sem. hort. acad. gotting. 1834:4.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67806a1f-4e67-5c1f-bed0-1481841b1867','','','Fl. flumin. icon. 9: t. 111.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b83197dc-15af-552d-8db2-323673632a9c','','','Proc. Amer. Acad. Arts 10:350.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ca3d41f-96e6-540d-a97e-160cb829b76d','','','Consp. fl. Turkest. 3:99.  1909 (Beih. Bot. Centralbl., Abt. 2, 28:44.  1911)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1336188d-77cc-5bce-bd8c-ac601039b06b','','','Hooker''s Icon. Pl. 30: t. 2954.  1911 "<I>rubro-striata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e232f50-5fa8-5f17-8b74-83e074498c93','','','Die Hauptsachlichsten Formen der Saatgerste 10, no. 47.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c16da4a1-ea38-5a58-a2fe-62f13d22e45f','','','Hist. pl. Guiane 1:93; 3: t. 36 "<I>guyanensis</I>".  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0142e46f-0174-55df-a86c-c28fc3663427','','','Neolin. fl. manshur. 572.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('296c4216-9982-57a4-ab9e-947d47300381','','','Z. Sukkulentenk. 3:30.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f0347cb-05f6-5c8b-ac48-97b35f044b64','','','Harper''s Monthly Mag. 55:365-367.  1877 (non L. 1753)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60156219-de98-562c-b255-29f352b6ad7a','','','Arch. Néerl. Sci. Exact. Nat. 3:250.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a04fd262-55cf-5fc4-bb65-e8bedda18750','','','Contr. U.S. Natl. Herb. 7:231.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84c0ab03-996c-5ffc-b4eb-0e2fcf874996','','','Taxon 67:334.  2018','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80a8b175-1fc2-520c-ad79-42d9106497a9','','','C. V. Piper & S. T. Dunn, Bull. Misc. Inform. Kew 1922:135.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b1d8565-f324-5bdc-be75-ebec6b3c5453','','','Ann. Sci. Nat., Bot. sér. 4, 8:315.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42c2cb07-0e77-5a25-8fee-3f40e95e799d','','','J. A. Murray, Syst. veg. ed. 14:216.  1784 May-Jun (Fl. jap. 89.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fafe3dc5-a546-5fec-9593-69ea90e637a7','','','Bot. Gaz. 97:594.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21401801-5365-5eb3-9542-a1f35078c6e2','','','Fontqueria 48:151.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03357130-4b8b-5c6b-ab3d-73f72d7e5c87','','','Fieldiana, Bot. 29(8):482.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9af68fe-865d-5ba4-bef2-cb2c0d88995f','','','Fl. bor.-amer. 1:195.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7568c842-a408-566d-baf6-03094686ff58','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 8:655, t. 6.  late 1884-1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17b0b075-f13a-5c90-9d2a-465b6a3a3713','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 4:527.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a17b655c-c07a-5423-9583-425ac2281a9d','','','Pl. hartw. 170.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5363be3d-8b63-5b7b-b8da-b075c9071f7c','','','Proc. Calif. Acad. Sci. 7:89.  1877 (non J. Vogel 1839)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b960ed1-3db3-5a92-9266-9246b619f652','','','Linnaea 5:569.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e42efe44-97bd-55b4-8825-c45f1493bcfd','','','J. Bot. 23:321.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5849c89-5d14-5eeb-9731-b3738209679e','','','Orch. Java 458.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('def6c9d7-ef9e-5c32-bd31-958b054f933c','','','Bot. Beechey Voy. 13.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11d495a1-0fdc-567e-84ec-915a63f56747','','','Čas. Nár. Muz. Praze, Rada Přír. 148:78.  1980 ("1979")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64aeb490-ca8e-543a-b35d-bca8d3aca516','','','Virginia Med. Monthly 3(1):48-49.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06bb6f52-d49a-5040-8c34-4768786b63d9','','','Orchis 58:129.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f26eadbf-57fe-5d05-ab92-1b32f26b9a7f','','','Diss. Bot. 223:174.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f5791bb-0237-5202-bde4-12a141168c2e','','','Ann. Mus. Colon. Marseille sér. 3, 3:22.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c87868a-95b8-5ed9-a13a-c4599b2b294c','','','Sp. Larix 51.  1930 (Biol. Meddel. Kongel. Danske Vidensk. Selsk. 9(2):51, fig. 16-18.  1830)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a254fa62-7862-50e6-8120-69eb203e706e','','','Stirp. austr. fasc. 2:45.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ee34d05-4575-5d28-952c-198a9171348e','','','Fl. taur.-caucas. 1:123.  1808 "<I>aruensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('202c6de0-e3a6-58d3-9238-74c66bb8412c','','','Kew Bull. 46(3):501.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86ebfe27-bacc-55be-a43c-ffbf56c45524','','','Enum. pl. 4:13.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a752fbc5-32f9-5578-ba4d-0e8a79e51b01','','','Fl. jap. 2:17, t. 108.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c907b4c3-fa25-5704-8853-079a3c6f02ba','','','Möller''s Deutsche Gärtn.-Zeitung 28:16.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eebc360d-6553-5cbb-8f0b-7ab519350e6d','','','Hist. nat. vég. 2:129.  1834, pro sp.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e141e63-2698-58b8-ac71-80efbed2078f','','','Trans. Amer. Philos. Soc. ser. 2, 11:159.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6158e4ab-462d-5439-be6d-e8c0e45acf85','','','Syn. pl. 1:418.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ab9dd10-335c-570b-aa73-4e2ad9751ee6','','','Enum. pl. China bor. 8.  1833 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 2:82.  1835)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a959023-233e-5d89-8fe0-c322c40db6ca','','','Feddes Repert. 69:37.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ce1399a-4508-5bc6-b8f6-ba129e339682','','','Repert. Spec. Nov. Regni Veg. Beih. 1:873.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26f4974e-f1bd-5334-8106-358b83a553b5','','','Gesch. Bot. 78.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3054ea31-943b-5778-925c-eddaa4d7b2e3','','','Austrobaileya 2:356.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b3b0722-6126-56eb-83c9-21e565796c54','','','Contr. New South Wales Natl. Herb. 4:380.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc740247-ea7d-566a-b7fb-20f72932cf54','','','Phytologia 20:194.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a5089bf-0125-5906-a294-49380a510647','','','Prodr. 2:4465.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b564ab88-c5ad-5a2c-90e3-5516b9326792','','','Bot. Mag. 56: t. 2913.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1f27eb0-d882-5750-8e7e-aca0cab3287f','','','Prodr. 5:444.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd31386c-b9fe-5a85-9c1e-6fabdc2d3874','','','Novosti Sist. Vyssh. Rast. 27:102.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8821c428-2ee9-5a24-83f8-e2bcab170a00','','','Phytotaxa 301:31.  2017 (L. G. Lohmann in O. Hokche et al., Nuevo cat. fl. vasc. Venez 273.  2008, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85a73e3c-e5ab-53c3-afae-565e8ffdc06a','','','Bot. J. Linn. Soc. 157:120.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4b6dc44-ff70-5624-8db2-e046dc72c3d1','','','Prodr. 5:531.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6814c973-347b-5dba-9d40-fd70c329b1ff','','','F. Schultz, Archives de la Flore de France et d''Allemagne 282.  1853 "<I>philippi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('423f56e7-8346-51b8-a1d5-0ab7025bc57a','','','Philipp. J. Sci. 1(suppl.):242.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d93f9f05-b617-5603-8c36-212fb26c8a29','','','J. Fac. Sci. Univ. Tokyo, Bot. 13:400.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef96ac32-fb93-52bf-ab43-2d9f7ea801a5','','','Icon. Pl. 8: t. 763.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6254d23-0c4c-5b7d-9f7a-b4f88d1892bf','','','Prodr. 2:78.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89cba69f-77d5-50a8-ada4-573d98126865','','','Contr. Gray Herb. 146:41, t. l4, fig. 3.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac725d83-b1c6-5975-9f01-85992a1c1939','','','Proc. Calif. Acad. Sci. ser. 3, 1:82.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec6dc99a-e211-5291-8b06-1a33624c08b3','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 64:333.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bccab328-79a5-59ec-b41b-a30add0ca5c9','','','Boissiera 11:97.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96d2b1f6-ac9b-5c7a-ac88-3e81f78a2ea1','','','Verh. Bot. Vereins Prov. Brandenburg 26:128.  1885 (Monogr. <I>Clematis</I>)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46a36b87-2354-578e-af71-e16588d096ee','','','Fl. flumin. 75.  1829 ("1825"); icon. 2: t. 68.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6662e46f-bf5c-5925-8e3a-bf9783a81f47','','','Berlin. Jahrb. Pharm. Verbundenen Wiss. 1804:75.  1804 (Tussac, J. Bot. Agric. 2:247.  1813; A. Richard, Bull. Fac. Med. 6:93.  1818)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f66d675d-dfa2-5d93-ba3a-33d6b61b76a5','','','Ann. Roy. Bot. Gard. (Calcutta) 7:117, t. 103.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81aef199-b697-5ec1-bbb5-c56d4d2bb5c7','','','Madroño 10:5.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21d4eb7c-2e71-57d0-bec1-06c054a9cd5d','','','Fl. Kavkaza 4:258.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28c6132c-99fd-563e-8db6-b6c4d5781f5f','','','Cact. Succ. J. Gr. Brit. 13:69.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1168a1a4-ef8d-5f39-99ac-370d7db52ce2','','','Bull. Misc. Inform. Kew 1895:229.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44dff364-ec09-5f88-ae4b-df5da567098b','','','J. G. C. Lehmann, Pl. Preiss. 1:358.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6d22095-91bc-53da-b0b2-e00aced331dd','','','Fl. angl. 192.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77e9e807-04ef-5bda-944b-1e2aced2dc3b','','','Sitzungsber. Königl. Böhm. Ges. Wiss., Math.-Naturwiss. Cl. 1903(17):34.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26baafc4-94cc-5e04-a23a-1ab674cef4c2','','','Mém. Acad. Imp. Sci. St.-Pétersbourg, Sér. 6, Sci. Math. 1(4):411.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ad6d5f9-6c66-5459-80cc-1300647e1965','','','Fl. gall. 384.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de33c161-8936-54a6-8216-76fb2d65f360','','','Contr. U.S. Natl. Herb. 7:236.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('828d1f50-1e00-5e0d-bad8-fb36a91287d5','','','Acta Phytotax. Sin. 18:215.  1980 "<I>vario-striata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a53436a-b72a-542c-a03b-4048cdce1a5e','','','Gard. Chron. ser. 3, 39:322, fig. 130.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f299b048-6b18-5abc-a121-65f5c21cd81b','','','Syn. pl. 2(2):331.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15037864-c7ef-5fb2-a154-64a44e85d857','','','Prodr. fl. Ind. orient. 353.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('643d5c84-c91a-5cba-a39f-cb1aeb692681','','','Legum. Trop. Africa 2:411.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f65d6acf-70eb-53c0-bcb1-0f31bae0da6a','','','Kakteen Südamerika 4:1287.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc6d7fa6-17b6-5920-a5b9-78c6f3103f4d','','','Mitt. Deutsch. Dendrol. Ges. 10:59.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9df4d60c-8da5-5867-a230-9c2914204e3c','','','J. Arnold Arbor. 20:421.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f1e6759-afdd-5b9d-b7ff-3f2e4c870ebe','','','Sp. pl. 2:619.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee289ea7-c6ce-5fa4-bb9e-5d119ac61f77','','','Fl. ind. ed. 1832, 3:360.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8641bba-b4ad-585d-bff9-022ea28bf1ea','','','Sp. pl. 1:302.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fdaea3f-3547-5f48-847d-a8c2d789ab9a','','','A. L. P. P. de Candolle, Prodr. 11:320.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44b4a794-8f45-5274-a0f6-3fb33db3f82a','','','Cact. Succ. J. (Los Angeles) 60:159.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef2091ac-9b25-5db9-9466-93cb0ebb05d9','','','Bot. Mag. (Tokyo) 16:129.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90dc9ac2-c4fe-5885-a840-020bbecfb748','','','Fl. chil. 1:270.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1100b230-1609-5b65-9f0c-040ffe5d6805','','','Hooker''s Icon. Pl. 23: t. 2214.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45155b19-a84f-54c3-ab74-2d6f076a2f68','','','Arbor. frutic. brit. 4:2341, fig. 2246.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3281dd75-f076-5bc9-81a7-7825eb0b8f33','','','Rep. Bot. Soc. Exch. Club Brit. Isles 4:624.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ce06c22-cc8d-5c26-8896-a583373b3646','','','Guía Identif. Cact. Amenazadas México unpaged.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc33be54-9fae-5d6b-aa3e-e98b9744142b','','','Sida 20:1410.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3df38a99-494c-52e4-80f7-483986a6e230','','','Mem. Bernice Pauahi Bishop Mus. 8:147.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('667e97d4-c105-5056-a3dc-56312c5f98dd','','','Phytologia 73:113.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b2a7124-8483-5263-a7ad-afe4caf04744','','','Sp. pl. 1:75.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01bb705b-3c53-583d-af95-b734ff3cd67b','','','Trudy Bot. Inst. Akad. Nauk S.S.S.R., Ser. 1, Fl. Sist. Vyssh. Rast. 1:102.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e754c50e-c570-5c17-a733-bfd621d2acae','','','Repert. Spec. Nov. Regni Veg. 7:230.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64116d2b-5861-5268-bcf4-4c28e98ec4e9','','','Phytologia 54:486, t. 1.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d811fad1-500a-5873-91ed-30846b55219a','','','Bull. Soc. Bot. France 54:469.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3d611be-6052-5d1b-935b-4cf3ae27ddf4','','','Fl. Neotrop. Monogr. 13:46.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fd861d5-c840-5df4-8d2e-ba33133e84db','','','Proc. Amer. Acad. Arts 21:436.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd5f5f6a-120b-55c0-ad10-b4e62b37e347','','','Bull. Misc. Inform. Kew 1936:323.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('283eadb0-4c7b-5099-8deb-6e9b5b2d549e','','','London J. Bot. 3:208.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d803637-39c1-5337-8f3d-65e19de0286b','','','Prodr. stirp. Chap. Allerton 325.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa4b0c94-dd30-5a67-b055-73fea6ec58e9','','','Biblioth. Bot. 17(Heft 72):33.  1910 (Sp. rub. 33.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d0d78da-1298-5b05-9386-5c57cbad3cff','','','Prodr. 8:426.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4df886cc-8cbc-595c-a688-22e3f05f461c','','','Fl. carol. 73.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f0acfbf-0b84-5c77-b7d2-1ffd61bd8e8c','','','Bot. Beechey Voy. 403.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52f04a29-d56d-5c11-9cc1-125ff7f64241','','','Byull. Sredne-Aziatsk. Gosud. Univ. 7(suppl.):23.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cf86af2-c2ab-5aea-81de-8c8b2142edc9','','','Gen. hist. 1:628.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7ceaf79-9e75-534c-8ca2-8bdb28383c33','','','Bot. Gaz. 23:241.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd1e9254-9a8d-5d7e-adec-33347f522fa4','','','Herb. brit. 1:82, t. 58, fig. 1.  1769','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97c7d49b-f854-5a79-882c-0a427b960c82','','','A. D. d''Orbigny, Voy. Amérique mér. 7(3). Palmiers 86.  1844 (Palmetum orbignianum)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3f62f3d-473f-57ff-b675-147b9109cf39','','','J. Franklin, Narr. journey Polar Sea 739.  1823 (Bot. App. 19)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07a765e2-c0a3-5300-98aa-6caf036f0ec7','','','Proc. Amer. Acad. Arts 6:219.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d00603bd-5bc1-5ac2-ba65-7f61c78ff8e5','','','Brittonia 34:181.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b1e69ce-4001-5cbf-9d60-b7cf81363588','','','Contr. U.S. Natl. Herb. 8:301.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b1f4591-1396-5801-ac55-ef91ad570195','','','J. Coll. Sci. Imp. Univ. Tokyo 25(19):205.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('151b1034-37cf-5b47-935f-b173a5adca0e','','','Bot. Mag. (Tokyo) 42:475.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00135a6d-adeb-5673-a653-dfe8e439ac7f','','','Mém. Soc. Imp. Naturalistes Moscou 2:108.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d67bcff3-edb4-5909-83df-4b51dbcd8c23','','','Sp. pl. 4:1141.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91179102-f199-591a-a0a2-7aaf2f661ad5','','','Bot. Gaz. 23:6.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f660028-250d-57dc-87d0-a08ce094a38e','','','Bol. Farm. Militar 3:127.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d87f476-1b05-51a5-8294-f655fcc18533','','','Fl. austral. 2:295.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0bea13c-5885-5b87-8c78-ae83ab260daf','','','Not. pl. asiat. 4:394.  1854 "<I>aurantiaceus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a1f2d53-1982-57e9-ac2b-367a02025e4b','','','Sp. pl. 1:247.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2acd84ad-f78b-5615-a923-0e45da270ff1','','','J. Proc. Linn. Soc., Bot. 4(suppl.):52.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc5bedd2-06b6-514b-96c8-76d16b766ca4','','','G. Bentham & J. D. Hooker, Gen. pl. 2:116.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92dda3b6-0670-501e-8825-bae5b66d897d','','','Madroño 23:293.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03cbacba-5095-54c9-a8df-289d129b8101','','','G. Schweinfurth, Beitr. Fl. Aethiop. 187.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3beaae3-559b-5f7f-9898-56976ebbab17','','','Bol. Soc. Esp. Hist. Nat. 23:245.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a0cf50c-df63-51e2-945b-a2513b2eab48','','','Beskr. Guin. pl. 249.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36682993-e3bf-56df-9a99-aaca749eca84','','','Encycl. suppl. 5:663.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('813a06fd-d743-5d6a-8154-98c473e9387b','','','Phytologia 26:176.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('422d62d6-5177-53f7-ab0e-d5461f32757d','','','Curtis''s Bot. Mag. 29:272.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d92d60f-1dd1-5a9f-acf0-d6bdad0765a9','','','Repert. Spec. Nov. Regni Veg. 33:155.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('898090c8-800a-5625-af91-9f93a1af018c','','','J. D. Hooker, Fl. Brit. India 2:251.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84ecab2a-d0e7-5004-b2f6-4434a94b7323','','','Fl. Portugal 455.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdb4cd30-a82d-5c4c-ad4d-da92a821dc31','','','Nuytsia 7:194.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c0579df-cfbf-5a6c-9b72-8b7de34cf7ce','','','Fl. carol. 251.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a1dc9f8-0582-5e95-a4f1-8ee82f447de2','','','Ill. observ. bot. 1.  1773','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('070cf594-8b6f-5eff-8380-e51271604131','','','Fl. Ned. Ind., Eerste bijv. 356.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86d5def0-fc47-568d-8810-525e2d7fc10d','','','World Checkl. & Bibliogr. Euphorbiaceae 4:1470.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('223fbee4-362d-5f32-a2a8-91073f45855b','','','Fl. Ned. Ind., Eerste bijv. 377.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4c6a4c7-a845-5e00-b5fe-36f80c6278bf','','','Trans. Linn. Soc. London 10:3, t. 1.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fca77b3-ee1d-5b93-9dad-5e093c7d9deb','','','Bull. Mus. Hist. Nat. (Paris) 1:320.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd18f70a-2258-592c-acae-0faecf23c336','','','J. Linn. Soc., Bot. 17:171.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('500761ef-d35d-5a66-80e6-17f606dca574','','','Bull. Soc. Natl. Acclim. France sér. 3, 5:773.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d58e002a-7669-593b-a0c2-7ac9de8beb1e','','','Veg. syst. 12(app.):64, t. 10.  1767 (Hort. kew. 172, t. 6.  1768)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9c011a9-941e-5fe7-904e-4d7cf084263e','','','Bot. J. Linn. Soc. 92:239.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25025351-8d7e-5d36-8e48-162851434cd2','','','Bull. Soc. Bot. France 40:262.  1894 ("1893")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94283332-4d8b-5af7-836d-6fe973a93357','','','H. G. A. Engler, Pflanzenr. IV. 105(Heft 86):319.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c45183e8-1219-5879-ac33-1cef956af57f','','','Bull. Herb. Boissier sér. 2, 1:873.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d51790e-0eb5-5c79-989c-f50f4749576d','','','C. F. von Ledebour, Fl. altaic. 1:399.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ddab165-e9df-5306-8f91-bdeefa3452c5','','','Fl. sichuan. 9:272.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32f925e3-ce67-54a2-b13c-1263ec18e7a6','','','Beitr. Fl. Russl. 275.  1852 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 7:451.  1854)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06b3e79c-9766-5119-ac9c-323245ea189d','','','Jahrb. Deutsch. Kakteen-Ges. 1:94.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80f04b35-427e-5c66-bcdb-34eb24580156','','','Proc. Amer. Philos. Soc. 60:32.  1921 "<I>urbani</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb713955-5569-55c9-9a8b-6db14dadbb1f','','','Fl. orient. 2:125.  1872-1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebe13b16-d882-5cc0-9bf0-8de4ed927ad8','','','Anleit. Erzieh. Holzarten 2:193.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95021a94-7814-5a45-9b89-dceeed941a22','','','Amaryllidaceae 96.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6bde36d5-6187-570c-83f3-09dc7cf8e586','','','Fl. atlant. 2:177.  1799 (non Burm. f. 1768)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9688c90-e844-51cd-9b64-8aa100110df2','','','J. Arnold Arbor. 20:412.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce0e3401-b99d-5be6-be06-cadb0324f402','','','Repert. Spec. Nov. Regni Veg. 8:573.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3782c5e3-ad4e-579c-b69e-058b99933d18','','','Contr. U.S. Natl. Herb. 23:1493.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebbaad0a-97b4-5a06-a89a-b52cb410a1ca','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:221[folio]; 3:283[quarto].  1819 "<I>Gualtheria</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ba82b0a-55d0-5d12-a69e-7ccda4387f48','','','Wrightia 2:190.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4581dfe3-99a2-5e1d-8295-5ac81bdeb0c9','','','Trudy Sredne-Aziatsk. Gosud. Univ., Ser. 8b, Bot. 17:56.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f2b0fc5-1666-5edf-a05e-b8f216f392a1','','','Fl. siam. 3:74.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('127db6ae-9ce6-5e58-bc98-e29e4d85860d','','','Rep. Bot. Exch. Club Soc. Brit. Isles 3:414.  1914 (Century Dict. 12(suppl.):845, sub <I>Myrsiphyllum</I>. 1909, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6dd2b23-537e-56ff-8a4f-e87468a37b9f','','','Amer. J. Sci. Arts 29:248, t. X, fig. 75.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b35e482-ac1f-5f91-bf35-28cfcf7faa4e','','','Syn. pl. 1:252.  1805 "<I>lacustris</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e04cea30-7c2e-586a-9636-fbb682b4d870','','','Bot. Mag. (Tokyo) 38:312.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('880a854a-e1e3-549a-b119-8a54a7da1599','','','Prodr. 280.  1810 "<I>cannaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa7eb6f0-9039-5cd7-bcb5-0f9666a70230','','','Gram. unifl. sesquifl. 157.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe0401d4-bbd8-5f03-a20a-0253b14dc7c4','','','H. G. A. Engler, Pflanzenr. IV. 20(Heft 101):588.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('375820df-4ee9-5833-a95c-d4619903cc89','','','Fragm. 8:50.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f2d697c-a538-55e1-9fb2-4ad94242ace8','','','Hist. nat. palm. 2:77, t. 65, fig. 2.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('192a6f1e-3c40-5db0-b229-6e8ea92e406e','','','J. Linn. Soc., Bot. 35:310.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cce0310b-385a-51b8-bc9d-4acdcbc238ec','','','Fl. ind. ed. 1832, 3:297.  1832 (Hort. bengal. 55.  1814, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('deaf5621-ab96-5e81-ad57-71482fc7728f','','','Linnaea 29:248.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74e076fd-29bb-58f2-8053-a83ef8920e17','','','Bull. Torrey Bot. Club 23:128.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80955007-2969-5b6e-aeb5-c957acdf2cf6','','','Bot. Jahrb. Syst. 22:51.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ac76beb-b039-5446-bf2f-7a60f3b93071','','','Orchids (West Palm Beach) 87:305.  2018','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('883b7815-83d7-507e-99aa-16374d884fa5','','','J. Matsumura, Icon. pl. koisik. 3:19, t. 155.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e10e2bf3-b6f4-5f64-84ab-de4ef5f68a1f','','','Fl. N. Amer. 2:6.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33ea41d2-4e35-5d7f-ac4c-d7428cd76aec','','','Enum. hort. berol. alt. 1:267.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff548045-e278-5845-8960-6913038b0e05','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:112.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e456140e-3610-5e5f-894d-10672521d5be','','','Mem. Amer. Acad. Arts ser. 2, 4:10.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5186f594-4d48-5cad-a273-d6f28d10a59a','','','Fl. ind. 1(2):227.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdc41418-af8f-5cd1-90f2-1d69febdc1ce','','','Bot. cult. 2:190.  1802 (Bot. Mag. 27: t. 1094.  1808)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69350680-1e74-5506-b44c-814ed511aaf0','','','Ann. Mus. Bot. Lugduno-Batavi 3:287.  1867-1868 ("1867")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8ca284c-39bc-5af5-990c-e736e7010398','','','Bot. Mag. (Tokyo) 47:260.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('365ec743-4dad-5dbe-9622-25833872ff0e','','','Methodus 545.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84aa9c89-261f-597e-957c-b10521f0e628','','','Nuovo Giorn. Bot. Ital. n.s., 17:430.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cca1798-97a6-58ba-b63f-331e0fe25a58','','','J. A. Murray, Syst. veg. ed. 14:187.  1784 May-Jun (Fl. jap. 81.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5f7bb96-f47c-5511-8bbc-4662d25d24d9','','','Descr. icon. pl. Hung. 2:200, t. 183.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b76b3d8-da0e-5edc-afa7-7478d07dcfe9','','','W. Roxburgh, Fl. ind. 2:404.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb1850dd-69a2-5f2f-8190-a45ec7fd5296','','','J. Bot. 55:41.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e591a1f-a7da-53ef-8bd3-66d59c4caaaf','','','Rev. Hort. Belge Etrangère 20:217.  1894 (Rev. Hort. 79:570.  1907)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8eb0909-1ea9-55f6-9a4c-7ac0031e17ac','','','Trans. Bot. Soc. Edinburgh 7:154.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a965554b-98be-5a4f-bb5d-9fd751085fc8','','','Trans. S. African Philos. Soc. 18:44.  1907 "<I>Mesembrianthemum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('baae3102-b485-54ee-95d8-ce5b100a34be','','','Linnaea 34:47.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a723f072-eb4c-54ed-a007-43ee85fa4365','','','Wrightia 2:196.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e79653b-a711-51ec-a87f-fd3fa16ca397','','','Bot. Mag. (Tokyo) 13:33.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0991dc0-7e8a-5f99-95b2-2847575826ed','','','Fl. N.W. Amer. 481.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b097474d-0e11-507b-86f5-a13346e00c9a','','','Pacific Sci. 6:289.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b752dce4-cd14-52d7-bd9c-8731a7313585','','','Ess. Agrostogr. 12, 154.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46d8eb95-8583-585d-b925-852e8fa4cc9f','','','P. E. Boissier, Diagn. pl. orient. ser. 2, 5:68.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31da7ee6-436d-5f27-8d48-da645f38f924','','','Gard. Chron. ser. 2, 8:809.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9d30264-114e-5a65-a933-62420633e6e3','','','J. Arnold Arbor. 7:242.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1686cfe-7284-51f1-ab47-c53e57f506d2','','','Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 3:211.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('050b95b1-e1dd-510a-afa7-6fe15509bb28','','','Prodr. fl. nepal. 56.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02324e24-bc1b-50f4-96af-c86b7cb21494','','','Bot. Jahrb. Syst. 36(Beibl. 82):57.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7c0c658-26d3-5510-941e-c008237191c9','','','Trans. Linn. Soc. London 25:312.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3927e95b-2834-5b21-bedd-649c088217f8','','','Bot. Jahrb. Syst. 65:429.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4658e3e3-eb66-5273-a8a0-9f9a993247b4','','','Flora 66:549.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e85ee2a-cbed-5a0f-b151-c1f0ff53b8c9','','','C. F. P. von Martius, Fl. bras. 15(2):132.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b866cef-8540-532f-b594-e80c50118f8b','','','Enum. syst. pl. 25.  1760 (Select. stirp. amer. hist. 173, t. 176, fig. 75.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb9f3484-8b80-516e-a97b-74d27ce8b3a9','','','Ann. Bot. Fenn. 43:53.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9304f9b3-6c60-5bce-9770-b6e228a1f5c0','','','Folia Geobot. Phytotax. 2:118.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4c4fa2b-39f2-5469-9a9b-9f4c6131bfad','','','Bot. Jahrb. Syst. 29:315.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('243271e1-5a15-57a0-aae5-3a24716162e4','','','Sp. pl. 1:511.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b406cf9-c656-5205-9485-7d352bdae2b8','','','H. G. A. Engler, Pflanzenr. IV. 94(Heft 46):272.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29f9fb90-38eb-5b13-a06b-fcedaf1288a1','','','Acta Bot. Bohem. 9:99.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4433ac05-1966-5125-9301-36d588cb62c8','','','Syst. Bot. 8:417.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4342e841-450e-5479-a512-8aea8961129b','','','Bot. Jahrb. Syst. 37:561.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c0869fe-6c62-5b8e-97f0-bc163abc54cd','','','Diagn. pl. orient. ser. 1, 8:12.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6dd33e1e-87b2-55b1-9edc-7eaef9b9f086','','','Univ. Calif. Publ. Bot. 15:253.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef546012-cf69-512b-978d-cf0df71e7ef5','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(2a):52.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf6fce39-ae17-53e1-9488-75eaa525c19c','','','D. Prain, Fl. trop. Afr. 9:561.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b387fdca-081f-522c-a725-c84982f1c5ba','','','Aarbok Univ. Bergen, Mat.-Naturvitensk. Ser. 19:27.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c356adc1-0cef-5374-951f-f2d38a67bf6c','','','Fl. Brit. W. I. 320.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9598f0c1-b98b-5b92-9c12-a22880d143d1','','','J. F. Royle, Ill. bot. Himal. Mts. 1(8):253; 2(7): t. 69, fig. 3.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e1079d5-a008-5602-8f3b-62a2f5dae067','','','Pittonia 2:72.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f022a2c7-4a4a-57bd-84f6-b4bf00dd8a6f','','','Nov. Holl. pl. 1:106.  Dec 1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7ab7377-fa8b-5c0b-aec9-cc4ce5a95d27','','','Ann. Naturhist. Mus. Wien 82:346.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ba0a1bc-14df-57fb-a993-74f4ba3ef1e0','','','Bot. Mag. (Tokyo) 90:53.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14a9052f-f31d-51c8-9006-552f372137d1','','','Monogr. Acad. Nat. Sci. Philadelphia 1:229.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c759937-34a1-52a7-9ef9-07d938df702b','','','Révis. gramin. 1:67.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61deaeee-5f4f-5c5e-859a-bd28171cde57','','','Proc. Roy. Soc. Queensland 69:84.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db38e972-4fb2-5e15-9f37-6c50ba95d16e','','','Bull. Soc. Bot. France 1:318.  1855 ("1854")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2eb718e0-f4f3-5b0a-8224-2ac225bd4752','','','Sp. pl. 2:854.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0313a509-d784-510e-8302-b956c3b3646c','','','Fl. Nieder-österreich 2(1):873.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6c9a9d6-c5d0-550f-b859-b09fbaf298ea','','','Bull. Bot. Lab. N. E. Forest. Inst., Harbin 6:73.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('513808f8-c6ce-5869-909d-8ff91dd1a324','','','Boston J. Nat. Hist. 5:111, t. 13.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5f002f3-6d60-5de0-82f6-c5f31d121cc3','','','Trudy Prikl. Bot. Prilož. 53:170.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('307c25d2-ad6d-5541-a0d2-2d8ed3b6c4ec','','','Amer. J. Bot. 26:419.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4331ddc-04cf-59a0-888b-fbe600e1525c','','','Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 9:158.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e2a027d-9bee-5c20-9912-97df6a3eb9a5','','','Ill. Hort. 7(Misc.):53.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50fcf74e-15f0-5586-acf0-f14c790a97a0','','','Fl. bor.-amer. 1:6.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5975495-88fb-5448-986d-d87f1fdcaee8','','','Observ. bot. 5:11.  1788 ("1789")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae6100a8-57aa-58c4-b6ca-bd15e98d84e2','','','Gard. Bull. Straits Settlem. ser. 3, 7:27.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa9146c1-4417-5379-a59b-729c2cc64b63','','','Bull. Herb. Boissier sér. 2, 5:435.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d376ec6-73d9-5fa8-ab3d-30f2c7225614','','','Lloydia 9:249.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c2cfe16-a56a-516d-896a-5384f8a4bb96','','','Bull. Bur. Pl. Industr. U.S.D.A. 261:30.  1912 "<I>longiflora</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6fc949a-fa0c-5d20-8a5d-dd8cb20713c4','','','Fl. taur.-caucas. 3:145.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bef06284-602f-53e3-8edf-3598f9eb30d5','','','Syn. pl. glumac. 1:123.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91a9c7b1-38f5-51bb-8332-2d34caa3b832','','','H. G. A. Engler, Pflanzenr. IV. 30(Heft 13):254.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84c5aaad-42d0-5b54-8ff4-0101bde2e2df','','','A. A. Orlov, Kulturnaya Fl. SSSR 2:164.  1936, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a0ff2b0-8ae6-55cf-8f07-daaf040ee201','','','Bot. Mag. (Tokyo) 44:27.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79b11d6a-addd-583a-bc60-c333592df2a0','','','Hist. & Mém. Acad. Roy. Sci. Toulouse 1:212, t. 17.  1782','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b20e172-b0cc-5c72-aeef-fd36a2cdf2be','','','Sp. pl. 1:191.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfca1060-ea83-5d49-bd4d-2bb5153e531c','','','Syn. pl. 1:183.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5b1e1a9-c937-5ac3-b5b9-e9ae61aeaff9','','','Amer. Fern J. 40:247.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1b83b94-8f63-5938-884c-0d0b2a49a9b0','','','Mem. New York Bot. Gard. 65:99.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e56f504-3f07-5092-bb55-40515212e19e','','','J. Arnold Arbor. 22:169.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c137a64c-a7ae-552f-8cf0-911549964a07','','','Fl. austral. 2:247.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9f571e9-16ff-54db-aaa1-3fc60783d963','','','Proc. Roy. Soc. Edinburgh 12:410.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3304cdae-7792-5a84-9f0d-9a1c27f97241','','','J. D. Hooker, Fl. Brit. India 1:94.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70a53d8f-65c1-5cd3-a37d-26c207d91c68','','','Bull. Torrey Bot. Club 21:121.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32176244-8fd3-5522-972e-4a0cc9242bbf','','','Pl. Syst. Evol. 237:71.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4f1b618-e00f-56c3-b3ad-4c17d87b3221','','','Novon 14:277.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c65406af-51a1-5326-999c-88250df04924','','','Diagn. pl. orient. ser. 1, 9:16.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b54924e8-9550-5391-a7de-40d6f49a5e87','','','Syst. veg. 1:658.  1824 ("1825")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a63eb76-073e-5b4e-b884-f48530574677','','','Bull. Soc. Roy. Bot. Belgique 10:324.  1871 "<I>luciae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac0da743-72b7-5495-ac2d-d7b877a7ea16','','','Physis (Buenos Aires) 4:184, fig. 5-6.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c76c9e3-7f1d-5a70-9299-05cae8e5cc1f','','','Sp. pl. ed. 2, 2:809.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4c05982-5764-5515-993e-7b51160d2be5','','','Beitr. Naturk. Ostseeprov. Russlands 1:67.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b8b8daf-8680-556e-a35d-1a2302cb4a51','','','Chem. & Druggist (Australas.) 5:56.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f6af8d7-c527-55b3-85ca-48048d80f4da','','','J. Jap. Bot. 2:22.  1922 "<I>komayae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae705612-483b-58b6-8722-beed590f06d9','','','Trans. & Proc. New Zealand Inst. 19:243.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('379d24b1-b780-5598-9f5a-35efac7c2669','','','Abh. Königl. Ges. Wiss. Göttingen 19:225; Pl. lorentz. 177.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5da7eaf2-68e0-51db-9983-f6ca69b1e349','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 15:229.  1870 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2b344dc-6897-5b92-a5e2-9099ac67ea60','','','Fl. taur.-caucas. 3:300.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62a87849-3255-524e-9bd2-8a4fce92ea32','','','Syst. veg. 1:41.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('798ac8e3-24f2-526e-9512-d5cdc49f82cf','','','Novon 28:159.  2020','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14f9343a-654b-54c6-95d1-00e031dce27a','','','Abh. Königl. Ges. Wiss. Göttingen 19:134; Pl. lorentz. 86.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c465b97-80a6-5622-9467-549532ea22c7','','','W. H. Brewer et al., Bot. California 1:585.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5184b787-26f1-5969-818d-dbdab1e7ac36','','','Aroideana 9:176.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57c75b33-c40c-590e-aa5b-3c6a2cad77f8','','','Orchidaceae 6:164.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b52c445-b77f-5856-a771-6e1d0dc4befc','','','Syn. pl. glumac. 1:111.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f76ccd9-7cc4-5c54-8fda-eb271a515c15','','','J. Bot. (Morot) 13:198.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77c6dde5-5065-5986-bbbb-ee5853a5ec0c','','','Rev. Hort. (Paris) 37:44.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cea5216a-f680-54a4-80b2-1bb337c4d485','','','Bull. Soc. Natl. Acclim. France 34:394.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a51ce9b1-960e-543c-bab4-9f581ba08aca','','','Fl. N. Amer. 1:627.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cd959c2-cfb2-5877-93b2-2a7b94012e83','','','Prodr. 28.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4317fa8-96a7-5dfd-895e-1f9f678927fa','','','Fl. N. Amer. 1:624.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3816d0dd-67d9-5852-b322-5969e079a2a4','','','Misc. nat. 184.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fcb0f95-aec0-5ed5-a9cf-e1cd200d53fb','','','Bot. Gaz. 18:123.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdc9f416-559e-57a4-b048-92751087370b','','','Gartenflora 47:145.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ace1d0ae-48ea-57ce-ac07-bf7d120ced73','','','New Fl. 2:63.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42f62a2a-65c4-5842-bf71-dc983a2e35f1','','','Repert. Spec. Nov. Regni Veg. 11:555.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96fa99eb-1867-579b-a97b-6018de33438e','','','Monatsschr. Kakteenk. 13:108.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('617a104b-44cd-5336-9cda-87f19199deed','','','Encycl. 3:259, t. 2.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e1a52ae-fcb1-5b15-a7d9-84c3fa3456af','','','Skånes fl. 197.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b866cd14-9203-5b51-bcd4-a4a0731529bc','','','A. L. P. P. de Candolle, Prodr. 10:374.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84b4205d-2bfe-5dde-9a8a-7e378fcaf009','','','Bot. Mag. (Tokyo) 21:31.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('186df14f-f783-5f4b-86f5-843b86a28e45','','','Vollst. Lex. Gärtn. 4:534.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6cbb9c8-7783-54e6-ae5b-e4a8548f4669','','','Bot. Mag. (Tokyo) 37:74.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48937ab3-73db-5e7c-8ee3-be50fd614663','','','Trans. Cambridge Philos. Soc. 6:546.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54aec6b0-498b-5149-a1b2-c396b2497fc0','','','Sist. Zametki Mater. Gerb. Tomsk. Univ. 3:3.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1dcfb541-af19-5ca7-9337-26df8a4f8d38','','','Univ. Calif. Publ. Bot. 64:11.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e78fc5d-a3bd-5707-bff6-a99bc0cee267','','','Beschr. Bot. Gaert. Breslau 82.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3c8cce4-850c-5704-9545-609b6de1efdb','','','Iconogr. pl. As. orient. 4:395.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f73093e1-ee01-56c5-aafd-cbac6f1be038','','','Sp. pl. 4(2):826.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a6926dc-3792-52e6-9907-63836f2eb55b','','','Izv. Bot. Sada Acad. Nauk S.S.S.R. 30:357.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('624726ce-2697-57ca-ae56-7dfb0d16fbd1','','','Dominion Mus. Bull. 19:33.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20daddcc-d372-5d3c-8286-f4593a9f16fd','','','Bull. Herb. Boissier 7(app. 1):75.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc6b260b-a186-5bb2-8244-12d145ebb875','','','Rep. Bot. Soc. Exch. Club Brit. Isles 7:771.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2569686-e8db-5c77-aef6-1a946203c2f7','','','Suppl. pl. 282.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b91dc44-1564-579d-bf80-f60601658503','','','Prodr. fl. nepal. 71.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('673c0812-4f91-52a6-8f72-9d5c24a707a2','','','Bull. Acad. Malgache sér. 2, 6:162.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a900fc2b-f16f-5533-a08f-ed0c78984e65','','','Succ. Euphorb. 1:397.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eda000ad-351b-5325-8578-d1032431ae34','','','Bot. Gaz. 12:160, t. 9, fig. 84.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7be4adc0-2185-5d73-82b9-dd98a8afbefe','','','Syst. veg. 5:140.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51920839-9007-50cc-9b8d-fc6b7fe67f31','','','Bull. Torrey Bot. Club 62:384.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31959387-cb63-5e8e-91d2-37aa9cf7760c','','','Kulturnaya Fl. SSSR 1:289.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d233ce3e-c67c-554f-92f0-d079c7bf787c','','','Linnaea 17:282.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a93ae142-b050-5143-b9cd-e893014ea165','','','Gard. Chron. ser. 2, 11:334.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5be4608b-2e55-55c0-9bca-c7f86df54e75','','','Proc. Amer. Acad. Arts 11:101.  1876 "<I>brandegei</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee765f7a-168a-50eb-8284-9febc52eaa05','','','N. Amer. fl. 22:284.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14619b2e-4ee3-5315-b9ee-2cc5aee8f634','','','Symb. bot. 3:40.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9739e1b6-a073-5034-b88a-d4989737b755','','','A. L. P. P. de Candolle, Prodr. 10:462.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('387bc384-ce87-5b81-9957-1cce61a0851b','','','A. Gray, Manual ed. 7:707.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc15d758-9092-56e6-8c9d-53bf4aac5559','','','Pl. bras. icon. descr. 1:20, t. 12.  1826 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24960a71-240b-5375-9ed2-233ab3661d96','','','J. Linn. Soc., Bot. 22:290.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c14b0962-a192-53ee-b120-8c66890e7fcb','','','Sp. pl. 1:77.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7569907-36fc-5386-a5a8-673b09ebf0f0','','','Fl. Aachen. Beckens 2:275.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d64b84e-7f1d-5f54-af04-b4294dec2855','','','Fl. angl. ed. 2, 1:154.  1778','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cc0367d-2abe-5161-bf3f-0bdc674c5e7f','','','J. F. Klotzsch & C. A. F. Garcke, Bot. Ergebn. Reise Waldemar 122, t. 16.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24101cb5-daea-5556-b93e-3bd1da23fd32','','','Fl. peruv. 2:19.  1799 "<I>subsagittata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('908e345c-37ac-5790-b909-c80e65b29547','','','Fl. N. Amer. 1:355.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88f96eac-923f-5dd5-a9c0-f044b2a0e01c','','','Arch. Bot. Mém. 7:78.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df0e8bb9-a749-59e2-a0bd-34f1e280289f','','','Trudy Prikl. Bot. 23(4):123, 338.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3294b64-5320-5ec4-a760-0bd7e33c0847','','','A. V. Fomin & G. J. N. Woronow, Opredelit. Rast. Kavkaza Kryma 1:299.  1909 "<I>schelkownikowi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77281792-ebf6-57cb-83fc-0c37b50f998b','','','Rev. Hort. (Paris) 57:546.  1885 (P. Mouillefert, Traité arb. arbriss. 2:982.  1896)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb25ea0f-468a-5656-bddb-9ba689e964a2','','','Repert. bot. syst. 2:9.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd005f1b-d72d-58d1-8438-64e1cb976e6b','','','Nomencl. bot. 59.  1831 (ex Fresenius, Syll. Pl. Nov. 2:232.  1828, pro syn.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04ee4b9e-4203-59ad-a647-edb319517674','','','Bot. Beechey Voy. 152.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3098983-cdbb-565d-9192-d049b2ddf73c','','','Orchideen 207.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bd49503-3f03-514c-98ce-380d9456cae7','','','Mém. Soc. Phys. Genève 9:97.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('619bd62f-2fc1-59ae-a2eb-07fa9567d470','','','Species lupinorum 29:462.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c35cdb44-4512-5763-83ee-28e97fd0af0d','','','J. Jap. Bot. 13:309.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cc7d744-8702-516c-8c06-9265b66eef12','','','Weitenw. Beitr. 2:30.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('499ec3e6-b14d-5c23-b727-199a51384bd7','','','Ann. Missouri Bot. Gard. 53:338.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ed70ab3-a3dc-5083-9c24-bbf7cfa57144','','','J. Bot. (Hooker) 4:336.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1e848d0-1936-5762-b970-5f7934311d46','','','A. L. P. P. de Candolle, Prodr. 14:594.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b879d35-211c-5537-9ebd-2b3420b8d92d','','','J. D. Hooker, Fl. Brit. India 1:549.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6f19716-9eb7-5d53-9bca-b35e18efd527','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 44:135.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0faa1c3-8bcd-5ce6-aac1-58c55601c463','','','Oestr. Fl. ed. 2, 1:410.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d9cd6d2-3bbe-5f51-8b68-f63c503512fe','','','Contr. fl. Asturias 65.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a2052f0-1422-53ba-8c3d-4a512d36bd27','','','Cact. 3:24, fig. 24.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57ae57ab-b38f-557e-b4c0-9bd582665959','','','Kew Mag. 4:184.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afc46004-0d73-5cfe-be9d-b378be26e266','','','J. B. G. M. Bory de Saint-Vincent, Dict. class. hist. nat. 3:299.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62aa04d2-1133-50b6-b69a-97331669612b','','','Forest. fl. Port. E. Afr. 98.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fce7267c-51e5-57d6-b0c9-1918c025b149','','','Bull. Soc. Bot. Genève sér. 2, 11:205.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4193d8f-5a49-5026-a22e-032e24aad5da','','','Ann. Sci. Nat., Bot. sér. 4, 1:186.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7587a07-b1cb-5c9e-af70-f2490950c74c','','','Ark. Bot. 22A(3):3.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1bfd9ca-b059-5d4d-aba9-42cd61603f03','','','Bot. Jahrb. Syst. 73:466.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2074bca-dd75-5c9d-9c67-6f4c95c1af1b','','','J. Linn. Soc., Bot. 22:463.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb10154d-b596-503e-b240-a729cf5d0cc0','','','New Zealand J. Bot. 37:33.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07acd982-2ca3-5af1-aaf5-19e391ef8392','','','Wrightia 2:187-188.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee3b23f7-0f31-50f6-874b-8807c6ba292b','','','Sp. pl. ed. 2, 2:1000.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80f76ad1-7dfe-5bbf-8afc-73084dd0a633','','','Hooker''s Icon. Pl. 35: t. 3431.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5f0e49d-daab-5ab2-9751-5fb58d8b05ac','','','Contr. U.S. Natl. Herb. 20:370.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc61e2ef-89f7-5b03-a8d3-0805ed481391','','','Proc. Amer. Acad. Arts 7:358.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8987f5a5-e86c-544c-b142-53d42ef8e239','','','Proc. Amer. Acad. Arts 22:137.  1886 (Prelim. syn. N. Amer. Carices)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c9ca056-d145-5255-9c61-d740c0f82583','','','Labiat. gen. spec. 182.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7509902-d34f-58ae-b3c5-504a146d4345','','','Syst. nat. 1:378.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a89e3a85-0e49-5ac3-a549-e065e1490174','','','Bull. Soc. Bot. France 52(Mém. 3a):19.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92feafd9-a36a-508b-8043-81f57ce8808b','','','Handb. Irid. 74.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1809b40-ef2e-5733-8632-bc23caabc57a','','','C. F. P. von Martius, Fl. bras. 11(1):250.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15c2af1d-3cb8-5bd3-8c58-56e55adce4f4','','','Fl. France 5:37.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82cb7b8d-932c-5c84-8fa8-4ffae5db79d8','','','J. Proc. Roy. Soc. New South Wales 49:313.  1916 ("1915")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71595627-e7a4-5b70-b48c-fa0a2a3d0b42','','','Ann. Sci. Nat., Bot. sér. 2, 7:186.  1837 "<I>Omalanthus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c8acf85-b1a9-559b-8f1f-259f62e712ab','','','Bot. Mag. 78: t. 4628.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32d7ea83-a7aa-556c-8df1-98009f6d577b','','','F. A. W. Miquel, Pl. jungh. 254.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1878aeca-378f-55f8-ba7f-a8d70d694fad','','','Verz. Art. Aloe 7.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72c9ae54-3997-5598-82b3-9c9a7c1e20fc','','','J. Bot. (Hooker) 2:152, t. 7.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6bb9b3e-379e-52cc-823d-765b60083902','','','Revis. gen. pl. 3(3):369.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('626a0c8f-da27-5dd4-ad07-ed8d065f87bd','','','Bot. Mag. (Tokyo) 39:28.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('370af96c-45d2-511b-a078-419b9e79a0ce','','','Philipp. Agric. Rev. 8:19.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c669366d-dabd-5104-bd32-76dd67a3d681','','','Del. sem. hort. hamburg. 1849:9.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28f8ec3c-f021-549b-b728-f1c91f8e4513','','','Contr. U.S. Natl. Herb. 20:14.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24b0e7a4-36f2-5c5a-8437-e5ca056f708e','','','Fl. Tadziksk. SSR 9:526.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('330b36be-6bc7-5bce-8e7d-5f650acc79a3','','','Cent. bot. Anmerk. 57.  1781','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ed75d3e-6faf-56fc-8185-5074962b736b','','','London J. Bot. 3:400, t. 16.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e12516a-b3fd-5f7f-9243-6067ed511dce','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 6:515.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7da8065-fdcb-5951-bc05-31f19b1a8d83','','','Ges. Naturf. Freunde Berlin Mag. Neuesten Entdeck. Gesammten Naturk. 3:298.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a856c63-ae0c-591f-828f-7e1846167930','','','Feddes Repert. 95:489.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd633835-f8ca-55bd-b566-0fa928122a5b','','','Tent. fl. napal. 10, t. 14.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adb34b3b-81dc-5bc3-a856-7147f0fd0cd9','','','Fl. pedem. 2:253.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a03c287a-9188-5118-9312-3872fc2e276e','','','Cact. 5:2925.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a4794fe-95b9-50f1-a987-a1132ca641a3','','','C. S. Sargent, Pl. wilson. 1:86.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1acc3190-e74e-5495-8f85-e11c72b1158d','','','J. Bot. (Morot) 9:397.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bb4ba07-9946-5882-b06c-3acbbe3f9e5c','','','Principes 14:79.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef1aa93a-3f95-5370-ade1-1b199ac4ddd4','','','Bull. Torrey Bot. Club 30:280.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d725a1f-aeec-5de2-88de-0e0c0d91eb1a','','','Fl. Brit. W. I.  503.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2d3238b-d96b-5272-bea6-5e5f022612b7','','','Bol. Soc. Argent. Bot. 24:195.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b3d84cf-383a-5c84-9b93-cd4e3ffc1fa2','','','Bot. Not. 122:406, in obs.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6a110df-ade5-5888-8580-bc61ff2a9a58','','','Contr. U.S. Natl. Herb. 24:394.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('657ac8a4-7848-5289-bf6d-ef37d9f9e5c2','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 10:365.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d9e0823-a2fd-5f67-bf06-1abeec786997','','','Lilloa 3:459.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2df9651-4887-5f4f-9ac5-5e599b11f82b','','','Frutic. vilmor. 61.  1904 (P. F. A. Ascherson & K. O. R. P. P. Graebner, Syn. mitteleur. Fl. 6(2):139.  1906, pro syn.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5397dfd5-3097-5403-bcc0-6b7f28701586','','','Torreya 13:15.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29281b03-175e-5222-8491-a448bab09799','','','Cat. pl. Cub. 170.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14b59196-7b80-523f-85d1-91886afaad95','','','Kew Bull. 14:415.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3966ee12-892c-5c7b-a45c-b5d7e73b9f3f','','','J. Linn. Soc., Bot. 18:54.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('121b91df-9633-553b-b91b-07f82787bea5','','','Hort. Reg. & Gard. Mag. 1:460.  1835 "<I>Duchesnia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d49e691-4368-5e41-8d46-696d5107ca0a','','','Cent. pl. Ross. merid. 3: t. 77.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e98d0e7-c70e-564a-84c3-1f0c9115eafa','','','J. F. Klotzsch & C. A. F. Garcke, Bot. Ergebn Reise Waldemar 65, t. 99.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ec1ab0d-b21a-5e51-bb75-36880f196728','','','J. Proc. Roy. Soc. New South Wales 51:457.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb1e05ed-189d-5535-a031-1a2fbbbde813','','','Water Gard. J. 5(2):17.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2830286-7fe6-5738-8dfc-56ef89646c04','','','Fl. bor.-amer. 2:72.  1803 (non Vahl 1791)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6be56352-6231-5562-8cb0-84b6c5887b67','','','Ann. Jard. Bot. Buitenzorg 42:214.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d27b1156-ac71-58a1-ac7f-fe5343c5a95a','','','Ill. dict. gard. 4:141.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9697f104-66ea-5129-a17f-ece7bb03d467','','','Leafl. W. Bot. 5:121.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04f3c7b8-9504-59e7-b96e-2831f3b0935c','','','J. Schlauer & J. Nerz, Blumea 39:141.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09e549ad-f0b8-557e-87e6-84d1f77f6336','','','Mém. Soc. Linn. Paris 6:317.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f54481e-f695-51e1-b2d0-5cb17abc5e9a','','','Acta Mus. Richnov., Sect. Nat. 12:12.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b669f27-4106-5a29-8ab8-c60b31dfde7b','','','Encycl. 1:548.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa92813a-5eb3-5351-8d1d-e6171f300702','','','Bull. Reale Soc. Tosc. Ortic. 5:401.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e1b6349-cc5c-5e87-b296-fab56fb75f7a','','','Pl. asiat. rar. 2:7.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('787c1551-33db-572d-9104-0086396246a5','','','Nuovo Giorn. Bot. Ital. 15:186.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a84ab672-3df2-5cfb-9520-4bd82de638b7','','','Rhodora 49:141, t. 1061-1063.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74ed3755-49a6-5528-a7d1-7847767214aa','','','Fl. deut. Volk. 713.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e896ff33-561b-5538-a072-2cbc7de88e59','','','Gard. dict. ed. 8: <I>Valeriana</I> no. 11.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16793004-901d-5e55-876c-e7edfeb5ce9e','','','Fl. Brit. W. I. 593.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c56f7722-99fa-52ed-8511-a27a386f7655','','','N. Amer. fl. 25:272.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb48c373-34de-59ce-9a07-8cf3e35c741f','','','Nakai, Fl. sylv. kor. 21:18, 21.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d34ce2a-81f7-5bef-8086-872aba59d10f','','','Flora 67:677, 679.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa02dc6c-7503-5f5f-998b-c8a2fcd85b90','','','Collectanea 2:104, t. 3, fig. 1.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9e5d2b5-7a5c-5afb-90e2-730160a574e0','','','Cact. Succ. J. (Los Angeles) 71:33.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c607ae9-3879-5d8b-b7ef-65748c252835','','','Proc. Amer. Acad. Arts 21:385.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16e35f2f-4954-5bf8-b906-6afdca3131a4','','','Contr. New South Wales Natl. Herb. 3:241.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b981207-8355-597e-95d4-cffe68b31168','','','Ann. Gén. Hort. 19:39, fig.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e06bd08-7c38-5959-baf1-169dbf5ff33c','','','Pollichia 16-17:86.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2290549d-40a1-58f0-be5b-956f896ac882','','','Consp. fl. eur. 182.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6954207b-7b9b-5080-896b-f082bae410ba','','','J. Bot. 20:258.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('824c3844-befe-5324-bae2-a66094db85e8','','','Torreya 42:9.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb57485a-0529-57fd-932b-8a6eff7f12d9','','','Arch. Jard. Bot. Rio de Janeiro 3:96.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed736402-286a-54c8-bea0-b6c221fe5675','','','Fl. Iranica 63:8.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ffe537b-659c-5905-8a61-c421a244d032','','','Bull. Écon. Indochine 13:857.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36f9ed9a-ef42-533d-b038-c9ba201f9ca7','','','Bot. Not. 128:520.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('391f8796-5dbd-539e-9184-ae37e1142b00','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 4:66[folio]; 4:85[quarto].  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a98b0d11-c0e3-5b90-a0e0-3f2efd10937d','','','Summa veg. Scand. 7.  1845; Symb. Hist. Hierac. 112.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1e7735a-900a-5154-9d64-4165a29ebe05','','','Stirp. nov. 151, t. 72.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed61be69-e307-5cb7-b928-404784784099','','','Nova Guinea, Bot. 7:96.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('002da9d6-c968-5133-8db6-bccab5b221bb','','','Ann. Missouri Bot. Gard. 20:707.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d81a6e1e-c54f-5b13-9f1e-812a7cd02505','','','Mitt. Geogr. Ges. (Thüringen) Jena 6:32.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e412eef-fed2-5a64-b4f9-d7ca6ace0e94','','','Syn. pl. glumac. 2:205.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a93d2f40-3cdc-59d8-bc00-6c9daa5bdd30','','','Fund. Agrost. 58.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e635d5c-c4e0-597f-baf6-1f455c46074c','','','Agronomía (Lima) 27:244.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64c81640-62bb-5503-b32f-b5109782ec2f','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 71:59.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a29dbdcb-c5f0-5857-bbb3-aefbc8cb1264','','','Enum. pl. China bor. 55.  1833 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 2:129.  1835)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4a3b49e-1a16-5182-8657-c9c386ffc017','','','Fl. pl. South Africa 14: t. 532.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25e9ce91-8900-50be-93dc-7c19b7c1d6c4','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 34:33.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a60cba4-8649-56f4-9a89-5677653ac5a3','','','Proc. Rochchester Acad. Sci. 4:51.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a5f2d60-9dc2-584d-9ec5-7ef8c037edfc','','','Ann. Sci. Nat., Bot. sér. 3, 13:151.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('930c5c56-5a13-521f-8c24-95bdb944a77f','','','Leafl. Philipp. Bot. 2:735.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12e82a9b-5588-532b-a8bc-5c2197348a4b','','','Contr. W. Bot. 11:20.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45f13d5c-63b1-589e-bdfe-6028736d6074','','','Prodr. 15(1):86.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35d3647a-c226-5abd-91ce-52fb4fc82559','','','Gard. dict. ed. 8: <I>Cereus</I> no. 1.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6c482ed-e95a-5c11-a40a-8c2785967a42','','','Fl. Ind. occid. 1:220.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7aa01337-8794-5542-a247-e1f52bcf7ec9','','','Notes Roy. Bot. Gard. Edinburgh 13:3.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81413828-69cb-5f76-b46e-c5a13a189662','','','Revis. gen. pl. 2:418.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27dededb-c1af-566a-ad39-1144dbb1b303','','','Ann. Sci. Nat., Bot. sér. 5, 17:130.  1873 (Cat. pl. hort. aksakov. 105.  1860, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccbe4293-5166-5e9f-bbc2-40ca7ce08979','','','Univ. Calif. Publ. Bot. 55:67.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5923e1d-e93d-5f38-9a61-673f070c0011','','','Mem. Torrey Bot. Club 5:240.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c53f9454-db9f-5419-a758-d42bd95dac7b','','','Brittonia 31:109.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02bde469-8ef0-5e4f-ac70-cf17e90b673f','','','Reinwardtia 5:60.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68101699-a1c4-5c60-b8be-3c5bde6cd3af','','','Sp. pl. 2:724.  1753, nom. cons. "<I>helvulus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a75219f-7496-5ace-b8e0-fadfdca85e7f','','','W. C. H. Peters, Naturw. Reise Mossambique 6(1):276.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2796a89d-6ced-5bbf-b629-4171c5f0d471','','','Čas. Nár. Muz. Praze, Rada Přír. 152:19.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7a4228d-d24f-5f15-aca4-bfe72bfbfb8b','','','Nov. stirp. pug. 2:7.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('467965b6-c3ec-5e61-a1d5-90c8378ff018','','','Lingnan Sci. J. 15:419.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8dec86ae-8a42-5e79-86d8-f61fee434fba','','','Beih. Bot. Centralbl., Abt. 2, 58:257.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0fd8a27-581f-5650-bbdd-251793c01d68','','','Acta Sci. Nat. Univ. Sunyatseni 30:81.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77a7d887-3931-54b0-999f-42a4b64df14c','','','Contr. fl. Paraguay 1:30.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a676647-ecfb-57c0-b857-310d23793031','','','Trans. Linn. Soc. London 2:327.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('414dd578-067c-5b94-aafd-0bcc3cc6720d','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 19:250.  1874 (Diagn. pl. nov. jap.) (non Michx. ex Steud. 1821)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f65708ee-53ba-52b5-b991-a952bd8510a3','','','N. Amer. fl. 24:204.  1924 "<I>Sesban</I>" (A. W. Hill, Index kewensis suppl. 7:223.  1929; Cory, Rhodora 38:406.  1936)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('446fe285-81f1-506e-a0f4-a0f574cdc023','','','J. J. Torrey & A. Gray, Fl. N. Amer. 1:375.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0049728-96e4-5b3c-be1a-7041d52432c5','','','Bot. Zhurn. (Moscow & Leningrad) 62(6):824.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4b05f37-307e-525f-8b90-987883459b12','','','Hooker''s Icon. Pl. 1: t. 9.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49fa9c5b-cfdf-59e0-bc26-829b78119a8a','','','Madroño 8:196.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93072992-bd0f-5b97-97e2-040c5abbc4e0','','','Man. fl. pl. Calif. 943.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dc7ece9-e437-5f88-8a0a-d3cef479b0a9','','','Bijdr. 246.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcbcf5e1-5b36-59a0-8be1-83d300a80a59','','','Labiat. gen. spec. 332.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b7771e4-d556-514c-9667-fbd82709d293','','','Bot. Jahrb. Syst. 37:579.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fca0b4c5-4fd9-5442-93d6-3bafdd78205b','','','Hist. pl. Guiane 735, t. 294.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67b4fd65-07a7-5693-8058-cf552e315297','','','Mant. pl. 1:75.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3fe374f-c8d4-59ca-b36a-35a61f7f03d9','','','Bull. Bot. Lab. N. E. Forest. Inst., Harbin 5:82.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34c1d59c-d9f3-5d36-9892-463c3d30d2ba','','','Bot. Jahrb. Syst. 106:366.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67c3d678-67c8-5e29-9ea4-fb3253a1f25a','','','Proc. Amer. Acad. Arts 21:408.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51668a31-a98f-5ef1-9450-b10ee097904b','','','Reise russ. Reich. 3:752.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('feee12a4-490b-5576-a76e-d744e1056855','','','Bot. Gaz. 40:65.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('180dc03a-ea75-5318-9008-a9890ab1ee18','','','Madras J. Lit. Sci. 5:15.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43dda768-6d5e-5d35-8dd9-1915c02e7e76','','','Ann. Lyceum Nat. Hist. New York 1:326.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71c5c984-e229-5b2d-b428-84e6cd79ed27','','','Oesterr. Bot. Z. 9:101.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9a7f7ce-44b1-5a8c-a8b5-16e1d181b306','','','Proc. Amer. Acad. Arts 3:54.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34b4258b-4baf-58c4-9ada-b47819ca9114','','','Encycl. 2:89.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2d86d1d-1272-5a43-ac8e-af16fb542035','','','Ann. Sci. Nat., Bot. sér. 2, 4:272.  1835 Nov "<I>Calylophis drummondiana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dea05f06-c071-5827-a3b9-6b5af5b1844d','','','Bull. Acad. Int. Géogr. Bot. 11:297.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a1ccdfe-7c3d-5c37-8382-33ce2e5cd6b1','','','J. Linn. Soc., Bot. 53:98.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41c0d87c-b848-5595-a3b2-3485b9a247b6','','','Descr. Egypte, Hist. nat. 79.  1813 ("1812")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f86b569-73c0-525e-9b18-122b88562173','','','Die Gattung <I>Lycianthes</I> 408. 1919; Abh. Naturwiss. Verein Bremen 24:408.  1920 "<I>mociniana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b742f14a-c3d4-5c70-aa9d-44c7e16862de','','','Bull. Torrey Bot. Club 27:620.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a81a06a1-ce64-5811-8f56-73de0e2a5c86','','','Rep. Bot. Soc. Exch. Club Brit. Isles 6:172.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4371202-1739-5954-8f8b-96118efbdd25','','','Die Gattung <I>Lycianthes</I> 439. 1919; Abh. Naturwiss. Verein Bremen 24:439.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68dcba3b-c517-5d89-9227-c4111d2c9db3','','','Wulfenia 13:93.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d749be7b-9f72-5c70-9c41-272fe1216a9f','','','Vaste Pl. Rotsheesters 92.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b16154da-354d-554c-bcea-acbd1ff8d9e1','','','Philos. Mag. J. 62:455.  1823 (D. Don, Trans. Linn. Soc. London 14:326.  1825)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75874d62-00e6-5d5b-b9a3-d4aa7bde2c60','','','Icon. Pl. 3: t. 291.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3a325b1-cfaf-5d32-89c9-1753c24e5e63','','','C. L. Hitchcock et al., Univ. Washington Publ. Biol. 17(2):472.  1964 (Vasc. pl. Pacif. N.W.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebce4ac5-b79f-5008-8f1b-f329312a7082','','','L. Bailey, Cycl. Amer. hort. 2:975.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dca69781-43d6-5c4f-929a-909c706a2f81','','','Beih. Bot. Centralbl., Abt. 2, 49(2):52.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ad01aae-44f1-51b0-b65c-f9fa8daa64b6','','','Hooker''s Icon. Pl. 23: t. 2288.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c048e7ed-e2f7-5097-8bfa-718cee8d54d3','','','J. Arnold Arbor. 5:58.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2223e35a-00df-5068-8bb8-5cf9c9229cdc','','','F. E. L. Fischer et al., Index sem. hort. petrop. 9(Suppl.):9.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90bd525d-be94-5bf6-92c5-a895f3a373c6','','','Repert. Spec. Nov. Regni Veg. 50:138.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aea16dfb-eb8c-5e87-88e0-1987a8f129b6','','','Bot. Jahrb. Syst. 49:426.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce8be611-796a-5a45-80e5-b7173231d718','','','Fl. N. Amer. 1:517.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3a45d50-2e34-55d7-8f86-703db9de393e','','','Parad. lond. 1(2): t. 67.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b09399dd-1738-5970-b2b3-685772947fb7','','','Bot. Mag. 108: t. 6605.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f66e7fa-1f88-58d3-94b2-3d4b3f8be474','','','Hort. dyck. 335.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07f3c912-9f66-530e-80d7-d72ee2c1b9a3','','','Gentes Herbarum 5:666.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e769d22-1795-5bee-8c8a-dac72ce5acdc','','','Contr. U.S. Natl. Herb. 1:34.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('941461a6-5fc6-55c1-8b2e-b4d0846d912f','','','Fl. jap. (Engl. ed.) 1440.  1965 (non Sennen 1927)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2469dcd-4028-52f3-8ce7-e120b48ade61','','','Gard. Bull. Singapore 54:68.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2712ad1c-066e-5732-ab7d-de1f279ac883','','','Cactaceae 5:2738.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39b96c7f-b1c9-5968-960a-84c9d1d89a93','','','Mitt. Bot. Staatssamml. München 10:124.  1971 "<I>rautaneni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a99df3d-7fe8-5a06-9873-01637a9632e7','','','H. G. A. Engler, Pflanzenr. IV. 236(Heft 9):285.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73cdb70c-45d6-5f72-9e1c-a71b05bee630','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 18:63.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4c3d680-2950-524f-9459-172e003ed73a','','','Mém. Soc. Phys. Genève 35:294.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf719c99-68e9-572c-b56f-699e68b5a230','','','Beskr. Guin. pl. 349.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecb8646a-b959-57f4-acfe-e1084a397b1b','','','S. L. Endlicher & E. Fenzl, Nov. stirp. dec. 7:60.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a901717d-3444-543b-8712-9c3443239364','','','Notizbl. Bot. Gart. Berlin-Dahlem 10:666.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99b10824-0dcf-51f4-ba2f-64bfa37200f8','','','Indian Forester 36:343.  1910 "<I>lycopersicaeformis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac6551ad-35cf-52e2-8941-9f530d5d9db6','','','New crit. Mal. pl. 3:21.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89cf6aff-b8bc-5132-b81e-b783ec26d61f','','','Acta Phytotax. Geobot. 16:40.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2158e643-f12d-52a2-a175-a5e39633ab9c','','','Bot. Repos. 8: t. 494.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59e21e7a-f7a2-5537-b1ba-45c4a055ffdb','','','Edwards''s Bot. Reg. 27: misc. 37.  1841 "<I>Bolbophyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('005b03ee-511e-5b5b-9a4d-30bde876f42c','','','Sp. pl. 2:884.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4c20454-5cb0-595f-b452-90b9688fbc44','','','Spic. fl. lips. 52.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f97ed8e-80a3-5466-a2a6-b2b78eb042b0','','','Bull. U.S.D.A. 622:18.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef51e943-d86d-54d8-8089-9b1ec4296a4f','','','J. Linn. Soc., Bot. 22:465.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d063da35-d775-5e28-ac25-70d11649c941','','','Huck et al., Syst. Bot. 14:198.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a883ff1-443a-5435-8d93-cb8adbe03759','','','Ill. Ind. Bot. 1:109.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('246fb792-1b15-5492-b123-c2dd44e33c87','','','D. M. van Gelderen et al., Maples of the world 232.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55e88405-3c9a-5661-b60e-bd0d39512685','','','Desert Pl. Life 22:99, fig. 5-7.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3664aff9-038c-5806-a2da-6c1b8500cec2','','','Prodr. 2:322.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aef6d1de-d222-56c8-b0c5-229913ba2b69','','','Beitr. Fl. Aethiop. 18.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a190f1d8-ee92-5804-8f7e-4ec108abde57','','','Proc. Amer. Acad. Arts 35:545.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2c14f7b-c1db-5085-8f62-88e248bc385c','','','Index sem. hort. dorpat. 1820:5.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d65b397c-8570-51ad-b0d3-3ffa8258c8fd','','','J. Lindley, Edwards''s Bot. Reg. 19: subt. 1257.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27267556-2aad-5a9e-b76f-bce6c6650a88','','','Acta Phytotax. Sin. 8:231.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1bcd459-9a10-540d-8ea5-2e623ba8a140','','','Trans. Sapporo Nat. Hist. Soc. 4:99.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8f83245-b1f2-5ccd-ab82-7d3ad692f1c3','','','Fl. austral. 3:498.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('260c6e21-413e-597a-80ba-f6669db26788','','','G. Bentham, Pl. hartw. 342.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e924f7b-ac22-5d24-9abd-3b78e9fa66d0','','','Kulturpflanze 26:271.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e751b62-3ea3-5321-a35b-3f2aa512641a','','','Bull. Torrey Bot. Club 100:89, fig. 4.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae14d12e-e561-54c3-9e20-8ea5a040ca1d','','','Abh. Königl. Ges. Wiss. Göttingen, Math.-Phys. Kl. ser. 2, 13(2):58, 68, t. 16A, fig. 10.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee65a194-8398-524f-8bc6-2b72defcdc16','','','Ann. Missouri Bot. Gard. 77:576.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b08d949e-c0a6-5340-a42e-287a416c7b91','','','Proc. Biol. Soc. Washington 35:122.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('072cb766-b3e3-5b12-ab49-24af744a9b4f','','','J. G. C. Lehmann, Pl. Preiss. 1:25.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3817dd24-bf77-57fa-95a2-6500d4a821ef','','','J. Adelaide Bot. Gard. 5:209.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ad50c16-a480-53ca-ad8a-385a864b6240','','','Fl. aegypt.-arab. 94.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0470e0a8-566e-5f6e-a221-839b9e406c98','','','Rev. Blancos Fl. Filip. 19.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2879d20e-46d5-561c-ac5f-ae82d5ae0c91','','','Nord. Karlfaxtfl. 1:369.  1953; Bot. Not. 357.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f20b0273-be16-5280-8429-c820ecbd86a1','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 11:430.  1867 "<I>Stuartia</I>" (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90df642f-2c31-545d-b683-0087c637dc48','','','Sida 1:89.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('949ecaf4-6ac4-58d7-b728-2beee0d994a8','','','Prolus. Fl. Jap. 386.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2299c902-2527-5c28-987c-d6e4b2d16351','','','Bot. J. Linn. Soc. 130:62.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2af4181-6c5a-5ab0-8f24-844e79a1aa47','','','Blumea 19:125.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b889105d-564b-537b-9f98-d8350a7fd9ba','','','Fl. taur.-caucas. 3:597.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c829a451-a407-5fe8-bbb0-eec43a2972e8','','','Fl. orient. 4:245.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('343bb474-fc50-5c34-b8a6-11a2482f2b99','','','Fragm. 6:85.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1dccbac-0b08-52c9-a9c3-176313ffdef8','','','E. H. F. Meyer & J. F. Drège, Comm. pl. Afr. austr. 129.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4328bfa8-ee68-57bb-a057-ec0de20e0527','','','J. A. Murray, Syst. veg. ed. 14:895.  1784 May-Jun (Fl. jap. 276.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f21b893-6ab2-5d58-80db-d62f9e305176','','','Bull. Torrey Bot. Club 51:380.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('816efe15-c57e-5fdd-b559-c63bb3c881cb','','','F. Luc-Cayol & L. Fereol, HortScience 32:915.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26547564-0893-5873-a9a5-475e1d2e300b','','','Acta Horti Berg. 8:10.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bed76aa2-bfea-51a6-927f-f4a53a90d214','','','Repert. Spec. Nov. Regni Veg. Beih. 4:68.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7bfca02-399b-5366-b121-cd7eeec20ee4','','','Fl. bor.-amer. 2:73, t. 160.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9034beeb-dcfb-5ee5-84aa-4183d80a5741','','','Notes Roy. Bot. Gard. Edinburgh 5:282.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bcbfec9-c795-54a4-9cd1-a721518be691','','','J. Jap. Bot. 12:338.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8c63d46-d2ba-5181-bdf2-4097d0db625e','','','Arch. Jard. Bot. Rio de Janeiro 1:19.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5226f75-2158-5598-86da-534d99ce8d90','','','Gen. N. Amer. pl. 1:196.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f6c04e6-0b45-53f2-9e9c-0d40bc4cb073','','','J. Jap. Bot. 71:246.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3877159-fba4-5a66-a014-cf7eb2993592','','','Arb. frutic. brit. 2:1084.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a63c6ea-301f-5538-8ee5-dd56b14a6767','','','Field & garden crops 2:29, t. 40A.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e502fb97-ab1a-5e7b-86bb-f9cd2dd10392','','','Trans. Linn. Soc. London 3:275.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8622089-6502-5575-a090-262a43ce157f','','','Sida 16:6.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2364cdb3-5de5-594a-9848-9323df21954c','','','Bot. Mag. (Tokyo) 44:95.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e32a3d27-ec9c-5491-9228-2d48069d5e0a','','','Mem. New York Bot. Gard. 74(1):70.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('651e4daa-bd68-5ab9-8860-cf2cc233dd73','','','Hortus kew. ed. 2, 3:257.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6a14709-7ef3-5edd-8c56-7b224c40f682','','','Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 5,3(4):168.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdac3d2d-6e07-5c2f-81db-b08b54847614','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 10:340, t. 5, fig. a-b.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ff3d8a3-897d-50b1-a925-a481734b5617','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(8):157.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f57e008-82ad-5d41-81c8-61343ed89f2d','','','J. D. Hooker, Fl. Brit. India 7:234.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b483380c-93de-5399-98cc-325e8d5cf9fd','','','Bot. Not. 1939:693.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cfee019-363c-5bfb-9692-a444552b84ee','','','Astragalogia 211.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b137f13-6a34-5457-8748-39db91065752','','','J. Bot. 13:292.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e75217e-5686-5613-b4bb-d1a0695df9d0','','','J. Hort. Soc. London 2:279.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b68dcd4f-2bb8-53b6-95e5-4bad16393b5a','','','Fl. jap., rev. ed. 1439.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e73f7fa-5e10-5da3-bcfe-1fa5f4b6c57b','','','Bot. Reg. 8: t. 661.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('953cba53-97dd-5a8d-a30c-715e849ddabd','','','Adansonia 8:268.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85ff675e-a398-5259-a5b8-45fbd7296352','','','D. Prain, Fl. trop. Afr. 9:677.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('871674ca-7378-5917-82af-81729bf2c822','','','Observ. pl. nouv. 6:17.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b18f5fe1-1e65-50fa-b17e-738738080a46','','','Kew Bull. 43:230.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c809d29c-8e38-549a-8e86-dacf9fa18a8a','','','Trudy Prikl. Bot. 52:28.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c76b9e15-b00a-5338-9e68-43942c953a9c','','','Cacti of the Southwest 92.  1970, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bb2d4ad-688b-5ff3-b475-e9deccae1f2b','','','Madroño 8:58.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('252a0c46-d76d-5d38-a1dc-861a4f8c76b5','','','Stirp. austr. fasc. ed. 2, 2:352.  1769','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4921147f-1636-5d46-ad4f-5dc19341b3a7','','','Pl. Guian. 1:31, t. 49.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d798c9d5-9449-5286-aca9-93beec920886','','','Mitth. Thüring. Bot. Vereins 11:46.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a951eaf-f922-5f53-a443-21a2c7029ade','','','Arch. Jard. Bot. Rio de Janeiro 12:8, t. 2, 5.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2854cecb-fef0-5970-a8f1-b484a21e27ba','','','Bull. Bot. Res., Harbin 13:122.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8f8d68a-a2c9-5244-81a0-1ff42b0e58a7','','','P. Tchihatcheff, Asie min., Bot. 1:215.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5176cfd-9303-5b31-955a-7e10afbccef3','','','C. F. P. von Martius, Fl. bras. 6(6):288.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f78d6629-4026-5288-ba56-8f79ba9075da','','','Sp. pl. 3(3):1499.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfcb7957-7cc2-5e04-afaf-68401a05903f','','','A. L. P. P. de Candolle, Prodr. 13(1):12.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b13318a-fac8-568f-9e79-14e38b7dbb17','','','Fl. orient. 1:771.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db776a74-668b-548c-b73f-f3bd5902c90b','','','Mem. Torrey Bot. Club 3(3):59.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6105227-681d-5ff9-b079-66ea75985fb8','','','Opera Bot. Belgique 2:85.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d19c3a13-cd2d-5b76-8218-1ff58ace2909','','','Telopea 5:188.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d7019e4-1e09-5e03-85c2-6a5e3d28fb38','','','Kosmos 38:1297.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef966864-9126-579b-adf8-c6bbfa39f5c7','','','J. Bot. (Morot) 10:306.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10ffdc45-179f-5710-91bb-3df0161dfbc3','','','Sarawak Mus. J. 5:599.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f07bc8ac-288d-5a91-be41-46085fd8a0be','','','Pl. hartw. 305.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00438c0b-314f-5050-97b2-af6b3762b6a1','','','Acta Phytotax. Sin. 37:88, fig. 1.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4e49e9e-9de9-512e-b4fe-983908449ab7','','','Ess. Agrostogr. 71, 161, 166, t. 15, fig. 1.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6937400d-5b15-5d90-81da-25ada12b8d64','','','Grass. N. Amer. 2:586.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('236d6099-acaf-523e-a21f-92c1615d96ad','','','Revista Sudamer. Bot. 5:2.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f478a0a6-9239-5362-b244-d0d5a8908b28','','','S. African J. Bot. 112:427.  2017 "<I>duemmeri</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5760d3e2-ee67-5959-8210-169df9b54559','','','Sp. pl. 1:4.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00df2a66-e9bb-5557-b724-aa3b12ff278b','','','Bot. voy. Sulphur 90.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12feb41c-dc0c-5f02-98a0-71016b94f13c','','','Sp. pl. 1:16.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a59eaa93-05a5-5bb0-b9b3-50d2927e9e69','','','Sp. pl. 2:941.  1753 "<I>masculus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff973790-2d98-55e2-a8d8-2537cd21191e','','','Changing genera. Systematic studies in neotropical and West African Annonaceae.  Ph.D. diss., Utrecht Univ. 70.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de4d0ccd-582a-5445-adbe-e961b2b632f9','','','Phytoneuron 2019-39:6.  2019','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae8c5386-a0e6-510c-b4c7-115ba84723db','','','Linnaea 9:206.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e601912c-7018-5fcc-935c-e3bac5e996db','','','J. S. African Bot. 3:93.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2348ef4-30ef-5ce4-b0ff-629636c682b3','','','Abh. Königl. Ges. Wiss. Göttingen 24:297.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b92fa1dc-4dbe-590a-9447-1013200f51aa','','','Boll. Reale Orto Bot. Giardino Colon. Palermo 8:253.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfab4caf-f546-5927-b523-bb9dfc5aa6d0','','','Sp. fil. 3:51.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d28ed340-0994-5b48-b25a-2bf3cf51f066','','','Obraz. Rosl. Król. Polsk. 2:15.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad248b13-02f4-54e4-822e-66a4ed4cd44d','','','Gard. Chron. 1861:23.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bd3db33-1c19-5406-9e00-1ee36f43a74d','','','Tent. fl. abyss. 1:223.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('935d548c-1429-5914-b202-eaf6c3390042','','','Syn. gen. Compos. 266.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe0978fd-02b5-5774-a5eb-b901d2890140','','','Pl. Coromandel 1: t. 78.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7685c531-751b-5552-a972-043c8e3a023e','','','Sp. pl. 2:1077.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d10018f9-4eef-549a-9588-851da6665977','','','Notul. Syst. (Paris) 2:159.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8383c69b-e69c-5645-b900-9b3fd6781669','','','Anales Inst. Biol. Univ. Nac. México 11:81.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cced2dc0-a962-520d-8720-853e4b634b09','','','Pacific Sci. 51:275.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d66a629-8751-5048-aecb-bffd5cd689a7','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 15(1):1.  1869 (Gen. Astragali)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('968e05ab-7e7a-5737-b07f-ae77edc6bcf3','','','Acta Phytotax. Sin. 6:357.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37d8f591-2e38-56b0-aeb2-565e1b933099','','','Arch. Jard. Bot. Rio de Janeiro 1:36.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('642f20e4-cfe6-54d7-b6c4-1c84c8977b1f','','','Nova Acta Acad. Caes. Leop.-Carol. German. Nat. Cur. 68:188.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33b56c22-5866-54bb-964a-ae480769a953','','','Aliso 11:194.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ce7f39e-6cec-5a60-b26b-a54ae6192590','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 16:218.  1871 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd8efc04-c73b-5b5f-bd76-a9423817210b','','','Enum. subst. Braz. 40.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f826d96-8e91-5839-a0c4-30f04e0bb9a3','','','Cact. Succ. J. (Los Angeles) 60:17.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('556aec64-3fe4-566d-93f0-7362a6f876ab','','','Sp. pl. 1:66.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4580c2d-e1e9-59d7-94d1-43e9906a856d','','','Bijdr. 1088.  1826-1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2671fc30-8b78-504b-94c6-f2fbbddb9401','','','Pl. hartw. 223.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d796c03f-efb6-5a2d-9c6d-b599e78aedbd','','','Carniv. Pl. Newslett. 23:104, fig. 2.  1995 ("1994")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f542b9a4-fe87-5373-8060-3cf0b441e58d','','','Descr. <I>Pinus</I> 1:87.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cd85e1f-a32d-54a0-a32c-9dad84cedd27','','','Proc. Linn. Soc. London 2:212.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('113013b7-98ce-5d83-a483-01d6e8967746','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 7:405.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af179bff-a8f1-514f-89be-d0967a6c452f','','','Monogr. afrik. Pflanzen-Fam. 8:77.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28684686-9c6d-54f5-a4d9-67dbbeecb855','','','Blumea 16:249.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e948f253-4f38-571c-b4ef-b436df9f2d88','','','Syst. Bot. 12:242.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e02aa7d-9f11-579b-ac3b-80633235b657','','','W. T. Thiselton-Dyer, Fl. cap. 7:557.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af2f704e-10b2-5fe3-99a6-c077d12d86a7','','','Fl. Amer. sept. 2:392.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('084e9e30-156f-540e-a555-4f545e24db1b','','','Contr. W. Bot. 8:41.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d656cba9-21a6-58a8-bf68-8f2824a98eb5','','','Nouv. Bull. Sci. Soc. Philom. Paris 2:189.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17b9b524-c9c8-5b3d-bf3b-59a681aa57fc','','','Beih. Bot. Centralbl. 15:169.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('797f98c3-8f2c-5d6c-ae64-296f836c6bf0','','','Pittonia 3:56.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bd5eb81-cab3-5e78-acee-7c678484ccad','','','Fl. austral. 3:314.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2313817-34c7-5155-b64d-91af1e74356c','','','Adansonia sér. 3, 26:50.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99e132e8-5e60-5b28-93b0-ef977335335c','','','Bull. Misc. Inform. Kew 1908:69.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a1b2191-755a-53d8-be12-8638df79a817','','','Trav. S. Africa 2:442.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3ec89d8-aab9-57b1-8f04-4fb7a561e8b3','','','Verz. Pfl. Casp. Meer. 142.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a71a57af-87ec-514c-bdae-b026b4660d69','','','Prodr. 2:350.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82e84aeb-c5a7-525f-9be3-66ed6d865b2b','','','Sp. pl. 2(1):326.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86ac6199-b9a2-5d38-ae44-06a13247b460','','','Vict. Naturalist 68:69.  1951 "<I>aureo-nitens</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0072db8f-e467-5bc9-bae5-60eb59ce1e2a','','','Gard. Chron. ser. 2, 15:782.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ed692d0-4082-5b6e-9c95-bdfb67fbddc5','','','Trans. Linn. Soc. London 20:39.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d666b707-db68-5ebf-bf44-8a34f15f32c4','','','Tent. fl. abyss. 1:60.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9143825-ba95-5758-8bec-e873bba35ce1','','','Notes Roy. Bot. Gard. Edinburgh 5:214.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f865a77-2211-5dbd-a142-81e7044d54bb','','','Naturhistorische Skizze von Litthauen, Volhynien und  Podolien 119.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('925c59c8-c4e5-5007-8e1b-28d524faf0fa','','','Bot. Mag. (Tokyo) 48:103.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a39bf98a-de42-56d6-bb0a-e800f4bc6cab','','','Proc. Amer. Acad. Arts 20:372.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbe61c24-9141-5706-a788-084c32d38258','','','Tent. fl. abyss. 2:264.  1850-1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e86c0753-6092-53c7-a55b-5ad007de5a69','','','J. Jap. Bot. 37:279.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bbb29ee-5831-53b2-a1c6-03a438b450cb','','','Oesterr. Bot. Wochenbl. 7:53.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4694ca1-b229-5b8b-a4f2-4826c88f8d27','','','Flora 24(1, Beibl.):25.  1841 "<I>auriculata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a234046-147a-5645-8fbc-4b5bb332b6e9','','','Elench. pl. nov. 90.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('082f7d33-9727-5017-83d5-1c2a8d25cb7e','','','Fl. portug. 1:119.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab70c78d-9c2d-5a40-8d91-e07b57ca5d1e','','','Prodr. 15(1):306.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdc132b7-20dd-5544-b94b-59ec25bca7d3','','','Bull. Soc. Bot. France 66:218, in clavi.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45603d34-060b-56a1-a8af-1249ee8f3258','','','Züchter 21(1/2):56.  1951 "<I>griseoleuconcompactoides</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82cff00f-076d-5b8c-b503-fe5f4a7e670d','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 4:105.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7784230-c04b-57b9-8c55-dfa94205361e','','','Bot. Not. 1933:1933.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4058d693-b5e9-5260-b213-203755120cbb','','','Proc. Amer. Acad. Arts 7:398.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba45765f-f59e-5fe5-ba1d-f646e060109b','','','New Zealand J. Bot. 25:103.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5bdfe90-cd45-5129-af54-aae537ae0601','','','Phytologia 49:46.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54b41985-dafb-51f6-adb5-1d8614d70fc7','','','Bot. Mag. 61: t. 3340.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08983056-8366-57bb-b0ce-9ff791ff6659','','','Sp. pl. 4(2):906.  1806 (non Berg 1767)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a0bb283-55d6-5e82-9aee-1af1a361f5b3','','','Trans. Linn. Soc. London 1:163.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('520437ca-b0da-51ba-b187-817f056b3937','','','Bull. Soc. Bot. France 33:452.  1887 ("1886")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41752b97-3f46-56a6-bf12-cbb35444ec85','','','Rhodora 43:619.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b85918d-d381-5e7b-aaf4-e8c7c945c26e','','','Mém. Acad. Imp. Sci. St.-Pétersbourg, Sér. 6, Sci. Math. 1(1):82.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc05b019-c9a8-56b6-ac01-713f8233a7f2','','','J. Linn. Soc., Bot. 58:272.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('343d20ca-7b70-57b8-801b-323d4d8821ec','','','Selbyana 2:198.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b6b3cb9-ca7a-5d4e-983b-d941c8864a36','','','Fl. Brit. W. I. 288.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('425e584d-53cc-5f8e-bd51-8c28034fa44e','','','J. G. C. Lehmann, Pl. Preiss. 1:15.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2226448b-5bf2-56a5-9030-72d37ef2e783','','','Linnaea 7:70.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3636101-1e27-5b95-bbd6-4e32dc4d25b6','','','Repert. Spec. Nov. Regni Veg. 20:330.  1924 Oct; Rep. Bot. Soc. Exch. Club Brit. Isles 7:237.  1924 Nov','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2d2672a-2d98-5fed-91eb-d05c02e700f9','','','Voy. Bonite, Bot. t. 37.  1841; t. 60.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06f1ae46-e159-5633-b333-2fe90fbe9aa2','','','Ann. Sci. Nat., Bot. sér. 4, 11:117.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('faae7acd-9a5a-568d-95b3-abcbd28b8c34','','','E. Jahandiez & R. Maire, Cat. pl. Maroc 3:784.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77003160-e2a2-517b-bb42-f02b5720888b','','','Bot. Univ. 2:238.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('653024b2-ec66-5616-8034-e098f8a1b373','','','Monogr. Digitaria 560.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79079adb-b9c7-58e7-ab70-b9190e3189af','','','Syn. pl. 2(2):402.  1807 (Zuccagni, Cent. observ. pl. n. 85.  1806, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('612d7faf-faa2-5f3c-85a0-3b328086368e','','','Sp. pl. ed. 2, 2:1483.  1763 "<I>polydactylon</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5469e028-b5d3-56be-a5aa-c5d07da14e4b','','','J. Jap. Bot. 17:127.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9edc6ee8-59d1-5c71-9672-6ed33fbd38cd','','','Handb. Conif. 35.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e12ee6d1-faed-5172-957c-e4b6e76ebed6','','','Bot. Zeitung (Berlin) 5:245.  1847 "<I>Amazonum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57f938e4-d563-5cc4-8dd2-9b0b1e1e9caa','','','Gard. & Forest. 4:519.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c1ec909-3ed0-5523-a25a-eb60e5f52668','','','C. F. P. von Martius, Fl. bras. 12(3):241.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54e63105-af5c-5446-84b7-0bc3e9d88bb4','','','Arch. Jard. Bot. Rio de Janeiro 1:9.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2e6cd78-dda6-5f60-965f-11efd7d971e5','','','Symb. bot. 2:20.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47157ab0-13fb-5127-aedb-c17e2075e182','','','Las papas de sudamerica: Peru 1:838, fig. 363.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('211e6a29-b5fe-53b7-82f9-86c86240f0c1','','','Anales Jard. Bot. Madrid 50:146.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da05efb1-9bfd-50bc-bdb1-3684c4a29101','','','Natuurk. Tijdschr. Ned.-Indië 17:245.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3f800c7-711c-5932-911a-fdf3e9235270','','','Bot. Gaz. 67:223.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('646958b4-2bc6-5d14-b757-9477a1c65c71','','','J. Torrey & A. Gray, Fl. N. Amer. 1:88.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d061c85-84c0-5c7b-b3de-54131dbf39dc','','','Enum. pl. hort. berol. alt. 1:76.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('917b8b35-b589-59e8-a0dc-7b8de66f8ce0','','','Fl. Amer. sept. 2:741.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a3d7987-6c55-5df3-a1a7-0739304e38ce','','','Veg. mater. med. U.S. 1:123.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('741c660c-b03f-5842-b769-8d2de348f360','','','Gartenstauden 2:947.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f3617af-0d4d-5a32-bc83-662fc08fbbb7','','','Mus. bot. 3:260.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ce0df75-dcd5-58dd-9bf5-1f1b37d6ecff','','','Icon. pl. formos. 5:128.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a20cb36-6924-565a-9ec9-bd150dcf1624','','','Allg. Gartenzeitung 21:126.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d415a13-57e8-51ce-825c-06a20902ec89','','','Icon. pl. rar. 33.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('348b4a2f-8089-5c83-991c-cf31cc12da83','','','Arch. Suikerindustr. Ned.-Indië 42:229.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbd5340c-d91f-5ac4-a8c1-5252df41d53b','','','Tabl. encycl. 1:175.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b293ab5f-6396-55cb-8210-0e41ac4d96dd','','','Icon. pl. med. 6:29, t. 534.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a23b2a5f-3d4d-5428-8552-7b2c009bfda3','','','J. Bot. 11:367.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1a25a27-f429-5c27-a7b3-c8aafe54036f','','','Prodr. syst. Aroid. 214.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d24c29f-b787-541f-99d1-8f71ac9219c1','','','Bot. Gaz. 27:452.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bc57cb5-8bfc-5467-8b3f-8cd942071253','','','Man. grass. N. Zeal. add. & corrig.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b871224e-9319-5786-a21c-7355e4f188f5','','','Bot. J. Linn. Soc. 133:57.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6ca31fc-1ba5-501b-a91f-c66811991f29','','','Contr. W. Bot. 12:25.  1908 "<I>watsoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e943e24-30e7-5418-92ba-b2de83a3c6bd','','','Arq. Univ. Lisboa 1:284.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72b803ce-e14c-58f0-aabe-ae660a3fd4b7','','','J. Linn. Soc., Bot. 35:313.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac51805d-36f6-534b-94f8-cbbf0018fe71','','','Enum. pl. 5:436.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee7ca77c-192b-5d32-83b4-a14747440bd3','','','A. L. P. P. de Candolle, Prodr. 11:165.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c91fc1a-1d23-5b65-b0ca-2ef3d78c79b5','','','Gartenflora 42:378.  1893 "<I>Salix purpurea scharfenbergensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07c17392-9a86-5d2f-82d0-03738d223d20','','','Lindleyana 5:209.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abbdbf46-3f8c-514c-bbab-09954613f61f','','','A. Degen, Fl. veleb. 2:569.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd5434ab-8571-51c5-a240-65f76447e9be','','','G. H. K. Thwaites & J. D. Hooker, Enum. pl. zeyl. 98.  1864 (non Moon 1824)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8f5d654-3841-5997-95cc-0e0f184b393b','','','Nomencl. bot. ed. 2, 2:403.  1841 "<I>nepaulensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6995c50d-7719-5070-8c5c-7828f695b3cf','','','Tent. fl. abyss. 2:398.  1850-1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8b40832-72f9-55dc-ae9d-d4f92d6145fd','','','Pl. nov. Amami-Ohsim. 12.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2251f8d-ee77-50c8-9cbe-558282a68b0b','','','Anales Ci. Nat. 3:46.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a88fb409-f575-5d81-8649-172bbaaeeab3','','','Repert. Spec. Nov. Regni Veg. 17:125.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51a8825f-2db1-56bc-b0c1-326d0b0c8e4e','','','Blumea 14:316.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c0443e7-6776-5c77-aeef-2e2155f503f6','','','Revista Acad. Colomb. Ci. Exact. 16:73.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd777785-4f2c-5c06-842d-cd2409737019','','','Tabl. école bot. ed. 3:389.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17bbdd10-ceff-5a32-b200-9d864eb348fd','','','Nat. Arr. Brit. Pl. 2:157.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f3325eb-425f-567f-a8d7-e803e6114c52','','','Edwards''s Bot. Reg. 30: sub t. 46.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d06ff39-b2c0-54fc-a55f-325b0c7db962','','','Diagn. pl. orient. ser. 1, 7:127.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72e0390c-261c-5245-b045-3adc955fb6ef','','','Salic. eur. 17.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77db9566-30fc-57eb-9797-2f4abcd708d7','','','Nouv. Ann. Mus. Hist. Nat. 4:393.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71281a74-97ee-5b07-a551-55c5aaa22129','','','Gen. sp. orchid. pl. 528.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3633d9e6-7652-52a6-a919-56b614d55b7a','','','Revis. gen. pl. 3(3):83.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01cfaedb-1e7a-5235-b251-e90e7cb2c97f','','','Sp. pl. 4(2):874.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1291d8b4-297a-5f73-b533-5c73dc609a9f','','','Syst. veg. 4(2):162.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7d3d8f9-2dc2-5198-82c5-c4c46fb2b7f7','','','Fl. Neotrop. Monogr. 13:170.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af0e9d2e-4c16-505c-94d6-e18ccfc3441e','','','Trans. Roy. Soc. South Africa 3:297.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b74fdd3-8656-52eb-b287-802973079793','','','J. A. Murray, Syst. veg. ed. 14:889.  1784 May-Jun (Fl. jap. 149.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('915ab29a-c0b9-5b4a-aa2c-9d13444bc67f','','','Hortus kew. ed. 2, 4:350.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('facb6284-a896-5085-a88a-42dcad5e2e1a','','','Trans. Linn. Soc. London 17:440.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('547efa45-e5d4-5ac4-905b-ddb9d80e3461','','','Gard. dict. ed. 8: <I>Gladiolus</I> no. 2.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c36de17-49dd-563d-b366-bd2b98eeff30','','','Beitr. Fl. Russl. 309.  1852 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 7:485.  1854)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f275104-31b8-570b-855d-2c57ef337556','','','Austrobaileya 6:573.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ef4f08d-55db-5d0a-a055-9235a15b024f','','','Enum. filic. 162.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3244649-411d-5ff5-b4f2-eb7f274ce6fb','','','Brit. fl. gard. 3: t. 209.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40946781-2728-57a7-bac0-417b2107f396','','','Gartenflora 46:393, t. 1441.  1891 (Gard. Chron. ser. 3, 16:718.  1894)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd86bfd3-c753-5248-8cc0-25e0f1d8a5b7','','','D. Prain, Fl. trop. Afr. 9:183.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0daf4df7-bef4-5b3e-803b-27d089fa7c12','','','Bambusées 25.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2017b426-9182-53f0-ba2d-8169a1105f19','','','Ionc. pl. formos. 3:12.  1913 "<I>cepharantha</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1a28e14-9009-5bcf-b759-182eba2acfc4','','','Linnaea 13:392.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05efdb83-8df9-5d2b-83bb-992e34d7c88f','','','Diagn. pl. orient. ser. 1, 6:28.  1846 ("1845")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5360b588-1bbc-5c63-a094-270dad413bdb','','','Sp. pl. 2(1):203.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3b3f2ff-268c-5161-8a72-6618bd1a45ab','','','Sp. pl. 2(1):159.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd97bafa-fa42-51c6-a98f-486e93008fbb','','','Acta Horti Berg. 18:144.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40e8ba6f-68eb-5bfc-8042-625ff9036a74','','','Recueil Trav. Bot. Néerl. 12:345.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22d62f60-c2f6-5ac0-a101-91d9e2c30d76','','','Hooker''s Icon. Pl. 14:3, t. 1304.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e408a1df-f6d0-5bc3-849f-9eeefee79c3e','','','Novosti Sist. Vyssh. Rast. 9:161.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a604dc07-510f-5509-807a-3ffa479fb101','','','Preslia 48:220.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('845b6172-4a75-56df-91a1-3799303fec0d','','','Enum. pl. 2:76.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2a0045c-b6cb-5880-83d2-2da19201a56e','','','Novon 8:100.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('992ff88a-16b9-56a2-8e29-e71f3b94c32e','','','Berberis. Amer. Austr. 21.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('052e14da-5004-57f9-80b0-af598e42b782','','','Fl. novo-galiciana 5:151.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64331953-c73e-51b7-8b11-14c269568a47','','','Sitzungsber. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. München 16:303.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('318e9e3d-6653-534b-8f71-463508d4d8b9','','','Fl. ind. 1:271.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0648d029-0c80-500f-ae8f-04102fce3af5','','','Revis. gen. pl. 3(3):272.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d064b32-438a-5f52-b360-05bfe11ca2f8','','','Oesterr. Bot. Wochenbl. 6:228.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab8ef32a-4bc4-5d15-845e-89bce744df6f','','','Rev. Bot. Appl. Agric. Trop. 15:966.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08e22ead-e710-5aac-871d-dd9f0f90114e','','','Beih. Bot. Centralbl., Abt. 2, 34:257.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a749153-99aa-5280-a2ba-8641c6f01738','','','Prodr. 1:705.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5010356e-5844-53be-9377-c7d08dd28bf6','','','Fl. Afr. austral. ill. 95.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b461710-697a-5074-8ce0-903825120f32','','','L. H. Bailey, Cycl. Amer. hort. 1021, fig. 1408.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8498b518-35ca-5b99-8c8f-b5bd6a4e4c53','','','Reliq. Kotschy. 20, t. 16.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2106ca89-9b45-524f-9579-a7429347dc12','','','Bull. Mus. Hist. Nat. (Paris) 1:317.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fb6afc1-dd48-52aa-a6a7-853736c68b60','','','Kew Bull. 40:15.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75e3584a-0167-58cc-8ca2-e403a55491c2','','','Fl. ind. ed. 1832, 2:663.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b2e9ed4-5037-522b-aa45-bf7240e5b1ec','','','Fl. aegypt.-arab. 80.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2330651c-afa7-5724-b943-36f93f96286f','','','H. G. A. Engler, Pflanzenr. IV. 243. I(Heft 72):23.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c76a316-630c-5171-9156-499a9208495b','','','Tent. fl. abyss. 1:193.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6421bc0e-980d-5742-9bd2-cc0cf8f485eb','','','Hort. brit. ed. 1:288.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b951a4b-1ef6-543b-be39-c73adc7725ef','','','Bull. Torrey Bot. Club 64:374.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('806a2af0-7439-5d10-8e02-d5fbc64fb404','','','Rep. (Annual) Missouri Bot. Gard. 13:64.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('caeec676-71ae-51c9-ac84-d7c2c111fc77','','','Sitzungsber. Heidelberger Akad. Wiss., Math.-Naturwiss. Kl. 1958:404.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48a7f51c-97bb-5606-b5f9-5ae209a666c6','','','Canad. J. Bot. 51:759.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d7d978b-94e3-5e8e-9bb4-62d6b3c961db','','','Bot. Mag. (Tokyo) 18:52.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f55c535-aa7d-56cc-8ad8-1b0005681337','','','Calcutta J. Nat. Hist. 5:62.  1845 ("1844")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8931c913-6405-559e-9e91-4fd66f0af2aa','','','Kakteen And. Sukk. 41:26.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbf547cb-42ae-5527-af00-03393ce6e174','','','Centralamer. Gesner. 60.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b3dd4d3-72ac-5b4d-a23d-ea4186f01fbc','','','Bol. Fac. Agron. Univ. Montevideo 101:52.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7f811f5-9eaa-5d3a-a6fd-2ebe66244296','','','Bull. Torrey Bot. Club 42:353.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3900e55-ceca-55bd-aa29-b5e290fad4bc','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:254.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f2f2c7b-45fd-514d-ac4c-bf8ec75765b0','','','E. Nasir & S. I. Ali, Fl. W. Pakistan 100:83.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a05d301d-a6f0-5ba5-8e68-29e1617ff343','','','Pl. wright. 1:50.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84ef001a-af3c-5e4d-b213-eb08f6a79147','','','Srpska Kralj. Bot. Bašta Beograd 1888:6.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('188b044d-77c4-5b47-a646-7dbd230b2258','','','Exot. fl. 2: t. 149.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a36c8aa6-e154-5b9e-8d19-f9b085154e18','','','Syst. nat. ed. 10, 2:863.  1759 "<I>meriania</I>" (Sp. pl. ed. 2, 1:54.  1762)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c129e92-47b5-56ef-b34e-64135ae85ba3','','','Allg. Gartenzeitung 16:131.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a70a57e-a934-5b8b-b7bc-4fdabb712806','','','Fl. sicul. 1:28.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('225cde7a-0b87-56fa-bd4b-4da40e7064c3','','','Prodr. 2:260.  1825 (F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:301[folio]; 6:383[quarto].  1824, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb31b1e3-1b64-58ff-954f-d01799930e48','','','Fl. cochinch. 2:615.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2068fc91-929f-5887-9c64-99d1ec1e6347','','','Taxon 56:944.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e767a59b-3f40-5152-8a77-708860288910','','','Syn. fl. germ. helv. 87.  1836 ("1835")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('479ac363-976c-5c2b-9fec-572d0db43744','','','Prodr. 2:161.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c22fe179-8ca4-5522-bead-98f3e27fb497','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:328[folio]; 5:419[quarto].  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5a3c1e8-961d-5ba1-b552-41f74cdd0ee8','','','Madroño 36:281.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47633515-5705-5d44-8d1d-af6962dc15fd','','','Pittonia 2:192.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1cacad4-321a-5156-9dd7-9dfc40bfa4f1','','','J. Bot. 76:352.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4aa656b7-b047-5768-8f0d-74be40dd01c9','','','Ann. Gén. Sci. Phys. 5:348.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1a2f6bf-2a33-53bc-943b-c24b5144dab8','','','W. T. Thiselton-Dyer, Fl. cap. 5(2):330.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b31d1d0-1bf9-534f-8ad0-4a5d7d4c8237','','','Züchter 21(1/2):56.  1951 "<I>"velutinumcompactoides</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbd2353e-f216-5f44-ac70-5099ba9ff0cc','','','Diagn. pl. nov. mexic. 54.  1880 "<I>mitraeformis</I>','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23c0e619-68a0-5711-b9d0-558acf8acd94','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 29:339, t. 15c.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d21a173-750d-56d2-9f5c-ae2535f72596','','','Revis. gen. pl. 2:779.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a5016ad-b316-5169-88dd-a373e1c71c9a','','','Hist. nat. <I>Solanum</I> 187.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04c81ee9-c599-51c8-b4c0-e507da755dd9','','','Abh. Königl. Böhm. Ges. Wiss. ser. 5, 6:615; Epimel. bot. 255.  1851 ("1849")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b593c946-77e6-5b78-b1d1-94a2f3b673b8','','','Blumea  51:565.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa61e50a-7790-549d-b2a9-bd14e9fb67d2','','','Webbia 8:222.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53c3f7b3-9086-5f71-82f5-55fbb40f8cc5','','','Zoë 2:17.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f235d39c-8641-5420-81d8-b31f98f05ad0','','','Repert. Spec. Nov. Regni Veg. Sonderbeih. C 136.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55d848dd-e611-5702-a0be-80148388b873','','','J. H. Maiden, Crit. revis. Eucalyptus 8:34.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5913038d-331b-59e3-a8ce-b4369f07eb1a','','','Pl. aequinoct. 2:162, t. 133.  1817 ("1809")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1e4c821-c679-566f-9d24-0e0c3ab7b4ae','','','Trans. & Proc. Bot. Soc. Edinburgh 14:121.  1882 (Salisb. ex W. J. Burchell, Trav. S. Africa 2:148.  1824, nom. inval.?)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3982cb76-2caf-5817-87cf-7a34c67e993f','','','Linnaea 2:10.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5df26484-2666-5611-8c78-5bdd28d15e5f','','','Mitt. Bot. Staatssamml. München 10:130.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0c30e07-76a9-50ef-82cf-686c8e9b428e','','','Fl. Guizhou. 2:147, 675.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b845588a-918d-5270-a0ff-1c3c1055b3d5','','','Sp. pl. 3(2):909.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e91b3f0-594a-582f-a6e0-fce81c7ff4bd','','','T. Nakai, Iconogr. pl. As. orient. 2:185.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49f2ce58-874e-54dc-9104-323c4486061e','','','Bonplandia 1:226.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('314dd451-59a0-5fc1-b40e-3b3832b49989','','','Indig. trees  Haw. Isl. 509.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37a143e9-80e7-58b1-bc84-301c23e65671','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 5:525.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7871272b-c53d-552e-a2cf-97fc21d4cb0e','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 5:629.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9167632-9993-5079-b09c-760fa6a9b7e2','','','F. Parlatore, Fl. ital. 6:480.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e92f8122-a740-5daa-a9b3-e8207e1c8a76','','','Martens, Gartenbohnen t. 2, fig. 15.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97b93375-189f-5228-820a-c26950e95196','','','Syst. Bot. 15:67.  1990 (non Turcz. ex DC. 1839)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81bcb1db-aa57-5e63-8f98-abd7c87e8723','','','Curr. Sci. 41:429.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75c77611-6858-56f5-bb35-4821de8c37bd','','','Bull. Torrey Bot. Club 65:252.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19c3ab35-32cb-574a-bcba-2add663759d7','','','Univ. Washington Publ. Biol. 11:110.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d361acd2-95f9-584b-8bb6-876431dcb53b','','','J. Linn. Soc., Bot. 58:29.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab78b7f4-787d-50b5-9b66-2401827ed62d','','','Bull. Mens. Soc. Linn. Paris 2:1193.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e47781de-acd7-52ed-b96c-4e0b9a01e1b9','','','Folia Geobot. Phytotax. 8:166.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f4019b0-429e-5391-ab28-b46122dd4f56','','','Gard. Chron. ser. 3, 40:350.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('446beb83-9f7f-5f14-a656-23a53c74c1d1','','','J. Jap. Bot. 1:9.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('339ac273-818c-5d98-bb6c-99fd380d065d','','','Willdenowia 12:198.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07bcc413-6607-5c69-9576-894b94d052d0','','','Linnaea 2:583.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a64f9655-f24e-5641-9c5c-24fb552b5f0c','','','Encycl. 1:556.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75762320-9081-5f66-94e0-658222e500a8','','','Bot. Jahrb. Syst. 2:145.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('979b1a9e-93c1-5953-90c9-5da76a7df4db','','','not published?','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2200e8c4-7e2a-5ad8-b0a4-8f15a0b771f2','','','Syst. nat. ed. 10, 2:1229.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1332e325-5fad-52bb-85c4-a5dd10f6ff51','','','Philipp. J. Sci., C 2:235.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd4aef08-9a26-5d80-bcb6-cbef83d1f4cb','','','Prodr. 457.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c2d7d0f-a8ee-57ae-ac92-2cd6f4487c19','','','Sp. pl. ed. 2, 2:1501.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb67e604-c0e3-5752-9d4f-f2bdaacf53d6','','','A. L. P. P. de Candolle, Prodr. 15(1):90.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95bd9eb0-eeda-595f-b0d0-bf915282a78b','','','PhytoKeys 205:185.  2022','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25064aa1-49d6-57fc-981d-81593b3b68d8','','','Bot. Jahrb. Syst. 18(Beibl. 45):34.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcad8560-bf5a-5f7d-8911-9e280785a2c9','','','Repert. Spec. Nov. Regni Veg. 41:197.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33b7315e-4cd5-516b-bbc7-94b4c979fb82','','','Bot. Mag. (Tokyo) 22:68.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95caf5c7-67a2-5d90-a4d8-e6d60fa8d7ce','','','Bull. Natl. Sci. Mus. Tokyo 33:79.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbe711b1-7ea0-57ec-a6e3-1dc3065fdad7','','','Acta Phytotax. Sin. 35:353  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('012af1a0-acd1-5a75-ad53-f1c4383b4852','','','Notes Roy. Bot. Gard. Edinburgh 26:190.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc64f030-945c-556b-a2c8-f7bd6f022cdd','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:54[folio]; 2:68[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a26b972-61ba-5c52-960f-9f87a35b0e4b','','','Biol. cent.-amer., Bot. 3:507.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd4a9084-3ef0-5b3c-b213-557dc205ea76','','','Rev. Hort. (Paris) 37:89.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8188abfe-c060-586a-9aa0-1f50b75ed57e','','','Pharm. J. Trans. ser. 3, 22:875.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a11e479-c96b-54c7-bf15-8dcfc9ce334f','','','Izv. Glavn. Bot. Sada S.S.S.R. 29:424.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e0550a1-f2c7-59ef-81a1-44da6a199664','','','Calcutta J. Nat. Hist. 5:480.  1845 ("1844")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9716a31c-2daa-52fc-8bfb-d3b8cbb323c8','','','F. L. E. Diels & E. Pritzel, Bot. Jahrb. Syst. 35:581.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25040117-cefa-532f-a46d-124c43c2909f','','','Stirp. herb. hügel. 6.  1838 (Ann. Wiener Mus. Naturgesch. 2:194.  1839)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffdc7ecf-2fa1-5f16-9bbe-68e1afdc3e09','','','N. Amer. fl. 23:125.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bbff4c5-e3f4-5f9d-ad40-850ac6d73929','','','Mem. New York Bot. Gard. 1:419.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5a92389-1b13-5500-9539-559ae3b1d073','','','Leafl. Bot. Observ. Crit. 2:80.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('608428bc-adcf-51b4-89a1-261cb492c347','','','Prodr. fl. Corse 1:572.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27e42b68-717f-5882-bbb2-6ce3df328629','','','Amer. J. Sci. Arts ser. 2,24:47.  1857 "<I>laevi-conica</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb6d798c-bfe6-5981-b1b3-b2edcaf54aac','','','Ill. Hort. 4(Misc.):72.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3c0e864-852e-53df-9619-e6992b5d66a0','','','Vilm. ill. Blumengärtn. ed. 1, 1:923.  1872-1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60a23e6e-58d5-5fb4-ad1f-f68e3ae7a692','','','Trans. Illinois Acad. Sci. 35:63.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bad924de-30f6-5f49-8f4a-eaa21a18f305','','','Fl. angl. 349.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31ee2e33-6169-5800-ac49-b08e7ed9026d','','','K. B. Presl, Reliq. haenk. 1:335.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf53bed0-8484-51af-9b6f-ea5cdc84d3ae','','','Fl. Italia 2:105.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b57d124-183e-5298-8c74-adec39d9eeda','','','Syn. pl. glumac. 1:422.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89294063-ace5-52cd-ae87-20e951cb65c2','','','Acta Phytotax. Geobot. 29:168.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7589cf3-477c-5c33-aa9b-a5145b972b1b','','','Acta Phytotax. Sin. 12:233.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0039a85b-ea24-5678-8cc0-07353a41e2fc','','','Bull. Torrey Bot. Club 40:483.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c72fac30-d82e-52f3-a043-cc5e140a8337','','','Prelim. cat. 36.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6d3512a-ae57-55d7-9192-496fbf336572','','','Rep. (Annual) Missouri Bot. Gard. 22:55.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e69da61-ffaa-5913-b1ed-ae9620c4a059','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 26:528.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12003923-5677-578f-99c8-a78e615afce2','','','Nuovi Saggi Ces.-Regia Accad. Sci. Padova 5:271, t. 29.1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e76d8d24-e12d-5a15-97ad-727e1cabd523','','','Agric. Univ. Wageningen Pap. 85-4:160.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de4e195a-4d18-5f36-a1ac-2762e1e911a7','','','K. P. J. Sprengel, Syst. veg. 4(2):408.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c718ca7b-658a-5892-bb53-1fc8e0147a4f','','','Collectanea 1:104.  1787 Jan-Sep ("1786"); Icon. pl. rar. 1:9, t. 85.  1787 ("1781-1786")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4bda190-a4ce-5d0c-b6ed-2cfffaa38125','','','Syst. veg. fl. peruv. chil. 1:116.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bef0b72-1789-5a01-84c3-0e1c7ebc1d53','','','Philipp. J. Sci., C 5:23.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83a1af7d-a356-5668-9fc7-84b6af84a4f3','','','Bot. Jahrb. Syst. 29:478.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ff6ec1b-e607-5a08-8d5e-0bf3e858baa8','','','Hist. & Commentat. Acad. Elect. Sci. Theod.-Palat. 6(Phys.):404.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6ebc17b-720f-5199-8b7a-d83cc1ccbd77','','','Mus. bot. 1:310.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ed91514-9574-51ef-a01e-26cc0fcc7973','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(6a):139.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c33caff-d411-59d2-8e0a-c7e1821fe83e','','','All about Begonias 136.  1960 (Begonian 37:199, cum t.  1970 "<I>sementacea</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('171ae463-5f86-5e20-aa3a-b6b07e7f86a7','','','Ann. Nat. Hist. 3:428.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50ccf30f-a889-5550-81fc-dfdf0aeac3f8','','','Occas. Pap. Bernice Pauahi Bishop Mus. 19:28.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('755181b3-510f-532a-8e7b-a796d63f9cc5','','','Bull. Herb. Boissier 4:453.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21f9492d-009c-5172-8be1-9030624defe0','','','Prodr. 15(1):375.  1864 (non Klotzsch 1855)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c530621b-e76d-5e75-9249-5fb5c2a4971d','','','Notes Roy. Bot. Gard. Edinburgh 46:251.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cf6151f-8030-5a35-bcad-d531f92254bc','','','Gen. hist. 1:415.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('075ca97b-2b61-5ae5-bfc4-df6e1f15cf47','','','<I>Canistrum</I> - Bromélias da Mata Atlântica 50.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c2cc686-792b-5879-9a12-9e9c47754d01','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 3:491.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04b400c3-d743-5bf1-854a-389776896d68','','','Proc. Wash. Acad. Sci. 1:139.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca33e735-769e-59c2-924d-4e66a592c53f','','','Proc. Linn. Soc. New South Wales 25:316.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af2e227f-0c30-55ed-85be-decd9f124806','','','Natal pl. 4: t. 320.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f1aa46f-c4b5-5d0c-bcb8-6f813a8d9092','','','Enum. syst. pl. 18.  1760 (Select. stirp. amer. hist. 94, t. 64.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24a2ce94-11f3-5f6b-9d52-7912eddca26e','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 8:251.  1886 "<I>Davidi</I>" (Pl. david. 2:69.  1888)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a72e2761-9b52-53cc-b193-d83a6f63aa4c','','','Proc. Amer. Acad. Arts 3:345.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85e09cc0-7d4d-514b-902f-4381d80b863b','','','Ann. Bot. Syst. 4(4):502.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e7acc7e-6b5f-53db-9d71-4f230607981a','','','Muhlenbergia 3:43, t. 2, fig a.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d284288c-a8cd-5062-89f3-101702be7403','','','Adansonia 1:139.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c75677a1-5760-519c-be0b-b8f366915e02','','','K. P. J. Sprengel, Neue Entd. 2:66.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f72e56c9-a840-5483-8674-ddd4647696e7','','','Sp. pl. 2:730.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a80100f2-64ed-527b-8724-e26ec3783ecc','','','Anales Mus. Nac. Montevideo 1:58.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fcb4a11-0894-56f8-8fde-41fa318e5669','','','Bot. Mag. 90: t. 5472.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('687ab2d3-e766-5c67-b8bf-476fd9a70313','','','Hist. arbr. forest. 1:64, t. 6.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96f9c442-15a6-5c5b-a903-6efe5913b1bf','','','Repert. Spec. Nov. Regni Veg. Beih. 80:59.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d32811f8-1f4d-51cd-96ff-336b62a76829','','','H. L. Duhamel du Monceau, Traité arbr. arbust. nouv. ed., 1:159.  1800-1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40d8648e-0b09-5b4c-b0d8-4bdea79f83d7','','','Prodr. 3:541.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5e3e71c-7b87-54ff-b0da-a1064df40919','','','Prodr. 7:248.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45b8735c-581b-5c5e-9af5-47cca5894e7c','','','Fl. flumin. 300.  1829 ("1825"); icon. 7:91.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a5a654d-e688-5ad9-a6c5-ed04781a9558','','','Oesterr. Bot. Z. 36:151.  1886 (F. E. L. Fischer, Index pl. hort. petrop. 25.  1824, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07c1db0d-ebe4-5602-a7de-6d77c3247127','','','J. Proc. Roy. Soc. New South Wales 58:177.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecd50118-215e-5e77-b889-e5b607f8ceab','','','Phytologia 73:58.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('813a1639-fea0-574c-aab0-421ce5726508','','','Bot. Mag. 85: t. 5149.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87293816-6839-5054-9d60-0d3ef0e129a8','','','Icon. 4:49, t. 372.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88dc3229-6b79-5018-be09-49b9d8a61a4e','','','Fl. angl. 103.  1762 Jan-Jun','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3813392f-e337-53c3-b46f-3617c9fb7737','','','Pugill. pl. Afr. bor. Hispan. 52.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9cf467e-8cf5-5de9-9c39-4f9a0aeaec9b','','','S. African J. Bot. 52:569.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98e019cf-1a64-5809-b350-e0b275c0508b','','','Linnaea 27:415.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2812f12-545f-5004-950c-819a41dbb9f7','','','Varied. Ci. 2(4):143.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06a18bff-c5a2-5f6b-9908-d1c543c7d840','','','Gard. dict. ed. 8: <I>Cupressus</I> no. 3.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0ead971-d99e-5672-9f85-d4ba8b015b9b','','','Bull. Soc. Bot. France 98:272, fig.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf62898b-59a4-599e-b3db-8191c6bd5c80','','','Allg. Naturgesch. 3:1431.  1841 (H. W. Rickett & F. A. Stafleu, Taxon 8:313.  1959)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('696260f9-cb21-5346-9bf9-653e6d473ed9','','','Phytologia 39:152.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ed22bd7-8d69-5dee-9ff7-0d793abb8580','','','Benth., Fl. austral. 2:264.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3dc56981-14b8-56ed-a02c-ad6ad7ba889f','','','Phytologia 77:284.  1995 ("1994")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25fd53c4-5226-5e43-bb0f-d590248aa8d8','','','Arch. Mus. Hist. Nat. 4:87.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad76e049-7614-55fd-ba5e-6587780147b0','','','Ann. Sci. Nat., Bot. sér. 3, 2:120.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('874beafa-5c57-5964-b3d2-6408acf60f49','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:127[folio]; 2:160[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aad3f1e1-acf7-5625-b177-8d2eb42dd551','','','Symb. bot. 2:97.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e53293d-7885-5c54-8ae9-16efe5d27667','','','Boissiera 13:133.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e282ed89-d05a-5203-aba9-dcaa13720181','','','Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 9:780.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21ac7e25-e846-5fc0-a228-e2df32d0c4e7','','','Gayana, Bot. 47:29.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a620c1e9-3a45-59aa-8ae0-75a270ecf353','','','World checkl. seed pl. 3:15.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('203aba28-fe06-50b4-8dd1-819e8db8a42a','','','Sp. pl. 3(2):1530.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9af5740c-65be-5377-8622-3721e57eb3e9','','','Fl. napol. 5:160.  1835-1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('874db6c9-40af-5d39-a9c5-4ca96c1221e7','','','Ann. Missouri Bot. Gard. 65:1101.  1979 ("1978")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fade5e93-ec69-544d-a391-46264e2853a4','','','Fl. s.e. U.S. 468.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c51ca5e-a394-56d8-9808-2e7d23a1ee35','','','Arch. Jard. Bot. Rio de Janeiro 3:231.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18feaa0c-4e05-570f-b246-2b732e03ebcd','','','Nouv. Ann. Mus. Hist. Nat. 4:380.  1836 ("1835")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0f9a331-51a0-57f6-aacf-12e35d63e1fc','','','Erythea 1:15.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92bf824a-2573-5b35-8229-624810a14dfa','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 7:369.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c4aed46-f616-5c85-b055-4b6a4232d609','','','Nov. Holl. pl. 2:27, t. 166.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('392d9d98-fcfb-5260-9418-f873189de1fc','','','Sp. pl. 2:669.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7955b7ff-8423-58da-8f94-51e30bcfe8aa','','','Gard. Chron. ser. 3, 13:580.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1f21ee0-6225-5daf-9c17-c486689ad0ed','','','Bull. Misc. Inform. Kew 1920:246.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cd5ffbf-c8d4-5c80-aed3-5a095f83d6a5','','','Proc. Linn. Soc. New South Wales 62:286.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bbf35ed-e7d9-5e70-8960-0c80259d678b','','','Diagn. pl. nov. mexic. 36.  1879 "<I>salviniae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe0a89a1-f50b-5719-8960-73a60703da7e','','','Willdenowia 43:233.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab0cbbe4-055e-52df-ba90-642def83b450','','','Verz. Pfl.-Kult. 40.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b724fbeb-c336-57f5-8b13-5eadd005f42e','','','Bull. Soc. Imp. Naturalistes Moscou 14:868.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6380ad9b-a113-5b67-949f-2311748e01c8','','','C. Wilkes, U.S. Expl. Exped., Phan. 15:135, t. 11.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77b3707d-c3a2-5b39-a645-d4578980ac77','','','Bull. Soc. Sci. Phys. Algérie 11:187.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebfed1b5-d7f5-548f-9910-78aef802f9ae','','','Amer. Midl. Naturalist 58:509.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41005d62-c020-5cea-b0d9-ae5cfa90f82c','','','Beitr. Naturk. 7:164.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11804c16-f051-5428-b972-16e4dedf6c15','','','Enum. pl. 1:445.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1dd726ee-e34c-5ad2-ae0a-9454af7a8bc2','','','J. Roy. Hort. Soc. 74:347.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46fad0c7-3f6d-5a10-9a41-79a42c58f3a3','','','Mant. pl. 2:270.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b32dad32-fcf9-59f3-86f4-3ada63e2534c','','','Suppl. pl. 213.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('883734a1-6bf1-54fc-ba01-55233af6dac0','','','Fl. trop. Afr. 2:364.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6c7b559-3fa5-5fd8-a967-92c5621d8665','','','Kew Bull. 1949:23.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4acaa83-0464-5a49-ad34-133f56a8a966','','','Fl. austral. 6:87.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cbf1291-933b-5902-9229-0768f8a08b2d','','','Trans. Illinois State Agric. Soc. 4:411.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cd7bba9-bad8-5871-a7a9-cdd8bc6dbaf1','','','Notes Roy. Bot. Gard. Edinburgh 12:145.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c37233c9-ce3b-563f-9783-3e4d7e651511','','','Edwards''s Bot. Reg. 20: t. 1722.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d19b4b00-a99b-5293-a65e-398c9c3ed3b4','','','Phytologia 73:458.  1993 ("1992")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bce9e557-f5e7-5c79-a8be-b20fe2910ed5','','','Fern. Bull. 12:41.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a08cfef4-fc7c-5776-92a3-fdb85591e2c5','','','Arnaldoa 5:167.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d45393b9-a382-5616-bfba-ccd315204af7','','','Sp. pl. 1:399.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8f38b08-9816-5e83-af59-592871c949d2','','','Novon 1:132.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f2f754d-d837-5d17-9430-f2ee8bf43ae2','','','Bot. Leafl. 7:10.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0235497-14dd-55d8-8d1d-a57a8e3e0c4e','','','Phytogr. Lusit. select. 1:82, t. 36.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cae6f9f0-0218-59d7-9fdb-c4a0aa64b236','','','Voy. Uranie 480.  1830; t. 69.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ffd132c-6da2-5db2-a52e-a089e2b84511','','','Man. fl. pl. Calif. 1041.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('598151c5-11d7-5b0d-af90-d0d769b823d9','','','Fl. austral. 3:254.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc7088ad-19a3-54cd-b456-63b18795e1c1','','','Amer. Fern J. 19:11.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d28c02b-92cc-59d2-ac34-df3c5943b7ce','','','Dendrologie 2(1):153.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55ac2bda-2b7f-5fab-980d-2cef2d7ad47b','','','Hesperian 3:300.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d94ed29-87f6-556b-8b73-2a85fa537526','','','Contr. New South Wales Natl. Herb. 3:98.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cc9737e-61c7-5532-8fc2-9ba340095334','','','Brit. Cactus Succ. J. 13:94.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60d09915-43a0-5474-aa7f-2243b3ab14f7','','','Enum. stirp. Transsilv. 2:215.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b524340a-66f5-5b52-aa08-319d0e43b93f','','','Fl. flumin. icon. 11: t. 26.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cd7a0af-d11e-5e71-a65f-9b98fc4f2dcc','','','Wrightia 2:185-186.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('648372b0-4acd-532d-bdbd-feb22616dd06','','','Madroño 41:15.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('396eb94d-f22b-5762-9d25-dc5a504462c2','','','London J. Bot. 1:498.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b502521d-adea-56c4-a854-fd202c71273f','','','Fl. austral. 6:433.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2acd0e00-3d8f-5612-878e-1c9f2b87d143','','','Notes Roy. Bot. Gard. Edinburgh 13:294.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3e83282-6864-5164-9cb6-d4ec1d871e58','','','Bot. Jahrb. Syst. 26:309.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53a3ed67-ca44-53c6-a453-ee9f74c5e14b','','','Contr. Biol. Lab. Sci. Soc. China, Bot. Ser. 10:169.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db5ad963-d866-56e6-ad07-ca251802cd8d','','','Strand-Steppengeb. Iber. Halbins. 110.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52f8bdf2-5f18-51fd-9f1f-7ae8fcfff2ea','','','Abh. Königl. Böhm. Ges. Wiss. ser. 5, 6:599; Epimel. bot. 239.  1851 ("1849")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbe94374-166e-54b0-be5b-7dc612f79525','','','Monogr. Narcissin. 1.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f032b24-633b-5f59-a03f-270ea047a2f6','','','Kew Bull. 22:213.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5073554-86e4-5e99-908b-ccca1dbd5178','','','Univ. Calif. Publ. Bot. 31:12.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d4fe5ec-e3ba-5556-8295-019ee2d7e2ed','','','Contr. U.S. Natl. Herb. 12:291, t. 24.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35c0e432-08e9-584f-9028-7fb5f55b46af','','','J. A. Murray, Syst. veg. ed. 14:844.  1784 May-Jun (Fl. jap. 38.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f769dc5-e0bc-59c6-99f9-27be0af49bb2','','','Caldasia 4:40, fig. 2.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('458aff38-a776-5045-8817-10efc7c55685','','','Fl. columb. 2:19, t. 110.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d91ba10e-4943-5707-9ec2-defd5dac4aa3','','','Proc. internat. symp. fam. Magnoliac. 23.  2000 ("1998")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8bc36fe-bfd8-5055-9cae-dbae57f9d191','','','W. H. Emory, Rep. U.S. Mex. bound. 2(1):141.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fca38889-0cbb-53b7-a1a4-a1a100be5fc9','','','Tent. fl. abyss. 1:202.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05faf9d2-e052-5e2b-9f4d-48119ce10d73','','','Fl. cochinch. 2:525.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56b6a87d-835f-527c-80ed-8c95dedf0238','','','Kew Bull. 40:728.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c910adc2-383f-54c5-b229-5a052c12e910','','','Syst. Nat. 2:246.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28a1a45d-1ffd-51b4-85e3-bd197f42ac76','','','Bull. Misc. Inform. Kew 1921:363.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88cfec84-7ebe-50e4-b0e8-60622d924561','','','Revis. gen. pl. 2:516.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8139ddfa-60d2-5481-bbbc-0db3346fd547','','','Anales Soc. Ci. Argent. 99:91.  1925 "<I>atro-virens</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58877aa8-acce-552e-8f8e-5f3963c63774','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:408[folio]; 6:522[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24c43db9-969c-50c3-98c3-250c97a81aba','','','Syn. pl. glumac. 1:349.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f017199-7674-52a7-83bc-e584dd65d5db','','','Bot. Mag. 87: t. 5248.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d69bd0f-6485-5bb2-8a53-67637a9e2c69','','','J. Linn. Soc., Bot. 38:320.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdcc2aeb-2206-5351-bea5-c0a7e55f3877','','','J. B. A. P. M. de Lamarck, Encycl. 4:529.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('beba0557-a438-56d1-aaba-4e387d895270','','','Revis. gen. pl. 2:524.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c116293b-a107-571e-8adb-a0946eac1277','','','Notizbl. Bot. Gart. Berlin-Dahlem 9:1041.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('866ea42b-38d7-5e3a-ba41-fe66bbb4dbf8','','','Notes <I>Mesembrianthemum</I> 3:227.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e54c279-5ff7-53fa-94b2-2b5b0125213a','','','J. Burtt Davy & A. C. Hoyle, Check-lists for. trees & shrubs Brit. Emp. 3, draft descr. check-list Gold Coast 110, 115.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e46db82-d539-5506-ad16-0381245c5907','','','Bot. Gaz. 78:276.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a9e8c37-50f8-5ce8-abec-64ddfc0a547e','','','Trans. Linn. Soc. London 12:360, t. 18.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca2e47ea-f7dd-530a-9775-eef53ae9a4d6','','','Acta Acad. Sci. Imp. Petrop. 1779(2):263.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c47be1dd-203c-5b08-9004-195bb31a0f22','','','Repert. fl. ligust. 52.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14fe27c7-55ae-5e34-960a-d0a3c3e43c00','','','Erythea 2:95.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d497cc0e-d87a-5633-874f-639f60f51f5a','','','O. Drude, Bot. Zeitung (Berlin) 34:803-804.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('409fd09a-16bf-5c46-b319-5e394fd45a55','','','Sp. pl. 1:99.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87731a0a-6939-51f6-bbcd-7e6914ccfb1c','','','W. J. Hooker & G. A. W. Arnott, Bot. Beechey Voy. 242.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e1aebcb-3acb-5fd2-9cc9-c747787be3c7','','','I. Urban, Bot. Jahrb. Syst. 19:587.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9da9aa34-1bed-596e-ae10-06a4f8356485','','','J. Lindley, Sketch veg. Swan R. xiv.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0d34633-0bfb-5a0f-9b5a-a26f7a5dae48','','','Fl. ins. austr. 80.  1786 Oct-Nov','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f6a000a-92cb-5c1e-b419-a4151335daad','','','Enum. pl. Javae 241.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0286f357-f0f5-552e-90a6-c501a04a14dc','','','Phytologia 40:19.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90a9fdb0-8bca-5303-b42a-d57a9c07537f','','','Palm. hassler. 6.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e47ab23e-171a-5553-98ed-f4199b63a094','','','Diagn. pl. orient. ser. 2, 2:92.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05d79021-4513-5b72-bc70-c3825657565e','','','Sag. stor. nat. Chili 158.  1782','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db34f0a7-be7b-5f33-a60d-176f49eb0f4e','','','Fl. dan. 4(12): t. 707.  1777 (non Burman 1768)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('675aa419-22ac-5c15-aae1-cf7ff513d6f4','','','C. F. von Ledebour, Fl. altaic. 3:64.  1831, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3db434a-97f9-56b9-80ad-02354721d35d','','','J. S. African Bot. 30:213.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3907d548-5cab-5474-b49b-7f2d80fe00b9','','','Fl. N. Amer. 1(2):268.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2593b77-8e13-5ede-aae4-dece00f29c56','','','Darwiniana 35:151.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fc11f78-25dd-5373-ae90-18dad6ef186e','','','Proc. Amer. Philos. Soc. 50:433.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70a35cf8-215c-5d8e-89f7-4041f57fdae2','','','Ann. Univ. Stellenbosch, Reeks A, Wis-Natuurk. 8:48.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28274537-11e4-5d5c-b771-bd266e20385a','','','Bull. Torrey Bot. Club 64:381.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13cf1a73-b175-56b9-bdf3-45e3895815e7','','','Gard. Chron. ser. 2, 7:684, 693, fig. 112.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cba0b96b-80f0-5d28-8576-ba00334a904d','','','Taxon 61:951.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee9da175-0810-56d7-852e-60f1124e1498','','','Tea Sci. Res. J. (China) 1983:18.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('973a3835-ce0d-522f-a2ad-3bf8c2805b21','','','Guihaia 11:8.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('329ac035-0d4a-5a1b-a3ba-238bbf1c3251','','','J. Bot. Res. Inst. Texas 3:479.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f5c8889-6570-5f9c-a6c7-a141e242c890','','','Bot. Mag. 132: t. 8092.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70843dd5-0199-543e-a4b2-446696dede6b','','','Colecc. Ci. Inst. Nac. Tecnol. Agropecu. 2:308.  1970 [Fl. Prov. Buenos Aires]','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('411c0a60-5f08-57c1-ace3-62d8ae689cc9','','','Syst. veg. 6:120.  1820 (R. Brown, Asclepiadeae 41.  1810; Mem. Wern. Nat. Hist. Soc. 1:52.  1811, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1349700-3804-5ba0-89ac-7c449ece5775','','','J. Arnold Arbor. 6:143.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5d22c56-7a37-50db-911c-e07dcf9ba612','','','Verh. nat. gesch. Ned. Bezitt., Bot. 4:115, t. 7.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10e7a2fd-37f0-55bb-ac82-7c0c8aa3b0b8','','','Pl. Coromandel 1:68, t. 100.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad7830ef-3cc1-5350-9352-477d4bdc46a5','','','Syn. pl. 1:324.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3dda80f0-fcdf-5b82-831c-95377fbdae92','','','Proc. Amer. Acad. Arts 10:343.  1875 (non Arrond.  1863)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3409a9c-d23b-52d8-aaea-6525f3725b61','','','Exkurs.-Fl. Bayern 346.  1884 Apr','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05aa2eeb-7754-5d13-b7f8-5d9147d42260','','','Nouv. Arch. Mus. Hist. Nat. 10:145.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef9ac5c8-15e6-54cd-8b82-f9e7d7b0552a','','','Queensl. fl. 103.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b4323c3-bce0-5c67-a828-7de5bafab2d4','','','Sp. pl. 3(1):223.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35136fb4-4faa-50b3-87fe-5a8d96de2119','','','Fl. forest. Cochinch. 1(fasc. 1): t. 2.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4db86aa6-e3c9-5c90-8f53-1d5b4381d726','','','P. H. Davis, Fl. Turkey 4:127.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20c9995f-d171-5369-93be-d7b7c3a91b53','','','Vavilov J. Genet. Breed. 21:168.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c483069-6a44-57d9-a1da-256aaa440b1b','','','Sp. pl. 2:1097.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56a6b0ed-a164-566c-9b68-8b97c03a1f4a','','','Gard. dict. ed. 8: <I>Hermodactylus</I>.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('660e802c-fe6d-5f1d-acb7-817c6ead5022','','','Appendix 40.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30278246-ff5f-5d29-b46d-4eec1fb34825','','','Pl. jav. rar. 41.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb116263-e6ca-5ae5-a25c-6f1aaa8efb9c','','','Bot. Jahrb. Syst. 51:367.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ab678f1-b5f9-593a-97ec-b48bccdd2559','','','Pl. Feuill. Ornem. 102.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b89584d8-e1c2-50c3-b8b2-2ffde7873ba3','','','J. A. Murray, Syst. veg. ed. 14:463.  1784 May-Jun (Fl. jap. 202.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8e856e6-cab4-5c12-b853-743f781f98ba','','','Descr. icon. pl. Hung. 2:207, t. 189.  1804 (non Bergeret 1803)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4a502f6-ed35-5454-aded-6839955186bb','','','Diagn. pl. orient. ser. 2, 5:81.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e493f025-f13d-5e67-99d8-d215910a6cfd','','','Sp. pl. 5(1):172.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f242d34e-67a2-53f8-850c-57f8cca89626','','','Bull. Misc. Inform. Kew 1926:201.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6903f16b-58c3-5754-a1aa-e094fc7240de','','','Fl. peruv. 3:69, t. 303, fig. a.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6097101b-3b0c-5930-a6e7-de2820440b27','','','Del. sem. hort. Kiov. 6.  1840; Linnaea 15(Litt.):98.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('304e4fd3-52a3-50cd-a8ab-8bcc83521cf0','','','Taxon 17:539.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ba08bdb-30e5-5667-9b79-1e373182d68c','','','Fl. Amer. sept. 2:547.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c367e875-56e0-5211-8a16-a54a8ba15e66','','','Monatsschr. Deutsch. Kakteen-Ges. 1:77.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb2f742a-d4dd-5de5-bf57-d4c5683e432a','','','Contr. U.S. Natl. Herb. 22:35.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5f892aa-fae2-5a21-9d28-d8626c493236','','','Fl. atlant. 1:279, t. 80.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee988e3f-e07c-51fb-a959-e16588dfbe94','','','Fl. Amer. sept. 2:740.  1813 (T. Nuttall, Cat. pl. Upper Louisiana no. 29.  1813, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3736b97c-282a-54a0-84d5-2e5d6d54df78','','','J. Proc. Linn. Soc., Bot. 4(suppl.):92.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc9a6f1b-ae78-5471-bc4a-8b336f88d48f','','','Fl. Calif. 1(2):354.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff19405c-63f3-5f58-afdf-9b43abf8d8d3','','','W. W. Saunders, Refug. bot. 4: t. 224.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7156e143-7212-5649-80a9-327bff20d89a','','','Verh. Naturf. Ges. Basel, 3:549.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc98814f-87cf-51a7-8f3c-8da5b322453d','','','Hist. nat. <I>Solanum</I> 149.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89edf0e1-66c5-5d7e-9cfb-880ce4b321a4','','','Encycl. suppl. 4:223.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('398d5c55-89ad-5b59-970b-13e81c7ba990','','','Syn. rub. Germ. 404.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0d8b961-e47f-5400-8580-a0793fb9a00f','','','J. Linn. Soc., Bot. 52:184.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e0092d2-1199-56eb-8cd9-cf149e3a6193','','','Enum. syst. pl. 29.  1760 (Select. stirp. amer. hist. 225, t. 139.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac6ec5a1-7cde-5587-a983-05d781b95b28','','','Fl. Amer. sept. 1:99.  1813 (non L. 1753)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad0fd189-16bb-57a4-bd43-2529d3b3c5ee','','','Syst. veg. 5:383.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b43b00d9-114a-5c8b-813e-650b75850d62','','','D. Oliver, Fl. trop. Afr. 2:230.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('220d3076-f4f9-5049-8a45-81958b9fe38e','','','C. L. Hitchcock et al., Univ. Washington Publ. Biol. 17(1):279.  1969 (Vasc. pl. Pacif. N.W.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4dbb16d3-d908-5e16-8779-2bac7bb13fc9','','','Ann. Sci. Nat., Bot. sér. 5, 3:324.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02d63c67-5f99-50d5-83c1-2bfcfce191d0','','','Madroño 13:162.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f66c6f45-2f78-5122-9e71-f3845da86d26','','','Elenco 83.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1bdfb8b-8821-53e7-ab70-eff7ad6d76a0','','','J. G. C. Lehmann, Pl. Preiss. 1:546.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87f26b36-3235-5bfe-b34a-a6c0e7013b8c','','','J. Linn. Soc., Bot. 41:223.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da5503b9-8475-508c-8324-2f1c718fb34c','','','Repert. bot. syst. 5:400.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a36ba53-7b66-53c6-bb3f-2ff5ce922048','','','Bothalia 15:86.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('840065d4-e913-5e5c-8b66-3fb244ba6f0e','','','J. S. Newberry, Pacif. Railr. Rep. 6(3):72.  1858 "<I>gordoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa1ca61d-1c01-5895-9c05-e2d6ebc1176f','','','Dansk Bot. Ark. 29(1):53.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5887de34-7c17-5701-9d2d-0190c9a5701f','','','Agric. Colon. 10:469.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43ddea59-1863-5fd5-9fcb-577e16a7e3a0','','','Prodr. 5:485.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a09810cd-ccbc-5c90-94ec-6c1a9d634204','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 3:536.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ced448d4-3ca7-53a7-85d4-076737359af9','','','Kul''t. Fl. SSSR 4:283.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef380dd8-d528-54e4-b928-2a4cf360e361','','','Bull. Herb. Boissier 2:521.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc8baf23-3572-5850-8176-647a6251a6b5','','','Gard. Bull. Straits Settlem. ser. 3, 10:260.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbf26245-b0de-50be-9379-6779831ba1a5','','','Tent. fl. abyss. 1:69.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5ee2cd1-1ea8-5a0e-b4e1-655ef184040a','','','Nov. gen. sp. pl. 3:57.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f008cc84-8eef-5052-be6d-11dadf68fb17','','','Hort. kew. 1:68.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('741805b9-c60a-580a-9ff4-2946e2085ff8','','','Bot. Jahrb. Syst. 30:312.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ba33c1c-d38b-5e93-bfa5-241737553fb2','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 6:670.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f89448c0-0d9c-5062-9194-7491cbed4cfc','','','Bol. Soc. Brot. sér. 2, 25:107.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8afe53e-cf1e-56a7-a4a5-5bdde5b83f29','','','Mem. New York Bot. Gard. 35:600.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93b73853-5551-56a3-a1f3-ce2368957519','','','Feddes Repert. 95:492.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37cff2e2-353c-5dcb-8d9d-c3afb5775a1a','','','Symb. antill. 2:266.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c62f512-1f95-54e9-b424-f17b37b31916','','','Ill. Himal. pl. t. 19.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0aa38a9-08fc-5b23-9260-137fe889be63','','','Bull. Bur. Pl. Industr. U.S.D.A. 68:54.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9af3d517-cffe-57a3-a23e-d571a3bfe1c8','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(2):13.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc252876-1761-5a3a-bb43-1c55326d5a93','','','Flora 37:162.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad48036b-dde2-5ddb-8425-977ff66f14c2','','','Telopea 9:799.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c45bd75-6fe7-5bf2-9b26-b09af4f527ca','','','Bot. Jahrb. Syst. 6:239.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da9cca53-f393-544c-a187-9515b6659e2e','','','J. SouthW. Forest. Coll. 11:3.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('276e1ca5-6f40-5119-9ed3-16ac90f79470','','','Fragm. 10:31.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0342c2e-ad93-54d8-ab4e-2e9f5f5fb215','','','Fragm. 4:132.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ee9a623-b863-5eac-b0e7-b798870cb111','','','Fl. Hawaiian Isl. 28.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea5ae12b-4dca-5bf2-ba4a-8040e24ee106','','','Bot. voy. Sulphur 158, t. 51.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e787cebc-44b7-5228-aab6-be7d08d96236','','','Phytologia 2:476.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d2a24f4-cebf-51f1-b0cf-8f66cc63ec82','','','Madroño 66:68.  2019','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f27beeb-6d2e-54ed-a3fc-a5e2eb4eed2c','','','C. Backeberg & F. M. Knuth, Kaktus-ABC 110.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ae0a99e-9d78-5855-8245-500efd554d3a','','','Z. Sukkulentenk. 2:187.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88f25ae1-55e4-540c-8232-537d8f526c0f','','','F. A. Körnicke & H. Werner, Handb. Getreideb. 1:210.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0b0d7d6-ddda-50bf-b81e-7fb51ebf2508','','','F. L. E. Diels & E. Pritzel, Bot. Jahrb. Syst. 35:130.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dba7e753-94b1-58f1-bfef-a78c27b71100','','','V. L. Komarov, Fl. URSS 6:488.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba00214f-8641-5c3a-b3d6-2e9d135262ca','','','Fl. Antill. 3:37.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cb0536f-2737-5d74-b235-2b4be8dbf0d4','','','Trans. Linn. Soc. London 30:583.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a21952d-991f-5a3e-b10f-ddf9c7c174b2','','','Agron. Lusit. 24:173.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0217630-f6ee-5f95-a564-40a6d4c125ae','','','J. Bot. 14:356.  1876 (J. Bot. 15:9.  1877)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b9cdf82-861f-501e-9617-181a14048503','','','J. Bot. 25:130.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d41785af-43a0-5c36-90ca-1157bcd9826f','','','Bot. Jahrb. Syst. 19:119.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a719a0d1-4488-5df4-9f32-06057d775758','','','D. Oliver, Fl. trop. Afr. 2:101.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f9e5226-cee6-5380-9ad8-9637ae6e8323','','','Mém. Soc. Imp. Naturalistes Moscou 5:355.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b072371e-b572-5278-b2dc-60be52a991eb','','','Bol. Soc. Brot. 6:140.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39679bc5-dc35-50b4-b36b-3b95f431deef','','','Bull. Soc. Bot. France 32:338.  1886 ("1885")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d578f13-5785-56e3-95df-992f01168b98','','','Madroño 18:120.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a388fb0f-5d28-512a-a87f-6dde61cff019','','','E. Jahandiez & R. Maire, Cat. pl. Maroc 2:273.  1932 "<I>tinei</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a94ebde9-fbd1-547f-88a8-d299f28d9808','','','J. Fac. Sci. Univ. Tokyo, Sect. 3, Bot. 7:127.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6c46c92-c759-5f3b-a341-718bcd5a4bd2','','','Enum. pl. Inarim. 371, t. 18.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a735356-3552-57e7-854c-99f3495191d9','','','Bull. Herb. Boissier sér. 2, 2:418,480.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('409b6d89-216c-54da-944a-539f6a75e3bf','','','Amer. Potato J. 58(3):131.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fb99095-5df2-5b30-85b9-fdd35c3686e7','','','Proc. Calif. Acad. Sci. ser. 2, 5:681.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a49d21e0-dd4d-508f-b191-5d0ec8edc862','','','Acta Phytotax. Sin. 19:87.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed96f23e-e8ee-58fb-a03c-8119591d5c41','','','Bot. Repos. 5: t. 320.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1596dcb2-90a1-5bf6-8900-31554403d7c2','','','Monogr. Syst. Bot. Missouri Bot. Gard. 14:95.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f86327ec-c101-5697-8e7d-fd8da64b76a2','','','Flow. Pl. Africa 44: t. 1723.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b1d9da7-25d9-5fbc-9ff0-26d59a93fb95','','','Gram. panic. 193.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('577f1dac-1225-53f8-8ebb-0fa24a679b21','','','Fl. ind. ed. 1832, 3:22.  1832 (non Roxb. 1814)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef24c8fc-a0e8-5ae3-87f6-0a221f30683c','','','Prodr. 1:710.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6fbc8ab-e4be-5c22-abe4-bf5f6a6468ad','','','Bot. Mag. (Tokyo) 32:251.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfff6283-0eec-5c6d-aafe-e61c414e482e','','','Allg. Bot. Z. Syst. 12:5.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d524e93-7f0e-5c07-9606-0050e57d88c2','','','Fl. atlant. 2:69.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bf76aa5-06c3-5eb9-bcad-129c13c65808','','','Bull. Soc. Bot. France 85:165.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('425a1493-8bba-5bf4-a7c4-f52512c1cc73','','','Bull. Mus. Hist. Nat. (Paris) ser. 2, 4:739.  1932 (repr. Archivos Jard. Bot. Rio Janeiro 6:44.  1933)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b2986e6-64e6-5415-b5e1-fba9180dc05c','','','Sp. pl. 1:174.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('081236e5-4b0c-5ff6-8434-9c924bd5bd15','','','Bull. Herb. Boissier sér. 2, 6:318.  1906, Ill. Handb. Laubholzk. 1:685, t. 379.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e08d8aa-551a-592d-a54a-7d070dcf407f','','','Bull. Soc. Imp. Naturalistes Moscou 15(2):347.  1842 (Enum. pl. desert. Songor.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e466ac04-5cf5-5f15-8fcc-e12c6b7a507d','','','J. Bot. Agric. 3:79.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cfff241-2cad-52f9-bf57-776fa674fb8f','','','Repert. Spec. Nov. Regni Veg. 6:101.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae8bc013-041a-53b3-ad62-76aa41199dc8','','','Gard. dict. ed. 8: <I>Echium</I> no. 6.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('398dc55b-780a-5e51-9ef2-514e1a693232','','','Hist. nat. méd. Casses 116.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d95aaf25-70b1-5924-bc75-8c89a57690a6','','','Novon 17:506.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aca24803-34ea-59b6-a9c8-1448e95ff5fb','','','Bothalia 3:63.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83a736d9-8198-5a3c-b111-358592a65870','','','Rev. Bot. Appl. Agric. Trop. 12:276.  1932 (Standley, Trop. Woods 33:19.  1933)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90692e43-8c87-58fa-9103-19cc55f76e29','','','Bull. Torrey Bot. Club 50:203.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bfe2dce-a8a0-558e-b220-5211c2f1aed9','','','Zametki Sist. Geogr. Rast. 27:78.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8b6c80e-41e1-51ab-abcb-939e8959d2d7','','','J. Bot. 42:72.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a761c350-42bb-517b-a71f-172fd8e486f6','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 7:110.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('430c3dd5-4ed0-52dd-b85e-7b382c41a28b','','','Repert. Spec. Nov. Regni Veg. 12:404.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed4bbb7c-424b-5d99-a240-edcbcf50608c','','','Proc. Calif. Acad. Sci. ser. 2, 5:661.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68dd17eb-9010-59f0-8496-a164ad1baed5','','','Bot. Repos. 3: t. 215.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a2bc7e8-4843-5157-9bb3-8593541cc790','','','Bull. Torrey Bot. Club 29:244.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e5fbf31-365e-5ddc-9331-e3f1c18d215c','','','J. S. African Bot. 5:37.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('264168c5-6a76-583b-9365-aff16a7e44b4','','','Bol. Soc. Brot. sér. 2, 44:190.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a2cdafe-a7d9-5ad2-a092-c3b29d0e8295','','','Acta Sci. Nat. Univ. Sunyatseni 20:92.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5383e5d8-3aff-5a48-9c28-5c325493e6fa','','','Fl. orient. 4:566.  1879 "<I>Satureia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cca5e735-7c13-5376-ae86-7f6a903acc3a','','','Repert. Spec. Nov. Regni Veg. 16:120.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db27c90c-5874-520f-9ffc-6184ff9422f4','','','Repert. Spec. Nov. Regni Veg. Sonderbeih. C 24, t. 94.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e24c2587-2c97-59e8-a04f-753000f5e299','','','Contr. Dudley Herb. 3:178.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05df4684-70dd-5fcb-b2ed-1510e9f9bc9f','','','Câyco Viêtnam 2(2):1007.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5b49466-792b-5766-ab8e-32b31a9db6d6','','','Kew Bull. 1949:408.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69d372e4-562a-5f14-8a20-85e847166cbb','','','Syn. gen. compos. 210. 1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25b49a93-59b2-51dc-91d2-773196858906','','','Mem. Natl. Acad. Sci. 20:66, t. 75.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19695584-9220-52d3-acff-d49fb71fa8ab','','','J. Jap. Bot. 1(12):40.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3aa8d9e9-496b-5448-be23-7d22840e0878','','','Revis. gen. pl. 1:175.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec99664e-9978-5353-a326-d7ede058b5e0','','','Paxton''s Fl. Gard. 2:73.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb1c525c-9f20-5e56-823c-a090e728e640','','','Bot. J. Linn. Soc. 79:63.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a51c2c57-0830-5e82-a366-c5fa19d45522','','','Linnaea 12:136.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3243595-99be-596d-882d-c9c2f4917246','','','Fl. N. Amer. 2:16.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8cdbfa5-85a5-5b16-b2f2-e5bd71d2fc6b','','','Monogr. <I>Digitaria</I> 370.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61083344-5119-5fca-a18c-d2546b050798','','','Candollea 43:564.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7d02265-8c41-57f2-8619-29c459491a56','','','Diagn. pl. orient. ser. 1, 13:26.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d936c83a-2331-57f7-83b9-50b8e2e879e5','','','Bot. Jahrb. Syst. 84:341.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('252c1c9e-ef38-5cc0-b6d4-13b1ff101af1','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:140[folio]; 2:176[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e66ed966-f1bc-585c-b8e1-bebf8bdf1ca2','','','Fragm. 6:7.  1867 "<I>Velleya</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2df4a0b4-95e8-5e21-bf8a-d63d398ea77b','','','Trans. Linn. Soc. London 26:101.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58c27b64-3a05-5830-923f-9348d3fb9449','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 5:610.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcadc8ce-4792-5118-bf24-bb9cb9fe9523','','','Syn. fl. N. Amer. 1(2):8.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a00934ac-1a2d-536e-b5ad-e4ffda2d55d9','','','C. S. Sargent, Pl. wilson. 2:518.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cda0d7b4-c95a-5c12-803e-abf2e0a46d44','','','P. E. Boissier, Fl. orient. 4:446.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d490af5-4c1a-510f-8dcc-4af7ba5e9c8a','','','E. H. F. Meyer & J. F. Drège, Comm. pl. Afr. austr. 78.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab7380ca-dd18-5185-9114-28006746e434','','','Novon 10:7.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edc1f6f0-e5c5-592f-9e72-2f68fa0adeb7','','','Legum. Trop. Africa 632.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51ef758d-e6d0-55e1-bf7a-60e9da093ff8','','','Syst. nat. ed. 10, 2:1079.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2020e6a1-0451-52b4-a510-4c1d13415811','','','Biosyst. monogr. Cucumis 72.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9afbcb7-e191-5999-a8e9-16e7d57f34f5','','','Allg. Gartenzeitung 23:18.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcfe25eb-350b-5e5e-a041-59de96886704','','','Cact. Succ. J. (Los Angeles) 72:189.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83ad0cd6-9716-5c87-8a92-0336b144583b','','','Fl. pedem. 1:258.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d0b5954-02a7-5a09-91c2-ea2cec4f8833','','','Prodr. 6:341.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0f66284-e2a4-5e86-b729-e92ea061f210','','','Fl. cochinch. 2:661.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91bb322b-a14c-51d2-943b-2050c226937b','','','Rhodora 93:112.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d86c3d3a-9079-5167-b122-f7ce0c5fa959','','','Biologia (Lahore) 12:33.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a625df7-6554-593f-bcbe-9beace886586','','','Ziraat Vekâleti Yayın 716:94.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51ed8346-5307-5694-a92c-8a3625d598d2','','','Bijdr. 162.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59f62756-a73b-5c70-879e-15ba5fb8545a','','','Fl. bor.-amer. 2:186, t. 46.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b050d9aa-f2f7-5b43-9d58-f99c98695332','','','Invent. Seeds U.S.D.A. Bur. Pl. Industr. 34:14.  1915 (Vilm. Blumengärtn. ed. 3, 1:215.  1894, pro syn.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbae08fd-4ed9-5cda-9f27-f5639d87fd18','','','Nova Acta Acad. Sci. Imp. Petrop. Hist. Acad. 14:166.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d5ec242-62f5-5960-aaea-4e2a18d26397','','','Fl. Italia 1:108.  1896 "<I>dicoccum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a15d6897-c061-5f58-abce-9b55c3255472','','','Pulle, Fl. Suriname 2(2):329.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a297d54-c422-5365-aa44-d3efad4ae605','','','Teysmannia 17:31.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('217c2bf6-9314-5b77-bff9-6853d4bf8f3b','','','Proc. Amer. Acad. Arts 21:364.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53cd74cc-423d-5e2f-a3ed-fed23b3f4d47','','','W. Roxburgh, Fl. ind. 2:15.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bc66963-1819-531b-a92e-eee6a53bef6d','','','Bot. Jahrb. Syst. 35:674.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c42d800-5823-59f7-8690-1ceb95b70451','','','Nov. Holl. pl. 2:100, t. 249.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0919efe1-ea2e-5071-994f-9ad5ff9f9e6e','','','Fl. exped. Szechenyi, in As. centr. coll. 58.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d0a6c7e-399d-5cc3-a8b9-bc4320d0ad67','','','Sida 9:353.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea548deb-876c-5244-9cd4-4a94d86fbe25','','','Erythea 7:121.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e316581-c993-5cc0-83ce-8fa540086fc2','','','J. M. Coulter, Contr. U.S. Natl. Herb. 3:362.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28373dc9-82cf-54c3-828f-a1df992fab3f','','','Flora 53:169.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce78ca54-3929-5ca9-98fa-4e93745c7d4b','','','Muelleria 6:197.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b195820-9757-536f-87e8-a616e76725a5','','','Madroño 10:118, t. 4.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5111b9b9-a5f8-52c4-9a09-a400a542f410','','','Ann. Sci. Nat., Bot. sér. 4, 14:319.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8945085-66cc-5868-8ff6-11073a82744f','','','Bull. Torrey Bot. Club 40:466.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04ac8305-8fb9-5a98-8e3e-3b1b4eebec12','','','Suppl. pl. succ. 83.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4830b0dd-82c1-597a-abbf-24595bb06756','','','Fl. novo-galiciana 12:1119.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfa88c76-0049-529c-b11e-222951a4873b','','','Bot. Mag. 49: t. 2331.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e9387ae-9cb8-5016-813c-a7f1d44e9759','','','Cact. Succ. J. (Los Angeles) 47:122.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3595d463-2195-5ce0-ad41-fb7efe69072d','','','Linnaea 11:200.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cc81de0-4532-56fb-a6e2-4ce5bb62587a','','','J. Arnold Arbor. 3:44.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb76dbea-430c-5765-b563-3914162a71eb','','','Austral. J. Bot. 30:428.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('960677cb-c2d1-52c4-af43-99d0ee9a9baa','','','Gen. hist. 4:391.  1837-1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc2f043d-5e75-5507-b858-909b302e7bc9','','','Wiss. Ergebn. Deut. Zentr.-Afr. Exped. (1907-1908), Bot. 2:243.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34975ab6-eb28-5cf4-a987-28bfbf7b3e91','','','Bot. Gaz. 13:209.  1888 "<I>watsoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36a7e335-5efb-5a6e-aee6-274beb22790a','','','Annuario Reale Ist. Bot. Roma 8:341.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2211c013-42e4-50d0-9687-16f7ba82840a','','','Edwards''s Bot. Reg. 20: sub t. 1685.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d705e2b2-2d00-5c1b-985d-06c75e20d183','','','Vict. Naturalist 73:162.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23086b8f-9a50-5aaf-ba18-c0b4249326a5','','','J. Linn. Soc., Bot. 57:356.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aeb6979f-aa37-500a-8241-02f81e551125','','','Bot. Reg. 11: t. 875.  1825 "<I>richardsoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29f553f2-9385-536d-9af8-acb5c47319d1','','','Hist. pl. Guiane 708, t. 282.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f4849d6-0565-5672-aa92-b8847a905db5','','','Gard. Chron. 1868:1138.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('682e33e7-e23a-5109-9281-5824897ed9e7','','','Ess. Agrostogr. 51, 171, 178.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('067948c9-0605-564e-940e-4cba76028f32','','','Meded. ''S Lands Plantent. 19:630.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7845ad9-f119-5a03-853a-30b4df2153fb','','','J. Arnold Arbor. 3:219.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b725f8ad-a645-56a9-9aca-761ab22610aa','','','Fl. Brit. India 5:760.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09766c01-f949-526e-b9bc-bb9bd3a82171','','','Univ. Calif. Publ. Bot. 18:64.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f72547a8-3bda-5848-8f11-d35147c53e3c','','','P. E. Boissier, Diagn. pl. orient. ser. 2, 1:30.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5cdd550-1b53-595e-a10c-88e057c49fa9','','','Anales Mus. Nac. Montevideo 4(2):122, fig. 33.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48851184-195f-5847-972a-b93ed7ed7f9c','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(3):335.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c917a46-f6f8-5f4e-8461-078411941422','','','Phytologia 3:280.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19ed012a-b025-5b15-958e-c5bcf14ddaed','','','Syn. fl. N. Amer. 2(1):288.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff5c1600-6559-5dcb-a7f8-feb84dc37d64','','','Bull. Herb. Boissier 4(app. 3):13.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dca1f610-e3f0-5ae8-9674-0254aeeab9e5','','','Sp. pl. 2:950.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72830047-b829-5630-9a55-b34221f45dc4','','','A. Gray, Syn. fl. N. Amer. 1(1):268.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93065682-2dcb-5d24-9f05-c0ef69347595','','','Indig. grass. N. Zeal. t. 49a.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d812a55-95bf-5827-9c19-fd9539ff5cc3','','','Wrightia 2:188.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02f3814b-d061-5b96-b52f-af1cbb8987bf','','','Acta Biol. Plateau Sin. 7:14.  1988 ("1987")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f6df141-7a76-5ff2-86a3-b5e59a6d1c48','','','Manual ed. 3:104.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4af6ebc4-d247-506a-b9ae-3bfe2aa5b3fa','','','Rhodora 32:90.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47d956df-1685-5570-abe8-126294c4625c','','','Parad. lond. 1(1): t. 31.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4ad1632-3927-553d-a741-d3f966fdb13e','','','Nov. Holl. pl. 1:67, t. 92.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a660870-41fb-5b2b-8e72-06409474284d','','','C. S. Sargent, Pl. wilson. 3:296.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd0b7259-c284-5651-9a8e-a3f30efcba10','','','Foldmuv. Erdek. 10:561.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66f7b0e1-5801-5024-94e3-4607536ffbdc','','','Mem. Gray Herb. 3:79, t. 15, 30, fig. 5.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ccf706a-cfcb-51d2-a73d-408fd314c404','','','Adansonia 1:142.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b48b551-1a2a-5443-b931-9b7320578f0d','','','Taxon 66:1387.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dde7552b-6a8f-5c55-8111-a7962cada94f','','','Cact. 2:160.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('171675b2-1bef-527f-b01a-2de09b777d0f','','','Fl. atlant. 1:180, t. 51.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fb11cd0-bcfe-50d9-b53b-33d103b82c20','','','Rev. Hort. (Paris) 40:154.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c43c58c1-55f2-5656-90b9-ed8f06ea6b5f','','','Abbild. Beschr. Cact. 1: sub t. 4.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('720c2689-5abe-545a-bffa-9775ed74b7a0','','','Encycl. 1:595.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42f905b6-a252-5922-98ef-8ce9d360a77a','','','Trans. Nat. Hist. Soc. Taiwan 26:218.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c85ec62-8718-5532-9dd4-e244fad2cf99','','','Fl. Iranica 177:69.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0e59465-106e-50fd-8f86-44f3f943b4f2','','','Interpr. Herb. amboin. 190.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b069b9b0-a40a-5c67-9587-03dd41eb2051','','','Icon. pl. Ind. orient. 5(2):5, t. 1791.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ae3abd4-e931-5c07-bbee-e280bea0e720','','','Burbidge, Narcissus 79.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba7a8a57-604f-5cd2-a237-c5cc602cb18f','','','K. P. J. Sprengel, Neue Entd. 2:78.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78af16d1-db03-5358-bb13-a8ae8e98cdaf','','','Index kew. 1:40.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb13a5af-6357-5948-a39a-7193f3c8fc8a','','','Verh. Bot. Vereins Prov. Brandenburg 54:219.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48df53d3-aff6-50c4-85fc-823b4cf5d161','','','Bull. Jard. Bot. Buitenzorg sér. 3, 9:355, fig. 19.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('164200dc-3682-5f00-a074-d1c6114e42ea','','','London J. Bot. 1:327.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac59f858-b639-56e7-80e5-3cdcb83f4b2f','','','Fl. ind. ed. 1832, 3:768.  1832 (Hort. bengal. 72.  1814, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15b07663-1baf-5011-ab19-0900b007b542','','','K. O. R. P. P. Graebner, Syn. mitteleur. Fl. 5:274.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5de8707-10c5-5f32-9bb3-a9b62ab2d5fc','','','Pl. wright. 2:14.  1853 (Smithsonian Contr. Knowl. 5, Art. 6)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4053eeb2-22b0-5278-bb43-e67badeb0aa9','','','Linnaea 12:557.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc0f7af0-ee2c-5183-b8f9-70598f0e74da','','','Trans. Linn. Soc. London 4:178.  1798 May ("1797")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79f588c3-422e-57fb-be19-705582b8e2dc','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:348.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67a5c5ba-43f5-5682-b595-aa7dc2ac0547','','','Bull. Misc. Inform. Kew 1914:76.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2608471-a5c1-5851-ba0c-a61e14d77c47','','','Linnaea 2:369.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49eee51c-a4ab-54e2-9341-bef8803822a1','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 17:83, t. 6.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13df0a4d-1d2e-5054-b192-0b68b18e0d1e','','','Haandb. Danske fl. ed. 2, 48.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1905594d-cd4c-5741-ad3c-1e625b18af15','','','Sp. pl. 2(1):348.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93a4e454-199d-5244-8a7b-23d99940accd','','','Pl. jard. Rio de Janeiro 1:14, t. 4b.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcd1c7f4-01fd-5ad2-a19f-d59af4e0eec3','','','J. Bot. 6:49.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a463b5a3-9a53-5e25-a8c0-922d5bc54f69','','','Nov. Holl. pl. 2:13, t. 152.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d1b09f3-ed47-5662-9227-d76993eb454a','','','Syst. Verz. 247.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('389bb598-4c01-5f36-846e-131d95db8d16','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 32:486; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 12:726.  1888 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22f866a7-42fb-583b-93ed-0a75750cbe9a','','','Syst. veg. 5:295.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('701651bf-5107-5b5e-87c6-4126cad6f20c','','','Sp. pl. 2:815.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a503722d-eccf-53a5-842d-a02a5058d307','','','Prodr. 10:174.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74e81e37-7b27-5d8a-a89f-e931c2098527','','','Comun. Inst. Nac. Invest. Agrar., Ser. Recurs. Nat. (Madrid) 1974(2):23.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9ed6f80-2bfd-5adb-85fb-44d6adcd458e','','','Willdenowia 13:86.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4cc3eb3-7a60-5307-a8e6-8b148d72be65','','','Diagn. pl. orient. ser. 1, 11:66.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56ff331d-a2ba-506f-a380-4e14480aac84','','','Notes Roy. Bot. Gard. Edinburgh 28:21.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de7d3b3d-153e-5610-8196-74f0d0c507b9','','','Z. Sukkulentenk. 2:184.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81f4f9b0-c445-5b67-99c9-f6455119f2ea','','','Bot. Gaz. 30:342.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d85db0d4-141d-5bc7-9561-49f56fd3bba3','','','Brittonia 33:446.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae203009-3762-519a-9fd3-1c940ddd4f1e','','','Cat. pl.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d599049-9c33-568b-87dd-3183c99226e4','','','Kulturnaya Fl. SSSR 1:169.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d619c11d-2342-5a1f-b257-c78a607f3c2b','','','Ill. Handb. Laubholzk. 1:726, ad nota.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e2c07cf-cee5-5391-b0b6-d8133c8a20f9','','','Fruct. sem. pl. 2:383.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ca2d659-9f4f-5ade-8970-f87cff7d0d3b','','','Proc. Amer. Acad. Arts 6:234.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('555ce9a8-f4eb-534b-9b03-4b90d6bfb15c','','','Ann. Mus. Bot. Lugduno-Batavi 2:254, t. 8.  1866 "<I>crenatum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d86e159c-df93-5e84-808f-450d1e0d29b3','','','Trans. Linn. Soc. London 8:312, t. 15.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e27d71be-2d73-56a0-a78a-badac6e00d8b','','','Diss 4:223, t. 97, fig. 3.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c2bc6fb-a4e7-5b93-bc8e-0c9f9f2e4167','','','J. Proc. Roy. Soc. New South Wales 55:266.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8fdc1e3-94e8-5cca-854f-be30128b0828','','','H. G. A. Engler, Pflanzenr. IV. 46(Heft 20):264.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81cd4eeb-7ba5-5852-ad95-d19ab4e60229','','','Blumea 31:388.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23a19d15-23f1-54c5-a321-1c3f91230a57','','','Eriogonum 90.  1936 "<I>heermanni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf4ca636-002d-5881-b42c-411d87352e26','','','Phytologia 2:28.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('616c57f8-b2dd-553b-8870-61f6108275ea','','','J. Agric. Res. 1:433.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('114f96eb-d6ae-53d0-acf1-3f484f275e71','','','Fl. taur.-caucas. 2:179.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('901759f4-bc16-5650-b328-cd2782fc9401','','','Bot. Gaz. 41:335.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('336ac0ca-1d11-5c48-a464-63882bc20065','','','J. Torrey & A. Gray, Fl. N. Amer. 1:346.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ed1d69a-bc9a-5e1f-a154-02f0981a2f3f','','','Adansonia sér. 2, 9:90.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b798ecba-d895-55c9-9ada-e1f7051ed998','','','Bol. Soc. Brot. sér. 2, 39:13.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('335a4103-f787-59dd-9c8d-305a9393b869','','','PhytoKeys 171:39.  2021','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad32f7cb-fc25-5fdb-b4e3-ab2e56a922d3','','','Syn. fl. germ. helv. ed. 2:1017.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4661082c-f6c9-5683-8e4f-a6886c78a8c7','','','Cat. Sem. Tokyo 8.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2997ba8-974f-5431-971b-5d850f8c671a','','','Ill. Handb. Laubholzk. 1:16.  1904, pro syn.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ef66beb-6097-5a3f-89f8-7f7676a08f46','','','Linnaea 9:309.  1834 (ex C. B. Trinius, Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 4(2):96.  1836)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e88e22f-1e87-56fa-83db-418a7aa01727','','','Oesterr. Bot. Z. 40:424.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee7ce83e-e29b-5d4e-bcd0-2f5087290151','','','Kew Bull. 1957:94.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2439299f-89c9-5783-bf7e-79abf83d9a59','','','Proc. Amer. Acad. Arts 11:77.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43622027-b65d-540a-a957-9779249893fb','','','Mem. Real Acad. Ci. Exac. Madrid 2:473.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72e0e21e-971d-55c8-9999-15fb1a5c195e','','','J. Linn. Soc., Bot. 26:499.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddeccce5-f9ca-5b48-86cd-a5d62c63f76c','','','J. Roy. Soc. Western Australia 47:60.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4e7d777-b39e-53b1-877f-2cd05d9ef336','','','Bull. Soc. Bot. France 54:164.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('731c99c9-ccdf-5216-847a-be1adf0ec70a','','','Ill. Hort. 11(Misc.):64.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e1bd4e8-8075-5616-99ef-c1abc215a96d','','','Bull. Inst. Franç. Afrique Noire, A 22:106.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5597233-6d45-5ba6-95c1-1b4ae0b9b18e','','','Fl. N. Amer. 2:47.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffbe04f1-e336-53fc-9c57-3aedf9377866','','','S. African J. Bot. 75:555.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c63f398c-620a-583f-99d1-09a80081c965','','','Bull. Jard. Bot. Buitenzorg sér. 2, 8:22.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77ab94e6-6bb9-555a-8e25-3e5aebdc20a8','','','Cyper. Gramin. sicul. 49.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33e4d761-6c4d-5b48-b7a3-507b6e6056e3','','','Fl. pleine terre ed. 1:584.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d8a1ced-3711-5bff-8e31-392f8e5e3f9c','','','Bull. Int. Acad. Sci. Cracovie, Cl. Sci. Math. 1910:69.  1910 "<I>himalayense</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('480282d8-e8cf-55b4-9bc1-be8c1d8d6700','','','H. Lecomte, Fl. Indo-Chine 2:158.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b20a905-ac42-5509-80c2-107b708014b6','','','Soc. Bot. Brasil Anais 75.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16bb718d-a879-5018-8416-92b56fe918c4','','','Beitr. Bot. 1:228.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22bdebca-4efe-5eb3-b265-9562dd7a38a0','','','Arch. Esc. Farm. Fac. Sci. Med. Cordoba 9:106.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60da6c81-bd71-5faf-b11c-2da0cf888ba7','','','Handb. Laubholzk. 3:385.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff52c468-82fb-5ab1-9627-ed8cfaecd020','','','Sp. pl. 4(2):1141.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bb93654-cf8b-5a4f-a695-39619b6ff9ad','','','Rumphia 2:54.  1839 ("1836")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17c5aae5-ed2d-5e55-9d29-3ad42e065849','','','Fl. sicul. 1:xx.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbf853fd-2599-5a7b-865a-352ca3441776','','','Fl. bor.-amer. 2:178.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad79a2dd-e96d-5fb0-9fba-1a8df62c474d','','','Monogr. Anonac. 84.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d4c4f1b-35c8-5bda-ba01-164c7476948c','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1853:48.  1854 (Nov. pl. mexic.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19dfd684-4647-531c-b15d-9dbfed309a7b','','','Bull. Misc. Inform. Kew 1894:149.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9eb3b3c3-ce33-59b4-b559-b7fa829a8364','','','J. Arnold Arbor. 36:355.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04ba9664-207a-591f-8edf-7f68a6fcc37b','','','Cact. Succ. J. (Los Angeles) 62:149.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aabb3974-00b0-5ec1-8809-d89cbb5e0d7e','','','Bull. Soc. Dendrol. France 1927:58.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('784fd13e-8114-5cdc-8615-c1c2170492c9','','','London J. Bot. 4:600.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9234e50-cdbf-5002-8664-c6b058018392','','','L. H. Bailey, Rhodora 18:158.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93e0c015-283f-5bdc-aebd-62ef5d6d5fc5','','','Gard. dict. ed. 8: <I>Erysimum</I> no. 3.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da76b909-4f48-5589-ae18-96579361dc22','','','Suom. Kasvio 161.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64d0b3db-489d-56d0-b83f-3d47e382048f','','','Pflanzenr. IV. 61(Heft 19):106.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6644e8d-269e-5271-ac1b-f85c719be5fc','','','Willdenowia 35:243.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cccbc75-fcb8-54f3-9f79-7c57c0401358','','','Encycl. 6:271.  1804 "<I>viridi-flavescens</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adb00fe7-3b91-531c-b61a-58e937d862eb','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 9(1):28.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a914a33f-b2e0-549b-8841-171c35e502f2','','','Austral. J. Bot. 8:364.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f479b2a3-dbe5-5ed0-9a0d-fb1b1e2d9a27','','','Fl. bor.-amer. 2:146.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0dd5985-a118-5749-9108-c1e8c5ac0836','','','Fl. South. U.S. 98.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88d10253-40dd-5b36-a603-c0661df5732c','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 23:313; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 9:721.  1877 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('227fef8c-2837-5b8d-9dde-936901fc1ab3','','','Fl. W. trop. Afr. 1:374.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61395de3-f113-5be8-bbae-f68055e64d7a','','','Bot. Jahrb. Syst. 23:169.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa494edd-4c64-5fc8-a84c-7ce065078ef0','','','Sp. pl. 2:612.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('035a7f96-a688-592d-9151-c968a8af42d8','','','W. Aiton, Hort. kew. 2:420.  1789 "<I>grossulariodes</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('030b01e9-228d-5e82-b5bf-b3251e707554','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 16:128.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e611a5b5-1b3e-5b60-86f5-91ed9cf8f54c','','','Descr. icon. pl. Hung. 1:40, t. 41.  1800-1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c65dee26-d5ca-5f02-af8c-86fce7bd71b5','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 9:335.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71da4163-b34b-51a9-9102-69eefe9af651','','','Hist. pl. Guiane 450, t. 179.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('750a594c-9049-5b65-8e67-07df3f4f68a2','','','Enum. pl. 2:1047.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('762548e3-17fa-543f-b161-4c2fe0a5f254','','','Suppl. pl. 119.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1985008-0227-5c70-8864-b642ccd2b7d3','','','Notizbl. Königl. Bot. Gart. Berlin 5:114.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5955d589-18b9-5a79-8231-9a2ad8abd3ea','','','Palms (1999+) 50:84.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11157038-fbd4-556a-a301-9322771077d8','','','Bull. Misc. Inform. Kew 1914:185.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e670cca6-259d-527e-8184-cf52f4fe97b0','','','Bull. Soc. Bot. France 33:69.  1886 (non Georgi 1775)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3eea23fe-8b19-5eee-b3b9-7337cf5dabd5','','','A. L. P. P. de Candolle, Prodr. 13(2):256.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0296c400-1d00-5208-b073-cb0e1df9fd67','','','Punjab pl. 51.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e9711e1-5189-5bbf-bfc4-4afdaf9c605e','','','J. Bot. (Desvaux) 2:340.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb0f174a-bc98-5dd9-93c9-5ffbbc020669','','','Amer. J. Sci. Arts ser. 2, 1:80.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fbad5d9-f9c5-588a-be79-7e62eca7a49e','','','Bot. Mag. 86: t. 5198.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9efddb08-3edf-5cce-9260-7cfb7377603a','','','Revis. gen. pl. 3(3):167.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('973f638d-0f13-57f7-983b-38cbfe4d122a','','','J. H. Maiden, Crit. revis. Eucalyptus 7:464.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef76324a-fc0f-5cea-a8a5-caf7678a8f3a','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 17:145; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 8:371.  1872 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad875282-be61-5103-9a76-eb1c2820117b','','','A. P. de Candolle, Prodr. 15:497.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a8e64f4-35d6-5c95-a847-bef3d0962b3f','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 26:115.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72746e4e-2e84-57d7-ac29-0033aa680faf','','','Bot. Jahrb. Syst. 27:597.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccd69166-9888-590d-a392-10bf08ff393a','','','Kew Mag. 1:39.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b970c7b3-62ff-5f72-b063-569c23accf64','','','N. Amer. fl. 25:128.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c5e7e8e-6055-5aa3-8497-f3d408ffd635','','','Mem. Amer. Acad. Arts ser. 2, 6:403.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35c15597-c3f3-54fe-a60e-c7615768e7d8','','','Prodr. 101.  1788 (?Linnaeus f., Suppl. pl. 51, 314.  1782 ("1781"))','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a1e2b04-c51b-543c-99ac-b126c9ab10f9','','','Gard. Chron. 1853:791.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8ef7b59-35da-51f6-a906-dab6ef7bdc82','','','Philipp. J. Sci., C 6:398.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b463dc7-9270-50c6-9648-7b2ec229f67e','','','Kew Bull. 32:233.  1977 "<I>novo-guineensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a562273-73dd-5cb4-84af-caeae203f76f','','','Trop. Subtrop. Pflanzenwelt 85:20.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acde8e60-4758-55f3-a47e-fdcf12cd7309','','','Bot. Mag. (Tokyo) 33:204.  1919 (Nakai, Bot. Mag. (Tokyo) 44:511.  1930)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d39e5539-54d0-5a46-9d9c-23e5942ff5bf','','','Prodr. 57.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3690fbae-1f60-5829-9574-33062775e6d8','','','J. Bot. 67:133.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b80fd24-61ae-5928-9f27-c1d2a40e096a','','','Syst. veg. 3:373.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('478ce433-ec25-58f9-90f1-e246641e0733','','','Notes Roy. Bot. Gard. Edinburgh 42:496.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('198237a1-b913-5ccd-8492-c674d26e71a3','','','Flora 24:666.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ee2d610-445a-5d81-ab0c-32bee6eeb4d2','','','Prodr. 1:638.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('468002cb-7a84-54e4-8e75-9ac36f0b2863','','','Bull. Acad. Roy. Sci. Bruxelles 3:171.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4695563-4138-55bd-8b3d-e66b9b600107','','','Bot. Mag. (Tokyo) 37:73.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34e7d47e-506e-5963-8d6e-dc8e78950579','','','Torreya 11:129.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('018b6dab-e428-5097-af24-0048abece9f5','','','Bot. J. Linn. Soc. 98:367.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e818613-8879-5d5b-8841-bad2d2458390','','','Fl. Brit. India 5:766.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc34a4c4-7aab-5c8d-8c0f-f05ac37260c6','','','Commentat. Soc. Regiae Sci. Gott. 9:28.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69488be0-2c56-511b-8d23-86db07c06a72','','','Contr. U.S. Natl. Herb. 1:132.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('709f8749-0fb4-5e75-ba35-fe761feeb055','','','Bot. Jahrb. Syst. 29:608.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d554af4-0c66-50ca-8de1-a97dab78b58e','','','Korn. & H. Werner, Handbuch des Getreidebaus 1:109.  1885 (non Forssk. 1775)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffac6c48-e58f-5b64-8800-5a2e73f7038e','','','J. Torrey & A. Gray, Fl. N. Amer. 1:427.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f63f1434-8e8b-562b-a868-1530a489e239','','','Notes Roy. Bot. Gard. Edinburgh 45:390.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f16946c2-3f6e-5a89-9cdc-8c8459650bc8','','','Mant. pl. 2:223.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fc6bdb5-efa5-5535-a74d-5bd1490c95a5','','','Taxon 46:222.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f35c829-c9dc-5df8-8be2-254bf48bf8c2','','','Rev. Bot. Appl. Agric. Colon. 1:279.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1686321c-b0d7-5a3d-aa64-eeadfa982bda','','','Exell & Wild, Flora Zambesiaca 1(2):444.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('702c9449-0133-5a90-8354-672e19c71993','','','Mus. bot. 2:54.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7952f36-1b67-54ce-a99c-79040abf09ed','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 15(2):149.  1869 (Fl. caucasi)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4a8867d-3714-59a1-a6b5-09157d721e63','','','Adansonia sér. 3, 24:276.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0563774-a5d4-536f-b76b-2c73a898f607','','','Sborn. Balg. Akad. Nauk. 29:42.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a14ca6f-ef6e-5238-aaa1-cd1ffbaef8a9','','','Fl. Pl. Africa 36: t. 1408.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fc42d7a-5103-57a3-ba12-389c45226d11','','','Philipp. J. Sci. 30:81.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fbf382e-e6ef-5694-b271-7d919e2acb4c','','','Israel J. Bot. 20:24.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aaebcd2f-e535-5dab-abe5-14a8d5d1712a','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. ed. 2, 18a:473.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f0739ea-04d7-5c56-bd29-5ea8364a99ee','','','Ill. bot. Himal. Mts. 1(6):214.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16bccbc4-b7a9-5651-a98d-bbc2bd937215','','','Natuurk. Tijdschr. Ned.-Indië 3:329.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e02ecf7-27ce-5844-aba4-753b53eb54b7','','','Suppl. pl. 217.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe1447e6-0df4-5003-9163-5e525305eba1','','','Enum. pl. afric. austral. 326.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce069cd9-6745-5258-81db-65563ef17cd9','','','Fl. Amer. sept. 1:245.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0327953e-c4f5-55c9-879a-298183224cf7','','','Contr. U.S. Natl. Herb. 10:99.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37c9c4c6-4189-5710-99b1-9685154323b1','','','Prodr. 5:401.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8dcd091-2044-575c-86fc-ce490b294c2c','','','L. H. Bailey, Cycl. Amer. hort. 1:242.  1900 (non <I>C. frutescens</I> var. <I>grandiflora</I> Regel 1866)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b9eb231-4c9d-5f75-a640-309c2ef25c95','','','Bull. Cl. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 15:133.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efc1de07-2b12-5451-89d5-fcc208cf2de8','','','Elench. pl. horti matr. 30.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('668789d2-d6e1-5ffe-ab65-f1d64e24acba','','','Repert. Spec. Nov. Regni Veg. 13:168.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d41bfcc2-77d8-56b2-afd5-657cf6e949b1','','','Fl. bor.-amer. 1:89.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa61b27e-c1ad-572a-97a2-e4fa97441068','','','J. Linn. Soc., Bot. 45:127.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff6ac66d-4f82-5006-a249-81a4c43b8b47','','','Proc. Amer. Acad. Arts 3:280.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41292e72-f26c-5679-b0e4-0c0b08068e4a','','','V. L. Komarov, Fl. URSS 3:378, 615.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e249770-a1a2-5d01-bb0d-2e8d3609064e','','','Prodr. 2:417.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84446ad8-19b7-5e2c-8384-4e84c2516fec','','','Lindley, Intr. nat. syst. bot. ed. 2, 449.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf75271f-1ab7-5a48-b22c-9f58f1e42520','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 6:251.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42447eea-6fc2-5efc-bece-c29e42b15475','','','Ann. Mag. Nat. Hist. ser. 3, 1:331.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1f58c8b-43a6-531d-9f09-43a741e5e75c','','','Handb. Laubholzk. 2:236.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1edc9cd0-a681-5be8-9a68-630e3be2eee1','','','Abh. Königl. Ges. Wiss. Göttingen 24:76.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d6657eb-a99c-5840-82e0-eb18fc7cf054','','','Calcutta J. Nat. Hist. 5:56.  1845 ("1844")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34b78ca6-d365-5f8f-8a7d-06bc444edc3a','','','D. Oliver, Fl. trop. Afr. 2:130.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52e5d66f-a2cb-5ec2-99fc-f6992449501e','','','Notes Roy. Bot. Gard. Edinburgh 37:334.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a72cad35-bcf2-51ae-bb67-4338c7b37340','','','Agaven 111.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccc3bf1f-3a7f-54c6-b2a7-96a14a705be2','','','A. L. P. P. de Candolle, Prodr. 16(1):428.  1869 "<I>pseudo-variegata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf21591d-c93f-56f4-a8dd-daba56c0e9b6','','','Bot. Mag. (Tokyo) 35:135.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c0156d1-4b58-53a4-bb07-49d31ac33252','','','J. Arnold Arbor. 29:132.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f44c35d-bc57-5c7b-8965-e38f26436321','','','Bull. Brit. Mus. (Nat. Hist.), Bot. 5:204.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c121534e-96c5-5acb-8081-2a95e8ba4618','','','Bot. Gaz. 6:271.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f957c2d5-5310-5f4f-860a-69c491261eae','','','Nov. gen. sp. pl. 1:37, t. 64.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe91ef26-a7fb-5f70-bd82-999273542518','','','Anz. Akad. Wiss. Wien, Math.-Naturwiss. Kl. 60:96.  1924 ("1923")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d43dcd21-b754-54b7-9071-1cca9b28d523','','','Abh. Königl. Akad. Wiss. Berlin 1857:60.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cbd6445-e139-5790-b1b2-54c4287d9678','','','Handb. Laubh. 1:356.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64c03691-56d0-5354-879c-c561e90e117c','','','Boissiera 9:358.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce4f6451-61cd-5210-9292-7718b672a64e','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 17:103.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3228d27a-bad0-5ef0-8b78-37e6a4fae42c','','','Hooker''s Icon. Pl. 30: t. 2904.  1910 "<I>stoliczkai</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4b46b11-cbbd-51d0-87e4-1465cd2c3c08','','','Contr. Biol. Lab. Sci. Soc. China, Bot. Ser. 8:294.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc68d937-e5af-5207-9f6f-f3f269cdb904','','','Encycl. suppl. 4:452.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b0d5fd8-f309-5498-a76f-b5b8e9488865','','','D. Oliver, Fl. trop. Afr. 2:121.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bb2717c-7ab5-5339-910e-c8d293d4c322','','','Handb. fl. N.S.W. 157.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('404689db-cf18-5474-9fc6-abe681873f7a','','','L. Diels, Bot. Jahrb. Syst. 29:396.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf42538c-53e5-5d1c-a7d3-7205d2b78815','','','Manual ed. 2:335.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e96a708d-7ee4-5d80-9a3e-447e9efc0e66','','','Observ. Gramin. Belg. 106.  1824, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed5c4236-4347-5c76-9b41-36b705909eae','','','J. Proc. Roy. Soc. New South Wales 57:126.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e58313ad-fd38-54dc-9efb-091214945d6a','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 13(3):41.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdd05d9b-610e-52ed-bdcb-eda4de078cf8','','','Brittonia 40:272.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5612e973-d325-5382-bda9-0933e20949ea','','','Candollea 17:29.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13277bb9-0b0e-50ae-bd5c-23098cdf35f0','','','Sitzungsber. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. München 20:255.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6e5a060-0ad9-57fa-a208-4c0b294bc0dc','','','Indian Forester 92:319.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fbc44c1-e3a8-5359-9f6d-5cdf3f2d9976','','','Hort. universel. 1:223.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31a893d3-1608-57fb-a085-4389cfd3b001','','','Syn. pl. succ. 236.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cf4f315-5ca6-5663-a0ee-8f6e9fc54516','','','Prodr. 6:45.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cde9de5-f399-5223-902f-f3b535edc23a','','','Bot. Mag. 54: t. 2743.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('292652aa-567a-55f1-b56d-2674a0660d7c','','','Bot. Jahrb. Syst. 38:324.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11b1fa73-f552-5a55-a696-17562927f54a','','','Hort. woburn. 231.  1833, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66889e11-c942-5714-9931-02aaa1267b07','','','Bull. Herb. Boissier sér. 2, 6:319; Ill. Handb. Laubholzk. 1:713, fig. 394 k-i.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e7df01a-0bd0-5b57-bdad-5c2aba401583','','','A. L. P. P. de Candolle, Prodr. 10:207.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c18d285b-a230-5026-8ee4-f19163784d16','','','Meded. Lands Plantentuin 19:522.  1898 (non Hemsl. 1895)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('daa447a2-a52b-5f81-b22c-3744b7a404a2','','','Amer. J. Bot. 75:104.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f64c3b1-d8fc-57b2-be13-a2620e433ae4','','','Publ. Carnegie Inst. Washington 326:212.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3672ef5d-5627-52ac-987d-52a6b7cdc691','','','Feddes Repert. 74:31.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9060cb75-af5d-5639-9b48-d7816f1592da','','','Ann. Sci. Nat., Bot. sér. 4, 1:212.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42943ce9-3d63-57ca-b90d-2d1bd78b498e','','','Repert. Spec. Nov. Regni Veg. Beih. 85:167.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ed5da96-0d9d-53e9-b0c6-e497e7122957','','','Bot. Mus. Leafl. 9:153.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1acfc7ce-edd6-5b04-acb3-585a087035c9','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 31:102; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 12:545.  1886 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a829d02-7459-5c7e-8fe1-6ef781e80aa4','','','Enum. pl. China bor. 33.  1833 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 2:107.  1835)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc9a00d4-6738-56fb-b6ca-a8f6453b44f5','','','J. Proc. Roy. Soc. New South Wales 52:495.  1919 ("1918")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6413c2a8-77a3-5988-bbb5-366453fe30ec','','','J. B. Stevenson, Sp. Rhodod. 783.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f3faf58-dbce-55b2-9237-fb2d5ec3a207','','','Bull. Torrey Bot. Club 25:617.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b16e596-195e-5887-90b3-7a1eb55748ca','','','J. Bot. 9:108.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e72bf73-1305-5e9c-96a2-c334535aaa3b','','','Sp. pl. 4(2):1011.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b328f3bd-181c-5d34-b512-9476cbcd6728','','','Canad. J. Bot. 40:885.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01164ab4-95ef-54a7-ab4b-6e5106a69d9b','','','Madroño 47:204.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8b34613-3b04-541a-9816-83b5c4da085f','','','Indic. sem. hort. dorpat. 1824(suppl. 2):2.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97a82068-127a-553f-8cdc-210a299cd7b5','','','Bot. Jahrb. Syst. 74:630.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e6673df-cf2b-56e9-8cd1-0d44268a0f0c','','','Phytologia 3:117.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a8173fd-ef46-57bf-a673-7e842accf592','','','Canad. Field-Naturalist  65:78, t. 2.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('736d916e-e389-51d5-90f9-966f84fc894f','','','Proc. Amer. Acad. Arts 10:348.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d3eef72-ffc4-59a3-ab59-511e237d3e67','','','Lithops - fl. stones 217.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c8326dc-ee64-53f3-9793-b291466ff5fe','','','Bot. Jahrb. Syst. 123:263.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('390b621d-b6ca-55ee-a19a-cce76df7fc7b','','','Revista Argent. Agron. 18(2):74.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d24ec498-5031-5812-a05f-6fd349fee31e','','','Fl. Afr. austral. ill. 397.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c78a35e-c37b-5b7e-90e8-22c27f7cce00','','','Fl. nov.-zel. 2:323.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87f2a607-55b3-504c-b67c-8349e0a614cc','','','Prodr. 1:347.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62b2ee82-15b1-5256-ab49-40c825331a58','','','Repert. Spec. Nov. Regni Veg. 18:125.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d05e64a4-8284-52e0-a752-e86b7edf10e4','','','Rumphia 1:107.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95587ff0-a748-52ff-b35c-c09f078b3991','','','Bot. Gaz. 9:87.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cd565ac-1b15-5034-afab-ced3d9624ae1','','','Sp. pl. ed. 2, 1:695.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('209c3564-7eff-5c71-a608-a3cf0fb1f169','','','Fl. s.e. U.S. 896.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6bd70310-3fa7-5d5f-bcf9-e4c807b3a809','','','Univ. Calif. Publ. Bot. 40:80.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b37e4856-7e0f-5d59-a878-7cb2e133c028','','','Commentat. Soc. Regiae Sci. Gott. 9:62.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('438aa3f7-9c32-5baa-8187-df95b78d8331','','','Ill. Hort. 6: t. 205.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8ca0695-2cfc-5d54-9fda-6dcb34d1ed8f','','','Ann. Sci. Nat., Bot. sér. 3, 16:248.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f850dab3-54c6-56c7-99f7-3c99b9808fbe','','','C. S. Sargent, Pl. wilson. 1:394.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f71eb650-ad3e-5af2-9470-128d5cdf1112','','','Pittiera 17:312.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33c8313f-ae9b-57d2-bf25-9378778a162b','','','Abh. Naturwiss. Vereine Bremen 9:125.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b3ca7ea-c217-5749-a5ac-3016659dc550','','','Prodr. 1:720.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cea68af-90b5-5fd2-ad82-ee7e197a48b1','','','Zoë 4:124.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c65511a-df7a-5bf0-81a6-f66079d16c82','','','Great Basin Naturalist 35:333.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3593164e-f18d-5ffb-be75-53126aa4b5a2','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(1a):87.  1893 (G. Bentham, Gen. pl. 3:73.  1880, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3f7c5a4-d954-5b44-912a-8aeb19af351c','','','Bot. Jahrb. Syst. 16:443, pl. 7.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d00c3836-90e0-5329-aaa0-0be312c90c54','','','S. L. Endlicher & E. Fenzl, Nov. stirp. dec. 3:20.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90ec36da-cf3e-599f-a736-287f74a8d0ad','','','Sp. pl. ed. 2, 1:214.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09900df1-b5b2-5112-87cd-114ea9f7e4f2','','','Rhodora 44:340.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5fab7e8-7f39-5c5d-a385-11abc155ea24','','','T. Holzmann, Contr. U.S. Natl. Herb. 3:266.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb9022c5-35b8-5b4f-bc9a-b444930fa24e','','','Arch. Bot. Mém. 7:28.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('135afa54-a334-5f3d-83ec-dc4ffef44cfe','','','N. L. Britton & P. Wilson, Bot. Porto Rico 5:378.  1924 (Sci. Surv. Porto Rico & Virgin Isl.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2086ae6-cda3-5330-94ce-f7ff6011918d','','','Mem. New York Bot. Gard. 74(3):129.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7aa34cc7-b5e7-5926-ac7f-f70ce3a32e78','','','Trees shrubs Japan 12.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ac80903-2ef8-5c47-b463-263f08259ec2','','','Rhodora 48:401.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('390a6a6d-83cf-5b46-a324-61916a7aeb7b','','','Fl. boston. 157.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3792b67a-9c2b-56f6-9360-5a397041dc92','','','Rhodora 42:116.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0f1a989-e4bc-585c-ba09-036d76a2056d','','','Syll. pl. fl. neapol. 168, t. 31.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4b89aab-23ab-531d-aeb3-28ec30a59f83','','','Agrostogr. bras. 28.  1823 "<I>Paspalus inaequivalvis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5abde38e-afdf-5528-a447-ddec0658b392','','','S. Watson et al., Bot. California 2:212, t. 1-2.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5340b426-ee85-5824-a223-b8a445f1ecb0','','','Bull. Misc. Inform. Kew 1939:262.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f24e07b5-ac99-55d2-837e-3f557d1a003a','','','Iconograph of Japanese Citrus fruits (Nippon Kankitsu Zufu) 1:91.  1946 "<I>meyerii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d87b949-4751-509d-ba60-5600ea95a741','','','V. L. Komarov, Fl. URSS 9:505.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('121c7937-b436-59ca-a226-6e576102a562','','','J. Hist. Nat. 2:234.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13458c72-7655-5aa3-a51e-d5fadf38fa7f','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 6:112.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('123d447c-b619-5aa1-b64f-56c6ffb0b74b','','','C. F. von Ledebour, Fl. altaic. 1:209.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43cea62b-950e-5f35-8d93-3c02d5e1c3f4','','','Fl. austral. 4:423.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05674f2f-9ff8-5c8e-b548-8d8692e743e0','','','Bull. Div. Agrostol. U.S.D.A. 18:11.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6fc504d-70dc-58e7-ba4a-3a29e9ed1fd1','','','Brittonia 39:59.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49a8f682-d59f-5ccc-adc0-70d8af2da2e7','','','The wheat plant 256, fig. 138, 159.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a8b8c0e-1f22-5a6a-8419-6f2deeabd6f6','','','Kulturnaya Fl. SSSR 1:86.  1935, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b6dea03-0731-55e9-b7d0-8fc8d864e350','','','Candollea 66:125.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e17a43e2-2703-5861-af0f-f915cd4c5a25','','','Syst. veg. 3:872.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9946b4e-29c2-5d3c-8241-1c803eb0c13e','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 359.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cdef1ce-21d3-5107-9a44-513efcebf8dc','','','Cent. pl. II:10.  1756 (Amoen. acad. 4:307.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12307abe-9cda-5821-8c60-15b59e12f34b','','','Bot. Gaz. 56:53.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f2f1531-5563-542a-99d5-6cf095840581','','','Adansonia 8:52.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1bf16ff-89e8-5017-8472-69b20a249547','','','Ill. pl. orient. 1:163, 168, t. 93.  1844 "<I>olivierii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5374199-3289-5979-97dc-62264cf4bfbb','','','Cent. Euphorb. 35.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9da74af-82f3-5443-ae0a-a74015fd7c60','','','J. Arnold Arbor. 2:61.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddc94008-d764-5657-bba2-939a777c6ba7','','','K. Richter, Pl. eur. 2:72.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('432b69e8-fa95-52cf-bf8e-7b86034c3d5c','','','H. G. A. Engler, Pflanzenr. IV. 241(Heft 30):103.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3ccf605-88aa-535e-98e6-81a0bde9602c','','','Lingnan Sci. J. 6:326.  1930 ("1928")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d65364e-a060-5a08-bc2c-d29dacd51d56','','','New Plantsman 7:41.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c7c9200-1a8c-50b5-8b28-eb44da6207b3','','','Kew Bull. 42:678.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df4ed651-dbe3-5370-a15a-b6ddbc23b12a','','','Hort. brit. ed. 1:334.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d505971-1f74-5ec9-a90c-cea3813a2db6','','','C. Wilkes, U.S. Expl. Exped., Phan. 15:452.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a99b1c63-7c95-5579-881d-41f98099e11a','','','Proc. Linn. Soc. New South Wales 18:15.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('548a976f-644b-511c-8c74-93b59d04c63d','','','Proc. Biol. Soc. Washington 33:48.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea374961-d53e-5927-9e4d-8054a778aeb4','','','Aliso 3:246.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3544119b-b7da-581c-98f0-2df533e510c6','','','Sp. pl. 1:343.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4ded785-ec60-5e49-b967-75499044d4f5','','','Proc. Amer. Acad. Arts 14:290.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cd98d54-09bf-55a1-bc2c-9e423d3e2e34','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 23:103.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba270882-2bd4-5be7-ad69-371a308bedcd','','','U.S. Expl. Exped., Phan. 15:367, t. 44.  1854 "<I>simarubaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8baa2b0-ab62-5eb1-b692-f0db759bbf1b','','','Asiat. Res. 13:429.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00ce10f8-91df-5439-b6d9-ef8f6689c889','','','Encycl. 2:19.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b59e03a7-1a1d-5543-b460-fb1ae13c080c','','','Bot. Repos. 10: t. 653.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d255f90-4657-51a4-95fb-df8d8ef0677d','','','Nuov. gen. sp. monocot. 37.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2caffeec-aade-5738-91ba-fd9c2d907cf4','','','J. Acad. Nat. Sci. Philadelphia 7:66.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('217abe7f-0ffd-5142-9cf0-92c31c4dfa08','','','Sp. pl. 1:358.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ae71e46-ffd5-5a63-8c5e-6735ae950ac6','','','Man. Brit. bot. ed. 2:65.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('029e2eb2-fbda-5967-9198-e9e33b0f5496','','','Bot. Jahrb. Syst. 35:666.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa971150-6ed7-5000-a878-21af06bca131','','','Gard. Chron. ser. 3, 91:438.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75f420f7-86ee-59e5-b8e3-340d441c926b','','','Ros. monogr. 12, t. 1.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('594521da-c819-57e2-94df-09235082c235','','','Fl. Amer. sept. 1:167.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3ca434e-9ab8-5514-a393-39e23de4b7e4','','','Principes 6:44.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fbd49e7-23bb-5fcc-8b8c-4f3db785db88','','','Bull. Torrey Bot. Club 13:26.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cff9864-3c95-559e-a60b-7b817ed7e9f1','','','Fl. ind. ed. 1832, 2:153.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df204efd-87e2-5a18-878a-4357fc8ec1f0','','','Pittonia 3:144.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05e495e7-da35-5d9f-a57d-5158a0dd9228','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 12:77.  1824 (Gen. pl. Umbell.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('764b3960-d6e4-5fc0-b52d-eff733a33707','','','Fl. taur.-caucas. 2:12.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0d47c75-d904-512a-abcc-c832a401428b','','','Ann. Sci. Nat., Bot. sér. 3, 9:295.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4196b39-5027-5986-925d-75dbb107f668','','','Rhodora 19:158.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eec6a278-c71d-58d5-982e-1b4f71779d46','','','J. Bot. 6:112.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c208464b-8533-56a8-991f-d82b891ea9d2','','','Fl. napol. 5:110.  1835-1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc1b8bba-fe69-5f7f-96fc-0a4cbc7ef192','','','Leafl. W. Bot. 7:195.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e813aab1-7cf3-5b75-9f43-1019acf9f044','','','Rep. (Annual) Missouri Bot. Gard. 21:172, t. 26.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa62a413-6047-508e-9e4f-bb835766cbce','','','Handb. fl. Java 2:42.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3dd8fed3-f6fc-5c5c-832c-9aa554ed932f','','','Taxon 29:351.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('537cf921-bf95-5d25-b437-c13b7930f450','','','Rep. Geol. Surv. Arkansas 1888(4):189.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e48c4543-ac0f-5dd0-be7c-2ea89e548e04','','','D. M. van Gelderen et al., Maples of the world 218.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2ab593d-93e2-5d60-970a-dc49fb8376c7','','','Bull. Misc. Inform. Kew 1896:195.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7ab848b-16af-5f47-a064-1ca0fece13a9','','','J. Straits Branch Roy. Asiat. Soc. 73:143.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50faf345-e522-5d07-8228-fccf41cf64b9','','','Webbia 2:170.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2dc7f1ab-10fb-5bfc-94fa-c8dd5046976d','','','Edwards''s Bot. Reg. 26: t. 59.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('670eb689-3f31-525d-8dd2-034c0aac882f','','','Gen. <I>Lavandula</I> 363, 390.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be19e499-dc0b-5721-9460-53d341e9a7af','','','Proc. Biol. Soc. Washington 13:65.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9c2dce2-a702-55f3-bbfa-4e1ecb1058b4','','','Telopea 8:123.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73a2cfe0-a773-51f5-a1d4-aafe3caaa104','','','Fl. carol. 76.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdd9f57b-0074-5ebd-af59-825f3478a677','','','Patriotiska Gallsk. J. 1802:97-106.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('970555ba-53df-529a-aa42-b68794231988','','','Hooker''s Icon. Pl. 20: t. 1952.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83499a9f-9bce-5237-8991-21f40def2d42','','','Beskr. Guin. pl. 338.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27111492-c0e6-58f2-bb61-3531e7639aee','','','Diagn. Cucurb. nouv. 2:67.  1877 (Mém. Couronnés Autres Mém. Acad. Roy. Sci. Belgique 28:67.  1878)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93edd658-f5b0-5f2d-a980-224f2b6ee0bb','','','Icon. pl. formos. 8:30.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73d2829b-ae0d-5537-a753-0b6cfd4e98f2','','','Meded. Rijks-Herb. 27:46.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4ae13ed-4b12-5f61-bda4-abc042267891','','','Notes Roy. Bot. Gard. Edinburgh 44:153.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac3bf295-6f4f-5d10-94b2-eb40e92bcc25','','','Bull. Torrey Bot. Club 69:542.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42f5e034-30b8-53ed-a9ce-c3fb1b1ff268','','','Anales Inst. Biol. Univ. Nac. México 12:93.  1941 "<I>santillani</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0dc38504-4c9d-5fea-81aa-cb419c183a95','','','Hort. beng. 71.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60525f25-0d7d-5fe6-9f94-32317ecef0ec','','','Trans. Linn. Soc. London 30:551.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e592228-d4ef-5f8f-9ff2-01e55a71dff9','','','Proc. Amer. Acad. Arts 63:52.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac7f2c1a-5295-58ab-af63-b80ea84b2376','','','Edwards''s Bot. Reg. 33: t. 15.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e32cbd63-b31d-52da-8d33-21b706ce02c1','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:404[folio]; 6:517[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee869a38-bee9-5fcb-87b5-cb7478d46b6a','','','Kulturnaya Fl. SSSR 2:422.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb225f67-2626-53ff-be1d-2b660c1e6799','','','J. Bamboo Res. 4(1):20.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aa80521-85a1-5354-99eb-f53fcf2d818f','','','Nuovo Giorn. Bot. Ital. n.s., 18:109.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79fb944c-3a06-53e6-8bdf-e4fd3df6310b','','','Sp. pl. 1(2):1186.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e416a116-5e0e-577a-9794-0c9372e9fba0','','','Biblioth. Bot. 19(Heft 83):52.  1914 (Sp. rub. 276.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0520fc02-521e-5ba7-a435-a8caf68821c4','','','W. H. Harvey & O. W. Sonder, Fl. cap. 1:287.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f46468c-548d-5e7b-923b-e14ac80f3471','','','A. R. Franchet, Bull. Soc. Bot. France 33:460.  1887 Mar ("1886") (A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 5(2):458.  1887 Jul)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2901d954-f67c-569d-82b8-3d88d13acf36','','','J. Bot. (Hooker) 2:140.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e83dc43-96d0-5b57-834f-6235fde4a11e','','','Fl. ind. ed. 1832, 3:288.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fedbd91a-73cf-523b-ba9a-b64924c502d1','','','J. Roy. Hort. Soc. 58:37.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c026b980-34ba-598c-bcfa-cb1bbff41c15','','','Proc. Amer. Acad. Arts 10:69.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e261bc98-6856-5ff2-8f86-045dd0905de4','','','P. E. Boissier, Diagn. pl. orient. ser. 2, 1:46.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5d52c12-e2d1-5587-9578-0baa0cc555f8','','','H. G. A. Engler, Pflanzenr. IV. 46(Heft 20):47.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e93611db-f492-5484-ae6f-a3d5fb5e28b4','','','Stand. cycl. hort. 3:1443.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('981e08d6-f767-53da-aa3f-1990ba34c3c5','','','Trudy Prikl. Bot. Prilož. 53:142.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc76f546-6fa9-5b8c-bb1d-047feca6dfc4','','','Bull. Jard. Bot. État Bruxelles 15:371.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c06c0364-11fa-5831-8712-f0b285c7ea7d','','','Encycl. suppl. 2:715.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3041c77-52bb-59a9-b091-e4f39e478c1a','','','J. Proc. Roy. Soc. New South Wales 53:227.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('146613f3-ef14-5db9-9bb5-5b085504084a','','','Bot. Mag. (Tokyo) 29:42.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('068451e9-9448-56b7-b47f-6d6337a5820a','','','Bot. Repos. 10: t. 602.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('128f29fd-eae1-5a92-8513-93f763ae305b','','','Pinet 155.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4210377a-0ee4-5950-aa55-3c1617f34678','','','J. Arnold Arbor. 12:71.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0744a37d-3c66-5944-bc27-2290bda92039','','','Sida 1:85.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6207778b-fd94-5ebb-8966-57132c628d97','','','Linnaea 25:443.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ec44a20-e0ef-539b-a824-92f7822bc27c','','','Fl. orient. 2:1075.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c586dc34-c2ee-56c7-8b3f-fe103bbbc705','','','Fragm. 3:26.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d13a45f-d15f-55dd-acc0-6a8ac86fffa3','','','C. S. Sargent, Trees & shrubs 1:180.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94bb0297-c252-50ab-9c2c-c90e01fd0753','','','Trans. Linn. Soc. London 7:8.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('963f7666-5c3f-526e-9f91-62b255fb606e','','','Ill. bot. Himal. Mts. 1(6):205, 207.  1835; 2(3): t. 38, fig. 2.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a331096a-b5da-51fc-8715-f07ed2900212','','','Trans. & Proc. Roy. Soc. South Australia 36:171.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf27438b-ca15-59c0-a14c-905ffc7ca2df','','','N. Wallich, Pl. asiat. rar. 1:65.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9b5ef58-7385-59e6-bf27-97e705a612aa','','','B. Hayata, J. Coll. Sci. Imp. Univ. Tokyo 30:286.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c589782e-b18e-5d52-bdf4-19ba4adb2250','','','Biblioth. Bot. 22(Heft 89):88(642).  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e70fb06b-ec4a-5048-97f6-28a64aea64a2','','','Anales Inst. Bot. Cavanilles 10:280.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b057b5df-a605-5fda-b812-4ddc1bfdf5e8','','','Fl. jap. 228.  1784 (non L. 1762)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8b2b779-2624-53d3-982c-bada20c57c08','','','Icon. pl. formos. 9:29.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87e87867-5b37-58ad-9649-3e84d7a762a2','','','Stand. cycl. hort. 2:1766.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df03e0a4-682a-527f-8563-d1484876105d','','','Pl. wright. 1:111.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d27758b-a093-5cc4-84f3-84950833978e','','','Kongl. Vetensk. Acad. Nya Handl. 8:63, t. 1, fig. 2.  1787 "<I>nummularifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b33faf55-3049-5c2c-8909-0c487578ecff','','','Mém. Soc. Phys. Genève 35:348.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('968417e7-edfc-57a9-b274-7317d0b089a5','','','Magyar Bot. Lapok 4:30.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc71eed7-845c-51b6-9ed6-6a2ca55f747f','','','Indian Forester 36:352.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('628ef503-78d3-5480-88ec-b297f3b13524','','','Orchid. Mexico & Guatemala t. 13.  1837-1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34f6bd80-4fad-5b91-b3fd-866dd51dd88a','','','Iagttag. over Vextr. Marokko 195.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5193161-fdf8-5448-9d06-1758d523e4d1','','','A. P. de Candolle, Prodr. 2:211.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('192cba30-f607-5996-a9b9-083f28e63fba','','','Hamburger Garten- Blumenzeitung 22:218.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5798603-b1a1-51ea-ad16-a7545605dc5e','','','Arch. Jard. Bot. Rio de Janeiro 4:31.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6319ef6c-4bf8-5600-b604-29c46682d318','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 12:61.  1867 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0aa72a16-b808-583a-b5fd-ead24c0253e6','','','Bibl. index N. Amer. bot. 94.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55f5c7f0-ee4e-5a73-b743-84c1daccffb9','','','Fl. Serres Jard. Eur. 10:211, t. 1055-1056.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d9028b4-d042-569f-85fe-84ccbef047fc','','','Hist. pl. Dauphiné 2:153.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57628b5d-9730-53d7-811e-a444b9c8a851','','','Phytogr. Lusit. select. 2:198.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44196a7f-faa1-5130-92ec-5b29710e0255','','','Novosti Sist. Vyssh. Rast. 31:137.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8cfcf47-8d25-5b4e-93d8-7fe840c4bff2','','','Proc. Amer. Acad. Arts 6:548.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d6651fd-9a08-52ab-8f32-afcdd18c9fd9','','','Fl. bor.-amer. 1:30.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8db3143d-8bfa-5f3f-97d4-f654784d1617','','','Bot. Gaz. 30:335.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a92f126e-0d39-5b18-a543-9c146e1c9415','','','G. Hegi, Ill. Fl. Mitt.-Eur. 4(3):1410.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51202e70-343c-565f-bc65-68cb92f9550e','','','Schischkin, Fl. Yugo-Vostoka 6:181.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('373fcceb-807b-56a6-823f-940da4d3d0ac','','','Syst. veg. 4:460.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78f1f34a-4686-57df-aa6e-04f9e2ed961b','','','Lingnan Sci. J. 6:329.  1930 ("1928")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73edc717-a8ca-581f-8c89-8d7dd7a0ee89','','','Kulturnaya Fl. SSSR 2(2):31.  1990 (A. A. Orlov, Kulturnaya Fl. SSSR 2:156.  1936, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73f0167c-3e6a-5a56-8ba6-59e05f29a03c','','','Handbuch 2:11.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('357ec0d1-7fc0-5dc6-8a5c-8dcbffbc5bfa','','','Sp. pl. 2:1057.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d9ad58d-5f3b-543a-ae1e-40709046bcf8','','','J. Straits Branch Roy. Asiat. Soc. 82:182.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('959f6d50-b712-5098-935e-f4f7a83336f1','','','Bull. Misc. Inform. Kew 1906:159.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f5bf41d-2082-59a3-b991-5842835cc9f5','','','Voy. Barbarie 2:207.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40b53dd8-9b35-5fc4-ba91-758a1a3eaa6d','','','Bot. comm. 1:18.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e420161f-74e3-55e8-a988-0b616678d6a8','','','Bull. Calif. Acad. Sci. 2:152.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dab88207-b50a-5d92-a3b6-446e137338f4','','','Pl. delavay. 222.  1890 "<I>coriacea</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e758b70-f303-588b-a231-1a5d1062fbe6','','','Gard. dict. ed. 8: <I>Linaria</I> no. 6.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9c8941b-4750-50a8-915a-95113b3e8beb','','','Bot. Mag. 18: t. 678.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ef66b40-d2c2-5195-baf7-92fdfd76f267','','','Ann. Sci. Nat., Bot. sér. 4, 11:127.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('787cb68e-bcd5-5ac0-8051-a59ccb24af5b','','','Blumea 42:58.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f42be02d-3fff-5246-9a68-b41431cef96e','','','G. W. J. Mildbraed, Wiss. Erg. deut. Zentr.-Afr. Exped., Bot. 241, t. 27.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df183363-9d70-5a12-b2c5-0359765310e2','','','Proc. Calif. Acad. Sci. 5:50.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb4dc4fd-9efa-588a-ab81-4e4f17132d17','','','N. Amer. fl. 23:277.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('706a3d77-93ce-5097-b3d0-7e0c967b5c38','','','Sp. pl. 1(1):246.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7470a61e-35f1-57f6-8d64-19dec193b03f','','','Bot. Mag. 55: t. 2859.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5be6d461-29e8-526d-9d6b-69107c261162','','','Delect. Sem. Inst. Bot. Sect. Tadshik. Acad. Sci. URSS 12.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c4158c5-b536-584e-8c1a-53a0fca8fcd8','','','Cat. pl. Maroc 4:1038.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d61001f2-5066-5bcc-9791-b9c73fb04c40','','','J. A. Murray, Syst. veg. ed. 14:72.  1784 May-Jun (Fl. jap. 22, t. 5.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc4381cf-5baa-55c2-9b3d-b510e2a6e65b','','','Labiat. gen. spec. 258.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22d3a0e3-c308-5b28-a8cf-37c19f1d32f0','','','Brittonia 31:234.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('975498fe-3a25-5b44-82d2-224d0ae62049','','','Aliso 4:92.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('098c3ab8-df9f-527e-897b-448584198dce','','','Bot. Mag. (Tokyo) 13:71.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c80f06a6-394b-5dd2-8d23-a5cd3b058f49','','','Trans. Amer. Philos. Soc. ser. 2, 7:309.  1840 "<I>foliosum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4da06a9f-e61e-5f94-83c4-fe2560c5663b','','','Man. S. Calif. bot. 601.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('765d15da-6f0f-55cc-bf26-348c38b87a47','','','Rev. n.-amer. <I>Astragalus</I> 163.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1b1e49a-f195-51f7-8117-12aecae2dcc0','','','Bot. Beechey Voy. 19.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9284776-9bc6-5989-b8b3-e049e14d2873','','','Bot. Mag. 134: t. 8202.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b546895-2a14-57e7-97bc-8e4043eb44d9','','','Trans. Linn. Soc. London 25:317.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45d6f817-b75b-58c8-b49f-9b7dcf54c715','','','Gram. unifl. sessquifl. 189.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bcced0a-f833-508e-83e8-b993812c3e36','','','W. Aiton, Hort. kew. 2:421.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ac617cc-881e-5165-ac81-d90602c966fc','','','Quart. J. Sci. Lit. Arts 22:112.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa3fc350-7066-5f96-a8d9-425f49d433f0','','','Gard. Chron. ser. 2, 262.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97a90fa1-4342-5ecb-83d2-b91320c99f06','','','Hist. pl. Guiane 177, t. 68.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9127b7aa-251f-5e6b-a9e8-d71253af73f4','','','Prodr. 2:489.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cc5e6f9-2cb2-5f70-b071-27bbe7d66aa3','','','Rev. Hort. (Paris) 41:377.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8cc471b-ffaf-554c-b92a-d1c9e33ed20c','','','D. Oliver, Fl. trop. Afr. 2:526.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1412f81b-c8b0-5287-abd2-c64346c830e2','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 13:376.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67b63d52-a9c1-566f-a982-fa90ec212815','','','J. Bot. Néerl. 1:127.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32a6ccc6-ba75-5275-baf2-fb9759148818','','','Ann. Sci. Nat., Bot. sér. 2, 13:323.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9aaf892e-4383-5e3a-a933-cbaf1bced1a7','','','Vers. Darstell. Alsin. t. ad p. 57.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9483f7b1-9f09-5d1f-ac8e-7c89ccb7586c','','','H. Schinz & R. Keller, Fl. Schweiz ed. 4, 1:342.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e559b853-a7d0-5aab-84b8-f98826026206','','','A. L. P. P. de Candolle, Prodr. 15(1):211.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5b5e80f-c22f-564a-9e8e-19ed929aa001','','','Expos. fam. nat. pl. 1:337.  1805 "<I>guyanensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('784bae48-9097-541e-ac8a-b342c6458ed7','','','Bot. Mag. 148: t. 8969.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3b3fc57-f773-544e-a36d-72311ead4455','','','A. J. Cavanilles, Icon. 4:37, t. 361-362.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a46276c4-a574-5a15-82ad-fcaa68bdd58a','','','Cuad. Bot. Canaria 7:7.  1969 (non Kit. ex Janka 1871, nom. inval. pro syn.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c3926cd-8463-5eda-bdd3-03dad65f0171','','','Beitr. Pflanzenk. Russ. Reiches 6:20, 61.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dca73449-2d55-511a-b83e-5b2098673add','','','Flora 68:119.  1885 (non Steud. 1855)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d92d4bab-95db-5f11-9c66-96b59fc51c52','','','Prodr. 9:257.  1845 (Ann. Sci. Nat. (Paris) 1:457.  1824, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('364d9184-7965-5299-b994-860ffb2ae6a3','','','Manual 630.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1685776-2bf6-5701-a55d-a6a48d889e09','','','Pl. hartw. 323.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac1a2ec1-93e0-57d5-b375-9e6deefe3cb4','','','Syst. nat. 2:58.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2243ab0f-31e5-5ae9-ad65-897f87772d55','','','Anales Univ. Chile 98:482.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9c4d168-cdf7-5ae3-b91e-69fb54106923','','','Sp. pl. 1:3.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('222a8ebb-868c-5a51-a4b3-c5202ed58fb1','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:350[folio]; 6:447[quarto].  1824 (non (Muhl.) W. P. C. Barton 1818)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06755371-5f4f-5468-839b-392279297a18','','','Suppl. pl. 209.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('005be1e9-bf36-591d-a806-a9db0ef56b14','','','Trans. Linn. Soc. London 27:639.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9791c521-5bd6-5a12-8ed5-1cd4ebed0f6d','','','Cat. pl. Upper Louisiana no. 34.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e307884-10bd-5215-93da-de2f8d60092b','','','Kew Bull. 29:88.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fcd8894-746f-5bea-bb96-5412e211e736','','','Diagn. pl. orient. ser. 1, 2:60.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72fc3f60-b11d-5546-a141-c0e5641fa7d4','','','Prodr. fl. Ind. orient. 323.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b88b808b-b86f-5e23-965a-7ada42853883','','','J. Bot. 22:230.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b481daf1-ff6e-54e6-a1e0-7be77c919090','','','Kew Bull. 52:484.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4526728-f901-5059-8d92-704f4ffda7bb','','','Smithsonian Contr. Bot. 79:45.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b046725-f497-542b-bc8d-936c16161221','','','Bot. J. Linn. Soc. 178:85.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe160a59-924d-5f9c-8e0a-c47c248cc011','','','Sp. pl. 2:711.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce73b48b-11ec-5212-b82b-031377df00c6','','','Bot. Jahrb. Syst. 8:22.  1887 (non Naudin 1851)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91d99ea8-de62-58b4-9759-bba08c862e48','','','J. Bot. 29:171.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49284184-38dc-5149-9d78-a56a6974eb5c','','','Bot. Jahrb. Syst. 114:10.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfc0fc3b-4da0-5abd-9db6-60314de76447','','','Syn. pl. glumac. 1:43.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcb5106b-874d-5f89-9b35-25a4e6f36efd','','','Acta Phytotax. Sin. 36:163.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce85e9fa-f834-5b69-88c4-03b5686b2884','','','Sp. pl. 2:878.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e90404c-d18c-5634-a7d1-335ecedea454','','','Gard. Chron. 1856:260.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2433ecda-8f0b-545e-bbfc-4ddec5957b8c','','','Beskr. Guin. pl. 213.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e1a461c-8131-58c2-b811-4bcfc2583b40','','','C. Wilkes, U.S. Expl. Exped., Phan. 15:272.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5015369-cfee-5f6e-ac23-621a0e4c91ae','','','Pl. hort. schoenbr. 1:43.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9902f65f-e1d5-5915-aa24-60af828fb7bd','','','Natuurk. Tijdschr. Ned.-Indië 24:327(236).  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acc096bd-94f8-5117-902f-0b3a6cd2c7ef','','','Nomencl. bot. ed. 2, 2:221.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7f86aab-dff1-5cfd-98fc-3aadea13cc61','','','Syst. nat. 1:223.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed0b5906-60d7-572c-b9bc-46bfacc0c787','','','Repert. Spec. Nov. Regni Veg. 19:149.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d5f2af8-716c-5619-aa84-799e9c8e1150','','','Leafl. W. Bot. 5:101.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('019cdf50-2eb5-58f3-a9cb-f1f5f88a9354','','','Bull. Jard. Bot. État Bruxelles 9:176.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89128f4b-e81d-5548-90b2-962c09f159aa','','','F. A. W. Miquel, Pl. jungh. 226.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab6f7ddd-31de-56b9-8807-a5ee13b840c5','','','Prodr. 1:437.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe6f7387-a411-5c82-9f49-9e9b3f4a4a00','','','Sunyatsenia 5:169.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbd957b4-3e0f-5b68-9769-5c09d12107f5','','','Enum. hort. berol. alt. 2:241.  1822 (non Hacq. 1790)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56d60878-0c1a-535c-ab2d-c77b594fe55c','','','Acta Univ. Lund., 2, 19:52.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c51f8d7-4476-59ed-8e5d-1883ce7d493d','','','Bot. J. Linn. Soc. 184:433.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fc60f2d-c3cd-5f25-b4ed-6bb9501e595d','','','Biol. cent.-amer., Bot. 3:66.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('752487bf-4f0a-5ac1-b59f-6a4963abee74','','','Diagn. pl. orient. ser. 1, 9:42.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d64ca6fe-be24-5de6-bc53-79bbcc3c0e41','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:17[folio]; 2:21[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('326cf0bb-be85-5749-937d-720bc472b0eb','','','Munz, Man. S. Calif. bot. 447, 600.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48d9fcb9-abe2-5d1e-8283-d8858013585b','','','Kew Bull. 6:191.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e6e8361-e279-55a4-9b66-87e6ae7830c4','','','Taxon 65:56.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90c49043-7ef1-5748-963c-a8a6e275ec50','','','Leafl. W. Bot. 10:181.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9915810f-042b-5212-b469-55f5b948f0ae','','','Bot. Jahrb. Syst. 50:413.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('210faeed-44d9-5b60-825e-d949a1f85c5d','','','J. A. Schultes, Syst. veg. 6:699.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad548c0b-10db-5d6f-945d-e04f9fac78be','','','Mem. New York Bot. Gard. 74(3):143.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58e5da1f-588d-51f1-9cda-5565ce844952','','','Edwards''s Bot. Reg. 25: misc. 72.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc2c8931-ffd4-5801-aa60-697c5e387ffc','','','Icon. 2:54, t. 169.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6555761e-429c-5f08-b5c2-5df06ea045ac','','','Herb. pedem. 2:255.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccf6d858-4344-5d71-9bef-6fdd954f05d7','','','Kurtziana 12-13:183.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a12581e-e6c6-56fb-8284-db92df580178','','','Erythea 3:19.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc41b63c-0eb5-5a2f-aacc-36ef7d2b4d1c','','','Notes pl. crit. 108.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e68fb47d-8eed-5dfa-aa3e-b6a893900b21','','','Fragm. 10:61.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1d0a090-7d64-5b39-b575-a6d8499fbfa4','','','Rev. Fac. Agron. Y Vet. 7:162.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35875221-5f0f-5926-8960-1cac27bb1404','','','Bot. Bull. Dept. Agric. Queensland 2:16.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03fc8b86-d566-5d34-bae5-9911c14eece4','','','Enum. pl. 1:50.  1801 "<I>zosteraefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79dbf67f-4dc9-50c5-83fa-9d57bc708e44','','','Bot. Mus. Leafl. 7:79, t. 2.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4122104d-373c-5601-a78f-e7ff871914d4','','','Sp. pl. 3(2):1209.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a780d3d-4f8c-50c5-ae73-81c28bc3b6f4','','','Amer. Midl. Naturalist 66:466.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac8ca7c6-07e4-586c-9c43-0463467c45a1','','','Gard. Chron. ser. 3, 84:169, fig. 72.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f895e7f-3aa1-52c5-9fd1-97433fd8cded','','','Fl. Franç. 2:580. 1779 ("1778")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8bb17fd-48f3-5c2b-8a53-57a7859f3a0f','','','Novosti Sist. Vyssh. Rast. 5:16.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('157aeb11-6fe6-5ad9-abd3-2cf233402476','','','Catal. prix-courante 149:24.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb36e6e6-daa0-5978-bb4d-3874699459e9','','','Fl. Ned. Ind. 3:645.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50c0005f-6ab8-5fc3-b555-cbcc383353d9','','','Prodr. 5:299.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34c71832-edf3-5f99-bb9b-9bd989c5d863','','','Ann. Sci. Nat., Bot. sér. 3, 1:336.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4ccf4f2-5ca7-54f8-abff-9a90a0f7236f','','','Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 6,4(1-2):95.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9a8d077-c3b1-5ced-8aa5-e593e461a0e6','','','Austral. J. Bot. 25:357.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fe5644b-3fa9-5128-a0f4-c4580520287b','','','F. Osten-Saken & F. J. Ruprecht, Mém. Acad. Imp. Sci. Saint Pétersbourg 14(4):73.  1869 (Sert. tianschan.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d42c3ed-089e-5517-9eca-c6a90a1fea35','','','Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 6,4(1-2):114.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b09a1426-834e-51d0-9394-b18e513483d1','','','Fl. ind. ed. 1832, 3:427.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9857907-b3f9-548e-a593-21fdd5edda08','','','Révis. gramin. 1:361, t. 84.  1830 (1:161.  1829, nomen)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a45126eb-cea7-5827-8604-5a08b597c1d5','','','Sukkulentenkunde 2:24.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae7f2769-9f8e-5fea-9bbd-b78967d07d59','','','Hist. nat. palm. 2:136, 96, fig. 1-2.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('755cde89-f62c-5bf1-a069-9d68b855a501','','','Hort. bogor. desc. 1:305.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1ea2494-0dae-58f1-afa6-bce855426faf','','','Ann. Mus. Bot. Lugduno-Batavi 3:298.  1868 ("1867")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ddac463-d6c0-5c9c-8399-81ee13728d9e','','','Gard. Chron. ser. 2, 6:808.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33ef313d-d556-5613-96fe-3c34dc9dbd87','','','Fl. orient. 5:700.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f11fe118-9a70-534b-957f-c8c882104c63','','','Flora 26:577.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c133f36-1b37-5135-a062-312618a4b4ab','','','Phytologia 10:486.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('814a6ed1-59c4-505e-ab2f-cb4bdf3edb13','','','Fl. Yunnan. 1:73.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c70f3d83-eba3-5970-84a6-a1daf73c0d94','','','J. Bot. 12:105, t. 145, fig. 21.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4763e89c-f47e-5ffd-ae08-4ed555fd2bfa','','','Contr. U.S. Natl. Herb. 12:208.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe3ac04f-4c31-5b69-90eb-28402b6c454a','','','A. Gray, Manual ed. 5:479.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e60826ee-fad5-5423-8847-170ba9f7f4da','','','Proc. Amer. Acad. Arts 3:292.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23157eee-76a5-57c5-84c3-30a133f566ac','','','Arch. Bot. Mém. 7:93.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('222ad109-4dd2-5099-a9d5-36fa5e40f9a5','','','C. Wilkes, U.S. Expl. Exped., Phan. Pacif. N. Amer. 17:347.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7af11af-3e17-5527-8dc9-d88f5cff48f2','','','Sp. pl. 2:785.  1753, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('735a058f-e9d1-5a79-a1f7-e03056475405','','','Syst. Bot. 23:381.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72574547-9de6-54b8-b7cc-bb2876f37597','','','Ann. Sci. Nat., Bot. sér. 3, 18:215.  1852 (non Gay 1849)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed4d693e-cf1d-519d-923b-d2a65eb1f75c','','','Prodr. 6:128.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a06ad78-4103-5a5c-a282-d9ef7e767754','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 3:727.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c85def5d-a351-5dee-99d4-c9d3326c7a66','','','Arch. Jard. Bot. Rio de Janeiro 4:41.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c09dcdd-7c42-5b38-b705-a77af9332685','','','Repert. Spec. Nov. Regni Veg. Beih. 40(1, Anhang):54.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3eb87652-5c39-592d-9341-8a7abbca4454','','','J. Washington Acad. Sci. 17:395.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6abd7664-378a-5e71-8329-7b27baa2aa7d','','','Bull. Soc. Bot. France 55(Mém. 8b):32.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8da24621-1a1b-5258-9cf9-243dc64ecf22','','','Beskr. Guin. pl. 322.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1442ace5-0e34-5796-8277-b80dcf46656c','','','Enum. hort. berol. alt. 2:182.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3eae85ff-fd07-54da-a556-e57b83f1d226','','','Kew Bull. 1949:78.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c1515fb-a2a9-5954-b463-e973133f2a8b','','','Icon. pl. Ind. orient. 4: t. 1245.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6abbacea-290d-50a4-a585-e855bbe4526a','','','Abh. Königl. Ges. Wiss. Göttingen 5:136.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('747511c4-15f9-5277-b403-590e27288afd','','','Schlüssel Hortus malab. 32.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aec85777-fe2d-5630-a863-f5ada6176b04','','','Cact. 3:210.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d0136fe-b15a-533b-8733-055286d0ce55','','','Revista Centro Estud. Farm. 2(6):16, 22.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5a74f23-c54a-5c35-b4c9-5c9fb10868cd','','','Notes Roy. Bot. Gard. Edinburgh 19:214.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc1f11dd-431f-5554-b2d6-d27ed2508cb8','','','Pflanzenr. IV. 117(Heft 69):675.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a555d6b-0326-5ad1-aeb2-7923d96071ff','','','Tent. fl. abyss. 2:464.  1850-1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb9ee8e6-ce24-578b-af20-140e596dc0ca','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:95[folio]; 1:116[quarto], t. 36.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec21c85e-bd95-543c-adff-a3845f06f4f4','','','Fl. N. Amer. 1:231.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d975de8-da77-53e6-959d-e6b3668bc2a1','','','Bull. Torrey Bot. Club 26:238.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee776cd1-b99a-52db-ab64-cb8047324d39','','','Senckenberg. Biol. 50:295.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3ad2b5f-8525-5e11-84e7-e025d55aa2d2','','','Bot. Gart. Halle Nachtr. 1:28.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('426fa55f-78ef-5d75-a6ce-eb78f31e1311','','','Verh. Bot. Vereins Prov. Brandenburg 15:60.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('632eeee4-d043-5d2f-b090-e3eebff9635d','','','Enum. pl. afric. austral. 296.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00337d55-6951-56ee-8c94-19c31022973c','','','Kakteen Südamerika 4:1257.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a98225c2-ed00-520b-b5ca-2409f391b310','','','Syst. laur. 495.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('336f6a1c-ac22-5933-ab65-b9c2b44d7b61','','','J. C. M. Grenier & D. A. Godron, Fl. France 2:736.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58ce7b2b-e694-56ef-ba8c-e18b61af3efc','','','A. Gray, Manual ed. 2:438, 496.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08dacea0-0408-5f17-9f78-5f0751cb657c','','','Byull. Sredne-Aziatsk. Gosud. Univ. 11:113.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c582de9e-3407-5409-a57e-5277e4d1540f','','','Linnaea 8:138.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48155c37-0498-5f76-bfd1-6a530d2c83b8','','','Bull. Mus. Natl. Hist. Nat. 27:115.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f7f1594-9494-5edd-a214-51dc1faf1504','','','Arch. Jard. Bot. Rio de Janeiro 3:116.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('249e7311-0584-5710-8664-ee901f9e6a8d','','','Ejegodn. Exzotl. 1:91.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7187e13-e498-5db2-906d-9d179b042817','','','Byull. Sredne-Aziatsk. Gosud. Univ. 7:20.  1924 (Monogr. 61, t. 36, fig. 2.  1947)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58cb2ddf-25f1-5d9a-80e1-70d69ecc288f','','','Sp. pl. 4(2):1037.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb4bd53d-321c-5895-afc1-704f70794007','','','Darwiniana 7:512.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c86d77d8-90b9-504d-8055-595809f901b8','','','Syst. nat. ed. 10, 2:1163.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0298ca1-f1db-5d2c-a590-bbbbb07772fa','','','Bull. Soc. Imp. Naturalistes Moscou 17(4):713.  1844 (Fl. baical.-dahur. 1:472.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5aaf2294-a168-5a48-be16-c79d3008e6c4','','','Bull. Torrey Bot. Club 34:604.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcef786a-3004-599f-a8a7-16bda4caf030','','','Symb. sin. 7:489.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28b11928-db9a-568f-9354-d0d85343a47f','','','Greuter & Raus, Willdenowia 19:31.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d77c3c42-3262-50a3-91f1-6b89e772e9fd','','','Nov. Actorum Acad. Caes. Leop.-Carol. Nat. Cur. 19(suppl. 1):432.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('caa7c740-c467-52bf-a322-2d5e5be71271','','','Madras J. Lit. Sci. ser. 2, 4:67.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ccf902e-7159-57ee-a443-f275268865c8','','','Webbia 4:213.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f314fdff-5508-5b8b-a459-29ffb6b39154','','','J. Arnold Arbor. 32:199.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f26b094f-72ca-59e4-abac-70cc51720ea8','','','Nov. gen. pl. 2:43.  1782','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17d78bed-7de6-5861-ab51-644dbfe82624','','','Anal. bot. ind. 2:27; Nieuwe Verh. Eerste Kl. Kon. Ned. Inst. Wetensch. Amsterdam ser. 3, 4:39.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebf83528-c628-535c-8fde-a86bab31b426','','','C. B. Trinius, Mém. Acad. Imp. Sci. St.-Pétersbourg, Sér. 6, Sci. Math. 1(1):81.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3b87f96-8160-5db1-8270-1afeb96f264b','','','N. Amer. fl. 23:94.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89b3850b-d584-5b1b-ae4d-3d91b5b51e34','','','C. F. Huang, Acta Phytotax. Sin. 20:101.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('badc01b5-18d5-5d05-b139-1f7521d13b5a','','','Notizbl. Königl. Bot. Gart. Berlin 1:213.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da2a7f98-b6ff-55c3-bc9d-d21fa735a15d','','','Ann. Missouri Bot. Gard. 28:207.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8f7a772-3b25-57b6-a400-4286a80733a9','','','Fl. dan. 13(39):6, t. 2298.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2a7cb70-6ae6-5c82-87db-1eac3b0241de','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(3):230.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e38b6003-8a2d-5a86-b108-7aa020b54ac4','','','Observ. pl. nouv. 7:26.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cb4ed00-8ec6-5078-85e0-93ce6471b3ce','','','Bot. Mag. 129: t. 7888.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc380e6f-dd94-54c1-b2d6-18cf41b4fe6f','','','Bull. Soc. Imp. Naturalistes Moscou 26(2):448.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2526c62d-33a9-5439-8808-7d63a2f857f3','','','Bull. Herb. Boissier sér. 2, 4:1171.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6217ea89-9a54-5fa5-b813-87be70f6cee5','','','Webbia 13:493.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('280480d8-ba41-5e16-82e6-88fdda9e0fb0','','','Novon 9:11.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b16f0f1e-b32a-5e77-81b2-e8f3c01c7b91','','','Fl. siles. 2:398.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d985420-907a-5f7e-b2aa-29128e3f34a3','','','B. Seemann, Bot. voy. Herald 307.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6067a810-7846-5c4a-9d7e-b320ffec397f','','','Pl. hort. schoenbr. 3:21, t. 290.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5809b74d-fbc1-5d3e-abad-534e60208e7b','','','Ann. Soc. Hort. Paris 27:136.  1840 (31:120.  1842 "<I>tripetiana</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ca78e30-4e37-569f-9b37-bf1af38af36f','','','Trans. Linn. Soc. London 13:460.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a271f143-6a5e-58c3-b844-180fc912430b','','','Bull. Herb. Boissier sér. 2, 5:956.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('102f73f8-8205-577c-9d48-ae59dc5de12b','','','W. Roxburgh, Fl. ind. 2:132.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f8d46ea-ece7-5684-a32b-449a24471f0c','','','Prodr. fl. Ind. orient. 140.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42665fd1-6511-574c-a40e-c08d57b9cc03','','','Pflanzenw. Ost-Afrikas C:227.  1895 "<I>Zanthoxylon</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abd34003-a5d0-5b92-92b4-9692fdee3c3e','','','Kakteen And. Sukk. 43:97.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4c37e8d-c3a4-51a8-a528-6083384c2614','','','Sicul. pl. 2:10.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae1ea676-e40e-57f1-b4a4-377de2e190b7','','','Ill. Handb. Laubholzk. 2:40.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('589c6ef3-6f13-5ff8-8883-ebbdbe17e5ee','','','Fl. peruv. 3:53, t. 283.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8a7b09c-299f-5441-a64f-82408e307884','','','Rhodora 56:201.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34a1987e-cd52-5ee7-8522-0c15c8f129ae','','','Fl. W. trop. Afr. 1:341.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8639929c-1967-59ff-b7e0-d5d014b38dfb','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 5:609.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af1485ad-07c7-580b-8e24-824f00346027','','','Kew Bull. 70(2)-19:1.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6217b926-93e7-5802-9f68-409a9ca01b00','','','J. Nanjing Univ. (Biol.) 1:39.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0ed7025-1df9-56b3-a83d-8a3c57b88e17','','','Fl. Afr. austral. ill. 109.  1841 "<I>ceresiaeformis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b177202-dfe6-5b0e-bde5-aba1910b6e39','','','Kew Bull. 17:166.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1116f98e-ee97-5669-ac43-84d5e300302b','','','Hortus maurit. 224.  1837 "<I>pinnata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08b4bdcb-50c9-5390-85bd-752cba5b02c6','','','Biol. cent.-amer., Bot. 2:153.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10aae3b1-6a46-584f-a43a-9f72c4e27a50','','','J. Bot. 11:194.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a2ba3c7-dd4b-5d44-8a87-07f37f3ea619','','','First rep. fl. Wyoming 84.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef664c65-2f0f-5318-9f92-c0d53282e227','','','Mém. Soc. Bot. France 32:7.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ddacd9b-c95a-5576-b30c-e0d37bf7442f','','','Hist. nat. palm. 3:314.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f27f5ce-59f9-577c-8cc2-124b9ecb7bbf','','','Bull. Soc. Bot. France 55:707.  1909 (" 1908")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b58bcaf9-a82c-51dc-810e-c6c4c543d202','','','Schriften Ges. Naturf. Freunde Berlin 8:130.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a27bf49-dc04-5eb1-82cc-241514228321','','','Repert. Spec. Nov. Regni Veg. 3:178.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4aaf8609-dc19-546e-853b-02556adfb06d','','','Pittonia 4:68.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76e5afc8-c78f-59de-b208-a964f43dbe11','','','Bull. Herb. Boissier sér. 2, 1:883.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7703924f-c4b3-5790-ba95-9bfb21878fce','','','Arq. Bot. Estado São Paulo 2:62, t. 16.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c5f44bf-dea2-5940-a909-f705bebed64f','','','Spisok Rast. Gerb. Russk. Fl. Bot. Muz. Rossijsk. Akad. Nauk 8:193.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5183650d-685c-525f-8b78-9fd5e87d1159','','','Fl. austral. 5:536.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c10995ad-f8a0-574a-9b28-9f69787b5424','','','J. B. A. P. M. de Lamarck, Encycl. 4:380.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83dbe0bb-578b-5088-820a-abdfb069ac38','','','Hist. Pl. 7:350, 375.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b442fbbd-dec0-5faf-ba58-2f3875e023fb','','','J. Bombay Nat. Hist. Soc. 65:724.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6559feb-01b3-5021-b8b5-eaeb296dae97','','','C. A. Flaksberger, Trudy Prikl. Bot. 22(2):116.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ff1bd38-9a6a-52a9-91e6-550254d13445','','','A. J. G. H. Kostermans & J. M. Bompard, The mangoes: their botany, nomenclature, horticulture, and utilization 72.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1352c9b-7a88-5a24-8f38-e86c98347c20','','','Acta Phytotax. Sin. 41:151.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd480de4-d705-5ed3-9b64-26c4d07409f6','','','Notes <I>Mesembrianthemum</I> 3:220.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d30ed2d5-4351-5cf4-9aee-3873e5b63cd3','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:143[folio]; 2:179[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f079f78-eefd-5984-b0a4-3dd693fee68b','','','Kew Bull. 13:481.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3109fc28-554a-5527-887f-ac18a19655eb','','','Rev. Hort. (Paris) sér. 4, 3:106.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('762aff0f-12c4-507d-a1d4-6312d07dbff2','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 4:425.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e41efede-cb53-5eb9-8b02-5e30515b9eec','','','Proc. Linn. Soc. New South Wales 89:356.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b15ab7b5-a2cb-594c-9f02-876079d59598','','','Acta Phytotax. Geobot. 22:42.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('971c6c3d-8ff9-5c14-9c66-1865d386e921','','','Selbyana 20:25, t. 9.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a48796d-d333-5557-89d2-c7b5f4332265','','','Gen. <I>Cyclamen</I> 60.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94e5bb2f-9af8-56af-849d-48a4d03c2c51','','','Revis. gen. pl. 1:171.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aaf485f0-3fdf-5df6-9120-fbc47f927753','','','Ann. Carnegie Mus. 11:201.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39ae7f91-a7c9-50aa-9130-bb1b0d05f3da','','','Suppl. pl. 129.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87163c41-05fd-5d58-94e7-26f1cab03190','','','Trudy Sredne-Aziatsk. Gosud. Univ., Ser. 8b, Bot. 17:22.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10651149-1de8-5743-bdd7-7d22a4f8a27a','','','Sierra Club Bull. 4:300.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3003984c-67df-5d13-8d24-ce6923dad19f','','','Verh. Bot. Vereins Prov. Brandenburg 48:117.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebf0b264-09c7-5a38-856c-c9357d482036','','','Bull. Torrey Bot. Club 28:575.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f48b3566-c825-55c4-99e3-b04cd7e332e6','','','Pl. eur. 1:101.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3be72e56-9068-5f4c-b35b-a7aa4666f60c','','','Symb. antill. 4:430.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be2116f1-aae9-5c4e-b3c5-4645412ece8c','','','Bull. Bernice P. Bishop Mus. 147:62.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bc04057-a690-58ec-8daf-d460095d779d','','','J. Jap. Bot. 93:302.  2018','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52c39cdd-4c70-58ab-a793-cb851548c8ab','','','Gartenflora 47:593, t. 1456.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c472bfa4-a2de-5333-b60f-1ab42b7b66f4','','','Mem. Coll. Sci. Kyoto Imp. Univ., ser. B, Biol. 16:104.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a34e2ff7-07f7-5ab0-904c-54201776f58b','','','Fl. reipubl. popularis sin. 74:357.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b42c3563-d57f-5ece-96d5-2b45587ddb8e','','','Linnaea 21:633.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6848bf20-46d6-542e-8bd4-998f2fcd9467','','','C. Gay, Fl. chil. 2:138.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4344271d-0f0e-5964-a003-262b1464984d','','','Bot. Mag. 109: t. 6693.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8df9b6e8-9a22-512c-a0bc-86228f3d1728','','','Hist. nat. <I>Solanum</I> 112.  1813 "<I>Lycopersicum pyriforme</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c37b479-5f5f-5fb7-98ff-4fc57b6ed168','','','Fl. orient. 5:666.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e3de712-547e-5949-a7c0-0e6155ad2818','','','Bot. Zeitung (Berlin) 29:334.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee3a3473-7f36-55d8-9d4b-7fb15dc1694e','','','Diagn. pl. orient. ser. 1, 9:81.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54b978dd-f834-5770-8bab-2ab93adcea47','','','Ann. Lyceum Nat. Hist. New York 2:212.  1827 (Acct. pl. Rocky Mts.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d504ea9-9eb1-5bf3-8253-761aa568541b','','','Revista Brasil. Biol. 49:650.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae7234aa-d0a2-5aa6-90c9-f6944cbe6974','','','Rev. n.-amer. <I>Astragalus</I> 77, t. 4.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b76f629a-1567-58ea-969a-12af7ee1b09e','','','Observ. pl. nouv. 7:13.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('546027ee-793e-5ebd-96a2-912e8b01a29c','','','Hist. & Commentat. Acad. Elect. Sci. Theod.-Palat. 6(Phys.):431.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e66131b-45a1-53e2-aaa0-4922fa751e07','','','Sp. pl. 2:923.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7826e552-35e3-5dc4-ab42-61203d22afc2','','','Acta Phytotax. Sin. 12:124.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('641c8be3-c266-526b-ae38-86e3d53f0991','','','Bull. Torrey Bot. Club 69:589.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d31b775f-f32a-5c3f-aed6-5ac6cbf315ab','','','W. Aiton, Hort. kew. 3:334.  1789 "<I>asplenifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfac49c4-b427-5c10-aeed-a61bf4b55447','','','G. Bentham & J. D. Hooker, Gen. pl. 2:588.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfeb3c73-51bc-5c6f-b049-da81a3aff6d0','','','7:231.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b5bc159-36cf-5dfb-b4c6-4c01068c7ad6','','','Leafl. Philipp. Bot. 3:864.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29b33beb-a68d-52ec-9339-2e63436f8911','','','Blumea 36:180.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82dd1cf6-32ee-572d-9071-0d630c3e5925','','','Compan. Bot. Mag. 1:97.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae953050-2ddb-5411-9290-cc1ce47a2621','','','Prodr. 6:445.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5645c683-8703-55db-92ca-ad08b4930607','','','Leiden Bot. Ser. 1:156.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9152b6c1-533c-5c4c-9357-85e06e700604','','','Anales Inst. Biol. Univ. Nac. Autón. México, Bot. 60:52.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64208786-cba7-56f7-8c83-bbe5b914b643','','','Novi provent. 21.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57cb06e9-af4b-563c-8363-82b31f8505ed','','','Prodr. fl. Ind. orient. 265.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('532e1628-3475-5ffa-930f-4b18749854c1','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:62[folio]; 3:78[quarto].  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c164a401-0ea7-531c-bf00-b1b2fe75c180','','','C. F. P. von Martius, Fl. bras. 5(1):56.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07b28e7c-4d8b-50e7-8f83-4c3cb6bd083b','','','Cat. pl. horti monsp. 24, 103.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2e8fca4-51bd-531f-a365-291950fa396e','','','Repert. Spec. Nov. Regni Veg. Beih. 85:22.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7c5f686-477c-5000-8493-3e63987c38af','','','Repert. Spec. Nov. Regni Veg. 11:4.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4526caf1-1b1c-53ad-8ecc-b577473eea7b','','','Kurtziana 6:242.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28026ddb-3543-57fe-b5e1-ee5aec63c047','','','Bull. Soc. Bot. France 11:165, t. 4.  1865 ("1864")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f68e975b-7f97-5a4f-b245-ab135b83fc31','','','Gard. Chron. ser. 2, 7:652.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66b2888e-3e26-58ab-9fa8-212f9f26a16b','','','Gartenflora 12:275.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37a9eeb7-89f8-589c-a5df-62b16220705a','','','Bot. Beechey Voy. 373.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afa519bd-5568-537e-9250-fdafc4b5fc00','','','Mant. pl. 2:305.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55e2a898-66a6-554f-a90b-d1446838617f','','','Asiat. Res. 9:391.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50798fdf-85e3-5b4a-baa5-3b8a7c8356c3','','','Revista Fac. Agron. (Maracay) 4(2):8.  1967 "nm. (nothomorph) <I>pentagona</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1f0b2b5-1b56-55b0-a734-b1ca57857789','','','Sp. pl. 3(1):683.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e48041e6-76dd-5ade-bf66-c55b3e9b8727','','','London J. Bot. 5:189.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94feac5d-784e-5000-a100-0a9879ca9f02','','','Native orch. U.S. & Can. 229.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59f041d8-e1ae-5bf4-863a-30944a0149ea','','','Blumea 51:69.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adebd26a-3311-532a-b02a-6e63e5edc782','','','Sci. Ann. Fac. Phys. Math. Aristotelian Univ. Thessaloniki 18:120.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05c5e20b-33e3-5f90-bd9e-9914f800d209','','','Bull. Misc. Inform. Kew 1911:23.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d52ac2d3-4996-5473-a220-8d25d483cea1','','','Grass. N. Amer. 2:598.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bea9026a-e65e-5ab5-b5ec-be0936fb2235','','','Candollea 3:201.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb9601a0-ba8c-58a2-9232-2906ebd7b7f3','','','Icon. 1:13.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d9af2a7-11ca-53d0-a4f9-34fe000af397','','','Bot. J. Linn. Soc. 76:294.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f691c49-82b8-578c-9bb9-cfc6933e2602','','','Fragm. 2:82.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f09e2a07-f64a-5c15-8a38-9d541a467d2e','','','Enum. pl. 1:203.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e02b1b5-e559-5c4d-b3ec-9726761934ce','','','Interpr. Herb. amboin. 274.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('faeb09cb-869f-5dac-baaf-fa5c48582898','','','J. Arnold Arbor. 1:53.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0756bd70-4622-57d5-a3d8-05828b4c7195','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 11:224.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b364d4e0-9e9e-55f5-af28-91f93886cd42','','','Revis. gen. pl. 1:45.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('798cfbb4-3341-559a-aac2-8a82970fc4e8','','','Prodr. 2:433.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd7e8623-b7c0-54f8-985e-bec52bc329f9','','','Philipp. J. Sci., C 6:337.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8308a887-8d89-5b8a-acf0-8ae9b59bf0cf','','','Die Agaven 94.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a4c36f5-8b3b-51c4-bbd1-0532924b2cfd','','','Spic. fl. lips. 47.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3256f44b-a71a-5830-b327-1483ee809320','','','Cuad. Bot. Canaria 14/15:22.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0d838c1-9dc3-587b-ab30-4023d2ac8469','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 9:79.  1859 (Prim. fl. amur.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b7393bf-42e7-5d02-a384-d49743f328c7','','','Revis. Drabas W. N. Amer. 70, t. 5, fig. 37a-c.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdbe5ffe-444f-5e97-8ee1-0fb36399e86b','','','Gard. Bull. Singapore 17:402.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14c87535-a698-5b4b-ab0b-1cf6987ad5e4','','','Mem. New York Bot. Gard. 53:253, fig. 73.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('047474b0-cc55-564a-8ee9-4e27c8e3a086','','','Nuytsia 8:370.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('310dc3b5-8c03-5928-b78d-7bfeb6694823','','','Orchid. linden. 5.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d9b2123-5bd2-5422-ae0c-ddad7637d502','','','Contr. U.S. Natl. Herb. 23:689.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b223400-0c35-550c-9481-e397ed4e707f','','','P. E. Boissier, Diagn. pl. orient. ser. 1, 11:26.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5d6c129-8722-5966-8d66-07af556fe92c','','','Cact.-Avent. Int. 88:5.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9854aeac-f377-5049-870f-51ac7b73717d','','','Kongel. Danske Vidensk. Selsk. Skr., Naturvidensk. Math. Afd. ser. 5, 1:308.  1849 (Mexic. bregn.) "<I>weinmanniaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b35af54d-70c5-530c-ba35-8eeac23b76ce','','','Bot. Reg. 9: t. 698.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b1a99b7-8eec-54ce-97b8-cc5bee022e0c','','','Lingnan Univ. Sci. Bull. 9:8.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b268f62-0118-542f-a9cc-dececa1f7c0d','','','J. G. C. Lehmann, Pl. Preiss. 1:13.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e3dd31e-9ed3-5db1-a9a4-eff8c5c970cb','','','Trudy Bot. Inst. Akad. Nauk S.S.S.R., Ser. 1, Fl. Sist. Vyssh. Rast. 4:304.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02366f76-966b-5634-8ab4-f7c7fbaae876','','','L. Beissner et al., Handb. Laubholzben. 462.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('160da43b-49bb-529d-9aab-3ca113260d0c','','','Syst. Bot. 27:625.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c227c2a8-5c82-5138-9ca3-ec02254080b5','','','Forest fl. Port. E. Afr. 57.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cedc4981-8308-5267-ba76-f5c92cccc7c9','','','Enum. syst. pl. 30.  1760 (Select. stirp. amer. hist. 230, t. 131, fig. 2.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16d8ded1-d2d0-5ea4-a0d5-9508b52c06cb','','','Mém. Mus. Hist. Nat. 13:63, 70.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77998184-8c1b-5d8b-a9a6-e2b84e2f3596','','','Prodr. 6:272.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd69ce3b-54e8-5ee5-b31a-cb18a2093274','','','S. African Gard. 23:47.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d1ec1f9-3f85-5740-b787-e4eebccbc2a7','','','Gard. Chron. ser. 2, 3:822.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8361f4c-0745-5079-b1aa-2de170344db8','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 3:611.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6952e08b-d06a-5f61-b4e4-385e2d5c7bc9','','','Mem. New York Bot. Gard. 13:747.  1964 "<I>thompsonae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3783ace-3684-5de8-970f-6d58c36be563','','','Repert. Spec. Nov. Regni Veg. 49:261, t. 331a.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f5542ba-78a1-5dda-946b-30a2ccc668f4','','','Biblioth. Bot. 20(Heft 85):320.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70dba27a-76da-5fcb-afd6-b580717b52cf','','','Hist. arbr. forest. 3:266.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3291f94-6004-5a65-84f9-24d64de296fb','','','Webbia 2:150.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47d8e18f-d28c-5b21-8f5f-e44865e47b4a','','','Proc. Biol. Soc. Washington 43:121.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ec9f808-22f5-5832-ad85-9964991cfe4c','','','J. Adelaide Bot. Gard. 15:72.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6f3e430-7fe4-5bab-a7be-e992738bce2c','','','Sp. pl. 1:465.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23cfff6e-a1b4-55c4-af60-331e4b260538','','','Fl. Amer. sept. 1:260.  1813 "<I>Clarckia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7af8ca2f-39d2-5233-8cb7-882e450f9d88','','','Sp. pl. ed. 2, 2:917.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22a75474-1a42-5fa4-aaa0-64ff016d0769','','','Not. pl. asiat. 4:287, t. 423, fig. 1.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('360c0cc4-4ea7-581e-bc76-59de1061b400','','','C. F. P. von Martius, Fl. bras. 15(1B):320.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bc3d6ae-4992-5d9a-b16e-3c0e6d371e65','','','Brittonia 37:126.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85a2dcff-1c39-52a4-b9e1-b99446ba3109','','','Mem. New York Bot. Gard. 1:7.  1900 Feb, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcb028a2-3039-5f8b-b3f2-589b5fc09064','','','Neodiversity 4:9.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e55a6ee-6c43-5db6-80b1-a90394d987ec','','','Prodr. 185.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0701272-e4e3-5110-a415-5e58721ab4dd','','','Prodr. 6:195.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35e99ee7-b7d8-5c9c-a0b0-84e585eeb451','','','J. Torrey & A. Gray, Fl. N. Amer. 1:197.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('335c0a43-510b-545f-aae1-cc367a63e045','','','The potato: evol. biodivers. genet. res. 169.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11e0a4f2-bd56-51df-b96c-3e9ef8ff3a7b','','','Handb. Laubholzk. 3:412.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6c7eb03-7b88-5786-93ac-934b9f9053e9','','','Fl. Brit. W. I. 317.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3066c04-9bbf-543d-9729-dbb4ce37610b','','','Explor. bot. Afrique occ. franc. 1:475.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02e2f037-2a4b-5129-82ce-ce54c7c3b43d','','','De orchid. eur. 33.  1817 (Mém. Mus. Natl. Hist. Nat. 4:55.  1818)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0720e5c6-498e-55b1-9837-3698050d94d0','','','A. L. P. P. de Candolle, Prodr. 8:42.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0b231b4-5f26-5597-8a91-277fbd365f73','','','Intr. nat. syst. bot. ed. 2. 372.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35f21ea9-541c-5fa5-a562-4346dc6cbe4e','','','Ill. fl. Pacific States 3:635.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91058524-98d6-513e-984a-1520ce7996e0','','','Sp. pl. 1:456.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7be8514-5dad-52e4-815a-8d6e99918d94','','','Bot. Repos. 1: t. 37.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cc6f4a2-a46c-5afb-9a1d-0e5f01a0b50a','','','Acta Bot. Gallica 144:42.  1998 ("1997")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76f7f487-f6c1-50aa-b2fc-dfca0d423f8a','','','J. Washington Acad. Sci. 26:397.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e9ccc72-bdfa-5a68-aa89-0f423359f08c','','','Contr. fl. Sicilia 12.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c5dda7b-8b84-5a62-80dc-16c688bdfba8','','','Hooker''s Icon. Pl. 27: t. 2641.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab09160d-b2eb-534f-be3b-3267133aa42a','','','Bot. Reg. 13: t. 1109.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1421bd72-0061-5c9c-b7a6-e039b58ee9d4','','','J. D. Hooker, Fl. Brit. India 1:88.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5eececb-97a5-5c65-adc9-67a4e26ff3d7','','','V. L. Komarov, Fl. URSS 9:447, addenda.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f36faeff-ad74-5677-8de5-7a37f4ec0e3a','','','Bot. Mag. (Tokyo) 36:31.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06432d54-436c-5ab4-acc1-c9f51b93b90f','','','Bot. Gaz. 13:82.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b2517c2-70ab-5abd-9979-0263d5642077','','','Bot. Mag. (Tokyo) 48:779.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1e03bb9-747b-5c98-9267-d578f51f0fa4','','','Prodr. syst. Aroid. 279.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d24780df-9640-5df3-aef2-9fddd0b244a1','','','Fl. Brit. India 2:314.  1878 (Steud., Nomencl. bot. ed. 2, 2:404.  1841, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('527f2394-47d8-5ffb-88e2-8b3d79bfe88f','','','Ann. Missouri Bot. Gard. 11:330.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d697895-138e-5cdc-95b7-3ec0a0f5fc36','','','Hooker''s J. Bot. Kew Gard. Misc. 8:358.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4a913c5-4a94-530d-84e4-9890c4ef605f','','','Kew Bull. 42:382.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efc1246b-3459-5a81-8f07-50bf6ef1ab5a','','','Leafl. Bot. Observ. Crit. 2:11.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7cbca4c1-1d5d-5055-a659-7dec13b48c92','','','Gard. Chron. ser. 3, 20:239.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53e79e30-70a7-5e4b-ade8-46a70e5fa03b','','','Encycl. suppl. 3:751.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47b490af-e2ea-51cc-8110-f0e8124dfd0a','','','Fl. sicul. 161.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8478adb5-0d07-593b-b764-dde997c3f33a','','','Adansonia 9:290.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b2d4465-1110-51ef-b422-f9f341e4f0e7','','','Notizbl. Bot. Gart. Berlin-Dahlem 14:352.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32625ce5-7faf-5c45-808a-1a89675910d7','','','Feddes Repert. 71:81.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00f5b8de-2626-5504-995f-e6640db6c94f','','','Bull. Misc. Inform. Kew 1936:470.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed5b1841-843a-55d8-bcf9-b2bb2cee9096','','','Proc. Amer. Acad. Arts 21:406.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db270021-3810-5fd2-b980-5da2fdbed9c1','','','J. D. Hooker, Fl. Brit. India 2:159.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8909bb7-9b84-5932-b0e7-04f1d1827055','','','Notes Roy. Bot. Gard. Edinburgh 13:246.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e599206-f347-55ad-82f7-deab4300338a','','','Bot. Misc. 3:334.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2fbbb2a9-343e-5c87-85ed-9b45cd89033e','','','Descr. Egypte, Hist. nat. 109.  1813; 253.  1813-1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9a5e732-b0c4-561d-b86f-2020fd82a814','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 40:69.  1871 "<I>leerii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('960776f6-8373-5671-9045-1a9247585b69','','','Ann. Lyceum Nat. Hist. New York 4:119.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bed1b08-2a08-5cb3-aa2a-9126327ab5bb','','','Hooker''s Icon. Pl. 29: t. 2863.  1908 "<I>claviger</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73fb0317-e943-5fdf-9f1b-ffaf3e4072ee','','','Chlor. melvill. 27.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e06d9223-e04e-54d2-bd47-90cc7fd480ba','','','Caldasia 8:432, fig.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('175cef66-af5d-5e66-a9e4-02e96199b1b2','','','N. Wallich, Pl. asiat. rar. 1:34, t. 40.  1830 Apr (Gen. sp. orchid. pl. 90.  1830 Jun)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('774acd33-4da8-5850-bceb-3a3c26b9e69d','','','Contr. U.S. Natl. Herb. 32:91.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f99b1f7b-77cf-5872-b725-72f36b93709d','','','N. Amer. fl. 24:192.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba1aa017-67ca-5d5d-9fe0-650ea176d605','','','J. Washington Acad. Sci. 32:150.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('177ab354-539f-5eaa-8d77-18302cf894bd','','','Suppl. Fl. Anal. Jugosl. 8(3-11):7.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55616573-088d-530a-bf05-e0d84890f834','','','Reliq. haenk. 2:47.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb38add9-cd04-55d6-b767-c0203c125025','','','Rev. Hort. (Paris) 6:248.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97942c43-bca1-530e-9631-1f77c3ba6a69','','','Bijdr. 545.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a001be49-29fe-57e3-989b-049aac1917e4','','','Fl. austral. 7:612.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e715552-6003-52fe-9392-2f6c68b4f503','','','Notes Roy. Bot. Gard. Edinburgh 15:316.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6487f4d-a235-5f9c-8327-166d6db87b16','','','Nye Saml. Danske Vid. Selsk. Skr. 2:527.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50e3f574-e0f8-5cf0-945a-dee158b4e0e8','','','A. L. P. P. de Candolle, Prodr. 12:174.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d6490ac-dac3-5cd2-8e31-d62a30aa4bbf','','','Sp. pl. 2:585.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c55c6419-4e85-5531-bbfd-670070a0bb0a','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 491.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91ffc93b-3a04-5ffd-b6f9-847a271e0e76','','','Proc. Biol. Soc. Washington 35:119.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37f00dee-af13-5743-939b-28c056578943','','','Bot. Zeitung (Berlin) 9:151.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1df12c1-900b-52a3-a647-cdbdcbf1d12a','','','C. S. Sargent, Pl. wilson. 1:190.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cf0b480-f1c8-55bf-95c7-5053aec5603f','','','Anz. österr. Akad. Wiss., Math.-Naturwiss. Kl. 89:170.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43437291-3335-50d2-9022-78db87ce69b4','','','Blumea 31:107.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('365e83ab-0e25-5905-b2f3-183ced090842','','','Novosti Sist. Vyssh. Rast. 8:15.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b2e38a4-e74b-5174-aee1-e73c62624fa9','','','Smithsonian Contr. Knowl. 3(5):59.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8009bfb-ef0f-5966-b74f-98a3d5ba8e65','','','C. Wilkes, U.S. Expl. Exped., Phan. 15:10.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e91c641-d242-59a9-803d-ea29c7d5ae59','','','Amer. Midl. Naturalist 24:38, fig. 5.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95bd90e6-6bd7-5d96-80a8-acb04af4e944','','','Bull. Soc. Dendrol. France 68:94.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90cfcb51-f3a7-5a89-9780-c83231b193c5','','','Biblioth. Bot. 26(Heft 106):52.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3aa0c1ab-3f97-549a-83d6-ef6bd57d9815','','','Rep. Bot. Soc. Exch. Club Brit. Isles 4:616.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a808433-3c1f-5770-9104-93100af97127','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(6a):19.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4f40232-ac56-5548-aeed-3f77819ec3d2','','','Fragm. 7:61.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a907ffb6-e7e5-5db7-b91e-525e2fad7134','','','Philos. Mag. Ann. Chem. 1:121.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da405701-2397-5307-99b2-09bdbc7f24db','','','S. Watson et al., Bot. California 2:241.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b769efd-3f40-55ca-90d3-6b6cb590d134','','','Bull. S. Calif. Acad. Sci. 1:122.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80412f7e-e841-5b3b-a59d-bc98acf1d5cb','','','Icon. Pl. 3: t. 262.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe4eafa6-c02c-565a-a169-cc618505e301','','','Mem. Wern. Nat. Hist. Soc. 4:305.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9d992c2-093c-56b6-a2ab-308975c88e08','','','Bull. Torrey Bot. Club 24:312.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('510b71f5-b7de-5719-9499-645bdba63446','','','Kakteen And. Sukk. 21:162.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f463560-a243-57de-89d6-a5d08d461378','','','Linnaea 17:43.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c27b07ea-c851-5018-9069-5ab9c4a18ac6','','','Icon. 5:23, t. 439, fig. 2.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f3942b9-6539-5344-81b2-7ae0432e8053','','','C. S. Sargent, Pl. wilson. 2:141.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad8d0343-b850-5a02-9968-3fe3dcb97b14','','','Wiener Ill. Gart.-Zeitung 17:855.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('670f2f78-ccd7-5b4a-94ee-57b6628fbf03','','','Symb. bot. 2:96.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af706559-239b-5c1d-94d3-74ab378911d8','','','Nov. Actorum Acad. Caes. Leop.-Carol. Nat. Cur. 19(suppl. 1):15.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38032680-1c1f-5b6a-be35-1b8c51966d9e','','','Kew Bull. 42:401.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e8014f7-6ed2-5a1b-aeb7-ffd249e9f984','','','Bull. Soc. Bot. Genève sér. 2, 1:371, 374, fig. 3.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc6b1567-c088-5cd5-9913-3f85fcba2e64','','','Prodr. 101.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e99f08a-cdfa-577d-ae86-a980d9d2c65e','','','Descr. icon. pl. Hung. 1:47.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bb39b8f-8c18-5670-a207-08e74aa74118','','','Fl. ind. 2:6.  1824 (Hort. bengal. 84.  1814, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5af36d2b-62f0-5c83-9caf-1ba97433346e','','','J. Washington Acad. Sci. 16:569.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76747c8e-a062-5919-a40a-64307ef7241f','','','Syn. fl. N. Amer. ed. 2, 2(1):461.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e95ebb75-868d-5753-9a92-93093d48e585','','','F. A. Körnicke & H. Werner, Handb. Getreideb. 1:48.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42878bdc-d14e-59d4-a072-bcbd680dae59','','','W. W. Saunders, Refug. bot. 3: t. 198.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f877524c-85a6-5151-b6e8-5f2245d212e6','','','C. F. P. von Martius, Fl. bras. 11(1):15, t. 2, fig. 12.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7ade40d-1ee4-5298-ba4a-470d4155c2f5','','','replace','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8bdf18c-25ce-5d1f-9e25-8ffc31c929cd','','','J. Bot. 11:306.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58cbe36e-a397-5e93-879b-dc7cfcf3c25a','','','Flora 26(45):759.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1525cbe-f687-51cf-86ca-ec2337211d8d','','','Fl. W. trop. Afr. 2:222.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dcb13f0-828b-53bb-87db-eb4b833f547d','','','Phytologia 35:190.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e142afc3-cb25-5b10-9c3d-8c16943620f3','','','Linnaea 6:105.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fe2eae8-6392-5389-8ea8-be46d64c02a6','','','J. Bot. 36:30.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94a31a0d-2012-50a8-8ac4-72ad2364374c','','','Bot. Mag. (Tokyo) 17:113.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fad34acd-0612-5cf9-9920-6d56e190c0f4','','','Bot. Jahrb. Syst. 16:25.  1893 "<I>yelliottii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2791f91b-8287-5726-97df-f09b12aceca9','','','A. D. d''Orbigny, Voy. Amérique mér. 7(3). Palmiers 133.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ee631c6-c44b-5c6e-844b-31300d567a22','','','Mitt. Bot. Mus. Univ. Zürich 28:230.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe341b6a-dd3f-51df-bcda-71b9cf59710f','','','Webbia 13:498.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c7362a1-91b4-5ae1-8b7a-f899aac232fc','','','J. Arnold Arbor. 24:49, t. 4a-b.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66727967-68cd-523c-b57b-cb74763bed67','','','J. Econ. Taxon. Bot. 15:450.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f4f6d66-6b82-525e-b65b-69f34a7e6246','','','Fl. reipubl. popularis sin. 38:68.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62840224-32e1-5131-9ef1-c67187a3ab17','','','Trans. & Proc. New Zealand Inst. 57:31.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1eb2b404-6308-578b-984d-1bb982548e1c','','','Kew Bull. 46:205-212.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44ae8c67-0d17-581e-93c8-3a8b6331cb13','','','Bull. Torrey Bot. Club 38:453.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33a04843-aead-5139-848b-92b3f8fa2c94','','','Proc. Biol. Soc. Washington 112:230.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aad24e66-49d1-5330-a94b-2dd696fe3dca','','','J. D. Hooker, Fl. Brit. India 6:468.  1893 "<I>didymophyllus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acf7755f-cab1-5dde-b837-7a90c9461f66','','','Fl. cochinch. 2:472.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94f347e2-5926-55df-ae99-13dcc9274995','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 20:469.  1875 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e84313a2-c4be-5cec-80ae-78f383e77ab1','','','Symb. bot. 3:99.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81057cb3-4c9c-52ac-bda1-72410e726cbc','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 8:666, t. 21.  late 1884-1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d81b4f6-175b-5829-8031-71d353c5fe21','','','J. Sibthorp & J. E. Smith, Fl. Graec. prodr. 1:184.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c4ed788-7f2d-52d7-8433-38daa0b08e83','','','Novosti Sist. Vyssh. Rast. 8:65.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('775c992b-e17f-529a-9908-b724d469b72b','','','New Hardy pl. West China 9.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc6a1e8f-fed9-5fe8-9acd-7e30c85c2e4d','','','Phytologia 68:15.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47d1829b-cfb9-573c-9c2c-254efab7f67e','','','Hort. kew. 1:252.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3666a2d8-0eea-585d-94da-b175a3593312','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(6a):27.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f33203c6-d7f3-5c48-8536-4d2cf7050194','','','Fl. Amer. sept. 1:342.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f4ce497-a112-5534-9e2d-405e8262c9a6','','','Cent. pl. I:18.  1755 (Amoen. acad. 4:279.  1759) "<I>hieraciifolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0938ca3-e585-57ce-8941-e064cc30e357','','','Prodr. 5:313.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0ca6170-bee6-5696-b586-c2a7166d2c48','','','Abh. Naturwiss. Vereins Bremen 1:224.  1867 "<I>procera</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec09c98c-e8c2-5d15-b953-97f7e4e0b19b','','','Gard. Chron. ser. 3, 84:242.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e3a02e0-27e7-51c3-860c-de4475da10fd','','','Belgique Hort. 25:273, t. 15-17.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8dca220d-2037-5da2-9510-591ad7c2934e','','','Prodr. 186.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('430e8b0f-7a88-5462-8a3c-4d47f3ae4206','','','Fl. ind. 2:51.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c166545d-02b2-5ede-8183-8108f65c7c9c','','','Fl. cochinch. 1:273.  1790 (non Jacq. 1760)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fc2dc54-15ff-5195-9281-693717cf98cf','','','Flora 27:424.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4045a939-78b5-582c-a73c-06686ee95ff1','','','Turkish J. Bot. 22:359.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47ec9ee6-8b28-54ab-89b8-78c840a8939a','','','Ill. Fl. Pacific States 1:73.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99a6d3aa-c31e-5cc3-946b-df0950e46d96','','','Mem. New York Bot. Gard. 1:241.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63359270-0d36-51db-b347-229e476c3ccb','','','Bot. Jahrb. Syst. 30(Beibl. 67):15.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a3ab275-7fd9-5469-aa45-0245805916f6','','','Notes Roy. Bot. Gard. Edinburgh 24:170.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5766c53-fa0a-592b-b328-284831aae302','','','Canad. J. Bot. 58:1766.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e6c3b46-ca32-5133-b580-aedc41b01f0e','','','Ann. Sci. Nat., Bot. sér. 4, 11:135.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28b3a1b0-12f1-5418-8c32-d84e9e1df708','','','Ann. Missouri Bot. Gard. 25:413.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2173070-efcf-5266-9a3a-c07d6074b108','','','Arch. Biontol. 2:424.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c997bb8a-ac79-5843-8b8b-f3c408f29b82','','','Fl. France 5:291.  1899 "Une forma <I>H. capitata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14c3bbec-4600-5617-a0a8-3e36305b016a','','','S. Sci. Rec. 3:33.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9f7fec2-78f8-51de-ad0a-d46ee871eec4','','','Sp. pl. 1:522.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67d175d1-10fe-5b16-838f-69f2058ed5dc','','','Bot. Gaz. 38:378.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff5dcf62-40a5-5660-adcc-c31db3ed7480','','','Amer. Fern J. 41:9, t. 2.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bdbd52b-820b-5c91-a093-949517413da9','','','Trans. Linn. Soc. London 22:420, t. 71.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('866ba2e9-8571-5ea6-b06b-d54c3de24f2d','','','Bol. Soc. Brot. 23:87.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9a3251e-8b12-5b1b-891c-4762712209a5','','','General- Doubl.-Verz. Schles. Bot. Tausch-Ver. 21:[24].  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('693d248c-b08a-5eab-91b0-03f4b484bc3f','','','Repert. Spec. Nov. Regni Veg. 20:284.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('769444c7-4c81-5a0b-ad95-2a69a45ef7d5','','','Bull. Misc. Inform. Kew 1934:449.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbdd7080-2817-575d-a786-e73542ff56cd','','','Amer. Midl. Naturalist 76:478.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1364b274-7b1e-5c62-b6b9-9b1503eb61b5','','','Eclog. amer. 2:26.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('198c458b-f516-548a-9170-07708a9851e3','','','Occas. Pap. Bernice Pauahi Bishop Mus. 14:4.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01ae67d8-91a3-5f63-a098-a0d675ace831','','','Trans. Acad. Sci. St. Louis 12:38.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecb47be2-cb4e-5bba-b240-77bfb678b59f','','','Webbia 1:305.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51a42b68-4177-5122-825e-f2c457709d81','','','Flora 28:172.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14fdc245-6722-58fe-8c35-7ea863512f0e','','','Enum. pl. zeyl. 318.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdcc3ee1-325b-5aee-ba08-bfab2bc423b8','','','Malesia 1:42, 98.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7187d6f2-33d0-5267-8b65-0484f8c464f9','','','Cent. pl. II:31.  1756 (Amoen. acad. 4:330.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03711289-7799-5ce8-9bcc-7796a8b7f680','','','Sp. pl. 3(3):1958.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d361c0c5-783a-5e0d-9b07-47271ee34bcb','','','Bull. Misc. Inform. Kew 1920:280.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8759ff6e-ba30-5406-8d9a-01c0065a5233','','','J. Jap. Bot. 3:44.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('107bce3e-1911-5572-874a-c570dec712e6','','','Bull. Torrey Bot. Club 35:270.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8359e708-3de3-5be1-888f-af91be0139f3','','','Fruct. sem. pl. 2:106, t. 105, fig. 1.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('036ea9be-1500-591f-9c36-2746a27f4bb6','','','Fl. jap. 1:187, t. 99.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9605042-0d56-5585-881a-0df237e8b9f3','','','Flora 31:250.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37d03fd7-f9dc-54f9-a9f6-4e71980410e3','','','Cat. N. Amer. pl., ed. 2:5.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8723b2c-e5aa-5b0e-9f6f-a75904d0d0fe','','','Sp. pl. 2:848.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffec0140-48c3-56ef-9af0-a5ff7288fc6a','','','Fl. atlant. 2:206.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('283fb774-35da-54d1-a686-f09b95fb327d','','','Sp. pl. 1:373.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('720dc388-30ea-5c22-89e5-b34c1d053569','','','Notas Mus. La Plata, Bot. 3:25, fig. 2.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76cae33b-c5d6-5702-b099-01ac4b366435','','','W. T. Aiton, Hortus kew. ed. 2, 3:5.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51b537d1-93ec-5c3f-9e3e-11a91f6ee8f3','','','Bot. Mag. 67, sub t. 3862.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7116b99b-e38b-50bc-8ab6-d795854ecca5','','','Bull. Misc. Inform. Kew 1911:255.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8ded0a6-fb34-5888-99a5-05d1eb3a77b2','','','Gen. N. Amer. pl. 1:155.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67d058ed-88d9-5df0-938b-db3060903f60','','','Bull. Soc. Bot. France 56(Mém. 3d):324.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('256277cb-1ca3-5f7c-81ac-7d187167b0d6','','','Fl. Congo Belge 3:461.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29cafd01-4aa2-56fa-b868-1931b5a832f5','','','Bot. Jahrb. Syst. 26:286.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac53b4f1-7888-5c95-9993-578326788a32','','','Bull. Torrey Bot. Club 28:573.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5626a8a-82a0-5ae0-8afa-13d92050b0cf','','','Mant. pl. 1:43.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec713d5f-b2c5-572b-9fc5-f434b0bacd07','','','Revista Fac. Agron. Veterin. 6:144, fig. 11.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae18cbb2-55a9-5a92-a815-50d9a286d6cc','','','H. G. A. Engler, Pflanzenr. IV. 104(Heft 40):366.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a67c076-82d1-5f07-82fb-c9af82a349f1','','','H. G. A. Engler, Pflanzenr. IV. 111(Heft 36):57.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86e0ded4-c514-56cf-9a2e-222d60244596','','','Bernice P. Bishop Mus. Bull. 174:40.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1aa191df-65cc-5960-b222-3469d0461e09','','','W. Amer. Sci. 3:157.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('423bb405-c032-56ef-8c1d-67697883e0b5','','','Repert. Spec. Nov. Regni Veg. 26:142.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05bba7ff-472c-5f9c-8823-4671b647b8c3','','','Bull. Jard. Bot. Natl. Belg. 45:418-419.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcc7ab06-e1de-5887-af21-9d8ac8c49649','','','Gen. sp. orchid. pl. 147.  1832','','','',