PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE version (id TEXT NOT NULL) STRICT;
INSERT INTO version VALUES('v0.3.31');
CREATE TABLE metadata (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__doi TEXT DEFAULT '',
  col__title TEXT NOT NULL,
  col__alias TEXT DEFAULT '',
  col__description TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__version TEXT DEFAULT '',
  col__keywords TEXT DEFAULT '',
  col__geographic_scope TEXT DEFAULT '',
  col__taxonomic_scope TEXT DEFAULT '',
  col__temporal_scope TEXT DEFAULT '',
  col__confidence INTEGER DEFAULT NULL,
  col__completeness INTEGER DEFAULT NULL,
  col__license TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__logo TEXT DEFAULT '',
  col__label TEXT DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__private INTEGER DEFAULT NULL -- bool 
) STRICT;
INSERT INTO metadata VALUES(1,'','USDA National Plant Germplasm System','GRIN Plant Taxonomy',replace('The USDA National Plant Germplasm System (NPGS), often referred to through its associated database, the Germplasm Resources Information Network (GRIN), is a vital resource for preserving and providing access to plant genetic diversity.\n\nThe Germplasm Resources Information Network (GRIN) provides information about the United States Department of Agriculture (USDA national collections of animal, microbial, and plant genetic resources (germplasm) important for food and agricultural production. GRIN documents these collections through informational pages, searchable databases, and links to USDA-ARS projects that curate the collections. ','\n',char(10)),'','','','','','',NULL,NULL,'','https://npgsweb.ars-grin.gov/gringlobal/taxon/abouttaxonomy','','','',0);
CREATE TABLE contact (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT NOT NULL,
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE editor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE creator (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE publisher (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT DEFAULT '',
  col__family TEXT DEFAULT '',
  col__rorid TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE contributor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE source (
  col__id TEXT PRIMARY KEY,
  col__metadata_id INTEGER DEFAULT 1,
  col__type TEXT DEFAULT '',
  col__title TEXT DEFAULT '',
  col__authors TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__isbn TEXT DEFAULT ''
) STRICT;
CREATE TABLE author (
  col__id TEXT PRIMARY KEY,
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__alternative_id TEXT DEFAULT '', -- sep by ','
  col__given TEXT DEFAULT '',
  col__family TEXT NOT NULL,
  -- f. for filius,  Jr., etc
  col__suffix TEXT DEFAULT '',
  col__abbreviation_botany TEXT DEFAULT '',
  col__alternative_names TEXT DEFAULT '', -- separated by '|'
  col__sex_id TEXT REFERENCES sex DEFAULT '',
  col__country TEXT DEFAULT '',
  col__birth TEXT DEFAULT '',
  col__birth_place TEXT DEFAULT '',
  col__death TEXT DEFAULT '',
  col__affiliation TEXT DEFAULT '',
  col__interest TEXT DEFAULT '',
  col__reference_id TEXT DEFAULT '', -- sep by ','
  -- url
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE reference (
  col__id TEXT PRIMARY KEY,
  col__alternative_id TEXT DEFAULT '', -- sep by ',', scope:id, id, URI/URN
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__type_id TEXT REFERENCES reference_type DEFAULT '',
  -- author/s in format of either
  -- family1, given1; family2, given2; ..
  -- or
  -- given1 family1, given2 family2, ...
  col__author TEXT DEFAULT '',
  col__author_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__title TEXT DEFAULT '',
  col__title_short TEXT DEFAULT '',
  -- container_author is an author or a parent volume (book, journal) 
  col__container_author TEXT DEFAULT '',
  -- container_title of the parent container
  col__container_title TEXT DEFAULT '',
  -- container_title_short of the parent container
  col__container_title_short TEXT DEFAULT '',
  col__issued TEXT DEFAULT '', -- yyyy-mm-dd
  col__accessed TEXT DEFAULT '', -- yyyy-mm-dd
  -- collection_title of the parent volume
  col__collection_title TEXT DEFAULT '',
  -- collection_editor of the parent volume
  col__collection_editor TEXT DEFAULT '',
  col__volume TEXT DEFAULT '',
  col__issue TEXT DEFAULT '',
  -- edition number
  col__edition TEXT DEFAULT '',
  -- page number
  col__page TEXT DEFAULT '',
  col__publisher TEXT DEFAULT '',
  col__publisher_place TEXT DEFAULT '',
  -- version of the reference
  col__version TEXT DEFAULT '',
  col__isbn TEXT DEFAULT '',
  col__issn TEXT DEFAULT '',
  col__doi TEXT DEFAULT '',
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
INSERT INTO reference VALUES('401aeca6-0312-5b6f-8fd4-70bcb65be2d8','','','Brittonia 47:166.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81f32b78-c7ef-59d5-b9e2-d31581888ae5','','','Bot. Jahrb. Syst. 74:626, t. 7.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c8d4627-e89f-5192-ba1a-c366c4ca5e8a','','','Aliso 4:99.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e97f25e4-bf55-5fff-a707-d31a6f17d614','','','Hlebn zlaki turcii 30.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86c62e84-7153-5b83-b627-047d59c37ce1','','','A. H. R. Grisebach, Fl. Brit. W. I. 515.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c932d548-4ce6-5443-889b-305692d04170','','','Nov. stirp. pug. 2:11.  1830 Aug','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83e9e39f-9e03-5ba9-aec6-b4db4141c7ca','','','Mém. foug. 5:326.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b03faba2-a378-530c-85cf-1db548536e2d','','','Trop. Woods 37:21.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3707b71d-7778-589f-b241-931564f2e234','','','Trans. Acad. Sci. St. Louis 1:483.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d2e338c-ec58-5738-a321-35cf8a107718','','','Giorn. Bot. Ital. 109:401.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aeef768e-3edc-5c44-a95a-8a4e51e4ff8d','','','Kew Bull. 61:185.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e86f562a-f2a6-519d-8b29-871f720c06ef','','','Bot. J. Linn. Soc. 183:575.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8e46c2a-d253-579c-a3c1-7129450f4009','','','Proc. Acad. Nat. Sci. Philadelphia 1867[18]:82.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('537c4c15-f92d-5a16-8c24-d92f43655560','','','Prodr. 10:593.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1efbd515-8b09-502d-83d9-bb792c99fdac','','','Phytotaxa 61:48.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b2e38a4-e74b-5174-aee1-e73c62624fa9','','','Smithsonian Contr. Knowl. 3(5):59.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33c4f2b9-8509-563a-8f6f-6e25a4e84dae','','','Fl. China 22:423.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e7a52c4-96da-5a12-aea2-2e09a53afa3c','','','Acta Phytotax. Sin. 34:443.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('968fd802-623a-5fac-9af1-ea0df7d74962','','','Bull. Soc. Bot. France 20:246.  1874 ("1873")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d54ef2e7-8492-5eaa-bb01-16ce12a8e0bb','','','Hort. kew. 1:64.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7415f7ae-61e4-52d6-a72b-d3a0b0f7c9c6','','','J. Hort. Soc. London 3:70.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c40d0cc5-3090-57ad-a6cf-8b911f2947d0','','','Bull. Soc. Imp. Naturalistes Moscou 10(1):57.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9196c4a2-a71c-5451-85c8-ca70380496c1','','','Kew Bull. 1953:93, fig. 2.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8131ad55-f0ae-50d6-b3ce-2a0e4e0b151e','','','Recueil Trav. Bot. Néerl. 39: 413.  1942; Meded. Bot. Mus. Herb. Rijks Univ. Utrecht 90:413.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75bd0155-d9d7-5d32-b930-6fbac07c0ae0','','','Bull. Torrey Bot. Club 30:383.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1d2830f-c201-51b6-8e30-e4444b31bba2','','','Gärt. Zentral-Bl. 1:646.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd7cdc53-f109-5fc9-a977-260b6557f86c','','','J. Coll. Sci. Imp. Univ. Tokyo 32(1):30.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dab3f2c2-0b42-581b-bed3-da0459a52e19','','','Mem. Bernice Pauahi Bishop Mus. 8:76.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bccf2a0-281b-5787-98d1-0d289da06ce3','','','Prodr. 8:365.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a275866-05d8-503f-a724-bbd09a3d0398','','','J. D. Hooker, Fl. Brit. India 1:282.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bfa41a3-feab-54c5-9049-6035de2c6352','','','Gard. Chron. ser. 2, 9:202.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed24e608-620c-56fb-aebe-5468b51e3abd','','','W. H. Harvey & O. W. Sonder, Fl. cap. 3:432.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('271dc100-f1b8-56b9-aecb-503a1fa9e202','','','Wrightia 2:178-179.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eafeb564-d190-569e-8e82-965dbd82b335','','','J. F. Royle, Ill. bot. Himal. Mts. 1(9):306.  1836 (N. Wallich, Numer. List 26, no. 922.  1829, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d8d1d62-4ec7-54e0-b7b1-e722eddaf5a6','','','Arch. Bot. (Paris) 2:518.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8f5e78e-1b03-5f3b-840d-97323fc1d3e0','','','London J. Bot. 4:582.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba75f410-3b3b-5dd0-9611-be751dd86163','','','Phytologia 48:426.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b55929d-95d3-519c-9df0-a919ae2e1e38','','','Anales Jard. Bot. Madrid 57:227.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da41d422-3dfc-5aa4-8c46-4f0885216c20','','','Sp. pl. ed. 2, 2:1362.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40785f39-7c43-5a28-bf2a-1bc8481483f6','','','Trans. Linn. Soc. London 28:103.  1871-1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b1f0d39-6db0-52aa-8e52-38e6d412ef06','','','J. Proc. Linn. Soc., Bot. 3:139.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9874e9c0-e29c-58e2-b6ff-d0810d74a6bf','','','Gen. Amer. bor. 2:80.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4da06a9f-e61e-5f94-83c4-fe2560c5663b','','','Man. S. Calif. bot. 601.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('886ec091-d7a9-5bc6-a27e-a1e75ff47e4e','','','Prodr. 4:262.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ae0a99e-9d78-5855-8245-500efd554d3a','','','Z. Sukkulentenk. 2:187.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('827620cc-959e-5c15-89ea-42af2f03d6a4','','','Cactus (Paris) 38:249.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bde16b77-9029-5947-8f65-3309398ba932','','','Oesterr. Bot. Wochenbl. 4:417.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e92bdef-0ab1-5dba-84e9-b1ef82d563c9','','','Willdenowia 16:443.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab07c53a-af5b-578b-812a-01c9f6e26522','','','Ill. dict. gard. 3:364.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a118dad0-1cec-5bdd-b74b-d09182bfcc3f','','','Arch. Bot. Mém. 7:71.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c6e51ee-98d3-5a11-abbc-53f8e15c3b65','','','Cact. Succ. J. (Los Angeles) 66:12.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5378cc71-b0cb-59b1-87ae-799fb1c8e5cf','','','Linnaea 19:335.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66b3ed6a-0658-58fe-b108-8344a4eb20fb','','','Fl. taur.-caucas. 1:304.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e75eb490-37c8-5a6d-a28f-a8710f3052af','','','Linnaea 1:354 ("254"), t. 5.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cc0ba0d-9c2a-5a59-af69-94a9fe7c20e5','','','Labiat. gen. spec. 718.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3feefe34-7f88-5d49-888c-fe3759625db4','','','Prodr. 224.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fcb926f-eb86-58b9-9658-c6d346a30e28','','','Global fl. 4:149.  2018','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e353023-1125-5a66-adac-5e38d60ca7a8','','','Symb. antill. 4:116.  1903 "<I>Heleocharis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f82863ef-dccb-57c9-82eb-ffbf2dc519c5','','','Věstn. Tiflissk. Bot. Sada 46:36, t. 2.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a802e0a-4b70-50d0-8092-e9046217ede0','','','Ann. Mus. Congo Belge, Bot. sér. 6, 1:73.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1529df4-c098-54e6-a820-c0501cd87da5','','','Aliso 4:89.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e21dfc6-df33-55b9-95cf-136def6b0da2','','','Kew Bull. 27:266.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('946db700-8a79-5444-bc53-196994642570','','','Kew Bull. 70(4)-52:1.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f4932a5-9d4d-55cd-b24e-553213b9dc67','','','Enum. Philipp. fl. pl. 1:53.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d22531c0-91c6-53cb-b5da-a89224ef5387','','','P. E. Boissier, Diagn. pl. orient. ser. 1, 9:27.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94fe6d33-4631-58e4-aa47-79256ea0ad7c','','','Mem. Torrey Bot. Club 22(3):43.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0843e9d3-0ff7-5031-9c90-e9736a5823f0','','','J. L. M. Poiret, Encycl. suppl. 3:552.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eeaf238b-e07d-593d-8c53-27072ce6b7a3','','','A. Rees, Cycl. 11: <I>Dicksonia</I> no. 1.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48f77667-03a3-5429-bba6-173b7a63bd30','','','Phytoneuron 2012-39:20.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3851da68-dbf0-5fa6-942f-6cda8800fc8d','','','Gram. unifl. sesquifl. 225, t. 4, fig. 10.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ca677e0-d79c-5c82-adbc-ad7e2b5fb2c0','','','Opera Bot. 5:65.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e9bb8f6-5df6-5287-96a3-216182004c1d','','','The genera of Sapotaceae 252.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1209beb-ac7c-554b-9f5d-380cf057d518','','','Novi Comment. Acad. Sci. Inst. Bononiensis 4:439.  1840 (Fl. guatimal. 39.  1840)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c3f9dbf-7a91-58d2-a343-39beb2d97971','','','Rec. Bot. Surv. India 4:45.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be052d6b-6ffa-53a7-926e-34c8ee73f7a0','','','Fl. Brit. India 1:447.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2c2935a-42d4-517e-a727-d0092f175d1a','','','Linnaea 13:536.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61733068-5244-5f98-9661-218d6dcef876','','','Nuytsia 3:394.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('378e1cb9-8160-5f20-a6da-34d1db8fea04','','','Mitt. Bot. Staatssamml. München 14:543.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d19e56e5-8d34-544c-a4fc-6d33aa5da04b','','','Trans. Linn. Soc. London 26:29.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbbfc088-3e5c-513d-a473-646431d2ab7d','','','Prodr. 3:218.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('174a02bf-1b70-5aec-8d72-ae3f3ddb3d2e','','','J. Washington Acad. Sci. 17:147.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67d86e88-b8c1-519e-80fb-a98888c8c1f0','','','J. Fleming, Asiat. Res. 11:183.  1810, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae7bc6af-5fec-51cd-96ba-97a3aad88ac9','','','Encycl. 1:252.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e421730-ea35-56e0-b081-15a6cf13119d','','','Bot. Jahrb. Syst. 23:173.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a8a0a67-8992-5ee0-9ed7-24614ff7521d','','','Beih. Bot. Centralbl., Abt. 2, 25:84.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cc7ea35-0da3-562f-a98c-133ff60de949','','','Tent. fl. abyss. 1:231.  1847; t. 44.  1851? (non Steudel 1841)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1c07777-9c1c-5b00-8549-de1f65a05414','','','Encycl. 1:426.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67d9299e-5ad0-5975-a305-dbef752bbd17','','','Mem. New York Bot. Gard. 35:570.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9751fd24-85b3-56ec-bf10-a6b645c56835','','','Phytoneuron 2012-39:30.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb90ae16-d9da-5902-9f3d-9caf91bc6215','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 23:367.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fecda3d-cde9-5aa3-8d28-943b19c589ac','','','Amer. J. Sci. Arts ser. 2, 4:25.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0744a37d-3c66-5944-bc27-2290bda92039','','','Sida 1:85.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e461e879-effe-5fd7-a781-5a88e7695e86','','','<I>Paphiopedilum</I> 214.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5336fa45-abfc-5823-b648-16dca133683c','','','Rec. Bot. Surv. India 4:31.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8f0e5ce-f1d1-53d2-b31b-ec4a5e1c5e5a','','','F. W. Schultz, Arch. fl. France Allem. 321.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a98d8c5c-16cf-53b4-9d3a-e96a43bfbba0','','','Trudy Prikl. Bot. 20:294.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f1ed1bc-e2cb-50b3-b875-b7357ebba1f6','','','K. Schumann, Gesamtbeschr. Kakt. 83.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e876ffa9-d488-5b14-b166-05b54ac44601','','','Bot. Bull. Dept. Agric. Queensland 4:8.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c53d877e-7cb1-539c-a434-a39b936bc762','','','Fl. lusit. 1:176.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4cdf881-3b72-5624-8a62-864e45ec3a23','','','Astragalogia 132.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a45322b-f214-5240-bd33-7ba45f8afc7c','','','Fl. altaic. 2:219.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f925e2a6-38f8-5b6d-8af1-d02b9503fa42','','','Bot. Abh. Beobacht. 35.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3fd1d96-d0cf-52ed-adef-122656e514cc','','','Fl. cochinch. 2:585.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c33a6209-667e-5d7f-a70a-1fb68d0c3cd1','','','Pl. eur. 1:32.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7efde8c-263c-5ddf-b767-ad474c19d298','','','Mem. Gen. Garcin. 21.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79a7a54e-367f-5910-84f7-8514ce1470e0','','','Acta Phytotax. Sin. 35:43, t. 25.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c20eda25-74c4-5f3a-bcf8-3d98f8d92b07','','','Kurtziana 1:82, fig. 32E-I.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d23d347-5f3b-5f66-be97-9e1fdf2e3edc','','','Philipp. Agric. Sci. 87:117.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('619bf64b-dea2-5ee9-89e2-2ed6a8047eea','','','Pl. wright. 2:22.  1853 (Smithsonian Contr. Knowl. 5, Art. 6)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9f9f940-03eb-5558-bb7e-d36d8a315393','','','Just''s Bot. Jahresber. 36(2):519, in adnot.  1910 "<I>tularensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4a271c9-f136-5b22-9dda-85ad331ee07d','','','Choix pl. t. 10.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88c1728b-4f76-535b-abb0-99d7a0540f77','','','Enum. pl. 1:154.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37a3350a-10f6-517e-8cdc-ff5afbee0d8d','','','Diana 1:88.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b189b1dd-36d9-5822-8ca7-fdadc4c34f02','','','Fl. bor.-amer. 1:307, t. 107.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f1551bb-16ea-5fc0-8730-26cf97aa8eec','','','H. G. A. Engler, Pflanzenr. IV. 250(Heft 27):108.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('502da379-ce48-5e4d-905a-a697311d666f','','','Acta Phytotax. Sin. 10:177.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fd2f976-d1aa-5f98-b89f-0f9b5913d204','','','Yuccas Southw. U.S. 1:24.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6e7d464-68b9-5f51-8fcd-a4e55232cdd9','','','Bot. J. Linn. Soc. 90:111.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c0ec4d3-82e2-5409-8c5a-6cbd751b28b4','','','Proc. Amer. Acad. Arts 7:383.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b250c55-6f07-599c-9a5a-4a7657db3a59','','','Amer. J. Sci. Arts ser. 2, 17:234.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5063c589-47e9-5901-9b77-005e966ea6a2','','','W. Withering, Bot. arr. Brit. pl. ed. 2, 2:1035.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5af36d2b-62f0-5c83-9caf-1ba97433346e','','','J. Washington Acad. Sci. 16:569.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d69b12c3-6f98-599e-a9f9-8320e07d3e36','','','Bot. Gaz. 26:332.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff35bd7b-7817-5610-bd7c-a5801366d610','','','Bull. Torrey Bot. Club 29:467.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a562170-6f8f-584e-ad39-c0bd31c37b30','','','R. Sweet, Hort. brit. ed. 3:165.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81339a2d-79f0-5390-abbe-ecb00ae0cf28','','','Bot. Mag. (Tokyo) 21:59.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06c5c6aa-fffd-5efd-b53d-7ba4555396fa','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 370.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71ba80ce-20de-5a28-83ba-0b7d20118aef','','','Philipp. Agric. Rev. 7:266.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5c5d6ef-264d-537e-bfdd-48deb8ec2232','','','J. Linn. Soc., Bot. 45:204.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a735356-3552-57e7-854c-99f3495191d9','','','Bull. Herb. Boissier sér. 2, 2:418,480.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd49d120-3ab7-5eb4-8264-3980ed925673','','','P. E. Boissier, Fl. orient. 2:629.  1872-1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('282a4273-1214-5dab-be96-5d03087951d9','','','Monogr. afrik. Pflanzen-Fam. 6:83.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f800b48-b16f-58f3-b7af-da252a0a1589','','','Enum. pl. 5:288.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('509dad23-a445-542e-97c0-acfa8f9fbdd6','','','Bull. Soc. Dendrol. France 11:36.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d50a857-023c-50a5-a3db-e98b1aeb586b','','','J. Washington Acad. Sci. 18:91.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d27680c5-84d7-5cde-bfdf-ff72302d3838','','','Linnaea 13:418.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d83b54e-ce2f-589c-9a95-91eff3c2e470','','','Fl. indica 147.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e728baa7-e811-5e8e-9e4f-a01de6f1a010','','','Fl. jap. 97.  1784','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ca6c9b8-9a3a-5b7e-a412-074fafccc49b','','','Bot. Mag. 130: t. 7983.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3593164e-f18d-5ffb-be75-53126aa4b5a2','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(1a):87.  1893 (G. Bentham, Gen. pl. 3:73.  1880, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90b1e6cc-a197-5343-adbe-173546e77379','','','Edinburgh J. Bot. 60:561.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6242866-15ba-5af6-929d-8a471f4934a0','','','Ann. Sci. Nat., Bot. sér. 3, 10:326.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bface37-cc5a-5a5e-b120-8a7ed019b70f','','','Révis. gramin. 1:165.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57a4857d-8795-5d1c-b4f0-61d0f9a2158c','','','Beskr. Guin. pl. 58.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa0306c4-94b4-5956-b606-fad1bbc8ea6f','','','Ann. Sci. Nat. (Paris) 9:415.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4615e62-dcb5-5f32-8746-ffd169c72d04','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 20:429.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71cc0327-e438-536a-acbf-c7f1073105c6','','','Sp. pl. 4(2):832.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9026c702-407a-5e5c-8c73-3dd21fc3cec9','','','Telopea 2:760.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab2d3e9d-3fc0-5f65-935d-097557d6e468','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 3:644.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd880618-0984-5837-858a-867709ed6569','','','Prodr. fl. nepal. 68.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60528c82-b1ae-5a1d-95ee-5721ce9dd8a1','','','Syst. Bot. 14:589, fig. 1.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec56a8b5-2533-5dae-9473-b2ee9c48cd6e','','','Brunonia 7:40.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52f1b911-e8a4-5313-8d72-ab8497f14304','','','Zametki Sist. Geogr. Rast. 13:53.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19076e10-d441-53f9-92a9-3427cc31c773','','','C. F. von Ledebour, Fl. ross. 4:343.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf4a8b42-378a-5f18-acc2-7be109f11228','','','Notizbl. Königl. Bot. Gart. Berlin 3:55.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dcd5c09-e113-5fef-a812-cd004c70cb68','','','Bull. Soc. Bot. France 82:157.  1935 "<I>spatulifera</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf2b9c72-e3ff-5361-b364-56a81563155c','','','Bot. Zeitung (Berlin) 36:115.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9e5f33e-6e64-5f00-a761-249cafaefaa8','','','H. L. Duhamel du Monceau, Traité arbr. arbust. nouv. ed., 5:9.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ba25c56-89c4-5110-86b1-4aa342e7578c','','','Repert. Spec. Nov. Regni Veg. Beih. 12:494.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4adb503-0fc3-5c75-995d-1f32549487b5','','','Trans. Linn. Soc. London 28:154.  1872 ("1871")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e92370fd-15b4-5968-8d30-725d707b4eca','','','Acta Phytotax. Sin. 13(4):82.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('089460e1-0ed9-5723-bbe9-78bf7f1f4f24','','','Phytologia 19:433.  1970 "<I>inulaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3275b27d-7def-5608-9c62-afeba30dea2b','','','Trans. Acad. Sci. St. Louis 2:590.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59e88eb4-73c3-5125-bc61-a8a59c92bbb9','','','Sommerfeltia 24:83.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f895a74-cd00-5907-bb92-641c6054063c','','','Tabl. encycl. 1:391, t. 253, fig. 3.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df586f78-f010-54f4-bc6f-e27052d43205','','','Flora 27:497.  1844 (non Moench 1794)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72b71d40-20b3-54f9-a5ba-b61de6ffeaa9','','','Kongl. Vetensk. Acad. Nya Handl. 3:132.  1782','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc561539-2ca5-591e-9453-921c4c6b869d','','','Fl. francisc. 181.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45241bba-426c-57fd-be3a-b2d22aa901be','','','Bull. Torrey Bot. Club 11:61.  1884 "<I>chapmani</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df3fea83-4efe-5659-a887-eba759cdefdb','','','Harvard Pap. Bot. 4:45.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('518ab73c-da28-5be1-9b88-6301e62f4dab','','','Pl. hort. schoenbr. 2:6, t. 137.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abf77bbf-6131-5e7d-9164-5257b472425c','','','Bull. Mus. Natl. Hist. Nat. 30:103.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36818146-3f65-5b5e-9efa-5523226508de','','','Salix 19, t. 64, 65.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40e9f7e4-c571-5cea-8a1d-587a91cb1e33','','','Ann. Sci. Nat., Bot. sér. 3, 2:233.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99aba4e2-3c24-583d-a9c4-cbbcad85a257','','','Mem. New York Bot. Gard. 35:403.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86e37533-eacc-53e6-8050-e01bf0d8f660','','','Willdenowia 36:663.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc406093-0a94-548b-a1c3-bb8bb3da2c77','','','Plantsman 15:124.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fac98400-99b9-59a2-8263-ae51aa41f667','','','Great Basin Naturalist 37:95.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3621b8e-3be6-5f06-80bd-40dbc2735800','','','Ill. woody pl. Korea 264.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('321156ff-c39d-562b-95fa-b6306f1568fd','','','Phytotaxa 46:6.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7dfecec8-b46c-5f3e-a1b2-a83154354210','','','Bot. Jahrb. Syst. 125:47.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('975a07d6-194c-54e8-bb53-8c9b82076dfd','','','W. T. Thiselton-Dyer, Fl. cap. 6:179.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('115b00d2-729c-5ee3-a132-4c2a30cd0100','','','Account bot. coll. Cantor 18.  1844-1845 (repr. J. Asiat. Soc. Bengal 23:637.  1854) "<I>whitiana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7dbdb6a-e8a2-5c70-86dd-e692ad6316d7','','','Naturaliste Canad. 79:242.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd592de9-2fc7-51f9-892f-25d7612a0654','','','J. Bellenden Ker, Bot. Reg. 8: t. 631.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdac3d2d-6e07-5c2f-81db-b08b54847614','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 10:340, t. 5, fig. a-b.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d81b3972-d643-5fad-82e6-006d3813424a','','','Verz. Pfl. Casp. Meer. 200.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35b82894-cb6a-5c43-a834-38f40a2f8935','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:359[folio]; 6:458[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a368f17c-ef1a-575c-86a1-7a1feb8c0347','','','Ann. Sci. Nat., Bot. sér. 6, 15:336.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eedc54ba-0a0e-5292-84ce-d6216395892b','','','Nova Acta Acad. Caes. Leop.-Carol. German. Nat. Cur. 77:120.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d166a0e-c0a5-51fd-9345-53fb562bfdc3','','','Bull. Cl. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 10:345.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2e5de4c-374f-5776-bd5d-70024202a964','','','Fruct. sem. pl. 1:221, t. 47, fig. 2.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4b0c9ef-e03d-5426-8b0e-efe4261e21fa','','','Gard. dict. ed. 8: <I>Mentha</I> no. 1.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec62b346-5936-5fc8-b61c-5989ddd7e4f5','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:206.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e65ed9b4-3ad7-59d5-965d-1ed4080e3592','','','W. H. Harvey & O. W. Sonder, Fl. cap. 1:350.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4c3ca3a-906c-5ea6-8127-60810e4a59dd','','','W. H. Brewer et al., Bot. California 1:223.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d46e8ffc-c8ab-5c3c-9643-cd2fdf64126c','','','Trans. Roy. Soc. Edinburgh 31:161.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('407b2bc3-dc2f-5c45-bff1-7f6088b8cbef','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 6:227.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc770024-8e64-5549-bf25-9ed0aac47a56','','','Martens, Gartenbohnen 52.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('021bb696-fd89-5c3e-b0d5-c67492057a97','','','Reise russ. Reich. 2:332; app. 738, t. S.  1773','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f371f59c-ca9f-5d08-952a-15c51bd75b1c','','','Boll. Ort. Bot. Palermo 1:27.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f13e008d-3f85-5e17-9891-d6b0228dc0fc','','','Proc. Amer. Acad. Arts 12:274.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f19416d-3218-5a2a-80e0-c12d025fed98','','','Syst. veg. 2:724.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77154fd3-d1e2-56ff-aec7-e7cecf8eaef2','','','Proc. Amer. Acad. Arts 19:4.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc699528-8e57-5027-88a9-d8e36669f8d1','','','J. Roy. Hort. Soc. 4:42.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d197007-59b3-5655-8460-7e3771aff31d','','','Izv. Imp. Obshch. Lyubit. Estestv. Moskovsk. Univ. 26(2):207.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('087b29e9-d85e-5ea2-bce1-5406c978083a','','','Advancing Frontiers Pl. Sci. 5:81.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('947cb55f-3e2e-53f1-94e6-14882e079939','','','Essai sur l''Histoire Naturelle des Courges 7.  1786 Aug-Sep? (J. B. A. P. M. de Lamarck, Encycl. 2:151.  1786 Oct)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3034df7-1b85-5de8-b496-a13a617e2bbe','','','J. Washington Acad. Sci. 5:423.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10cae06e-e6ca-5b75-9da4-d87aa8e6f37f','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:208[folio]; 6:264[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1613da6-ee24-56da-8954-31dbd99e05de','','','Acta Phytotax. Sin. 38:560, fig. 3.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('129650ad-1e4a-5c7e-80ac-40c03c01120f','','','J. G. C. Lehmann, Pl. Preiss. 2:206.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd64769d-06a3-57a3-b209-b515c20e19ef','','','Nuytsia 1:467.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('656b11f6-f1aa-5909-873d-8f7b085e5fce','','','Bull. Soc. Bot. France 21:18.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('726cf246-79c8-560d-b78e-0448e29d9e29','','','Hort. dendrol. 182.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58e1ce15-4cfe-5279-91a5-5f377a1b4863','','','Rhodora 30:68.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0378cf26-916d-55e7-a3ae-79b3466b88a9','','','W. T. Thiselton-Dyer, Fl. cap. 5(2):305.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1738863-0023-588a-9e72-26d4c782ecac','','','J. G. Boerlage, Icon. bogor. 4:99, t. 331.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5935ef21-2c58-5781-b762-eb2753a93d63','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 9:613, t. 10.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f73f802f-5993-5e09-9e65-ac76a9ef057c','','','Repert. Spec. Nov. Regni Veg. 13:549.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc05d17c-8586-59a3-a231-3294df2a5066','','','Cactaceae 2:67.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f141dfc6-c84a-55e6-95a5-31203dc732de','','','Sert. orchid. t. 17.  1838 (N. Wallich, Numer. List 245, no. 7307.  1832, nomen)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5694b2a5-269e-58dc-920f-bde9f382a48a','','','Hooker''s Icon. Pl. 39: t. 3870.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e28c69bc-8832-5a0f-936c-6ebb76ddc069','','','J. T. Kartesz & C. A. Meacham, Synth. N. Amer. Fl., nomencl. innov. 20.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b5c068a-2471-508b-a705-6947f9551697','','','C. S. Sargent, Pl. wilson. 2:31.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4fafeb6-d029-5104-8549-411e6e5d4c11','','','Acta Bot. Neerl. 1:468.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ace5531e-af76-5b8d-9737-73c3ce1d563d','','','Bot. Beob. 1782:345.  1784 "<I>salici-folia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff98498c-24ac-5ec9-a4b5-9cb58312980d','','','J. Bot. 11:298.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('671d0d68-c572-5559-a9dd-606f08f7bacd','','','Linnaea 6: Litt.-Ber. 73.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c880606c-7c93-52b5-b5df-38f273073d15','','','H. G. A. Engler, Pflannzenr. IV. 147 II (Heft 44):30.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a880dbf-551c-580b-839c-a9f425033731','','','Kulturnaya Fl. SSSR 1:125.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('017e0a7b-f205-55a7-a391-4019a14c3e6e','','','Mém. Soc. Imp. Naturalistes Moscou 6:167.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cdc164d-c22a-5aa7-b4d7-8754dd6d49c0','','','Bull. Herb. Boissier sér. 2, 8:197.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('263e941b-8692-59bb-b1d9-3a73b4d880bd','','','Beitr. Pflanzenk. Russ. Reiches 2:65.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eeb621a6-41bb-56be-823d-ba5cdee0577c','','','Caesiana 3:27.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78de11f3-5c5d-5b72-9c3f-940929abb0c5','','','Syst. veg. 7(1):370.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98815e59-20c4-5651-96ec-03fea77348cf','','','Bull. Soc. Hist. Nat. Afrique N. 13:21.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76e5afc8-c78f-59de-b208-a964f43dbe11','','','Bull. Herb. Boissier sér. 2, 1:883.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4588ad24-b1fa-531a-b6cc-365fd0f71583','','','J. Arnold Arbor. 25:314.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4b25ece-4a17-59a1-af18-f61c26040851','','','Bot. Mag. (Tokyo) 51:913.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e0c23bd-7272-57eb-83b7-7c1532ce6af3','','','Les Cafeiers 21.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('731200e6-1afd-5187-a283-e7993e65de13','','','Linnaea 22:521.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5024e862-84b5-5237-b8c0-b4378ecb5a1e','','','Jard. fruit. 1:329, sub t. 8.  1872, pro sp.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0808515e-6bbf-5059-85a1-0d3854cf8a5a','','','Sched. fl. hung. exs. 4:38.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c65ba50c-e1d2-56f6-871f-cbf177e0970a','','','D. Oliver, Fl. trop. Afr. 1:400.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96917285-4ebe-5127-95d8-ad8f05e06472','','','Ann. Inst. Bot.-Géol. Colon. Marseille, sér. 2, 6:227.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('901ae2aa-5edb-50ae-8e3c-9ab894e6f56b','','','Nuytsia 15:166.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60422e19-4a97-5a5f-a385-cd99605371e5','','','J. Proc. Linn. Soc., Bot. 3:93.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f61d41de-4556-54b4-a09d-a730dadc662d','','','Fl. Kavkaza 1:136.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0769651-a9ed-5e7a-aeab-72fae234f46a','','','Pittonia 1:29.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a779687-853f-54e4-a7be-fe2fdb58304c','','','Fragm. 11:102.  1880 "<I>Fitzgeraldi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a04fb320-be2a-5ebc-8115-2278164a6eda','','','Man. New Zealand fl. 403.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5322d2ae-5bf2-5330-8870-167d5180aa23','','','Věstn. Tiflissk. Bot. Sada 25:11.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bbc4306-3c50-51f2-9f93-648cc370d6a9','','','Fl. Brit. India 6:275.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2069fdd9-28c5-5615-bcb4-d72d4ce5b932','','','Syst. nat. ed. 12, 2:165.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a990a8b0-6209-5ddb-bab8-f681c88ed331','','','Fl. Brit. India 1:496.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68bc79e9-dea4-567a-933e-6f823e3ddf32','','','Fl. Plains N. Amer. 626.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c24c1086-2584-570b-b6af-8b59739047c3','','','Rep. new pl. 1.  1889; A. Meston, Rep. Bellenden-Ker Range 34.  1889 "<I>inodorus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27d19aee-22e3-5146-8983-3f6ca36c275c','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 6:682.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('695fbdf3-ed35-5ade-9778-b955d9eb6807','','','Sp. pl. 1:397.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17298d3a-4895-5f1f-814d-d2d9ecd41496','','','Anales Jard. Bot. Madrid 59:370.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66134409-de71-51d0-afc0-726f388b6236','','','C. F. P. von Martius, Fl. bras. 14(3):323.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6195e24-6ec7-5e9c-ad7e-a2e8d0f08057','','','Vilm. Blumengärtn., ed. 3. 1:1033.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27a3725a-36ac-5599-aca8-d2a232dab4b0','','','Ann. Mus. Bot. Lugduno-Batavi 1:251.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da31cd79-53fe-5df5-9690-569acf2e8cdd','','','Contr. Gray Herb. 146:80.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7217761d-af42-5620-99a3-9c4660369f30','','','M. Cárdenas & J. G. Hawkes, J. Linn. Soc., Bot. 53:95.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ad442ca-0962-5d86-8c2b-d49eaf5ceea5','','','Gard. dict. ed. 8: <I>Helianthemum</I> no. 24.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d10fa5e-09cf-5a49-83a0-dc64af72f0e5','','','Oesterr. Bot. Z. 28:264.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e3b8d3e-85be-5f7b-99c0-b5bb7d83a2ef','','','Prodr. 1:514.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f93c0b89-81ef-548a-8f3f-f1fe8e4864bd','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 27:502; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 11:266.  1882 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97ec2880-6a30-5ee4-b7f0-be5ecf11b0b4','','','Sp. pl. 3(2):1185.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d10afd0a-9d1d-58fa-a473-962686eec6c3','','','Mem. New York Bot. Gard. 35:604.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f652f737-951b-5e71-9523-6e44ec2ea72f','','','Spring fl. Wasatch ed. 4:106.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f386892-723d-54b8-ab88-0fcd0ca51996','','','Proc. Acad. Nat. Sci. Philadelphia 1892[43]:363.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d910813b-ef26-577d-8adc-5cf40ab0755e','','','Bot. Misc. 3:236, t. 107.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96fe3a9b-6047-5b7c-9544-b8b2d9bb167b','','','Fl. francisc. 3.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb1d4877-f94e-5ac4-81c3-b944cc3a4aa8','','','Hooker''s J. Bot. Kew Gard. Misc. 3:332.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a52f8323-6164-5a26-811d-faec11b7a140','','','J. Linn. Soc., Bot. 20:140.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('205add75-f0cd-593a-b70d-4e7acb4d4a68','','','Sketch veg. Swan R. viii.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff977f36-99c5-5400-9f14-b5cd23f1c67c','','','Bot. Jahrb. Syst. 30:327.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6724130f-9231-55e8-bd8b-bc6633394ed4','','','Naturaliste Canad. 94:522.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ff683c7-bc89-556b-b94a-04a9bd670eca','','','F.A.O. Forest Genet. Res. Inform. 13:50.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4226928b-59ac-54ee-813d-92c1889cdad7','','','Pl. esc. 42.  1786 Aug-Sep (Fl. ins. austr. 18.  1786 Oct-Nov)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a74e69ab-6fa1-5b59-9ea4-a9fa5aff1dc9','','','J. Bamboo Res. 8(1):24.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8e2fd02-1f2d-502b-a357-c32f7761ca00','','','Bull. Jard. Bot. État Bruxelles 27:273.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fd5a93a-e917-5479-9b0b-286303674f24','','','Syst. Bot. 33:350.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cc7a927-aba3-5bfc-a391-230d95f353fe','','','Anales Jard. Bot. Madrid 6(2):14.  1946, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef7617af-da7d-5afc-aa48-a97d00df8a02','','','Ill. Handb. Laubholzk. 1:126.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36a4791f-f3e5-5000-8109-087ea12c4151','','','Prodr. 2:128.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2df54498-7232-5784-abdf-ac8ad8c6bb92','','','Bull. Soc. Bot. France 53:549.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fad8d11-ee2e-5160-becf-ac2e8e04fd51','','','Flora 38:5.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('caa45040-2d1c-5398-90d9-79df98c0852f','','','Excelsa 15:15.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a78bba7-0348-5ea0-bf07-771ddd391bc6','','','J. Cact. Succ. Soc. Amer. 18:77.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('293ad792-c64f-5550-a43a-2973fb7b6048','','','Trav. S. Africa 1:432.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ab581c7-8685-5cdc-8e79-4bf536961226','','','Phytologia 64:52.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6234e42e-8a1c-54f4-9099-29a09c1962b7','','','J. Bot. Res. Inst. Texas 2:267.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('807e28a7-c8e2-53d5-be67-d75ceca474de','','','Symb. bot. 3:50.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd2c8362-a44b-5cae-9a13-bbb27f9c4fb0','','','Spic. observ. Aconit. 22.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3912de8-c2ba-5c62-8e96-ae3beabd4e7c','','','Biol. Skr. 9(3):34.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8f3168e-eb88-5300-bafb-1fc215fa55d4','','','Hooker''s Icon. Pl. 20:sub t. 1952.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e50271b-047d-5e3c-95e8-62890cfc8315','','','Gard. Chron. ser. 3, 2:332.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91a91708-f381-50af-8fc8-9dbe277ebf36','','','Novosti Sist. Vyssh. Rast. 5:18.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('496a0af5-c6d4-560f-ab0b-da0f51e308c9','','','K. B. Presl, Reliq. haenk. 1:270.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c861addf-ccf8-5ad7-82d0-1549c5efcdbc','','','Comm. Acac. aphyll. 15.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('824f1d54-4693-5a7a-a1e8-b586166cab57','','','J. Proc. Roy. Soc. New South Wales 52:508.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7a31c45-543a-524d-9f33-a5ea33c48fa8','','','J. Washington Acad. Sci. 21:339.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62a49253-7c90-5672-9de9-5c83c150d446','','','Izv. Imp. Bot. Sada Petra Velikago 15:366.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9004c4e1-d853-50ac-853e-492ca414b8ac','','','Aliso 5:179.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebf6b798-96e9-5ba8-8db2-4902f954a8e6','','','Repert. Spec. Nov. Regni Veg. 19:234.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a547ea5-b814-53cd-baf4-9afd47a3a1ca','','','Bull. New York Bot. Gard. 6(21):274.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('093900e2-6b5a-598d-9c90-61740bcd5983','','','Ann. Missouri Bot. Gard. 79:155.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f04e2e7f-fc48-540d-8cf2-2bba80a61eb7','','','Sedum N. Amer. 404.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0dc7779-f164-5efe-a9e3-a53c68eeed2a','','','Hanburyana 5:67.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('863e510f-d837-5a12-ad28-ead97ec3e660','','','Turczaninowia 22:40.  2019','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d49a8dd5-c4a7-5b57-831f-d170586ed8b2','','','Naturwiss. Wochenschr. ser. 2, 17(33):470.  1918 (P. F. A. Ascherson & K. O. R. P. P. Graebner, Syn. mitteleur. Fl. 2:701.  1901, without rank)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5930eb10-db50-5643-87bb-8a02f5849516','','','Orchidaceae 5:177.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('616d114a-a2e1-547f-8c34-4c6921560f01','','','Prodr. 324.  1810 "<I>patersoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c56699d5-40e8-5677-aea5-d1809808c825','','','Encycl. 1:644.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29dbcd0a-0e7c-526d-9fb4-eafa5e64a562','','','Trans. Linn. Soc. 6:355.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9d7222c-0b37-5c9c-bc5d-936cca2ba096','','','Nova Acta Acad. Caes. Leop.-Carol. German. Nat. Cur. 70:198.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a641c98e-3a88-5861-8e34-97d14d7b774e','','','J. Elisha Mitchell Sci. Soc. 15:113.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b390c820-012b-5ad0-a8b1-5428a0ca3f9c','','','Byull. Moskovsk. Obshch. Isp. Prir., Otd. Biol. 78(4):139.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af02340c-1c40-515c-93ab-a92f308b3def','','','Hooker''s Icon. Pl. 11: sub t. 1092.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d4ebb27-9660-558b-a57b-b02e6decabbf','','','Trudy Bjuro Prikl. Bot. 8:195.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('407786b3-a4dd-55b0-a43f-47b4e1d7774b','','','Liliac. 3: t. 176.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('398261a0-e9b5-52f9-801a-1959a6a78b05','','','Trans. Linn. Soc. London 8:304.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98ab98ab-35d6-5e33-9f10-bf5f727e2a19','','','Syn. pl. succ. 92.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71df3d1c-4ce4-5ce8-9083-b3ea71cf29ac','','','J. Roy. Soc. Western Australia 47:59.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d58ee1d-ead8-500c-a937-83d2213561da','','','Syst. veg. 5:318.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bc238c3-8807-56e3-925f-bcd687dfab0a','','','Acta Phytotax. Geobot. 8:78.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d821f0ef-032c-592a-8c2e-8d7a48a0cd3e','','','Proc. Amer. Acad. Arts 7:356.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1be1059-cbb1-5be7-ac4d-a4c6ab814d76','','','Pl. Div. Evol. 128:73.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af155bd9-368f-5b03-be66-cab648744d35','','','Voy. bot. Espagne 2:258, t. 68.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('415e580d-6754-51da-b131-4561d760f671','','','Biblioth. Bot. 89:192.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('828d0cd2-d956-5d24-938a-ebf35f50b312','','','Austral. Paniceae 233.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d8a3f0f-8b10-529b-8df1-ebb212307163','','','Asiatic Res. 11:565.  1812 (Fl. ind. 1:162.  1820)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b42b60cf-2846-5c7d-b2fd-5be1ed8483a6','','','Brittonia 48:180.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02128dd3-939c-5910-8a12-0f3344da5f52','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:217[folio]; 3:278[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7aba3275-06bd-54e7-9c5c-b6f24f752b04','','','J. Sibthorp & J. E. Smith, Fl. Graec. prodr. 1:107.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62885f39-4862-56cb-88f8-b7f441e436ba','','','Bot. Jahrb. Syst. 28:62.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc89310f-d3ba-590d-abe8-a0e45fa9784e','','','Gött. Gel. Anz. 1821(1):711.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c4b1bc6-3186-5853-94fe-253eb2de1000','','','Univ. Washington Publ. Biol. 15:35.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee4451a0-3846-5eff-ba09-b558a5946668','','','Fam. nat. syn. monogr. 4:146.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f792b8d-ad48-5325-b4e2-9d346adcce96','','','Mitt. Inst. Allg. Bot. Hamburg 8:104.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0baf4bcf-f817-57e5-8996-b1a80a2e03e4','','','Syst. veg. 6:275.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e6d7461-8afa-57a7-8b7d-4b17c6dd5a30','','','Icon. descr. gram. austriac. 4:4, t. 7.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bcf0c1c-c233-51d6-89e0-b63032ca9ae7','','','Landw. Fl. 309.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18daa9c1-96e4-5378-aa6b-e3698b5269d9','','','Bull. Soc. Imp. Naturalistes Moscou 17(4):740.  1844 (Fl. baical.-dahur. 1:499.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47931f3b-55e8-51ff-b6db-5c32e7eb7d2a','','','Fl. Afr. austral. ill. 176.  1841 "<I>capense</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43df0744-a586-5505-bb6c-246f8a759dac','','','Ann. Missouri Bot. Gard. 108:231.  2023','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47981533-a111-57f7-98ef-656dde38eb97','','','C. S. Sargent, Pl. wilson. 1:137.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4ecec61-65cf-5909-840a-5b1e9e608265','','','Contr. Gray Herb. 53:18.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3656c56f-9323-55e6-a38e-39ffd37b420d','','','Prodr. 3:291.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd5f5f6a-120b-55c0-ad10-b4e62b37e347','','','Bull. Misc. Inform. Kew 1936:323.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('934a5e5b-3b66-5ac7-bd06-290b0a0102ce','','','A. L. P. P. de Candolle, Prodr. 13(1):725.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7098f2ab-274b-5663-99c9-30a5675d3626','','','Contr. U.S. Natl. Herb. 20:111.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bc503ed-7e82-569c-ab13-71d0d6a52490','','','A. B. Lambert, Descr. <I>Pinus</I> ed. 2, 2(appendix).  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21cda7b2-05f4-5b75-9586-5d783a8a9850','','','Rev. Hort. (Paris) 53:190.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a201dbf5-0909-54b6-986d-aa1a8721f909','','','Sp. pl. ed. 2, 1:294.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a33599f-c7dc-5a6c-8636-1a03021c7ca2','','','Gen. spec. Orchid. 2:271.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76ef267e-b88f-5d88-aebf-c52d7873d69e','','','Cat. hort. bot. bogor. 192:311.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('665c5747-ed0e-535b-977d-51a4a63d0880','','','Phytologia 90:73.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35c030ea-8c46-5593-9993-38f93fb9b033','','','Bull. Soc. Imp. Naturalistes Moscou 36(1):589.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12c5fc92-bc75-51fd-a98d-76d2a600507a','','','Byull. Sredne-Aziatsk. Gosud. Univ. 19:122.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0569c0f5-fc4b-5e4c-befd-14e77c16c2b6','','','Sp. pl. 2:885.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc7490b8-e9a9-5f32-a835-2be4d3ef3c9e','','','Labiat. gen. spec. 734.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7486072a-13ee-5063-a9c0-cfc0ed144e57','','','Fl. franç. 2:568.  1779 ("1778")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f160f1a6-f2cc-52a5-91fa-b80451787311','','','Gentes Herbarum 3:207.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9330d2c7-4cba-5159-bbcb-6cb0f443db59','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 11:89.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c01c181a-e79f-50d0-b6ef-8333f78d407c','','','Linnaea 25:25.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3b2ea17-6bc8-5077-98b7-547ccb94350b','','','Willdenowia 33:391.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdb6d4ca-6f74-5c46-a04f-ccb8a3ee0421','','','Desert Pl. Life 9:102.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('559f3782-146f-5646-bba2-6b462b5b0d5f','','','Asclepiadeae 62.  1810 (Mem. Wern. Nat. Hist. Soc. 1:73.  1811)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('683661cc-e35d-5143-8f74-bdbbaab6d4ce','','','Gen. N. Amer. pl. 1:245.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e188ea75-b085-574e-9019-f6b00be7b536','','','Fl. N. Amer. 1(2):332.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('280b8055-cdda-5286-aa92-ea335c292db9','','','Trans. Cambridge Philos. Soc. 6:539.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8748b39e-fd65-52a7-a650-815e25ead7fa','','','J. Jap. Bot. 93:186.  2018','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8867912-3610-57e4-9865-8234cab99f6f','','','Repert. Spec. Nov. Regni Veg. 36:118.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7dd6fe40-588f-5e0d-aefe-bd121e461d1f','','','Bot. Misc. 3:170.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a26b972-61ba-5c52-960f-9f87a35b0e4b','','','Biol. cent.-amer., Bot. 3:507.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72ad4f41-bea1-54b0-8b32-58dd2780b560','','','Syst. veg. fl. peruv. chil. 149.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65a369a0-e37d-51de-a275-929ec8f2c1c2','','','Ann. Sci. Nat., Bot. sér. 4, 17:171.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d50a4f12-8864-5945-903e-8865d231190a','','','Proc. Boston Soc. Nat. Hist. 10:310.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e0affed-2e87-5b84-8584-7964a0019d57','','','Meddel. Grønland 136(3):37.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c5e3bd5-d07f-5164-9ad7-131a6780c269','','','Fl. Tasman. 2:108.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1840b7ed-1103-5b69-afcc-7f08a1e5d4ad','','','J. Bot. Agric. 3:162.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db837c96-ec89-5b01-b647-abeefa53d233','','','Suppl. pl. 266.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04c76f4f-33ce-5367-ac66-769d16dc7f27','','','Sp. pl. 2(2):960.  1799 (non Lam. 1789)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a8ef5bb-9fff-590e-b5f1-e6cebea0c643','','','London J. Bot. 2:124.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fef275c6-ed87-57ff-9913-5fa60d109c79','','','Kew Bull. 34:554.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58e7096f-d8ec-5264-a72d-5ff94b1a1699','','','Bot. Cab. 9: t. 842.  1824, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86084f6e-9357-54cd-8d09-5ea659ea3992','','','Enum. pl. Jap. 2:158.  1877; 593.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a06093b7-1153-5e3f-83bd-0874d02f7edf','','','Rep. pl. Babbage''s Exped. 15.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('440bf78e-8295-5e74-b7bc-411d0eca67bd','','','Bull. Torrey Bot. Club 27:535.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91d71d00-2967-59a9-b306-f0b7b3638bc0','','','Linnaea 32:49.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e27d71be-2d73-56a0-a78a-badac6e00d8b','','','Diss 4:223, t. 97, fig. 3.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca78b1d4-c6bb-51d0-b068-c120b719d9ba','','','Fl. atlant. 1:56.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5614a188-edb7-5196-97e2-a719437d9357','','','Bot. Sturt''s exped. Australia 5.  1848 (C. Sturt, Narr. Exped. C. Australia 2: App. 68.  "1849")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5e2bcf5-32b9-5505-961a-b617e56e1442','','','Fl. bor.-amer. 1:70.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34473221-47fd-5058-8969-75269cb8c81d','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 26:193.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1617a76-98de-5293-b39a-2cc2e1764e3c','','','Bot. Zeitung (Berlin) 10:690.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afb88584-3992-526a-9f5e-8f4248836f39','','','Fl. atlant. 1:178.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29b39a03-b261-5b00-b66b-4dfc987a1a80','','','Biblioth. Bot. 22(Heft 89):196.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4e0b42b-3f19-5e7c-a4b7-feb1e8055783','','','Sp. pl. 1:491.  1753, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc815cbe-e27e-5827-b07d-e9d5dceb52e0','','','Fl. chil. 1:90.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4742f1bf-29a8-522f-9728-ac569833be09','','','öfvers. Kongl. Vetensk.-Akad. Förh. 12:161.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a40c8e0-422e-5231-b731-c7af9d5db029','','','Sp. pl. 1:8.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3af51d30-5b34-5523-aa99-8d56cad3cf44','','','D. Prain, Fl. trop. Afr. 9:842.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('787c7616-c4bd-5dc2-9352-8a6ce8125bd9','','','J. Washington Acad. Sci. 14:241.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('627ba853-1421-59e1-86df-da6c421ea813','','','Bradleya 10:1.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dd45059-ef3b-51e5-8106-41389ae9a585','','','Hooker''s J. Bot. Kew Gard. Misc. 2:357.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('265f05bd-7fb0-58f1-b75b-8bf5c6094e1d','','','Bull. Misc. Inform. Kew 1910:382.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec60163b-429d-5743-a3f6-63e6b352f0dd','','','Bull. Soc. Bot. France 34:389.  1888 ("1887")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6475921b-0f82-572a-98c2-99fc1577ff3a','','','Pl. Coromandel 1:25, t. 24.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64ac8161-3a5c-5a01-b819-eb0c226e09ba','','','Ann. Mus. Natl. Hist. Nat. 4:262, t. 61.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96f3951c-f58c-5f49-a346-01024d909e2c','','','Aroideana 8:19.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3606d0ab-e9be-5c79-954a-ca1c4a2f9cc9','','','Bot. J. Linn. Soc. 96:313.  1988 "<I>suffruticosum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b20a905-ac42-5509-80c2-107b708014b6','','','Soc. Bot. Brasil Anais 75.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69f92c3a-5911-5f7a-b45f-11cfdefb0248','','','Ann. Missouri Bot. Gard. 91:720.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f866501-a46e-5879-a322-0cdaeca8b49f','','','T. L. Mitchell, J. exped. trop. Australia 33.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a84de0e-30d3-5a5b-9fec-472e657d11bf','','','Trans. Linn. Soc. London, Bot. 3:383.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dcedcb1-96ab-5b0b-9447-4730f07d6f06','','','Kew Bull. 24:546.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4444f57-721e-5a75-998e-7902296be8f7','','','Enum. pl. 2:194.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6edb2e0a-3871-5d12-a253-df493375a76a','','','Bot. Zeitung (Berlin) 6:214.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba791372-e870-5fef-aebf-4a489f8c4c4d','','','Hist. vég. isles austral. Afriq. 51, t. 15.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57fed778-19fc-53e0-98ef-cf83ba93c4f6','','','Bull. Torrey Bot. Club 28:510.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0936bbd6-8222-559b-b4eb-28b1463809d2','','','Proc. Amer. Acad. Arts 38:179.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08bd8927-d520-5ae5-9e83-cadf87a3b47b','','','K. M. Schumann & U. M. Hollrung, Fl. Kais. Wilh. Land 16.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b655ef7-3a29-54eb-8949-010833ec7ed3','','','Bull. Soc. Imp. Naturalistes Moscou 20(1):167.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2999f3f4-4958-56fd-b09d-76b685cc04f7','','','Handb. N. Zeal. fl. 731.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b226d9a-5c76-53ed-b929-a10a0f13a857','','','Gen. Ferula monogr. illust. 81.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8880c62f-d25f-5a3b-837b-d7b9d4e39c54','','','Descr. Egypte, Hist. nat. 142, t. 52, fig. 3.  1813 ("1812")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e379f7e-eb14-50dd-854a-c95379b62c67','','','Die Orchidee 39:111.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('264168c5-6a76-583b-9365-aff16a7e44b4','','','Bol. Soc. Brot. sér. 2, 44:190.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00a82ed4-5234-52db-aaa6-c1495be74c5a','','','Hort. kew. 2:130.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6991bd44-3766-5ef1-b4c2-926bc0058b2d','','','Suppl. pl. 293.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('550f53b1-aa99-5787-8c28-3e7dd8f63fa1','','','Prodr. 2:325.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e2c63e8-729a-5d38-a5e0-a3ab69bb64ad','','','C. L. von Buch, Phys. Beschr. Canar. Ins. 156.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f75e154f-9a1c-5d5f-b07c-3daa3a0ee63b','','','Fl. ind. ed. 1832, 2:578.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5711ade5-76f6-5e69-9364-1831bd80b303','','','Nieuwe Verh. Eerste Kl. Kon. Ned. Inst. Wetensch. Amsterdam 5:204.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c723ec3-3933-5712-a8cf-a773cc70cd08','','','A. L. P. P. de Candolle, Prodr. 8:424.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9d19258-0308-500f-bff0-d090fbe57dc7','','','Bot. Mag. 134: t. 8213.  1908 (L. H. Bailey, Cycl. Amer. hort. 4:1538.  1902, nomen nudum)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42a85ab3-788e-5ba5-bc70-3f4599d3917e','','','D. Oliver, Fl. trop. Afr. 3:104.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fe76dfd-c510-5bf8-b2e9-41a093e62a31','','','Fl. bor.-amer. 1:286.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce775773-528a-5505-9caa-297997b2bb60','','','Hortus Sinicus 2:8.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b0bf466-5b7e-54e4-ba17-12823d463742','','','Trudy Prikl. Bot. 5(2):154.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5f002f3-6d60-5de0-82f6-c5f31d121cc3','','','Trudy Prikl. Bot. Prilož. 53:170.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('933effb0-9403-5fbb-904c-6ada9f80d04f','','','Mem. New York Bot. Gard. 27:267.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37c7e6ed-e359-521c-a5c8-1a34fdfe686f','','','Trudy Sredne-Aziatsk. Gosud. Univ., Ser. 8b, Bot. 17: 56.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6705a873-9a95-5a4d-b435-2cc966a26d13','','','Sida 3:384.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48944303-394c-5bd0-83b6-7a608f2bf06f','','','Fl. Congo Belge 6:286.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99a4fb62-079d-5a2d-996b-e948e301d52e','','','Icon. pl. formos. 8:134.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bad62b3-4a97-5e10-bb77-08660eb88e65','','','Bull. Misc. Inform. Kew 1921:16.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac179a79-14e6-52d0-8951-9090b25bb193','','','Bot. Jahrb. Syst. 7:437.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c70fff2-198a-5963-bd3a-d963427c8460','','','Tent. fl. Germ. 1:72.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e04bbbcd-9ca7-5920-b50c-91e87afb0fae','','','Enum. pl. Jap. 2:378.  1878 (1:193.  1875, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db7ccf2f-3a7b-58cb-9405-45a2db3ba7b9','','','Semina 1830:13.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75943999-8921-55c2-bef3-90664e5d07fc','','','V. L. Komarov, Fl. URSS 11:357,401.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f15cebf-8f16-546b-9df4-9f6a0123dce3','','','Telopea 2:28.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46e77d2c-ae2f-56d4-a94e-363c3c3df8c8','','','Trudy Bot. Muz. Imp. Akad. Nauk 12:93.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1eab58a6-01a4-5615-8a93-0e91c2094f92','','','H. Hara et al., Enum. fl. pl. Nepal 3:186.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77b6212a-dde5-5ee7-bd48-a445c048be03','','','Linnaea 30:389.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c46bfb8-21b1-58c2-b888-5746fdf4f7d8','','','Bot. Mag. 81: t. 4863.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1d04260-406a-5c99-8c5c-9241c25506fc','','','F. A. Wislizenus, Mem. tour N. Mexico 90.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bad0810-b71b-5fd9-a4d8-3a6f77a6e179','','','Fl. nov.-zel. 1:136.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('484efe31-1a1c-5beb-918c-7ae37f429dcd','','','Bot. Reg. 12: t. 1006.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3df01857-5da3-50ac-be24-07c6b6d8951c','','','Sida 13:131.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8280cc00-749b-5214-abd8-2428314cbb18','','','Ill. <I>Carex</I> 142, t. 455.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('478c6e7a-1773-59d2-8887-3ea8fd9ecad7','','','Gard. Bull. Singapore 42:26.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1a4de1c-c773-5d7b-a2a8-beb4f15a57c2','','','Prodr. 3:194.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3faa9f01-9bec-52ee-b8eb-c20ce94765ef','','','Syst. nat. 1:426.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('feee12a4-490b-5576-a76e-d744e1056855','','','Bot. Gaz. 40:65.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4eacdb2-3f5c-561e-bb4b-ff3fa29235fe','','','Allg. Gartenzeitung 9:58.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2fc1935-2a28-5aa8-88d3-fffa7bf5ff7a','','','Fl. sicul. syn. 2:97.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26ba6b04-6476-5c77-9a87-dbdd84f5dff9','','','Proc. Amer. Acad. Arts 21:412.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b6af01b-1615-5d99-bb96-c71d92588a4a','','','Repert. bot. syst. 4:55.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3bb7b7e-f5f2-5294-83b3-3eb5919a5ab5','','','Bot. Mag. (Tokyo) 55:356.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64465fa3-53a8-5f41-8570-2690c160c8d5','','','Bot. Gaz. 18:206.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edfe02ee-cf1a-5235-b858-a66cdcb6a78b','','','Fl. peruv. 3:18.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8baae2db-9250-58ac-87d8-a75390bd10cb','','','Enum. syst. pl. 30.  1760 (Select. stirp. amer. hist. 233, t. 147.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('189cdd49-8809-58f0-a3ce-4e429fc49012','','','Notes Roy. Bot. Gard. Edinburgh 45:445.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70b3457c-9014-5fef-8835-6661a6b19e35','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 10:49.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4d6c01a-7ab4-5c9d-bb20-a96c2eeea900','','','Bull. Orto Bot. Regia Univ. Napoli 5:58.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3318c855-bff2-5b17-b568-a63d0dfb3a8c','','','J. Bamboo Res. 2(1):39.  1983, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c75aca99-0384-5970-ac01-ae8de72e0047','','','Syst. veg. 4:411.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92acc85d-5495-5227-bfb8-237d209f5a42','','','Fam. Bromel. 39.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41167b9e-358b-5cfe-bac2-363df1c218b2','','','Mus. bot. 1:83.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b1675de-d247-5fd2-97ce-13377a93d674','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 2:27.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74614f05-1fc7-5fca-81d7-1c4ee145d549','','','N. C. Seringe, Mus. Helv. Bot. 1(3/4):51.  1819 "<I>Sibbaldi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('698ec7bf-9e43-5a77-ac99-ce7d541f8de2','','','Hort. bengal. 46.  1814 (Fl. ind. ed. 1832, 3:42.  1832)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8458f930-073b-59e2-be17-161b93a2cb7e','','','Bull. Soc. Imp. Naturalistes Moscou 27(2,4):287.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6fc1cae-5949-5f7d-b234-00438bf6a20a','','','Bot. Not. 1885:90.  1885 (non Muller 1858)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72bfdc29-5cf1-5e3f-9719-49cbada7f9f2','','','Oesterr. Bot. Z. 42:16.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0f2b830-1b1b-5673-a967-50be6c3d3906','','','J. Adelaide Bot. Gard. 7(1):117.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1156f49-5c37-5c76-a34b-344af9ba8d59','','','Pl. baker. 3:15.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c3ba948-6567-51a7-8646-bf556c09c96e','','','Trans. Linn. Soc. London 28:111.  1872 ("1871")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e626e6ed-4add-5911-836e-ba44be3e253f','','','Ber. Deutsch. Bot. Ges. 14:285.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cea68af-90b5-5fd2-ad82-ee7e197a48b1','','','Zoë 4:124.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63c89de1-e576-53c9-ae31-78a24495a2a0','','','Enum. syst. pl. 22.  1760 (Select. stirp. amer. hist. 148.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dddc6aa3-57f7-55d6-bb0a-0521ed9beafd','','','Trans. & Proc. New Zealand Inst. 2:89.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98fa2ac5-4aaa-5861-ae5d-8c6b0501a9dd','','','Pl. aequinoct. 1:107, t. 31.  1807 ("1808")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de9fce38-617e-508b-b1ce-e6361025284f','','','Prodr. 79.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8710b796-42ef-5afb-80c8-2e84d0acab99','','','Bot. Mag. 125: t. 7655.  1899 (Gard. Chron. ser. 2, 11:216, 12:525.  1879, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb91296e-0179-5623-9420-83e73ee08f4e','','','Repert. Spec. Nov. Regni Veg. 12:303.  1913 (Gentil, Rev. Hort. Belge Etrangère 32:85.  1906, nom. subnud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe9cbe0e-0bff-5079-955e-5ebdada1b97b','','','Revis. gen. pl. 2:702.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e98b9ff-5feb-5850-87ed-98d1a44b88e4','','','Bol. Soc. Brot. sér. 2, 32:53.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d57e6ad7-d9b0-5493-8fef-c783714983dc','','','Flora 56:175.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40e8ba6f-68eb-5bfc-8042-625ff9036a74','','','Recueil Trav. Bot. Néerl. 12:345.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5a8a64d-3cff-59d9-90ec-3a31949d593b','','','Diagn. pl. orient. ser. 1, 10:80.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a209f07-8b84-5b2d-aaa4-28180e4bfa4e','','','Hortus berolinensis t. 70.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c4d6e02-a086-520b-9bc4-e9e13417082f','','','Fl. Neotrop. Monogr. 13:96.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d8f5e89-00e5-55d3-a0d5-77c4c9ce8b4c','','','Trans. Linn. Soc. London 26:140.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30df0196-0ac5-5698-968a-a799d5ef65ac','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 25:371.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('050fd91e-80d4-518d-b443-c68c7653d30a','','','Bot. Mag. (Tokyo) 23:38.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ade92e83-ab0b-56b7-9c9e-2228dccb5bb4','','','N. L. Britton & P. Wilson, Bot. Porto Rico 6:140.  1925 (Sci. Surv. Porto Rico & Virgin Isl.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a96ed72-15ab-50a5-b41e-d62d0b10f999','','','Dendrologie 1:602.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c94b1170-61aa-5e96-b46e-72c777abb2fa','','','Bull. Soc. Roy. Bot. Belgique 15:29.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a36c5ae-ed3e-5f98-9bae-6c75f047cc57','','','Oesterr. Bot. Wochenbl. 3:29.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fae5e7e-6256-5e44-998e-a4d305c6d531','','','Kart. der Schweiz 81.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a29d67e-cfac-5402-a069-79763c88ab69','','','Bonplandia 10:335.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('faa787c1-d166-54f3-8f79-25b3f18cfbb6','','','Ill. Handb. Laubholzk. 1:769.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('affa7776-b097-5cd9-b976-15ec37413504','','','Leafl. W. Bot. 7:136.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fb85e59-80d2-5a06-9195-7808773f8b3e','','','Beitr. Fl. Aethiop. 238.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('297023aa-4d15-5ddb-8867-8dc0643e93cc','','','Bull. Soc. Bot. France 33:232.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c36083b-c3b8-540e-a0d9-802faef1524c','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 9:39.  1859 (Prim. fl. amur.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1faf232e-f889-5fe6-8205-e7d1df379465','','','Bot. Jahrb. Syst. 29:161.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71652af2-4f47-5d9a-86ad-17c840751eda','','','Hort. kew. 1:467.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5191210e-383c-5abb-b8c2-9a97283d0bf8','','','Ann. Fl. Pomone 1833-1834:214.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ca16a80-4b6b-5985-ab4b-00def83629df','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(6):97.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('812c658f-6da8-5f98-adda-86ef70229a55','','','Fl. bor.-amer. 1:69, t. 11.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73021450-6a03-5160-8a95-f6796e422e7a','','','Notizbl. Bot. Gart. Berlin-Dahlem 7:58.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dbd53fb-31b5-5674-aa56-56ac30306469','','','J. Bombay Nat. Hist. Soc. 81:676.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3adfb631-866b-5410-a116-9490a32138a8','','','J. Coll. Sci. Imp. Univ. Tokyo 32:49.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7108c91d-7987-5cec-9900-069fd784e15c','','','W. Roxburgh, Fl. ind. 2:378.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae07be47-970c-56fb-95f5-c940971a09c7','','','J. Linn. Soc., Bot. 10:43.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0c95e4b-df9f-5974-973e-142622563712','','','Sida 16(4):787.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cf6151f-8030-5a35-bcad-d531f92254bc','','','Gen. hist. 1:415.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40536b6a-457f-5527-b555-47c9f587e20d','','','Phytologia 49:483.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3107cb6d-5ce8-5dfb-a955-49fcf967bf25','','','Bot. Mag. 67: sub t. 3861.  1841 (non Stephan ex Spreng. & Link 1820)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5b38f26-e625-536e-9cbd-e1c3e6871642','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:35[folio]; 1:42[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf1cbe72-894f-50e8-a8c4-5fb93455612c','','','Fruct. sem. pl. 2:136, t. 111, fig. 3.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fb0f2ae-60b1-5445-a934-57d8a64d5289','','','M. Zohary & D. Heller, The genus Trifolium 206, 579.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9257fb41-7947-5c89-ada0-619fdeb833e0','','','Acta Phytotax. Sin. 2:105.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92be1301-7dc0-5854-8cc4-7e16ae9faee2','','','Arch. Bot. Mém. 7:62.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a99f3537-0eed-5d38-acbe-6e565e258d16','','','Fl. W. trop. Afr. 1:336.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1c6b372-5a9d-529a-b087-1abcb41a3ee2','','','Edinburgh J. Bot. 49:228.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab29e47d-6a96-546d-8029-346fd6a1c1e3','','','Fl. Calif. 2:374.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee83e11b-6014-5fa1-9ca1-b70b1d6e8367','','','W. H. Brewer et al., Bot. California 1:330.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34730912-46ba-5c16-85b8-ad73997925e7','','','C. S. Sargent, Pl. wilson. 2:42.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19cf04b9-c3c3-5800-b522-6b3bc4abece9','','','Cat. pl. horti monsp. 113.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('751f6852-a20f-5eb6-b352-b77f365bb30a','','','Allg. Gartenzeitung 25:147.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c531ab3-1558-568b-8722-b6e0f37bbcaa','','','Bot. Not. 1930:334.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6ba2c02-5ed8-5c6e-8dfc-2997743813dd','','','Sert. hannov. 2: t. 11.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5affa2c-1f65-520a-b6c0-0ffc6001db29','','','Proc. Acad. Nat. Sci. Philadelphia 1848[4]:15.  1848 Mar-Apr (J. Acad. Nat. Sci. Philadelphia ser. 2, 1:164.  1848 Aug) "<I>brevicaulis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('029c3974-afd0-532a-b76c-790e34cba2af','','','Bot. Mag. (Tokyo) 24:149.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92a51238-115a-53e0-a747-8ae2c253db2c','','','Contr. Gray Herb. 124:37.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcdc7638-d14c-5eea-b2cb-ab5909d510bf','','','Flora 68:381.  1885 "<I>grandidieranus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cc91bfc-f627-5812-aa5e-4b2e1f62f8a2','','','Bot. Gaz. 25:451.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d45915b-35b9-561e-bc82-cf514ec4a8aa','','','Stand. cycl. hort. 5:2833.  1916  "<I>camelliaeflora</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fe5a5ea-1b97-53f6-bbee-47231a7903f5','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 4:231[folio].  1818; 4:294[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34f07c32-0420-574f-bed3-3ea07f46bb8b','','','Gartenflora 85:324.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25880ace-dc2b-5421-8814-bce2bbc70799','','','Bull. Torrey Bot. Club 35:264.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44663404-801f-517b-a86b-a9be99a9934b','','','Gard. Bull. Straits Settlem. ser. 3, 10:368.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92c43147-32e2-57cc-a478-d7374c7fd706','','','Deut. Dendrol. 282.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('662e201b-8f45-59cb-be56-f2778f626b62','','','Sp. pl. 2:932.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6d5c97c-95b3-56df-b1b5-6c1153ea6dfb','','','Chron. Bot. 16(1/6):361.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61c18d79-988e-5fd2-9d6c-a013a5419817','','','Proc. Biol. Soc. Washington 38:86.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12f5293b-5922-5fb1-9a42-6bfaddbbb5de','','','Adansonia 6:196.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c65bb26c-bca7-5f06-9ac9-03d11e4841df','','','Blumea 28:342.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04c7cc44-b9af-5fad-9a95-651273b4e83d','','','Enum. syst. pl. 26.  1760 (Select. stirp. amer. hist. 195.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45df22bd-b271-570e-a368-fe9124168044','','','Labiat. gen. spec. 611.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2846e63d-c10c-5a56-8fe2-a6ebbb4e0a5d','','','Austral. J. Bot., suppl. 9:55.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('142bcfbd-db71-5a13-a3bd-0823d9545637','','','J. Bot. (Morot) 8(20):339.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af730050-a2e6-523f-8766-b73fc3c098bd','','','Suppl. pl. 272.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('312a782b-8dae-52bd-b8ec-4a166ef9991c','','','Nov. gen. sp. pl. 3:70, t. 279.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60b9f6d5-eb23-5d3f-9d98-5f6fcb2c847b','','','Kirkia 6:6.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4b298ce-5591-5350-9aeb-ccfa83efa3a2','','','Fl. Filip. 755.  1837 "<I>trisperma</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d430aaa-777f-5eca-841c-02dc77f874f3','','','Bot. Mag. (Tokyo) 33:201.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c29d25ba-2949-5aad-8a88-20105862fa96','','','Nouv. Ann. Mus. Hist. Nat. 3:401.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62be583e-cd7e-5e62-870d-468d33ee6a0a','','','Bot. J. Linn. Soc. 172:513.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58e5b912-ee19-5451-802f-c7a55fba4f84','','','Sida 20:1467.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05bbfa5d-5b29-53c0-a597-81de58be9006','','','Amer. Naturalist 7:300.  1873 "<I>thompsonae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('431a1af9-05a2-56a5-833a-48699b7bc586','','','Trans. Linn. Soc. 5:225.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e551a23b-52f5-5717-9ef5-2e0e23b1f197','','','Collectanea 1:138.  1787 Jan-Sep ("1786"); Icon. pl. rar. 1: t. 52.  1787 ("1781-1786")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b7940fc-1f87-5096-802a-600a8ad3b200','','','O. A. Leistner, Fl. S. Africa 27(4):51.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dffe68dd-8c2f-596b-b18f-9ddebcfdd808','','','Proc. Biol. Soc. Washington 17:100.  1904 "<I>Pentstemon</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27a1c597-5dee-5bd1-9eca-a61cbde2fb8f','','','Bull. Torrey Bot. Club 45:15.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a562273-73dd-5cb4-84af-caeae203f76f','','','Trop. Subtrop. Pflanzenwelt 85:20.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f9637e8-49b2-51e3-807d-7fa84821b435','','','N. L. Britton & P. Wilson, Bot. Porto Rico 5:266.  1924 (Sci. Surv. Porto Rico & Virgin Isl.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('727afe67-642b-5dd3-bc5c-e78964cc15c9','','','Revista Argent. Agron. 4:247, fig. 1.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18f6c674-20da-564c-8d14-2f0f59855c5d','','','Enum. pl. afric. austral. 202.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bd2046a-47e7-5067-9591-1ae5064f1f82','','','Trans. Linn. Soc. London 10:166.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01b5706e-84a9-5315-b5d8-6021c6713ede','','','Mem. Acad. Roy. Sci. Hist. (Berlin) 1798:102.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe555df8-04a9-540c-a657-ef6732adfeca','','','A. Rees, Cycl. 31: <I>Salix</I> no. 10.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6286ecb5-d275-549e-99db-39e29789acc0','','','Proc. Biol. Soc. Washington 26:195.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a3ae34e-e268-5ccc-a9bd-32e3a3003d98','','','Encycl. 3:199.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f8cb46f-eda3-578a-b11c-e3d0f7ef885c','','','Pl. delavay. 206.  1890 (non Boulay 1868)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25f1abea-8f8a-511c-8282-bf55aba04304','','','Contr. New South Wales Natl. Herb. 4:455.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24d804e8-faaa-5ab3-b705-858aeae3734a','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(7):125.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c6448bb-ec75-58e4-8bfe-c8dec24c09dd','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:66[folio]; 1:77[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0526b2b-f89b-50ce-8f4c-0c1e364ed074','','','Begonias penins. Malaysia 256.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa70fb3a-93bb-5c23-bc4d-80ab0d3dbbd8','','','Icon. 6:18, t. 528.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd5c424f-602e-5262-99b4-179e902c03c6','','','Amer. Midl. Naturalist 41:501.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7bbcf7d-4930-5cb8-b0bc-da90ceb5500e','','','Edwards''s Bot. Reg. 25: misc. 73.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27e02fb1-99cb-53b6-9075-6fb41d61f44f','','','Repert. bot. syst. 3:481.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26ccb04a-a073-594f-96b8-3e6047001680','','','Trans. Linn. Soc. London 28:147.  1872 ("1871")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f9f1dba-ac06-5bdf-9b2e-592e06cd6e89','','','Jahrb. Königl. Bot. Gart. Berlin 1:334, in adnot.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce9ebb6f-9586-5de0-9915-62a32f6a6ed1','','','Ergebn. Bot. Exp. Sudbras. 1:5.  1906 (Denkschr. Kaiserl. Akad. Wiss. Wien, Math.-Naturwiss Kl. 79:66.  1908)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84ecf291-e998-5a95-bbed-2c2d652a5d80','','','Char. gen. pl. 58, t. 29.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65dd1fe2-5a47-55ca-869a-6a992ef36779','','','Man. cult. trees 683.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('555abd47-5f72-5ef1-864a-deee0911a00f','','','Nat. hist. 14:68, t. 95, fig. 2.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ca76d63-0860-5708-822d-420352353386','','','Gard. Chron. ser. 3, 1:346.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72225781-1120-5b8a-896a-7cfdcad5896b','','','Landw. Fl. 322.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ceeca3f-73f8-50fc-bfac-e244412cccc9','','','Scroph. ind. 42.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8dc61860-f4cf-5087-92b3-0a05a645596a','','','Mém. Soc. Méd. Emul. Paris 280.  1782','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27da9a8a-de80-5900-9c1a-002b9966be62','','','Encycl. 5:516.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d524e93-7f0e-5c07-9606-0050e57d88c2','','','Fl. atlant. 2:69.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84dda51b-8bd8-50de-92e0-9f7f0df8d2b0','','','Mus. bot. 1:381.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05c9172c-24f1-52a5-86a7-85c5a4869a80','','','Sp. pl. 1:210.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5349291-96c6-588c-a180-32611944782e','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:181[folio]; 3:232[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a7683ed-e4ad-5958-9912-b659db5ca775','','','Fl. New Zealand 1:434.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cced0167-8d59-508a-927d-8eb942aa536e','','','J. Linn. Soc., Bot. 25:26, t. 13.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('930f3264-c187-5377-943f-75534d17a6b5','','','Acta Phytotax. Geobot. 6:49.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a599956e-12a5-5483-be7e-9d2837e50102','','','Bot. Jahrb. Syst. 65:110.  1932 ("1933")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1f24b83-bc69-520e-b2bb-b9511f978c1d','','','Novon 17:64.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6668996-61ec-57a2-b5f8-6014cc4e4a94','','','Sp. pl. ed. 4:901.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62458346-d40a-5e59-97c8-44331c4be2f1','','','S. Watson et al., Bot. California 2:249.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6fd5c96-0abf-5a7a-848a-a624cb321a9d','','','W. J. Hooker, Fl. bor.-amer. 1:153, in adnot.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32a1bc56-d960-5e8b-9c3b-99ee197d1e2e','','','Darwiniana 16:793.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25e0c797-e395-50a7-9a3b-4bb8a0a9b6ad','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. ed. 2, 18a:419.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63a27616-64ce-5ac8-ada6-61802abf3cf5','','','Fl. pedem. 1:48.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9af6383-68d0-5916-b06c-9c49c339428b','','','Flore de Madagascar et des Comores 189:264.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf78ffb0-1288-50c7-aee8-8146aa768b54','','','Bot. Mag. 129: t. 7878.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6db6b0b6-0f72-5eb5-9a31-79a80f0834e3','','','A. L. P. P. de Candolle, Prodr. 15(2):1073.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06695c06-1c28-5541-baa0-1a20100d39f4','','','A. L. P. P. de Candolle & A. C. de Candolle, Monog. phan. 3:623.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('410955d2-f2bd-5877-ac28-95abeaed1d07','','','Rev. Hort. (Paris) 38:340.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac522a63-76d0-5fad-8b66-67656c3614aa','','','Nat. arr. Brit. pl. 2:417.  1822 ("1821")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a7d7d26-78f7-5afa-a847-bd927f730f45','','','Contr. W. Bot. 10:28.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a70f11f-a4bd-5e41-9815-e9439391ef1d','','','Haussknechtia 4:38.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db253781-7357-5d4e-b00d-2b9026f8aca4','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. ed. 2, 16b:51.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b6196c6-293e-5c43-b0e6-5ec73dc4767e','','','Bol. Mus. Goeldi Hist. Nat. Ethnogr. 5:427.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df361d8f-5f0a-5caf-ae79-4080872979b8','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 9:112, t. 7.  1859 (Prim. fl. amur.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4984ac90-04a6-593e-8d79-88c316c7d7fc','','','Bull. Misc. Inform. Kew 1935:243.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08e440e5-b4f3-5b3c-b86a-f37ffa752d0d','','','Prodr. 1:140.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10c9fcba-2f61-5bb9-80ac-6fdd8974585e','','','Pl. wright. 1:89.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3dfba9d1-fc97-557d-8b5d-e19cb5598cbc','','','Gentes Herbarum 12:15.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6d509ee-7d16-5475-8b6a-fc050e845383','','','A. J. G. H. Kostermans & J. M. Bompard, The mangoes: their botany, nomenclature, horticulture, and utilization 52.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('637b108d-ade0-5328-a8de-9ded38c16f1a','','','Ann. Missouri Bot. Gard. 64:412.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9634e47-5919-5634-b65c-d09ebc9d7a11','','','de Acere n. 8.  1781','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2d8aa66-36b4-5b59-9a53-40a7b0587d63','','','Catalogus 72.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1eacbdf2-81dd-5ed7-9757-85e3b3bbc2fb','','','Contr. U.S. Natl. Herb. 6:810.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fce9ca6b-25fe-59c7-9eb2-fdc015ceb6e0','','','Bull. Mens. Soc. Linn. Paris 1:752.  1888 "<I>coffaeoides</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1239a5e3-24a2-5cfd-b82b-115d3c357df3','','','Opera Bot. 114:263.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb644f5f-9567-567d-8d9d-620dad02e3f9','','','Cactaceae 3:1678.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('003b26b6-05ad-50a9-bd33-45915190cce5','','','Bijdr. 701.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0057433b-99c7-53af-a0db-83e357aa5f53','','','Novon 16:309.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf4d0caa-45b8-5063-a555-fece3fb1cb26','','','Fl. s.e. U.S. 668.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7df794b1-de47-5c05-8148-9307f73fdfe0','','','Kew Bull. 22:265.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acb33055-31eb-5a17-9961-1e1451b25c40','','','J. Arnold Arbor. 45:425.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0f6d2b6-305b-5799-99d3-f53c5b410f02','','','J. Proc. Linn. Soc., Bot. 3:91.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78bdf1d5-d180-5364-8b10-04215a26aab4','','','Handbuch 1:10.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acd7e24f-a489-54de-b562-23c90b8d824b','','','Bot. Mag. (Tokyo) 26:167.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5222dd0-1faf-5386-bda7-c2f66600b84a','','','Cat. pl. Upper Louisiana no. 51.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34f8043e-25a0-5c59-ad45-3fd0a65f1a95','','','Edinburgh J. Bot. 56:355.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac9126b6-dad3-502d-b7e1-be904fb04293','','','Bot. Jahrb. Syst. 117:498.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('160e9185-bf06-58fe-97dd-ff28117a26ad','','','Succulenta (Netherlands) 69:211.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51e6271c-6717-5286-8980-a0a6d780f688','','','J. G. C. Lehmann, Pl. Preiss. 1:543.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9234e50-cdbf-5002-8664-c6b058018392','','','L. H. Bailey, Rhodora 18:158.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('958cfd51-5022-5fd7-b671-41d3ea5b19e6','','','Bibl. cult. trees 33.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c8ed9fc-fd08-5647-b65e-17cd232adcff','','','Reise russ. Reich. 3:727.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ee730cc-4493-58c4-af33-77d4af0732c2','','','Mem. Torrey Bot. Club 18:138.  1932, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71d4fc18-7315-53bd-a214-78f53cebe99c','','','Biol. cent.-amer., Bot. 2:168.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5b727d9-46b7-5731-a589-8d82c55ceeba','','','Arbor. frutic. brit. 4:2201.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f009f17d-d21f-5ec1-8926-9e651e98abc3','','','Repert. Spec. Nov. Regni Veg. 22:352.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff30ac5c-c066-5d1b-a5d0-d632e9b696e2','','','Traité gén. conif. ed. 2:791.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('caefe7b0-2836-55c7-9264-6afcee1aad58','','','Edinburgh Philos. J. 11:347.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec011ef1-f362-521a-9578-3a28a401d76f','','','Nov. pl. sp. 341.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a5a3b69-3845-506e-aeca-3f65ccc80230','','','Bijdr. 58.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed736402-286a-54c8-bea0-b6c221fe5675','','','Fl. Iranica 63:8.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a5cfd62-8445-54d2-b475-8d7e54fd5765','','','Tent. fl. abyss. 1:444.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78e8cf26-85af-5ca1-80a8-b8869f21ba76','','','J. S. African Bot. 41:115.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08999391-6132-5511-b6ea-398a42f2643a','','','Prodr. 15(1):320.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8390dc72-d8ed-5770-b9e7-a990216f39a0','','','Sp. pl. 2:742.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cb8306d-c473-5611-95a2-fd21d2b84b52','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1881:102.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b8aca1a-7820-5456-bb02-237afb93292b','','','Prodr. 9:498.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('549f239d-a4c2-5095-8bc8-718811d9f494','','','Proc. Calif. Acad. Sci. 2:32.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('125fa838-ecb2-53b6-8f72-e62731ec0860','','','Cact. Succ. J. (Los Angeles) 5:489, fig. s.n.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6ed6a19-621f-5692-b762-f7e094d994e8','','','Amer. Midl. Naturalist 11:268.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20af95b6-9ac5-5a11-86b2-49bcb0c5ee03','','','J. Bot. (Hooker) 4:337.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8a45a0f-19bc-59fc-af6b-30eb79c0897e','','','Gard. Chron. ser. 3, 27:130, 195.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ec50df0-6894-52b6-9c55-a348b2940575','','','F. Mason, Burma ed. W. Theob. 2:541.  1883 (Taubert, Bot. Centralbl. 67:395.  1891)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4f987bf-a30d-5183-aab2-f31fa9de30fd','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 10:16.  1887-1888 (Pl. david. 2:74.  1888)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97aed661-7e9c-5f67-9b96-ac17aa28605d','','','Legum. Trop. Africa 2:468.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4db33631-8fd9-57fc-a422-0be34d7743bf','','','Enum. pl. 2:232.  1805 "<I>Rynchospora</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbbad75e-484c-582d-be28-d11dd1920773','','','Kew Bull. 25:172.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f9f4c8e-26bb-5ad4-8e6c-d73040796e1b','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 59:182.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c9c1966-bb68-5cde-97c5-8dbd86bb2e6b','','','Sp. pl. ed. 2, 1:450.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d3cc0c5-963b-5aa0-8ca5-ecfbd49a2a7b','','','Fl. flumin. 244.  1829 ("1825"); icon. 6:15.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d9e40ba-3189-5a5f-a217-618dffd7fc99','','','Phytologia 1:480.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('333759f8-a59b-5afa-86b0-d6c27bddd0b0','','','Bot. Mag. 16: t. 626.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6207b762-9999-5595-a603-df9b2802ecd8','','','J. Jap. Bot. 55:97.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36655ee4-317d-5f0a-8c09-fd0bd8cea4cc','','','Cat. pl. Salton Sink 6.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f3cdffb-69f4-51a7-ab69-2e2046c43c07','','','Trees & shrubs USSR 3:763.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('634da663-2381-5c3e-ad90-339843971413','','','Bull. New York Bot. Gard. 4:222.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54a90ac8-15a2-58be-87b2-409c7c10e0b7','','','Nederl. Dendrol. Ver. Gedenkb. Suringar 184.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('388c6a37-5c69-5709-b4f0-a99144d2af81','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(8):36.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fa726e5-222b-5001-9eac-5b1c03184631','','','Animadv. bot. spec. alt. 27.  1764','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('200478ed-0adc-5069-9325-e8fa304c097b','','','London J. Bot. 2:285.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41cd9728-19f0-56d5-b02e-ca8191fe9782','','','N. Wallich, Pl. asiat. rar. 3:78.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2801954e-1382-5d14-be7c-93e6cfebe0c8','','','Gen. sp. Orchid. 1:41.  1877 "<I>Bolbophyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f4e15dd-bf3a-50d9-b6ba-978e4708c395','','','Linnaea 38:76.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74f5a3a2-6c14-500c-a6af-2480a5391ffc','','','Gard. Chron. ser. 2, 19:274.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81ecf91b-a6c1-53ca-bf2b-f6bd5b6e15c3','','','Novon 17:449.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c032157-a835-5766-9e02-4f54e1e532ca','','','H. G. A. Engler, Pflanzenr. IV. 20(Heft 38):468.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e545b86-8100-5266-aceb-0ed6788c8274','','','Acta Sci. Nat. Univ. Sunyatseni  42:118.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('effb3504-2c1a-59ca-b23f-eecae422b431','','','Symb. antill. 9:207.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('710bb0cf-6d14-5af6-99a3-e0df73e55828','','','Ann. Lyceum Nat. Hist. New York 2:232.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90a1d7d4-c595-550b-96cd-0c15249d01ec','','','Cent. Euphorb. 30.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f73988d7-d48f-5343-bd76-8345a05d43e5','','','C. S. Sargent, Pl. wilson. 1:165.  1912 "<I>floribunda</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7128a2e-6a09-5f50-8b78-02f6b8bec05a','','','Sp. pl. 1:474.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d4d8ffd-2440-5a8f-8868-dad672ebe44d','','','Leafl. Bot. Observ. Crit. 1:206.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('733f478f-da1c-5c4e-b3b5-8f0c8dd92ed7','','','Cat. jard. bot. Krzemieniec suppl. 4:20.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb70f750-612c-5601-b529-c422bf72fc0d','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:199[folio]; 2:245[quarto].  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a19d6e0f-c8ef-5c64-8e1d-d849f972c175','','','Kew Bull. 54:209.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae051083-2b97-5116-a9a6-a0afd435065a','','','Linnaea 22:793.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26bfd717-3546-5988-97a3-d54a0f193b4f','','','Cact. Suc. Mex. 34:52.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fc15142-d11f-5c46-bccf-381f29bb6716','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:168[folio].  1823; 6:213[quarto], t. 555.  1824 (non Pohl 1815, nec C. Presl 1822, nec. H. L. Wendl. 1823)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cc55585-b881-5532-8ba9-73901b219877','','','Fl. Korea 1145.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f768607a-fef2-58cd-b355-cb203a5de088','','','Enum. pl. afric. austral. 212.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('975cb316-d1e8-5284-9df4-02f6f9da61cb','','','Proc. Amer. Acad. Arts 10:72.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2c4cb68-43e5-578a-9477-91c66ffd8b91','','','Linnaea 5:246.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f40d61e2-adda-5383-869a-3d55a84b40e8','','','Sp. pl. 2:957.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f86d7ab2-1c95-5efd-a97b-01996e9bea96','','','Bull. Soc. Sci. Nancy sér. 3, 9:208; Mater. Étude Fl. Geogr. Bot. Orient 4:60.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bf7ec57-30c7-5656-a7e8-4cec4cb87368','','','P. R. J. Bamps et al., Flora of tropical East Africa: Guttiferae 28.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e579b23-7060-577d-a5f2-aa96f3ff941d','','','Rhodora 3:251.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb60bdfe-64ec-54f7-b14a-7731b1cc660f','','','Bradleya 30:15.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06da1b62-75ef-50cd-bbe1-ae4a88621506','','','Madroño 14:20.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c8a9573-f4bf-56fc-ba7c-5afc14ce24b2','','','Encycl. 7:129.  1806 "<I>Sesban</I>" (C. Persoon, Syn. pl. 2(2):316.  1807)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ded4a669-f91d-5824-821c-975aec99477c','','','Martelli, Webbia 1:320.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d46b4441-b1fc-5590-a77b-ff2354ed5416','','','Trans. Linn. Soc. London 28:49.  1872 ("1871")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a8308dd-573e-56c7-a087-d847a6218a64','','','Phytologia 77:260.  1995 ("1994")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a307c1d3-6065-5665-b929-6d14bedbc9b2','','','Amer. J. Bot. 36:164.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('689f4d5b-da67-533f-a11a-e43d0a6fa02d','','','Bull. Soc. Hist. Nat. Afrique N. 30:343.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a16b2dc-767b-5e52-9644-b1be78e9c258','','','Univ. Calif. Publ. Bot. 13:138.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('106620a2-f805-5d28-a329-cc5aeadebba5','','','Ark. Bot. ser. 2, 1(5):309.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('551ba9ce-a3fa-537f-ba0d-0edff56403ae','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 6:329, 334.  1778','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bb1b0b7-574f-535a-8f1f-958accfa4f42','','','Fl. cestr. ed. 2:414.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f27c8a61-406c-50a4-bfd0-cc2968911475','','','C. F. Forster, Handb. Cacteenk. ed. 2. 818.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f61248f9-ac4f-5ab6-8ac5-c3fd25e6a169','','','Syn. mitteleur. Fl. 6(2):936.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ce81766-aae8-5b95-8948-730e9dd5c71b','','','Ginkgoana 1:295.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ce0ed71-5da0-55c4-9cb3-0eb09667d7af','','','Observ. bot. 2:26.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acc75b65-fd0a-5f98-bb36-5948b9ace590','','','Bull. Bot. Res., Harbin 15:356.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0607374-6fa7-59f8-8bb1-4f7e375c7349','','','C. S. Sargent, Pl. wilson. 2:311.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58754339-47fa-565e-8387-2f6927351066','','','Exot. bot. 1:1, t. 1.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d7ad81f-178d-5b60-b3a6-ad0ee03ae3e8','','','Fl. ind. 1(2):74.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3486ca4f-68d0-58bb-a38c-15c731558c52','','','A. Rees, Cycl. 27: <I>Philoxerus</I> no. 3.  1814 "<I>vermiculatus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea5b8164-0f5f-5e00-ba2c-7a100ee41a3f','','','Nom. nov. gen. Dactylorhiza 5.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ddf9be1-3bea-5c16-acbc-19ecf12a21b1','','','Kakteen-Freund 1:131.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9a6f819-70e3-51f6-8eef-e0d20b835937','','','Fl. taur.-caucas. 3:246.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f099210-0205-5252-847d-1a46d6712679','','','J. Bot. 69:13.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6421b3cd-c771-5bd3-bd39-2e17ed36e371','','','Kamibayashi, Chosen Yuri Dzukai, t. 7.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bf544db-0e3a-5dd9-beb1-c59217d21d15','','','Bot. Mag. 62: t. 3410.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('323c0d7c-b240-5f91-8f8f-ed1834535503','','','Symb. bot. 3:26.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3c977e2-3c33-5e00-82f1-da2024c840fa','','','Contr. U.S. Natl. Herb. 7:107.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('566254ff-3bf1-59dd-ae39-614b66eb9aa7','','','Rep. Exped. Forest. Kyushu Imp. Univ. 1:65.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f86327ec-c101-5697-8e7d-fd8da64b76a2','','','Flow. Pl. Africa 44: t. 1723.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd43551e-a7a1-552a-a964-6d5e69691468','','','Mat. fl. Malay. Penins. 81.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02f54260-3709-58d5-a79e-eb3571d3e995','','','Tent. fl. abyss. 1:155.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75eacb55-bfab-5eaa-a0d4-05d2a81d8c70','','','Prodr. 282.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ca63d31-4391-5310-82d0-1c94c0da22eb','','','Trans. Linn. Soc. London 7:9.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eee37e04-91c7-5bec-86ea-252f465c7072','','','Proc. Linn. Soc. London 151:218.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e133809-41fc-5c90-b384-2d818a4ab3e1','','','Arq. Inst. Biol. Veg. 1:205.  1935; Trop. Woods 43:19.  1935; "<I>Torresia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f83d8042-e4e9-5262-9622-9c24eb7635bc','','','Fl. Ned. Ind., Eerste bijv. 539.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94c50f8c-7860-551b-a6a7-004b9a6f3818','','','J. Jap. Bot. 13:385.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1ee9619-d243-5167-8c0b-83e6337b5bde','','','Gen. N. Amer. pl. 2:221.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63359270-0d36-51db-b347-229e476c3ccb','','','Bot. Jahrb. Syst. 30(Beibl. 67):15.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6c2e3f3-88d5-5291-83c3-d8fe9fbe82de','','','Bonplandia 9:367.  1861 "<I>edulis</I>" (Schott ex Seemann, Bonplandia 9:260.  1861, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cee16e0d-0a55-5640-b404-bb57c1805535','','','Proc. Amer. Acad. Arts 29:294.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('448e399c-9240-5d37-864c-573d28c4f6e3','','','London J. Bot. 3:201.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86351c04-3c46-594e-b839-61b7f7a4f746','','','Leafl. W. Bot. 6:41.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6dd203a5-c779-5f76-82f6-69cf1da7bd08','','','Fl. Filip. 1:807.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce86f820-b23c-5d7f-9812-289fe65c9b07','','','Exot. bot. 2:109, t. 114.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a649e85-3921-568c-ab8a-6ad422740dea','','','Fieldiana, Bot. 32:157.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0647f1f3-1621-5d80-b475-5be6d93571d0','','','Hl. Blast. Nisurou 74.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('736f24ba-5c58-5a74-a90b-335c8d0e8d2d','','','Phytologia 50:185.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41d4b86c-4719-5bfd-86ed-5165567848e1','','','Icon. Pl. Formosan. 1:137.  1911; J. Coll. Sci. Imp. Univ. Tokyo 30:59.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cf3ccff-efae-5140-8ecf-c1703d9ec59d','','','Contr. U.S. Natl. Herb. 17:430, t. 25.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49d188cf-b585-5cc2-b28d-677ff2cc2984','','','Trudy Prikl. Bot. 55(3):48.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a6e7f5c-5bb7-5fe4-b02b-a31c78ba961c','','','Fl. tellur. 4:81.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0880af33-18ad-5061-b10b-a398683193e3','','','Hist. & Mém. Acad. Roy. Sci. Toulouse 3:308.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f2e40f4-2702-55fb-a489-735a6c79fcd2','','','Field & Lab. 18(2):73.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63ad806f-d924-579b-893f-cd807b3a9708','','','J. Bot. 52:289.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d369e12-b7d6-5ef7-a8ba-c2e733f6b1e5','','','Fl. portug. 2:11.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e3d006d-7a4d-5fa7-bef2-b26c7e47a385','','','A. P. de Candolle, Prodr. 2:607.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66c5e4be-8080-53e7-88f1-c29b349914e5','','','Malesia 3:92.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2d3238b-d96b-5272-bea6-5e5f022612b7','','','Bol. Soc. Argent. Bot. 24:195.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3579791d-7e84-5eff-ba4b-8521546838eb','','','Icon. 1:10, t. 14.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80052310-dc09-57c0-834f-ee41475a044c','','','C. F. P. von Martius, Fl. bras. 2(2):52.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('891c3924-5371-5e02-bb16-9014d8c22e20','','','Pl. aequinoct. 2:84, t. 105.  1811 ("1809")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea7dae3d-996b-52bc-a026-a3a7fb2a92be','','','J. Bot. 66(suppl. 1):128.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c38a612-ccfa-54b3-b41d-89705311efd4','','','Onira 3(15):44.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc367ad9-13b0-5f50-8b23-34464675e8f5','','','Nomencl. bot. ed. 2, 2:471.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89713959-0862-5397-b022-765113efef0c','','','Sp. pl. 1:271.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ced5473e-9918-504e-9483-af004f6ede35','','','Fl. tellur. 3:53.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee45946e-8262-5b4c-b130-458ce3e97c1e','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 6:170.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a46de70e-09dc-54fe-8176-a05277ffdc22','','','Trans. Roy. Soc. South Africa 2:37.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('649d3999-be5e-577e-b55c-1d93cc87bacd','','','Sp. pl. 2:1187.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f56db0e-1b2c-5e9c-95b5-d983c3b6b612','','','Sert. angl. 29.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0af7005-a1fa-5fb2-bb83-40723f2fbdfe','','','J. Bot. (Morot) 13:202.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a095dc90-b1ff-5891-a6c2-559dd04f5a48','','','Bull. Soc. Bot. France 103(Sess. Extraord.):127.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de48e13a-b6da-514e-932f-7fdfd5476660','','','Encycl. 1:287.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e267790-87c1-59b0-a0ee-2c9c5148ae99','','','Encycl. 2:381.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92f3f981-3d9d-54cf-bce7-478e09edf9db','','','PhytoKeys 25:99.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a61fa547-d09f-5000-94a3-16b3c0647795','','','Acta Bot. Fenn. 39:20.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3beaae3-559b-5f7f-9898-56976ebbab17','','','Bol. Soc. Esp. Hist. Nat. 23:245.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c890802d-bc22-5825-af2f-17e3a82cf8df','','','Jahrb. Königl. Bot. Gart. Berlin 5:148.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b606b3b2-5ffc-5176-a6e5-b8537b690877','','','Linnaea 34:66.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24d99a57-e3cc-5b51-bf35-414903e4b917','','','L. Bailey, Cycl. Amer. hort. 2:942.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b493ef5-5cdd-5a8e-a2d6-fb15d36c8228','','','Phytotaxa 175:113-116.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b133c7ee-5329-566e-9210-7a24f7821a60','','','Banisteria 1:6.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea09736a-2a5f-55cd-9e2f-2870e73d0f9a','','','Enum. pl. 41.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a53d27a-4d30-5ee2-b470-b057d21b7bd9','','','Repert. Spec. Nov. Regni Veg. 43:146.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90bbb1fc-cb3f-5f15-abcf-e672b4c73f82','','','Reise russ. Reich. 3(2): t. kk.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23d08f58-8481-5fff-8986-5b910e6276e5','','','Nov. Actorum Acad. Caes. Leop.-Carol. Nat. Cur. 21:26.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('694350ab-0643-5614-90c9-513677835827','','','Contr. U.S. Natl. Herb. 18:319.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c129a786-3e8a-50d1-bbab-b058e6125ec0','','','Deut. Fl. 790.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('822dddcd-094a-5992-aa9d-350f3118951c','','','Sp. pl. ed. 2, 1:128.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba936fa9-73a2-538d-b756-b79dffc5a661','','','Strauch. Spiräen 23.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06f81a9c-3ef6-5b90-a3b5-576763ce4422','','','Nuytsia 3:63.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28266407-39b4-596d-9922-9e74dd4076fd','','','Opusc. Bot. Pharm. Complut. 5:82.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ad0db38-38be-5674-9337-5894216b0bd2','','','F. A. Wislizenus, Mem. tour N. Mexico 107.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d608943b-26fa-5de6-a3a9-7d70a0430c7e','','','Char. gen. pl. 70, t. 35.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47451726-bb47-59a5-bcfa-b083076f0304','','','Fl. South. U.S. ed. 3:425.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ce601ca-20ee-5ab4-94f8-5cd9ed90057d','','','V. L. Komarov, Fl. URSS 2:311.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3f196bd-e645-594e-8e13-0a1c07c0b818','','','Abh. Naturwiss. Verein Bremen 24:410.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e4abd64-45a4-5a48-a14c-933c1506ab3c','','','Leafl. Bot. Observ. Crit. 2:141.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c308f1b3-030c-5f80-97e5-b94b77f92670','','','Fl. carol.  219.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb323954-b297-5c0f-8dde-02a051aa5801','','','Arch. Bot. Mém. 7:111.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f872f49e-fee8-54e0-8fee-b3625818d9e0','','','Bull. Soc. Imp. Naturalistes Moscou 15(3):508.  1842 May 23 (Enum. pl. desert. Songor.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d9c50e3-b932-5f81-9150-c5f37528f340','','','A. L. P. P. de Candolle, Prodr. 16(2.2):657.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12452b98-e150-5121-8519-2c54d120dfc9','','','Taxon 33:727.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0026e91a-a943-5382-904d-326060575b50','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 18:146.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('625b67af-5c86-514d-b4cc-eaca7338ac8f','','','Lingnan Sci. J. 11:16.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8553d46-69e0-5053-990c-640dab38b6f4','','','Notizbl. Bot. Gart. Berlin-Dahlem 8:370.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05eae7b2-55a6-51e9-a035-993756337242','','','Proc. Amer. Acad. Arts 9:202.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2dd1ddb6-25d2-5a8b-8af1-03f871d47220','','','Taxon 64:1201.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09f66412-167f-5e48-ac09-1a32ca2d1d2b','','','Sp. pl. 2:732.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e31634e7-d9bb-5125-bcf6-99b148ca9169','','','Austral. Syst Bot. 13:46.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b2517c2-70ab-5abd-9979-0263d5642077','','','Bot. Mag. (Tokyo) 48:779.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f30794fb-d0b3-5771-91f1-64e2be519b91','','','Fl. nov.-zel. 2:329.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abd89cb3-66ec-5798-a977-8e3db1dc9f5e','','','Willdenowia 34:362.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7580c18d-d044-57da-9f40-0ef94511b06b','','','Taxon 66:1165.  2017 "<I>hispanicum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2cbcbde-6186-58ae-912d-402f82def64b','','','Linnaea 26:370.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27e7e1fb-7156-5519-82af-327a4c79d707','','','Cat. graines jard. bot. Grenoble 24.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d07aacd-1668-5cc6-9d02-fe11254f9d08','','','Sp. pl. 1:278.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d41f88b-2ace-52a5-9e5d-d839198f0485','','','Novosti Sist. Vyssh. Rast. 8:66.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('223205cc-84e7-5b35-a916-2806d1127874','','','Ann. Fl. Pomone 1837-1838:40.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8243a435-02a8-5a59-b55f-42e02e5e1e27','','','Enum. pl. 1:345.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b89c4312-efa7-5cdb-ad0f-0b44076a0617','','','H. L. Duhamel du Monceau, Traité arbr. arbust. nouv. ed., 7:76.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c643cd4-13be-5b0d-adb1-682f565d0633','','','Hort. kew. 2:193.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8e28a66-948a-5204-ab34-b763d6c219a3','','','J. Linn. Soc., Bot. 11:105.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61e17c98-8d6d-54cc-9a32-970c2d2c36c0','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 29:217; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 11:860.  1883 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89f806c1-dcf9-5a6a-b8f7-79c0e8371a0e','','','Rhodora 62:342.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58907ad4-6b97-536a-bf56-44327546e2c1','','','A. Gray, Manual ed. 6:146.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa8b3a8a-a5c8-5ec7-a572-2bb08853aa44','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1873:55.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f996e61-567f-5221-b3b8-1f89dd1a4e86','','','Pl. wright. 2:82.  1853 (Smithsonian Contr. Knowl. 5, Art. 6)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cbf3094-ebcf-52bd-952c-50566202fd36','','','Bull. Jard. Bot. État Bruxelles 25:95.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3150728-3c53-5bb7-a49b-95fbd51a545e','','','Enum. pl. 1:527.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f87411a-8f20-5e22-bd78-d94c6be297c9','','','Expos. fam. nat. pl. 2:184.  1805 (non Herrm. 1762)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae11d606-eba7-5e23-9246-7e1718895180','','','Muhlenbergia 1:7.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6650cd45-2051-52bd-ba64-7c569d76a5ed','','','S. African J. Bot. 62:61.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1fb40aa-03a2-5a08-9b3f-903766e63341','','','Nouv. not. fl. France 13.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('808a019c-24b7-57db-9b2f-16e5a7e62a33','','','Ann. Missouri Bot. Gard. 82:454.  1995, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('466a640f-360e-5402-aee3-26df7ad24e27','','','Contr. U.S. Natl. Herb. 16:100.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb917f01-7873-51dc-9093-06078e76dcb2','','','Edinburgh Philos. J. 9:263.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca8210e4-d4c8-529a-b766-603cde966c48','','','Hist. nat. palm. 3:292, t. 166.  1845 (A. D. d''Orbigny, Voy. Amérique mér. 7(3). Palmiers 133.  1847)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('354370f8-d482-530f-9121-23b3c0cac799','','','Quinol. Ind. Pl. 84.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('312a2646-e903-524b-8f48-09fdc2ccb3af','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. ed. 2, 19b1:119.  1940 "<I>trifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c71f4c71-48dd-51a1-b946-2fabbdf7983a','','','Cact. Succ. J. (Los Angeles) 78:94.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93bada73-cab8-5b15-84d9-00d5c67e4c0b','','','Phytoneuron 2012-39:23.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34de9d71-3fff-5a41-9ab0-a2ddc36a685f','','','Compositae Newslett. 47:36.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28f8145d-f80d-52ef-bac9-ca6304c9c3b0','','','Stirp. nov. 73, t. 36.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0423fe1d-83cb-560d-9c20-d0c0ab962924','','','Gard. Chron. ser. 3, 5:648.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e23b741-9980-50ca-9b4a-68ecac9a8695','','','Gard. dict. ed. 8: <I>Helianthemum</I> no. 23.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe457eb4-e012-5a36-94bc-b2cf3d78a277','','','J. Linn. Soc., Bot. 37:330.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4bc654d-0fec-56d3-bc0f-b6303e3334d9','','','Blumea 16:1-82.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbcb1810-0ed8-58e3-8905-b17ba80d6532','','','Gard. Chron. 1849:580.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a833521a-b3e3-5bbf-b284-bf97dbfe3a2c','','','Bot. Beechey Voy. 175.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed0a5514-769d-54b3-9f2f-790764d51868','','','Hamburger Garten- Blumenzeitung 21:256.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b504a50-52db-5c87-bc33-69b4d8a760b6','','','Ann. Missouri Bot. Gard. 78:388.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22811f6c-e4dc-5b94-bf0b-c0a03bd60d5d','','','Ann. Bot. (König & Sims) 1:505.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c22a96d6-5faf-5531-ae87-1fc2593954b1','','','Notes Bot. Gard. Edinburgh 25:186.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2160a28-e4f1-55fb-a6bf-f46ec402b7f2','','','Syn. mitteleur. Fl. 6(2):725.  1909 (non Steudel 1840)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92dc3dd6-c551-525a-b496-2a0beeffd56f','','','J. Linn. Soc., Bot. 29:392.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccc77361-a458-505b-a156-b1eb110c2350','','','Tabl. encycl. 1:465.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80f25f61-95ef-5f1e-8b5b-b78dda1042c0','','','Bull. Bur. Pl. Industr. U.S.D.A. 282:68.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c04015c-10a4-5656-8c53-e849a13c0fda','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 12:116.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf6c7135-6363-5c56-a84f-6e5d18811ad9','','','J. Torrey in W. H. Emory, Rep. U.S. Mex. bound. 2(1):188.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cf94301-74e5-544f-8766-43ad00364987','','','Bull. Sci. Soc. Philom. Paris 1817:183.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d29ba4af-8955-52ac-9bf3-0bfec6d02a65','','','Icon. descr. pl. 11, t. 6.  1766','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d005e8cc-efe4-569e-84f5-0c6fe4a7ab84','','','Gard. Chron. ser. 2, 20:404.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed1a6a0f-9e63-5ac3-a717-2c629699c000','','','Mém. Mus. Hist. Nat. 18:30.  1829 (non Noronha 1790)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb145dbe-ee8e-5425-b8f5-ff8bdee42163','','','J. Arnold Arbor. 3:27.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48f9527e-8be4-55f3-805d-8c377be4e31c','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 8:218.  1886 (Pl. david. 2:35.  1888)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('050bb3de-280f-5354-9204-a24a8243165f','','','Diagn. pl. orient. ser. 1, 2:48.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa252812-7dd2-5944-b4b1-4e004cdcbf52','','','Aliso 4:90.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80fe5aef-dde9-53e9-b920-8c7d1acc7f5a','','','Hort. bogor. descr. 342.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1280774f-c42c-562a-9237-ef80318f75df','','','Trans. Linn. Soc. London 10:203.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16b226ce-8a31-5637-b709-afcac2b8dd29','','','Revis. gen. pl. 1:266.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('135b020c-b9a4-51b8-b8b5-c2f5b268a08f','','','Ill. Ind. Bot. 1:144, t. 53.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4929c76-2d05-5cb8-870a-1322066a39a7','','','A. Grandidier, Hist. phys. Madagascar 35(tome 5, Atlas 3): t. 170A.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c72d73f-488f-50f0-8f63-d64de040c056','','','Austral. Syst. Bot. 8:1201.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4866398-983a-54a7-ba66-ef0753151526','','','Hooker''s J. Bot. Kew Gard. Misc. 8:357.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fcf2c0c-f528-578e-a2f2-5e42f2203f68','','','Ann. Missouri Bot. Gard. 37:209.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85839c9f-5732-598d-97ed-7ed8d6afeb97','','','Fam. nat. syn. monogr. 1:99.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9179e2df-e393-5fb7-aec4-6ee19a197fb1','','','Ann. Roy. Bot. Gard. (Calcutta) 1:39, t. 45.  1887 (Sp. <I>Ficus</I>)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c692fb63-ef66-545b-bb9b-04c0a5224b50','','','Sp. pl. 3(3):2207.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5513db5-b2ef-5e87-af5e-60e6048beae7','','','Prodr. fl. nepal. 36.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9310ef0e-8f10-5d3e-b396-83b9f677b6af','','','V. L. Komarov, Fl. URSS 11:251.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f019688-a9fa-5e89-98c5-c24c342e4595','','','Izv. Tomsk. Gosud. Univ. 81:452.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('713270a6-42e7-5f61-b7e9-a650ececcc44','','','Trans. Linn. Soc. London, Bot. 1:74.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0b4b826-01dc-5955-ba3e-216e29487c66','','','Sida 21:1645.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82744c16-55dd-5a0d-ae9d-a87619ed57ec','','','Ann. Missouri Bot. Gard. 68:473.  1982 ("1981")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22624494-2010-51cd-9991-007b818150b9','','','Bull. Jard. Bot. État Bruxelles 23:373, fig. 36, 37.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48af3e10-9712-574e-899f-b379537345d1','','','J. Hutchinson in J. B. Stevenson, Sp. Rhodod. 166.  1930 (Notes Roy. Bot. Gard. Edinburgh 16:173.  1931)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e76fbae-1628-5025-bdf0-32569809e36e','','','Syst. veg. 1:959.  1824 ("1825")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3360ab9b-1110-5f45-bea7-3b5c038c496e','','','Kew Bull. 26:579.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('726e8a61-8cc1-503e-be03-a43c2d750dc7','','','S. Watson et al., Botany [fortieth parallel] 71.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e114c6c5-1378-56fb-9411-d8e6fc97b021','','','J. Torrey & A. Gray, Fl. N. Amer. 1:560.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c808a63-66b3-5c85-9a23-3fbe852f427e','','','Handb. angew. Bot. 2:447.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb804266-edee-50ba-8d8b-1b7f62e98cff','','','Proc. Amer. Acad. Arts 21:428.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d3bd33e-32ea-5b77-9bfc-da83433d2e3f','','','J. Bot. 61: (suppl.) 53.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fab8d2b2-5675-5430-8d9e-296f5e1e99ed','','','Revis. gen. pl. 2:787.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b109e94-a0c4-5935-bc7e-293dd2262a6a','','','Pl. Life (Stanford) 7:42.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f71ddda-0e86-5124-a44c-fdd5fae23118','','','Diagn. pl. orient. ser. 2, 2:55.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08e22b9e-f6b7-57a8-8ff3-56983d7b326a','','','Spec. bot. New Holland 13, t. 4.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f242d34e-67a2-53f8-850c-57f8cca89626','','','Bull. Misc. Inform. Kew 1926:201.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88702e65-acdf-5e89-ae77-3efe70d2c9ea','','','A. T. Middendorff, Reise Sibir. 1, 2(3):77.  1856 (Fl. ochot. phan.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('832046d3-beff-58c5-a535-78f8c3ee474e','','','Revis. gen. pl. 1:205.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47b3b5b6-fee2-5fd1-a965-31b919768a22','','','Trans. Roy. Soc. South Australia 95:231, fig. 6.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62dab3d2-b503-537c-87a6-34ce6a9a411c','','','Orchidaceae 1:98.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad612814-e3a2-52f9-9690-b3a1220be70a','','','Bull. Sci. Soc. Philom. Paris 1822:44.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89bd607d-60c6-5b6d-8294-bb3e6002004b','','','Bijdr. 558.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7319793-1b8f-5f95-a5c3-9fb12ae88405','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 13(2):173,219.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56708c6c-38b1-5d6e-92c0-0190a7f02e85','','','Bol. Soc. Peruana Bot. 7:15.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c919910-1db2-54cb-84d2-7400de1b768e','','','Symb. antill. 5:398.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('175c2796-619a-5127-9c1d-fbbd8534e56c','','','Bot. Gaz. 19:319.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdda8e89-8df8-5554-a856-c34f2e0ca20f','','','Int. J. Pl. Sci. 158:872.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b70900f4-3d52-560c-b78f-f43621d2e134','','','<I>Oxalis</I> 9.  1781 (Linnaeus f., Suppl. pl. 243.  1782 ("1781"))','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96934f1c-e7b1-52dd-ab31-b75525ffde6b','','','Bot. Jahrb. Syst. 54(Beibl. 119):49.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ab395ee-d8df-5a27-8e64-5cbb50ba2101','','','Rev. Hort. (Paris) 1860:363.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18308e71-5f7d-5a92-9152-d52b9ccdf87f','','','Biblioth. Universelle Genève sér. 3, 13:409.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d31af9a9-f234-5171-8319-1249edccb6d3','','','Mem. Torrey Bot. Club 4:366.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3d67b17-4fae-5fad-901d-ab8081cbfa68','','','Amer. J. Sci. ser. 4, 17:312.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a646800-7cc1-5048-819a-b6b9afc13bda','','','Trudy Prikl. Bot. Selekts.13(1):175.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c7b8d47-14ab-599d-8d36-330b9f76b5bd','','','Tent. fl. abyss. 1:224.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c388a571-639a-5c65-b260-8e3bc60499b6','','','Philipp. J. Sci., C 10:277.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c921b7dd-065f-51b7-9edd-4c5ddf5ab9cf','','','Fl. austral. 3:436.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('891cfde6-8ee6-51bc-a22d-b9420b7af249','','','J. D. Hooker, Fl. Brit. India 1:547.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9fcce21-ca03-519c-99b3-16ee2560919e','','','J. Linn. Soc., Bot. 45:432.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e95c0fe-308a-551e-8366-8aa7fa9aff2e','','','Sp. gram. stipac. 79.  1842 (Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 7,5(1-2):79.  1843)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97a4ca5c-d884-5cc3-bd7c-22d7c85a9817','','','Encycl. 1:695.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cba56266-2f5c-59ec-b76c-c0a524a52bda','','','Bot. Mag. 51: t. 2477.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57fb5b42-6ff5-5213-9463-c8ca0c28a5c7','','','Ann. Sci. Nat., Bot. sér. 3, 19:252.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('896d0073-1008-5985-9c7d-b9185a3231ea','','','J. J. Roemer & J. A. Schultes, Syst. veg. 3:531.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('509647c5-b5d1-5390-853c-94944941daee','','','Fragm. 1:50.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed0f4e2d-ff02-5167-a8b4-2fb214f49528','','','Bonplandia 7:26.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94a4f3eb-f18a-5db9-bfe7-abba4b3b3c00','','','Syll. fl. Eur., suppl. 73.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41befd42-bda9-56f2-b383-d53f793d1fad','','','Bull. Misc. Inform. Kew 1913:43.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a7f168c-bb74-5a39-a694-672d9a127ac1','','','Bot. J. Linn. Soc. 85:66.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c58bb87-a990-5496-9aab-d8bd43003db8','','','Bull. Torrey Bot. Club 29:238.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2041de17-9b87-5639-9691-ab3c94596326','','','Sida 21:213.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf86607c-5e57-5e9b-8813-390f8a896c46','','','Hooker''s J. Bot. Kew Gard. Misc. 4:271.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('855a7326-8eaf-5b52-b558-5bf49a94975d','','','Bull. Soc. Bot. France 75:710.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba4fd6a2-031a-5d72-ad61-0382e4939c93','','','Encycl. 7:128.  1806 "<I>Sesban</I>" (C. Persoon, Syn. pl. 2(2):316.  1807)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d05733b3-0f93-50e9-82e2-634ef4a593f4','','','Ill. pl. 34, t. 26.  1803-1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74e076fd-29bb-58f2-8053-a83ef8920e17','','','Bull. Torrey Bot. Club 23:128.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9e41aca-f2bc-581a-9ced-783eb0c88ea8','','','Bot. Jahrb. Syst. 50:377.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4f5f2f9-f2b8-5582-9bed-e689574edb79','','','Fl. taur.-caucas. 1:324.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa8208cf-2238-5d59-8b12-300f9adc8d26','','','Biblioth. Bot. 22(Heft 89):270(824).  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4ed2c0f-89c0-5618-86a9-10e1fc24e8d5','','','J. Straits Branch Roy. Asiat. Soc. 86:330.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6953ae87-684c-5bfd-9446-5785dbf86ea8','','','Bot. Mag. (Tokyo) 16:16.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6df5350-3a6a-579c-acea-002a618a0210','','','Bot. Jahrb. Syst. 29:503.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecf2dff7-08b2-5cc0-8034-1cb0470ede15','','','Acta Phytotax. Geobot. 22:128.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76dd28fd-f578-59a9-a7b6-c1e784bb6c31','','','Proc. Biol. Soc. Washington 16:127.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d922ae7e-3143-5fbf-a3f7-b1f7e9e5f9a1','','','Arch. Biontol. 2:411.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a31c908-2185-54de-ba53-482476ec6760','','','Ann. Sci. Phys. Nat. Lyon 38.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcb37035-3d0b-5ea1-aedf-f448138f0f67','','','Indian Forester 36:346.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39ac5d81-b348-5e04-ae15-181e417a6909','','','C. F. Schumacher, Beskr. Guin. pl. 289.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79742c65-49b0-544a-8598-a9516fec51f0','','','Linnaea 11:182.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('511d72a9-9ae0-5fbb-b9c7-f78ecef79021','','','Hort. brit. ed. 1:223.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15050a15-febb-5988-900d-ed1d22f20ec4','','','Mem. Inst. Roy. Colon. Belge, Sect. Sci. Nat. (4to) 1(6):41, figs. 4, G-M.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30c556b8-5142-5f27-8fe5-4271c7d56835','','','Magyar Bot. Lapok 1:341.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8c074c0-f707-5745-aa9f-a108c861adff','','','Acta Bot. Mex. 95:81.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('871674ca-7378-5917-82af-81729bf2c822','','','Observ. pl. nouv. 6:17.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf8fbd2c-2adf-592c-ac14-a8b1a6539339','','','Nov. pl. sp. 261.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d79cec5-4faa-5b10-9b8c-aacad2a75f3a','','','Anales Soc. Ci. Argent. 5:209; Contr. fl. Paraguay 59.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3129f56e-b751-5399-9369-04c52b0764f9','','','Madroño 35:347.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6319ef6c-4bf8-5600-b604-29c46682d318','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 12:61.  1867 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d9acc90-faed-5e0b-83d8-dc5275964bab','','','J. Arnold Arbor. 54:441.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d74e3c07-6d88-56de-ac8f-d12239b7aa28','','','Hist. nat. orangers 91, t. 40.  1819 "<I>volcameriana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('286d3e87-7651-51e3-9a0b-34c67d2a08c9','','','Deutschl. Fl. ed. 3, 1:864.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32db57a6-39d6-554c-83ad-f16482c5863e','','','Cact. Succ. J. (Los Angeles) 35:167.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4474fc63-1991-59ff-9025-bbfe33b0874b','','','Hooker''s Icon. Pl. 15: t. 1441.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54b56dfe-7548-5a5b-ae55-2cdfdd6f6507','','','Gen. hist. 3:490.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb1bc959-5c8c-5f14-823b-125bd28b8cbe','','','Nov. Holl. pl. 1:65, t. 90.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8887c974-3a84-53b1-aa5d-0e9a3fe0483d','','','Bull. Torrey Bot. Club 51:149.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('134e17d3-4eef-5488-9440-b8b9b93b29c2','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 15:380.  1870 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a390162c-c461-51b8-92d6-245805127551','','','Bull. Soc. Imp. Naturalistes Moscou 36(1,2):610.  1863 "<I>Blackwellia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0dc12937-4e26-596f-88d6-f920d047ec74','','','Manual ed. 2:252.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13f4a13e-0a78-503e-8a00-996436de3b1e','','','Bot. Not. 1950:31.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27f156ac-c97d-5fcd-8000-08214b3ffb3b','','','Bibl. cult. trees 342.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5862faab-6941-5471-b76a-a5c684600fbd','','','Mem. Torrey Bot. Club 23(1):63.  1973 ("1972")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f05870ae-3910-5847-95b1-4f1783c04555','','','Pl. bras. icon. descr. 1:2, t. 1.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69216982-d3cd-5b40-b51c-3655cca52770','','','Syll. fl. Eur. 298.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9fbb614-bcbe-5021-9f03-f7e74c79d8e4','','','Acaul. blue violets N. Amer. 42.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cc31939-f914-5be6-8482-1ec5062b43a0','','','W. T. Thiselton-Dyer, Fl. cap. 7:495.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ad385a2-c927-5899-9961-338a459fdcfd','','','Spaeth, Kat. 104:94.  1899 (W. J. Bean, Trees shrubs hardy Brit. Isles 1:558.  1914)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6773a62e-b32d-5cbc-8312-1c81623fdd6d','','','Wiener Ill. Gart.-Zeitung 19:51.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b73efa1-aba3-5244-bef3-e9957a03b313','','','Encycl. suppl. 1:741.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5647722-de2c-5d52-b683-454ecb24d991','','','Fl. reipubl. popularis sin. 67(2):402.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7621caf0-31b2-5f1a-a211-aae753aedfd0','','','A. A. Orlov, Kulturnaya Fl. SSSR 2:210.  1936, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0775d766-75b3-5e29-a97b-3dfb8e3cc06a','','','Fl. norveg. 2:101.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdc7e270-c0c4-5558-a07f-f047655318b9','','','Repert. Spec. Nov. Regni Veg. 12:401.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6d64fc8-c26a-59f3-94ce-6c7f7eb27055','','','Hist. pl. Guiane 1:296, t. 116.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44e5f965-e69e-5e53-a4b0-29f39b4ae0cd','','','Fl. antarct. 98.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9170106f-6ad2-5489-aecc-0de01a76d2e5','','','Symb. bot. 3:42.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f10ccb67-f715-5524-ad3f-afa03b417c73','','','Anales Ci. Nat. 4:63.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75292e58-a21f-580b-b91f-3f60dc4b4771','','','Bull. Soc. Bot. France 4:16.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0eb8695e-0a71-5675-902e-382342c478f5','','','New Phytol. 46:135.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b74c39e3-6485-53f8-82c8-bf5b3760b2ef','','','I. M. Johnston, Contr. Gray Herb. 70:66.  1924 (pro sp.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbc29966-aee9-5abb-bba7-5140fd93ef1b','','','Grasses of north-eastern India 125.  1996 (Bor, Grasses of Burma, Ceylon, India, & Pakistan 212.  1960, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b49fa88-1cba-5660-affc-9eabe8c07e7b','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:132[folio]; 2:166[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d15a08f-b4b9-5346-8541-54ea86a2ffd5','','','J. Linn. Soc., Bot. 2:23.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a41d13fb-cd41-565c-8440-1f14c2cbe4a0','','','Fl. s.e. U.S. 218.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6b60dba-2f91-5ca9-9fdc-63ddee9c6e93','','','Prodr. 2:62.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f13f74f6-3aee-5197-ae85-e7006deef64b','','','J. Arnold Arbor. 20:100.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de465d0d-4240-5367-b520-0858ec67fd74','','','Fl. Brit. India 6:273.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21540bb5-e698-5d85-8e00-dd0433c13df0','','','Bot. Bull. Acad. Sin. ser. 2, 35:135.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42e1d25d-095b-5468-8b65-513193b5684c','','','Rec. Albany Mus. 4:104.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2293937a-1150-51d9-b137-c641693ad52e','','','Phytologia 47:259.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63d56cc7-3baf-5fdd-a056-386e2f0c884e','','','Vasc. pl. San Luis Obispo 245.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4e7d777-b39e-53b1-877f-2cd05d9ef336','','','Bull. Soc. Bot. France 54:164.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc96f06e-da8a-524b-8d36-57a4e7933375','','','Fl. angl. 42.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c85f1f1-12a2-52a7-91d8-40249ce84f2a','','','Repert. Spec. Nov. Regni Veg. 41:203.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31e6c738-1aa8-5909-b60b-ae31f5f1d8e8','','','Bot. Beechey Voy. 281.  1838 "<I>drummondi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09a8794a-5d98-5375-acd3-bc5512af96ed','','','Rhodora 19(220):76.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b707318e-ce63-5f7c-a2f8-4165fa665b99','','','Stirp. austr. fasc. 2:97.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1c4862b-4444-5fc8-a877-7216b3267a67','','','Phytologia 60:77.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('154e8c13-02ae-5c07-9f9c-c8461d13ea2f','','','Bot. Mag. 163: sub t. 9606.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91007e29-8e5b-5743-9850-045ffab2827b','','','Brittonia 31:454.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e361012-463d-5f00-8e0c-9cbcc0351f2f','','','Bot. Jahrb. Syst. 48:347.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ed61397-a19b-5945-8f46-f996e4fdd7d8','','','Ann. Sci. Nat. (Paris) 25:11, t. 3, fig. 1.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecb8646a-b959-57f4-acfe-e1084a397b1b','','','S. L. Endlicher & E. Fenzl, Nov. stirp. dec. 7:60.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43878cb1-bc28-562e-9325-5000506625a5','','','Monog. Abietin. Japan. Reich.49, t. 3.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a168d981-ca36-5b31-a1ac-74a8ad5672ac','','','Bull. Soc. Bot. France 9:171.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c4809bf-9504-5770-bf3e-ed97e66f1307','','','Fl. lusat. 1:154, 184.  1839 (non L. 1767)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78fb6c38-1940-5660-b773-e1d1991ec3b0','','','Fl. carol. 104.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8fc535e-3d1c-5a1e-86c2-a79bada71fee','','','Bot. Jahrb. Syst. 28:426.  1901 "<I>pallide-rosea</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cd227c0-3372-55c4-a01a-24966becfed0','','','J. S. African Bot. 25:371.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a509c33-6828-5bdc-9854-f6b671d736ad','','','Bot. Mag. 50: t. 2413.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c68d9cb-4c3a-5e99-a462-c8aa121b548c','','','Ann. Mus. Bot. Lugduno-Batavi 3:102.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa70dcc1-8038-58d6-aced-a22c0bae389c','','','Blumea 18:367.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee500ce0-963f-5fd9-b80b-618d23c70859','','','Fl. N. Amer. 2(3):485.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55a4e972-0399-590d-8b3c-96fa431cdae1','','','Phytologia 2:475.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4712e153-488e-5076-ad19-c1870b4da825','','','Bull. Bot. Res., Harbin 9(3):71.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f3dbb1b-b3ae-574e-a515-56428b2b70ab','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:13[folio].  1821; 5:16[quarto].  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e770db09-9a77-58be-8333-9e913cc383f8','','','Nova Acta Regiae Soc. Sci. Upsal. ser. 3, 2:245.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26b624d4-1e41-52d4-9855-aec7655bd561','','','Fl. orient. 4:999.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cd2f1b9-6003-5c61-aaef-b7fb72ca0b02','','','Cact. 3:129.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb33d4d5-ae3b-5724-a02e-248f1d499f7d','','','Sel. pl. Galic. 15.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bda71955-f727-5e25-8553-01c71861c41d','','','C. F. P. von Martius, Fl. bras. 13(2):452.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91bb322b-a14c-51d2-943b-2050c226937b','','','Rhodora 93:112.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('836066de-20c9-5d6d-bd15-492924eaff5f','','','Bol. Técn. Inst. Agron. N. 2:20.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14d1ade1-b109-5f30-a12b-2c3712d118a5','','','Notizbl. Bot. Gart. Berlin-Dahlem 11:681.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('078540d4-8e10-57c8-8e30-88c2355c25fc','','','Icon. pl. rar. 2:9, t. 306.  1795 ("1786-1793"); Collectanea 5:35.  1797 ("1796")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ee5f802-644c-5da9-9042-c73092db62b7','','','Mem. Amer. Acad. Arts ser. 2, 4:52.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae457a7b-8ec8-5bcc-9bd6-39f7d6d5cfa9','','','Amer. J. Bot. 27:544.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ce28c90-a3e6-5743-874c-31bf1cdb070d','','','Edwards''s Bot. Reg. 28: sub t. 45.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f143d4dd-9091-5fe2-9e2a-4bc0e810f97b','','','Enum. pl. 3:71.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45ddfd02-7dd2-5cc8-aa60-66625cb7f3f0','','','Chlor. andina 1:69.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2602a74c-e71a-5d5d-a6cb-0045595f5729','','','Allertonia 5:148.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcad8560-bf5a-5f7d-8911-9e280785a2c9','','','Repert. Spec. Nov. Regni Veg. 41:197.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d96d5edd-4278-5ee6-b0c1-202c431fd609','','','C. L. Hitchcock et al., Univ. Washington Publ. Biol. 17(5):207.  1955 (Vasc. pl. Pacif. N.W.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7395674-152c-580b-ad64-013fe690b52c','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:77[folio]; 6:97[quarto].  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42369d7c-c60f-56b4-b0be-6d29e6449a37','','','E. H. F. Meyer & J. F. Drège, Comm. pl. Afr. austr. 115.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dead6a28-7576-5854-8623-239f5ec4bafb','','','Z. Naturwiss. 63:124.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6aa411b-ced2-53f5-b612-e9d008304b22','','','Nordic J. Bot. 16:38.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50433cc2-8667-54af-ab2d-ab7e315fec17','','','Linnaea 12:363.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04f0bc86-736b-562c-b13e-ece37f5a0f5d','','','A. L. P. P. de Candolle, Prodr. 11:625.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9a34c34-3094-505f-abb2-47c08986a849','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 7:55[folio]; 7:70[quarto], t. 614.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e31fec67-cb58-5cdb-85ec-e8b36d91fa54','','','Beih. Bot. Centralbl., Abt. 2, 28:226.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15c476e6-efa9-54b4-bbac-fd8eb79bff76','','','J. S. African Bot. 41:12.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe26e5a2-459d-52ff-b8e7-f918e24c32d1','','','Liliac. 1: t. 38.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1da19308-c113-5b74-9767-d973c226e179','','','Bot. Mag. (Tokyo) 11:332.  1897 (Bot. Mag. (Tokyo) 6:50.  1892, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e1efde1-a94a-5ccd-b7bf-b95ca8fd9abb','','','Fl. angl. 49.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acbde7ba-6a4a-5c07-878d-b3f981d788f9','','','Linnaea 36:571.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd471160-c130-5839-acb1-4547662ac7c4','','','Repert. Spec. Nov. Regni Veg. 11:431.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b9a8433-5662-55e6-aedc-15461d465f92','','','Biltmore Bot. Stud. 1:7.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('666f166f-6483-5f3d-8459-eeeb5a97d366','','','Proc. Amer. Acad. Arts 13:370.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a97f538-84de-5dad-ba20-91fa9206f7ec','','','Mem. New York Bot. Gard. 65:126.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7c317fc-cbb3-5f06-a030-a4babefc01cb','','','Eur. J. Taxon. 69:6.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2b23bef-efa2-57e3-9f80-2891df6ad916','','','Fl. cochinch. 1:206.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8393cca7-2a56-5a36-b155-2c0cb67ef1cb','','','Fl. trop. E. Afr., Nymphaeaceae 10.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15ae405c-0779-560d-8c3c-556387f8b19b','','','Opera Bot. 8(1):117.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('393b3ae9-f8d0-5d13-ace5-d5f9c6ae46fc','','','Fl. bor.-amer. 1:192.  1803 (non Balb. 1801)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9024910-aabb-5a06-b85b-4db6b0b65ba5','','','Syn. fl. N. Amer. 2(1):85.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40f516d8-adff-5616-a653-2d991f83abff','','','Aliso 3:237.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66e1c6af-88a3-5342-b051-76f0272cb38e','','','J. R. Harlan et al., Crop Sci. (Madison) 10:291.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e610ef1a-b0bf-5b70-9e38-8e48daa4dcd8','','','Phytologia 2:148.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('997be322-c903-5d31-a505-95be34811850','','','Pl. Syst. Evol. 151:292.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c79eb1d-4e8f-565e-bbc7-d54722be3cf1','','','F. Cuvier, Dict. sci. nat. 37:491.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c29e2376-c212-521f-b85f-818e85fcaf27','','','Philipp. J. Sci., C 9:149.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17d93e26-0f32-51d0-9205-21d79c21a572','','','Bot. Mag. (Tokyo) 36:37.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('269936e1-0f5b-525a-acb2-6ba30506ac3b','','','Bononiensi Sci. Inst. Acad. Comment. 6(Opusc.):17.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6503b22-029b-5995-814d-1647dc54a642','','','Fl. Ned. Ind., Eerste bijv. 489.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33808bb7-8939-5aba-8219-bb0498b7fd74','','','Welsh botanology 1:49.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ebc167a-0952-5aeb-9844-af1676ae7d16','','','Izv. Akad. Nauk Tadzhiksk. S.S.R., Otd. Biol. Nauk 1(125):51.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19f089e2-ef1f-558c-bee3-aae8b238747d','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:193.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bea9bd8-e3b3-511d-8cdb-25d23c9970b1','','','Fl. cochinch. 2:618.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('099044ff-ed39-5b36-a7ec-21a2377a3ec9','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1853:101.  1854 (Nov. pl. mexic.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('973476a0-a5c2-5e41-bcee-7195d08c22be','','','Cent. pl. II:13.  1756 (Amoen. acad. 4:310.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6187b23-ab66-5262-90f6-0e107e52c1ac','','','Bull. Alpine Gard. Soc. Gr. Brit. 66:380.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4b33206-79ab-5e97-8ef7-be9431827daf','','','Opera Bot. 9(1):280, 130.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('784dbaf9-65d7-5cd5-8503-a48ec3c8669f','','','Acta Phytotax. Sin. 16(3):56.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0554d9b7-e877-5296-aadb-267f5b0d5c42','','','Grass. N. Amer. 2:229.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('974cee6f-dd99-5731-889f-f3470252938e','','','Notizbl. Königl. Bot. Gart. Berlin 1:266.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b32dad32-fcf9-59f3-86f4-3ada63e2534c','','','Suppl. pl. 213.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3f56ce5-3e82-50c2-afa2-785ce3d4f23b','','','Syn. Aroid. 89.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0eb264a9-11b2-5105-a6a8-2cb4894a8947','','','V. Jacquemont, Voy. Inde 4(Bot.):75, t. 84.  1835-1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b038329-e35d-597b-9f43-2af7b24823fa','','','Prodr. fl. monast. westphal. 222.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9303ca6c-3b6f-5e0b-ad7f-4b1d2cfc9bb2','','','Philipp. J. Sci., C 9:324.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('188de2a1-1fee-5527-8282-f3f2fbe6e05e','','','Fl. taur.-caucas. 2:208.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f883b32-bbf5-507d-9685-a5e1539301d5','','','J. Straits Branch Roy. Asiat. Soc. 46:257.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5741e928-5033-5aac-b9d7-748fec44f232','','','Pl. bras. icon. descr. 1:28, t. 22.  1826 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fd4b5b5-691a-5bce-a354-25a675989127','','','J. Bot. 71:343.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9036d5a9-215f-56e9-9b1a-35b677952f65','','','A. L. P. P. de Candolle, Prodr. 15(2):62.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc099bda-0eec-5d79-b442-8186ab9d8578','','','R. de la Sagra, Hist. fis. Cuba, Bot. 10:176.  1845; Hist. phys. Cuba, Bot. Pl. vasc. 414.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82a8fa97-afd2-5a95-be7d-84c1b8daeb06','','','Adansonia 6:222.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf2ee8ff-956c-5e17-8dea-a2c8edd2d054','','','Sp. pl. 1(2):1267.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab78b7f4-787d-50b5-9b66-2401827ed62d','','','Bull. Mens. Soc. Linn. Paris 2:1193.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e704d89-ee56-5276-94fc-1bd247299811','','','Crit. revis. Eucalyptus 1:96.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc934eec-11c6-5267-afee-dc9ab3c23f53','','','Sp. pl. 4(2):1025.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79152f35-8686-54b6-8e81-aec14a7fb663','','','Trans. Linn. Soc. London 8:340.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a608763a-91e0-5b3f-a581-30da8b7235c3','','','Bot. Mag. 56: t. 2919.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e038a2bc-f718-543f-b4c0-acf34e77c5cc','','','Repert. Spec. Nov. Regni Veg. 24:297.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa581e42-2df0-5097-a43b-5cfc17e76637','','','Ann. Sci. Nat., Bot. sér. 2, 2:289.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('783bf3fc-b2c1-5dab-ae87-8311b591fc92','','','Bot. Mag, 69: t. 4009.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fdf792c-dd6f-5499-9a71-67926bf3c5fb','','','Bot. Jahrb. Syst. 70:122.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3b307e8-c506-5aeb-800b-0bcf078a1156','','','P. E. Boissier, Diagn. pl. orient. ser. 1, 13:70.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4226cf43-6e90-5c7f-a837-0f13e8518016','','','Trudy Moskovsk. Sel''skohoz. Akad. 6(Selekts.):9.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('926f6c2a-63d4-5c96-95a9-4db1a279c511','','','Sunyatsenia 7:14.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bc9b62a-500b-54a4-bac6-e58a3066adc0','','','Svensk Bot. Tidskr. 18:428.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bb45dc6-546b-596c-9c8f-7e37a91c6fa3','','','Acta Univ. Agric. Bor.-Occid. 23(5):121.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ceab6a97-6473-556e-8aa3-951c7fab1c83','','','J. Hutchinson & J. M. Dalziel, Fl. W. trop. Afr. 2:387.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f283eeab-a8c3-5dd0-9f56-4ce38cb04927','','','Notes Roy. Bot. Gard. Edinburgh 11:71.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d845d190-934b-54e1-913b-004345e57e2e','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1903:165.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c609a1f-196b-5c8a-87ee-6c94b335a980','','','Notes Roy. Bot. Gard. Edinburgh 28:20.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f70228bf-92b8-5db2-94fd-ce705175b03f','','','Abh. Königl. Ges. Wiss. Göttingen, Math.-Phys. Kl. 1894:61.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4205a8e7-acda-55e0-8fa0-56c668b3cf68','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 22:68.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c10e9f36-62aa-55f8-b1d2-1b602d0771fe','','','Bot. Jahrb. Syst. 17:582.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6ceed39-18a0-537d-8138-d5d13dc09f32','','','Fl. atlant. 1:87, t. 20.  1798 (non J. F. Gmel. 1791)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8990f43c-45ee-5304-abc1-1e3e3b367621','','','Bull. Jard. Bot. Buitenzorg sér. 3, 9:163.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7f8c294-c72b-596d-b926-776b63b3277f','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 13:97.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c6e3e7c-6e9f-5e7d-b474-2cb937e593d5','','','World Checklist Seed pl. 3:18.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d754242-3848-5b09-9626-7aa371e6ca73','','','Mem. Dept. Bot. Columbia Coll. 2:201.  1898 (Monogr. N. Amer. Potent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('117e8e32-bcde-586a-932b-256e6c2e0e22','','','Proc. Amer. Acad. Arts 6:223.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b65a139e-7be7-57e0-a4fa-026b820b418e','','','Vierteljahrsschr. Naturf. Ges. Zürich 56:314.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49b9bfc9-3708-5c0a-83b1-cb573a221b8e','','','Kakteen And. Sukk. 18:202.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf592c6f-cf6a-55f0-9e41-d320af36c65c','','','Madroño 66:93.  2019','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37dda5ef-3c43-5d30-85c5-5963e4719add','','','Trans. Philos. Inst. Victoria 2:74.  1858 "<I>leptocarpum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd44188c-09eb-576e-93e6-4949e047bf91','','','M. D. Crisp & P. H. Weston, Advances in legume systematics 3:126.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('147ac10e-4e12-59a3-ac32-16a1db070ec8','','','Sp. pl. 5(1):144.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('491c8ab5-b79e-536f-8d65-ced5537c41da','','','J. Linn. Soc., Bot. 42:377.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37e7a038-1c8d-5e4b-92eb-2d217337c80d','','','Repert. Spec. Nov. Regni Veg. 26:126.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f031f0a2-8636-545c-84f0-f5efb3d7b6d1','','','Bull. Torrey Bot. Club 36:690.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a7d666d-6a87-5705-ae52-411d6e9fcd68','','','Bull. Soc. Bot. France 55:695.  1909 ("1908")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f4799f3-3889-57e7-b726-a2f4807d41e2','','','Fl. Lib.-Syr. 1:37.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95a9e592-a8bc-5414-9dac-6076e0d180c5','','','Ill. dict. gard. 3:152.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf863b29-68cb-56a7-8e73-379fb70b37b9','','','Symb. antill. 8:292.  1920 Feb 1 (Fawcett & Rendle, Fl. jam. 4:34.  1920 Mar 25)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('201fc378-cd17-5b7a-aa56-e22763d31624','','','Ill. Handb. Laubholzk. 1:121.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('675f9add-54f4-5bd8-9b3f-0f7e7d394712','','','Syn. fl. N. Amer. 2(1):381.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48b921e0-79ad-5319-91c1-365f0cd02cad','','','Fl. Afr. austral. ill. 74.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad24db68-3caa-5839-b3ff-3135be6b1014','','','Pl. Cult. Serres Jard. Bot. Brux. 85.  1907, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('342110fb-d21d-5d55-94e5-61de5821784d','','','N. L. Britton & J. A. Shafer, N. Amer. trees 141, t. 107.  1908 May (Torreya 8:239.  1908)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('308a2346-d8a8-5062-b5ff-25cf0ff01473','','','New York Agric. Exp. Sta. Techn. Bull. 149:34.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90a4c96e-9b46-5069-97bb-80669021de56','','','Phytologia 77:261.  1995 ("1994")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2d19c2a-c44f-52cd-83d2-63ca0d561f78','','','Univ. Calif. Publ. Bot. 3:75.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88362f10-de12-5320-b7f6-8a4abba878e9','','','Repert. Spec. Nov. Regni Veg. 19:134.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3893fa8-a411-52df-8097-3fb74b3c86ee','','','Hortus kew. ed. 2, 4:110.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25ef7e41-a97a-509f-b2ac-111524c958ef','','','A. L. P. P. de Candolle, Prodr. 9:211.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7602ba0-ea8a-5783-a6e9-eb98031d245b','','','Kew Bull. 1952:373.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21dfa539-e5f1-5f14-ac91-2b0ad6fc4a88','','','L. Diels, Bot. Jahrb. Syst. 29:401.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fdc85da-d093-5ac3-b2ea-44378953c0e9','','','Fl. Australia 8:392.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25b08d5f-60e8-5e90-8093-49193f501f93','','','Sketch bot. S. Carolina 1:448.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9e6d7e5-6e42-56eb-b23c-7087d51e0569','','','Bull. Torrey Bot. Club 17:312.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eff9f5a1-e0ba-596f-81ba-d7e6302abf50','','','Legum. Trop. Africa 480.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1990e89-5358-5e4b-bb3f-e8987b7ab300','','','Retzia 1:225.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8ebaf38-3de4-5c27-9a21-1edd8cc8a87b','','','Mem. New York Bot. Gard. 9:214.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56773e80-3faf-56a2-be4f-fbcc0259bf51','','','Ann. Nat. Hist. 3:429.  1839 (non Rottler 1803)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('daeea250-2106-59c9-84aa-0da229a6d188','','','Icon. pl. Ind. or. 29, t. 143.  1872 ("1871")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bc0489e-67ab-5457-bd20-e00e7f553d2d','','','Kulturnaya Fl. SSSR 2:184.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7538a2b-8f77-5d71-a86a-1921a5cf60f3','','','D. Prain, Fl. trop. Afr. 9:113.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecc71d64-4704-5ca0-a8da-936a02e548c8','','','Handb. Bromel. 41.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49746086-d0d1-5eca-980a-2669b4a29dcc','','','Fol. orchid. 5-<I>Coelogyne</I>:7, no. 16.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3e06d8d-c4f4-5e27-adbb-281df9b5ec2c','','','Fl. Hawaiian Isl. 194.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70cab69f-d145-52e1-99d7-19f88f376659','','','Sitzungsber. Königl. Preuss. Akad. Wiss. Berlin 1904:385.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e64447e0-a695-5d0f-8dd6-b4b6607cf6ec','','','Gentes Herbarum 5:551.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22a1028c-1cae-5702-b13b-c6f60616e20f','','','Flora 49:165.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1417efbf-9f22-5069-a2ca-a49b6b97ee49','','','Bull. Bur. Pl. Industr. U.S.D.A. 282:60.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea51162e-7f3e-5075-9edb-c6464001bc46','','','Bot. Reg. 4: t. 291.  1818 (R. L. Desfontaines, Tabl. école bot. ed. 2:232.  1815, nomen nudum)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5830fb84-a844-5046-b63b-6e5bf9826f76','','','Syn. pl. succ. ed. 1. 180. 1812 (non Miller 1768)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c474b198-a1aa-5ebe-ad32-5020ec850a16','','','Bot. Centralbl. 8:406.  1881 (Monogr. Festuc. eur. 134.  1882)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c68c8841-bb43-5ed3-8e77-96795db158f4','','','L. Beissner et al., Handb. Laubholzben. 437.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('098c3ab8-df9f-527e-897b-448584198dce','','','Bot. Mag. (Tokyo) 13:71.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61a62b1f-e0c9-5186-9329-bed5f8498ac9','','','Kongl. Svenska Vetensk. Akad. Handl. ser. 2, 34(5):44, t. 4, fig. 1-2.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4f08cac-d46a-5ac5-8224-a9447a06fb1e','','','Gard. Bull. Singapore 53:251.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('208cfbac-a280-5834-af2a-0f8baa30baaf','','','Observ. bot. 3:9.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e16ae45c-ee9c-52a1-b2e1-bb465c2c2d36','','','Diss. observ. bot. 31.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e868dd9c-c761-549e-931f-bb69ee640082','','','Orchid Rev. 11:292.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db999c6c-27c4-5de8-9f34-cad42a12944e','','','Contr. U.S. Natl. Herb. 5:139.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b41baeb-1c9e-588f-98d6-d67700c4649f','','','Rep. Bot. Soc. Exch. Club Brit. Isles 4(Suppl. 2):607.  1917 "<I>epacridum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c311995-4b83-50e4-8bc3-9d8f1012c1eb','','','Bot. Misc. 1:19, t. 15.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7330c1f2-104e-51d1-befd-0512eeebb76d','','','Proc. Amer. Acad. Arts 23:280.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03013d36-1fcb-583e-8374-af38151c7afb','','','Feddes Repert. 95:501.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23cf189b-d9a4-5eeb-bab0-94b738fb8042','','','Syn. Queensl. fl. 500.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7df03e94-a165-5e78-8069-1a6c462d3f9d','','','Mem. Wern. Nat. Hist. Soc. 4:288.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e172be83-7c71-5684-86b3-2d7cfa347a7e','','','J. K. Small, Fl. s.e. U.S. 1211.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7997edf-37f7-5161-99f1-26c872c8ad4d','','','Contr. U.S. Natl. Herb. 16:102.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdaa0128-21f6-56ba-b1cc-6589a2d73678','','','Ann. Sci. Nat., Bot. sér. 3, 2:123.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62538f2b-fff2-5e02-bc6c-7b9eabd05381','','','Fl. orient. 1:494.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2153490b-11af-555e-b685-9c085a2f2527','','','Fl. nov.-zel. 1:81, t. 20.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93cdaf5f-fa12-5585-9a0e-990039a1fee2','','','Fl. gall. 1:105.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bb5e4d1-8146-5e25-a228-a36aa44210ae','','','Hooker''s J. Bot. Kew Gard. Misc. 3:255.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb48d167-51fd-5e14-91af-3814f7469d45','','','Brit. fl. gard. 2: t. 127.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9621d17-411a-5414-8ac8-3f6f48b8541d','','','Phytologia 77:286.  1995 ("1994")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd1f5a8c-27f1-58e2-9dc6-343cc3e53ea5','','','Cat. afr. pl. 1:768.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d59c535f-9b4a-5614-b325-9d7d98a772b9','','','Proc. Amer. Acad. Arts 8:165.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a51a8be-e498-5a22-b651-e69c441a2afa','','','Madroño 3:26.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c048186a-842d-526d-ac08-f3a72cec52c9','','','A. L. P. P. de Candolle, Prodr. 17:182.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64d6f3eb-60a6-50f3-b2ae-9aa3d972228b','','','Meyen, Observ. bot. 13; Nov. Actorum Acad. Caes. Leop.-Carol. Nat. Cur. 19(suppl. 1):13.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01ead204-64ed-5c53-92a9-370fe9cca894','','','Tabl. encycl. 1:59.  1791 "<I>Zapania</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87cb9259-cf8a-54fc-aae9-6a7128798688','','','Cact. Succ. J. (Los Angeles) 49:167.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d830a1f-1ea6-588b-913d-82e2fa401731','','','Mem. Fac. Sci. Kyoto Univ., Ser. Biol. 15:34.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d668b9f-4b5a-5ab9-872b-56d0d85f6cbb','','','Saxifrag. enum. 2:13.  1821 (Revis. pl. succ.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95519b71-715b-5fac-a005-da6582758fcf','','','A. L. P. P. de Candolle, 8:42.  1844 (non Link & Otto ex R. Sweet  1839)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43eb07b2-5fc0-53f3-9cb5-b2ce7fd94d0a','','','Rep. (Annual) Missouri Bot. Gard. 19:78.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27bc78c3-3926-509d-8acf-7086a3d19dcd','','','Fl. siam. 1:28.  1925 ("1931")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44a96310-c2e6-5b1e-8190-a5b76d841c3e','','','Contr. New South Wales Natl. Herb. 1:329.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3dde748d-036b-537a-873c-a6d0549034fa','','','Pl. Life (Stanford) 25:48.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02fb4049-b18b-5c1e-a3bb-4e1852aeb795','','','Prodr. 5:642.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f966b661-c6e5-5f32-80fe-55706a7b7294','','','Fl. sicul. syn. 2:430.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f954ff4-2c22-5b0c-a127-cff3faeeb88c','','','Descr. icon. pl. Hung. 1:2.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('864bc81c-2d86-5b79-b139-fbc333a68142','','','Repert. Spec. Nov. Regni Veg. 7:145.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d003cb04-183f-51bc-9805-7caf2a7f1644','','','Arch. Bot. Mém. 7:104.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0ee779b-97b1-56cf-b4dd-d109932a8ba4','','','Bull. Torrey Bot. Club 9:17.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41c131f5-b92c-5d04-a24c-cbfaf63962c5','','','Handb. Kor. Mandsh. Forestry 186.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ef4b0dd-4b77-58e3-b32d-8db88c7d3a56','','','Ill. Hort. 37:107, t. 115.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8418ddda-3aa4-56c4-8081-6aae02aedcf4','','','Fl. berol. 65.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96b95890-d583-5da2-a1dd-70f01c20d92a','','','Kew Bull. 58:346.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a54cbece-abb9-5634-956d-f31c61a6d899','','','Novi Comment. Soc. Regiae Sci. Gott. 6:5.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f8e67b0-0487-5eda-81e1-e1f21b4eb420','','','Trans. New York Acad. Sci. 11:84.  1892 "<I>Rynchospora</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9c92620-a43a-54fb-bf33-1dc7ae69f03f','','','Hist. pl. Dauphiné 3:237.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06700010-e639-5387-a86c-bae9e51ce428','','','Fl. Gabon 29:69.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('754f26e3-9387-554b-b691-2df7b35fdd79','','','Bot. Jahrb. Syst. 39:597.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82f60f53-fe5d-5b3e-96f5-808e0f9cd2f1','','','Cactaceae 3:163.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c350578-aa02-5206-a2a2-14a44600ff16','','','J. J. Roemer & J. A. Schultes, Syst. veg. 3:520.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce93203e-5a75-5865-a215-615354c14997','','','Syst. veg. fl. peruv. chil. 191.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e3ac685-1cb2-528e-ab63-56f7c4aadb5e','','','J. Adelaide Bot. Gard. 11:34.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78490e11-fad2-54ed-ad44-c49d3f707787','','','Ann. Sci. Nat., Bot. sér. 4, 16:71.  1861 "<I>atra</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07c57626-2aa2-5007-9f28-e2a861954bee','','','Notizbl. Bot. Gart. Berlin-Dahlem 15:247.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('094fc423-c267-5cbf-839d-805ba55bc85b','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:169[folio].  1823; 6:214[quarto].  1824 "<I>denticulata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('488c1eef-587d-5149-a049-13fbca703ac9','','','Leafl. Bot. Observ. Crit. 2:79.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54d8067d-b701-572d-bcb6-b680816e2f8f','','','Feddes Repert. 112:42.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f9adc7a-e0d2-5917-af90-e7b754edbcd2','','','J. Malayan Branch Roy. Asiat. Soc. 19:147.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0402104c-988a-5e25-a2e2-209d54364216','','','J. L. Stewart & D. Brandis, Forest fl. N. W. India 100.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f52c34a-964d-5032-bd61-d884d09291a1','','','Hooker''s Icon. Pl. 13:33, t. 1242.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1448ebfb-fb34-5942-b2ae-74e93c08f126','','','N. Amer. fl. 23:29.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4e97c7a-6c8e-59ea-ac36-752994110387','','','Pl. rar. 5.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('184d4748-f8b1-5562-807a-7eb8387a9630','','','Kongl. Vetensk. Acad. Handl. 1817:71, t. 3, fig. 2.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dceab86-4502-5463-8a62-5386b0bcf496','','','Smithsonian Contr. Bot. 1:50.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('047b97fb-85ed-5e90-a35a-3e08617abe00','','','Reise russ. Reich. 3:App. 718.  1776; 3:Anhang 32.  1778','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0bbc935-ce01-55ae-9b8d-469ca50a2569','','','Rhodora 37:138.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aea0b114-a86d-5425-b01e-9428390000d9','','','Monogr. <I>Digitaria</I> 419.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('106e9694-27f4-5013-9b07-0bd2bd0b75af','','','Prodr. 2:397.  1825 "<I>jacquini</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fa8eaa2-7ac8-5be3-b03b-1e70551b5296','','','Diagn. pl. orient. ser. 1, 2:23.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3a0c5d0-b30c-5a26-8323-192a8ce22043','','','C. F. P. von Martius, Fl. bras. 1(2):125.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f742a347-6e6d-5617-bd1a-9b9e6f5b1721','','','Proc. Calif. Acad. Sci. ser. 4, 25:297.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fc9d16a-0e09-557d-9122-004afa2880f3','','','F. Cuvier, Dict. sci. nat. 29:494.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28638d8d-af75-5892-be05-c5da61bca69a','','','Bot. Jahrb. Syst. 50:352.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f0ad640-1ff2-52c6-a876-92ca88f59cf2','','','Repert. Spec. Nov. Regni Veg. 42:171.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('957174bb-c509-5989-91d2-f5feb1a90e8f','','','Gard. dict. ed. 8: <I>Agrimonia</I> no. 3.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a158db51-c582-5183-ba19-7f6349354d90','','','Révis. gramin. 1:293, t. 58.  1830 (1:89.  1829, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c36a23d-054b-5e0c-9de2-c58358d3dc0f','','','Hist. nat. Iles Canaries 3(2,3):182.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c51b5675-503f-52db-8a6c-283d87faaccd','','','Nova Acta Regiae Soc. Sci. Upsal. 6:77.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('928c953c-c325-5e7d-a2a8-e53f04b6d407','','','C. F. P. von Martius, Fl. bras. 15(2):172.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63d6e78a-b831-55d8-a5b3-614b93a17776','','','Bull. Torrey Bot. Club 44:9.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef682861-ea4f-537d-bf75-1e643ffd2a2a','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 66:168.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ba0b34d-7375-5487-b8ae-0e9f209f7ca1','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:362.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91d9a15f-9024-5667-b131-f5953f92bff0','','','Enum. hort. berol. alt. 1:144.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb75fddc-994a-5239-a41a-08859305185c','','','Mitt. Deutsch. Dendrol. Ges. 1915(24):214.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6eef194b-3044-586e-9f40-394521c7a48f','','','Bull. Misc. Inform. Kew 1939:247.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dac986ff-8c59-5b0b-a034-9483708483c5','','','Harvard Pap. Bot. 4:265.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('359b0231-c6c0-50e4-9b96-80fef2780345','','','J. Dept. Agric. Kyushu Imp. Univ. 6:303.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbcf83b3-831b-58d1-8d90-a8362f0e0e41','','','Ann. Sci. Nat., Bot. sér. 4, 8:149.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aec7060d-6aa5-54be-aaac-d30accce14cd','','','Rep. Conif. Conf. Roy. Hort. Soc. London 1931:232.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a3878dc-5c5c-54c4-b66d-7e9816fee805','','','Prodr. 329.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77691ead-aad4-5298-96e3-9f15d9f03d94','','','Phytotaxa 162:177.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('433bdaf0-a936-5168-a789-87cb5f58acdb','','','Char. gen. pl. 92.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('442824be-8dfd-5eac-900c-e62b88446b74','','','S. African Quart. J. 1:363.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ade2b72-7461-5fb6-afae-cb53c237f55a','','','Verh. Bot. Vereins Prov. Brandenburg 15:81.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77635891-e3a5-5a83-9809-f97a8efd71da','','','Sp. pl. 1:478.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('732ba3b0-8e19-5d09-b590-fd97b17942dd','','','Verz. Pfl. Casp. Meer. 166.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbf8ed3f-7e4b-5632-b22f-56ac66fc9ac0','','','Revis. gen. pl. 1:778.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b89227c8-e587-560f-918c-30ef09bfcdb3','','','J. Torrey in W. H. Emory, Rep. U.S. Mex. bound. 2(1):231.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b40902d4-6b8f-5d6f-aa53-da7ed816e361','','','Ann. Jard. Bot. Buitenzorg 2:128.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2620af44-8ba7-5603-8faf-6037a20a46ed','','','Brit. herb. 486.  1756','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b1ca7ee-585f-55b4-a4e4-3d10c7a23495','','','C. S. Sargent, Pl. wilson. 1:393.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c80eaadf-5fe5-54d3-ba87-617908b3b63c','','','J. Bot. (Morot) 9:366.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('946375c8-530e-51ee-8ba4-aa919ec494b7','','','Fragm. 5:172.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c1406e1-1bba-5e5e-ab0d-213d254f152b','','','Repert. Spec. Nov. Regni Veg. Beih. 1:741.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e33ed603-390f-5362-87c6-3a62c7c8ad2e','','','Proc. Calif. Acad. Sci. ser. 4, 25:392.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65934539-a4b6-544e-a72e-96fd1ad1dfe2','','','Sp. pl. 2:1321.1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5831296-7c16-5f3d-8064-f06cb30c54b2','','','Fl. bulg. Suppl. 1:111.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f311f7a-0592-567a-8c75-b9e01bbbfbdb','','','Handb. Bromel. 49.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0738906-7963-54c6-a487-bb14ef5391cf','','','Phytocoenologia 15:450.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e170327-e116-5bcf-a3ff-bfd2a2f684e8','','','Syst. Bot. Monogr. 7:86.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c25ba40d-fa87-5d9f-8981-16f43f3d0f08','','','Fl. altaic. 3:364.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65c7f8cd-d2d6-52b3-aa78-4aa664aa110b','','','F. Henkel et al., Das Buch der Nymphaeaceen oder Seerosengewächse 84.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8b1126b-0eeb-5f41-856e-b7024ce10634','','','Prodr. 2:632.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1d1e8e2-08e8-5a3f-a747-881fa422678f','','','Dendrofl. U.R.S.R. 1:115.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcf8919b-8895-5aaf-b203-39957a40f964','','','Sp. pl. 3(2):1180.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22f55bbe-c35c-5834-b10e-90c0e9636180','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 29:126; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 11:731.  1883 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdce679a-12a4-590d-84a5-d605366b21ae','','','Bot. Jahrb. Syst. 10:20.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d17c502-b5b3-5c83-a16b-3adc159c00b2','','','Kew Bull. 42:380.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('063144ad-6598-5d5c-9306-4ddaef08599e','','','Enum. stirp. Transsilv. 2:63.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b72a51ef-fd9c-5c31-be8c-457d47b3c4fa','','','J. Arnold Arbor. 19:17.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03f0f3cb-84ad-5bf1-b802-688affb1a3fa','','','Bull. Soc. Imp. Naturalistes Moscou 5:189.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5ca947b-0950-5b83-8330-e3ef9f675b4e','','','Bot. J. Linn. Soc. 76:378.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d81774c0-3a16-5333-8813-a61ecc266f51','','','Liliac. 6: t. 315.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d09aa35f-e9c9-575a-aaf1-34250fd4d7f1','','','Suppl. pl. 446.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91ffc93b-3a04-5ffd-b6f9-847a271e0e76','','','Proc. Biol. Soc. Washington 35:119.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9e2229e-ac88-5c8a-af12-0ec8af0f5a64','','','Acta Bot. Yunnan. 19(3):217, fig. 1.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41aecf4f-ce5a-5d03-8c90-99d10d9f3e74','','','Bot. Mag. 99: t. 6069.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d577a058-f3c3-59ab-896f-c7e139885b51','','','Linnaea 14:536.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb0a6832-8438-5fa2-b3c9-9f4ddf941e0a','','','J. Bot. 3:181.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('186daead-8e53-5dc9-a01e-c6659b01937d','','','W. T. Thiselton-Dyer, Fl. cap. 5(1):128.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b370b268-d7ae-5e82-b669-257918c22f28','','','Bot. Mag. (Tokyo) 32:224.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa638191-0247-5757-9139-f3411f1f78d6','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 8:195, t. 6.  1886 "<I>Davidi</I>" (Pl. david. 2:13.  1888)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd92429f-a10b-5880-9dec-51b092951235','','','Bijdr. 873.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32ede95b-f417-507d-8d7e-993a0c47e7b9','','','Repert. Spec. Nov. Regni Veg. 24:65.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1961af53-5f16-5324-b8aa-37031152ad66','','','Linnaea 22:240.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b31b3ac5-0d42-5374-b303-d8e28eaf97b9','','','Ann. Sci. Nat., Bot. sér. 5, 5:38.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5fb050f-2fb7-55ea-afa6-a793f901f7a6','','','Select. stirp. amer. hist. 1:277-278, t. 170.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('057d9ec6-2f89-5366-82fd-420c1956b6b7','','','W. T. Thiselton-Dyer, Fl. trop. Afr. 4(2):105.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('216a8734-bf27-50b5-987d-7fc6d48ca20d','','','Sp. pl. ed. 2, 2:1677.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aafd3964-98b4-5612-b1f7-16c1802e64a0','','','E. G. Steudel, Syn. pl. glumac. 1:400.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5526c5b-8c48-57b3-b158-64f00557700b','','','Mém. Mus. Hist. Nat. 17:117.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d9726aa-b153-5960-acb1-e52518465d01','','','Bull. Jard. Bot. Buitenzorg sér. 3, 1:379.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ead49692-1ed9-5b08-b100-3dd91b897eee','','','Vierteljahrsschr. Naturf. Ges. Zürich 51:182.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a558bed6-0465-58df-8cb8-b1073ff1483b','','','Kew Bull. 1957:466.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5ba7d24-5119-5f32-8e1e-6b9839393042','','','Cat. Hort. Dorp. 3.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42a28dca-a9f5-5e7a-aaf6-56a93cef62f4','','','Fl. atlant. 2:372, t. 253.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5db201f-02a1-591e-b0d4-00b61c9ceb98','','','Bijdr. 1101.  Oct 1826-Nov 1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d880bf51-3199-5ab3-adb8-3212428d4c6c','','','C. S. Sargent, Pl. wilson. 1:203.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd13f9d8-1568-58f6-9d36-6bbc2770c223','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:335[folio]; 3:429[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36931802-f592-56b3-b021-783086cb7d8f','','','Cat. fl. Rif orient. 6.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d7c0eb4-d306-5521-bf9b-79b7ae84bfe7','','','Natl. Cact. Succ. J. 21:93.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30fb5379-8b53-5a31-a325-dfb004ec365d','','','Trop. Subtrop. Pflanzenwelt 21:45.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d44dd96a-4e2e-51bd-883e-713497009c76','','','Repert. Spec. Nov. Regni Veg. 8:9.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e0fa20d-035d-5a22-b831-a9cf046b4d94','','','B. Seemann, Bot. voy. Herald 430.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10651149-1de8-5743-bdd7-7d22a4f8a27a','','','Sierra Club Bull. 4:300.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cc6f4a2-a46c-5afb-9a1d-0e5f01a0b50a','','','Acta Bot. Gallica 144:42.  1998 ("1997")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dfedbbc-0834-5844-874d-132de4c0448e','','','Rhodora 42:403.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcb4f7ef-70fc-59d1-bfd9-2e219480f827','','','J. Orchideenfr. 13:143.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('099fb55e-aa23-5f43-9dec-911d5f0fd363','','','Rep. (Annual) New York Agric. Exp. Sta. , Geneva 3:238.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7309692d-0b0c-54c8-a755-acee172c7035','','','Brittonia 49:102.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9e69573-9330-53db-89dd-6db654a2cf60','','','Prodr. fl. Ind. orient. 435.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e8250fa-013a-5c49-8b0f-be82cb6884e0','','','A. L. P. P. de Candolle, Prodr. 10:532.  1846 "<I>linariaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7cc069b7-d715-5742-bc06-b667853d9600','','','Notes Roy. Bot. Gard. Edinburgh 20:86.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52be4d60-881c-5e29-acc9-5f6463bd7765','','','Mém. Soc. Imp. Naturalistes Moscou 5:33.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61982400-a638-5f08-9aad-fd60cfa2fc09','','','J. Burtt Davy, Man. pl. Transvaal 2:xxiv, 369.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dddbbc24-64ef-5f77-a0b9-0a83c223f465','','','E. H. F. Meyer & J. F. Drège, Comm. pl. Afr. austr. 35.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('176f0c13-cb44-57d6-80b5-4808d681070c','','','Trudy Prikl. Bot. 23(4):110, 137, 338, fig. 30.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3a13fca-561a-5c2c-ba53-851b69dc11be','','','Elench. pl. [22]; Gen. sp. pl. [22].  1816 (non Willd. 1802)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bc9ec9c-a442-5d80-a3f7-945b0fdace3e','','','Fl. ins. austr. 56, no. 297.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('304c1ba4-887a-5d64-9ef3-4bd83d51516d','','','Repert. Spec. Nov. Regni Veg. 11:428.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9af1aa83-90d6-5a6b-96d5-27a8077c8d07','','','Bonplandia 8:95.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cddd46f3-f479-5e07-bafc-d486a9efa205','','','Prodr. fl. nepal. 196.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1019ae4b-5e2a-5b51-ac60-cbb1480fcaa2','','','Notul. Syst. (Paris) 1:43.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fe8c8a0-77bb-54f7-a8e5-acc6536d1252','','','Dansk Bot. Ark. 4(3):21.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('410ef996-b709-5e92-bc27-81762c65d1c3','','','Syst. Verz. 20, 44.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5f2196c-e1f2-506a-b247-2f8b325c4d15','','','Fl. sylv. kor. 19:26, t. 9.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c70ff611-3a1d-530b-8c81-e1eb7a0333e9','','','Acta Horti Gothob. 1:253.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66b2888e-3e26-58ab-9fa8-212f9f26a16b','','','Gartenflora 12:275.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fa0c27b-c1ee-55fe-b111-3119ae931270','','','Prakt. Stud. Orchid. 284.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72e2e8eb-be4b-56fe-b8a3-9625031ec334','','','Univ. Calif. Publ. Bot. 32:73.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('584db0dc-e464-537e-b5ff-f2289e655e6f','','','J. Bot. Res. Inst. Texas 11:307.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2a79113-1f16-57fd-846e-3a06e4f04ecc','','','Fl. Brit. India 5:759.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76afe3a6-b6f2-5fd5-b38a-e43e1005eb62','','','Belgique Hort. 23:97, t. 6.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7fd3c50-f283-5828-b9d4-07e80dff6f98','','','Proc. Calif. Acad. Sci. ser. 2, 2:144.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21ec900e-40ac-528a-aa69-748ff9d1fc64','','','Mem. Amer. Acad. Arts ser. 2, 6:382.  1858-1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35ebbde9-cb4e-5a58-9525-2e6a247596ca','','','Byull. Moskovsk. Obshch. Isp. Prir., Otd. Biol. 92:134.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee65a194-8398-524f-8bc6-2b72defcdc16','','','Ann. Missouri Bot. Gard. 77:576.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9463e73a-a648-5308-b82c-d506c3809de9','','','Trans. Roy. Soc. South Africa 16:303.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6f61612-1d9d-5279-adc9-8566f05aeb02','','','Legumes of India 196.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e8760b2-b3c2-51ff-8684-a3fb4629d9aa','','','Ill. dict. gard. 1:484.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6969a29a-2a8e-5fcb-8d76-378d8efe8f37','','','Encycl. 1:103.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2884a9b9-77f0-54bd-af0b-4662e2fc5f53','','','Phytologia 19:223.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7f2eafe-345f-5252-9a38-e91e07136067','','','Syst. Bot. 15:693.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5eea5d9e-3881-5588-b68d-7e2b4843608b','','','Bull. Herb. Boissier 1, App. 2:22.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7773aff2-e6de-5c77-8807-f81104e3f0f0','','','Proc. Amer. Acad. Arts 26:141.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bd98a57-0d0d-5664-b2ad-9f236c1e3df0','','','Ann. Soc. Bot. Lyon 26:14.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4941af32-bc37-57c3-bc1e-f39afba4dd97','','','Bot. Mag. 143: t. 8719.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d14ed896-e638-5e12-904c-e5cd28dd7529','','','Proc. Amer. Acad. Arts 15:48.  1880 ("1879")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4ad5367-5fec-5c43-875b-3c519d80a7b8','','','Hort. kew. 3:320.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e47e610b-9034-5c7d-9e36-ade7f52a93fd','','','Fl. bor.-amer. 1:141.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ef6e751-568e-5ae3-bc2b-409f15214313','','','Deut. Dendrol. 300.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd546f8c-90a9-5efe-a814-a3beefdaa401','','','Icon. Pl. 9: t. 887.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26692923-41cb-5752-937e-6413d1ac1d9d','','','Proc. Calif. Acad. Sci. ser. 4, 25:254.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59a68c82-3515-5d6d-bc5a-cd8412959769','','','Caldasia 4:104, t. 13.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d68ae26c-0aa0-514c-9578-0ef01968c9ce','','','Austral. Syst. Bot. 10:615.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cd98503-b01e-5d31-befd-f024a9626a19','','','Arch. Jard. Bot. Rio de Janeiro 4:133.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f85dda4f-6051-5ce1-8ea7-a31990452263','','','Rep. (Annual) Missouri Bot. Gard. 22:57.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1566ef75-32e6-5b92-9768-6772adb27345','','','Fl. S. Calif. 401.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b20c79dc-3397-55a9-be5b-da0ff51795c5','','','J. Acad. Nat. Sci. Philadelphia 7:72.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a2247a3-1cf6-5bf9-8c25-56329a39e858','','','Bull. Fan Mem. Inst. Biol. 8:135.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afb5cfa7-55a7-5ee5-a144-699430e9f06e','','','Lazaroa 8:76.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba3868fc-3d71-5884-9e25-36be46f08df0','','','Kew bull. 26:574.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17938614-2fa8-54d1-b9b5-2dc29770e642','','','Linnaea 12:366.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f5b333e-b8c8-5cf3-9252-27ef86aa4788','','','Bothalia 2:288.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2423489f-c27d-5421-99aa-10a830c621a3','','','J. Hort. Soc. London 1:230.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de6684c3-d7b8-5800-a94c-56400c237569','','','C. F. P. von Martius, Fl. bras. 7:274.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93343bdc-fe39-5bf4-989d-aa93c1148142','','','Bull. Misc. Inform. Kew 1920:111.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55014bb7-7b5a-589a-8ef2-68bd41155ba7','','','Cult. Prot. 50.  1809 "<I>subulaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f11a8574-e983-5bab-866e-b166e2922393','','','Sandakania 7:39.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88c910e9-d2a4-552c-aa8b-5691853f567f','','','Mabberley''s Pl.-Book ed. 4:1102.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21074cbb-5e67-5a3b-af4b-e52e2407c56a','','','Linnaea 10:241.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91ed87e6-490a-5106-8fc0-534a46369e8e','','','Traité bot. méd. phan. 2:881.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7a31e72-c73b-54de-8db7-bce775c91037','','','H. G. A. Engler, Pflanzenr. IV. 9(Heft 3):48.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0061012c-8119-5e87-ab72-3497e8876719','','','Révis. gramin. 1:28.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef9a81bc-0f42-5311-91ea-03dd061de959','','','Repertorium botanices systematicae 3:341.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ede3b0db-fa7a-51dc-8356-cc7a0002115e','','','Proc. Amer. Acad. Arts 29:315.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ca64549-b8e9-5d7a-afba-65130a6f2d50','','','Garcia de Orta, Ser. Bot. 7:11.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b9e317b-81fd-52b0-b0aa-156f104629e3','','','S. African J. Bot. 52:481.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2919fb6f-2670-565c-83f2-ce3d74f6ad55','','','Bot. Mag. 137: t. 8378.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ec087e4-3004-5975-8de6-48e93f2316ba','','','Bull. Jard. Bot. État Bruxelles 27:401.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0fad492-cee9-5fbe-912f-eb22568bafa6','','','Ill. Handb. Laubholzk. 1:719.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e5f452b-2932-5c37-88ad-aa9d14e1da93','','','Kongl. Svenska Vetensk. Akad. Handl. ser. 2, 35(1):70.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df0931c0-1b4b-5b5f-a813-95e03da19da4','','','Phytologia 74:276.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7891f541-7d21-5ec7-bc94-115d2060f2a0','','','Bot. Jahrb. Syst. 78:185.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c75b87d9-1e52-554f-a82d-5a77f8e81c12','','','Getreue Darstell. Gew. 11: t. 11.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28373647-c071-51d6-9c0e-5cbf8bde5600','','','Taxon 58:268.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4c896f3-6396-5612-8e22-61faef984464','','','C. S. Sargent, Pl. wilson. 1:188.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f85e3a6e-a8d6-5eb1-af2e-5c244ad9b663','','','K. B. Presl, Reliq. haenk. 1:226.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e92e4c81-4c92-5378-be0b-e7c904574ce0','','','Bot. Not. 3:357.  1953 "<I>boreoatlantica</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0292b8c0-dabd-59a8-b2c4-0f9c5b0360f0','','','Fl. Bulgar. 263.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98ca2575-d047-57bc-a9ce-19873baa542f','','','J. Adelaide Bot. Gard. 6:77.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('671d721d-a82c-5f48-9996-00a4ed43d5b1','','','Telopea 6:250.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a04c4b4e-7cb1-58b2-b80b-caf812eb82d2','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 18:129.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ed00e7b-fb0e-50da-8b3e-28d4c45f3669','','','Trab. Mus. Comercial Venezuela 2:69.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35f7a63e-fae1-5465-973b-f82877557a0b','','','Man. New Zealand fl. 921.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48a5c810-e4d6-53ab-8334-478bd92e18c5','','','Brit. fl. gard. 3:54, t. 276.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c3006e0-890f-58f6-9dfd-c5384b3840ec','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 16:84.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95fcaebf-4a0e-5020-ab89-152c67a9d4a6','','','Encycl. 7:130.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b08ff5a7-610b-5f75-85ee-66e7c725fa07','','','S. African J. Bot. 61:226.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93f6e40c-9d23-584c-98e1-072a11bd09be','','','Brittonia 30:471.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('374c1aa1-d69e-57af-89d7-ad4dc894895e','','','Brittonia 29:221.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa4bbd71-fb80-55a2-b3a7-effa9472a206','','','Rhodora 20:25.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f01ac52-3288-5c2c-bfdf-c24ee9de1d6b','','','L. H. Bailey, Stand. cycl. hort. 2:756.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0003d8f7-681c-5bdf-bb56-9c35dbbce672','','','Prodr. 1:634.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08970bb4-fa7c-5b2d-a132-14f9e46aeebb','','','Bot. Jahrb. Syst. 71:163.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d37ee0a-a897-55c6-aec4-11ea833cb98c','','','Bull. Jard. Bot. Buitenzorg sér. 3, 9:285, fig. 4.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c88fddc5-b593-554a-81a5-d933f545a1ae','','','Bot. Jahrb. Syst. 42:163.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80c61448-0868-57ab-861c-bc38c4dc8876','','','Kew Bull. 22:211.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9f8860f-10fb-5c79-bb6e-bc6f2c98f32d','','','Phytotaxa 277:207.  2016 (non Turrill 1919)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7064f866-2473-5564-a3fc-b22856fd7159','','','<I>Nepenthes</I> della Thailandia 40.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29791b23-4a27-5f71-90a1-924ad56444b8','','','Repert. Spec. Nov. Regni Veg. 10:133.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f7674a3-30ba-56fc-ac68-18996494c599','','','Diagn. pl. orient. ser. 1, 1:20.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7ecff20-3c7f-5bcd-94ab-629b53954c35','','','J. Pl. Biol. 40:288.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('850286f7-d8a9-5d01-9eef-1b5921e35a34','','','Tabl. encycl. 1:50.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aee5dc3a-f43f-5985-81f4-8cbf8e5856be','','','W. W. Saunders, Refug. bot. 3: t. 199.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ce9092f-1a8b-5ae1-83d0-9d889842486d','','','Denkschr. Ak. Wissensch. Wien, Mathem. Naturw. Kl. 79:321.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69e6f08e-26df-552f-a9ee-a07bdc4a79c7','','','Icon. pl. rar. 2: t. 279.  1794 ("1786-1793")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d989bcc8-69f7-5e5c-8f81-011d6cd81fe0','','','Revista Fac. Agron. Univ. Rio Grande do Sul 7:205, fig. 2A.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc0cbd53-cd7a-53b5-a0c5-cea540a08f65','','','Bot. Gaz. 27:437.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fdebdbd-a9eb-5f68-8724-afb564eeb7a6','','','Sist. Bot. Dergisi 8:7.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('132be614-3d0e-547b-bfcb-8ca5014416a3','','','Jahrb. Königl. Bot. Gart. Berlin 5:218.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('797f84a5-72ae-5cc3-bc7b-388950b7c79f','','','Bot. Beechey Voy. 343.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a028806-8c2c-5a2e-9764-ca1c21461102','','','Fl. austriac. 1:57.  1773','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76fe13ff-9573-53df-b4e3-96fcaab08eea','','','Monogr. <I>Digitaria</I> 563.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c088fb4f-bde1-5763-bc19-e103e96fa169','','','Sp. pl. 1:151.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1798c8ac-5836-5c07-b7ba-48d275b5ed4e','','','Fl. gall. 191.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18c8beaa-e535-5b4c-a590-be356a056eb4','','','Fl. peruv. 3:97, t. 325, fig. b.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d431b73-efa3-5a6f-a342-d8273311e1a1','','','Observ. bot. 2:25.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('763f64ad-68da-52a8-afb2-7a993e17e895','','','Icon. 2:33, t. 141.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5209c262-95e2-5037-b6fc-94c2b00d7371','','','Amer. J. Bot. 55:1249.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fa9f9bc-3405-5455-ab21-4e6896218210','','','Overs. Kongel. Danske Vidensk. Selsk. Forh. Medlemmers Arbeider 1854:179.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0589f990-1971-5966-80a8-0276a9c9bc9e','','','Meded. Bot. Mus. Herb. Rijks Univ. Utrecht 65:521; Recueil Trav. Bot. Néerl. 36:521.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4be046e1-a6ec-59f6-b742-b7a5a99cca45','','','Acta Phytotax. Sin. 9:328.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b1032b0-96af-5866-9fef-b2815ca946bb','','','Kew Bull. 1955:191.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cd90f94-02ac-5920-b512-d0eb0519581f','','','Brittonia 39:412.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f2d1efb-7acb-527b-841a-4dec60a7c777','','','B. Valdés & H. Scholz, Willdenowia 36:664.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19eff461-6d89-51ff-9c66-b8fc48c364b6','','','Hort. kew. 2:181.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c0c9555-dd93-51eb-b51b-1b78526ce2b2','','','Sp. pl. ed. 2, 2:1491.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcfd6d66-c142-5818-bbef-2bfb0c0770b6','','','Nomencl. bot. ed. 2, 2:726.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6421b76f-f505-52b9-8ff0-02f2a76a00c3','','','A. C. H. Braun et al., App. gen. sp. nov. 5.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32ddb066-fa1c-571c-ace2-5ea14074e9f0','','','Enum. hort. berol. alt. 2:299.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ecfc7c1-0c62-517d-ba08-6ae9282feaba','','','Trav. Mus. Bot. Acad. Petersb. 14:156.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50cd1bc5-1321-59aa-9b62-9a35ef9f924a','','','Bull. Fan Mem. Inst. Biol. 7:290.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb1d227a-3537-583c-a59e-4c86603ffdfb','','','Bull. Herb. Boissier 2(app. 2):38.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed49b934-adab-5afd-b2dd-8054e15ccce9','','','Natl. Hort. Mag. 24:286.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2ab835d-13b2-5fe0-b8b9-ef4efe868a6f','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 2:415.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d25955d9-88ba-5fb1-9998-3d2ab9d44f17','','','Proc. Amer. Acad. Arts 11:127.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e346ca3-63a7-5c7d-835b-4f6d3fb051ea','','','Sida 16:444.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc73b461-6e11-5cbc-bcec-b9325473bd52','','','Bull. Acad, Imp. Sci. Saint-Pétersbourg, sér. 3, 19:525.  1874 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01afa14d-4b25-5c54-a377-272edf9ceb46','','','Pl. columb. 1:9.  1874 ("1863")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2fab294b-b6d3-5f50-994b-c9a242f3f5c2','','','C. F. P. von Martius, Fl. bras. 7:265.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a102bbc-9a08-5e0e-9b06-6129bd127f51','','','Bull. Misc. Inform. Kew 1935:234.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0718b9e-80c8-5107-b5f1-3ed1eb470a84','','','C. F. P. von Martius, Fl. bras. 15(1):81.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5621c11c-63d7-5ebd-be06-97b9e3a4698c','','','Sp. pl. 4(2):771.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('177ff8f1-1515-5392-8490-183eb0b291e6','','','Trudy Prikl. Bot. 32(3):34.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6b6b234-c49f-5757-bafb-c9db714add6d','','','Fragm. 1:40.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f720344-8a3a-5aa0-95f1-4fe3ba8f1a64','','','N. I. Kusnezow et al., Fl. cauc. crit. 3(7):10.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36e9225c-4bf0-55c4-ba3a-e90c68aefb6d','','','Flora 26:760.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('064fcbef-1e7c-5fbf-8936-9628c5d8252e','','','Bol. Soc. Brot. sér. 2, 42:270.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0053aedf-9815-5a2c-9880-c30d64e6f603','','','Bijdr. 345.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f08a15a-9954-585e-a216-68b7feec4345','','','Fl. lusit. 2:365.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('797c4e1d-d104-518b-afa5-2ebf69f9c16d','','','Index sem. hort. hal. 1839:10.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cc3af6a-62bd-5fff-98d1-79817e9e4b7a','','','H. Lorentz, Nova Guinea 8:292.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43d5579f-4606-5004-9f52-6db0c2f56f4f','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1852:20.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('512f3b52-ce6a-54be-b5e7-8182ad16a499','','','Linnaea 1:166.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb9220e4-ca60-5af5-9a0a-6814e9e8d6d3','','','Baileya 19:3.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02bb087d-73f5-5880-a0c7-57ec99c53ca6','','','Izv. Bot. Sada Akad. Nauk S.S.S.R. 30:632.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42335535-c60c-5640-bfc8-3821367d83c6','','','Trans. Linn. Soc. London 7:20.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5caaa44-ad22-565a-8319-052828982ab5','','','Monatsschr. Kakteenk. 5:102.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f37128a2-991f-5bcc-b1f9-9d3b27f70152','','','Contr. Gray Herb. 171:51.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f13cb0c-dc9b-5781-aa57-1957bea31f2b','','','Kulturnaya Fl. SSSR 1:366.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0deb1355-7528-5008-a475-6593a71435e3','','','Repert. Spec. Nov. Regni Veg. Beih. 12:382.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f119b764-4abf-5b83-95f5-c9c1297f30e8','','','Fl. Brit. India 5:758.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bf736e3-82b6-5cc8-bc6f-dffef8105f50','','','Bot. univ. 1:172.  1770 (J. B. A. P. M. de Lamarck, Encycl. 2:486.  1788)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('584427e4-bf8e-5a24-8f13-f4cdd232434e','','','Fl. nov.-zel. 1:55.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1ebed20-f44e-5834-aea0-c805ff800007','','','J. Bot. Soc. Bot. France 48:10.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40e797f7-5928-5676-8b0b-d59882a938be','','','Gentes Herbarum 2:241.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6700a086-0810-5305-be6e-de4601f5204c','','','J. Proc. Linn. Soc., Bot. 2:76.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51fc1d5d-d02d-5470-a182-24aff18dc828','','','Mant. pl. 2:268.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f89d765a-450b-57be-bae8-5d4279577484','','','T. C. Whitmore, Tree fl. Malaya 1:381.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a65b27a-1b88-5255-bb01-a90866f02824','','','Phytologia 31:481.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1df628a1-075f-5c04-ae92-04df7f503085','','','Symb. antill. 1:325.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d401c916-17ac-5642-8eff-d7febe0596fe','','','Linnaea 12:467.  1838 "<I>gmelini</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7a61c3d-fbf2-5c83-8f42-df17e4cfdc03','','','S. W. Naturalist 15:391.  1971 "<I>macera</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce097f02-5736-5e0a-b675-6528a66ed48b','','','Bot. Mag. (Tokyo) 43:292.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71f93c77-89a4-50cf-bfc0-9c92e428e197','','','Mus. bot. 1:361.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58893f9e-607c-5bf5-89e7-af1b088e6c01','','','Select. stirp. amer. hist. 283, t. 183, fig. 92.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b371ecb-e50e-524c-896f-7e98e496bb72','','','Ann. Missouri Bot. Gard. 28:222.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdf5a9bf-0c56-50bb-a8e8-c648dacfa1b3','','','Monogr. Campan. 340.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2885d7c-f3be-5ec5-b765-cacc99b6b2a2','','','Notizbl. Königl. Bot. Gart. Berlin 5:260.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a123e15-22ac-59af-a283-1e67c15dcd42','','','Index sem. (Agron. Investig. Nat. Hispan. Inst.) 1968:43.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bc13e96-0637-52d7-9294-67c4cabd6b2d','','','Fl. ind. ed. 1832, 2:566.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('017cb5df-e1b8-5371-99f1-5ed586fb829d','','','J. A. Murray, Syst. veg. ed. 14:331.  1784 May-Jun (Fl. jap. 138.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30bcacf2-f8f5-521a-bcc0-4b39756b8d82','','','L. Bailey, Cycl. Amer. hort. 2:913.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4137e4f3-33c5-57b0-81c6-066f6945553d','','','Ark. Bot. 11(9):15.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4de82173-fd98-523d-8aac-0bd1b96a8d38','','','J. D. Hooker, Fl. Brit. India 1:407.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63597a83-00bd-5eff-ac88-4d81d3e16a4d','','','Novosti Sist. Vyssh. Rast. 21:230.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10a815f3-2bfe-5054-8f37-4511d43db0e1','','','Muhlenbergia 4:40.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3e84b7c-5e9c-50e9-8fbe-895ea76e7fda','','','Interpr. Herb. amboin. 133.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14198838-53c5-5687-8c0e-6cffd1380ad1','','','Observ. bot. 5:23.  1788 ("1789")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('055744cf-a87d-5140-a5c4-bd549f0dfb23','','','Hort. brit. ed. 1:112.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11d2c318-25a5-57fb-b778-f73e5a8a8ed7','','','Fl. Tasman. 2(6):57, t. 133.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78f98f34-7906-5117-854f-279d1cbe7ed7','','','Tent. fl. abyss. 2:431.  1850-1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e11d7688-5ad0-5412-9c51-a7a1ec59fe14','','','Proc. Arkansas Acad. Sci. 29:68.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f16bfd2-9f06-5961-9a12-8928e364d0aa','','','Trudy Bot. Inst. Akad. Nauk S.S.S.R., Ser. 1, Fl. Sist. Vyssh. Rast. 4:321.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f68c3059-a66a-540a-a073-b1510be0a158','','','Trudy Prikl. Bot. 53:44.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a860c517-840e-5c39-9569-3b48604845ed','','','Compos. ind. 122.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d672946-e6c6-5eb9-b9b3-0e73a72e8067','','','Fl. ind. ed. 1832, 2:387.  1832 (Hort. bengal. 32.  1814, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('626a0c8f-da27-5dd4-ad07-ed8d065f87bd','','','Bot. Mag. (Tokyo) 39:28.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec8c3f87-ef4c-5a7d-b7bd-d1f99f2abcff','','','Prodr. 1:537.  1824 (H. T. Colebrooke, Trans. Linn. Soc. London 15:367.  1827)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('265452dd-36ae-5a0e-baee-b0f6677842f1','','','Rhodora 42:254.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08557abe-eb27-56e9-aac7-3d35b02de591','','','J. Arnold Arbor. 33:57.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('989e2eac-ba84-5351-ae8a-4680d38b0078','','','Taxon 58:1345.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2343361-70c2-5774-a138-d12791c2501b','','','Acta Bot. Bohem. 2:41.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a937c2de-1366-53e3-a0bc-4ebe90e7f0ec','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 3(2):243.  1875 (Allior. monogr.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7b0884b-38ae-5a7c-9131-7db8a976f5a9','','','J. Proc. Linn. Soc., Bot. 7:28.  1863 ("1864")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('134d684d-2f28-5b93-a327-a0d7c02b5d9b','','','H. Ohba & Malla, The Himalayan plants 1:228.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e20edbea-e025-5bc4-bdb7-d5524dfbd624','','','Contr. Gray Herb. 68:75.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f65f71d-1d4c-5b9f-b284-03320dfadd81','','','J. Torrey, Pacif. Railr. Rep. 4(5,1):101.  1857 ("1856")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1aa8ca46-ded3-59e3-8658-029a3c6b60ed','','','J. A. Murray, Syst. veg. ed. 14:888.  1784 May-Jun (Fl. jap. 149.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9dedbef-3e7e-55e7-a4a2-1490da095458','','','Bot. Misc. 3:306.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfc47ab4-5bab-54ae-b399-d6bd5d055fc4','','','Rec. Bot. Surv. India 4:272.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd417543-66e1-5592-a74b-1f353e6e46a4','','','W. T. Thiselton-Dyer, Fl. cap. 5(1):144.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0132916a-d932-59ee-88c4-1f0d588167ff','','','Ann. Roy. Bot. Gard. (Calcutta) 9:32.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07ff7bbe-660a-525f-a360-ba07fa33ec55','','','Syn. pl. 2(1):181.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5598e3c3-e542-52bb-954b-3b8773e1833f','','','Icon. Pl. 9: t. 849.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('816e7719-ee13-59ac-b08b-c50fbfd16570','','','Observ. Trifol. sp. 31.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e5e0f13-25a0-5e26-a2b5-7910d686a6fa','','','Gen. hist. 1:516.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a692f023-f20e-5d43-bd92-67aaa0590f48','','','J. Bot. 73:128.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d143f853-0d77-5938-848a-c9584f1d86c9','','','Coll. bot. t. 33.  1821?','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0563d4f0-af43-563c-9374-f31c4d4498ae','','','Prodr. 2:191.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8be692eb-98b4-5f2c-a66c-d568fe9f2e70','','','Proc. Amer. Acad. Arts 8:296.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ca891ad-dc84-51e6-a802-10f5b24b3292','','','J. Straits Branch Roy. Asiat. Soc. 35:80.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed3241fc-86f3-5a13-9256-71c848f4f5c5','','','Mimoses t. 46.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('538a7267-0196-53c3-af74-525d22ac9e43','','','Compan. Bot. Mag. 2:354.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e493f025-f13d-5e67-99d8-d215910a6cfd','','','Sp. pl. 5(1):172.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83d3d465-bdd2-58d3-8848-a0edda34d598','','','J. Adelaide Bot. Gard. 5:230.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f9903db-8713-5569-94ae-8fa7398dcf04','','','Enum. pl. 2:903.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b794431-dacc-5a00-86db-be7920fb4e65','','','Cact. 3:209.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd2f550e-7f05-5a3a-b9f2-a2df99ebd368','','','Rhodora 49:159.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cafdf5d-4aff-53fe-9a87-1dc1758263e8','','','Mexic. pl. 2:28.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7a862a5-bb98-5f55-9252-863e9a41a787','','','Bot. Zhurn. (Moscow & Leningrad) 81(8):80.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('354169ab-083b-554d-b465-01ce9d6af748','','','Kulturnaya Fl. SSSR 1:191.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e3810cb-2b3b-5a16-b070-51ec3fa77e6c','','','Brittonia 65:6.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('159139aa-fef8-5cba-98af-72d38ac5ae9a','','','Enum. pl. Jap. 2:471.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d28d791-475a-57e2-ba80-07dc68700802','','','Fl. Parma 128.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8ca2ebb-d8bd-5408-933f-92dea7a9ada4','','','Dept. Agric. Bot. Div. Bull. 8:25.  1889 "<I>reverchoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c964632f-eb96-5fdd-83f2-6f0befb2b3d9','','','Enum. syst. pl. 36.  1760','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9d15228-2993-549d-accc-6d1175d0733b','','','Syn. mitteleur. Fl. 2(1):679.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0251bafb-7461-5598-ab3d-fffbfeaff795','','','Pap. Michigan Acad. Sci. 13:213.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdd83bf6-8bad-59a8-b152-efcc9fac68c7','','','Fl. ajan. 187.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79557d32-b5af-5684-a2b9-a5671054a55c','','','R. Wight, Contr. bot. India 89.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c256501a-7d80-5682-bc32-b54eeca88349','','','Contr. Gray Herb. 200:40.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87578ddb-a3ff-5883-a91a-d45a105c3986','','','Hooker''s Icon. Pl. 16: t. 1600.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbfb027e-40b1-5b8f-9f3d-91dc8f332b26','','','Hort. brit. ed. 2:343.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f4ac27d-5527-5e58-98c9-c65e5979e3c8','','','W. Roxburgh, Fl. ind. 2:408.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f17cf305-de6b-5867-808f-4b3cb86450fd','','','Desert Pl. Life 6:68.  1934 "<I>collomae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88e6b078-5bb8-5312-bb6c-1ae9c4b03248','','','Curtis''s Bot. Mag. 29:268.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66caaf90-f02d-5202-bb89-be5a2eed0633','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 2:406.  1873 Jul (Gartenflora 22:236.  1873 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97a232eb-cf20-54b8-ae04-23dae89d660d','','','J. Coll. Sci. Imp. Univ. Tokyo 26:276.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97a82068-127a-553f-8cdc-210a299cd7b5','','','Bot. Jahrb. Syst. 74:630.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cef0b61-cf0c-555d-8d10-851b73c43f22','','','Gen. pl. 3(2):832.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e6fc7a5-678e-5fb8-a819-d1e5ae92a861','','','Elench. pl. nov. 15.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ad14ed8-09d7-54d0-8322-f721a59be8ff','','','J. A. Murray, Syst. veg. ed. 14:818.  1784 May-Jun (Fl. jap. 30.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a58a24bf-88a9-5272-a936-0e445d749d06','','','Philipp. J. Sci., C 2:259.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30f90c08-6d08-55eb-b685-c3a8e289c5a3','','','Sp. pl. 1:268.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd427cbf-beff-53a0-aea0-b61acc0e5e15','','','Auct. fl. pedem. 40.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abf427ba-6f11-5362-821f-4ac90ab742e3','','','Trans. Amer. Philos. Soc. ser. 2, 2:173.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49334e24-7ea8-5626-9237-de0c464b8e49','','','Sovetsk. Bot. 1:28.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('750e0b02-ec66-572c-96aa-d55b39e3e2f1','','','Index sem. hort. acad. gotting. 1832:4.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('524c2a43-3d3c-52e3-8d9d-df4e0dc42682','','','Acta Univ. Lund. Afd. 2. 33(12):115.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed78ba56-e911-5658-b40b-c2bc31f59344','','','Beih. Bot. Centralbl., Abt. 2, 34:234.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4556c19-3e39-5df5-bce7-a482328cdfc4','','','Centurie de plantes d''Afrique 67.  1826 (F. Cailliaud, Voy. Méroé 4:360.  1827)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('208b6a6d-143b-54dd-9fd7-456e70740fca','','','Kew Bull. 57:613.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('616621c4-5c57-541e-b934-c0118ecb474e','','','Prodr. stirp. Chap. Allerton 297.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5780f2b0-1bfe-53b8-83d3-a63c56fcd295','','','Linnaea 31:549.  1861-1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3fe6b59-b053-5e76-86d7-3e597c89ea4b','','','Sp. pl. 2:851.  1753 "<I>luteo-album</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b781ff64-7082-5020-bd75-9400630e6655','','','Philip. J. Sc. 10:400, t. 14, figs. 6-10.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebec0b46-71e9-5570-8336-211af5900308','','','Madroño 55:188.  2009 ("2008")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18218dbe-6c1d-518f-84e8-610e3cb676f4','','','Bot. Zeitung (Berlin) 23:146.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1972a0ae-299f-5fa3-b3db-71f753812c24','','','Dendrol. Fl. 134.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9790f44-fe46-5d1c-ab4e-cc4522fdfef4','','','Bot. Mag. 54: t. 2762.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f92faaa9-b7f8-5d53-bafd-c846e1b1dfbf','','','Mem. New York Bot. Gard. 65:298.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5a686b2-af0c-5a88-927f-e627e5844470','','','J. Linn. Soc., Bot. 38:363.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1848c1a-6f3b-534f-b55a-f4718ac078b6','','','Pl. asiat. rar. 1:77, t. 86.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a522682-1570-5619-92e1-da07982539b1','','','Rec. Bot. Surv. India 4:5.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('226f9bb5-0002-5c57-8106-f43512cfbbbb','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger fl. 320.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee3cedc7-f796-5d05-8752-59439589d243','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 3(2):164.  1875 (Allior. monogr.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a715cc38-5fa4-5505-9f25-e6b43747b90e','','','Bull. Bot. Res., Harbin 1(1-2):88.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03cdec90-4916-564c-b17b-4e28cc5674cb','','','Sitzungsber. Ges. Naturf. Freunde Berlin 1876:164.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('796efb8a-f0f8-51ce-b4b9-2c6e8c0b137f','','','öfvers. Kongl. Vetensk.-Akad. Förh. 12:166.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a837027c-3a31-504a-b88d-4a070e6457bd','','','Willdenowia 33:53.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d77c273-d3cd-503c-a346-1b8892af16b3','','','Linnaea 5:205.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('829fcdd1-3dfd-54e8-9a89-b485160fb898','','','Edwards''s Bot. Reg. 15: t. 1229.  1829 "<I>frigida</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8022fe58-11b2-52ba-ad7e-5669431a78d9','','','Bonplandia 8:138.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a3ff1f4-f323-51fc-9522-03709ff5f650','','','N. I. Kuznetsov et al., Mater. Fl. Kavkaza 3(7):52.  1908 (Fl. Caucasica critica)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edb02a5c-a53c-51ca-9a79-d26012b39a02','','','Bot. Mag. 77: t. 4604.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9561cb1f-62b7-59ef-b697-6befcb3e6622','','','J. Proc. Asiat. Soc. Bengal ser. 2, 4:189.  1908, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fbc95e4-f610-5445-816e-2be0317c85ae','','','Tijdschr. Natuurl. Gesch. Physiol. 9:164.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a961b653-86e7-532f-86cd-da4fd278d550','','','Lloydia 11:309.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aacb9e3c-2d11-59d8-ad65-7e8d7a7bf1fb','','','Nov. gen. sp. pl. 2:68, t. 194.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f796aea-cbdc-5593-8ac4-0e8bd350095b','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:390[folio]; 6:499[quarto], t. 583.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0d4cacd-734c-5871-85ff-43a5ceab6c3c','','','Trans. Acad. Sci. St. Louis 1:497.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('192418d0-47d5-5a24-bda5-ba47874b0a2b','','','Acta Phytotax. Geobot. 1:14.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c9c6a0f-5899-576d-8023-458b953d3b77','','','Hist. nat. palm. 3:314.  1849 "<I>olivaeformis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9712e406-9b3c-5599-ab94-92621607dfa7','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 12(2):124.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f590a1e-83c7-57dd-94d1-46454b2f31fc','','','Fl. cochinch. 1:143.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c76fe242-82b0-5f84-8be0-26979b3fb6b0','','','Candollea 24:170.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed39d5c2-5f4a-5b8d-9ff5-54a18cb94c33','','','Collectanea 2:349.  1789 ("1788"); Icon. pl. rar. 3: t. 572.  1790 ("1786-1793")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5acecda1-e919-574e-9cc9-b2130c6ed216','','','Fl. Brit. India 1:451.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c28c5b15-800a-5122-833b-a664831cee26','','','Agric. Colon. 10(2):513.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce8df40b-0724-591d-8e3e-f9a8f222c075','','','Gard. Chron. ser. 3, 44:101, t. 37.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e63debb-7bb6-5b19-860e-9267020693ec','','','Zoh. & D. Heller, The genus Trifolium 175.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07138596-06b0-5078-9830-279eff6af769','','','Hort. kew. 3:214.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73a05603-a496-5473-b2cd-1ff6c5b1e173','','','Gatt. Pomac. 21.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cc8b980-f7f9-59ee-9b12-5b0cdb12d004','','','Descr. pl. Malmaison 110, t. 45.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11321147-eefc-5423-b9d5-2d7ab5115ada','','','Kom. & Aliss., Opred. Rast. Dalnevost. Kraya 2:683.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88fea192-6e9a-5bd9-ad5f-d9874fcfc02e','','','Ann. Missouri Bot. Gard. 20:297.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcca2963-41c7-57e8-9244-7053f56dcb10','','','Tabl. encycl. 1:425.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd69ce3b-54e8-5ee5-b31a-cb18a2093274','','','S. African Gard. 23:47.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2ae873a-3b88-5634-bf6e-acdc74b057fc','','','Suppl. Meth. 64.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b20411c-3bdc-5404-b929-f2417001a6ac','','','Syst. veg. fl. peruv. chil. 208.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6282f73-634f-55a7-8a0d-c34997f03efd','','','Aliso 4:437.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f596233-7504-59db-8449-27a6e63b4314','','','Contr. New South Wales Natl. Herb. 3:159.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16893710-5c21-5aae-a7ba-d793f8b3ed6b','','','Z.-Y. Wu & P. H. Raven, Fl. China 11:127.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a226ab1c-4813-52b9-b3ff-6e93d3d347cb','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 8:432.  1883 "<I>glehni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2860f2c2-4016-52d8-a559-b519ae49e35f','','','Hort. dyck. 360.  1834 (G. Don in J. C. Loudon, Hort. brit. ed. 1:196.  1830, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae090f75-400b-58f7-a4cd-b0925d8385e0','','','Webbia 9:499, t. 7.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07586d76-588c-5bd4-9e82-b92e101d4e00','','','Blumea 44:189.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60b9d053-1d20-53a9-8a86-ad3bfaa33456','','','Kew Bull. 1939:2.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8232ccd-d412-5c88-91b5-db477ced928c','','','Dendrol. florest. 55.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e64d91d8-09fb-514f-a5fc-d02ddbec93f2','','','Ill. <I>Cinchona</I> 8.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ece61ed3-b8a9-5ff9-8c9a-5f69ed679250','','','Bull. Jard. Bot. État Bruxelles 5:175.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f744a83a-9d04-5128-8fda-5edd7407e056','','','Fl. napol. 4(syll. app. iii):iv.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12a4c7a4-7742-56ba-bb08-7b8de1a348fd','','','Bot. Reg. 14: t. 1132.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('307ea370-adf3-50af-bf15-cc8dc139e301','','','J. Arnold Arbor. 9:3.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3c7e928-9bfe-511c-8431-1e9fd7fe7ddf','','','Syst. veg. fl. peruv. chil. 128.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ace82492-c549-56de-851d-5f1ab41f6acb','','','Autik. bot. 95.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('991dfbc1-76e8-594f-93be-02d8504b8cac','','','Willdenowia 17:13.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c82a09d-8a79-5551-b604-69e88da5cf19','','','Ann. bot. syst. 2:529.  1852 "<I>meliaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62c1eaf5-4fcc-5627-95ed-1822cae59a63','','','Brit. fl. gard. 2: t. 178.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1bee993-3c84-54f8-a80c-4bd0d441eba1','','','Nomencl. bot., ed. 1, 1:128.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d692cbb-8967-5e2f-9e55-b3fb8b80959e','','','Ros. monogr. 35, t. 6.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97521a71-077a-590e-a4a5-e718f7668cc3','','','Cact. Succ. J. (Los Angeles) 27:166.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75973129-8182-5b8c-a542-3213d11a3673','','','Bol. Soc. Brot. sér. 2, 12:240.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89492a4d-9e03-536a-bfeb-65c6306d1ae2','','','Ann. Sci. Nat., Bot. sér. 2, 6:366.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2f9fac7-7588-5562-88d2-96811bfb8216','','','Taxon 32:440.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38ab0ced-d965-52da-a09d-a961ffec19a6','','','Meded. Rijks-Herb. 61:6.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c22eb660-46a6-52e7-852f-a4306d383eab','','','Pl. aequinoct. 2:32, t. 80.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d7d6619-bf4e-5fbf-9b9c-31a9a9fdefef','','','Collectanea 1:93.  1787 Jan-Sep ("1786"); Icon. pl. rar. 1:8, t. 75.  1787 ("1781-1786")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30f89c18-8d8d-5d13-bf0b-fbfa2d8bbb3b','','','Fam. nat. syn. monogr. 3:139.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cda2acc7-f0da-5510-91ad-43785dc5d52b','','','Fl. forest. Cochinch. 1(fasc. 6): t. 90, fig. B.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95fe8169-8217-5192-90eb-bed3000845c6','','','Ann. Lyceum Nat. Hist. New York 1:154.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bb60ef3-f5d9-54e1-a1d0-97d251253b1e','','','J. Linn. Soc., Bot. 22:38.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2656f4b0-56d2-55e7-8be9-c88c3c0f581f','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 8:238.  1886 (Pl. david. 2:56.  1888)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e56242f0-ce66-5a39-886b-c091ad4e4363','','','Bull. Torrey Bot. Club 24:302.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5247089-fbd7-57fd-b932-cf0e86adce30','','','Contr. Gray Herb. 52:70.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82c8152b-1027-5a63-8a61-ea928ba78034','','','Ann. Missouri Bot. Gard. 78:674.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bb19435-8f55-5310-98d4-0cd78878f827','','','Bull. Torrey Bot. Club 86:379.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2597656f-8a46-5a35-98e8-3cb12c77c02f','','','Bot. Jahrb. Syst. 33:180.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f454641-3f3e-5304-b8ec-9144a000ea7e','','','Notes Roy. Bot. Gard. Edinburgh 5:301.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5153680a-5e8d-5606-bb1b-85245f75a154','','','Ann. Sci. Nat., Bot. sér. 2, 4:348.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('036d855b-61fa-59d6-b160-bc729832280b','','','Nov. stirp. bras. 77.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96c61dea-977b-5d3a-b678-1417aab8176d','','','Studies in the Calenduleae I. 259.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3f9b566-e2d0-5b69-bfa4-3edf6daec648','','','Linnaea 11:419.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee577aea-2594-5702-a922-12d3e0d45ae3','','','A. Cronquist et al., Imtermt. fl. 6:534.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f094b31-07ce-532d-a86b-84277880dcbd','','','New Zealand J. Bot. 1:96.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ce1399a-4508-5bc6-b8f6-ba129e339682','','','Repert. Spec. Nov. Regni Veg. Beih. 1:873.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35d5c36d-7181-5416-b90f-8a330f2f3434','','','Reinwardtia 2:150.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('443a88c4-932b-527b-86c2-a39084859c69','','','Bull. Acad. Int. Géogr. Bot. 16:74.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1bb872d-79d8-5003-9067-10fe140cae10','','','E. H. F. Meyer & J. F. Drège, Comm. pl. Afr. austr. 100.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bf514b5-0607-5172-91a2-899ccbe043ea','','','Kew Bull. 25:211.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3f3a588-7bf9-5e14-8ac6-8062f44cd8f1','','','Madroño 11:174.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c636004b-8547-5b63-9080-2ee286d7a0e4','','','Bull. Herb. Boissier 6:510.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86fa5cda-c6c0-59dc-8ec8-091531adf382','','','Ann. Mus. Congo Belge, Bot. sér. 5, 1:146.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7dcbe408-0acd-5825-a0a4-3345b3111da8','','','Prodr. 2:312.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32ad15cb-f9e9-5b5e-8373-ec6a5ea2da60','','','Collect. Bot. (Barcelona) 14:95.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29559ca2-0daa-5842-8a57-604bdc0d3b2a','','','Bot. Repos. 1: t. 6.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc0c743b-c1cc-5a81-a430-6893eea76fce','','','Hist. pl. Guiane 740, t. 296.  1775 "<I>odora</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b571d40-8bc6-53a2-ae07-d270a21b89cb','','','K. B. Presl, Reliq. haenk. 1:330.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab8385ab-bb79-554d-9fa1-f9831ce895af','','','Proc. Amer. Acad. Arts 25:124.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b050a43-5478-54f9-969c-bd879e85233a','','','Bull. U.S.D.A. 772:145.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('473f5a41-a051-51a4-9850-41286bb97d07','','','Gen. Cynaroceph. 12.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c370051-a725-5894-b149-1bb1b2ecb7e5','','','Contr. U.S. Natl. Herb. 20:217.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5573fe9a-f779-5a0e-9107-3c161cf39c18','','','Fl. jap. 1:86, t. 41.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53069eba-1430-542e-9b23-b332b943fa59','','','A. A. Bunge, Enum. pl. China bor. 71.  1833 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 2:145.  1835)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('257cd04e-0650-5cc8-b32b-a448bb15caaa','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:260[folio]; 1:324[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e4ae0d7-7c2b-5b87-a902-dd4391878e2a','','','Darwiniana 5:88, fig. 3.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bce70884-c405-56b3-a6ad-501f5e160389','','','Bot. Jahrb. Syst. 76:81.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18f5c4b8-5851-5178-a49e-81cb0c3ec5be','','','Gard. Chron. ser. 3, 13:384.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc9a0912-330c-52be-a8b3-fec66ae10d13','','','Bull. Jard. Bot. État Bruxelles 20:316.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba5cba1a-ab18-56c4-82b4-c11d051040a0','','','Mitt. Bot. Staatssamml. München 14:522.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e50e9c56-7ebd-5961-bf62-d56c7c1d0c64','','','Taxon 44:202.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b67c825-34a3-59b3-aa3a-96c7fd4bc129','','','Fl. ind. 1:423.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8484384-4fa5-515a-8bd2-ffb8410ce89d','','','Fl. Pl. South Africa 22: t. 853.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c64bdfd-25fb-5e5c-8f11-7243a92433b0','','','Plantsman 17:200.  2018','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59f0a1e4-ead9-5e70-9314-8e7c8c12fc45','','','J. Arnold Arbor. 21:263.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cc6ba23-008b-5118-ba90-772a58fa2472','','','Syn. pl. 1:80.  1805 (non (Gouan) Huds. 1778)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30607f7e-cd35-590e-8ff1-dec59726385a','','','Trans. Linn. Soc. London 11:213, t. 17.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d49b4a4-b7a9-5db6-89f0-5693321657f8','','','Sp. pl. 2:880.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47ee39f8-8389-52dc-9628-64f74a2679e8','','','H. Bolus & A. H. Wolley-Dod, Trans. S. African Philos. Soc. 14:20.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92f02991-1702-539e-8ecf-4fbf9f0546cd','','','Bull. Misc. Inform. Kew 1894:21.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5ff4ad0-13f4-5c64-9f55-f2635a365336','','','Edwards''s Bot. Reg. 23: sub t. 1920.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6f6fff0-e0ab-59a9-8038-72f8dbc63fa7','','','Arch. Biol. Vég. Pure Appl. 1:35, 62.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b052468-ea1d-52a4-b8f9-4c8ddd113807','','','Kirkia 7:156.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53df815a-f798-5bee-a20a-accfabe1a26d','','','Pl. aequinoct. 2:69, t. 100.  1811 ("1809")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd3ae376-8335-5d79-a3de-197489d0c70f','','','Fl. aegypt.-arab. 7.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38ba9a34-75d2-5db3-9ef0-9bfe89767aba','','','Beitr. Naturk. 7:21.  1792 (non Mill. 1754)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c21a85e9-ebfa-50a0-bccf-57d5f295f6f1','','','Fl. taur.-caucas. 3:641.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('180e156e-bf66-523f-9b04-8d58bb22bd10','','','Oesterr. Bot. Wochenbl. 3:12.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44438970-643d-5eb3-9f42-6dae52ed83ce','','','Phytologia 54:494.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74d575e7-8037-59ef-8e22-109b8cdd7fef','','','Möller''s Deutsche Gärtn.-Zeitung 46:267.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ce2d68d-bf4f-5cc3-9ae1-eec3865b5d0b','','','Torreya 21:50.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cfcafa7-ae6d-5d58-8e56-5da7264e35b2','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 15:71.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b758d5c9-0503-574b-b7c4-be51247c5461','','','Brittonia 27:56.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2c97a4e-bf6e-55cc-80f0-e59adf8be71e','','','Bot. Jahrb. Syst. 30:360.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('898732dd-c509-5b68-b936-1c70014b3135','','','Trans. Nat. Hist. Soc. Formosa 3:62.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b453774-f812-5f20-90cf-df1d9c76245f','','','Mém. Mus. Hist. Nat. 9:351.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ec3f0eb-56d4-57cb-978d-872aba452bc7','','','Gard. Chron. 1871:902.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ca78c56-c11d-570c-8140-7a302090f9f6','','','Philos. Trans., Ser. B 199:190, t. 24.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23807f66-8f59-54af-b233-3d066aa5e807','','','Prodr. 252.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9df5fc58-82f9-524c-8604-74131a1f986f','','','Diagn. pl. orient. ser. 1, 13:56.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86de9baa-c738-5c84-945b-31024706fcf8','','','Révis. gramin. 2:549, t. 189.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd25989b-9036-5a6d-ac1e-68d80a269aef','','','Bot. Mag. (Tokyo) 18:33.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b87f08e2-1564-5339-84f6-21f8bfd72243','','','Enum. hort. berol. alt. 2:289.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b164d99b-64f1-5ac0-aa71-5b88008c43eb','','','Flora 68:139.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73e687f4-1019-5ba2-8d7d-b3367124c3c0','','','Contr. W. Bot. 10:58.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a62c9ad-6e7d-5ca5-a0d3-e10506de5a96','','','J. G. C. Lehmann, Pl. Preiss. 1:641.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71706006-ecc4-5eae-9a97-9679bbd59042','','','Fl. chil. 1:212.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50f4b5c7-3cda-589a-b2da-27fa624c182e','','','Syn. fl. N. Amer. 1(1):199.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8879f95e-00a8-5146-8c8a-2676da845d68','','','Hooker''s Icon. Pl. 19: t. 1897, note 12.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1fd5d47-433e-57d0-aca8-5fa25add5add','','','Summa veg. Scand. 1:175.  1845 "<I>nigra</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af8286c1-aa10-550f-81e0-bbf43b9081bd','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 8:685, t. 12.  late 1884-1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87ebfd02-e0b5-504f-a35c-9f8d5ed71d78','','','Cact. Succ. J. (Los Angeles) 14:34.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fdfca94-113d-5345-91d5-b7d98784be11','','','Hort. Brit. [Loudon] 1:380.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81fe71b9-0439-5edd-9320-dedfc6c4d03b','','','Schumannia 3:188.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf91e8b9-e095-572c-9cd0-87e0924a9959','','','Ess. Agrostogr. 162, 177.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1da183b9-6b9e-59de-a8cd-a930e13d8bbe','','','J. Bot. 20:69.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b31db661-df40-5e00-a6e9-391547d07050','','','Ann. Mus. Bot. Lugduno-Batavi 2:250.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a49e5c78-d9cf-5939-8764-ad697ed29e0e','','','C. Gay, Fl. chil. 1:167.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e02eb69d-f25f-5bec-ae5a-51c47b74ec42','','','Hooker''s Icon. Pl. 11:37,  t. 1049.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4275e0b-b9ed-5336-8af2-6c320e1e41b2','','','Labiat. gen. spec. 714.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e65cb54-9e7e-5a89-8310-523653f59fd8','','','Symb. antill. 5:371.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07c14e47-5003-5b2b-baa0-d9df7692a4fe','','','Bull. Misc. Inform. Kew 1932:447.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da678620-8c7d-524d-96fa-9e14ec560d13','','','Verh. K. K. Zool.-Bot. Ges. Wien 18:651.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3279dd8-75d3-563a-8eff-40d01c38e818','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 4:62.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f170e934-19df-571f-942f-45d091179c22','','','Philipp. J. Sci., C 13:314.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('787b7d7c-1ccf-5f6f-88f3-7a750afd0a79','','','Ann. Lyceum Nat. Hist. New York 2:224.  1827 (Acct. pl. Rocky Mts.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56a63953-1be1-5a7f-b341-4dd2ba50d2b0','','','Parad. lond. 2(2): t. 116.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f84731be-c0cd-5894-9509-dbc96fbd03af','','','Pacif. Railr. Rep. 12(2,2):42.  1860 (Bot. Rep., Expl. Miss. Riv. Pac. Ocean)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d02cb96b-bc5b-5109-bc97-10abd789937c','','','J. Coll. Sci. Imp. Univ. Tokyo 12:490.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e94081ce-043b-5d1c-abd0-5a1525499894','','','Baileya 19(4):171.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa8373f0-8c52-5736-8de3-e787501c1aa5','','','Madroño 15:215.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6715a0a-c583-531b-95ee-cb0b34514daa','','','Bull. Misc. Inform. Kew 1909:65.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2ed5f1a-1382-5096-b9f3-cce6b321949e','','','Mant. pl. 2:227.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8465964-0ad7-5847-9982-c3e2c092e7d4','','','Sida 19:600.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('824d512c-79c2-5036-9996-3e8e21603d29','','','Contr. U.S. Natl. Herb. 1:208.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21df56bb-c675-5611-abed-3f0245f68920','','','Prodr. 8:672.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79fe8116-ec20-59b1-88b1-64240c89a5d0','','','P. E. Boissier, Diagn. pl. orient. ser. 1, 13:64.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20c687ce-3d93-55c8-acbc-bf721db3dabd','','','Suppl. pl. 285.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8dbafec-9468-585b-ab1f-48be5acbe34a','','','Notes Roy. Bot. Gard. Edinburgh 23:463.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6e5070b-c733-58ed-82cb-5ffab7944be0','','','Stirp. nov. 170.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d08f156-3328-5dbe-81b8-ed67fc98bc98','','','Vég. util. Afr. trop. franç. 5:163.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e0f8a8c-8b97-5d8b-8762-4b1c18f51026','','','Bijdr. 464.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56fa4a88-7626-5564-9605-a8bd0be6f615','','','Bull. Soc. Imp. Naturalistes Moscou 11:337.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a7bbade-85af-534d-9ba7-936156b78afe','','','Repert. Spec. Nov. Regni Veg. 23:224.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1adf2e5-fcb5-581e-bc39-c90f1a226321','','','Acta Bot. Yunnan. 12:26, fig. 4.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe18d5fe-dd27-5346-8c38-13b791456ca3','','','Brittonia 26:60.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e3dbb23-f925-5aec-a5d9-fa7214f3e124','','','Amoen. Acad. 4:478.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbf4600f-9b0a-505c-9dae-3bafbeb54da7','','','Novosti Sist. Vyssh. Rast. 1964:219.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dddc635d-1c75-5200-a639-1b0c76a7ff6f','','','Fragm. 3:57.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49555835-5d7c-5fc7-b02d-05529f2fe151','','','Tent. fl. napal. 20, t. 11.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2eea26d9-2931-53b1-9408-c6102fc4923c','','','K. H. Rechinger, Fl. iranica 34:25.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8dd1c16-b07b-5bf5-937a-ef42e72e7180','','','Bol. Soc. Aragonesa Ci. Nat. 15:95.  1916, pro. syn.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25720ec9-6fc9-5313-8645-c583277db715','','','London J. Bot. 2:411.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adc26073-2535-58a3-b95a-86a9539b2020','','','Trans. & Proc. New Zealand Inst. 29:391.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64d5457e-6db1-5c7c-9bcb-62bbd382d781','','','Gen. pl. 1:588.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e31dad53-3799-55ec-a893-cbb5d58fa0e6','','','Saxifrag. enum. 2:116.  1821 (Revis. pl. succ.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afa0b64b-6bd6-5d89-b453-aa5bbe06cf90','','','Acta Horti. Gothob. 5:89.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18273579-3531-545d-bc95-d2b0fc806d47','','','J. Bot. (Hooker) 3:241.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2dc79f0e-789a-5f76-8e54-19d112b32622','','','Annus hist.-nat. 2:64.  1769','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9467f2ae-2291-5d36-8233-c12c259f38af','','','Fl. austral. 1:319.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54a9bdce-dab9-50ea-862c-ab8d7c57f44f','','','Fl. Australia 48:716.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d56664d4-beb7-5766-a361-57c359edc756','','','Zametki Sist. Geogr. Rast. 32:21.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('119d5935-b701-5890-97b0-85e8136edd13','','','Zhukovskii, Kul''t. Fl. SSSR 20:64.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('def735b6-1990-58ef-b53b-3cfb39f24412','','','Fl. Frankfurt 1:220.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f35ab93-a3b6-547f-b5a6-b26983bbbd42','','','Amer. J. Sci. ser. 5, 3(= 203):89.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4005e859-41ec-5e4b-9782-e1150459bc4b','','','Great Basin Naturalist 34:163.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34b79508-4c2e-5f3f-9405-ff60773cacd6','','','V. L. Komarov, Fl. URSS 11:151.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00c5c2a5-a855-5ff5-bd24-c35fd9c385c8','','','Pl. rar. 390.  1826 "<I>olivaeformis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81396ecc-486f-5fea-8a21-8ca572b81bfc','','','Beitr. Sukkulentenk. Sukkulentenpflege 1941(2):31.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('241bb14d-40e3-5559-a5a7-5284e1656456','','','Trees shrubs Japan ed. 2:665, fig. 300.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('822b88b2-6db5-5821-9f12-c0ceec4234d0','','','Descr. pl. nouv. t. 39.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('255f1747-808f-549f-b5bf-7cc869781031','','','Bull. Misc. Inform. Kew 1910:113.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e91cbb83-3cc6-5620-8b3c-f7cf64190cea','','','Prodr. fl. nepal. 218.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2896fa15-f613-53fc-8491-dfdd2309722d','','','Gard. dict. ed. 8: <I>Lychnis</I> no. 4.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54ad71f6-187e-5a85-954f-17f829347d76','','','Trans. & Proc. New Zealand Inst. 27:353.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64275f61-f60e-5409-a5c6-dbc9ca977f93','','','Biblioth. Bot. 138:73.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bc3f046-9dc7-5ef0-b49e-4b71cad80c13','','','Bot. Jahrb. Syst. 15:573.  1893 (H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(6a):84.  1893 Dec)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a227ba6-b5ab-5646-b71c-23719ecf8329','','','Ned. Kruidk. Arch. 4:132.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85fbbfb7-b57c-5cb7-b8a7-b46866210240','','','Feddes Repert. 101:274.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2cd0601-e74b-507d-92db-2a146ac8299a','','','Kurtziana 10:25.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2828f0a-2e53-5bb5-bb15-5532c93be81c','','','Contr. U.S. Natl. Herb. 12(10):415.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bed6916d-bdeb-58a8-a837-fb0db1dec1cd','','','Bot. Tidsskr. 24:260.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4c0ee71-5193-531e-b4be-643c9d0a39d1','','','Nuytsia 2:108.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('194c4444-925d-5b31-bb3d-0acf6f4e79ab','','','Ann. Bot. (König & Sims) 2:74.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('895b70ac-4ee0-5fb9-b857-9ffd692241ed','','','Edwards''s Bot. Reg. 20: t. 1715.  1834 "<I>Kennedya</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1a9aa9d-8963-57df-8383-9bbd3ce313ef','','','Bot. Mag. (Tokyo) 14:64.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28369d80-2771-50d2-afea-b609dc5be80d','','','Fl. Ned. Ind. 1(1):361.  1855 (Pl. jungh. 401.  1857)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27e37dcd-3dee-52af-b7c3-7e9ffda09f48','','','Seznam 54.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43490fd0-5e11-5e9c-a47f-133da7717a8a','','','J. Jap. Bot. 57:313.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2f8b4cd-b347-577d-9f92-d363e8bb92bc','','','Arch. Bot. Mém. 7:76.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1945aa79-78a4-5ce5-b7b6-6236a067f8ed','','','Gard. Chron. ser. 3, 49:66.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60de97ba-f794-5829-9674-69dd0e4f99e0','','','Rep. (Annual) Missouri Bot. Gard. 22:95.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d69c3b9-cc68-5c0b-a553-1fde33088efa','','','Acta Phytotax. Geobot. 7:43.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d8aef59-0aa6-54dd-9330-e6850015aa82','','','J. S. African Bot. 14:84.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae2f2d34-2959-5520-ad13-282394fbaeb7','','','Bull. Bot. Res., Harbin 12:223.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8e1a47e-aed4-5fcc-a54f-bcabd2dbe9b8','','','Bull. Misc. Inform. Kew 1920:305.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bf886c8-855f-525a-95a4-3af23883339c','','','Mitth. Thüring. Bot. Vereins 30:79.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69a0df54-cf2c-5154-bc3c-64eff186ab12','','','Sp. pl. 3(1):306.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b88a6ffc-786f-5aee-b0b4-55bbea36531d','','','Ann. Sci. Nat., Bot. sér. 4, 11:24.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c287da2d-2a1b-53f2-8178-9316c50a37c0','','','Pap. Michigan Acad. Sci. 9:347.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d6f774f-a3bd-543f-898b-6e545612f959','','','H. G. A. Engler, Pflanzenr. IV. 42(Heft 92):30.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5eed728-c712-50f7-b472-826a47415532','','','Ann. Sci. Nat., Bot. sér. 2, 20:139.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d36e8ba-9248-5e96-a5cb-e08c2fe1244e','','','J. Linn. Soc., Bot. 19:187.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3337ec55-09a7-5659-8ce3-139a50783c25','','','J. Washington Acad. Sci. 45:112.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bd84ed9-4de3-56f6-b732-cf0161799459','','','Bull. Jard. Bot. Natl. Belg. 60:301.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1db439d4-6300-51bc-a50b-3162aa0e3b58','','','J. Soc. Trop. Agric. 2:48.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebcf0716-7017-5407-98b1-41c5ad21a94b','','','D. Prain, Fl. trop. Afr. 9:625.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fb3c392-4e9d-5ff7-ab08-c03f2494af2e','','','Proc. Amer. Acad. Arts 6:227.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a81352b0-13d5-55b4-90e2-3e6e809b888a','','','Trans. Albany Inst. 7:191.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f17a2ee-01d5-52f2-ba0f-b72fcac5db02','','','C. Y. Wu & H. W. Li, Fl. Yunnan. 3:369.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e5d908f-dd49-5b45-be61-facbdb66f81f','','','Proc. Amer. Acad. Arts 16:88.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2700ff17-824a-57f9-882f-8a5fff58fbef','','','Cult. Prot. 23.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb3f04d7-d6db-551d-814c-f8c6a54bba0c','','','Bull. Div. Agrostol. U.S.D.A. 4:33.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5369f4ab-7503-5f00-91b9-21bc68b4c7b0','','','Cat. hort. Paris ed. 3:331.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d0ce17f-ccdc-5280-a8fe-4112b8e91fc0','','','Nordic J. Bot. 16:141.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a49b6b4d-4464-5398-8f3d-876013e0e536','','','Bot. Reg. 14: t. 1187.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6294110-fe0b-5929-89fb-56e9cfda001d','','','Reise um die Erde 1:402.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27d757db-696b-531b-8dc8-95c6ecda56d7','','','Nova Acta Acad. Sci. Imp. Petrop. Hist. Acad. 10:277, t. 9.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('864f097f-0678-546e-bd88-e676024249e9','','','Gartenflora 28:353.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e70a27a3-5ff7-5879-a2e1-48eddc563288','','','Ann. Missouri Bot. Gard. 95:649.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d61b1215-52b5-5fb3-9271-ddbbf3968f4d','','','Elench. pl. nov. 39.  1838 "<I>ramburei</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d047365b-be32-59d4-b444-5c298d6a5c91','','','Bot. Mag. 37: t. 1509.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('183d8886-995f-5736-8c14-c991586f1b80','','','Sp. pl. 1:227.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf03253d-f91a-5bcd-89bf-1d66dd2d5a92','','','Kakteenk. & Kakteenfr. 1937:166.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a494811c-6a3b-58b7-82bc-925fe324fc20','','','P. de La Llave & J. M. de Lexarza, Nov. veg. descr. 1:20.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20e0a65e-7311-50dd-b589-a5df71f8e15a','','','Gen. N. Amer. pl. 1:235.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f65d9c07-0c0a-559d-bee9-2f0c1783ff6b','','','Syn. pl. glumac. 1:209.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98d76b36-4e86-5c05-a83a-9b7ed1409a25','','','Candollea 20:187.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d399e474-d689-5e14-9c75-ec1ba1593307','','','Rep. (Annual) New York State Mus. Nat. Hist. 51:197.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0bfe3e9-1153-5c68-a4f9-243fbf9a11b4','','','Bot. Mus. Leafl. 7:79, t. 3.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96773999-1602-5a7e-bf8a-97c71abdfea9','','','Sp. pl. 2:822.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee15668d-574a-5455-8b79-4fb8864d213d','','','Bol. Soc. Bot. México 24:42.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46934a9d-82cb-5d09-b620-dc41d20c837b','','','Fl. Brit. India 1:513.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('049dd22e-28d5-59e0-8d55-0642abc891d5','','','Univ. Mus., Univ. Tokyo, Bull. 33:139.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcd6efdd-7e85-54c6-b9ba-e0ca9458a4bc','','','N. Amer. fl. 16:73.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdd8c1f3-7bbe-54a3-b3ed-df505c943f06','','','Prodr. Monogr. Lobel. 48.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ea80e21-4aa0-537c-a5a2-cd8724371a89','','','Notizbl. Bot. Gart. Berlin-Dahlem 11:1028.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d995ad12-13a7-5a66-ae1c-267e20fae095','','','C. S. Kunth, Sp. nov. hort. berol. 11.  1848 ("1847")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38de1fcc-7c16-52c4-80b7-747b1ca57142','','','Spic. fl. rumel. 2:505.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a11e1758-7cdc-5118-a5e2-eaa17fcd55e6','','','H. Harms, Annuario Reale Ist. Bot. Roma 7:90.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7f793ea-f712-51c8-babb-8282b60ee0e1','','','Trans. Amer. Philos. Soc. ser. 2, 7:410.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7772ed30-c246-56ac-b15e-214cf4f3d204','','','Bothalia 37:172.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0148b953-dc7a-578d-a305-bbe128d7168a','','','Bull. Misc. Inform. Kew 1914:281.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44ba3623-f83e-5018-b866-aaf784206416','','','Fl. N. Amer. 1(2):333.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf8ff217-520b-5a1f-afd3-5b2b53fa5939','','','Syst. nat. 2:110.  1821 (G. Don, Gen. hist. 1:140.  1831 "<I>Dielytra</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('776274f6-65fe-5a9e-bec3-604bd1a5c29a','','','Bull. Jard. Bot. État Bruxelles 24:436.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('995b9a43-0655-52a3-9078-d829d4bf8d59','','','Prodr. 1:461.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92bd5b07-2b4d-597a-a172-9538b9f290a0','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:317[folio]; 2:394[quarto], t. 189.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('008ff1bb-e64a-57c5-b4e1-07b85d2a8664','','','Bot. Gaz. 89:352.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51611ab6-5b14-54b5-b3a3-af0c75fe690a','','','Repert. Spec. Nov. Regni Veg. 40:219.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a746a755-f82a-5a9d-b7a4-56cadc3d7738','','','J. Elisha Mitchell Sci. Soc. 68:74.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7252b549-84eb-5f83-937c-630fb86ab248','','','Man. fl. pl. Calif. 952.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e9157dd-dd35-57a6-8851-897b0b638703','','','Nordic J. Bot. 36 e01694:4.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d4e1c2a-0717-587f-b979-803d80895146','','','Madroño 13:161.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f649fed8-761e-581c-9242-973fb930efbe','','','Bot. Mag. 47: t. 2156.  Jun 1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('431b6109-c45d-5b47-9cb1-e587413c49c8','','','Med. Repos. ser. 2, 5:352.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aeaf7c3b-33d6-5d85-81f0-cc4f3f049dde','','','J. Bot. Agric. 3:19.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c95280e-7db5-5e01-a9be-5d1753ed378f','','','Symb. antill. 4:309.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17f16931-98fb-56dc-8c43-21e32199dce6','','','Rhodora 3:21.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6dab6ef-7a3b-5d4a-bdd9-1bc9053b6fe8','','','Collect. Bot. (Barcelona) 17:96.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82c65b53-4b17-585b-88c4-059416bd2bc9','','','Trav. S. Afric. 1:537.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01dbd286-6867-5b42-b6d7-701d12bc1201','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 3(2):171.  1875 (Allior. monogr.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1a8f9a1-7f4d-582a-b728-5deae76a1bfd','','','Bot. Mag. 167: t. 126.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('996cc391-5a11-5bdc-b494-e0707b4239fe','','','Flora 24(1, Beibl.):73.  1841 "<I>Pohliana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f299b048-6b18-5abc-a121-65f5c21cd81b','','','Syn. pl. 2(2):331.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a67cb018-254c-580b-80ed-178778d4b36e','','','Rev. Hort. (Paris) sér. 4, 3:227.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('816a229b-472b-5fbf-bca8-5692d2eac675','','','Gard. Bull. Singapore 26:283.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb60cd83-36e4-5f47-9d48-43247479ab58','','','Sp. pl. 1:62.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('934b4d89-a1ae-5743-85b2-f12557981ba4','','','Repert. Spec. Nov. Regni Veg. 10:229.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57d90d4d-2b64-53a2-8286-4747f9643967','','','Hist. nat. palm. 3:226, t. 161, figs. 2 (10-14).  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd16132e-59a8-5362-95ee-383661dd5f61','','','Neue Denkschr. Allg. Schweiz. Ges. Gesammten Naturwiss. 24(3):6, 7, t. 2, fig. 2.  1869 "<I>leiocarpa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3ed4b51-7c8a-5b56-83a5-2a21fe37ee91','','','Hort. univ. lit. lip.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b25b46b8-cb7c-504b-8731-aca973e3abec','','','Blumea 3:263, t. 1 (a-g).  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26b9b38d-adc2-55f5-8bb9-304835f8cc4f','','','Novon 19:408.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b1e4a3b-a90a-5a91-b7e3-e39b13db258e','','','Fl. Hawaiian Isl. 285.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7e46cf6-fad7-572f-bfae-0ce2e6f92fea','','','Diss. 4:250.  1787 (non Aiton ex Murray 1786)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a78c320-0ebf-5b2a-8501-e860e54124fd','','','Züchter 21(1/2):58.  1951 "<I>albidumcompactoides</I>','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d8b4134-d1f4-58d3-9a52-5d806be7344b','','','Acantholimon 46.  1872, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77ce7570-1fcb-55b9-975b-3ba065d5be54','','','Novon 19:267.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef6b2b78-5380-56d0-950e-ef4e65cd7b03','','','A. L. P. P. de Candolle, Prodr. 8:275.  1844 "<I>zanthoxyloides</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60e344bb-baa1-50ab-94ff-b070acc65b12','','','Bull. Misc. Inform. Kew 1907:294.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc8d2748-e654-57d4-ad93-b201b00e81fb','','','Pharm. J. Trans. ser. 3, 24:506.  1893 (ex Holmes, Pharm. J. Trans. ser. 3, 24:416.  1893, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12ed9c2a-c4fe-5f23-b793-46307d5008a1','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1850:15.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d342ddc7-f7d8-5391-869e-0b668ff7721c','','','Bull. Misc. Inform. Kew 1892:82.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb094786-f7c3-5b3e-98c4-09e718c7abae','','','Philipp. J. Sci., C 6:376.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a03bfe0-ab70-572e-bebe-40171330869b','','','Arch. Biontol. 2:431.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da5be3f0-3ead-5676-b074-24915210c437','','','Pl. hort. schoenbr. 4:33, t. 465.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6ca1daf-c133-57cc-b724-2b8c6a960466','','','J. Arnold Arbor. 26:474.  1945 "<I>rubro-marginata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5c2a330-c2d2-5058-851d-be9a5427a953','','','Proc. Amer. Acad. Arts 23:262.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcdd77ff-5da0-5bef-a180-e60a61635d6e','','','Bot. Gaz. 15:111.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de02556a-0a12-54c6-8411-4674d5dcd2a1','','','Bull. Misc. Inform. Kew 1920:20.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1138613e-de2c-5299-9e87-43e37bfb87fa','','','Bothalia 1:121.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a61d2d3a-5e08-5931-b036-6916c0438ff3','','','Bot. Gaz. 27:333.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae69f3cf-cd53-5dc4-b6f7-e6ec4f426fb5','','','Syst. nat. ed. 10, 2:928.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba2bb51c-c6b6-5fb3-8e94-98edf58602f6','','','J. Proc. Linn. Soc., Bot. 6:33.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a71a002d-fd31-56e6-bd79-13102f67a99b','','','Acta Phytotax. Geobot. 20:50.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('504c4276-d275-5851-a6e2-852db80e661d','','','Ginkgoana 1:255.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d11c8f89-57b3-5118-90e9-b6d661e823af','','','Austral. Syst. Bot. 4:582, 584, t. 3, 585, t. 4.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd6f04f5-e816-5c8a-bbd2-86b8811d1785','','','Bull. Taiwan Forest Res. Inst. 248:14.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('daf0753d-8743-5f9f-9dbc-379a6c01df15','','','Phytologia 73:37.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ea16eee-f6fb-55fb-b7b7-201a80aecbfb','','','Suppl. pl. 330.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c78c60c-10da-5441-9d07-9482f5ad6dc6','','','Bot. cult. ed. 2, 5:459.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('535b12d3-c5e2-5106-b520-223faabdef53','','','Repert. Spec. Nov. Regni Veg. 30:272.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08e9b51f-d57e-5958-a347-38ea7c05d4b8','','','C. F. Otto & A. Dietrich, Allg. Gartenzeitung 4:105.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42d0a67d-ebc9-5eeb-b0ea-1a03bb06eaac','','','Bull. Torrey Bot. Club 22:464.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('619b1675-24de-50a8-9bff-bd3e9dde985f','','','Verh. Bot. Vereins Prov. Brandenburg 15:58.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8aaad8b-7c17-5854-addb-bbdbb679746c','','','Bull. Mus. Natl. Hist. Nat., Sér. 3, Bot. 47:81.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f70c609a-e2b8-5e7e-a94c-f7c2cd114665','','','J. B. von Spix & C. F. P. von Martius, Reise Bras. 1:555.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2597b6a1-f0f4-53e5-8b4a-e4f0f78b60c4','','','Taxon 56:750.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2cfb3bf-884f-52ef-b89a-e8cbce0b9ea4','','','Prodr. 3:167.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35a75017-9295-5872-b4cf-7c29d175035e','','','J. Bot. (Morot) 13:206.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ddd732b-34e4-5c8f-8240-747fd3b82218','','','Bull. Soc. Bot. France 33:410.  1887 ("1886")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7403633-a79c-5d29-b540-9d4100d3d67b','','','Leafl. W. Bot. 1:78.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c2d3d1b-3da8-5334-a603-ba522091dd65','','','Austral. Syst. Bot. 22:404.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('daca191c-e9d2-5753-a9f9-d2a0b9095b04','','','Folia Geobot. Phytotax. 6:176.  1971 "<I>dentato-alata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40ce7f0d-4765-569c-96e7-2ad621f07705','','','Notes Roy. Bot. Gard. Edinburgh 5:212.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f66ace4f-cd6f-5e9f-a5cf-5b57d4e5949b','','','Gartenflora 26:130, t. 901.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('271245aa-4ea9-5222-acad-32a38b1d4f67','','','Bot. Gaz. 65:459.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('836e5126-3337-5442-b190-dd190c301af7','','','Wiener Ill. Gart.-Zeitung 13:158.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e475d187-f2d7-5007-9abb-cd8a9c36670b','','','Fl. N. Amer. 1:170.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('249c8872-ea08-58ac-b668-026e68588f9c','','','Amer. J. Bot. 2:302.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6dfb86d8-0671-5932-8631-766b0d837bf6','','','Anales Inst. Bot. Cavanilles 11(2):423.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2ca1525-85dc-5cac-9fd8-b09747615113','','','Enum. pl. 3:459.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46cd68f8-5881-5c5f-873c-6bcef820be8d','','','Berlin. Baumz. 279.  1796, nom. cons. (Sp. pl. 4:450.  1805)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5313c8f0-c224-5f74-94e5-ac7c8d29f8bb','','','Selbyana 2:300.  1978 (non G. S. Bunting 1975)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a18d54bb-8ac5-5b40-aaa8-b29c0e77ee6c','','','Novon 15:488-489.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1a1d48e-d49f-5068-9ac2-f61d4e8f5012','','','Erythea 3:63.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b8c9cf0-8c73-5141-b59c-5c7afde4d5b3','','','Landw. Fl. 153.  1866 "<I>Petroselinum sativum</I> var.-gr. <I>radicosum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('855b2678-d4ab-5a80-9c8a-e218fe1ed9d3','','','Repert. Spec. Nov. Regni Veg. Beih. 1:781.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('296a8218-3141-534f-8ff5-1c7a664517f8','','','Syll. pl. fl. neapol. App. 5:13.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('568356d2-3917-50a0-acf4-eac3a8e7de0c','','','Hooker''s Icon. Pl. 27: sub t. 2628.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94f680db-a89e-5d6b-ac7d-20ac3bd4aa78','','','Sp. pl. 2:769.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7be9999-946e-568b-b19a-f8b2e8c65334','','','Revis. gen. pl. 3(3):253.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a756420-b49e-511d-aceb-5bac0439d33d','','','Fl. reipubl. popularis sin. 27:381.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a42b7281-acca-5a76-8f6f-e3fdb720adea','','','Bijdr. 568.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2e53cd6-24f2-5ab3-8db4-e98a4ba5f4af','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:74[folio]; 5:95[quarto].  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('765e6ba5-4570-59bb-ab2c-438573b18f0f','','','Trans. & Proc. New Zealand Inst. 26:269.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('271f5501-b52e-5b43-a5ee-e79471e56c46','','','Hist. nat. prod. Eur. mérid. 1:403.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27f7955e-e424-536c-9367-fda6815c41bd','','','Compan. Bot. Mag. 1:158.  1835 <I>mackaii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('beb59c65-c960-5918-8948-a607c69655d3','','','Bull. Misc. Inform. Kew 1933:282.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d062ad5-4204-5fdb-895f-853fe8da9ff0','','','Feddes Repert. Spec. Nov. Regni Veg. 54:26.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab3f8702-d759-5de2-899e-220404372583','','','Contr. Gray Herb. 54:148.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e836785e-e663-55da-ad1f-014cb2e1b340','','','Prodr. 3:469.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8260f9b-fd90-5271-ae6f-bb739ec60ebd','','','Sp. pl. 2:1070.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8df3bd80-723c-57b5-b24c-0d4b0797a5ed','','','J. Fed. Malay States Mus. 4:8.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01c620f0-2d16-5c97-aaf7-a14db4f8c3b8','','','E. A. Petzold & G. Kirchner, Arbor. muscav. 427.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('449991ae-e786-5e9e-b3e7-d6859da718fd','','','Verh. Bot. Vereins Prov. Brandenburg 30:165.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7c7af1e-ac37-5aca-a617-57f7367b5df5','','','Pittonia 1:117.  1887 "<I>clevelandi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31299696-9b31-5d57-87cf-595d0a7c3f26','','','Sp. pl. 1:55.  1753"<I>erucaeformis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2391e8fd-47fb-5698-9740-af6db00b7c4e','','','Hooker''s J. Bot. Kew Gard. Misc. 4:169.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddc6d07a-0d3f-529e-8e56-c1da6629800b','','','Linnea 17:279.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d16484d-460e-56da-8aa2-dedb6ecbf1ec','','','Bull. Soc. Imp. Naturalistes Moscou 27(2):66.  1854 (non A. Massal. 1850)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad0fb0ee-6d6e-528f-98cd-c7e9d0c69ee1','','','Bull. Torrey Bot. Club 22:512.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96218a58-cae1-516b-982f-60dfd3aa497f','','','Fl. France 5:219.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6b33220-2a09-5e51-9e03-5ab78c342cb9','','','Amer. J. Bot. 72:772.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c3ff4b5-bf0f-536d-b939-167a274e836d','','','Acta Bot. Neerl. 12:320.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52dc9909-9ed8-57ff-8819-76f1c1cc2ee5','','','J. Acad. Nat. Sci. Philadelphia 7:97.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e526d1a-a946-532a-851c-409b2503e398','','','Phytologia 90:244.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('103afc19-bf2f-5ff5-b19b-3cb4a87dab63','','','Bull. Soc. Hist. Nat. Autun 8:354.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b44670e-bd24-551b-9a51-86e2ab26d7f9','','','Univ. Wash. Publ. Biol. 15:39.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29d57098-8800-56b7-9ba4-869b935f9902','','','J. Bot. (Morot) sér. 2, 2:207.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('240c2097-1de1-5a46-a12f-c188cabad64a','','','Fl. Ind. occid. 2:1150.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c271f75-786e-57a5-be63-77986e82f300','','','Bot. Mag. 30: sub t. 1216.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44111eae-5bc6-5c11-bcd0-f8f4249c0319','','','Repert. Spec. Nov. Regni Veg. 11:390.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32d146ac-7b95-57b0-9a93-95cab61e79b5','','','Proc. Amer. Acad. Arts 14:279.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c3fbd33-c5f0-5252-adbc-e26611b13837','','','Consp. fl. eur. 178.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8541f54-301f-5872-bb5d-d7dc272c30a7','','','Bot. Jahrb. Syst. 29:20.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef94ff5c-58bb-59c8-a0d8-431efaa36068','','','Trudy Prikl. Bot. 19(2):67.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('538e6d96-08ca-56e1-a4d8-70c066e6ff43','','','Sp. pl. ed. 2, 2:867.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('843d2fb8-6c33-5d8b-8ee3-c0ad8fefadf3','','','Sp. pl. 2:883.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2ebcc97-5c79-59e2-b68f-66e13ef7c793','','','Ann. Lyceum Nat. Hist. New York 2:217.  1827 (Acct. pl. Rocky Mts.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b068eb0-06d6-57f1-8d2f-c29c78ac33da','','','Prodr. 5:135.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d54fb8c0-c77a-547b-a380-11b65bbc32f1','','','Sida 3:377.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c815f56b-20de-55c6-837c-872304cb83c5','','','Physiogr. Salsk. Handl. 1:166.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('511abf6f-e55a-584b-bbfc-d6c929629e18','','','Manual 617.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0426a07-ee1c-5061-8717-81037be03bfc','','','Orch. Java 442.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64ee24fa-b1e4-59e0-af7e-a2f4d7a1a858','','','Rep. Inst. Sci. Res. Manchoukuo 2:279.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('927add94-9cb1-5888-ba09-cbe0649f10ff','','','H. G. A. Engler & C. G. O. Drude, Veg. Erde 9(II):386.  1908 (Pflanzenw. Afrikas)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a9c4f94-98f3-57af-b6e6-41f4c9e509ce','','','Wiener Z. Kunst 1829(3):828.  1829 (H. W. Schott & S. L. Endlicher, Melet. bot. 22.  1832)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6ee5814-9914-500d-94fd-1a7acebfadb5','','','R. Sweet, Brit. fl. gard. ser. 2, 3(= 6): t. 267.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('383d9ce7-dc45-5e1a-b9e3-79ada25ff88b','','','N. Amer. fl. 21:21.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d2bbd20-9ccc-585a-946d-1ed44cd4a209','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 3(2):121.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13b74e77-5648-5f00-aa2b-f6325ff9580b','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 38:147.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f307088-1110-53de-9f4d-9bd4ee0d524f','','','G. H. K. Thwaites & J. D. Hooker, Enum. pl. zeyl. 150.  1859 "<I>Chasalia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('993f975f-9f3b-54fa-bdbf-26a797ab477d','','','Bull. Herb. Boissier 3:586.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d81a6e1e-c54f-5b13-9f1e-812a7cd02505','','','Mitt. Geogr. Ges. (Thüringen) Jena 6:32.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d78f2f93-f3aa-56c8-b701-19546b0ca67b','','','Excursionsfl. Oesterreich ed. 3:789.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68be2483-b2df-5c3b-bc7a-ec2f4d003916','','','Icon. 2:77, t. 197.  1793-1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5190d2eb-c357-5db6-b36c-e7a70b7ae084','','','Fl. portug. 1:387.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0a3ef9d-bcaa-53f5-977a-fa44ce892aa0','','','J. Bombay Nat. Hist. Soc. 52:898.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b88b637d-67a1-59ef-b1e0-44371887b536','','','Bol. Soc. Portug. Ci. Nat. 25:82.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6e4241a-38e6-5550-89a2-b7ab81df9af8','','','Notul. Syst. (Paris) 9:53.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94a3d48d-005e-5fbc-949e-3de09fbe5c98','','','Fl. Oware 2:54.  1818, t. 107.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46682901-4bfc-5fc6-a2d8-c38ad732b5d9','','','S. W. Naturalist 3:212.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9e66296-7752-57b6-86b4-0451011b03e1','','','Rubi Germanici 22, t. 6.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6fa1743-e9c5-5b4f-8c3c-3bea3ccec23c','','','Notes Roy. Bot. Gard. Edinburgh 10:163.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1488d58-a9b5-56c5-8cc7-47b0a9d8f73f','','','Fl. orient. 2:861.  1872-1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2b77f84-feda-5937-8e26-4c0751c1e26a','','','Rev. Hort. Belge Etrangère 9:241.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ad347b5-875e-5823-bbbe-a0077befbb70','','','Econ. Bot. 31:319.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb24af31-2bc8-5330-a7e1-1bf1fc128274','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 2:177.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cda365ee-4869-5c40-9647-930a4e213694','','','Bot. Mag. 59: t. 7899.  1903 (Pirotta, Annuario Reale Ist. Bot. Roma 3:132.  1888, nom. provis.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de711787-c11c-5428-974c-4fc1532e4fbd','','','Verh. Bot. Vereins Prov. Brandenburg 32:19.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e70b964-5265-5a7f-a887-7e475ddd11d2','','','Malayan Forest Rec. 10:236.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24a1a6d5-343e-5fe7-9175-3f6aabc3f18f','','','Zametki Sist. Geogr. Rast. 13:44.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf3fe41b-7c48-54b9-8242-d15d89369a00','','','Syn. pl. 1:187.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa265c3d-6605-5e07-9ef0-86935d349f92','','','Labiat. gen. spec. 265.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f92c7b73-2f7b-5f08-be33-55b4317e1f8f','','','Fig. pl. Pyrénées 1:7, t. 4.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16804d63-5f6d-5e60-bc2c-220c0553941e','','','Monatsber. Königl. Preuss. Akad. Wiss. Berlin 1853:494.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d5e2e02-0112-508a-b5e6-381fc7063d9c','','','Fl. France 5:140.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('578942cc-2016-5430-bcc3-cd4da8239c4a','','','C. Meyer, Vers. Monogr. Ephedra 88.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0588ef3-bc94-5394-9c36-1751e1f81a22','','','Fl. ross. 1(2):107, t. 95.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e293bca5-955e-55ad-aafa-3ad109b52c6f','','','Rhodora 58:9.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01c456f2-555a-5029-847f-8a12048d6804','','','Cat. pl. horti monsp. 215.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff80728f-5858-5ec7-a58c-c8f29dd5c66c','','','Linnaea 22:726.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83948714-82d1-5eaf-8efa-2751af57b69d','','','Nova Acta Regiae Soc. Sci. Upsal. 3:201.  1780','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bb38cfe-8787-5a98-a613-db217347dc7b','','','Icon. Pl. 9: t. 846.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7bf3d01-dcfb-5d35-a236-bd412ce2f99a','','','Symb. antill. 2:260.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f361371-8e20-598b-a176-625906bc50d6','','','J. A. Murray, Syst. veg. ed. 14:926.  1784 May-Jun (Fl. jap. 328.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a817f0e7-c890-5ef9-941f-1a88bee62c9f','','','J. Jap. Bot. 66:20.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6af8ba2-cae8-5b16-ab75-620bcfc8ef85','','','Kew Bull. 51:750.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a912037b-1589-5743-9dcc-113ce17385ed','','','Sitzungsber. Königl. Böhm. Ges. Wiss., Math.-Naturwiss. Cl. 1893(37):16.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02dfede9-dbd3-5b65-b152-063b54ceee45','','','Prodr. syst. Aroid. 425.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cb56ac8-4ac9-5220-a8ca-1edd6a9f3ba3','','','Wiss. Erg. Schwed. Rhodesia-Kongo-Exp. 1:54.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2b22f94-8a4b-56f7-9bce-20496693e096','','','J. Bot. 66:360.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a675b49-03de-58a5-a01a-47e4df5f369b','','','Taxon 39:610.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60d0f582-fb8c-5275-94ed-425b663097c3','','','Bull. Mens. Soc. Linn. Paris 2:1271.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('409e070e-6e4b-53aa-9705-8c5bb09aa88c','','','Paxton''s Mag. Bot. 12:73.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f6a78c8-21a6-5861-8c04-ec07fb18aba2','','','Bot. J. Linn. Soc. 102:384.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a25b76fb-1835-583c-b49b-9152f24cbdb1','','','Byull. Vsesoyuzn. Ordena Lenina Inst. Rasteniev. N. I. Vavilova 105:11.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06086079-2e87-5cbc-8041-4a3522a533f2','','','Fl. Roman. 1:617.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d497cc0e-d87a-5633-874f-639f60f51f5a','','','O. Drude, Bot. Zeitung (Berlin) 34:803-804.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e4895da-f087-50d4-886c-3853036335a6','','','Acta Bot. Neerl. 4(2):167.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b473ac86-16b0-5c01-8d80-0bd3a0f02338','','','Van Heurck, Observ. bot. 215.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7a7b7e6-c1dc-5bb5-981b-3abb82fc602c','','','Recueil Trav. Bot. Néerl. 32:211.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e99bec2d-c709-520f-ab69-83a9f5fb8b0c','','','Bot. Jahrb. Syst. 40:462.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58a6a0d7-0624-5e98-8150-c3ec85cdecc9','','','V. L. Komarov, Fl. URSS 9:118.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16ac60d1-8fc0-5bf3-afcd-973524be6adf','','','Trans. Linn. Soc. London 9:202, t. 21, fig. 1.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e23ebc2f-ff92-5eb9-b688-e504687785a8','','','Diagn. Cucurb. nouv. 1:25.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d74ba718-835c-53e8-a415-d1381ec51d80','','','Ann. Sci. Nat., Bot. sér. 2, 17:139.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd55f3dc-04ea-56ca-8580-c474dedf21bf','','','Canad. J. Genet. Cytol. 7:396.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('146040b1-904a-5ccb-991c-cf272b42f7ab','','','H. L. Duhamel du Monceau, Traité arbr. arbust. nouv. ed., 5:6.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b479694-99d3-50ba-a291-ab9ee66b59b5','','','Fl. Neotrop. Monogr. 13:168.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbd85198-3fce-5b71-8071-bcead8eda147','','','Kew Bull. add. ser., 1:74.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0ffd9fe-2db3-50bf-adf7-36c48466c440','','','Linnaea 20:444.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22da1a1d-34e5-5f3a-955d-6b3a26174e59','','','Mem. New York Bot. Gard. 8:319.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f49b07d4-1f5f-5a34-8a6f-724dd98315a7','','','Rheedea 6:51.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a035a8c8-b8f8-560c-86bf-00568c5f6959','','','Comm. legum. gen. 34.  1837 (Ann. Wiener Mus. Naturgesch. 2:98.  1838)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e3eba7c-f79d-5f33-8e9c-0511a4576d38','','','Misc. bot. 23:16, t. 1.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e62b7f6a-b51c-5f2b-a7b0-19312058d0fe','','','Rep. (Annual) Missouri Bot. Gard. 4:141.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa0bf3f8-1a7d-5273-a204-42002a70eb05','','','Syst. veg. 3:126.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('655fa20e-6565-5324-921a-50046d3e30dc','','','Methodus 261.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8a4c4cd-1f09-5aba-b5a4-a0ce4b26c241','','','Linnaea 27:307.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('432e3b0b-1ec8-5b3e-824a-25e15571accf','','','Blumea 31:389.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f47372d0-7dd2-5f47-b086-cb598a5615fd','','','Fl. Antill. 2:49, t. 12.  1818-1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('715b2bda-4400-5790-a83e-335d8a37e2aa','','','J. Proc. Linn. Soc., Bot. 4:139.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5b311e5-1dfa-57d0-b22c-696c54e90b77','','','Gen. sp. Aster. 163.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ff8dbcb-30ea-5006-a5e4-507a71e7be84','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 11:59.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('235b0a31-4347-5ffc-b734-e642d8b10c9f','','','Gard. Chron. ser. 2, 11:430.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce5e6013-6326-52a0-9057-941d1a3c0a41','','','Prodr. fl. nepal. 63.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f97edce-4471-589f-8780-77f765718565','','','W. A. Silveus, Texas grass. 737.  1933 (A. S. Hitchcock, Amer. J. Bot. 21:139.  1934)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a9af454-d668-573a-90fe-79df18befd96','','','Bot. Cab. 15: t. 1408.  1829 "<I>zamiaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4814839-eb27-504f-a766-1107964ef9d0','','','Misc. mat. 65.  1803 (J. Donn, Hortus cantabrig. ed. 2:66.  1800, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e03509a-9638-5cbc-8f36-a4ef2da6f404','','','K. Iwatsuki et al., Fl. Japan 3a:41.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('856047b3-667f-5758-a790-bdf167d7f37d','','','Legum. Caatinga 126.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a073ad34-2d01-5efe-9ef4-4ca5d841cbcf','','','Méth. éprouv. ed. 2:495.  1833 (E. G. Steudel, Nomencl. bot. 882.  1821, pro syn.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('100b7b96-9885-5157-be85-900adf40bc3d','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(1):44.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afee5be3-9b94-5652-90b0-e0f62ce6d4ed','','','Contr. Gray Herb. 183:88.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de887a6b-63a2-53c5-999b-c5441949a918','','','Hist. pl. Guiane 39, t. 392.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd4e4291-ff70-5735-9618-a8b3b9f74ba1','','','Repert. Spec. Nov. Regni Veg. 11:345.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7304059e-636a-5574-a544-1c15946a79af','','','Kew Bull. 52:40.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05dad154-ad63-58dd-bf92-3a78307c76d6','','','Gard. dict. ed. 8: <I>Smyrnium</I> no. 2.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('891ef77b-8886-51c5-9ab1-a9fde20268d8','','','Ann. Sci. Nat. (Paris) 10:366.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df7f5b5b-f72f-5f1c-8bfb-ef327a26de27','','','Kakteenkunde 1933:103.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d0f24d8-c802-5af2-b8a3-51cec0e90a0e','','','Syst. nat. ed. 10, 2:875.  1759 "<I>Coracan</I>" (Sp. pl. ed. 2, 1:105.  1762 "<I>coracanus</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c7429a4-95d6-5bda-8f87-7909e0223ccb','','','Ann. Sci. Nat., Bot. sér. 3, 18:225 (255).  1852 "<I>nummulariaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2de0de06-e740-5a52-8732-6b534c219aca','','','Ann. Sci. Nat., Bot. sér. 2, 6:54.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54f768d9-b909-59f6-8eb2-2547845093ec','','','Fl. bor.-amer. 2:72.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7e88fe8-8bde-5f23-9b4e-47b0c3712b90','','','Nordic J. Bot. 23:289.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6932682-1f68-50f8-8a02-33e42cde04f4','','','Willdenowia 12:188.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8b746cf-44f2-5082-9174-d6e2afc7fe43','','','Cactaceae 2:140.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d36ca1e-ec21-5718-b6e3-42956ab20832','','','Bot. Jahrb. Syst. 26:259.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('938c79de-24bd-5e44-9518-2f1b3aaa2934','','','Linnaea 26:352.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35c9d83d-9141-5458-a680-0db59cf1d86f','','','Consp. pl. charc. 8.  1859 Mar (E. Cosson, Bull. Soc. Bot. France 6:609.  1860 Jan)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ede287b4-17ce-5b6c-bd7c-7da6274fe2ee','','','Linnaea 33:246.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7650af60-d1b6-54e2-a706-b1c5ba75752c','','','Scroph. ind. 18.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94754f33-16dc-5674-b265-9c58e340564b','','','Bot. Mag. 82: t. 4934.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5e54cb8-51c5-5eb9-9374-e88276ef8f94','','','Bull. Bot. Res., Harbin 4(3):108.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afa897d3-9cf3-536c-82f8-a65da9278827','','','Bull. Bot. Res., Harbin 6:68.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfaa6844-52da-5d6e-a56f-b2a09624cd40','','','Voy. Uranie 467.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('911aabbc-df78-5369-b994-12a3eb6fe2cb','','','Gentes Herbarum 9:252.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e444ccbf-b2e1-540f-b1b3-baea0559ccca','','','Eclog. amer. 1:26.  1797 ("1796")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a185fba7-503b-5dfd-940f-ff39d6bb74db','','','Ceiba 1:55.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e8109aa-24dd-5b58-8d22-70b85d7c3886','','','Repert. Spec. Nov. Regni Veg. 14:311.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51896e95-a101-5c0a-bd14-f855c99097ec','','','Bot. Jahrb. Syst. 12:514.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fe64356-00ad-5918-93fb-060c5260bafe','','','Brittonia 3:529.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27a79feb-4410-56a3-9326-35cf5499b1b3','','','Prosp. Hist. pl. Dauphiné 39.  1779','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('360f3129-6f5c-5627-9839-2b86394b5fc2','','','Comm. Fl. cochinch. 208; Trans. Amer. Philos. Soc. ser. 2, 24(2):208.  1935 (non Siebold & Zucc. 1845)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0ee3fe3-a1db-5072-9215-84e631b0ee71','','','Pl. Victoria 1:15.  1862Syst. nat. 1:422.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07ce3954-d075-54fa-9714-9b77cb5563a6','','','Crop Sci. (Madison) 23:639.  1983 Jul-Aug','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39a22052-9b04-50f1-a59a-02abae570501','','','Bot. Mag. (Tokyo) 8:49.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31b906e7-5abd-5a90-a145-c6be8a41707d','','','Prodr. 3:269.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5faf9e1e-8d5e-5c3f-900c-18e22f991301','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 19:251.  1874 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8931091a-b77a-547b-8b6b-8cb534c8278e','','','Pl. asiat. rar. 2:4.  1830 (non J. Presl & C. Presl 1822)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f7e04b2-f0f5-5448-9ec8-15669a98fccd','','','Gard. dict. ed. 8: <I>Persea</I> no. 1.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4098794f-0dc6-5790-b15e-8601981b8f99','','','Fragm. bot. 27, t. 28.  1801 ("1809")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52bfa59d-0f7d-54ef-9d8b-615107a2521d','','','Pl. mex. gen. <I>Yucca</I> 120.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a6c04f9-8876-566d-ac92-28bfae436f30','','','Fl. ins. austr. 34.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bb24fe5-4803-5256-ab96-49c633af8a02','','','Byull. Sredne-Aziatsk. Gosud. Univ. 19:121.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e006919d-2e14-5816-8d5d-0cb8444a68bb','','','Prodr. 3:256.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95dff724-b542-51ff-8e48-45965a2c9e5e','','','Syst. nat. ed. 10, 2:874.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbb92b10-7f64-5eb7-a202-2ad83748935f','','','Prodr. stirp. Chap. Allerton 199.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f77100c-7c02-578b-8ce3-20565f7000f3','','','Syn. pl. insulis britannicis indigenarum 160.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fec124dd-7b58-50ff-b3a6-b10e730a142a','','','Mém. Herb. Boissier 1(1):108.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d8ac53b-198c-5775-b8b0-2b9a7b66a7be','','','Encycl. 1:579.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6d1cf95-5291-5119-99a4-71fb20ccbe0e','','','N. Wallich, Pl. asiat. rar. 1:27, t. 33.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f17b055-5357-58b8-8118-e54db18e0620','','','Verh. K. K. Zool.-Bot. Ges. Wien 60(2):110.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ec65ac2-90a2-5517-a774-2238f7616d88','','','J. Arnold Arbor. 6:147.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14a6a69c-8f94-5d77-8770-eff4accd29de','','','Bot. Not. 133:486.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef320e64-0f89-57e3-9599-ec67a5c6c5dc','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:282.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f24957f-8c0a-5aa8-925f-c80185ca1a67','','','A. D. d''Orbigny, Voy. Amérique mér. 7(3). Palmiers 113.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77c304eb-57a1-5eb4-b335-ab7001c9c301','','','Linnaea 4:230.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c195ff46-602d-57bd-9669-22c141abd904','','','Nov. gen. pl. 3:55.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eaf2897f-e3da-5c6d-9746-5c0bf400995d','','','Ill. Hort. 2: t. 74.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6ace2e5-4563-5fc5-a826-b2665861a916','','','Fl. N. Amer. 2:271.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7865b21e-c3fb-5fc3-aaab-9c3182563a7e','','','Icon. pl. formos. 5:204, t. 15.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e67d166-ab7e-5f43-b66a-83adcd1c20f2','','','Linnaea 39:7.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3414837-04b0-539d-9805-beb423f3802e','','','K. H. Rechinger, Fl. iranica 147:71.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b2998c7-fc91-5720-b65d-7a1b70524941','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 8:26.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17af6a99-4187-5da7-a7e6-ab84013fa202','','','Enum. pl. Javae 133.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30f3a87c-e196-529e-a7d4-1f21d5464e39','','','J. D. Hooker, Fl. Brit. India 2:91.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7419209d-768e-5bdd-87fd-a61afa1f8e24','','','Hist. pl. Guiane 68.  1775 "<I>Coccocipsilum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5dfa9e3-0a17-5d1c-bdfa-2badc41f14ae','','','Fl. suec. ed. 2, 165.  1755','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2478bbd0-6091-5e2c-b9c6-a68c84ad8a83','','','Nordic J. Bot. 6:404.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87026c7f-7801-5869-9571-58b40869b93e','','','Acta Phytotax. Geobot. 23:3.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52598319-0fe1-500f-a999-e64804f749a6','','','Fl. palaest. 17.  1756','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68ab662f-bd30-52a9-a358-f61223cc3585','','','Verh. Bot. Vereins Prov. Brandenburg 32:21.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba194856-37c1-5cab-bfc9-4cbe34eef074','','','Catal. bot. 2:39.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1016cd86-dd3b-546e-a825-cb8bc3dae924','','','Fragm. 11:28.  1878 (Linnaea 25:376.  1853, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01e84280-0422-522e-87ba-23306cf3dd5f','','','Repert. Spec. Nov. Regni Veg. Beih. 1:716.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fefbdaf-39e7-57b0-ab25-339a7f11f0cd','','','Prodr. monogr. Hypéric. 34.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3907d548-5cab-5474-b49b-7f2d80fe00b9','','','Fl. N. Amer. 1(2):268.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5221b01-bf7c-51c9-a96a-f0768e23cf42','','','Verh. Naturf. Vereins Brünn 22(2):435.  1884 (Fl. Mähren)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c27baf65-716e-521c-91f9-d82575f8feef','','','Austral. Syst. Bot. 10:412.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9b1dd36-e537-5032-9eb8-34a7ce4e9cfd','','','Fl. boëm. 3:88.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0236d31-4485-5547-a46a-31c3f92c9097','','','Fl. Hongk. 51.  1861; J. Proc. Linn. Soc., Bot. 5(suppl. 2):26.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5728f1bb-c1b7-580e-ae50-86ab3bf4b209','','','Nov. Holl. pl. 2:101, t. 250, fig. 1.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('530238b6-a670-5944-949a-603e136b8ca6','','','Trans. Philos. Inst. Victoria 3:55.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d89634ca-f0ba-5b55-9524-d31105208111','','','Fl. Bermuda 135.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('069942ab-0354-54f1-86f0-072a96d1bd0f','','','Zoë 3:302.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f66730e-5f6a-5596-b523-85fb765c930e','','','Bot. Jahrb. Syst. 13:338.  1891 "<I>Evodia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8b4fd35-8c20-5764-99d2-63c98189e7cb','','','Bot. Jahrb. Syst. 1:333.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a608e064-1680-5745-81fa-18ffa82907d8','','','Mem. New York Bot. Gard. 35:382.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9814947b-5751-5688-8054-ea4fbf91a708','','','Sborn. Prezident. Akad. Nauk S.S.S.R. V. L. Komarovu 735.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1db4edfe-f7d6-5f58-9650-e9eaa93de6a1','','','Contr. Gray Herb. 49:25.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8221686f-af2a-59e9-8a3f-d906d6212768','','','Aliso 3:153.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09696393-04c7-5953-8302-da4defe17308','','','Blumea 58:43.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('549acc09-94b3-5c1f-b8f5-d8f26583d3e8','','','Flora 20(2, Beibl.):95.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e2a43cb-0da5-5fcd-ab61-b401a72a24d4','','','Verh. Naturf. Ges. Basel 61:176.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f41af3e5-eed6-5ee1-be5b-ab80b51afd12','','','Fl. Ned. Ind., Eerste bijv. 492, 192.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70a0456b-d814-5378-a892-7d064f6195cc','','','C. F. P. von Martius, Fl. bras. 4(2):177 "<I>tenuinervia</I>"; t. 36.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a913d69c-b1ef-5d4c-aa68-dd608fb1523b','','','Bull. Herb. Boissier sér. 2, 8:739.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1747a2f1-ca6d-514f-9ac2-7fac48b7107f','','','Pflanzenw. Ost-Afrikas C:213.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('009770c1-81ec-5ea4-87e0-2f9fe143c792','','','Adansonia sér. 2, 1:195.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f45f05fb-68b9-536e-bce2-82b0392c3e3b','','','Trudy vsecouz. sezda genetike 3:609.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5530462-2a15-516b-9cff-4c980272fd47','','','Fl. bor.-amer. 2:124.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19d0bdd3-ad57-5d8f-bdea-5e2122e700d7','','','Taxon 63:755.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccd891f5-a5fe-53d7-b4a3-48a81685cfa5','','','Verh. Batav. Genootsch. Kunst. 11:185.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('766262e8-6e89-59be-9fa8-dc5b4f2be5f5','','','Prodr. fl. nepal. 125.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('794fc8f4-f80f-5659-bdc1-d7d712bec9fd','','','Mus. bot. 1:231.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ad96f40-ac1f-521d-a32c-9bbe68f592b1','','','Chataigniers 234.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6248438e-9d62-585c-a428-f06f08da44f8','','','Gen. hist. 4:560.  1838 "<I>delphinifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74ca7b74-2d90-5d85-8052-eced69bd896d','','','Bauhinia 2:198.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1a6752f-6513-5521-a54b-563c9c268d03','','','Bull. Misc. Inform. Kew 1906:18.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f8d6b2e-6a92-5555-a4f9-dc1a193ac31e','','','Prodr. 6:306.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf989353-3814-5fdc-9b6e-288ba09ed90e','','','Spic. fl. rumel. 2:74.  1844 "<I>sylvatica</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('668dce08-6b44-5a18-b13e-a3fa86168892','','','Trees shrubs hardy Brit. Isles 1:649.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3eb5f4d3-5c47-5036-9591-91008618ceac','','','Symb. antill. 3:339.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72619cef-bba7-5bf7-bff8-70f919b45b53','','','Sp. pl. 1:549.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('549c1474-0e58-5b0b-a49d-98178061b3b0','','','Gentes Herbarum 7:348.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('720d23f0-8fc8-591b-b096-65ef565a0ef3','','','Syst. veg. 2:663.  1817 "<I>carpathicum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8362eba4-aef0-5dca-bb91-3a12f2880528','','','Fl. N.W. Amer. 416.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1eac976-c74c-5b99-952a-208ebd01d983','','','Linnaea 1:43.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28dafcf1-8820-5d30-ac1f-53a2e346b626','','','C. Wilkes, U.S. Expl. Exped., Phan. Pacif. N. Amer. 17:255.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85dfc3ef-565a-5ce1-9c04-45449db17de1','','','Amen. nat. Espan. 1(2):101.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('facb9581-86f4-548e-88f7-8eff99697d61','','','Izv. Glavn. Bot. Sada S.S.S.R. 27:619, fig. 1.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2fffd285-d9f3-57ef-b822-0e64a1c9d8b1','','','Syst. nat. ed. 10, 2:1311.  1759 (Sp. pl. ed. 2, 2:1500.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6869e6dc-4acb-5546-bfb1-c5177b342a75','','','Ann. Missouri Bot. Gard. 64:466.  1978 ("1977")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e18a88ce-f24a-507e-9348-a7c7751069d0','','','Bull. Misc. Inform. Kew 1906:6.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bd2c1e5-9e15-520a-9cfb-982334f67527','','','Rhodora 8:163.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bfe9601-46f7-55d5-bb64-bda5cf125b8e','','','Desert Pl. Life 14:191.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92ab6653-7cb8-568c-8023-c214c86fbe40','','','J. Arnold Arbor. 26:472.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df33a99c-c926-5d4f-8fa5-ecb22b86bd42','','','Hist. pl. Guiane 828, t. 324.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e412eef-fed2-5a64-b4f9-d7ca6ace0e94','','','Syn. pl. glumac. 2:205.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2949881-9e8e-57ff-a74a-01b01fa9e797','','','Z. Gesammte Brauw. 5:185.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99539e27-45ed-5703-8a44-524618001724','','','Mant. pl. 1:49.  1767 "<I>pumilus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f53bdc37-28ad-5e9e-84a5-8888e0b0fccc','','','Icon. 5:33, t. 455.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddf483da-d1b0-57e9-afcf-4d97e6eaa7ef','','','Fragm. 6:229.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c173300-3dcb-507e-af3e-fb3ee4619f94','','','H. G. A. Engler, Pflanzenr. IV. 43(Heft 87):299.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f323c99-72fe-51d9-8240-03b14b1a12c2','','','Descr. pl. rar. 20.  1772','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b66e165c-e15b-5583-bd3b-c6d2a5d955a3','','','Madroño 35:339.  1989 ("1988")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c78e7888-18e8-500e-a6aa-ae1a62d522cb','','','W. T. Thiselton-Dyer, Fl. cap. 7:628.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e9b1e50-dc8f-5097-b569-8fa98a1cf02c','','','Amer. Midl. Naturalist 29:458.  1943 "<I>adscendens</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5884a66e-69f2-5c87-a1bf-eb7eac668865','','','Prodr. 8:447.  1844 "<I>berterii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b278472e-12a8-525e-b4de-4afb977eb1f1','','','Zap. Kievsk. Obshch. Estestvoisp. 11(2):7.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73bc4cc9-d372-5830-8a9b-2fd9540f5246','','','Notizbl. Bot. Gart. Berlin-Dahlem 15:502.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a625641-cbf6-5ed5-998c-12e21a9b01bf','','','Bot. Jahrb. Syst. 19:193.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76f38aac-3cb3-5999-888d-2dec37fb12a2','','','Sp. pl. 2:1051.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fa015bb-314e-5306-9178-58d5837aac71','','','Bull. Misc. Inform. Kew 1928:375.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aefe1346-ad8b-5698-9254-957ce133f88a','','','Novon 8:206.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb46539b-885d-5c1b-a41a-59f7218e536e','','','Biblioth. Bot. 89:211.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa418609-2d15-5a7f-9a91-8424a8e22383','','','Acta Phytotax. Geobot. 14:63.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f5b2dbd-8a71-5c2f-8db8-5dc20cce05d8','','','Ann. Sci. Nat., Bot. sér. 3, 11:269.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ea7c675-83b8-561a-befe-6e3e36b795e8','','','O. C. E. M. G. de Kerchove de Denterghem, Palmiers 244.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d68d63dc-dd6a-5b06-949e-211ee4e6eede','','','Reise russ. Reich. 3:730.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a81b58b-6a57-5604-a5d7-db5531c23c96','','','Mem. Amer. Acad. Arts ser. 2, 4:81.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52b52c90-e14f-5441-ab4d-7e5d06f6c993','','','Cat. pl. Cub. 186.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9c05934-ffa3-577b-9c25-0c7e909a970a','','','Acta Phytotax. Sin. 31:452.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b671446-1b01-5ba2-b2dd-4e5a7386eaca','','','Sudania 1:163.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f94cf6b2-1b07-596e-8df7-29e436556a7b','','','Index sem. hort. petrop. 1868:14.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb9b316a-b1ae-5f86-ae23-a933e947c797','','','Ann. Wiener Mus. Naturgesch. 1:162.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8765245-bca2-5aba-a2fb-de2e40935020','','','Bull. New York Bot. Gard. 3:433.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba263eff-e4d7-5f3f-b66c-7c379509c46b','','','Fl. bulg. suppl. 40.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cbf316b-6067-5d6e-9917-e6cdb224a31f','','','Hist. pl. remarq. Brésil 261.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31338e52-6b61-5cce-b007-f551cb8149e7','','','Fl. N. Amer. 1:124.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b90796c-9d11-5608-9a5b-00784fe69c2f','','','Contr. Gray Herb. 129:11.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78e946ea-d9de-52f7-ab38-ff5fd74cb54d','','','Enum. pl. Jap. 2:527.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0f1902e-bc9a-571b-8083-975e111721d6','','','Prodr. 2:147.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1b16ee6-e077-5c19-b3d9-6084b857601a','','','Gard. Chron. ser. 3, 2:660.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26c322cb-5b8c-5506-8d66-305a20b09d0c','','','Handb. Amaryll. 7.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1203b49e-2d3b-5fea-9a59-3e5fe9ab9a1b','','','D. Oliver, Fl. trop. Afr. 2:201.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a6c3a6c-15b1-52c4-86fa-5d57c2f22cfc','','','T. L. Mitchell, Three exped. Australia 2:146.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34f950ce-3295-5f8e-aa44-d59eee870e0d','','','Z. Sukkulentenk. 2:183.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c85c2a2-b2e7-51f8-89aa-b63dd1121e2b','','','Gentes Herbarum 1:79, fig. 29.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3f3b670-4844-5bd0-8eab-4985f2a3c6d9','','','Fl. Alsace 1:401.  1851 [Mém. Soc. Hist. Nat. Strasbourg 4, n.15.  1853]','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27ac7ce1-e3e6-52b9-b958-3b7b18fe72a7','','','Bradleya 12:111.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e89aff9-4e17-54e4-8a36-fb37b18d47ed','','','Leafl. Bot. Observ. Crit. 1:123.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a400d243-1f37-558e-8a88-bbb89a7069a0','','','Fl. Ned. Ind. 1(2):522.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34a10851-cd36-50d6-b0a7-9609ae1d8afb','','','D. Prain, Fl. trop. Afr. 9:622.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8a4649d-e30b-55d8-a25e-d1cce61bb12b','','','F. Henkel et al., Das Buch der Nymphaeaceen oder Seerosengewächse 66.  1907 (non Carrière 1879)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2b26e96-8d77-5570-b719-96b990459fb5','','','Illinois Biol. Monogr. 34:20.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6822516f-ab11-51ee-b3e8-04543fb68435','','','Fl. ross. 1:146.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f39d598-77bf-5c97-90a6-e2fdfecec153','','','Geraniologia t. 1.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a4fa766-c75f-5439-b420-510f1396a854','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 26:93.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d1d37e7-17ed-532c-8a03-cc8724c74efd','','','Syst. laur. 157.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3f4cb51-9660-5057-93e3-5e1a9571d92a','','','Fl. ital. 1:167.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b69730f-781d-54a3-8bc2-a0ba97e34556','','','Syst. veg. 4:795.  1819 "<I>macrantha</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82230956-0003-590d-a8c0-a70cf59dabff','','','Kew Bull. 24:272.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a88cd26f-ab1d-556e-84f0-fb56e1b78738','','','C. Wilkes, U.S. Expl. Exped., Phan. 15:451.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e772f2e-be6d-5c80-a6b9-817c73be05f9','','','Apocyn. S. Amer. 75.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64e8e418-1c0e-5fd0-ba64-f001c86995a8','','','Trans. Acad. Sci. St. Louis 12:86.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a045ad1b-2fb2-54c2-ba64-c2b12db4f7de','','','Anales Mus. Nac. Hist. Nat. Buenos Aires 7:153.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8977e80-6c29-5c40-968b-fc47cbc76055','','','Contr. U.S. Natl. Herb. 3:162.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfc57d45-794c-5e95-81ea-c3de9791ec73','','','Monogr. Salicum 97.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abf5cc7e-9974-532f-8b67-f8848e4c2141','','','Fl. carol. 61.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea067ec2-1839-5b65-805a-192c491cb4ca','','','Candollea 7:18.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('721a0c58-4ac8-5e9d-9520-3afb8f89ce5f','','','Gard. dict. ed. 8: <I>Tagetes</I> no. 4.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e6dfec1-8c1f-597f-9d24-c39d2825ed79','','','Enum. syst. pl. 11.  1760 (Select. stirp. amer. hist. 3, fig. 3.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75b352e3-6b10-5c54-b082-be4599b3ac81','','','Kew Bull. 42:681.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa95d276-a7b9-5c14-ab15-c8f416e2b45f','','','N. Amer. fl. 23:72.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b2c99ea-2ec6-56fd-abd7-273c68fa143d','','','Select. stirp. amer. hist. ed 2:136.  1781 (ed. 1:280.  1763, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04ee297d-7f0d-51cd-8fb4-eb2d446a8af0','','','Sert. austro-caledon. 13, t. 18.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11cff23d-584d-54d7-ab67-d9e13223dc10','','','J. B. Stevenson, Sp. Rhodod. 97.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c582de9e-3407-5409-a57e-5277e4d1540f','','','Linnaea 8:138.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91c994a9-3d21-5fdd-a3b9-6af526ee2815','','','Gen. hist. 1:516.  1831 (W. Roxburgh, Hort. bengal. 50.  1814, nomen nudum) (non Jack 1820)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e9e4764-6e28-516e-a2a5-2bfb349b5266','','','Prodr. 5:327.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aed1ca12-339d-5a2b-91e7-4d1f7d3d244a','','','Encycl. 2:249.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a70f1e08-0282-5710-b0d2-52cf02f0a0a1','','','Proc. Amer. Acad. Arts 3:282.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f023e340-201d-5886-81ce-1f519c780c25','','','Repert. Spec. Nov. Regni Veg. 7:2.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('731613c9-5308-5deb-aa61-e73d6e6d3404','','','J. Washington Acad. Sci. 6:47.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3fa7a9c-8884-5ff1-946c-f853e50095d2','','','Bull. Calif. Acad. Sci. 1(2-4):133.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b8b83ba-1284-5fb5-8aae-3516aac834fc','','','Garden 40:194.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85d7f0fb-e1b6-5c06-a3d3-e00a1f33ab97','','','Madroño 6:154.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6e638ca-5efb-59c5-ac93-c46875551379','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:239[folio]; 1:298[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b430a7c8-89a5-5afe-bcea-9d565603503f','','','K. Koch, Wochenschr. Vereines Beförd. Gartenbaues Königl. Preuss. Staaten. 6:346.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22310f5e-02c0-56f1-8170-25599ff549bd','','','J. Bellenden Ker, Bot. Reg. 5: t. 393.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d383bb76-7868-5c11-9f18-ffaac132bc29','','','Syst. veg. 3:370.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('968a5b71-ebd9-561f-a97e-51ef4531dde5','','','Reinwardtia 6:21.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0a9c243-4c0b-5334-b982-79b29042290e','','','Trans. Amer. Philos. Soc. ser. 2, 7:320.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b849cf5c-62cd-5fba-8132-f38a8be1d018','','','Key Eucalypts 224.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7304570d-6316-562b-8aad-3d211b0c0d17','','','Pl. eur. 1:102.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff18c509-719b-5862-9b45-1b8dae4c3375','','','A. J. Ewart & O. B. Davies, Fl. N. Territory 333.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('760cd043-4a13-5607-b7bb-00517de879f4','','','Hist. nat. Iles Canaries 3(2,1):81.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b17ecbaf-84cb-5e7c-8c88-5b0fccedd5ab','','','A. L. P. P. de Candolle, Prodr. 13(2):71.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d7d249b-b457-5581-93b9-4927aa9e434a','','','Bull. Soc. Imp. Naturalistes Moscou 36(2,3):222.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0dfae423-9879-5004-8bb6-dc9dfeed9932','','','London J. Bot. 1:363.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59ea4380-0c41-5be0-8963-8bffab4431c7','','','Fl. ind. 1(2):153.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('811ad7e4-42a8-5589-afc8-0835ae19a753','','','Bot. Mag. (Tokyo) 29:313.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10d408b6-984c-597e-b359-4c234b5a4c73','','','J. Bot. 36:316.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('666531b2-6fa1-5904-9b5c-ec9579241f15','','','Sukkulentenkunde 2:27.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddaa9f89-3cbe-5f4a-982b-ce9053397444','','','J. D. Hooker, Fl. Brit. India 2:114.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9de0e815-9dc0-5099-82eb-495adf1f0f62','','','Fl. bor.-amer. 1:89.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c410ba54-7898-519f-9246-57f31c270b46','','','Tent. fl. abyss. 1:25.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e64d5f5a-c6cc-5a11-a16d-f0efbd189354','','','Illustr. Pl. 44, t. 36.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f06763ca-7636-56a1-9c21-d6640c3069c7','','','Proc. Amer. Acad. Arts 12:275.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc3093c0-9c8e-553d-a3b3-9d16d19e35bc','','','Bol. Inst. Nac. Invest. Agron. 14(30):29.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6998224d-e8c5-5044-8460-d7be9b52cf59','','','S. Watson et al., Botany [fortieth parallel] 360.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63f06f82-50f9-5b5e-8cfc-c1f9fc7e29cc','','','Phytotaxa 134:50.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('429f6a0a-6f5b-59e4-babb-051df25e330d','','','Syn. mitteleur. Fl. 6(2):626.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56a3c80e-1d48-57c7-bcc2-5bc5c0adb41d','','','Anales Mus. Nac. Buenos Aires ser. 3, 4:486.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('409bbb0e-4799-5805-8083-15ac505588a8','','','Wrightia 2:189.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bb2028b-b53d-5c76-ab9e-e51c7b10cdd8','','','J. Arnold Arbor. 61:350.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4a40f8b-7374-589f-ba8d-3b2fcb4dd63b','','','Gard. dict. ed. 8: <I>Ruscus</I>.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0dc16185-93c0-5a28-adaf-5420af8edd91','','','Mem. New York Bot. Gard. 30:12.  1978 ("1977")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('550a4c6f-3b7e-57d7-a17c-169dbadfeafa','','','G. L. Nesom, Phytoneuron 2010-35:13.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64bb2acc-b01c-5483-a000-e5bd23a839a9','','','Hooker''s Icon. Pl. 16: t. 1595.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('949367dd-9dfd-5d03-900b-19200ada600c','','','Proc. Amer. Acad. Arts 28:137.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d942d78-bbf5-5468-909b-fb0f8a6bc3cb','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 463.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30a7246d-9006-5f31-9afb-df75a1d89907','','','Bot. Gaz. 37:271.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a663713-0eb1-5380-a179-0d3096f0927f','','','Prodr. 5:641.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3a56990-87ae-57e7-8710-e7b5d9573612','','','Trans. Amer. Philos. Soc. ser. 2, 8:257.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac3fa547-1461-5756-af19-f143d6047b6d','','','Les cafeiers du globe 3:190.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('004b48e2-3e4d-5906-8ca4-c2f149fdf6ad','','','C. S. Sargent, Pl. wilson. 1:485.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('315fbce9-77e2-5d63-b696-90bc4e9de874','','','Sp. pl. 1:460.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c52b175f-f672-5bd3-bd84-68a923627a0e','','','Handb. Amaryll. 68.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('281069ba-a425-5f3c-9a94-2e6bc11930ef','','','Ann. Bolus Herb. 3:134.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a45a36c2-427c-57c6-ba81-76cf812a1cd4','','','Allg. Gartenzeitung 4:115.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7983084c-5fd6-5050-b80d-1818644b33cc','','','Suppl. carp. 247.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1300af9e-0479-560a-b216-485822c677c0','','','Phytologia 46(1):5.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2f98282-7bbb-5835-8e5c-559982bfcf4d','','','Fl. Oware 1:78.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39f22357-28db-51d6-b6aa-d4fedc6e1f98','','','Syst. Bot. 4:244.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7b58152-b66c-5395-b5cd-41f60cfe2df0','','','Repert. Spec. Nov. Regni Veg. 9:456.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('450ebd6d-7cf2-578e-a256-594fe62c1c63','','','Mitt. Inst. Allg. Bot. Hamburg 10:554.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9a469f0-7268-5694-a283-30e96b0d2035','','','J. D. Hooker, Fl. Brit. India 5:762.  1890 Apr (J. Linn. Soc., Bot. 28:130, t. 19.  1890 Nov)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89b9b564-a548-5fca-be3b-934c07025cb4','','','Repert. Spec. Nov. Regni Veg. Beih. 33:251.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df05d712-bf09-50ac-be78-5a8391c96992','','','Fl. carol. 92.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ae5a618-929e-5700-b67f-29992d719e81','','','Kew Bull. 1949:175.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('156125eb-dcfb-5b01-af38-b04e1b968448','','','Fl. Afr. austral. ill. 255.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d3f8687-2715-5c49-bfee-4f88ea9e7d0e','','','Nomenclature of the arborescent flora of the U.S. 237.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9db37f7-cac1-58dd-93c9-60be7825bf8c','','','Kew Bull. 1952:387.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6f28e31-16a1-57e1-8e70-df95c24a275f','','','Bonplandia 3:216.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07f70097-6c00-5fa5-80a3-337ead89cab2','','','Taxon 55:502.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fb15ec9-3ef7-575f-bc7c-c9417be1140e','','','Austrobaileya 9:314.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d6eeb9a-6c22-5ff4-9de9-75b29b78de38','','','Agric. Univ. Wageningen Pap. 87-5:1.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3ead14d-16e5-53e0-b39f-6267afb6693d','','','Fl. ind. 2:230.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9376077-1209-5fe6-b479-c37d0309ecac','','','Bot. Jahrb. Syst. 20:404.  1895 "<I>dictyocarpum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c09509f8-abf4-556a-a76d-74dcbc1be7c3','','','Prodr. 191.  1810 (non Moench 1794)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a97dec5d-e312-57c3-a56f-852ee035443b','','','Mem. Acad. Sci. (Paris) 1786:5.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12069058-9d57-51ef-b765-cb3a7ddd968e','','','Pl. rar. neapol. 2:7.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02fdbf57-d539-5ace-a33a-76124831637c','','','Cact. Succ. J. (Los Angeles) 11:74.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f582573-fa52-5e81-afc3-3dca980ab12e','','','Syst. veg. 5:193.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af17e409-691a-5040-ae34-67194b0f6bec','','','Bull. Misc. Inform. Kew 1934:389.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4abb8064-e3d8-53e1-97af-c44d75d6fda8','','','Z. Gesamm. Brauw. 5:126, 178.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34aa69f6-6fe2-5c68-b9b1-2a53014a514e','','','Bot. Jahrb. Syst. 4:34.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6942f7e2-4e63-5c83-9548-60f24590bb62','','','Vict. Naturalist 59:86.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa7a112d-e4e9-551a-a702-5818d9fd8dd6','','','Bull. Herb. Boissier 3:418.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c32fe6d2-296e-5d9f-9b7d-d687e45661c2','','','W. Austral. Naturalist 18:79.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('392de7a1-f2a9-59c3-9c5d-7c0371d1faa0','','','Mitt. Bot. Staatssamml. München 11:246.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a29f3e7-11e3-5234-b9d4-303e6024e501','','','Proc. Calif. Acad. Sci. ser. 4, 25:309.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01fe1b1a-7a74-5f6d-bc3c-385f6a830e3c','','','Pl. Aequinoct. 1(6):140, pl. 40.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5690ea3d-0a4d-512f-9e8a-70686d9c3824','','','Bull. Soc. Bot. France 33:386.  1887 ("1886")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fe172cd-59b5-50e5-a8b6-cc6b3cf7d16f','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 2:95.  1833 (non Raf. 1817)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3ed9cb8-05d4-5845-a873-85edceee5e9b','','','Gard. Chron. ser. 3, 28:254.  1900 "<I>aitchisoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8928fde-f749-5e63-9fb8-25f3ead430da','','','Yuccas Southw. U.S. 2:52.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5385324-ba9d-5a64-af2c-a4b474845af3','','','Cat. pl. horti monsp. 149.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('616eda70-b70b-56b2-8c38-a02a7687182b','','','Descr. icon. pl. Hung. 3:209.  1806-1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f104926-07a4-51bc-8d57-50ccd5ed8e6a','','','Gen. hist. 2:350.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a81ce7c-1be7-5ea9-a86a-3f718951f58c','','','Contr. U.S. Natl. Herb. 8:55.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3eea07f0-c39b-57f0-ab64-6c7e7f5fef3b','','','Pittonia 4:27.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bce458b-2fd6-58ba-ae24-d06759b9dbf3','','','Flora 4:303.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13a87c9c-2e48-5e93-82d1-6da672bd2265','','','London J. Bot. 3:221.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef41e919-f2f8-53bd-b402-8feabbb6c393','','','Calyx 5:136.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0d90605-1379-5471-a7dc-1f0cffcee203','','','Bull. Int. Acad. Sci. Cracovie, Cl. Sci. Math. 1906:3.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8de634bf-a0b4-5b56-aa9b-2a22d038a2f7','','','Succulenta (Netherlands) 42:3.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67946d1c-cf0e-53b3-8d02-e4569570a497','','','Brittonia 32:533.  1981 ("1980")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6648ea5-46c6-5f03-86b5-8ac43420a0b2','','','Forest fl. Punjab ed. 1:159.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a467d9d4-634d-5a85-97f3-b9bb880a7f95','','','Bot. J. Linn. Soc. 156:295.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9965cf67-69a7-5838-b102-8e72457251cf','','','V. L. Komarov, Fl. URSS 11:14.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f37f5b72-3bf0-514b-a562-2c9f6600e080','','','Descriptiones plantarum novarum et minus cognitarum 213.  1879 (G. Maw, Gard. Chron. ser. 2, 13:531.  1880 Apr "<I>korolkowi</I>"; E. Regel, Trudy Imp. S.-Peterburgsk. Bot. Sada 6:499.  1880)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cee0ec19-90fa-5fe1-b48e-f40961429de3','','','Madroño 36:226.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa3c6051-c8f4-5060-a6e3-652140bb6a67','','','Bull. Popular Inform. Arnold Arbor. n.s. 5:50.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('034f9951-8701-5311-99e5-aaafe71317f9','','','Gard. dict. ed. 8: <I>Rosa</I> no. 11.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('540bdc1e-5eb1-5518-aaa8-83b07914e17d','','','Trans. Linn. Soc. London 10:132.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('181d4a00-0097-55fa-ac2f-346e0457d783','','','Sp. pl. 2:837.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e823574-22b9-5ef4-b602-4a37681c2933','','','Bot. Not. 1886:38.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36acb301-f547-5fb0-822f-e976d7ddeb2d','','','Sargentia 7:133.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9513e912-e57e-57ff-80a4-37a68c03dc8c','','','Natuurk. Tijdschr. Ned.-Indië 27:38.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fda5d6d3-0cc2-5512-a4e8-589469755cf8','','','Cat. N. Amer. pl. 8.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2212e40d-fda4-5783-a8db-0192764c8d3c','','','Ginkgoana 1:149.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5362e4f2-30f3-5af3-8319-53b00084af2d','','','Bull. Torrey Bot. Club 24:17.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('638b4cda-7e17-580f-860c-aa823a28b50d','','','Rec. Albany Mus. 1:49.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b1aa114-5517-5124-848c-c23cb819d82d','','','Phytologia 74:9.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b3dd4d3-72ac-5b4d-a23d-ea4186f01fbc','','','Bol. Fac. Agron. Univ. Montevideo 101:52.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8abe2a95-76bb-5062-ac12-3815af7d0174','','','Nieuwe Verh. Ferste Kl. Kon. Ned. Inst. Wetensch. Amsterdam ser. 3, 4:184.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c7a93ee-730c-5df6-b640-f90fe0443d38','','','Contr. Biol. Lab. Sci. Soc. China, Bot. Ser. 10:70.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57847a24-b2de-585a-a0e9-8cf5880b12a5','','','Rugayah & W. J. J. O. de Wilde, Reinwardtia 11:254, fig. 2.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03bf3001-384f-54b0-8d37-86ad82a6cfb8','','','Calcutta Gard. Rep. 26.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad44f919-6a27-5061-a012-59fece11d0e2','','','Ann. Herb. Bolus 3:129.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbf80853-f789-505b-8d4d-6fb6490fef67','','','Contr. New South Wales Natl. Herb. 3:125.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec4dd287-9396-5c69-909c-2ec38ffcd72c','','','Telopea 3:366.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38eafe6f-9329-5fc8-b088-2961831085b9','','','Contr. U.S. Natl. Herb. 16:181.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('732d6d37-92d1-59e9-a1d9-b4207e9068e5','','','Not. fl. France 139.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56b49aaa-463d-5bab-9544-20554acb4efc','','','Linnaea 33:239.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('717ba427-7718-5625-aae6-d3a89f1955f5','','','Hort. kew. 2:8.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23f9988d-45ab-5af8-85a0-4a7b33f7200a','','','Hist. nat. vég. 11:418.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf34ab2b-fd4d-51fa-b2f0-b75693001037','','','Mant. pl. 2:286.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e74d80a3-bbe3-5838-a677-042f5234a192','','','Fl. austral. 3:485.  1867 (F. Mueller, Fragm. 5:66.  1865, pro syn.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14614d06-d94c-5d62-acf6-4988ff64e70e','','','Leafl. W. Bot. 5:125.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adb933f0-0f82-5864-83f6-a2738a91390b','','','Syn. pl. glumac. 1:425.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf220bde-b143-562e-ae62-c7d799804a44','','','Syn. fl. N. Amer. 1(2):184.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23dd73c9-8624-5879-b514-5a5146d2d896','','','Bol. Soc. Aragonesa Ci. Nat. 6:28.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('092f8348-d2c0-51f5-ae05-1e24ebf8d7fa','','','Fl. fanerog. Estado São Paulo 3:135.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('909bde44-deac-5a57-8c1a-c6b4ef954fb4','','','Meded. Rijks-Herb. 40:73.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7626a7b1-82d3-55ee-a341-37bf7b0e7c7c','','','Bull. Mens. Soc. Linn. Paris 1:399.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8854b6ca-cfc9-5244-9b44-672413a7ecf0','','','Observ. Mesembryanthemum 2:164.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fc682a4-d723-5711-9ee0-902cdc94ada5','','','Contr. Gray Herb. 75:35.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4c53271-7666-545a-b131-43d12b934dd7','','','Repert. Spec. Nov. Regni Veg. 7:229.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53dec31e-a963-5984-a60e-1c3e42dad60d','','','Bull. Soc. Bot. France 55:214.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5037b17b-62f3-5454-bc58-66e651e39951','','','Bot. Reg. 11: t. 949.  1 Feb 1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9f2a9bb-b41b-58b6-9808-573a2d589eab','','','Epiphytes 7(28):89.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f4cd518-9888-5346-b15d-1e9e1e256664','','','Nova Acta Helv. Phys.-Math. 1:39.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8857710-4f96-5593-b66a-ddc7dc406060','','','Pl. jamaic. pug. 14.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c57c73a-6e4b-5270-b27b-c4a597a11a26','','','Verh. Zool.-Bot. Vereins Wien 3, Abh.:130.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bdfa849-22da-5e8d-909a-9a6b218adb7d','','','Acta Phytotax. Sin. 33:263, fig. 11.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6050ec06-72ae-555a-ab9f-2f49410c845d','','','Bot. Mag. 80: pl. 4810.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6df56c23-124b-5dfd-8f9d-c15aa40155a8','','','A. A. Orlov, Trudy Prikl. Bot. 20:300, Fig. 7.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8149b846-8ee1-5871-b1b4-697182a2bf39','','','Bull. Soc. Bot. France 41:504.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00126369-1e56-51b5-ab25-ddc5a9789dfa','','','J. Linn. Soc., Bot. 28:138, t. 22.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f709a576-30e8-5095-ad32-bc79c3633095','','','Ann. Soc. Bot. Lyon 19(Compt.-Rend.):5.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aec0d349-02b3-5cb1-b9e4-c9c28bdd53f6','','','Linnaea 1:410.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d60d8c78-0d4b-5b55-87db-bc14c3708383','','','Proc. Biol. Soc. Washington 29:128.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0383af3-5524-5949-872f-38642038d91f','','','Belgique Hort. 28:140, t. 4-5.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c71217e-dbda-5925-9e21-609788487788','','','Symb. antill. 5:426.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f491a066-f52b-5940-9e1f-d60d1086da0e','','','Vict. Naturalist 73:174.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b0f247e-17b7-53f2-95a6-ed62a6ce8498','','','R. M. Polhill, Flora of tropical East Africa. Nymphaeaceae 10.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3322f27d-9462-5c3d-ae3e-1beacce2b92c','','','Prodr. 2:438.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93391621-5d63-5919-b0b2-f9cf1236a4b1','','','Trudy Prikl. Bot. 42(2):286.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7df277f2-5796-5826-adee-11ecd0be5b70','','','Sci. Surv. Porto Rico & Virgin Islands 6:128.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b25f5340-6009-5f25-b796-e88e86efc825','','','Linnaea 38:509.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86c23cb2-5292-52c5-8079-b86966c8b79e','','','Taxon 15:22.1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5071316d-c726-564c-928e-30cd6d945c86','','','Verz. Pfl. Casp. Meer. 72.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a145480f-092d-511f-9971-ea724ac2882e','','','Flora 55:531.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77931c5a-23fd-5904-a1bd-fa89bd1196f7','','','Bartlett, Rhodora 15:83.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89b0307b-42d3-5407-aa95-5e38d79089ca','','','Nov. pl. descr. dec. 4:51.  1797 "<I>ciliato-glanduliferum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa1657e8-58cf-5086-9b85-934971b99ede','','','P. S. Pallas, Neueste Nord. Beytr. 3:362.  1796 (Briefe Siberien 218.  1796)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('350b6e98-edfc-5694-8626-68f163c3cf62','','','Syst. nat. ed. 10, 2:1227.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('159635fc-63c1-58b8-9d60-826dd6b828c5','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:94[folio]; 1:115[quarto], t. 35.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21e022d8-7628-56af-b933-cd4e1038d5f6','','','Notes Roy. Bot. Gard. Edinburgh 5:261.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29df05e5-e5f1-52f6-ab1b-bece4ab94511','','','Acta Mus. Richnov., Sect. Nat. 4:29.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b09c9b13-594f-5d0d-b5ad-b12211f76442','','','Kulturnaya Fl. SSSR 1:111.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85811a2b-d76a-599a-ad10-79ce26bb4b4b','','','Oesterr. Bot. Z. 51:294.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd62fa1b-66b7-5fa4-9a65-c16ea4ab91af','','','Abh. Schles. Ges. Vaterl. Cult., Abth. Naturwiss. 150.  1869 "<I>beaulueriana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94f347e2-5926-55df-ae99-13dcc9274995','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 20:469.  1875 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2256b083-3bfe-5d2e-9630-45f6b62677e0','','','Sp. pl. ed. 2, 2:1405.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17294af5-d89f-5e30-a148-a6af2066eae4','','','J. Bot. (Morot) 2:337.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('657f1df5-3265-503d-9250-71fc1a64ce2c','','','A. L. P. P. de Candolle, Prodr. 11:325.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('089baa3e-bd16-5f7f-8de3-6fdd22ed3d24','','','J. Linn. Soc., Bot. 14:244.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ac474a4-35ee-52e5-8d93-659cba726ca3','','','Rhodora 49:214.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25748902-1bdb-5af1-9441-1c15bb10cad1','','','Trans. Linn. Soc. London 29:132.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('747e4bda-c237-5296-b529-370e07288687','','','Abbild. Beschr. Cact. 2: sub t. 14.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('204f13ed-ac43-5c39-b2b6-e998ce041e04','','','Bot. Beechey Voy. 21.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ced5920a-9680-5d4d-8549-bd29ad0a73f3','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 14:690.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d60e3bf5-5fe8-536c-9a22-bc72aacf1657','','','Fl. lit. inch. 2:99.  1782, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e25c498f-d0dd-5f33-b2af-775aed264e74','','','J. Bot. (Morot) 12:262.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad1bfcb5-18ee-5992-a74b-13afafda5623','','','Sida 13:123.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e32e40d8-1c29-5cb1-940f-982bc5bf15c5','','','Zoë 5:228.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be2615b2-0985-5645-ae24-54b28bd894b9','','','Mem. Wern. Nat. Hist. Soc. 3:409.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('050081a9-022a-5e88-a8bd-7f62899e62fc','','','Michigan Bot. 15:104.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68ddc665-74fb-5099-abf7-3f340cde20d6','','','Bijdr. 907.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f12630f-c200-56cc-ae3d-f130f230847c','','','Arbor. frutic. brit. 2:1012.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da9b25bc-513d-59e6-8b89-73dba4e340a5','','','C. F. P. von Martius et al., Fl. bras. enum. pl. 2(1):485.  1829 (Agrost. bras.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('959acd3e-0203-5719-ab9f-f60390c0c58c','','','Syst. nat. 1:324.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1807332a-a618-546f-8d04-f9da175300f9','','','Arch. Jard. Bot. Rio de Janeiro 4:73.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f11f67e-c09e-5199-9604-1bc8b02d78d0','','','A. P. de Candolle, Prodr. 1:358.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59ad20aa-2c5d-579b-8e82-c50516570bf5','','','Fl. Kamtchatka 1:239.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21e14403-51f5-54cf-a508-0158b9cd2fc6','','','Wrightia 2:174.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ade59596-7e4b-595e-8fd7-1661aa85a5ca','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:142[folio]; 1:176[quarto], t. 58.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2406ee8e-11b2-5263-b1ea-c77e789ff2ce','','','Biol. cent.-amer., Bot. 2:82.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77a90d44-9268-52e9-ab06-9df5c5892173','','','Acta Phytotax. Geobot. 38:382.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48a9ef73-1b5f-52e1-b1de-8325e58f4204','','','Prim. Reun. Nac. Soc. Argent. Ci. Nat. Tucuman 1916:224.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad5e09ab-8503-53ca-89ce-e4cc60d9af9a','','','Bull. Soc. Roy. Bot. Belgique 81:28.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f97e3dd-d917-5b26-8b31-b1f862a56bb1','','','Phytologia 36:52.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7a1e3f6-5c25-5be0-ad6f-a130734a3101','','','Acta Univ. Lund. 27:169.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('537057be-e499-5fb8-a0dc-03a134759b68','','','Repert. Spec. Nov. Regni Veg. Beih. 1:846.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6b2473a-5edd-5a2e-820f-254e43e5172c','','','Vved. et al., Opredelitel'' Rastenii Okresnosti Tashkenta 1:41.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc8ab8f0-4050-50db-a3a6-ede64042ea45','','','Sinops. Pl. Filip., Atlas 16, t. 16, fig. C.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6f10844-2c01-5d40-87da-df3296fa5448','','','Spic. fl. rumel. 2:423.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('856aea87-d2e6-5acd-87da-2c9cb2850d4b','','','Bull. Int. Acad. Sci. Cracovie, Cl. Sci. Math. 1906:287.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71767d92-d442-54e4-965a-59dbedd6fc44','','','Tenn.-kinenb.-chosa-hokoku, Shokub.12:33,46. (Veg. Mt. Apoi).  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('019ed837-de61-5510-a4fc-ca5c2a8b4fe9','','','Prodr. 3:97.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2b6c186-e9cd-5609-8baa-6cb43e0d4e2a','','','Fl. Kavkaza 1:206.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10635df4-d274-59df-80d4-a78b8d6fd297','','','sensu Fairchild in Plant Inventory 87:32. (PI 67501)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ffeba14-1127-5c51-b61c-5fd0866dcf79','','','Fl. Ned. Ind. 1(1):20.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c463a658-86c0-553b-a96b-9cfe794cafb6','','','Bull. Misc. Inform. Kew 1935:229.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fde4486-9263-5224-a4c0-c721d08b7d52','','','Fl. France 5:14.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d6bb533-a75d-5a3d-aa27-6e4377553c77','','','Bot. Jahrb. Syst. 21:445.  1895 [preprint], 1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17cc9803-9433-5491-9a97-87627d7e8e7b','','','Pl. bequaert. 1:355.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3abc63ee-cfaa-5fbc-b302-0f6a111024c6','','','Bot. Gaz. 23:246.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f418ff29-d635-5ab9-ae59-e50c04b4d535','','','Syst. nat. 2(1):385.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('639af41d-5361-50c8-92f2-9b613bd6b88f','','','Ann. Mag. Nat. Hist. 13:188.  1844`','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c20780d-a491-5e36-8cf6-5927cba5cbe5','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 11:433.  1867 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d051f1c0-c534-5708-945d-84060f41a75e','','','Chaetopt. 27.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5504fda-778c-56bc-857a-4a97c0e3d7cc','','','Bot. Tidsskr. 60:51.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('583753ed-77fe-50ad-bfa0-6bb77e0fe9e0','','','J. Linn. Soc., Bot. 37:507.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19b6b9a5-b5bb-58b7-8e0e-6bcaa8edc67c','','','Linnaea 43:101.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d45b4ded-72f8-5b9f-8e73-8b3c4442732b','','','Hickenia 1:22.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('189455b2-a197-5bcd-a628-c2959e2f60e0','','','Byull. Moskovsk. Obshch. Isp. Prir., Otd. Biol. 49:90.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1c3f352-34d0-5829-9f69-6b81c48eace3','','','Cat. horti camald. 26.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15e8b8f7-b37f-5e59-a89a-4ef71eb63542','','','Icon. 3:14, t. 227.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2696d8c-b0de-58d2-a89d-331094afecc9','','','S. Balle & N. Hallé, Adansonia sér. 2, 1:251, t. 10.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2e5b76b-4d35-543c-af02-d8bc9cf2f535','','','W. T. Thiselton-Dyer, Fl. trop. Afr. 6:570.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a183fc38-2830-5748-bb80-56747858f977','','','Flora 25:239.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43f2f571-286b-55a2-a054-6ca57f58bec7','','','Fl. Brit. India 1:533.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f4dbd1d-8669-5e53-8902-e924ec11c36f','','','Ann. K. K. Naturhist. Hofmus. 27:43.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('855b350f-59ba-52c3-a7b7-4765f9cc68bf','','','Nouv. Ann. Mus. Hist. Nat. 3:457.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0a59e19-f98a-56b8-acf5-add357ab6ec2','','','Kew Bull. 40(4):798.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69204ecc-1376-5997-a880-48eed95d55e1','','','Herb. fl. bras. 528.  1841; Flora 24(2, Beibl.):18.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dc0a999-5b1e-5d0c-905b-e0e67789060d','','','Proc. Amer. Acad. Arts 26:170.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5efd1c1-0841-56cd-8380-581cb834d13d','','','H. G. A. Engler, Pflanzenr. IV. 46(Heft 20):262.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f38dfec-ef4c-5f9c-9432-ac26fb01078f','','','Mem. Wern. Nat. Hist. Soc. 3:408.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00e25ac3-798c-5946-b02f-aa41442a7780','','','Bot. Not. 114:49.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0296089-2573-5ef6-b93a-97c53c10cd0a','','','Methodus 535.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69732cc5-7325-5eb6-bbbe-04f3104fb322','','','Phytologia 25:66.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a75b25ec-d6fa-58bd-b1e4-0add10f9df47','','','Trans. Linn. Soc. London, Bot. 1:171, t. 24.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83a236b5-415c-584a-9d7f-8199c917abea','','','H. Lecomte, Fl. Indo-Chine 2:572.  1916 (non Walp. 1842)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4333ec51-fa81-5ff7-87b4-2a4e103d3764','','','Prir. rostlin 1(Ranunculaceae):22.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d482ec52-81f7-58e0-977e-a108fd238263','','','Hand. Cakteenk. ed. 2, 812.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfe7b504-d42d-54d1-a328-7093593e6b29','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 10:324.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7726613-15bc-54e7-90bc-640de605c4fc','','','Trans. Linn. Soc. London 2:347.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa78bf15-a086-5b6f-88f8-48025b16dd49','','','Sp. pl. 1:259.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53689ac9-e444-56b2-883e-763940a283ab','','','Bull. Jard. Bot. Buitenzorg sér. 3, 4:226.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d85a84a-4489-5298-aae3-270d68760fa4','','','V. L. Komarov, Fl. URSS 28:592.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a1de411-3e9d-56b5-9157-0ab554348d55','','','Arch. Jard. Bot. Rio de Janeiro 13:87.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('222a3494-40a1-5096-939e-384764ce602f','','','Fl. germ. excurs. 2:785.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8470d2c4-c6ac-5155-85d2-1a1b38148596','','','Canad. Field-Naturalist 61:98.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47a414e6-f357-5d7a-b594-b3578cc2e8ee','','','Berlin. Baumz. 65, t. 4, fig. 1.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c429c12-c467-5fbb-90ef-2eadb108052b','','','J. Linn. Soc., Bot. 16:206.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fd15103-d128-53bb-ab00-a7f4e9d54681','','','Alpina 3:47.  1808 "<I>Koelera vallesiaca</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e39c111f-51f9-5fda-932c-eea19eaf6396','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. ed. 2, 14e:15.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d59279d-8f1e-58ac-b8c1-cf7c16465bc6','','','H. G. A. Engler, Pflanzenr. IV. 129(Heft 53):581.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c04a4645-cb98-5d66-b024-27fff17634a1','','','Sp. pl. 3(3):1664.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('211d2305-d7eb-534f-864b-e01bce37c808','','','Willdenowia 33:47.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f999c103-a6e6-58b9-b023-436855b57a9a','','','Vict. Naturalist 3:157.  1887 "<I>lochae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5291e778-3c15-549c-8b8f-8c4771c58505','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 6:394.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55e34462-6ca9-51ac-8426-61d0423149f5','','','Notes Roy. Bot. Gard. Edinburgh 31(2):204.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca579316-c464-5e76-a967-61ec58158c13','','','Bol. Soc. Brot. 11:122.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38529193-88e2-5681-9c40-df2b8838a906','','','Torreya 33:70.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18cb156d-6e53-5ca3-b300-8ffbd1bbe6c0','','','Bull. Torrey Bot. Club 33:200.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('310a7425-c20d-5457-b472-16c54a4962b1','','','Enum. pl. 1:306.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c6b4c1f-77d5-5ba8-a9fe-410defa29802','','','Hort. herrenhus. 1: t. 10.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16af5237-4e54-5eef-b5e1-8016ff840445','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:143.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f519405-5375-530a-81b5-8232e25fae75','','','Fl. peruv. 3:9, t. 231, fig. b.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42e7a1cf-1bdf-527c-92b8-bbc9214033e6','','','Nouv. mat. fl. atl. 292.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8067d269-6994-5775-a905-0f7897c14d6a','','','Gard. Bull. Singapore 26:134.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f8ad363-0d6e-54da-8aa4-04301bd46eee','','','Fl. francisc. 215.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5ca8026-3c8a-5f4c-91a0-5cfd152a3eb8','','','Anales Mus. Nac. Montevideo 4(2):6.  1901; Speg. Stipeae Platenses 6.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26784560-f610-538a-8523-0706b6584a0c','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. ed. 2, 21:151.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e494da9f-d337-5042-9080-9d59a820b771','','','Fl. taur.-caucas. 2:407.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6110b6a9-bd24-5bb5-9042-77b7546ca864','','','Bijdr. 856.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77f19de6-ae62-5fba-add2-327969afdf24','','','Bull. Soc. Bot. France 33:64.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9600fea3-15de-5c99-b6c8-caa2a3f77551','','','Fl. sicul. syn. 1:366.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddf8b9c8-c447-5dcb-a725-d1d2b7b1b8fd','','','Kew Bull. 45:157.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea017f04-b40d-5033-b56e-ea23a86e67e7','','','Kakteen Südamerika 1:269.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14718014-98f6-5818-8a9e-8925b2236adf','','','Gen. hist. 1:504.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81cfcd9f-2058-57df-8748-afefb6fa5859','','','Syn. pl. 2(2):477.  1807 "<I>Cosmus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39d48361-f9d8-5dc7-bdef-6248276be29d','','','J. B. A. P. M. de Lamarck, Encycl. suppl. 2:609.  1812 (non Lam. 1788)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08bc9efb-b97d-5bb4-867f-d4cfad5582aa','','','Bull. Mus. Natl. Hist. Nat., B, Adansonia sér. 4, 11:378.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('074fbb70-7abe-5678-980e-accca70a40ac','','','Dendrologie 1:5.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adf57daa-f39a-509b-8faf-c4252ea38750','','','Bot. Jahrb. Syst. 31:92.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45a05bda-8157-5354-b7ef-dadb488318ef','','','Mem. Real Acad. Ci. Barcelona ser. 3, 12:4.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bee55d7-ea39-5806-a01a-4937a78caeb5','','','Madras. J. Lit. Sci. ser. 3, 1:41, t. 5.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46b81678-c6eb-5403-b3ca-356f3a7bf376','','','Sarawak Mus. J. 50:152.  1998 ("1996")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56412cbe-c15a-54e6-80ab-59a3e6fbacec','','','Ann. Missouri Bot. Gard. 59:320.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fea8e71a-8ec6-5683-b3b8-09b06011e268','','','H. Lecomte, Fl. Indo-Chine 7:363.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3881fda5-c44d-5bef-bd21-b87f5f5a84f1','','','Fl. bor.-amer. 1:306, t. 105.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a99a20f-7984-5681-bcee-89da62733eb2','','','Fl. carol. 237.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53e79e30-70a7-5e4b-ade8-46a70e5fa03b','','','Encycl. suppl. 3:751.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('210cffe5-3a15-5e86-a7e0-b5d662a3fda0','','','Bull. Soc. Bot. France 71:1181.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e95abef2-35c7-5689-818f-daad2a63ebc9','','','Amer. J. Bot. 28:360.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4ce574e-3d56-5a76-80b5-d5a3959e8287','','','Pl. labrador. 20.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ed0468c-5a0e-5228-829f-c6e24c7400bc','','','Prodr. 6:470.  1838 ("1837") "<I>cluytiaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30901a9a-4f6e-504e-908c-3ff2f27ea1c7','','','Cent. pl. I:6.  1755 (Amoen. acad. 4:266.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('109e27fd-db47-5052-add3-38ef12e7bdab','','','Fl. bor.-amer. 1:95.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cafe8b6-5c71-5c4e-a993-4499418277e0','','','Repert. Spec. Nov. Regni Veg. 7:146.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9a7b8ef-1da5-51ed-9e03-2c826889b5a3','','','Fl. ludov. 14.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d461ce12-0e10-54af-bc06-4cebde4d59d4','','','Muhlenbergia 4(5):68.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('366c9f41-b829-5421-b02f-7ce9cae2ddde','','','Enum. hort. berol. alt. 2:122.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7af0b13-ab50-537d-a292-52174b406b12','','','P. E. Boissier, Diagn. pl. orient. ser. 2, 3:170.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('093c811c-6281-586d-b68d-3d13ea00ee1d','','','F. A. W. Miquel, Pl. jungh. 382.  1854 "<I>pseudo-ischaemum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('239547c0-4a5f-54ee-99a9-46b2a49cdcf7','','','Gen. sp. orchid. pl. 118.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae943856-5658-525c-86d4-402b0abbdb26','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 214, in adnot.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6241e12a-86d3-5a8a-808a-e35804981c74','','','Not. pl. asiat. 4:139.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57628b5d-9730-53d7-811e-a444b9c8a851','','','Phytogr. Lusit. select. 2:198.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2faddfeb-ca63-5cc5-b4f9-af0e78be1621','','','E. A. Durand & G. Barratte, Fl. libyc. prodr. 183.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee2e0b2a-6254-5a0b-a111-2fac5a2fcf49','','','Bot. Mag. 145: t. 8829.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffca68eb-2723-5478-8e8c-f4156d742944','','','I. B. Balfour, Notes Roy. Bot. Gard. Edinburgh 9:208.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8d9453f-5735-5ff1-bd5e-9e577eb20c4d','','','Nomencl. bot. ed. 2, 1:107.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88b4cba6-4e7f-5316-88e3-97457c8bf791','','','A. Guillemin et al., Fl. Seneg. tent. 1:240.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c630570-2e60-5c29-b007-dfb37f22e64b','','','Gartenflora 48:649.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d55ff33e-a24b-5f9b-9884-721873b1d606','','','Telopea 3:178.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('121bd15e-e208-50c0-a4db-9cf76f852540','','','A. L. P. P. de Candolle, Prodr. 8:524.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7ef5b82-e8a3-5d2f-927d-3ad104ae6ebc','','','Fl. trop. Afr. 2:357.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30e30d74-9926-519e-a377-170fde482370','','','Gard. Chron. ser. 3, 81:53.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c1f8e00-a88d-5dc1-8143-d5bec8bdd923','','','Kulturnaya Fl. SSSR 1:112.  1935, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3ccb885-c1ec-5adf-a140-de28e55f5eca','','','A. L. P. P. de Candolle, Prodr. 13(2):113.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c512b7c9-6254-5573-ae8a-f27e0ed06176','','','Bot. Jahrb. Syst. 26:391.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('707f5c60-0acb-5b01-9257-ba15b054f490','','','Prodr. 551.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b2dde46-1fd0-5bb8-a05a-0b4bdd323ec3','','','Fl. atlant. 2:364.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b715efc9-03de-5ded-8c41-a621e9bcc6a3','','','Acta Phytotax. Sin. 17(3):76.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3887934f-9525-55a2-8da1-4ef1c6d5833a','','','Mém. Soc. Sci. Nat. Math. Cherbourg 24(sér. 3, vol. 4):224.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eca2d714-60de-53bd-a832-b6f2114e0fb1','','','A. D. d''Orbigny, Voy. Amérique mér. 7(3). Palmiers 121.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aaae3d93-575e-55b2-a923-c3c18094db37','','','Fl. austral. 6:452.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb5a77d9-c24d-5f84-8446-65422a262159','','','Abh. Königl. Ges. Wiss. Göttingen 19:99; Pl. lorentz. 51.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b214cdce-4a60-5269-b53f-fcc7bed04bc9','','','Trudy Bot. Inst. Akad. Nauk S.S.S.R., Ser. 1, Fl. Sist. Vyssh. Rast. 10:115, t. 49-58.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1868473e-5d16-50a1-a71b-a9ed6a7bca65','','','Gentes Herbarum 1:191.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('234dc662-ae9b-5fe9-9702-a8ded0ba7421','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 12:128.  1824 (Gen. pl. Umbell.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f144dfae-129e-5e12-b14e-811bd354c659','','','Sp. pl. 1:320.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8310125-165e-5c08-a103-b656058f47ac','','','Fl. angl. 23.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09d190aa-5911-548b-8b88-ee9e159ea2d8','','','A. L. P. P. de Candolle, Prodr. 13(1):544.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a41ecbd3-4b08-5728-810a-532b0e52579b','','','G. Bentham & J. D. Hooker, Gen. pl. 2:660.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40000ff7-5c0a-57b3-9d51-89c8af60bd45','','','F. A. Pax, Bot. Jahrb. Syst. 15:376.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8f65ae2-8dfc-5c90-a637-0f2692fb4049','','','Sp. pl. 2:773.  1753, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2aedf34-9dab-573c-ae82-428e0e3785d8','','','S. Watson et al., Botany [fortieth parallel] 180, t. 19.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f57f7cf9-7747-589a-b990-e857bc4902ae','','','Bull. Soc. Imp. Naturalistes Moscou 10(7):69.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d2d3fd8-5ce9-53c5-8f24-accc9a1aa10e','','','Allertonia 3:302.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82a67538-d013-5754-8360-d31f6abfbaaf','','','Sp. pl. 3(2):982.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('490aa715-06ce-5971-b03b-a21869c4de3c','','','The Wild and Cultivated Cottons of the World 153.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('397b8c02-94bb-5d58-8371-ad8a95ae8ac1','','','Notul. Syst. (Paris) 13:35.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d350f9d8-22fe-52ee-aaff-dd76b3ca1db8','','','Madroño 28:159.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d7ebb5a-4ba8-5c67-a4b7-762bbe83f604','','','Berchtold & Seidl, Oekon.-techn. fl. Böhm. 1:425.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94a500b3-f298-584e-83b4-0d4745ebe0c7','','','Kew Bull. 57:101.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7671003d-4ecd-5e5a-9651-1c39fd5b1f43','','','C. Gay, Fl. chil. 4:232.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb850fbf-a596-5d87-bb33-c5f67421e798','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 4:83.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd55f8f6-687d-5b10-a7bc-0f30c05ba2b8','','','D. Prain, Fl. trop. Afr. 9:129.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f57bd043-c865-536e-a794-994886912bd1','','','Sp. pl. 4(2):1143.  1806, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f773a0cc-c49c-5173-b420-0733d9b7f5b5','','','Mem. Soc. Sci. Nat. Maroc 5:277.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d38b6b76-7707-57db-91a2-a060aa302668','','','Notizbl. Bot. Gart. Berlin-Dahlem 13:423.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c6ec2a2-d944-5f0f-984d-577b10115332','','','Repert. bot. syst. 2:956.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d95f9caa-8e3b-5a68-abf9-9c7de2cb1822','','','Publ. Inst. Invest. Geogr. Fac. Filos. Letras Univ. Buenos Aires, A 10:26.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e855135-34ba-5dc2-90c9-95eebdee16c3','','','Diagn. pl. orient. ser. 1, 5:3.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('961b1e86-a5dd-5fce-954a-ab7eb5aca880','','','J. L. M. Poiret, Encycl. suppl. 3:750.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d450106b-200c-5e84-bb1e-74d4f793c003','','','Gött. Gel. Anz. 1821(3):2073.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18f78655-b850-54cf-9b52-21f8da48ecdf','','','Prodr. 80.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('847ae813-e5dc-5a66-8067-4a5c30d404b2','','','Gard. Chron. ser. 3, 47:314.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adb8269b-c84e-5957-b055-a4222618a36b','','','Backer, Bekn. fl. Java family 107:23, in clave.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57035095-b2f2-5ced-af08-c3608a8e0a2f','','','New Mexico Agric. Exp. Sta. Bull. 15:58.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b193a861-605a-5733-b11f-019ca0385501','','','Baier. Fl. 2:103.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9361247-5aa4-55d9-a6c4-c9c0cea85ce3','','','Fl. orient. 4:551.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea8a837a-2a65-5edb-bcd7-739d4b1cfe5a','','','Sp. pl. 2:949.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99f17a30-ff24-54b1-b432-63a5b0144f0f','','','Scripta Hierosolymitana 12:118.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('716ae23d-ed3d-58b4-a06d-481539d447e5','','','Fl. bor.-amer. 2:145, t. 180.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55ab184d-50ad-5732-a742-44538733f8ed','','','Bot. Jahrb. Syst. 29:42.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f318cc72-b544-5c52-8f7e-eca4cbc5d829','','','Brittonia 17:132.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf5ef048-2ce2-5a9a-b186-fb5d3624b8fa','','','Icon. pl. Syr. 5:5.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cddcad0-f55b-50de-bffd-373689bc8939','','','Mem. Reale Accad. Sci. Torino ser. 2, 16:20.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0dfe063-c0dc-536d-b45c-abf02b80364c','','','Bot. Jahrb. Syst. 25:395.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b7b2b5f-0b72-5da4-8981-be5d4aa30b9e','','','Proc. Acad. Nat. Sci. Philadelphia 1848[4]:10.  1848 Mar-Apr (J. Acad. Nat. Sci. Philadelphia ser. 2, 1:154.  1848 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9518efbd-ef05-50d8-9fe0-de945ea562ea','','','Fragm. 4:50.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cad6b8bf-8236-5560-baa2-8344e47f35a7','','','Gard. Bull. Singapore 17:476.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d653ec42-dfad-5e28-8b32-1faf0d3da09c','','','Trans. & Proc. New Zealand Inst. 57:40.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58c2e874-f496-5b54-97eb-fe2c64104bb8','','','Fl. cochinch. 2:648.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('580d2e52-d004-5613-b6a0-529a8c0b67ee','','','Austrobaileya 5:45.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9abf02b3-d9c9-5c98-9d83-b216616f31f4','','','J. Linn. Soc., Bot. 17:379, t. 16, fig. 6.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07d84abc-b4d2-5a6c-866c-c21a22a20e75','','','Kew Bull. 45:655.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edb12ba2-5012-5101-a86c-40c734b1ddb4','','','Nov. Actorum Acad. Caes. Leop.-Carol. Nat. Cur. 11(1):88.  1823 "<I>ferrugineum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e1b6349-cc5c-5e87-b296-fab56fb75f7a','','','Pl. asiat. rar. 2:7.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa678c7f-73d1-5961-868e-bbddcefd7d24','','','J. B. A. P. M. de Lamarck, Encycl. 3:625.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d3da87f-77d3-5553-9c0d-95e6f19c6c25','','','Linnaea 18:555.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b4ac7ea-2b4c-5e63-af32-e3ce3e0cfd7a','','','Bot. Mag. 54: t. 2786.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76021241-eb61-5629-bf85-3d675b760457','','','A. A. Orlov, Kulturnaya Fl. SSSR 2:152.  1936, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd0d112e-8ed1-50ec-ac81-4c8fde119da5','','','Malayan Misc. 2(7):69.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de26031c-ee94-5b43-99ca-b0bb5a444224','','','Syst. Bot. 40:496.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cb796c4-c97d-549e-bfa2-cbe49eb6c4b5','','','Rumphia 2:49, t. 95, 96.  1839 ("1836")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5add1f46-7b03-5e81-805d-f25aaadb430a','','','Handro, Arq. Bot. Estado São Paulo 3:64.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78a6a38e-d81e-5ee1-affa-53f966d0c641','','','Bull. New York Bot. Gard. 3(9):15.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('facc519e-a3a5-5b51-b795-5d2419ec5281','','','Mitt. Inst. Allg. Bot. Hamburg 8:129.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('355a9e64-bd8a-58b6-ab96-7037e832255f','','','Vestn. s.-kh. nauki 10:129.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d7b5aca-b6b0-54a9-9bbc-03f0adac460c','','','Gard. Bull. Straits Settlem. ser. 3, 7:20.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4eb0eddb-c717-582d-9e4f-c23a065e2923','','','Mitt. Naturf. Ges. Solothurn 20:57.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f9ddeb2-e26b-5d0e-b615-4d206ea0f119','','','H. Lecomte, Fl. Indo-Chine 7:460.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9b16911-7003-5b49-88a1-919229606bfc','','','Enum. hort. berol. alt. 2:25.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8dc4fbf-2276-5f69-98d4-39476e3437f5','','','Acta Bot. Mex. 4:2.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04787f5c-881a-5561-8602-8e8ce90ba3f7','','','J. Linn. Soc., Bot. 11:359.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42bb20e2-8a3f-51fe-ae3f-e1d782e648ce','','','Bull. Torrey Bot. Club 36:695.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b23d4be6-df2f-502f-9f96-a9ebde6dcf38','','','J. Arnold Arbor. 15:3.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdacf5ba-61d4-57e3-8fe8-b8b2d970fdad','','','Blumea 58:41.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdb628ea-dfb1-5984-bf2a-104aedb6e37f','','','Sp. pl. 2:783.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c88a9ed-8447-529f-9349-ae7ae21adf0f','','','Fragm. 3:121.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfd03055-9ff7-5658-b602-147a3c7f85fa','','','Oesterr. Bot. Z. 29:262.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('188789ca-13ec-54bf-965d-a0e6a0e612a0','','','Repert. Spec. Nov. Regni Veg. 41:232.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bd1ddb2-acc5-51ee-9a47-c8f5d421d29b','','','Comp. fl. ital. 195.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08a1c31f-2bd9-5c79-abcb-a2ee9d33c20c','','','Fl. Filip. 357.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35064e3b-74da-536d-bc8a-2dcdf15fc653','','','Actes Soc. Hist. Nat. Paris 1:107.  1792 "<I>hirsuta</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24aaa0cc-cb38-54b0-b972-fd7ed46bd713','','','J. S. C. Dumont d''Urville, Voy. Astrolabe 2:34, t. 14.  1834 (Sert. Astrolab.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3da3b996-7177-5811-8049-c6e9df422338','','','Pabstia 4:13.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72c9ae54-3997-5598-82b3-9c9a7c1e20fc','','','J. Bot. (Hooker) 2:152, t. 7.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebd778a7-d68e-567c-b0f4-8f2313c6a823','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. ed. 2, 14e:113.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44fe98d6-167d-5f1e-9dc6-b68ccd0c5494','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 4:138.  1770','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd037939-495a-57e7-8be7-1f3fda7b6635','','','Wimmer & Grab., Fl. Siles. 2(1):51.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cca1469-bb5d-55c4-9bac-9bdc120ce15d','','','H. G. A. Engler, Pflanzenr. IV. 129(Heft 53):201.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7a51916-aca9-5d8b-a6b0-8ffac3453a0c','','','Phytologia 10:439, t. 11, fig. 5, 6.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ee5dc56-5cc9-585b-aefa-c9aac48658ce','','','Beih. Bot. Centralbl., Abt. 2, 36:472.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d6bdbc0-35f4-5303-bdca-0a422de78b07','','','Cent. pl. I:24.  1755 (Amoen. acad. 4:285.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b4f6c5b-a475-59d7-8da8-4acbb3d4a0e5','','','Sp. pl. 2:581.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf36bcf9-277a-53ac-b682-63ec22db8de5','','','Blätt. Kakteenf. 1935: pt. 6.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ee66917-17be-5e2c-9646-2bf6cdad072a','','','Hist. nat. palm. 2:100.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c636e24-9bc7-5e43-a23f-f89c9f970af6','','','Gard. Chron. ser. 3, 37:2.  1905 "<I>perringi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44c0a7ac-bb1b-5ed7-b91c-15d6abceb8ab','','','Hort. kew. 3:492.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a68dcedc-1aba-5839-a707-453ac0fb4a67','','','Fl. forest. Cochinch. 4(fasc. 25): t. 388a.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17d838e2-a137-5e39-9bf2-74bf2b043626','','','Bamboo Gard. 160.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fefb18d2-734b-52c8-a829-954454b38357','','','Muelleria 9:8.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d7bcc8a-08fe-51cc-91e6-941aefa642fc','','','Acta Phytotax. Sin. 17(1):47.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdd38acd-c20d-5abd-afa5-be92d6cce413','','','Contr. Gray Herb. 59:23.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb447b00-4e5f-51da-b835-7584aba8e77b','','','Blumea 2:323.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78770683-c859-514e-bef8-0696f6a45a20','','','Bol. Mus. Paraense Hist. Nat. 5:337.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5cf6871-0569-5d23-8a45-aa107d16dc27','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 26:20.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbac63ad-44ef-5f3c-a7b7-e05cbbe5982a','','','Elem. mat. med. therapeut. ed. 3, 2:1136.  1850 (J. Baker in W. T. Thiselton-Dyer, Fl. trop. Afr. 7:311.  1898)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef133a1a-1063-5f97-aa4e-eb8b7bf76ec0','','','Res. Pines Australia 233.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb9547f0-324d-5593-af80-f984fff24359','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 6:329, 336, t. 5b, fig. 3.  1778','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b4b09ac-029e-5bc8-abc2-b8c9018fe4c9','','','Bot. Sturt''s exped. Australia 4.  1848 (C. Sturt, Narr. Exped. C. Australia 2: App. 67.  "1849")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('958652dc-058a-5be8-96a5-0a0c17d571d8','','','Enum. pl. Jap. 2:305.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6681ae6c-c2fc-53f0-8358-7aae9856bff6','','','Kew Bull. 41:32.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb62031c-156a-5529-bffe-f1911f9f2477','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 9:905.  1896 "<I>monostachya</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3a019d7-4169-5c84-afb6-f355164bb55b','','','Pl. wright. 1:58.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f71c7eac-37c7-5df3-b28f-9cf7b8faf9dc','','','Senckenberg. Biol. 50:303.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50ecaecc-5c0a-524f-8c0f-4eec1b7ef6fe','','','Rosac. monogr. 2:85.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('626d99ed-f996-50e3-8f47-2d449d8a6f39','','','Gard. Bull. Singapore 26:285.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fa2e5fd-aafd-5f86-bfb2-ebb479b5819e','','','J. Straits Branch Roy. Asiat. Soc. 75:153.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4575a776-4e48-50c5-812e-83d2d6afca02','','','Allg. Gartenzeitung 9:163.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4551955f-ee7f-55d5-85b6-c65c1920e06f','','','Tanacet. 32.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('653aec1d-8e64-55a6-bcce-137720553e42','','','Linnaea 21:408.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b83d7a57-7eb1-5d0a-99cf-8e05f97165d5','','','A. Gray, Boston J. Nat. Hist. 6:214.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62eb9c18-8419-567d-a459-d21d09c8a8a8','','','Muelleria 2:139.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e0b5748-45f3-56db-8a2d-1c806aa7589d','','','Fl. Cambodge, Laos & Vietnam 18:208.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a895163-7cbf-55ad-8edf-672efb8cdd47','','','Gen. <I>Lavandula</I> 241.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('962839b8-31c5-58fd-8ace-a9250b6fdfd4','','','Brit. fl. gard. ser. 2, 1(= 4): t. 41.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e6f5b11-8be8-5501-937a-4fa23cd48a2e','','','Fl. atlant. 2:305, t. 245.  1799 (non L. f. 1782)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8384a351-db53-59a2-9246-75edcd10fd5d','','','Bull. Torrey Bot. Club 43:618.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a061fce-7273-5fb4-9123-5d6339f62a7b','','','J. L. M. Poiret, Encycl. suppl. 3:755.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a46276c4-a574-5a15-82ad-fcaa68bdd58a','','','Cuad. Bot. Canaria 7:7.  1969 (non Kit. ex Janka 1871, nom. inval. pro syn.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbfaf184-6c46-502d-b7e2-41a5e7e06814','','','Paphiopedilum 119.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63f18e51-9fd1-5e09-a4ba-f61bdb020db4','','','Trans. Amer. Philos. Soc. ser. 2, 5:203.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55b68140-6ff3-5f02-b828-444cdc08e16a','','','Kulturnaya Fl. SSSR 1:303.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('174ca9b3-b0c3-5adf-a849-4e06dd1be11e','','','World checkl. seed pl. 2:14.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3025587-4b20-589b-b9c6-ff9a952f8f5f','','','Linnaea 7:301.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('153520d0-6997-53e1-8dcf-887468f14382','','','Edwards''s Bot. Reg. 31: t. 20.  1845 "<I>tubulosa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a70b4479-912c-504d-8ee4-5fab26ee529f','','','Anales Soc. Esp. Hist. Nat. 26:198.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64ca1a03-dbc2-5580-a108-7a3db479aef4','','','Fl. orient. 1:102.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6791420-2547-57bb-862c-5d4e39dfa91d','','','A. L. P. P. de Candolle, 15(2):82.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bb72753-46d0-5435-980b-f9d6290f8d82','','','Pl. rar. 323.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19188687-4d3d-501f-a529-5543a728d8a1','','','Diagn. pl. orient. ser. 1, 2:73.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8425f7aa-6da5-5544-8c8a-d3cc9bbddcb3','','','Proc. Biol. Soc. Washington 15:28.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c50b2b4-5ea3-5b32-8cb2-0a97346707d9','','','Linnaea 25:512.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('799dcf59-001b-5f80-ad12-39618331171a','','','Byull. Moskovsk. Obshch. Isp. Prir., Otd. Biol. 74:76.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db461a83-d58e-567f-8816-4a06e565b56b','','','Flora 30:697.  1847 (H. Zollinger & A. Moritzi, Natuur- Geneesk. Arch. Ned.-Indië 3:58, 76.  1846, nom. nudum) (non (Thunb.) Poir. 1819)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adc44ca8-e031-5ef3-bc8d-96af3a8432b0','','','Telopea 7:137.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccb01ca3-3e53-5c80-b803-7a4a6eea528c','','','Great Basin Naturalist 46:86.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f203432b-5652-5c54-a8f8-e5caf1289f8c','','','Novon 19:491.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5de37d34-3255-5ff5-827e-cda4e65372e1','','','Fl. taur.-caucas. 3:269.  1819, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('884db266-fee1-5b2b-aaf6-da935e4a0db2','','','Proc. Biol. Soc. Washington 29:10.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2e72fda-5561-51ba-add7-a2ad7e3b39cf','','','Enum. pl. 1:105.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7c13fa8-be51-5422-b326-98f6dbce7514','','','Kakteen Südamerika 1:253.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42da41ee-97af-50e2-a116-025b9edadf4e','','','Asiat. Res. 11:159.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cc08a42-497e-5b14-b084-10e9a888fba6','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:215[folio]; 1:271[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e0f02b7-2533-5633-bd87-9da6bde668c9','','','J. Arnold Arbor. 35:86.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc21913e-b76b-550e-9b56-8959848c4dc8','','','D. Oliver, Fl. trop. Afr. 3:459.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('424bc03e-987e-5dc8-bcb7-a73e7b08e337','','','Bot. Mag. 14:28.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('552c3912-8c1f-540d-ad53-eb47423e5efb','','','Aliso 11:33.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7eb89cb4-4887-5094-b80b-86bb4c9e5496','','','Univ. Washington Publ. Biol. 17:175.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5aea18c0-2d6f-5123-990c-cd3b8ab121c4','','','Reinwardtia 5:490.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62fcf54f-e030-571c-8028-78837b3fc5da','','','Fl. reipubl. popularis sin. 36:370.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a7e1349-c3de-511d-b772-efc3607a5bbf','','','J. Bot. 52:90.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad79f6ab-4ea9-5c11-92f7-e3b555084167','','','Fl. boëm. 2:71.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81d6830d-c826-517e-9061-50c5328ac5fe','','','Pittonia 3:205.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed1b5154-5d6b-5037-a1f0-7ea967a21318','','','Willdenowia 20:108.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('273e3eaa-9d5f-5476-bbcc-5b5c343b592c','','','Gen. hist. 1:516.  1831 (W. Roxburgh, Fl. ind. ed. 1832, 3:147.  1832)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7c56312-eb76-5cf6-a035-9fe3f0b47fd3','','','Nomencl. bot. ed. 2, 2:163.  1841, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10c1015a-9418-533d-a416-c20a5606aeba','','','Linnaea 12:315.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1a1b1dd-a3c2-5aa5-88fe-a82ecaae4fe6','','','Notizbl. Bot. Gart. Berlin-Dahlem 13:609.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87dd0618-cc68-5e64-9d75-1ef2f7464a0b','','','Bull. Misc. Inform. Kew 1921:294.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('332327e0-e1ea-5be0-a7bf-6063418ee37e','','','Amer. J. Bot. 54:496.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac82bc9c-df08-5d6f-8b3f-192702393a02','','','Leafl. W. Bot. 4:39.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('baa8128e-e8a4-5b3d-82bb-225e10114924','','','Pl. Ecol. Evol. 145:219.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95461a7c-394e-5fd7-8573-e27400e3fa85','','','Fl. Afr. austral. ill. 402.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6631caad-8831-5e93-91fc-b8f0dbf6cf9e','','','J. F. Drege, Zwei pflanzengeogr. Dokum. 227.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a621599-e2cd-59ea-800d-038dd7e88734','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 23:44.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('968ab011-c69e-5e09-9ac0-5999323dd903','','','Verh. K. K. Zool.-Bot. Vereins Wien 3:129.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d49e691-4368-5e41-8d46-696d5107ca0a','','','Cent. pl. Ross. merid. 3: t. 77.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de423633-7aec-523c-9894-410e80cec119','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 29:86; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 11:675.  1883 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04bd92ac-99df-51e6-8a0f-2c338b78873a','','','Zoh. & D. Heller, The genus Trifolium 173.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5c65740-5757-50cb-83ad-7b1072eb3dc7','','','Icon. pl. rar. 3:8, t. 511 ("<I>Geranium</I>").  1795 ("1786-1793")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19e90e35-0064-5359-937e-d42477387682','','','Fl. adv. Montpellier 85.  1912 Jan (Mém. Soc. Sci. Nat. Math. Cherbourg 38(sér. 4, vol. 8):85.  1912)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce24ef03-bffd-513e-acab-b0f6a69d3454','','','Gard. Bull. Singapore 18:44.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec3405ff-67cd-5c52-819c-7bd6b1586ece','','','Trudy Prikl. Bot. Selekts. 11:41, fig. 1204.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8e66e8b-6bce-5ab6-810e-2dc3583cd383','','','Pittonia 2:21.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35fe7830-125a-5630-acd1-5c39752d658f','','','J. J. Roemer & J. A. Schultes, Syst. veg. 3:476.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d3d3562-e1cc-5831-ba1c-e8d6945211c7','','','J. Arnold Arbor. 57:510.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35d1e6ad-43b7-5f18-8b1c-14aa5fd6a8d3','','','Gard. Chron. ser. 3, 12:179; Bull. Misc. Inform. Kew 1892:3.  1892 "<I>franzosini</I>", nom. cons. prop.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('455699cd-a917-507b-93b8-e09edb3765d6','','','Proc. Amer. Acad. Arts 7:394.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c89e8a6d-2d30-5546-9e9f-666c184fe669','','','Sp. pl. 1:407.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec6581ac-8706-566b-b4a0-77a88cd74cd4','','','Fl. napol. 1:xxii.  1811-1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c7173d2-4ddd-544e-a0f6-51e8a164a862','','','Sp. pl. 1:67.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa4b0c94-dd30-5a67-b055-73fea6ec58e9','','','Biblioth. Bot. 17(Heft 72):33.  1910 (Sp. rub. 33.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cb299f6-f5d5-52d5-8a1c-d2473f31b530','','','J. S. African Bot. 7:30.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61d0d5d9-e064-5ef7-8da5-5633beff3224','','','Philipp. J. Sci. 14:245.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('485f60d6-eebe-5842-9a69-2442b8ca75bd','','','Mem. Torrey Bot. Club 1:50.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('832bf0cf-f8ee-5d29-b253-2a9bebbb06c6','','','Die Hauptsachlichsten Formen der Saatgerste 7, 11.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5a347f4-5655-5a5e-9e7f-3129284cb40b','','','Descr. icon. pl. Hung. 1:26, t. 27.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ebdf03d-80f4-5bc2-aa36-9d726a54e5b7','','','Great Basin Naturalist 28:152.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17b0f942-d6c0-5409-85db-b4c69172a723','','','Gard. dict. ed. 8: <I>Solanum</I> no. 27.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab8c7ff6-be79-52ca-b59c-b7913cf58731','','','Neue Schriften Ges. Naturf. Freunde Berlin 4:236.  1803 May (non Michx. 1803 Mar)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b84ef285-86d5-5c89-b0a4-fa863f6f6df2','','','Linnaea 10:596.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ebfe667-08e0-5c62-befb-5a2d6aa29232','','','Contr. U.S. Natl. Herb. 5:120.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35fd825b-499c-5d23-8bbc-374140fa1553','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 4:47.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2dfa1f2d-4f1a-5a2a-908f-3e11d229a6ff','','','Observ. bot. 1:10.  1779','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afa65b59-5a93-5c9d-b24d-acce868e9d64','','','Gard. Chron. ser. 3, 24:330.  1898 "<I>sanderiana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('831b78f1-9f0b-53f2-b544-150edfde3b7c','','','Fl. Ned. Ind. 3:187.  1856 "<I>marantaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d33f651-fcef-58a0-aa3a-bef616c4e4d0','','','Mém. Acad. Sci. Toulouse ser. 7, 6:643.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9fa4fdf-93c8-5d02-84a4-ed09a32e0621','','','Phytotaxa 279:53.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e1e2859-6356-597d-9097-23d4752d9f4e','','','W. Roxburgh, Fl. ind. 2:157.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a0f679c-7064-5d81-86df-a9e34110625a','','','Hooker''s Icon. Pl. 30: t. 2949.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0563fcc6-96a8-5720-9bec-ae51b02452f1','','','J. A. Murray, Syst. veg. ed. 14:294.  1784 May-Jun (Fl. jap. 124.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d553aa6-3b67-51ab-84ea-3106bd3b616d','','','Blumea 18:148.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffb8ab7c-f8ca-5f4b-a716-f16035c823c8','','','Contr. U.S. Natl. Herb. 18:65.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34e6f108-d3d7-57bc-b893-2e41cddd3e28','','','Pl. vapinc. 21.  1785; D. Villars, Hist. pl. Dauphiné 1:325.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67994d44-cde3-5f4a-9a66-4d8ea28dbe8e','','','Feddes Repert. 117:49.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6247361-7b15-5669-ac7c-d65519eb6e67','','','Eclog. amer. 2:25.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a56e3af-4b0d-56e8-8a41-0000bd737767','','','Icon. pict. pl. rar. t. 2.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1629338d-76a8-5b64-87be-fe9439e28166','','','Madroño 18:159.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('627f0632-4c8a-5bd5-95ff-28d2da19ea62','','','Fl. reipubl. popularis sin. 32:543.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b6855be-1f04-50bf-807f-3de920eba0ef','','','Bot. Gaz. 38:71.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f8b1623-2a71-5db7-ae0f-aec46283d6b7','','','J. Linn. Soc., Bot. 29:302.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06471c2b-a59c-5787-a9e8-c84ec377de72','','','S. Austral. Naturalist 50:28.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9649ec6-6244-55b6-91d4-1c258036f5ea','','','Contr. U.S. Natl. Herb. 3:251.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5646fd1f-4a74-5f25-8acf-64c3ac80a243','','','H. G. A. Engler, Pflanzenr. IV. 147. II(Heft 44):53.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79087630-80f0-50f5-90f7-889dc67de2c6','','','Fl. sicul. prodr. 1:426.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('668355dc-f589-599c-95cc-4888d43802e1','','','Icon. 5:28, t. 446.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48ead6e5-dcd7-5300-aef8-cb66ebb4f249','','','Bull. Misc. Inform. Kew 1926:114, t. 7, fig.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a49e6e3d-e436-5148-bb1d-828d40d803c1','','','Taiwania 42:143.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45ab7ed3-aba7-526d-8cb2-ceb6c7191637','','','Magyar Bot. Lapok 5:244.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a619053b-050c-55d4-b2ae-a8af21de12b5','','','Ann. Missouri Bot. Gard. 68:496.  1982 ("1981")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d6b4183-dab6-5354-a6e1-992cdbd82307','','','S. Watson et al., Botany [fortieth parallel] 249.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('372652a9-a986-53a4-9a74-94f51e931e44','','','Fl. germ. excurs. 290.  1831-1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed01b7a4-bb9c-536e-b06d-2588e4b896c2','','','Sp. pl. 4(2):1067.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da6191ba-15e1-57d9-b11b-51cb2ac62134','','','Fl. atlant. 1:106.  1798 (non Poir. 1789)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b820208-acf3-5a4b-925b-18742b6411bd','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 314.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a782dfdd-f7fc-5a89-9c0e-ee5e1ed16a0d','','','L. Diels, Bot. Jahrb. Syst. 29:285.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39d985b0-d91b-5562-ba84-b186c2c08481','','','Fl. orient. 5:122.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51533c1d-d05c-5ef1-bc8f-1f6e72ec2052','','','Bot. Mag. 52: t. 2594.  1825 Sep','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4051c9ad-560c-51f3-91dc-7a4ff7853417','','','Bot. Mag. (Tokyo) 27:125.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdc4d0d6-8c24-5863-a751-3dbaa7e4d8b0','','','W. T. Thiselton-Dyer, Fl. trop. Afr. 4(1):17.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c17407aa-d0d4-5ebd-9b92-14b928c31329','','','J. Washington Acad. Sci. 11:183.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8330db5-9e6c-5f2c-9a2c-0f555b2e7446','','','Pl. hort. schoenbr. 2:31.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddae10c8-b695-521f-ae21-c901a257453b','','','Syn. pl. 1:68.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('393da9bc-ad54-5219-95dd-be24d02a68d3','','','Fl. forest. Cochinch. 3(fasc. 18): t. 285.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef655821-88ab-5ceb-9205-745cf8877efd','','','Garden (London) 104:302.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7301e859-83e4-5c37-8b95-5bf313e98e81','','','H. G. A. Engler, Pflanzenr. IV. 250(Heft 27):67.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79d2844b-7792-511c-939d-90dff077052a','','','Bot. Gaz. 61:36.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d3a4e79-6851-533c-862b-8c1dc814bafd','','','Zoë 4:398.  1894 "<I>jaredi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6dfe8f47-fe49-55cf-9d54-3388de94e8cc','','','Bull. Herb. Boissier 5:528.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ced92e24-3e3f-50c9-b141-98380cb096d9','','','Palme della tribu Borasseae. 36, t. 33. (Ann. Calcutta Bot. Gard.) 1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fae9d9ee-767e-536f-ad33-a8e0a15a62ae','','','Sci. Res. Ozegahara Moor 446.  1954 (Enum. Spermat. Jap.3:71)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a2661af-d696-583a-a65d-c8a98d891475','','','J. Jap. Bot. 26:234.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ea4584a-d6fc-50ca-8308-f2c9d34b915d','','','Rhododendr. Sikkim-Himalaya t. 3.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5f604eb-74ca-5702-b34f-36dea37859aa','','','Sp. pl. 2:874.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad53c1b5-1ed5-5a1d-82a7-02c1170bf045','','','C. L. Hitchcock et al., Univ. Washington Publ. Biol. 17(2):103.  1964 (Vasc. pl. Pacif. N.W.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6338c9f4-9324-5e94-ad2c-424561eb4aa9','','','Mem. Amer. Acad. Arts ser. 2, 5:322.  1854 (Pl. nov. thurb.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('303e6d6d-dc4e-5b59-9cf0-eb7d1d0de2e3','','','Acta Phytotax. Geobot. 1:36, in adnot.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ac340d5-3b6e-5f19-9af9-bb0bbe300c02','','','Sp. pl. 2:642.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2145daa2-7bd0-5b70-a072-eee6b69831ed','','','Sida Bot. Misc. 23:194.  2002 as "<I>carteri</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b51f6b18-923c-5f40-bf1d-d146f0e11430','','','Spic. fl. lips. 155.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15f63515-08be-5cb0-92d2-a74a34af1c1e','','','Mitt. Inst. Allg. Bot. Hamburg 6:353.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cca111b2-b98e-55f6-913c-ca61f937c683','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:265[folio]; 5:341[quarto].  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f201b80d-a7fb-557e-be62-3d09b5f6843a','','','Pittonia 4:319.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24f93a58-f26b-567f-a3d4-1aefd045433c','','','Fl. bor.-amer. 1:238, t. 81.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('355821d8-3c41-5ac3-a420-df3e8bed1da4','','','Trudy Prikl. Bot. 18(1):447, 483.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41f9b4ff-b296-580f-a59e-4248d4ce6bce','','','Bot. Beob. 1783:20.  1784 (Schmidel, Icon. pl. ed. Keller 49, t. 12-13.  1763, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('956d561f-fcba-5459-8593-bc8a452fcf82','','','Čas. Nár. Muz. Praze, Rada Přír. 152:22.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e9b38d4-5d82-57f6-b8af-61eb85567582','','','R. Maire, Fl. Afrique N. 6:61.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef1e34e0-8c5b-5ed8-a7f5-492652a81e21','','','Verh. K. K. Zool.-Bot. Ges. Wien 18:656.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88fb8478-7aff-5fe3-b0cb-05a2841a8758','','','Adansonia sér. 2, 4:333.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('290f2fba-2cf8-5c3b-b170-5b9b847352ce','','','Edinburgh J. Bot. 54:253.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('374d1235-13d8-5c2a-9af6-99adf03ec47a','','','Palms of Madagascar 366.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('285fd87a-72b1-58c9-8da8-69260ccd54af','','','Fl. austral. 3:421.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd958767-7899-542b-a308-3ede019f4c36','','','Contr. U.S. Natl. Herb. 7:217.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a088344d-7421-5f5e-a8c5-1ed84458634d','','','Nov. pl. sp. 147.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3e1028d-20fc-58b6-a781-96232ea1267c','','','London J. Bot. 1:332.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('174b0414-41ed-5207-bcd3-1ff8a6fed772','','','Reise durch die La Plata Staaten 2:48.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e88ed954-61cc-57bc-8e42-b238d9bb1649','','','Blumea 41:357.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbd9f6d3-0186-5c52-9118-bc4189c9f121','','','Bull. Misc. Inform. Kew 1908:180.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d8bbe17-d14f-5f4e-bfc8-43d39167caea','','','Bol. Soc. Brot. sér. 2, 36:48, t. 1.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e192122f-ddef-5774-9f29-14b82e4db612','','','Bull. Bot. Res., Harbin 11(3):33, t. 2.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f15d9bfb-53e1-5647-b5f6-ed66bb85c4d6','','','Fl. ludov. 13.  1817 "<I>prealtum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c082db18-4f4d-5e0c-93d1-da2e307ced63','','','J. Fed. Malay States Mus. 6:175.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99eaddd7-d998-5ce3-bcd1-6ecff8f40d7e','','','J. Fleming, Asiat. Res. 11:174.  1810 (Fl. ind. 1:421.  1820 "<I>ispaghula</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c91ca21-53a0-5ca7-b9dc-8fcecdb021a8','','','Diagn. pl. orient. ser. 1, 6:101.  1846 ("1845")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28c656ce-b351-5c00-b85e-f23cf8e73a99','','','Bol. Soc. Ibér. Ci. Nat. 20:185.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fea06ac4-138b-577b-8228-835d9f3745ef','','','Wodyetia 4:10.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d304bb2d-904a-5352-ace3-3bf4df538d4b','','','Syst. veg. 7(1):545.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36cf4ddf-386e-5494-ad9d-502db119fbf5','','','Bambou (Mons) 1:272.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b24b0bf-5df7-55eb-aa9d-856cb5a84c48','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:309[folio]; 6:393[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94a38d53-a92a-5050-8ee5-d5daee0847bb','','','Prodr. 2:440.  1825 (Mém. Légum. 440, t. 65.  1826-1827)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2107337e-8029-5234-a703-235a2530e926','','','J. J. Roemer & J. A. Schultes, Syst. veg. 2:604.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4e9d75b-9211-56a8-86d1-4e0c54f7602c','','','Fl. Brit. India 1:481.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4a6426f-bb96-5e3e-9b81-f5fa72ffbb64','','','Syn. pl. 2(2):421.  1807 "<I>policaulon</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db50f8a0-f021-556f-81af-c2bbec133144','','','Deut. Dendrol. 315.  1893, non (Spach) Walp. 1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c7a486c-b24d-5d00-a28a-7c8315b141f6','','','Nuytsia 2:32.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c45229cc-3a44-574c-a8fe-09b8d904d981','','','C. S. Sargent, Pl. wilson. 2:302.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7452dc0-ee32-5bb3-95fe-71871893f06a','','','Novon 2:286, fig. 1.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e81a734-37ad-5c38-97d9-586c5a9f1882','','','Meded. Rijks-Herb. 61:13.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e3f50e7-1484-5334-b373-1ddcf4562b75','','','Pl. nov. horti then. 1:184, t. 40.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1dc82a84-9e82-5b58-9d6f-d78595dd6782','','','Fl. atlant. 2:4, t. 118.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('552a97cf-8dd8-5e33-b360-b3d63c2c0183','','','Bijdr. 313.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0167ed9-8177-5b7a-a1d5-9898db91c29f','','','Bull. Jard. Bot. Buitenzorg sér. 3, 10:68.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a3a11d2-318e-5b73-9aa7-181a9de70be8','','','London J. Bot. 7:130.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46257850-7c1b-5fc5-8e8c-6167807e5528','','','Hort. kew. 3:104.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d467f679-cd3c-50d2-8726-6b9f5579ad2d','','','Ann. Mus. Bot. Lugduno-Batavi 3:32.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a864c4f-d082-5e68-bcbd-e1e848145d46','','','Arch. Bot. Mém. 7:101.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d7b7828-0a3a-5bf3-b5ce-0aaea0254b29','','','Bot. Reg. 10: t. 866.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f547e55f-9696-5d69-9569-e30f70173302','','','Syst. veg. 7(1):323.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('291cd3e8-8532-5672-a365-a9eb3c36699d','','','Amer. Midl. Naturalist 29:12.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11981284-8530-5518-a413-9ea1e719658b','','','Gartenflora 19:268.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9598f0c1-b98b-5b92-9c12-a22880d143d1','','','J. F. Royle, Ill. bot. Himal. Mts. 1(8):253; 2(7): t. 69, fig. 3.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ef5aa94-7823-5b19-a297-d869a396e985','','','Fl. jap. 67.  1784','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07347017-3ab1-508e-8fe0-de6ccb59f086','','','C. F. P. von Martius, Fl. bras. 15(1):43.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5be4922-18db-5b24-bec9-75103eaac674','','','Bull. Mens. Soc. Linn. Paris 1:285.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2b6ff58-081d-5a26-8423-d37f4bca739a','','','Dendrologie 2(1):118.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7be43419-31dd-5494-b93e-325582b68a88','','','Philos. Mag. J. 64:425.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7214453-d216-5d0c-b577-acc33ce4b135','','','Sp. pl. ed. 2, 2:886.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3da2d2f3-0544-57ca-929f-77cff9c005dd','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 4(2):842.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6bd70310-3fa7-5d5f-bcf9-e4c807b3a809','','','Univ. Calif. Publ. Bot. 40:80.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e06ac9d-8e9e-5206-9703-7bd0dbc5482c','','','Artemis. 26.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40e9dfc6-8a2e-5b7a-add6-9c3bc5db4a90','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:112[folio]; 3:143[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c05602d7-160b-57b6-b308-bf3c0796e760','','','Fl. reipubl. popularis sin. 38:54.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c919525b-9a81-503b-b0bb-c14901566d92','','','Mém. Soc. Linn. Paris 6:323.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab8ef32a-4bc4-5d15-845e-89bce744df6f','','','Rev. Bot. Appl. Agric. Trop. 15:966.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebb4e38b-33ce-5785-9d19-a3025cf8d9bf','','','Symb. sin. 7:376, t. 10, fig. 2, 3.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cf7c02c-8c4f-5208-8ada-9beeefc007c5','','','W. Amer. Sci. 6:29.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2335089-584a-51e5-a599-69730c7789a2','','','Fl. Afrique N. 5:103.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6829bb6b-c680-5264-b73e-72cce71b60c6','','','C. S. Sargent, Pl. wilson. 2:522.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33dbcfba-bf39-59ab-9ce0-75a054f054a0','','','Fl. Brit. W. I. 479.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('760758a4-349a-537c-ba4d-3e292db0aed2','','','J. M. J. de Wet et al., Amer. J. Bot. 70:1141, fig. 3.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24e31fc5-32e9-5727-a7ed-598caa050574','','','Cavanillesia 1:14.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44d3112d-5d83-5421-be16-a6bf3e0537d1','','','Enum. pl. afric. austral. 216.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcd7dd54-ec45-5826-8ccb-79a3d8083bd6','','','Descr. pl. Cap. 212.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50104d6c-17e4-54bd-8061-e8c10e20429d','','','A. Gray, Manual ed. 5:489.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c65aa9f5-244f-58ca-bbea-5f448b4d0e6e','','','Bot. Beechey Voy. 350.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99ac915e-fb32-5862-bda7-4537b40c1331','','','V. L. Komarov, Fl. URSS 2:430.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0caaaedf-7958-50ce-881d-6e2ebc712379','','','Syst. nat. ed. 12, 2:734.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e5afc12-8699-527d-99ba-aaa1c6059d2f','','','Encycl. 3:210.  1789 "<I>hirsuta</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('775170f3-82b0-5e6a-812b-e95014ef4d33','','','Amer. J. Sci. Arts 25:74.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('125adbda-38e7-595a-9b1b-d691a61fef0f','','','Candollea 20:190.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d33b2da8-5a30-59b8-8a29-12ad51afd89c','','','Ann. Missouri Bot. Gard. 108:243.  2023','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11d93f63-7c77-5d55-8a8c-b974d2d3eb57','','','Fl. sicul. syn. 2:813.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b32bae74-9c6a-55ae-818d-3172a3dca113','','','Sketch bot. S. Carolina 1:146.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('056a8653-1fc4-5fc2-a0aa-08a5ee51a680','','','Syst. veg. 3:615.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0485f223-2d0f-50cc-a4ee-e6dc6c951a90','','','Bot. Not. 114:40.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3133b4db-9bc5-545b-a29f-2cc89898ab0b','','','Billot, Annot. fl. France Allemagne 163.  1859 "<I>durandii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe434f6a-926e-5191-8e0c-18a9ef49ddb1','','','Plantsman 4:191.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3df7ab39-cc0e-5205-bc90-fac356d6f0b4','','','M. Stones & W. Curtis, Endem. fl. Tasman. 6:432, 477.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('184162e0-a7a7-576a-9e41-e38973cfbae0','','','Contr. U.S. Natl. Herb. 24:426.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9757533-cbca-5fcc-90f3-2f1057218d69','','','Ann. Rep. Commiss. Agric. 642.  1887 "<I>pomelanus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8a9fd41-173d-5bd3-b077-a9690960fc0d','','','Acta Phytotax. Geobot. 3:81.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26b00451-f4e3-54f7-999c-1c886ea71937','','','J. Jap. Bot. 15:203.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bb3d57e-74f0-5a2c-b117-7bd4e0c225f4','','','Telopea 1:395.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('190f3bf0-bc0f-5c8b-80f6-c5c7f9283f94','','','Linnaea 29:43.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62494a03-00f3-5bf4-907a-3940b5720377','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 1:224, t. 13.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dea82145-bd3a-55c2-89d6-be93cb3dd61f','','','A. Strid & K. Tan, Fl. Hellenica 1:371.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7f508e5-c0bc-53e4-9142-4101009efb6d','','','Muelleria 15:11.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('765539cb-ede5-52ed-a452-824e0807e836','','','Rhodora 20:83.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3059b5a0-0714-591c-8682-212b8161afc8','','','Icon. pl. formos. 8:114.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ceaa2f6-6994-5bb5-a38a-f79c9079c612','','','Labiat. gen. spec. 736.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94a94a04-c037-5f1d-b055-91c32ce77576','','','P. Russell, Nat. hist. Aleppo ed. 2, 2:248.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('187a6322-04ed-506f-a74c-8e4f6ce27a82','','','Fl. atlant. 2:287.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4355d2b-21a1-5070-9fd5-47e6078b094a','','','Bull. Acad. Roy. Sci. Bruxelles 10:209.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c48bcf5-e28e-5522-a259-22bb6166bcca','','','Revis. gen. pl. 1:198.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f13939d-8fe1-50f0-af8f-ec56c58905a1','','','Amaryllidaceae 175.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15abcff4-6132-507a-a272-ec008f5dc023','','','Bull. Torrey Bot. Club 69:452.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b79a47a-aa5a-57cc-902d-35deb04cd48d','','','Edwards''s Bot. Reg. 20: t. 1712.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ff1e670-089d-5f00-974f-c085039a185e','','','Bot. Jahrb. Syst. 50:357.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e10d9e6-4d8e-58d2-84b4-ea3198513268','','','Bull. Fan Mem. Inst. Biol. 5:41.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a3b3a84-7fbf-5f5a-b478-361af7af245f','','','Garcia de Orta, Sér. Bot. 1:35.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0510ea70-b828-5c93-8770-f91c2350cf68','','','Gen. hist. 4:40.  1837 (N. Wallich, Numer. List no. 4137,  1831. nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('034e457b-fb08-507d-a4a0-d8de20db7355','','','C. F. P. von Martius, Fl. bras. 14(3):309.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('194825e7-a314-5c3c-b271-18897d7344c0','','','Kakteen And. Sukk. 39:18.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33aa0a13-d01c-552e-9386-4091cdc1aba5','','','Denkschr. Kaiserl. Akad. Wiss. Wien, Math.-Naturwiss. Kl. 56:59, t. 2, 14, fig. 1-7.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00b7adb9-1bb0-5413-91dd-790dd4bf51b7','','','Fl. ludov. 80.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e72b7ef-9c33-5d9f-8c32-1f2b88093112','','','Comp. fl. ital. 299.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76a23a45-0067-5146-a8ce-2fdaaf607727','','','Kirkia 3:123.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94055615-abe4-543c-b49e-4523423fc662','','','Ann. Missouri Bot. Gard. 108:180.  2023','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7436be5f-d9e1-55dc-96c9-35ba56a980d3','','','J. Bot. (Hooker) 2:215.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25769f39-730c-5b69-b704-deb719298ff6','','','Gartenflora 27:361, t. 959.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a91a04b-8a52-5188-b7e1-62b0bab1a9ce','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:264[folio]; 3:337[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95498c80-ddc8-587a-a318-d5edb082013f','','','Opera Bot. 92:265.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab40c004-c364-5500-8319-b1c37a8c61d6','','','Repert. Spec. Nov. Regni Veg. Beih. 1:880.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2751b1ee-ee3a-5df1-94a7-f7e71ad58c5b','','','Bull. Cl. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 10:341.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e977ed4-04f5-5174-9e41-e198ed8fa5c1','','','H. G. A. Engler, Pflanzenr. IV. 32(Heft 100):159.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b790fdb-7eec-5d7f-b5e1-e7ce948a1b30','','','Cact. Succ. J. (Los Angeles) 68:311.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f278d099-e2b3-54e0-9a6e-d34cb1239f96','','','Ann. Mus. Hist. Nat. 9:288.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84c8de84-0dba-5f73-91f9-30e2de49c7ed','','','Acta Bot. Yunnan. 18:209.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8a9dcad-10e3-543e-887d-6f0720a08b24','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 3:56.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b1aee38-83b4-540c-b8e2-0e9c9b7dbdce','','','Nat. Sci. Mus. 7(2):21.  1936 "<I>matsudai</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07ae5982-a285-5943-9958-9299eefdd772','','','Proc. Amer. Acad. Arts 32:284.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('119e52f1-f5ff-51dc-bebb-c6c5c1708b8c','','','Spisok Rast. Gerb. Fl. S.S.S.R. 18:30.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1095d04-e853-52fd-86bb-ca30bfbee1a8','','','P. E. Boissier, Fl. orient. 3:888.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f206211-ffb6-53fd-8493-c9d88ee77192','','','Trans. Linn. Soc. London 30:584.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51f9b72d-7f19-588a-875e-090dfc6bea4a','','','A. B. Lambert & M. Vahl, Descr. <I>Cinchona</I> 52, t. 10.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f400d0d-48d6-5c1c-96b3-3e0800183b82','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:335[folio]; 6:427[quarto], t. 575.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c54ae31-3835-57c2-bb18-d4b939d2b4e7','','','V. L. Komarov, Fl. URSS 17:19, t. 8, fig. 7.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c0579df-cfbf-5a6c-9b72-8b7de34cf7ce','','','Fl. carol. 251.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7492e49-eb92-56cb-aa11-23153a913c9c','','','Bull. Brit. Mus. (Nat. Hist.), Bot. 20(1):83.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92a96814-bb81-5dc8-9729-ea98b167a864','','','Sec. cent. ferns t. 96.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87b60c38-d01d-5a87-a8a3-fd3086231451','','','H. M. Willkomm & J. M. C. Lange, Prodr. fl. hispan. 2:406.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d83540d-e6e4-501b-b529-635bd9cb1526','','','Sp. astragal. 15.  1800-1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('450bab10-925b-5f61-856c-046caa905ef3','','','J. Genet. 28:422.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1f79d2e-e482-52b5-b201-6add34ab12c5','','','Jardin de la Malmaison 2: t. 91.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59f86c97-de1a-51e0-8fb5-fd8086e97d14','','','Fl. Bras. merid. 3:112.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3f64be3-ff7c-569c-bda9-38865fc87ede','','','A. Krapovickas & W. C. Gregory, Bonplandia 8:90.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edb60bb6-26aa-5209-8d27-98d72dca8cde','','','Cent. pl. II:26.  1756 (Amoen. acad. 4:324.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8097b49-7f1a-5970-b2cb-9d2d4af275b1','','','Bot. Mag. 142: t. 8674B.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4948a044-867a-533b-8540-6b0dda43caaa','','','K. B. Presl, Reliq. haenk. 1:264.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f539c30d-405c-5d79-8036-dd8bad06a86f','','','J. F. Klotzsch & C. A. F. Garcke, Bot. Ergebn Reise Waldemar 84, t. 71.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('154c4932-5202-5c67-9bbe-d82d796a2c0a','','','Baileya 19:91.  1973 (non <I>G. barbadense</I> var. <I>brasiliense</I> (Macfad.) Mauer 1930)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d92b9625-9079-5a21-8778-161624d41a8d','','','Trudy Prikl. Bot. Selekts. 14(3):155.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f415a388-cc92-5ea5-869b-7bdd8a9c9a73','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 4:215[folio].  1818; 4:274[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f0282e2-ec0d-5526-aca4-041e10721e94','','','Contr. U.S. Natl. Herb. 18:202, t. 102.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe7446b1-4a1f-5d1c-b45f-c0a02c87d1a8','','','Proc. Amer. Acad. Arts 17:367.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0cd305e-1b6f-50de-8139-af57f9083ee5','','','Amer. Midl. Naturalist 23:614.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33c94bf3-31b5-525c-91d0-de921a633046','','','Cat. Sem. Hort. Amst.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88edba44-4b66-521d-98dc-fdfb14822eb0','','','Chlor. andina 2:82.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec6eb9b1-feed-54d6-98f5-0cc375aa02dc','','','Bull. Soc. Échange Pl. Vasc. Eur. Occid. Bassin Médit. 23:81.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bab8699-787e-5181-abac-b3b342074607','','','Pl. bras. icon. descr. 2:134, t. 190.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3904148-687b-515a-9a45-24cb5cbca116','','','Nuovo Giorn. Bot. Ital. n.s., 22:267.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2662c8b-a717-508f-be95-c7b207df6871','','','Anales Mus. Nac. Hist. Nat. Buenos Aires 34:480, fig. 28.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0ff1aff-009b-5309-ad03-716821f950d5','','','Feddes Repert. 89:114.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c1a231e-ca6d-51f9-92ce-1d6d00525ca1','','','Ann. Roy. Bot. Gard. (Calcutta) 7:20.  1896 (G. Bentham & J. D. Hooker Gen. pl. 3:1208.  1883, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('387500a4-9147-5117-b248-208262b2dd17','','','Mao, Hortus 2(8):690.  1936, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7324ac1-24b7-52aa-99cf-979950250d01','','','Fl. bor.-amer. 2:57.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a48994b-3055-565f-8bd7-ba2bd5cc8073','','','Bull. Fan Mem. Inst. Biol. 5:271.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d30a5829-f529-52c1-9687-53b861b9fae9','','','Sida 21:907.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf545776-78bc-5b27-998c-dc45d14a29fb','','','Philipp. J. Sci. 20:411.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26b0cb86-81ce-5c81-a073-c998a5f72621','','','Fl. Serres Jard. Eur. 5: t. 442, fig. 1-2.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50a07b6b-cf6d-5343-ae70-8daf6aa74400','','','Telopea 8:22.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d91465a9-7be2-5306-a248-37a01b966ec7','','','Paxton''s Fl. Gard. 2:102.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eda478c4-b96b-5948-81cf-2aa1d63a4506','','','Syn. conif. 213.  1847 (ex Mirbel, Mém. Mus. Hist. Nat. 13:75.  1825, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f3b2b69-8a9f-5286-9709-7d941b56e392','','','S. W. Naturalist 11:416.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b68cd8e-603b-502e-9926-d66382766ad7','','','Revisio critica Casuarinarum 70, t. 10.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdfbe86a-3beb-5762-ab14-c6fc2d10a673','','','Proc. Amer. Acad. Arts 6:79.  1862 ("1866")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9cffebf-09f9-590f-8c46-c1c020bf88d2','','','Ill. fl. Pacific States 3:639.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af0c69c5-3e73-52d6-b878-547063fcd2db','','','A. V. Fomin & G. J. N. Woronow, Opredelit. Rast. Kavkaza Kryma 1:233.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d26f39e9-5ed5-575b-9a40-c22e785accd2','','','Repert. Spec. Nov. Regni Veg. 3:350.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b603185-e933-52b6-91da-d465519edc98','','','Loefgrenia 26:26.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bc8273f-be87-5c0d-af98-d1920e9c3124','','','Bibl. cult. trees 257.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19e6ccb5-084a-59ae-998b-5e0038cb260b','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 3:477.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('744d9d9c-47ed-573b-ac9c-d7e3a06b4e06','','','Phytologia 1:131.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df4d5b4a-7bd4-59f0-8e2d-5da170bad20e','','','Syst. veg. 4(2):30.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d96c716-6436-5d20-a5d2-df51dc7d4e0c','','','New names Grevillea 14.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d158ebc1-511f-55e2-b881-36c8162a7de8','','','Fl. reipubl. popularis sin. 74:356.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03e43777-8c85-5d7e-8d90-87a3df4b375f','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:484.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a02aaf31-0f48-5c14-92c5-8d46770195d7','','','Monatsschr. Deutsch. Kakteen-Ges. 2:236.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2b1b0ba-e9cb-566d-9d4b-7b552b4f0a39','','','Trudy Prikl. Bot. 18(1):478.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72a09bc2-2189-504a-bc66-36135b0d5108','','','Gard. Chron. ser. 3, 37:227.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0810c4d8-551b-5d8e-b98c-708dfa352e44','','','Izv. Gosud. Politekhn. Inst. 1:4.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcb77231-89fc-5b08-ae56-7a3c2110e24c','','','Amer. J. Sci. Arts ser. 2, 14:339.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6db0b785-8df9-5a18-abae-0afaa5b4a3d2','','','Repert. Spec. Nov. Regni Veg. Beih. 1:499.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6d89606-0c63-58ed-bd9b-7604dd703d02','','','Contr. Gray Herb. 154:25, fig. 1.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2f8d588-a779-5066-8e0f-e59c39695634','','','Bot. Mag. 19: t. 717.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('654c9a51-4e41-548a-84bb-e926ace39d7e','','','Not. Pl. Asiat. 4:704.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e511305-b475-5469-85b4-d0d4574f4a28','','','Kew Bull. 42:377.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb417f45-8300-5abf-9c0d-7ff0d72b44d6','','','Enum. pl. 1:95.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be501692-8a06-57d5-a98e-50b11c83301b','','','Bull. Soc. Imp. Naturalistes Moscou 38(2):422.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c57b9c4-46ea-59e8-a700-0171812056b5','','','P. E. Boissier, Diagn. pl. orient. ser. 1, 9:49.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a9c3baf-a592-5b2a-8a3c-68a03e7065dd','','','Post & Autran, Bull. Herb. Boissier 1:400.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('472ce4bf-8aa5-5818-a802-f462167d1b52','','','Fl. N. Amer. 2:422.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68272523-5eae-5fd5-974f-cfc2d6d24a9a','','','Mem. New York Bot. Gard. 21:84.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a66dd186-e774-5512-bbc0-1da886c6f08e','','','Kakteen And. Sukk. 2(1):2.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0c9c8f7-c0ae-51e4-9c63-20a848a6e188','','','Webbia 9:483.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb966f65-c000-54cc-b8bc-b57e537d9fc2','','','Brittonia 30:168.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6f23d14-c662-53e9-b95b-1372718e51ea','','','Cact. Succ. J. (Los Angeles) 67:219.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('592b1c31-3aca-50a9-9652-44f69d9e1b9b','','','Adansonia sér. 3, 25:18.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cbb4895-6502-532b-a77e-62bcb0223fcf','','','Ill. fl. Nippon 351.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0610868e-7952-5f82-8f95-4cdb88693838','','','Enum. pl. 491.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7724da75-30be-5224-9210-8895b7c6583a','','','Relaz. cult. coton. 109.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5767ee55-0102-5e1e-922a-b996e1c7a0e0','','','L. H. Bailey, Cycl. Amer. hort. 2:784.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25b080f8-1a5b-519c-8e8d-039772a36625','','','Madroño 36:50.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2050713-0a5d-5e9e-b7c7-73bf6261d608','','','Bull. Soc. Imp. Naturalistes Moscou 38(2):399, t. 7, fig. 15.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c62d785-2968-5d2d-9962-9d638b2b1dbd','','','A. L. P. P. de Candolle, Prodr. 9:377.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f570443-76b3-5eaf-8c17-800a53828914','','','Prodr. 513.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('addb8ab0-21e1-5ca2-8136-ac109e52c0c4','','','Syn. pl. 2(1):95.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e0a77cb-209a-5404-91f9-cd58dbc413b2','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:330[folio]; 6:421[quarto], t. 573.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7661b5f-b438-5a93-be2b-d3cc158d2238','','','Feddes Repert. 79:45.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b60e9078-016a-571a-a3cd-cc29cbad60ea','','','Arch. fl. France Allem. 2:219.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a80f49d8-586d-5390-8570-3d22b05d4d50','','','Mem. New York Bot. Gard. 35:433.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0dbe57a-904d-5206-8341-2d1484698257','','','Resumen Trab. Soc. Linn. Matritense 1880:33.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea120fb3-b2cb-5a5b-9836-20f7857671f9','','','J. voy. n.-w. passage, Bot. 291.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfac49c4-b427-5c10-aeed-a61bf4b55447','','','G. Bentham & J. D. Hooker, Gen. pl. 2:588.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6903f16b-58c3-5754-a1aa-e094fc7240de','','','Fl. peruv. 3:69, t. 303, fig. a.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d902903b-a246-5a88-8fca-cff415ec95c8','','','Trans. Linn. Soc. London 9:255.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1efca881-3eec-5ccf-93af-41ae2d7d5005','','','Grasses Maur. Rodr. 96.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0c3988c-4c59-5dd3-8a15-a3aec82b6536','','','Bot. Mag. (Tokyo) 42:563.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8aca62b-4615-5d11-815a-ad555e2e2fb8','','','Bull. Torrey Bot. Club 57:621, t. 39, fig. 18.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37a90c56-3963-531d-bd83-9a86ca2ff6ba','','','P. E. Boissier, Diagn. pl. orient. ser. 2, 4:64.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5c79531-5e7f-5315-a1d2-c0fcc5b5b2f8','','','Allg. Gartenzeitung 10:297.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa1ca61d-1c01-5895-9c05-e2d6ebc1176f','','','Dansk Bot. Ark. 29(1):53.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36f140f7-167c-5fdf-b9de-46066aa53c5e','','','Fl. ind. 2:274.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('284e738a-fd99-5d81-bbb9-3a54b67476f9','','','Fragm. 1:213.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c4c75ed-9b21-5c2f-83e5-81b7a50dc9c2','','','Blumea 4:411.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('521885db-aa7b-5c20-b08c-aaad25c88ff1','','','J. B. Stevenson, Sp. Rhodod. 234.  1930 (Kingdon-Ward, Notes Roy. Bot. Gard. Edingurgh 16:174.  1931)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c13644c1-13a8-583b-ae1a-7a870f20123f','','','Encycl. 2:747.  1786 "<I>satureioides</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d3eef72-ffc4-59a3-ab59-511e237d3e67','','','Lithops - fl. stones 217.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('929f02a5-5041-5f47-834b-68e7ceb061bc','','','Ann. Missouri Bot. Gard. 83:224.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1de38ab-871e-5c05-a221-8c1288c3f48a','','','Orchidaceae 5:172.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52153e27-5c72-5157-a55f-ff4639917101','','','London J. Bot. 3:200.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2da12fe9-97b9-52db-985b-583945ba349b','','','Amer. Fern J. 82:57.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f464dc4e-5df4-58d7-ab82-1df70da15566','','','Symb. bot. 2:11, t. 58.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d38264a-d648-5c00-9222-ffe21a7c1da2','','','Occas. Pap. Bernice Pauahi Bishop Mus. 6:70.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00a2c9e8-017f-5b83-a60f-61536f153d41','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 13:99.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85ad4ba5-73bb-5363-9892-5cd7a778238c','','','Bot. Jahrb. Syst. 57:640.  1922; emend. Reynolds, J. S. African Bot. 7:171.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a57f1bf8-d893-5a64-881f-64371e4353a9','','','Bot. J. Linn. Soc. 167:324.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c80c901d-cb6e-5cad-931a-ff27d94c1732','','','Revista Argent. Agron. 10:361.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f549ae8-8d06-5769-8af7-55a9ceaf654e','','','Acta Bot. Yunnan. 5:148.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b578e6b-25a4-5287-a0ba-071b862dd52b','','','Fl. reipubl. popularis sin. 45(1):59.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0da8dbde-6329-5004-8eda-44e7b7dd9d41','','','Madroño 66:67.  2019','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('646d98fb-b845-5d54-b513-7a97a3d50d81','','','Bol. Mus. Munic. Funchal 23:31.  1969 (non Andrews 1806)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63d3a75c-209d-5160-9f5c-d5f0aab2251e','','','Fl. Fitzalan 9.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a83715b5-f30d-5007-a9eb-9429c86e8d81','','','Bull. Jard. Bot. État Bruxelles 3:271.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c80f06a6-394b-5dd2-8d23-a5cd3b058f49','','','Trans. Amer. Philos. Soc. ser. 2, 7:309.  1840 "<I>foliosum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a912c88c-7358-54c0-a29e-6e3cef1c264e','','','J. Sci. Math. Phys. Nat. 4:319.  1873, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa3db468-2855-5b5a-84fd-59f9834b95f6','','','Man. fl. pl. Calif. 1141.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19e0bd36-4af6-5538-9dae-4955c31f6db8','','','Zametki Sist. Geogr. Rast. 37:25.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('255fa213-77f0-53b5-b61a-e0306268edbd','','','A. L. P. P. de Candolle, Prodr. 14:9.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50405a97-f257-5fce-baea-39228bd0210d','','','Encycl. 8:617.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b71c7fe0-71bb-5ac1-9525-d13a2b0ad550','','','Fl. Brit. W. I. 614.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfc1a955-bb4b-5fe7-af10-2789c78f3b52','','','Taxon 31:113.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff2f7ace-4bf3-54d9-88c8-d3b6c6d19a5e','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 11:491.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('819bc77a-4684-5d6f-8a8b-bc61850131b8','','','Prodr. 2:77.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a26ff9c1-e336-53a8-a6a5-118bd251bedb','','','Blumea 16(1):124.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a8c3936-9e1d-5c02-9cb9-82f4bf859946','','','Fl. austral. 2:233.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b9decec-c8de-5876-9f29-a3c3985b15b6','','','J. Roy. Hort. Soc. 57:291.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('013ecc91-cb2c-5648-b43d-fc8f8eb33c49','','','Fl. angl. 288.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93a58cc3-0915-5463-b56e-152fec40df4e','','','Mém. Acad. Sci. Turin, Sci. Phys. 10:6.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('288de519-7d76-50c6-bafc-8eedf4164923','','','Proc. Biol. Soc. Washington 19:192.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d114d879-2583-5059-ba5a-431a4deab9d7','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:178.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf62e980-59c3-51ef-92fd-bcfd3732e9d2','','','Notes Roy. Bot. Gard. Edinburgh 13:291.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('302e0ab4-b2a4-5e69-b50e-2e2a9cda5b91','','','Blumea 48:507.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bea929d3-aba9-58e6-9d69-163ee16f6b4a','','','Schroeter, Pfl.-Leb. Alpen ed. 2:505.  1924 (Beih. Bot. Centralbl., Abt. 2, 44(2):92.  1927)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a38f9ce-3b06-5b2c-8f38-1610f6ae1565','','','Ann. Missouri Bot. Gard. 28:225.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('801522ad-891b-5dcc-8475-acf6582ba66e','','','Akad. Nauk S.S.S.R. Bot. Inst. Komarova, Rast. Tsentral. Azii 4:217.  1968 (Plantae asiae centralis)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b086b05-3737-5f69-9916-083726f84147','','','Bull. Bur. Pl. Industr. U.S.D.A. 137:50.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c12ce25e-9440-528b-94f5-e850a25fd194','','','Bot. Jahrb. Syst. 21:303.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e673a7f-d23e-5225-8bec-a5f3bd00dc1e','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 4:213[folio], t.397.  1818; 4:271[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cfb6eae-7bce-5950-961d-82ada5aa6f5d','','','Font Quer, Iter. marocc. 1927: no. 281.  1928 [in sched.]','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a68002a6-a202-5d51-8efd-3867895a1e79','','','Kakteen Südamerika 2:486.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3efd2d62-c8f4-5fd3-aae2-5dd5e7e64311','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 31:101; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 12:542.  1886 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71ac0999-4e86-5fa5-bc4f-8e901bbf65ba','','','J. Linn. Soc., Bot. 31:99.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cafb19f6-830d-5237-81a0-bf0e5c0788a0','','','Abh. Böhm. Ges. Wiss. 1786:238.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4ded785-ec60-5e49-b967-75499044d4f5','','','Proc. Amer. Acad. Arts 14:290.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d12b263-84b8-5bcd-90e2-db487217bb87','','','Telopea 12:521.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eea6f3e2-b7c9-5425-96a2-1c59fe8715da','','','Candollea 48:422.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('223f226b-4fa7-5596-b2e9-47bd0f32f1fa','','','Handb. Skand. fl. ed. 3:17.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83256268-0d86-56b8-a208-7939188f877c','','','Sp. pl. 1:418.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09d4fee1-afc4-5124-951e-99b0246c20de','','','A. L. P. P. de Candolle, Prodr. 9:185.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb20c2df-d1aa-5af5-8330-b9248afea2f3','','','Bull. Herb. Boissier sér. 2, 6:375.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb907bdb-2ed8-5bfc-82bf-f242e53b096c','','','Kew Bull. add. ser., 1:104.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ebaf3b7-3495-5f1a-9ae4-e3c8ab21a925','','','Linnaea 6:420.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdb0078a-67ee-50b7-bcb6-0985bc746063','','','J. Hort. Soc. London 3:76.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a32ac7f-14c6-53df-9afa-7312ee91657c','','','Linnaea 8:47.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fca77b3-ee1d-5b93-9dad-5e093c7d9deb','','','Bull. Mus. Hist. Nat. (Paris) 1:320.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('111a671e-1525-5310-9645-270832ab42a5','','','Edwards''s Bot. Reg. 26: misc. 35.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6bc6a5c6-6521-5a59-b9fb-841605c86f7d','','','Mord. Laun., Herb. gen. Amat. 5: t. 304.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6e89cea-84c9-5dfb-8745-abbc8e4a9865','','','J. Bot. (Hooker) 4:400.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04a34c57-e8c7-59f4-80a6-58079b954250','','','Compt. Rend. Hebd. Séances Acad. Sci. 228:115.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a92e8eb-da28-55b9-8298-41cde2bc234a','','','Icon. 1:36, t. 48.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4911e9ae-d3e7-5e55-9cac-367846311eb8','','','Suppl. pl. 93.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e513a650-7f30-56e5-b5b7-181e914dff7c','','','Pugill. pl. nov. Syr. 16.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae705612-483b-58b6-8722-beed590f06d9','','','Trans. & Proc. New Zealand Inst. 19:243.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16715571-6c5b-596e-81a4-f0acee082afb','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(3):159.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b06536a-49c2-5b57-9148-d1d055ceb1fe','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 4:346.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ac86d1e-fa3b-5ab2-9bf9-89dcced952ee','','','Brittonia 31:273.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('821204a6-2429-5403-87a2-9bc0ba9e619b','','','G. Hegi, Ill. Fl. Mitt.-Eur. ed. 3, 4(SA):301.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8350b50b-d293-5a4d-a6b0-2eb6739f0a1d','','','Linnaea 33(3):298.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ddeefd0-65e3-5025-a6f3-2ee46e002bb3','','','C. F. P. von Martius, Fl. bras. 8(2):161, t. 84.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b45003d-e0ad-59aa-ae6e-b12b3ecacc81','','','Trans. Sukhumi Bot. Gard. 10:119.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e35279eb-f3d0-5cc5-bb23-6506e1f6d81e','','','Collect. Bot. (Barcelona) 6:309.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02b5d930-1ea1-51ad-a1e2-27520468e089','','','Sp. pl. 1:420.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a04e8284-9969-55b0-a6a4-114da2ecd2b0','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 4:25[folio].  1818; 4:32[quarto], t. 315.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d38edc84-edd2-5e03-b332-36d1ba4d7b2f','','','Gard. dict. ed. 8: <I>Melastoma</I> no. 6.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b71f6285-af25-57f9-9f44-c13f12aa5e11','','','Bull. Misc. Inform. Kew 1910:329.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d050071-ac3d-5328-88c1-6f420a6cec18','','','Prodr. 2:79.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dba9266b-815b-506b-9715-05466aa5b96e','','','N. Amer. Sagittaria 20, t. 15, figs. 5-8.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2eae0cc-70b6-54cb-8b76-a10b3d4e8af1','','','Fl. Brit. India 6:30.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('594083d9-51c9-5309-829b-ce138ab6f94b','','','Rhodora 60:154.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9aca701-9141-5f25-ba77-a8fabcaeeef3','','','Gard. Chron. ser. 3, 2:126.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('920b7d00-19f3-5ee4-86c7-9f29db42cf93','','','Ann. Bot. (König & Sims) 1:238.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5b88b75-024b-5003-bfaa-890a761e4681','','','Bot. Mag. 36: t. 1488.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9f5ed9c-2cd9-59e0-a209-b9d291770a8a','','','Tent. fl. abyss. 2:360.  1850-1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15ef9445-3484-5bf9-9450-647d0d9ac73b','','','Cat. pl. exot. 19:8.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43767b80-301a-5cac-9e1d-ee6ea43da45a','','','Syst. nat. ed. 10, 2:991.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48cc7dc2-201b-5219-a801-7a6dabd5de0d','','','O. Warburg, Kunene-Sambesi Exped. 245.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ed72ead-4eb4-5f47-b2b2-98f0de9cfa9a','','','Smithsonian Misc. Collect. 50:532.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0739b480-404d-5135-9b93-4e69268eed92','','','Notul. Syst. (Paris) 15:45.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c444607d-b989-5d56-8f20-18f18e30a5f7','','','Occas. Pap. Calif. Acad. Sci. 9:54.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20b63ab6-3f5e-59b4-8380-8ac4ea026444','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 27:535; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 11:313.  1882 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc19fdac-9e96-5a36-b54c-5e02529bf409','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 22:23.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3976ee6e-4486-546a-b509-7786960c48af','','','Exot. bot. 2:26.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f903dbbb-05b8-5091-b098-dd5ac37a7502','','','Rev. Hort. (Paris) 1861:449.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('448b3495-5489-590f-ba5e-895ffca71ba1','','','Fl. bor.-amer. 1:70, t. 25.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('131e6c5e-8ba5-5718-ab22-e5baffff9675','','','Bot. Jahrb. Syst. 40:86.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2194c95-a044-5971-8fcd-c81d182ef287','','','V. L. Komarov & E. N. Klobukova-Alisova, Key pl. Far East. USSR 1:385.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30013ebb-2c7c-5488-bac7-ad8397d9aac7','','','C. F. P. von Martius, Fl. bras. 10:144.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48804322-dc87-5729-adf5-8b65e8e03cfa','','','Recueil Trav. Bot. Néerl. 22:392.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f8d206e-5b2f-53bf-9e14-81f1825d219c','','','Lingnan Sci. J. 19:552.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d212693-479c-56ff-b6d8-b32597383a25','','','P. H. Lecomte & H. Humbert, Fl. Indo-Chine 5:1092.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9602be10-be59-5e28-ada8-6748a40592ae','','','Ann. Missouri Bot. Gard. 15:358.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af807195-b1df-5614-b538-bd44caf97e96','','','Fl. antarct. 258.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e0fb110-f9d2-5fa6-80ff-8372ccd0462e','','','Contr. U.S. Natl. Herb. 13(3):58.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8969fc4-5fcd-5cd3-bd80-f9032d65780c','','','Syn. pl. glumac. 1:90.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7796978-b459-5aea-b3cd-9c1c01ebc55a','','','C. S. Sargent, Pl. wilson. 3:439.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1dbf37fa-3404-5be2-ae3a-f9f80396f189','','','Geraniaceae 1: t. 47.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9434757-a195-5257-8c00-5c1cb408ef1d','','','Nov. stirp. pug. 2:24.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d38db0c-7f4d-5f36-a89b-41dc5bafbace','','','Landw. Fl. 328.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('052b310b-a57a-5f6c-8152-3f87bf3cbc4b','','','Sp. pl. 3(1):626.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb1cb94c-4699-5e83-a9fa-25f1bc3e8d3c','','','W. Roxburgh, Fl. ind. 2:293.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7ddd623-7bf6-5b40-ac94-c23a8c743de8','','','F. Cuvier, Dict. sci. nat. 38:385.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1c1081c-e040-5200-a90c-2f822388c127','','','J. A. Murray, Syst. veg. ed. 14:711.  1784 May-Jun (Fl. jap. 299.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc530eb1-ce34-5f08-8dc5-c367ddd5a940','','','Proc. Calif. Acad. Sci. ser. 3, 1:83.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17e87e7d-4c4f-5c2c-94cf-bb27cf6771c1','','','Baileya 4:86.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4418dc5a-9b55-536e-9ae0-09f0574b495f','','','Syst, Laur. 472.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95ae560a-3680-5378-9e99-e16a69316d4b','','','J. Linn. Soc., Bot. 17:500.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed76576f-6a9c-5af1-b2ec-8001a33f2e7d','','','Pap. Michigan Acad. Sci. 19:159.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ada242c-3284-59b4-a344-b4c972badbbb','','','J. Bamboo Res. 2(1):20.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('812cc8ab-57b9-5b83-b609-7efedd127257','','','Fl. Amer. sept. 1:181.  1813 (non Raf. 1808)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24a771e0-7c28-52e8-9914-17eb5b697039','','','Acta Phytotax. Geobot. 13(3):81.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31824971-e2fb-5e86-8aeb-571bc283304e','','','Nuovo Giorn. Bot. Ital. n.s., 19:576.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('368fba68-069e-598a-ad18-10e22d1591f1','','','Bijdr. 1156.  1826-1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b5eb6e6-df2a-582c-aee6-b6298da18ec2','','','Fl. Hongk. 99.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11ffb81b-6cbf-5731-aea8-8d336b1b50f4','','','Sp. Blancoan. 90.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aaca195a-d2da-587d-a4e4-3fa4aa0e9c56','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 5:467.  1815 (non Pers. 1807)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a75a6577-65d2-5d0b-9ac3-9c08b4115e38','','','Mem. Torrey Bot. Club 5:208.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bc7becf-2cc6-5b89-80d1-c5af39b605e6','','','Prodr. pl. cap. 47.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf2cc242-d17f-58df-a87c-8c74bbbfe08a','','','Sp. pl. 2(1):447.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0153fc0-ecff-568f-b8f4-0aa8f72e5dfa','','','Cat. Gratianop. 24.  1848 (non Raf. 1837)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab2d4ac2-1a31-5803-bf56-36b7ea084dc0','','','Bot. J. Linn. Soc. 142:115.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b7a1052-2c6d-5e20-a4e9-00537fe3c764','','','Hort. berol. 1:190.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b715a6c-ce50-556d-aee9-866f0bbd0283','','','F. P. Daniels, Fl. Boulder, Colorado 167.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efe4054f-4236-5030-9de5-96932267b310','','','C. F. P. von Martius, Fl. bras. 13(1):570-571.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14bef6c7-87e2-52ab-ae2a-4259abadb0c6','','','Ann. Sci. Nat., Bot. sér. 9, 6:341, t. 3, fig. 8.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba8cd25c-2384-51af-8dec-66f836496313','','','J. B. A. P. M. de Lamarck, Encycl. 4:48.  1797 "<I>ledifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a3049fa-9364-528a-b3a4-2ccca46c5af4','','','C. S. Sargent, Trees & shrubs 2:50.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1c131ab-79f7-578c-be68-06b4a45e401f','','','Icon. Pl. 7: t. 626.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f273d49b-4200-5168-913f-f5db6e5c66da','','','Fl. Brit. India 7:18.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e328841-cae5-5dcb-9c66-d9a429930d84','','','Linnaea 4:469.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c08ba88b-86b5-54f7-9c66-262e90199d7b','','','J. Arnold Arbor. 28:204.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96b89555-465f-5ea8-9577-0cab9392c6f3','','','Bot. Jahrb. Syst. 34:96.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96a8511f-d337-5f47-b797-6ba19727b8ca','','','Bull. Biogeogr. Soc. Japan 6:20.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa42abca-d7df-55d8-8219-59dff17baa6d','','','Bol. Tecn. Inst. Agron. N. 15:19.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7c40976-ccf5-5134-9f1f-257c06e6bc04','','','Leafl. Philipp. Bot. 7:2675.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('750a594c-9049-5b65-8e67-07df3f4f68a2','','','Enum. pl. 2:1047.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95dc424b-8703-531a-bb66-0dffdfbdeac6','','','Ill. fl. n. U.S. 2:456.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4bac7bf-9301-5802-8b8b-6ab41229a886','','','Proc. Amer. Acad. Arts 14:227.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a93e8227-f243-56ed-809a-06cc5bcea9eb','','','Sp. pl. ed. 2, 1:613.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb3277f4-cb24-505f-9df8-dfae264c6527','','','J. C. M. Grenier & D. A. Godron, Fl. France 3:180.  1855 Jun','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a678d6ec-4770-54af-91ad-fab0b5269583','','','Man. S. Calif. bot. 262, 598.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1fad154-b119-5b85-9050-5aa2dc36d250','','','J. Jap. Forest. Soc. 24:120, fig. 1.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('739931df-8fe3-5058-b3b8-61ed7daff575','','','Prodr. fl. Norfolk 17.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59508373-4355-5f3c-b230-7efdf360f44d','','','Global fl. 4:146.  2018','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c72ff4a-3f00-5f36-9da9-111460d6f8d3','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 16:674.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96f7d017-6dcc-51d7-be69-7d8dd3954cbe','','','Prodr. 7:164.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7ac17b4-0933-5f7d-b120-08ea0ea2456f','','','Repert. Spec. Nov. Regni Veg. 6:346.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8039633-6579-5fd6-a4bf-0d6235186a84','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 5:626.  1878 "<I>argute serrata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c651d648-a8e0-5c78-a175-1bb2fa1c9342','','','Trans. Amer. Philos. Soc. ser. 2, 7:323.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0f9a331-51a0-57f6-aacf-12e35d63e1fc','','','Erythea 1:15.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eaecf96a-cf2d-5deb-8976-4dbd42bc4294','','','E. H. F. Meyer & J. F. Drège, Comm. pl. Afr. austr. 273.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fa6638a-b1a3-540a-b880-9e9006818881','','','Bull. Jard. Bot. Natl. Belg. 44:421.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd5203c9-ebb7-5238-83cc-13e5e4f30729','','','J. Straits Branch Roy. Asiat. Soc. 59:106.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70363f7f-1af8-5dc2-9d0e-3e42cea67355','','','V. L. Komarov, Fl. URSS 25:870.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61957ca2-9ee4-5624-a6ad-0877eee0eea6','','','Opusc. Bot. Pharm. Complut. 2:103.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21b4c64b-2528-5012-91cf-3747c1aa5eee','','','Verh. Bot. Vereins Prov. Brandenburg 26:163.  1885 (Monogr. <I>Clematis</I>)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('128eb051-15b8-530d-a8ab-3d464e4b538c','','','Blumea 6:391.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36f94aaf-38c6-5411-b666-b47bccd26c96','','','Descr. pl. 1:260.  1802, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd161abe-0da7-5cc0-aa66-86f5478997da','','','Bull. Herb. Boissier sér. 2, 2:750.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e63b4b72-1bff-55f0-ae51-3e0efcf45dc7','','','Pl. delavay. 186.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b28fc7a1-bece-551a-9398-e75b28456426','','','Acta Bot. Mex. 38:9.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ba42520-bb3e-513f-a614-c4151a1aaa3f','','','Bot. Mag. (Tokyo) 13:17.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d94e72c4-676c-5293-bb44-9088e65fae94','','','Trudy Tbilissk. Bot. Inst. 21:28.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e381bc0-8483-5d03-ae40-26c7b5768fee','','','Nuev. jen. esp. 21 1855; Linnaea 28:428.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dda7fa4-0cb0-5667-8c7e-57be311fd706','','','Succulenta (Netherlands) 46:24.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e54fc8ee-d6dd-5b66-be78-c32eaba0b6fe','','','Aliso 14:202.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85b5e606-82e3-5118-860e-25c986f3cfc4','','','O. Warburg, Kunene-Sambesi Exped. 260.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c44d411b-db13-564d-a686-cc9c850e3b82','','','Van Houtte, Fl. Gewachause 2: t. 9.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bca6f799-5825-5b6a-a5f7-6f02777752d6','','','Syst. veg. 2:620.  1817, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03e6801f-046c-5924-937f-ca7c668f1ae1','','','Bull. Brit. Mus. (Nat. Hist.), Bot. 5:186.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca296a00-4eb8-59fd-b34d-849af257528b','','','Compt. Rend. Hebd. Séances Acad. Sci., Ser. D. 274:1655.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d48667c9-17e5-5272-a890-69a2c277faaa','','','Comp. fl. ital. 465.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ba3933f-f7ec-540c-810e-04b42746bca0','','','Enum. syst. pl. 20.  1760 (Select. stirp. amer. hist. 128.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f7e2351-bcb8-52b5-b7c1-551f515b9b51','','','Orchid.-Buch 480.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54177c07-0bb2-56aa-a159-5bf03fba845e','','','Rhodora 82:375.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('170a1048-bb93-5f12-a925-bc882ac47f44','','','J. Agric. Res. 1:153, 176.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39fe256e-4518-53ce-a8f3-87e542de0d54','','','Monogr. Acad. Nat. Sci. Philadelphia 1:152.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c041c771-8630-5d67-8949-eb026316e21d','','','Rhodora 56:261.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98e3de24-69a0-5618-9a09-33f2d7382e5f','','','Fl. carpat. princ. 258.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad5599cc-1c89-5bf4-a520-9fd2f47dd4e4','','','Notes Roy. Bot. Gard. Edinburgh 11:172.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a73232d6-d6ac-5726-b117-7c32b834e83e','','','P. R. Reitz, Fl. ilustr. catarin. 1. Acanthác.102.  1969 "<I>brandegeana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40586a91-709b-52e0-a4b9-57074e98670d','','','Malesia 3:242.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('380f351d-3c78-5c9e-a586-c0230350cc92','','','Bot. Zeitung (Berlin) 10:747.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad35fb50-046e-5e10-a9a0-f341d3814b78','','','Boston J. Nat. Hist. 5:218.  1845 (G. Engelmann et al., Pl. lindheim. 1:10.  1845)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6a02a2e-c7f6-5e0f-b18e-be103294df09','','','Fl. jap. 1:87, t. 42.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10d55f31-8dec-5d7b-8c5b-f4b3bde06bca','','','Hort. bot. panorm. 1:49.  1877; t. 12, fig. 3.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24986bbd-5dbc-520e-9609-c51b0f5ca1eb','','','Fl. jap. 1:126.  1840 (non Blume 1826)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3045a5f5-c7b5-5eff-8205-058308d8775a','','','Handl. fl. Ned. Ind 3:147.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1476564d-d8a1-567e-990e-777a9fd496ba','','','T. B. Croat, Ann. Missouri Bot. Gard. 91:703.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01516f8d-37e6-5102-b9f1-1c34a98bdd14','','','Pl. bras. icon. descr. 1:53, t. 47.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce219548-1ea4-5223-987a-f80dcb46ae6c','','','Cactaceae Syst. Init. 36:34.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31ab8f22-46d7-5db4-9919-e5dc92943138','','','A. L. P. P. de Candolle, Prodr. 13(2):57.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e220fe36-f5e5-58e7-a87d-b00209323e0c','','','G. King, J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 66:267.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0251cba0-4e44-59d0-b86d-5aabc2f9f594','','','Mem. ipecacuanha fusca 31, t. 2.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea5a1fd2-7de4-5a9c-ab58-7914a717930d','','','Nat. arr. Brit. pl. 2:564.  1822 ("1821") (non Mill. 1768)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('649125a6-944d-5e50-8bf7-cfe17baa096b','','','Fl. Japan IIa 383.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be806ebd-e8a2-509e-9139-81dc59f2a6df','','','Descr. notes Papuan Pl. 1:63.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('824dc3d2-479d-5571-89a3-e06ed114496c','','','Prodr. 2:321.  1825  "<I>micrantha</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26ca893a-8088-5075-9843-91fa96333997','','','Bull. Soc. Imp. Naturalistes Moscou 38(2):410.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1c36950-0ce0-59b1-b813-ff3c731a966d','','','Bull. Soc. Bot. France 45:180.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fdccdf3-37d9-5a05-b513-0bcde9063d26','','','Mant. pl. 2:237.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4490fbc-781b-57b1-9f92-f113307002a9','','','Gartenkalender 4:192.  1784 (Beitr. Naturk. 4:17.  1789)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ae20017-fa97-57d6-a17e-5de65df7715e','','','Bull. Bur. Pl. Industr. U.S.D.A. 179:17.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3770280a-2696-5793-b384-efb7d263029b','','','F. L. E. Diels & E. Pritzel, Bot. Jahrb. Syst. 35:308.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('000c29da-7ad2-53e3-bc62-5a89a9c290ff','','','Kongl. Vetensk. Acad. Nya Handl. 21:234.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be6f92cb-2a1a-5a04-9787-94df07a3b83d','','','Ann. Sci. Nat., Bot. sér. 4, 9:44.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3e6bb74-2326-57ad-90b0-efe72cefc6e5','','','Bull. Torrey Bot. Club 33:137.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('217ab5e1-d7fd-5226-96e8-107acb902737','','','Mém. Acad. Roy. Sci. Lyon, Sect. Lett. sér. 2, 1:336.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e769662-98bf-521e-8800-a3d9784cd8d0','','','Ill. fl. Pacific states 3:449.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7169a150-fcc6-5b63-a713-804d98f76e74','','','Bull. Calif. Acad. Sci. 1(2-4):100.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6394f1a0-235f-5e72-80cf-799d37f7a419','','','Tabl. encycl. 1:342.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61ceab51-911b-5f77-93c0-332f43f7fdce','','','Gard. Bull. Singapore 26:75, fig. 4.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22b63980-b516-586c-b00e-9234c219cdc5','','','Suppl. prodr. fl. Nov. Holl. 28.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('666d62b2-0121-5699-8be6-908bb8a18906','','','Sp. pl. 2:1008.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('560eaf3d-d95c-5749-bccb-d712eb75e2f6','','','Ill. Hort. 60:87, t. 67.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('799adec5-24fd-545d-adef-330a62c544c2','','','J. D. Hooker, Fl. Brit. India 6:224.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f05f1ca9-6a3b-5aa5-8ee9-692ca2c58e1f','','','Repert. Spec. Nov. Regni Veg. 20:278.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25a6bf10-d030-5096-a82c-1ce48e8a960f','','','Mem. Tanaka Citrus Exp. Sta. 1(1):42, in obs.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0dae0d7-f565-5a3d-ad8c-5de2534799af','','','Diss. 4:204, t. 89, fig. 1.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b947fd43-aa66-5610-abcd-d80e29f0f5cb','','','C. L. Hitchcock et al., Univ. Washington Publ. Biol. 17(3):84.  1961 (Vasc. pl. Pacif. N.W.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c85cddbe-20f6-5537-befb-544dbbab2eb3','','','Sp. pl. 3(3):1517.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3845a900-6c8b-5872-8e8a-7dba8720b810','','','K. H. Rechinger, Fl. iranica 147:154.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27013237-35e5-5151-8d12-4c26aeb0c8d1','','','S. Watson et al., Botany [fortieth parallel] 129.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e150f79a-2f0e-5411-9ec8-443188f0380d','','','H. G. A. Engler, Pflanzenr. IV. 105(Heft 70):35.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dbdba4c-a9da-52c3-9bda-774d37459a07','','','Bot. Jahrb. Syst. 33:313.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ad10694-f92f-5bc8-87e8-6324064d6d76','','','Fl. n. middle United States 104.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c74c6480-9312-5e8f-b6e2-f57e85e52016','','','Notes Roy. Bot. Gard. Edinburgh 5:173.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5107b20c-1525-5e43-b473-5c16bd30d1e7','','','Gard. dict. ed. 8: <I>Cereus</I> no. 5.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97e45fd1-989e-533a-a5b9-788beb72daad','','','Bull. Torrey Bot. Club 53:218.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e56652c9-9d18-5536-8f6d-e6b3d6617ddf','','','Kew Bull. 32:1.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db47cb0b-cdcf-5efa-b277-f26813b58e84','','','Kulturnaya Fl. SSSR 2:426.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d49fe2bb-93b4-5f70-beda-c23ef7dc95a3','','','Pl. vapinc. 31.  1785; D. Villars, Hist. pl. Dauphiné 1:335.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c17588f9-9c3d-5246-83ee-d49ea1a6a7ad','','','Int. J. Pl. Sci. 170:809.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdd1704d-8e25-5f68-a9cb-c3903e7d9c12','','','Bartonia no. 23:36.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2af1b31-042b-5928-b522-bfbc941ecc7f','','','Gen. hist. 4:245.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cde163f-0c19-59bc-8970-8077e86a953e','','','Fl. Tasman. 2:368.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc8b402a-3676-55b2-9869-58f208e61354','','','Rep. Bot. Soc. Exch. Club Brit. Isles 4:613.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3e931ee-57c7-5b88-b8ae-e6c7719e504d','','','C. F. von Ledebour, Fl. altaic. 1:415.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fd4aa56-a84e-5352-ba48-2b7ad60fdabe','','','Repert. Spec. Nov. Regni Veg. 13:525.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1de4de10-f896-552f-8fd1-ce5e509065c7','','','Sp. pl. 2:852.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58d77d08-1e7e-5031-96be-7f27055eb618','','','É. A. J. De Wildeman & T. A. Durand, Bull. Herb. Boissier sér. 2, 1:882.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd2feec0-b45e-5a25-926b-2c53cc720ddf','','','Bot. Mag. 48: t. 2230.  1821 (non Salisb. 1769, nec Roxb. 1832, Cambess. 1833)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d4573cb-dc1f-5bd2-be6b-ec75ebffb5ed','','','Catalogue 125:9, cum t.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62f88343-9abb-5152-9fd2-cb2913914825','','','Notul. Syst. (Paris) 2:244.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26d1c73e-7074-5c6b-a052-941832afaf6a','','','Nov. gen. sp. pl. 1:151.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85abb8f7-760d-5f77-98fd-cca4cb143305','','','Bot. Jahrb. Syst. 37(Beibl. 85):58.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61695cae-d31b-5b40-8b91-0fc5c4f227af','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:11[folio]; 3:15[quarto].  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0131b3bd-d92d-5347-b33d-29c94643e683','','','C. F. P. von Martius, Fl. bras. 10:6.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2078f64d-df87-5658-8c19-ccc91af2a734','','','Reinwardtia 6:192.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24b18add-452f-56da-aeb9-cf28814be672','','','Yuccas Southw. U.S. 2:49.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd484de7-334c-5f67-821b-00898f7d6285','','','Mem. Torrey Bot. Club 5:152.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa477377-e238-5a26-bcfe-66f51472562e','','','Nova Guinea 8(1):583.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44c18ca8-fd31-50f6-8587-87e9404e57b3','','','A. Rees, Cycl. 6: <I>Castalia</I> no. 3.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53701c41-ba74-5517-9da0-0ac6e5bd26fd','','','Fl. Brit. India 1:114.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9923b1d3-c022-5d7e-8fad-15a5234d3846','','','Monogr. Orobanche 117.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48496dbe-5a00-5e62-add2-61cb0b4ae387','','','Flora 57:523.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0bf4243-6b63-57ed-bf92-721ba51b3b0e','','','Compan. Bot. Mag. 1:375.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9b835a9-8d0b-54ff-a8c1-637d0c03a283','','','Adansonia sér. 2, 18:366.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b1c91fc-4cf9-5eb4-8f1f-7edd5395a91f','','','J. Bot. 70:328.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b046725-f497-542b-bc8d-936c16161221','','','Bot. J. Linn. Soc. 178:85.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8f6d174-67eb-5850-9ec1-82ce55bdd562','','','Handb. Laubholzk. 3:710.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5c4d12c-887b-55f2-8cd5-94691dd162ac','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:393[folio]; 6:503[quarto], t. 593.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a1f4b82-396c-5927-9e40-6c93876b4750','','','Diagn. pl. orient. ser. 1, 6:22.  1846 ("1845")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2652479-2445-5518-893f-23f9c2ac62e0','','','Ann. Sci. Nat., Bot. sér. 4, 16:193.  1862 "<I>Crugerii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3c1a131-98d4-56e5-b5ab-eaa3a7e49625','','','Bot. Misc. 3:365.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28497781-fc2a-5163-9a6b-84ff1bd78524','','','Gard. Chron. ser. 3, 15:238, 368.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36f6896e-4119-503f-adb5-f51adb331dc2','','','Ref. Naucno-Issl. Rabot, Otd. Biol. Nauk 1945:7.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('feb11a2a-9142-5279-a48e-d7d2ff0298dc','','','Kew Mag. 1:42.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b8b8daf-8680-556e-a35d-1a2302cb4a51','','','Chem. & Druggist (Australas.) 5:56.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7eafcd39-ab27-556c-8711-a3900d5e577f','','','Linnaea 25:299.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('628d9e55-a769-5bc7-ac26-06111d12a635','','','Fl. adv. Montpellier 697. 1912 Jan (Mém. Soc. Sci. Nat. Math. Cherbourg 38(sér. 4, vol. 8):697.  1912)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc9ffaad-a321-57bc-b50a-098f9182e234','','','C. Backeberg & F. M. Knuth, Kaktus-ABC 329.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4abec8bc-124e-5dd2-9a6a-3a4e27fda052','','','Telopea 6:405.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f01ee89-efbf-5880-9dd5-166ca7694780','','','Opera Bot. 95:188.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a95a4466-0252-5142-bcc6-f3f81002afc4','','','Not. pl. asiat. 3:296; Icon. pl. asiat. 3: t. 299.  1851 "<I>bootanensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba13c9a1-e203-58bc-9802-fd98509e8f27','','','C. F. P. von Martius, Fl. bras. 13(2):84.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80e6b4c0-eb44-5c15-81e6-75390480126c','','','Gard. Chron. ser. 3, 1:543, fig. 105.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a4529b1-18c2-55ec-aa74-a82dde34fa92','','','Allan, Flora of New Zealand 1:880.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b60b5514-c703-5b7d-8837-1d94d5acbd05','','','Repert. Spec. Nov. Regni Veg. Beih. 93:102.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('204c753c-4e96-5f15-b188-bd8f2ae2bf45','','','Belgique Hort. 15:162, t. 11.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2557f1b9-e983-5c36-acae-3c2380edacaa','','','Gen. sp. orchid. pl. 127.  1831 "<I>Phajus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('967cb334-8131-54c5-a254-fc4c859d0c57','','','Bull. U.S. Geol. Surv. 2(3):235.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97fff61c-ab67-5831-8a8a-e166263a6f8b','','','Melet. bot. 35.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b7f182c-3219-5b94-8558-d84f7ea58fbd','','','Fl. pedem. 1:108.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('592bbec6-185b-5611-9a45-c9981d52a3d2','','','Bol. Soc. Brot. sér. 2, 36:60, t. 8.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d812dd5-12b9-525d-a90c-0e95de68cf3b','','','Cat. hort. dyck. 165.  1850 "<I>haynii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('965b5fcb-636c-515f-bcb7-23585a3e96a6','','','Forest fl. Burma 1:547; 2:586.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('929e9c5b-ec3b-52d7-94b1-9ae737849e33','','','L. Diels, Bot. Jahrb. Syst. 29:464.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb1be051-2c13-511b-8c63-520223793b00','','','I. Urban, Bot. Jahrb. Syst. 15:337.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86df5736-1d05-5327-ae33-7ff2671109e2','','','Contr. U.S. Natl. Herb. 32:84.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('259f5121-cadc-5b25-b2aa-5d8691b0de88','','','Anales Inst. Biol. Univ. Nac. México 13:629.  1942 "<I>vejari</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eef56256-8f2e-5e7a-8b1c-724cca1263f7','','','Bot. Mag. (Tokyo) 48:334.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04c998a9-7e39-52b5-8f5e-9dab31957135','','','Diagn. pl. orient. ser. 1, 8:64.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eba72e90-3df1-5ed8-8802-2eb9b5138a7d','','','Edwards''s Bot. Reg. 22: t. 1835.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5009c10-6e7a-5ebb-95c6-d61e0218ccd7','','','Symb. antill. 9:471.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dfe4d69-e4e4-57b3-9d33-45dcc810702a','','','Bull. Soc. Dendrol. France 13:194.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('019e8a9d-5c58-59af-97fb-21fb13308ad9','','','Bull. Soc. Imp. Naturalistes Moscou 30(3):110.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3f7c5a4-d954-5b44-912a-8aeb19af351c','','','Bot. Jahrb. Syst. 16:443, pl. 7.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fc83c7e-e1fb-5594-8292-fe355b87af8d','','','Rev. <I>Allium</I> sect. <I>Allium</I> 101.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d599049-9c33-568b-87dd-3183c99226e4','','','Kulturnaya Fl. SSSR 1:169.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85a73e3c-e5ab-53c3-afae-565e8ffdc06a','','','Bot. J. Linn. Soc. 157:120.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d4856db-714b-593a-9707-ef6208bd0df7','','','Bonplandia 6:369.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52660d6b-b17a-5600-b453-8c1fdb4bd05c','','','Encycl. 1:513.  1785 "<I>Budleia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da73ab8c-ea65-5663-abe7-8f6a1517a1ba','','','Contr. U.S. Natl. Herb. 2:101.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90cab78f-dade-56c7-b06b-c6a928de3ab1','','','Willdenowia 41:249.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84e209e1-49d3-511b-963a-f81b92b2aea2','','','Syst. Veg. 7(2):1286.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ba39ed8-d38f-53a0-9634-4451668a4a1f','','','Enum. pl. afric. austral. 298.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('459d0b41-876c-50bc-bf85-a92566c65e35','','','Publ. Cairo Univ. Herb. 7-8:328.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ecb3c68-f642-55fd-a4f8-ed9ee74b16f5','','','Revis. gen. pl. 2:759.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f435be8-1010-5457-a4fd-47ac0eb831ce','','','Handb. Laubholzk. 1:246, t. 158.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7200e6e7-0038-5f0c-aad9-b181fbf6a31e','','','Enum. syst. pl. 20.  1760 (Select. stirp. amer. hist. 119, t. 173, fig. 3.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66b19e97-b1fe-5479-b18c-a9c11abcb5af','','','C. Gay, Fl. chil. 2:228.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('767f6ffc-fa32-57b6-a8c4-179dac54cc65','','','Fl. pedem. 1:285.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3be96d01-4f18-512b-92df-d2157d2923f1','','','Encycl. 1:62.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d191d9d-3e3c-5d44-a30b-693936a86545','','','N. Amer. fl. 24:119.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb849958-fbc3-5608-960d-28951d25a120','','','Hist. nat. palm. 2:66.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01895948-034f-5b97-9977-cee96d67a15d','','','Flora 25(2, Beibl.):55.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5d3a62a-34d6-535d-bc1d-30fbd804c2d0','','','Feddes Repert. 95:458.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30519d60-b4e4-5981-93bf-069159a7d4b7','','','Kew Bull. 44:119.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a5f4d91-193c-5f50-9f1a-36b31618a371','','','Taxon 42:47.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9f37a2f-d230-59bb-a7e5-cfe454988fcb','','','Bull. Jard. Bot. État Bruxelles 9:154.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2c28079-65f6-5f25-9a96-f66792745769','','','C. S. Sargent, Trees & shrubs 1:45.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65dcd49a-3ea3-5566-96aa-af9469f4adfc','','','Notizbl. Bot. Gart. Berlin-Dahlem 12:611.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d23a7c59-91d1-5051-9557-90beabd20109','','','Bot. Jahrb. Syst. 3:420.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab7bdc52-75b1-5169-8135-b20461667eb1','','','D. Oliver, Fl. trop. Afr. 3:28.  1877 "<I>ferrugineum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0b4e6a3-5551-5d63-93d6-a9ebd5db8e7b','','','Kew Bull. 1955:597.  1956 "<I>roseo-alba</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9551342f-4cb5-5947-9122-cac6ad822a6a','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 1:222, t. 11.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b50660d-45ab-5bc1-81f9-183a68f60158','','','Hooker''s Icon. Pl. 39: t. 3865.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f1d3293-ae0f-5042-af8b-135eb7858fac','','','W. T. Thiselton-Dyer, Fl. trop. Afr. 4(1):243.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f7bbf3b-96d8-5b02-8275-5ea79bf001d9','','','Telopea 6:381.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa96dda1-1fef-5782-a8a5-b1e485d7c69c','','','C. F. P. von Martius, Fl. bras. 15(1):214.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfd0b80c-9733-5fa6-b797-0177ac7ac9d8','','','Irid. gen. 133.  1827 (non Burm. f. 1768)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4aee020-6596-576d-961a-b97f69a8e5c3','','','Spisok Rast. Gerb. Fl. S.S.S.R. Bot. Inst. Vsesoyuzn. Akad. Nauk 18:25.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3ee5b62-4d4b-553f-a6f9-6c9b752992bd','','','Fl. ross. 1:258.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d71bd6b4-7e20-51b3-91a5-e24baa22dbef','','','Ann. Mus. Congo Belge, Bot. sér. 5, 1:139.  1904 (Études fl. Bas- Moyen-Congo)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f6f197e-267e-519b-947d-184f0437c61d','','','Bull. Torrey Bot. Club 29:573.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efcf3711-d212-53fe-9486-46b1fb26b699','','','Diagn. pl. orient. ser. 1, 7:96.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78672acd-bc8c-541c-b941-0a768a9a76d7','','','Rhodora 62:16.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54eb8617-1a2c-588e-a193-9b743e60ca4e','','','Darwiniana 3:251.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c64be74-4b65-57a8-a98d-490a4bbf50fb','','','Bull. Mus. Natl. Hist. Nat. sér. 2, 3:523.  1931 "<I>prieuri</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('140eea74-5e09-58bb-871a-d484f918855a','','','Castanea 34:408.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9aa65312-b0e0-5994-a0f3-482e3feb26d7','','','Artemis. 29.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67c12458-5dbb-5ee8-b5d9-b415e420d081','','','J. C. Röhling, Deutschl. Fl. ed. 3, 2:433.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e14873c3-16a4-543e-bfe4-e5e717b16839','','','Rad Jugoslav. Akad. Znan. 16:20.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('456f5787-e834-5506-841d-cb0feaee4e99','','','Oesterr. Bot. Z. 8:182.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0117de62-1125-5ad3-b8b5-6c7e3fdbbe34','','','Oesterr. Bot. Z. 21:12.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef590d30-1077-53bd-94e3-11a929cc08f2','','','Fl. N. Amer. 2:216.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe9a1709-065b-5132-98c0-b021344941e9','','','Bibl. cult. trees 160.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eac10550-a33c-5cc9-9c53-8c4e96e463b3','','','Vierteljahrsschr. Naturf. Ges. Zürich 66:227.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9162ff2-9be5-57af-ad03-21ec00a1f62c','','','Fl. ross. 1(1):59.  1784','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb8f84ee-6857-5eea-bed3-3bf26dfd74ee','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 2(6):215, t. 234.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b14065f9-b6b1-5fe4-82a2-89b514f80da3','','','Not. pl. asiat. 3:365; Icon. pl. asiat. 3: t. 320, fig. 1.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67e914b2-f836-541e-92f3-c77d84c8b3d0','','','Acta Phytotax. Sin. 19:16.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85c4d247-bd03-58e3-a7e2-cf9245af7550','','','Bot. Gaz. 13:210.  1888 "<I>brandegei</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('156c12d3-8918-5637-a82f-0306f475016a','','','Calyx 6:55.  1999 "<I>roeleanus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9045674c-3d36-5986-b185-79119ce28b77','','','Bull. Soc. Roy. Bot. Belgique 27(2):148.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5226a428-3e66-5da1-892c-f8a08d115073','','','Fl. franç. 3:157.  1779 ("1778")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddc785c1-9657-5ad5-a4c6-74e9cd74829e','','','Notes Roy. Bot. Gard. Edinburgh 8:60.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24cf32d9-2ebc-58bb-9868-ae142089a1ef','','','Bengal pl. 2:1054.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64498b9d-efcb-56fe-bbd5-a6541db2114e','','','W. Aiton, Hort. kew. 2:420.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9120b9f-12ad-5aa7-af3c-2bfc6b503965','','','Mém. Soc. Imp. Naturalistes Moscou 3:256.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb48fe91-6fb1-5efb-847e-3f31f265c10b','','','Gard. Chron. ser. 3, 84:254.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a633168-af36-5991-aace-655577d70c03','','','Acta Phytotax. Geobot. 11:36.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c625fcb-a0c9-5751-a717-0df81dcc4593','','','Bot. Mag. 155: t. 9275.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00e674b4-bdb3-5a3a-8076-0e86c49104f2','','','Prelim. rep. forest Pegu, app. A:xliv.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85782ef5-184d-5d3c-8877-4d8e0ba57e02','','','Notes Roy. Bot. Gard. Edinburgh 5:159.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67794f0b-686b-582c-b4eb-4b8bb8660707','','','Mém. Mus. Hist. Nat., Paris n.s., 19:159.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d28becd6-0511-5bea-a797-0c41f9d1827e','','','H. Jaeger & L. Beissner, Ziergehölze gärt. parkan.  ed. 2:500.  1884 "<I>rosenthali</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('744be525-5035-5232-b790-e2633776d702','','','Gard. Bull. Straits Settlem. ser. 3, 9:327.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2be8e7e5-3db9-55b3-9d0a-76c71b128933','','','J. Acad. Nat. Sci. Philadelphia 7:36.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6856a28-08d8-5684-8c9d-eecbfac9fd76','','','H. Wawra & J. J. Peyritsch, Sitzungsber. Kaiserl. Akad. Wiss. Wien, Math.-Naturwiss. Cl. 38:584.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('669539fe-a24a-5160-adc3-e9c0530fec2a','','','Ann. Jard. Bot. Buitenzorg 1:18.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb22d2e0-72f0-57b9-9dee-592804449934','','','Bull. Natl. Sci. Mus. Tokyo 14:265.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('329458ca-47a1-52f2-b50b-8cfe01c6dd62','','','Vasc. pl. Wyoming 297.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1286b470-ec5d-5e89-b635-07e1dfc00dbd','','','Fl. bor.-amer. 2:99.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('629c76c3-8fc4-549b-8fda-66502b6e416c','','','Pittonia 1:120.  1887 "<I>watsoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e515ab2c-24f0-5e77-b880-4b3b05183756','','','S. L. Endlicher et al., Enum. pl. 63.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a56a4ed-02c0-5cfd-823e-09146bf02f22','','','A. L. P. P. de Candolle, Prodr. 13(2):276.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c168dd8a-56b4-5fae-a71d-82a720c47d3e','','','Fl. Calif. 2:151.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('120a4f29-08d5-5930-8ec1-68315e8ac800','','','Kulturnaya Fl. SSSR 1:153.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73fb08a5-9c6a-5550-9047-fee0a92132a7','','','Taxon 63:83.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d329e2e-ac45-5e00-b0a9-2b4ada294d72','','','Bull. Jard. Bot. Buitenzorg sér. 3, 8:315.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27544445-185f-5cf9-bbd3-15276f4fcf54','','','Pl. Coromandel 1:16, t. 15.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d952a02-e90f-540d-9386-3a7ad0a6e037','','','Bot. Zhurn. (Moscow & Leningrad) 52(12):1790.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9fcb82e-853c-5fb4-86f9-17a59a85b193','','','Austrobaileya 1:132, fig. 9 I.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a46d3624-195b-523b-a4a9-ac53e3b89e1f','','','Revis. gen. pl. 1:318.  1891 (non Lam. 1783)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90bc381f-d820-595b-badc-ba11c0e07451','','','J. Jap. Bot. 39:115.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a92e8c5-ec0d-51c4-97d1-68093801cf23','','','Kew Bull. 70(3)-31:56.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d9a38df-d900-5a9f-9220-7e050e56497d','','','Jard. Malmaison 2: ad t. 74.  1804 "<I>diosmaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d947f3c9-47f1-53bc-aaf2-15c071e187b5','','','Sp. pl. 4(2):1033.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f25a103-21ef-50ad-8d2a-c91f99d7d687','','','Syst. nat. ed. 10, 2:1020.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e199532b-e1ad-5803-ab9b-8fbfcb2f39c1','','','J. Linn. Soc., Bot. 18:187.  1880 "var. <I>G. natalensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98a49f3b-c434-51c8-b3c8-cae7916aecfd','','','Pl. hartw. 307.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c12ee85-aff7-5d32-aeeb-9138c7498db8','','','Observ. bot. 1:16.  1764','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99dc752d-86e9-5879-940f-bd0bad48773e','','','G. Hegi, Ill. Fl. Mitt.-Eur. ed. 2, 3(2):501.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ae6d35c-aa8b-5bd2-9a0b-2c0891799a6f','','','Nuovo Giorn. Lett. 8:120.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab773170-e860-5ba8-b238-0d05c78da54d','','','Bull. Misc. Inform. Kew 1911:356.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5311d84-77ee-5166-923b-db2f32d820ea','','','Geograph. Mem. New South Wales 347.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63924eb3-47fa-5129-93b9-e04a3b8a56b4','','','Sp. pl. 2:603.  1753 "<I>virginica</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb45c46d-d973-5bdd-be9f-25b4eaf8dcff','','','The wheat plant 183, fig. 122, 123.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffda22ce-cab6-5134-8e98-a46944097030','','','Proc. Linn. Soc. London 153:89, 91, fig. 5.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1a7142d-8e07-579e-b7d5-882d617c2698','','','Trans. Linn. Soc. London, Bot. 1:174.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25ba18a3-5a4a-5d24-a3d0-49ddb8268057','','','J. Washington Acad. Sci. 32:174.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09ef7452-2cdb-5d2b-bc53-321017b62ea0','','','C. F. P. von Martius et al., Fl. bras. enum. pl. 2(1):248.  1829 (Agrost. bras.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d73dfa1-04cc-577b-a690-1a923594d62f','','','Prodr. 5:655.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42ba7bb5-cc58-53f3-a916-fed0c811a09d','','','Fl. reipubl. popularis sin. 49(2):261, 322.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cae56158-3a90-5d59-8fd3-77e7ec12cd91','','','Bull. Misc. Inform. Kew 1926:160.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13c21064-f332-5a62-b5f0-3ce643963576','','','Proc. Amer. Acad. Arts 9:189.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd95c286-7c56-5c8a-852e-862acc833c5c','','','Cactaceae 3:111.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49c1d25b-a8d7-5110-a15b-b4e2290fdcb5','','','Bot. Reg. 1: t. 38.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f83cb426-29ac-5b13-b8fe-13f2f75b5514','','','Result. Sci. Miss. Stefan.-Paoli Somal. Ital. 1:115.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('496c5dbb-298e-5eba-a8b5-b53ff244be8f','','','Verh. Vereines Beförd. Gattenbaues Königl. Preuss Staatenser. 2, 1:269.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ceabc31d-94f9-53cd-940c-9bfaa294b53d','','','Notes Roy. Bot. Gard. Edinburgh 36:113.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9de33d23-9449-5f06-a4ae-a7a963ebeabb','','','Linnaea 13:34.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e38d481a-d088-5f4a-8cad-376dc06a6918','','','Trans. Acad. Sci. St. Louis 2:491.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9aa86924-d2b7-578c-847e-fe4150c68202','','','S. Watson et al., Botany [fortieth parallel] 201.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e849728-df6a-50a5-93ba-10fa891c5aae','','','Contr. Hist. Nat. Colomb. 1:2.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32ba6c67-0172-5c2a-808a-959999415dc1','','','New Zealand Country J. 3:58.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de0ef366-a9aa-5810-a497-0c4c700dc791','','','S. African Gard. 17:365.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f99fba2-5744-5c65-a1e2-fcd7263c037f','','','Rev. n.-amer. <I>Astragalus</I> 89, t. 7.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd829ac0-dd23-5710-99e0-f2585e5a51b5','','','Symb. bot. 3:4.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b751bb9e-7d64-5a12-9651-dbad0a03ac0c','','','Fl. helv. 1:287.  1828, nom. inval. "<I>Festuca rubra megastachys</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a36fb0bc-4ede-548e-bedc-a0137201f504','','','C. H. Stirton, Advances in legume systematics 3:126.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1668e30d-c221-5cec-91b7-e1c7a5fef27a','','','Bot. Jahrb. Syst. 22:426.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('835a787d-83e6-5af1-8944-a1179d486e85','','','Bull. Torrey Bot. Club 40:124.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c425971-1e96-5e56-8eea-2e6c0c4ebcfe','','','Trans. Acad. Sci. St. Louis 3:302.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00750217-6f51-5b90-aa10-f2d915905645','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3b):223, t. 88.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('956208d0-38a5-51a4-87e6-5f62232f1f70','','','Sp. pl. 2:647.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f080153-c008-5f70-b025-db45f98be8ab','','','C. S. Sargent, Pl. wilson. 2:77.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('770f52c9-ce92-515b-8372-7f9a1e66d18e','','','Meded. Proefstat. Thee 40:67.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9b9018e-987e-57fe-b3a4-861066ecd54d','','','Prodr. 5:73.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c8de35b-921e-565c-b36c-47306a2ecb89','','','Flora 31:95.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d56c8586-82af-5ec2-a2b4-278c89e52067','','','Hist. nat. Iles Canaries 3(2,1):92.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ddb0cad-84f4-58ea-b9d4-9dea1dc98980','','','Brittonia 30:467.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09d5420f-7fd8-5ee7-9071-caca6716788e','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:56[folio].  1823; 6:69[quarto].  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62f05608-ba91-5a57-8f29-eddce040de4a','','','Philipp. J. Sci. 26:452.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3423948d-a638-5a4b-aa28-426f7fd13fc6','','','N. Amer. fl. 23:108.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17a006a8-0d04-5e0e-9be2-844d497a256f','','','A. L. P. P. de Candolle, Prodr. 15(2):11.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41163909-c3db-5677-954c-3523ba11a472','','','Ann. Mus. Bot. Lugduno-Batavi 3:47.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b38be0dc-3dff-5608-b8ff-e63c646a7a34','','','Fieldiana, Bot. 31:238.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44de22af-39d4-5726-a57b-81ad2509308b','','','Sp. pl. ed. 2, 2:961.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe8d3613-3497-5fe0-857a-519ae42fba98','','','Mant. pl. 59.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d02bbec-543a-5d5b-9628-1449f2aaf111','','','Trans. & Proc. Roy. Soc. South Australia 57; Biblioth. Bot. 20(Heft 85):280.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25dafd5f-a252-5552-a43f-2e0d7e1fb201','','','A. L. S. Lejeune & R. J. Courtois, Comp. fl. belg. 2:166.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6584ea5-9a45-5c98-8135-dcccddf46820','','','Kongl. Svenska Vetensk. Acad. Handl. ser. 2, 6(1):94.  1867 (Monogr. Salicum)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e5c2837-0fae-5867-b7fb-4f8b499b177d','','','Pl. wright. 2:42.  1853 (Smithsonian Contr. Knowl. 5, Art. 6)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85c22acc-025b-5178-b262-6a9bae38b969','','','Compt.-Rend. Séances Soc. Sci. Nat. Maroc 20:175.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f05d2b23-6c6a-598a-b661-663ed04a6aed','','','L. M. d''Albertis, New Guinea 2:398.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bc1ce40-20bb-54b2-81d3-03839df7c821','','','Man. fl. pl. Calif. 1116.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03f4c9f3-66c4-58f1-8ca3-0d6a50d581dc','','','Phytotaxa 265:20.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d02e9775-2be3-5045-a2c9-761245414dcf','','','Hist. vég. isles austral. Afriq. 67, t. 21, fig. 1.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb9d102e-b7a1-5905-b3c0-70d1d2572e30','','','Linnaea 32:693.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7a20739-1782-5de5-8973-8b39b53f0a42','','','Pinetum 166.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7651fcdd-4cb8-54b0-b316-699f6931cd02','','','Boston J. Nat. Hist. 6:158.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b34489f-d405-5c66-971b-6ccfa60a6875','','','Principes 7:85.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('472d1aa5-9a33-5898-ad82-8401678caf1c','','','S. Watson, Proc. Amer. Acad. Arts 22:441.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ba0966a-9a24-59f0-836e-c73d420eb3f6','','','Hist. pl. Dauphiné 3:615.  1789 (D. M. L. Cirillo, Essent. pl. char. comment. xxxvi.  1784, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('487713e2-2a49-538b-a1e1-f260c1207e51','','','Austral. J. Bot. 36:129.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44a7a5f1-c40f-587e-9b27-484af463d860','','','Syn. pl. 3:43.  1842 ("1843")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('524c478a-f08f-57dc-86f8-74acdde53a31','','','Cat. sem. spor. hort. bot. Univ. Imp. Tokyo 32.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd448303-bdef-5918-9cdf-97c905c7763a','','','Ann. Soc. Bot. Lyon 9:274.  1882 (non Brot. 1804)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('947cbdcd-077c-5b13-9bc2-557af5d02cc6','','','Fl. s. Brit. Columbia 88.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1b923e4-0132-5afa-889e-6b7589f66242','','','Vég. util. Afr. trop. franç. 5:214.  1909 (Bois Côte Ivoire)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89731c51-1c71-58b8-b403-9dc6217c817b','','','Prodr. stirp. gott. 217.  1770','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42d74861-1d90-5470-a299-2ac1203e1ea8','','','J. A. Murray, Syst. veg. ed 14:480.  1784 May-Jun (Fl. jap. 220.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f61a04c-998c-52c8-8a22-1924656f1cc7','','','Intermountain Fl. 5:260.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d065d300-3512-5197-933a-be21acdb351d','','','Acta Phytotax. Geobot. 10:98.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0027a3f-1825-5865-a649-c2d54a32d48e','','','Syst. veg. fl. peruv. chil. 164.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('652f539b-79d0-5ebb-a143-024568d64fd6','','','Fl. austral. 2:105.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c9ac677-6ac0-56c5-87b9-0ecd2ed791a2','','','App. Ann. Rep. Exp. Farms Canada 1901:439.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17ca85fa-c0d6-5533-91f8-fc208f6ef184','','','Repert. Spec. Nov. Regni Veg. 15:310.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e86b583-2d1d-5a41-be99-f51536b31046','','','Pittonia 3:242.  1897 "<I>fascicularis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcadc8ce-4792-5118-bf24-bb9cb9fe9523','','','Syn. fl. N. Amer. 1(2):8.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecaf3906-b0b9-5c30-889e-f73061f9d9d4','','','Philip. J. Sci. 13:188, t. 5.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8be39396-0ce1-5262-938b-80f79ae04bc1','','','Syn. Queensl. fl. suppl. 1:8.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4740d1ee-ee2c-5580-858b-c0cb96ba777f','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 4:168[folio].  1818; 4:215[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bfce66f-b01e-5479-9385-7cac39d23a3d','','','J. Bot. 11:303.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82fb0d93-00fa-5546-a789-5e4a8a75a2e0','','','London J. Bot. 5:105.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1d45971-d437-5433-bdfc-20e8d578ac05','','','Syst. veg. 4:511.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d7990c3-cfe2-5b81-8668-5f144ae815ea','','','Rhodora 21:187.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c611724d-fc2d-50c5-8d8b-ab22cf9afba2','','','Ann. Sci. Nat., Bot. sér. 3, 11:74.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8f59bf9-e416-5be0-a88c-b6f70ce0777f','','','Mem. Wern. Nat. Hist. Soc. 6:84.  1827 ("1832")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89b12b92-b718-550a-911f-b78234100fbb','','','Sp. pl. 2:981.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bade8ea-a49c-5d71-88cf-c61e54c06555','','','I. Urban, Bot. Jahrb. Syst. 15:308.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('752cf683-673d-548c-8bd2-c7cb74a2425c','','','The wheat plant 184.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('016b6e06-b6a7-50cf-8546-9a44c3a5cb63','','','Prodr. 2:410.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a204fbdf-55e6-5534-908b-69f591d8420c','','','Austral. Syst. Bot. 6:371.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8919c30-95c9-56ef-aac0-f0f9354b3285','','','Repert. Spec. Nov. Regni Veg. Beih. 30:885.  1926 (Prodr. fl. penins. Balcan.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e74d11d0-cc73-579e-9508-f94b4b34dd82','','','Man. Comp. Jard. 2:289.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25731482-cb12-5700-860a-2e280d764bee','','','Fl. austral. 2:424.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3197e021-a997-5228-8fbf-9629a6e75102','','','Man. pl. Transvaal 1:50.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c42b3ffe-bcef-593d-af9f-6a68a3b8a220','','','Trans. Missouri Acad. Sci. 5:85.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('512ad155-b9c4-5cb5-928a-1082687258b5','','','H. J. Jacobsen, Handb. succ. pl. 3:1103, in adnot.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82dd1cf6-32ee-572d-9071-0d630c3e5925','','','Compan. Bot. Mag. 1:97.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a5cbc4c-72b7-52be-af23-a290aa87e87d','','','C. F. von Ledebour, Fl. altaic. 2:454.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f961209-8284-57d9-b39d-76e5f91852c7','','','Prodr. pl. cap. 161.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bd5c616-1434-558a-803d-c007517597a1','','','State Agric. Coll. Colorado Bull. 12:36.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bec37be-0b12-5d08-b034-d9bbc1bc800d','','','Bol. Soc. Venez. Ci. Nat. 4:82.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76686226-61ac-5a78-a10e-2242455ee0a8','','','Fl. carniol. ed. 2, 2:116.  1772','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7a31cd4-c073-5d98-ac8e-e5970bf9da99','','','Repert. Spec. Nov. Regni Veg. 8:285.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('847ddd16-87c0-505b-af28-46212e25bc02','','','Nat. arr. Brit. pl. 2:614.  1822 ("1821")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2bce83b-1b02-5a16-910a-fbf7d0c81be9','','','Ann. Missouri Bot. Gard. 64:642.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cd9ea36-6b84-5279-9cc8-8a3f525d1c1f','','','Select extra-tropical plants readily eligible for industrial culture... 138.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d395966-a4ba-5415-a184-e7a58144b323','','','Bull. Jard. Bot. État Bruxelles 22:298.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('598168e7-940b-53c4-b078-ab9096ab6f90','','','Notul. Syst. (Paris) 6:70.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2979160c-91c3-5840-9d07-9251870da754','','','W. T. Thiselton-Dyer, Fl. cap. 5(1):535.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8faf3922-7300-529c-bc00-7c9f47a6b979','','','H. Schinz & R. Keller, Fl. Schweiz ed. 4, 1:791.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4f026f8-70fb-5b2c-8ce9-92b718ec3b65','','','Prodr. syst. Aroid. 192.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d68223c-aba3-513a-937a-443bfbf24fa6','','','Mem. Soc. Sci. Nat. Maroc 26:22.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bff9c7c9-4610-588d-984f-8eda0c2f3ebb','','','Spisok Rast. Gerb. Russk. Fl. Bot. Muz. Imp. Acad. Nauk 6:166.  1908 (Sched. herb. fl. ross.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f882bed1-ea77-584f-a3aa-7242ea8d5426','','','Muhlenbergia 1:58.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3350828-9e01-5eb3-9733-b18037c56da5','','','Bol. Soc. Aragonesa Ci. Nat. 2:68.  1903 Mar "<I>Ibañezi</I>" (F. de P. Jiménez Munuera, Mem. Soc. Esp. Hist. Nat. 2:103.  1903 May "<I>Ibanyenzii</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bac18c1e-5da6-5ca6-94ac-7520c5f465fd','','','Fl. bor.-amer. 2:41.  1803 "<I>pulverulentum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6aa599ac-233c-59d8-9c35-992e547d7084','','','Sp. pl. 2:823.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8261ca04-7ea2-5017-b6a6-f131d23530c3','','','Linnaea 21:586.  1848 "<I>texanum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da87da70-a06d-5f0a-b537-ec48e019411b','','','Anales Univ. Chile, I, Mem. Ci. Lit. 123:371.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5f8382c-67af-5349-a13f-3229749ec432','','','Telopea 6:584.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb0a0fa9-7412-5f35-bd3e-eab60f759466','','','Beschr. Riedgras. 1:65.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74cec0ce-c076-5d47-8730-5538ba3a455f','','','Repert. Spec. Nov. Regni Veg. Sonderbeih. C t. 72.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c536373-b79c-542f-967f-ac5265aa4cbe','','','Martens, Gartenbohnen t. 3, fig. 11.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce78ca54-3929-5ca9-98fa-4e93745c7d4b','','','Muelleria 6:197.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9c6e87d-0550-517f-84b7-717307b97d7e','','','Symb. sin. 7:391.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cd12953-7627-57e1-abc5-1ec8afe10487','','','Guihaia 2:3.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4177dc2-179b-526c-8c11-f163d99ad831','','','Sp. pl. 2:899.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40c760d8-25a9-5491-b26a-80e429fc4201','','','Canad. J. Bot. 43:1434.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33be064e-4c95-533a-b2cc-86006673131d','','','Fragm. 9:92.  1875 "<I>Alphandi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00e62adc-2dd9-51da-aa6f-51252fe2cc70','','','J. Proc. Linn. Soc., Bot. 1:41.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddb4f131-a0ae-53f4-81c9-5a5351da3675','','','Garden 40:442.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8afe53e-cf1e-56a7-a4a5-5bdde5b83f29','','','Mem. New York Bot. Gard. 35:600.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c183c337-11b3-5440-9499-cef82644fdc5','','','G. Bentham & J. D. Hooker, Gen. pl. 1:566.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('449de73c-2fc9-55d5-bd2c-e65efb00038e','','','Fl. jap. 2:38, t. 121.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('133b4e32-1b55-5f6a-8247-9dcfe4066c91','','','Phytologia 26:177.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca023dc6-a0e7-5f79-a872-b7b5c86ffa30','','','Bot. Mag. (Tokyo) 40:163.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0bfb983-db45-57c9-8248-43e4253c369f','','','Bot. Zhurn. (Moscow & Leningrad) 70:784.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4af56f7-da84-5ca0-91db-01e5e06961c8','','','Bot. Mag. 90: sub t. 5477.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71f0a07c-090e-59c3-8a53-f581dfbced6a','','','Acta Phytotax. Geobot. 5:212.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87b10b6d-104b-5b9a-9768-a6e32ee0358b','','','C. F. P. von Martius, Fl. bras. 7:102.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ed295b9-d924-5d85-bb2b-0e844a3e4242','','','Taxon 35(3):556.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13ce5e44-a821-50ee-8381-1b513de8aa0c','','','Enum. Myrt. bras. 28.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19443ee5-8f4b-5bf7-bf27-8a534a8b5f52','','','J. Bot. 1:207.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff8ced17-b1e1-52b3-865a-411724627272','','','Proc. Amer. Acad. Arts 7:189.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8750309f-d758-5a2c-a3d9-44caed548b2a','','','Rhodora 30:207.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4d6f5e1-a226-5186-8468-7aa6faa15574','','','Notizbl. Bot. Gart. Berlin-Dahlem 9:280.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('823e0ce5-59a0-50b7-a733-a280b6ae46f3','','','Fl. reipubl. popularis sin. 14:154.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('335a91bb-5297-57c8-9b66-f316a38aca88','','','Enum. pl. 2:139.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2687171c-c67c-5a6c-960f-2e975bdb1319','','','Pharm. J. Trans. 11:445.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c69d24b4-68b4-5276-b564-d0be05c183dc','','','Fl. lusit. 1:31.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3210d072-e87c-586c-b7c7-938294f8d1cf','','','Bull. Torrey Bot. Club 24:493.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('449f1390-9b6c-5e91-ab31-e303a99072ac','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 3:228, t. 1, fig. IV.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21116742-c32d-59a0-8b44-0147c2bc7d9d','','','N. Amer. fl. 24:106.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fce7b6d-a35e-5143-9e07-824cd3dc3fb2','','','I. B. Balfour, Notes Roy. Bot. Gard. Edinburgh 9:191.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8323411-1361-5485-8fa6-b5aa7b5bb302','','','Ill. dict. gard. 2:460.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f70a5b1-c9fc-5612-aa66-59757a642dfc','','','J. B. A. P. M. de Lamarck, Encycl. 3:567.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32d6b629-3305-5fef-95cf-2f4bb095931d','','','Ann. Roy. Bot. Gard. (Peradeniya) 11:204.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1caa25fc-d677-5589-8a22-f14742578c92','','','Bot. Mag. 58: t. 3044.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e022552-7772-5cfd-b3bc-1347ecdf2e92','','','Rhodora 6:226.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55fffc30-11fd-5083-84c2-0bb74bbf17f0','','','Voy. Uranie 412.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('681055a6-012a-52d1-947a-4da466be996c','','','Cathaya 3:24.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2ab43d4-cfd6-5a0f-b6cf-6c5061242ddc','','','Repert. Spec. Nov. Regni Veg. Beih. 30(2):127.  1929 (Prodr. fl. penins. Balcan.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05d7a783-25ba-5eef-acd5-9cba609ae1c8','','','Tea Sci. Res. J. (China) 1983:16.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26b34357-cdea-5a72-a68c-fc7a4634f439','','','Methodus 503.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d3637f0-3acd-5f17-af46-30ddcbf35f23','','','Sp. pl. ed. 2, 1:422.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab579e6a-d23e-5f8d-a745-ea2430f2a3ff','','','R. Wight, Contr. bot. India 5.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdcd2f92-5a40-5bec-b399-413b75647ccc','','','Nuytsia 4:232.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd52f19e-a148-530b-9a39-f443296ba697','','','C. F. P. von Martius, Fl. bras. 11(1):73.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('793214ca-33fe-5bc6-bf34-ead2e3cf14c7','','','Oesterr. Bot. Wochenbl. 7:197.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b46d710-24c3-526c-be48-8fb927d1a681','','','Bull. Soc. Imp. Naturalistes Moscou 31(1):226.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83a1af7d-a356-5668-9fc7-84b6af84a4f3','','','Bot. Jahrb. Syst. 29:478.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59e17692-fef9-5427-a570-d3e5ad1cbe1d','','','Choix pl.  t. 9.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8490d0a1-8d5a-5065-8203-214338ed0354','','','Mitth. Thüring. Bot. Vereins 23:17.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6db3d948-8008-5235-a798-9f875aa76d8d','','','Linnaea 30:66.  1859-1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eee86c5d-562c-57f2-b4b6-efcaa03bf98b','','','J. Bot. 78:252.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fbeda50-e317-50fa-af18-8b4762bcbebc','','','Linnaea 5:247.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10c684fe-b627-5410-baaf-06acf57156f8','','','Hooker''s Icon. Pl. 23: t. 2250.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8cc471b-ffaf-554c-b92a-d1c9e33ed20c','','','D. Oliver, Fl. trop. Afr. 2:526.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aff674e8-0949-55f4-b71d-40d02b4b3d36','','','Enum. hort. berol. alt. 1:377.  1821 "<I>striata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bc1421c-acda-5ea2-b13d-5bff8c0d948d','','','C. F. von Ledebour, Fl. altaic. 3:55.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b29f863d-8fa8-5aeb-aca5-9883e75c0c27','','','A. L. P. P. de Candolle, Prodr. 17:241.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a06538f-0c38-5a6f-840d-68165b3a7d51','','','Kakteen And. Sukk. 44:2.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bd70351-9b01-58d8-8f4f-5495c393bcd2','','','Kew Bull. 17:448.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6aabadfa-16fb-5e13-bbe9-0206982b6c87','','','Lloydia 1:101.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70a99c93-fa64-5fbf-871a-d99230cfc3c2','','','Proc. Amer. Acad. Arts 1:49.  1846 Dec - 1847 Jan ("1848")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ea413fa-1421-5392-99fd-83ec47a5ba3e','','','Gard. dict. ed. 8: <I>Senna</I> no. 2.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f21c443a-3271-533d-8ba6-5aebaa4cf108','','','Sp. pl. 2(2):1260.  1799, nom. utique rej. "<I>Nelumbium pentapetalum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cfff241-2cad-52f9-bf57-776fa674fb8f','','','Repert. Spec. Nov. Regni Veg. 6:101.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3db70e4-e9a5-5e23-9d51-9812c5689415','','','Bull. Misc. Inform. Kew 1932:446.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4023bc6-ff64-5d54-b1bd-c4f6c482484e','','','Mem. New York Bot. Gard. 74(1):83.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('289ccf60-52d8-5313-913c-01d375204412','','','Bol. Soc. Brot. sér. 2, 39:102.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2923711d-fe88-5411-a329-93a9a060fa01','','','J. Jap. Bot. 1:7.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ad44181-4670-5bcc-ad1f-a8aec16f7b8f','','','Bull. Torrey Bot. Club 27:615.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62fde4c6-6d3a-57c3-b0cc-68783099c734','','','Sp. pl. 1:301.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11dffaec-3662-53a6-9ffa-edd85883b70c','','','Voy. Barbarie 2:100.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7004653b-3b06-5661-9eb2-a3e567dd2480','','','Madroño 7:112.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('064d8be5-7726-57d7-906b-38ec7c84a547','','','Contr. U.S. Natl. Herb. 3:565, t. 26.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2435438-5da0-5e6f-8e4f-4c97c876eae0','','','J. Torrey in W. H. Emory, Rep. U.S. Mex. bound. 2(1):90.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdc7f5b8-10e1-5b89-a637-088881bb495a','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk. S.S.S.R. 8:271.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dadb4e6c-0446-507c-8f61-0fdc785f8ca7','','','Gram. panic. 85.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b25e40d1-1ae4-5dec-8b73-b11328927b63','','','Syn. fl. germ. helv. 644.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d61a5ccc-8d65-57e7-aa52-96dd57c16cf7','','','Pl. hort. schoenbr. 2:47.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d86c2ee-5109-52e9-9e34-6b559b7a8664','','','Darwiniana 11:263, fig. 3-6.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c227c2a8-5c82-5138-9ca3-ec02254080b5','','','Forest fl. Port. E. Afr. 57.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47d1438b-755d-58d8-b766-5ff999e1d0ac','','','Bull. Herb. Boissier 7(app. II):324.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3da08f9-924d-5472-b505-bca039b8f973','','','C. F. P. von Martius, Fl. bras. 3(3):476.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8eac9ac7-5304-5305-9d1c-bcfe6d0c6a41','','','Bull. Soc. Imp. Naturalistes Moscou 41(1):458.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04bca662-3c2f-5f23-ad55-96787dd86d4c','','','Engl. bot. ed. 3[B], 2:191.  1864 (C. H. Persoon, Syn. pl. 2:234.  1806 "β <I>prostratum</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c6f2e91-c456-5f9e-926c-5147bb7a81f6','','','Novosti Sist. Vyssh. Rast. 7:62.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('401720bb-037c-55f1-8cb6-0c4ee45569fd','','','Fl. Steiermark 1:436.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7e29b16-2a27-56e0-8d62-d7be398ee0d0','','','Bot. Jahrb. Syst. 40:41.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e24fd60-b58b-5c4c-8ced-c1911c1b21a9','','','Mem. New York Bot. Gard. 35:143.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b67f855f-3f8b-5623-8356-340fe128bfb6','','','Ann. Sci. Nat., Bot. sér. 3, 2:122.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7e96f17-ad99-59f0-85d0-84ba820c258f','','','J. Jap. Bot. 93:115.  2018','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fd5774d-96df-5af2-9ed7-9bb0c4553e7b','','','Acta Phytotax. Geobot. 18:126.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0615925-5f69-52aa-82c2-80f1587df657','','','J. Proc. Linn. Soc., Bot. 2:168.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57817644-f65e-5426-9da4-c8d03b521551','','','Cat. sem. spor. hort. bot. Univ. Imp. Tokyo 31, no. 909.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43b0bed6-6213-5454-9d80-f047efa9cac4','','','Acta Bot. Indica 13:283, t. 1-9.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08a38370-5d99-53f1-a625-a604c606ea69','','','Tea Sci. Res. J. (China) 1983:11.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14ad78f4-fe40-55e7-a50a-e94fac4fc1d7','','','J. S. African Bot. 35:19.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b08d4ff6-0889-5fac-9cf0-3b2cbb1cdb9d','','','Nat. Hist. Sci. 1:4.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1064c1dd-5875-5e2a-9d08-f9901a0f00f3','','','J. G. C. Lehmann, Pl. Preiss. 1:644.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('febf1a8d-da8b-5262-859e-e83b9d5c29aa','','','Handb. Conif. 13.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfd4265d-baf2-5eac-9e35-11ff446bdf52','','','Bull. Fan Mem. Inst. Biol. ser. 2, 1:119.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f33c641-a255-5eb6-ac23-c36b37c4ee42','','','Novon 7:85.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47a39867-182c-5d72-aad5-c5a768d8d1a0','','','Fl. jap. (Engl. ed.) 600.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('140e3349-0152-535b-9632-c42fb1ca41c4','','','Fl. Alpes marit. 2:106.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fed9cd4-5784-585a-a481-b3b2abbbb71e','','','Hort. brit. ed. 1:407.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a63ca73b-dcc2-5aa5-a3db-d6b336c26430','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 9:513.  1885 (E. Regel, Gartenflora 34:335.  1885)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7bf20ff-89d4-549f-b018-71d751b33ae7','','','Bull. Misc. Inform. Kew 1907:55.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36548f32-9439-5f85-9fb4-041f15b5d6c6','','','Proc. Acad. Nat. Sci. Philadelphia 1863[15]:68.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('372acf0a-4703-5f3c-9532-05d21234ae1b','','','Proc. Amer. Acad. Arts 42:542.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1582da2-f13b-526d-8817-88bdec7660eb','','','Florist & pomol. 49.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('414389d3-2542-5037-878c-cdc53dc258c8','','','Abh. Königl. Böhm. Ges. Wiss. ser. 5, 5:326.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7896036c-c7b4-51dc-a611-7c9f9db3f2f7','','','Fl. cochinch. 1:199.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('716b55e3-6bb8-577d-8d29-e29467c06b5b','','','Sp. pl. 2:821.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5766ba3e-a5fd-56b2-b18b-965bb3757967','','','J. Bot. (Schrader) 1800(2):67.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('823a86c0-8d70-529c-8202-65224f501750','','','Gard. Chron. ser. 3, 3:554.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3880ce28-cdcf-5bc0-b6b5-ae2466001499','','','Revista Acad. Colomb. Ci. Exact. 8:319.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a9dbc7c-2b55-52f2-987a-03d26d5373b7','','','Nyt Mag. Naturvidensk. 52:254.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('509b41d1-083d-5c32-861b-d590ebc25f9e','','','Icon. fl. germ. helv. 2:13.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d24780df-9640-5df3-aef2-9fddd0b244a1','','','Fl. Brit. India 2:314.  1878 (Steud., Nomencl. bot. ed. 2, 2:404.  1841, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62bd16cb-b726-5c83-a27d-659744e88296','','','Bambusées 23.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('562cf088-48c3-517a-8631-b205926dc5e1','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 8:647.  late 1884-1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c5332b9-aed5-57e9-82ff-22faaf916d36','','','Ginkgoana 1:290.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fefbadd-5338-5bbe-8e5b-3220126765cf','','','J. Bot. (Desvaux) 2:358.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1033aeb8-ccab-52fe-852c-ff443dbfc81d','','','Bull. Bot. Res., Harbin 17:28.  1997 "<I>aristuglumus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66e384de-eed7-56c7-8816-aabdb6ee1dc0','','','PhytoKeys 167:69.  2020','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0971cda1-3dc7-5b7b-88a5-71a54b3d51ce','','','Cact. Succ. J. (Los Angeles) 24:107.  1952 "<I>ausiensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de90b9b9-8fdd-55d5-895c-0ddfd0c3122b','','','Contr. U.S. Natl. Herb. 16:100.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c9e6101-7771-5730-997b-857478ae56b9','','','Flora 21(2, Beibl.):50.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38c102f2-e7b3-5a3a-a70d-d8d7a69f91b8','','','Ill. Hort. 10(Misc.):80.  1863 "<I>hookerii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02b85216-2ff1-530e-9cf7-b7e31f58f173','','','Nuovo Giorn. Bot. Ital. 3:187.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4f14a94-bad2-5daa-a7d9-a91745b92b98','','','Bot. Mag. (Tokyo) 11:82.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c524c16-bb9e-5640-b0d5-8c2f0b579298','','','Rev. Hort. (Paris) 82:198.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('933c30e0-8cf1-5c4f-9310-c7e55b129828','','','Bull. Soc. Bot. France 66:217.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc633221-3736-5e46-933c-c18e33633e5c','','','Index sem. hort. acclim. pl. Arautap. 58.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0f2b201-566f-5cfe-9e88-821a2903c047','','','Bot. Zhurn. (Moscow & Leningrad) 72:35.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59a698ad-29b3-5cd5-8a9f-bdc3ffae77f9','','','Anales Univ. Chile, I, Mem. Ci. Lit. 93:161.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73de4e6b-ddb9-5d0f-848a-eb33d1386c91','','','Nomencl. bot. ed. 2, 1:567.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3083a512-a344-5bf4-96ed-784a35ab9774','','','Man. s.e. fl. 1231.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d6dbd2f-b4b1-548d-ac2b-1301d826dd19','','','Orchadian 13:494.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a26fc35-a09b-527b-b3ec-93ad76e34aaa','','','Bull. Géogr. Bot. 21:211.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d4d61e8-d70b-58d5-a307-d358e391dbc8','','','Intr. nat. syst. bot. ed. 2. 439.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('657c2577-506b-5e5b-9961-96811ae0f40a','','','Symb. fl. argent. 258.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0cba6da-414f-5f12-955b-a25a350660b9','','','Bull. Soc. Imp. Naturalistes Moscou 21(2):579.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2e197b3-cc72-524c-9790-4af7d8e1090f','','','Fl. orient. 1:512.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a1e34af-606b-52b7-aa33-691e2cdb27e2','','','Pl. david. 1:65.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad51908e-ea20-5999-8365-66bf853e28c9','','','Abh. Königl. Ges. Wiss. Göttingen 24:86.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a5b91db-4d6d-5132-91de-1a22dbc8a90e','','','Symb. antill. 2:276.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a574d38-c9f9-5947-8ff8-52ef779f741f','','','Hort. kew. 1:434.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('859a49c1-a6b0-5c98-add0-a0dfb1d1d846','','','N. Amer. fl. 23:134.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d833926c-2e4d-5cbd-a5cc-e8dc0fc6cd49','','','Cact. Succ. J. (Los Angeles) 27:171.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('caae921b-5614-55ba-91ec-7390632be0ef','','','P. F. A. Ascherson & K. O. R. P. P. Graebner, Syn. Mitteleur. Fl. 2:693.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1487361d-02b8-51dd-b422-d02ea8ab2101','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1852:72.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('601b2666-b8a8-5f69-9e40-7bf808d67f2f','','','Syst. veg. 3:525.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cc597ac-f59a-51db-b257-85e0579acdff','','','Gard. dict. ed. 8: <I>Cydonia</I> no. 1.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d01e2054-91c8-51c5-b087-3db814f07ae5','','','C. F. P. von Martius, Fl. bras. 3(2):424.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7aa38759-fd72-5597-b8a5-488b3eaad573','','','Bot. Mag. (Tokyo) 44:98.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ba4f376-caa4-5278-95a1-7e9f59fd9040','','','Fl. taur.-caucas. 3:81.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5795875-9f63-5b1f-8a3e-7cf7fd674306','','','Linnaea 24:64.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1ee0c28-7c13-5399-8ab2-36de79f02c91','','','Gen. sp. orchid. pl. 143.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7359141-4ac1-54fb-b491-21f37abc7819','','','Oesterr. Bot. Z. 47:96.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('241f3be8-e237-5b7b-865e-2e44dde2a816','','','Bot. Zhurn. (Moscow & Leningrad) 33:583.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('942acf73-73f2-5b8f-896e-ca350d33e699','','','Bot. Gaz. 67:230.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19d4b996-cca5-53db-8602-26cbafb29b9a','','','Monog. Anonac. 82.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f3c9ba1-6e0b-5bcf-b845-c25708ff32fa','','','Sp. pl. ed. 2, 2:1318.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9106275d-e921-5f30-9821-60b8061ef23a','','','R. F. Hohenacker, Pl. Pers. Austr. 639.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d5f5c87-c19a-588c-83a9-c6e551e495ff','','','Succulenta (Netherlands) 38:76.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53d7473d-def2-5e13-aebe-2ff6f76a2e5a','','','R. Sweet, Brit. fl. gard. ser. 2, 3(= 6): t. 265.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('968b03b8-3e13-57f2-b1b4-4b08b5e27fa0','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 9:898.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a52685b-a98e-568f-8a77-03475521268d','','','Geraniaceae 2: t. 101.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e9e7b90-b12f-519c-9ee9-921072839cad','','','Miss. Em. Laurent 122.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02ba34ff-3a60-512f-a679-0b8dd5020680','','','Bot. Mag. 10: t. 352.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0916679-a4a3-534c-9e44-61e25c055d7f','','','Kew Bull. 25:215.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51a72451-aef3-5e17-8077-9096033cfa12','','','Indian Forester 99:100.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b4a09e9-cf55-557a-b14e-42175e742a24','','','J. Hutchinson & J. M. Dalziel, Fl. W. trop. Afr. 2:352.  1936 [Bull. Misc. Inform. Kew 1939:245.  1939]','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7044d1c8-174d-596f-b6b6-e9e549fa41ff','','','D. Prain, Fl. trop. Afr. 6(2):192.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2c01d67-355e-5e00-8d0f-08ccce2e803e','','','Monogr. Campan. 351.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('726518f8-e7ac-5b9a-9887-aab60a256e79','','','Icon. pl. rar. 3: t. 548.  1789 Mar ("1786-1793"); Collectanea 2:352.  1789 Apr ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aec52bf4-4362-5436-8b27-136a2e76658b','','','Darwiniana 25:204.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc87ecf7-dcdb-546f-ab9c-53c2564669f9','','','S. Watson et al., Botany [fortieth parallel] 389.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('079d3936-db86-51bd-befd-5878874bfd49','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 11:9.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c75d0de4-f022-5cf8-a2c4-3e2e633140e0','','','J. Proc. Linn. Soc., Bot. 4(suppl.):91.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('160b9a7f-ca90-529b-9d89-f1b1db9e160e','','','Prodr. Fl. Böhmen 270.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('485a82bb-2ad9-5f29-805b-842f0998fbea','','','J. Arnold Arbor. 63:282.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56c1de76-d47c-540d-8e6d-e32602f9d96f','','','Bull. Jard. Bot. Buitenzorg sér. 3, 7:126.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b28a803-1a43-5791-bb76-97475864831a','','','Contr. Biol. Lab. Sci. Soc. China, Bot. Ser. 7(6):175.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('969c55f5-8d03-5e61-a6a7-87f6fe0f1d35','','','J. Proc. Linn. Soc., Bot. 7:186.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92961fcd-ff2d-5963-9c35-8077e4539c59','','','Formosan trees 428.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('783050f1-7e1e-5888-a217-c8eeb79e42f3','','','J. Acad. Nat. Sci. Philadelphia 7:67.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90484a52-4eda-50a1-86b4-efc203123f15','','','Nov. gen. sp. pl. 3:22.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e650295-ff30-5a3e-9c4e-98c9f73744c8','','','Sp. pl. 1:215.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43fa0dcc-961b-5d35-8a18-63309d15cd8c','','','Ann. Mus. Bot. Lugduno-Batavi 2:69.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74f324e7-5d3e-50c3-b3b9-57d1ec14286c','','','Syst. nat. ed. 10, 2:1242.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4136d741-7c41-5e9b-bc6e-1e0125ecd1de','','','Kew Bull. 19:215, t. 1.  1965 "<I>aëtheocarpa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a18961f-a236-552d-b085-381a21ec31a9','','','Icon. 3:30, t. 259.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eea35dcd-27c0-5328-9ee0-76215a05e34f','','','R. Roland-Gosselin, Bull. Mens. Soc. Centr. Agric. Hort. Acclim. Nice Alpes Maritimes 44:34.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d84254b7-19f0-5458-965b-acc26df1154c','','','Bull. Soc. Imp. Naturalistes Moscou 40(2):109.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74df8602-ff12-5a7c-a5bf-cec42692c955','','','Bot. Mus. Leafl. 1:10.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3723d060-dbc4-5785-9bca-f09dcccbece3','','','Revis. gen. pl. 1:212.  1891 (non Baker 1876)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3eed82b4-b869-5156-a5ce-2ee58f693d36','','','Proc. Amer. Acad. Arts 17:352.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f73cb81-ba08-57c8-8d6d-fe1c775b3b46','','','Rev. Hort. (Paris) 1861:349, t. 84.  1861 "<I>grandiflora</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa347042-8f96-59bc-b9fa-3cd8b8db405c','','','Cent. pl. II:18.  1756 (Amoen. acad. 4:315.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f96b62b-ee0d-53a8-b686-70512e41c579','','','Bull. Jard. Bot. Buitenzorg sér. 2, 9:31.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('639fa728-59bb-5c62-a8e2-6bbc0460ecbd','','','Candollea 57:313.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb1850dd-69a2-5f2f-8190-a45ec7fd5296','','','J. Bot. 55:41.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7819b4cf-0526-5057-99c9-859eaef44641','','','A. L. P. P. de Candolle, Prodr. 17:158.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a480b850-d45a-53e2-932e-31039273c2e3','','','Cat. pl. ed. 1813, 31.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d13eec29-51b9-513d-b701-9ad4eef78fe0','','','Smithsonian Misc. Collect. 126(1):31, t. 65.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('538af607-fdfe-579d-a979-b2df4dc274fa','','','Proc. Amer. Acad. Arts 17:375.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbd95943-f2f4-55db-8403-f0a42cc92a92','','','J. Bot. 32:102.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f658c292-7427-51ab-82a5-450b566d8e47','','','Trudy Prikl. Bot. Selekts. 13(1):225.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5bf3987-f6f0-5ee7-a30b-1f7ad609a24f','','','Bull. Soc. Bot. France 96:170.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5797652b-d80b-57c8-9767-21fdd709a88a','','','Sp. pl. 1:74.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4b6dc44-ff70-5624-8db2-e046dc72c3d1','','','Prodr. 5:531.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15494f6b-9525-501f-98fd-dcf792d43b25','','','Fl. Congo Belg. 5:353; Bol. Soc. Brot. sér. 2, 28:100.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03e06493-2633-5977-b12f-6be5af5938fd','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 7:107.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0aa76ee-2841-5741-91f0-f4d75d9347a1','','','Bot. J. Linn. Soc. 68:280.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea491d38-0c06-500a-be74-f67806a9934b','','','Fl. cochinch. 2:611.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b792008-8bab-5177-b3f1-9ebfa10e51b0','','','Phytologia 25:281.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5597233-6d45-5ba6-95c1-1b4ae0b9b18e','','','Fl. N. Amer. 2:47.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46df2a3b-ae93-5070-98ca-43db400554d9','','','Index sem. hort. bot. berol. 1872(app.):3.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('894b7eac-b63b-5cf3-b4be-aa62e0b3cdd0','','','O. Stapf & C. E. Hubbard in D. Prain, Fl. trop. Afr. 9:799.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b723ff5b-d177-55b1-96dd-d318bb556dc1','','','V. L. Komarov, Fl. URSS 10:71.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02336a71-3cb3-52a3-a9b2-bd0f57767c62','','','Brittonia 42:279, fig. 1.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ec09c78-2b46-5a6a-9f87-62878de49132','','','Aliso 4:103.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('014b60d6-fe63-5d1a-be4d-3c10bc439f24','','','Fl. Amer. sept. 2:478.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61ff3ec9-d70f-5bc9-acbc-08fc76610dd4','','','Siskin, ed., Vol. Sci. Works Leningrad 1941-1943:101.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd866ce2-ba73-5a28-9dc1-f54196fac8d7','','','Fruct. sem. pl. 2:404.  1791 "<I>Elichrysum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7df62aee-e9e8-5dd6-adbb-7dfb048b7e52','','','Die Gurken 35, 43, 57.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('149e296f-bb8a-56ed-9544-fcb4b1d55a40','','','Proc. Biol. Soc. Washington 55:112.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74e3db63-7281-5bc0-98aa-93e0b3856d93','','','T. L. Mitchell, J. exped. trop. Australia 218.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86140505-c1ee-5762-9cce-9c6fcf4918df','','','Arbor. frutic. brit. 3:1674.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c35f3a0-b54a-5937-81a0-e708276b1997','','','Mem. New York Bot. Gard. 65:675.  1991 (Bull. Soc. Bot. France 53(Mém. 3b):186.  1906, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('336e4382-fe3a-56ce-afc3-f2f8ec8151b2','','','Rheedia 4(2):133.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('468a0cbb-426d-5f80-a7a5-e450da602548','','','Beitr. Naturk. 6:98.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84205093-7ece-5c33-a572-e6c5be06534a','','','Enum. pl. nov. 1:9.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb48cb81-5fab-5655-82ce-cb36af185ec7','','','Fl. carol. 174.  1788 (non L. 1753)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('867f6e89-f282-560f-bada-d2a716eeb0bb','','','Oesterr. Bot. Z. 71:243.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b80db5d5-ec7b-53bc-9a54-845647dc10a3','','','Pl. nouv. Amér. 168, t. 98.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12eed4d1-1887-52f3-a03f-702a00cc6d1a','','','Revista Mus. La Plata, Secc. Bot. 6:229.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1ea6586-bde2-5494-8a6f-a4580c278b34','','','Fl. jap. 1:64, t. 27.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67c382fe-10a7-5959-b908-7219add8a624','','','Elench. pl. nov. 38.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('218190a6-c216-5ca8-aaed-20a69d37935f','','','Arch. Biol. Vég. Pure Appl. 1:58.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0115ddcd-a1d2-5689-97f5-81c3fa958ed3','','','Bot. Mag. (Tokyo) 33:5.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e94097a7-3715-5288-932e-cf7e2d865e58','','','Adumbr. pl. hort. hal. 1.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84f9863f-f48c-5abc-a698-a1e4ae7bed3e','','','Fl. Hongk. 59.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1be26dc8-0199-56b5-91aa-fb958f7575df','','','Hooker''s Icon. Pl. 19: t. 1863.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88e2bc8c-27d8-5d7c-a976-76b4db2b12f2','','','J. Jap. Bot. 62:357.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1b0b80d-8d08-5741-b203-67cd670f5c9e','','','L. H. Bailey, Cycl. Amer. hort. 3:1147.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2efd024d-529c-5a59-bd36-a29db71ee665','','','Ann. Sci. Agron. Franç. Étrangère 28:179.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a4ff764-adf1-501c-a0a2-1d9dd642bc7a','','','Contr. Gray Herb. 56:20.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6316f1a5-040e-5fd0-aefc-24c984814dd8','','','Rec. Bot. Surv. India 9:231.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa5fb196-5112-51b0-9e0a-a65c9f2deb94','','',' [plate] s.n.  Jun? 1788 (W. Aiton, Hort. kew. 1:285, t. 2.  1789)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19c730e8-c122-546e-917f-037f0f8a71da','','','Sp. pl. 1:542.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('133878fb-172c-517f-ac7d-f6f74aafce49','','','A. L. P. P. de Candolle, Prodr. 14(1):15.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ebad572-a0b5-58af-9a28-7c0971b71e2c','','','Trudy Prikl. Bot. 23(3):452, 463, fig. 23.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f691d95f-9fb0-5a49-8171-92b18dc599e6','','','Ann. New York Acad. Sci. 18:246.  1908 "<I>phillomega</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e49ca41-86eb-53d7-9ffe-294fe55b33df','','','Helios 10:27.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f28959c-04f7-5219-a436-8ab61b13869b','','','Doc. Jard. Bot. Atlántico 6:66.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('016ca4f6-56f8-5e7c-bd74-313cff561178','','','Bull. Misc. Inform. Kew 1908(10):445.  1908 "<I>mansoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfd077ca-d542-541e-af9e-34cb5d52ca08','','','Fl. austral. 2:300.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0180d45b-7cd1-5fb5-a44b-76fcdd19fb33','','','Prodr. 15(1):338.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1bdce4a-6de4-5c0a-a130-bb77329c8cbc','','','Adansonia sér. 2, 9:553.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81e3d91d-68fa-5032-8fa7-d451d63bb14f','','','Hawaii, Board Agric. Forest. Bot. Bull. 4:58.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('621c92f1-ced2-549f-af01-302d34052fed','','','S. Watson et al., Bot. California 2:96.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d85db0d4-141d-5bc7-9561-49f56fd3bba3','','','Brittonia 33:446.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90ceca91-8ea2-560c-b080-527aa7a69136','','','Contr. New South Wales Natl. Herb. 4:454.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9464370-ba1e-595d-b1fd-a1328f0efdf5','','','Contr. Inst. Bot. Natl. Acad. Peiping 3:465.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d88474c-b4b8-5d28-b14d-4baa587f7601','','','Webbia 13:165.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99f9a21a-e076-5218-9c20-53c1aec467ff','','','Abh. Königl. Ges. Wiss. Göttingen 19:107; Pl. lorentz. 59.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6077d95b-fcb4-5191-87d4-5b462cf14999','','','Rep. (Annual) Missouri Bot. Gard. 9:130.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a916236e-f4a4-5a63-b09c-19b85c38abb9','','','Mem. Torrey Bot. Club 5:291.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbee0015-6b43-52b7-a239-73f8a6ec7d02','','','Prim. fl. holsat 10.  1780','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('174ba0e4-1a9b-5757-a33b-221534f9698b','','','Pl. hartw. 377.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70971d9e-ade4-59db-81ca-8107949ecf26','','','Prodr. 5:258.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aafbfacf-9899-5c89-b874-11e30164f872','','','C. Wilkes, U.S. Expl. Exped., Phan. 15:508.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0173a4d-94f0-567c-bcce-5cd959cb6420','','','Abh. Königl. Ges. Wiss. Göttingen 24:249.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28c7b40e-484f-558b-b868-a3798d065fda','','','J. Arnold Arbor. 27:234.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce05776f-76f8-5681-b972-c567f963a5d0','','','Fl. germ. excurs. 873.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('101c9bcf-079c-5fe9-b03a-6e9e39b25d85','','','Enum. pl. 5:352.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f96faf00-cead-504b-95d0-3bf8a465b952','','','Zoë 5:191.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76b761de-c523-5951-bfde-de623a6515f6','','','Ann. Mus. Natl. Hist. Nat. 5:25, t. 1, fig. 1.  1804 "<I>sclareaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cd33bd8-e458-5a1c-8c57-0540d0b88516','','','Abh. Königl. Ges. Wiss. Göttingen 19:135; Pl. lorentz. 87.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('501685d0-1b15-534e-a60d-1b7623646185','','','W. H. Brewer et al., Bot. California 1:181.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('deb4724e-d65d-557e-b285-a13a2c38c3fe','','','Notes <I>Mesembrianthemum</I> 3:23.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1335404-ecb4-5b3d-aa8e-1437090bc5fe','','','Fl. antarct. 371, t. 131.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b9490d2-83ac-5759-ab7d-b32b0c3bbf0e','','','Observ. Compositae 127.  1817 (Trans. Linn. Soc. London 12:127.  1818)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6c183c3-4f33-52d6-b098-9c4ac617f719','','','Man. cult. trees 361.  1927, pro syn.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81695778-80e8-5937-ab6c-f239f9ac1ae7','','','Sp. pl. 2:752.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47344431-2fe5-570c-aea0-7a9a70ba7184','','','Syst. Bot. 39:70.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61115a71-857b-5786-8eaa-3dc074dd8c18','','','Edinburgh J. Bot. 48:57.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77caf599-5d38-5623-a99b-e11d1e282b46','','','Prodr. fl. nepal. 58.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93d61d8c-1bde-5f30-a93f-de9095d9d8e3','','','Fl. Amer. sept. 2:484.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d6703ea-f5b3-54b2-8c36-3e014c4eaf07','','','Enum. pl. Austral. occid. 3.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9036cf36-06a5-5f6d-93df-4b9857f3001c','','','Webbia 35:296.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb1683dc-fb3f-501d-a52a-a27edfed0e1c','','','Proc. Linn. Soc. New South Wales 24:298.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8540a38-e4df-513f-912f-07bfefdc7920','','','Rec. Bot. Surv. India 4:20.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3de4c43e-d653-5721-81cc-3080bd4119c8','','','J. Soc. Trop. Agric. 5:59.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d84db83-ae51-5153-b4df-88ea110dd15c','','','V. L. Komarov, Fl. URSS 2:436.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ee3340c-5aa1-5102-8b11-868fe70449fa','','','Brittonia 31:105.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3b86cb2-9daa-56f6-a4b1-9e2ec35de076','','','Proc. Amer. Acad. Arts 20:268.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb234ad9-e559-5d47-a664-baf79b32d108','','','Bull. Mus. Natl. Hist. Nat. 25:200.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0895a49a-5018-57ed-814e-22885a5ebb08','','','Adansonia 10:186.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6e20af5-7013-55ad-8198-1fab53574f8e','','','Sp. pl. 1:56.  1753 "<I>crusgalli</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16057a40-f402-5627-a64d-7e3da30d117a','','','Kulturpflanze 35:140.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2d407fa-c906-5a17-a4b2-961ecd3ef934','','','Fl. E. Himalaya 1:632, in adnot.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b10ad08-958e-50bf-897b-cef6642434d1','','','Trans. Linn. Soc. London 2:333.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3abf3911-1d8e-5cb1-bddf-1e1fa1a4d13b','','','H. G. A. Engler, Pflanzenr. IV. 236(Heft 9):354.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee95b533-f512-53c4-9ec5-edfc05078fab','','','I. B. Balfour, Notes Roy. Bot. Gard. Edinburgh 9:256.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7085518b-e1ae-587c-a6f6-9265e8d76da7','','','Hort. kew. 2:259.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e5e22e2-bcdc-5001-abe6-a6befa3fdc74','','','Abh. Königl. Ges. Wiss. Göttingen 19:136; Pl. lorentz. 88.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2de28d0f-f8b4-5b3f-9158-f4676841a3fa','','','Fund. Agrost. 133.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c1dd0bb-957c-5b25-af96-747937e55472','','','Field & Lab. 17:145.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('307df38a-4799-5d72-97bf-d34b5ff1a688','','','Beih. Bot. Centralbl., Abt. 2, 61(3):383.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf8b782d-040a-5e5c-9001-30cfa197babc','','','Bibliot. Ital. (Milan) 70:436.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('279d92c9-3e56-5eb1-9cad-3cfc40311741','','','Bot. Porto Rico 6:52.  1925 (Sci. Surv. Porto Rico & Virgin Isl.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03cc8184-2f9d-5248-b05a-6f7faa629978','','','H. Lecomte, Fl. Indo-Chine 3:1136.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8faf0a0-1ed1-520b-88d2-1e0565723abd','','','Fl. reipubl. popularis sin. 45(1):38.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f541da9-d9f0-5dc5-925e-a9ce04fb70b5','','','Contr. U.S. Natl. Herb. 22:666.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9e60731-8c67-5dac-a884-f30c761a691d','','','J. Bot. (Schrader) 1799(2,2):324.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22b40d8a-9c54-5c37-8446-2ca9758a462e','','','Fl. altaic. 3:338.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b656a799-be93-5303-b1d0-096a2c51101a','','','J. Bot. 16:84.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b1abf7d-25e4-587c-b4e1-4b9b8efa3f8d','','','Notes Roy. Bot. Gard. Edinburgh 10:188.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0028cbe1-6486-5052-8620-64d0b1927c44','','','Cycl. Amer. hort. 4:1689.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69020855-1a59-5cd3-83f2-eddb6765564d','','','Phytologia 19:189.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30fa4224-4b2e-5cdd-8827-d703c4cb1445','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 15(1):145.  1869 (Gen. Astragali)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('814552d6-d792-59ce-b5b6-f1a33d7dc18b','','','Sist. Bot. Dergisi 1:2.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ab6b6ce-24ab-558a-8b99-fd3f97213a28','','','A. C. H. Braun et al., App. gen. sp. nov. 10.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30f540ba-f421-58de-b2ff-212196d478c1','','','Trudy Prikl. Bot. 20:100.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c81212c-0d13-525e-ab03-fcb62e387881','','','Prodr. 4:396.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad45478d-32c8-5ce8-92be-fe1ff36e2292','','','Monogr. Taraxacum 35.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5814e8a-4d06-589d-ad09-26758febeb88','','','W. L. Wagner et al., Bishop Mus. Occas. Pap. 29:101.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e8014f7-6ed2-5a1b-aeb7-ffd249e9f984','','','Bull. Soc. Bot. Genève sér. 2, 1:371, 374, fig. 3.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a6c5ca1-addc-525a-a858-2c5381bb6c7e','','','A. A. Orlov, Kulturnaya Fl. SSSR 2:195.  1936, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ebdf3ea-3245-5787-84b9-ecf6b97a5d53','','','Gen. sp. Orchid. 1:41.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06b5e10e-c23c-5867-bbf3-ece325167157','','','Bot. Repos. 1: t. 54.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5b590d2-a65f-5f29-a719-1bfe3c6a989f','','','Sp. gram. stipac. 143.  1842 (Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 7,5(1-2):143.  1843)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba3e4f6d-3d34-5be8-b4ea-94570540502f','','','Anales Mus. Nac. Montevideo ser. 2. 1:14.  1904 "<I>arechavelatai</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7cdd8a2-04d4-53a6-b0ed-80cf69ffc18d','','','Revista Soc. Geogr. Cuba 4:40.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8b57419-de79-50e9-9962-a5d877d32e3b','','','Gard. Bull. Straits Settlem. ser. 3, 10:76.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8db4c284-28e6-53a5-b13c-85026d58940d','','','Fl. ins. austr. 55.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2a84f58-980f-5927-ba56-0a3390ce1f75','','','Bull. Herb. Boissier sér. 2, 2:760.  1902 "<I>F. krishnae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72db969f-8e00-501d-8cc7-7bf604ee0fdd','','','Bot. Mag. 98: t. 5983.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bd49503-3f03-514c-98ce-380d9456cae7','','','Mém. Soc. Phys. Genève 9:97.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf9f9022-fade-54b6-9822-65c6e4cbe2ac','','','Fl. ind. ed. 1832, 3:225.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cd49966-d06a-573b-bc27-e45d5abc680a','','','Syst. Bot. 35:852.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d58dfe5-aceb-5167-b375-0fc77dd90abe','','','Trudy Prikl. Bot. 5(2):102.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b4c2339-2a5c-5069-97c6-edc313b22487','','','Bol. Soc. Brot. 6:68.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68fff276-7c3c-575c-8f22-5126e5808d88','','','C. F. P. von Martius, Fl. bras. 6(4):318.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0795b0ca-8822-5faf-8915-e8b1f31a1ea3','','','Bull. Soc. Bot. France 32:271.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58e07676-c417-540e-bb23-e9cfa5de12af','','','Mém. Acad. Imp. Sci. St.-Pétersbourg, Sér. 6, Sci. Math. 2(3):300.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a2f0b0a-1f1a-5467-a8a7-beb48988d007','','','D. Oliver, Fl. trop. Afr. 2:85.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b899ee22-5c53-59aa-844e-e20fbd2699b2','','','Fl. Brit. India 2:334.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fab12f74-be4c-57b5-adff-6f8c5bb3d340','','','J. Donnell Smith, Bot. Gaz. 18:202.  1893 (non Kuntze 1879)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c3c2f23-561d-5126-aa14-e778ba3cb9bd','','','Ann. Sci. Nat., Bot. sér. 2, 2:353.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dccc4a59-ae1c-5821-9f33-a5ad85dbd3dc','','','Prodr. fl. Ind. orient. 176.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a7530b4-1367-59eb-930c-906f924c67c5','','','Bothalia 2:392.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c780f465-e2df-5bb8-baca-1067afa8b64d','','','Hooker''s Icon. Pl. 19: t. 1824.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0515eb1a-662a-5fbc-90fc-4b2f9f0dc266','','','Diss. 1:22, t. 3, fig. 10.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('947239a0-9a03-5d5a-8f5c-1037c04dd332','','','Gard. dict. ed. 8: <I>Colutea</I> no. 3.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4881592-1951-5a5c-b18c-63da0518d8ec','','','Bull. Acad. Roy. Sci. Bruxelles 10:136.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4b31e69-27fc-5db1-9919-5177625ed3b3','','','Trans. Hort. Soc. London 5:427.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbb7b936-a15d-5dc9-81c5-ee61cefcc2dc','','','Phytotaxa 218:214.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('589cdd5f-21af-526f-b8c0-d22786ebbd45','','','Acta Phytotax. Geobot. 17(3):84.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0c95edc-1988-5e1d-a54e-ad4fc552a2b3','','','Fl. taur.-caucas. 3:471.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7657ad73-0b07-5a18-b432-320bb8b9270f','','','J. D. Hooker, Fl. Brit. India 3:466.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8af74e17-0555-5203-a5ae-720520be3689','','','J. S. African Bot. 13:101.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb938f0d-701d-5382-8666-e295e011816c','','','Spisok Rast. Gerb. Russk. Fl. Bot. Muz. Rossijsk. Akad. Nauk 8:117.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebd5d089-0c5e-5197-8e49-c63df70d636d','','','Notes Roy. Bot. Gard. Edinburgh 5(24):106.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47af1fdd-c409-5bd9-88e2-873d9e38044d','','','Gefässbündel Farrn 18.  1847 (Abh. Königl. Böhm. Ges. Wiss. ser. 5, 5:326.  1848)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdcc2aeb-2206-5351-bea5-c0a7e55f3877','','','J. B. A. P. M. de Lamarck, Encycl. 4:529.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11c67993-7079-5fb4-9511-1149652d1887','','','Kakteen And. Sukk. 13:4.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ac46451-8a1d-55ef-b92c-ad976e487701','','','W. J. Bean, Bull. Misc. Inform. Kew 1920:344.  1920, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e0b6df3-dc25-5a34-ad1d-937abc09388a','','','J. Sibthorp & J. E. Smith, Fl. Graec. prodr. 1:71.  1806 "<I>Rottbollia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9fa53fe-1978-5cab-b3d3-45b69402c0f9','','','J. Sibthorp & J. Lindley, Fl. graec. 8:13, t. 718.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40931c5a-4a9f-500d-8257-8ef943c46b93','','','Hist. nat. <I>Solanum</I> 199.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8befbe26-e159-5118-a5ca-139e32a01671','','','Cat. hort. bot. bogor. 282.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c486f992-e661-5a55-9c35-b1f15d116b37','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1852:6.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('560710e0-ec8d-5b82-88c4-6e0c17670af9','','','Notes Roy. Bot. Gard. Edinburgh 21:126.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3341bf90-8332-564d-a538-971d28670dcb','','','Bull. Mens. Soc. Linn. Paris 2:1254.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c987692-10e9-5ef0-8cf5-7fbd7f481a93','','','Gard. dict. ed. 8: <I>Rosa</I> no. 10.  1768, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a901717d-3444-543b-8712-9c3443239364','','','Notizbl. Bot. Gart. Berlin-Dahlem 10:666.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e347a7a-79d1-5a09-a16f-5b0eab647513','','','Trans. Linn. Soc. London 10:380.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04f3a616-56a8-5bb4-94e5-bdce9196c2fe','','','Fl. W. trop. Afr. 1:227.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1152a569-df6f-551c-ada0-476d23bafb5d','','','Mant. pl. 1:33.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9861f82d-5155-5779-97ae-e742715b5848','','','Fl. oesterr. Kustenl. 2(2):357.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62499450-f638-5600-b46e-fbee1170da01','','','Fl. excurs. hafn. 45.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f0d7ffe-3432-5cb4-920b-809dcea4425f','','','Bot. Jahrb. Syst. 40:519.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('485ad49d-1655-5025-9957-315f3b60d95c','','','Bull. Torrey Bot. Club 26:591.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e841ca6-316b-574f-b4d0-5e3f2d052bdd','','','Brittonia 26:192.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7b9c336-5e5b-5a0b-a565-4288e6af6e3d','','','J. Bot. 50:166.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6bcc9a10-d6fb-59be-909a-6783fe48c3e0','','','Bull. Soc. Hist. Nat. Afrique N. 15:390.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c8b0054-ad95-5551-85bd-c96e7f41c3f1','','','Landw. Fl. 321.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a098d703-d385-593f-8d2a-96a4b476b899','','','Sp. pl. 1:20.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('483d6598-0ec7-561c-8dd8-1c07a8b838a5','','','Taxon 27:201.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22e8a400-289e-597e-aa0d-620fff49a19b','','','J. B. von Spix & C. F. P. von Martius, Reise Bras. 2:548.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6d5cbfc-e57f-5977-b922-b71b6359caa5','','','Fl. reipubl. popularis sin. 27:196.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cee0b6f-30bc-57a8-a6c7-a741ff8c1d65','','','Enum. pl. Jap. 1:121.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6208c574-7e7c-59bf-9b09-26dbdff6aad5','','','Man. pl. Oregon 721.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9204036f-1d41-50ea-92f3-b68030df4ceb','','','Prodr. pl. cap. 127.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0d91c28-9ac2-59c9-abab-645ae996371c','','','Diagn. pl. nov. mexic. 9.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3b1aced-c594-5d3f-82be-27ec198dee13','','','Pl. hartw. 11.  1839 (non Moench 1794)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ef035c5-02ea-546e-8e26-029109217603','','','Contr. U.S. Natl. Herb. 1:276.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b518c38c-2c7a-5fd0-a1e9-b3912880d1ed','','','Methodus 349.  1794, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79fe05d9-38ec-56b7-80de-c99452d6783c','','','Fl. austral. 2:389.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4f7793e-1884-5642-8889-82c2ae1a8c30','','','L. H. Bailey, Stand. cycl. hort. 3:1305.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4c8464b-b4e4-5b40-90d0-d337d58b165a','','','Hymenophyllaceae 108, 136.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e38cb8cf-0e95-5714-af9e-3ea600891755','','','Izv. Bot. Sada Akad. Nauk S.S.S.R. 30:215.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('216543df-0b0e-54b5-b134-60310b1c8490','','','Zap. Naucno-Prikl. Otd. Tiflissk. Bot. Sada 6:141.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82741da7-8a6c-5cd7-b584-e24a47c6129a','','','A. L. P. P. de Candolle, Prodr. 16(1):356.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6c3e7b3-8e5d-5b92-8e42-8e5899a4224e','','','Nov. Actorum Acad. Caes. Leop.-Carol. Nat. Cur. 19(suppl. 2):208.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3e859eb-5024-53bb-a555-aead57bc3e40','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3b):350.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a063387-fb7f-5377-8ed2-908307a49aac','','','Encycl. suppl. 5:361.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ac074fc-2bab-595a-9dae-79c521144763','','','Edinburgh J. Bot. 51:312.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06979119-9511-5a60-a1e2-eec483854d25','','','Prodr. fl. Ind. orient. 72.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42550f1e-0cbd-53ef-aeb0-57f39b4c7fa6','','','Biblioth. Bot. 4(Heft 19):180.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff7e743e-ffd2-5d51-9afa-2c0883ae0bfd','','','Mem. Inst. Oswaldo Cruz 20:113.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a21398e6-5393-55ce-86eb-51e03d3ffa4d','','','Bot. Gaz. 67:208.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79935801-21ae-5655-8e20-df78393a3898','','','Beih. Bot. Centralbl., Abt. 2, 22:117.  1907 "<I>pseudo-negundo</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a5c7adc-0bd0-5d3d-8c7a-bb6ce4ea700d','','','Prodr. pl. cap. 145.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d888b52-ffb5-545e-a4a7-587e68ee3446','','','Leafl. W. Bot. 5:148.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('daf2727d-e0aa-5318-93cc-2ae6112248e1','','','Verh. Bot. Vereins Prov. Brandenburg 26:171.  1885 (Monogr. <I>Clematis</I>)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('464143d1-ced3-555b-920a-a614510c540f','','','Bull. Torrey Bot. Club 20:137.  1893 "<I>Mandoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92bb9a90-3fb5-5385-92a7-3f1505ddee43','','','Fieldiana, Bot. 29:485.  1963, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1667a134-c622-5fa9-a135-7361c319620d','','','J. D. Hooker, Fl. Brit. India 3:457.  1882 "<I>pyrolaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b77d64b-1093-5fe0-8e13-c21f67134f8b','','','Sp. pl. 3(1):817.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3562f760-98c0-5ff3-9909-1437c8d0d94d','','','Hort. Beng. 46.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db8621e6-23b4-5202-9c1e-862ea8a77f75','','','Mant. 2:258.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcbefb08-d4d0-562c-b923-329ca6d17f01','','','Bot. Mag. 75: t. 4483.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26d3fdf1-da96-5308-a563-37b3ccec82a1','','','J. Proc. Linn. Soc., Bot. 3:145.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14106dec-2da1-533e-be24-07279f193354','','','J. Washington Acad. Sci. 14:47.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51898be8-869f-57aa-b79b-09f6cf333fd2','','','W. H. Emory, Not. Milit. Reconn. 145.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b5c5388-4b59-5000-a9fe-d2349451507b','','','Prodr. 102.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('209c3564-7eff-5c71-a608-a3cf0fb1f169','','','Fl. s.e. U.S. 896.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('193b3138-4a7b-5d11-a8d8-67bcfdf18baa','','','Icon. pl. Ind. orient. 3: t. 955.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6f48436-ecc9-5ea5-8397-e3f109914283','','','Syst. mat. med. bras. 31.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f69259d-b1b3-557f-aaa6-b7c97554e12b','','','Indian Forester 20:1.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c09cea3d-76e9-5b97-9ec1-53917979eec2','','','Kulturnaya Fl. SSSR 1:161.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7f4f896-82c2-5b53-b203-4bb69aaeccea','','','Stirp. rar. Sicilia 1:[9].  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb627067-5b02-50c3-a337-048b0f9de3fc','','','Bot. Zeitung, 2. Abt. 65:133.  1907 "<I>steinmanni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f55d6f98-b433-5dab-9d0b-294bc74a962e','','','Bot. Mag. (Tokyo) 26:15.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3418319-4185-5939-8738-d5e11442c682','','','Fl. nov.-zel. 2:337.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1ed5bbd-cb57-5be8-b0f9-2494f2c317f3','','','Trans. & Proc. Bot. Soc. Edinburgh 27:95.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70fc6140-4666-5e71-a62a-1f6212605ac6','','','Dalzell & A. Gibson, Bombay fl. 182.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('556fa0c6-1877-5e8b-b998-7329bcc57ba8','','','Nova fl. Portugal 1:551.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5eca6ca-4c18-5b14-8a7d-95a942af1cae','','','Acta Bot. Venez. 10:330-331.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6071850b-1427-599c-b129-11b35b8e0dda','','','New York Agric. Exp. Sta. Techn. Bull. 109:94.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00559057-33d2-5f78-8406-271b41acc476','','','J. Fac. Sci. Univ. Tokyo, Sect. 3, Bot. 5:366.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45ad3b0d-965a-52a8-af0d-a8e4c0279b9d','','','Acta Bot. Acad. Sci. Hung. 11(1-2):235.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('104aa39a-6018-5673-9daf-f3cc0f11c995','','','Trans. Linn. Soc. 6:342.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b943bb01-31bf-5d2c-b45b-3f244300b6d3','','','Adansonia sér. 3, 24:279, fig. 6.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('612f9029-e425-5fac-a7e0-a52d348456b4','','','Meded. Bot. Mus. Herb. Rijks Univ. Utrecht  52:61.  1939 (S. Amer. Papilion.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('848784ac-2706-5a8d-b2e5-7c756d21e4c6','','','J. A. Schultes & J. H. Schultes, Mant. 3:228.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd3da196-0ce7-5b5f-bfeb-7e03dcf6d2d4','','','Mem. Natl. Acad. Sci. 11:44, pl. 53, 116.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cd213e4-7b34-5267-bdd3-ca50ff5542a2','','','J. New York Bot. Gard. 20:26.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fc67a2f-10c1-5a24-8078-543a5381efd5','','','Erythea 3:13.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12c63bc6-e535-578b-b34b-eeb04ebf783f','','','Izv. Donsk. Inst. Sel''sk. Kohz. Melior. 9:47, 54, 58.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1430522d-a668-50a5-ab00-7d83a75a713f','','','Kulturnaya Fl. SSSR 1:133.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31057825-239f-5c54-859c-dc5143249f14','','','Notes Roy. Bot. Gard. Edinburgh 10:39.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9f7c19e-88b9-51e9-9626-13ccee5d18a5','','','Symb. antill. 4:195.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51202e70-343c-565f-bc65-68cb92f9550e','','','Schischkin, Fl. Yugo-Vostoka 6:181.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ada19b6d-02e6-522f-aeee-93662dc352ee','','','Bot. J. Linn. Soc. 183:582.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec6dc99a-e211-5291-8b06-1a33624c08b3','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 64:333.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13cc7f0c-ff28-5977-b2e1-f0c2b9d2962e','','','C. F. P. von Martius, Fl. bras. 1:126.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('545c1922-2fd0-535d-aca6-0e927fbe9506','','','Mem. New York Bot. Gard. 9:354, fig. 65A.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('feb71756-ab2c-5513-95ad-e027dbb07d4a','','','Enum. pl. 5:262.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3dac4cb-428c-517a-9704-d7fadb84c5b5','','','S. African J. Bot. 112:423.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca10d72e-cbec-5878-b21a-96bfbd938ecc','','','Ci. Florest. 23:420.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0267174a-6d23-5ea5-a2ad-647da4a54ebc','','','Enum. pl. 4:390.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aeee3f96-3ab8-5bcf-9f40-bd67fe1e69dc','','','Acta Helv. Phys.-Math. 7:129, t. 8.  1772','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d64964b-7868-58f1-8fad-32eafb0b6e82','','','Prodr. 77.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c83b192e-202d-52dd-9390-db44cae84f7f','','','Bot. Mag. (Tokyo) 18:98.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f8c3b3c-e341-5a7e-b7b5-24224b1684b0','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. Nachtr. 3:208.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53e34d39-5a3a-5a4a-8246-bdf9438f79a6','','','F. Weber & D. M. H. Mohr, Beitr. Naturk. 1:47.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e64b2b40-fdc6-5f36-9b36-e674ec74fb33','','','Morris Arbor. Monogr. 3:101.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54eb4c7f-bdbc-5443-911f-75c733a4d7be','','','Encycl. 2:132.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a07acaf-c283-55d9-b79d-7e26cc877ed1','','','Syn. pl. succ. 82.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e727b64-a135-5e3e-a972-8f1503be5bb9','','','Proc. Biol. Soc. Washington 24:134.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61704650-e2af-57c1-b277-a4db56a4671a','','','Fragm. 9:169, 190.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('047f6635-d439-5a68-b94d-6ffda0462697','','','Tabl. encycl. 1:170.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17497edc-6c77-5ee4-b1dd-000425171185','','','Meded. Rijks-Herb. 27:69.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f60dbe76-8668-5490-bef8-e7351cfb7d93','','','Nov. Holl. pl. 1:27, t. 35.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91a1e49e-76be-5da9-9cff-9daadff851d3','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 457.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b286fb9a-c294-585f-bbdd-911c4a698ef0','','','J. Linn. Soc., Bot. 14:604.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2474d88a-c685-50ef-a120-25027ca50e9d','','','Edwards''s Bot. Reg. 15: t. 1229.  1829; t. 1305.  1830 "<I>laxiflora</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34d9f105-77c4-5fd4-9faa-b8b2a147b2e8','','','Gard. dict. ed. 8: <I>Lycium</I> no. 6.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bbb7f91-2f3b-57ce-b343-890370cff9a6','','','Anales Soc. Ci. Argent. 5:207; Contr. fl. Paraguay 56.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9576a569-01a8-5586-9fc5-14cec0e5be7f','','','J. Jap. Bot. 31:296.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0bb8f1c-e530-59f6-a779-2f8e83547cda','','','J. Arnold Arbor. 19:16.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('147d7adc-60b6-5949-9f29-629adb1bd2f4','','','Syst. Bot. 18:302.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b36520a-f14f-56c4-89bd-3ad40c6c1798','','','Prodr. 3:393.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('688b9c15-eea8-5f70-9566-2977c64b0ca0','','','Fl. ind. ed. 1832, 3:720.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63f63aff-6632-51b4-b8b4-b1fe31fc450f','','','Bot. Mag. 66: t. 3752.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de35ceb5-767c-51fc-8451-a58a35fcaea4','','','Trans. Linn. Soc. London 10:362.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45371d27-a9b8-5bc2-86b4-a384f4adde5e','','','Fl. Alpes marit. 2:54.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96c43854-0465-5ccf-b83c-8f2318a28126','','','Index sem. hort. kazan.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8efd3c0c-3915-55e9-8aa7-09b083836c30','','','Feddes Repert. 79:65.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de2a0853-71e5-5148-b391-c4eccc08097e','','','Sarawak Mus. J. 3:530.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c084c0e-324d-5399-aea4-9f77ba89f195','','','Mém. Soc. Sci. Nat. Maroc 4:15.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33319ff5-1985-5a94-87da-809d7bdd60f6','','','Suppl. pl. 95.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5998c8ec-ed43-563f-a8d6-ca5e0cdb8392','','','Univ. Calif. Publ. Bot. 18:56.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3817623f-96bd-5726-82c7-cdc88ab2b771','','','J. Arnold Arbor. 6:146.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb218652-2f93-52b0-9c13-e4203add5ad7','','','Fl. Kamtschatka 3:70.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84f45bd8-87b6-5194-987d-308d8cb0f173','','','N. Amer. fl. 25:80.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60adbbd2-0629-5a7e-a0ca-c5c657d9ab79','','','Fl. bor.-amer. 1:160.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f127075-0d2e-5d33-817f-b5a879d99bec','','','Crotalaria in Africa and Madagascar 375.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('286bee3b-0e16-5754-be74-f27560edc921','','','Neue Entdeck. Pflanzenk. 2:157.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d069813-0a9a-5e5d-b6f4-b3d7cc578e1f','','','Contr. U.S. Natl. Herb. 20:211.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d1d5227-ba3c-5ab6-b92d-c067627d726a','','','A. Gray, Manual ed. 6:141.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96ce291c-dbcc-5945-a8f2-8e093ad2f54f','','','Fl. austral. 7:482.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21c4c68a-a0ee-5d02-92b3-565e7b05b9a8','','','H. G. A. Engler, Abh. Königl. Akad. Wiss. Berlin 46:55.  1894 (Engl., Planzenw. Ost-Afrikas C:253.  1895)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecff26fb-0c0d-537d-a557-62df8d501925','','','Univ. Washington Publ. Biol. 15:18.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aaaa5581-d4a6-5096-bfaf-c9b31444ee2b','','','J. Washington Acad. Sci. 28:486.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cb0ad0d-b9b4-5f92-bfcf-8ba383a6eb69','','','Prodr. 3:437.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2256289c-609f-5930-9b61-3463a6e503c7','','','Arch. Jard. Bot. Rio de Janeiro 3:134.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4547a9ee-6bb2-5a9e-b663-c2fbb5ad3615','','','Ann. Mag. Nat. Hist. ser. 2, 14:13.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f483ec8-02dd-565a-bb95-c320212c3fff','','','Rhodora 37:220.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c01346ae-63ea-5869-8343-d04c30a2eaf9','','','Repert. Spec. Nov. Regni Veg. Beih. 1:779.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6b08063-dc7b-5c44-9d92-d4bf74457037','','','Lindleyana 14:214.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdaa2239-3cd9-5ccc-bc29-41ad451e4a86','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(4):178.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1cf98d9-74f5-584d-ac7d-eeeb86a3d184','','','Fl. N. Amer. 1:400.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58cae660-a1b5-57cf-bd3e-9872fa3a19d6','','','Byull. Sredne-Aziatsk. Gosud. Univ. 21:151.  1935, pro syn.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15736226-efac-5eb9-8651-fb912370734d','','','Bull. Torrey Bot. Club 40:412.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('857e8caf-6373-5c3d-a23c-45e4e11c83fd','','','Phytologia 86:137.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a533b80-0e48-52fb-8ccf-cf5a5bcf138d','','','Blumea 56:34.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03a5f8a8-e487-5197-975a-e12016365800','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:88[folio]; 3:112[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6d4f55a-28a8-5fdb-8ec3-c5547c93501b','','','Acta Phytotax. Sin. 26:213.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acb5c106-9fd7-5584-b827-08787b370a37','','','Astragalogia 85.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96a35732-57d4-59ce-bec0-326d1274defe','','','Cent. pl. I:16.  1755 (Amoen. acad. 4:277.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b21de7a-40fe-5594-a57f-f74e3875da92','','','Syst. nat. ed. 10, 2:930.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47c440f2-a952-58d7-bcbe-327410cdd812','','','J. Straits Branch Roy. Asiat. Soc. 82:181.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0153b754-8550-56ed-966f-f77af645a3a9','','','Hooker''s J. Bot. Kew Gard. Misc. 4:334.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f206a058-e108-5a63-9eaf-c2ce8592265c','','','Mant. pl. 2:566.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8b9a641-d112-512c-b2fe-19307b854077','','','Linnaea 13:534.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92fd4624-5016-54c5-ac96-a7be9e997f0d','','','Orchid.-Buch 487.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0efbbf0b-11ab-5b01-b098-4fc3bf00ebf2','','','J. Washington Acad. Sci. 38:236.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d56e477-0151-50b8-94df-c81d6120dfa1','','','Contr. U.S. Natl. Herb. 18:198.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a67512f-9fce-510c-8db5-014b5c4ffa5b','','','Thai Forest Bull., Bot. 28:10.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('578362db-5b4c-5e09-93ab-be61aac680e8','','','Ceylon J. Sci., Biol. Sci. 2:145.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90df33c9-4b48-5080-b16a-969b610ec621','','','Bibl. index N. Amer. bot. 383.  1878 (Smithsonian Misc. Collect. 258:383.  1878)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8be55b46-1dd6-5851-8d41-7b4a05fc2053','','','Encycl. suppl. 2:825.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27a0dd99-9947-545a-bd34-b2858c2b3fbb','','','Fl. transb. 2:141, fig. 98.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbc4a824-d906-570d-bad6-17c2a8f6eda8','','','J. Bot. 71:135.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebde38d6-fab0-5fd3-a286-92fa3e09e39f','','','Webbia 9:484.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e29761c8-ec3f-584d-9037-f1ecad6a0b62','','','Sver. Fl. 726.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a172e945-a196-58f9-adc0-c70ca561a8e5','','','Fl. cochinch. 1:302.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d084f443-3b5c-5507-ac3c-7ce3a76d60d9','','','A. Fiori & A. Béguinot, Fl. Italia 3:39.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cec53a6f-826c-5956-bfce-0b7c9b742fc8','','','Fl. Amer. sept. 1:271.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6286e09-fc87-5155-a7ee-910b5f25b12a','','','Fl. Serres Jard. Eur. 9:78.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce9d171e-24ff-57b2-8090-282e12b823e4','','','Repert. Spec. Nov. Regni Veg. 11:33.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec8e2a7f-fbea-5adf-b98f-c3404dd2fa08','','','Thorne, Aliso 9:191.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('284333cc-5497-5cda-bbcc-b5ee9fe29328','','','Hamburger Garten- Blumenzeitung 9:197, 208.  1853 "<I>pseudo-pygmaea</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5abffd5e-17f6-5282-87c4-b7d73cc00b83','','','Enum. syst. pl. 19.  1760 (Select. stirp. amer. hist. 114, t. 74.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce371fcd-24b1-5c82-b974-66263efff7df','','','Wochenschr. Vereines Beförd. Gartenbaues Königl. Preuss. Staaten 8:94.  1865, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a78e5741-b7a7-52fa-9f9a-47abe4b8e15c','','','Handb. Amaryll. 162.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0e59465-106e-50fd-8f86-44f3f943b4f2','','','Interpr. Herb. amboin. 190.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d72a550-80bd-5e9f-afb8-3b84e07bba0a','','','Notes Roy. Bot. Gard. Edinburgh 12:213.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8a718ac-e6c9-5c76-a1e2-051ce7ed4dc4','','','Fl. aegypt.-arab. 40.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72e82ff1-5f5c-5800-abfc-14e96ab25ea5','','','Revis. gen. pl. 2:483.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f399241-28c6-5df6-b626-7121f0a151ef','','','Vierteljahrsschr. Naturf. Ges. Zürich 66:228.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81a9cc77-f542-55f8-b16c-4cc427a33cd5','','','Novon 14:105.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdd1b966-99f6-5cf5-8458-5bbabd152c14','','','Gen. S. Afr. pl. ed. 2. 125.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('164a8c51-2dc4-5d69-9852-a85c6073cd1c','','','Bot. J. Linn. Soc. 179:292.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5533f347-974c-5a92-99a0-ba98de36b748','','','Icon. pl. formos. 3:67.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('676a48d3-c69f-51f5-a77c-2621a32fa617','','','Trans. Roy. Soc. South Africa 3:307.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08b0a1e1-12f5-5df8-91b6-f9c23c15dba2','','','Anais Fac. Sci. Porto 17:45.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e0f2230-e395-50d1-87d8-03f4fcd3371e','','','Bijdr. 461.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c26c21b-ae74-5eb5-934d-88baa68c65cf','','','Proc. Amer. Acad. Arts 7:377.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5073e92-5548-50ef-997d-d7720b57a48c','','','Gard. Chron. ser. 3, 48:53.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8da82ec-13df-50db-b5a1-0bf0a7cdf152','','','Icon. Pl. 9: t. 878.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6168cd73-f9e4-5895-93ab-a1c8a252a84b','','','Fl. N. Amer. 1:315.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('540e25da-8df3-598a-bbbe-69d42554207b','','','Pl. hort. schoenbr. 2:4, t. 133.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44fcb7e9-23c7-5b2f-844b-2a10e43002ec','','','Watsonia 3:288.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7b0a2b1-0a46-54e9-997f-cdb678b2f0e8','','','Syn. pl. 2(1):131.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2f72fd5-f0b3-5a11-8a1e-9951757f4836','','','Bull. Soc. Linn. Normandie sér. 2, 6:232.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ad7c55a-0e97-57d2-b751-a1b633cc0704','','','A. A. Orlov, Kulturnaya Fl. SSSR 2:146.  1936, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e741b03a-5d59-502d-9848-27757b27d40a','','','Trans. Linn. Soc. London 10:200.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('440020ac-5fec-58f6-8363-8b7e89803b08','','','Notes Roy. Bot. Gard. Edinburgh 11:13.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5b8df0d-75eb-529a-95c5-802fb34cbd2d','','','Kongl. Svenska Vetensk. Akad. Handl. ser. 2, 35(1):89.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4b6ca30-583c-5d7d-a6de-075f14e0271e','','','J. Linn. Soc., Bot. 35:317.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2677c6b2-3c35-52fd-8465-9158e97d5e89','','','Bot. Mag. 135: t. 8235.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b415009-3ccb-5c98-af55-99cc597ef8f9','','','G. Vasey & J. N. Rose, Contr. U.S. Natl. Herb. 1:88.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('325dc65c-abc4-512a-9bfd-0bcf056f36ad','','','London J. Bot. 6:209.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99829b43-7a30-5a7b-9888-a945e2a91c13','','','Pl. hartw. 221.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6306985-14a8-5e19-bf6b-3ff54388e063','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 4:136,t. 3.  1770','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7cab46da-b01c-5ef8-bb2e-9a626f817446','','','Ann. Missouri Bot. Gard. 91:700.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd39fe09-89d3-542f-af1e-2993e7bdbae7','','','Chin. J. Appl. Environm. Biol. 2:243.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a38c0a4-b1b3-5175-85be-008a36f75867','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 3:916.  1881 "<I>integrifoliola</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb0c333c-4ac4-5d91-84d9-8c685754894f','','','Trans. Linn. Soc. London 10:99.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e36a60d-24ba-5884-9105-8244c52795e2','','','Bot. Mag. 33: t. 1368.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d54b7720-8c77-5a03-87d1-6a9752fa31ff','','','Phytologia 71:93.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57ba4ac7-66be-576b-b8b5-678ce1e61e62','','','Compt. Rend. Hebd. Séances Acad. Sci. 278(20):2508.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36b08cd2-f6f8-5f9e-9c8f-f5fc9cc2c1c7','','','Edwards''s Bot. Reg. 30: misc. 11.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c3f6bef-3828-524e-b58d-57567d5610a4','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 62:136.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f61cb55e-041b-5d95-b8fb-3c3e023d1a7c','','','Post, Fl. Syria 304.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fea11e8-0733-56b2-9a0b-e8dd9ece5aba','','','New Plantsman 2:131.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2c64e78-f352-5c35-9f0d-12c46e71a399','','','Fl. Brit. India 4:25.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7037971d-5399-5427-a0c5-893fdd63d47f','','','Res. Stud. State Coll. Washington 23:193.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff8258c2-8515-5a6d-a01f-64d105b576f2','','','Hort. dendrol. 48.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('663b8abb-e279-5220-987b-ecc11d1f0b1d','','','Recueil Trav. Bot. Néerl. 14:138, 141.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e452113-0c77-5757-bfe2-26bfba237aa6','','','Bull. Soc. Bot. France 59:781.  1913 ("1912")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27fffaba-5b35-56e6-8234-9474f8d29a91','','','C. L. Hitchcock et al., Univ. Washington Publ. Biol. 17(3):69.  1961 (Vasc. pl. Pacif. N.W.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e0d9e6f-1ab9-5caa-b26a-cbe5f634b619','','','Gard. Chron. ser. 3, 34:178.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0627da4d-21c7-569d-ac52-23097788b522','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:274.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6ee550a-f1a8-5ec0-87ee-dae5c966c57e','','','Prodr. 584.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3129e6df-d804-52d5-8bc3-e092aba19862','','','H. G. A. Engler, Pflanzenr. IV. 219a(Heft 105):25.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df61f27b-d0d9-5668-b9e4-ed34eae5b73c','','','Campagn. Bot. Maroc Or. 147-148.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78c11271-5d23-5499-9485-748c566f0eaa','','','Phytotaxa 183:12.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cf120d5-c365-5767-8b4e-b691a8ae414d','','','Repert. Spec. Nov. Regni Veg. 33:347.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f594c077-ab53-5cfa-9422-35b197010422','','','Pl. Coromandel 2:49, t. 192.  1805 ("1798")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35b41125-d612-5adc-97e8-d777a256f3db','','','Gard. & Forest 7:376.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6af6494-6ddf-5b7d-a95e-3d53089c98dc','','','Ann. Missouri Bot. Gard. 57:243.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2dc8cdfd-d1cc-5410-bc8f-f411cde1acf3','','','Rhodora 63:26.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d702a469-4736-51ec-898e-c3900aa27f15','','','Bot. Jahrb. Syst. 40:212.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('204907dd-e360-51c5-b08a-4ef24221dd97','','','J. D. Hooker, Fl. Brit. India 3:577.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15a17fe5-2f70-5dc1-ad25-55a62fe8f9e8','','','S. Watson et al., Botany [fortieth parallel] 204.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3ec46bf-dd20-5ffd-84da-48ad30f84712','','','Ark. Bot. 17(12):2, t. 2,5.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('662155c5-0a56-5ded-9618-17954793c241','','','Bull. Soc. Imp. Naturalistes Moscou 15:423.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6276480f-d7c6-5e8c-8ef5-18a58fc497ba','','','L. I. Duperrey, Voy. monde 2(Phanérogamie):97.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06848a0a-2808-5c45-946e-af6620dc42ff','','','Agaves Cont. N. Amer. 566.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7547ac7c-897d-5d0a-b63c-bad8fb8d788b','','','Syn. pl. glumac. 1:315.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e661fa2-bc38-5a72-bca9-f1a2f3175649','','','Bull. Torrey Bot. Club 21:479.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d7f870c-94f5-5e9d-a14e-b22ee2d2b9e1','','','Sp. pl. 2:610.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d7b7fc8-1617-5090-8b8f-637e3dfbad11','','','Bot. Jahrb. Syst. 23:191.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cd9ff00-74e0-5946-a8e1-dd4ed86c9fd9','','','Fl. Bras. merid. 1:248, t. 48.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd3221a0-8b32-52e7-846b-42ab9589db5d','','','Fl. brit. 3:1041.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6b79ae6-f58d-5b00-b3cd-1f780f5f4797','','','Austral. Syst. Bot. 4:609.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d1ad810-b3f4-5911-8d8e-b2eda1090e3a','','','Contr. New South Wales Natl. Herb. 4:56.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51fa6710-6c9e-51e4-b8f9-973a8359b2f7','','','Revista Fac. Agron. Univ. Nac. La Plata 3:557.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5ee5742-827d-5ec4-a7bc-841ba9b2ceb9','','','Phytologia 66:258.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c97d0795-702b-5467-982c-cd8686889b62','','','Gard. Bull. Singapore 57:131.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba83e64f-46c0-5125-a14f-8c79213f6102','','','Nordic J. Bot. 20:517.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ed13f38-3411-549d-b7cd-d74a598ff2d1','','','Dendrologie 2(2):168.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('747eaab6-f741-55d3-b972-28dad1b36923','','','Sched. fl. exs. austro-hung. 3:145.  1884 (Oesterr. Bot. Z. 35:174.  1885)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa2ca5e2-a233-5446-b7bc-3f477cf81426','','','Fl. N. Amer. 1:493.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7232a70c-9dba-5419-96fe-7605f2be6573','','','Feddes Repert. 89:3.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2799e983-0b1e-50de-b223-02cfa59b9cf0','','','Bothalia 8:41.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e72a0a5c-4cf4-5bee-838d-ece80e0607d5','','','J. S. African Bot. 24:52.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ff57897-6a74-5ed8-b654-e2c927cfd99d','','','Pl. wright. 2:96.  1853 (Smithsonian Contr. Knowl. 5, Art. 6)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71ce7662-c323-5055-80a3-6644f7af1099','','','Hist. pl. Guiane 425, t. 166.  1755','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c01dde62-a7f8-58cc-bc59-7e55414f72d8','','','Agric. Ledger 1906: 78, 91, 102, 105, 128, 139, 140, 147.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2fcb0637-dbbd-51dc-b78a-266b1b723b13','','','Herb. pedem. 4:24.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb999839-eee6-5cf8-b578-c63cddff8d9c','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:86[folio]; 2:110[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7edef2d-1404-5ec2-874b-e043401b9a79','','','Repert. Spec. Nov. Regni Veg. Beih. 5:123.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4a282d5-67bc-59b3-a27f-6f88b42bb30a','','','J. Bot. 31:2, t. 331.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37e1074c-943c-59eb-9e7f-88c2ec8e45dd','','','W. D. J. Koch et al., Syn. deut. schweiz. Fl. ed. 3, 3:2531.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e515e3d7-2c84-5762-bbfa-b7c04c0a872e','','','S. U. Sci. Res. J. 2:4.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f6db4d5-6b17-5e69-be00-b2cca40ba46a','','','Nordic J. Bot. 12:417.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82de1d58-1da4-51ec-8eb2-98866928c2f1','','','Ill. pl. orient. 1:151, t. 82A.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86514dd7-a47f-505f-a44d-3aa42a438c78','','','Bot. Gaz. 16:2.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c45d4527-dcc3-5588-b9f5-48c487423d69','','','Phytotaxa 3:37.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('156d40a7-e3d5-5747-ae23-7a211bd616d9','','','Baier. Fl. 1:366.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('427cc39f-2ebe-5369-9b34-bef33eccbc02','','','Meth. Sp.-Beschr. Rubus 73.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('071a69ef-7532-5d9c-88ca-fec24464acc9','','','Bull. Misc. Inform. Kew 1911:38.  1912 "<I>polycarpum</I>", nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b002f6b-235a-5179-9aec-4f51a8fe874c','','','Hort. kew. 3:353.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c77050ee-5265-5a48-87d7-654592e4a59c','','','Opera Bot. 88:38.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8531068d-d7ec-5be5-be45-10df823744cc','','','Notul. Syst. (Paris) 16:247.  1960 "<I>ogoouensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7ed780d-1032-5492-8bc6-8188c3f0668c','','','Bonplandia 5:274.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b06c240a-5adb-5d1b-8ea0-b127bfcb3eb5','','','C. S. Sargent, Pl. wilson. 1:292.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45e817bf-3048-5f73-8e00-b8c7a590ff9e','','','J. Linn. Soc., Bot. 25:17, t. 5.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('295d67fc-4212-5ad5-9fb3-236e7d5eb211','','','Gen. sp. Orchid. 1:40.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02a6c642-3d4e-5d2d-9cec-512bcc04cc68','','','J. Arnold Arbor. 22:119.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('214d0d52-38dd-587c-b9a2-02220fc20313','','','Edwards''s Bot. Reg. 23: t. 1956.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac00f7f7-eed4-57dc-9daf-82d7e6daa0eb','','','Proc. Amer. Acad. Arts 7:336.  1868 "<I>foliosum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d6f866c-1fd7-5d83-8c08-699022c8c037','','','Brittonia 31:422.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d8b8589-00bc-557a-9761-10a896077140','','','Bot. Jahrb. Syst. 113:543.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3a90965-af0f-59d0-9935-6ed3d2316595','','','Brainerd et al., Contr. Bot. Vermont 8:89.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba78586f-f7f0-5421-bec1-6c1a7517d3df','','','Hist. pl. Guiane 88.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('563189e9-16ee-5325-899b-c2b017300bb6','','','Bull. Soc. Imp. Naturalistes Moscou 27(2,4):369.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e7ea9d2-e5e9-5cfd-9ce9-86c9fae682a7','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 10:30.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4763f2f0-ffc5-5766-951f-c4c22a7beaa4','','','Sylva 7:7.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50df908b-f27f-5a84-9905-83e6ecb8deb9','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 23:225, t. 6.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1b4b362-35bc-57d9-bbb1-55ba69441f39','','','Handb. Amaryll. 35.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d49509c6-ca96-56eb-ab34-586f2e0cb29d','','','Webbia 13:503.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb9b8ec8-9df0-5401-8c35-18dfb514b7e5','','','Paxton''s Fl. Gard. 1:186.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6eca1929-4dd2-5ab1-b31b-cc19accdf339','','','Mitt. Bot. Staatssamml. München 16:544.  1980 "<I>purpurei-maculatus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b57e48d-0d39-501c-a090-0e9d2f29ec22','','','Gard. dict. ed. 8: <I>Euonymus</I> no. 2.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f300b591-4026-576f-98ef-bed7ae2124fe','','','J. Bot. (Morot) 8:289.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dde4fa95-f350-58f8-bfa9-b7d5d2cd0560','','','Abh. Naturwiss. Vereine Bremen 5:407.  1877 (not seen)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1663488d-9392-5325-ac18-55081c4fbc8f','','','Mem. Amer. Acad. Arts ser. 2, 4:34.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69e39936-b66e-5330-9080-d324dc12c991','','','F. Cuvier, Dict. sci. nat. 10:375.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8eb26479-232b-57b2-aac6-661ea129327d','','','Fl. bor.-amer. 1:36, t. 14.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92eb2b7d-44bc-5736-99f6-cf407e1a9100','','','J. Coll. Sci. Imp. Univ. Tokyo 16(4):83.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff68dafe-538e-525b-9d38-6082e65c7973','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 3:727.  1843 "<I>arguta</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50d78d45-7467-5f6a-9119-dd5ba168285d','','','Hist. pl. Guiane 969, t. 367.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b846c9b-b12a-5b85-9f33-3942d754e1ee','','','Ewart & O. B. Davies, Fl. N. Territory 344.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b9e3b18-25b1-5a15-8c47-559b5b40400b','','','Prodr. pl. cap. 2:124.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e8a9af6-3ea2-5234-af7c-370806a6d918','','','Bijdr. 133.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e86d393c-0392-5436-92a4-c9f2ab633132','','','Bull. Jard. Bot. Natl. Belg. 40(suppl.):1443.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7945b0a2-13cf-59be-8e26-688316d5b1f8','','','Hist. pl. Guiane 1:418.  1775 "<I>succosa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('915e44e5-4520-56ba-8130-48b8c27f592f','','','J. Proc. Mueller Bot. Soc. Western Australia 1(11):81.  1903 "<I>hamiltoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf5f6747-29d1-52b5-ab1e-8e8e829bcb0c','','','Proc. Amer. Acad. Arts 37:507.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('993b23d3-6064-523a-9935-4f8a17849bfa','','','Bull. Soc. Natl. Acclim. France sér. 3, 5:758.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('861caa8c-8b2a-5415-bf24-14ddaf0c1673','','','Methodus 683.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60c2a03b-1062-5a6e-9b60-349285e1f90f','','','Univ. Calif. Publ. Bot. 1:58.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b268f62-0118-542f-a9cc-dececa1f7c0d','','','J. G. C. Lehmann, Pl. Preiss. 1:13.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90d9f145-f346-5f55-9d22-96e4090b60bd','','','Notizbl. Bot. Gart. Berlin-Dahlem 9:606.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c4fc25b-51e4-587f-8ecc-02994fcf786d','','','J. D. Hooker, Fl. nov.-zel. 1:51.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7780574d-a4dc-5011-9912-47242fd26389','','','Rhododendrons 229.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c3721fa-e5d3-5e97-a07e-43ba15f7a860','','','Pl. wright. 1:51.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a43aa729-7ee9-5668-b9ee-a72d5b596ac4','','','Fl. Veg. Mundi 9:32.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99c5a226-c107-54fb-999f-0eb8e64133ca','','','Hooker''s Icon. Pl. 15: t. 1445.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e0db2ef-3784-56b4-8e8e-b21c4e94a21b','','','Trudy Prikl. Bot. 22(2):116.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57f8ff35-e66a-506a-b8f4-11162beb0aed','','','Notes Roy. Bot. Gard. Edinburgh 8:343.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('212f5dd4-0827-58fa-9b45-4f8399fbb516','','','Prodr. stirp. Chap. Allerton 62.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f35d22f0-4b52-5d61-a875-43999b71bd92','','','Handb. Sukk. Pfl. 2:835.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5eef0056-ce18-5b97-afbe-a921ea5b9dc8','','','Fl. N. Amer. 2:285.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68dd4913-2b1e-500e-bd9f-0b487f22f522','','','Herb. amb. 18.  1754 (Amoen. acad. 4:128.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bda63115-be1e-5ad4-997d-b7bca9b28e1b','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 23:101.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4647f9ae-a532-5fe1-beea-aeda92427d35','','','Denkschr. Königl.-Baier. Bot. Ges. Regensburg 1(2):56, t. 3.  1818 "<I>liotardi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d88ee54-0a74-5109-a3f5-ca3ff5f6ab0e','','','Ill. Fl. Mitt.-Eur. 5:1936.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10108e19-a887-5d4a-b7d4-895b6ee24a67','','','Linnaea 21:251.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc27f5a7-4c3c-5f74-9b54-08dc0ad11854','','','Gartenflora 74:454.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6091754-e7d3-5168-8762-59d135af3b7c','','','Field & Lab. 18:128.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d01a4928-279b-5054-93af-0b2f9d7e904e','','','L. I. Duperrey, Voy. monde 2(Phanérogamie):69, t. 12.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e6aa08e-ed2e-55e8-ad54-3098bc402deb','','','Fl. orient. 3:775.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b0c3688-06b7-58fd-be56-7eabec2759c2','','','Flora 21:183.  1838 "<I>atro-viridis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f460218-b01d-5416-893e-9d303fe6e6ed','','','Diss. 5:287.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57e5893d-ded5-5c0b-b05c-d8de1d243429','','','Contr. U.S. Natl. Herb. 1:57.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca7db8bb-2cda-5985-a96b-8de3aa56354f','','','Ill. Handb. Laubholzk. 2:224.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a69e8ee5-a553-5aa5-b156-226d22919981','','','Bol. Soc. Aragonesa Ci. Nat. 2:274.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34b3348a-7156-5b2a-93b7-939dd742f0f5','','','Prodr. 2:392.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21c8b960-bac0-51d4-8bf2-41d42bcb1812','','','Rubi Germanici 38.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a210120c-b538-5801-8630-e8dd66cad330','','','Bot. Gaz. 65:64.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4053eeb2-22b0-5278-bb43-e67badeb0aa9','','','Linnaea 12:557.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3dd065e-1855-5560-b304-2a3d2b70af90','','','Fl. Amer. sept. 6.  1771, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa0fcc30-b4e9-5d8d-b825-aed860828687','','','Bull. Misc. Inform. Kew 1928:398.  1928; Fl. W. trop. Afr. 1:343.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bfa329f-3f40-59ad-9c90-38e5cf1462a5','','','C. S. Sargent, Pl. wilson. 2:46.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df2c5fe3-a56e-51f8-bdb9-15910c63ddb5','','','Prodr. fl. Ind. orient. 84.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89acac57-582d-5f04-b6cd-a4f1dc2e8951','','','Man. Pl. Transvaal Pt. III. p. xxxi. 377.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d06ba247-f4c0-590c-9fa8-ef97c637e179','','','Mem. Torrey Bot. Club 16:96.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6685ba81-035b-5050-bbdd-50868887c9ce','','','Bull. Misc. Inform. Kew 1894:342.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d0666f2-6469-53a2-9730-8837548b906a','','','Fl. Ned. Ind., Eerste bijv. 472.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d172624-47c0-5db6-85a1-ce4b79928d84','','','Sp. pl. 2(1):487.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b136ba48-5b59-57a1-81d3-8d4a14309d01','','','Philipp. J. Sci., C 7:237.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e1f30cf-129c-5627-b0cc-e044e8bbde41','','','Palms (1999+) 57:200.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa954827-c852-5e95-afb2-f01d7fa68aaf','','','Fl. ross. 4:175.  1852 (E. Regel, Trudy Imp. S.-Peterburgsk. Bot. Sada  3:188.  1875)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8176a6e-b15b-5351-b9ee-e7d9c49d751d','','','Allg. Bot. Z. Syst. 14:160.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17d78bed-7de6-5861-ab51-644dbfe82624','','','Anal. bot. ind. 2:27; Nieuwe Verh. Eerste Kl. Kon. Ned. Inst. Wetensch. Amsterdam ser. 3, 4:39.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9e72c8e-fe24-5208-b41f-e8b5d6407531','','','Kongel. Danske Vidensk. Selsk. Skr., Naturvidensk. Math. Afd. ser. 5, 2:323.  1851 (Mexic. neldeagt. pl.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74018720-c200-57b8-ac65-4389d15ca600','','','Ishii, Cycl. Hort. (Engei Daijiten) 1:531.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26d09f42-abd7-58a8-839a-e3bda3fe208f','','','Succulenta (Netherlands) 71:253.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f64f1cd9-3bd6-5023-8777-4373c4464b0e','','','Fl. novo-galiciana 3:667.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09888257-b891-5294-8b22-d21bf4024b68','','','Proc. Biol. Soc. Washington 17:99.  1904 (Abrams, Fl. Los Angeles 128.  1904)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ed5b289-2e41-54c1-b276-67e79307dfdb','','','J. Bamboo Res. 7(2):42.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6146af52-c99e-53c0-b5a2-9a1eeaa3b264','','','Denkschr. Kaiserl. Akad. Wiss. Wien, Math.-Naturwiss. Kl. 50(2):9.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb708cf9-feab-54f5-b30d-35ea560d8e2a','','','Jahrb. Bochum. Bot. Vereins 1:126.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('116326cd-282f-54e9-bbbb-4ad1abe0b5a9','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 12:418.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f76ee36-0e8b-5b25-bf21-718cbcd98f85','','','Syn. pl. glumac. 2:197.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6f1427b-b1fd-58c7-90cf-700b4e3b057c','','','Izv. Kievsk. Bot. Sada 9:11.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bc5ad3d-1b95-5c46-895b-d22f88d43700','','','Expl. sci. Algérie 1: t. 72, fig. 4.  1849 (Bull. Soc. Bot. France 4:11.  1857)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ef4f08d-55db-5d0a-a055-9235a15b024f','','','Enum. filic. 162.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('570c53de-9bda-5d8d-9359-e82d9bd84a84','','','Mem. New York Bot. Gard. 35:24.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54d80773-c2b3-50ec-8f86-e06e174c2fd3','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:478.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6de55ef-587a-5f7c-a9b1-d966794bd436','','','Prodr. 2:470.  1825 "<I>berteriana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8dc03538-840a-59c0-8dcd-2eb08dc8b65f','','','Ber. Schweiz. Bot. Ges. 62:86.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a000e43-af8e-50cb-b1cf-8e8c69d650e5','','','Bot. Mag. (Tokyo) 32:218.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('817cf5a6-3104-5fdd-a601-b7f8908772a4','','','Anales Ci., Univ. Nac. Agrar., Lima 1:134.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('975498fe-3a25-5b44-82d2-224d0ae62049','','','Aliso 4:92.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef21cda1-8127-5180-9878-70186741cf17','','','Coll. Hawaii Publ. Bull. 2:44.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb2be397-336d-5a47-ba27-3d2f1eec587e','','','Jahrb. Deutsch. Kakteen-Ges. 1941(2):12.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cae8589-62bc-596c-8009-c791156e7273','','','Fl. austral. 2:142.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2f5523d-761e-5645-9a5b-122376054d11','','','H. G. A. Engler, Pflanzenr. IV. 20(Heft 38):309.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41e0c126-cc5e-5b0c-99bc-74897689517b','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 29:110; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 11:708.  1883 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6d6ce52-f3a3-5d02-b14c-225eb50bb4ac','','','Sida 16:103, in adnot.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0d56148-5607-5a32-a1a6-252f0371cd8a','','','Contr. Arnold Arbor. 5:74, t. 11.  1933 "<I>Pithecolobium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d344379-b388-57b0-8696-3579bbd438ed','','','Bull. Torrey Bot. Club 36:605, fig. 3.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37c88b8c-a515-5d46-9976-d9aa662b95a0','','','Arq. Mus. Paranaense 9:228.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0648f7aa-3043-51a9-85b5-745ce7704d59','','','Bull. Soc. Imp. Naturalistes Moscou 27(2):309.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec8507db-4667-5312-ba48-c758c98965a9','','','Ann. Roy. Bot. Gard. (Calcutta) 10:67.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d0d4a84-3152-5ec8-bfeb-b9cd06fa21ab','','','Pl. Coromandel 1: t. 27.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0e573c5-aa45-5d2e-aee1-26817a350ebd','','','Bull. Soc. Bot. France 55:510.  1909 ("1908")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bca5810-1d59-5a37-a47d-e1752ce9c514','','','Thai Forest Bull., Bot. 31:29.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e774807-286f-5eec-b766-6020f9955f37','','','Forest fl. Meghalaya 2:542.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5987e188-8804-583b-917b-906cbf8ab121','','','Prim. fl. esseq. 266.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31fa53cf-1ae5-5941-92ac-16b560222848','','','H. G. Bongard, Mém. Acad. Imp. Sci. St.-Pétersbourg, Sér. 6, Sci. Math. 2(2):173.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43425cd5-6ae1-5e88-9dd6-5c5045629790','','','Hist. pl. Guiane 848, t. 329.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2adcb1f2-211f-5fc9-8203-760b6f747e1e','','','Philipp. J. Sci., C 9:124.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5962878f-9a53-5db8-83d2-4d00dbf0cf07','','','Nomencl. bot. ed. 2, 2:706.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1f26bd2-d48e-55a9-8cc9-7023e2702229','','','Brittonia 25:187.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b380211b-82a8-5a46-af9f-0e7f95e7dc4f','','','Kew Bull. 35:206.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6e3fe52-f56d-5f5a-9855-d997c2bb2b89','','','Encycl. 1:320.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c49f7be-8b62-586c-ae96-de8c410fb4d2','','','Bull. Jard. Bot. Buitenzorg sér. 3, 1:320.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96b7abf9-b96e-5665-b164-1fc53bbeaff7','','','Bot. Jahrb. Syst. 29:40.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6366feab-792f-597f-a7fe-08279112e91c','','','Linnaea 2:13.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bc7602e-fd6b-5e0a-91af-68dd218df4b4','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:223.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a8a32cc-81c7-5ab1-a2f5-771e9971896c','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 6:52.  1883 (Pl. david. 1:172.  1884)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc4cd9a3-44b3-573b-8556-975bc55607b4','','','Tent. clav. anal. festuc. 83.  1927 (Rev. Bretonne Bot. Pure Appl. 1927(2):83.  1927)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dee63fb8-fb64-539f-a61e-0354de856aa5','','','Fl. bor.-amer. 2:153.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('586aec00-46eb-5647-8242-13c24cb2f19c','','','Sp. pl. 2:600.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6119b8e-d76c-5a9f-914e-607a8528d02c','','','Neue Allg. Deutsche Garten-Blumenzeitung 5:225.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09454571-7770-5b09-bad5-9784a2b1ab29','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 4:26.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87d5957f-895c-5ce7-b77e-4fc6a544ab37','','','J. Jirasek, Beobacht. Reis. Riesengeb. 120.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b04371ff-ab0a-5f65-8172-f25840a49fd5','','','Mém. Soc. Phys. Genève 6:483.  1834 (Convolv. orient.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('301df6a9-8c55-5060-acb3-5c50a1911058','','','Bull. Jard. Bot. État Bruxelles 32:170.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('490e8709-8d64-5cff-902f-e6c2a101084a','','','D. Oliver, Fl. trop. Afr. 2:261.  1871 "<I>Mezoneurum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6bdfb29-3b71-538f-9eee-c2dcfba5a249','','','C. F. P. von Martius, Fl. bras. 15(2):146.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad22bccf-079d-54eb-a407-c9620fdb47be','','','Tent. fl. abyss. 1:228.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f03cc89-25af-54c9-8441-19709aa1c943','','','J. Bot. (Hooker) 2:102.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7f283e8-baba-5590-bd10-dd3a6bdc26b2','','','J. K. Small, Fl. s.e. U.S. 104.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('573a2459-bd78-5e65-8a46-abe90f7e2d29','','','Willdenowia 31:115.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32690533-68ad-5df2-87c1-2e0b3df84864','','','PhytoKeys 2:32.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d748793-4490-5365-9636-0a133fe39ab5','','','Occas. pap. Bernice Pauahi Bishop Mus. 5(1):6.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('398d5c55-89ad-5b59-970b-13e81c7ba990','','','Syn. rub. Germ. 404.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf0cb80c-ec45-506a-8965-11b6dae5654e','','','Amer. Midl. Naturalist 4:235.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67bec53b-5650-5739-9ad4-87ba0f33822f','','','Enum. syst. pl. 32.  1760 (Select. stirp. amer. hist. 256, t. 183.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdf36535-ba29-5a64-ad3d-5fa06cddcbde','','','Darwiniana 10:222.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3b87f9b-6c32-514b-9955-78a0f5b6a982','','','J. Bot. 66:15.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8739886b-c328-5a8d-8583-8c36f7712fb4','','','Flora 37:291.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da381de4-aeb5-5868-9a8a-3487d8b0622f','','','Traité bot. méd. phan. 2:841.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93cc24c6-8793-5145-8ab4-3d75bda822a3','','','Fl. s.e. U.S. 630, 1332.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfcee445-029b-54d8-8259-2e4fd1e593a5','','','London J. Bot. 3:214.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3082cea8-ebf0-5b12-9f89-f8e57a4a8d1f','','','G. Engelmann, Proc. Amer. Acad. Arts 3:281.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94283332-4d8b-5af7-836d-6fe973a93357','','','H. G. A. Engler, Pflanzenr. IV. 105(Heft 86):319.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08248fa4-49f9-5f3a-85ff-c8776fb8706b','','','Pl. wright. 2:79.  1853 (Smithsonian Contr. Knowl. 5, Art. 6)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6498c7fd-09cf-5c59-ad12-4b4a117fcf40','','','J. Torrey in W. H. Emory, Rep. U.S. Mex. bound. 2(1):94.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93b90b77-55be-5a05-8b82-694ac8222e4c','','','Fl. taur.-caucas. 1:353.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e040916-8858-54c7-887c-8a688d383a26','','','Gen. gram. 5.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e177c2c0-b056-59df-9080-8dce2bd1bf7c','','','Fl. orient. 3:819.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6621bbe-e83f-5595-8215-04e4cc8220d3','','','Fl. ind. 1:286.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eaa038f1-e697-57a3-910a-a0bdab2eede6','','','Dec. pl. horti upsal. 1:11, t. 6.  1762 Apr-Jul (L., Sp. pl. ed. 2, 1:551.  1762 Sep)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b0735f2-754d-5763-80b9-44ae7223d68a','','','Philipp. J. Sci. 15:252.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93f48142-36d9-57ae-808a-b2b9693104eb','','','J. Arnold Arbor. 50:549.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60ad97a1-4619-5db4-b09f-af6600d4a807','','','Fl. env. Paris ed. 2:383.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9557ddcc-7756-5dc4-97d3-938634d6145d','','','Abh. Königl. Ges. Wiss. Göttingen 19:219; Pl. lorentz. 171.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15bc67df-33ee-57ef-9845-b2a1f3e0d251','','','W. H. Harvey & O. W. Sonder, Fl. cap. 1:503.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0151613a-dc94-5571-8d2f-e941a77ac1d8','','','Contr. Gray Herb. 56:32.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef1f1f6a-9f1a-5d04-91fe-513ccc64eca2','','','W. J. Hooker, Fl. bor.-amer. 2:66, t. 153.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbb70a11-fefe-5c84-a643-e3d8e72ce617','','','Descr. Egypte, Hist. nat. 62.  1813 ("1812")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5113887-d053-5508-bb6a-24938ac378af','','','Beschr. Gatt. Art. Heid. 91.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2c4d425-a2cc-5b7e-a91f-eda836ff946e','','','Nat. Hist. (Houttuyn) 2(14):181, t. 99.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f82c798-3362-56a6-8450-7869e70c6c90','','','Izv. Kavkazsk. Muz. 9:33.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4aa5756-00c3-5ae0-805e-50fbad02b135','','','Gen. pl. 2:570.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0667bea2-3a42-5d52-b4a9-aac769f908c8','','','Encycl. 4:530.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f006bb76-6e8b-5c69-88aa-211d14490fa7','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:204[folio]; 2:252[quarto].  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edbcf6e7-b0f1-5654-bcc6-97a753c4e685','','','Novon 17:509.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('328103d4-af60-5375-926e-3ff23d7ef26e','','','Sp. pl. 1:486.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e170ff35-21af-54b9-8bf8-d00a09860900','','','Contr. Gray Herb. 68:98.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7bc1b41-f808-5242-91f0-fda63cd8a502','','','A. L. P. P. de Candolle, Prodr. 13(2):295.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2908c627-5a0e-5d40-8a61-83ab3d22d54f','','','Kew Bull. 24:395.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a8d74df-2ec7-5fdd-8f67-63b5d901aea8','','','Bull. Bot. Lab. N. E. Forest. Inst., Harbin 8:86.  1980 "<I>stellato-pilosa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89ec95ab-dd50-55d0-935f-9da78091fe56','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 2:199.  1761','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('634e032d-5a13-5a24-974e-97b209147ac2','','','Repert. Spec. Nov. Regni Veg. 11:306.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('daceea3a-067b-5797-b207-5beba302647c','','','Mem. New York Bot. Gard. 35:312.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dba414a3-74d9-5455-ace1-197af9474d9a','','','Syn. fl. N. Amer. 2(1):297.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d85e8350-4168-58ba-b519-0cdbc32fdb68','','','Sp. pl. 1(2):1128.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b514426-7d07-5e23-869a-de672e07bc29','','','Fl. orient. 4:911.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bfd78b4-f8a1-564c-ad9d-b5954c4ca348','','','Demonstr. pl. 3.  1753 (Amoen. acad. 3:400.  1756)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a3f6b1e-6cf0-53ec-b261-0ed92dee140c','','','Trans. Linn. Soc. London 30:408.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b86e6b6-a234-5b79-b6f6-ffb3d4bd0244','','','Ottawa Naturalist 16:39.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf0692c1-c5a2-5c33-81fe-ac16b0db9193','','','Nat. arr. Brit. pl. 2:131.  1822 ("1821")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3996f77c-2510-5485-884d-bcdebc011fc1','','','Stand. cycl. hort. 4:2013.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1249fe9-7891-5990-bfbc-7e338e934003','','','Pl. aequinoct. 2:173, t. 137.  1817 ("1809")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1abc5981-48d9-5107-be18-22e796603a76','','','Amaryllidaceae 129, t. 33, fig. 14.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b90d3d3-f9f7-5863-bc38-675827cf4475','','','Abh. Königl. Ges. Wiss. Göttingen 24:35.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('caf4ddcb-6885-535d-b100-9b08e4ea75ea','','','Prodr. 190.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cebdfd6b-40c9-59c6-880b-f75bd0b3d3af','','','J. Bot. 37:428.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43febd78-89dd-5bb8-913b-d0da12d0dcd9','','','Descr. icon. pl. Hung. 2:141, t. 132.  1802-1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a630e7c9-a6c4-5e1b-88bc-8ce95c74bad5','','','J. Coll. Sci. Imp. Univ. Tokyo 30:67.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8230c790-c7c6-5fe6-8cb0-87cf78932ca2','','','Amer. Midl. Naturalist 35:425.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e1bca98-0c9f-561e-ba37-dfefb393b1da','','','Encycl. suppl. 4:7.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('432a500d-78cf-58a2-ae30-822bc21d919f','','','N. Amer. fl. 23:332.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42d926ea-db09-56d2-9509-427ff4c1bce3','','','Phytologia 63:497.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73c56a1a-34e0-5ee4-a31d-e19e41d8fd1e','','','Nat. Hist. Sci. 9:71.  2022 ("2021")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('106593e4-9c2e-5f2e-8aad-887779bda342','','','C. F. P. von Martius, Fl. bras. 11(1):89, t. 24, fig. 5, & t. 28.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3562a7db-49e6-55c7-858d-5b2fbcdf170b','','','Prodr. 2:216.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('413632fa-f578-5c44-99f2-dae970eb1807','','','Bot. Reg 13: t. 1096.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56a1db64-5445-55d3-8840-65cff9cfa96a','','','Nuytsia 12:276.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b0ec8e8-95ff-57f3-ad08-5a64e54f2bfa','','','Sp. pl. 1:181.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0236712-3337-52a9-bc1a-3fa0a30fa560','','','Sp. pl. 3(2):1340.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('652d4acb-294b-58cf-96b0-fe5518219903','','','Fl. nov.-zel. 1:293.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('371fd23a-8340-5137-9ba7-5ab97034627a','','','Contr. Gray Herb. 200:29.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e5d6a3d-6374-5c3c-a866-fb017fe5d79b','','','Corr. Status <I>Saxifraga nuttallii</I>.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d80fd9b-7e9f-5fda-9bbd-ab445b9370dc','','','Cact. Succ. J. (Los Angeles) 13:98.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f86af85-88bc-59ef-a561-cecbccd0093e','','','Jahrb. Königl. Bot. Gart. Berlin 5:281.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa723f87-602a-51dc-b0cd-7868e80e93cd','','','Bot. Jahrb. Syst. 121:305.  1999 "<I>hayatai</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('322f3e2e-4250-507b-9b69-96baa756fcbf','','','Spisok Rast. Gerb. Fl. S.S.S.R. 11:11.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10c1af9e-02c9-5a4c-ac70-4724685c83d5','','','Bot. Jahrb. Syst. 37:136.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2459fce-3d82-5b8d-af06-c0d41bed1b2d','','','J. Proc. Roy. Soc. New South Wales 61:167.  1927 "<I>robertsoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1da6ccc0-5efa-5cd9-882f-391c8baa77e6','','','Icon. pl. rar. 2: t. 387.  1794 ("1786-1793"); Collectanea 5:66.  1797 ("1796")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07ae760a-1cea-5d15-9797-a5003f551af4','','','Sp. pl. 2:960.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f877bea0-a565-5b99-9d47-7120355c6b48','','','Not. fl. France 141.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c034f25b-77f6-51ff-9bac-ddd89102144f','','','Dendrologie 2(2):233.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('164235eb-dd07-598b-a491-ba68202fe17b','','','Linnaea 21:685.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3bd7821-01dc-5dc9-b7ab-40140cd64565','','','Pl. rar. neapol. 1:35.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfeca2b3-874b-52ce-93ad-c72f445d1c27','','','Pacif. Railr. Rep. 2(4):161.  1857 ("1855")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44213434-168a-598c-a51e-ab0efe83410c','','','Begonian 26:202, 231.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e38c472-30eb-589d-91ea-733569df3883','','','Verh. K. K. Zool.-Bot. Ges. Wien 27:414.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('271bc26c-6bb4-553c-b826-c19a8bfd182c','','','Bot. Zeitung (Berlin) 9:395.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01d5e078-dcc4-5bbd-b788-91f5da54e78d','','','Mem. New York Bot. Gard. 35:499.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('404a94e7-cbb6-5357-ac57-7bcb18322f4e','','','Züchter 21(1/2):54.  1951 "<I>"melanopogoncompactoides</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e657b9b-b4bb-5a68-b3d8-90963e4ea8ab','','','Pacific Sci. 17:410.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42956a29-6898-56d4-adfa-20d0cab6f53c','','','Mem. Amer. Acad. Arts ser. 2, 18:152.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b26a3c6-a299-525f-ab5f-95399dae0c0a','','','Fragm. 1:78.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db1db08e-0b3d-526c-b2e8-0c1bdd912272','','','N. I. Kusnezow et al., Fl. caucas. crit. 3(4):294.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48069cf3-cdfb-59c9-92b5-00009e08203f','','','Contr. Dudley Herb. 4:59.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2b86e8c-86e6-5198-a4e6-f0975d288c94','','','Fl. Bras. merid. 3:83.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84522c1e-fceb-56d4-a449-bee6f1ed7bcc','','','Verz. Pfl. Casp. Meer. 217.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73808cd5-5c07-5f63-a028-d9b5bcbfc1cb','','','Fl. Ind. occid. 755.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45a2ff6c-7960-5d9d-86d2-dd204116f1c9','','','Beih. Bot. Centralbl., Abt. 2, 18:359.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2410cbfc-db98-5b61-9108-cd495b6a3fba','','','Ann. Sci. Nat., Bot. sér. 4, 15:81.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d886af7b-39c6-53fb-b6bd-3ab698c8b72a','','','Nov. Holl. pl. 2:25, t. 164.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3341e7d-6867-580a-858f-324fc2f8b8ab','','','Bot. Sturt''s exped. Australia 8.  1848 (C. Sturt, Narr. Exped. C. Australia 2: App. 71.  "1849")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('390d3363-c124-5d47-a198-21288f8fea1c','','','Edwards''s Bot. Reg. 29: misc. 59.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25680cfd-027d-5778-8d9b-4327b7981b2d','','','A. L. P. P. de Candolle, Prodr. 13(2):430.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a910c40d-b973-5f0a-af5d-16e870b6e81a','','','Sp. pl. 1:343.  1753 "<I>cordifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20daddcc-d372-5d3c-8286-f4593a9f16fd','','','Bull. Herb. Boissier 7(app. 1):75.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cfbb5a1-11a2-5b85-877b-b52d444c5b62','','','Monatsschr. Kakteenk. 9:149.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aaa08c1-30a9-5aa5-89c0-b222bae9709c','','','Philipp. J. Sci. 26:482.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c070c18e-7935-5c46-a436-88316bfb03e6','','','Trop. Woods  41:6.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('152c0682-08fd-5145-aad4-49518631a0d3','','','Prodr. 5:106.  1836 Oct','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e2b9539-0591-5531-871f-2c60127db0a5','','','Fl. bor.-amer. 2:169.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bc3c478-b37b-5512-8ed5-1c215bca05d4','','','Bot. Mag. 72: t. 4260.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0ae836d-23f6-54dd-8ea2-d48da1101508','','','Edwards''s Bot. Reg. 15: t. 1262.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1135340-c1a8-5830-9f7a-65977e1bece1','','','Notes Roy. Bot. Gard. Edinburgh 16:42.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf1fd067-79bf-5be2-96ae-bb9ff78bae94','','','Monde Pl. sér. 3, 27(45-160):4.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65a5028b-c980-5054-aad7-dcd296cafc16','','','Sellowia 15:157.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef2e2239-c46d-51ac-b7cb-cf8d50ef4564','','','Bull. Div. Agrostol. U.S.D.A. 21:34.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9cba922-2b7c-51b3-9c76-79487a4436ef','','','Möller''s Deutsche Gärtn.-Zeitung 38:201.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2d4cf7a-aa4d-54b4-bc2c-6ef266ae8393','','','Bull. Misc. Inform. Kew 1920:332, fig. 1.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54cbd634-7e9a-5834-b75e-a8c12622e0a7','','','Fruct. sem. pl. 2:122, t. 109, fig. 3.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46e23ebd-8b56-5770-af22-a9b6f472a98c','','','Ill. Handb. Laubholzk. 1:724.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5531e7f-d583-58cc-83fa-31c1093c098b','','','Gard. dict. ed. 8: <I>Solanum</I> no. 17.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2200e8c4-7e2a-5ad8-b0a4-8f15a0b771f2','','','Syst. nat. ed. 10, 2:1229.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48132ef6-faef-501f-94ec-e0af2921bc47','','','Notes Roy. Bot. Gard. Edinburgh 41:308.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1aa7797-0a2b-5311-ab89-5fc9d0cf1fbb','','','Encycl. 1:297.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('053dc3ef-f1ee-509f-b427-24591df45949','','','Bot. Jahrb. Syst. 29:702.  1901 "<I>micrantha</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffb89901-5627-5067-8303-e69fbbf816ad','','','Fl. Siles. 2(2):362.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('240c20ae-8c88-55cf-ab59-ac236020a6a3','','','Bull. Imp. Bur. Pl. Breed. Genet., Cambridge 33, 117.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0491f4c2-fcc1-5991-b441-a7e0b62914e8','','','J. Elisha Mitchell Sci. Soc. 37:176.  1922 Mar (pro sp.) "<I>margaretta</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a0f2fe7-99e5-5f08-9e7b-7d76b47f5b47','','','Pl. hartw. 298.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40bf4233-676a-54f7-b7bc-005e9067aaa1','','','Sp. pl. 3:1731.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aed9e4cc-9491-5b91-a702-3019b59e5afb','','','H. Stansbury, Exped. Great Salt Lake 385, t. 2.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be55fdb2-8984-5f68-a51a-337bb7d3715b','','','Bot. Beechey Voy. 58, t. 11.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ee7ab99-6754-5b7f-8778-ebc16ce18286','','','Crop Sci. (Madison) 9:775.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a06b44fc-5b92-5a6c-8cdf-27718304225e','','','E. G. Steudel, Syn. pl. glumac. 1:126.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90dbfe61-4478-5bba-82e6-569e26afbb19','','','Polygon. Guttif. Surinam 70.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88ba8399-4b3f-55f1-b63e-b2f5060fb5f6','','','Handb. Bromel. 31.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64e5c0fa-700c-5434-9f15-39fcfcd476ed','','','J. B. A. P. M. de Lamarck, Encycl. 4:407.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c64904cb-72c3-5728-88cd-a7baefcd8d8c','','','Linnaea 27:14.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('419553a4-b33a-59e4-8c93-764155e40b26','','','Bull. Misc. Inform. Kew 1912:131.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('854d2953-7e89-5279-9426-7a4f1cdb7d33','','','Gartenflora 28:294.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d12232b3-2577-5101-a6b1-6d1e3c21831b','','','D. G. J. M. Bois, Dict. hort. 2:895.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('098182f0-667c-5c89-a0a4-646e271d7657','','','Zoë 2:237.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b80442d-8ded-506f-9989-59a5cecec4a3','','','Bot. Jahrb. Syst. 74:629.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6645e149-91a7-5222-9948-209155b5982c','','','Pap. Dept. Biol. Univ. Queensland 1(18):21.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9a9dd38-6891-55cb-8a30-8672f34fb14b','','','Flora 5:296.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('287542e6-187f-5036-9d22-9fa6c9e26f67','','','J. Adelaide Bot. Gard. 20:86.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d9eefb8-c90b-54af-8822-991b1e54ee29','','','Trans. Linn. Soc. London 17:413.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bedd2ebd-1764-5e52-b915-49baafd17f94','','','J. Proc. Roy. Soc. New South Wales 53:194.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb15e8f6-1c1a-5f5e-9604-f4de5f1c8bc4','','','Cact. Succ. J. (Los Angeles) 38:55, fig. 6.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('155e9857-3a46-5d80-a300-1f378e5acad9','','','Encycl. 6:380.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('757620bc-6864-5799-bb59-fa38164db60f','','','Bot. Jahrb. Syst. 27:174.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7877c14-d96a-537b-a187-b8cb96069662','','','Prodr. 4:646.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f6270c9-acfd-599a-b6ad-c7f2563a2e79','','','Neogenyton 4.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4df10bc9-c1bb-57ae-910d-08c1fa456a12','','','Pl. aequinoct. 2:125, t. 121.  1813  ("1809") "<I>Befaria</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5d1b171-2647-5df2-a139-0b7ecec20fc0','','','Syn. pl. 2(2):332.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddc3e493-1752-5bd5-9ad1-bf63373bdb8b','','','S. African J. Bot. 112:421.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('264c19bb-fc53-5b68-a70f-2bbf10421ee2','','','Suppl. pl. 306.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('168fa53a-113f-5da6-a9c6-cb5624272fbd','','','Beskr. Guin. pl. 309.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('359c0da4-34d9-55d3-893f-03765ef07054','','','Enum. pl. China bor. 15.  1833 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 2:89.  1835)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13eef1c3-3f5b-5f00-bcf7-7e13674d4894','','','Hooker''s J. Bot. Kew Gard. Misc. 4:147.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c4a9d9c-f446-5c9e-b3a5-0bc3126c6852','','','J. S. African Bot. 13:62.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87442c11-a8ce-56cc-a9ba-d4a2313a88fb','','','Man. fl. pl. Calif. 762.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0aa07286-df85-53e8-99f4-0093da9af8d4','','','Contr. U.S. Natl. Herb. 22:698.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f68006e2-fdf2-57e7-8fd7-15a24d6bd4c4','','','Enum. pl. Tahiti 80.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9eb258f7-8e87-5042-bee3-866bfb66b4b3','','','Bot. Gaz. 34:368.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd6bf611-e38f-5481-b283-c27f0570d24e','','','Pl. jungh. 60.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f47e86f9-073a-513a-8bb3-6b2d9a9b87c8','','','Collectanea 4:197.  1791 ("1790"); Icon. pl. rar. 3: t. 516.  1792 ("1786-1793")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e0aa28a-d236-56bd-ba43-91084a19fb1e','','','Sp. pl. 1:200.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ab61a49-19a9-532c-a7f3-e60723aff799','','','J. Linn. Soc., Bot. 45:424.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0d202d8-3462-5652-b54b-2a841267e24f','','','F. E. L. Fischer et al., Index sem. hort. petrop. 9:89.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc21a1cb-33d1-5722-beee-fe7216cdcbbd','','','Prodr. 7:85.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49ed6e3d-b15e-5742-9361-a7edcbcbb75a','','','A. L. P. P. de Candolle, Prodr. 13(1):435.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('317ad3fb-8b9b-5a7e-929b-053b1579212c','','','Bull. Misc. Inform. Kew 1941:8.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c29e10c8-3f28-542e-87b8-56fe1fe36252','','','Proc. Amer. Acad. Arts 10:51.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02e12b14-72fa-5131-a3a6-99ee4faf3609','','','F. A. Körnicke & H. Werner, Handb. Getreideb. 1:208, 219.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f621a25-e16d-52dd-9ab2-53f25447f9ee','','','J. D. Hooker, Fl. Brit. India 6:214.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63d8003e-4840-5d02-a827-a884287c5310','','','W. L. Jepson, Fl. Calif. 1:177.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64f94e9f-3296-52ed-be8c-f99c4ebfa0d0','','','Syst. Bot. 14:244.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8bfe5e7-5f43-5d75-9fc2-444254dea4a4','','','Syst. veg. fl. peruv. chil. 117.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64fe0523-ef0a-5c92-ab2d-1ed7fb0a7f09','','','W. Roxburgh, Fl. ind. 2:465.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f52c50a9-704b-56d8-bb44-d53f52cd96f8','','','Amer. Orchid Soc. Bull. 38:227.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbdd187b-12a2-5e0d-9df7-ef4e0432152f','','','Gard. Chron. ser. 2, 9:439.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bab7e775-7cb5-5db1-aa87-332cd8d7240e','','','J. A. Schultes & J. H. Schultes, Syst. veg. 7(1):178.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91543a3e-ccef-50db-b5dd-1632b678425b','','','Biltmore Bot. Stud. 1:116.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71f62252-0221-5d95-8623-389fd2961c86','','','Bull. New York Bot. Gard. 3:10.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3288ff38-3f29-5c7c-95d0-ae2fedceb1b6','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 4:53.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('688437ea-939f-5882-8e47-05e382360fdd','','','Bull. Mus. Natl. Hist. Nat. 33:536.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b700d5e7-4aab-52b8-95f5-af05d500c1d0','','','Hooker''s Icon. Pl. 25: t. 2401.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('865126ef-e396-5245-8254-cc2cd0926227','','','Acta Horti Gothob. 13:301.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f10cb0e-0b6d-5428-ae1a-f6b1c86c635f','','','Z. Sukkulentenk. 3:305.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('585ed0e2-44ec-505b-a506-d5486a6a0757','','','Trans. Amer. Philos. Soc. ser. 2, 7:298.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ac4c0fe-b51c-5dd0-8755-3dbdf42282f6','','','Bot. Jahrb. Syst. 42:203.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2807bea-bfc7-5d47-8cb1-9741af0d41f3','','','Fl. N. Amer. 1:604.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bf0fb84-4920-5236-88b3-a6b1a6e8710e','','','Fl. Bras. merid. 1:178.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5333e83f-92a0-5ff9-8c57-08b8eccdfc95','','','C. S. Sargent, Pl. wilson. 1:122.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('196797fa-a95d-52d4-8633-d5e126eae3a2','','','Linnaea 26:360.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b60cfe1a-a4b0-52bf-a955-0f4d35cbd22b','','','A. L. P. P. de Candolle, Prodr. 15(2):1087.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('144741f6-f755-517d-a3d0-08f3ef29f60e','','','Bot. Jahrb. Syst. 17:567.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e249770-a1a2-5d01-bb0d-2e8d3609064e','','','Prodr. 2:417.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa50743c-abcf-5d65-849c-dfaf5e2fd799','','','Revis. gen. pl. 2:741.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd64e1d1-be81-5420-96fb-4e5377ed917e','','','Stirp. nov. 183.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('314dd451-59a0-5fc1-b40e-3b3832b49989','','','Indig. trees  Haw. Isl. 509.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d10fed10-3c2f-5cb3-903b-2ccce2da524d','','','Nov. gen. pl. 3:59.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68c9ae0d-3282-5fa7-936c-46532eaaafc6','','','Consp. fl. eur. 421.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b61050eb-eaa8-5e75-9e2f-dd0fe3b98f1d','','','Bull. Soc. Bot. France 112:327.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('545fa37e-795e-5e76-9394-f6980f4c0098','','','Prodr. 1:640.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ed110a9-24b5-5798-932a-bf401bf4d795','','','Pl. asiat. rar. 1:83, t. 98.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4ea7566-0d18-5ad1-9e7c-11606667babf','','','Sp. pl. 1:78.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9369a6e5-5035-5cb4-9323-3cc2f25c9f96','','','Symb. bot. 1:35.  1790 "<I>tiliaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a99babd-82bc-53ef-a8d9-03850acace7a','','','Sp. pl. 2:1006.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('123c5963-abd4-5ecf-9443-73c7209a0138','','','Bull. Mus. Natl. Hist. Nat. 24:84.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('491022a1-8e42-5124-97bf-2c3a3779200b','','','Rhodora 73:383.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('473bd11b-b082-58e3-a9fa-8b882f5daef8','','','Oesterr. Bot. Z. 88:254.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aaa1b247-1073-5906-8a0e-14d2908c1447','','','K. P. J. Sprengel et al., Jahrb. Gewächsk. 1(3):71.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e08c816-bedf-5d55-99c3-5b15fe1be6b0','','','Manual 632.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('194f4054-21e9-56d0-b666-ce8a5f27839a','','','Aliso 2:230.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd2b23d7-423f-54b8-8a34-48d29f71be0a','','','J. B. A. P. M. de Lamarck, Encycl. 4:41.  1797 "<I>laxa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65570dd7-ec7c-587b-a026-3d5fa681fb06','','','Agric. Univ. Wageningen Pap. 91-4:93.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30394400-d3cd-5bc7-9c79-d80d936ccfd7','','','Opera Bot. 95:241.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c185617-9fee-572a-83a0-6eacf20f30b8','','','Fl. orient. 2:32.  1872-1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40af4763-ceb1-54b4-952c-f5d63db93e5f','','','Bot. J. Linn. Soc. 159:196.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8162de48-3079-5faa-9d63-46539bf7e6c7','','','Bot. Mag. 138: t. 8466.  1912, pro sp.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a21a780c-f240-5dac-bf0f-cad07dd79068','','','Jard. Fleur. 1: misc. 116.  1851; 2: t. 118.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddae8a5c-a8ee-572d-b272-e3a3d341de20','','','J. Linn. Soc., Bot. 17:505.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9459ad8-7f02-592a-9a75-c9d7a6c0ad3d','','','Hooker''s Icon. Pl. 20: t. 1951.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('190c8f7a-125b-5035-8cfd-f78925597782','','','Mem. New York Bot. Gard. 35:258.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d6114c8-a409-5374-8283-ccdde7370cfd','','','Brittonia 32:81.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cf3d05b-e73c-5a06-8549-d0dd1b05d43e','','','Feddes Repert. 79:409.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('039df48e-885e-5578-9a1e-c56b3c0cbd50','','','Willows Calif. 90.  1879 (S. Watson et al., Bot. California 2:90.  1880)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('470ab2f8-6a8a-5a44-9d04-f17798de4c1d','','','Sp. pl. ed. 2, 2:1667.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59b821bf-9010-58a9-ba61-fccf5caced8b','','','Syst. nat. 2(2):1108.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b701cb02-8fbb-51f1-8c58-74160c4955c4','','','Abh. Naturwiss. Verein Bremen 24:520.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('423a4f7b-7810-5955-82cf-38c28403054f','','','Ark. Bot. 4(9):4.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f28cec9f-8d14-5866-8fc0-24edd72439a6','','','Trans. & Proc. Roy. Soc. South Australia 42:171, t. 16.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cd97a6c-0f6b-5bfd-8d38-84c4c7f5ed7e','','','Adansonia 27:210.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d510e6ac-d110-5dc8-afa0-5818e7561d2e','','','Phytologia 14:383.  1967 "<I>oteroii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('487ee7c3-2f18-5af7-8f1d-2b2a93e783b6','','','Ann. Mus. Bot. Lugduno-Batavi 2:111.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3192d695-c422-5602-99da-df6ac75c08d7','','','Fl. indica 311.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9fc3a55-5741-5917-8af6-d0513e7fa224','','','Fl. taur.-caucas. 3:160.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff4c3761-35da-53a7-b202-3625dffe9fea','','','A. L. P. P. de Candolle, Prodr. 10:477.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9f25180-7a88-524f-be8d-8bcc888c785f','','','Notul. Syst. (Paris) 6:76.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29fb8671-2ef8-53ca-bf29-5d9ec11a0229','','','Syst. nat. ed. 10, 2:863.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d2f4c56-86d9-5a78-81b4-501b505a9b06','','','Encycl. suppl. 1:471.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43d1093b-64cd-562f-9fab-1effc692ee56','','','C. Gay, Fl. chil. 6:440.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da36f095-fdb1-5f28-930b-5c2070eedeb5','','','C. F. P. von Martius, Fl. bras. 13(3):183, t. 51.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d1576de-b23c-5820-a8c3-306ce932357a','','','Coll. bot. sub t. 37.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50a80f36-ff3d-5be1-948a-5da80bffee69','','','P. Russell, Nat. hist. Aleppo ed. 2, 2:266.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f3a6ba0-0089-5fac-b207-457a9ba4c55b','','','Observ. fl. Hwangshan. 127, fig. 3.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f1a1526-5635-5f6b-b19e-b45690fdf30b','','','Flora 55:137.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('035e0bd4-951e-5971-aed2-8ba7b01959a9','','','A. L. P. P. de Candolle, Prodr. 9:381.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4be8dae-4aaf-5c89-a7ac-a6f0c7a054f3','','','V. Jacquemont, Voy. Inde 4(Bot.):73, t. 82.  1835-1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82aa9d01-e552-51ba-b4f8-ed471e90fa7b','','','Bull. New York Bot. Gard. 3:42.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('435bbb75-21bb-5adb-9db0-a6775baade75','','','Bot. Gaz. 80:383.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c292ae5e-76da-5bee-866f-8f82656913b3','','','Prodr. 5:219.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfed4521-83e2-5941-8438-5df330642206','','','Bot. Misc. 1:169.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8f94c9d-49ee-5bf6-8316-6df7992efea1','','','A. L. P. P. de Candolle, Prodr. 13(1):363.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fb051e2-e56d-50ad-96de-f3d2b46ae71c','','','Tabl. encycl. 1:141.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('113830f8-bff1-5990-a47e-45f0ca4e2e44','','','Fedde, Repert. Sp. Nov. Beih. 1:371.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d152fea9-5e20-5e2f-b06f-679f0c1dbae1','','','Arbor. frutic. brit. 2:833.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97939ab3-9ae9-5dc0-9f8d-b76cd86c9d6d','','','Fl. ital. 1:246.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e747956d-3b53-5c1f-ba2b-48500428edc6','','','Fl. taur.-caucas. 3:424.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e769facd-ee1c-556b-adda-8b3426648c69','','','Novon 8:225.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58e7ba0e-8bdc-517e-91d8-28dea6e5842f','','','Suppl. prodr. fl. Nov. Holl. 23.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d4bbf9a-684c-58f7-9aa9-67118210918e','','','Repert. Spec. Nov. Regni Veg. Beih. 85:21.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2db106f2-167c-590d-a005-95242ee02b01','','','Linnaea 13:533.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5429b2a0-82d6-53e0-aa51-cd3f3e9b2856','','','A. Gray, Syn. fl. N. Amer. 1(1):141.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4be72de-7d89-5763-8321-f3b5a16c3bd1','','','E. Regel & H. S. T. Tiling, Fl. ajan. 92.  1858 (Nouv. Mém. Soc. Imp. Naturalistes Moscou 11:92.  1859)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3500a2f2-1c9b-5b8f-a2e7-7d8acd078f40','','','Viola 34.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58aab47c-68bc-5ae1-a180-90e2a3bb7cd4','','','H. G. A. Engler, Pflanzenr. IV. 47(Heft 56):70.  1912, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06a8ec5f-bfc0-516c-b5a9-6e4f934320c5','','','Suppl. pl. succ. 75.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb959f06-be9e-5872-81c0-d1eef157772f','','','Enum. pl. afric. austral. 256.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d69175bb-d501-5885-b602-9c69563035f0','','','Linnaea 5:583.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c74beba-1bee-5162-bc07-aa531975e4a2','','','Rev. Hort. (Paris) 55:104, fig. 21.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a625df7-6554-593f-bcbe-9beace886586','','','Ziraat Vekâleti Yayın 716:94.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a37e8f3-4086-52a7-9787-62142b153667','','','Lindenia 4:22.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7ed14c8-4400-5eef-a105-58819118d23a','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 2:526.  1835 (A. A. von Bunge, Verz. Altai Pfl. 8.  1836, repr.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9767f8ef-7d26-5207-bd7d-6fed80614c12','','','Bull. Misc. Inform. Kew 1936:264.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82dd9da6-b420-5404-bd5a-97af318c1568','','','Kew Bull. 15:12.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43576310-ff69-5303-b2ac-8b98bcfb3ad4','','','Trans. Roy. Soc. South Africa 16:193.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bf44ffa-5475-5e2e-af35-ea50ad852e59','','','Sitzungsber. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. München 16:404.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e12e1848-858f-5164-a966-d95510779418','','','Norweg. J. Bot. 23(2):64.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1eb5c3b-ddd4-5c40-b3ea-65daae46c189','','','Nuovo Giorn. Bot. Ital. 7:68.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbe6e877-e5f8-5f84-ba6a-8b6af97e3ceb','','','Endemic plants of Greece-the Peloponnese. 239.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('925b5bbd-2244-5164-bea9-375ae70cfed6','','','Z. Gesamm. Brauw. 5:206.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00462591-4317-5efb-830b-a4faa5b7928c','','','Enum. syst. pl. 31.  1760 (Select. stirp. amer. hist. 249, t. 158.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29f4931d-25b0-588b-857e-8a134d22817d','','','N. Amer. fl. 22:497.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd0600d7-3221-59aa-a413-abdd929dbc2e','','','Gen. sp. orchid. pl. 157.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bf76aa5-06c3-5eb9-bcad-129c13c65808','','','Bull. Soc. Bot. France 85:165.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f44dce7-b7f0-5fdb-999e-b83b0d577987','','','Sp. pl. 2:875.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cd52f1c-44ef-5fac-83e0-fb60d9c841d3','','','Notes Roy. Bot. Gard. Edinburgh 11:205.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cd1755b-ca21-5785-9ef7-9d0aa1b0a205','','','D. Prain, Fl. trop. Afr. 9:141.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('107bd140-93e1-5e2d-ab36-10e2e0196c67','','','Beih. Bot. Centralbl., Abt. 2, 61B:398.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a733ea7e-ceec-59b7-8e78-54bd9fc9e2fc','','','Kew Bull. 24:293.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88fed022-f51c-5c6b-898d-b661d5957074','','','Oesterr. Bot. Z. 81:306.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87032013-4a33-5f17-9cdb-9dd9c96fbe48','','','Sp. pl. 2:686.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1690346f-e08d-5c20-93a8-c258264e367a','','','Fl. N. Amer. 1:511.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('518349e7-ed21-5890-8914-0c52d288f9b0','','','Gard. Chron. ser. 2, 20:758.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9113abd6-fb76-5acb-9cfa-f4692cef38db','','','Hort. kew. 3:213.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c8d3adf-a5d5-5db2-b508-e9cb3c8d6de4','','','Ill. Hort. 11: t. 421.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fbd9ae2-9ff5-5e23-92ee-89147d3a4c2e','','','Gard. Chron. ser. 3, 30:385.  1901 "<I>subcoerulea</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c89619ca-dcba-5036-8a08-963bb1b50fb9','','','Flora 25:237.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5cbded6-4dd6-5c90-bfea-260ed807c36f','','','J. Jap. Bot. 15:401.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e73bb34-d0c6-5bb6-90d4-afbff51eb475','','','Acta Phytotax. Geobot. 19:28.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4850fba-68c1-5ae8-a3a0-504bbe5f868f','','','Notul. Nat. Acad. Nat. Sci. Philadelphia 74:4.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be20f36c-7aa4-53ba-be2d-b4a955aa39a0','','','Pl. mattogr. 15, t. 6.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4645c5b7-35ce-5f23-8ba4-740eadd9e250','','','Voy. emp. Othoman 1(ed. qto.):252, 2(ed. oct.):64; Atlas t. 14-15.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb31b1e3-1b64-58ff-954f-d01799930e48','','','Fl. cochinch. 2:615.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f922a08f-c216-5188-9b11-4a3c342ae0aa','','','J. Arnold Arbor. 57:162.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('101ef221-677c-5b3c-a87c-870226d5193a','','','Contr. New South Wales Natl. Herb. 4:19.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('112899c7-2ca6-5e2d-a210-f1c49b9f5638','','','Tent. fl. abyss. 1:136.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e6e8361-e279-55a4-9b66-87e6ae7830c4','','','Taxon 65:56.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b96fd5c5-2a49-539c-8ba5-2778bbebf5e6','','','Notizbl. Bot. Gart. Berlin-Dahlem 11:264.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84031f6a-4ac7-5dbe-adfd-402ab5f5b5c1','','','P. E. Boissier, Diagn. pl. orient. ser. 2, 4:93.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62b6267a-206c-56e3-a766-5c0259cfd536','','','Fl. ind. ed. 1832, 2:244.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('228fe556-9edb-53c0-9de9-976f2775b27e','','','Bull. S. Calif. Acad. Sci. 31:62.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a52e528-dad1-53b7-b6d6-4de320925737','','','Hist. Nat. Iles Canaries 3(2,2):282.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a73e4de-96cc-5c03-bcf0-8ca7ccaaa3e5','','','Novon 8:205.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a28285f7-c836-51c6-a1f5-5c29d05ed99e','','','Leafl. W. Bot. 7:26.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('822fd16a-b255-5424-a25f-6c216a2ec013','','','Scroph. ind. 49.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60e34a51-0ed8-59f9-b46c-7900dc7782e9','','','Contr. U.S. Natl. Herb. 23:117.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d96f3ed-cc1e-53fd-ab41-d19a57424a42','','','Fl. orient. 1:615.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48879b63-4368-578d-9489-4693dfbd8daf','','','Symb. antill. 3:342.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac289601-64c9-5b4a-8c4e-18fefb6edb02','','','Bot. Gaz. 35:434.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('220d9335-8a99-5d4c-b1b5-93250fbdb54f','','','Syn. gen. Compos. 221.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88ff4390-f868-5090-abb7-6889ff208f71','','','Bull. Mus. Natl. Hist. Nat., B, Adansonia 18:58.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c0329a5-00f9-566f-9f6d-6f106cac075e','','','Pinaceae 84.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f06fef4-1b78-5e23-af02-613dd0efc922','','','Edinburgh J. Bot. 56:357.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fcc552e-1636-513a-8ae6-db69693a1c6e','','','Revis. gen. pl. 2:780.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('029dc0a2-2190-52de-81db-aa209db631ba','','','Techn. Bull. U.S.D.A. 1601:16.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf822705-007d-595a-a6c7-dc496e26399d','','','W. C. H. Peters, Naturw. Reise Mossambique 6(1):110, t. 21.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('244db109-45d0-5fd0-962b-aa54484f9cf0','','','Gard. Bull. Singapore 35:216.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47586ce5-3caf-5738-92ec-a939713fdfbb','','','Mem. New York Bot. Gard. 35:397.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a90a0beb-4e18-5065-894f-a0346d314a4d','','','Biblioth. Bot. 29(Heft 116):98.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f3f4d81-86bf-5abb-bb95-aa876e8420ef','','','Bull. Jard. Bot. État Bruxelles 25:202.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d98cf1e2-60a5-59c2-a805-8c31ccc7e9fb','','','Phytologia 64:449.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9c0b106-e36e-5f07-ba46-783ce092d562','','','Enum. pl. Transsilv. 136.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('431a37d2-dba9-54d5-8ae6-f117f9e0680c','','','Fl. ross. 2:94.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3df59285-6001-582c-b567-1b5bd48e87a4','','','Auct. syn. meth. stirp. hort. reg. Taur. 18.  1773 (Mélanges Philos. Math. Soc. Roy. Turin 5:70.  1774)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40e20d19-d45f-5b20-bdc9-f6a5efe7d454','','','Ann. Sci. Nat., Bot. sér. 4, 16:175.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9c2103b-b848-5d0e-a05d-1d68425d96cb','','','J. D. Hooker, Fl. Brit. India 3:451.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98a0fa9f-2068-546d-8a8f-a862d8896ce9','','','Bull. Soc. Bot. France 33:390.  1887 ("1886")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0c283ed-6f91-5f7a-9aab-7c358a43cbe9','','','Bull. Soc. Bot. France 68:376.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f4c7c92-ad18-52ce-96ac-b64ab2df4a83','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:112[folio].  1821; 5:145[quarto].  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cc68ec9-ca5a-526b-9ea6-f3bd7e81f6bc','','','Icon. 1:2, t. 4.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61ea36d3-3d6d-502e-9196-d9afc1d1fd57','','','Index sem. hort. vratisl.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e663ffd5-83de-54c1-abef-136bc8c8ea8b','','','Repert. Spec. Nov. Regni Veg. Beih. 12:346.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6dfbfd5-ca4b-5ee7-9da0-f9511fa58bbf','','','J. D. Hooker, Fl. Brit. India 2:648.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2fd3c1c-f14d-59da-ac84-7e527ddea99f','','','Adansonia sér. 3, 26:46.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37617667-a5aa-56bc-a5b2-062b9e2edc74','','','Erythea 7:70.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4e2037b-e06a-580b-bd7d-9b1ba5a1fc20','','','Tea Sci. Res. J. (China) 1983:4.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3671706-9b35-5146-aaf8-7b55717edc37','','','Repert. Spec. Nov. Regni Veg. 18:238.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('032e8871-45a6-5f68-a5ae-db07794bacac','','','Annuario Reale Ist. Bot. Roma 8:310.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c195478d-9d4d-5356-a4d2-9a72b90232d4','','','Fl. France 1:6.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ef2f7e1-b64a-5d05-ac73-73b2998fc12d','','','Fl. Oware 1:41, t. 24.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b366c1e9-9db8-5bd2-91be-c447bd0fe60f','','','Hort. kew. 1:286.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c33f5eb8-f70a-59f5-8171-ae954cd5da7f','','','Willdenowia 7:102.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abbefada-b20f-52e1-989f-c41c829adc78','','','Repert. Spec. Nov. Regni Veg. 13:116.  1914 "<I>bequaerti</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec60f29a-b250-51d1-bb30-cefe4beb4930','','','Proc. Acad. Nat. Sci. Philadelphia 1848[4]:20.  1848 Mar-Apr (J. Acad. Nat. Sci. Philadelphia ser. 2, 1:173.  1848 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2dc8dfad-ccbe-5a84-8419-86cf3e02f580','','','Ann. Nat. Hist. 1:136.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff2496ed-6dca-5189-aa72-4091a2d3fb0f','','','Bull. Soc. Bot. France 42:299.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54af6e75-f088-5460-a71b-052f66b4d350','','','Amer. Midl. Naturalist 74:434.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd6d907e-8dde-5417-90f1-e0245af44080','','','Aliso 4:110.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21511460-c399-562d-88da-afc738f4d53a','','','C. F. Drège, Flora 26:163.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0e73455-bff3-5f82-8c9d-4b729138832b','','','Linnaea 22:532.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b709ddd-6b9f-5ffb-b21c-23c9bcb069a9','','','Bull. Dép. Agric. Indes Néerl. 45:9.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7f50933-abb3-537c-b5bd-0f217af1f0f4','','','Bull. Soc. Bot. France 20:260.  1874 ("1873")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05425f90-f150-52d5-99f5-d8d0593262d9','','','Arch. Mus. Hist. Nat. 1:192.  1839; Ann. Sci. Nat., Bot. sér. 2, 12:105.  1839 Aug','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e12cdc85-6bdb-5857-a97b-7e80dcbeb60a','','','Pl. hartw. 17.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53d77a89-cbf7-5ee5-85a7-9354f3c53422','','','Nuovo Giorn. Bot. Ital. 15:145.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6037904e-3e64-5874-90d8-3a862e97f359','','','J. Arnold Arbor. 35:45.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('436d07bb-74de-5f17-8d49-0969c1e13b5f','','','J. A. Schultes, Oestr. Fl. ed. 2, 1:437.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('375086ee-9b8c-5359-8f0d-6b8b9583f429','','','Anais Soc. Bot. Brasil XXVIII Cong. 86.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f92cd92-7365-5cbb-99aa-90c1561ff99a','','','Bull. Herb. Boissier sér. 2, 4:532.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a5ec93b-62e8-5959-9bf9-d2dddc8b196b','','','Repert. Spec. Nov. Regni Veg. 31:86.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a34b390a-d798-5f08-801f-4916f958f8a2','','','J. Arnold Arbor. 13:32, t. 40.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be77629a-b77b-5a70-85bd-db9f1aa858eb','','','Gard. Chron. ser. 3, 1:670.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afd7ebbb-ae24-5d15-9411-de4302933c6a','','','Philos. Trans. 77(2):308, t. 12.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a099f760-2b26-5d05-b2bd-a3d2ce85dc7f','','','Bradleya 4:22.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcbdf45c-a536-5e0c-8b02-d72d8718f238','','','Contr. U.S. Natl. Herb. 7:57.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3aee5d11-6458-5736-8a18-c52cfe97b5e8','','','Brittonia 4:412.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25e45450-ebf6-599d-b03e-00b06af30971','','','Index sem. hort. petrop. 1868:81.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9c03aed-cf03-5cc0-a131-778660cb1a8e','','','A. Guillemin et al., Fl. Seneg. tent. 1:219.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7ef7f54-9bb3-5e25-896b-456f3265a91e','','','Bull. Soc. Dendrol. France 38:30.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec07e241-630d-5ec4-8b50-650215bc6de2','','','Syst. veg. 7(2):1555.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb81cf35-882e-5ecb-a32b-ac869211a369','','','Principes 13:76.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2152fdb-d3f7-5e34-ba99-39a580a9b942','','','Bot. Mag. 52: t. 2524.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbb92d4f-a1f6-5656-86ef-6066d6f77e06','','','Prodr. 5:685.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2420df9d-4336-57d0-b4b5-c30090eba5d8','','','D. Oliver, Fl. trop. Afr. 2:7.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bc18bbe-f530-5975-ae11-09b2d55c6da1','','','Trudy Sil''s''ko-Gosp. Bot. 1:170.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a94b020-48e6-54df-987c-65f744730285','','','Contr. U.S. Natl. Herb. 20:239.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b0b1a15-66aa-57dd-ad94-9340ce19c135','','','Nuovo Giorn. Bot. Ital. n.s., 36:364.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('455d7fbb-855d-5ffe-98d5-726a189849d1','','','Fl. Pl. South Africa 14: t. 530.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9376727-6382-530a-8ea4-a3376cea154e','','','Opera Bot. 20:200.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('322e3100-f9b0-5c42-8754-6209f98f232d','','','Novosti Sist. Vyssh. Rast. 39:154.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3a51ff2-2053-59a7-89a6-be3a05036a7c','','','J. Linn. Soc., Bot. 35:515.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('619c9341-843c-589a-9adb-efedb4e0df65','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 12:225.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('148b744b-5cf3-5867-8ffa-d11b1ecbb140','','','Fl. chil. 6:352.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5aa03505-e186-514c-8ece-a0013aa35afb','','','Bull. Fan Mem. Inst. Biol. 8:37.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8016c7f6-93ff-5f4d-8695-327d4b57cee3','','','Ann. Sci. Nat., Bot. sér. 4, 11:132.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b57ae652-4f8a-5540-b0a6-d8e3467665de','','','Notizbl. Bot. Gart. Berlin-Dahlem 8:350.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce376b1c-c075-5c3b-9f63-1d93401189bf','','','Byull. Vsesoyuzn. Inst. Rasteniev. 81:41.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b212627b-6b48-5a1a-a913-4e00b3030969','','','Revista Centro Estud. Farm. 2(6):22.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('941551bb-000e-54ee-897e-c5b5f1f721fa','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:50[folio]; 1:60[quarto], t. 5.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a412e1f9-65a4-50dd-a02e-e75f3dec8bfc','','','Blumea 8:193.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aa507db-fd87-5ea7-aa62-25b936a78c41','','','H. Schott & S. L. Endlicher, Melet. bot. 20.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6