PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE version (id TEXT NOT NULL) STRICT;
INSERT INTO version VALUES('v0.3.33');
CREATE TABLE metadata (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__doi TEXT DEFAULT '',
  col__title TEXT NOT NULL,
  col__alias TEXT DEFAULT '',
  col__description TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__version TEXT DEFAULT '',
  col__keywords TEXT DEFAULT '',
  col__geographic_scope TEXT DEFAULT '',
  col__taxonomic_scope TEXT DEFAULT '',
  col__temporal_scope TEXT DEFAULT '',
  col__confidence INTEGER DEFAULT NULL,
  col__completeness INTEGER DEFAULT NULL,
  col__license TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__logo TEXT DEFAULT '',
  col__label TEXT DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__private INTEGER DEFAULT NULL -- bool 
) STRICT;
INSERT INTO metadata VALUES(1,'','New Zealand Organizm Register','','NZOR is an actively maintained compilation of all organism names relevant to New Zealand: indigenous, endemic or exotic species or species not present in New Zealand but of national interest. NZOR is digitally and automatically assembled from a number of taxonomic data providers. It provides a consensus opinion on the preferred name for an organism, any alternative scientific names (synonyms), common and Māori names, relevant literature, and the data provider’s view on the documented presence/absence in New Zealand.','','','','','','',0,0,'','','','','',0);
CREATE TABLE contact (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT NOT NULL,
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE editor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE creator (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE publisher (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT DEFAULT '',
  col__family TEXT DEFAULT '',
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE contributor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE source (
  col__id TEXT PRIMARY KEY,
  col__metadata_id INTEGER DEFAULT 1,
  col__type TEXT DEFAULT '',
  col__title TEXT DEFAULT '',
  col__authors TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__isbn TEXT DEFAULT ''
) STRICT;
CREATE TABLE author (
  col__id TEXT PRIMARY KEY,
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__alternative_id TEXT DEFAULT '', -- sep by ','
  col__given TEXT DEFAULT '',
  col__family TEXT NOT NULL,
  -- f. for filius,  Jr., etc
  col__suffix TEXT DEFAULT '',
  col__abbreviation_botany TEXT DEFAULT '',
  col__alternative_names TEXT DEFAULT '', -- separated by '|'
  col__sex_id TEXT REFERENCES sex DEFAULT '',
  col__country TEXT DEFAULT '',
  col__birth TEXT DEFAULT '',
  col__birth_place TEXT DEFAULT '',
  col__death TEXT DEFAULT '',
  col__affiliation TEXT DEFAULT '',
  col__interest TEXT DEFAULT '',
  col__reference_id TEXT DEFAULT '', -- sep by ','
  -- url
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE reference (
  col__id TEXT PRIMARY KEY,
  col__alternative_id TEXT DEFAULT '', -- sep by ',', scope:id, id, URI/URN
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__type_id TEXT REFERENCES reference_type DEFAULT '',
  -- author/s in format of either
  -- family1, given1; family2, given2; ..
  -- or
  -- given1 family1, given2 family2, ...
  col__author TEXT DEFAULT '',
  col__author_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__title TEXT DEFAULT '',
  col__title_short TEXT DEFAULT '',
  -- container_author is an author or a parent volume (book, journal) 
  col__container_author TEXT DEFAULT '',
  -- container_title of the parent container
  col__container_title TEXT DEFAULT '',
  -- container_title_short of the parent container
  col__container_title_short TEXT DEFAULT '',
  col__issued TEXT DEFAULT '', -- yyyy-mm-dd
  col__accessed TEXT DEFAULT '', -- yyyy-mm-dd
  -- collection_title of the parent volume
  col__collection_title TEXT DEFAULT '',
  -- collection_editor of the parent volume
  col__collection_editor TEXT DEFAULT '',
  col__volume TEXT DEFAULT '',
  col__issue TEXT DEFAULT '',
  -- edition number
  col__edition TEXT DEFAULT '',
  -- page number
  col__page TEXT DEFAULT '',
  col__publisher TEXT DEFAULT '',
  col__publisher_place TEXT DEFAULT '',
  -- version of the reference
  col__version TEXT DEFAULT '',
  col__isbn TEXT DEFAULT '',
  col__issn TEXT DEFAULT '',
  col__doi TEXT DEFAULT '',
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE name (
  col__id TEXT PRIMARY KEY,
  col__alternative_id TEXT DEFAULT '',
  col__source_id TEXT DEFAULT '',
  -- basionym_id TEXT DEFAULT '', -- use name_relation instead
  gn__scientific_name_string TEXT NOT NULL, -- full name with authorship (if given)
  gn__parse_quality INTEGER DEFAULT NULL,
  gn__canonical_simple TEXT DEFAULT '',
  gn__canonical_full TEXT DEFAULT '',
  gn__canonical_stemmed TEXT DEFAULT '',
  gn__cardinality INTEGER DEFAULT NULL,
  gn__virus INTEGER DEFAULT NULL, -- bool
  gn__hybrid TEXT DEFAULT '',
  gn__surrogate TEXT DEFAULT '',
  gn__authors TEXT DEFAULT '', -- separated by '|'
  gn__id TEXT DEFAULT '', -- UUID v5 generated for GN from name-string
  col__scientific_name TEXT NOT NULL, -- full canonical form
  col__authorship TEXT DEFAULT '', -- verbatim authorship
  col__rank_id TEXT REFERENCES rank DEFAULT '',
  col__uninomial TEXT DEFAULT '',
  col__genus TEXT DEFAULT '',
  col__infrageneric_epithet TEXT DEFAULT '',
  col__specific_epithet TEXT DEFAULT '',
  col__infraspecific_epithet TEXT DEFAULT '',
  col__cultivar_epithet TEXT DEFAULT '',
  col__notho_id TEXT DEFAULT '', -- ref name_part
  col__original_spelling INTEGER DEFAULT NULL, -- bool
  col__combination_authorship TEXT DEFAULT '', -- separated by '|'
  col__combination_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__combination_ex_authorship TEXT DEFAULT '', -- separated by '|'
  col__combination_ex_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__combination_authorship_year TEXT DEFAULT '',
  col__basionym_authorship TEXT DEFAULT '', -- separated by '|'
  col__basionym_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__basionym_ex_authorship TEXT DEFAULT '', -- separated by '|'
  col__basionym_ex_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__basionym_authorship_year TEXT DEFAULT '',
  col__code_id TEXT REFERENCES nom_code DEFAULT '',
  col__status_id TEXT REFERENCES nom_status DEFAULT '',
  col__reference_id TEXT DEFAULT '', -- refs about taxon sep ','
  col__published_in_year TEXT DEFAULT '',
  col__published_in_page TEXT DEFAULT '',
  col__published_in_page_link TEXT DEFAULT '',
  col__gender_id TEXT REFERENCES gender DEFAULT '',
  col__gender_agreement INTEGER DEFAULT NULL, -- bool
  col__etymology TEXT DEFAULT '',
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
INSERT INTO name VALUES('0045bdb4-a30f-4479-821d-cd15a4f60f42','','','Manilkara',1,'Manilkara','Manilkara','Manilkara',1,0,'','','','abcdf8e2-d004-5929-ac1f-9061a977f7fc','Manilkara','','GENUS','Manilkara','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('004382c7-5b84-46f2-98af-d59289c7adae','','','Parvigenerina',1,'Parvigenerina','Parvigenerina','Parvigenerina',1,0,'','','','d0665aac-7b42-52f6-b849-ca678e24cfd9','Parvigenerina','','GENUS','Parvigenerina','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('004c4574-affe-4301-8c05-02ccb3a65880','','','Zschokkella',1,'Zschokkella','Zschokkella','Zschokkella',1,0,'','','','4117603b-843b-53ab-a6fc-2ed6a24ee007','Zschokkella','','GENUS','Zschokkella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('004d83cf-9718-4c43-b76b-3b02c203b488','','','Cheilanthes tenuifolia subsp. sieberi (Kunze) Domin',1,'Cheilanthes tenuifolia sieberi','Cheilanthes tenuifolia subsp. sieberi','Cheilanthes tenuifol sieber',3,0,'','','Kunze|Domin','158d0d43-6c86-50d3-a831-541d6b47ef04','Cheilanthes tenuifolia subsp. sieberi (Kunze) Domin','(Kunze) Domin','SUBSPECIES','','Cheilanthes','','tenuifolia','sieberi','','',NULL,'Domin','','','','','Kunze','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('004f1849-4341-4868-8524-5bbc593b357b','','','Lonicera ligustrina Wall.',1,'Lonicera ligustrina','Lonicera ligustrina','Lonicera ligustrin',2,0,'','','Wall.','e91d3d6f-2ac2-5b4e-9c6a-e73e24d8f8c7','Lonicera ligustrina Wall.','Wall.','SPECIES','','Lonicera','','ligustrina','','','',NULL,'','','','','','Wall.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('004b67f7-f28a-4dbc-b2f5-9418a19121f4','','','Bidenichthys',1,'Bidenichthys','Bidenichthys','Bidenichthys',1,0,'','','','5935c118-7bfd-5b83-bc74-a928c06338f9','Bidenichthys','','GENUS','Bidenichthys','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00499edf-230d-4fcc-bccf-ac7e821b7718','','','Ambrosiella roeperi T.C. Harr. & McNew',1,'Ambrosiella roeperi','Ambrosiella roeperi','Ambrosiella roeper',2,0,'','','T. C. Harr.|McNew','31cf9416-ed97-5b3f-b5aa-476742597202','Ambrosiella roeperi T.C. Harr. & McNew','T.C. Harr. & McNew','SPECIES','','Ambrosiella','','roeperi','','','',NULL,'','','','','','T. C. Harr. & McNew','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0050e59c-40b7-455c-afa7-0f15801bfffc','','','Stephanonectria keithii (Berk. & Broome) Schroers & Samuels',1,'Stephanonectria keithii','Stephanonectria keithii','Stephanonectria keith',2,0,'','','Berk.|Broome|Schroers|Samuels','441f35d2-eb39-5c09-a2c9-bc4aaec45c42','Stephanonectria keithii (Berk. & Broome) Schroers & Samuels','(Berk. & Broome) Schroers & Samuels','SPECIES','','Stephanonectria','','keithii','','','',NULL,'Schroers & Samuels','','','','','Berk. & Broome','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00558541-9089-4117-bbcd-9809f914a5ec','','','Panisea (Lindl.) Lindl.',1,'Panisea','Panisea','Panisea',1,0,'','','Lindl.','78dc3c7a-8619-5a98-9ec1-845851afb83f','Panisea (Lindl.) Lindl.','(Lindl.) Lindl.','GENUS','Panisea','','','','','','',NULL,'Lindl.','','','','','Lindl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0055a779-66c0-4e55-8ec4-e0a6c80ea1dd','','','Ensifer numidicus Merabet et al., 2010',1,'Ensifer numidicus','Ensifer numidicus','Ensifer numidic',2,0,'','','Merabet et al.','8cd71956-0302-59e9-8bed-a597f8493b1d','Ensifer numidicus Merabet et al., 2010','Merabet et al., 2010','SPECIES','','Ensifer','','numidicus','','','',NULL,'','','','','','Merabet et al.','','','','2010','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('005a6276-9318-4ddb-a4dc-092a18316cec','','','Nitrobacter winogradskyi Winslow et al., 1917',1,'Nitrobacter winogradskyi','Nitrobacter winogradskyi','Nitrobacter winogradsky',2,0,'','','Winslow et al.','d871b0f3-c17c-55b8-b74c-2a357fec5c52','Nitrobacter winogradskyi Winslow et al., 1917','Winslow et al., 1917','SPECIES','','Nitrobacter','','winogradskyi','','','',NULL,'','','','','','Winslow et al.','','','','1917','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0058c69d-3552-4f61-b4ea-483daf479cf3','','','Synchytrium fulgens J. Schröt.',1,'Synchytrium fulgens','Synchytrium fulgens','Synchytrium fulgens',2,0,'','','J. Schröt.','a999521e-c730-5a7c-8a24-2ad4a95f628c','Synchytrium fulgens J. Schröt.','J. Schröt.','SPECIES','','Synchytrium','','fulgens','','','',NULL,'','','','','','J. Schröt.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0059549f-b181-477d-b197-a8c7222454ed','','','Helichrysum plumeum Allan',1,'Helichrysum plumeum','Helichrysum plumeum','Helichrysum plume',2,0,'','','Allan','82b17c68-6aae-5396-be80-88c400c1bb05','Helichrysum plumeum Allan','Allan','SPECIES','','Helichrysum','','plumeum','','','',NULL,'','','','','','Allan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('005ebb73-a337-4687-84a9-df8db530dd64','','','Sciaphila Treitschke, 1829',1,'Sciaphila','Sciaphila','Sciaphila',1,0,'','','Treitschke','a260631b-f138-5a42-a403-28b747991b23','Sciaphila Treitschke, 1829','Treitschke, 1829','GENUS','Sciaphila','','','','','','',NULL,'','','','','','Treitschke','','','','1829','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00679b56-867d-43b4-adac-285343abd74e','','','Ceratium macroceros (Ehrenberg)',1,'Ceratium macroceros','Ceratium macroceros','Ceratium macrocer',2,0,'','','Ehrenberg','a0ae3204-08cb-5e8d-aa3b-35dc907702e9','Ceratium macroceros (Ehrenberg)','(Ehrenberg)','SPECIES','','Ceratium','','macroceros','','','',NULL,'','','','','','Ehrenberg','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0064f74f-7f72-4aa5-bd1f-50da67686a00','','','Maclura Nutt.',1,'Maclura','Maclura','Maclura',1,0,'','','Nutt.','94fc3482-a54e-567f-9bdd-5826c196d802','Maclura Nutt.','Nutt.','GENUS','Maclura','','','','','','',NULL,'','','','','','Nutt.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('005f8e92-f7d8-416c-83d9-78cccc537107','','','Klopstockia cerifera H.Karst.',1,'Klopstockia cerifera','Klopstockia cerifera','Klopstockia cerifer',2,0,'','','H. Karst.','37f1bffa-8389-5c38-bf8d-c805ec41da0a','Klopstockia cerifera H.Karst.','H.Karst.','SPECIES','','Klopstockia','','cerifera','','','',NULL,'','','','','','H. Karst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0063a7e0-89c4-4e83-8269-ef22caba69cd','','','Mendax trizonaloides B. Marshall, 1978',1,'Mendax trizonaloides','Mendax trizonaloides','Mendax trizonaloid',2,0,'','','B. Marshall','29f4ec53-8ff3-5f2b-93cc-06755adc3691','Mendax trizonaloides B. Marshall, 1978','B. Marshall, 1978','SPECIES','','Mendax','','trizonaloides','','','',NULL,'','','','','','B. Marshall','','','','1978','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('006de0c1-701a-40ea-9abc-1fd432d65ad3','','','Stenella novae-zelandiae Matsush.',1,'Stenella novae-zelandiae','Stenella novae-zelandiae','Stenella nouae-zelandi',2,0,'','','Matsush.','976417cb-a4a0-525d-99a6-aea97c4a9ce4','Stenella novae-zelandiae Matsush.','Matsush.','SPECIES','','Stenella','','novae-zelandiae','','','',NULL,'','','','','','Matsush.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('006de08a-fdb4-4eef-a3ab-70de531ac878','','','Oropezella trucispicata Plant, 1989',1,'Oropezella trucispicata','Oropezella trucispicata','Oropezella trucispicat',2,0,'','','Plant','c964b9a4-6787-5160-9c8e-4e196d16a035','Oropezella trucispicata Plant, 1989','Plant, 1989','SPECIES','','Oropezella','','trucispicata','','','',NULL,'','','','','','Plant','','','','1989','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('006a348b-de66-4c05-a4e5-973798cd9338','','','Nertera balfouriana Cockayne',1,'Nertera balfouriana','Nertera balfouriana','Nertera balfourian',2,0,'','','Cockayne','ad8c9aea-9ad4-5878-b60d-25523ab0bda3','Nertera balfouriana Cockayne','Cockayne','SPECIES','','Nertera','','balfouriana','','','',NULL,'','','','','','Cockayne','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0068de3d-3f0a-46d0-a951-fb4048c7b95a','','','Trigonotylus tenuis Reuter, 1893',1,'Trigonotylus tenuis','Trigonotylus tenuis','Trigonotylus tenu',2,0,'','','Reuter','645bb8cb-6401-5ecc-bc63-dacc720b52d2','Trigonotylus tenuis Reuter, 1893','Reuter, 1893','SPECIES','','Trigonotylus','','tenuis','','','',NULL,'','','','','','Reuter','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00758e7c-b105-4805-b3f8-406db49e8fdc','','','Phoma nigricans P.R. Johnst. & Boerema',1,'Phoma nigricans','Phoma nigricans','Phoma nigricans',2,0,'','','P. R. Johnst.|Boerema','347b8bca-afe7-58bf-aed4-fdd195014c4a','Phoma nigricans P.R. Johnst. & Boerema','P.R. Johnst. & Boerema','SPECIES','','Phoma','','nigricans','','','',NULL,'','','','','','P. R. Johnst. & Boerema','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('007705cd-889d-4d5c-9bfb-75e8f670280a','','','Asecodes',1,'Asecodes','Asecodes','Asecodes',1,0,'','','','95910518-e892-502f-b141-6b962a4b1ec0','Asecodes','','GENUS','Asecodes','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0076b77f-e9ef-4b7f-a89e-92cff86b1458','','','Whitea',1,'Whitea','Whitea','Whitea',1,0,'','','','9244b59b-d258-57c1-b1cd-c0e6d200b251','Whitea','','GENUS','Whitea','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0072f84e-1814-4066-9903-97d5dd8c5ef7','','','Tholospira cervicornis Haeckel, 1887',1,'Tholospira cervicornis','Tholospira cervicornis','Tholospira ceruicorn',2,0,'','','Haeckel','3a36cd4d-f823-5303-a0cd-15b523f5d69e','Tholospira cervicornis Haeckel, 1887','Haeckel, 1887','SPECIES','','Tholospira','','cervicornis','','','',NULL,'','','','','','Haeckel','','','','1887','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0076dfae-ee73-416e-aa1f-e923f82fc781','','','Asterivora combinatana (Walker, 1863)',1,'Asterivora combinatana','Asterivora combinatana','Asterivora combinatan',2,0,'','','Walker','9dc52ce1-7416-5af4-98a1-9450f4efc5b1','Asterivora combinatana (Walker, 1863)','(Walker, 1863)','SPECIES','','Asterivora','','combinatana','','','',NULL,'','','','','','Walker','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('007a2a6c-640d-4bb2-a29b-39d36c82ced4','','','Anthocleista Afzel. ex R.Br.',1,'Anthocleista','Anthocleista','Anthocleista',1,0,'','','Afzel.|R. Br.','fdb2b13d-e7cc-54e8-b575-fb139735b680','Anthocleista Afzel. ex R.Br.','Afzel. ex R.Br.','GENUS','Anthocleista','','','','','','',NULL,'','','','','','Afzel.','','R. Br.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('007cdfe7-1a56-49c6-8119-7edf5c481039','','','Tylimanthus perpusillus Colenso',1,'Tylimanthus perpusillus','Tylimanthus perpusillus','Tylimanthus perpusill',2,0,'','','Colenso','4cab1b0e-4bf9-5ec4-bcaf-83deb18785c8','Tylimanthus perpusillus Colenso','Colenso','SPECIES','','Tylimanthus','','perpusillus','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('007a4f2a-105d-4c54-8b5b-cec19f390ede','','','Lunathyrium japonicum (Thunb. ) Sa.Kurata',1,'Lunathyrium japonicum','Lunathyrium japonicum','Lunathyrium iaponic',2,0,'','','Thunb.|Sa. Kurata','8da9f809-8aec-5924-a01e-bdd4dc6c1b30','Lunathyrium japonicum (Thunb. ) Sa.Kurata','(Thunb. ) Sa.Kurata','SPECIES','','Lunathyrium','','japonicum','','','',NULL,'Sa. Kurata','','','','','Thunb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00793fcd-d4bb-474e-bdf5-e27d6010360d','','','Sternoptyx diaphana Hermann, 1781',1,'Sternoptyx diaphana','Sternoptyx diaphana','Sternoptyx diaphan',2,0,'','','Hermann','a01b9e55-ed30-54f8-931a-ea9c2119e863','Sternoptyx diaphana Hermann, 1781','Hermann, 1781','SPECIES','','Sternoptyx','','diaphana','','','',NULL,'','','','','','Hermann','','','','1781','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0083e7bd-a977-41e9-922b-680e220a0fbf','','','Rathkea formosissima M. Sars, 1835',1,'Rathkea formosissima','Rathkea formosissima','Rathkea formosissim',2,0,'','','M. Sars','508f106f-9033-51fd-b4a6-ee08f6a2a5c3','Rathkea formosissima M. Sars, 1835','M. Sars, 1835','SPECIES','','Rathkea','','formosissima','','','',NULL,'','','','','','M. Sars','','','','1835','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('008348d2-f89b-4958-a77c-b2436346e64a','','','Decostea Ruiz & Pav.',1,'Decostea','Decostea','Decostea',1,0,'','','Ruiz|Pav.','7a8279bb-f321-56a0-8779-d08f804a278c','Decostea Ruiz & Pav.','Ruiz & Pav.','GENUS','Decostea','','','','','','',NULL,'','','','','','Ruiz & Pav.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0082db09-3d12-4bb2-9aff-ca299c4169da','','','Leptocotis tenuirostris (Claus, 1871)',1,'Leptocotis tenuirostris','Leptocotis tenuirostris','Leptocotis tenuirostr',2,0,'','','Claus','a6187da4-8b66-5f37-b850-fc033bf63d5d','Leptocotis tenuirostris (Claus, 1871)','(Claus, 1871)','SPECIES','','Leptocotis','','tenuirostris','','','',NULL,'','','','','','Claus','','','','1871','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('008134e3-166c-4aa0-bfab-d845825f5154','','','Calamagrostis billardierei (R.Br.) Steud.',1,'Calamagrostis billardierei','Calamagrostis billardierei','Calamagrostis billardiere',2,0,'','','R. Br.|Steud.','9f65c0fc-a46c-5822-871e-a855b5ef7932','Calamagrostis billardierei (R.Br.) Steud.','(R.Br.) Steud.','SPECIES','','Calamagrostis','','billardierei','','','',NULL,'Steud.','','','','','R. Br.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('008b6958-48ea-4c14-96c4-387b36d021ea','','','Xylomelasma sordida Réblová',1,'Xylomelasma sordida','Xylomelasma sordida','Xylomelasma sordid',2,0,'','','Réblová','eeb8ac0a-99da-5d29-b666-d21a2fe07c1f','Xylomelasma sordida Réblová','Réblová','SPECIES','','Xylomelasma','','sordida','','','',NULL,'','','','','','Réblová','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('008a1278-e8d7-4edc-8faa-7bb60202baa7','','','Lecidea vitellinaria Nyl.',1,'Lecidea vitellinaria','Lecidea vitellinaria','Lecidea uitellinar',2,0,'','','Nyl.','5b7b54ea-5615-5272-9cd8-8f99ebdab25e','Lecidea vitellinaria Nyl.','Nyl.','SPECIES','','Lecidea','','vitellinaria','','','',NULL,'','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('008800ee-631a-4c4d-927e-b09dd87d3236','','','Geranium pilosum sensu Allan',4,'','','',NULL,NULL,'','','','','Geranium pilosum sensu Allan','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0084c236-d604-4b06-b2d4-d17e0478cd16','','','Chelophyes appendiculata (Eschscholtz, 1829)',1,'Chelophyes appendiculata','Chelophyes appendiculata','Chelophyes appendiculat',2,0,'','','Eschscholtz','9b16cbaa-e17e-5aab-9310-5c2c94e5abd0','Chelophyes appendiculata (Eschscholtz, 1829)','(Eschscholtz, 1829)','SPECIES','','Chelophyes','','appendiculata','','','',NULL,'','','','','','Eschscholtz','','','','1829','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00d639cd-2592-46fc-8a94-5c81a1713501','','','Sarcocystis cruzi (Hasselman, 1923)',1,'Sarcocystis cruzi','Sarcocystis cruzi','Sarcocystis cruz',2,0,'','','Hasselman','6ea0865b-4fda-57fa-ab29-b478ca85b590','Sarcocystis cruzi (Hasselman, 1923)','(Hasselman, 1923)','SPECIES','','Sarcocystis','','cruzi','','','',NULL,'','','','','','Hasselman','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00d1f312-3c0f-4444-bb97-c6d2c87c9816','','','Nuncia paucispinosa Forster, 1954',1,'Nuncia paucispinosa','Nuncia paucispinosa','Nuncia paucispinos',2,0,'','','Forster','6c25e121-7e9f-50fb-b9f5-196fac5e96ca','Nuncia paucispinosa Forster, 1954','Forster, 1954','SPECIES','','Nuncia','','paucispinosa','','','',NULL,'','','','','','Forster','','','','1954','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00d82233-8f35-446b-b013-08f3802d1b14','','','Lama glama (Linnaeus, 1758)',1,'Lama glama','Lama glama','Lama glam',2,0,'','','Linnaeus','85cf7246-bafa-5876-befb-9ce87b1deb92','Lama glama (Linnaeus, 1758)','(Linnaeus, 1758)','SPECIES','','Lama','','glama','','','',NULL,'','','','','','Linnaeus','','','','1758','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00d91e72-0012-4c8f-9e61-1ff2cff96035','','','Cunninghamia infundibulifera Curr.',1,'Cunninghamia infundibulifera','Cunninghamia infundibulifera','Cunninghamia infundibulifer',2,0,'','','Curr.','c5e1a6bc-4f96-5257-8f0c-1152191b54ce','Cunninghamia infundibulifera Curr.','Curr.','SPECIES','','Cunninghamia','','infundibulifera','','','',NULL,'','','','','','Curr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00db9793-0dd4-45cc-b06c-8aeb8151ed35','','','Acanthocolpiata',1,'Acanthocolpiata','Acanthocolpiata','Acanthocolpiata',1,0,'','','','57734512-9b3c-59e0-83bb-70541f02d2c4','Acanthocolpiata','','SUBORDER','Acanthocolpiata','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00db3b46-49c6-4503-bb5f-9bee42b109a9','','','Aeonium haworthii (Salm-Dyck) Webb & Berthel.',1,'Aeonium haworthii','Aeonium haworthii','Aeonium haworth',2,0,'','','Salm-Dyck|Webb|Berthel.','abe39384-4bce-595a-a7c0-7e8361171772','Aeonium haworthii (Salm-Dyck) Webb & Berthel.','(Salm-Dyck) Webb & Berthel.','SPECIES','','Aeonium','','haworthii','','','',NULL,'Webb & Berthel.','','','','','Salm-Dyck','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00db5bb1-cd01-432f-9046-fc9022c70425','','','Corallinales',1,'Corallinales','Corallinales','Corallinales',1,0,'','','','067c8001-ffbf-5712-992a-512d9353ea86','Corallinales','','ORDER','Corallinales','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00e7b5c4-5eb2-42ea-a271-29df11d9f6d6','','','Diploneis novae seelandiae (A.Schmidt) Hustedt',1,'Diploneis novae seelandiae','Diploneis novae seelandiae','Diploneis nou seelandi',3,0,'','','A. Schmidt|Hustedt','41e4a4a1-75e7-5a3c-8b3d-b04843ce7909','Diploneis novae seelandiae (A.Schmidt) Hustedt','(A.Schmidt) Hustedt','SPECIES','','Diploneis','','novae','seelandiae','','',NULL,'Hustedt','','','','','A. Schmidt','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00e99a71-0ab0-467c-9012-5aaa97241783','','','Dimorphoma saxea (Aveskamp, Gruyter & Verkley) L.W. Hou, L. Cai & Crous',1,'Dimorphoma saxea','Dimorphoma saxea','Dimorphoma saxe',2,0,'','','Aveskamp|Gruyter|Verkley|L. W. Hou|L. Cai|Crous','8db38e3e-8c92-51bf-bc31-b44358f930a5','Dimorphoma saxea (Aveskamp, Gruyter & Verkley) L.W. Hou, L. Cai & Crous','(Aveskamp, Gruyter & Verkley) L.W. Hou, L. Cai & Crous','SPECIES','','Dimorphoma','','saxea','','','',NULL,'L. W. Hou, L. Cai & Crous','','','','','Aveskamp, Gruyter & Verkley','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00ee17cb-b902-470b-95f3-10bf5574dcb1','','','Hercinothrips',1,'Hercinothrips','Hercinothrips','Hercinothrips',1,0,'','','','8234c3da-d546-5027-8731-c8b1b5936718','Hercinothrips','','GENUS','Hercinothrips','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00eb5587-29d3-4624-a968-33c6633ca38f','','','Waiporia chathamensis Forster & Platnick, 1985',1,'Waiporia chathamensis','Waiporia chathamensis','Waiporia chathamens',2,0,'','','Forster|Platnick','6c05edf1-e71b-5d41-893b-3dcd01af6a23','Waiporia chathamensis Forster & Platnick, 1985','Forster & Platnick, 1985','SPECIES','','Waiporia','','chathamensis','','','',NULL,'','','','','','Forster & Platnick','','','','1985','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00ee52ee-de95-456c-894e-8086aee69822','','','Malachiinae',1,'Malachiinae','Malachiinae','Malachiinae',1,0,'','','','cba04d02-4ac2-51d3-b29d-6e51c41e0ddb','Malachiinae','','SUBFAMILY','Malachiinae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00ea9b8b-88ab-4f8f-8403-abde79f54198','','','Anthemis L.',1,'Anthemis','Anthemis','Anthemis',1,0,'','','L.','defbf6a2-3bd5-507c-ba1a-9cd1237a7de9','Anthemis L.','L.','GENUS','Anthemis','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00ea85df-4155-4355-aa2a-f983ef3b869a','','','Eucalyptus dendromorpha (Blakely) L.A.S.Johnson & Blaxell',1,'Eucalyptus dendromorpha','Eucalyptus dendromorpha','Eucalyptus dendromorph',2,0,'','','Blakely|L. A. S. Johnson|Blaxell','8d3babb4-24dd-590c-becd-aa6ff5f9a3c8','Eucalyptus dendromorpha (Blakely) L.A.S.Johnson & Blaxell','(Blakely) L.A.S.Johnson & Blaxell','SPECIES','','Eucalyptus','','dendromorpha','','','',NULL,'L. A. S. Johnson & Blaxell','','','','','Blakely','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00f9f273-2fd4-49a7-b45c-4eb709a0d2b9','','','Threskiornis molucca strictipennis (Gould)',1,'Threskiornis molucca strictipennis','Threskiornis molucca strictipennis','Threskiornis molucc strictipenn',3,0,'','','Gould','adb37083-e73f-5bd1-953e-a97f74631c22','Threskiornis molucca strictipennis (Gould)','(Gould)','SUBSPECIES','','Threskiornis','','molucca','strictipennis','','',NULL,'','','','','','Gould','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00f668ea-7ed1-42de-b94d-e002538adfb4','','','Hebe angustifolia Cockayne & Allan',1,'Hebe angustifolia','Hebe angustifolia','Hebe angustifol',2,0,'','','Cockayne|Allan','d982b88d-14a4-5984-8454-5af359c579b9','Hebe angustifolia Cockayne & Allan','Cockayne & Allan','SPECIES','','Hebe','','angustifolia','','','',NULL,'','','','','','Cockayne & Allan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00fd342c-337c-4ff9-87ed-090983b1d367','','','Calothrix weberi Schmidle',1,'Calothrix weberi','Calothrix weberi','Calothrix weber',2,0,'','','Schmidle','02aa0812-c6e2-5be0-aac6-8bd94a57ae89','Calothrix weberi Schmidle','Schmidle','SPECIES','','Calothrix','','weberi','','','',NULL,'','','','','','Schmidle','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00fa4800-5a23-4c87-b373-4f55d2e9be71','','','Platanurida marplesi (Salmon, 1941)',1,'Platanurida marplesi','Platanurida marplesi','Platanurida marples',2,0,'','','Salmon','585a98ea-b6af-5c77-84f2-88b826cca4bc','Platanurida marplesi (Salmon, 1941)','(Salmon, 1941)','SPECIES','','Platanurida','','marplesi','','','',NULL,'','','','','','Salmon','','','','1941','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('010086a1-ac0d-4446-904e-82adb9e76a6e','','','Spilosticta cephalariae (Ranoj.) Petr.',1,'Spilosticta cephalariae','Spilosticta cephalariae','Spilosticta cephalari',2,0,'','','Ranoj.|Petr.','273faa67-71c5-5e8f-a034-54f53daaf288','Spilosticta cephalariae (Ranoj.) Petr.','(Ranoj.) Petr.','SPECIES','','Spilosticta','','cephalariae','','','',NULL,'Petr.','','','','','Ranoj.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00fa21f9-caee-4afa-9e42-bedce1da157b','','','Ectreposebastes niger (Fourmanoir, 1971)',1,'Ectreposebastes niger','Ectreposebastes niger','Ectreposebastes niger',2,0,'','','Fourmanoir','3b51be2d-1334-575e-83ff-050498d7f148','Ectreposebastes niger (Fourmanoir, 1971)','(Fourmanoir, 1971)','SPECIES','','Ectreposebastes','','niger','','','',NULL,'','','','','','Fourmanoir','','','','1971','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01070718-bece-454b-8513-35583e54505c','','','Jungermannia nivalis Sw.',1,'Jungermannia nivalis','Jungermannia nivalis','Jungermannia niual',2,0,'','','Sw.','65aab9d0-7271-594d-9aa6-f8a97d8b0944','Jungermannia nivalis Sw.','Sw.','SPECIES','','Jungermannia','','nivalis','','','',NULL,'','','','','','Sw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01059f45-0fe5-4f37-bba2-4ac709d192b4','','','Hypoderma euphorbiae (Rehm) Nannf.',1,'Hypoderma euphorbiae','Hypoderma euphorbiae','Hypoderma euphorbi',2,0,'','','Rehm|Nannf.','f10d7f0c-1a38-5e79-909e-f2fce9c031a2','Hypoderma euphorbiae (Rehm) Nannf.','(Rehm) Nannf.','SPECIES','','Hypoderma','','euphorbiae','','','',NULL,'Nannf.','','','','','Rehm','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01008ffd-9883-4650-a42f-c03373422a18','','','Kunzea ericoides (A.Rich.) Joy Thomps. var. ericoides',1,'Kunzea ericoides ericoides','Kunzea ericoides var. ericoides','Kunzea ericoid ericoid',3,0,'','','','c930c60f-002e-502a-9002-6573980c9dcb','Kunzea ericoides (A.Rich.) Joy Thomps. var. ericoides','','VARIETY','','Kunzea','','ericoides','ericoides','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01101b1f-2412-4944-a9ef-03e861bd3eec','','','Plesiastrea versipora (Lamarck, 1816)',1,'Plesiastrea versipora','Plesiastrea versipora','Plesiastrea uersipor',2,0,'','','Lamarck','1327dabe-8890-5058-ba12-4886f8b3d6a0','Plesiastrea versipora (Lamarck, 1816)','(Lamarck, 1816)','SPECIES','','Plesiastrea','','versipora','','','',NULL,'','','','','','Lamarck','','','','1816','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('010a2eba-778e-4ae5-874f-5e5db5e9514d','','','Aspidothea Syd.',1,'Aspidothea','Aspidothea','Aspidothea',1,0,'','','Syd.','1431ba49-fcbd-5e1c-b3f0-192b5666e418','Aspidothea Syd.','Syd.','GENUS','Aspidothea','','','','','','',NULL,'','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('010fd8c5-3aaf-4dcd-84ed-7cc2eac8dfd6','','','Dichelesthidae',1,'Dichelesthidae','Dichelesthidae','Dichelesthidae',1,0,'','','','6f85fdf4-83f0-54c0-84c6-628a4d82dd18','Dichelesthidae','','FAMILY','Dichelesthidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('010c9bb2-60d0-4dd1-be80-a184e12a717e','','','Veronica macrantha var. brachyphylla Cheeseman',1,'Veronica macrantha brachyphylla','Veronica macrantha var. brachyphylla','Veronica macranth brachyphyll',3,0,'','','Cheeseman','0ea0ff2a-fe29-5fff-880d-46d2d98bd895','Veronica macrantha var. brachyphylla Cheeseman','Cheeseman','VARIETY','','Veronica','','macrantha','brachyphylla','','',NULL,'','','','','','Cheeseman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01105398-1618-44b7-bca2-c13e2f19ff12','','','Aneuma rufa Broun, 1921',1,'Aneuma rufa','Aneuma rufa','Aneuma ruf',2,0,'','','Broun','3e3f0b45-dc34-55bc-8942-3c0cdc0a8a35','Aneuma rufa Broun, 1921','Broun, 1921','SPECIES','','Aneuma','','rufa','','','',NULL,'','','','','','Broun','','','','1921','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01127b71-764d-43ce-9003-535b4e8d6f63','','','Lamproderma violaceum var. sauteri (Rostaf.) Lister',1,'Lamproderma violaceum sauteri','Lamproderma violaceum var. sauteri','Lamproderma uiolace sauter',3,0,'','','Rostaf.|Lister','42cc34c3-7852-57ad-94e7-b41d25a8e852','Lamproderma violaceum var. sauteri (Rostaf.) Lister','(Rostaf.) Lister','VARIETY','','Lamproderma','','violaceum','sauteri','','',NULL,'Lister','','','','','Rostaf.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('011b9dfd-b595-45e0-b338-7a6c5dd3fcae','','','Helichrysum selago var. acutum Cheeseman',1,'Helichrysum selago acutum','Helichrysum selago var. acutum','Helichrysum selag acut',3,0,'','','Cheeseman','95421b6b-7a43-5e96-a77f-e0b01c5920f2','Helichrysum selago var. acutum Cheeseman','Cheeseman','VARIETY','','Helichrysum','','selago','acutum','','',NULL,'','','','','','Cheeseman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('011a5c66-99e2-48ae-b358-a2d4d754771a','','','Dysnocryptus maculifer Broun, 1893',1,'Dysnocryptus maculifer','Dysnocryptus maculifer','Dysnocryptus maculifer',2,0,'','','Broun','6bc5598a-402c-5f17-9eb1-d2ad1129b4b9','Dysnocryptus maculifer Broun, 1893','Broun, 1893','SPECIES','','Dysnocryptus','','maculifer','','','',NULL,'','','','','','Broun','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01217367-384d-4e3b-9f52-1c412a534781','','','Bilimbia allotropa (Nyl.) Hellb.',1,'Bilimbia allotropa','Bilimbia allotropa','Bilimbia allotrop',2,0,'','','Nyl.|Hellb.','08e42453-430a-5ffa-9a4a-c4e00bae4d7a','Bilimbia allotropa (Nyl.) Hellb.','(Nyl.) Hellb.','SPECIES','','Bilimbia','','allotropa','','','',NULL,'Hellb.','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('011bcefa-4578-4d47-bd8c-5b5f3a5a97d0','','','Marthamyces barbatus P.R. Johnst.',1,'Marthamyces barbatus','Marthamyces barbatus','Marthamyces barbat',2,0,'','','P. R. Johnst.','72854582-b8af-51e5-a184-2dbab3eaaa77','Marthamyces barbatus P.R. Johnst.','P.R. Johnst.','SPECIES','','Marthamyces','','barbatus','','','',NULL,'','','','','','P. R. Johnst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01c3df99-32ad-425e-91e3-08a06b456532','','','Gunnera prorepens Hook.f.',1,'Gunnera prorepens','Gunnera prorepens','Gunnera prorepens',2,0,'','','Hook. fil.','22b3d0e8-3ab2-5237-b47f-414fe7f1f535','Gunnera prorepens Hook.f.','Hook.f.','SPECIES','','Gunnera','','prorepens','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01c0bce6-610d-452d-9f10-0df716ce5fa4','','','Arthonia lirellaeformis C.Knight',1,'Arthonia lirellaeformis','Arthonia lirellaeformis','Arthonia lirellaeform',2,0,'','','C. Knight','ea0b5ca4-7267-5059-bc13-d84e426374f5','Arthonia lirellaeformis C.Knight','C.Knight','SPECIES','','Arthonia','','lirellaeformis','','','',NULL,'','','','','','C. Knight','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01c3f1c0-a1b7-44c7-83c0-5dd3fbf9d3c6','','','Drepanocladus uncinatus (Hedw.) Warnst.',1,'Drepanocladus uncinatus','Drepanocladus uncinatus','Drepanocladus uncinat',2,0,'','','Hedw.|Warnst.','6dab04b2-85bf-5a8b-aa8f-c32b634aeb14','Drepanocladus uncinatus (Hedw.) Warnst.','(Hedw.) Warnst.','SPECIES','','Drepanocladus','','uncinatus','','','',NULL,'Warnst.','','','','','Hedw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01bf39f9-dc09-4aae-8ffd-8ffa01fd3fa8','','','Trachytetra',1,'Trachytetra','Trachytetra','Trachytetra',1,0,'','','','fcaf23e0-a80f-58bb-885f-1900cfe81373','Trachytetra','','GENUS','Trachytetra','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01bd75f5-ac9f-4d31-b8e7-b8d8a5d70dad','','','Zeadelium aeratum (Broun, 1880)',1,'Zeadelium aeratum','Zeadelium aeratum','Zeadelium aerat',2,0,'','','Broun','82a1cc78-b70f-5571-a82c-c3b8151e809b','Zeadelium aeratum (Broun, 1880)','(Broun, 1880)','SPECIES','','Zeadelium','','aeratum','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01c90f1c-f341-418b-b02e-1c9d8bda4f6d','','','Pannaria elixii P.M.Jørg. & D.J.Galloway',1,'Pannaria elixii','Pannaria elixii','Pannaria elix',2,0,'','','P. M. Jørg.|D. J. Galloway','9b27d84b-470b-5bd2-a92e-6c7f91c8344d','Pannaria elixii P.M.Jørg. & D.J.Galloway','P.M.Jørg. & D.J.Galloway','SPECIES','','Pannaria','','elixii','','','',NULL,'','','','','','P. M. Jørg. & D. J. Galloway','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01cec444-8cdf-46ff-b2ad-0783c3662202','','','Kermatia',1,'Kermatia','Kermatia','Kermatia',1,0,'','','','375da805-3498-5446-ba64-5494bea7a7e7','Kermatia','','GENUS','Kermatia','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01d2b68e-ddc3-4dd7-9f5e-0c5cac68d862','','','Davainea proglottina (Davaine, 1860)',1,'Davainea proglottina','Davainea proglottina','Davainea proglottin',2,0,'','','Davaine','d469e8ef-96bf-5420-b772-f0262517240e','Davainea proglottina (Davaine, 1860)','(Davaine, 1860)','SPECIES','','Davainea','','proglottina','','','',NULL,'','','','','','Davaine','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01cefdb0-49b1-4fde-82d7-43b3039a91bf','','','Penicillium nikau F.J. Morton',1,'Penicillium nikau','Penicillium nikau','Penicillium nika',2,0,'','','F. J. Morton','c8c0d38e-883a-5a25-bd2c-230cb30970cd','Penicillium nikau F.J. Morton','F.J. Morton','SPECIES','','Penicillium','','nikau','','','',NULL,'','','','','','F. J. Morton','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01d1a8ec-819d-4b1d-b2a0-c9607c9cebc5','','','Grevillea sulphurea A.Cunn.',1,'Grevillea sulphurea','Grevillea sulphurea','Grevillea sulphure',2,0,'','','A. Cunn.','bbf86c51-5213-5a05-9f5c-68853e084402','Grevillea sulphurea A.Cunn.','A.Cunn.','SPECIES','','Grevillea','','sulphurea','','','',NULL,'','','','','','A. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01df5cae-3eeb-45a8-827e-11d94a3e0b7c','','','Tanea lemniscata (Philippi, 1852)',1,'Tanea lemniscata','Tanea lemniscata','Tanea lemniscat',2,0,'','','Philippi','d26bbaec-1b63-56ad-b8f7-0cf9274a7a05','Tanea lemniscata (Philippi, 1852)','(Philippi, 1852)','SPECIES','','Tanea','','lemniscata','','','',NULL,'','','','','','Philippi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01d99840-8dbf-43cb-84e2-8f36be7ee6c2','','','Peronella',1,'Peronella','Peronella','Peronella',1,0,'','','','7000ce09-f955-5b99-aa4e-61739d9743fa','Peronella','','GENUS','Peronella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01d77a2f-809c-4ee5-989f-ac4c292afd54','','','Humidicutis horakii J.A. Cooper',1,'Humidicutis horakii','Humidicutis horakii','Humidicutis horak',2,0,'','','J. A. Cooper','5c943516-948a-5d8e-b21f-522958157e29','Humidicutis horakii J.A. Cooper','J.A. Cooper','SPECIES','','Humidicutis','','horakii','','','',NULL,'','','','','','J. A. Cooper','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01dd968c-7b4b-4608-9715-e96330fede5e','','','Hypericum pusillum Choisy',1,'Hypericum pusillum','Hypericum pusillum','Hypericum pusill',2,0,'','','Choisy','e763bf4d-1bf5-569a-944b-4e5bbe03fae8','Hypericum pusillum Choisy','Choisy','SPECIES','','Hypericum','','pusillum','','','',NULL,'','','','','','Choisy','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01e5f929-c819-4b7e-9b25-14ae7413d758','','','Parsonsia capsularis var. ochracea (Colenso) Allan',1,'Parsonsia capsularis ochracea','Parsonsia capsularis var. ochracea','Parsonsia capsular ochrace',3,0,'','','Colenso|Allan','22c9471c-3d67-5617-a202-10f87044400a','Parsonsia capsularis var. ochracea (Colenso) Allan','(Colenso) Allan','VARIETY','','Parsonsia','','capsularis','ochracea','','',NULL,'Allan','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01e40a76-c00e-4852-ad4c-361066006201','','','Armillariella limonea G. Stev.',1,'Armillariella limonea','Armillariella limonea','Armillariella limone',2,0,'','','G. Stev.','8c466fda-d2f7-5f75-9aa0-50ceda2ca75c','Armillariella limonea G. Stev.','G. Stev.','SPECIES','','Armillariella','','limonea','','','',NULL,'','','','','','G. Stev.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01e0d562-ed95-4212-bc47-89c81e9e11f2','','','Ulothrix zonata (Weber & Mohr) Kütz.',1,'Ulothrix zonata','Ulothrix zonata','Ulothrix zonat',2,0,'','','Weber|Mohr|Kütz.','80451df4-234e-5592-8dd6-ad9a854ae9d1','Ulothrix zonata (Weber & Mohr) Kütz.','(Weber & Mohr) Kütz.','SPECIES','','Ulothrix','','zonata','','','',NULL,'Kütz.','','','','','Weber & Mohr','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01e4f775-04d0-4cb4-b9de-f6c20f710136','','','Pseudisograptus juangxiensis (Yu & Fang, 1981)',1,'Pseudisograptus juangxiensis','Pseudisograptus juangxiensis','Pseudisograptus iuangxiens',2,0,'','','Yu|Fang','6166e1b6-6544-5454-acaf-de593cee41c4','Pseudisograptus juangxiensis (Yu & Fang, 1981)','(Yu & Fang, 1981)','SPECIES','','Pseudisograptus','','juangxiensis','','','',NULL,'','','','','','Yu & Fang','','','','1981','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01ebb71d-86ce-4257-b0a0-63a240b28f96','','','Protohystricia gourlayi (Tonnoir, 1935)',1,'Protohystricia gourlayi','Protohystricia gourlayi','Protohystricia gourlay',2,0,'','','Tonnoir','7b369631-9e86-530c-a642-3597c6e64560','Protohystricia gourlayi (Tonnoir, 1935)','(Tonnoir, 1935)','SPECIES','','Protohystricia','','gourlayi','','','',NULL,'','','','','','Tonnoir','','','','1935','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01eb93bc-e4e3-4884-ab38-ad35bfc3f023','','','Philonaster species H. E. S. Clark, 2001',4,'','','',NULL,NULL,'','','','','Philonaster species H. E. S. Clark, 2001','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01f15a1e-49dc-430f-9ef5-29279ca90602','','','Pristomerus foureckensis Klopfstein, 2016',1,'Pristomerus foureckensis','Pristomerus foureckensis','Pristomerus foureckens',2,0,'','','Klopfstein','299ca77b-88e4-55ef-aa29-08913bf6f6aa','Pristomerus foureckensis Klopfstein, 2016','Klopfstein, 2016','SPECIES','','Pristomerus','','foureckensis','','','',NULL,'','','','','','Klopfstein','','','','2016','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01ef871d-d426-4b67-aa28-45ebed0bb1be','','','Echinophallus seriolellae Korotaeva, 1975',1,'Echinophallus seriolellae','Echinophallus seriolellae','Echinophallus seriolell',2,0,'','','Korotaeva','f44c9f77-1880-5cf9-8a80-944e3dbc992d','Echinophallus seriolellae Korotaeva, 1975','Korotaeva, 1975','SPECIES','','Echinophallus','','seriolellae','','','',NULL,'','','','','','Korotaeva','','','','1975','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01f4b7cc-b66b-41ba-86b5-852f081f3f7d','','','Molopsida propinqua (Broun, 1917)',1,'Molopsida propinqua','Molopsida propinqua','Molopsida propinqu',2,0,'','','Broun','faa934b5-0717-535c-939f-055248622946','Molopsida propinqua (Broun, 1917)','(Broun, 1917)','SPECIES','','Molopsida','','propinqua','','','',NULL,'','','','','','Broun','','','','1917','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01f185c5-9c3e-4a99-977a-bd23debda371','','','Haastia sinclairii var. fulvida Allan',1,'Haastia sinclairii fulvida','Haastia sinclairii var. fulvida','Haastia sinclair fuluid',3,0,'','','Allan','d482621c-1b2c-5b1e-bb0d-93a67c370b13','Haastia sinclairii var. fulvida Allan','Allan','VARIETY','','Haastia','','sinclairii','fulvida','','',NULL,'','','','','','Allan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01f7871a-6a94-413a-b59d-209a8dd2facf','','','Ectopleura multicirrata Schuchert, 1996',1,'Ectopleura multicirrata','Ectopleura multicirrata','Ectopleura multicirrat',2,0,'','','Schuchert','af980e43-7883-5f50-af6c-63d73a3340f0','Ectopleura multicirrata Schuchert, 1996','Schuchert, 1996','SPECIES','','Ectopleura','','multicirrata','','','',NULL,'','','','','','Schuchert','','','','1996','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01f620e1-7271-44df-8199-518b977ff1cf','','','Eudyptes filholi Hutton, 1879',1,'Eudyptes filholi','Eudyptes filholi','Eudyptes filhol',2,0,'','','Hutton','ec335840-8813-5217-81ae-60109c02e5ed','Eudyptes filholi Hutton, 1879','Hutton, 1879','SPECIES','','Eudyptes','','filholi','','','',NULL,'','','','','','Hutton','','','','1879','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01fdb7f6-994f-4762-9009-b1319d2e34a5','','','Ascyrum humifusum Labill.',1,'Ascyrum humifusum','Ascyrum humifusum','Ascyrum humifus',2,0,'','','Labill.','612d3c33-968a-524e-892c-09c49b28c737','Ascyrum humifusum Labill.','Labill.','SPECIES','','Ascyrum','','humifusum','','','',NULL,'','','','','','Labill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01f726eb-193f-4ef7-8a60-d41d90593534','','','Eolophus',1,'Eolophus','Eolophus','Eolophus',1,0,'','','','aafecc2d-9bea-5dca-9dbb-25f8820f175d','Eolophus','','GENUS','Eolophus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('020010a5-e400-4c39-99e3-23fd90e458f8','','','Grapevine leafroll-associated virus 4',NULL,'','','',NULL,NULL,'','','','','Grapevine leafroll-associated virus 4','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02027a72-3d05-45ff-9850-3013a4fb6a15','','','Brounea chorui Park & Carlton, 2015',1,'Brounea chorui','Brounea chorui','Brounea choru',2,0,'','','Park|Carlton','03a3ee71-adeb-5c55-ae5a-a2afce804a30','Brounea chorui Park & Carlton, 2015','Park & Carlton, 2015','SPECIES','','Brounea','','chorui','','','',NULL,'','','','','','Park & Carlton','','','','2015','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0201a4c6-3c23-47e9-afe0-872b982e8352','','','Mycosphaerella junciginea (Cooke) Lindau',1,'Mycosphaerella junciginea','Mycosphaerella junciginea','Mycosphaerella iuncigine',2,0,'','','Cooke|Lindau','e42a5f47-d40b-5f09-86f6-75c12b70fcc0','Mycosphaerella junciginea (Cooke) Lindau','(Cooke) Lindau','SPECIES','','Mycosphaerella','','junciginea','','','',NULL,'Lindau','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02045e11-d73f-4b3b-a217-c385c63cd7f9','','','Bussabanomyces longisporus (Bussaban) Klaubauf, Lebrun & Crous',1,'Bussabanomyces longisporus','Bussabanomyces longisporus','Bussabanomyces longispor',2,0,'','','Bussaban|Klaubauf|Lebrun|Crous','77c020d1-3fbe-50ee-9494-974f3ff64f38','Bussabanomyces longisporus (Bussaban) Klaubauf, Lebrun & Crous','(Bussaban) Klaubauf, Lebrun & Crous','SPECIES','','Bussabanomyces','','longisporus','','','',NULL,'Klaubauf, Lebrun & Crous','','','','','Bussaban','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('020a036c-3e67-4c61-ae7a-b410bac64da6','','','Echinostoma',1,'Echinostoma','Echinostoma','Echinostoma',1,0,'','','','44d3baad-9bb7-5336-88e9-8f13fe3b90e6','Echinostoma','','GENUS','Echinostoma','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02080c4f-c1c3-47ec-81b8-cae0277bbb89','','','Agropyron subeglume P.Candargy',1,'Agropyron subeglume','Agropyron subeglume','Agropyron subeglum',2,0,'','','P. Candargy','03989754-e77c-57be-8848-60084029ca80','Agropyron subeglume P.Candargy','P.Candargy','SPECIES','','Agropyron','','subeglume','','','',NULL,'','','','','','P. Candargy','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('012c9cd8-663d-484d-884d-3e72cc064e6e','','','Lysimachia vulgaris L.',1,'Lysimachia vulgaris','Lysimachia vulgaris','Lysimachia uulgar',2,0,'','','L.','bfbea475-abd8-51d8-bcb4-db38e07fd463','Lysimachia vulgaris L.','L.','SPECIES','','Lysimachia','','vulgaris','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('012888c0-63e9-4268-ac6c-7420af517900','','','Polystictus sector (Ehrenb.) Cooke',1,'Polystictus sector','Polystictus sector','Polystictus sector',2,0,'','','Ehrenb.|Cooke','18eadde2-b174-510b-93ca-6966dce803f4','Polystictus sector (Ehrenb.) Cooke','(Ehrenb.) Cooke','SPECIES','','Polystictus','','sector','','','',NULL,'Cooke','','','','','Ehrenb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01263894-9315-4fe3-ab07-a65b4a90b3fd','','','Exochella',1,'Exochella','Exochella','Exochella',1,0,'','','','e80e280f-55f7-55bd-bb41-76c0ef8200f7','Exochella','','GENUS','Exochella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01287926-6a51-45d5-bfb6-bb9328efe66f','','','Austropsocus fasciatus Thornton, Wong & Smithers, 1977',1,'Austropsocus fasciatus','Austropsocus fasciatus','Austropsocus fasciat',2,0,'','','Thornton|Wong|Smithers','a5a5446b-877a-50b5-81be-2cf51d4fe9b9','Austropsocus fasciatus Thornton, Wong & Smithers, 1977','Thornton, Wong & Smithers, 1977','SPECIES','','Austropsocus','','fasciatus','','','',NULL,'','','','','','Thornton, Wong & Smithers','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('012fbba6-c857-4cde-9fa4-0a32f69766b6','','','Navicula halophila (Grunow) Cleve',1,'Navicula halophila','Navicula halophila','Navicula halophil',2,0,'','','Grunow|Cleve','6e29ef02-28fb-5d5f-82b0-13114e2fd048','Navicula halophila (Grunow) Cleve','(Grunow) Cleve','SPECIES','','Navicula','','halophila','','','',NULL,'Cleve','','','','','Grunow','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0130d890-48b7-4088-a597-61e947804715','','','Galiteuthis',1,'Galiteuthis','Galiteuthis','Galiteuthis',1,0,'','','','81b58d28-3d4d-5a7f-a06f-e8d093d80a07','Galiteuthis','','GENUS','Galiteuthis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('013471fb-e742-4e08-af5a-823f56bae17e','','','Chlorovibrissea tasmanica (Rodway) L.M. Kohn',1,'Chlorovibrissea tasmanica','Chlorovibrissea tasmanica','Chlorovibrissea tasmanic',2,0,'','','Rodway|L. M. Kohn','56301510-2574-55f0-8ea8-ee67e398af10','Chlorovibrissea tasmanica (Rodway) L.M. Kohn','(Rodway) L.M. Kohn','SPECIES','','Chlorovibrissea','','tasmanica','','','',NULL,'L. M. Kohn','','','','','Rodway','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('012e6e7c-c333-4a07-a4fb-c9fe3861bc8b','','','Axylita',1,'Axylita','Axylita','Axylita',1,0,'','','','886982b3-85da-5eac-94ac-a6feceba5253','Axylita','','GENUS','Axylita','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0134898b-d332-4698-9ce1-e53f6d83da1e','','','Mortierella camargensis W. Gams & R. Moreau',1,'Mortierella camargensis','Mortierella camargensis','Mortierella camargens',2,0,'','','W. Gams|R. Moreau','0dd6ed06-f2df-5600-b0a3-5e6178483b56','Mortierella camargensis W. Gams & R. Moreau','W. Gams & R. Moreau','SPECIES','','Mortierella','','camargensis','','','',NULL,'','','','','','W. Gams & R. Moreau','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01360e7d-bffd-486e-800f-07e7b636b1c7','','','Saropogon fascipes Hutton, 1902',1,'Saropogon fascipes','Saropogon fascipes','Saropogon fascip',2,0,'','','Hutton','a2c6cc0e-c2fa-508b-8f42-add4a1e79e61','Saropogon fascipes Hutton, 1902','Hutton, 1902','SPECIES','','Saropogon','','fascipes','','','',NULL,'','','','','','Hutton','','','','1902','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01371617-03bd-45cf-8fc1-378bc03acec3','','','Katodinium bohemicum (Fott)',1,'Katodinium bohemicum','Katodinium bohemicum','Katodinium bohemic',2,0,'','','Fott','110cb84c-4b0e-57f9-8db9-c3684e6a9eab','Katodinium bohemicum (Fott)','(Fott)','SPECIES','','Katodinium','','bohemicum','','','',NULL,'','','','','','Fott','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('013787e6-6ade-43b7-bcd5-8ebd726d2a90','','','Irenopsis F. Stevens',1,'Irenopsis','Irenopsis','Irenopsis',1,0,'','','F. Stevens','7fea9ce9-4abd-5ba5-a932-3ab02cc8aa52','Irenopsis F. Stevens','F. Stevens','GENUS','Irenopsis','','','','','','',NULL,'','','','','','F. Stevens','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0137fd24-203a-4e6f-b2ca-a5fdeae928aa','','','Carpobrotus glaucescens (Haw.) Schwantes',1,'Carpobrotus glaucescens','Carpobrotus glaucescens','Carpobrotus glaucescens',2,0,'','','Haw.|Schwantes','5ec8bf80-52bc-52e7-84b6-7329dd275174','Carpobrotus glaucescens (Haw.) Schwantes','(Haw.) Schwantes','SPECIES','','Carpobrotus','','glaucescens','','','',NULL,'Schwantes','','','','','Haw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01470672-d413-4dbe-a6d1-1fda6c13aeff','','','Puffinus puffinus newelli Henshaw',1,'Puffinus puffinus newelli','Puffinus puffinus newelli','Puffinus puffin newell',3,0,'','','Henshaw','beada896-bee0-51ac-bbc9-ad360be02af9','Puffinus puffinus newelli Henshaw','Henshaw','SUBSPECIES','','Puffinus','','puffinus','newelli','','',NULL,'','','','','','Henshaw','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0147b418-5b97-4f37-81f4-521fab925c4a','','','Coprinus ephemerus sensu Colenso',4,'','','',NULL,NULL,'','','','','Coprinus ephemerus sensu Colenso','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01464f3c-1ec2-49eb-9c32-7575124e768d','','','Allogalumna',1,'Allogalumna','Allogalumna','Allogalumna',1,0,'','','','33c921de-d92a-5dda-8668-bcce71adb3e7','Allogalumna','','GENUS','Allogalumna','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0146f480-a4f9-48cd-a68e-849bf947590b','','','Islandiella',1,'Islandiella','Islandiella','Islandiella',1,0,'','','','f21e3b1c-12d1-5ccd-9c42-fa3d4f864262','Islandiella','','GENUS','Islandiella','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01456ea6-0907-43b2-8a51-8ee57e9011e7','','','Trichoderma cerinum Bissett, C.P. Kubicek & Szakacs',1,'Trichoderma cerinum','Trichoderma cerinum','Trichoderma cerin',2,0,'','','Bissett|C. P. Kubicek|Szakacs','609e8ffd-1dbd-5395-a0a6-3fbbbc74a112','Trichoderma cerinum Bissett, C.P. Kubicek & Szakacs','Bissett, C.P. Kubicek & Szakacs','SPECIES','','Trichoderma','','cerinum','','','',NULL,'','','','','','Bissett, C. P. Kubicek & Szakacs','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('014c0cb5-e96f-4f8a-99b7-6651a66a8a20','','','Nitella flexilis (L.) Agardh',1,'Nitella flexilis','Nitella flexilis','Nitella flexil',2,0,'','','L.|Agardh','e16f025b-8c25-5645-a76f-d3948e1bf5f1','Nitella flexilis (L.) Agardh','(L.) Agardh','SPECIES','','Nitella','','flexilis','','','',NULL,'Agardh','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('014c8671-cde6-4b58-b325-9a0ddfa0cac8','','','Puccinia subcircinata Ellis & Everh.',1,'Puccinia subcircinata','Puccinia subcircinata','Puccinia subcircinat',2,0,'','','Ellis|Everh.','19ca5bae-87ef-5698-ab38-51e51d3da985','Puccinia subcircinata Ellis & Everh.','Ellis & Everh.','SPECIES','','Puccinia','','subcircinata','','','',NULL,'','','','','','Ellis & Everh.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('014c9d70-76eb-42a9-8ad1-ca71935db5ae','','','Microsilpha litorea Broun, 1886',1,'Microsilpha litorea','Microsilpha litorea','Microsilpha litore',2,0,'','','Broun','9f8d92ec-535a-5669-b09c-1a3069a246eb','Microsilpha litorea Broun, 1886','Broun, 1886','SPECIES','','Microsilpha','','litorea','','','',NULL,'','','','','','Broun','','','','1886','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('014b1d2a-1c4e-4c10-8e72-f75818eaa5a5','','','Tropopterus patulus Broun, 1881',1,'Tropopterus patulus','Tropopterus patulus','Tropopterus patul',2,0,'','','Broun','e0026293-7ed1-51a4-90c6-90e9366ea8d7','Tropopterus patulus Broun, 1881','Broun, 1881','SPECIES','','Tropopterus','','patulus','','','',NULL,'','','','','','Broun','','','','1881','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('014fe59d-aef2-40dc-8e53-40aba6aa0ea0','','','Maorinus maketuensis (Franz, 1980)',1,'Maorinus maketuensis','Maorinus maketuensis','Maorinus maketuens',2,0,'','','Franz','d66a1d04-d5da-5ef0-80ab-5ab84ee87413','Maorinus maketuensis (Franz, 1980)','(Franz, 1980)','SPECIES','','Maorinus','','maketuensis','','','',NULL,'','','','','','Franz','','','','1980','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0152f66a-cdd5-4acf-a724-bcd4506bce6a','','','Synchytrium limosellae Karling',1,'Synchytrium limosellae','Synchytrium limosellae','Synchytrium limosell',2,0,'','','Karling','b86ba7bf-2805-510a-8b30-b462709e67d7','Synchytrium limosellae Karling','Karling','SPECIES','','Synchytrium','','limosellae','','','',NULL,'','','','','','Karling','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('015aed4c-ade6-447c-9ced-0ccbb5683c64','','','Lachnum ellipsosporum Spooner',1,'Lachnum ellipsosporum','Lachnum ellipsosporum','Lachnum ellipsospor',2,0,'','','Spooner','33ac03bc-389a-5595-be4f-610f9935c749','Lachnum ellipsosporum Spooner','Spooner','SPECIES','','Lachnum','','ellipsosporum','','','',NULL,'','','','','','Spooner','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('015a056f-c459-4714-b981-4bc06cd0dc95','','','Hapalosiphon',1,'Hapalosiphon','Hapalosiphon','Hapalosiphon',1,0,'','','','06464215-8e64-52c7-8b53-218f129d713c','Hapalosiphon','','GENUS','Hapalosiphon','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('015afbe6-dbe3-4eda-a28b-6edbe8c06da6','','','Oedogonium chapmanii Tiffany',1,'Oedogonium chapmanii','Oedogonium chapmanii','Oedogonium chapman',2,0,'','','Tiffany','f6c879e7-775a-54f0-896e-9db673f7dbea','Oedogonium chapmanii Tiffany','Tiffany','SPECIES','','Oedogonium','','chapmanii','','','',NULL,'','','','','','Tiffany','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0158efbd-a6bc-44e1-8774-94e7fb21b738','','','Putilla neozelanica (Suter, 1898)',1,'Putilla neozelanica','Putilla neozelanica','Putilla neozelanic',2,0,'','','Suter','62f96ffd-66f0-5434-80e0-535598d8ea1c','Putilla neozelanica (Suter, 1898)','(Suter, 1898)','SPECIES','','Putilla','','neozelanica','','','',NULL,'','','','','','Suter','','','','1898','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('015ffff1-46b2-426b-9ba8-3f346930064d','','','Gemmabryum ruderale (Crundw. & Nyholm) J.R.Spence',1,'Gemmabryum ruderale','Gemmabryum ruderale','Gemmabryum ruderal',2,0,'','','Crundw.|Nyholm|J. R. Spence','9a36fa27-7bff-54be-9d44-37483c99fd3e','Gemmabryum ruderale (Crundw. & Nyholm) J.R.Spence','(Crundw. & Nyholm) J.R.Spence','SPECIES','','Gemmabryum','','ruderale','','','',NULL,'J. R. Spence','','','','','Crundw. & Nyholm','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0165a107-047f-42e0-9ead-62e9ce50b5de','','','Asthenothaerus maxwelli B. Marshall, 2002',1,'Asthenothaerus maxwelli','Asthenothaerus maxwelli','Asthenothaerus maxwell',2,0,'','','B. Marshall','57890d16-727b-51ad-8fe8-bed175a5f9c4','Asthenothaerus maxwelli B. Marshall, 2002','B. Marshall, 2002','SPECIES','','Asthenothaerus','','maxwelli','','','',NULL,'','','','','','B. Marshall','','','','2002','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0163aa8e-c631-4991-bff3-d1405b285d05','','','Ensete ventricosum (Welw.) Cheesman',1,'Ensete ventricosum','Ensete ventricosum','Ensete uentricos',2,0,'','','Welw.|Cheesman','36cd53c1-db8b-56e4-a458-ef5fcb54a23d','Ensete ventricosum (Welw.) Cheesman','(Welw.) Cheesman','SPECIES','','Ensete','','ventricosum','','','',NULL,'Cheesman','','','','','Welw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('016a0858-c86e-4830-9aca-160a517e352e','','','Hebe arganthera Garn.-Jones, Bayly, W.G.Lee & Rance',1,'Hebe arganthera','Hebe arganthera','Hebe arganther',2,0,'','','Garn.-Jones|Bayly|W. G. Lee|Rance','70962eee-8b50-56e4-95f1-60cac881407a','Hebe arganthera Garn.-Jones, Bayly, W.G.Lee & Rance','Garn.-Jones, Bayly, W.G.Lee & Rance','SPECIES','','Hebe','','arganthera','','','',NULL,'','','','','','Garn.-Jones, Bayly, W. G. Lee & Rance','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0166ef03-f8cc-42e8-a9af-d96b08f40a18','','','Lobariaceae Chevall.',1,'Lobariaceae','Lobariaceae','Lobariaceae',1,0,'','','Chevall.','7309c3ef-c5ff-5222-8ecd-0fd26ab8ccad','Lobariaceae Chevall.','Chevall.','FAMILY','Lobariaceae','','','','','','',NULL,'','','','','','Chevall.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0173264e-88f2-459c-9d2c-7a05c8ca9fde','','','Tortrix encausta Meyrick, 1907',1,'Tortrix encausta','Tortrix encausta','Tortrix encaust',2,0,'','','Meyrick','119bc914-e8b2-5588-973c-af1c8be07092','Tortrix encausta Meyrick, 1907','Meyrick, 1907','SPECIES','','Tortrix','','encausta','','','',NULL,'','','','','','Meyrick','','','','1907','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0172b982-f5ee-483a-8510-af3e6ab5b6e5','','','Gottschea conchophylla (E.A.Hodgs. & Allison) Grolle & Zijlstra var. conchophylla',1,'Gottschea conchophylla conchophylla','Gottschea conchophylla var. conchophylla','Gottschea conchophyll conchophyll',3,0,'','','','ae27bd6e-64a6-5e88-976b-0df50e70c5da','Gottschea conchophylla (E.A.Hodgs. & Allison) Grolle & Zijlstra var. conchophylla','','VARIETY','','Gottschea','','conchophylla','conchophylla','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('016dbcce-3b77-4da7-a3d8-ee184b6e4df1','','','Sphaeria inquinans Tode',1,'Sphaeria inquinans','Sphaeria inquinans','Sphaeria inquinans',2,0,'','','Tode','0cd77652-da7b-5e6a-87b2-3cd5e4d07c8b','Sphaeria inquinans Tode','Tode','SPECIES','','Sphaeria','','inquinans','','','',NULL,'','','','','','Tode','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('020d6f92-f8ac-4adc-b3cd-13db5b0c124d','','','Hemicycliophora halophila Yeates, 1967',1,'Hemicycliophora halophila','Hemicycliophora halophila','Hemicycliophora halophil',2,0,'','','Yeates','d7ca1775-aa43-5504-822f-858575376e20','Hemicycliophora halophila Yeates, 1967','Yeates, 1967','SPECIES','','Hemicycliophora','','halophila','','','',NULL,'','','','','','Yeates','','','','1967','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('020bad28-f5f3-4e86-a4b8-3268527763b0','','','Conchoecia eltaninae Deevey, 1982',1,'Conchoecia eltaninae','Conchoecia eltaninae','Conchoecia eltanin',2,0,'','','Deevey','6620be99-d2e3-51d4-89da-d0f95e962216','Conchoecia eltaninae Deevey, 1982','Deevey, 1982','SPECIES','','Conchoecia','','eltaninae','','','',NULL,'','','','','','Deevey','','','','1982','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('020e6a0c-4576-417b-9136-6757c60e28e6','','','Laurelia novae-zelandiae A.Cunn.',1,'Laurelia novae-zelandiae','Laurelia novae-zelandiae','Laurelia nouae-zelandi',2,0,'','','A. Cunn.','85312b52-7d0b-50c0-a8b0-013d46737e53','Laurelia novae-zelandiae A.Cunn.','A.Cunn.','SPECIES','','Laurelia','','novae-zelandiae','','','',NULL,'','','','','','A. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('020f1fa3-f109-4457-bc7d-d129939b9a4c','','','Siboglinidae',1,'Siboglinidae','Siboglinidae','Siboglinidae',1,0,'','','','3f66f94b-577c-53ff-836a-4c9b1cb34a84','Siboglinidae','','FAMILY','Siboglinidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0219cea3-2ba0-4957-9a94-08b2575780ca','','','Geissorhiza monanthos Eckl.',1,'Geissorhiza monanthos','Geissorhiza monanthos','Geissorhiza monanth',2,0,'','','Eckl.','bdc433eb-8097-5657-892d-27302f2e2be8','Geissorhiza monanthos Eckl.','Eckl.','SPECIES','','Geissorhiza','','monanthos','','','',NULL,'','','','','','Eckl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02153b57-fe0c-44b6-b16c-34201f8cbc43','','','Leontodon nudicaulis sensu New Zealand Botanists',4,'','','',NULL,NULL,'','','','','Leontodon nudicaulis sensu New Zealand Botanists','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02169877-a16a-43de-a2c0-5c8244bc0d96','','','Pleioplectron simplex Hutton, 1896',1,'Pleioplectron simplex','Pleioplectron simplex','Pleioplectron simplex',2,0,'','','Hutton','107ef8cf-0c9d-58bd-8819-9967db9d0f6b','Pleioplectron simplex Hutton, 1896','Hutton, 1896','SPECIES','','Pleioplectron','','simplex','','','',NULL,'','','','','','Hutton','','','','1896','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0219b9d5-5897-4193-a0d3-a472a257b21d','','','Lupinus arboreus Sims',1,'Lupinus arboreus','Lupinus arboreus','Lupinus arbore',2,0,'','','Sims','d3578bca-2bc0-5ea8-a74c-57dd10d0f756','Lupinus arboreus Sims','Sims','SPECIES','','Lupinus','','arboreus','','','',NULL,'','','','','','Sims','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0216388a-455f-4c50-80da-fc4de62a12d9','','','Anchomenus oreobius Broun, 1886',1,'Anchomenus oreobius','Anchomenus oreobius','Anchomenus oreob',2,0,'','','Broun','e5c1052f-28e8-541d-bdff-62a178a05ef1','Anchomenus oreobius Broun, 1886','Broun, 1886','SPECIES','','Anchomenus','','oreobius','','','',NULL,'','','','','','Broun','','','','1886','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('021d23d5-9290-4372-b2f5-319750f1f939','','','Antipodosis rotoiti Jaschhof, 2016',1,'Antipodosis rotoiti','Antipodosis rotoiti','Antipodosis rotoit',2,0,'','','Jaschhof','53c8da46-ccc6-5b10-b7ca-17f0ffdb667a','Antipodosis rotoiti Jaschhof, 2016','Jaschhof, 2016','SPECIES','','Antipodosis','','rotoiti','','','',NULL,'','','','','','Jaschhof','','','','2016','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02214012-9001-4caf-b689-a56414b2fb5d','','','Platypodini',1,'Platypodini','Platypodini','Platypodini',1,0,'','','','7365eba4-dd0d-5430-bc39-dd63a37c6c79','Platypodini','','TRIBE','Platypodini','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('021c56eb-c727-4d0a-85d0-af6c0cf11e2c','','','Gluconacetobacter diazotrophicus (Gillis et al. 1989) Yamada et al., 1998',1,'Gluconacetobacter diazotrophicus','Gluconacetobacter diazotrophicus','Gluconacetobacter diazotrophic',2,0,'','','Gillis et al.|Yamada et al.','6eb0533d-270f-5d82-9956-b83bd1fd0cf4','Gluconacetobacter diazotrophicus (Gillis et al. 1989) Yamada et al., 1998','(Gillis et al. 1989) Yamada et al., 1998','SPECIES','','Gluconacetobacter','','diazotrophicus','','','',NULL,'Yamada et al.','','','','1998','Gillis et al.','','','','1989','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0223b0c2-8a26-4da1-a4e6-2d622238a553','','','Stilla',1,'Stilla','Stilla','Stilla',1,0,'','','','7773f07f-9063-5e9f-b33b-7cd1d34c8c9b','Stilla','','GENUS','Stilla','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('022283df-2bb4-4d22-a630-691a32623ca0','','','Ischnura aurora (Brauer, 1865)',1,'Ischnura aurora','Ischnura aurora','Ischnura auror',2,0,'','','Brauer','1b77b180-7899-5b97-bc5b-36c9a0944aea','Ischnura aurora (Brauer, 1865)','(Brauer, 1865)','SPECIES','','Ischnura','','aurora','','','',NULL,'','','','','','Brauer','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0228448c-4bda-410b-a5d9-b1b381955270','','','Ardissoneales',1,'Ardissoneales','Ardissoneales','Ardissoneales',1,0,'','','','977dab77-92c5-58d1-befc-a8349f639a93','Ardissoneales','','ORDER','Ardissoneales','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('022e3769-8d2e-472e-b94f-0a20cff2ae27','','','Calosciadium Endl.',1,'Calosciadium','Calosciadium','Calosciadium',1,0,'','','Endl.','a5a39d23-9a3f-5283-944f-9c4a29bad229','Calosciadium Endl.','Endl.','GENUS','Calosciadium','','','','','','',NULL,'','','','','','Endl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('022995dc-22b9-4fc8-a531-2df5477f240f','','','Pleurosigma normanii Ralfs',1,'Pleurosigma normanii','Pleurosigma normanii','Pleurosigma norman',2,0,'','','Ralfs','b88c567a-7c0f-5523-a747-d86797f5f812','Pleurosigma normanii Ralfs','Ralfs','SPECIES','','Pleurosigma','','normanii','','','',NULL,'','','','','','Ralfs','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('022df94a-f16d-4bfc-89ad-86511230fed7','','','Ceramaster',1,'Ceramaster','Ceramaster','Ceramaster',1,0,'','','','91d13f6e-356b-5a3d-86c0-15b65ad426a4','Ceramaster','','GENUS','Ceramaster','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('022b0e34-a557-4ff4-b4ed-9ee71c402c2d','','','Agaricus solitarius Bull.',1,'Agaricus solitarius','Agaricus solitarius','Agaricus solitar',2,0,'','','Bull.','4312f085-8c1e-5718-8285-faf01db4597d','Agaricus solitarius Bull.','Bull.','SPECIES','','Agaricus','','solitarius','','','',NULL,'','','','','','Bull.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02345dcc-57e7-49e2-a3a0-132f3e223e1e','','','Gymnosporangium juvenescens F. Kern',1,'Gymnosporangium juvenescens','Gymnosporangium juvenescens','Gymnosporangium iuuenescens',2,0,'','','F. Kern','19841ed2-282d-5154-bad0-3d036ebe94be','Gymnosporangium juvenescens F. Kern','F. Kern','SPECIES','','Gymnosporangium','','juvenescens','','','',NULL,'','','','','','F. Kern','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02334696-468e-4e37-beaa-446b5913bfc4','','','Leonohebe ciliolata (Hook.f.) Heads',1,'Leonohebe ciliolata','Leonohebe ciliolata','Leonohebe ciliolat',2,0,'','','Hook. fil.|Heads','3009f1d8-9f2f-55ef-8c2b-f7b52a79baa0','Leonohebe ciliolata (Hook.f.) Heads','(Hook.f.) Heads','SPECIES','','Leonohebe','','ciliolata','','','',NULL,'Heads','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0231ccf3-6cc3-447f-9530-63a5ea249e2c','','','Encoelia (Fr.) P. Karst.',1,'Encoelia','Encoelia','Encoelia',1,0,'','','Fr.|P. Karst.','23ae1f44-84d9-5ca3-a62b-3d65bc648d74','Encoelia (Fr.) P. Karst.','(Fr.) P. Karst.','GENUS','Encoelia','','','','','','',NULL,'P. Karst.','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0231b0b8-0eb3-475d-8e89-e8cabfc34ae9','','','Scolopini',1,'Scolopini','Scolopini','Scolopini',1,0,'','','','f54d4320-628b-5b44-8536-775d5afaf84e','Scolopini','','TRIBE','Scolopini','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0239bc42-9855-40db-9335-04a947c916c1','','','Pseudognaphalium subgen. Laphangium Hilliard & B.L.Burtt',2,'Laphangium','Pseudognaphalium subgen. Laphangium','Laphangium',1,0,'','','Hilliard|B. L. Burtt','d25fdae0-d18d-50e3-adc4-cfa473ac5cef','Pseudognaphalium subgen. Laphangium Hilliard & B.L.Burtt','Hilliard & B.L.Burtt','SUBGENUS','Laphangium','','','','','','',NULL,'','','','','','Hilliard & B. L. Burtt','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02360c9d-41f5-438d-b253-31b7b1bc9e1f','','','Chaetoscypha mahinapua (P.R. Johnst.) Baral & P.R. Johnst.',1,'Chaetoscypha mahinapua','Chaetoscypha mahinapua','Chaetoscypha mahinapu',2,0,'','','P. R. Johnst.|Baral','a94190e2-6953-5efb-b617-2943ca7a603a','Chaetoscypha mahinapua (P.R. Johnst.) Baral & P.R. Johnst.','(P.R. Johnst.) Baral & P.R. Johnst.','SPECIES','','Chaetoscypha','','mahinapua','','','',NULL,'Baral & P. R. Johnst.','','','','','P. R. Johnst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0238e1fa-9788-4333-b869-babbc4b4b60e','','','Arcobacter cryaerophilus Vandamme et al. 1991',1,'Arcobacter cryaerophilus','Arcobacter cryaerophilus','Arcobacter cryaerophil',2,0,'','','Vandamme et al.','07a823be-a416-5be6-b87e-ebe265c38258','Arcobacter cryaerophilus Vandamme et al. 1991','Vandamme et al. 1991','SPECIES','','Arcobacter','','cryaerophilus','','','',NULL,'','','','','','Vandamme et al.','','','','1991','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('023e3029-2ec2-4b69-9bb5-0b874345e0ee','','','Vertebrata constricta',1,'Vertebrata constricta','Vertebrata constricta','Vertebrata constrict',2,0,'','','','4be37e93-fba3-58c2-8b88-2b2f181ba745','Vertebrata constricta','','SPECIES','','Vertebrata','','constricta','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('023e39ab-a4ca-470e-b53f-131153aef027','','','Agaricus ceres Cooke & Massee',1,'Agaricus ceres','Agaricus ceres','Agaricus cer',2,0,'','','Cooke|Massee','65694b4a-f6b5-5d9f-a046-922ce0a81e56','Agaricus ceres Cooke & Massee','Cooke & Massee','SPECIES','','Agaricus','','ceres','','','',NULL,'','','','','','Cooke & Massee','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('023e5b06-2936-4434-bbe3-a12bf0d0ac77','','','Sticta squamata D.J.Galloway',1,'Sticta squamata','Sticta squamata','Sticta squamat',2,0,'','','D. J. Galloway','a9b0c520-4ff1-5da5-a962-2f726407432c','Sticta squamata D.J.Galloway','D.J.Galloway','SPECIES','','Sticta','','squamata','','','',NULL,'','','','','','D. J. Galloway','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('023d9244-7ca4-4536-b214-f13c4245dc82','','','Gromilus veneris setarius (Broun, 1909)',1,'Gromilus veneris setarius','Gromilus veneris setarius','Gromilus uener setar',3,0,'','','Broun','b08195a6-f8ab-5264-9d6a-a57d0d59c9a6','Gromilus veneris setarius (Broun, 1909)','(Broun, 1909)','SUBSPECIES','','Gromilus','','veneris','setarius','','',NULL,'','','','','','Broun','','','','1909','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0241e739-d22a-4ca5-88d1-09dfd7ebd783','','','Gasparia oparara Forster, 1970',1,'Gasparia oparara','Gasparia oparara','Gasparia oparar',2,0,'','','Forster','102aa140-9697-541f-be63-4fc0ccbee170','Gasparia oparara Forster, 1970','Forster, 1970','SPECIES','','Gasparia','','oparara','','','',NULL,'','','','','','Forster','','','','1970','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02409a5b-3f25-435e-a48b-6b3138a74a4c','','','Ulnaria ulna',1,'Ulnaria ulna','Ulnaria ulna','Ulnaria uln',2,0,'','','','1a0975b4-028c-592a-8d30-a68705bfc919','Ulnaria ulna','','SPECIES','','Ulnaria','','ulna','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02448763-a851-4167-ae51-731ffe376844','','','Orthotrichum cupulatum var. austrocupulatum (Dixon & Sainsbury) Lewinsky',1,'Orthotrichum cupulatum austrocupulatum','Orthotrichum cupulatum var. austrocupulatum','Orthotrichum cupulat austrocupulat',3,0,'','','Dixon|Sainsbury|Lewinsky','30c08948-e83d-5ebe-9bcf-dc2ba582c677','Orthotrichum cupulatum var. austrocupulatum (Dixon & Sainsbury) Lewinsky','(Dixon & Sainsbury) Lewinsky','VARIETY','','Orthotrichum','','cupulatum','austrocupulatum','','',NULL,'Lewinsky','','','','','Dixon & Sainsbury','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0243670f-8c68-4a75-b96a-c0f50d67100b','','','Jaaginema filiforme (J.J.Copel.) Anagn.',1,'Jaaginema filiforme','Jaaginema filiforme','Jaaginema filiform',2,0,'','','J. J. Copel.|Anagn.','f68c7157-ac0e-5c11-8be4-61198b479807','Jaaginema filiforme (J.J.Copel.) Anagn.','(J.J.Copel.) Anagn.','SPECIES','','Jaaginema','','filiforme','','','',NULL,'Anagn.','','','','','J. J. Copel.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02471afa-1f11-4e57-8681-06f8f1068ca5','','','Gelochelidon Brehm',1,'Gelochelidon','Gelochelidon','Gelochelidon',1,0,'','','Brehm','ec0f0b2c-1949-538a-8820-79ab3d9626fe','Gelochelidon Brehm','Brehm','GENUS','Gelochelidon','','','','','','',NULL,'','','','','','Brehm','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('024757b0-c3b0-48b3-bff2-2842c3461c95','','','Blindia magellanica Schimp.',1,'Blindia magellanica','Blindia magellanica','Blindia magellanic',2,0,'','','Schimp.','ff6a8524-7913-5037-a8aa-c63f7eacd7e9','Blindia magellanica Schimp.','Schimp.','SPECIES','','Blindia','','magellanica','','','',NULL,'','','','','','Schimp.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0248417f-4c93-4617-a755-88d655326862','','','Sigaus takahe Morris, 2003',1,'Sigaus takahe','Sigaus takahe','Sigaus takah',2,0,'','','Morris','5c821519-02e5-5fb5-8b21-30fb6509f169','Sigaus takahe Morris, 2003','Morris, 2003','SPECIES','','Sigaus','','takahe','','','',NULL,'','','','','','Morris','','','','2003','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0247cf7a-672f-4a1d-ad8f-dbfabafcf490','','','Agaricus interruptus Berk.',1,'Agaricus interruptus','Agaricus interruptus','Agaricus interrupt',2,0,'','','Berk.','8261c3db-62bc-5af3-a1a0-568ad2981fad','Agaricus interruptus Berk.','Berk.','SPECIES','','Agaricus','','interruptus','','','',NULL,'','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02987528-4d26-43a9-8d62-2f51f331c3af','','','Postia ceriflua (Berk. & M.A. Curtis) Jülich',1,'Postia ceriflua','Postia ceriflua','Postia ceriflu',2,0,'','','Berk.|M. A. Curtis|Jülich','610dbc0e-9709-5c20-bedb-ba166214cb4b','Postia ceriflua (Berk. & M.A. Curtis) Jülich','(Berk. & M.A. Curtis) Jülich','SPECIES','','Postia','','ceriflua','','','',NULL,'Jülich','','','','','Berk. & M. A. Curtis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02994186-4b0c-40fa-aeb9-c2e37036abbf','','','Hypotagea dissona Broun, 1886',1,'Hypotagea dissona','Hypotagea dissona','Hypotagea disson',2,0,'','','Broun','37d8993d-fedd-5ab0-8799-ff1d12d44391','Hypotagea dissona Broun, 1886','Broun, 1886','SPECIES','','Hypotagea','','dissona','','','',NULL,'','','','','','Broun','','','','1886','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('029db5c3-4109-49ef-8846-3698d1a404fd','','','Hibiscus mutabilis L.',1,'Hibiscus mutabilis','Hibiscus mutabilis','Hibiscus mutabil',2,0,'','','L.','79c2f1b9-e662-5298-9321-11b208ffaa03','Hibiscus mutabilis L.','L.','SPECIES','','Hibiscus','','mutabilis','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02a2f974-572d-45a4-aecf-42b4d0b4fc58','','','Cymonomus',1,'Cymonomus','Cymonomus','Cymonomus',1,0,'','','','65c9a558-3611-56eb-839f-84c4d41c343c','Cymonomus','','GENUS','Cymonomus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02a33c3e-095d-4225-b13d-4fdcc3556507','','','Favosipora tincta Gordon & Taylor, 2001',1,'Favosipora tincta','Favosipora tincta','Favosipora tinct',2,0,'','','Gordon|Taylor','e5740422-e98a-5b6a-8579-32730279d906','Favosipora tincta Gordon & Taylor, 2001','Gordon & Taylor, 2001','SPECIES','','Favosipora','','tincta','','','',NULL,'','','','','','Gordon & Taylor','','','','2001','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('029e65ac-0773-4cd9-bd22-c589400739cd','','','Sympodiella fragilis Aramb. & W.B. Kendr.',1,'Sympodiella fragilis','Sympodiella fragilis','Sympodiella fragil',2,0,'','','Aramb.|W. B. Kendr.','34f73101-f982-5047-ae3f-b4357a6ffb0c','Sympodiella fragilis Aramb. & W.B. Kendr.','Aramb. & W.B. Kendr.','SPECIES','','Sympodiella','','fragilis','','','',NULL,'','','','','','Aramb. & W. B. Kendr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02ab6605-8b5c-4455-ba5c-392f9f23684f','','','Tugali elegans Gray, 1843',1,'Tugali elegans','Tugali elegans','Tugali elegans',2,0,'','','Gray','cae79bd0-00e5-5f8f-8bb5-f46238ff27fd','Tugali elegans Gray, 1843','Gray, 1843','SPECIES','','Tugali','','elegans','','','',NULL,'','','','','','Gray','','','','1843','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02a7ca1e-bbb3-4171-97df-6b3f56699ee4','','','Pachyptila belcheri (Mathews, 1912)',1,'Pachyptila belcheri','Pachyptila belcheri','Pachyptila belcher',2,0,'','','Mathews','3e3a487c-bda7-5dd6-95cf-76cc2e222c11','Pachyptila belcheri (Mathews, 1912)','(Mathews, 1912)','SPECIES','','Pachyptila','','belcheri','','','',NULL,'','','','','','Mathews','','','','1912','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02a7f62d-9f8b-4009-836d-b8768287a438','','','Anteaglonium parvulum (W.R. Gerard) Mugambi & Huhndorf',1,'Anteaglonium parvulum','Anteaglonium parvulum','Anteaglonium paruul',2,0,'','','W. R. Gerard|Mugambi|Huhndorf','5b41b296-ac89-56ec-82ab-373510353bbd','Anteaglonium parvulum (W.R. Gerard) Mugambi & Huhndorf','(W.R. Gerard) Mugambi & Huhndorf','SPECIES','','Anteaglonium','','parvulum','','','',NULL,'Mugambi & Huhndorf','','','','','W. R. Gerard','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02ad8fbd-071a-4745-91fb-3d124e5e35d6','','','Bleptaturus',1,'Bleptaturus','Bleptaturus','Bleptaturus',1,0,'','','','8f6ab4a1-5d9b-52a8-9930-73c2318256aa','Bleptaturus','','GENUS','Bleptaturus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02b1111c-ca76-414b-990e-69a77a752750','','','Erysiphe syringae Schwein.',1,'Erysiphe syringae','Erysiphe syringae','Erysiphe syring',2,0,'','','Schwein.','3de4f3cf-97ba-5ad5-a623-fc45b8e9d2c3','Erysiphe syringae Schwein.','Schwein.','SPECIES','','Erysiphe','','syringae','','','',NULL,'','','','','','Schwein.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02b2513b-8399-4fff-a873-e807fcf2a518','','','Calopadia subcoerulescens (Zahlbr.) Vězda',1,'Calopadia subcoerulescens','Calopadia subcoerulescens','Calopadia subcoerulescens',2,0,'','','Zahlbr.|Vězda','bfd1d1f8-eac1-5151-9803-5097d51a9a04','Calopadia subcoerulescens (Zahlbr.) Vězda','(Zahlbr.) Vězda','SPECIES','','Calopadia','','subcoerulescens','','','',NULL,'Vězda','','','','','Zahlbr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02b6f862-9c67-482f-85f6-4d66f148c7f3','','','Cotula sericea (Kirk) Cockayne & Allan',1,'Cotula sericea','Cotula sericea','Cotula serice',2,0,'','','Kirk|Cockayne|Allan','bba894b9-7a76-545a-afaf-6d718cb6c9a5','Cotula sericea (Kirk) Cockayne & Allan','(Kirk) Cockayne & Allan','SPECIES','','Cotula','','sericea','','','',NULL,'Cockayne & Allan','','','','','Kirk','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02b8224f-2727-4cc4-9f9c-975e47065280','','','Guignardia camelliae (Cooke) E.J. Butler',1,'Guignardia camelliae','Guignardia camelliae','Guignardia camelli',2,0,'','','Cooke|E. J. Butler','c8010c03-4973-5175-a649-eaab1b0715f7','Guignardia camelliae (Cooke) E.J. Butler','(Cooke) E.J. Butler','SPECIES','','Guignardia','','camelliae','','','',NULL,'E. J. Butler','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02b6516d-ddc5-45d1-a5b0-e55b758ba188','','','Helicotheca tamesis (Shrubsole) Ricard',1,'Helicotheca tamesis','Helicotheca tamesis','Helicotheca tames',2,0,'','','Shrubsole|Ricard','d535235b-22c6-5264-8610-fa4dc70d32e6','Helicotheca tamesis (Shrubsole) Ricard','(Shrubsole) Ricard','SPECIES','','Helicotheca','','tamesis','','','',NULL,'Ricard','','','','','Shrubsole','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02bcf8a3-852e-434a-9cfa-2cb17040d618','','','Cymus novaezelandiae Woodward, 1954',1,'Cymus novaezelandiae','Cymus novaezelandiae','Cymus nouaezelandi',2,0,'','','Woodward','5ba8f7f2-e6af-587b-afb1-ddb824a76110','Cymus novaezelandiae Woodward, 1954','Woodward, 1954','SPECIES','','Cymus','','novaezelandiae','','','',NULL,'','','','','','Woodward','','','','1954','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02bc4c85-eb36-46f0-b739-84c0271380e2','','','Cercosporella acalyphae Lacy & Thirum.',1,'Cercosporella acalyphae','Cercosporella acalyphae','Cercosporella acalyph',2,0,'','','Lacy|Thirum.','f3ec4028-1797-595f-bbae-deab5b4756a8','Cercosporella acalyphae Lacy & Thirum.','Lacy & Thirum.','SPECIES','','Cercosporella','','acalyphae','','','',NULL,'','','','','','Lacy & Thirum.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02be97be-f402-40b1-b2e5-9b6c9dda4dae','','','Tingena ancogramma (Meyrick, 1919)',1,'Tingena ancogramma','Tingena ancogramma','Tingena ancogramm',2,0,'','','Meyrick','352286c1-acdf-54de-a475-3be518b99c8b','Tingena ancogramma (Meyrick, 1919)','(Meyrick, 1919)','SPECIES','','Tingena','','ancogramma','','','',NULL,'','','','','','Meyrick','','','','1919','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02c3a803-e030-4f62-a2fb-00cf008f6ad3','','','Stenolemus fraterculus Wygodzinsky, 1956',1,'Stenolemus fraterculus','Stenolemus fraterculus','Stenolemus fratercul',2,0,'','','Wygodzinsky','c41330d3-58e9-5aea-a1fe-3af6a4affec2','Stenolemus fraterculus Wygodzinsky, 1956','Wygodzinsky, 1956','SPECIES','','Stenolemus','','fraterculus','','','',NULL,'','','','','','Wygodzinsky','','','','1956','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02c5ed8c-d78d-4601-b94c-56f42cde2e01','','','Ophioglossum vulgatum var. gramineum Hook.f.',1,'Ophioglossum vulgatum gramineum','Ophioglossum vulgatum var. gramineum','Ophioglossum uulgat gramine',3,0,'','','Hook. fil.','2acb025c-33de-5257-b652-0cd8b0345806','Ophioglossum vulgatum var. gramineum Hook.f.','Hook.f.','VARIETY','','Ophioglossum','','vulgatum','gramineum','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02c47fdb-8919-4664-8678-7d93dcd8113d','','','Olearia ilicifolia Hook.f.',1,'Olearia ilicifolia','Olearia ilicifolia','Olearia ilicifol',2,0,'','','Hook. fil.','dd7c575f-1d47-540b-81a5-ebb71b5e9bb7','Olearia ilicifolia Hook.f.','Hook.f.','SPECIES','','Olearia','','ilicifolia','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02c51339-6c62-4433-bacd-a4152e2951d5','','','Crassula mataikona A.P.Druce',1,'Crassula mataikona','Crassula mataikona','Crassula mataikon',2,0,'','','A. P. Druce','f08be83b-99fa-566c-a91a-d5ffc0cc3af2','Crassula mataikona A.P.Druce','A.P.Druce','SPECIES','','Crassula','','mataikona','','','',NULL,'','','','','','A. P. Druce','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02cb7ba3-cccc-45d6-a955-019a31df2e0f','','','Cryptocephalinae',1,'Cryptocephalinae','Cryptocephalinae','Cryptocephalinae',1,0,'','','','97ed629a-2b4d-5efa-b769-bf9fc0f1f0e9','Cryptocephalinae','','SUBFAMILY','Cryptocephalinae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02c7dfe2-3169-43ac-bdd8-14a9651c9dc3','','','Heterodoassansia hottoniae (Rostr.) Vánky',1,'Heterodoassansia hottoniae','Heterodoassansia hottoniae','Heterodoassansia hottoni',2,0,'','','Rostr.|Vánky','2f112ad3-16d5-5525-b9fa-c1252a0e7ce5','Heterodoassansia hottoniae (Rostr.) Vánky','(Rostr.) Vánky','SPECIES','','Heterodoassansia','','hottoniae','','','',NULL,'Vánky','','','','','Rostr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02c9225d-6969-4dc0-aead-8e57c0e1e375','','','Endoconidium temulentum Prill. & Delacr.',1,'Endoconidium temulentum','Endoconidium temulentum','Endoconidium temulent',2,0,'','','Prill.|Delacr.','b36b790d-ecb7-5c45-a1f7-b66ccaf54c25','Endoconidium temulentum Prill. & Delacr.','Prill. & Delacr.','SPECIES','','Endoconidium','','temulentum','','','',NULL,'','','','','','Prill. & Delacr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02c9fdd6-5f9f-4b37-a7e3-cdae6de8c7cb','','','Scatopse notata (Linnaeus, 1758)',1,'Scatopse notata','Scatopse notata','Scatopse notat',2,0,'','','Linnaeus','b3231d08-368e-53f8-95be-37badb2cd1aa','Scatopse notata (Linnaeus, 1758)','(Linnaeus, 1758)','SPECIES','','Scatopse','','notata','','','',NULL,'','','','','','Linnaeus','','','','1758','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02d172e4-4544-4328-b637-00cfcfa1c7a4','','','Maryella reducta Sublette & Wirth, 1980',1,'Maryella reducta','Maryella reducta','Maryella reduct',2,0,'','','Sublette|Wirth','5a71b972-ffb2-53ec-be7f-ac5dc152cbd4','Maryella reducta Sublette & Wirth, 1980','Sublette & Wirth, 1980','SPECIES','','Maryella','','reducta','','','',NULL,'','','','','','Sublette & Wirth','','','','1980','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02d2e4a2-4254-4aa5-a5be-4bebfede8a9f','','','Metacirolana',1,'Metacirolana','Metacirolana','Metacirolana',1,0,'','','','f75f512f-8220-516a-ad36-77415bb71ec0','Metacirolana','','GENUS','Metacirolana','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02d2895b-2ed0-491d-9456-514092bf6010','','','Pezizomycetidae',1,'Pezizomycetidae','Pezizomycetidae','Pezizomycetidae',1,0,'','','','ce039f66-959f-52c4-8c20-2674cd5a4045','Pezizomycetidae','','SUBCLASS','Pezizomycetidae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02cd17ac-ec72-4f49-9f3e-76f0f7ea5082','','','Telimena ecastophylli (Lév.) Cif.',1,'Telimena ecastophylli','Telimena ecastophylli','Telimena ecastophyll',2,0,'','','Lév.|Cif.','39919271-d0cb-5277-b9e7-a314e477143f','Telimena ecastophylli (Lév.) Cif.','(Lév.) Cif.','SPECIES','','Telimena','','ecastophylli','','','',NULL,'Cif.','','','','','Lév.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02d0cb01-71cb-4f00-9248-edd8735f19f0','','','Heliothela atra (Butler, 1877)',1,'Heliothela atra','Heliothela atra','Heliothela atr',2,0,'','','Butler','9659e7d5-e4c7-550f-ac41-e07b14219855','Heliothela atra (Butler, 1877)','(Butler, 1877)','SPECIES','','Heliothela','','atra','','','',NULL,'','','','','','Butler','','','','1877','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02d48ec5-84c5-4e2a-ad0f-4970586285ce','','','Phragmidium libocedri Henn.',1,'Phragmidium libocedri','Phragmidium libocedri','Phragmidium libocedr',2,0,'','','Henn.','0daa1c03-fcf2-5e2a-ab2d-5e07af17ed1a','Phragmidium libocedri Henn.','Henn.','SPECIES','','Phragmidium','','libocedri','','','',NULL,'','','','','','Henn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02daba71-273b-4b20-9601-7304c1a86c4e','','','Aplidium adamsi Brewin, 1946',1,'Aplidium adamsi','Aplidium adamsi','Aplidium adams',2,0,'','','Brewin','3baa4468-e458-5d2c-b88e-f46e4633b7ff','Aplidium adamsi Brewin, 1946','Brewin, 1946','SPECIES','','Aplidium','','adamsi','','','',NULL,'','','','','','Brewin','','','','1946','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02d813c1-c00d-411e-96e7-f0d4103537a2','','','Hymenostylium Brid.',1,'Hymenostylium','Hymenostylium','Hymenostylium',1,0,'','','Brid.','8c52c1e3-25d8-5941-80ba-3e209d1cdc7c','Hymenostylium Brid.','Brid.','GENUS','Hymenostylium','','','','','','',NULL,'','','','','','Brid.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('024dbcff-201b-468e-b1e2-249cf75c77a2','','','Oxalis vallicola (Rose) R.Knuth',1,'Oxalis vallicola','Oxalis vallicola','Oxalis uallicol',2,0,'','','Rose|R. Knuth','ba389fda-c7c4-5748-b23c-862703fba48d','Oxalis vallicola (Rose) R.Knuth','(Rose) R.Knuth','SPECIES','','Oxalis','','vallicola','','','',NULL,'R. Knuth','','','','','Rose','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('024a1f2c-8dfc-4736-80f1-8218f660b91a','','','Linaria pelisseriana (L.) Mill.',1,'Linaria pelisseriana','Linaria pelisseriana','Linaria pelisserian',2,0,'','','L.|Mill.','4677d4ce-cf98-59f9-ac29-ea82a022fffb','Linaria pelisseriana (L.) Mill.','(L.) Mill.','SPECIES','','Linaria','','pelisseriana','','','',NULL,'Mill.','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('024ab898-ccf2-40a7-9dee-e76a9da1f46f','','','Haplinis chiltoni Hogg, 1911',1,'Haplinis chiltoni','Haplinis chiltoni','Haplinis chilton',2,0,'','','Hogg','06b24428-4fa6-5027-9e98-06a38e1d71e3','Haplinis chiltoni Hogg, 1911','Hogg, 1911','SPECIES','','Haplinis','','chiltoni','','','',NULL,'','','','','','Hogg','','','','1911','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02517b0c-418f-45c4-a828-247d0c746ac9','','','Liriope tetraphylla (Chamisso & Eysenhardt, 1821)',1,'Liriope tetraphylla','Liriope tetraphylla','Liriope tetraphyll',2,0,'','','Chamisso|Eysenhardt','240eb83f-b56e-5b03-9ae5-322df18766f9','Liriope tetraphylla (Chamisso & Eysenhardt, 1821)','(Chamisso & Eysenhardt, 1821)','SPECIES','','Liriope','','tetraphylla','','','',NULL,'','','','','','Chamisso & Eysenhardt','','','','1821','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('024fbee2-b69a-4cd3-8654-965c603239c2','','','Nectria canadensis Ellis & Everh.',1,'Nectria canadensis','Nectria canadensis','Nectria canadens',2,0,'','','Ellis|Everh.','3a4610eb-e54a-5106-b8a4-0b0242be3f9c','Nectria canadensis Ellis & Everh.','Ellis & Everh.','SPECIES','','Nectria','','canadensis','','','',NULL,'','','','','','Ellis & Everh.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02519c5c-582e-4b8f-9ddd-e607f7a2954f','','','Streptomyces scabiei (Thaxter 1892) Waksman and Henrici, 1948',1,'Streptomyces scabiei','Streptomyces scabiei','Streptomyces scabie',2,0,'','','Thaxter|Waksman|Henrici','e5926c8b-5efa-55c5-a229-e9d454a6d3ec','Streptomyces scabiei (Thaxter 1892) Waksman and Henrici, 1948','(Thaxter 1892) Waksman and Henrici, 1948','SPECIES','','Streptomyces','','scabiei','','','',NULL,'Waksman & Henrici','','','','1948','Thaxter','','','','1892','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0256ca0b-eb64-4fd5-bb0a-9d183aa577ea','','','Howickia trilineata (Hutton, 1901)',1,'Howickia trilineata','Howickia trilineata','Howickia trilineat',2,0,'','','Hutton','70a2fce2-ce40-53d9-9359-f747a6ce16e8','Howickia trilineata (Hutton, 1901)','(Hutton, 1901)','SPECIES','','Howickia','','trilineata','','','',NULL,'','','','','','Hutton','','','','1901','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0258dc14-042a-4e08-bbc9-d23727c54f63','','','Scirpus muscosus Kirk',1,'Scirpus muscosus','Scirpus muscosus','Scirpus muscos',2,0,'','','Kirk','539968ba-20f1-5ddb-8ce8-dae537ad5d15','Scirpus muscosus Kirk','Kirk','SPECIES','','Scirpus','','muscosus','','','',NULL,'','','','','','Kirk','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0257f81c-7a7c-4c1b-b593-faed69d29841','','','Mollisia juncina (Pers.) Rehm',1,'Mollisia juncina','Mollisia juncina','Mollisia iuncin',2,0,'','','Pers.|Rehm','21354bb5-6c1b-57a0-852b-58e370eb2c1d','Mollisia juncina (Pers.) Rehm','(Pers.) Rehm','SPECIES','','Mollisia','','juncina','','','',NULL,'Rehm','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('025cb6d5-b04d-4a46-b815-55c21d185577','','','Polygonum aequale Lindm.',1,'Polygonum aequale','Polygonum aequale','Polygonum aequal',2,0,'','','Lindm.','09a86fa1-4207-5c88-b5c4-8ff72d82b905','Polygonum aequale Lindm.','Lindm.','SPECIES','','Polygonum','','aequale','','','',NULL,'','','','','','Lindm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02637b0e-f0f3-40ac-a0b9-825ee934fc2b','','','Solenostoma patellata (Berggr.) Steph.',1,'Solenostoma patellata','Solenostoma patellata','Solenostoma patellat',2,0,'','','Berggr.|Steph.','baf61abd-fa6d-55af-ae8e-ebb90f8e097e','Solenostoma patellata (Berggr.) Steph.','(Berggr.) Steph.','SPECIES','','Solenostoma','','patellata','','','',NULL,'Steph.','','','','','Berggr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('025d96ad-44b5-46ef-a6cf-ff27cf424ce0','','','Anuropus species N. Bruce, 2008',4,'','','',NULL,NULL,'','','','','Anuropus species N. Bruce, 2008','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('026751b8-3a7b-4e8c-be33-1bb929d17ccb','','','Taiaroa tauhou Bayer & Muzik, 1976',1,'Taiaroa tauhou','Taiaroa tauhou','Taiaroa tauho',2,0,'','','Bayer|Muzik','bbb67f12-a1cf-5093-be44-ea75b57fcc37','Taiaroa tauhou Bayer & Muzik, 1976','Bayer & Muzik, 1976','SPECIES','','Taiaroa','','tauhou','','','',NULL,'','','','','','Bayer & Muzik','','','','1976','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02694412-bade-4720-97e0-e708542e5fdc','','','Helicosporidium',1,'Helicosporidium','Helicosporidium','Helicosporidium',1,0,'','','','9e10b2f7-4bb3-5f31-b2ac-1497ad397b76','Helicosporidium','','GENUS','Helicosporidium','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('026a498e-a40b-44d2-bf4d-f9b9b3d2444b','','','Neorchesia divergens Broun, 1914',1,'Neorchesia divergens','Neorchesia divergens','Neorchesia diuergens',2,0,'','','Broun','4d242678-3be5-5a81-8b4a-9986c57683a1','Neorchesia divergens Broun, 1914','Broun, 1914','SPECIES','','Neorchesia','','divergens','','','',NULL,'','','','','','Broun','','','','1914','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0273b31c-faf4-4a26-b942-6254279618c4','','','Mylonchus ubis Clark, 1961',1,'Mylonchus ubis','Mylonchus ubis','Mylonchus ub',2,0,'','','Clark','9eae15a5-efa1-5b63-aa9c-2a39b152a554','Mylonchus ubis Clark, 1961','Clark, 1961','SPECIES','','Mylonchus','','ubis','','','',NULL,'','','','','','Clark','','','','1961','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('026ed966-f46c-4565-a5e8-80bd063e268e','','','Gnaphalium purpureum L. var. purpureum',1,'Gnaphalium purpureum purpureum','Gnaphalium purpureum var. purpureum','Gnaphalium purpure purpure',3,0,'','','','ec1bdda3-acab-5bac-ae35-c64c61f55d76','Gnaphalium purpureum L. var. purpureum','','VARIETY','','Gnaphalium','','purpureum','purpureum','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0271566f-59b6-4bd0-8e8e-eb0b37cdc11c','','','Craterium vulgare Ditmar',1,'Craterium vulgare','Craterium vulgare','Craterium uulgar',2,0,'','','Ditmar','ed02f3ea-5a55-57ab-a343-1d799c61ec0a','Craterium vulgare Ditmar','Ditmar','SPECIES','','Craterium','','vulgare','','','',NULL,'','','','','','Ditmar','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0275a05f-75d3-4521-8255-4078572eba0a','','','Ipana hermione Hudson, 1898',1,'Ipana hermione','Ipana hermione','Ipana hermion',2,0,'','','Hudson','591ade9f-429a-5f70-ba04-a36a644a44a9','Ipana hermione Hudson, 1898','Hudson, 1898','SPECIES','','Ipana','','hermione','','','',NULL,'','','','','','Hudson','','','','1898','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0277ed0d-7a08-49ae-8150-9442eec2de46','','','Leptecophylla robusta (Hook.f.) C.M.Weiller',1,'Leptecophylla robusta','Leptecophylla robusta','Leptecophylla robust',2,0,'','','Hook. fil.|C. M. Weiller','fc60dae3-8f7c-5772-810d-906b0d1eafdc','Leptecophylla robusta (Hook.f.) C.M.Weiller','(Hook.f.) C.M.Weiller','SPECIES','','Leptecophylla','','robusta','','','',NULL,'C. M. Weiller','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0277503e-4475-4185-b172-d3770bfe1c95','','','Trachelomonas pulchella Drezepolski',1,'Trachelomonas pulchella','Trachelomonas pulchella','Trachelomonas pulchell',2,0,'','','Drezepolski','0d046b83-54c9-595c-9348-90942eaf4f80','Trachelomonas pulchella Drezepolski','Drezepolski','SPECIES','','Trachelomonas','','pulchella','','','',NULL,'','','','','','Drezepolski','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('027c1097-6399-4ed6-81d6-fd49f2a54ee0','','','Stenomalium antipodum (Broun, 1893)',1,'Stenomalium antipodum','Stenomalium antipodum','Stenomalium antipod',2,0,'','','Broun','0510901e-34e8-5ab1-8cc1-adf90974668c','Stenomalium antipodum (Broun, 1893)','(Broun, 1893)','SPECIES','','Stenomalium','','antipodum','','','',NULL,'','','','','','Broun','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('027fe56e-5f03-4dd0-89a2-5b5756ab88f5','','','Lecidea ochracea Schaer.',1,'Lecidea ochracea','Lecidea ochracea','Lecidea ochrace',2,0,'','','Schaer.','e1757f05-cd10-5953-aadd-887b1bd6abe0','Lecidea ochracea Schaer.','Schaer.','SPECIES','','Lecidea','','ochracea','','','',NULL,'','','','','','Schaer.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('027c7dfd-e155-4c61-86b1-cb9e596a9aa6','','','Oecophora armigerella Walker, 1864',1,'Oecophora armigerella','Oecophora armigerella','Oecophora armigerell',2,0,'','','Walker','517099b5-26b3-5e07-92d4-34aed569b744','Oecophora armigerella Walker, 1864','Walker, 1864','SPECIES','','Oecophora','','armigerella','','','',NULL,'','','','','','Walker','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02805f80-5cd7-4260-a8ec-d51a9241242e','','','Eatoniella notata Ponder & Yoo, 1977',1,'Eatoniella notata','Eatoniella notata','Eatoniella notat',2,0,'','','Ponder|Yoo','18b810d7-b5e5-541f-adba-652cc2e05699','Eatoniella notata Ponder & Yoo, 1977','Ponder & Yoo, 1977','SPECIES','','Eatoniella','','notata','','','',NULL,'','','','','','Ponder & Yoo','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('028c1268-e6f1-440c-8e1a-5c0cd141ecf0','','','Allelochaeta obtusa (H.J. Swart & M.A. Will.) Crous',1,'Allelochaeta obtusa','Allelochaeta obtusa','Allelochaeta obtus',2,0,'','','H. J. Swart|M. A. Will.|Crous','3261fbc0-f657-5bed-a3e6-0b8b1c352249','Allelochaeta obtusa (H.J. Swart & M.A. Will.) Crous','(H.J. Swart & M.A. Will.) Crous','SPECIES','','Allelochaeta','','obtusa','','','',NULL,'Crous','','','','','H. J. Swart & M. A. Will.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('028e0787-f794-443b-9b3f-065c7aad6af0','','','Hypoxylon multiforme (Fr.) Fr. var. multiforme',1,'Hypoxylon multiforme multiforme','Hypoxylon multiforme var. multiforme','Hypoxylon multiform multiform',3,0,'','','','74b53465-0c24-5e71-b842-cc7058254512','Hypoxylon multiforme (Fr.) Fr. var. multiforme','','VARIETY','','Hypoxylon','','multiforme','multiforme','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0292ad6a-8ac3-41a4-aaac-9e947b0b5133','','','Thripobius',1,'Thripobius','Thripobius','Thripobius',1,0,'','','','11c9416b-dbf4-5179-bdea-26c931658b41','Thripobius','','GENUS','Thripobius','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('028dee1e-6d82-4793-bf1e-b2da668caf92','','','Pseudaphycus',1,'Pseudaphycus','Pseudaphycus','Pseudaphycus',1,0,'','','','5caf6518-6cda-5986-952b-b7b1705ab323','Pseudaphycus','','GENUS','Pseudaphycus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02938f05-3816-4ea1-8f91-dc0c93df9235','','','Mycena minya Grgur.',1,'Mycena minya','Mycena minya','Mycena miny',2,0,'','','Grgur.','16524e81-891b-598d-abb1-584b397a4e54','Mycena minya Grgur.','Grgur.','SPECIES','','Mycena','','minya','','','',NULL,'','','','','','Grgur.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('029089c3-d3c5-4f28-99ad-fd9457668d2b','','','Gammaropsis tawahi Barnard, 1972',1,'Gammaropsis tawahi','Gammaropsis tawahi','Gammaropsis tawah',2,0,'','','Barnard','0a118495-1c44-5b25-8092-4d7afb6cd2a8','Gammaropsis tawahi Barnard, 1972','Barnard, 1972','SPECIES','','Gammaropsis','','tawahi','','','',NULL,'','','','','','Barnard','','','','1972','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0178981b-f308-43d0-8264-261da809c198','','','Tineobius species [Noyes & Valentine], 1989',4,'','','',NULL,NULL,'','','','','Tineobius species [Noyes & Valentine], 1989','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01753a51-9066-4478-951d-9a2cfb87004c','','','Aechmea weilbachii var. leodiensis Andre',1,'Aechmea weilbachii leodiensis','Aechmea weilbachii var. leodiensis','Aechmea weilbach leodiens',3,0,'','','Andre','4ad62f9d-e935-5e64-b595-d579f9b77892','Aechmea weilbachii var. leodiensis Andre','Andre','VARIETY','','Aechmea','','weilbachii','leodiensis','','',NULL,'','','','','','Andre','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01762ecc-0ba7-48c8-a6d7-bb60ccce65b7','','','Chrysanthemum myconis L.',1,'Chrysanthemum myconis','Chrysanthemum myconis','Chrysanthemum mycon',2,0,'','','L.','eb7ccfce-ef17-5cac-a3d7-05c39e2b72db','Chrysanthemum myconis L.','L.','SPECIES','','Chrysanthemum','','myconis','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01795acb-5d63-402e-89be-cbfc0e1c1f11','','','Dendrobathypathes',1,'Dendrobathypathes','Dendrobathypathes','Dendrobathypathes',1,0,'','','','549ce36f-c1f7-527d-a947-406b32d59aca','Dendrobathypathes','','GENUS','Dendrobathypathes','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01783008-0a25-45c8-8257-da010b931d80','','','Amphora laevissima Gregory',1,'Amphora laevissima','Amphora laevissima','Amphora laeuissim',2,0,'','','Gregory','b8cd710a-8e01-57b6-9512-0b5a2e1fca50','Amphora laevissima Gregory','Gregory','SPECIES','','Amphora','','laevissima','','','',NULL,'','','','','','Gregory','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('017f9429-e7f9-4839-831a-3dad0a37dda3','','','Poa remota Forselles',1,'Poa remota','Poa remota','Poa remot',2,0,'','','Forselles','a0bf8a07-e4d3-5c2b-bb38-e3026872cb26','Poa remota Forselles','Forselles','SPECIES','','Poa','','remota','','','',NULL,'','','','','','Forselles','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('017f42ce-baeb-41ea-a155-8f3e0f3f6a90','','','Cyanolophocolea echinella (Lindenb. & Gottsche) R.M.Schust.',1,'Cyanolophocolea echinella','Cyanolophocolea echinella','Cyanolophocolea echinell',2,0,'','','Lindenb.|Gottsche|R. M. Schust.','0bf813a2-c95f-5869-aa68-fcd225720aa7','Cyanolophocolea echinella (Lindenb. & Gottsche) R.M.Schust.','(Lindenb. & Gottsche) R.M.Schust.','SPECIES','','Cyanolophocolea','','echinella','','','',NULL,'R. M. Schust.','','','','','Lindenb. & Gottsche','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('017c3026-4679-4d43-b4d4-ce368ca94dd4','','','Doliocoitis cyanea Gordon & Taylor, 2001',1,'Doliocoitis cyanea','Doliocoitis cyanea','Doliocoitis cyane',2,0,'','','Gordon|Taylor','e6efaa48-e52e-57fe-8c0c-036825141d64','Doliocoitis cyanea Gordon & Taylor, 2001','Gordon & Taylor, 2001','SPECIES','','Doliocoitis','','cyanea','','','',NULL,'','','','','','Gordon & Taylor','','','','2001','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0187f4e4-2ace-4129-8950-5a8364cb27f1','','','Pseudotriakis microdon Capello, 1867',1,'Pseudotriakis microdon','Pseudotriakis microdon','Pseudotriakis microdon',2,0,'','','Capello','b894d2ac-96eb-5919-9fcf-b03ff5a9a8dd','Pseudotriakis microdon Capello, 1867','Capello, 1867','SPECIES','','Pseudotriakis','','microdon','','','',NULL,'','','','','','Capello','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01856c76-cbe0-4bbc-b4f4-ae73aa8fe7b2','','','Thunnus',1,'Thunnus','Thunnus','Thunnus',1,0,'','','','95fbb816-5ad2-5da5-b13f-acd37b47fad9','Thunnus','','GENUS','Thunnus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0187dbc3-baee-4b35-b1ed-c88cda252ec0','','','Tephrosara Meyrick, 1915',1,'Tephrosara','Tephrosara','Tephrosara',1,0,'','','Meyrick','0be4a895-fbf3-5a39-8e21-00240edd411f','Tephrosara Meyrick, 1915','Meyrick, 1915','GENUS','Tephrosara','','','','','','',NULL,'','','','','','Meyrick','','','','1915','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0182b600-bd53-42dd-8503-e34edb1d8658','','','Uredo porri Sowerby',1,'Uredo porri','Uredo porri','Uredo porr',2,0,'','','Sowerby','d9573489-2916-5d02-87c0-3e1a0bbfb4cb','Uredo porri Sowerby','Sowerby','SPECIES','','Uredo','','porri','','','',NULL,'','','','','','Sowerby','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0189000d-84f5-46b9-b66c-2659abbdb790','','','Oidium cydoniae Pass.',1,'Oidium cydoniae','Oidium cydoniae','Oidium cydoni',2,0,'','','Pass.','6cca88b5-8e39-534e-8ea9-624a75c81351','Oidium cydoniae Pass.','Pass.','SPECIES','','Oidium','','cydoniae','','','',NULL,'','','','','','Pass.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0188d11f-1342-4a99-b760-8b015c39b1e7','','','Leptodictyum humile (P.Beauv.) H.A.Crum',1,'Leptodictyum humile','Leptodictyum humile','Leptodictyum humil',2,0,'','','P. Beauv.|H. A. Crum','f912cf10-2481-53ad-aa66-3371962b7d77','Leptodictyum humile (P.Beauv.) H.A.Crum','(P.Beauv.) H.A.Crum','SPECIES','','Leptodictyum','','humile','','','',NULL,'H. A. Crum','','','','','P. Beauv.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('018a404c-c89a-4c50-b199-deddfbf9e618','','','Bembidion wanakense Lindroth, 1976',1,'Bembidion wanakense','Bembidion wanakense','Bembidion wanakens',2,0,'','','Lindroth','c43b9d91-e7b7-5221-95e3-f2bfe1d81b77','Bembidion wanakense Lindroth, 1976','Lindroth, 1976','SPECIES','','Bembidion','','wanakense','','','',NULL,'','','','','','Lindroth','','','','1976','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01933086-554e-4b37-bcc4-23a72661e601','','','Eclipta L.',1,'Eclipta','Eclipta','Eclipta',1,0,'','','L.','afc33bcc-3190-5c84-9147-e0f5705ecf25','Eclipta L.','L.','GENUS','Eclipta','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0196ca30-f0b1-4611-b8bf-454db05d5243','','','Gomphosphenia',1,'Gomphosphenia','Gomphosphenia','Gomphosphenia',1,0,'','','','20356e93-21d5-553d-8a39-2aa749148e7c','Gomphosphenia','','GENUS','Gomphosphenia','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('018feefa-5068-42c3-8afa-6b9475853a6c','','','Bacidia praelucida (Kremp.) Hellb.',1,'Bacidia praelucida','Bacidia praelucida','Bacidia praelucid',2,0,'','','Kremp.|Hellb.','83a70657-9b58-58fd-82c6-8d30f719e65b','Bacidia praelucida (Kremp.) Hellb.','(Kremp.) Hellb.','SPECIES','','Bacidia','','praelucida','','','',NULL,'Hellb.','','','','','Kremp.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0190cb12-cd76-4dfd-b99d-b8d9c52b5c4b','','','Caloplaca biatorina (A.Massal.) J.Steiner',1,'Caloplaca biatorina','Caloplaca biatorina','Caloplaca biatorin',2,0,'','','A. Massal.|J. Steiner','97c92c93-e765-57a5-8e65-dc943ac9c8d8','Caloplaca biatorina (A.Massal.) J.Steiner','(A.Massal.) J.Steiner','SPECIES','','Caloplaca','','biatorina','','','',NULL,'J. Steiner','','','','','A. Massal.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01903ea2-773a-480d-a4e1-e6502150514c','','','Carmichaelia muelleriana Regel',1,'Carmichaelia muelleriana','Carmichaelia muelleriana','Carmichaelia muellerian',2,0,'','','Regel','44aa42c1-ac41-5a84-a51d-8c8d651a6569','Carmichaelia muelleriana Regel','Regel','SPECIES','','Carmichaelia','','muelleriana','','','',NULL,'','','','','','Regel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('019cc494-a233-4e15-b5ea-156c95b52aeb','','','Caelorinchus bollonsi McCann & McKnight, 1980',1,'Caelorinchus bollonsi','Caelorinchus bollonsi','Caelorinchus bollons',2,0,'','','McCann|McKnight','d04bf18a-7281-55c7-adf4-3ca86f38a465','Caelorinchus bollonsi McCann & McKnight, 1980','McCann & McKnight, 1980','SPECIES','','Caelorinchus','','bollonsi','','','',NULL,'','','','','','McCann & McKnight','','','','1980','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01973b4d-c4d9-41a1-96c2-72d7303cb7e9','','','Arduina Mill. ex L.',1,'Arduina','Arduina','Arduina',1,0,'','','Mill.|L.','801d448b-8884-5788-b833-3e8f0ff4e82a','Arduina Mill. ex L.','Mill. ex L.','GENUS','Arduina','','','','','','',NULL,'','','','','','Mill.','','L.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('019a9268-774c-4c80-85e0-c227da8cdd28','','','Juglandaceae',1,'Juglandaceae','Juglandaceae','Juglandaceae',1,0,'','','','c226aaad-968b-590f-aa97-4befbe70089b','Juglandaceae','','FAMILY','Juglandaceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('019b0bb2-af81-423e-981a-cd0ad7655e69','','','Acaena buchananii var. inermis Bitter',1,'Acaena buchananii inermis','Acaena buchananii var. inermis','Acaena buchanan inerm',3,0,'','','Bitter','5e185f5d-e7e1-535b-ac2b-67c968c3a1c4','Acaena buchananii var. inermis Bitter','Bitter','VARIETY','','Acaena','','buchananii','inermis','','',NULL,'','','','','','Bitter','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('019fe65e-8e09-4ac3-a1a2-3816101acfcf','','','Diderma Pers.',1,'Diderma','Diderma','Diderma',1,0,'','','Pers.','3e36c3d5-5c6a-5f8c-afce-98a6db5f25da','Diderma Pers.','Pers.','GENUS','Diderma','','','','','','',NULL,'','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('019db0c8-cb8e-46ac-9c87-5a6f17bd525a','','','Ramalina geniculata Hook.f. & Taylor',1,'Ramalina geniculata','Ramalina geniculata','Ramalina geniculat',2,0,'','','Hook. fil.|Taylor','9009b1e7-9f28-550b-b5cb-9507e7b883ee','Ramalina geniculata Hook.f. & Taylor','Hook.f. & Taylor','SPECIES','','Ramalina','','geniculata','','','',NULL,'','','','','','Hook. fil. & Taylor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('019eb264-9689-4ada-9181-d0ac2b05c5b3','','','Lycoperdon constellatum Fr. & Nordholm',1,'Lycoperdon constellatum','Lycoperdon constellatum','Lycoperdon constellat',2,0,'','','Fr.|Nordholm','1931ee40-de09-5759-a095-c9a5b2d9cd4e','Lycoperdon constellatum Fr. & Nordholm','Fr. & Nordholm','SPECIES','','Lycoperdon','','constellatum','','','',NULL,'','','','','','Fr. & Nordholm','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01a72dfa-0341-4e7c-b253-3f6f10ba906c','','','Geotria',1,'Geotria','Geotria','Geotria',1,0,'','','','5079a45f-37de-55b1-b85e-e17151f08832','Geotria','','GENUS','Geotria','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01a850b5-a64c-4c7b-97e2-43d699211c19','','','Cercospora rhois E. Castell.',1,'Cercospora rhois','Cercospora rhois','Cercospora rho',2,0,'','','E. Castell.','7ce5de69-bf0a-5d3a-85a8-cc5e7c6b2c64','Cercospora rhois E. Castell.','E. Castell.','SPECIES','','Cercospora','','rhois','','','',NULL,'','','','','','E. Castell.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01a54897-200e-4d09-a135-893a634c9440','','','Eatoniella puniceomacer Ponder, 1965',1,'Eatoniella puniceomacer','Eatoniella puniceomacer','Eatoniella puniceomacer',2,0,'','','Ponder','036c06c9-0ab4-5ed6-b849-4a5d77a46640','Eatoniella puniceomacer Ponder, 1965','Ponder, 1965','SPECIES','','Eatoniella','','puniceomacer','','','',NULL,'','','','','','Ponder','','','','1965','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01a560c8-5904-4fec-9777-d8f0b7aa452c','','','Pleurosigma aestuarii (Brebisson) W. Smith',1,'Pleurosigma aestuarii','Pleurosigma aestuarii','Pleurosigma aestuar',2,0,'','','Brebisson|W. Smith','26dc6e4d-5696-53d7-9257-6f8cd4996629','Pleurosigma aestuarii (Brebisson) W. Smith','(Brebisson) W. Smith','SPECIES','','Pleurosigma','','aestuarii','','','',NULL,'W. Smith','','','','','Brebisson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01b14a6f-ae3c-4d30-8a36-3d52e072a6de','','','Zelandomyia penthoptera Alexander, 1924',1,'Zelandomyia penthoptera','Zelandomyia penthoptera','Zelandomyia penthopter',2,0,'','','Alexander','12734ecd-85be-52fd-95b0-1591e37e3269','Zelandomyia penthoptera Alexander, 1924','Alexander, 1924','SPECIES','','Zelandomyia','','penthoptera','','','',NULL,'','','','','','Alexander','','','','1924','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01acebf2-7045-4acb-8da8-73d15dffc64c','','','Poria illudens sensu G. Cunn.',4,'','','',NULL,NULL,'','','','','Poria illudens sensu G. Cunn.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01ad58f1-4e6d-4cb9-ad9a-8caa0468f517','','','Cuscuta pentagona Engelm.',1,'Cuscuta pentagona','Cuscuta pentagona','Cuscuta pentagon',2,0,'','','Engelm.','e5b2bf41-a845-5591-94e0-01383308063b','Cuscuta pentagona Engelm.','Engelm.','SPECIES','','Cuscuta','','pentagona','','','',NULL,'','','','','','Engelm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01ac0f9c-ac50-4b18-9afe-ae059f4975f0','','','Toxosporium camptospermum (Peck) Maubl.',1,'Toxosporium camptospermum','Toxosporium camptospermum','Toxosporium camptosperm',2,0,'','','Peck|Maubl.','cf71bfbd-c5c9-5932-aa14-60531db0e711','Toxosporium camptospermum (Peck) Maubl.','(Peck) Maubl.','SPECIES','','Toxosporium','','camptospermum','','','',NULL,'Maubl.','','','','','Peck','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01bc94e8-f54f-468b-b212-37f75835c27f','','','Rhadinosomus acuminatus (Fabricius, 1775)',1,'Rhadinosomus acuminatus','Rhadinosomus acuminatus','Rhadinosomus acuminat',2,0,'','','Fabricius','6a93a19c-a0df-55fe-8861-361ffe46eb64','Rhadinosomus acuminatus (Fabricius, 1775)','(Fabricius, 1775)','SPECIES','','Rhadinosomus','','acuminatus','','','',NULL,'','','','','','Fabricius','','','','1775','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01bc39fa-672e-48f0-8921-ac62c2b8235c','','','Kettlotrechus millari Townsend, 2010',1,'Kettlotrechus millari','Kettlotrechus millari','Kettlotrechus millar',2,0,'','','Townsend','713b92b5-d8c2-5eff-99e6-a8d63f3b996a','Kettlotrechus millari Townsend, 2010','Townsend, 2010','SPECIES','','Kettlotrechus','','millari','','','',NULL,'','','','','','Townsend','','','','2010','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('01bb3fd7-6343-4fd1-b9b3-e308b4fce6c3','','','Amandinea austroconiops Elix & Kantvilas',1,'Amandinea austroconiops','Amandinea austroconiops','Amandinea austroconiops',2,0,'','','Elix|Kantvilas','321c36a7-08c7-509c-8d3e-f5459df87821','Amandinea austroconiops Elix & Kantvilas','Elix & Kantvilas','SPECIES','','Amandinea','','austroconiops','','','',NULL,'','','','','','Elix & Kantvilas','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00043116-38c2-4891-82e4-2cc0a266c800','','','Lophodermium miscanthi Tehon',1,'Lophodermium miscanthi','Lophodermium miscanthi','Lophodermium miscanth',2,0,'','','Tehon','600f8716-67f7-520f-8b90-ce34d40282d5','Lophodermium miscanthi Tehon','Tehon','SPECIES','','Lophodermium','','miscanthi','','','',NULL,'','','','','','Tehon','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('000a6721-5863-4c6e-a348-6b13b3f36322','','','Wittrockia Lindm.',1,'Wittrockia','Wittrockia','Wittrockia',1,0,'','','Lindm.','63924996-461e-5eb9-a8d3-9b06f8207991','Wittrockia Lindm.','Lindm.','GENUS','Wittrockia','','','','','','',NULL,'','','','','','Lindm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00073cbb-6418-45ff-a7f4-c1b82f91c96e','','','Geastrum Pers.',1,'Geastrum','Geastrum','Geastrum',1,0,'','','Pers.','d4681442-b620-5acf-84ef-6673964683c0','Geastrum Pers.','Pers.','GENUS','Geastrum','','','','','','',NULL,'','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('000c1ee0-94d3-4053-85df-165ebb59f223','','','Arcellina',1,'Arcellina','Arcellina','Arcellina',1,0,'','','','611b1ff4-3cf4-582a-a779-f68ab56bba95','Arcellina','','SUBORDER','Arcellina','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('000cae44-31c8-462c-bc09-263c0b732f95','','','Patella subg. Scutellastra',2,'Scutellastra','Patella subgen. Scutellastra','Scutellastra',1,0,'','','','3ec580bc-47ea-58d1-8144-0e04d61c36a3','Patella subg. Scutellastra','','SUBGENUS','Scutellastra','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00116cad-2fc7-42a1-bfaf-a2949d248cab','','','Ruppia spiralis sensu New Zealand Botanists',4,'','','',NULL,NULL,'','','','','Ruppia spiralis sensu New Zealand Botanists','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0010cb7a-bd2f-45f7-900b-a793c03ba2da','','','Molophilus howesi Alexander, 1923',1,'Molophilus howesi','Molophilus howesi','Molophilus howes',2,0,'','','Alexander','faf1b679-e3bd-5fd8-8dd8-9ce04bf915b1','Molophilus howesi Alexander, 1923','Alexander, 1923','SPECIES','','Molophilus','','howesi','','','',NULL,'','','','','','Alexander','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('000ce14e-8a85-47e2-a9b1-d8deece5f75c','','','Carex megalepis K.A.Ford',1,'Carex megalepis','Carex megalepis','Carex megalep',2,0,'','','K. A. Ford','a90c0c5c-f587-519a-923b-265276e6947a','Carex megalepis K.A.Ford','K.A.Ford','SPECIES','','Carex','','megalepis','','','',NULL,'','','','','','K. A. Ford','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('001371ed-fc8e-4d95-a194-318aaa37805a','','','Erwinia carotovora subsp. betavasculorum Thomson et al., 1984',1,'Erwinia carotovora betavasculorum','Erwinia carotovora subsp. betavasculorum','Erwinia carotouor betauasculor',3,0,'','','Thomson et al.','61f41fb1-b722-58bd-b93f-7ebf699e0fd0','Erwinia carotovora subsp. betavasculorum Thomson et al., 1984','Thomson et al., 1984','SUBSPECIES','','Erwinia','','carotovora','betavasculorum','','',NULL,'','','','','','Thomson et al.','','','','1984','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('001419d0-dbfe-4c3a-b3b6-592331248556','','','Nestor productus (Gould)',1,'Nestor productus','Nestor productus','Nestor product',2,0,'','','Gould','f7217306-fd5f-5826-ac47-ddab25c2cb73','Nestor productus (Gould)','(Gould)','SPECIES','','Nestor','','productus','','','',NULL,'','','','','','Gould','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00129d97-6939-490c-821a-7d186631cfc6','','','Bathypathes',1,'Bathypathes','Bathypathes','Bathypathes',1,0,'','','','aa20f474-f6a3-5f68-8b4e-e10630c01cec','Bathypathes','','GENUS','Bathypathes','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00167769-dc7a-44e3-85eb-7d2ff36dfe4a','','','Hippoboscoidea',1,'Hippoboscoidea','Hippoboscoidea','Hippoboscoidea',1,0,'','','','007aff3b-97b5-5e52-8b8c-759e9a390776','Hippoboscoidea','','SUPERFAMILY','Hippoboscoidea','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0016cb15-32ce-47af-b7c6-91e9711621e8','','','Lithocampe furcaspiculata (Popofsky, 1908)',1,'Lithocampe furcaspiculata','Lithocampe furcaspiculata','Lithocampe furcaspiculat',2,0,'','','Popofsky','ffcd7a90-702a-5d1f-8a70-e3b520aa1f27','Lithocampe furcaspiculata (Popofsky, 1908)','(Popofsky, 1908)','SPECIES','','Lithocampe','','furcaspiculata','','','',NULL,'','','','','','Popofsky','','','','1908','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('001401d9-605a-453f-adac-efa6ff1bc90b','','','Coccocarpia gyrophoroides Räsänen',1,'Coccocarpia gyrophoroides','Coccocarpia gyrophoroides','Coccocarpia gyrophoroid',2,0,'','','Räsänen','e7b3cab7-1062-5f08-bd5c-529bd0e8b34c','Coccocarpia gyrophoroides Räsänen','Räsänen','SPECIES','','Coccocarpia','','gyrophoroides','','','',NULL,'','','','','','Räsänen','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0019c457-b5d6-4808-9c56-30508646f79c','','','Adiantum fulvum Raoul',1,'Adiantum fulvum','Adiantum fulvum','Adiantum fulu',2,0,'','','Raoul','d5fff786-dc4a-5a47-9df4-772450e6f999','Adiantum fulvum Raoul','Raoul','SPECIES','','Adiantum','','fulvum','','','',NULL,'','','','','','Raoul','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('001a59e4-8fad-4227-a240-abea7ae3134f','','','Liochoria huttoni Pascoe, 1875',1,'Liochoria huttoni','Liochoria huttoni','Liochoria hutton',2,0,'','','Pascoe','eafdbbde-2d8a-5894-9fb8-306dc5f535cd','Liochoria huttoni Pascoe, 1875','Pascoe, 1875','SPECIES','','Liochoria','','huttoni','','','',NULL,'','','','','','Pascoe','','','','1875','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00171e87-773c-4607-94aa-b596b4117120','','','Lotus tenuis Willd.',1,'Lotus tenuis','Lotus tenuis','Lotus tenu',2,0,'','','Willd.','1605c501-ac2d-5945-b4cd-248bddb7bc1f','Lotus tenuis Willd.','Willd.','SPECIES','','Lotus','','tenuis','','','',NULL,'','','','','','Willd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00218dca-8997-4518-84c0-38477f2f8d04','','','Trimmatostroma betulinum (Corda) S. Hughes',1,'Trimmatostroma betulinum','Trimmatostroma betulinum','Trimmatostroma betulin',2,0,'','','Corda|S. Hughes','daf32828-ec57-542a-a61e-3537bc1109f1','Trimmatostroma betulinum (Corda) S. Hughes','(Corda) S. Hughes','SPECIES','','Trimmatostroma','','betulinum','','','',NULL,'S. Hughes','','','','','Corda','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0021f7c5-f76d-4bd5-9075-811f1216411a','','','Lepidozia beckettiana Steph.',1,'Lepidozia beckettiana','Lepidozia beckettiana','Lepidozia beckettian',2,0,'','','Steph.','b4083aa3-a1eb-5b61-9f6c-d7282de5dd56','Lepidozia beckettiana Steph.','Steph.','SPECIES','','Lepidozia','','beckettiana','','','',NULL,'','','','','','Steph.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00203584-248c-4bcb-b081-9fb05aa49824','','','Lecidea fineranii C.W.Dodge',1,'Lecidea fineranii','Lecidea fineranii','Lecidea fineran',2,0,'','','C. W. Dodge','f24dcdcc-3bbd-531b-9920-47271abfc2d8','Lecidea fineranii C.W.Dodge','C.W.Dodge','SPECIES','','Lecidea','','fineranii','','','',NULL,'','','','','','C. W. Dodge','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0029089a-1b11-482c-9a32-16843b9e1bac','','','Phyllachne sedifolia (G.Forst.) F.Muell.',1,'Phyllachne sedifolia','Phyllachne sedifolia','Phyllachne sedifol',2,0,'','','G. Forst.|F. Muell.','99f5f9c3-b185-5f20-8f51-f053206a37d1','Phyllachne sedifolia (G.Forst.) F.Muell.','(G.Forst.) F.Muell.','SPECIES','','Phyllachne','','sedifolia','','','',NULL,'F. Muell.','','','','','G. Forst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0022ae39-8dc1-4025-9954-5f62df22523b','','','Dawsicola Döbbeler',1,'Dawsicola','Dawsicola','Dawsicola',1,0,'','','Döbbeler','f055a264-f5de-572c-968f-ad21f80e66c4','Dawsicola Döbbeler','Döbbeler','GENUS','Dawsicola','','','','','','',NULL,'','','','','','Döbbeler','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('002371a9-261f-48cc-9252-d6b5908cd7f1','','','Phyllotopsidaceae Locquin ex Olariaga, Huhtinen, Læssøe, J.H. Petersen & K. Hansen',1,'Phyllotopsidaceae','Phyllotopsidaceae','Phyllotopsidaceae',1,0,'','','Locquin|Olariaga|Huhtinen|Læssøe|J. H. Petersen|K. Hansen','eb521f50-cd84-5503-bbc8-04ee7a3c8399','Phyllotopsidaceae Locquin ex Olariaga, Huhtinen, Læssøe, J.H. Petersen & K. Hansen','Locquin ex Olariaga, Huhtinen, Læssøe, J.H. Petersen & K. Hansen','FAMILY','Phyllotopsidaceae','','','','','','',NULL,'','','','','','Locquin','','Olariaga, Huhtinen, Læssøe, J. H. Petersen & K. Hansen','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('002d6d12-dc93-4821-823d-5d6034acc931','','','Poria nitida Pers.',1,'Poria nitida','Poria nitida','Poria nitid',2,0,'','','Pers.','ecaceeb6-391f-5693-94b2-8488d5f68fdb','Poria nitida Pers.','Pers.','SPECIES','','Poria','','nitida','','','',NULL,'','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('002cc85d-317c-4394-9353-79cad6cf14c7','','','Bouganinvilliidae',1,'Bouganinvilliidae','Bouganinvilliidae','Bouganinvilliidae',1,0,'','','','6bb8110d-1ed9-5052-85c2-8adc1450bd57','Bouganinvilliidae','','FAMILY','Bouganinvilliidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('002a8516-34fa-4265-b90c-8fef9edd97c2','','','Omphalina cremea (G. Stev.) O.K. Mill.',1,'Omphalina cremea','Omphalina cremea','Omphalina creme',2,0,'','','G. Stev.|O. K. Mill.','d8257736-97db-5160-bf68-cad2a68f3fe2','Omphalina cremea (G. Stev.) O.K. Mill.','(G. Stev.) O.K. Mill.','SPECIES','','Omphalina','','cremea','','','',NULL,'O. K. Mill.','','','','','G. Stev.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0034cbda-71f4-4894-9967-23fe35a02bab','','','Neoerysiphe joerstadii V.P. Heluta & S. Takam.',1,'Neoerysiphe joerstadii','Neoerysiphe joerstadii','Neoerysiphe ioerstad',2,0,'','','V. P. Heluta|S. Takam.','23e50d1b-ba07-505b-a6a0-7cff873eee45','Neoerysiphe joerstadii V.P. Heluta & S. Takam.','V.P. Heluta & S. Takam.','SPECIES','','Neoerysiphe','','joerstadii','','','',NULL,'','','','','','V. P. Heluta & S. Takam.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00342793-73e0-4917-beab-ac5591d17d88','','','Hyphoderma neopuberum Sheng H. Wu',1,'Hyphoderma neopuberum','Hyphoderma neopuberum','Hyphoderma neopuber',2,0,'','','Sheng H. Wu','eec1940a-a8b9-50aa-afdf-ac266a7b3947','Hyphoderma neopuberum Sheng H. Wu','Sheng H. Wu','SPECIES','','Hyphoderma','','neopuberum','','','',NULL,'','','','','','Sheng H. Wu','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00354cef-f6e0-4897-99fd-0647d6a353ae','','','Halalaimus subg. Halalaimus',2,'Halalaimus','Halalaimus subgen. Halalaimus','Halalaimus',1,0,'','','','139103c4-24b5-51e8-8a6d-bd41e6f12edc','Halalaimus subg. Halalaimus','','SUBGENUS','Halalaimus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00387241-a194-42b0-a135-0c363d11ec15','','','Pumilus antiquatus Atkins, 1958',1,'Pumilus antiquatus','Pumilus antiquatus','Pumilus antiquat',2,0,'','','Atkins','30f50972-6844-5ec2-89ce-da99df6dda2b','Pumilus antiquatus Atkins, 1958','Atkins, 1958','SPECIES','','Pumilus','','antiquatus','','','',NULL,'','','','','','Atkins','','','','1958','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0034e2a1-5a24-4127-96db-8f39e2977539','','','Corticium bombycinum (Sommerf.) Bres.',1,'Corticium bombycinum','Corticium bombycinum','Corticium bombycin',2,0,'','','Sommerf.|Bres.','cbfa4152-fad7-5196-ab56-f72b182658c0','Corticium bombycinum (Sommerf.) Bres.','(Sommerf.) Bres.','SPECIES','','Corticium','','bombycinum','','','',NULL,'Bres.','','','','','Sommerf.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00376165-77bc-4fd4-9788-e0e48513a507','','','Cintractia gigantospora Liro',1,'Cintractia gigantospora','Cintractia gigantospora','Cintractia gigantospor',2,0,'','','Liro','be3cb6bc-7b82-57a4-83f0-383f4e501f77','Cintractia gigantospora Liro','Liro','SPECIES','','Cintractia','','gigantospora','','','',NULL,'','','','','','Liro','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('003e2a5f-0ea5-4771-8e0b-595f8b23b886','','','Allamanda neriifolia Hook.',1,'Allamanda neriifolia','Allamanda neriifolia','Allamanda neriifol',2,0,'','','Hook.','d3602606-30ab-556e-91a4-9fdf986c4ac8','Allamanda neriifolia Hook.','Hook.','SPECIES','','Allamanda','','neriifolia','','','',NULL,'','','','','','Hook.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('003ecf60-2e08-493c-9bfc-7d5cd725885e','','','Celerioriella prunicola (Damm & Crous) Crous',1,'Celerioriella prunicola','Celerioriella prunicola','Celerioriella prunicol',2,0,'','','Damm|Crous','9f179616-e8ae-5ee8-9f3b-7cf86e4379ea','Celerioriella prunicola (Damm & Crous) Crous','(Damm & Crous) Crous','SPECIES','','Celerioriella','','prunicola','','','',NULL,'Crous','','','','','Damm & Crous','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00414685-136b-43dc-a62c-d462b66aeb89','','','Lophocolea villosa Mitt. ex Steph.',1,'Lophocolea villosa','Lophocolea villosa','Lophocolea uillos',2,0,'','','Mitt.|Steph.','0acb662c-29a0-5aa4-a91a-2c7ce18aabdf','Lophocolea villosa Mitt. ex Steph.','Mitt. ex Steph.','SPECIES','','Lophocolea','','villosa','','','',NULL,'','','','','','Mitt.','','Steph.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02df384d-8c3b-4542-ac3b-6b2b4612ee28','','','Ischnoglossa rufa Cameron, 1945',1,'Ischnoglossa rufa','Ischnoglossa rufa','Ischnoglossa ruf',2,0,'','','Cameron','5644419e-1ace-5d2a-948c-6a29724a1b8b','Ischnoglossa rufa Cameron, 1945','Cameron, 1945','SPECIES','','Ischnoglossa','','rufa','','','',NULL,'','','','','','Cameron','','','','1945','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02ddc393-948e-4ffe-baff-d032264f0e5f','','','Cosmarium nasutum Nordst.',1,'Cosmarium nasutum','Cosmarium nasutum','Cosmarium nasut',2,0,'','','Nordst.','76a9c88b-e2ce-5306-97d2-7d8f842c89b8','Cosmarium nasutum Nordst.','Nordst.','SPECIES','','Cosmarium','','nasutum','','','',NULL,'','','','','','Nordst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02dd5e83-5f0e-4fb3-a4cb-f691fdf74a60','','','Zygomyia apicalis Tonnoir, 1927',1,'Zygomyia apicalis','Zygomyia apicalis','Zygomyia apical',2,0,'','','Tonnoir','d6eca5c3-29f8-5e50-b6b9-019906daae6f','Zygomyia apicalis Tonnoir, 1927','Tonnoir, 1927','SPECIES','','Zygomyia','','apicalis','','','',NULL,'','','','','','Tonnoir','','','','1927','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02e80030-68bb-4ea0-9ef2-5b6be2067614','','','Abutilon vitifolium (Cav.) G.Don',1,'Abutilon vitifolium','Abutilon vitifolium','Abutilon uitifoli',2,0,'','','Cav.|G. Don','2e031e1c-d3cd-50ff-b72a-01013f191f5d','Abutilon vitifolium (Cav.) G.Don','(Cav.) G.Don','SPECIES','','Abutilon','','vitifolium','','','',NULL,'G. Don','','','','','Cav.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02e62514-dae6-4b88-a757-c01ee8ffd803','','','Achyranthes repens L.',1,'Achyranthes repens','Achyranthes repens','Achyranthes repens',2,0,'','','L.','7d395ea7-56c6-5d7a-9ed5-ce3a66131d3b','Achyranthes repens L.','L.','SPECIES','','Achyranthes','','repens','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02ee47a9-d856-4e2b-9c17-203233dd2fbc','','','Eumalocostraca',1,'Eumalocostraca','Eumalocostraca','Eumalocostraca',1,0,'','','','c5ae580e-8e11-505a-8a9d-2f33148caab4','Eumalocostraca','','SUBCLASS','Eumalocostraca','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02f0263e-5805-4873-82c7-2f25121e7ea0','','','Hymenochaete gladiola G. Cunn.',1,'Hymenochaete gladiola','Hymenochaete gladiola','Hymenochaete gladiol',2,0,'','','G. Cunn.','5dd3dcee-6468-58ee-b672-2bc28e7bd518','Hymenochaete gladiola G. Cunn.','G. Cunn.','SPECIES','','Hymenochaete','','gladiola','','','',NULL,'','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02ef677a-2676-465e-b723-5ae08f303ece','','','Aporcelaimellus',1,'Aporcelaimellus','Aporcelaimellus','Aporcelaimellus',1,0,'','','','eef9b8a5-8494-5ef5-baf8-1fa47dd83fdf','Aporcelaimellus','','GENUS','Aporcelaimellus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02e8be8b-bfdf-44d8-b2aa-e177d92e6544','','','Hylurgus ligniperda (Fabricius, 1787)',1,'Hylurgus ligniperda','Hylurgus ligniperda','Hylurgus ligniperd',2,0,'','','Fabricius','6a282466-dcce-5d28-ad36-3ac5fed1312d','Hylurgus ligniperda (Fabricius, 1787)','(Fabricius, 1787)','SPECIES','','Hylurgus','','ligniperda','','','',NULL,'','','','','','Fabricius','','','','1787','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02ea8f88-1776-4e7a-8efe-fd0f28a80d5b','','','Rhodymenia sonderi P.C.Silva',1,'Rhodymenia sonderi','Rhodymenia sonderi','Rhodymenia sonder',2,0,'','','P. C. Silva','9ccae2e8-cb01-5b07-bff2-43cb7199bd9f','Rhodymenia sonderi P.C.Silva','P.C.Silva','SPECIES','','Rhodymenia','','sonderi','','','',NULL,'','','','','','P. C. Silva','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02f11e03-7558-4409-b727-1eea414a21cc','','','Lyperanthus suaveolens R.Br.',1,'Lyperanthus suaveolens','Lyperanthus suaveolens','Lyperanthus suaueolens',2,0,'','','R. Br.','0669c9aa-380c-5357-8118-65e51bd67148','Lyperanthus suaveolens R.Br.','R.Br.','SPECIES','','Lyperanthus','','suaveolens','','','',NULL,'','','','','','R. Br.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02f44659-aac3-4dd9-9e6e-7309625e327c','','','Tanypus Meigen, 1803',1,'Tanypus','Tanypus','Tanypus',1,0,'','','Meigen','a977be97-4e0e-5cf1-8ff5-d1fd20f69560','Tanypus Meigen, 1803','Meigen, 1803','GENUS','Tanypus','','','','','','',NULL,'','','','','','Meigen','','','','1803','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02f6a469-fbc8-402d-a224-94b750dc3b5a','','','Microsporum praecox Rivalier ex A.A. Padhye, Ajello & McGinnis',1,'Microsporum praecox','Microsporum praecox','Microsporum praecox',2,0,'','','Rivalier|A. A. Padhye|Ajello|McGinnis','72160462-0590-5551-9a8c-b9f8b53295fa','Microsporum praecox Rivalier ex A.A. Padhye, Ajello & McGinnis','Rivalier ex A.A. Padhye, Ajello & McGinnis','SPECIES','','Microsporum','','praecox','','','',NULL,'','','','','','Rivalier','','A. A. Padhye, Ajello & McGinnis','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02f8eab1-54c4-4acf-b78d-16795214dd2a','','','Asaphodes mnesichola (Meyrick, 1888)',1,'Asaphodes mnesichola','Asaphodes mnesichola','Asaphodes mnesichol',2,0,'','','Meyrick','e410805e-4834-570f-86f3-9119b747d205','Asaphodes mnesichola (Meyrick, 1888)','(Meyrick, 1888)','SPECIES','','Asaphodes','','mnesichola','','','',NULL,'','','','','','Meyrick','','','','1888','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02f93e75-acec-4390-9d17-a7cc65ae76a0','','','Zanchius totus Eyles, 2005',1,'Zanchius totus','Zanchius totus','Zanchius tot',2,0,'','','Eyles','71430514-c961-5534-978d-8e8557ce7706','Zanchius totus Eyles, 2005','Eyles, 2005','SPECIES','','Zanchius','','totus','','','',NULL,'','','','','','Eyles','','','','2005','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('02fde91d-90da-429e-aad1-e4596d9f7fdd','','','Hoherius',1,'Hoherius','Hoherius','Hoherius',1,0,'','','','26c17369-8f2b-508b-ad3c-85b9f06acbdc','Hoherius','','GENUS','Hoherius','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0306d671-7b93-4d8e-bfbf-17b301db3ee4','','','Lachnum rehmii (Staritz) Rehm',1,'Lachnum rehmii','Lachnum rehmii','Lachnum rehm',2,0,'','','Staritz|Rehm','0ddcb60c-f5c7-5743-a95d-9d70b0f1f8c1','Lachnum rehmii (Staritz) Rehm','(Staritz) Rehm','SPECIES','','Lachnum','','rehmii','','','',NULL,'Rehm','','','','','Staritz','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('030206d8-b09a-4c9b-825a-81aa39b4d67c','','','Lomaria minor (R.Br.) Spreng.',1,'Lomaria minor','Lomaria minor','Lomaria minor',2,0,'','','R. Br.|Spreng.','676b9827-a8b7-5853-9e0a-b54a256dca16','Lomaria minor (R.Br.) Spreng.','(R.Br.) Spreng.','SPECIES','','Lomaria','','minor','','','',NULL,'Spreng.','','','','','R. Br.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0300f5f1-91fc-48d6-a27d-b40f883ac5d8','','','Microcystaceae',1,'Microcystaceae','Microcystaceae','Microcystaceae',1,0,'','','','245da397-6f67-5230-8683-e91d9c115e6b','Microcystaceae','','FAMILY','Microcystaceae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03066d6d-1b0b-4b59-bef8-c9910ba88137','','','Anous tenuirostris minutus Boie',1,'Anous tenuirostris minutus','Anous tenuirostris minutus','Anous tenuirostr minut',3,0,'','','Boie','69f8a7ba-55cd-5a73-9b59-adc2905af8a2','Anous tenuirostris minutus Boie','Boie','SUBSPECIES','','Anous','','tenuirostris','minutus','','',NULL,'','','','','','Boie','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('030c1966-0dc7-44ad-b8c7-1785af36cafc','','','Agrostis tenuis Sibth.',1,'Agrostis tenuis','Agrostis tenuis','Agrostis tenu',2,0,'','','Sibth.','42e32873-d683-5be4-bdad-8d86c2fa886b','Agrostis tenuis Sibth.','Sibth.','SPECIES','','Agrostis','','tenuis','','','',NULL,'','','','','','Sibth.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('030e296c-ef1e-416b-a13b-47e9d2b68785','','','Trichodochium Syd.',1,'Trichodochium','Trichodochium','Trichodochium',1,0,'','','Syd.','11edec1a-c828-564b-be6d-af26da4728c4','Trichodochium Syd.','Syd.','GENUS','Trichodochium','','','','','','',NULL,'','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('030c34b3-8f0c-437e-ba73-7a1237e571f6','','','Philonotis hastata (Duby) Wijk & Margad.',1,'Philonotis hastata','Philonotis hastata','Philonotis hastat',2,0,'','','Duby|Wijk|Margad.','04639b94-1889-5acf-9a3b-ea7219147420','Philonotis hastata (Duby) Wijk & Margad.','(Duby) Wijk & Margad.','SPECIES','','Philonotis','','hastata','','','',NULL,'Wijk & Margad.','','','','','Duby','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('030df958-f32b-40d1-94fb-e1a58cebd4c4','','','Tricholoma equestre (L.) P. Kumm.',1,'Tricholoma equestre','Tricholoma equestre','Tricholoma equestr',2,0,'','','L.|P. Kumm.','2137f4b1-34c8-5d91-9c54-ad1133fee8b7','Tricholoma equestre (L.) P. Kumm.','(L.) P. Kumm.','SPECIES','','Tricholoma','','equestre','','','',NULL,'P. Kumm.','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03118769-5f74-4084-844a-09e3c1da02d3','','','Panicum maximum Jacq.',1,'Panicum maximum','Panicum maximum','Panicum maxim',2,0,'','','Jacq.','75447809-8e3c-55ef-ad3b-8fbd704aca7c','Panicum maximum Jacq.','Jacq.','SPECIES','','Panicum','','maximum','','','',NULL,'','','','','','Jacq.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0315f9e7-26cd-4882-81ec-59c2ac6dd942','','','Plectranthus oertendahlii T.C.E.Fr.',1,'Plectranthus oertendahlii','Plectranthus oertendahlii','Plectranthus oertendahl',2,0,'','','T. C. E. Fr.','6111669e-c652-5fbf-8792-b139efa41ea9','Plectranthus oertendahlii T.C.E.Fr.','T.C.E.Fr.','SPECIES','','Plectranthus','','oertendahlii','','','',NULL,'','','','','','T. C. E. Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0314c745-9f25-483b-a301-da630a67d97e','','','Staurastrum subradians Rich',1,'Staurastrum subradians','Staurastrum subradians','Staurastrum subradians',2,0,'','','Rich','36380467-fa86-54c6-8f3c-eb2cec01fb4e','Staurastrum subradians Rich','Rich','SPECIES','','Staurastrum','','subradians','','','',NULL,'','','','','','Rich','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0316abc0-ea89-4cef-ac3b-f1aeb64c92b3','','','Carex muelleri Petrie',1,'Carex muelleri','Carex muelleri','Carex mueller',2,0,'','','Petrie','aa22428a-8f6f-585d-802e-ce18822ad7f1','Carex muelleri Petrie','Petrie','SPECIES','','Carex','','muelleri','','','',NULL,'','','','','','Petrie','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0317e96f-1c87-4ab7-ba50-09d311793087','','','Stictocarbo',1,'Stictocarbo','Stictocarbo','Stictocarbo',1,0,'','','','600c8e71-154d-5faa-bbe7-ffd60e94ee02','Stictocarbo','','GENUS','Stictocarbo','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('031b9e20-564f-4aa6-a7c6-52823cb516c2','','','Hoogstraalia',1,'Hoogstraalia','Hoogstraalia','Hoogstraalia',1,0,'','','','df4c0cf5-539d-5f77-8ec5-919d86089f5a','Hoogstraalia','','GENUS','Hoogstraalia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0317b3c3-df0f-48fc-b1f7-5e21db7459f3','','','Attenuata regis (Powell, 1940)',1,'Attenuata regis','Attenuata regis','Attenuata reg',2,0,'','','Powell','9e2f23d5-df2d-5f70-a8a1-de916519db93','Attenuata regis (Powell, 1940)','(Powell, 1940)','SPECIES','','Attenuata','','regis','','','',NULL,'','','','','','Powell','','','','1940','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0318fe09-7f24-422f-96ec-97df279bd94d','','','Epipolasis novaezealandiae Dendy, 1924',1,'Epipolasis novaezealandiae','Epipolasis novaezealandiae','Epipolasis nouaezealandi',2,0,'','','Dendy','7080f767-ee94-5250-99df-2ad78538cdf8','Epipolasis novaezealandiae Dendy, 1924','Dendy, 1924','SPECIES','','Epipolasis','','novaezealandiae','','','',NULL,'','','','','','Dendy','','','','1924','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('031a4f54-4099-40d7-8664-c9fb1e46219b','','','Cyphotelus angustifrons Sharp, 1878',1,'Cyphotelus angustifrons','Cyphotelus angustifrons','Cyphotelus angustifrons',2,0,'','','Sharp','5fbff4fe-686e-5d4e-b4a0-74a0e43f3097','Cyphotelus angustifrons Sharp, 1878','Sharp, 1878','SPECIES','','Cyphotelus','','angustifrons','','','',NULL,'','','','','','Sharp','','','','1878','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03239f20-8601-4626-90a3-31a726c28b82','','','Brachyglottis repanda J.R.Forst. & G.Forst. var. repanda',1,'Brachyglottis repanda repanda','Brachyglottis repanda var. repanda','Brachyglottis repand repand',3,0,'','','','5a76f160-2ae1-5515-8c8e-0c7191ea1278','Brachyglottis repanda J.R.Forst. & G.Forst. var. repanda','','VARIETY','','Brachyglottis','','repanda','repanda','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('008ba502-15b9-4a4f-a2ec-cdf7cd0f0972','','','Cymatoderma elegans var. lamellatum (Berk. & M.A. Curtis) D.A. Reid',1,'Cymatoderma elegans lamellatum','Cymatoderma elegans var. lamellatum','Cymatoderma elegans lamellat',3,0,'','','Berk.|M. A. Curtis|D. A. Reid','a68e2465-3954-54a7-8394-aa594bf8e952','Cymatoderma elegans var. lamellatum (Berk. & M.A. Curtis) D.A. Reid','(Berk. & M.A. Curtis) D.A. Reid','VARIETY','','Cymatoderma','','elegans','lamellatum','','',NULL,'D. A. Reid','','','','','Berk. & M. A. Curtis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('008e2310-d366-4c49-a99a-0101800186d7','','','Lythrum virgatum ''Dropmore Purple''',1,'Lythrum virgatum ‘Dropmore Purple’','Lythrum virgatum ‘Dropmore Purple’','Lythrum uirgat ‘Dropmore Purple’',3,0,'','','','ca6cefce-8cee-5736-bab5-c66cff4c4de6','Lythrum virgatum ''Dropmore Purple''','','CULTIVAR','','Lythrum','','virgatum','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('009282cb-a5a2-458e-960d-1fdec87fe407','','','Chlamydocapsa planctonica (W.& G.S.West) Fott',1,'Chlamydocapsa planctonica','Chlamydocapsa planctonica','Chlamydocapsa planctonic',2,0,'','','W.|G. S. West|Fott','14de50d0-1ad5-5672-b39d-0d1d057d841b','Chlamydocapsa planctonica (W.& G.S.West) Fott','(W.& G.S.West) Fott','SPECIES','','Chlamydocapsa','','planctonica','','','',NULL,'Fott','','','','','W. & G. S. West','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('008df969-6cf6-4c2b-8c6f-a821deecf0aa','','','Megaloceroea Fieber, 1858',1,'Megaloceroea','Megaloceroea','Megaloceroea',1,0,'','','Fieber','cb34266d-bbc1-592e-9a6f-eb7737e6f487','Megaloceroea Fieber, 1858','Fieber, 1858','GENUS','Megaloceroea','','','','','','',NULL,'','','','','','Fieber','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('008f03ee-9065-40cc-8bc7-bbdce35a1bd7','','','Chaenusa helmorei Berry, 2007',1,'Chaenusa helmorei','Chaenusa helmorei','Chaenusa helmore',2,0,'','','Berry','28247e1b-b12f-50a2-8dc0-c8cf504170b8','Chaenusa helmorei Berry, 2007','Berry, 2007','SPECIES','','Chaenusa','','helmorei','','','',NULL,'','','','','','Berry','','','','2007','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0095d5d6-1d91-4e37-b82b-4e8087064861','','','Epilobium cockayneanum Petrie',1,'Epilobium cockayneanum','Epilobium cockayneanum','Epilobium cockaynean',2,0,'','','Petrie','c67e96c3-4550-5882-8c83-53267b41c995','Epilobium cockayneanum Petrie','Petrie','SPECIES','','Epilobium','','cockayneanum','','','',NULL,'','','','','','Petrie','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00942a6a-f98e-4d55-a8fa-64738ffe1199','','','Cicindela halli Broun, 1917',1,'Cicindela halli','Cicindela halli','Cicindela hall',2,0,'','','Broun','a70226d2-0eb7-5f90-8e7e-00db32558c6e','Cicindela halli Broun, 1917','Broun, 1917','SPECIES','','Cicindela','','halli','','','',NULL,'','','','','','Broun','','','','1917','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00955f66-273e-45cb-b50f-cc7e5730504e','','','Pityrosporum ovale (Bizz.) Castell. & Chalm.',1,'Pityrosporum ovale','Pityrosporum ovale','Pityrosporum oual',2,0,'','','Bizz.|Castell.|Chalm.','68852141-552e-5017-9188-4f0002f32191','Pityrosporum ovale (Bizz.) Castell. & Chalm.','(Bizz.) Castell. & Chalm.','SPECIES','','Pityrosporum','','ovale','','','',NULL,'Castell. & Chalm.','','','','','Bizz.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('009be26e-a9b3-48ee-9679-3d80b588ad0b','','','Zasmidium cerophilum (Tubaki) U. Braun, C. Nakash., Videira & Crous',1,'Zasmidium cerophilum','Zasmidium cerophilum','Zasmidium cerophil',2,0,'','','Tubaki|U. Braun|C. Nakash.|Videira|Crous','20bdb716-9c44-56c5-ba24-5cac7b2d06cc','Zasmidium cerophilum (Tubaki) U. Braun, C. Nakash., Videira & Crous','(Tubaki) U. Braun, C. Nakash., Videira & Crous','SPECIES','','Zasmidium','','cerophilum','','','',NULL,'U. Braun, C. Nakash., Videira & Crous','','','','','Tubaki','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('009b2864-115e-4167-8bd5-f5a121550fde','','','Dacrydium mai A.Cunn.',1,'Dacrydium mai','Dacrydium mai','Dacrydium ma',2,0,'','','A. Cunn.','9160e6ef-112d-588f-a43a-ca2ac9425a05','Dacrydium mai A.Cunn.','A.Cunn.','SPECIES','','Dacrydium','','mai','','','',NULL,'','','','','','A. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00a58c66-017b-4e0e-9767-046ab3462a61','','','Orbilia xanthostigma (Fr.) Fr.',1,'Orbilia xanthostigma','Orbilia xanthostigma','Orbilia xanthostigm',2,0,'','','Fr.','93897e59-501e-5a3a-9fea-5780fa6150f8','Orbilia xanthostigma (Fr.) Fr.','(Fr.) Fr.','SPECIES','','Orbilia','','xanthostigma','','','',NULL,'Fr.','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00a0319b-01e8-44ad-ae75-14b5a63258b7','','','Aspergillus foeniculicola Udagawa',1,'Aspergillus foeniculicola','Aspergillus foeniculicola','Aspergillus foeniculicol',2,0,'','','Udagawa','f9a3e291-e9a7-59b9-a65d-06acfe597a96','Aspergillus foeniculicola Udagawa','Udagawa','SPECIES','','Aspergillus','','foeniculicola','','','',NULL,'','','','','','Udagawa','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('009f8372-174f-419c-8ea2-b726802ba354','','','Holophrya',1,'Holophrya','Holophrya','Holophrya',1,0,'','','','d9c61cbf-a909-55bc-9b65-108aac42c37f','Holophrya','','GENUS','Holophrya','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00a724b7-e12e-4842-a78f-c595a5c224d2','','','Lemonniera species',4,'','','',NULL,NULL,'','','','','Lemonniera species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00a62e8f-e31d-4684-b551-db6f39326036','','','Stigeoclonium amoenum Kütz.',1,'Stigeoclonium amoenum','Stigeoclonium amoenum','Stigeoclonium amoen',2,0,'','','Kütz.','18eaa093-f043-58dc-9b5b-aa332304dba2','Stigeoclonium amoenum Kütz.','Kütz.','SPECIES','','Stigeoclonium','','amoenum','','','',NULL,'','','','','','Kütz.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00aa8597-876a-49d0-904b-08ebdd9e2dbe','','','Cryptosporella betulae (Tul. & C. Tul.) L.C. Mejía & Castl.',1,'Cryptosporella betulae','Cryptosporella betulae','Cryptosporella betul',2,0,'','','Tul.|C. Tul.|L. C. Mejía|Castl.','5fff8197-d58c-57cf-8932-fd8d1569207f','Cryptosporella betulae (Tul. & C. Tul.) L.C. Mejía & Castl.','(Tul. & C. Tul.) L.C. Mejía & Castl.','SPECIES','','Cryptosporella','','betulae','','','',NULL,'L. C. Mejía & Castl.','','','','','Tul. & C. Tul.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00aba681-8a30-4a57-a60b-a68592daadbf','','','Psalliota brunneola J.E. Lange',1,'Psalliota brunneola','Psalliota brunneola','Psalliota brunneol',2,0,'','','J. E. Lange','e2731270-406a-5e56-a80e-b2445f0b5837','Psalliota brunneola J.E. Lange','J.E. Lange','SPECIES','','Psalliota','','brunneola','','','',NULL,'','','','','','J. E. Lange','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00a9f262-0760-467d-ac4f-ce3540347e3d','','','Galanthus L.',1,'Galanthus','Galanthus','Galanthus',1,0,'','','L.','fc3ee59e-de0a-585c-bc66-87ff1ca09e3e','Galanthus L.','L.','GENUS','Galanthus','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00b231f4-6361-41bf-bf92-1528f5325480','','','Peziza triangularis Schwein.',1,'Peziza triangularis','Peziza triangularis','Peziza triangular',2,0,'','','Schwein.','7022b51a-0e45-526e-9698-10e0a333cdac','Peziza triangularis Schwein.','Schwein.','SPECIES','','Peziza','','triangularis','','','',NULL,'','','','','','Schwein.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00b1b38c-df63-49e5-81a0-4a12b1e186e6','','','Oligosoma microlepis (Patterson & Daugherty, 1990)',1,'Oligosoma microlepis','Oligosoma microlepis','Oligosoma microlep',2,0,'','','Patterson|Daugherty','7f8a744e-9c17-56e0-91e5-42bb65c37111','Oligosoma microlepis (Patterson & Daugherty, 1990)','(Patterson & Daugherty, 1990)','SPECIES','','Oligosoma','','microlepis','','','',NULL,'','','','','','Patterson & Daugherty','','','','1990','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00afca6f-455a-4472-908e-ac1fff2d0c73','','','Urostylidae',1,'Urostylidae','Urostylidae','Urostylidae',1,0,'','','','0610357b-5048-5177-b969-432d22ec5106','Urostylidae','','FAMILY','Urostylidae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00ae0ef2-be96-4253-93e8-e102470b255a','','','Scythrididae Rebel, 1901',1,'Scythrididae','Scythrididae','Scythrididae',1,0,'','','Rebel','78a17403-a3d9-59ab-824b-3c7f936074d7','Scythrididae Rebel, 1901','Rebel, 1901','FAMILY','Scythrididae','','','','','','',NULL,'','','','','','Rebel','','','','1901','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00ba41c6-28a7-461a-80b7-0618f388fb96','','','Diomedea chionoptera Salvin, 1896',1,'Diomedea chionoptera','Diomedea chionoptera','Diomedea chionopter',2,0,'','','Salvin','3efeb70e-5a5b-5bc7-8a12-4e7e6f3ecd78','Diomedea chionoptera Salvin, 1896','Salvin, 1896','SPECIES','','Diomedea','','chionoptera','','','',NULL,'','','','','','Salvin','','','','1896','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00b602f4-d985-48fa-bc2b-7d2d2817efdb','','','Penicillium palmae Samson, Stolk & Frisvad',1,'Penicillium palmae','Penicillium palmae','Penicillium palm',2,0,'','','Samson|Stolk|Frisvad','832be763-62a3-50f8-8639-d7283f1cf7d2','Penicillium palmae Samson, Stolk & Frisvad','Samson, Stolk & Frisvad','SPECIES','','Penicillium','','palmae','','','',NULL,'','','','','','Samson, Stolk & Frisvad','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00bc90f8-e02e-4b65-9670-3e6f90638809','','','Kuwanina',1,'Kuwanina','Kuwanina','Kuwanina',1,0,'','','','82481236-b6ce-591d-9d40-1beae3ae4f1a','Kuwanina','','GENUS','Kuwanina','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00bf72ad-707f-4815-8504-767fc3ca0a2d','','','Antithamnion',1,'Antithamnion','Antithamnion','Antithamnion',1,0,'','','','ce1969a5-b9f4-5a61-a6b5-ab95e70f0a85','Antithamnion','','GENUS','Antithamnion','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00c15a8e-b045-45fa-ba6e-7c52d345e0c2','','','Phyllhermannia',1,'Phyllhermannia','Phyllhermannia','Phyllhermannia',1,0,'','','','7afcf964-1dd2-5e98-9237-ef91010fb0b7','Phyllhermannia','','GENUS','Phyllhermannia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00c005cc-a42f-48f9-b209-a2135d46d8ac','','','Veronica ''Midsummer Beauty''',1,'Veronica ‘Midsummer Beauty’','Veronica ‘Midsummer Beauty’','Veronica ‘Midsummer Beauty’',2,0,'','','','00a0d003-6097-5f32-935b-969488508b82','Veronica ''Midsummer Beauty''','','CULTIVAR','Veronica','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00c1e707-0bf1-499d-ba70-ac931cea5313','','','Mecistostylus douei Lacordaire, 1866',1,'Mecistostylus douei','Mecistostylus douei','Mecistostylus doue',2,0,'','','Lacordaire','998840f1-7458-5974-924b-e7b15530ca51','Mecistostylus douei Lacordaire, 1866','Lacordaire, 1866','SPECIES','','Mecistostylus','','douei','','','',NULL,'','','','','','Lacordaire','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00c16179-2f84-4470-92fb-e26d2c9c81ae','','','Rhodococcus fascian (Tilford, 1936) Goodfellow 1984',1,'Rhodococcus fascian','Rhodococcus fascian','Rhodococcus fascian',2,0,'','','Tilford|Goodfellow','af215d3c-7614-5a13-be96-0620b1ba8ba4','Rhodococcus fascian (Tilford, 1936) Goodfellow 1984','(Tilford, 1936) Goodfellow 1984','SPECIES','','Rhodococcus','','fascian','','','',NULL,'Goodfellow','','','','1984','Tilford','','','','1936','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00c65380-1f14-4ea7-a1e3-1688fbfec443','','','Gastroptychus rogeri (Baba, 2000)',1,'Gastroptychus rogeri','Gastroptychus rogeri','Gastroptychus roger',2,0,'','','Baba','37371eb9-f4ca-5ff1-8d8c-b1edae1bc826','Gastroptychus rogeri (Baba, 2000)','(Baba, 2000)','SPECIES','','Gastroptychus','','rogeri','','','',NULL,'','','','','','Baba','','','','2000','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00c8af70-7cb6-4be1-a9cb-6d3c7fe4ddba','','','Dryopteris gongylodes var. glabra (Mett.) Domin',1,'Dryopteris gongylodes glabra','Dryopteris gongylodes var. glabra','Dryopteris gongylod glabr',3,0,'','','Mett.|Domin','db87b0a6-d4bf-5afe-a98a-2decc8c64297','Dryopteris gongylodes var. glabra (Mett.) Domin','(Mett.) Domin','VARIETY','','Dryopteris','','gongylodes','glabra','','',NULL,'Domin','','','','','Mett.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00c83b28-c77b-4611-82cf-92680317afce','','','Mesaphorura minutissima Salmon, 1944',1,'Mesaphorura minutissima','Mesaphorura minutissima','Mesaphorura minutissim',2,0,'','','Salmon','7b797813-120a-5577-ae07-db04e3f26ed8','Mesaphorura minutissima Salmon, 1944','Salmon, 1944','SPECIES','','Mesaphorura','','minutissima','','','',NULL,'','','','','','Salmon','','','','1944','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00c776eb-9151-4d9b-ad65-f9c5eb7de9f5','','','Oecophora hemimochla Meyrick, 1883',1,'Oecophora hemimochla','Oecophora hemimochla','Oecophora hemimochl',2,0,'','','Meyrick','cb50197c-64b2-5a33-bccd-a94df36c7b0b','Oecophora hemimochla Meyrick, 1883','Meyrick, 1883','SPECIES','','Oecophora','','hemimochla','','','',NULL,'','','','','','Meyrick','','','','1883','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00c90dc6-b24f-48bb-8540-29ddcb388c56','','','Rhodochorton purpureum (Lightf.) Rosenv.',1,'Rhodochorton purpureum','Rhodochorton purpureum','Rhodochorton purpure',2,0,'','','Lightf.|Rosenv.','2f671251-9cbb-59fb-9886-55e4a88c65a1','Rhodochorton purpureum (Lightf.) Rosenv.','(Lightf.) Rosenv.','SPECIES','','Rhodochorton','','purpureum','','','',NULL,'Rosenv.','','','','','Lightf.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00cef51c-5735-4e7e-b259-abeea3e89083','','','Hyphodontia brevidens (Pat.) Ryvarden',1,'Hyphodontia brevidens','Hyphodontia brevidens','Hyphodontia breuidens',2,0,'','','Pat.|Ryvarden','777bad98-ff2b-573d-b506-c4abacd526b0','Hyphodontia brevidens (Pat.) Ryvarden','(Pat.) Ryvarden','SPECIES','','Hyphodontia','','brevidens','','','',NULL,'Ryvarden','','','','','Pat.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00c9d7bc-77af-41d3-8774-c26e3fea3a13','','','Oxylasma vittiger Broun, 1883',1,'Oxylasma vittiger','Oxylasma vittiger','Oxylasma uittiger',2,0,'','','Broun','2e9433d6-1027-56b1-b8eb-1ceeefc4a4d0','Oxylasma vittiger Broun, 1883','Broun, 1883','SPECIES','','Oxylasma','','vittiger','','','',NULL,'','','','','','Broun','','','','1883','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00ccd308-6934-41d7-b44c-edaab431364c','','','Idris',1,'Idris','Idris','Idris',1,0,'','','','51f84d51-7432-5833-ab4d-615bcdd69a0c','Idris','','GENUS','Idris','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('00cee21e-d71d-4635-8d8d-efb4684e71ce','','','Chaetoceros socialis Lauder',1,'Chaetoceros socialis','Chaetoceros socialis','Chaetoceros social',2,0,'','','Lauder','8e813804-86a0-5d5e-80c2-41019b003d33','Chaetoceros socialis Lauder','Lauder','SPECIES','','Chaetoceros','','socialis','','','',NULL,'','','','','','Lauder','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0455de02-444c-4318-a1b0-2fcb1458389d','','','Tulostoma granulosum var. magnusianum Bres.',1,'Tulostoma granulosum magnusianum','Tulostoma granulosum var. magnusianum','Tulostoma granulos magnusian',3,0,'','','Bres.','76a41149-5afe-5bb8-b550-fb8efc1cd03b','Tulostoma granulosum var. magnusianum Bres.','Bres.','VARIETY','','Tulostoma','','granulosum','magnusianum','','',NULL,'','','','','','Bres.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04596233-fdb1-49e5-bf44-6b7421cd8140','','','Gen. indet. species indet. Hine et al., 2000',NULL,'','','',NULL,NULL,'','','','','Gen. indet. species indet. Hine et al., 2000','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('045a0709-1245-42c4-9a45-8c370a583ca0','','','Asperella Humb.',1,'Asperella','Asperella','Asperella',1,0,'','','Humb.','175ebce6-fd60-53e9-aea1-2667485acbbc','Asperella Humb.','Humb.','GENUS','Asperella','','','','','','',NULL,'','','','','','Humb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0455aa6b-2b18-472b-a4b9-ba0fba50b7e2','','','Allocasuarina L.A.S.Johnson',1,'Allocasuarina','Allocasuarina','Allocasuarina',1,0,'','','L. A. S. Johnson','b30a6f4d-f330-5ced-afee-a020d8b8687d','Allocasuarina L.A.S.Johnson','L.A.S.Johnson','GENUS','Allocasuarina','','','','','','',NULL,'','','','','','L. A. S. Johnson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('045b2cce-f3c3-4f16-96a2-18dcbe397f19','','','Acronota aterrima (Gravenhorst, 1802)',1,'Acronota aterrima','Acronota aterrima','Acronota aterrim',2,0,'','','Gravenhorst','bacfacbe-ea5c-50e6-adb7-20fb40342142','Acronota aterrima (Gravenhorst, 1802)','(Gravenhorst, 1802)','SPECIES','','Acronota','','aterrima','','','',NULL,'','','','','','Gravenhorst','','','','1802','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04629355-4a46-45b1-a50b-325ff5bc8a14','','','Thelidium papulare (Fr.) Arnold',1,'Thelidium papulare','Thelidium papulare','Thelidium papular',2,0,'','','Fr.|Arnold','af2d5c04-dc9a-565d-ad0b-903e4798893e','Thelidium papulare (Fr.) Arnold','(Fr.) Arnold','SPECIES','','Thelidium','','papulare','','','',NULL,'Arnold','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('046226b4-c34f-42ba-94b0-8d80395135f5','','','Cytoplea orientalis B. Sutton',1,'Cytoplea orientalis','Cytoplea orientalis','Cytoplea oriental',2,0,'','','B. Sutton','fefe1414-b074-51a0-937f-22aca23f8d7d','Cytoplea orientalis B. Sutton','B. Sutton','SPECIES','','Cytoplea','','orientalis','','','',NULL,'','','','','','B. Sutton','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('045bcac7-07f2-4f45-8288-dd1236d01df5','','','Volutella ciliata (Alb. & Schwein.) Fr.',1,'Volutella ciliata','Volutella ciliata','Volutella ciliat',2,0,'','','Alb.|Schwein.|Fr.','96254e6f-7e3c-58fd-8dc7-ab8bb44878cb','Volutella ciliata (Alb. & Schwein.) Fr.','(Alb. & Schwein.) Fr.','SPECIES','','Volutella','','ciliata','','','',NULL,'Fr.','','','','','Alb. & Schwein.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('046505be-8113-40bc-8425-489ac17617c1','','','Antholoba',1,'Antholoba','Antholoba','Antholoba',1,0,'','','','c0f968ff-86a0-5402-8c5f-f8c3c3ae837d','Antholoba','','GENUS','Antholoba','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0464fc75-a51e-4c51-9d33-629f63b65fac','','','Glyphipterix iocheaera Meyrick, 1880',1,'Glyphipterix iocheaera','Glyphipterix iocheaera','Glyphipterix iocheaer',2,0,'','','Meyrick','5c7e83e3-27f6-5c65-add5-b8d1d1005317','Glyphipterix iocheaera Meyrick, 1880','Meyrick, 1880','SPECIES','','Glyphipterix','','iocheaera','','','',NULL,'','','','','','Meyrick','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('046844c4-2260-4932-b474-a74245a2bbd6','','','Danthonia pilosa var. racemosa Buchanan',1,'Danthonia pilosa racemosa','Danthonia pilosa var. racemosa','Danthonia pilos racemos',3,0,'','','Buchanan','490995b5-f7a0-5521-a324-6e29346f6ceb','Danthonia pilosa var. racemosa Buchanan','Buchanan','VARIETY','','Danthonia','','pilosa','racemosa','','',NULL,'','','','','','Buchanan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0468e8da-ac7c-4054-acea-ee20bcd0d298','','','Alseuosmia quercifolia var. pusilla (Colenso) Kirk',1,'Alseuosmia quercifolia pusilla','Alseuosmia quercifolia var. pusilla','Alseuosmia quercifol pusill',3,0,'','','Colenso|Kirk','d2842272-d337-5578-b666-6c09efa0d3bf','Alseuosmia quercifolia var. pusilla (Colenso) Kirk','(Colenso) Kirk','VARIETY','','Alseuosmia','','quercifolia','pusilla','','',NULL,'Kirk','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('046895bf-0c75-42c6-9069-f53c8080aab2','','','Rhabditis',1,'Rhabditis','Rhabditis','Rhabditis',1,0,'','','','99cf427d-85c5-5376-beeb-057579a82854','Rhabditis','','GENUS','Rhabditis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('046c75d0-b770-4f85-a795-3c118b4c42cd','','','Mollisia benesuada (Tul.) W. Phillips',1,'Mollisia benesuada','Mollisia benesuada','Mollisia benesuad',2,0,'','','Tul.|W. Phillips','2809845b-006d-5703-915f-acf010a913bb','Mollisia benesuada (Tul.) W. Phillips','(Tul.) W. Phillips','SPECIES','','Mollisia','','benesuada','','','',NULL,'W. Phillips','','','','','Tul.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('046d5e01-240e-4b5c-8e9a-6044f0e9824e','','','Imbricatea',1,'Imbricatea','Imbricatea','Imbricatea',1,0,'','','','ea46a9ed-3797-598f-b9bf-61932bf1c0fd','Imbricatea','','CLASS','Imbricatea','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('046c08d5-3292-4b0d-8f95-6d8ee425312a','','','Facelinidae',1,'Facelinidae','Facelinidae','Facelinidae',1,0,'','','','cce7cf02-8eea-5f48-9c6d-30bd8ab1391a','Facelinidae','','FAMILY','Facelinidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('046d99f0-eee7-4de5-81f1-71b5b7222bc3','','','Biddulphia picturatum (Greville) Taylor',1,'Biddulphia picturatum','Biddulphia picturatum','Biddulphia picturat',2,0,'','','Greville|Taylor','9350ae86-1afe-5322-8746-8e9e2ede35e0','Biddulphia picturatum (Greville) Taylor','(Greville) Taylor','SPECIES','','Biddulphia','','picturatum','','','',NULL,'Taylor','','','','','Greville','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('046dfbf1-31ef-46f5-8498-f30103ad83f3','','','Sarcogyne corrugata Flot.',1,'Sarcogyne corrugata','Sarcogyne corrugata','Sarcogyne corrugat',2,0,'','','Flot.','d90df542-763a-52d1-83f8-64d92f185af3','Sarcogyne corrugata Flot.','Flot.','SPECIES','','Sarcogyne','','corrugata','','','',NULL,'','','','','','Flot.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0475db4c-9570-4c93-9418-6ffe06ed97b3','','','Phytodietus zealandicus (Ashmead, 1900)',1,'Phytodietus zealandicus','Phytodietus zealandicus','Phytodietus zealandic',2,0,'','','Ashmead','7d955567-6fc0-507b-9d85-02f9d1aa00e0','Phytodietus zealandicus (Ashmead, 1900)','(Ashmead, 1900)','SPECIES','','Phytodietus','','zealandicus','','','',NULL,'','','','','','Ashmead','','','','1900','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04731764-eca0-4e4f-bf3f-d29cb44b4165','','','Maoridrilus nelsoni Lee, 1959',1,'Maoridrilus nelsoni','Maoridrilus nelsoni','Maoridrilus nelson',2,0,'','','Lee','9e1fdd4d-1e41-553e-a569-5d4e1305fd8c','Maoridrilus nelsoni Lee, 1959','Lee, 1959','SPECIES','','Maoridrilus','','nelsoni','','','',NULL,'','','','','','Lee','','','','1959','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04780a6b-f3f2-4246-99f5-2e6a7d5d4598','','','Hoplothrips oudeus Mound & Walker, 1986',1,'Hoplothrips oudeus','Hoplothrips oudeus','Hoplothrips oude',2,0,'','','Mound|Walker','c82e2613-a62a-5ed3-ba4f-cc4d8f81fa29','Hoplothrips oudeus Mound & Walker, 1986','Mound & Walker, 1986','SPECIES','','Hoplothrips','','oudeus','','','',NULL,'','','','','','Mound & Walker','','','','1986','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('047cddc8-f4e3-4be7-bd35-4ec6a7d02ced','','','Chiloscyphus laxus Mitt.',1,'Chiloscyphus laxus','Chiloscyphus laxus','Chiloscyphus lax',2,0,'','','Mitt.','2e3c3cd1-7dfe-5353-bb40-d7d3fd9d5ce6','Chiloscyphus laxus Mitt.','Mitt.','SPECIES','','Chiloscyphus','','laxus','','','',NULL,'','','','','','Mitt.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0477296b-c429-47bd-a015-8096a964d687','','','Zetzellia oudemansi Wood, 1967',1,'Zetzellia oudemansi','Zetzellia oudemansi','Zetzellia oudemans',2,0,'','','Wood','7d476469-d046-5457-a9ed-6ac889e4bcc1','Zetzellia oudemansi Wood, 1967','Wood, 1967','SPECIES','','Zetzellia','','oudemansi','','','',NULL,'','','','','','Wood','','','','1967','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('048185af-8ee7-4722-8890-2e0e3beb39c9','','','Gnathostomata',1,'Gnathostomata','Gnathostomata','Gnathostomata',1,0,'','','','0a4cc1c3-75b5-5a54-b67d-af08e9ec4a1c','Gnathostomata','','SUPERCLASS','Gnathostomata','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0482a5f0-a06e-448a-96e4-3071f4015fa4','','','Patellaria fallaciosa Müll.Arg.',1,'Patellaria fallaciosa','Patellaria fallaciosa','Patellaria fallacios',2,0,'','','Müll. Arg.','61906704-a4ea-578d-8bda-6c94a97fd2ff','Patellaria fallaciosa Müll.Arg.','Müll.Arg.','SPECIES','','Patellaria','','fallaciosa','','','',NULL,'','','','','','Müll. Arg.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('047e8295-bd15-4b14-8aa6-7c0cec8ab006','','','Synthetonychidae',1,'Synthetonychidae','Synthetonychidae','Synthetonychidae',1,0,'','','','7fe18a3a-bf43-51ea-a46f-1105112025d5','Synthetonychidae','','FAMILY','Synthetonychidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('047f0361-a8f3-467a-9e12-c143bb7fe8f3','','','Epipterygium obovatum Ochyra',1,'Epipterygium obovatum','Epipterygium obovatum','Epipterygium obouat',2,0,'','','Ochyra','4bbd6084-91fd-58a5-a982-82490b3d1db0','Epipterygium obovatum Ochyra','Ochyra','SPECIES','','Epipterygium','','obovatum','','','',NULL,'','','','','','Ochyra','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0480f438-1fd9-414a-b91c-e8215b26a14c','','','Alternaria species',4,'','','',NULL,NULL,'','','','','Alternaria species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('047ee7af-1fd9-47b0-94a6-f3add777bff4','','','Astronesthes kreffti Gibbs & McKinney, 1988',1,'Astronesthes kreffti','Astronesthes kreffti','Astronesthes krefft',2,0,'','','Gibbs|McKinney','cfb67ed0-1e7a-5fba-8cd4-fb600a1b2cd2','Astronesthes kreffti Gibbs & McKinney, 1988','Gibbs & McKinney, 1988','SPECIES','','Astronesthes','','kreffti','','','',NULL,'','','','','','Gibbs & McKinney','','','','1988','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('048c3726-1dc3-4644-9b3d-6b1e5cf7d6ff','','','Bassozetus',1,'Bassozetus','Bassozetus','Bassozetus',1,0,'','','','d1f48e47-54b1-5375-95dd-548f5c14e660','Bassozetus','','GENUS','Bassozetus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04856fa9-abad-40b7-94ee-9a428715a46d','','','Habrotrocha perforata (Murray, 1906)',1,'Habrotrocha perforata','Habrotrocha perforata','Habrotrocha perforat',2,0,'','','Murray','5d1e4cd6-76f3-5441-9bc2-9810e675aeb0','Habrotrocha perforata (Murray, 1906)','(Murray, 1906)','SPECIES','','Habrotrocha','','perforata','','','',NULL,'','','','','','Murray','','','','1906','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04887105-d8ea-49c8-a17f-e162259637cb','','','Cladocopina',1,'Cladocopina','Cladocopina','Cladocopina',1,0,'','','','8f9c0d81-dc23-5d7d-921f-b81f243718a6','Cladocopina','','SUBORDER','Cladocopina','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04856812-0f86-408d-bfb0-f47cb043ff28','','','Acizzia exquisita (Tuthill, 1952)',1,'Acizzia exquisita','Acizzia exquisita','Acizzia exquisit',2,0,'','','Tuthill','eda30681-ed7f-572b-bdb1-e841045c097f','Acizzia exquisita (Tuthill, 1952)','(Tuthill, 1952)','SPECIES','','Acizzia','','exquisita','','','',NULL,'','','','','','Tuthill','','','','1952','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('048f58a6-893a-491b-9ae4-163cbe048d35','','','Limodorum',1,'Limodorum','Limodorum','Limodorum',1,0,'','','','882859fd-bc25-506e-84cf-61755eb9319c','Limodorum','','GENUS','Limodorum','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0492583e-f202-4665-9ce7-1e2e08898eb9','','','Protomycetales Luttr. ex D. Hawksw. & O.E. Erikss.',1,'Protomycetales','Protomycetales','Protomycetales',1,0,'','','Luttr.|D. Hawksw.|O. E. Erikss.','094f59d9-bb5c-5e79-b3b7-67c8377e68a8','Protomycetales Luttr. ex D. Hawksw. & O.E. Erikss.','Luttr. ex D. Hawksw. & O.E. Erikss.','ORDER','Protomycetales','','','','','','',NULL,'','','','','','Luttr.','','D. Hawksw. & O. E. Erikss.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0491e89b-6e78-4a1b-935f-7b2cbf0e595c','','','Peziza nivalis (R. Heim & L. Remy) M.M. Moser',1,'Peziza nivalis','Peziza nivalis','Peziza niual',2,0,'','','R. Heim|L. Remy|M. M. Moser','dddad401-2706-54da-8830-73ab8bb84369','Peziza nivalis (R. Heim & L. Remy) M.M. Moser','(R. Heim & L. Remy) M.M. Moser','SPECIES','','Peziza','','nivalis','','','',NULL,'M. M. Moser','','','','','R. Heim & L. Remy','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0493ff90-541e-42c0-9437-f9bcb26b4218','','','Byraxis sternalis Broun, 1893',1,'Byraxis sternalis','Byraxis sternalis','Byraxis sternal',2,0,'','','Broun','7c87847d-c374-5a35-9495-07218db1dfb5','Byraxis sternalis Broun, 1893','Broun, 1893','SPECIES','','Byraxis','','sternalis','','','',NULL,'','','','','','Broun','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04995aa4-a8d7-46a3-9902-6007be735c90','','','Clavaria ligula Schaeff.',1,'Clavaria ligula','Clavaria ligula','Clavaria ligul',2,0,'','','Schaeff.','6e3ab326-b1d3-5e6c-854b-4383ef059d19','Clavaria ligula Schaeff.','Schaeff.','SPECIES','','Clavaria','','ligula','','','',NULL,'','','','','','Schaeff.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04952aef-f1ee-475d-b5f9-92e76ca227a2','','','Brassica oleracea var. gongylodes L.',1,'Brassica oleracea gongylodes','Brassica oleracea var. gongylodes','Brassica olerace gongylod',3,0,'','','L.','03c67a22-6cf4-522b-89f8-86312f6adb47','Brassica oleracea var. gongylodes L.','L.','VARIETY','','Brassica','','oleracea','gongylodes','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0499cac2-af8b-4987-aaa7-cbcfa12d3564','','','Prosopis velutina',1,'Prosopis velutina','Prosopis velutina','Prosopis uelutin',2,0,'','','','caca1e53-f851-55de-9665-f9f8d4a2b4e8','Prosopis velutina','','SPECIES','','Prosopis','','velutina','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0497ac79-d76e-41a5-ae90-d560b84e804b','','','Philotarsopsis guttatus (Tillyard, 1923)',1,'Philotarsopsis guttatus','Philotarsopsis guttatus','Philotarsopsis guttat',2,0,'','','Tillyard','825fbe31-8359-547b-aa90-2d4e3d6be4c3','Philotarsopsis guttatus (Tillyard, 1923)','(Tillyard, 1923)','SPECIES','','Philotarsopsis','','guttatus','','','',NULL,'','','','','','Tillyard','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('058e7844-a391-4e4e-85ba-5de81ac92bdb','','','Phaeoclavulina curta (Fr.) Giachini',1,'Phaeoclavulina curta','Phaeoclavulina curta','Phaeoclavulina curt',2,0,'','','Fr.|Giachini','9a1ce0fa-d73f-5904-a014-70203a465052','Phaeoclavulina curta (Fr.) Giachini','(Fr.) Giachini','SPECIES','','Phaeoclavulina','','curta','','','',NULL,'Giachini','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('058e40b0-cb3f-4e61-9d41-a3b0528bac69','','','Australocnus',1,'Australocnus','Australocnus','Australocnus',1,0,'','','','d054c5a1-df9d-5012-9526-1b49e436d30f','Australocnus','','GENUS','Australocnus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('058b0f31-a498-48a7-9e90-ad2fe72106c8','','','Carabodes variabilis Hammer, 1966',1,'Carabodes variabilis','Carabodes variabilis','Carabodes uariabil',2,0,'','','Hammer','af896fbc-ee47-54d3-bdb0-ea288ad149d4','Carabodes variabilis Hammer, 1966','Hammer, 1966','SPECIES','','Carabodes','','variabilis','','','',NULL,'','','','','','Hammer','','','','1966','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05931a29-a08e-415b-b482-164dd9220640','','','Protohystricia orientalis (Schiner, 1868)',1,'Protohystricia orientalis','Protohystricia orientalis','Protohystricia oriental',2,0,'','','Schiner','d4d6af41-6fd1-5463-97b2-5f67e450d3a6','Protohystricia orientalis (Schiner, 1868)','(Schiner, 1868)','SPECIES','','Protohystricia','','orientalis','','','',NULL,'','','','','','Schiner','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05915c20-1b43-4be0-9b60-6ed958ee79b9','','','Siphlaenigma',1,'Siphlaenigma','Siphlaenigma','Siphlaenigma',1,0,'','','','62279506-6562-53bc-8add-5c6644741be3','Siphlaenigma','','GENUS','Siphlaenigma','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('059062ed-091d-4369-9595-8f1d2e520a9e','','','Glyptotermes',1,'Glyptotermes','Glyptotermes','Glyptotermes',1,0,'','','','770ae28b-59b5-5f92-8f62-af82b4328491','Glyptotermes','','GENUS','Glyptotermes','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0590e160-abc9-432b-9476-9b7900c6c984','','','Ambuchanania Seppelt & H.A.Crum',1,'Ambuchanania','Ambuchanania','Ambuchanania',1,0,'','','Seppelt|H. A. Crum','b9d812c9-1e96-5857-840e-cc5d671548d6','Ambuchanania Seppelt & H.A.Crum','Seppelt & H.A.Crum','GENUS','Ambuchanania','','','','','','',NULL,'','','','','','Seppelt & H. A. Crum','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0599b59f-3ccc-4b5d-b1b6-0a5d5b1eb2d6','','','Gentianella saxosa (G.Forst.) Holub',1,'Gentianella saxosa','Gentianella saxosa','Gentianella saxos',2,0,'','','G. Forst.|Holub','97e5fd15-9bac-58e9-9c9a-f1768115af82','Gentianella saxosa (G.Forst.) Holub','(G.Forst.) Holub','SPECIES','','Gentianella','','saxosa','','','',NULL,'Holub','','','','','G. Forst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0598841d-fc7c-42be-bd0d-67135376b2f3','','','Anabarhynchus schlingeri Lyneborg, 1992',1,'Anabarhynchus schlingeri','Anabarhynchus schlingeri','Anabarhynchus schlinger',2,0,'','','Lyneborg','aed5f43f-6246-50b4-9e4d-02978680b796','Anabarhynchus schlingeri Lyneborg, 1992','Lyneborg, 1992','SPECIES','','Anabarhynchus','','schlingeri','','','',NULL,'','','','','','Lyneborg','','','','1992','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0594ab01-3611-4df6-aeb3-d50ef2b5c2b1','','','Cyphelium tigillare (Ach.) Ach.',1,'Cyphelium tigillare','Cyphelium tigillare','Cyphelium tigillar',2,0,'','','Ach.','6f24f2f8-b8d2-5030-8afe-d70e733ef880','Cyphelium tigillare (Ach.) Ach.','(Ach.) Ach.','SPECIES','','Cyphelium','','tigillare','','','',NULL,'Ach.','','','','','Ach.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('059cf847-51c7-4608-b11a-084b817077e2','','','Sorastrum spinulosum Nägeli',1,'Sorastrum spinulosum','Sorastrum spinulosum','Sorastrum spinulos',2,0,'','','Nägeli','346bb273-9684-5566-aed9-de61805b95ae','Sorastrum spinulosum Nägeli','Nägeli','SPECIES','','Sorastrum','','spinulosum','','','',NULL,'','','','','','Nägeli','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05a23582-7b6e-4986-af2e-2dcd1252c67c','','','Anoxybacillus kualawohkensis Azura et al., 2006',1,'Anoxybacillus kualawohkensis','Anoxybacillus kualawohkensis','Anoxybacillus kualawohkens',2,0,'','','Azura et al.','38962da5-5d65-5564-9e31-410fc95d989e','Anoxybacillus kualawohkensis Azura et al., 2006','Azura et al., 2006','SPECIES','','Anoxybacillus','','kualawohkensis','','','',NULL,'','','','','','Azura et al.','','','','2006','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('059c635f-d4d0-4e17-a5c9-c0bae1be74d2','','','Trachyphyllum A.Gepp.',1,'Trachyphyllum','Trachyphyllum','Trachyphyllum',1,0,'','','A. Gepp.','7f85a328-d133-52ae-9e9e-0d9736b1e690','Trachyphyllum A.Gepp.','A.Gepp.','GENUS','Trachyphyllum','','','','','','',NULL,'','','','','','A. Gepp.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05a0894d-aa35-4174-9f9e-c43e0d162a7a','','','Aspergillus beijingensis D.M. Li, Y. Horie, Y.X. Wang & R.Y. Li',1,'Aspergillus beijingensis','Aspergillus beijingensis','Aspergillus beiiingens',2,0,'','','D. M. Li|Y. Horie|Y. X. Wang|R. Y. Li','3e5728d9-2538-54e0-81ba-6b32cfa47c8e','Aspergillus beijingensis D.M. Li, Y. Horie, Y.X. Wang & R.Y. Li','D.M. Li, Y. Horie, Y.X. Wang & R.Y. Li','SPECIES','','Aspergillus','','beijingensis','','','',NULL,'','','','','','D. M. Li, Y. Horie, Y. X. Wang & R. Y. Li','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05a85e0d-6e97-493e-b9e2-7af154bfb335','','','Ocyusa brouniana Bernhauer, 1943',1,'Ocyusa brouniana','Ocyusa brouniana','Ocyusa brounian',2,0,'','','Bernhauer','e2b29970-3f7d-5a8b-939c-bb154d77b60e','Ocyusa brouniana Bernhauer, 1943','Bernhauer, 1943','SPECIES','','Ocyusa','','brouniana','','','',NULL,'','','','','','Bernhauer','','','','1943','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05a6863e-a4f8-465d-b7fb-e12b45ac21bd','','','Forstera purpurata Glenny',1,'Forstera purpurata','Forstera purpurata','Forstera purpurat',2,0,'','','Glenny','3488732e-b34f-5994-b820-73198595bc5e','Forstera purpurata Glenny','Glenny','SPECIES','','Forstera','','purpurata','','','',NULL,'','','','','','Glenny','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05abd017-7aad-42a0-8874-396f435eb20b','','','Rigidoporus vinctus (Berk.) Ryvarden',1,'Rigidoporus vinctus','Rigidoporus vinctus','Rigidoporus uinct',2,0,'','','Berk.|Ryvarden','5ad6e71a-e786-5d46-8472-46f4324a8416','Rigidoporus vinctus (Berk.) Ryvarden','(Berk.) Ryvarden','SPECIES','','Rigidoporus','','vinctus','','','',NULL,'Ryvarden','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05ab316b-0805-4c17-a678-79a08a2242d1','','','"Cyanobacteria" (ex Stanier 1974) Cavalier-Smith, 2002',NULL,'','','',NULL,NULL,'','','','','"Cyanobacteria" (ex Stanier 1974) Cavalier-Smith, 2002','','PHYLUM','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05ab8e21-8855-4955-8011-89d2eefd337a','','','Pseudocercospora odontoglossi (Prill. & Delacr.) U. Braun',1,'Pseudocercospora odontoglossi','Pseudocercospora odontoglossi','Pseudocercospora odontogloss',2,0,'','','Prill.|Delacr.|U. Braun','1ee07604-f3c5-583e-ba25-d5550e12b025','Pseudocercospora odontoglossi (Prill. & Delacr.) U. Braun','(Prill. & Delacr.) U. Braun','SPECIES','','Pseudocercospora','','odontoglossi','','','',NULL,'U. Braun','','','','','Prill. & Delacr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05ac7453-e658-4a93-b78c-fbc7d4d382f8','','','Octophialucium indicum Kramp, 1958',1,'Octophialucium indicum','Octophialucium indicum','Octophialucium indic',2,0,'','','Kramp','36150afb-9d61-5aaa-8740-f254d11e790f','Octophialucium indicum Kramp, 1958','Kramp, 1958','SPECIES','','Octophialucium','','indicum','','','',NULL,'','','','','','Kramp','','','','1958','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05b5b893-846f-4183-9608-797c7f9ee4bf','','','Inocybe spinulifera E. Horak',1,'Inocybe spinulifera','Inocybe spinulifera','Inocybe spinulifer',2,0,'','','E. Horak','aa510a16-ae79-5204-9ad4-eecee2e3d6ae','Inocybe spinulifera E. Horak','E. Horak','SPECIES','','Inocybe','','spinulifera','','','',NULL,'','','','','','E. Horak','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05b114f9-7a41-4977-8fe4-b1fe90614cdc','','','Rinodina gennarii sensu N.Z. auct.',4,'','','',NULL,NULL,'','','','','Rinodina gennarii sensu N.Z. auct.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05b41abd-f478-410b-96b5-c90f6565ee92','','','Hypocrea minutispora B.S. Lu, Fallah & Samuels',1,'Hypocrea minutispora','Hypocrea minutispora','Hypocrea minutispor',2,0,'','','B. S. Lu|Fallah|Samuels','87de30d6-a20f-5350-b238-88c30ec5f233','Hypocrea minutispora B.S. Lu, Fallah & Samuels','B.S. Lu, Fallah & Samuels','SPECIES','','Hypocrea','','minutispora','','','',NULL,'','','','','','B. S. Lu, Fallah & Samuels','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05b8701d-d687-49cb-80f4-8d791b77a5b1','','','Lactarius novae-zelandiae McNabb',1,'Lactarius novae-zelandiae','Lactarius novae-zelandiae','Lactarius nouae-zelandi',2,0,'','','McNabb','9acc37b3-1ef7-52f5-88d7-006082cf2b18','Lactarius novae-zelandiae McNabb','McNabb','SPECIES','','Lactarius','','novae-zelandiae','','','',NULL,'','','','','','McNabb','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05bf1cbd-beea-4f15-b536-a5776832aa57','','','Phaulochernes townsendi Beier, 1976',1,'Phaulochernes townsendi','Phaulochernes townsendi','Phaulochernes townsend',2,0,'','','Beier','b3812b63-7101-5cc0-a3d9-6e6beb93fdb8','Phaulochernes townsendi Beier, 1976','Beier, 1976','SPECIES','','Phaulochernes','','townsendi','','','',NULL,'','','','','','Beier','','','','1976','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05bd7bd7-f7a8-4f28-9a2a-f24013fbd0a3','','','Brunfelsia pauciflora (Cham. & Schltdl.) Benth.',1,'Brunfelsia pauciflora','Brunfelsia pauciflora','Brunfelsia pauciflor',2,0,'','','Cham.|Schltdl.|Benth.','14f99504-c8e3-5707-b677-fd9cf3a81b17','Brunfelsia pauciflora (Cham. & Schltdl.) Benth.','(Cham. & Schltdl.) Benth.','SPECIES','','Brunfelsia','','pauciflora','','','',NULL,'Benth.','','','','','Cham. & Schltdl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05c543df-b1b4-4af8-b155-1dd0a5c1e686','','','Cosmarium depressum var. achondrum (Boldt) West & G.S.West',1,'Cosmarium depressum achondrum','Cosmarium depressum var. achondrum','Cosmarium depress achondr',3,0,'','','Boldt|West|G. S. West','24449ee4-460c-5790-95f2-38177e9b630c','Cosmarium depressum var. achondrum (Boldt) West & G.S.West','(Boldt) West & G.S.West','VARIETY','','Cosmarium','','depressum','achondrum','','',NULL,'West & G. S. West','','','','','Boldt','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05c4758f-8388-4bcc-a0b8-54536d997308','','','Clavaria gibbsiae Ramsb.',1,'Clavaria gibbsiae','Clavaria gibbsiae','Clavaria gibbsi',2,0,'','','Ramsb.','8696ed60-c04b-5f29-8e13-00c938e35240','Clavaria gibbsiae Ramsb.','Ramsb.','SPECIES','','Clavaria','','gibbsiae','','','',NULL,'','','','','','Ramsb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05c5955d-67db-42a6-bbb8-ad6e85056fd0','','','Odontoglossum pulchellum Bateman ex Lindl.',1,'Odontoglossum pulchellum','Odontoglossum pulchellum','Odontoglossum pulchell',2,0,'','','Bateman|Lindl.','752f72d9-ca93-5210-9048-b430479f4516','Odontoglossum pulchellum Bateman ex Lindl.','Bateman ex Lindl.','SPECIES','','Odontoglossum','','pulchellum','','','',NULL,'','','','','','Bateman','','Lindl.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05c2c96d-9ea4-4095-a7e7-f3d6c703e9d7','','','Coptomma lineatum (Fabricius, 1775)',1,'Coptomma lineatum','Coptomma lineatum','Coptomma lineat',2,0,'','','Fabricius','94c426db-0cda-552a-865c-6e4d77461b5b','Coptomma lineatum (Fabricius, 1775)','(Fabricius, 1775)','SPECIES','','Coptomma','','lineatum','','','',NULL,'','','','','','Fabricius','','','','1775','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05c91d22-0325-420a-9c75-4c928874c672','','','Megalospora dispora C.Knight',1,'Megalospora dispora','Megalospora dispora','Megalospora dispor',2,0,'','','C. Knight','37420329-4f51-58a8-a342-a5d9d2593521','Megalospora dispora C.Knight','C.Knight','SPECIES','','Megalospora','','dispora','','','',NULL,'','','','','','C. Knight','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05c976c5-8982-488d-bb4f-8b60a534d348','','','Chaunax',1,'Chaunax','Chaunax','Chaunax',1,0,'','','','869423c8-df81-5a49-a3b1-a7991de398e4','Chaunax','','GENUS','Chaunax','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05c9ffb8-7bc1-488b-b8d1-9214352aa518','','','Claviceps Tul.',1,'Claviceps','Claviceps','Claviceps',1,0,'','','Tul.','a7a7431e-95b5-55b2-9c89-e57c745ab944','Claviceps Tul.','Tul.','GENUS','Claviceps','','','','','','',NULL,'','','','','','Tul.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('032c50b6-62b0-4c2a-a3a8-14e332fea7af','','','Sansevieria cylindrica Bojer ex Hook.',1,'Sansevieria cylindrica','Sansevieria cylindrica','Sansevieria cylindric',2,0,'','','Bojer|Hook.','180fe738-99fd-51e6-bea8-6b023439873a','Sansevieria cylindrica Bojer ex Hook.','Bojer ex Hook.','SPECIES','','Sansevieria','','cylindrica','','','',NULL,'','','','','','Bojer','','Hook.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0327de8f-38c3-43a0-a026-8ec92e7851ef','','','Anu Thompson, 2008',1,'Anu','Anu','Anu',1,0,'','','Thompson','113c1e41-7aca-522a-99e4-ef034c4992c4','Anu Thompson, 2008','Thompson, 2008','GENUS','Anu','','','','','','',NULL,'','','','','','Thompson','','','','2008','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('032c5ac8-7e5a-45b2-9e9e-d2eeb2958759','','','Solenopezia Sacc.',1,'Solenopezia','Solenopezia','Solenopezia',1,0,'','','Sacc.','fceb06f6-d7ce-5b93-9c93-b70364fa2a36','Solenopezia Sacc.','Sacc.','GENUS','Solenopezia','','','','','','',NULL,'','','','','','Sacc.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('032d9a6a-004e-4599-9c53-0a8ee00f4baa','','','Ocyropsis',1,'Ocyropsis','Ocyropsis','Ocyropsis',1,0,'','','','1c9a51d8-0711-5100-b802-49d5d6f0195e','Ocyropsis','','GENUS','Ocyropsis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03331ad2-521d-4d8e-9636-11265dd9a0cb','','','Lanceoppia feideri (Hammer, 1968)',1,'Lanceoppia feideri','Lanceoppia feideri','Lanceoppia feider',2,0,'','','Hammer','e95c1b38-bfa3-5dcf-a68e-d5b482bb6bfd','Lanceoppia feideri (Hammer, 1968)','(Hammer, 1968)','SPECIES','','Lanceoppia','','feideri','','','',NULL,'','','','','','Hammer','','','','1968','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0331ce34-76b8-417d-bc8b-890b71ce0cd6','','','Polyporus cingulatus Fr.',1,'Polyporus cingulatus','Polyporus cingulatus','Polyporus cingulat',2,0,'','','Fr.','07367adc-006c-54c5-b828-22b413d364cf','Polyporus cingulatus Fr.','Fr.','SPECIES','','Polyporus','','cingulatus','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('032fc236-f385-4b40-802c-c6c937a70732','','','Cochliobolus heteropogonis Alcorn',1,'Cochliobolus heteropogonis','Cochliobolus heteropogonis','Cochliobolus heteropogon',2,0,'','','Alcorn','7b98febe-35bc-5a3e-807a-800a6010c40c','Cochliobolus heteropogonis Alcorn','Alcorn','SPECIES','','Cochliobolus','','heteropogonis','','','',NULL,'','','','','','Alcorn','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('033bb604-8020-4613-a93a-206c8c59d9df','','','Gynoplistia dispila Alexander, 1923',1,'Gynoplistia dispila','Gynoplistia dispila','Gynoplistia dispil',2,0,'','','Alexander','0f3856b1-60e2-511a-86da-33ae366737e2','Gynoplistia dispila Alexander, 1923','Alexander, 1923','SPECIES','','Gynoplistia','','dispila','','','',NULL,'','','','','','Alexander','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('033ff06d-c0f5-4e55-b253-5f3a8f3207c6','','','Myrtales Juss. ex Bercht. & J.Presl',1,'Myrtales','Myrtales','Myrtales',1,0,'','','Juss.|Bercht.|J. Presl','8d3065b5-772c-596a-98df-0d9c7303983f','Myrtales Juss. ex Bercht. & J.Presl','Juss. ex Bercht. & J.Presl','ORDER','Myrtales','','','','','','',NULL,'','','','','','Juss.','','Bercht. & J. Presl','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('033dedf9-b9ca-4374-8c04-d362aece20f7','','','Pseudeurotium bakeri C. Booth',1,'Pseudeurotium bakeri','Pseudeurotium bakeri','Pseudeurotium baker',2,0,'','','C. Booth','bddb01db-f7cd-5bef-a626-ce041c3c81aa','Pseudeurotium bakeri C. Booth','C. Booth','SPECIES','','Pseudeurotium','','bakeri','','','',NULL,'','','','','','C. Booth','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('033b46af-e17d-4599-a633-f44fd3a02cf7','','','Fibricium J. Erikss.',1,'Fibricium','Fibricium','Fibricium',1,0,'','','J. Erikss.','23e274d2-988d-5b91-8090-763dcdddc595','Fibricium J. Erikss.','J. Erikss.','GENUS','Fibricium','','','','','','',NULL,'','','','','','J. Erikss.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03461b0c-bb7d-4524-9bd7-06366e49f31a','','','Aletia lacustris Meyrick, 1934',1,'Aletia lacustris','Aletia lacustris','Aletia lacustr',2,0,'','','Meyrick','0c8fcae3-e7fd-5a48-9579-7d7c354b5f1d','Aletia lacustris Meyrick, 1934','Meyrick, 1934','SPECIES','','Aletia','','lacustris','','','',NULL,'','','','','','Meyrick','','','','1934','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0341eb46-fdc7-4478-a262-83518e447ad3','','','Lithographa graphidioides (Cromb.) Imshaug ex Coppins & Fryday',1,'Lithographa graphidioides','Lithographa graphidioides','Lithographa graphidioid',2,0,'','','Cromb.|Imshaug|Coppins|Fryday','344803fa-33b7-5b8c-8a71-f7b3cff0799d','Lithographa graphidioides (Cromb.) Imshaug ex Coppins & Fryday','(Cromb.) Imshaug ex Coppins & Fryday','SPECIES','','Lithographa','','graphidioides','','','',NULL,'Imshaug','','Coppins & Fryday','','','Cromb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0342ba2f-255c-4687-9b78-ec59c691f7f0','','','Carex geminata Schkuhr',1,'Carex geminata','Carex geminata','Carex geminat',2,0,'','','Schkuhr','d0502b29-6280-5ccf-bb8a-49bff4fabd48','Carex geminata Schkuhr','Schkuhr','SPECIES','','Carex','','geminata','','','',NULL,'','','','','','Schkuhr','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('034930c8-c414-4703-8b63-138181b766e8','','','Fusarium FSSC 5 ined.',4,'','','',NULL,NULL,'','','','','Fusarium FSSC 5 ined.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('034a4181-e1d6-4631-901f-55ff6f13c069','','','Aulacoseira crenulata (Ehrenberg) Thwaites',1,'Aulacoseira crenulata','Aulacoseira crenulata','Aulacoseira crenulat',2,0,'','','Ehrenberg|Thwaites','c3c3ebe9-95b9-5626-a4e0-1f67b6afe93f','Aulacoseira crenulata (Ehrenberg) Thwaites','(Ehrenberg) Thwaites','SPECIES','','Aulacoseira','','crenulata','','','',NULL,'Thwaites','','','','','Ehrenberg','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0346d842-2ced-4e4b-b286-8c089c724a21','','','Molophilus submorosus Alexander, 1924',1,'Molophilus submorosus','Molophilus submorosus','Molophilus submoros',2,0,'','','Alexander','469b349e-ddb3-540a-b52d-7b4703517c89','Molophilus submorosus Alexander, 1924','Alexander, 1924','SPECIES','','Molophilus','','submorosus','','','',NULL,'','','','','','Alexander','','','','1924','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03477877-21d1-43bd-b33f-be35a119a36a','','','Asarina Mill.',1,'Asarina','Asarina','Asarina',1,0,'','','Mill.','7df31233-680f-55b5-8a26-e911da861a28','Asarina Mill.','Mill.','GENUS','Asarina','','','','','','',NULL,'','','','','','Mill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('035667b1-9548-452c-af2a-1d09f3d6ec36','','','Lepidosira arborea',1,'Lepidosira arborea','Lepidosira arborea','Lepidosira arbore',2,0,'','','','dcd48a6c-1c6f-52d0-9379-d3033acaba87','Lepidosira arborea','','SPECIES','','Lepidosira','','arborea','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0351e8e0-585b-4c08-9a0a-55e16f695d59','','','Asterionellopsis glacialis (Castracane) Round',1,'Asterionellopsis glacialis','Asterionellopsis glacialis','Asterionellopsis glacial',2,0,'','','Castracane|Round','31e33578-94e3-58f8-bb06-b9f28f02e6ef','Asterionellopsis glacialis (Castracane) Round','(Castracane) Round','SPECIES','','Asterionellopsis','','glacialis','','','',NULL,'Round','','','','','Castracane','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('034d311e-ae6a-4adb-b09e-7f28a8df47f3','','','Septoria agrimoniae-eupatoriae E. Bommer & M. Rousseau',1,'Septoria agrimoniae-eupatoriae','Septoria agrimoniae-eupatoriae','Septoria agrimoniae-eupatori',2,0,'','','E. Bommer|M. Rousseau','2c94699a-c90e-5655-96d9-2c03901b65b1','Septoria agrimoniae-eupatoriae E. Bommer & M. Rousseau','E. Bommer & M. Rousseau','SPECIES','','Septoria','','agrimoniae-eupatoriae','','','',NULL,'','','','','','E. Bommer & M. Rousseau','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('034f8d92-19ec-4a5f-b4a2-a79ad55719e2','','','Hymenostilbe species',4,'','','',NULL,NULL,'','','','','Hymenostilbe species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0355961f-649f-4346-b861-c18dbaf706a2','','','Andesanthus lepidotus ''Alstonville''',1,'Andesanthus lepidotus ‘Alstonville’','Andesanthus lepidotus ‘Alstonville’','Andesanthus lepidot ‘Alstonville’',3,0,'','','','e3cab621-938b-5d65-bb53-c426f195865f','Andesanthus lepidotus ''Alstonville''','','CULTIVAR','','Andesanthus','','lepidotus','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('035e7432-bd26-4172-842e-04d054bcce9b','','','Ammonia',1,'Ammonia','Ammonia','Ammonia',1,0,'','','','54ee6fe4-4015-51cf-8f4d-88f0393ad23c','Ammonia','','GENUS','Ammonia','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('035c96dc-af59-4f64-af79-1b96fd84d171','','','Camptochaete arbuscula var. deflexa (Wilson) Dixon',1,'Camptochaete arbuscula deflexa','Camptochaete arbuscula var. deflexa','Camptochaete arbuscul deflex',3,0,'','','Wilson|Dixon','ee66ec1d-83d8-5f32-86c9-8994486efbae','Camptochaete arbuscula var. deflexa (Wilson) Dixon','(Wilson) Dixon','VARIETY','','Camptochaete','','arbuscula','deflexa','','',NULL,'Dixon','','','','','Wilson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('035aecda-ffd8-465d-9c59-5d0f141df1b5','','','Forficuloecus meinertzhageni Guimaraes, 1974',1,'Forficuloecus meinertzhageni','Forficuloecus meinertzhageni','Forficuloecus meinertzhagen',2,0,'','','Guimaraes','02c416c5-7288-51dd-87dd-0c6f9a63c278','Forficuloecus meinertzhageni Guimaraes, 1974','Guimaraes, 1974','SPECIES','','Forficuloecus','','meinertzhageni','','','',NULL,'','','','','','Guimaraes','','','','1974','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('035bac21-4ff4-4ca9-bfbd-ca5f3a54dc49','','','Guignardia carpinea (Fr.) J. Schröt.',1,'Guignardia carpinea','Guignardia carpinea','Guignardia carpine',2,0,'','','Fr.|J. Schröt.','d052f88d-ac1a-5f6c-8715-49138b5ca212','Guignardia carpinea (Fr.) J. Schröt.','(Fr.) J. Schröt.','SPECIES','','Guignardia','','carpinea','','','',NULL,'J. Schröt.','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('035ece2f-bb24-4541-9362-20aaedf00579','','','Billbergia vittata Brongn. ex C.Morel',1,'Billbergia vittata','Billbergia vittata','Billbergia uittat',2,0,'','','Brongn.|C. Morel','936004f5-66ab-5ba2-93a1-fddf0630d311','Billbergia vittata Brongn. ex C.Morel','Brongn. ex C.Morel','SPECIES','','Billbergia','','vittata','','','',NULL,'','','','','','Brongn.','','C. Morel','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('035eaf84-dfe7-4cef-a2db-6d54aec95fb2','','','Hebe ×andersonii (Lindl. & Paxton) Cockayne',3,'','','',NULL,NULL,'','','','','Hebe ×andersonii (Lindl. & Paxton) Cockayne','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03617dea-35d1-403c-be24-9451e8611f4d','','','Stephanospora flava (Rodway) G.W. Beaton, Pegler & T.W.K. Young',1,'Stephanospora flava','Stephanospora flava','Stephanospora flau',2,0,'','','Rodway|G. W. Beaton|Pegler|T. W. K. Young','535903ba-1bb0-5438-b5c6-6f8bf50be0c4','Stephanospora flava (Rodway) G.W. Beaton, Pegler & T.W.K. Young','(Rodway) G.W. Beaton, Pegler & T.W.K. Young','SPECIES','','Stephanospora','','flava','','','',NULL,'G. W. Beaton, Pegler & T. W. K. Young','','','','','Rodway','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03640f5a-dacd-4d5a-ba43-debc2181db0a','','','Hypnum sarmentosum Wahlenb.',1,'Hypnum sarmentosum','Hypnum sarmentosum','Hypnum sarmentos',2,0,'','','Wahlenb.','4d8aa094-1c24-5de0-bd3c-a0e456c33a72','Hypnum sarmentosum Wahlenb.','Wahlenb.','SPECIES','','Hypnum','','sarmentosum','','','',NULL,'','','','','','Wahlenb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('036a16e0-d000-48b6-b4cc-3346169827a8','','','Erysiphe umbelliferarum de Bary',1,'Erysiphe umbelliferarum','Erysiphe umbelliferarum','Erysiphe umbelliferar',2,0,'','','de Bary','56f95fdb-fb6e-55d5-a010-45c0bb49d286','Erysiphe umbelliferarum de Bary','de Bary','SPECIES','','Erysiphe','','umbelliferarum','','','',NULL,'','','','','','de Bary','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('036a86bf-a31f-4a5e-a68c-6d520dce6229','','','Cyathea smithii Hook.f.',1,'Cyathea smithii','Cyathea smithii','Cyathea smith',2,0,'','','Hook. fil.','fade1050-0822-5317-ac03-c6c278997a0b','Cyathea smithii Hook.f.','Hook.f.','SPECIES','','Cyathea','','smithii','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0368bcd0-4bf6-495a-81ad-86f68f441232','','','Merulioporia Bondartsev & Singer',1,'Merulioporia','Merulioporia','Merulioporia',1,0,'','','Bondartsev|Singer','8e641fc3-3fdb-5e2b-ba3a-d00dc3f78802','Merulioporia Bondartsev & Singer','Bondartsev & Singer','GENUS','Merulioporia','','','','','','',NULL,'','','','','','Bondartsev & Singer','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('036c47a6-6898-47e9-82f7-dacad19eb28f','','','Agaricus adscendens Lasch',1,'Agaricus adscendens','Agaricus adscendens','Agaricus adscendens',2,0,'','','Lasch','7f1a1c5c-7d82-5af9-a2fe-82c75258bd18','Agaricus adscendens Lasch','Lasch','SPECIES','','Agaricus','','adscendens','','','',NULL,'','','','','','Lasch','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03739869-8080-4a2a-9414-0df3956db22c','','','Reynoutria sachalinensis (F.Schmidt) Nakai',1,'Reynoutria sachalinensis','Reynoutria sachalinensis','Reynoutria sachalinens',2,0,'','','F. Schmidt|Nakai','039c2970-d6ce-55ae-a5e2-7d03bc6dc2aa','Reynoutria sachalinensis (F.Schmidt) Nakai','(F.Schmidt) Nakai','SPECIES','','Reynoutria','','sachalinensis','','','',NULL,'Nakai','','','','','F. Schmidt','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03712676-4e35-40a9-877e-751446a9f252','','','Guepinia Fr.',1,'Guepinia','Guepinia','Guepinia',1,0,'','','Fr.','d4e48bee-dfaf-5ebb-a8ed-41726e1b76f2','Guepinia Fr.','Fr.','GENUS','Guepinia','','','','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03709eb0-afc1-4262-be62-ae05f8881646','','','Atrina',1,'Atrina','Atrina','Atrina',1,0,'','','','7749edb6-7e24-531b-9afb-9141c0cde3a0','Atrina','','GENUS','Atrina','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0372ef45-d4c7-4789-8206-b56792401f0b','','','Sabatinca demissa Philpott, 1923',1,'Sabatinca demissa','Sabatinca demissa','Sabatinca demiss',2,0,'','','Philpott','060290b9-3d8e-5927-8485-30e9af0e7eca','Sabatinca demissa Philpott, 1923','Philpott, 1923','SPECIES','','Sabatinca','','demissa','','','',NULL,'','','','','','Philpott','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03776f81-64c2-49e9-9bbe-cc911bca4d68','','','Abrotanella rostrata Swenson',1,'Abrotanella rostrata','Abrotanella rostrata','Abrotanella rostrat',2,0,'','','Swenson','92d1c4e2-9a0f-5df7-b0c6-d6379a4d2e52','Abrotanella rostrata Swenson','Swenson','SPECIES','','Abrotanella','','rostrata','','','',NULL,'','','','','','Swenson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03768c27-cf9e-46af-8ef7-f483ad60236a','','','Lepeophtheirus',1,'Lepeophtheirus','Lepeophtheirus','Lepeophtheirus',1,0,'','','','39648f32-8fb0-5567-8b53-0174f256615a','Lepeophtheirus','','GENUS','Lepeophtheirus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04ef8f4d-4c54-4386-8893-0c21e51aef85','','','Aphidini',1,'Aphidini','Aphidini','Aphidini',1,0,'','','','1fcf1dca-631c-5405-8d52-86126ae780d1','Aphidini','','TRIBE','Aphidini','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04ec435a-49dd-4941-812b-2295c55957ca','','','Mastigocladus',1,'Mastigocladus','Mastigocladus','Mastigocladus',1,0,'','','','7829825c-12c6-55d7-87ca-81a6ded7c8be','Mastigocladus','','GENUS','Mastigocladus','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04f09750-61e2-4b1b-b5b7-6041cf1c7a74','','','Lunaceps limosella Timmermann, 1954',1,'Lunaceps limosella','Lunaceps limosella','Lunaceps limosell',2,0,'','','Timmermann','46fc3d8c-dc08-5e65-bf78-a46c28084bc8','Lunaceps limosella Timmermann, 1954','Timmermann, 1954','SPECIES','','Lunaceps','','limosella','','','',NULL,'','','','','','Timmermann','','','','1954','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04ee7b1b-8629-471c-a7cb-a69bd16f6b5b','','','Carcharhinus longimanus (Poey, 1861)',1,'Carcharhinus longimanus','Carcharhinus longimanus','Carcharhinus longiman',2,0,'','','Poey','1b793eca-a4c9-52a4-a056-62d0acacc913','Carcharhinus longimanus (Poey, 1861)','(Poey, 1861)','SPECIES','','Carcharhinus','','longimanus','','','',NULL,'','','','','','Poey','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04f3493d-6556-42be-91c9-da13c5035d80','','','Loxandrini',1,'Loxandrini','Loxandrini','Loxandrini',1,0,'','','','e3d75c06-1f7a-54bd-9786-7313db8dd94d','Loxandrini','','TRIBE','Loxandrini','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04f483e4-cbe2-4529-a71b-063d01668c0b','','','Keithomyces Samson, Luangsa-ard & Houbraken',1,'Keithomyces','Keithomyces','Keithomyces',1,0,'','','Samson|Luangsa-ard|Houbraken','0b740768-acdd-5230-b677-f9945456727a','Keithomyces Samson, Luangsa-ard & Houbraken','Samson, Luangsa-ard & Houbraken','GENUS','Keithomyces','','','','','','',NULL,'','','','','','Samson, Luangsa-ard & Houbraken','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04f66041-8935-4d54-8d84-81a32c7abbe3','','','Davallia tasmanii Field',1,'Davallia tasmanii','Davallia tasmanii','Davallia tasman',2,0,'','','Field','fd14cc34-6e17-597f-972b-2474c703b44d','Davallia tasmanii Field','Field','SPECIES','','Davallia','','tasmanii','','','',NULL,'','','','','','Field','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04f6e168-2cba-4834-b3a9-a7690452a5fe','','','Antrodia mappa (Overh. & J. Lowe) Miettinen & Vlasák',1,'Antrodia mappa','Antrodia mappa','Antrodia mapp',2,0,'','','Overh.|J. Lowe|Miettinen|Vlasák','f8728cc7-4086-59ea-b205-19cd0286c235','Antrodia mappa (Overh. & J. Lowe) Miettinen & Vlasák','(Overh. & J. Lowe) Miettinen & Vlasák','SPECIES','','Antrodia','','mappa','','','',NULL,'Miettinen & Vlasák','','','','','Overh. & J. Lowe','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04f3fcbc-59e2-43bd-a8b2-f7852f6f3aa3','','','Pezicula corni Petr.',1,'Pezicula corni','Pezicula corni','Pezicula corn',2,0,'','','Petr.','7d273c22-38c0-531e-adf5-12f250f09769','Pezicula corni Petr.','Petr.','SPECIES','','Pezicula','','corni','','','',NULL,'','','','','','Petr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04fe1257-0c66-4aba-93b9-8d9ab00efdd9','','','Plantaginales',1,'Plantaginales','Plantaginales','Plantaginales',1,0,'','','','c744b31f-af9c-5c16-b730-d81b588cc98e','Plantaginales','','ORDER','Plantaginales','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04fb93e6-7b45-4cc2-b821-9310dc0bf983','','','Myriotrichia adriatica Hauck',1,'Myriotrichia adriatica','Myriotrichia adriatica','Myriotrichia adriatic',2,0,'','','Hauck','6fe47f76-cbf2-524c-8934-2f71329b4bd4','Myriotrichia adriatica Hauck','Hauck','SPECIES','','Myriotrichia','','adriatica','','','',NULL,'','','','','','Hauck','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04fe1665-72e3-40bb-8a7b-a66fe56059b1','','','Porina granulata Ach.',1,'Porina granulata','Porina granulata','Porina granulat',2,0,'','','Ach.','de912b9b-a87b-5d9b-8a9f-cd8995a4ea5f','Porina granulata Ach.','Ach.','SPECIES','','Porina','','granulata','','','',NULL,'','','','','','Ach.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04f9972b-a8a4-4e69-bfa1-b83c4e84bcd4','','','Erwinia alni Surico et al., 1996',1,'Erwinia alni','Erwinia alni','Erwinia aln',2,0,'','','Surico et al.','7f756405-6ab1-58a2-b6aa-3ba374e55183','Erwinia alni Surico et al., 1996','Surico et al., 1996','SPECIES','','Erwinia','','alni','','','',NULL,'','','','','','Surico et al.','','','','1996','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04fd75d9-4615-4380-b8c8-f9b672bdf16e','','','Clavaria hypoxylon L.',1,'Clavaria hypoxylon','Clavaria hypoxylon','Clavaria hypoxylon',2,0,'','','L.','7bfb1312-339a-5bfa-90e3-a39508dd448f','Clavaria hypoxylon L.','L.','SPECIES','','Clavaria','','hypoxylon','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04fed5c8-7c70-4d95-81b0-26b7a764dbbb','','','Thinempis Bickel, 1996',1,'Thinempis','Thinempis','Thinempis',1,0,'','','Bickel','507091bd-7944-5348-8e78-e509229a183c','Thinempis Bickel, 1996','Bickel, 1996','GENUS','Thinempis','','','','','','',NULL,'','','','','','Bickel','','','','1996','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('050346cb-40dd-4ae6-b9e6-8d0c08ecf03f','','','Ophioglossum vulgatum var. minimum Hook.f.',1,'Ophioglossum vulgatum minimum','Ophioglossum vulgatum var. minimum','Ophioglossum uulgat minim',3,0,'','','Hook. fil.','69451308-45d1-5b1e-9b2d-2f44e8e29e7c','Ophioglossum vulgatum var. minimum Hook.f.','Hook.f.','VARIETY','','Ophioglossum','','vulgatum','minimum','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05019921-1098-4af5-8858-a155d6cb445b','','','Dracophyllum brachycladum Colenso',1,'Dracophyllum brachycladum','Dracophyllum brachycladum','Dracophyllum brachyclad',2,0,'','','Colenso','811f0cc8-ff17-5926-8ffc-e2a01f7f0c38','Dracophyllum brachycladum Colenso','Colenso','SPECIES','','Dracophyllum','','brachycladum','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0500ff18-03c9-498e-ac4f-e76fd46eef00','','','Oplophorus novaezeelandiae de Man, 1931',1,'Oplophorus novaezeelandiae','Oplophorus novaezeelandiae','Oplophorus nouaezeelandi',2,0,'','','de Man','e98cf7c2-8154-52e7-85a3-07fff802cf93','Oplophorus novaezeelandiae de Man, 1931','de Man, 1931','SPECIES','','Oplophorus','','novaezeelandiae','','','',NULL,'','','','','','de Man','','','','1931','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05062007-ada9-48f3-8842-54218dadf818','','','Hookeria quadrifaria Sm.',1,'Hookeria quadrifaria','Hookeria quadrifaria','Hookeria quadrifar',2,0,'','','Sm.','149a1a4a-2180-57ef-bfc9-7c9375d172f4','Hookeria quadrifaria Sm.','Sm.','SPECIES','','Hookeria','','quadrifaria','','','',NULL,'','','','','','Sm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0503d6c4-26bb-4422-9f6c-92a8c1f6a169','','','Planothidium peragallii (Brun & Héribaud) Round & Bukhtiyarova',1,'Planothidium peragallii','Planothidium peragallii','Planothidium peragall',2,0,'','','Brun|Héribaud|Round|Bukhtiyarova','786f2403-b291-567f-847b-37fb323b5968','Planothidium peragallii (Brun & Héribaud) Round & Bukhtiyarova','(Brun & Héribaud) Round & Bukhtiyarova','SPECIES','','Planothidium','','peragallii','','','',NULL,'Round & Bukhtiyarova','','','','','Brun & Héribaud','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('050bbdf8-4fdd-4be3-a9c1-113b6b5750e0','','','Callorhynchocotyle callorhynchi (Manter, 1955)',1,'Callorhynchocotyle callorhynchi','Callorhynchocotyle callorhynchi','Callorhynchocotyle callorhynch',2,0,'','','Manter','67b9b3fb-e906-5213-beb7-ef254be842d8','Callorhynchocotyle callorhynchi (Manter, 1955)','(Manter, 1955)','SPECIES','','Callorhynchocotyle','','callorhynchi','','','',NULL,'','','','','','Manter','','','','1955','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05094a26-7d70-4fea-b887-2fd4958e104b','','','Platanurida marplesioides Massoud, 1967',1,'Platanurida marplesioides','Platanurida marplesioides','Platanurida marplesioid',2,0,'','','Massoud','84bfa7fc-64b6-5d72-b898-2f55bddf2afe','Platanurida marplesioides Massoud, 1967','Massoud, 1967','SPECIES','','Platanurida','','marplesioides','','','',NULL,'','','','','','Massoud','','','','1967','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('050cd73a-6e23-4e1a-bccd-73121670db96','','','Chloroclystis aristias Meyrick, 1897',1,'Chloroclystis aristias','Chloroclystis aristias','Chloroclystis aristi',2,0,'','','Meyrick','5614c175-8174-523f-a9cc-20d0dd743475','Chloroclystis aristias Meyrick, 1897','Meyrick, 1897','SPECIES','','Chloroclystis','','aristias','','','',NULL,'','','','','','Meyrick','','','','1897','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0519837c-b8c9-48ed-8d2d-4915937edbaa','','','Psilostomatidae',1,'Psilostomatidae','Psilostomatidae','Psilostomatidae',1,0,'','','','8d2ba611-5893-5d68-b884-e8d4a2316ae3','Psilostomatidae','','FAMILY','Psilostomatidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05180cfa-967c-4593-b0dc-7ed5b8c03628','','','Sphenomeris angustifolia (Bernh.) Brownlie',1,'Sphenomeris angustifolia','Sphenomeris angustifolia','Sphenomeris angustifol',2,0,'','','Bernh.|Brownlie','eec57c05-cb63-56f1-b62c-f924fefafd39','Sphenomeris angustifolia (Bernh.) Brownlie','(Bernh.) Brownlie','SPECIES','','Sphenomeris','','angustifolia','','','',NULL,'Brownlie','','','','','Bernh.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('051a907a-914f-4c6c-b3b4-9f417391b9b8','','','Stipa stuposa Hughes',1,'Stipa stuposa','Stipa stuposa','Stipa stupos',2,0,'','','Hughes','2ec9b00e-6678-5609-bd3c-fea2b2b7fbfd','Stipa stuposa Hughes','Hughes','SPECIES','','Stipa','','stuposa','','','',NULL,'','','','','','Hughes','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('051aaa86-abed-43be-b6aa-dae9182d8856','','','Ensigraptus',1,'Ensigraptus','Ensigraptus','Ensigraptus',1,0,'','','','7d9349eb-f81a-5e45-9848-3bc7ed290e44','Ensigraptus','','GENUS','Ensigraptus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0515435b-9dec-44b3-b76c-e8026883e088','','','Nonionellina',1,'Nonionellina','Nonionellina','Nonionellina',1,0,'','','','4965af31-e99b-5cb2-95cd-07edcc8a49de','Nonionellina','','GENUS','Nonionellina','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0519f2f5-5236-42f9-bcd9-eff58bc35ea1','','','Sagitta maxima (Conant, 1896)',1,'Sagitta maxima','Sagitta maxima','Sagitta maxim',2,0,'','','Conant','2f43f552-5cfc-50b7-9919-43ad2e7061ba','Sagitta maxima (Conant, 1896)','(Conant, 1896)','SPECIES','','Sagitta','','maxima','','','',NULL,'','','','','','Conant','','','','1896','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05205229-ce50-45ff-a0dc-3357663224b0','','','Crucibulum lanosum (Cooke) J.A. Cooper',1,'Crucibulum lanosum','Crucibulum lanosum','Crucibulum lanos',2,0,'','','Cooke|J. A. Cooper','e1d95400-e555-5ea9-b219-dce6a035f2fa','Crucibulum lanosum (Cooke) J.A. Cooper','(Cooke) J.A. Cooper','SPECIES','','Crucibulum','','lanosum','','','',NULL,'J. A. Cooper','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0521d5ee-10ea-429e-b701-b110ba076979','','','Pygoscelis adeliae (Hombron & Jacquinot, 1841)',1,'Pygoscelis adeliae','Pygoscelis adeliae','Pygoscelis adeli',2,0,'','','Hombron|Jacquinot','fbc016e4-4653-5779-86ed-958fc08debf0','Pygoscelis adeliae (Hombron & Jacquinot, 1841)','(Hombron & Jacquinot, 1841)','SPECIES','','Pygoscelis','','adeliae','','','',NULL,'','','','','','Hombron & Jacquinot','','','','1841','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05273b2f-38f0-4776-849a-0f5a2cfcf341','','','Monacrosporium leptosporum (Drechsler) A. Rubner',1,'Monacrosporium leptosporum','Monacrosporium leptosporum','Monacrosporium leptospor',2,0,'','','Drechsler|A. Rubner','1ae8cffb-22d6-5253-9dd6-fa1f02673d9f','Monacrosporium leptosporum (Drechsler) A. Rubner','(Drechsler) A. Rubner','SPECIES','','Monacrosporium','','leptosporum','','','',NULL,'A. Rubner','','','','','Drechsler','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05250707-1568-448d-8e25-5bb67d484c6f','','','Euaugaptilus oblongus (Sars, 1905)',1,'Euaugaptilus oblongus','Euaugaptilus oblongus','Euaugaptilus oblong',2,0,'','','Sars','2b8a8d2b-a7a1-52d3-a55c-62b23aeccc0e','Euaugaptilus oblongus (Sars, 1905)','(Sars, 1905)','SPECIES','','Euaugaptilus','','oblongus','','','',NULL,'','','','','','Sars','','','','1905','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05279598-4251-493b-80df-b4174c7a9ff8','','','Spinifex hirsutus Labill.',1,'Spinifex hirsutus','Spinifex hirsutus','Spinifex hirsut',2,0,'','','Labill.','454c3cc3-aaa6-521d-bd13-a9edbbf7b616','Spinifex hirsutus Labill.','Labill.','SPECIES','','Spinifex','','hirsutus','','','',NULL,'','','','','','Labill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('052d279f-8b7a-40ae-a642-12fc44249be8','','','Leptographium huntii M.J. Wingf',1,'Leptographium huntii','Leptographium huntii','Leptographium hunt',2,0,'','','M. J. Wingf','f471dd7c-856d-5f32-bdc2-bd235b9b35e3','Leptographium huntii M.J. Wingf','M.J. Wingf','SPECIES','','Leptographium','','huntii','','','',NULL,'','','','','','M. J. Wingf','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05291e35-19a0-45d7-9d10-65cb14e17070','','','Metarhizium robertsii J.F. Bisch., S.A. Rehner & Humber',1,'Metarhizium robertsii','Metarhizium robertsii','Metarhizium roberts',2,0,'','','J. F. Bisch.|S. A. Rehner|Humber','f6f153ff-2913-5d46-8b55-48f14c1f10e3','Metarhizium robertsii J.F. Bisch., S.A. Rehner & Humber','J.F. Bisch., S.A. Rehner & Humber','SPECIES','','Metarhizium','','robertsii','','','',NULL,'','','','','','J. F. Bisch., S. A. Rehner & Humber','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03c5fd50-e513-4b72-878a-1064e82c1367','','','Ceratocorys gourreti Paulsen',1,'Ceratocorys gourreti','Ceratocorys gourreti','Ceratocorys gourret',2,0,'','','Paulsen','05a3e050-ed55-503c-9ef3-6a764752ec42','Ceratocorys gourreti Paulsen','Paulsen','SPECIES','','Ceratocorys','','gourreti','','','',NULL,'','','','','','Paulsen','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03c5fbe1-0ed2-4506-bf25-3805bb354eaf','','','Brexiaceae',1,'Brexiaceae','Brexiaceae','Brexiaceae',1,0,'','','','9170dac8-e79c-5017-b619-0c5cf119a56a','Brexiaceae','','FAMILY','Brexiaceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03c3b92b-0c97-4659-9f9e-4cf73897f085','','','Pterostylis trullifolia var. alobula Hatch',1,'Pterostylis trullifolia alobula','Pterostylis trullifolia var. alobula','Pterostylis trullifol alobul',3,0,'','','Hatch','4fe3102e-9b1d-58b8-81d7-492c7608e4e3','Pterostylis trullifolia var. alobula Hatch','Hatch','VARIETY','','Pterostylis','','trullifolia','alobula','','',NULL,'','','','','','Hatch','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03c57dc5-e5f0-4473-a776-97f39acc5fd9','','','Botryotinia globosa N.F. Buchw.',1,'Botryotinia globosa','Botryotinia globosa','Botryotinia globos',2,0,'','','N. F. Buchw.','7bb91525-4f9f-5654-802c-8e06247be7c2','Botryotinia globosa N.F. Buchw.','N.F. Buchw.','SPECIES','','Botryotinia','','globosa','','','',NULL,'','','','','','N. F. Buchw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03c7e834-3f62-4c3d-badd-1dd738d724ad','','','Dicranoloma fasciatum (Hedw.) Paris',1,'Dicranoloma fasciatum','Dicranoloma fasciatum','Dicranoloma fasciat',2,0,'','','Hedw.|Paris','ad69baff-75b5-5da1-85fa-ec8fe6b34c15','Dicranoloma fasciatum (Hedw.) Paris','(Hedw.) Paris','SPECIES','','Dicranoloma','','fasciatum','','','',NULL,'Paris','','','','','Hedw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03cdd604-c1e2-4619-9dcd-7528f0f9f3ef','','','Septoria jahnii Syd.',1,'Septoria jahnii','Septoria jahnii','Septoria iahn',2,0,'','','Syd.','a392fc5a-745f-5551-9104-aefbcd6377a4','Septoria jahnii Syd.','Syd.','SPECIES','','Septoria','','jahnii','','','',NULL,'','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03c9a40b-51b2-41d1-a5a8-7f86ab49139e','','','Biliphyta',1,'Biliphyta','Biliphyta','Biliphyta',1,0,'','','','06d4d76f-f9ae-565f-a5e1-110cca00619f','Biliphyta','','SUBKINGDOM','Biliphyta','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03c8bfc8-5b53-4b88-9493-98eb58c1db05','','','Weissia lancifolia var. weymouthii (R.Br.bis) Wijk & Margad.',1,'Weissia lancifolia weymouthii','Weissia lancifolia var. weymouthii','Weissia lancifol weymouth',3,0,'','','R. Br. bis|Wijk|Margad.','11c4bbbc-a4b5-5efc-8db2-715baddbace3','Weissia lancifolia var. weymouthii (R.Br.bis) Wijk & Margad.','(R.Br.bis) Wijk & Margad.','VARIETY','','Weissia','','lancifolia','weymouthii','','',NULL,'Wijk & Margad.','','','','','R. Br. bis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03c9a422-8a73-4045-b6b3-c0988cd61f65','','','Regalia',1,'Regalia','Regalia','Regalia',1,0,'','','','ffb1b2db-09c4-5d87-bf12-b33547d88c87','Regalia','','GENUS','Regalia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03d4dce1-44a8-40f8-be4b-20a264ae9a6b','','','Saprinus Erichson',1,'Saprinus','Saprinus','Saprinus',1,0,'','','Erichson','5391a967-a614-5197-a2fd-5959c63b943b','Saprinus Erichson','Erichson','GENUS','Saprinus','','','','','','',NULL,'','','','','','Erichson','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03d4e54d-69f5-4619-9929-23af84b95570','','','Solitaria',1,'Solitaria','Solitaria','Solitaria',1,0,'','','','bce0cfb3-a9a4-5a2d-a220-c28c34a814ef','Solitaria','','ORDER','Solitaria','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03d292f6-4c96-4f7d-8825-41ff74f1cd8e','','','Tornatellides',1,'Tornatellides','Tornatellides','Tornatellides',1,0,'','','','b549abcb-a326-5bb5-af42-4cdd256b13bd','Tornatellides','','GENUS','Tornatellides','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03d30db4-df68-4fb4-9586-43a19ce4216f','','','Stackhousia minima Hook.f.',1,'Stackhousia minima','Stackhousia minima','Stackhousia minim',2,0,'','','Hook. fil.','64fd0d26-3140-57c5-8567-e281d76b5573','Stackhousia minima Hook.f.','Hook.f.','SPECIES','','Stackhousia','','minima','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03d46c76-b0f0-4031-81df-83eebeacbaa3','','','Loricella',1,'Loricella','Loricella','Loricella',1,0,'','','','b5dffd21-c7ed-5d4b-9201-3c1504ae5252','Loricella','','GENUS','Loricella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03d25703-54ff-4086-9910-a7672e35a8ea','','','Vibilia longicarpus Behning, 1913',1,'Vibilia longicarpus','Vibilia longicarpus','Vibilia longicarp',2,0,'','','Behning','c25c5a2a-eebb-5159-b357-7974ddbcc439','Vibilia longicarpus Behning, 1913','Behning, 1913','SPECIES','','Vibilia','','longicarpus','','','',NULL,'','','','','','Behning','','','','1913','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03d06218-735e-4292-be24-e701b2250381','','','Kiwaia brontophora (Meyrick, 1885)',1,'Kiwaia brontophora','Kiwaia brontophora','Kiwaia brontophor',2,0,'','','Meyrick','11b37c4d-e45e-5891-bd4e-f51fb826d024','Kiwaia brontophora (Meyrick, 1885)','(Meyrick, 1885)','SPECIES','','Kiwaia','','brontophora','','','',NULL,'','','','','','Meyrick','','','','1885','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03dbfbac-f901-4f62-9f99-1de730aac439','','','Coelothauma duodenum Haeckel, 1887',1,'Coelothauma duodenum','Coelothauma duodenum','Coelothauma duoden',2,0,'','','Haeckel','f7393e46-f972-5694-bccf-407cba666c2a','Coelothauma duodenum Haeckel, 1887','Haeckel, 1887','SPECIES','','Coelothauma','','duodenum','','','',NULL,'','','','','','Haeckel','','','','1887','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03d91fe9-9a93-478e-92c7-65f407a60524','','','Errina cheilopora Cairns, 1983',1,'Errina cheilopora','Errina cheilopora','Errina cheilopor',2,0,'','','Cairns','111ea20e-3aff-5130-9e20-3d693ca2491b','Errina cheilopora Cairns, 1983','Cairns, 1983','SPECIES','','Errina','','cheilopora','','','',NULL,'','','','','','Cairns','','','','1983','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03dbae0d-4c96-4715-9dcf-79ce5c0c05df','','','Marasmius unilamellatus Desjardin & E. Horak',1,'Marasmius unilamellatus','Marasmius unilamellatus','Marasmius unilamellat',2,0,'','','Desjardin|E. Horak','c70f2639-58d8-5d4d-b30f-4a9e38c50024','Marasmius unilamellatus Desjardin & E. Horak','Desjardin & E. Horak','SPECIES','','Marasmius','','unilamellatus','','','',NULL,'','','','','','Desjardin & E. Horak','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03e0bc30-7535-4397-b491-3bdaac8b3f15','','','Stellulathyas',1,'Stellulathyas','Stellulathyas','Stellulathyas',1,0,'','','','cd7c225a-be72-56d2-91b3-11c2e7fcd150','Stellulathyas','','GENUS','Stellulathyas','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03ddee54-1174-4ea7-91df-59dcacf507c7','','','Megadromus guerinii (Chaudoir, 1865)',1,'Megadromus guerinii','Megadromus guerinii','Megadromus guerin',2,0,'','','Chaudoir','32b30557-60c4-51e7-bcca-49d8f2c6be0f','Megadromus guerinii (Chaudoir, 1865)','(Chaudoir, 1865)','SPECIES','','Megadromus','','guerinii','','','',NULL,'','','','','','Chaudoir','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03e3bbf1-0d33-4901-a673-b7930d5ee3ff','','','Dicranograptus ramosus longicaulis Elles & Wood, 1904',1,'Dicranograptus ramosus longicaulis','Dicranograptus ramosus longicaulis','Dicranograptus ramos longicaul',3,0,'','','Elles|Wood','7f3c84e7-8ab6-5bc9-820d-e6e1bf3b289f','Dicranograptus ramosus longicaulis Elles & Wood, 1904','Elles & Wood, 1904','SUBSPECIES','','Dicranograptus','','ramosus','longicaulis','','',NULL,'','','','','','Elles & Wood','','','','1904','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03e4181b-46e3-41cc-82de-e56953087881','','','Peristoreus aericomus (Broun, 1883)',1,'Peristoreus aericomus','Peristoreus aericomus','Peristoreus aericom',2,0,'','','Broun','532d4f38-4875-5abc-8612-82ff86b1e101','Peristoreus aericomus (Broun, 1883)','(Broun, 1883)','SPECIES','','Peristoreus','','aericomus','','','',NULL,'','','','','','Broun','','','','1883','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03e9c4ae-8629-4795-bd70-56154e3c49fb','','','Paradorydium insulare Evans, 1966',1,'Paradorydium insulare','Paradorydium insulare','Paradorydium insular',2,0,'','','Evans','ed32fab9-ff7c-54f8-8a09-40adfbf81e68','Paradorydium insulare Evans, 1966','Evans, 1966','SPECIES','','Paradorydium','','insulare','','','',NULL,'','','','','','Evans','','','','1966','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03e8347c-9b88-4c4e-a906-83dc6726dc81','','','Metzgeria disciformis A.Evans',1,'Metzgeria disciformis','Metzgeria disciformis','Metzgeria disciform',2,0,'','','A. Evans','8618cf5c-9786-5e80-8af4-05efead4c445','Metzgeria disciformis A.Evans','A.Evans','SPECIES','','Metzgeria','','disciformis','','','',NULL,'','','','','','A. Evans','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03ed44d8-676d-4c97-885c-00de3d076b22','','','Coxelus robustus Broun, 1880',1,'Coxelus robustus','Coxelus robustus','Coxelus robust',2,0,'','','Broun','1963c28a-655c-5215-8d7a-3bdd91161444','Coxelus robustus Broun, 1880','Broun, 1880','SPECIES','','Coxelus','','robustus','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03ec0b90-1761-441b-b7b4-2ef5fe671d8e','','','Drosera sewelliae Diels',1,'Drosera sewelliae','Drosera sewelliae','Drosera sewelli',2,0,'','','Diels','e74501f8-4343-5cf1-8801-a4cd74d1f2e9','Drosera sewelliae Diels','Diels','SPECIES','','Drosera','','sewelliae','','','',NULL,'','','','','','Diels','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03f00557-3601-4e94-8406-a29f986b3a24','','','Distichium capillaceum (Hedw.) Bruch & Schimp.',1,'Distichium capillaceum','Distichium capillaceum','Distichium capillace',2,0,'','','Hedw.|Bruch|Schimp.','4b7ab40b-a249-5833-a1eb-949d81704408','Distichium capillaceum (Hedw.) Bruch & Schimp.','(Hedw.) Bruch & Schimp.','SPECIES','','Distichium','','capillaceum','','','',NULL,'Bruch & Schimp.','','','','','Hedw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03fb0e38-bd96-4269-af26-52ed56132083','','','Polyporus radiatus (Sowerby) Fr.',1,'Polyporus radiatus','Polyporus radiatus','Polyporus radiat',2,0,'','','Sowerby|Fr.','11704c0c-2cac-5b1f-a722-99cc9fb92989','Polyporus radiatus (Sowerby) Fr.','(Sowerby) Fr.','SPECIES','','Polyporus','','radiatus','','','',NULL,'Fr.','','','','','Sowerby','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03f30a8e-f5eb-42ab-9206-b4ddae629069','','','Hemerodromia Meigen, 1822',1,'Hemerodromia','Hemerodromia','Hemerodromia',1,0,'','','Meigen','fe0a5dd2-9fe6-55ed-acc4-54eccf679431','Hemerodromia Meigen, 1822','Meigen, 1822','GENUS','Hemerodromia','','','','','','',NULL,'','','','','','Meigen','','','','1822','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03f5db0d-c651-4846-95e2-c5777bdcc6b7','','','Hymenochaete campylopora (Mont.) Spirin & Miettinen',1,'Hymenochaete campylopora','Hymenochaete campylopora','Hymenochaete campylopor',2,0,'','','Mont.|Spirin|Miettinen','6ee83bea-2489-5dc8-aa82-5435d0025798','Hymenochaete campylopora (Mont.) Spirin & Miettinen','(Mont.) Spirin & Miettinen','SPECIES','','Hymenochaete','','campylopora','','','',NULL,'Spirin & Miettinen','','','','','Mont.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0401fb53-06b2-4dd3-b86f-010688ec8133','','','Adelopora fragilis Cairns, 1991',1,'Adelopora fragilis','Adelopora fragilis','Adelopora fragil',2,0,'','','Cairns','d3b9f468-7cde-5f57-bd31-d5102bee624a','Adelopora fragilis Cairns, 1991','Cairns, 1991','SPECIES','','Adelopora','','fragilis','','','',NULL,'','','','','','Cairns','','','','1991','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0400e124-cc63-49ce-b882-488c84402304','','','Neororea',1,'Neororea','Neororea','Neororea',1,0,'','','','09e20a59-399b-544e-95ee-0f960519e28c','Neororea','','GENUS','Neororea','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03fe05e8-8e4e-4974-82b9-588b0064c8ac','','','Uncinia drucei Hamlin',1,'Uncinia drucei','Uncinia drucei','Uncinia druce',2,0,'','','Hamlin','3f2f864e-83f7-5d6a-b3fd-5324f87d57de','Uncinia drucei Hamlin','Hamlin','SPECIES','','Uncinia','','drucei','','','',NULL,'','','','','','Hamlin','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04013c5f-3a7f-43d8-966d-87b8f02457de','','','Cercospora insulana (Sacc.) Vassiljevsky',1,'Cercospora insulana','Cercospora insulana','Cercospora insulan',2,0,'','','Sacc.|Vassiljevsky','fd3a1b81-b0c5-5a69-a934-d1281f9946c0','Cercospora insulana (Sacc.) Vassiljevsky','(Sacc.) Vassiljevsky','SPECIES','','Cercospora','','insulana','','','',NULL,'Vassiljevsky','','','','','Sacc.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0408c221-fdfc-4ad6-a618-0de6f73a816d','','','Cinchona pubescens',1,'Cinchona pubescens','Cinchona pubescens','Cinchona pubescens',2,0,'','','','7a7d443c-39f5-5479-aba2-264a2f365b4c','Cinchona pubescens','','SPECIES','','Cinchona','','pubescens','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04040e61-820a-434d-8645-4135e187be6d','','','Uromyces atriplicis McAlpine',1,'Uromyces atriplicis','Uromyces atriplicis','Uromyces atriplic',2,0,'','','McAlpine','689f91f1-3992-5359-a886-532207f041c2','Uromyces atriplicis McAlpine','McAlpine','SPECIES','','Uromyces','','atriplicis','','','',NULL,'','','','','','McAlpine','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04079a3a-1a4f-4e67-91f4-8be7580fdcd0','','','Calocybe species',4,'','','',NULL,NULL,'','','','','Calocybe species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04060cfd-13f1-476f-bdd2-9a2d647aecc5','','','Sarisa Fletcher, 1979',1,'Sarisa','Sarisa','Sarisa',1,0,'','','Fletcher','f7410082-a738-54e1-8a23-fa0ad7a48395','Sarisa Fletcher, 1979','Fletcher, 1979','GENUS','Sarisa','','','','','','',NULL,'','','','','','Fletcher','','','','1979','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0407c9d4-c1ad-4eb5-998c-ced37adef9d9','','','Pselaphotheseus ihupuku Carlton & Leschen, 2001',1,'Pselaphotheseus ihupuku','Pselaphotheseus ihupuku','Pselaphotheseus ihupuk',2,0,'','','Carlton|Leschen','2e372544-b863-5371-a54d-df61b9c491b0','Pselaphotheseus ihupuku Carlton & Leschen, 2001','Carlton & Leschen, 2001','SPECIES','','Pselaphotheseus','','ihupuku','','','',NULL,'','','','','','Carlton & Leschen','','','','2001','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('049e93cf-c96e-4f78-b4f1-2db240489aed','','','Senecio pentacopus D.G.Drury',1,'Senecio pentacopus','Senecio pentacopus','Senecio pentacop',2,0,'','','D. G. Drury','b4d0fede-0e7d-5848-8892-4bdf44976697','Senecio pentacopus D.G.Drury','D.G.Drury','SPECIES','','Senecio','','pentacopus','','','',NULL,'','','','','','D. G. Drury','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('049df74b-8766-4b6a-8c84-40024dbcb6e2','','','Pusillomyces J.S. Oliveira',1,'Pusillomyces','Pusillomyces','Pusillomyces',1,0,'','','J. S. Oliveira','4b69a0a8-1416-50f6-a865-b95e7ce14d40','Pusillomyces J.S. Oliveira','J.S. Oliveira','GENUS','Pusillomyces','','','','','','',NULL,'','','','','','J. S. Oliveira','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('049dfda0-c3c9-477e-99d1-b8cd393f36c7','','','Apodospora simulans Cain & J.H. Mirza',1,'Apodospora simulans','Apodospora simulans','Apodospora simulans',2,0,'','','Cain|J. H. Mirza','0b881d14-3393-5f19-8477-7eb1012d7667','Apodospora simulans Cain & J.H. Mirza','Cain & J.H. Mirza','SPECIES','','Apodospora','','simulans','','','',NULL,'','','','','','Cain & J. H. Mirza','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04a84e9c-5c29-41be-92ba-44d767bb8b2e','','','Racopilaceae Kindb.',1,'Racopilaceae','Racopilaceae','Racopilaceae',1,0,'','','Kindb.','19fb3ba1-2110-5750-ab00-c9e0b0e5ae1b','Racopilaceae Kindb.','Kindb.','FAMILY','Racopilaceae','','','','','','',NULL,'','','','','','Kindb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04a6a964-7f61-49f0-8493-5413c2ffb020','','','Acarapis vagans Schneider, 1941',1,'Acarapis vagans','Acarapis vagans','Acarapis uagans',2,0,'','','Schneider','719170dc-536f-5687-ba1c-fd203567dd43','Acarapis vagans Schneider, 1941','Schneider, 1941','SPECIES','','Acarapis','','vagans','','','',NULL,'','','','','','Schneider','','','','1941','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04a851f4-35a4-4a47-a22c-7925a904344c','','','Pottia davalliana (Sm.) C.E.O.Jensen',1,'Pottia davalliana','Pottia davalliana','Pottia dauallian',2,0,'','','Sm.|C. E. O. Jensen','915a7b7e-8027-5cc7-a9ef-8668a713ca8b','Pottia davalliana (Sm.) C.E.O.Jensen','(Sm.) C.E.O.Jensen','SPECIES','','Pottia','','davalliana','','','',NULL,'C. E. O. Jensen','','','','','Sm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04a45999-0122-4749-bc67-ce8476773e45','','','Dicnemon obsoletinerve Hampe & Müll.Hal.',1,'Dicnemon obsoletinerve','Dicnemon obsoletinerve','Dicnemon obsoletineru',2,0,'','','Hampe|Müll. Hal.','37657374-0ce6-51d8-8461-1ddb400bcc00','Dicnemon obsoletinerve Hampe & Müll.Hal.','Hampe & Müll.Hal.','SPECIES','','Dicnemon','','obsoletinerve','','','',NULL,'','','','','','Hampe & Müll. Hal.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04b2d86a-81ba-4911-b395-3af841fa870f','','','Holacanthella',1,'Holacanthella','Holacanthella','Holacanthella',1,0,'','','','e8575f4d-7d69-56bb-bfe8-db2e8c0f9e83','Holacanthella','','GENUS','Holacanthella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04ad8cfd-fa74-4f0d-b14d-55d3111a4c63','','','Thelohanellus',1,'Thelohanellus','Thelohanellus','Thelohanellus',1,0,'','','','4bf86db0-5bcf-5f8b-97fa-488d40d50386','Thelohanellus','','GENUS','Thelohanellus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04ae7ee2-464c-48ab-858d-98e5b606f6cd','','','Amaryllis fothergillii Andrews',1,'Amaryllis fothergillii','Amaryllis fothergillii','Amaryllis fothergill',2,0,'','','Andrews','e483e151-536e-57ff-ba82-fe356460408b','Amaryllis fothergillii Andrews','Andrews','SPECIES','','Amaryllis','','fothergillii','','','',NULL,'','','','','','Andrews','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04b29b45-452e-47d1-aed2-e2eeafc79359','','','Xylella fastidiosa subsp. "piercei" Schaad et al., 2004',4,'','','',NULL,NULL,'','','','','Xylella fastidiosa subsp. "piercei" Schaad et al., 2004','','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04b24df8-abe8-4193-9431-fe18d859388f','','','Cyperus insularis Heenan & de Lange',1,'Cyperus insularis','Cyperus insularis','Cyperus insular',2,0,'','','Heenan|de Lange','2826bcc5-dd1b-5d4e-aee8-b0305810593b','Cyperus insularis Heenan & de Lange','Heenan & de Lange','SPECIES','','Cyperus','','insularis','','','',NULL,'','','','','','Heenan & de Lange','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04ba68b0-d343-49a0-8745-3efa353a672f','','','Mielichhoferia buchananii R.Br.bis',1,'Mielichhoferia buchananii','Mielichhoferia buchananii','Mielichhoferia buchanan',2,0,'','','R. Br. bis','360e9d06-aaaf-5262-99ca-731a3a70f58e','Mielichhoferia buchananii R.Br.bis','R.Br.bis','SPECIES','','Mielichhoferia','','buchananii','','','',NULL,'','','','','','R. Br. bis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04b70903-2648-4803-9828-958b5b38e369','','','Buglossoides Moench',1,'Buglossoides','Buglossoides','Buglossoides',1,0,'','','Moench','9f1f6e63-dae4-5256-954d-d351239cb8f5','Buglossoides Moench','Moench','GENUS','Buglossoides','','','','','','',NULL,'','','','','','Moench','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04b814ae-67b3-4c65-82fa-b5dc3593c211','','','Epichloe tembladerae (Cabral & J.F. White) Iannone & Schardl',1,'Epichloe tembladerae','Epichloe tembladerae','Epichloe temblader',2,0,'','','Cabral|J. F. White|Iannone|Schardl','0521a809-da4f-5b60-ad61-867cd7b8893e','Epichloe tembladerae (Cabral & J.F. White) Iannone & Schardl','(Cabral & J.F. White) Iannone & Schardl','SPECIES','','Epichloe','','tembladerae','','','',NULL,'Iannone & Schardl','','','','','Cabral & J. F. White','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04bd9f44-dfb2-41f1-9f53-a0320808ea56','','','Arthurdendyus species 4 Johns unpubl.',4,'','','',NULL,NULL,'','','','','Arthurdendyus species 4 Johns unpubl.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04c0921d-0c91-4b56-90d1-a3c45f012e71','','','Corynoptera pentaspina Mohrig, 1999',1,'Corynoptera pentaspina','Corynoptera pentaspina','Corynoptera pentaspin',2,0,'','','Mohrig','205c61a5-af98-5ddd-ae27-5d1bfaa29d53','Corynoptera pentaspina Mohrig, 1999','Mohrig, 1999','SPECIES','','Corynoptera','','pentaspina','','','',NULL,'','','','','','Mohrig','','','','1999','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04c0f00c-902d-435f-92e8-ded20f296ed2','','','Staurastrum tetracerum Ralfs',1,'Staurastrum tetracerum','Staurastrum tetracerum','Staurastrum tetracer',2,0,'','','Ralfs','d3fbd424-7f42-535e-a711-30cc886f65c8','Staurastrum tetracerum Ralfs','Ralfs','SPECIES','','Staurastrum','','tetracerum','','','',NULL,'','','','','','Ralfs','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04c113ba-8f1d-49dc-8a66-fbc2e19c7eed','','','Kaveinga orbitosa (Broun, 1880)',1,'Kaveinga orbitosa','Kaveinga orbitosa','Kaveinga orbitos',2,0,'','','Broun','09e7eff5-5a6d-57a4-b244-717e4aa35e8e','Kaveinga orbitosa (Broun, 1880)','(Broun, 1880)','SPECIES','','Kaveinga','','orbitosa','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04c3dd7b-8f40-475a-a60d-3abd05896056','','','Heliocidaris',1,'Heliocidaris','Heliocidaris','Heliocidaris',1,0,'','','','877af08f-e134-544c-9a84-6c0434531f5f','Heliocidaris','','GENUS','Heliocidaris','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04c28175-727d-4aec-a773-6a36059754fd','','','Pisonia brunoniana Endl.',1,'Pisonia brunoniana','Pisonia brunoniana','Pisonia brunonian',2,0,'','','Endl.','3f9b9ffc-c199-5683-be67-72064112e87b','Pisonia brunoniana Endl.','Endl.','SPECIES','','Pisonia','','brunoniana','','','',NULL,'','','','','','Endl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04c32457-5742-454b-a7af-9f48e5b0845c','','','Celmisia viscosa Hook.f.',1,'Celmisia viscosa','Celmisia viscosa','Celmisia uiscos',2,0,'','','Hook. fil.','9b933480-3c05-5636-a469-abfabd2be5f3','Celmisia viscosa Hook.f.','Hook.f.','SPECIES','','Celmisia','','viscosa','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04c5f6e2-8744-4909-a81c-f57c7e8625c6','','','Actiniidae',1,'Actiniidae','Actiniidae','Actiniidae',1,0,'','','','5e811a73-9166-57ef-81b1-82debd7c3e95','Actiniidae','','FAMILY','Actiniidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04cd1e83-51bc-4772-88a5-15e6dd627ee8','','','Pimelea aridula Cheeseman',1,'Pimelea aridula','Pimelea aridula','Pimelea aridul',2,0,'','','Cheeseman','6ecedde1-e059-52a8-8967-d3439cf31ffb','Pimelea aridula Cheeseman','Cheeseman','SPECIES','','Pimelea','','aridula','','','',NULL,'','','','','','Cheeseman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04d08f95-1b74-4e4d-afb2-87070d4c776c','','','Passalora tomentosae (Hansf.) U. Braun & Crous',1,'Passalora tomentosae','Passalora tomentosae','Passalora tomentos',2,0,'','','Hansf.|U. Braun|Crous','4457e832-0583-5a40-bf7c-e486fb5469f7','Passalora tomentosae (Hansf.) U. Braun & Crous','(Hansf.) U. Braun & Crous','SPECIES','','Passalora','','tomentosae','','','',NULL,'U. Braun & Crous','','','','','Hansf.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04cbfb67-1115-44be-b2cc-e4bb42217c46','','','Stenopterobia Brebisson',1,'Stenopterobia','Stenopterobia','Stenopterobia',1,0,'','','Brebisson','f7e17f44-7e18-5f89-a4fb-b856e086bba8','Stenopterobia Brebisson','Brebisson','GENUS','Stenopterobia','','','','','','',NULL,'','','','','','Brebisson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04d29972-b474-42d4-bf93-4a3fc2eca6e8','','','Tilletia striiformis (Westend.) Sacc.',1,'Tilletia striiformis','Tilletia striiformis','Tilletia striiform',2,0,'','','Westend.|Sacc.','22913e93-f379-56be-ab81-706d9e7eb5f3','Tilletia striiformis (Westend.) Sacc.','(Westend.) Sacc.','SPECIES','','Tilletia','','striiformis','','','',NULL,'Sacc.','','','','','Westend.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04d24500-2ef3-4fac-b5c6-93d3ac45f4aa','','','Crocus scharojanii Rupr.',1,'Crocus scharojanii','Crocus scharojanii','Crocus scharoian',2,0,'','','Rupr.','7fcd9b3c-7469-56a8-87f8-85c3fb196635','Crocus scharojanii Rupr.','Rupr.','SPECIES','','Crocus','','scharojanii','','','',NULL,'','','','','','Rupr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04d3361f-31b5-4972-a6be-ed7e314c86e8','','','Neoferonia edax (Chaudoir, 1878)',1,'Neoferonia edax','Neoferonia edax','Neoferonia edax',2,0,'','','Chaudoir','7143b4f4-4a1f-5514-b183-a612d306f164','Neoferonia edax (Chaudoir, 1878)','(Chaudoir, 1878)','SPECIES','','Neoferonia','','edax','','','',NULL,'','','','','','Chaudoir','','','','1878','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04dc1af8-3654-4be4-a41d-1b13aaa4b890','','','Euconnus (Tetramelus) northlandensis Franz, 1975',1,'Euconnus northlandensis','Euconnus northlandensis','Euconnus northlandens',2,0,'','','Franz','c867e919-0f16-58b9-b2bf-8cd7eb994c99','Euconnus (Tetramelus) northlandensis Franz, 1975','Franz, 1975','SPECIES','','Euconnus','Tetramelus','northlandensis','','','',NULL,'','','','','','Franz','','','','1975','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04e437cd-f197-4ba8-8087-7a085d805db0','','','Alternaria alternata (Fr.) Keissl.',1,'Alternaria alternata','Alternaria alternata','Alternaria alternat',2,0,'','','Fr.|Keissl.','d634530c-72d9-5c82-8bca-b3212ff7d467','Alternaria alternata (Fr.) Keissl.','(Fr.) Keissl.','SPECIES','','Alternaria','','alternata','','','',NULL,'Keissl.','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04e0df2d-3f4e-4518-8d8c-c20cd842ecd0','','','Austrosimulium dumbletoni Crosby, 1976',1,'Austrosimulium dumbletoni','Austrosimulium dumbletoni','Austrosimulium dumbleton',2,0,'','','Crosby','e0c20e6c-79cb-5599-b486-9bde494d4294','Austrosimulium dumbletoni Crosby, 1976','Crosby, 1976','SPECIES','','Austrosimulium','','dumbletoni','','','',NULL,'','','','','','Crosby','','','','1976','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04e6898b-7ed2-40b4-8f76-00dead570f30','','','Paecilomyces baarnensis Fassat.',1,'Paecilomyces baarnensis','Paecilomyces baarnensis','Paecilomyces baarnens',2,0,'','','Fassat.','b0e06875-579b-5eea-900d-acf2dc47e9d4','Paecilomyces baarnensis Fassat.','Fassat.','SPECIES','','Paecilomyces','','baarnensis','','','',NULL,'','','','','','Fassat.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04e87b7c-cc31-4bec-911b-4d6ede3ac9a9','','','Narcissea D. Wächt. & A. Melzer',1,'Narcissea','Narcissea','Narcissea',1,0,'','','D. Wächt.|A. Melzer','abf6a84b-49f1-50ae-a8ed-12f1630519f8','Narcissea D. Wächt. & A. Melzer','D. Wächt. & A. Melzer','GENUS','Narcissea','','','','','','',NULL,'','','','','','D. Wächt. & A. Melzer','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04e822e2-8f6a-44ff-a8c2-898287a0fd9e','','','Cyttopsis rosea (Lowe, 1843)',1,'Cyttopsis rosea','Cyttopsis rosea','Cyttopsis rose',2,0,'','','Lowe','70d896cb-5899-522f-8eb6-4b211ded3e7f','Cyttopsis rosea (Lowe, 1843)','(Lowe, 1843)','SPECIES','','Cyttopsis','','rosea','','','',NULL,'','','','','','Lowe','','','','1843','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04e501eb-b609-4750-a22e-fd40bb65e058','','','Pteris vittata L.',1,'Pteris vittata','Pteris vittata','Pteris uittat',2,0,'','','L.','c3d5bd30-357b-54d6-9c14-6dcca6f5bb97','Pteris vittata L.','L.','SPECIES','','Pteris','','vittata','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05326a81-3d1a-41a6-a9bf-134ed894c698','','','Attenuata affinis orientalis (Dell, 1956)',1,'Attenuata affinis orientalis','Attenuata affinis orientalis','Attenuata affin oriental',3,0,'','','Dell','61673811-caed-541d-b334-abc9c3676d47','Attenuata affinis orientalis (Dell, 1956)','(Dell, 1956)','SUBSPECIES','','Attenuata','','affinis','orientalis','','',NULL,'','','','','','Dell','','','','1956','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05337b6b-b1e4-41ef-a645-694e17ef6013','','','Anthracoidea globularis Kukkonen',1,'Anthracoidea globularis','Anthracoidea globularis','Anthracoidea globular',2,0,'','','Kukkonen','b752cced-b5fd-5634-a143-68b321f07f15','Anthracoidea globularis Kukkonen','Kukkonen','SPECIES','','Anthracoidea','','globularis','','','',NULL,'','','','','','Kukkonen','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0531eaa4-a93a-4652-981b-af8d998e89b5','','','Calliostoma tosaense (Kuroda & Habe, 1961)',1,'Calliostoma tosaense','Calliostoma tosaense','Calliostoma tosaens',2,0,'','','Kuroda|Habe','418547d5-0d76-5da1-b114-90510be44559','Calliostoma tosaense (Kuroda & Habe, 1961)','(Kuroda & Habe, 1961)','SPECIES','','Calliostoma','','tosaense','','','',NULL,'','','','','','Kuroda & Habe','','','','1961','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05381b7d-fc58-4925-becb-f58adae37861','','','Oxalis corniculata var. ciliifera (A.Cunn.) Hook.f.',1,'Oxalis corniculata ciliifera','Oxalis corniculata var. ciliifera','Oxalis corniculat ciliifer',3,0,'','','A. Cunn.|Hook. fil.','08c62b1c-c4eb-501a-b5bc-09536762b217','Oxalis corniculata var. ciliifera (A.Cunn.) Hook.f.','(A.Cunn.) Hook.f.','VARIETY','','Oxalis','','corniculata','ciliifera','','',NULL,'Hook. fil.','','','','','A. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('054180cd-2766-484d-937c-353245e84798','','','Penium cylindrus (Ehrenb.) ex Bréb. var. cylindrus',4,'','','',NULL,NULL,'','','','','Penium cylindrus (Ehrenb.) ex Bréb. var. cylindrus','','VARIETY','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('053b1ab9-3988-4faa-9442-59237c615524','','','Lophiopoacea paramacrostoma',1,'Lophiopoacea paramacrostoma','Lophiopoacea paramacrostoma','Lophiopoacea paramacrostom',2,0,'','','','1b6410f1-f44a-52f4-9a66-1fe97f063959','Lophiopoacea paramacrostoma','','SPECIES','','Lophiopoacea','','paramacrostoma','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0541f47f-6d9f-42a4-9f19-b274e539dc06','','','Conochilus',1,'Conochilus','Conochilus','Conochilus',1,0,'','','','c8c7aada-942a-5e66-bb25-254941f8e1bf','Conochilus','','GENUS','Conochilus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('053ca397-51e9-4404-a854-be5c355181ad','','','Adrisa nigrosignata (White, 1878)',1,'Adrisa nigrosignata','Adrisa nigrosignata','Adrisa nigrosignat',2,0,'','','White','c04a8308-92d2-56cb-a3e2-5d66a7b230d1','Adrisa nigrosignata (White, 1878)','(White, 1878)','SPECIES','','Adrisa','','nigrosignata','','','',NULL,'','','','','','White','','','','1878','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0542d2f5-886b-465b-8e87-42cf5464fe60','','','Metatrichia vesparia (Batsch) Nann.-Bremek. ex G.W.Martin & Alexop.',1,'Metatrichia vesparia','Metatrichia vesparia','Metatrichia uespar',2,0,'','','Batsch|Nann.-Bremek.|G. W. Martin|Alexop.','4d04d0a5-82e0-5a1c-a992-5934311ea504','Metatrichia vesparia (Batsch) Nann.-Bremek. ex G.W.Martin & Alexop.','(Batsch) Nann.-Bremek. ex G.W.Martin & Alexop.','SPECIES','','Metatrichia','','vesparia','','','',NULL,'Nann.-Bremek.','','G. W. Martin & Alexop.','','','Batsch','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05498355-f246-4255-b5a1-bdeb8b4a1170','','','Inula L.',1,'Inula','Inula','Inula',1,0,'','','L.','de2a6117-a6df-527e-a3b9-33eeab7063bf','Inula L.','L.','GENUS','Inula','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('055598b0-9f02-467c-88e3-06696fb67af9','','','Onoba simplex (Powell, 1927)',1,'Onoba simplex','Onoba simplex','Onoba simplex',2,0,'','','Powell','7e10b2c7-9c15-5d64-ac90-5bd0666e0435','Onoba simplex (Powell, 1927)','(Powell, 1927)','SPECIES','','Onoba','','simplex','','','',NULL,'','','','','','Powell','','','','1927','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05576ec2-5b5a-4700-b3fe-6d1fbd17b1ce','','','Chiltoniella elongata Knox & Fenwick, 1977',1,'Chiltoniella elongata','Chiltoniella elongata','Chiltoniella elongat',2,0,'','','Knox|Fenwick','09e704df-aa70-5dce-bcac-036721cd43e1','Chiltoniella elongata Knox & Fenwick, 1977','Knox & Fenwick, 1977','SPECIES','','Chiltoniella','','elongata','','','',NULL,'','','','','','Knox & Fenwick','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05565eed-1371-4db4-9530-a01a489cec92','','','Philocheras quadrispinosus (Yaldwyn, 1971)',1,'Philocheras quadrispinosus','Philocheras quadrispinosus','Philocheras quadrispinos',2,0,'','','Yaldwyn','70e2fd7e-7586-5a4f-9a26-d0d8b1c67abb','Philocheras quadrispinosus (Yaldwyn, 1971)','(Yaldwyn, 1971)','SPECIES','','Philocheras','','quadrispinosus','','','',NULL,'','','','','','Yaldwyn','','','','1971','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('055509eb-aad6-447c-b7f3-e4fc80b96544','','','Paroxyethira ramifera Ward & Henderson, 2004',1,'Paroxyethira ramifera','Paroxyethira ramifera','Paroxyethira ramifer',2,0,'','','Ward|Henderson','e050281c-1bed-5513-988f-69140ef67cb2','Paroxyethira ramifera Ward & Henderson, 2004','Ward & Henderson, 2004','SPECIES','','Paroxyethira','','ramifera','','','',NULL,'','','','','','Ward & Henderson','','','','2004','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('055b0d9e-c1b9-416f-b4dc-701926044a07','','','Pterocorys clausus (Popofsky, 1913)',1,'Pterocorys clausus','Pterocorys clausus','Pterocorys claus',2,0,'','','Popofsky','03b30d72-9512-596c-bbf2-bc4468398b48','Pterocorys clausus (Popofsky, 1913)','(Popofsky, 1913)','SPECIES','','Pterocorys','','clausus','','','',NULL,'','','','','','Popofsky','','','','1913','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05604b0b-6eb2-4a55-9a48-d9f3a95eccef','','','Beris lacuans Miller, 1917',1,'Beris lacuans','Beris lacuans','Beris lacuans',2,0,'','','Miller','5bc2e193-61d7-5903-b748-6e8b06fb6ba6','Beris lacuans Miller, 1917','Miller, 1917','SPECIES','','Beris','','lacuans','','','',NULL,'','','','','','Miller','','','','1917','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0564b2bb-e8a8-4b59-b02e-289c386703c6','','','Neocosmospora vasinfecta E.F. Sm.',1,'Neocosmospora vasinfecta','Neocosmospora vasinfecta','Neocosmospora uasinfect',2,0,'','','E. F. Sm.','2584cd0b-8906-593d-903d-e2e1fb39c2c2','Neocosmospora vasinfecta E.F. Sm.','E.F. Sm.','SPECIES','','Neocosmospora','','vasinfecta','','','',NULL,'','','','','','E. F. Sm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0566f201-5245-4c9c-9c34-6cc1d76ad2c7','','','Diaporthe perniciosa Marchal & É.J. Marchal',1,'Diaporthe perniciosa','Diaporthe perniciosa','Diaporthe pernicios',2,0,'','','Marchal|É. J. Marchal','62d5a882-9673-56e6-9d93-9b2ed5ff8dbd','Diaporthe perniciosa Marchal & É.J. Marchal','Marchal & É.J. Marchal','SPECIES','','Diaporthe','','perniciosa','','','',NULL,'','','','','','Marchal & É. J. Marchal','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0566524f-c55b-4081-98bc-b0eb3404b283','','','Pulluterina',1,'Pulluterina','Pulluterina','Pulluterina',1,0,'','','','160d0ced-c634-54a8-9865-775ac670ce53','Pulluterina','','GENUS','Pulluterina','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('056645ab-7805-42fa-9719-bdd8295cebb4','','','Recurvoidatus',1,'Recurvoidatus','Recurvoidatus','Recurvoidatus',1,0,'','','','22dcac6f-e465-5ef2-a891-43a0221e9372','Recurvoidatus','','GENUS','Recurvoidatus','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05694c44-44db-4a20-85f3-e76d40dc404c','','','Tovara virginiana var. filiformis (Thunb.) Steward',1,'Tovara virginiana filiformis','Tovara virginiana var. filiformis','Tovara uirginian filiform',3,0,'','','Thunb.|Steward','b1b10135-4351-5744-a037-b3e5fadb9c14','Tovara virginiana var. filiformis (Thunb.) Steward','(Thunb.) Steward','VARIETY','','Tovara','','virginiana','filiformis','','',NULL,'Steward','','','','','Thunb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('056adc99-3b60-422a-92d1-3c7c9d124fd4','','','Didymium bahiense Gottsb.',1,'Didymium bahiense','Didymium bahiense','Didymium bahiens',2,0,'','','Gottsb.','9ecf21d8-6130-5794-932f-ea31397b8dd3','Didymium bahiense Gottsb.','Gottsb.','SPECIES','','Didymium','','bahiense','','','',NULL,'','','','','','Gottsb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('056d0f46-cca2-4ea8-b3c8-ad41508fb3e0','','','Pseudomonas beteli (Ragunathan 1928) Savulescu, 1947',1,'Pseudomonas beteli','Pseudomonas beteli','Pseudomonas betel',2,0,'','','Ragunathan|Savulescu','e8286fdf-9f37-5df4-b49d-ec615e73bac3','Pseudomonas beteli (Ragunathan 1928) Savulescu, 1947','(Ragunathan 1928) Savulescu, 1947','SPECIES','','Pseudomonas','','beteli','','','',NULL,'Savulescu','','','','1947','Ragunathan','','','','1928','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('056a42e0-272b-4f92-9e9e-c3f57870ba51','','','Allium candidissimum Cav.',1,'Allium candidissimum','Allium candidissimum','Allium candidissim',2,0,'','','Cav.','7881009a-3e0e-5900-934d-544050e0cad2','Allium candidissimum Cav.','Cav.','SPECIES','','Allium','','candidissimum','','','',NULL,'','','','','','Cav.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('056c783b-4374-4c44-9104-d9fa1345b3e6','','','Anaptychia japonica (M.Satô) Kurok.',1,'Anaptychia japonica','Anaptychia japonica','Anaptychia iaponic',2,0,'','','M. Satô|Kurok.','1699b5fb-2d37-516d-956e-bf441fad23e1','Anaptychia japonica (M.Satô) Kurok.','(M.Satô) Kurok.','SPECIES','','Anaptychia','','japonica','','','',NULL,'Kurok.','','','','','M. Satô','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('056fee9d-f500-41ae-8a83-8e32bd937555','','','Alternaria cucurbitae Letendre & Roum.',1,'Alternaria cucurbitae','Alternaria cucurbitae','Alternaria cucurbit',2,0,'','','Letendre|Roum.','f1f9b714-ca1a-5e3e-bc03-1980b0444fbb','Alternaria cucurbitae Letendre & Roum.','Letendre & Roum.','SPECIES','','Alternaria','','cucurbitae','','','',NULL,'','','','','','Letendre & Roum.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05790a96-0724-4af3-9926-9bd4e7cf932f','','','Monophadnus spinolae (Klug, 1816)',1,'Monophadnus spinolae','Monophadnus spinolae','Monophadnus spinol',2,0,'','','Klug','40c76904-4338-5a9d-a08e-c177802f4d1d','Monophadnus spinolae (Klug, 1816)','(Klug, 1816)','SPECIES','','Monophadnus','','spinolae','','','',NULL,'','','','','','Klug','','','','1816','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05714d2d-197d-4cb0-8b1b-d3226ad6c3cb','','','Tenuipalpus rangiorae Collyer, 1964',1,'Tenuipalpus rangiorae','Tenuipalpus rangiorae','Tenuipalpus rangior',2,0,'','','Collyer','fefdc222-5f8b-53eb-a1b5-cc3932d17ed8','Tenuipalpus rangiorae Collyer, 1964','Collyer, 1964','SPECIES','','Tenuipalpus','','rangiorae','','','',NULL,'','','','','','Collyer','','','','1964','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05802285-5ded-4a87-9e1e-151ec4386342','','','Armeria maritima (Mill.) Willd.',1,'Armeria maritima','Armeria maritima','Armeria maritim',2,0,'','','Mill.|Willd.','27f40b68-3a4a-5ccd-a94c-1f3881cd5f86','Armeria maritima (Mill.) Willd.','(Mill.) Willd.','SPECIES','','Armeria','','maritima','','','',NULL,'Willd.','','','','','Mill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('057bd710-84c7-410b-aaa2-265bd1ba1163','','','Stethaspis suturalis (Fabricius, 1775)',1,'Stethaspis suturalis','Stethaspis suturalis','Stethaspis sutural',2,0,'','','Fabricius','97ca24e6-b50f-55aa-8acf-ebe8a1f577ac','Stethaspis suturalis (Fabricius, 1775)','(Fabricius, 1775)','SPECIES','','Stethaspis','','suturalis','','','',NULL,'','','','','','Fabricius','','','','1775','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('057b844e-3105-401c-bea6-a72a74b26995','','','Hierochloe magellanica Hook.f.',1,'Hierochloe magellanica','Hierochloe magellanica','Hierochloe magellanic',2,0,'','','Hook. fil.','8af6cad2-d6ae-51ed-8e68-b972478ce7ae','Hierochloe magellanica Hook.f.','Hook.f.','SPECIES','','Hierochloe','','magellanica','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05800e06-2ba1-41b4-961b-f6dbc5e8460e','','','Ramaria curta (Fr.) Schild',1,'Ramaria curta','Ramaria curta','Ramaria curt',2,0,'','','Fr.|Schild','29a386d0-fe5e-538a-9a46-d6dbca1dbe4d','Ramaria curta (Fr.) Schild','(Fr.) Schild','SPECIES','','Ramaria','','curta','','','',NULL,'Schild','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05836b94-c43f-405e-83fd-2fa93f78d4ff','','','Gonaxia',1,'Gonaxia','Gonaxia','Gonaxia',1,0,'','','','d12a49a9-2e9c-508b-a4c6-874cb3e12af9','Gonaxia','','GENUS','Gonaxia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('058711ff-7dd2-4874-a649-62908469f200','','','Anatoma aupouria (Powell, 1937)',1,'Anatoma aupouria','Anatoma aupouria','Anatoma aupour',2,0,'','','Powell','8e53a2fd-3066-5c0c-a566-c1872e501972','Anatoma aupouria (Powell, 1937)','(Powell, 1937)','SPECIES','','Anatoma','','aupouria','','','',NULL,'','','','','','Powell','','','','1937','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05836455-506b-4e6a-b8e7-a13805616194','','','Pinus L.',1,'Pinus','Pinus','Pinus',1,0,'','','L.','149fce49-a264-5479-bc1b-aaa083a0a105','Pinus L.','L.','GENUS','Pinus','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0583d75c-c289-46e4-9022-cb155cdca89c','','','Quercus bicolor Willd.',1,'Quercus bicolor','Quercus bicolor','Quercus bicolor',2,0,'','','Willd.','27fca70c-2912-516c-ab1d-e012d3c611e9','Quercus bicolor Willd.','Willd.','SPECIES','','Quercus','','bicolor','','','',NULL,'','','','','','Willd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('040aa17b-8d03-4da0-8419-3f2e96b23bc7','','','Heterodinium',1,'Heterodinium','Heterodinium','Heterodinium',1,0,'','','','f8c0b2fb-baf9-5e52-8129-a7b7b859d58a','Heterodinium','','GENUS','Heterodinium','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('040d5697-3f02-47fa-9374-555ba8ee4a58','','','Fusarium tumidum Sherb.',1,'Fusarium tumidum','Fusarium tumidum','Fusarium tumid',2,0,'','','Sherb.','001b1216-77d9-5662-ad7e-ad41adb4f7b1','Fusarium tumidum Sherb.','Sherb.','SPECIES','','Fusarium','','tumidum','','','',NULL,'','','','','','Sherb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('040a8bd3-e6be-4278-969d-96465c54494e','','','Kiaerograptus species',4,'','','',NULL,NULL,'','','','','Kiaerograptus species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04105d12-4d79-4e05-8c25-c5f1f866a19a','','','Monilea incerta Iredale, 1912',1,'Monilea incerta','Monilea incerta','Monilea incert',2,0,'','','Iredale','733f7734-7d27-54bb-a1de-764f485a3874','Monilea incerta Iredale, 1912','Iredale, 1912','SPECIES','','Monilea','','incerta','','','',NULL,'','','','','','Iredale','','','','1912','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04161f4e-3143-4702-821d-2a5c73099e68','','','Platycercus Vigors',1,'Platycercus','Platycercus','Platycercus',1,0,'','','Vigors','662a36f4-62b2-50d2-9f28-b4dbb3751f85','Platycercus Vigors','Vigors','GENUS','Platycercus','','','','','','',NULL,'','','','','','Vigors','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04119d1b-97cc-43c1-9a79-4c46f1d9c488','','','Agaricus laccatus Scop.',1,'Agaricus laccatus','Agaricus laccatus','Agaricus laccat',2,0,'','','Scop.','b453a860-1288-50a9-ba7a-9252911ae61a','Agaricus laccatus Scop.','Scop.','SPECIES','','Agaricus','','laccatus','','','',NULL,'','','','','','Scop.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04143f5c-2c7a-46ed-978d-8d6eaef8b755','','','Lanceoppia haarlovi (Hammer, 1968)',1,'Lanceoppia haarlovi','Lanceoppia haarlovi','Lanceoppia haarlou',2,0,'','','Hammer','31436512-e90b-51a2-a8a6-2c41a5b9f390','Lanceoppia haarlovi (Hammer, 1968)','(Hammer, 1968)','SPECIES','','Lanceoppia','','haarlovi','','','',NULL,'','','','','','Hammer','','','','1968','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0411c4cd-b064-40a6-9d92-ef2614411ced','','','Heteroglypta',1,'Heteroglypta','Heteroglypta','Heteroglypta',1,0,'','','','8e3be3e2-937b-5e22-98ae-ac9741b7536a','Heteroglypta','','GENUS','Heteroglypta','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0413fa7a-1e78-41af-834b-fd712b4f85b4','','','Agaricus tylicolor Fr.',1,'Agaricus tylicolor','Agaricus tylicolor','Agaricus tylicolor',2,0,'','','Fr.','7b1a6f5e-3e63-5a27-8252-b3f8fe692cec','Agaricus tylicolor Fr.','Fr.','SPECIES','','Agaricus','','tylicolor','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('041f8e24-aff2-44e4-813a-52070884b010','','','Urocystis paridis (Unger) Thüm.',1,'Urocystis paridis','Urocystis paridis','Urocystis parid',2,0,'','','Unger|Thüm.','d852dd83-f8bf-5f3f-8012-6176dcbdf041','Urocystis paridis (Unger) Thüm.','(Unger) Thüm.','SPECIES','','Urocystis','','paridis','','','',NULL,'Thüm.','','','','','Unger','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0417fba8-fbd3-4912-93a7-8bf66363ead5','','','Psychodocha campbellica (Quate, 1964)',1,'Psychodocha campbellica','Psychodocha campbellica','Psychodocha campbellic',2,0,'','','Quate','14f393af-8d4c-5805-8b15-207aabd51c9c','Psychodocha campbellica (Quate, 1964)','(Quate, 1964)','SPECIES','','Psychodocha','','campbellica','','','',NULL,'','','','','','Quate','','','','1964','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('041bc767-7366-4542-80b9-d4e78c7f24b0','','','Carex imbecilla K.A.Ford',1,'Carex imbecilla','Carex imbecilla','Carex imbecill',2,0,'','','K. A. Ford','06118d19-b291-5e9f-85ac-d194d28c544b','Carex imbecilla K.A.Ford','K.A.Ford','SPECIES','','Carex','','imbecilla','','','',NULL,'','','','','','K. A. Ford','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('041c05d4-7867-4990-9681-f8d52d38d509','','','Netrium',1,'Netrium','Netrium','Netrium',1,0,'','','','ae956226-e460-5af8-979f-03ea2fad7c61','Netrium','','GENUS','Netrium','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('042a715e-350a-4658-aa40-0470f3048c89','','','Tuberculatus annulatus (Hartig, 1841)',1,'Tuberculatus annulatus','Tuberculatus annulatus','Tuberculatus annulat',2,0,'','','Hartig','3249c987-5493-5360-8645-681a940a704e','Tuberculatus annulatus (Hartig, 1841)','(Hartig, 1841)','SPECIES','','Tuberculatus','','annulatus','','','',NULL,'','','','','','Hartig','','','','1841','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04274565-d0b6-470d-81a8-5e505026926b','','','Gymnopus impudicus (Fr.) Antonín, Halling & Noordel.',1,'Gymnopus impudicus','Gymnopus impudicus','Gymnopus impudic',2,0,'','','Fr.|Antonín|Halling|Noordel.','44107c1b-45f3-526a-aef1-9e29e88a4952','Gymnopus impudicus (Fr.) Antonín, Halling & Noordel.','(Fr.) Antonín, Halling & Noordel.','SPECIES','','Gymnopus','','impudicus','','','',NULL,'Antonín, Halling & Noordel.','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('042aa68f-346e-42df-ae2a-ccee004ffd7a','','','Holcaspis falcis Butcher, 1984',1,'Holcaspis falcis','Holcaspis falcis','Holcaspis falc',2,0,'','','Butcher','c744e2cd-7598-5dbe-afe6-3655557d72e4','Holcaspis falcis Butcher, 1984','Butcher, 1984','SPECIES','','Holcaspis','','falcis','','','',NULL,'','','','','','Butcher','','','','1984','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04249192-412e-451b-951c-f6e49e36860d','','','Alcaliginaceae',1,'Alcaliginaceae','Alcaliginaceae','Alcaliginaceae',1,0,'','','','923dce07-05af-518a-a847-241e95c312c3','Alcaliginaceae','','FAMILY','Alcaliginaceae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('042c147b-f045-40f4-8007-50d60d1738a5','','','Pucciniastrum circaeae (Schumach.) Speg.',1,'Pucciniastrum circaeae','Pucciniastrum circaeae','Pucciniastrum circae',2,0,'','','Schumach.|Speg.','d5ed1337-aff6-5de7-971f-a526ab5ac775','Pucciniastrum circaeae (Schumach.) Speg.','(Schumach.) Speg.','SPECIES','','Pucciniastrum','','circaeae','','','',NULL,'Speg.','','','','','Schumach.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04324df6-f6a9-4e24-987e-78c9a46f21e6','','','Brachyolus breviusculus (Broun, 1880)',1,'Brachyolus breviusculus','Brachyolus breviusculus','Brachyolus breuiuscul',2,0,'','','Broun','97d101e5-b82f-582a-b463-f9f208c2fd53','Brachyolus breviusculus (Broun, 1880)','(Broun, 1880)','SPECIES','','Brachyolus','','breviusculus','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('042c757d-9d1f-486c-b9cc-f44b1b33def5','','','Xiphoides vacans Eyles & Schuh, 2003',1,'Xiphoides vacans','Xiphoides vacans','Xiphoides uacans',2,0,'','','Eyles|Schuh','904977ef-607b-5525-a48b-ed54f2e55bd3','Xiphoides vacans Eyles & Schuh, 2003','Eyles & Schuh, 2003','SPECIES','','Xiphoides','','vacans','','','',NULL,'','','','','','Eyles & Schuh','','','','2003','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04396249-15d5-42b4-8507-1bc5853fbf17','','','Polyschides',1,'Polyschides','Polyschides','Polyschides',1,0,'','','','28e8f743-977e-57ed-bae2-335efa0801e5','Polyschides','','GENUS','Polyschides','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0436bb21-bbf4-47a5-a8c6-568d982a1e46','','','Cucurbita citrullus L.',1,'Cucurbita citrullus','Cucurbita citrullus','Cucurbita citrull',2,0,'','','L.','365ef8d1-9d6d-5cf6-8aec-b11662e9078e','Cucurbita citrullus L.','L.','SPECIES','','Cucurbita','','citrullus','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04389e74-0725-409a-aee5-cd181e8be035','','','Ramalina australiensis Nyl.',1,'Ramalina australiensis','Ramalina australiensis','Ramalina australiens',2,0,'','','Nyl.','9fb4c009-2925-5d42-9ffe-895b7e826a0d','Ramalina australiensis Nyl.','Nyl.','SPECIES','','Ramalina','','australiensis','','','',NULL,'','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0437325f-4d09-467a-88ea-f3a92c90e590','','','Physma A.Massal.',1,'Physma','Physma','Physma',1,0,'','','A. Massal.','5d8d4c62-8e01-58f4-93e4-e5d6b9448b1a','Physma A.Massal.','A.Massal.','GENUS','Physma','','','','','','',NULL,'','','','','','A. Massal.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('043f01d4-e048-41a5-862e-69a1aa62110c','','','Nakazawaea Y. Yamada, K. Maeda & Mikata',1,'Nakazawaea','Nakazawaea','Nakazawaea',1,0,'','','Y. Yamada|K. Maeda|Mikata','f71b9871-ce56-5f4b-9916-b796734caf81','Nakazawaea Y. Yamada, K. Maeda & Mikata','Y. Yamada, K. Maeda & Mikata','GENUS','Nakazawaea','','','','','','',NULL,'','','','','','Y. Yamada, K. Maeda & Mikata','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04401950-d2e3-43b7-95ed-b7bbbea81039','','','Xylodon magnificus (Gresl. & Rajchenb.) K.H. Larss.',1,'Xylodon magnificus','Xylodon magnificus','Xylodon magnific',2,0,'','','Gresl.|Rajchenb.|K. H. Larss.','6fa53a81-2acf-57c8-855b-c1dd7a32d8ce','Xylodon magnificus (Gresl. & Rajchenb.) K.H. Larss.','(Gresl. & Rajchenb.) K.H. Larss.','SPECIES','','Xylodon','','magnificus','','','',NULL,'K. H. Larss.','','','','','Gresl. & Rajchenb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04494317-a44d-408c-bae5-2e6569593365','','','Aecidium atractylidis Dietel',1,'Aecidium atractylidis','Aecidium atractylidis','Aecidium atractylid',2,0,'','','Dietel','c7998f44-d869-5342-8e9c-0d8c3c2c7a08','Aecidium atractylidis Dietel','Dietel','SPECIES','','Aecidium','','atractylidis','','','',NULL,'','','','','','Dietel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('044612a9-bce8-4ee5-a40b-61c080e52ebf','','','Planotortrix syntona syntona Meyrick, 1909',1,'Planotortrix syntona syntona','Planotortrix syntona syntona','Planotortrix synton synton',3,0,'','','Meyrick','40af5c9e-5c62-54f6-8dbc-92b1d22650ac','Planotortrix syntona syntona Meyrick, 1909','Meyrick, 1909','SUBSPECIES','','Planotortrix','','syntona','syntona','','',NULL,'','','','','','Meyrick','','','','1909','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('044804c7-b66b-4189-b268-c304fcad909a','','','Eupines (Eupines) grata (Sharp, 1874)',1,'Eupines grata','Eupines grata','Eupines grat',2,0,'','','Sharp','b2d551b1-d378-500d-a3cc-7aee4c7fc1e8','Eupines (Eupines) grata (Sharp, 1874)','(Sharp, 1874)','SPECIES','','Eupines','Eupines','grata','','','',NULL,'','','','','','Sharp','','','','1874','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0446dfda-87ef-4da3-abf6-ff13d852ac08','','','Trochila astragali Rehm',1,'Trochila astragali','Trochila astragali','Trochila astragal',2,0,'','','Rehm','9ecfe5e3-9474-5fe1-9e2f-6a597d3ca3df','Trochila astragali Rehm','Rehm','SPECIES','','Trochila','','astragali','','','',NULL,'','','','','','Rehm','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('04506c30-83fe-43de-891f-27b6fa54d94f','','','Schizochitonidae',1,'Schizochitonidae','Schizochitonidae','Schizochitonidae',1,0,'','','','f31329f2-f81b-54ae-bbc5-e51859905b24','Schizochitonidae','','FAMILY','Schizochitonidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('044ebe7c-bd53-4d77-8a3c-8423da2720e2','','','Zelleromyces Singer & A.H. Sm.',1,'Zelleromyces','Zelleromyces','Zelleromyces',1,0,'','','Singer|A. H. Sm.','e07feefe-7c19-53ba-acc1-b3e048c0f5c6','Zelleromyces Singer & A.H. Sm.','Singer & A.H. Sm.','GENUS','Zelleromyces','','','','','','',NULL,'','','','','','Singer & A. H. Sm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('044a8bfa-886c-4266-bb63-afa993f1e312','','','Jovellana sinclairii (Hook.) Kraenzl.',1,'Jovellana sinclairii','Jovellana sinclairii','Jovellana sinclair',2,0,'','','Hook.|Kraenzl.','75b6013f-224d-5f4a-9518-cdfab0e475ca','Jovellana sinclairii (Hook.) Kraenzl.','(Hook.) Kraenzl.','SPECIES','','Jovellana','','sinclairii','','','',NULL,'Kraenzl.','','','','','Hook.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0454c799-9cb3-4f2f-b211-00deeec86907','','','Epsilonema dentatum',1,'Epsilonema dentatum','Epsilonema dentatum','Epsilonema dentat',2,0,'','','','0c4b5e79-9bdb-58af-8b75-ce3a48e8906e','Epsilonema dentatum','','SPECIES','','Epsilonema','','dentatum','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0451f878-e1e2-4e66-b084-1f5e7fcc0ebf','','','Aorangia pilgrimi Forster & Wilton, 1973',1,'Aorangia pilgrimi','Aorangia pilgrimi','Aorangia pilgrim',2,0,'','','Forster|Wilton','852bc7e8-ddba-508e-93a1-03c89ba6dbe1','Aorangia pilgrimi Forster & Wilton, 1973','Forster & Wilton, 1973','SPECIES','','Aorangia','','pilgrimi','','','',NULL,'','','','','','Forster & Wilton','','','','1973','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('045429c0-f3ba-41d1-8cc9-850f086e81a7','','','Penzigia species',4,'','','',NULL,NULL,'','','','','Penzigia species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0452d313-96be-42e2-b79c-8cdba4d6b19d','','','Apple russet ring',1,'Apple russet ring','Apple russet ring','Apple russet ring',3,0,'','','','c0d4af45-b988-58b3-8a44-cda9d9a36be9','Apple russet ring','','SPECIES','','Apple','','russet','ring','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0450a016-8751-45ea-abbd-a0c12c9419e0','','','Gelophaula Meyrick, 1923',1,'Gelophaula','Gelophaula','Gelophaula',1,0,'','','Meyrick','d22ab641-7190-5bc4-b795-f3ac2f8e15cd','Gelophaula Meyrick, 1923','Meyrick, 1923','GENUS','Gelophaula','','','','','','',NULL,'','','','','','Meyrick','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0378b2db-8df3-4229-a7b1-f83b50a65b9b','','','Proscissio albiceps Malloch, 1938',1,'Proscissio albiceps','Proscissio albiceps','Proscissio albiceps',2,0,'','','Malloch','f2334be4-8d04-55d6-b454-287925f4b5bd','Proscissio albiceps Malloch, 1938','Malloch, 1938','SPECIES','','Proscissio','','albiceps','','','',NULL,'','','','','','Malloch','','','','1938','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0378f2f9-213a-419e-bd8a-2bc8ba443016','','','Hypoxylon nummularium Bull.',1,'Hypoxylon nummularium','Hypoxylon nummularium','Hypoxylon nummulari',2,0,'','','Bull.','7c6aaebc-684b-542e-801c-26a4ea9dac93','Hypoxylon nummularium Bull.','Bull.','SPECIES','','Hypoxylon','','nummularium','','','',NULL,'','','','','','Bull.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('037e4fd1-6b32-4b6d-9d08-4b561416c4a0','','','Rosisphaerella Videira & Crous',1,'Rosisphaerella','Rosisphaerella','Rosisphaerella',1,0,'','','Videira|Crous','1cd6c744-483e-5f5a-b348-e9c5bb7ea166','Rosisphaerella Videira & Crous','Videira & Crous','GENUS','Rosisphaerella','','','','','','',NULL,'','','','','','Videira & Crous','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('037ce13b-defb-437a-87b4-ce3ca90e04f5','','','Hirsutella species',4,'','','',NULL,NULL,'','','','','Hirsutella species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('037a65cd-5fc4-4281-9d3a-ea7543913832','','','Gloeosporium betulae (Lib.) J. Kickx f.',1,'Gloeosporium betulae','Gloeosporium betulae','Gloeosporium betul',2,0,'','','Lib.|J. Kickx fil.','0d331cd9-f38f-58a6-a6bf-c5e12fd45d52','Gloeosporium betulae (Lib.) J. Kickx f.','(Lib.) J. Kickx f.','SPECIES','','Gloeosporium','','betulae','','','',NULL,'J. Kickx fil.','','','','','Lib.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0381d17d-67b7-419f-93f2-1ce18c58bb87','','','Weraroa virescens (Massee) Singer & A.H. Sm.',1,'Weraroa virescens','Weraroa virescens','Weraroa uirescens',2,0,'','','Massee|Singer|A. H. Sm.','194460e6-e5b7-5276-b09a-c81d8f29d42d','Weraroa virescens (Massee) Singer & A.H. Sm.','(Massee) Singer & A.H. Sm.','SPECIES','','Weraroa','','virescens','','','',NULL,'Singer & A. H. Sm.','','','','','Massee','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0382d9de-e4f8-4e9e-ac8e-7c4cae88b824','','','Conchomyces bursiformis (Berk.) E. Horak',1,'Conchomyces bursiformis','Conchomyces bursiformis','Conchomyces bursiform',2,0,'','','Berk.|E. Horak','95df7784-c678-5715-83e1-5bc2c7a8127b','Conchomyces bursiformis (Berk.) E. Horak','(Berk.) E. Horak','SPECIES','','Conchomyces','','bursiformis','','','',NULL,'E. Horak','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03855935-28b1-4717-83ce-b8324c16e7f8','','','Tulostoma cyclophorum Lloyd',1,'Tulostoma cyclophorum','Tulostoma cyclophorum','Tulostoma cyclophor',2,0,'','','Lloyd','4efdc32e-f0a8-55f6-ab48-da84bcafc9fe','Tulostoma cyclophorum Lloyd','Lloyd','SPECIES','','Tulostoma','','cyclophorum','','','',NULL,'','','','','','Lloyd','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03850fa2-d715-48db-8e9b-d182014bb659','','','Coprosma retusa Hook.f.',1,'Coprosma retusa','Coprosma retusa','Coprosma retus',2,0,'','','Hook. fil.','2b85720e-f1f4-54d5-9e86-5ecb86164d0e','Coprosma retusa Hook.f.','Hook.f.','SPECIES','','Coprosma','','retusa','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0384515d-2e79-48ac-9db7-f7f2ef0807c0','','','Isocladus reconditus Hurley & Jansen, 1977',1,'Isocladus reconditus','Isocladus reconditus','Isocladus recondit',2,0,'','','Hurley|Jansen','99a2d90c-d676-5f41-bae3-2b2196c4fdb2','Isocladus reconditus Hurley & Jansen, 1977','Hurley & Jansen, 1977','SPECIES','','Isocladus','','reconditus','','','',NULL,'','','','','','Hurley & Jansen','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('038bca64-1023-4e99-9cf9-529d8ab6aeaa','','','Franzpetrakia Thirum. & Pavgi',1,'Franzpetrakia','Franzpetrakia','Franzpetrakia',1,0,'','','Thirum.|Pavgi','70c45b0c-cf29-58bb-8c87-67df99e12d19','Franzpetrakia Thirum. & Pavgi','Thirum. & Pavgi','GENUS','Franzpetrakia','','','','','','',NULL,'','','','','','Thirum. & Pavgi','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('038dd95e-f26f-4a1a-9b4b-a8102af05d9f','','','Gautieria queenslandica J.W. Cribb',1,'Gautieria queenslandica','Gautieria queenslandica','Gautieria queenslandic',2,0,'','','J. W. Cribb','51571c39-d8a6-58ce-a5be-cc47e1ce6a84','Gautieria queenslandica J.W. Cribb','J.W. Cribb','SPECIES','','Gautieria','','queenslandica','','','',NULL,'','','','','','J. W. Cribb','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0394e44b-0969-4e7d-a3c8-08fafddb0786','','','Phthorimaea Meyrick, 1902',1,'Phthorimaea','Phthorimaea','Phthorimaea',1,0,'','','Meyrick','84b39ddf-1f0d-5843-8906-19db2a2ff72d','Phthorimaea Meyrick, 1902','Meyrick, 1902','GENUS','Phthorimaea','','','','','','',NULL,'','','','','','Meyrick','','','','1902','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('038f6db1-dc22-4c69-adf7-4a638e225f2f','','','Metrosideros albiflora Sol. ex Gaertn.',1,'Metrosideros albiflora','Metrosideros albiflora','Metrosideros albiflor',2,0,'','','Sol.|Gaertn.','25c24366-c14a-5508-bf8f-e16396cac318','Metrosideros albiflora Sol. ex Gaertn.','Sol. ex Gaertn.','SPECIES','','Metrosideros','','albiflora','','','',NULL,'','','','','','Sol.','','Gaertn.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0395f3db-21ea-41a2-93e7-bffe9172e9be','','','Glyphothecium pangerangense M.Fleisch.',1,'Glyphothecium pangerangense','Glyphothecium pangerangense','Glyphothecium pangerangens',2,0,'','','M. Fleisch.','6f48dcc0-cf67-5196-9b0f-a7a00ea94eda','Glyphothecium pangerangense M.Fleisch.','M.Fleisch.','SPECIES','','Glyphothecium','','pangerangense','','','',NULL,'','','','','','M. Fleisch.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('039b7630-7d06-4b90-accf-00062765143e','','','Xuthodes batesi Sharp, 1877',1,'Xuthodes batesi','Xuthodes batesi','Xuthodes bates',2,0,'','','Sharp','08cf7a30-02ca-57b8-8dfe-d3cdf4696e57','Xuthodes batesi Sharp, 1877','Sharp, 1877','SPECIES','','Xuthodes','','batesi','','','',NULL,'','','','','','Sharp','','','','1877','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('039acc6b-0ed2-4192-b028-298f57a05abd','','','Farysia subolivacea (Henn.) Cif.',1,'Farysia subolivacea','Farysia subolivacea','Farysia suboliuace',2,0,'','','Henn.|Cif.','75f2e670-327e-51ee-a034-331b0791f724','Farysia subolivacea (Henn.) Cif.','(Henn.) Cif.','SPECIES','','Farysia','','subolivacea','','','',NULL,'Cif.','','','','','Henn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('039afb8b-334c-4aec-81f3-707b720eb092','','','Schizaea propinqua A.Cunn.',1,'Schizaea propinqua','Schizaea propinqua','Schizaea propinqu',2,0,'','','A. Cunn.','9110f076-1990-5047-bbc3-c02cf9253ec8','Schizaea propinqua A.Cunn.','A.Cunn.','SPECIES','','Schizaea','','propinqua','','','',NULL,'','','','','','A. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('039bacd2-2c81-453e-9574-bf181820b1ed','','','Hyadesia zelandica Luxton, 1984',1,'Hyadesia zelandica','Hyadesia zelandica','Hyadesia zelandic',2,0,'','','Luxton','d8e28589-d508-5d40-83ae-fa4f4ec71e3c','Hyadesia zelandica Luxton, 1984','Luxton, 1984','SPECIES','','Hyadesia','','zelandica','','','',NULL,'','','','','','Luxton','','','','1984','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('039e6f6b-f123-4aef-9066-45270c6737ab','','','Kirkophytum lyallii (J.B.Armstr.) Allan',1,'Kirkophytum lyallii','Kirkophytum lyallii','Kirkophytum lyall',2,0,'','','J. B. Armstr.|Allan','8ffc9c7a-ce1a-5788-99f6-9d85743cb5bf','Kirkophytum lyallii (J.B.Armstr.) Allan','(J.B.Armstr.) Allan','SPECIES','','Kirkophytum','','lyallii','','','',NULL,'Allan','','','','','J. B. Armstr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('039e03d2-3a54-4351-98dc-df1de07b9c21','','','Provocator mirabilis (Finlay, 1926)',1,'Provocator mirabilis','Provocator mirabilis','Provocator mirabil',2,0,'','','Finlay','63bca02d-0c7f-5b19-92ce-52f959a6283b','Provocator mirabilis (Finlay, 1926)','(Finlay, 1926)','SPECIES','','Provocator','','mirabilis','','','',NULL,'','','','','','Finlay','','','','1926','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('039d866a-790b-47a6-8b4d-f77324fd49c9','','','Schizospora Dietel',1,'Schizospora','Schizospora','Schizospora',1,0,'','','Dietel','84cc28f9-9198-534e-ab75-cdb1d4a9d5b7','Schizospora Dietel','Dietel','GENUS','Schizospora','','','','','','',NULL,'','','','','','Dietel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03a76651-e0a0-4db1-b22f-3e36b7801f84','','','Coelosphaerium kuetzingianum Nägeli',1,'Coelosphaerium kuetzingianum','Coelosphaerium kuetzingianum','Coelosphaerium kuetzingian',2,0,'','','Nägeli','66de6b5f-d9eb-56df-a433-c47cf13f4dc0','Coelosphaerium kuetzingianum Nägeli','Nägeli','SPECIES','','Coelosphaerium','','kuetzingianum','','','',NULL,'','','','','','Nägeli','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03a71a21-e92e-439a-bb35-899b4b31a1ee','','','Anthracocystis lophopogonis (Thirum. & Pavgi) McTaggart & R.G. Shivas',1,'Anthracocystis lophopogonis','Anthracocystis lophopogonis','Anthracocystis lophopogon',2,0,'','','Thirum.|Pavgi|McTaggart|R. G. Shivas','0a578822-720f-5377-a80e-b952018c5b8c','Anthracocystis lophopogonis (Thirum. & Pavgi) McTaggart & R.G. Shivas','(Thirum. & Pavgi) McTaggart & R.G. Shivas','SPECIES','','Anthracocystis','','lophopogonis','','','',NULL,'McTaggart & R. G. Shivas','','','','','Thirum. & Pavgi','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03a4eb46-3ca2-46e9-8797-f2cb29516fe9','','','Puccinia hyalina Dietel',1,'Puccinia hyalina','Puccinia hyalina','Puccinia hyalin',2,0,'','','Dietel','bd84dc26-7e8f-5293-aebd-d7134a92e796','Puccinia hyalina Dietel','Dietel','SPECIES','','Puccinia','','hyalina','','','',NULL,'','','','','','Dietel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03b165af-07eb-43cd-ab01-0a98f2a22be7','','','Oxychilus subg. Oxychilus',2,'Oxychilus','Oxychilus subgen. Oxychilus','Oxychilus',1,0,'','','','0de88e9b-88cb-55f9-849c-5d63ee02c333','Oxychilus subg. Oxychilus','','SUBGENUS','Oxychilus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03b0751c-d874-4620-98bb-205003f27776','','','Artamus personatus (Gould, 1841)',1,'Artamus personatus','Artamus personatus','Artamus personat',2,0,'','','Gould','edd2dc6e-0f8a-519a-bb1c-584116a9249d','Artamus personatus (Gould, 1841)','(Gould, 1841)','SPECIES','','Artamus','','personatus','','','',NULL,'','','','','','Gould','','','','1841','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03b18391-995f-4de0-be58-72ec5fdc6abe','','','Linospadix H.Wendl.',1,'Linospadix','Linospadix','Linospadix',1,0,'','','H. Wendl.','7d765f85-6277-56dc-be20-fe02f3ae9e20','Linospadix H.Wendl.','H.Wendl.','GENUS','Linospadix','','','','','','',NULL,'','','','','','H. Wendl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03ace794-9420-4a20-85ad-c6e5b0ad64b3','','','Trichostomum falcatum R.Br.bis',1,'Trichostomum falcatum','Trichostomum falcatum','Trichostomum falcat',2,0,'','','R. Br. bis','254cdfba-5f6a-5b7b-b3ef-f0ede783551b','Trichostomum falcatum R.Br.bis','R.Br.bis','SPECIES','','Trichostomum','','falcatum','','','',NULL,'','','','','','R. Br. bis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03b670ce-3377-44a3-9071-056b4dd6d905','','','Helminthosporium balladynae Hansf.',1,'Helminthosporium balladynae','Helminthosporium balladynae','Helminthosporium balladyn',2,0,'','','Hansf.','5d41c790-35d8-5673-92df-5cb3685ec2ae','Helminthosporium balladynae Hansf.','Hansf.','SPECIES','','Helminthosporium','','balladynae','','','',NULL,'','','','','','Hansf.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03b242a7-4770-4554-8793-5747e6626b8e','','','Pamera nigriceps (Dallas, 1852)',1,'Pamera nigriceps','Pamera nigriceps','Pamera nigriceps',2,0,'','','Dallas','2520bfad-7236-52a9-9b10-da5fafc086f1','Pamera nigriceps (Dallas, 1852)','(Dallas, 1852)','SPECIES','','Pamera','','nigriceps','','','',NULL,'','','','','','Dallas','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03b6b2fd-273a-4165-bf27-b67e19de62f8','','','Camarosporium aequivocum (Pass.) Sacc.',1,'Camarosporium aequivocum','Camarosporium aequivocum','Camarosporium aequiuoc',2,0,'','','Pass.|Sacc.','f2a9e274-42f8-5792-a82a-9747acbb8f56','Camarosporium aequivocum (Pass.) Sacc.','(Pass.) Sacc.','SPECIES','','Camarosporium','','aequivocum','','','',NULL,'Sacc.','','','','','Pass.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03b7b768-dbb6-413b-a2ee-644a62c1f9ee','','','Eupelte regalis Hicks, 1971',1,'Eupelte regalis','Eupelte regalis','Eupelte regal',2,0,'','','Hicks','4a8d8951-daf8-50fd-993a-e6f83fe7f02c','Eupelte regalis Hicks, 1971','Hicks, 1971','SPECIES','','Eupelte','','regalis','','','',NULL,'','','','','','Hicks','','','','1971','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('03bc5db6-0558-419f-aa04-d3c86b71f0ba','','','Cholevinae',1,'Cholevinae','Cholevinae','Cholevinae',1,0,'','','','611ac8c9-d3dd-5937-8b68-254ddc6dc97a','Cholevinae','','SUBFAMILY','Cholevinae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('065f51d9-2e94-4d76-a18f-ded5551676bd','','','Zecillenus albescens (Bates, 1878)',1,'Zecillenus albescens','Zecillenus albescens','Zecillenus albescens',2,0,'','','Bates','8c5d5854-df6e-56e1-9114-cabd054a1d6c','Zecillenus albescens (Bates, 1878)','(Bates, 1878)','SPECIES','','Zecillenus','','albescens','','','',NULL,'','','','','','Bates','','','','1878','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06663dd8-cd8f-4926-85e5-1a7e03d64691','','','Portulaca pilosa subsp. decipiens (Poelln.) Geesink',1,'Portulaca pilosa decipiens','Portulaca pilosa subsp. decipiens','Portulaca pilos decipiens',3,0,'','','Poelln.|Geesink','50aad4d6-96a0-5707-bc17-f4f630cec693','Portulaca pilosa subsp. decipiens (Poelln.) Geesink','(Poelln.) Geesink','SUBSPECIES','','Portulaca','','pilosa','decipiens','','',NULL,'Geesink','','','','','Poelln.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06612a11-ef5e-4ccf-9d7f-3bf6b719951e','','','Myriogyne elatinoides Less.',1,'Myriogyne elatinoides','Myriogyne elatinoides','Myriogyne elatinoid',2,0,'','','Less.','71ac1b49-9c98-5958-9857-9346860ccfb3','Myriogyne elatinoides Less.','Less.','SPECIES','','Myriogyne','','elatinoides','','','',NULL,'','','','','','Less.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0665003d-1531-41d2-8b0a-af486f572b57','','','Crepidotus fuscus E. Horak',1,'Crepidotus fuscus','Crepidotus fuscus','Crepidotus fusc',2,0,'','','E. Horak','029f4007-cd42-5c13-91a6-18441ddc66c1','Crepidotus fuscus E. Horak','E. Horak','SPECIES','','Crepidotus','','fuscus','','','',NULL,'','','','','','E. Horak','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('066b928a-b5b8-4e39-8e79-2151a02b7886','','','Spirozonidae',1,'Spirozonidae','Spirozonidae','Spirozonidae',1,0,'','','','4cdee875-9cf6-5716-9a14-95678051de5e','Spirozonidae','','FAMILY','Spirozonidae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('066a3082-3480-4356-b9de-2cc7ee967f47','','','Oriopsis limbata (Ehlers, 1897)',1,'Oriopsis limbata','Oriopsis limbata','Oriopsis limbat',2,0,'','','Ehlers','08952344-cdd1-5f31-b9f3-8ca7b5a0ec0c','Oriopsis limbata (Ehlers, 1897)','(Ehlers, 1897)','SPECIES','','Oriopsis','','limbata','','','',NULL,'','','','','','Ehlers','','','','1897','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('067219d0-16ba-47ca-9b3c-a115049ee599','','','Truncospora ohiensis (Berk.) Pilát',1,'Truncospora ohiensis','Truncospora ohiensis','Truncospora ohiens',2,0,'','','Berk.|Pilát','f7a00171-03fe-5650-9d01-3e8cedbe53c4','Truncospora ohiensis (Berk.) Pilát','(Berk.) Pilát','SPECIES','','Truncospora','','ohiensis','','','',NULL,'Pilát','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0674aab2-e556-45b2-ba8b-0184a6c65035','','','Feronia politissima White, 1846',1,'Feronia politissima','Feronia politissima','Feronia politissim',2,0,'','','White','6b89ee5e-9440-5336-91ec-3076b4bee8eb','Feronia politissima White, 1846','White, 1846','SPECIES','','Feronia','','politissima','','','',NULL,'','','','','','White','','','','1846','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0672504f-67c9-4ff9-8f81-38e2387b11cd','','','Hoheria angustifolia Raoul × Hoheria sexstylosa Colenso',2,'Hoheria angustifolia × Hoheria sexstylosa','Hoheria angustifolia × Hoheria sexstylosa','Hoheria angustifol × Hoheria sexstylos',0,0,'HYBRID_FORMULA','','','fc9cb30e-bcb0-5a7f-8810-7cc14ffb4f89','Hoheria angustifolia Raoul × Hoheria sexstylosa Colenso','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06741c2d-f09c-46ca-b46d-90740f26df4c','','','Melicytus (Mt. Burnett)',1,'Melicytus','Melicytus','Melicytus',1,0,'','','Mt. Burnett','48728f3f-cc48-57f6-a44a-a384e1bfc62d','Melicytus (Mt. Burnett)','(Mt. Burnett)','SPECIES','Melicytus','','','','','','',NULL,'','','','','','Mt. Burnett','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0673a522-d9a6-47bf-a4b3-c8f90650bbce','','','Puccinia uliginosa Juel',1,'Puccinia uliginosa','Puccinia uliginosa','Puccinia uliginos',2,0,'','','Juel','1e152b15-09b1-535b-88d6-37ccc3f8a249','Puccinia uliginosa Juel','Juel','SPECIES','','Puccinia','','uliginosa','','','',NULL,'','','','','','Juel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0681a22b-ee59-4333-8f4c-02c40173b731','','','Coriolus flabelliformis (Fr.) G. Cunn.',1,'Coriolus flabelliformis','Coriolus flabelliformis','Coriolus flabelliform',2,0,'','','Fr.|G. Cunn.','e279994e-878d-56c7-a6e2-789cfdb0c73f','Coriolus flabelliformis (Fr.) G. Cunn.','(Fr.) G. Cunn.','SPECIES','','Coriolus','','flabelliformis','','','',NULL,'G. Cunn.','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('067f81c2-1180-42c9-930b-558a53eae6ac','','','Cypraea moneta Linnaeus, 1758',1,'Cypraea moneta','Cypraea moneta','Cypraea monet',2,0,'','','Linnaeus','dc88da11-e3f6-5789-a045-bfb63a916254','Cypraea moneta Linnaeus, 1758','Linnaeus, 1758','SPECIES','','Cypraea','','moneta','','','',NULL,'','','','','','Linnaeus','','','','1758','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('067e5cd5-788f-47b8-95ce-9dc582c05388','','','Pinguicula alpina L.',1,'Pinguicula alpina','Pinguicula alpina','Pinguicula alpin',2,0,'','','L.','d2de36c3-9ba2-5fee-8cad-1f596dbe9be3','Pinguicula alpina L.','L.','SPECIES','','Pinguicula','','alpina','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('067adf72-0836-41b7-bf4b-f326a699abb9','','','Cercospora apii Fresen.',1,'Cercospora apii','Cercospora apii','Cercospora ap',2,0,'','','Fresen.','6b7bd00f-3c8e-5b76-bc48-1987fa4a8c10','Cercospora apii Fresen.','Fresen.','SPECIES','','Cercospora','','apii','','','',NULL,'','','','','','Fresen.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('067e5e26-3c41-4ec1-a58e-fb0fe36866e1','','','Rumex sanguineus var. viridis Sibth.',1,'Rumex sanguineus viridis','Rumex sanguineus var. viridis','Rumex sanguine uirid',3,0,'','','Sibth.','8e3bb8c8-c9aa-5f03-a856-4c6038cffcf8','Rumex sanguineus var. viridis Sibth.','Sibth.','VARIETY','','Rumex','','sanguineus','viridis','','',NULL,'','','','','','Sibth.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06877975-9342-45f9-8ef8-493a81180728','','','Pterostylis brumalis L.B.Moore',1,'Pterostylis brumalis','Pterostylis brumalis','Pterostylis brumal',2,0,'','','L. B. Moore','020f6689-57df-5e21-b363-748b56376ead','Pterostylis brumalis L.B.Moore','L.B.Moore','SPECIES','','Pterostylis','','brumalis','','','',NULL,'','','','','','L. B. Moore','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06878298-ec5d-468c-93b5-cd486f7d7972','','','Botryodiplodia (Sacc.) Sacc.',1,'Botryodiplodia','Botryodiplodia','Botryodiplodia',1,0,'','','Sacc.','c77edb64-4d0d-5385-a738-251154955685','Botryodiplodia (Sacc.) Sacc.','(Sacc.) Sacc.','GENUS','Botryodiplodia','','','','','','',NULL,'Sacc.','','','','','Sacc.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0686cce8-d9c6-461f-b3db-fc385b1f69a8','','','Leptoscyphus excipulatus var. canaliculatus J.J.Engel',1,'Leptoscyphus excipulatus canaliculatus','Leptoscyphus excipulatus var. canaliculatus','Leptoscyphus excipulat canaliculat',3,0,'','','J. J. Engel','0d1afd18-f975-5207-9d4c-a76b66e6f1d8','Leptoscyphus excipulatus var. canaliculatus J.J.Engel','J.J.Engel','VARIETY','','Leptoscyphus','','excipulatus','canaliculatus','','',NULL,'','','','','','J. J. Engel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0690aec6-8e38-4836-a56f-604b01a86263','','','Gloeosporium salicis Westend.',1,'Gloeosporium salicis','Gloeosporium salicis','Gloeosporium salic',2,0,'','','Westend.','0414fb73-096c-5ad6-a363-1d0daa24d936','Gloeosporium salicis Westend.','Westend.','SPECIES','','Gloeosporium','','salicis','','','',NULL,'','','','','','Westend.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('068f858e-25c0-49f8-a626-99d49021e2ed','','','Eupines dispar (Sharp, 1874)',1,'Eupines dispar','Eupines dispar','Eupines dispar',2,0,'','','Sharp','9acc36f1-1719-52ea-a20a-170e046d8746','Eupines dispar (Sharp, 1874)','(Sharp, 1874)','SPECIES','','Eupines','','dispar','','','',NULL,'','','','','','Sharp','','','','1874','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('068a9289-140b-4f6a-b46b-c3c46fa9591f','','','Oligella Rossau et al. 1987',1,'Oligella','Oligella','Oligella',1,0,'','','Rossau et al.','c89bd742-34aa-5e20-aead-df1f6cb99276','Oligella Rossau et al. 1987','Rossau et al. 1987','GENUS','Oligella','','','','','','',NULL,'','','','','','Rossau et al.','','','','1987','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0691f584-5347-4f06-9487-424df408bbe6','','','Procordulia valevahalo Marinov, 2016',1,'Procordulia valevahalo','Procordulia valevahalo','Procordulia ualeuahal',2,0,'','','Marinov','6dfbf29c-ae42-5872-9ce5-d423d6e28f7b','Procordulia valevahalo Marinov, 2016','Marinov, 2016','SPECIES','','Procordulia','','valevahalo','','','',NULL,'','','','','','Marinov','','','','2016','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06991d59-2b21-402c-99e3-6a255f915036','','','Zelandanura',1,'Zelandanura','Zelandanura','Zelandanura',1,0,'','','','5669a490-bc5d-5689-b75b-fe6ab0e09207','Zelandanura','','GENUS','Zelandanura','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06950711-840b-4a9d-9515-9df9b756f10b','','','Closterium compactum Nordst.',1,'Closterium compactum','Closterium compactum','Closterium compact',2,0,'','','Nordst.','de62ff4d-e0ea-51d0-9f18-e2da9024d571','Closterium compactum Nordst.','Nordst.','SPECIES','','Closterium','','compactum','','','',NULL,'','','','','','Nordst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0699be7f-f729-4b44-ab53-d527cafa265f','','','Austroparmelina pseudorelicina (Jatta) A.Crespo, Divakar & Elix',1,'Austroparmelina pseudorelicina','Austroparmelina pseudorelicina','Austroparmelina pseudorelicin',2,0,'','','Jatta|A. Crespo|Divakar|Elix','e5db43c9-5b6c-5856-ab4f-50ed15c7efc8','Austroparmelina pseudorelicina (Jatta) A.Crespo, Divakar & Elix','(Jatta) A.Crespo, Divakar & Elix','SPECIES','','Austroparmelina','','pseudorelicina','','','',NULL,'A. Crespo, Divakar & Elix','','','','','Jatta','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('069f313f-0321-47c2-b819-4752b3183ca5','','','Rhoicosphenia genuflexa (Kützing) Medlin',1,'Rhoicosphenia genuflexa','Rhoicosphenia genuflexa','Rhoicosphenia genuflex',2,0,'','','Kützing|Medlin','175f81f6-58b0-55b4-8440-5b8bb3305805','Rhoicosphenia genuflexa (Kützing) Medlin','(Kützing) Medlin','SPECIES','','Rhoicosphenia','','genuflexa','','','',NULL,'Medlin','','','','','Kützing','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('069da711-9756-4910-8d9f-6851960478d3','','','Pseudodistichium buchananii (R.Br.bis) Dixon',1,'Pseudodistichium buchananii','Pseudodistichium buchananii','Pseudodistichium buchanan',2,0,'','','R. Br. bis|Dixon','db26e13f-943d-5ab8-820a-d51d38b6ecb0','Pseudodistichium buchananii (R.Br.bis) Dixon','(R.Br.bis) Dixon','SPECIES','','Pseudodistichium','','buchananii','','','',NULL,'Dixon','','','','','R. Br. bis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('069efac3-f421-455f-b235-a00452a84716','','','Sirococcus castaneae (Prill. & Delacr.) J.B. Mey., Senn-Irlet & T.N. Sieber',1,'Sirococcus castaneae','Sirococcus castaneae','Sirococcus castane',2,0,'','','Prill.|Delacr.|J. B. Mey.|Senn-Irlet|T. N. Sieber','57d14aa4-ce94-5dfb-b2b5-caa8f6535124','Sirococcus castaneae (Prill. & Delacr.) J.B. Mey., Senn-Irlet & T.N. Sieber','(Prill. & Delacr.) J.B. Mey., Senn-Irlet & T.N. Sieber','SPECIES','','Sirococcus','','castaneae','','','',NULL,'J. B. Mey., Senn-Irlet & T. N. Sieber','','','','','Prill. & Delacr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06a57e34-8035-4fa7-8bec-523ecffab81d','','','Dactylanthus taylorii Hook.f.',1,'Dactylanthus taylorii','Dactylanthus taylorii','Dactylanthus taylor',2,0,'','','Hook. fil.','e130ef21-cc19-5da2-9e43-99d2a70b5174','Dactylanthus taylorii Hook.f.','Hook.f.','SPECIES','','Dactylanthus','','taylorii','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06ac5ce2-b788-43e2-9c1b-852aaedb4a6d','','','Tyromyces albidus sensu G. Cunn.',4,'','','',NULL,NULL,'','','','','Tyromyces albidus sensu G. Cunn.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06abaf7d-aa84-41a3-b025-af108e26d940','','','Synacalles mundus (Broun, 1881)',1,'Synacalles mundus','Synacalles mundus','Synacalles mund',2,0,'','','Broun','cd4e841a-1a45-50e7-8074-0cc9d94bca85','Synacalles mundus (Broun, 1881)','(Broun, 1881)','SPECIES','','Synacalles','','mundus','','','',NULL,'','','','','','Broun','','','','1881','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06b1aa34-7c28-486a-abc9-326a8f98b4e4','','','Fragilaria capucina var. mesolepta (Rabenhorst) Rabenhorst',1,'Fragilaria capucina mesolepta','Fragilaria capucina var. mesolepta','Fragilaria capucin mesolept',3,0,'','','Rabenhorst','6419a580-dddc-5e28-837b-64b34cdfd767','Fragilaria capucina var. mesolepta (Rabenhorst) Rabenhorst','(Rabenhorst) Rabenhorst','VARIETY','','Fragilaria','','capucina','mesolepta','','',NULL,'Rabenhorst','','','','','Rabenhorst','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06b3d2e2-e18b-45f5-8707-7900dc1929fe','','','Rosulabryum perlimbatum (Cardot) Ochyra',1,'Rosulabryum perlimbatum','Rosulabryum perlimbatum','Rosulabryum perlimbat',2,0,'','','Cardot|Ochyra','58160f66-12bc-5741-b37a-e93aba297c04','Rosulabryum perlimbatum (Cardot) Ochyra','(Cardot) Ochyra','SPECIES','','Rosulabryum','','perlimbatum','','','',NULL,'Ochyra','','','','','Cardot','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06b60dfe-aba6-4361-b697-c9426a9633d8','','','Puccinellia stricta var. suborbicularis (Hack.) Allan & Jansen',1,'Puccinellia stricta suborbicularis','Puccinellia stricta var. suborbicularis','Puccinellia strict suborbicular',3,0,'','','Hack.|Allan|Jansen','5bd2b7ac-d50d-5de8-80df-28f4aa6de4e8','Puccinellia stricta var. suborbicularis (Hack.) Allan & Jansen','(Hack.) Allan & Jansen','VARIETY','','Puccinellia','','stricta','suborbicularis','','',NULL,'Allan & Jansen','','','','','Hack.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06b456f1-c600-4f45-acc1-f05303061cd9','','','Saulomataceae W.R.Buck, C.J.Cox, A.J.Shaw & Goffinet',1,'Saulomataceae','Saulomataceae','Saulomataceae',1,0,'','','W. R. Buck|C. J. Cox|A. J. Shaw|Goffinet','81726a24-e361-58e1-8bf7-0022a1ba51ba','Saulomataceae W.R.Buck, C.J.Cox, A.J.Shaw & Goffinet','W.R.Buck, C.J.Cox, A.J.Shaw & Goffinet','FAMILY','Saulomataceae','','','','','','',NULL,'','','','','','W. R. Buck, C. J. Cox, A. J. Shaw & Goffinet','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06b8f24e-5397-491e-bbba-5bd131400daa','','','Entomobrya',1,'Entomobrya','Entomobrya','Entomobrya',1,0,'','','','aa93095c-89ec-5072-a5fa-7ee05a4aebb8','Entomobrya','','GENUS','Entomobrya','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06bb5505-8e3a-4b1b-aa55-717d2c808b8f','','','Aphidius',1,'Aphidius','Aphidius','Aphidius',1,0,'','','','cc897488-53ac-5104-b135-1709f586a769','Aphidius','','GENUS','Aphidius','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06ba9647-0c74-4486-8867-88584a0887e2','','','Lejeunea vesiculosa Mitt.',1,'Lejeunea vesiculosa','Lejeunea vesiculosa','Lejeunea uesiculos',2,0,'','','Mitt.','8f8edfef-e626-5635-8df4-2eb6439603c7','Lejeunea vesiculosa Mitt.','Mitt.','SPECIES','','Lejeunea','','vesiculosa','','','',NULL,'','','','','','Mitt.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06bca5a3-ec27-4034-af38-caf72a91e452','','','Umbilicaria cinereorufescens (Schaer.) Frey',1,'Umbilicaria cinereorufescens','Umbilicaria cinereorufescens','Umbilicaria cinereorufescens',2,0,'','','Schaer.|Frey','6ba38fd0-635f-51e5-9cea-fa0e252358ea','Umbilicaria cinereorufescens (Schaer.) Frey','(Schaer.) Frey','SPECIES','','Umbilicaria','','cinereorufescens','','','',NULL,'Frey','','','','','Schaer.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06c21f44-8355-4b5f-b6e1-30177087011a','','','Tewara cranwellae Griffin, 1933',1,'Tewara cranwellae','Tewara cranwellae','Tewara cranwell',2,0,'','','Griffin','8021abc0-41af-5470-9ddb-bf881fdccb52','Tewara cranwellae Griffin, 1933','Griffin, 1933','SPECIES','','Tewara','','cranwellae','','','',NULL,'','','','','','Griffin','','','','1933','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06c05a8a-8375-4e5e-9122-4c44d1d733fe','','','Pterocirrus hunteri Benham, 1921',1,'Pterocirrus hunteri','Pterocirrus hunteri','Pterocirrus hunter',2,0,'','','Benham','4767bbad-2668-5564-9359-a34cb349d79c','Pterocirrus hunteri Benham, 1921','Benham, 1921','SPECIES','','Pterocirrus','','hunteri','','','',NULL,'','','','','','Benham','','','','1921','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06c624b9-31e1-4aec-81a3-85c2fbc67dcc','','','Peristoreus celmisiae (Broun, 1917)',1,'Peristoreus celmisiae','Peristoreus celmisiae','Peristoreus celmisi',2,0,'','','Broun','b6f91e19-1546-5818-87c8-16054d9f6c84','Peristoreus celmisiae (Broun, 1917)','(Broun, 1917)','SPECIES','','Peristoreus','','celmisiae','','','',NULL,'','','','','','Broun','','','','1917','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06c2f5bd-7949-4eaa-9d75-c2f806f99808','','','Viktorocara',1,'Viktorocara','Viktorocara','Viktorocara',1,0,'','','','b12c7019-bd67-554e-ad07-cbc54b810b5a','Viktorocara','','GENUS','Viktorocara','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06c0431c-448d-4e6d-a0e4-d4b03c4efc99','','','Agaricus diversipes Berk.',1,'Agaricus diversipes','Agaricus diversipes','Agaricus diuersip',2,0,'','','Berk.','f5d42847-2e43-5f35-9494-a809f7a0a621','Agaricus diversipes Berk.','Berk.','SPECIES','','Agaricus','','diversipes','','','',NULL,'','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06ca116d-a937-4777-a8d3-265ac760a358','','','Asaphodes sericodes (Meyrick, 1915)',1,'Asaphodes sericodes','Asaphodes sericodes','Asaphodes sericod',2,0,'','','Meyrick','d8790dc4-b97e-56a4-8852-e45a9844d80b','Asaphodes sericodes (Meyrick, 1915)','(Meyrick, 1915)','SPECIES','','Asaphodes','','sericodes','','','',NULL,'','','','','','Meyrick','','','','1915','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06d05788-68ba-44bd-a71b-76796e3337ea','','','Abatetia robusta (Parent, 1933)',1,'Abatetia robusta','Abatetia robusta','Abatetia robust',2,0,'','','Parent','cbe78b1d-60d0-5f21-bf87-97ee2c775e12','Abatetia robusta (Parent, 1933)','(Parent, 1933)','SPECIES','','Abatetia','','robusta','','','',NULL,'','','','','','Parent','','','','1933','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06d10f7a-114f-492a-8eba-a7c34641c23f','','','Stachybotrys atrus var. microsporus B.L. Mathur & Sankhla',1,'Stachybotrys atrus microsporus','Stachybotrys atrus var. microsporus','Stachybotrys atr microspor',3,0,'','','B. L. Mathur|Sankhla','2e64e39c-f2af-5b66-96e9-c094b861b20a','Stachybotrys atrus var. microsporus B.L. Mathur & Sankhla','B.L. Mathur & Sankhla','VARIETY','','Stachybotrys','','atrus','microsporus','','',NULL,'','','','','','B. L. Mathur & Sankhla','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06d2ab04-dd07-43e1-b02c-3137193d391c','','','Odontia nothofagi G. Cunn.',1,'Odontia nothofagi','Odontia nothofagi','Odontia nothofag',2,0,'','','G. Cunn.','deaad61a-8042-5f35-884a-dfac26785671','Odontia nothofagi G. Cunn.','G. Cunn.','SPECIES','','Odontia','','nothofagi','','','',NULL,'','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06d8e5f0-3362-4577-aed3-bb7b8833ea97','','','Tellinella',1,'Tellinella','Tellinella','Tellinella',1,0,'','','','7f170654-5cfd-50c0-93b2-d157e6ece86a','Tellinella','','GENUS','Tellinella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06d5fe3b-c6d3-45d3-bee1-f044c37a35d7','','','Pyrus malus',1,'Pyrus malus','Pyrus malus','Pyrus mal',2,0,'','','','73b6e9ac-2292-5438-ad64-f47f00cecc78','Pyrus malus','','SPECIES','','Pyrus','','malus','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06d9fbcb-75ba-4987-b0d4-1716856d2a3b','','','Neonetus pilosus (Hutton, 1904)',1,'Neonetus pilosus','Neonetus pilosus','Neonetus pilos',2,0,'','','Hutton','ba975bbb-9904-5813-956c-e34ea8ed411a','Neonetus pilosus (Hutton, 1904)','(Hutton, 1904)','SPECIES','','Neonetus','','pilosus','','','',NULL,'','','','','','Hutton','','','','1904','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06ddb76f-a167-4e44-bb87-acffc8020990','','','Lecidea melaloma C.Knight',1,'Lecidea melaloma','Lecidea melaloma','Lecidea melalom',2,0,'','','C. Knight','f6952f95-8178-5022-8f6a-73e5d45bb1f6','Lecidea melaloma C.Knight','C.Knight','SPECIES','','Lecidea','','melaloma','','','',NULL,'','','','','','C. Knight','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06dcea58-0884-4b38-99d0-dcaae68c3614','','','Phytophthora lacustris Brasier, Cacciola, Nechw., T. Jung & Bakonyi',1,'Phytophthora lacustris','Phytophthora lacustris','Phytophthora lacustr',2,0,'','','Brasier|Cacciola|Nechw.|T. Jung|Bakonyi','794f3c53-11b8-5188-9c59-c9a51ff410bc','Phytophthora lacustris Brasier, Cacciola, Nechw., T. Jung & Bakonyi','Brasier, Cacciola, Nechw., T. Jung & Bakonyi','SPECIES','','Phytophthora','','lacustris','','','',NULL,'','','','','','Brasier, Cacciola, Nechw., T. Jung & Bakonyi','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06e6622c-5451-4f6f-915b-90d5f9bc7ecd','','','Asparagus falcatus L.',1,'Asparagus falcatus','Asparagus falcatus','Asparagus falcat',2,0,'','','L.','d7f886ce-5f07-5390-94d0-c30ab9a36b00','Asparagus falcatus L.','L.','SPECIES','','Asparagus','','falcatus','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06ebd24a-dab6-4371-af58-d343dae11e73','','','Pleurosigma angulatum (Quekett) W.Smith',1,'Pleurosigma angulatum','Pleurosigma angulatum','Pleurosigma angulat',2,0,'','','Quekett|W. Smith','a08b5f13-185c-5fcd-a592-e77e056359ad','Pleurosigma angulatum (Quekett) W.Smith','(Quekett) W.Smith','SPECIES','','Pleurosigma','','angulatum','','','',NULL,'W. Smith','','','','','Quekett','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06f517db-0bcc-4580-af22-5280d8cb4823','','','Allium pulchellum G.Don',1,'Allium pulchellum','Allium pulchellum','Allium pulchell',2,0,'','','G. Don','7613b58c-545f-5581-b853-f1443ecbdce7','Allium pulchellum G.Don','G.Don','SPECIES','','Allium','','pulchellum','','','',NULL,'','','','','','G. Don','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06f504f7-930b-4959-a65a-8a945f1aa3bc','','','Catenicella perlucens (Harmer, 1957)',1,'Catenicella perlucens','Catenicella perlucens','Catenicella perlucens',2,0,'','','Harmer','d1e027df-7d0c-52c3-8fff-79e4d1f5c793','Catenicella perlucens (Harmer, 1957)','(Harmer, 1957)','SPECIES','','Catenicella','','perlucens','','','',NULL,'','','','','','Harmer','','','','1957','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06f87d8a-69bd-412f-8512-aca392bcea4e','','','Poria curreyana (Cooke) G. Cunn.',1,'Poria curreyana','Poria curreyana','Poria curreyan',2,0,'','','Cooke|G. Cunn.','6d8486f8-f22a-58d0-a50c-a374b480136e','Poria curreyana (Cooke) G. Cunn.','(Cooke) G. Cunn.','SPECIES','','Poria','','curreyana','','','',NULL,'G. Cunn.','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06f9f8fd-31ef-48d9-b808-08e76e920b14','','','Panaeolus fimbriatus A.M. Young',1,'Panaeolus fimbriatus','Panaeolus fimbriatus','Panaeolus fimbriat',2,0,'','','A. M. Young','ec6c21b2-e4c2-50f6-a47e-f0185660db78','Panaeolus fimbriatus A.M. Young','A.M. Young','SPECIES','','Panaeolus','','fimbriatus','','','',NULL,'','','','','','A. M. Young','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06fd2d0a-c334-4b51-8d5f-9494cd3a2ccd','','','Uncinia divaricata Boott',1,'Uncinia divaricata','Uncinia divaricata','Uncinia diuaricat',2,0,'','','Boott','8a7f50f0-8061-5bc4-a5d0-bc45af1395b3','Uncinia divaricata Boott','Boott','SPECIES','','Uncinia','','divaricata','','','',NULL,'','','','','','Boott','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06fffa37-e5fa-4701-864d-bfac2e702b72','','','Gomphonema undulatum Hustedt',1,'Gomphonema undulatum','Gomphonema undulatum','Gomphonema undulat',2,0,'','','Hustedt','ca255730-f174-5529-87f5-69dea46a3e48','Gomphonema undulatum Hustedt','Hustedt','SPECIES','','Gomphonema','','undulatum','','','',NULL,'','','','','','Hustedt','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06fe6729-0235-4375-a0c6-e1a051b4933d','','','Chryseomonas Chryseomonas Holmes et al., 1986',1,'Chryseomonas','Chryseomonas','Chryseomonas',1,0,'','','Chryseomonas Holmes et al.','f875eda0-9b0b-5d6f-857c-1d5a232e9b20','Chryseomonas Chryseomonas Holmes et al., 1986','Chryseomonas Holmes et al., 1986','GENUS','Chryseomonas','','','','','','',NULL,'','','','','','Chryseomonas Holmes et al.','','','','1986','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0708125b-ba29-4159-831c-6ae4b4865746','','','Trichoderma victoriense (Overton) Jaklitsch & Voglmayr',1,'Trichoderma victoriense','Trichoderma victoriense','Trichoderma uictoriens',2,0,'','','Overton|Jaklitsch|Voglmayr','7f2fa293-7ed4-5ae5-a45a-f80f8a79bb43','Trichoderma victoriense (Overton) Jaklitsch & Voglmayr','(Overton) Jaklitsch & Voglmayr','SPECIES','','Trichoderma','','victoriense','','','',NULL,'Jaklitsch & Voglmayr','','','','','Overton','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0704e532-2d98-4740-89f0-95c7e617c081','','','Endococcus parietinarius (Linds.) Clauzade & Cl. Roux',1,'Endococcus parietinarius','Endococcus parietinarius','Endococcus parietinar',2,0,'','','Linds.|Clauzade|Cl. Roux','588ee02a-aafb-561a-94c1-97229c2ca637','Endococcus parietinarius (Linds.) Clauzade & Cl. Roux','(Linds.) Clauzade & Cl. Roux','SPECIES','','Endococcus','','parietinarius','','','',NULL,'Clauzade & Cl. Roux','','','','','Linds.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('070dae6c-834e-4dbb-9ab5-0493f267a9d9','','','Trametes versicolor f. versicolor (Speg.) Rajchenb. & J.E. Wright',1,'Trametes versicolor versicolor','Trametes versicolor f. versicolor','Trametes uersicolor uersicolor',3,0,'','','Speg.|Rajchenb.|J. E. Wright','1ea62e4b-0287-5f7f-8a4d-670db464920c','Trametes versicolor f. versicolor (Speg.) Rajchenb. & J.E. Wright','(Speg.) Rajchenb. & J.E. Wright','FORM','','Trametes','','versicolor','versicolor','','',NULL,'Rajchenb. & J. E. Wright','','','','','Speg.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('070d3405-3f2a-4b3a-ac69-84300d01a64b','','','Helicosporium lumbricopsis Linder',1,'Helicosporium lumbricopsis','Helicosporium lumbricopsis','Helicosporium lumbricops',2,0,'','','Linder','585c377d-2d2e-58a4-96ed-47ffcb06bf03','Helicosporium lumbricopsis Linder','Linder','SPECIES','','Helicosporium','','lumbricopsis','','','',NULL,'','','','','','Linder','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0709afad-b62d-448c-afac-b3f9c8306905','','','Sanguibacter Fernández-Garayzábal et al.',1,'Sanguibacter','Sanguibacter','Sanguibacter',1,0,'','','Fernández-Garayzábal et al.','c1122801-8282-5bd6-ba21-0da6f41bbb45','Sanguibacter Fernández-Garayzábal et al.','Fernández-Garayzábal et al.','GENUS','Sanguibacter','','','','','','',NULL,'','','','','','Fernández-Garayzábal et al.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('070b8a68-1c52-46b6-827b-d555b857aaf9','','','Apalocnemis Philippi, 1865',1,'Apalocnemis','Apalocnemis','Apalocnemis',1,0,'','','Philippi','a5759d7c-929f-5554-8acf-ddb779ee01ef','Apalocnemis Philippi, 1865','Philippi, 1865','GENUS','Apalocnemis','','','','','','',NULL,'','','','','','Philippi','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06197bb6-0e17-4428-acc7-98e697178ba1','','','Comesoma',1,'Comesoma','Comesoma','Comesoma',1,0,'','','','159c6ac7-adbb-5fba-bcf2-867dc0892f59','Comesoma','','GENUS','Comesoma','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('061754e4-a4aa-42f7-a229-9afb945e9f8a','','','Leptospermum marginatum Labill.',1,'Leptospermum marginatum','Leptospermum marginatum','Leptospermum marginat',2,0,'','','Labill.','d1009355-30d4-5abc-8f87-5566980bf2f8','Leptospermum marginatum Labill.','Labill.','SPECIES','','Leptospermum','','marginatum','','','',NULL,'','','','','','Labill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0619acd6-e2ac-4a57-9ca5-bde45f9c7671','','','Nonagria Ochsenheimer, 1816',1,'Nonagria','Nonagria','Nonagria',1,0,'','','Ochsenheimer','964c045d-7dee-53dc-8aa4-2cfb2d5f9c63','Nonagria Ochsenheimer, 1816','Ochsenheimer, 1816','GENUS','Nonagria','','','','','','',NULL,'','','','','','Ochsenheimer','','','','1816','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06168e58-fe2a-46d2-a8f5-e0ad52706f18','','','Jungermannia exsecta Schmidel ex Schrad.',1,'Jungermannia exsecta','Jungermannia exsecta','Jungermannia exsect',2,0,'','','Schmidel|Schrad.','ce5605a0-4c9a-57df-bf94-f28d8e837a40','Jungermannia exsecta Schmidel ex Schrad.','Schmidel ex Schrad.','SPECIES','','Jungermannia','','exsecta','','','',NULL,'','','','','','Schmidel','','Schrad.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('061ef28b-02ab-465e-bdae-29642609db7f','','','Fuscidea asbolodes (Nyl.) Hertel & V.Wirth',1,'Fuscidea asbolodes','Fuscidea asbolodes','Fuscidea asbolod',2,0,'','','Nyl.|Hertel|V. Wirth','0356d690-1553-5629-9d88-bb158aab190a','Fuscidea asbolodes (Nyl.) Hertel & V.Wirth','(Nyl.) Hertel & V.Wirth','SPECIES','','Fuscidea','','asbolodes','','','',NULL,'Hertel & V. Wirth','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0620e4b2-ebec-419e-96a3-9f3e7a7b3062','','','Teloschistes velifer f. nodulosa (Js.Murray) Filson',1,'Teloschistes velifer nodulosa','Teloschistes velifer f. nodulosa','Teloschistes uelifer nodulos',3,0,'','','Js. Murray|Filson','d41d6ff2-a844-54ea-bee3-42976483a603','Teloschistes velifer f. nodulosa (Js.Murray) Filson','(Js.Murray) Filson','FORM','','Teloschistes','','velifer','nodulosa','','',NULL,'Filson','','','','','Js. Murray','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('062049e6-122e-4681-b6f9-fd7101bf6be3','','','Acaena sanguisorbae var. viridor Cockayne',1,'Acaena sanguisorbae viridor','Acaena sanguisorbae var. viridor','Acaena sanguisorb uiridor',3,0,'','','Cockayne','5f228f1c-c4aa-5d9e-b2d6-3fed13c80169','Acaena sanguisorbae var. viridor Cockayne','Cockayne','VARIETY','','Acaena','','sanguisorbae','viridor','','',NULL,'','','','','','Cockayne','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('062a806b-9928-4db6-875c-0fe97a57940d','','','Lecidea miscescens Nyl.',1,'Lecidea miscescens','Lecidea miscescens','Lecidea miscescens',2,0,'','','Nyl.','87a8cdf2-3a5d-5d9e-b418-5d689eb5ccd7','Lecidea miscescens Nyl.','Nyl.','SPECIES','','Lecidea','','miscescens','','','',NULL,'','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('062ec7ca-1a87-45bd-8d86-3216838a5ced','','','Chrysomyxa ledi var. rhododendri (de Bary) Savile',1,'Chrysomyxa ledi rhododendri','Chrysomyxa ledi var. rhododendri','Chrysomyxa led rhododendr',3,0,'','','de Bary|Savile','2f0d4926-5dd1-5ebc-b333-6a8b7d6f4109','Chrysomyxa ledi var. rhododendri (de Bary) Savile','(de Bary) Savile','VARIETY','','Chrysomyxa','','ledi','rhododendri','','',NULL,'Savile','','','','','de Bary','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('062555f6-cd20-4a4b-a25e-67c9159bdde8','','','Semiocladius Sublette & Wirth, 1980',1,'Semiocladius','Semiocladius','Semiocladius',1,0,'','','Sublette|Wirth','5dc810eb-462f-50fc-b2d2-fe372baf9377','Semiocladius Sublette & Wirth, 1980','Sublette & Wirth, 1980','GENUS','Semiocladius','','','','','','',NULL,'','','','','','Sublette & Wirth','','','','1980','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06296af5-27e3-43d5-ae3f-f45a3127a9cd','','','Mycoacia lutea (G. Cunn.) Hjortstam',1,'Mycoacia lutea','Mycoacia lutea','Mycoacia lute',2,0,'','','G. Cunn.|Hjortstam','3280a3db-0fff-5671-95b2-f8168023f0f9','Mycoacia lutea (G. Cunn.) Hjortstam','(G. Cunn.) Hjortstam','SPECIES','','Mycoacia','','lutea','','','',NULL,'Hjortstam','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('062fbba2-b374-4c1c-a201-97334832e4f2','','','Pseudoopterus fiordlandensis Larochelle & Larivière, 2017',1,'Pseudoopterus fiordlandensis','Pseudoopterus fiordlandensis','Pseudoopterus fiordlandens',2,0,'','','Larochelle|Larivière','3001984e-b0f6-5173-87d8-eb08d8f5073d','Pseudoopterus fiordlandensis Larochelle & Larivière, 2017','Larochelle & Larivière, 2017','SPECIES','','Pseudoopterus','','fiordlandensis','','','',NULL,'','','','','','Larochelle & Larivière','','','','2017','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06369238-2e5c-4bd3-b804-f6592bf76ebf','','','Araeosoma coriaceum (A. Agassiz, 1879)',1,'Araeosoma coriaceum','Araeosoma coriaceum','Araeosoma coriace',2,0,'','','A. Agassiz','0067939e-d08a-5bf3-ac79-7e85d5c75535','Araeosoma coriaceum (A. Agassiz, 1879)','(A. Agassiz, 1879)','SPECIES','','Araeosoma','','coriaceum','','','',NULL,'','','','','','A. Agassiz','','','','1879','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('063c3efb-6e87-4592-9728-75f7e9883cf9','','','Serruria barbigera Knight',1,'Serruria barbigera','Serruria barbigera','Serruria barbiger',2,0,'','','Knight','3356cd40-ae0d-53e9-a3b1-acb87c01bd45','Serruria barbigera Knight','Knight','SPECIES','','Serruria','','barbigera','','','',NULL,'','','','','','Knight','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0639aec5-5347-47e4-98ce-7e89ab0e7c74','','','Betyla wahine Naumann, 1988',1,'Betyla wahine','Betyla wahine','Betyla wahin',2,0,'','','Naumann','763de275-ee96-598f-939a-0375ddee2f44','Betyla wahine Naumann, 1988','Naumann, 1988','SPECIES','','Betyla','','wahine','','','',NULL,'','','','','','Naumann','','','','1988','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('063b5e87-045f-4e29-855a-c93279c2798b','','','Rhipidura fuliginosa penita Bangs',1,'Rhipidura fuliginosa penita','Rhipidura fuliginosa penita','Rhipidura fuliginos penit',3,0,'','','Bangs','ad574b13-d806-5859-8ff7-283e52f95fa8','Rhipidura fuliginosa penita Bangs','Bangs','SUBSPECIES','','Rhipidura','','fuliginosa','penita','','',NULL,'','','','','','Bangs','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0643fc6f-bba1-4ebc-aef1-17500e0b7717','','','Aceria pimeliae Manson, 1984',1,'Aceria pimeliae','Aceria pimeliae','Aceria pimeli',2,0,'','','Manson','33df7af4-3fa6-50bd-9f9d-6a8e6f26c527','Aceria pimeliae Manson, 1984','Manson, 1984','SPECIES','','Aceria','','pimeliae','','','',NULL,'','','','','','Manson','','','','1984','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06445142-5b63-46f7-8bf4-7280d80cf1d7','','','Procellaria westlandica Falla',1,'Procellaria westlandica','Procellaria westlandica','Procellaria westlandic',2,0,'','','Falla','98222b38-1cbd-5075-aeb5-46ba2d05342f','Procellaria westlandica Falla','Falla','SPECIES','','Procellaria','','westlandica','','','',NULL,'','','','','','Falla','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('063e9e86-1124-4fed-8c78-bbb45c34abd8','','','Rhacocarpus humboldtii (Hook.) Lindb.',1,'Rhacocarpus humboldtii','Rhacocarpus humboldtii','Rhacocarpus humboldt',2,0,'','','Hook.|Lindb.','e8bad50a-d182-598d-8650-513d3a7e6592','Rhacocarpus humboldtii (Hook.) Lindb.','(Hook.) Lindb.','SPECIES','','Rhacocarpus','','humboldtii','','','',NULL,'Lindb.','','','','','Hook.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0642f48a-9eab-488f-b8c2-f529e49ddfc3','','','Alcithoe benthicola (Dell, 1963)',1,'Alcithoe benthicola','Alcithoe benthicola','Alcithoe benthicol',2,0,'','','Dell','f8816e6d-3df6-5d36-bab9-df3aa26b24ca','Alcithoe benthicola (Dell, 1963)','(Dell, 1963)','SPECIES','','Alcithoe','','benthicola','','','',NULL,'','','','','','Dell','','','','1963','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06463279-a89a-40e5-ba4b-36cc8baa0154','','','Veronica teucrium ''Crater Blue Lake''',1,'Veronica teucrium ‘Crater Blue Lake’','Veronica teucrium ‘Crater Blue Lake’','Veronica teucri ‘Crater Blue Lake’',3,0,'','','','b9d5f9c2-9a48-52b5-9079-92ee37272a8a','Veronica teucrium ''Crater Blue Lake''','','CULTIVAR','','Veronica','','teucrium','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06465406-c1a4-415a-9530-77b564276d67','','','Peperomia blanda var. leptostachya (Hook. & Arn.) Düll.',1,'Peperomia blanda leptostachya','Peperomia blanda var. leptostachya','Peperomia bland leptostachy',3,0,'','','Hook.|Arn.|Düll.','263115c8-6a1b-5f1e-b3fb-197f196227e1','Peperomia blanda var. leptostachya (Hook. & Arn.) Düll.','(Hook. & Arn.) Düll.','VARIETY','','Peperomia','','blanda','leptostachya','','',NULL,'Düll.','','','','','Hook. & Arn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('064d513f-e9cc-4cdb-b619-ce19bd817183','','','Tarzetta catinus (Holmsk.) Korf & J.K. Rogers',1,'Tarzetta catinus','Tarzetta catinus','Tarzetta catin',2,0,'','','Holmsk.|Korf|J. K. Rogers','58a8b780-b80f-557a-bfff-f12f2dc6aa3c','Tarzetta catinus (Holmsk.) Korf & J.K. Rogers','(Holmsk.) Korf & J.K. Rogers','SPECIES','','Tarzetta','','catinus','','','',NULL,'Korf & J. K. Rogers','','','','','Holmsk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('065149eb-ec4a-4403-a310-13e94989082f','','','Nezumia',1,'Nezumia','Nezumia','Nezumia',1,0,'','','','997a2552-bf38-5171-814c-3bbfb34a738a','Nezumia','','GENUS','Nezumia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06503cee-829b-44b1-8a77-27c38448e01e','','','Merisma tuberosum Grev.',1,'Merisma tuberosum','Merisma tuberosum','Merisma tuberos',2,0,'','','Grev.','33cc78e0-2019-5c06-b52b-b9c65b09f677','Merisma tuberosum Grev.','Grev.','SPECIES','','Merisma','','tuberosum','','','',NULL,'','','','','','Grev.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('064ff75e-ac14-44c9-9c25-76ab847396b7','','','Pelecanidae',1,'Pelecanidae','Pelecanidae','Pelecanidae',1,0,'','','','6d418c9c-c43b-5331-a916-b4d844378119','Pelecanidae','','FAMILY','Pelecanidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('064ef970-d258-4b89-ba17-9aae83c9aa86','','','Pluvialis fulva (Gmelin)',1,'Pluvialis fulva','Pluvialis fulva','Pluvialis fulu',2,0,'','','Gmelin','3725a74c-6792-5bf8-9be8-ac5dcd3219da','Pluvialis fulva (Gmelin)','(Gmelin)','SPECIES','','Pluvialis','','fulva','','','',NULL,'','','','','','Gmelin','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('064f60fd-e9e8-419b-adaa-d140ff5b6aeb','','','Rhabdomastix trichiata Alexander, 1923',1,'Rhabdomastix trichiata','Rhabdomastix trichiata','Rhabdomastix trichiat',2,0,'','','Alexander','4b5c03f3-3675-58b5-be82-8e4dc8a9bbcd','Rhabdomastix trichiata Alexander, 1923','Alexander, 1923','SPECIES','','Rhabdomastix','','trichiata','','','',NULL,'','','','','','Alexander','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06596d2f-9791-4f48-9eab-11f89b0e50d0','','','Amorphophallus konjac K.Koch',1,'Amorphophallus konjac','Amorphophallus konjac','Amorphophallus koniac',2,0,'','','K. Koch','6531fc35-6518-576d-81da-dab1ee20f392','Amorphophallus konjac K.Koch','K.Koch','SPECIES','','Amorphophallus','','konjac','','','',NULL,'','','','','','K. Koch','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('065a3c70-a1f6-4010-aba2-418de091d075','','','Pentlandia Herb.',1,'Pentlandia','Pentlandia','Pentlandia',1,0,'','','Herb.','643136da-3214-5c9e-aa23-39d670e0c839','Pentlandia Herb.','Herb.','GENUS','Pentlandia','','','','','','',NULL,'','','','','','Herb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06547f06-4cd9-402e-b345-4b7131d4fe0f','','','Limnophilella Alexander, 1919',1,'Limnophilella','Limnophilella','Limnophilella',1,0,'','','Alexander','9872c4b5-4f7e-5d49-874c-7ff636de8779','Limnophilella Alexander, 1919','Alexander, 1919','GENUS','Limnophilella','','','','','','',NULL,'','','','','','Alexander','','','','1919','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('065704f0-550d-4f75-88aa-7d7fd257a36e','','','Acarospora thelococcoides (Nyl.) Zahlbr.',1,'Acarospora thelococcoides','Acarospora thelococcoides','Acarospora thelococcoid',2,0,'','','Nyl.|Zahlbr.','391c375b-3aa6-5cc3-ad92-8b8195223790','Acarospora thelococcoides (Nyl.) Zahlbr.','(Nyl.) Zahlbr.','SPECIES','','Acarospora','','thelococcoides','','','',NULL,'Zahlbr.','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('065894ff-fa8a-4ae1-9297-dd24aca4bca6','','','Turnagrinae',1,'Turnagrinae','Turnagrinae','Turnagrinae',1,0,'','','','25700675-ad82-5528-a71c-9d00843c953f','Turnagrinae','','SUBFAMILY','Turnagrinae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('065dc157-19c4-4fb8-ac7a-081d2904dfcc','','','Drosera flagellifera Colenso',1,'Drosera flagellifera','Drosera flagellifera','Drosera flagellifer',2,0,'','','Colenso','36933169-9026-596d-9e6c-36477060c0d7','Drosera flagellifera Colenso','Colenso','SPECIES','','Drosera','','flagellifera','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('065b5142-174c-4924-90d2-8c59b30a4ddb','','','Pachypatella Theiss. & Syd.',1,'Pachypatella','Pachypatella','Pachypatella',1,0,'','','Theiss.|Syd.','8b3fde88-d12b-5ea4-b9d7-8addfa12bdc8','Pachypatella Theiss. & Syd.','Theiss. & Syd.','GENUS','Pachypatella','','','','','','',NULL,'','','','','','Theiss. & Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('065da54c-b984-45ee-b835-afcdd198e18d','','','Schizeilema allanii Cheeseman',1,'Schizeilema allanii','Schizeilema allanii','Schizeilema allan',2,0,'','','Cheeseman','4dfab6bc-a93a-56ed-9d69-10cebd638c7d','Schizeilema allanii Cheeseman','Cheeseman','SPECIES','','Schizeilema','','allanii','','','',NULL,'','','','','','Cheeseman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('065d35a3-c465-452d-8245-ebc7d7efc8a7','','','Tradescantia L.',1,'Tradescantia','Tradescantia','Tradescantia',1,0,'','','L.','0fec6dd9-4c30-5e04-b527-40af2171b576','Tradescantia L.','L.','GENUS','Tradescantia','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07a068fb-29fc-45d9-955a-56d84cbb7cad','','','Oligosoma chloronoton (Hardy, 1977)',1,'Oligosoma chloronoton','Oligosoma chloronoton','Oligosoma chloronoton',2,0,'','','Hardy','d4c18817-5845-52ab-9ca8-664c962f9cbc','Oligosoma chloronoton (Hardy, 1977)','(Hardy, 1977)','SPECIES','','Oligosoma','','chloronoton','','','',NULL,'','','','','','Hardy','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('079d5fa4-c80f-487c-97b8-82cfbf86b009','','','Galeropsis',1,'Galeropsis','Galeropsis','Galeropsis',1,0,'','','','2ff0f483-23f9-5285-822f-e5654db9f271','Galeropsis','','GENUS','Galeropsis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('079fe813-209c-4f43-af1a-bee9b9968d30','','','Buellia stellulata (Taylor) Mudd',1,'Buellia stellulata','Buellia stellulata','Buellia stellulat',2,0,'','','Taylor|Mudd','08691960-1ddc-585e-98db-ffb136d573bc','Buellia stellulata (Taylor) Mudd','(Taylor) Mudd','SPECIES','','Buellia','','stellulata','','','',NULL,'Mudd','','','','','Taylor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('079ffe35-fec5-4ebb-952c-f6ffdce3e85f','','','Cladia collodes (Hook.f. & Taylor) C.W.Dodge',1,'Cladia collodes','Cladia collodes','Cladia collod',2,0,'','','Hook. fil.|Taylor|C. W. Dodge','a3452986-2dba-5e4a-ba74-43cbd51c81a4','Cladia collodes (Hook.f. & Taylor) C.W.Dodge','(Hook.f. & Taylor) C.W.Dodge','SPECIES','','Cladia','','collodes','','','',NULL,'C. W. Dodge','','','','','Hook. fil. & Taylor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07a68259-9517-41fa-9e13-6052f1097074','','','Monilochaetes laeënsis (Matsush.) Réblová, W. Gams & Seifert',2,'Monilochaetes laeensis','Monilochaetes laeensis','Monilochaetes laeens',2,0,'','','Matsush.|Réblová|W. Gams|Seifert','cc5c68ce-c9cf-59e5-9dc0-97297ce65e63','Monilochaetes laeënsis (Matsush.) Réblová, W. Gams & Seifert','(Matsush.) Réblová, W. Gams & Seifert','SPECIES','','Monilochaetes','','laeensis','','','',NULL,'Réblová, W. Gams & Seifert','','','','','Matsush.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07adb02e-648b-498c-83b1-0ae47dcdf962','','','Remotididymella Valenz.-Lopez, Crous, Cano, Guarro & Stchigel',1,'Remotididymella','Remotididymella','Remotididymella',1,0,'','','Valenz.-Lopez|Crous|Cano|Guarro|Stchigel','0b4a7a54-cb7a-585d-8f8a-06fdee3b6e1c','Remotididymella Valenz.-Lopez, Crous, Cano, Guarro & Stchigel','Valenz.-Lopez, Crous, Cano, Guarro & Stchigel','GENUS','Remotididymella','','','','','','',NULL,'','','','','','Valenz.-Lopez, Crous, Cano, Guarro & Stchigel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07b514e8-e7ba-4249-a4b9-61587528540a','','','Lagenosolenia scintillans (McCulloch, 1977)',1,'Lagenosolenia scintillans','Lagenosolenia scintillans','Lagenosolenia scintillans',2,0,'','','McCulloch','d3928fc6-0fc3-534f-81f8-ce3e6fa22117','Lagenosolenia scintillans (McCulloch, 1977)','(McCulloch, 1977)','SPECIES','','Lagenosolenia','','scintillans','','','',NULL,'','','','','','McCulloch','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07b5e408-9795-4f11-8835-ac2000d77db4','','','Thripobius javae (Girault, 1917)',1,'Thripobius javae','Thripobius javae','Thripobius iau',2,0,'','','Girault','daa00317-2433-5343-8150-fca7547cf9f3','Thripobius javae (Girault, 1917)','(Girault, 1917)','SPECIES','','Thripobius','','javae','','','',NULL,'','','','','','Girault','','','','1917','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07b674d7-fed4-4d0a-a449-e81c1ed4b919','','','Schizoxylon gaubae Petr.',1,'Schizoxylon gaubae','Schizoxylon gaubae','Schizoxylon gaub',2,0,'','','Petr.','992c1cba-9818-520e-9465-ea243ce0cd51','Schizoxylon gaubae Petr.','Petr.','SPECIES','','Schizoxylon','','gaubae','','','',NULL,'','','','','','Petr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07ba7f9c-934b-46eb-9f31-17f9cb85dc2e','','','Lathrobium',1,'Lathrobium','Lathrobium','Lathrobium',1,0,'','','','b82e2d3e-e350-52e6-8307-cd0ea3da01d6','Lathrobium','','GENUS','Lathrobium','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07be3825-7a6a-45ff-ae24-1a6773e96fa5','','','Chamaemyia Meigen, 1803',1,'Chamaemyia','Chamaemyia','Chamaemyia',1,0,'','','Meigen','0a053471-2473-58d3-889b-f3c0d471ad78','Chamaemyia Meigen, 1803','Meigen, 1803','GENUS','Chamaemyia','','','','','','',NULL,'','','','','','Meigen','','','','1803','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07bd18f9-8b5c-447d-8d85-555e4c41b4fc','','','Uvigerina',1,'Uvigerina','Uvigerina','Uvigerina',1,0,'','','','20d5e6f0-7f93-5b57-b634-403a04d19b63','Uvigerina','','GENUS','Uvigerina','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07bcd471-19f2-4ee4-9507-785f4f5b0c55','','','Nasturtium microphyllum Boenn. ex Rchb.',1,'Nasturtium microphyllum','Nasturtium microphyllum','Nasturtium microphyll',2,0,'','','Boenn.|Rchb.','2b1ab597-bc8d-5f10-948a-2db6cd129167','Nasturtium microphyllum Boenn. ex Rchb.','Boenn. ex Rchb.','SPECIES','','Nasturtium','','microphyllum','','','',NULL,'','','','','','Boenn.','','Rchb.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07baab47-4856-41a6-8a0e-fda0a18ebecc','','','Lyperobates rostralis Broun, 1913',1,'Lyperobates rostralis','Lyperobates rostralis','Lyperobates rostral',2,0,'','','Broun','beb18cd3-06f1-5046-ad45-30aeff70c8cb','Lyperobates rostralis Broun, 1913','Broun, 1913','SPECIES','','Lyperobates','','rostralis','','','',NULL,'','','','','','Broun','','','','1913','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07c3b79a-1e29-4a16-b0ad-5f4f3eaf436f','','','Trachymela catenata (Chapuis, 1877)',1,'Trachymela catenata','Trachymela catenata','Trachymela catenat',2,0,'','','Chapuis','e01c0af2-d0e2-5154-9dfb-46591d6bfd77','Trachymela catenata (Chapuis, 1877)','(Chapuis, 1877)','SPECIES','','Trachymela','','catenata','','','',NULL,'','','','','','Chapuis','','','','1877','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07bfdf72-2fb3-4b4d-aaf4-76f48b8d3a20','','','Aspergillus brunneouniseriatus Suj. Singh & B.K. Bakshi',1,'Aspergillus brunneouniseriatus','Aspergillus brunneouniseriatus','Aspergillus brunneouniseriat',2,0,'','','Suj. Singh|B. K. Bakshi','216adfcd-8784-5af2-a25b-49b160978e44','Aspergillus brunneouniseriatus Suj. Singh & B.K. Bakshi','Suj. Singh & B.K. Bakshi','SPECIES','','Aspergillus','','brunneouniseriatus','','','',NULL,'','','','','','Suj. Singh & B. K. Bakshi','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07c17e3b-eeb6-466f-88a2-ece33dd5391e','','','Poa incrassata Petrie',1,'Poa incrassata','Poa incrassata','Poa incrassat',2,0,'','','Petrie','718f4ed0-21f8-5c55-9b9c-1a45206df668','Poa incrassata Petrie','Petrie','SPECIES','','Poa','','incrassata','','','',NULL,'','','','','','Petrie','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07c96bf7-0b62-43b3-ae8b-465f478afb99','','','Cymodopsis torminosa Hurley & Jansen, 1977',1,'Cymodopsis torminosa','Cymodopsis torminosa','Cymodopsis torminos',2,0,'','','Hurley|Jansen','3b67b744-bee1-566a-9a90-d8e1ddc38387','Cymodopsis torminosa Hurley & Jansen, 1977','Hurley & Jansen, 1977','SPECIES','','Cymodopsis','','torminosa','','','',NULL,'','','','','','Hurley & Jansen','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07c98e26-bfdd-41a3-a829-a5104cd492ab','','','Rhododrilus ravus Lee, 1959',1,'Rhododrilus ravus','Rhododrilus ravus','Rhododrilus rau',2,0,'','','Lee','fb55109a-5116-5d8f-ba1a-6f36a72f046b','Rhododrilus ravus Lee, 1959','Lee, 1959','SPECIES','','Rhododrilus','','ravus','','','',NULL,'','','','','','Lee','','','','1959','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07c82f54-2e40-47c6-93d7-c8add86b321b','','','Penicillium atrosanguineum B.X. Dong',1,'Penicillium atrosanguineum','Penicillium atrosanguineum','Penicillium atrosanguine',2,0,'','','B. X. Dong','343fc772-211f-57a5-babb-df0d2fc6fab3','Penicillium atrosanguineum B.X. Dong','B.X. Dong','SPECIES','','Penicillium','','atrosanguineum','','','',NULL,'','','','','','B. X. Dong','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07cb95e4-d197-404b-9139-514d3b893925','','','Thoramus parryi (Candeze, 1863)',1,'Thoramus parryi','Thoramus parryi','Thoramus parry',2,0,'','','Candeze','dad8943b-ca64-5f5b-9769-451ff45c8383','Thoramus parryi (Candeze, 1863)','(Candeze, 1863)','SPECIES','','Thoramus','','parryi','','','',NULL,'','','','','','Candeze','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07cb6c20-09d8-4638-bf51-bb10c226fda5','','','Punica granatum L.',1,'Punica granatum','Punica granatum','Punica granat',2,0,'','','L.','9008630e-ba6a-594c-bb26-9a54ee99e933','Punica granatum L.','L.','SPECIES','','Punica','','granatum','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07d55974-3c05-4d16-8625-0a61362474de','','','Leioproctus subg. Leioproctus',2,'Leioproctus','Leioproctus subgen. Leioproctus','Leioproctus',1,0,'','','','516dfb07-5276-53e0-a8aa-1437beb753bc','Leioproctus subg. Leioproctus','','SUBGENUS','Leioproctus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07d24697-ba76-4236-bd27-182ebd8ec539','','','Huperzia australiana (Herter) Holub',1,'Huperzia australiana','Huperzia australiana','Huperzia australian',2,0,'','','Herter|Holub','402ff432-908a-5031-bfa8-65ba984ffffe','Huperzia australiana (Herter) Holub','(Herter) Holub','SPECIES','','Huperzia','','australiana','','','',NULL,'Holub','','','','','Herter','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07d9f935-f2d8-49c4-86a8-91e8844af489','','','Cominella (Eucominia) elegantula marlboroughensis Powell, 1946',1,'Cominella elegantula marlboroughensis','Cominella elegantula marlboroughensis','Cominella elegantul marlboroughens',3,0,'','','Powell','546d622a-2f67-5b07-8a48-10e8c061b865','Cominella (Eucominia) elegantula marlboroughensis Powell, 1946','Powell, 1946','SUBSPECIES','','Cominella','','elegantula','marlboroughensis','','',NULL,'','','','','','Powell','','','','1946','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07dd2743-eee1-4c87-a441-1682911db4c1','','','Tyromyces setiger (Cooke) G. Cunn.',1,'Tyromyces setiger','Tyromyces setiger','Tyromyces setiger',2,0,'','','Cooke|G. Cunn.','0b85292e-eaa9-582b-aff9-daed8e139651','Tyromyces setiger (Cooke) G. Cunn.','(Cooke) G. Cunn.','SPECIES','','Tyromyces','','setiger','','','',NULL,'G. Cunn.','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07df40ba-9820-4f90-8e32-9c0dbcc9d342','','','Verbascum nigrum L.',1,'Verbascum nigrum','Verbascum nigrum','Verbascum nigr',2,0,'','','L.','d40ce215-34b8-5044-9aa6-52c6f7fbd8dc','Verbascum nigrum L.','L.','SPECIES','','Verbascum','','nigrum','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07dc8061-01c5-4921-81dc-9cb9b5eb112f','','','Athertonia L.A.S.Johnson & B.G.Briggs',1,'Athertonia','Athertonia','Athertonia',1,0,'','','L. A. S. Johnson|B. G. Briggs','ad7abcf5-f490-565d-a9d0-8351df0918de','Athertonia L.A.S.Johnson & B.G.Briggs','L.A.S.Johnson & B.G.Briggs','GENUS','Athertonia','','','','','','',NULL,'','','','','','L. A. S. Johnson & B. G. Briggs','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07e265a2-fb0d-411b-863c-0ffeb05c84be','','','Phacus helikoides Pochmann',1,'Phacus helikoides','Phacus helikoides','Phacus helikoid',2,0,'','','Pochmann','b4ea6c35-69cd-5824-9a57-9a487e3c8850','Phacus helikoides Pochmann','Pochmann','SPECIES','','Phacus','','helikoides','','','',NULL,'','','','','','Pochmann','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07e744eb-75aa-4c57-98f7-5cb533894564','','','Glabratelloidea',1,'Glabratelloidea','Glabratelloidea','Glabratelloidea',1,0,'','','','ed3c1443-63ff-53c8-b13b-aa51c81b8077','Glabratelloidea','','SUPERFAMILY','Glabratelloidea','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07e41ea0-86a3-4e9c-a772-7463777a00ff','','','Comptella devia (Suter, 1908)',1,'Comptella devia','Comptella devia','Comptella deu',2,0,'','','Suter','9de6ac14-9f52-53bb-a5cf-f1332a5a25e3','Comptella devia (Suter, 1908)','(Suter, 1908)','SPECIES','','Comptella','','devia','','','',NULL,'','','','','','Suter','','','','1908','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07e93b83-b876-403b-807c-1ac8d07752ab','','','Tortula princeps sensu Sainsbury',4,'','','',NULL,NULL,'','','','','Tortula princeps sensu Sainsbury','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07e9dce8-e1d7-4438-b1e1-3fe834dd5bcb','','','Anthoceros muscoides Colenso',1,'Anthoceros muscoides','Anthoceros muscoides','Anthoceros muscoid',2,0,'','','Colenso','c4fc744f-aaf5-56c8-a84a-2eb75a44ce29','Anthoceros muscoides Colenso','Colenso','SPECIES','','Anthoceros','','muscoides','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07ea2630-9af0-454d-8e6e-8d3d2f5be3dd','','','Xylosphaera polymorpha (Pers.) Dumort.',1,'Xylosphaera polymorpha','Xylosphaera polymorpha','Xylosphaera polymorph',2,0,'','','Pers.|Dumort.','4ae5ef32-5b13-59e6-a932-cb7aecb79498','Xylosphaera polymorpha (Pers.) Dumort.','(Pers.) Dumort.','SPECIES','','Xylosphaera','','polymorpha','','','',NULL,'Dumort.','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07e7aa2f-38f6-429c-ab6b-fa796ceee41f','','','Euglena salina Liebetanz',1,'Euglena salina','Euglena salina','Euglena salin',2,0,'','','Liebetanz','d2ae8609-7eb3-5f59-bd29-cce7b18939a3','Euglena salina Liebetanz','Liebetanz','SPECIES','','Euglena','','salina','','','',NULL,'','','','','','Liebetanz','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07efa0cc-499d-4231-9f8a-3917aadc9d7e','','','Rygmodus antennatus (Sharp, 1884)',1,'Rygmodus antennatus','Rygmodus antennatus','Rygmodus antennat',2,0,'','','Sharp','91eba423-411e-5158-a7f7-8a4eb7882a81','Rygmodus antennatus (Sharp, 1884)','(Sharp, 1884)','SPECIES','','Rygmodus','','antennatus','','','',NULL,'','','','','','Sharp','','','','1884','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07f000cb-ae73-451d-b874-607b5dbe796d','','','Worsleya rayneri (Hook.f.) Traub & Moldenke',1,'Worsleya rayneri','Worsleya rayneri','Worsleya rayner',2,0,'','','Hook. fil.|Traub|Moldenke','b607fb49-e5ba-5d33-b513-0842fbb9482b','Worsleya rayneri (Hook.f.) Traub & Moldenke','(Hook.f.) Traub & Moldenke','SPECIES','','Worsleya','','rayneri','','','',NULL,'Traub & Moldenke','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07ed422c-4364-401a-9632-8d5fbeea97e4','','','Trithuria brevistyla (K.A.Ford) de Lange & Mosyakin',1,'Trithuria brevistyla','Trithuria brevistyla','Trithuria breuistyl',2,0,'','','K. A. Ford|de Lange|Mosyakin','38a64c21-108c-5236-b174-fa2fe5966618','Trithuria brevistyla (K.A.Ford) de Lange & Mosyakin','(K.A.Ford) de Lange & Mosyakin','SPECIES','','Trithuria','','brevistyla','','','',NULL,'de Lange & Mosyakin','','','','','K. A. Ford','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07f9278c-6391-4e0c-9f3b-090dbf275bd5','','','Mimalaptus',1,'Mimalaptus','Mimalaptus','Mimalaptus',1,0,'','','','0faee54f-9703-56c0-a7f8-41fc7bdb41e6','Mimalaptus','','GENUS','Mimalaptus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07f88258-d615-4c0f-b138-3bf68ab82cb1','','','Galba',1,'Galba','Galba','Galba',1,0,'','','','2cf43382-f076-5f14-98ed-acea89ee00a4','Galba','','GENUS','Galba','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07f72370-7618-41cf-8c2f-4107ca03d0b3','','','Trametes tenuis (Berk.) Justo',1,'Trametes tenuis','Trametes tenuis','Trametes tenu',2,0,'','','Berk.|Justo','4085ef37-e801-5980-adb6-4e620f08813c','Trametes tenuis (Berk.) Justo','(Berk.) Justo','SPECIES','','Trametes','','tenuis','','','',NULL,'Justo','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07f886d7-6b7a-48a3-8902-9015d6cfb383','','','Pareucalanus',1,'Pareucalanus','Pareucalanus','Pareucalanus',1,0,'','','','a8fb8fc7-dd5d-53bc-b3ff-d6e1055fd97b','Pareucalanus','','GENUS','Pareucalanus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07f82ad3-8713-4b61-824b-beb0082ef22e','','','Scenidium (Klotzsch) Kuntze',1,'Scenidium','Scenidium','Scenidium',1,0,'','','Klotzsch|Kuntze','184da256-c5b6-56e9-905e-e7a98bfd3110','Scenidium (Klotzsch) Kuntze','(Klotzsch) Kuntze','GENUS','Scenidium','','','','','','',NULL,'Kuntze','','','','','Klotzsch','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07f92bef-4ad6-4d09-8b97-151e74183c3b','','','Centraugaptilus horridus (Farran, 1908)',1,'Centraugaptilus horridus','Centraugaptilus horridus','Centraugaptilus horrid',2,0,'','','Farran','413cb649-38db-5c11-8b8c-2c75e346140f','Centraugaptilus horridus (Farran, 1908)','(Farran, 1908)','SPECIES','','Centraugaptilus','','horridus','','','',NULL,'','','','','','Farran','','','','1908','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07fd99b2-6602-4828-98be-7163f58b3b0e','','','Restionales',1,'Restionales','Restionales','Restionales',1,0,'','','','176daac8-ad49-588b-afc4-a7a1af9a9b1a','Restionales','','ORDER','Restionales','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07fad55b-c309-4069-9e92-7446dd1db6cd','','','Juniperus cedrus Webb & Berthel.',1,'Juniperus cedrus','Juniperus cedrus','Juniperus cedr',2,0,'','','Webb|Berthel.','3777cfaf-d881-5424-ade3-a416060057ff','Juniperus cedrus Webb & Berthel.','Webb & Berthel.','SPECIES','','Juniperus','','cedrus','','','',NULL,'','','','','','Webb & Berthel.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07f9a347-b877-40a7-8d4f-8e1127f3d36f','','','Rhoeo Hance',1,'Rhoeo','Rhoeo','Rhoeo',1,0,'','','Hance','10280ae5-da51-548f-a50d-f8aea0877ff9','Rhoeo Hance','Hance','GENUS','Rhoeo','','','','','','',NULL,'','','','','','Hance','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07fd655b-0292-4ba9-8a67-ea57d9d7cafb','','','Aglaophamus elamellata (Eliason, 1951)',1,'Aglaophamus elamellata','Aglaophamus elamellata','Aglaophamus elamellat',2,0,'','','Eliason','68daac24-c650-5bd9-be1f-6d73fa010fc6','Aglaophamus elamellata (Eliason, 1951)','(Eliason, 1951)','SPECIES','','Aglaophamus','','elamellata','','','',NULL,'','','','','','Eliason','','','','1951','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08021888-2d07-4091-83f5-3955a49a0172','','','Notiomimetini',1,'Notiomimetini','Notiomimetini','Notiomimetini',1,0,'','','','59cbc05a-a03c-575b-a153-ea143c7b4f64','Notiomimetini','','TRIBE','Notiomimetini','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0804b8a9-5faa-4053-beac-8e54c48c261c','','','Teratosphaeria nubilosa (Cooke) Crous & U. Braun',1,'Teratosphaeria nubilosa','Teratosphaeria nubilosa','Teratosphaeria nubilos',2,0,'','','Cooke|Crous|U. Braun','a316cbc6-99e3-53ca-afe6-263d4420105f','Teratosphaeria nubilosa (Cooke) Crous & U. Braun','(Cooke) Crous & U. Braun','SPECIES','','Teratosphaeria','','nubilosa','','','',NULL,'Crous & U. Braun','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0800b259-a940-47a8-a1a3-c8acba313212','','','Synuraceae',1,'Synuraceae','Synuraceae','Synuraceae',1,0,'','','','3a3119e4-68d8-58ab-94b1-457e8fd37021','Synuraceae','','FAMILY','Synuraceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('080556bb-8d21-4eee-832f-e383f5ad9fa1','','','Sigaus',1,'Sigaus','Sigaus','Sigaus',1,0,'','','','cb58fb20-5771-586f-8509-0898ff6ea4aa','Sigaus','','GENUS','Sigaus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08041069-0541-4861-9ea7-e44562387a02','','','Anabarhynchus rufobasalis Lyneborg, 1992',1,'Anabarhynchus rufobasalis','Anabarhynchus rufobasalis','Anabarhynchus rufobasal',2,0,'','','Lyneborg','cbfd53c4-c521-50bf-bee1-d7bc298553cc','Anabarhynchus rufobasalis Lyneborg, 1992','Lyneborg, 1992','SPECIES','','Anabarhynchus','','rufobasalis','','','',NULL,'','','','','','Lyneborg','','','','1992','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('080b76f0-ec47-486f-a1bd-0f05bf879d53','','','Mitophyllus gibbosus (Broun, 1885)',1,'Mitophyllus gibbosus','Mitophyllus gibbosus','Mitophyllus gibbos',2,0,'','','Broun','d3ea9c65-8fcb-5768-8f5f-1fa46ea98815','Mitophyllus gibbosus (Broun, 1885)','(Broun, 1885)','SPECIES','','Mitophyllus','','gibbosus','','','',NULL,'','','','','','Broun','','','','1885','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('080a0253-424d-4b7e-8be8-25a066cfc6ae','','','Planispirinoides bucculentus',1,'Planispirinoides bucculentus','Planispirinoides bucculentus','Planispirinoides bucculent',2,0,'','','','0e96a5c2-480d-58d3-96eb-cdf8369628dd','Planispirinoides bucculentus','','SPECIES','','Planispirinoides','','bucculentus','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('080e1d03-36fb-4111-9c58-631c47403f15','','','Limatula insularis Oliver, 1915',1,'Limatula insularis','Limatula insularis','Limatula insular',2,0,'','','Oliver','fa571ba9-e796-50cf-b79c-13c2e119d770','Limatula insularis Oliver, 1915','Oliver, 1915','SPECIES','','Limatula','','insularis','','','',NULL,'','','','','','Oliver','','','','1915','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08099ac4-18b0-436e-8973-ab1b26ea8669','','','Botryosporium pulchrum Corda',1,'Botryosporium pulchrum','Botryosporium pulchrum','Botryosporium pulchr',2,0,'','','Corda','26f7d68e-870d-52b0-860b-4e7b00c83e62','Botryosporium pulchrum Corda','Corda','SPECIES','','Botryosporium','','pulchrum','','','',NULL,'','','','','','Corda','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('080fa05a-ff7e-4800-91a2-eb9cf0e6e44b','','','Lecane subtilis Harring & Myers, 1926',1,'Lecane subtilis','Lecane subtilis','Lecane subtil',2,0,'','','Harring|Myers','7ddb21fb-3ba7-584f-a977-e9573eb5122c','Lecane subtilis Harring & Myers, 1926','Harring & Myers, 1926','SPECIES','','Lecane','','subtilis','','','',NULL,'','','','','','Harring & Myers','','','','1926','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08164d8d-cf32-424a-b170-adceb6ac8dc4','','','Penicillium sabulosum Pitt & A.D. Hocking',1,'Penicillium sabulosum','Penicillium sabulosum','Penicillium sabulos',2,0,'','','Pitt|A. D. Hocking','946deb61-3321-5390-9048-a39dad8e563a','Penicillium sabulosum Pitt & A.D. Hocking','Pitt & A.D. Hocking','SPECIES','','Penicillium','','sabulosum','','','',NULL,'','','','','','Pitt & A. D. Hocking','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('081b750a-bdd7-4d19-9bb2-2a3dbea334c0','','','Haradaea Denchev',1,'Haradaea','Haradaea','Haradaea',1,0,'','','Denchev','0932f321-dcc3-5d45-8549-ba56f94b5eb6','Haradaea Denchev','Denchev','GENUS','Haradaea','','','','','','',NULL,'','','','','','Denchev','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('081a9f92-244f-44ed-9b8d-41c3b1c05c57','','','Penidiella cubensis (R.F. Castañeda) U. Braun, Crous & R.F. Castañeda',1,'Penidiella cubensis','Penidiella cubensis','Penidiella cubens',2,0,'','','R. F. Castañeda|U. Braun|Crous','f345ff95-7150-51e4-8f61-fd4db832e769','Penidiella cubensis (R.F. Castañeda) U. Braun, Crous & R.F. Castañeda','(R.F. Castañeda) U. Braun, Crous & R.F. Castañeda','SPECIES','','Penidiella','','cubensis','','','',NULL,'U. Braun, Crous & R. F. Castañeda','','','','','R. F. Castañeda','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('081b6954-45ce-4fa3-b607-e3b99cda5eef','','','Pasiphila rivalis (Philpott, 1916)',1,'Pasiphila rivalis','Pasiphila rivalis','Pasiphila riual',2,0,'','','Philpott','14af87b3-128b-5a65-bcbe-933ccead1af2','Pasiphila rivalis (Philpott, 1916)','(Philpott, 1916)','SPECIES','','Pasiphila','','rivalis','','','',NULL,'','','','','','Philpott','','','','1916','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0823a0f9-e927-4f7a-93fd-2d15e7a73929','','','Liriomyza oleariae Spencer, 1976',1,'Liriomyza oleariae','Liriomyza oleariae','Liriomyza oleari',2,0,'','','Spencer','0ffd3daf-802c-5ff0-ac17-9f5060c3d674','Liriomyza oleariae Spencer, 1976','Spencer, 1976','SPECIES','','Liriomyza','','oleariae','','','',NULL,'','','','','','Spencer','','','','1976','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0823c87a-fd51-433c-a24d-6268d74fd938','','','Laevidentalina badenensis (d’Orbigny, 1846)',3,'','','',NULL,NULL,'','','','','Laevidentalina badenensis (d’Orbigny, 1846)','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08203743-9fd4-4340-871b-b75a86056288','','','Pezicula dissepta (Tul.) Tul. & C. Tul.',1,'Pezicula dissepta','Pezicula dissepta','Pezicula dissept',2,0,'','','Tul.|C. Tul.','c77fa245-6e69-5302-b502-bc76be1d2749','Pezicula dissepta (Tul.) Tul. & C. Tul.','(Tul.) Tul. & C. Tul.','SPECIES','','Pezicula','','dissepta','','','',NULL,'Tul. & C. Tul.','','','','','Tul.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0822f805-9511-412f-ac7b-fff746b335e8','','','Wheeleriola',1,'Wheeleriola','Wheeleriola','Wheeleriola',1,0,'','','','4906522f-e2fc-5e7c-9712-1ad39cbdd0cd','Wheeleriola','','GENUS','Wheeleriola','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('070fa6a1-d1ef-43c6-b7c1-0736293694ec','','','Coprosma grandifolia Hook.f.',1,'Coprosma grandifolia','Coprosma grandifolia','Coprosma grandifol',2,0,'','','Hook. fil.','c5af9c12-2c41-5731-a27c-90779d6fd7dc','Coprosma grandifolia Hook.f.','Hook.f.','SPECIES','','Coprosma','','grandifolia','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07108456-7f6a-4085-88d5-466df41a954f','','','Neuropogon pseudocapillaris (F.J.Walker) D.J.Galloway',1,'Neuropogon pseudocapillaris','Neuropogon pseudocapillaris','Neuropogon pseudocapillar',2,0,'','','F. J. Walker|D. J. Galloway','8a058b99-236a-5797-8289-5e5ddfbfd25c','Neuropogon pseudocapillaris (F.J.Walker) D.J.Galloway','(F.J.Walker) D.J.Galloway','SPECIES','','Neuropogon','','pseudocapillaris','','','',NULL,'D. J. Galloway','','','','','F. J. Walker','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0710352b-cd00-4898-bfc2-9abfafa0387a','','','Cenomyce chlorophaea Flörke ex Sommerf.',1,'Cenomyce chlorophaea','Cenomyce chlorophaea','Cenomyce chlorophae',2,0,'','','Flörke|Sommerf.','1590308c-ea2c-54f8-a407-482a27c1ffc3','Cenomyce chlorophaea Flörke ex Sommerf.','Flörke ex Sommerf.','SPECIES','','Cenomyce','','chlorophaea','','','',NULL,'','','','','','Flörke','','Sommerf.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('070ffb95-42b2-452e-bf7a-e77576c01ae2','','','Melanotopelia toensbergii (Kantvilas & Vězda) Lumbsch & Mangold',1,'Melanotopelia toensbergii','Melanotopelia toensbergii','Melanotopelia toensberg',2,0,'','','Kantvilas|Vězda|Lumbsch|Mangold','78ceb370-ca11-5e84-bdf0-f8c6b36f5c7f','Melanotopelia toensbergii (Kantvilas & Vězda) Lumbsch & Mangold','(Kantvilas & Vězda) Lumbsch & Mangold','SPECIES','','Melanotopelia','','toensbergii','','','',NULL,'Lumbsch & Mangold','','','','','Kantvilas & Vězda','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0715c0f3-06dc-43dc-a047-4f8249170f3b','','','Nepenthes bongso Korth.',1,'Nepenthes bongso','Nepenthes bongso','Nepenthes bongs',2,0,'','','Korth.','d64f3f99-f9e7-5c03-8c30-c8df39a90c26','Nepenthes bongso Korth.','Korth.','SPECIES','','Nepenthes','','bongso','','','',NULL,'','','','','','Korth.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0716a0a0-a512-4865-a270-af2d07a91260','','','Neonetus poduroides (Walker, 1869)',1,'Neonetus poduroides','Neonetus poduroides','Neonetus poduroid',2,0,'','','Walker','c670dc6e-1bf6-5d92-a931-f6618a46402c','Neonetus poduroides (Walker, 1869)','(Walker, 1869)','SPECIES','','Neonetus','','poduroides','','','',NULL,'','','','','','Walker','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07153cd6-f862-488c-a480-d19b2d0495bc','','','Frullania knightbridgei von Konrat & de Lange',1,'Frullania knightbridgei','Frullania knightbridgei','Frullania knightbridge',2,0,'','','von Konrat|de Lange','d93426e7-92ab-5ed0-a678-a24942ad5301','Frullania knightbridgei von Konrat & de Lange','von Konrat & de Lange','SPECIES','','Frullania','','knightbridgei','','','',NULL,'','','','','','von Konrat & de Lange','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('071b096a-724f-4b46-9a96-3c11a9950618','','','Kiwi Khalaim and Ward, 2019',1,'Kiwi','Kiwi','Kiwi',1,0,'','','Khalaim|Ward','046ac73d-0976-51fb-b409-94c2dbc68dcc','Kiwi Khalaim and Ward, 2019','Khalaim and Ward, 2019','GENUS','Kiwi','','','','','','',NULL,'','','','','','Khalaim & Ward','','','','2019','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('071c2730-aaa6-474d-b04b-9e727f0f580d','','','Goplana Racib.',1,'Goplana','Goplana','Goplana',1,0,'','','Racib.','9efcb379-27ac-575c-9e0c-d15d36614450','Goplana Racib.','Racib.','GENUS','Goplana','','','','','','',NULL,'','','','','','Racib.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0725d13b-bc2d-49c8-aabb-070e89597eec','','','Chaenothecopsis brevipes Tibell',1,'Chaenothecopsis brevipes','Chaenothecopsis brevipes','Chaenothecopsis breuip',2,0,'','','Tibell','8704f072-aebe-53f2-8f05-cd1b9c740935','Chaenothecopsis brevipes Tibell','Tibell','SPECIES','','Chaenothecopsis','','brevipes','','','',NULL,'','','','','','Tibell','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('072330e5-ea66-4c55-9261-5412e206b37d','','','Botrytis porri N.F. Buchw.',1,'Botrytis porri','Botrytis porri','Botrytis porr',2,0,'','','N. F. Buchw.','c696a58a-adf6-5784-82f4-b533338a9054','Botrytis porri N.F. Buchw.','N.F. Buchw.','SPECIES','','Botrytis','','porri','','','',NULL,'','','','','','N. F. Buchw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07248925-54e3-49f7-9e97-71344cae489e','','','Aspergillus carbonarius (Bainier) Thom',1,'Aspergillus carbonarius','Aspergillus carbonarius','Aspergillus carbonar',2,0,'','','Bainier|Thom','bad006d1-2881-5226-9f06-baa92ee22c8f','Aspergillus carbonarius (Bainier) Thom','(Bainier) Thom','SPECIES','','Aspergillus','','carbonarius','','','',NULL,'Thom','','','','','Bainier','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07248319-d498-4d1a-9da5-8e2e1f0239b9','','','Festuca ovina subsp. matthewsii Hack.',1,'Festuca ovina matthewsii','Festuca ovina subsp. matthewsii','Festuca ouin matthews',3,0,'','','Hack.','ba0444a5-97bd-56f3-a831-7cabfeb5e9a2','Festuca ovina subsp. matthewsii Hack.','Hack.','SUBSPECIES','','Festuca','','ovina','matthewsii','','',NULL,'','','','','','Hack.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07233b21-cff2-40b1-b8e8-ca929f0f650c','','','Conocybe rickenii sensu A.E. Bell',4,'','','',NULL,NULL,'','','','','Conocybe rickenii sensu A.E. Bell','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('072dde3c-bcad-4e3e-9dce-2a492177376a','','','Allorhizobium undicola de Lajudie et al., 1998',1,'Allorhizobium undicola','Allorhizobium undicola','Allorhizobium undicol',2,0,'','','de Lajudie et al.','faa89ea3-f01b-5725-8fc0-83de3c22a21f','Allorhizobium undicola de Lajudie et al., 1998','de Lajudie et al., 1998','SPECIES','','Allorhizobium','','undicola','','','',NULL,'','','','','','de Lajudie et al.','','','','1998','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('072aa788-761c-4433-b8dc-73157b8ebd58','','','Idioteuthis subg. Idioteuthis',2,'Idioteuthis','Idioteuthis subgen. Idioteuthis','Idioteuthis',1,0,'','','','f470f9b7-44d7-579c-8dcc-ffa8790f9524','Idioteuthis subg. Idioteuthis','','SUBGENUS','Idioteuthis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('072a198e-1ee8-475f-8325-92aae24d7d54','','','Phormiobius matau Shen, Choi & Leschen, 2020',1,'Phormiobius matau','Phormiobius matau','Phormiobius mata',2,0,'','','Shen|Choi|Leschen','fef63410-b05d-5f55-a3ac-764793dc2eb2','Phormiobius matau Shen, Choi & Leschen, 2020','Shen, Choi & Leschen, 2020','SPECIES','','Phormiobius','','matau','','','',NULL,'','','','','','Shen, Choi & Leschen','','','','2020','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('072aebe3-e213-452c-b241-d09f371f4796','','','Uromyces panici-sanguinalis Rangel',1,'Uromyces panici-sanguinalis','Uromyces panici-sanguinalis','Uromyces panici-sanguinal',2,0,'','','Rangel','0c2093da-d81c-5bbf-b99a-cbb35add7d70','Uromyces panici-sanguinalis Rangel','Rangel','SPECIES','','Uromyces','','panici-sanguinalis','','','',NULL,'','','','','','Rangel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('072ed7fd-6224-4574-91f4-5500d00b9c51','','','Juncus microcephalus var. floribundus (Kunth) E.Mey.',1,'Juncus microcephalus floribundus','Juncus microcephalus var. floribundus','Juncus microcephal floribund',3,0,'','','Kunth|E. Mey.','ca645789-afc7-5768-a985-8bc6eafd9f48','Juncus microcephalus var. floribundus (Kunth) E.Mey.','(Kunth) E.Mey.','VARIETY','','Juncus','','microcephalus','floribundus','','',NULL,'E. Mey.','','','','','Kunth','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('073470a7-0988-4f36-bc41-6de83570ff9a','','','Warburgiella leucocyta (Müll.Hal.) B.C.Tan, W.B.Schofield & H.P.Ramsay',1,'Warburgiella leucocyta','Warburgiella leucocyta','Warburgiella leucocyt',2,0,'','','Müll. Hal.|B. C. Tan|W. B. Schofield|H. P. Ramsay','ce8a3473-079c-5d65-8a51-fdea78575fdc','Warburgiella leucocyta (Müll.Hal.) B.C.Tan, W.B.Schofield & H.P.Ramsay','(Müll.Hal.) B.C.Tan, W.B.Schofield & H.P.Ramsay','SPECIES','','Warburgiella','','leucocyta','','','',NULL,'B. C. Tan, W. B. Schofield & H. P. Ramsay','','','','','Müll. Hal.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07354f42-3d9b-41eb-ae0d-d27dc0ecaa3a','','','Paramage',1,'Paramage','Paramage','Paramage',1,0,'','','','bcdaf171-5132-5734-8c6a-3340fddf4596','Paramage','','GENUS','Paramage','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0732ee81-80c3-426e-a67f-e6f90b39ba34','','','Adiantum setulosum J.Sm.',1,'Adiantum setulosum','Adiantum setulosum','Adiantum setulos',2,0,'','','J. Sm.','d71e0fe1-59de-561b-b1f9-cbdab2172217','Adiantum setulosum J.Sm.','J.Sm.','SPECIES','','Adiantum','','setulosum','','','',NULL,'','','','','','J. Sm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('073a1b48-a5cb-4124-b473-02c5772eea88','','','Mustelus species',4,'','','',NULL,NULL,'','','','','Mustelus species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07384f29-4fc3-490f-900f-071ed5390596','','','Ocellularia bicavata (Nyl.) Müll.Arg.',1,'Ocellularia bicavata','Ocellularia bicavata','Ocellularia bicauat',2,0,'','','Nyl.|Müll. Arg.','11cc06b8-0b67-5509-9240-0993af1623f5','Ocellularia bicavata (Nyl.) Müll.Arg.','(Nyl.) Müll.Arg.','SPECIES','','Ocellularia','','bicavata','','','',NULL,'Müll. Arg.','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('073a06eb-8e07-4516-9a1f-4ae5e348ebe1','','','Verrucaria durietzii I.M.Lamb',1,'Verrucaria durietzii','Verrucaria durietzii','Verrucaria durietz',2,0,'','','I. M. Lamb','89a976f9-8cd4-5636-8e5d-d37f47b6639a','Verrucaria durietzii I.M.Lamb','I.M.Lamb','SPECIES','','Verrucaria','','durietzii','','','',NULL,'','','','','','I. M. Lamb','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('073762be-5b36-4b96-b91f-b7e138bf6c91','','','Puccinia pallidomaculata Ellis & Everh.',1,'Puccinia pallidomaculata','Puccinia pallidomaculata','Puccinia pallidomaculat',2,0,'','','Ellis|Everh.','48433a59-383c-5044-8175-b2946cb93e90','Puccinia pallidomaculata Ellis & Everh.','Ellis & Everh.','SPECIES','','Puccinia','','pallidomaculata','','','',NULL,'','','','','','Ellis & Everh.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('073c59f8-c01d-4a3b-a1e3-10c7c6ade64c','','','Rivularia beccariana (DeNot.) Bornet et Flahault',1,'Rivularia beccariana','Rivularia beccariana','Rivularia beccarian',2,0,'','','De Not.|Bornet|Flahault','e710c766-2be9-5367-b779-6b824bcdd173','Rivularia beccariana (DeNot.) Bornet et Flahault','(DeNot.) Bornet et Flahault','SPECIES','','Rivularia','','beccariana','','','',NULL,'Bornet & Flahault','','','','','De Not.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('073df2aa-0b50-4105-9afd-45bca93b66ba','','','Macrophoma reniformis (Viala & Ravaz) Cavara',1,'Macrophoma reniformis','Macrophoma reniformis','Macrophoma reniform',2,0,'','','Viala|Ravaz|Cavara','d6652b6b-6b86-5ade-958b-6d8627cebdb0','Macrophoma reniformis (Viala & Ravaz) Cavara','(Viala & Ravaz) Cavara','SPECIES','','Macrophoma','','reniformis','','','',NULL,'Cavara','','','','','Viala & Ravaz','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07463cee-c986-4a6c-a41f-22b5878487e1','','','Clinorhampha Collin, 1933',1,'Clinorhampha','Clinorhampha','Clinorhampha',1,0,'','','Collin','ae9ada81-1565-559d-893d-a81436be58f7','Clinorhampha Collin, 1933','Collin, 1933','GENUS','Clinorhampha','','','','','','',NULL,'','','','','','Collin','','','','1933','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0741276d-abd9-42e6-b422-732631d1c5d4','','','Kritaturus jacundus Cook, 1983',1,'Kritaturus jacundus','Kritaturus jacundus','Kritaturus iacund',2,0,'','','Cook','308d5014-95f9-55b1-a1f8-b8d79aa4a7ba','Kritaturus jacundus Cook, 1983','Cook, 1983','SPECIES','','Kritaturus','','jacundus','','','',NULL,'','','','','','Cook','','','','1983','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('074413c3-599b-4d4f-a082-a3ef8024a5a0','','','Gen. nov. 2',NULL,'','','',NULL,NULL,'','','','','Gen. nov. 2','','GENUS','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07422795-13e1-455b-8c7d-af89b2ed5528','','','Puccinia lateripes Berk. & Ravenel',1,'Puccinia lateripes','Puccinia lateripes','Puccinia laterip',2,0,'','','Berk.|Ravenel','710c9210-ebc2-56aa-881f-63c1989b0c4e','Puccinia lateripes Berk. & Ravenel','Berk. & Ravenel','SPECIES','','Puccinia','','lateripes','','','',NULL,'','','','','','Berk. & Ravenel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('074877da-f464-4d4f-a8b7-086dd89e27fc','','','Caliciaceae Chevall.',1,'Caliciaceae','Caliciaceae','Caliciaceae',1,0,'','','Chevall.','17ae80ce-2af0-5f8c-8131-1a30fb7bd5d6','Caliciaceae Chevall.','Chevall.','FAMILY','Caliciaceae','','','','','','',NULL,'','','','','','Chevall.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('074af451-e615-4509-9dfc-17b08f9ca113','','','Baccharis L.',1,'Baccharis','Baccharis','Baccharis',1,0,'','','L.','d1c59015-3272-5e8a-94fd-4b5d9bf854be','Baccharis L.','L.','GENUS','Baccharis','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('074c0965-77dd-4755-a007-4d8f06eecd3b','','','Epichorista elephantina (Meyrick, 1885)',1,'Epichorista elephantina','Epichorista elephantina','Epichorista elephantin',2,0,'','','Meyrick','581c9ceb-b9af-5a11-a0b1-969f8945d50b','Epichorista elephantina (Meyrick, 1885)','(Meyrick, 1885)','SPECIES','','Epichorista','','elephantina','','','',NULL,'','','','','','Meyrick','','','','1885','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('074840a0-0587-408e-ba64-a82c77dd1ce9','','','Paragaeumannomyces bombycinus (T.J. Atk., A.N. Mill. & Huhndorf) Réblová & A.N. Mill.',1,'Paragaeumannomyces bombycinus','Paragaeumannomyces bombycinus','Paragaeumannomyces bombycin',2,0,'','','T. J. Atk.|A. N. Mill.|Huhndorf|Réblová','859ab46b-a89c-5c72-b8c7-63fce4f2f30b','Paragaeumannomyces bombycinus (T.J. Atk., A.N. Mill. & Huhndorf) Réblová & A.N. Mill.','(T.J. Atk., A.N. Mill. & Huhndorf) Réblová & A.N. Mill.','SPECIES','','Paragaeumannomyces','','bombycinus','','','',NULL,'Réblová & A. N. Mill.','','','','','T. J. Atk., A. N. Mill. & Huhndorf','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08292685-28ed-4823-ad6d-9d762d680ca7','','','Limnothrix meffertae Anagn.',1,'Limnothrix meffertae','Limnothrix meffertae','Limnothrix meffert',2,0,'','','Anagn.','6d18cc92-ae40-5cde-929a-d3e2a40ddf98','Limnothrix meffertae Anagn.','Anagn.','SPECIES','','Limnothrix','','meffertae','','','',NULL,'','','','','','Anagn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0830e72d-e2a5-4151-89c4-a9b0c0974afb','','','Hydrocotyle novae-zeelandiae DC.',1,'Hydrocotyle novae-zeelandiae','Hydrocotyle novae-zeelandiae','Hydrocotyle nouae-zeelandi',2,0,'','','DC.','15520eb1-bf60-5925-b165-3fe6a4092dca','Hydrocotyle novae-zeelandiae DC.','DC.','SPECIES','','Hydrocotyle','','novae-zeelandiae','','','',NULL,'','','','','','DC.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0831ecc7-37cf-47ce-b227-0c4c5b299dd9','','','Apple leaf chlorosis and fruit distortion',4,'','','',NULL,NULL,'','','','','Apple leaf chlorosis and fruit distortion','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08351740-600d-46e6-adda-1e0b300bebfd','','','Carmichaelia juncea Colenso ex Hook.f.',1,'Carmichaelia juncea','Carmichaelia juncea','Carmichaelia iunce',2,0,'','','Colenso|Hook. fil.','61a0c209-f61d-5ebe-b2e0-f50121b9509d','Carmichaelia juncea Colenso ex Hook.f.','Colenso ex Hook.f.','SPECIES','','Carmichaelia','','juncea','','','',NULL,'','','','','','Colenso','','Hook. fil.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08333e62-7667-4aae-a119-5f4184aadf45','','','Cosmarium margaritatum (P.M.Lundell) Roy & Bisset',1,'Cosmarium margaritatum','Cosmarium margaritatum','Cosmarium margaritat',2,0,'','','P. M. Lundell|Roy|Bisset','1df68f19-afff-57a9-9fe5-0db1c4a82ea8','Cosmarium margaritatum (P.M.Lundell) Roy & Bisset','(P.M.Lundell) Roy & Bisset','SPECIES','','Cosmarium','','margaritatum','','','',NULL,'Roy & Bisset','','','','','P. M. Lundell','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('083502c5-8f65-48b8-b93e-cc8cf0666cee','','','Dinobryon balticum (Schütt) Moestrup',1,'Dinobryon balticum','Dinobryon balticum','Dinobryon baltic',2,0,'','','Schütt|Moestrup','02b815be-fdfe-536e-a165-81fb9e40dda6','Dinobryon balticum (Schütt) Moestrup','(Schütt) Moestrup','SPECIES','','Dinobryon','','balticum','','','',NULL,'Moestrup','','','','','Schütt','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('083cd59e-07d0-45bf-af81-4d118e7b10e6','','','Eucnemidae',1,'Eucnemidae','Eucnemidae','Eucnemidae',1,0,'','','','fc06c99b-3e87-568a-916a-80d387f05967','Eucnemidae','','FAMILY','Eucnemidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('083a5ba4-a76c-4edc-910f-72f1ce1e4ce3','','','Thelephora striata Fr.',1,'Thelephora striata','Thelephora striata','Thelephora striat',2,0,'','','Fr.','cbddd7fe-656a-5cc0-97d5-24e2e5f8e307','Thelephora striata Fr.','Fr.','SPECIES','','Thelephora','','striata','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0838586e-1188-4d76-89e8-8936cb20c11a','','','Acrolophozia R.M.Schust.',1,'Acrolophozia','Acrolophozia','Acrolophozia',1,0,'','','R. M. Schust.','570ed534-dc13-512e-9349-bf0640a29851','Acrolophozia R.M.Schust.','R.M.Schust.','GENUS','Acrolophozia','','','','','','',NULL,'','','','','','R. M. Schust.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('083bffcd-203e-4e1f-af28-ae113a923c15','','','Ostertagia leptospicularis Asadov, 1953',1,'Ostertagia leptospicularis','Ostertagia leptospicularis','Ostertagia leptospicular',2,0,'','','Asadov','255e9126-3b64-561d-9201-98096976fe8a','Ostertagia leptospicularis Asadov, 1953','Asadov, 1953','SPECIES','','Ostertagia','','leptospicularis','','','',NULL,'','','','','','Asadov','','','','1953','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0839165c-0574-41fc-af5c-fc26076c146d','','','Olearia cymbifolia (Hook.f.) Cheeseman',1,'Olearia cymbifolia','Olearia cymbifolia','Olearia cymbifol',2,0,'','','Hook. fil.|Cheeseman','3f2902da-0263-5553-82fd-8e0caaa624b3','Olearia cymbifolia (Hook.f.) Cheeseman','(Hook.f.) Cheeseman','SPECIES','','Olearia','','cymbifolia','','','',NULL,'Cheeseman','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08415a11-f9cc-463a-9320-5ae436f4aeae','','','Gen. nov. 2 species 2 B175',NULL,'','','',NULL,NULL,'','','','','Gen. nov. 2 species 2 B175','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0846bbc7-b533-45f7-bf68-620d29101aff','','','Sastrapada nigrolineata Distant, 1920',1,'Sastrapada nigrolineata','Sastrapada nigrolineata','Sastrapada nigrolineat',2,0,'','','Distant','9b1e5c2a-197a-5063-ac0b-5f037f0b2246','Sastrapada nigrolineata Distant, 1920','Distant, 1920','SPECIES','','Sastrapada','','nigrolineata','','','',NULL,'','','','','','Distant','','','','1920','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0846df0d-5270-4296-963b-9d9d729795ce','','','Distichophyllum pulchellum (Hampe) Mitt. var. pulchellum (Hampe in Müll.Hal.)',2,'Distichophyllum pulchellum pulchellum','Distichophyllum pulchellum var. pulchellum','Distichophyllum pulchell pulchell',3,0,'','','Hampe|Müll. Hal.','c29ba686-10e5-5991-866e-65a39f4efe63','Distichophyllum pulchellum (Hampe) Mitt. var. pulchellum (Hampe in Müll.Hal.)','(Hampe in Müll.Hal.)','VARIETY','','Distichophyllum','','pulchellum','pulchellum','','',NULL,'','','','','','Hampe','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('084f5e47-3e53-42cd-a041-5499e818c818','','','Postia caesia (Schrad.) P. Karst.',1,'Postia caesia','Postia caesia','Postia caes',2,0,'','','Schrad.|P. Karst.','60c5ef03-1c47-5a9b-8341-15bccf779e77','Postia caesia (Schrad.) P. Karst.','(Schrad.) P. Karst.','SPECIES','','Postia','','caesia','','','',NULL,'P. Karst.','','','','','Schrad.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('084d79da-8d01-4a01-930a-673e881ea5f6','','','Odontria nesobia Broun, 1921',1,'Odontria nesobia','Odontria nesobia','Odontria nesob',2,0,'','','Broun','625676e5-a23d-5a3e-a746-df451ef746f4','Odontria nesobia Broun, 1921','Broun, 1921','SPECIES','','Odontria','','nesobia','','','',NULL,'','','','','','Broun','','','','1921','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('085138dd-4b0f-41a5-9087-d7612a1290a7','','','Sytus Blackwelder, 1952',1,'Sytus','Sytus','Sytus',1,0,'','','Blackwelder','a266ff70-8ddf-5305-93fa-b66f35a3fa37','Sytus Blackwelder, 1952','Blackwelder, 1952','GENUS','Sytus','','','','','','',NULL,'','','','','','Blackwelder','','','','1952','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08533091-f803-4c97-beb8-23be8a13bb2e','','','Pohlia humilis (Mont.) Broth.',1,'Pohlia humilis','Pohlia humilis','Pohlia humil',2,0,'','','Mont.|Broth.','4ecab9b3-12a4-536f-88b3-940eb2423da0','Pohlia humilis (Mont.) Broth.','(Mont.) Broth.','SPECIES','','Pohlia','','humilis','','','',NULL,'Broth.','','','','','Mont.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0854e634-b8b4-40ad-af19-5d3a14f07040','','','Favosipora candida Gordon & Taylor, 2001',1,'Favosipora candida','Favosipora candida','Favosipora candid',2,0,'','','Gordon|Taylor','1d6ca8c0-92b6-557e-80df-0291709dfd96','Favosipora candida Gordon & Taylor, 2001','Gordon & Taylor, 2001','SPECIES','','Favosipora','','candida','','','',NULL,'','','','','','Gordon & Taylor','','','','2001','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0855781b-4339-4ad9-a8e6-b718a91af3c9','','','Tetrasporales',1,'Tetrasporales','Tetrasporales','Tetrasporales',1,0,'','','','725f9b95-f4af-50e4-bfde-ea197534abed','Tetrasporales','','ORDER','Tetrasporales','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08567fff-78d0-41f1-92c0-c628bbc85c1d','','','Lecanora varia (Hoffm.) Ach.',1,'Lecanora varia','Lecanora varia','Lecanora uar',2,0,'','','Hoffm.|Ach.','7e85a00f-79cf-57aa-84d6-ddd71db095cb','Lecanora varia (Hoffm.) Ach.','(Hoffm.) Ach.','SPECIES','','Lecanora','','varia','','','',NULL,'Ach.','','','','','Hoffm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('085e1f7a-a39a-4bf4-9b80-300960c54034','','','Phaeosphaeria nigrans (Desm.) L. Holm',1,'Phaeosphaeria nigrans','Phaeosphaeria nigrans','Phaeosphaeria nigrans',2,0,'','','Desm.|L. Holm','8b93d18c-befc-5a22-80a3-3cfff7f0f781','Phaeosphaeria nigrans (Desm.) L. Holm','(Desm.) L. Holm','SPECIES','','Phaeosphaeria','','nigrans','','','',NULL,'L. Holm','','','','','Desm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('085af771-e449-4ccf-acf0-73df9889fc1f','','','Tanybyrsa cumberi Drake, 1959',1,'Tanybyrsa cumberi','Tanybyrsa cumberi','Tanybyrsa cumber',2,0,'','','Drake','6ed95e0f-6678-5512-84db-0a82bbffec0e','Tanybyrsa cumberi Drake, 1959','Drake, 1959','SPECIES','','Tanybyrsa','','cumberi','','','',NULL,'','','','','','Drake','','','','1959','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('085e7785-c45a-4e59-9e3e-3462c126af67','','','Pinus contorta subsp. latifolia (Engelm. ex S.Watson) Critchf.',1,'Pinus contorta latifolia','Pinus contorta subsp. latifolia','Pinus contort latifol',3,0,'','','Engelm.|S. Watson|Critchf.','65244c72-9ff4-5873-8bf2-a263eb296da9','Pinus contorta subsp. latifolia (Engelm. ex S.Watson) Critchf.','(Engelm. ex S.Watson) Critchf.','SUBSPECIES','','Pinus','','contorta','latifolia','','',NULL,'Critchf.','','','','','Engelm.','','S. Watson','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08665075-9633-4acf-a08b-8684bee8454f','','','Angiopsora Mains',1,'Angiopsora','Angiopsora','Angiopsora',1,0,'','','Mains','86ac9dda-d1d7-5fe7-87fb-bc6ec7ff60b8','Angiopsora Mains','Mains','GENUS','Angiopsora','','','','','','',NULL,'','','','','','Mains','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08626e7d-92b0-4d5e-8e48-d05aa74cbe03','','','Circoxena ditrocha Meyrick, 1916',1,'Circoxena ditrocha','Circoxena ditrocha','Circoxena ditroch',2,0,'','','Meyrick','001d8055-88b0-5a8a-b333-d722a88bdab6','Circoxena ditrocha Meyrick, 1916','Meyrick, 1916','SPECIES','','Circoxena','','ditrocha','','','',NULL,'','','','','','Meyrick','','','','1916','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('086a2688-fdd3-4ef6-b656-3f90c40ebe1a','','','Aceria victoriae Ramsay, 1958',1,'Aceria victoriae','Aceria victoriae','Aceria uictori',2,0,'','','Ramsay','7e5352e2-2891-5bcb-b7e6-6aae55413d16','Aceria victoriae Ramsay, 1958','Ramsay, 1958','SPECIES','','Aceria','','victoriae','','','',NULL,'','','','','','Ramsay','','','','1958','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('086ee4e6-c8f2-4cc9-9382-6e05b8f91813','','','Ficopomatus',1,'Ficopomatus','Ficopomatus','Ficopomatus',1,0,'','','','9a5aeede-11b9-5fc9-b774-9b24ab5754e9','Ficopomatus','','GENUS','Ficopomatus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('086a008d-83ed-4ad4-9d8b-83808f142666','','','Ceratium Alb. & Schwein.',1,'Ceratium','Ceratium','Ceratium',1,0,'','','Alb.|Schwein.','8be487f4-679c-57e6-9c0e-78cd4d8adc6c','Ceratium Alb. & Schwein.','Alb. & Schwein.','GENUS','Ceratium','','','','','','',NULL,'','','','','','Alb. & Schwein.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0868dc51-2979-42af-b655-eb5e029d7e96','','','Graphina contorta Müll.Arg.',1,'Graphina contorta','Graphina contorta','Graphina contort',2,0,'','','Müll. Arg.','d24c4305-751d-5b92-95e6-3d9dce8bfcea','Graphina contorta Müll.Arg.','Müll.Arg.','SPECIES','','Graphina','','contorta','','','',NULL,'','','','','','Müll. Arg.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0872ce2c-5742-42ab-84bc-13d6cb0a1924','','','Paragorgia wahine Sanchez, 2005',1,'Paragorgia wahine','Paragorgia wahine','Paragorgia wahin',2,0,'','','Sanchez','d0f67dd5-af54-573b-a6ba-54af06a8a136','Paragorgia wahine Sanchez, 2005','Sanchez, 2005','SPECIES','','Paragorgia','','wahine','','','',NULL,'','','','','','Sanchez','','','','2005','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08731f1e-4651-4669-a13d-3fe80044a9db','','','Nephroma helveticum Ach.',1,'Nephroma helveticum','Nephroma helveticum','Nephroma heluetic',2,0,'','','Ach.','ed49e69f-3b20-5efb-b115-4115f582e69c','Nephroma helveticum Ach.','Ach.','SPECIES','','Nephroma','','helveticum','','','',NULL,'','','','','','Ach.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('087198a6-e256-486d-ac54-76980b806f59','','','Siboglinum species XI Ivanov, 1960',4,'','','',NULL,NULL,'','','','','Siboglinum species XI Ivanov, 1960','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08723759-9e1b-4917-ab33-8e2ecaee7963','','','Pythium graminicola Subraman.',1,'Pythium graminicola','Pythium graminicola','Pythium graminicol',2,0,'','','Subraman.','7b445136-82c6-52ab-8691-3c4dd6e0db85','Pythium graminicola Subraman.','Subraman.','SPECIES','','Pythium','','graminicola','','','',NULL,'','','','','','Subraman.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07509faa-f1f5-405f-bffb-090e8508bab7','','','Netelia',1,'Netelia','Netelia','Netelia',1,0,'','','','71271a7d-0551-5a27-b567-6d3af62420c2','Netelia','','GENUS','Netelia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('074f6c15-d550-4aa4-b78f-316df85b0f3a','','','Uncinia horizontalis Colenso',1,'Uncinia horizontalis','Uncinia horizontalis','Uncinia horizontal',2,0,'','','Colenso','586dda00-417b-57af-bcb3-204f33a7453a','Uncinia horizontalis Colenso','Colenso','SPECIES','','Uncinia','','horizontalis','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0755337b-7561-4ffa-921b-5a1c8b84ca79','','','Ctenolimnophila brevitarsis (Alexander, 1926)',1,'Ctenolimnophila brevitarsis','Ctenolimnophila brevitarsis','Ctenolimnophila breuitars',2,0,'','','Alexander','636ceae1-c88c-5932-a8d7-66be0b946f67','Ctenolimnophila brevitarsis (Alexander, 1926)','(Alexander, 1926)','SPECIES','','Ctenolimnophila','','brevitarsis','','','',NULL,'','','','','','Alexander','','','','1926','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0754a0b4-954c-49bf-b337-a209917aa54d','','','Diachorella hedysari (Scalia) Petr.',1,'Diachorella hedysari','Diachorella hedysari','Diachorella hedysar',2,0,'','','Scalia|Petr.','55f9d0e5-3831-59d6-ab38-429e4b615303','Diachorella hedysari (Scalia) Petr.','(Scalia) Petr.','SPECIES','','Diachorella','','hedysari','','','',NULL,'Petr.','','','','','Scalia','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('075823f1-461b-4bf2-80c9-131ed9b730ab','','','Parkermavella species 3 Tan0205/64',4,'','','',NULL,NULL,'','','','','Parkermavella species 3 Tan0205/64','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07583c96-e024-486e-8af4-3242ae1c08db','','','Mahonia japonica (Thunb.) DC.',1,'Mahonia japonica','Mahonia japonica','Mahonia iaponic',2,0,'','','Thunb.|DC.','aad4eb9d-7d64-50f1-b330-3820aa6f1d40','Mahonia japonica (Thunb.) DC.','(Thunb.) DC.','SPECIES','','Mahonia','','japonica','','','',NULL,'DC.','','','','','Thunb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0756ebfc-d9f9-4469-ab50-a687039e4072','','','Selliera rotundifolia Heenan',1,'Selliera rotundifolia','Selliera rotundifolia','Selliera rotundifol',2,0,'','','Heenan','be15a59f-99ab-5841-bc65-3abd9ffd4b34','Selliera rotundifolia Heenan','Heenan','SPECIES','','Selliera','','rotundifolia','','','',NULL,'','','','','','Heenan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0759959f-c66e-4868-877e-bd677d2fcdc1','','','Ophiostoma species A sensu G.H. Kim, J.J. Kim, Y.W. Lim & C. Breuil',4,'','','',NULL,NULL,'','','','','Ophiostoma species A sensu G.H. Kim, J.J. Kim, Y.W. Lim & C. Breuil','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0756f92e-821c-41f3-bc5f-e6b1592a5734','','','Synopeas',1,'Synopeas','Synopeas','Synopeas',1,0,'','','','5ad0ce71-ea55-57d2-a9ee-1bb56d0e3880','Synopeas','','GENUS','Synopeas','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07604559-1273-41f9-807b-0cbe8509e923','','','Bombus subg. Bombus',2,'Bombus','Bombus subgen. Bombus','Bombus',1,0,'','','','2efdcf99-9b3e-5127-9b94-3b7476cf4e4e','Bombus subg. Bombus','','SUBGENUS','Bombus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('075d3d8f-d486-4336-92cc-48d1e7028d62','','','Trichodontium falcatum (R.Br.bis) Fife',1,'Trichodontium falcatum','Trichodontium falcatum','Trichodontium falcat',2,0,'','','R. Br. bis|Fife','3e5ab61b-30a8-511f-995f-67ad88762eee','Trichodontium falcatum (R.Br.bis) Fife','(R.Br.bis) Fife','SPECIES','','Trichodontium','','falcatum','','','',NULL,'Fife','','','','','R. Br. bis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('075fe2b0-57e6-4aa1-b292-c4963d713981','','','Baeostethus chiltoni Broun, 1909',1,'Baeostethus chiltoni','Baeostethus chiltoni','Baeostethus chilton',2,0,'','','Broun','d8a41abd-560b-57ac-8631-0af9522d3028','Baeostethus chiltoni Broun, 1909','Broun, 1909','SPECIES','','Baeostethus','','chiltoni','','','',NULL,'','','','','','Broun','','','','1909','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('075f69da-30a2-47da-9dcc-dc77e26fcbe5','','','Lichen squamosus Scop.',1,'Lichen squamosus','Lichen squamosus','Lichen squamos',2,0,'','','Scop.','5ba949e1-7f44-5615-b24c-2ced244317e3','Lichen squamosus Scop.','Scop.','SPECIES','','Lichen','','squamosus','','','',NULL,'','','','','','Scop.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0761f907-9497-42cb-bba0-0b6e820a4685','','','Curtuteria',1,'Curtuteria','Curtuteria','Curtuteria',1,0,'','','','5de4f0ff-f486-52c1-a20f-14de7ef92551','Curtuteria','','GENUS','Curtuteria','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0761d2a9-db6c-4558-94e7-5a93d9ed7dd1','','','Calycellina Höhn.',1,'Calycellina','Calycellina','Calycellina',1,0,'','','Höhn.','34254933-38f9-5e8d-b785-55c7633aa056','Calycellina Höhn.','Höhn.','GENUS','Calycellina','','','','','','',NULL,'','','','','','Höhn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0767c7e8-543e-41f1-9756-ae1ea9f41122','','','Mycosphaerella zeae-maydis Mukunya & Boothr.',1,'Mycosphaerella zeae-maydis','Mycosphaerella zeae-maydis','Mycosphaerella zeae-mayd',2,0,'','','Mukunya|Boothr.','e1116e7d-785a-5efa-a6ca-9bd0d91072cd','Mycosphaerella zeae-maydis Mukunya & Boothr.','Mukunya & Boothr.','SPECIES','','Mycosphaerella','','zeae-maydis','','','',NULL,'','','','','','Mukunya & Boothr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0767898e-fdba-4c55-b330-d3a6d73ca147','','','Dracaena bacularis (Pfennig ex A.Butler & Jankalski) Byng & Christenh.',1,'Dracaena bacularis','Dracaena bacularis','Dracaena bacular',2,0,'','','Pfennig|A. Butler|Jankalski|Byng|Christenh.','b2b27f97-97a1-5ab9-a43d-2f20bcc94984','Dracaena bacularis (Pfennig ex A.Butler & Jankalski) Byng & Christenh.','(Pfennig ex A.Butler & Jankalski) Byng & Christenh.','SPECIES','','Dracaena','','bacularis','','','',NULL,'Byng & Christenh.','','','','','Pfennig','','A. Butler & Jankalski','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('076cbc93-8f60-40be-bac9-318c9bbb553a','','','Sciacharis paralatuliceps (Franz, 1975)',1,'Sciacharis paralatuliceps','Sciacharis paralatuliceps','Sciacharis paralatuliceps',2,0,'','','Franz','edc7d088-8551-5064-a8fa-da55aafec795','Sciacharis paralatuliceps (Franz, 1975)','(Franz, 1975)','SPECIES','','Sciacharis','','paralatuliceps','','','',NULL,'','','','','','Franz','','','','1975','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('076e1867-5500-4f75-8667-b3b04919d369','','','Hormiscium dermatitidis Kano',1,'Hormiscium dermatitidis','Hormiscium dermatitidis','Hormiscium dermatitid',2,0,'','','Kano','008c08cc-6ed4-5075-9609-3714f2dc0207','Hormiscium dermatitidis Kano','Kano','SPECIES','','Hormiscium','','dermatitidis','','','',NULL,'','','','','','Kano','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07709bb3-1849-46dd-9667-e93969bc6f5b','','','Acerentulus',1,'Acerentulus','Acerentulus','Acerentulus',1,0,'','','','188b4e4f-21c0-5fe0-8664-b0db2f127213','Acerentulus','','GENUS','Acerentulus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0774559a-cb6a-4227-a20f-0930e0b3cbb7','','','Pyrenophora biseptata (Sacc. & Roum.) Crous',1,'Pyrenophora biseptata','Pyrenophora biseptata','Pyrenophora biseptat',2,0,'','','Sacc.|Roum.|Crous','f76bcbe5-4c01-505d-8de3-67d59e35f9e5','Pyrenophora biseptata (Sacc. & Roum.) Crous','(Sacc. & Roum.) Crous','SPECIES','','Pyrenophora','','biseptata','','','',NULL,'Crous','','','','','Sacc. & Roum.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07767ee7-1582-482c-b033-548dd694fe3f','','','Gonichthys',1,'Gonichthys','Gonichthys','Gonichthys',1,0,'','','','795c22ed-f694-579c-988f-b38d6735692d','Gonichthys','','GENUS','Gonichthys','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0777d80e-9db6-4213-a4c4-8a0ed96d68c9','','','Depazea Fr.',1,'Depazea','Depazea','Depazea',1,0,'','','Fr.','d74ba9f7-0129-5220-92a0-468b587b1d80','Depazea Fr.','Fr.','GENUS','Depazea','','','','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0775e7f3-b2df-4ffd-90ee-c23ec8b1589a','','','Smardaea planchonis (Dunal ex Boud.) Korf & W.Y. Zhunag',1,'Smardaea planchonis','Smardaea planchonis','Smardaea planchon',2,0,'','','Dunal|Boud.|Korf|W. Y. Zhunag','12b40949-2aa8-5c14-8090-9710c9f399dc','Smardaea planchonis (Dunal ex Boud.) Korf & W.Y. Zhunag','(Dunal ex Boud.) Korf & W.Y. Zhunag','SPECIES','','Smardaea','','planchonis','','','',NULL,'Korf & W. Y. Zhunag','','','','','Dunal','','Boud.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('077d11a2-f73a-462b-8ded-211179bc46fe','','','Anopsolobus subterraneus Forster & Platnick, 1985',1,'Anopsolobus subterraneus','Anopsolobus subterraneus','Anopsolobus subterrane',2,0,'','','Forster|Platnick','f8824130-a6ef-5177-8afd-a08cbc129461','Anopsolobus subterraneus Forster & Platnick, 1985','Forster & Platnick, 1985','SPECIES','','Anopsolobus','','subterraneus','','','',NULL,'','','','','','Forster & Platnick','','','','1985','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('077bb28c-45b7-4b7c-bc8a-b1b1fa078eac','','','Comovirus',NULL,'','','',NULL,NULL,'','','','','Comovirus','','GENUS','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0780de6d-3c65-4c06-a22d-b3319ea3a665','','','Hebe diosmifolia (A.Cunn.) Andersen',1,'Hebe diosmifolia','Hebe diosmifolia','Hebe diosmifol',2,0,'','','A. Cunn.|Andersen','39378572-a93a-5e66-b0dd-cce18b327765','Hebe diosmifolia (A.Cunn.) Andersen','(A.Cunn.) Andersen','SPECIES','','Hebe','','diosmifolia','','','',NULL,'Andersen','','','','','A. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('077985c1-ff0b-4b4a-8883-f824daf3bfe0','','','Mycena helminthobasis var. novae-zelandiae E. Horak',1,'Mycena helminthobasis novae-zelandiae','Mycena helminthobasis var. novae-zelandiae','Mycena helminthobas nouae-zelandi',3,0,'','','E. Horak','a0c7aa6c-ec6c-57db-8f11-6341d3992df8','Mycena helminthobasis var. novae-zelandiae E. Horak','E. Horak','VARIETY','','Mycena','','helminthobasis','novae-zelandiae','','',NULL,'','','','','','E. Horak','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07876cc0-9cb0-408d-ad51-aa6690f726b3','','','Parawaldeckia hirsuta Lowry & Stoddart, 1983',1,'Parawaldeckia hirsuta','Parawaldeckia hirsuta','Parawaldeckia hirsut',2,0,'','','Lowry|Stoddart','ca28c479-4dbb-5559-9c56-b1f05e0c7b10','Parawaldeckia hirsuta Lowry & Stoddart, 1983','Lowry & Stoddart, 1983','SPECIES','','Parawaldeckia','','hirsuta','','','',NULL,'','','','','','Lowry & Stoddart','','','','1983','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0788fc94-3d66-4c0c-9bf6-f3090f017223','','','Cheilotrichia Rossi, 1848',1,'Cheilotrichia','Cheilotrichia','Cheilotrichia',1,0,'','','Rossi','474b240f-2623-5253-b6f8-c48b5d4b61fd','Cheilotrichia Rossi, 1848','Rossi, 1848','GENUS','Cheilotrichia','','','','','','',NULL,'','','','','','Rossi','','','','1848','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('078dce76-b906-4fdd-8a0f-432db2fee278','','','Neobakeria angustifolia (L.f.) Schltr.',1,'Neobakeria angustifolia','Neobakeria angustifolia','Neobakeria angustifol',2,0,'','','L. fil.|Schltr.','6a2496d0-97e0-5fc9-b93c-6c08a0827b47','Neobakeria angustifolia (L.f.) Schltr.','(L.f.) Schltr.','SPECIES','','Neobakeria','','angustifolia','','','',NULL,'Schltr.','','','','','L. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('078def97-833e-4e02-9645-71a651ccaa83','','','Gymnodinium simplex lohmann',1,'Gymnodinium simplex lohmann','Gymnodinium simplex lohmann','Gymnodinium simplex lohmann',3,0,'','','','77f47a98-7115-579b-a9a7-1692715fecce','Gymnodinium simplex lohmann','','SPECIES','','Gymnodinium','','simplex','lohmann','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('078e2d40-2fff-428a-b9f8-84a1212f0206','','','Sordaria alcina N. Lundq.',1,'Sordaria alcina','Sordaria alcina','Sordaria alcin',2,0,'','','N. Lundq.','2326276b-f577-5a1e-9157-28957602f75f','Sordaria alcina N. Lundq.','N. Lundq.','SPECIES','','Sordaria','','alcina','','','',NULL,'','','','','','N. Lundq.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07898922-de4c-43b8-bcb8-b6f83159e6f2','','','Nitella opaca (Bruzelius) Agardh',1,'Nitella opaca','Nitella opaca','Nitella opac',2,0,'','','Bruzelius|Agardh','24b68b76-057f-5bb0-a0bd-608d8b9f2ac3','Nitella opaca (Bruzelius) Agardh','(Bruzelius) Agardh','SPECIES','','Nitella','','opaca','','','',NULL,'Agardh','','','','','Bruzelius','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('078c9fc8-3f3a-459a-b93b-fae1af040706','','','Hendea myersi assimilis Forster, 1954',1,'Hendea myersi assimilis','Hendea myersi assimilis','Hendea myers assimil',3,0,'','','Forster','af51b3fb-e40c-5a3e-ab9f-1e761273ead3','Hendea myersi assimilis Forster, 1954','Forster, 1954','SUBSPECIES','','Hendea','','myersi','assimilis','','',NULL,'','','','','','Forster','','','','1954','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0794a943-bccb-4055-ad84-3a6f8549294a','','','Cercyodes laevigatus Broun, 1886',1,'Cercyodes laevigatus','Cercyodes laevigatus','Cercyodes laeuigat',2,0,'','','Broun','fbd76a2c-38f2-5e36-9b46-95fb05743009','Cercyodes laevigatus Broun, 1886','Broun, 1886','SPECIES','','Cercyodes','','laevigatus','','','',NULL,'','','','','','Broun','','','','1886','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('07928feb-e130-4c26-99e7-a17a44322164','','','Acremonium arenarium Petch',1,'Acremonium arenarium','Acremonium arenarium','Acremonium arenari',2,0,'','','Petch','5532b914-9763-5494-979a-ef6ac8dd10c0','Acremonium arenarium Petch','Petch','SPECIES','','Acremonium','','arenarium','','','',NULL,'','','','','','Petch','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0791a3dc-e059-4079-825b-ef8115d60483','','','Hippocrepinellidae',1,'Hippocrepinellidae','Hippocrepinellidae','Hippocrepinellidae',1,0,'','','','5791361a-16f0-53f3-beb1-405a2dde9ceb','Hippocrepinellidae','','FAMILY','Hippocrepinellidae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08772be6-8b66-4cc8-887b-04aaa906d298','','','Sphaeria larvarum Westwood',1,'Sphaeria larvarum','Sphaeria larvarum','Sphaeria laruar',2,0,'','','Westwood','5c69e642-2615-5052-bb55-053b79beb76b','Sphaeria larvarum Westwood','Westwood','SPECIES','','Sphaeria','','larvarum','','','',NULL,'','','','','','Westwood','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('087c508e-46c0-4f63-a511-65cdc180dd63','','','Flosculomyces B. Sutton',1,'Flosculomyces','Flosculomyces','Flosculomyces',1,0,'','','B. Sutton','90f1f0cf-a123-5c0b-9b4a-f8204a4fda81','Flosculomyces B. Sutton','B. Sutton','GENUS','Flosculomyces','','','','','','',NULL,'','','','','','B. Sutton','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('087a12a1-5d22-4ad4-a48f-a98fb4bda78c','','','Sciacharis (Sciacharis) hokianoae (Franz, 1975)',1,'Sciacharis hokianoae','Sciacharis hokianoae','Sciacharis hokiano',2,0,'','','Franz','11e11ab4-5459-5204-8aa4-f68a4c636e0a','Sciacharis (Sciacharis) hokianoae (Franz, 1975)','(Franz, 1975)','SPECIES','','Sciacharis','Sciacharis','hokianoae','','','',NULL,'','','','','','Franz','','','','1975','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('087ec6bf-51c7-4c1a-abab-ce048767bfce','','','Echiodon cryomargarites Markle, Williams & Olney, 1983',1,'Echiodon cryomargarites','Echiodon cryomargarites','Echiodon cryomargarit',2,0,'','','Markle|Williams|Olney','cf87c5d7-6da5-52fd-8405-828d70f96ee2','Echiodon cryomargarites Markle, Williams & Olney, 1983','Markle, Williams & Olney, 1983','SPECIES','','Echiodon','','cryomargarites','','','',NULL,'','','','','','Markle, Williams & Olney','','','','1983','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08810caf-8bfe-4b36-81c1-37f70cab6d79','','','Verrucaria fissa Taylor',1,'Verrucaria fissa','Verrucaria fissa','Verrucaria fiss',2,0,'','','Taylor','2bdfcf42-3d67-51a0-b500-c1851766ca86','Verrucaria fissa Taylor','Taylor','SPECIES','','Verrucaria','','fissa','','','',NULL,'','','','','','Taylor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0883e1bf-f39b-41bc-a813-9cf565a09f5a','','','Limacinia phloiophilia E.E. Fisher',1,'Limacinia phloiophilia','Limacinia phloiophilia','Limacinia phloiophil',2,0,'','','E. E. Fisher','a3bd2219-6f8f-5ed4-8c94-d9965d556f6f','Limacinia phloiophilia E.E. Fisher','E.E. Fisher','SPECIES','','Limacinia','','phloiophilia','','','',NULL,'','','','','','E. E. Fisher','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0885aa08-5c78-4d37-9ef7-f6be054aae57','','','Eballistra lineata (Cooke) R. Bauer, Begerow, A. Nagler & Oberw.',1,'Eballistra lineata','Eballistra lineata','Eballistra lineat',2,0,'','','Cooke|R. Bauer|Begerow|A. Nagler|Oberw.','acff87c5-5f29-514f-9af2-639d52a4baed','Eballistra lineata (Cooke) R. Bauer, Begerow, A. Nagler & Oberw.','(Cooke) R. Bauer, Begerow, A. Nagler & Oberw.','SPECIES','','Eballistra','','lineata','','','',NULL,'R. Bauer, Begerow, A. Nagler & Oberw.','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('088b4c9c-b89d-4515-b81b-446d8b3df456','','','Naemaspora chrysosperma Pers.',1,'Naemaspora chrysosperma','Naemaspora chrysosperma','Naemaspora chrysosperm',2,0,'','','Pers.','f748a296-3b21-5ce6-bcb0-06ae9425c5f2','Naemaspora chrysosperma Pers.','Pers.','SPECIES','','Naemaspora','','chrysosperma','','','',NULL,'','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('088c49e5-6eb7-48f0-bfcc-ac0b9102c949','','','Thelymitra angustifolia Hook.f.',1,'Thelymitra angustifolia','Thelymitra angustifolia','Thelymitra angustifol',2,0,'','','Hook. fil.','fb21b2d2-1029-55e6-9b61-1edbabe0ec25','Thelymitra angustifolia Hook.f.','Hook.f.','SPECIES','','Thelymitra','','angustifolia','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('088971c3-8f73-4537-9a52-e23a3c64acd8','','','Thaxteriella pezizula (Berk. & M.A. Curtis) Petr.',1,'Thaxteriella pezizula','Thaxteriella pezizula','Thaxteriella pezizul',2,0,'','','Berk.|M. A. Curtis|Petr.','3ae08198-9564-5215-b382-9725816ce6bc','Thaxteriella pezizula (Berk. & M.A. Curtis) Petr.','(Berk. & M.A. Curtis) Petr.','SPECIES','','Thaxteriella','','pezizula','','','',NULL,'Petr.','','','','','Berk. & M. A. Curtis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08937ad4-6863-443e-9e0d-6a81083091a1','','','Lusius',1,'Lusius','Lusius','Lusius',1,0,'','','','ecae7d5c-9fdb-5c05-9cfe-e28fc4279855','Lusius','','GENUS','Lusius','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('088eca31-c9ff-4900-b7b9-73c2f48407f8','','','Mougeotia',1,'Mougeotia','Mougeotia','Mougeotia',1,0,'','','','150ceffb-491c-5400-b012-f6a31653e167','Mougeotia','','GENUS','Mougeotia','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('088d8bca-5d18-4361-a08d-77a31a44c0a2','','','Dolichotetranychus ancistrus Baker & Pritchard, 1956',1,'Dolichotetranychus ancistrus','Dolichotetranychus ancistrus','Dolichotetranychus ancistr',2,0,'','','Baker|Pritchard','d8bfbad4-a969-56ce-8ed3-c3805ee311e2','Dolichotetranychus ancistrus Baker & Pritchard, 1956','Baker & Pritchard, 1956','SPECIES','','Dolichotetranychus','','ancistrus','','','',NULL,'','','','','','Baker & Pritchard','','','','1956','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('089469c7-9dce-4887-a9ef-05743d1df86f','','','Scutuloidea kutu Stephenson & Riley, 1996',1,'Scutuloidea kutu','Scutuloidea kutu','Scutuloidea kut',2,0,'','','Stephenson|Riley','3ad19c50-e2a4-5878-ae6f-f9a462add9bf','Scutuloidea kutu Stephenson & Riley, 1996','Stephenson & Riley, 1996','SPECIES','','Scutuloidea','','kutu','','','',NULL,'','','','','','Stephenson & Riley','','','','1996','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08966e05-83e1-4ae2-8c29-4baf2c54024d','','','Sporadopora micropora Cairns, 1991',1,'Sporadopora micropora','Sporadopora micropora','Sporadopora micropor',2,0,'','','Cairns','7d4bbbe3-3beb-5273-9d86-266c00936eeb','Sporadopora micropora Cairns, 1991','Cairns, 1991','SPECIES','','Sporadopora','','micropora','','','',NULL,'','','','','','Cairns','','','','1991','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('089df86a-3119-4d4e-a589-ba5de84d147c','','','Platydyptes amiesi Marples',1,'Platydyptes amiesi','Platydyptes amiesi','Platydyptes amies',2,0,'','','Marples','6ef3ffe8-d990-5189-80fe-a9b98ef34ad3','Platydyptes amiesi Marples','Marples','SPECIES','','Platydyptes','','amiesi','','','',NULL,'','','','','','Marples','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08991366-b3d9-41e8-a9f8-db456d423faf','','','Opius',1,'Opius','Opius','Opius',1,0,'','','','4c29eebf-fb5c-5d55-b0bb-7f3533078795','Opius','','GENUS','Opius','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08a382d4-5df4-4d58-a2bb-0920bd7a4242','','','Spongiobranchea australis d''Orbigny, 1836',1,'Spongiobranchea australis','Spongiobranchea australis','Spongiobranchea austral',2,0,'','','d''Orbigny','e8e947f1-bb8f-58db-8a2a-a2912af23997','Spongiobranchea australis d''Orbigny, 1836','d''Orbigny, 1836','SPECIES','','Spongiobranchea','','australis','','','',NULL,'','','','','','d''Orbigny','','','','1836','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('089ffbad-3393-4bdc-99cf-707aa5e1e80d','','','Ingella bullager Hammer, 1967',1,'Ingella bullager','Ingella bullager','Ingella bullager',2,0,'','','Hammer','ffc5a955-cf32-5b22-a668-ed80fa50bd12','Ingella bullager Hammer, 1967','Hammer, 1967','SPECIES','','Ingella','','bullager','','','',NULL,'','','','','','Hammer','','','','1967','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('089f04e2-b2c5-4a3a-910d-c76da22eca59','','','Mycena avellanea Murrill',1,'Mycena avellanea','Mycena avellanea','Mycena auellane',2,0,'','','Murrill','8a94274e-4bfd-5029-b6f7-70cc91e78c03','Mycena avellanea Murrill','Murrill','SPECIES','','Mycena','','avellanea','','','',NULL,'','','','','','Murrill','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08a49c46-1cb1-496f-8a32-ca53045b2e98','','','Nepticula ogygia Meyrick, 1889',1,'Nepticula ogygia','Nepticula ogygia','Nepticula ogyg',2,0,'','','Meyrick','99a51232-c2c1-5419-9868-a3f62e9a2363','Nepticula ogygia Meyrick, 1889','Meyrick, 1889','SPECIES','','Nepticula','','ogygia','','','',NULL,'','','','','','Meyrick','','','','1889','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08a84f18-4943-4337-a5b0-17272c50cbc3','','','Chaetocerotaceae',1,'Chaetocerotaceae','Chaetocerotaceae','Chaetocerotaceae',1,0,'','','','06917e82-2c94-5282-9b65-454f4b71042c','Chaetocerotaceae','','FAMILY','Chaetocerotaceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08a51c1d-5209-4a18-956a-553954013793','','','Hakaharpalus maddisoni Larochelle & Lariviere, 2005',1,'Hakaharpalus maddisoni','Hakaharpalus maddisoni','Hakaharpalus maddison',2,0,'','','Larochelle|Lariviere','3ca88a89-c9bb-550b-a79c-790b343c112f','Hakaharpalus maddisoni Larochelle & Lariviere, 2005','Larochelle & Lariviere, 2005','SPECIES','','Hakaharpalus','','maddisoni','','','',NULL,'','','','','','Larochelle & Lariviere','','','','2005','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08a5326b-806d-4225-8654-993a23eb4084','','','Litschauerella abietis (Bourdot & Galzin) Oberw. ex Jülich',1,'Litschauerella abietis','Litschauerella abietis','Litschauerella abiet',2,0,'','','Bourdot|Galzin|Oberw.|Jülich','f11d3263-1efe-5b0c-adc8-e7e4ce7f9279','Litschauerella abietis (Bourdot & Galzin) Oberw. ex Jülich','(Bourdot & Galzin) Oberw. ex Jülich','SPECIES','','Litschauerella','','abietis','','','',NULL,'Oberw.','','Jülich','','','Bourdot & Galzin','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08aadc9e-5f72-41a8-9aee-faced40a3ed4','','','Nemadactylus douglasii (Hector, 1875)',1,'Nemadactylus douglasii','Nemadactylus douglasii','Nemadactylus douglas',2,0,'','','Hector','3c7e213c-eb5c-5743-b9fc-b16eee9ce492','Nemadactylus douglasii (Hector, 1875)','(Hector, 1875)','SPECIES','','Nemadactylus','','douglasii','','','',NULL,'','','','','','Hector','','','','1875','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08b352ad-30a4-4d8e-ad88-3504d570957a','','','Mamiellaceae',1,'Mamiellaceae','Mamiellaceae','Mamiellaceae',1,0,'','','','dbbbcd93-f48b-5dd1-8e57-26ef2443985b','Mamiellaceae','','FAMILY','Mamiellaceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08ae3762-c4bb-41ca-9b2e-52c92ed84fd6','','','Urtica dioica L. subsp. dioica',1,'Urtica dioica dioica','Urtica dioica subsp. dioica','Urtica dioic dioic',3,0,'','','','af70ca92-acaa-56fc-b8aa-b903a8a67d62','Urtica dioica L. subsp. dioica','','SUBSPECIES','','Urtica','','dioica','dioica','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08abb1ef-2216-4ace-81e8-8ce366a7d07e','','','Lutjanus',1,'Lutjanus','Lutjanus','Lutjanus',1,0,'','','','99173d97-aeaa-5f1b-8ad7-50354062d690','Lutjanus','','GENUS','Lutjanus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08afeae7-1fcd-4e21-891d-b9c44ccda502','','','Asterophora Ditmar',1,'Asterophora','Asterophora','Asterophora',1,0,'','','Ditmar','a46e84cd-137d-57a9-bcec-68a0a24a198a','Asterophora Ditmar','Ditmar','GENUS','Asterophora','','','','','','',NULL,'','','','','','Ditmar','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08b8fb12-a9b5-46f4-8924-100839a61c12','','','Thomisidae',1,'Thomisidae','Thomisidae','Thomisidae',1,0,'','','','cccd1a25-7edf-5f3d-98ed-bcd5ee669e2b','Thomisidae','','FAMILY','Thomisidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08ba0a05-643a-4bed-b965-38ce8a00443e','','','Coriaria L.',1,'Coriaria','Coriaria','Coriaria',1,0,'','','L.','6644613b-2d04-531e-a55b-52fc8d18e728','Coriaria L.','L.','GENUS','Coriaria','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08b545ac-d068-41bc-93f8-41b432b2a67f','','','Cytospora foliicola Lib.',1,'Cytospora foliicola','Cytospora foliicola','Cytospora foliicol',2,0,'','','Lib.','560cd90f-79ad-5d47-aaf6-9f7b85ece2c7','Cytospora foliicola Lib.','Lib.','SPECIES','','Cytospora','','foliicola','','','',NULL,'','','','','','Lib.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08b4b193-0d7b-43c1-bfaa-8e2ffeef009d','','','Jungermannia unguicularis Hook.f. & Taylor',1,'Jungermannia unguicularis','Jungermannia unguicularis','Jungermannia unguicular',2,0,'','','Hook. fil.|Taylor','3dac05c6-931a-5c76-9c1a-f98d10019eb9','Jungermannia unguicularis Hook.f. & Taylor','Hook.f. & Taylor','SPECIES','','Jungermannia','','unguicularis','','','',NULL,'','','','','','Hook. fil. & Taylor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08bf0c61-1073-4ed9-a002-280a40ba951a','','','Pholiota scamba (Fr.) M.M. Moser',1,'Pholiota scamba','Pholiota scamba','Pholiota scamb',2,0,'','','Fr.|M. M. Moser','ea43d991-0464-5dbb-88c0-389dbbc22784','Pholiota scamba (Fr.) M.M. Moser','(Fr.) M.M. Moser','SPECIES','','Pholiota','','scamba','','','',NULL,'M. M. Moser','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08bcd86e-f943-4894-a7b4-7c771c9af1da','','','Cryptoblabes species',4,'','','',NULL,NULL,'','','','','Cryptoblabes species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08c0d257-f402-4c1f-8c20-d92e3d401a46','','','Cordyceps clavulata (Schwein.) Ellis & Everh.',1,'Cordyceps clavulata','Cordyceps clavulata','Cordyceps clauulat',2,0,'','','Schwein.|Ellis|Everh.','398444eb-9edd-53d9-9c06-a0bce6ae0c17','Cordyceps clavulata (Schwein.) Ellis & Everh.','(Schwein.) Ellis & Everh.','SPECIES','','Cordyceps','','clavulata','','','',NULL,'Ellis & Everh.','','','','','Schwein.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('095b2eba-9ee2-40a0-98f1-26f960594e3b','','','Huonodon aorangi (Suter, 1890)',1,'Huonodon aorangi','Huonodon aorangi','Huonodon aorang',2,0,'','','Suter','a12fca0d-9a5c-57c2-8a6f-114b0911f3ba','Huonodon aorangi (Suter, 1890)','(Suter, 1890)','SPECIES','','Huonodon','','aorangi','','','',NULL,'','','','','','Suter','','','','1890','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('095c8976-7937-4b69-b7dc-49714d6982cf','','','Meridion Agardh',1,'Meridion','Meridion','Meridion',1,0,'','','Agardh','0fbab6f6-1954-5100-9003-a660b67d8d0b','Meridion Agardh','Agardh','GENUS','Meridion','','','','','','',NULL,'','','','','','Agardh','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('095c3af2-6a3f-4acd-9eae-6801c730f691','','','Cladorhiza',1,'Cladorhiza','Cladorhiza','Cladorhiza',1,0,'','','','550fba3d-18d8-53fb-b3f5-5ab2edd93675','Cladorhiza','','GENUS','Cladorhiza','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0959d096-cf15-4f62-936e-7499bbe7c1f4','','','Cladoscenium ancoratum Haeckel, 1887',1,'Cladoscenium ancoratum','Cladoscenium ancoratum','Cladoscenium ancorat',2,0,'','','Haeckel','0af568ce-a521-501c-a6db-be434b740f9c','Cladoscenium ancoratum Haeckel, 1887','Haeckel, 1887','SPECIES','','Cladoscenium','','ancoratum','','','',NULL,'','','','','','Haeckel','','','','1887','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('095dfdad-7ceb-4e58-8511-f3bfa831bea7','','','Staphylococcus schleiferi Freney et al., 1988',1,'Staphylococcus schleiferi','Staphylococcus schleiferi','Staphylococcus schleifer',2,0,'','','Freney et al.','1777bda8-362e-5532-b18b-02ec7585e2ad','Staphylococcus schleiferi Freney et al., 1988','Freney et al., 1988','SPECIES','','Staphylococcus','','schleiferi','','','',NULL,'','','','','','Freney et al.','','','','1988','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0965712a-3ae4-4e6d-af47-5bc07046341f','','','Octochaetus michaelseni Benham, 1904',1,'Octochaetus michaelseni','Octochaetus michaelseni','Octochaetus michaelsen',2,0,'','','Benham','48ce764b-f06d-5589-97b8-f3fa04a259d7','Octochaetus michaelseni Benham, 1904','Benham, 1904','SPECIES','','Octochaetus','','michaelseni','','','',NULL,'','','','','','Benham','','','','1904','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0963a770-19bc-44ba-b8cd-a24ccac5bab8','','','Psilocybe subcoprophila (Britzelm.) Sacc.',1,'Psilocybe subcoprophila','Psilocybe subcoprophila','Psilocybe subcoprophil',2,0,'','','Britzelm.|Sacc.','1e9a1ead-6ad9-5235-8ce4-958e6979e167','Psilocybe subcoprophila (Britzelm.) Sacc.','(Britzelm.) Sacc.','SPECIES','','Psilocybe','','subcoprophila','','','',NULL,'Sacc.','','','','','Britzelm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09653c94-8fa5-402e-9c50-c490ddcc4ac5','','','Thelohaniidae',1,'Thelohaniidae','Thelohaniidae','Thelohaniidae',1,0,'','','','b1efa71d-ed81-55b5-bb40-bdd0f2e31420','Thelohaniidae','','FAMILY','Thelohaniidae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0965b291-8508-424b-96d1-c58f3bc0cb3b','','','Conoplea juniperi S. Hughes',1,'Conoplea juniperi','Conoplea juniperi','Conoplea iuniper',2,0,'','','S. Hughes','87f56157-a822-507f-8082-0a0a43b24329','Conoplea juniperi S. Hughes','S. Hughes','SPECIES','','Conoplea','','juniperi','','','',NULL,'','','','','','S. Hughes','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0968fb71-e49f-47a2-9c55-129986168969','','','Lophocolea unduliflora Gottsche ex Steph.',1,'Lophocolea unduliflora','Lophocolea unduliflora','Lophocolea unduliflor',2,0,'','','Gottsche|Steph.','7927880b-589c-5d0c-906f-b2f77bc629a0','Lophocolea unduliflora Gottsche ex Steph.','Gottsche ex Steph.','SPECIES','','Lophocolea','','unduliflora','','','',NULL,'','','','','','Gottsche','','Steph.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('096bcef6-ccef-430e-b0e0-4549b6159bd2','','','Arenaria L.',1,'Arenaria','Arenaria','Arenaria',1,0,'','','L.','86c5df52-bc9d-5990-b5cf-efd0d70fab77','Arenaria L.','L.','GENUS','Arenaria','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('096b96dd-e88c-4297-8cdb-8c963e3964d9','','','Campylopus kirkii var. pilosus Frahm',1,'Campylopus kirkii pilosus','Campylopus kirkii var. pilosus','Campylopus kirk pilos',3,0,'','','Frahm','cae077f3-780c-5e53-b608-4c3439e68ceb','Campylopus kirkii var. pilosus Frahm','Frahm','VARIETY','','Campylopus','','kirkii','pilosus','','',NULL,'','','','','','Frahm','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('096c980e-2c57-47f7-bdc4-c0c40a893067','','','Aurotipula Alexander, 1924',1,'Aurotipula','Aurotipula','Aurotipula',1,0,'','','Alexander','4bb1fcfe-de3c-5827-b067-d002e7b39ec2','Aurotipula Alexander, 1924','Alexander, 1924','GENUS','Aurotipula','','','','','','',NULL,'','','','','','Alexander','','','','1924','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('096c3189-d7da-42a5-963f-f01d5327fbe7','','','Sieversia albiflora Hook.f.',1,'Sieversia albiflora','Sieversia albiflora','Sieversia albiflor',2,0,'','','Hook. fil.','9435592a-c9bf-5ec5-8f87-47417499460f','Sieversia albiflora Hook.f.','Hook.f.','SPECIES','','Sieversia','','albiflora','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09669927-0785-4bcc-9913-fd1e55cbc070','','','Lecidea homophylia C.Knight',1,'Lecidea homophylia','Lecidea homophylia','Lecidea homophyl',2,0,'','','C. Knight','56f3ae72-1b1b-59b0-b642-b37a2cdd9151','Lecidea homophylia C.Knight','C.Knight','SPECIES','','Lecidea','','homophylia','','','',NULL,'','','','','','C. Knight','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('096dbb95-fa99-4feb-a6a5-36ded331eb2d','','','Ochronectria Rossman & Samuels',1,'Ochronectria','Ochronectria','Ochronectria',1,0,'','','Rossman|Samuels','4a886ea8-e021-5977-a49e-a7a74155ecaa','Ochronectria Rossman & Samuels','Rossman & Samuels','GENUS','Ochronectria','','','','','','',NULL,'','','','','','Rossman & Samuels','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('096edc80-b67d-462d-9eac-6e4603e56dd3','','','Hydrolagus trolli Didier & Séret, 2002 Didier & Séret 2002, 2002',4,'','','',NULL,NULL,'','','','','Hydrolagus trolli Didier & Séret, 2002 Didier & Séret 2002, 2002','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('096fddb7-6a4a-4d03-abe0-b1dad90bc563','','','Xepicula leucotricha (Peck) Nag Raj',1,'Xepicula leucotricha','Xepicula leucotricha','Xepicula leucotrich',2,0,'','','Peck|Nag Raj','83bceefc-1175-5b41-a66e-3862630ea2d4','Xepicula leucotricha (Peck) Nag Raj','(Peck) Nag Raj','SPECIES','','Xepicula','','leucotricha','','','',NULL,'Nag Raj','','','','','Peck','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0974bafb-fca7-4b16-aa5f-07ec3052c968','','','Bathysaurus',1,'Bathysaurus','Bathysaurus','Bathysaurus',1,0,'','','','43b47551-f6bf-54f9-946b-57da5fe3ba5b','Bathysaurus','','GENUS','Bathysaurus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('097a2aa8-3a9c-413e-ab17-1da99bf8ee40','','','Rhododendron malindangense Merr.',1,'Rhododendron malindangense','Rhododendron malindangense','Rhododendron malindangens',2,0,'','','Merr.','0e57f332-b2b8-5e52-80f8-76a4e4d5883f','Rhododendron malindangense Merr.','Merr.','SPECIES','','Rhododendron','','malindangense','','','',NULL,'','','','','','Merr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0978eb86-91c7-4a99-9f20-3ab48d32185e','','','Uromyces sellierae G. Cunn.',1,'Uromyces sellierae','Uromyces sellierae','Uromyces sellier',2,0,'','','G. Cunn.','d2ded686-712c-571a-8719-80d2b0760ef4','Uromyces sellierae G. Cunn.','G. Cunn.','SPECIES','','Uromyces','','sellierae','','','',NULL,'','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0979ec9a-dcb7-4ed7-ab27-6011e0435060','','','Fanniidae',1,'Fanniidae','Fanniidae','Fanniidae',1,0,'','','','1d5683d4-a079-59a8-8f5d-e0a267734958','Fanniidae','','FAMILY','Fanniidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09772050-fd27-41f7-8649-a8c6d008b635','','','Coprinus pseudofriesii Pilát & Svrček',1,'Coprinus pseudofriesii','Coprinus pseudofriesii','Coprinus pseudofries',2,0,'','','Pilát|Svrček','7cba5f25-7844-5811-bcec-2bd20c89f3f9','Coprinus pseudofriesii Pilát & Svrček','Pilát & Svrček','SPECIES','','Coprinus','','pseudofriesii','','','',NULL,'','','','','','Pilát & Svrček','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('097d55be-dbdd-47f7-aa88-511c8f406e32','','','Ophiophycis',1,'Ophiophycis','Ophiophycis','Ophiophycis',1,0,'','','','19d37d99-67b0-5ef3-a9f2-0c0df3c20267','Ophiophycis','','GENUS','Ophiophycis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('097eb96b-5c04-4f98-a6f0-8711a33acbf0','','','Oemona hirta (Fabricius, 1775)',1,'Oemona hirta','Oemona hirta','Oemona hirt',2,0,'','','Fabricius','19e49045-e720-5b23-909b-f874700abe2d','Oemona hirta (Fabricius, 1775)','(Fabricius, 1775)','SPECIES','','Oemona','','hirta','','','',NULL,'','','','','','Fabricius','','','','1775','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0980c55b-9d0b-460d-9382-b92b069548e4','','','Gloeophyllum trabeum (Pers.) Murrill',1,'Gloeophyllum trabeum','Gloeophyllum trabeum','Gloeophyllum trabe',2,0,'','','Pers.|Murrill','160d4d8f-3320-5f9b-9654-38f3f9f01b5d','Gloeophyllum trabeum (Pers.) Murrill','(Pers.) Murrill','SPECIES','','Gloeophyllum','','trabeum','','','',NULL,'Murrill','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('097e50b1-9158-492f-98ac-fd911cffae98','','','Zasmidium stipae (H.C. Greene) K. Schub. & U. Braun',1,'Zasmidium stipae','Zasmidium stipae','Zasmidium stip',2,0,'','','H. C. Greene|K. Schub.|U. Braun','a231ce94-de44-5813-83c4-32e7e494bcb6','Zasmidium stipae (H.C. Greene) K. Schub. & U. Braun','(H.C. Greene) K. Schub. & U. Braun','SPECIES','','Zasmidium','','stipae','','','',NULL,'K. Schub. & U. Braun','','','','','H. C. Greene','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0986d607-9137-4310-a8c5-2820b49621ca','','','Bethelium diversicorne (White, 1846)',1,'Bethelium diversicorne','Bethelium diversicorne','Bethelium diuersicorn',2,0,'','','White','94982810-4272-5e5a-99d0-c4538150c03a','Bethelium diversicorne (White, 1846)','(White, 1846)','SPECIES','','Bethelium','','diversicorne','','','',NULL,'','','','','','White','','','','1846','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0984dd6e-e264-4719-a99e-91dd6f43085b','','','Schleichera oleosa',1,'Schleichera oleosa','Schleichera oleosa','Schleichera oleos',2,0,'','','','e531942a-8708-5fbc-b84f-542cba8543af','Schleichera oleosa','','SPECIES','','Schleichera','','oleosa','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('098901f1-e644-4c09-80fa-e8c8fe50f1fd','','','Brassica oleracea var. italica Plenck',1,'Brassica oleracea italica','Brassica oleracea var. italica','Brassica olerace italic',3,0,'','','Plenck','fbb0e618-d74f-5c13-9395-b3f1ef244cb0','Brassica oleracea var. italica Plenck','Plenck','VARIETY','','Brassica','','oleracea','italica','','',NULL,'','','','','','Plenck','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09913cd0-4120-4b5c-aea0-6de6908a0f40','','','Cladosporium pisicola W.C. Snyder',1,'Cladosporium pisicola','Cladosporium pisicola','Cladosporium pisicol',2,0,'','','W. C. Snyder','b5f4119c-16b2-53bd-b70d-07acc3c6cc26','Cladosporium pisicola W.C. Snyder','W.C. Snyder','SPECIES','','Cladosporium','','pisicola','','','',NULL,'','','','','','W. C. Snyder','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('098e8639-a94f-44a1-a9e8-8b590bae5f8d','','','Enterographa subgelatinosa (Stirt.) Redinger',1,'Enterographa subgelatinosa','Enterographa subgelatinosa','Enterographa subgelatinos',2,0,'','','Stirt.|Redinger','85543d0b-2930-5c42-a09a-2b135e05c7a5','Enterographa subgelatinosa (Stirt.) Redinger','(Stirt.) Redinger','SPECIES','','Enterographa','','subgelatinosa','','','',NULL,'Redinger','','','','','Stirt.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09941d03-8561-4661-93a4-a565707c5ce3','','','Agaricus separatus L.',1,'Agaricus separatus','Agaricus separatus','Agaricus separat',2,0,'','','L.','a895e36d-31d8-57c8-bf02-bc76651a900a','Agaricus separatus L.','L.','SPECIES','','Agaricus','','separatus','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('098e46d6-6923-48ae-a82a-eb01abbc11af','','','Sciara zealandica Kieffer, 1910',1,'Sciara zealandica','Sciara zealandica','Sciara zealandic',2,0,'','','Kieffer','048e2462-09de-5faf-b619-73ed256c15ac','Sciara zealandica Kieffer, 1910','Kieffer, 1910','SPECIES','','Sciara','','zealandica','','','',NULL,'','','','','','Kieffer','','','','1910','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('098e8a5a-61b2-4fa3-a26b-f260be236661','','','Hygrocybe helobia (Arnolds) Bon',1,'Hygrocybe helobia','Hygrocybe helobia','Hygrocybe helob',2,0,'','','Arnolds|Bon','ac9b754b-88ec-55d4-8ec5-5d51ac98d157','Hygrocybe helobia (Arnolds) Bon','(Arnolds) Bon','SPECIES','','Hygrocybe','','helobia','','','',NULL,'Bon','','','','','Arnolds','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09950f69-0fa5-4895-9228-2ad3eb638b37','','','Phellinus pomaceus (Pers.) Pat.',1,'Phellinus pomaceus','Phellinus pomaceus','Phellinus pomace',2,0,'','','Pers.|Pat.','509d72d2-b3bc-5edf-a8d9-a84449e10fa2','Phellinus pomaceus (Pers.) Pat.','(Pers.) Pat.','SPECIES','','Phellinus','','pomaceus','','','',NULL,'Pat.','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0995f779-e222-439e-bd87-55f3ed102acb','','','Dermocarpa gracilis Lemmerm. Lemmerm.',1,'Dermocarpa gracilis','Dermocarpa gracilis','Dermocarpa gracil',2,0,'','','Lemmerm. Lemmerm.','86f0d156-83c1-5271-9f23-2c4e97c375dc','Dermocarpa gracilis Lemmerm. Lemmerm.','Lemmerm. Lemmerm.','SPECIES','','Dermocarpa','','gracilis','','','',NULL,'','','','','','Lemmerm. Lemmerm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('099a9a91-310f-4825-ae77-8dafbe8c23c9','','','Babingtonia virgata (J.R.Forst. & G.Forst.) F.Muell.',1,'Babingtonia virgata','Babingtonia virgata','Babingtonia uirgat',2,0,'','','J. R. Forst.|G. Forst.|F. Muell.','1ada4af7-0c75-5317-afbf-21b9db8fda06','Babingtonia virgata (J.R.Forst. & G.Forst.) F.Muell.','(J.R.Forst. & G.Forst.) F.Muell.','SPECIES','','Babingtonia','','virgata','','','',NULL,'F. Muell.','','','','','J. R. Forst. & G. Forst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09a2ab2a-0fa6-48af-9497-0dadf0cf3807','','','Cardamine basicola Heenan',1,'Cardamine basicola','Cardamine basicola','Cardamine basicol',2,0,'','','Heenan','01772643-b202-5a98-8a7b-ee273c655613','Cardamine basicola Heenan','Heenan','SPECIES','','Cardamine','','basicola','','','',NULL,'','','','','','Heenan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('099d455a-93ff-4821-adbc-6b382c770815','','','Ascochyta Lib.',1,'Ascochyta','Ascochyta','Ascochyta',1,0,'','','Lib.','a4db9c3a-26be-53d5-867a-34f994fee254','Ascochyta Lib.','Lib.','GENUS','Ascochyta','','','','','','',NULL,'','','','','','Lib.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('099cd239-3156-4a52-8903-97ff3dffca79','','','Pseudofissurina metaconica (McCulloch, 1977)',1,'Pseudofissurina metaconica','Pseudofissurina metaconica','Pseudofissurina metaconic',2,0,'','','McCulloch','892ae2ef-6c04-51fe-9bc8-26265a4dd41d','Pseudofissurina metaconica (McCulloch, 1977)','(McCulloch, 1977)','SPECIES','','Pseudofissurina','','metaconica','','','',NULL,'','','','','','McCulloch','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('099ee421-eb08-4df2-a951-f347ea1041e2','','','Hohorstiella species',4,'','','',NULL,NULL,'','','','','Hohorstiella species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09a198d0-2f44-4911-83da-f9c8dae614cc','','','Cycloctenus nelsonensis Forster, 1979',1,'Cycloctenus nelsonensis','Cycloctenus nelsonensis','Cycloctenus nelsonens',2,0,'','','Forster','4248f10a-4912-529b-a722-ee64bed982e4','Cycloctenus nelsonensis Forster, 1979','Forster, 1979','SPECIES','','Cycloctenus','','nelsonensis','','','',NULL,'','','','','','Forster','','','','1979','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a92ce1e-7bc9-4f7c-b695-2894899e0701','','','Grammitis Sw.',1,'Grammitis','Grammitis','Grammitis',1,0,'','','Sw.','95c76068-76e4-59f6-896e-02ca9814afb7','Grammitis Sw.','Sw.','GENUS','Grammitis','','','','','','',NULL,'','','','','','Sw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a90227e-719e-405c-96db-676c190487ca','','','Clavaria ypsilonidia R.H. Petersen',1,'Clavaria ypsilonidia','Clavaria ypsilonidia','Clavaria ypsilonid',2,0,'','','R. H. Petersen','f8bba44e-503e-55b5-a942-68fa0862c17b','Clavaria ypsilonidia R.H. Petersen','R.H. Petersen','SPECIES','','Clavaria','','ypsilonidia','','','',NULL,'','','','','','R. H. Petersen','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a94e8e3-61a0-43be-914f-8e248eb76670','','','Dactylopodida',1,'Dactylopodida','Dactylopodida','Dactylopodida',1,0,'','','','91ea65f3-73f0-5957-b26a-96650fca70a7','Dactylopodida','','ORDER','Dactylopodida','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a90f105-f6e0-4738-9c59-c3ffdd2af6ba','','','Bulgaria Fr.',1,'Bulgaria','Bulgaria','Bulgaria',1,0,'','','Fr.','6fc3742f-1c81-5bad-9c10-a074e3a6fff4','Bulgaria Fr.','Fr.','GENUS','Bulgaria','','','','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a95210a-7647-43a1-80b8-df5cba252cb5','','','Epipyxis utriculus var. pusilla (Lemmerman) D.K.Hilliard et Asmund',1,'Epipyxis utriculus pusilla','Epipyxis utriculus var. pusilla','Epipyxis utricul pusill',3,0,'','','Lemmerman|D. K. Hilliard|Asmund','42448492-8fc0-519d-aa0a-71a90f7351c4','Epipyxis utriculus var. pusilla (Lemmerman) D.K.Hilliard et Asmund','(Lemmerman) D.K.Hilliard et Asmund','VARIETY','','Epipyxis','','utriculus','pusilla','','',NULL,'D. K. Hilliard & Asmund','','','','','Lemmerman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a95bf1a-c67b-43a2-a1eb-8a95d522d4db','','','Neomenia',1,'Neomenia','Neomenia','Neomenia',1,0,'','','','30ee2b79-eeda-5fa5-af9e-f9c2b95e1a2a','Neomenia','','GENUS','Neomenia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a9ab7a4-2984-4351-a0c5-921d45f649fe','','','Megarhyssa nortoni (Cresson, 1864)',1,'Megarhyssa nortoni','Megarhyssa nortoni','Megarhyssa norton',2,0,'','','Cresson','09af0bc3-cd05-5a41-a70d-e6017317f2f7','Megarhyssa nortoni (Cresson, 1864)','(Cresson, 1864)','SPECIES','','Megarhyssa','','nortoni','','','',NULL,'','','','','','Cresson','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a9a38f1-0527-41e8-bdc3-fdc4aff99ddb','','','Transrenus Grzymala and Leschen, 2020',1,'Transrenus','Transrenus','Transrenus',1,0,'','','Grzymala|Leschen','33e8c019-57f5-5789-89c1-54f9177ac05a','Transrenus Grzymala and Leschen, 2020','Grzymala and Leschen, 2020','GENUS','Transrenus','','','','','','',NULL,'','','','','','Grzymala & Leschen','','','','2020','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0aa069fc-be07-4bf5-b90a-29eb69def985','','','Pseudognaphalium luteoalbum (L.) Hilliard & B.L.Burtt',1,'Pseudognaphalium luteoalbum','Pseudognaphalium luteoalbum','Pseudognaphalium luteoalb',2,0,'','','L.|Hilliard|B. L. Burtt','b9ac13dd-2e8b-54f2-bbd6-24036f8a6f73','Pseudognaphalium luteoalbum (L.) Hilliard & B.L.Burtt','(L.) Hilliard & B.L.Burtt','SPECIES','','Pseudognaphalium','','luteoalbum','','','',NULL,'Hilliard & B. L. Burtt','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0aa324b2-1f4f-42b9-bfda-6a4cb65420bd','','','Cercospora polymorpha Bubák',1,'Cercospora polymorpha','Cercospora polymorpha','Cercospora polymorph',2,0,'','','Bubák','fdc75e79-4563-5853-8e05-2b6e09597802','Cercospora polymorpha Bubák','Bubák','SPECIES','','Cercospora','','polymorpha','','','',NULL,'','','','','','Bubák','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a9e74da-ab7b-43e1-8f1c-956e649e5c6d','','','Penicillium minioluteum Dierckx',1,'Penicillium minioluteum','Penicillium minioluteum','Penicillium miniolute',2,0,'','','Dierckx','c3b7c06e-312f-5d4d-b05d-d712cbb6566c','Penicillium minioluteum Dierckx','Dierckx','SPECIES','','Penicillium','','minioluteum','','','',NULL,'','','','','','Dierckx','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0aa45863-78fd-48c3-9449-4d636db7ec70','','','Celmisia glandulosa var. latifolia Cockayne',1,'Celmisia glandulosa latifolia','Celmisia glandulosa var. latifolia','Celmisia glandulos latifol',3,0,'','','Cockayne','4780a1d7-0e63-5065-a361-6c23ffe49a5e','Celmisia glandulosa var. latifolia Cockayne','Cockayne','VARIETY','','Celmisia','','glandulosa','latifolia','','',NULL,'','','','','','Cockayne','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0aa5bf2e-0655-4352-8a94-578c8024ed30','','','Gladiolus albidus Jacq.',1,'Gladiolus albidus','Gladiolus albidus','Gladiolus albid',2,0,'','','Jacq.','cbfb8caa-b7e7-5757-ad36-e9d98c50ee9b','Gladiolus albidus Jacq.','Jacq.','SPECIES','','Gladiolus','','albidus','','','',NULL,'','','','','','Jacq.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0aa778d5-c509-4b7f-8dce-6d2c5a501690','','','Chaetosphaeria phaeostalacta Réblová',1,'Chaetosphaeria phaeostalacta','Chaetosphaeria phaeostalacta','Chaetosphaeria phaeostalact',2,0,'','','Réblová','014d66d9-d8ab-5137-a37f-66cd29e851d0','Chaetosphaeria phaeostalacta Réblová','Réblová','SPECIES','','Chaetosphaeria','','phaeostalacta','','','',NULL,'','','','','','Réblová','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0aa53ddb-0829-4d23-a567-a43d0f6f6fbb','','','Polyporus revolutus (Bres.) E.H.L. Krause',1,'Polyporus revolutus','Polyporus revolutus','Polyporus reuolut',2,0,'','','Bres.|E. H. L. Krause','a6261ca8-47f2-57d3-943e-0004ee3a6adc','Polyporus revolutus (Bres.) E.H.L. Krause','(Bres.) E.H.L. Krause','SPECIES','','Polyporus','','revolutus','','','',NULL,'E. H. L. Krause','','','','','Bres.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ab43c31-4642-48ad-8d7b-1ae2bb54d774','','','Puccinia tuberculata Speg.',1,'Puccinia tuberculata','Puccinia tuberculata','Puccinia tuberculat',2,0,'','','Speg.','d8f715be-15f7-5ab9-900a-74d98f36c707','Puccinia tuberculata Speg.','Speg.','SPECIES','','Puccinia','','tuberculata','','','',NULL,'','','','','','Speg.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ab3ed1f-f4d5-4c55-a80b-4e6d7f769241','','','Penicillium westlingii K.M. Zalessky',1,'Penicillium westlingii','Penicillium westlingii','Penicillium westling',2,0,'','','K. M. Zalessky','0be34e4e-46c6-5699-8d90-eea821ea5774','Penicillium westlingii K.M. Zalessky','K.M. Zalessky','SPECIES','','Penicillium','','westlingii','','','',NULL,'','','','','','K. M. Zalessky','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ab41ce3-2cbb-4309-8feb-6ba9858a2992','','','Jungermanniidae J.J.Engel',1,'Jungermanniidae','Jungermanniidae','Jungermanniidae',1,0,'','','J. J. Engel','f7d73135-809b-5fb5-ba54-d4204e355488','Jungermanniidae J.J.Engel','J.J.Engel','SUBCLASS','Jungermanniidae','','','','','','',NULL,'','','','','','J. J. Engel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0aace8bd-39cd-4fda-98ac-ba2625f57bea','','','Teloschistes xanthorioides Js.Murray',1,'Teloschistes xanthorioides','Teloschistes xanthorioides','Teloschistes xanthorioid',2,0,'','','Js. Murray','3fb431cd-fdc1-5185-9c33-7e7369f3020a','Teloschistes xanthorioides Js.Murray','Js.Murray','SPECIES','','Teloschistes','','xanthorioides','','','',NULL,'','','','','','Js. Murray','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ab7956e-50b7-450b-b6a0-1ad1ce4248f6','','','Geastrum coriaceum Colenso',1,'Geastrum coriaceum','Geastrum coriaceum','Geastrum coriace',2,0,'','','Colenso','0ca04aa3-1521-5f44-a3eb-b557f7d94fe8','Geastrum coriaceum Colenso','Colenso','SPECIES','','Geastrum','','coriaceum','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ab924cc-e43f-4874-b858-4235657ebba3','','','Helophyllum muscoides Colenso',1,'Helophyllum muscoides','Helophyllum muscoides','Helophyllum muscoid',2,0,'','','Colenso','b846def3-9b02-5555-8732-bb62d262e0bc','Helophyllum muscoides Colenso','Colenso','SPECIES','','Helophyllum','','muscoides','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0abacf77-5121-4f24-acfd-a2252c5d91b5','','','Laevidentalina sidebottomi (Cushman, 1933)',1,'Laevidentalina sidebottomi','Laevidentalina sidebottomi','Laevidentalina sidebottom',2,0,'','','Cushman','4140b7c7-30a8-5bfa-9e42-24085439b3b1','Laevidentalina sidebottomi (Cushman, 1933)','(Cushman, 1933)','SPECIES','','Laevidentalina','','sidebottomi','','','',NULL,'','','','','','Cushman','','','','1933','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ac1b68e-3f6c-4294-bf18-15e74cff71eb','','','Colobaturus',1,'Colobaturus','Colobaturus','Colobaturus',1,0,'','','','cc6b9b6e-c70e-5ced-88aa-4cd683be9475','Colobaturus','','GENUS','Colobaturus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0abcc6b4-c53d-4915-aa38-4c4a33591cea','','','Criconematoidea',1,'Criconematoidea','Criconematoidea','Criconematoidea',1,0,'','','','996f643b-bfc3-58a0-8fcb-a7d14bf9b443','Criconematoidea','','SUPERFAMILY','Criconematoidea','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0abd767a-be5f-4e09-8f78-a2804a572172','','','White clover virus L',NULL,'','','',NULL,NULL,'','','','','White clover virus L','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ac0fa8d-7339-4388-a05f-aa9bdf680254','','','Celmisia petriei Cheeseman',1,'Celmisia petriei','Celmisia petriei','Celmisia petrie',2,0,'','','Cheeseman','576d05a4-12bf-59ee-a62d-38742263bb59','Celmisia petriei Cheeseman','Cheeseman','SPECIES','','Celmisia','','petriei','','','',NULL,'','','','','','Cheeseman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0abc95e3-df9d-465e-8a5c-d73f091d39b7','','','Ledermuelleriopsis',1,'Ledermuelleriopsis','Ledermuelleriopsis','Ledermuelleriopsis',1,0,'','','','6492f4f6-4340-5313-b5ab-f549414ef580','Ledermuelleriopsis','','GENUS','Ledermuelleriopsis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0abccb89-a123-46b2-aa5f-f20e84ff1ca3','','','Semo southlandiae Larivière & Hoch, 1998',1,'Semo southlandiae','Semo southlandiae','Semo southlandi',2,0,'','','Larivière|Hoch','8a5735cb-3452-5616-a45d-463a51fb1ba5','Semo southlandiae Larivière & Hoch, 1998','Larivière & Hoch, 1998','SPECIES','','Semo','','southlandiae','','','',NULL,'','','','','','Larivière & Hoch','','','','1998','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ac80352-c863-4f35-a8ac-affe3535d12b','','','Veronatus sharpi Broun, 1880',1,'Veronatus sharpi','Veronatus sharpi','Veronatus sharp',2,0,'','','Broun','02981aa0-9174-5777-a10e-ca2fdb1cd9f5','Veronatus sharpi Broun, 1880','Broun, 1880','SPECIES','','Veronatus','','sharpi','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ac4ac30-3a81-41c3-9650-b3310f4150f5','','','Allodessus oliveri (Ordish, 1966)',1,'Allodessus oliveri','Allodessus oliveri','Allodessus oliuer',2,0,'','','Ordish','b3f38edc-854d-54e2-9837-55872332bc78','Allodessus oliveri (Ordish, 1966)','(Ordish, 1966)','SPECIES','','Allodessus','','oliveri','','','',NULL,'','','','','','Ordish','','','','1966','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ac2dddc-7969-4360-b49c-d1ff9bd65b90','','','Kunzea linearis (Kirk) de Lange & Toelken',1,'Kunzea linearis','Kunzea linearis','Kunzea linear',2,0,'','','Kirk|de Lange|Toelken','6cc57a71-394a-5901-8f58-ec5a9ecc4300','Kunzea linearis (Kirk) de Lange & Toelken','(Kirk) de Lange & Toelken','SPECIES','','Kunzea','','linearis','','','',NULL,'de Lange & Toelken','','','','','Kirk','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ac3a09b-314e-4122-9a03-f0da6a3e1d91','','','Pseudocercospora vitis (Lév.) Speg.',1,'Pseudocercospora vitis','Pseudocercospora vitis','Pseudocercospora uit',2,0,'','','Lév.|Speg.','8a5f9481-fa05-55ec-bb36-e857dac7f296','Pseudocercospora vitis (Lév.) Speg.','(Lév.) Speg.','SPECIES','','Pseudocercospora','','vitis','','','',NULL,'Speg.','','','','','Lév.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0acfec56-4600-420d-b489-66ba42074fd3','','','Duportella tristicula (Berk. & Broome) Reinking',1,'Duportella tristicula','Duportella tristicula','Duportella tristicul',2,0,'','','Berk.|Broome|Reinking','eefe6a07-c0b4-5a87-b42d-8de4742dbc14','Duportella tristicula (Berk. & Broome) Reinking','(Berk. & Broome) Reinking','SPECIES','','Duportella','','tristicula','','','',NULL,'Reinking','','','','','Berk. & Broome','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0acafbdd-652c-49ae-ab86-c10871193c48','','','Torula murorum Corda',1,'Torula murorum','Torula murorum','Torula muror',2,0,'','','Corda','c62db556-c0cd-522d-be9a-ce2943d19881','Torula murorum Corda','Corda','SPECIES','','Torula','','murorum','','','',NULL,'','','','','','Corda','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0acd33c1-e4c9-481f-8370-ceb752124dfb','','','Australopacifica species 2 Johns unpubl.',4,'','','',NULL,NULL,'','','','','Australopacifica species 2 Johns unpubl.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ad19658-a4c3-4a16-9e9a-e9d77ce21a2a','','','Euryapteryx curtus curtus Owen, 1846 Owen 1846, 1846',4,'','','',NULL,NULL,'','','','','Euryapteryx curtus curtus Owen, 1846 Owen 1846, 1846','','SUBSPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ad528f3-240b-459b-8ad7-20238bd24a99','','','Ataxocerithium',1,'Ataxocerithium','Ataxocerithium','Ataxocerithium',1,0,'','','','958aa3ba-fac4-50b0-b231-a27f44e20a13','Ataxocerithium','','GENUS','Ataxocerithium','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09f1ad0c-2590-4b31-939e-30d09e765bc2','','','Thoracochaeta ancudensis (Richards, 1931)',1,'Thoracochaeta ancudensis','Thoracochaeta ancudensis','Thoracochaeta ancudens',2,0,'','','Richards','ae56c547-6836-536b-a0a0-5ffcf43b1c52','Thoracochaeta ancudensis (Richards, 1931)','(Richards, 1931)','SPECIES','','Thoracochaeta','','ancudensis','','','',NULL,'','','','','','Richards','','','','1931','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ad1df80-35c6-407e-a6ae-6c2f07733ed1','','','Reseda L.',1,'Reseda','Reseda','Reseda',1,0,'','','L.','5c7a95d7-744f-59e5-8d02-c1821060d888','Reseda L.','L.','GENUS','Reseda','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ad3e697-04df-4c1c-8300-a9bb31bec6e6','','','Collybia confusa P.D. Orton',1,'Collybia confusa','Collybia confusa','Collybia confus',2,0,'','','P. D. Orton','81373f1c-c9ac-52ba-833b-d117c04a1a49','Collybia confusa P.D. Orton','P.D. Orton','SPECIES','','Collybia','','confusa','','','',NULL,'','','','','','P. D. Orton','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ad654a9-4eab-4c27-a4ef-cdfb2a166e5b','','','Quadracythere radizea Hornibrook, 1952',1,'Quadracythere radizea','Quadracythere radizea','Quadracythere radize',2,0,'','','Hornibrook','60a96767-1b54-5e1c-b52f-e94d817e91df','Quadracythere radizea Hornibrook, 1952','Hornibrook, 1952','SPECIES','','Quadracythere','','radizea','','','',NULL,'','','','','','Hornibrook','','','','1952','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09f834e4-a185-45e4-8a3d-28dc91f7486f','','','Armatimonadota Tamaki et al., 2021',1,'Armatimonadota','Armatimonadota','Armatimonadota',1,0,'','','Tamaki et al.','81632754-1660-5f0e-b0ad-632d852a69af','Armatimonadota Tamaki et al., 2021','Tamaki et al., 2021','PHYLUM','Armatimonadota','','','','','','',NULL,'','','','','','Tamaki et al.','','','','2021','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09f60a20-7e6f-45af-bfa2-8680c6137191','','','Azaleastrum',1,'Azaleastrum','Azaleastrum','Azaleastrum',1,0,'','','','25190dec-9e5f-5a5f-85f2-61e90d47bb17','Azaleastrum','','GENUS','Azaleastrum','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09fa2f6b-86c4-4711-980e-a12744b14ec0','','','Pseudodiplodia stipina (Petr.) Petr.',1,'Pseudodiplodia stipina','Pseudodiplodia stipina','Pseudodiplodia stipin',2,0,'','','Petr.','7f6e6118-adb5-5e30-a7d6-c441bbdb4585','Pseudodiplodia stipina (Petr.) Petr.','(Petr.) Petr.','SPECIES','','Pseudodiplodia','','stipina','','','',NULL,'Petr.','','','','','Petr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09f41040-fe41-4776-9fc5-cbe0912ae9d9','','','Narcissus poeticus L.',1,'Narcissus poeticus','Narcissus poeticus','Narcissus poetic',2,0,'','','L.','e97aad2c-140e-57b9-ad96-6524aa789f85','Narcissus poeticus L.','L.','SPECIES','','Narcissus','','poeticus','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09f3fdbf-be89-4546-ba09-d05a6a4ee2ea','','','Pinguicula agnata Casper',1,'Pinguicula agnata','Pinguicula agnata','Pinguicula agnat',2,0,'','','Casper','e2b05b71-e6e4-5759-b105-0d8242e3c2b8','Pinguicula agnata Casper','Casper','SPECIES','','Pinguicula','','agnata','','','',NULL,'','','','','','Casper','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09f8aa70-a7e5-4d1c-94a4-d86b9f8f9104','','','Sabuloglossum arenarium (Rostr.) Hustad, A.N. Mill., Dentinger',1,'Sabuloglossum arenarium','Sabuloglossum arenarium','Sabuloglossum arenari',2,0,'','','Rostr.|Hustad|A. N. Mill.|Dentinger','e389ac15-3eae-5b74-8cfa-8b7ee4be52fe','Sabuloglossum arenarium (Rostr.) Hustad, A.N. Mill., Dentinger','(Rostr.) Hustad, A.N. Mill., Dentinger','SPECIES','','Sabuloglossum','','arenarium','','','',NULL,'Hustad, A. N. Mill. & Dentinger','','','','','Rostr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09fe19ac-7c30-4e87-aaac-7ae652e8a838','','','Stigmatidium confluens C.Knight',1,'Stigmatidium confluens','Stigmatidium confluens','Stigmatidium confluens',2,0,'','','C. Knight','6a3b517d-e5cf-57fc-a0ae-6be5fa46b70d','Stigmatidium confluens C.Knight','C.Knight','SPECIES','','Stigmatidium','','confluens','','','',NULL,'','','','','','C. Knight','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a05787b-7014-40aa-afb4-188d0a526e20','','','Passalurus ambiguus (Rudolphi, 1819)',1,'Passalurus ambiguus','Passalurus ambiguus','Passalurus ambigu',2,0,'','','Rudolphi','d2f9dda7-b240-5dac-bbf7-e4dbce677fc0','Passalurus ambiguus (Rudolphi, 1819)','(Rudolphi, 1819)','SPECIES','','Passalurus','','ambiguus','','','',NULL,'','','','','','Rudolphi','','','','1819','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a053947-74b4-4f87-a9ac-b08ec3ae9ea9','','','Cryptosporiopsis citri P.R. Johnst. & Full.',1,'Cryptosporiopsis citri','Cryptosporiopsis citri','Cryptosporiopsis citr',2,0,'','','P. R. Johnst.|Full.','50d9c367-1726-5e36-bba6-8c02fd016e43','Cryptosporiopsis citri P.R. Johnst. & Full.','P.R. Johnst. & Full.','SPECIES','','Cryptosporiopsis','','citri','','','',NULL,'','','','','','P. R. Johnst. & Full.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a0aa6a5-a980-4d4f-b6cc-1cf3130598fd','','','Olea europaea L.',1,'Olea europaea','Olea europaea','Olea europae',2,0,'','','L.','2ed9d796-5bdf-5814-a557-6d44d981be26','Olea europaea L.','L.','SPECIES','','Olea','','europaea','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a0a40ae-c81d-461a-86a6-421d2df76437','','','Planktolyngbya',1,'Planktolyngbya','Planktolyngbya','Planktolyngbya',1,0,'','','','70a63502-a856-5248-ad35-d29a1e5e30d8','Planktolyngbya','','GENUS','Planktolyngbya','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a09f8ec-7c9e-4336-9a2d-444c3af9140c','','','Huonodon hectori (Suter, 1890)',1,'Huonodon hectori','Huonodon hectori','Huonodon hector',2,0,'','','Suter','6287e038-6c31-5cc2-a0ab-dc83b3af7dd6','Huonodon hectori (Suter, 1890)','(Suter, 1890)','SPECIES','','Huonodon','','hectori','','','',NULL,'','','','','','Suter','','','','1890','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a0d165d-878d-43d5-9955-c4ee6c74cba9','','','Achalcus minusculus Parent, 1933',1,'Achalcus minusculus','Achalcus minusculus','Achalcus minuscul',2,0,'','','Parent','6e6452d6-b2d0-58de-be29-fd84cacf9544','Achalcus minusculus Parent, 1933','Parent, 1933','SPECIES','','Achalcus','','minusculus','','','',NULL,'','','','','','Parent','','','','1933','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a0ade35-8284-40f1-a06f-f69ce50f3b60','','','Macrobiotus diffusus Binda & Pilato, 1987',1,'Macrobiotus diffusus','Macrobiotus diffusus','Macrobiotus diffus',2,0,'','','Binda|Pilato','fec8079f-9cf8-52c9-b2d6-fbb1fc30b820','Macrobiotus diffusus Binda & Pilato, 1987','Binda & Pilato, 1987','SPECIES','','Macrobiotus','','diffusus','','','',NULL,'','','','','','Binda & Pilato','','','','1987','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a10a4ec-37e0-43ab-b3c6-764f50366a03','','','Pseudopyrenochaeta lycopersici (R.W. Schneid. & Gerlach) Valenzuela-Lopez, Crous, Stchigel, Guarro & Cano',1,'Pseudopyrenochaeta lycopersici','Pseudopyrenochaeta lycopersici','Pseudopyrenochaeta lycopersic',2,0,'','','R. W. Schneid.|Gerlach|Valenzuela-Lopez|Crous|Stchigel|Guarro|Cano','62629d58-e2e7-5a16-9489-9a0c34044ecf','Pseudopyrenochaeta lycopersici (R.W. Schneid. & Gerlach) Valenzuela-Lopez, Crous, Stchigel, Guarro & Cano','(R.W. Schneid. & Gerlach) Valenzuela-Lopez, Crous, Stchigel, Guarro & Cano','SPECIES','','Pseudopyrenochaeta','','lycopersici','','','',NULL,'Valenzuela-Lopez, Crous, Stchigel, Guarro & Cano','','','','','R. W. Schneid. & Gerlach','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a1a39a3-0c8a-450d-be23-5e79511c7f28','','','Haplosyllis spongicola (Grube, 1855)',1,'Haplosyllis spongicola','Haplosyllis spongicola','Haplosyllis spongicol',2,0,'','','Grube','3a67289e-0556-5387-bec0-66678e17d4bf','Haplosyllis spongicola (Grube, 1855)','(Grube, 1855)','SPECIES','','Haplosyllis','','spongicola','','','',NULL,'','','','','','Grube','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a1c0850-446e-4b10-930b-b9a01ce89adf','','','Xylodon magallanesii Fern.-López, Tellería, M. Dueñas, Laguna & M.P. Martín',1,'Xylodon magallanesii','Xylodon magallanesii','Xylodon magallanes',2,0,'','','Fern.-López|Tellería|M. Dueñas|Laguna|M. P. Martín','fb191b70-c1cb-5e07-af54-d50c096cf7fd','Xylodon magallanesii Fern.-López, Tellería, M. Dueñas, Laguna & M.P. Martín','Fern.-López, Tellería, M. Dueñas, Laguna & M.P. Martín','SPECIES','','Xylodon','','magallanesii','','','',NULL,'','','','','','Fern.-López, Tellería, M. Dueñas, Laguna & M. P. Martín','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a2088ce-e7e1-40c8-ad96-43e3a3a9a84e','','','Adel crenatum (Broun, 1883)',1,'Adel crenatum','Adel crenatum','Adel crenat',2,0,'','','Broun','3d747d90-ca35-5009-b078-04bced2473e1','Adel crenatum (Broun, 1883)','(Broun, 1883)','SPECIES','','Adel','','crenatum','','','',NULL,'','','','','','Broun','','','','1883','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a25a10e-760a-4a29-b20f-9037166d0aeb','','','Chroococcus turgidus (Kütz.) Nägeli',1,'Chroococcus turgidus','Chroococcus turgidus','Chroococcus turgid',2,0,'','','Kütz.|Nägeli','03e6ef64-dc6f-5aed-bb69-76bac7be4251','Chroococcus turgidus (Kütz.) Nägeli','(Kütz.) Nägeli','SPECIES','','Chroococcus','','turgidus','','','',NULL,'Nägeli','','','','','Kütz.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a2271a4-35bd-4151-ba88-a23a4e373dbc','','','Dendrobium kauldorumii T.M.Reeve',1,'Dendrobium kauldorumii','Dendrobium kauldorumii','Dendrobium kauldorum',2,0,'','','T. M. Reeve','6e9becae-6b75-5bb9-a8bb-412340650ef5','Dendrobium kauldorumii T.M.Reeve','T.M.Reeve','SPECIES','','Dendrobium','','kauldorumii','','','',NULL,'','','','','','T. M. Reeve','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a2b97ac-6d89-4fe2-aa02-889729d9a88f','','','Francuscia',1,'Francuscia','Francuscia','Francuscia',1,0,'','','','de733bdc-e2f3-5a4e-9c6d-a6bddb5df4b1','Francuscia','','GENUS','Francuscia','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a267b74-0989-4e7f-b41a-91265940d6a8','','','Egretta novaehollandiae (Latham, 1790)',1,'Egretta novaehollandiae','Egretta novaehollandiae','Egretta nouaehollandi',2,0,'','','Latham','64a1e75a-4e4a-5387-87ea-abc75ed321f2','Egretta novaehollandiae (Latham, 1790)','(Latham, 1790)','SPECIES','','Egretta','','novaehollandiae','','','',NULL,'','','','','','Latham','','','','1790','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a2826c1-c170-46ee-82f4-d1d3c05bffcd','','','Pestalotia macrotricha Kleb.',1,'Pestalotia macrotricha','Pestalotia macrotricha','Pestalotia macrotrich',2,0,'','','Kleb.','60d977d9-20e9-52f4-bcc7-e600ab7564a1','Pestalotia macrotricha Kleb.','Kleb.','SPECIES','','Pestalotia','','macrotricha','','','',NULL,'','','','','','Kleb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a2831e7-1904-4a6a-b8aa-f72ff7673b65','','','Ceratorhiza R.T. Moore',1,'Ceratorhiza','Ceratorhiza','Ceratorhiza',1,0,'','','R. T. Moore','3a2c7fb2-c3b0-5b31-819a-f305e09e5f2e','Ceratorhiza R.T. Moore','R.T. Moore','GENUS','Ceratorhiza','','','','','','',NULL,'','','','','','R. T. Moore','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a2f8124-91cd-42b7-9997-3cf103040c22','','','Glomerella cingulata camelliae Dickens & R.T.A. Cook',1,'Glomerella cingulata camelliae','Glomerella cingulata camelliae','Glomerella cingulat camelli',3,0,'','','Dickens|R. T. A. Cook','fda200ed-b069-5394-b8dd-0e309db460d1','Glomerella cingulata camelliae Dickens & R.T.A. Cook','Dickens & R.T.A. Cook','','','Glomerella','','cingulata','camelliae','','',NULL,'','','','','','Dickens & R. T. A. Cook','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a2e5a95-96bd-435a-b7e7-6ce4290f608d','','','Startes foveata Broun, 1893',1,'Startes foveata','Startes foveata','Startes foueat',2,0,'','','Broun','1ffa9271-393e-578c-a5ae-cd936b327b2a','Startes foveata Broun, 1893','Broun, 1893','SPECIES','','Startes','','foveata','','','',NULL,'','','','','','Broun','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a3829f6-b8c2-4a45-a836-5f49126e4fe0','','','Meterana alcyone (Hudson, 1898)',1,'Meterana alcyone','Meterana alcyone','Meterana alcyon',2,0,'','','Hudson','0d7c9a12-99f3-5dce-b78c-8fb85c5e31b5','Meterana alcyone (Hudson, 1898)','(Hudson, 1898)','SPECIES','','Meterana','','alcyone','','','',NULL,'','','','','','Hudson','','','','1898','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a333ae8-9f81-4f8f-9a12-79f62a2ccdbb','','','Dicranella vaginata (Hook.) Cardot',1,'Dicranella vaginata','Dicranella vaginata','Dicranella uaginat',2,0,'','','Hook.|Cardot','d933dcb1-6480-5773-848b-a056e4bfbe47','Dicranella vaginata (Hook.) Cardot','(Hook.) Cardot','SPECIES','','Dicranella','','vaginata','','','',NULL,'Cardot','','','','','Hook.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0adf3627-aff2-434a-8470-253b260cf624','','','Eucrosia bicolor Ker Gawl.',1,'Eucrosia bicolor','Eucrosia bicolor','Eucrosia bicolor',2,0,'','','Ker Gawl.','639cbc0d-28ee-5cea-93a6-7229497ffc40','Eucrosia bicolor Ker Gawl.','Ker Gawl.','SPECIES','','Eucrosia','','bicolor','','','',NULL,'','','','','','Ker Gawl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ae048ef-39e3-4990-bdeb-86b96409a01f','','','Sciacharis (Sciacharis) hopeana (Franz, 1975)',1,'Sciacharis hopeana','Sciacharis hopeana','Sciacharis hopean',2,0,'','','Franz','3a4321fb-1f91-565a-894c-73591aabd6f9','Sciacharis (Sciacharis) hopeana (Franz, 1975)','(Franz, 1975)','SPECIES','','Sciacharis','Sciacharis','hopeana','','','',NULL,'','','','','','Franz','','','','1975','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ade7d0a-578f-414c-a6b4-94e2658f7c25','','','Usnea inermis Motyka',1,'Usnea inermis','Usnea inermis','Usnea inerm',2,0,'','','Motyka','ce0c8363-3335-5de1-b154-0d628adc462a','Usnea inermis Motyka','Motyka','SPECIES','','Usnea','','inermis','','','',NULL,'','','','','','Motyka','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ae05eec-ad9d-44dc-9d33-a0c3f96bc232','','','Austrotipula hudsoni Hutton, 1900',1,'Austrotipula hudsoni','Austrotipula hudsoni','Austrotipula hudson',2,0,'','','Hutton','73e6b9c3-24e5-54fe-9047-e1f99e2cb0c0','Austrotipula hudsoni Hutton, 1900','Hutton, 1900','SPECIES','','Austrotipula','','hudsoni','','','',NULL,'','','','','','Hutton','','','','1900','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ae23ff7-269c-41e9-89d3-41b09eb462dd','','','Paronana tasmasecta tasmasecta (Salmon, 1941)',1,'Paronana tasmasecta tasmasecta','Paronana tasmasecta tasmasecta','Paronana tasmasect tasmasect',3,0,'','','Salmon','6a64d95d-c584-5d5c-aeeb-5a3b490201b0','Paronana tasmasecta tasmasecta (Salmon, 1941)','(Salmon, 1941)','SUBSPECIES','','Paronana','','tasmasecta','tasmasecta','','',NULL,'','','','','','Salmon','','','','1941','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ae382d1-8ab4-428c-969e-55143f51729f','','','Toninia lobulata (Sommerf.) Lynge',1,'Toninia lobulata','Toninia lobulata','Toninia lobulat',2,0,'','','Sommerf.|Lynge','fa71ac84-6432-5238-a1ab-e1463ee47ca3','Toninia lobulata (Sommerf.) Lynge','(Sommerf.) Lynge','SPECIES','','Toninia','','lobulata','','','',NULL,'Lynge','','','','','Sommerf.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ae46e2b-1dc0-4b98-9000-8fd8aa2144e5','','','Egretta T. Forster',1,'Egretta','Egretta','Egretta',1,0,'','','T. Forster','22b07556-bcbf-5d0f-b35b-afdb1bd84937','Egretta T. Forster','T. Forster','GENUS','Egretta','','','','','','',NULL,'','','','','','T. Forster','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ae83139-164b-4998-804c-c49fbb07c1de','','','Parapsyllus lynnae',1,'Parapsyllus lynnae','Parapsyllus lynnae','Parapsyllus lynn',2,0,'','','','735fd863-d964-5d51-b3a2-17ae48a5be40','Parapsyllus lynnae','','SPECIES','','Parapsyllus','','lynnae','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ae6a664-5bab-45f4-9598-eddbf4a39def','','','Lorica',1,'Lorica','Lorica','Lorica',1,0,'','','','037b6d10-78b9-5328-af3e-6671d12aaa79','Lorica','','GENUS','Lorica','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ae0a6a5-32ab-4a63-ae69-f30c7c807c51','','','Diaporthe hyperopta Nitschke ex G.H. Otth',1,'Diaporthe hyperopta','Diaporthe hyperopta','Diaporthe hyperopt',2,0,'','','Nitschke|G. H. Otth','b9d83d1b-2195-5053-9fbf-f2f738428e1c','Diaporthe hyperopta Nitschke ex G.H. Otth','Nitschke ex G.H. Otth','SPECIES','','Diaporthe','','hyperopta','','','',NULL,'','','','','','Nitschke','','G. H. Otth','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0aefaff0-2364-415f-9de3-9db5366bdede','','','Banksia grandis Willd.',1,'Banksia grandis','Banksia grandis','Banksia grand',2,0,'','','Willd.','21f1367c-9983-5c5a-8dfa-8923e40b18c4','Banksia grandis Willd.','Willd.','SPECIES','','Banksia','','grandis','','','',NULL,'','','','','','Willd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0aee0dd3-bdc7-4f65-b6f7-d5ec551d0f46','','','Craterellus insignis Cooke',1,'Craterellus insignis','Craterellus insignis','Craterellus insign',2,0,'','','Cooke','ef7a7d00-5af8-5555-8abb-6bcaf26b4b54','Craterellus insignis Cooke','Cooke','SPECIES','','Craterellus','','insignis','','','',NULL,'','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0aebec76-d32d-470a-844f-e125ccdeeb28','','','Empicoris aculeatus (Bergroth, 1927)',1,'Empicoris aculeatus','Empicoris aculeatus','Empicoris aculeat',2,0,'','','Bergroth','1b02d527-2ee3-5e20-b995-f83f161e0979','Empicoris aculeatus (Bergroth, 1927)','(Bergroth, 1927)','SPECIES','','Empicoris','','aculeatus','','','',NULL,'','','','','','Bergroth','','','','1927','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0af1b0b9-3dbe-4039-b975-38d085e40c96','','','Amandinea decedens (Nyl.) Blaha, H.Mayrhofer & Elix',1,'Amandinea decedens','Amandinea decedens','Amandinea decedens',2,0,'','','Nyl.|Blaha|H. Mayrhofer|Elix','f45a747e-c2fd-5062-8f79-c5a4a00ad032','Amandinea decedens (Nyl.) Blaha, H.Mayrhofer & Elix','(Nyl.) Blaha, H.Mayrhofer & Elix','SPECIES','','Amandinea','','decedens','','','',NULL,'Blaha, H. Mayrhofer & Elix','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0af24918-cf97-4e96-91b4-c6564fd3ce51','','','Phellinus tawhai (G. Cunn.) G. Cunn.',1,'Phellinus tawhai','Phellinus tawhai','Phellinus tawha',2,0,'','','G. Cunn.','6cba64ca-521d-5c24-b2e6-9b7926704189','Phellinus tawhai (G. Cunn.) G. Cunn.','(G. Cunn.) G. Cunn.','SPECIES','','Phellinus','','tawhai','','','',NULL,'G. Cunn.','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0af916bb-b1f7-4ff6-aa00-02d09d8bd063','','','Cosmarium bioculatum var. depressum (Schaarschm.) Schmidle',1,'Cosmarium bioculatum depressum','Cosmarium bioculatum var. depressum','Cosmarium bioculat depress',3,0,'','','Schaarschm.|Schmidle','2fbeeeaf-1b5d-504e-87a8-1f07f692d5a7','Cosmarium bioculatum var. depressum (Schaarschm.) Schmidle','(Schaarschm.) Schmidle','VARIETY','','Cosmarium','','bioculatum','depressum','','',NULL,'Schmidle','','','','','Schaarschm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0af9fb10-a0a0-44b8-9b05-5cb31a93d341','','','Zygosporium masonii S. Hughes',1,'Zygosporium masonii','Zygosporium masonii','Zygosporium mason',2,0,'','','S. Hughes','8a139991-96dc-5f40-943c-f55bab0c2110','Zygosporium masonii S. Hughes','S. Hughes','SPECIES','','Zygosporium','','masonii','','','',NULL,'','','','','','S. Hughes','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0afad465-bdd1-4573-91a0-9b0e5f0fb114','','','Psychropotes longicauda Theel, 1882',1,'Psychropotes longicauda','Psychropotes longicauda','Psychropotes longicaud',2,0,'','','Theel','d8bb57b9-7ad4-5d9e-b4f8-c8f358ca04f7','Psychropotes longicauda Theel, 1882','Theel, 1882','SPECIES','','Psychropotes','','longicauda','','','',NULL,'','','','','','Theel','','','','1882','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0afb2223-26f5-4377-be7a-e3c9b8f5cab3','','','Hydrachna',1,'Hydrachna','Hydrachna','Hydrachna',1,0,'','','','cc0fc6ef-1987-560c-9c04-6248ffef254a','Hydrachna','','GENUS','Hydrachna','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0affad37-4719-460c-a26d-febc3535702c','','','Danthonia antarctica var. α elata Hook.f.',2,'Danthonia antarctica elata','Danthonia antarctica var. elata','Danthonia antarctic elat',3,0,'','','Hook. fil.','9907f671-ecf1-5bdc-8152-b6a5150d8161','Danthonia antarctica var. α elata Hook.f.','Hook.f.','VARIETY','','Danthonia','','antarctica','elata','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b0767dc-1715-4f04-8e81-4241b3af8a00','','','Uredo jucunda Syd.',1,'Uredo jucunda','Uredo jucunda','Uredo iucund',2,0,'','','Syd.','ddc45f35-168d-58c5-99a8-7b90b5a4c576','Uredo jucunda Syd.','Syd.','SPECIES','','Uredo','','jucunda','','','',NULL,'','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b0051e0-9906-4783-91b5-70182bd2c5a1','','','Ustilago schlechteri Henn.',1,'Ustilago schlechteri','Ustilago schlechteri','Ustilago schlechter',2,0,'','','Henn.','8529bb72-fe61-5c70-8393-e870782e0879','Ustilago schlechteri Henn.','Henn.','SPECIES','','Ustilago','','schlechteri','','','',NULL,'','','','','','Henn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b07969f-0229-4de9-90e2-e4d243abbf4a','','','Guttulina silvestrii (Cushman & Ozawa, 1930)',1,'Guttulina silvestrii','Guttulina silvestrii','Guttulina siluestr',2,0,'','','Cushman|Ozawa','32d1c635-fa45-573c-9c7c-60202570b662','Guttulina silvestrii (Cushman & Ozawa, 1930)','(Cushman & Ozawa, 1930)','SPECIES','','Guttulina','','silvestrii','','','',NULL,'','','','','','Cushman & Ozawa','','','','1930','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b08244f-305a-4207-adb9-484ef30d13a0','','','Bellerocheaceae',1,'Bellerocheaceae','Bellerocheaceae','Bellerocheaceae',1,0,'','','','df2385a3-9705-5d99-ad22-bc56f981fc2f','Bellerocheaceae','','FAMILY','Bellerocheaceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b09d13c-fcbe-4a01-958b-69e609ef4321','','','Chrysanthemum paludosum Poir.',1,'Chrysanthemum paludosum','Chrysanthemum paludosum','Chrysanthemum paludos',2,0,'','','Poir.','069652ca-a9ac-50be-837d-49347562e3aa','Chrysanthemum paludosum Poir.','Poir.','SPECIES','','Chrysanthemum','','paludosum','','','',NULL,'','','','','','Poir.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b0a6249-b5e1-42b3-a92c-863335b2a403','','','Phyllachorella sesseae (Syd.) Petr.',1,'Phyllachorella sesseae','Phyllachorella sesseae','Phyllachorella sesse',2,0,'','','Syd.|Petr.','9a25a6ee-726a-5338-a548-048cdce22b92','Phyllachorella sesseae (Syd.) Petr.','(Syd.) Petr.','SPECIES','','Phyllachorella','','sesseae','','','',NULL,'Petr.','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b0e0d6d-d10c-41a1-a360-d0f889657580','','','Tillina enormis Maskell, 1886',1,'Tillina enormis','Tillina enormis','Tillina enorm',2,0,'','','Maskell','c1925771-bd33-591c-9ea4-0cc90cfe839b','Tillina enormis Maskell, 1886','Maskell, 1886','SPECIES','','Tillina','','enormis','','','',NULL,'','','','','','Maskell','','','','1886','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b11805d-7fea-4571-bb94-387c46e1c2c1','','','Novothymbris extremitatis Knight, 1974',1,'Novothymbris extremitatis','Novothymbris extremitatis','Novothymbris extremitat',2,0,'','','Knight','66a6756b-3750-53fc-b17a-1aa62098c286','Novothymbris extremitatis Knight, 1974','Knight, 1974','SPECIES','','Novothymbris','','extremitatis','','','',NULL,'','','','','','Knight','','','','1974','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b163ed8-e86b-4e49-9de8-50fe071ed950','','','Fusarium stilboides Wollenw.',1,'Fusarium stilboides','Fusarium stilboides','Fusarium stilboid',2,0,'','','Wollenw.','d66e5be5-66d8-5759-a101-9c1a81dd086d','Fusarium stilboides Wollenw.','Wollenw.','SPECIES','','Fusarium','','stilboides','','','',NULL,'','','','','','Wollenw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b14199c-2291-4184-b114-c5ddb9bae717','','','Rosellinia rosarum Niessl',1,'Rosellinia rosarum','Rosellinia rosarum','Rosellinia rosar',2,0,'','','Niessl','03959edf-c594-5ec2-866c-3d375e70414a','Rosellinia rosarum Niessl','Niessl','SPECIES','','Rosellinia','','rosarum','','','',NULL,'','','','','','Niessl','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b157c3a-ea1d-4600-8c94-f8ac4582de08','','','Tetrasporaceae',1,'Tetrasporaceae','Tetrasporaceae','Tetrasporaceae',1,0,'','','','03c864b8-c0a5-535e-81fd-799ddc65cb82','Tetrasporaceae','','FAMILY','Tetrasporaceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b18597a-75e7-4c08-a96a-10fab7ca013c','','','Isolepis multinervosa Boeckeler',1,'Isolepis multinervosa','Isolepis multinervosa','Isolepis multineruos',2,0,'','','Boeckeler','a9be5d95-1b5e-5206-8c15-0013eaa0f55f','Isolepis multinervosa Boeckeler','Boeckeler','SPECIES','','Isolepis','','multinervosa','','','',NULL,'','','','','','Boeckeler','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b1ca438-48a4-4511-a2d3-8477dac2277d','','','Aethalium Link',1,'Aethalium','Aethalium','Aethalium',1,0,'','','Link','c675e19a-d1a6-5a47-acee-c784462ad14e','Aethalium Link','Link','GENUS','Aethalium','','','','','','',NULL,'','','','','','Link','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b171749-0da7-4da9-8610-aaa0cea4c557','','','Eragrostis amabilis (L.) Wight & Arn. ex Nees',1,'Eragrostis amabilis','Eragrostis amabilis','Eragrostis amabil',2,0,'','','L.|Wight|Arn.|Nees','2b363be4-ec01-52db-a8bc-985426782b2e','Eragrostis amabilis (L.) Wight & Arn. ex Nees','(L.) Wight & Arn. ex Nees','SPECIES','','Eragrostis','','amabilis','','','',NULL,'Wight & Arn.','','Nees','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b226557-21b9-4aff-ab59-7059de7a61ac','','','Selidosema terrena Philpott, 1915',1,'Selidosema terrena','Selidosema terrena','Selidosema terren',2,0,'','','Philpott','d023abba-c06c-5503-b711-8a0f5c31b91a','Selidosema terrena Philpott, 1915','Philpott, 1915','SPECIES','','Selidosema','','terrena','','','',NULL,'','','','','','Philpott','','','','1915','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b23bf55-0db8-428d-9ef0-d74459b0ea9d','','','Eunotia gracillima (Krasske) Norpel',1,'Eunotia gracillima','Eunotia gracillima','Eunotia gracillim',2,0,'','','Krasske|Norpel','7647b844-36dd-5448-886e-59dbb1fba09f','Eunotia gracillima (Krasske) Norpel','(Krasske) Norpel','SPECIES','','Eunotia','','gracillima','','','',NULL,'Norpel','','','','','Krasske','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b264a95-faba-467a-869e-fa5dca6054cf','','','Prionurus maculatus Ogilby, 1887',1,'Prionurus maculatus','Prionurus maculatus','Prionurus maculat',2,0,'','','Ogilby','a039cf5b-6098-5bf5-9b7e-2270b760b7fd','Prionurus maculatus Ogilby, 1887','Ogilby, 1887','SPECIES','','Prionurus','','maculatus','','','',NULL,'','','','','','Ogilby','','','','1887','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a3f29fa-5ee2-4279-a2ac-0b4e0570758e','','','Mielichhoferia sericeus Dozy Molk.',1,'Mielichhoferia sericeus','Mielichhoferia sericeus','Mielichhoferia serice',2,0,'','','Dozy Molk.','68932345-9891-587e-9d05-e34b0672cf75','Mielichhoferia sericeus Dozy Molk.','Dozy Molk.','SPECIES','','Mielichhoferia','','sericeus','','','',NULL,'','','','','','Dozy Molk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a3f5f50-05c0-4226-aaf1-aa807ab0dec1','','','Leptotarsus fucatus (Hutton, 1900)',1,'Leptotarsus fucatus','Leptotarsus fucatus','Leptotarsus fucat',2,0,'','','Hutton','17ab14d9-d120-5eb2-bcb3-060a14a0a2b9','Leptotarsus fucatus (Hutton, 1900)','(Hutton, 1900)','SPECIES','','Leptotarsus','','fucatus','','','',NULL,'','','','','','Hutton','','','','1900','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a3e10b9-de44-41e1-b300-fec82f7b1bce','','','Anaulaceae',1,'Anaulaceae','Anaulaceae','Anaulaceae',1,0,'','','','6b724c8b-6c06-5f3a-bd2a-a86e41c87a79','Anaulaceae','','FAMILY','Anaulaceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a4e4633-1a82-4e2f-bd96-30c8f2fefc82','','','Thylacoplethus',1,'Thylacoplethus','Thylacoplethus','Thylacoplethus',1,0,'','','','10a52d31-df40-5dc1-ab80-362a4b3c20e2','Thylacoplethus','','GENUS','Thylacoplethus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a4a04d2-62e3-41fd-a347-4599eb39dd60','','','Grimmia pulvinata (Hedw.) Sm. & Sowerby var. pulvinata',1,'Grimmia pulvinata pulvinata','Grimmia pulvinata var. pulvinata','Grimmia puluinat puluinat',3,0,'','','','13059939-f965-5534-bf2d-5436e9df2b34','Grimmia pulvinata (Hedw.) Sm. & Sowerby var. pulvinata','','VARIETY','','Grimmia','','pulvinata','pulvinata','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a4cf2fc-2847-4089-8392-b8c75a5cf3ed','','','Pseudoalteromonadaceae Ivanova et al., 2004',1,'Pseudoalteromonadaceae','Pseudoalteromonadaceae','Pseudoalteromonadaceae',1,0,'','','Ivanova et al.','a7532a15-4425-5ce4-b94e-9d3ce4954275','Pseudoalteromonadaceae Ivanova et al., 2004','Ivanova et al., 2004','FAMILY','Pseudoalteromonadaceae','','','','','','',NULL,'','','','','','Ivanova et al.','','','','2004','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a4d0538-4070-4fce-8916-fc27b04ad1b4','','','Bactrocera tryoni (Froggatt, 1897)',1,'Bactrocera tryoni','Bactrocera tryoni','Bactrocera tryon',2,0,'','','Froggatt','9dfa02c2-6bb3-5a64-81ff-eaffa6a3ba29','Bactrocera tryoni (Froggatt, 1897)','(Froggatt, 1897)','SPECIES','','Bactrocera','','tryoni','','','',NULL,'','','','','','Froggatt','','','','1897','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a4fccd0-8cd4-44f3-8ce8-352aed23744d','','','Gliocladium viride Matr.',1,'Gliocladium viride','Gliocladium viride','Gliocladium uirid',2,0,'','','Matr.','fd7a1e5b-9082-5fda-8874-160f8ca1a9a4','Gliocladium viride Matr.','Matr.','SPECIES','','Gliocladium','','viride','','','',NULL,'','','','','','Matr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a51145d-ad3f-494f-a5b2-82416f0973ab','','','Nicolea',1,'Nicolea','Nicolea','Nicolea',1,0,'','','','ba05877d-5024-54fc-b4eb-4971a47bfcfb','Nicolea','','GENUS','Nicolea','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a59eeb7-6874-43fc-aa59-36bf24b1426a','','','Aecidium traversiae G. Cunn.',1,'Aecidium traversiae','Aecidium traversiae','Aecidium trauersi',2,0,'','','G. Cunn.','80e65ec3-932f-5191-be4e-08a3d0e68431','Aecidium traversiae G. Cunn.','G. Cunn.','SPECIES','','Aecidium','','traversiae','','','',NULL,'','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a58ed51-a6e7-4267-adf2-4ae074e9c016','','','Bovista pila Berk. & M.A. Curtis',1,'Bovista pila','Bovista pila','Bovista pil',2,0,'','','Berk.|M. A. Curtis','55dd2bbc-1cca-53d9-9fcd-f063ba72fcfe','Bovista pila Berk. & M.A. Curtis','Berk. & M.A. Curtis','SPECIES','','Bovista','','pila','','','',NULL,'','','','','','Berk. & M. A. Curtis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a5b689b-7983-45f4-9688-9cb40f9bc5c6','','','Neomeniidae',1,'Neomeniidae','Neomeniidae','Neomeniidae',1,0,'','','','f0c1972c-f9dc-5211-aad1-6ebec917b32e','Neomeniidae','','FAMILY','Neomeniidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a5ddd2b-798a-4849-a1d6-db9fa6bd419a','','','Hypoxylon allantoideum Cooke',1,'Hypoxylon allantoideum','Hypoxylon allantoideum','Hypoxylon allantoide',2,0,'','','Cooke','2af38dc2-4e7d-5adf-b52d-a05526b85488','Hypoxylon allantoideum Cooke','Cooke','SPECIES','','Hypoxylon','','allantoideum','','','',NULL,'','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a631cf0-b58f-4d66-9acb-1f2ba5a0ec6c','','','Gliophorus lilacipes E. Horak',1,'Gliophorus lilacipes','Gliophorus lilacipes','Gliophorus lilacip',2,0,'','','E. Horak','cc69844c-2008-5bc3-a28e-52cfc48bc2a3','Gliophorus lilacipes E. Horak','E. Horak','SPECIES','','Gliophorus','','lilacipes','','','',NULL,'','','','','','E. Horak','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a6119a2-a169-443f-910c-9ba8a83ed7f4','','','Liochoria nigricans (Broun, 1881)',1,'Liochoria nigricans','Liochoria nigricans','Liochoria nigricans',2,0,'','','Broun','49020c05-294c-5140-a5e4-819ff8c43db4','Liochoria nigricans (Broun, 1881)','(Broun, 1881)','SPECIES','','Liochoria','','nigricans','','','',NULL,'','','','','','Broun','','','','1881','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a65c8d1-c974-4b25-a46c-b49f17e73a72','','','Lepidozia obtusiloba Steph.',1,'Lepidozia obtusiloba','Lepidozia obtusiloba','Lepidozia obtusilob',2,0,'','','Steph.','2e6c871e-8003-5e56-be31-363e21cfb583','Lepidozia obtusiloba Steph.','Steph.','SPECIES','','Lepidozia','','obtusiloba','','','',NULL,'','','','','','Steph.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a674bf8-3eb8-4db7-b51c-c73a4211fc75','','','Lonicera korolkowii Stapf',1,'Lonicera korolkowii','Lonicera korolkowii','Lonicera korolkow',2,0,'','','Stapf','f5cc921c-63a0-5558-8832-15a430c9e96c','Lonicera korolkowii Stapf','Stapf','SPECIES','','Lonicera','','korolkowii','','','',NULL,'','','','','','Stapf','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a6f1dc6-56e0-4f70-a506-3f90941c0785','','','Psegmatopterus Chaudoir, 1878',1,'Psegmatopterus','Psegmatopterus','Psegmatopterus',1,0,'','','Chaudoir','6c1c9588-de19-559d-bad1-b26ff3301124','Psegmatopterus Chaudoir, 1878','Chaudoir, 1878','GENUS','Psegmatopterus','','','','','','',NULL,'','','','','','Chaudoir','','','','1878','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a6e2ee7-41eb-4f10-9b6c-58d7e5dfdaf9','','','Bactrodesmium nothofagi J.A. Cooper',1,'Bactrodesmium nothofagi','Bactrodesmium nothofagi','Bactrodesmium nothofag',2,0,'','','J. A. Cooper','90cee935-d173-5d50-b450-15ecfe96caef','Bactrodesmium nothofagi J.A. Cooper','J.A. Cooper','SPECIES','','Bactrodesmium','','nothofagi','','','',NULL,'','','','','','J. A. Cooper','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a71630d-9c43-4f44-91b6-c7446694f9e4','','','Saprolegnia unispora (Coker & Couch) R.L. Seym.',1,'Saprolegnia unispora','Saprolegnia unispora','Saprolegnia unispor',2,0,'','','Coker|Couch|R. L. Seym.','84b1a9d3-e61a-53b8-a916-b0a28d5f04a4','Saprolegnia unispora (Coker & Couch) R.L. Seym.','(Coker & Couch) R.L. Seym.','SPECIES','','Saprolegnia','','unispora','','','',NULL,'R. L. Seym.','','','','','Coker & Couch','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a72d01d-93f4-4543-80a4-36e0a3cf8925','','','Jungermannia anguiformis Hook.f. & Taylor',1,'Jungermannia anguiformis','Jungermannia anguiformis','Jungermannia anguiform',2,0,'','','Hook. fil.|Taylor','28065b32-b619-5194-a55a-b70e7f915409','Jungermannia anguiformis Hook.f. & Taylor','Hook.f. & Taylor','SPECIES','','Jungermannia','','anguiformis','','','',NULL,'','','','','','Hook. fil. & Taylor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a762ef3-81d2-4a2a-a378-92de12d347b2','','','Leucadendron spicatum P.J.Bergius',1,'Leucadendron spicatum','Leucadendron spicatum','Leucadendron spicat',2,0,'','','P. J. Bergius','7ea385d4-bb8c-5046-a3b2-fa7b7fb5cb88','Leucadendron spicatum P.J.Bergius','P.J.Bergius','SPECIES','','Leucadendron','','spicatum','','','',NULL,'','','','','','P. J. Bergius','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a782a0b-f123-43c2-9c40-e5d6cdec3410','','','Cribrariales T. Macbr.',1,'Cribrariales','Cribrariales','Cribrariales',1,0,'','','T. Macbr.','ee27c72a-5365-5acc-aac4-d8baee111e4e','Cribrariales T. Macbr.','T. Macbr.','ORDER','Cribrariales','','','','','','',NULL,'','','','','','T. Macbr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a7ac9b2-b539-44db-ae28-184423e8dbcb','','','Enterobacter dissolvens (Rosen 1922) Brenner et al., 1988',1,'Enterobacter dissolvens','Enterobacter dissolvens','Enterobacter dissoluens',2,0,'','','Rosen|Brenner et al.','42393750-a687-537a-b80c-62cfadf5d3a3','Enterobacter dissolvens (Rosen 1922) Brenner et al., 1988','(Rosen 1922) Brenner et al., 1988','SPECIES','','Enterobacter','','dissolvens','','','',NULL,'Brenner et al.','','','','1988','Rosen','','','','1922','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a7bf09c-af8e-45cf-b2b8-a1b9985347c0','','','Cladosporium brevipes Peck',1,'Cladosporium brevipes','Cladosporium brevipes','Cladosporium breuip',2,0,'','','Peck','3b4fcb26-4ce3-5ef1-af42-f148f7dcce91','Cladosporium brevipes Peck','Peck','SPECIES','','Cladosporium','','brevipes','','','',NULL,'','','','','','Peck','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a7b147a-b87c-4d42-aa37-d56d481a5ec0','','','Calamistrum novae-hollandiae (A.Br.) Kuntze',1,'Calamistrum novae-hollandiae','Calamistrum novae-hollandiae','Calamistrum nouae-hollandi',2,0,'','','A. Br.|Kuntze','79c29ded-62f1-50fb-b5cb-9139480f19e0','Calamistrum novae-hollandiae (A.Br.) Kuntze','(A.Br.) Kuntze','SPECIES','','Calamistrum','','novae-hollandiae','','','',NULL,'Kuntze','','','','','A. Br.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a86e695-a480-4c20-ba00-82c6b3af632f','','','Coenagrionidae',1,'Coenagrionidae','Coenagrionidae','Coenagrionidae',1,0,'','','','793e2f04-e1b0-5dca-a5f4-d2e8e02e82e6','Coenagrionidae','','FAMILY','Coenagrionidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a833dfc-4f1c-4126-a3fa-92a87fa3c76d','','','Diacavolinia longirostris (Blainville, 1821)',1,'Diacavolinia longirostris','Diacavolinia longirostris','Diacavolinia longirostr',2,0,'','','Blainville','7fddd022-802d-5d91-938b-fdc71f4c4eb8','Diacavolinia longirostris (Blainville, 1821)','(Blainville, 1821)','SPECIES','','Diacavolinia','','longirostris','','','',NULL,'','','','','','Blainville','','','','1821','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a8600de-683d-4b9a-a32c-ed7dd841f1fe','','','Ascochytula ulicis Grove',1,'Ascochytula ulicis','Ascochytula ulicis','Ascochytula ulic',2,0,'','','Grove','9d265e8a-16f5-560d-82db-9c387f0e355e','Ascochytula ulicis Grove','Grove','SPECIES','','Ascochytula','','ulicis','','','',NULL,'','','','','','Grove','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a8c0955-f448-4349-98c9-3eeaa0c6eeaf','','','Cladonia aspera (Flörke) Doign.',1,'Cladonia aspera','Cladonia aspera','Cladonia asper',2,0,'','','Flörke|Doign.','7a27fcfc-60be-507c-8206-304e2028c715','Cladonia aspera (Flörke) Doign.','(Flörke) Doign.','SPECIES','','Cladonia','','aspera','','','',NULL,'Doign.','','','','','Flörke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0a8a6a68-c401-471a-87df-c42ae4d744a8','','','Lomaria oligoneuron Colenso',1,'Lomaria oligoneuron','Lomaria oligoneuron','Lomaria oligoneuron',2,0,'','','Colenso','aa72633a-21ca-549e-a4d5-2ca351eef37f','Lomaria oligoneuron Colenso','Colenso','SPECIES','','Lomaria','','oligoneuron','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('090d3c2c-9a23-4731-9c85-edc639cc0e71','','','Staurastrum striolatum (Nägeli) W. Archer',1,'Staurastrum striolatum','Staurastrum striolatum','Staurastrum striolat',2,0,'','','Nägeli|W. Archer','3512beef-9bff-5a4b-b88a-463ea19a4788','Staurastrum striolatum (Nägeli) W. Archer','(Nägeli) W. Archer','SPECIES','','Staurastrum','','striolatum','','','',NULL,'W. Archer','','','','','Nägeli','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09125e4d-c265-4fc0-9994-2b43b29d51cc','','','Ramularia lonicerae Voglino',1,'Ramularia lonicerae','Ramularia lonicerae','Ramularia lonicer',2,0,'','','Voglino','cdd7ab63-8d78-5ffd-b427-cee2c0c99526','Ramularia lonicerae Voglino','Voglino','SPECIES','','Ramularia','','lonicerae','','','',NULL,'','','','','','Voglino','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09165179-0364-4869-a0d4-60adf1bca87d','','','Rhodobryum albolimbatum Hampe',1,'Rhodobryum albolimbatum','Rhodobryum albolimbatum','Rhodobryum albolimbat',2,0,'','','Hampe','61652e9a-19c8-5098-87cb-2de86718210c','Rhodobryum albolimbatum Hampe','Hampe','SPECIES','','Rhodobryum','','albolimbatum','','','',NULL,'','','','','','Hampe','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0912bbe4-a182-45fe-af90-c320d96ad47d','','','Endocalyx melanoxanthus (Berk. & Broome) Petch',1,'Endocalyx melanoxanthus','Endocalyx melanoxanthus','Endocalyx melanoxanth',2,0,'','','Berk.|Broome|Petch','ec0003f2-6987-52d8-a223-46c21e70bde7','Endocalyx melanoxanthus (Berk. & Broome) Petch','(Berk. & Broome) Petch','SPECIES','','Endocalyx','','melanoxanthus','','','',NULL,'Petch','','','','','Berk. & Broome','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('091796f2-ac30-4bd5-8e44-1e338e920a20','','','Oncousoecia dilatans (Johnston, 1847)',1,'Oncousoecia dilatans','Oncousoecia dilatans','Oncousoecia dilatans',2,0,'','','Johnston','dcb431dd-3d11-5b46-8721-f78db2e75abb','Oncousoecia dilatans (Johnston, 1847)','(Johnston, 1847)','SPECIES','','Oncousoecia','','dilatans','','','',NULL,'','','','','','Johnston','','','','1847','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('091ee51e-4a94-4c54-9b64-77f207fea584','','','Staurastrum trifidum Nordst.',1,'Staurastrum trifidum','Staurastrum trifidum','Staurastrum trifid',2,0,'','','Nordst.','869d5f68-1e1c-5a09-9228-eb0f0eaaf3b6','Staurastrum trifidum Nordst.','Nordst.','SPECIES','','Staurastrum','','trifidum','','','',NULL,'','','','','','Nordst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09199521-5484-42be-a2da-aa5c9b8f4660','','','Bactrocera Macquart, 1835',1,'Bactrocera','Bactrocera','Bactrocera',1,0,'','','Macquart','b1191dd2-9e4b-545f-ab08-2b82d10b7c4d','Bactrocera Macquart, 1835','Macquart, 1835','GENUS','Bactrocera','','','','','','',NULL,'','','','','','Macquart','','','','1835','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('091ab706-0e0d-4beb-8a70-e590b11f7a66','','','Lobatiriccardia coronopus (De Not. ex Steph.) Furuki',1,'Lobatiriccardia coronopus','Lobatiriccardia coronopus','Lobatiriccardia coronop',2,0,'','','De Not.|Steph.|Furuki','08ad1d3b-cb63-5376-941d-536acc382d7e','Lobatiriccardia coronopus (De Not. ex Steph.) Furuki','(De Not. ex Steph.) Furuki','SPECIES','','Lobatiriccardia','','coronopus','','','',NULL,'Furuki','','','','','De Not.','','Steph.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0922e21c-c794-46e1-83e5-6cc69c3e7b3a','','','Boletus scaber aff. Rawlings',4,'','','',NULL,NULL,'','','','','Boletus scaber aff. Rawlings','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('092705f5-79d4-4d92-a68f-71f391645440','','','Parlibellus bennikei Witkowski',1,'Parlibellus bennikei','Parlibellus bennikei','Parlibellus bennike',2,0,'','','Witkowski','9c1094bb-b712-507e-a2b5-bff672cd3915','Parlibellus bennikei Witkowski','Witkowski','SPECIES','','Parlibellus','','bennikei','','','',NULL,'','','','','','Witkowski','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0923db7f-b0ef-4651-b340-9015897eed96','','','Xanthomonas campestris pv. olitorii (Sabet 1957) Dye, 1978',1,'Xanthomonas campestris olitorii','Xanthomonas campestris pv. olitorii','Xanthomonas campestr olitor',3,0,'','','Sabet|Dye','d9b976a7-0327-5807-9de4-284b9c14b320','Xanthomonas campestris pv. olitorii (Sabet 1957) Dye, 1978','(Sabet 1957) Dye, 1978','PATHOVAR','','Xanthomonas','','campestris','olitorii','','',NULL,'Dye','','','','1978','Sabet','','','','1957','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09272b11-121c-45ac-900d-e863b99be2e7','','','Adriopea pallidata Broun, 1910',1,'Adriopea pallidata','Adriopea pallidata','Adriopea pallidat',2,0,'','','Broun','dcd81cce-eb4e-5d8c-bba5-a166c9925b17','Adriopea pallidata Broun, 1910','Broun, 1910','SPECIES','','Adriopea','','pallidata','','','',NULL,'','','','','','Broun','','','','1910','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('092bde20-2a69-4aa4-934a-4bdbea573b01','','','Chroococcus dispersus',1,'Chroococcus dispersus','Chroococcus dispersus','Chroococcus dispers',2,0,'','','','e73f1ca6-8729-5dba-b11d-f420c4448360','Chroococcus dispersus','','SPECIES','','Chroococcus','','dispersus','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('092f8683-8295-4f7f-8ee8-7b1bf56b65da','','','Diomedea melanophrys Temminck',1,'Diomedea melanophrys','Diomedea melanophrys','Diomedea melanophrys',2,0,'','','Temminck','e7386fe5-5e47-598f-86a2-c966b0829e62','Diomedea melanophrys Temminck','Temminck','SPECIES','','Diomedea','','melanophrys','','','',NULL,'','','','','','Temminck','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('092c6fb3-1b7e-4c14-aeb7-e250bb827e17','','','Sticta pedunculata Kremp.',1,'Sticta pedunculata','Sticta pedunculata','Sticta pedunculat',2,0,'','','Kremp.','4760c5c6-72d0-5e06-9547-5a65fa3d5b2e','Sticta pedunculata Kremp.','Kremp.','SPECIES','','Sticta','','pedunculata','','','',NULL,'','','','','','Kremp.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('092fe643-ba07-4881-b59b-f0094a703c03','','','Sarcostroma Cooke',1,'Sarcostroma','Sarcostroma','Sarcostroma',1,0,'','','Cooke','6b4052bf-0397-5587-8ace-7756a6b08ab5','Sarcostroma Cooke','Cooke','GENUS','Sarcostroma','','','','','','',NULL,'','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09330e72-201e-4847-b04a-177fc26dbe3d','','','Gen. nov. 2',NULL,'','','',NULL,NULL,'','','','','Gen. nov. 2','','GENUS','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09381d1c-d63e-44d1-bf94-26347fc0b440','','','Palazzia',1,'Palazzia','Palazzia','Palazzia',1,0,'','','','b1ae86fd-337d-54e0-8776-00e5fcb219cf','Palazzia','','GENUS','Palazzia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0933433f-dab7-48ba-918a-42f9c3b61f1a','','','Immergentia',1,'Immergentia','Immergentia','Immergentia',1,0,'','','','94e9a3df-5cba-5aee-b24f-ffe34ecc6474','Immergentia','','GENUS','Immergentia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0930f037-db69-409e-9ebc-6c9eb8e5619d','','','Magilus antiquus Monfort, 1810',1,'Magilus antiquus','Magilus antiquus','Magilus antiqu',2,0,'','','Monfort','f15b4d15-4f3b-5f46-9f0f-e0d5994944a3','Magilus antiquus Monfort, 1810','Monfort, 1810','SPECIES','','Magilus','','antiquus','','','',NULL,'','','','','','Monfort','','','','1810','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('093702ef-8fb5-4d12-960f-a3a227e041cc','','','Trametes variiformis (Peck) Peck',1,'Trametes variiformis','Trametes variiformis','Trametes uariiform',2,0,'','','Peck','fd3d05a0-1a88-5d70-b389-0ef3cfdf288e','Trametes variiformis (Peck) Peck','(Peck) Peck','SPECIES','','Trametes','','variiformis','','','',NULL,'Peck','','','','','Peck','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('093acba6-0403-4582-b8d6-05afce3d59a1','','','Harmonia conformis (Boisduval, 1835)',1,'Harmonia conformis','Harmonia conformis','Harmonia conform',2,0,'','','Boisduval','ee505887-50fd-5d98-a4bb-10a2b98b1f53','Harmonia conformis (Boisduval, 1835)','(Boisduval, 1835)','SPECIES','','Harmonia','','conformis','','','',NULL,'','','','','','Boisduval','','','','1835','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('093a4c02-53ed-4c10-a159-8b859c905632','','','Tangata furcata Forster & Platnick, 1985',1,'Tangata furcata','Tangata furcata','Tangata furcat',2,0,'','','Forster|Platnick','60364d54-9c82-5739-91bb-53fa5a0630b7','Tangata furcata Forster & Platnick, 1985','Forster & Platnick, 1985','SPECIES','','Tangata','','furcata','','','',NULL,'','','','','','Forster & Platnick','','','','1985','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('093fc640-4675-4f75-adef-f3eaf18b8a9d','','','Nothofageae Baum.-Bod.',1,'Nothofageae','Nothofageae','Nothofageae',1,0,'','','Baum.-Bod.','358d413b-bbcc-5e62-8c71-f2286ba25549','Nothofageae Baum.-Bod.','Baum.-Bod.','TRIBE','Nothofageae','','','','','','',NULL,'','','','','','Baum.-Bod.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0945384f-6e41-491c-9a55-3d8a0f64adf6','','','Craterium Trentep.',1,'Craterium','Craterium','Craterium',1,0,'','','Trentep.','2e65299e-621e-52cd-b494-91d64be79081','Craterium Trentep.','Trentep.','GENUS','Craterium','','','','','','',NULL,'','','','','','Trentep.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0942a4f5-6899-4d7e-a4cb-5d57f7d03685','','','Oedogonium sexangulare var. maius Wille',1,'Oedogonium sexangulare maius','Oedogonium sexangulare var. maius','Oedogonium sexangular ma',3,0,'','','Wille','62fa6a8d-7396-581a-a000-07fee1bb3dc1','Oedogonium sexangulare var. maius Wille','Wille','VARIETY','','Oedogonium','','sexangulare','maius','','',NULL,'','','','','','Wille','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('094490d6-84ee-4248-a620-eeab9431138f','','','Xanthomonas translucens pv. graminis (Egli et al. 1975) Vauterin et al., 1995',1,'Xanthomonas translucens graminis','Xanthomonas translucens pv. graminis','Xanthomonas translucens gramin',3,0,'','','Egli et al.|Vauterin et al.','d4260974-94d7-52a4-ade5-2a1f0643498a','Xanthomonas translucens pv. graminis (Egli et al. 1975) Vauterin et al., 1995','(Egli et al. 1975) Vauterin et al., 1995','PATHOVAR','','Xanthomonas','','translucens','graminis','','',NULL,'Vauterin et al.','','','','1995','Egli et al.','','','','1975','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09484c7c-d272-403f-a3ca-1ebc9739d5bf','','','Staurastrum lunatum var. lunatum Ralfs',1,'Staurastrum lunatum lunatum','Staurastrum lunatum var. lunatum','Staurastrum lunat lunat',3,0,'','','Ralfs','0234f5d9-9a05-56d1-920c-10671f5aa747','Staurastrum lunatum var. lunatum Ralfs','Ralfs','VARIETY','','Staurastrum','','lunatum','lunatum','','',NULL,'','','','','','Ralfs','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('094a50a2-0972-45d8-994e-3e6924207e4d','','','Hydrocotyle umbellata L.',1,'Hydrocotyle umbellata','Hydrocotyle umbellata','Hydrocotyle umbellat',2,0,'','','L.','a5637f85-8bb4-5c1a-9c55-50f587161619','Hydrocotyle umbellata L.','L.','SPECIES','','Hydrocotyle','','umbellata','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('094b31c7-9cf8-4e06-863d-b3fc6cd128f6','','','Ophiocomidae',1,'Ophiocomidae','Ophiocomidae','Ophiocomidae',1,0,'','','','078a40de-eafd-5e14-af94-d25f04564a1b','Ophiocomidae','','FAMILY','Ophiocomidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0949d626-2353-4fd0-b729-cbae48135484','','','Trichoderma species 753 Braithwaite et al.',4,'','','',NULL,NULL,'','','','','Trichoderma species 753 Braithwaite et al.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09472089-b028-4f6d-a250-f21897e30b6b','','','Ascochyta pteridis Bres.',1,'Ascochyta pteridis','Ascochyta pteridis','Ascochyta pterid',2,0,'','','Bres.','5ad01d09-37f4-5119-97eb-9b3b4bc6b8fa','Ascochyta pteridis Bres.','Bres.','SPECIES','','Ascochyta','','pteridis','','','',NULL,'','','','','','Bres.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09527bcc-922e-4c65-8ce6-19cf798625d8','','','Psiloclada Mitt.',1,'Psiloclada','Psiloclada','Psiloclada',1,0,'','','Mitt.','e099b42f-30cd-5737-b575-3cc7a5ea5e81','Psiloclada Mitt.','Mitt.','GENUS','Psiloclada','','','','','','',NULL,'','','','','','Mitt.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('094dbd4a-b987-4fa7-8f07-67930c5cf8cb','','','Alocasia macrorrhizos (L.) G.Don',1,'Alocasia macrorrhizos','Alocasia macrorrhizos','Alocasia macrorrhiz',2,0,'','','L.|G. Don','eedc0758-11b3-5d51-8c78-bb427c871a06','Alocasia macrorrhizos (L.) G.Don','(L.) G.Don','SPECIES','','Alocasia','','macrorrhizos','','','',NULL,'G. Don','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('094d632e-edb1-4de9-bf40-a0de1ddf067f','','','Molophilus abruptus Alexander, 1923',1,'Molophilus abruptus','Molophilus abruptus','Molophilus abrupt',2,0,'','','Alexander','cf1a0f85-6b08-5a1c-b100-d7e92b3da1f6','Molophilus abruptus Alexander, 1923','Alexander, 1923','SPECIES','','Molophilus','','abruptus','','','',NULL,'','','','','','Alexander','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0958dec4-c9f1-4cd1-abd3-1548d12249cd','','','Collema F.H.Wigg.',1,'Collema','Collema','Collema',1,0,'','','F. H. Wigg.','a76b5224-8c74-5f8e-98f1-e6c59dc888e8','Collema F.H.Wigg.','F.H.Wigg.','GENUS','Collema','','','','','','',NULL,'','','','','','F. H. Wigg.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09569921-71eb-4b43-94aa-65f22229bfcd','','','Pteris incisa Thunb.',1,'Pteris incisa','Pteris incisa','Pteris incis',2,0,'','','Thunb.','438e536b-bdc1-57fc-bf8e-922404e240f8','Pteris incisa Thunb.','Thunb.','SPECIES','','Pteris','','incisa','','','',NULL,'','','','','','Thunb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09552aae-fa83-4d7f-bd5b-78eea1ed4ba9','','','Trisetum antarcticum (G.Forst.) Trin.',1,'Trisetum antarcticum','Trisetum antarcticum','Trisetum antarctic',2,0,'','','G. Forst.|Trin.','b7971163-e237-5483-91eb-c0cced0c8ecf','Trisetum antarcticum (G.Forst.) Trin.','(G.Forst.) Trin.','SPECIES','','Trisetum','','antarcticum','','','',NULL,'Trin.','','','','','G. Forst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09555c75-dcba-4c5b-89de-e5ddf8f691e6','','','Pareuchaeta bisinuata (Sars, 1907)',1,'Pareuchaeta bisinuata','Pareuchaeta bisinuata','Pareuchaeta bisinuat',2,0,'','','Sars','30ba5c04-dac4-5928-b9dd-9483f29ad203','Pareuchaeta bisinuata (Sars, 1907)','(Sars, 1907)','SPECIES','','Pareuchaeta','','bisinuata','','','',NULL,'','','','','','Sars','','','','1907','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08c9292f-2da6-4254-86b5-50aed5ca2779','','','Paradiopatra',1,'Paradiopatra','Paradiopatra','Paradiopatra',1,0,'','','','b97f610a-c374-5d80-bdb6-b8151cf08b74','Paradiopatra','','GENUS','Paradiopatra','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08c665ee-9e0a-4429-ac51-5ea07add999b','','','Hebe diosmifolia var. trisepala (Colenso) A.Wall',1,'Hebe diosmifolia trisepala','Hebe diosmifolia var. trisepala','Hebe diosmifol trisepal',3,0,'','','Colenso|A. Wall','0b3dd014-ebc6-5a9d-a402-7380902c4e40','Hebe diosmifolia var. trisepala (Colenso) A.Wall','(Colenso) A.Wall','VARIETY','','Hebe','','diosmifolia','trisepala','','',NULL,'A. Wall','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08c99185-d054-4925-991b-9101c0cf18d8','','','Paecilomyces niphetodes Samson',1,'Paecilomyces niphetodes','Paecilomyces niphetodes','Paecilomyces niphetod',2,0,'','','Samson','1601e622-ac22-5b9f-926a-db57f30bb77a','Paecilomyces niphetodes Samson','Samson','SPECIES','','Paecilomyces','','niphetodes','','','',NULL,'','','','','','Samson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08c61142-bc95-4d25-b06a-ad00d0f03e0a','','','Pleurotus cystidiosus O.K. Mill.',1,'Pleurotus cystidiosus','Pleurotus cystidiosus','Pleurotus cystidios',2,0,'','','O. K. Mill.','4f899ac3-e62d-5941-9436-af430c9cc379','Pleurotus cystidiosus O.K. Mill.','O.K. Mill.','SPECIES','','Pleurotus','','cystidiosus','','','',NULL,'','','','','','O. K. Mill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08d080f6-3217-4470-8041-2fb708f39f9d','','','Lichen articulatus L.',1,'Lichen articulatus','Lichen articulatus','Lichen articulat',2,0,'','','L.','aea3c646-1749-5fb0-885d-28496580c451','Lichen articulatus L.','L.','SPECIES','','Lichen','','articulatus','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08cc3376-f7b1-412f-a438-5f721d4eaeee','','','Polygonatum Mill.',1,'Polygonatum','Polygonatum','Polygonatum',1,0,'','','Mill.','854b96f5-f4a8-55fb-9613-dfd5e67ae4fe','Polygonatum Mill.','Mill.','GENUS','Polygonatum','','','','','','',NULL,'','','','','','Mill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08d03369-0f92-4e3b-95ce-af4ec7f4d1d2','','','Cladonia cornuta sensu Galloway',4,'','','',NULL,NULL,'','','','','Cladonia cornuta sensu Galloway','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08d1e657-2bc8-444f-a623-cef35ae4e264','','','Orbiniidae',1,'Orbiniidae','Orbiniidae','Orbiniidae',1,0,'','','','e7f0f4c6-0f2b-577d-be72-e0ae5224ec65','Orbiniidae','','FAMILY','Orbiniidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08d0de85-e6ae-4e32-817e-dbf893947555','','','Conus',1,'Conus','Conus','Conus',1,0,'','','','74c014a7-b0c5-546e-af8f-ec69e83ddec7','Conus','','GENUS','Conus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08d58000-2b2a-48fd-afca-02c8162e08cd','','','Anomalomyces Vánky, M. Lutz & R.G. Shivas',1,'Anomalomyces','Anomalomyces','Anomalomyces',1,0,'','','Vánky|M. Lutz|R. G. Shivas','4cacd331-c061-565a-acb2-607ad9689d25','Anomalomyces Vánky, M. Lutz & R.G. Shivas','Vánky, M. Lutz & R.G. Shivas','GENUS','Anomalomyces','','','','','','',NULL,'','','','','','Vánky, M. Lutz & R. G. Shivas','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08d63a3f-426d-47db-aca5-5d53fceb1ad7','','','Cheiracanthium stratioticum L. Koch, 1873',1,'Cheiracanthium stratioticum','Cheiracanthium stratioticum','Cheiracanthium stratiotic',2,0,'','','L. Koch','47a38da8-4c15-55b9-8431-abf837bf1302','Cheiracanthium stratioticum L. Koch, 1873','L. Koch, 1873','SPECIES','','Cheiracanthium','','stratioticum','','','',NULL,'','','','','','L. Koch','','','','1873','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08d5359c-aa89-4ace-9394-c7b9635eb1b0','','','Valdemunitella valdemunita (Hincks, 1885)',1,'Valdemunitella valdemunita','Valdemunitella valdemunita','Valdemunitella ualdemunit',2,0,'','','Hincks','73f8d752-99f7-5de4-86fa-ccfd88bbbed7','Valdemunitella valdemunita (Hincks, 1885)','(Hincks, 1885)','SPECIES','','Valdemunitella','','valdemunita','','','',NULL,'','','','','','Hincks','','','','1885','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08d4fc31-95b9-4410-804a-f2abb31af017','','','Chrysothricaceae Zahlbr.',1,'Chrysothricaceae','Chrysothricaceae','Chrysothricaceae',1,0,'','','Zahlbr.','3ef33e75-4dd0-5d27-90dd-e15e8006b69c','Chrysothricaceae Zahlbr.','Zahlbr.','FAMILY','Chrysothricaceae','','','','','','',NULL,'','','','','','Zahlbr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08dee709-a86c-4c1e-af90-17ee84de9d20','','','Tulostoma macrosporum G. Cunn.',1,'Tulostoma macrosporum','Tulostoma macrosporum','Tulostoma macrospor',2,0,'','','G. Cunn.','c225944b-b14c-5c04-addd-9149f0c65200','Tulostoma macrosporum G. Cunn.','G. Cunn.','SPECIES','','Tulostoma','','macrosporum','','','',NULL,'','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08dc85bf-3b9e-43ce-a59b-62b1f8e156fc','','','Microbryum davallianum (Sm.) R.H.Zander',1,'Microbryum davallianum','Microbryum davallianum','Microbryum dauallian',2,0,'','','Sm.|R. H. Zander','5c356c73-b846-5c6f-b043-e47f3bc2ee2a','Microbryum davallianum (Sm.) R.H.Zander','(Sm.) R.H.Zander','SPECIES','','Microbryum','','davallianum','','','',NULL,'R. H. Zander','','','','','Sm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08dce54d-a8f2-4c41-9a4f-cf06e0215dc8','','','Urginea Steinh.',1,'Urginea','Urginea','Urginea',1,0,'','','Steinh.','e4e8db39-11a6-5696-8197-14086bb34e55','Urginea Steinh.','Steinh.','GENUS','Urginea','','','','','','',NULL,'','','','','','Steinh.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08dd09d5-37bd-4e62-8ae7-f330bbcde6ee','','','Fissurina consentanea Nyl.',1,'Fissurina consentanea','Fissurina consentanea','Fissurina consentane',2,0,'','','Nyl.','848e4a71-5862-5ad3-9da3-38caba2b6120','Fissurina consentanea Nyl.','Nyl.','SPECIES','','Fissurina','','consentanea','','','',NULL,'','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08e48c01-1206-4ac7-8852-1723c22669dc','','','Rhombocoris similis (Mayr, 1865)',1,'Rhombocoris similis','Rhombocoris similis','Rhombocoris simil',2,0,'','','Mayr','4dd5727b-d3a6-5c8f-836f-b73184d2e27b','Rhombocoris similis (Mayr, 1865)','(Mayr, 1865)','SPECIES','','Rhombocoris','','similis','','','',NULL,'','','','','','Mayr','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08e3227a-4b64-4937-ae2a-59b286654609','','','Urticales',1,'Urticales','Urticales','Urticales',1,0,'','','','97bd1fa0-ef30-5d8b-b918-308f71f0e0a0','Urticales','','ORDER','Urticales','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08e0f231-088b-44e4-a365-5f138d8454e8','','','Corynetes Hazsl.',1,'Corynetes','Corynetes','Corynetes',1,0,'','','Hazsl.','c245cd46-0422-5263-9269-fb39c4fd374c','Corynetes Hazsl.','Hazsl.','GENUS','Corynetes','','','','','','',NULL,'','','','','','Hazsl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08e28299-7353-459c-8fef-b25d319e5616','','','Allium sikkimense Baker',1,'Allium sikkimense','Allium sikkimense','Allium sikkimens',2,0,'','','Baker','e85148ae-1dfa-599b-b4c5-29e037c34dc6','Allium sikkimense Baker','Baker','SPECIES','','Allium','','sikkimense','','','',NULL,'','','','','','Baker','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08e9edb4-d085-49c1-896c-1d25885d04ba','','','Aciphylla horrida W.R.B.Oliv.',1,'Aciphylla horrida','Aciphylla horrida','Aciphylla horrid',2,0,'','','W. R. B. Oliv.','bd2d14ca-5236-51c3-9487-b10bcaaafc4b','Aciphylla horrida W.R.B.Oliv.','W.R.B.Oliv.','SPECIES','','Aciphylla','','horrida','','','',NULL,'','','','','','W. R. B. Oliv.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08ebbe2a-70c5-42e3-a9f8-d06c23caaa3b','','','Agaricus marginatus Batsch',1,'Agaricus marginatus','Agaricus marginatus','Agaricus marginat',2,0,'','','Batsch','ee094ca3-76eb-5310-b83c-63b4afb5e107','Agaricus marginatus Batsch','Batsch','SPECIES','','Agaricus','','marginatus','','','',NULL,'','','','','','Batsch','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08e77d2f-4053-495e-83da-f1f046b70881','','','Cryptopygus parasiticus (Salmon, 1943)',1,'Cryptopygus parasiticus','Cryptopygus parasiticus','Cryptopygus parasitic',2,0,'','','Salmon','639b2470-017a-527f-87d7-ee76e199432e','Cryptopygus parasiticus (Salmon, 1943)','(Salmon, 1943)','SPECIES','','Cryptopygus','','parasiticus','','','',NULL,'','','','','','Salmon','','','','1943','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08f3b13f-d388-4b01-9af0-1c52948fe9d3','','','Leptoypha hospita Drake and Poor, 1937',1,'Leptoypha hospita','Leptoypha hospita','Leptoypha hospit',2,0,'','','Drake|Poor','c8395715-f928-5dbf-896b-b6aea0f457a5','Leptoypha hospita Drake and Poor, 1937','Drake and Poor, 1937','SPECIES','','Leptoypha','','hospita','','','',NULL,'','','','','','Drake & Poor','','','','1937','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08f4c181-3a7d-433c-9319-a460135815d8','','','Parapherusa',1,'Parapherusa','Parapherusa','Parapherusa',1,0,'','','','d351ab7f-ba40-5022-9e67-85a159b6aaf7','Parapherusa','','GENUS','Parapherusa','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08ef5442-e6d1-434b-a2b9-a797138c26e9','','','Inophloeus collinus Broun, 1917',1,'Inophloeus collinus','Inophloeus collinus','Inophloeus collin',2,0,'','','Broun','40685859-db47-5c0f-b272-1e7e23aa2a15','Inophloeus collinus Broun, 1917','Broun, 1917','SPECIES','','Inophloeus','','collinus','','','',NULL,'','','','','','Broun','','','','1917','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08ef308f-457d-44e6-8141-c7c01b14493e','','','Polyoppia Hammer, 1968',1,'Polyoppia','Polyoppia','Polyoppia',1,0,'','','Hammer','3ee9aca6-0735-53b7-a5fc-669f4a1092ca','Polyoppia Hammer, 1968','Hammer, 1968','GENUS','Polyoppia','','','','','','',NULL,'','','','','','Hammer','','','','1968','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08f7cca9-37e7-4831-b454-5475c6dfd77e','','','Siphogenerina dimorpha (Parker & Jones, 1865)',1,'Siphogenerina dimorpha','Siphogenerina dimorpha','Siphogenerina dimorph',2,0,'','','Parker|Jones','7925a833-0483-5a4f-a6c9-bac35b22ca46','Siphogenerina dimorpha (Parker & Jones, 1865)','(Parker & Jones, 1865)','SPECIES','','Siphogenerina','','dimorpha','','','',NULL,'','','','','','Parker & Jones','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08fc0d3b-1138-406d-84df-e8df9a411392','','','Cavinula lacustris (Gregory) Mann & Stickle',1,'Cavinula lacustris','Cavinula lacustris','Cavinula lacustr',2,0,'','','Gregory|Mann|Stickle','fac656d3-b120-5f37-a77d-08fb7514d6da','Cavinula lacustris (Gregory) Mann & Stickle','(Gregory) Mann & Stickle','SPECIES','','Cavinula','','lacustris','','','',NULL,'Mann & Stickle','','','','','Gregory','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09001ea7-3ebc-48b5-a44d-1c64f9d9f1b6','','','Empicoris rubromaculatus obsoletus McAtee & Malloch, 1926',1,'Empicoris rubromaculatus obsoletus','Empicoris rubromaculatus obsoletus','Empicoris rubromaculat obsolet',3,0,'','','McAtee|Malloch','c8a50a8a-4b0c-5e12-8a3b-434d72d68cec','Empicoris rubromaculatus obsoletus McAtee & Malloch, 1926','McAtee & Malloch, 1926','SUBSPECIES','','Empicoris','','rubromaculatus','obsoletus','','',NULL,'','','','','','McAtee & Malloch','','','','1926','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0906fca0-e4ad-42f8-855c-4fa787efded3','','','Goniodes ortygis Denny, 1842',1,'Goniodes ortygis','Goniodes ortygis','Goniodes ortyg',2,0,'','','Denny','85d9d722-d165-51a3-a788-f4cf93589d5c','Goniodes ortygis Denny, 1842','Denny, 1842','SPECIES','','Goniodes','','ortygis','','','',NULL,'','','','','','Denny','','','','1842','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('08ff91a1-8611-4ff4-92eb-7b19b6469995','','','Aulaxina Fée',1,'Aulaxina','Aulaxina','Aulaxina',1,0,'','','Fée','a6e1d160-2845-5225-8763-7e4c69a7d262','Aulaxina Fée','Fée','GENUS','Aulaxina','','','','','','',NULL,'','','','','','Fée','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('090166f3-9eb6-40dd-a08c-a76ee86e1eae','','','Uromyces verruculosus Berk. & Broome',1,'Uromyces verruculosus','Uromyces verruculosus','Uromyces uerruculos',2,0,'','','Berk.|Broome','d8b20de2-7b8d-5e52-a104-c01ac2001471','Uromyces verruculosus Berk. & Broome','Berk. & Broome','SPECIES','','Uromyces','','verruculosus','','','',NULL,'','','','','','Berk. & Broome','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0904a1c9-3b54-428f-b378-c635e1108bf0','','','Chersodromia zelandica Rogers, 1982',1,'Chersodromia zelandica','Chersodromia zelandica','Chersodromia zelandic',2,0,'','','Rogers','3bbb6ecc-75f0-55b3-9a68-3bf9ff7432bc','Chersodromia zelandica Rogers, 1982','Rogers, 1982','SPECIES','','Chersodromia','','zelandica','','','',NULL,'','','','','','Rogers','','','','1982','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('090c14a5-b637-40a2-baf4-1a25f279bbef','','','Schizothrix telephoroides Gomont',1,'Schizothrix telephoroides','Schizothrix telephoroides','Schizothrix telephoroid',2,0,'','','Gomont','fcc770fe-9c4c-5d58-8bbc-82a7f81a3001','Schizothrix telephoroides Gomont','Gomont','SPECIES','','Schizothrix','','telephoroides','','','',NULL,'','','','','','Gomont','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('090819a9-7099-4c38-b1d6-6e974d2e5e31','','','Paradorydium stewartensis Evans, 1966',1,'Paradorydium stewartensis','Paradorydium stewartensis','Paradorydium stewartens',2,0,'','','Evans','c4161199-0965-5de6-850b-bf7b3a62bd1f','Paradorydium stewartensis Evans, 1966','Evans, 1966','SPECIES','','Paradorydium','','stewartensis','','','',NULL,'','','','','','Evans','','','','1966','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09084787-a50c-455a-8a11-aacc89a3413f','','','Tortula torquata (Taylor) Hook.f. & Wilson',1,'Tortula torquata','Tortula torquata','Tortula torquat',2,0,'','','Taylor|Hook. fil.|Wilson','63ea972b-a1b1-57dd-9d32-ef0407300624','Tortula torquata (Taylor) Hook.f. & Wilson','(Taylor) Hook.f. & Wilson','SPECIES','','Tortula','','torquata','','','',NULL,'Hook. fil. & Wilson','','','','','Taylor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09a73bf2-e31c-42d6-8aeb-161eb2d0f7dc','','','Trachymela sloanei (Blackburn, 1896)',1,'Trachymela sloanei','Trachymela sloanei','Trachymela sloane',2,0,'','','Blackburn','1c124146-29cd-5c88-a0d0-50d1e0a08588','Trachymela sloanei (Blackburn, 1896)','(Blackburn, 1896)','SPECIES','','Trachymela','','sloanei','','','',NULL,'','','','','','Blackburn','','','','1896','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09a7f788-d819-45e2-a27e-633010abcec3','','','Strigula stigmatella',1,'Strigula stigmatella','Strigula stigmatella','Strigula stigmatell',2,0,'','','','cce8fd67-484b-5e50-a133-81909461a883','Strigula stigmatella','','SPECIES','','Strigula','','stigmatella','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09a50a77-f866-4bb4-8c93-840497216006','','','Hyalonema species7 Reiswig',4,'','','',NULL,NULL,'','','','','Hyalonema species7 Reiswig','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09a5e5e5-b37c-4dfc-a717-acf10603263b','','','Pisanianura species (NZOI U609)',4,'','','',NULL,NULL,'','','','','Pisanianura species (NZOI U609)','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09a42da4-f2d0-4a18-9ea0-dde49d1fcfa5','','','Aulacomnium stolonaceum Müll.Hal.',1,'Aulacomnium stolonaceum','Aulacomnium stolonaceum','Aulacomnium stolonace',2,0,'','','Müll. Hal.','110571ad-036c-59bd-bbba-58d6b346e8b6','Aulacomnium stolonaceum Müll.Hal.','Müll.Hal.','SPECIES','','Aulacomnium','','stolonaceum','','','',NULL,'','','','','','Müll. Hal.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09aacb67-f13b-485e-972c-5e386c3a80fd','','','Plagiochila intermixta Colenso',1,'Plagiochila intermixta','Plagiochila intermixta','Plagiochila intermixt',2,0,'','','Colenso','f23cf192-163c-58a3-aeb2-87adeb2feaa7','Plagiochila intermixta Colenso','Colenso','SPECIES','','Plagiochila','','intermixta','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09af0b9f-2405-4a9c-8698-690a03b5b7ae','','','Lepidosira arborea pigmenta Salmon, 1944',1,'Lepidosira arborea pigmenta','Lepidosira arborea pigmenta','Lepidosira arbore pigment',3,0,'','','Salmon','ae8b291c-2899-553f-bd39-d246410bddaa','Lepidosira arborea pigmenta Salmon, 1944','Salmon, 1944','SUBSPECIES','','Lepidosira','','arborea','pigmenta','','',NULL,'','','','','','Salmon','','','','1944','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09b7e5dc-dbaa-4178-baa2-322e72d2fd06','','','Bunodophoron insigne (Laurer) Wedin',1,'Bunodophoron insigne','Bunodophoron insigne','Bunodophoron insign',2,0,'','','Laurer|Wedin','87d7c312-91cf-5fab-967d-6814f904bcb1','Bunodophoron insigne (Laurer) Wedin','(Laurer) Wedin','SPECIES','','Bunodophoron','','insigne','','','',NULL,'Wedin','','','','','Laurer','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09b06c5f-14bd-4956-af37-4f86abe6e958','','','Archeophylla R.M.Schust.',1,'Archeophylla','Archeophylla','Archeophylla',1,0,'','','R. M. Schust.','141744e2-3081-5b5e-8a48-5bee0d60371e','Archeophylla R.M.Schust.','R.M.Schust.','GENUS','Archeophylla','','','','','','',NULL,'','','','','','R. M. Schust.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09b2762b-a713-43cb-a88a-9cbc6f785d5c','','','Xanthopsoroma soccatum (R.Br. ex Cromb.) Elvebakk',1,'Xanthopsoroma soccatum','Xanthopsoroma soccatum','Xanthopsoroma soccat',2,0,'','','R. Br.|Cromb.|Elvebakk','a20023f3-4d50-5d45-be1f-dde1f8f05f68','Xanthopsoroma soccatum (R.Br. ex Cromb.) Elvebakk','(R.Br. ex Cromb.) Elvebakk','SPECIES','','Xanthopsoroma','','soccatum','','','',NULL,'Elvebakk','','','','','R. Br.','','Cromb.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09bde069-5a3e-46e7-b100-2dd504112185','','','Calliphora Robineau-Desvoidy, 1830',1,'Calliphora','Calliphora','Calliphora',1,0,'','','Robineau-Desvoidy','bbecf237-3b3c-5ccf-86d5-17eeb345d6c3','Calliphora Robineau-Desvoidy, 1830','Robineau-Desvoidy, 1830','GENUS','Calliphora','','','','','','',NULL,'','','','','','Robineau-Desvoidy','','','','1830','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09bd398a-b3cf-42e7-887b-560488208880','','','Hermanidae',1,'Hermanidae','Hermanidae','Hermanidae',1,0,'','','','631011f7-45ae-5bb0-9da4-4017393ab14f','Hermanidae','','FAMILY','Hermanidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09b9bb01-7368-4e64-afbc-6ea8f717aac8','','','Aplidium foliaceum (Sluiter, 1900)',1,'Aplidium foliaceum','Aplidium foliaceum','Aplidium foliace',2,0,'','','Sluiter','6a7b5a88-0b31-52e5-a805-8535f9151c9e','Aplidium foliaceum (Sluiter, 1900)','(Sluiter, 1900)','SPECIES','','Aplidium','','foliaceum','','','',NULL,'','','','','','Sluiter','','','','1900','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09be5560-db90-4d63-9025-c8787fe54220','','','Herpobasidium filicinum (Rostr.) Lind',1,'Herpobasidium filicinum','Herpobasidium filicinum','Herpobasidium filicin',2,0,'','','Rostr.|Lind','4dde6ee7-c8c6-58f6-9e8f-046441a7cb83','Herpobasidium filicinum (Rostr.) Lind','(Rostr.) Lind','SPECIES','','Herpobasidium','','filicinum','','','',NULL,'Lind','','','','','Rostr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09c2e241-c2ce-4f6f-9ef9-28a09b2052ea','','','Acrobolbus perpusillus var. denticulatus (J.J.Engel & Glenny) Briscoe',1,'Acrobolbus perpusillus denticulatus','Acrobolbus perpusillus var. denticulatus','Acrobolbus perpusill denticulat',3,0,'','','J. J. Engel|Glenny|Briscoe','4559e1ae-6b16-569d-a8d6-ca46ec1bf0d0','Acrobolbus perpusillus var. denticulatus (J.J.Engel & Glenny) Briscoe','(J.J.Engel & Glenny) Briscoe','VARIETY','','Acrobolbus','','perpusillus','denticulatus','','',NULL,'Briscoe','','','','','J. J. Engel & Glenny','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09c35752-fc4c-4f05-b630-4bdeb3a4346c','','','Lecidea durietzii H.Magn.',1,'Lecidea durietzii','Lecidea durietzii','Lecidea durietz',2,0,'','','H. Magn.','78e98b62-a8ff-5586-8967-92c8f10a6914','Lecidea durietzii H.Magn.','H.Magn.','SPECIES','','Lecidea','','durietzii','','','',NULL,'','','','','','H. Magn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09c69e24-eef3-4514-a20b-ca5335d7d5b6','','','Hymenochaete rubiginosa (Dicks.) Lév.',1,'Hymenochaete rubiginosa','Hymenochaete rubiginosa','Hymenochaete rubiginos',2,0,'','','Dicks.|Lév.','601bcf8a-fb84-5556-90a4-24239bebc92d','Hymenochaete rubiginosa (Dicks.) Lév.','(Dicks.) Lév.','SPECIES','','Hymenochaete','','rubiginosa','','','',NULL,'Lév.','','','','','Dicks.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09cdcf95-f802-4b67-971b-1b11a0be18e8','','','Emesella dohrni Signoret, 1863',1,'Emesella dohrni','Emesella dohrni','Emesella dohrn',2,0,'','','Signoret','7c52c919-0f08-5f92-89e8-8c3b875ba845','Emesella dohrni Signoret, 1863','Signoret, 1863','SPECIES','','Emesella','','dohrni','','','',NULL,'','','','','','Signoret','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09c9e380-dca9-4249-b9f8-71e559a6e78b','','','Eudyptes chrysolophus schlegeli Finsch',1,'Eudyptes chrysolophus schlegeli','Eudyptes chrysolophus schlegeli','Eudyptes chrysoloph schlegel',3,0,'','','Finsch','6ceb6c52-8fa9-5b33-8e6e-2186c9e93d12','Eudyptes chrysolophus schlegeli Finsch','Finsch','SUBSPECIES','','Eudyptes','','chrysolophus','schlegeli','','',NULL,'','','','','','Finsch','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09cdb269-99b5-44b5-8c3b-a043b83aa977','','','Alepocephalus',1,'Alepocephalus','Alepocephalus','Alepocephalus',1,0,'','','','17da44a2-1a41-5d46-b67f-f45a5be88797','Alepocephalus','','GENUS','Alepocephalus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09cec7ac-281c-4673-8f34-b00e2e14b7ae','','','Fissurina contusa colomboensis McCulloch, 1977',1,'Fissurina contusa colomboensis','Fissurina contusa colomboensis','Fissurina contus colomboens',3,0,'','','McCulloch','03b18e9e-c1c9-5336-89ad-f9ac72b9e277','Fissurina contusa colomboensis McCulloch, 1977','McCulloch, 1977','SUBSPECIES','','Fissurina','','contusa','colomboensis','','',NULL,'','','','','','McCulloch','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09cefc10-a286-4cb7-8291-049b1557caeb','','','Rhododendron lineare Merr.',1,'Rhododendron lineare','Rhododendron lineare','Rhododendron linear',2,0,'','','Merr.','43fb143a-0810-556c-b04b-9794d8006f97','Rhododendron lineare Merr.','Merr.','SPECIES','','Rhododendron','','lineare','','','',NULL,'','','','','','Merr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09d21480-be40-45aa-bd15-3a96262a0098','','','Bougainvillia muscoides (M. Sars, 1846)',1,'Bougainvillia muscoides','Bougainvillia muscoides','Bougainvillia muscoid',2,0,'','','M. Sars','1559709e-acfa-5c12-9a62-103e0abe399b','Bougainvillia muscoides (M. Sars, 1846)','(M. Sars, 1846)','SPECIES','','Bougainvillia','','muscoides','','','',NULL,'','','','','','M. Sars','','','','1846','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09d4a1b5-de1f-4194-9ab1-b05ba3f3660d','','','Juncus acuminatus Michx.',1,'Juncus acuminatus','Juncus acuminatus','Juncus acuminat',2,0,'','','Michx.','bb8fd8a1-c6c3-552d-a804-7b7e5f291569','Juncus acuminatus Michx.','Michx.','SPECIES','','Juncus','','acuminatus','','','',NULL,'','','','','','Michx.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09d67f80-3a57-41ea-be50-ea6b2b30be2c','','','Entodinium ovinum Dogiel, 1927',1,'Entodinium ovinum','Entodinium ovinum','Entodinium ouin',2,0,'','','Dogiel','ff200e2b-ffda-5cbf-a011-78a8c41e9853','Entodinium ovinum Dogiel, 1927','Dogiel, 1927','SPECIES','','Entodinium','','ovinum','','','',NULL,'','','','','','Dogiel','','','','1927','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09d83170-65c8-4d0b-b59f-0a5e92106009','','','Lopadostoma turgidum (Pers.) Traverso',1,'Lopadostoma turgidum','Lopadostoma turgidum','Lopadostoma turgid',2,0,'','','Pers.|Traverso','868420ea-22c8-56ef-9c66-ac3a5a998c49','Lopadostoma turgidum (Pers.) Traverso','(Pers.) Traverso','SPECIES','','Lopadostoma','','turgidum','','','',NULL,'Traverso','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09de5735-9876-472e-bb5d-1e798fbd75e2','','','Oleandraceae',1,'Oleandraceae','Oleandraceae','Oleandraceae',1,0,'','','','b931b53b-8477-5658-a0f7-fe610caac64f','Oleandraceae','','FAMILY','Oleandraceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09de6819-6aa2-4f92-aed9-25c1ee680620','','','Tylopathes',1,'Tylopathes','Tylopathes','Tylopathes',1,0,'','','','bac84f43-8452-5ae6-8ce1-36d9c8b28f0f','Tylopathes','','GENUS','Tylopathes','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09d99dbc-ba54-4fd6-b2f9-6d500f6c5c43','','','Grynoma regularis Sharp, 1882',1,'Grynoma regularis','Grynoma regularis','Grynoma regular',2,0,'','','Sharp','c4273d93-9661-54fd-8e58-87d795992092','Grynoma regularis Sharp, 1882','Sharp, 1882','SPECIES','','Grynoma','','regularis','','','',NULL,'','','','','','Sharp','','','','1882','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09db6bd6-a5eb-4bbb-a516-e86e66b773fc','','','Bothidae',1,'Bothidae','Bothidae','Bothidae',1,0,'','','','4e0c9bad-96a8-5c1c-bcf4-d72c947a81d0','Bothidae','','FAMILY','Bothidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09d886ca-f808-46ab-be63-fc7db70f1e8f','','','Mitridae',1,'Mitridae','Mitridae','Mitridae',1,0,'','','','d779e926-5e0d-59ff-9874-73653c0b692f','Mitridae','','FAMILY','Mitridae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09e51a89-a53a-42cf-8766-008bd358bb1e','','','Docophoroides murphyi (Kellogg, 1914)',1,'Docophoroides murphyi','Docophoroides murphyi','Docophoroides murphy',2,0,'','','Kellogg','84c2187f-f019-5ea2-a993-7b97a78e686f','Docophoroides murphyi (Kellogg, 1914)','(Kellogg, 1914)','SPECIES','','Docophoroides','','murphyi','','','',NULL,'','','','','','Kellogg','','','','1914','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09e55a8a-6fb7-4c85-91a8-16bf59cda144','','','Astelia solandri A.Cunn. subsp. solandri',1,'Astelia solandri solandri','Astelia solandri subsp. solandri','Astelia solandr solandr',3,0,'','','','c76237c2-d89d-52dc-a57f-048a7b310544','Astelia solandri A.Cunn. subsp. solandri','','SUBSPECIES','','Astelia','','solandri','solandri','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09e46526-6337-4e2c-83d1-9a018f38b454','','','Diachea Fr.',1,'Diachea','Diachea','Diachea',1,0,'','','Fr.','fe65cc04-0de1-5dd2-8167-2d68aed522ce','Diachea Fr.','Fr.','GENUS','Diachea','','','','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09e9607b-6e73-45ed-9b4e-3de7cf701fcc','','','Comatricha elegans (Racib.) G.Lister',1,'Comatricha elegans','Comatricha elegans','Comatricha elegans',2,0,'','','Racib.|G. Lister','586588a7-20d7-5c59-98e6-d72d660034c8','Comatricha elegans (Racib.) G.Lister','(Racib.) G.Lister','SPECIES','','Comatricha','','elegans','','','',NULL,'G. Lister','','','','','Racib.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09eb9701-2da0-4921-bf8e-58113f404a71','','','Olpidiales Doweld',1,'Olpidiales','Olpidiales','Olpidiales',1,0,'','','Doweld','689ab64f-7786-5a5e-8b61-4e6c1d968f45','Olpidiales Doweld','Doweld','ORDER','Olpidiales','','','','','','',NULL,'','','','','','Doweld','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09ee1e88-cc9b-46d0-acf7-6d26f4ff0aaa','','','Parrotiopsis jacquemontiana (Decne.) Rehd.',1,'Parrotiopsis jacquemontiana','Parrotiopsis jacquemontiana','Parrotiopsis iacquemontian',2,0,'','','Decne.|Rehd.','42110330-ebce-5f11-8632-b112e5cbdb1d','Parrotiopsis jacquemontiana (Decne.) Rehd.','(Decne.) Rehd.','SPECIES','','Parrotiopsis','','jacquemontiana','','','',NULL,'Rehd.','','','','','Decne.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('09e7a742-958b-43b4-a3ec-bae0f37cdeef','','','Guttulina bartschi Cushman & Ozawa, 1930',1,'Guttulina bartschi','Guttulina bartschi','Guttulina bartsch',2,0,'','','Cushman|Ozawa','5bd4b8a6-d7bd-518c-9e72-16272421d3df','Guttulina bartschi Cushman & Ozawa, 1930','Cushman & Ozawa, 1930','SPECIES','','Guttulina','','bartschi','','','',NULL,'','','','','','Cushman & Ozawa','','','','1930','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05d06eea-b449-4ade-80ff-0242779f1888','','','Cercospora fatouae Henn.',1,'Cercospora fatouae','Cercospora fatouae','Cercospora fatou',2,0,'','','Henn.','6a4f4ed0-fa2b-5232-b7d7-d3ab04dfee54','Cercospora fatouae Henn.','Henn.','SPECIES','','Cercospora','','fatouae','','','',NULL,'','','','','','Henn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05cf63d0-b55e-4dc8-b2b7-316132ae16b1','','','Dermamoebida',1,'Dermamoebida','Dermamoebida','Dermamoebida',1,0,'','','','45380765-7d9a-5fe1-bd03-8e2b5cc2dc79','Dermamoebida','','ORDER','Dermamoebida','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05d36504-4a51-4e5f-a7e4-431de74c0117','','','Anthostomella obesa Daranagama, E. Camporesi & K.D. Hyde',1,'Anthostomella obesa','Anthostomella obesa','Anthostomella obes',2,0,'','','Daranagama|E. Camporesi|K. D. Hyde','e92b356e-feb8-53c6-89cb-856f4fdc6a5c','Anthostomella obesa Daranagama, E. Camporesi & K.D. Hyde','Daranagama, E. Camporesi & K.D. Hyde','SPECIES','','Anthostomella','','obesa','','','',NULL,'','','','','','Daranagama, E. Camporesi & K. D. Hyde','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05d3bb79-3398-4639-9f29-d9328cfe85e1','','','Nectria sceptri P. Karst.',1,'Nectria sceptri','Nectria sceptri','Nectria sceptr',2,0,'','','P. Karst.','49124b79-eb41-5edd-b082-786f23fb5ac7','Nectria sceptri P. Karst.','P. Karst.','SPECIES','','Nectria','','sceptri','','','',NULL,'','','','','','P. Karst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05dc222d-0e57-4900-bef8-17c8662acda4','','','Mitophyllus falcatus Holloway, 2007',1,'Mitophyllus falcatus','Mitophyllus falcatus','Mitophyllus falcat',2,0,'','','Holloway','708d11e3-73b3-5ba9-a7d1-e4f738d1ae12','Mitophyllus falcatus Holloway, 2007','Holloway, 2007','SPECIES','','Mitophyllus','','falcatus','','','',NULL,'','','','','','Holloway','','','','2007','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05d7a33f-17e9-42dc-93f1-863739cc148f','','','Arachnopusia',1,'Arachnopusia','Arachnopusia','Arachnopusia',1,0,'','','','30071f90-1677-5b75-a8a9-b73319547d15','Arachnopusia','','GENUS','Arachnopusia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05de85b6-56ea-4be5-a8b6-9347f4a264d1','','','Closterium ehrenbergii Menegh. ex Ralfs',1,'Closterium ehrenbergii','Closterium ehrenbergii','Closterium ehrenberg',2,0,'','','Menegh.|Ralfs','1acb1029-cbbf-5410-a272-01fb51031cbb','Closterium ehrenbergii Menegh. ex Ralfs','Menegh. ex Ralfs','SPECIES','','Closterium','','ehrenbergii','','','',NULL,'','','','','','Menegh.','','Ralfs','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05d9f353-30eb-4505-9c98-ef64e4806636','','','Clitocybe gigantea (Sowerby.) Quél.',1,'Clitocybe gigantea','Clitocybe gigantea','Clitocybe gigante',2,0,'','','Sowerby.|Quél.','70c0a11a-22e2-5db8-b2a4-b7fcbdf69f0a','Clitocybe gigantea (Sowerby.) Quél.','(Sowerby.) Quél.','SPECIES','','Clitocybe','','gigantea','','','',NULL,'Quél.','','','','','Sowerby.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05e187d9-df06-431d-957f-38e38d480177','','','Oecobius',1,'Oecobius','Oecobius','Oecobius',1,0,'','','','e8d25c58-2ab4-5357-9996-de4ef8cf6806','Oecobius','','GENUS','Oecobius','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05e51e04-b2ca-4d0a-95db-4752e0af3ddc','','','Senebiera didyma (L.) Pers.',1,'Senebiera didyma','Senebiera didyma','Senebiera didym',2,0,'','','L.|Pers.','710b0c52-d110-5773-a098-d2f9885a69d2','Senebiera didyma (L.) Pers.','(L.) Pers.','SPECIES','','Senebiera','','didyma','','','',NULL,'Pers.','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05df6ffd-8baa-444c-b79b-63fe934ee0d4','','','Olpidium entophytum (A. Braun) Rabenh.',1,'Olpidium entophytum','Olpidium entophytum','Olpidium entophyt',2,0,'','','A. Braun|Rabenh.','2b62313a-19b6-54b7-9422-1433760e328e','Olpidium entophytum (A. Braun) Rabenh.','(A. Braun) Rabenh.','SPECIES','','Olpidium','','entophytum','','','',NULL,'Rabenh.','','','','','A. Braun','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05e42744-53c2-4e66-8b3b-f86460a845b3','','','Marsupella ustulata (Huebener) Spruce ex Pearson',1,'Marsupella ustulata','Marsupella ustulata','Marsupella ustulat',2,0,'','','Huebener|Spruce|Pearson','344126e0-a0b8-5a27-b2cf-34ecb07198d3','Marsupella ustulata (Huebener) Spruce ex Pearson','(Huebener) Spruce ex Pearson','SPECIES','','Marsupella','','ustulata','','','',NULL,'Spruce','','Pearson','','','Huebener','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05ed6b34-fe69-4688-830a-981aa724933a','','','Trachypepla semilauta Philpott, 1918',1,'Trachypepla semilauta','Trachypepla semilauta','Trachypepla semilaut',2,0,'','','Philpott','7ab2bcb0-0c51-5f68-98bf-a98a36c9a8d8','Trachypepla semilauta Philpott, 1918','Philpott, 1918','SPECIES','','Trachypepla','','semilauta','','','',NULL,'','','','','','Philpott','','','','1918','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05e9b794-cf54-4143-aa4d-9cf093a7fcd7','','','Patellaria pseudophana (Nyl.) Müll.Arg.',1,'Patellaria pseudophana','Patellaria pseudophana','Patellaria pseudophan',2,0,'','','Nyl.|Müll. Arg.','35c5bccf-ca62-5c61-a369-e00fcd424f15','Patellaria pseudophana (Nyl.) Müll.Arg.','(Nyl.) Müll.Arg.','SPECIES','','Patellaria','','pseudophana','','','',NULL,'Müll. Arg.','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05e6de7c-bb4a-4686-8e45-e5ecac0e85b4','','','Periegops suterii (Urquhart, 1892)',1,'Periegops suterii','Periegops suterii','Periegops suter',2,0,'','','Urquhart','5e2c725f-aed6-5867-a387-507994dc8589','Periegops suterii (Urquhart, 1892)','(Urquhart, 1892)','SPECIES','','Periegops','','suterii','','','',NULL,'','','','','','Urquhart','','','','1892','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05f01bc2-e02c-4417-b16a-6affc40c5078','','','Sitona',1,'Sitona','Sitona','Sitona',1,0,'','','','70ecdd23-110d-5846-a89e-a05abf4c4702','Sitona','','GENUS','Sitona','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05efff4b-4a4a-4980-9ff9-7837d4b7701a','','','Ocellularia G. Mey.',1,'Ocellularia','Ocellularia','Ocellularia',1,0,'','','G. Mey.','f09bb12b-9e2a-56e5-8ba2-74f22d06301e','Ocellularia G. Mey.','G. Mey.','GENUS','Ocellularia','','','','','','',NULL,'','','','','','G. Mey.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05f04e23-9cd4-430c-8dd1-bf167835aec0','','','Spirotaenia condensata Brébisson',1,'Spirotaenia condensata','Spirotaenia condensata','Spirotaenia condensat',2,0,'','','Brébisson','97b31e94-413f-5c7f-bb43-c9f24ac6e4be','Spirotaenia condensata Brébisson','Brébisson','SPECIES','','Spirotaenia','','condensata','','','',NULL,'','','','','','Brébisson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05f44b92-8e12-4671-a583-efbbb83735b1','','','Didymosphaeria exigua Niessl',1,'Didymosphaeria exigua','Didymosphaeria exigua','Didymosphaeria exigu',2,0,'','','Niessl','1266ac86-976f-5552-94d4-72b8d44627f9','Didymosphaeria exigua Niessl','Niessl','SPECIES','','Didymosphaeria','','exigua','','','',NULL,'','','','','','Niessl','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05fa6af2-c04e-4c54-b724-246a64142b3a','','','Thelephora lamellata Berk. & M.A. Curtis',1,'Thelephora lamellata','Thelephora lamellata','Thelephora lamellat',2,0,'','','Berk.|M. A. Curtis','b53d15b1-ea1e-5efb-b1aa-b3d8efa60a0c','Thelephora lamellata Berk. & M.A. Curtis','Berk. & M.A. Curtis','SPECIES','','Thelephora','','lamellata','','','',NULL,'','','','','','Berk. & M. A. Curtis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05f842e2-fd96-4500-86b9-bfadc885d2e4','','','Indotritia aotearoana Ramsay, 1966',1,'Indotritia aotearoana','Indotritia aotearoana','Indotritia aotearoan',2,0,'','','Ramsay','e33c09b6-9883-5f29-a312-31c560c1a95f','Indotritia aotearoana Ramsay, 1966','Ramsay, 1966','SPECIES','','Indotritia','','aotearoana','','','',NULL,'','','','','','Ramsay','','','','1966','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('05fa5904-96c1-4236-bfd1-f96379397c5f','','','Jungermannia excisa Dicks.',1,'Jungermannia excisa','Jungermannia excisa','Jungermannia excis',2,0,'','','Dicks.','99e384c5-ad7a-5c9a-bba6-e0c19e420935','Jungermannia excisa Dicks.','Dicks.','SPECIES','','Jungermannia','','excisa','','','',NULL,'','','','','','Dicks.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0601d653-3095-4281-a056-0eebee9d2abd','','','Makawe insularis (Chilton, 1909)',1,'Makawe insularis','Makawe insularis','Makawe insular',2,0,'','','Chilton','574d6eda-994f-591f-8cf3-9be3bcf12643','Makawe insularis (Chilton, 1909)','(Chilton, 1909)','SPECIES','','Makawe','','insularis','','','',NULL,'','','','','','Chilton','','','','1909','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('060201fc-168f-4337-b721-6b010bfc1e11','','','Hyalinoecia incubans Orensanz, 1990',1,'Hyalinoecia incubans','Hyalinoecia incubans','Hyalinoecia incubans',2,0,'','','Orensanz','97e5d6cb-3d03-5b3b-b877-f9cd39123153','Hyalinoecia incubans Orensanz, 1990','Orensanz, 1990','SPECIES','','Hyalinoecia','','incubans','','','',NULL,'','','','','','Orensanz','','','','1990','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0600506b-408e-4141-b647-b600ccc352fa','','','Microlepia strigosa (Thunb.) C.Presl',1,'Microlepia strigosa','Microlepia strigosa','Microlepia strigos',2,0,'','','Thunb.|C. Presl','42b69300-22a6-5f43-82a8-2fa9752460fd','Microlepia strigosa (Thunb.) C.Presl','(Thunb.) C.Presl','SPECIES','','Microlepia','','strigosa','','','',NULL,'C. Presl','','','','','Thunb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0604eb0c-b05b-4b60-a961-06f8d0b23f67','','','Molophilus remotus Alexander, 1923',1,'Molophilus remotus','Molophilus remotus','Molophilus remot',2,0,'','','Alexander','bf5f3850-b1bc-56af-bf68-9da47c31f3d2','Molophilus remotus Alexander, 1923','Alexander, 1923','SPECIES','','Molophilus','','remotus','','','',NULL,'','','','','','Alexander','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0606f4da-6b44-4575-9559-5dda5e89389f','','','Azoarcus indigens Reinhold-Hurek et al., 1993',1,'Azoarcus indigens','Azoarcus indigens','Azoarcus indigens',2,0,'','','Reinhold-Hurek et al.','a360d794-7be4-52e9-a36c-af0afa6a7b80','Azoarcus indigens Reinhold-Hurek et al., 1993','Reinhold-Hurek et al., 1993','SPECIES','','Azoarcus','','indigens','','','',NULL,'','','','','','Reinhold-Hurek et al.','','','','1993','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0608589e-f641-458c-9352-b63634b8c736','','','Tomopleura ischna (Watson, 1881)',1,'Tomopleura ischna','Tomopleura ischna','Tomopleura ischn',2,0,'','','Watson','db36f4e0-3708-527e-b525-f01b0adf5d30','Tomopleura ischna (Watson, 1881)','(Watson, 1881)','SPECIES','','Tomopleura','','ischna','','','',NULL,'','','','','','Watson','','','','1881','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('060d6419-250e-44e6-81ee-140604d42a5a','','','Phellinus caryophylleus (Cooke) Ryvarden',1,'Phellinus caryophylleus','Phellinus caryophylleus','Phellinus caryophylle',2,0,'','','Cooke|Ryvarden','09f0c5a0-19e5-5dda-816c-c9ff2f5ace54','Phellinus caryophylleus (Cooke) Ryvarden','(Cooke) Ryvarden','SPECIES','','Phellinus','','caryophylleus','','','',NULL,'Ryvarden','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('060d6212-56a6-4338-ae62-93add3915d4c','','','Hebeloma laterinum (Batsch) Vesterh.',1,'Hebeloma laterinum','Hebeloma laterinum','Hebeloma laterin',2,0,'','','Batsch|Vesterh.','9a2ca56c-10f1-57b7-a227-5ff4c3b46eb0','Hebeloma laterinum (Batsch) Vesterh.','(Batsch) Vesterh.','SPECIES','','Hebeloma','','laterinum','','','',NULL,'Vesterh.','','','','','Batsch','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('060b1d5f-e402-4f65-9cbd-c3c2806a6d9a','','','Agrostis personata Edgar',1,'Agrostis personata','Agrostis personata','Agrostis personat',2,0,'','','Edgar','58b3fa36-abbe-557c-a1be-e1b49a6a241a','Agrostis personata Edgar','Edgar','SPECIES','','Agrostis','','personata','','','',NULL,'','','','','','Edgar','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('060ae72d-616e-404d-945f-f8f0878d466f','','','Lemidia',1,'Lemidia','Lemidia','Lemidia',1,0,'','','','6070d553-452b-5837-ab95-59a1244a5c70','Lemidia','','GENUS','Lemidia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0613f409-2f1b-407c-9eb8-0880fe3d0c6b','','','Roussoella mangrovei Phukhams. & K.D. Hyde',1,'Roussoella mangrovei','Roussoella mangrovei','Roussoella mangroue',2,0,'','','Phukhams.|K. D. Hyde','48be1b38-87f8-5acd-9019-778ac072d176','Roussoella mangrovei Phukhams. & K.D. Hyde','Phukhams. & K.D. Hyde','SPECIES','','Roussoella','','mangrovei','','','',NULL,'','','','','','Phukhams. & K. D. Hyde','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('06128589-f173-47d4-81fd-d3a12751d8e3','','','Emmia metamorphosa (Fuckel) Zmitr., Spirin & Malysheva',1,'Emmia metamorphosa','Emmia metamorphosa','Emmia metamorphos',2,0,'','','Fuckel|Zmitr.|Spirin|Malysheva','ee71d72b-d925-57d2-b429-7020864c8896','Emmia metamorphosa (Fuckel) Zmitr., Spirin & Malysheva','(Fuckel) Zmitr., Spirin & Malysheva','SPECIES','','Emmia','','metamorphosa','','','',NULL,'Zmitr., Spirin & Malysheva','','','','','Fuckel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c9d4f45-9478-4e66-831d-13d7583f0772','','','Didymozoum species NIWA MNP7410',4,'','','',NULL,NULL,'','','','','Didymozoum species NIWA MNP7410','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c9d84e7-f818-48cc-baa3-4cd27db5a2cb','','','Platycercus elegans (Gmelin, 1788)',1,'Platycercus elegans','Platycercus elegans','Platycercus elegans',2,0,'','','Gmelin','7725440b-90a1-577f-a590-74df0514bad4','Platycercus elegans (Gmelin, 1788)','(Gmelin, 1788)','SPECIES','','Platycercus','','elegans','','','',NULL,'','','','','','Gmelin','','','','1788','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c98bc72-1935-48ce-a291-9fd885264df7','','','Probetyla',1,'Probetyla','Probetyla','Probetyla',1,0,'','','','9cf59306-98d6-5aa2-8b97-4fb964fb7d94','Probetyla','','GENUS','Probetyla','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c99954e-d8e3-44e5-a1da-a389fee725b2','','','Lichen vermicularis Sw.',1,'Lichen vermicularis','Lichen vermicularis','Lichen uermicular',2,0,'','','Sw.','34e09ed5-14d5-55e8-9b7b-04ea73af191b','Lichen vermicularis Sw.','Sw.','SPECIES','','Lichen','','vermicularis','','','',NULL,'','','','','','Sw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c99c9f0-5af7-4f8e-b188-dea31f91dbb8','','','Gymnodiniidae',1,'Gymnodiniidae','Gymnodiniidae','Gymnodiniidae',1,0,'','','','e4de5cad-e80c-5967-abf3-061dfdee666c','Gymnodiniidae','','FAMILY','Gymnodiniidae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ca41366-223c-4da2-bd81-171802e17ef3','','','Syntrichia norvegica F.Weber',1,'Syntrichia norvegica','Syntrichia norvegica','Syntrichia noruegic',2,0,'','','F. Weber','0dfd26d0-6997-5f11-b146-c8ca6e8f7406','Syntrichia norvegica F.Weber','F.Weber','SPECIES','','Syntrichia','','norvegica','','','',NULL,'','','','','','F. Weber','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ca1da78-3342-4381-b760-737fc949e0b0','','','Taphrophila cornu-capreoli Scheuer',1,'Taphrophila cornu-capreoli','Taphrophila cornu-capreoli','Taphrophila cornu-capreol',2,0,'','','Scheuer','370a0d93-0307-5df0-8c54-a25910b97c6b','Taphrophila cornu-capreoli Scheuer','Scheuer','SPECIES','','Taphrophila','','cornu-capreoli','','','',NULL,'','','','','','Scheuer','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ca4200b-1121-490f-bb72-9619ba0cd1a2','','','Podosphaera sect. Sphaerotheca (Lév.) de Bary',2,'Sphaerotheca','Podosphaera sect. Sphaerotheca','Sphaerotheca',1,0,'','','Lév.|de Bary','eb1199ee-7fc1-55f2-97a0-f283c145d658','Podosphaera sect. Sphaerotheca (Lév.) de Bary','(Lév.) de Bary','SECTION','Sphaerotheca','','','','','','',NULL,'de Bary','','','','','Lév.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ca21094-9a5a-4bdc-8d1c-cd00777199c0','','','Miastor Meinert, 1864',1,'Miastor','Miastor','Miastor',1,0,'','','Meinert','1c52c5ad-bd00-5436-a9aa-bc4f375f7e99','Miastor Meinert, 1864','Meinert, 1864','GENUS','Miastor','','','','','','',NULL,'','','','','','Meinert','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ca42271-7e32-4c3c-b768-e5978eb654d7','','','Amphoroidea falcifer Thomson, 1879',1,'Amphoroidea falcifer','Amphoroidea falcifer','Amphoroidea falcifer',2,0,'','','Thomson','ec794357-bcfb-5070-ae37-7cad2eadae0d','Amphoroidea falcifer Thomson, 1879','Thomson, 1879','SPECIES','','Amphoroidea','','falcifer','','','',NULL,'','','','','','Thomson','','','','1879','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cad62ae-4bd1-4f76-acc9-269cd29c3b71','','','Nesterenkonia species',4,'','','',NULL,NULL,'','','','','Nesterenkonia species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cae1633-0169-4d5e-99e8-3dda57e147c0','','','Pseudomonas syringae pv. lachrymans (Smith and Bryan 1915) Young et al., 1978',1,'Pseudomonas syringae lachrymans','Pseudomonas syringae pv. lachrymans','Pseudomonas syring lachrymans',3,0,'','','Smith|Bryan|Young et al.','809753e5-fd24-537c-95f7-5af72a9a5dcd','Pseudomonas syringae pv. lachrymans (Smith and Bryan 1915) Young et al., 1978','(Smith and Bryan 1915) Young et al., 1978','PATHOVAR','','Pseudomonas','','syringae','lachrymans','','',NULL,'Young et al.','','','','1978','Smith & Bryan','','','','1915','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ca97475-ffec-4386-82f0-d15f839864d8','','','Penicillium lanosum Westling',1,'Penicillium lanosum','Penicillium lanosum','Penicillium lanos',2,0,'','','Westling','f0ab6c8c-2d8a-5752-817d-211a90b053bf','Penicillium lanosum Westling','Westling','SPECIES','','Penicillium','','lanosum','','','',NULL,'','','','','','Westling','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cb0b9a8-0967-4ca7-94cc-0e7e615a8532','','','Umbilicaria propagulifera (Vain.) Llano',1,'Umbilicaria propagulifera','Umbilicaria propagulifera','Umbilicaria propagulifer',2,0,'','','Vain.|Llano','d3dcb77a-f97c-52de-9c61-fd2f0917ca15','Umbilicaria propagulifera (Vain.) Llano','(Vain.) Llano','SPECIES','','Umbilicaria','','propagulifera','','','',NULL,'Llano','','','','','Vain.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cb0dcf2-0428-4685-ad60-7f36c4e1de07','','','Degelia periptera (C.Knight) P.M.Jørg. & P.James',1,'Degelia periptera','Degelia periptera','Degelia peripter',2,0,'','','C. Knight|P. M. Jørg.|P. James','4e77bf4b-b538-59d9-9184-425a0ea2c2d0','Degelia periptera (C.Knight) P.M.Jørg. & P.James','(C.Knight) P.M.Jørg. & P.James','SPECIES','','Degelia','','periptera','','','',NULL,'P. M. Jørg. & P. James','','','','','C. Knight','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cbb16e3-8391-4085-960b-057880c69636','','','Scorpiurus thorpei Masunaga, 2017',1,'Scorpiurus thorpei','Scorpiurus thorpei','Scorpiurus thorpe',2,0,'','','Masunaga','74eb8bb6-50d4-5a49-a79f-5c280bfc44ed','Scorpiurus thorpei Masunaga, 2017','Masunaga, 2017','SPECIES','','Scorpiurus','','thorpei','','','',NULL,'','','','','','Masunaga','','','','2017','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cc11353-f820-4ace-8e83-63bb97c2db76','','','Aetideus giesbrechti Cleve, 1904',1,'Aetideus giesbrechti','Aetideus giesbrechti','Aetideus giesbrecht',2,0,'','','Cleve','5451eb6e-f2b8-57be-9b53-e08c475773f2','Aetideus giesbrechti Cleve, 1904','Cleve, 1904','SPECIES','','Aetideus','','giesbrechti','','','',NULL,'','','','','','Cleve','','','','1904','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cbc5c78-dca2-441f-83c2-815eafb8988a','','','Graphania chlorodonta (Hampson, 1911)',1,'Graphania chlorodonta','Graphania chlorodonta','Graphania chlorodont',2,0,'','','Hampson','baa74f22-3c84-5ea9-9938-34a240c60969','Graphania chlorodonta (Hampson, 1911)','(Hampson, 1911)','SPECIES','','Graphania','','chlorodonta','','','',NULL,'','','','','','Hampson','','','','1911','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cc10d8d-3dd9-48c5-a7b4-c8fc315f3a4b','','','Navicula obdurata Hohn & Hellerman',1,'Navicula obdurata','Navicula obdurata','Navicula obdurat',2,0,'','','Hohn|Hellerman','07d3e632-a352-5150-a458-5960ae40b752','Navicula obdurata Hohn & Hellerman','Hohn & Hellerman','SPECIES','','Navicula','','obdurata','','','',NULL,'','','','','','Hohn & Hellerman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cc1cc62-f411-487a-8fbe-89b9f1917494','','','Keratella procurva Thorpe, 1891',1,'Keratella procurva','Keratella procurva','Keratella procuru',2,0,'','','Thorpe','33d2efa7-8995-59ae-8ad1-7420a774a3cb','Keratella procurva Thorpe, 1891','Thorpe, 1891','SPECIES','','Keratella','','procurva','','','',NULL,'','','','','','Thorpe','','','','1891','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cc7b6ab-7a98-4c2d-aae9-d22f5eb3d4dd','','','Paralaeospira monacantha (Augener, 1923)',1,'Paralaeospira monacantha','Paralaeospira monacantha','Paralaeospira monacanth',2,0,'','','Augener','797d2189-3d1c-5b4f-9d1b-4547c2f3d64d','Paralaeospira monacantha (Augener, 1923)','(Augener, 1923)','SPECIES','','Paralaeospira','','monacantha','','','',NULL,'','','','','','Augener','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ccabb63-5e27-4ec3-94ab-284824458cc0','','','Helleborus argutifolius Viv.',1,'Helleborus argutifolius','Helleborus argutifolius','Helleborus argutifol',2,0,'','','Viv.','95afa3c6-4ae5-57d6-b28a-6d23ef1acad4','Helleborus argutifolius Viv.','Viv.','SPECIES','','Helleborus','','argutifolius','','','',NULL,'','','','','','Viv.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ccb4995-0e4a-4993-9457-93bb31275510','','','Trioza equalis (Ferris & Klyver, 1932)',1,'Trioza equalis','Trioza equalis','Trioza equal',2,0,'','','Ferris|Klyver','3f3bd6be-2bcf-52d7-9b38-060cd77995a0','Trioza equalis (Ferris & Klyver, 1932)','(Ferris & Klyver, 1932)','SPECIES','','Trioza','','equalis','','','',NULL,'','','','','','Ferris & Klyver','','','','1932','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ccfe5e9-dcc7-406a-9be1-cb2603e375a9','','','Oedogonium pyrulum Wittr.',1,'Oedogonium pyrulum','Oedogonium pyrulum','Oedogonium pyrul',2,0,'','','Wittr.','804737fc-f4a0-52c2-8973-6d982a116188','Oedogonium pyrulum Wittr.','Wittr.','SPECIES','','Oedogonium','','pyrulum','','','',NULL,'','','','','','Wittr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ccc45b4-ad21-41a7-9f8d-dcf7b812c2b1','','','Melochia L.',1,'Melochia','Melochia','Melochia',1,0,'','','L.','0fd01738-b8cf-547d-81aa-e26257e43602','Melochia L.','L.','GENUS','Melochia','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cd1106a-0100-4b01-a018-1a580a0377bf','','','Carex lectissima K.A.Ford',1,'Carex lectissima','Carex lectissima','Carex lectissim',2,0,'','','K. A. Ford','cebd5d91-bdff-5ab3-9506-871988d8e99f','Carex lectissima K.A.Ford','K.A.Ford','SPECIES','','Carex','','lectissima','','','',NULL,'','','','','','K. A. Ford','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cd201cd-d831-48f7-9d59-5be9eebca4fc','','','Gromilus sulcipennis (Broun, 1917)',1,'Gromilus sulcipennis','Gromilus sulcipennis','Gromilus sulcipenn',2,0,'','','Broun','9db06eac-b5f2-5fc4-9f14-4c7677c1ebd7','Gromilus sulcipennis (Broun, 1917)','(Broun, 1917)','SPECIES','','Gromilus','','sulcipennis','','','',NULL,'','','','','','Broun','','','','1917','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cd75186-7a1a-4c8e-9526-98b82d947a8f','','','Leucocarbo stewarti (Ogilvie-Grant, 1898) (Ogilvie-Grant 1898, 1898)',4,'','','',NULL,NULL,'','','','','Leucocarbo stewarti (Ogilvie-Grant, 1898) (Ogilvie-Grant 1898, 1898)','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cd5dc73-cd94-40d4-b9f7-fd6b446d2b73','','','Anabaena minutissima var. australis Skuja',1,'Anabaena minutissima australis','Anabaena minutissima var. australis','Anabaena minutissim austral',3,0,'','','Skuja','0ddce68c-4b03-51c6-9a7e-feac00d9ad51','Anabaena minutissima var. australis Skuja','Skuja','VARIETY','','Anabaena','','minutissima','australis','','',NULL,'','','','','','Skuja','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cd9caa2-9de4-43c3-8e3a-57d7ec7a54f0','','','Polyporus osseus Kalchbr.',1,'Polyporus osseus','Polyporus osseus','Polyporus osse',2,0,'','','Kalchbr.','4cba04c7-f5e3-5064-8fea-37691c8d86f6','Polyporus osseus Kalchbr.','Kalchbr.','SPECIES','','Polyporus','','osseus','','','',NULL,'','','','','','Kalchbr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cda632a-ea33-4598-b444-898cb8ad6f0d','','','Leanobium marmoratum (Lea, 1924)',1,'Leanobium marmoratum','Leanobium marmoratum','Leanobium marmorat',2,0,'','','Lea','5eac154c-e574-504a-a3da-80f5f874405f','Leanobium marmoratum (Lea, 1924)','(Lea, 1924)','SPECIES','','Leanobium','','marmoratum','','','',NULL,'','','','','','Lea','','','','1924','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cda77d7-f456-442d-a9c8-b111bc13a85c','','','Batodes Guenée, 1845',1,'Batodes','Batodes','Batodes',1,0,'','','Guenée','473a2178-f501-5751-bc79-6981b0a39313','Batodes Guenée, 1845','Guenée, 1845','GENUS','Batodes','','','','','','',NULL,'','','','','','Guenée','','','','1845','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cd9a586-a4b3-4243-ab6b-ded0ae6543d0','','','Haematonectria illudens (Berk.) Samuels & Nirenberg',1,'Haematonectria illudens','Haematonectria illudens','Haematonectria illudens',2,0,'','','Berk.|Samuels|Nirenberg','f29413bb-c1c3-535e-b203-93e54c6601bd','Haematonectria illudens (Berk.) Samuels & Nirenberg','(Berk.) Samuels & Nirenberg','SPECIES','','Haematonectria','','illudens','','','',NULL,'Samuels & Nirenberg','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ce02bc9-51fb-48ea-b759-457ef53f4b1a','','','Pectobacterium carotovorum subsp. atrosepticum (van Hall 1902) Hauben et al., 1999',1,'Pectobacterium carotovorum atrosepticum','Pectobacterium carotovorum subsp. atrosepticum','Pectobacterium carotouor atroseptic',3,0,'','','van Hall|Hauben et al.','f24bff58-c4d8-56f1-9dd2-fb8b2368a3e6','Pectobacterium carotovorum subsp. atrosepticum (van Hall 1902) Hauben et al., 1999','(van Hall 1902) Hauben et al., 1999','SUBSPECIES','','Pectobacterium','','carotovorum','atrosepticum','','',NULL,'Hauben et al.','','','','1999','van Hall','','','','1902','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cde638d-d657-40b1-ae97-8549ac25b955','','','Tuiharpalus hallae Larochelle & Lariviere, 2005',1,'Tuiharpalus hallae','Tuiharpalus hallae','Tuiharpalus hall',2,0,'','','Larochelle|Lariviere','d2fbad36-3230-5df6-b461-1aa250076b1b','Tuiharpalus hallae Larochelle & Lariviere, 2005','Larochelle & Lariviere, 2005','SPECIES','','Tuiharpalus','','hallae','','','',NULL,'','','','','','Larochelle & Lariviere','','','','2005','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cde7dcb-0066-4b6b-beea-9fb1c517c9c2','','','Friesia racemosa A.Cunn.',1,'Friesia racemosa','Friesia racemosa','Friesia racemos',2,0,'','','A. Cunn.','348a0bae-822f-5e17-8ae1-2970aae2ef1a','Friesia racemosa A.Cunn.','A.Cunn.','SPECIES','','Friesia','','racemosa','','','',NULL,'','','','','','A. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bbd4de9-2aa0-44bc-b23e-38afc05327c3','','','Tretodictyidae',1,'Tretodictyidae','Tretodictyidae','Tretodictyidae',1,0,'','','','f7571b9b-e0f3-5594-a662-8b3d129ed7bd','Tretodictyidae','','FAMILY','Tretodictyidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bbffa88-7dde-4e88-ae0b-679458ecad33','','','Rhododendron pubitubum Sleumer',1,'Rhododendron pubitubum','Rhododendron pubitubum','Rhododendron pubitub',2,0,'','','Sleumer','c5c80ae1-911c-5e5f-af33-3487f16618cf','Rhododendron pubitubum Sleumer','Sleumer','SPECIES','','Rhododendron','','pubitubum','','','',NULL,'','','','','','Sleumer','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bbdf175-fa76-4d6a-9568-9b05c25e2541','','','Manu antiquus Marples',1,'Manu antiquus','Manu antiquus','Manu antiqu',2,0,'','','Marples','192beac3-befe-5127-8c86-12abec65dbc1','Manu antiquus Marples','Marples','SPECIES','','Manu','','antiquus','','','',NULL,'','','','','','Marples','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bc0e749-7533-4b3f-a926-bf236bfe66dc','','','Didymograptus similis (J. Hall, 1865)',1,'Didymograptus similis','Didymograptus similis','Didymograptus simil',2,0,'','','J. Hall','527c395a-8490-5c61-99da-358edc1aeea5','Didymograptus similis (J. Hall, 1865)','(J. Hall, 1865)','SPECIES','','Didymograptus','','similis','','','',NULL,'','','','','','J. Hall','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bc6f596-b692-45d9-ba4f-5daf261ca3a2','','','Amplistromatales D’souza, Maharachch. & K.D. Hyde',4,'','','',NULL,NULL,'','','','','Amplistromatales D’souza, Maharachch. & K.D. Hyde','','ORDER','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bc99c16-a5a8-40ec-81d4-6fc288939661','','','Aleochara subaenea Fauvel, 1878',1,'Aleochara subaenea','Aleochara subaenea','Aleochara subaene',2,0,'','','Fauvel','292fbd81-2fcf-5b3e-b2b6-968546048f3b','Aleochara subaenea Fauvel, 1878','Fauvel, 1878','SPECIES','','Aleochara','','subaenea','','','',NULL,'','','','','','Fauvel','','','','1878','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bc2cad4-14f9-4980-aa20-ce7847521109','','','Barnadesia Mutis ex L.f.',1,'Barnadesia','Barnadesia','Barnadesia',1,0,'','','Mutis|L. fil.','4d2721c7-d9c8-5dc0-ad14-e3a9069fd06a','Barnadesia Mutis ex L.f.','Mutis ex L.f.','GENUS','Barnadesia','','','','','','',NULL,'','','','','','Mutis','','L. fil.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bcd6bc1-3c1e-4e6a-ba87-14ace37a6804','','','Apoctena clarkei (Philpott, 1930)',1,'Apoctena clarkei','Apoctena clarkei','Apoctena clarke',2,0,'','','Philpott','36965ca4-7fcb-5cb8-b0e5-9d74f4364019','Apoctena clarkei (Philpott, 1930)','(Philpott, 1930)','SPECIES','','Apoctena','','clarkei','','','',NULL,'','','','','','Philpott','','','','1930','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bcddc36-430d-4908-8276-67a47a313a8d','','','Abies nordmanniana (Steven) Spach',1,'Abies nordmanniana','Abies nordmanniana','Abies nordmannian',2,0,'','','Steven|Spach','d4ea6469-53cc-5e89-bb96-b0c1d04e6e1f','Abies nordmanniana (Steven) Spach','(Steven) Spach','SPECIES','','Abies','','nordmanniana','','','',NULL,'Spach','','','','','Steven','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bcc0c3a-a0b3-4270-bdb6-fb8b5cc5b20d','','','Chondracanthus australis Ho, 1991',1,'Chondracanthus australis','Chondracanthus australis','Chondracanthus austral',2,0,'','','Ho','dcce7dac-79c6-5365-941a-a787f5d6279b','Chondracanthus australis Ho, 1991','Ho, 1991','SPECIES','','Chondracanthus','','australis','','','',NULL,'','','','','','Ho','','','','1991','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bd0ef6c-afa8-4af2-99e1-3dbb424b6382','','','Beania quadricornuta (Hincks, 1885)',1,'Beania quadricornuta','Beania quadricornuta','Beania quadricornut',2,0,'','','Hincks','5ca2025e-613f-5698-9ee2-54c3a50282b6','Beania quadricornuta (Hincks, 1885)','(Hincks, 1885)','SPECIES','','Beania','','quadricornuta','','','',NULL,'','','','','','Hincks','','','','1885','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bcec202-73fa-47dd-aab8-a9da44825350','','','Heterodermia Trevis.',1,'Heterodermia','Heterodermia','Heterodermia',1,0,'','','Trevis.','193b335d-39a6-526d-9f19-f3889f32216b','Heterodermia Trevis.','Trevis.','GENUS','Heterodermia','','','','','','',NULL,'','','','','','Trevis.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bd30112-f7f3-4db7-88d7-b7428b045941','','','Asymphus',1,'Asymphus','Asymphus','Asymphus',1,0,'','','','3a05de3a-8f3e-5009-b01f-c60fbdf7a84d','Asymphus','','GENUS','Asymphus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bd2a9c3-1e49-49fe-b9e7-dbef4405ff09','','','Pohlia elongata Hedw.',1,'Pohlia elongata','Pohlia elongata','Pohlia elongat',2,0,'','','Hedw.','e9eb15f2-20db-5647-b36d-15cc87aa3360','Pohlia elongata Hedw.','Hedw.','SPECIES','','Pohlia','','elongata','','','',NULL,'','','','','','Hedw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bd7ef32-2697-49bd-80ab-398edc5f00e8','','','Oedogonium cardiacum (Hassall) Witrock',1,'Oedogonium cardiacum','Oedogonium cardiacum','Oedogonium cardiac',2,0,'','','Hassall|Witrock','a5526a09-7253-5536-94dc-59c6c4719652','Oedogonium cardiacum (Hassall) Witrock','(Hassall) Witrock','SPECIES','','Oedogonium','','cardiacum','','','',NULL,'Witrock','','','','','Hassall','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bda98d6-5955-465e-b68d-78db5eca450c','','','Diaprepocoris',1,'Diaprepocoris','Diaprepocoris','Diaprepocoris',1,0,'','','','501505bf-a272-58ee-ab5c-1b41e76fdd85','Diaprepocoris','','GENUS','Diaprepocoris','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bd8dd81-6943-4860-b1d1-8cb414ec047c','','','Proscoloplos',1,'Proscoloplos','Proscoloplos','Proscoloplos',1,0,'','','','ab42cb8e-798b-59be-b8f9-97a0e076bde3','Proscoloplos','','GENUS','Proscoloplos','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bd56c33-7afc-4187-a9d7-9033dff87339','','','Paranectria Sacc.',1,'Paranectria','Paranectria','Paranectria',1,0,'','','Sacc.','8a253ffb-e983-508e-b1c1-aafc3a2117ca','Paranectria Sacc.','Sacc.','GENUS','Paranectria','','','','','','',NULL,'','','','','','Sacc.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bdae734-d00a-4751-9c67-bfaf7eda7c3c','','','Parapsyllus magellanicus magellanicus Jordan, 1938',1,'Parapsyllus magellanicus magellanicus','Parapsyllus magellanicus magellanicus','Parapsyllus magellanic magellanic',3,0,'','','Jordan','01e58e89-c2ba-5661-b5d1-c840a108e3c0','Parapsyllus magellanicus magellanicus Jordan, 1938','Jordan, 1938','SUBSPECIES','','Parapsyllus','','magellanicus','magellanicus','','',NULL,'','','','','','Jordan','','','','1938','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bd9a115-c161-4855-93d5-cf669d446276','','','Paracephaleus Evans, 1942',1,'Paracephaleus','Paracephaleus','Paracephaleus',1,0,'','','Evans','232af4fc-7517-574d-888c-ad23c1d1ddf4','Paracephaleus Evans, 1942','Evans, 1942','GENUS','Paracephaleus','','','','','','',NULL,'','','','','','Evans','','','','1942','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bde578d-9c30-405c-b266-2bddcef552fe','','','Graliophilus',1,'Graliophilus','Graliophilus','Graliophilus',1,0,'','','','bbee9b53-63f1-55e6-a163-5b8ae49a2b99','Graliophilus','','GENUS','Graliophilus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bdf70de-7974-481d-bc50-2e327d6d22d4','','','Lepiorsillus Malipatil, 1979',1,'Lepiorsillus','Lepiorsillus','Lepiorsillus',1,0,'','','Malipatil','983cb5a8-8808-59f1-9315-fc7507d1699e','Lepiorsillus Malipatil, 1979','Malipatil, 1979','GENUS','Lepiorsillus','','','','','','',NULL,'','','','','','Malipatil','','','','1979','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0be238c0-a21d-4c15-8849-8e06f7f4d135','','','Glaucus atlanticus Forster, 1777',1,'Glaucus atlanticus','Glaucus atlanticus','Glaucus atlantic',2,0,'','','Forster','39b45b34-b4a6-5694-80f8-05c2adb535e8','Glaucus atlanticus Forster, 1777','Forster, 1777','SPECIES','','Glaucus','','atlanticus','','','',NULL,'','','','','','Forster','','','','1777','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bdbeeda-eb28-417f-95cf-bc16deb22c82','','','Aphilon impressum Broun, 1914',1,'Aphilon impressum','Aphilon impressum','Aphilon impress',2,0,'','','Broun','7cf09202-6f7f-50ee-b2b0-054cd6871834','Aphilon impressum Broun, 1914','Broun, 1914','SPECIES','','Aphilon','','impressum','','','',NULL,'','','','','','Broun','','','','1914','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0be28a2b-f60c-4f7a-a56f-d20f453dce23','','','Cymbellonitzschia szulczewskii Witkowski et al.',1,'Cymbellonitzschia szulczewskii','Cymbellonitzschia szulczewskii','Cymbellonitzschia szulczewsk',2,0,'','','Witkowski et al.','7d9c4ded-fc44-5df7-b40a-e87941228d64','Cymbellonitzschia szulczewskii Witkowski et al.','Witkowski et al.','SPECIES','','Cymbellonitzschia','','szulczewskii','','','',NULL,'','','','','','Witkowski et al.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0be8c20a-afac-4674-aee6-1b32928837cb','','','Proales parasita (Ehrenberg, 1838)',1,'Proales parasita','Proales parasita','Proales parasit',2,0,'','','Ehrenberg','08cb759d-cd04-5e8e-a939-ed083bcf7339','Proales parasita (Ehrenberg, 1838)','(Ehrenberg, 1838)','SPECIES','','Proales','','parasita','','','',NULL,'','','','','','Ehrenberg','','','','1838','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0be587c2-fd4a-49be-ab41-62fad5c8ad48','','','Nuncia (Micronuncia) roeweri demissa Forster, 1954',1,'Nuncia roeweri demissa','Nuncia roeweri demissa','Nuncia roewer demiss',3,0,'','','Forster','3f8a8225-458d-594d-a4a3-048264002d61','Nuncia (Micronuncia) roeweri demissa Forster, 1954','Forster, 1954','SUBSPECIES','','Nuncia','','roeweri','demissa','','',NULL,'','','','','','Forster','','','','1954','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0be60532-0119-416f-bed0-80c2d77ac0e5','','','Phyllosticta circumscissa Cooke',1,'Phyllosticta circumscissa','Phyllosticta circumscissa','Phyllosticta circumsciss',2,0,'','','Cooke','b4068eee-f71f-57da-9e9b-677b3b59e867','Phyllosticta circumscissa Cooke','Cooke','SPECIES','','Phyllosticta','','circumscissa','','','',NULL,'','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0be32942-ad2d-44b0-a877-f851c2e344c6','','','Erwinia ananatis Serrano, 1928',1,'Erwinia ananatis','Erwinia ananatis','Erwinia ananat',2,0,'','','Serrano','55fdeb12-71f8-518b-ad5c-8472563da3ca','Erwinia ananatis Serrano, 1928','Serrano, 1928','SPECIES','','Erwinia','','ananatis','','','',NULL,'','','','','','Serrano','','','','1928','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bef7566-1bcc-45a4-b1b4-1fbea21308df','','','Pseudoarthrographis Crous & Thangavel',1,'Pseudoarthrographis','Pseudoarthrographis','Pseudoarthrographis',1,0,'','','Crous|Thangavel','bafd99d1-4b26-5ed6-96d5-5878918afbdb','Pseudoarthrographis Crous & Thangavel','Crous & Thangavel','GENUS','Pseudoarthrographis','','','','','','',NULL,'','','','','','Crous & Thangavel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0befe8ee-1654-4299-9fdb-630423aabe4f','','','Nephroma rufum (C.Bab.) P.James',1,'Nephroma rufum','Nephroma rufum','Nephroma ruf',2,0,'','','C. Bab.|P. James','2a14f7a8-95a8-5923-ad4c-632ac22770e1','Nephroma rufum (C.Bab.) P.James','(C.Bab.) P.James','SPECIES','','Nephroma','','rufum','','','',NULL,'P. James','','','','','C. Bab.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bef5511-05b6-4737-b9d5-d3d68ec02942','','','Micarea isabellina Coppins & Kantvilas',1,'Micarea isabellina','Micarea isabellina','Micarea isabellin',2,0,'','','Coppins|Kantvilas','fb38a69f-c6e3-5206-8e22-fac7f10a810b','Micarea isabellina Coppins & Kantvilas','Coppins & Kantvilas','SPECIES','','Micarea','','isabellina','','','',NULL,'','','','','','Coppins & Kantvilas','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bf7a1ab-7bbe-43b3-992d-75ec4e5da16d','','','Alternaria atra (Preuss) Woudenb. & Crous',1,'Alternaria atra','Alternaria atra','Alternaria atr',2,0,'','','Preuss|Woudenb.|Crous','c7525dad-7ce4-5bac-acdf-2c72552cfa0f','Alternaria atra (Preuss) Woudenb. & Crous','(Preuss) Woudenb. & Crous','SPECIES','','Alternaria','','atra','','','',NULL,'Woudenb. & Crous','','','','','Preuss','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bf234de-1a24-410c-bdc0-ff4c9df1abc1','','','Cotesia kazak (Telenga, 1949)',1,'Cotesia kazak','Cotesia kazak','Cotesia kazak',2,0,'','','Telenga','17b386f6-cff9-5811-85c1-1f9c2d812f5e','Cotesia kazak (Telenga, 1949)','(Telenga, 1949)','SPECIES','','Cotesia','','kazak','','','',NULL,'','','','','','Telenga','','','','1949','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bfaf0f7-00d4-42cc-91ad-5f9972726257','','','Amalda subg. Baryspira',2,'Baryspira','Amalda subgen. Baryspira','Baryspira',1,0,'','','','070a9a2d-7648-51f4-a361-032834fffddd','Amalda subg. Baryspira','','SUBGENUS','Baryspira','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bfb56c4-6911-4b4a-a674-7fdbe445d874','','','Cortinarius sect. Subcastanelli',2,'Subcastanelli','Cortinarius sect. Subcastanelli','Subcastanelli',1,0,'','','','a1c91a77-cbf6-5c90-9151-2370c0b5c993','Cortinarius sect. Subcastanelli','','SECTION','Subcastanelli','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bf9a014-49ce-4a60-bbbb-81cb560e04de','','','Truncospora ochroleuca (Berk.) Pilát ex S. Ito',1,'Truncospora ochroleuca','Truncospora ochroleuca','Truncospora ochroleuc',2,0,'','','Berk.|Pilát|S. Ito','afd34210-5a9b-523a-811c-3e87a2e4fa12','Truncospora ochroleuca (Berk.) Pilát ex S. Ito','(Berk.) Pilát ex S. Ito','SPECIES','','Truncospora','','ochroleuca','','','',NULL,'Pilát','','S. Ito','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bfc3b29-56fd-4c38-b606-c5062b74ba5d','','','Crassula multicava Lem.',1,'Crassula multicava','Crassula multicava','Crassula multicau',2,0,'','','Lem.','22bad2e9-bf38-5329-96d2-078d062694c3','Crassula multicava Lem.','Lem.','SPECIES','','Crassula','','multicava','','','',NULL,'','','','','','Lem.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bfc79a2-564e-4e00-ac6f-e0ce8cfdc6c8','','','Contacyphon propinquus (Broun, 1883)',1,'Contacyphon propinquus','Contacyphon propinquus','Contacyphon propinqu',2,0,'','','Broun','be08aeb7-eed1-5026-b57e-0d2e06ee607b','Contacyphon propinquus (Broun, 1883)','(Broun, 1883)','SPECIES','','Contacyphon','','propinquus','','','',NULL,'','','','','','Broun','','','','1883','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c065f74-ef1e-4178-b21f-84f4e075dcb5','','','Davidiella liabi (Petr.) Aptroot',1,'Davidiella liabi','Davidiella liabi','Davidiella liab',2,0,'','','Petr.|Aptroot','1b1960fb-473a-5e3e-82b3-2b3c44b4ce9b','Davidiella liabi (Petr.) Aptroot','(Petr.) Aptroot','SPECIES','','Davidiella','','liabi','','','',NULL,'Aptroot','','','','','Petr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c032392-94c9-452e-9ffb-995eb49c1ec4','','','Inocybe infirma E. Horak',1,'Inocybe infirma','Inocybe infirma','Inocybe infirm',2,0,'','','E. Horak','31ad71e6-4a80-5274-b648-a4c1671e7ab3','Inocybe infirma E. Horak','E. Horak','SPECIES','','Inocybe','','infirma','','','',NULL,'','','','','','E. Horak','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c04e45d-f860-43f8-862f-e7bd66a2b302','','','Placostylus (Maoristylus) ambagiosus',1,'Placostylus ambagiosus','Placostylus ambagiosus','Placostylus ambagios',2,0,'','','','3cfdf5e2-25bc-5922-bced-51b928b299ab','Placostylus (Maoristylus) ambagiosus','','SPECIES','','Placostylus','Maoristylus','ambagiosus','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c05e305-0393-4b74-a5f6-fbb8747382f8','','','Iridia',1,'Iridia','Iridia','Iridia',1,0,'','','','15b651b2-be93-5063-b30c-93013df913dc','Iridia','','GENUS','Iridia','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c04e6bb-8a63-4b63-b5c8-fde588413092','','','Asterina pouzolziae Petr.',1,'Asterina pouzolziae','Asterina pouzolziae','Asterina pouzolzi',2,0,'','','Petr.','565a6c84-0c59-5d2a-a8b8-a3f8e457aaae','Asterina pouzolziae Petr.','Petr.','SPECIES','','Asterina','','pouzolziae','','','',NULL,'','','','','','Petr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c0b116d-7eaf-4b48-918b-6b68d3a76590','','','Helxine Req.',1,'Helxine','Helxine','Helxine',1,0,'','','Req.','d4feef6b-8213-5a40-afa1-96a824e325f3','Helxine Req.','Req.','GENUS','Helxine','','','','','','',NULL,'','','','','','Req.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c0ff71b-3e89-4f70-9cab-9e9e8a0f7f04','','','Xanthoparmelia philippsiana (Filson) Elix & J.Johnst.',1,'Xanthoparmelia philippsiana','Xanthoparmelia philippsiana','Xanthoparmelia philippsian',2,0,'','','Filson|Elix|J. Johnst.','a4767a9e-110c-54e5-9269-102a6fecd3e4','Xanthoparmelia philippsiana (Filson) Elix & J.Johnst.','(Filson) Elix & J.Johnst.','SPECIES','','Xanthoparmelia','','philippsiana','','','',NULL,'Elix & J. Johnst.','','','','','Filson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c0d464d-a30a-41f6-a2fe-c7898ab344f3','','','Gen. n.',NULL,'','','',NULL,NULL,'','','','','Gen. n.','','GENUS','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c0bd72a-d45c-41f6-9435-e1c43ef0b14e','','','Stereum papyrinum Mont.',1,'Stereum papyrinum','Stereum papyrinum','Stereum papyrin',2,0,'','','Mont.','b7e175de-8bfa-57ef-9f32-66c1a8794497','Stereum papyrinum Mont.','Mont.','SPECIES','','Stereum','','papyrinum','','','',NULL,'','','','','','Mont.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c180281-6c49-4b39-88f3-28b34cf85f69','','','Austropsocus chathamensis Thornton, Wong & Smithers, 1977',1,'Austropsocus chathamensis','Austropsocus chathamensis','Austropsocus chathamens',2,0,'','','Thornton|Wong|Smithers','44ce542a-70e2-5717-9958-d10df725fef3','Austropsocus chathamensis Thornton, Wong & Smithers, 1977','Thornton, Wong & Smithers, 1977','SPECIES','','Austropsocus','','chathamensis','','','',NULL,'','','','','','Thornton, Wong & Smithers','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c12e29f-50a1-49cc-aff8-88bb3e03a9ce','','','Sphaerella cannabis G. Winter',1,'Sphaerella cannabis','Sphaerella cannabis','Sphaerella cannab',2,0,'','','G. Winter','1dd82c1f-ad5d-55f1-9530-c538a478a39f','Sphaerella cannabis G. Winter','G. Winter','SPECIES','','Sphaerella','','cannabis','','','',NULL,'','','','','','G. Winter','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c154358-15bf-4ce7-85f5-d2815d06be23','','','Oribotritia contraria Niedbala, 1993',1,'Oribotritia contraria','Oribotritia contraria','Oribotritia contrar',2,0,'','','Niedbala','ddea3b6c-a23b-5f94-b22e-b625658102f5','Oribotritia contraria Niedbala, 1993','Niedbala, 1993','SPECIES','','Oribotritia','','contraria','','','',NULL,'','','','','','Niedbala','','','','1993','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c1c7a86-3c4c-4442-aa73-5738bdecb242','','','Caymanabyssia',1,'Caymanabyssia','Caymanabyssia','Caymanabyssia',1,0,'','','','eb4698fd-bda0-5674-ad2c-730a8e8946cd','Caymanabyssia','','GENUS','Caymanabyssia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c1e505e-578c-4dd4-a79f-5a719bde2e7d','','','Cladosporium carpophilum Thüm.',1,'Cladosporium carpophilum','Cladosporium carpophilum','Cladosporium carpophil',2,0,'','','Thüm.','2b3f05ae-dd60-57bf-b0b2-b75cbd72ceff','Cladosporium carpophilum Thüm.','Thüm.','SPECIES','','Cladosporium','','carpophilum','','','',NULL,'','','','','','Thüm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c1c1145-3de3-49c4-afe4-985689749654','','','Echinaster farquhari Benham, 1909',1,'Echinaster farquhari','Echinaster farquhari','Echinaster farquhar',2,0,'','','Benham','ba475a58-d22b-5a2d-9649-ed0388396cf2','Echinaster farquhari Benham, 1909','Benham, 1909','SPECIES','','Echinaster','','farquhari','','','',NULL,'','','','','','Benham','','','','1909','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c1cd982-1b70-48fd-ba8f-b4344f95004b','','','Teloschistes fasciculatus Hillmann',1,'Teloschistes fasciculatus','Teloschistes fasciculatus','Teloschistes fasciculat',2,0,'','','Hillmann','f5e8162d-0d96-5112-94ad-1aa7eaeeac71','Teloschistes fasciculatus Hillmann','Hillmann','SPECIES','','Teloschistes','','fasciculatus','','','',NULL,'','','','','','Hillmann','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c2521e4-5bce-46c2-ac48-357b420166c0','','','Rhododendron ×detonsum Balf.f. & Forrest',3,'','','',NULL,NULL,'','','','','Rhododendron ×detonsum Balf.f. & Forrest','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c24737a-4864-4513-9da8-6c78353ddcfd','','','Capitellethus dispar (Ehlers, 1907)',1,'Capitellethus dispar','Capitellethus dispar','Capitellethus dispar',2,0,'','','Ehlers','dfe8d882-3270-545b-a72b-9bcc5000c677','Capitellethus dispar (Ehlers, 1907)','(Ehlers, 1907)','SPECIES','','Capitellethus','','dispar','','','',NULL,'','','','','','Ehlers','','','','1907','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c2617fe-6f5e-4bbc-b36b-c856e5bef147','','','Polystictus iodinus sensu Lloyd',4,'','','',NULL,NULL,'','','','','Polystictus iodinus sensu Lloyd','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c22fef1-19c0-4b23-a61c-dd3ddcceb201','','','Dianemataceae T. Macbr.',1,'Dianemataceae','Dianemataceae','Dianemataceae',1,0,'','','T. Macbr.','120fbca0-501b-5331-bcbd-7358346baec8','Dianemataceae T. Macbr.','T. Macbr.','FAMILY','Dianemataceae','','','','','','',NULL,'','','','','','T. Macbr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c2b3b98-5b1b-4ed8-a06f-157cc20e1a01','','','Themisto australis (Stebbing, 1888)',1,'Themisto australis','Themisto australis','Themisto austral',2,0,'','','Stebbing','a57939a4-c040-559c-9f9f-6762efddd748','Themisto australis (Stebbing, 1888)','(Stebbing, 1888)','SPECIES','','Themisto','','australis','','','',NULL,'','','','','','Stebbing','','','','1888','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c2cc3bb-8300-449f-83d0-4a104929ec8d','','','Oligota zealandica Bernhauer, 1941',1,'Oligota zealandica','Oligota zealandica','Oligota zealandic',2,0,'','','Bernhauer','b9e5de2c-d6ff-5414-a9d1-2a0fc241cc15','Oligota zealandica Bernhauer, 1941','Bernhauer, 1941','SPECIES','','Oligota','','zealandica','','','',NULL,'','','','','','Bernhauer','','','','1941','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c294a26-a870-4eee-bd4e-840f4ba4f830','','','Trenchia',1,'Trenchia','Trenchia','Trenchia',1,0,'','','','dce1619d-f6ad-5ea3-92c0-a02785900d30','Trenchia','','GENUS','Trenchia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c27dac1-429b-4fbb-b677-98f4fa8273c1','','','Agrocybe subpediades (Murrill) Watling',1,'Agrocybe subpediades','Agrocybe subpediades','Agrocybe subpediad',2,0,'','','Murrill|Watling','11e0ca86-6005-52d0-a856-70f57d6c02d8','Agrocybe subpediades (Murrill) Watling','(Murrill) Watling','SPECIES','','Agrocybe','','subpediades','','','',NULL,'Watling','','','','','Murrill','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c28a848-c741-4c35-b937-d152cae0deb4','','','Illeis',1,'Illeis','Illeis','Illeis',1,0,'','','','868417d7-806f-5c2b-a6f7-eb3938511c4b','Illeis','','GENUS','Illeis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c2b1025-dde8-46a2-bfbe-dd9a9f8b22f2','','','Seminavis strigosa (Hustedt) Danielidis & Economou-Amilli',1,'Seminavis strigosa','Seminavis strigosa','Seminavis strigos',2,0,'','','Hustedt|Danielidis|Economou-Amilli','27006f0b-542d-5966-ae3d-de9ed6aa01ee','Seminavis strigosa (Hustedt) Danielidis & Economou-Amilli','(Hustedt) Danielidis & Economou-Amilli','SPECIES','','Seminavis','','strigosa','','','',NULL,'Danielidis & Economou-Amilli','','','','','Hustedt','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c2e1ef7-1e27-4bb3-9984-5c855fe28581','','','Labyrinthodonta',1,'Labyrinthodonta','Labyrinthodonta','Labyrinthodonta',1,0,'','','','ff10c554-ac31-5be8-9f6e-b9408ec78706','Labyrinthodonta','','SUPERORDER','Labyrinthodonta','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c310a28-cffe-41f5-a40e-625d9242693a','','','Vicia tetrasperma (L.) Schreb.',1,'Vicia tetrasperma','Vicia tetrasperma','Vicia tetrasperm',2,0,'','','L.|Schreb.','eb2a48be-c57e-57f9-87c9-6836de5446a0','Vicia tetrasperma (L.) Schreb.','(L.) Schreb.','SPECIES','','Vicia','','tetrasperma','','','',NULL,'Schreb.','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c30e5d1-e0da-413b-be43-a4584eb1b5f8','','','Eugamasus',1,'Eugamasus','Eugamasus','Eugamasus',1,0,'','','','724882af-7c6e-5b99-9694-31c1071bdf85','Eugamasus','','GENUS','Eugamasus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c2ef218-50f9-41ec-8683-d7db82467e4b','','','Mastigobryum',1,'Mastigobryum','Mastigobryum','Mastigobryum',1,0,'','','','e25d88e6-fc9f-52c8-98c6-bfb67e89ff6e','Mastigobryum','','GENUS','Mastigobryum','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c2cdf03-0776-41ba-b18f-e143358d3b1f','','','Encyonema neogracile Krammer',1,'Encyonema neogracile','Encyonema neogracile','Encyonema neogracil',2,0,'','','Krammer','39beef38-8b5a-5b15-9113-50d0e06b326a','Encyonema neogracile Krammer','Krammer','SPECIES','','Encyonema','','neogracile','','','',NULL,'','','','','','Krammer','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c325ab3-732b-4ef2-8b19-eccfb1ecc3a4','','','Saccobolus depauperatus (Berk. & Broome) E.C. Hansen',1,'Saccobolus depauperatus','Saccobolus depauperatus','Saccobolus depauperat',2,0,'','','Berk.|Broome|E. C. Hansen','40ac4e49-89c7-59ac-a9ff-b69a6107684e','Saccobolus depauperatus (Berk. & Broome) E.C. Hansen','(Berk. & Broome) E.C. Hansen','SPECIES','','Saccobolus','','depauperatus','','','',NULL,'E. C. Hansen','','','','','Berk. & Broome','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c342493-4496-4127-97e6-6b2b617527f3','','','Cornicularia ochroleuca var. nigricans Ach.',1,'Cornicularia ochroleuca nigricans','Cornicularia ochroleuca var. nigricans','Cornicularia ochroleuc nigricans',3,0,'','','Ach.','349157f8-4f0c-537d-b06a-6b17617f217c','Cornicularia ochroleuca var. nigricans Ach.','Ach.','VARIETY','','Cornicularia','','ochroleuca','nigricans','','',NULL,'','','','','','Ach.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c3a23c5-3da4-41df-8017-9080b08870ca','','','Selenosporella curvispora G. Arnaud ex MacGarvie',1,'Selenosporella curvispora','Selenosporella curvispora','Selenosporella curuispor',2,0,'','','G. Arnaud|MacGarvie','055080c8-ee3d-55f2-af1c-8e6eee641e71','Selenosporella curvispora G. Arnaud ex MacGarvie','G. Arnaud ex MacGarvie','SPECIES','','Selenosporella','','curvispora','','','',NULL,'','','','','','G. Arnaud','','MacGarvie','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c363823-d5e3-4ddc-8e3f-c8b4c27582cf','','','Newzealandia inaequalistriata (Dendy, 1894)',1,'Newzealandia inaequalistriata','Newzealandia inaequalistriata','Newzealandia inaequalistriat',2,0,'','','Dendy','7313351f-53ab-55f4-9e5a-25ac0c0c5202','Newzealandia inaequalistriata (Dendy, 1894)','(Dendy, 1894)','SPECIES','','Newzealandia','','inaequalistriata','','','',NULL,'','','','','','Dendy','','','','1894','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c3d7e17-bcee-4935-b47f-293fd1405dff','','','Carex banksiana K.A.Ford',1,'Carex banksiana','Carex banksiana','Carex banksian',2,0,'','','K. A. Ford','1928f7df-65d2-5669-bc3d-1fbbcd9cf926','Carex banksiana K.A.Ford','K.A.Ford','SPECIES','','Carex','','banksiana','','','',NULL,'','','','','','K. A. Ford','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c3efe92-3bca-4c1c-b69f-765b33ef63b7','','','Septoria tradescantiae (Ellis & Kellerm.) Davis',1,'Septoria tradescantiae','Septoria tradescantiae','Septoria tradescanti',2,0,'','','Ellis|Kellerm.|Davis','fed3a24e-de4a-5b97-b610-ac0d2730cda2','Septoria tradescantiae (Ellis & Kellerm.) Davis','(Ellis & Kellerm.) Davis','SPECIES','','Septoria','','tradescantiae','','','',NULL,'Davis','','','','','Ellis & Kellerm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c3fa629-3e1e-4ba6-8649-a7ce2d0c47c0','','','Chiloscyphus erraticus W.Martin & E.A.Hodgs.',1,'Chiloscyphus erraticus','Chiloscyphus erraticus','Chiloscyphus erratic',2,0,'','','W. Martin|E. A. Hodgs.','0c677770-df81-5f4b-b0b4-c68235154a64','Chiloscyphus erraticus W.Martin & E.A.Hodgs.','W.Martin & E.A.Hodgs.','SPECIES','','Chiloscyphus','','erraticus','','','',NULL,'','','','','','W. Martin & E. A. Hodgs.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c451adf-0f31-461d-b26d-0dddcd31290b','','','Thelebolus crustaceus (Fuckel) Kimbr.',1,'Thelebolus crustaceus','Thelebolus crustaceus','Thelebolus crustace',2,0,'','','Fuckel|Kimbr.','8dfb7e8f-1bda-51b2-be33-3a4abdf4a3d9','Thelebolus crustaceus (Fuckel) Kimbr.','(Fuckel) Kimbr.','SPECIES','','Thelebolus','','crustaceus','','','',NULL,'Kimbr.','','','','','Fuckel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c44895b-d45d-4ff4-9fbf-6301dd3a7c58','','','Tychosporium',1,'Tychosporium','Tychosporium','Tychosporium',1,0,'','','','22cb9158-a7c2-52c0-87a4-df4565f9298f','Tychosporium','','GENUS','Tychosporium','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c43abbf-639b-4eab-83ed-7c3a0cfc393b','','','Zingiber Mill.',1,'Zingiber','Zingiber','Zingiber',1,0,'','','Mill.','49f6d68f-ae37-58ce-8eb7-6032ce2d2349','Zingiber Mill.','Mill.','GENUS','Zingiber','','','','','','',NULL,'','','','','','Mill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c45aaeb-3439-4680-8826-9e5b5329d32f','','','Arecales Bromhead',1,'Arecales','Arecales','Arecales',1,0,'','','Bromhead','f31f1df6-6589-5473-a7bc-409d1006987c','Arecales Bromhead','Bromhead','ORDER','Arecales','','','','','','',NULL,'','','','','','Bromhead','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d3226e3-53f9-4985-99c1-1bb76bc1080d','','','Sellnickia',1,'Sellnickia','Sellnickia','Sellnickia',1,0,'','','','4522b032-9b70-55ae-afac-94cf482ac07f','Sellnickia','','GENUS','Sellnickia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d320150-495d-4d14-9ab0-2f6bee720826','','','Trineuron pusillum Hook.f.',1,'Trineuron pusillum','Trineuron pusillum','Trineuron pusill',2,0,'','','Hook. fil.','82149c65-ef4e-51f6-b53f-58fc248cbc01','Trineuron pusillum Hook.f.','Hook.f.','SPECIES','','Trineuron','','pusillum','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d323dce-b6ac-4fb2-8064-3efb8231ab42','','','Sphaeria multiformis Fr. var. multiformis',1,'Sphaeria multiformis multiformis','Sphaeria multiformis var. multiformis','Sphaeria multiform multiform',3,0,'','','','0651dce8-4be7-5faf-9d1b-99af9e20310d','Sphaeria multiformis Fr. var. multiformis','','VARIETY','','Sphaeria','','multiformis','multiformis','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d2f27b3-39a7-4560-a86b-827f27863936','','','Naucoria pediades sensu Massee',4,'','','',NULL,NULL,'','','','','Naucoria pediades sensu Massee','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d2e28d4-95f7-4b26-8675-9c560e4d411d','','','Scleronephthya species NIWA G. Williams',4,'','','',NULL,NULL,'','','','','Scleronephthya species NIWA G. Williams','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d2ce753-94fc-4e6c-97b0-bb88bb7fbbb4','','','Pronkia antefurcalis van Achterberg, 1990',1,'Pronkia antefurcalis','Pronkia antefurcalis','Pronkia antefurcal',2,0,'','','van Achterberg','4ab7805a-93b5-584a-b193-0a2ef40746e4','Pronkia antefurcalis van Achterberg, 1990','van Achterberg, 1990','SPECIES','','Pronkia','','antefurcalis','','','',NULL,'','','','','','van Achterberg','','','','1990','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d30ee3a-dddc-49f6-8fff-fadd0e6d8859','','','Pimelea prostrata (J.R.Forst. & G.Forst.) Willd. subsp. prostrata',1,'Pimelea prostrata prostrata','Pimelea prostrata subsp. prostrata','Pimelea prostrat prostrat',3,0,'','','','a14ce4d0-ea59-55d4-bf70-e374c0e9659a','Pimelea prostrata (J.R.Forst. & G.Forst.) Willd. subsp. prostrata','','SUBSPECIES','','Pimelea','','prostrata','prostrata','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d363339-a163-4af1-8e01-b3f6ea9104f8','','','Atopida basalis Broun, 1912',1,'Atopida basalis','Atopida basalis','Atopida basal',2,0,'','','Broun','825a0497-dcf3-5dfd-a8c4-8d3cb9821897','Atopida basalis Broun, 1912','Broun, 1912','SPECIES','','Atopida','','basalis','','','',NULL,'','','','','','Broun','','','','1912','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d34d1eb-e86a-4f5b-9ed2-f2e7a8ba73d2','','','Sitobolium',1,'Sitobolium','Sitobolium','Sitobolium',1,0,'','','','176723be-466d-54d1-b1c7-6deae810237f','Sitobolium','','GENUS','Sitobolium','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d3b8b4b-f1bb-472e-8678-0025b0e6b8b7','','','Cenolia species Ameziane pers. comm.',4,'','','',NULL,NULL,'','','','','Cenolia species Ameziane pers. comm.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d3a70c7-9d88-4ed1-b511-11e57b791c95','','','Cyloma flemingi (Ordish, 1974)',1,'Cyloma flemingi','Cyloma flemingi','Cyloma fleming',2,0,'','','Ordish','768fb991-ae61-5efc-986e-42f15633bf8c','Cyloma flemingi (Ordish, 1974)','(Ordish, 1974)','SPECIES','','Cyloma','','flemingi','','','',NULL,'','','','','','Ordish','','','','1974','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d3c795f-d44b-40e7-8351-5d9ff68d4783','','','Phacodinium',1,'Phacodinium','Phacodinium','Phacodinium',1,0,'','','','615f7ff0-0f3d-5090-89cb-f3c88539d01b','Phacodinium','','GENUS','Phacodinium','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d3c753b-27f1-4615-986c-8aa9aea42ad0','','','Lathyrus sylvestris L.',1,'Lathyrus sylvestris','Lathyrus sylvestris','Lathyrus syluestr',2,0,'','','L.','1ae6f747-ae84-5bed-8d43-cdf57c2ab6f7','Lathyrus sylvestris L.','L.','SPECIES','','Lathyrus','','sylvestris','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d3d965b-9440-43d6-bef1-b53bda52b961','','','Nepenthes alata Blanco',1,'Nepenthes alata','Nepenthes alata','Nepenthes alat',2,0,'','','Blanco','a6623051-c747-5e34-a987-e860057d5081','Nepenthes alata Blanco','Blanco','SPECIES','','Nepenthes','','alata','','','',NULL,'','','','','','Blanco','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d426fa7-275b-40ad-b3bd-063a9918b548','','','Capsulospora K.D. Hyde',1,'Capsulospora','Capsulospora','Capsulospora',1,0,'','','K. D. Hyde','01546800-10a7-59c6-8b10-fa823e4e68a6','Capsulospora K.D. Hyde','K.D. Hyde','GENUS','Capsulospora','','','','','','',NULL,'','','','','','K. D. Hyde','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d442baf-f11c-41b1-a9c1-6b1cae7e5854','','','Hypnum squarrosum Hedw.',1,'Hypnum squarrosum','Hypnum squarrosum','Hypnum squarros',2,0,'','','Hedw.','62d55156-64b7-5f92-bd37-3e79124acd43','Hypnum squarrosum Hedw.','Hedw.','SPECIES','','Hypnum','','squarrosum','','','',NULL,'','','','','','Hedw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d425aa0-3410-48e0-ab37-b707c58daa65','','','Lophocolea goebeliana Steph.',1,'Lophocolea goebeliana','Lophocolea goebeliana','Lophocolea goebelian',2,0,'','','Steph.','980e3c5c-4263-5011-abb2-cbff44005cb4','Lophocolea goebeliana Steph.','Steph.','SPECIES','','Lophocolea','','goebeliana','','','',NULL,'','','','','','Steph.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d46594b-cfa3-4e63-a68c-0bb760ed4c4a','','','Fissidentalium',1,'Fissidentalium','Fissidentalium','Fissidentalium',1,0,'','','','fb55833b-a9bc-5f57-af1e-033fd4b7d100','Fissidentalium','','GENUS','Fissidentalium','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d4cfb45-34a3-4cc6-8c76-524a57e2100b','','','Todea africana Willd. ex Bernh.',1,'Todea africana','Todea africana','Todea african',2,0,'','','Willd.|Bernh.','f6a8d017-8913-5f90-8719-3ff74e0ada00','Todea africana Willd. ex Bernh.','Willd. ex Bernh.','SPECIES','','Todea','','africana','','','',NULL,'','','','','','Willd.','','Bernh.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d4a3527-96f9-470e-9745-8b578b06b99e','','','Dothichiza foveolaris (Fr.) Petr.',1,'Dothichiza foveolaris','Dothichiza foveolaris','Dothichiza foueolar',2,0,'','','Fr.|Petr.','f90f4032-225a-5495-a8f0-321977743838','Dothichiza foveolaris (Fr.) Petr.','(Fr.) Petr.','SPECIES','','Dothichiza','','foveolaris','','','',NULL,'Petr.','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d4b6bcc-e726-40a4-b2f0-ddd6e10ab7f7','','','Halobates Eschscholtz, 1822',1,'Halobates','Halobates','Halobates',1,0,'','','Eschscholtz','267eed4b-fffa-548c-83b2-b6ebc80d366a','Halobates Eschscholtz, 1822','Eschscholtz, 1822','GENUS','Halobates','','','','','','',NULL,'','','','','','Eschscholtz','','','','1822','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d4fef83-c18e-450a-9cd3-2423fc351774','','','Xanthomonas axonopodis pv. patelii (Desai and Shah 1959) Vauterin et al., 1995',1,'Xanthomonas axonopodis patelii','Xanthomonas axonopodis pv. patelii','Xanthomonas axonopod patel',3,0,'','','Desai|Shah|Vauterin et al.','1515f5d9-ce7e-5d28-b392-4b75480be4d1','Xanthomonas axonopodis pv. patelii (Desai and Shah 1959) Vauterin et al., 1995','(Desai and Shah 1959) Vauterin et al., 1995','PATHOVAR','','Xanthomonas','','axonopodis','patelii','','',NULL,'Vauterin et al.','','','','1995','Desai & Shah','','','','1959','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d4dda3d-1892-4eda-948b-69fe0b30c65f','','','Chusquea galeottiana Rupr. ex Munro',1,'Chusquea galeottiana','Chusquea galeottiana','Chusquea galeottian',2,0,'','','Rupr.|Munro','cb4414c8-cfd9-57e6-b20e-b2ff2d80bc6b','Chusquea galeottiana Rupr. ex Munro','Rupr. ex Munro','SPECIES','','Chusquea','','galeottiana','','','',NULL,'','','','','','Rupr.','','Munro','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d4f18f0-cfd0-4051-9b05-8e3a80b503c4','','','Acer capillipes Maxim.',1,'Acer capillipes','Acer capillipes','Acer capillip',2,0,'','','Maxim.','af538d28-6e75-55c5-90ed-a831ccbcd672','Acer capillipes Maxim.','Maxim.','SPECIES','','Acer','','capillipes','','','',NULL,'','','','','','Maxim.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d52a514-3cc3-40c3-8a9b-ba1863fef602','','','Rhabdamminidae',1,'Rhabdamminidae','Rhabdamminidae','Rhabdamminidae',1,0,'','','','dbb47748-378e-5433-abaa-8bada2d6ded8','Rhabdamminidae','','FAMILY','Rhabdamminidae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d5489c1-64e5-4d64-88c3-de55b5b46b84','','','Blatticola',1,'Blatticola','Blatticola','Blatticola',1,0,'','','','d7b72628-0bd5-5317-ab6c-0dea3ad2fdee','Blatticola','','GENUS','Blatticola','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d5794f0-43cc-4365-99b5-1a03a6776de5','','','Hebe bidwillii (Hook.) A.Wall',1,'Hebe bidwillii','Hebe bidwillii','Hebe bidwill',2,0,'','','Hook.|A. Wall','0c9972b3-8b22-566c-9fc3-a70987d7decf','Hebe bidwillii (Hook.) A.Wall','(Hook.) A.Wall','SPECIES','','Hebe','','bidwillii','','','',NULL,'A. Wall','','','','','Hook.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d5881f1-fd7d-4968-ac6c-9c5cb9eace99','','','Larentia anthracias Meyrick, 1883',1,'Larentia anthracias','Larentia anthracias','Larentia anthraci',2,0,'','','Meyrick','87101262-3b02-5ce6-830c-90fb3b58c439','Larentia anthracias Meyrick, 1883','Meyrick, 1883','SPECIES','','Larentia','','anthracias','','','',NULL,'','','','','','Meyrick','','','','1883','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d57e7e8-c842-4673-af48-af1b72532a00','','','Endothia Fr.',1,'Endothia','Endothia','Endothia',1,0,'','','Fr.','4dcfb6c6-e722-504f-bc60-853187703860','Endothia Fr.','Fr.','GENUS','Endothia','','','','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d625e7b-17d0-405b-b9c6-1d7b1c7edf90','','','Euconnus paracilipes Franz, 1986',1,'Euconnus paracilipes','Euconnus paracilipes','Euconnus paracilip',2,0,'','','Franz','a0ab8848-c03c-5142-934f-3d19e626f6af','Euconnus paracilipes Franz, 1986','Franz, 1986','SPECIES','','Euconnus','','paracilipes','','','',NULL,'','','','','','Franz','','','','1986','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d63e57c-b41a-48c5-956c-a587fa0184ac','','','Leucoagaricus purpureolilacinus Huijsman',1,'Leucoagaricus purpureolilacinus','Leucoagaricus purpureolilacinus','Leucoagaricus purpureolilacin',2,0,'','','Huijsman','19ba23d5-c011-52b5-a1e4-6e834f97102d','Leucoagaricus purpureolilacinus Huijsman','Huijsman','SPECIES','','Leucoagaricus','','purpureolilacinus','','','',NULL,'','','','','','Huijsman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d6c79a0-1e0d-4720-899e-1156ebdaf7f3','','','Alyssum L.',1,'Alyssum','Alyssum','Alyssum',1,0,'','','L.','68bf8a8d-a62f-59fc-b994-e48e754e2333','Alyssum L.','L.','GENUS','Alyssum','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d67101b-f6bf-41fe-8503-8d40b1e5ab01','','','Peltigera ulcerata Müll.Arg.',1,'Peltigera ulcerata','Peltigera ulcerata','Peltigera ulcerat',2,0,'','','Müll. Arg.','64ac866f-99e4-5a7f-acd1-105188b1a509','Peltigera ulcerata Müll.Arg.','Müll.Arg.','SPECIES','','Peltigera','','ulcerata','','','',NULL,'','','','','','Müll. Arg.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d695134-9953-4f33-ab78-da4b963d1222','','','Paracypria tenuis (Sars, 1905)',1,'Paracypria tenuis','Paracypria tenuis','Paracypria tenu',2,0,'','','Sars','ceb25b31-f9b3-5c24-bb29-ce9404476b30','Paracypria tenuis (Sars, 1905)','(Sars, 1905)','SPECIES','','Paracypria','','tenuis','','','',NULL,'','','','','','Sars','','','','1905','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d716073-db6b-45e4-9ae8-495c7e815394','','','Lepidametria',1,'Lepidametria','Lepidametria','Lepidametria',1,0,'','','','31959afc-dba9-5476-92e0-95ad0092cccc','Lepidametria','','GENUS','Lepidametria','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d742e68-fb80-4844-9033-c6fdaa98bf99','','','Agrostis quadrifida Labill.',1,'Agrostis quadrifida','Agrostis quadrifida','Agrostis quadrifid',2,0,'','','Labill.','3434b131-a116-5d15-a68c-af2d765c595b','Agrostis quadrifida Labill.','Labill.','SPECIES','','Agrostis','','quadrifida','','','',NULL,'','','','','','Labill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c4f56e3-bd90-4296-83e9-2e133b32566b','','','Parakiefferiella Thienemann, 1936',1,'Parakiefferiella','Parakiefferiella','Parakiefferiella',1,0,'','','Thienemann','ce72e9b3-4ff7-5402-86aa-2034c0194468','Parakiefferiella Thienemann, 1936','Thienemann, 1936','GENUS','Parakiefferiella','','','','','','',NULL,'','','','','','Thienemann','','','','1936','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c4ee4d5-1eeb-4f0b-853c-69d28ae35266','','','Barbatia decussata (G. B. Sowerby I, 1823)',1,'Barbatia decussata','Barbatia decussata','Barbatia decussat',2,0,'','','G. B. Sowerby I','fe0a8d54-3815-59f1-bbc1-9614656da7c0','Barbatia decussata (G. B. Sowerby I, 1823)','(G. B. Sowerby I, 1823)','SPECIES','','Barbatia','','decussata','','','',NULL,'','','','','','G. B. Sowerby I','','','','1823','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c47b6dd-0b5f-4077-b906-ce3c72df5b9c','','','Sporisorium paspali-thunbergii (Henn.) Vánky',1,'Sporisorium paspali-thunbergii','Sporisorium paspali-thunbergii','Sporisorium paspali-thunberg',2,0,'','','Henn.|Vánky','505266f3-97d5-595d-8a47-a9029776506b','Sporisorium paspali-thunbergii (Henn.) Vánky','(Henn.) Vánky','SPECIES','','Sporisorium','','paspali-thunbergii','','','',NULL,'Vánky','','','','','Henn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c5163b4-ff04-4bfd-9d54-06e88f82bae2','','','Arthurdendyus testaceus (Hutton, 1880)',1,'Arthurdendyus testaceus','Arthurdendyus testaceus','Arthurdendyus testace',2,0,'','','Hutton','15abad09-1196-59e2-b4dc-1e7b1887b6d6','Arthurdendyus testaceus (Hutton, 1880)','(Hutton, 1880)','SPECIES','','Arthurdendyus','','testaceus','','','',NULL,'','','','','','Hutton','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c53dc3d-bdf5-4fd8-b6ac-89754505df14','','','Microspalax',1,'Microspalax','Microspalax','Microspalax',1,0,'','','','00bcf03b-1670-580e-9592-f1a43c70a5cb','Microspalax','','GENUS','Microspalax','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c52eaaa-3af0-4523-ba69-8e1bab71f1a1','','','Protomerulius brachysporus (Luck-Allen) V. Spirin & V. Malysheva',1,'Protomerulius brachysporus','Protomerulius brachysporus','Protomerulius brachyspor',2,0,'','','Luck-Allen|V. Spirin|V. Malysheva','28d3db40-ae0b-59bd-8d0d-a9ffc64a1fdd','Protomerulius brachysporus (Luck-Allen) V. Spirin & V. Malysheva','(Luck-Allen) V. Spirin & V. Malysheva','SPECIES','','Protomerulius','','brachysporus','','','',NULL,'V. Spirin & V. Malysheva','','','','','Luck-Allen','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c524ed8-efed-4d27-a555-b3429d2e7b73','','','Strigula johnsonii P.M.McCarthy',1,'Strigula johnsonii','Strigula johnsonii','Strigula iohnson',2,0,'','','P. M. McCarthy','36ecee5d-f1cf-5b56-bb20-3d8de63a66ab','Strigula johnsonii P.M.McCarthy','P.M.McCarthy','SPECIES','','Strigula','','johnsonii','','','',NULL,'','','','','','P. M. McCarthy','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c59491c-3fb8-49d8-8812-4fdf272381aa','','','Epilobium pernitens Cockayne & Allan',1,'Epilobium pernitens','Epilobium pernitens','Epilobium pernitens',2,0,'','','Cockayne|Allan','f71bd23c-b1b1-5f4c-9c5d-6fad50548d1a','Epilobium pernitens Cockayne & Allan','Cockayne & Allan','SPECIES','','Epilobium','','pernitens','','','',NULL,'','','','','','Cockayne & Allan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c64d878-9246-4dac-89c8-0131353231a1','','','Dasyscypha Fuckel',1,'Dasyscypha','Dasyscypha','Dasyscypha',1,0,'','','Fuckel','ff4b2d94-7105-5eb5-8d06-3fb0d226d05c','Dasyscypha Fuckel','Fuckel','GENUS','Dasyscypha','','','','','','',NULL,'','','','','','Fuckel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c5d71bd-37e9-401b-b378-0607095e89de','','','Neophreatoicus',1,'Neophreatoicus','Neophreatoicus','Neophreatoicus',1,0,'','','','86c8ef04-8801-5a08-9ec7-7ee3d4e5c728','Neophreatoicus','','GENUS','Neophreatoicus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c610667-34b8-41fa-b44f-2f2a450100f1','','','Arthonia perparva (Zahlbr.) Matzer',1,'Arthonia perparva','Arthonia perparva','Arthonia perparu',2,0,'','','Zahlbr.|Matzer','8b8c9e76-17af-53bf-8f55-8426a0678b58','Arthonia perparva (Zahlbr.) Matzer','(Zahlbr.) Matzer','SPECIES','','Arthonia','','perparva','','','',NULL,'Matzer','','','','','Zahlbr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c62c9c8-4169-4269-8f57-7f61f2436614','','','Macropora levinseni Brown, 1952',1,'Macropora levinseni','Macropora levinseni','Macropora leuinsen',2,0,'','','Brown','6612ece7-1814-5538-978b-73a55f70d7ed','Macropora levinseni Brown, 1952','Brown, 1952','SPECIES','','Macropora','','levinseni','','','',NULL,'','','','','','Brown','','','','1952','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c62b385-e0b9-44b2-8c72-a814b8062f55','','','Kiwi oreteus Khalaim and Ward, 2019',1,'Kiwi oreteus','Kiwi oreteus','Kiwi orete',2,0,'','','Khalaim|Ward','46aeabc5-604e-58ca-9284-c8406745154a','Kiwi oreteus Khalaim and Ward, 2019','Khalaim and Ward, 2019','SPECIES','','Kiwi','','oreteus','','','',NULL,'','','','','','Khalaim & Ward','','','','2019','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c6aa8c2-318c-4b2a-adb2-593a681da7c3','','','Celmisia rupestris Cheeseman',1,'Celmisia rupestris','Celmisia rupestris','Celmisia rupestr',2,0,'','','Cheeseman','d3b31473-eb17-5880-a662-c5ac5111957f','Celmisia rupestris Cheeseman','Cheeseman','SPECIES','','Celmisia','','rupestris','','','',NULL,'','','','','','Cheeseman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c674033-7772-4aa6-b911-79f6b0e013a1','','','Zeaphilon marskeae Leschen, Reid and Madein, 2020',1,'Zeaphilon marskeae','Zeaphilon marskeae','Zeaphilon marske',2,0,'','','Leschen|Reid|Madein','e354702a-cab4-5b9d-a34b-d983394432fc','Zeaphilon marskeae Leschen, Reid and Madein, 2020','Leschen, Reid and Madein, 2020','SPECIES','','Zeaphilon','','marskeae','','','',NULL,'','','','','','Leschen, Reid & Madein','','','','2020','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c6c6f20-5f81-4758-a415-dc62d4c972bf','','','Eurotium costiforme H.Z. Kong & Z.T. Qi',1,'Eurotium costiforme','Eurotium costiforme','Eurotium costiform',2,0,'','','H. Z. Kong|Z. T. Qi','162db67e-bba0-5f3c-b30d-7b459b9fc67e','Eurotium costiforme H.Z. Kong & Z.T. Qi','H.Z. Kong & Z.T. Qi','SPECIES','','Eurotium','','costiforme','','','',NULL,'','','','','','H. Z. Kong & Z. T. Qi','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c76f094-6112-4458-b1d4-1256adfab9a8','','','Septoria listerae Allesch.',1,'Septoria listerae','Septoria listerae','Septoria lister',2,0,'','','Allesch.','dbeaa719-49cb-5390-89e0-6745437255c2','Septoria listerae Allesch.','Allesch.','SPECIES','','Septoria','','listerae','','','',NULL,'','','','','','Allesch.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c737e20-10af-4792-923d-2d0d84b3d497','','','Sporisorium indehiscens (L. Ling) Vánky',1,'Sporisorium indehiscens','Sporisorium indehiscens','Sporisorium indehiscens',2,0,'','','L. Ling|Vánky','243c5da0-577f-5cfb-91c6-b33b54d8ac20','Sporisorium indehiscens (L. Ling) Vánky','(L. Ling) Vánky','SPECIES','','Sporisorium','','indehiscens','','','',NULL,'Vánky','','','','','L. Ling','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c76be2a-060c-43af-94fc-aa822ade0a04','','','Jungermannia aterrima Hook.f. & Taylor',1,'Jungermannia aterrima','Jungermannia aterrima','Jungermannia aterrim',2,0,'','','Hook. fil.|Taylor','d9d13265-9aa8-54d7-92aa-f9640ddab358','Jungermannia aterrima Hook.f. & Taylor','Hook.f. & Taylor','SPECIES','','Jungermannia','','aterrima','','','',NULL,'','','','','','Hook. fil. & Taylor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c7eb3f6-099f-48a4-a1bf-0d08b2a23b0f','','','Gallinula hodgenorum (Scarlett, 1955)',1,'Gallinula hodgenorum','Gallinula hodgenorum','Gallinula hodgenor',2,0,'','','Scarlett','560b08d2-703e-5308-bd61-4afe47e37c89','Gallinula hodgenorum (Scarlett, 1955)','(Scarlett, 1955)','SPECIES','','Gallinula','','hodgenorum','','','',NULL,'','','','','','Scarlett','','','','1955','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c7ea2d6-b764-48f9-be8d-37102cb86ffb','','','Stenomastax Cameron, 1933',1,'Stenomastax','Stenomastax','Stenomastax',1,0,'','','Cameron','fc1fadd8-7691-5860-a000-8f28c2bdc9cf','Stenomastax Cameron, 1933','Cameron, 1933','GENUS','Stenomastax','','','','','','',NULL,'','','','','','Cameron','','','','1933','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c7f0308-b4a5-459f-8f3c-6a477ce916a9','','','Conchoecia belgicae Müller, 1906',1,'Conchoecia belgicae','Conchoecia belgicae','Conchoecia belgic',2,0,'','','Müller','3ff65975-753e-5cb2-9c1a-547af6a669cd','Conchoecia belgicae Müller, 1906','Müller, 1906','SPECIES','','Conchoecia','','belgicae','','','',NULL,'','','','','','Müller','','','','1906','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c7a44a7-1ecd-433c-8f65-b5ab0ac54b03','','','Cubomedusae',1,'Cubomedusae','Cubomedusae','Cubomedusae',1,0,'','','','73a3813c-a509-5e30-9c03-c13972fb5c06','Cubomedusae','','ORDER','Cubomedusae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c7c4519-fdec-4b7d-9c1b-c024a5b15e4a','','','Rinodina olivaceobrunnea C.W.Dodge & G.E.Baker',1,'Rinodina olivaceobrunnea','Rinodina olivaceobrunnea','Rinodina oliuaceobrunne',2,0,'','','C. W. Dodge|G. E. Baker','84195c33-01a7-51b4-93c6-516446a44661','Rinodina olivaceobrunnea C.W.Dodge & G.E.Baker','C.W.Dodge & G.E.Baker','SPECIES','','Rinodina','','olivaceobrunnea','','','',NULL,'','','','','','C. W. Dodge & G. E. Baker','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c8303de-6f69-42af-a8a7-481f3952b5a0','','','Sanguinicolidae',1,'Sanguinicolidae','Sanguinicolidae','Sanguinicolidae',1,0,'','','','6e20971d-1bf4-5212-b77a-2c3001cb6c12','Sanguinicolidae','','FAMILY','Sanguinicolidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c8132ce-e440-44b8-9b45-57a2eeff3711','','','Dothichloe G.F. Atk.',1,'Dothichloe','Dothichloe','Dothichloe',1,0,'','','G. F. Atk.','5e94ef36-c6bc-5c29-8c8f-6ed24771c91b','Dothichloe G.F. Atk.','G.F. Atk.','GENUS','Dothichloe','','','','','','',NULL,'','','','','','G. F. Atk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c849f3b-1a73-4a8f-8ba3-ac2551ba7310','','','Eutypella species',4,'','','',NULL,NULL,'','','','','Eutypella species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c81e21d-fe01-4fc0-9ac9-b0cb10f85cc2','','','Scirpus prolifer Rottb.',1,'Scirpus prolifer','Scirpus prolifer','Scirpus prolifer',2,0,'','','Rottb.','301d728f-c394-5e86-8129-9e7572ce4aa3','Scirpus prolifer Rottb.','Rottb.','SPECIES','','Scirpus','','prolifer','','','',NULL,'','','','','','Rottb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c8243f3-bc6d-458c-89af-f25008ca75f1','','','Bubaris ornata Dendy, 1924',1,'Bubaris ornata','Bubaris ornata','Bubaris ornat',2,0,'','','Dendy','16624965-102f-5242-b80b-7aaa1e20d854','Bubaris ornata Dendy, 1924','Dendy, 1924','SPECIES','','Bubaris','','ornata','','','',NULL,'','','','','','Dendy','','','','1924','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c8c77a5-092d-47be-bd3f-5c6f46c933c4','','','Peristoreus innocens Kirsch, 1877',1,'Peristoreus innocens','Peristoreus innocens','Peristoreus innocens',2,0,'','','Kirsch','64b0b70f-b116-5108-93ef-0dcb236bbfbf','Peristoreus innocens Kirsch, 1877','Kirsch, 1877','SPECIES','','Peristoreus','','innocens','','','',NULL,'','','','','','Kirsch','','','','1877','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c8a04b4-9304-4744-ad6b-befd497e3910','','','Pseudonsiella aotearoa Hicks, 1988',1,'Pseudonsiella aotearoa','Pseudonsiella aotearoa','Pseudonsiella aotearo',2,0,'','','Hicks','d7cecfe3-7114-50ae-9256-d0709536933f','Pseudonsiella aotearoa Hicks, 1988','Hicks, 1988','SPECIES','','Pseudonsiella','','aotearoa','','','',NULL,'','','','','','Hicks','','','','1988','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c88e758-afb1-4969-aff0-f29c07d09daa','','','Fuscopannaria granulans P.M.Jørg.',1,'Fuscopannaria granulans','Fuscopannaria granulans','Fuscopannaria granulans',2,0,'','','P. M. Jørg.','4a8d4542-da04-5d58-b341-ca31dceb23e3','Fuscopannaria granulans P.M.Jørg.','P.M.Jørg.','SPECIES','','Fuscopannaria','','granulans','','','',NULL,'','','','','','P. M. Jørg.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d753284-c372-406b-8af8-760cb3475c9e','','','Weissia starckeana Hedw.',1,'Weissia starckeana','Weissia starckeana','Weissia starckean',2,0,'','','Hedw.','ff537871-a87d-5158-8b09-dd6aa38728d6','Weissia starckeana Hedw.','Hedw.','SPECIES','','Weissia','','starckeana','','','',NULL,'','','','','','Hedw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c900342-7646-4c70-bf75-a2da389702f0','','','Jasus',1,'Jasus','Jasus','Jasus',1,0,'','','','5dd3d431-2725-5f3e-b83e-c645ec8e0d2a','Jasus','','GENUS','Jasus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0c95abbe-8a38-4fb6-a40c-a5c00216be16','','','Pseudomonas fragi (Eichholz 1902) Gruber 1905',1,'Pseudomonas fragi','Pseudomonas fragi','Pseudomonas frag',2,0,'','','Eichholz|Gruber','3ff6971a-0e40-5220-b2d4-adbcb42b85ad','Pseudomonas fragi (Eichholz 1902) Gruber 1905','(Eichholz 1902) Gruber 1905','SPECIES','','Pseudomonas','','fragi','','','',NULL,'Gruber','','','','1905','Eichholz','','','','1902','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d761b30-47fd-4c01-97e5-feddaa39809d','','','Rosellinia pumila Lettau',1,'Rosellinia pumila','Rosellinia pumila','Rosellinia pumil',2,0,'','','Lettau','820a970d-8e99-507d-965f-7476d545906e','Rosellinia pumila Lettau','Lettau','SPECIES','','Rosellinia','','pumila','','','',NULL,'','','','','','Lettau','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d78a951-d363-4154-8e39-890fa46f166d','','','Entosthodon bonplandii (Hook.) Mitt.',1,'Entosthodon bonplandii','Entosthodon bonplandii','Entosthodon bonpland',2,0,'','','Hook.|Mitt.','b36e1a23-ecf1-5481-ba8c-4af608cb3923','Entosthodon bonplandii (Hook.) Mitt.','(Hook.) Mitt.','SPECIES','','Entosthodon','','bonplandii','','','',NULL,'Mitt.','','','','','Hook.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d762bd2-8b2d-4703-9abe-c185f0c4a573','','','Lugensa Mathews',1,'Lugensa','Lugensa','Lugensa',1,0,'','','Mathews','fa1882f4-a5a6-5adc-9b9b-a6e9668036df','Lugensa Mathews','Mathews','GENUS','Lugensa','','','','','','',NULL,'','','','','','Mathews','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d827b2a-768d-42d1-a5e3-131b4ce3ae67','','','Rosellinia mammiformis sensu (Pers.) Ces. & De Not.',4,'','','',NULL,NULL,'','','','','Rosellinia mammiformis sensu (Pers.) Ces. & De Not.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d8099f1-93c9-48a3-99db-6e785e8cf39f','','','Vanda R.Br.',1,'Vanda','Vanda','Vanda',1,0,'','','R. Br.','9d63d132-a970-554f-9168-c463feb0b9e4','Vanda R.Br.','R.Br.','GENUS','Vanda','','','','','','',NULL,'','','','','','R. Br.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d7f657f-99ff-4a2c-805b-8d6fda8bb06c','','','Notodanthonia racemosa (R.Br.) Zotov',1,'Notodanthonia racemosa','Notodanthonia racemosa','Notodanthonia racemos',2,0,'','','R. Br.|Zotov','14b40aee-79c7-5b61-925e-220c12e2338c','Notodanthonia racemosa (R.Br.) Zotov','(R.Br.) Zotov','SPECIES','','Notodanthonia','','racemosa','','','',NULL,'Zotov','','','','','R. Br.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d841ec7-3d92-4909-a994-cf9779d14f5a','','','Agaricus perforans Hoffm.',1,'Agaricus perforans','Agaricus perforans','Agaricus perforans',2,0,'','','Hoffm.','16cb80cf-fea9-5428-bbc8-c5e8ea75e2a3','Agaricus perforans Hoffm.','Hoffm.','SPECIES','','Agaricus','','perforans','','','',NULL,'','','','','','Hoffm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d877f34-9d2c-4b16-84b6-2a191c087d0d','','','Fusarium phaseoli (Burkh.) T. Aoki & O''Donnell',1,'Fusarium phaseoli','Fusarium phaseoli','Fusarium phaseol',2,0,'','','Burkh.|T. Aoki|O''Donnell','ae6502ec-f362-5a8e-92cd-803f7629c013','Fusarium phaseoli (Burkh.) T. Aoki & O''Donnell','(Burkh.) T. Aoki & O''Donnell','SPECIES','','Fusarium','','phaseoli','','','',NULL,'T. Aoki & O''Donnell','','','','','Burkh.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d876377-1ac1-4920-a56c-dd6fb266ee2c','','','Carex confusa Hamlin',1,'Carex confusa','Carex confusa','Carex confus',2,0,'','','Hamlin','3a3f6a25-0025-5e25-a8d2-535adcf70ce2','Carex confusa Hamlin','Hamlin','SPECIES','','Carex','','confusa','','','',NULL,'','','','','','Hamlin','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d9572ea-126e-4bb6-b2cb-131742487c86','','','Ceratomyxa nitida Meglitsch, 1960',1,'Ceratomyxa nitida','Ceratomyxa nitida','Ceratomyxa nitid',2,0,'','','Meglitsch','bb6d033b-bdcc-5099-ad89-8d155c72c289','Ceratomyxa nitida Meglitsch, 1960','Meglitsch, 1960','SPECIES','','Ceratomyxa','','nitida','','','',NULL,'','','','','','Meglitsch','','','','1960','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d954759-5db9-4fb7-a30a-79d57c919814','','','Pinnulariaceae',1,'Pinnulariaceae','Pinnulariaceae','Pinnulariaceae',1,0,'','','','4c6e8c76-ca80-556d-bfdc-8dcddd88b562','Pinnulariaceae','','FAMILY','Pinnulariaceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d97721d-158a-4a1f-8af8-81a4556f1a63','','','Polymastia species 3 Kelly & Wilkinson, 2000',4,'','','',NULL,NULL,'','','','','Polymastia species 3 Kelly & Wilkinson, 2000','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d90fc38-4b8c-4814-ab65-9ea0c4ef2df0','','','Lepidosira purpurea',1,'Lepidosira purpurea','Lepidosira purpurea','Lepidosira purpure',2,0,'','','','0591a5cd-761c-56e5-9a22-5170f3226801','Lepidosira purpurea','','SPECIES','','Lepidosira','','purpurea','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d9597bb-eac2-45d0-810e-cf198ded5019','','','Dacrycarpus imbricatus (Blume) de Laub.',1,'Dacrycarpus imbricatus','Dacrycarpus imbricatus','Dacrycarpus imbricat',2,0,'','','Blume|de Laub.','7bb71f0f-8dfa-5218-b1b4-702e1dd3faa7','Dacrycarpus imbricatus (Blume) de Laub.','(Blume) de Laub.','SPECIES','','Dacrycarpus','','imbricatus','','','',NULL,'de Laub.','','','','','Blume','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d9b9784-0dd2-4d5d-b26f-25e9538b343e','','','Teratosphaeria suberosa (Crous, F.A. Ferreira, Alfenas & M.J. Wingf.) Crous & U. Braun',1,'Teratosphaeria suberosa','Teratosphaeria suberosa','Teratosphaeria suberos',2,0,'','','Crous|F. A. Ferreira|Alfenas|M. J. Wingf.|U. Braun','501ecc6e-d792-5c21-a5f4-49af48aa7159','Teratosphaeria suberosa (Crous, F.A. Ferreira, Alfenas & M.J. Wingf.) Crous & U. Braun','(Crous, F.A. Ferreira, Alfenas & M.J. Wingf.) Crous & U. Braun','SPECIES','','Teratosphaeria','','suberosa','','','',NULL,'Crous & U. Braun','','','','','Crous, F. A. Ferreira, Alfenas & M. J. Wingf.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d9eb50c-a5ac-47c8-9144-9f516b6d877b','','','Polyedriopsis spinulosa Schmidle',1,'Polyedriopsis spinulosa','Polyedriopsis spinulosa','Polyedriopsis spinulos',2,0,'','','Schmidle','f92b004f-acf8-5d3d-929b-920f290f304f','Polyedriopsis spinulosa Schmidle','Schmidle','SPECIES','','Polyedriopsis','','spinulosa','','','',NULL,'','','','','','Schmidle','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0da88092-bb08-4488-b9cb-08fa10d45fcf','','','Jamesoniella kirkii Steph.',1,'Jamesoniella kirkii','Jamesoniella kirkii','Jamesoniella kirk',2,0,'','','Steph.','3fe174ec-5fda-59b5-8cf8-32ab749773f8','Jamesoniella kirkii Steph.','Steph.','SPECIES','','Jamesoniella','','kirkii','','','',NULL,'','','','','','Steph.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0da6a731-f8cc-4334-a28c-12470ec99e30','','','Entoloma parsonsiae G. Stev.',1,'Entoloma parsonsiae','Entoloma parsonsiae','Entoloma parsonsi',2,0,'','','G. Stev.','b5bb17fb-e64b-596e-9198-56bb7cfa8802','Entoloma parsonsiae G. Stev.','G. Stev.','SPECIES','','Entoloma','','parsonsiae','','','',NULL,'','','','','','G. Stev.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0da8a565-2087-4564-936c-8f7318f0ae4d','','','Ellisembia brachypus (Ellis & Everh.) Subram.',1,'Ellisembia brachypus','Ellisembia brachypus','Ellisembia brachyp',2,0,'','','Ellis|Everh.|Subram.','5ebee1d1-dce6-5522-b6ab-c2b5d262f9b0','Ellisembia brachypus (Ellis & Everh.) Subram.','(Ellis & Everh.) Subram.','SPECIES','','Ellisembia','','brachypus','','','',NULL,'Subram.','','','','','Ellis & Everh.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0da53343-62bf-476b-b530-d9970ec25b54','','','Phaeomycena fusca G. Stev. & G.M. Taylor',1,'Phaeomycena fusca','Phaeomycena fusca','Phaeomycena fusc',2,0,'','','G. Stev.|G. M. Taylor','6b8a5e77-0992-5197-99c1-a1c65c8515ab','Phaeomycena fusca G. Stev. & G.M. Taylor','G. Stev. & G.M. Taylor','SPECIES','','Phaeomycena','','fusca','','','',NULL,'','','','','','G. Stev. & G. M. Taylor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0db62ba0-71bb-45e7-a127-9d819d836ce6','','','Ramularia heraclei (Oudem.) Sacc.',1,'Ramularia heraclei','Ramularia heraclei','Ramularia heracle',2,0,'','','Oudem.|Sacc.','9de2c61c-59c6-5dc6-bf36-68b745e7ab0b','Ramularia heraclei (Oudem.) Sacc.','(Oudem.) Sacc.','SPECIES','','Ramularia','','heraclei','','','',NULL,'Sacc.','','','','','Oudem.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dafbbad-a8e8-454f-9ee4-c894624939f9','','','Viegasia Bat.',1,'Viegasia','Viegasia','Viegasia',1,0,'','','Bat.','711e7511-4603-5d2b-aa8e-0b21e0977e82','Viegasia Bat.','Bat.','GENUS','Viegasia','','','','','','',NULL,'','','','','','Bat.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0db19c28-a600-4033-97a8-cb10d9135b4b','','','Aposphaeria Sacc.',1,'Aposphaeria','Aposphaeria','Aposphaeria',1,0,'','','Sacc.','7345a083-8319-5b47-85dd-ee4e46bf4e46','Aposphaeria Sacc.','Sacc.','GENUS','Aposphaeria','','','','','','',NULL,'','','','','','Sacc.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0db06dd2-d423-4aeb-80cf-fdc96205a0f6','','','Tortilispora Senan. & K.D. Hyde',1,'Tortilispora','Tortilispora','Tortilispora',1,0,'','','Senan.|K. D. Hyde','74e53117-f22e-5c20-8f19-ffbbce988d59','Tortilispora Senan. & K.D. Hyde','Senan. & K.D. Hyde','GENUS','Tortilispora','','','','','','',NULL,'','','','','','Senan. & K. D. Hyde','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dbca188-f8f6-401d-b2b3-7e6ca3bb3f96','','','Pseudocoremia rudisata rudisata (Walker, 1862)',1,'Pseudocoremia rudisata rudisata','Pseudocoremia rudisata rudisata','Pseudocoremia rudisat rudisat',3,0,'','','Walker','487bb8ab-55bc-5034-b1dc-773f3face888','Pseudocoremia rudisata rudisata (Walker, 1862)','(Walker, 1862)','SUBSPECIES','','Pseudocoremia','','rudisata','rudisata','','',NULL,'','','','','','Walker','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dbe7b46-2297-48b8-8a8d-88feab3a23a3','','','Litschauerella gladiola (G. Cunn.) Stalpers & P.K. Buchanan',1,'Litschauerella gladiola','Litschauerella gladiola','Litschauerella gladiol',2,0,'','','G. Cunn.|Stalpers|P. K. Buchanan','72326206-95b4-5cc9-891a-345be8bf49b5','Litschauerella gladiola (G. Cunn.) Stalpers & P.K. Buchanan','(G. Cunn.) Stalpers & P.K. Buchanan','SPECIES','','Litschauerella','','gladiola','','','',NULL,'Stalpers & P. K. Buchanan','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0db9134d-5a14-4dfd-a34f-b776a904ccf7','','','Staurastrum smithii Teiling',1,'Staurastrum smithii','Staurastrum smithii','Staurastrum smith',2,0,'','','Teiling','e68615b4-d21b-521f-b6ec-c841b4b32858','Staurastrum smithii Teiling','Teiling','SPECIES','','Staurastrum','','smithii','','','',NULL,'','','','','','Teiling','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dc19007-d08e-4fd7-aef6-0a355b36dfaf','','','Pseudochaete olivacea (Schwein.) Parmasto',1,'Pseudochaete olivacea','Pseudochaete olivacea','Pseudochaete oliuace',2,0,'','','Schwein.|Parmasto','278831b2-e19d-5039-95c4-b9760f36d4b6','Pseudochaete olivacea (Schwein.) Parmasto','(Schwein.) Parmasto','SPECIES','','Pseudochaete','','olivacea','','','',NULL,'Parmasto','','','','','Schwein.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dc18df7-c22a-4487-a2fb-7d5c43e6d527','','','Baggina philippinensis Loeblich & Tappan, 1994',1,'Baggina philippinensis','Baggina philippinensis','Baggina philippinens',2,0,'','','Loeblich|Tappan','b03d1610-8721-59ff-839a-1d893d5a769c','Baggina philippinensis Loeblich & Tappan, 1994','Loeblich & Tappan, 1994','SPECIES','','Baggina','','philippinensis','','','',NULL,'','','','','','Loeblich & Tappan','','','','1994','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dc4900e-bbdb-4a71-a302-ff3fc8d1e47f','','','Andromeda formosa Wall',1,'Andromeda formosa','Andromeda formosa','Andromeda formos',2,0,'','','Wall','fb9e143d-b943-5479-82f8-e5f597ec17cc','Andromeda formosa Wall','Wall','SPECIES','','Andromeda','','formosa','','','',NULL,'','','','','','Wall','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dc988ca-7d5a-4f66-a34e-4b4399dac0c2','','','Bostrichoidea',1,'Bostrichoidea','Bostrichoidea','Bostrichoidea',1,0,'','','','bf413998-00b1-5706-af73-53bd04b26fca','Bostrichoidea','','SUPERFAMILY','Bostrichoidea','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b78a855-40ab-4eb6-ba40-69623272bac4','','','Genista linifolia L.',1,'Genista linifolia','Genista linifolia','Genista linifol',2,0,'','','L.','36664ae1-5927-5826-b5c7-ce2e321a6acd','Genista linifolia L.','L.','SPECIES','','Genista','','linifolia','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dca74d2-922d-41a6-bbad-8556e4a76519','','','Alboleptonia minutoalba (E. Horak) T.J. Baroni & Lodge',1,'Alboleptonia minutoalba','Alboleptonia minutoalba','Alboleptonia minutoalb',2,0,'','','E. Horak|T. J. Baroni|Lodge','3ea60df7-a124-5483-8117-9bb64e367938','Alboleptonia minutoalba (E. Horak) T.J. Baroni & Lodge','(E. Horak) T.J. Baroni & Lodge','SPECIES','','Alboleptonia','','minutoalba','','','',NULL,'T. J. Baroni & Lodge','','','','','E. Horak','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b79c72b-3d9f-4a2b-b448-1227f62f85b7','','','Leptinella drummondii (Benth.) D.G. Lloyd & C.J.Webb',1,'Leptinella drummondii','Leptinella drummondii','Leptinella drummond',2,0,'','','Benth.|D. G. Lloyd|C. J. Webb','55affaa2-0ee5-588b-842c-7d47cf2401ce','Leptinella drummondii (Benth.) D.G. Lloyd & C.J.Webb','(Benth.) D.G. Lloyd & C.J.Webb','SPECIES','','Leptinella','','drummondii','','','',NULL,'D. G. Lloyd & C. J. Webb','','','','','Benth.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b7cffe2-9a64-4e73-a76c-9f260878c034','','','Phlebia ludoviciana (Burt) Nakasone & Burds.',1,'Phlebia ludoviciana','Phlebia ludoviciana','Phlebia ludouician',2,0,'','','Burt|Nakasone|Burds.','857160d6-bbd4-5faa-b90e-bd81bcd6a4a4','Phlebia ludoviciana (Burt) Nakasone & Burds.','(Burt) Nakasone & Burds.','SPECIES','','Phlebia','','ludoviciana','','','',NULL,'Nakasone & Burds.','','','','','Burt','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b7931c4-e78e-4c1a-b57b-d0ffe9e7b8c1','','','Aciculites manawatawhi Kelly, 2007',1,'Aciculites manawatawhi','Aciculites manawatawhi','Aciculites manawatawh',2,0,'','','Kelly','c482fe8e-edfa-57fd-a325-08abac8507c2','Aciculites manawatawhi Kelly, 2007','Kelly, 2007','SPECIES','','Aciculites','','manawatawhi','','','',NULL,'','','','','','Kelly','','','','2007','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b7f4c76-59b8-4096-b6cf-3baf14b3a856','','','Verum',1,'Verum','Verum','Verum',1,0,'','','','db710cc9-2458-570d-a27d-3acd1bedbd9f','Verum','','GENUS','Verum','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b81ae83-666c-4079-b02a-699030f79a8b','','','Sparrmannia L.f.',1,'Sparrmannia','Sparrmannia','Sparrmannia',1,0,'','','L. fil.','85b02bdc-157d-50db-8c26-698913a7cece','Sparrmannia L.f.','L.f.','GENUS','Sparrmannia','','','','','','',NULL,'','','','','','L. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b7d9f05-0faa-44de-8413-8604b57cadec','','','Puccinia dolosa var. circumdata (Mains) Ramachar & Cummins',1,'Puccinia dolosa circumdata','Puccinia dolosa var. circumdata','Puccinia dolos circumdat',3,0,'','','Mains|Ramachar|Cummins','37eecc48-5fef-5e80-8ad6-ded1eb516657','Puccinia dolosa var. circumdata (Mains) Ramachar & Cummins','(Mains) Ramachar & Cummins','VARIETY','','Puccinia','','dolosa','circumdata','','',NULL,'Ramachar & Cummins','','','','','Mains','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b822621-0aa7-4f63-becf-b207f5097481','','','Macrophthalmidae',1,'Macrophthalmidae','Macrophthalmidae','Macrophthalmidae',1,0,'','','','54229076-600b-5008-9869-9c945020d93d','Macrophthalmidae','','FAMILY','Macrophthalmidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b83f4f6-35e4-4131-b6f2-e65ad954ebdb','','','Psilotum heterocarpum Colenso',1,'Psilotum heterocarpum','Psilotum heterocarpum','Psilotum heterocarp',2,0,'','','Colenso','75c4b3ef-a1d4-5fb1-851b-a000eddbb44f','Psilotum heterocarpum Colenso','Colenso','SPECIES','','Psilotum','','heterocarpum','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b84ba57-f7d8-47e2-bea6-3bc6e5c33e9f','','','Telenominae',1,'Telenominae','Telenominae','Telenominae',1,0,'','','','3f398986-61f4-5350-8c56-d08d064f03a8','Telenominae','','SUBFAMILY','Telenominae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b84d02a-2552-40cf-a1f4-4047a9a163f5','','','Myxobolus',1,'Myxobolus','Myxobolus','Myxobolus',1,0,'','','','8660e702-d7dc-5523-9dd7-27b1f8ff9ac0','Myxobolus','','GENUS','Myxobolus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b8a1984-5ac1-4635-814b-5c3a32d7d21b','','','Cromyechinus',1,'Cromyechinus','Cromyechinus','Cromyechinus',1,0,'','','','759a43c0-1174-50f5-a889-99634542c3aa','Cromyechinus','','GENUS','Cromyechinus','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b89ad7b-0ddb-4d48-bc87-63e317bf4434','','','Delphinium L.',1,'Delphinium','Delphinium','Delphinium',1,0,'','','L.','c610f834-c256-54dd-abc6-12c12f735d4a','Delphinium L.','L.','GENUS','Delphinium','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b8977db-4a5e-4035-a80f-89c8d8bdcea2','','','Symplectoscyphus subdichotomus (Kirchenpauer, 1884)',1,'Symplectoscyphus subdichotomus','Symplectoscyphus subdichotomus','Symplectoscyphus subdichotom',2,0,'','','Kirchenpauer','a4a53d14-e040-55ed-949b-84f1c89e47ed','Symplectoscyphus subdichotomus (Kirchenpauer, 1884)','(Kirchenpauer, 1884)','SPECIES','','Symplectoscyphus','','subdichotomus','','','',NULL,'','','','','','Kirchenpauer','','','','1884','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b850265-3764-464f-acd2-b802f5ecd469','','','Rhytisma itatiaiae Rehm',1,'Rhytisma itatiaiae','Rhytisma itatiaiae','Rhytisma itatiai',2,0,'','','Rehm','3d0d2ee9-440c-52cd-b5ad-72a8366fdb9a','Rhytisma itatiaiae Rehm','Rehm','SPECIES','','Rhytisma','','itatiaiae','','','',NULL,'','','','','','Rehm','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b8feda3-58fb-49a2-b822-67c046d36b7f','','','Carex breviculmis R.Br.',1,'Carex breviculmis','Carex breviculmis','Carex breuiculm',2,0,'','','R. Br.','2b5c68b3-8ac3-510d-9108-7dc12b5a5fb4','Carex breviculmis R.Br.','R.Br.','SPECIES','','Carex','','breviculmis','','','',NULL,'','','','','','R. Br.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b912045-ded3-47ce-9da5-807925fcb59a','','','Lecanactis tibelliana Egea & Torrente',1,'Lecanactis tibelliana','Lecanactis tibelliana','Lecanactis tibellian',2,0,'','','Egea|Torrente','a31efc47-5a9f-5fa2-8908-e8ff9f130644','Lecanactis tibelliana Egea & Torrente','Egea & Torrente','SPECIES','','Lecanactis','','tibelliana','','','',NULL,'','','','','','Egea & Torrente','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b8eda74-7540-435e-a822-b9fb3881c60e','','','Drepanolejeunea vesiculosa (Mitt.) Steph.',1,'Drepanolejeunea vesiculosa','Drepanolejeunea vesiculosa','Drepanolejeunea uesiculos',2,0,'','','Mitt.|Steph.','51aa6a60-f79a-515f-b472-f5a372f915ce','Drepanolejeunea vesiculosa (Mitt.) Steph.','(Mitt.) Steph.','SPECIES','','Drepanolejeunea','','vesiculosa','','','',NULL,'Steph.','','','','','Mitt.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b9b60e6-a004-4fce-8383-33cdc775c905','','','Nitzschia circumsuta (Bailey) Grunow',1,'Nitzschia circumsuta','Nitzschia circumsuta','Nitzschia circumsut',2,0,'','','Bailey|Grunow','7c0cde05-9380-5a93-8c96-c333e9f63692','Nitzschia circumsuta (Bailey) Grunow','(Bailey) Grunow','SPECIES','','Nitzschia','','circumsuta','','','',NULL,'Grunow','','','','','Bailey','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b9cb06a-738d-43d1-a0f3-57a13b3764e8','','','Saycia cooki',1,'Saycia cooki','Saycia cooki','Saycia cook',2,0,'','','','3c0f48f7-e157-5ac4-a032-4c3cb8be0b6e','Saycia cooki','','SPECIES','','Saycia','','cooki','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b95a1eb-ae05-49d5-9e8b-65aa34d09a32','','','Tymbopiptus',1,'Tymbopiptus','Tymbopiptus','Tymbopiptus',1,0,'','','','61af285b-6c1c-57c1-9cd1-fb3e2fe4ee68','Tymbopiptus','','GENUS','Tymbopiptus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b9b8e0e-10e2-413c-9f85-82a887dc69c8','','','Ogma alternum Wouts, 2006',1,'Ogma alternum','Ogma alternum','Ogma altern',2,0,'','','Wouts','515e40f2-5bc5-593b-91f8-fba96b5de03d','Ogma alternum Wouts, 2006','Wouts, 2006','SPECIES','','Ogma','','alternum','','','',NULL,'','','','','','Wouts','','','','2006','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ba44514-6672-42f1-bcba-2fc0c65aad38','','','Sphaerotheca volkartii S. Blumer',1,'Sphaerotheca volkartii','Sphaerotheca volkartii','Sphaerotheca uolkart',2,0,'','','S. Blumer','33a3f166-2ee0-5efc-bf7b-f8dd5554c54e','Sphaerotheca volkartii S. Blumer','S. Blumer','SPECIES','','Sphaerotheca','','volkartii','','','',NULL,'','','','','','S. Blumer','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b9ee25b-cac4-421e-b8b1-5eeae3b4d328','','','Puccinia huteri Syd. & P. Syd.',1,'Puccinia huteri','Puccinia huteri','Puccinia huter',2,0,'','','Syd.|P. Syd.','bd63852a-028a-5b1c-82af-5985ba6b88d1','Puccinia huteri Syd. & P. Syd.','Syd. & P. Syd.','SPECIES','','Puccinia','','huteri','','','',NULL,'','','','','','Syd. & P. Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ba13fd9-c4b3-41d3-8f7b-c5070f08cd2a','','','Papilio dialis (Leech, 1893)',1,'Papilio dialis','Papilio dialis','Papilio dial',2,0,'','','Leech','a9b54177-248c-59c7-b899-6619379eae06','Papilio dialis (Leech, 1893)','(Leech, 1893)','SPECIES','','Papilio','','dialis','','','',NULL,'','','','','','Leech','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ba8ceea-8543-4a1f-a3f5-6168b9984fd8','','','Schistochila pellucida R.M.Schust. & J.J.Engel',1,'Schistochila pellucida','Schistochila pellucida','Schistochila pellucid',2,0,'','','R. M. Schust.|J. J. Engel','0ed7a67e-3f79-5dbe-9eed-09da8ed1b1f0','Schistochila pellucida R.M.Schust. & J.J.Engel','R.M.Schust. & J.J.Engel','SPECIES','','Schistochila','','pellucida','','','',NULL,'','','','','','R. M. Schust. & J. J. Engel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ba5b971-c488-4b0d-bf9b-aee8194e9170','','','Arctomia Th.Fr.',1,'Arctomia','Arctomia','Arctomia',1,0,'','','Th. Fr.','fe775683-cecd-5ea3-9e50-6ab3327402f3','Arctomia Th.Fr.','Th.Fr.','GENUS','Arctomia','','','','','','',NULL,'','','','','','Th. Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ba6af88-49b2-44b7-842b-bcf5a6f17834','','','Acaraptera Usinger & Matsuda, 1959',1,'Acaraptera','Acaraptera','Acaraptera',1,0,'','','Usinger|Matsuda','e7027e1c-1c16-5fca-b153-3a4b2fb0b74d','Acaraptera Usinger & Matsuda, 1959','Usinger & Matsuda, 1959','GENUS','Acaraptera','','','','','','',NULL,'','','','','','Usinger & Matsuda','','','','1959','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bab5b5c-0aac-4ae2-8e5a-1a67fd945afa','','','Naineris laevigata (Grube, 1855)',1,'Naineris laevigata','Naineris laevigata','Naineris laeuigat',2,0,'','','Grube','8ae15382-7d0d-5da2-b183-b863608c7cf0','Naineris laevigata (Grube, 1855)','(Grube, 1855)','SPECIES','','Naineris','','laevigata','','','',NULL,'','','','','','Grube','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bab4810-477e-472c-a2b8-663f4357dafe','','','Leptopius robustus Olivier, 1807',1,'Leptopius robustus','Leptopius robustus','Leptopius robust',2,0,'','','Olivier','f3d5c3ff-105a-51da-a0a9-0d7e63310e6d','Leptopius robustus Olivier, 1807','Olivier, 1807','SPECIES','','Leptopius','','robustus','','','',NULL,'','','','','','Olivier','','','','1807','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bb5d254-c9e0-4824-8d23-20c3d2012676','','','Anthurium lilacinum G.S.Bunting',1,'Anthurium lilacinum','Anthurium lilacinum','Anthurium lilacin',2,0,'','','G. S. Bunting','3e61f086-9ad5-520d-aba0-e162d2197761','Anthurium lilacinum G.S.Bunting','G.S.Bunting','SPECIES','','Anthurium','','lilacinum','','','',NULL,'','','','','','G. S. Bunting','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bb061a6-e65d-4f8c-bb9f-50f15c3e653c','','','Grevillea acanthifolia A.Cunn',1,'Grevillea acanthifolia','Grevillea acanthifolia','Grevillea acanthifol',2,0,'','','A. Cunn','e5d6dc87-d04a-5f87-aec5-3165f3cd966f','Grevillea acanthifolia A.Cunn','A.Cunn','SPECIES','','Grevillea','','acanthifolia','','','',NULL,'','','','','','A. Cunn','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0baf80a5-1909-4116-9f73-8459209c157d','','','Pachnocybe clavulata Grove',1,'Pachnocybe clavulata','Pachnocybe clavulata','Pachnocybe clauulat',2,0,'','','Grove','baf806ae-0096-5ea9-8a86-8ab546f5cac9','Pachnocybe clavulata Grove','Grove','SPECIES','','Pachnocybe','','clavulata','','','',NULL,'','','','','','Grove','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bb0fec9-eba1-40a9-92d7-ca108bdeb4f3','','','Hybomyia oliveri Plant, 1995',1,'Hybomyia oliveri','Hybomyia oliveri','Hybomyia oliuer',2,0,'','','Plant','893689c0-3580-5b65-8920-bb2685d9cc2f','Hybomyia oliveri Plant, 1995','Plant, 1995','SPECIES','','Hybomyia','','oliveri','','','',NULL,'','','','','','Plant','','','','1995','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bb3b347-8b72-406c-9da2-fce59a91306f','','','Mesocyphon longicornis Broun, 1914',1,'Mesocyphon longicornis','Mesocyphon longicornis','Mesocyphon longicorn',2,0,'','','Broun','7319a1e8-7018-5290-82f7-d4c350837805','Mesocyphon longicornis Broun, 1914','Broun, 1914','SPECIES','','Mesocyphon','','longicornis','','','',NULL,'','','','','','Broun','','','','1914','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bbae7b5-c796-4bfc-9567-3472a20091e8','','','Laccaria laccata sensu auct. NZ',4,'','','',NULL,NULL,'','','','','Laccaria laccata sensu auct. NZ','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bb8524e-4936-4b24-9cef-5f0d3cdf8aab','','','Campylopus incrassatus Müll.Hal.',1,'Campylopus incrassatus','Campylopus incrassatus','Campylopus incrassat',2,0,'','','Müll. Hal.','e48e9afc-8e95-5088-a8f5-51508526fe5a','Campylopus incrassatus Müll.Hal.','Müll.Hal.','SPECIES','','Campylopus','','incrassatus','','','',NULL,'','','','','','Müll. Hal.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ce48510-ccae-40ca-9ad2-9929417fa7a6','','','Caloplaca irrubescens (Nyl.) Zahlbr.',1,'Caloplaca irrubescens','Caloplaca irrubescens','Caloplaca irrubescens',2,0,'','','Nyl.|Zahlbr.','50b78c24-cd37-59a0-a8bb-94bc574f0b6b','Caloplaca irrubescens (Nyl.) Zahlbr.','(Nyl.) Zahlbr.','SPECIES','','Caloplaca','','irrubescens','','','',NULL,'Zahlbr.','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0bb7e4d6-accd-4063-bb80-bec01632c8b3','','','Senecio rotundifolius (J.R.Forst. & G.Forst.) Hook.f.',1,'Senecio rotundifolius','Senecio rotundifolius','Senecio rotundifol',2,0,'','','J. R. Forst.|G. Forst.|Hook. fil.','685db1e2-e446-5c9b-9a67-89790ef5bd5d','Senecio rotundifolius (J.R.Forst. & G.Forst.) Hook.f.','(J.R.Forst. & G.Forst.) Hook.f.','SPECIES','','Senecio','','rotundifolius','','','',NULL,'Hook. fil.','','','','','J. R. Forst. & G. Forst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ce74f66-139d-4409-9174-0ca475d569d5','','','Scytomonadaceae',1,'Scytomonadaceae','Scytomonadaceae','Scytomonadaceae',1,0,'','','','77fde502-bb19-5a37-9f4d-731823827233','Scytomonadaceae','','FAMILY','Scytomonadaceae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ce95593-06e1-4c5e-8427-233ba03cdbe7','','','Protohyale grenfelli Chilton, 1916',1,'Protohyale grenfelli','Protohyale grenfelli','Protohyale grenfell',2,0,'','','Chilton','d79d39cf-e6ee-50a9-9a68-504a96f84bf6','Protohyale grenfelli Chilton, 1916','Chilton, 1916','SPECIES','','Protohyale','','grenfelli','','','',NULL,'','','','','','Chilton','','','','1916','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cec2dd4-c441-40d9-83d6-7699bdcf854e','','','Ceuthosira aesculicarpa Petr.',1,'Ceuthosira aesculicarpa','Ceuthosira aesculicarpa','Ceuthosira aesculicarp',2,0,'','','Petr.','beba7fe5-4923-580a-b7d0-49450d3b6fff','Ceuthosira aesculicarpa Petr.','Petr.','SPECIES','','Ceuthosira','','aesculicarpa','','','',NULL,'','','','','','Petr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ce93492-4fdf-4983-bc8a-c7c1e33eaa80','','','Salix atrocinerea ''Tricolor''',1,'Salix atrocinerea ‘Tricolor’','Salix atrocinerea ‘Tricolor’','Salix atrocinere ‘Tricolor’',3,0,'','','','068a4ab3-f086-5262-ab23-1b801d78d6f6','Salix atrocinerea ''Tricolor''','','CULTIVAR','','Salix','','atrocinerea','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cebcc09-81c8-4fcf-a530-fd1fbb318c9e','','','Chaperiopsis multifida (Busk, 1884)',1,'Chaperiopsis multifida','Chaperiopsis multifida','Chaperiopsis multifid',2,0,'','','Busk','44cc082d-a600-5532-aeb2-79bfc25363c1','Chaperiopsis multifida (Busk, 1884)','(Busk, 1884)','SPECIES','','Chaperiopsis','','multifida','','','',NULL,'','','','','','Busk','','','','1884','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cf1d141-71d8-494c-9d8a-70c506616d4a','','','Anthyllis vulneraria L.',1,'Anthyllis vulneraria','Anthyllis vulneraria','Anthyllis uulnerar',2,0,'','','L.','5b133769-e495-54aa-97d9-e04680c27883','Anthyllis vulneraria L.','L.','SPECIES','','Anthyllis','','vulneraria','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ced792b-1429-4c33-a3d4-819e2f4c31d4','','','Paracatops relatus (Broun, 1893)',1,'Paracatops relatus','Paracatops relatus','Paracatops relat',2,0,'','','Broun','1033172c-a986-519d-90e3-32654a7548a0','Paracatops relatus (Broun, 1893)','(Broun, 1893)','SPECIES','','Paracatops','','relatus','','','',NULL,'','','','','','Broun','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cf2fdfb-3a41-476b-a2ed-c224ba7ff179','','','Anillus pallidus Broun, 1884',1,'Anillus pallidus','Anillus pallidus','Anillus pallid',2,0,'','','Broun','ab904a66-4271-595a-a7df-4bca05a4062f','Anillus pallidus Broun, 1884','Broun, 1884','SPECIES','','Anillus','','pallidus','','','',NULL,'','','','','','Broun','','','','1884','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cf1c7c9-3e82-4a87-86dc-dd9fbb9f4990','','','Stilbospora angustata Pers.',1,'Stilbospora angustata','Stilbospora angustata','Stilbospora angustat',2,0,'','','Pers.','23830084-e8c8-5146-b04b-bdc62ac9d969','Stilbospora angustata Pers.','Pers.','SPECIES','','Stilbospora','','angustata','','','',NULL,'','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cf378a5-923c-4683-94b1-14b36b6655a4','','','Isachne R.Br.',1,'Isachne','Isachne','Isachne',1,0,'','','R. Br.','a5049de0-e87b-5de5-9d1a-462459fcc38c','Isachne R.Br.','R.Br.','GENUS','Isachne','','','','','','',NULL,'','','','','','R. Br.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cf830ba-2e03-4a10-85c9-27d0e201f0f5','','','Enchytraeus albidus Henle, 1837',1,'Enchytraeus albidus','Enchytraeus albidus','Enchytraeus albid',2,0,'','','Henle','5ee8ba4b-06f2-5f1b-b8eb-3092b0fa3c25','Enchytraeus albidus Henle, 1837','Henle, 1837','SPECIES','','Enchytraeus','','albidus','','','',NULL,'','','','','','Henle','','','','1837','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cf7a99b-c5f2-4bbc-9b9b-4f6e2c5bea56','','','Clupeidae',1,'Clupeidae','Clupeidae','Clupeidae',1,0,'','','','ad779dc4-7413-51be-9580-73b4523c9ebd','Clupeidae','','FAMILY','Clupeidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cf4365b-15ef-4f2b-a0c4-5ab4cd2a1665','','','Chaenotheca ferruginea (Turner ex Sm.) Migula',1,'Chaenotheca ferruginea','Chaenotheca ferruginea','Chaenotheca ferrugine',2,0,'','','Turner|Sm.|Migula','8e756285-3216-52c9-8bc6-7d393e2f5102','Chaenotheca ferruginea (Turner ex Sm.) Migula','(Turner ex Sm.) Migula','SPECIES','','Chaenotheca','','ferruginea','','','',NULL,'Migula','','','','','Turner','','Sm.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cfbad71-72ad-4119-a916-296d893f107d','','','Amphisphaeriales D. Hawksw. & O.E. Erikss.',1,'Amphisphaeriales','Amphisphaeriales','Amphisphaeriales',1,0,'','','D. Hawksw.|O. E. Erikss.','58cc2924-da75-5cdb-aec6-dc7530ade72c','Amphisphaeriales D. Hawksw. & O.E. Erikss.','D. Hawksw. & O.E. Erikss.','ORDER','Amphisphaeriales','','','','','','',NULL,'','','','','','D. Hawksw. & O. E. Erikss.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cffa6d2-9432-4fc5-b1a9-8969176e1225','','','Lobelia carens Heenan',1,'Lobelia carens','Lobelia carens','Lobelia carens',2,0,'','','Heenan','c690478f-6713-51fe-a905-ef77d02c035c','Lobelia carens Heenan','Heenan','SPECIES','','Lobelia','','carens','','','',NULL,'','','','','','Heenan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0cfc318e-6be7-408f-aa31-c745678372a5','','','Coelomomyces psorophorae var. tasmaniensis Couch & Laird',1,'Coelomomyces psorophorae tasmaniensis','Coelomomyces psorophorae var. tasmaniensis','Coelomomyces psorophor tasmaniens',3,0,'','','Couch|Laird','eebcfe17-2d24-56b4-997e-2f07bbe72780','Coelomomyces psorophorae var. tasmaniensis Couch & Laird','Couch & Laird','VARIETY','','Coelomomyces','','psorophorae','tasmaniensis','','',NULL,'','','','','','Couch & Laird','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d02139f-64ea-481d-b99b-1e12e7cf0f30','','','Peziza lanariceps Cooke & W. Phillips',1,'Peziza lanariceps','Peziza lanariceps','Peziza lanariceps',2,0,'','','Cooke|W. Phillips','01994beb-3942-5e46-9fef-815152f58f2d','Peziza lanariceps Cooke & W. Phillips','Cooke & W. Phillips','SPECIES','','Peziza','','lanariceps','','','',NULL,'','','','','','Cooke & W. Phillips','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d0465fd-4990-49ca-8385-cf2a3c819d0c','','','Hamoppia Hammer, 1968',1,'Hamoppia','Hamoppia','Hamoppia',1,0,'','','Hammer','b2985fb4-ece4-5e30-b821-9e098aaa3ec2','Hamoppia Hammer, 1968','Hammer, 1968','GENUS','Hamoppia','','','','','','',NULL,'','','','','','Hammer','','','','1968','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d00a5c1-832a-4431-8a58-ef464a38e03c','','','Myriangiales Starbäck',1,'Myriangiales','Myriangiales','Myriangiales',1,0,'','','Starbäck','4417f8a0-0640-53e0-994c-b270bd62cc73','Myriangiales Starbäck','Starbäck','ORDER','Myriangiales','','','','','','',NULL,'','','','','','Starbäck','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d0b4f80-5793-42a0-ad10-6293d6aaa204','','','Austrarcturella',1,'Austrarcturella','Austrarcturella','Austrarcturella',1,0,'','','','18983bb8-2793-500a-bdd7-2bf6bc9b297c','Austrarcturella','','GENUS','Austrarcturella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d07eee9-2381-40a3-aaf6-734aaa5b28ba','','','Panaeolus campanulatus (L.) Quél.',1,'Panaeolus campanulatus','Panaeolus campanulatus','Panaeolus campanulat',2,0,'','','L.|Quél.','4f8ceaa3-e969-55c9-aed4-8b13a3f66f50','Panaeolus campanulatus (L.) Quél.','(L.) Quél.','SPECIES','','Panaeolus','','campanulatus','','','',NULL,'Quél.','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d0831e1-b50f-43f3-8535-b2e2b73e3ca0','','','Epidapus parvus Mohrig, 1999',1,'Epidapus parvus','Epidapus parvus','Epidapus paru',2,0,'','','Mohrig','5d9163b7-cdba-5fbe-bde7-89b3a972edba','Epidapus parvus Mohrig, 1999','Mohrig, 1999','SPECIES','','Epidapus','','parvus','','','',NULL,'','','','','','Mohrig','','','','1999','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d0db470-8356-4ab7-b680-4391a459d3d7','','','Pelagodroma marina albiclunis Murphy & Irving',1,'Pelagodroma marina albiclunis','Pelagodroma marina albiclunis','Pelagodroma marin albiclun',3,0,'','','Murphy|Irving','e6068a2f-fc0e-54a6-8c4d-f287d584f8ce','Pelagodroma marina albiclunis Murphy & Irving','Murphy & Irving','SUBSPECIES','','Pelagodroma','','marina','albiclunis','','',NULL,'','','','','','Murphy & Irving','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d0e8a30-e9db-4066-a4c7-a27cd06c366c','','','Harpalini',1,'Harpalini','Harpalini','Harpalini',1,0,'','','','5076cb6c-fa65-5af1-b5e8-65d3bfa0b2fa','Harpalini','','TRIBE','Harpalini','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d0d46bf-9069-4fe4-bdd4-b6a92fb9206c','','','Arrhenophagus chionaspidis Aurivillius, 1888',1,'Arrhenophagus chionaspidis','Arrhenophagus chionaspidis','Arrhenophagus chionaspid',2,0,'','','Aurivillius','a1cbd61a-e997-5f9f-bb01-94054f919d19','Arrhenophagus chionaspidis Aurivillius, 1888','Aurivillius, 1888','SPECIES','','Arrhenophagus','','chionaspidis','','','',NULL,'','','','','','Aurivillius','','','','1888','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d14be96-9a44-4b59-8885-069a6ee28634','','','Vaccinium ashei J.M.Reade',1,'Vaccinium ashei','Vaccinium ashei','Vaccinium ashe',2,0,'','','J. M. Reade','07014dde-90a9-54d1-8232-499bc0c871d2','Vaccinium ashei J.M.Reade','J.M.Reade','SPECIES','','Vaccinium','','ashei','','','',NULL,'','','','','','J. M. Reade','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d19fd7e-5d18-451a-9f34-756a9b1c4796','','','Chiloscyphus suboppositus J.J.Engel',1,'Chiloscyphus suboppositus','Chiloscyphus suboppositus','Chiloscyphus subopposit',2,0,'','','J. J. Engel','6c04a8b0-874b-5284-a2dc-4c6fa2f4622b','Chiloscyphus suboppositus J.J.Engel','J.J.Engel','SPECIES','','Chiloscyphus','','suboppositus','','','',NULL,'','','','','','J. J. Engel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d17e274-42be-40ed-aad8-e40ccb4911ff','','','Veronatus capito Broun, 1880',1,'Veronatus capito','Veronatus capito','Veronatus capit',2,0,'','','Broun','23ff7db2-f6e4-5b47-abe8-142e42d490f6','Veronatus capito Broun, 1880','Broun, 1880','SPECIES','','Veronatus','','capito','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d1fe8c3-d9a3-4975-9c18-1bfd7f92003e','','','Cosmarium reniforme (Ralfs) W. Archer',1,'Cosmarium reniforme','Cosmarium reniforme','Cosmarium reniform',2,0,'','','Ralfs|W. Archer','0a50f04a-3434-5cc2-9b4b-eb5ac16116ed','Cosmarium reniforme (Ralfs) W. Archer','(Ralfs) W. Archer','SPECIES','','Cosmarium','','reniforme','','','',NULL,'W. Archer','','','','','Ralfs','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d20e30d-c996-4484-a201-cee551d44776','','','Pinnularia polyonca (Brebisson ) W. Smith',1,'Pinnularia polyonca','Pinnularia polyonca','Pinnularia polyonc',2,0,'','','Brebisson|W. Smith','236dd86d-11ce-522c-aa06-4b4f3110ebf7','Pinnularia polyonca (Brebisson ) W. Smith','(Brebisson ) W. Smith','SPECIES','','Pinnularia','','polyonca','','','',NULL,'W. Smith','','','','','Brebisson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d26661c-39e8-43f3-902c-49de1c69ea5c','','','Entoloma incanum sensu E. Horak',4,'','','',NULL,NULL,'','','','','Entoloma incanum sensu E. Horak','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0d276fb6-f3ff-4110-8889-b362e9dd73e7','','','Ramularia ludwigiana Syd.',1,'Ramularia ludwigiana','Ramularia ludwigiana','Ramularia ludwigian',2,0,'','','Syd.','3de70452-dc48-56c7-af30-55e4c34e1b49','Ramularia ludwigiana Syd.','Syd.','SPECIES','','Ramularia','','ludwigiana','','','',NULL,'','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b27e6c1-e9fb-4b68-b0d8-df319ecaaf77','','','Steirochaete A. Braun & Casp.',1,'Steirochaete','Steirochaete','Steirochaete',1,0,'','','A. Braun|Casp.','368f6aa8-017c-5e4b-a756-5bf266956f7b','Steirochaete A. Braun & Casp.','A. Braun & Casp.','GENUS','Steirochaete','','','','','','',NULL,'','','','','','A. Braun & Casp.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b2c824a-c262-4dd3-8b08-0dd996dde3a8','','','Entomorphinoides opposita McCulloch, 1977',1,'Entomorphinoides opposita','Entomorphinoides opposita','Entomorphinoides opposit',2,0,'','','McCulloch','d7e1a4c0-9d22-5db6-a28a-af68d60b9df8','Entomorphinoides opposita McCulloch, 1977','McCulloch, 1977','SPECIES','','Entomorphinoides','','opposita','','','',NULL,'','','','','','McCulloch','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b2a92c7-4527-43ce-8bb1-962426e692ad','','','Stereum rheicolor Mont.',1,'Stereum rheicolor','Stereum rheicolor','Stereum rheicolor',2,0,'','','Mont.','6d03eddc-0469-5234-af04-e90697c8cb4d','Stereum rheicolor Mont.','Mont.','SPECIES','','Stereum','','rheicolor','','','',NULL,'','','','','','Mont.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b3351d8-4fd7-4c99-ab5a-e6d4fb32088b','','','Macropora filifera Gordon & Taylor, 2008',1,'Macropora filifera','Macropora filifera','Macropora filifer',2,0,'','','Gordon|Taylor','0db01e8c-af5d-5ce8-8aa2-a877835ebf90','Macropora filifera Gordon & Taylor, 2008','Gordon & Taylor, 2008','SPECIES','','Macropora','','filifera','','','',NULL,'','','','','','Gordon & Taylor','','','','2008','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b365b38-1c2a-42f0-961d-4b53882799b4','','','Pinus rigida Mill.',1,'Pinus rigida','Pinus rigida','Pinus rigid',2,0,'','','Mill.','870f96e6-07cf-55d4-ba81-b49fd07d26e5','Pinus rigida Mill.','Mill.','SPECIES','','Pinus','','rigida','','','',NULL,'','','','','','Mill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b392f00-cbda-4991-b2ef-57d4a53172cf','','','Irenicodes Meyrick, 1919',1,'Irenicodes','Irenicodes','Irenicodes',1,0,'','','Meyrick','493e180c-43fa-5232-918a-2bcd1840c337','Irenicodes Meyrick, 1919','Meyrick, 1919','GENUS','Irenicodes','','','','','','',NULL,'','','','','','Meyrick','','','','1919','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b375226-6df8-4237-81a5-76b05f5a8593','','','Agaricus praecox sensu Colenso',4,'','','',NULL,NULL,'','','','','Agaricus praecox sensu Colenso','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b397054-cd85-4be0-9f8a-c8f0898adff4','','','Polysphondylium violaceum Bref.',1,'Polysphondylium violaceum','Polysphondylium violaceum','Polysphondylium uiolace',2,0,'','','Bref.','5f2da3c4-2f9c-59a1-a847-6d72a791145e','Polysphondylium violaceum Bref.','Bref.','SPECIES','','Polysphondylium','','violaceum','','','',NULL,'','','','','','Bref.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b3aae8c-9229-48ff-9ca2-194c68e08643','','','Drosera platystigma Lehm.',1,'Drosera platystigma','Drosera platystigma','Drosera platystigm',2,0,'','','Lehm.','424df12b-ab09-5629-8f33-dbf2f3a9028c','Drosera platystigma Lehm.','Lehm.','SPECIES','','Drosera','','platystigma','','','',NULL,'','','','','','Lehm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b3c70c3-870d-4b9a-a887-6719886a295f','','','Crepidopteris',1,'Crepidopteris','Crepidopteris','Crepidopteris',1,0,'','','','0889c7f0-926f-55e9-9b94-6373888b4da6','Crepidopteris','','GENUS','Crepidopteris','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b3f5eca-2d85-4494-bc93-79563e185a41','','','Olearia populifolia Colenso',1,'Olearia populifolia','Olearia populifolia','Olearia populifol',2,0,'','','Colenso','3af867f8-c111-5891-b870-ecfedc2b21fe','Olearia populifolia Colenso','Colenso','SPECIES','','Olearia','','populifolia','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b3cd61e-49f7-456e-99ab-b0b114efe466','','','Gigartina macrocarpa J.Agardh',1,'Gigartina macrocarpa','Gigartina macrocarpa','Gigartina macrocarp',2,0,'','','J. Agardh','9ea05afc-73c7-5237-8701-45712ed60197','Gigartina macrocarpa J.Agardh','J.Agardh','SPECIES','','Gigartina','','macrocarpa','','','',NULL,'','','','','','J. Agardh','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b4137ad-5331-449c-acf7-4483546ef33c','','','Anixiella Saito & Minoura ex Cain',1,'Anixiella','Anixiella','Anixiella',1,0,'','','Saito|Minoura|Cain','ee4d8f45-04df-5b63-9f4d-90e912de5e33','Anixiella Saito & Minoura ex Cain','Saito & Minoura ex Cain','GENUS','Anixiella','','','','','','',NULL,'','','','','','Saito & Minoura','','Cain','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b4806c0-3d98-4853-9e84-832d0ad86e14','','','Luzula micrantha Buchenau',1,'Luzula micrantha','Luzula micrantha','Luzula micranth',2,0,'','','Buchenau','62c05d45-5089-5e5a-bdcf-b0da11089a56','Luzula micrantha Buchenau','Buchenau','SPECIES','','Luzula','','micrantha','','','',NULL,'','','','','','Buchenau','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b482a91-2c99-479b-b847-c7b6acc90ec5','','','Asphodelaceae Juss.',1,'Asphodelaceae','Asphodelaceae','Asphodelaceae',1,0,'','','Juss.','d3f3ed96-ac9a-59d0-a380-45b2cfa3b49d','Asphodelaceae Juss.','Juss.','FAMILY','Asphodelaceae','','','','','','',NULL,'','','','','','Juss.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b484cbc-64c4-43d0-ba47-091b35bde8a1','','','Litonotidae',1,'Litonotidae','Litonotidae','Litonotidae',1,0,'','','','feab58b5-aba4-5710-bc38-b824d1b619f6','Litonotidae','','FAMILY','Litonotidae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b4953bb-1d9f-44c9-bc64-2aab01bf56c3','','','Ichneutica fibriata (Meyrick, 1913)',1,'Ichneutica fibriata','Ichneutica fibriata','Ichneutica fibriat',2,0,'','','Meyrick','1f1ccf27-ae5f-5c68-a40a-30146de32f05','Ichneutica fibriata (Meyrick, 1913)','(Meyrick, 1913)','SPECIES','','Ichneutica','','fibriata','','','',NULL,'','','','','','Meyrick','','','','1913','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b494955-4a79-41a9-a208-68b834e36773','','','Leptodon smithii (Hedw.) F.Weber & D.Mohr',1,'Leptodon smithii','Leptodon smithii','Leptodon smith',2,0,'','','Hedw.|F. Weber|D. Mohr','15ea6354-82eb-599e-9a4f-3b1bb9ae0c32','Leptodon smithii (Hedw.) F.Weber & D.Mohr','(Hedw.) F.Weber & D.Mohr','SPECIES','','Leptodon','','smithii','','','',NULL,'F. Weber & D. Mohr','','','','','Hedw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b4c11dc-8ec8-45b4-a5a5-b2c199d8358a','','','Helotium allantosporum Dennis',1,'Helotium allantosporum','Helotium allantosporum','Helotium allantospor',2,0,'','','Dennis','85f27c81-33e5-5978-9615-1b5dc192b473','Helotium allantosporum Dennis','Dennis','SPECIES','','Helotium','','allantosporum','','','',NULL,'','','','','','Dennis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b4de89e-b652-4417-b666-fc4542890c2b','','','Eucryphia milliganii Hook.f.',1,'Eucryphia milliganii','Eucryphia milliganii','Eucryphia milligan',2,0,'','','Hook. fil.','328ab70d-e440-5d78-b4d6-3ba4751c5093','Eucryphia milliganii Hook.f.','Hook.f.','SPECIES','','Eucryphia','','milliganii','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b526310-2c3f-4332-bcf6-3b1cf86da55d','','','Cotula scariosa (Cass.) Franchet',1,'Cotula scariosa','Cotula scariosa','Cotula scarios',2,0,'','','Cass.|Franchet','0af6eedb-2ab7-52c1-8be6-ca394cfe7300','Cotula scariosa (Cass.) Franchet','(Cass.) Franchet','SPECIES','','Cotula','','scariosa','','','',NULL,'Franchet','','','','','Cass.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b557db3-6a3d-4974-ac3a-678d7e297785','','','Cecidomyia flavella Kieffer, 1913',1,'Cecidomyia flavella','Cecidomyia flavella','Cecidomyia flauell',2,0,'','','Kieffer','94b643ef-d8ca-57b2-89b9-93700cad1bde','Cecidomyia flavella Kieffer, 1913','Kieffer, 1913','SPECIES','','Cecidomyia','','flavella','','','',NULL,'','','','','','Kieffer','','','','1913','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b501cf7-fefb-4106-8641-bbfa52a2610f','','','Pterothamnion antarcticum (Kylin) Moe & Silva',1,'Pterothamnion antarcticum','Pterothamnion antarcticum','Pterothamnion antarctic',2,0,'','','Kylin|Moe|Silva','4bcf5df8-5b6e-589c-b9b1-eb9d6008a302','Pterothamnion antarcticum (Kylin) Moe & Silva','(Kylin) Moe & Silva','SPECIES','','Pterothamnion','','antarcticum','','','',NULL,'Moe & Silva','','','','','Kylin','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b5ee1c3-e52d-4edc-b542-14010fb610c2','','','Epilobium crassum Hook.f.',1,'Epilobium crassum','Epilobium crassum','Epilobium crass',2,0,'','','Hook. fil.','6f91ea5d-ff4d-5b53-b3d3-041a2a6f483f','Epilobium crassum Hook.f.','Hook.f.','SPECIES','','Epilobium','','crassum','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b5813ce-5290-48d0-9774-50a175a48918','','','Geissorhiza ovata (Burm.f.) Asch. & Graebn.',1,'Geissorhiza ovata','Geissorhiza ovata','Geissorhiza ouat',2,0,'','','Burm. fil.|Asch.|Graebn.','f3a225dd-8687-542d-8a3d-02ea6f04d7ce','Geissorhiza ovata (Burm.f.) Asch. & Graebn.','(Burm.f.) Asch. & Graebn.','SPECIES','','Geissorhiza','','ovata','','','',NULL,'Asch. & Graebn.','','','','','Burm. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b58d512-1e82-452f-ad30-a0d3e941ad0b','','','Pea mosaic',1,'Pea mosaic','Pea mosaic','Pea mosaic',2,0,'','','','dae5953c-0a87-5d76-a3f6-b7e9edb7a055','Pea mosaic','','SPECIES','','Pea','','mosaic','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b5d7c31-f558-49c1-9939-a8181760c174','','','Haloragis cartilaginea Cheeseman',1,'Haloragis cartilaginea','Haloragis cartilaginea','Haloragis cartilagine',2,0,'','','Cheeseman','b3d0ee39-25e1-51e0-9b13-4fc95d061b1a','Haloragis cartilaginea Cheeseman','Cheeseman','SPECIES','','Haloragis','','cartilaginea','','','',NULL,'','','','','','Cheeseman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b6453e4-aab7-4b73-8ce8-0db52605015c','','','Hydrabasidium Park.-Rhodes ex J. Erikss. & Ryvarden',1,'Hydrabasidium','Hydrabasidium','Hydrabasidium',1,0,'','','Park.-Rhodes|J. Erikss.|Ryvarden','05f0d5a9-fccc-59e5-a830-b68b4d39e8b9','Hydrabasidium Park.-Rhodes ex J. Erikss. & Ryvarden','Park.-Rhodes ex J. Erikss. & Ryvarden','GENUS','Hydrabasidium','','','','','','',NULL,'','','','','','Park.-Rhodes','','J. Erikss. & Ryvarden','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b671e42-2dc3-4dc3-b528-69185715833c','','','Dolichandra unguis-cati (L.) L.G.Lohmann',1,'Dolichandra unguis-cati','Dolichandra unguis-cati','Dolichandra unguis-cat',2,0,'','','L.|L. G. Lohmann','12a23198-793c-52f9-afc4-cca2d828303f','Dolichandra unguis-cati (L.) L.G.Lohmann','(L.) L.G.Lohmann','SPECIES','','Dolichandra','','unguis-cati','','','',NULL,'L. G. Lohmann','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b62f2fd-eaa9-4e9f-9629-b8398027a37a','','','Virus',NULL,'','','',NULL,NULL,'','','','','Virus','','KINGDOM','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b613427-cfa0-4380-9c02-bebf9f564da8','','','Staurosirella leptostauron var. rhomboides (Grunow) Bukhtiyarova',1,'Staurosirella leptostauron rhomboides','Staurosirella leptostauron var. rhomboides','Staurosirella leptostauron rhomboid',3,0,'','','Grunow|Bukhtiyarova','fe71c172-369e-547b-8995-1650ed1ec9df','Staurosirella leptostauron var. rhomboides (Grunow) Bukhtiyarova','(Grunow) Bukhtiyarova','VARIETY','','Staurosirella','','leptostauron','rhomboides','','',NULL,'Bukhtiyarova','','','','','Grunow','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b6471fc-45a1-41f9-98d4-f4c64077268f','','','Carmichaelia R.Br.',1,'Carmichaelia','Carmichaelia','Carmichaelia',1,0,'','','R. Br.','f3c2ba6c-050e-5445-94b9-8b7a9ee818cf','Carmichaelia R.Br.','R.Br.','GENUS','Carmichaelia','','','','','','',NULL,'','','','','','R. Br.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b6d9c2b-1f43-4548-8199-39cb30182c2e','','','Hymenochaete phaea (Berk.) Cooke',1,'Hymenochaete phaea','Hymenochaete phaea','Hymenochaete phae',2,0,'','','Berk.|Cooke','71f5ea25-0441-55fc-8ac8-6a0ae442fe2d','Hymenochaete phaea (Berk.) Cooke','(Berk.) Cooke','SPECIES','','Hymenochaete','','phaea','','','',NULL,'Cooke','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b708966-4b54-4eea-953c-991b8973ff1d','','','Schoenoplectus californicus (C.A.Mey.) Palla',1,'Schoenoplectus californicus','Schoenoplectus californicus','Schoenoplectus californic',2,0,'','','C. A. Mey.|Palla','c1665282-9ae5-5abb-98f2-dad36a209884','Schoenoplectus californicus (C.A.Mey.) Palla','(C.A.Mey.) Palla','SPECIES','','Schoenoplectus','','californicus','','','',NULL,'Palla','','','','','C. A. Mey.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b6909fd-0e47-46a7-891e-e6a8364ec617','','','Entodon plicatus Müll.Hal.',1,'Entodon plicatus','Entodon plicatus','Entodon plicat',2,0,'','','Müll. Hal.','2ce4f169-e4e8-5497-b8f4-195e3f0f0d46','Entodon plicatus Müll.Hal.','Müll.Hal.','SPECIES','','Entodon','','plicatus','','','',NULL,'','','','','','Müll. Hal.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b76b726-0456-431b-a7c7-6b45eb9d2604','','','Poecilasthena pulchraria (Doubleday, 1843)',1,'Poecilasthena pulchraria','Poecilasthena pulchraria','Poecilasthena pulchrar',2,0,'','','Doubleday','46d3dc93-fad9-56a1-800c-1121047684e8','Poecilasthena pulchraria (Doubleday, 1843)','(Doubleday, 1843)','SPECIES','','Poecilasthena','','pulchraria','','','',NULL,'','','','','','Doubleday','','','','1843','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0b72b9dd-272f-4eb6-adbd-ce8c15e5980c','','','Chrysoporthe cubensis (Bruner) Gryzenh. & M.J. Wingf.',1,'Chrysoporthe cubensis','Chrysoporthe cubensis','Chrysoporthe cubens',2,0,'','','Bruner|Gryzenh.|M. J. Wingf.','1e5ee752-f43c-52cf-8866-fd872d997fcc','Chrysoporthe cubensis (Bruner) Gryzenh. & M.J. Wingf.','(Bruner) Gryzenh. & M.J. Wingf.','SPECIES','','Chrysoporthe','','cubensis','','','',NULL,'Gryzenh. & M. J. Wingf.','','','','','Bruner','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f9f61f1-f2c3-4c15-af73-2e03faedc4b3','','','Melaleuca squarrosa Donn ex Sm.',1,'Melaleuca squarrosa','Melaleuca squarrosa','Melaleuca squarros',2,0,'','','Donn|Sm.','a51cfb60-d5e8-570e-8a96-64c2abf882d4','Melaleuca squarrosa Donn ex Sm.','Donn ex Sm.','SPECIES','','Melaleuca','','squarrosa','','','',NULL,'','','','','','Donn','','Sm.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fa084fe-3567-41c3-a2f9-9ff8e87b75ea','','','Gymnomyces rolfalexii Trappe, T. Lebel & Castellano',1,'Gymnomyces rolfalexii','Gymnomyces rolfalexii','Gymnomyces rolfalex',2,0,'','','Trappe|T. Lebel|Castellano','30c7724f-df0e-5d99-85ae-b8629bfa71f4','Gymnomyces rolfalexii Trappe, T. Lebel & Castellano','Trappe, T. Lebel & Castellano','SPECIES','','Gymnomyces','','rolfalexii','','','',NULL,'','','','','','Trappe, T. Lebel & Castellano','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f9eede7-9e88-4fa0-af9e-e011bb7f5e09','','','Ianiropsis',1,'Ianiropsis','Ianiropsis','Ianiropsis',1,0,'','','','2ed0b9ce-6a12-5c4a-b3ec-a6b96249e04c','Ianiropsis','','GENUS','Ianiropsis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f9e6ea5-35e5-41a3-8732-ffb0a962cfa2','','','Rosa L.',1,'Rosa','Rosa','Rosa',1,0,'','','L.','522bb3b3-5f94-5a00-b20b-51f491b327a8','Rosa L.','L.','GENUS','Rosa','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fa120f0-9b1b-4e53-a010-4685fcc1caa2','','','Uromyces genistae-tinctoriae (Pers.) Fuckel ex G. Winter',1,'Uromyces genistae-tinctoriae','Uromyces genistae-tinctoriae','Uromyces genistae-tinctori',2,0,'','','Pers.|Fuckel|G. Winter','3a5d0366-0c3d-53ae-9895-3ca467ee90eb','Uromyces genistae-tinctoriae (Pers.) Fuckel ex G. Winter','(Pers.) Fuckel ex G. Winter','SPECIES','','Uromyces','','genistae-tinctoriae','','','',NULL,'Fuckel','','G. Winter','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fa7e7cb-415d-454c-8d87-8becf0a7fa8c','','','Septoria araguata Syd.',1,'Septoria araguata','Septoria araguata','Septoria araguat',2,0,'','','Syd.','b3e0d48b-814d-56b7-9786-d55cf7ee5f67','Septoria araguata Syd.','Syd.','SPECIES','','Septoria','','araguata','','','',NULL,'','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fa723cf-8fff-47ed-93ed-dcf9162c4c12','','','Trypetocoris aucklandensis Woodward, 1953',1,'Trypetocoris aucklandensis','Trypetocoris aucklandensis','Trypetocoris aucklandens',2,0,'','','Woodward','8be138b2-4cf1-5332-b334-c9796c67defc','Trypetocoris aucklandensis Woodward, 1953','Woodward, 1953','SPECIES','','Trypetocoris','','aucklandensis','','','',NULL,'','','','','','Woodward','','','','1953','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fade2fe-00f3-4252-aeaa-06df9479af21','','','Strigula minutula P.M.McCarthy',1,'Strigula minutula','Strigula minutula','Strigula minutul',2,0,'','','P. M. McCarthy','ca6099d0-c14f-53e7-ad1a-c27699899243','Strigula minutula P.M.McCarthy','P.M.McCarthy','SPECIES','','Strigula','','minutula','','','',NULL,'','','','','','P. M. McCarthy','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fad528b-edd8-44f5-b229-3974ed6039b3','','','Halobrecta flavipes Thomson, 1861',1,'Halobrecta flavipes','Halobrecta flavipes','Halobrecta flauip',2,0,'','','Thomson','29da3d34-d787-5457-a434-abf8b9127417','Halobrecta flavipes Thomson, 1861','Thomson, 1861','SPECIES','','Halobrecta','','flavipes','','','',NULL,'','','','','','Thomson','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0faca651-4fc3-4d8d-ad65-c0f08cc0be42','','','Staurastrum grande var. parvum W.West',1,'Staurastrum grande parvum','Staurastrum grande var. parvum','Staurastrum grand paru',3,0,'','','W. West','215ecd9b-8184-50dc-83ef-64ee1433a3ec','Staurastrum grande var. parvum W.West','W.West','VARIETY','','Staurastrum','','grande','parvum','','',NULL,'','','','','','W. West','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fa96211-bfbd-423f-a4fb-e6647ec86afa','','','Curvularia tetramera (McKinney) Boedijn ex J.C. Gilman',1,'Curvularia tetramera','Curvularia tetramera','Curvularia tetramer',2,0,'','','McKinney|Boedijn|J. C. Gilman','1c8f4898-2244-5ede-a5be-ad7917b5f65f','Curvularia tetramera (McKinney) Boedijn ex J.C. Gilman','(McKinney) Boedijn ex J.C. Gilman','SPECIES','','Curvularia','','tetramera','','','',NULL,'Boedijn','','J. C. Gilman','','','McKinney','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fb15bf2-27c4-4529-a576-b2d9a921b66a','','','Spirogyra communis (Hassall) Kütz.',1,'Spirogyra communis','Spirogyra communis','Spirogyra commun',2,0,'','','Hassall|Kütz.','96ebf7a7-7aa6-5153-9296-e555dfb60201','Spirogyra communis (Hassall) Kütz.','(Hassall) Kütz.','SPECIES','','Spirogyra','','communis','','','',NULL,'Kütz.','','','','','Hassall','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fb7f866-0d38-4523-9071-29fb7fa78e95','','','Limacella Earle',1,'Limacella','Limacella','Limacella',1,0,'','','Earle','b82db5fe-c83d-520e-9bf8-34a2d028aced','Limacella Earle','Earle','GENUS','Limacella','','','','','','',NULL,'','','','','','Earle','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fb8cd33-aaaa-4295-99b7-658ee42d78a2','','','Petrograptus elegans Holm, 1934',1,'Petrograptus elegans','Petrograptus elegans','Petrograptus elegans',2,0,'','','Holm','6f16e18d-2fcc-5470-8251-06173043315c','Petrograptus elegans Holm, 1934','Holm, 1934','SPECIES','','Petrograptus','','elegans','','','',NULL,'','','','','','Holm','','','','1934','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fbaa1d7-b2c4-4c01-b83d-8ead25fcc206','','','Schwanniomyces yamadae (Van der Walt & Johannsen) M. Suzuki & Kurtzman',1,'Schwanniomyces yamadae','Schwanniomyces yamadae','Schwanniomyces yamad',2,0,'','','Van der Walt|Johannsen|M. Suzuki|Kurtzman','23e451a9-67cc-5dd9-836e-63b21a05c937','Schwanniomyces yamadae (Van der Walt & Johannsen) M. Suzuki & Kurtzman','(Van der Walt & Johannsen) M. Suzuki & Kurtzman','SPECIES','','Schwanniomyces','','yamadae','','','',NULL,'M. Suzuki & Kurtzman','','','','','Van der Walt & Johannsen','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fc1f549-60e5-4ac4-a9cf-028745e1a5ae','','','Cunninghammyces umbonatus (G. Cunn.) Stalpers',1,'Cunninghammyces umbonatus','Cunninghammyces umbonatus','Cunninghammyces umbonat',2,0,'','','G. Cunn.|Stalpers','5736ee4c-bd1d-5dae-9920-84b99eec8713','Cunninghammyces umbonatus (G. Cunn.) Stalpers','(G. Cunn.) Stalpers','SPECIES','','Cunninghammyces','','umbonatus','','','',NULL,'Stalpers','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fc28637-3ab7-4a90-90ae-4c1def4fa563','','','Erlangea rogersii S.Moore',1,'Erlangea rogersii','Erlangea rogersii','Erlangea rogers',2,0,'','','S. Moore','5d7e3bfe-383e-5f8b-9520-c586b0197b07','Erlangea rogersii S.Moore','S.Moore','SPECIES','','Erlangea','','rogersii','','','',NULL,'','','','','','S. Moore','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fc2a60e-94b7-4115-8ae3-cbe19c1b8801','','','Glaphyrymenia pustulosa J.Agardh',1,'Glaphyrymenia pustulosa','Glaphyrymenia pustulosa','Glaphyrymenia pustulos',2,0,'','','J. Agardh','c6394486-0fe4-5edb-9c9d-43112c20638b','Glaphyrymenia pustulosa J.Agardh','J.Agardh','SPECIES','','Glaphyrymenia','','pustulosa','','','',NULL,'','','','','','J. Agardh','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fc6a1fd-76b6-4f7a-b9ee-1d05c8ef1b63','','','Stagonospora suaedae Syd.',1,'Stagonospora suaedae','Stagonospora suaedae','Stagonospora suaed',2,0,'','','Syd.','414453c8-96a0-5096-bf66-3ad94b7b3707','Stagonospora suaedae Syd.','Syd.','SPECIES','','Stagonospora','','suaedae','','','',NULL,'','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fc72b7c-837f-4bd2-a154-547d58ffbcee','','','Juniperus sabina L.',1,'Juniperus sabina','Juniperus sabina','Juniperus sabin',2,0,'','','L.','ca4003e7-b7f2-56c4-83de-5897bd8b0913','Juniperus sabina L.','L.','SPECIES','','Juniperus','','sabina','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fc98055-e570-4955-8863-79fe9db9fcae','','','Pactola hudsoni Marshall, 1938',1,'Pactola hudsoni','Pactola hudsoni','Pactola hudson',2,0,'','','Marshall','12d42569-987e-5ae1-8b4d-106fc71e6a33','Pactola hudsoni Marshall, 1938','Marshall, 1938','SPECIES','','Pactola','','hudsoni','','','',NULL,'','','','','','Marshall','','','','1938','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fc695c8-e4d0-4af3-93e2-dc75714ec0ca','','','Felaniella zelandica (Gray, 1835)',1,'Felaniella zelandica','Felaniella zelandica','Felaniella zelandic',2,0,'','','Gray','e70d0134-3358-5ffb-ac93-325e59bedb3e','Felaniella zelandica (Gray, 1835)','(Gray, 1835)','SPECIES','','Felaniella','','zelandica','','','',NULL,'','','','','','Gray','','','','1835','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fd6009f-19a1-4e62-806a-281d8c4c12d1','','','Lecanora cyrtospora C.Knight',1,'Lecanora cyrtospora','Lecanora cyrtospora','Lecanora cyrtospor',2,0,'','','C. Knight','e52ade06-589c-5696-a888-173bd8c3eb68','Lecanora cyrtospora C.Knight','C.Knight','SPECIES','','Lecanora','','cyrtospora','','','',NULL,'','','','','','C. Knight','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fd50fe6-dbfa-47f1-a033-8b472413a1d2','','','Pimenta Lindl.',1,'Pimenta','Pimenta','Pimenta',1,0,'','','Lindl.','a5ea5398-ba37-5279-b116-109d5b1c1935','Pimenta Lindl.','Lindl.','GENUS','Pimenta','','','','','','',NULL,'','','','','','Lindl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fd625fb-b5fd-4a25-a5c8-b6ac8eb8fd01','','','Cauloglossum novozelandicum (Henn.) auct.',4,'','','',NULL,NULL,'','','','','Cauloglossum novozelandicum (Henn.) auct.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fdd2d80-ead9-48ce-9b23-106850156114','','','Clathria subg. Thalysias',2,'Thalysias','Clathria subgen. Thalysias','Thalysias',1,0,'','','','ce871ff2-ac09-5933-9d82-b73ee6207a2b','Clathria subg. Thalysias','','SUBGENUS','Thalysias','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fd6e711-5511-4227-906c-363ba6fa44bd','','','Plociomerus',1,'Plociomerus','Plociomerus','Plociomerus',1,0,'','','','32e70461-5474-5042-a035-738fa968a942','Plociomerus','','GENUS','Plociomerus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fd727ff-553c-4929-9bf5-3c2d97b46225','','','Microbotryaceae R.T. Moore',1,'Microbotryaceae','Microbotryaceae','Microbotryaceae',1,0,'','','R. T. Moore','2964a559-7b81-56d7-8d50-c2f92e66975c','Microbotryaceae R.T. Moore','R.T. Moore','FAMILY','Microbotryaceae','','','','','','',NULL,'','','','','','R. T. Moore','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fda6576-54f3-4d02-af41-85f46c2802e0','','','Muehlenbeckia paucifolia Colenso',1,'Muehlenbeckia paucifolia','Muehlenbeckia paucifolia','Muehlenbeckia paucifol',2,0,'','','Colenso','5f10fb8f-55ba-5d5f-a200-d926294c43cf','Muehlenbeckia paucifolia Colenso','Colenso','SPECIES','','Muehlenbeckia','','paucifolia','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fd6494d-8a83-4ad9-9761-b638f05ebe10','','','Trichomanes sanguinolentum G.Forst.',1,'Trichomanes sanguinolentum','Trichomanes sanguinolentum','Trichomanes sanguinolent',2,0,'','','G. Forst.','3029ba31-9b45-52e0-8ba8-f279f4d7e025','Trichomanes sanguinolentum G.Forst.','G.Forst.','SPECIES','','Trichomanes','','sanguinolentum','','','',NULL,'','','','','','G. Forst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fd9286a-3170-47f0-9de0-f154fb0ba2cc','','','Allaorus sternalis Broun, 1893',1,'Allaorus sternalis','Allaorus sternalis','Allaorus sternal',2,0,'','','Broun','a91cb4cd-6d4c-5078-abf3-f8bf6a0514cf','Allaorus sternalis Broun, 1893','Broun, 1893','SPECIES','','Allaorus','','sternalis','','','',NULL,'','','','','','Broun','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fe12a1e-a89d-4b31-afb0-3c16985aefcc','','','Histodermella species 1 Kelly & Wilkinson, 2000',4,'','','',NULL,NULL,'','','','','Histodermella species 1 Kelly & Wilkinson, 2000','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fe0ee6f-9615-4aea-b34e-45c4335bd372','','','Hyalonema species Levi, 1964',4,'','','',NULL,NULL,'','','','','Hyalonema species Levi, 1964','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fde41b7-9641-4c4f-b3a5-8737a064f689','','','Ulota rufescens (Hampe) A.Jaeger',1,'Ulota rufescens','Ulota rufescens','Ulota rufescens',2,0,'','','Hampe|A. Jaeger','72da074d-f1be-57f4-affb-d251cf743e0d','Ulota rufescens (Hampe) A.Jaeger','(Hampe) A.Jaeger','SPECIES','','Ulota','','rufescens','','','',NULL,'A. Jaeger','','','','','Hampe','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fe3e4c4-337c-4727-9213-e8a60930862c','','','Semo clypeatus White, 1879',1,'Semo clypeatus','Semo clypeatus','Semo clypeat',2,0,'','','White','cb698efd-8132-5cf8-8146-3973e58491d2','Semo clypeatus White, 1879','White, 1879','SPECIES','','Semo','','clypeatus','','','',NULL,'','','','','','White','','','','1879','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fe5f320-7ea9-4492-8456-57171b566730','','','Criconema nelsonense Wouts, 2006',1,'Criconema nelsonense','Criconema nelsonense','Criconema nelsonens',2,0,'','','Wouts','1a4a9f34-4122-51bb-9ea2-5689189caf06','Criconema nelsonense Wouts, 2006','Wouts, 2006','SPECIES','','Criconema','','nelsonense','','','',NULL,'','','','','','Wouts','','','','2006','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fec405e-f517-4d13-96b7-9c0813e3aa16','','','Dicranomyia sulphuralis Edwards, 1923',1,'Dicranomyia sulphuralis','Dicranomyia sulphuralis','Dicranomyia sulphural',2,0,'','','Edwards','8076589b-fc16-5121-92d5-573b8c97957c','Dicranomyia sulphuralis Edwards, 1923','Edwards, 1923','SPECIES','','Dicranomyia','','sulphuralis','','','',NULL,'','','','','','Edwards','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fed8f50-36a6-4ee5-b35f-12507e847212','','','Phlogiotis Quél.',1,'Phlogiotis','Phlogiotis','Phlogiotis',1,0,'','','Quél.','e1ff35a0-f52f-53d9-9f9c-b2ff98a75952','Phlogiotis Quél.','Quél.','GENUS','Phlogiotis','','','','','','',NULL,'','','','','','Quél.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fee60ce-8c88-40b6-b677-3e27b327e6dd','','','Cassida',1,'Cassida','Cassida','Cassida',1,0,'','','','1ca0976d-60f7-537b-a143-c67416f81bd6','Cassida','','GENUS','Cassida','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0feff434-f96b-4196-a5c9-50fe53a78cde','','','Arikuryroba',1,'Arikuryroba','Arikuryroba','Arikuryroba',1,0,'','','','cffae144-a0e6-5a20-91b6-548cc7adbe36','Arikuryroba','','GENUS','Arikuryroba','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fef10ee-57ae-49ab-b202-6ad107d7ca86','','','Thalassarche salvini (Rothschild, 1893)',1,'Thalassarche salvini','Thalassarche salvini','Thalassarche saluin',2,0,'','','Rothschild','15b8c196-caca-58c6-a309-14eeba40b574','Thalassarche salvini (Rothschild, 1893)','(Rothschild, 1893)','SPECIES','','Thalassarche','','salvini','','','',NULL,'','','','','','Rothschild','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0fef8747-9fb8-43d8-b206-94c1e40a254f','','','Dictyoceratida',1,'Dictyoceratida','Dictyoceratida','Dictyoceratida',1,0,'','','','42f32631-b917-510d-a764-5dfc096d1758','Dictyoceratida','','ORDER','Dictyoceratida','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ff0ceb1-93a7-443b-bd3b-afa10172caf6','','','Pharcidia balani (G.Winter ex Har.) Bauch',1,'Pharcidia balani','Pharcidia balani','Pharcidia balan',2,0,'','','G. Winter|Har.|Bauch','7fa0170f-5c02-5c3c-8723-a12cb18e0faa','Pharcidia balani (G.Winter ex Har.) Bauch','(G.Winter ex Har.) Bauch','SPECIES','','Pharcidia','','balani','','','',NULL,'Bauch','','','','','G. Winter','','Har.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ff76120-f099-4faa-a144-327fb880cfd3','','','Rhypodes myersi Usinger, 1942',1,'Rhypodes myersi','Rhypodes myersi','Rhypodes myers',2,0,'','','Usinger','a55c94b9-794e-5725-96d3-a9aee001e810','Rhypodes myersi Usinger, 1942','Usinger, 1942','SPECIES','','Rhypodes','','myersi','','','',NULL,'','','','','','Usinger','','','','1942','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ff59b34-1011-4d6e-a417-3fff649d20e7','','','Hypericum elatum Aiton',1,'Hypericum elatum','Hypericum elatum','Hypericum elat',2,0,'','','Aiton','19470377-e433-5057-8101-55e2375732ca','Hypericum elatum Aiton','Aiton','SPECIES','','Hypericum','','elatum','','','',NULL,'','','','','','Aiton','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ff2a707-c47e-4fae-a2a5-893e57a2faea','','','Sticta martinii D.J.Galloway',1,'Sticta martinii','Sticta martinii','Sticta martin',2,0,'','','D. J. Galloway','3f16c927-5728-5d87-bcd8-8d1e723fc288','Sticta martinii D.J.Galloway','D.J.Galloway','SPECIES','','Sticta','','martinii','','','',NULL,'','','','','','D. J. Galloway','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ff26fc0-a7b5-4b8d-835a-c2b9abe61bc3','','','Sytus fulgens (Broun, 1880)',1,'Sytus fulgens','Sytus fulgens','Sytus fulgens',2,0,'','','Broun','1380661b-9d16-5018-8bda-b46cd3a8719f','Sytus fulgens (Broun, 1880)','(Broun, 1880)','SPECIES','','Sytus','','fulgens','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ff9efdb-b3a0-4554-a478-28fb54257479','','','Entyloma thalictri J. Schröt.',1,'Entyloma thalictri','Entyloma thalictri','Entyloma thalictr',2,0,'','','J. Schröt.','082db649-78cf-5077-952a-3472a84f1d4f','Entyloma thalictri J. Schröt.','J. Schröt.','SPECIES','','Entyloma','','thalictri','','','',NULL,'','','','','','J. Schröt.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ffbc093-f44a-4421-b668-6756b1182be3','','','Orepukia alta Forster & Wilton, 1973',1,'Orepukia alta','Orepukia alta','Orepukia alt',2,0,'','','Forster|Wilton','801c373d-31de-5282-b07c-00c0fe4ee498','Orepukia alta Forster & Wilton, 1973','Forster & Wilton, 1973','SPECIES','','Orepukia','','alta','','','',NULL,'','','','','','Forster & Wilton','','','','1973','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ffdd43b-5dad-4569-97ab-b8bfeae6833e','','','Hydnum seriatum Lloyd',1,'Hydnum seriatum','Hydnum seriatum','Hydnum seriat',2,0,'','','Lloyd','b481f447-a9ba-5302-91fb-c3c8bfa2f186','Hydnum seriatum Lloyd','Lloyd','SPECIES','','Hydnum','','seriatum','','','',NULL,'','','','','','Lloyd','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ffea119-3bc0-491b-97e9-d7f7b8aab99e','','','Quercus canariensis Willd.',1,'Quercus canariensis','Quercus canariensis','Quercus canariens',2,0,'','','Willd.','ec01ab30-6c16-5d62-8711-5b938978f2a8','Quercus canariensis Willd.','Willd.','SPECIES','','Quercus','','canariensis','','','',NULL,'','','','','','Willd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10057936-0f44-4d7e-8914-33cf093a541e','','','Metacrinus',1,'Metacrinus','Metacrinus','Metacrinus',1,0,'','','','a8f58993-5f35-570a-a2ef-99c02f5b0c50','Metacrinus','','GENUS','Metacrinus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1001ec51-4f86-433a-a04f-7880fe4f359d','','','Bryaxis impar Sharp, 1874',1,'Bryaxis impar','Bryaxis impar','Bryaxis impar',2,0,'','','Sharp','866a04b2-d4ff-5347-8673-1409440098ed','Bryaxis impar Sharp, 1874','Sharp, 1874','SPECIES','','Bryaxis','','impar','','','',NULL,'','','','','','Sharp','','','','1874','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('100285e4-8d93-4993-b87d-c5daaf49ddfc','','','Sciacharis dunedinensis Franz, 1980',1,'Sciacharis dunedinensis','Sciacharis dunedinensis','Sciacharis dunedinens',2,0,'','','Franz','98f20614-9c77-5a7f-93b1-1aaa4822bd4a','Sciacharis dunedinensis Franz, 1980','Franz, 1980','SPECIES','','Sciacharis','','dunedinensis','','','',NULL,'','','','','','Franz','','','','1980','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10006d10-ec0e-4b85-a45d-eb4445baeca5','','','Nysius',1,'Nysius','Nysius','Nysius',1,0,'','','','272e745d-b127-52f1-972f-b375083bd20a','Nysius','','GENUS','Nysius','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('100582b3-0db9-404d-884e-ef6d18546285','','','Onychonema laeve Nordst.',1,'Onychonema laeve','Onychonema laeve','Onychonema laeu',2,0,'','','Nordst.','28c2ad7b-7228-5da5-8c9b-73596dbe205f','Onychonema laeve Nordst.','Nordst.','SPECIES','','Onychonema','','laeve','','','',NULL,'','','','','','Nordst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('100b9dce-3543-4ba8-931c-2e69a632110c','','','Leptinella pusilla Hook.f.',1,'Leptinella pusilla','Leptinella pusilla','Leptinella pusill',2,0,'','','Hook. fil.','d06942e8-49b3-54c8-b495-b0dd3e670d51','Leptinella pusilla Hook.f.','Hook.f.','SPECIES','','Leptinella','','pusilla','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10067e4d-e8ca-4b2e-a8d8-6137f5e06200','','','Spilonema dendroides Henssen',1,'Spilonema dendroides','Spilonema dendroides','Spilonema dendroid',2,0,'','','Henssen','b20ca5a3-bfef-5f96-857e-bb845d540bb1','Spilonema dendroides Henssen','Henssen','SPECIES','','Spilonema','','dendroides','','','',NULL,'','','','','','Henssen','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10073a74-690a-478d-9f6c-8dca2ff2bb14','','','Alectoris chukar (J.E. Gray, 1830)',1,'Alectoris chukar','Alectoris chukar','Alectoris chukar',2,0,'','','J. E. Gray','10d9fedc-b5f5-5e52-82bc-7042e3382874','Alectoris chukar (J.E. Gray, 1830)','(J.E. Gray, 1830)','SPECIES','','Alectoris','','chukar','','','',NULL,'','','','','','J. E. Gray','','','','1830','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('100e83e5-aa7f-43ec-8cb4-179dd0c213b0','','','Flatinae',1,'Flatinae','Flatinae','Flatinae',1,0,'','','','524029e7-aaf9-51b5-aac3-d003454f31a4','Flatinae','','SUBFAMILY','Flatinae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('100d77be-c006-435c-935d-1ac0cc2bc60c','','','Cerius triregius Holloway, 1982',1,'Cerius triregius','Cerius triregius','Cerius trireg',2,0,'','','Holloway','40381a0d-2f4f-5daa-ac0c-2f5a16203037','Cerius triregius Holloway, 1982','Holloway, 1982','SPECIES','','Cerius','','triregius','','','',NULL,'','','','','','Holloway','','','','1982','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('100f2f04-7938-474f-9fe7-766a07275cae','','','Lepidozia remotifolia Horik.',1,'Lepidozia remotifolia','Lepidozia remotifolia','Lepidozia remotifol',2,0,'','','Horik.','bec38167-f214-5fc7-bd20-d02cb0384641','Lepidozia remotifolia Horik.','Horik.','SPECIES','','Lepidozia','','remotifolia','','','',NULL,'','','','','','Horik.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('100e2e98-2f32-4ee9-a716-d44bc7c0c6b7','','','Trametes mollis Fr.',1,'Trametes mollis','Trametes mollis','Trametes moll',2,0,'','','Fr.','761dcee2-eb14-5df3-9f2e-f5021d7f4fd5','Trametes mollis Fr.','Fr.','SPECIES','','Trametes','','mollis','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1011c658-66db-4916-98f6-fd2b06bb94dd','','','Geotrichum Link',1,'Geotrichum','Geotrichum','Geotrichum',1,0,'','','Link','93351be1-7479-5daf-82e0-794c5427f365','Geotrichum Link','Link','GENUS','Geotrichum','','','','','','',NULL,'','','','','','Link','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1016b26a-0009-44ef-aa87-45904803581c','','','Chelipoda modica Collin, 1928',1,'Chelipoda modica','Chelipoda modica','Chelipoda modic',2,0,'','','Collin','f2e65ed3-998c-51bf-84a4-ca55a457ec8c','Chelipoda modica Collin, 1928','Collin, 1928','SPECIES','','Chelipoda','','modica','','','',NULL,'','','','','','Collin','','','','1928','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1011d136-45d3-4d17-8a82-bb25f84307d1','','','Polypodium punctatum var. rugosulum sensu Field',4,'','','',NULL,NULL,'','','','','Polypodium punctatum var. rugosulum sensu Field','','VARIETY','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10164fd6-61c8-4770-862d-d0a3caf9c30b','','','Englerula Henn.',1,'Englerula','Englerula','Englerula',1,0,'','','Henn.','5e5e8aaf-cf44-5c4a-81c3-e51147164705','Englerula Henn.','Henn.','GENUS','Englerula','','','','','','',NULL,'','','','','','Henn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1014faf3-fd2d-4fbd-9da2-ea65e65a7139','','','Megaselia dolichoptera Bridarolli, 1937',1,'Megaselia dolichoptera','Megaselia dolichoptera','Megaselia dolichopter',2,0,'','','Bridarolli','1bb35442-00ac-5a39-a2be-7c72b860d3ad','Megaselia dolichoptera Bridarolli, 1937','Bridarolli, 1937','SPECIES','','Megaselia','','dolichoptera','','','',NULL,'','','','','','Bridarolli','','','','1937','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10188ef3-f039-466e-8e1a-1ae7cdec7705','','','Rhododendron decandrum (Makino) Makino',1,'Rhododendron decandrum','Rhododendron decandrum','Rhododendron decandr',2,0,'','','Makino','4e442db3-b58f-5490-add2-565cf77777f5','Rhododendron decandrum (Makino) Makino','(Makino) Makino','SPECIES','','Rhododendron','','decandrum','','','',NULL,'Makino','','','','','Makino','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10186af0-9915-449b-8b0c-67bb041cdef2','','','Aulacodiscus Ehrenberg',1,'Aulacodiscus','Aulacodiscus','Aulacodiscus',1,0,'','','Ehrenberg','ad0e90c5-e822-5128-9d1d-112c8aa4d3b3','Aulacodiscus Ehrenberg','Ehrenberg','GENUS','Aulacodiscus','','','','','','',NULL,'','','','','','Ehrenberg','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('101c315e-3e20-47e0-8f5d-facc275d1d45','','','Lacellina Sacc.',1,'Lacellina','Lacellina','Lacellina',1,0,'','','Sacc.','0d69dfee-9733-5e41-9b16-2d683b1e92ee','Lacellina Sacc.','Sacc.','GENUS','Lacellina','','','','','','',NULL,'','','','','','Sacc.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('102682ce-b441-41b7-8d9c-750f1dee90d1','','','Anthomyia peregrinum Meigen, 1826',1,'Anthomyia peregrinum','Anthomyia peregrinum','Anthomyia peregrin',2,0,'','','Meigen','5815ee00-88b0-5811-81e3-99ab5edbc0e9','Anthomyia peregrinum Meigen, 1826','Meigen, 1826','SPECIES','','Anthomyia','','peregrinum','','','',NULL,'','','','','','Meigen','','','','1826','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('101f8791-ca2a-482e-b633-a6af061f4024','','','Senecio hectorii Buchanan',1,'Senecio hectorii','Senecio hectorii','Senecio hector',2,0,'','','Buchanan','300eae98-5e97-536d-8bd0-327eed8b56f4','Senecio hectorii Buchanan','Buchanan','SPECIES','','Senecio','','hectorii','','','',NULL,'','','','','','Buchanan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10247b06-b08c-45fa-aa54-b373aca03ea7','','','Inopus Walker, 1850',1,'Inopus','Inopus','Inopus',1,0,'','','Walker','66142959-2fa7-56c9-bcb0-ea4aaa2567a9','Inopus Walker, 1850','Walker, 1850','GENUS','Inopus','','','','','','',NULL,'','','','','','Walker','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0eb9e1ba-4b96-41a7-898a-761b013a2198','','','Asparagus sprengeri Regel',1,'Asparagus sprengeri','Asparagus sprengeri','Asparagus sprenger',2,0,'','','Regel','3a8c9799-dc64-5c17-9511-731906b2e2eb','Asparagus sprengeri Regel','Regel','SPECIES','','Asparagus','','sprengeri','','','',NULL,'','','','','','Regel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0eb86111-7ba4-4790-9c28-dbc2ea6ea174','','','Glyphidopeza longicornis Sinclair, 1997',1,'Glyphidopeza longicornis','Glyphidopeza longicornis','Glyphidopeza longicorn',2,0,'','','Sinclair','6be08d0a-cf96-5628-8174-1c4c4db96ae0','Glyphidopeza longicornis Sinclair, 1997','Sinclair, 1997','SPECIES','','Glyphidopeza','','longicornis','','','',NULL,'','','','','','Sinclair','','','','1997','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ec2dfa0-420f-4db6-9be0-245ff0c53e0c','','','Amaryllis subgen. Worsleya W.Watson ex Traub',2,'Worsleya','Amaryllis subgen. Worsleya','Worsleya',1,0,'','','W. Watson|Traub','bdf10338-1401-5384-bd81-3147d35232d7','Amaryllis subgen. Worsleya W.Watson ex Traub','W.Watson ex Traub','SUBGENUS','Worsleya','','','','','','',NULL,'','','','','','W. Watson','','Traub','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ec159d7-824e-4093-a66a-3c330ad9c4c2','','','Cerabilia aphela (Broun, 1912)',1,'Cerabilia aphela','Cerabilia aphela','Cerabilia aphel',2,0,'','','Broun','9d0dce12-9540-54cf-aee4-88ce73421f78','Cerabilia aphela (Broun, 1912)','(Broun, 1912)','SPECIES','','Cerabilia','','aphela','','','',NULL,'','','','','','Broun','','','','1912','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ebec52a-228a-4aa4-badf-ebec8d334fac','','','Stomacarus',1,'Stomacarus','Stomacarus','Stomacarus',1,0,'','','','8cc5b929-556d-5f51-aff6-3f37bdd2cabc','Stomacarus','','GENUS','Stomacarus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ec70407-afb0-4e9b-819d-0212000805e6','','','Pseudodistichium austrogeorgicum Cardot',1,'Pseudodistichium austrogeorgicum','Pseudodistichium austrogeorgicum','Pseudodistichium austrogeorgic',2,0,'','','Cardot','3a1b2f27-687d-538e-9557-fc100631ecaa','Pseudodistichium austrogeorgicum Cardot','Cardot','SPECIES','','Pseudodistichium','','austrogeorgicum','','','',NULL,'','','','','','Cardot','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ecbb744-a755-4a76-aef3-1eecc669faa0','','','Stylosphaera',1,'Stylosphaera','Stylosphaera','Stylosphaera',1,0,'','','','a90bbda1-3e28-5ff0-949e-ef03422af5f4','Stylosphaera','','GENUS','Stylosphaera','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ec5656a-5c45-4e01-93bc-6f2d9191660f','','','Arctotis stoechadifolia P.J.Bergius',1,'Arctotis stoechadifolia','Arctotis stoechadifolia','Arctotis stoechadifol',2,0,'','','P. J. Bergius','4624e27d-9807-5394-a2f5-2e7637ac5df6','Arctotis stoechadifolia P.J.Bergius','P.J.Bergius','SPECIES','','Arctotis','','stoechadifolia','','','',NULL,'','','','','','P. J. Bergius','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0eceb4af-c6a8-4bd0-8f3d-39be2f9026ee','','','Melanelia glabratuloides (Essl.) Essl.',1,'Melanelia glabratuloides','Melanelia glabratuloides','Melanelia glabratuloid',2,0,'','','Essl.','5a04fa7a-27ae-560d-b921-386e72d8de8a','Melanelia glabratuloides (Essl.) Essl.','(Essl.) Essl.','SPECIES','','Melanelia','','glabratuloides','','','',NULL,'Essl.','','','','','Essl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ed0c87d-9bc5-4f35-b97e-5b86e8621da0','','','Naricava',1,'Naricava','Naricava','Naricava',1,0,'','','','8cd90e2d-0c34-55af-97f1-a4b0c9ef67e4','Naricava','','GENUS','Naricava','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ecea4aa-70ac-4faa-8843-81379129def2','','','Callidina',1,'Callidina','Callidina','Callidina',1,0,'','','','9eeab075-30bb-5763-b47a-0d8d98796192','Callidina','','GENUS','Callidina','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ecc4b38-c32a-4f33-9ce1-de3852ab881a','','','Periconia atropurpurea (Berk. & M.A. Curtis) M.A. Litv.',1,'Periconia atropurpurea','Periconia atropurpurea','Periconia atropurpure',2,0,'','','Berk.|M. A. Curtis|M. A. Litv.','ae8e4b17-6b12-5b7c-b943-5e5a681b9c55','Periconia atropurpurea (Berk. & M.A. Curtis) M.A. Litv.','(Berk. & M.A. Curtis) M.A. Litv.','SPECIES','','Periconia','','atropurpurea','','','',NULL,'M. A. Litv.','','','','','Berk. & M. A. Curtis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ed6c789-72a4-4652-9be8-558c0d2a7a57','','','Orchymontia calcarata Ordish, 1984',1,'Orchymontia calcarata','Orchymontia calcarata','Orchymontia calcarat',2,0,'','','Ordish','58fbdba4-46b5-512e-a5cb-ce0efffe3991','Orchymontia calcarata Ordish, 1984','Ordish, 1984','SPECIES','','Orchymontia','','calcarata','','','',NULL,'','','','','','Ordish','','','','1984','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ed39152-12fb-404e-8e81-a9eec709698d','','','Laminoppia blocki Hammer, 1968',1,'Laminoppia blocki','Laminoppia blocki','Laminoppia block',2,0,'','','Hammer','ed0fca35-3cae-5ad9-ad31-e53662f0fccd','Laminoppia blocki Hammer, 1968','Hammer, 1968','SPECIES','','Laminoppia','','blocki','','','',NULL,'','','','','','Hammer','','','','1968','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ed50b21-4da7-4cca-86dc-d47fce48967d','','','Benhamipolynoe antipathicola (Benham, 1927)',1,'Benhamipolynoe antipathicola','Benhamipolynoe antipathicola','Benhamipolynoe antipathicol',2,0,'','','Benham','8e45cbbb-33ea-5268-bc47-e4a0aaa3c26a','Benhamipolynoe antipathicola (Benham, 1927)','(Benham, 1927)','SPECIES','','Benhamipolynoe','','antipathicola','','','',NULL,'','','','','','Benham','','','','1927','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0eddf6c8-5970-4c1a-b4f2-5908ed92f120','','','Hymenobolus parasiticus Zukal',1,'Hymenobolus parasiticus','Hymenobolus parasiticus','Hymenobolus parasitic',2,0,'','','Zukal','7fcc8e1f-50b4-5487-8a4f-d87b3ac7e0c6','Hymenobolus parasiticus Zukal','Zukal','SPECIES','','Hymenobolus','','parasiticus','','','',NULL,'','','','','','Zukal','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ed9cd5d-fe0a-4e2a-99a0-73079e11c6f3','','','Acanthopharynx',1,'Acanthopharynx','Acanthopharynx','Acanthopharynx',1,0,'','','','9e1c7032-f69d-5ceb-8046-d9f64b88712b','Acanthopharynx','','GENUS','Acanthopharynx','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0edac74a-8be4-4929-b901-8c924f8a13ab','','','Fissurina spinulata McCulloch, 1977',1,'Fissurina spinulata','Fissurina spinulata','Fissurina spinulat',2,0,'','','McCulloch','744f2000-3a7d-5028-b102-d652c48661fd','Fissurina spinulata McCulloch, 1977','McCulloch, 1977','SPECIES','','Fissurina','','spinulata','','','',NULL,'','','','','','McCulloch','','','','1977','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ee56f0f-a5a3-4304-905c-03190eb43c3a','','','Pseudoeconesus paludis Ward, 1997',1,'Pseudoeconesus paludis','Pseudoeconesus paludis','Pseudoeconesus palud',2,0,'','','Ward','d2727d3c-5160-5724-80f7-7636e8b0a135','Pseudoeconesus paludis Ward, 1997','Ward, 1997','SPECIES','','Pseudoeconesus','','paludis','','','',NULL,'','','','','','Ward','','','','1997','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0edffdff-93f6-4c3a-a403-39ffa605a58c','','','Sagola flemingensis Park & Carlton, 2014',1,'Sagola flemingensis','Sagola flemingensis','Sagola flemingens',2,0,'','','Park|Carlton','c85908d7-bf7d-5935-a0e5-de67b77cfbfb','Sagola flemingensis Park & Carlton, 2014','Park & Carlton, 2014','SPECIES','','Sagola','','flemingensis','','','',NULL,'','','','','','Park & Carlton','','','','2014','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0edf9d58-8dea-46b8-89bb-8f4f87f78010','','','Pterygophyllum dentatum var. robustum (Hook.f. & Wilson) Dixon',1,'Pterygophyllum dentatum robustum','Pterygophyllum dentatum var. robustum','Pterygophyllum dentat robust',3,0,'','','Hook. fil.|Wilson|Dixon','e49e20c2-63db-59ad-8abd-873d1a8130a9','Pterygophyllum dentatum var. robustum (Hook.f. & Wilson) Dixon','(Hook.f. & Wilson) Dixon','VARIETY','','Pterygophyllum','','dentatum','robustum','','',NULL,'Dixon','','','','','Hook. fil. & Wilson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ee5599b-b2d3-4c9c-9c8f-d888a66bce80','','','Mycena morrisjonesii G. Stev.',1,'Mycena morrisjonesii','Mycena morrisjonesii','Mycena morrisiones',2,0,'','','G. Stev.','0aae6375-df26-5170-80a2-5ef04feef4ff','Mycena morrisjonesii G. Stev.','G. Stev.','SPECIES','','Mycena','','morrisjonesii','','','',NULL,'','','','','','G. Stev.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ee98d43-4c29-43d0-a83c-307abb04b797','','','Aspicilia aspera (Mereschk.) Tomin',1,'Aspicilia aspera','Aspicilia aspera','Aspicilia asper',2,0,'','','Mereschk.|Tomin','b2b2403c-6521-5686-99ba-893005f2e49c','Aspicilia aspera (Mereschk.) Tomin','(Mereschk.) Tomin','SPECIES','','Aspicilia','','aspera','','','',NULL,'Tomin','','','','','Mereschk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0eef4a6c-63a4-4fbd-8504-845ebbb387f9','','','Ringicula delecta R. Murdoch & Suter, 1906',1,'Ringicula delecta','Ringicula delecta','Ringicula delect',2,0,'','','R. Murdoch|Suter','bfc03993-7c25-5400-8107-9bccfc4ef66c','Ringicula delecta R. Murdoch & Suter, 1906','R. Murdoch & Suter, 1906','SPECIES','','Ringicula','','delecta','','','',NULL,'','','','','','R. Murdoch & Suter','','','','1906','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ef27fda-9646-4556-8c17-06b53f036d0a','','','Pseudocercosporella myopori U. Braun & C.F. Hill',1,'Pseudocercosporella myopori','Pseudocercosporella myopori','Pseudocercosporella myopor',2,0,'','','U. Braun|C. F. Hill','bc8bee33-9904-5e0e-8bb9-cfb756805cfb','Pseudocercosporella myopori U. Braun & C.F. Hill','U. Braun & C.F. Hill','SPECIES','','Pseudocercosporella','','myopori','','','',NULL,'','','','','','U. Braun & C. F. Hill','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ef0e388-77ab-4c00-8a3f-6e2e01276571','','','Scopodes levistriatus Broun, 1886',1,'Scopodes levistriatus','Scopodes levistriatus','Scopodes leuistriat',2,0,'','','Broun','14f08099-a728-58c6-adee-2ffb81b83fb1','Scopodes levistriatus Broun, 1886','Broun, 1886','SPECIES','','Scopodes','','levistriatus','','','',NULL,'','','','','','Broun','','','','1886','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ef034d1-4860-4be1-a5c6-e5142b031d42','','','Dasyuris Guenée, 1868',1,'Dasyuris','Dasyuris','Dasyuris',1,0,'','','Guenée','aedd4877-02fc-505b-b2d8-5bd4429c1a97','Dasyuris Guenée, 1868','Guenée, 1868','GENUS','Dasyuris','','','','','','',NULL,'','','','','','Guenée','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0efbe814-20a7-40b2-945e-1bf3efb0ad78','','','Pezicula amoena (Tul.) Tul. & C. Tul.',1,'Pezicula amoena','Pezicula amoena','Pezicula amoen',2,0,'','','Tul.|C. Tul.','3bded864-b276-5043-a589-caced113995b','Pezicula amoena (Tul.) Tul. & C. Tul.','(Tul.) Tul. & C. Tul.','SPECIES','','Pezicula','','amoena','','','',NULL,'Tul. & C. Tul.','','','','','Tul.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0efc456a-b490-4bac-9faf-a5df4a92857b','','','Porcellidium',1,'Porcellidium','Porcellidium','Porcellidium',1,0,'','','','dee2e51a-3db2-5759-982e-b63fcf8e829a','Porcellidium','','GENUS','Porcellidium','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0efa83a1-2581-4ee0-bb79-b753edc678bd','','','Ramichloridium musae (Stahel ex M.B. Ellis) de Hoog',1,'Ramichloridium musae','Ramichloridium musae','Ramichloridium mus',2,0,'','','Stahel|M. B. Ellis|de Hoog','de556f6f-91d4-560f-9790-2142f6cb1cbf','Ramichloridium musae (Stahel ex M.B. Ellis) de Hoog','(Stahel ex M.B. Ellis) de Hoog','SPECIES','','Ramichloridium','','musae','','','',NULL,'de Hoog','','','','','Stahel','','M. B. Ellis','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0efa3492-a408-44d0-aeb4-ec72f8b87209','','','Erica tetralix L.',1,'Erica tetralix','Erica tetralix','Erica tetralix',2,0,'','','L.','45071b14-4955-5410-a3a2-daf23fdd74a9','Erica tetralix L.','L.','SPECIES','','Erica','','tetralix','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f592c9c-7cbf-47ca-a5f3-3aed84b13cd0','','','Parepierus rufescens (Reitter, 1880)',1,'Parepierus rufescens','Parepierus rufescens','Parepierus rufescens',2,0,'','','Reitter','3a52fe8d-5dca-53dd-9158-4528e4ec725a','Parepierus rufescens (Reitter, 1880)','(Reitter, 1880)','SPECIES','','Parepierus','','rufescens','','','',NULL,'','','','','','Reitter','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f585c9e-1b2c-4933-bd1c-a4baad75f4f2','','','Ptychomnion (Hook.f. & Wilson) Mitt.',1,'Ptychomnion','Ptychomnion','Ptychomnion',1,0,'','','Hook. fil.|Wilson|Mitt.','1b4e9296-664f-5671-bafc-635cf870ecc5','Ptychomnion (Hook.f. & Wilson) Mitt.','(Hook.f. & Wilson) Mitt.','GENUS','Ptychomnion','','','','','','',NULL,'Mitt.','','','','','Hook. fil. & Wilson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f578722-e434-4511-9c42-cf8fc69640d6','','','Roccellina exspectata Tehler',1,'Roccellina exspectata','Roccellina exspectata','Roccellina exspectat',2,0,'','','Tehler','c712d132-5c98-5558-b473-f91143354d04','Roccellina exspectata Tehler','Tehler','SPECIES','','Roccellina','','exspectata','','','',NULL,'','','','','','Tehler','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f5ebdd3-d717-4412-a95f-20229d60a02f','','','Inophloeus vestitus Broun, 1893',1,'Inophloeus vestitus','Inophloeus vestitus','Inophloeus uestit',2,0,'','','Broun','de6ab920-9e92-58ef-a816-6ee4d0fbe90f','Inophloeus vestitus Broun, 1893','Broun, 1893','SPECIES','','Inophloeus','','vestitus','','','',NULL,'','','','','','Broun','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f62ac01-d2d3-4a7d-99a4-48e376df1298','','','Eolepadidae',1,'Eolepadidae','Eolepadidae','Eolepadidae',1,0,'','','','caa78b7f-7a30-5fe1-a6dd-16823202dd35','Eolepadidae','','FAMILY','Eolepadidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f5c5c0b-9f75-4526-9d21-5887a52510d7','','','Siphogenerina',1,'Siphogenerina','Siphogenerina','Siphogenerina',1,0,'','','','0be8f802-6165-53fe-877e-75a74e3c78d1','Siphogenerina','','GENUS','Siphogenerina','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f613142-8f47-48b0-9067-68cb0c4272bc','','','Aspicilia rogeri Sohrabi',1,'Aspicilia rogeri','Aspicilia rogeri','Aspicilia roger',2,0,'','','Sohrabi','a83c5791-76b0-550e-b893-225569583e22','Aspicilia rogeri Sohrabi','Sohrabi','SPECIES','','Aspicilia','','rogeri','','','',NULL,'','','','','','Sohrabi','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f628572-0c83-4cde-94d8-997bac6dfac6','','','Ipomoea indica (Burm.) Merr.',1,'Ipomoea indica','Ipomoea indica','Ipomoea indic',2,0,'','','Burm.|Merr.','a06a3d96-e7e9-52af-b16b-5e9be9ba99a4','Ipomoea indica (Burm.) Merr.','(Burm.) Merr.','SPECIES','','Ipomoea','','indica','','','',NULL,'Merr.','','','','','Burm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f5c8453-d036-410b-a3a9-f79eee0883dd','','','Rosasphaeria Jaklitsch & Voglmayr',1,'Rosasphaeria','Rosasphaeria','Rosasphaeria',1,0,'','','Jaklitsch|Voglmayr','d82a820e-4484-5c65-86a0-d8741735806a','Rosasphaeria Jaklitsch & Voglmayr','Jaklitsch & Voglmayr','GENUS','Rosasphaeria','','','','','','',NULL,'','','','','','Jaklitsch & Voglmayr','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f667fc9-d7a3-4699-a1a4-369f775e26c9','','','Marasmiellus stenophyllus (Mont.) Singer',1,'Marasmiellus stenophyllus','Marasmiellus stenophyllus','Marasmiellus stenophyll',2,0,'','','Mont.|Singer','5150fa93-b258-5e06-8482-e3d5ee542a2f','Marasmiellus stenophyllus (Mont.) Singer','(Mont.) Singer','SPECIES','','Marasmiellus','','stenophyllus','','','',NULL,'Singer','','','','','Mont.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f6623f5-1bcc-4b94-9d82-682a40444308','','','Setascutum',1,'Setascutum','Setascutum','Setascutum',1,0,'','','','48157fc2-8ffe-58d2-b90c-0bc7fa47aec6','Setascutum','','GENUS','Setascutum','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f641323-9a5c-4c7f-9e4f-9c14337adeb2','','','Ustilago aeluropodis (Trotter) Vánky',1,'Ustilago aeluropodis','Ustilago aeluropodis','Ustilago aeluropod',2,0,'','','Trotter|Vánky','04f544c9-b444-5f51-9324-d9e364f8a4ed','Ustilago aeluropodis (Trotter) Vánky','(Trotter) Vánky','SPECIES','','Ustilago','','aeluropodis','','','',NULL,'Vánky','','','','','Trotter','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f652e6a-36da-4ad2-aec1-fb30cd3a4273','','','Timmiales Ochyra',1,'Timmiales','Timmiales','Timmiales',1,0,'','','Ochyra','ff1f74d2-6953-5900-9d52-bb3a86fd96a2','Timmiales Ochyra','Ochyra','ORDER','Timmiales','','','','','','',NULL,'','','','','','Ochyra','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f6d1bf3-503f-47ee-8295-217870871eaa','','','Fusicolla merismoides (Corda) Gräfenhan, Seifert & Schroers',1,'Fusicolla merismoides','Fusicolla merismoides','Fusicolla merismoid',2,0,'','','Corda|Gräfenhan|Seifert|Schroers','bf022e98-d58f-5b49-ae3d-8427753ce6d9','Fusicolla merismoides (Corda) Gräfenhan, Seifert & Schroers','(Corda) Gräfenhan, Seifert & Schroers','SPECIES','','Fusicolla','','merismoides','','','',NULL,'Gräfenhan, Seifert & Schroers','','','','','Corda','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f6e73ee-528a-42c2-b0f8-8563561021c7','','','Hypnum pulchellum Hedw.',1,'Hypnum pulchellum','Hypnum pulchellum','Hypnum pulchell',2,0,'','','Hedw.','3703c589-cbc9-5213-8aa0-245239103ac2','Hypnum pulchellum Hedw.','Hedw.','SPECIES','','Hypnum','','pulchellum','','','',NULL,'','','','','','Hedw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f6c4320-60ee-4a05-a50b-b8607f154f9c','','','Dahlia imperialis Roezl ex Ortgies',1,'Dahlia imperialis','Dahlia imperialis','Dahlia imperial',2,0,'','','Roezl|Ortgies','56a7528d-4c99-561c-b384-7c948d71d46f','Dahlia imperialis Roezl ex Ortgies','Roezl ex Ortgies','SPECIES','','Dahlia','','imperialis','','','',NULL,'','','','','','Roezl','','Ortgies','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f735da9-c664-4de5-a628-25bb9c230866','','','Paguristes subpilosus Henderson, 1888',1,'Paguristes subpilosus','Paguristes subpilosus','Paguristes subpilos',2,0,'','','Henderson','585c411c-455f-5cf3-a06a-56fbc5d899b6','Paguristes subpilosus Henderson, 1888','Henderson, 1888','SPECIES','','Paguristes','','subpilosus','','','',NULL,'','','','','','Henderson','','','','1888','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f733591-8580-40d3-8cef-74fd89bf63f2','','','Drotus elegans Sharp, 1877',1,'Drotus elegans','Drotus elegans','Drotus elegans',2,0,'','','Sharp','7ce56ed0-6d42-570e-9c9d-61e238a61989','Drotus elegans Sharp, 1877','Sharp, 1877','SPECIES','','Drotus','','elegans','','','',NULL,'','','','','','Sharp','','','','1877','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f71aad0-c4f3-4c6d-adca-c77083dcb7dd','','','Eriolobus (DC.) M.Roem.',1,'Eriolobus','Eriolobus','Eriolobus',1,0,'','','DC.|M. Roem.','d12264b2-69fc-5336-bb59-3e8f488e934b','Eriolobus (DC.) M.Roem.','(DC.) M.Roem.','GENUS','Eriolobus','','','','','','',NULL,'M. Roem.','','','','','DC.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f726abc-9ba5-48a7-966c-dbf68d8affe6','','','Exosporium Link',1,'Exosporium','Exosporium','Exosporium',1,0,'','','Link','850644a5-d9ca-5c84-8259-71983d49b6bb','Exosporium Link','Link','GENUS','Exosporium','','','','','','',NULL,'','','','','','Link','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f7862d5-da03-4c3e-b9c5-1de7bfa1aa8e','','','Acaena inermis Hook.f.',1,'Acaena inermis','Acaena inermis','Acaena inerm',2,0,'','','Hook. fil.','76000812-18a4-5df3-9b82-8607d607847f','Acaena inermis Hook.f.','Hook.f.','SPECIES','','Acaena','','inermis','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f7b7f1d-a912-4139-9909-75d020bd3c8f','','','Galeropsidaceae Singer',1,'Galeropsidaceae','Galeropsidaceae','Galeropsidaceae',1,0,'','','Singer','275c6714-4c3f-5652-9a10-7b4fbb32e7dd','Galeropsidaceae Singer','Singer','FAMILY','Galeropsidaceae','','','','','','',NULL,'','','','','','Singer','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f7f35be-9bee-4730-a63d-7b5611bd783c','','','Ostreopsididae',1,'Ostreopsididae','Ostreopsididae','Ostreopsididae',1,0,'','','','85039939-d57a-595d-a476-9960a1a9cfba','Ostreopsididae','','FAMILY','Ostreopsididae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f788a98-8f4d-40a2-b4fd-85545338f1a7','','','Bromus unioloides Kunth',1,'Bromus unioloides','Bromus unioloides','Bromus unioloid',2,0,'','','Kunth','ffb5473d-ff63-5709-affd-5de74c5d6ac2','Bromus unioloides Kunth','Kunth','SPECIES','','Bromus','','unioloides','','','',NULL,'','','','','','Kunth','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f7675e7-5739-4904-b9fa-c628924d71d7','','','Lomariopsis hugelii C.Presl',1,'Lomariopsis hugelii','Lomariopsis hugelii','Lomariopsis hugel',2,0,'','','C. Presl','af51be93-9712-5752-9bc5-12e945e6b5ed','Lomariopsis hugelii C.Presl','C.Presl','SPECIES','','Lomariopsis','','hugelii','','','',NULL,'','','','','','C. Presl','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f838fd5-a1b4-4255-b23c-0d96015603c5','','','Votum Broun, 1880',1,'Votum','Votum','Votum',1,0,'','','Broun','ab39ea15-be08-52b8-9a12-f9f2df60075e','Votum Broun, 1880','Broun, 1880','GENUS','Votum','','','','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f857225-8867-4edd-8c54-5912263e0280','','','Erioptera subg. Trimicra Osten Sacken, 1861',2,'Trimicra','Erioptera subgen. Trimicra','Trimicra',1,0,'','','Osten Sacken','f5bbd16a-516c-55a1-a47b-36048d59c8c6','Erioptera subg. Trimicra Osten Sacken, 1861','Osten Sacken, 1861','SUBGENUS','Trimicra','','','','','','',NULL,'','','','','','Osten Sacken','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f817306-f2f1-4c45-8027-7b2f3474d745','','','Dracophyllum virgatum Colenso',1,'Dracophyllum virgatum','Dracophyllum virgatum','Dracophyllum uirgat',2,0,'','','Colenso','36e43ad7-e1fb-51e0-a2e0-0cc002c302f8','Dracophyllum virgatum Colenso','Colenso','SPECIES','','Dracophyllum','','virgatum','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f8286c3-29d9-42a8-9378-ca485e080d01','','','Coprosma waima A.P.Druce',1,'Coprosma waima','Coprosma waima','Coprosma waim',2,0,'','','A. P. Druce','b7ff2fb8-4126-57f9-b4f5-3739bec828a8','Coprosma waima A.P.Druce','A.P.Druce','SPECIES','','Coprosma','','waima','','','',NULL,'','','','','','A. P. Druce','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f889ca0-1247-47b8-b518-1be740c78cd8','','','Gynoplistia waitakerensis Alexander, 1952',1,'Gynoplistia waitakerensis','Gynoplistia waitakerensis','Gynoplistia waitakerens',2,0,'','','Alexander','2d6add5d-b119-5564-a494-a50bdf88f67d','Gynoplistia waitakerensis Alexander, 1952','Alexander, 1952','SPECIES','','Gynoplistia','','waitakerensis','','','',NULL,'','','','','','Alexander','','','','1952','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f85b410-64bf-49d4-ba45-5d3f799297f6','','','Spilogona dolosa (Hutton, 1901)',1,'Spilogona dolosa','Spilogona dolosa','Spilogona dolos',2,0,'','','Hutton','78b3e5f9-b210-5ee6-802e-db34c4795000','Spilogona dolosa (Hutton, 1901)','(Hutton, 1901)','SPECIES','','Spilogona','','dolosa','','','',NULL,'','','','','','Hutton','','','','1901','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f8d93b9-8ff8-42ac-ad1a-ec63acd117ba','','','Scoloplos subg. Leodamas',2,'Leodamas','Scoloplos subgen. Leodamas','Leodamas',1,0,'','','','f03b5583-f0c5-59fe-9826-dfc2278c95fb','Scoloplos subg. Leodamas','','SUBGENUS','Leodamas','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f917fce-a012-4ad4-a094-053c4a02b3a3','','','Sapromyza simillima Tonnoir & Malloch, 1926',1,'Sapromyza simillima','Sapromyza simillima','Sapromyza simillim',2,0,'','','Tonnoir|Malloch','bd15dced-45be-5ac1-b1b8-ea4ea323a116','Sapromyza simillima Tonnoir & Malloch, 1926','Tonnoir & Malloch, 1926','SPECIES','','Sapromyza','','simillima','','','',NULL,'','','','','','Tonnoir & Malloch','','','','1926','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f903710-4852-4a44-af85-5e69fbec94a0','','','Paraphytopus minutus Cameron, 1948',1,'Paraphytopus minutus','Paraphytopus minutus','Paraphytopus minut',2,0,'','','Cameron','7def8530-4d60-5d0e-bc2c-6f0038563a49','Paraphytopus minutus Cameron, 1948','Cameron, 1948','SPECIES','','Paraphytopus','','minutus','','','',NULL,'','','','','','Cameron','','','','1948','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f90005d-e5f9-4b60-a9e9-a43c8b7ae4c0','','','Acanthogorgiidae',1,'Acanthogorgiidae','Acanthogorgiidae','Acanthogorgiidae',1,0,'','','','554eb126-865f-5233-8f8a-6691f248d8bc','Acanthogorgiidae','','FAMILY','Acanthogorgiidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f91fd69-fff4-4430-877a-b865c3ffa1ae','','','Clavulina leveillei (Sacc.) Overeem',1,'Clavulina leveillei','Clavulina leveillei','Clavulina leueille',2,0,'','','Sacc.|Overeem','43b742ac-d432-5bd9-a4fc-f5b4f1742c8d','Clavulina leveillei (Sacc.) Overeem','(Sacc.) Overeem','SPECIES','','Clavulina','','leveillei','','','',NULL,'Overeem','','','','','Sacc.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f9bd514-5a08-4587-9dd1-4d692d8c36f0','','','Stifftia J.C.Mikan',1,'Stifftia','Stifftia','Stifftia',1,0,'','','J. C. Mikan','1f377913-0c6b-52d7-8559-7406b97c88ef','Stifftia J.C.Mikan','J.C.Mikan','GENUS','Stifftia','','','','','','',NULL,'','','','','','J. C. Mikan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f9839ae-af44-4638-8488-75cc2f59f084','','','Isograptus primulus Harris, 1933',1,'Isograptus primulus','Isograptus primulus','Isograptus primul',2,0,'','','Harris','883b0933-c311-57b1-af31-ce56994ef744','Isograptus primulus Harris, 1933','Harris, 1933','SPECIES','','Isograptus','','primulus','','','',NULL,'','','','','','Harris','','','','1933','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f97e1b2-f6e1-4890-8e02-cb2fc769fa24','','','Hymenolaimus malacorhynchos (Gmelin, 1789)',1,'Hymenolaimus malacorhynchos','Hymenolaimus malacorhynchos','Hymenolaimus malacorhynch',2,0,'','','Gmelin','9b1a7e3c-01fd-5421-b8a9-c0030802e432','Hymenolaimus malacorhynchos (Gmelin, 1789)','(Gmelin, 1789)','SPECIES','','Hymenolaimus','','malacorhynchos','','','',NULL,'','','','','','Gmelin','','','','1789','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0effce80-b435-4a65-bb2c-1872e94dd583','','','Puccinia andropogonis Schwein.',1,'Puccinia andropogonis','Puccinia andropogonis','Puccinia andropogon',2,0,'','','Schwein.','0e1f4458-7ca8-5a18-a126-1ac165e39a58','Puccinia andropogonis Schwein.','Schwein.','SPECIES','','Puccinia','','andropogonis','','','',NULL,'','','','','','Schwein.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f035117-3b43-47c3-843a-4a651ad2ffb1','','','Starkomyia inexpecta Jaschhof, 2004',1,'Starkomyia inexpecta','Starkomyia inexpecta','Starkomyia inexpect',2,0,'','','Jaschhof','6f569d6c-affc-5b20-aad5-e6e455674a8f','Starkomyia inexpecta Jaschhof, 2004','Jaschhof, 2004','SPECIES','','Starkomyia','','inexpecta','','','',NULL,'','','','','','Jaschhof','','','','2004','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f03a5c1-bb7b-4f92-9a06-77e1c0370513','','','Adagnesia',1,'Adagnesia','Adagnesia','Adagnesia',1,0,'','','','25e1a19a-c299-52b3-8437-e2eb1efc23c9','Adagnesia','','GENUS','Adagnesia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f02537c-b1ea-49bf-a8a9-7c1a641fce3f','','','Oligota wendyi Williams, 1976',1,'Oligota wendyi','Oligota wendyi','Oligota wendy',2,0,'','','Williams','43400725-00a0-5437-babe-7344c2a65a52','Oligota wendyi Williams, 1976','Williams, 1976','SPECIES','','Oligota','','wendyi','','','',NULL,'','','','','','Williams','','','','1976','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f02eabf-3ce6-4737-96c8-f3f8b089b29c','','','Duvaliomimus pluto Britton, 1962',1,'Duvaliomimus pluto','Duvaliomimus pluto','Duvaliomimus plut',2,0,'','','Britton','0c689e30-92d1-5d85-ba7d-c9a61864300b','Duvaliomimus pluto Britton, 1962','Britton, 1962','SPECIES','','Duvaliomimus','','pluto','','','',NULL,'','','','','','Britton','','','','1962','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f074276-9cad-4be2-aeff-412fa16feeb2','','','gen. indet. species indet.',NULL,'','','',NULL,NULL,'','','','','gen. indet. species indet.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f0b18f9-9f1a-45fc-8aa0-509979321455','','','Benthogone rosea Koehler, 1896',1,'Benthogone rosea','Benthogone rosea','Benthogone rose',2,0,'','','Koehler','30c0005c-ae24-55e8-8135-aa4fa4f9acaa','Benthogone rosea Koehler, 1896','Koehler, 1896','SPECIES','','Benthogone','','rosea','','','',NULL,'','','','','','Koehler','','','','1896','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f06330a-20c7-4107-aeb5-8cb5c4392225','','','Metzgeria crassipaginula Kuwah.',1,'Metzgeria crassipaginula','Metzgeria crassipaginula','Metzgeria crassipaginul',2,0,'','','Kuwah.','db0589e6-e84b-5745-bf7a-6abe7adc4166','Metzgeria crassipaginula Kuwah.','Kuwah.','SPECIES','','Metzgeria','','crassipaginula','','','',NULL,'','','','','','Kuwah.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f09ec79-5019-48ce-8611-f16218cf1f2f','','','Thelomma A.Massal.',1,'Thelomma','Thelomma','Thelomma',1,0,'','','A. Massal.','51893125-5baa-5dea-a38a-c4538ea94750','Thelomma A.Massal.','A.Massal.','GENUS','Thelomma','','','','','','',NULL,'','','','','','A. Massal.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f0edc1d-ef57-4b7a-bbeb-168ccf438456','','','Entoloma egonii Courtec.',1,'Entoloma egonii','Entoloma egonii','Entoloma egon',2,0,'','','Courtec.','12a52a0f-b341-56a6-9664-1b5d1141ff9a','Entoloma egonii Courtec.','Courtec.','SPECIES','','Entoloma','','egonii','','','',NULL,'','','','','','Courtec.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f196744-2b51-482f-9a53-9b1d6abf387c','','','Veronica canterburiensis J.B.Armstr.',1,'Veronica canterburiensis','Veronica canterburiensis','Veronica canterburiens',2,0,'','','J. B. Armstr.','47c54465-2744-5ef5-8c8b-31b7db0d2204','Veronica canterburiensis J.B.Armstr.','J.B.Armstr.','SPECIES','','Veronica','','canterburiensis','','','',NULL,'','','','','','J. B. Armstr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f12d0ae-2096-4e07-8fab-fb5d97128a32','','','Austronothrus curviseta Hammer, 1966',1,'Austronothrus curviseta','Austronothrus curviseta','Austronothrus curuiset',2,0,'','','Hammer','d780f102-2dfd-520f-a48b-84364d4fb5db','Austronothrus curviseta Hammer, 1966','Hammer, 1966','SPECIES','','Austronothrus','','curviseta','','','',NULL,'','','','','','Hammer','','','','1966','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f209862-867c-4d5f-a494-193db8aa912e','','','Baeosomus serripes Kuschel, 1964',1,'Baeosomus serripes','Baeosomus serripes','Baeosomus serrip',2,0,'','','Kuschel','110276f9-041b-5077-9a28-8e8e8e6824de','Baeosomus serripes Kuschel, 1964','Kuschel, 1964','SPECIES','','Baeosomus','','serripes','','','',NULL,'','','','','','Kuschel','','','','1964','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f1aff8a-8d80-4f17-94dd-6b7b2f8d5fc2','','','Hoheria ovata Simpson & J.S.Thomson',1,'Hoheria ovata','Hoheria ovata','Hoheria ouat',2,0,'','','Simpson|J. S. Thomson','abaa3086-09ae-5d96-b5aa-7665e6efc4cf','Hoheria ovata Simpson & J.S.Thomson','Simpson & J.S.Thomson','SPECIES','','Hoheria','','ovata','','','',NULL,'','','','','','Simpson & J. S. Thomson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f1f703a-4ac0-4d56-aaa2-cd8afbf76d17','','','Brounea mijeongae Park & Carlton, 2015',1,'Brounea mijeongae','Brounea mijeongae','Brounea miieong',2,0,'','','Park|Carlton','1dcf192e-7035-54b9-b136-56c450e6b2c6','Brounea mijeongae Park & Carlton, 2015','Park & Carlton, 2015','SPECIES','','Brounea','','mijeongae','','','',NULL,'','','','','','Park & Carlton','','','','2015','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f229ea3-9a93-4b0f-b985-4a7da2ff79f2','','','Chaetoceros teres Cleve',1,'Chaetoceros teres','Chaetoceros teres','Chaetoceros ter',2,0,'','','Cleve','1b342669-6754-555e-ba21-87037c68907a','Chaetoceros teres Cleve','Cleve','SPECIES','','Chaetoceros','','teres','','','',NULL,'','','','','','Cleve','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f21a524-02a4-4b13-8889-6893fc969dee','','','Mycoacia species',4,'','','',NULL,NULL,'','','','','Mycoacia species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f26e714-13c1-40f5-9307-892be08e3525','','','Lycopodium novozealandicum Colenso',1,'Lycopodium novozealandicum','Lycopodium novozealandicum','Lycopodium nouozealandic',2,0,'','','Colenso','14e3dc54-dcbc-5d76-97d3-5cf9acff796e','Lycopodium novozealandicum Colenso','Colenso','SPECIES','','Lycopodium','','novozealandicum','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f22f8e5-d74c-4f6e-9d8e-e39ca3fe3664','','','Ephedrus plagiator (Nees, 1811)',1,'Ephedrus plagiator','Ephedrus plagiator','Ephedrus plagiator',2,0,'','','Nees','3ccf5064-2af1-5bca-9f31-f5788d66a27d','Ephedrus plagiator (Nees, 1811)','(Nees, 1811)','SPECIES','','Ephedrus','','plagiator','','','',NULL,'','','','','','Nees','','','','1811','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f2d4a28-8b7e-404a-89ce-3fedb7626811','','','Odostomia incidata Suter, 1908',1,'Odostomia incidata','Odostomia incidata','Odostomia incidat',2,0,'','','Suter','947807ee-7d79-5432-b6e2-5cdbeca0a27f','Odostomia incidata Suter, 1908','Suter, 1908','SPECIES','','Odostomia','','incidata','','','',NULL,'','','','','','Suter','','','','1908','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f2aa1b6-9a38-4191-91db-6b359078946d','','','Flavodon Ryvarden',1,'Flavodon','Flavodon','Flavodon',1,0,'','','Ryvarden','42c8f366-1b27-5614-b42c-1fad3b4b5841','Flavodon Ryvarden','Ryvarden','GENUS','Flavodon','','','','','','',NULL,'','','','','','Ryvarden','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f309009-fd46-4fae-bff2-702c2618de40','','','Lagurus L.',1,'Lagurus','Lagurus','Lagurus',1,0,'','','L.','35227129-10ce-5036-99c8-2ae22466150b','Lagurus L.','L.','GENUS','Lagurus','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f2b2c46-f9f4-4b71-8813-7e635cdfee66','','','Rhabdomastix sagana Alexander, 1925',1,'Rhabdomastix sagana','Rhabdomastix sagana','Rhabdomastix sagan',2,0,'','','Alexander','847863c2-aeb3-57b7-ae35-26cbc2e51fd4','Rhabdomastix sagana Alexander, 1925','Alexander, 1925','SPECIES','','Rhabdomastix','','sagana','','','',NULL,'','','','','','Alexander','','','','1925','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f2ec47b-9d65-4c14-ad46-c84cd6bcac0b','','','Opius carpocapsae (Ashmead, 1900)',1,'Opius carpocapsae','Opius carpocapsae','Opius carpocaps',2,0,'','','Ashmead','4edf02c2-aaaf-58d9-963d-f974c751d24a','Opius carpocapsae (Ashmead, 1900)','(Ashmead, 1900)','SPECIES','','Opius','','carpocapsae','','','',NULL,'','','','','','Ashmead','','','','1900','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f31ca37-1326-423b-a271-740684c9c179','','','Linaria Mill.',1,'Linaria','Linaria','Linaria',1,0,'','','Mill.','403b35ab-e75e-5a34-b693-0765a1424cdc','Linaria Mill.','Mill.','GENUS','Linaria','','','','','','',NULL,'','','','','','Mill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f37f7e1-579c-41d1-8cb4-7bdd5925e698','','','Agrostis muscosa Kirk',1,'Agrostis muscosa','Agrostis muscosa','Agrostis muscos',2,0,'','','Kirk','7c9b5cd0-1321-5b06-b95c-c255474d7e9a','Agrostis muscosa Kirk','Kirk','SPECIES','','Agrostis','','muscosa','','','',NULL,'','','','','','Kirk','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f34d260-55bf-4db8-8df2-b355d8849ab8','','','Pertusaria novae-zelandiae Szatala',1,'Pertusaria novae-zelandiae','Pertusaria novae-zelandiae','Pertusaria nouae-zelandi',2,0,'','','Szatala','d9a95a38-0cdf-539a-a986-1f18b629a764','Pertusaria novae-zelandiae Szatala','Szatala','SPECIES','','Pertusaria','','novae-zelandiae','','','',NULL,'','','','','','Szatala','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f386129-23c5-4c86-a43e-f2e1ad7be97f','','','Rhaphiolepis indica (L.) Lindl.',1,'Rhaphiolepis indica','Rhaphiolepis indica','Rhaphiolepis indic',2,0,'','','L.|Lindl.','8b10c598-24a3-5d93-92a9-d86380702236','Rhaphiolepis indica (L.) Lindl.','(L.) Lindl.','SPECIES','','Rhaphiolepis','','indica','','','',NULL,'Lindl.','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f3b5177-0c24-4454-afcf-4e6cd9c45dc9','','','Epithele fasciculata (G. Cunn.) Boidin & Gilles',1,'Epithele fasciculata','Epithele fasciculata','Epithele fasciculat',2,0,'','','G. Cunn.|Boidin|Gilles','a6c4f8b0-c5c4-5940-9e22-4d843d6d20ce','Epithele fasciculata (G. Cunn.) Boidin & Gilles','(G. Cunn.) Boidin & Gilles','SPECIES','','Epithele','','fasciculata','','','',NULL,'Boidin & Gilles','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f435671-8f2b-4bd3-a9c9-d8d99de22dd3','','','Balanus trigonus Darwin, 1854',1,'Balanus trigonus','Balanus trigonus','Balanus trigon',2,0,'','','Darwin','4d64e325-fc30-5739-b237-b76e5631e0bb','Balanus trigonus Darwin, 1854','Darwin, 1854','SPECIES','','Balanus','','trigonus','','','',NULL,'','','','','','Darwin','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f4e9ea2-1160-4d85-8a88-1a2efc4ee72b','','','Annona reticulata',1,'Annona reticulata','Annona reticulata','Annona reticulat',2,0,'','','','cec73172-1f08-5958-856b-5e20ab9dc437','Annona reticulata','','SPECIES','','Annona','','reticulata','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f46229f-3679-4e1d-ba21-6f99b1bb33f9','','','Entodesmium nevadense Petr.',1,'Entodesmium nevadense','Entodesmium nevadense','Entodesmium neuadens',2,0,'','','Petr.','fe3c06bd-284a-5db8-8b89-46e27746d443','Entodesmium nevadense Petr.','Petr.','SPECIES','','Entodesmium','','nevadense','','','',NULL,'','','','','','Petr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f4f7aca-76c0-4c75-84c1-82bf9d6463f7','','','Veronica subrosulata Colenso',1,'Veronica subrosulata','Veronica subrosulata','Veronica subrosulat',2,0,'','','Colenso','d381556d-a11b-5658-92b4-310ddbc6f1ab','Veronica subrosulata Colenso','Colenso','SPECIES','','Veronica','','subrosulata','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f474851-0f72-4353-ad17-b6fd45aaabb7','','','Galium L.',1,'Galium','Galium','Galium',1,0,'','','L.','d4647419-66e7-5680-ab3f-61f94a9df673','Galium L.','L.','GENUS','Galium','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f4edc34-34c7-4c10-8732-e8ad7a028eef','','','Cladophoropsis lyallii (Harv.) V.J.Chapm.',1,'Cladophoropsis lyallii','Cladophoropsis lyallii','Cladophoropsis lyall',2,0,'','','Harv.|V. J. Chapm.','4a172992-4a1a-5a6e-9d84-904fbfaba448','Cladophoropsis lyallii (Harv.) V.J.Chapm.','(Harv.) V.J.Chapm.','SPECIES','','Cladophoropsis','','lyallii','','','',NULL,'V. J. Chapm.','','','','','Harv.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f53a29e-6e9a-476e-beb7-2594f0db38e8','','','Pselaphus meliusculus Broun, 1893',1,'Pselaphus meliusculus','Pselaphus meliusculus','Pselaphus meliuscul',2,0,'','','Broun','ce91c384-c22a-5a3e-9b73-0ac43ba6b633','Pselaphus meliusculus Broun, 1893','Broun, 1893','SPECIES','','Pselaphus','','meliusculus','','','',NULL,'','','','','','Broun','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f54638c-053a-4027-8878-6fcee08f68ee','','','Miyagia Miyabe ex Syd. & P. Syd.',1,'Miyagia','Miyagia','Miyagia',1,0,'','','Miyabe|Syd.|P. Syd.','895d8cde-9be0-57d3-845d-07e1046fca4a','Miyagia Miyabe ex Syd. & P. Syd.','Miyabe ex Syd. & P. Syd.','GENUS','Miyagia','','','','','','',NULL,'','','','','','Miyabe','','Syd. & P. Syd.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0f53007f-d116-42ce-aa41-ad46d7c0cfc7','','','Hyadesia plicata Luxton, 1989',1,'Hyadesia plicata','Hyadesia plicata','Hyadesia plicat',2,0,'','','Luxton','0cfa0292-b8a9-5288-babd-a528f4d64aff','Hyadesia plicata Luxton, 1989','Luxton, 1989','SPECIES','','Hyadesia','','plicata','','','',NULL,'','','','','','Luxton','','','','1989','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dce2c09-4e6e-4aa4-afca-3f958eeaa10a','','','Atarba eluta (Edwards, 1923)',1,'Atarba eluta','Atarba eluta','Atarba elut',2,0,'','','Edwards','ea3a7ff4-4b04-521c-944c-41214a9efe68','Atarba eluta (Edwards, 1923)','(Edwards, 1923)','SPECIES','','Atarba','','eluta','','','',NULL,'','','','','','Edwards','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dd5a880-396b-463a-b492-59e4be7fd489','','','Carientothrips badius (Hood, 1918)',1,'Carientothrips badius','Carientothrips badius','Carientothrips bad',2,0,'','','Hood','91cf96da-a9d5-57ff-aab3-08de6f24dddf','Carientothrips badius (Hood, 1918)','(Hood, 1918)','SPECIES','','Carientothrips','','badius','','','',NULL,'','','','','','Hood','','','','1918','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dd3a897-c65e-45e9-ac6e-bc5db630a4e8','','','Physarum decipiens M.A. Curtis',1,'Physarum decipiens','Physarum decipiens','Physarum decipiens',2,0,'','','M. A. Curtis','b16f3687-e4ea-5f18-9cc0-e312fc815726','Physarum decipiens M.A. Curtis','M.A. Curtis','SPECIES','','Physarum','','decipiens','','','',NULL,'','','','','','M. A. Curtis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dd8bbc7-82f5-4f94-8e4f-0c56cf7358c0','','','Cyrtolophosis',1,'Cyrtolophosis','Cyrtolophosis','Cyrtolophosis',1,0,'','','','62ab938e-af11-5183-9286-abd66dc71283','Cyrtolophosis','','GENUS','Cyrtolophosis','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dd93670-b967-4093-bad2-4402b64adc72','','','Cirrhopetalum',1,'Cirrhopetalum','Cirrhopetalum','Cirrhopetalum',1,0,'','','','567c5bb1-6609-5c46-b965-87ee50e36f06','Cirrhopetalum','','GENUS','Cirrhopetalum','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dd90d34-ca45-437f-ad2c-474c0aa2ec16','','','Acanthoceras Honigman',1,'Acanthoceras','Acanthoceras','Acanthoceras',1,0,'','','Honigman','74ec241a-0197-5dc8-9bc5-5c309e45157c','Acanthoceras Honigman','Honigman','GENUS','Acanthoceras','','','','','','',NULL,'','','','','','Honigman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dd74b71-6000-4155-8fd4-851cc7a4cccf','','','Lophocolea meridionalis Steph.',1,'Lophocolea meridionalis','Lophocolea meridionalis','Lophocolea meridional',2,0,'','','Steph.','c29a578e-20be-5645-87f5-558d575d0ac9','Lophocolea meridionalis Steph.','Steph.','SPECIES','','Lophocolea','','meridionalis','','','',NULL,'','','','','','Steph.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dd80af1-5ae7-45a9-adae-c0c40e80eadc','','','Wolfiporia Ryvarden & Gilb.',1,'Wolfiporia','Wolfiporia','Wolfiporia',1,0,'','','Ryvarden|Gilb.','026b2f15-8686-5978-aab5-a871d3518a93','Wolfiporia Ryvarden & Gilb.','Ryvarden & Gilb.','GENUS','Wolfiporia','','','','','','',NULL,'','','','','','Ryvarden & Gilb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ddebd6f-934d-42b9-a5d1-00fee015a76e','','','Microcryptorhynchus planidorsis (Kirsch, 1877)',1,'Microcryptorhynchus planidorsis','Microcryptorhynchus planidorsis','Microcryptorhynchus planidors',2,0,'','','Kirsch','08d8a817-3f4c-5bed-a61d-969d917af056','Microcryptorhynchus planidorsis (Kirsch, 1877)','(Kirsch, 1877)','SPECIES','','Microcryptorhynchus','','planidorsis','','','',NULL,'','','','','','Kirsch','','','','1877','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0de46d6c-4c12-4818-a8ac-2835a4eab425','','','Spiochaetopterus',1,'Spiochaetopterus','Spiochaetopterus','Spiochaetopterus',1,0,'','','','09a6fee9-b04b-5aa5-afed-9258997a2f86','Spiochaetopterus','','GENUS','Spiochaetopterus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ddfc3ad-f5f2-4a7d-9d2c-4a96be8a3210','','','Naucoria siparia (Fr.) Gillet',1,'Naucoria siparia','Naucoria siparia','Naucoria sipar',2,0,'','','Fr.|Gillet','97c9c935-795c-569e-a904-a331ffa47cd6','Naucoria siparia (Fr.) Gillet','(Fr.) Gillet','SPECIES','','Naucoria','','siparia','','','',NULL,'Gillet','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0de5c731-f498-4401-a878-915bc22f535e','','','Clematis tibetana subsp. vernayi (C.E.C.Fisch.) Grey-Wilson',1,'Clematis tibetana vernayi','Clematis tibetana subsp. vernayi','Clematis tibetan uernay',3,0,'','','C. E. C. Fisch.|Grey-Wilson','ea6da0eb-a199-56c2-bb26-4c356fa999e3','Clematis tibetana subsp. vernayi (C.E.C.Fisch.) Grey-Wilson','(C.E.C.Fisch.) Grey-Wilson','SUBSPECIES','','Clematis','','tibetana','vernayi','','',NULL,'Grey-Wilson','','','','','C. E. C. Fisch.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ded944d-8b36-49dd-8f02-1d42399aa975','','','Scandix L.',1,'Scandix','Scandix','Scandix',1,0,'','','L.','c535a015-9bc7-51f1-8d94-c9c6e44b1a06','Scandix L.','L.','GENUS','Scandix','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0de9d5a6-0573-4c6f-a760-784245a3432a','','','Austrognathia',1,'Austrognathia','Austrognathia','Austrognathia',1,0,'','','','0b9138a5-b403-57cd-b234-3784343763ee','Austrognathia','','GENUS','Austrognathia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0de73078-7665-44a2-a0ee-88b052829aa8','','','Epicoccum purpurascens var. tabaci (Pass.) Sacc.',1,'Epicoccum purpurascens tabaci','Epicoccum purpurascens var. tabaci','Epicoccum purpurascens tabac',3,0,'','','Pass.|Sacc.','3d36607c-419f-582f-a3a4-fc35dcf9879c','Epicoccum purpurascens var. tabaci (Pass.) Sacc.','(Pass.) Sacc.','VARIETY','','Epicoccum','','purpurascens','tabaci','','',NULL,'Sacc.','','','','','Pass.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0deda5a0-f903-446f-b4ce-bf06e0b4ee8b','','','Tupidanthus calyptratus Hook.f. & Thompson',1,'Tupidanthus calyptratus','Tupidanthus calyptratus','Tupidanthus calyptrat',2,0,'','','Hook. fil.|Thompson','15c72f37-fea0-55ae-aa10-f2570032e718','Tupidanthus calyptratus Hook.f. & Thompson','Hook.f. & Thompson','SPECIES','','Tupidanthus','','calyptratus','','','',NULL,'','','','','','Hook. fil. & Thompson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0de79783-9ef2-4677-8b34-fb76f23b83c3','','','Echinostelium minutum de Bary',1,'Echinostelium minutum','Echinostelium minutum','Echinostelium minut',2,0,'','','de Bary','f8e3c469-1826-530d-946b-a431d136e30b','Echinostelium minutum de Bary','de Bary','SPECIES','','Echinostelium','','minutum','','','',NULL,'','','','','','de Bary','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0df0d72f-4f33-405b-8d47-3b8612b32c09','','','Pseudopanax simplex (G.Forst.) K.Koch',1,'Pseudopanax simplex','Pseudopanax simplex','Pseudopanax simplex',2,0,'','','G. Forst.|K. Koch','5f52b852-5884-55ac-84fb-853d87f8120d','Pseudopanax simplex (G.Forst.) K.Koch','(G.Forst.) K.Koch','SPECIES','','Pseudopanax','','simplex','','','',NULL,'K. Koch','','','','','G. Forst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0df312a8-fe87-44d6-9b4f-8218069d15f6','','','Attenuata affinis (Powell, 1940)',1,'Attenuata affinis','Attenuata affinis','Attenuata affin',2,0,'','','Powell','b22a8701-5dac-504e-be14-37f1eb4aa4c8','Attenuata affinis (Powell, 1940)','(Powell, 1940)','SPECIES','','Attenuata','','affinis','','','',NULL,'','','','','','Powell','','','','1940','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dee8f28-34bc-4097-97d2-fb5e4526be44','','','Trachypepla euryleucota Meyrick, 1883',1,'Trachypepla euryleucota','Trachypepla euryleucota','Trachypepla euryleucot',2,0,'','','Meyrick','fb3c642e-cba7-5d03-a837-e31151004fcb','Trachypepla euryleucota Meyrick, 1883','Meyrick, 1883','SPECIES','','Trachypepla','','euryleucota','','','',NULL,'','','','','','Meyrick','','','','1883','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0df61f0a-f9bd-4a66-8ac7-35739607c6a8','','','Clivia gardenii Hook.',1,'Clivia gardenii','Clivia gardenii','Clivia garden',2,0,'','','Hook.','1faff254-4370-5cb9-b7cc-e81682e5c077','Clivia gardenii Hook.','Hook.','SPECIES','','Clivia','','gardenii','','','',NULL,'','','','','','Hook.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dfcf233-0638-4eff-8404-5bf6314b2fba','','','Entomobrya nigranota immaculata Schaffer, 1896',1,'Entomobrya nigranota immaculata','Entomobrya nigranota immaculata','Entomobrya nigranot immaculat',3,0,'','','Schaffer','6e4ac618-d1f9-52a8-afbd-83353558136b','Entomobrya nigranota immaculata Schaffer, 1896','Schaffer, 1896','SUBSPECIES','','Entomobrya','','nigranota','immaculata','','',NULL,'','','','','','Schaffer','','','','1896','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0df5ff08-ef60-467c-82cf-64af28a4580f','','','Pentapogon lautumia (Edgar & Connor) P.M. Peterson, Romasch. & Soreng',1,'Pentapogon lautumia','Pentapogon lautumia','Pentapogon lautum',2,0,'','','Edgar|Connor|P. M. Peterson|Romasch.|Soreng','9e7e8cc1-7c0e-5e44-b56e-a2403c2ae325','Pentapogon lautumia (Edgar & Connor) P.M. Peterson, Romasch. & Soreng','(Edgar & Connor) P.M. Peterson, Romasch. & Soreng','SPECIES','','Pentapogon','','lautumia','','','',NULL,'P. M. Peterson, Romasch. & Soreng','','','','','Edgar & Connor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e0040be-ef68-47ba-922d-00789b0df4ad','','','Pleurotheciella tropica J. Yang & K.D. Hyde',1,'Pleurotheciella tropica','Pleurotheciella tropica','Pleurotheciella tropic',2,0,'','','J. Yang|K. D. Hyde','446f353e-557b-5c35-ab32-5380b4c73e09','Pleurotheciella tropica J. Yang & K.D. Hyde','J. Yang & K.D. Hyde','SPECIES','','Pleurotheciella','','tropica','','','',NULL,'','','','','','J. Yang & K. D. Hyde','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e032824-5907-434a-a446-8bf13d635c68','','','Wiseana mimica (Philpott, 1923)',1,'Wiseana mimica','Wiseana mimica','Wiseana mimic',2,0,'','','Philpott','a0210add-4b49-562a-a7c4-96d06f3b9c6d','Wiseana mimica (Philpott, 1923)','(Philpott, 1923)','SPECIES','','Wiseana','','mimica','','','',NULL,'','','','','','Philpott','','','','1923','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e03e189-257c-4c4e-aa8c-bf8c0ce4a33c','','','Tristoma',1,'Tristoma','Tristoma','Tristoma',1,0,'','','','0a35dcc6-0a72-59c8-af49-0091746f520b','Tristoma','','GENUS','Tristoma','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0dffe1ad-ead4-482b-8d9a-ec737ef0c9a1','','','Crenella',1,'Crenella','Crenella','Crenella',1,0,'','','','be9e9c5e-21b4-585f-9af6-12d89d3e2393','Crenella','','GENUS','Crenella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e07882b-207c-4ef2-8fc2-06b510c8961e','','','Hypnum struthiopteris Brid.',1,'Hypnum struthiopteris','Hypnum struthiopteris','Hypnum struthiopter',2,0,'','','Brid.','367b2d56-60e7-5767-a193-619332f36f85','Hypnum struthiopteris Brid.','Brid.','SPECIES','','Hypnum','','struthiopteris','','','',NULL,'','','','','','Brid.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e040752-3c1f-46c3-bcf9-56e81112fa67','','','Strigula schizospora R.Sant.',1,'Strigula schizospora','Strigula schizospora','Strigula schizospor',2,0,'','','R. Sant.','3b30b8ce-4332-58b7-900c-b3dee43477b0','Strigula schizospora R.Sant.','R.Sant.','SPECIES','','Strigula','','schizospora','','','',NULL,'','','','','','R. Sant.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e0aee11-e665-4d2f-a565-624f5ab00f18','','','Ephestiopsis oenobarella (Meyrick, 1879)',1,'Ephestiopsis oenobarella','Ephestiopsis oenobarella','Ephestiopsis oenobarell',2,0,'','','Meyrick','f6927595-a95e-5610-bc11-cf7b7b82ad64','Ephestiopsis oenobarella (Meyrick, 1879)','(Meyrick, 1879)','SPECIES','','Ephestiopsis','','oenobarella','','','',NULL,'','','','','','Meyrick','','','','1879','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e046eb2-10a9-4211-8682-a7e497cf335c','','','Wurmbea capensis Thunb.',1,'Wurmbea capensis','Wurmbea capensis','Wurmbea capens',2,0,'','','Thunb.','5b8ad855-c09a-5c11-98db-2f1ed8c92eb7','Wurmbea capensis Thunb.','Thunb.','SPECIES','','Wurmbea','','capensis','','','',NULL,'','','','','','Thunb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e0a2dbb-ac50-4ca1-a8e8-d3cef4fa329b','','','Cyclotheca melastomatis (Pat.) Arx',1,'Cyclotheca melastomatis','Cyclotheca melastomatis','Cyclotheca melastomat',2,0,'','','Pat.|Arx','15799b35-1661-5b53-9d66-95c45b1d94e3','Cyclotheca melastomatis (Pat.) Arx','(Pat.) Arx','SPECIES','','Cyclotheca','','melastomatis','','','',NULL,'Arx','','','','','Pat.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e0fbbf7-18f5-4b6c-bae2-1e2f9614fbed','','','Brachyglottis revoluta (Kirk) B.Nord.',1,'Brachyglottis revoluta','Brachyglottis revoluta','Brachyglottis reuolut',2,0,'','','Kirk|B. Nord.','996d4e57-8b7c-5ab7-a009-3fbcd9f2a999','Brachyglottis revoluta (Kirk) B.Nord.','(Kirk) B.Nord.','SPECIES','','Brachyglottis','','revoluta','','','',NULL,'B. Nord.','','','','','Kirk','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e106cb6-a47a-4e72-921b-8e530e8b1fe5','','','Rallicola subg. Aptericola',2,'Aptericola','Rallicola subgen. Aptericola','Aptericola',1,0,'','','','f2628813-bae0-53b5-85e3-ab3c2ab67707','Rallicola subg. Aptericola','','SUBGENUS','Aptericola','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e13f243-b6ee-4ff9-bfaf-a662e36c56df','','','Xylophilus nitidus Broun, 1893',1,'Xylophilus nitidus','Xylophilus nitidus','Xylophilus nitid',2,0,'','','Broun','96784d34-7094-5a79-a474-80d731e99c0d','Xylophilus nitidus Broun, 1893','Broun, 1893','SPECIES','','Xylophilus','','nitidus','','','',NULL,'','','','','','Broun','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e1181fb-758b-440e-84ce-b3662b4918cc','','','Bathypaguropsis yaldwyni McLaughlin, 1994',1,'Bathypaguropsis yaldwyni','Bathypaguropsis yaldwyni','Bathypaguropsis yaldwyn',2,0,'','','McLaughlin','333e68f2-256e-57e6-b516-98aab10eae5b','Bathypaguropsis yaldwyni McLaughlin, 1994','McLaughlin, 1994','SPECIES','','Bathypaguropsis','','yaldwyni','','','',NULL,'','','','','','McLaughlin','','','','1994','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e0f05f5-98d8-439b-aae5-f1f492c008b6','','','Cephalosporium tabacinum J.F.H. Beyma',1,'Cephalosporium tabacinum','Cephalosporium tabacinum','Cephalosporium tabacin',2,0,'','','J. F. H. Beyma','afd1c179-b46c-5372-a900-54e5ba0beec2','Cephalosporium tabacinum J.F.H. Beyma','J.F.H. Beyma','SPECIES','','Cephalosporium','','tabacinum','','','',NULL,'','','','','','J. F. H. Beyma','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e15dbb3-dded-4a43-857f-b5ab72dead65','','','Halipeurus turtur Edwards, 1961',1,'Halipeurus turtur','Halipeurus turtur','Halipeurus turtur',2,0,'','','Edwards','d6cd38f6-13da-53db-b145-2cab68052611','Halipeurus turtur Edwards, 1961','Edwards, 1961','SPECIES','','Halipeurus','','turtur','','','',NULL,'','','','','','Edwards','','','','1961','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e15aeb8-0a8e-4598-9bbb-c733f6ab609d','','','Pseudocaranx dentex (Bloch & Schneider, 1801)',1,'Pseudocaranx dentex','Pseudocaranx dentex','Pseudocaranx dentex',2,0,'','','Bloch|Schneider','ceb46678-b8b4-5b3c-9554-32e2da4c3ab8','Pseudocaranx dentex (Bloch & Schneider, 1801)','(Bloch & Schneider, 1801)','SPECIES','','Pseudocaranx','','dentex','','','',NULL,'','','','','','Bloch & Schneider','','','','1801','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e68f893-f04e-4dc7-9e90-1908e50dcfc3','','','Uromyces ficariae (Schumach.) Lév.',1,'Uromyces ficariae','Uromyces ficariae','Uromyces ficari',2,0,'','','Schumach.|Lév.','9a32e2fa-44c6-58fd-ab45-718d3af9c141','Uromyces ficariae (Schumach.) Lév.','(Schumach.) Lév.','SPECIES','','Uromyces','','ficariae','','','',NULL,'Lév.','','','','','Schumach.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e6a378b-14b3-4807-8c07-3c3566159ad4','','','Mesochytrium penetrans B.V. Gromov, Mamkaeva & Pjusch',1,'Mesochytrium penetrans','Mesochytrium penetrans','Mesochytrium penetrans',2,0,'','','B. V. Gromov|Mamkaeva|Pjusch','d53c1c0e-920c-5819-91f1-bc9c21f3f13c','Mesochytrium penetrans B.V. Gromov, Mamkaeva & Pjusch','B.V. Gromov, Mamkaeva & Pjusch','SPECIES','','Mesochytrium','','penetrans','','','',NULL,'','','','','','B. V. Gromov, Mamkaeva & Pjusch','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e687764-7821-4351-82c9-cff056af0524','','','Leptosphaeria praetermissa (P. Karst.) Sacc.',1,'Leptosphaeria praetermissa','Leptosphaeria praetermissa','Leptosphaeria praetermiss',2,0,'','','P. Karst.|Sacc.','0741aa78-d553-5250-9682-9b74a3f041b1','Leptosphaeria praetermissa (P. Karst.) Sacc.','(P. Karst.) Sacc.','SPECIES','','Leptosphaeria','','praetermissa','','','',NULL,'Sacc.','','','','','P. Karst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e70068d-8f98-4b24-8c58-5a8fecb14555','','','Lophogaster',1,'Lophogaster','Lophogaster','Lophogaster',1,0,'','','','9714ce8f-9dc8-52fa-895c-860e8d697d1a','Lophogaster','','GENUS','Lophogaster','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e6c9109-56d5-4818-804c-63176548fc56','','','Salpingus species n.',4,'','','',NULL,NULL,'','','','','Salpingus species n.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e6e968e-16ce-4a72-bd0e-70544c476add','','','Typhlocybini',1,'Typhlocybini','Typhlocybini','Typhlocybini',1,0,'','','','953e3692-46a0-517d-bbb1-d9cc3f7c6048','Typhlocybini','','TRIBE','Typhlocybini','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e726a37-f41c-4077-89b7-ad3f53a66993','','','Tortula truncata (Hedw.) Mitt.',1,'Tortula truncata','Tortula truncata','Tortula truncat',2,0,'','','Hedw.|Mitt.','b91a21ed-bc6c-5a84-a5df-14cccd920cdf','Tortula truncata (Hedw.) Mitt.','(Hedw.) Mitt.','SPECIES','','Tortula','','truncata','','','',NULL,'Mitt.','','','','','Hedw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e6d4329-a6cd-45ca-bfea-d93397a91f6f','','','Mastogloia braunii Grunow',1,'Mastogloia braunii','Mastogloia braunii','Mastogloia braun',2,0,'','','Grunow','02c8940a-57e4-5fa8-a680-cdbc909fc472','Mastogloia braunii Grunow','Grunow','SPECIES','','Mastogloia','','braunii','','','',NULL,'','','','','','Grunow','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e777683-b9db-4722-bf45-00f3b25c7e96','','','Munditia',1,'Munditia','Munditia','Munditia',1,0,'','','','3b62bb69-70d0-5be0-9945-71293b211a14','Munditia','','GENUS','Munditia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e7870b3-1a21-4007-b079-1eb89451b3e8','','','Otidea concinna (Pers.) Sacc.',1,'Otidea concinna','Otidea concinna','Otidea concinn',2,0,'','','Pers.|Sacc.','8008fc10-0aa9-5f7b-8516-5b0699265a22','Otidea concinna (Pers.) Sacc.','(Pers.) Sacc.','SPECIES','','Otidea','','concinna','','','',NULL,'Sacc.','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e7616f7-f2c8-4314-a3ce-3fb6a3603a13','','','Thoracochaeta alia Marshall & Roháček, 2000',1,'Thoracochaeta alia','Thoracochaeta alia','Thoracochaeta al',2,0,'','','Marshall|Roháček','02fff9c2-167a-55e1-8bcc-7efeb7d57b7a','Thoracochaeta alia Marshall & Roháček, 2000','Marshall & Roháček, 2000','SPECIES','','Thoracochaeta','','alia','','','',NULL,'','','','','','Marshall & Roháček','','','','2000','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e761819-2335-4907-a64a-e1e3a96472ef','','','Ramularia macrospora var. major Lindr.',1,'Ramularia macrospora major','Ramularia macrospora var. major','Ramularia macrospor maior',3,0,'','','Lindr.','c6df5aea-8707-58d7-b30c-393d4c5bec20','Ramularia macrospora var. major Lindr.','Lindr.','VARIETY','','Ramularia','','macrospora','major','','',NULL,'','','','','','Lindr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e7ec470-411a-4262-a703-133ffa5bee4a','','','Laevilitorina subg. Macquariella',2,'Macquariella','Laevilitorina subgen. Macquariella','Macquariella',1,0,'','','','196c1804-b783-57f5-a5ad-057b48c463f0','Laevilitorina subg. Macquariella','','SUBGENUS','Macquariella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e7fe466-e892-46d9-b053-2b92feedc694','','','Carex horizontalis (Colenso) K.A.Ford',1,'Carex horizontalis','Carex horizontalis','Carex horizontal',2,0,'','','Colenso|K. A. Ford','52055d46-a20c-53f7-bd5c-8b1305c5c326','Carex horizontalis (Colenso) K.A.Ford','(Colenso) K.A.Ford','SPECIES','','Carex','','horizontalis','','','',NULL,'K. A. Ford','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e80d7cb-f850-44a8-92a0-805888146d1d','','','Phronira osculans (Broun, 1880)',1,'Phronira osculans','Phronira osculans','Phronira osculans',2,0,'','','Broun','07af09d8-775b-5bf2-9300-83ad7f747632','Phronira osculans (Broun, 1880)','(Broun, 1880)','SPECIES','','Phronira','','osculans','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e79f9e5-29b6-4c81-967c-cda9258b29c2','','','Rhodofomes roseus (Alb. & Schwein.) Vlasák',1,'Rhodofomes roseus','Rhodofomes roseus','Rhodofomes rose',2,0,'','','Alb.|Schwein.|Vlasák','fcd4a206-74fe-5857-b2c1-69294d028a73','Rhodofomes roseus (Alb. & Schwein.) Vlasák','(Alb. & Schwein.) Vlasák','SPECIES','','Rhodofomes','','roseus','','','',NULL,'Vlasák','','','','','Alb. & Schwein.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e7b76c1-9d67-476e-892c-e58678b12f03','','','Parawaldeckia dabita Lowry & Stoddart, 1983',1,'Parawaldeckia dabita','Parawaldeckia dabita','Parawaldeckia dabit',2,0,'','','Lowry|Stoddart','118e2979-7598-5393-b329-cc9df7c56ac3','Parawaldeckia dabita Lowry & Stoddart, 1983','Lowry & Stoddart, 1983','SPECIES','','Parawaldeckia','','dabita','','','',NULL,'','','','','','Lowry & Stoddart','','','','1983','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e867482-8025-4bb3-aa6a-5362882a8632','','','Fusarium Link',1,'Fusarium','Fusarium','Fusarium',1,0,'','','Link','a65c3da4-c8e9-568c-9583-353fa4a70004','Fusarium Link','Link','GENUS','Fusarium','','','','','','',NULL,'','','','','','Link','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e873768-6cad-4a8d-b0f2-73c6f86ceb20','','','Cryptosporella viticola Shear',1,'Cryptosporella viticola','Cryptosporella viticola','Cryptosporella uiticol',2,0,'','','Shear','0f3ab1e8-2347-51e5-87e4-f17b3dcd62d6','Cryptosporella viticola Shear','Shear','SPECIES','','Cryptosporella','','viticola','','','',NULL,'','','','','','Shear','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e834ebe-78ab-46de-a115-e85214610340','','','Mimosa invisa Colla',1,'Mimosa invisa','Mimosa invisa','Mimosa inuis',2,0,'','','Colla','470f7f92-57bb-5db4-9463-79a9b4616d69','Mimosa invisa Colla','Colla','SPECIES','','Mimosa','','invisa','','','',NULL,'','','','','','Colla','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e8fd1d7-b27f-41d6-a098-3482fc8e52e5','','','Octochaetus tricystis Lee, 1952',1,'Octochaetus tricystis','Octochaetus tricystis','Octochaetus tricyst',2,0,'','','Lee','9b5640f3-41e2-5dd5-8d09-2c7155c3e6af','Octochaetus tricystis Lee, 1952','Lee, 1952','SPECIES','','Octochaetus','','tricystis','','','',NULL,'','','','','','Lee','','','','1952','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e932432-f9f0-4e88-ad8b-55b193b56e93','','','Clio antarctica Dall, 1908',1,'Clio antarctica','Clio antarctica','Clio antarctic',2,0,'','','Dall','437bb82d-9ff1-538b-8610-66894168743d','Clio antarctica Dall, 1908','Dall, 1908','SPECIES','','Clio','','antarctica','','','',NULL,'','','','','','Dall','','','','1908','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e8bedb6-1a4e-4720-b576-b7e709867866','','','Circoxena Meyrick, 1916',1,'Circoxena','Circoxena','Circoxena',1,0,'','','Meyrick','a8780491-f982-5007-95db-59677819f497','Circoxena Meyrick, 1916','Meyrick, 1916','GENUS','Circoxena','','','','','','',NULL,'','','','','','Meyrick','','','','1916','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e90f1d8-0d65-45f1-a403-d8e7fc21bf85','','','Coscinodiscus oculus-iridis Ehrenberg',1,'Coscinodiscus oculus-iridis','Coscinodiscus oculus-iridis','Coscinodiscus oculus-irid',2,0,'','','Ehrenberg','39de6326-d7e7-53b0-b212-eb97f2c7a29e','Coscinodiscus oculus-iridis Ehrenberg','Ehrenberg','SPECIES','','Coscinodiscus','','oculus-iridis','','','',NULL,'','','','','','Ehrenberg','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e8ddb35-c007-4c5c-9ffe-f71ed3d4a0f3','','','Molophilus cruciferus Alexander, 1922',1,'Molophilus cruciferus','Molophilus cruciferus','Molophilus crucifer',2,0,'','','Alexander','e5deefe8-2737-54c0-8b23-013b8ea223d4','Molophilus cruciferus Alexander, 1922','Alexander, 1922','SPECIES','','Molophilus','','cruciferus','','','',NULL,'','','','','','Alexander','','','','1922','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e95fdd3-26e0-4f24-9014-65439778a1e4','','','Navomorpha lineata (Fabricius, 1775)',1,'Navomorpha lineata','Navomorpha lineata','Navomorpha lineat',2,0,'','','Fabricius','a7d98584-ffed-538e-880e-f065758e9a6a','Navomorpha lineata (Fabricius, 1775)','(Fabricius, 1775)','SPECIES','','Navomorpha','','lineata','','','',NULL,'','','','','','Fabricius','','','','1775','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e93f038-325b-4ff0-bd93-891b70ed659c','','','Narcissus late season yellows virus',NULL,'','','',NULL,NULL,'','','','','Narcissus late season yellows virus','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e9af4a0-1d13-4b19-92db-8ae067ccc127','','','Mycomicrothelia minutissima (C.Knight) D.Hawksw.',1,'Mycomicrothelia minutissima','Mycomicrothelia minutissima','Mycomicrothelia minutissim',2,0,'','','C. Knight|D. Hawksw.','1c0b6d48-a180-5330-960d-b1efb7a883f8','Mycomicrothelia minutissima (C.Knight) D.Hawksw.','(C.Knight) D.Hawksw.','SPECIES','','Mycomicrothelia','','minutissima','','','',NULL,'D. Hawksw.','','','','','C. Knight','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e9448bb-bf39-426e-ac02-edcdd28964a7','','','Disonycha argentinensis Jacoby',1,'Disonycha argentinensis','Disonycha argentinensis','Disonycha argentinens',2,0,'','','Jacoby','f9097d29-fc55-5d4b-99de-2fbf507ea1b8','Disonycha argentinensis Jacoby','Jacoby','SPECIES','','Disonycha','','argentinensis','','','',NULL,'','','','','','Jacoby','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e9dd063-9572-41f7-889b-775c3a901635','','','Cylindrosporium eminens Davis',1,'Cylindrosporium eminens','Cylindrosporium eminens','Cylindrosporium eminens',2,0,'','','Davis','31f577d9-19d2-5ba4-a90b-377284e1d992','Cylindrosporium eminens Davis','Davis','SPECIES','','Cylindrosporium','','eminens','','','',NULL,'','','','','','Davis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ea40850-5e65-4c80-97d2-b09b3bf9138d','','','Poria ambigua Bres.',1,'Poria ambigua','Poria ambigua','Poria ambigu',2,0,'','','Bres.','b2e13a19-4c87-5557-9cf0-6525b1329d1c','Poria ambigua Bres.','Bres.','SPECIES','','Poria','','ambigua','','','',NULL,'','','','','','Bres.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ea083dd-773f-4b79-a6bb-b778105353a5','','','Dixella Tonnoir, 1924',1,'Dixella','Dixella','Dixella',1,0,'','','Tonnoir','80ff3e70-77d7-5698-baef-8f243c196a83','Dixella Tonnoir, 1924','Tonnoir, 1924','GENUS','Dixella','','','','','','',NULL,'','','','','','Tonnoir','','','','1924','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ea41c9a-7666-4caa-b8c7-e10dd4bed7f3','','','Diploschistes ocellatus (Vill.) Norman',1,'Diploschistes ocellatus','Diploschistes ocellatus','Diploschistes ocellat',2,0,'','','Vill.|Norman','3638023f-967d-5bd2-a7a9-01e66d6c5c19','Diploschistes ocellatus (Vill.) Norman','(Vill.) Norman','SPECIES','','Diploschistes','','ocellatus','','','',NULL,'Norman','','','','','Vill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ea74296-c3c9-4a22-8a0c-5f4ef845e96e','','','Ultratenuipalpus coprosmicus (Collyer, 1973)',1,'Ultratenuipalpus coprosmicus','Ultratenuipalpus coprosmicus','Ultratenuipalpus coprosmic',2,0,'','','Collyer','91c87232-0e3e-52b6-86f6-3e73734beb97','Ultratenuipalpus coprosmicus (Collyer, 1973)','(Collyer, 1973)','SPECIES','','Ultratenuipalpus','','coprosmicus','','','',NULL,'','','','','','Collyer','','','','1973','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0ea5d4cd-e146-4d16-a9af-c266a85ea358','','','Herbertus scolopendra (Hook.) Kuntze',1,'Herbertus scolopendra','Herbertus scolopendra','Herbertus scolopendr',2,0,'','','Hook.|Kuntze','60c69457-129c-5d30-b941-01b64f6ddfa3','Herbertus scolopendra (Hook.) Kuntze','(Hook.) Kuntze','SPECIES','','Herbertus','','scolopendra','','','',NULL,'Kuntze','','','','','Hook.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0eabc93c-615e-4fc3-b8f2-0a0f1a097083','','','Opiconsiva dilpa (Kirkaldy, 1907)',1,'Opiconsiva dilpa','Opiconsiva dilpa','Opiconsiva dilp',2,0,'','','Kirkaldy','219bc514-a4d1-5203-8edb-905441f37255','Opiconsiva dilpa (Kirkaldy, 1907)','(Kirkaldy, 1907)','SPECIES','','Opiconsiva','','dilpa','','','',NULL,'','','','','','Kirkaldy','','','','1907','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0eaa0f2c-c3d2-468d-9d4b-75d26d8a1d8b','','','Tragopogon porrifolius L.',1,'Tragopogon porrifolius','Tragopogon porrifolius','Tragopogon porrifol',2,0,'','','L.','8cb35fc7-fc51-5def-964e-1705459ebec1','Tragopogon porrifolius L.','L.','SPECIES','','Tragopogon','','porrifolius','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0eab650c-f31f-4dec-ab0c-ba199e45c8c2','','','Delitschia leptospora Oudem.',1,'Delitschia leptospora','Delitschia leptospora','Delitschia leptospor',2,0,'','','Oudem.','448a1391-9461-51c6-957b-581461cd75ac','Delitschia leptospora Oudem.','Oudem.','SPECIES','','Delitschia','','leptospora','','','',NULL,'','','','','','Oudem.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0eaa8e7d-203d-4612-a34f-dd51d239a8d4','','','Bacteriastrum hyalinum Lauder',1,'Bacteriastrum hyalinum','Bacteriastrum hyalinum','Bacteriastrum hyalin',2,0,'','','Lauder','0231d59a-c414-549b-902c-6299143f5f1a','Bacteriastrum hyalinum Lauder','Lauder','SPECIES','','Bacteriastrum','','hyalinum','','','',NULL,'','','','','','Lauder','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e19d863-6c14-4367-8128-ef7e67b0998a','','','Glycaspis',1,'Glycaspis','Glycaspis','Glycaspis',1,0,'','','','9498e322-9e26-5ec7-883c-406b54590612','Glycaspis','','GENUS','Glycaspis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0eb03aee-8769-4ed1-8178-fcc3827df394','','','Agaricus illinitus Fr.',1,'Agaricus illinitus','Agaricus illinitus','Agaricus illinit',2,0,'','','Fr.','69cfbb09-87c8-5432-84f6-41517421e3e2','Agaricus illinitus Fr.','Fr.','SPECIES','','Agaricus','','illinitus','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e1ad513-b391-4f3f-ac3a-4050a4e75fc4','','','Cryptaranea venustula (Urquhart, 1891)',1,'Cryptaranea venustula','Cryptaranea venustula','Cryptaranea uenustul',2,0,'','','Urquhart','12f5f6c5-904b-5f94-9e48-525561b624e8','Cryptaranea venustula (Urquhart, 1891)','(Urquhart, 1891)','SPECIES','','Cryptaranea','','venustula','','','',NULL,'','','','','','Urquhart','','','','1891','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e204082-2981-4e30-a043-992e52018aa1','','','Distocercosporaster dioscoreae (Ellis & G. Martin) Videira, H.D. Shin, C. Nakash. & Crous',1,'Distocercosporaster dioscoreae','Distocercosporaster dioscoreae','Distocercosporaster dioscore',2,0,'','','Ellis|G. Martin|Videira|H. D. Shin|C. Nakash.|Crous','bb513dde-edbc-55d1-b53d-9e6d54b6cdf3','Distocercosporaster dioscoreae (Ellis & G. Martin) Videira, H.D. Shin, C. Nakash. & Crous','(Ellis & G. Martin) Videira, H.D. Shin, C. Nakash. & Crous','SPECIES','','Distocercosporaster','','dioscoreae','','','',NULL,'Videira, H. D. Shin, C. Nakash. & Crous','','','','','Ellis & G. Martin','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e23e960-7085-4db3-92b8-01327a6ed637','','','Myrmaecium fulvopruinatum (Berk.) Jaklitsch & Voglmayr',1,'Myrmaecium fulvopruinatum','Myrmaecium fulvopruinatum','Myrmaecium fuluopruinat',2,0,'','','Berk.|Jaklitsch|Voglmayr','5bebd473-737e-5e3a-b7ef-e5163299cb03','Myrmaecium fulvopruinatum (Berk.) Jaklitsch & Voglmayr','(Berk.) Jaklitsch & Voglmayr','SPECIES','','Myrmaecium','','fulvopruinatum','','','',NULL,'Jaklitsch & Voglmayr','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e28225d-0005-4729-9dc8-5cc6dafe9943','','','Phacussa fulminata costata Suter, 1899',1,'Phacussa fulminata costata','Phacussa fulminata costata','Phacussa fulminat costat',3,0,'','','Suter','2b4c2309-dc13-52c1-9177-58ed6117e545','Phacussa fulminata costata Suter, 1899','Suter, 1899','SUBSPECIES','','Phacussa','','fulminata','costata','','',NULL,'','','','','','Suter','','','','1899','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e2b948b-f747-4f2d-bd88-96b019ae0498','','','Epilobium vernicosum Cheeseman',1,'Epilobium vernicosum','Epilobium vernicosum','Epilobium uernicos',2,0,'','','Cheeseman','99e44b3a-6519-51e0-8ca4-a99df7350932','Epilobium vernicosum Cheeseman','Cheeseman','SPECIES','','Epilobium','','vernicosum','','','',NULL,'','','','','','Cheeseman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e2aefe5-da15-4627-b587-e32cec0af031','','','Nitzschia martiana (Agardh) van Heurck',1,'Nitzschia martiana','Nitzschia martiana','Nitzschia martian',2,0,'','','Agardh|van Heurck','abdfeba4-b98c-565c-bfa0-77e55fe6001b','Nitzschia martiana (Agardh) van Heurck','(Agardh) van Heurck','SPECIES','','Nitzschia','','martiana','','','',NULL,'van Heurck','','','','','Agardh','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e2d736c-c1df-439f-ace8-2fdb24fdff97','','','Spirillina decorata Brady, 1884',1,'Spirillina decorata','Spirillina decorata','Spirillina decorat',2,0,'','','Brady','fb705285-8059-5298-894a-d20ec3f37021','Spirillina decorata Brady, 1884','Brady, 1884','SPECIES','','Spirillina','','decorata','','','',NULL,'','','','','','Brady','','','','1884','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e2d3efa-837b-4da5-bfd1-7246ce5b9d48','','','Pavia indica Wall. ex Cambess.',1,'Pavia indica','Pavia indica','Pavia indic',2,0,'','','Wall.|Cambess.','4275fec8-833a-5a7d-9285-82adfea44c8a','Pavia indica Wall. ex Cambess.','Wall. ex Cambess.','SPECIES','','Pavia','','indica','','','',NULL,'','','','','','Wall.','','Cambess.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e344c0c-a9b2-4e07-8238-d84e2e848444','','','Dothidotthiaceae',1,'Dothidotthiaceae','Dothidotthiaceae','Dothidotthiaceae',1,0,'','','','d2d7aa57-167a-5bd3-8fe2-f29daa22097a','Dothidotthiaceae','','FAMILY','Dothidotthiaceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e3a894a-bda3-4a33-b00e-3053e48d3505','','','Giardia duodenalis (Davaine, 1875)',1,'Giardia duodenalis','Giardia duodenalis','Giardia duodenal',2,0,'','','Davaine','f464db01-9018-5b17-894c-70a8cc0af95d','Giardia duodenalis (Davaine, 1875)','(Davaine, 1875)','SPECIES','','Giardia','','duodenalis','','','',NULL,'','','','','','Davaine','','','','1875','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e3c7bd9-72e8-4ac7-9536-5d9ff559c29e','','','Parmularia Lév.',1,'Parmularia','Parmularia','Parmularia',1,0,'','','Lév.','acf75ad4-ee30-56a6-a030-e0c396453f6e','Parmularia Lév.','Lév.','GENUS','Parmularia','','','','','','',NULL,'','','','','','Lév.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e39847a-ef98-40b9-b1e8-87f7ae63d09e','','','Limosa limosa melanuroides Gould',1,'Limosa limosa melanuroides','Limosa limosa melanuroides','Limosa limos melanuroid',3,0,'','','Gould','7e4b1a64-5880-5d5a-86dd-16a28bb5dcd6','Limosa limosa melanuroides Gould','Gould','SUBSPECIES','','Limosa','','limosa','melanuroides','','',NULL,'','','','','','Gould','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e3bf312-692d-436b-b784-d3ed631d95ad','','','Rhizophagus populinus P.A. Dang.',1,'Rhizophagus populinus','Rhizophagus populinus','Rhizophagus populin',2,0,'','','P. A. Dang.','88426f7c-4084-5578-9bf6-fea183419a28','Rhizophagus populinus P.A. Dang.','P.A. Dang.','SPECIES','','Rhizophagus','','populinus','','','',NULL,'','','','','','P. A. Dang.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e403cd1-b23b-4b82-b974-0013f10ef9cd','','','Phormium tenax ''Tūtaewheke''',1,'Phormium tenax ‘Tūtaewheke’','Phormium tenax ‘Tūtaewheke’','Phormium tenax ‘Tūtaewheke’',3,0,'','','','47ca8d1a-9a10-59b8-bb99-44f1320bb7c9','Phormium tenax ''Tūtaewheke''','','CULTIVAR','','Phormium','','tenax','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e43f164-e160-47f5-9435-0eaa92ed1a5d','','','Arenaria serpyllifolia L.',1,'Arenaria serpyllifolia','Arenaria serpyllifolia','Arenaria serpyllifol',2,0,'','','L.','81889b6e-9ace-521b-ad71-153fa9cc5d8b','Arenaria serpyllifolia L.','L.','SPECIES','','Arenaria','','serpyllifolia','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e4623d7-0e03-453f-9146-75b1b71d7850','','','Hippocrepinella alba Heron-Allen & Earland, 1932',1,'Hippocrepinella alba','Hippocrepinella alba','Hippocrepinella alb',2,0,'','','Heron-Allen|Earland','6ec4d2e8-8e0b-5c99-9c08-e8dae2f94b02','Hippocrepinella alba Heron-Allen & Earland, 1932','Heron-Allen & Earland, 1932','SPECIES','','Hippocrepinella','','alba','','','',NULL,'','','','','','Heron-Allen & Earland','','','','1932','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e46c707-0623-46c1-834b-fe2002a1c683','','','Aceria pimeliae Manson, 1984',1,'Aceria pimeliae','Aceria pimeliae','Aceria pimeli',2,0,'','','Manson','33df7af4-3fa6-50bd-9f9d-6a8e6f26c527','Aceria pimeliae Manson, 1984','Manson, 1984','SPECIES','','Aceria','','pimeliae','','','',NULL,'','','','','','Manson','','','','1984','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e47a7cb-b60b-4ee3-b277-4c2c85123b61','','','Zelandobius peglegensis McLellan, 1993',1,'Zelandobius peglegensis','Zelandobius peglegensis','Zelandobius peglegens',2,0,'','','McLellan','7d30b96a-9aaf-5de2-b732-16f356ffca9b','Zelandobius peglegensis McLellan, 1993','McLellan, 1993','SPECIES','','Zelandobius','','peglegensis','','','',NULL,'','','','','','McLellan','','','','1993','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e4cfbae-a938-452e-bebd-69b80944dc97','','','Heterosphaeria lojkae (Rehm) Höhn.',1,'Heterosphaeria lojkae','Heterosphaeria lojkae','Heterosphaeria loik',2,0,'','','Rehm|Höhn.','c50c61bf-940f-5e24-acb1-5547d0fb37cf','Heterosphaeria lojkae (Rehm) Höhn.','(Rehm) Höhn.','SPECIES','','Heterosphaeria','','lojkae','','','',NULL,'Höhn.','','','','','Rehm','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e4d8935-ebfa-4c8e-9147-c478e8266b55','','','Mniobia dentata Haigh, 1967',1,'Mniobia dentata','Mniobia dentata','Mniobia dentat',2,0,'','','Haigh','31bd79d6-d4f1-5e12-ae4a-d1f321746a45','Mniobia dentata Haigh, 1967','Haigh, 1967','VARIETY','','Mniobia','','dentata','','','',NULL,'','','','','','Haigh','','','','1967','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e4f28e3-dce9-4bca-9e77-57f29aaa002d','','','Hyalinella',1,'Hyalinella','Hyalinella','Hyalinella',1,0,'','','','e184b9a8-a591-5eab-ba2a-4168af1cc922','Hyalinella','','GENUS','Hyalinella','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e50551d-d6f9-4da6-95b9-65dcfab2b48e','','','Lepidozia glaucophylla (Hook.f. & Taylor) Gottsche, Lindenb. & Nees',1,'Lepidozia glaucophylla','Lepidozia glaucophylla','Lepidozia glaucophyll',2,0,'','','Hook. fil.|Taylor|Gottsche|Lindenb.|Nees','a2b1eefb-0a20-590f-acb1-09a6c7866218','Lepidozia glaucophylla (Hook.f. & Taylor) Gottsche, Lindenb. & Nees','(Hook.f. & Taylor) Gottsche, Lindenb. & Nees','SPECIES','','Lepidozia','','glaucophylla','','','',NULL,'Gottsche, Lindenb. & Nees','','','','','Hook. fil. & Taylor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e503977-7b7e-4e13-aaa8-bd99f7f6514c','','','Aegotheles novaezealandiae (Scarlett, 1968)',1,'Aegotheles novaezealandiae','Aegotheles novaezealandiae','Aegotheles nouaezealandi',2,0,'','','Scarlett','1fdfe01d-3ae1-5df1-ad17-c3f9d378acb5','Aegotheles novaezealandiae (Scarlett, 1968)','(Scarlett, 1968)','SPECIES','','Aegotheles','','novaezealandiae','','','',NULL,'','','','','','Scarlett','','','','1968','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e5378ca-702e-4c18-b704-09f8168fb9b6','','','Richoniella pumila f. bispora E. Horak',1,'Richoniella pumila bispora','Richoniella pumila f. bispora','Richoniella pumil bispor',3,0,'','','E. Horak','c6a0fa09-2736-5e2e-a11b-0560c4b8d871','Richoniella pumila f. bispora E. Horak','E. Horak','FORM','','Richoniella','','pumila','bispora','','',NULL,'','','','','','E. Horak','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e56d8ef-f4c1-4101-ae2a-79327a78fe77','','','Rotaliammina sigmoidea Wells, 1985',1,'Rotaliammina sigmoidea','Rotaliammina sigmoidea','Rotaliammina sigmoide',2,0,'','','Wells','607b5ea8-3661-586b-a58e-27250df166c0','Rotaliammina sigmoidea Wells, 1985','Wells, 1985','SPECIES','','Rotaliammina','','sigmoidea','','','',NULL,'','','','','','Wells','','','','1985','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e543f48-18e6-4484-ba1b-aac3c2195740','','','Austropsocus insularis Smithers, 1962',1,'Austropsocus insularis','Austropsocus insularis','Austropsocus insular',2,0,'','','Smithers','6d30458c-7188-59f9-96b7-59b7a09d1340','Austropsocus insularis Smithers, 1962','Smithers, 1962','SPECIES','','Austropsocus','','insularis','','','',NULL,'','','','','','Smithers','','','','1962','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e55f7b6-474f-47d9-8794-e368bf8907d5','','','Senecio macroglossus DC.',1,'Senecio macroglossus','Senecio macroglossus','Senecio macrogloss',2,0,'','','DC.','68520996-6178-5a78-96f3-1dd52642020d','Senecio macroglossus DC.','DC.','SPECIES','','Senecio','','macroglossus','','','',NULL,'','','','','','DC.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e5c3a67-7327-4f1c-92e7-2dd9c60092c5','','','Crystallophyes amygdalina Moser, 1925',1,'Crystallophyes amygdalina','Crystallophyes amygdalina','Crystallophyes amygdalin',2,0,'','','Moser','db1fadbb-5ce2-5810-b320-826c5dc71a3a','Crystallophyes amygdalina Moser, 1925','Moser, 1925','SPECIES','','Crystallophyes','','amygdalina','','','',NULL,'','','','','','Moser','','','','1925','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e5b1e7c-e4a1-42c9-a3fc-58304034983a','','','Drosera lusitanica L.',1,'Drosera lusitanica','Drosera lusitanica','Drosera lusitanic',2,0,'','','L.','ad45ea5c-9912-5f86-ac11-44c886af31b6','Drosera lusitanica L.','L.','SPECIES','','Drosera','','lusitanica','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e5af053-feeb-4188-b0ac-9423e9ba547c','','','Tymovirus',NULL,'','','',NULL,NULL,'','','','','Tymovirus','','GENUS','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e595c32-66f3-42f2-8d8a-9c3242d8c30d','','','Trichocoleaceae Nakai',1,'Trichocoleaceae','Trichocoleaceae','Trichocoleaceae',1,0,'','','Nakai','34ca6390-83b1-506a-8b13-bc526debdba5','Trichocoleaceae Nakai','Nakai','FAMILY','Trichocoleaceae','','','','','','',NULL,'','','','','','Nakai','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e5bda3c-46de-449f-883f-ecfb8df07cbf','','','Dahlia australis (Sherff) P.D.Sørensen',1,'Dahlia australis','Dahlia australis','Dahlia austral',2,0,'','','Sherff|P. D. Sørensen','587888de-af04-544e-9e5e-15bd04f3fe6b','Dahlia australis (Sherff) P.D.Sørensen','(Sherff) P.D.Sørensen','SPECIES','','Dahlia','','australis','','','',NULL,'P. D. Sørensen','','','','','Sherff','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e5fe7bf-4274-4f5e-bfa6-64d95e4bebe3','','','Datura wrightii Regel',1,'Datura wrightii','Datura wrightii','Datura wright',2,0,'','','Regel','5a7e516f-6bd1-558d-8286-1f479c500d6f','Datura wrightii Regel','Regel','SPECIES','','Datura','','wrightii','','','',NULL,'','','','','','Regel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e5edf96-b906-4ec4-821a-8724718c755f','','','Rhodocybe dingleyae E. Horak',1,'Rhodocybe dingleyae','Rhodocybe dingleyae','Rhodocybe dingley',2,0,'','','E. Horak','ed5c3484-49c1-512d-9c92-a67299e4098d','Rhodocybe dingleyae E. Horak','E. Horak','SPECIES','','Rhodocybe','','dingleyae','','','',NULL,'','','','','','E. Horak','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e633430-33f9-4b6b-af69-e3f25d502e5a','','','Tenebroides',1,'Tenebroides','Tenebroides','Tenebroides',1,0,'','','','39bdecc2-3bfc-5ec7-87fa-22c4f0cc2258','Tenebroides','','GENUS','Tenebroides','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('0e6349b1-bd30-4cf1-ac78-f8701612b855','','','Uromyces citriformis Berk.',1,'Uromyces citriformis','Uromyces citriformis','Uromyces citriform',2,0,'','','Berk.','9bef2334-178d-5945-87d8-4a3cf3271d6d','Uromyces citriformis Berk.','Berk.','SPECIES','','Uromyces','','citriformis','','','',NULL,'','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10310834-2f8f-4d72-a50e-456c740bebdf','','','Sphaeria polymorpha Pers.',1,'Sphaeria polymorpha','Sphaeria polymorpha','Sphaeria polymorph',2,0,'','','Pers.','3d35f56a-26a2-5578-8540-ac51302f39ac','Sphaeria polymorpha Pers.','Pers.','SPECIES','','Sphaeria','','polymorpha','','','',NULL,'','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('102d82cf-62a5-4f11-9db6-78a4226bbc21','','','Notogaster macdonaldae Fernandez-Triana and Ward, 2020',1,'Notogaster macdonaldae','Notogaster macdonaldae','Notogaster macdonald',2,0,'','','Fernandez-Triana|Ward','4ae72793-a020-52f1-aeb1-70e27773b533','Notogaster macdonaldae Fernandez-Triana and Ward, 2020','Fernandez-Triana and Ward, 2020','SPECIES','','Notogaster','','macdonaldae','','','',NULL,'','','','','','Fernandez-Triana & Ward','','','','2020','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('102a5461-4b8b-42a0-8b0f-f90b39f31fff','','','Sarcinella Sacc.',1,'Sarcinella','Sarcinella','Sarcinella',1,0,'','','Sacc.','05b3ef8b-6685-5363-8297-266a9447bace','Sarcinella Sacc.','Sacc.','GENUS','Sarcinella','','','','','','',NULL,'','','','','','Sacc.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10320134-9a31-4731-880a-2788283b19f1','','','Phloeognathus',1,'Phloeognathus','Phloeognathus','Phloeognathus',1,0,'','','','c947e1e7-86ed-50e8-a256-d72ce1e70853','Phloeognathus','','GENUS','Phloeognathus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10330f57-0ff7-46d9-86d7-2c4279913b63','','','Demetrida ater Broun, 1880',1,'Demetrida ater','Demetrida ater','Demetrida ater',2,0,'','','Broun','64a4138f-aa5c-5716-8c07-3333f8fca037','Demetrida ater Broun, 1880','Broun, 1880','SPECIES','','Demetrida','','ater','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1032586c-22b4-418d-9b9a-8779221ef821','','','Perisporiopsis fusispora (Pat.) Arx',1,'Perisporiopsis fusispora','Perisporiopsis fusispora','Perisporiopsis fusispor',2,0,'','','Pat.|Arx','056b0d5b-c572-52ad-b08c-c7135b19830c','Perisporiopsis fusispora (Pat.) Arx','(Pat.) Arx','SPECIES','','Perisporiopsis','','fusispora','','','',NULL,'Arx','','','','','Pat.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1031a607-f344-4218-89fc-f301674aa666','','','Camaropycnis libocedri E.K. Cash',1,'Camaropycnis libocedri','Camaropycnis libocedri','Camaropycnis libocedr',2,0,'','','E. K. Cash','64678c96-4142-542f-98d7-bbcc34a18cb2','Camaropycnis libocedri E.K. Cash','E.K. Cash','SPECIES','','Camaropycnis','','libocedri','','','',NULL,'','','','','','E. K. Cash','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('103d3de6-15d5-4916-a67a-4112f4b555fe','','','Philophthalmus species weekes, 1982',4,'','','',NULL,NULL,'','','','','Philophthalmus species weekes, 1982','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('103dbb90-3e9a-4f0e-8ec0-48f77c13995d','','','Cesius lutescens (Lehm. & Lindenb.) Kuntze',1,'Cesius lutescens','Cesius lutescens','Cesius lutescens',2,0,'','','Lehm.|Lindenb.|Kuntze','a7b10f67-bd95-5592-ba49-8ab5c5e906d7','Cesius lutescens (Lehm. & Lindenb.) Kuntze','(Lehm. & Lindenb.) Kuntze','SPECIES','','Cesius','','lutescens','','','',NULL,'Kuntze','','','','','Lehm. & Lindenb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('103acf6a-ffa9-4021-ba54-9031751a5dd4','','','Uredo fabae Pers.',1,'Uredo fabae','Uredo fabae','Uredo fab',2,0,'','','Pers.','13e0f0ad-cde1-53a3-a52b-4fe5242863db','Uredo fabae Pers.','Pers.','SPECIES','','Uredo','','fabae','','','',NULL,'','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('103ef538-e4ea-4a25-95f1-f1e5aea6d8b3','','','Gymnodinium marinum Kent',1,'Gymnodinium marinum','Gymnodinium marinum','Gymnodinium marin',2,0,'','','Kent','51026459-8eab-5e55-92ee-ba17dff7f872','Gymnodinium marinum Kent','Kent','SPECIES','','Gymnodinium','','marinum','','','',NULL,'','','','','','Kent','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('103f74c0-085a-4c5b-b200-250d0035d655','','','Rhizophydium pythii De Wild.',1,'Rhizophydium pythii','Rhizophydium pythii','Rhizophydium pyth',2,0,'','','De Wild.','79b2fd8f-ee07-5fed-ac13-25a7caa775ee','Rhizophydium pythii De Wild.','De Wild.','SPECIES','','Rhizophydium','','pythii','','','',NULL,'','','','','','De Wild.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10482ee6-561d-490a-94e0-7542c722964c','','','Pepper mild mottle virus',NULL,'','','',NULL,NULL,'','','','','Pepper mild mottle virus','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('103fb8b3-9617-48c8-ba7c-877fac4db570','','','Stephos angulatus Bradford-Grieve, 1999',1,'Stephos angulatus','Stephos angulatus','Stephos angulat',2,0,'','','Bradford-Grieve','a1765204-17ea-57f3-a5ac-75f11d75d78d','Stephos angulatus Bradford-Grieve, 1999','Bradford-Grieve, 1999','SPECIES','','Stephos','','angulatus','','','',NULL,'','','','','','Bradford-Grieve','','','','1999','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1048254e-6aea-4127-802c-ca7751e1b5de','','','Pinus montezumae Lamb. var. montezumae',1,'Pinus montezumae montezumae','Pinus montezumae var. montezumae','Pinus montezum montezum',3,0,'','','','5d447dfa-8999-5ae3-91a5-7596da01c910','Pinus montezumae Lamb. var. montezumae','','VARIETY','','Pinus','','montezumae','montezumae','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10522fd1-f9fd-4812-be2c-2955d68d97ea','','','Pseudocercospora rumohrae W.H. Hsieh & Goh',1,'Pseudocercospora rumohrae','Pseudocercospora rumohrae','Pseudocercospora rumohr',2,0,'','','W. H. Hsieh|Goh','57365327-72b5-5065-b127-04af7f7decaf','Pseudocercospora rumohrae W.H. Hsieh & Goh','W.H. Hsieh & Goh','SPECIES','','Pseudocercospora','','rumohrae','','','',NULL,'','','','','','W. H. Hsieh & Goh','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('104cd2f0-7e98-4a1c-8015-d85825cf3245','','','Polyporus laevigatus Fr.',1,'Polyporus laevigatus','Polyporus laevigatus','Polyporus laeuigat',2,0,'','','Fr.','6d7fd87b-81fa-5dbb-8969-5636f67ce60b','Polyporus laevigatus Fr.','Fr.','SPECIES','','Polyporus','','laevigatus','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('104b76b5-4dc0-438e-aa8a-ff550af2052b','','','Amphora sinuata Greville',1,'Amphora sinuata','Amphora sinuata','Amphora sinuat',2,0,'','','Greville','3dac1169-0638-53c1-b442-ff89d33ffecb','Amphora sinuata Greville','Greville','SPECIES','','Amphora','','sinuata','','','',NULL,'','','','','','Greville','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('105717d6-9ce7-46a7-be2f-8764141bea25','','','Colutea frutescens L.',1,'Colutea frutescens','Colutea frutescens','Colutea frutescens',2,0,'','','L.','e2cb0697-e22c-50c8-8ad7-6c2c83ea264f','Colutea frutescens L.','L.','SPECIES','','Colutea','','frutescens','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('105283e9-a97c-41af-a9f1-a4efff8ff73f','','','Microtis viridis F.Muell.',1,'Microtis viridis','Microtis viridis','Microtis uirid',2,0,'','','F. Muell.','890f92a0-2726-5984-a6e7-05fb608d4c5f','Microtis viridis F.Muell.','F.Muell.','SPECIES','','Microtis','','viridis','','','',NULL,'','','','','','F. Muell.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1057d4fb-27fa-451d-89af-ce8a19a1f52e','','','Komagataella pastoris (Guillierm.) Y. Yamada, M. Matsuda, K. Maeda & Mikata',1,'Komagataella pastoris','Komagataella pastoris','Komagataella pastor',2,0,'','','Guillierm.|Y. Yamada|M. Matsuda|K. Maeda|Mikata','009b39d0-2a9f-5207-affc-7d5a5c3247a2','Komagataella pastoris (Guillierm.) Y. Yamada, M. Matsuda, K. Maeda & Mikata','(Guillierm.) Y. Yamada, M. Matsuda, K. Maeda & Mikata','SPECIES','','Komagataella','','pastoris','','','',NULL,'Y. Yamada, M. Matsuda, K. Maeda & Mikata','','','','','Guillierm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('105abb62-a0c0-427c-bf42-3efbe30702f8','','','Paramoebidium',1,'Paramoebidium','Paramoebidium','Paramoebidium',1,0,'','','','036b3015-f68b-5d50-b645-6981b26e309e','Paramoebidium','','GENUS','Paramoebidium','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10591f7d-c8fe-438d-acc5-6a9fd315d969','','','Fuscospora fusca (Hook.f.) Heenan & Smissen',1,'Fuscospora fusca','Fuscospora fusca','Fuscospora fusc',2,0,'','','Hook. fil.|Heenan|Smissen','ea75e807-f15b-5fe6-a187-d8765616f6e8','Fuscospora fusca (Hook.f.) Heenan & Smissen','(Hook.f.) Heenan & Smissen','SPECIES','','Fuscospora','','fusca','','','',NULL,'Heenan & Smissen','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('105a187f-c7d7-4c05-a7c2-8e36b450ddcd','','','Sciacharis hopeana (Franz, 1975)',1,'Sciacharis hopeana','Sciacharis hopeana','Sciacharis hopean',2,0,'','','Franz','647e54a6-f385-54c9-8940-6ba79d35c406','Sciacharis hopeana (Franz, 1975)','(Franz, 1975)','SPECIES','','Sciacharis','','hopeana','','','',NULL,'','','','','','Franz','','','','1975','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10589152-e2d6-4980-aea5-faf6b2beb7fd','','','Todea marginata Colenso',1,'Todea marginata','Todea marginata','Todea marginat',2,0,'','','Colenso','84ac6521-f71d-544f-8d29-e1694ff257d0','Todea marginata Colenso','Colenso','SPECIES','','Todea','','marginata','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10644619-43d1-4cea-b555-26b75ea0f854','','','Euphorbia characias subsp. wulfenii (Hoppe ex W.D.J.Koch) Radcl.-Sm.',1,'Euphorbia characias wulfenii','Euphorbia characias subsp. wulfenii','Euphorbia characi wulfen',3,0,'','','Hoppe|W. D. J. Koch|Radcl.-Sm.','fd78802f-d1e7-56a9-9474-049e03299678','Euphorbia characias subsp. wulfenii (Hoppe ex W.D.J.Koch) Radcl.-Sm.','(Hoppe ex W.D.J.Koch) Radcl.-Sm.','SUBSPECIES','','Euphorbia','','characias','wulfenii','','',NULL,'Radcl.-Sm.','','','','','Hoppe','','W. D. J. Koch','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10677f68-1749-4c5d-8589-891ad8b08178','','','Stilbum fimetarium (Pers.) Berk. & Broome',1,'Stilbum fimetarium','Stilbum fimetarium','Stilbum fimetari',2,0,'','','Pers.|Berk.|Broome','c9dcc17d-5b79-5baf-9c77-d88d86a8259c','Stilbum fimetarium (Pers.) Berk. & Broome','(Pers.) Berk. & Broome','SPECIES','','Stilbum','','fimetarium','','','',NULL,'Berk. & Broome','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10625f52-5855-4a0b-9eb6-c40c50667275','','','Rhizocarpon eupetraeum (Nyl.) Arnold',1,'Rhizocarpon eupetraeum','Rhizocarpon eupetraeum','Rhizocarpon eupetrae',2,0,'','','Nyl.|Arnold','99ed9f1a-bda0-567f-b90a-f1565f304527','Rhizocarpon eupetraeum (Nyl.) Arnold','(Nyl.) Arnold','SPECIES','','Rhizocarpon','','eupetraeum','','','',NULL,'Arnold','','','','','Nyl.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1067a983-923d-4add-8940-13b4786fd538','','','Andromeda pulverulenta W.Bartram ex Willd.',1,'Andromeda pulverulenta','Andromeda pulverulenta','Andromeda puluerulent',2,0,'','','W. Bartram|Willd.','be8694e9-1ac3-529c-bc61-d5e445289b63','Andromeda pulverulenta W.Bartram ex Willd.','W.Bartram ex Willd.','SPECIES','','Andromeda','','pulverulenta','','','',NULL,'','','','','','W. Bartram','','Willd.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1069a79f-f20f-4a9c-ab70-8da8636e9657','','','Cryptolaemus',1,'Cryptolaemus','Cryptolaemus','Cryptolaemus',1,0,'','','','9a6e9ef8-ea97-592e-8213-1ad16c08254f','Cryptolaemus','','GENUS','Cryptolaemus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('106b891d-4811-48e9-9175-d15f5390d6e3','','','Solariella',1,'Solariella','Solariella','Solariella',1,0,'','','','a32e7e46-1d32-5197-b23c-a25bf7e1b4e7','Solariella','','GENUS','Solariella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('106c0e6e-a278-4bf1-93cb-d9d00db897b8','','','Myopiarolis carinata (Bruce, 2008)',1,'Myopiarolis carinata','Myopiarolis carinata','Myopiarolis carinat',2,0,'','','Bruce','5e79bdc4-fb94-5927-b52f-8653a7e9e94c','Myopiarolis carinata (Bruce, 2008)','(Bruce, 2008)','SPECIES','','Myopiarolis','','carinata','','','',NULL,'','','','','','Bruce','','','','2008','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10707b26-50c4-4b3f-b642-14885337db20','','','Eucalyptus regnans F.Muell.',1,'Eucalyptus regnans','Eucalyptus regnans','Eucalyptus regnans',2,0,'','','F. Muell.','944f2e81-95db-5ea2-8d3c-75023f935dbb','Eucalyptus regnans F.Muell.','F.Muell.','SPECIES','','Eucalyptus','','regnans','','','',NULL,'','','','','','F. Muell.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10711b3a-849c-49e9-964a-52176171db0d','','','Pleurotus dryinus (Pers.) P. Kumm.',1,'Pleurotus dryinus','Pleurotus dryinus','Pleurotus dryin',2,0,'','','Pers.|P. Kumm.','363a7aa0-a398-573b-a955-6071b66ff438','Pleurotus dryinus (Pers.) P. Kumm.','(Pers.) P. Kumm.','SPECIES','','Pleurotus','','dryinus','','','',NULL,'P. Kumm.','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1071ef12-0cac-409f-b77a-b56905bbde85','','','Fenwickia Malloch, 1930',1,'Fenwickia','Fenwickia','Fenwickia',1,0,'','','Malloch','49fc6283-809f-518e-9ac9-53bfb900b763','Fenwickia Malloch, 1930','Malloch, 1930','GENUS','Fenwickia','','','','','','',NULL,'','','','','','Malloch','','','','1930','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('111100b4-e3f0-4f26-b15b-f7f29ed54e67','','','Cosmarium regnelli var. minimum B. Eichler & Gutw.',1,'Cosmarium regnelli minimum','Cosmarium regnelli var. minimum','Cosmarium regnell minim',3,0,'','','B. Eichler|Gutw.','32aacbfc-9de0-5078-ab4c-231a8227e0cb','Cosmarium regnelli var. minimum B. Eichler & Gutw.','B. Eichler & Gutw.','VARIETY','','Cosmarium','','regnelli','minimum','','',NULL,'','','','','','B. Eichler & Gutw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1118430d-b512-4652-b78a-19daa8da19d2','','','Lampanyctus species',4,'','','',NULL,NULL,'','','','','Lampanyctus species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('111ca8f3-a63d-43dd-81d5-351631fc0a59','','','Auloplax',1,'Auloplax','Auloplax','Auloplax',1,0,'','','','d28af3f1-5ac2-550b-9efc-f8685754755c','Auloplax','','GENUS','Auloplax','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('111c62df-4dfb-42a8-accc-60b7f8c953e7','','','Hyporhamma clavata (Pers.) Lado',1,'Hyporhamma clavata','Hyporhamma clavata','Hyporhamma clauat',2,0,'','','Pers.|Lado','d3ee5d2f-5778-5ce4-bb8f-8413ed4ebe11','Hyporhamma clavata (Pers.) Lado','(Pers.) Lado','SPECIES','','Hyporhamma','','clavata','','','',NULL,'Lado','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1119bd58-4067-41a2-a924-8c62ceb4a5cc','','','Oriopsis',1,'Oriopsis','Oriopsis','Oriopsis',1,0,'','','','dbecc6ea-4560-56d1-a194-b7b95f9b553a','Oriopsis','','GENUS','Oriopsis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('111386fa-8215-4b04-9d8b-9fdad569fcaa','','','Parmelia cinerea (L.) Hepp',1,'Parmelia cinerea','Parmelia cinerea','Parmelia cinere',2,0,'','','L.|Hepp','c0a70bc4-d76a-56fb-aead-8096aee94829','Parmelia cinerea (L.) Hepp','(L.) Hepp','SPECIES','','Parmelia','','cinerea','','','',NULL,'Hepp','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1112a28f-3626-466e-a398-bbe4ca2ca8a9','','','Sciacharis (Sciacharis) pseudowhangamoana (Franz, 1975)',1,'Sciacharis pseudowhangamoana','Sciacharis pseudowhangamoana','Sciacharis pseudowhangamoan',2,0,'','','Franz','57876559-1f55-57c7-80d0-c64798423b74','Sciacharis (Sciacharis) pseudowhangamoana (Franz, 1975)','(Franz, 1975)','SPECIES','','Sciacharis','Sciacharis','pseudowhangamoana','','','',NULL,'','','','','','Franz','','','','1975','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('111835ab-3a1d-4245-b363-df6e518066c9','','','Cossura consimilis Read, 2000',1,'Cossura consimilis','Cossura consimilis','Cossura consimil',2,0,'','','Read','d526a352-8d5a-5ded-aed8-fff387caa569','Cossura consimilis Read, 2000','Read, 2000','SPECIES','','Cossura','','consimilis','','','',NULL,'','','','','','Read','','','','2000','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('111dd1b1-830b-47b4-bbb1-18725d88b6de','','','Cintractia limosa var. minor Savile',1,'Cintractia limosa minor','Cintractia limosa var. minor','Cintractia limos minor',3,0,'','','Savile','594ae933-92c0-52db-8b8e-fbd3e2afd416','Cintractia limosa var. minor Savile','Savile','VARIETY','','Cintractia','','limosa','minor','','',NULL,'','','','','','Savile','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11229bb8-057f-4a60-baf9-6e41f67abc8b','','','Oochoristica',1,'Oochoristica','Oochoristica','Oochoristica',1,0,'','','','895a1d36-2cea-5c0b-ab89-4ad3408e8e03','Oochoristica','','GENUS','Oochoristica','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('111e7ecf-eb07-4f25-9d72-9b848c765e38','','','Bitoma vicina Sharp, 1876',1,'Bitoma vicina','Bitoma vicina','Bitoma uicin',2,0,'','','Sharp','e867951b-80f7-51e2-a1b6-6e857b090f36','Bitoma vicina Sharp, 1876','Sharp, 1876','SPECIES','','Bitoma','','vicina','','','',NULL,'','','','','','Sharp','','','','1876','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1127aa70-6f4c-4b58-a88a-13eea8f74479','','','Bovichtus variegatus Richardson, 1846',1,'Bovichtus variegatus','Bovichtus variegatus','Bovichtus uariegat',2,0,'','','Richardson','32b19b30-2d5d-5549-9a0f-5ff380a03ad4','Bovichtus variegatus Richardson, 1846','Richardson, 1846','SPECIES','','Bovichtus','','variegatus','','','',NULL,'','','','','','Richardson','','','','1846','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11273be3-b9d2-42a0-91cd-519d0dd5c627','','','Achelia australiensis Miers, 1884',1,'Achelia australiensis','Achelia australiensis','Achelia australiens',2,0,'','','Miers','d4c23e98-d672-5542-8691-d7f2f43c441e','Achelia australiensis Miers, 1884','Miers, 1884','SPECIES','','Achelia','','australiensis','','','',NULL,'','','','','','Miers','','','','1884','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('112758dc-dedf-4641-9e40-b2f5a4864abe','','','Disella rebeeveri Xue & Zhang, 2008',1,'Disella rebeeveri','Disella rebeeveri','Disella rebeeuer',2,0,'','','Xue|Zhang','cec6d7c9-cebf-5694-ac50-32a2579b9434','Disella rebeeveri Xue & Zhang, 2008','Xue & Zhang, 2008','SPECIES','','Disella','','rebeeveri','','','',NULL,'','','','','','Xue & Zhang','','','','2008','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('112c31b2-bfeb-4ed7-9871-24d705ea37fa','','','Babiana regia (G.J.Lewis) Goldblatt & J.C.Manning',1,'Babiana regia','Babiana regia','Babiana reg',2,0,'','','G. J. Lewis|Goldblatt|J. C. Manning','d2d29c55-b671-5b00-a128-3fc15676098e','Babiana regia (G.J.Lewis) Goldblatt & J.C.Manning','(G.J.Lewis) Goldblatt & J.C.Manning','SPECIES','','Babiana','','regia','','','',NULL,'Goldblatt & J. C. Manning','','','','','G. J. Lewis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11305905-fa8c-4962-80fa-8bc5376850ba','','','Amynthas hupeiensis (Michaelsen, 1895)',1,'Amynthas hupeiensis','Amynthas hupeiensis','Amynthas hupeiens',2,0,'','','Michaelsen','eaf9cc25-b821-59e4-96b7-45503c9b7671','Amynthas hupeiensis (Michaelsen, 1895)','(Michaelsen, 1895)','SPECIES','','Amynthas','','hupeiensis','','','',NULL,'','','','','','Michaelsen','','','','1895','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('112c68a7-5bb2-48ac-8c4b-c44b3e507cc7','','','Parvicellula Marshall, 1896',1,'Parvicellula','Parvicellula','Parvicellula',1,0,'','','Marshall','130ac652-3d1b-5817-87e6-5638a7c017be','Parvicellula Marshall, 1896','Marshall, 1896','GENUS','Parvicellula','','','','','','',NULL,'','','','','','Marshall','','','','1896','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1132244c-beae-4dc5-99cd-ffbef2466e4d','','','Urophorus',1,'Urophorus','Urophorus','Urophorus',1,0,'','','','dc6f6ddd-e0e9-5053-a2d1-51d835c94898','Urophorus','','GENUS','Urophorus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('113753da-487c-4185-b366-09c822e50e6c','','','Graphania nullifera (Walker, 1857)',1,'Graphania nullifera','Graphania nullifera','Graphania nullifer',2,0,'','','Walker','062b22e6-3590-5a53-9295-7efc525304f5','Graphania nullifera (Walker, 1857)','(Walker, 1857)','SPECIES','','Graphania','','nullifera','','','',NULL,'','','','','','Walker','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('113b603a-b5c8-462d-ab01-7994b21a0985','','','Cambridgea obscura Blest & Vink, 2000',1,'Cambridgea obscura','Cambridgea obscura','Cambridgea obscur',2,0,'','','Blest|Vink','07551770-66a7-5e00-b2e5-6d3a79682341','Cambridgea obscura Blest & Vink, 2000','Blest & Vink, 2000','SPECIES','','Cambridgea','','obscura','','','',NULL,'','','','','','Blest & Vink','','','','2000','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('113c7af5-011e-4efe-9593-a39935cbf7e0','','','Pilotrichum P.Beauv.',1,'Pilotrichum','Pilotrichum','Pilotrichum',1,0,'','','P. Beauv.','be9f0571-27cf-5dbf-864a-99d87fbf7d82','Pilotrichum P.Beauv.','P.Beauv.','GENUS','Pilotrichum','','','','','','',NULL,'','','','','','P. Beauv.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('113ad7c3-fec1-4ebf-8aee-f146717bc026','','','Limosella ciliata Colenso',1,'Limosella ciliata','Limosella ciliata','Limosella ciliat',2,0,'','','Colenso','0d0b63e8-6ec8-5507-a930-459142be1b69','Limosella ciliata Colenso','Colenso','SPECIES','','Limosella','','ciliata','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1137905e-31b4-4498-bb22-fcc8b2621f2f','','','Poecillastra schulzii Sollas, 1888',1,'Poecillastra schulzii','Poecillastra schulzii','Poecillastra schulz',2,0,'','','Sollas','ec10c381-c085-5fb8-bfda-cae2eb464514','Poecillastra schulzii Sollas, 1888','Sollas, 1888','SPECIES','','Poecillastra','','schulzii','','','',NULL,'','','','','','Sollas','','','','1888','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('113fc0d0-4760-4224-91f6-61224e48470b','','','Hoplodactylus kahutarae Whitaker, 1985',1,'Hoplodactylus kahutarae','Hoplodactylus kahutarae','Hoplodactylus kahutar',2,0,'','','Whitaker','0cdb79d0-68a9-5b87-8b83-873707e6f47c','Hoplodactylus kahutarae Whitaker, 1985','Whitaker, 1985','SPECIES','','Hoplodactylus','','kahutarae','','','',NULL,'','','','','','Whitaker','','','','1985','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('113d302b-93fb-4dbf-85c6-a7654384bfd4','','','Dilophus neoinsolitus Harrison, 1990',1,'Dilophus neoinsolitus','Dilophus neoinsolitus','Dilophus neoinsolit',2,0,'','','Harrison','0843f16c-214d-51c8-8615-bd8bd33537f9','Dilophus neoinsolitus Harrison, 1990','Harrison, 1990','SPECIES','','Dilophus','','neoinsolitus','','','',NULL,'','','','','','Harrison','','','','1990','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11416d06-95cc-4f87-b64d-ee85d8620352','','','Veronica macrocarpa Vahl',1,'Veronica macrocarpa','Veronica macrocarpa','Veronica macrocarp',2,0,'','','Vahl','a36a296a-d311-5c34-af9d-cfc798fd74dd','Veronica macrocarpa Vahl','Vahl','SPECIES','','Veronica','','macrocarpa','','','',NULL,'','','','','','Vahl','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1141c008-bd53-44d1-9748-f9c0e63d4514','','','Cladosporium modestum Syd.',1,'Cladosporium modestum','Cladosporium modestum','Cladosporium modest',2,0,'','','Syd.','54ae535a-916b-5fdb-a1f1-66da0dfcb2db','Cladosporium modestum Syd.','Syd.','SPECIES','','Cladosporium','','modestum','','','',NULL,'','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1146f7fc-0414-4295-8cab-19696d8dbffd','','','Nephrochytrium Karling',1,'Nephrochytrium','Nephrochytrium','Nephrochytrium',1,0,'','','Karling','ad56844d-347e-5a7a-aa5e-3b4447ff2a31','Nephrochytrium Karling','Karling','GENUS','Nephrochytrium','','','','','','',NULL,'','','','','','Karling','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1144c903-f4f1-473a-80cc-66c6ecfa28ec','','','Parmelia foraminulosa Kremp.',1,'Parmelia foraminulosa','Parmelia foraminulosa','Parmelia foraminulos',2,0,'','','Kremp.','26c3ee26-b073-5533-a41f-08f4875e46ad','Parmelia foraminulosa Kremp.','Kremp.','SPECIES','','Parmelia','','foraminulosa','','','',NULL,'','','','','','Kremp.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1143edc9-36cd-4263-9d75-a09a33f32d36','','','Calacarus',1,'Calacarus','Calacarus','Calacarus',1,0,'','','','f70ab093-4fc9-5788-8486-df79cdc7be9c','Calacarus','','GENUS','Calacarus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1149b9cb-0e60-4f73-91f6-b4dcdafe6112','','','Placopsis contortuplicata I.M.Lamb',1,'Placopsis contortuplicata','Placopsis contortuplicata','Placopsis contortuplicat',2,0,'','','I. M. Lamb','f957f11b-7587-5255-8a73-3e70031b8ead','Placopsis contortuplicata I.M.Lamb','I.M.Lamb','SPECIES','','Placopsis','','contortuplicata','','','',NULL,'','','','','','I. M. Lamb','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('114c0547-7d8e-4488-9719-0d3e72357202','','','Monospilus',1,'Monospilus','Monospilus','Monospilus',1,0,'','','','1c7acf47-eaae-5889-be9f-ca3c755eca8b','Monospilus','','GENUS','Monospilus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1152630f-3863-41c0-97f9-2a90c9b6f0f2','','','Streptomyces arenae Pridham et al. 1958',1,'Streptomyces arenae','Streptomyces arenae','Streptomyces aren',2,0,'','','Pridham et al.','16e78eb1-5241-5cc7-8360-9237e9f1e75a','Streptomyces arenae Pridham et al. 1958','Pridham et al. 1958','SPECIES','','Streptomyces','','arenae','','','',NULL,'','','','','','Pridham et al.','','','','1958','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('114addc8-08be-4d8a-ad71-865f05a13935','','','Saproamanita inopinata (D.A. Reid & Bas) Redhead, Vizzini, Drehmel & Contu',1,'Saproamanita inopinata','Saproamanita inopinata','Saproamanita inopinat',2,0,'','','D. A. Reid|Bas|Redhead|Vizzini|Drehmel|Contu','0a10b093-f72c-52e8-a990-153705871d6d','Saproamanita inopinata (D.A. Reid & Bas) Redhead, Vizzini, Drehmel & Contu','(D.A. Reid & Bas) Redhead, Vizzini, Drehmel & Contu','SPECIES','','Saproamanita','','inopinata','','','',NULL,'Redhead, Vizzini, Drehmel & Contu','','','','','D. A. Reid & Bas','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('115358ce-cbdc-41d6-afce-dab8a642e8b7','','','Tugali suteri',1,'Tugali suteri','Tugali suteri','Tugali suter',2,0,'','','','1e475ebd-d8df-5842-b7be-25090f087031','Tugali suteri','','SPECIES','','Tugali','','suteri','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1157e510-b80f-45de-a609-13f54795327c','','','Streptopelia roseogrisea (Sundevall, 1857)',1,'Streptopelia roseogrisea','Streptopelia roseogrisea','Streptopelia roseogrise',2,0,'','','Sundevall','a152e395-6051-5385-82fa-868134540b10','Streptopelia roseogrisea (Sundevall, 1857)','(Sundevall, 1857)','SPECIES','','Streptopelia','','roseogrisea','','','',NULL,'','','','','','Sundevall','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('115a4800-c231-4738-8917-58b395ae5325','','','Acanthuchus trispinifer (Fairmaire, 1846)',1,'Acanthuchus trispinifer','Acanthuchus trispinifer','Acanthuchus trispinifer',2,0,'','','Fairmaire','3b72c8b4-ec45-534a-8c2a-f84d2d4e658e','Acanthuchus trispinifer (Fairmaire, 1846)','(Fairmaire, 1846)','SPECIES','','Acanthuchus','','trispinifer','','','',NULL,'','','','','','Fairmaire','','','','1846','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11568b00-8b30-4ba3-903c-e28fb3ce2c26','','','Frustulia maoriana Lange-Bertalot & T.Beier',1,'Frustulia maoriana','Frustulia maoriana','Frustulia maorian',2,0,'','','Lange-Bertalot|T. Beier','0ef48f11-80fb-5f3f-9920-444adaebe527','Frustulia maoriana Lange-Bertalot & T.Beier','Lange-Bertalot & T.Beier','SPECIES','','Frustulia','','maoriana','','','',NULL,'','','','','','Lange-Bertalot & T. Beier','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('115f73e9-9d7e-45a6-be4a-7fe95e9f4ddb','','','Brachythecium oxycladon (Brid.) A.Jaeger',1,'Brachythecium oxycladon','Brachythecium oxycladon','Brachythecium oxycladon',2,0,'','','Brid.|A. Jaeger','c6787a1c-e131-531a-a593-57a818d77a68','Brachythecium oxycladon (Brid.) A.Jaeger','(Brid.) A.Jaeger','SPECIES','','Brachythecium','','oxycladon','','','',NULL,'A. Jaeger','','','','','Brid.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1164168d-ea25-47a0-919d-babe460d3585','','','Streptococcus uberis Diernhofer, 1932',1,'Streptococcus uberis','Streptococcus uberis','Streptococcus uber',2,0,'','','Diernhofer','e9f15be2-1ca0-5484-9487-f74613b761a2','Streptococcus uberis Diernhofer, 1932','Diernhofer, 1932','SPECIES','','Streptococcus','','uberis','','','',NULL,'','','','','','Diernhofer','','','','1932','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10753f0c-96cf-4fde-990c-d90375019b42','','','Evadne nordmanni Loven, 1836',1,'Evadne nordmanni','Evadne nordmanni','Evadne nordmann',2,0,'','','Loven','aaf862ca-deed-59c7-a86c-62225d3ff5b6','Evadne nordmanni Loven, 1836','Loven, 1836','SPECIES','','Evadne','','nordmanni','','','',NULL,'','','','','','Loven','','','','1836','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1076275e-262c-4426-8a19-3204d6978f20','','','Celmisia coriacea sensu Raoul',4,'','','',NULL,NULL,'','','','','Celmisia coriacea sensu Raoul','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('107a5d51-abec-4629-80a5-5754f0ea5ec6','','','Pholiota glutinosa (Massee) E. Horak',1,'Pholiota glutinosa','Pholiota glutinosa','Pholiota glutinos',2,0,'','','Massee|E. Horak','f3b1b7e9-098e-5967-9eb8-289083d107e1','Pholiota glutinosa (Massee) E. Horak','(Massee) E. Horak','SPECIES','','Pholiota','','glutinosa','','','',NULL,'E. Horak','','','','','Massee','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1075dbb6-857c-4e32-9356-e743dba9a524','','','Rytidosperma maculatum (Zotov) Connor & Edgar',1,'Rytidosperma maculatum','Rytidosperma maculatum','Rytidosperma maculat',2,0,'','','Zotov|Connor|Edgar','ae74ad38-3858-57b5-8b31-7693df0d6478','Rytidosperma maculatum (Zotov) Connor & Edgar','(Zotov) Connor & Edgar','SPECIES','','Rytidosperma','','maculatum','','','',NULL,'Connor & Edgar','','','','','Zotov','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('107ada9c-d7b3-48b1-854d-367354d9b02c','','','Chenopodium glaucum sensu A.Cunn.',4,'','','',NULL,NULL,'','','','','Chenopodium glaucum sensu A.Cunn.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('107b8a6a-329e-46f3-aa3a-53490e3b1585','','','Leptotarsus fuscolateratus (Alexander, 1922)',1,'Leptotarsus fuscolateratus','Leptotarsus fuscolateratus','Leptotarsus fuscolaterat',2,0,'','','Alexander','adaeb18d-09b4-58b0-ac8e-5adf7e1bc05a','Leptotarsus fuscolateratus (Alexander, 1922)','(Alexander, 1922)','SPECIES','','Leptotarsus','','fuscolateratus','','','',NULL,'','','','','','Alexander','','','','1922','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('107c455c-aceb-411b-ad79-e595c7dc258e','','','Myzaphis',1,'Myzaphis','Myzaphis','Myzaphis',1,0,'','','','095b76b6-bdb5-55c5-a423-bebef5808d87','Myzaphis','','GENUS','Myzaphis','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('107bdce6-e73c-442e-9718-e945d9f5fc7b','','','Pyrgiscilla otakauica Laws, 1937',1,'Pyrgiscilla otakauica','Pyrgiscilla otakauica','Pyrgiscilla otakauic',2,0,'','','Laws','e084f9e3-87de-5a16-80fa-9b260020e8ee','Pyrgiscilla otakauica Laws, 1937','Laws, 1937','SPECIES','','Pyrgiscilla','','otakauica','','','',NULL,'','','','','','Laws','','','','1937','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10830b24-538f-435a-af67-046662453bfa','','','Hippomenella gigantica Powell, 1967',1,'Hippomenella gigantica','Hippomenella gigantica','Hippomenella gigantic',2,0,'','','Powell','ca4541f2-e72f-5b40-8ac7-3c9976738911','Hippomenella gigantica Powell, 1967','Powell, 1967','SPECIES','','Hippomenella','','gigantica','','','',NULL,'','','','','','Powell','','','','1967','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10854a87-e8d5-4a9c-9f3b-308288d27418','','','Nephelolejeunea hispida (R.M.Schust.) L.Söderstr. & A.Hagborg',1,'Nephelolejeunea hispida','Nephelolejeunea hispida','Nephelolejeunea hispid',2,0,'','','R. M. Schust.|L. Söderstr.|A. Hagborg','2c6cd73e-8c6c-55ef-910d-df86e10622da','Nephelolejeunea hispida (R.M.Schust.) L.Söderstr. & A.Hagborg','(R.M.Schust.) L.Söderstr. & A.Hagborg','SPECIES','','Nephelolejeunea','','hispida','','','',NULL,'L. Söderstr. & A. Hagborg','','','','','R. M. Schust.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1087ac28-7099-4e93-9592-aa5971f49d1f','','','Tetraphis repanda Funck',1,'Tetraphis repanda','Tetraphis repanda','Tetraphis repand',2,0,'','','Funck','766e5f30-4038-5896-831b-c4847ea87c09','Tetraphis repanda Funck','Funck','SPECIES','','Tetraphis','','repanda','','','',NULL,'','','','','','Funck','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('108eeca7-bc06-49dc-ba80-1bf3886f3b68','','','Mibora Adans.',1,'Mibora','Mibora','Mibora',1,0,'','','Adans.','83a2e3c2-bf23-55ac-9014-1a6f83d4f03c','Mibora Adans.','Adans.','GENUS','Mibora','','','','','','',NULL,'','','','','','Adans.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('108d6408-2490-4e5b-9308-3cba61532647','','','Hypophyllum geminum Paulet',1,'Hypophyllum geminum','Hypophyllum geminum','Hypophyllum gemin',2,0,'','','Paulet','dd3eaa5f-a2e9-51f1-9bd1-72e90139ecd0','Hypophyllum geminum Paulet','Paulet','SPECIES','','Hypophyllum','','geminum','','','',NULL,'','','','','','Paulet','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('108d1af8-3fd4-45b0-b23a-c1e6751add1d','','','Agaricus myomyces var. pardinus Pers.',1,'Agaricus myomyces pardinus','Agaricus myomyces var. pardinus','Agaricus myomyc pardin',3,0,'','','Pers.','4e7374fb-fb64-5a2b-a8c4-b10725e4d17a','Agaricus myomyces var. pardinus Pers.','Pers.','VARIETY','','Agaricus','','myomyces','pardinus','','',NULL,'','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1092854a-e442-4d90-9f00-0e021b45abe9','','','Dolomedes dondalei Vink & Duperre, 2010',1,'Dolomedes dondalei','Dolomedes dondalei','Dolomedes dondale',2,0,'','','Vink|Duperre','a28a7787-6cc4-5328-90da-ce656937531b','Dolomedes dondalei Vink & Duperre, 2010','Vink & Duperre, 2010','SPECIES','','Dolomedes','','dondalei','','','',NULL,'','','','','','Vink & Duperre','','','','2010','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('109219a8-d74d-4f2f-9a20-59ecf8cf7f99','','','Cosmochthonius',1,'Cosmochthonius','Cosmochthonius','Cosmochthonius',1,0,'','','','48871e01-146b-5cf3-b7b6-c66d3fede3da','Cosmochthonius','','GENUS','Cosmochthonius','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10952cbf-ddfe-424d-9090-9dd07011974b','','','Myonera tasmanica (Knudsen, 1970)',1,'Myonera tasmanica','Myonera tasmanica','Myonera tasmanic',2,0,'','','Knudsen','806f28cb-4ec3-5170-b406-f37fafbe541d','Myonera tasmanica (Knudsen, 1970)','(Knudsen, 1970)','SPECIES','','Myonera','','tasmanica','','','',NULL,'','','','','','Knudsen','','','','1970','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1094ec5d-5712-4008-8902-e5fc34ea01c2','','','Pseudocamptoum citri Gonz. Frag. & Cif.',1,'Pseudocamptoum citri','Pseudocamptoum citri','Pseudocamptoum citr',2,0,'','','Gonz. Frag.|Cif.','a3e2ffc9-133e-521a-afe0-c503890fccdc','Pseudocamptoum citri Gonz. Frag. & Cif.','Gonz. Frag. & Cif.','SPECIES','','Pseudocamptoum','','citri','','','',NULL,'','','','','','Gonz. Frag. & Cif.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10904c12-2238-4f32-b343-fd5aee0655fe','','','Gelechia apparitella Walker, 1864',1,'Gelechia apparitella','Gelechia apparitella','Gelechia apparitell',2,0,'','','Walker','217da813-6dfb-5131-b22e-9d25eebf774a','Gelechia apparitella Walker, 1864','Walker, 1864','SPECIES','','Gelechia','','apparitella','','','',NULL,'','','','','','Walker','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1099b83c-ee99-4801-8eff-3e7dfb778dd8','','','Maoritenes Dugdale, 1966',1,'Maoritenes','Maoritenes','Maoritenes',1,0,'','','Dugdale','e7ec3c3a-70d0-5733-899a-b6d3ad3288ec','Maoritenes Dugdale, 1966','Dugdale, 1966','GENUS','Maoritenes','','','','','','',NULL,'','','','','','Dugdale','','','','1966','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1095939d-2cf4-4d25-b492-6d0cf4e9520a','','','Torula graminis Desm.',1,'Torula graminis','Torula graminis','Torula gramin',2,0,'','','Desm.','2680448b-4f99-5ca1-a140-27aa56b5e502','Torula graminis Desm.','Desm.','SPECIES','','Torula','','graminis','','','',NULL,'','','','','','Desm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('109ca4e9-2c67-4813-a855-8ae00fdc9f5d','','','Centropyxis platystoma (Penard, 1890)',1,'Centropyxis platystoma','Centropyxis platystoma','Centropyxis platystom',2,0,'','','Penard','75106a4e-6eac-528c-bae0-de4651f4c390','Centropyxis platystoma (Penard, 1890)','(Penard, 1890)','SPECIES','','Centropyxis','','platystoma','','','',NULL,'','','','','','Penard','','','','1890','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('109dee4f-39ce-406b-a8e4-f9f2129ecb19','','','Lasiosphaeria spermoides (Hoffm.) Ces. & De Not.',1,'Lasiosphaeria spermoides','Lasiosphaeria spermoides','Lasiosphaeria spermoid',2,0,'','','Hoffm.|Ces.|De Not.','ee307c35-2269-5823-a9db-655d97c6a29e','Lasiosphaeria spermoides (Hoffm.) Ces. & De Not.','(Hoffm.) Ces. & De Not.','SPECIES','','Lasiosphaeria','','spermoides','','','',NULL,'Ces. & De Not.','','','','','Hoffm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10a2dea6-5dec-487e-b161-69c197018fd1','','','Rhus vernicifera DC.',1,'Rhus vernicifera','Rhus vernicifera','Rhus uernicifer',2,0,'','','DC.','6d7fdcf8-1e8d-5a7a-a2cb-22c04150ee21','Rhus vernicifera DC.','DC.','SPECIES','','Rhus','','vernicifera','','','',NULL,'','','','','','DC.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10a4e468-53ae-4a39-b888-91425c3e7694','','','Culladia Moore, 1886',1,'Culladia','Culladia','Culladia',1,0,'','','Moore','ed52fa1a-4aed-50bf-b1e2-a9d2d52d9869','Culladia Moore, 1886','Moore, 1886','GENUS','Culladia','','','','','','',NULL,'','','','','','Moore','','','','1886','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10a44563-d810-4e58-be56-d3b41cb17ff0','','','Placopsis elixii D.J.Galloway',1,'Placopsis elixii','Placopsis elixii','Placopsis elix',2,0,'','','D. J. Galloway','bbb03d04-2718-53be-90b2-6947feb78774','Placopsis elixii D.J.Galloway','D.J.Galloway','SPECIES','','Placopsis','','elixii','','','',NULL,'','','','','','D. J. Galloway','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10aa40b0-7740-4729-a3a0-4223593bdf83','','','Helvella rubiginosa Dicks.',1,'Helvella rubiginosa','Helvella rubiginosa','Helvella rubiginos',2,0,'','','Dicks.','1cbdee1a-9310-5bd8-8472-dff0040e8297','Helvella rubiginosa Dicks.','Dicks.','SPECIES','','Helvella','','rubiginosa','','','',NULL,'','','','','','Dicks.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10a70d76-1de5-4ffc-89eb-a474a402a7ee','','','Ophiostoma species E Uzunovic et al.',4,'','','',NULL,NULL,'','','','','Ophiostoma species E Uzunovic et al.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10aadad5-8843-48fc-a0c9-b49e8a26ea88','','','Zoroaster planus Alcock, 1893',1,'Zoroaster planus','Zoroaster planus','Zoroaster plan',2,0,'','','Alcock','aac062e2-dbaa-52bc-a33f-6fc486a9a8fa','Zoroaster planus Alcock, 1893','Alcock, 1893','SPECIES','','Zoroaster','','planus','','','',NULL,'','','','','','Alcock','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10a7d9dd-758a-4d74-97d7-f920ddc64882','','','Anatoecus icterodes oloris Zlotorzycka, 1970',1,'Anatoecus icterodes oloris','Anatoecus icterodes oloris','Anatoecus icterod olor',3,0,'','','Zlotorzycka','6bb16cca-0e6d-5fce-8395-f8265537421f','Anatoecus icterodes oloris Zlotorzycka, 1970','Zlotorzycka, 1970','SUBSPECIES','','Anatoecus','','icterodes','oloris','','',NULL,'','','','','','Zlotorzycka','','','','1970','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10b3fcbc-f99f-485a-ae13-49bfca9a038c','','','Phaeocalicium asciiforme Tibell',1,'Phaeocalicium asciiforme','Phaeocalicium asciiforme','Phaeocalicium asciiform',2,0,'','','Tibell','f19756af-5e77-571d-b2d3-ed13c39d69b9','Phaeocalicium asciiforme Tibell','Tibell','SPECIES','','Phaeocalicium','','asciiforme','','','',NULL,'','','','','','Tibell','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10b48a26-0465-463c-be8d-793842c83fdd','','','Lobelia laxiflora subsp. angustifolia (A.DC.) Eakes & Lammers',1,'Lobelia laxiflora angustifolia','Lobelia laxiflora subsp. angustifolia','Lobelia laxiflor angustifol',3,0,'','','A. DC.|Eakes|Lammers','283c122c-0896-5583-a990-42c52a7c6e0c','Lobelia laxiflora subsp. angustifolia (A.DC.) Eakes & Lammers','(A.DC.) Eakes & Lammers','SUBSPECIES','','Lobelia','','laxiflora','angustifolia','','',NULL,'Eakes & Lammers','','','','','A. DC.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10b3250c-8559-4d07-8ef2-9af15dd83229','','','Catenomyces persicinus A.M. Hanson',1,'Catenomyces persicinus','Catenomyces persicinus','Catenomyces persicin',2,0,'','','A. M. Hanson','9b0b10f4-796f-5ef3-8b2c-b4c8f4cc609e','Catenomyces persicinus A.M. Hanson','A.M. Hanson','SPECIES','','Catenomyces','','persicinus','','','',NULL,'','','','','','A. M. Hanson','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10b1b473-dfd6-4c26-8b07-ee0f21afb280','','','Brevimyia pulverea (Parent, 1933)',1,'Brevimyia pulverea','Brevimyia pulverea','Brevimyia puluere',2,0,'','','Parent','82f2eb7b-e519-5f0e-9977-04ced929b056','Brevimyia pulverea (Parent, 1933)','(Parent, 1933)','SPECIES','','Brevimyia','','pulverea','','','',NULL,'','','','','','Parent','','','','1933','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10bc053d-fb4b-4540-9738-1586d91a6415','','','Lagenosolenia anteroalatiformis Albani & Yassini, 1995',1,'Lagenosolenia anteroalatiformis','Lagenosolenia anteroalatiformis','Lagenosolenia anteroalatiform',2,0,'','','Albani|Yassini','3eb685f2-4ed6-543d-b710-81fd80eb0041','Lagenosolenia anteroalatiformis Albani & Yassini, 1995','Albani & Yassini, 1995','SPECIES','','Lagenosolenia','','anteroalatiformis','','','',NULL,'','','','','','Albani & Yassini','','','','1995','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10bbc5e5-2ccd-4981-941a-a8852207c284','','','Meryta angustifolia',1,'Meryta angustifolia','Meryta angustifolia','Meryta angustifol',2,0,'','','','1e713bc2-6fb8-5c5c-8bf6-93464752bf6e','Meryta angustifolia','','SPECIES','','Meryta','','angustifolia','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13230eaa-be95-487a-9b90-cede71aded9c','','','Puccinia alboclava G.T.S. Baylis',1,'Puccinia alboclava','Puccinia alboclava','Puccinia alboclau',2,0,'','','G. T. S. Baylis','6ecd45f4-382a-5d6b-b9ce-aa3b049626f6','Puccinia alboclava G.T.S. Baylis','G.T.S. Baylis','SPECIES','','Puccinia','','alboclava','','','',NULL,'','','','','','G. T. S. Baylis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10b8343a-d6d7-44f6-ade9-fd7ec1a46dda','','','Megalaria subcarnea (Müll.Arg.) D.J.Galloway',1,'Megalaria subcarnea','Megalaria subcarnea','Megalaria subcarne',2,0,'','','Müll. Arg.|D. J. Galloway','426476e3-53c8-5e7c-9fae-b21dd34bfa9a','Megalaria subcarnea (Müll.Arg.) D.J.Galloway','(Müll.Arg.) D.J.Galloway','SPECIES','','Megalaria','','subcarnea','','','',NULL,'D. J. Galloway','','','','','Müll. Arg.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13278346-90a3-49c1-af3d-453d58017d1e','','','Polyporus vinctus Berk.',1,'Polyporus vinctus','Polyporus vinctus','Polyporus uinct',2,0,'','','Berk.','7a2730c9-d81d-589e-9b6b-9a1ad984d579','Polyporus vinctus Berk.','Berk.','SPECIES','','Polyporus','','vinctus','','','',NULL,'','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13240438-3300-44c0-bea8-94a54aee439e','','','Curvularia leonensis M.B. Ellis',1,'Curvularia leonensis','Curvularia leonensis','Curvularia leonens',2,0,'','','M. B. Ellis','78599d30-1a78-52bc-a74b-f14fc4667f3b','Curvularia leonensis M.B. Ellis','M.B. Ellis','SPECIES','','Curvularia','','leonensis','','','',NULL,'','','','','','M. B. Ellis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1327b25a-fdce-466f-8bf5-d6bab44ee070','','','Lavandula angustifolia ''Munstead''',1,'Lavandula angustifolia ‘Munstead’','Lavandula angustifolia ‘Munstead’','Lavandula angustifol ‘Munstead’',3,0,'','','','f039db7c-e285-5b34-a5e4-20690a976bbe','Lavandula angustifolia ''Munstead''','','CULTIVAR','','Lavandula','','angustifolia','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('132f357f-1629-474b-af89-373d7871c9b1','','','Quadraceps sellatus (Burmeister, 1838)',1,'Quadraceps sellatus','Quadraceps sellatus','Quadraceps sellat',2,0,'','','Burmeister','2f53872a-3b32-5af1-8d46-cafa1fa47cfa','Quadraceps sellatus (Burmeister, 1838)','(Burmeister, 1838)','SPECIES','','Quadraceps','','sellatus','','','',NULL,'','','','','','Burmeister','','','','1838','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('132947ca-9419-4d1a-9916-950711f0c936','','','Astelia linearis Hook.f. var. linearis',1,'Astelia linearis linearis','Astelia linearis var. linearis','Astelia linear linear',3,0,'','','','55031061-343c-5f9b-a659-73c4298242d9','Astelia linearis Hook.f. var. linearis','','VARIETY','','Astelia','','linearis','linearis','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('132bc35b-bec1-4f36-9a2d-c36e47631a46','','','Mycosphaerellopsis moravica Petr.',1,'Mycosphaerellopsis moravica','Mycosphaerellopsis moravica','Mycosphaerellopsis morauic',2,0,'','','Petr.','a8680103-8bc0-5a78-b04f-d23c3348158e','Mycosphaerellopsis moravica Petr.','Petr.','SPECIES','','Mycosphaerellopsis','','moravica','','','',NULL,'','','','','','Petr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('133008a7-d0db-45fd-b8da-f53b10e57c63','','','Sterigmatomyces Fell',1,'Sterigmatomyces','Sterigmatomyces','Sterigmatomyces',1,0,'','','Fell','00ad4572-756d-5d58-b651-7f55face1b10','Sterigmatomyces Fell','Fell','GENUS','Sterigmatomyces','','','','','','',NULL,'','','','','','Fell','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13284d99-f84f-4a82-baf0-fe569d79b4ea','','','Protanthea',1,'Protanthea','Protanthea','Protanthea',1,0,'','','','6ccf9d31-0778-5749-9991-6c13c021215b','Protanthea','','GENUS','Protanthea','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1337bdc7-4f76-4080-9073-1e94f8373da6','','','Cardamine uniflora (Hook.f.) Allan',1,'Cardamine uniflora','Cardamine uniflora','Cardamine uniflor',2,0,'','','Hook. fil.|Allan','b9d7b7fb-5d26-5946-a683-fd5eb52a5861','Cardamine uniflora (Hook.f.) Allan','(Hook.f.) Allan','SPECIES','','Cardamine','','uniflora','','','',NULL,'Allan','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13346e87-6721-4a3a-8232-343ba62c6ec8','','','Physcia stellaris (L.) Nyl.',1,'Physcia stellaris','Physcia stellaris','Physcia stellar',2,0,'','','L.|Nyl.','ed21dd7e-15d7-5792-a97b-bce975c5b253','Physcia stellaris (L.) Nyl.','(L.) Nyl.','SPECIES','','Physcia','','stellaris','','','',NULL,'Nyl.','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('133a1a98-91f7-447c-bc43-974153437c0d','','','Freyellaster',1,'Freyellaster','Freyellaster','Freyellaster',1,0,'','','','15fd63aa-b1bf-5cc9-b78a-d83a8b8ca2c2','Freyellaster','','GENUS','Freyellaster','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1336d611-935c-4b55-8596-a1a2184af991','','','Myerslopia',1,'Myerslopia','Myerslopia','Myerslopia',1,0,'','','','c8250e6b-d7f2-5b16-92f5-54f50f1d1055','Myerslopia','','GENUS','Myerslopia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13384471-f3ff-4a77-85f9-ca5aa7af6e31','','','Vanicela Walker, 1864',1,'Vanicela','Vanicela','Vanicela',1,0,'','','Walker','d85a9a54-a1cb-55bc-a173-332da57093a5','Vanicela Walker, 1864','Walker, 1864','GENUS','Vanicela','','','','','','',NULL,'','','','','','Walker','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('133c62ae-b3f5-4cd0-b840-184775c59a69','','','Rhinecanthus',1,'Rhinecanthus','Rhinecanthus','Rhinecanthus',1,0,'','','','70dde742-c121-5013-8f7c-3957a22dd459','Rhinecanthus','','GENUS','Rhinecanthus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('133efa80-c51a-497b-a3bd-2df69fdd90bc','','','Secotium cartilagineum G. Cunn.',1,'Secotium cartilagineum','Secotium cartilagineum','Secotium cartilagine',2,0,'','','G. Cunn.','76520f56-a186-513a-bfdd-9c6883fde6ac','Secotium cartilagineum G. Cunn.','G. Cunn.','SPECIES','','Secotium','','cartilagineum','','','',NULL,'','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('133dc97d-b300-4da6-a1a7-5ffebc859d77','','','Desulfovibrionaceae',1,'Desulfovibrionaceae','Desulfovibrionaceae','Desulfovibrionaceae',1,0,'','','','2abd2934-e7f2-52a0-ba77-59df08d93086','Desulfovibrionaceae','','FAMILY','Desulfovibrionaceae','','','','','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('133edb11-149f-4e85-91c0-94de4a62837f','','','Archeria traversii var. australis Hook.f.',1,'Archeria traversii australis','Archeria traversii var. australis','Archeria trauers austral',3,0,'','','Hook. fil.','65321f54-1adf-50de-8d13-f10d515bb766','Archeria traversii var. australis Hook.f.','Hook.f.','VARIETY','','Archeria','','traversii','australis','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('133f372f-9588-498f-8762-bb551576a3ee','','','Pediastrum angulosum (Ehrenb.) Menegh.',1,'Pediastrum angulosum','Pediastrum angulosum','Pediastrum angulos',2,0,'','','Ehrenb.|Menegh.','ec477165-5b6e-5551-8d07-87bc1c0f5df5','Pediastrum angulosum (Ehrenb.) Menegh.','(Ehrenb.) Menegh.','SPECIES','','Pediastrum','','angulosum','','','',NULL,'Menegh.','','','','','Ehrenb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('133d8e21-860a-4aaf-aa08-dfb1fec8dec4','','','Pseudocercospora samaneae U. Braun & Crous',1,'Pseudocercospora samaneae','Pseudocercospora samaneae','Pseudocercospora samane',2,0,'','','U. Braun|Crous','eb2b3c85-1790-5570-acdc-43e7ff738aaa','Pseudocercospora samaneae U. Braun & Crous','U. Braun & Crous','SPECIES','','Pseudocercospora','','samaneae','','','',NULL,'','','','','','U. Braun & Crous','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1344a3d5-d843-4d0b-a157-608cf8cbedbd','','','Uromyces salicorniae (DC.) de Bary',1,'Uromyces salicorniae','Uromyces salicorniae','Uromyces salicorni',2,0,'','','DC.|de Bary','3535ce7a-187c-5e07-b3c2-f76be93b9883','Uromyces salicorniae (DC.) de Bary','(DC.) de Bary','SPECIES','','Uromyces','','salicorniae','','','',NULL,'de Bary','','','','','DC.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1348416b-9916-42e0-bcf3-bce76f351f11','','','Ctenocidaris aotearoa McKnight, 1974',1,'Ctenocidaris aotearoa','Ctenocidaris aotearoa','Ctenocidaris aotearo',2,0,'','','McKnight','a0d68f89-aae3-5402-925f-37911e661ec7','Ctenocidaris aotearoa McKnight, 1974','McKnight, 1974','SPECIES','','Ctenocidaris','','aotearoa','','','',NULL,'','','','','','McKnight','','','','1974','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1349e386-9417-4469-b2f8-05e2b9b66a35','','','Gordoniaceae Rainey et al. 1997',1,'Gordoniaceae','Gordoniaceae','Gordoniaceae',1,0,'','','Rainey et al.','b82e4bab-fc6b-5b74-b479-3a955ac84c45','Gordoniaceae Rainey et al. 1997','Rainey et al. 1997','FAMILY','Gordoniaceae','','','','','','',NULL,'','','','','','Rainey et al.','','','','1997','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1349e255-aa82-4adc-a540-7aab5e3d0724','','','Vigna angularis (Willd.) Ohwi & Ohashi',1,'Vigna angularis','Vigna angularis','Vigna angular',2,0,'','','Willd.|Ohwi|Ohashi','6eb4dfbe-170a-5345-a831-a1f9c33419c7','Vigna angularis (Willd.) Ohwi & Ohashi','(Willd.) Ohwi & Ohashi','SPECIES','','Vigna','','angularis','','','',NULL,'Ohwi & Ohashi','','','','','Willd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('134d3767-d6db-4835-8f95-91f44ed99948','','','Adhaesozetidae',1,'Adhaesozetidae','Adhaesozetidae','Adhaesozetidae',1,0,'','','','223b737c-9b8e-50f5-b8ff-7bd402ada091','Adhaesozetidae','','FAMILY','Adhaesozetidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1349fe79-9e5e-48fd-8a5c-c5b59d8d632f','','','Porricondyla Rondani, 1840',1,'Porricondyla','Porricondyla','Porricondyla',1,0,'','','Rondani','01ac04b1-df3b-507d-91fd-dae2b44543e7','Porricondyla Rondani, 1840','Rondani, 1840','GENUS','Porricondyla','','','','','','',NULL,'','','','','','Rondani','','','','1840','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1352d5b6-8c68-4f20-9b7c-89d82b44b99a','','','Trichothyrina nigroannulata (J. Webster) J.P. Ellis',1,'Trichothyrina nigroannulata','Trichothyrina nigroannulata','Trichothyrina nigroannulat',2,0,'','','J. Webster|J. P. Ellis','64199a77-254b-5c51-a2e7-71010e204a33','Trichothyrina nigroannulata (J. Webster) J.P. Ellis','(J. Webster) J.P. Ellis','SPECIES','','Trichothyrina','','nigroannulata','','','',NULL,'J. P. Ellis','','','','','J. Webster','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('134fee60-6b85-4a84-9dab-bb487bb06537','','','Rhizocarpon viridiatrum (Wulfen) Körb.',1,'Rhizocarpon viridiatrum','Rhizocarpon viridiatrum','Rhizocarpon uiridiatr',2,0,'','','Wulfen|Körb.','4306cc55-06d3-5c39-bc20-98bf6c387579','Rhizocarpon viridiatrum (Wulfen) Körb.','(Wulfen) Körb.','SPECIES','','Rhizocarpon','','viridiatrum','','','',NULL,'Körb.','','','','','Wulfen','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('135149c1-17ae-4632-b2f0-eaf7705ff0af','','','Achlya treleaseana (Humphrey) Kauffman',1,'Achlya treleaseana','Achlya treleaseana','Achlya treleasean',2,0,'','','Humphrey|Kauffman','28d8b969-5e59-5759-836b-b1356669f67a','Achlya treleaseana (Humphrey) Kauffman','(Humphrey) Kauffman','SPECIES','','Achlya','','treleaseana','','','',NULL,'Kauffman','','','','','Humphrey','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13574ed4-3b21-43e6-9c3b-0667c1d376b7','','','Pseudocyphellaria jamesii D.J.Galloway',1,'Pseudocyphellaria jamesii','Pseudocyphellaria jamesii','Pseudocyphellaria iames',2,0,'','','D. J. Galloway','5b8d00ba-fd3b-5af8-85b5-e6a90b6366f1','Pseudocyphellaria jamesii D.J.Galloway','D.J.Galloway','SPECIES','','Pseudocyphellaria','','jamesii','','','',NULL,'','','','','','D. J. Galloway','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13588344-1154-447d-93e9-477bcbae9d6e','','','Polystichum vestitum subsp. sylvaticum (Diels) C.Chr.',1,'Polystichum vestitum sylvaticum','Polystichum vestitum subsp. sylvaticum','Polystichum uestit syluatic',3,0,'','','Diels|C. Chr.','3c2d3d22-cb79-5dc4-9d46-4ad049aa7739','Polystichum vestitum subsp. sylvaticum (Diels) C.Chr.','(Diels) C.Chr.','SUBSPECIES','','Polystichum','','vestitum','sylvaticum','','',NULL,'C. Chr.','','','','','Diels','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13590dfb-dc92-4ae5-8b5c-9b695e48e17f','','','Baltraella peterroyi Yassini & Jones, 1995',1,'Baltraella peterroyi','Baltraella peterroyi','Baltraella peterroy',2,0,'','','Yassini|Jones','b80ff001-6e4a-508e-a74c-52672b5bed6c','Baltraella peterroyi Yassini & Jones, 1995','Yassini & Jones, 1995','SPECIES','','Baltraella','','peterroyi','','','',NULL,'','','','','','Yassini & Jones','','','','1995','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1356f5f4-d850-44eb-833e-e51823426719','','','Cyphella discoidea Cooke',1,'Cyphella discoidea','Cyphella discoidea','Cyphella discoide',2,0,'','','Cooke','7d0eca2f-0972-5c47-aab1-e15c2e6f737e','Cyphella discoidea Cooke','Cooke','SPECIES','','Cyphella','','discoidea','','','',NULL,'','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('135ad85d-c046-41b5-8867-09f47810cc28','','','Septoriella hollandica Crous, Quaedvl. & Y. Marín',1,'Septoriella hollandica','Septoriella hollandica','Septoriella hollandic',2,0,'','','Crous|Quaedvl.|Y. Marín','d381f646-1b65-55e7-b994-5245040f5b5b','Septoriella hollandica Crous, Quaedvl. & Y. Marín','Crous, Quaedvl. & Y. Marín','SPECIES','','Septoriella','','hollandica','','','',NULL,'','','','','','Crous, Quaedvl. & Y. Marín','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('135a973f-53b8-4415-af46-85c1ec9fcaa6','','','Pelecanus conspicillatus Temminck, 1824',1,'Pelecanus conspicillatus','Pelecanus conspicillatus','Pelecanus conspicillat',2,0,'','','Temminck','129fd5d0-a45c-57cf-b9eb-74ffd4a8587e','Pelecanus conspicillatus Temminck, 1824','Temminck, 1824','SPECIES','','Pelecanus','','conspicillatus','','','',NULL,'','','','','','Temminck','','','','1824','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('135e22c4-a275-4612-a71c-c2fb3ee8de77','','','Oxytricha parallela Engelmann, 1862',1,'Oxytricha parallela','Oxytricha parallela','Oxytricha parallel',2,0,'','','Engelmann','2baa5ee1-98b5-5051-9c58-a37caaf8509d','Oxytricha parallela Engelmann, 1862','Engelmann, 1862','SPECIES','','Oxytricha','','parallela','','','',NULL,'','','','','','Engelmann','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13640bc3-4e32-451e-8c32-1c367e9e36d6','','','Ephydridae',1,'Ephydridae','Ephydridae','Ephydridae',1,0,'','','','b404b209-370d-5b0c-af08-0536657510a4','Ephydridae','','FAMILY','Ephydridae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1363e95e-774f-454a-99b2-3e5c6b7e64e7','','','Nephroma Ach.',1,'Nephroma','Nephroma','Nephroma',1,0,'','','Ach.','37e251e7-ebfa-5a17-8b97-b7f0c5cc3e98','Nephroma Ach.','Ach.','GENUS','Nephroma','','','','','','',NULL,'','','','','','Ach.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10bd990b-fd3a-4766-b7a7-99e6a45d40ff','','','Adelencyrtoides similis Noyes, 1988',1,'Adelencyrtoides similis','Adelencyrtoides similis','Adelencyrtoides simil',2,0,'','','Noyes','27e16f48-8893-5d36-bb3d-a6c35c2fc6db','Adelencyrtoides similis Noyes, 1988','Noyes, 1988','SPECIES','','Adelencyrtoides','','similis','','','',NULL,'','','','','','Noyes','','','','1988','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13612cfc-47fb-4e81-9138-cf06738f2ce5','','','Hypnum laxatum Mitt.',1,'Hypnum laxatum','Hypnum laxatum','Hypnum laxat',2,0,'','','Mitt.','3b0e3775-574d-56e7-b385-effcec1b9459','Hypnum laxatum Mitt.','Mitt.','SPECIES','','Hypnum','','laxatum','','','',NULL,'','','','','','Mitt.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10c4634a-d894-426e-a1b2-3566dd3784a2','','','Dictyographa cinerea (C.Knight & Mitt.) Müll.Arg.',1,'Dictyographa cinerea','Dictyographa cinerea','Dictyographa cinere',2,0,'','','C. Knight|Mitt.|Müll. Arg.','40b659c9-f1c8-5a97-8571-f2c50fca7e98','Dictyographa cinerea (C.Knight & Mitt.) Müll.Arg.','(C.Knight & Mitt.) Müll.Arg.','SPECIES','','Dictyographa','','cinerea','','','',NULL,'Müll. Arg.','','','','','C. Knight & Mitt.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10c060c7-ed68-4609-abb5-9804977ed0a8','','','Carrot motley dwarf',1,'Carrot motley dwarf','Carrot motley dwarf','Carrot motley dwarf',3,0,'','','','09bd0bd5-c999-5bd8-8d54-48e010683f1c','Carrot motley dwarf','','SPECIES','','Carrot','','motley','dwarf','','',NULL,'','','','','','','','','','','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10c2d5e0-ed06-41d0-bede-c2da24f3d4a0','','','Brada whiteavesii McIntosh, 1885',1,'Brada whiteavesii','Brada whiteavesii','Brada whiteaues',2,0,'','','McIntosh','92e42cde-395d-548e-90ab-5f87287a388d','Brada whiteavesii McIntosh, 1885','McIntosh, 1885','SPECIES','','Brada','','whiteavesii','','','',NULL,'','','','','','McIntosh','','','','1885','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10c954fb-3980-4f17-a159-277c6aedda7e','','','Dianema Rex',1,'Dianema','Dianema','Dianema',1,0,'','','Rex','6802d024-4a46-5aae-ab22-659ade812e1c','Dianema Rex','Rex','GENUS','Dianema','','','','','','',NULL,'','','','','','Rex','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10c84401-b529-4e75-ac5c-595144061992','','','Fusarium lycopersici Sacc.',1,'Fusarium lycopersici','Fusarium lycopersici','Fusarium lycopersic',2,0,'','','Sacc.','9f822a1e-4a11-5503-ba72-1cb6e3b91a07','Fusarium lycopersici Sacc.','Sacc.','SPECIES','','Fusarium','','lycopersici','','','',NULL,'','','','','','Sacc.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10c82cbd-b9a3-4754-84f6-b6156f2de5f2','','','Gelis cinctus (Linnaeus, 1758)',1,'Gelis cinctus','Gelis cinctus','Gelis cinct',2,0,'','','Linnaeus','629328d5-ca96-5cde-aad9-479ccc1b1c8d','Gelis cinctus (Linnaeus, 1758)','(Linnaeus, 1758)','SPECIES','','Gelis','','cinctus','','','',NULL,'','','','','','Linnaeus','','','','1758','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10c4ded4-4e4f-4a81-af29-e58a39bcf49b','','','Badhamia gracilis (T. Macbr.) T. Macbr.',1,'Badhamia gracilis','Badhamia gracilis','Badhamia gracil',2,0,'','','T. Macbr.','67ae7d2b-93ce-5ecc-8369-9814f13e701e','Badhamia gracilis (T. Macbr.) T. Macbr.','(T. Macbr.) T. Macbr.','SPECIES','','Badhamia','','gracilis','','','',NULL,'T. Macbr.','','','','','T. Macbr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10d14d9a-0108-4793-8ade-1b6ff3e0e6b7','','','Muehlenbeckia axillaris (Hook.f.) Endl.',1,'Muehlenbeckia axillaris','Muehlenbeckia axillaris','Muehlenbeckia axillar',2,0,'','','Hook. fil.|Endl.','c5c49076-430e-5fe1-b60d-c9891df329ad','Muehlenbeckia axillaris (Hook.f.) Endl.','(Hook.f.) Endl.','SPECIES','','Muehlenbeckia','','axillaris','','','',NULL,'Endl.','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10cbf7f8-a098-423e-8e29-5de8d615dab7','','','Carex dipsacea Berggr.',1,'Carex dipsacea','Carex dipsacea','Carex dipsace',2,0,'','','Berggr.','dbe76717-8f16-5feb-aa31-2723faa78ff8','Carex dipsacea Berggr.','Berggr.','SPECIES','','Carex','','dipsacea','','','',NULL,'','','','','','Berggr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10cee6c1-a710-4b9a-a8ac-69d2128bb685','','','Cilicaea',1,'Cilicaea','Cilicaea','Cilicaea',1,0,'','','','cfb8e78b-9a9f-5472-ac58-84b8b95e9c7e','Cilicaea','','GENUS','Cilicaea','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10ce9506-1723-49f7-a9a3-79c08579f9f6','','','Ramularia senecionis (Berk. & Broome) Sacc.',1,'Ramularia senecionis','Ramularia senecionis','Ramularia senecion',2,0,'','','Berk.|Broome|Sacc.','b45f7829-e55b-5be2-975f-3cb2b6a41844','Ramularia senecionis (Berk. & Broome) Sacc.','(Berk. & Broome) Sacc.','SPECIES','','Ramularia','','senecionis','','','',NULL,'Sacc.','','','','','Berk. & Broome','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10daa827-ba57-461c-b232-606096bb4a9a','','','Sporisorium penniseticola Vánky',1,'Sporisorium penniseticola','Sporisorium penniseticola','Sporisorium penniseticol',2,0,'','','Vánky','1b9cc1f6-c11c-5ac2-b7ae-478d95e4dddd','Sporisorium penniseticola Vánky','Vánky','SPECIES','','Sporisorium','','penniseticola','','','',NULL,'','','','','','Vánky','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10d9fa7f-d18e-4c43-9eec-cf1e88b773a6','','','Xenodidymella Q. Chen & L. Cai',1,'Xenodidymella','Xenodidymella','Xenodidymella',1,0,'','','Q. Chen|L. Cai','d0d634a0-7094-567f-acdb-db039630639b','Xenodidymella Q. Chen & L. Cai','Q. Chen & L. Cai','GENUS','Xenodidymella','','','','','','',NULL,'','','','','','Q. Chen & L. Cai','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10dcfe19-3ac5-4a49-ac5c-06833843fbde','','','Cliopsis krohni Troschel, 1854',1,'Cliopsis krohni','Cliopsis krohni','Cliopsis krohn',2,0,'','','Troschel','717c3b44-dfeb-579a-8094-55f65c4a55ca','Cliopsis krohni Troschel, 1854','Troschel, 1854','SPECIES','','Cliopsis','','krohni','','','',NULL,'','','','','','Troschel','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10df5d0d-1356-467e-b053-4ca0a147cfa3','','','Hypocrea novozealandica Dingley',1,'Hypocrea novozealandica','Hypocrea novozealandica','Hypocrea nouozealandic',2,0,'','','Dingley','672829ea-bd39-582b-ba6f-94dd6ed4f3e9','Hypocrea novozealandica Dingley','Dingley','SPECIES','','Hypocrea','','novozealandica','','','',NULL,'','','','','','Dingley','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10e0102f-2bd7-406f-bc4e-cb427db34f14','','','Puccinia dulichii Syd.',1,'Puccinia dulichii','Puccinia dulichii','Puccinia dulich',2,0,'','','Syd.','03cca319-c678-50f6-a847-fb6a6e0f1498','Puccinia dulichii Syd.','Syd.','SPECIES','','Puccinia','','dulichii','','','',NULL,'','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10e0547c-3d0b-42e1-8688-eea247994d80','','','Phaeosaces Meyrick, 1885',1,'Phaeosaces','Phaeosaces','Phaeosaces',1,0,'','','Meyrick','5d5bcdeb-bd85-522a-a371-dcc5aa7a0619','Phaeosaces Meyrick, 1885','Meyrick, 1885','GENUS','Phaeosaces','','','','','','',NULL,'','','','','','Meyrick','','','','1885','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10e4e7cc-7c66-4d6c-bfd6-2709ee0bf9b6','','','Menegazzia kantvilasii P.James',1,'Menegazzia kantvilasii','Menegazzia kantvilasii','Menegazzia kantuilas',2,0,'','','P. James','a9698447-b244-5586-a12f-6cd308f3dabb','Menegazzia kantvilasii P.James','P.James','SPECIES','','Menegazzia','','kantvilasii','','','',NULL,'','','','','','P. James','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10eb8517-761d-4448-8219-82f499b68ef3','','','Davallia multiflora Roxb.',1,'Davallia multiflora','Davallia multiflora','Davallia multiflor',2,0,'','','Roxb.','812e34ce-34b7-578b-989f-620f48e168fa','Davallia multiflora Roxb.','Roxb.','SPECIES','','Davallia','','multiflora','','','',NULL,'','','','','','Roxb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10e738e9-7b9e-477c-b322-a3f486ebbb1a','','','Wuchereria bancrofti (Cobbold, 1877)',1,'Wuchereria bancrofti','Wuchereria bancrofti','Wuchereria bancroft',2,0,'','','Cobbold','c15c6af9-454e-57cb-9d61-dc073714bcfb','Wuchereria bancrofti (Cobbold, 1877)','(Cobbold, 1877)','SPECIES','','Wuchereria','','bancrofti','','','',NULL,'','','','','','Cobbold','','','','1877','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10e9f0dc-8a2f-4671-b15c-fac3e205b07b','','','Fissurina malcolmsonii (Wright, 1911)',1,'Fissurina malcolmsonii','Fissurina malcolmsonii','Fissurina malcolmson',2,0,'','','Wright','85bc5a44-655f-5960-a435-e7f322255af0','Fissurina malcolmsonii (Wright, 1911)','(Wright, 1911)','SPECIES','','Fissurina','','malcolmsonii','','','',NULL,'','','','','','Wright','','','','1911','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10f2ce01-c24e-4450-91ef-5471df2f0f07','','','Coryneaceae Corda',1,'Coryneaceae','Coryneaceae','Coryneaceae',1,0,'','','Corda','20333d59-03db-59e2-a1f9-523e48abd86e','Coryneaceae Corda','Corda','FAMILY','Coryneaceae','','','','','','',NULL,'','','','','','Corda','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10f1964e-88cb-498b-80cf-a91b029e3661','','','Ciocalypta species 2 Kelly & Wilkinson, 2000',4,'','','',NULL,NULL,'','','','','Ciocalypta species 2 Kelly & Wilkinson, 2000','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10eeedd2-8e54-4479-92f9-abd32f4fd6bd','','','Schoenoplectus lacustris (L.) Palla',1,'Schoenoplectus lacustris','Schoenoplectus lacustris','Schoenoplectus lacustr',2,0,'','','L.|Palla','70f4e2bd-1d29-5ddd-8a2b-c2d06383af48','Schoenoplectus lacustris (L.) Palla','(L.) Palla','SPECIES','','Schoenoplectus','','lacustris','','','',NULL,'Palla','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10f27bb4-bc29-497d-ba96-e15b80ad8799','','','Capronia pilosella (P. Karst.) E. Müll., L.E. Petrini, P.J. Fisher, Samuels & Rossman',1,'Capronia pilosella','Capronia pilosella','Capronia pilosell',2,0,'','','P. Karst.|E. Müll.|L. E. Petrini|P. J. Fisher|Samuels|Rossman','ca9676d3-5c2c-5549-8b3a-d18aec621f6d','Capronia pilosella (P. Karst.) E. Müll., L.E. Petrini, P.J. Fisher, Samuels & Rossman','(P. Karst.) E. Müll., L.E. Petrini, P.J. Fisher, Samuels & Rossman','SPECIES','','Capronia','','pilosella','','','',NULL,'E. Müll., L. E. Petrini, P. J. Fisher, Samuels & Rossman','','','','','P. Karst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10fdf8d4-bdef-4dfa-a8a3-cbc5b2e48c2b','','','Herzogianthus vaginatus (Herzog) R.M.Schust.',1,'Herzogianthus vaginatus','Herzogianthus vaginatus','Herzogianthus uaginat',2,0,'','','Herzog|R. M. Schust.','7a128447-b802-5d5b-8971-8e2971fa92b6','Herzogianthus vaginatus (Herzog) R.M.Schust.','(Herzog) R.M.Schust.','SPECIES','','Herzogianthus','','vaginatus','','','',NULL,'R. M. Schust.','','','','','Herzog','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('10fc58ef-bd47-4508-ab41-ff71eee58f84','','','Neogrollea E.A.Hodgs.',1,'Neogrollea','Neogrollea','Neogrollea',1,0,'','','E. A. Hodgs.','b4b94665-8e0d-560e-8772-93ef5fd00829','Neogrollea E.A.Hodgs.','E.A.Hodgs.','GENUS','Neogrollea','','','','','','',NULL,'','','','','','E. A. Hodgs.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1104c3cd-e078-46b3-bf03-740ad5950897','','','Agaricus praeclaresquamosus A.E. Freeman',1,'Agaricus praeclaresquamosus','Agaricus praeclaresquamosus','Agaricus praeclaresquamos',2,0,'','','A. E. Freeman','6556b23f-311b-584e-9816-abe15c30e0e1','Agaricus praeclaresquamosus A.E. Freeman','A.E. Freeman','SPECIES','','Agaricus','','praeclaresquamosus','','','',NULL,'','','','','','A. E. Freeman','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1103734a-b1b6-48d2-8213-e4d65aed10e3','','','Gonioctenina',1,'Gonioctenina','Gonioctenina','Gonioctenina',1,0,'','','','89ebcc31-f29a-594d-8290-fb39080070d9','Gonioctenina','','SUBTRIBE','Gonioctenina','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1100d51a-65b4-46e9-8696-fe0c89cded2a','','','Desmodesmus spinosus (Chodat) E.H. Hegew.',1,'Desmodesmus spinosus','Desmodesmus spinosus','Desmodesmus spinos',2,0,'','','Chodat|E. H. Hegew.','e6722968-edc1-546d-a974-e6fafa22cc7c','Desmodesmus spinosus (Chodat) E.H. Hegew.','(Chodat) E.H. Hegew.','SPECIES','','Desmodesmus','','spinosus','','','',NULL,'E. H. Hegew.','','','','','Chodat','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('110be8ef-c310-4094-adcb-d6a61e79d659','','','Haastia recurva Hook.f. var. recurva',1,'Haastia recurva recurva','Haastia recurva var. recurva','Haastia recuru recuru',3,0,'','','','47b68331-aa85-5f8b-9a26-38bcfd8a960a','Haastia recurva Hook.f. var. recurva','','VARIETY','','Haastia','','recurva','recurva','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('110e994e-f506-4d13-ac9b-e9a01a5d9320','','','Nephelolejeunea secunda M.A.M.Renner ex L.Söderstr. & A.Hagborg',1,'Nephelolejeunea secunda','Nephelolejeunea secunda','Nephelolejeunea secund',2,0,'','','M. A. M. Renner|L. Söderstr.|A. Hagborg','67480862-49a0-532b-af17-b7fda0714c17','Nephelolejeunea secunda M.A.M.Renner ex L.Söderstr. & A.Hagborg','M.A.M.Renner ex L.Söderstr. & A.Hagborg','SPECIES','','Nephelolejeunea','','secunda','','','',NULL,'','','','','','M. A. M. Renner','','L. Söderstr. & A. Hagborg','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12dedc7b-e1be-4c80-8d01-80f07f3d6483','','','Opalinales',1,'Opalinales','Opalinales','Opalinales',1,0,'','','','12840462-cc38-50d1-a6ad-cc21b4e6e80c','Opalinales','','ORDER','Opalinales','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12d8df1e-383a-4ffd-b693-83d0c177082e','','','Drepanopeziza fuckelii Nannf.',1,'Drepanopeziza fuckelii','Drepanopeziza fuckelii','Drepanopeziza fuckel',2,0,'','','Nannf.','dad31209-b0e9-57aa-aca9-9c2082395752','Drepanopeziza fuckelii Nannf.','Nannf.','SPECIES','','Drepanopeziza','','fuckelii','','','',NULL,'','','','','','Nannf.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12d7df20-dd2c-4ce4-b398-b812242967f0','','','Zalipais',1,'Zalipais','Zalipais','Zalipais',1,0,'','','','cd3b0c15-ace0-54fe-87fe-a8a6117da253','Zalipais','','GENUS','Zalipais','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12df0534-8e11-406a-a898-ecd0c2330c39','','','Striatellaceae',1,'Striatellaceae','Striatellaceae','Striatellaceae',1,0,'','','','0d54c2ff-dda3-5f49-95c6-ce6c7a693a11','Striatellaceae','','FAMILY','Striatellaceae','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12e68660-ab03-4474-ad6d-05dc8b498e3e','','','Cleidothaerus albidus (Lamarck, 1819)',1,'Cleidothaerus albidus','Cleidothaerus albidus','Cleidothaerus albid',2,0,'','','Lamarck','1a1db21e-7b75-5be3-b80c-3f1a9be681ee','Cleidothaerus albidus (Lamarck, 1819)','(Lamarck, 1819)','SPECIES','','Cleidothaerus','','albidus','','','',NULL,'','','','','','Lamarck','','','','1819','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12e35c5d-b168-4cf2-8b36-5db3085142ea','','','Mariannaea catenulatae (Samuels) L. Lombard & Crous',1,'Mariannaea catenulatae','Mariannaea catenulatae','Mariannaea catenulat',2,0,'','','Samuels|L. Lombard|Crous','b0871c36-5304-53f8-8b0c-c955ce530fee','Mariannaea catenulatae (Samuels) L. Lombard & Crous','(Samuels) L. Lombard & Crous','SPECIES','','Mariannaea','','catenulatae','','','',NULL,'L. Lombard & Crous','','','','','Samuels','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12e3d5bc-b1cb-422c-a951-dbc086fe41f7','','','Cortinarius sect. Rozites',2,'Rozites','Cortinarius sect. Rozites','Rozites',1,0,'','','','2bcf2712-7ee2-512d-9ee7-0502d32efc63','Cortinarius sect. Rozites','','SECTION','Rozites','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12e73926-e9f0-43d8-990a-0f41ad63a64e','','','Philacta',1,'Philacta','Philacta','Philacta',1,0,'','','','ee14f033-4ee4-5182-9825-caee0b94bad9','Philacta','','GENUS','Philacta','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12e95485-dba8-4d2a-8317-2979310d4b85','','','Austrosimulium laticorne Tonnoir, 1925',1,'Austrosimulium laticorne','Austrosimulium laticorne','Austrosimulium laticorn',2,0,'','','Tonnoir','db4e4086-55d7-53bd-91af-5483df842cee','Austrosimulium laticorne Tonnoir, 1925','Tonnoir, 1925','SPECIES','','Austrosimulium','','laticorne','','','',NULL,'','','','','','Tonnoir','','','','1925','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12e7660a-ecb9-4a30-981f-6cb2e2f9deab','','','Cintractia carpophila (Schumach.) Liro var. carpophila',1,'Cintractia carpophila carpophila','Cintractia carpophila var. carpophila','Cintractia carpophil carpophil',3,0,'','','','289e268c-6691-5f3f-8cdf-b2b7e4c7dcd2','Cintractia carpophila (Schumach.) Liro var. carpophila','','VARIETY','','Cintractia','','carpophila','carpophila','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12ec347b-3edc-45ef-bdc8-b3cecf8f2f33','','','Deconica subcoprophila (Britzelm.) E. Horak',1,'Deconica subcoprophila','Deconica subcoprophila','Deconica subcoprophil',2,0,'','','Britzelm.|E. Horak','5a01a01d-1ad1-5dc9-849f-d9809171f529','Deconica subcoprophila (Britzelm.) E. Horak','(Britzelm.) E. Horak','SPECIES','','Deconica','','subcoprophila','','','',NULL,'E. Horak','','','','','Britzelm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12ed4524-7799-4a75-ad4a-109e7ad6b609','','','Chalepistes compressus (Broun, 1880)',1,'Chalepistes compressus','Chalepistes compressus','Chalepistes compress',2,0,'','','Broun','9aeee02e-b7a5-5819-b0dc-fdd9983e8639','Chalepistes compressus (Broun, 1880)','(Broun, 1880)','SPECIES','','Chalepistes','','compressus','','','',NULL,'','','','','','Broun','','','','1880','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12f37d20-222e-4b3d-9bc2-2db2e59ef160','','','Splendrillia larochei Powell, 1940',1,'Splendrillia larochei','Splendrillia larochei','Splendrillia laroche',2,0,'','','Powell','f32f8c87-54dc-5620-bfd6-5eebf8b51bcc','Splendrillia larochei Powell, 1940','Powell, 1940','SPECIES','','Splendrillia','','larochei','','','',NULL,'','','','','','Powell','','','','1940','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12ece8bb-eb1b-4bc5-87c5-822b114a799b','','','Dictyocladium amplexum Vervoort & Watson, 2003',1,'Dictyocladium amplexum','Dictyocladium amplexum','Dictyocladium amplex',2,0,'','','Vervoort|Watson','5c6f3f77-5e05-5435-820a-5245265c5447','Dictyocladium amplexum Vervoort & Watson, 2003','Vervoort & Watson, 2003','SPECIES','','Dictyocladium','','amplexum','','','',NULL,'','','','','','Vervoort & Watson','','','','2003','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12fb226c-b8c2-4635-a0d2-00279b45d44f','','','Arenariomyces trifurcatus Höhnk',1,'Arenariomyces trifurcatus','Arenariomyces trifurcatus','Arenariomyces trifurcat',2,0,'','','Höhnk','4c633d64-c695-5fa7-9b36-5a544bd1d975','Arenariomyces trifurcatus Höhnk','Höhnk','SPECIES','','Arenariomyces','','trifurcatus','','','',NULL,'','','','','','Höhnk','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12fcd6da-25f8-4277-a01c-6975e0064904','','','Dictamnus L.',1,'Dictamnus','Dictamnus','Dictamnus',1,0,'','','L.','daffbd5a-5a23-5af3-bc3a-23021253eec9','Dictamnus L.','L.','GENUS','Dictamnus','','','','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12f75347-3312-42b6-a833-abf28920f649','','','Bambusa pubescens Pradelle',1,'Bambusa pubescens','Bambusa pubescens','Bambusa pubescens',2,0,'','','Pradelle','92c96310-65d9-5ae8-9be4-c1a6c2c24826','Bambusa pubescens Pradelle','Pradelle','SPECIES','','Bambusa','','pubescens','','','',NULL,'','','','','','Pradelle','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12f69d04-0219-43c9-8cfd-ce9b7ca68739','','','Amplexograptus ingens wellingtonensis (Harris & Thomas, 1955)',1,'Amplexograptus ingens wellingtonensis','Amplexograptus ingens wellingtonensis','Amplexograptus ingens wellingtonens',3,0,'','','Harris|Thomas','ea9df44b-d858-5dfa-94fa-7217827aa9c6','Amplexograptus ingens wellingtonensis (Harris & Thomas, 1955)','(Harris & Thomas, 1955)','SUBSPECIES','','Amplexograptus','','ingens','wellingtonensis','','',NULL,'','','','','','Harris & Thomas','','','','1955','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1302d894-ed2d-4467-961e-1a92862b374a','','','Lachnella gallica P. Karst. & Har.',1,'Lachnella gallica','Lachnella gallica','Lachnella gallic',2,0,'','','P. Karst.|Har.','0d40761a-0336-5904-82bf-c4759a7c940a','Lachnella gallica P. Karst. & Har.','P. Karst. & Har.','SPECIES','','Lachnella','','gallica','','','',NULL,'','','','','','P. Karst. & Har.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1300937e-a8e1-4e50-beee-7c8b8bf0323c','','','Nepenthes macrovulgaris J.R.Turnbull & A.T.Middleton',1,'Nepenthes macrovulgaris','Nepenthes macrovulgaris','Nepenthes macrouulgar',2,0,'','','J. R. Turnbull|A. T. Middleton','e1fa70f1-bcc5-5f25-a7d2-5313e998a0c1','Nepenthes macrovulgaris J.R.Turnbull & A.T.Middleton','J.R.Turnbull & A.T.Middleton','SPECIES','','Nepenthes','','macrovulgaris','','','',NULL,'','','','','','J. R. Turnbull & A. T. Middleton','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1303d4b7-22d5-4c6d-ab87-5855c35c261b','','','Bryaxis crassicornis Motschulsky, 1852',1,'Bryaxis crassicornis','Bryaxis crassicornis','Bryaxis crassicorn',2,0,'','','Motschulsky','a6bd6d49-fdf8-5ca0-af9b-baad8edc76f0','Bryaxis crassicornis Motschulsky, 1852','Motschulsky, 1852','SPECIES','','Bryaxis','','crassicornis','','','',NULL,'','','','','','Motschulsky','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13042a20-4e76-48b1-b6dd-a3bf95db36ec','','','Prunus cerasifera ''Atropurpurea''',1,'Prunus cerasifera ‘Atropurpurea’','Prunus cerasifera ‘Atropurpurea’','Prunus cerasifer ‘Atropurpurea’',3,0,'','','','293cf570-1b3c-5a53-9586-7ecb3d5121bc','Prunus cerasifera ''Atropurpurea''','','CULTIVAR','','Prunus','','cerasifera','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1305a2a8-b10f-4898-be85-c0432b7021f9','','','Astelia nervosa Hook.f.',1,'Astelia nervosa','Astelia nervosa','Astelia neruos',2,0,'','','Hook. fil.','5aee02b9-98d4-58ec-9c0a-3972ebacc9fc','Astelia nervosa Hook.f.','Hook.f.','SPECIES','','Astelia','','nervosa','','','',NULL,'','','','','','Hook. fil.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('130b9222-e109-4e69-aa6d-0dabcb00f54c','','','Puccinia coaetanea Bubák',1,'Puccinia coaetanea','Puccinia coaetanea','Puccinia coaetane',2,0,'','','Bubák','ff155ba6-304e-5bba-8ea2-4d01d2025d0e','Puccinia coaetanea Bubák','Bubák','SPECIES','','Puccinia','','coaetanea','','','',NULL,'','','','','','Bubák','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('130cdc3a-ab78-49ad-9a2f-4e8ef6fedda7','','','Rytidosperma biannulare (Zotov) Connor & Edgar',1,'Rytidosperma biannulare','Rytidosperma biannulare','Rytidosperma biannular',2,0,'','','Zotov|Connor|Edgar','172632b4-47d1-5893-8ada-d08170ed6b3a','Rytidosperma biannulare (Zotov) Connor & Edgar','(Zotov) Connor & Edgar','SPECIES','','Rytidosperma','','biannulare','','','',NULL,'Connor & Edgar','','','','','Zotov','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('130edb85-1dfa-4637-9a43-a0d0d7e4b35b','','','Mesadenocoris robustus Kirman, 1985',1,'Mesadenocoris robustus','Mesadenocoris robustus','Mesadenocoris robust',2,0,'','','Kirman','fed4ea03-5e94-5a50-a4f3-618a2a979ccd','Mesadenocoris robustus Kirman, 1985','Kirman, 1985','SPECIES','','Mesadenocoris','','robustus','','','',NULL,'','','','','','Kirman','','','','1985','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('130b6a79-89f6-4a38-b1ec-dfcd43e711b1','','','Nuncia (Corinuncia) coriacea coriacea (Pocock, 1903)',1,'Nuncia coriacea coriacea','Nuncia coriacea coriacea','Nuncia coriace coriace',3,0,'','','Pocock','89586d83-a8c2-55a9-a4a1-fc5732c48a09','Nuncia (Corinuncia) coriacea coriacea (Pocock, 1903)','(Pocock, 1903)','SUBSPECIES','','Nuncia','','coriacea','coriacea','','',NULL,'','','','','','Pocock','','','','1903','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('131696ea-f352-4d20-8b8f-0d99ccc5ec42','','','Aedes antipodeus (Edwards, 1920)',1,'Aedes antipodeus','Aedes antipodeus','Aedes antipode',2,0,'','','Edwards','47591a20-9c9b-5799-a3d4-89fff6a3b842','Aedes antipodeus (Edwards, 1920)','(Edwards, 1920)','SPECIES','','Aedes','','antipodeus','','','',NULL,'','','','','','Edwards','','','','1920','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('131bbf79-a80c-457e-9db1-331add984b3b','','','Hymenogaster viscidus (Massee & Rodway) C.W. Dodge & Zeller',1,'Hymenogaster viscidus','Hymenogaster viscidus','Hymenogaster uiscid',2,0,'','','Massee|Rodway|C. W. Dodge|Zeller','e36b293e-a692-5aa7-9bf1-c53652340bf2','Hymenogaster viscidus (Massee & Rodway) C.W. Dodge & Zeller','(Massee & Rodway) C.W. Dodge & Zeller','SPECIES','','Hymenogaster','','viscidus','','','',NULL,'C. W. Dodge & Zeller','','','','','Massee & Rodway','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('13171e55-4661-4fa7-9369-f7f1c7963c8a','','','Pseudolycoriella tuakana Köhler, 2019',1,'Pseudolycoriella tuakana','Pseudolycoriella tuakana','Pseudolycoriella tuakan',2,0,'','','Köhler','24a22c5f-246f-579c-8cb5-e48838dde8a7','Pseudolycoriella tuakana Köhler, 2019','Köhler, 2019','SPECIES','','Pseudolycoriella','','tuakana','','','',NULL,'','','','','','Köhler','','','','2019','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('131d713f-5b90-43cb-95a7-2b8db4ace27a','','','Chaetoceros peruvianus Brightwell',1,'Chaetoceros peruvianus','Chaetoceros peruvianus','Chaetoceros peruuian',2,0,'','','Brightwell','abba1307-c526-5920-8741-fa6f28c32e2e','Chaetoceros peruvianus Brightwell','Brightwell','SPECIES','','Chaetoceros','','peruvianus','','','',NULL,'','','','','','Brightwell','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1321d325-1695-4730-8133-613652a8216b','','','Zoopsis lobulata Colenso',1,'Zoopsis lobulata','Zoopsis lobulata','Zoopsis lobulat',2,0,'','','Colenso','1577f3ab-759b-55af-945b-65a1dfa5308d','Zoopsis lobulata Colenso','Colenso','SPECIES','','Zoopsis','','lobulata','','','',NULL,'','','','','','Colenso','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11f990dc-7092-4aea-b2bc-a4cb35880b9b','','','Secotium ochraceum Rodway',1,'Secotium ochraceum','Secotium ochraceum','Secotium ochrace',2,0,'','','Rodway','8d54c9a9-097c-50c6-a3fe-babbc381e975','Secotium ochraceum Rodway','Rodway','SPECIES','','Secotium','','ochraceum','','','',NULL,'','','','','','Rodway','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('131bbfd2-43ba-4c15-8d65-f4745317b8da','','','Dadayiella',1,'Dadayiella','Dadayiella','Dadayiella',1,0,'','','','516049c4-0c0d-50cb-b112-7cb41cacff4d','Dadayiella','','GENUS','Dadayiella','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('131c3967-02fd-484a-9a74-f9c614484147','','','Filago gallica L.',1,'Filago gallica','Filago gallica','Filago gallic',2,0,'','','L.','0941ae87-6fbf-5d12-a740-2b0f429b2143','Filago gallica L.','L.','SPECIES','','Filago','','gallica','','','',NULL,'','','','','','L.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11fcaf71-3ad8-4e34-9db2-06bd00f27818','','','Liarea turriculata turriculata (Pfeiffer, 1855)',1,'Liarea turriculata turriculata','Liarea turriculata turriculata','Liarea turriculat turriculat',3,0,'','','Pfeiffer','e69bd6c1-4b91-502b-9dfc-4a5982689afc','Liarea turriculata turriculata (Pfeiffer, 1855)','(Pfeiffer, 1855)','SUBSPECIES','','Liarea','','turriculata','turriculata','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11feda3a-44b6-4ca4-9269-7ac6bb5db448','','','Minicosta',1,'Minicosta','Minicosta','Minicosta',1,0,'','','','f1bb2f6d-0af3-5967-bcec-f898241a83cb','Minicosta','','GENUS','Minicosta','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11fd9cc4-df8a-4253-af60-904742096d88','','','Navicula platystoma Ehrenberg',1,'Navicula platystoma','Navicula platystoma','Navicula platystom',2,0,'','','Ehrenberg','7619efb6-3689-5aed-9f25-cf37f9a2de4e','Navicula platystoma Ehrenberg','Ehrenberg','SPECIES','','Navicula','','platystoma','','','',NULL,'','','','','','Ehrenberg','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11fdd336-a43e-411a-b65d-c8fdef0f122b','','','Zelleria Stainton, 1849',1,'Zelleria','Zelleria','Zelleria',1,0,'','','Stainton','584df208-a304-5439-ba5d-50d2a9b9d2af','Zelleria Stainton, 1849','Stainton, 1849','GENUS','Zelleria','','','','','','',NULL,'','','','','','Stainton','','','','1849','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11fecb76-0c0d-4e0c-af73-f8dd5c507618','','','Leprieuria Læssøe, J.D. Rogers & Whalley',1,'Leprieuria','Leprieuria','Leprieuria',1,0,'','','Læssøe|J. D. Rogers|Whalley','5ef4eb23-a2e4-5c47-b508-bacc335125d9','Leprieuria Læssøe, J.D. Rogers & Whalley','Læssøe, J.D. Rogers & Whalley','GENUS','Leprieuria','','','','','','',NULL,'','','','','','Læssøe, J. D. Rogers & Whalley','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12018347-8511-49a1-adb9-4d139a97be51','','','Ustilago sacchari-ciliaris Bref.',1,'Ustilago sacchari-ciliaris','Ustilago sacchari-ciliaris','Ustilago sacchari-ciliar',2,0,'','','Bref.','ce101d1e-0f0c-5cb3-af97-6aaebdde8f89','Ustilago sacchari-ciliaris Bref.','Bref.','SPECIES','','Ustilago','','sacchari-ciliaris','','','',NULL,'','','','','','Bref.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1200be35-efc5-4ece-a17e-8df25a5829e9','','','Lepiota mesomorpha sensu Massee',4,'','','',NULL,NULL,'','','','','Lepiota mesomorpha sensu Massee','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12030060-b9f2-432d-b9ee-934115d23a47','','','Antheraea Hübner, 1819',1,'Antheraea','Antheraea','Antheraea',1,0,'','','Hübner','3e20263b-3dad-5104-9838-ea45a894342e','Antheraea Hübner, 1819','Hübner, 1819','GENUS','Antheraea','','','','','','',NULL,'','','','','','Hübner','','','','1819','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1207effa-6acd-4864-a11c-ebcdea0576a5','','','Urostachys helmii Nessel',1,'Urostachys helmii','Urostachys helmii','Urostachys helm',2,0,'','','Nessel','12bb5cda-e28f-5fd9-b6ce-0aef90ff42cc','Urostachys helmii Nessel','Nessel','SPECIES','','Urostachys','','helmii','','','',NULL,'','','','','','Nessel','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1208edc6-b562-496f-9ee5-4bce098cd8ed','','','Orthotheciella varia (Hedw.) Ochyra',1,'Orthotheciella varia','Orthotheciella varia','Orthotheciella uar',2,0,'','','Hedw.|Ochyra','af440348-df30-5d29-9f20-270510bd134d','Orthotheciella varia (Hedw.) Ochyra','(Hedw.) Ochyra','SPECIES','','Orthotheciella','','varia','','','',NULL,'Ochyra','','','','','Hedw.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('120d7138-7a89-448d-af4d-655256d8e835','','','Lichen polydactylus Neck.',1,'Lichen polydactylus','Lichen polydactylus','Lichen polydactyl',2,0,'','','Neck.','372b66c7-ad39-5484-9bb3-236726c9c160','Lichen polydactylus Neck.','Neck.','SPECIES','','Lichen','','polydactylus','','','',NULL,'','','','','','Neck.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12105258-c06b-44db-9b53-795303e6d666','','','Vermicularia holci P. Syd.',1,'Vermicularia holci','Vermicularia holci','Vermicularia holc',2,0,'','','P. Syd.','d9faf7d0-6a7b-54b6-b73d-f5d7ce7ed0af','Vermicularia holci P. Syd.','P. Syd.','SPECIES','','Vermicularia','','holci','','','',NULL,'','','','','','P. Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1210c7d8-3cf9-4c82-b9dc-d318b25fae6e','','','Neisseria weaveri Holmes et al., 1993',1,'Neisseria weaveri','Neisseria weaveri','Neisseria weauer',2,0,'','','Holmes et al.','a3337fc6-6804-5b1a-b930-94f2f675f359','Neisseria weaveri Holmes et al., 1993','Holmes et al., 1993','SPECIES','','Neisseria','','weaveri','','','',NULL,'','','','','','Holmes et al.','','','','1993','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1217422c-f74f-4b89-8316-044a5c1de4be','','','Achelia transfuga Stock, 1954',1,'Achelia transfuga','Achelia transfuga','Achelia transfug',2,0,'','','Stock','2928ef4b-6740-578c-9932-392daf7b5b86','Achelia transfuga Stock, 1954','Stock, 1954','SPECIES','','Achelia','','transfuga','','','',NULL,'','','','','','Stock','','','','1954','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12152a0c-e700-4192-8d00-82cfc0f9516d','','','Uromyces asclepiadis Cooke',1,'Uromyces asclepiadis','Uromyces asclepiadis','Uromyces asclepiad',2,0,'','','Cooke','2703741b-6bc6-5deb-93f5-869f4ddb190e','Uromyces asclepiadis Cooke','Cooke','SPECIES','','Uromyces','','asclepiadis','','','',NULL,'','','','','','Cooke','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('121383b2-b0be-4d80-82a1-b37f6a530704','','','Craspedia thinicola Breitw. & K.A.Ford',1,'Craspedia thinicola','Craspedia thinicola','Craspedia thinicol',2,0,'','','Breitw.|K. A. Ford','77b567ec-d23d-536b-aa2d-e51a26543649','Craspedia thinicola Breitw. & K.A.Ford','Breitw. & K.A.Ford','SPECIES','','Craspedia','','thinicola','','','',NULL,'','','','','','Breitw. & K. A. Ford','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('121baa30-aba9-492b-9041-046b9b3612b9','','','Colletotrichum clidemiae B.S. Weir & P.R. Johnst.',1,'Colletotrichum clidemiae','Colletotrichum clidemiae','Colletotrichum clidemi',2,0,'','','B. S. Weir|P. R. Johnst.','6391fb9b-2808-57f6-ad64-92de555aed1f','Colletotrichum clidemiae B.S. Weir & P.R. Johnst.','B.S. Weir & P.R. Johnst.','SPECIES','','Colletotrichum','','clidemiae','','','',NULL,'','','','','','B. S. Weir & P. R. Johnst.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('121bc156-0c1c-4c15-a6ac-463ccde4b71d','','','Halobaena',1,'Halobaena','Halobaena','Halobaena',1,0,'','','','0fb91c55-722e-55db-81ff-d9fa77064934','Halobaena','','GENUS','Halobaena','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('121821de-a7f7-485c-acf4-73e7a3ff75eb','','','Eupines (Byraxis) hectori (Broun, 1895)',1,'Eupines hectori','Eupines hectori','Eupines hector',2,0,'','','Broun','baf1c1f3-4986-5045-ab99-477fbf7eff37','Eupines (Byraxis) hectori (Broun, 1895)','(Broun, 1895)','SPECIES','','Eupines','Byraxis','hectori','','','',NULL,'','','','','','Broun','','','','1895','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('121a86a3-5cdc-4cad-b80c-a71bc1a40d2b','','','Deoterthridae',1,'Deoterthridae','Deoterthridae','Deoterthridae',1,0,'','','','08c37cdc-9695-509c-b273-5d5f8bae1bcd','Deoterthridae','','FAMILY','Deoterthridae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1217a856-5d19-460d-8423-c89e0ff480d5','','','Protoperidinium',1,'Protoperidinium','Protoperidinium','Protoperidinium',1,0,'','','','aa3a7b3c-50fa-5aa1-83ce-8f83b78df871','Protoperidinium','','GENUS','Protoperidinium','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('121857e8-2d9f-4087-9da7-d02cb61bdd56','','','Tyrophagus communis Fan & Zhang, 2007',1,'Tyrophagus communis','Tyrophagus communis','Tyrophagus commun',2,0,'','','Fan|Zhang','9cca7dc6-9499-5020-b5de-4809494ab0cd','Tyrophagus communis Fan & Zhang, 2007','Fan & Zhang, 2007','SPECIES','','Tyrophagus','','communis','','','',NULL,'','','','','','Fan & Zhang','','','','2007','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('121df92a-7644-4459-bef9-00de10078910','','','Mallobathra metrosema Meyrick, 1888',1,'Mallobathra metrosema','Mallobathra metrosema','Mallobathra metrosem',2,0,'','','Meyrick','55338878-9b13-599f-af0a-fea332464c5b','Mallobathra metrosema Meyrick, 1888','Meyrick, 1888','SPECIES','','Mallobathra','','metrosema','','','',NULL,'','','','','','Meyrick','','','','1888','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1223a60f-d2a9-4fa7-8746-3928e0be68f7','','','Agaricus uber Berk. & M.A.Curtis',1,'Agaricus uber','Agaricus uber','Agaricus uber',2,0,'','','Berk.|M. A. Curtis','ac60d10d-a2f6-5a96-b320-fdb65afccf84','Agaricus uber Berk. & M.A.Curtis','Berk. & M.A.Curtis','SPECIES','','Agaricus','','uber','','','',NULL,'','','','','','Berk. & M. A. Curtis','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12231014-0245-4f5c-bf34-94295ab9ef5f','','','Eudynamys orientalis (Linnaeus, 1766)',1,'Eudynamys orientalis','Eudynamys orientalis','Eudynamys oriental',2,0,'','','Linnaeus','c3c07282-7f4d-5a03-8b52-249a77c10b0e','Eudynamys orientalis (Linnaeus, 1766)','(Linnaeus, 1766)','SPECIES','','Eudynamys','','orientalis','','','',NULL,'','','','','','Linnaeus','','','','1766','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1223206b-e860-4d39-ba28-b5ae9a30e697','','','Dolichopeza Curtis, 1825',1,'Dolichopeza','Dolichopeza','Dolichopeza',1,0,'','','Curtis','19dd0b11-6ca3-5cd5-acb6-67be1891fd1b','Dolichopeza Curtis, 1825','Curtis, 1825','GENUS','Dolichopeza','','','','','','',NULL,'','','','','','Curtis','','','','1825','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('121db741-3651-41a5-a6ba-f32dc96ba37b','','','Perofascia Constant.',1,'Perofascia','Perofascia','Perofascia',1,0,'','','Constant.','d2884e60-da2e-5639-bcd8-f72f7df02d7c','Perofascia Constant.','Constant.','GENUS','Perofascia','','','','','','',NULL,'','','','','','Constant.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12261d2e-af0c-4e9c-bfbc-12c80dee07e8','','','Lobelia fatiscens Heenan',1,'Lobelia fatiscens','Lobelia fatiscens','Lobelia fatiscens',2,0,'','','Heenan','9022a65e-b6d3-5f18-b053-9db2e0845ecb','Lobelia fatiscens Heenan','Heenan','SPECIES','','Lobelia','','fatiscens','','','',NULL,'','','','','','Heenan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12297a8d-9afe-4016-9880-91ef68434d07','','','Cryptodifflugia',1,'Cryptodifflugia','Cryptodifflugia','Cryptodifflugia',1,0,'','','','8cda2fb1-21a6-5c66-967e-565e38387a4d','Cryptodifflugia','','GENUS','Cryptodifflugia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('122bb1e3-3461-4068-a74b-9f92c8a7a8ae','','','Podosphaera Kunze',1,'Podosphaera','Podosphaera','Podosphaera',1,0,'','','Kunze','108a498d-5dd9-5e91-abdc-cc99eac0d9e0','Podosphaera Kunze','Kunze','GENUS','Podosphaera','','','','','','',NULL,'','','','','','Kunze','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12251bc2-6edb-4ed0-9d7f-b36507239e98','','','Thysanozoon',1,'Thysanozoon','Thysanozoon','Thysanozoon',1,0,'','','','daf1f71c-c902-5341-b602-4046b564758f','Thysanozoon','','GENUS','Thysanozoon','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('122b9a3f-6ec3-4a3a-87f0-c2eb26b35d48','','','Ischiochaetus Bickel & Dyte, 1989',1,'Ischiochaetus','Ischiochaetus','Ischiochaetus',1,0,'','','Bickel|Dyte','c9e64854-55aa-5537-846b-47aa54f4a826','Ischiochaetus Bickel & Dyte, 1989','Bickel & Dyte, 1989','GENUS','Ischiochaetus','','','','','','',NULL,'','','','','','Bickel & Dyte','','','','1989','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1229fb03-b07f-4ddd-99f3-e76410bc4a42','','','Cryptognathus vulgaris Luxton, 1973',1,'Cryptognathus vulgaris','Cryptognathus vulgaris','Cryptognathus uulgar',2,0,'','','Luxton','11b2ed9f-4183-549c-9f80-4f7030305c3c','Cryptognathus vulgaris Luxton, 1973','Luxton, 1973','SPECIES','','Cryptognathus','','vulgaris','','','',NULL,'','','','','','Luxton','','','','1973','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('122d67fc-fc2c-42ae-be68-75c51d192a5d','','','Psychrophila M.M. Wang & Xing Z. Liu',1,'Psychrophila','Psychrophila','Psychrophila',1,0,'','','M. M. Wang|Xing Z. Liu','36afe131-583b-53fe-81d7-292d036d0e41','Psychrophila M.M. Wang & Xing Z. Liu','M.M. Wang & Xing Z. Liu','GENUS','Psychrophila','','','','','','',NULL,'','','','','','M. M. Wang & Xing Z. Liu','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('123116e3-5381-47fb-9dee-ac23b6f2d4b4','','','Acanthosomatinae',1,'Acanthosomatinae','Acanthosomatinae','Acanthosomatinae',1,0,'','','','7b3445d0-d27f-5b59-b7a2-a88d26bdd55f','Acanthosomatinae','','SUBFAMILY','Acanthosomatinae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('122f28df-ccff-4770-967d-cca10e7aead9','','','Puccinia lemonnieriana Maire',1,'Puccinia lemonnieriana','Puccinia lemonnieriana','Puccinia lemonnierian',2,0,'','','Maire','1cf9a6f7-f8df-5e07-bb21-6f10d025817f','Puccinia lemonnieriana Maire','Maire','SPECIES','','Puccinia','','lemonnieriana','','','',NULL,'','','','','','Maire','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12326287-3e45-4bd7-bcfb-4664266aa5ab','','','Bulliarda DC.',1,'Bulliarda','Bulliarda','Bulliarda',1,0,'','','DC.','9c148c15-2122-5741-acec-ed4d5fc0c475','Bulliarda DC.','DC.','GENUS','Bulliarda','','','','','','',NULL,'','','','','','DC.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12353a71-0350-47a2-bf8d-90d9e6f76a01','','','Clubiona contrita Forster, 1979',1,'Clubiona contrita','Clubiona contrita','Clubiona contrit',2,0,'','','Forster','2a8151a8-2581-5166-9f08-6e86e3222767','Clubiona contrita Forster, 1979','Forster, 1979','SPECIES','','Clubiona','','contrita','','','',NULL,'','','','','','Forster','','','','1979','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('123be7c4-8f48-461d-b614-d2b01dea0329','','','Synchaetidae',1,'Synchaetidae','Synchaetidae','Synchaetidae',1,0,'','','','de13075f-6ecf-5cd3-a026-2f07bc86dcb4','Synchaetidae','','FAMILY','Synchaetidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12374e74-7fd2-4eeb-bd46-d624fdf324f0','','','Anthostomella rubicola Sacc. & Trotter',1,'Anthostomella rubicola','Anthostomella rubicola','Anthostomella rubicol',2,0,'','','Sacc.|Trotter','9efbf4ac-cf99-5545-bc8c-27159b68af33','Anthostomella rubicola Sacc. & Trotter','Sacc. & Trotter','SPECIES','','Anthostomella','','rubicola','','','',NULL,'','','','','','Sacc. & Trotter','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('123fc20b-a2c0-45f2-9914-0b10d4595fbf','','','Berberis aquifolium Pursh',1,'Berberis aquifolium','Berberis aquifolium','Berberis aquifoli',2,0,'','','Pursh','eaed132d-53d5-52c4-9e0c-8065c9b6ee4c','Berberis aquifolium Pursh','Pursh','SPECIES','','Berberis','','aquifolium','','','',NULL,'','','','','','Pursh','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('123e1a09-13c4-4660-829f-5851f7857416','','','Staurastrum armigerum Bréb.',1,'Staurastrum armigerum','Staurastrum armigerum','Staurastrum armiger',2,0,'','','Bréb.','9c662fdd-0f76-5557-aedb-d95254895e7f','Staurastrum armigerum Bréb.','Bréb.','SPECIES','','Staurastrum','','armigerum','','','',NULL,'','','','','','Bréb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12401a06-fc00-4a11-98a7-92f59712f29b','','','Baccella',1,'Baccella','Baccella','Baccella',1,0,'','','','7a6cbecc-52c6-5982-bbab-41174847deba','Baccella','','GENUS','Baccella','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('123d0380-77f5-4c34-852f-a0fabab5628e','','','Gymnosporium culmigenum Berk.',1,'Gymnosporium culmigenum','Gymnosporium culmigenum','Gymnosporium culmigen',2,0,'','','Berk.','beb6ad28-73e6-5222-a804-850732215ced','Gymnosporium culmigenum Berk.','Berk.','SPECIES','','Gymnosporium','','culmigenum','','','',NULL,'','','','','','Berk.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1240a0fc-efef-4da4-8ac3-ecd1dc3db306','','','Catoptes postrectus Marshall, 1931',1,'Catoptes postrectus','Catoptes postrectus','Catoptes postrect',2,0,'','','Marshall','b0644a84-d359-5091-8e41-4d87da5e93bd','Catoptes postrectus Marshall, 1931','Marshall, 1931','SPECIES','','Catoptes','','postrectus','','','',NULL,'','','','','','Marshall','','','','1931','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1243aecb-9b75-446a-be04-30493e1a2a16','','','Anabaena circinalis Rabenh. ex Bornet & Flahault',1,'Anabaena circinalis','Anabaena circinalis','Anabaena circinal',2,0,'','','Rabenh.|Bornet|Flahault','ba866fe6-fee3-5c71-8345-f11eae21eadc','Anabaena circinalis Rabenh. ex Bornet & Flahault','Rabenh. ex Bornet & Flahault','SPECIES','','Anabaena','','circinalis','','','',NULL,'','','','','','Rabenh.','','Bornet & Flahault','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12475bd8-0bde-40f8-a752-9ff91d9b4d3c','','','Pyramidelloides subg. Teretianax',2,'Teretianax','Pyramidelloides subgen. Teretianax','Teretianax',1,0,'','','','2016766d-3be5-507a-8e10-fd44a7867433','Pyramidelloides subg. Teretianax','','SUBGENUS','Teretianax','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1242bc15-9b3a-41d4-b62a-bf9034b248bb','','','Cyclobothra Sweet',1,'Cyclobothra','Cyclobothra','Cyclobothra',1,0,'','','Sweet','a6d2f5e2-61ed-563e-b58c-11e0da19daa3','Cyclobothra Sweet','Sweet','GENUS','Cyclobothra','','','','','','',NULL,'','','','','','Sweet','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1242c6c7-c394-48d7-9ee6-ea62ad08ca3e','','','Stephanorhynchus attelaboides (Fabricius, 1775)',1,'Stephanorhynchus attelaboides','Stephanorhynchus attelaboides','Stephanorhynchus attelaboid',2,0,'','','Fabricius','f64e048a-4f73-51dc-bd56-23be79723b6b','Stephanorhynchus attelaboides (Fabricius, 1775)','(Fabricius, 1775)','SPECIES','','Stephanorhynchus','','attelaboides','','','',NULL,'','','','','','Fabricius','','','','1775','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1249e03c-9b34-440d-a2b6-81d19054209a','','','Poria manuka G. Cunn.',1,'Poria manuka','Poria manuka','Poria manuk',2,0,'','','G. Cunn.','0bc93723-2bc0-5fae-ac87-9a7961c4893b','Poria manuka G. Cunn.','G. Cunn.','SPECIES','','Poria','','manuka','','','',NULL,'','','','','','G. Cunn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12492521-f90c-48ac-952f-906c3d73fdcc','','','Gen. nov.',NULL,'','','',NULL,NULL,'','','','','Gen. nov.','','GENUS','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1248904b-09eb-4cc4-a2ee-d51fb2e7e4c9','','','Synorthus species',4,'','','',NULL,NULL,'','','','','Synorthus species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1248eb8c-8837-4b3f-8a2d-ded6b583e2c4','','','Sarcosoma orientale Pat.',1,'Sarcosoma orientale','Sarcosoma orientale','Sarcosoma oriental',2,0,'','','Pat.','db23f68a-9edd-5b34-9987-df9979ba62b1','Sarcosoma orientale Pat.','Pat.','SPECIES','','Sarcosoma','','orientale','','','',NULL,'','','','','','Pat.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1248e826-6c4a-426d-883e-e9003328341c','','','Agaricus inolens Fr.',1,'Agaricus inolens','Agaricus inolens','Agaricus inolens',2,0,'','','Fr.','cb789cc5-61fe-518e-91c0-af96b3c3911e','Agaricus inolens Fr.','Fr.','SPECIES','','Agaricus','','inolens','','','',NULL,'','','','','','Fr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('124df764-8aa1-4c7c-b541-1469b911254c','','','Ascandra species Bergquistt al., 1986',4,'','','',NULL,NULL,'','','','','Ascandra species Bergquistt al., 1986','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12505fc5-ab11-414f-9aa5-1493e7cdbfcb','','','Mitsukurinidae',1,'Mitsukurinidae','Mitsukurinidae','Mitsukurinidae',1,0,'','','','bbe8ce55-7226-542e-b364-cfb8d04976fc','Mitsukurinidae','','FAMILY','Mitsukurinidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12545565-4286-470b-8bfb-39bbd285942c','','','Reticularia carestiana Rabenh.',1,'Reticularia carestiana','Reticularia carestiana','Reticularia carestian',2,0,'','','Rabenh.','57cf48dc-5df1-5b5a-b84a-46a1cb0e04d1','Reticularia carestiana Rabenh.','Rabenh.','SPECIES','','Reticularia','','carestiana','','','',NULL,'','','','','','Rabenh.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1253453d-4335-4f13-b7e9-8f68c8c30317','','','Nysius anceps White, 1878',1,'Nysius anceps','Nysius anceps','Nysius anceps',2,0,'','','White','c0b898dc-fe65-5751-b00d-4b12ce16deff','Nysius anceps White, 1878','White, 1878','SPECIES','','Nysius','','anceps','','','',NULL,'','','','','','White','','','','1878','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1254418d-9604-4dac-a3c5-c4d8414f39ba','','','Puccinia pazschkei Dietel var. pazschkei',1,'Puccinia pazschkei pazschkei','Puccinia pazschkei var. pazschkei','Puccinia pazschke pazschke',3,0,'','','','87997998-d7b2-5751-8373-55cb4dad40f9','Puccinia pazschkei Dietel var. pazschkei','','VARIETY','','Puccinia','','pazschkei','pazschkei','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1255217d-2043-4e14-91dc-0ad53bc47b2b','','','Doodia caudata sensu A.Rich.',4,'','','',NULL,NULL,'','','','','Doodia caudata sensu A.Rich.','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('125923ed-e7c3-4f31-ab0f-5b50344ea7e7','','','Wheeleria',1,'Wheeleria','Wheeleria','Wheeleria',1,0,'','','','0f678a90-81a5-5514-a446-bf455c9440e9','Wheeleria','','GENUS','Wheeleria','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1255252a-a445-4fc3-9e47-633543c781fc','','','Cystiscus',1,'Cystiscus','Cystiscus','Cystiscus',1,0,'','','','24d85ea2-a8a8-5744-84aa-40861402d47f','Cystiscus','','GENUS','Cystiscus','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1259dbc8-7669-4cd0-9c83-89768c6a5ed8','','','Bankia neztalia Turner & Mckoy, 1979',1,'Bankia neztalia','Bankia neztalia','Bankia neztal',2,0,'','','Turner|Mckoy','b9803684-5bbf-50d7-8fee-79fab0662b4b','Bankia neztalia Turner & Mckoy, 1979','Turner & Mckoy, 1979','SPECIES','','Bankia','','neztalia','','','',NULL,'','','','','','Turner & Mckoy','','','','1979','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('125a2f1f-fb22-4ee1-8359-e4a5dc90ed52','','','Lythrum virgatum ''Rose Queen''',1,'Lythrum virgatum ‘Rose Queen’','Lythrum virgatum ‘Rose Queen’','Lythrum uirgat ‘Rose Queen’',3,0,'','','','74d4dfeb-a2ec-5514-82b4-0d0edc33aec6','Lythrum virgatum ''Rose Queen''','','CULTIVAR','','Lythrum','','virgatum','','','',NULL,'','','','','','','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12602d38-6e40-457e-a7e5-0daa8d2d2e3c','','','Dasyscyphus macrolanceolatus G.W. Beaton',1,'Dasyscyphus macrolanceolatus','Dasyscyphus macrolanceolatus','Dasyscyphus macrolanceolat',2,0,'','','G. W. Beaton','0d4142c6-168b-50e7-98de-a699c9bb06a5','Dasyscyphus macrolanceolatus G.W. Beaton','G.W. Beaton','SPECIES','','Dasyscyphus','','macrolanceolatus','','','',NULL,'','','','','','G. W. Beaton','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12604137-9bbb-43d6-abcb-3613a619c013','','','Agropyron pungens (Pers.) Roem. & Schult.',1,'Agropyron pungens','Agropyron pungens','Agropyron pungens',2,0,'','','Pers.|Roem.|Schult.','a1535592-f689-5028-b95f-b7d273ba95d4','Agropyron pungens (Pers.) Roem. & Schult.','(Pers.) Roem. & Schult.','SPECIES','','Agropyron','','pungens','','','',NULL,'Roem. & Schult.','','','','','Pers.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('125de8ac-d614-438b-bb65-e2838c7d55a2','','','Kybos Fieber, 1866',1,'Kybos','Kybos','Kybos',1,0,'','','Fieber','4b9b1096-9d0b-5e05-91b7-a357664f12a7','Kybos Fieber, 1866','Fieber, 1866','GENUS','Kybos','','','','','','',NULL,'','','','','','Fieber','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('126e9f4e-7d7c-4b8a-9c1f-260c7f5e198c','','','Heteracanthocephalidae',1,'Heteracanthocephalidae','Heteracanthocephalidae','Heteracanthocephalidae',1,0,'','','','09a5d656-38c8-5393-90f3-717130383c31','Heteracanthocephalidae','','FAMILY','Heteracanthocephalidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('126b78d9-c6ac-4588-823d-56892ec08380','','','Diplopeltis cirrhatus (Eberth, 1863)',1,'Diplopeltis cirrhatus','Diplopeltis cirrhatus','Diplopeltis cirrhat',2,0,'','','Eberth','e279e9a3-41c6-5113-9dbc-675335d50bef','Diplopeltis cirrhatus (Eberth, 1863)','(Eberth, 1863)','SPECIES','','Diplopeltis','','cirrhatus','','','',NULL,'','','','','','Eberth','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12690b85-16ca-4590-adcd-8db7c6052dea','','','Phloeospora jaapiana Magnus',1,'Phloeospora jaapiana','Phloeospora jaapiana','Phloeospora iaapian',2,0,'','','Magnus','314ad048-b7fc-56dc-9f71-5a36dcbb5d01','Phloeospora jaapiana Magnus','Magnus','SPECIES','','Phloeospora','','jaapiana','','','',NULL,'','','','','','Magnus','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1267eb2d-1537-4608-af65-d20b94e65f59','','','Euphorbia serrulata Thuill.',1,'Euphorbia serrulata','Euphorbia serrulata','Euphorbia serrulat',2,0,'','','Thuill.','e0784951-5622-5173-bc33-4266a36a3304','Euphorbia serrulata Thuill.','Thuill.','SPECIES','','Euphorbia','','serrulata','','','',NULL,'','','','','','Thuill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1271d6f6-2c4c-449d-8474-0fa6f2486f53','','','Cardamine lilacina Hook.',1,'Cardamine lilacina','Cardamine lilacina','Cardamine lilacin',2,0,'','','Hook.','5e3dcae0-5db2-5607-a415-b654f56b10d4','Cardamine lilacina Hook.','Hook.','SPECIES','','Cardamine','','lilacina','','','',NULL,'','','','','','Hook.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12762bed-a023-4194-b6dc-6427d0062867','','','Hendeola bullata pterna Forster, 1954',1,'Hendeola bullata pterna','Hendeola bullata pterna','Hendeola bullat ptern',3,0,'','','Forster','53e8c068-f535-5eee-8da5-c1471bfd76fc','Hendeola bullata pterna Forster, 1954','Forster, 1954','SUBSPECIES','','Hendeola','','bullata','pterna','','',NULL,'','','','','','Forster','','','','1954','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('126f2756-411b-4bf7-b422-bc4f13a691f8','','','Krithe minima Coles, Whatley & Moguilevsky, 1994',1,'Krithe minima','Krithe minima','Krithe minim',2,0,'','','Coles|Whatley|Moguilevsky','2a5228c6-1ff7-5dc1-a467-ce7648dd1838','Krithe minima Coles, Whatley & Moguilevsky, 1994','Coles, Whatley & Moguilevsky, 1994','SPECIES','','Krithe','','minima','','','',NULL,'','','','','','Coles, Whatley & Moguilevsky','','','','1994','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1279173b-aa1d-4d77-ba94-033adeb1ef74','','','Lophocolea lauterbachii Steph.',1,'Lophocolea lauterbachii','Lophocolea lauterbachii','Lophocolea lauterbach',2,0,'','','Steph.','20c9a154-8e99-538b-9eec-c04fc49e1da8','Lophocolea lauterbachii Steph.','Steph.','SPECIES','','Lophocolea','','lauterbachii','','','',NULL,'','','','','','Steph.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1278add4-61ae-4965-a245-4493b9302577','','','Hatschekia',1,'Hatschekia','Hatschekia','Hatschekia',1,0,'','','','d58c1b46-06ab-5476-a380-8060c80f738e','Hatschekia','','GENUS','Hatschekia','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('127815ff-41e7-4392-af9d-668d36d60bdc','','','Spilophera amokuroides (Allgén, 1928)',1,'Spilophera amokuroides','Spilophera amokuroides','Spilophera amokuroid',2,0,'','','Allgén','09d41441-d41f-55a7-a231-a9e006e28771','Spilophera amokuroides (Allgén, 1928)','(Allgén, 1928)','SPECIES','','Spilophera','','amokuroides','','','',NULL,'','','','','','Allgén','','','','1928','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('127b656b-42e7-40bb-89f0-96c68ab7aff9','','','Poa kirkii var. mackayi (Buchanan) Hack.',1,'Poa kirkii mackayi','Poa kirkii var. mackayi','Poa kirk mackay',3,0,'','','Buchanan|Hack.','63c2b073-19a8-57aa-a831-284525908346','Poa kirkii var. mackayi (Buchanan) Hack.','(Buchanan) Hack.','VARIETY','','Poa','','kirkii','mackayi','','',NULL,'Hack.','','','','','Buchanan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12770db2-b066-469a-8ba8-d01cb9a716bf','','','Psoraceae Zahlbr.',1,'Psoraceae','Psoraceae','Psoraceae',1,0,'','','Zahlbr.','1f5d972c-549e-57a4-bf5e-f1ebfecd6104','Psoraceae Zahlbr.','Zahlbr.','FAMILY','Psoraceae','','','','','','',NULL,'','','','','','Zahlbr.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12838a3b-3e57-434e-91e8-22fe0d89c88d','','','Duripelta koomaa Forster & Platnick, 1985',1,'Duripelta koomaa','Duripelta koomaa','Duripelta kooma',2,0,'','','Forster|Platnick','30dcd20c-eb13-5113-9fd0-8032360ec066','Duripelta koomaa Forster & Platnick, 1985','Forster & Platnick, 1985','SPECIES','','Duripelta','','koomaa','','','',NULL,'','','','','','Forster & Platnick','','','','1985','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12814434-d386-4fe8-96b7-5788740e326e','','','Nivatogastrium Singer & A.H. Sm.',1,'Nivatogastrium','Nivatogastrium','Nivatogastrium',1,0,'','','Singer|A. H. Sm.','2dc5833c-1256-55f2-b006-b1b96dc47163','Nivatogastrium Singer & A.H. Sm.','Singer & A.H. Sm.','GENUS','Nivatogastrium','','','','','','',NULL,'','','','','','Singer & A. H. Sm.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('12877ee7-08cd-49bb-81ea-ccfcf8446e5b','','','Geostiba species',4,'','','',NULL,NULL,'','','','','Geostiba species','','SPECIES','','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('1280e264-78d5-408d-b37f-ebf531efc870','','','Hymenoscyphus monotropae Kernan & Finoccchio',1,'Hymenoscyphus monotropae','Hymenoscyphus monotropae','Hymenoscyphus monotrop',2,0,'','','Kernan|Finoccchio','da4e0068-931f-54e2-86d0-ffded6e673e9','Hymenoscyphus monotropae Kernan & Finoccchio','Kernan & Finoccchio','SPECIES','','Hymenoscyphus','','monotropae','','','',NULL,'','','','','','Kernan & Finoccchio','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('128aa12b-806a-4440-9ef9-2277d77cb911','','','Nothoceros giganteus (Lehm. & Lindenb.) Haseg. ex J.C.Villarreal, Hässel & Salazar',1,'Nothoceros giganteus','Nothoceros giganteus','Nothoceros gigante',2,0,'','','Lehm.|Lindenb.|Haseg.|J. C. Villarreal|Hässel|Salazar','0c293a5a-8903-5801-b40d-90a72041893f','Nothoceros giganteus (Lehm. & Lindenb.) Haseg. ex J.C.Villarreal, Hässel & Salazar','(Lehm. & Lindenb.) Haseg. ex J.C.Villarreal, Hässel & Salazar','SPECIES','','Nothoceros','','giganteus','','','',NULL,'Haseg.','','J. C. Villarreal, Hässel & Salazar','','','Lehm. & Lindenb.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('128add30-83ef-4e26-8e4a-bd53df6be018','','','Ruhlandiella Henn.',1,'Ruhlandiella','Ruhlandiella','Ruhlandiella',1,0,'','','Henn.','74e38946-07b0-5ca2-9501-f721f4598846','Ruhlandiella Henn.','Henn.','GENUS','Ruhlandiella','','','','','','',NULL,'','','','','','Henn.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('128d4a83-a450-44a9-b5c7-d6b372af3f4f','','','Diptychophora parorma Meyrick, 1924',1,'Diptychophora parorma','Diptychophora parorma','Diptychophora parorm',2,0,'','','Meyrick','1e8805fc-17ed-52a1-9230-43862b7df217','Diptychophora parorma Meyrick, 1924','Meyrick, 1924','SPECIES','','Diptychophora','','parorma','','','',NULL,'','','','','','Meyrick','','','','1924','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11aedd82-f700-4f41-8686-0fa4ac60a1f6','','','Festuca matthewsii subsp. aquilonia Connor',1,'Festuca matthewsii aquilonia','Festuca matthewsii subsp. aquilonia','Festuca matthews aquilon',3,0,'','','Connor','a42914f1-829d-58fd-a17b-b007d0ebd897','Festuca matthewsii subsp. aquilonia Connor','Connor','SUBSPECIES','','Festuca','','matthewsii','aquilonia','','',NULL,'','','','','','Connor','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11ae77c0-1a27-4cd8-bf64-2aff43df9a45','','','Prisahypnus attenuatus (Broun, 1893)',1,'Prisahypnus attenuatus','Prisahypnus attenuatus','Prisahypnus attenuat',2,0,'','','Broun','9818a657-f692-505b-ac88-6d24415d730f','Prisahypnus attenuatus (Broun, 1893)','(Broun, 1893)','SPECIES','','Prisahypnus','','attenuatus','','','',NULL,'','','','','','Broun','','','','1893','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11b05fe4-c838-4ddc-8524-af68efa39893','','','Nephromataceae Wetmore ex J.C. David & D. Hawksw.',1,'Nephromataceae','Nephromataceae','Nephromataceae',1,0,'','','Wetmore|J. C. David|D. Hawksw.','c54e129d-2033-518d-a650-cfc02c183bd0','Nephromataceae Wetmore ex J.C. David & D. Hawksw.','Wetmore ex J.C. David & D. Hawksw.','FAMILY','Nephromataceae','','','','','','',NULL,'','','','','','Wetmore','','J. C. David & D. Hawksw.','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11baf018-4c5d-4bf4-a118-20a81f95da9b','','','Progynotaeniidae',1,'Progynotaeniidae','Progynotaeniidae','Progynotaeniidae',1,0,'','','','11bcbf53-5ad0-5952-ae9f-e7366a0c5c69','Progynotaeniidae','','FAMILY','Progynotaeniidae','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11b90560-2d5f-46a3-99f9-43c1801570ad','','','Phyllachora baphispora Syd.',1,'Phyllachora baphispora','Phyllachora baphispora','Phyllachora baphispor',2,0,'','','Syd.','fd70da99-cec7-564c-b8c4-77cdda508d17','Phyllachora baphispora Syd.','Syd.','SPECIES','','Phyllachora','','baphispora','','','',NULL,'','','','','','Syd.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11bb76ca-2a3b-4cfe-8c03-64460c168367','','','Ceratocephala pungens Garn.-Jones',1,'Ceratocephala pungens','Ceratocephala pungens','Ceratocephala pungens',2,0,'','','Garn.-Jones','bf6fde8c-e247-5217-8df7-eec9c0096bd7','Ceratocephala pungens Garn.-Jones','Garn.-Jones','SPECIES','','Ceratocephala','','pungens','','','',NULL,'','','','','','Garn.-Jones','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11b73d1b-bba8-4f29-82d9-b85b27a0b9e6','','','Phialophora verrucosa Medlar',1,'Phialophora verrucosa','Phialophora verrucosa','Phialophora uerrucos',2,0,'','','Medlar','af690e09-1a2c-5d3d-a88e-be70d8f5dd14','Phialophora verrucosa Medlar','Medlar','SPECIES','','Phialophora','','verrucosa','','','',NULL,'','','','','','Medlar','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11b54dd6-f1b1-412a-b681-f24b6417fef8','','','Ischiodasys occulta Noyes & Valentine, 1989',1,'Ischiodasys occulta','Ischiodasys occulta','Ischiodasys occult',2,0,'','','Noyes|Valentine','989f2cf8-b8f4-5563-9da0-588ad66d1f48','Ischiodasys occulta Noyes & Valentine, 1989','Noyes & Valentine, 1989','SPECIES','','Ischiodasys','','occulta','','','',NULL,'','','','','','Noyes & Valentine','','','','1989','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11c04034-f441-4e14-9973-5b476d79099c','','','Diploschistes euganeus (A.Massal.) J.Steiner',1,'Diploschistes euganeus','Diploschistes euganeus','Diploschistes eugane',2,0,'','','A. Massal.|J. Steiner','507d8f23-2676-5447-9bd4-a1c3cf86f35e','Diploschistes euganeus (A.Massal.) J.Steiner','(A.Massal.) J.Steiner','SPECIES','','Diploschistes','','euganeus','','','',NULL,'J. Steiner','','','','','A. Massal.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11c2c674-8d1a-40cc-ae49-dd2e784561f4','','','Craspedia uniflora var. subhispida Allan',1,'Craspedia uniflora subhispida','Craspedia uniflora var. subhispida','Craspedia uniflor subhispid',3,0,'','','Allan','66baf1fd-4243-5d29-8648-1169958db19c','Craspedia uniflora var. subhispida Allan','Allan','VARIETY','','Craspedia','','uniflora','subhispida','','',NULL,'','','','','','Allan','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11c4c1e4-f087-40ea-b42a-1563daa8d405','','','Achaeta camerani (Cognetti, 1899)',1,'Achaeta camerani','Achaeta camerani','Achaeta cameran',2,0,'','','Cognetti','2375c2e0-7039-504e-a39a-7eeb595cfd45','Achaeta camerani (Cognetti, 1899)','(Cognetti, 1899)','SPECIES','','Achaeta','','camerani','','','',NULL,'','','','','','Cognetti','','','','1899','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11c48393-a814-46c0-b2fb-9d0c2ccb81a5','','','Legionella bozemaniae Brenner et al., 1980',1,'Legionella bozemaniae','Legionella bozemaniae','Legionella bozemani',2,0,'','','Brenner et al.','42a1f343-2530-5edf-8b3c-25a3a9491332','Legionella bozemaniae Brenner et al., 1980','Brenner et al., 1980','SPECIES','','Legionella','','bozemaniae','','','',NULL,'','','','','','Brenner et al.','','','','1980','','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11ca52c4-6f02-4ec6-9ab5-d1c04dcc04e4','','','Leptorhynchos squamatus (Labill.) Less.',1,'Leptorhynchos squamatus','Leptorhynchos squamatus','Leptorhynchos squamat',2,0,'','','Labill.|Less.','7326d3f8-8304-5cc3-a872-7ad74ba26904','Leptorhynchos squamatus (Labill.) Less.','(Labill.) Less.','SPECIES','','Leptorhynchos','','squamatus','','','',NULL,'Less.','','','','','Labill.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11c76ab7-9200-42d8-ad66-f9074cb77526','','','Puccinia ruelliae Lagerh.',1,'Puccinia ruelliae','Puccinia ruelliae','Puccinia ruelli',2,0,'','','Lagerh.','e377ad1a-a1ff-5029-8549-1eff98bb2676','Puccinia ruelliae Lagerh.','Lagerh.','SPECIES','','Puccinia','','ruelliae','','','',NULL,'','','','','','Lagerh.','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11cbef31-75a3-4054-bf31-2b561e2baec2','','','Achyra',1,'Achyra','Achyra','Achyra',1,0,'','','','4715d838-7abb-566a-8a86-53dad7a6d48e','Achyra','','GENUS','Achyra','','','','','','',NULL,'','','','','','','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11cdada8-58ac-46a0-ba75-5d1ada94d1fa','','','Lepidosira arborea arborea Salmon, 1944',1,'Lepidosira arborea arborea','Lepidosira arborea arborea','Lepidosira arbore arbore',3,0,'','','Salmon','e62138d2-95c0-50c8-a5f0-a030321dea8a','Lepidosira arborea arborea Salmon, 1944','Salmon, 1944','SUBSPECIES','','Lepidosira','','arborea','arborea','','',NULL,'','','','','','Salmon','','','','1944','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11d13760-c12f-43d6-aac7-91b4d139f68f','','','Chlamydomonas moewusii Gerloff',1,'Chlamydomonas moewusii','Chlamydomonas moewusii','Chlamydomonas moewus',2,0,'','','Gerloff','497a89c3-9d31-589f-8621-33f76b33b22d','Chlamydomonas moewusii Gerloff','Gerloff','SPECIES','','Chlamydomonas','','moewusii','','','',NULL,'','','','','','Gerloff','','','','','BOTANICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11d04c41-b570-4af6-bab2-addcca9d4305','','','Proternia Meyrick, 1884',1,'Proternia','Proternia','Proternia',1,0,'','','Meyrick','00d7aa19-0c21-52e3-8d7a-fec7d857bb01','Proternia Meyrick, 1884','Meyrick, 1884','GENUS','Proternia','','','','','','',NULL,'','','','','','Meyrick','','','','1884','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('11cbd23e-72c5-45dd-98c7-c089c4e01833','','','Gymnomyces parvisaxoides T. Lebel',1,'Gymnomyces parvisaxoides','Gymnomyces parvisaxoides','Gymnomyces paruisaxoid',2,0,'','','T. Lebel','592f62ed-4b34-5ac8-addd-5b3ec36919e3','Gymnomyces parvisa