PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE version (id TEXT NOT NULL) STRICT;
INSERT INTO version VALUES('v0.3.33');
CREATE TABLE metadata (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__doi TEXT DEFAULT '',
  col__title TEXT NOT NULL,
  col__alias TEXT DEFAULT '',
  col__description TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__version TEXT DEFAULT '',
  col__keywords TEXT DEFAULT '',
  col__geographic_scope TEXT DEFAULT '',
  col__taxonomic_scope TEXT DEFAULT '',
  col__temporal_scope TEXT DEFAULT '',
  col__confidence INTEGER DEFAULT NULL,
  col__completeness INTEGER DEFAULT NULL,
  col__license TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__logo TEXT DEFAULT '',
  col__label TEXT DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__private INTEGER DEFAULT NULL -- bool 
) STRICT;
INSERT INTO metadata VALUES(1,'','Ruhoff 1980','','Index to the species of Mollusca introduced from 1850 to 1870','','','','','','',0,0,'','','','','',0);
CREATE TABLE contact (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT NOT NULL,
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
INSERT INTO contact VALUES(1,1,'','','','','','','','','','','','');
CREATE TABLE editor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE creator (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
INSERT INTO creator VALUES(1,1,'','Florence A.','Ruhoff','','','','','','','','','');
CREATE TABLE publisher (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT DEFAULT '',
  col__family TEXT DEFAULT '',
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE contributor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE source (
  col__id TEXT PRIMARY KEY,
  col__metadata_id INTEGER DEFAULT 1,
  col__type TEXT DEFAULT '',
  col__title TEXT DEFAULT '',
  col__authors TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__isbn TEXT DEFAULT ''
) STRICT;
CREATE TABLE author (
  col__id TEXT PRIMARY KEY,
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__alternative_id TEXT DEFAULT '', -- sep by ','
  col__given TEXT DEFAULT '',
  col__family TEXT NOT NULL,
  -- f. for filius,  Jr., etc
  col__suffix TEXT DEFAULT '',
  col__abbreviation_botany TEXT DEFAULT '',
  col__alternative_names TEXT DEFAULT '', -- separated by '|'
  col__sex_id TEXT REFERENCES sex DEFAULT '',
  col__country TEXT DEFAULT '',
  col__birth TEXT DEFAULT '',
  col__birth_place TEXT DEFAULT '',
  col__death TEXT DEFAULT '',
  col__affiliation TEXT DEFAULT '',
  col__interest TEXT DEFAULT '',
  col__reference_id TEXT DEFAULT '', -- sep by ','
  -- url
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE reference (
  col__id TEXT PRIMARY KEY,
  col__alternative_id TEXT DEFAULT '', -- sep by ',', scope:id, id, URI/URN
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__type_id TEXT REFERENCES reference_type DEFAULT '',
  -- author/s in format of either
  -- family1, given1; family2, given2; ..
  -- or
  -- given1 family1, given2 family2, ...
  col__author TEXT DEFAULT '',
  col__author_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__title TEXT DEFAULT '',
  col__title_short TEXT DEFAULT '',
  -- container_author is an author or a parent volume (book, journal) 
  col__container_author TEXT DEFAULT '',
  -- container_title of the parent container
  col__container_title TEXT DEFAULT '',
  -- container_title_short of the parent container
  col__container_title_short TEXT DEFAULT '',
  col__issued TEXT DEFAULT '', -- yyyy-mm-dd
  col__accessed TEXT DEFAULT '', -- yyyy-mm-dd
  -- collection_title of the parent volume
  col__collection_title TEXT DEFAULT '',
  -- collection_editor of the parent volume
  col__collection_editor TEXT DEFAULT '',
  col__volume TEXT DEFAULT '',
  col__issue TEXT DEFAULT '',
  -- edition number
  col__edition TEXT DEFAULT '',
  -- page number
  col__page TEXT DEFAULT '',
  col__publisher TEXT DEFAULT '',
  col__publisher_place TEXT DEFAULT '',
  -- version of the reference
  col__version TEXT DEFAULT '',
  col__isbn TEXT DEFAULT '',
  col__issn TEXT DEFAULT '',
  col__doi TEXT DEFAULT '',
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE name (
  col__id TEXT PRIMARY KEY,
  col__alternative_id TEXT DEFAULT '',
  col__source_id TEXT DEFAULT '',
  -- basionym_id TEXT DEFAULT '', -- use name_relation instead
  gn__scientific_name_string TEXT NOT NULL, -- full name with authorship (if given)
  gn__parse_quality INTEGER DEFAULT NULL,
  gn__canonical_simple TEXT DEFAULT '',
  gn__canonical_full TEXT DEFAULT '',
  gn__canonical_stemmed TEXT DEFAULT '',
  gn__cardinality INTEGER DEFAULT NULL,
  gn__virus INTEGER DEFAULT NULL, -- bool
  gn__hybrid TEXT DEFAULT '',
  gn__surrogate TEXT DEFAULT '',
  gn__authors TEXT DEFAULT '', -- separated by '|'
  gn__id TEXT DEFAULT '', -- UUID v5 generated for GN from name-string
  col__scientific_name TEXT NOT NULL, -- full canonical form
  col__authorship TEXT DEFAULT '', -- verbatim authorship
  col__rank_id TEXT REFERENCES rank DEFAULT '',
  col__uninomial TEXT DEFAULT '',
  col__genus TEXT DEFAULT '',
  col__infrageneric_epithet TEXT DEFAULT '',
  col__specific_epithet TEXT DEFAULT '',
  col__infraspecific_epithet TEXT DEFAULT '',
  col__cultivar_epithet TEXT DEFAULT '',
  col__notho_id TEXT DEFAULT '', -- ref name_part
  col__original_spelling INTEGER DEFAULT NULL, -- bool
  col__combination_authorship TEXT DEFAULT '', -- separated by '|'
  col__combination_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__combination_ex_authorship TEXT DEFAULT '', -- separated by '|'
  col__combination_ex_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__combination_authorship_year TEXT DEFAULT '',
  col__basionym_authorship TEXT DEFAULT '', -- separated by '|'
  col__basionym_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__basionym_ex_authorship TEXT DEFAULT '', -- separated by '|'
  col__basionym_ex_authorship_id TEXT DEFAULT '', -- separated by '|'
  col__basionym_authorship_year TEXT DEFAULT '',
  col__code_id TEXT REFERENCES nom_code DEFAULT '',
  col__status_id TEXT REFERENCES nom_status DEFAULT '',
  col__reference_id TEXT DEFAULT '', -- refs about taxon sep ','
  col__published_in_year TEXT DEFAULT '',
  col__published_in_page TEXT DEFAULT '',
  col__published_in_page_link TEXT DEFAULT '',
  col__gender_id TEXT REFERENCES gender DEFAULT '',
  col__gender_agreement INTEGER DEFAULT NULL, -- bool
  col__etymology TEXT DEFAULT '',
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
INSERT INTO name VALUES('gn_00011','','','Goniobasis abbevillensis Lea, 1862',1,'Goniobasis abbevillensis','Goniobasis abbevillensis','Goniobasis abbeuillens',2,0,'','','Lea','6ed7f255-84d0-5306-95ec-358a24ae7e4d','Goniobasis abbevillensis Lea, 1862','Lea, 1862','UNRANKED','','Goniobasis','','abbevillensis','','','',NULL,'','','','','','Lea','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00017','','','Achatina costellata abbreviata F. Edwards, 1852',1,'Achatina costellata abbreviata','Achatina costellata abbreviata','Achatina costellat abbreuiat',3,0,'','','F. Edwards','45b2d03e-97e5-53ae-a201-f3df0fada4ef','Achatina costellata abbreviata F. Edwards, 1852','F. Edwards, 1852','UNRANKED','','Achatina','','costellata','abbreviata','','',NULL,'','','','','','F. Edwards','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00019','','','Limnaea caudata abbreviata F. Edwards, 1852',1,'Limnaea caudata abbreviata','Limnaea caudata abbreviata','Limnaea caudat abbreuiat',3,0,'','','F. Edwards','b7ad34bb-feac-5420-889f-e681e5d98620','Limnaea caudata abbreviata F. Edwards, 1852','F. Edwards, 1852','UNRANKED','','Limnaea','','caudata','abbreviata','','',NULL,'','','','','','F. Edwards','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00022','','','Michelia abbreviata Fried. Roemer, 1852',1,'Michelia abbreviata','Michelia abbreviata','Michelia abbreuiat',2,0,'','','Fried. Roemer','139aa19c-5d44-55b1-967a-19e3e93a1134','Michelia abbreviata Fried. Roemer, 1852','Fried. Roemer, 1852','UNRANKED','','Michelia','','abbreviata','','','',NULL,'','','','','','Fried. Roemer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00025','','','Paludina abbreviata Reeve, 1863',1,'Paludina abbreviata','Paludina abbreviata','Paludina abbreuiat',2,0,'','','Reeve','e920326d-e326-5360-8316-1b7698385de5','Paludina abbreviata Reeve, 1863','Reeve, 1863','UNRANKED','','Paludina','','abbreviata','','','',NULL,'','','','','','Reeve','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00030','','','Pupa abbreviata R. Lowe, 1852',1,'Pupa abbreviata','Pupa abbreviata','Pupa abbreuiat',2,0,'','','R. Lowe','d65b3b07-523a-55d9-b5ba-7faea5640343','Pupa abbreviata R. Lowe, 1852','R. Lowe, 1852','UNRANKED','','Pupa','','abbreviata','','','',NULL,'','','','','','R. Lowe','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00037','','','Cerithium abbreviatum Leckenby, 1858',1,'Cerithium abbreviatum','Cerithium abbreviatum','Cerithium abbreuiat',2,0,'','','Leckenby','d8bac4ef-7e42-5194-bcf3-474983e49ea0','Cerithium abbreviatum Leckenby, 1858','Leckenby, 1858','UNRANKED','','Cerithium','','abbreviatum','','','',NULL,'','','','','','Leckenby','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00040','','','Cleidophorus abbreviatus Sharpe, 1856',1,'Cleidophorus abbreviatus','Cleidophorus abbreviatus','Cleidophorus abbreuiat',2,0,'','','Sharpe','ce22afd8-bd1e-53de-83ec-0a855b37f342','Cleidophorus abbreviatus Sharpe, 1856','Sharpe, 1856','UNRANKED','','Cleidophorus','','abbreviatus','','','',NULL,'','','','','','Sharpe','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00045','','','Ophileta abdita Billings, 1865',1,'Ophileta abdita','Ophileta abdita','Ophileta abdit',2,0,'','','Billings','d60e0660-dd3b-529c-a0b0-f18a82ac2f21','Ophileta abdita Billings, 1865','Billings, 1865','UNRANKED','','Ophileta','','abdita','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00051','','','Helix aberrans Mousson, 1863',1,'Helix aberrans','Helix aberrans','Helix aberrans',2,0,'','','Mousson','8add6f48-0110-5725-b1df-b52dbf4bfd5d','Helix aberrans Mousson, 1863','Mousson, 1863','UNRANKED','','Helix','','aberrans','','','',NULL,'','','','','','Mousson','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00057','','','Heteroceras abichanum Orbigny, 1851',1,'Heteroceras abichanum','Heteroceras abichanum','Heteroceras abichan',2,0,'','','Orbigny','574e7f6f-f457-58ec-85c3-69e9182f66a2','Heteroceras abichanum Orbigny, 1851','Orbigny, 1851','UNRANKED','','Heteroceras','','abichanum','','','',NULL,'','','','','','Orbigny','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00064','','','Helix abjecta Gould, 1851',1,'Helix abjecta','Helix abjecta','Helix abiect',2,0,'','','Gould','c4325699-2447-566f-9c67-2e504af683c9','Helix abjecta Gould, 1851','Gould, 1851','UNRANKED','','Helix','','abjecta','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00069','','','Caecum abnormale P. Carpenter, 1856',1,'Caecum abnormale','Caecum abnormale','Caecum abnormal',2,0,'','','P. Carpenter','7c69dead-9f5f-545a-9684-88bd50202b75','Caecum abnormale P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Caecum','','abnormale','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00073','','','Hyala abnormis Gould, 1861',1,'Hyala abnormis','Hyala abnormis','Hyala abnorm',2,0,'','','Gould','876efa54-6662-51ac-900d-8e4113f70d8f','Hyala abnormis Gould, 1861','Gould, 1861','UNRANKED','','Hyala','','abnormis','','','',NULL,'','','','','','Gould','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00079','','','Unio abnormis Morelet, 1862',1,'Unio abnormis','Unio abnormis','Unio abnorm',2,0,'','','Morelet','ff9d9464-ef3b-5e8d-9bc3-3b0ef6613368','Unio abnormis Morelet, 1862','Morelet, 1862','UNRANKED','','Unio','','abnormis','','','',NULL,'','','','','','Morelet','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00084','','','Helix abrochroa Crosse, 1868',1,'Helix abrochroa','Helix abrochroa','Helix abrochro',2,0,'','','Crosse','c710eb76-ff81-59e2-b7c5-c3b9051ff568','Helix abrochroa Crosse, 1868','Crosse, 1868','UNRANKED','','Helix','','abrochroa','','','',NULL,'','','','','','Crosse','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00089','','','Arca abrupta Forbes, 1856',1,'Arca abrupta','Arca abrupta','Arca abrupt',2,0,'','','Forbes','eff3d324-becb-5b7b-bf92-0e144d2a36f2','Arca abrupta Forbes, 1856','Forbes, 1856','UNRANKED','','Arca','','abrupta','','','',NULL,'','','','','','Forbes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00094','','','Saxicava abrupta Conrad, 1855',1,'Saxicava abrupta','Saxicava abrupta','Saxicava abrupt',2,0,'','','Conrad','404df647-4c2c-5864-b87e-fa0008c4839c','Saxicava abrupta Conrad, 1855','Conrad, 1855','UNRANKED','','Saxicava','','abrupta','','','',NULL,'','','','','','Conrad','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00098','','','Melania abscida Anthony, 1860',1,'Melania abscida','Melania abscida','Melania abscid',2,0,'','','Anthony','34056f82-d0a8-54c0-86c0-8d80aa37847e','Melania abscida Anthony, 1860','Anthony, 1860','UNRANKED','','Melania','','abscida','','','',NULL,'','','','','','Anthony','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00104','','','Cerithium absconditum Deshayes, 1864',1,'Cerithium absconditum','Cerithium absconditum','Cerithium abscondit',2,0,'','','Deshayes','1f2fbcd3-42df-5f9b-adaa-4f8582922c5e','Cerithium absconditum Deshayes, 1864','Deshayes, 1864','UNRANKED','','Cerithium','','absconditum','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00109','','','Limopsis abyssicola A. Adams, 1862',1,'Limopsis abyssicola','Limopsis abyssicola','Limopsis abyssicol',2,0,'','','A. Adams','22a44959-517a-51fc-ab49-152f11f45667','Limopsis abyssicola A. Adams, 1862','A. Adams, 1862','UNRANKED','','Limopsis','','abyssicola','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00113','','','Paludina abyssinica Martens, 1866',1,'Paludina abyssinica','Paludina abyssinica','Paludina abyssinic',2,0,'','','Martens','e2b52ec8-8df8-5b02-b4d8-cba0d3ab7f42','Paludina abyssinica Martens, 1866','Martens, 1866','UNRANKED','','Paludina','','abyssinica','','','',NULL,'','','','','','Martens','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00115','','','Pupa abyssinica Reinhardt, in Martens, 1869',2,'Pupa abyssinica','Pupa abyssinica','Pupa abyssinic',2,0,'','','Reinhardt|Martens','27903e83-9dec-58d0-bcc4-fa195d965aff','Pupa abyssinica Reinhardt, in Martens, 1869','Reinhardt, in Martens, 1869','UNRANKED','','Pupa','','abyssinica','','','',NULL,'','','','','','Reinhardt','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00119','','','Helix acalles Pfeiffer, 1856',1,'Helix acalles','Helix acalles','Helix acall',2,0,'','','Pfeiffer','a0bf32a5-4f0f-5b1e-9f0b-be5d310054a1','Helix acalles Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Helix','','acalles','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00123','','','Turritella acanthophora J. Muller, 1851',1,'Turritella acanthophora','Turritella acanthophora','Turritella acanthophor',2,0,'','','J. Muller','cfbd12eb-e43b-5649-8843-704ca06069de','Turritella acanthophora J. Muller, 1851','J. Muller, 1851','UNRANKED','','Turritella','','acanthophora','','','',NULL,'','','','','','J. Muller','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00127','','','Bulimus (Borus) accelerans Martens, 1867',1,'Bulimus accelerans','Bulimus accelerans','Bulimus accelerans',2,0,'','','Martens','24dacebb-4a9f-5b5c-bb9f-d338d1e55818','Bulimus (Borus) accelerans Martens, 1867','Martens, 1867','UNRANKED','','Bulimus','Borus','accelerans','','','',NULL,'','','','','','Martens','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00131','','','Scalaria acephala Ryckholt, 1860',1,'Scalaria acephala','Scalaria acephala','Scalaria acephal',2,0,'','','Ryckholt','90f53172-d007-55f2-81d4-c86146eddb80','Scalaria acephala Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Scalaria','','acephala','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00137','','','Bulimus acervatus Pfeiffer, 1857',1,'Bulimus acervatus','Bulimus acervatus','Bulimus aceruat',2,0,'','','Pfeiffer','b07254f4-7572-58e0-97e5-5fa307d61bc6','Bulimus acervatus Pfeiffer, 1857','Pfeiffer, 1857','UNRANKED','','Bulimus','','acervatus','','','',NULL,'','','','','','Pfeiffer','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00142','','','Odostomia achates Gould, 1853',1,'Odostomia achates','Odostomia achates','Odostomia achat',2,0,'','','Gould','50ca26b4-cf6a-531b-8aee-41cf85c607c8','Odostomia achates Gould, 1853','Gould, 1853','UNRANKED','','Odostomia','','achates','','','',NULL,'','','','','','Gould','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00149','','','Leptopoma achatinum Crosse, 1865',1,'Leptopoma achatinum','Leptopoma achatinum','Leptopoma achatin',2,0,'','','Crosse','816fc510-db8e-52c7-a622-d6b9c1d69115','Leptopoma achatinum Crosse, 1865','Crosse, 1865','UNRANKED','','Leptopoma','','achatinum','','','',NULL,'','','','','','Crosse','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00153','','','Mitra aci Biondi, 1860',1,'Mitra aci','Mitra aci','Mitra ac',2,0,'','','Biondi','af696b09-d2f3-57a8-8c1e-5c7df646064d','Mitra aci Biondi, 1860','Biondi, 1860','UNRANKED','','Mitra','','aci','','','',NULL,'','','','','','Biondi','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00157','','','Dentalium acicula Deshayes, 1861',1,'Dentalium acicula','Dentalium acicula','Dentalium acicul',2,0,'','','Deshayes','bacb976c-c3f5-5e0e-8f84-6852488ab6b1','Dentalium acicula Deshayes, 1861','Deshayes, 1861','UNRANKED','','Dentalium','','acicula','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00160','','','Stilifer acicula Gould, 1851',1,'Stilifer acicula','Stilifer acicula','Stilifer acicul',2,0,'','','Gould','41e1e981-9aa7-57e0-9553-16205bab270e','Stilifer acicula Gould, 1851','Gould, 1851','UNRANKED','','Stilifer','','acicula','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00164','','','Turritella acicula Stimpson, 1851',1,'Turritella acicula','Turritella acicula','Turritella acicul',2,0,'','','Stimpson','c3afea4a-64f2-5ae2-9b5d-e75943552d9a','Turritella acicula Stimpson, 1851','Stimpson, 1851','UNRANKED','','Turritella','','acicula','','','',NULL,'','','','','','Stimpson','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00169','','','Paludina acicularis Hislop, 1860',1,'Paludina acicularis','Paludina acicularis','Paludina acicular',2,0,'','','Hislop','a42ca011-49ce-5b47-86b8-6a9c33417f6d','Paludina acicularis Hislop, 1860','Hislop, 1860','UNRANKED','','Paludina','','acicularis','','','',NULL,'','','','','','Hislop','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00175','','','Chemnitzia aciculatis A. Adams, 1853',1,'Chemnitzia aciculatis','Chemnitzia aciculatis','Chemnitzia aciculat',2,0,'','','A. Adams','5936a9e9-221c-5008-bc84-1ba292717abf','Chemnitzia aciculatis A. Adams, 1853','A. Adams, 1853','UNRANKED','','Chemnitzia','','aciculatis','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00179','','','Dentalium aciculum Gould, 1859',1,'Dentalium aciculum','Dentalium aciculum','Dentalium acicul',2,0,'','','Gould','3d96e300-3cc0-58c9-ba9f-396267663ddc','Dentalium aciculum Gould, 1859','Gould, 1859','UNRANKED','','Dentalium','','aciculum','','','',NULL,'','','','','','Gould','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00183','','','Trochus acies Fried. Roemer, 1850',1,'Trochus acies','Trochus acies','Trochus aci',2,0,'','','Fried. Roemer','ee837dc7-17bc-5b88-83be-207eccf5045a','Trochus acies Fried. Roemer, 1850','Fried. Roemer, 1850','UNRANKED','','Trochus','','acies','','','',NULL,'','','','','','Fried. Roemer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00190','','','Turbo acinosus Zekeli, 1852',1,'Turbo acinosus','Turbo acinosus','Turbo acinos',2,0,'','','Zekeli','f1c8494f-a453-599f-b860-68f114f77e1e','Turbo acinosus Zekeli, 1852','Zekeli, 1852','UNRANKED','','Turbo','','acinosus','','','',NULL,'','','','','','Zekeli','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00196','','','Helix acmella Pfeiffer, 1860',1,'Helix acmella','Helix acmella','Helix acmell',2,0,'','','Pfeiffer','5045b582-e38e-583c-a18a-ead4f9ed7c11','Helix acmella Pfeiffer, 1860','Pfeiffer, 1860','UNRANKED','','Helix','','acmella','','','',NULL,'','','','','','Pfeiffer','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00199','','','Turrilites acostae Orbigny, 1851',1,'Turrilites acostae','Turrilites acostae','Turrilites acost',2,0,'','','Orbigny','7c48dffa-b873-5308-baf7-2328775ad066','Turrilites acostae Orbigny, 1851','Orbigny, 1851','UNRANKED','','Turrilites','','acostae','','','',NULL,'','','','','','Orbigny','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00205','','','Purpurina acteoniformis Piette, 1855',1,'Purpurina acteoniformis','Purpurina acteoniformis','Purpurina acteoniform',2,0,'','','Piette','85e9eef4-859d-5c9f-ba70-efd893491d2e','Purpurina acteoniformis Piette, 1855','Piette, 1855','UNRANKED','','Purpurina','','acteoniformis','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00209','','','Pecten actoni Martens, 1856',1,'Pecten actoni','Pecten actoni','Pecten acton',2,0,'','','Martens','9fd0a772-ecb1-5c2e-ad1d-a92cfd18954f','Pecten actoni Martens, 1856','Martens, 1856','UNRANKED','','Pecten','','actoni','','','',NULL,'','','','','','Martens','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00212','','','Partulus actor Albers, 1850',1,'Partulus actor','Partulus actor','Partulus actor',2,0,'','','Albers','115f6656-e5fc-5eb4-9065-17b3f8ae9241','Partulus actor Albers, 1850','Albers, 1850','UNRANKED','','Partulus','','actor','','','',NULL,'','','','','','Albers','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00217','','','Emarginula aculeata A. Adams, 1851',1,'Emarginula aculeata','Emarginula aculeata','Emarginula aculeat',2,0,'','','A. Adams','13d8c507-4ee1-5036-b815-bcc867ca3b40','Emarginula aculeata A. Adams, 1851','A. Adams, 1851','UNRANKED','','Emarginula','','aculeata','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00223','','','Eulima acumen Deshayes, 1862',1,'Eulima acumen','Eulima acumen','Eulima acumen',2,0,'','','Deshayes','65011324-25d9-5a8d-a512-26f3261bfd78','Eulima acumen Deshayes, 1862','Deshayes, 1862','UNRANKED','','Eulima','','acumen','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00227','','','Anatina acuminata Eichwald, 1868',1,'Anatina acuminata','Anatina acuminata','Anatina acuminat',2,0,'','','Eichwald','469c0806-dfc8-5fa7-bf7a-515195a38cf1','Anatina acuminata Eichwald, 1868','Eichwald, 1868','UNRANKED','','Anatina','','acuminata','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00232','','','Cypraea acuminata Schafhäutl, 1863',1,'Cypraea acuminata','Cypraea acuminata','Cypraea acuminat',2,0,'','','Schafhäutl','4e72be11-3f95-5fe0-9eb6-0f84d6bc26d0','Cypraea acuminata Schafhäutl, 1863','Schafhäutl, 1863','UNRANKED','','Cypraea','','acuminata','','','',NULL,'','','','','','Schafhäutl','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00237','','','Eulima acuminata J. Müller, 1851',1,'Eulima acuminata','Eulima acuminata','Eulima acuminat',2,0,'','','J. Müller','d29a4cc1-72a1-5a42-8e95-5154cbbee9da','Eulima acuminata J. Müller, 1851','J. Müller, 1851','UNRANKED','','Eulima','','acuminata','','','',NULL,'','','','','','J. Müller','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00243','','','Linteria acuminata G. Sowerby, 1870',1,'Linteria acuminata','Linteria acuminata','Linteria acuminat',2,0,'','','G. Sowerby','32bebb98-1c10-5752-9c65-5b3ecc9e1072','Linteria acuminata G. Sowerby, 1870','G. Sowerby, 1870','UNRANKED','','Linteria','','acuminata','','','',NULL,'','','','','','G. Sowerby','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00249','','','Perna acuminata Zittel, 1866',1,'Perna acuminata','Perna acuminata','Perna acuminat',2,0,'','','Zittel','db2e44cc-1dfb-55a3-9931-55e6a774560d','Perna acuminata Zittel, 1866','Zittel, 1866','UNRANKED','','Perna','','acuminata','','','',NULL,'','','','','','Zittel','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00253','','','Pterocera acuminata Piette, 1855',1,'Pterocera acuminata','Pterocera acuminata','Pterocera acuminat',2,0,'','','Piette','f0498315-0d80-5cf9-b455-f501dc79be75','Pterocera acuminata Piette, 1855','Piette, 1855','UNRANKED','','Pterocera','','acuminata','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00259','','','Tapes acuminata G. Sowerby, 1852',1,'Tapes acuminata','Tapes acuminata','Tapes acuminat',2,0,'','','G. Sowerby','0ab302e5-4771-5169-9444-160b1d42c424','Tapes acuminata G. Sowerby, 1852','G. Sowerby, 1852','UNRANKED','','Tapes','','acuminata','','','',NULL,'','','','','','G. Sowerby','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00263','','','Cerithium acuminatum Zekeli, 1852',1,'Cerithium acuminatum','Cerithium acuminatum','Cerithium acuminat',2,0,'','','Zekeli','74258586-3d00-5a4e-b745-4b02f51e2d38','Cerithium acuminatum Zekeli, 1852','Zekeli, 1852','UNRANKED','','Cerithium','','acuminatum','','','',NULL,'','','','','','Zekeli','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00266','','','Acteon acuminatus Piette, 1856',1,'Acteon acuminatus','Acteon acuminatus','Acteon acuminat',2,0,'','','Piette','8e762328-66f4-5b82-bae6-eea2ed4aec72','Acteon acuminatus Piette, 1856','Piette, 1856','UNRANKED','','Acteon','','acuminatus','','','',NULL,'','','','','','Piette','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00271','','','Unio acuminatus H. Adams, 1866',1,'Unio acuminatus','Unio acuminatus','Unio acuminat',2,0,'','','H. Adams','ce5a2cea-a0d8-58f9-bb7b-5c6d8d986dbd','Unio acuminatus H. Adams, 1866','H. Adams, 1866','UNRANKED','','Unio','','acuminatus','','','',NULL,'','','','','','H. Adams','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00274','','','Bulimus acus Pfeiffer, 1852',1,'Bulimus acus','Bulimus acus','Bulimus ac',2,0,'','','Pfeiffer','83e3a9dd-c111-5271-a1c4-6a2c48807513','Bulimus acus Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Bulimus','','acus','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00280','','','Turritella acus Eichwald, 1857',1,'Turritella acus','Turritella acus','Turritella ac',2,0,'','','Eichwald','2f60dbba-1e4f-55d6-88cb-73467022ea12','Turritella acus Eichwald, 1857','Eichwald, 1857','UNRANKED','','Turritella','','acus','','','',NULL,'','','','','','Eichwald','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00283','','','Ceritella acuta Morris and Lycett, 1854',1,'Ceritella acuta','Ceritella acuta','Ceritella acut',2,0,'','','Morris|Lycett','6b4da949-b256-52b1-9ac2-2037046acc8c','Ceritella acuta Morris and Lycett, 1854','Morris and Lycett, 1854','UNRANKED','','Ceritella','','acuta','','','',NULL,'','','','','','Morris & Lycett','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00292','','','Nassa pagodus acuta P. Carpenter, 1857',1,'Nassa pagodus acuta','Nassa pagodus acuta','Nassa pagod acut',3,0,'','','P. Carpenter','d5201519-3b9c-5d56-a3ec-eb523e125a7a','Nassa pagodus acuta P. Carpenter, 1857','P. Carpenter, 1857','UNRANKED','','Nassa','','pagodus','acuta','','',NULL,'','','','','','P. Carpenter','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00297','','','Saxicava acuta Folin, 1867',1,'Saxicava acuta','Saxicava acuta','Saxicava acut',2,0,'','','Folin','b4651730-531f-5264-90ff-84ed4cf5855b','Saxicava acuta Folin, 1867','Folin, 1867','UNRANKED','','Saxicava','','acuta','','','',NULL,'','','','','','Folin','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00302','','','Turritella acuta Mayer, 1859',1,'Turritella acuta','Turritella acuta','Turritella acut',2,0,'','','Mayer','1152d73d-bfc9-5705-9119-f2d5a616adae','Turritella acuta Mayer, 1859','Mayer, 1859','UNRANKED','','Turritella','','acuta','','','',NULL,'','','','','','Mayer','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00306','','','Crassatella acutangula Bellardi, 1852',1,'Crassatella acutangula','Crassatella acutangula','Crassatella acutangul',2,0,'','','Bellardi','f2dded17-4487-5b16-bfc8-fac743c6044c','Crassatella acutangula Bellardi, 1852','Bellardi, 1852','UNRANKED','','Crassatella','','acutangula','','','',NULL,'','','','','','Bellardi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00310','','','Helix planata acutangula R. Lowe, 1861',1,'Helix planata acutangula','Helix planata acutangula','Helix planat acutangul',3,0,'','','R. Lowe','acfac7ad-c8ec-57b5-9dc7-5c52c43dc547','Helix planata acutangula R. Lowe, 1861','R. Lowe, 1861','UNRANKED','','Helix','','planata','acutangula','','',NULL,'','','','','','R. Lowe','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00313','','','Lutraria acutangula Michelotti, 1861',1,'Lutraria acutangula','Lutraria acutangula','Lutraria acutangul',2,0,'','','Michelotti','95ac62d3-0bc9-5404-a40e-418794b16464','Lutraria acutangula Michelotti, 1861','Michelotti, 1861','UNRANKED','','Lutraria','','acutangula','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00317','','','Cyrena acutangularis Deshayes, 1857',1,'Cyrena acutangularis','Cyrena acutangularis','Cyrena acutangular',2,0,'','','Deshayes','1f99a84e-ebd9-5c50-afdd-0b4a99981268','Cyrena acutangularis Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cyrena','','acutangularis','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00321','','','Solen acutangulus Dunker, 1868',1,'Solen acutangulus','Solen acutangulus','Solen acutangul',2,0,'','','Dunker','9c1ea2be-287a-5d5d-a2ab-bf5e94390d3c','Solen acutangulus Dunker, 1868','Dunker, 1868','UNRANKED','','Solen','','acutangulus','','','',NULL,'','','','','','Dunker','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00324','','','Donax acutata Deshayes, 1857',1,'Donax acutata','Donax acutata','Donax acutat',2,0,'','','Deshayes','51098259-cc04-5b86-a337-01619854066f','Donax acutata Deshayes, 1857','Deshayes, 1857','UNRANKED','','Donax','','acutata','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00329','','','Rissoa acutelirata P. Carpenter, 1864',1,'Rissoa acutelirata','Rissoa acutelirata','Rissoa acutelirat',2,0,'','','P. Carpenter','379fc940-2e4c-5bb3-9133-fa8e5c87f040','Rissoa acutelirata P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Rissoa','','acutelirata','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00336','','','Cypricardia acuticarinata Terquem and Jourdy, 1869',1,'Cypricardia acuticarinata','Cypricardia acuticarinata','Cypricardia acuticarinat',2,0,'','','Terquem|Jourdy','d0852441-c51a-5d56-9ee4-ea3626c60026','Cypricardia acuticarinata Terquem and Jourdy, 1869','Terquem and Jourdy, 1869','UNRANKED','','Cypricardia','','acuticarinata','','','',NULL,'','','','','','Terquem & Jourdy','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00341','','','Cerithium acuticosta Michelotti, 1861',1,'Cerithium acuticosta','Cerithium acuticosta','Cerithium acuticost',2,0,'','','Michelotti','b702aaf1-e189-5b58-8a59-a2f009cdf852','Cerithium acuticosta Michelotti, 1861','Michelotti, 1861','UNRANKED','','Cerithium','','acuticosta','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00349','','','Hemifusus acuticostatus Stoliczka, 1867',1,'Hemifusus acuticostatus','Hemifusus acuticostatus','Hemifusus acuticostat',2,0,'','','Stoliczka','c42f5abc-b7a0-5b3e-9ab5-49fffdcba495','Hemifusus acuticostatus Stoliczka, 1867','Stoliczka, 1867','UNRANKED','','Hemifusus','','acuticostatus','','','',NULL,'','','','','','Stoliczka','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00354','','','Ctenoides acutilineata Conrad, 1858',1,'Ctenoides acutilineata','Ctenoides acutilineata','Ctenoides acutilineat',2,0,'','','Conrad','87d2161f-e33b-51af-b147-8d17af503c0d','Ctenoides acutilineata Conrad, 1858','Conrad, 1858','UNRANKED','','Ctenoides','','acutilineata','','','',NULL,'','','','','','Conrad','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00360','','','Pecten acutiplicatus Meek, 1864',1,'Pecten acutiplicatus','Pecten acutiplicatus','Pecten acutiplicat',2,0,'','','Meek','1d019fb8-69f6-5ac8-bfb1-899573b03bee','Pecten acutiplicatus Meek, 1864','Meek, 1864','UNRANKED','','Pecten','','acutiplicatus','','','',NULL,'','','','','','Meek','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00365','','','Unio acutirostris Lea, 1866',1,'Unio acutirostris','Unio acutirostris','Unio acutirostr',2,0,'','','Lea','0dcb6178-4e40-529e-823e-cb5cce240f0f','Unio acutirostris Lea, 1866','Lea, 1866','UNRANKED','','Unio','','acutirostris','','','',NULL,'','','','','','Lea','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00368','','','Natica acutispira Shumard, 1860',1,'Natica acutispira','Natica acutispira','Natica acutispir',2,0,'','','Shumard','b8f386e0-e23d-5fd8-8927-938fc7c3b7db','Natica acutispira Shumard, 1860','Shumard, 1860','UNRANKED','','Natica','','acutispira','','','',NULL,'','','','','','Shumard','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00372','','','Melania acutissima Busch, 1858',1,'Melania acutissima','Melania acutissima','Melania acutissim',2,0,'','','Busch','ca40ff7c-0ad9-547a-991b-7c546faa8876','Melania acutissima Busch, 1858','Busch, 1858','UNRANKED','','Melania','','acutissima','','','',NULL,'','','','','','Busch','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00376','','','Phasianella acutiuscula Lycett, 1850',1,'Phasianella acutiuscula','Phasianella acutiuscula','Phasianella acutiuscul',2,0,'','','Lycett','439dcc49-f148-52c0-bfc2-dd485b191c38','Phasianella acutiuscula Lycett, 1850','Lycett, 1850','UNRANKED','','Phasianella','','acutiuscula','','','',NULL,'','','','','','Lycett','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00380','','','Paludomus acutus Reeve, 1852',1,'Paludomus acutus','Paludomus acutus','Paludomus acut',2,0,'','','Reeve','44332737-9434-5853-98f3-226fc484e753','Paludomus acutus Reeve, 1852','Reeve, 1852','UNRANKED','','Paludomus','','acutus','','','',NULL,'','','','','','Reeve','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00384','','','Unio acutus Schafhäutl, 1863',1,'Unio acutus','Unio acutus','Unio acut',2,0,'','','Schafhäutl','bd20fecb-bf91-5f95-ba28-4641d1389bf7','Unio acutus Schafhäutl, 1863','Schafhäutl, 1863','UNRANKED','','Unio','','acutus','','','',NULL,'','','','','','Schafhäutl','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00387','','','Semele ada A. Adams and Angas, 1863',1,'Semele ada','Semele ada','Semele ad',2,0,'','','A. Adams|Angas','960cc1d9-f4c7-5200-85d9-f76a95637b07','Semele ada A. Adams and Angas, 1863','A. Adams and Angas, 1863','UNRANKED','','Semele','','ada','','','',NULL,'','','','','','A. Adams & Angas','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00392','','','Bulla adamsi Menke, 1850',1,'Bulla adamsi','Bulla adamsi','Bulla adams',2,0,'','','Menke','5e6cf627-a3f1-5b41-b13b-17ed7a0de172','Bulla adamsi Menke, 1850','Menke, 1850','UNRANKED','','Bulla','','adamsi','','','',NULL,'','','','','','Menke','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00397','','','Lepton adamsi Angas, 1867',1,'Lepton adamsi','Lepton adamsi','Lepton adams',2,0,'','','Angas','d275d0b4-9e65-53f7-bf4b-143967ac7f61','Lepton adamsi Angas, 1867','Angas, 1867','UNRANKED','','Lepton','','adamsi','','','',NULL,'','','','','','Angas','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00402','','','Obeliscus adamsi P. Carpenter, 1864',1,'Obeliscus adamsi','Obeliscus adamsi','Obeliscus adams',2,0,'','','P. Carpenter','d9020ef5-bfc1-5d0a-a211-281040639047','Obeliscus adamsi P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Obeliscus','','adamsi','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00407','','','Scintilla adamsi Deshayes, 1855',1,'Scintilla adamsi','Scintilla adamsi','Scintilla adams',2,0,'','','Deshayes','0d339cff-51f8-5b3d-8c7c-594615626deb','Scintilla adamsi Deshayes, 1855','Deshayes, 1855','UNRANKED','','Scintilla','','adamsi','','','',NULL,'','','','','','Deshayes','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00411','','','Achatina adamsiana Chitty, 1853',1,'Achatina adamsiana','Achatina adamsiana','Achatina adamsian',2,0,'','','Chitty','79f4b136-40a6-50bf-9c99-6c14606632c7','Achatina adamsiana Chitty, 1853','Chitty, 1853','UNRANKED','','Achatina','','adamsiana','','','',NULL,'','','','','','Chitty','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00417','','','Emarginula adamsiana G. Sowerby, in A. Adams and Sowerby, 1863',2,'Emarginula adamsiana','Emarginula adamsiana','Emarginula adamsian',2,0,'','','G. Sowerby|A. Adams|Sowerby','60921230-0d6c-5aa0-82c1-ed5bde3f71b7','Emarginula adamsiana G. Sowerby, in A. Adams and Sowerby, 1863','G. Sowerby, in A. Adams and Sowerby, 1863','UNRANKED','','Emarginula','','adamsiana','','','',NULL,'','','','','','G. Sowerby','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00426','','','Trochus adamsianus Schrenck, 1867',1,'Trochus adamsianus','Trochus adamsianus','Trochus adamsian',2,0,'','','Schrenck','c9c1b431-aa19-556c-a259-9f2c2fd39516','Trochus adamsianus Schrenck, 1867','Schrenck, 1867','UNRANKED','','Trochus','','adamsianus','','','',NULL,'','','','','','Schrenck','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00431','','','Tritonium adansonii Dunker, 1853',1,'Tritonium adansonii','Tritonium adansonii','Tritonium adanson',2,0,'','','Dunker','fdae92e9-1551-5749-8f5c-87323d3d3697','Tritonium adansonii Dunker, 1853','Dunker, 1853','UNRANKED','','Tritonium','','adansonii','','','',NULL,'','','','','','Dunker','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00436','','','Buliminus (Chondrula) adelaidae A. Adams and Angas, in Angas, 1863',2,'Buliminus adelaidae','Buliminus adelaidae','Buliminus adelaid',2,0,'','','A. Adams|Angas','b87b45d6-ebf5-5bae-8510-0e3792a5c795','Buliminus (Chondrula) adelaidae A. Adams and Angas, in Angas, 1863','A. Adams and Angas, in Angas, 1863','UNRANKED','','Buliminus','Chondrula','adelaidae','','','',NULL,'','','','','','A. Adams & Angas','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00441','','','Buccinum adelaidense Crosse, 1864',1,'Buccinum adelaidense','Buccinum adelaidense','Buccinum adelaidens',2,0,'','','Crosse','7f13eacb-af1d-5f40-9166-8070139afdf1','Buccinum adelaidense Crosse, 1864','Crosse, 1864','UNRANKED','','Buccinum','','adelaidense','','','',NULL,'','','','','','Crosse','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00445','','','Limnaea adelinae Tryon, 1863',1,'Limnaea adelinae','Limnaea adelinae','Limnaea adelin',2,0,'','','Tryon','7cbb184a-051a-5ae1-9784-d6b512a3a178','Limnaea adelinae Tryon, 1863','Tryon, 1863','UNRANKED','','Limnaea','','adelinae','','','',NULL,'','','','','','Tryon','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00448','','','Gundlachia adelosia Bourguignat, 1862',1,'Gundlachia adelosia','Gundlachia adelosia','Gundlachia adelos',2,0,'','','Bourguignat','3b70cbfd-411c-5b3b-8bff-cc5eee8ab82a','Gundlachia adelosia Bourguignat, 1862','Bourguignat, 1862','UNRANKED','','Gundlachia','','adelosia','','','',NULL,'','','','','','Bourguignat','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00454','','','Astarte adherbalesis Coquand, 1862',1,'Astarte adherbalesis','Astarte adherbalesis','Astarte adherbales',2,0,'','','Coquand','f20afb81-f2d7-57aa-b8cd-89a43ae64fda','Astarte adherbalesis Coquand, 1862','Coquand, 1862','UNRANKED','','Astarte','','adherbalesis','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00459','','','Ostodes adjunctus Mousson, 1869',1,'Ostodes adjunctus','Ostodes adjunctus','Ostodes adiunct',2,0,'','','Mousson','df168d2a-fd8b-565e-b9f3-9f1bc5487a31','Ostodes adjunctus Mousson, 1869','Mousson, 1869','UNRANKED','','Ostodes','','adjunctus','','','',NULL,'','','','','','Mousson','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00464','','','Cyclostoma (Choanopoma) adolfi Pfeiffer, 1852',1,'Cyclostoma adolfi','Cyclostoma adolfi','Cyclostoma adolf',2,0,'','','Pfeiffer','477ba3f9-09ff-52e5-ad6d-20aebe9b3f08','Cyclostoma (Choanopoma) adolfi Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Cyclostoma','Choanopoma','adolfi','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00467','','','Barbatia adolphi Dunker, 1868',1,'Barbatia adolphi','Barbatia adolphi','Barbatia adolph',2,0,'','','Dunker','5f1f6eda-d56c-5a8d-a98a-6950f9e88f86','Barbatia adolphi Dunker, 1868','Dunker, 1868','UNRANKED','','Barbatia','','adolphi','','','',NULL,'','','','','','Dunker','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00472','','','Modiolopsis adrastia Billings, 1865',1,'Modiolopsis adrastia','Modiolopsis adrastia','Modiolopsis adrast',2,0,'','','Billings','da58053e-923b-5e65-83b9-08af3caf4e25','Modiolopsis adrastia Billings, 1865','Billings, 1865','UNRANKED','','Modiolopsis','','adrastia','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00476','','','Nerita (Clithon) adspersa Recluz, 1853',1,'Nerita adspersa','Nerita adspersa','Nerita adspers',2,0,'','','Recluz','ae17b5be-2165-54aa-82e7-629542857450','Nerita (Clithon) adspersa Recluz, 1853','Recluz, 1853','UNRANKED','','Nerita','Clithon','adspersa','','','',NULL,'','','','','','Recluz','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00480','','','Neritina adumbrata Reeve, 1855',1,'Neritina adumbrata','Neritina adumbrata','Neritina adumbrat',2,0,'','','Reeve','283e4a6b-d45c-5b66-99c6-dd0567491ca0','Neritina adumbrata Reeve, 1855','Reeve, 1855','UNRANKED','','Neritina','','adumbrata','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00482','','','Crista adunca E. Römer, 1869',1,'Crista adunca','Crista adunca','Crista adunc',2,0,'','','E. Römer','b414339d-9a78-5058-b51b-bd7f10097f41','Crista adunca E. Römer, 1869','E. Römer, 1869','UNRANKED','','Crista','','adunca','','','',NULL,'','','','','','E. Römer','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00486','','','Ampullaria adusta Reeve, 1856',1,'Ampullaria adusta','Ampullaria adusta','Ampullaria adust',2,0,'','','Reeve','e160117a-d443-541d-8de0-826efe59d48b','Ampullaria adusta Reeve, 1856','Reeve, 1856','UNRANKED','','Ampullaria','','adusta','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00491','','','Busycon adversarium Conrad, 1862',1,'Busycon adversarium','Busycon adversarium','Busycon aduersari',2,0,'','','Conrad','93f9ab6a-b866-5607-ac5a-a24be9274ed4','Busycon adversarium Conrad, 1862','Conrad, 1862','UNRANKED','','Busycon','','adversarium','','','',NULL,'','','','','','Conrad','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00497','','','Helix aegrotus Reeve, 1851',1,'Helix aegrotus','Helix aegrotus','Helix aegrot',2,0,'','','Reeve','224e85c2-1ad1-5541-aa37-cf2cebe7294d','Helix aegrotus Reeve, 1851','Reeve, 1851','UNRANKED','','Helix','','aegrotus','','','',NULL,'','','','','','Reeve','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00501','','','Helix aemula Rossmässler, in Pfeiffer, 1853',2,'Helix aemula','Helix aemula','Helix aemul',2,0,'','','Rossmässler|Pfeiffer','4413abdf-524f-5eed-afa0-9eff34619694','Helix aemula Rossmässler, in Pfeiffer, 1853','Rossmässler, in Pfeiffer, 1853','UNRANKED','','Helix','','aemula','','','',NULL,'','','','','','Rossmässler','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00508','','','Cancellaria aequaeva Ryckholt, 1861',1,'Cancellaria aequaeva','Cancellaria aequaeva','Cancellaria aequaeu',2,0,'','','Ryckholt','4304586e-e3c5-52c1-99f3-98ec88da98ae','Cancellaria aequaeva Ryckholt, 1861','Ryckholt, 1861','UNRANKED','','Cancellaria','','aequaeva','','','',NULL,'','','','','','Ryckholt','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00509','','','Cardium aequale Deshayes, 1854',1,'Cardium aequale','Cardium aequale','Cardium aequal',2,0,'','','Deshayes','867edf50-bf3b-5afb-80e4-3daaedc5a58e','Cardium aequale Deshayes, 1854','Deshayes, 1854','UNRANKED','','Cardium','','aequale','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00514','','','Defrancia linearis aequalis Jeffreys, 1867',1,'Defrancia linearis aequalis','Defrancia linearis aequalis','Defrancia linear aequal',3,0,'','','Jeffreys','d4d61f18-6cd5-507b-a0b2-4352f311f983','Defrancia linearis aequalis Jeffreys, 1867','Jeffreys, 1867','UNRANKED','','Defrancia','','linearis','aequalis','','',NULL,'','','','','','Jeffreys','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00517','','','Lucinopsis undata aequalis Jeffreys, 1863',1,'Lucinopsis undata aequalis','Lucinopsis undata aequalis','Lucinopsis undat aequal',3,0,'','','Jeffreys','5b3c5fb1-0964-5b81-82ca-b68d2867eeda','Lucinopsis undata aequalis Jeffreys, 1863','Jeffreys, 1863','UNRANKED','','Lucinopsis','','undata','aequalis','','',NULL,'','','','','','Jeffreys','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00521','','','Potamomya aequalis C.B. Adams, 1852',1,'Potamomya aequalis','Potamomya aequalis','Potamomya aequal',2,0,'','','C. B. Adams','d21cd10a-62d3-5cb8-9653-01b373c6a6fc','Potamomya aequalis C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Potamomya','','aequalis','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00527','','','Helix aequatoriana Hidalgo, 1867',1,'Helix aequatoriana','Helix aequatoriana','Helix aequatorian',2,0,'','','Hidalgo','6f7f3ea7-a3b2-5dc8-a2c8-6f43dc204108','Helix aequatoriana Hidalgo, 1867','Hidalgo, 1867','UNRANKED','','Helix','','aequatoriana','','','',NULL,'','','','','','Hidalgo','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00532','','','Zonites aequatus Mousson, 1854',1,'Zonites aequatus','Zonites aequatus','Zonites aequat',2,0,'','','Mousson','62700a9b-14cb-5381-8cb4-787173c92a2b','Zonites aequatus Mousson, 1854','Mousson, 1854','UNRANKED','','Zonites','','aequatus','','','',NULL,'','','','','','Mousson','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00537','','','Cyrena aequilatera Deshayes, 1854',1,'Cyrena aequilatera','Cyrena aequilatera','Cyrena aequilater',2,0,'','','Deshayes','e1186d24-bbe7-5692-8b2e-32e7a8face56','Cyrena aequilatera Deshayes, 1854','Deshayes, 1854','UNRANKED','','Cyrena','','aequilatera','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00542','','','Lima aequilateralis Terquem and Piette, 1865',1,'Lima aequilateralis','Lima aequilateralis','Lima aequilateral',2,0,'','','Terquem|Piette','da60c1f1-1fe5-5267-a615-00a60c254c03','Lima aequilateralis Terquem and Piette, 1865','Terquem and Piette, 1865','UNRANKED','','Lima','','aequilateralis','','','',NULL,'','','','','','Terquem & Piette','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00548','','','Pisania pagodus aequilirata P. Carpenter, 1857',1,'Pisania pagodus aequilirata','Pisania pagodus aequilirata','Pisania pagod aequilirat',3,0,'','','P. Carpenter','3577192a-2e50-550a-9544-fdc1ba96d810','Pisania pagodus aequilirata P. Carpenter, 1857','P. Carpenter, 1857','UNRANKED','','Pisania','','pagodus','aequilirata','','',NULL,'','','','','','P. Carpenter','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00553','','','Cassis aequinodosa F. Sandberger, 1863',1,'Cassis aequinodosa','Cassis aequinodosa','Cassis aequinodos',2,0,'','','F. Sandberger','d138a912-5532-53ea-9af7-ada076d1fdf5','Cassis aequinodosa F. Sandberger, 1863','F. Sandberger, 1863','UNRANKED','','Cassis','','aequinodosa','','','',NULL,'','','','','','F. Sandberger','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00559','','','Cytherea aequistriata Mayer, 1863',1,'Cytherea aequistriata','Cytherea aequistriata','Cytherea aequistriat',2,0,'','','Mayer','4cab8601-b596-5848-849b-baed0833cf8a','Cytherea aequistriata Mayer, 1863','Mayer, 1863','UNRANKED','','Cytherea','','aequistriata','','','',NULL,'','','','','','Mayer','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00564','','','Pecten aequisulcatus P. Carpenter, 1864',1,'Pecten aequisulcatus','Pecten aequisulcatus','Pecten aequisulcat',2,0,'','','P. Carpenter','61aa435d-e66c-50a8-91c9-ce6ee2bcb3b5','Pecten aequisulcatus P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Pecten','','aequisulcatus','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00570','','','Unio aereus G. Sowerby, 1856',1,'Unio aereus','Unio aereus','Unio aere',2,0,'','','G. Sowerby','a6538cf5-f966-5984-bac6-ce138628f56c','Unio aereus G. Sowerby, 1856','G. Sowerby, 1856','UNRANKED','','Unio','','aereus','','','',NULL,'','','','','','G. Sowerby','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00576','','','Neptunea aestuosa Gould, 1860',1,'Neptunea aestuosa','Neptunea aestuosa','Neptunea aestuos',2,0,'','','Gould','f294345d-34d6-5eee-9672-0e267cf1452a','Neptunea aestuosa Gould, 1860','Gould, 1860','UNRANKED','','Neptunea','','aestuosa','','','',NULL,'','','','','','Gould','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00581','','','Unio aethiops Lea, 1860',1,'Unio aethiops','Unio aethiops','Unio aethiops',2,0,'','','Lea','f79fb20c-487d-5d75-a0e8-553fc05c2195','Unio aethiops Lea, 1860','Lea, 1860','UNRANKED','','Unio','','aethiops','','','',NULL,'','','','','','Lea','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00586','','','Dentalium affine Deshayes, 1861',1,'Dentalium affine','Dentalium affine','Dentalium affin',2,0,'','','Deshayes','c42f78c9-e472-56b6-916d-913519f4e985','Dentalium affine Deshayes, 1861','Deshayes, 1861','UNRANKED','','Dentalium','','affine','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00591','','','Achatinella affinis Newcomb, 1853',1,'Achatinella affinis','Achatinella affinis','Achatinella affin',2,0,'','','Newcomb','71b4ce1c-c18e-5f19-8d32-8f670b775545','Achatinella affinis Newcomb, 1853','Newcomb, 1853','UNRANKED','','Achatinella','','affinis','','','',NULL,'','','','','','Newcomb','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00596','','','Chemnitzia affinis C.B. Adams, 1852',1,'Chemnitzia affinis','Chemnitzia affinis','Chemnitzia affin',2,0,'','','C. B. Adams','d0019194-6b6d-5e7b-b06e-ba55d032709f','Chemnitzia affinis C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Chemnitzia','','affinis','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00602','','','Donax affinis Deshayes, 1854',1,'Donax affinis','Donax affinis','Donax affin',2,0,'','','Deshayes','888a9c20-6544-528a-86c8-f62ef13df883','Donax affinis Deshayes, 1854','Deshayes, 1854','UNRANKED','','Donax','','affinis','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00607','','','Ianthina affinis Reeve, 1858',1,'Ianthina affinis','Ianthina affinis','Ianthina affin',2,0,'','','Reeve','b5cc3c03-75b4-595e-a31c-9ab3fc407109','Ianthina affinis Reeve, 1858','Reeve, 1858','UNRANKED','','Ianthina','','affinis','','','',NULL,'','','','','','Reeve','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00614','','','Lymnaea affinis Souleyet, 1852',1,'Lymnaea affinis','Lymnaea affinis','Lymnaea affin',2,0,'','','Souleyet','2e72d682-3464-5ce3-adc0-be43ff731985','Lymnaea affinis Souleyet, 1852','Souleyet, 1852','UNRANKED','','Lymnaea','','affinis','','','',NULL,'','','','','','Souleyet','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00620','','','Navicella affinis Reeve, 1856',1,'Navicella affinis','Navicella affinis','Navicella affin',2,0,'','','Reeve','ef918c74-d8f3-5ed3-aa6e-a120c204f9a1','Navicella affinis Reeve, 1856','Reeve, 1856','UNRANKED','','Navicella','','affinis','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00625','','','Paludina affinis Martens, 1865',1,'Paludina affinis','Paludina affinis','Paludina affin',2,0,'','','Martens','824ce909-34a4-5383-8b8a-a4efef331935','Paludina affinis Martens, 1865','Martens, 1865','UNRANKED','','Paludina','','affinis','','','',NULL,'','','','','','Martens','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00629','','','Pholadomya affinis Bellardi, 1852',1,'Pholadomya affinis','Pholadomya affinis','Pholadomya affin',2,0,'','','Bellardi','17a385f2-9106-5c51-917e-2e49560903ad','Pholadomya affinis Bellardi, 1852','Bellardi, 1852','UNRANKED','','Pholadomya','','affinis','','','',NULL,'','','','','','Bellardi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00633','','','Psammobia affinis Reeve, 1856',1,'Psammobia affinis','Psammobia affinis','Psammobia affin',2,0,'','','Reeve','4c18f58c-7123-5f46-ae70-baa4dcd78ec1','Psammobia affinis Reeve, 1856','Reeve, 1856','UNRANKED','','Psammobia','','affinis','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00637','','','Scissurella affinis O. Costa, 1861',1,'Scissurella affinis','Scissurella affinis','Scissurella affin',2,0,'','','O. Costa','d70eefd6-2368-5198-9dee-5936e3002b71','Scissurella affinis O. Costa, 1861','O. Costa, 1861','UNRANKED','','Scissurella','','affinis','','','',NULL,'','','','','','O. Costa','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00645','','','Trivia affinis Marrat, 1867',1,'Trivia affinis','Trivia affinis','Trivia affin',2,0,'','','Marrat','782ec65b-b399-5151-9fc8-babcf35dfc32','Trivia affinis Marrat, 1867','Marrat, 1867','UNRANKED','','Trivia','','affinis','','','',NULL,'','','','','','Marrat','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00650','','','Helix afra Pfeiffer, 1859',1,'Helix afra','Helix afra','Helix afr',2,0,'','','Pfeiffer','dbecae63-7dbe-5f87-8cec-89fdc985cb36','Helix afra Pfeiffer, 1859','Pfeiffer, 1859','UNRANKED','','Helix','','afra','','','',NULL,'','','','','','Pfeiffer','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00654','','','Cyprina africana Coquand, 1862',1,'Cyprina africana','Cyprina africana','Cyprina african',2,0,'','','Coquand','b404a90e-8f30-5bc9-a7f8-4c90cfcdda70','Cyprina africana Coquand, 1862','Coquand, 1862','UNRANKED','','Cyprina','','africana','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00659','','','Sanguinolaria africana Sharpe, 1856',1,'Sanguinolaria africana','Sanguinolaria africana','Sanguinolaria african',2,0,'','','Sharpe','cd565273-8334-5532-81f9-7abe5bad855b','Sanguinolaria africana Sharpe, 1856','Sharpe, 1856','UNRANKED','','Sanguinolaria','','africana','','','',NULL,'','','','','','Sharpe','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00664','','','Buccinum afrum Philippi, 1851',1,'Buccinum afrum','Buccinum afrum','Buccinum afr',2,0,'','','Philippi','db41cc5d-1f81-51ca-bf12-3542337c7d9b','Buccinum afrum Philippi, 1851','Philippi, 1851','UNRANKED','','Buccinum','','afrum','','','',NULL,'','','','','','Philippi','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00667','','','Cyclostoma agassizii Charpentier, in Pfeiffer, 1854',2,'Cyclostoma agassizii','Cyclostoma agassizii','Cyclostoma agassiz',2,0,'','','Charpentier|Pfeiffer','6d155f36-6f45-5623-9a9a-a4f2cf69eae7','Cyclostoma agassizii Charpentier, in Pfeiffer, 1854','Charpentier, in Pfeiffer, 1854','UNRANKED','','Cyclostoma','','agassizii','','','',NULL,'','','','','','Charpentier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00673','','','Venus agassizii Orbigny, 1852',1,'Venus agassizii','Venus agassizii','Venus agassiz',2,0,'','','Orbigny','41a0f123-e0a8-5fe6-ae50-bc690eb9a25d','Venus agassizii Orbigny, 1852','Orbigny, 1852','UNRANKED','','Venus','','agassizii','','','',NULL,'','','','','','Orbigny','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00677','','','Arion aggericola Mabille, 1870',1,'Arion aggericola','Arion aggericola','Arion aggericol',2,0,'','','Mabille','9e6f445d-2152-5617-9c0d-649e2799c45f','Arion aggericola Mabille, 1870','Mabille, 1870','UNRANKED','','Arion','','aggericola','','','',NULL,'','','','','','Mabille','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00684','','','Pleurotoma aglaia Mayer, 1862',1,'Pleurotoma aglaia','Pleurotoma aglaia','Pleurotoma agla',2,0,'','','Mayer','11af010d-6b3b-5dad-a497-416d86858a3c','Pleurotoma aglaia Mayer, 1862','Mayer, 1862','UNRANKED','','Pleurotoma','','aglaia','','','',NULL,'','','','','','Mayer','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00690','','','Nanina aglypta Dohrn, 1866',1,'Nanina aglypta','Nanina aglypta','Nanina aglypt',2,0,'','','Dohrn','76b149f9-e4d9-54d5-bb6e-e8775c9fabd1','Nanina aglypta Dohrn, 1866','Dohrn, 1866','UNRANKED','','Nanina','','aglypta','','','',NULL,'','','','','','Dohrn','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00693','','','Succinea agonostoma Küster, 1856',1,'Succinea agonostoma','Succinea agonostoma','Succinea agonostom',2,0,'','','Küster','b4123114-3637-5a24-b5db-d8d8c7897efe','Succinea agonostoma Küster, 1856','Küster, 1856','UNRANKED','','Succinea','','agonostoma','','','',NULL,'','','','','','Küster','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00697','','','Corbicula agrensis Prime, 1861',1,'Corbicula agrensis','Corbicula agrensis','Corbicula agrens',2,0,'','','Prime','0a267080-5603-5927-8316-54e0d6b9bda9','Corbicula agrensis Prime, 1861','Prime, 1861','UNRANKED','','Corbicula','','agrensis','','','',NULL,'','','','','','Prime','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00703','','','Littorina ahenea Reeve, 1857',1,'Littorina ahenea','Littorina ahenea','Littorina ahene',2,0,'','','Reeve','6dae0f75-27f8-5336-9339-05cee1787ddb','Littorina ahenea Reeve, 1857','Reeve, 1857','UNRANKED','','Littorina','','ahenea','','','',NULL,'','','','','','Reeve','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00709','','','Diplodonta aizyensis Deshayes, 1857',1,'Diplodonta aizyensis','Diplodonta aizyensis','Diplodonta aizyens',2,0,'','','Deshayes','67aa635e-e330-5a30-a374-26533af5c228','Diplodonta aizyensis Deshayes, 1857','Deshayes, 1857','UNRANKED','','Diplodonta','','aizyensis','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00714','','','Helix ajax Pfeiffer, 1861',1,'Helix ajax','Helix ajax','Helix aiax',2,0,'','','Pfeiffer','0774d712-fed0-5810-80ef-bbc744169616','Helix ajax Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Helix','','ajax','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00720','','','Melania alabamensis Lea, 1861',1,'Melania alabamensis','Melania alabamensis','Melania alabamens',2,0,'','','Lea','cada2c8e-9741-5141-84cd-b77f85a2fb1a','Melania alabamensis Lea, 1861','Lea, 1861','UNRANKED','','Melania','','alabamensis','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00723','','','Natica (Girodes) alabamiensis Whitfield, 1865',1,'Natica alabamiensis','Natica alabamiensis','Natica alabamiens',2,0,'','','Whitfield','2d202a9e-1506-5bf4-8e15-731ee00b16fd','Natica (Girodes) alabamiensis Whitfield, 1865','Whitfield, 1865','UNRANKED','','Natica','Girodes','alabamiensis','','','',NULL,'','','','','','Whitfield','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00727','','','Natica alabaster Reeve, 1855',1,'Natica alabaster','Natica alabaster','Natica alabaster',2,0,'','','Reeve','331944a5-e5aa-59aa-8424-1afa8771c66e','Natica alabaster Reeve, 1855','Reeve, 1855','UNRANKED','','Natica','','alabaster','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00734','','','Alaba alabastrites P. Carpenter, 1856',1,'Alaba alabastrites','Alaba alabastrites','Alaba alabastrit',2,0,'','','P. Carpenter','06fec59b-b38d-5aa6-aeb9-757096a840ca','Alaba alabastrites P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Alaba','','alabastrites','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00739','','','Trochus (Euchele) alabastrum Reeve, 1857',1,'Trochus alabastrum','Trochus alabastrum','Trochus alabastr',2,0,'','','Reeve','77af7479-dd13-5f26-95cd-f7f7900c3437','Trochus (Euchele) alabastrum Reeve, 1857','Reeve, 1857','UNRANKED','','Trochus','Euchele','alabastrum','','','',NULL,'','','','','','Reeve','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00741','','','Avicula ala-perdicis Reeve, 1857',1,'Avicula ala-perdicis','Avicula ala-perdicis','Avicula ala-perdic',2,0,'','','Reeve','c7074a2e-7697-5759-9058-a5fb756baa8b','Avicula ala-perdicis Reeve, 1857','Reeve, 1857','UNRANKED','','Avicula','','ala-perdicis','','','',NULL,'','','','','','Reeve','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00746','','','Cyclas alata Leach, in J. Gray, 1852',2,'Cyclas alata','Cyclas alata','Cyclas alat',2,0,'','','Leach|J. Gray','aceb8639-cfdc-506d-8cd0-ed2348f7cfa0','Cyclas alata Leach, in J. Gray, 1852','Leach, in J. Gray, 1852','UNRANKED','','Cyclas','','alata','','','',NULL,'','','','','','Leach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00752','','','Palaina alata O. Semper, 1865',1,'Palaina alata','Palaina alata','Palaina alat',2,0,'','','O. Semper','4392dce4-c827-5d09-bbcf-1859ee8e7460','Palaina alata O. Semper, 1865','O. Semper, 1865','UNRANKED','','Palaina','','alata','','','',NULL,'','','','','','O. Semper','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00756','','','Unio alatoides Lea, 1868',1,'Unio alatoides','Unio alatoides','Unio alatoid',2,0,'','','Lea','49fdc7be-8856-525b-a3b1-9535c3ba1822','Unio alatoides Lea, 1868','Lea, 1868','UNRANKED','','Unio','','alatoides','','','',NULL,'','','','','','Lea','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00763','','','Acme lineata alba Jeffreys, 1862',1,'Acme lineata alba','Acme lineata alba','Acme lineat alb',3,0,'','','Jeffreys','233f709f-8add-53ee-8f82-e3da5a987df4','Acme lineata alba Jeffreys, 1862','Jeffreys, 1862','UNRANKED','','Acme','','lineata','alba','','',NULL,'','','','','','Jeffreys','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00766','','','Clausilia alba Küster, 1860',1,'Clausilia alba','Clausilia alba','Clausilia alb',2,0,'','','Küster','a30e2b8c-2ec5-5ce8-b0a8-51f337fdb459','Clausilia alba Küster, 1860','Küster, 1860','UNRANKED','','Clausilia','','alba','','','',NULL,'','','','','','Küster','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00770','','','Fusus antiquus alba Jeffreys, 1867',1,'Fusus antiquus alba','Fusus antiquus alba','Fusus antiqu alb',3,0,'','','Jeffreys','5174a751-cd18-58e2-ae45-9e4f2e45a59d','Fusus antiquus alba Jeffreys, 1867','Jeffreys, 1867','UNRANKED','','Fusus','','antiquus','alba','','',NULL,'','','','','','Jeffreys','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00773','','','Helix cantiana alba Colbeau, 1865',1,'Helix cantiana alba','Helix cantiana alba','Helix cantian alb',3,0,'','','Colbeau','9437063e-a412-5dc4-9ee4-0499a80f06bc','Helix cantiana alba Colbeau, 1865','Colbeau, 1865','UNRANKED','','Helix','','cantiana','alba','','',NULL,'','','','','','Colbeau','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00779','','','Helix pyramidata alba A. Moquin-Tandon, 1855',1,'Helix pyramidata alba','Helix pyramidata alba','Helix pyramidat alb',3,0,'','','A. Moquin-Tandon','9cb71346-3fba-519e-9fe5-75b0e0d4f552','Helix pyramidata alba A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','pyramidata','alba','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00785','','','Pecten septemradiatus alba Jeffreys, 1863',1,'Pecten septemradiatus alba','Pecten septemradiatus alba','Pecten septemradiat alb',3,0,'','','Jeffreys','2a0f961e-6d18-5214-bad9-90c8f864eb72','Pecten septemradiatus alba Jeffreys, 1863','Jeffreys, 1863','UNRANKED','','Pecten','','septemradiatus','alba','','',NULL,'','','','','','Jeffreys','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00791','','','Scaphander lignarius alba Jeffreys, 1867',1,'Scaphander lignarius alba','Scaphander lignarius alba','Scaphander lignar alb',3,0,'','','Jeffreys','2fdd3ca2-91e8-599d-9614-736a2063e0f3','Scaphander lignarius alba Jeffreys, 1867','Jeffreys, 1867','UNRANKED','','Scaphander','','lignarius','alba','','',NULL,'','','','','','Jeffreys','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00795','','','Trochus magus alba Jeffreys, 1865',1,'Trochus magus alba','Trochus magus alba','Trochus mag alb',3,0,'','','Jeffreys','7aa0ef67-db91-55b2-b443-7ab1db6afbf1','Trochus magus alba Jeffreys, 1865','Jeffreys, 1865','UNRANKED','','Trochus','','magus','alba','','',NULL,'','','','','','Jeffreys','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00796','','','Trophon truncatus alba Jeffreys, 1867',1,'Trophon truncatus alba','Trophon truncatus alba','Trophon truncat alb',3,0,'','','Jeffreys','8a836fe9-3625-5010-a140-dc798fa8f179','Trophon truncatus alba Jeffreys, 1867','Jeffreys, 1867','UNRANKED','','Trophon','','truncatus','alba','','',NULL,'','','','','','Jeffreys','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00800','','','Helix albanensis Cox, 1867',1,'Helix albanensis','Helix albanensis','Helix albanens',2,0,'','','Cox','70caea1c-8ad7-5abd-a2d7-745a746e9fc8','Helix albanensis Cox, 1867','Cox, 1867','UNRANKED','','Helix','','albanensis','','','',NULL,'','','','','','Cox','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00804','','','Marginella albayana Gaskoin, 1853',1,'Marginella albayana','Marginella albayana','Marginella albayan',2,0,'','','Gaskoin','63b14e89-ab16-55a9-bd0f-a1d6bbed0c4d','Marginella albayana Gaskoin, 1853','Gaskoin, 1853','UNRANKED','','Marginella','','albayana','','','',NULL,'','','','','','Gaskoin','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00808','','','Helicarion albellus Martens, 1867',1,'Helicarion albellus','Helicarion albellus','Helicarion albell',2,0,'','','Martens','33495faa-85ea-5bb0-b049-6c95603e19e4','Helicarion albellus Martens, 1867','Martens, 1867','UNRANKED','','Helicarion','','albellus','','','',NULL,'','','','','','Martens','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00811','','','Helix albersi Reeve, 1851',1,'Helix albersi','Helix albersi','Helix albers',2,0,'','','Reeve','77d26341-d922-5e2a-aed8-9bfa9cbe3ea0','Helix albersi Reeve, 1851','Reeve, 1851','UNRANKED','','Helix','','albersi','','','',NULL,'','','','','','Reeve','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00818','','','Avicula albertiana M. Rouault, 1851',1,'Avicula albertiana','Avicula albertiana','Avicula albertian',2,0,'','','M. Rouault','fffff15d-1ae5-5ba0-87b0-0d100ddbf20c','Avicula albertiana M. Rouault, 1851','M. Rouault, 1851','UNRANKED','','Avicula','','albertiana','','','',NULL,'','','','','','M. Rouault','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00823','','','Helix aspersa albescens A. Moquin-Tandon, 1855',1,'Helix aspersa albescens','Helix aspersa albescens','Helix aspers albescens',3,0,'','','A. Moquin-Tandon','88c38be6-17d0-58ea-8d3d-06f633c74eb5','Helix aspersa albescens A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','aspersa','albescens','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00827','','','Melania albescens Lea and Lea, 1850',1,'Melania albescens','Melania albescens','Melania albescens',2,0,'','','Lea','9b83bd08-c851-5ccc-bf31-12b81c213701','Melania albescens Lea and Lea, 1850','Lea and Lea, 1850','UNRANKED','','Melania','','albescens','','','',NULL,'','','','','','Lea & Lea','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00835','','','Achatinella albida Pfeiffer, 1855',1,'Achatinella albida','Achatinella albida','Achatinella albid',2,0,'','','Pfeiffer','8696f7f6-e986-5bca-a13d-ed85de8eee7f','Achatinella albida Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Achatinella','','albida','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00842','','','Clausilia rugosa albida Jeffreys, 1862',1,'Clausilia rugosa albida','Clausilia rugosa albida','Clausilia rugos albid',3,0,'','','Jeffreys','9ecf6802-e0a2-56fa-88fc-6352494c6d51','Clausilia rugosa albida Jeffreys, 1862','Jeffreys, 1862','UNRANKED','','Clausilia','','rugosa','albida','','',NULL,'','','','','','Jeffreys','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00847','','','Helix concinna albida Jeffreys, 1862',1,'Helix concinna albida','Helix concinna albida','Helix concinn albid',3,0,'','','Jeffreys','594d4f53-56c0-5bdf-9ad4-0626a86fe1c1','Helix concinna albida Jeffreys, 1862','Jeffreys, 1862','UNRANKED','','Helix','','concinna','albida','','',NULL,'','','','','','Jeffreys','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00850','','','Helix pomatia albida A. Moquin-Tandon, 1855',1,'Helix pomatia albida','Helix pomatia albida','Helix pomat albid',3,0,'','','A. Moquin-Tandon','0b67d1a0-29d3-577d-8bf2-2ded8c3526e6','Helix pomatia albida A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','pomatia','albida','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00855','','','Hydrobia ulvae albida Jeffreys, 1867',1,'Hydrobia ulvae albida','Hydrobia ulvae albida','Hydrobia ulu albid',3,0,'','','Jeffreys','ed4c48b9-da7b-5fc7-b70c-d99e162c1727','Hydrobia ulvae albida Jeffreys, 1867','Jeffreys, 1867','UNRANKED','','Hydrobia','','ulvae','albida','','',NULL,'','','','','','Jeffreys','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00862','','','Trochus groenlandicus albida Jeffreys, 1865',1,'Trochus groenlandicus albida','Trochus groenlandicus albida','Trochus groenlandic albid',3,0,'','','Jeffreys','4141d5d2-2ef5-558e-b8a2-583e0cd61ff8','Trochus groenlandicus albida Jeffreys, 1865','Jeffreys, 1865','UNRANKED','','Trochus','','groenlandicus','albida','','',NULL,'','','','','','Jeffreys','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00869','','','Helix ericetorum albidula Bourguignat, 1864',1,'Helix ericetorum albidula','Helix ericetorum albidula','Helix ericetor albidul',3,0,'','','Bourguignat','8b66d43a-4fee-5877-81b0-36c332a602b7','Helix ericetorum albidula Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','ericetorum','albidula','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00874','','','Cyclostoma ignilabre albilabre C.B. Adams, 1851',1,'Cyclostoma ignilabre albilabre','Cyclostoma ignilabre albilabre','Cyclostoma ignilabr albilabr',3,0,'','','C. B. Adams','7940ea40-83f6-533a-b29a-0e6a0ddc2973','Cyclostoma ignilabre albilabre C.B. Adams, 1851','C.B. Adams, 1851','UNRANKED','','Cyclostoma','','ignilabre','albilabre','','',NULL,'','','','','','C. B. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00878','','','Helix hortensis albina A. Moquin-Tandon, 1855',1,'Helix hortensis albina','Helix hortensis albina','Helix hortens albin',3,0,'','','A. Moquin-Tandon','6e2965a3-e169-5689-a938-a297e0c1d9f0','Helix hortensis albina A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','hortensis','albina','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00882','','','Helix limbata albina A. Moquin-Tandon, 1855',1,'Helix limbata albina','Helix limbata albina','Helix limbat albin',3,0,'','','A. Moquin-Tandon','0b0ff313-e208-55f4-b477-bcfcc0833bc0','Helix limbata albina A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','limbata','albina','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00888','','','Marginella albina Gaskoin, 1853',1,'Marginella albina','Marginella albina','Marginella albin',2,0,'','','Gaskoin','787f63ca-27f7-56a4-9161-f860b0bd5b59','Marginella albina Gaskoin, 1853','Gaskoin, 1853','UNRANKED','','Marginella','','albina','','','',NULL,'','','','','','Gaskoin','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00894','','','Pupa muscorum albina A. Moquin-Tandon, 1855',1,'Pupa muscorum albina','Pupa muscorum albina','Pupa muscor albin',3,0,'','','A. Moquin-Tandon','c296dbd2-de4a-507a-9ef7-85d17d61b8dc','Pupa muscorum albina A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Pupa','','muscorum','albina','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00897','','','Testacella maguei albina Gassies and Fischer, 1856',1,'Testacella maguei albina','Testacella maguei albina','Testacella mague albin',3,0,'','','Gassies|Fischer','c386371a-547b-5374-b432-17073ae9b660','Testacella maguei albina Gassies and Fischer, 1856','Gassies and Fischer, 1856','UNRANKED','','Testacella','','maguei','albina','','',NULL,'','','','','','Gassies & Fischer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00901','','','Nanina albinensis J. Gray, 1853',1,'Nanina albinensis','Nanina albinensis','Nanina albinens',2,0,'','','J. Gray','5c2a0ac9-5043-580c-94d4-f027a1df32cf','Nanina albinensis J. Gray, 1853','J. Gray, 1853','UNRANKED','','Nanina','','albinensis','','','',NULL,'','','','','','J. Gray','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00906','','','Bulimus subcylindricus albinos A. Moquin-Tandon, 1855',1,'Bulimus subcylindricus albinos','Bulimus subcylindricus albinos','Bulimus subcylindric albin',3,0,'','','A. Moquin-Tandon','7bc5005e-fff5-5ec1-874f-05b7be151ae8','Bulimus subcylindricus albinos A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Bulimus','','subcylindricus','albinos','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00912','','','Helix cornea albinos A. Moquin-Tandon, 1855',1,'Helix cornea albinos','Helix cornea albinos','Helix corne albin',3,0,'','','A. Moquin-Tandon','b7508941-c063-5e4c-957a-94dab9445dd2','Helix cornea albinos A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','cornea','albinos','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00914','','','Helix lineata albinos Bourguignat, 1864',1,'Helix lineata albinos','Helix lineata albinos','Helix lineat albin',3,0,'','','Bourguignat','b37f947b-26ce-51e3-8331-8b6c1b212e46','Helix lineata albinos Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','lineata','albinos','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00919','','','Helix villosa albinos A. Moquin-Tandon, 1855',1,'Helix villosa albinos','Helix villosa albinos','Helix uillos albin',3,0,'','','A. Moquin-Tandon','15c8c9ff-86cf-59fc-8d79-4298a2f60134','Helix villosa albinos A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','villosa','albinos','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00925','','','Zonites nitidus albinos A. Moquin-Tandon, 1855',1,'Zonites nitidus albinos','Zonites nitidus albinos','Zonites nitid albin',3,0,'','','A. Moquin-Tandon','dde5e1b9-eabd-588a-b923-e54f23d98f26','Zonites nitidus albinos A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Zonites','','nitidus','albinos','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00931','','','Nerita albipunctata Reeve, 1855',1,'Nerita albipunctata','Nerita albipunctata','Nerita albipunctat',2,0,'','','Reeve','57813b6c-e100-547e-9b97-ecf3c609a618','Nerita albipunctata Reeve, 1855','Reeve, 1855','UNRANKED','','Nerita','','albipunctata','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00942','','','Fusus albocinctus Petit de la Saussaye, 1851',1,'Fusus albocinctus','Fusus albocinctus','Fusus albocinct',2,0,'','','Petit de la Saussaye','2a8b9e2d-0a18-5793-9323-3c1cc603ee0d','Fusus albocinctus Petit de la Saussaye, 1851','Petit de la Saussaye, 1851','UNRANKED','','Fusus','','albocinctus','','','',NULL,'','','','','','Petit de la Saussaye','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00950','','','Cerithium alboliratum P. Carpenter, 1856',1,'Cerithium alboliratum','Cerithium alboliratum','Cerithium albolirat',2,0,'','','P. Carpenter','73b89e60-d1ca-5c61-a47b-044abf3affaf','Cerithium alboliratum P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Cerithium','','alboliratum','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00956','','','Cerithiopsis tuberculoides albonodosa P. Carpenter, 1856',1,'Cerithiopsis tuberculoides albonodosa','Cerithiopsis tuberculoides albonodosa','Cerithiopsis tuberculoid albonodos',3,0,'','','P. Carpenter','86f7149a-cfe0-5124-82fe-79ec93b8c67a','Cerithiopsis tuberculoides albonodosa P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Cerithiopsis','','tuberculoides','albonodosa','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00958','','','Nanina mossambicensis albopicta Martens, 1869',1,'Nanina mossambicensis albopicta','Nanina mossambicensis albopicta','Nanina mossambicens albopict',3,0,'','','Martens','f0a2f738-f157-506f-82fd-f8b2b140c76c','Nanina mossambicensis albopicta Martens, 1869','Martens, 1869','UNRANKED','','Nanina','','mossambicensis','albopicta','','',NULL,'','','','','','Martens','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00960','','','Vitrina albo-punctata Reeve, 1862',1,'Vitrina albo-punctata','Vitrina albo-punctata','Vitrina albo-punctat',2,0,'','','Reeve','d42ee531-e56f-50fc-a661-35e98829253c','Vitrina albo-punctata Reeve, 1862','Reeve, 1862','UNRANKED','','Vitrina','','albo-punctata','','','',NULL,'','','','','','Reeve','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00964','','','Venus albo-radiata G. Sowerby, 1853',1,'Venus albo-radiata','Venus albo-radiata','Venus albo-radiat',2,0,'','','G. Sowerby','1fae4233-d231-5ad1-a08d-537f3fd77432','Venus albo-radiata G. Sowerby, 1853','G. Sowerby, 1853','UNRANKED','','Venus','','albo-radiata','','','',NULL,'','','','','','G. Sowerby','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00969','','','Pleurotoma albovirgulata Souverbie, 1860',1,'Pleurotoma albovirgulata','Pleurotoma albovirgulata','Pleurotoma albouirgulat',2,0,'','','Souverbie','0f839fd1-983e-5887-b6c5-403fd532ecea','Pleurotoma albovirgulata Souverbie, 1860','Souverbie, 1860','UNRANKED','','Pleurotoma','','albovirgulata','','','',NULL,'','','','','','Souverbie','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00973','','','Columbella albuginosa Reeve, 1859',1,'Columbella albuginosa','Columbella albuginosa','Columbella albuginos',2,0,'','','Reeve','2a21bd7c-b426-5a98-9638-d50f8fa4e452','Columbella albuginosa Reeve, 1859','Reeve, 1859','UNRANKED','','Columbella','','albuginosa','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00978','','','Chondrus septemdentatus albulus Mousson, 1861',1,'Chondrus septemdentatus albulus','Chondrus septemdentatus albulus','Chondrus septemdentat albul',3,0,'','','Mousson','058dbe84-8adf-5c30-a6fa-f5309c9d68b5','Chondrus septemdentatus albulus Mousson, 1861','Mousson, 1861','UNRANKED','','Chondrus','','septemdentatus','albulus','','',NULL,'','','','','','Mousson','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00990','','','Pleurotomaria alcibiades Orbigny, 1854',1,'Pleurotomaria alcibiades','Pleurotomaria alcibiades','Pleurotomaria alcibiad',2,0,'','','Orbigny','b434d974-2f26-5a8a-af0d-e0d3b3541508','Pleurotomaria alcibiades Orbigny, 1854','Orbigny, 1854','UNRANKED','','Pleurotomaria','','alcibiades','','','',NULL,'','','','','','Orbigny','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00991','','','Myophoria alculeata Hassencamp, 1856',1,'Myophoria alculeata','Myophoria alculeata','Myophoria alculeat',2,0,'','','Hassencamp','493e6c26-233c-5a15-961b-50b5967101a8','Myophoria alculeata Hassencamp, 1856','Hassencamp, 1856','UNRANKED','','Myophoria','','alculeata','','','',NULL,'','','','','','Hassencamp','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00992','','','Cytherea alcyone E. Römer, 1869',1,'Cytherea alcyone','Cytherea alcyone','Cytherea alcyon',2,0,'','','E. Römer','a743dea2-1640-5bde-8ba0-bba9abad9dd0','Cytherea alcyone E. Römer, 1869','E. Römer, 1869','UNRANKED','','Cytherea','','alcyone','','','',NULL,'','','','','','E. Römer','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00995','','','Eolis alderi Cocks, 1852',1,'Eolis alderi','Eolis alderi','Eolis alder',2,0,'','','Cocks','c85c29be-9fc2-50b1-befd-1515e1054293','Eolis alderi Cocks, 1852','Cocks, 1852','UNRANKED','','Eolis','','alderi','','','',NULL,'','','','','','Cocks','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_00999','','','Lindsleya alderiana Chitty, 1857',1,'Lindsleya alderiana','Lindsleya alderiana','Lindsleya alderian',2,0,'','','Chitty','ff3ede81-15f2-5843-a02c-48dc9bf0e590','Lindsleya alderiana Chitty, 1857','Chitty, 1857','UNRANKED','','Lindsleya','','alderiana','','','',NULL,'','','','','','Chitty','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01004','','','Conus alessioi Michelotti, 1861',1,'Conus alessioi','Conus alessioi','Conus alessio',2,0,'','','Michelotti','9618473e-0bfa-5b77-b498-de8234bb8f24','Conus alessioi Michelotti, 1861','Michelotti, 1861','UNRANKED','','Conus','','alessioi','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01009','','','Helix alexandrae Cox, 1864',1,'Helix alexandrae','Helix alexandrae','Helix alexandr',2,0,'','','Cox','cbd9e11e-c9fc-5e02-935b-bb54c9690f51','Helix alexandrae Cox, 1864','Cox, 1864','UNRANKED','','Helix','','alexandrae','','','',NULL,'','','','','','Cox','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01014','','','Terebra algarbiorum P. Costa, 1866',1,'Terebra algarbiorum','Terebra algarbiorum','Terebra algarbior',2,0,'','','P. Costa','752ac914-e998-573e-ad87-9bb909697cc3','Terebra algarbiorum P. Costa, 1866','P. Costa, 1866','UNRANKED','','Terebra','','algarbiorum','','','',NULL,'','','','','','P. Costa','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01020','','','Chiton algesirensis Capellini, 1859',1,'Chiton algesirensis','Chiton algesirensis','Chiton algesirens',2,0,'','','Capellini','a88a09a6-d5cb-51b7-aa75-f6a5d17f0b53','Chiton algesirensis Capellini, 1859','Capellini, 1859','UNRANKED','','Chiton','','algesirensis','','','',NULL,'','','','','','Capellini','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01022','','','Natica algida Gould, 1851',1,'Natica algida','Natica algida','Natica algid',2,0,'','','Gould','a20bff5a-7e4e-5b43-9136-e98e6cc0c255','Natica algida Gould, 1851','Gould, 1851','UNRANKED','','Natica','','algida','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01029','','','Cardita aliena Deshayes, 1858',1,'Cardita aliena','Cardita aliena','Cardita alien',2,0,'','','Deshayes','a4987672-0b2b-5569-810d-4260317d9847','Cardita aliena Deshayes, 1858','Deshayes, 1858','UNRANKED','','Cardita','','aliena','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01033','','','Corbula aliformis Conrad, 1866',1,'Corbula aliformis','Corbula aliformis','Corbula aliform',2,0,'','','Conrad','d3d36a35-b0d2-5987-a27c-fb30b516fc9e','Corbula aliformis Conrad, 1866','Conrad, 1866','UNRANKED','','Corbula','','aliformis','','','',NULL,'','','','','','Conrad','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01034','','','Lucina aliformis Mayer, 1861',1,'Lucina aliformis','Lucina aliformis','Lucina aliform',2,0,'','','Mayer','ff66c735-360b-5d8b-a13f-900e9d91f13f','Lucina aliformis Mayer, 1861','Mayer, 1861','UNRANKED','','Lucina','','aliformis','','','',NULL,'','','','','','Mayer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01037','','','Helix alleniana Paiva, 1866',1,'Helix alleniana','Helix alleniana','Helix allenian',2,0,'','','Paiva','efe211d5-19c0-5d1e-b19a-d847dd7291a0','Helix alleniana Paiva, 1866','Paiva, 1866','UNRANKED','','Helix','','alleniana','','','',NULL,'','','','','','Paiva','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01042','','','Edwardsia allmanni W. McIntosh, 1866',1,'Edwardsia allmanni','Edwardsia allmanni','Edwardsia allmann',2,0,'','','W. McIntosh','b50c8db7-98ba-5828-8840-319607077a24','Edwardsia allmanni W. McIntosh, 1866','W. McIntosh, 1866','UNRANKED','','Edwardsia','','allmanni','','','',NULL,'','','','','','W. McIntosh','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01045','','','Neritina alloeodus F. Sandberger, 1863',1,'Neritina alloeodus','Neritina alloeodus','Neritina alloeod',2,0,'','','F. Sandberger','854c8a0d-0e0b-5015-a46e-6d80ca262883','Neritina alloeodus F. Sandberger, 1863','F. Sandberger, 1863','UNRANKED','','Neritina','','alloeodus','','','',NULL,'','','','','','F. Sandberger','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01056','','','Helix arbustorum alpicola A. Moquin-Tandon, 1855',1,'Helix arbustorum alpicola','Helix arbustorum alpicola','Helix arbustor alpicol',3,0,'','','A. Moquin-Tandon','d78468df-4fb0-5489-92ef-04c3ecd904b5','Helix arbustorum alpicola A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','arbustorum','alpicola','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01060','','','Clausilia alpina Stabile, 1859',1,'Clausilia alpina','Clausilia alpina','Clausilia alpin',2,0,'','','Stabile','35b8f375-2a1d-5692-baf4-3d99c3eb6713','Clausilia alpina Stabile, 1859','Stabile, 1859','UNRANKED','','Clausilia','','alpina','','','',NULL,'','','','','','Stabile','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01066','','','Leda alpina Winkler, 1861',1,'Leda alpina','Leda alpina','Leda alpin',2,0,'','','Winkler','f6d9c103-1a66-5ca8-85af-3187e76038a3','Leda alpina Winkler, 1861','Winkler, 1861','UNRANKED','','Leda','','alpina','','','',NULL,'','','','','','Winkler','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01070','','','Pleurotomaria alpina Gümbel, 1861',1,'Pleurotomaria alpina','Pleurotomaria alpina','Pleurotomaria alpin',2,0,'','','Gümbel','173f1165-1cbc-52d5-aa9b-7ef4396f73eb','Pleurotomaria alpina Gümbel, 1861','Gümbel, 1861','UNRANKED','','Pleurotomaria','','alpina','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01072','','','Rissoa alpina Gümbel, 1861',1,'Rissoa alpina','Rissoa alpina','Rissoa alpin',2,0,'','','Gümbel','b9c23153-a9b2-5e2a-ae09-7a84aae7c99d','Rissoa alpina Gümbel, 1861','Gümbel, 1861','UNRANKED','','Rissoa','','alpina','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01076','','','Turritella alpina Gümbel, 1861',1,'Turritella alpina','Turritella alpina','Turritella alpin',2,0,'','','Gümbel','544e1eba-d94f-5ff8-8ef5-0b44174dc858','Turritella alpina Gümbel, 1861','Gümbel, 1861','UNRANKED','','Turritella','','alpina','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01078','','','Cardium alpinum Gümbel, 1861',1,'Cardium alpinum','Cardium alpinum','Cardium alpin',2,0,'','','Gümbel','83c477da-e6bd-5b42-bfed-740b049897e5','Cardium alpinum Gümbel, 1861','Gümbel, 1861','UNRANKED','','Cardium','','alpinum','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01084','','','Turbo alpinus Winkler, 1861',1,'Turbo alpinus','Turbo alpinus','Turbo alpin',2,0,'','','Winkler','2008db2f-12a7-5203-8c2d-f978c6ae1b5d','Turbo alpinus Winkler, 1861','Winkler, 1861','UNRANKED','','Turbo','','alpinus','','','',NULL,'','','','','','Winkler','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01089','','','Helix alsia Bourguignat, 1864',1,'Helix alsia','Helix alsia','Helix als',2,0,'','','Bourguignat','d63acb22-0664-5118-afba-385cb8116ac2','Helix alsia Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','alsia','','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01093','','','Delphinula alta Morris and Lycett, 1854',1,'Delphinula alta','Delphinula alta','Delphinula alt',2,0,'','','Morris|Lycett','ec2f3bb1-65ab-529a-bc09-50243fa66c51','Delphinula alta Morris and Lycett, 1854','Morris and Lycett, 1854','UNRANKED','','Delphinula','','alta','','','',NULL,'','','','','','Morris & Lycett','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01101','','','Mactra aha Meek and Hayden, 1856',1,'Mactra aha','Mactra aha','Mactra ah',2,0,'','','Meek|Hayden','4f6a8bfc-4482-51cc-844b-0e80d9189b2c','Mactra aha Meek and Hayden, 1856','Meek and Hayden, 1856','UNRANKED','','Mactra','','aha','','','',NULL,'','','','','','Meek & Hayden','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01107','','','Valvata alta Deshayes, 1862',1,'Valvata alta','Valvata alta','Valvata alt',2,0,'','','Deshayes','ccb222c4-1b0b-5456-b4bd-a1f9f8dbf295','Valvata alta Deshayes, 1862','Deshayes, 1862','UNRANKED','','Valvata','','alta','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01112','','','Arca altera Deshayes, 1858',1,'Arca altera','Arca altera','Arca alter',2,0,'','','Deshayes','e8ff8188-acc6-5970-9825-a9144f547f56','Arca altera Deshayes, 1858','Deshayes, 1858','UNRANKED','','Arca','','altera','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01115','','','Alaria alternans Terquem and Jourdy, 1869',1,'Alaria alternans','Alaria alternans','Alaria alternans',2,0,'','','Terquem|Jourdy','95631365-1b54-5955-9409-a2a006d11ed7','Alaria alternans Terquem and Jourdy, 1869','Terquem and Jourdy, 1869','UNRANKED','','Alaria','','alternans','','','',NULL,'','','','','','Terquem & Jourdy','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01122','','','Trochus alternans Lycett, 1850',1,'Trochus alternans','Trochus alternans','Trochus alternans',2,0,'','','Lycett','0c9efaf9-ac31-5dfd-886f-a31a94068db3','Trochus alternans Lycett, 1850','Lycett, 1850','UNRANKED','','Trochus','','alternans','','','',NULL,'','','','','','Lycett','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01127','','','Cardium alternatum J. Sowerby, in Dixon, 1850',2,'Cardium alternatum','Cardium alternatum','Cardium alternat',2,0,'','','J. Sowerby|Dixon','b96bf99e-e9cb-527d-a468-d88058342391','Cardium alternatum J. Sowerby, in Dixon, 1850','J. Sowerby, in Dixon, 1850','UNRANKED','','Cardium','','alternatum','','','',NULL,'','','','','','J. Sowerby','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01136','','','Leda althei Deshayes, 1853',1,'Leda althei','Leda althei','Leda althe',2,0,'','','Deshayes','1198659f-57c2-5bbd-98c1-055897b448ea','Leda althei Deshayes, 1853','Deshayes, 1853','UNRANKED','','Leda','','althei','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01139','','','Lima althi Favre, 1869',1,'Lima althi','Lima althi','Lima alth',2,0,'','','Favre','ed2b72b3-77ef-5d53-8dbb-8bf993ac2fd6','Lima althi Favre, 1869','Favre, 1869','UNRANKED','','Lima','','althi','','','',NULL,'','','','','','Favre','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01143','','','Patella alticostata Angas, 1865',1,'Patella alticostata','Patella alticostata','Patella alticostat',2,0,'','','Angas','4bc1b6e5-6dc5-5339-86cf-2b0193772bfd','Patella alticostata Angas, 1865','Angas, 1865','UNRANKED','','Patella','','alticostata','','','',NULL,'','','','','','Angas','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01149','','','Cyrena altilus Gould, 1853',1,'Cyrena altilus','Cyrena altilus','Cyrena altil',2,0,'','','Gould','5ebb37bf-aa01-59ec-acda-9b5c2a793764','Cyrena altilus Gould, 1853','Gould, 1853','UNRANKED','','Cyrena','','altilus','','','',NULL,'','','','','','Gould','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01156','','','Naticopsis altonensis McChesney, 1865',1,'Naticopsis altonensis','Naticopsis altonensis','Naticopsis altonens',2,0,'','','McChesney','5a8e3a68-f869-50af-b98c-e61fae844321','Naticopsis altonensis McChesney, 1865','McChesney, 1865','UNRANKED','','Naticopsis','','altonensis','','','',NULL,'','','','','','McChesney','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01161','','','Ancylus altus Tryon, 1865',1,'Ancylus altus','Ancylus altus','Ancylus alt',2,0,'','','Tryon','70875001-e58e-5fe2-81a5-271a7e7915d8','Ancylus altus Tryon, 1865','Tryon, 1865','UNRANKED','','Ancylus','','altus','','','',NULL,'','','','','','Tryon','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01165','','','Straparollus altus Orbigny, 1853',1,'Straparollus altus','Straparollus altus','Straparollus alt',2,0,'','','Orbigny','46a6d095-e36b-55b4-8353-2fadb2c21ddc','Straparollus altus Orbigny, 1853','Orbigny, 1853','UNRANKED','','Straparollus','','altus','','','',NULL,'','','','','','Orbigny','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01169','','','Euchelus alusidotus Ryckholt, 1861',1,'Euchelus alusidotus','Euchelus alusidotus','Euchelus alusidot',2,0,'','','Ryckholt','170878cc-0aaf-51df-b296-f78395662e92','Euchelus alusidotus Ryckholt, 1861','Ryckholt, 1861','UNRANKED','','Euchelus','','alusidotus','','','',NULL,'','','','','','Ryckholt','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01175','','','Natica alveata Troschel, 1852',1,'Natica alveata','Natica alveata','Natica alueat',2,0,'','','Troschel','205068dc-bf0a-54da-b442-e5e8303b8113','Natica alveata Troschel, 1852','Troschel, 1852','UNRANKED','','Natica','','alveata','','','',NULL,'','','','','','Troschel','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01182','','','Emarginula (Subemarginula) alveolata A. Adams, 1851',1,'Emarginula alveolata','Emarginula alveolata','Emarginula alueolat',2,0,'','','A. Adams','f67510dd-1a6f-520f-903b-6f456431ba13','Emarginula (Subemarginula) alveolata A. Adams, 1851','A. Adams, 1851','UNRANKED','','Emarginula','Subemarginula','alveolata','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01186','','','Cerithium alveolatum Deshayes, 1864',1,'Cerithium alveolatum','Cerithium alveolatum','Cerithium alueolat',2,0,'','','Deshayes','15a7a9f4-2c4c-516b-8732-ae9a640568b8','Cerithium alveolatum Deshayes, 1864','Deshayes, 1864','UNRANKED','','Cerithium','','alveolatum','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01191','','','Doris amabilis Kelaart, 1859',1,'Doris amabilis','Doris amabilis','Doris amabil',2,0,'','','Kelaart','b887c28b-91fe-57a5-8a55-350da152b87c','Doris amabilis Kelaart, 1859','Kelaart, 1859','UNRANKED','','Doris','','amabilis','','','',NULL,'','','','','','Kelaart','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01196','','','Trochus amabilis Jeffreys, 1865',1,'Trochus amabilis','Trochus amabilis','Trochus amabil',2,0,'','','Jeffreys','5d2a3853-8552-5cce-a3da-5a2c6f4efc16','Trochus amabilis Jeffreys, 1865','Jeffreys, 1865','UNRANKED','','Trochus','','amabilis','','','',NULL,'','','','','','Jeffreys','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01200','','','Rostellaria amaena Piette, 1856',1,'Rostellaria amaena','Rostellaria amaena','Rostellaria amaen',2,0,'','','Piette','89ae5b71-6cc7-5964-9f6b-89e1b7ba7ab6','Rostellaria amaena Piette, 1856','Piette, 1856','UNRANKED','','Rostellaria','','amaena','','','',NULL,'','','','','','Piette','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01207','','','Pecten amalthei Oppel, 1853',1,'Pecten amalthei','Pecten amalthei','Pecten amalthe',2,0,'','','Oppel','ea6733b4-4b93-5859-8771-3b2f71fe4ec0','Pecten amalthei Oppel, 1853','Oppel, 1853','UNRANKED','','Pecten','','amalthei','','','',NULL,'','','','','','Oppel','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01210','','','Scalaria amalthei Quenstedt, 1856',1,'Scalaria amalthei','Scalaria amalthei','Scalaria amalthe',2,0,'','','Quenstedt','5b8fa9fd-0b02-5a56-a8bd-21c2795a6953','Scalaria amalthei Quenstedt, 1856','Quenstedt, 1856','UNRANKED','','Scalaria','','amalthei','','','',NULL,'','','','','','Quenstedt','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01216','','','Ferussacia amauronia Bourguignat, 1860',1,'Ferussacia amauronia','Ferussacia amauronia','Ferussacia amauron',2,0,'','','Bourguignat','5e548b36-ff28-5f1a-b145-3378313ff345','Ferussacia amauronia Bourguignat, 1860','Bourguignat, 1860','UNRANKED','','Ferussacia','','amauronia','','','',NULL,'','','','','','Bourguignat','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01225','','','Helix ambieliana Charpentier, in Moitessier, 1867',2,'Helix ambieliana','Helix ambieliana','Helix ambielian',2,0,'','','Charpentier|Moitessier','8302d6a4-8d40-596b-a7b9-33327de79a3d','Helix ambieliana Charpentier, in Moitessier, 1867','Charpentier, in Moitessier, 1867','UNRANKED','','Helix','','ambieliana','','','',NULL,'','','','','','Charpentier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01232','','','Chione ambigua Deshayes, 1853',1,'Chione ambigua','Chione ambigua','Chione ambigu',2,0,'','','Deshayes','5687a9d6-ddb8-58f0-b8b2-84de534e4718','Chione ambigua Deshayes, 1853','Deshayes, 1853','UNRANKED','','Chione','','ambigua','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01238','','','Galeomma ambigua Deshayes, 1855',1,'Galeomma ambigua','Galeomma ambigua','Galeomma ambigu',2,0,'','','Deshayes','df9fa9bd-e57d-58f2-9566-b093048a1d63','Galeomma ambigua Deshayes, 1855','Deshayes, 1855','UNRANKED','','Galeomma','','ambigua','','','',NULL,'','','','','','Deshayes','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01243','','','Nassa ambigua Michelotti, 1861',1,'Nassa ambigua','Nassa ambigua','Nassa ambigu',2,0,'','','Michelotti','78a74df3-6cb7-5b0f-91d5-6cc8d31e0ccc','Nassa ambigua Michelotti, 1861','Michelotti, 1861','UNRANKED','','Nassa','','ambigua','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01249','','','Pyramidella ambigua Gould, 1851',1,'Pyramidella ambigua','Pyramidella ambigua','Pyramidella ambigu',2,0,'','','Gould','6b8775cd-1b73-50e1-9d76-8215142157cc','Pyramidella ambigua Gould, 1851','Gould, 1851','UNRANKED','','Pyramidella','','ambigua','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01254','','','Registoma ambiguum O. Semper, 1864',1,'Registoma ambiguum','Registoma ambiguum','Registoma ambigu',2,0,'','','O. Semper','690d3b7d-7b25-576e-937d-9850eeae3984','Registoma ambiguum O. Semper, 1864','O. Semper, 1864','UNRANKED','','Registoma','','ambiguum','','','',NULL,'','','','','','O. Semper','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01260','','','Ferussacia amblya Bourguignat, 1860',1,'Ferussacia amblya','Ferussacia amblya','Ferussacia ambly',2,0,'','','Bourguignat','0dda00cd-1381-5bf4-8d8e-e12df096c658','Ferussacia amblya Bourguignat, 1860','Bourguignat, 1860','UNRANKED','','Ferussacia','','amblya','','','',NULL,'','','','','','Bourguignat','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01266','','','Cyclostoma (Cyclophorus) amboinense Pfeiffer, 1852',1,'Cyclostoma amboinense','Cyclostoma amboinense','Cyclostoma amboinens',2,0,'','','Pfeiffer','f15a3f9f-feb7-5be3-a460-28571f9b6b6f','Cyclostoma (Cyclophorus) amboinense Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Cyclostoma','Cyclophorus','amboinense','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01268','','','Helix unguiculastra amboinensis Martens, 1867',1,'Helix unguiculastra amboinensis','Helix unguiculastra amboinensis','Helix unguiculastr amboinens',3,0,'','','Martens','cb55c940-80eb-5388-bd45-788bef611210','Helix unguiculastra amboinensis Martens, 1867','Martens, 1867','UNRANKED','','Helix','','unguiculastra','amboinensis','','',NULL,'','','','','','Martens','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01269','','','Hyalina amboinensis Martens, 1864',1,'Hyalina amboinensis','Hyalina amboinensis','Hyalina amboinens',2,0,'','','Martens','9665863a-6953-500b-acc7-632dcf873733','Hyalina amboinensis Martens, 1864','Martens, 1864','UNRANKED','','Hyalina','','amboinensis','','','',NULL,'','','','','','Martens','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01273','','','Auriculella ambusta Pease, 1868',1,'Auriculella ambusta','Auriculella ambusta','Auriculella ambust',2,0,'','','Pease','3d9725f1-84b3-5b5e-9c2f-77c31fe9dadd','Auriculella ambusta Pease, 1868','Pease, 1868','UNRANKED','','Auriculella','','ambusta','','','',NULL,'','','','','','Pease','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01276','','','Pterocera amentata Ryckholt, 1862',1,'Pterocera amentata','Pterocera amentata','Pterocera amentat',2,0,'','','Ryckholt','0175489b-eacf-5649-adca-9f06f001c1cf','Pterocera amentata Ryckholt, 1862','Ryckholt, 1862','UNRANKED','','Pterocera','','amentata','','','',NULL,'','','','','','Ryckholt','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01281','','','Lucina americana C.B. Adams, 1852',1,'Lucina americana','Lucina americana','Lucina american',2,0,'','','C. B. Adams','bd2bb568-6abf-5195-8369-5dcd12852f7d','Lucina americana C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Lucina','','americana','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01285','','','Voluta americana Reeve, 1856',1,'Voluta americana','Voluta americana','Voluta american',2,0,'','','Reeve','8aef0d1e-f274-537b-8715-1bec79b5e810','Voluta americana Reeve, 1856','Reeve, 1856','UNRANKED','','Voluta','','americana','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01289','','','Dosinia amethystina E. Römer, 1860',1,'Dosinia amethystina','Dosinia amethystina','Dosinia amethystin',2,0,'','','E. Römer','a3791a52-8374-5690-b079-1b7bcac89f25','Dosinia amethystina E. Römer, 1860','E. Römer, 1860','UNRANKED','','Dosinia','','amethystina','','','',NULL,'','','','','','E. Römer','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01293','','','Helix amicta Reeve, 1851',1,'Helix amicta','Helix amicta','Helix amict',2,0,'','','Reeve','f0aeb47f-aa21-55b5-a419-95b0533282c0','Helix amicta Reeve, 1851','Reeve, 1851','UNRANKED','','Helix','','amicta','','','',NULL,'','','','','','Reeve','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01299','','','Euomphalus ammon White and Whitfield, 1862',1,'Euomphalus ammon','Euomphalus ammon','Euomphalus ammon',2,0,'','','White|Whitfield','22091554-e269-575d-92c2-dfba05e384bf','Euomphalus ammon White and Whitfield, 1862','White and Whitfield, 1862','UNRANKED','','Euomphalus','','ammon','','','',NULL,'','','','','','White & Whitfield','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01306','','','Stoa ammonitiformis Serres, 1855',1,'Stoa ammonitiformis','Stoa ammonitiformis','Stoa ammonitiform',2,0,'','','Serres','bdbc1402-c313-5107-a178-985a6979118e','Stoa ammonitiformis Serres, 1855','Serres, 1855','UNRANKED','','Stoa','','ammonitiformis','','','',NULL,'','','','','','Serres','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01311','','','Bifrontia ammonoides Deshayes, 1861',1,'Bifrontia ammonoides','Bifrontia ammonoides','Bifrontia ammonoid',2,0,'','','Deshayes','63fd1d0e-c398-5ea0-8f85-7b490f0655cc','Bifrontia ammonoides Deshayes, 1861','Deshayes, 1861','UNRANKED','','Bifrontia','','ammonoides','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01314','','','Cucullaea amoena Lycett, 1850',1,'Cucullaea amoena','Cucullaea amoena','Cucullaea amoen',2,0,'','','Lycett','966347dc-b22f-5df0-bca4-00a4fe00bd55','Cucullaea amoena Lycett, 1850','Lycett, 1850','UNRANKED','','Cucullaea','','amoena','','','',NULL,'','','','','','Lycett','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01318','','','Mitra amoena A. Adams, 1851',1,'Mitra amoena','Mitra amoena','Mitra amoen',2,0,'','','A. Adams','12aea1b1-aea5-558c-9382-09af8130e978','Mitra amoena A. Adams, 1851','A. Adams, 1851','UNRANKED','','Mitra','','amoena','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01322','','','Psammobia amoena Deshayes, 1854',1,'Psammobia amoena','Psammobia amoena','Psammobia amoen',2,0,'','','Deshayes','a99a0ce6-90f7-5214-a9c2-a9878f1cedb4','Psammobia amoena Deshayes, 1854','Deshayes, 1854','UNRANKED','','Psammobia','','amoena','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01325','','','Tellina amoena Deshayes, 1854',1,'Tellina amoena','Tellina amoena','Tellina amoen',2,0,'','','Deshayes','3237275e-07a9-5c10-9312-da5c5b7615db','Tellina amoena Deshayes, 1854','Deshayes, 1854','UNRANKED','','Tellina','','amoena','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01328','','','Phasianella amoenula Philippi, 1853',1,'Phasianella amoenula','Phasianella amoenula','Phasianella amoenul',2,0,'','','Philippi','d978e118-b340-5cdc-ac83-f143d923f017','Phasianella amoenula Philippi, 1853','Philippi, 1853','UNRANKED','','Phasianella','','amoenula','','','',NULL,'','','','','','Philippi','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01332','','','Murex amoenus Fuchs, 1870',1,'Murex amoenus','Murex amoenus','Murex amoen',2,0,'','','Fuchs','642d6576-bb0c-50e1-96c8-f4b5c339d4f7','Murex amoenus Fuchs, 1870','Fuchs, 1870','UNRANKED','','Murex','','amoenus','','','',NULL,'','','','','','Fuchs','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01336','','','Mytilus ampelitaecola Ryckholt, 1852',1,'Mytilus ampelitaecola','Mytilus ampelitaecola','Mytilus ampelitaecol',2,0,'','','Ryckholt','9ae5ac40-7a88-57bf-9007-8c4e8ce7d54f','Mytilus ampelitaecola Ryckholt, 1852','Ryckholt, 1852','UNRANKED','','Mytilus','','ampelitaecola','','','',NULL,'','','','','','Ryckholt','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01340','','','Zonites amphicyrta Bourguignat, 1859',1,'Zonites amphicyrta','Zonites amphicyrta','Zonites amphicyrt',2,0,'','','Bourguignat','52878ff3-9afe-5afc-a791-6b0b89ae1adf','Zonites amphicyrta Bourguignat, 1859','Bourguignat, 1859','UNRANKED','','Zonites','','amphicyrta','','','',NULL,'','','','','','Bourguignat','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01344','','','Pleurotomaria amphiloga Hebert and Eudes-Deslongchamps, 1860',1,'Pleurotomaria amphiloga','Pleurotomaria amphiloga','Pleurotomaria amphilog',2,0,'','','Hebert|Eudes-Deslongchamps','ecf3020f-0e49-5baf-9eee-e65f01230628','Pleurotomaria amphiloga Hebert and Eudes-Deslongchamps, 1860','Hebert and Eudes-Deslongchamps, 1860','UNRANKED','','Pleurotomaria','','amphiloga','','','',NULL,'','','','','','Hebert & Eudes-Deslongchamps','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01353','','','Atys amphorella A. Adams, 1862',1,'Atys amphorella','Atys amphorella','Atys amphorell',2,0,'','','A. Adams','34705a30-4218-5566-9fb5-b682e59aa988','Atys amphorella A. Adams, 1862','A. Adams, 1862','UNRANKED','','Atys','','amphorella','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01359','','','Gyrotoma ampla Anthony, 1860',1,'Gyrotoma ampla','Gyrotoma ampla','Gyrotoma ampl',2,0,'','','Anthony','47620c14-9cfe-50a4-9257-24e107484b9f','Gyrotoma ampla Anthony, 1860','Anthony, 1860','UNRANKED','','Gyrotoma','','ampla','','','',NULL,'','','','','','Anthony','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01365','','','Helix amplecta Gundlach, in Pfeiffer and Gundlach, 1860',2,'Helix amplecta','Helix amplecta','Helix amplect',2,0,'','','Gundlach|Pfeiffer','48c5552a-366f-5e39-bf0b-7d5c95309116','Helix amplecta Gundlach, in Pfeiffer and Gundlach, 1860','Gundlach, in Pfeiffer and Gundlach, 1860','UNRANKED','','Helix','','amplecta','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01378','','','Macroceramus amplus Gundlach, in Pfeiffer, 1858',2,'Macroceramus amplus','Macroceramus amplus','Macroceramus ampl',2,0,'','','Gundlach|Pfeiffer','75b33d03-de84-58dd-bdb2-1ac534bb9498','Macroceramus amplus Gundlach, in Pfeiffer, 1858','Gundlach, in Pfeiffer, 1858','UNRANKED','','Macroceramus','','amplus','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01385','','','Limnaeus ampulla Küster, 1862',1,'Limnaeus ampulla','Limnaeus ampulla','Limnaeus ampull',2,0,'','','Küster','543f37d5-fa52-5d19-b998-6244072d37e9','Limnaeus ampulla Küster, 1862','Küster, 1862','UNRANKED','','Limnaeus','','ampulla','','','',NULL,'','','','','','Küster','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01389','','','Paludina ampullarioides Hanley, in Reeve, 1863',2,'Paludina ampullarioides','Paludina ampullarioides','Paludina ampullarioid',2,0,'','','Hanley|Reeve','875607b1-7c97-55eb-b9fc-405199b8e165','Paludina ampullarioides Hanley, in Reeve, 1863','Hanley, in Reeve, 1863','UNRANKED','','Paludina','','ampullarioides','','','',NULL,'','','','','','Hanley','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01396','','','Astarte amygdala Coquand, 1862',1,'Astarte amygdala','Astarte amygdala','Astarte amygdal',2,0,'','','Coquand','57215587-a6e8-5a41-8483-086fda07ae08','Astarte amygdala Coquand, 1862','Coquand, 1862','UNRANKED','','Astarte','','amygdala','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01401','','','Pholadomya amygdalina Thurmann, in Thurmann and Etallon, 1862',2,'Pholadomya amygdalina','Pholadomya amygdalina','Pholadomya amygdalin',2,0,'','','Thurmann|Etallon','b18a94ec-ddbb-54c8-89bd-3372b3ac398c','Pholadomya amygdalina Thurmann, in Thurmann and Etallon, 1862','Thurmann, in Thurmann and Etallon, 1862','UNRANKED','','Pholadomya','','amygdalina','','','',NULL,'','','','','','Thurmann','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01409','','','Laimodonta anaaensis Mousson, 1869',1,'Laimodonta anaaensis','Laimodonta anaaensis','Laimodonta anaaens',2,0,'','','Mousson','3d775fed-7d8e-5d89-91c9-61010cc04a67','Laimodonta anaaensis Mousson, 1869','Mousson, 1869','UNRANKED','','Laimodonta','','anaaensis','','','',NULL,'','','','','','Mousson','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01414','','','Helix (Corasia) anadyomene A. Adams and Angas, 1864',1,'Helix anadyomene','Helix anadyomene','Helix anadyomen',2,0,'','','A. Adams|Angas','5593a46c-d61b-5feb-9f68-2055606b3790','Helix (Corasia) anadyomene A. Adams and Angas, 1864','A. Adams and Angas, 1864','UNRANKED','','Helix','Corasia','anadyomene','','','',NULL,'','','','','','A. Adams & Angas','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01417','','','Conus anaglypticus Crosse, 1865',1,'Conus anaglypticus','Conus anaglypticus','Conus anaglyptic',2,0,'','','Crosse','61693e13-a9a7-582e-93fc-980c270074cc','Conus anaglypticus Crosse, 1865','Crosse, 1865','UNRANKED','','Conus','','anaglypticus','','','',NULL,'','','','','','Crosse','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01422','','','Cytherea analoga Deshayes, 1857',1,'Cytherea analoga','Cytherea analoga','Cytherea analog',2,0,'','','Deshayes','6718265a-642c-58e2-985f-98b054e7f82d','Cytherea analoga Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cytherea','','analoga','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01426','','','Pithys analogica Pease, 1870',1,'Pithys analogica','Pithys analogica','Pithys analogic',2,0,'','','Pease','0eb08fe0-6e36-5a07-932c-d76ca93686c8','Pithys analogica Pease, 1870','Pease, 1870','UNRANKED','','Pithys','','analogica','','','',NULL,'','','','','','Pease','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01430','','','Unio anaticulus Lea, 1861',1,'Unio anaticulus','Unio anaticulus','Unio anaticul',2,0,'','','Lea','e6699294-477b-51b5-81f6-065c76c893ac','Unio anaticulus Lea, 1861','Lea, 1861','UNRANKED','','Unio','','anaticulus','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01436','','','Pterocera anatipes Contejean, 1857',1,'Pterocera anatipes','Pterocera anatipes','Pterocera anatip',2,0,'','','Contejean','74b081d0-f2c4-5a45-a885-6e1596d818d6','Pterocera anatipes Contejean, 1857','Contejean, 1857','UNRANKED','','Pterocera','','anatipes','','','',NULL,'','','','','','Contejean','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01443','','','Arca anceps Michelotti, 1861',1,'Arca anceps','Arca anceps','Arca anceps',2,0,'','','Michelotti','4bae0bda-b565-5137-9a91-05d21a1a7dde','Arca anceps Michelotti, 1861','Michelotti, 1861','UNRANKED','','Arca','','anceps','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01446','','','Lucina anceps Laube, 1866',1,'Lucina anceps','Lucina anceps','Lucina anceps',2,0,'','','Laube','dd32999f-a36b-5988-b2b5-09cef33ed046','Lucina anceps Laube, 1866','Laube, 1866','UNRANKED','','Lucina','','anceps','','','',NULL,'','','','','','Laube','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01452','','','Voluta anceps Michelotti, 1861',1,'Voluta anceps','Voluta anceps','Voluta anceps',2,0,'','','Michelotti','1ba2b637-df91-592f-b606-ab57011311cd','Voluta anceps Michelotti, 1861','Michelotti, 1861','UNRANKED','','Voluta','','anceps','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01456','','','Helix andamanensis W. Theobald, 1860',1,'Helix andamanensis','Helix andamanensis','Helix andamanens',2,0,'','','W. Theobald','e0b6fd52-1b8c-54d7-bca1-bacbf77c7b7c','Helix andamanensis W. Theobald, 1860','W. Theobald, 1860','UNRANKED','','Helix','','andamanensis','','','',NULL,'','','','','','W. Theobald','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01461','','','Clausilia andecola Morelet, 1863',1,'Clausilia andecola','Clausilia andecola','Clausilia andecol',2,0,'','','Morelet','7b483f03-9619-5e49-bf13-3e441769332a','Clausilia andecola Morelet, 1863','Morelet, 1863','UNRANKED','','Clausilia','','andecola','','','',NULL,'','','','','','Morelet','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01467','','','Dentalium andleri Oppel, 1856',1,'Dentalium andleri','Dentalium andleri','Dentalium andler',2,0,'','','Oppel','86356ef5-1e79-5f02-82c6-104fef9162c2','Dentalium andleri Oppel, 1856','Oppel, 1856','UNRANKED','','Dentalium','','andleri','','','',NULL,'','','','','','Oppel','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01472','','','Eolis andreapolis W. McIntosh, 1866',1,'Eolis andreapolis','Eolis andreapolis','Eolis andreapol',2,0,'','','W. McIntosh','d95a9574-3f8f-5056-8d34-9e0b25f8bd66','Eolis andreapolis W. McIntosh, 1866','W. McIntosh, 1866','UNRANKED','','Eolis','','andreapolis','','','',NULL,'','','','','','W. McIntosh','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01478','','','Anodon angasii Lea, in G. Sowerby, 1870',2,'Anodon angasii','Anodon angasii','Anodon angas',2,0,'','','Lea|G. Sowerby','07805678-56d2-5f9f-bf1f-58ffd68fff96','Anodon angasii Lea, in G. Sowerby, 1870','Lea, in G. Sowerby, 1870','UNRANKED','','Anodon','','angasii','','','',NULL,'','','','','','Lea','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01482','','','Cancellaria angasi Crosse, 1863',1,'Cancellaria angasi','Cancellaria angasi','Cancellaria angas',2,0,'','','Crosse','f5614d3f-b17e-5c92-a805-b62f39bad858','Cancellaria angasi Crosse, 1863','Crosse, 1863','UNRANKED','','Cancellaria','','angasi','','','',NULL,'','','','','','Crosse','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01487','','','Marginella angasi Crosse, 1870',1,'Marginella angasi','Marginella angasi','Marginella angas',2,0,'','','Crosse','f8ea9414-f13e-5575-9dc1-654826843495','Marginella angasi Crosse, 1870','Crosse, 1870','UNRANKED','','Marginella','','angasi','','','',NULL,'','','','','','Crosse','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01489','','','Periploma angasi Crosse and Fischer, 1864',1,'Periploma angasi','Periploma angasi','Periploma angas',2,0,'','','Crosse|Fischer','a4a6f827-7cf5-53d9-9d7d-9a260393461d','Periploma angasi Crosse and Fischer, 1864','Crosse and Fischer, 1864','UNRANKED','','Periploma','','angasi','','','',NULL,'','','','','','Crosse & Fischer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01496','','','Helix angasiana Newcomb, 1860',1,'Helix angasiana','Helix angasiana','Helix angasian',2,0,'','','Newcomb','8ab994ed-292b-518d-b74b-83dbf41664fb','Helix angasiana Newcomb, 1860','Newcomb, 1860','UNRANKED','','Helix','','angasiana','','','',NULL,'','','','','','Newcomb','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01500','','','Ctenodonta angela Billings, 1865',1,'Ctenodonta angela','Ctenodonta angela','Ctenodonta angel',2,0,'','','Billings','affe78ab-7867-507a-b6b1-a8e29dd4e414','Ctenodonta angela Billings, 1865','Billings, 1865','UNRANKED','','Ctenodonta','','angela','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01503','','','Tectarius angeloti Ryckholt, 1861',1,'Tectarius angeloti','Tectarius angeloti','Tectarius angelot',2,0,'','','Ryckholt','1981a6cc-f5ed-5c97-8e50-81593617f935','Tectarius angeloti Ryckholt, 1861','Ryckholt, 1861','UNRANKED','','Tectarius','','angeloti','','','',NULL,'','','','','','Ryckholt','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01507','','','Cerithium angiostoma Hebert and Eudes-Deslongchamps, 1860',1,'Cerithium angiostoma','Cerithium angiostoma','Cerithium angiostom',2,0,'','','Hebert|Eudes-Deslongchamps','89c77875-3599-500d-931e-5b82147ec2ff','Cerithium angiostoma Hebert and Eudes-Deslongchamps, 1860','Hebert and Eudes-Deslongchamps, 1860','UNRANKED','','Cerithium','','angiostoma','','','',NULL,'','','','','','Hebert & Eudes-Deslongchamps','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01513','','','Physa angolensis Morelet, 1866',1,'Physa angolensis','Physa angolensis','Physa angolens',2,0,'','','Morelet','a5dd55a2-5d98-55a4-a95b-03710f40c513','Physa angolensis Morelet, 1866','Morelet, 1866','UNRANKED','','Physa','','angolensis','','','',NULL,'','','','','','Morelet','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01520','','','Scalaria angresiana Ryckholt, 1860',1,'Scalaria angresiana','Scalaria angresiana','Scalaria angresian',2,0,'','','Ryckholt','984d4d0c-cd12-5f4e-9757-93ea4d903f99','Scalaria angresiana Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Scalaria','','angresiana','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01523','','','Aplysia anguilla G. Sowerby, 1869',1,'Aplysia anguilla','Aplysia anguilla','Aplysia anguill',2,0,'','','G. Sowerby','a9da3b93-7dda-5b3c-a2c0-e19221d2f3cf','Aplysia anguilla G. Sowerby, 1869','G. Sowerby, 1869','UNRANKED','','Aplysia','','anguilla','','','',NULL,'','','','','','G. Sowerby','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01529','','','Teredo anguinus F. Sandberger, 1863',1,'Teredo anguinus','Teredo anguinus','Teredo anguin',2,0,'','','F. Sandberger','fcb44404-6b6f-5f24-b442-53a43c9a7603','Teredo anguinus F. Sandberger, 1863','F. Sandberger, 1863','UNRANKED','','Teredo','','anguinus','','','',NULL,'','','','','','F. Sandberger','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01532','','','Cerithium angulare Schafhäutl, 1863',1,'Cerithium angulare','Cerithium angulare','Cerithium angular',2,0,'','','Schafhäutl','98c3c2a9-b511-545d-97c4-d6e4f8ce4754','Cerithium angulare Schafhäutl, 1863','Schafhäutl, 1863','UNRANKED','','Cerithium','','angulare','','','',NULL,'','','','','','Schafhäutl','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01536','','','Aclis angulata Fischer, in Folin, 1869',2,'Aclis angulata','Aclis angulata','Aclis angulat',2,0,'','','Fischer|Folin','5e2b4331-2b06-5b28-97dc-f7edd27c4510','Aclis angulata Fischer, in Folin, 1869','Fischer, in Folin, 1869','UNRANKED','','Aclis','','angulata','','','',NULL,'','','','','','Fischer','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01542','','','Cardiola angulata Fried. Roemer, 1850',1,'Cardiola angulata','Cardiola angulata','Cardiola angulat',2,0,'','','Fried. Roemer','34f9936d-1ae9-541f-a0ef-31479f2920b7','Cardiola angulata Fried. Roemer, 1850','Fried. Roemer, 1850','UNRANKED','','Cardiola','','angulata','','','',NULL,'','','','','','Fried. Roemer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01547','','','Corbulomya angulata Speyer, 1864',1,'Corbulomya angulata','Corbulomya angulata','Corbulomya angulat',2,0,'','','Speyer','24da475e-da08-5690-95b5-31f1f47419a1','Corbulomya angulata Speyer, 1864','Speyer, 1864','UNRANKED','','Corbulomya','','angulata','','','',NULL,'','','','','','Speyer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01551','','','Eucharis angulata H. Adams, 1870',1,'Eucharis angulata','Eucharis angulata','Eucharis angulat',2,0,'','','H. Adams','edd8a23e-5483-5d4f-a1fd-b06351a0d970','Eucharis angulata H. Adams, 1870','H. Adams, 1870','UNRANKED','','Eucharis','','angulata','','','',NULL,'','','','','','H. Adams','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01559','','','Margarita angulata A. Adams, 1851',1,'Margarita angulata','Margarita angulata','Margarita angulat',2,0,'','','A. Adams','c6be4ff0-0f71-557a-b38c-4799ab3190f8','Margarita angulata A. Adams, 1851','A. Adams, 1851','UNRANKED','','Margarita','','angulata','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01565','','','Philine angulata Jeffreys, 1867',1,'Philine angulata','Philine angulata','Philine angulat',2,0,'','','Jeffreys','3933afae-ac20-52b8-a7f0-196f3c196e90','Philine angulata Jeffreys, 1867','Jeffreys, 1867','UNRANKED','','Philine','','angulata','','','',NULL,'','','','','','Jeffreys','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01569','','','Voluta cithara angulata F. Edwards, 1854',1,'Voluta cithara angulata','Voluta cithara angulata','Voluta cithar angulat',3,0,'','','F. Edwards','6bad31b7-4ec3-5033-92db-26942023fc3a','Voluta cithara angulata F. Edwards, 1854','F. Edwards, 1854','UNRANKED','','Voluta','','cithara','angulata','','',NULL,'','','','','','F. Edwards','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01574','','','Bellerophon angulatus Gueranger, 1853',1,'Bellerophon angulatus','Bellerophon angulatus','Bellerophon angulat',2,0,'','','Gueranger','808f9e66-c7af-5141-b7d3-706ad96fa1b9','Bellerophon angulatus Gueranger, 1853','Gueranger, 1853','UNRANKED','','Bellerophon','','angulatus','','','',NULL,'','','','','','Gueranger','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01577','','','Euchelus angulatus Pease, 1868',1,'Euchelus angulatus','Euchelus angulatus','Euchelus angulat',2,0,'','','Pease','924ac6d1-dc16-5dc9-9c59-74a210aba64a','Euchelus angulatus Pease, 1868','Pease, 1868','UNRANKED','','Euchelus','','angulatus','','','',NULL,'','','','','','Pease','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01582','','','Planorbis angulatus Chitty, 1853',1,'Planorbis angulatus','Planorbis angulatus','Planorbis angulat',2,0,'','','Chitty','91b69174-bfb7-56ec-9b56-38251a2a82ad','Planorbis angulatus Chitty, 1853','Chitty, 1853','UNRANKED','','Planorbis','','angulatus','','','',NULL,'','','','','','Chitty','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01585','','','Rostellaria angulicostata Buvignier, 1852',1,'Rostellaria angulicostata','Rostellaria angulicostata','Rostellaria angulicostat',2,0,'','','Buvignier','cac07258-52ca-571a-a39c-86a98e99dfa7','Rostellaria angulicostata Buvignier, 1852','Buvignier, 1852','UNRANKED','','Rostellaria','','angulicostata','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01588','','','Cylindrella angulifera Gundlach, in Pfeiffer, 1858',2,'Cylindrella angulifera','Cylindrella angulifera','Cylindrella angulifer',2,0,'','','Gundlach|Pfeiffer','5eeb38ea-443d-5c8b-9c8e-69f2ee5602a9','Cylindrella angulifera Gundlach, in Pfeiffer, 1858','Gundlach, in Pfeiffer, 1858','UNRANKED','','Cylindrella','','angulifera','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01597','','','Cardium anguliferum Fried, Roemer, 1850',1,'Cardium anguliferum','Cardium anguliferum','Cardium angulifer',2,0,'','','Fried|Roemer','4294501d-9c6c-530c-8f00-d61547777414','Cardium anguliferum Fried, Roemer, 1850','Fried, Roemer, 1850','UNRANKED','','Cardium','','anguliferum','','','',NULL,'','','','','','Fried & Roemer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01604','','','Cardium angulosum Deshayes, 1853',1,'Cardium angulosum','Cardium angulosum','Cardium angulos',2,0,'','','Deshayes','65c837e3-e23e-5a40-940f-4e9e24542759','Cardium angulosum Deshayes, 1853','Deshayes, 1853','UNRANKED','','Cardium','','angulosum','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01609','','','Mesodesma angulum Deshayes, 1854',1,'Mesodesma angulum','Mesodesma angulum','Mesodesma angul',2,0,'','','Deshayes','2e8e3ad7-3053-58f5-86cd-ff8578db0135','Mesodesma angulum Deshayes, 1854','Deshayes, 1854','UNRANKED','','Mesodesma','','angulum','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01613','','','Cerithium perelegans angusta Deshayes, 1864',1,'Cerithium perelegans angusta','Cerithium perelegans angusta','Cerithium perelegans angust',3,0,'','','Deshayes','738aa474-ce18-54a4-af64-2b37d0be9ca9','Cerithium perelegans angusta Deshayes, 1864','Deshayes, 1864','UNRANKED','','Cerithium','','perelegans','angusta','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01618','','','Cyrena angusta Deshayes, 1857',1,'Cyrena angusta','Cyrena angusta','Cyrena angust',2,0,'','','Deshayes','b05bcc07-f5bb-5b6c-846c-313ff9cf329f','Cyrena angusta Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cyrena','','angusta','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01624','','','Leda angusta Ryckholt, 1860',1,'Leda angusta','Leda angusta','Leda angust',2,0,'','','Ryckholt','3d7d7e06-49a3-5cf8-a07f-766f81012c00','Leda angusta Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Leda','','angusta','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01631','','','Mesodesma angusta Deshayes, 1854',1,'Mesodesma angusta','Mesodesma angusta','Mesodesma angust',2,0,'','','Deshayes','78434037-51fc-58b0-943b-61f9647559bf','Mesodesma angusta Deshayes, 1854','Deshayes, 1854','UNRANKED','','Mesodesma','','angusta','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01636','','','Realia bifilaris angusta Mousson, 1870',1,'Realia bifilaris angusta','Realia bifilaris angusta','Realia bifilar angust',3,0,'','','Mousson','aa02ff72-de9e-5481-a82d-b09a287a6518','Realia bifilaris angusta Mousson, 1870','Mousson, 1870','UNRANKED','','Realia','','bifilaris','angusta','','',NULL,'','','','','','Mousson','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01640','','','Sphenia angusta Deshayes, 1857',1,'Sphenia angusta','Sphenia angusta','Sphenia angust',2,0,'','','Deshayes','d218d085-6ec6-5af7-b30f-fbe1d9285155','Sphenia angusta Deshayes, 1857','Deshayes, 1857','UNRANKED','','Sphenia','','angusta','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01641','','','Sportella angusta Deshayes, 1857',1,'Sportella angusta','Sportella angusta','Sportella angust',2,0,'','','Deshayes','fe516990-9387-5df4-8954-e6f3ec8045e3','Sportella angusta Deshayes, 1857','Deshayes, 1857','UNRANKED','','Sportella','','angusta','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01646','','','Vulsella angusta Deshayes, 1858',1,'Vulsella angusta','Vulsella angusta','Vulsella angust',2,0,'','','Deshayes','f6bd882a-56b3-50c0-a5a7-3567cdebc221','Vulsella angusta Deshayes, 1858','Deshayes, 1858','UNRANKED','','Vulsella','','angusta','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01647','','','Alicia angustata Angas, 1867',1,'Alicia angustata','Alicia angustata','Alicia angustat',2,0,'','','Angas','0118d3fe-e670-5710-b67b-c6f4d55f078d','Alicia angustata Angas, 1867','Angas, 1867','UNRANKED','','Alicia','','angustata','','','',NULL,'','','','','','Angas','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01650','','','Haminea angustata G. Sowerby, 1868',1,'Haminea angustata','Haminea angustata','Haminea angustat',2,0,'','','G. Sowerby','811e4ef0-c6e4-5348-976a-1a30e52f1058','Haminea angustata G. Sowerby, 1868','G. Sowerby, 1868','UNRANKED','','Haminea','','angustata','','','',NULL,'','','','','','G. Sowerby','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01657','','','Cyclostoma (Chondropoma) angustatum Pfeiffer, 1854',1,'Cyclostoma angustatum','Cyclostoma angustatum','Cyclostoma angustat',2,0,'','','Pfeiffer','a70ff2ea-a3cc-5f65-9d64-54451b2305e5','Cyclostoma (Chondropoma) angustatum Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Cyclostoma','Chondropoma','angustatum','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01660','','','Clausilia angustella Parreyss, in Pfeiffer, 1866',2,'Clausilia angustella','Clausilia angustella','Clausilia angustell',2,0,'','','Parreyss|Pfeiffer','c4992329-3d22-50c5-abeb-ccc816d5a120','Clausilia angustella Parreyss, in Pfeiffer, 1866','Parreyss, in Pfeiffer, 1866','UNRANKED','','Clausilia','','angustella','','','',NULL,'','','','','','Parreyss','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01666','','','Modiolaria discors angustior Jeffreys, 1863',1,'Modiolaria discors angustior','Modiolaria discors angustior','Modiolaria discors angustior',3,0,'','','Jeffreys','e802bf0c-bdc2-53d5-952f-b9ee88d7ed29','Modiolaria discors angustior Jeffreys, 1863','Jeffreys, 1863','UNRANKED','','Modiolaria','','discors','angustior','','',NULL,'','','','','','Jeffreys','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01670','','','Melania angustispira Anthony, 1860',1,'Melania angustispira','Melania angustispira','Melania angustispir',2,0,'','','Anthony','525a5395-0d8a-5877-add2-6cd91abc3092','Melania angustispira Anthony, 1860','Anthony, 1860','UNRANKED','','Melania','','angustispira','','','',NULL,'','','','','','Anthony','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01675','','','Pectunculus angustus Mayer, 1868',1,'Pectunculus angustus','Pectunculus angustus','Pectunculus angust',2,0,'','','Mayer','f3cbbfbe-cf22-56cc-a131-71757c57d4db','Pectunculus angustus Mayer, 1868','Mayer, 1868','UNRANKED','','Pectunculus','','angustus','','','',NULL,'','','','','','Mayer','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01681','','','Helix (Polygyra) anilis Gabb, 1865',1,'Helix anilis','Helix anilis','Helix anil',2,0,'','','Gabb','3287073d-b41f-591b-8438-7ddd33378944','Helix (Polygyra) anilis Gabb, 1865','Gabb, 1865','UNRANKED','','Helix','Polygyra','anilis','','','',NULL,'','','','','','Gabb','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01684','','','Dosinia annae P. Carpenter, 1855',1,'Dosinia annae','Dosinia annae','Dosinia ann',2,0,'','','P. Carpenter','ba950bf3-95d8-5071-87df-1063fb4ae935','Dosinia annae P. Carpenter, 1855','P. Carpenter, 1855','UNRANKED','','Dosinia','','annae','','','',NULL,'','','','','','P. Carpenter','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01691','','','Helix annatonensis Pfeiffer, 1854',1,'Helix annatonensis','Helix annatonensis','Helix annatonens',2,0,'','','Pfeiffer','6157fcee-cb33-51ca-aea5-786d5306fdb6','Helix annatonensis Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Helix','','annatonensis','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01695','','','Dione annexa Conrad, 1865',1,'Dione annexa','Dione annexa','Dione annex',2,0,'','','Conrad','c29a6135-21de-559a-b096-818818ead9d1','Dione annexa Conrad, 1865','Conrad, 1865','UNRANKED','','Dione','','annexa','','','',NULL,'','','','','','Conrad','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01699','','','Avicula annosa Conrad, 1865',1,'Avicula annosa','Avicula annosa','Avicula annos',2,0,'','','Conrad','cc38a9ce-dd9f-5ae4-8c5e-0d4a7adbd061','Avicula annosa Conrad, 1865','Conrad, 1865','UNRANKED','','Avicula','','annosa','','','',NULL,'','','','','','Conrad','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01705','','','Columbella annulata Reeve, 1858',1,'Columbella annulata','Columbella annulata','Columbella annulat',2,0,'','','Reeve','6f624cb4-e97c-5fad-8967-58cf55784b48','Columbella annulata Reeve, 1858','Reeve, 1858','UNRANKED','','Columbella','','annulata','','','',NULL,'','','','','','Reeve','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01712','','','Vitrinella annulata P. Carpenter, 1856',1,'Vitrinella annulata','Vitrinella annulata','Vitrinella annulat',2,0,'','','P. Carpenter','db4b1d37-a657-542e-8cb8-1a0eb143fc69','Vitrinella annulata P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Vitrinella','','annulata','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01719','','','Thylacodes oryzata annulatus Mörch, 1862',1,'Thylacodes oryzata annulatus','Thylacodes oryzata annulatus','Thylacodes oryzat annulat',3,0,'','','Mörch','5db47524-98ef-5a3a-8c81-0c4b271dfe73','Thylacodes oryzata annulatus Mörch, 1862','Mörch, 1862','UNRANKED','','Thylacodes','','oryzata','annulatus','','',NULL,'','','','','','Mörch','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01722','','','Cypraea annulifera Conrad, 1866',1,'Cypraea annulifera','Cypraea annulifera','Cypraea annulifer',2,0,'','','Conrad','ff09dfd5-88de-52f7-b46e-275a154060e4','Cypraea annulifera Conrad, 1866','Conrad, 1866','UNRANKED','','Cypraea','','annulifera','','','',NULL,'','','','','','Conrad','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01726','','','Dentalium annulostriatum Meek and Worthen, 1870',1,'Dentalium annulostriatum','Dentalium annulostriatum','Dentalium annulostriat',2,0,'','','Meek|Worthen','986225ce-c15d-5593-8cf8-0dc41e84d9cb','Dentalium annulostriatum Meek and Worthen, 1870','Meek and Worthen, 1870','UNRANKED','','Dentalium','','annulostriatum','','','',NULL,'','','','','','Meek & Worthen','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01731','','','Mesodesma anodontina E. Römer, 1862',1,'Mesodesma anodontina','Mesodesma anodontina','Mesodesma anodontin',2,0,'','','E. Römer','0dc5a7b7-758a-5851-bee3-fc715e50caa9','Mesodesma anodontina E. Römer, 1862','E. Römer, 1862','UNRANKED','','Mesodesma','','anodontina','','','',NULL,'','','','','','E. Römer','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01735','','','Metoptoma anomala Billings, 1865',1,'Metoptoma anomala','Metoptoma anomala','Metoptoma anomal',2,0,'','','Billings','4030ac54-d4ff-591b-ae19-8aa86e19e22f','Metoptoma anomala Billings, 1865','Billings, 1865','UNRANKED','','Metoptoma','','anomala','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01742','','','Turritella anomala C. Moore, 1866',1,'Turritella anomala','Turritella anomala','Turritella anomal',2,0,'','','C. Moore','e8b168d2-60c9-5395-9650-5b8ef19e98e4','Turritella anomala C. Moore, 1866','C. Moore, 1866','UNRANKED','','Turritella','','anomala','','','',NULL,'','','','','','C. Moore','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01746','','','Pterocyclos anomalus Reeve, 1863',1,'Pterocyclos anomalus','Pterocyclos anomalus','Pterocyclos anomal',2,0,'','','Reeve','b9c8f9ca-079c-54d1-84a9-2fd19100944f','Pterocyclos anomalus Reeve, 1863','Reeve, 1863','UNRANKED','','Pterocyclos','','anomalus','','','',NULL,'','','','','','Reeve','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01748','','','Ostrea anomioides Gümbel, 1861',1,'Ostrea anomioides','Ostrea anomioides','Ostrea anomioid',2,0,'','','Gümbel','11c9b9be-cfc1-5620-a598-977227144cbb','Ostrea anomioides Gümbel, 1861','Gümbel, 1861','UNRANKED','','Ostrea','','anomioides','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01756','','','Panopaea antarctica Gould, 1851',1,'Panopaea antarctica','Panopaea antarctica','Panopaea antarctic',2,0,'','','Gould','1fe76bf4-490c-5754-ad11-f86378c2af36','Panopaea antarctica Gould, 1851','Gould, 1851','UNRANKED','','Panopaea','','antarctica','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01763','','','Truncatella antediluviana Deshayes, 1861',1,'Truncatella antediluviana','Truncatella antediluviana','Truncatella antediluuian',2,0,'','','Deshayes','d841a169-ec8e-53ca-b564-fd0a4330c4f3','Truncatella antediluviana Deshayes, 1861','Deshayes, 1861','UNRANKED','','Truncatella','','antediluviana','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01767','','','Bulimus anthisanensis Pfeiffer, 1852',1,'Bulimus anthisanensis','Bulimus anthisanensis','Bulimus anthisanens',2,0,'','','Pfeiffer','928e7c9f-dbef-509f-8607-31d56ba2295b','Bulimus anthisanensis Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Bulimus','','anthisanensis','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01771','','','Goniobasis anthonyi Lea, 1862',1,'Goniobasis anthonyi','Goniobasis anthonyi','Goniobasis anthony',2,0,'','','Lea','b0c59429-e4ac-5aa9-8108-692783e25f2b','Goniobasis anthonyi Lea, 1862','Lea, 1862','UNRANKED','','Goniobasis','','anthonyi','','','',NULL,'','','','','','Lea','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01776','','','Arion anthracius Bourguignat, 1866',1,'Arion anthracius','Arion anthracius','Arion anthrac',2,0,'','','Bourguignat','452bba3f-137c-5333-80ff-394c5db94545','Arion anthracius Bourguignat, 1866','Bourguignat, 1866','UNRANKED','','Arion','','anthracius','','','',NULL,'','','','','','Bourguignat','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01779','','','Mactra antica Mayer, 1867',1,'Mactra antica','Mactra antica','Mactra antic',2,0,'','','Mayer','3656ab00-60f6-5076-9457-4ae7cf171d55','Mactra antica Mayer, 1867','Mayer, 1867','UNRANKED','','Mactra','','antica','','','',NULL,'','','','','','Mayer','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01782','','','Cistula antiguensis Shuttleworth, in Pfeiffer, 1858',2,'Cistula antiguensis','Cistula antiguensis','Cistula antiguens',2,0,'','','Shuttleworth|Pfeiffer','202cdc5c-a718-5567-8cad-6727d39d6c7b','Cistula antiguensis Shuttleworth, in Pfeiffer, 1858','Shuttleworth, in Pfeiffer, 1858','UNRANKED','','Cistula','','antiguensis','','','',NULL,'','','','','','Shuttleworth','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01794','','','Rhizochilus antipathum Steenstrup, 1852',1,'Rhizochilus antipathum','Rhizochilus antipathum','Rhizochilus antipath',2,0,'','','Steenstrup','e85f6a39-e0fc-50ff-b680-5ede93038a36','Rhizochilus antipathum Steenstrup, 1852','Steenstrup, 1852','UNRANKED','','Rhizochilus','','antipathum','','','',NULL,'','','','','','Steenstrup','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01799','','','Achatina antiqua Deshayes, 1863',1,'Achatina antiqua','Achatina antiqua','Achatina antiqu',2,0,'','','Deshayes','7b6aefee-b454-5d48-b917-ce58b668bc73','Achatina antiqua Deshayes, 1863','Deshayes, 1863','UNRANKED','','Achatina','','antiqua','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01806','','','Marginella antiqua Redfleld, 1852',1,'Marginella antiqua','Marginella antiqua','Marginella antiqu',2,0,'','','Redfleld','991a7812-ba7a-588c-92a2-f5463690a13f','Marginella antiqua Redfleld, 1852','Redfleld, 1852','UNRANKED','','Marginella','','antiqua','','','',NULL,'','','','','','Redfleld','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01813','','','Pleurotoma rostrata antiqua F. Edwards, 1854',1,'Pleurotoma rostrata antiqua','Pleurotoma rostrata antiqua','Pleurotoma rostrat antiqu',3,0,'','','F. Edwards','01a74a3b-61df-5fb8-b506-4e9d93003755','Pleurotoma rostrata antiqua F. Edwards, 1854','F. Edwards, 1854','UNRANKED','','Pleurotoma','','rostrata','antiqua','','',NULL,'','','','','','F. Edwards','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01818','','','Nerita antiquata Recluz, 1853',1,'Nerita antiquata','Nerita antiquata','Nerita antiquat',2,0,'','','Recluz','f61954be-5d01-593c-a4d7-45f8d2f2de34','Nerita antiquata Recluz, 1853','Recluz, 1853','UNRANKED','','Nerita','','antiquata','','','',NULL,'','','','','','Recluz','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01822','','','Triton antiquum Deshayes, 1865',1,'Triton antiquum','Triton antiquum','Triton antiqu',2,0,'','','Deshayes','b1c721ae-4bd8-5936-b0aa-37c3826a451f','Triton antiquum Deshayes, 1865','Deshayes, 1865','UNRANKED','','Triton','','antiquum','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01826','','','Voluta antiscalaris McCoy, 1866',1,'Voluta antiscalaris','Voluta antiscalaris','Voluta antiscalar',2,0,'','','McCoy','48363845-c60e-5538-9597-f1766e22c38d','Voluta antiscalaris McCoy, 1866','McCoy, 1866','UNRANKED','','Voluta','','antiscalaris','','','',NULL,'','','','','','McCoy','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01834','','','Helix antonini Michaud, 1862',1,'Helix antonini','Helix antonini','Helix antonin',2,0,'','','Michaud','2156e95d-c893-5070-bab3-7a05be39a28a','Helix antonini Michaud, 1862','Michaud, 1862','UNRANKED','','Helix','','antonini','','','',NULL,'','','','','','Michaud','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01837','','','Scalaria anversiensis Deshayes, 1861',1,'Scalaria anversiensis','Scalaria anversiensis','Scalaria anuersiens',2,0,'','','Deshayes','684bee89-f871-55b5-a080-c870419e24f1','Scalaria anversiensis Deshayes, 1861','Deshayes, 1861','UNRANKED','','Scalaria','','anversiensis','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01842','','','Cancellaria apater Ryckholt, 1861',1,'Cancellaria apater','Cancellaria apater','Cancellaria apater',2,0,'','','Ryckholt','30513884-2b9f-5230-b98a-a39cabb3e64f','Cancellaria apater Ryckholt, 1861','Ryckholt, 1861','UNRANKED','','Cancellaria','','apater','','','',NULL,'','','','','','Ryckholt','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01847','','','Pupa apennina Charpentier, in Küster, 1850',2,'Pupa apennina','Pupa apennina','Pupa apennin',2,0,'','','Charpentier|Küster','fc6d5007-08cd-51df-bcad-a98d79ab9f84','Pupa apennina Charpentier, in Küster, 1850','Charpentier, in Küster, 1850','UNRANKED','','Pupa','','apennina','','','',NULL,'','','','','','Charpentier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01858','','','Paludina aperta Küster, 1852',1,'Paludina aperta','Paludina aperta','Paludina apert',2,0,'','','Küster','91b54419-a920-5d4b-a643-63c1aeaa846d','Paludina aperta Küster, 1852','Küster, 1852','UNRANKED','','Paludina','','aperta','','','',NULL,'','','','','','Küster','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01866','','','Cardium aperturatum Deshayes, 1853',1,'Cardium aperturatum','Cardium aperturatum','Cardium aperturat',2,0,'','','Deshayes','e14c6c43-9279-55ae-86a4-bb56f3600ec3','Cardium aperturatum Deshayes, 1853','Deshayes, 1853','UNRANKED','','Cardium','','aperturatum','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01872','','','Mactra aphrodina Deshayes, 1854',1,'Mactra aphrodina','Mactra aphrodina','Mactra aphrodin',2,0,'','','Deshayes','d478cf38-bd18-5e02-8940-01e49a9ed45a','Mactra aphrodina Deshayes, 1854','Deshayes, 1854','UNRANKED','','Mactra','','aphrodina','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01874','','','Helix aphrodite Pfeiffer, 1859',1,'Helix aphrodite','Helix aphrodite','Helix aphrodit',2,0,'','','Pfeiffer','6002c652-88cd-515f-8d83-827b7424a928','Helix aphrodite Pfeiffer, 1859','Pfeiffer, 1859','UNRANKED','','Helix','','aphrodite','','','',NULL,'','','','','','Pfeiffer','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01878','','','Helix (Fruticicola) apicalis Reuss, 1860',1,'Helix apicalis','Helix apicalis','Helix apical',2,0,'','','Reuss','37d17cf4-a0ed-57fd-aa6d-ab4905d8d1d7','Helix (Fruticicola) apicalis Reuss, 1860','Reuss, 1860','UNRANKED','','Helix','Fruticicola','apicalis','','','',NULL,'','','','','','Reuss','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01881','','','Trochus apicalis C. Moore, 1867',1,'Trochus apicalis','Trochus apicalis','Trochus apical',2,0,'','','C. Moore','901246eb-6f4a-5574-b258-8571669ee582','Trochus apicalis C. Moore, 1867','C. Moore, 1867','UNRANKED','','Trochus','','apicalis','','','',NULL,'','','','','','C. Moore','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01886','','','Sportella apicialis Deshayes, 1857',1,'Sportella apicialis','Sportella apicialis','Sportella apicial',2,0,'','','Deshayes','f684fc6e-0c29-5648-b72b-bdfd7b77bb3c','Sportella apicialis Deshayes, 1857','Deshayes, 1857','UNRANKED','','Sportella','','apicialis','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01888','','','Mactra apicina Deshayes, in Reeve, 1854',2,'Mactra apicina','Mactra apicina','Mactra apicin',2,0,'','','Deshayes|Reeve','d70d6a83-0fb0-5efa-95b7-aa579b3600e8','Mactra apicina Deshayes, in Reeve, 1854','Deshayes, in Reeve, 1854','UNRANKED','','Mactra','','apicina','','','',NULL,'','','','','','Deshayes','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01897','','','Pleurotoma apiculata Montrouzier, in Souverbie and Montrouzier, 1864',2,'Pleurotoma apiculata','Pleurotoma apiculata','Pleurotoma apiculat',2,0,'','','Montrouzier|Souverbie','28e9fb99-c513-56c7-8e9a-005d7756bec8','Pleurotoma apiculata Montrouzier, in Souverbie and Montrouzier, 1864','Montrouzier, in Souverbie and Montrouzier, 1864','UNRANKED','','Pleurotoma','','apiculata','','','',NULL,'','','','','','Montrouzier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01907','','','Bythinia aploa Bourguignat, 1860',1,'Bythinia aploa','Bythinia aploa','Bythinia aplo',2,0,'','','Bourguignat','b4b7fee6-ecf4-574e-a895-5499e7b42923','Bythinia aploa Bourguignat, 1860','Bourguignat, 1860','UNRANKED','','Bythinia','','aploa','','','',NULL,'','','','','','Bourguignat','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01912','','','Helix appendiculata Pfeiffer, 1854',1,'Helix appendiculata','Helix appendiculata','Helix appendiculat',2,0,'','','Pfeiffer','ee8eaec2-8f9f-538f-8a24-f23cd9ffe023','Helix appendiculata Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Helix','','appendiculata','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01917','','','Trochus applanatus Piette, 1855',1,'Trochus applanatus','Trochus applanatus','Trochus applanat',2,0,'','','Piette','47d58503-54dd-5aea-9db8-d71bdcb6f5d2','Trochus applanatus Piette, 1855','Piette, 1855','UNRANKED','','Trochus','','applanatus','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01921','','','Lima appressa Gabb, 1864',1,'Lima appressa','Lima appressa','Lima appress',2,0,'','','Gabb','e798b4ca-7fac-51c4-9643-4179ce902306','Lima appressa Gabb, 1864','Gabb, 1864','UNRANKED','','Lima','','appressa','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01926','','','Clausilia approximans Ziegler, in A. Schmidt, 1857',2,'Clausilia approximans','Clausilia approximans','Clausilia approximans',2,0,'','','Ziegler|A. Schmidt','051fc8cd-a85d-5fe0-89e5-8d8da286b920','Clausilia approximans Ziegler, in A. Schmidt, 1857','Ziegler, in A. Schmidt, 1857','UNRANKED','','Clausilia','','approximans','','','',NULL,'','','','','','Ziegler','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01931','','','Pleurotoma approximata Deshayes, 1865',1,'Pleurotoma approximata','Pleurotoma approximata','Pleurotoma approximat',2,0,'','','Deshayes','39597614-45ce-5586-ac8c-71202fa5c53e','Pleurotoma approximata Deshayes, 1865','Deshayes, 1865','UNRANKED','','Pleurotoma','','approximata','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01933','','','Turricula approximata Pease, 1860',1,'Turricula approximata','Turricula approximata','Turricula approximat',2,0,'','','Pease','97f8f08e-dc28-5ce3-b66e-ae0c92c2e31e','Turricula approximata Pease, 1860','Pease, 1860','UNRANKED','','Turricula','','approximata','','','',NULL,'','','','','','Pease','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01942','','','Panopaea aptiensis Coquand, 1865',1,'Panopaea aptiensis','Panopaea aptiensis','Panopaea aptiens',2,0,'','','Coquand','1c23f6f7-b376-511a-981e-810922de1aa4','Panopaea aptiensis Coquand, 1865','Coquand, 1865','UNRANKED','','Panopaea','','aptiensis','','','',NULL,'','','','','','Coquand','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01944','','','Limnaea stagnalis aquarii Colbeau, 1865',1,'Limnaea stagnalis aquarii','Limnaea stagnalis aquarii','Limnaea stagnal aquar',3,0,'','','Colbeau','dd3daaff-0091-5194-93e3-7c5bc3f2f16d','Limnaea stagnalis aquarii Colbeau, 1865','Colbeau, 1865','UNRANKED','','Limnaea','','stagnalis','aquarii','','',NULL,'','','','','','Colbeau','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01947','','','Melania aquatilis Reeve, 1859',1,'Melania aquatilis','Melania aquatilis','Melania aquatil',2,0,'','','Reeve','11b93e19-f88b-5a83-9253-024c49aed250','Melania aquatilis Reeve, 1859','Reeve, 1859','UNRANKED','','Melania','','aquatilis','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01950','','','Fissurella aquensis Orbigny, 1852',1,'Fissurella aquensis','Fissurella aquensis','Fissurella aquens',2,0,'','','Orbigny','374008d9-e88d-525c-b4f0-b317a752a7f8','Fissurella aquensis Orbigny, 1852','Orbigny, 1852','UNRANKED','','Fissurella','','aquensis','','','',NULL,'','','','','','Orbigny','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01957','','','Vitrina aquila Cox, 1868',1,'Vitrina aquila','Vitrina aquila','Vitrina aquil',2,0,'','','Cox','b8ba439f-a912-5a8e-84d8-475d76a3da35','Vitrina aquila Cox, 1868','Cox, 1868','UNRANKED','','Vitrina','','aquila','','','',NULL,'','','','','','Cox','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01962','','','Arca aquitanica Mayer, 1861',1,'Arca aquitanica','Arca aquitanica','Arca aquitanic',2,0,'','','Mayer','268b299d-2e07-5c9b-8649-ac1acab4746b','Arca aquitanica Mayer, 1861','Mayer, 1861','UNRANKED','','Arca','','aquitanica','','','',NULL,'','','','','','Mayer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01966','','','Tellina aquitanica Mayer, 1864',1,'Tellina aquitanica','Tellina aquitanica','Tellina aquitanic',2,0,'','','Mayer','50f542fd-442e-53da-baf2-aa05efa8aad5','Tellina aquitanica Mayer, 1864','Mayer, 1864','UNRANKED','','Tellina','','aquitanica','','','',NULL,'','','','','','Mayer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01969','','','Cardium aquitanicum Mayer, 1858',1,'Cardium aquitanicum','Cardium aquitanicum','Cardium aquitanic',2,0,'','','Mayer','18e15904-1daa-5a0c-a0f8-6aa397394bc6','Cardium aquitanicum Mayer, 1858','Mayer, 1858','UNRANKED','','Cardium','','aquitanicum','','','',NULL,'','','','','','Mayer','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01975','','','Axinaea (Pectunculus) arabica H. Adams, 1870',1,'Axinaea arabica','Axinaea arabica','Axinaea arabic',2,0,'','','H. Adams','351e4dd8-a156-5f0e-a8fb-7d778d9af6b0','Axinaea (Pectunculus) arabica H. Adams, 1870','H. Adams, 1870','UNRANKED','','Axinaea','Pectunculus','arabica','','','',NULL,'','','','','','H. Adams','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01979','','','Nerita arabica Reeve, 1855',1,'Nerita arabica','Nerita arabica','Nerita arabic',2,0,'','','Reeve','60d8b391-925d-5246-ac67-d24fbe35c321','Nerita arabica Reeve, 1855','Reeve, 1855','UNRANKED','','Nerita','','arabica','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01984','','','Pleurotomaria arachne Billings, 1865',1,'Pleurotomaria arachne','Pleurotomaria arachne','Pleurotomaria arachn',2,0,'','','Billings','3a7cddac-3093-581e-8a18-26d8057012dd','Pleurotomaria arachne Billings, 1865','Billings, 1865','UNRANKED','','Pleurotomaria','','arachne','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01989','','','Ericina aradae Giunti, in Biondi, 1859',2,'Ericina aradae','Ericina aradae','Ericina arad',2,0,'','','Giunti|Biondi','9f6c17bf-926d-5ec6-89f5-718c57f65ea2','Ericina aradae Giunti, in Biondi, 1859','Giunti, in Biondi, 1859','UNRANKED','','Ericina','','aradae','','','',NULL,'','','','','','Giunti','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_01996','','','Rostellaria aralensis Eichwald, 1868',1,'Rostellaria aralensis','Rostellaria aralensis','Rostellaria aralens',2,0,'','','Eichwald','46d88a18-98b4-5b40-8462-fcbdbf1ff1db','Rostellaria aralensis Eichwald, 1868','Eichwald, 1868','UNRANKED','','Rostellaria','','aralensis','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02001','','','Cyclostoma arangianum Gundlach, in Pfeiffer, 1857',2,'Cyclostoma arangianum','Cyclostoma arangianum','Cyclostoma arangian',2,0,'','','Gundlach|Pfeiffer','60b90afc-df70-59e4-bdde-81201163e028','Cyclostoma arangianum Gundlach, in Pfeiffer, 1857','Gundlach, in Pfeiffer, 1857','UNRANKED','','Cyclostoma','','arangianum','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02008','','','Cyrena arata Forbes, 1851',1,'Cyrena arata','Cyrena arata','Cyrena arat',2,0,'','','Forbes','81fd9f9c-9bec-541f-b0ae-ed72799de667','Cyrena arata Forbes, 1851','Forbes, 1851','UNRANKED','','Cyrena','','arata','','','',NULL,'','','','','','Forbes','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02010','','','Ficula arata Mayer, 1867',1,'Ficula arata','Ficula arata','Ficula arat',2,0,'','','Mayer','77c7dcbe-5ca2-5d56-bc6d-a28e87d69560','Ficula arata Mayer, 1867','Mayer, 1867','UNRANKED','','Ficula','','arata','','','',NULL,'','','','','','Mayer','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02013','','','Modiola arata Dunker, in Reeve, 1857',2,'Modiola arata','Modiola arata','Modiola arat',2,0,'','','Dunker|Reeve','6ea3fcda-9c5f-5b54-af3f-e13256db25e7','Modiola arata Dunker, in Reeve, 1857','Dunker, in Reeve, 1857','UNRANKED','','Modiola','','arata','','','',NULL,'','','','','','Dunker','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02020','','','Pinna arata Forbes, 1856',1,'Pinna arata','Pinna arata','Pinna arat',2,0,'','','Forbes','1aa3ec96-1956-56d7-8671-db896900969a','Pinna arata Forbes, 1856','Forbes, 1856','UNRANKED','','Pinna','','arata','','','',NULL,'','','','','','Forbes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02028','','','Fusus aratus Gabb, 1864',1,'Fusus aratus','Fusus aratus','Fusus arat',2,0,'','','Gabb','eac5f68a-77c2-5a76-ad90-c4b4492526e2','Fusus aratus Gabb, 1864','Gabb, 1864','UNRANKED','','Fusus','','aratus','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02036','','','Helix arbusticola Deshayes, 1870',1,'Helix arbusticola','Helix arbusticola','Helix arbusticol',2,0,'','','Deshayes','7bafa950-c72a-57e4-9eb3-67d8e61830b9','Helix arbusticola Deshayes, 1870','Deshayes, 1870','UNRANKED','','Helix','','arbusticola','','','',NULL,'','','','','','Deshayes','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02039','','','Pisidium arcaeforme Malm, 1855',1,'Pisidium arcaeforme','Pisidium arcaeforme','Pisidium arcaeform',2,0,'','','Malm','8f3ff265-61cb-5298-9d09-a5840532a335','Pisidium arcaeforme Malm, 1855','Malm, 1855','UNRANKED','','Pisidium','','arcaeforme','','','',NULL,'','','','','','Malm','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02043','','','Truncatella arcasiana Crosse, 1868',1,'Truncatella arcasiana','Truncatella arcasiana','Truncatella arcasian',2,0,'','','Crosse','a805e4cc-e2f7-5302-9e24-73985ecd8b41','Truncatella arcasiana Crosse, 1868','Crosse, 1868','UNRANKED','','Truncatella','','arcasiana','','','',NULL,'','','','','','Crosse','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02045','','','Voluta (Lyria) archeri Angas, 1865',1,'Voluta archeri','Voluta archeri','Voluta archer',2,0,'','','Angas','2c4f30d4-1f63-5357-afea-9fa94882879d','Voluta (Lyria) archeri Angas, 1865','Angas, 1865','UNRANKED','','Voluta','Lyria','archeri','','','',NULL,'','','','','','Angas','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02050','','','Cerithium archiaci Piette, 1855',1,'Cerithium archiaci','Cerithium archiaci','Cerithium archiac',2,0,'','','Piette','27090ded-e1ce-5d20-a818-b6c9e255cee0','Cerithium archiaci Piette, 1855','Piette, 1855','UNRANKED','','Cerithium','','archiaci','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02055','','','Phasianella archiaci Piette, 1855',1,'Phasianella archiaci','Phasianella archiaci','Phasianella archiac',2,0,'','','Piette','0c56d6a0-bea1-54d0-9228-e34ed0e3da71','Phasianella archiaci Piette, 1855','Piette, 1855','UNRANKED','','Phasianella','','archiaci','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02059','','','Pleurotomaria archiaciana Cotteau, 1854',1,'Pleurotomaria archiaciana','Pleurotomaria archiaciana','Pleurotomaria archiacian',2,0,'','','Cotteau','f2e008e1-a2ec-5e9d-8f7e-85388e59335d','Pleurotomaria archiaciana Cotteau, 1854','Cotteau, 1854','UNRANKED','','Pleurotomaria','','archiaciana','','','',NULL,'','','','','','Cotteau','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02067','','','Pyramis architectonicus A. Adams, 1851',1,'Pyramis architectonicus','Pyramis architectonicus','Pyramis architectonic',2,0,'','','A. Adams','08b81a20-6103-5e90-a787-f151cb3609b2','Pyramis architectonicus A. Adams, 1851','A. Adams, 1851','UNRANKED','','Pyramis','','architectonicus','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02071','','','Elathia arconatii Issel, 1869',1,'Elathia arconatii','Elathia arconatii','Elathia arconat',2,0,'','','Issel','c58025d6-5cd7-5fa2-aa4b-0b11417f2950','Elathia arconatii Issel, 1869','Issel, 1869','UNRANKED','','Elathia','','arconatii','','','',NULL,'','','','','','Issel','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02076','','','Tellina (Tellinella) arcotensis Stoliczka, 1870',1,'Tellina arcotensis','Tellina arcotensis','Tellina arcotens',2,0,'','','Stoliczka','cce41469-da8f-5445-81af-cbdc9c59c67d','Tellina (Tellinella) arcotensis Stoliczka, 1870','Stoliczka, 1870','UNRANKED','','Tellina','Tellinella','arcotensis','','','',NULL,'','','','','','Stoliczka','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02078','','','Venus arcotensis Forbes, 1856',1,'Venus arcotensis','Venus arcotensis','Venus arcotens',2,0,'','','Forbes','02b5dc0c-4586-522e-a9f4-c341e9b6c97b','Venus arcotensis Forbes, 1856','Forbes, 1856','UNRANKED','','Venus','','arcotensis','','','',NULL,'','','','','','Forbes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02086','','','Colus arctatus Conrad, 1855',1,'Colus arctatus','Colus arctatus','Colus arctat',2,0,'','','Conrad','359cdb54-fbfd-5ec8-b18a-a1db4ad07d2b','Colus arctatus Conrad, 1855','Conrad, 1855','UNRANKED','','Colus','','arctatus','','','',NULL,'','','','','','Conrad','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02093','','','Tapes arctica Reeve, 1864',1,'Tapes arctica','Tapes arctica','Tapes arctic',2,0,'','','Reeve','77d66b20-8d1d-5a6f-9caf-0825392e0595','Tapes arctica Reeve, 1864','Reeve, 1864','UNRANKED','','Tapes','','arctica','','','',NULL,'','','','','','Reeve','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02096','','','Cylindrella arctispira Pfeiffer, 1861',1,'Cylindrella arctispira','Cylindrella arctispira','Cylindrella arctispir',2,0,'','','Pfeiffer','73683199-782e-528c-a22b-e81e8d1f92be','Cylindrella arctispira Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Cylindrella','','arctispira','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02101','','','Anatina arcuata Forbes, 1856',1,'Anatina arcuata','Anatina arcuata','Anatina arcuat',2,0,'','','Forbes','d10f9f2b-ac22-503b-9d25-fd292058b928','Anatina arcuata Forbes, 1856','Forbes, 1856','UNRANKED','','Anatina','','arcuata','','','',NULL,'','','','','','Forbes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02105','','','Lutraria arcuata Deshayes, 1854',1,'Lutraria arcuata','Lutraria arcuata','Lutraria arcuat',2,0,'','','Deshayes','6b1e3ea6-a1d5-5245-9dae-cc1d903d46cf','Lutraria arcuata Deshayes, 1854','Deshayes, 1854','UNRANKED','','Lutraria','','arcuata','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02107','','','Odostomia (Evalea) arcuata A. Adams, 1860',1,'Odostomia arcuata','Odostomia arcuata','Odostomia arcuat',2,0,'','','A. Adams','e16d691e-9a9f-52a5-ba2b-d0abd50ceb00','Odostomia (Evalea) arcuata A. Adams, 1860','A. Adams, 1860','UNRANKED','','Odostomia','Evalea','arcuata','','','',NULL,'','','','','','A. Adams','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02110','','','Solen siliqua arcuata Jeffreys, 1865',1,'Solen siliqua arcuata','Solen siliqua arcuata','Solen siliqu arcuat',3,0,'','','Jeffreys','f2368a8c-45e4-55c2-861f-98a4be559318','Solen siliqua arcuata Jeffreys, 1865','Jeffreys, 1865','UNRANKED','','Solen','','siliqua','arcuata','','',NULL,'','','','','','Jeffreys','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02115','','','Bulimus arcuato-striatus Pfeiffer, 1855',1,'Bulimus arcuato-striatus','Bulimus arcuato-striatus','Bulimus arcuato-striat',2,0,'','','Pfeiffer','fcf37d6f-3500-5bac-aac2-f316cda80e75','Bulimus arcuato-striatus Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Bulimus','','arcuato-striatus','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02121','','','Cylindrella arcustriata Wright, in Pfeiffer, 1864',2,'Cylindrella arcustriata','Cylindrella arcustriata','Cylindrella arcustriat',2,0,'','','Wright|Pfeiffer','5041f898-09c3-5782-9594-968f9e59c2cd','Cylindrella arcustriata Wright, in Pfeiffer, 1864','Wright, in Pfeiffer, 1864','UNRANKED','','Cylindrella','','arcustriata','','','',NULL,'','','','','','Wright','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02125','','','Acteonina arduennensis Piette, 1856',1,'Acteonina arduennensis','Acteonina arduennensis','Acteonina arduennens',2,0,'','','Piette','426b4da2-00f9-5296-8ee8-17cdabcea22e','Acteonina arduennensis Piette, 1856','Piette, 1856','UNRANKED','','Acteonina','','arduennensis','','','',NULL,'','','','','','Piette','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02132','','','Natica ardunnensis Buvignier, 1852',1,'Natica ardunnensis','Natica ardunnensis','Natica ardunnens',2,0,'','','Buvignier','26e87766-6739-511e-abe6-580ba919bff9','Natica ardunnensis Buvignier, 1852','Buvignier, 1852','UNRANKED','','Natica','','ardunnensis','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02137','','','Mitra arenacea Dunker, 1852',1,'Mitra arenacea','Mitra arenacea','Mitra arenace',2,0,'','','Dunker','9e96ae01-b9fd-5d90-b812-2f7c3970736a','Mitra arenacea Dunker, 1852','Dunker, 1852','UNRANKED','','Mitra','','arenacea','','','',NULL,'','','','','','Dunker','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02142','','','Avicula textilis arenaria Hall, 1859',1,'Avicula textilis arenaria','Avicula textilis arenaria','Avicula textil arenar',3,0,'','','Hall','b3c88476-7612-561a-92f6-92cf807f2580','Avicula textilis arenaria Hall, 1859','Hall, 1859','UNRANKED','','Avicula','','textilis','arenaria','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02149','','','Ennea arenicola Morelet, 1860',1,'Ennea arenicola','Ennea arenicola','Ennea arenicol',2,0,'','','Morelet','3f1ceadc-d327-5003-a1e2-f03a5d4f8c22','Ennea arenicola Morelet, 1860','Morelet, 1860','UNRANKED','','Ennea','','arenicola','','','',NULL,'','','','','','Morelet','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02152','','','Saxicava arenicola Terquem, 1855',1,'Saxicava arenicola','Saxicava arenicola','Saxicava arenicol',2,0,'','','Terquem','8e3c04ca-9e50-5967-ac68-3e036c75d36b','Saxicava arenicola Terquem, 1855','Terquem, 1855','UNRANKED','','Saxicava','','arenicola','','','',NULL,'','','','','','Terquem','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02157','','','Aclesia areola Pease, 1860',1,'Aclesia areola','Aclesia areola','Aclesia areol',2,0,'','','Pease','c4f47dee-b0dd-590e-b9dc-755f04b11b63','Aclesia areola Pease, 1860','Pease, 1860','UNRANKED','','Aclesia','','areola','','','',NULL,'','','','','','Pease','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02164','','','Turritella areolata Stimpson, 1851',1,'Turritella areolata','Turritella areolata','Turritella areolat',2,0,'','','Stimpson','1cc34828-0b78-5154-8a1b-bd170c11e26c','Turritella areolata Stimpson, 1851','Stimpson, 1851','UNRANKED','','Turritella','','areolata','','','',NULL,'','','','','','Stimpson','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02167','','','Mytilus (Modiola) areolatus Gould, 1851',1,'Mytilus areolatus','Mytilus areolatus','Mytilus areolat',2,0,'','','Gould','f4ea6d0d-9b75-5f5c-8008-ce30b44370de','Mytilus (Modiola) areolatus Gould, 1851','Gould, 1851','UNRANKED','','Mytilus','Modiola','areolatus','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02170','','','Rissoa areolifera F. Sandberger, 1863',1,'Rissoa areolifera','Rissoa areolifera','Rissoa areolifer',2,0,'','','F. Sandberger','5e2359cd-f8f3-5d3d-879d-14f035998bf5','Rissoa areolifera F. Sandberger, 1863','F. Sandberger, 1863','UNRANKED','','Rissoa','','areolifera','','','',NULL,'','','','','','F. Sandberger','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02174','','','Avicula argentea Reeve, 1857',1,'Avicula argentea','Avicula argentea','Avicula argente',2,0,'','','Reeve','ec399446-2eb7-5611-aa5f-c1a37280cd26','Avicula argentea Reeve, 1857','Reeve, 1857','UNRANKED','','Avicula','','argentea','','','',NULL,'','','','','','Reeve','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02177','','','Pulvinites argentea Conrad, 1858',1,'Pulvinites argentea','Pulvinites argentea','Pulvinites argente',2,0,'','','Conrad','3069912e-94ce-5c77-9ba3-420433e34aa8','Pulvinites argentea Conrad, 1858','Conrad, 1858','UNRANKED','','Pulvinites','','argentea','','','',NULL,'','','','','','Conrad','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02181','','','Sigaretus argenteus Reeve, 1864',1,'Sigaretus argenteus','Sigaretus argenteus','Sigaretus argente',2,0,'','','Reeve','a3edbfd1-77ef-579d-b7b2-cffc9074e3d2','Sigaretus argenteus Reeve, 1864','Reeve, 1864','UNRANKED','','Sigaretus','','argenteus','','','',NULL,'','','','','','Reeve','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02186','','','Perna argillacea Gould, 1851',1,'Perna argillacea','Perna argillacea','Perna argillace',2,0,'','','Gould','6feed25c-6acb-5fb0-8ae6-d203e0a5c967','Perna argillacea Gould, 1851','Gould, 1851','UNRANKED','','Perna','','argillacea','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02193','','','Lima argonnensis Buvignier, 1852',1,'Lima argonnensis','Lima argonnensis','Lima argonnens',2,0,'','','Buvignier','fd2684d7-10ed-5264-9a68-a3b9029d5bbc','Lima argonnensis Buvignier, 1852','Buvignier, 1852','UNRANKED','','Lima','','argonnensis','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02196','','','Helix arguta Pfeiffer, 1856',1,'Helix arguta','Helix arguta','Helix argut',2,0,'','','Pfeiffer','64e3a093-d266-5b2e-9f31-de58d4bed347','Helix arguta Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Helix','','arguta','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02200','','','Bulimus argutus Pease, 1864',1,'Bulimus argutus','Bulimus argutus','Bulimus argut',2,0,'','','Pease','06e3c945-6b17-5374-85a5-4ea8eb3c8b77','Bulimus argutus Pease, 1864','Pease, 1864','UNRANKED','','Bulimus','','argutus','','','',NULL,'','','','','','Pease','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02202','','','Helix arianensis Bourguignat, 1868',1,'Helix arianensis','Helix arianensis','Helix arianens',2,0,'','','Bourguignat','8af1a67a-ca69-5d79-83e5-3e5ab7f2e5c7','Helix arianensis Bourguignat, 1868','Bourguignat, 1868','UNRANKED','','Helix','','arianensis','','','',NULL,'','','','','','Bourguignat','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02206','','','Delphinulopsis arietina Laube, 1870',1,'Delphinulopsis arietina','Delphinulopsis arietina','Delphinulopsis arietin',2,0,'','','Laube','4f9549a1-14aa-506d-b3b1-83ab58c3aab7','Delphinulopsis arietina Laube, 1870','Laube, 1870','UNRANKED','','Delphinulopsis','','arietina','','','',NULL,'','','','','','Laube','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02210','','','Pecten arion Orbigny, 1852',1,'Pecten arion','Pecten arion','Pecten arion',2,0,'','','Orbigny','af0d8b4f-a959-5a67-a1e8-afb3010d7a73','Pecten arion Orbigny, 1852','Orbigny, 1852','UNRANKED','','Pecten','','arion','','','',NULL,'','','','','','Orbigny','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02213','','','Bulimus aristaeus Crosse, 1869',1,'Bulimus aristaeus','Bulimus aristaeus','Bulimus aristae',2,0,'','','Crosse','82f6bed0-e59a-579c-b603-02c39289c9f0','Bulimus aristaeus Crosse, 1869','Crosse, 1869','UNRANKED','','Bulimus','','aristaeus','','','',NULL,'','','','','','Crosse','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02221','','','Liotia armata A. Adams, 1861',1,'Liotia armata','Liotia armata','Liotia armat',2,0,'','','A. Adams','b91127fc-f561-56f9-bb63-9cdf18611e2e','Liotia armata A. Adams, 1861','A. Adams, 1861','UNRANKED','','Liotia','','armata','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02225','','','Tectaria armata Issel, 1869',1,'Tectaria armata','Tectaria armata','Tectaria armat',2,0,'','','Issel','965b933f-e2da-5929-a66a-f981765ceb44','Tectaria armata Issel, 1869','Issel, 1869','UNRANKED','','Tectaria','','armata','','','',NULL,'','','','','','Issel','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02227','','','Triton armatum Hupe, 1854',1,'Triton armatum','Triton armatum','Triton armat',2,0,'','','Hupe','d2de8d45-84af-512e-8e5c-7e09d962b358','Triton armatum Hupe, 1854','Hupe, 1854','UNRANKED','','Triton','','armatum','','','',NULL,'','','','','','Hupe','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02232','','','Cardium armenicum Eichwald, 1868',1,'Cardium armenicum','Cardium armenicum','Cardium armenic',2,0,'','','Eichwald','efc0e29f-8067-5165-ac02-ebf274bf3b25','Cardium armenicum Eichwald, 1868','Eichwald, 1868','UNRANKED','','Cardium','','armenicum','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02234','','','Amberleya armigera Lycett, 1863',1,'Amberleya armigera','Amberleya armigera','Amberleya armiger',2,0,'','','Lycett','f761bc16-0305-5756-ab60-50b076238fae','Amberleya armigera Lycett, 1863','Lycett, 1863','UNRANKED','','Amberleya','','armigera','','','',NULL,'','','','','','Lycett','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02242','','','Helix armitageana R. Lowe, 1852',1,'Helix armitageana','Helix armitageana','Helix armitagean',2,0,'','','R. Lowe','3d60f26a-9e94-5990-94de-528a8d3b3358','Helix armitageana R. Lowe, 1852','R. Lowe, 1852','UNRANKED','','Helix','','armitageana','','','',NULL,'','','','','','R. Lowe','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02247','','','Capsa arnaudi Coquand, 1859',1,'Capsa arnaudi','Capsa arnaudi','Capsa arnaud',2,0,'','','Coquand','ed46e48c-ec3b-5fdc-a40e-43daabd78894','Capsa arnaudi Coquand, 1859','Coquand, 1859','UNRANKED','','Capsa','','arnaudi','','','',NULL,'','','','','','Coquand','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02255','','','Unio arquatus Conrad, 1854',1,'Unio arquatus','Unio arquatus','Unio arquat',2,0,'','','Conrad','b337650a-1047-5b79-af2a-48ed1e814aa5','Unio arquatus Conrad, 1854','Conrad, 1854','UNRANKED','','Unio','','arquatus','','','',NULL,'','','','','','Conrad','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02258','','','Aporrhais arrialoorensis Stoliczka, 1867',1,'Aporrhais arrialoorensis','Aporrhais arrialoorensis','Aporrhais arrialoorens',2,0,'','','Stoliczka','fa85105f-ce4f-5d1a-aba6-74900f10483b','Aporrhais arrialoorensis Stoliczka, 1867','Stoliczka, 1867','UNRANKED','','Aporrhais','','arrialoorensis','','','',NULL,'','','','','','Stoliczka','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02264','','','Helix arrouxi Bourguignat, 1863',1,'Helix arrouxi','Helix arrouxi','Helix arroux',2,0,'','','Bourguignat','f942fefb-9b5a-57b8-aad5-65ea82181ec7','Helix arrouxi Bourguignat, 1863','Bourguignat, 1863','UNRANKED','','Helix','','arrouxi','','','',NULL,'','','','','','Bourguignat','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02268','','','Murchisonia artemesia Billings, 1865',1,'Murchisonia artemesia','Murchisonia artemesia','Murchisonia artemes',2,0,'','','Billings','63ff9e61-b97c-5caa-a704-371c5bfc3db5','Murchisonia artemesia Billings, 1865','Billings, 1865','UNRANKED','','Murchisonia','','artemesia','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02273','','','Cyclostoma artense Montrouzier, 1859',1,'Cyclostoma artense','Cyclostoma artense','Cyclostoma artens',2,0,'','','Montrouzier','5e503f00-39ec-52e0-a669-6928050932ed','Cyclostoma artense Montrouzier, 1859','Montrouzier, 1859','UNRANKED','','Cyclostoma','','artense','','','',NULL,'','','','','','Montrouzier','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02276','','','Mactra artensis Montrouzier, in Fischer, 1859',2,'Mactra artensis','Mactra artensis','Mactra artens',2,0,'','','Montrouzier|Fischer','2311246c-bfb7-5d5c-ad4f-ff6334ca661d','Mactra artensis Montrouzier, in Fischer, 1859','Montrouzier, in Fischer, 1859','UNRANKED','','Mactra','','artensis','','','',NULL,'','','','','','Montrouzier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02285','','','Achatina arthuri Benson, 1864',1,'Achatina arthuri','Achatina arthuri','Achatina arthur',2,0,'','','Benson','c1fde987-6f10-5c46-8c27-2a2ca08beaa5','Achatina arthuri Benson, 1864','Benson, 1864','UNRANKED','','Achatina','','arthuri','','','',NULL,'','','','','','Benson','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02291','','','Columbella articulata Souverbie, in Souverbie and Montrouzier, 1864',2,'Columbella articulata','Columbella articulata','Columbella articulat',2,0,'','','Souverbie|Montrouzier','ca316100-c1b2-5abb-bd7a-1f4da04932e3','Columbella articulata Souverbie, in Souverbie and Montrouzier, 1864','Souverbie, in Souverbie and Montrouzier, 1864','UNRANKED','','Columbella','','articulata','','','',NULL,'','','','','','Souverbie','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02301','','','Helix artificiosa Benson, 1856',1,'Helix artificiosa','Helix artificiosa','Helix artificios',2,0,'','','Benson','525f1332-c98e-5954-afdf-573d1dc2ee72','Helix artificiosa Benson, 1856','Benson, 1856','UNRANKED','','Helix','','artificiosa','','','',NULL,'','','','','','Benson','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02310','','','Pecten arzierensis Loriol, 1868',1,'Pecten arzierensis','Pecten arzierensis','Pecten arzierens',2,0,'','','Loriol','b9882a68-41d6-51a5-8767-ab4ee8a884aa','Pecten arzierensis Loriol, 1868','Loriol, 1868','UNRANKED','','Pecten','','arzierensis','','','',NULL,'','','','','','Loriol','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02314','','','Pupa ascendens Martens, 1864',1,'Pupa ascendens','Pupa ascendens','Pupa ascendens',2,0,'','','Martens','4cb05911-1799-5e2d-b0b1-7f27ccc06918','Pupa ascendens Martens, 1864','Martens, 1864','UNRANKED','','Pupa','','ascendens','','','',NULL,'','','','','','Martens','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02319','','','Natica asellus Reeve, 1855',1,'Natica asellus','Natica asellus','Natica asell',2,0,'','','Reeve','b70085bf-70a3-50c4-a35c-6582b08bb4c6','Natica asellus Reeve, 1855','Reeve, 1855','UNRANKED','','Natica','','asellus','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02326','','','Helix (Planispira) aspasia H. Adams, 1865',1,'Helix aspasia','Helix aspasia','Helix aspas',2,0,'','','H. Adams','ca30f129-16b1-56a4-a2ca-8b60dc6be362','Helix (Planispira) aspasia H. Adams, 1865','H. Adams, 1865','UNRANKED','','Helix','Planispira','aspasia','','','',NULL,'','','','','','H. Adams','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02327','','','Margarita aspecta A. Adams, 1854',1,'Margarita aspecta','Margarita aspecta','Margarita aspect',2,0,'','','A. Adams','a6dd24e0-6ec1-5c81-be51-39202cf848be','Margarita aspecta A. Adams, 1854','A. Adams, 1854','UNRANKED','','Margarita','','aspecta','','','',NULL,'','','','','','A. Adams','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02332','','','Columbellina aspera Ryckholt, 1862',1,'Columbellina aspera','Columbellina aspera','Columbellina asper',2,0,'','','Ryckholt','e4dcf790-6b7e-54cd-a67a-a9a37622b1ed','Columbellina aspera Ryckholt, 1862','Ryckholt, 1862','UNRANKED','','Columbellina','','aspera','','','',NULL,'','','','','','Ryckholt','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02336','','','Lucina aspera Buvignier, 1852',1,'Lucina aspera','Lucina aspera','Lucina asper',2,0,'','','Buvignier','299086a0-3b7d-59e8-8e71-fb006352afb8','Lucina aspera Buvignier, 1852','Buvignier, 1852','UNRANKED','','Lucina','','aspera','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02338','','','Pirena aspera Brot, 1868',1,'Pirena aspera','Pirena aspera','Pirena asper',2,0,'','','Brot','26d55db1-9b77-5f72-a03a-fc784908f927','Pirena aspera Brot, 1868','Brot, 1868','UNRANKED','','Pirena','','aspera','','','',NULL,'','','','','','Brot','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02344','','','Bulimus asperatus Albers, 1857',1,'Bulimus asperatus','Bulimus asperatus','Bulimus asperat',2,0,'','','Albers','e0d533ca-3f92-5756-8c6b-010762a1a031','Bulimus asperatus Albers, 1857','Albers, 1857','UNRANKED','','Bulimus','','asperatus','','','',NULL,'','','','','','Albers','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02348','','','Lucina aspernata Loriol, in Loriol and Cotteau, 1867',2,'Lucina aspernata','Lucina aspernata','Lucina aspernat',2,0,'','','Loriol|Cotteau','75371dee-ba4a-5c83-8292-e8834ef2c524','Lucina aspernata Loriol, in Loriol and Cotteau, 1867','Loriol, in Loriol and Cotteau, 1867','UNRANKED','','Lucina','','aspernata','','','',NULL,'','','','','','Loriol','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02356','','','Doris aspersa Gould, 1852',1,'Doris aspersa','Doris aspersa','Doris aspers',2,0,'','','Gould','7da986e4-11e9-5d1a-b6ea-86960acda09d','Doris aspersa Gould, 1852','Gould, 1852','UNRANKED','','Doris','','aspersa','','','',NULL,'','','','','','Gould','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02360','','','Melania aspersa Reeve, 1860',1,'Melania aspersa','Melania aspersa','Melania aspers',2,0,'','','Reeve','68dc2173-383e-5af1-a4c2-89673e775a6a','Melania aspersa Reeve, 1860','Reeve, 1860','UNRANKED','','Melania','','aspersa','','','',NULL,'','','','','','Reeve','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02365','','','Lima asperula Gümbel, 186?',2,'Lima asperula','Lima asperula','Lima asperul',2,0,'','','Gümbel','4d6c4f2f-41f7-5428-97a1-f0b115ad94bb','Lima asperula Gümbel, 186?','Gümbel, 186?','UNRANKED','','Lima','','asperula','','','',NULL,'','','','','','Gümbel','','','','(186?)','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02370','','','Gena asperulata A. Adams, 1850',1,'Gena asperulata','Gena asperulata','Gena asperulat',2,0,'','','A. Adams','b213e953-885d-5e17-9878-1a7c9f78fd70','Gena asperulata A. Adams, 1850','A. Adams, 1850','UNRANKED','','Gena','','asperulata','','','',NULL,'','','','','','A. Adams','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02376','','','Marginella asphari W. Theobald, 1860',1,'Marginella asphari','Marginella asphari','Marginella asphar',2,0,'','','W. Theobald','c73a4350-e37f-5822-bae1-6ec77fdd5ecf','Marginella asphari W. Theobald, 1860','W. Theobald, 1860','UNRANKED','','Marginella','','asphari','','','',NULL,'','','','','','W. Theobald','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02383','','','Chondropoma assimile Gundlach, in Pfeiffer, 1863',2,'Chondropoma assimile','Chondropoma assimile','Chondropoma assimil',2,0,'','','Gundlach|Pfeiffer','8053aba1-0c6e-5bc2-89a3-a2bad419c11c','Chondropoma assimile Gundlach, in Pfeiffer, 1863','Gundlach, in Pfeiffer, 1863','UNRANKED','','Chondropoma','','assimile','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02393','','','Nanina (Acusta) assimilis H. Adams, 1866',1,'Nanina assimilis','Nanina assimilis','Nanina assimil',2,0,'','','H. Adams','a7e61301-de71-5735-9cb9-710234f52da4','Nanina (Acusta) assimilis H. Adams, 1866','H. Adams, 1866','UNRANKED','','Nanina','Acusta','assimilis','','','',NULL,'','','','','','H. Adams','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02400','','','Corbula astartea Mayer and Gümbel, in Gümbel, 1861',2,'Corbula astartea','Corbula astartea','Corbula astarte',2,0,'','','Mayer|Gümbel','72a32b86-9b90-52a5-a845-abbfd3587f2b','Corbula astartea Mayer and Gümbel, in Gümbel, 1861','Mayer and Gümbel, in Gümbel, 1861','UNRANKED','','Corbula','','astartea','','','',NULL,'','','','','','Mayer & Gümbel','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02408','','','Trochus astartinus Thurmann, in Thurmann and Etallon, 1862',2,'Trochus astartinus','Trochus astartinus','Trochus astartin',2,0,'','','Thurmann|Etallon','68ccb627-1caf-586c-b2f8-ff69e0aa7e99','Trochus astartinus Thurmann, in Thurmann and Etallon, 1862','Thurmann, in Thurmann and Etallon, 1862','UNRANKED','','Trochus','','astartinus','','','',NULL,'','','','','','Thurmann','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02414','','','Cythnia asteriaphila P. Carpenter, 1864',1,'Cythnia asteriaphila','Cythnia asteriaphila','Cythnia asteriaphil',2,0,'','','P. Carpenter','6fc0e425-4c18-5c98-87fb-ba9659f2ed31','Cythnia asteriaphila P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Cythnia','','asteriaphila','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02418','','','Heteroceras astieranum Orbigny, 1851',1,'Heteroceras astieranum','Heteroceras astieranum','Heteroceras astieran',2,0,'','','Orbigny','4fa3e129-d3c9-5006-9853-ff0e5bdffcf4','Heteroceras astieranum Orbigny, 1851','Orbigny, 1851','UNRANKED','','Heteroceras','','astieranum','','','',NULL,'','','','','','Orbigny','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02420','','','Helix pyramidata astieri A. Moquin-Tandon, 1855',1,'Helix pyramidata astieri','Helix pyramidata astieri','Helix pyramidat astier',3,0,'','','A. Moquin-Tandon','81368ca9-5c91-5525-b12e-bdad9c060ef3','Helix pyramidata astieri A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','pyramidata','astieri','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02427','','','Helix astur Souverbie, 1860',1,'Helix astur','Helix astur','Helix astur',2,0,'','','Souverbie','6a62019c-d4f4-5395-94a0-9599ddedbe5a','Helix astur Souverbie, 1860','Souverbie, 1860','UNRANKED','','Helix','','astur','','','',NULL,'','','','','','Souverbie','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02433','','','Paludina atacamensis Philippi, 1860',1,'Paludina atacamensis','Paludina atacamensis','Paludina atacamens',2,0,'','','Philippi','9e79eb4a-6f6c-582a-bea2-a7d7af444b3b','Paludina atacamensis Philippi, 1860','Philippi, 1860','UNRANKED','','Paludina','','atacamensis','','','',NULL,'','','','','','Philippi','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02438','','','Vitrina ataranensis W. Theobald, 1870',1,'Vitrina ataranensis','Vitrina ataranensis','Vitrina ataranens',2,0,'','','W. Theobald','6aac86d8-b6ef-5afc-ad76-886784a6d6fd','Vitrina ataranensis W. Theobald, 1870','W. Theobald, 1870','UNRANKED','','Vitrina','','ataranensis','','','',NULL,'','','','','','W. Theobald','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02448','','','Acteon atherstoni Sharpe, 1856',1,'Acteon atherstoni','Acteon atherstoni','Acteon atherston',2,0,'','','Sharpe','b223de4e-a73b-5ae3-b5af-265c9ce73fea','Acteon atherstoni Sharpe, 1856','Sharpe, 1856','UNRANKED','','Acteon','','atherstoni','','','',NULL,'','','','','','Sharpe','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02450','','','Modiola atherstoni Sharpe, 1856',1,'Modiola atherstoni','Modiola atherstoni','Modiola atherston',2,0,'','','Sharpe','2c3d70d4-db76-5c6e-8cbb-d790a0ef410a','Modiola atherstoni Sharpe, 1856','Sharpe, 1856','UNRANKED','','Modiola','','atherstoni','','','',NULL,'','','','','','Sharpe','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02455','','','Turbo atherstoni Sharpe, 1856',1,'Turbo atherstoni','Turbo atherstoni','Turbo atherston',2,0,'','','Sharpe','3d2a2b96-1fa1-5d45-aed0-b3383c8882d3','Turbo atherstoni Sharpe, 1856','Sharpe, 1856','UNRANKED','','Turbo','','atherstoni','','','',NULL,'','','','','','Sharpe','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02460','','','Gryphaea athyroides Guppy, 1866',1,'Gryphaea athyroides','Gryphaea athyroides','Gryphaea athyroid',2,0,'','','Guppy','741de22b-4b7c-590c-8573-a22390051390','Gryphaea athyroides Guppy, 1866','Guppy, 1866','UNRANKED','','Gryphaea','','athyroides','','','',NULL,'','','','','','Guppy','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02464','','','Fiona atlantica Bergh, 1857',1,'Fiona atlantica','Fiona atlantica','Fiona atlantic',2,0,'','','Bergh','543c5c54-2c09-5ea7-90ef-35dd221a2e6e','Fiona atlantica Bergh, 1857','Bergh, 1857','UNRANKED','','Fiona','','atlantica','','','',NULL,'','','','','','Bergh','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02469','','','Pomatias atlanticus Bourguignat, 1868',1,'Pomatias atlanticus','Pomatias atlanticus','Pomatias atlantic',2,0,'','','Bourguignat','bfbb8a07-df14-5d5f-90d4-123d7d6cdd44','Pomatias atlanticus Bourguignat, 1868','Bourguignat, 1868','UNRANKED','','Pomatias','','atlanticus','','','',NULL,'','','','','','Bourguignat','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02470','','','Cingula atomaria Gould, 1861',1,'Cingula atomaria','Cingula atomaria','Cingula atomar',2,0,'','','Gould','49cb683e-826f-5bbb-9227-d43775e71f78','Cingula atomaria Gould, 1861','Gould, 1861','UNRANKED','','Cingula','','atomaria','','','',NULL,'','','','','','Gould','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02474','','','Liotia atomus Issel, 1869',1,'Liotia atomus','Liotia atomus','Liotia atom',2,0,'','','Issel','c2e1c818-fc33-57b0-b908-1a4b8e13d40c','Liotia atomus Issel, 1869','Issel, 1869','UNRANKED','','Liotia','','atomus','','','',NULL,'','','','','','Issel','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02476','','','Triphoris atomus Issel, 1869',1,'Triphoris atomus','Triphoris atomus','Triphoris atom',2,0,'','','Issel','727fd4a9-9dd5-5448-be62-dba008159d90','Triphoris atomus Issel, 1869','Issel, 1869','UNRANKED','','Triphoris','','atomus','','','',NULL,'','','','','','Issel','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02481','','','Thylacodes colubrinus atra Mörch, 1862',1,'Thylacodes colubrinus atra','Thylacodes colubrinus atra','Thylacodes colubrin atr',3,0,'','','Mörch','654edea0-ad00-5bc0-92b0-0012524f47d0','Thylacodes colubrinus atra Mörch, 1862','Mörch, 1862','UNRANKED','','Thylacodes','','colubrinus','atra','','',NULL,'','','','','','Mörch','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02485','','','Patella atramentosa Reeve, 1854',1,'Patella atramentosa','Patella atramentosa','Patella atramentos',2,0,'','','Reeve','97160326-abac-519a-bbf0-b71ab286c7c3','Patella atramentosa Reeve, 1854','Reeve, 1854','UNRANKED','','Patella','','atramentosa','','','',NULL,'','','','','','Reeve','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02489','','','Doris atrata Kelaart, 1859',1,'Doris atrata','Doris atrata','Doris atrat',2,0,'','','Kelaart','5c144560-15ea-5b4c-907c-d2ebd9b8956d','Doris atrata Kelaart, 1859','Kelaart, 1859','UNRANKED','','Doris','','atrata','','','',NULL,'','','','','','Kelaart','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02494','','','Milax atratus Mabille, 1868',1,'Milax atratus','Milax atratus','Milax atrat',2,0,'','','Mabille','db52a405-a35d-5c08-9fd9-baf4191a30bf','Milax atratus Mabille, 1868','Mabille, 1868','UNRANKED','','Milax','','atratus','','','',NULL,'','','','','','Mabille','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02500','','','Cerithium atropos Bayan, 1870',1,'Cerithium atropos','Cerithium atropos','Cerithium atrop',2,0,'','','Bayan','fc667dfb-bf86-596c-aa49-fd967722d441','Cerithium atropos Bayan, 1870','Bayan, 1870','UNRANKED','','Cerithium','','atropos','','','',NULL,'','','','','','Bayan','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02505','','','Mytilus atropurpureus Dunker, 1856',1,'Mytilus atropurpureus','Mytilus atropurpureus','Mytilus atropurpure',2,0,'','','Dunker','f41b41c3-0e46-57b9-9129-4f8fa91c8e36','Mytilus atropurpureus Dunker, 1856','Dunker, 1856','UNRANKED','','Mytilus','','atropurpureus','','','',NULL,'','','','','','Dunker','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02509','','','Helix attegia Benson, 1859',1,'Helix attegia','Helix attegia','Helix atteg',2,0,'','','Benson','2527bdd4-30d5-5828-87c0-444172270210','Helix attegia Benson, 1859','Benson, 1859','UNRANKED','','Helix','','attegia','','','',NULL,'','','','','','Benson','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02513','','','Ambonychia attenuata Hall, 1861',1,'Ambonychia attenuata','Ambonychia attenuata','Ambonychia attenuat',2,0,'','','Hall','e6aa2276-996d-5c71-be96-50530981fe33','Ambonychia attenuata Hall, 1861','Hall, 1861','UNRANKED','','Ambonychia','','attenuata','','','',NULL,'','','','','','Hall','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02519','','','Chiton fascicularis attenuata Jeffreys, 1865',1,'Chiton fascicularis attenuata','Chiton fascicularis attenuata','Chiton fascicular attenuat',3,0,'','','Jeffreys','b70952e1-fffc-52d4-a9c7-0d50dc9511ad','Chiton fascicularis attenuata Jeffreys, 1865','Jeffreys, 1865','UNRANKED','','Chiton','','fascicularis','attenuata','','',NULL,'','','','','','Jeffreys','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02526','','','Loxonema attenuata Hall, 1859',1,'Loxonema attenuata','Loxonema attenuata','Loxonema attenuat',2,0,'','','Hall','6510f06e-8832-5ae2-8e2c-2f1686e81d3a','Loxonema attenuata Hall, 1859','Hall, 1859','UNRANKED','','Loxonema','','attenuata','','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02533','','','Partula attenuata Pease, 1864',1,'Partula attenuata','Partula attenuata','Partula attenuat',2,0,'','','Pease','46542da0-49ce-51fd-8093-879ce9d8114c','Partula attenuata Pease, 1864','Pease, 1864','UNRANKED','','Partula','','attenuata','','','',NULL,'','','','','','Pease','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02536','','','Pinna attenuata Reeve, 1858',1,'Pinna attenuata','Pinna attenuata','Pinna attenuat',2,0,'','','Reeve','a3340700-3822-5d10-a609-a28cc53d81bc','Pinna attenuata Reeve, 1858','Reeve, 1858','UNRANKED','','Pinna','','attenuata','','','',NULL,'','','','','','Reeve','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02543','','','Cirsotrema attenuatum Pease, 1860',1,'Cirsotrema attenuatum','Cirsotrema attenuatum','Cirsotrema attenuat',2,0,'','','Pease','1d1a6ca2-3cf0-5f5f-87a8-140a1b7ecb57','Cirsotrema attenuatum Pease, 1860','Pease, 1860','UNRANKED','','Cirsotrema','','attenuatum','','','',NULL,'','','','','','Pease','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02548','','','Chondrus attenuatus Mousson, 1854',1,'Chondrus attenuatus','Chondrus attenuatus','Chondrus attenuat',2,0,'','','Mousson','020ec7d0-4fca-582f-a7c7-be43ca924e95','Chondrus attenuatus Mousson, 1854','Mousson, 1854','UNRANKED','','Chondrus','','attenuatus','','','',NULL,'','','','','','Mousson','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02557','','','Clausilia attica Parreyss, in A. Schmidt, 1868',2,'Clausilia attica','Clausilia attica','Clausilia attic',2,0,'','','Parreyss|A. Schmidt','1dcb8285-aa2e-52b6-bb76-8a6d15f973fc','Clausilia attica Parreyss, in A. Schmidt, 1868','Parreyss, in A. Schmidt, 1868','UNRANKED','','Clausilia','','attica','','','',NULL,'','','','','','Parreyss','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02560','','','Planorbis atticus Bourguignat, 1852',1,'Planorbis atticus','Planorbis atticus','Planorbis attic',2,0,'','','Bourguignat','dafba530-f981-53a5-aacc-4ec2f74d028d','Planorbis atticus Bourguignat, 1852','Bourguignat, 1852','UNRANKED','','Planorbis','','atticus','','','',NULL,'','','','','','Bourguignat','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02565','','','Natica atylodes Gümbel, 1861',1,'Natica atylodes','Natica atylodes','Natica atylod',2,0,'','','Gümbel','f97ab0f9-4937-514a-9baf-4b43f9390242','Natica atylodes Gümbel, 1861','Gümbel, 1861','UNRANKED','','Natica','','atylodes','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02567','','','Cerithium aubersonense Pictet and Campiche, 1862',1,'Cerithium aubersonense','Cerithium aubersonense','Cerithium aubersonens',2,0,'','','Pictet|Campiche','e1e3fca5-ba4f-50b4-936b-84d413bbcb4c','Cerithium aubersonense Pictet and Campiche, 1862','Pictet and Campiche, 1862','UNRANKED','','Cerithium','','aubersonense','','','',NULL,'','','','','','Pictet & Campiche','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02572','','','Pleurotomaria aubersonensis Pictet and Campiche, 1863',1,'Pleurotomaria aubersonensis','Pleurotomaria aubersonensis','Pleurotomaria aubersonens',2,0,'','','Pictet|Campiche','85dee402-355f-5045-886a-3c004cde28db','Pleurotomaria aubersonensis Pictet and Campiche, 1863','Pictet and Campiche, 1863','UNRANKED','','Pleurotomaria','','aubersonensis','','','',NULL,'','','','','','Pictet & Campiche','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02576','','','Ostrea aucapitainei Coquand, 1869',1,'Ostrea aucapitainei','Ostrea aucapitainei','Ostrea aucapitaine',2,0,'','','Coquand','cfe4f725-e3a7-557d-9c44-c96856f902e6','Ostrea aucapitainei Coquand, 1869','Coquand, 1869','UNRANKED','','Ostrea','','aucapitainei','','','',NULL,'','','','','','Coquand','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02581','','','Pecten aucklandicus Zittel, 1865',1,'Pecten aucklandicus','Pecten aucklandicus','Pecten aucklandic',2,0,'','','Zittel','66cbc5fe-35ab-58ec-90a3-36344e12943c','Pecten aucklandicus Zittel, 1865','Zittel, 1865','UNRANKED','','Pecten','','aucklandicus','','','',NULL,'','','','','','Zittel','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02582','','','Helix audebardi Pfeiffer, 1851',1,'Helix audebardi','Helix audebardi','Helix audebard',2,0,'','','Pfeiffer','31f49175-60b7-5ec9-bd52-3ef7f18fd21a','Helix audebardi Pfeiffer, 1851','Pfeiffer, 1851','UNRANKED','','Helix','','audebardi','','','',NULL,'','','','','','Pfeiffer','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02587','','','Trochus augusti Dumortier, 1857',1,'Trochus augusti','Trochus augusti','Trochus august',2,0,'','','Dumortier','118ba06d-6d90-5dd3-9450-6b4650d83040','Trochus augusti Dumortier, 1857','Dumortier, 1857','UNRANKED','','Trochus','','augusti','','','',NULL,'','','','','','Dumortier','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02589','','','Cardita auingeri Hörnes, 1865',1,'Cardita auingeri','Cardita auingeri','Cardita auinger',2,0,'','','Hörnes','65558580-6b38-54e9-8671-8eddb41ef0b6','Cardita auingeri Hörnes, 1865','Hörnes, 1865','UNRANKED','','Cardita','','auingeri','','','',NULL,'','','','','','Hörnes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02597','','','Chemnitzia aurantia P. Carpenter, 1864',1,'Chemnitzia aurantia','Chemnitzia aurantia','Chemnitzia aurant',2,0,'','','P. Carpenter','e102070e-c088-56ec-90c6-09c701b4870c','Chemnitzia aurantia P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Chemnitzia','','aurantia','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02603','','','Styloptygma aurantiaca Angas, 1867',1,'Styloptygma aurantiaca','Styloptygma aurantiaca','Styloptygma aurantiac',2,0,'','','Angas','53ddef44-6951-5823-9143-b4f4baed8980','Styloptygma aurantiaca Angas, 1867','Angas, 1867','UNRANKED','','Styloptygma','','aurantiaca','','','',NULL,'','','','','','Angas','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02610','','','Clathurella aurea P. Carpenter, 1856',1,'Clathurella aurea','Clathurella aurea','Clathurella aure',2,0,'','','P. Carpenter','2e3b6acf-bcf7-5eb3-8054-6b46651be739','Clathurella aurea P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Clathurella','','aurea','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02615','','','Helix aurelenta Beck, in Pfeiffer, 1853',2,'Helix aurelenta','Helix aurelenta','Helix aurelent',2,0,'','','Beck|Pfeiffer','92b69c1b-c5e9-56d5-bf7e-e0a63882cc40','Helix aurelenta Beck, in Pfeiffer, 1853','Beck, in Pfeiffer, 1853','UNRANKED','','Helix','','aurelenta','','','',NULL,'','','','','','Beck','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02624','','','Plicatula auressensis Coquand, 1862',1,'Plicatula auressensis','Plicatula auressensis','Plicatula auressens',2,0,'','','Coquand','ffa322e4-5af4-574e-af6b-9e2e52a7edd8','Plicatula auressensis Coquand, 1862','Coquand, 1862','UNRANKED','','Plicatula','','auressensis','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02632','','','Limnaeus auricula Küster, 1862',1,'Limnaeus auricula','Limnaeus auricula','Limnaeus auricul',2,0,'','','Küster','8ad5b523-21c0-5a87-a417-dd43e91ce360','Limnaeus auricula Küster, 1862','Küster, 1862','UNRANKED','','Limnaeus','','auricula','','','',NULL,'','','','','','Küster','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02637','','','Caecum auriculatum Folin, 1868',1,'Caecum auriculatum','Caecum auriculatum','Caecum auriculat',2,0,'','','Folin','14307ef8-1924-5925-970a-0ed4813d34f1','Caecum auriculatum Folin, 1868','Folin, 1868','UNRANKED','','Caecum','','auriculatum','','','',NULL,'','','','','','Folin','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02643','','','Helix auriformis Bland, 1859',1,'Helix auriformis','Helix auriformis','Helix auriform',2,0,'','','Bland','e2afa5dc-a822-5d6a-a65e-40d83b6dce27','Helix auriformis Bland, 1859','Bland, 1859','UNRANKED','','Helix','','auriformis','','','',NULL,'','','','','','Bland','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02647','','','Bulimus auris Pfeiffer, 1865',1,'Bulimus auris','Bulimus auris','Bulimus aur',2,0,'','','Pfeiffer','ea3a7d26-8a35-5e0a-b5b4-713bbd2fd218','Bulimus auris Pfeiffer, 1865','Pfeiffer, 1865','UNRANKED','','Bulimus','','auris','','','',NULL,'','','','','','Pfeiffer','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02650','','','Bulimus auris-myoxi Shuttleworth, 1852',1,'Bulimus auris-myoxi','Bulimus auris-myoxi','Bulimus auris-myox',2,0,'','','Shuttleworth','b2f2bfe9-bd57-526c-90fa-818e63856c69','Bulimus auris-myoxi Shuttleworth, 1852','Shuttleworth, 1852','UNRANKED','','Bulimus','','auris-myoxi','','','',NULL,'','','','','','Shuttleworth','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02655','','','Helix aurita Martens, 1864',1,'Helix aurita','Helix aurita','Helix aurit',2,0,'','','Martens','a7f0ecbc-930f-5aea-a3e3-60e93933aa9c','Helix aurita Martens, 1864','Martens, 1864','UNRANKED','','Helix','','aurita','','','',NULL,'','','','','','Martens','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02660','','','Cyclostoma aurora Benson, 1851',1,'Cyclostoma aurora','Cyclostoma aurora','Cyclostoma auror',2,0,'','','Benson','b21d50b7-6893-5e6a-b136-d14de86bdba2','Cyclostoma aurora Benson, 1851','Benson, 1851','UNRANKED','','Cyclostoma','','aurora','','','',NULL,'','','','','','Benson','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02666','','','Nanina austeni W. Blanford, 1870',1,'Nanina austeni','Nanina austeni','Nanina austen',2,0,'','','W. Blanford','0fc9763f-a230-5ce0-a819-d07d34777dc1','Nanina austeni W. Blanford, 1870','W. Blanford, 1870','UNRANKED','','Nanina','','austeni','','','',NULL,'','','','','','W. Blanford','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02672','','','Diplommatina australiae Benson, 1855',1,'Diplommatina australiae','Diplommatina australiae','Diplommatina australi',2,0,'','','Benson','3367496a-2e5e-5d32-9c43-7fee98feb3cb','Diplommatina australiae Benson, 1855','Benson, 1855','UNRANKED','','Diplommatina','','australiae','','','',NULL,'','','','','','Benson','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02679','','','Actinodoris australis Angas, 1864',1,'Actinodoris australis','Actinodoris australis','Actinodoris austral',2,0,'','','Angas','3b13edf8-e71a-5265-b989-a56f6b1ea5eb','Actinodoris australis Angas, 1864','Angas, 1864','UNRANKED','','Actinodoris','','australis','','','',NULL,'','','','','','Angas','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02682','','','Calobates australis E. Wright, 1866',1,'Calobates australis','Calobates australis','Calobates austral',2,0,'','','E. Wright','31104c38-157e-5477-93fd-01c18a96e12c','Calobates australis E. Wright, 1866','E. Wright, 1866','UNRANKED','','Calobates','','australis','','','',NULL,'','','','','','E. Wright','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02689','','','Erycina australis Deshayes, 1855',1,'Erycina australis','Erycina australis','Erycina austral',2,0,'','','Deshayes','6a9c4605-d2a6-5b71-9555-85d268980145','Erycina australis Deshayes, 1855','Deshayes, 1855','UNRANKED','','Erycina','','australis','','','',NULL,'','','','','','Deshayes','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02697','','','Martesia australis J. Gray, 1851',1,'Martesia australis','Martesia australis','Martesia austral',2,0,'','','J. Gray','18749893-9327-5cf8-a423-9bfe97c6c143','Martesia australis J. Gray, 1851','J. Gray, 1851','UNRANKED','','Martesia','','australis','','','',NULL,'','','','','','J. Gray','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02701','','','Melibaea australis Angas, 1864',1,'Melibaea australis','Melibaea australis','Melibaea austral',2,0,'','','Angas','2b8f77e7-c80b-5f81-af4e-43ac98ef083e','Melibaea australis Angas, 1864','Angas, 1864','UNRANKED','','Melibaea','','australis','','','',NULL,'','','','','','Angas','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02707','','','Ringicula australis Crosse and Fischer, 1865',1,'Ringicula australis','Ringicula australis','Ringicula austral',2,0,'','','Crosse|Fischer','98154346-69c5-58c8-8aaf-f34d7b5e7670','Ringicula australis Crosse and Fischer, 1865','Crosse and Fischer, 1865','UNRANKED','','Ringicula','','australis','','','',NULL,'','','','','','Crosse & Fischer','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02715','','','Vitrina australis Pfeiffer, in Reeve, 1862',2,'Vitrina australis','Vitrina australis','Vitrina austral',2,0,'','','Pfeiffer|Reeve','fbf48fd9-5d65-55dd-959c-cd8d3acc8c2c','Vitrina australis Pfeiffer, in Reeve, 1862','Pfeiffer, in Reeve, 1862','UNRANKED','','Vitrina','','australis','','','',NULL,'','','','','','Pfeiffer','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02722','','','Paludinella austriaca Frauenfeld, 1863',1,'Paludinella austriaca','Paludinella austriaca','Paludinella austriac',2,0,'','','Frauenfeld','442428a4-f85d-5254-9e66-03727a8f4a87','Paludinella austriaca Frauenfeld, 1863','Frauenfeld, 1863','UNRANKED','','Paludinella','','austriaca','','','',NULL,'','','','','','Frauenfeld','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02729','','','Arca autissiodorensis Cotteau, 1855',1,'Arca autissiodorensis','Arca autissiodorensis','Arca autissiodorens',2,0,'','','Cotteau','ab79e640-4729-529c-b469-49cbd8dee3af','Arca autissiodorensis Cotteau, 1855','Cotteau, 1855','UNRANKED','','Arca','','autissiodorensis','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02734','','','Mytilus autissiodorensis Cotteau, 1855',1,'Mytilus autissiodorensis','Mytilus autissiodorensis','Mytilus autissiodorens',2,0,'','','Cotteau','5f5543af-c1eb-5e05-8cb6-d088ce3ff6b2','Mytilus autissiodorensis Cotteau, 1855','Cotteau, 1855','UNRANKED','','Mytilus','','autissiodorensis','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02738','','','Tellina autissiodorensis Cotteau, 1855',1,'Tellina autissiodorensis','Tellina autissiodorensis','Tellina autissiodorens',2,0,'','','Cotteau','86807fde-446a-583b-a764-033f25304c06','Tellina autissiodorensis Cotteau, 1855','Cotteau, 1855','UNRANKED','','Tellina','','autissiodorensis','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02745','','','Bulimus auversiensis Deshayes, 1863',1,'Bulimus auversiensis','Bulimus auversiensis','Bulimus auuersiens',2,0,'','','Deshayes','53705d99-9b71-5c80-b460-9e7388dfb0e2','Bulimus auversiensis Deshayes, 1863','Deshayes, 1863','UNRANKED','','Bulimus','','auversiensis','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02751','','','Alycaeus avae W. Blanford, 1863',1,'Alycaeus avae','Alycaeus avae','Alycaeus au',2,0,'','','W. Blanford','c08ed646-8d55-5eb1-b05c-69c89fc0f1ce','Alycaeus avae W. Blanford, 1863','W. Blanford, 1863','UNRANKED','','Alycaeus','','avae','','','',NULL,'','','','','','W. Blanford','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02757','','','Natica avellana Philippi, 1852',1,'Natica avellana','Natica avellana','Natica auellan',2,0,'','','Philippi','f8fe33e8-ebe2-5095-a4ba-30e6b1dc0f1b','Natica avellana Philippi, 1852','Philippi, 1852','UNRANKED','','Natica','','avellana','','','',NULL,'','','','','','Philippi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02764','','','Orthostoma avena Terquem, 1855',1,'Orthostoma avena','Orthostoma avena','Orthostoma auen',2,0,'','','Terquem','bd8e9f3c-adca-505f-9e46-c054e1b4fcdb','Orthostoma avena Terquem, 1855','Terquem, 1855','UNRANKED','','Orthostoma','','avena','','','',NULL,'','','','','','Terquem','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02768','','','Unio averyi Lea, 1859',1,'Unio averyi','Unio averyi','Unio auery',2,0,'','','Lea','23eaf4f8-a778-57c0-96b1-eb12e029b0d2','Unio averyi Lea, 1859','Lea, 1859','UNRANKED','','Unio','','averyi','','','',NULL,'','','','','','Lea','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02770','','','Cytherea avia Deshayes, 1857',1,'Cytherea avia','Cytherea avia','Cytherea au',2,0,'','','Deshayes','86d4ea3d-c5d4-5576-8acc-2cae6a0b7df0','Cytherea avia Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cytherea','','avia','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02776','','','Megambonia aviculoidea Hall, 1859',1,'Megambonia aviculoidea','Megambonia aviculoidea','Megambonia auiculoide',2,0,'','','Hall','537f7e43-18f4-596b-bdb5-b289358ff3de','Megambonia aviculoidea Hall, 1859','Hall, 1859','UNRANKED','','Megambonia','','aviculoidea','','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02779','','','Myalina aviculoides Meek and Hayden, 1860',1,'Myalina aviculoides','Myalina aviculoides','Myalina auiculoid',2,0,'','','Meek|Hayden','3c5e0692-68ae-58df-bd06-372a159a3d23','Myalina aviculoides Meek and Hayden, 1860','Meek and Hayden, 1860','UNRANKED','','Myalina','','aviculoides','','','',NULL,'','','','','','Meek & Hayden','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02786','','','Turbo aviothensis Buvignier, 1852',1,'Turbo aviothensis','Turbo aviothensis','Turbo auiothens',2,0,'','','Buvignier','e2b087d2-737f-51b2-abab-467dcd9ee780','Turbo aviothensis Buvignier, 1852','Buvignier, 1852','UNRANKED','','Turbo','','aviothensis','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02791','','','Helix avus Pfeiffer, 1852',1,'Helix avus','Helix avus','Helix au',2,0,'','','Pfeiffer','3175a271-c5a4-5ac5-b405-084f8a2821bd','Helix avus Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Helix','','avus','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02797','','','Astarte aytonensis Bean, in Lycett, 1863',2,'Astarte aytonensis','Astarte aytonensis','Astarte aytonens',2,0,'','','Bean|Lycett','e94193c7-d0ca-5a43-9b5f-4527320c05f6','Astarte aytonensis Bean, in Lycett, 1863','Bean, in Lycett, 1863','UNRANKED','','Astarte','','aytonensis','','','',NULL,'','','','','','Bean','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02802','','','Glandina azorica Albers, 1852',1,'Glandina azorica','Glandina azorica','Glandina azoric',2,0,'','','Albers','4509d296-26d6-5602-b85d-8a2b4fe54d08','Glandina azorica Albers, 1852','Albers, 1852','UNRANKED','','Glandina','','azorica','','','',NULL,'','','','','','Albers','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02807','','','Helix bacca Pfeiffer, 1865',1,'Helix bacca','Helix bacca','Helix bacc',2,0,'','','Pfeiffer','6e6a4810-f575-5413-9ed1-09e236a9ea18','Helix bacca Pfeiffer, 1865','Pfeiffer, 1865','UNRANKED','','Helix','','bacca','','','',NULL,'','','','','','Pfeiffer','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02813','','','Paludomus baccula Reeve, 1852',1,'Paludomus baccula','Paludomus baccula','Paludomus baccul',2,0,'','','Reeve','5b22ee17-0b59-58dd-aa59-f3966f122830','Paludomus baccula Reeve, 1852','Reeve, 1852','UNRANKED','','Paludomus','','baccula','','','',NULL,'','','','','','Reeve','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02816','','','Pleurotomaria bachelieri M. Rouault, 1851',1,'Pleurotomaria bachelieri','Pleurotomaria bachelieri','Pleurotomaria bachelier',2,0,'','','M. Rouault','2e6d91d1-6a7a-57c4-9228-50d1afef0e69','Pleurotomaria bachelieri M. Rouault, 1851','M. Rouault, 1851','UNRANKED','','Pleurotomaria','','bachelieri','','','',NULL,'','','','','','M. Rouault','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02821','','','Terebra bacillus Deshayes, 1859',1,'Terebra bacillus','Terebra bacillus','Terebra bacill',2,0,'','','Deshayes','e52f4e8b-1e5f-5f6d-97d1-c34706211f91','Terebra bacillus Deshayes, 1859','Deshayes, 1859','UNRANKED','','Terebra','','bacillus','','','',NULL,'','','','','','Deshayes','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02828','','','Siphonaria baconi Reeve, 1856',1,'Siphonaria baconi','Siphonaria baconi','Siphonaria bacon',2,0,'','','Reeve','575325b9-450f-5f50-9668-edea0696ecc7','Siphonaria baconi Reeve, 1856','Reeve, 1856','UNRANKED','','Siphonaria','','baconi','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02833','','','Nerinea baculiformis Gemmellaro, 1865',1,'Nerinea baculiformis','Nerinea baculiformis','Nerinea baculiform',2,0,'','','Gemmellaro','63fd0d8f-c7cd-5435-926f-17898b5b6e04','Nerinea baculiformis Gemmellaro, 1865','Gemmellaro, 1865','UNRANKED','','Nerinea','','baculiformis','','','',NULL,'','','','','','Gemmellaro','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02835','','','Cerithiopsis baculum A. Adams, 1861',1,'Cerithiopsis baculum','Cerithiopsis baculum','Cerithiopsis bacul',2,0,'','','A. Adams','c05949dd-a46a-536f-aaff-e9231541e44b','Cerithiopsis baculum A. Adams, 1861','A. Adams, 1861','UNRANKED','','Cerithiopsis','','baculum','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02842','','','Elusa badia A. Adams, 1862',1,'Elusa badia','Elusa badia','Elusa bad',2,0,'','','A. Adams','3ae384d4-4fa2-5164-8d35-a2124cd58c4b','Elusa badia A. Adams, 1862','A. Adams, 1862','UNRANKED','','Elusa','','badia','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02850','','','Vermetus (Vermetus) varians badia Mörch, 1861',1,'Vermetus varians badia','Vermetus varians badia','Vermetus uarians bad',3,0,'','','Mörch','ff75ba40-fd14-5137-8ce9-d441b03d482d','Vermetus (Vermetus) varians badia Mörch, 1861','Mörch, 1861','UNRANKED','','Vermetus','','varians','badia','','',NULL,'','','','','','Mörch','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02853','','','Olivella baetica P. Carpenter, 1864',1,'Olivella baetica','Olivella baetica','Olivella baetic',2,0,'','','P. Carpenter','04199fdb-bc5a-599d-a497-c9ad7064bca6','Olivella baetica P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Olivella','','baetica','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02858','','','Unio bagdadensis Bourguignat, 1852',1,'Unio bagdadensis','Unio bagdadensis','Unio bagdadens',2,0,'','','Bourguignat','c5edc289-5089-542a-903f-11b5ba1178be','Unio bagdadensis Bourguignat, 1852','Bourguignat, 1852','UNRANKED','','Unio','','bagdadensis','','','',NULL,'','','','','','Bourguignat','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02861','','','Cylindrella bahamensis Pfeiffer, 1861',1,'Cylindrella bahamensis','Cylindrella bahamensis','Cylindrella bahamens',2,0,'','','Pfeiffer','777e1f6f-9eb4-51b9-b852-b186e59695bc','Cylindrella bahamensis Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Cylindrella','','bahamensis','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02864','','','Neritina bahiensis Recluz, 1850',1,'Neritina bahiensis','Neritina bahiensis','Neritina bahiens',2,0,'','','Recluz','79cc919f-5632-54aa-b3bd-cc853ea054f4','Neritina bahiensis Recluz, 1850','Recluz, 1850','UNRANKED','','Neritina','','bahiensis','','','',NULL,'','','','','','Recluz','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02868','','','Spatha baikii H. Adams, 1866',1,'Spatha baikii','Spatha baikii','Spatha baik',2,0,'','','H. Adams','81ee306a-68c1-5d53-9838-ca030149fde8','Spatha baikii H. Adams, 1866','H. Adams, 1866','UNRANKED','','Spatha','','baikii','','','',NULL,'','','','','','H. Adams','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02879','','','Helix (Camaena) bairdi H. Adams, 1866',1,'Helix bairdi','Helix bairdi','Helix baird',2,0,'','','H. Adams','e448d820-49cf-5801-b579-2731e48ce610','Helix (Camaena) bairdi H. Adams, 1866','H. Adams, 1866','UNRANKED','','Helix','Camaena','bairdi','','','',NULL,'','','','','','H. Adams','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02883','','','Truncatella bairdiana C.B. Adams, 1852',1,'Truncatella bairdiana','Truncatella bairdiana','Truncatella bairdian',2,0,'','','C. B. Adams','78aada76-ca94-5ab7-87cf-39fd033dd54b','Truncatella bairdiana C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Truncatella','','bairdiana','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02891','','','Helix baladensis Souverbie, in Souverbie and Montrouzier, 1863',2,'Helix baladensis','Helix baladensis','Helix baladens',2,0,'','','Souverbie|Montrouzier','2f31736a-1a59-5e5c-92a5-e3108baf0f2e','Helix baladensis Souverbie, in Souverbie and Montrouzier, 1863','Souverbie, in Souverbie and Montrouzier, 1863','UNRANKED','','Helix','','baladensis','','','',NULL,'','','','','','Souverbie','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02896','','','Valvata balatonica Rolle, 1861',1,'Valvata balatonica','Valvata balatonica','Valvata balatonic',2,0,'','','Rolle','c0cd335a-af84-567c-9e56-a9c9a27f3082','Valvata balatonica Rolle, 1861','Rolle, 1861','UNRANKED','','Valvata','','balatonica','','','',NULL,'','','','','','Rolle','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02900','','','Clausilia baldensis Parreyss, in Charpentier, 1852',2,'Clausilia baldensis','Clausilia baldensis','Clausilia baldens',2,0,'','','Parreyss|Charpentier','4ba31627-26ed-56b8-b637-ed70873ef2f1','Clausilia baldensis Parreyss, in Charpentier, 1852','Parreyss, in Charpentier, 1852','UNRANKED','','Clausilia','','baldensis','','','',NULL,'','','','','','Parreyss','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02905','','','Alexia balearica Dohrn and Heynemann, 1862',1,'Alexia balearica','Alexia balearica','Alexia balearic',2,0,'','','Dohrn|Heynemann','6ac5d42f-33f7-5db0-b79b-b7f53961f1fe','Alexia balearica Dohrn and Heynemann, 1862','Dohrn and Heynemann, 1862','UNRANKED','','Alexia','','balearica','','','',NULL,'','','','','','Dohrn & Heynemann','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02910','','','Helcion balinense Stoliczka, in Laube, 1866',2,'Helcion balinense','Helcion balinense','Helcion balinens',2,0,'','','Stoliczka|Laube','947f6d88-ce67-5df4-a9cb-b59c79d77c71','Helcion balinense Stoliczka, in Laube, 1866','Stoliczka, in Laube, 1866','UNRANKED','','Helcion','','balinense','','','',NULL,'','','','','','Stoliczka','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02917','','','Unio balonnensis Conrad, 1850',1,'Unio balonnensis','Unio balonnensis','Unio balonnens',2,0,'','','Conrad','aa211e2f-d7cf-5039-921d-6ed17ae02769','Unio balonnensis Conrad, 1850','Conrad, 1850','UNRANKED','','Unio','','balonnensis','','','',NULL,'','','','','','Conrad','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02922','','','Cerithidea balteata A. Adams, 1854',1,'Cerithidea balteata','Cerithidea balteata','Cerithidea balteat',2,0,'','','A. Adams','efe248e0-2a51-5a19-b1b7-18ce7fc51969','Cerithidea balteata A. Adams, 1854','A. Adams, 1854','UNRANKED','','Cerithidea','','balteata','','','',NULL,'','','','','','A. Adams','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02930','','','Melania balteata Reeve, 1860',1,'Melania balteata','Melania balteata','Melania balteat',2,0,'','','Reeve','1ff08bb4-14e5-523f-8c26-65999a3bb119','Melania balteata Reeve, 1860','Reeve, 1860','UNRANKED','','Melania','','balteata','','','',NULL,'','','','','','Reeve','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02933','','','Natica melanostoma balteata Philippi, 1852',1,'Natica melanostoma balteata','Natica melanostoma balteata','Natica melanostom balteat',3,0,'','','Philippi','f543caac-027f-54cd-8b22-712abd843de3','Natica melanostoma balteata Philippi, 1852','Philippi, 1852','UNRANKED','','Natica','','melanostoma','balteata','','',NULL,'','','','','','Philippi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02936','','','Rissoa (Cingula) balteata Manzoni, 1868',1,'Rissoa balteata','Rissoa balteata','Rissoa balteat',2,0,'','','Manzoni','c50bea7b-864f-584a-b173-1255b63cc085','Rissoa (Cingula) balteata Manzoni, 1868','Manzoni, 1868','UNRANKED','','Rissoa','Cingula','balteata','','','',NULL,'','','','','','Manzoni','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02940','','','Anodon bambousearum Morelet, 1851',1,'Anodon bambousearum','Anodon bambousearum','Anodon bambousear',2,0,'','','Morelet','3a4dcc36-ad37-5763-8b17-8522f33fecc6','Anodon bambousearum Morelet, 1851','Morelet, 1851','UNRANKED','','Anodon','','bambousearum','','','',NULL,'','','','','','Morelet','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02944','','','Cyclophorus bankanus Martens, 1867',1,'Cyclophorus bankanus','Cyclophorus bankanus','Cyclophorus bankan',2,0,'','','Martens','8cb20d78-45be-5e48-aaaf-4b58848d5fa0','Cyclophorus bankanus Martens, 1867','Martens, 1867','UNRANKED','','Cyclophorus','','bankanus','','','',NULL,'','','','','','Martens','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02949','','','Cardium banneianum Thurmann, in Thurmann and Etallon, 1862',2,'Cardium banneianum','Cardium banneianum','Cardium banneian',2,0,'','','Thurmann|Etallon','14b56396-c116-509c-8012-371193baa2e7','Cardium banneianum Thurmann, in Thurmann and Etallon, 1862','Thurmann, in Thurmann and Etallon, 1862','UNRANKED','','Cardium','','banneianum','','','',NULL,'','','','','','Thurmann','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02956','','','Sphaerium barbadense Prime, 1861',1,'Sphaerium barbadense','Sphaerium barbadense','Sphaerium barbadens',2,0,'','','Prime','78b31f45-5f8b-555a-9583-e15aba676ccc','Sphaerium barbadense Prime, 1861','Prime, 1861','UNRANKED','','Sphaerium','','barbadense','','','',NULL,'','','','','','Prime','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02960','','','Truncatella barbadensis Pfeiffer, 1856',1,'Truncatella barbadensis','Truncatella barbadensis','Truncatella barbadens',2,0,'','','Pfeiffer','ac91de23-710d-534c-a780-90127deeed4d','Truncatella barbadensis Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Truncatella','','barbadensis','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02964','','','Fusus barbarensis Trask, 1855',1,'Fusus barbarensis','Fusus barbarensis','Fusus barbarens',2,0,'','','Trask','3677b606-1ec7-5b73-8252-8da534be6e3f','Fusus barbarensis Trask, 1855','Trask, 1855','UNRANKED','','Fusus','','barbarensis','','','',NULL,'','','','','','Trask','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02966','','','Avicula barbata Reeve, 1857',1,'Avicula barbata','Avicula barbata','Avicula barbat',2,0,'','','Reeve','df1d6778-73cb-52ef-bad6-f455b9a13de8','Avicula barbata Reeve, 1857','Reeve, 1857','UNRANKED','','Avicula','','barbata','','','',NULL,'','','','','','Reeve','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02973','','','Lithodomus barbatus Reeve, 1858',1,'Lithodomus barbatus','Lithodomus barbatus','Lithodomus barbat',2,0,'','','Reeve','8b58d641-43d2-5255-843f-0abef2603d8f','Lithodomus barbatus Reeve, 1858','Reeve, 1858','UNRANKED','','Lithodomus','','barbatus','','','',NULL,'','','','','','Reeve','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02974','','','Spondylus barbatus Reeve, 1856',1,'Spondylus barbatus','Spondylus barbatus','Spondylus barbat',2,0,'','','Reeve','b7435816-981b-5efc-a46b-42ce2ff36e15','Spondylus barbatus Reeve, 1856','Reeve, 1856','UNRANKED','','Spondylus','','barbatus','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02979','','','Achatina barbigera Morelet, 1866',1,'Achatina barbigera','Achatina barbigera','Achatina barbiger',2,0,'','','Morelet','cae481c4-fe16-5664-8dd1-732af10992df','Achatina barbigera Morelet, 1866','Morelet, 1866','UNRANKED','','Achatina','','barbigera','','','',NULL,'','','','','','Morelet','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02982','','','Helix barbozae Paiva, 1866',1,'Helix barbozae','Helix barbozae','Helix barboz',2,0,'','','Paiva','fbda1ae3-d5f3-5737-9d85-834f449e1525','Helix barbozae Paiva, 1866','Paiva, 1866','UNRANKED','','Helix','','barbozae','','','',NULL,'','','','','','Paiva','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02987','','','Gibbus (Gibbulina) barclayi H. Adams, 1868',1,'Gibbus barclayi','Gibbus barclayi','Gibbus barclay',2,0,'','','H. Adams','7b9ef11c-31d2-53b9-996e-7ee4715e1b8a','Gibbus (Gibbulina) barclayi H. Adams, 1868','H. Adams, 1868','UNRANKED','','Gibbus','Gibbulina','barclayi','','','',NULL,'','','','','','H. Adams','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02990','','','Murex barclayi Reeve, 1857',1,'Murex barclayi','Murex barclayi','Murex barclay',2,0,'','','Reeve','0c53ffb3-2e46-5936-b3ec-752fa4dc5531','Murex barclayi Reeve, 1857','Reeve, 1857','UNRANKED','','Murex','','barclayi','','','',NULL,'','','','','','Reeve','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02993','','','Clausilia bargesi Bourguignat, 1868',1,'Clausilia bargesi','Clausilia bargesi','Clausilia barges',2,0,'','','Bourguignat','ac754cc0-c451-5297-8c50-7dd3139e69db','Clausilia bargesi Bourguignat, 1868','Bourguignat, 1868','UNRANKED','','Clausilia','','bargesi','','','',NULL,'','','','','','Bourguignat','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_02998','','','Avicula barklyi C. Moore, 1870',1,'Avicula barklyi','Avicula barklyi','Avicula barkly',2,0,'','','C. Moore','b5fbf7fe-6b4f-5254-84d1-35d844d1991e','Avicula barklyi C. Moore, 1870','C. Moore, 1870','UNRANKED','','Avicula','','barklyi','','','',NULL,'','','','','','C. Moore','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03003','','','Dentalium barquense Winchell, 1862',1,'Dentalium barquense','Dentalium barquense','Dentalium barquens',2,0,'','','Winchell','26dcf59e-1b83-53f1-94e8-80f29bcb9dea','Dentalium barquense Winchell, 1862','Winchell, 1862','UNRANKED','','Dentalium','','barquense','','','',NULL,'','','','','','Winchell','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03006','','','Nerinea barrandeana Piette, 1855',1,'Nerinea barrandeana','Nerinea barrandeana','Nerinea barrandean',2,0,'','','Piette','36a01b47-f25b-5f32-88a7-0f4cab3a7d98','Nerinea barrandeana Piette, 1855','Piette, 1855','UNRANKED','','Nerinea','','barrandeana','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03009','','','Cerithium barrandei Archiac, 1854',1,'Cerithium barrandei','Cerithium barrandei','Cerithium barrande',2,0,'','','Archiac','ca26ee5c-e6b1-51e2-909e-a5c92509ee77','Cerithium barrandei Archiac, 1854','Archiac, 1854','UNRANKED','','Cerithium','','barrandei','','','',NULL,'','','','','','Archiac','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03016','','','Helix barrandii Deshayes, 1863',1,'Helix barrandii','Helix barrandii','Helix barrand',2,0,'','','Deshayes','6b2335b3-02a5-5630-821b-ea146da948d5','Helix barrandii Deshayes, 1863','Deshayes, 1863','UNRANKED','','Helix','','barrandii','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03021','','','Corbula barrattiana C.B. Adams, 1852',1,'Corbula barrattiana','Corbula barrattiana','Corbula barrattian',2,0,'','','C. B. Adams','d6ac02b8-ba1a-58c0-9a0f-12fa39876bf8','Corbula barrattiana C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Corbula','','barrattiana','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03031','','','Pecten barrettii Seeley, 1861',1,'Pecten barrettii','Pecten barrettii','Pecten barrett',2,0,'','','Seeley','0291f27c-a941-5d28-abe9-d342505a2b68','Pecten barrettii Seeley, 1861','Seeley, 1861','UNRANKED','','Pecten','','barrettii','','','',NULL,'','','','','','Seeley','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03036','','','Petitia (Lewisia) barroniana Chitty, 1857',1,'Petitia barroniana','Petitia barroniana','Petitia barronian',2,0,'','','Chitty','cf40f957-aed9-5bdb-be39-60669b5cbbc1','Petitia (Lewisia) barroniana Chitty, 1857','Chitty, 1857','UNRANKED','','Petitia','Lewisia','barroniana','','','',NULL,'','','','','','Chitty','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03038','','','Pomatias barthelemianum Shuttleworth, 1852',1,'Pomatias barthelemianum','Pomatias barthelemianum','Pomatias barthelemian',2,0,'','','Shuttleworth','bb20a994-3c15-5aa6-be5f-f0d3a6264a9b','Pomatias barthelemianum Shuttleworth, 1852','Shuttleworth, 1852','UNRANKED','','Pomatias','','barthelemianum','','','',NULL,'','','','','','Shuttleworth','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03043','','','Aperostoma bartletti H. Adams, 1870',1,'Aperostoma bartletti','Aperostoma bartletti','Aperostoma bartlett',2,0,'','','H. Adams','9e783582-78c8-5964-b20d-3f6cac8410be','Aperostoma bartletti H. Adams, 1870','H. Adams, 1870','UNRANKED','','Aperostoma','','bartletti','','','',NULL,'','','','','','H. Adams','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03047','','','Modiola bartonensis Wood, 1864',1,'Modiola bartonensis','Modiola bartonensis','Modiola bartonens',2,0,'','','Wood','ac587b81-9235-5405-bec1-9923bd2e1897','Modiola bartonensis Wood, 1864','Wood, 1864','UNRANKED','','Modiola','','bartonensis','','','',NULL,'','','','','','Wood','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03052','','','Cyclostoma basicarinatum Pfeiffer, 1855',1,'Cyclostoma basicarinatum','Cyclostoma basicarinatum','Cyclostoma basicarinat',2,0,'','','Pfeiffer','a2f55d17-8ab9-593c-96c6-1a3c6d38797c','Cyclostoma basicarinatum Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Cyclostoma','','basicarinatum','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03057','','','Spondylus basilicus Reeve, 1856',1,'Spondylus basilicus','Spondylus basilicus','Spondylus basilic',2,0,'','','Reeve','eab623ae-a77a-5d61-8859-296d567b5aa1','Spondylus basilicus Reeve, 1856','Reeve, 1856','UNRANKED','','Spondylus','','basilicus','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03060','','','Nanina basseinensis W. Blanford, 1865',1,'Nanina basseinensis','Nanina basseinensis','Nanina basseinens',2,0,'','','W. Blanford','56c23cf5-77f7-5cdc-a706-a81e2be1a907','Nanina basseinensis W. Blanford, 1865','W. Blanford, 1865','UNRANKED','','Nanina','','basseinensis','','','',NULL,'','','','','','W. Blanford','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03068','','','Rissoina basteroti Schwartz von Mohrenstern, 1860',1,'Rissoina basteroti','Rissoina basteroti','Rissoina basterot',2,0,'','','Schwartz von Mohrenstern','2d90f3f0-75f3-54a7-9b30-c911362d852c','Rissoina basteroti Schwartz von Mohrenstern, 1860','Schwartz von Mohrenstern, 1860','UNRANKED','','Rissoina','','basteroti','','','',NULL,'','','','','','Schwartz von Mohrenstern','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03075','','','Helix batchianensis Pfeiffer, 1861',1,'Helix batchianensis','Helix batchianensis','Helix batchianens',2,0,'','','Pfeiffer','9d27e552-6903-51c5-b7d5-61d348b93b47','Helix batchianensis Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Helix','','batchianensis','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03079','','','Helix bathiomphala Charpentier, in Tiberi, 1869',2,'Helix bathiomphala','Helix bathiomphala','Helix bathiomphal',2,0,'','','Charpentier|Tiberi','af8ff2ba-bf48-5904-96e6-e05ddd561cde','Helix bathiomphala Charpentier, in Tiberi, 1869','Charpentier, in Tiberi, 1869','UNRANKED','','Helix','','bathiomphala','','','',NULL,'','','','','','Charpentier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03083','','','Corbis (Corbicella) bathonica Morris and Lycett, 1853',1,'Corbis bathonica','Corbis bathonica','Corbis bathonic',2,0,'','','Morris|Lycett','6914bc4a-3624-50fe-a01a-3a2c92736180','Corbis (Corbicella) bathonica Morris and Lycett, 1853','Morris and Lycett, 1853','UNRANKED','','Corbis','Corbicella','bathonica','','','',NULL,'','','','','','Morris & Lycett','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03086','','','Panopea bathonica Cotteau, 1855',1,'Panopea bathonica','Panopea bathonica','Panopea bathonic',2,0,'','','Cotteau','53f24a03-1e6c-5508-bc17-65b9f0936466','Panopea bathonica Cotteau, 1855','Cotteau, 1855','UNRANKED','','Panopea','','bathonica','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03090','','','Acteon bathonicum Lycett, 1863',1,'Acteon bathonicum','Acteon bathonicum','Acteon bathonic',2,0,'','','Lycett','ce37bc7c-dfb9-5eec-9ada-d3919ef2d30f','Acteon bathonicum Lycett, 1863','Lycett, 1863','UNRANKED','','Acteon','','bathonicum','','','',NULL,'','','','','','Lycett','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03095','','','Cyclotus batjanensis Martens, 1867',1,'Cyclotus batjanensis','Cyclotus batjanensis','Cyclotus batianens',2,0,'','','Martens','2553374f-5262-5066-9e13-861a28fdf7e6','Cyclotus batjanensis Martens, 1867','Martens, 1867','UNRANKED','','Cyclotus','','batjanensis','','','',NULL,'','','','','','Martens','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03100','','','Clausilia baudoni Michaud, 1862',1,'Clausilia baudoni','Clausilia baudoni','Clausilia baudon',2,0,'','','Michaud','8352e3db-e7df-52d0-9edf-b160a407570b','Clausilia baudoni Michaud, 1862','Michaud, 1862','UNRANKED','','Clausilia','','baudoni','','','',NULL,'','','','','','Michaud','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03104','','','Lucina baudoni Deshayes, 1857',1,'Lucina baudoni','Lucina baudoni','Lucina baudon',2,0,'','','Deshayes','b8def891-89ff-5560-bbc7-5a7091d23cb4','Lucina baudoni Deshayes, 1857','Deshayes, 1857','UNRANKED','','Lucina','','baudoni','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03109','','','Poromya baudoni Deshayes, 1857',1,'Poromya baudoni','Poromya baudoni','Poromya baudon',2,0,'','','Deshayes','d2aa3a17-9312-5406-b33c-7e078169508e','Poromya baudoni Deshayes, 1857','Deshayes, 1857','UNRANKED','','Poromya','','baudoni','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03114','','','Turbo baudoni Deshayes, 1863',1,'Turbo baudoni','Turbo baudoni','Turbo baudon',2,0,'','','Deshayes','12db5571-9824-563e-85bb-5e6a34e8282a','Turbo baudoni Deshayes, 1863','Deshayes, 1863','UNRANKED','','Turbo','','baudoni','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03118','','','Avellana baudoniana Cotteau, 1854',1,'Avellana baudoniana','Avellana baudoniana','Avellana baudonian',2,0,'','','Cotteau','4ebcdbea-e22b-5ea9-8fb9-8286c2f1fbc8','Avellana baudoniana Cotteau, 1854','Cotteau, 1854','UNRANKED','','Avellana','','baudoniana','','','',NULL,'','','','','','Cotteau','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03120','','','Panopea baudoniana Cotteau, 1855',1,'Panopea baudoniana','Panopea baudoniana','Panopea baudonian',2,0,'','','Cotteau','35b4053b-b028-5e08-a706-076f938ea5cc','Panopea baudoniana Cotteau, 1855','Cotteau, 1855','UNRANKED','','Panopea','','baudoniana','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03132','','','Cardium bavaricum Deshayes, 1853',1,'Cardium bavaricum','Cardium bavaricum','Cardium bauaric',2,0,'','','Deshayes','110b8b0a-38a7-56e3-a295-1bca4da9efef','Cardium bavaricum Deshayes, 1853','Deshayes, 1853','UNRANKED','','Cardium','','bavaricum','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03138','','','Helix bayamensis Pfeiffer, 1854',1,'Helix bayamensis','Helix bayamensis','Helix bayamens',2,0,'','','Pfeiffer','00c1ef46-dfe2-5638-bc07-b5ab2320beb2','Helix bayamensis Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Helix','','bayamensis','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03144','','','Bulla baylei Archiac, 1854',1,'Bulla baylei','Bulla baylei','Bulla bayle',2,0,'','','Archiac','1853c129-aef3-59b3-aee7-93a840b3ec20','Bulla baylei Archiac, 1854','Archiac, 1854','UNRANKED','','Bulla','','baylei','','','',NULL,'','','','','','Archiac','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03150','','','Lavignon baylei Coquand, 1862',1,'Lavignon baylei','Lavignon baylei','Lavignon bayle',2,0,'','','Coquand','2c8dc0ec-c912-56c5-b100-d217529eb037','Lavignon baylei Coquand, 1862','Coquand, 1862','UNRANKED','','Lavignon','','baylei','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03156','','','Trigonia baylei Dollfus, 1862',1,'Trigonia baylei','Trigonia baylei','Trigonia bayle',2,0,'','','Dollfus','f7f1cbef-cb4f-56ce-8091-b6f2993d7767','Trigonia baylei Dollfus, 1862','Dollfus, 1862','UNRANKED','','Trigonia','','baylei','','','',NULL,'','','','','','Dollfus','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03165','','','Unio beadleianus Lea, 1861',1,'Unio beadleianus','Unio beadleianus','Unio beadleian',2,0,'','','Lea','9af947f4-d78b-597e-b4c0-81c43a850c4c','Unio beadleianus Lea, 1861','Lea, 1861','UNRANKED','','Unio','','beadleianus','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03168','','','Ancylus beani Bourguignat, 1853',1,'Ancylus beani','Ancylus beani','Ancylus bean',2,0,'','','Bourguignat','8d76ae39-54ca-5e14-a905-c821623b76b7','Ancylus beani Bourguignat, 1853','Bourguignat, 1853','UNRANKED','','Ancylus','','beani','','','',NULL,'','','','','','Bourguignat','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03174','','','Myacites beanii Morris and Lycett, 1853',1,'Myacites beanii','Myacites beanii','Myacites bean',2,0,'','','Morris|Lycett','e6734aa9-cdd2-528e-98ff-1bc0186548d7','Myacites beanii Morris and Lycett, 1853','Morris and Lycett, 1853','UNRANKED','','Myacites','','beanii','','','',NULL,'','','','','','Morris & Lycett','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03181','','','Murex beauii Fischer and Bernardi, 1857',1,'Murex beauii','Murex beauii','Murex beau',2,0,'','','Fischer|Bernardi','54799e53-04c3-5cf9-b050-a2461d59db91','Murex beauii Fischer and Bernardi, 1857','Fischer and Bernardi, 1857','UNRANKED','','Murex','','beauii','','','',NULL,'','','','','','Fischer & Bernardi','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03186','','','Pholas beauiana Recluz, 1853',1,'Pholas beauiana','Pholas beauiana','Pholas beauian',2,0,'','','Recluz','a322eb56-abbf-587d-aff9-01c19bf13d2f','Pholas beauiana Recluz, 1853','Recluz, 1853','UNRANKED','','Pholas','','beauiana','','','',NULL,'','','','','','Recluz','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03189','','','Pachyrisma beaumonti Zejszner, 1862',1,'Pachyrisma beaumonti','Pachyrisma beaumonti','Pachyrisma beaumont',2,0,'','','Zejszner','e2030a21-cb88-542e-b137-7ffc732e0b18','Pachyrisma beaumonti Zejszner, 1862','Zejszner, 1862','UNRANKED','','Pachyrisma','','beaumonti','','','',NULL,'','','','','','Zejszner','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03192','','','Neritopsis beaumontina Buvignier, 1852',1,'Neritopsis beaumontina','Neritopsis beaumontina','Neritopsis beaumontin',2,0,'','','Buvignier','627cc4d5-25d0-5697-81ba-c3398a65c208','Neritopsis beaumontina Buvignier, 1852','Buvignier, 1852','UNRANKED','','Neritopsis','','beaumontina','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03197','','','Helix becasis Rambur, 1868',1,'Helix becasis','Helix becasis','Helix becas',2,0,'','','Rambur','57a9d3cf-092b-5f79-b16e-6932e1fbc008','Helix becasis Rambur, 1868','Rambur, 1868','UNRANKED','','Helix','','becasis','','','',NULL,'','','','','','Rambur','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03199','','','Liocyma beckii Dall, 1870',1,'Liocyma beckii','Liocyma beckii','Liocyma beck',2,0,'','','Dall','2852ad88-2f4d-581c-866b-db3089aa71c5','Liocyma beckii Dall, 1870','Dall, 1870','UNRANKED','','Liocyma','','beckii','','','',NULL,'','','','','','Dall','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03203','','','Spiraculum beddomei W. Blanford, 1866',1,'Spiraculum beddomei','Spiraculum beddomei','Spiraculum beddome',2,0,'','','W. Blanford','99425f98-8ad6-5141-b90a-a0a66866f663','Spiraculum beddomei W. Blanford, 1866','W. Blanford, 1866','UNRANKED','','Spiraculum','','beddomei','','','',NULL,'','','','','','W. Blanford','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03207','','','Helicina behniana Pfeiffer, 1859',1,'Helicina behniana','Helicina behniana','Helicina behnian',2,0,'','','Pfeiffer','0c8fe1d9-a15a-5891-9984-1b6b1c4b689e','Helicina behniana Pfeiffer, 1859','Pfeiffer, 1859','UNRANKED','','Helicina','','behniana','','','',NULL,'','','','','','Pfeiffer','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03212','','','Mytilus beirensis Sharpe, 1850',1,'Mytilus beirensis','Mytilus beirensis','Mytilus beirens',2,0,'','','Sharpe','7ae2a810-b4c5-58e3-9eba-3b83fbc32a9e','Mytilus beirensis Sharpe, 1850','Sharpe, 1850','UNRANKED','','Mytilus','','beirensis','','','',NULL,'','','','','','Sharpe','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03218','','','Cyclostoma belairi Petit, 1853',1,'Cyclostoma belairi','Cyclostoma belairi','Cyclostoma belair',2,0,'','','Petit','499f5866-7b56-55f2-bf7a-187784760a55','Cyclostoma belairi Petit, 1853','Petit, 1853','UNRANKED','','Cyclostoma','','belairi','','','',NULL,'','','','','','Petit','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03220','','','Bulimus belcheri Pfeiffer, 1851',1,'Bulimus belcheri','Bulimus belcheri','Bulimus belcher',2,0,'','','Pfeiffer','7f97815e-60df-5f14-8e43-e626775dc7e4','Bulimus belcheri Pfeiffer, 1851','Pfeiffer, 1851','UNRANKED','','Bulimus','','belcheri','','','',NULL,'','','','','','Pfeiffer','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03226','','','Terebra belcheri Philippi, 1851',1,'Terebra belcheri','Terebra belcheri','Terebra belcher',2,0,'','','Philippi','532407d5-3c50-5986-894b-0f3c282f5178','Terebra belcheri Philippi, 1851','Philippi, 1851','UNRANKED','','Terebra','','belcheri','','','',NULL,'','','','','','Philippi','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03231','','','Unio batavus belgicus Colbeau, 1859',1,'Unio batavus belgicus','Unio batavus belgicus','Unio batau belgic',3,0,'','','Colbeau','190f10bd-c69f-5fbb-8867-acb9a5f0b0dc','Unio batavus belgicus Colbeau, 1859','Colbeau, 1859','UNRANKED','','Unio','','batavus','belgicus','','',NULL,'','','','','','Colbeau','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03233','','','Lithodomus belgrandianus Cotteau, 1855',1,'Lithodomus belgrandianus','Lithodomus belgrandianus','Lithodomus belgrandian',2,0,'','','Cotteau','421e311f-271f-5072-8997-34dac039d010','Lithodomus belgrandianus Cotteau, 1855','Cotteau, 1855','UNRANKED','','Lithodomus','','belgrandianus','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03240','','','Daphnella bella Pease, 1860',1,'Daphnella bella','Daphnella bella','Daphnella bell',2,0,'','','Pease','18924bbd-82bf-5e36-bc5d-0b2367ab97ed','Daphnella bella Pease, 1860','Pease, 1860','UNRANKED','','Daphnella','','bella','','','',NULL,'','','','','','Pease','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03242','','','Drillia bella Conrad, 1862',1,'Drillia bella','Drillia bella','Drillia bell',2,0,'','','Conrad','0113bdc5-7275-5834-8c83-a335e369a409','Drillia bella Conrad, 1862','Conrad, 1862','UNRANKED','','Drillia','','bella','','','',NULL,'','','','','','Conrad','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03245','','','Janira bella Conrad, 1856',1,'Janira bella','Janira bella','Janira bell',2,0,'','','Conrad','bf0293a9-bc2d-560c-9e96-4debb0ddee65','Janira bella Conrad, 1856','Conrad, 1856','UNRANKED','','Janira','','bella','','','',NULL,'','','','','','Conrad','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03252','','','Rapana bella Nevill in Nevill and Nevill, 1869',2,'Rapana bella','Rapana bella','Rapana bell',2,0,'','','Nevill','e08488d8-fadc-5ccf-ac20-e69e47b1f514','Rapana bella Nevill in Nevill and Nevill, 1869','Nevill in Nevill and Nevill, 1869','UNRANKED','','Rapana','','bella','','','',NULL,'','','','','','Nevill','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03259','','','Neritina belladonna Parreyss, in Mousson, 1854',2,'Neritina belladonna','Neritina belladonna','Neritina belladonn',2,0,'','','Parreyss|Mousson','bfb69ced-96c5-5faf-a956-5f305bfb4969','Neritina belladonna Parreyss, in Mousson, 1854','Parreyss, in Mousson, 1854','UNRANKED','','Neritina','','belladonna','','','',NULL,'','','','','','Parreyss','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03266','','','Columbella bellardii Hörnes, 1852',1,'Columbella bellardii','Columbella bellardii','Columbella bellard',2,0,'','','Hörnes','a8c04b99-a879-566a-b726-65fbd4fe911b','Columbella bellardii Hörnes, 1852','Hörnes, 1852','UNRANKED','','Columbella','','bellardii','','','',NULL,'','','','','','Hörnes','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03272','','','Pecten bellardii Mayer, 1869',1,'Pecten bellardii','Pecten bellardii','Pecten bellard',2,0,'','','Mayer','88b20401-acf1-5cb0-9759-e9365d544889','Pecten bellardii Mayer, 1869','Mayer, 1869','UNRANKED','','Pecten','','bellardii','','','',NULL,'','','','','','Mayer','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03278','','','Marginella bellardiana J. Semper, 1861',1,'Marginella bellardiana','Marginella bellardiana','Marginella bellardian',2,0,'','','J. Semper','57e4971f-1365-50a9-87ba-2687eb60f8b6','Marginella bellardiana J. Semper, 1861','J. Semper, 1861','UNRANKED','','Marginella','','bellardiana','','','',NULL,'','','','','','J. Semper','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03283','','','Acteonina bellayana Farge, 1862',1,'Acteonina bellayana','Acteonina bellayana','Acteonina bellayan',2,0,'','','Farge','f323ebea-7e3f-5185-b837-1e212763fbb2','Acteonina bellayana Farge, 1862','Farge, 1862','UNRANKED','','Acteonina','','bellayana','','','',NULL,'','','','','','Farge','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03290','','','Leda bellistriata Stevens, 1858',1,'Leda bellistriata','Leda bellistriata','Leda bellistriat',2,0,'','','Stevens','63c94b08-8cac-5077-9091-23797edd8556','Leda bellistriata Stevens, 1858','Stevens, 1858','UNRANKED','','Leda','','bellistriata','','','',NULL,'','','','','','Stevens','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03293','','','Clausilia belloti P. Strobel, 1854',1,'Clausilia belloti','Clausilia belloti','Clausilia bellot',2,0,'','','P. Strobel','57d67fb8-617b-56d1-ba2c-f5b924ddb693','Clausilia belloti P. Strobel, 1854','P. Strobel, 1854','UNRANKED','','Clausilia','','belloti','','','',NULL,'','','','','','P. Strobel','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03300','','','Crassatella bellula A. Adams, 1852',1,'Crassatella bellula','Crassatella bellula','Crassatella bellul',2,0,'','','A. Adams','78022dd7-1c93-5d9f-9d32-3653af1011ee','Crassatella bellula A. Adams, 1852','A. Adams, 1852','UNRANKED','','Crassatella','','bellula','','','',NULL,'','','','','','A. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03304','','','Helicina bellula Gundlach, in Pfeiffer, 1859',2,'Helicina bellula','Helicina bellula','Helicina bellul',2,0,'','','Gundlach|Pfeiffer','e87d9ceb-0006-58ea-aecd-47598ee77e15','Helicina bellula Gundlach, in Pfeiffer, 1859','Gundlach, in Pfeiffer, 1859','UNRANKED','','Helicina','','bellula','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03309','','','Melania bellula Lea, 1861',1,'Melania bellula','Melania bellula','Melania bellul',2,0,'','','Lea','7900c0cc-c350-5fb4-83a7-5e8a6ba76992','Melania bellula Lea, 1861','Lea, 1861','UNRANKED','','Melania','','bellula','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03313','','','Parthenia bellula A. Adams, 1860',1,'Parthenia bellula','Parthenia bellula','Parthenia bellul',2,0,'','','A. Adams','b8a5fa88-62f4-5616-90bb-25b6f5af354f','Parthenia bellula A. Adams, 1860','A. Adams, 1860','UNRANKED','','Parthenia','','bellula','','','',NULL,'','','','','','A. Adams','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03318','','','Spondylus bellulus Loriol, 1868',1,'Spondylus bellulus','Spondylus bellulus','Spondylus bellul',2,0,'','','Loriol','d0205070-ac14-5a88-91ab-fa240a7fcf53','Spondylus bellulus Loriol, 1868','Loriol, 1868','UNRANKED','','Spondylus','','bellulus','','','',NULL,'','','','','','Loriol','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03321','','','Fusus bellus C.B. Adams, 1852',1,'Fusus bellus','Fusus bellus','Fusus bell',2,0,'','','C. B. Adams','1ce080c8-e79d-5b5b-b02c-0a89dd691d68','Fusus bellus C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Fusus','','bellus','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03329','','','Helix bembicodes Pfeiffer, 1851',1,'Helix bembicodes','Helix bembicodes','Helix bembicod',2,0,'','','Pfeiffer','ea85ebc7-cef9-518f-970a-32c250edb19d','Helix bembicodes Pfeiffer, 1851','Pfeiffer, 1851','UNRANKED','','Helix','','bembicodes','','','',NULL,'','','','','','Pfeiffer','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03333','','','Voluta benedeni J. Müller, 1851',1,'Voluta benedeni','Voluta benedeni','Voluta beneden',2,0,'','','J. Müller','60db6541-a52e-5879-8fe3-143790067192','Voluta benedeni J. Müller, 1851','J. Müller, 1851','UNRANKED','','Voluta','','benedeni','','','',NULL,'','','','','','J. Müller','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03341','','','Helicina benigna Crosse, 1870',1,'Helicina benigna','Helicina benigna','Helicina benign',2,0,'','','Crosse','79f64ec5-d543-5358-900c-7dd26eb59ad6','Helicina benigna Crosse, 1870','Crosse, 1870','UNRANKED','','Helicina','','benigna','','','',NULL,'','','','','','Crosse','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03346','','','Murex benoiti Tiberi, 1855',1,'Murex benoiti','Murex benoiti','Murex benoit',2,0,'','','Tiberi','b5bb6488-af4b-5972-bf1f-93e9479a293b','Murex benoiti Tiberi, 1855','Tiberi, 1855','UNRANKED','','Murex','','benoiti','','','',NULL,'','','','','','Tiberi','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03350','','','Ancylus benoitianus Bourguignat, 1862',1,'Ancylus benoitianus','Ancylus benoitianus','Ancylus benoitian',2,0,'','','Bourguignat','4793c96f-944a-55eb-99c3-ea927a172f22','Ancylus benoitianus Bourguignat, 1862','Bourguignat, 1862','UNRANKED','','Ancylus','','benoitianus','','','',NULL,'','','','','','Bourguignat','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03358','','','Melania bensoni Philippi, 1851',1,'Melania bensoni','Melania bensoni','Melania benson',2,0,'','','Philippi','d5ad50a7-ebd9-5fc1-8923-ae8524b13687','Melania bensoni Philippi, 1851','Philippi, 1851','UNRANKED','','Melania','','bensoni','','','',NULL,'','','','','','Philippi','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03362','','','Tomichia bensoni A. Adams, 1861',1,'Tomichia bensoni','Tomichia bensoni','Tomichia benson',2,0,'','','A. Adams','be040637-b074-5ec4-af82-424d6a601588','Tomichia bensoni A. Adams, 1861','A. Adams, 1861','UNRANKED','','Tomichia','','bensoni','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03371','','','Helix berbniggeriana Letourneux, 1870',1,'Helix berbniggeriana','Helix berbniggeriana','Helix berbniggerian',2,0,'','','Letourneux','c0ea523b-72e0-541e-8076-4f1d1383d514','Helix berbniggeriana Letourneux, 1870','Letourneux, 1870','UNRANKED','','Helix','','berbniggeriana','','','',NULL,'','','','','','Letourneux','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03374','','','Cyclotus berendti Pfeiffer, 1861',1,'Cyclotus berendti','Cyclotus berendti','Cyclotus berendt',2,0,'','','Pfeiffer','b032a049-5fac-5f54-adb7-2281cc56eed0','Cyclotus berendti Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Cyclotus','','berendti','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03382','','','Spiraxis berendti Pfeiffer, 1862',1,'Spiraxis berendti','Spiraxis berendti','Spiraxis berendt',2,0,'','','Pfeiffer','899e4309-aa85-517e-a706-6ca7c0a46b34','Spiraxis berendti Pfeiffer, 1862','Pfeiffer, 1862','UNRANKED','','Spiraxis','','berendti','','','',NULL,'','','','','','Pfeiffer','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03385','','','Helix berkeleii R. Lowe, 1861',1,'Helix berkeleii','Helix berkeleii','Helix berkele',2,0,'','','R. Lowe','e2939b69-e20d-5051-b221-2496fa541fb8','Helix berkeleii R. Lowe, 1861','R. Lowe, 1861','UNRANKED','','Helix','','berkeleii','','','',NULL,'','','','','','R. Lowe','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03391','','','Terebra bermonti Lorois, 1857',1,'Terebra bermonti','Terebra bermonti','Terebra bermont',2,0,'','','Lorois','ef2ef406-e09f-51d1-9b1b-4cf53cad7ecf','Terebra bermonti Lorois, 1857','Lorois, 1857','UNRANKED','','Terebra','','bermonti','','','',NULL,'','','','','','Lorois','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03397','','','Cancellaria bernardii Mayer, 1861',1,'Cancellaria bernardii','Cancellaria bernardii','Cancellaria bernard',2,0,'','','Mayer','a3788988-eb0c-5b26-aa50-d9333e76debb','Cancellaria bernardii Mayer, 1861','Mayer, 1861','UNRANKED','','Cancellaria','','bernardii','','','',NULL,'','','','','','Mayer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03404','','','Pterocyclos bernardii Pfeiffer, in Reeve, 1863',2,'Pterocyclos bernardii','Pterocyclos bernardii','Pterocyclos bernard',2,0,'','','Pfeiffer|Reeve','624d784c-1903-5b2e-88df-92bc4ab88887','Pterocyclos bernardii Pfeiffer, in Reeve, 1863','Pfeiffer, in Reeve, 1863','UNRANKED','','Pterocyclos','','bernardii','','','',NULL,'','','','','','Pfeiffer','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03413','','','Arca bernayi Deshayes, 1858',1,'Arca bernayi','Arca bernayi','Arca bernay',2,0,'','','Deshayes','3b34998f-4ff7-58f5-a204-ffbdec69c823','Arca bernayi Deshayes, 1858','Deshayes, 1858','UNRANKED','','Arca','','bernayi','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03416','','','Murex bernayi Deshayes, 1865',1,'Murex bernayi','Murex bernayi','Murex bernay',2,0,'','','Deshayes','5cd19388-5b2a-53bb-8cd3-24b166502bc9','Murex bernayi Deshayes, 1865','Deshayes, 1865','UNRANKED','','Murex','','bernayi','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03422','','','Alaria bernouilensis Loriol, in Loriol and Cotteau, 1867',2,'Alaria bernouilensis','Alaria bernouilensis','Alaria bernouilens',2,0,'','','Loriol|Cotteau','a0886d79-98b3-5008-a8dc-83446ba39290','Alaria bernouilensis Loriol, in Loriol and Cotteau, 1867','Loriol, in Loriol and Cotteau, 1867','UNRANKED','','Alaria','','bernouilensis','','','',NULL,'','','','','','Loriol','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03424','','','Helix loxotropis bernsteinii Martens, 1867',1,'Helix loxotropis bernsteinii','Helix loxotropis bernsteinii','Helix loxotrop bernstein',3,0,'','','Martens','335b447f-720d-518d-b8ca-f330514f34e1','Helix loxotropis bernsteinii Martens, 1867','Martens, 1867','UNRANKED','','Helix','','loxotropis','bernsteinii','','',NULL,'','','','','','Martens','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03428','','','Pleurotomaria bertheloti Orbigny, 1853',1,'Pleurotomaria bertheloti','Pleurotomaria bertheloti','Pleurotomaria berthelot',2,0,'','','Orbigny','fe215fb1-fea3-59a6-a3d2-b17334de1fc9','Pleurotomaria bertheloti Orbigny, 1853','Orbigny, 1853','UNRANKED','','Pleurotomaria','','bertheloti','','','',NULL,'','','','','','Orbigny','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03432','','','Pterocera bervillei Piette, 1855',1,'Pterocera bervillei','Pterocera bervillei','Pterocera beruille',2,0,'','','Piette','e290f6a6-2709-5ef3-bb9d-e51a1e736f18','Pterocera bervillei Piette, 1855','Piette, 1855','UNRANKED','','Pterocera','','bervillei','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03437','','','Ferussacia berytensis Bourguignat, 1864',1,'Ferussacia berytensis','Ferussacia berytensis','Ferussacia berytens',2,0,'','','Bourguignat','44f4f4aa-36bf-5a26-84ae-2dedce4d62e0','Ferussacia berytensis Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Ferussacia','','berytensis','','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03438','','','Limax berytensis Bourguignat, 1852',1,'Limax berytensis','Limax berytensis','Limax berytens',2,0,'','','Bourguignat','a2d96124-3579-5ee2-afff-25b4f912c56a','Limax berytensis Bourguignat, 1852','Bourguignat, 1852','UNRANKED','','Limax','','berytensis','','','',NULL,'','','','','','Bourguignat','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03442','','','Pleurotomaria bessina Orbigny, 1854',1,'Pleurotomaria bessina','Pleurotomaria bessina','Pleurotomaria bessin',2,0,'','','Orbigny','b0e114b0-6bbd-5ee4-9e56-1590448ee2b7','Pleurotomaria bessina Orbigny, 1854','Orbigny, 1854','UNRANKED','','Pleurotomaria','','bessina','','','',NULL,'','','','','','Orbigny','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03446','','','Gervillia betacalcis Quenstedt, 1856',1,'Gervillia betacalcis','Gervillia betacalcis','Gervillia betacalc',2,0,'','','Quenstedt','2e63e03d-6509-5ab1-b501-ac3083fdcdc0','Gervillia betacalcis Quenstedt, 1856','Quenstedt, 1856','UNRANKED','','Gervillia','','betacalcis','','','',NULL,'','','','','','Quenstedt','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03450','','','Zonites beticus Bourguignat, 1864',1,'Zonites beticus','Zonites beticus','Zonites betic',2,0,'','','Bourguignat','6469cabc-31dd-5c12-a51f-ddd4572e951b','Zonites beticus Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Zonites','','beticus','','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03452','','','Natica beuqueui Coquand, 1862',1,'Natica beuqueui','Natica beuqueui','Natica beuqueu',2,0,'','','Coquand','9549a682-5a8c-55ed-991f-0302cbf13dc0','Natica beuqueui Coquand, 1862','Coquand, 1862','UNRANKED','','Natica','','beuqueui','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03457','','','Actaeonella beyrichii Dreschner, 1863',1,'Actaeonella beyrichii','Actaeonella beyrichii','Actaeonella beyrich',2,0,'','','Dreschner','124d60dd-4660-503f-a3b4-5aef88a85895','Actaeonella beyrichii Dreschner, 1863','Dreschner, 1863','UNRANKED','','Actaeonella','','beyrichii','','','',NULL,'','','','','','Dreschner','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03464','','','Cypraea beyrichii Koenen, 1867',1,'Cypraea beyrichii','Cypraea beyrichii','Cypraea beyrich',2,0,'','','Koenen','eb6ab9d7-4f88-59a4-9695-e95a828ce80a','Cypraea beyrichii Koenen, 1867','Koenen, 1867','UNRANKED','','Cypraea','','beyrichii','','','',NULL,'','','','','','Koenen','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03469','','','Pholadomya beyrichi U. Schlonbach, 1863',1,'Pholadomya beyrichi','Pholadomya beyrichi','Pholadomya beyrich',2,0,'','','U. Schlonbach','f7ff6716-df0a-5fb0-b353-d74c665ce0bb','Pholadomya beyrichi U. Schlonbach, 1863','U. Schlonbach, 1863','UNRANKED','','Pholadomya','','beyrichi','','','',NULL,'','','','','','U. Schlonbach','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03472','','','Tellina beyrichi Deshayes, 1857',1,'Tellina beyrichi','Tellina beyrichi','Tellina beyrich',2,0,'','','Deshayes','f681cea0-a228-55e3-ac16-4fb8a7ab3478','Tellina beyrichi Deshayes, 1857','Deshayes, 1857','UNRANKED','','Tellina','','beyrichi','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03477','','','Lucina bialata Bellardi, 1854',1,'Lucina bialata','Lucina bialata','Lucina bialat',2,0,'','','Bellardi','6c13a751-1e6e-5ac7-a663-f499b93d0019','Lucina bialata Bellardi, 1854','Bellardi, 1854','UNRANKED','','Lucina','','bialata','','','',NULL,'','','','','','Bellardi','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03483','','','Turritella biangularis Schafhäutl, 1863',1,'Turritella biangularis','Turritella biangularis','Turritella biangular',2,0,'','','Schafhäutl','b03561d9-f8d3-581f-afe1-ee960879e9f3','Turritella biangularis Schafhäutl, 1863','Schafhäutl, 1863','UNRANKED','','Turritella','','biangularis','','','',NULL,'','','','','','Schafhäutl','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03485','','','Corbula biangulata Deshayes, 1857',1,'Corbula biangulata','Corbula biangulata','Corbula biangulat',2,0,'','','Deshayes','f02fa157-ecd3-5d5f-8cf5-06bbfeb0a799','Corbula biangulata Deshayes, 1857','Deshayes, 1857','UNRANKED','','Corbula','','biangulata','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03492','','','Cyclostoma biangulatum Pease, 1864',1,'Cyclostoma biangulatum','Cyclostoma biangulatum','Cyclostoma biangulat',2,0,'','','Pease','9efa4b16-f34f-5d87-ac63-a2823f996ff0','Cyclostoma biangulatum Pease, 1864','Pease, 1864','UNRANKED','','Cyclostoma','','biangulatum','','','',NULL,'','','','','','Pease','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03494','','','Planorbis biangulatus F. Edwards, 1852',1,'Planorbis biangulatus','Planorbis biangulatus','Planorbis biangulat',2,0,'','','F. Edwards','a97e75b1-f46a-5a36-87b4-1224874e756b','Planorbis biangulatus F. Edwards, 1852','F. Edwards, 1852','UNRANKED','','Planorbis','','biangulatus','','','',NULL,'','','','','','F. Edwards','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03497','','','Argonauta biarmata Hecke, 1858',1,'Argonauta biarmata','Argonauta biarmata','Argonauta biarmat',2,0,'','','Hecke','9d4d8f5a-a500-5f6c-a43e-f5b7b8061b21','Argonauta biarmata Hecke, 1858','Hecke, 1858','UNRANKED','','Argonauta','','biarmata','','','',NULL,'','','','','','Hecke','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03502','','','Carychium minimum bicanaliculatum Cessac, 1857',1,'Carychium minimum bicanaliculatum','Carychium minimum bicanaliculatum','Carychium minim bicanaliculat',3,0,'','','Cessac','7ba4108d-b232-5a4b-bc12-8adb26353858','Carychium minimum bicanaliculatum Cessac, 1857','Cessac, 1857','UNRANKED','','Carychium','','minimum','bicanaliculatum','','',NULL,'','','','','','Cessac','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03503','','','Limnaea auricularia bicanalis A. Moquin-Tandon, 1855',1,'Limnaea auricularia bicanalis','Limnaea auricularia bicanalis','Limnaea auricular bicanal',3,0,'','','A. Moquin-Tandon','632e2cb9-0ff5-5d67-b28b-7171e05a3ad9','Limnaea auricularia bicanalis A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Limnaea','','auricularia','bicanalis','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03508','','','Cerithiopsis bicarinata Tiberi, in Appelius, 1870',2,'Cerithiopsis bicarinata','Cerithiopsis bicarinata','Cerithiopsis bicarinat',2,0,'','','Tiberi|Appelius','b5838ca3-1a05-583b-83b0-d1ba0785579f','Cerithiopsis bicarinata Tiberi, in Appelius, 1870','Tiberi, in Appelius, 1870','UNRANKED','','Cerithiopsis','','bicarinata','','','',NULL,'','','','','','Tiberi','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03513','','','Edmondia bicarinata Winchell, 1863',1,'Edmondia bicarinata','Edmondia bicarinata','Edmondia bicarinat',2,0,'','','Winchell','1c1cacc4-e72a-5a60-a067-037e546100cd','Edmondia bicarinata Winchell, 1863','Winchell, 1863','UNRANKED','','Edmondia','','bicarinata','','','',NULL,'','','','','','Winchell','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03516','','','Natica bicarinata Bellardi, 1852',1,'Natica bicarinata','Natica bicarinata','Natica bicarinat',2,0,'','','Bellardi','a5db42c5-7c18-575a-8adc-4ed84f1f9893','Natica bicarinata Bellardi, 1852','Bellardi, 1852','UNRANKED','','Natica','','bicarinata','','','',NULL,'','','','','','Bellardi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03521','','','Pleurotoma bicarinata Pease, 1868',1,'Pleurotoma bicarinata','Pleurotoma bicarinata','Pleurotoma bicarinat',2,0,'','','Pease','14d49f59-8cf6-5036-9de5-9af8a37b86bf','Pleurotoma bicarinata Pease, 1868','Pease, 1868','UNRANKED','','Pleurotoma','','bicarinata','','','',NULL,'','','','','','Pease','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03525','','','Stomatia bicarinata A. Adams, 1853',1,'Stomatia bicarinata','Stomatia bicarinata','Stomatia bicarinat',2,0,'','','A. Adams','765a23df-a082-586f-85cb-cdf12a37bec9','Stomatia bicarinata A. Adams, 1853','A. Adams, 1853','UNRANKED','','Stomatia','','bicarinata','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03530','','','Fossar bicarinatus A. Adams, 1853',1,'Fossar bicarinatus','Fossar bicarinatus','Fossar bicarinat',2,0,'','','A. Adams','41fe1016-c4ab-5d4a-a67a-952e52ada7e8','Fossar bicarinatus A. Adams, 1853','A. Adams, 1853','UNRANKED','','Fossar','','bicarinatus','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03535','','','Cardiomorpha bicatenulata Ryckholt, 1860',1,'Cardiomorpha bicatenulata','Cardiomorpha bicatenulata','Cardiomorpha bicatenulat',2,0,'','','Ryckholt','0807af91-e81e-5a77-8dce-09f4123a7776','Cardiomorpha bicatenulata Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Cardiomorpha','','bicatenulata','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03542','','','Natica bicincta Recluz, 1850',1,'Natica bicincta','Natica bicincta','Natica bicinct',2,0,'','','Recluz','216f5c8d-0981-5bd6-a838-9b7d27df87c3','Natica bicincta Recluz, 1850','Recluz, 1850','UNRANKED','','Natica','','bicincta','','','',NULL,'','','','','','Recluz','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03549','','','Pleurocera bicinctum Tryon, 1866',1,'Pleurocera bicinctum','Pleurocera bicinctum','Pleurocera bicinct',2,0,'','','Tryon','7130e1e5-0bf2-5cef-8a85-9ccf22ba4702','Pleurocera bicinctum Tryon, 1866','Tryon, 1866','UNRANKED','','Pleurocera','','bicinctum','','','',NULL,'','','','','','Tryon','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03553','','','Melania bicineta Tryon, 1864',1,'Melania bicineta','Melania bicineta','Melania bicinet',2,0,'','','Tryon','522ad6d3-100e-5880-b6a6-553846150040','Melania bicineta Tryon, 1864','Tryon, 1864','UNRANKED','','Melania','','bicineta','','','',NULL,'','','','','','Tryon','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03555','','','Pleurotoma bicingulata F. Sandberger, 1863',1,'Pleurotoma bicingulata','Pleurotoma bicingulata','Pleurotoma bicingulat',2,0,'','','F. Sandberger','c15468ee-6686-526a-88db-5478e04fff29','Pleurotoma bicingulata F. Sandberger, 1863','F. Sandberger, 1863','UNRANKED','','Pleurotoma','','bicingulata','','','',NULL,'','','','','','F. Sandberger','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03560','','','Amphidesma bicolor C.B. Adams, 1852',1,'Amphidesma bicolor','Amphidesma bicolor','Amphidesma bicolor',2,0,'','','C. B. Adams','9514d3bb-1145-5b67-a8f4-9040e5630e92','Amphidesma bicolor C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Amphidesma','','bicolor','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03567','','','Cyclostoma (Leptopoma) bicolor Pfeiffer, 1852',1,'Cyclostoma bicolor','Cyclostoma bicolor','Cyclostoma bicolor',2,0,'','','Pfeiffer','de9edba6-0f04-54eb-ac91-35ce6140af22','Cyclostoma (Leptopoma) bicolor Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Cyclostoma','Leptopoma','bicolor','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03572','','','Helix lucasi bicolor Bourguignat, 1864',1,'Helix lucasi bicolor','Helix lucasi bicolor','Helix lucas bicolor',3,0,'','','Bourguignat','a33542d3-46fb-5a9b-ba3d-8bb8d6b21b7c','Helix lucasi bicolor Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','lucasi','bicolor','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03579','','','Plecotrema bicolor Pfeiffer, 1855',1,'Plecotrema bicolor','Plecotrema bicolor','Plecotrema bicolor',2,0,'','','Pfeiffer','605580cc-0c71-5015-8ec2-f72834ff4fc9','Plecotrema bicolor Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Plecotrema','','bicolor','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03585','','','Tapes bicolorata Reeve, 1864',1,'Tapes bicolorata','Tapes bicolorata','Tapes bicolorat',2,0,'','','Reeve','e7fd72fd-de0b-553d-8173-c59dfa1c898e','Tapes bicolorata Reeve, 1864','Reeve, 1864','UNRANKED','','Tapes','','bicolorata','','','',NULL,'','','','','','Reeve','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03589','','','Mitra biconica Whitfield, 1865',1,'Mitra biconica','Mitra biconica','Mitra biconic',2,0,'','','Whitfield','3bf8093f-e5d5-5cb1-8077-41dc7ae7d934','Mitra biconica Whitfield, 1865','Whitfield, 1865','UNRANKED','','Mitra','','biconica','','','',NULL,'','','','','','Whitfield','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03593','','','Helix biconvexa Martens, 1864',1,'Helix biconvexa','Helix biconvexa','Helix biconuex',2,0,'','','Martens','0c9b5cb7-f36b-5a4d-a614-d2666365f56f','Helix biconvexa Martens, 1864','Martens, 1864','UNRANKED','','Helix','','biconvexa','','','',NULL,'','','','','','Martens','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03595','','','Aporrhais bicornis Pictet and Campiche, 1864',1,'Aporrhais bicornis','Aporrhais bicornis','Aporrhais bicorn',2,0,'','','Pictet|Campiche','9a0155b3-8421-5a1c-9e37-d422ec3d3d5a','Aporrhais bicornis Pictet and Campiche, 1864','Pictet and Campiche, 1864','UNRANKED','','Aporrhais','','bicornis','','','',NULL,'','','','','','Pictet & Campiche','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03604','','','Cerithium bicoronifer Piette, 1855',1,'Cerithium bicoronifer','Cerithium bicoronifer','Cerithium bicoronifer',2,0,'','','Piette','4b5369dc-ccaf-5943-96e9-ab44ebce3804','Cerithium bicoronifer Piette, 1855','Piette, 1855','UNRANKED','','Cerithium','','bicoronifer','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03609','','','Myophoria bicostata Picard, 1858',1,'Myophoria bicostata','Myophoria bicostata','Myophoria bicostat',2,0,'','','Picard','4cf1c0ea-bca7-5e7d-b2fe-78bb2440c496','Myophoria bicostata Picard, 1858','Picard, 1858','UNRANKED','','Myophoria','','bicostata','','','',NULL,'','','','','','Picard','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03614','','','Nerinea bicristata Etallon, in Thurmann and Etallon, 1862',2,'Nerinea bicristata','Nerinea bicristata','Nerinea bicristat',2,0,'','','Etallon|Thurmann','f6cc3f7d-1e36-519b-9c1e-ac60ccb7ef53','Nerinea bicristata Etallon, in Thurmann and Etallon, 1862','Etallon, in Thurmann and Etallon, 1862','UNRANKED','','Nerinea','','bicristata','','','',NULL,'','','','','','Etallon','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03622','','','Carychium bidentatum Hauffen, 1856',1,'Carychium bidentatum','Carychium bidentatum','Carychium bidentat',2,0,'','','Hauffen','753b4b99-0497-5051-93aa-7d1eed447422','Carychium bidentatum Hauffen, 1856','Hauffen, 1856','UNRANKED','','Carychium','','bidentatum','','','',NULL,'','','','','','Hauffen','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03625','','','Cardium bidorsatum Coquand, 1865',1,'Cardium bidorsatum','Cardium bidorsatum','Cardium bidorsat',2,0,'','','Coquand','6f38be6c-d107-5130-9c6c-ce357d0e7d9c','Cardium bidorsatum Coquand, 1865','Coquand, 1865','UNRANKED','','Cardium','','bidorsatum','','','',NULL,'','','','','','Coquand','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03631','','','Unio biemarginatus Lea, 1857',1,'Unio biemarginatus','Unio biemarginatus','Unio biemarginat',2,0,'','','Lea','e13c32d5-3b76-5d88-b2dc-53d61d06aa87','Unio biemarginatus Lea, 1857','Lea, 1857','UNRANKED','','Unio','','biemarginatus','','','',NULL,'','','','','','Lea','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03637','','','Leiostraca bifascialis A. Adams, 1864',1,'Leiostraca bifascialis','Leiostraca bifascialis','Leiostraca bifascial',2,0,'','','A. Adams','347a5911-cae8-50c9-a989-13d894aeebd1','Leiostraca bifascialis A. Adams, 1864','A. Adams, 1864','UNRANKED','','Leiostraca','','bifascialis','','','',NULL,'','','','','','A. Adams','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03641','','','Helix lactea bifasciata Bourguignat, 1864',1,'Helix lactea bifasciata','Helix lactea bifasciata','Helix lacte bifasciat',3,0,'','','Bourguignat','f9aea36d-fb90-5a69-b020-ff729460d2d4','Helix lactea bifasciata Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','lactea','bifasciata','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03643','','','Helix soluta bifasciata Bourguignat, 1864',1,'Helix soluta bifasciata','Helix soluta bifasciata','Helix solut bifasciat',3,0,'','','Bourguignat','ade3c7cf-fae6-50f4-8d02-f0fc74ea0751','Helix soluta bifasciata Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','soluta','bifasciata','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03650','','','Cerithium bifasciatum G. Sowerby, 1855',1,'Cerithium bifasciatum','Cerithium bifasciatum','Cerithium bifasciat',2,0,'','','G. Sowerby','598794cb-4628-55b8-91f7-f8eb4ab272de','Cerithium bifasciatum G. Sowerby, 1855','G. Sowerby, 1855','UNRANKED','','Cerithium','','bifasciatum','','','',NULL,'','','','','','G. Sowerby','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03659','','','Solarium bifidum Deshayes, 1863',1,'Solarium bifidum','Solarium bifidum','Solarium bifid',2,0,'','','Deshayes','be519afa-a7b1-594b-bacd-17805980e918','Solarium bifidum Deshayes, 1863','Deshayes, 1863','UNRANKED','','Solarium','','bifidum','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03662','','','Columbella biflammata Reeve, 1859',1,'Columbella biflammata','Columbella biflammata','Columbella biflammat',2,0,'','','Reeve','eabfd9c9-0f9b-5b31-bcea-4518d31c8450','Columbella biflammata Reeve, 1859','Reeve, 1859','UNRANKED','','Columbella','','biflammata','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03669','','','Limnaeus biformis Küster, 1863',1,'Limnaeus biformis','Limnaeus biformis','Limnaeus biform',2,0,'','','Küster','84ede840-6bb2-5fb3-aee8-e43f814b3206','Limnaeus biformis Küster, 1863','Küster, 1863','UNRANKED','','Limnaeus','','biformis','','','',NULL,'','','','','','Küster','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03672','','','Alycaeus bifrons W. Theobald, 1870',1,'Alycaeus bifrons','Alycaeus bifrons','Alycaeus bifrons',2,0,'','','W. Theobald','b1aafc3e-8a7f-52dc-983b-daa081d5c09d','Alycaeus bifrons W. Theobald, 1870','W. Theobald, 1870','UNRANKED','','Alycaeus','','bifrons','','','',NULL,'','','','','','W. Theobald','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03676','','','Helix neglecta bifrons A. Moquin-Tandon, 1855',1,'Helix neglecta bifrons','Helix neglecta bifrons','Helix neglect bifrons',3,0,'','','A. Moquin-Tandon','38aa3b7e-913d-540e-aa7b-2a2dca68d70c','Helix neglecta bifrons A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','neglecta','bifrons','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03680','','','Pterocyclos bifrons Pfeiffer, 1855',1,'Pterocyclos bifrons','Pterocyclos bifrons','Pterocyclos bifrons',2,0,'','','Pfeiffer','cf1dd9f0-4df5-5352-8db0-cb3a1fc5f991','Pterocyclos bifrons Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Pterocyclos','','bifrons','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03687','','','Heteroceras bifurcatum Orbigny, 1851',1,'Heteroceras bifurcatum','Heteroceras bifurcatum','Heteroceras bifurcat',2,0,'','','Orbigny','79f4d14b-dfaa-56b2-8fe0-c7000f238bd5','Heteroceras bifurcatum Orbigny, 1851','Orbigny, 1851','UNRANKED','','Heteroceras','','bifurcatum','','','',NULL,'','','','','','Orbigny','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03695','','','Macleurea bigsbyi Hall, 1861',1,'Macleurea bigsbyi','Macleurea bigsbyi','Macleurea bigsby',2,0,'','','Hall','4f3e96db-1244-5dc8-be5b-5207e85af9f6','Macleurea bigsbyi Hall, 1861','Hall, 1861','UNRANKED','','Macleurea','','bigsbyi','','','',NULL,'','','','','','Hall','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03698','','','Voluta biinterrupta Schaftiautl, 1863',1,'Voluta biinterrupta','Voluta biinterrupta','Voluta biinterrupt',2,0,'','','Schaftiautl','b20a96a1-bdd2-54ac-92cf-09a98a4546b2','Voluta biinterrupta Schaftiautl, 1863','Schaftiautl, 1863','UNRANKED','','Voluta','','biinterrupta','','','',NULL,'','','','','','Schaftiautl','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03701','','','Trochus bijugatus Quenstedt, 1856',1,'Trochus bijugatus','Trochus bijugatus','Trochus biiugat',2,0,'','','Quenstedt','2cb70c88-c856-598c-bca6-27a08d72d301','Trochus bijugatus Quenstedt, 1856','Quenstedt, 1856','UNRANKED','','Trochus','','bijugatus','','','',NULL,'','','','','','Quenstedt','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03708','','','Cucullaea bilineata C. Moore, 1866',1,'Cucullaea bilineata','Cucullaea bilineata','Cucullaea bilineat',2,0,'','','C. Moore','d857a270-03f6-570f-9059-9eac8957fdd5','Cucullaea bilineata C. Moore, 1866','C. Moore, 1866','UNRANKED','','Cucullaea','','bilineata','','','',NULL,'','','','','','C. Moore','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03714','','','Pupina bilinguis Pfeiffer, 1850',1,'Pupina bilinguis','Pupina bilinguis','Pupina bilingu',2,0,'','','Pfeiffer','efe70755-8c78-53fc-91f2-95af1250d6e0','Pupina bilinguis Pfeiffer, 1850','Pfeiffer, 1850','UNRANKED','','Pupina','','bilinguis','','','',NULL,'','','','','','Pfeiffer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03721','','','Scalaria billaudeli Mayer, 1864',1,'Scalaria billaudeli','Scalaria billaudeli','Scalaria billaudel',2,0,'','','Mayer','8bfa9c5b-fa68-572a-8990-4011c271376d','Scalaria billaudeli Mayer, 1864','Mayer, 1864','UNRANKED','','Scalaria','','billaudeli','','','',NULL,'','','','','','Mayer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03725','','','Planorbis billingsii Lea, 1864',1,'Planorbis billingsii','Planorbis billingsii','Planorbis billings',2,0,'','','Lea','6bcea874-84ca-50c3-8689-34959b658444','Planorbis billingsii Lea, 1864','Lea, 1864','UNRANKED','','Planorbis','','billingsii','','','',NULL,'','','','','','Lea','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03731','','','Teredo bilobatus Buvignier, 1852',1,'Teredo bilobatus','Teredo bilobatus','Teredo bilobat',2,0,'','','Buvignier','91073411-ebea-5f18-be36-7d79940b0324','Teredo bilobatus Buvignier, 1852','Buvignier, 1852','UNRANKED','','Teredo','','bilobatus','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03734','','','Cardita bimaculata Deshayes, 1852',1,'Cardita bimaculata','Cardita bimaculata','Cardita bimaculat',2,0,'','','Deshayes','fa3f47f9-71b3-5a06-88bf-3a5f55fac69b','Cardita bimaculata Deshayes, 1852','Deshayes, 1852','UNRANKED','','Cardita','','bimaculata','','','',NULL,'','','','','','Deshayes','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03741','','','Caecum bimarginatum P. Carpenter, 1858',1,'Caecum bimarginatum','Caecum bimarginatum','Caecum bimarginat',2,0,'','','P. Carpenter','9df4a114-abec-550c-82d9-bcee75b4c4e9','Caecum bimarginatum P. Carpenter, 1858','P. Carpenter, 1858','UNRANKED','','Caecum','','bimarginatum','','','',NULL,'','','','','','P. Carpenter','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03745','','','Turbo bimarginatus Deshayes, 1863',1,'Turbo bimarginatus','Turbo bimarginatus','Turbo bimarginat',2,0,'','','Deshayes','40bc32c6-e4a2-5c47-a6ac-d467cbd71a40','Turbo bimarginatus Deshayes, 1863','Deshayes, 1863','UNRANKED','','Turbo','','bimarginatus','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03749','','','Turritella binaria Hebert and Eudes-Deslongchamps, 1860',1,'Turritella binaria','Turritella binaria','Turritella binar',2,0,'','','Hebert|Eudes-Deslongchamps','43e6071b-5694-5eb7-97bf-95e809a5eee7','Turritella binaria Hebert and Eudes-Deslongchamps, 1860','Hebert and Eudes-Deslongchamps, 1860','UNRANKED','','Turritella','','binaria','','','',NULL,'','','','','','Hebert & Eudes-Deslongchamps','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03752','','','Sabanaea binghamiana Leach, in J. Gray, 1852',2,'Sabanaea binghamiana','Sabanaea binghamiana','Sabanaea binghamian',2,0,'','','Leach|J. Gray','2d37b7f0-eb25-5f84-bbf3-81378a22c3fc','Sabanaea binghamiana Leach, in J. Gray, 1852','Leach, in J. Gray, 1852','UNRANKED','','Sabanaea','','binghamiana','','','',NULL,'','','','','','Leach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03758','','','Hyalina binneyana Morse, 1864',1,'Hyalina binneyana','Hyalina binneyana','Hyalina binneyan',2,0,'','','Morse','27fe985c-6394-51d4-8f1d-68b568a4435e','Hyalina binneyana Morse, 1864','Morse, 1864','UNRANKED','','Hyalina','','binneyana','','','',NULL,'','','','','','Morse','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03766','','','Goniobasis binneyiana Lea, 1862',1,'Goniobasis binneyiana','Goniobasis binneyiana','Goniobasis binneyian',2,0,'','','Lea','8e18d867-4630-54c1-81bd-bb07f456dc9e','Goniobasis binneyiana Lea, 1862','Lea, 1862','UNRANKED','','Goniobasis','','binneyiana','','','',NULL,'','','','','','Lea','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03769','','','Edmondia binumbonata Winchell, 1862',1,'Edmondia binumbonata','Edmondia binumbonata','Edmondia binumbonat',2,0,'','','Winchell','ae1be2a7-3f46-5403-ba45-01c39a826d30','Edmondia binumbonata Winchell, 1862','Winchell, 1862','UNRANKED','','Edmondia','','binumbonata','','','',NULL,'','','','','','Winchell','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03774','','','Achatina biondiana Benoit, 1862',1,'Achatina biondiana','Achatina biondiana','Achatina biondian',2,0,'','','Benoit','b5da1b20-b404-54f4-8364-55a92aa5d5fc','Achatina biondiana Benoit, 1862','Benoit, 1862','UNRANKED','','Achatina','','biondiana','','','',NULL,'','','','','','Benoit','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03777','','','Littorina biornata Tate, 1870',1,'Littorina biornata','Littorina biornata','Littorina biornat',2,0,'','','Tate','a28667b3-114d-56bb-9c1b-3af18390f22c','Littorina biornata Tate, 1870','Tate, 1870','UNRANKED','','Littorina','','biornata','','','',NULL,'','','','','','Tate','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03782','','','Petricola bipartita Deshayes, 1853',1,'Petricola bipartita','Petricola bipartita','Petricola bipartit',2,0,'','','Deshayes','19f443b3-0a20-5352-a2ab-38308f7866d0','Petricola bipartita Deshayes, 1853','Deshayes, 1853','UNRANKED','','Petricola','','bipartita','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03791','','','Limea biplex Eichwald, 1865',1,'Limea biplex','Limea biplex','Limea biplex',2,0,'','','Eichwald','a51d8413-2673-5ec0-bfc5-cdcc854e1e7b','Limea biplex Eichwald, 1865','Eichwald, 1865','UNRANKED','','Limea','','biplex','','','',NULL,'','','','','','Eichwald','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03796','','','Marginella biplicata Krauss, 1852',1,'Marginella biplicata','Marginella biplicata','Marginella biplicat',2,0,'','','Krauss','255ecc4c-ce80-5321-a09e-9e95d6748772','Marginella biplicata Krauss, 1852','Krauss, 1852','UNRANKED','','Marginella','','biplicata','','','',NULL,'','','','','','Krauss','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03800','','','Carychium myosotis biplicatum A. Moquin-Tandon, 1855',1,'Carychium myosotis biplicatum','Carychium myosotis biplicatum','Carychium myosot biplicat',3,0,'','','A. Moquin-Tandon','04ad1bfe-d857-50dd-94db-9b59b6827e86','Carychium myosotis biplicatum A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Carychium','','myosotis','biplicatum','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03804','','','Stomatella biporcata A. Adams, 1850',1,'Stomatella biporcata','Stomatella biporcata','Stomatella biporcat',2,0,'','','A. Adams','a3f20657-ab50-5e77-8e09-abee1b04e206','Stomatella biporcata A. Adams, 1850','A. Adams, 1850','UNRANKED','','Stomatella','','biporcata','','','',NULL,'','','','','','A. Adams','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03806','','','Arcopagia biradiata Zittel, 1865',1,'Arcopagia biradiata','Arcopagia biradiata','Arcopagia biradiat',2,0,'','','Zittel','b635b5ab-4e96-510f-94ff-08888622a7c5','Arcopagia biradiata Zittel, 1865','Zittel, 1865','UNRANKED','','Arcopagia','','biradiata','','','',NULL,'','','','','','Zittel','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03812','','','Streptaxis birmanica Blanford, in W. Theobald, 1864',2,'Streptaxis birmanica','Streptaxis birmanica','Streptaxis birmanic',2,0,'','','Blanford|W. Theobald','81693a92-f1ea-5803-b2db-c5c3452083cb','Streptaxis birmanica Blanford, in W. Theobald, 1864','Blanford, in W. Theobald, 1864','UNRANKED','','Streptaxis','','birmanica','','','',NULL,'','','','','','Blanford','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03816','','','Cyclostoma (Cyclotus) birostre Pfeiffer, 1854',1,'Cyclostoma birostre','Cyclostoma birostre','Cyclostoma birostr',2,0,'','','Pfeiffer','3d5ee75b-679c-50d2-8a4d-e5d7729f2d90','Cyclostoma (Cyclotus) birostre Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Cyclostoma','Cyclotus','birostre','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03819','','','Bulimus bisculptus Pfeiffer, 1869',1,'Bulimus bisculptus','Bulimus bisculptus','Bulimus bisculpt',2,0,'','','Pfeiffer','4e4c0e57-1fa6-5f46-acba-97dd53c664aa','Bulimus bisculptus Pfeiffer, 1869','Pfeiffer, 1869','UNRANKED','','Bulimus','','bisculptus','','','',NULL,'','','','','','Pfeiffer','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03821','','','Cardium bisectum Forbes, 1856',1,'Cardium bisectum','Cardium bisectum','Cardium bisect',2,0,'','','Forbes','4b97904f-87bd-562c-b862-07bc9b85d1cb','Cardium bisectum Forbes, 1856','Forbes, 1856','UNRANKED','','Cardium','','bisectum','','','',NULL,'','','','','','Forbes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03825','','','Turritella biserialis Eichwald, 1865',1,'Turritella biserialis','Turritella biserialis','Turritella biserial',2,0,'','','Eichwald','8821a3fd-f84e-5025-8ad6-ce91686c3361','Turritella biserialis Eichwald, 1865','Eichwald, 1865','UNRANKED','','Turritella','','biserialis','','','',NULL,'','','','','','Eichwald','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03830','','','Stephopoma bispinosa Mörch, 1860',1,'Stephopoma bispinosa','Stephopoma bispinosa','Stephopoma bispinos',2,0,'','','Mörch','8a895d7f-08db-5ef9-8f4a-bf80f03545e8','Stephopoma bispinosa Mörch, 1860','Mörch, 1860','UNRANKED','','Stephopoma','','bispinosa','','','',NULL,'','','','','','Mörch','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03833','','','Avellana bistriata Gümbel, 1861',1,'Avellana bistriata','Avellana bistriata','Avellana bistriat',2,0,'','','Gümbel','503ece13-4eb2-50eb-9b6c-e7446bf4fc07','Avellana bistriata Gümbel, 1861','Gümbel, 1861','UNRANKED','','Avellana','','bistriata','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03836','','','Fusus bistriatus Gümbel, 1861',1,'Fusus bistriatus','Fusus bistriatus','Fusus bistriat',2,0,'','','Gümbel','554730b8-887c-5a61-a256-a22b002d9490','Fusus bistriatus Gümbel, 1861','Gümbel, 1861','UNRANKED','','Fusus','','bistriatus','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03843','','','Platyceras bisulcatum Hall, 1859',1,'Platyceras bisulcatum','Platyceras bisulcatum','Platyceras bisulcat',2,0,'','','Hall','54384ba2-0263-5582-99b6-4d047b422b70','Platyceras bisulcatum Hall, 1859','Hall, 1859','UNRANKED','','Platyceras','','bisulcatum','','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03848','','','Clausilia bitorquata Frivaldszky, in Rossmässler, 1857',2,'Clausilia bitorquata','Clausilia bitorquata','Clausilia bitorquat',2,0,'','','Frivaldszky|Rossmässler','4eba4c1b-f658-577b-9ecb-186d8be80f61','Clausilia bitorquata Frivaldszky, in Rossmässler, 1857','Frivaldszky, in Rossmässler, 1857','UNRANKED','','Clausilia','','bitorquata','','','',NULL,'','','','','','Frivaldszky','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03857','','','Meioceras bitumidum Folin, 1869',1,'Meioceras bitumidum','Meioceras bitumidum','Meioceras bitumid',2,0,'','','Folin','842489eb-c31d-5114-8551-2641ae076c18','Meioceras bitumidum Folin, 1869','Folin, 1869','UNRANKED','','Meioceras','','bitumidum','','','',NULL,'','','','','','Folin','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03860','','','Nerinaea bivia Eichwald, 1868',1,'Nerinaea bivia','Nerinaea bivia','Nerinaea biu',2,0,'','','Eichwald','8979aa8f-aeab-5ce1-8e2c-dd471439fc08','Nerinaea bivia Eichwald, 1868','Eichwald, 1868','UNRANKED','','Nerinaea','','bivia','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03864','','','Bulimus acutus bizona Jeffreys, 1862',1,'Bulimus acutus bizona','Bulimus acutus bizona','Bulimus acut bizon',3,0,'','','Jeffreys','a49cedb5-8791-5a7e-b415-a81410ccb5ad','Bulimus acutus bizona Jeffreys, 1862','Jeffreys, 1862','UNRANKED','','Bulimus','','acutus','bizona','','',NULL,'','','','','','Jeffreys','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03869','','','Cyclostoma sulcatum bizonata Bourguignat, 1864',1,'Cyclostoma sulcatum bizonata','Cyclostoma sulcatum bizonata','Cyclostoma sulcat bizonat',3,0,'','','Bourguignat','701a4b75-4da9-5d60-88e4-95337436e863','Cyclostoma sulcatum bizonata Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Cyclostoma','','sulcatum','bizonata','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03870','','','Helix acuta bizonata Bourguignat, 1864',1,'Helix acuta bizonata','Helix acuta bizonata','Helix acut bizonat',3,0,'','','Bourguignat','ee02a68c-9c3e-5593-a355-4759f1b69b22','Helix acuta bizonata Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','acuta','bizonata','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03873','','','Helix moesta bizonata Bourguignat, 1864',1,'Helix moesta bizonata','Helix moesta bizonata','Helix moest bizonat',3,0,'','','Bourguignat','dcd73e10-70d8-5ede-9f27-11fdbe331f3c','Helix moesta bizonata Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','moesta','bizonata','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03876','','','Helix terrestris bizonata Bourguignat, 1864',1,'Helix terrestris bizonata','Helix terrestris bizonata','Helix terrestr bizonat',3,0,'','','Bourguignat','098ead97-6285-5888-bf3d-0a363b1e5496','Helix terrestris bizonata Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','terrestris','bizonata','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03883','','','Trichotropis blainvilleanus Petit de la Saussaye, 1851',1,'Trichotropis blainvilleanus','Trichotropis blainvilleanus','Trichotropis blainuillean',2,0,'','','Petit de la Saussaye','7962fc27-bbf7-5a26-b2bd-69ae1a93bdfd','Trichotropis blainvilleanus Petit de la Saussaye, 1851','Petit de la Saussaye, 1851','UNRANKED','','Trichotropis','','blainvilleanus','','','',NULL,'','','','','','Petit de la Saussaye','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03889','','','Helix blakeana Tate, 1870',1,'Helix blakeana','Helix blakeana','Helix blakean',2,0,'','','Tate','eddfc394-e430-5fc7-be36-f5df953237ac','Helix blakeana Tate, 1870','Tate, 1870','UNRANKED','','Helix','','blakeana','','','',NULL,'','','','','','Tate','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03894','','','Nerinea blancheti Pictet and Campiche, 1862',1,'Nerinea blancheti','Nerinea blancheti','Nerinea blanchet',2,0,'','','Pictet|Campiche','9035b0c9-609e-5592-81a5-8d106ea0a899','Nerinea blancheti Pictet and Campiche, 1862','Pictet and Campiche, 1862','UNRANKED','','Nerinea','','blancheti','','','',NULL,'','','','','','Pictet & Campiche','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03900','','','Turbonilla blanda Deshayes, 1861',1,'Turbonilla blanda','Turbonilla blanda','Turbonilla bland',2,0,'','','Deshayes','c8df33a8-0ea6-50b8-b53f-15c7e1939fcf','Turbonilla blanda Deshayes, 1861','Deshayes, 1861','UNRANKED','','Turbonilla','','blanda','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03904','','','Pupilla blandii Morse, 1865',1,'Pupilla blandii','Pupilla blandii','Pupilla bland',2,0,'','','Morse','035058b7-3ec6-544d-86ca-abe5e62ab3d3','Pupilla blandii Morse, 1865','Morse, 1865','UNRANKED','','Pupilla','','blandii','','','',NULL,'','','','','','Morse','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03908','','','Cyane blandiana H. Adams, 1870',1,'Cyane blandiana','Cyane blandiana','Cyane blandian',2,0,'','','H. Adams','56c81f0e-e58a-5cef-98b3-bcd0c91c5d8d','Cyane blandiana H. Adams, 1870','H. Adams, 1870','UNRANKED','','Cyane','','blandiana','','','',NULL,'','','','','','H. Adams','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03914','','','Trochus blandianus Crosse, 1864',1,'Trochus blandianus','Trochus blandianus','Trochus blandian',2,0,'','','Crosse','cf9422d1-fe22-51f4-8774-cbcf55f5ed5f','Trochus blandianus Crosse, 1864','Crosse, 1864','UNRANKED','','Trochus','','blandianus','','','',NULL,'','','','','','Crosse','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03920','','','Bellerophon blaneyanus McChesney, 1867',1,'Bellerophon blaneyanus','Bellerophon blaneyanus','Bellerophon blaneyan',2,0,'','','McChesney','2e36293f-9f3e-533f-90ad-5213fb94737e','Bellerophon blaneyanus McChesney, 1867','McChesney, 1867','UNRANKED','','Bellerophon','','blaneyanus','','','',NULL,'','','','','','McChesney','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03926','','','Pupina blanfordi W. Theobald, 1864',1,'Pupina blanfordi','Pupina blanfordi','Pupina blanford',2,0,'','','W. Theobald','ae1dfe74-da84-54b1-ae74-2010de61dcf9','Pupina blanfordi W. Theobald, 1864','W. Theobald, 1864','UNRANKED','','Pupina','','blanfordi','','','',NULL,'','','','','','W. Theobald','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03931','','','Helix (Geotrochus) blanfordiana H. Adams, 1869',1,'Helix blanfordiana','Helix blanfordiana','Helix blanfordian',2,0,'','','H. Adams','15dc8082-da63-5431-8eb7-74338dbfbf2d','Helix (Geotrochus) blanfordiana H. Adams, 1869','H. Adams, 1869','UNRANKED','','Helix','Geotrochus','blanfordiana','','','',NULL,'','','','','','H. Adams','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03934','','','Astarte blanowicensis Ferd. Roemer, 1870',1,'Astarte blanowicensis','Astarte blanowicensis','Astarte blanowicens',2,0,'','','Ferd. Roemer','e043f187-d2bd-5f74-9855-1ad3e320117f','Astarte blanowicensis Ferd. Roemer, 1870','Ferd. Roemer, 1870','UNRANKED','','Astarte','','blanowicensis','','','',NULL,'','','','','','Ferd. Roemer','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03937','','','Melania blatta Lea and Lea, 1850',1,'Melania blatta','Melania blatta','Melania blatt',2,0,'','','Lea','56981e51-fea9-567d-a2a8-cea41e55caf0','Melania blatta Lea and Lea, 1850','Lea and Lea, 1850','UNRANKED','','Melania','','blatta','','','',NULL,'','','','','','Lea & Lea','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03945','','','Ancylus gibbosus blidahensis Bourguignat, 1864',1,'Ancylus gibbosus blidahensis','Ancylus gibbosus blidahensis','Ancylus gibbos blidahens',3,0,'','','Bourguignat','ce34d404-7f7d-52a1-8740-247b62dd9c45','Ancylus gibbosus blidahensis Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Ancylus','','gibbosus','blidahensis','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03950','','','Helix boa Hupe, 1857',1,'Helix boa','Helix boa','Helix bo',2,0,'','','Hupe','1bce9cbb-921c-50fc-ade5-ea330e710eb1','Helix boa Hupe, 1857','Hupe, 1857','UNRANKED','','Helix','','boa','','','',NULL,'','','','','','Hupe','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03955','','','Helix bocageana Crosse, 1864',1,'Helix bocageana','Helix bocageana','Helix bocagean',2,0,'','','Crosse','ecd67c2f-2b67-5556-b56a-a6caee5cc282','Helix bocageana Crosse, 1864','Crosse, 1864','UNRANKED','','Helix','','bocageana','','','',NULL,'','','','','','Crosse','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03961','','','Lima bochardi J. Martin, 1863',1,'Lima bochardi','Lima bochardi','Lima bochard',2,0,'','','J. Martin','b0fd6ce6-3e53-58f3-922e-51f78b8c293b','Lima bochardi J. Martin, 1863','J. Martin, 1863','UNRANKED','','Lima','','bochardi','','','',NULL,'','','','','','J. Martin','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03965','','','Helicina bocourti Crosse and Fischer, 1869',1,'Helicina bocourti','Helicina bocourti','Helicina bocourt',2,0,'','','Crosse|Fischer','25479abf-45dc-556a-a10e-4d5b041326c3','Helicina bocourti Crosse and Fischer, 1869','Crosse and Fischer, 1869','UNRANKED','','Helicina','','bocourti','','','',NULL,'','','','','','Crosse & Fischer','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03968','','','Arca bodana Fried. Roemer, 1860',1,'Arca bodana','Arca bodana','Arca bodan',2,0,'','','Fried. Roemer','576f3e83-db85-570a-bda7-25baae30427d','Arca bodana Fried. Roemer, 1860','Fried. Roemer, 1860','UNRANKED','','Arca','','bodana','','','',NULL,'','','','','','Fried. Roemer','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03973','','','Soletellina boeddinghausi Lischke, 1870',1,'Soletellina boeddinghausi','Soletellina boeddinghausi','Soletellina boeddinghaus',2,0,'','','Lischke','4ec94baf-2ba5-5e7a-921a-5dab8aad4417','Soletellina boeddinghausi Lischke, 1870','Lischke, 1870','UNRANKED','','Soletellina','','boeddinghausi','','','',NULL,'','','','','','Lischke','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03976','','','Cerithium boeticum Pease, 1860',1,'Cerithium boeticum','Cerithium boeticum','Cerithium boetic',2,0,'','','Pease','28d18b66-d65b-5f15-847f-441f813d75db','Cerithium boeticum Pease, 1860','Pease, 1860','UNRANKED','','Cerithium','','boeticum','','','',NULL,'','','','','','Pease','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03980','','','Cyclostoma (Cyclotus) bogotense Pfeiffer, 1855',1,'Cyclostoma bogotense','Cyclostoma bogotense','Cyclostoma bogotens',2,0,'','','Pfeiffer','66cdcb2e-26f1-5b0f-8b2e-6db0c4c7d655','Cyclostoma (Cyclotus) bogotense Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Cyclostoma','Cyclotus','bogotense','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03985','','','Arca bohemica Reuss, 1860',1,'Arca bohemica','Arca bohemica','Arca bohemic',2,0,'','','Reuss','ccae7957-f774-5f8e-b7a6-a52a887a49d0','Arca bohemica Reuss, 1860','Reuss, 1860','UNRANKED','','Arca','','bohemica','','','',NULL,'','','','','','Reuss','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03990','','','Mitra boissaci Montrouzier, 1859',1,'Mitra boissaci','Mitra boissaci','Mitra boissac',2,0,'','','Montrouzier','2bb0cfe7-e653-556c-8a5e-e8f2f5f64f29','Mitra boissaci Montrouzier, 1859','Montrouzier, 1859','UNRANKED','','Mitra','','boissaci','','','',NULL,'','','','','','Montrouzier','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03994','','','Lindsleya boissieriana Chitty, 1857',1,'Lindsleya boissieriana','Lindsleya boissieriana','Lindsleya boissierian',2,0,'','','Chitty','aea6cea8-d2c2-57b0-9ac7-6b9968c94379','Lindsleya boissieriana Chitty, 1857','Chitty, 1857','UNRANKED','','Lindsleya','','boissieriana','','','',NULL,'','','','','','Chitty','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_03997','','','Planorbis boissyi Deshayes, 1863',1,'Planorbis boissyi','Planorbis boissyi','Planorbis boissy',2,0,'','','Deshayes','d1c83787-9973-5097-bc4b-63400bb9802c','Planorbis boissyi Deshayes, 1863','Deshayes, 1863','UNRANKED','','Planorbis','','boissyi','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04003','','','Buccinum bolivianum Souleyet, 1852',1,'Buccinum bolivianum','Buccinum bolivianum','Buccinum boliuian',2,0,'','','Souleyet','85fe3c05-66ea-546b-8762-ccb10a6d94ba','Buccinum bolivianum Souleyet, 1852','Souleyet, 1852','UNRANKED','','Buccinum','','bolivianum','','','',NULL,'','','','','','Souleyet','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04009','','','Buccinum bolli Beyrich, 1854',1,'Buccinum bolli','Buccinum bolli','Buccinum boll',2,0,'','','Beyrich','4d44ef4c-f505-5df0-87de-d41d11e2467c','Buccinum bolli Beyrich, 1854','Beyrich, 1854','UNRANKED','','Buccinum','','bolli','','','',NULL,'','','','','','Beyrich','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04014','','','Trochus bolognai Bayan, 1870',1,'Trochus bolognai','Trochus bolognai','Trochus bologna',2,0,'','','Bayan','a5c807d7-d2ba-52e0-90d8-d27026b966a8','Trochus bolognai Bayan, 1870','Bayan, 1870','UNRANKED','','Trochus','','bolognai','','','',NULL,'','','','','','Bayan','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04019','','','Lima boloniensis Loriol, in Loriol and Pellat, 1867',2,'Lima boloniensis','Lima boloniensis','Lima boloniens',2,0,'','','Loriol|Pellat','f474803f-7aa3-5ac4-86a7-aada04286e9c','Lima boloniensis Loriol, in Loriol and Pellat, 1867','Loriol, in Loriol and Pellat, 1867','UNRANKED','','Lima','','boloniensis','','','',NULL,'','','','','','Loriol','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04026','','','Cerithidea bombayana G. Sowerby, 1866',1,'Cerithidea bombayana','Cerithidea bombayana','Cerithidea bombayan',2,0,'','','G. Sowerby','7879e9b3-a5ab-52d8-b489-dd5813a1bc18','Cerithidea bombayana G. Sowerby, 1866','G. Sowerby, 1866','UNRANKED','','Cerithidea','','bombayana','','','',NULL,'','','','','','G. Sowerby','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04032','','','Lima bonanomii Etallon, in Thurmann and Etallon, 1862',2,'Lima bonanomii','Lima bonanomii','Lima bonanom',2,0,'','','Etallon|Thurmann','1b1d0c27-4cc7-5e16-a8fd-2f6eee310ff6','Lima bonanomii Etallon, in Thurmann and Etallon, 1862','Etallon, in Thurmann and Etallon, 1862','UNRANKED','','Lima','','bonanomii','','','',NULL,'','','','','','Etallon','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04039','','','Mitra bonellii Bellardi, 1850',1,'Mitra bonellii','Mitra bonellii','Mitra bonell',2,0,'','','Bellardi','e08c8214-0157-59f0-9ed8-238ac173fe40','Mitra bonellii Bellardi, 1850','Bellardi, 1850','UNRANKED','','Mitra','','bonellii','','','',NULL,'','','','','','Bellardi','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04049','','','Helix borbonica Deshayes, 1863',1,'Helix borbonica','Helix borbonica','Helix borbonic',2,0,'','','Deshayes','73c1b34c-c04a-5489-9913-536ef0349d1a','Helix borbonica Deshayes, 1863','Deshayes, 1863','UNRANKED','','Helix','','borbonica','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04051','','','Ovula borbonica Deshayes, 1863',1,'Ovula borbonica','Ovula borbonica','Ovula borbonic',2,0,'','','Deshayes','d4dc6b78-af1a-5b5d-831a-bb978c93158d','Ovula borbonica Deshayes, 1863','Deshayes, 1863','UNRANKED','','Ovula','','borbonica','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04056','','','Conus (Chelyconus) borbonicus H. Adams, 1868',1,'Conus borbonicus','Conus borbonicus','Conus borbonic',2,0,'','','H. Adams','b35dfa58-3082-5d26-8e3a-efbabac61a0c','Conus (Chelyconus) borbonicus H. Adams, 1868','H. Adams, 1868','UNRANKED','','Conus','Chelyconus','borbonicus','','','',NULL,'','','','','','H. Adams','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04061','','','Crassatella borealis Eichwald, 1865',1,'Crassatella borealis','Crassatella borealis','Crassatella boreal',2,0,'','','Eichwald','1bb86f40-b699-5cff-bf20-f70a82e16dfd','Crassatella borealis Eichwald, 1865','Eichwald, 1865','UNRANKED','','Crassatella','','borealis','','','',NULL,'','','','','','Eichwald','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04065','','','Opalia borealis Gould, in P. Carpenter, 1864',2,'Opalia borealis','Opalia borealis','Opalia boreal',2,0,'','','Gould|P. Carpenter','8b01da0a-6932-569b-aa39-defc86270f9f','Opalia borealis Gould, in P. Carpenter, 1864','Gould, in P. Carpenter, 1864','UNRANKED','','Opalia','','borealis','','','',NULL,'','','','','','Gould','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04074','','','Patella boreaui Bayan, 1870',1,'Patella boreaui','Patella boreaui','Patella boreau',2,0,'','','Bayan','c9ff3477-5ddf-5d6f-b1ec-215ffd8065f2','Patella boreaui Bayan, 1870','Bayan, 1870','UNRANKED','','Patella','','boreaui','','','',NULL,'','','','','','Bayan','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04079','','','Terebellum borissiakii Eichwald, 1865',1,'Terebellum borissiakii','Terebellum borissiakii','Terebellum borissiak',2,0,'','','Eichwald','b3725d34-015b-5c31-9bd2-d517b0e59f9b','Terebellum borissiakii Eichwald, 1865','Eichwald, 1865','UNRANKED','','Terebellum','','borissiakii','','','',NULL,'','','','','','Eichwald','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04083','','','Cyclostoma borneensis Metcalfe, 1851',1,'Cyclostoma borneensis','Cyclostoma borneensis','Cyclostoma borneens',2,0,'','','Metcalfe','77fdb73b-1a67-5851-8b2e-33ef0bb79779','Cyclostoma borneensis Metcalfe, 1851','Metcalfe, 1851','UNRANKED','','Cyclostoma','','borneensis','','','',NULL,'','','','','','Metcalfe','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04090','','','Scintilla borneensis Deshayes, in G. Sowerby, 1862',2,'Scintilla borneensis','Scintilla borneensis','Scintilla borneens',2,0,'','','Deshayes|G. Sowerby','3fc8cae9-9254-5e39-95c5-3f251e2bd12a','Scintilla borneensis Deshayes, in G. Sowerby, 1862','Deshayes, in G. Sowerby, 1862','UNRANKED','','Scintilla','','borneensis','','','',NULL,'','','','','','Deshayes','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04097','','','Mitra borsoni Bellardi, 1850',1,'Mitra borsoni','Mitra borsoni','Mitra borson',2,0,'','','Bellardi','61bd0a4f-292c-5bec-b4fd-126e3f4de620','Mitra borsoni Bellardi, 1850','Bellardi, 1850','UNRANKED','','Mitra','','borsoni','','','',NULL,'','','','','','Bellardi','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04101','','','Clausilia bosniensis Zelebor, in Vest, 1867',2,'Clausilia bosniensis','Clausilia bosniensis','Clausilia bosniens',2,0,'','','Zelebor|Vest','2303ce85-3e90-59f8-81ed-27cd2b4f5f1d','Clausilia bosniensis Zelebor, in Vest, 1867','Zelebor, in Vest, 1867','UNRANKED','','Clausilia','','bosniensis','','','',NULL,'','','','','','Zelebor','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04106','','','Mytilus bosquetianus Ryckholt, 1860',1,'Mytilus bosquetianus','Mytilus bosquetianus','Mytilus bosquetian',2,0,'','','Ryckholt','2f6978e1-29aa-5c8c-9bdd-9b2d4a587659','Mytilus bosquetianus Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Mytilus','','bosquetianus','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04113','','','Oleacina boucardi Pfeiffer, 1859',1,'Oleacina boucardi','Oleacina boucardi','Oleacina boucard',2,0,'','','Pfeiffer','681f5976-0d35-564e-9e0c-616ee282af1c','Oleacina boucardi Pfeiffer, 1859','Pfeiffer, 1859','UNRANKED','','Oleacina','','boucardi','','','',NULL,'','','','','','Pfeiffer','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04119','','','Pecten bouchardi Oppel, 1857',1,'Pecten bouchardi','Pecten bouchardi','Pecten bouchard',2,0,'','','Oppel','24ff8389-0367-5bc2-937e-9c39711684da','Pecten bouchardi Oppel, 1857','Oppel, 1857','UNRANKED','','Pecten','','bouchardi','','','',NULL,'','','','','','Oppel','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04121','','','Phorus bouchardi E. Deslongchamps, 1862',1,'Phorus bouchardi','Phorus bouchardi','Phorus bouchard',2,0,'','','E. Deslongchamps','8f868ec1-461b-5816-98b1-334a64590ca5','Phorus bouchardi E. Deslongchamps, 1862','E. Deslongchamps, 1862','UNRANKED','','Phorus','','bouchardi','','','',NULL,'','','','','','E. Deslongchamps','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04125','','','Scalaria boucheroni Coquand, 1859',1,'Scalaria boucheroni','Scalaria boucheroni','Scalaria boucheron',2,0,'','','Coquand','aef2ebb7-63c5-595b-a4c3-67ff41e886b1','Scalaria boucheroni Coquand, 1859','Coquand, 1859','UNRANKED','','Scalaria','','boucheroni','','','',NULL,'','','','','','Coquand','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04132','','','Neritina bougainvillei Recluz, 1850',1,'Neritina bougainvillei','Neritina bougainvillei','Neritina bougainuille',2,0,'','','Recluz','3a7c56ea-c0a1-5878-807f-4e451951b15e','Neritina bougainvillei Recluz, 1850','Recluz, 1850','UNRANKED','','Neritina','','bougainvillei','','','',NULL,'','','','','','Recluz','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04137','','','Monodonta bourcierei Crosse, 1863',1,'Monodonta bourcierei','Monodonta bourcierei','Monodonta bourciere',2,0,'','','Crosse','dbab96b2-ee03-50fa-a201-3d1892baeb13','Monodonta bourcierei Crosse, 1863','Crosse, 1863','UNRANKED','','Monodonta','','bourcierei','','','',NULL,'','','','','','Crosse','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04143','','','Cypraea bourgeoisi Mayer, 1869',1,'Cypraea bourgeoisi','Cypraea bourgeoisi','Cypraea bourgeois',2,0,'','','Mayer','b8778555-1e8c-5e8b-aae5-4966442210e8','Cypraea bourgeoisi Mayer, 1869','Mayer, 1869','UNRANKED','','Cypraea','','bourgeoisi','','','',NULL,'','','','','','Mayer','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04147','','','Pupa secale bourgetica Bourguignat, 1864',1,'Pupa secale bourgetica','Pupa secale bourgetica','Pupa secal bourgetic',3,0,'','','Bourguignat','4f412ace-ff1c-57e4-967d-f5d7ed2f6ae4','Pupa secale bourgetica Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Pupa','','secale','bourgetica','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04151','','','Alvania bourguignati Issel, 1869',1,'Alvania bourguignati','Alvania bourguignati','Alvania bourguignat',2,0,'','','Issel','3b3d9068-e46c-58e3-a704-7d1dea2a1b11','Alvania bourguignati Issel, 1869','Issel, 1869','UNRANKED','','Alvania','','bourguignati','','','',NULL,'','','','','','Issel','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04157','','','Clausilia bourguignati Charpentier, 1852',1,'Clausilia bourguignati','Clausilia bourguignati','Clausilia bourguignat',2,0,'','','Charpentier','0ea61d2a-7351-5a57-91c9-0e6032f59c75','Clausilia bourguignati Charpentier, 1852','Charpentier, 1852','UNRANKED','','Clausilia','','bourguignati','','','',NULL,'','','','','','Charpentier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04164','','','Ostrea bourguignati Coquand, 1869',1,'Ostrea bourguignati','Ostrea bourguignati','Ostrea bourguignat',2,0,'','','Coquand','f22427d1-d27f-57a2-ab2c-a8fa60f5ec9b','Ostrea bourguignati Coquand, 1869','Coquand, 1869','UNRANKED','','Ostrea','','bourguignati','','','',NULL,'','','','','','Coquand','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04170','','','Testacella bourguignati Massot, 1870',1,'Testacella bourguignati','Testacella bourguignati','Testacella bourguignat',2,0,'','','Massot','6741ebb8-10e4-51d0-ae22-a1bae75c4d3e','Testacella bourguignati Massot, 1870','Massot, 1870','UNRANKED','','Testacella','','bourguignati','','','',NULL,'','','','','','Massot','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04175','','','Unio bourguignatianus Lea, 1863',1,'Unio bourguignatianus','Unio bourguignatianus','Unio bourguignatian',2,0,'','','Lea','659af0e9-c47f-51eb-910a-9961797c50e3','Unio bourguignatianus Lea, 1863','Lea, 1863','UNRANKED','','Unio','','bourguignatianus','','','',NULL,'','','','','','Lea','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04180','','','Turbo bourjoti Piette, 1855',1,'Turbo bourjoti','Turbo bourjoti','Turbo bouriot',2,0,'','','Piette','3933f691-0f62-533d-be27-00f27a66940a','Turbo bourjoti Piette, 1855','Piette, 1855','UNRANKED','','Turbo','','bourjoti','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04184','','','Bulimus boussingaultii Hupe, 1857',1,'Bulimus boussingaultii','Bulimus boussingaultii','Bulimus boussingault',2,0,'','','Hupe','626aa948-977c-524e-881e-b4e0f8d6ec5a','Bulimus boussingaultii Hupe, 1857','Hupe, 1857','UNRANKED','','Bulimus','','boussingaultii','','','',NULL,'','','','','','Hupe','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04188','','','Helix bouyeri Crosse and Fischer, 1864',1,'Helix bouyeri','Helix bouyeri','Helix bouyer',2,0,'','','Crosse|Fischer','caf5dc26-19b0-5750-af00-4a0e3292a7a8','Helix bouyeri Crosse and Fischer, 1864','Crosse and Fischer, 1864','UNRANKED','','Helix','','bouyeri','','','',NULL,'','','','','','Crosse & Fischer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04191','','','Cypraea bowerbankii I. Sowerby, in Dixon, 1850',2,'Cypraea bowerbankii','Cypraea bowerbankii','Cypraea bowerbank',2,0,'','','I. Sowerby|Dixon','fa94026e-aaf0-56f3-8e2f-9e78812d4ad2','Cypraea bowerbankii I. Sowerby, in Dixon, 1850','I. Sowerby, in Dixon, 1850','UNRANKED','','Cypraea','','bowerbankii','','','',NULL,'','','','','','I. Sowerby','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04196','','','Helix boyerii Fischer and Bernardi, 1857',1,'Helix boyerii','Helix boyerii','Helix boyer',2,0,'','','Fischer|Bernardi','c02143b3-4eee-5c3e-bbd6-2495750b9b19','Helix boyerii Fischer and Bernardi, 1857','Fischer and Bernardi, 1857','UNRANKED','','Helix','','boyerii','','','',NULL,'','','','','','Fischer & Bernardi','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04203','','','Osteodesma bracteata Gould, 1851',1,'Osteodesma bracteata','Osteodesma bracteata','Osteodesma bracteat',2,0,'','','Gould','e7b90a75-7803-5680-90f0-9c14841a44a8','Osteodesma bracteata Gould, 1851','Gould, 1851','UNRANKED','','Osteodesma','','bracteata','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04209','','','Melania branca Reeve, 1860',1,'Melania branca','Melania branca','Melania branc',2,0,'','','Reeve','7dd532b2-4d02-5cf5-a79e-3f8515b5d471','Melania branca Reeve, 1860','Reeve, 1860','UNRANKED','','Melania','','branca','','','',NULL,'','','','','','Reeve','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04214','','','Turbo branoviensis Dumortier, 1860',1,'Turbo branoviensis','Turbo branoviensis','Turbo branouiens',2,0,'','','Dumortier','c825570e-c405-5d0e-9bb3-6512257c1a15','Turbo branoviensis Dumortier, 1860','Dumortier, 1860','UNRANKED','','Turbo','','branoviensis','','','',NULL,'','','','','','Dumortier','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04220','','','Siphonaria brasiliana Reeve, 1856',1,'Siphonaria brasiliana','Siphonaria brasiliana','Siphonaria brasilian',2,0,'','','Reeve','6a14d5d8-f5df-5efd-854c-39fb449b20ba','Siphonaria brasiliana Reeve, 1856','Reeve, 1856','UNRANKED','','Siphonaria','','brasiliana','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04226','','','Cardium braunni Deshayes, 1853',1,'Cardium braunni','Cardium braunni','Cardium braunn',2,0,'','','Deshayes','a5e5ec7c-f3fa-5516-a7f3-12b95af1049f','Cardium braunni Deshayes, 1853','Deshayes, 1853','UNRANKED','','Cardium','','braunni','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04232','','','Helicina brazieri Pease, 1870',1,'Helicina brazieri','Helicina brazieri','Helicina brazier',2,0,'','','Pease','882f684a-bea0-54ca-814b-ae1889b4f2b4','Helicina brazieri Pease, 1870','Pease, 1870','UNRANKED','','Helicina','','brazieri','','','',NULL,'','','','','','Pease','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04240','','','Unio brazosensis Lea, 1868',1,'Unio brazosensis','Unio brazosensis','Unio brazosens',2,0,'','','Lea','b2db22e9-d116-5c1b-a4e9-9e585090c243','Unio brazosensis Lea, 1868','Lea, 1868','UNRANKED','','Unio','','brazosensis','','','',NULL,'','','','','','Lea','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04249','','','Cypricardia breoni J. Martin, 1863',1,'Cypricardia breoni','Cypricardia breoni','Cypricardia breon',2,0,'','','J. Martin','7f95c1f3-9b4b-5d7a-956a-55efe51d2c61','Cypricardia breoni J. Martin, 1863','J. Martin, 1863','UNRANKED','','Cypricardia','','breoni','','','',NULL,'','','','','','J. Martin','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04255','','','Dentalium breve Deshayes, 1861',1,'Dentalium breve','Dentalium breve','Dentalium breu',2,0,'','','Deshayes','8d3cde92-d77e-5ff8-8cdd-be51d11e24ad','Dentalium breve Deshayes, 1861','Deshayes, 1861','UNRANKED','','Dentalium','','breve','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04262','','','Melaniella brevicula H. Adams, 1870',1,'Melaniella brevicula','Melaniella brevicula','Melaniella breuicul',2,0,'','','H. Adams','b468eb24-c373-5c34-aebd-8a4daa4e3a32','Melaniella brevicula H. Adams, 1870','H. Adams, 1870','UNRANKED','','Melaniella','','brevicula','','','',NULL,'','','','','','H. Adams','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04268','','','Helicina brevilabris Pfeiffer, 1856',1,'Helicina brevilabris','Helicina brevilabris','Helicina breuilabr',2,0,'','','Pfeiffer','80bbb701-e3c4-5035-bad3-485fcf59b622','Helicina brevilabris Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Helicina','','brevilabris','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04273','','','Tellina brevirostrata G. Sowerby, 1867',1,'Tellina brevirostrata','Tellina brevirostrata','Tellina breuirostrat',2,0,'','','G. Sowerby','49331c6f-10ef-5331-8577-1327a4c95a89','Tellina brevirostrata G. Sowerby, 1867','G. Sowerby, 1867','UNRANKED','','Tellina','','brevirostrata','','','',NULL,'','','','','','G. Sowerby','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04280','','','Amphidesma brevirostrum Hupe, 1854',1,'Amphidesma brevirostrum','Amphidesma brevirostrum','Amphidesma breuirostr',2,0,'','','Hupe','860cd11e-6f0e-5471-8699-a2ad8a19ec9d','Amphidesma brevirostrum Hupe, 1854','Hupe, 1854','UNRANKED','','Amphidesma','','brevirostrum','','','',NULL,'','','','','','Hupe','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04283','','','Brachytrema brevis Piette, 1856',1,'Brachytrema brevis','Brachytrema brevis','Brachytrema breu',2,0,'','','Piette','367eca87-cbea-55c1-b853-db6a203b5683','Brachytrema brevis Piette, 1856','Piette, 1856','UNRANKED','','Brachytrema','','brevis','','','',NULL,'','','','','','Piette','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04289','','','Cylindrites brevis Gabb, 1864',1,'Cylindrites brevis','Cylindrites brevis','Cylindrites breu',2,0,'','','Gabb','1fd7007c-58af-593a-aee6-c41e8f99db15','Cylindrites brevis Gabb, 1864','Gabb, 1864','UNRANKED','','Cylindrites','','brevis','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04296','','','Melampus brevis Gassies, 1863',1,'Melampus brevis','Melampus brevis','Melampus breu',2,0,'','','Gassies','6791cc01-5e6c-5d92-8ae6-6859cdb5e785','Melampus brevis Gassies, 1863','Gassies, 1863','UNRANKED','','Melampus','','brevis','','','',NULL,'','','','','','Gassies','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04300','','','Persephona brevis Leach, in J. Gray, 1852',2,'Persephona brevis','Persephona brevis','Persephona breu',2,0,'','','Leach|J. Gray','ff79b799-3579-56c0-acfb-01281d800bb0','Persephona brevis Leach, in J. Gray, 1852','Leach, in J. Gray, 1852','UNRANKED','','Persephona','','brevis','','','',NULL,'','','','','','Leach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04307','','','Subulites brevis Winchell and Marcy, 1865',1,'Subulites brevis','Subulites brevis','Subulites breu',2,0,'','','Winchell|Marcy','cae00a66-d01b-5327-9e14-0da7d1af11ef','Subulites brevis Winchell and Marcy, 1865','Winchell and Marcy, 1865','UNRANKED','','Subulites','','brevis','','','',NULL,'','','','','','Winchell & Marcy','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04312','','','Teredo (Xylotria) brevis Deshayes, 1863',1,'Teredo brevis','Teredo brevis','Teredo breu',2,0,'','','Deshayes','1f00ebe1-2928-52d4-a9f1-2e86c758b894','Teredo (Xylotria) brevis Deshayes, 1863','Deshayes, 1863','UNRANKED','','Teredo','Xylotria','brevis','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04315','','','Helix breviseta Pfeiffer, 1862',1,'Helix breviseta','Helix breviseta','Helix breuiset',2,0,'','','Pfeiffer','0088ba45-1ca1-5af4-a777-925885c37ce0','Helix breviseta Pfeiffer, 1862','Pfeiffer, 1862','UNRANKED','','Helix','','breviseta','','','',NULL,'','','','','','Pfeiffer','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04320','','','Melania brevispira Anthony, in Gould, 1851',2,'Melania brevispira','Melania brevispira','Melania breuispir',2,0,'','','Anthony|Gould','a6996b4b-6dec-550c-bcd6-f846dcc98ac0','Melania brevispira Anthony, in Gould, 1851','Anthony, in Gould, 1851','UNRANKED','','Melania','','brevispira','','','',NULL,'','','','','','Anthony','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04327','','','Macrochilus brevispiratus McCoy, 1853',1,'Macrochilus brevispiratus','Macrochilus brevispiratus','Macrochilus breuispirat',2,0,'','','McCoy','fac33c62-204e-54cb-8093-825a41a8f828','Macrochilus brevispiratus McCoy, 1853','McCoy, 1853','UNRANKED','','Macrochilus','','brevispiratus','','','',NULL,'','','','','','McCoy','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04330','','','Hydrocena brevissima Mousson, 1870',1,'Hydrocena brevissima','Hydrocena brevissima','Hydrocena breuissim',2,0,'','','Mousson','46e98779-5e3e-5336-a472-966cecb1db2f','Hydrocena brevissima Mousson, 1870','Mousson, 1870','UNRANKED','','Hydrocena','','brevissima','','','',NULL,'','','','','','Mousson','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04333','','','Erycina breviuscula Deshayes, 1858',1,'Erycina breviuscula','Erycina breviuscula','Erycina breuiuscul',2,0,'','','Deshayes','2c1edf66-78eb-51f7-aa33-4d817633b1d8','Erycina breviuscula Deshayes, 1858','Deshayes, 1858','UNRANKED','','Erycina','','breviuscula','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04339','','','Pinna brewerii Gabb, 1864',1,'Pinna brewerii','Pinna brewerii','Pinna brewer',2,0,'','','Gabb','136b6066-b7e6-5c03-a46c-82580c91ec20','Pinna brewerii Gabb, 1864','Gabb, 1864','UNRANKED','','Pinna','','brewerii','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04341','','','Zizyphinus brianii Conrad, 1868',1,'Zizyphinus brianii','Zizyphinus brianii','Zizyphinus brian',2,0,'','','Conrad','26b771cf-306c-561c-a121-c0c8bfa1a3b0','Zizyphinus brianii Conrad, 1868','Conrad, 1868','UNRANKED','','Zizyphinus','','brianii','','','',NULL,'','','','','','Conrad','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04346','','','Anodonta bridgesii Lea, 1868',1,'Anodonta bridgesii','Anodonta bridgesii','Anodonta bridges',2,0,'','','Lea','c4d96ed8-3878-518e-b520-bbd18ae84ed4','Anodonta bridgesii Lea, 1868','Lea, 1868','UNRANKED','','Anodonta','','bridgesii','','','',NULL,'','','','','','Lea','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04347','','','Columbella bridgesii Reeve, 1858',1,'Columbella bridgesii','Columbella bridgesii','Columbella bridges',2,0,'','','Reeve','7817e3e9-a0fb-5895-8d82-dc7298e2e3c0','Columbella bridgesii Reeve, 1858','Reeve, 1858','UNRANKED','','Columbella','','bridgesii','','','',NULL,'','','','','','Reeve','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04352','','','Vermetus (Aletes) centiquadrus bridgesii Mörch, 1861',1,'Vermetus centiquadrus bridgesii','Vermetus centiquadrus bridgesii','Vermetus centiquadr bridges',3,0,'','','Mörch','546ab609-353b-5cf4-9705-85400cf6554c','Vermetus (Aletes) centiquadrus bridgesii Mörch, 1861','Mörch, 1861','UNRANKED','','Vermetus','','centiquadrus','bridgesii','','',NULL,'','','','','','Mörch','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04361','','','Pterinea brisa Hall, 1868',1,'Pterinea brisa','Pterinea brisa','Pterinea bris',2,0,'','','Hall','9a98d5f7-a2ee-5903-8947-36f184ed93ef','Pterinea brisa Hall, 1868','Hall, 1868','UNRANKED','','Pterinea','','brisa','','','',NULL,'','','','','','Hall','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04365','','','Doris britannica Leach, in J. Gray, 1852',2,'Doris britannica','Doris britannica','Doris britannic',2,0,'','','Leach|J. Gray','e468404c-b0bf-51ad-b377-9f02d1f1a694','Doris britannica Leach, in J. Gray, 1852','Leach, in J. Gray, 1852','UNRANKED','','Doris','','britannica','','','',NULL,'','','','','','Leach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04371','','','Cardium brocchii Mayer, 1866',1,'Cardium brocchii','Cardium brocchii','Cardium brocch',2,0,'','','Mayer','b524e596-2d77-5ab7-96ad-1b8d517b735f','Cardium brocchii Mayer, 1866','Mayer, 1866','UNRANKED','','Cardium','','brocchii','','','',NULL,'','','','','','Mayer','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04376','','','Modiola brocchii Mayer, in Hörnes, 1868',2,'Modiola brocchii','Modiola brocchii','Modiola brocch',2,0,'','','Mayer|Hörnes','457f5ef4-d6e4-5b7b-af7c-6b96c99d4a1c','Modiola brocchii Mayer, in Hörnes, 1868','Mayer, in Hörnes, 1868','UNRANKED','','Modiola','','brocchii','','','',NULL,'','','','','','Mayer','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04381','','','Helix brocchiana Calcara, in Benoit, 1859',2,'Helix brocchiana','Helix brocchiana','Helix brocchian',2,0,'','','Calcara|Benoit','95f87797-d202-5c9d-bfa2-92f58fa0322a','Helix brocchiana Calcara, in Benoit, 1859','Calcara, in Benoit, 1859','UNRANKED','','Helix','','brocchiana','','','',NULL,'','','','','','Calcara','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04386','','','Fissurella brodiei Lycett, 1850',1,'Fissurella brodiei','Fissurella brodiei','Fissurella brodie',2,0,'','','Lycett','fc3d77ff-4b82-5caa-a49f-2e987e2da1de','Fissurella brodiei Lycett, 1850','Lycett, 1850','UNRANKED','','Fissurella','','brodiei','','','',NULL,'','','','','','Lycett','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04388','','','Ostrea broliensis Buvignier, 1852',1,'Ostrea broliensis','Ostrea broliensis','Ostrea broliens',2,0,'','','Buvignier','d6bb0076-ee1d-5db8-8abe-e0884671bb1f','Ostrea broliensis Buvignier, 1852','Buvignier, 1852','UNRANKED','','Ostrea','','broliensis','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04391','','','Ancylus brondeli Bourguignat, 1862',1,'Ancylus brondeli','Ancylus brondeli','Ancylus brondel',2,0,'','','Bourguignat','8c0256b6-7edf-56b1-861d-468ef2857ce5','Ancylus brondeli Bourguignat, 1862','Bourguignat, 1862','UNRANKED','','Ancylus','','brondeli','','','',NULL,'','','','','','Bourguignat','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04394','','','Hydrobia brondeli Bourguignat, 1862',1,'Hydrobia brondeli','Hydrobia brondeli','Hydrobia brondel',2,0,'','','Bourguignat','abb82405-7a5f-59f8-8961-64f0830bd9b5','Hydrobia brondeli Bourguignat, 1862','Bourguignat, 1862','UNRANKED','','Hydrobia','','brondeli','','','',NULL,'','','','','','Bourguignat','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04401','','','Helix brongnarti Deshayes, 1863',1,'Helix brongnarti','Helix brongnarti','Helix brongnart',2,0,'','','Deshayes','bb62ced0-5f79-5e76-ab13-177b39504b8e','Helix brongnarti Deshayes, 1863','Deshayes, 1863','UNRANKED','','Helix','','brongnarti','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04405','','','Cypricardia brongniarti Bayan, 1870',1,'Cypricardia brongniarti','Cypricardia brongniarti','Cypricardia brongniart',2,0,'','','Bayan','1ddb69d9-c362-5eec-bf55-1a3ddd55fc44','Cypricardia brongniarti Bayan, 1870','Bayan, 1870','UNRANKED','','Cypricardia','','brongniarti','','','',NULL,'','','','','','Bayan','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04410','','','Lucina brongniarti Deshayes, 1857',1,'Lucina brongniarti','Lucina brongniarti','Lucina brongniart',2,0,'','','Deshayes','a080a23e-d5f7-53c4-b8e0-1edf9e4d9c94','Lucina brongniarti Deshayes, 1857','Deshayes, 1857','UNRANKED','','Lucina','','brongniarti','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04412','','','Pectunculus brongniarti Mayer, 1868',1,'Pectunculus brongniarti','Pectunculus brongniarti','Pectunculus brongniart',2,0,'','','Mayer','b2c3cba3-9ef5-50fe-9363-24041b2e68e9','Pectunculus brongniarti Mayer, 1868','Mayer, 1868','UNRANKED','','Pectunculus','','brongniarti','','','',NULL,'','','','','','Mayer','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04416','','','Lima bronni Alth, 1850',1,'Lima bronni','Lima bronni','Lima bronn',2,0,'','','Alth','eb3e0599-717e-5f43-a902-58cbb12a4d1f','Lima bronni Alth, 1850','Alth, 1850','UNRANKED','','Lima','','bronni','','','',NULL,'','','','','','Alth','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04420','','','Neritina bronni Ancona, 1869',1,'Neritina bronni','Neritina bronni','Neritina bronn',2,0,'','','Ancona','10f62361-b4c9-5a05-b7d9-66157db8830d','Neritina bronni Ancona, 1869','Ancona, 1869','UNRANKED','','Neritina','','bronni','','','',NULL,'','','','','','Ancona','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04423','','','Pecten bronni Mayer, 1861',1,'Pecten bronni','Pecten bronni','Pecten bronn',2,0,'','','Mayer','d3516e01-e16a-56b5-a695-06bc84d0f87d','Pecten bronni Mayer, 1861','Mayer, 1861','UNRANKED','','Pecten','','bronni','','','',NULL,'','','','','','Mayer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04428','','','Trigonocoelia bronni Mayer, 1868',1,'Trigonocoelia bronni','Trigonocoelia bronni','Trigonocoelia bronn',2,0,'','','Mayer','b764a92a-d545-5e1b-aaa6-e9f2760c39d9','Trigonocoelia bronni Mayer, 1868','Mayer, 1868','UNRANKED','','Trigonocoelia','','bronni','','','',NULL,'','','','','','Mayer','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04433','','','Leda brookii Hanley, 1860',1,'Leda brookii','Leda brookii','Leda brook',2,0,'','','Hanley','b7eacb4a-7a18-54b3-af98-65506329d95b','Leda brookii Hanley, 1860','Hanley, 1860','UNRANKED','','Leda','','brookii','','','',NULL,'','','','','','Hanley','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04436','','','Conus broteri P. Costa, 1866',1,'Conus broteri','Conus broteri','Conus broter',2,0,'','','P. Costa','40189fdd-92a3-57e3-9621-dd6c18f21f18','Conus broteri P. Costa, 1866','P. Costa, 1866','UNRANKED','','Conus','','broteri','','','',NULL,'','','','','','P. Costa','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04439','','','Melampus brotianus Pfeiffer, 1859',1,'Melampus brotianus','Melampus brotianus','Melampus brotian',2,0,'','','Pfeiffer','9197b8b3-b35b-55c7-8a8f-a9b40ca2be1b','Melampus brotianus Pfeiffer, 1859','Pfeiffer, 1859','UNRANKED','','Melampus','','brotianus','','','',NULL,'','','','','','Pfeiffer','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04443','','','Limnaea brownii Tryon, 1865',1,'Limnaea brownii','Limnaea brownii','Limnaea brown',2,0,'','','Tryon','5401795b-a990-5413-918f-8c62910a554b','Limnaea brownii Tryon, 1865','Tryon, 1865','UNRANKED','','Limnaea','','brownii','','','',NULL,'','','','','','Tryon','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04450','','','Buccinum bruckneri Beyrich, 1854',1,'Buccinum bruckneri','Buccinum bruckneri','Buccinum bruckner',2,0,'','','Beyrich','53a3686a-0311-5ed3-96a7-ac718e6951cb','Buccinum bruckneri Beyrich, 1854','Beyrich, 1854','UNRANKED','','Buccinum','','bruckneri','','','',NULL,'','','','','','Beyrich','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04456','','','Vitrina brumalis Morelet, 1860',1,'Vitrina brumalis','Vitrina brumalis','Vitrina brumal',2,0,'','','Morelet','256aa320-c308-5f40-94ca-50020df29f7c','Vitrina brumalis Morelet, 1860','Morelet, 1860','UNRANKED','','Vitrina','','brumalis','','','',NULL,'','','','','','Morelet','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04465','','','Corbicula brunnea Prime, 1864',1,'Corbicula brunnea','Corbicula brunnea','Corbicula brunne',2,0,'','','Prime','e1a2d879-b4db-5857-8638-20a42b3053b1','Corbicula brunnea Prime, 1864','Prime, 1864','UNRANKED','','Corbicula','','brunnea','','','',NULL,'','','','','','Prime','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04469','','','Helix pomatia brunnea A. Moquin-Tandon, 1855',1,'Helix pomatia brunnea','Helix pomatia brunnea','Helix pomat brunne',3,0,'','','A. Moquin-Tandon','3d7e9b18-cf3f-50e4-b495-ee6fc30f9227','Helix pomatia brunnea A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','pomatia','brunnea','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04474','','','Cytherea brunneri Mayer, 1861',1,'Cytherea brunneri','Cytherea brunneri','Cytherea brunner',2,0,'','','Mayer','c7eb128a-86d3-5e30-ac55-8501a04ddec6','Cytherea brunneri Mayer, 1861','Mayer, 1861','UNRANKED','','Cytherea','','brunneri','','','',NULL,'','','','','','Mayer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04478','','','Melania brunnescens Tryon, 1865',1,'Melania brunnescens','Melania brunnescens','Melania brunnescens',2,0,'','','Tryon','e3b0e7b4-3196-52d2-91c4-4395bef16580','Melania brunnescens Tryon, 1865','Tryon, 1865','UNRANKED','','Melania','','brunnescens','','','',NULL,'','','','','','Tryon','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04484','','','Clausilia (Medora) brusinae Kutschig, in Brusina, 1866',2,'Clausilia brusinae','Clausilia brusinae','Clausilia brusin',2,0,'','','Kutschig|Brusina','d865ac17-6b61-510c-8dd8-0e62f5a8e12a','Clausilia (Medora) brusinae Kutschig, in Brusina, 1866','Kutschig, in Brusina, 1866','UNRANKED','','Clausilia','Medora','brusinae','','','',NULL,'','','','','','Kutschig','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04490','','','Zonites bryodes Shuttleworth, 1854',1,'Zonites bryodes','Zonites bryodes','Zonites bryod',2,0,'','','Shuttleworth','34591e63-7dff-5047-adc1-b3e3ed3406ea','Zonites bryodes Shuttleworth, 1854','Shuttleworth, 1854','UNRANKED','','Zonites','','bryodes','','','',NULL,'','','','','','Shuttleworth','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04496','','','Brachytrema buccinoidea Lycett, 1863',1,'Brachytrema buccinoidea','Brachytrema buccinoidea','Brachytrema buccinoide',2,0,'','','Lycett','400924e0-6f2e-5722-bb0f-213a4cf06bb9','Brachytrema buccinoidea Lycett, 1863','Lycett, 1863','UNRANKED','','Brachytrema','','buccinoidea','','','',NULL,'','','','','','Lycett','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04499','','','Hemisinus buccinoides Reeve, 1860',1,'Hemisinus buccinoides','Hemisinus buccinoides','Hemisinus buccinoid',2,0,'','','Reeve','4dacbe32-35b5-5242-9ee4-5e9ce401d176','Hemisinus buccinoides Reeve, 1860','Reeve, 1860','UNRANKED','','Hemisinus','','buccinoides','','','',NULL,'','','','','','Reeve','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04507','','','Cytherea bucculenta E. Römer, 1869',1,'Cytherea bucculenta','Cytherea bucculenta','Cytherea bucculent',2,0,'','','E. Römer','31e0db44-8c89-5884-93d3-9cb0eac4d80d','Cytherea bucculenta E. Römer, 1869','E. Römer, 1869','UNRANKED','','Cytherea','','bucculenta','','','',NULL,'','','','','','E. Römer','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04509','','','Platyceras bucculentum Hall, 1862',1,'Platyceras bucculentum','Platyceras bucculentum','Platyceras bucculent',2,0,'','','Hall','4cad5235-fc16-5133-a07e-fe545331e47c','Platyceras bucculentum Hall, 1862','Hall, 1862','UNRANKED','','Platyceras','','bucculentum','','','',NULL,'','','','','','Hall','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04514','','','Turbo buchii Archiac, 1850',1,'Turbo buchii','Turbo buchii','Turbo buch',2,0,'','','Archiac','b38cfdf9-3131-57ab-afb6-5be595607d71','Turbo buchii Archiac, 1850','Archiac, 1850','UNRANKED','','Turbo','','buchii','','','',NULL,'','','','','','Archiac','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04516','','','Cardium buckmani Morris and Lycett, 1853',1,'Cardium buckmani','Cardium buckmani','Cardium buckman',2,0,'','','Morris|Lycett','acd3fbb2-8536-549d-8190-b165c3778efe','Cardium buckmani Morris and Lycett, 1853','Morris and Lycett, 1853','UNRANKED','','Cardium','','buckmani','','','',NULL,'','','','','','Morris & Lycett','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04520','','','Helix buddiana C.B. Adams, 1851',1,'Helix buddiana','Helix buddiana','Helix buddian',2,0,'','','C. B. Adams','c79a2e6b-bee2-597b-97b2-d66717c0cff9','Helix buddiana C.B. Adams, 1851','C.B. Adams, 1851','UNRANKED','','Helix','','buddiana','','','',NULL,'','','','','','C. B. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04524','','','Campylaea coerulans bukovicana Brusina, 1869',1,'Campylaea coerulans bukovicana','Campylaea coerulans bukovicana','Campylaea coerulans bukouican',3,0,'','','Brusina','c5106672-60c7-5ac3-b45c-5cd463714fa9','Campylaea coerulans bukovicana Brusina, 1869','Brusina, 1869','UNRANKED','','Campylaea','','coerulans','bukovicana','','',NULL,'','','','','','Brusina','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04532','','','Marginella bulbosa Reeve, 1865',1,'Marginella bulbosa','Marginella bulbosa','Marginella bulbos',2,0,'','','Reeve','4239b2ef-65af-5240-a3c3-653c37e0400e','Marginella bulbosa Reeve, 1865','Reeve, 1865','UNRANKED','','Marginella','','bulbosa','','','',NULL,'','','','','','Reeve','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04534','','','Petricola bulbosa Gould, 1851',1,'Petricola bulbosa','Petricola bulbosa','Petricola bulbos',2,0,'','','Gould','550f8121-0e7e-5e0d-8e16-e64627bf9df2','Petricola bulbosa Gould, 1851','Gould, 1851','UNRANKED','','Petricola','','bulbosa','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04541','','','Bulimella bulimiformis Hall, 1858',1,'Bulimella bulimiformis','Bulimella bulimiformis','Bulimella bulimiform',2,0,'','','Hall','b914c7fb-42f1-5b93-9d66-2c5645011d95','Bulimella bulimiformis Hall, 1858','Hall, 1858','UNRANKED','','Bulimella','','bulimiformis','','','',NULL,'','','','','','Hall','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04545','','','Eulima bulimoides Coquand, 1859',1,'Eulima bulimoides','Eulima bulimoides','Eulima bulimoid',2,0,'','','Coquand','2f4242ef-3fb8-5aa6-b45c-ec79da4ccfe7','Eulima bulimoides Coquand, 1859','Coquand, 1859','UNRANKED','','Eulima','','bulimoides','','','',NULL,'','','','','','Coquand','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04553','','','Pterodonta bulimoides Ryckholt, 1860',1,'Pterodonta bulimoides','Pterodonta bulimoides','Pterodonta bulimoid',2,0,'','','Ryckholt','3d226235-8f2b-5740-9385-55c55aeb15ab','Pterodonta bulimoides Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Pterodonta','','bulimoides','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04558','','','Crenella bulla Dunker, 1856',1,'Crenella bulla','Crenella bulla','Crenella bull',2,0,'','','Dunker','e2ffe348-5fc0-5678-9ffa-40c5acaf3d3e','Crenella bulla Dunker, 1856','Dunker, 1856','UNRANKED','','Crenella','','bulla','','','',NULL,'','','','','','Dunker','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04564','','','Helix bullacea Pfeiffer, 1854',1,'Helix bullacea','Helix bullacea','Helix bullace',2,0,'','','Pfeiffer','11d1b79f-244c-54d7-a8ef-154f54479237','Helix bullacea Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Helix','','bullacea','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04569','','','Cytheraea bullata G. Sowerby, 1851',1,'Cytheraea bullata','Cytheraea bullata','Cytheraea bullat',2,0,'','','G. Sowerby','09a940ee-549c-5f66-bc9b-8ff1ad34da8f','Cytheraea bullata G. Sowerby, 1851','G. Sowerby, 1851','UNRANKED','','Cytheraea','','bullata','','','',NULL,'','','','','','G. Sowerby','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04576','','','Opalia bullata P. Carpenter, 1864',1,'Opalia bullata','Opalia bullata','Opalia bullat',2,0,'','','P. Carpenter','5b041c35-aa1a-5308-983e-1d43eab495a4','Opalia bullata P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Opalia','','bullata','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04581','','','Amphiperas bullatus Gould, 1860',1,'Amphiperas bullatus','Amphiperas bullatus','Amphiperas bullat',2,0,'','','Gould','e65b9ec6-cdc3-5404-aab1-23905d929475','Amphiperas bullatus Gould, 1860','Gould, 1860','UNRANKED','','Amphiperas','','bullatus','','','',NULL,'','','','','','Gould','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04584','','','Hipponix bullii Tuomey and Holmes, 1856',1,'Hipponix bullii','Hipponix bullii','Hipponix bull',2,0,'','','Tuomey|Holmes','807d8c20-6535-5df9-8b96-0a8fafc7cb2f','Hipponix bullii Tuomey and Holmes, 1856','Tuomey and Holmes, 1856','UNRANKED','','Hipponix','','bullii','','','',NULL,'','','','','','Tuomey & Holmes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04589','','','Melania bullioides Reeve, 1859',1,'Melania bullioides','Melania bullioides','Melania bullioid',2,0,'','','Reeve','d161cad3-acd0-576e-8705-45766b759b42','Melania bullioides Reeve, 1859','Reeve, 1859','UNRANKED','','Melania','','bullioides','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04593','','','Melania bullula Lea, 1861',1,'Melania bullula','Melania bullula','Melania bullul',2,0,'','','Lea','e37b08d8-2af7-5eda-b146-d1bed6bf9aef','Melania bullula Lea, 1861','Lea, 1861','UNRANKED','','Melania','','bullula','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04596','','','Tellina bullula Deshayes, 1857',1,'Tellina bullula','Tellina bullula','Tellina bullul',2,0,'','','Deshayes','5d58512f-61c2-518a-b21c-c390c59ab0bf','Tellina bullula Deshayes, 1857','Deshayes, 1857','UNRANKED','','Tellina','','bullula','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04604','','','Terebellum burdenii Tuomey and Holmes, 1856',1,'Terebellum burdenii','Terebellum burdenii','Terebellum burden',2,0,'','','Tuomey|Holmes','cb3cf8ac-b86a-5b06-a16f-15283999759b','Terebellum burdenii Tuomey and Holmes, 1856','Tuomey and Holmes, 1856','UNRANKED','','Terebellum','','burdenii','','','',NULL,'','','','','','Tuomey & Holmes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04611','','','Mactra burdigalensis Mayer, 1864',1,'Mactra burdigalensis','Mactra burdigalensis','Mactra burdigalens',2,0,'','','Mayer','7b19fef9-2410-59cb-a719-0addc0f1a6e1','Mactra burdigalensis Mayer, 1864','Mayer, 1864','UNRANKED','','Mactra','','burdigalensis','','','',NULL,'','','','','','Mayer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04616','','','Testacella burdigalensis Gassies, in Grateloup, 1855',2,'Testacella burdigalensis','Testacella burdigalensis','Testacella burdigalens',2,0,'','','Gassies|Grateloup','b6463a6a-2f2e-5003-931c-55059ce3dad7','Testacella burdigalensis Gassies, in Grateloup, 1855','Gassies, in Grateloup, 1855','UNRANKED','','Testacella','','burdigalensis','','','',NULL,'','','','','','Gassies','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04622','','','Paludina burgundina Tournouer, 1866',1,'Paludina burgundina','Paludina burgundina','Paludina burgundin',2,0,'','','Tournouer','e31015c7-c831-51ec-a49a-c16826ee9881','Paludina burgundina Tournouer, 1866','Tournouer, 1866','UNRANKED','','Paludina','','burgundina','','','',NULL,'','','','','','Tournouer','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04626','','','Aviculopecten burlingtonensis Meek and Worthen, 1860',1,'Aviculopecten burlingtonensis','Aviculopecten burlingtonensis','Aviculopecten burlingtonens',2,0,'','','Meek|Worthen','d9318c4e-a098-5509-9bc9-f30bb6e6e91b','Aviculopecten burlingtonensis Meek and Worthen, 1860','Meek and Worthen, 1860','UNRANKED','','Aviculopecten','','burlingtonensis','','','',NULL,'','','','','','Meek & Worthen','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04631','','','Streptaxis burmanica W. Blanford, 1865',1,'Streptaxis burmanica','Streptaxis burmanica','Streptaxis burmanic',2,0,'','','W. Blanford','72d71e82-95bd-558e-8415-30ff77a68465','Streptaxis burmanica W. Blanford, 1865','W. Blanford, 1865','UNRANKED','','Streptaxis','','burmanica','','','',NULL,'','','','','','W. Blanford','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04636','','','Teredo burtini Deshayes, in Ryckholt, 1852',2,'Teredo burtini','Teredo burtini','Teredo burtin',2,0,'','','Deshayes|Ryckholt','323dd24e-132c-5a8a-b744-5155b9badded','Teredo burtini Deshayes, in Ryckholt, 1852','Deshayes, in Ryckholt, 1852','UNRANKED','','Teredo','','burtini','','','',NULL,'','','','','','Deshayes','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04640','','','Trochus burtonensis Lycett, 1863',1,'Trochus burtonensis','Trochus burtonensis','Trochus burtonens',2,0,'','','Lycett','a7d5eadd-2bc5-5f9b-a9c5-df61adeaacb1','Trochus burtonensis Lycett, 1863','Lycett, 1863','UNRANKED','','Trochus','','burtonensis','','','',NULL,'','','','','','Lycett','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04643','','','Helix unguiculastra buruensis Martens, 1867',1,'Helix unguiculastra buruensis','Helix unguiculastra buruensis','Helix unguiculastr buruens',3,0,'','','Martens','a76d71bd-a447-5a2b-b7cb-9279a1db128e','Helix unguiculastra buruensis Martens, 1867','Martens, 1867','UNRANKED','','Helix','','unguiculastra','buruensis','','',NULL,'','','','','','Martens','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04649','','','Spondylus butleri Reeve, 1856',1,'Spondylus butleri','Spondylus butleri','Spondylus butler',2,0,'','','Reeve','4e3e3e8d-2985-5336-867c-d8862d4d898d','Spondylus butleri Reeve, 1856','Reeve, 1856','UNRANKED','','Spondylus','','butleri','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04653','','','Brachytrema buvignieri Morris and Lycett, 1854',1,'Brachytrema buvignieri','Brachytrema buvignieri','Brachytrema buuignier',2,0,'','','Morris|Lycett','98ababa0-d7e8-5b17-8165-27d5029c500c','Brachytrema buvignieri Morris and Lycett, 1854','Morris and Lycett, 1854','UNRANKED','','Brachytrema','','buvignieri','','','',NULL,'','','','','','Morris & Lycett','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04657','','','Orthostoma buvignieri Loriol, in Loriol and Pellat, 1867',2,'Orthostoma buvignieri','Orthostoma buvignieri','Orthostoma buuignier',2,0,'','','Loriol|Pellat','e459c3bf-d98c-5d55-a260-aab9d064884f','Orthostoma buvignieri Loriol, in Loriol and Pellat, 1867','Loriol, in Loriol and Pellat, 1867','UNRANKED','','Orthostoma','','buvignieri','','','',NULL,'','','','','','Loriol','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04664','','','Conularia byblis White, 1862',1,'Conularia byblis','Conularia byblis','Conularia bybl',2,0,'','','White','6b197e08-4b8d-58bb-a269-8cd3c962aa6f','Conularia byblis White, 1862','White, 1862','UNRANKED','','Conularia','','byblis','','','',NULL,'','','','','','White','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04669','','','Helix cabriti Gassies, 1863',1,'Helix cabriti','Helix cabriti','Helix cabrit',2,0,'','','Gassies','cd1ad18b-f08c-5b49-8d57-a507c0b78cd2','Helix cabriti Gassies, 1863','Gassies, 1863','UNRANKED','','Helix','','cabriti','','','',NULL,'','','','','','Gassies','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04674','','','Cancellaria cacellensis P. Costa, 1867',1,'Cancellaria cacellensis','Cancellaria cacellensis','Cancellaria cacellens',2,0,'','','P. Costa','0f2b3e03-1858-5ce8-a56a-58af906c03b7','Cancellaria cacellensis P. Costa, 1867','P. Costa, 1867','UNRANKED','','Cancellaria','','cacellensis','','','',NULL,'','','','','','P. Costa','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04679','','','Ostrea caderensis Coquand, 1869',1,'Ostrea caderensis','Ostrea caderensis','Ostrea caderens',2,0,'','','Coquand','73f8c09c-096d-5d54-a456-9795f63b92f8','Ostrea caderensis Coquand, 1869','Coquand, 1869','UNRANKED','','Ostrea','','caderensis','','','',NULL,'','','','','','Coquand','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04685','','','Helix caecilia Pfeiffer, 1855',1,'Helix caecilia','Helix caecilia','Helix caecil',2,0,'','','Pfeiffer','46cbbbe8-c7e8-51ac-a75c-151d0c2e3cac','Helix caecilia Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Helix','','caecilia','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04690','','','Bulla caelata Deshayes, 1862',1,'Bulla caelata','Bulla caelata','Bulla caelat',2,0,'','','Deshayes','603e69d2-5118-5138-9827-b3af8c79cd61','Bulla caelata Deshayes, 1862','Deshayes, 1862','UNRANKED','','Bulla','','caelata','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04694','','','Melania caelata Deshayes, 1862',1,'Melania caelata','Melania caelata','Melania caelat',2,0,'','','Deshayes','ad9f0d69-f1f8-5a1b-9adf-75c7e2066a61','Melania caelata Deshayes, 1862','Deshayes, 1862','UNRANKED','','Melania','','caelata','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04699','','','Turritella (Torcula) caelata Mörch, in Dunker, 1867',2,'Turritella caelata','Turritella caelata','Turritella caelat',2,0,'','','Mörch|Dunker','bbce66c5-6a94-5306-b8b5-f3c08827e016','Turritella (Torcula) caelata Mörch, in Dunker, 1867','Mörch, in Dunker, 1867','UNRANKED','','Turritella','Torcula','caelata','','','',NULL,'','','','','','Mörch','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04706','','','Conus caelatus A. Adams, 1853',1,'Conus caelatus','Conus caelatus','Conus caelat',2,0,'','','A. Adams','02f621d5-4761-5d85-af3d-8a4b30a5b936','Conus caelatus A. Adams, 1853','A. Adams, 1853','UNRANKED','','Conus','','caelatus','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04712','','','Elysia caerulea Kelaart, 1859',1,'Elysia caerulea','Elysia caerulea','Elysia caerule',2,0,'','','Kelaart','8418e093-3807-576d-a0ad-f7de53372d49','Elysia caerulea Kelaart, 1859','Kelaart, 1859','UNRANKED','','Elysia','','caerulea','','','',NULL,'','','','','','Kelaart','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04715','','','Helix (Geotrochus) caerulescens Angas, 1869',1,'Helix caerulescens','Helix caerulescens','Helix caerulescens',2,0,'','','Angas','7235171d-c36f-5f0f-bf50-1c80cb773559','Helix (Geotrochus) caerulescens Angas, 1869','Angas, 1869','UNRANKED','','Helix','Geotrochus','caerulescens','','','',NULL,'','','','','','Angas','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04717','','','Cerithium caeruleum G. Sowerby, 1855',1,'Cerithium caeruleum','Cerithium caeruleum','Cerithium caerule',2,0,'','','G. Sowerby','6b32d97d-8b38-5edb-9dae-8ae588eb2c2d','Cerithium caeruleum G. Sowerby, 1855','G. Sowerby, 1855','UNRANKED','','Cerithium','','caeruleum','','','',NULL,'','','','','','G. Sowerby','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04723','','','Ptychostylis caffea Gabb, 1865',1,'Ptychostylis caffea','Ptychostylis caffea','Ptychostylis caffe',2,0,'','','Gabb','0093499a-9242-53fd-be96-83f7c03969a2','Ptychostylis caffea Gabb, 1865','Gabb, 1865','UNRANKED','','Ptychostylis','','caffea','','','',NULL,'','','','','','Gabb','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04727','','','Arca caillati Deshayes, 1860',1,'Arca caillati','Arca caillati','Arca caillat',2,0,'','','Deshayes','ae782138-c5de-5b91-b26b-372021ec31ce','Arca caillati Deshayes, 1860','Deshayes, 1860','UNRANKED','','Arca','','caillati','','','',NULL,'','','','','','Deshayes','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04729','','','Clavagella caillati Deshayes, 1856',1,'Clavagella caillati','Clavagella caillati','Clavagella caillat',2,0,'','','Deshayes','3e2de85e-aa94-5dab-b619-5cd2fd2fd2e9','Clavagella caillati Deshayes, 1856','Deshayes, 1856','UNRANKED','','Clavagella','','caillati','','','',NULL,'','','','','','Deshayes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04735','','','Natica caillati Deshayes, 1864',1,'Natica caillati','Natica caillati','Natica caillat',2,0,'','','Deshayes','62a2ae24-424f-54f9-8de2-4597a7e15b13','Natica caillati Deshayes, 1864','Deshayes, 1864','UNRANKED','','Natica','','caillati','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04738','','','Sportella caillati Deshayes, 1857',1,'Sportella caillati','Sportella caillati','Sportella caillat',2,0,'','','Deshayes','bca842ae-54a9-54e0-af9c-8dc7e152f9ad','Sportella caillati Deshayes, 1857','Deshayes, 1857','UNRANKED','','Sportella','','caillati','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04741','','','Anodon caillaudii G. Sowerby, 1867',1,'Anodon caillaudii','Anodon caillaudii','Anodon caillaud',2,0,'','','G. Sowerby','e89d835e-5080-51f7-8f5a-1157ed252a88','Anodon caillaudii G. Sowerby, 1867','G. Sowerby, 1867','UNRANKED','','Anodon','','caillaudii','','','',NULL,'','','','','','G. Sowerby','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04747','','','Solarium cailliaudanum Orbigny, 1853',1,'Solarium cailliaudanum','Solarium cailliaudanum','Solarium cailliaudan',2,0,'','','Orbigny','aac1a643-1fa9-5b91-b9bd-64540f93fa9e','Solarium cailliaudanum Orbigny, 1853','Orbigny, 1853','UNRANKED','','Solarium','','cailliaudanum','','','',NULL,'','','','','','Orbigny','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04754','','','Kellia cailliaudii Recluz, 1857',1,'Kellia cailliaudii','Kellia cailliaudii','Kellia cailliaud',2,0,'','','Recluz','ed542d40-fd85-597e-8f69-3d7bdba2d43e','Kellia cailliaudii Recluz, 1857','Recluz, 1857','UNRANKED','','Kellia','','cailliaudii','','','',NULL,'','','','','','Recluz','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04760','','','Crassatella calabra Seguenza, 1866',1,'Crassatella calabra','Crassatella calabra','Crassatella calabr',2,0,'','','Seguenza','0a0796e2-d5a0-5190-b643-8c94d035ec56','Crassatella calabra Seguenza, 1866','Seguenza, 1866','UNRANKED','','Crassatella','','calabra','','','',NULL,'','','','','','Seguenza','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04766','','','Rissoina calariformis Schwartz von Mohrenstern, 1860',1,'Rissoina calariformis','Rissoina calariformis','Rissoina calariform',2,0,'','','Schwartz von Mohrenstern','9d23fc4b-153c-5657-9422-5b105d717a62','Rissoina calariformis Schwartz von Mohrenstern, 1860','Schwartz von Mohrenstern, 1860','UNRANKED','','Rissoina','','calariformis','','','',NULL,'','','','','','Schwartz von Mohrenstern','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04774','','','Delphinula calcar A. Adams, 1850',1,'Delphinula calcar','Delphinula calcar','Delphinula calcar',2,0,'','','A. Adams','920245d6-ba9a-5655-bed9-ac00d4544980','Delphinula calcar A. Adams, 1850','A. Adams, 1850','UNRANKED','','Delphinula','','calcar','','','',NULL,'','','','','','A. Adams','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04777','','','Bornella calcarata Mörch, 1863',1,'Bornella calcarata','Bornella calcarata','Bornella calcarat',2,0,'','','Mörch','5066d449-3f77-5222-8871-b88eea00ef55','Bornella calcarata Mörch, 1863','Mörch, 1863','UNRANKED','','Bornella','','calcarata','','','',NULL,'','','','','','Mörch','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04782','','','Trochus calcarius Dumortier, 1867',1,'Trochus calcarius','Trochus calcarius','Trochus calcar',2,0,'','','Dumortier','b16c4f27-f76c-50be-b639-428467478934','Trochus calcarius Dumortier, 1867','Dumortier, 1867','UNRANKED','','Trochus','','calcarius','','','',NULL,'','','','','','Dumortier','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04789','','','Melania calculoides Lea, 1861',1,'Melania calculoides','Melania calculoides','Melania calculoid',2,0,'','','Lea','c5587e09-daca-5b24-8661-4e4c8431e56e','Melania calculoides Lea, 1861','Lea, 1861','UNRANKED','','Melania','','calculoides','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04795','','','Helix caldwelli Barclay, in Benson, 1859',2,'Helix caldwelli','Helix caldwelli','Helix caldwell',2,0,'','','Barclay|Benson','c0022ec7-6043-5ab5-809f-20ca08a17075','Helix caldwelli Barclay, in Benson, 1859','Barclay, in Benson, 1859','UNRANKED','','Helix','','caldwelli','','','',NULL,'','','','','','Barclay','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04804','','','Leucorhynchia caledonica Crosse, 1867',1,'Leucorhynchia caledonica','Leucorhynchia caledonica','Leucorhynchia caledonic',2,0,'','','Crosse','c5e2b9e9-7ac3-5303-a8db-c000832627fd','Leucorhynchia caledonica Crosse, 1867','Crosse, 1867','UNRANKED','','Leucorhynchia','','caledonica','','','',NULL,'','','','','','Crosse','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04810','','','Tapes caledonica Bernardi, 1856',1,'Tapes caledonica','Tapes caledonica','Tapes caledonic',2,0,'','','Bernardi','dbdc2f52-ea0f-5f50-a426-5d8be098834e','Tapes caledonica Bernardi, 1856','Bernardi, 1856','UNRANKED','','Tapes','','caledonica','','','',NULL,'','','','','','Bernardi','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04816','','','Cardita caliculaeformis Deshayes, 1863',1,'Cardita caliculaeformis','Cardita caliculaeformis','Cardita caliculaeform',2,0,'','','Deshayes','7a07bfdc-e548-502a-a973-a9461c2dab54','Cardita caliculaeformis Deshayes, 1863','Deshayes, 1863','UNRANKED','','Cardita','','caliculaeformis','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04825','','','Aplysia californica J. Cooper, 1863',1,'Aplysia californica','Aplysia californica','Aplysia californic',2,0,'','','J. Cooper','69f3787d-f981-570c-9d89-5ef642a48ffb','Aplysia californica J. Cooper, 1863','J. Cooper, 1863','UNRANKED','','Aplysia','','californica','','','',NULL,'','','','','','J. Cooper','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04830','','','Gundlachia californica Rowell, 1863',1,'Gundlachia californica','Gundlachia californica','Gundlachia californic',2,0,'','','Rowell','1344621d-b9f8-534b-80e2-684990c9ceca','Gundlachia californica Rowell, 1863','Rowell, 1863','UNRANKED','','Gundlachia','','californica','','','',NULL,'','','','','','Rowell','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04835','','','Natica maroccana californica P. Carpenter, 1856',1,'Natica maroccana californica','Natica maroccana californica','Natica maroccan californic',3,0,'','','P. Carpenter','610c7550-036a-574e-a841-421df0fdc296','Natica maroccana californica P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Natica','','maroccana','californica','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04838','','','Pedicularia californica Newcomb, 1864',1,'Pedicularia californica','Pedicularia californica','Pedicularia californic',2,0,'','','Newcomb','49b5c35a-e75e-5460-9837-56bc814a72b2','Pedicularia californica Newcomb, 1864','Newcomb, 1864','UNRANKED','','Pedicularia','','californica','','','',NULL,'','','','','','Newcomb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04842','','','Semele californica A. Adams, 1853',1,'Semele californica','Semele californica','Semele californic',2,0,'','','A. Adams','ac98c841-4451-5c1a-93e3-e9501c0e3f14','Semele californica A. Adams, 1853','A. Adams, 1853','UNRANKED','','Semele','','californica','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04849','','','Chiton californicus Prescott, 1864',1,'Chiton californicus','Chiton californicus','Chiton californic',2,0,'','','Prescott','d73996c8-9a4a-5c03-a332-7b197923bfaa','Chiton californicus Prescott, 1864','Prescott, 1864','UNRANKED','','Chiton','','californicus','','','',NULL,'','','','','','Prescott','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04851','','','Phorcus californicus A. Adams, 1851',1,'Phorcus californicus','Phorcus californicus','Phorcus californic',2,0,'','','A. Adams','01e7a39c-aefe-517c-b911-de516983a776','Phorcus californicus A. Adams, 1851','A. Adams, 1851','UNRANKED','','Phorcus','','californicus','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04855','','','Littorina caliginosa Gould, 1851',1,'Littorina caliginosa','Littorina caliginosa','Littorina caliginos',2,0,'','','Gould','06e72f0f-e594-5abf-8fac-346a2ef20d12','Littorina caliginosa Gould, 1851','Gould, 1851','UNRANKED','','Littorina','','caliginosa','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04858','','','Pecten calisto Orbigny, 1852',1,'Pecten calisto','Pecten calisto','Pecten calist',2,0,'','','Orbigny','d4657595-5699-5732-859e-357a3be9cd1f','Pecten calisto Orbigny, 1852','Orbigny, 1852','UNRANKED','','Pecten','','calisto','','','',NULL,'','','','','','Orbigny','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04863','','','Neritina callifera F. Sandberger, 1863',1,'Neritina callifera','Neritina callifera','Neritina callifer',2,0,'','','F. Sandberger','27da23e6-9f90-51d9-9bd5-94b4d013106c','Neritina callifera F. Sandberger, 1863','F. Sandberger, 1863','UNRANKED','','Neritina','','callifera','','','',NULL,'','','','','','F. Sandberger','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04869','','','Rissoa calliopaea Orbigny, 1852',1,'Rissoa calliopaea','Rissoa calliopaea','Rissoa calliopae',2,0,'','','Orbigny','d85e73e4-670e-5063-a697-bc261b7724f4','Rissoa calliopaea Orbigny, 1852','Orbigny, 1852','UNRANKED','','Rissoa','','calliopaea','','','',NULL,'','','','','','Orbigny','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04877','','','Melania plutonis callosa Mousson, 1870',1,'Melania plutonis callosa','Melania plutonis callosa','Melania pluton callos',3,0,'','','Mousson','501ac07b-a2ed-54ef-b123-f95bfa76ca3f','Melania plutonis callosa Mousson, 1870','Mousson, 1870','UNRANKED','','Melania','','plutonis','callosa','','',NULL,'','','','','','Mousson','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04880','','','Sportella callosa Deshayes, 1857',1,'Sportella callosa','Sportella callosa','Sportella callos',2,0,'','','Deshayes','9abafa21-4709-5657-bcf3-51a7dabe43aa','Sportella callosa Deshayes, 1857','Deshayes, 1857','UNRANKED','','Sportella','','callosa','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04884','','','Nassa (Eione) callospira A. Adams, 1851',1,'Nassa callospira','Nassa callospira','Nassa callospir',2,0,'','','A. Adams','1a790be4-74e8-5479-a9ed-da0c178ca903','Nassa (Eione) callospira A. Adams, 1851','A. Adams, 1851','UNRANKED','','Nassa','Eione','callospira','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04889','','','Pleurotoma calophora Deshayes, 1865',1,'Pleurotoma calophora','Pleurotoma calophora','Pleurotoma calophor',2,0,'','','Deshayes','19ce84ba-19af-5016-8f2d-027c970b2bcc','Pleurotoma calophora Deshayes, 1865','Deshayes, 1865','UNRANKED','','Pleurotoma','','calophora','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04895','','','Helix calpis Benson, 1859',1,'Helix calpis','Helix calpis','Helix calp',2,0,'','','Benson','d886d05f-0a82-50a4-8afb-afd2fb57c7d9','Helix calpis Benson, 1859','Benson, 1859','UNRANKED','','Helix','','calpis','','','',NULL,'','','','','','Benson','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04899','','','Voluta calva J. Sowerby, in Dixon, 1850',2,'Voluta calva','Voluta calva','Voluta calu',2,0,'','','J. Sowerby|Dixon','4d7048e3-1dad-51be-8a44-a216c4609eca','Voluta calva J. Sowerby, in Dixon, 1850','J. Sowerby, in Dixon, 1850','UNRANKED','','Voluta','','calva','','','',NULL,'','','','','','J. Sowerby','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04905','','','Cerithium calvimontanum Deshayes, 1864',1,'Cerithium calvimontanum','Cerithium calvimontanum','Cerithium caluimontan',2,0,'','','Deshayes','aca99f10-39e9-5b7f-a97b-d6251911a0ea','Cerithium calvimontanum Deshayes, 1864','Deshayes, 1864','UNRANKED','','Cerithium','','calvimontanum','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04910','','','Lithophagus calyculatus P''. Carpenter, 1856',1,'Lithophagus calyculatus','Lithophagus calyculatus','Lithophagus calyculat',2,0,'','','P''. Carpenter','52a85d78-2cbb-5fc0-ad19-b2fd3cf35f2f','Lithophagus calyculatus P''. Carpenter, 1856','P''. Carpenter, 1856','UNRANKED','','Lithophagus','','calyculatus','','','',NULL,'','','','','','P''. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04917','','','Melania calypsoides Thurmann, in Thurmann and Etallon, 1862',2,'Melania calypsoides','Melania calypsoides','Melania calypsoid',2,0,'','','Thurmann|Etallon','005c17a2-ea08-52cb-aab6-92b9e487b784','Melania calypsoides Thurmann, in Thurmann and Etallon, 1862','Thurmann, in Thurmann and Etallon, 1862','UNRANKED','','Melania','','calypsoides','','','',NULL,'','','','','','Thurmann','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04926','','','Bulimus cambojiensis Reeve, 1860',1,'Bulimus cambojiensis','Bulimus cambojiensis','Bulimus camboiiens',2,0,'','','Reeve','664280eb-4c5a-5e9d-a5f5-c55dfd277fd2','Bulimus cambojiensis Reeve, 1860','Reeve, 1860','UNRANKED','','Bulimus','','cambojiensis','','','',NULL,'','','','','','Reeve','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04930','','','Ostrea cameleo Coquand, 1869',1,'Ostrea cameleo','Ostrea cameleo','Ostrea camele',2,0,'','','Coquand','6b2c9019-ea17-5162-a6a9-723d36beecc4','Ostrea cameleo Coquand, 1869','Coquand, 1869','UNRANKED','','Ostrea','','cameleo','','','',NULL,'','','','','','Coquand','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04933','','','Unio camelopardilis Lea, 1860',1,'Unio camelopardilis','Unio camelopardilis','Unio camelopardil',2,0,'','','Lea','da6d52fd-3606-5b39-a189-bb922e935cf1','Unio camelopardilis Lea, 1860','Lea, 1860','UNRANKED','','Unio','','camelopardilis','','','',NULL,'','','','','','Lea','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04940','','','Turbo camillus Orbigny, 1853',1,'Turbo camillus','Turbo camillus','Turbo camill',2,0,'','','Orbigny','54ada253-111d-5ef2-a517-93d29d0b8e77','Turbo camillus Orbigny, 1853','Orbigny, 1853','UNRANKED','','Turbo','','camillus','','','',NULL,'','','','','','Orbigny','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04942','','','Helix campana Tiberi, 1869',1,'Helix campana','Helix campana','Helix campan',2,0,'','','Tiberi','b578572e-11dc-599b-b5ee-be5e091f7610','Helix campana Tiberi, 1869','Tiberi, 1869','UNRANKED','','Helix','','campana','','','',NULL,'','','','','','Tiberi','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04946','','','Cyclotus campanulatus Martens, 1865',1,'Cyclotus campanulatus','Cyclotus campanulatus','Cyclotus campanulat',2,0,'','','Martens','cca4a765-c25a-5069-ad57-6fca2f50fb59','Cyclotus campanulatus Martens, 1865','Martens, 1865','UNRANKED','','Cyclotus','','campanulatus','','','',NULL,'','','','','','Martens','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04949','','','Natica campeachiensis Recluz, in Reeve, 1855',2,'Natica campeachiensis','Natica campeachiensis','Natica campeachiens',2,0,'','','Recluz|Reeve','a99409dd-7efd-5972-a453-584ee0055d31','Natica campeachiensis Recluz, in Reeve, 1855','Recluz, in Reeve, 1855','UNRANKED','','Natica','','campeachiensis','','','',NULL,'','','','','','Recluz','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04955','','','Spondylus camurus Reeve, 1856',1,'Spondylus camurus','Spondylus camurus','Spondylus camur',2,0,'','','Reeve','de551d09-daca-5343-92ee-98f53639ff81','Spondylus camurus Reeve, 1856','Reeve, 1856','UNRANKED','','Spondylus','','camurus','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04960','','','Artemis canaliculata G. Sowerby, 1852',1,'Artemis canaliculata','Artemis canaliculata','Artemis canaliculat',2,0,'','','G. Sowerby','ddc87cfe-46df-5cdb-917e-e249bf7b0a43','Artemis canaliculata G. Sowerby, 1852','G. Sowerby, 1852','UNRANKED','','Artemis','','canaliculata','','','',NULL,'','','','','','G. Sowerby','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04962','','','Cancellaria canaliculata Deshayes, 1864',1,'Cancellaria canaliculata','Cancellaria canaliculata','Cancellaria canaliculat',2,0,'','','Deshayes','a124732a-a340-524f-93b8-e22686d894f2','Cancellaria canaliculata Deshayes, 1864','Deshayes, 1864','UNRANKED','','Cancellaria','','canaliculata','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04969','','','Paludinella canaliculata Paladilhe, 1869',1,'Paludinella canaliculata','Paludinella canaliculata','Paludinella canaliculat',2,0,'','','Paladilhe','73635323-cd03-5f64-aad8-3bf3f92295db','Paludinella canaliculata Paladilhe, 1869','Paladilhe, 1869','UNRANKED','','Paludinella','','canaliculata','','','',NULL,'','','','','','Paladilhe','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04974','','','Voluta (Amoria) canaliculata McCoy, 1869',1,'Voluta canaliculata','Voluta canaliculata','Voluta canaliculat',2,0,'','','McCoy','c31d1861-2cd6-5e36-88d8-49589ebc64ed','Voluta (Amoria) canaliculata McCoy, 1869','McCoy, 1869','UNRANKED','','Voluta','Amoria','canaliculata','','','',NULL,'','','','','','McCoy','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04979','','','Parmophorus canaliculus Deshayes, 1861',1,'Parmophorus canaliculus','Parmophorus canaliculus','Parmophorus canalicul',2,0,'','','Deshayes','a1ce40c2-e15e-54b2-ae60-878f4dcb4867','Parmophorus canaliculus Deshayes, 1861','Deshayes, 1861','UNRANKED','','Parmophorus','','canaliculus','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04983','','','Fissurella canalifera Nevill, in Nevill and Nevill, 1869',2,'Fissurella canalifera','Fissurella canalifera','Fissurella canalifer',2,0,'','','Nevill','4e049f94-c8b9-5b17-a92f-4de0f8ddde68','Fissurella canalifera Nevill, in Nevill and Nevill, 1869','Nevill, in Nevill and Nevill, 1869','UNRANKED','','Fissurella','','canalifera','','','',NULL,'','','','','','Nevill','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04990','','','Natica canaligera Piette, 1855',1,'Natica canaligera','Natica canaligera','Natica canaliger',2,0,'','','Piette','69a5a266-7168-5a31-9efa-e78758fbf34d','Natica canaligera Piette, 1855','Piette, 1855','UNRANKED','','Natica','','canaligera','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04994','','','Partula canalis Mousson, 1865',1,'Partula canalis','Partula canalis','Partula canal',2,0,'','','Mousson','4e3da1a0-f856-5fa6-ab98-42053d2845ed','Partula canalis Mousson, 1865','Mousson, 1865','UNRANKED','','Partula','','canalis','','','',NULL,'','','','','','Mousson','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_04999','','','Actaeonina canariensis Tate, 1870',1,'Actaeonina canariensis','Actaeonina canariensis','Actaeonina canariens',2,0,'','','Tate','e5385f2d-dfec-5d49-bed5-2adfe5d99fd3','Actaeonina canariensis Tate, 1870','Tate, 1870','UNRANKED','','Actaeonina','','canariensis','','','',NULL,'','','','','','Tate','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05006','','','Kleinella cancellaris A. Adams, 1860',1,'Kleinella cancellaris','Kleinella cancellaris','Kleinella cancellar',2,0,'','','A. Adams','be05b27d-d533-56ec-9b30-607fdd4f7b14','Kleinella cancellaris A. Adams, 1860','A. Adams, 1860','UNRANKED','','Kleinella','','cancellaris','','','',NULL,'','','','','','A. Adams','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05012','','','Coralliobia cancellata Pease, 1860',1,'Coralliobia cancellata','Coralliobia cancellata','Coralliobia cancellat',2,0,'','','Pease','cb62db19-47cd-5d66-a587-6a6ce0c771dc','Coralliobia cancellata Pease, 1860','Pease, 1860','UNRANKED','','Coralliobia','','cancellata','','','',NULL,'','','','','','Pease','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05016','','','Eupoleme cancellata Leach, in J. Gray, 1852',2,'Eupoleme cancellata','Eupoleme cancellata','Eupoleme cancellat',2,0,'','','Leach|J. Gray','f6ebd781-c3ec-50cc-aca4-882a650ea944','Eupoleme cancellata Leach, in J. Gray, 1852','Leach, in J. Gray, 1852','UNRANKED','','Eupoleme','','cancellata','','','',NULL,'','','','','','Leach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05023','','','Pleurotomaria cancellata Terquem and Piette, 1865',1,'Pleurotomaria cancellata','Pleurotomaria cancellata','Pleurotomaria cancellat',2,0,'','','Terquem|Piette','3e29cc70-9dff-5d5a-b61d-1fd063307f8b','Pleurotomaria cancellata Terquem and Piette, 1865','Terquem and Piette, 1865','UNRANKED','','Pleurotomaria','','cancellata','','','',NULL,'','','','','','Terquem & Piette','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05026','','','Rostellaria cancellata Forbes, 1856',1,'Rostellaria cancellata','Rostellaria cancellata','Rostellaria cancellat',2,0,'','','Forbes','40bb7520-8542-5298-b73c-f3d470714e49','Rostellaria cancellata Forbes, 1856','Forbes, 1856','UNRANKED','','Rostellaria','','cancellata','','','',NULL,'','','','','','Forbes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05032','','','Vermetus cancellata ( Petaloconchus) intortus Mörch, 1861',1,'Vermetus cancellata intortus','Vermetus cancellata intortus','Vermetus cancellat intort',3,0,'','','Mörch','f5293655-6dc5-558f-b4cb-c09077536e2c','Vermetus cancellata ( Petaloconchus) intortus Mörch, 1861','Mörch, 1861','UNRANKED','','Vermetus','','cancellata','intortus','','',NULL,'','','','','','Mörch','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05038','','','Bellerophon cancellatus Hall, 1858',1,'Bellerophon cancellatus','Bellerophon cancellatus','Bellerophon cancellat',2,0,'','','Hall','65e8dd2c-97cc-5ec4-b3cd-f9793582a4c5','Bellerophon cancellatus Hall, 1858','Hall, 1858','UNRANKED','','Bellerophon','','cancellatus','','','',NULL,'','','','','','Hall','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05040','','','Pecten cancellatus Eichwald, 1865',1,'Pecten cancellatus','Pecten cancellatus','Pecten cancellat',2,0,'','','Eichwald','282fdb5c-20d8-5795-a7e6-646827835527','Pecten cancellatus Eichwald, 1865','Eichwald, 1865','UNRANKED','','Pecten','','cancellatus','','','',NULL,'','','','','','Eichwald','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05044','','','Strophostylus cancellatus Meek and Worthen, 1868',1,'Strophostylus cancellatus','Strophostylus cancellatus','Strophostylus cancellat',2,0,'','','Meek|Worthen','f063cda6-12b3-5d63-a4f4-38a42f410fd6','Strophostylus cancellatus Meek and Worthen, 1868','Meek and Worthen, 1868','UNRANKED','','Strophostylus','','cancellatus','','','',NULL,'','','','','','Meek & Worthen','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05049','','','Ambonychia cancellosa Hall, 1861',1,'Ambonychia cancellosa','Ambonychia cancellosa','Ambonychia cancellos',2,0,'','','Hall','8cffb8f9-d787-57e5-9164-d87186068fa1','Ambonychia cancellosa Hall, 1861','Hall, 1861','UNRANKED','','Ambonychia','','cancellosa','','','',NULL,'','','','','','Hall','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05052','','','Helix candeloti Crosse, 1868',1,'Helix candeloti','Helix candeloti','Helix candelot',2,0,'','','Crosse','e964f3f3-d57b-557f-bff9-70cabf0bd679','Helix candeloti Crosse, 1868','Crosse, 1868','UNRANKED','','Helix','','candeloti','','','',NULL,'','','','','','Crosse','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05055','','','Limicolaria candidissima Shuttleworth, 1856',1,'Limicolaria candidissima','Limicolaria candidissima','Limicolaria candidissim',2,0,'','','Shuttleworth','6bf54800-d2e1-5dc1-a4d3-e0e6106d7859','Limicolaria candidissima Shuttleworth, 1856','Shuttleworth, 1856','UNRANKED','','Limicolaria','','candidissima','','','',NULL,'','','','','','Shuttleworth','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05061','','','Cylichna candidula A. Adams, 1862',1,'Cylichna candidula','Cylichna candidula','Cylichna candidul',2,0,'','','A. Adams','128ccd68-3aec-5dd1-a967-74460b4c1aab','Cylichna candidula A. Adams, 1862','A. Adams, 1862','UNRANKED','','Cylichna','','candidula','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05068','','','Cyclostoma canescens Pfeiffer, 1851',1,'Cyclostoma canescens','Cyclostoma canescens','Cyclostoma canescens',2,0,'','','Pfeiffer','1abe35d9-a7d0-58ec-8d99-11b7e0a979d6','Cyclostoma canescens Pfeiffer, 1851','Pfeiffer, 1851','UNRANKED','','Cyclostoma','','canescens','','','',NULL,'','','','','','Pfeiffer','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05071','','','Physa canescens Morelet, 1868',1,'Physa canescens','Physa canescens','Physa canescens',2,0,'','','Morelet','7c06f7e1-44f5-56e2-aaf0-70a2c709b3bb','Physa canescens Morelet, 1868','Morelet, 1868','UNRANKED','','Physa','','canescens','','','',NULL,'','','','','','Morelet','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05075','','','Lucina cannabina Deshayes, 1857',1,'Lucina cannabina','Lucina cannabina','Lucina cannabin',2,0,'','','Deshayes','5db8facd-97e0-5b1f-8ada-7a624386349a','Lucina cannabina Deshayes, 1857','Deshayes, 1857','UNRANKED','','Lucina','','cannabina','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05082','','','Patella cantharus Reeve, 1855',1,'Patella cantharus','Patella cantharus','Patella canthar',2,0,'','','Reeve','3cbe6152-87b8-5050-958b-07170748bf1c','Patella cantharus Reeve, 1855','Reeve, 1855','UNRANKED','','Patella','','cantharus','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05086','','','Planorbis cantori Benson, 1850',1,'Planorbis cantori','Planorbis cantori','Planorbis cantor',2,0,'','','Benson','e31fcf4d-2c2f-5ba2-b4bf-3992f8774d9c','Planorbis cantori Benson, 1850','Benson, 1850','UNRANKED','','Planorbis','','cantori','','','',NULL,'','','','','','Benson','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05090','','','Fissurella cantraineana Ryckholt, 1852',1,'Fissurella cantraineana','Fissurella cantraineana','Fissurella cantrainean',2,0,'','','Ryckholt','9b2a49c9-ccb7-5c36-a10c-3e849bcdf2ef','Fissurella cantraineana Ryckholt, 1852','Ryckholt, 1852','UNRANKED','','Fissurella','','cantraineana','','','',NULL,'','','','','','Ryckholt','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05095','','','Lutraria capax Gould, 1851',1,'Lutraria capax','Lutraria capax','Lutraria capax',2,0,'','','Gould','4e37a9dd-31a4-54ca-b59a-d84d62fddff8','Lutraria capax Gould, 1851','Gould, 1851','UNRANKED','','Lutraria','','capax','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05098','','','Spondylus capax Conrad, 1853',1,'Spondylus capax','Spondylus capax','Spondylus capax',2,0,'','','Conrad','5acd71e4-2a4c-5a9f-82ce-e9a8bbe8b933','Spondylus capax Conrad, 1853','Conrad, 1853','UNRANKED','','Spondylus','','capax','','','',NULL,'','','','','','Conrad','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05100','','','Pleurotoma capellinii Deshayes, 1865',1,'Pleurotoma capellinii','Pleurotoma capellinii','Pleurotoma capellin',2,0,'','','Deshayes','877bb47e-2fd6-56f4-bc70-06d5b87f7009','Pleurotoma capellinii Deshayes, 1865','Deshayes, 1865','UNRANKED','','Pleurotoma','','capellinii','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05105','','','Purpura capensis Petit de la Saussaye, 1852',1,'Purpura capensis','Purpura capensis','Purpura capens',2,0,'','','Petit de la Saussaye','d4eb5a3d-fb45-5d2d-b489-1236279dd46f','Purpura capensis Petit de la Saussaye, 1852','Petit de la Saussaye, 1852','UNRANKED','','Purpura','','capensis','','','',NULL,'','','','','','Petit de la Saussaye','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05109','','','Achatina capillacea Pfeiffer, 1854',1,'Achatina capillacea','Achatina capillacea','Achatina capillace',2,0,'','','Pfeiffer','6cd6fbd4-5685-5141-ac49-49e7e482c399','Achatina capillacea Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Achatina','','capillacea','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05118','','','Pupa capillacea Dohrn and Semper, 1862',1,'Pupa capillacea','Pupa capillacea','Pupa capillace',2,0,'','','Dohrn|Semper','2d929359-2746-58bb-8027-8963269e9a05','Pupa capillacea Dohrn and Semper, 1862','Dohrn and Semper, 1862','UNRANKED','','Pupa','','capillacea','','','',NULL,'','','','','','Dohrn & Semper','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05124','','','Lima capillaris Pictet and Campiche, 1869',1,'Lima capillaris','Lima capillaris','Lima capillar',2,0,'','','Pictet|Campiche','71a6a8eb-3b08-5dfb-ba7a-e3845f63a53d','Lima capillaris Pictet and Campiche, 1869','Pictet and Campiche, 1869','UNRANKED','','Lima','','capillaris','','','',NULL,'','','','','','Pictet & Campiche','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05130','','','Physa capillata Gassies, 1870',1,'Physa capillata','Physa capillata','Physa capillat',2,0,'','','Gassies','6ee72b56-59a9-579e-8587-4adca79c72e7','Physa capillata Gassies, 1870','Gassies, 1870','UNRANKED','','Physa','','capillata','','','',NULL,'','','','','','Gassies','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05139','','','Natica caprae Philippi, 1852',1,'Natica caprae','Natica caprae','Natica capr',2,0,'','','Philippi','b05f9607-0996-55de-9298-354387681ab5','Natica caprae Philippi, 1852','Philippi, 1852','UNRANKED','','Natica','','caprae','','','',NULL,'','','','','','Philippi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05143','','','Exogyra caprina Conrad, 1853',1,'Exogyra caprina','Exogyra caprina','Exogyra caprin',2,0,'','','Conrad','5b3625a1-fa29-5136-97b3-6268cf96a2b3','Exogyra caprina Conrad, 1853','Conrad, 1853','UNRANKED','','Exogyra','','caprina','','','',NULL,'','','','','','Conrad','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05148','','','Helix capsula Benson, 1864',1,'Helix capsula','Helix capsula','Helix capsul',2,0,'','','Benson','7373fb3c-5924-5293-b01f-d41bd1f67054','Helix capsula Benson, 1864','Benson, 1864','UNRANKED','','Helix','','capsula','','','',NULL,'','','','','','Benson','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05156','','','Inoceramus capulus Shumard, 1860',1,'Inoceramus capulus','Inoceramus capulus','Inoceramus capul',2,0,'','','Shumard','7c13a552-0db0-53aa-9764-212090234b00','Inoceramus capulus Shumard, 1860','Shumard, 1860','UNRANKED','','Inoceramus','','capulus','','','',NULL,'','','','','','Shumard','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05159','','','Cerithium caraboeufi Loriol, in Loriol and Pellat, 1867',2,'Cerithium caraboeufi','Cerithium caraboeufi','Cerithium caraboeuf',2,0,'','','Loriol|Pellat','ba7e1913-7959-528e-a7a7-fa655c64a2f8','Cerithium caraboeufi Loriol, in Loriol and Pellat, 1867','Loriol, in Loriol and Pellat, 1867','UNRANKED','','Cerithium','','caraboeufi','','','',NULL,'','','','','','Loriol','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05168','','','Pleurotomaria carbonaria Eichwald, 1860',1,'Pleurotomaria carbonaria','Pleurotomaria carbonaria','Pleurotomaria carbonar',2,0,'','','Eichwald','2ead6b94-9f87-5b45-901f-58abb5a7116f','Pleurotomaria carbonaria Eichwald, 1860','Eichwald, 1860','UNRANKED','','Pleurotomaria','','carbonaria','','','',NULL,'','','','','','Eichwald','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05171','','','Chiton carbonarius Stevens, 1858',1,'Chiton carbonarius','Chiton carbonarius','Chiton carbonar',2,0,'','','Stevens','b08d7e24-5874-5976-a8ce-1af626d18c52','Chiton carbonarius Stevens, 1858','Stevens, 1858','UNRANKED','','Chiton','','carbonarius','','','',NULL,'','','','','','Stevens','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05174','','','Ditrupa carbonifera Ryckholt, 1852',1,'Ditrupa carbonifera','Ditrupa carbonifera','Ditrupa carbonifer',2,0,'','','Ryckholt','8b361e5b-2791-5ae9-a9af-e4d461c617ed','Ditrupa carbonifera Ryckholt, 1852','Ryckholt, 1852','UNRANKED','','Ditrupa','','carbonifera','','','',NULL,'','','','','','Ryckholt','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05178','','','Pyrula carcarensis Michelotti, 1861',1,'Pyrula carcarensis','Pyrula carcarensis','Pyrula carcarens',2,0,'','','Michelotti','1b65174a-33a6-5d35-aff3-8459a634c640','Pyrula carcarensis Michelotti, 1861','Michelotti, 1861','UNRANKED','','Pyrula','','carcarensis','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05185','','','Pecten cardinatus Quenstedt, 1858',1,'Pecten cardinatus','Pecten cardinatus','Pecten cardinat',2,0,'','','Quenstedt','447d5e09-a885-5f31-8773-505614b95fde','Pecten cardinatus Quenstedt, 1858','Quenstedt, 1858','UNRANKED','','Pecten','','cardinatus','','','',NULL,'','','','','','Quenstedt','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05192','','','Gresslya carditaeformis Morris and Lycett, 1853',1,'Gresslya carditaeformis','Gresslya carditaeformis','Gresslya carditaeform',2,0,'','','Morris|Lycett','26b012b5-dca1-540f-80b6-1e4f729995ce','Gresslya carditaeformis Morris and Lycett, 1853','Morris and Lycett, 1853','UNRANKED','','Gresslya','','carditaeformis','','','',NULL,'','','','','','Morris & Lycett','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05199','','','Rostellaria carentonensis Coquand, 1859',1,'Rostellaria carentonensis','Rostellaria carentonensis','Rostellaria carentonens',2,0,'','','Coquand','cb89ab7a-15be-503d-aabf-ad02eb57fbe5','Rostellaria carentonensis Coquand, 1859','Coquand, 1859','UNRANKED','','Rostellaria','','carentonensis','','','',NULL,'','','','','','Coquand','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05204','','','Xenophora caribaea Petit de la Saussaye, 1857',1,'Xenophora caribaea','Xenophora caribaea','Xenophora caribae',2,0,'','','Petit de la Saussaye','7741bd91-735e-5662-aa13-9db659cff27d','Xenophora caribaea Petit de la Saussaye, 1857','Petit de la Saussaye, 1857','UNRANKED','','Xenophora','','caribaea','','','',NULL,'','','','','','Petit de la Saussaye','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05210','','','Apricardia carinata Gueranger, 1853',1,'Apricardia carinata','Apricardia carinata','Apricardia carinat',2,0,'','','Gueranger','26a62c6f-3fe4-531c-9b1b-5b0ead39105f','Apricardia carinata Gueranger, 1853','Gueranger, 1853','UNRANKED','','Apricardia','','carinata','','','',NULL,'','','','','','Gueranger','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05213','','','Brownia carinata A. Adams, 1858',1,'Brownia carinata','Brownia carinata','Brownia carinat',2,0,'','','A. Adams','5fdfbc0e-faad-55c0-b7c7-ba9aa589da33','Brownia carinata A. Adams, 1858','A. Adams, 1858','UNRANKED','','Brownia','','carinata','','','',NULL,'','','','','','A. Adams','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05219','','','Emarginula (Tugali) carinata A. Adams, 1851',1,'Emarginula carinata','Emarginula carinata','Emarginula carinat',2,0,'','','A. Adams','8869984f-d600-5c34-80d8-8146d05cf4b6','Emarginula (Tugali) carinata A. Adams, 1851','A. Adams, 1851','UNRANKED','','Emarginula','Tugali','carinata','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05223','','','Helix consanguinea carinata C.B. Adams, 1851',1,'Helix consanguinea carinata','Helix consanguinea carinata','Helix consanguine carinat',3,0,'','','C. B. Adams','6c2f69be-0d59-5af2-8344-33263747f49f','Helix consanguinea carinata C.B. Adams, 1851','C.B. Adams, 1851','UNRANKED','','Helix','','consanguinea','carinata','','',NULL,'','','','','','C. B. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05230','','','Liotia carinata P. Carpenter, 1856',1,'Liotia carinata','Liotia carinata','Liotia carinat',2,0,'','','P. Carpenter','8f09b523-82f2-5e5b-8beb-7cf93871f84a','Liotia carinata P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Liotia','','carinata','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05236','','','Melanopsis mingrelica carinata Issel, 1865',1,'Melanopsis mingrelica carinata','Melanopsis mingrelica carinata','Melanopsis mingrelic carinat',3,0,'','','Issel','26489cc2-6c61-555c-91c6-6f92925f696f','Melanopsis mingrelica carinata Issel, 1865','Issel, 1865','UNRANKED','','Melanopsis','','mingrelica','carinata','','',NULL,'','','','','','Issel','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05242','','','Rimula carinata A. Adams, 1851',1,'Rimula carinata','Rimula carinata','Rimula carinat',2,0,'','','A. Adams','ef00b6a3-19ea-5f81-9a22-7cdb75c3ab0e','Rimula carinata A. Adams, 1851','A. Adams, 1851','UNRANKED','','Rimula','','carinata','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05247','','','Tomatina carinata P. Carpenter, 1856',1,'Tomatina carinata','Tomatina carinata','Tomatina carinat',2,0,'','','P. Carpenter','2c177fc7-d6d9-55dd-8735-379fa834a427','Tomatina carinata P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Tomatina','','carinata','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05253','','','Platyceras carinatum Hall, 1862',1,'Platyceras carinatum','Platyceras carinatum','Platyceras carinat',2,0,'','','Hall','c4d76d83-ff6e-5e64-8056-ff55b0f3c801','Platyceras carinatum Hall, 1862','Hall, 1862','UNRANKED','','Platyceras','','carinatum','','','',NULL,'','','','','','Hall','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05256','','','Tritonium carinatum Dunker, 1858',1,'Tritonium carinatum','Tritonium carinatum','Tritonium carinat',2,0,'','','Dunker','134e5ae3-f912-53b8-8feb-65bde56be853','Tritonium carinatum Dunker, 1858','Dunker, 1858','UNRANKED','','Tritonium','','carinatum','','','',NULL,'','','','','','Dunker','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05259','','','Anculotus carinatus Layard, 1854',1,'Anculotus carinatus','Anculotus carinatus','Anculotus carinat',2,0,'','','Layard','e511d7b7-b228-5eba-89a4-fcabcc63746c','Anculotus carinatus Layard, 1854','Layard, 1854','UNRANKED','','Anculotus','','carinatus','','','',NULL,'','','','','','Layard','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05263','','','Limax carinatus Leach, in J. Gray, 1852',2,'Limax carinatus','Limax carinatus','Limax carinat',2,0,'','','Leach|J. Gray','0ada5d52-30b9-5156-bbd5-b46bf85b9a9d','Limax carinatus Leach, in J. Gray, 1852','Leach, in J. Gray, 1852','UNRANKED','','Limax','','carinatus','','','',NULL,'','','','','','Leach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05270','','','Trochus carinellaris Buvignier, 1852',1,'Trochus carinellaris','Trochus carinellaris','Trochus carinellar',2,0,'','','Buvignier','4d7b329c-9852-55b6-b1fc-538fc54424e9','Trochus carinellaris Buvignier, 1852','Buvignier, 1852','UNRANKED','','Trochus','','carinellaris','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05274','','','Conradia carinifera A. Adams, 1860',1,'Conradia carinifera','Conradia carinifera','Conradia carinifer',2,0,'','','A. Adams','481520f1-eb08-5a96-a823-01c9218b412e','Conradia carinifera A. Adams, 1860','A. Adams, 1860','UNRANKED','','Conradia','','carinifera','','','',NULL,'','','','','','A. Adams','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05279','','','Natica carinifera Koch, in Philippi, 1852',2,'Natica carinifera','Natica carinifera','Natica carinifer',2,0,'','','Koch|Philippi','a45a49aa-48d9-5404-9a6b-407d84e40849','Natica carinifera Koch, in Philippi, 1852','Koch, in Philippi, 1852','UNRANKED','','Natica','','carinifera','','','',NULL,'','','','','','Koch','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05285','','','Hydrobia carinulata Drouet, 1867',1,'Hydrobia carinulata','Hydrobia carinulata','Hydrobia carinulat',2,0,'','','Drouet','cda09a77-f8a1-5ba7-b09d-7c6a95446097','Hydrobia carinulata Drouet, 1867','Drouet, 1867','UNRANKED','','Hydrobia','','carinulata','','','',NULL,'','','','','','Drouet','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05291','','','Natica carlyana Hall, 1858',1,'Natica carlyana','Natica carlyana','Natica carlyan',2,0,'','','Hall','85fe8f9e-e8bc-5f16-8a20-802963f96dad','Natica carlyana Hall, 1858','Hall, 1858','UNRANKED','','Natica','','carlyana','','','',NULL,'','','','','','Hall','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05297','','','Cypraea (Luponia) carnatica Stoliczka, 1868',1,'Cypraea carnatica','Cypraea carnatica','Cypraea carnatic',2,0,'','','Stoliczka','af911c18-ae97-5991-8418-d437324b1215','Cypraea (Luponia) carnatica Stoliczka, 1868','Stoliczka, 1868','UNRANKED','','Cypraea','Luponia','carnatica','','','',NULL,'','','','','','Stoliczka','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05299','','','Macrocyclis carnatica Stoliczka, 1867',1,'Macrocyclis carnatica','Macrocyclis carnatica','Macrocyclis carnatic',2,0,'','','Stoliczka','9eb7929a-e9c6-58f7-be32-e3cf9f33b539','Macrocyclis carnatica Stoliczka, 1867','Stoliczka, 1867','UNRANKED','','Macrocyclis','','carnatica','','','',NULL,'','','','','','Stoliczka','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05306','','','Eolis carnea Alder and Hancock, 1854',1,'Eolis carnea','Eolis carnea','Eolis carne',2,0,'','','Alder|Hancock','2b089d5c-41bd-519f-9bdc-9e705949a8b3','Eolis carnea Alder and Hancock, 1854','Alder and Hancock, 1854','UNRANKED','','Eolis','','carnea','','','',NULL,'','','','','','Alder & Hancock','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05315','','','Helix carniolica A. Schmidt, in Pfeiffer, 1859',2,'Helix carniolica','Helix carniolica','Helix carniolic',2,0,'','','A. Schmidt|Pfeiffer','9c58cb6f-b9dd-5814-900a-b8ec44b966f4','Helix carniolica A. Schmidt, in Pfeiffer, 1859','A. Schmidt, in Pfeiffer, 1859','UNRANKED','','Helix','','carniolica','','','',NULL,'','','','','','A. Schmidt','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05320','','','Helix caroli Dohrn and Heynemann, 1862',1,'Helix caroli','Helix caroli','Helix carol',2,0,'','','Dohrn|Heynemann','58acc543-16b2-5d8d-b684-ce364453eb62','Helix caroli Dohrn and Heynemann, 1862','Dohrn and Heynemann, 1862','UNRANKED','','Helix','','caroli','','','',NULL,'','','','','','Dohrn & Heynemann','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05329','','','Cassidulus carolinensis Tourney and Holmes, 1856',1,'Cassidulus carolinensis','Cassidulus carolinensis','Cassidulus carolinens',2,0,'','','Tourney|Holmes','ce7825c0-0fa1-5005-a0ad-4d0604ab35aa','Cassidulus carolinensis Tourney and Holmes, 1856','Tourney and Holmes, 1856','UNRANKED','','Cassidulus','','carolinensis','','','',NULL,'','','','','','Tourney & Holmes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05334','','','Pinna carolinensis Hanley, 1858',1,'Pinna carolinensis','Pinna carolinensis','Pinna carolinens',2,0,'','','Hanley','77f361fd-dd04-5a46-a3c8-5049bfc4683c','Pinna carolinensis Hanley, 1858','Hanley, 1858','UNRANKED','','Pinna','','carolinensis','','','',NULL,'','','','','','Hanley','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05341','','','Nerinea carpathica Zeuschner, 1850',1,'Nerinea carpathica','Nerinea carpathica','Nerinea carpathic',2,0,'','','Zeuschner','84e1d427-deca-5eb7-bc42-d42830f74930','Nerinea carpathica Zeuschner, 1850','Zeuschner, 1850','UNRANKED','','Nerinea','','carpathica','','','',NULL,'','','','','','Zeuschner','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05345','','','Conus carpenteri Crosse, 1865',1,'Conus carpenteri','Conus carpenteri','Conus carpenter',2,0,'','','Crosse','c613da2f-d65a-51f6-b1c2-5a62ba6ff824','Conus carpenteri Crosse, 1865','Crosse, 1865','UNRANKED','','Conus','','carpenteri','','','',NULL,'','','','','','Crosse','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05348','','','Helix carpenteri Newcomb, 1861',1,'Helix carpenteri','Helix carpenteri','Helix carpenter',2,0,'','','Newcomb','87ff45c7-0293-58c2-8fe7-819e5c8bbd2f','Helix carpenteri Newcomb, 1861','Newcomb, 1861','UNRANKED','','Helix','','carpenteri','','','',NULL,'','','','','','Newcomb','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05352','','','Siliquaria carpenteri Dunker, 1861',1,'Siliquaria carpenteri','Siliquaria carpenteri','Siliquaria carpenter',2,0,'','','Dunker','c13fd74f-e808-5629-a8df-a61e91e909a7','Siliquaria carpenteri Dunker, 1861','Dunker, 1861','UNRANKED','','Siliquaria','','carpenteri','','','',NULL,'','','','','','Dunker','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05359','','','Helix carpenteriana Bland, 1860',1,'Helix carpenteriana','Helix carpenteriana','Helix carpenterian',2,0,'','','Bland','59f8dfa5-f1bd-5335-a9b0-b2832cbd8a4d','Helix carpenteriana Bland, 1860','Bland, 1860','UNRANKED','','Helix','','carpenteriana','','','',NULL,'','','','','','Bland','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05363','','','Unio carriosoides Lea, 1868',1,'Unio carriosoides','Unio carriosoides','Unio carriosoid',2,0,'','','Lea','559f8749-c151-539f-97f6-959c139094be','Unio carriosoides Lea, 1868','Lea, 1868','UNRANKED','','Unio','','carriosoides','','','',NULL,'','','','','','Lea','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05370','','','Pleurotomaria carusensis Orbigny, 1855',1,'Pleurotomaria carusensis','Pleurotomaria carusensis','Pleurotomaria carusens',2,0,'','','Orbigny','190820c7-2646-5096-97cf-4a7a6f1cff60','Pleurotomaria carusensis Orbigny, 1855','Orbigny, 1855','UNRANKED','','Pleurotomaria','','carusensis','','','',NULL,'','','','','','Orbigny','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05376','','','Pleurotomaria casii Meek and Worthen, 1868',1,'Pleurotomaria casii','Pleurotomaria casii','Pleurotomaria cas',2,0,'','','Meek|Worthen','01e3cb9c-2386-5ef6-8c36-9140379cc3c2','Pleurotomaria casii Meek and Worthen, 1868','Meek and Worthen, 1868','UNRANKED','','Pleurotomaria','','casii','','','',NULL,'','','','','','Meek & Worthen','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05380','','','Ostrea cassandra Coquand, 1865',1,'Ostrea cassandra','Ostrea cassandra','Ostrea cassandr',2,0,'','','Coquand','a0bdead3-1ef1-5abd-a3c4-0d881a849f01','Ostrea cassandra Coquand, 1865','Coquand, 1865','UNRANKED','','Ostrea','','cassandra','','','',NULL,'','','','','','Coquand','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05386','','','Pupa cassidula R. Lowe, 1852',1,'Pupa cassidula','Pupa cassidula','Pupa cassidul',2,0,'','','R. Lowe','a5f2f14c-b1c0-5a63-bb40-70905636f488','Pupa cassidula R. Lowe, 1852','R. Lowe, 1852','UNRANKED','','Pupa','','cassidula','','','',NULL,'','','','','','R. Lowe','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05395','','','Crenella casta A. Adams, 1862',1,'Crenella casta','Crenella casta','Crenella cast',2,0,'','','A. Adams','1643dc40-352d-52db-ac1a-46ddd8f6dbdf','Crenella casta A. Adams, 1862','A. Adams, 1862','UNRANKED','','Crenella','','casta','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05398','','','Melania casta Anthony, 1854',1,'Melania casta','Melania casta','Melania cast',2,0,'','','Anthony','6ec3a4f4-330b-591c-838d-ba6895659a61','Melania casta Anthony, 1854','Anthony, 1854','UNRANKED','','Melania','','casta','','','',NULL,'','','','','','Anthony','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05401','','','Natica casta Philippi, 1852',1,'Natica casta','Natica casta','Natica cast',2,0,'','','Philippi','53aebf76-190f-5679-8c32-3bc500a381e1','Natica casta Philippi, 1852','Philippi, 1852','UNRANKED','','Natica','','casta','','','',NULL,'','','','','','Philippi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05407','','','Columbella castanea Gould, 1851',1,'Columbella castanea','Columbella castanea','Columbella castane',2,0,'','','Gould','3a6e0383-72e1-5ad2-b4cd-863cc91429e6','Columbella castanea Gould, 1851','Gould, 1851','UNRANKED','','Columbella','','castanea','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05416','','','Mitra castanea A. Adams, 1851',1,'Mitra castanea','Mitra castanea','Mitra castane',2,0,'','','A. Adams','5b06f520-833a-5828-b9c0-04f779ad2969','Mitra castanea A. Adams, 1851','A. Adams, 1851','UNRANKED','','Mitra','','castanea','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05422','','','Purpura castanea Krauss, in Küster, 1859',2,'Purpura castanea','Purpura castanea','Purpura castane',2,0,'','','Krauss|Küster','d63124bd-dd43-5219-85b8-a3b21ebacd8f','Purpura castanea Krauss, in Küster, 1859','Krauss, in Küster, 1859','UNRANKED','','Purpura','','castanea','','','',NULL,'','','','','','Krauss','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05429','','','Chlorostoma castaneum A. Adams, 1851',1,'Chlorostoma castaneum','Chlorostoma castaneum','Chlorostoma castane',2,0,'','','A. Adams','e5cf0825-57db-525a-bc58-33eb7dfbeffe','Chlorostoma castaneum A. Adams, 1851','A. Adams, 1851','UNRANKED','','Chlorostoma','','castaneum','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05432','','','Chiton castaneus Gould, 1852',1,'Chiton castaneus','Chiton castaneus','Chiton castane',2,0,'','','Gould','9b91e1f7-2674-5ba9-a6f8-8c2ecf76b9d7','Chiton castaneus Gould, 1852','Gould, 1852','UNRANKED','','Chiton','','castaneus','','','',NULL,'','','','','','Gould','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05437','','','Ampullaria castelnaudii Hupe, 1857',1,'Ampullaria castelnaudii','Ampullaria castelnaudii','Ampullaria castelnaud',2,0,'','','Hupe','46a0f30e-b969-50ed-845e-111332b57ba3','Ampullaria castelnaudii Hupe, 1857','Hupe, 1857','UNRANKED','','Ampullaria','','castelnaudii','','','',NULL,'','','','','','Hupe','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05441','','','Hyria castelnaudii Hupe, 1857',1,'Hyria castelnaudii','Hyria castelnaudii','Hyria castelnaud',2,0,'','','Hupe','3cf83404-6d89-5950-93bd-f382cb7f0057','Hyria castelnaudii Hupe, 1857','Hupe, 1857','UNRANKED','','Hyria','','castelnaudii','','','',NULL,'','','','','','Hupe','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05447','','','Helix castra Benson, 1852',1,'Helix castra','Helix castra','Helix castr',2,0,'','','Benson','42bcf862-f32a-5a17-8b64-85a2eaf8c9d4','Helix castra Benson, 1852','Benson, 1852','UNRANKED','','Helix','','castra','','','',NULL,'','','','','','Benson','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05448','','','Zizyphinus castra Reeve, 1863',1,'Zizyphinus castra','Zizyphinus castra','Zizyphinus castr',2,0,'','','Reeve','ef24be98-3f22-54e0-8809-f98f3f114a36','Zizyphinus castra Reeve, 1863','Reeve, 1863','UNRANKED','','Zizyphinus','','castra','','','',NULL,'','','','','','Reeve','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05452','','','Cyclostoma (Cyclostomus) castum Pfeiffer, 1854',1,'Cyclostoma castum','Cyclostoma castum','Cyclostoma cast',2,0,'','','Pfeiffer','e7f4e4fa-d521-5db7-a693-87a36ac1ada3','Cyclostoma (Cyclostomus) castum Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Cyclostoma','Cyclostomus','castum','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05455','','','Unio castus Lea, 1860',1,'Unio castus','Unio castus','Unio cast',2,0,'','','Lea','09649efa-4dfb-5262-8515-2d745b41da94','Unio castus Lea, 1860','Lea, 1860','UNRANKED','','Unio','','castus','','','',NULL,'','','','','','Lea','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05460','','','Bulimus catamarcanus Pfeiffer, 1858',1,'Bulimus catamarcanus','Bulimus catamarcanus','Bulimus catamarcan',2,0,'','','Pfeiffer','ca0753c0-892c-5180-afdf-8e7c4a3f0b1b','Bulimus catamarcanus Pfeiffer, 1858','Pfeiffer, 1858','UNRANKED','','Bulimus','','catamarcanus','','','',NULL,'','','','','','Pfeiffer','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05461','','','Clausilia cataphracta Parreyss, in A. Schmidt, 1868',2,'Clausilia cataphracta','Clausilia cataphracta','Clausilia cataphract',2,0,'','','Parreyss|A. Schmidt','58162088-9537-5280-ba84-5c4dcee952de','Clausilia cataphracta Parreyss, in A. Schmidt, 1868','Parreyss, in A. Schmidt, 1868','UNRANKED','','Clausilia','','cataphracta','','','',NULL,'','','','','','Parreyss','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05466','','','Cinulia catenata Tate, 1865',1,'Cinulia catenata','Cinulia catenata','Cinulia catenat',2,0,'','','Tate','7b0cf69d-d08b-55cf-b61d-7945ebb937ba','Cinulia catenata Tate, 1865','Tate, 1865','UNRANKED','','Cinulia','','catenata','','','',NULL,'','','','','','Tate','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05471','','','Conus catenatus G. Sowerby, 1850',1,'Conus catenatus','Conus catenatus','Conus catenat',2,0,'','','G. Sowerby','a5351135-db8b-53da-b49f-b9f007ef1f9c','Conus catenatus G. Sowerby, 1850','G. Sowerby, 1850','UNRANKED','','Conus','','catenatus','','','',NULL,'','','','','','G. Sowerby','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05473','','','Scaphander catenatus Leach, in J. Gray, 1852',2,'Scaphander catenatus','Scaphander catenatus','Scaphander catenat',2,0,'','','Leach|J. Gray','60c3e5c1-8716-5155-b493-82f15699f4d5','Scaphander catenatus Leach, in J. Gray, 1852','Leach, in J. Gray, 1852','UNRANKED','','Scaphander','','catenatus','','','',NULL,'','','','','','Leach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05489','','','Bulimus catlowiae Pfeiffer, 1852',1,'Bulimus catlowiae','Bulimus catlowiae','Bulimus catlowi',2,0,'','','Pfeiffer','1d7e8d97-f044-5088-8ddd-ec41cc7c7da0','Bulimus catlowiae Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Bulimus','','catlowiae','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05495','','','Cerithium cattleyae Baily, 1858',1,'Cerithium cattleyae','Cerithium cattleyae','Cerithium cattley',2,0,'','','Baily','8579cdf2-1ee5-5613-8c35-9a1483d10002','Cerithium cattleyae Baily, 1858','Baily, 1858','UNRANKED','','Cerithium','','cattleyae','','','',NULL,'','','','','','Baily','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05501','','','Bulimus caucasicus Pfeiffer, 1852',1,'Bulimus caucasicus','Bulimus caucasicus','Bulimus caucasic',2,0,'','','Pfeiffer','abe579e2-f871-5c82-a25f-ca5ab9a3078b','Bulimus caucasicus Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Bulimus','','caucasicus','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05504','','','Cypricardia caudata Lycett, 1863',1,'Cypricardia caudata','Cypricardia caudata','Cypricardia caudat',2,0,'','','Lycett','b60f4224-77d8-55e4-8b10-a1ffd71b61c9','Cypricardia caudata Lycett, 1863','Lycett, 1863','UNRANKED','','Cypricardia','','caudata','','','',NULL,'','','','','','Lycett','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05507','','','Ostrea caudata Schafhäutl, 1863',1,'Ostrea caudata','Ostrea caudata','Ostrea caudat',2,0,'','','Schafhäutl','52b5ecec-c634-541e-a93c-76e9ea4ee1e7','Ostrea caudata Schafhäutl, 1863','Schafhäutl, 1863','UNRANKED','','Ostrea','','caudata','','','',NULL,'','','','','','Schafhäutl','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05510','','','Cyprina caudataeformis Schauroth, 1865',1,'Cyprina caudataeformis','Cyprina caudataeformis','Cyprina caudataeform',2,0,'','','Schauroth','28fdf74c-c9ae-5164-aaae-9c282cbaba1c','Cyprina caudataeformis Schauroth, 1865','Schauroth, 1865','UNRANKED','','Cyprina','','caudataeformis','','','',NULL,'','','','','','Schauroth','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05516','','','Helix cauisa Benson, 1859',1,'Helix cauisa','Helix cauisa','Helix cauis',2,0,'','','Benson','ddf11dac-6ba7-5487-bf86-49cd07223137','Helix cauisa Benson, 1859','Benson, 1859','UNRANKED','','Helix','','cauisa','','','',NULL,'','','','','','Benson','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05520','','','Calcar causia Ryckholt, 1861',1,'Calcar causia','Calcar causia','Calcar caus',2,0,'','','Ryckholt','800467b3-76ac-527c-971b-56892e1f57d5','Calcar causia Ryckholt, 1861','Ryckholt, 1861','UNRANKED','','Calcar','','causia','','','',NULL,'','','','','','Ryckholt','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05525','','','Cyclostoma (Cyclophorus) cayennense Shuttleworth, 1852',1,'Cyclostoma cayennense','Cyclostoma cayennense','Cyclostoma cayennens',2,0,'','','Shuttleworth','b9673ff9-4866-54d7-a8f3-1dfc044c489d','Cyclostoma (Cyclophorus) cayennense Shuttleworth, 1852','Shuttleworth, 1852','UNRANKED','','Cyclostoma','Cyclophorus','cayennense','','','',NULL,'','','','','','Shuttleworth','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05526','','','Natica cayennensis Recluz, 1850',1,'Natica cayennensis','Natica cayennensis','Natica cayennens',2,0,'','','Recluz','0e5a8e8a-3e5e-5267-b4c9-c027bc0e8283','Natica cayennensis Recluz, 1850','Recluz, 1850','UNRANKED','','Natica','','cayennensis','','','',NULL,'','','','','','Recluz','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05531','','','Bulimus cecileae J. Moricand, 1858',1,'Bulimus cecileae','Bulimus cecileae','Bulimus cecile',2,0,'','','J. Moricand','3a4e0627-94d0-51c0-bce2-46de8f8daa47','Bulimus cecileae J. Moricand, 1858','J. Moricand, 1858','UNRANKED','','Bulimus','','cecileae','','','',NULL,'','','','','','J. Moricand','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05535','','','Cerithium cedo-nulli G. Sowerby, 1855',1,'Cerithium cedo-nulli','Cerithium cedo-nulli','Cerithium cedo-null',2,0,'','','G. Sowerby','de857600-7ed3-508c-b04d-3e9e95dfe219','Cerithium cedo-nulli G. Sowerby, 1855','G. Sowerby, 1855','UNRANKED','','Cerithium','','cedo-nulli','','','',NULL,'','','','','','G. Sowerby','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05541','','','Bulimus cefalonicus Mousson, 1859',1,'Bulimus cefalonicus','Bulimus cefalonicus','Bulimus cefalonic',2,0,'','','Mousson','210cc61f-32fc-5b70-b0c4-e80761ea3dbb','Bulimus cefalonicus Mousson, 1859','Mousson, 1859','UNRANKED','','Bulimus','','cefalonicus','','','',NULL,'','','','','','Mousson','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05544','','','Vitrina celebensis Pfeiffer, 1856',1,'Vitrina celebensis','Vitrina celebensis','Vitrina celebens',2,0,'','','Pfeiffer','b1447969-69ca-57c3-af1e-990628229c0b','Vitrina celebensis Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Vitrina','','celebensis','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05546','','','Ferussacia celosia Bourguignat, 1864',1,'Ferussacia celosia','Ferussacia celosia','Ferussacia celos',2,0,'','','Bourguignat','97245e4a-02b2-5d5d-9ad5-404253f4624a','Ferussacia celosia Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Ferussacia','','celosia','','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05552','','','Emarginula cenomanensis Gueranger, 1853',1,'Emarginula cenomanensis','Emarginula cenomanensis','Emarginula cenomanens',2,0,'','','Gueranger','56b2f8fe-adc7-5150-b970-6046425de529','Emarginula cenomanensis Gueranger, 1853','Gueranger, 1853','UNRANKED','','Emarginula','','cenomanensis','','','',NULL,'','','','','','Gueranger','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05559','','','Vermetus cenomanensis Gueranger, 1853',1,'Vermetus cenomanensis','Vermetus cenomanensis','Vermetus cenomanens',2,0,'','','Gueranger','7f752a10-9b62-5016-920c-bea6afdfe5aa','Vermetus cenomanensis Gueranger, 1853','Gueranger, 1853','UNRANKED','','Vermetus','','cenomanensis','','','',NULL,'','','','','','Gueranger','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05563','','','Acteon censoriensis Cotteau, 1854',1,'Acteon censoriensis','Acteon censoriensis','Acteon censoriens',2,0,'','','Cotteau','104ed157-1736-53d2-a01b-f377d17e9756','Acteon censoriensis Cotteau, 1854','Cotteau, 1854','UNRANKED','','Acteon','','censoriensis','','','',NULL,'','','','','','Cotteau','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05572','','','Nerinea censoriensis Cotteau, 1854',1,'Nerinea censoriensis','Nerinea censoriensis','Nerinea censoriens',2,0,'','','Cotteau','d1e1f71e-ff60-5e58-a918-7a6e51ee04c2','Nerinea censoriensis Cotteau, 1854','Cotteau, 1854','UNRANKED','','Nerinea','','censoriensis','','','',NULL,'','','','','','Cotteau','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05575','','','Pecten censoriensis Cotteau, 1855',1,'Pecten censoriensis','Pecten censoriensis','Pecten censoriens',2,0,'','','Cotteau','6c84eaa7-61ff-5cb1-b945-9420d210cd07','Pecten censoriensis Cotteau, 1855','Cotteau, 1855','UNRANKED','','Pecten','','censoriensis','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05584','','','Bursa centrosa Conrad, 1868',1,'Bursa centrosa','Bursa centrosa','Bursa centros',2,0,'','','Conrad','59f037b9-77d9-550d-8d2c-7da049a37c11','Bursa centrosa Conrad, 1868','Conrad, 1868','UNRANKED','','Bursa','','centrosa','','','',NULL,'','','','','','Conrad','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05586','','','Olivia cephalinophora Ryckholt, 1861',1,'Olivia cephalinophora','Olivia cephalinophora','Olivia cephalinophor',2,0,'','','Ryckholt','3fad5b20-45fc-547c-8e3a-c634401213eb','Olivia cephalinophora Ryckholt, 1861','Ryckholt, 1861','UNRANKED','','Olivia','','cephalinophora','','','',NULL,'','','','','','Ryckholt','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05591','','','Helix ceraria Benson, 1853',1,'Helix ceraria','Helix ceraria','Helix cerar',2,0,'','','Benson','626e55b1-63b1-5a0f-b2c5-fe4125793d30','Helix ceraria Benson, 1853','Benson, 1853','UNRANKED','','Helix','','ceraria','','','',NULL,'','','','','','Benson','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05593','','','Tellina cerasum G. Sowerby, 1868',1,'Tellina cerasum','Tellina cerasum','Tellina ceras',2,0,'','','G. Sowerby','681d4b3d-7f08-55d5-a5e9-28559eb9840a','Tellina cerasum G. Sowerby, 1868','G. Sowerby, 1868','UNRANKED','','Tellina','','cerasum','','','',NULL,'','','','','','G. Sowerby','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05602','','','Cerithiopsis cerea P. Carpenter, 1856',1,'Cerithiopsis cerea','Cerithiopsis cerea','Cerithiopsis cere',2,0,'','','P. Carpenter','e24cc521-b802-5b73-aa07-71f360ad398a','Cerithiopsis cerea P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Cerithiopsis','','cerea','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05607','','','Hydrocena (Omphalotropis) cerea Pfeiffer, 1857',1,'Hydrocena cerea','Hydrocena cerea','Hydrocena cere',2,0,'','','Pfeiffer','8ef32ff1-5f8a-5002-a89e-d84a067ca25e','Hydrocena (Omphalotropis) cerea Pfeiffer, 1857','Pfeiffer, 1857','UNRANKED','','Hydrocena','Omphalotropis','cerea','','','',NULL,'','','','','','Pfeiffer','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05609','','','Melania cerea Brot, 1860',1,'Melania cerea','Melania cerea','Melania cere',2,0,'','','Brot','99543eef-04c3-51f4-a975-1dfcb67a770e','Melania cerea Brot, 1860','Brot, 1860','UNRANKED','','Melania','','cerea','','','',NULL,'','','','','','Brot','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05617','','','Achatina cereola Morelet, 1860',1,'Achatina cereola','Achatina cereola','Achatina cereol',2,0,'','','Morelet','6b13d5bd-902d-56d9-a0e5-ae21d1eac26f','Achatina cereola Morelet, 1860','Morelet, 1860','UNRANKED','','Achatina','','cereola','','','',NULL,'','','','','','Morelet','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05620','','','Natica ceres Loriol in Loriol and Pellat, 1867',2,'Natica ceres','Natica ceres','Natica cer',2,0,'','','Loriol|Pellat','aa44107d-537a-5074-bb98-3c5a519d1f38','Natica ceres Loriol in Loriol and Pellat, 1867','Loriol in Loriol and Pellat, 1867','UNRANKED','','Natica','','ceres','','','',NULL,'','','','','','Loriol','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05631','','','Venus cerina C.B. Adams, in Reeve, 1864',2,'Venus cerina','Venus cerina','Venus cerin',2,0,'','','C. B. Adams|Reeve','2e7c0f63-2d76-517f-978f-6b32106a0d11','Venus cerina C.B. Adams, in Reeve, 1864','C.B. Adams, in Reeve, 1864','UNRANKED','','Venus','','cerina','','','',NULL,'','','','','','C. B. Adams','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05640','','','Scalaria cerithiformis Watelet, 1853',1,'Scalaria cerithiformis','Scalaria cerithiformis','Scalaria cerithiform',2,0,'','','Watelet','6a10c297-b519-5dde-bbda-81b94e23a9a0','Scalaria cerithiformis Watelet, 1853','Watelet, 1853','UNRANKED','','Scalaria','','cerithiformis','','','',NULL,'','','','','','Watelet','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05643','','','Drillia cerithoidea P. Carpenter, 1856',1,'Drillia cerithoidea','Drillia cerithoidea','Drillia cerithoide',2,0,'','','P. Carpenter','3c58ebe2-10ff-51d7-a04a-5b0e2a0ebe93','Drillia cerithoidea P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Drillia','','cerithoidea','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05649','','','Helix ceroconus Pfeiffer, 1863',1,'Helix ceroconus','Helix ceroconus','Helix cerocon',2,0,'','','Pfeiffer','409408d8-f40a-52b5-8308-bade4a0c46a4','Helix ceroconus Pfeiffer, 1863','Pfeiffer, 1863','UNRANKED','','Helix','','ceroconus','','','',NULL,'','','','','','Pfeiffer','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05655','','','Columbella cervinetta P. Carpenter, 1857',1,'Columbella cervinetta','Columbella cervinetta','Columbella ceruinett',2,0,'','','P. Carpenter','e69b4bbf-9220-5f44-8b17-f40b1da0ac8c','Columbella cervinetta P. Carpenter, 1857','P. Carpenter, 1857','UNRANKED','','Columbella','','cervinetta','','','',NULL,'','','','','','P. Carpenter','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05662','','','Nerita cestophora Ryckholt, 1852',1,'Nerita cestophora','Nerita cestophora','Nerita cestophor',2,0,'','','Ryckholt','8b5f250c-1909-562c-bbd6-14af62782062','Nerita cestophora Ryckholt, 1852','Ryckholt, 1852','UNRANKED','','Nerita','','cestophora','','','',NULL,'','','','','','Ryckholt','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05667','','','Clausilia ceylanica Benson, 1863',1,'Clausilia ceylanica','Clausilia ceylanica','Clausilia ceylanic',2,0,'','','Benson','4f3ca3c0-11ad-5445-8e6b-2383628c7fbd','Clausilia ceylanica Benson, 1863','Benson, 1863','UNRANKED','','Clausilia','','ceylanica','','','',NULL,'','','','','','Benson','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05674','','','Truncatella ceylanica Pfeiffer, 1856',1,'Truncatella ceylanica','Truncatella ceylanica','Truncatella ceylanic',2,0,'','','Pfeiffer','5f718f05-5902-5b9c-bd13-c75f46a47511','Truncatella ceylanica Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Truncatella','','ceylanica','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05679','','','Paludina ceylonica Dohrn, 1857',1,'Paludina ceylonica','Paludina ceylonica','Paludina ceylonic',2,0,'','','Dohrn','8a0d0b8f-2626-5e57-834c-188fda30135d','Paludina ceylonica Dohrn, 1857','Dohrn, 1857','UNRANKED','','Paludina','','ceylonica','','','',NULL,'','','','','','Dohrn','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05682','','','Clanculus ceylonicus Nevill, in Nevill and Nevill, 1869',2,'Clanculus ceylonicus','Clanculus ceylonicus','Clanculus ceylonic',2,0,'','','Nevill','065cf397-fc2e-521b-98be-f5b3aab9a2da','Clanculus ceylonicus Nevill, in Nevill and Nevill, 1869','Nevill, in Nevill and Nevill, 1869','UNRANKED','','Clanculus','','ceylonicus','','','',NULL,'','','','','','Nevill','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05690','','','Helix challameliana Bourguignat, 1864',1,'Helix challameliana','Helix challameliana','Helix challamelian',2,0,'','','Bourguignat','d500883b-10e8-506c-936c-daca73e4b298','Helix challameliana Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','challameliana','','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05695','','','Rhysota (Helix) chambertinii Tryon, 1869',1,'Rhysota chambertinii','Rhysota chambertinii','Rhysota chambertin',2,0,'','','Tryon','89119325-54ad-539e-b939-174db8f10004','Rhysota (Helix) chambertinii Tryon, 1869','Tryon, 1869','UNRANKED','','Rhysota','Helix','chambertinii','','','',NULL,'','','','','','Tryon','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05699','','','Helix chancei Cox, 1870',1,'Helix chancei','Helix chancei','Helix chance',2,0,'','','Cox','d5dc9317-7a1a-531e-a0ab-7102d4d10cfa','Helix chancei Cox, 1870','Cox, 1870','UNRANKED','','Helix','','chancei','','','',NULL,'','','','','','Cox','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05701','','','Turbo chantrei Dumortier, 1867',1,'Turbo chantrei','Turbo chantrei','Turbo chantre',2,0,'','','Dumortier','6d001727-d448-535f-b009-52eee1f489b4','Turbo chantrei Dumortier, 1867','Dumortier, 1867','UNRANKED','','Turbo','','chantrei','','','',NULL,'','','','','','Dumortier','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05706','','','Pleurotoma chapuisi Deshayes, 1865',1,'Pleurotoma chapuisi','Pleurotoma chapuisi','Pleurotoma chapuis',2,0,'','','Deshayes','1fdd98f0-2a5f-5218-83b6-b3fc03198e0c','Pleurotoma chapuisi Deshayes, 1865','Deshayes, 1865','UNRANKED','','Pleurotoma','','chapuisi','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05708','','','Natica chapuisiana Ryckholt, 1860',1,'Natica chapuisiana','Natica chapuisiana','Natica chapuisian',2,0,'','','Ryckholt','6d5ae9dc-d6b2-5601-bcd0-ca6efff6455e','Natica chapuisiana Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Natica','','chapuisiana','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05713','','','Unio charlottensis Lea, 1863',1,'Unio charlottensis','Unio charlottensis','Unio charlottens',2,0,'','','Lea','4e36fa23-22a3-5d4e-b435-6f95b367b454','Unio charlottensis Lea, 1863','Lea, 1863','UNRANKED','','Unio','','charlottensis','','','',NULL,'','','','','','Lea','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05714','','','Lima charmasseana Cotteau, 1855',1,'Lima charmasseana','Lima charmasseana','Lima charmassean',2,0,'','','Cotteau','9d84e94a-3611-5af1-a630-00ce043ac760','Lima charmasseana Cotteau, 1855','Cotteau, 1855','UNRANKED','','Lima','','charmasseana','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05719','','','Daudebardia charopia Letourneux, 1870',1,'Daudebardia charopia','Daudebardia charopia','Daudebardia charop',2,0,'','','Letourneux','3ce89e9b-2e00-5a45-8d50-434089c54f1c','Daudebardia charopia Letourneux, 1870','Letourneux, 1870','UNRANKED','','Daudebardia','','charopia','','','',NULL,'','','','','','Letourneux','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05721','','','Amnicola charpentieri Roth, 1855',1,'Amnicola charpentieri','Amnicola charpentieri','Amnicola charpentier',2,0,'','','Roth','81783ce7-5c6e-5d23-a082-b72d497213ae','Amnicola charpentieri Roth, 1855','Roth, 1855','UNRANKED','','Amnicola','','charpentieri','','','',NULL,'','','','','','Roth','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05728','','','Nautilus charpentieri Leymerie, 1851',1,'Nautilus charpentieri','Nautilus charpentieri','Nautilus charpentier',2,0,'','','Leymerie','c0092def-ebcf-5d0d-8a9d-b0ba3dd792c1','Nautilus charpentieri Leymerie, 1851','Leymerie, 1851','UNRANKED','','Nautilus','','charpentieri','','','',NULL,'','','','','','Leymerie','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05733','','','Vitrina charpentieri Stabile, 1859',1,'Vitrina charpentieri','Vitrina charpentieri','Vitrina charpentier',2,0,'','','Stabile','8cbfaa09-a14c-5fef-a3d1-677869e715ee','Vitrina charpentieri Stabile, 1859','Stabile, 1859','UNRANKED','','Vitrina','','charpentieri','','','',NULL,'','','','','','Stabile','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05741','','','Unio chattanoogaensis Lea, 1858',1,'Unio chattanoogaensis','Unio chattanoogaensis','Unio chattanoogaens',2,0,'','','Lea','8b8460e6-d610-51ce-9587-27baf1934e1b','Unio chattanoogaensis Lea, 1858','Lea, 1858','UNRANKED','','Unio','','chattanoogaensis','','','',NULL,'','','','','','Lea','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05743','','','Acteonina chavannesi Pictet and Renevier, 1854',1,'Acteonina chavannesi','Acteonina chavannesi','Acteonina chauannes',2,0,'','','Pictet|Renevier','69d7288d-4b6f-5aa3-9aec-056faa716ba8','Acteonina chavannesi Pictet and Renevier, 1854','Pictet and Renevier, 1854','UNRANKED','','Acteonina','','chavannesi','','','',NULL,'','','','','','Pictet & Renevier','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05748','','','Helix chelonitis Crosse, 1868',1,'Helix chelonitis','Helix chelonitis','Helix chelonit',2,0,'','','Crosse','0db84a39-16ee-59bb-95ac-c9ae35d7794f','Helix chelonitis Crosse, 1868','Crosse, 1868','UNRANKED','','Helix','','chelonitis','','','',NULL,'','','','','','Crosse','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05754','','','Separatista chemnitzii A. Adams, 1850',1,'Separatista chemnitzii','Separatista chemnitzii','Separatista chemnitz',2,0,'','','A. Adams','37ba7e8c-210a-5dc4-9d40-e09bf46090c0','Separatista chemnitzii A. Adams, 1850','A. Adams, 1850','UNRANKED','','Separatista','','chemnitzii','','','',NULL,'','','','','','A. Adams','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05757','','','Bulimus chemnitzioides Forbes, 1850',1,'Bulimus chemnitzioides','Bulimus chemnitzioides','Bulimus chemnitzioid',2,0,'','','Forbes','26e2266a-3f6e-5993-a775-5a67de6cccb0','Bulimus chemnitzioides Forbes, 1850','Forbes, 1850','UNRANKED','','Bulimus','','chemnitzioides','','','',NULL,'','','','','','Forbes','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05764','','','Pleurotoma chersonesus Baily, 1858',1,'Pleurotoma chersonesus','Pleurotoma chersonesus','Pleurotoma chersones',2,0,'','','Baily','59f908cc-eade-5440-aca9-52c193bff13d','Pleurotoma chersonesus Baily, 1858','Baily, 1858','UNRANKED','','Pleurotoma','','chersonesus','','','',NULL,'','','','','','Baily','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05772','','','Pleurotomaria chesterensis Meek and Worthen, 1860',1,'Pleurotomaria chesterensis','Pleurotomaria chesterensis','Pleurotomaria chesterens',2,0,'','','Meek|Worthen','7bd01bc8-e3e9-5fab-b617-d07c31b33569','Pleurotomaria chesterensis Meek and Worthen, 1860','Meek and Worthen, 1860','UNRANKED','','Pleurotomaria','','chesterensis','','','',NULL,'','','','','','Meek & Worthen','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05780','','','Tellina cheyenensis Meek and Hayden, 1856',1,'Tellina cheyenensis','Tellina cheyenensis','Tellina cheyenens',2,0,'','','Meek|Hayden','16329c58-9587-5d86-85d1-c2f7672b56dd','Tellina cheyenensis Meek and Hayden, 1856','Meek and Hayden, 1856','UNRANKED','','Tellina','','cheyenensis','','','',NULL,'','','','','','Meek & Hayden','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05785','','','Helix chiapensis Pfeiffer, 1856',1,'Helix chiapensis','Helix chiapensis','Helix chiapens',2,0,'','','Pfeiffer','a3ef618c-0248-51f9-b672-b03e22b1fac6','Helix chiapensis Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Helix','','chiapensis','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05791','','','Cerithium chiemiense Gümbel, 1861',1,'Cerithium chiemiense','Cerithium chiemiense','Cerithium chiemiens',2,0,'','','Gümbel','00ebaf69-4416-59aa-b95f-9fc90e111d6a','Cerithium chiemiense Gümbel, 1861','Gümbel, 1861','UNRANKED','','Cerithium','','chiemiense','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05795','','','Onchidium chilense Hupe, 1854',1,'Onchidium chilense','Onchidium chilense','Onchidium chilens',2,0,'','','Hupe','83b2901b-1210-5449-8b4f-f732539a5ff1','Onchidium chilense Hupe, 1854','Hupe, 1854','UNRANKED','','Onchidium','','chilense','','','',NULL,'','','','','','Hupe','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05800','','','Saxicava chilensis Hupe, 1854',1,'Saxicava chilensis','Saxicava chilensis','Saxicava chilens',2,0,'','','Hupe','0514cc1e-f62e-5ef1-ac12-902b38901399','Saxicava chilensis Hupe, 1854','Hupe, 1854','UNRANKED','','Saxicava','','chilensis','','','',NULL,'','','','','','Hupe','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05805','','','Cyrena chilina Prime, 1867',1,'Cyrena chilina','Cyrena chilina','Cyrena chilin',2,0,'','','Prime','9d934510-68c5-5022-a6b5-88b0f8bab7b2','Cyrena chilina Prime, 1867','Prime, 1867','UNRANKED','','Cyrena','','chilina','','','',NULL,'','','','','','Prime','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05812','','','Patella chiloensis Reeve, 1855',1,'Patella chiloensis','Patella chiloensis','Patella chiloens',2,0,'','','Reeve','d5ba9898-92cd-5d48-a8fc-775934e69c1e','Patella chiloensis Reeve, 1855','Reeve, 1855','UNRANKED','','Patella','','chiloensis','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05819','','','Auricula chinensis Pfeiffer, 1854',1,'Auricula chinensis','Auricula chinensis','Auricula chinens',2,0,'','','Pfeiffer','7b4c0be9-d542-5a34-be0d-0f6cb7199d6a','Auricula chinensis Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Auricula','','chinensis','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05825','','','Petricola chinensis Deshayes, 1853',1,'Petricola chinensis','Petricola chinensis','Petricola chinens',2,0,'','','Deshayes','b2d50a84-9144-5a9f-9cc6-00ffe7cb9dcb','Petricola chinensis Deshayes, 1853','Deshayes, 1853','UNRANKED','','Petricola','','chinensis','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05832','','','Arca chiriquiensis Gabb, 1860',1,'Arca chiriquiensis','Arca chiriquiensis','Arca chiriquiens',2,0,'','','Gabb','508f2fa5-7f20-52e3-8d58-6776f033a859','Arca chiriquiensis Gabb, 1860','Gabb, 1860','UNRANKED','','Arca','','chiriquiensis','','','',NULL,'','','','','','Gabb','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05835','','','Corbula chittyana C.B. Adams, 1852',1,'Corbula chittyana','Corbula chittyana','Corbula chittyan',2,0,'','','C. B. Adams','25434023-8320-5d10-8839-1f8bf6f2f812','Corbula chittyana C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Corbula','','chittyana','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05841','','','Cochlostyla chloroleuca Martens, 1868',1,'Cochlostyla chloroleuca','Cochlostyla chloroleuca','Cochlostyla chloroleuc',2,0,'','','Martens','c5f8cf06-0301-594a-b6c3-5a01e177c28b','Cochlostyla chloroleuca Martens, 1868','Martens, 1868','UNRANKED','','Cochlostyla','','chloroleuca','','','',NULL,'','','','','','Martens','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05843','','','Infundibulum chloromphalus A. Adams, 1851',1,'Infundibulum chloromphalus','Infundibulum chloromphalus','Infundibulum chloromphal',2,0,'','','A. Adams','49c78ad4-8213-549e-b6a0-f20aa05ee99b','Infundibulum chloromphalus A. Adams, 1851','A. Adams, 1851','UNRANKED','','Infundibulum','','chloromphalus','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05848','','','Teredo chlorotica Gould, 1870',1,'Teredo chlorotica','Teredo chlorotica','Teredo chlorotic',2,0,'','','Gould','53e1b64b-1887-5d9e-b964-f3a9dfe1952f','Teredo chlorotica Gould, 1870','Gould, 1870','UNRANKED','','Teredo','','chlorotica','','','',NULL,'','','','','','Gould','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05850','','','Bulimus chloroticus Pfeiffer, 1853',1,'Bulimus chloroticus','Bulimus chloroticus','Bulimus chlorotic',2,0,'','','Pfeiffer','a4c5869a-4aee-50cb-9e33-eeabaa8ecb45','Bulimus chloroticus Pfeiffer, 1853','Pfeiffer, 1853','UNRANKED','','Bulimus','','chloroticus','','','',NULL,'','','','','','Pfeiffer','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05856','','','Arca choffati Thurmann, in Thurmann and Etallon, 1862',2,'Arca choffati','Arca choffati','Arca choffat',2,0,'','','Thurmann|Etallon','45637bae-eb01-5fc9-8e87-4aa1203e253b','Arca choffati Thurmann, in Thurmann and Etallon, 1862','Thurmann, in Thurmann and Etallon, 1862','UNRANKED','','Arca','','choffati','','','',NULL,'','','','','','Thurmann','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05862','','','Diplommatina chordata Pfeiffer, 1855',1,'Diplommatina chordata','Diplommatina chordata','Diplommatina chordat',2,0,'','','Pfeiffer','962a61a6-b3dd-5cf4-a69d-9734a41099d1','Diplommatina chordata Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Diplommatina','','chordata','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05866','','','Cyclostoma chordiferum Pfeiffer, 1855',1,'Cyclostoma chordiferum','Cyclostoma chordiferum','Cyclostoma chordifer',2,0,'','','Pfeiffer','e27496ac-1644-5c71-a769-502c739708cf','Cyclostoma chordiferum Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Cyclostoma','','chordiferum','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05872','','','Neritina christovalensis Reeve, 1856',1,'Neritina christovalensis','Neritina christovalensis','Neritina christoualens',2,0,'','','Reeve','d63aeb42-22c6-526f-acb3-f38413befcac','Neritina christovalensis Reeve, 1856','Reeve, 1856','UNRANKED','','Neritina','','christovalensis','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05881','','','Amycla chrysalloidea P. Carpenter, 1864',1,'Amycla chrysalloidea','Amycla chrysalloidea','Amycla chrysalloide',2,0,'','','P. Carpenter','9b24b6a6-5fae-548c-af1c-ac0fc6e5941f','Amycla chrysalloidea P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Amycla','','chrysalloidea','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05884','','','Unio favidens chryseis Benson, 1862',1,'Unio favidens chryseis','Unio favidens chryseis','Unio fauidens chryse',3,0,'','','Benson','413a4f20-88d0-599a-802c-2061157ca1a8','Unio favidens chryseis Benson, 1862','Benson, 1862','UNRANKED','','Unio','','favidens','chryseis','','',NULL,'','','','','','Benson','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05889','','','Helix chrysosticta Morelet, 1868',1,'Helix chrysosticta','Helix chrysosticta','Helix chrysostict',2,0,'','','Morelet','df9b7de8-0c28-5dae-8923-fd0ae6acbe8c','Helix chrysosticta Morelet, 1868','Morelet, 1868','UNRANKED','','Helix','','chrysosticta','','','',NULL,'','','','','','Morelet','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05899','','','Murchisonia cicelia Billings, 1865',1,'Murchisonia cicelia','Murchisonia cicelia','Murchisonia cicel',2,0,'','','Billings','561b6f7b-5c09-579f-a951-34af9ac0eaef','Murchisonia cicelia Billings, 1865','Billings, 1865','UNRANKED','','Murchisonia','','cicelia','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05906','','','Amnicola ciliata Gould, 1851',1,'Amnicola ciliata','Amnicola ciliata','Amnicola ciliat',2,0,'','','Gould','2c14d9c7-fc67-5a17-a9a8-2312e26a511a','Amnicola ciliata Gould, 1851','Gould, 1851','UNRANKED','','Amnicola','','ciliata','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05912','','','Pleurotomaria cilicina Ryckholt, 1861',1,'Pleurotomaria cilicina','Pleurotomaria cilicina','Pleurotomaria cilicin',2,0,'','','Ryckholt','a8ac85f2-ecad-5507-bf45-a2aabbf35931','Pleurotomaria cilicina Ryckholt, 1861','Ryckholt, 1861','UNRANKED','','Pleurotomaria','','cilicina','','','',NULL,'','','','','','Ryckholt','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05924','','','Avicula cincta Alth, 1850',1,'Avicula cincta','Avicula cincta','Avicula cinct',2,0,'','','Alth','62decb5e-16fb-5473-a871-0db85aa42d4c','Avicula cincta Alth, 1850','Alth, 1850','UNRANKED','','Avicula','','cincta','','','',NULL,'','','','','','Alth','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05928','','','Cyprina cincta Eichwald, 1868',1,'Cyprina cincta','Cyprina cincta','Cyprina cinct',2,0,'','','Eichwald','d022c91e-4624-5c33-a9ac-df9a231ab97e','Cyprina cincta Eichwald, 1868','Eichwald, 1868','UNRANKED','','Cyprina','','cincta','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05933','','','Ostrea cincta Schafhäutl, 1863',1,'Ostrea cincta','Ostrea cincta','Ostrea cinct',2,0,'','','Schafhäutl','65e831e7-5098-5ce0-9aa4-bb1256cdb271','Ostrea cincta Schafhäutl, 1863','Schafhäutl, 1863','UNRANKED','','Ostrea','','cincta','','','',NULL,'','','','','','Schafhäutl','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05936','','','Teredo cincta Deshayes, 1856',1,'Teredo cincta','Teredo cincta','Teredo cinct',2,0,'','','Deshayes','588f0eb0-e1a7-5bf2-b203-d377173f7aff','Teredo cincta Deshayes, 1856','Deshayes, 1856','UNRANKED','','Teredo','','cincta','','','',NULL,'','','','','','Deshayes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05942','','','Leiostraca cinctella A. Adams, 1864',1,'Leiostraca cinctella','Leiostraca cinctella','Leiostraca cinctell',2,0,'','','A. Adams','d191f751-cda6-58ea-9b07-6bfab9a8d5b8','Leiostraca cinctella A. Adams, 1864','A. Adams, 1864','UNRANKED','','Leiostraca','','cinctella','','','',NULL,'','','','','','A. Adams','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05947','','','Turbonilla cinctella Mörch, 1859',1,'Turbonilla cinctella','Turbonilla cinctella','Turbonilla cinctell',2,0,'','','Mörch','7d5923e4-afcd-5c44-a3d0-cd48f9f067a8','Turbonilla cinctella Mörch, 1859','Mörch, 1859','UNRANKED','','Turbonilla','','cinctella','','','',NULL,'','','','','','Mörch','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05951','','','Tylostoma cinctum Ryckholt, 1860',1,'Tylostoma cinctum','Tylostoma cinctum','Tylostoma cinct',2,0,'','','Ryckholt','1dea8106-0e92-5fa3-9275-5a1e5880a48c','Tylostoma cinctum Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Tylostoma','','cinctum','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05955','','','Venus cineracea Hupe, 1854',1,'Venus cineracea','Venus cineracea','Venus cinerace',2,0,'','','Hupe','c31debc0-814f-5a03-a202-88f62775bec8','Venus cineracea Hupe, 1854','Hupe, 1854','UNRANKED','','Venus','','cineracea','','','',NULL,'','','','','','Hupe','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05962','','','Goniobasis cinerea Lea, 1862',1,'Goniobasis cinerea','Goniobasis cinerea','Goniobasis cinere',2,0,'','','Lea','22a30d49-974e-5c2a-ab21-8ea9bd630de0','Goniobasis cinerea Lea, 1862','Lea, 1862','UNRANKED','','Goniobasis','','cinerea','','','',NULL,'','','','','','Lea','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05966','','','Pupa triplicata cinerea A. Moquin-Tandon, 1855',1,'Pupa triplicata cinerea','Pupa triplicata cinerea','Pupa triplicat cinere',3,0,'','','A. Moquin-Tandon','474ff69b-86c2-584e-b3fa-bc7fd29bb574','Pupa triplicata cinerea A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Pupa','','triplicata','cinerea','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05971','','','Bulimus cinereus Mortillet, in Petit, 1852',2,'Bulimus cinereus','Bulimus cinereus','Bulimus cinere',2,0,'','','Mortillet|Petit','bb16aa67-edba-5e9d-ace3-ce24e7ffbc63','Bulimus cinereus Mortillet, in Petit, 1852','Mortillet, in Petit, 1852','UNRANKED','','Bulimus','','cinereus','','','',NULL,'','','','','','Mortillet','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05980','','','Corbis lajoyei cingenda Morris and Lycett, 1853',1,'Corbis lajoyei cingenda','Corbis lajoyei cingenda','Corbis laioye cingend',3,0,'','','Morris|Lycett','fb2b1ca5-79e5-5de0-bced-db0e19f14374','Corbis lajoyei cingenda Morris and Lycett, 1853','Morris and Lycett, 1853','UNRANKED','','Corbis','','lajoyei','cingenda','','',NULL,'','','','','','Morris & Lycett','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05983','','','Littorina clathrata cingillata Terquem, 1855',1,'Littorina clathrata cingillata','Littorina clathrata cingillata','Littorina clathrat cingillat',3,0,'','','Terquem','a77d40e2-df92-5509-952f-be78782417cd','Littorina clathrata cingillata Terquem, 1855','Terquem, 1855','UNRANKED','','Littorina','','clathrata','cingillata','','',NULL,'','','','','','Terquem','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05988','','','Turritella cingularo-lineata J. Mriller, 1851',1,'Turritella cingularo-lineata','Turritella cingularo-lineata','Turritella cingularo-lineat',2,0,'','','J. Mriller','f519cfe4-bc24-5320-9f2a-6e41f8aae02f','Turritella cingularo-lineata J. Mriller, 1851','J. Mriller, 1851','UNRANKED','','Turritella','','cingularo-lineata','','','',NULL,'','','','','','J. Mriller','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05993','','','Cerithiopsis (Seila) cingulata A. Adams, 1861',1,'Cerithiopsis cingulata','Cerithiopsis cingulata','Cerithiopsis cingulat',2,0,'','','A. Adams','59e0aa32-6762-5d21-ae43-65336d89e0c3','Cerithiopsis (Seila) cingulata A. Adams, 1861','A. Adams, 1861','UNRANKED','','Cerithiopsis','Seila','cingulata','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_05995','','','Delphinula cingulata Philippi, 1852',1,'Delphinula cingulata','Delphinula cingulata','Delphinula cingulat',2,0,'','','Philippi','c598784e-6f4c-5ed8-936e-775571f07835','Delphinula cingulata Philippi, 1852','Philippi, 1852','UNRANKED','','Delphinula','','cingulata','','','',NULL,'','','','','','Philippi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06000','','','Melania cingulata J. Moricand, 1860',1,'Melania cingulata','Melania cingulata','Melania cingulat',2,0,'','','J. Moricand','fd362aac-e354-5a5b-a865-2f5e8eff5e20','Melania cingulata J. Moricand, 1860','J. Moricand, 1860','UNRANKED','','Melania','','cingulata','','','',NULL,'','','','','','J. Moricand','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06003','','','Monoptygma cingulata A. Adams, 1861',1,'Monoptygma cingulata','Monoptygma cingulata','Monoptygma cingulat',2,0,'','','A. Adams','f5012846-0650-5304-a577-a4ad86c2e7c2','Monoptygma cingulata A. Adams, 1861','A. Adams, 1861','UNRANKED','','Monoptygma','','cingulata','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06009','','','Scissurella cingulata O. Costa, 1861',1,'Scissurella cingulata','Scissurella cingulata','Scissurella cingulat',2,0,'','','O. Costa','ba1b48ff-c027-5f82-a564-e394665854e3','Scissurella cingulata O. Costa, 1861','O. Costa, 1861','UNRANKED','','Scissurella','','cingulata','','','',NULL,'','','','','','O. Costa','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06016','','','Voluta cingulata J. Müller, 1851',1,'Voluta cingulata','Voluta cingulata','Voluta cingulat',2,0,'','','J. Müller','f4d11cb2-a8e1-5bcc-9528-0f9391e6a20b','Voluta cingulata J. Müller, 1851','J. Müller, 1851','UNRANKED','','Voluta','','cingulata','','','',NULL,'','','','','','J. Müller','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06023','','','Dosinia cingulifera E. Römer, 1862',1,'Dosinia cingulifera','Dosinia cingulifera','Dosinia cingulifer',2,0,'','','E. Römer','3abfbab3-8342-5656-a9da-6b1394f224ba','Dosinia cingulifera E. Römer, 1862','E. Römer, 1862','UNRANKED','','Dosinia','','cingulifera','','','',NULL,'','','','','','E. Römer','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06029','','','Elusa cinnamomea A. Adams, 1862',1,'Elusa cinnamomea','Elusa cinnamomea','Elusa cinnamome',2,0,'','','A. Adams','dfd1316b-b5b4-5754-a32b-8c7f45c8a273','Elusa cinnamomea A. Adams, 1862','A. Adams, 1862','UNRANKED','','Elusa','','cinnamomea','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06034','','','Unio cinnamomicus Lea, 1861',1,'Unio cinnamomicus','Unio cinnamomicus','Unio cinnamomic',2,0,'','','Lea','365a5903-595c-515b-9157-e05df13d9201','Unio cinnamomicus Lea, 1861','Lea, 1861','UNRANKED','','Unio','','cinnamomicus','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06038','','','Ditrupa ciplyana Ryckholt, 1852',1,'Ditrupa ciplyana','Ditrupa ciplyana','Ditrupa ciplyan',2,0,'','','Ryckholt','4b2fd576-c356-5096-a341-0ed98ef53102','Ditrupa ciplyana Ryckholt, 1852','Ryckholt, 1852','UNRANKED','','Ditrupa','','ciplyana','','','',NULL,'','','','','','Ryckholt','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06042','','','Trapezium ciplyanum Ryckholt, 1860',1,'Trapezium ciplyanum','Trapezium ciplyanum','Trapezium ciplyan',2,0,'','','Ryckholt','d946b1ea-c4f6-51d5-ba99-501bd8711ffd','Trapezium ciplyanum Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Trapezium','','ciplyanum','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06045','','','Mytilus ciplyanus Ryckholt, 1852',1,'Mytilus ciplyanus','Mytilus ciplyanus','Mytilus ciplyan',2,0,'','','Ryckholt','b4927a5f-8d63-5aae-83fc-c895c3ccb6f6','Mytilus ciplyanus Ryckholt, 1852','Ryckholt, 1852','UNRANKED','','Mytilus','','ciplyanus','','','',NULL,'','','','','','Ryckholt','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06050','','','Dosinia circinaria Deshayes, 1853',1,'Dosinia circinaria','Dosinia circinaria','Dosinia circinar',2,0,'','','Deshayes','e9ca38c0-4535-5fb1-8530-873fa4dca885','Dosinia circinaria Deshayes, 1853','Deshayes, 1853','UNRANKED','','Dosinia','','circinaria','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06051','','','Alvania circinata A. Adams, 1861',1,'Alvania circinata','Alvania circinata','Alvania circinat',2,0,'','','A. Adams','65711996-9626-5f5e-b557-93d44787c4ea','Alvania circinata A. Adams, 1861','A. Adams, 1861','UNRANKED','','Alvania','','circinata','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06053','','','Myrtea circinata A. Adams, 1862',1,'Myrtea circinata','Myrtea circinata','Myrtea circinat',2,0,'','','A. Adams','b858faac-3a85-5d4c-b905-20d0913fc687','Myrtea circinata A. Adams, 1862','A. Adams, 1862','UNRANKED','','Myrtea','','circinata','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06059','','','Berthella circularis Mörch, 1863',1,'Berthella circularis','Berthella circularis','Berthella circular',2,0,'','','Mörch','15f8e463-e5ea-5012-a6bf-ee592ee29547','Berthella circularis Mörch, 1863','Mörch, 1863','UNRANKED','','Berthella','','circularis','','','',NULL,'','','','','','Mörch','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06063','','','Littorina circularis C. Moore, 1867',1,'Littorina circularis','Littorina circularis','Littorina circular',2,0,'','','C. Moore','8582b86d-7448-5b75-9660-492e0ac12976','Littorina circularis C. Moore, 1867','C. Moore, 1867','UNRANKED','','Littorina','','circularis','','','',NULL,'','','','','','C. Moore','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06070','','','Nassa (Eione) circumcincta A. Adams, 1851',1,'Nassa circumcincta','Nassa circumcincta','Nassa circumcinct',2,0,'','','A. Adams','6bab96b8-632d-5b68-98db-2c5d12208ff5','Nassa (Eione) circumcincta A. Adams, 1851','A. Adams, 1851','UNRANKED','','Nassa','Eione','circumcincta','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06073','','','Mitra circumcisa Beyrich, 1854',1,'Mitra circumcisa','Mitra circumcisa','Mitra circumcis',2,0,'','','Beyrich','2dd411ad-43fc-5899-bfac-af9f2f81b5b4','Mitra circumcisa Beyrich, 1854','Beyrich, 1854','UNRANKED','','Mitra','','circumcisa','','','',NULL,'','','','','','Beyrich','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06078','','','Mitra circumfossa Beyrich, 1854',1,'Mitra circumfossa','Mitra circumfossa','Mitra circumfoss',2,0,'','','Beyrich','879201fa-6c0d-5114-b502-1328f3b232f1','Mitra circumfossa Beyrich, 1854','Beyrich, 1854','UNRANKED','','Mitra','','circumfossa','','','',NULL,'','','','','','Beyrich','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06083','','','Planorbis circumlineatus Shuttleworth, 1854',1,'Planorbis circumlineatus','Planorbis circumlineatus','Planorbis circumlineat',2,0,'','','Shuttleworth','8957ea5d-6748-5cb6-9cc9-8f45df5f748b','Planorbis circumlineatus Shuttleworth, 1854','Shuttleworth, 1854','UNRANKED','','Planorbis','','circumlineatus','','','',NULL,'','','','','','Shuttleworth','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06087','','','Melania circumstriata Metcalfe, 1851',1,'Melania circumstriata','Melania circumstriata','Melania circumstriat',2,0,'','','Metcalfe','771e3e46-9c39-5b21-9cf5-d76f206a11b8','Melania circumstriata Metcalfe, 1851','Metcalfe, 1851','UNRANKED','','Melania','','circumstriata','','','',NULL,'','','','','','Metcalfe','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06094','','','Caecum circumvolutum Folin, 1867',1,'Caecum circumvolutum','Caecum circumvolutum','Caecum circumuolut',2,0,'','','Folin','93f67b0e-ba73-554d-aa1f-c6efbee8be58','Caecum circumvolutum Folin, 1867','Folin, 1867','UNRANKED','','Caecum','','circumvolutum','','','',NULL,'','','','','','Folin','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06101','','','Ferussacia cirtana Bourguignat, 1867',1,'Ferussacia cirtana','Ferussacia cirtana','Ferussacia cirtan',2,0,'','','Bourguignat','a5c6dc0c-7d19-5459-9d7f-afec84228fab','Ferussacia cirtana Bourguignat, 1867','Bourguignat, 1867','UNRANKED','','Ferussacia','','cirtana','','','',NULL,'','','','','','Bourguignat','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06106','','','Anatina cistella Reeve, 1863',1,'Anatina cistella','Anatina cistella','Anatina cistell',2,0,'','','Reeve','751aadb0-b9a4-5a22-b63b-4fa1de54b389','Anatina cistella Reeve, 1863','Reeve, 1863','UNRANKED','','Anatina','','cistella','','','',NULL,'','','','','','Reeve','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06112','','','Mangelia cithara Gould, 1851',1,'Mangelia cithara','Mangelia cithara','Mangelia cithar',2,0,'','','Gould','cf76d63a-bf7d-51a9-866c-8faa07c9074b','Mangelia cithara Gould, 1851','Gould, 1851','UNRANKED','','Mangelia','','cithara','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06117','','','Avicula (Meleagrina) citrina Dunker, 1852',1,'Avicula citrina','Avicula citrina','Avicula citrin',2,0,'','','Dunker','81332d67-f981-5283-a186-604462804d6e','Avicula (Meleagrina) citrina Dunker, 1852','Dunker, 1852','UNRANKED','','Avicula','Meleagrina','citrina','','','',NULL,'','','','','','Dunker','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06122','','','Natica citrina Philippi, 1851',1,'Natica citrina','Natica citrina','Natica citrin',2,0,'','','Philippi','10553917-736e-5fcd-934e-ccfd34093ede','Natica citrina Philippi, 1851','Philippi, 1851','UNRANKED','','Natica','','citrina','','','',NULL,'','','','','','Philippi','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06127','','','Cerithium citrinum G. Sowerby, 1855',1,'Cerithium citrinum','Cerithium citrinum','Cerithium citrin',2,0,'','','G. Sowerby','e9c1f55a-a789-5085-9f89-7d0e9a44a520','Cerithium citrinum G. Sowerby, 1855','G. Sowerby, 1855','UNRANKED','','Cerithium','','citrinum','','','',NULL,'','','','','','G. Sowerby','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06131','','','Pisania claibornensis Whitfield, 1865',1,'Pisania claibornensis','Pisania claibornensis','Pisania claibornens',2,0,'','','Whitfield','0817413f-b27c-565b-ac22-97088fd318f1','Pisania claibornensis Whitfield, 1865','Whitfield, 1865','UNRANKED','','Pisania','','claibornensis','','','',NULL,'','','','','','Whitfield','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06135','','','Rissoa clandestina C.B. Adams, 1852',1,'Rissoa clandestina','Rissoa clandestina','Rissoa clandestin',2,0,'','','C. B. Adams','42915308-118e-58e8-ad5a-2c17ee359c94','Rissoa clandestina C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Rissoa','','clandestina','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06143','','','Hettangia clapensis Terquem and Jourdy, 1869',1,'Hettangia clapensis','Hettangia clapensis','Hettangia clapens',2,0,'','','Terquem|Jourdy','871184e3-0bc8-5ad7-9f92-0cd154c7a7f9','Hettangia clapensis Terquem and Jourdy, 1869','Terquem and Jourdy, 1869','UNRANKED','','Hettangia','','clapensis','','','',NULL,'','','','','','Terquem & Jourdy','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06151','','','Melania clara Anthony, 1854',1,'Melania clara','Melania clara','Melania clar',2,0,'','','Anthony','58e63723-bcf7-56d6-8077-5e279e112299','Melania clara Anthony, 1854','Anthony, 1854','UNRANKED','','Melania','','clara','','','',NULL,'','','','','','Anthony','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06156','','','Isocardia clarissima Leckenby, 1858',1,'Isocardia clarissima','Isocardia clarissima','Isocardia clarissim',2,0,'','','Leckenby','e2878fd2-adaa-5c01-b718-b139a695c467','Isocardia clarissima Leckenby, 1858','Leckenby, 1858','UNRANKED','','Isocardia','','clarissima','','','',NULL,'','','','','','Leckenby','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06165','','','Unio clarkianus Lea, 1852',1,'Unio clarkianus','Unio clarkianus','Unio clarkian',2,0,'','','Lea','f8d6a031-e97b-5451-89ed-9824a84aedcd','Unio clarkianus Lea, 1852','Lea, 1852','UNRANKED','','Unio','','clarkianus','','','',NULL,'','','','','','Lea','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06171','','','Cardita clathrata Buvignier, 1852',1,'Cardita clathrata','Cardita clathrata','Cardita clathrat',2,0,'','','Buvignier','082bdc3f-66ad-51d9-8eb3-d49807387cf6','Cardita clathrata Buvignier, 1852','Buvignier, 1852','UNRANKED','','Cardita','','clathrata','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06177','','','Emarginula clathrata Pease, 1862',1,'Emarginula clathrata','Emarginula clathrata','Emarginula clathrat',2,0,'','','Pease','1648a18b-a205-567a-8b17-e5300990d969','Emarginula clathrata Pease, 1862','Pease, 1862','UNRANKED','','Emarginula','','clathrata','','','',NULL,'','','','','','Pease','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06182','','','Posidonia clathrata Lea, 1853',1,'Posidonia clathrata','Posidonia clathrata','Posidonia clathrat',2,0,'','','Lea','9af3995b-2789-5576-9ff1-ef1e6b70fcbe','Posidonia clathrata Lea, 1853','Lea, 1853','UNRANKED','','Posidonia','','clathrata','','','',NULL,'','','','','','Lea','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06184','','','Pyrgula clathrata A. Adams, 1853',1,'Pyrgula clathrata','Pyrgula clathrata','Pyrgula clathrat',2,0,'','','A. Adams','492e80fc-c9aa-53ed-a769-1f801013df06','Pyrgula clathrata A. Adams, 1853','A. Adams, 1853','UNRANKED','','Pyrgula','','clathrata','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06190','','','Venus clathrata Deshayes, 1853',1,'Venus clathrata','Venus clathrata','Venus clathrat',2,0,'','','Deshayes','cc495c68-e722-5c03-a03d-312f58ad3e62','Venus clathrata Deshayes, 1853','Deshayes, 1853','UNRANKED','','Venus','','clathrata','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06195','','','Helix clathratula Pfeiffer, 1850',1,'Helix clathratula','Helix clathratula','Helix clathratul',2,0,'','','Pfeiffer','d1a151c7-952d-5ffe-9fd8-32f7d462d020','Helix clathratula Pfeiffer, 1850','Pfeiffer, 1850','UNRANKED','','Helix','','clathratula','','','',NULL,'','','','','','Pfeiffer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06200','','','Cerithium clathratum A. Adams, in G. Sowerby, 1855',2,'Cerithium clathratum','Cerithium clathratum','Cerithium clathrat',2,0,'','','A. Adams|G. Sowerby','6dc437b9-da1c-5cfa-b636-8b3e9a7ff610','Cerithium clathratum A. Adams, in G. Sowerby, 1855','A. Adams, in G. Sowerby, 1855','UNRANKED','','Cerithium','','clathratum','','','',NULL,'','','','','','A. Adams','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06205','','','Triforis clathratus Gould, 1861',1,'Triforis clathratus','Triforis clathratus','Triforis clathrat',2,0,'','','Gould','46f939bb-c71a-50cc-b303-00856974f604','Triforis clathratus Gould, 1861','Gould, 1861','UNRANKED','','Triforis','','clathratus','','','',NULL,'','','','','','Gould','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06207','','','Macroceramus claudens Gundlach, in Pfeiffer, 1859',2,'Macroceramus claudens','Macroceramus claudens','Macroceramus claudens',2,0,'','','Gundlach|Pfeiffer','ac99fa8f-7165-530b-b6f5-e6b204f8b4e1','Macroceramus claudens Gundlach, in Pfeiffer, 1859','Gundlach, in Pfeiffer, 1859','UNRANKED','','Macroceramus','','claudens','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06212','','','Martesia clausa Gabb, 1864',1,'Martesia clausa','Martesia clausa','Martesia claus',2,0,'','','Gabb','fc74d8d4-a5a0-5b1c-9608-6e706d829bf8','Martesia clausa Gabb, 1864','Gabb, 1864','UNRANKED','','Martesia','','clausa','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06216','','','Chrysallida clausiliformis P. Carpenter, 1856',1,'Chrysallida clausiliformis','Chrysallida clausiliformis','Chrysallida clausiliform',2,0,'','','P. Carpenter','f7b71374-a88b-5547-a8cf-da8c0001aeaa','Chrysallida clausiliformis P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Chrysallida','','clausiliformis','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06222','','','Cylindrella clava Pfeiffer, 1856',1,'Cylindrella clava','Cylindrella clava','Cylindrella clau',2,0,'','','Pfeiffer','7a981e90-b1d3-58bc-acce-c37ceb822e36','Cylindrella clava Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Cylindrella','','clava','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06228','','','Leiostraca clavata Guppy, 1867',1,'Leiostraca clavata','Leiostraca clavata','Leiostraca clauat',2,0,'','','Guppy','955f260b-0cc9-5774-a555-7d1fa6ff9221','Leiostraca clavata Guppy, 1867','Guppy, 1867','UNRANKED','','Leiostraca','','clavata','','','',NULL,'','','','','','Guppy','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06233','','','Dentalium clavatum Gould, 1859',1,'Dentalium clavatum','Dentalium clavatum','Dentalium clauat',2,0,'','','Gould','9144777d-7daf-5d38-b28e-b23d3ec8c6d0','Dentalium clavatum Gould, 1859','Gould, 1859','UNRANKED','','Dentalium','','clavatum','','','',NULL,'','','','','','Gould','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06238','','','Leiostraca clavella A. Adams, 1861',1,'Leiostraca clavella','Leiostraca clavella','Leiostraca clauell',2,0,'','','A. Adams','f088ea17-8117-51af-a245-69ee9242ca77','Leiostraca clavella A. Adams, 1861','A. Adams, 1861','UNRANKED','','Leiostraca','','clavella','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06241','','','Pandora claviculata P. Carpenter, 1855',1,'Pandora claviculata','Pandora claviculata','Pandora clauiculat',2,0,'','','P. Carpenter','98af71a2-8ac9-51d8-a689-30114758632d','Pandora claviculata P. Carpenter, 1855','P. Carpenter, 1855','UNRANKED','','Pandora','','claviculata','','','',NULL,'','','','','','P. Carpenter','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06248','','','Cerithiopsis clavula A. Adams, 1861',1,'Cerithiopsis clavula','Cerithiopsis clavula','Cerithiopsis clauul',2,0,'','','A. Adams','b21b25a8-99dd-5266-bdf4-58ae9e008dfc','Cerithiopsis clavula A. Adams, 1861','A. Adams, 1861','UNRANKED','','Cerithiopsis','','clavula','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06255','','','Cerithium clavulus Buvignier, 1852',1,'Cerithium clavulus','Cerithium clavulus','Cerithium clauul',2,0,'','','Buvignier','9e1d34a0-6af2-5e35-b0f8-9f159777f1ce','Cerithium clavulus Buvignier, 1852','Buvignier, 1852','UNRANKED','','Cerithium','','clavulus','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06261','','','Nerinea clavus Coquand, 1865',1,'Nerinea clavus','Nerinea clavus','Nerinea clau',2,0,'','','Coquand','8e52884c-11cc-5ec6-8113-e134f77998fd','Nerinea clavus Coquand, 1865','Coquand, 1865','UNRANKED','','Nerinea','','clavus','','','',NULL,'','','','','','Coquand','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06263','','','Turritella clealandiana Leach, in J. Gray, 1852',2,'Turritella clealandiana','Turritella clealandiana','Turritella clealandian',2,0,'','','Leach|J. Gray','24c07d19-fbd3-5a83-851b-d0ef87656111','Turritella clealandiana Leach, in J. Gray, 1852','Leach, in J. Gray, 1852','UNRANKED','','Turritella','','clealandiana','','','',NULL,'','','','','','Leach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06268','','','Venus cleopatra Coquand, 1862',1,'Venus cleopatra','Venus cleopatra','Venus cleopatr',2,0,'','','Coquand','f640edca-e015-5cf5-8179-fa5e0d111937','Venus cleopatra Coquand, 1862','Coquand, 1862','UNRANKED','','Venus','','cleopatra','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06271','','','Macroceramus clerchi Arango, in Pfeiffer, 1866',2,'Macroceramus clerchi','Macroceramus clerchi','Macroceramus clerch',2,0,'','','Arango|Pfeiffer','84870f06-061e-5900-86ab-87beae8cf975','Macroceramus clerchi Arango, in Pfeiffer, 1866','Arango, in Pfeiffer, 1866','UNRANKED','','Macroceramus','','clerchi','','','',NULL,'','','','','','Arango','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06277','','','Astarte cliftoni C. Moore, 1870',1,'Astarte cliftoni','Astarte cliftoni','Astarte clifton',2,0,'','','C. Moore','17b734a1-aaeb-5b41-b2fa-e7bff8173f61','Astarte cliftoni C. Moore, 1870','C. Moore, 1870','UNRANKED','','Astarte','','cliftoni','','','',NULL,'','','','','','C. Moore','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06284','','','Ostrea clot-beyi Bellardi, 1854',1,'Ostrea clot-beyi','Ostrea clot-beyi','Ostrea clot-bey',2,0,'','','Bellardi','9601e999-3ec8-598c-960b-8cadaf40d662','Ostrea clot-beyi Bellardi, 1854','Bellardi, 1854','UNRANKED','','Ostrea','','clot-beyi','','','',NULL,'','','','','','Bellardi','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06286','','','Bulimus clouei Pfeiffer, 1856',1,'Bulimus clouei','Bulimus clouei','Bulimus cloue',2,0,'','','Pfeiffer','80bf05b1-15ae-5239-b871-41438658c913','Bulimus clouei Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Bulimus','','clouei','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06294','','','Trochotoma clypeus Terquem, 1855',1,'Trochotoma clypeus','Trochotoma clypeus','Trochotoma clype',2,0,'','','Terquem','a0274ff2-1b17-5b2a-8e65-0c2da5dcbb6b','Trochotoma clypeus Terquem, 1855','Terquem, 1855','UNRANKED','','Trochotoma','','clypeus','','','',NULL,'','','','','','Terquem','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06299','','','Helix coagulata Pfeiffer, 1856',1,'Helix coagulata','Helix coagulata','Helix coagulat',2,0,'','','Pfeiffer','1357ff25-356a-551e-aeb1-dd5eb4b26eef','Helix coagulata Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Helix','','coagulata','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06305','','','Gastrochoena coarctata Deshayes, 1856',1,'Gastrochoena coarctata','Gastrochoena coarctata','Gastrochoena coarctat',2,0,'','','Deshayes','260bf60b-fe0c-52bd-b8a6-4c6a1f8b3f98','Gastrochoena coarctata Deshayes, 1856','Deshayes, 1856','UNRANKED','','Gastrochoena','','coarctata','','','',NULL,'','','','','','Deshayes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06309','','','Pleurotomaria coarctata Stoliczka, 1861',1,'Pleurotomaria coarctata','Pleurotomaria coarctata','Pleurotomaria coarctat',2,0,'','','Stoliczka','3971d790-33d2-5bb1-8086-178606e5cd13','Pleurotomaria coarctata Stoliczka, 1861','Stoliczka, 1861','UNRANKED','','Pleurotomaria','','coarctata','','','',NULL,'','','','','','Stoliczka','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06314','','','Trochus coarctatus Zekeli, 1852',1,'Trochus coarctatus','Trochus coarctatus','Trochus coarctat',2,0,'','','Zekeli','5fd309a8-f3c4-54bb-9332-e889b2b6e86f','Trochus coarctatus Zekeli, 1852','Zekeli, 1852','UNRANKED','','Trochus','','coarctatus','','','',NULL,'','','','','','Zekeli','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06321','','','Octopus cocco Risso, 1854',1,'Octopus cocco','Octopus cocco','Octopus cocc',2,0,'','','Risso','71fe264b-e24a-52e7-9c2c-62c994648748','Octopus cocco Risso, 1854','Risso, 1854','UNRANKED','','Octopus','','cocco','','','',NULL,'','','','','','Risso','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06326','','','Succinea cochinchinensis Pfeiffer, 1863',1,'Succinea cochinchinensis','Succinea cochinchinensis','Succinea cochinchinens',2,0,'','','Pfeiffer','0c6d1adb-7b16-5622-a446-dce6168468da','Succinea cochinchinensis Pfeiffer, 1863','Pfeiffer, 1863','UNRANKED','','Succinea','','cochinchinensis','','','',NULL,'','','','','','Pfeiffer','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06328','','','Cyrena cochinensis Hanley, 1858',1,'Cyrena cochinensis','Cyrena cochinensis','Cyrena cochinens',2,0,'','','Hanley','ba450204-faa7-56f6-a92f-fa991f0a2ce4','Cyrena cochinensis Hanley, 1858','Hanley, 1858','UNRANKED','','Cyrena','','cochinensis','','','',NULL,'','','','','','Hanley','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06336','','','Bithinia cochlearella Deshayes, 1862',1,'Bithinia cochlearella','Bithinia cochlearella','Bithinia cochlearell',2,0,'','','Deshayes','54e35e91-666c-5ff9-913e-12bfdec9550e','Bithinia cochlearella Deshayes, 1862','Deshayes, 1862','UNRANKED','','Bithinia','','cochlearella','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06343','','','Mytilus cochleatus Kickz, in Reeve, 1858',2,'Mytilus cochleatus','Mytilus cochleatus','Mytilus cochleat',2,0,'','','Kickz|Reeve','4f14c0f8-0c21-5d1c-b563-ccee45208b3a','Mytilus cochleatus Kickz, in Reeve, 1858','Kickz, in Reeve, 1858','UNRANKED','','Mytilus','','cochleatus','','','',NULL,'','','','','','Kickz','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06349','','','Petaloconchus cochlidium P. Carpenter, 1856',1,'Petaloconchus cochlidium','Petaloconchus cochlidium','Petaloconchus cochlidi',2,0,'','','P. Carpenter','0063f98c-5737-55e2-b079-8ad3b4aef74a','Petaloconchus cochlidium P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Petaloconchus','','cochlidium','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06353','','','Cancellaria coctilis Reeve, 1856',1,'Cancellaria coctilis','Cancellaria coctilis','Cancellaria coctil',2,0,'','','Reeve','d6b3c9cc-ffd0-5f7a-89a9-f969f0b3ade5','Cancellaria coctilis Reeve, 1856','Reeve, 1856','UNRANKED','','Cancellaria','','coctilis','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06356','','','Vertigo codia Bourguignat, 1864',1,'Vertigo codia','Vertigo codia','Vertigo cod',2,0,'','','Bourguignat','605ab117-5431-55a1-a68d-e45bf3eba349','Vertigo codia Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Vertigo','','codia','','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06360','','','Dentalium coelatulum Baily, in Salter, 1857',2,'Dentalium coelatulum','Dentalium coelatulum','Dentalium coelatul',2,0,'','','Baily|Salter','d60ea3b3-9759-5dce-9560-20b378bab465','Dentalium coelatulum Baily, in Salter, 1857','Baily, in Salter, 1857','UNRANKED','','Dentalium','','coelatulum','','','',NULL,'','','','','','Baily','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06364','','','Cyclostoma coeloconus Benson, 1851',1,'Cyclostoma coeloconus','Cyclostoma coeloconus','Cyclostoma coelocon',2,0,'','','Benson','f2988914-faf0-5a15-ba69-5f31db21004d','Cyclostoma coeloconus Benson, 1851','Benson, 1851','UNRANKED','','Cyclostoma','','coeloconus','','','',NULL,'','','','','','Benson','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06367','','','Cylindrella coerulans Poey, 1858',1,'Cylindrella coerulans','Cylindrella coerulans','Cylindrella coerulans',2,0,'','','Poey','1b801ddc-8c5a-5f77-94c3-685443addae0','Cylindrella coerulans Poey, 1858','Poey, 1858','UNRANKED','','Cylindrella','','coerulans','','','',NULL,'','','','','','Poey','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06372','','','Saxicava coeuvensis Mayer, 1864',1,'Saxicava coeuvensis','Saxicava coeuvensis','Saxicava coeuuens',2,0,'','','Mayer','15b86cc2-7ebb-5391-8103-70ad0cd92ce7','Saxicava coeuvensis Mayer, 1864','Mayer, 1864','UNRANKED','','Saxicava','','coeuvensis','','','',NULL,'','','','','','Mayer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06374','','','Patella coffea Reeve, 1855',1,'Patella coffea','Patella coffea','Patella coffe',2,0,'','','Reeve','f22c2f4b-3d9b-5f13-94c5-428096945a29','Patella coffea Reeve, 1855','Reeve, 1855','UNRANKED','','Patella','','coffea','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06379','','','Petricola cognata C.B. Adams, 1852',1,'Petricola cognata','Petricola cognata','Petricola cognat',2,0,'','','C. B. Adams','1f7ebfc4-0ec1-55a5-88af-f869206c5405','Petricola cognata C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Petricola','','cognata','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06384','','','Cerithium cognatum Zekeli, 1852',1,'Cerithium cognatum','Cerithium cognatum','Cerithium cognat',2,0,'','','Zekeli','85bd459b-7282-596d-a42c-de1773e4b62a','Cerithium cognatum Zekeli, 1852','Zekeli, 1852','UNRANKED','','Cerithium','','cognatum','','','',NULL,'','','','','','Zekeli','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06387','','','Unio cognatus Lea, 1860',1,'Unio cognatus','Unio cognatus','Unio cognat',2,0,'','','Lea','0c90bdbc-0562-56c6-8297-5b18da95bf2b','Unio cognatus Lea, 1860','Lea, 1860','UNRANKED','','Unio','','cognatus','','','',NULL,'','','','','','Lea','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06399','','','Nassa collaria C.B. Adams, 1852',1,'Nassa collaria','Nassa collaria','Nassa collar',2,0,'','','C. B. Adams','76f7df2c-1d40-5c8b-9c78-7640df4c8f3d','Nassa collaria C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Nassa','','collaria','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06400','','','Columbella collaris Reeve, 1859',1,'Columbella collaris','Columbella collaris','Columbella collar',2,0,'','','Reeve','fc4a4db4-f3f4-50c4-9a7f-16d2b5ea0537','Columbella collaris Reeve, 1859','Reeve, 1859','UNRANKED','','Columbella','','collaris','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06405','','','Arca collenoti J. Martin, 1863',1,'Arca collenoti','Arca collenoti','Arca collenot',2,0,'','','J. Martin','5d4cf475-ba57-59cd-8b5b-ee9fdfc7cf06','Arca collenoti J. Martin, 1863','J. Martin, 1863','UNRANKED','','Arca','','collenoti','','','',NULL,'','','','','','J. Martin','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06407','','','Cerithium collenoti J. Martin, 1863',1,'Cerithium collenoti','Cerithium collenoti','Cerithium collenot',2,0,'','','J. Martin','cad39a08-3308-5cd8-a18e-189fe306e86a','Cerithium collenoti J. Martin, 1863','J. Martin, 1863','UNRANKED','','Cerithium','','collenoti','','','',NULL,'','','','','','J. Martin','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06414','','','Crassatella collina Conrad, 1857',1,'Crassatella collina','Crassatella collina','Crassatella collin',2,0,'','','Conrad','27a7e131-3807-5aa8-8ca0-2fead4e1ca60','Crassatella collina Conrad, 1857','Conrad, 1857','UNRANKED','','Crassatella','','collina','','','',NULL,'','','','','','Conrad','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06418','','','Cardita collinea Buvignier, 1852',1,'Cardita collinea','Cardita collinea','Cardita colline',2,0,'','','Buvignier','2515ac9d-801e-5dc1-8165-caba608a3428','Cardita collinea Buvignier, 1852','Buvignier, 1852','UNRANKED','','Cardita','','collinea','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06422','','','Helix colliniana Bourguignat, 1863',1,'Helix colliniana','Helix colliniana','Helix collinian',2,0,'','','Bourguignat','a3e97742-3857-50c5-bfa6-8b860fe648ea','Helix colliniana Bourguignat, 1863','Bourguignat, 1863','UNRANKED','','Helix','','colliniana','','','',NULL,'','','','','','Bourguignat','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06426','','','Limnaea auricularia collisa A. Moquin-Tandon, 1855',1,'Limnaea auricularia collisa','Limnaea auricularia collisa','Limnaea auricular collis',3,0,'','','A. Moquin-Tandon','ac9fd123-a785-5b5d-aedb-e9ffdcb7de09','Limnaea auricularia collisa A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Limnaea','','auricularia','collisa','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06430','','','Helix collongeoni Michaud, 1855',1,'Helix collongeoni','Helix collongeoni','Helix collongeon',2,0,'','','Michaud','c103ac5b-7290-5480-af55-2fd5403d960d','Helix collongeoni Michaud, 1855','Michaud, 1855','UNRANKED','','Helix','','collongeoni','','','',NULL,'','','','','','Michaud','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06436','','','Unio coloradoensis Lea, 1856',1,'Unio coloradoensis','Unio coloradoensis','Unio coloradoens',2,0,'','','Lea','c9679d1b-619d-5030-b45e-e5e3ea0b98cc','Unio coloradoensis Lea, 1856','Lea, 1856','UNRANKED','','Unio','','coloradoensis','','','',NULL,'','','','','','Lea','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06441','','','Helix conspurcata coloratus Colbeau, 1859',1,'Helix conspurcata coloratus','Helix conspurcata coloratus','Helix conspurcat colorat',3,0,'','','Colbeau','e0c53718-2064-5553-99d8-189f9c2ce784','Helix conspurcata coloratus Colbeau, 1859','Colbeau, 1859','UNRANKED','','Helix','','conspurcata','coloratus','','',NULL,'','','','','','Colbeau','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06442','','','Limax arborum coloratus Broeck, 1870',1,'Limax arborum coloratus','Limax arborum coloratus','Limax arbor colorat',3,0,'','','Broeck','f004e8cf-50be-51fa-8d4f-79a4fc56c477','Limax arborum coloratus Broeck, 1870','Broeck, 1870','UNRANKED','','Limax','','arborum','coloratus','','',NULL,'','','','','','Broeck','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06446','','','Nerita colpostoma Schafhäutl, 1863',1,'Nerita colpostoma','Nerita colpostoma','Nerita colpostom',2,0,'','','Schafhäutl','58bb5d17-4554-5690-9038-c515f2a0ff13','Nerita colpostoma Schafhäutl, 1863','Schafhäutl, 1863','UNRANKED','','Nerita','','colpostoma','','','',NULL,'','','','','','Schafhäutl','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06449','','','Achatina colubrina Morelet, 1866',1,'Achatina colubrina','Achatina colubrina','Achatina colubrin',2,0,'','','Morelet','21ee0779-8742-557f-9713-a6938e808257','Achatina colubrina Morelet, 1866','Morelet, 1866','UNRANKED','','Achatina','','colubrina','','','',NULL,'','','','','','Morelet','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06456','','','Mitra columbellina A. Adams, 1851',1,'Mitra columbellina','Mitra columbellina','Mitra columbellin',2,0,'','','A. Adams','0c6cce7a-608b-53a8-9617-3247c40755e9','Mitra columbellina A. Adams, 1851','A. Adams, 1851','UNRANKED','','Mitra','','columbellina','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06462','','','Bulimus columbiensis Pfeiffer, 1854',1,'Bulimus columbiensis','Bulimus columbiensis','Bulimus columbiens',2,0,'','','Pfeiffer','748581d8-359a-50a2-850b-439a097e7ab6','Bulimus columbiensis Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Bulimus','','columbiensis','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06465','','','Bulla columellaris Menke, 1854',1,'Bulla columellaris','Bulla columellaris','Bulla columellar',2,0,'','','Menke','f423b82f-ad02-52f9-9a2b-1b2d2da60e52','Bulla columellaris Menke, 1854','Menke, 1854','UNRANKED','','Bulla','','columellaris','','','',NULL,'','','','','','Menke','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06469','','','Cerithiopsis columna P. Carpenter, 1864',1,'Cerithiopsis columna','Cerithiopsis columna','Cerithiopsis column',2,0,'','','P. Carpenter','4e2c0353-f772-5c49-b1db-502cebed1997','Cerithiopsis columna P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Cerithiopsis','','columna','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06475','','','Natica columnaris Recluz, 1850',1,'Natica columnaris','Natica columnaris','Natica columnar',2,0,'','','Recluz','26e2d1d8-e9a3-5f98-9ceb-bb726a2b9f11','Natica columnaris Recluz, 1850','Recluz, 1850','UNRANKED','','Natica','','columnaris','','','',NULL,'','','','','','Recluz','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06478','','','Achatina columnella Deshayes, 1863',1,'Achatina columnella','Achatina columnella','Achatina columnell',2,0,'','','Deshayes','6635b5d6-9710-5a5f-822e-ff81a862a853','Achatina columnella Deshayes, 1863','Deshayes, 1863','UNRANKED','','Achatina','','columnella','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06483','','','Cardium comatulum Bronn, 1860',1,'Cardium comatulum','Cardium comatulum','Cardium comatul',2,0,'','','Bronn','14d66b28-4df5-5b64-817e-5b2adfe6c326','Cardium comatulum Bronn, 1860','Bronn, 1860','UNRANKED','','Cardium','','comatulum','','','',NULL,'','','','','','Bronn','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06487','','','Bulimus comes Pfeiffer, 1861',1,'Bulimus comes','Bulimus comes','Bulimus com',2,0,'','','Pfeiffer','94419154-eecc-50ab-8467-49a2bf92fc12','Bulimus comes Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Bulimus','','comes','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06495','','','Helix (Fruticicola) commoda A. Adams, 1868',1,'Helix commoda','Helix commoda','Helix commod',2,0,'','','A. Adams','9c84d3fb-8be8-5d79-a745-4617e50be4b8','Helix (Fruticicola) commoda A. Adams, 1868','A. Adams, 1868','UNRANKED','','Helix','Fruticicola','commoda','','','',NULL,'','','','','','A. Adams','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06500','','','Conus commodus A. Adams, 1853',1,'Conus commodus','Conus commodus','Conus commod',2,0,'','','A. Adams','13c5886d-be37-5991-8c90-bb41f9076726','Conus commodus A. Adams, 1853','A. Adams, 1853','UNRANKED','','Conus','','commodus','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06506','','','Avicula communis Hall, 1859',1,'Avicula communis','Avicula communis','Avicula commun',2,0,'','','Hall','f82d0f4e-2d1e-5df5-928b-f19a6db680fc','Avicula communis Hall, 1859','Hall, 1859','UNRANKED','','Avicula','','communis','','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06510','','','Tritonium antiquum communis Middendorff, 1851',1,'Tritonium antiquum communis','Tritonium antiquum communis','Tritonium antiqu commun',3,0,'','','Middendorff','cd9e3c3b-6018-52b7-af06-52e7a863d328','Tritonium antiquum communis Middendorff, 1851','Middendorff, 1851','UNRANKED','','Tritonium','','antiquum','communis','','',NULL,'','','','','','Middendorff','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06517','','','Bivonia compacta P. Carpenter, 1864',1,'Bivonia compacta','Bivonia compacta','Bivonia compact',2,0,'','','P. Carpenter','6b7ed270-93f5-559f-b8d9-441818f46d1d','Bivonia compacta P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Bivonia','','compacta','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06524','','','Littorina compacta Gabb, 1864',1,'Littorina compacta','Littorina compacta','Littorina compact',2,0,'','','Gabb','a3784a14-924d-52ce-ab42-ff8f3c947cf6','Littorina compacta Gabb, 1864','Gabb, 1864','UNRANKED','','Littorina','','compacta','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06527','','','Melania compacta Anthony, 1854',1,'Melania compacta','Melania compacta','Melania compact',2,0,'','','Anthony','83e6b21a-e69e-58e8-aa61-d5e566d8f73e','Melania compacta Anthony, 1854','Anthony, 1854','UNRANKED','','Melania','','compacta','','','',NULL,'','','','','','Anthony','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06536','','','Unio compactus Lea, 1859',1,'Unio compactus','Unio compactus','Unio compact',2,0,'','','Lea','3630f71c-231b-5b5e-b24c-c39cfc1f3494','Unio compactus Lea, 1859','Lea, 1859','UNRANKED','','Unio','','compactus','','','',NULL,'','','','','','Lea','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06539','','','Clausilia comparata Parreyss, in A. Schmidt, 1868',2,'Clausilia comparata','Clausilia comparata','Clausilia comparat',2,0,'','','Parreyss|A. Schmidt','844cb8e9-0671-5fa6-882f-e48530012d31','Clausilia comparata Parreyss, in A. Schmidt, 1868','Parreyss, in A. Schmidt, 1868','UNRANKED','','Clausilia','','comparata','','','',NULL,'','','','','','Parreyss','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06548','','','Hyria complanata Hupe, 1857',1,'Hyria complanata','Hyria complanata','Hyria complanat',2,0,'','','Hupe','3625fdb0-5db4-5fbf-9ad9-8aa99dd12ac4','Hyria complanata Hupe, 1857','Hupe, 1857','UNRANKED','','Hyria','','complanata','','','',NULL,'','','','','','Hupe','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06555','','','Zonites cellarius complanata Jeffreys, 1862',1,'Zonites cellarius complanata','Zonites cellarius complanata','Zonites cellar complanat',3,0,'','','Jeffreys','89977f4f-8789-504d-86a4-7996eddc26f6','Zonites cellarius complanata Jeffreys, 1862','Jeffreys, 1862','UNRANKED','','Zonites','','cellarius','complanata','','',NULL,'','','','','','Jeffreys','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06557','','','Anisodonta complanatum Deshayes, 1857',1,'Anisodonta complanatum','Anisodonta complanatum','Anisodonta complanat',2,0,'','','Deshayes','de752b97-f294-523a-b917-261980d66917','Anisodonta complanatum Deshayes, 1857','Deshayes, 1857','UNRANKED','','Anisodonta','','complanatum','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06560','','','Cochlodesma complanatum Wood, 1856',1,'Cochlodesma complanatum','Cochlodesma complanatum','Cochlodesma complanat',2,0,'','','Wood','4ccd97cb-df5e-59cb-a20b-57b2f511e3b3','Cochlodesma complanatum Wood, 1856','Wood, 1856','UNRANKED','','Cochlodesma','','complanatum','','','',NULL,'','','','','','Wood','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06567','','','Ampullaria complicata Reeve, 1856',1,'Ampullaria complicata','Ampullaria complicata','Ampullaria complicat',2,0,'','','Reeve','486bb5d9-be00-5a1e-b742-5bd66433dffa','Ampullaria complicata Reeve, 1856','Reeve, 1856','UNRANKED','','Ampullaria','','complicata','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06571','','','Monodonta composita Lycett, 1863',1,'Monodonta composita','Monodonta composita','Monodonta composit',2,0,'','','Lycett','333014ca-413f-5eec-9429-ede244f763c1','Monodonta composita Lycett, 1863','Lycett, 1863','UNRANKED','','Monodonta','','composita','','','',NULL,'','','','','','Lycett','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06574','','','Ancylus lacustris compressa Jeffreys, 1862',1,'Ancylus lacustris compressa','Ancylus lacustris compressa','Ancylus lacustr compress',3,0,'','','Jeffreys','885b9b7e-4b31-5e1e-9612-7c2d461d7e1e','Ancylus lacustris compressa Jeffreys, 1862','Jeffreys, 1862','UNRANKED','','Ancylus','','lacustris','compressa','','',NULL,'','','','','','Jeffreys','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06577','','','Corbicula compressa Deshayes, 1854',1,'Corbicula compressa','Corbicula compressa','Corbicula compress',2,0,'','','Deshayes','a288219b-8266-5b15-9841-4a4f0b5dee42','Corbicula compressa Deshayes, 1854','Deshayes, 1854','UNRANKED','','Corbicula','','compressa','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06584','','','Glandina compressa Mousson, 1859',1,'Glandina compressa','Glandina compressa','Glandina compress',2,0,'','','Mousson','80408b0a-57bb-5f1e-be51-62b4e486b6f8','Glandina compressa Mousson, 1859','Mousson, 1859','UNRANKED','','Glandina','','compressa','','','',NULL,'','','','','','Mousson','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06585','','','Helix cunninghami compressa Mousson, 1869',1,'Helix cunninghami compressa','Helix cunninghami compressa','Helix cunningham compress',3,0,'','','Mousson','696d1c05-2459-59f6-b08e-7357a49d72bc','Helix cunninghami compressa Mousson, 1869','Mousson, 1869','UNRANKED','','Helix','','cunninghami','compressa','','',NULL,'','','','','','Mousson','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06589','','','Hettangia compressa Terquem, 1853',1,'Hettangia compressa','Hettangia compressa','Hettangia compress',2,0,'','','Terquem','53c52d30-4968-5570-8e31-b9a3bd281cea','Hettangia compressa Terquem, 1853','Terquem, 1853','UNRANKED','','Hettangia','','compressa','','','',NULL,'','','','','','Terquem','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06595','','','Melania compressa Brot, 1868',1,'Melania compressa','Melania compressa','Melania compress',2,0,'','','Brot','511690d6-ba2c-5b8a-9d15-46e0005c91b8','Melania compressa Brot, 1868','Brot, 1868','UNRANKED','','Melania','','compressa','','','',NULL,'','','','','','Brot','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06599','','','Patella pellucida compressa R. Lowe, 1861',1,'Patella pellucida compressa','Patella pellucida compressa','Patella pellucid compress',3,0,'','','R. Lowe','cb629371-1812-5483-a8c8-f0563382c993','Patella pellucida compressa R. Lowe, 1861','R. Lowe, 1861','UNRANKED','','Patella','','pellucida','compressa','','',NULL,'','','','','','R. Lowe','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06604','','','Tugonia compressa Reeve, 1863',1,'Tugonia compressa','Tugonia compressa','Tugonia compress',2,0,'','','Reeve','3f5706d4-d8d5-56f6-a2b6-a759c5e182a4','Tugonia compressa Reeve, 1863','Reeve, 1863','UNRANKED','','Tugonia','','compressa','','','',NULL,'','','','','','Reeve','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06609','','','Tellina compressissima G. Sowerby, 1869',1,'Tellina compressissima','Tellina compressissima','Tellina compressissim',2,0,'','','G. Sowerby','fbb9b7f5-dd95-5789-8d36-9cb8f26e6338','Tellina compressissima G. Sowerby, 1869','G. Sowerby, 1869','UNRANKED','','Tellina','','compressissima','','','',NULL,'','','','','','G. Sowerby','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06613','','','Helix compressivoluta Reeve, 1852',1,'Helix compressivoluta','Helix compressivoluta','Helix compressiuolut',2,0,'','','Reeve','8c1e8cd5-28a1-5fe1-93f3-cbbdff0a842b','Helix compressivoluta Reeve, 1852','Reeve, 1852','UNRANKED','','Helix','','compressivoluta','','','',NULL,'','','','','','Reeve','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06620','','','Bulimus compressus Pfeiffer, 1850',1,'Bulimus compressus','Bulimus compressus','Bulimus compress',2,0,'','','Pfeiffer','b5a94015-e8d9-52e1-8795-c5bd64a6706d','Bulimus compressus Pfeiffer, 1850','Pfeiffer, 1850','UNRANKED','','Bulimus','','compressus','','','',NULL,'','','','','','Pfeiffer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06622','','','Mytilus compressus Philippi, in Reeve, 1857',2,'Mytilus compressus','Mytilus compressus','Mytilus compress',2,0,'','','Philippi|Reeve','14839bbe-b4b5-5844-af62-732ab302efdc','Mytilus compressus Philippi, in Reeve, 1857','Philippi, in Reeve, 1857','UNRANKED','','Mytilus','','compressus','','','',NULL,'','','','','','Philippi','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06627','','','Astarte compsonema Conrad, 1866',1,'Astarte compsonema','Astarte compsonema','Astarte compsonem',2,0,'','','Conrad','39270f4b-35bc-5f09-b186-d998319871dc','Astarte compsonema Conrad, 1866','Conrad, 1866','UNRANKED','','Astarte','','compsonema','','','',NULL,'','','','','','Conrad','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06632','','','Cypraea compta Pease, 1860',1,'Cypraea compta','Cypraea compta','Cypraea compt',2,0,'','','Pease','c9c56158-778a-53f6-9970-53e1eef95c9d','Cypraea compta Pease, 1860','Pease, 1860','UNRANKED','','Cypraea','','compta','','','',NULL,'','','','','','Pease','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06633','','','Cyrena compta Deshayes, 1854',1,'Cyrena compta','Cyrena compta','Cyrena compt',2,0,'','','Deshayes','e86857e2-9147-5e99-a6d2-ada32360a9db','Cyrena compta Deshayes, 1854','Deshayes, 1854','UNRANKED','','Cyrena','','compta','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06638','','','Nassa (Alectrion) compta A. Adams, 1851',1,'Nassa compta','Nassa compta','Nassa compt',2,0,'','','A. Adams','f464c07d-4b61-533c-9735-6af43d990e64','Nassa (Alectrion) compta A. Adams, 1851','A. Adams, 1851','UNRANKED','','Nassa','Alectrion','compta','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06639','','','Partulina compta Pease, 1869',1,'Partulina compta','Partulina compta','Partulina compt',2,0,'','','Pease','4569ece1-65ac-5a0f-9f6a-4ff2ff71eea9','Partulina compta Pease, 1869','Pease, 1869','UNRANKED','','Partulina','','compta','','','',NULL,'','','','','','Pease','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06644','','','Tellina compta Gould, 1851',1,'Tellina compta','Tellina compta','Tellina compt',2,0,'','','Gould','3441525a-619e-50db-af0e-b8f65f9434a4','Tellina compta Gould, 1851','Gould, 1851','UNRANKED','','Tellina','','compta','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06645','','','Trigonia compta Lycett, 1863',1,'Trigonia compta','Trigonia compta','Trigonia compt',2,0,'','','Lycett','8446ff4c-fc9f-5ac0-b8af-9c4185bf0e14','Trigonia compta Lycett, 1863','Lycett, 1863','UNRANKED','','Trigonia','','compta','','','',NULL,'','','','','','Lycett','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06650','','','Cardium comptum Deshayes, 1853',1,'Cardium comptum','Cardium comptum','Cardium compt',2,0,'','','Deshayes','533a259b-6589-5aeb-9f1a-d13d0a7daa57','Cardium comptum Deshayes, 1853','Deshayes, 1853','UNRANKED','','Cardium','','comptum','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06652','','','Conus comptus A. Adams, 1853',1,'Conus comptus','Conus comptus','Conus compt',2,0,'','','A. Adams','0559b933-73e3-547d-b874-fb6b86fbc281','Conus comptus A. Adams, 1853','A. Adams, 1853','UNRANKED','','Conus','','comptus','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06660','','','Fissurella concatenata Crosse and Fischer, 1864',1,'Fissurella concatenata','Fissurella concatenata','Fissurella concatenat',2,0,'','','Crosse|Fischer','d4e7311a-4840-5104-b221-ff0b87aab968','Fissurella concatenata Crosse and Fischer, 1864','Crosse and Fischer, 1864','UNRANKED','','Fissurella','','concatenata','','','',NULL,'','','','','','Crosse & Fischer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06665','','','Nerinea concava Piette, 1855',1,'Nerinea concava','Nerinea concava','Nerinea concau',2,0,'','','Piette','f539aa68-d1b3-50a4-9d1d-5f38e48e7deb','Nerinea concava Piette, 1855','Piette, 1855','UNRANKED','','Nerinea','','concava','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06672','','','Euomphalus concavus Fried. Roemer, 1852',1,'Euomphalus concavus','Euomphalus concavus','Euomphalus concau',2,0,'','','Fried. Roemer','e0e7dc2c-81bb-54fd-ac09-ac2ffaba1db3','Euomphalus concavus Fried. Roemer, 1852','Fried. Roemer, 1852','UNRANKED','','Euomphalus','','concavus','','','',NULL,'','','','','','Fried. Roemer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06678','','','Anomia concentrica Meek, 1860',1,'Anomia concentrica','Anomia concentrica','Anomia concentric',2,0,'','','Meek','8fa6680c-7c33-581f-8756-468ce9c6410c','Anomia concentrica Meek, 1860','Meek, 1860','UNRANKED','','Anomia','','concentrica','','','',NULL,'','','','','','Meek','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06686','','','Cypricardinia concentrica Hall, 1859',1,'Cypricardinia concentrica','Cypricardinia concentrica','Cypricardinia concentric',2,0,'','','Hall','58255127-b58e-5b52-9331-08620271692c','Cypricardinia concentrica Hall, 1859','Hall, 1859','UNRANKED','','Cypricardinia','','concentrica','','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06691','','','Mesodesma concentrica Holmes, 1858',1,'Mesodesma concentrica','Mesodesma concentrica','Mesodesma concentric',2,0,'','','Holmes','e09bccf7-2844-5323-8c5a-f9f13297de14','Mesodesma concentrica Holmes, 1858','Holmes, 1858','UNRANKED','','Mesodesma','','concentrica','','','',NULL,'','','','','','Holmes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06693','','','Panopaea concentrica Gabb, 1864',1,'Panopaea concentrica','Panopaea concentrica','Panopaea concentric',2,0,'','','Gabb','4689644d-a9a7-57ec-b735-5593199c0d73','Panopaea concentrica Gabb, 1864','Gabb, 1864','UNRANKED','','Panopaea','','concentrica','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06698','','','Tellina concentrica Gould, 1851',1,'Tellina concentrica','Tellina concentrica','Tellina concentric',2,0,'','','Gould','77829878-9946-5f41-91c7-3ea75fe58d1c','Tellina concentrica Gould, 1851','Gould, 1851','UNRANKED','','Tellina','','concentrica','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06701','','','Lepton concentricum Gould, 1861',1,'Lepton concentricum','Lepton concentricum','Lepton concentric',2,0,'','','Gould','fb0598de-c408-5e92-80a0-812b110a9d00','Lepton concentricum Gould, 1861','Gould, 1861','UNRANKED','','Lepton','','concentricum','','','',NULL,'','','','','','Gould','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06704','','','Axinus concentricus C. Moore, 1861',1,'Axinus concentricus','Axinus concentricus','Axinus concentric',2,0,'','','C. Moore','4afbdfe4-509d-5bf6-b8c5-712f56d1bf56','Axinus concentricus C. Moore, 1861','C. Moore, 1861','UNRANKED','','Axinus','','concentricus','','','',NULL,'','','','','','C. Moore','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06710','','','Clausilia concilians Schmidt, in Bielz, 1853',2,'Clausilia concilians','Clausilia concilians','Clausilia concilians',2,0,'','','Schmidt|Bielz','689c9cd2-8f3c-5a93-8d7a-06e66f6532c1','Clausilia concilians Schmidt, in Bielz, 1853','Schmidt, in Bielz, 1853','UNRANKED','','Clausilia','','concilians','','','',NULL,'','','','','','Schmidt','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06715','','','Auricula concinna C.B. Adams, 1852',1,'Auricula concinna','Auricula concinna','Auricula concinn',2,0,'','','C. B. Adams','9e220fad-3210-5a51-bcae-5f875b79030c','Auricula concinna C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Auricula','','concinna','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06722','','','Clausilia concinna Küster, 1860',1,'Clausilia concinna','Clausilia concinna','Clausilia concinn',2,0,'','','Küster','b962d910-3604-57d2-95e6-99bf3bacf32e','Clausilia concinna Küster, 1860','Küster, 1860','UNRANKED','','Clausilia','','concinna','','','',NULL,'','','','','','Küster','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06727','','','Cyllene concinna Solander, in A. Adams, 1850',2,'Cyllene concinna','Cyllene concinna','Cyllene concinn',2,0,'','','Solander|A. Adams','0780a01f-851d-5472-b9e6-6860c489b5da','Cyllene concinna Solander, in A. Adams, 1850','Solander, in A. Adams, 1850','UNRANKED','','Cyllene','','concinna','','','',NULL,'','','','','','Solander','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06735','','','Lanistina concinna Dunker, 1856',1,'Lanistina concinna','Lanistina concinna','Lanistina concinn',2,0,'','','Dunker','248187d6-4fcc-5b3d-ba23-13c62fe2dd38','Lanistina concinna Dunker, 1856','Dunker, 1856','UNRANKED','','Lanistina','','concinna','','','',NULL,'','','','','','Dunker','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06740','','','Lucina concinna Deshayes, 1857',1,'Lucina concinna','Lucina concinna','Lucina concinn',2,0,'','','Deshayes','c315ea6b-c046-5034-bdeb-768475c0a094','Lucina concinna Deshayes, 1857','Deshayes, 1857','UNRANKED','','Lucina','','concinna','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06743','','','Mitra concinna Beyrich, 1854',1,'Mitra concinna','Mitra concinna','Mitra concinn',2,0,'','','Beyrich','41812e23-b9e9-5537-8c81-ee6a2853a0e6','Mitra concinna Beyrich, 1854','Beyrich, 1854','UNRANKED','','Mitra','','concinna','','','',NULL,'','','','','','Beyrich','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06746','','','Natica concinna Hall and Meek, 1855',1,'Natica concinna','Natica concinna','Natica concinn',2,0,'','','Hall|Meek','696d05b2-1cba-5945-9ddf-69b9063c7d98','Natica concinna Hall and Meek, 1855','Hall and Meek, 1855','UNRANKED','','Natica','','concinna','','','',NULL,'','','','','','Hall & Meek','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06757','','','Tellina concinna C.B. Adams, 1852',1,'Tellina concinna','Tellina concinna','Tellina concinn',2,0,'','','C. B. Adams','404bef27-b355-51c6-a6c4-c4095a2648c7','Tellina concinna C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Tellina','','concinna','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06763','','','Buccinum concinnum G. Sowerby, 1858',1,'Buccinum concinnum','Buccinum concinnum','Buccinum concinn',2,0,'','','G. Sowerby','33f05e48-6fea-50f0-ae48-06d20981e857','Buccinum concinnum G. Sowerby, 1858','G. Sowerby, 1858','UNRANKED','','Buccinum','','concinnum','','','',NULL,'','','','','','G. Sowerby','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06766','','','Trophon concinnum A. Adams, 1862',1,'Trophon concinnum','Trophon concinnum','Trophon concinn',2,0,'','','A. Adams','de56c53e-6111-5667-bfc7-d55e25296d38','Trophon concinnum A. Adams, 1862','A. Adams, 1862','UNRANKED','','Trophon','','concinnum','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06772','','','Helix desertorum concoidea Martens, 1865',1,'Helix desertorum concoidea','Helix desertorum concoidea','Helix desertor concoide',3,0,'','','Martens','48e561a4-f416-5666-9cdb-029becbe9d9a','Helix desertorum concoidea Martens, 1865','Martens, 1865','UNRANKED','','Helix','','desertorum','concoidea','','',NULL,'','','','','','Martens','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06776','','','Helix vermiculata concolor A. Moquin-Tandon, 1855',1,'Helix vermiculata concolor','Helix vermiculata concolor','Helix uermiculat concolor',3,0,'','','A. Moquin-Tandon','17ffcd66-dfbc-5fc4-8b60-71166a216995','Helix vermiculata concolor A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','vermiculata','concolor','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06778','','','Unio concolor Lea, 1861',1,'Unio concolor','Unio concolor','Unio concolor',2,0,'','','Lea','549a2171-1e99-55e9-8c9a-5575a128d6cd','Unio concolor Lea, 1861','Lea, 1861','UNRANKED','','Unio','','concolor','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06785','','','Turritella condensata Hebert and Eudes-Deslongchamps, 1860',1,'Turritella condensata','Turritella condensata','Turritella condensat',2,0,'','','Hebert|Eudes-Deslongchamps','e0582b25-a003-5c61-a1d9-e9cfe9650149','Turritella condensata Hebert and Eudes-Deslongchamps, 1860','Hebert and Eudes-Deslongchamps, 1860','UNRANKED','','Turritella','','condensata','','','',NULL,'','','','','','Hebert & Eudes-Deslongchamps','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06789','','','Pupa condita Gassies, 1869',1,'Pupa condita','Pupa condita','Pupa condit',2,0,'','','Gassies','edd57976-c8e8-5365-a095-5146e0261708','Pupa condita Gassies, 1869','Gassies, 1869','UNRANKED','','Pupa','','condita','','','',NULL,'','','','','','Gassies','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06794','','','Helix (Plectotropis) conella A. Adams, 1868',1,'Helix conella','Helix conella','Helix conell',2,0,'','','A. Adams','ff30f774-e9c6-5fa2-a90a-5c3af74085fe','Helix (Plectotropis) conella A. Adams, 1868','A. Adams, 1868','UNRANKED','','Helix','Plectotropis','conella','','','',NULL,'','','','','','A. Adams','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06798','','','Cyclostoma confertum Poey, 1852',1,'Cyclostoma confertum','Cyclostoma confertum','Cyclostoma confert',2,0,'','','Poey','b05f0b9b-cd93-5766-b4f3-314c30ed32ad','Cyclostoma confertum Poey, 1852','Poey, 1852','UNRANKED','','Cyclostoma','','confertum','','','',NULL,'','','','','','Poey','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06803','','','Pollia confluens Ryckholt, 1861',1,'Pollia confluens','Pollia confluens','Pollia confluens',2,0,'','','Ryckholt','05dc73ae-24d0-5fc6-aa1d-1f2354199453','Pollia confluens Ryckholt, 1861','Ryckholt, 1861','UNRANKED','','Pollia','','confluens','','','',NULL,'','','','','','Ryckholt','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06808','','','Venus conformis Deshayes, 1857',1,'Venus conformis','Venus conformis','Venus conform',2,0,'','','Deshayes','940e8a84-70c9-5b6d-8c69-17a2eb3c079c','Venus conformis Deshayes, 1857','Deshayes, 1857','UNRANKED','','Venus','','conformis','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06815','','','Helix confusa Benoit, 1857',1,'Helix confusa','Helix confusa','Helix confus',2,0,'','','Benoit','bd8d47af-b3ca-5e46-b836-14d4fa6564c7','Helix confusa Benoit, 1857','Benoit, 1857','UNRANKED','','Helix','','confusa','','','',NULL,'','','','','','Benoit','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06822','','','Dosinia conglobata E. Römer, 1861',1,'Dosinia conglobata','Dosinia conglobata','Dosinia conglobat',2,0,'','','E. Römer','12643dc5-af87-56d2-af53-b2ad98de8d61','Dosinia conglobata E. Römer, 1861','E. Römer, 1861','UNRANKED','','Dosinia','','conglobata','','','',NULL,'','','','','','E. Römer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06828','','','Ostrea coniacensis Coquand, 1859',1,'Ostrea coniacensis','Ostrea coniacensis','Ostrea coniacens',2,0,'','','Coquand','0d6c8cce-dd95-5e27-9b77-0ec9e3193dcf','Ostrea coniacensis Coquand, 1859','Coquand, 1859','UNRANKED','','Ostrea','','coniacensis','','','',NULL,'','','','','','Coquand','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06834','','','Alvania conica Schwartz, in Reuss, 1867',2,'Alvania conica','Alvania conica','Alvania conic',2,0,'','','Schwartz|Reuss','143e0eab-ea4e-5b41-9638-8234403fd40b','Alvania conica Schwartz, in Reuss, 1867','Schwartz, in Reuss, 1867','UNRANKED','','Alvania','','conica','','','',NULL,'','','','','','Schwartz','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06842','','','Helix pyramidata conica Bourguignat, 1864',1,'Helix pyramidata conica','Helix pyramidata conica','Helix pyramidat conic',3,0,'','','Bourguignat','d287a00a-936f-5e3f-90bf-8c2d2a0567af','Helix pyramidata conica Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','pyramidata','conica','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06844','','','Holopea conica Winchell, 1863',1,'Holopea conica','Holopea conica','Holopea conic',2,0,'','','Winchell','2b9ff55c-8249-5e9d-9540-ca9557104706','Holopea conica Winchell, 1863','Winchell, 1863','UNRANKED','','Holopea','','conica','','','',NULL,'','','','','','Winchell','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06849','','','Microdoma conica Meek and Worthen, 1866',1,'Microdoma conica','Microdoma conica','Microdoma conic',2,0,'','','Meek|Worthen','924e4e7f-99ec-58bc-ab6a-5882d4fb9d9b','Microdoma conica Meek and Worthen, 1866','Meek and Worthen, 1866','UNRANKED','','Microdoma','','conica','','','',NULL,'','','','','','Meek & Worthen','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06854','','','Phasianella conica Morris and Lycett, 1854',1,'Phasianella conica','Phasianella conica','Phasianella conic',2,0,'','','Morris|Lycett','94ac1b96-f77e-52ba-9578-7ac8e02d320b','Phasianella conica Morris and Lycett, 1854','Morris and Lycett, 1854','UNRANKED','','Phasianella','','conica','','','',NULL,'','','','','','Morris & Lycett','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06860','','','Rissoa scalata conica Schauroth, 1857',1,'Rissoa scalata conica','Rissoa scalata conica','Rissoa scalat conic',3,0,'','','Schauroth','3590a860-7585-5791-8c73-d955cc15d5be','Rissoa scalata conica Schauroth, 1857','Schauroth, 1857','UNRANKED','','Rissoa','','scalata','conica','','',NULL,'','','','','','Schauroth','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06863','','','Tornatellina conica Mousson, 1869',1,'Tornatellina conica','Tornatellina conica','Tornatellina conic',2,0,'','','Mousson','d785f54f-a747-5423-8884-1c5b87f84183','Tornatellina conica Mousson, 1869','Mousson, 1869','UNRANKED','','Tornatellina','','conica','','','',NULL,'','','','','','Mousson','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06872','','','Cremnoconchus conicus W. Blanford, 1870',1,'Cremnoconchus conicus','Cremnoconchus conicus','Cremnoconchus conic',2,0,'','','W. Blanford','eaf62f95-00d0-5ba6-b387-8cb26db815bd','Cremnoconchus conicus W. Blanford, 1870','W. Blanford, 1870','UNRANKED','','Cremnoconchus','','conicus','','','',NULL,'','','','','','W. Blanford','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06878','','','Pleurotoma conifera F. Edwards, 1860',1,'Pleurotoma conifera','Pleurotoma conifera','Pleurotoma conifer',2,0,'','','F. Edwards','cb961481-5993-5875-9c6e-5e1b1c0fbd32','Pleurotoma conifera F. Edwards, 1860','F. Edwards, 1860','UNRANKED','','Pleurotoma','','conifera','','','',NULL,'','','','','','F. Edwards','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06884','','','Meta coniformis Reeve, 1859',1,'Meta coniformis','Meta coniformis','Meta coniform',2,0,'','','Reeve','7d5751e3-4a94-57f3-8ecf-6498c4283a06','Meta coniformis Reeve, 1859','Reeve, 1859','UNRANKED','','Meta','','coniformis','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06886','','','Spiraxis coniformis Shuttleworth, 1852',1,'Spiraxis coniformis','Spiraxis coniformis','Spiraxis coniform',2,0,'','','Shuttleworth','35b93015-c437-5e1d-b3c1-34ccceb04b56','Spiraxis coniformis Shuttleworth, 1852','Shuttleworth, 1852','UNRANKED','','Spiraxis','','coniformis','','','',NULL,'','','','','','Shuttleworth','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06892','','','Bulimus conjunctus Parreyss, in Pfeiffer, 1853',2,'Bulimus conjunctus','Bulimus conjunctus','Bulimus coniunct',2,0,'','','Parreyss|Pfeiffer','355efdce-e25f-5397-9e24-5e60519f4714','Bulimus conjunctus Parreyss, in Pfeiffer, 1853','Parreyss, in Pfeiffer, 1853','UNRANKED','','Bulimus','','conjunctus','','','',NULL,'','','','','','Parreyss','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06898','','','Goniobasis connesaugaensis Lea, 1868',1,'Goniobasis connesaugaensis','Goniobasis connesaugaensis','Goniobasis connesaugaens',2,0,'','','Lea','0505d16d-d679-5d6b-9a72-442c9c71408d','Goniobasis connesaugaensis Lea, 1868','Lea, 1868','UNRANKED','','Goniobasis','','connesaugaensis','','','',NULL,'','','','','','Lea','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06903','','','Tectura conoidalis Pease, 1868',1,'Tectura conoidalis','Tectura conoidalis','Tectura conoidal',2,0,'','','Pease','d80c4a58-762b-5f8b-9878-0e46d07d3576','Tectura conoidalis Pease, 1868','Pease, 1868','UNRANKED','','Tectura','','conoidalis','','','',NULL,'','','','','','Pease','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06906','','','Bulla (Cylichna) conoidea Deshayes, 1862',1,'Bulla conoidea','Bulla conoidea','Bulla conoide',2,0,'','','Deshayes','d90a66eb-7ffe-5138-9cf9-6fcfad540e06','Bulla (Cylichna) conoidea Deshayes, 1862','Deshayes, 1862','UNRANKED','','Bulla','Cylichna','conoidea','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06909','','','Helix conoidea Cox, 1864',1,'Helix conoidea','Helix conoidea','Helix conoide',2,0,'','','Cox','83ad2874-3918-5379-948a-9cae64434648','Helix conoidea Cox, 1864','Cox, 1864','UNRANKED','','Helix','','conoidea','','','',NULL,'','','','','','Cox','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06918','','','Helix sordulenta conoidea Bourguignat, 1864',1,'Helix sordulenta conoidea','Helix sordulenta conoidea','Helix sordulent conoide',3,0,'','','Bourguignat','91e21322-174f-5298-b120-765dc2e5075f','Helix sordulenta conoidea Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','sordulenta','conoidea','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06924','','','Paludina conoidea Hislop, 1860',1,'Paludina conoidea','Paludina conoidea','Paludina conoide',2,0,'','','Hislop','10d5ae8a-7ba6-5d49-8130-f7baec4e7fb9','Paludina conoidea Hislop, 1860','Hislop, 1860','UNRANKED','','Paludina','','conoidea','','','',NULL,'','','','','','Hislop','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06928','','','Streptaxis conoidea Pfeiffer, 1854',1,'Streptaxis conoidea','Streptaxis conoidea','Streptaxis conoide',2,0,'','','Pfeiffer','87a72d83-28d7-5689-915f-6ad12d00bd3b','Streptaxis conoidea Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Streptaxis','','conoidea','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06937','','','Anomya conradi Orbigny, 1852',1,'Anomya conradi','Anomya conradi','Anomya conrad',2,0,'','','Orbigny','3e15fc53-5d5f-53a6-8953-8537212f3a50','Anomya conradi Orbigny, 1852','Orbigny, 1852','UNRANKED','','Anomya','','conradi','','','',NULL,'','','','','','Orbigny','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06939','','','Argonauta conradi Parkinson, 1856',1,'Argonauta conradi','Argonauta conradi','Argonauta conrad',2,0,'','','Parkinson','e4f08881-dca4-5597-81f2-1eff6f93b975','Argonauta conradi Parkinson, 1856','Parkinson, 1856','UNRANKED','','Argonauta','','conradi','','','',NULL,'','','','','','Parkinson','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06943','','','Cardita conradi Deshayes, 1858',1,'Cardita conradi','Cardita conradi','Cardita conrad',2,0,'','','Deshayes','881b4844-4249-54b4-bdb2-0b41551f3091','Cardita conradi Deshayes, 1858','Deshayes, 1858','UNRANKED','','Cardita','','conradi','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06947','','','Euomphalus conradi Hall, 1861',1,'Euomphalus conradi','Euomphalus conradi','Euomphalus conrad',2,0,'','','Hall','17a6c422-783d-5739-9f21-28c9815fb26c','Euomphalus conradi Hall, 1861','Hall, 1861','UNRANKED','','Euomphalus','','conradi','','','',NULL,'','','','','','Hall','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06954','','','Murchisonia conradi Hall, 1868',1,'Murchisonia conradi','Murchisonia conradi','Murchisonia conrad',2,0,'','','Hall','7301e796-7d0d-5cc4-990f-2ea97b667cee','Murchisonia conradi Hall, 1868','Hall, 1868','UNRANKED','','Murchisonia','','conradi','','','',NULL,'','','','','','Hall','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06958','','','Tellina (Peronaea) conradi Tryon, 1870',1,'Tellina conradi','Tellina conradi','Tellina conrad',2,0,'','','Tryon','97b17171-81dd-5fc5-a135-4dad7d47e7a3','Tellina (Peronaea) conradi Tryon, 1870','Tryon, 1870','UNRANKED','','Tellina','Peronaea','conradi','','','',NULL,'','','','','','Tryon','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06962','','','Lunatia (Gyrodes) conradiana Gabb, 1864',1,'Lunatia conradiana','Lunatia conradiana','Lunatia conradian',2,0,'','','Gabb','b176ff84-1fe3-5288-abd3-13bdbc674097','Lunatia (Gyrodes) conradiana Gabb, 1864','Gabb, 1864','UNRANKED','','Lunatia','Gyrodes','conradiana','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06964','','','Volvula conradiana Gabb, 1860',1,'Volvula conradiana','Volvula conradiana','Volvula conradian',2,0,'','','Gabb','31ee0513-c8aa-5d91-9016-feb765520b79','Volvula conradiana Gabb, 1860','Gabb, 1860','UNRANKED','','Volvula','','conradiana','','','',NULL,'','','','','','Gabb','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06971','','','Pisidium consanguineum Prime, 1865',1,'Pisidium consanguineum','Pisidium consanguineum','Pisidium consanguine',2,0,'','','Prime','3d76e879-4f0d-5865-b395-6f5e188cea31','Pisidium consanguineum Prime, 1865','Prime, 1865','UNRANKED','','Pisidium','','consanguineum','','','',NULL,'','','','','','Prime','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06974','','','Nassa consensa Ravenel, 1861',1,'Nassa consensa','Nassa consensa','Nassa consens',2,0,'','','Ravenel','c04329c1-cac5-5e0d-b8a7-de519fbf1d99','Nassa consensa Ravenel, 1861','Ravenel, 1861','UNRANKED','','Nassa','','consensa','','','',NULL,'','','','','','Ravenel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06982','','','Clausilia dacica consobrina A. Schmidt, 1868',1,'Clausilia dacica consobrina','Clausilia dacica consobrina','Clausilia dacic consobrin',3,0,'','','A. Schmidt','2d39c7ae-4351-50b4-b4af-85a690de5576','Clausilia dacica consobrina A. Schmidt, 1868','A. Schmidt, 1868','UNRANKED','','Clausilia','','dacica','consobrina','','',NULL,'','','','','','A. Schmidt','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06984','','','Cylichna consobrina Gould, 1859',1,'Cylichna consobrina','Cylichna consobrina','Cylichna consobrin',2,0,'','','Gould','d866ef4c-c997-56ee-8870-22ff299086b2','Cylichna consobrina Gould, 1859','Gould, 1859','UNRANKED','','Cylichna','','consobrina','','','',NULL,'','','','','','Gould','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06989','','','Natica consobrina Deshayes, 1864',1,'Natica consobrina','Natica consobrina','Natica consobrin',2,0,'','','Deshayes','c071ccd6-4561-5092-8c49-c616d7a514c7','Natica consobrina Deshayes, 1864','Deshayes, 1864','UNRANKED','','Natica','','consobrina','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_06995','','','Rissoella consobrina A. Adams, 1861',1,'Rissoella consobrina','Rissoella consobrina','Rissoella consobrin',2,0,'','','A. Adams','f43e85b9-d052-59d3-b1bb-3454e1c4f46f','Rissoella consobrina A. Adams, 1861','A. Adams, 1861','UNRANKED','','Rissoella','','consobrina','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07002','','','Cerithium consobrinus Deshayes, 1864',1,'Cerithium consobrinus','Cerithium consobrinus','Cerithium consobrin',2,0,'','','Deshayes','d51e5fbd-38e9-5656-8cb7-240b946d2989','Cerithium consobrinus Deshayes, 1864','Deshayes, 1864','UNRANKED','','Cerithium','','consobrinus','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07014','','','Scalaria consors Crosse and Fischer, 1864',1,'Scalaria consors','Scalaria consors','Scalaria consors',2,0,'','','Crosse|Fischer','8163ec0b-09d3-5d80-9e51-b2997a201958','Scalaria consors Crosse and Fischer, 1864','Crosse and Fischer, 1864','UNRANKED','','Scalaria','','consors','','','',NULL,'','','','','','Crosse & Fischer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07019','','','Chaetopleura conspersa H. Adams and Angas, 1864',1,'Chaetopleura conspersa','Chaetopleura conspersa','Chaetopleura conspers',2,0,'','','H. Adams|Angas','ef896cad-3bf3-570f-a100-0b9bacbf0322','Chaetopleura conspersa H. Adams and Angas, 1864','H. Adams and Angas, 1864','UNRANKED','','Chaetopleura','','conspersa','','','',NULL,'','','','','','H. Adams & Angas','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07028','','','Murex conspicuus Eichwald, 1868',1,'Murex conspicuus','Murex conspicuus','Murex conspicu',2,0,'','','Eichwald','5592e076-f4cb-50ff-b061-91e8a83e1577','Murex conspicuus Eichwald, 1868','Eichwald, 1868','UNRANKED','','Murex','','conspicuus','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07033','','','Leiostraca constantia A. Adams, 1861',1,'Leiostraca constantia','Leiostraca constantia','Leiostraca constant',2,0,'','','A. Adams','9df86fe2-bd7c-5d8f-a261-cc5394bc9412','Leiostraca constantia A. Adams, 1861','A. Adams, 1861','UNRANKED','','Leiostraca','','constantia','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07038','','','Chemnitzia constricta Folin, 1870',1,'Chemnitzia constricta','Chemnitzia constricta','Chemnitzia constrict',2,0,'','','Folin','527243a1-b8ca-5b77-bc2a-c989e97a63f6','Chemnitzia constricta Folin, 1870','Folin, 1870','UNRANKED','','Chemnitzia','','constricta','','','',NULL,'','','','','','Folin','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07045','','','Mactra constricta Wood, 1856',1,'Mactra constricta','Mactra constricta','Mactra constrict',2,0,'','','Wood','3766378e-3b47-502c-9379-280c283c723a','Mactra constricta Wood, 1856','Wood, 1856','UNRANKED','','Mactra','','constricta','','','',NULL,'','','','','','Wood','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07047','','','Patella constricta Eichwald, 1857',1,'Patella constricta','Patella constricta','Patella constrict',2,0,'','','Eichwald','c937a608-d11f-5bb1-879a-38660dc2e04f','Patella constricta Eichwald, 1857','Eichwald, 1857','UNRANKED','','Patella','','constricta','','','',NULL,'','','','','','Eichwald','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07055','','','Cerithium constrictum C. Moore, 1861',1,'Cerithium constrictum','Cerithium constrictum','Cerithium constrict',2,0,'','','C. Moore','43c61acc-e733-539c-a189-fc093a691187','Cerithium constrictum C. Moore, 1861','C. Moore, 1861','UNRANKED','','Cerithium','','constrictum','','','',NULL,'','','','','','C. Moore','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07061','','','Conus consul Boivin, 1864',1,'Conus consul','Conus consul','Conus consul',2,0,'','','Boivin','fbbdb466-2f6b-567b-a9e3-e366c2f01533','Conus consul Boivin, 1864','Boivin, 1864','UNRANKED','','Conus','','consul','','','',NULL,'','','','','','Boivin','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07062','','','Helix consul Pfeiffer, 1854',1,'Helix consul','Helix consul','Helix consul',2,0,'','','Pfeiffer','3d484440-a9bd-5693-81e5-49655606496b','Helix consul Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Helix','','consul','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07067','','','Nassa contabulata Speyer, 1862',1,'Nassa contabulata','Nassa contabulata','Nassa contabulat',2,0,'','','Speyer','6b8f980e-3682-5039-94df-86d2e44a10c2','Nassa contabulata Speyer, 1862','Speyer, 1862','UNRANKED','','Nassa','','contabulata','','','',NULL,'','','','','','Speyer','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07072','','','Cerithium contabulatum Deshayes, 1864',1,'Cerithium contabulatum','Cerithium contabulatum','Cerithium contabulat',2,0,'','','Deshayes','f7305084-5ba1-5a51-bf0b-3f0b1335508e','Cerithium contabulatum Deshayes, 1864','Deshayes, 1864','UNRANKED','','Cerithium','','contabulatum','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07077','','','Pholadomya contejeani Etallon, in Thurmann and Etallon, 1862',2,'Pholadomya contejeani','Pholadomya contejeani','Pholadomya conteiean',2,0,'','','Etallon|Thurmann','88831f9f-73dc-5a45-8bfd-fa1e2c43d8fe','Pholadomya contejeani Etallon, in Thurmann and Etallon, 1862','Etallon, in Thurmann and Etallon, 1862','UNRANKED','','Pholadomya','','contejeani','','','',NULL,'','','','','','Etallon','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07083','','','Voluta contigua Eichwald, 1868',1,'Voluta contigua','Voluta contigua','Voluta contigu',2,0,'','','Eichwald','3388ead8-9f4d-5ed4-b991-055242a38e57','Voluta contigua Eichwald, 1868','Eichwald, 1868','UNRANKED','','Voluta','','contigua','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07087','','','Helicina continua Gundlach, in Pfeiffer, 1858',2,'Helicina continua','Helicina continua','Helicina continu',2,0,'','','Gundlach|Pfeiffer','7a805570-c501-531c-898f-28bee443c2b3','Helicina continua Gundlach, in Pfeiffer, 1858','Gundlach, in Pfeiffer, 1858','UNRANKED','','Helicina','','continua','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07097','','','Rissoa contorta Jeffreys, 1856',1,'Rissoa contorta','Rissoa contorta','Rissoa contort',2,0,'','','Jeffreys','e9a50910-14cd-5e4f-9a17-280dec5a802f','Rissoa contorta Jeffreys, 1856','Jeffreys, 1856','UNRANKED','','Rissoa','','contorta','','','',NULL,'','','','','','Jeffreys','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07100','','','Teredo contorta Gabb, 1861',1,'Teredo contorta','Teredo contorta','Teredo contort',2,0,'','','Gabb','406aad40-7882-5264-bf52-e30545d50382','Teredo contorta Gabb, 1861','Gabb, 1861','UNRANKED','','Teredo','','contorta','','','',NULL,'','','','','','Gabb','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07104','','','Vermetus (Thylacodus) contortus contortula Mörch, 1861',1,'Vermetus contortus contortula','Vermetus contortus contortula','Vermetus contort contortul',3,0,'','','Mörch','074818b6-9bb2-5733-84c6-2c28edce4b02','Vermetus (Thylacodus) contortus contortula Mörch, 1861','Mörch, 1861','UNRANKED','','Vermetus','','contortus','contortula','','',NULL,'','','','','','Mörch','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07109','','','Galerus contortus P. Carpenter, 1864',1,'Galerus contortus','Galerus contortus','Galerus contort',2,0,'','','P. Carpenter','eff56117-ae1b-560e-937a-112a589a3373','Galerus contortus P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Galerus','','contortus','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07111','','','Achatinella contracta Gulick, 1858',1,'Achatinella contracta','Achatinella contracta','Achatinella contract',2,0,'','','Gulick','f01cd57a-f533-5a19-838a-fb66bc46cb7f','Achatinella contracta Gulick, 1858','Gulick, 1858','UNRANKED','','Achatinella','','contracta','','','',NULL,'','','','','','Gulick','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07116','','','Mactra contracta Conrad, 1868',1,'Mactra contracta','Mactra contracta','Mactra contract',2,0,'','','Conrad','0a6068e8-cc90-52cf-b0d1-4208fd61519a','Mactra contracta Conrad, 1868','Conrad, 1868','UNRANKED','','Mactra','','contracta','','','',NULL,'','','','','','Conrad','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07122','','','Cerithium contractum Bellardi, 1852',1,'Cerithium contractum','Cerithium contractum','Cerithium contract',2,0,'','','Bellardi','110a2de0-2a51-5657-9c14-a71915a623f1','Cerithium contractum Bellardi, 1852','Bellardi, 1852','UNRANKED','','Cerithium','','contractum','','','',NULL,'','','','','','Bellardi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07126','','','Turbo contractus Terquem and Piette, 1865',1,'Turbo contractus','Turbo contractus','Turbo contract',2,0,'','','Terquem|Piette','f0261d0f-895c-5ff6-be77-a4a2b34be47c','Turbo contractus Terquem and Piette, 1865','Terquem and Piette, 1865','UNRANKED','','Turbo','','contractus','','','',NULL,'','','','','','Terquem & Piette','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07133','','','Turritella contumescens Stoliczka, 1868',1,'Turritella contumescens','Turritella contumescens','Turritella contumescens',2,0,'','','Stoliczka','a0b9cac8-cddb-5162-b45d-27ccf8eba958','Turritella contumescens Stoliczka, 1868','Stoliczka, 1868','UNRANKED','','Turritella','','contumescens','','','',NULL,'','','','','','Stoliczka','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07137','','','Nanina (Kaliella) conula W. Blanford, 1865',1,'Nanina conula','Nanina conula','Nanina conul',2,0,'','','W. Blanford','7ad243b9-3094-57dd-b0a9-79c4f766a35a','Nanina (Kaliella) conula W. Blanford, 1865','W. Blanford, 1865','UNRANKED','','Nanina','Kaliella','conula','','','',NULL,'','','','','','W. Blanford','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07143','','','Acteonina conuloides Piette, 1855',1,'Acteonina conuloides','Acteonina conuloides','Acteonina conuloid',2,0,'','','Piette','e3219589-b0a8-53ff-931e-692effe4f2ac','Acteonina conuloides Piette, 1855','Piette, 1855','UNRANKED','','Acteonina','','conuloides','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07150','','','Orthostoma conulus Buvignier, 1852',1,'Orthostoma conulus','Orthostoma conulus','Orthostoma conul',2,0,'','','Buvignier','c43ef48b-cdcf-5313-bd71-ee2130453ad0','Orthostoma conulus Buvignier, 1852','Buvignier, 1852','UNRANKED','','Orthostoma','','conulus','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07157','','','Fusus conus Holmes, 1860',1,'Fusus conus','Fusus conus','Fusus con',2,0,'','','Holmes','cdafd944-94d7-5112-b794-65743e459eab','Fusus conus Holmes, 1860','Holmes, 1860','UNRANKED','','Fusus','','conus','','','',NULL,'','','','','','Holmes','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07160','','','Cerithiopsis convexa P. Carpenter, 1856',1,'Cerithiopsis convexa','Cerithiopsis convexa','Cerithiopsis conuex',2,0,'','','P. Carpenter','aa5ae24e-556e-5635-bf39-635d43d06de1','Cerithiopsis convexa P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Cerithiopsis','','convexa','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07166','','','Helix concinna convexa Mabille, 1866',1,'Helix concinna convexa','Helix concinna convexa','Helix concinn conuex',3,0,'','','Mabille','56d8e80e-d0ad-5c2a-8af3-9d6e012160a1','Helix concinna convexa Mabille, 1866','Mabille, 1866','UNRANKED','','Helix','','concinna','convexa','','',NULL,'','','','','','Mabille','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07172','','','Plicatula convexa Eichwald, 1865',1,'Plicatula convexa','Plicatula convexa','Plicatula conuex',2,0,'','','Eichwald','58185dad-06d1-54ae-a644-fad8ab036cd0','Plicatula convexa Eichwald, 1865','Eichwald, 1865','UNRANKED','','Plicatula','','convexa','','','',NULL,'','','','','','Eichwald','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07178','','','Turritella convexiuscula Zekeli, 1852',1,'Turritella convexiuscula','Turritella convexiuscula','Turritella conuexiuscul',2,0,'','','Zekeli','86ba9bad-ebf7-5785-a595-90bac0c5c80f','Turritella convexiuscula Zekeli, 1852','Zekeli, 1852','UNRANKED','','Turritella','','convexiuscula','','','',NULL,'','','','','','Zekeli','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07183','','','Bulimus convexus Pfeiffer, 1855',1,'Bulimus convexus','Bulimus convexus','Bulimus conuex',2,0,'','','Pfeiffer','8a271375-dc01-50d1-af3b-af67db2bdefa','Bulimus convexus Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Bulimus','','convexus','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07187','','','Inoceramus convexus Hall and Meek, 1855',1,'Inoceramus convexus','Inoceramus convexus','Inoceramus conuex',2,0,'','','Hall|Meek','5fe9460b-1f5b-576c-aaaa-5228cd7ebf1f','Inoceramus convexus Hall and Meek, 1855','Hall and Meek, 1855','UNRANKED','','Inoceramus','','convexus','','','',NULL,'','','','','','Hall & Meek','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07192','','','Planorbis convolutus Meek and Hayden, 1856',1,'Planorbis convolutus','Planorbis convolutus','Planorbis conuolut',2,0,'','','Meek|Hayden','d5fcc0cf-5486-5fbc-a3fb-a7dd317fc252','Planorbis convolutus Meek and Hayden, 1856','Meek and Hayden, 1856','UNRANKED','','Planorbis','','convolutus','','','',NULL,'','','','','','Meek & Hayden','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07200','','','Cyathopoma coonoorense W. Blanford, 1868',1,'Cyathopoma coonoorense','Cyathopoma coonoorense','Cyathopoma coonoorens',2,0,'','','W. Blanford','3c230805-f6c4-5147-b165-dba4bac60b5b','Cyathopoma coonoorense W. Blanford, 1868','W. Blanford, 1868','UNRANKED','','Cyathopoma','','coonoorense','','','',NULL,'','','','','','W. Blanford','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07203','','','Caecum cooperi P. Carpenter, 1864',1,'Caecum cooperi','Caecum cooperi','Caecum cooper',2,0,'','','P. Carpenter','fbc6dfc5-a931-5a49-9a96-5971276e6c98','Caecum cooperi P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Caecum','','cooperi','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07206','','','Cardium cooperii Gabb, 1864',1,'Cardium cooperii','Cardium cooperii','Cardium cooper',2,0,'','','Gabb','edc076d6-0ab8-58a8-967e-4c79d6ef16d4','Cardium cooperii Gabb, 1864','Gabb, 1864','UNRANKED','','Cardium','','cooperii','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07213','','','Panopaea cooperi Meek and Hayden, 1858',1,'Panopaea cooperi','Panopaea cooperi','Panopaea cooper',2,0,'','','Meek|Hayden','bfba29a5-ba77-59b6-9abe-83ffae36eff3','Panopaea cooperi Meek and Hayden, 1858','Meek and Hayden, 1858','UNRANKED','','Panopaea','','cooperi','','','',NULL,'','','','','','Meek & Hayden','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07220','','','Melania coosaensis Lea, 1861',1,'Melania coosaensis','Melania coosaensis','Melania coosaens',2,0,'','','Lea','4ad61455-e077-5f02-a717-03617dbcb488','Melania coosaensis Lea, 1861','Lea, 1861','UNRANKED','','Melania','','coosaensis','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07227','','','Anomia coquandi Zittel, 1866',1,'Anomia coquandi','Anomia coquandi','Anomia coquand',2,0,'','','Zittel','3c5c5ecb-7505-5547-90b6-85b125e4b48d','Anomia coquandi Zittel, 1866','Zittel, 1866','UNRANKED','','Anomia','','coquandi','','','',NULL,'','','','','','Zittel','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07230','','','Turbo coquandi Pictet and Campiche, 1863',1,'Turbo coquandi','Turbo coquandi','Turbo coquand',2,0,'','','Pictet|Campiche','9fcbaaee-9e3e-51d0-9686-13ff75a79aae','Turbo coquandi Pictet and Campiche, 1863','Pictet and Campiche, 1863','UNRANKED','','Turbo','','coquandi','','','',NULL,'','','','','','Pictet & Campiche','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07238','','','Melania coracina Anthony, in Gould, 1851',2,'Melania coracina','Melania coracina','Melania coracin',2,0,'','','Anthony|Gould','6d93c057-9a3f-5ff0-a60b-2def9c62b0cc','Melania coracina Anthony, in Gould, 1851','Anthony, in Gould, 1851','UNRANKED','','Melania','','coracina','','','',NULL,'','','','','','Anthony','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07246','','','Venerupis corallensis Buvignier, 1852',1,'Venerupis corallensis','Venerupis corallensis','Venerupis corallens',2,0,'','','Buvignier','8bc34654-cfec-5d83-b6e9-2597b68f706f','Venerupis corallensis Buvignier, 1852','Buvignier, 1852','UNRANKED','','Venerupis','','corallensis','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07251','','','Opis corallina Damon, 1860',1,'Opis corallina','Opis corallina','Opis corallin',2,0,'','','Damon','dadb2d96-ea0b-5a3a-be89-cfab93a7548e','Opis corallina Damon, 1860','Damon, 1860','UNRANKED','','Opis','','corallina','','','',NULL,'','','','','','Damon','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07253','','','Trochomorpha ludersi corallina Mousson, 1870',1,'Trochomorpha ludersi corallina','Trochomorpha ludersi corallina','Trochomorpha luders corallin',3,0,'','','Mousson','aaa90efb-1cdb-5421-8ff9-defe222aeede','Trochomorpha ludersi corallina Mousson, 1870','Mousson, 1870','UNRANKED','','Trochomorpha','','ludersi','corallina','','',NULL,'','','','','','Mousson','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07257','','','Thyreopsis coralliophila H. Adams, 1868',1,'Thyreopsis coralliophila','Thyreopsis coralliophila','Thyreopsis coralliophil',2,0,'','','H. Adams','2d03d508-ad17-5f1d-a19c-ff787c96adb6','Thyreopsis coralliophila H. Adams, 1868','H. Adams, 1868','UNRANKED','','Thyreopsis','','coralliophila','','','',NULL,'','','','','','H. Adams','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07261','','','Astarte corbicula Conrad, 1867',1,'Astarte corbicula','Astarte corbicula','Astarte corbicul',2,0,'','','Conrad','fd83eb16-468a-5e1c-9f73-3e8c2241f83d','Astarte corbicula Conrad, 1867','Conrad, 1867','UNRANKED','','Astarte','','corbicula','','','',NULL,'','','','','','Conrad','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07264','','','Cyrena corbiculaeformis Prime, 1860',1,'Cyrena corbiculaeformis','Cyrena corbiculaeformis','Cyrena corbiculaeform',2,0,'','','Prime','97b319ea-22d6-5c27-a2c5-b50119bf1c40','Cyrena corbiculaeformis Prime, 1860','Prime, 1860','UNRANKED','','Cyrena','','corbiculaeformis','','','',NULL,'','','','','','Prime','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07271','','','Arca corbisoides Loriol, in Loriol and Cotteau, 1867',2,'Arca corbisoides','Arca corbisoides','Arca corbisoid',2,0,'','','Loriol|Cotteau','86f8b9bf-def0-5bb5-a92e-454b99dafc15','Arca corbisoides Loriol, in Loriol and Cotteau, 1867','Loriol, in Loriol and Cotteau, 1867','UNRANKED','','Arca','','corbisoides','','','',NULL,'','','','','','Loriol','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07277','','','Mactra corbuloides Deshayes, 1854',1,'Mactra corbuloides','Mactra corbuloides','Mactra corbuloid',2,0,'','','Deshayes','4f12b833-c707-5102-af4b-b2409d10bbdf','Mactra corbuloides Deshayes, 1854','Deshayes, 1854','UNRANKED','','Mactra','','corbuloides','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07286','','','Arca cordata Deshayes, 1853',1,'Arca cordata','Arca cordata','Arca cordat',2,0,'','','Deshayes','195925be-71a1-5566-b56a-f1388d5250c3','Arca cordata Deshayes, 1853','Deshayes, 1853','UNRANKED','','Arca','','cordata','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07289','','','Cardinia cordata Swallow, in Swallow and Hawn, 1858',2,'Cardinia cordata','Cardinia cordata','Cardinia cordat',2,0,'','','Swallow|Hawn','3a1a5beb-c53a-5218-a094-f9f24014a5b7','Cardinia cordata Swallow, in Swallow and Hawn, 1858','Swallow, in Swallow and Hawn, 1858','UNRANKED','','Cardinia','','cordata','','','',NULL,'','','','','','Swallow','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07296','','','Pholadomya cordata Tate, 1865',1,'Pholadomya cordata','Pholadomya cordata','Pholadomya cordat',2,0,'','','Tate','a5c5a058-8b26-542b-8698-ceb2cad4c1e4','Pholadomya cordata Tate, 1865','Tate, 1865','UNRANKED','','Pholadomya','','cordata','','','',NULL,'','','','','','Tate','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07304','','','Mitra cordierii Maravigna, 1853',1,'Mitra cordierii','Mitra cordierii','Mitra cordier',2,0,'','','Maravigna','58a319f7-e794-5aae-8d25-d53f238b57d7','Mitra cordierii Maravigna, 1853','Maravigna, 1853','UNRANKED','','Mitra','','cordierii','','','',NULL,'','','','','','Maravigna','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07308','','','Cyrena cordiformis Recluz, 1853',1,'Cyrena cordiformis','Cyrena cordiformis','Cyrena cordiform',2,0,'','','Recluz','197ee88b-db63-53fc-a55a-b558eebc314d','Cyrena cordiformis Recluz, 1853','Recluz, 1853','UNRANKED','','Cyrena','','cordiformis','','','',NULL,'','','','','','Recluz','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07310','','','Megambonia cordiformis Hall, 1859',1,'Megambonia cordiformis','Megambonia cordiformis','Megambonia cordiform',2,0,'','','Hall','c980ab9f-cc21-5796-8647-da0e37fe3b75','Megambonia cordiformis Hall, 1859','Hall, 1859','UNRANKED','','Megambonia','','cordiformis','','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07316','','','Mytilus cordolianus Ryckholt, 1852',1,'Mytilus cordolianus','Mytilus cordolianus','Mytilus cordolian',2,0,'','','Ryckholt','770767c6-2568-537c-873d-6584cf63e8fc','Mytilus cordolianus Ryckholt, 1852','Ryckholt, 1852','UNRANKED','','Mytilus','','cordolianus','','','',NULL,'','','','','','Ryckholt','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07323','','','Murex coreanicus A. Adams, 1853',1,'Murex coreanicus','Murex coreanicus','Murex coreanic',2,0,'','','A. Adams','a26dbef7-66d6-5285-b1a8-13a36a4f30c5','Murex coreanicus A. Adams, 1853','A. Adams, 1853','UNRANKED','','Murex','','coreanicus','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07327','','','Bulimus coriaceus Pfeiffer, 1856',1,'Bulimus coriaceus','Bulimus coriaceus','Bulimus coriace',2,0,'','','Pfeiffer','80e21fe7-ffe7-5885-8436-6d3488aa675d','Bulimus coriaceus Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Bulimus','','coriaceus','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07332','','','Bulimus decollatus cornea Bourguignat, 1864',1,'Bulimus decollatus cornea','Bulimus decollatus cornea','Bulimus decollat corne',3,0,'','','Bourguignat','2b01d504-7a24-578a-8277-af0cbb5561a8','Bulimus decollatus cornea Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Bulimus','','decollatus','cornea','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07337','','','Crenella cornea A. Adams, 1862',1,'Crenella cornea','Crenella cornea','Crenella corne',2,0,'','','A. Adams','76c74b11-f657-591d-8f59-38658b2d31ac','Crenella cornea A. Adams, 1862','A. Adams, 1862','UNRANKED','','Crenella','','cornea','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07340','','','Helix sericea cornea Jeffreys, 1862',1,'Helix sericea cornea','Helix sericea cornea','Helix serice corne',3,0,'','','Jeffreys','1b85bf05-114b-5cf5-8810-97b115b55585','Helix sericea cornea Jeffreys, 1862','Jeffreys, 1862','UNRANKED','','Helix','','sericea','cornea','','',NULL,'','','','','','Jeffreys','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07343','','','Mactra cornea Deshayes, 1853',1,'Mactra cornea','Mactra cornea','Mactra corne',2,0,'','','Deshayes','ed35cc90-1902-5e55-8520-e9b78f6d6ee9','Mactra cornea Deshayes, 1853','Deshayes, 1853','UNRANKED','','Mactra','','cornea','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07346','','','Streptostyla cornea Crosse and Fischer, 1869',1,'Streptostyla cornea','Streptostyla cornea','Streptostyla corne',2,0,'','','Crosse|Fischer','1185075c-a489-5393-9457-5c0c985f1563','Streptostyla cornea Crosse and Fischer, 1869','Crosse and Fischer, 1869','UNRANKED','','Streptostyla','','cornea','','','',NULL,'','','','','','Crosse & Fischer','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07353','','','Melania corneola Anthony, 1860',1,'Melania corneola','Melania corneola','Melania corneol',2,0,'','','Anthony','5a600ab9-7d58-585d-b957-460a58994dd1','Melania corneola Anthony, 1860','Anthony, 1860','UNRANKED','','Melania','','corneola','','','',NULL,'','','','','','Anthony','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07359','','','Adeorbis corniculum A. Adams, 1861',1,'Adeorbis corniculum','Adeorbis corniculum','Adeorbis cornicul',2,0,'','','A. Adams','556356cd-b386-547c-8ef5-8abe6b469f42','Adeorbis corniculum A. Adams, 1861','A. Adams, 1861','UNRANKED','','Adeorbis','','corniculum','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07366','','','Meioceras cornubovis P. Carpenter, 1858',1,'Meioceras cornubovis','Meioceras cornubovis','Meioceras cornubou',2,0,'','','P. Carpenter','0f93444d-75ab-58dc-ae86-04f83ae3eb95','Meioceras cornubovis P. Carpenter, 1858','P. Carpenter, 1858','UNRANKED','','Meioceras','','cornubovis','','','',NULL,'','','','','','P. Carpenter','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07369','','','Planorbis cornucopia Baily, 1858',1,'Planorbis cornucopia','Planorbis cornucopia','Planorbis cornucop',2,0,'','','Baily','6f9d6c31-4adb-5d35-9242-b30fcdf372ce','Planorbis cornucopia Baily, 1858','Baily, 1858','UNRANKED','','Planorbis','','cornucopia','','','',NULL,'','','','','','Baily','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07372','','','Meioceras cornucopiae P. Carpenter, 1858',1,'Meioceras cornucopiae','Meioceras cornucopiae','Meioceras cornucopi',2,0,'','','P. Carpenter','5d8d4f0c-7f21-567d-9071-244c6f8ae4cd','Meioceras cornucopiae P. Carpenter, 1858','P. Carpenter, 1858','UNRANKED','','Meioceras','','cornucopiae','','','',NULL,'','','','','','P. Carpenter','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07378','','','Tubiola cornuella A. Adams, 1863',1,'Tubiola cornuella','Tubiola cornuella','Tubiola cornuell',2,0,'','','A. Adams','9613933a-7ce4-5a68-8087-8fc93e910931','Tubiola cornuella A. Adams, 1863','A. Adams, 1863','UNRANKED','','Tubiola','','cornuella','','','',NULL,'','','','','','A. Adams','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07383','','','Argonauta cornuta Conrad, 1854',1,'Argonauta cornuta','Argonauta cornuta','Argonauta cornut',2,0,'','','Conrad','4fbf1974-b1ba-5e2e-97c0-7c3443bb96dd','Argonauta cornuta Conrad, 1854','Conrad, 1854','UNRANKED','','Argonauta','','cornuta','','','',NULL,'','','','','','Conrad','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07386','','','Pandora cornuta C.B. Adams, 1852',1,'Pandora cornuta','Pandora cornuta','Pandora cornut',2,0,'','','C. B. Adams','75032b84-b769-5c9e-9cb8-44b22dfc8e65','Pandora cornuta C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Pandora','','cornuta','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07392','','','Trochus corolla Reeve, 1861',1,'Trochus corolla','Trochus corolla','Trochus coroll',2,0,'','','Reeve','72e32ada-b02b-54d2-9ac9-2a8f0b5fd4ce','Trochus corolla Reeve, 1861','Reeve, 1861','UNRANKED','','Trochus','','corolla','','','',NULL,'','','','','','Reeve','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07399','','','Helix coronadoi Hidalgo, 1868',1,'Helix coronadoi','Helix coronadoi','Helix coronado',2,0,'','','Hidalgo','37d246d3-c796-5d31-85fb-dd0b257fedbe','Helix coronadoi Hidalgo, 1868','Hidalgo, 1868','UNRANKED','','Helix','','coronadoi','','','',NULL,'','','','','','Hidalgo','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07401','','','Scalaria coronalis Deshayes, 1861',1,'Scalaria coronalis','Scalaria coronalis','Scalaria coronal',2,0,'','','Deshayes','abef8e2d-2d40-5637-a93b-5664d1599242','Scalaria coronalis Deshayes, 1861','Deshayes, 1861','UNRANKED','','Scalaria','','coronalis','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07405','','','Coralliophila coronata Barclay, in H. Adams, 1869',2,'Coralliophila coronata','Coralliophila coronata','Coralliophila coronat',2,0,'','','Barclay|H. Adams','0f9f1327-2a51-5e16-a336-f61a7c20f45a','Coralliophila coronata Barclay, in H. Adams, 1869','Barclay, in H. Adams, 1869','UNRANKED','','Coralliophila','','coronata','','','',NULL,'','','','','','Barclay','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07410','','','Littorina coronata Terquem and Piette, 1865',1,'Littorina coronata','Littorina coronata','Littorina coronat',2,0,'','','Terquem|Piette','a7f7c0e6-1700-5199-a306-a398248fda78','Littorina coronata Terquem and Piette, 1865','Terquem and Piette, 1865','UNRANKED','','Littorina','','coronata','','','',NULL,'','','','','','Terquem & Piette','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07415','','','Stenogyra coronata Guppy, 1868',1,'Stenogyra coronata','Stenogyra coronata','Stenogyra coronat',2,0,'','','Guppy','32ba1f51-dfc7-5f83-a134-dcc634ad6983','Stenogyra coronata Guppy, 1868','Guppy, 1868','UNRANKED','','Stenogyra','','coronata','','','',NULL,'','','','','','Guppy','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07419','','','Cerithium coronatum C. Moore, 1866',1,'Cerithium coronatum','Cerithium coronatum','Cerithium coronat',2,0,'','','C. Moore','0bc66789-e862-5e84-b200-8509d748e36e','Cerithium coronatum C. Moore, 1866','C. Moore, 1866','UNRANKED','','Cerithium','','coronatum','','','',NULL,'','','','','','C. Moore','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07423','','','Fusus coronatus Morris and Lycett, 1854',1,'Fusus coronatus','Fusus coronatus','Fusus coronat',2,0,'','','Morris|Lycett','70c7f4f2-0392-5fa2-939d-85d10ea181e2','Fusus coronatus Morris and Lycett, 1854','Morris and Lycett, 1854','UNRANKED','','Fusus','','coronatus','','','',NULL,'','','','','','Morris & Lycett','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07430','','','Helicina coronula Shuttleworth, in Pfeiffer, 1862',2,'Helicina coronula','Helicina coronula','Helicina coronul',2,0,'','','Shuttleworth|Pfeiffer','53ec9308-182f-5fc5-aa71-a9aedef0ea9f','Helicina coronula Shuttleworth, in Pfeiffer, 1862','Shuttleworth, in Pfeiffer, 1862','UNRANKED','','Helicina','','coronula','','','',NULL,'','','','','','Shuttleworth','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07433','','','Trochus coronulatus C.B. Adams, 1852',1,'Trochus coronulatus','Trochus coronulatus','Trochus coronulat',2,0,'','','C. B. Adams','1726c412-9504-5194-8fa0-e4e31c752b3a','Trochus coronulatus C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Trochus','','coronulatus','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07439','','','Nassa corpulenta C.B. Adams, 1852',1,'Nassa corpulenta','Nassa corpulenta','Nassa corpulent',2,0,'','','C. B. Adams','a0ea0270-2898-5cb3-a6c5-c45c28fed966','Nassa corpulenta C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Nassa','','corpulenta','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07444','','','Bulimus correctus Pfeiffer, 1852',1,'Bulimus correctus','Bulimus correctus','Bulimus correct',2,0,'','','Pfeiffer','d9b81047-73d6-5690-bcd4-b49bd13e0eaa','Bulimus correctus Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Bulimus','','correctus','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07450','','','Labio corrosa A. Adams, 1851',1,'Labio corrosa','Labio corrosa','Labio corros',2,0,'','','A. Adams','08fe50fd-e793-57af-afc8-bc5d134c7efc','Labio corrosa A. Adams, 1851','A. Adams, 1851','UNRANKED','','Labio','','corrosa','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07456','','','Doris corrugata Kelaart, 1859',1,'Doris corrugata','Doris corrugata','Doris corrugat',2,0,'','','Kelaart','77fdf52b-9f50-5d49-a37a-6077cc75ccf4','Doris corrugata Kelaart, 1859','Kelaart, 1859','UNRANKED','','Doris','','corrugata','','','',NULL,'','','','','','Kelaart','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07462','','','Patella corrugata Reeve, 1855',1,'Patella corrugata','Patella corrugata','Patella corrugat',2,0,'','','Reeve','eec71d91-2c89-57f3-b828-bd4b163707cf','Patella corrugata Reeve, 1855','Reeve, 1855','UNRANKED','','Patella','','corrugata','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07467','','','Trivia corrugata Pease, 1868',1,'Trivia corrugata','Trivia corrugata','Trivia corrugat',2,0,'','','Pease','24939eaa-986e-531f-851e-fd1e253a0907','Trivia corrugata Pease, 1868','Pease, 1868','UNRANKED','','Trivia','','corrugata','','','',NULL,'','','','','','Pease','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07472','','','Cardium corrugatum Sharpe, 1850',1,'Cardium corrugatum','Cardium corrugatum','Cardium corrugat',2,0,'','','Sharpe','023d9475-1c3c-500e-b7a9-0fd61762780d','Cardium corrugatum Sharpe, 1850','Sharpe, 1850','UNRANKED','','Cardium','','corrugatum','','','',NULL,'','','','','','Sharpe','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07475','','','Dentalium corrugatum P. Carpenter, 1856',1,'Dentalium corrugatum','Dentalium corrugatum','Dentalium corrugat',2,0,'','','P. Carpenter','f67668fc-7c90-5279-ad41-904673059541','Dentalium corrugatum P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Dentalium','','corrugatum','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07479','','','Sanguinolites corrugatus Sharpe, 1856',1,'Sanguinolites corrugatus','Sanguinolites corrugatus','Sanguinolites corrugat',2,0,'','','Sharpe','1502bf69-789b-599c-8b78-9c44517fd77d','Sanguinolites corrugatus Sharpe, 1856','Sharpe, 1856','UNRANKED','','Sanguinolites','','corrugatus','','','',NULL,'','','','','','Sharpe','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07482','','','Caecum corrugulatum P. Carpenter, 1856',1,'Caecum corrugulatum','Caecum corrugulatum','Caecum corrugulat',2,0,'','','P. Carpenter','37233916-34a3-59c7-8652-a52d517a2337','Caecum corrugulatum P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Caecum','','corrugulatum','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07486','','','Ostrea cortex Conrad, 1857',1,'Ostrea cortex','Ostrea cortex','Ostrea cortex',2,0,'','','Conrad','6ea3f1e8-4352-51fc-9d66-69adefd15507','Ostrea cortex Conrad, 1857','Conrad, 1857','UNRANKED','','Ostrea','','cortex','','','',NULL,'','','','','','Conrad','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07492','','','Unio coruscus Gould, 1856',1,'Unio coruscus','Unio coruscus','Unio corusc',2,0,'','','Gould','308165c4-69bb-54a5-9db1-7db5c000e7f3','Unio coruscus Gould, 1856','Gould, 1856','UNRANKED','','Unio','','coruscus','','','',NULL,'','','','','','Gould','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07494','','','Unio corvinus Leu, 1868',1,'Unio corvinus','Unio corvinus','Unio coruin',2,0,'','','Leu','4e900244-388e-585c-a20d-b71c623f7ced','Unio corvinus Leu, 1868','Leu, 1868','UNRANKED','','Unio','','corvinus','','','',NULL,'','','','','','Leu','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07499','','','Dosinia coryne A. Adams, 1855',1,'Dosinia coryne','Dosinia coryne','Dosinia coryn',2,0,'','','A. Adams','53c16cff-2318-534d-9045-de159ccd1af6','Dosinia coryne A. Adams, 1855','A. Adams, 1855','UNRANKED','','Dosinia','','coryne','','','',NULL,'','','','','','A. Adams','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07503','','','Emarginula costae Tiberi, 1855',1,'Emarginula costae','Emarginula costae','Emarginula cost',2,0,'','','Tiberi','b8c424f4-94e5-58f2-9eb8-542a7b4191e7','Emarginula costae Tiberi, 1855','Tiberi, 1855','UNRANKED','','Emarginula','','costae','','','',NULL,'','','','','','Tiberi','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07506','','','Rostellaria costae Sharpe, 1850',1,'Rostellaria costae','Rostellaria costae','Rostellaria cost',2,0,'','','Sharpe','b2de1b0c-5671-5f2d-b10f-eaa387b907f7','Rostellaria costae Sharpe, 1850','Sharpe, 1850','UNRANKED','','Rostellaria','','costae','','','',NULL,'','','','','','Sharpe','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07511','','','Adeorbis costata Garrett, 1857',1,'Adeorbis costata','Adeorbis costata','Adeorbis costat',2,0,'','','Garrett','b17aa8b1-14f5-5da7-a77e-da5c048b63dd','Adeorbis costata Garrett, 1857','Garrett, 1857','UNRANKED','','Adeorbis','','costata','','','',NULL,'','','','','','Garrett','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07520','','','Helix costata Dupuy, 1850',1,'Helix costata','Helix costata','Helix costat',2,0,'','','Dupuy','3bb1e630-6c50-5c05-9daf-b8deb11f4e71','Helix costata Dupuy, 1850','Dupuy, 1850','UNRANKED','','Helix','','costata','','','',NULL,'','','','','','Dupuy','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07524','','','Melania muricata costata Morris, 1856',1,'Melania muricata costata','Melania muricata costata','Melania muricat costat',3,0,'','','Morris','db826d9d-fd29-5b15-96d6-a21ee0a00d29','Melania muricata costata Morris, 1856','Morris, 1856','UNRANKED','','Melania','','muricata','costata','','',NULL,'','','','','','Morris','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07527','','','Natica costata Berger, 1860',1,'Natica costata','Natica costata','Natica costat',2,0,'','','Berger','e6a076ae-9579-5052-9b94-1f8ae76e0544','Natica costata Berger, 1860','Berger, 1860','UNRANKED','','Natica','','costata','','','',NULL,'','','','','','Berger','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07531','','','Rissoa costata J. Muller, 1851',1,'Rissoa costata','Rissoa costata','Rissoa costat',2,0,'','','J. Muller','a0f8881e-39a8-5962-831c-491d7632e312','Rissoa costata J. Muller, 1851','J. Muller, 1851','UNRANKED','','Rissoa','','costata','','','',NULL,'','','','','','J. Muller','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07535','','','Vermetus (Thylacodus) varians costata Mörch, 1861',1,'Vermetus varians costata','Vermetus varians costata','Vermetus uarians costat',3,0,'','','Mörch','75e41db4-c224-57ea-8b68-88c7e8dab463','Vermetus (Thylacodus) varians costata Mörch, 1861','Mörch, 1861','UNRANKED','','Vermetus','','varians','costata','','',NULL,'','','','','','Mörch','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07537','','','Pleurophorus costatiformis Meek and Worthen, 1865',1,'Pleurophorus costatiformis','Pleurophorus costatiformis','Pleurophorus costatiform',2,0,'','','Meek|Worthen','5db9a978-074a-53af-a099-7f889a34c672','Pleurophorus costatiformis Meek and Worthen, 1865','Meek and Worthen, 1865','UNRANKED','','Pleurophorus','','costatiformis','','','',NULL,'','','','','','Meek & Worthen','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07544','','','Carychium costatum Freyer, 1855',1,'Carychium costatum','Carychium costatum','Carychium costat',2,0,'','','Freyer','469bcbba-2cf5-5145-8f85-70a5b4884716','Carychium costatum Freyer, 1855','Freyer, 1855','UNRANKED','','Carychium','','costatum','','','',NULL,'','','','','','Freyer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07549','','','Trochus costatus Piette, 1856',1,'Trochus costatus','Trochus costatus','Trochus costat',2,0,'','','Piette','6286fa1b-af3c-515a-a677-a17586db1f6e','Trochus costatus Piette, 1856','Piette, 1856','UNRANKED','','Trochus','','costatus','','','',NULL,'','','','','','Piette','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07552','','','Macroceramus costellaris Gundlach, in Pfeiffer, 1864',2,'Macroceramus costellaris','Macroceramus costellaris','Macroceramus costellar',2,0,'','','Gundlach|Pfeiffer','2ebb017b-f09c-5984-a65b-b3740d738bf1','Macroceramus costellaris Gundlach, in Pfeiffer, 1864','Gundlach, in Pfeiffer, 1864','UNRANKED','','Macroceramus','','costellaris','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07557','','','Limnaea costellata F. Edwards, 1852',1,'Limnaea costellata','Limnaea costellata','Limnaea costellat',2,0,'','','F. Edwards','9aa8d259-2912-557f-a574-6b11812b377a','Limnaea costellata F. Edwards, 1852','F. Edwards, 1852','UNRANKED','','Limnaea','','costellata','','','',NULL,'','','','','','F. Edwards','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07562','','','Pholas costellata Morris and Lycett, 1853',1,'Pholas costellata','Pholas costellata','Pholas costellat',2,0,'','','Morris|Lycett','83876c68-2d14-5ee0-8357-fb4283e3f854','Pholas costellata Morris and Lycett, 1853','Morris and Lycett, 1853','UNRANKED','','Pholas','','costellata','','','',NULL,'','','','','','Morris & Lycett','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07571','','','Turbo costellifer Baudon, 1853',1,'Turbo costellifer','Turbo costellifer','Turbo costellifer',2,0,'','','Baudon','359a2ec2-eb43-534a-9173-86101846534b','Turbo costellifer Baudon, 1853','Baudon, 1853','UNRANKED','','Turbo','','costellifer','','','',NULL,'','','','','','Baudon','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07576','','','Melania costifera Haldeman, in Reeve, 1861',2,'Melania costifera','Melania costifera','Melania costifer',2,0,'','','Haldeman|Reeve','876b15f8-1ca0-5a25-87ef-02e6e331c7b4','Melania costifera Haldeman, in Reeve, 1861','Haldeman, in Reeve, 1861','UNRANKED','','Melania','','costifera','','','',NULL,'','','','','','Haldeman','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07581','','','Cerithium costiferum A. Adams, in G. Sowerby, 1855',2,'Cerithium costiferum','Cerithium costiferum','Cerithium costifer',2,0,'','','A. Adams|G. Sowerby','593147ae-82f2-580d-b19c-f4df275d8133','Cerithium costiferum A. Adams, in G. Sowerby, 1855','A. Adams, in G. Sowerby, 1855','UNRANKED','','Cerithium','','costiferum','','','',NULL,'','','','','','A. Adams','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07587','','','Caprotina costulata J. Müller, 1859',1,'Caprotina costulata','Caprotina costulata','Caprotina costulat',2,0,'','','J. Müller','135af76e-a9a0-5635-a340-adc199c511db','Caprotina costulata J. Müller, 1859','J. Müller, 1859','UNRANKED','','Caprotina','','costulata','','','',NULL,'','','','','','J. Müller','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07591','','','Emarginula costulata Deshayes, 1863',1,'Emarginula costulata','Emarginula costulata','Emarginula costulat',2,0,'','','Deshayes','5d9c2265-7540-5c4a-a2e9-9df944d68afa','Emarginula costulata Deshayes, 1863','Deshayes, 1863','UNRANKED','','Emarginula','','costulata','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07593','','','Leda costulata Deshayes, 1858',1,'Leda costulata','Leda costulata','Leda costulat',2,0,'','','Deshayes','03661921-49c4-5768-9e2d-2ac047b7a171','Leda costulata Deshayes, 1858','Deshayes, 1858','UNRANKED','','Leda','','costulata','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07598','','','Pleurotomaria costulata Fried. Roemer, 1850',1,'Pleurotomaria costulata','Pleurotomaria costulata','Pleurotomaria costulat',2,0,'','','Fried. Roemer','293e5104-21a3-593e-bae5-8f49c794fb6c','Pleurotomaria costulata Fried. Roemer, 1850','Fried. Roemer, 1850','UNRANKED','','Pleurotomaria','','costulata','','','',NULL,'','','','','','Fried. Roemer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07601','','','Rissoina costulata Dunker, 1860',1,'Rissoina costulata','Rissoina costulata','Rissoina costulat',2,0,'','','Dunker','b41f11f6-630f-5192-97b2-2288778feba5','Rissoina costulata Dunker, 1860','Dunker, 1860','UNRANKED','','Rissoina','','costulata','','','',NULL,'','','','','','Dunker','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07607','','','Discopsis costulatus Folin, 1870',1,'Discopsis costulatus','Discopsis costulatus','Discopsis costulat',2,0,'','','Folin','95688b05-780c-5e0f-81ab-cc329602bd66','Discopsis costulatus Folin, 1870','Folin, 1870','UNRANKED','','Discopsis','','costulatus','','','',NULL,'','','','','','Folin','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07610','','','Trochus costulatus Piette, 1855',1,'Trochus costulatus','Trochus costulatus','Trochus costulat',2,0,'','','Piette','0d1fdb5a-bfcc-5614-a8b4-f2b6b4069298','Trochus costulatus Piette, 1855','Piette, 1855','UNRANKED','','Trochus','','costulatus','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07614','','','Atys costulosa Pease, 1869',1,'Atys costulosa','Atys costulosa','Atys costulos',2,0,'','','Pease','98ff5bcd-b939-5992-b849-5d8e50cf888a','Atys costulosa Pease, 1869','Pease, 1869','UNRANKED','','Atys','','costulosa','','','',NULL,'','','','','','Pease','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07616','','','Leptachatina costulosa Pease, 1870',1,'Leptachatina costulosa','Leptachatina costulosa','Leptachatina costulos',2,0,'','','Pease','20eb51a1-eb5f-5ba4-8dda-db063b3233ba','Leptachatina costulosa Pease, 1870','Pease, 1870','UNRANKED','','Leptachatina','','costulosa','','','',NULL,'','','','','','Pease','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07621','','','Bulimus cotopaxiensis Pfeiffer, 1852',1,'Bulimus cotopaxiensis','Bulimus cotopaxiensis','Bulimus cotopaxiens',2,0,'','','Pfeiffer','2daaa64e-b5c5-5986-bb29-c3e6f6f2abca','Bulimus cotopaxiensis Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Bulimus','','cotopaxiensis','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07623','','','Trigonia cottaldi Munier, in Loriol and Cotteau, 1867',2,'Trigonia cottaldi','Trigonia cottaldi','Trigonia cottald',2,0,'','','Munier|Loriol|Cotteau','4ce9e189-0253-524d-b703-51483d00f165','Trigonia cottaldi Munier, in Loriol and Cotteau, 1867','Munier, in Loriol and Cotteau, 1867','UNRANKED','','Trigonia','','cottaldi','','','',NULL,'','','','','','Munier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07632','','','Buccinum (Nassa) coturnix Dunker, 1853',1,'Buccinum coturnix','Buccinum coturnix','Buccinum coturnix',2,0,'','','Dunker','d29d5105-a1b7-5bfd-aa58-891a460d77da','Buccinum (Nassa) coturnix Dunker, 1853','Dunker, 1853','UNRANKED','','Buccinum','Nassa','coturnix','','','',NULL,'','','','','','Dunker','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07636','','','Helix cotyledonis Benson, 1850',1,'Helix cotyledonis','Helix cotyledonis','Helix cotyledon',2,0,'','','Benson','e2a0b2ea-bdb1-5ae8-9380-7db8e4073696','Helix cotyledonis Benson, 1850','Benson, 1850','UNRANKED','','Helix','','cotyledonis','','','',NULL,'','','','','','Benson','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07640','','','Conus couderti Bernardi, 1860',1,'Conus couderti','Conus couderti','Conus coudert',2,0,'','','Bernardi','2a757f4c-5b91-55ac-b0a4-3af9b12d2583','Conus couderti Bernardi, 1860','Bernardi, 1860','UNRANKED','','Conus','','couderti','','','',NULL,'','','','','','Bernardi','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07645','','','Helix couloni Shuttleworth, 1852',1,'Helix couloni','Helix couloni','Helix coulon',2,0,'','','Shuttleworth','e5b5f03f-bb5f-5a68-9070-33aaaf8f93ce','Helix couloni Shuttleworth, 1852','Shuttleworth, 1852','UNRANKED','','Helix','','couloni','','','',NULL,'','','','','','Shuttleworth','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07649','','','Fusus countjeani Coquand, 1862',1,'Fusus countjeani','Fusus countjeani','Fusus countiean',2,0,'','','Coquand','84de662d-3342-52d3-affa-e3f1ee1341af','Fusus countjeani Coquand, 1862','Coquand, 1862','UNRANKED','','Fusus','','countjeani','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07656','','','Acteonina courtilleri Farge, 1862',1,'Acteonina courtilleri','Acteonina courtilleri','Acteonina courtiller',2,0,'','','Farge','05f70075-425e-5b4c-ac13-a67f79d9dfc4','Acteonina courtilleri Farge, 1862','Farge, 1862','UNRANKED','','Acteonina','','courtilleri','','','',NULL,'','','','','','Farge','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07661','','','Pleurotomaria coxana Meek and Worthen, 1866',1,'Pleurotomaria coxana','Pleurotomaria coxana','Pleurotomaria coxan',2,0,'','','Meek|Worthen','9f5e3666-bfc5-587f-9c5d-437ed0b035d3','Pleurotomaria coxana Meek and Worthen, 1866','Meek and Worthen, 1866','UNRANKED','','Pleurotomaria','','coxana','','','',NULL,'','','','','','Meek & Worthen','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07665','','','Gibbula coxi Angas, 1867',1,'Gibbula coxi','Gibbula coxi','Gibbula cox',2,0,'','','Angas','9734d299-8252-53c8-a50c-88a4bb64772c','Gibbula coxi Angas, 1867','Angas, 1867','UNRANKED','','Gibbula','','coxi','','','',NULL,'','','','','','Angas','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07670','','','Geotrochus coxianus Angas, 1867',1,'Geotrochus coxianus','Geotrochus coxianus','Geotrochus coxian',2,0,'','','Angas','378a3216-b432-5de3-91dd-0479e44ee92a','Geotrochus coxianus Angas, 1867','Angas, 1867','UNRANKED','','Geotrochus','','coxianus','','','',NULL,'','','','','','Angas','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07675','','','Alvania cranchiana Leach, in J. Gray, 1852',2,'Alvania cranchiana','Alvania cranchiana','Alvania cranchian',2,0,'','','Leach|J. Gray','ea073f35-a21d-5df1-b53f-e6b5f6d7304b','Alvania cranchiana Leach, in J. Gray, 1852','Leach, in J. Gray, 1852','UNRANKED','','Alvania','','cranchiana','','','',NULL,'','','','','','Leach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07682','','','Helix (Fruticicola) craspedocheila A. Adams, 1868',1,'Helix craspedocheila','Helix craspedocheila','Helix craspedocheil',2,0,'','','A. Adams','99c8f13e-287d-5da6-bd6b-67ef3c4682ce','Helix (Fruticicola) craspedocheila A. Adams, 1868','A. Adams, 1868','UNRANKED','','Helix','Fruticicola','craspedocheila','','','',NULL,'','','','','','A. Adams','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07687','','','Bulimus oblongus crassa Albers, 1850',1,'Bulimus oblongus crassa','Bulimus oblongus crassa','Bulimus oblong crass',3,0,'','','Albers','71d2b245-83dd-5c7b-9de0-8defb4805218','Bulimus oblongus crassa Albers, 1850','Albers, 1850','UNRANKED','','Bulimus','','oblongus','crassa','','',NULL,'','','','','','Albers','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07690','','','Cylindrella maugeri crassa C.B. Adams, 1851',1,'Cylindrella maugeri crassa','Cylindrella maugeri crassa','Cylindrella mauger crass',3,0,'','','C. B. Adams','44dd8625-3719-51a2-9d0a-416ed1f1ffab','Cylindrella maugeri crassa C.B. Adams, 1851','C.B. Adams, 1851','UNRANKED','','Cylindrella','','maugeri','crassa','','',NULL,'','','','','','C. B. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07697','','','Nassa (Desmoulea) crassa A. Adams, 1851',1,'Nassa crassa','Nassa crassa','Nassa crass',2,0,'','','A. Adams','fab02620-261d-5d12-aa4d-b7e6b3855632','Nassa (Desmoulea) crassa A. Adams, 1851','A. Adams, 1851','UNRANKED','','Nassa','Desmoulea','crassa','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07701','','','Phasianella crassa Brusina, 1865',1,'Phasianella crassa','Phasianella crassa','Phasianella crass',2,0,'','','Brusina','25fb352c-5e02-5d6f-8464-32951eb0a523','Phasianella crassa Brusina, 1865','Brusina, 1865','UNRANKED','','Phasianella','','crassa','','','',NULL,'','','','','','Brusina','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07706','','','Stomatella (Gena) crassa Montrouzier, in Souverbie and Montrouzier, 1870',2,'Stomatella crassa','Stomatella crassa','Stomatella crass',2,0,'','','Montrouzier|Souverbie','18e5dcf0-842c-5c14-be81-1e455e56acf2','Stomatella (Gena) crassa Montrouzier, in Souverbie and Montrouzier, 1870','Montrouzier, in Souverbie and Montrouzier, 1870','UNRANKED','','Stomatella','Gena','crassa','','','',NULL,'','','','','','Montrouzier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07715','','','Pleurotoma crassicosta F. Edwards, 1854',1,'Pleurotoma crassicosta','Pleurotoma crassicosta','Pleurotoma crassicost',2,0,'','','F. Edwards','cbbde8dd-80d0-5729-a540-e01397c9f5e4','Pleurotoma crassicosta F. Edwards, 1854','F. Edwards, 1854','UNRANKED','','Pleurotoma','','crassicosta','','','',NULL,'','','','','','F. Edwards','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07718','','','Clausilia crassicostata Benoit, in Pfeiffer, 1856',2,'Clausilia crassicostata','Clausilia crassicostata','Clausilia crassicostat',2,0,'','','Benoit|Pfeiffer','d4d033f9-0cf4-5eb0-9b86-7266a404bea6','Clausilia crassicostata Benoit, in Pfeiffer, 1856','Benoit, in Pfeiffer, 1856','UNRANKED','','Clausilia','','crassicostata','','','',NULL,'','','','','','Benoit','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07726','','','Helix tigriana crassidens Bourguignat, 1864',1,'Helix tigriana crassidens','Helix tigriana crassidens','Helix tigrian crassidens',3,0,'','','Bourguignat','fc811307-485c-5284-a287-17854bc065eb','Helix tigriana crassidens Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','tigriana','crassidens','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07729','','','Unio requienii crassidens A. Moquin-Tandon, 1855',1,'Unio requienii crassidens','Unio requienii crassidens','Unio requien crassidens',3,0,'','','A. Moquin-Tandon','594cd63b-f309-58be-bddb-773f18c14ea4','Unio requienii crassidens A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Unio','','requienii','crassidens','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07735','','','Bithinia crassilabris Deshayes, 1862',1,'Bithinia crassilabris','Bithinia crassilabris','Bithinia crassilabr',2,0,'','','Deshayes','37c3c673-709e-51ce-a409-1596b6189e55','Bithinia crassilabris Deshayes, 1862','Deshayes, 1862','UNRANKED','','Bithinia','','crassilabris','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07741','','','Cerithidea crassilabrum A. Adams, 1854',1,'Cerithidea crassilabrum','Cerithidea crassilabrum','Cerithidea crassilabr',2,0,'','','A. Adams','f2b5894c-d9e3-5ca6-8e89-2b8a135b70c4','Cerithidea crassilabrum A. Adams, 1854','A. Adams, 1854','UNRANKED','','Cerithidea','','crassilabrum','','','',NULL,'','','','','','A. Adams','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07748','','','Purpura crassilabrum Deshayes, 1865',1,'Purpura crassilabrum','Purpura crassilabrum','Purpura crassilabr',2,0,'','','Deshayes','a828967e-2fde-51a6-b1c3-eaa7a44364f8','Purpura crassilabrum Deshayes, 1865','Deshayes, 1865','UNRANKED','','Purpura','','crassilabrum','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07753','','','Cerithium plicatum crassinodosum F. Sandberger, 1863',1,'Cerithium plicatum crassinodosum','Cerithium plicatum crassinodosum','Cerithium plicat crassinodos',3,0,'','','F. Sandberger','5794b746-c2a7-5477-a18e-08d847a58031','Cerithium plicatum crassinodosum F. Sandberger, 1863','F. Sandberger, 1863','UNRANKED','','Cerithium','','plicatum','crassinodosum','','',NULL,'','','','','','F. Sandberger','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07759','','','Fusus crassisculptus Beyrich, 1856',1,'Fusus crassisculptus','Fusus crassisculptus','Fusus crassisculpt',2,0,'','','Beyrich','a7cb1235-d611-5000-a2f9-ed697a71a06c','Fusus crassisculptus Beyrich, 1856','Beyrich, 1856','UNRANKED','','Fusus','','crassisculptus','','','',NULL,'','','','','','Beyrich','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07766','','','Cyprina crassitesta Cotteau, 1855',1,'Cyprina crassitesta','Cyprina crassitesta','Cyprina crassitest',2,0,'','','Cotteau','29c2997c-dec7-587b-a1d7-6ab29adfe79c','Cyprina crassitesta Cotteau, 1855','Cotteau, 1855','UNRANKED','','Cyprina','','crassitesta','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07771','','','Lithoglyphus crassiuscula Frauenfeld, 1863',1,'Lithoglyphus crassiuscula','Lithoglyphus crassiuscula','Lithoglyphus crassiuscul',2,0,'','','Frauenfeld','6066fea2-25d6-5f38-a4b3-d9457d348a78','Lithoglyphus crassiuscula Frauenfeld, 1863','Frauenfeld, 1863','UNRANKED','','Lithoglyphus','','crassiuscula','','','',NULL,'','','','','','Frauenfeld','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07775','','','Anodonta variabilis crassula A. Moquin-Tandon, 1855',1,'Anodonta variabilis crassula','Anodonta variabilis crassula','Anodonta uariabil crassul',3,0,'','','A. Moquin-Tandon','ebea697c-0ad4-5e72-8f07-2387e09f29e6','Anodonta variabilis crassula A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Anodonta','','variabilis','crassula','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07781','','','Mesodesma crassula Deshayes, 1854',1,'Mesodesma crassula','Mesodesma crassula','Mesodesma crassul',2,0,'','','Deshayes','a98f0633-5add-5638-9c73-5636a920a3dd','Mesodesma crassula Deshayes, 1854','Deshayes, 1854','UNRANKED','','Mesodesma','','crassula','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07787','','','Caecum crassum Folin, 1870',1,'Caecum crassum','Caecum crassum','Caecum crass',2,0,'','','Folin','f3c2c492-f1ff-541a-8e49-e1b952535d19','Caecum crassum Folin, 1870','Folin, 1870','UNRANKED','','Caecum','','crassum','','','',NULL,'','','','','','Folin','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07792','','','Megalodus crassus Eichwald, 1857',1,'Megalodus crassus','Megalodus crassus','Megalodus crass',2,0,'','','Eichwald','a9d4fabc-9d34-5f82-981f-e01ec2f98cc7','Megalodus crassus Eichwald, 1857','Eichwald, 1857','UNRANKED','','Megalodus','','crassus','','','',NULL,'','','','','','Eichwald','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07796','','','Septifer crassus Dunker, 1853',1,'Septifer crassus','Septifer crassus','Septifer crass',2,0,'','','Dunker','1d9d4fa8-8fd5-51bd-bc19-15acb1693fb6','Septifer crassus Dunker, 1853','Dunker, 1853','UNRANKED','','Septifer','','crassus','','','',NULL,'','','','','','Dunker','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07802','','','Nassa craticulata Foresti, 1868',1,'Nassa craticulata','Nassa craticulata','Nassa craticulat',2,0,'','','Foresti','d438044b-3371-5293-91a9-f082a6332a78','Nassa craticulata Foresti, 1868','Foresti, 1868','UNRANKED','','Nassa','','craticulata','','','',NULL,'','','','','','Foresti','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07807','','','Turbo craticulatus Deshayes, 1863',1,'Turbo craticulatus','Turbo craticulatus','Turbo craticulat',2,0,'','','Deshayes','687c3dfc-de73-598c-99a2-891ed1ad0f8f','Turbo craticulatus Deshayes, 1863','Deshayes, 1863','UNRANKED','','Turbo','','craticulatus','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07812','','','Caecum crebricinctum P. Carpenter, 1864',1,'Caecum crebricinctum','Caecum crebricinctum','Caecum crebricinct',2,0,'','','P. Carpenter','251f702a-8eb6-5880-911d-980fcaa948a5','Caecum crebricinctum P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Caecum','','crebricinctum','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07817','','','Helix crebriflammis Pfeiffer, 1852',1,'Helix crebriflammis','Helix crebriflammis','Helix crebriflamm',2,0,'','','Pfeiffer','0061025b-60d3-5bb1-8c9f-b48aa5743414','Helix crebriflammis Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Helix','','crebriflammis','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07823','','','Astarte crebrilirata Wood, 1856',1,'Astarte crebrilirata','Astarte crebrilirata','Astarte crebrilirat',2,0,'','','Wood','11ae5325-3517-5fc3-b65c-e643b33b0979','Astarte crebrilirata Wood, 1856','Wood, 1856','UNRANKED','','Astarte','','crebrilirata','','','',NULL,'','','','','','Wood','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07832','','','Macrochlamys crebristriatus C. Semper, 1870',1,'Macrochlamys crebristriatus','Macrochlamys crebristriatus','Macrochlamys crebristriat',2,0,'','','C. Semper','9baabebf-5fb4-5af0-ba88-d73bcb47723f','Macrochlamys crebristriatus C. Semper, 1870','C. Semper, 1870','UNRANKED','','Macrochlamys','','crebristriatus','','','',NULL,'','','','','','C. Semper','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07836','','','Anatina creccina Valenciennes, in Reeve, 1860',2,'Anatina creccina','Anatina creccina','Anatina creccin',2,0,'','','Valenciennes|Reeve','578003aa-048c-5745-a7bb-0f06344c90c1','Anatina creccina Valenciennes, in Reeve, 1860','Valenciennes, in Reeve, 1860','UNRANKED','','Anatina','','creccina','','','',NULL,'','','','','','Valenciennes','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07843','','','Cylindrella crenata Weinland and Martens, in Martens, 1859',2,'Cylindrella crenata','Cylindrella crenata','Cylindrella crenat',2,0,'','','Weinland|Martens','53f7b4e4-63e9-52dd-9951-13b783f077bc','Cylindrella crenata Weinland and Martens, in Martens, 1859','Weinland and Martens, in Martens, 1859','UNRANKED','','Cylindrella','','crenata','','','',NULL,'','','','','','Weinland & Martens','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07849','','','Philine crenata A. Adams, 1862',1,'Philine crenata','Philine crenata','Philine crenat',2,0,'','','A. Adams','9545c3f2-ca61-5eaf-b223-ec2e3a2ee225','Philine crenata A. Adams, 1862','A. Adams, 1862','UNRANKED','','Philine','','crenata','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07856','','','Macroceramus crenatus Gundlach, in Pfeiffer, 1864',2,'Macroceramus crenatus','Macroceramus crenatus','Macroceramus crenat',2,0,'','','Gundlach|Pfeiffer','3b0dc32e-9ddd-5b0d-97bf-1e807ef78ae9','Macroceramus crenatus Gundlach, in Pfeiffer, 1864','Gundlach, in Pfeiffer, 1864','UNRANKED','','Macroceramus','','crenatus','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07865','','','Terebra crenifera Deshayes, 1859',1,'Terebra crenifera','Terebra crenifera','Terebra crenifer',2,0,'','','Deshayes','4628f74f-2cea-5db6-beae-8b770f44b39b','Terebra crenifera Deshayes, 1859','Deshayes, 1859','UNRANKED','','Terebra','','crenifera','','','',NULL,'','','','','','Deshayes','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07871','','','Cardiopsis crenistriata Winchell, 1862',1,'Cardiopsis crenistriata','Cardiopsis crenistriata','Cardiopsis crenistriat',2,0,'','','Winchell','3c90a3aa-5d54-5eb4-9d35-aed2b67a8777','Cardiopsis crenistriata Winchell, 1862','Winchell, 1862','UNRANKED','','Cardiopsis','','crenistriata','','','',NULL,'','','','','','Winchell','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07875','','','Solarium crenulare Deshayes, 1863',1,'Solarium crenulare','Solarium crenulare','Solarium crenular',2,0,'','','Deshayes','7d8a2218-3f62-58ab-84c4-67dc1ecc2e5a','Solarium crenulare Deshayes, 1863','Deshayes, 1863','UNRANKED','','Solarium','','crenulare','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07882','','','Chama crenulata Deshayes, 1858',1,'Chama crenulata','Chama crenulata','Chama crenulat',2,0,'','','Deshayes','a46c315a-9117-5ba0-96fb-50f94a1787df','Chama crenulata Deshayes, 1858','Deshayes, 1858','UNRANKED','','Chama','','crenulata','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07884','','','Cyrena crenulata Deshayes, 1857',1,'Cyrena crenulata','Cyrena crenulata','Cyrena crenulat',2,0,'','','Deshayes','061ddd81-42ed-50c5-a79c-2a10eb8ede8b','Cyrena crenulata Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cyrena','','crenulata','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07889','','','Marginella crenulata Deshayes, 1865',1,'Marginella crenulata','Marginella crenulata','Marginella crenulat',2,0,'','','Deshayes','42725a36-bd31-5c3a-8aa4-e9867c179f27','Marginella crenulata Deshayes, 1865','Deshayes, 1865','UNRANKED','','Marginella','','crenulata','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07893','','','Scalaria crenulata Piette, 1855',1,'Scalaria crenulata','Scalaria crenulata','Scalaria crenulat',2,0,'','','Piette','5432d039-864e-518a-9f1f-63c0de3963a4','Scalaria crenulata Piette, 1855','Piette, 1855','UNRANKED','','Scalaria','','crenulata','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07896','','','Solarium crenulatum C. Moore, 1866',1,'Solarium crenulatum','Solarium crenulatum','Solarium crenulat',2,0,'','','C. Moore','7b3d1ae6-fb9d-5f1a-9561-4a9e0e1eeec4','Solarium crenulatum C. Moore, 1866','C. Moore, 1866','UNRANKED','','Solarium','','crenulatum','','','',NULL,'','','','','','C. Moore','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07904','','','Anodonta crepera Lea, 1850',1,'Anodonta crepera','Anodonta crepera','Anodonta creper',2,0,'','','Lea','904cdadc-a076-5dfa-983f-b00819adcb24','Anodonta crepera Lea, 1850','Lea, 1850','UNRANKED','','Anodonta','','crepera','','','',NULL,'','','','','','Lea','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07907','','','Navicella crepiduloides Reeve, 1856',1,'Navicella crepiduloides','Navicella crepiduloides','Navicella crepiduloid',2,0,'','','Reeve','97e86707-5176-5b3a-a6e0-9176de98f492','Navicella crepiduloides Reeve, 1856','Reeve, 1856','UNRANKED','','Navicella','','crepiduloides','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07915','','','Bullopsis cretacea Conrad, 1858',1,'Bullopsis cretacea','Bullopsis cretacea','Bullopsis cretace',2,0,'','','Conrad','586a0fcc-d076-5b23-99d6-d80d31b3b58a','Bullopsis cretacea Conrad, 1858','Conrad, 1858','UNRANKED','','Bullopsis','','cretacea','','','',NULL,'','','','','','Conrad','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07919','','','Cylindrella cretacea Pfeiffer, 1860',1,'Cylindrella cretacea','Cylindrella cretacea','Cylindrella cretace',2,0,'','','Pfeiffer','541fcd1a-da3d-5095-838b-784617797d4d','Cylindrella cretacea Pfeiffer, 1860','Pfeiffer, 1860','UNRANKED','','Cylindrella','','cretacea','','','',NULL,'','','','','','Pfeiffer','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07925','','','Eulima cretacea Conrad, 1869',1,'Eulima cretacea','Eulima cretacea','Eulima cretace',2,0,'','','Conrad','412556ce-49ad-53dd-ba8f-b45874d3501d','Eulima cretacea Conrad, 1869','Conrad, 1869','UNRANKED','','Eulima','','cretacea','','','',NULL,'','','','','','Conrad','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07931','','','Mitra cretacea Gabb, 1864',1,'Mitra cretacea','Mitra cretacea','Mitra cretace',2,0,'','','Gabb','2c9f89a9-06f7-56fe-8d9f-19078e2e9d74','Mitra cretacea Gabb, 1864','Gabb, 1864','UNRANKED','','Mitra','','cretacea','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07936','','','Panopaea cretacea Tuomey, 1855',1,'Panopaea cretacea','Panopaea cretacea','Panopaea cretace',2,0,'','','Tuomey','dff66786-78d1-5f58-bdde-bd7a1ea9958d','Panopaea cretacea Tuomey, 1855','Tuomey, 1855','UNRANKED','','Panopaea','','cretacea','','','',NULL,'','','','','','Tuomey','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07943','','','Volvaria cretacea Alth, 1850',1,'Volvaria cretacea','Volvaria cretacea','Volvaria cretace',2,0,'','','Alth','e3aa2924-b4d7-5619-ba77-4c9dfb1e2d0e','Volvaria cretacea Alth, 1850','Alth, 1850','UNRANKED','','Volvaria','','cretacea','','','',NULL,'','','','','','Alth','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07950','','','Cultellus cretaceus Gabb, 1860',1,'Cultellus cretaceus','Cultellus cretaceus','Cultellus cretace',2,0,'','','Gabb','1194b1be-ff86-51b5-a7ba-9c91c89d345e','Cultellus cretaceus Gabb, 1860','Gabb, 1860','UNRANKED','','Cultellus','','cretaceus','','','',NULL,'','','','','','Gabb','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07956','','','Acmaea patina cribraria Gould, in P. Carpenter, 1866',2,'Acmaea patina cribraria','Acmaea patina cribraria','Acmaea patin cribrar',3,0,'','','Gould|P. Carpenter','5f2df00b-4fa2-5f07-9c04-b728e6c3a5d5','Acmaea patina cribraria Gould, in P. Carpenter, 1866','Gould, in P. Carpenter, 1866','UNRANKED','','Acmaea','','patina','cribraria','','',NULL,'','','','','','Gould','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07970','','','Unio crispisulcatus Benson, 1862',1,'Unio crispisulcatus','Unio crispisulcatus','Unio crispisulcat',2,0,'','','Benson','cf3c4059-f0e8-5716-b822-26d838779108','Unio crispisulcatus Benson, 1862','Benson, 1862','UNRANKED','','Unio','','crispisulcatus','','','',NULL,'','','','','','Benson','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07976','','','Rissoa cristallinula Manzoni, 1868',1,'Rissoa cristallinula','Rissoa cristallinula','Rissoa cristallinul',2,0,'','','Manzoni','2b5850e2-1455-5c27-9ed7-20be36e76d05','Rissoa cristallinula Manzoni, 1868','Manzoni, 1868','UNRANKED','','Rissoa','','cristallinula','','','',NULL,'','','','','','Manzoni','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07982','','','Cyprina cristata Stoliczka, 1870',1,'Cyprina cristata','Cyprina cristata','Cyprina cristat',2,0,'','','Stoliczka','f88842b9-370c-51d6-86ee-84491e6f8a08','Cyprina cristata Stoliczka, 1870','Stoliczka, 1870','UNRANKED','','Cyprina','','cristata','','','',NULL,'','','','','','Stoliczka','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07985','','','Melania cristata Anthony, 1854',1,'Melania cristata','Melania cristata','Melania cristat',2,0,'','','Anthony','b5a6966f-b14d-5086-93f1-a4d5963cc7f0','Melania cristata Anthony, 1854','Anthony, 1854','UNRANKED','','Melania','','cristata','','','',NULL,'','','','','','Anthony','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07987','','','Neritina cristata Morelet, 1864',1,'Neritina cristata','Neritina cristata','Neritina cristat',2,0,'','','Morelet','86fef0cc-efb2-5094-a783-76298b97e2b0','Neritina cristata Morelet, 1864','Morelet, 1864','UNRANKED','','Neritina','','cristata','','','',NULL,'','','','','','Morelet','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07994','','','Serpulorbis cristatus Deshayes, 1861',1,'Serpulorbis cristatus','Serpulorbis cristatus','Serpulorbis cristat',2,0,'','','Deshayes','01f644a7-0009-597d-aba7-a4a40ae57b4c','Serpulorbis cristatus Deshayes, 1861','Deshayes, 1861','UNRANKED','','Serpulorbis','','cristatus','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_07998','','','Vermetus cristatus F. Sandberger, 1863',1,'Vermetus cristatus','Vermetus cristatus','Vermetus cristat',2,0,'','','F. Sandberger','69b0bb2b-1732-5bc1-a563-e07ec2442327','Vermetus cristatus F. Sandberger, 1863','F. Sandberger, 1863','UNRANKED','','Vermetus','','cristatus','','','',NULL,'','','','','','F. Sandberger','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08004','','','Haminea crocata Pease, 1860',1,'Haminea crocata','Haminea crocata','Haminea crocat',2,0,'','','Pease','48105622-4f1b-5f5e-9bd8-664282f4d99a','Haminea crocata Pease, 1860','Pease, 1860','UNRANKED','','Haminea','','crocata','','','',NULL,'','','','','','Pease','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08009','','','Cominella crocea A. Adams, 1853',1,'Cominella crocea','Cominella crocea','Cominella croce',2,0,'','','A. Adams','d68e6024-1348-5eb9-827f-02d209e1a9a8','Cominella crocea A. Adams, 1853','A. Adams, 1853','UNRANKED','','Cominella','','crocea','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08017','','','Unio cromwellii Lea, 1865',1,'Unio cromwellii','Unio cromwellii','Unio cromwell',2,0,'','','Lea','416fd14e-7bba-5af1-9580-b1eda0606de8','Unio cromwellii Lea, 1865','Lea, 1865','UNRANKED','','Unio','','cromwellii','','','',NULL,'','','','','','Lea','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08023','','','Hydrocena crosseana Gassies, 1869',1,'Hydrocena crosseana','Hydrocena crosseana','Hydrocena crossean',2,0,'','','Gassies','d5f0ceff-8c3f-557d-9ba0-a7ec1e033eed','Hydrocena crosseana Gassies, 1869','Gassies, 1869','UNRANKED','','Hydrocena','','crosseana','','','',NULL,'','','','','','Gassies','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08029','','','Dolium crosseanum Monterosato, 1869',1,'Dolium crosseanum','Dolium crosseanum','Dolium crossean',2,0,'','','Monterosato','f2f19108-2a1e-50fc-b8bf-3d8e68df764c','Dolium crosseanum Monterosato, 1869','Monterosato, 1869','UNRANKED','','Dolium','','crosseanum','','','',NULL,'','','','','','Monterosato','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08036','','','Cancellaria crossei J. Semper, 1861',1,'Cancellaria crossei','Cancellaria crossei','Cancellaria crosse',2,0,'','','J. Semper','65e92b34-7bad-5afc-a1eb-d72fdcc2a1c3','Cancellaria crossei J. Semper, 1861','J. Semper, 1861','UNRANKED','','Cancellaria','','crossei','','','',NULL,'','','','','','J. Semper','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08042','','','Meioceras crossei Folin, 1869',1,'Meioceras crossei','Meioceras crossei','Meioceras crosse',2,0,'','','Folin','bf576045-1e1b-5c95-a890-c083ccecc953','Meioceras crossei Folin, 1869','Folin, 1869','UNRANKED','','Meioceras','','crossei','','','',NULL,'','','','','','Folin','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08045','','','Streptaxis crossei Pfeiffer, 1867',1,'Streptaxis crossei','Streptaxis crossei','Streptaxis crosse',2,0,'','','Pfeiffer','349fae04-63ee-52d2-8ccc-c9405c32a857','Streptaxis crossei Pfeiffer, 1867','Pfeiffer, 1867','UNRANKED','','Streptaxis','','crossei','','','',NULL,'','','','','','Pfeiffer','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08047','','','Vertigo crossei Michaud, 1862',1,'Vertigo crossei','Vertigo crossei','Vertigo crosse',2,0,'','','Michaud','cb5787fc-5004-544e-b6c0-5fed7710a5cd','Vertigo crossei Michaud, 1862','Michaud, 1862','UNRANKED','','Vertigo','','crossei','','','',NULL,'','','','','','Michaud','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08056','','','Scalaria cruciana Pictet and Campiche, 1862',1,'Scalaria cruciana','Scalaria cruciana','Scalaria crucian',2,0,'','','Pictet|Campiche','4e2dc133-d137-5d78-baef-a6c2387a69e1','Scalaria cruciana Pictet and Campiche, 1862','Pictet and Campiche, 1862','UNRANKED','','Scalaria','','cruciana','','','',NULL,'','','','','','Pictet & Campiche','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08059','','','Cardium cruciatum Eichwald, 1868',1,'Cardium cruciatum','Cardium cruciatum','Cardium cruciat',2,0,'','','Eichwald','684574df-a9e5-55e3-acc3-65ec5cbe3abd','Cardium cruciatum Eichwald, 1868','Eichwald, 1868','UNRANKED','','Cardium','','cruciatum','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08064','','','Goniobasis cruda Lea, 1862',1,'Goniobasis cruda','Goniobasis cruda','Goniobasis crud',2,0,'','','Lea','bd3fecdc-487c-5f0e-b3c8-b8854d045f05','Goniobasis cruda Lea, 1862','Lea, 1862','UNRANKED','','Goniobasis','','cruda','','','',NULL,'','','','','','Lea','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08067','','','Pecten cruentatus Reeve, 1853',1,'Pecten cruentatus','Pecten cruentatus','Pecten cruentat',2,0,'','','Reeve','40b1941c-a932-5ac0-90d3-0a1a95f0c0e2','Pecten cruentatus Reeve, 1853','Reeve, 1853','UNRANKED','','Pecten','','cruentatus','','','',NULL,'','','','','','Reeve','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08075','','','Helix (Streptaxis) cryptodon S. Moricand, 1851',1,'Helix cryptodon','Helix cryptodon','Helix cryptodon',2,0,'','','S. Moricand','65f2eb82-7ee9-54b8-aa7a-3f45f183df82','Helix (Streptaxis) cryptodon S. Moricand, 1851','S. Moricand, 1851','UNRANKED','','Helix','Streptaxis','cryptodon','','','',NULL,'','','','','','S. Moricand','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08078','','','Menestho cryptostyla J. Semper, 1861',1,'Menestho cryptostyla','Menestho cryptostyla','Menestho cryptostyl',2,0,'','','J. Semper','e073a7ab-23a3-5d7c-9b1f-5d4febadcf20','Menestho cryptostyla J. Semper, 1861','J. Semper, 1861','UNRANKED','','Menestho','','cryptostyla','','','',NULL,'','','','','','J. Semper','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08083','','','Leiostraca crystallina A. Adams, 1864',1,'Leiostraca crystallina','Leiostraca crystallina','Leiostraca crystallin',2,0,'','','A. Adams','32809142-791e-5b7c-aadb-2fe758ca0461','Leiostraca crystallina A. Adams, 1864','A. Adams, 1864','UNRANKED','','Leiostraca','','crystallina','','','',NULL,'','','','','','A. Adams','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08090','','','Spiraxis cubaniana Pfeiffer, 1852',1,'Spiraxis cubaniana','Spiraxis cubaniana','Spiraxis cubanian',2,0,'','','Pfeiffer','e683ef29-6506-5c62-b9ff-50d8ae72c932','Spiraxis cubaniana Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Spiraxis','','cubaniana','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08094','','','Patella cubensis Reeve, 1855',1,'Patella cubensis','Patella cubensis','Patella cubens',2,0,'','','Reeve','742c60ba-f66f-5bed-9414-83b17bc65df1','Patella cubensis Reeve, 1855','Reeve, 1855','UNRANKED','','Patella','','cubensis','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08097','','','Turbonilla cubitata Folin, 1868',1,'Turbonilla cubitata','Turbonilla cubitata','Turbonilla cubitat',2,0,'','','Folin','cf7e74ec-77da-5774-80ee-1278cb159ff4','Turbonilla cubitata Folin, 1868','Folin, 1868','UNRANKED','','Turbonilla','','cubitata','','','',NULL,'','','','','','Folin','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08102','','','Emarginula cucullata A. Adams, 1851',1,'Emarginula cucullata','Emarginula cucullata','Emarginula cucullat',2,0,'','','A. Adams','c97eea7e-3e08-5780-a6e5-44f39eac32e7','Emarginula cucullata A. Adams, 1851','A. Adams, 1851','UNRANKED','','Emarginula','','cucullata','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08109','','','Ostrea cucullina Deshayes, 1863',1,'Ostrea cucullina','Ostrea cucullina','Ostrea cucullin',2,0,'','','Deshayes','3fa7fda0-254a-5a0f-91a5-ae2bfd26ff19','Ostrea cucullina Deshayes, 1863','Deshayes, 1863','UNRANKED','','Ostrea','','cucullina','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08114','','','Bulimus cuencanus Pfeiffer, 1858',1,'Bulimus cuencanus','Bulimus cuencanus','Bulimus cuencan',2,0,'','','Pfeiffer','1eeb3ee4-1106-5a9e-8320-e5cf8b753201','Bulimus cuencanus Pfeiffer, 1858','Pfeiffer, 1858','UNRANKED','','Bulimus','','cuencanus','','','',NULL,'','','','','','Pfeiffer','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08118','','','Bulla (Akera) culcitella Gould, 1853',1,'Bulla culcitella','Bulla culcitella','Bulla culcitell',2,0,'','','Gould','4a224e56-1c95-532c-b41b-6729327750af','Bulla (Akera) culcitella Gould, 1853','Gould, 1853','UNRANKED','','Bulla','Akera','culcitella','','','',NULL,'','','','','','Gould','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08121','','','Pleurotomaria culminata Hebert and Eudes-Deslongchamps, 1860',1,'Pleurotomaria culminata','Pleurotomaria culminata','Pleurotomaria culminat',2,0,'','','Hebert|Eudes-Deslongchamps','cf6d383f-13a1-54ce-a23c-c2e83bfc3977','Pleurotomaria culminata Hebert and Eudes-Deslongchamps, 1860','Hebert and Eudes-Deslongchamps, 1860','UNRANKED','','Pleurotomaria','','culminata','','','',NULL,'','','','','','Hebert & Eudes-Deslongchamps','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08133','','','Goniobasis cumberlandensis Lea, 1867',1,'Goniobasis cumberlandensis','Goniobasis cumberlandensis','Goniobasis cumberlandens',2,0,'','','Lea','f63c8108-e4fe-5bca-82f1-17b0f080b20a','Goniobasis cumberlandensis Lea, 1867','Lea, 1867','UNRANKED','','Goniobasis','','cumberlandensis','','','',NULL,'','','','','','Lea','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08139','','','Achatinella cumingi Newcomb, 1853',1,'Achatinella cumingi','Achatinella cumingi','Achatinella cuming',2,0,'','','Newcomb','3564bb51-7a54-537a-b864-27acdd2db745','Achatinella cumingi Newcomb, 1853','Newcomb, 1853','UNRANKED','','Achatinella','','cumingi','','','',NULL,'','','','','','Newcomb','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08142','','','Anodonta cumingii Lea, 1850',1,'Anodonta cumingii','Anodonta cumingii','Anodonta cuming',2,0,'','','Lea','2fed5ec1-a792-587b-b7de-e283e909ab9d','Anodonta cumingii Lea, 1850','Lea, 1850','UNRANKED','','Anodonta','','cumingii','','','',NULL,'','','','','','Lea','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08147','','','Cardita cumingii Deshayes, 1852',1,'Cardita cumingii','Cardita cumingii','Cardita cuming',2,0,'','','Deshayes','1284a293-cbe4-53af-b5ff-c39586f2b2d4','Cardita cumingii Deshayes, 1852','Deshayes, 1852','UNRANKED','','Cardita','','cumingii','','','',NULL,'','','','','','Deshayes','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08151','','','Clementia cumingii Deshayes, 1854',1,'Clementia cumingii','Clementia cumingii','Clementia cuming',2,0,'','','Deshayes','10107a5a-fc47-5b7c-a814-1449ccb5d888','Clementia cumingii Deshayes, 1854','Deshayes, 1854','UNRANKED','','Clementia','','cumingii','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08158','','','Eglisia cumingii A. Adams, 1850',1,'Eglisia cumingii','Eglisia cumingii','Eglisia cuming',2,0,'','','A. Adams','8d082a87-a8b3-51ae-be2f-cd6e0c2c26a3','Eglisia cumingii A. Adams, 1850','A. Adams, 1850','UNRANKED','','Eglisia','','cumingii','','','',NULL,'','','','','','A. Adams','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08162','','','Fossar cumingii A. Adams, 1853',1,'Fossar cumingii','Fossar cumingii','Fossar cuming',2,0,'','','A. Adams','d9fe5fcc-9691-59ad-9822-0a0457025970','Fossar cumingii A. Adams, 1853','A. Adams, 1853','UNRANKED','','Fossar','','cumingii','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08166','','','Lampania cumingi Crosse, 1862',1,'Lampania cumingi','Lampania cumingi','Lampania cuming',2,0,'','','Crosse','58dc8601-7c8b-5996-ad56-ba9c21e5b104','Lampania cumingi Crosse, 1862','Crosse, 1862','UNRANKED','','Lampania','','cumingi','','','',NULL,'','','','','','Crosse','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08172','','','Margarita cumingii A. Adams, 1851',1,'Margarita cumingii','Margarita cumingii','Margarita cuming',2,0,'','','A. Adams','12394af3-8ac1-589f-8f4d-2cad8073f6cb','Margarita cumingii A. Adams, 1851','A. Adams, 1851','UNRANKED','','Margarita','','cumingii','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08178','','','Neptunea cumingi Crosse, 1862',1,'Neptunea cumingi','Neptunea cumingi','Neptunea cuming',2,0,'','','Crosse','f2e3b6ee-b3ca-5ac2-aabe-5e3cdf4043b2','Neptunea cumingi Crosse, 1862','Crosse, 1862','UNRANKED','','Neptunea','','cumingi','','','',NULL,'','','','','','Crosse','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08182','','','Patella cumingii Reeve, 1854',1,'Patella cumingii','Patella cumingii','Patella cuming',2,0,'','','Reeve','be7d39c0-9d2e-585f-85a8-a4bed4d501cb','Patella cumingii Reeve, 1854','Reeve, 1854','UNRANKED','','Patella','','cumingii','','','',NULL,'','','','','','Reeve','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08187','','','Pinna cumingii Hanley, 1858',1,'Pinna cumingii','Pinna cumingii','Pinna cuming',2,0,'','','Hanley','e8bf39b5-8afe-5011-ba73-6f576e9c3674','Pinna cumingii Hanley, 1858','Hanley, 1858','UNRANKED','','Pinna','','cumingii','','','',NULL,'','','','','','Hanley','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08189','','','Pythina cumingii A. Adams, 1856',1,'Pythina cumingii','Pythina cumingii','Pythina cuming',2,0,'','','A. Adams','1d0dbc23-87a8-51b4-9b40-8abff78b8802','Pythina cumingii A. Adams, 1856','A. Adams, 1856','UNRANKED','','Pythina','','cumingii','','','',NULL,'','','','','','A. Adams','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08197','','','Stomatella cumingii A. Adams, 1853',1,'Stomatella cumingii','Stomatella cumingii','Stomatella cuming',2,0,'','','A. Adams','cb022ee7-43e7-5d96-8b43-56d08807e6f6','Stomatella cumingii A. Adams, 1853','A. Adams, 1853','UNRANKED','','Stomatella','','cumingii','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08205','','','Venerupis cumingii Deshayes, 1853',1,'Venerupis cumingii','Venerupis cumingii','Venerupis cuming',2,0,'','','Deshayes','f9f70cc6-7ecc-5135-9445-d0af4f62851d','Venerupis cumingii Deshayes, 1853','Deshayes, 1853','UNRANKED','','Venerupis','','cumingii','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08209','','','Caecella cumingiana Deshayes, 1854',1,'Caecella cumingiana','Caecella cumingiana','Caecella cumingian',2,0,'','','Deshayes','ba0f1d11-1446-5864-bfbf-e9f55e26e3e4','Caecella cumingiana Deshayes, 1854','Deshayes, 1854','UNRANKED','','Caecella','','cumingiana','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08215','','','Modiola cumingiana Dunker, in Reeve, 1857',2,'Modiola cumingiana','Modiola cumingiana','Modiola cumingian',2,0,'','','Dunker|Reeve','f2b06293-88a0-5134-b7b9-25ecf87cd79d','Modiola cumingiana Dunker, in Reeve, 1857','Dunker, in Reeve, 1857','UNRANKED','','Modiola','','cumingiana','','','',NULL,'','','','','','Dunker','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08223','','','Zenatia cumingiana Deshayes, 1854',1,'Zenatia cumingiana','Zenatia cumingiana','Zenatia cumingian',2,0,'','','Deshayes','46321f69-ef18-52e1-b44e-bd8840cdfc30','Zenatia cumingiana Deshayes, 1854','Deshayes, 1854','UNRANKED','','Zenatia','','cumingiana','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08230','','','Cistula cumulata Pfeiffer, 1863',1,'Cistula cumulata','Cistula cumulata','Cistula cumulat',2,0,'','','Pfeiffer','d1f65a65-71dd-53cb-b461-bd29f911521d','Cistula cumulata Pfeiffer, 1863','Pfeiffer, 1863','UNRANKED','','Cistula','','cumulata','','','',NULL,'','','','','','Pfeiffer','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08238','','','Cylichna cuneata Tiberi, 1868',1,'Cylichna cuneata','Cylichna cuneata','Cylichna cuneat',2,0,'','','Tiberi','4b589503-fd1e-5a44-abd1-0168bd7be99c','Cylichna cuneata Tiberi, 1868','Tiberi, 1868','UNRANKED','','Cylichna','','cuneata','','','',NULL,'','','','','','Tiberi','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08241','','','Lutraria cuneata Schafhäutl, 1863',1,'Lutraria cuneata','Lutraria cuneata','Lutraria cuneat',2,0,'','','Schafhäutl','550ecfac-010b-5c97-941e-f647b7ac8f1a','Lutraria cuneata Schafhäutl, 1863','Schafhäutl, 1863','UNRANKED','','Lutraria','','cuneata','','','',NULL,'','','','','','Schafhäutl','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08249','','','Buccinum cuneatum Mayer, 1860',1,'Buccinum cuneatum','Buccinum cuneatum','Buccinum cuneat',2,0,'','','Mayer','abf36c7b-5060-53c1-bbb9-c8eb96cca059','Buccinum cuneatum Mayer, 1860','Mayer, 1860','UNRANKED','','Buccinum','','cuneatum','','','',NULL,'','','','','','Mayer','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08251','','','Pisidium cuneatum Bielz, 1862',1,'Pisidium cuneatum','Pisidium cuneatum','Pisidium cuneat',2,0,'','','Bielz','0aeca1a9-65f7-553b-9567-c04384baf4fd','Pisidium cuneatum Bielz, 1862','Bielz, 1862','UNRANKED','','Pisidium','','cuneatum','','','',NULL,'','','','','','Bielz','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08257','','','Lutraria cuneiformis Hupe, 1854',1,'Lutraria cuneiformis','Lutraria cuneiformis','Lutraria cuneiform',2,0,'','','Hupe','93d61c9c-4814-5ba1-b429-d15bc37bad94','Lutraria cuneiformis Hupe, 1854','Hupe, 1854','UNRANKED','','Lutraria','','cuneiformis','','','',NULL,'','','','','','Hupe','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08266','','','Pecten cuneolus Reeve, 1853',1,'Pecten cuneolus','Pecten cuneolus','Pecten cuneol',2,0,'','','Reeve','057fc8b7-8258-5562-82c0-e343933f94a2','Pecten cuneolus Reeve, 1853','Reeve, 1853','UNRANKED','','Pecten','','cuneolus','','','',NULL,'','','','','','Reeve','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08270','','','Achatinella cuneus Pfeiffer, 1855',1,'Achatinella cuneus','Achatinella cuneus','Achatinella cune',2,0,'','','Pfeiffer','224c880c-2291-503a-bcb8-1bfd134c65db','Achatinella cuneus Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Achatinella','','cuneus','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08275','','','Cyrena cunninghamii Forbes, 1851',1,'Cyrena cunninghamii','Cyrena cunninghamii','Cyrena cunningham',2,0,'','','Forbes','dc9ddc48-8334-544b-9df1-95ac21e539ed','Cyrena cunninghamii Forbes, 1851','Forbes, 1851','UNRANKED','','Cyrena','','cunninghamii','','','',NULL,'','','','','','Forbes','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08282','','','Ampullaria cuprina Reeve, 1856',1,'Ampullaria cuprina','Ampullaria cuprina','Ampullaria cuprin',2,0,'','','Reeve','9ccec546-8648-5e38-9617-830abc9d8ac2','Ampullaria cuprina Reeve, 1856','Reeve, 1856','UNRANKED','','Ampullaria','','cuprina','','','',NULL,'','','','','','Reeve','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08290','','','Amnicola currieriana Lea, 1863',1,'Amnicola currieriana','Amnicola currieriana','Amnicola currierian',2,0,'','','Lea','af09d093-92e6-5da7-9fe7-769b9eee62d0','Amnicola currieriana Lea, 1863','Lea, 1863','UNRANKED','','Amnicola','','currieriana','','','',NULL,'','','','','','Lea','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08291','','','Achatinella curta Newcomb, 1853',1,'Achatinella curta','Achatinella curta','Achatinella curt',2,0,'','','Newcomb','3c9c6944-ea43-56e7-899e-f98585891706','Achatinella curta Newcomb, 1853','Newcomb, 1853','UNRANKED','','Achatinella','','curta','','','',NULL,'','','','','','Newcomb','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08302','','','Isocardia curta Shumard, in Shumard and Swallow, 1858',2,'Isocardia curta','Isocardia curta','Isocardia curt',2,0,'','','Shumard|Swallow','72ee7db2-392a-5a58-b7ca-f2c9ab24aa0b','Isocardia curta Shumard, in Shumard and Swallow, 1858','Shumard, in Shumard and Swallow, 1858','UNRANKED','','Isocardia','','curta','','','',NULL,'','','','','','Shumard','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08307','','','Melanopsis curta Gassies, 1870',1,'Melanopsis curta','Melanopsis curta','Melanopsis curt',2,0,'','','Gassies','8475e9c5-1834-5e5e-a33a-0cf0276d98c3','Melanopsis curta Gassies, 1870','Gassies, 1870','UNRANKED','','Melanopsis','','curta','','','',NULL,'','','','','','Gassies','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08312','','','Nerinaea curta Eichwald, 1868',1,'Nerinaea curta','Nerinaea curta','Nerinaea curt',2,0,'','','Eichwald','f5ce3c2d-d95d-51f4-a39d-054084779b03','Nerinaea curta Eichwald, 1868','Eichwald, 1868','UNRANKED','','Nerinaea','','curta','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08315','','','Pleurotoma curta F. Edwards, 1860',1,'Pleurotoma curta','Pleurotoma curta','Pleurotoma curt',2,0,'','','F. Edwards','413ab12b-3d1c-5089-a5f9-5c36d4e21eab','Pleurotoma curta F. Edwards, 1860','F. Edwards, 1860','UNRANKED','','Pleurotoma','','curta','','','',NULL,'','','','','','F. Edwards','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08323','','','Thracia curtansata Morris and Lycett, 1853',1,'Thracia curtansata','Thracia curtansata','Thracia curtansat',2,0,'','','Morris|Lycett','abc0f2bd-c629-5bf0-8fda-701b22c1f90c','Thracia curtansata Morris and Lycett, 1853','Morris and Lycett, 1853','UNRANKED','','Thracia','','curtansata','','','',NULL,'','','','','','Morris & Lycett','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08329','','','Cardium (Hemicardium) curtum Meek and Hayden, 1861',1,'Cardium curtum','Cardium curtum','Cardium curt',2,0,'','','Meek|Hayden','02e84c71-0513-5eb7-af56-da8471289f78','Cardium (Hemicardium) curtum Meek and Hayden, 1861','Meek and Hayden, 1861','UNRANKED','','Cardium','Hemicardium','curtum','','','',NULL,'','','','','','Meek & Hayden','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08332','','','Odostomia curtum Deshayes, 1861',1,'Odostomia curtum','Odostomia curtum','Odostomia curt',2,0,'','','Deshayes','35a0e8fe-9956-5480-a4a4-4903d9085786','Odostomia curtum Deshayes, 1861','Deshayes, 1861','UNRANKED','','Odostomia','','curtum','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08339','','','Mytilus curvatus Dunker, 1856',1,'Mytilus curvatus','Mytilus curvatus','Mytilus curuat',2,0,'','','Dunker','ce18ce80-058d-57ab-99b5-5b0258802164','Mytilus curvatus Dunker, 1856','Dunker, 1856','UNRANKED','','Mytilus','','curvatus','','','',NULL,'','','','','','Dunker','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08342','','','Melania curvicostata Deshayes, 1862',1,'Melania curvicostata','Melania curvicostata','Melania curuicostat',2,0,'','','Deshayes','a18a0541-c0f2-5284-9965-c766454923ac','Melania curvicostata Deshayes, 1862','Deshayes, 1862','UNRANKED','','Melania','','curvicostata','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08346','','','Rimella curviliratus Conrad, 1858',1,'Rimella curviliratus','Rimella curviliratus','Rimella curuilirat',2,0,'','','Conrad','dd38a0b7-094e-5cfb-b05c-acb2932ac8a6','Rimella curviliratus Conrad, 1858','Conrad, 1858','UNRANKED','','Rimella','','curviliratus','','','',NULL,'','','','','','Conrad','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08352','','','Platyceras curvirostrum Hall, 1859',1,'Platyceras curvirostrum','Platyceras curvirostrum','Platyceras curuirostr',2,0,'','','Hall','e79c6f3c-1461-51b2-8d6b-a5349b0f4142','Platyceras curvirostrum Hall, 1859','Hall, 1859','UNRANKED','','Platyceras','','curvirostrum','','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08354','','','Emarginula cusmichiana Brusina, 1866',1,'Emarginula cusmichiana','Emarginula cusmichiana','Emarginula cusmichian',2,0,'','','Brusina','6f7568e2-79bc-5c31-9ad9-3c72cb47f2de','Emarginula cusmichiana Brusina, 1866','Brusina, 1866','UNRANKED','','Emarginula','','cusmichiana','','','',NULL,'','','','','','Brusina','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08358','','','Leda cuspidata Gould, 1861',1,'Leda cuspidata','Leda cuspidata','Leda cuspidat',2,0,'','','Gould','913e2ebb-cc17-57c0-82f0-57b7638b1fb2','Leda cuspidata Gould, 1861','Gould, 1861','UNRANKED','','Leda','','cuspidata','','','',NULL,'','','','','','Gould','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08361','','','Natica cuspidata Deshayes, 1864',1,'Natica cuspidata','Natica cuspidata','Natica cuspidat',2,0,'','','Deshayes','5804e04b-9db9-515f-9834-56109ab10bb7','Natica cuspidata Deshayes, 1864','Deshayes, 1864','UNRANKED','','Natica','','cuspidata','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08365','','','Bulimus cuspidatus Morelet, 1863',1,'Bulimus cuspidatus','Bulimus cuspidatus','Bulimus cuspidat',2,0,'','','Morelet','c7080f92-4d19-5e39-906f-12bc2e73c5ee','Bulimus cuspidatus Morelet, 1863','Morelet, 1863','UNRANKED','','Bulimus','','cuspidatus','','','',NULL,'','','','','','Morelet','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08370','','','Macrochlamys cutteri H. Adams, 1870',1,'Macrochlamys cutteri','Macrochlamys cutteri','Macrochlamys cutter',2,0,'','','H. Adams','c1d772a4-9037-51c2-b199-6fa694256605','Macrochlamys cutteri H. Adams, 1870','H. Adams, 1870','UNRANKED','','Macrochlamys','','cutteri','','','',NULL,'','','','','','H. Adams','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08372','','','Leptoconchus cuvieri Deshayes, 1863',1,'Leptoconchus cuvieri','Leptoconchus cuvieri','Leptoconchus cuuier',2,0,'','','Deshayes','965b9b89-d1a5-5b17-a968-675296a4ed2f','Leptoconchus cuvieri Deshayes, 1863','Deshayes, 1863','UNRANKED','','Leptoconchus','','cuvieri','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08377','','','Unio cuvierianus Lea, 1852',1,'Unio cuvierianus','Unio cuvierianus','Unio cuuierian',2,0,'','','Lea','4b1bc779-21e6-5c80-95dd-7d65f8521a41','Unio cuvierianus Lea, 1852','Lea, 1852','UNRANKED','','Unio','','cuvierianus','','','',NULL,'','','','','','Lea','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08380','','','Unio cyamus Philippi, 1851',1,'Unio cyamus','Unio cyamus','Unio cyam',2,0,'','','Philippi','dc038fa2-dc80-51d0-98ed-ce3ddf1e9b25','Unio cyamus Philippi, 1851','Philippi, 1851','UNRANKED','','Unio','','cyamus','','','',NULL,'','','','','','Philippi','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08385','','','Phos cyanostoma A. Adams, 1850',1,'Phos cyanostoma','Phos cyanostoma','Phos cyanostom',2,0,'','','A. Adams','bbfa651d-e169-5e2a-8769-12255dc07ec8','Phos cyanostoma A. Adams, 1850','A. Adams, 1850','UNRANKED','','Phos','','cyanostoma','','','',NULL,'','','','','','A. Adams','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08393','','','Dosinia cyclas E. Römer, 1870',1,'Dosinia cyclas','Dosinia cyclas','Dosinia cycl',2,0,'','','E. Römer','6288e42c-56ce-555f-9833-dc5f0bbc68e4','Dosinia cyclas E. Römer, 1870','E. Römer, 1870','UNRANKED','','Dosinia','','cyclas','','','',NULL,'','','','','','E. Römer','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08396','','','Cyclotus cycloatus Chitty, 1857',1,'Cyclotus cycloatus','Cyclotus cycloatus','Cyclotus cycloat',2,0,'','','Chitty','a1bb810e-6bc9-54d8-89ac-586c89ee1728','Cyclotus cycloatus Chitty, 1857','Chitty, 1857','UNRANKED','','Cyclotus','','cycloatus','','','',NULL,'','','','','','Chitty','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08404','','','Helix cycloplax Benson, 1852',1,'Helix cycloplax','Helix cycloplax','Helix cycloplax',2,0,'','','Benson','c9fd4024-de23-5051-8a7f-b094b8759d4e','Helix cycloplax Benson, 1852','Benson, 1852','UNRANKED','','Helix','','cycloplax','','','',NULL,'','','','','','Benson','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08407','','','Cylindrella cyclostoma Pfeiffer, 1855',1,'Cylindrella cyclostoma','Cylindrella cyclostoma','Cylindrella cyclostom',2,0,'','','Pfeiffer','10bf77df-d6fa-5915-abb3-b39b6dd9a849','Cylindrella cyclostoma Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Cylindrella','','cyclostoma','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08414','','','Turbo cyclostomoides Fried. Roemer, 1850',1,'Turbo cyclostomoides','Turbo cyclostomoides','Turbo cyclostomoid',2,0,'','','Fried. Roemer','5e9c4801-1e92-5dac-8efa-5b372d5b669c','Turbo cyclostomoides Fried. Roemer, 1850','Fried. Roemer, 1850','UNRANKED','','Turbo','','cyclostomoides','','','',NULL,'','','','','','Fried. Roemer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08419','','','Rotella cyclotrema Ryckholt, 1860',1,'Rotella cyclotrema','Rotella cyclotrema','Rotella cyclotrem',2,0,'','','Ryckholt','b808553e-e9eb-5e74-9c17-69d3146d4ac7','Rotella cyclotrema Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Rotella','','cyclotrema','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08425','','','Fusus cygneus Philippi, 1851',1,'Fusus cygneus','Fusus cygneus','Fusus cygne',2,0,'','','Philippi','52b3dc4f-dcc4-582f-b6ed-2e80f2c9434a','Fusus cygneus Philippi, 1851','Philippi, 1851','UNRANKED','','Fusus','','cygneus','','','',NULL,'','','','','','Philippi','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08430','','','Bithinia cylindracea Deshayes, 1862',1,'Bithinia cylindracea','Bithinia cylindracea','Bithinia cylindrace',2,0,'','','Deshayes','edcd3f89-fa89-5e10-89aa-95781fd1a462','Bithinia cylindracea Deshayes, 1862','Deshayes, 1862','UNRANKED','','Bithinia','','cylindracea','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08435','','','Trypanostoma cylindraceum Lea, 1864',1,'Trypanostoma cylindraceum','Trypanostoma cylindraceum','Trypanostoma cylindrace',2,0,'','','Lea','8828526a-c81a-5bf4-acb1-63fd76aee43b','Trypanostoma cylindraceum Lea, 1864','Lea, 1864','UNRANKED','','Trypanostoma','','cylindraceum','','','',NULL,'','','','','','Lea','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08436','','','Actaeon cylindraceus J. Muller, 1851',1,'Actaeon cylindraceus','Actaeon cylindraceus','Actaeon cylindrace',2,0,'','','J. Muller','6b17ac87-7372-5920-b656-cc1dcec606aa','Actaeon cylindraceus J. Muller, 1851','J. Muller, 1851','UNRANKED','','Actaeon','','cylindraceus','','','',NULL,'','','','','','J. Muller','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08441','','','Achatina cylindrella Morelet, 1851',1,'Achatina cylindrella','Achatina cylindrella','Achatina cylindrell',2,0,'','','Morelet','36d2df31-8938-5707-bc4c-53a396a3f4d2','Achatina cylindrella Morelet, 1851','Morelet, 1851','UNRANKED','','Achatina','','cylindrella','','','',NULL,'','','','','','Morelet','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08444','','','Syrnola cylindrella A. Adams, 1862',1,'Syrnola cylindrella','Syrnola cylindrella','Syrnola cylindrell',2,0,'','','A. Adams','7ccb1651-dfe7-5b3e-9a15-2a7298d459bb','Syrnola cylindrella A. Adams, 1862','A. Adams, 1862','UNRANKED','','Syrnola','','cylindrella','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08448','','','Gibbus (Gibbulina) cylindrellus H. Adams, 1868',1,'Gibbus cylindrellus','Gibbus cylindrellus','Gibbus cylindrell',2,0,'','','H. Adams','4a1c31f4-8b9f-5507-a245-4c1fe22f7f4b','Gibbus (Gibbulina) cylindrellus H. Adams, 1868','H. Adams, 1868','UNRANKED','','Gibbus','Gibbulina','cylindrellus','','','',NULL,'','','','','','H. Adams','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08454','','','Jeffreysia cylindrica Jeffreys, 1856',1,'Jeffreysia cylindrica','Jeffreysia cylindrica','Jeffreysia cylindric',2,0,'','','Jeffreys','625d4246-32a5-57b0-9cf7-9fb20a57e9d5','Jeffreysia cylindrica Jeffreys, 1856','Jeffreys, 1856','UNRANKED','','Jeffreysia','','cylindrica','','','',NULL,'','','','','','Jeffreys','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08463','','','Panopaea cylindrica Pictet and Campiche, 1864',1,'Panopaea cylindrica','Panopaea cylindrica','Panopaea cylindric',2,0,'','','Pictet|Campiche','cb3dc7c9-b97d-5c9c-805e-792e2c77b50a','Panopaea cylindrica Pictet and Campiche, 1864','Pictet and Campiche, 1864','UNRANKED','','Panopaea','','cylindrica','','','',NULL,'','','','','','Pictet & Campiche','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08469','','','Cerithium cylindricum C. Moore, 1861',1,'Cerithium cylindricum','Cerithium cylindricum','Cerithium cylindric',2,0,'','','C. Moore','8d842d46-53a8-5537-926b-90e8000c36f6','Cerithium cylindricum C. Moore, 1861','C. Moore, 1861','UNRANKED','','Cerithium','','cylindricum','','','',NULL,'','','','','','C. Moore','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08475','','','Triphoris cylindricus Pease, 1870',1,'Triphoris cylindricus','Triphoris cylindricus','Triphoris cylindric',2,0,'','','Pease','05cbec56-5e64-5ce1-8d1e-f401a98955f8','Triphoris cylindricus Pease, 1870','Pease, 1870','UNRANKED','','Triphoris','','cylindricus','','','',NULL,'','','','','','Pease','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08477','','','Pupa secale cylindroides A. Moquin-Tandon, 1855',1,'Pupa secale cylindroides','Pupa secale cylindroides','Pupa secal cylindroid',3,0,'','','A. Moquin-Tandon','d869c3e7-74f5-57e0-a8c1-6e851fc3ef53','Pupa secale cylindroides A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Pupa','','secale','cylindroides','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08483','','','Helix cymatium Benson, in Pfeiffer, 1856',2,'Helix cymatium','Helix cymatium','Helix cymati',2,0,'','','Benson|Pfeiffer','53620f22-bdde-56a9-b6cf-31ac68bf839a','Helix cymatium Benson, in Pfeiffer, 1856','Benson, in Pfeiffer, 1856','UNRANKED','','Helix','','cymatium','','','',NULL,'','','','','','Benson','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08492','','','Platyceras cymbium Hall, 1862',1,'Platyceras cymbium','Platyceras cymbium','Platyceras cymbi',2,0,'','','Hall','c95f5c3a-1c95-57ba-93bc-2b4a5aa5d5ca','Platyceras cymbium Hall, 1862','Hall, 1862','UNRANKED','','Platyceras','','cymbium','','','',NULL,'','','','','','Hall','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08496','','','Helix cymodoce Crosse, 1869',1,'Helix cymodoce','Helix cymodoce','Helix cymodoc',2,0,'','','Crosse','50fe9d80-32b1-5cd1-b571-971a82dcf42c','Helix cymodoce Crosse, 1869','Crosse, 1869','UNRANKED','','Helix','','cymodoce','','','',NULL,'','','','','','Crosse','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08503','','','Bulla (Bullea) cypraeola Menke, 1853',1,'Bulla cypraeola','Bulla cypraeola','Bulla cypraeol',2,0,'','','Menke','d3698f0d-c7bc-53d6-9200-ddde7b9c1ada','Bulla (Bullea) cypraeola Menke, 1853','Menke, 1853','UNRANKED','','Bulla','Bullea','cypraeola','','','',NULL,'','','','','','Menke','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08509','','','Trochus cypris Orbigny, 1852',1,'Trochus cypris','Trochus cypris','Trochus cypr',2,0,'','','Orbigny','95478b33-488e-5cff-8b3a-aa919654532b','Trochus cypris Orbigny, 1852','Orbigny, 1852','UNRANKED','','Trochus','','cypris','','','',NULL,'','','','','','Orbigny','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08517','','','Krynickillus cyrniacus Mabille, 1868',1,'Krynickillus cyrniacus','Krynickillus cyrniacus','Krynickillus cyrniac',2,0,'','','Mabille','9b182441-4557-5be8-838a-c82167562939','Krynickillus cyrniacus Mabille, 1868','Mabille, 1868','UNRANKED','','Krynickillus','','cyrniacus','','','',NULL,'','','','','','Mabille','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08527','','','Helix cysis Benson, 1852',1,'Helix cysis','Helix cysis','Helix cys',2,0,'','','Benson','f0615b4f-4332-547b-b92f-d48eeb5d5619','Helix cysis Benson, 1852','Benson, 1852','UNRANKED','','Helix','','cysis','','','',NULL,'','','','','','Benson','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08532','','','Cyrena (Corbicula) cytheriformis Meek and Hayden, 1860',1,'Cyrena cytheriformis','Cyrena cytheriformis','Cyrena cytheriform',2,0,'','','Meek|Hayden','4cf87353-40ab-5644-9ec9-065eb11d12f1','Cyrena (Corbicula) cytheriformis Meek and Hayden, 1860','Meek and Hayden, 1860','UNRANKED','','Cyrena','Corbicula','cytheriformis','','','',NULL,'','','','','','Meek & Hayden','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08535','','','Limax aniiquor czernaevii Kaleniczenko, 1851',1,'Limax aniiquor czernaevii','Limax aniiquor czernaevii','Limax aniiquor czernaeu',3,0,'','','Kaleniczenko','d8225a89-1367-5553-ae4c-a5b57b8d05a1','Limax aniiquor czernaevii Kaleniczenko, 1851','Kaleniczenko, 1851','UNRANKED','','Limax','','aniiquor','czernaevii','','',NULL,'','','','','','Kaleniczenko','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08542','','','Rissoa dactyliosa Deshayes, 1861',1,'Rissoa dactyliosa','Rissoa dactyliosa','Rissoa dactylios',2,0,'','','Deshayes','b1406986-92f0-5c52-9137-680345e47171','Rissoa dactyliosa Deshayes, 1861','Deshayes, 1861','UNRANKED','','Rissoa','','dactyliosa','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08549','','','Pupa dadion Benson, 1864',1,'Pupa dadion','Pupa dadion','Pupa dadion',2,0,'','','Benson','24ab1258-9468-5837-a1f6-01e102e247d3','Pupa dadion Benson, 1864','Benson, 1864','UNRANKED','','Pupa','','dadion','','','',NULL,'','','','','','Benson','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08551','','','Microstelma daedala A. Adams, 1863',1,'Microstelma daedala','Microstelma daedala','Microstelma daedal',2,0,'','','A. Adams','5e4f6ab7-61cf-562e-9d6a-6b0aad1e5498','Microstelma daedala A. Adams, 1863','A. Adams, 1863','UNRANKED','','Microstelma','','daedala','','','',NULL,'','','','','','A. Adams','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08556','','','Helix pachystyla daemelii Martens, 1869',1,'Helix pachystyla daemelii','Helix pachystyla daemelii','Helix pachystyl daemel',3,0,'','','Martens','2249da8c-148a-5a55-94e9-2e86ce8e1b32','Helix pachystyla daemelii Martens, 1869','Martens, 1869','UNRANKED','','Helix','','pachystyla','daemelii','','',NULL,'','','','','','Martens','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08560','','','Unio dahuricus Middendorff, 1851',1,'Unio dahuricus','Unio dahuricus','Unio dahuric',2,0,'','','Middendorff','a5aa38fe-dabf-597f-b7ff-9205adbb0b91','Unio dahuricus Middendorff, 1851','Middendorff, 1851','UNRANKED','','Unio','','dahuricus','','','',NULL,'','','','','','Middendorff','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08564','','','Pholas dallasii Walker, 1866',1,'Pholas dallasii','Pholas dallasii','Pholas dallas',2,0,'','','Walker','f2f166ac-7b03-524d-a4ff-0e9baa6947e3','Pholas dallasii Walker, 1866','Walker, 1866','UNRANKED','','Pholas','','dallasii','','','',NULL,'','','','','','Walker','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08566','','','Pomatias dalmatinus Parreyss, in Pfeiffer, 1863',2,'Pomatias dalmatinus','Pomatias dalmatinus','Pomatias dalmatin',2,0,'','','Parreyss|Pfeiffer','5ce7b151-6178-552f-8c7b-bc1e3ca372ff','Pomatias dalmatinus Parreyss, in Pfeiffer, 1863','Parreyss, in Pfeiffer, 1863','UNRANKED','','Pomatias','','dalmatinus','','','',NULL,'','','','','','Parreyss','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08572','','','Unio damascensis Lea, 1863',1,'Unio damascensis','Unio damascensis','Unio damascens',2,0,'','','Lea','771dbb7c-afd6-5b5e-a66b-ddf50f77db0c','Unio damascensis Lea, 1863','Lea, 1863','UNRANKED','','Unio','','damascensis','','','',NULL,'','','','','','Lea','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08576','','','Solarium dameriacense Deshayes, 1863',1,'Solarium dameriacense','Solarium dameriacense','Solarium dameriacens',2,0,'','','Deshayes','1fce00d3-72d2-5afc-bfae-6a90d478043e','Solarium dameriacense Deshayes, 1863','Deshayes, 1863','UNRANKED','','Solarium','','dameriacense','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08578','','','Natica dameriacensis Deshayes, 1864',1,'Natica dameriacensis','Natica dameriacensis','Natica dameriacens',2,0,'','','Deshayes','c5cc9b22-8e04-52d4-b1bc-e037afb76d62','Natica dameriacensis Deshayes, 1864','Deshayes, 1864','UNRANKED','','Natica','','dameriacensis','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08585','','','Trochus dammariensis Buvignier, 1852',1,'Trochus dammariensis','Trochus dammariensis','Trochus dammariens',2,0,'','','Buvignier','e79bafbe-1968-571b-847d-1f2196aab0da','Trochus dammariensis Buvignier, 1852','Buvignier, 1852','UNRANKED','','Trochus','','dammariensis','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08589','','','Melania damonis Brot, 1868',1,'Melania damonis','Melania damonis','Melania damon',2,0,'','','Brot','9338ee25-b6ee-5d42-9348-aa91dd530b06','Melania damonis Brot, 1868','Brot, 1868','UNRANKED','','Melania','','damonis','','','',NULL,'','','','','','Brot','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08592','','','Holopea danai Hall, 1859',1,'Holopea danai','Holopea danai','Holopea dana',2,0,'','','Hall','007f0caa-d28c-56cb-9e96-9ddfd61799db','Holopea danai Hall, 1859','Hall, 1859','UNRANKED','','Holopea','','danai','','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08599','','','Anodonta danielsii Lea, 1858',1,'Anodonta danielsii','Anodonta danielsii','Anodonta daniels',2,0,'','','Lea','841ba47c-c439-50bf-9e29-f9067a16276b','Anodonta danielsii Lea, 1858','Lea, 1858','UNRANKED','','Anodonta','','danielsii','','','',NULL,'','','','','','Lea','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08602','','','Pleurotoma danjouxii Baudon, 1853',1,'Pleurotoma danjouxii','Pleurotoma danjouxii','Pleurotoma danioux',2,0,'','','Baudon','da572b39-a33c-5271-baa2-96a589eaff05','Pleurotoma danjouxii Baudon, 1853','Baudon, 1853','UNRANKED','','Pleurotoma','','danjouxii','','','',NULL,'','','','','','Baudon','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08607','','','Vivipara danubialis Bourguignat, 1870',1,'Vivipara danubialis','Vivipara danubialis','Vivipara danubial',2,0,'','','Bourguignat','cbbc0d11-0c40-5e11-a6ad-9ed3ac72d91c','Vivipara danubialis Bourguignat, 1870','Bourguignat, 1870','UNRANKED','','Vivipara','','danubialis','','','',NULL,'','','','','','Bourguignat','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08614','','','Subulites daphne Billings, 1865',1,'Subulites daphne','Subulites daphne','Subulites daphn',2,0,'','','Billings','83e708bb-1f3a-5461-b08e-299af9d89c87','Subulites daphne Billings, 1865','Billings, 1865','UNRANKED','','Subulites','','daphne','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08617','','','Tellina dariena Conrad, 1855',1,'Tellina dariena','Tellina dariena','Tellina darien',2,0,'','','Conrad','50890595-2284-5176-beca-bf35f50d1723','Tellina dariena Conrad, 1855','Conrad, 1855','UNRANKED','','Tellina','','dariena','','','',NULL,'','','','','','Conrad','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08622','','','Vitrina darnaudi Pfeiffer, 1856',1,'Vitrina darnaudi','Vitrina darnaudi','Vitrina darnaud',2,0,'','','Pfeiffer','09b2a37d-f2f0-5f30-9aa3-79432007a087','Vitrina darnaudi Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Vitrina','','darnaudi','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08627','','','Cardium darwini Mayer, 1866',1,'Cardium darwini','Cardium darwini','Cardium darwin',2,0,'','','Mayer','dadd1ccf-ffb1-5b85-86fb-2012a17b8548','Cardium darwini Mayer, 1866','Mayer, 1866','UNRANKED','','Cardium','','darwini','','','',NULL,'','','','','','Mayer','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08633','','','Unio datus Lea, 1868',1,'Unio datus','Unio datus','Unio dat',2,0,'','','Lea','b75c05b0-4e54-563a-8d7a-a6470dc3d976','Unio datus Lea, 1868','Lea, 1868','UNRANKED','','Unio','','datus','','','',NULL,'','','','','','Lea','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08639','','','Cyclostoma daudinoti Gundlach, in Pfeiffer, 1859',2,'Cyclostoma daudinoti','Cyclostoma daudinoti','Cyclostoma daudinot',2,0,'','','Gundlach|Pfeiffer','f19ccf9c-59b1-597c-9d19-e6d5c38defbb','Cyclostoma daudinoti Gundlach, in Pfeiffer, 1859','Gundlach, in Pfeiffer, 1859','UNRANKED','','Cyclostoma','','daudinoti','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08646','','','Helix davidiana Bourguignat, 1863',1,'Helix davidiana','Helix davidiana','Helix dauidian',2,0,'','','Bourguignat','b4c21227-89c2-5382-b82f-af10dd410753','Helix davidiana Bourguignat, 1863','Bourguignat, 1863','UNRANKED','','Helix','','davidiana','','','',NULL,'','','','','','Bourguignat','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08653','','','Turbo davidsoni Laube, 1866',1,'Turbo davidsoni','Turbo davidsoni','Turbo dauidson',2,0,'','','Laube','82400808-c25f-5a1e-82d4-d4f2d1186904','Turbo davidsoni Laube, 1866','Laube, 1866','UNRANKED','','Turbo','','davidsoni','','','',NULL,'','','','','','Laube','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08661','','','Lima davoustiana Cotteau, 1855',1,'Lima davoustiana','Lima davoustiana','Lima dauoustian',2,0,'','','Cotteau','916d458e-7179-55b9-bcbc-20aaeaf3f74a','Lima davoustiana Cotteau, 1855','Cotteau, 1855','UNRANKED','','Lima','','davoustiana','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08663','','','Pholadomia davreuxi Chapuis and Dewalque, 1853',1,'Pholadomia davreuxi','Pholadomia davreuxi','Pholadomia daureux',2,0,'','','Chapuis|Dewalque','b564c7cb-097c-5a3d-aff0-5ed130f68293','Pholadomia davreuxi Chapuis and Dewalque, 1853','Chapuis and Dewalque, 1853','UNRANKED','','Pholadomia','','davreuxi','','','',NULL,'','','','','','Chapuis & Dewalque','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08676','','','Cerithium debile Zekeli, 1852',1,'Cerithium debile','Cerithium debile','Cerithium debil',2,0,'','','Zekeli','4c01df30-fb5a-5587-b70b-81962f2ab0c9','Cerithium debile Zekeli, 1852','Zekeli, 1852','UNRANKED','','Cerithium','','debile','','','',NULL,'','','','','','Zekeli','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08681','','','Eulima debilis A. Adams, 1861',1,'Eulima debilis','Eulima debilis','Eulima debil',2,0,'','','A. Adams','335a5176-0959-5b00-938d-98d3190158f2','Eulima debilis A. Adams, 1861','A. Adams, 1861','UNRANKED','','Eulima','','debilis','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08686','','','Psammobia debilis Deshayes, 1857',1,'Psammobia debilis','Psammobia debilis','Psammobia debil',2,0,'','','Deshayes','ba80a1b4-9dba-596c-b40c-5cc69e674432','Psammobia debilis Deshayes, 1857','Deshayes, 1857','UNRANKED','','Psammobia','','debilis','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08687','','','Sigaretus debilis Gould, 1853',1,'Sigaretus debilis','Sigaretus debilis','Sigaretus debil',2,0,'','','Gould','65458e04-825e-507d-b60e-1745694248bf','Sigaretus debilis Gould, 1853','Gould, 1853','UNRANKED','','Sigaretus','','debilis','','','',NULL,'','','','','','Gould','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08692','','','Cyclotus deburghaenus Chitty, 1857',1,'Cyclotus deburghaenus','Cyclotus deburghaenus','Cyclotus deburghaen',2,0,'','','Chitty','a27d2506-bfeb-54f1-b80b-e3260a17ac0f','Cyclotus deburghaenus Chitty, 1857','Chitty, 1857','UNRANKED','','Cyclotus','','deburghaenus','','','',NULL,'','','','','','Chitty','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08693','','','Marginella deburghi A. Adams, 1863',1,'Marginella deburghi','Marginella deburghi','Marginella deburgh',2,0,'','','A. Adams','9cb6f06e-e38a-5116-8c3b-5657b4e8550c','Marginella deburghi A. Adams, 1863','A. Adams, 1863','UNRANKED','','Marginella','','deburghi','','','',NULL,'','','','','','A. Adams','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08698','','','Helix decagyra Philippi, 1869',1,'Helix decagyra','Helix decagyra','Helix decagyr',2,0,'','','Philippi','2bf2785c-736d-5458-8da8-0178c10ba0b0','Helix decagyra Philippi, 1869','Philippi, 1869','UNRANKED','','Helix','','decagyra','','','',NULL,'','','','','','Philippi','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08703','','','Paludina decapitata Anthony, 1860',1,'Paludina decapitata','Paludina decapitata','Paludina decapitat',2,0,'','','Anthony','98a39b24-0980-53c5-a0ef-5867cea2d5ef','Paludina decapitata Anthony, 1860','Anthony, 1860','UNRANKED','','Paludina','','decapitata','','','',NULL,'','','','','','Anthony','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08707','','','Gouldia decemnaria Conrad, 1869',1,'Gouldia decemnaria','Gouldia decemnaria','Gouldia decemnar',2,0,'','','Conrad','3f1fdc2b-fa4e-5e43-8650-01d30797d98c','Gouldia decemnaria Conrad, 1869','Conrad, 1869','UNRANKED','','Gouldia','','decemnaria','','','',NULL,'','','','','','Conrad','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08709','','','Achatinella decepta C.B. Adams, 1851',1,'Achatinella decepta','Achatinella decepta','Achatinella decept',2,0,'','','C. B. Adams','c1ac5db4-a7f4-57d3-9deb-2e6b00b7e15d','Achatinella decepta C.B. Adams, 1851','C.B. Adams, 1851','UNRANKED','','Achatinella','','decepta','','','',NULL,'','','','','','C. B. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08714','','','Cerithium decimate Ryckholt, 1862',1,'Cerithium decimate','Cerithium decimate','Cerithium decimat',2,0,'','','Ryckholt','c92bba02-d2ac-5b14-bc73-c0a4a667d3cb','Cerithium decimate Ryckholt, 1862','Ryckholt, 1862','UNRANKED','','Cerithium','','decimate','','','',NULL,'','','','','','Ryckholt','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08718','','','Cerithium decipiens Hebert and Eudes-Deslongchamps, 1860',1,'Cerithium decipiens','Cerithium decipiens','Cerithium decipiens',2,0,'','','Hebert|Eudes-Deslongchamps','1195568e-fdde-5ce1-b4b0-771e3b6339a2','Cerithium decipiens Hebert and Eudes-Deslongchamps, 1860','Hebert and Eudes-Deslongchamps, 1860','UNRANKED','','Cerithium','','decipiens','','','',NULL,'','','','','','Hebert & Eudes-Deslongchamps','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08723','','','Leptopoma decipiens Pfeiffer, 1861',1,'Leptopoma decipiens','Leptopoma decipiens','Leptopoma decipiens',2,0,'','','Pfeiffer','4c8dc923-2128-541d-a315-45ac7dc805c2','Leptopoma decipiens Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Leptopoma','','decipiens','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08727','','','Pleurotoma decipiens Deshayes, 1865',1,'Pleurotoma decipiens','Pleurotoma decipiens','Pleurotoma decipiens',2,0,'','','Deshayes','63a7916f-3f82-57b8-b117-4ba0bba4e2e9','Pleurotoma decipiens Deshayes, 1865','Deshayes, 1865','UNRANKED','','Pleurotoma','','decipiens','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08732','','','Streptaxis decipiens Crosse, 1865',1,'Streptaxis decipiens','Streptaxis decipiens','Streptaxis decipiens',2,0,'','','Crosse','640c34b3-ce2f-52ac-8a1e-83db55f8bd10','Streptaxis decipiens Crosse, 1865','Crosse, 1865','UNRANKED','','Streptaxis','','decipiens','','','',NULL,'','','','','','Crosse','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08733','','','Trochus decipiens Guppy, 1867',1,'Trochus decipiens','Trochus decipiens','Trochus decipiens',2,0,'','','Guppy','603936d5-2d31-5aa5-b226-81695af9c6dc','Trochus decipiens Guppy, 1867','Guppy, 1867','UNRANKED','','Trochus','','decipiens','','','',NULL,'','','','','','Guppy','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08738','','','Hydrobia declinata Frauenfeld, 1863',1,'Hydrobia declinata','Hydrobia declinata','Hydrobia declinat',2,0,'','','Frauenfeld','6a3b2405-a8a0-54ed-bba2-c59c93e240c4','Hydrobia declinata Frauenfeld, 1863','Frauenfeld, 1863','UNRANKED','','Hydrobia','','declinata','','','',NULL,'','','','','','Frauenfeld','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08739','','','Forskalia declivior Ryckholt, 1862',1,'Forskalia declivior','Forskalia declivior','Forskalia decliuior',2,0,'','','Ryckholt','3fba2fb9-f36e-596d-a700-6e4bcabdef67','Forskalia declivior Ryckholt, 1862','Ryckholt, 1862','UNRANKED','','Forskalia','','declivior','','','',NULL,'','','','','','Ryckholt','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08744','','','Helicina declivis Gundlach, in Pfeiffer and Gundlach, 1860',2,'Helicina declivis','Helicina declivis','Helicina decliu',2,0,'','','Gundlach|Pfeiffer','26ca243f-b2a3-5cc3-9e30-2a930f6b399e','Helicina declivis Gundlach, in Pfeiffer and Gundlach, 1860','Gundlach, in Pfeiffer and Gundlach, 1860','UNRANKED','','Helicina','','declivis','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08750','','','Tapes declivis G. Sowerby, 1852',1,'Tapes declivis','Tapes declivis','Tapes decliu',2,0,'','','G. Sowerby','cdf8ec2e-4485-5b1c-948e-54872911202c','Tapes declivis G. Sowerby, 1852','G. Sowerby, 1852','UNRANKED','','Tapes','','declivis','','','',NULL,'','','','','','G. Sowerby','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08754','','','Cleodora decluciana Rang, in Rang and Souleyet, 1852',2,'Cleodora decluciana','Cleodora decluciana','Cleodora declucian',2,0,'','','Rang|Souleyet','f1ab2d6f-5061-52d9-97d2-fa9e3bb793e5','Cleodora decluciana Rang, in Rang and Souleyet, 1852','Rang, in Rang and Souleyet, 1852','UNRANKED','','Cleodora','','decluciana','','','',NULL,'','','','','','Rang','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08762','','','Valvata decollata Hislop, 1860',1,'Valvata decollata','Valvata decollata','Valvata decollat',2,0,'','','Hislop','a5b77f3f-11aa-5202-b1fc-2dbe8ef46172','Valvata decollata Hislop, 1860','Hislop, 1860','UNRANKED','','Valvata','','decollata','','','',NULL,'','','','','','Hislop','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08767','','','Cyclostoma decoloratum Gundlach, in Pfeiffer, 1859',2,'Cyclostoma decoloratum','Cyclostoma decoloratum','Cyclostoma decolorat',2,0,'','','Gundlach|Pfeiffer','c57be285-5ebd-5eca-a176-e03309a8417a','Cyclostoma decoloratum Gundlach, in Pfeiffer, 1859','Gundlach, in Pfeiffer, 1859','UNRANKED','','Cyclostoma','','decoloratum','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08770','','','Leda decora A. Adams, 1856',1,'Leda decora','Leda decora','Leda decor',2,0,'','','A. Adams','6902d4a1-67ca-56b8-94da-e36b47729834','Leda decora A. Adams, 1856','A. Adams, 1856','UNRANKED','','Leda','','decora','','','',NULL,'','','','','','A. Adams','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08776','','','Crenella decorata A. Adams, 1862',1,'Crenella decorata','Crenella decorata','Crenella decorat',2,0,'','','A. Adams','5765261e-bcab-59d8-ad45-177a15c916f5','Crenella decorata A. Adams, 1862','A. Adams, 1862','UNRANKED','','Crenella','','decorata','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08783','','','Odostomia decorata Jeffreys, 1850',1,'Odostomia decorata','Odostomia decorata','Odostomia decorat',2,0,'','','Jeffreys','413425e6-7198-5dce-9860-ddfade9fdd86','Odostomia decorata Jeffreys, 1850','Jeffreys, 1850','UNRANKED','','Odostomia','','decorata','','','',NULL,'','','','','','Jeffreys','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08790','','','Cerithium decoratum C. Moore, 1861',1,'Cerithium decoratum','Cerithium decoratum','Cerithium decorat',2,0,'','','C. Moore','69141f20-f37b-5e82-86ed-f9eaed9c35dd','Cerithium decoratum C. Moore, 1861','C. Moore, 1861','UNRANKED','','Cerithium','','decoratum','','','',NULL,'','','','','','C. Moore','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08798','','','Unio decoratus Lea, 1852',1,'Unio decoratus','Unio decoratus','Unio decorat',2,0,'','','Lea','51c510fc-b249-55dd-b1df-0b32e1d0a9c0','Unio decoratus Lea, 1852','Lea, 1852','UNRANKED','','Unio','','decoratus','','','',NULL,'','','','','','Lea','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08804','','','Unio decumbens Lea, 1861',1,'Unio decumbens','Unio decumbens','Unio decumbens',2,0,'','','Lea','69530569-016b-5190-830e-d61fe54aa5b2','Unio decumbens Lea, 1861','Lea, 1861','UNRANKED','','Unio','','decumbens','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08811','','','Cypricardia decurtata Winkler, 1861',1,'Cypricardia decurtata','Cypricardia decurtata','Cypricardia decurtat',2,0,'','','Winkler','cd0fa6ce-c35a-5c38-b12e-698cedf0e98a','Cypricardia decurtata Winkler, 1861','Winkler, 1861','UNRANKED','','Cypricardia','','decurtata','','','',NULL,'','','','','','Winkler','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08817','','','Cassidula decussata H. Adams and A. Adams, 1854',1,'Cassidula decussata','Cassidula decussata','Cassidula decussat',2,0,'','','H. Adams|A. Adams','335aaf1c-3975-5e01-9798-f59c99706577','Cassidula decussata H. Adams and A. Adams, 1854','H. Adams and A. Adams, 1854','UNRANKED','','Cassidula','','decussata','','','',NULL,'','','','','','H. Adams & A. Adams','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08823','','','Emarginula (Tugali) decussata A. Adams, 1851',1,'Emarginula decussata','Emarginula decussata','Emarginula decussat',2,0,'','','A. Adams','01f27b03-bc47-5c0a-945a-bdff20427caf','Emarginula (Tugali) decussata A. Adams, 1851','A. Adams, 1851','UNRANKED','','Emarginula','Tugali','decussata','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08826','','','Melania decussata Brot, 1862',1,'Melania decussata','Melania decussata','Melania decussat',2,0,'','','Brot','96bf7830-3ef7-5faf-b2c6-ae1440dfb4df','Melania decussata Brot, 1862','Brot, 1862','UNRANKED','','Melania','','decussata','','','',NULL,'','','','','','Brot','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08830','','','Myrtea decussata A. Adams, 1862',1,'Myrtea decussata','Myrtea decussata','Myrtea decussat',2,0,'','','A. Adams','33995736-54d8-599e-82f8-43e363263d87','Myrtea decussata A. Adams, 1862','A. Adams, 1862','UNRANKED','','Myrtea','','decussata','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08833','','','Pyrgulina decussata A. Adams, 1864',1,'Pyrgulina decussata','Pyrgulina decussata','Pyrgulina decussat',2,0,'','','A. Adams','e8a12e66-5a71-56c1-ae56-2971018498cc','Pyrgulina decussata A. Adams, 1864','A. Adams, 1864','UNRANKED','','Pyrgulina','','decussata','','','',NULL,'','','','','','A. Adams','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08840','','','Helix decussatula Pease, 1866',1,'Helix decussatula','Helix decussatula','Helix decussatul',2,0,'','','Pease','79ff5df9-5dfa-587f-bcba-3ae553e155f0','Helix decussatula Pease, 1866','Pease, 1866','UNRANKED','','Helix','','decussatula','','','',NULL,'','','','','','Pease','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08843','','','Adeorbis decussatus F. Sandberger, 1863',1,'Adeorbis decussatus','Adeorbis decussatus','Adeorbis decussat',2,0,'','','F. Sandberger','6cab6c2e-53af-5416-99e4-5a319d6b37d9','Adeorbis decussatus F. Sandberger, 1863','F. Sandberger, 1863','UNRANKED','','Adeorbis','','decussatus','','','',NULL,'','','','','','F. Sandberger','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08848','','','Leda deffneri Oppel, in Oppel and Suess, 1856',2,'Leda deffneri','Leda deffneri','Leda deffner',2,0,'','','Oppel|Suess','829756d2-030e-5e2e-ab09-57bc38bf116a','Leda deffneri Oppel, in Oppel and Suess, 1856','Oppel, in Oppel and Suess, 1856','UNRANKED','','Leda','','deffneri','','','',NULL,'','','','','','Oppel','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08856','','','Limnaea fusiformis deformis F. Edwards, 1852',1,'Limnaea fusiformis deformis','Limnaea fusiformis deformis','Limnaea fusiform deform',3,0,'','','F. Edwards','a8338801-bb60-598b-a2f5-1f11c034d63c','Limnaea fusiformis deformis F. Edwards, 1852','F. Edwards, 1852','UNRANKED','','Limnaea','','fusiformis','deformis','','',NULL,'','','','','','F. Edwards','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08862','','','Avicula defrancei Deshayes, 1858',1,'Avicula defrancei','Avicula defrancei','Avicula defrance',2,0,'','','Deshayes','1ff66a2e-0093-529b-a2a7-bc19c7b60333','Avicula defrancei Deshayes, 1858','Deshayes, 1858','UNRANKED','','Avicula','','defrancei','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08867','','','Gastrochaena defrancii Deshayes, 1856',1,'Gastrochaena defrancii','Gastrochaena defrancii','Gastrochaena defranc',2,0,'','','Deshayes','78f63901-d01c-5010-9662-d975836bbbc9','Gastrochaena defrancii Deshayes, 1856','Deshayes, 1856','UNRANKED','','Gastrochaena','','defrancii','','','',NULL,'','','','','','Deshayes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08871','','','Lutaria deickei Mayer, 1867',1,'Lutaria deickei','Lutaria deickei','Lutaria deicke',2,0,'','','Mayer','9b2f9f4e-9fa9-5f02-a191-279f6ce7abbd','Lutaria deickei Mayer, 1867','Mayer, 1867','UNRANKED','','Lutaria','','deickei','','','',NULL,'','','','','','Mayer','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08875','','','Helix (Trochomorpha) deiopeia Angas, 1869',1,'Helix deiopeia','Helix deiopeia','Helix deiope',2,0,'','','Angas','4da6cb48-d85f-54f9-89a8-de7fbe6bcf42','Helix (Trochomorpha) deiopeia Angas, 1869','Angas, 1869','UNRANKED','','Helix','Trochomorpha','deiopeia','','','',NULL,'','','','','','Angas','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08879','','','Cithara delacouriana Crosse, 1869',1,'Cithara delacouriana','Cithara delacouriana','Cithara delacourian',2,0,'','','Crosse','5d350a87-c92d-5f54-80ed-e579385434d1','Cithara delacouriana Crosse, 1869','Crosse, 1869','UNRANKED','','Cithara','','delacouriana','','','',NULL,'','','','','','Crosse','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08884','','','Helix epistylium delaminata C.B. Adams, 1851',1,'Helix epistylium delaminata','Helix epistylium delaminata','Helix epistyli delaminat',3,0,'','','C. B. Adams','a04c4a9f-a42e-5347-88f2-89c9d6ae9469','Helix epistylium delaminata C.B. Adams, 1851','C.B. Adams, 1851','UNRANKED','','Helix','','epistylium','delaminata','','',NULL,'','','','','','C. B. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08886','','','Bellerophon delanouei M. Rouault, 1851',1,'Bellerophon delanouei','Bellerophon delanouei','Bellerophon delanoue',2,0,'','','M. Rouault','c6dc0d77-a50c-5036-b10e-8fa3af031f6a','Bellerophon delanouei M. Rouault, 1851','M. Rouault, 1851','UNRANKED','','Bellerophon','','delanouei','','','',NULL,'','','','','','M. Rouault','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08896','','','Ostrea delbosi Michelotti, 1861',1,'Ostrea delbosi','Ostrea delbosi','Ostrea delbos',2,0,'','','Michelotti','1b93c409-95b7-5992-9574-8b8470397599','Ostrea delbosi Michelotti, 1861','Michelotti, 1861','UNRANKED','','Ostrea','','delbosi','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08901','','','Tellina delemontana Mayer, 1864',1,'Tellina delemontana','Tellina delemontana','Tellina delemontan',2,0,'','','Mayer','9e70b581-13ef-520b-b24b-dd1cbc26f7b8','Tellina delemontana Mayer, 1864','Mayer, 1864','UNRANKED','','Tellina','','delemontana','','','',NULL,'','','','','','Mayer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08903','','','Bulimus delesserti Bourguignat, 1852',1,'Bulimus delesserti','Bulimus delesserti','Bulimus delessert',2,0,'','','Bourguignat','c917b813-c6d9-56d4-a5c5-cc84f8d8b3db','Bulimus delesserti Bourguignat, 1852','Bourguignat, 1852','UNRANKED','','Bulimus','','delesserti','','','',NULL,'','','','','','Bourguignat','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08906','','','Glandina delesserti Bourguignat, 1852',1,'Glandina delesserti','Glandina delesserti','Glandina delessert',2,0,'','','Bourguignat','7c32fec2-3590-565b-b1dd-cdc4d20f1051','Glandina delesserti Bourguignat, 1852','Bourguignat, 1852','UNRANKED','','Glandina','','delesserti','','','',NULL,'','','','','','Bourguignat','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08909','','','Unio delesserti Bourguignat, 1852',1,'Unio delesserti','Unio delesserti','Unio delessert',2,0,'','','Bourguignat','2c6208e9-0eab-5421-b2b5-dc81b9682551','Unio delesserti Bourguignat, 1852','Bourguignat, 1852','UNRANKED','','Unio','','delesserti','','','',NULL,'','','','','','Bourguignat','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08914','','','Helix cespitum deleta A. Moquin-Tandon, 1855',1,'Helix cespitum deleta','Helix cespitum deleta','Helix cespit delet',3,0,'','','A. Moquin-Tandon','3bb2544b-0003-5dd0-8aff-f8ee8b78e3b4','Helix cespitum deleta A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','cespitum','deleta','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08918','','','Arca deletlrei Coquand, 1862',1,'Arca deletlrei','Arca deletlrei','Arca deletlre',2,0,'','','Coquand','51d10cf2-a718-5cf2-84c1-dc789061fbbc','Arca deletlrei Coquand, 1862','Coquand, 1862','UNRANKED','','Arca','','deletlrei','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08920','','','Avicula delettrei Coquand, 1862',1,'Avicula delettrei','Avicula delettrei','Avicula delettre',2,0,'','','Coquand','aa3e7576-7efe-5889-bf1f-c637f926bf80','Avicula delettrei Coquand, 1862','Coquand, 1862','UNRANKED','','Avicula','','delettrei','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08926','','','Pecten deletus Michelotti, 1861',1,'Pecten deletus','Pecten deletus','Pecten delet',2,0,'','','Michelotti','4bb3e373-be51-5c92-91db-e8b2215314a0','Pecten deletus Michelotti, 1861','Michelotti, 1861','UNRANKED','','Pecten','','deletus','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08932','','','Mitra delicata A. Adams, 1851',1,'Mitra delicata','Mitra delicata','Mitra delicat',2,0,'','','A. Adams','816b8a21-601a-5ff4-8074-67f95c13df97','Mitra delicata A. Adams, 1851','A. Adams, 1851','UNRANKED','','Mitra','','delicata','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08937','','','Pleurotomaria delicata Laube, 1868',1,'Pleurotomaria delicata','Pleurotomaria delicata','Pleurotomaria delicat',2,0,'','','Laube','b57ab39e-a4a0-54d5-a7a3-e482e74441a7','Pleurotomaria delicata Laube, 1868','Laube, 1868','UNRANKED','','Pleurotomaria','','delicata','','','',NULL,'','','','','','Laube','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08942','','','Cytherea delicatula Deshayes, 1857',1,'Cytherea delicatula','Cytherea delicatula','Cytherea delicatul',2,0,'','','Deshayes','304ee70f-ad5d-5477-afa6-e991de219ae9','Cytherea delicatula Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cytherea','','delicatula','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08946','','','Myrtea delicatula A. Adams, 1862',1,'Myrtea delicatula','Myrtea delicatula','Myrtea delicatul',2,0,'','','A. Adams','eb8a4e27-9cea-56eb-93cb-85267a06cc02','Myrtea delicatula A. Adams, 1862','A. Adams, 1862','UNRANKED','','Myrtea','','delicatula','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08954','','','Tornatina delicatula A. Adams, 1862',1,'Tornatina delicatula','Tornatina delicatula','Tornatina delicatul',2,0,'','','A. Adams','d104dbf8-e777-5976-abee-8e4b0c4f5eb2','Tornatina delicatula A. Adams, 1862','A. Adams, 1862','UNRANKED','','Tornatina','','delicatula','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08959','','','Macrodon delicatus Meek and Worthen, 1870',1,'Macrodon delicatus','Macrodon delicatus','Macrodon delicat',2,0,'','','Meek|Worthen','503b1b22-912d-5231-9041-d2f5533aa8e0','Macrodon delicatus Meek and Worthen, 1870','Meek and Worthen, 1870','UNRANKED','','Macrodon','','delicatus','','','',NULL,'','','','','','Meek & Worthen','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08963','','','Voluta deliciosa Montrouzier, 1859',1,'Voluta deliciosa','Voluta deliciosa','Voluta delicios',2,0,'','','Montrouzier','4bb80756-363b-53da-9e0e-5e76c05f0dd2','Voluta deliciosa Montrouzier, 1859','Montrouzier, 1859','UNRANKED','','Voluta','','deliciosa','','','',NULL,'','','','','','Montrouzier','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08972','','','Nautilus delphinus Forbes, 1856',1,'Nautilus delphinus','Nautilus delphinus','Nautilus delphin',2,0,'','','Forbes','71a28b5f-393c-57cf-ae34-0b422ff16441','Nautilus delphinus Forbes, 1856','Forbes, 1856','UNRANKED','','Nautilus','','delphinus','','','',NULL,'','','','','','Forbes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08975','','','Trochus delta Dumortier, 1869',1,'Trochus delta','Trochus delta','Trochus delt',2,0,'','','Dumortier','e46c0c23-f68c-52d1-a6a6-3781bcffe6c9','Trochus delta Dumortier, 1869','Dumortier, 1869','UNRANKED','','Trochus','','delta','','','',NULL,'','','','','','Dumortier','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08980','','','Neritina deltoidea Garrett, in Mousson, 1870',2,'Neritina deltoidea','Neritina deltoidea','Neritina deltoide',2,0,'','','Garrett|Mousson','cedeb6c9-26cd-5772-865a-b7d5e7ae1873','Neritina deltoidea Garrett, in Mousson, 1870','Garrett, in Mousson, 1870','UNRANKED','','Neritina','','deltoidea','','','',NULL,'','','','','','Garrett','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08985','','','Anomia delumbis Conrad, 1862',1,'Anomia delumbis','Anomia delumbis','Anomia delumb',2,0,'','','Conrad','cccdbba1-376d-5016-88e6-21940f4c4a8b','Anomia delumbis Conrad, 1862','Conrad, 1862','UNRANKED','','Anomia','','delumbis','','','',NULL,'','','','','','Conrad','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08987','','','Mactra deluta Gould, 1851',1,'Mactra deluta','Mactra deluta','Mactra delut',2,0,'','','Gould','302ddefa-29d4-5aca-b17d-1d9b28323a16','Mactra deluta Gould, 1851','Gould, 1851','UNRANKED','','Mactra','','deluta','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08992','','','Bulimus demerarensis Pfeiffer, 1861',1,'Bulimus demerarensis','Bulimus demerarensis','Bulimus demerarens',2,0,'','','Pfeiffer','5f895d1f-7b30-5949-ab37-3d2855e10084','Bulimus demerarensis Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Bulimus','','demerarensis','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_08997','','','Helix scabriuscula demissa Benoit, 1859',1,'Helix scabriuscula demissa','Helix scabriuscula demissa','Helix scabriuscul demiss',3,0,'','','Benoit','0de89021-cd72-5776-89b9-74d1bbf6d808','Helix scabriuscula demissa Benoit, 1859','Benoit, 1859','UNRANKED','','Helix','','scabriuscula','demissa','','',NULL,'','','','','','Benoit','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09000','','','Pholadomya demogetina Buvignier, 1852',1,'Pholadomya demogetina','Pholadomya demogetina','Pholadomya demogetin',2,0,'','','Buvignier','4b99516e-615c-5d7d-b60d-c188e7e0f2a3','Pholadomya demogetina Buvignier, 1852','Buvignier, 1852','UNRANKED','','Pholadomya','','demogetina','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09008','','','Bulimus denickei J. Gray and Reeve, 1851',1,'Bulimus denickei','Bulimus denickei','Bulimus denicke',2,0,'','','J. Gray|Reeve','25c1bda6-3ba9-500b-9906-3ebc5cc2eaa4','Bulimus denickei J. Gray and Reeve, 1851','J. Gray and Reeve, 1851','UNRANKED','','Bulimus','','denickei','','','',NULL,'','','','','','J. Gray & Reeve','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09015','','','Pseudachatina dennisoni Pfeiffer, 1857',1,'Pseudachatina dennisoni','Pseudachatina dennisoni','Pseudachatina dennison',2,0,'','','Pfeiffer','1f9f87bc-ecf2-5b61-b070-633433e9aa98','Pseudachatina dennisoni Pfeiffer, 1857','Pfeiffer, 1857','UNRANKED','','Pseudachatina','','dennisoni','','','',NULL,'','','','','','Pfeiffer','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09023','','','Dione densata Conrad, 1862',1,'Dione densata','Dione densata','Dione densat',2,0,'','','Conrad','ac316f9a-4040-5fe9-b6e3-ea019071c370','Dione densata Conrad, 1862','Conrad, 1862','UNRANKED','','Dione','','densata','','','',NULL,'','','','','','Conrad','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09026','','','Mulinia densata Conrad, 1856',1,'Mulinia densata','Mulinia densata','Mulinia densat',2,0,'','','Conrad','8c0cf03f-3ca6-50b2-bb7f-68812f08cf2a','Mulinia densata Conrad, 1856','Conrad, 1856','UNRANKED','','Mulinia','','densata','','','',NULL,'','','','','','Conrad','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09031','','','Strombus densatus Conrad, 1858',1,'Strombus densatus','Strombus densatus','Strombus densat',2,0,'','','Conrad','42d3ae25-802f-5a6f-bcb7-ae4a2b99b018','Strombus densatus Conrad, 1858','Conrad, 1858','UNRANKED','','Strombus','','densatus','','','',NULL,'','','','','','Conrad','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09033','','','Cucullaea densegranulata Lycett, 1850',1,'Cucullaea densegranulata','Cucullaea densegranulata','Cucullaea densegranulat',2,0,'','','Lycett','4fe4ff90-7f4f-5124-81b8-3f8992e4649d','Cucullaea densegranulata Lycett, 1850','Lycett, 1850','UNRANKED','','Cucullaea','','densegranulata','','','',NULL,'','','','','','Lycett','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09042','','','Nitidella densilineata P. Carpenter, 1864',1,'Nitidella densilineata','Nitidella densilineata','Nitidella densilineat',2,0,'','','P. Carpenter','ebb181be-0465-5f2c-a036-65becba404fd','Nitidella densilineata P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Nitidella','','densilineata','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09047','','','Platyceras (Orthonychia) dentalium Hall, 1862',1,'Platyceras dentalium','Platyceras dentalium','Platyceras dentali',2,0,'','','Hall','6e17fc22-4256-57d6-965d-7a0679ac1a15','Platyceras (Orthonychia) dentalium Hall, 1862','Hall, 1862','UNRANKED','','Platyceras','Orthonychia','dentalium','','','',NULL,'','','','','','Hall','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09052','','','Lima dentata Terquem, 1855',1,'Lima dentata','Lima dentata','Lima dentat',2,0,'','','Terquem','1525eb24-eb55-5394-b1e9-1ebf4cb021ee','Lima dentata Terquem, 1855','Terquem, 1855','UNRANKED','','Lima','','dentata','','','',NULL,'','','','','','Terquem','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09057','','','Chemnitzia denticulata Piette, 1855',1,'Chemnitzia denticulata','Chemnitzia denticulata','Chemnitzia denticulat',2,0,'','','Piette','390e7019-43f1-51d6-8683-0aab36cca91c','Chemnitzia denticulata Piette, 1855','Piette, 1855','UNRANKED','','Chemnitzia','','denticulata','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09058','','','Clausilia denticulata Reuss, 1860',1,'Clausilia denticulata','Clausilia denticulata','Clausilia denticulat',2,0,'','','Reuss','6f7a78d5-fca9-5204-91a1-e3c91ba4e438','Clausilia denticulata Reuss, 1860','Reuss, 1860','UNRANKED','','Clausilia','','denticulata','','','',NULL,'','','','','','Reuss','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09063','','','Gastrochaena denticulata Deshayes, 1854',1,'Gastrochaena denticulata','Gastrochaena denticulata','Gastrochaena denticulat',2,0,'','','Deshayes','93f4c66c-06ac-5604-b864-5d06423c29d0','Gastrochaena denticulata Deshayes, 1854','Deshayes, 1854','UNRANKED','','Gastrochaena','','denticulata','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09066','','','Nassa (Alectrion) denticulata A. Adams, 1851',1,'Nassa denticulata','Nassa denticulata','Nassa denticulat',2,0,'','','A. Adams','657a2c59-5910-5eb0-bb0f-7d19391d0414','Nassa (Alectrion) denticulata A. Adams, 1851','A. Adams, 1851','UNRANKED','','Nassa','Alectrion','denticulata','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09070','','','Tellina denticulata Deshayes, 1854',1,'Tellina denticulata','Tellina denticulata','Tellina denticulat',2,0,'','','Deshayes','af21f764-89ba-5d60-bcb0-98855801600d','Tellina denticulata Deshayes, 1854','Deshayes, 1854','UNRANKED','','Tellina','','denticulata','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09077','','','Erycina dentiens Deshayes, 1858',1,'Erycina dentiens','Erycina dentiens','Erycina dentiens',2,0,'','','Deshayes','70944676-2b3d-5914-9618-a45f66e877f3','Erycina dentiens Deshayes, 1858','Deshayes, 1858','UNRANKED','','Erycina','','dentiens','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09079','','','Vertigo muscorum dentiens A. Moquin-Tandon, 1855',1,'Vertigo muscorum dentiens','Vertigo muscorum dentiens','Vertigo muscor dentiens',3,0,'','','A. Moquin-Tandon','4af4cc65-66a3-5b2b-8c7b-66efea9beb53','Vertigo muscorum dentiens A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Vertigo','','muscorum','dentiens','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09086','','','Rostellaria dentilabrum Quenstedt, 1858',1,'Rostellaria dentilabrum','Rostellaria dentilabrum','Rostellaria dentilabr',2,0,'','','Quenstedt','a681e786-fec9-5149-bf6c-bd7e10e37377','Rostellaria dentilabrum Quenstedt, 1858','Quenstedt, 1858','UNRANKED','','Rostellaria','','dentilabrum','','','',NULL,'','','','','','Quenstedt','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09088','','','Bulimus dentritis Morelet, 1863',1,'Bulimus dentritis','Bulimus dentritis','Bulimus dentrit',2,0,'','','Morelet','0ec83645-d48c-5583-a249-05cb4bd894d8','Bulimus dentritis Morelet, 1863','Morelet, 1863','UNRANKED','','Bulimus','','dentritis','','','',NULL,'','','','','','Morelet','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09092','','','Pleurotoma denudata Deshayes, 1865',1,'Pleurotoma denudata','Pleurotoma denudata','Pleurotoma denudat',2,0,'','','Deshayes','3566e4e7-01c4-56e9-9194-488e1f05ae21','Pleurotoma denudata Deshayes, 1865','Deshayes, 1865','UNRANKED','','Pleurotoma','','denudata','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09097','','','Pecten denudatus Reuss, 1867',1,'Pecten denudatus','Pecten denudatus','Pecten denudat',2,0,'','','Reuss','7cc67c0f-1068-5305-b9a1-4a28aead8bf4','Pecten denudatus Reuss, 1867','Reuss, 1867','UNRANKED','','Pecten','','denudatus','','','',NULL,'','','','','','Reuss','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09100','','','Murex depauperatus Deshayes, 1865',1,'Murex depauperatus','Murex depauperatus','Murex depauperat',2,0,'','','Deshayes','74fc2ab1-bd81-5db4-bda2-74ecf269e79c','Murex depauperatus Deshayes, 1865','Deshayes, 1865','UNRANKED','','Murex','','depauperatus','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09105','','','Cerithium deperditum Deshayes, 1864',1,'Cerithium deperditum','Cerithium deperditum','Cerithium deperdit',2,0,'','','Deshayes','6b94fc7d-a870-559a-ba8b-2f2f7ac1752e','Cerithium deperditum Deshayes, 1864','Deshayes, 1864','UNRANKED','','Cerithium','','deperditum','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09106','','','Cerithium deperditum Michelotti, 1861',1,'Cerithium deperditum','Cerithium deperditum','Cerithium deperdit',2,0,'','','Michelotti','1740f6e3-d903-5d28-9b40-58e7206be189','Cerithium deperditum Michelotti, 1861','Michelotti, 1861','UNRANKED','','Cerithium','','deperditum','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09111','','','Macrocheilus depilis Koninck, 1863',1,'Macrocheilus depilis','Macrocheilus depilis','Macrocheilus depil',2,0,'','','Koninck','f4641421-ce71-5a86-9238-3d648b2e38d9','Macrocheilus depilis Koninck, 1863','Koninck, 1863','UNRANKED','','Macrocheilus','','depilis','','','',NULL,'','','','','','Koninck','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09113','','','Streptaxis deplanchei Drouet, 1859',1,'Streptaxis deplanchei','Streptaxis deplanchei','Streptaxis deplanche',2,0,'','','Drouet','64720d8e-801e-5454-9ff4-21129c70165f','Streptaxis deplanchei Drouet, 1859','Drouet, 1859','UNRANKED','','Streptaxis','','deplanchei','','','',NULL,'','','','','','Drouet','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09120','','','Ancillaria depressa G. Sowerby, 1859',1,'Ancillaria depressa','Ancillaria depressa','Ancillaria depress',2,0,'','','G. Sowerby','2a68d8d7-b4fd-5358-9902-a0047a5631b9','Ancillaria depressa G. Sowerby, 1859','G. Sowerby, 1859','UNRANKED','','Ancillaria','','depressa','','','',NULL,'','','','','','G. Sowerby','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09124','','','Campylaea coerulans depressa Zelebor, in Brusina, 1869',2,'Campylaea coerulans depressa','Campylaea coerulans depressa','Campylaea coerulans depress',3,0,'','','Zelebor|Brusina','69cd8b10-8bb4-5592-bae3-88d6b25292ab','Campylaea coerulans depressa Zelebor, in Brusina, 1869','Zelebor, in Brusina, 1869','UNRANKED','','Campylaea','','coerulans','depressa','','',NULL,'','','','','','Zelebor','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09130','','','Goniomya depressa C. Moore, 1870',1,'Goniomya depressa','Goniomya depressa','Goniomya depress',2,0,'','','C. Moore','7b34f53c-c261-5f82-954e-3659a74558cb','Goniomya depressa C. Moore, 1870','C. Moore, 1870','UNRANKED','','Goniomya','','depressa','','','',NULL,'','','','','','C. Moore','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09134','','','Helix desertorum depressa Martens, 1865',1,'Helix desertorum depressa','Helix desertorum depressa','Helix desertor depress',3,0,'','','Martens','b8e53ca4-05cf-5f3b-aef5-3d1026ef164a','Helix desertorum depressa Martens, 1865','Martens, 1865','UNRANKED','','Helix','','desertorum','depressa','','',NULL,'','','','','','Martens','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09136','','','Helix pisana depressa A. Moquin-Tandon, 1855',1,'Helix pisana depressa','Helix pisana depressa','Helix pisan depress',3,0,'','','A. Moquin-Tandon','976fa366-2615-51f8-acf3-b14e61668f75','Helix pisana depressa A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','pisana','depressa','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09145','','','Isoarca depressa Laube, 1866',1,'Isoarca depressa','Isoarca depressa','Isoarca depress',2,0,'','','Laube','ba509d26-263d-55d8-a5e2-6eb342337d72','Isoarca depressa Laube, 1866','Laube, 1866','UNRANKED','','Isoarca','','depressa','','','',NULL,'','','','','','Laube','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09147','','','Lacunella depressa Deshayes, 1861',1,'Lacunella depressa','Lacunella depressa','Lacunella depress',2,0,'','','Deshayes','19fa8105-8fc9-54d5-81d2-26929a6f503a','Lacunella depressa Deshayes, 1861','Deshayes, 1861','UNRANKED','','Lacunella','','depressa','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09151','','','Lucina borealis depressa Jeffreys, 1863',1,'Lucina borealis depressa','Lucina borealis depressa','Lucina boreal depress',3,0,'','','Jeffreys','30daf4e8-4c81-5495-8ce2-98acc44f0405','Lucina borealis depressa Jeffreys, 1863','Jeffreys, 1863','UNRANKED','','Lucina','','borealis','depressa','','',NULL,'','','','','','Jeffreys','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09154','','','Panopaea depressa J. Martin, 1863',1,'Panopaea depressa','Panopaea depressa','Panopaea depress',2,0,'','','J. Martin','2be13933-d968-544f-a95b-92aaaccb6c0b','Panopaea depressa J. Martin, 1863','J. Martin, 1863','UNRANKED','','Panopaea','','depressa','','','',NULL,'','','','','','J. Martin','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09161','','','Syndosmya depressa Deshayes, 1857',1,'Syndosmya depressa','Syndosmya depressa','Syndosmya depress',2,0,'','','Deshayes','4b5f4e8c-bf14-52ed-9e87-a457836d3f8a','Syndosmya depressa Deshayes, 1857','Deshayes, 1857','UNRANKED','','Syndosmya','','depressa','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09164','','','Zonites otthianus depressa Bourguignat, 1864',1,'Zonites otthianus depressa','Zonites otthianus depressa','Zonites otthian depress',3,0,'','','Bourguignat','cfb0bfbc-9ce9-58bd-b495-3e3156f4ada7','Zonites otthianus depressa Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Zonites','','otthianus','depressa','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09167','','','Lima depressicosta Pictet and Campiche, 1870',1,'Lima depressicosta','Lima depressicosta','Lima depressicost',2,0,'','','Pictet|Campiche','939d9ff6-9148-51e6-9d49-5d4345e2dc3b','Lima depressicosta Pictet and Campiche, 1870','Pictet and Campiche, 1870','UNRANKED','','Lima','','depressicosta','','','',NULL,'','','','','','Pictet & Campiche','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09175','','','Trochomorpha transarata depresso-striata Mousson, 1870',1,'Trochomorpha transarata depresso-striata','Trochomorpha transarata depresso-striata','Trochomorpha transarat depresso-striat',3,0,'','','Mousson','79976d5d-f519-5e02-ab40-23f09a9ca2e0','Trochomorpha transarata depresso-striata Mousson, 1870','Mousson, 1870','UNRANKED','','Trochomorpha','','transarata','depresso-striata','','',NULL,'','','','','','Mousson','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09177','','','Callopoma (Turbo) depressum Jluctuatum P. Carpenter, 1855',1,'Callopoma depressum','Callopoma depressum','Callopoma depress',2,0,'','','Jluctuatum P. Carpenter','d579c3ca-486c-5f3f-bc38-630f1e035b2b','Callopoma (Turbo) depressum Jluctuatum P. Carpenter, 1855','Jluctuatum P. Carpenter, 1855','UNRANKED','','Callopoma','Turbo','depressum','','','',NULL,'','','','','','Jluctuatum P. Carpenter','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09182','','','Umbonium depressum A. Adams, 1853',1,'Umbonium depressum','Umbonium depressum','Umbonium depress',2,0,'','','A. Adams','89605e70-ae89-5c59-a593-a883c2a736cb','Umbonium depressum A. Adams, 1853','A. Adams, 1853','UNRANKED','','Umbonium','','depressum','','','',NULL,'','','','','','A. Adams','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09184','','','Ancylus fluviatilis depressus Colbeau, 1859',1,'Ancylus fluviatilis depressus','Ancylus fluviatilis depressus','Ancylus fluuiatil depress',3,0,'','','Colbeau','42ca4aa5-6291-5d9f-846d-78d685e2a9bb','Ancylus fluviatilis depressus Colbeau, 1859','Colbeau, 1859','UNRANKED','','Ancylus','','fluviatilis','depressus','','',NULL,'','','','','','Colbeau','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09189','','','Mytilus depressus Deshayes, 1858',1,'Mytilus depressus','Mytilus depressus','Mytilus depress',2,0,'','','Deshayes','1e1b809b-1ba7-565e-95a0-8a9cccaef4ce','Mytilus depressus Deshayes, 1858','Deshayes, 1858','UNRANKED','','Mytilus','','depressus','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09195','','','Turbo depressus Hörnes, 1856',1,'Turbo depressus','Turbo depressus','Turbo depress',2,0,'','','Hörnes','4f6ed868-bdf4-5410-8185-e2ed512d2159','Turbo depressus Hörnes, 1856','Hörnes, 1856','UNRANKED','','Turbo','','depressus','','','',NULL,'','','','','','Hörnes','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09202','','','Turritella derbesi Coquand, 1862',1,'Turritella derbesi','Turritella derbesi','Turritella derbes',2,0,'','','Coquand','3534414d-46e3-58bd-b9d5-655914eecd85','Turritella derbesi Coquand, 1862','Coquand, 1862','UNRANKED','','Turritella','','derbesi','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09207','','','Nassa dermestina Gould, 1860',1,'Nassa dermestina','Nassa dermestina','Nassa dermestin',2,0,'','','Gould','84baf5b5-eff3-5f87-ba48-17c120ff0fb1','Nassa dermestina Gould, 1860','Gould, 1860','UNRANKED','','Nassa','','dermestina','','','',NULL,'','','','','','Gould','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09211','','','Turritella dertonensis Mayer, 1868',1,'Turritella dertonensis','Turritella dertonensis','Turritella dertonens',2,0,'','','Mayer','5a2bb565-3114-5a3a-947e-1bfaedd03aa9','Turritella dertonensis Mayer, 1868','Mayer, 1868','UNRANKED','','Turritella','','dertonensis','','','',NULL,'','','','','','Mayer','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09216','','','Cerithium descoudresi Speyer, 1867',1,'Cerithium descoudresi','Cerithium descoudresi','Cerithium descoudres',2,0,'','','Speyer','7e3edad7-3427-51f0-bd81-c1ed4c556e0d','Cerithium descoudresi Speyer, 1867','Speyer, 1867','UNRANKED','','Cerithium','','descoudresi','','','',NULL,'','','','','','Speyer','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09218','','','Pecten deserti Conrad, 1855',1,'Pecten deserti','Pecten deserti','Pecten desert',2,0,'','','Conrad','d302e74a-d816-5e5a-953b-85710c4f6213','Pecten deserti Conrad, 1855','Conrad, 1855','UNRANKED','','Pecten','','deserti','','','',NULL,'','','','','','Conrad','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09223','','','Trigonia deshayesana Mayer and Gümbel, in Gümbel, 1861',2,'Trigonia deshayesana','Trigonia deshayesana','Trigonia deshayesan',2,0,'','','Mayer|Gümbel','c29bb273-a9e9-5c99-8e25-0a8cefa74ae4','Trigonia deshayesana Mayer and Gümbel, in Gümbel, 1861','Mayer and Gümbel, in Gümbel, 1861','UNRANKED','','Trigonia','','deshayesana','','','',NULL,'','','','','','Mayer & Gümbel','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09230','','','Gastrochaena deshayesea Buvignier, 1852',1,'Gastrochaena deshayesea','Gastrochaena deshayesea','Gastrochaena deshayese',2,0,'','','Buvignier','2c0e76b6-9b0a-5297-a04d-17a86805b193','Gastrochaena deshayesea Buvignier, 1852','Buvignier, 1852','UNRANKED','','Gastrochaena','','deshayesea','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09233','','','Nerita deshayesea Buvignier, 1852',1,'Nerita deshayesea','Nerita deshayesea','Nerita deshayese',2,0,'','','Buvignier','52595b2c-29c2-5bab-9290-4e09a020ec51','Nerita deshayesea Buvignier, 1852','Buvignier, 1852','UNRANKED','','Nerita','','deshayesea','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09236','','','Rostellaria deshayesea Buvignier, 1852',1,'Rostellaria deshayesea','Rostellaria deshayesea','Rostellaria deshayese',2,0,'','','Buvignier','7b4029d8-2a90-5879-ace2-c12aa25154f0','Rostellaria deshayesea Buvignier, 1852','Buvignier, 1852','UNRANKED','','Rostellaria','','deshayesea','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09243','','','Bifrontia deshayesi Michaud, in Deshayes, 1861',2,'Bifrontia deshayesi','Bifrontia deshayesi','Bifrontia deshayes',2,0,'','','Michaud|Deshayes','9d695cb7-d82d-5e38-8076-f76863700fef','Bifrontia deshayesi Michaud, in Deshayes, 1861','Michaud, in Deshayes, 1861','UNRANKED','','Bifrontia','','deshayesi','','','',NULL,'','','','','','Michaud','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09250','','','Columbella deshayesi Folin, 1867',1,'Columbella deshayesi','Columbella deshayesi','Columbella deshayes',2,0,'','','Folin','b58ab84e-a658-50cd-bd97-01616f1513da','Columbella deshayesi Folin, 1867','Folin, 1867','UNRANKED','','Columbella','','deshayesi','','','',NULL,'','','','','','Folin','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09254','','','Cypricardia deshayesi Mayer, 1861',1,'Cypricardia deshayesi','Cypricardia deshayesi','Cypricardia deshayes',2,0,'','','Mayer','32234717-896a-5a75-bfb3-bb19a3817691','Cypricardia deshayesi Mayer, 1861','Mayer, 1861','UNRANKED','','Cypricardia','','deshayesi','','','',NULL,'','','','','','Mayer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09260','','','Lavignon deshayesii Recluz, 1869',1,'Lavignon deshayesii','Lavignon deshayesii','Lavignon deshayes',2,0,'','','Recluz','125388aa-5d5a-530b-b62f-8f36e28f8663','Lavignon deshayesii Recluz, 1869','Recluz, 1869','UNRANKED','','Lavignon','','deshayesii','','','',NULL,'','','','','','Recluz','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09267','','','Meioceras deshayesi Folin, 1869',1,'Meioceras deshayesi','Meioceras deshayesi','Meioceras deshayes',2,0,'','','Folin','056168bb-7268-5315-95cb-2dba7eb2f758','Meioceras deshayesi Folin, 1869','Folin, 1869','UNRANKED','','Meioceras','','deshayesi','','','',NULL,'','','','','','Folin','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09270','','','Neritina deshayesii Pease, 1868',1,'Neritina deshayesii','Neritina deshayesii','Neritina deshayes',2,0,'','','Pease','63228119-bdb8-5e33-967d-2605835e165e','Neritina deshayesii Pease, 1868','Pease, 1868','UNRANKED','','Neritina','','deshayesii','','','',NULL,'','','','','','Pease','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09275','','','Pholadomya deshayesi Chapuis and Dewalque, 1853',1,'Pholadomya deshayesi','Pholadomya deshayesi','Pholadomya deshayes',2,0,'','','Chapuis|Dewalque','e906ddf3-5198-540b-89bb-eda44443a6ea','Pholadomya deshayesi Chapuis and Dewalque, 1853','Chapuis and Dewalque, 1853','UNRANKED','','Pholadomya','','deshayesi','','','',NULL,'','','','','','Chapuis & Dewalque','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09283','','','Scalaria deshayesi Mayer, 1856',1,'Scalaria deshayesi','Scalaria deshayesi','Scalaria deshayes',2,0,'','','Mayer','dc148418-b8a6-5104-aff7-340950fb7736','Scalaria deshayesi Mayer, 1856','Mayer, 1856','UNRANKED','','Scalaria','','deshayesi','','','',NULL,'','','','','','Mayer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09287','','','Solen deshayesi Terquem, 1855',1,'Solen deshayesi','Solen deshayesi','Solen deshayes',2,0,'','','Terquem','e6cbd570-3e3b-5438-bd24-cfc88f397a8f','Solen deshayesi Terquem, 1855','Terquem, 1855','UNRANKED','','Solen','','deshayesi','','','',NULL,'','','','','','Terquem','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09289','','','Terebra deshayesii Reeve, 1860',1,'Terebra deshayesii','Terebra deshayesii','Terebra deshayes',2,0,'','','Reeve','23ffbd82-6849-5b62-a583-66d0d3de4ddf','Terebra deshayesii Reeve, 1860','Reeve, 1860','UNRANKED','','Terebra','','deshayesii','','','',NULL,'','','','','','Reeve','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09295','','','Turbonilla deshayesi Mayer, 1864',1,'Turbonilla deshayesi','Turbonilla deshayesi','Turbonilla deshayes',2,0,'','','Mayer','c500f036-7d8e-551a-bc3e-c64628a24815','Turbonilla deshayesi Mayer, 1864','Mayer, 1864','UNRANKED','','Turbonilla','','deshayesi','','','',NULL,'','','','','','Mayer','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09297','','','Voluta deshayesii Reeve, 1854',1,'Voluta deshayesii','Voluta deshayesii','Voluta deshayes',2,0,'','','Reeve','72d6a8d2-423e-5b4f-9487-803b13f2f8d1','Voluta deshayesii Reeve, 1854','Reeve, 1854','UNRANKED','','Voluta','','deshayesii','','','',NULL,'','','','','','Reeve','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09301','','','Cumingia deshayesiana Vaillant, 1865',1,'Cumingia deshayesiana','Cumingia deshayesiana','Cumingia deshayesian',2,0,'','','Vaillant','fb44115d-d15a-5dd9-bb0b-6e3ebdbf06ea','Cumingia deshayesiana Vaillant, 1865','Vaillant, 1865','UNRANKED','','Cumingia','','deshayesiana','','','',NULL,'','','','','','Vaillant','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09304','','','Dimya deshayesiana A. Rouault, 1850',1,'Dimya deshayesiana','Dimya deshayesiana','Dimya deshayesian',2,0,'','','A. Rouault','e8b22ab7-0bc7-5d50-b466-9d7e4ecbd7fe','Dimya deshayesiana A. Rouault, 1850','A. Rouault, 1850','UNRANKED','','Dimya','','deshayesiana','','','',NULL,'','','','','','A. Rouault','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09313','','','Verticordia deshayesiana Fischer, 1862',1,'Verticordia deshayesiana','Verticordia deshayesiana','Verticordia deshayesian',2,0,'','','Fischer','0a3433b1-4755-59cd-ae68-00abea4895b0','Verticordia deshayesiana Fischer, 1862','Fischer, 1862','UNRANKED','','Verticordia','','deshayesiana','','','',NULL,'','','','','','Fischer','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09315','','','Volutharpa deshayesiana Fischer, 1856',1,'Volutharpa deshayesiana','Volutharpa deshayesiana','Volutharpa deshayesian',2,0,'','','Fischer','c68cd154-07b4-555a-8384-4568bd5efde0','Volutharpa deshayesiana Fischer, 1856','Fischer, 1856','UNRANKED','','Volutharpa','','deshayesiana','','','',NULL,'','','','','','Fischer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09323','','','Helix desiderata Pfeiffer, in Hjalmarson and Pfeiffer, 1858',2,'Helix desiderata','Helix desiderata','Helix desiderat',2,0,'','','Pfeiffer|Hjalmarson','b96a5f6d-42b2-5955-afef-09cb590a54db','Helix desiderata Pfeiffer, in Hjalmarson and Pfeiffer, 1858','Pfeiffer, in Hjalmarson and Pfeiffer, 1858','UNRANKED','','Helix','','desiderata','','','',NULL,'','','','','','Pfeiffer','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09330','','','Lima deslongchampsi Stoliczka, 1861',1,'Lima deslongchampsi','Lima deslongchampsi','Lima deslongchamps',2,0,'','','Stoliczka','4da52d37-0d1b-5a62-a088-fbd305bd6dfa','Lima deslongchampsi Stoliczka, 1861','Stoliczka, 1861','UNRANKED','','Lima','','deslongchampsi','','','',NULL,'','','','','','Stoliczka','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09336','','','Trochus deslongchampsii C. Moore, 1867',1,'Trochus deslongchampsii','Trochus deslongchampsii','Trochus deslongchamps',2,0,'','','C. Moore','8a522c12-e317-56be-bd86-d2d65aa148a9','Trochus deslongchampsii C. Moore, 1867','C. Moore, 1867','UNRANKED','','Trochus','','deslongchampsii','','','',NULL,'','','','','','C. Moore','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09339','','','Fusus (Pisania) desmoulinsi Montrouzier, in Souverbie and Montrouzier, 1864',2,'Fusus desmoulinsi','Fusus desmoulinsi','Fusus desmoulins',2,0,'','','Montrouzier|Souverbie','a25161f6-2c7c-5b37-bd44-7cb8b73c5061','Fusus (Pisania) desmoulinsi Montrouzier, in Souverbie and Montrouzier, 1864','Montrouzier, in Souverbie and Montrouzier, 1864','UNRANKED','','Fusus','Pisania','desmoulinsi','','','',NULL,'','','','','','Montrouzier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09343','','','Pecten desmoulinsianus Cotteau, 1855',1,'Pecten desmoulinsianus','Pecten desmoulinsianus','Pecten desmoulinsian',2,0,'','','Cotteau','d05daf05-672f-5273-a24b-732c892f68b5','Pecten desmoulinsianus Cotteau, 1855','Cotteau, 1855','UNRANKED','','Pecten','','desmoulinsianus','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09348','','','Pterocera desori Pictet and Campiche, 1864',1,'Pterocera desori','Pterocera desori','Pterocera desor',2,0,'','','Pictet|Campiche','318491b9-831b-55ff-ba80-9142241858b6','Pterocera desori Pictet and Campiche, 1864','Pictet and Campiche, 1864','UNRANKED','','Pterocera','','desori','','','',NULL,'','','','','','Pictet & Campiche','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09352','','','Ditremaria desoriana Cotteau, 1854',1,'Ditremaria desoriana','Ditremaria desoriana','Ditremaria desorian',2,0,'','','Cotteau','dfb14d2f-8793-55d2-8417-8336b97f25ce','Ditremaria desoriana Cotteau, 1854','Cotteau, 1854','UNRANKED','','Ditremaria','','desoriana','','','',NULL,'','','','','','Cotteau','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09355','','','Cytherea despecta Deshayes, 1857',1,'Cytherea despecta','Cytherea despecta','Cytherea despect',2,0,'','','Deshayes','de5f31f3-9241-53fe-8021-dd25e9268201','Cytherea despecta Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cytherea','','despecta','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09360','','','Cerithium desplanchei Piette, 1857',1,'Cerithium desplanchei','Cerithium desplanchei','Cerithium desplanche',2,0,'','','Piette','1d352c8a-6700-5979-9d2b-887e490eab7a','Cerithium desplanchei Piette, 1857','Piette, 1857','UNRANKED','','Cerithium','','desplanchei','','','',NULL,'','','','','','Piette','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09363','','','Voluta desportesii Gueranger, 1853',1,'Voluta desportesii','Voluta desportesii','Voluta desportes',2,0,'','','Gueranger','9df3629c-3f08-5145-a152-9ad13bf4215a','Voluta desportesii Gueranger, 1853','Gueranger, 1853','UNRANKED','','Voluta','','desportesii','','','',NULL,'','','','','','Gueranger','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09367','','','Melania asavaensis desulcata Mousson, 1870',1,'Melania asavaensis desulcata','Melania asavaensis desulcata','Melania asauaens desulcat',3,0,'','','Mousson','434076d2-b176-5fcd-9e32-f22c38444450','Melania asavaensis desulcata Mousson, 1870','Mousson, 1870','UNRANKED','','Melania','','asavaensis','desulcata','','',NULL,'','','','','','Mousson','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09373','','','Nerinea desvoidyiformis Schauroth, 1865',1,'Nerinea desvoidyiformis','Nerinea desvoidyiformis','Nerinea desuoidyiform',2,0,'','','Schauroth','307414c4-25da-51c0-897e-afacf782cd1c','Nerinea desvoidyiformis Schauroth, 1865','Schauroth, 1865','UNRANKED','','Nerinea','','desvoidyiformis','','','',NULL,'','','','','','Schauroth','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09380','','','Patella detrita Bayan, 1870',1,'Patella detrita','Patella detrita','Patella detrit',2,0,'','','Bayan','57840e01-4673-58af-8d60-cb8d13895372','Patella detrita Bayan, 1870','Bayan, 1870','UNRANKED','','Patella','','detrita','','','',NULL,'','','','','','Bayan','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09383','','','Cyclas detruncata Prime, 1852',1,'Cyclas detruncata','Cyclas detruncata','Cyclas detruncat',2,0,'','','Prime','2f2be6d2-3a99-5ba2-bcfb-f8a4ac101990','Cyclas detruncata Prime, 1852','Prime, 1852','UNRANKED','','Cyclas','','detruncata','','','',NULL,'','','','','','Prime','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09386','','','Helix (Fruticicola) devexa Reuss, 1860',1,'Helix devexa','Helix devexa','Helix deuex',2,0,'','','Reuss','f0834aa1-e446-5f13-a755-2497219d9012','Helix (Fruticicola) devexa Reuss, 1860','Reuss, 1860','UNRANKED','','Helix','Fruticicola','devexa','','','',NULL,'','','','','','Reuss','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09391','','','Unio deviatus Anthony, in G. Sowerby, 1864',2,'Unio deviatus','Unio deviatus','Unio deuiat',2,0,'','','Anthony|G. Sowerby','ef9018a2-02da-5500-bd36-36dc1ccfa910','Unio deviatus Anthony, in G. Sowerby, 1864','Anthony, in G. Sowerby, 1864','UNRANKED','','Unio','','deviatus','','','',NULL,'','','','','','Anthony','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09398','','','Solemya devonica Ryckholt, 1852',1,'Solemya devonica','Solemya devonica','Solemya deuonic',2,0,'','','Ryckholt','3106101b-4981-573e-bd8e-68c7ccd5dcd8','Solemya devonica Ryckholt, 1852','Ryckholt, 1852','UNRANKED','','Solemya','','devonica','','','',NULL,'','','','','','Ryckholt','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09400','','','Acteonina dewalquei Oppel, 1856',1,'Acteonina dewalquei','Acteonina dewalquei','Acteonina dewalque',2,0,'','','Oppel','80ab3453-29f2-5c42-b64c-382f6e78a1de','Acteonina dewalquei Oppel, 1856','Oppel, 1856','UNRANKED','','Acteonina','','dewalquei','','','',NULL,'','','','','','Oppel','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09407','','','Cytherea deweyi Meek and Hayden, 1856',1,'Cytherea deweyi','Cytherea deweyi','Cytherea dewey',2,0,'','','Meek|Hayden','e476b527-b9a9-50c8-ada4-0ada78c2aee0','Cytherea deweyi Meek and Hayden, 1856','Meek and Hayden, 1856','UNRANKED','','Cytherea','','deweyi','','','',NULL,'','','','','','Meek & Hayden','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09412','','','Helix diabloensis J. Cooper, 1869',1,'Helix diabloensis','Helix diabloensis','Helix diabloens',2,0,'','','J. Cooper','1fef7b83-955c-537a-af13-5d0ab44bd49f','Helix diabloensis J. Cooper, 1869','J. Cooper, 1869','UNRANKED','','Helix','','diabloensis','','','',NULL,'','','','','','J. Cooper','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09417','','','Conus diadema F. Edwards, 1854',1,'Conus diadema','Conus diadema','Conus diadem',2,0,'','','F. Edwards','1d1c75e5-e243-5730-9584-6c5e88c8d494','Conus diadema F. Edwards, 1854','F. Edwards, 1854','UNRANKED','','Conus','','diadema','','','',NULL,'','','','','','F. Edwards','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09427','','','Turbo diadematus Dumortier, 1867',1,'Turbo diadematus','Turbo diadematus','Turbo diademat',2,0,'','','Dumortier','fca73899-41cf-53ad-a4f6-41b4d7c874cf','Turbo diadematus Dumortier, 1867','Dumortier, 1867','UNRANKED','','Turbo','','diadematus','','','',NULL,'','','','','','Dumortier','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09430','','','Actaeon dianae A. Adams, 1854',1,'Actaeon dianae','Actaeon dianae','Actaeon dian',2,0,'','','A. Adams','6af16f57-1db5-5ac7-8142-603b4d39b10a','Actaeon dianae A. Adams, 1854','A. Adams, 1854','UNRANKED','','Actaeon','','dianae','','','',NULL,'','','','','','A. Adams','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09437','','','Ebala diaphana A. Adams, 1861',1,'Ebala diaphana','Ebala diaphana','Ebala diaphan',2,0,'','','A. Adams','03563070-26c3-5788-bb58-95574a861224','Ebala diaphana A. Adams, 1861','A. Adams, 1861','UNRANKED','','Ebala','','diaphana','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09444','','','Physa diaphana Tyron, 1865',1,'Physa diaphana','Physa diaphana','Physa diaphan',2,0,'','','Tyron','59230a49-1317-589a-b616-2b0e93c70021','Physa diaphana Tyron, 1865','Tyron, 1865','UNRANKED','','Physa','','diaphana','','','',NULL,'','','','','','Tyron','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09448','','','Planorbis diaphanellus Bourguignat, 1864',1,'Planorbis diaphanellus','Planorbis diaphanellus','Planorbis diaphanell',2,0,'','','Bourguignat','a96ba542-7ce7-53f9-9698-11c6a6592189','Planorbis diaphanellus Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Planorbis','','diaphanellus','','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09456','','','Helix dibenedictiana Calcara, in Benoit, 1859',2,'Helix dibenedictiana','Helix dibenedictiana','Helix dibenedictian',2,0,'','','Calcara|Benoit','ee5b78de-0545-5312-90f7-b04e7882701d','Helix dibenedictiana Calcara, in Benoit, 1859','Calcara, in Benoit, 1859','UNRANKED','','Helix','','dibenedictiana','','','',NULL,'','','','','','Calcara','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09461','','','Chemnitzia dichotoma Herm. Credner, 1864',1,'Chemnitzia dichotoma','Chemnitzia dichotoma','Chemnitzia dichotom',2,0,'','','Herm. Credner','947e81ae-683b-5878-8a60-95205ed4ee67','Chemnitzia dichotoma Herm. Credner, 1864','Herm. Credner, 1864','UNRANKED','','Chemnitzia','','dichotoma','','','',NULL,'','','','','','Herm. Credner','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09465','','','Septifer dichotomus Gabb, 1864',1,'Septifer dichotomus','Septifer dichotomus','Septifer dichotom',2,0,'','','Gabb','7ed3fa2b-3ce6-5fab-80bf-6f9b3124905f','Septifer dichotomus Gabb, 1864','Gabb, 1864','UNRANKED','','Septifer','','dichotomus','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09468','','','Mitra dichroma A. Adams, 1851',1,'Mitra dichroma','Mitra dichroma','Mitra dichrom',2,0,'','','A. Adams','06e25c78-57f8-5bc0-9e3f-8a8378b9eb52','Mitra dichroma A. Adams, 1851','A. Adams, 1851','UNRANKED','','Mitra','','dichroma','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09476','','','Narica diegoana Conrad, 1855',1,'Narica diegoana','Narica diegoana','Narica diegoan',2,0,'','','Conrad','8a65d4f0-5247-58bc-ac07-e6e7593a4b35','Narica diegoana Conrad, 1855','Conrad, 1855','UNRANKED','','Narica','','diegoana','','','',NULL,'','','','','','Conrad','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09479','','','Solen (Solena) diegoensis Gabb, 1864',1,'Solen diegoensis','Solen diegoensis','Solen diegoens',2,0,'','','Gabb','6e4682e2-fba9-5ad8-b7a6-c1c3de1b2d33','Solen (Solena) diegoensis Gabb, 1864','Gabb, 1864','UNRANKED','','Solen','Solena','diegoensis','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09486','','','Cardium difficile Deshayes, 1858',1,'Cardium difficile','Cardium difficile','Cardium difficil',2,0,'','','Deshayes','20f5f05b-32ef-557d-ba0b-27a7c6531023','Cardium difficile Deshayes, 1858','Deshayes, 1858','UNRANKED','','Cardium','','difficile','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09487','','','Cardium difficile Michelotti, 1861',1,'Cardium difficile','Cardium difficile','Cardium difficil',2,0,'','','Michelotti','c4789e75-dfe4-5988-b6c3-771367142f1d','Cardium difficile Michelotti, 1861','Michelotti, 1861','UNRANKED','','Cardium','','difficile','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09492','','','Cyrena difficilis Deshayes, 1857',1,'Cyrena difficilis','Cyrena difficilis','Cyrena difficil',2,0,'','','Deshayes','a2bfe682-0d5c-5bbf-9afa-1a7bd7c445c5','Cyrena difficilis Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cyrena','','difficilis','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09499','','','Pupina difficilis J. Semper, 1864',1,'Pupina difficilis','Pupina difficilis','Pupina difficil',2,0,'','','J. Semper','bb7e0534-9441-52fb-b76b-110ec3542503','Pupina difficilis J. Semper, 1864','J. Semper, 1864','UNRANKED','','Pupina','','difficilis','','','',NULL,'','','','','','J. Semper','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09507','','','Melania digitalis Mousson, 1857',1,'Melania digitalis','Melania digitalis','Melania digital',2,0,'','','Mousson','4ad2abc6-4a35-57eb-b6e4-f2ee5b7ef260','Melania digitalis Mousson, 1857','Mousson, 1857','UNRANKED','','Melania','','digitalis','','','',NULL,'','','','','','Mousson','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09510','','','Cardiola digitata Fried. Roemer, 1850',1,'Cardiola digitata','Cardiola digitata','Cardiola digitat',2,0,'','','Fried. Roemer','7ea4d2ea-3408-5cb1-9896-d3bce992430f','Cardiola digitata Fried. Roemer, 1850','Fried. Roemer, 1850','UNRANKED','','Cardiola','','digitata','','','',NULL,'','','','','','Fried. Roemer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09517','','','Trypanostoma dignum Lea, 1862',1,'Trypanostoma dignum','Trypanostoma dignum','Trypanostoma dign',2,0,'','','Lea','66d43c16-14fe-5421-9564-32923c6cde02','Trypanostoma dignum Lea, 1862','Lea, 1862','UNRANKED','','Trypanostoma','','dignum','','','',NULL,'','','','','','Lea','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09521','','','Venerupis digona Deshayes, 1853',1,'Venerupis digona','Venerupis digona','Venerupis digon',2,0,'','','Deshayes','ecb3d1d2-fa51-553f-923f-f9225ad15ac5','Venerupis digona Deshayes, 1853','Deshayes, 1853','UNRANKED','','Venerupis','','digona','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09525','','','Chemnitzia dilatata Laube, 1866',1,'Chemnitzia dilatata','Chemnitzia dilatata','Chemnitzia dilatat',2,0,'','','Laube','87c0a9ae-cb46-5338-a641-9bef16ad46d5','Chemnitzia dilatata Laube, 1866','Laube, 1866','UNRANKED','','Chemnitzia','','dilatata','','','',NULL,'','','','','','Laube','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09533','','','Limnaea dilatata Noulet, 1854',1,'Limnaea dilatata','Limnaea dilatata','Limnaea dilatat',2,0,'','','Noulet','406d510e-4c16-5c07-8ed4-6c8700fd566a','Limnaea dilatata Noulet, 1854','Noulet, 1854','UNRANKED','','Limnaea','','dilatata','','','',NULL,'','','','','','Noulet','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09540','','','Opis dilatata Deshayes, 1853',1,'Opis dilatata','Opis dilatata','Opis dilatat',2,0,'','','Deshayes','34205d41-ae99-5b30-8214-f420f15f9541','Opis dilatata Deshayes, 1853','Deshayes, 1853','UNRANKED','','Opis','','dilatata','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09546','','','Tellina dilatata Deshayes, 1854',1,'Tellina dilatata','Tellina dilatata','Tellina dilatat',2,0,'','','Deshayes','0d5a8a9c-694a-5f76-9514-d99c51b87fac','Tellina dilatata Deshayes, 1854','Deshayes, 1854','UNRANKED','','Tellina','','dilatata','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09552','','','Cyclostoma dilatatum Gundlach, in Pfeiffer, 1859',2,'Cyclostoma dilatatum','Cyclostoma dilatatum','Cyclostoma dilatat',2,0,'','','Gundlach|Pfeiffer','d160a858-8e5a-5ae8-90cc-55c0b4ce4aaf','Cyclostoma dilatatum Gundlach, in Pfeiffer, 1859','Gundlach, in Pfeiffer, 1859','UNRANKED','','Cyclostoma','','dilatatum','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09558','','','Scaphander dilatatus A. Adams, 1862',1,'Scaphander dilatatus','Scaphander dilatatus','Scaphander dilatat',2,0,'','','A. Adams','72005360-6cd1-5ce9-bfb5-ae4e2bdc0265','Scaphander dilatatus A. Adams, 1862','A. Adams, 1862','UNRANKED','','Scaphander','','dilatatus','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09563','','','Gouldia dilecta Gould, 1861',1,'Gouldia dilecta','Gouldia dilecta','Gouldia dilect',2,0,'','','Gould','72a8301a-e70e-5c43-b7a6-5ae70ea6de82','Gouldia dilecta Gould, 1861','Gould, 1861','UNRANKED','','Gouldia','','dilecta','','','',NULL,'','','','','','Gould','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09567','','','Conus dilectus Gould, 1851',1,'Conus dilectus','Conus dilectus','Conus dilect',2,0,'','','Gould','ddb539cf-00af-5ba1-b4eb-e40653455035','Conus dilectus Gould, 1851','Gould, 1851','UNRANKED','','Conus','','dilectus','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09572','','','Trigona dillwyni Deshayes, 1853',1,'Trigona dillwyni','Trigona dillwyni','Trigona dillwyn',2,0,'','','Deshayes','e927bf92-d35f-5ed1-8d70-104a186ebcc4','Trigona dillwyni Deshayes, 1853','Deshayes, 1853','UNRANKED','','Trigona','','dillwyni','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09577','','','Paludina diluviana Kunth, 1865',1,'Paludina diluviana','Paludina diluviana','Paludina diluuian',2,0,'','','Kunth','21519d39-12ee-5191-85bf-b0da63be2681','Paludina diluviana Kunth, 1865','Kunth, 1865','UNRANKED','','Paludina','','diluviana','','','',NULL,'','','','','','Kunth','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09581','','','Melania dimidiata Menke, 1854',1,'Melania dimidiata','Melania dimidiata','Melania dimidiat',2,0,'','','Menke','0a4eb332-807d-5d92-b1eb-bc54a4eeb6cb','Melania dimidiata Menke, 1854','Menke, 1854','UNRANKED','','Melania','','dimidiata','','','',NULL,'','','','','','Menke','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09586','','','Ancylus fluviatilis dimidiatus Colbeau, 1868',1,'Ancylus fluviatilis dimidiatus','Ancylus fluviatilis dimidiatus','Ancylus fluuiatil dimidiat',3,0,'','','Colbeau','25d7720a-8c32-58b0-93dd-63dc6be30abb','Ancylus fluviatilis dimidiatus Colbeau, 1868','Colbeau, 1868','UNRANKED','','Ancylus','','fluviatilis','dimidiatus','','',NULL,'','','','','','Colbeau','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09590','','','Partula diminuta C.B. Adams, 1851',1,'Partula diminuta','Partula diminuta','Partula diminut',2,0,'','','C. B. Adams','29c778dd-4929-530c-8c95-61acc911a18d','Partula diminuta C.B. Adams, 1851','C.B. Adams, 1851','UNRANKED','','Partula','','diminuta','','','',NULL,'','','','','','C. B. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09597','','','Achatinella dimorpha Gulick, 1858',1,'Achatinella dimorpha','Achatinella dimorpha','Achatinella dimorph',2,0,'','','Gulick','530bc318-a2f9-5223-aab0-afd8488ae7a1','Achatinella dimorpha Gulick, 1858','Gulick, 1858','UNRANKED','','Achatinella','','dimorpha','','','',NULL,'','','','','','Gulick','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09602','','','Pecten dimotus Eichwald, 1865',1,'Pecten dimotus','Pecten dimotus','Pecten dimot',2,0,'','','Eichwald','e4b19b07-81c9-5cc1-be5d-e750a061c08d','Pecten dimotus Eichwald, 1865','Eichwald, 1865','UNRANKED','','Pecten','','dimotus','','','',NULL,'','','','','','Eichwald','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09608','','','Hettangia dionvillensis Terquem, 1853',1,'Hettangia dionvillensis','Hettangia dionvillensis','Hettangia dionuillens',2,0,'','','Terquem','b1e5806d-b271-567c-adf7-956e4ad88a5d','Hettangia dionvillensis Terquem, 1853','Terquem, 1853','UNRANKED','','Hettangia','','dionvillensis','','','',NULL,'','','','','','Terquem','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09611','','','Helix diplodon Benson, 1859',1,'Helix diplodon','Helix diplodon','Helix diplodon',2,0,'','','Benson','1d2d9478-45e1-591a-9d48-2d7e2784c5ec','Helix diplodon Benson, 1859','Benson, 1859','UNRANKED','','Helix','','diplodon','','','',NULL,'','','','','','Benson','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09614','','','Patella dira Reeve, 1855',1,'Patella dira','Patella dira','Patella dir',2,0,'','','Reeve','cf68a890-6ef2-53d7-965f-d0aee4c3142d','Patella dira Reeve, 1855','Reeve, 1855','UNRANKED','','Patella','','dira','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09620','','','Helix discina R. Lowe, 1852',1,'Helix discina','Helix discina','Helix discin',2,0,'','','R. Lowe','bd0fca16-1ac4-5c8c-99f0-e53e6a8a5af0','Helix discina R. Lowe, 1852','R. Lowe, 1852','UNRANKED','','Helix','','discina','','','',NULL,'','','','','','R. Lowe','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09624','','','Lucina discoidalis Buvignier, 1852',1,'Lucina discoidalis','Lucina discoidalis','Lucina discoidal',2,0,'','','Buvignier','c5d6f553-17df-501c-a0e5-5557e635e5f0','Lucina discoidalis Buvignier, 1852','Buvignier, 1852','UNRANKED','','Lucina','','discoidalis','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09629','','','Ostrea discoidea Gould, 1851',1,'Ostrea discoidea','Ostrea discoidea','Ostrea discoide',2,0,'','','Gould','b38cc566-80a6-5420-9c65-005695e0be0a','Ostrea discoidea Gould, 1851','Gould, 1851','UNRANKED','','Ostrea','','discoidea','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09633','','','Crossostoma discoideum Morris and Lycett, 1854',1,'Crossostoma discoideum','Crossostoma discoideum','Crossostoma discoide',2,0,'','','Morris|Lycett','d75c146e-7f35-5ae7-ace6-f7a2cc010e2f','Crossostoma discoideum Morris and Lycett, 1854','Morris and Lycett, 1854','UNRANKED','','Crossostoma','','discoideum','','','',NULL,'','','','','','Morris & Lycett','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09636','','','Chondropoma discolorans Wright, in Pfeiffer, 1863',2,'Chondropoma discolorans','Chondropoma discolorans','Chondropoma discolorans',2,0,'','','Wright|Pfeiffer','813f233d-d2d3-5322-9937-25689c31c8e1','Chondropoma discolorans Wright, in Pfeiffer, 1863','Wright, in Pfeiffer, 1863','UNRANKED','','Chondropoma','','discolorans','','','',NULL,'','','','','','Wright','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09641','','','Acmaea discrepans Ryckholt, 1852',1,'Acmaea discrepans','Acmaea discrepans','Acmaea discrepans',2,0,'','','Ryckholt','ebed68f7-88fa-583f-86cb-0f773435f753','Acmaea discrepans Ryckholt, 1852','Ryckholt, 1852','UNRANKED','','Acmaea','','discrepans','','','',NULL,'','','','','','Ryckholt','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09649','','','Solarium disculum Morris and Lycett, 1854',1,'Solarium disculum','Solarium disculum','Solarium discul',2,0,'','','Morris|Lycett','e5dc16e6-82e7-535c-be61-d0501d023544','Solarium disculum Morris and Lycett, 1854','Morris and Lycett, 1854','UNRANKED','','Solarium','','disculum','','','',NULL,'','','','','','Morris & Lycett','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09656','','','Unio disculus Lea, 1860',1,'Unio disculus','Unio disculus','Unio discul',2,0,'','','Lea','f8c1e287-a74a-5628-91c1-651c0b8c3d91','Unio disculus Lea, 1860','Lea, 1860','UNRANKED','','Unio','','disculus','','','',NULL,'','','','','','Lea','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09667','','','Lacuna disjuncta Raincourt and Munier, 1863',1,'Lacuna disjuncta','Lacuna disjuncta','Lacuna disiunct',2,0,'','','Raincourt|Munier','d6caa455-19b6-50e0-a0a9-6a288225bea4','Lacuna disjuncta Raincourt and Munier, 1863','Raincourt and Munier, 1863','UNRANKED','','Lacuna','','disjuncta','','','',NULL,'','','','','','Raincourt & Munier','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09674','','','Euomphalus disjunctus Hall, 1859',1,'Euomphalus disjunctus','Euomphalus disjunctus','Euomphalus disiunct',2,0,'','','Hall','94f83048-52b6-57df-9fe4-b1bd32fd5e38','Euomphalus disjunctus Hall, 1859','Hall, 1859','UNRANKED','','Euomphalus','','disjunctus','','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09678','','','Argonauta dispar Conrad, 1854',1,'Argonauta dispar','Argonauta dispar','Argonauta dispar',2,0,'','','Conrad','6b182a7e-290b-5e43-bf31-f68c63639d33','Argonauta dispar Conrad, 1854','Conrad, 1854','UNRANKED','','Argonauta','','dispar','','','',NULL,'','','','','','Conrad','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09681','','','Helix (Charopa) dispar Brazier, 1870',1,'Helix dispar','Helix dispar','Helix dispar',2,0,'','','Brazier','86c94f5e-92cf-543f-8b0b-0c05d691b0c7','Helix (Charopa) dispar Brazier, 1870','Brazier, 1870','UNRANKED','','Helix','Charopa','dispar','','','',NULL,'','','','','','Brazier','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09685','','','Nerinea dispar Gabb, 1864',1,'Nerinea dispar','Nerinea dispar','Nerinea dispar',2,0,'','','Gabb','ce56aa33-de3a-58b3-9c9b-14864ebcf83e','Nerinea dispar Gabb, 1864','Gabb, 1864','UNRANKED','','Nerinea','','dispar','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09692','','','Unio dispar Lea, 1860',1,'Unio dispar','Unio dispar','Unio dispar',2,0,'','','Lea','9dd88586-3f38-53e5-a4ba-3e86a5dcd6dc','Unio dispar Lea, 1860','Lea, 1860','UNRANKED','','Unio','','dispar','','','',NULL,'','','','','','Lea','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09696','','','Pecten disparilis Quenstedt, 1856',1,'Pecten disparilis','Pecten disparilis','Pecten disparil',2,0,'','','Quenstedt','cf013c33-64de-5f6c-a0dd-4c6ed8397c65','Pecten disparilis Quenstedt, 1856','Quenstedt, 1856','UNRANKED','','Pecten','','disparilis','','','',NULL,'','','','','','Quenstedt','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09701','','','Mitra dispora Ryckholt, 1862',1,'Mitra dispora','Mitra dispora','Mitra dispor',2,0,'','','Ryckholt','424151ae-cb28-5ce4-9fd0-3852b8031b2d','Mitra dispora Ryckholt, 1862','Ryckholt, 1862','UNRANKED','','Mitra','','dispora','','','',NULL,'','','','','','Ryckholt','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09705','','','Dentalium dissimile Guppy, 1866',1,'Dentalium dissimile','Dentalium dissimile','Dentalium dissimil',2,0,'','','Guppy','ff2b7ea6-2305-516f-92c9-705b609a733e','Dentalium dissimile Guppy, 1866','Guppy, 1866','UNRANKED','','Dentalium','','dissimile','','','',NULL,'','','','','','Guppy','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09712','','','Marginella dissimilis Deshayes, 1865',1,'Marginella dissimilis','Marginella dissimilis','Marginella dissimil',2,0,'','','Deshayes','4e289890-271d-50df-9ab9-54573820db59','Marginella dissimilis Deshayes, 1865','Deshayes, 1865','UNRANKED','','Marginella','','dissimilis','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09717','','','Pleurotoma dissimilis F. Edwards, 1860',1,'Pleurotoma dissimilis','Pleurotoma dissimilis','Pleurotoma dissimil',2,0,'','','F. Edwards','090c574f-ac9a-5d0d-8c2b-09531a7f8833','Pleurotoma dissimilis F. Edwards, 1860','F. Edwards, 1860','UNRANKED','','Pleurotoma','','dissimilis','','','',NULL,'','','','','','F. Edwards','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09721','','','Helicina dissimulans Poey, 1858',1,'Helicina dissimulans','Helicina dissimulans','Helicina dissimulans',2,0,'','','Poey','48d570c2-98fd-5ede-a60b-fffe095f7a0e','Helicina dissimulans Poey, 1858','Poey, 1858','UNRANKED','','Helicina','','dissimulans','','','',NULL,'','','','','','Poey','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09728','','','Bulimus distans Pfeiffer, 1856',1,'Bulimus distans','Bulimus distans','Bulimus distans',2,0,'','','Pfeiffer','eefd659b-a9ca-5642-9cd2-aadc02eeb9c1','Bulimus distans Pfeiffer, 1856','Pfeiffer, 1856','UNRANKED','','Bulimus','','distans','','','',NULL,'','','','','','Pfeiffer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09733','','','Drillia distans Conrad, 1860',1,'Drillia distans','Drillia distans','Drillia distans',2,0,'','','Conrad','92e4a166-d40d-5955-8d9d-6be6812e62df','Drillia distans Conrad, 1860','Conrad, 1860','UNRANKED','','Drillia','','distans','','','',NULL,'','','','','','Conrad','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09738','','','Leiotrochus distans Conrad, 1862',1,'Leiotrochus distans','Leiotrochus distans','Leiotrochus distans',2,0,'','','Conrad','9085d542-3dc4-54d7-a388-8fa0ce05da8a','Leiotrochus distans Conrad, 1862','Conrad, 1862','UNRANKED','','Leiotrochus','','distans','','','',NULL,'','','','','','Conrad','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09742','','','Trapezium distans Ryckholt, 1860',1,'Trapezium distans','Trapezium distans','Trapezium distans',2,0,'','','Ryckholt','abc72ca3-291e-5a35-a48e-f81ed64c7da2','Trapezium distans Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Trapezium','','distans','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09749','','','Crassatella distincta Deshayes, 1857',1,'Crassatella distincta','Crassatella distincta','Crassatella distinct',2,0,'','','Deshayes','9a0d8dda-7d4f-57f2-a8d8-c83007a4f510','Crassatella distincta Deshayes, 1857','Deshayes, 1857','UNRANKED','','Crassatella','','distincta','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09754','','','Arca distinctissima Mayer, 1868',1,'Arca distinctissima','Arca distinctissima','Arca distinctissim',2,0,'','','Mayer','2d8b418b-abd6-568e-a1d1-5e4e68a6bdde','Arca distinctissima Mayer, 1868','Mayer, 1868','UNRANKED','','Arca','','distinctissima','','','',NULL,'','','','','','Mayer','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09758','','','Latirus distinctus A. Adams, 1854',1,'Latirus distinctus','Latirus distinctus','Latirus distinct',2,0,'','','A. Adams','d9edb9a7-12cc-5c31-a375-a5533e423b6a','Latirus distinctus A. Adams, 1854','A. Adams, 1854','UNRANKED','','Latirus','','distinctus','','','',NULL,'','','','','','A. Adams','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09765','','','Clausilia distorta Küster, 1861',1,'Clausilia distorta','Clausilia distorta','Clausilia distort',2,0,'','','Küster','3e978db0-7933-5538-897c-b137c523eaf3','Clausilia distorta Küster, 1861','Küster, 1861','UNRANKED','','Clausilia','','distorta','','','',NULL,'','','','','','Küster','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09768','','','Limnaea longiscata distorta F. Edwards, 1852',1,'Limnaea longiscata distorta','Limnaea longiscata distorta','Limnaea longiscat distort',3,0,'','','F. Edwards','38a797df-0f22-5a62-863d-d5ed4d656740','Limnaea longiscata distorta F. Edwards, 1852','F. Edwards, 1852','UNRANKED','','Limnaea','','longiscata','distorta','','',NULL,'','','','','','F. Edwards','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09774','','','Cerithium distortion Terquem and Piette, 1865',1,'Cerithium distortion','Cerithium distortion','Cerithium distortion',2,0,'','','Terquem|Piette','feeb6cce-7695-5020-ab10-04c602d3835c','Cerithium distortion Terquem and Piette, 1865','Terquem and Piette, 1865','UNRANKED','','Cerithium','','distortion','','','',NULL,'','','','','','Terquem & Piette','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09779','','','Michelia distracta Fried. Roemer, 1852',1,'Michelia distracta','Michelia distracta','Michelia distract',2,0,'','','Fried. Roemer','9e735578-9fdc-5345-8980-fc30a64c05bb','Michelia distracta Fried. Roemer, 1852','Fried. Roemer, 1852','UNRANKED','','Michelia','','distracta','','','',NULL,'','','','','','Fried. Roemer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09784','','','Clavagella divaricata J. Müller, 1859',1,'Clavagella divaricata','Clavagella divaricata','Clavagella diuaricat',2,0,'','','J. Müller','f6ea877e-e67d-5de9-b36b-1c809659861e','Clavagella divaricata J. Müller, 1859','J. Müller, 1859','UNRANKED','','Clavagella','','divaricata','','','',NULL,'','','','','','J. Müller','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09788','','','Teredo divaricata Deshayes, in Fischer, 1856',2,'Teredo divaricata','Teredo divaricata','Teredo diuaricat',2,0,'','','Deshayes|Fischer','f7202fc6-fb56-5c9a-9464-973604a82573','Teredo divaricata Deshayes, in Fischer, 1856','Deshayes, in Fischer, 1856','UNRANKED','','Teredo','','divaricata','','','',NULL,'','','','','','Deshayes','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09793','','','Achatina diversa Deshayes, 1863',1,'Achatina diversa','Achatina diversa','Achatina diuers',2,0,'','','Deshayes','f3486423-75ba-5b30-a285-e790991cd26a','Achatina diversa Deshayes, 1863','Deshayes, 1863','UNRANKED','','Achatina','','diversa','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09798','','','Tapes diversa G. Sowerby, 1852',1,'Tapes diversa','Tapes diversa','Tapes diuers',2,0,'','','G. Sowerby','cbd5e784-a1db-53bd-afdc-eee176ceeb4d','Tapes diversa G. Sowerby, 1852','G. Sowerby, 1852','UNRANKED','','Tapes','','diversa','','','',NULL,'','','','','','G. Sowerby','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09803','','','Nerinea dives Piette, 1855',1,'Nerinea dives','Nerinea dives','Nerinea diu',2,0,'','','Piette','0cf5cd31-7430-5a68-90e2-f25d099a6590','Nerinea dives Piette, 1855','Piette, 1855','UNRANKED','','Nerinea','','dives','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09810','','','Opis divisus Rigaux and Sauvage, 1868',1,'Opis divisus','Opis divisus','Opis diuis',2,0,'','','Rigaux|Sauvage','ea0fb2c5-2773-52b2-b06c-477e3cc2844d','Opis divisus Rigaux and Sauvage, 1868','Rigaux and Sauvage, 1868','UNRANKED','','Opis','','divisus','','','',NULL,'','','','','','Rigaux & Sauvage','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09815','','','Turritella dixoni Deshayes, 1861',1,'Turritella dixoni','Turritella dixoni','Turritella dixon',2,0,'','','Deshayes','6621651f-a148-5efc-a377-ebc322fdf5ee','Turritella dixoni Deshayes, 1861','Deshayes, 1861','UNRANKED','','Turritella','','dixoni','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09820','','','Cyclostoma fimbriatulum docens C.B. Adams, 1851',1,'Cyclostoma fimbriatulum docens','Cyclostoma fimbriatulum docens','Cyclostoma fimbriatul docens',3,0,'','','C. B. Adams','74ed9901-7d4c-5bd5-9315-6ec3840e1d0a','Cyclostoma fimbriatulum docens C.B. Adams, 1851','C.B. Adams, 1851','UNRANKED','','Cyclostoma','','fimbriatulum','docens','','',NULL,'','','','','','C. B. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09823','','','Neritina doderleini Ancona, 1869',1,'Neritina doderleini','Neritina doderleini','Neritina doderlein',2,0,'','','Ancona','dd847349-6e0a-5d8c-9dfc-ac106d3410b2','Neritina doderleini Ancona, 1869','Ancona, 1869','UNRANKED','','Neritina','','doderleini','','','',NULL,'','','','','','Ancona','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09828','','','Bulimus dohrni Pfeiffer, 1863',1,'Bulimus dohrni','Bulimus dohrni','Bulimus dohrn',2,0,'','','Pfeiffer','cb085292-a5cd-5796-b7c0-b3f3080d3bd5','Bulimus dohrni Pfeiffer, 1863','Pfeiffer, 1863','UNRANKED','','Bulimus','','dohrni','','','',NULL,'','','','','','Pfeiffer','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09831','','','Cytherea dohrni E. Römer, 1869',1,'Cytherea dohrni','Cytherea dohrni','Cytherea dohrn',2,0,'','','E. Römer','cb38a663-bb27-5804-92ef-f82af330de43','Cytherea dohrni E. Römer, 1869','E. Römer, 1869','UNRANKED','','Cytherea','','dohrni','','','',NULL,'','','','','','E. Römer','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09836','','','Achatina dohrniana Pfeiffer, 1870',1,'Achatina dohrniana','Achatina dohrniana','Achatina dohrnian',2,0,'','','Pfeiffer','f55022c0-fae3-59a3-94e6-ee0f879e87cc','Achatina dohrniana Pfeiffer, 1870','Pfeiffer, 1870','UNRANKED','','Achatina','','dohrniana','','','',NULL,'','','','','','Pfeiffer','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09844','','','Mactra dolabrata Deshayes, 1854',1,'Mactra dolabrata','Mactra dolabrata','Mactra dolabrat',2,0,'','','Deshayes','a21c14ef-2bc5-53bc-a067-3d6abddabe9e','Mactra dolabrata Deshayes, 1854','Deshayes, 1854','UNRANKED','','Mactra','','dolabrata','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09846','','','Mysia dolabrata Gould, 1861',1,'Mysia dolabrata','Mysia dolabrata','Mysia dolabrat',2,0,'','','Gould','3bec9d7a-99d5-5735-95da-29b10b80a9b1','Mysia dolabrata Gould, 1861','Gould, 1861','UNRANKED','','Mysia','','dolabrata','','','',NULL,'','','','','','Gould','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09851','','','Ringicula doliaris Gould, 1860',1,'Ringicula doliaris','Ringicula doliaris','Ringicula doliar',2,0,'','','Gould','446ecc07-2a15-5c3b-9d2d-b2dadaecf03a','Ringicula doliaris Gould, 1860','Gould, 1860','UNRANKED','','Ringicula','','doliaris','','','',NULL,'','','','','','Gould','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09852','','','Unio doliaris Lea, 1865',1,'Unio doliaris','Unio doliaris','Unio doliar',2,0,'','','Lea','06154971-f765-52e2-b737-46f1a4dcf5f8','Unio doliaris Lea, 1865','Lea, 1865','UNRANKED','','Unio','','doliaris','','','',NULL,'','','','','','Lea','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09857','','','Bulla doliolum Morris and Lycett, 1854',1,'Bulla doliolum','Bulla doliolum','Bulla doliol',2,0,'','','Morris|Lycett','13f94fcd-0b46-5b4d-b63c-6949fbe48b4c','Bulla doliolum Morris and Lycett, 1854','Morris and Lycett, 1854','UNRANKED','','Bulla','','doliolum','','','',NULL,'','','','','','Morris & Lycett','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09862','','','Conus dolium Boivin, 1864',1,'Conus dolium','Conus dolium','Conus doli',2,0,'','','Boivin','266ff131-4fe0-54a3-9846-0f5f2bc9892a','Conus dolium Boivin, 1864','Boivin, 1864','UNRANKED','','Conus','','dolium','','','',NULL,'','','','','','Boivin','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09864','','','Trichotropis dolium Petit de la Saussaye, 1851',1,'Trichotropis dolium','Trichotropis dolium','Trichotropis doli',2,0,'','','Petit de la Saussaye','8a9aaece-4da1-59d9-9f8f-9400b3ca55c7','Trichotropis dolium Petit de la Saussaye, 1851','Petit de la Saussaye, 1851','UNRANKED','','Trichotropis','','dolium','','','',NULL,'','','','','','Petit de la Saussaye','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09869','','','Cytherea domeykoana Philippi, 1857',1,'Cytherea domeykoana','Cytherea domeykoana','Cytherea domeykoan',2,0,'','','Philippi','75031503-29bf-5b61-940b-c11e13fa45f1','Cytherea domeykoana Philippi, 1857','Philippi, 1857','UNRANKED','','Cytherea','','domeykoana','','','',NULL,'','','','','','Philippi','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09874','','','Oniscia domingensis G. Sowerby, 1850',1,'Oniscia domingensis','Oniscia domingensis','Oniscia domingens',2,0,'','','G. Sowerby','c01ffd5f-3dd2-58f9-b5ac-18e6a288f74e','Oniscia domingensis G. Sowerby, 1850','G. Sowerby, 1850','UNRANKED','','Oniscia','','domingensis','','','',NULL,'','','','','','G. Sowerby','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09875','','','Petaloconchus domingensis G. Sowerby, 1850',1,'Petaloconchus domingensis','Petaloconchus domingensis','Petaloconchus domingens',2,0,'','','G. Sowerby','63c839cc-f9e4-5615-b2da-c2c875138fea','Petaloconchus domingensis G. Sowerby, 1850','G. Sowerby, 1850','UNRANKED','','Petaloconchus','','domingensis','','','',NULL,'','','','','','G. Sowerby','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09880','','','Cylindrella dominicensis Pfeiffer, 1850',1,'Cylindrella dominicensis','Cylindrella dominicensis','Cylindrella dominicens',2,0,'','','Pfeiffer','8cca02a1-372c-5bfc-92ee-b66e45c3c048','Cylindrella dominicensis Pfeiffer, 1850','Pfeiffer, 1850','UNRANKED','','Cylindrella','','dominicensis','','','',NULL,'','','','','','Pfeiffer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09884','','','Succinea dominicensis Pfeiffer, 1851',1,'Succinea dominicensis','Succinea dominicensis','Succinea dominicens',2,0,'','','Pfeiffer','6ad53d1c-b53e-5438-a0df-baa4349853fc','Succinea dominicensis Pfeiffer, 1851','Pfeiffer, 1851','UNRANKED','','Succinea','','dominicensis','','','',NULL,'','','','','','Pfeiffer','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09888','','','Erycina donaciformis Deshayes, 1858',1,'Erycina donaciformis','Erycina donaciformis','Erycina donaciform',2,0,'','','Deshayes','8fe27ef5-efe2-5d2f-bacb-487742443ae2','Erycina donaciformis Deshayes, 1858','Deshayes, 1858','UNRANKED','','Erycina','','donaciformis','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09893','','','Tellina donaciformis Deshayes, 1854',1,'Tellina donaciformis','Tellina donaciformis','Tellina donaciform',2,0,'','','Deshayes','9d1d23f4-b4b5-54a0-9df0-a852f00ae25a','Tellina donaciformis Deshayes, 1854','Deshayes, 1854','UNRANKED','','Tellina','','donaciformis','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09896','','','Psammobia donacina Deshayes, 1857',1,'Psammobia donacina','Psammobia donacina','Psammobia donacin',2,0,'','','Deshayes','a0cd204e-ad56-5f02-a756-7ae638c5b7a9','Psammobia donacina Deshayes, 1857','Deshayes, 1857','UNRANKED','','Psammobia','','donacina','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09903','','','Helix donovani Pfeiffer, 1851',1,'Helix donovani','Helix donovani','Helix donouan',2,0,'','','Pfeiffer','a0a8f796-d4d3-5137-acfd-ce7568f979a0','Helix donovani Pfeiffer, 1851','Pfeiffer, 1851','UNRANKED','','Helix','','donovani','','','',NULL,'','','','','','Pfeiffer','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09907','','','Cyclostoma dorbignyanum Petit de la Saussaye, 1850',1,'Cyclostoma dorbignyanum','Cyclostoma dorbignyanum','Cyclostoma dorbignyan',2,0,'','','Petit de la Saussaye','c60a8b62-55b4-5a61-bc9e-0083599aa187','Cyclostoma dorbignyanum Petit de la Saussaye, 1850','Petit de la Saussaye, 1850','UNRANKED','','Cyclostoma','','dorbignyanum','','','',NULL,'','','','','','Petit de la Saussaye','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09915','','','Melanopsis doriae Issel, 1865',1,'Melanopsis doriae','Melanopsis doriae','Melanopsis dori',2,0,'','','Issel','57bc68f2-1fe3-53d4-8ea8-1606fc8d7645','Melanopsis doriae Issel, 1865','Issel, 1865','UNRANKED','','Melanopsis','','doriae','','','',NULL,'','','','','','Issel','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09918','','','Limnaea doriana Bourguignat, 1862',1,'Limnaea doriana','Limnaea doriana','Limnaea dorian',2,0,'','','Bourguignat','79d04c18-6fb5-5fb3-933c-0c3ef86c7f64','Limnaea doriana Bourguignat, 1862','Bourguignat, 1862','UNRANKED','','Limnaea','','doriana','','','',NULL,'','','','','','Bourguignat','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09922','','','Bulimus dormant W. Binney, 1857',1,'Bulimus dormant','Bulimus dormant','Bulimus dorma',2,0,'','','W. Binney','8b43585d-c1ca-514a-b2a7-c8427119c5e6','Bulimus dormant W. Binney, 1857','W. Binney, 1857','UNRANKED','','Bulimus','','dormant','','','',NULL,'','','','','','W. Binney','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09929','','','Modiola dorsata Eichwald, 1865',1,'Modiola dorsata','Modiola dorsata','Modiola dorsat',2,0,'','','Eichwald','c0e910c3-4b5c-5fdc-8d71-936635fb7489','Modiola dorsata Eichwald, 1865','Eichwald, 1865','UNRANKED','','Modiola','','dorsata','','','',NULL,'','','','','','Eichwald','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09935','','','Cabestana dorsuosa A. Adams, 1870',1,'Cabestana dorsuosa','Cabestana dorsuosa','Cabestana dorsuos',2,0,'','','A. Adams','143d475f-1c52-52ad-a8f2-305f6e526a7d','Cabestana dorsuosa A. Adams, 1870','A. Adams, 1870','UNRANKED','','Cabestana','','dorsuosa','','','',NULL,'','','','','','A. Adams','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09942','','','Pinna dötzkirchneri Gümbel, 1861',2,'Pinna doetzkirchneri','Pinna doetzkirchneri','Pinna doetzkirchner',2,0,'','','Gümbel','bc94ce3f-97a1-5775-a8b0-0fb5d962c868','Pinna dötzkirchneri Gümbel, 1861','Gümbel, 1861','UNRANKED','','Pinna','','doetzkirchneri','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09948','','','Unio downiei Lea, 1858',1,'Unio downiei','Unio downiei','Unio downie',2,0,'','','Lea','d081a8ec-b04f-56c6-8180-8682759b2407','Unio downiei Lea, 1858','Lea, 1858','UNRANKED','','Unio','','downiei','','','',NULL,'','','','','','Lea','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09956','','','Helix arbustorum draparnaudia A. Moquin-Tandon, 1855',1,'Helix arbustorum draparnaudia','Helix arbustorum draparnaudia','Helix arbustor draparnaud',3,0,'','','A. Moquin-Tandon','1b50cce2-edee-5879-bd7e-83e48fb2e65f','Helix arbustorum draparnaudia A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','arbustorum','draparnaudia','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09959','','','Goniobasis draytonii Lea, 1862',1,'Goniobasis draytonii','Goniobasis draytonii','Goniobasis drayton',2,0,'','','Lea','042592f9-fcdc-5ebe-ad60-97f569b181f2','Goniobasis draytonii Lea, 1862','Lea, 1862','UNRANKED','','Goniobasis','','draytonii','','','',NULL,'','','','','','Lea','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09963','','','Lucina drogiaca Cotteau, 1855',1,'Lucina drogiaca','Lucina drogiaca','Lucina drogiac',2,0,'','','Cotteau','2b64258b-a255-506b-8a57-b700c03239a5','Lucina drogiaca Cotteau, 1855','Cotteau, 1855','UNRANKED','','Lucina','','drogiaca','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09965','','','Mytilus drogiacus Cotteau, 1855',1,'Mytilus drogiacus','Mytilus drogiacus','Mytilus drogiac',2,0,'','','Cotteau','e9f0ed70-eec1-5db8-ab19-6d5b16def730','Mytilus drogiacus Cotteau, 1855','Cotteau, 1855','UNRANKED','','Mytilus','','drogiacus','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09969','','','Mytilus droueti Gueranger, 1853',1,'Mytilus droueti','Mytilus droueti','Mytilus drouet',2,0,'','','Gueranger','1a16b3e2-e075-5f3d-abff-6bc0db9925f1','Mytilus droueti Gueranger, 1853','Gueranger, 1853','UNRANKED','','Mytilus','','droueti','','','',NULL,'','','','','','Gueranger','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09973','','','Astarte drouetiana Cotteau, 1855',1,'Astarte drouetiana','Astarte drouetiana','Astarte drouetian',2,0,'','','Cotteau','81c981de-0701-5453-ade0-7d933f0a9b85','Astarte drouetiana Cotteau, 1855','Cotteau, 1855','UNRANKED','','Astarte','','drouetiana','','','',NULL,'','','','','','Cotteau','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09975','','','Ancylus drouetianus Bourguignat, 1853',1,'Ancylus drouetianus','Ancylus drouetianus','Ancylus drouetian',2,0,'','','Bourguignat','090fc8f2-5589-52e5-9aa0-52106df12d61','Ancylus drouetianus Bourguignat, 1853','Bourguignat, 1853','UNRANKED','','Ancylus','','drouetianus','','','',NULL,'','','','','','Bourguignat','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09981','','','Pleurotomaria dryope Billings, 1865',1,'Pleurotomaria dryope','Pleurotomaria dryope','Pleurotomaria dryop',2,0,'','','Billings','e6fffa35-1939-5041-9727-01a6c3252be6','Pleurotomaria dryope Billings, 1865','Billings, 1865','UNRANKED','','Pleurotomaria','','dryope','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09984','','','Achatinella dubia Newcomb, 1853',1,'Achatinella dubia','Achatinella dubia','Achatinella dub',2,0,'','','Newcomb','c85fbe23-14c9-51ac-95c3-44e2726768ae','Achatinella dubia Newcomb, 1853','Newcomb, 1853','UNRANKED','','Achatinella','','dubia','','','',NULL,'','','','','','Newcomb','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09987','','','Cylindrella dubia Chitty, 1853',1,'Cylindrella dubia','Cylindrella dubia','Cylindrella dub',2,0,'','','Chitty','ec1d84ec-19e5-5bbe-b3c4-959af08a137b','Cylindrella dubia Chitty, 1853','Chitty, 1853','UNRANKED','','Cylindrella','','dubia','','','',NULL,'','','','','','Chitty','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09991','','','Halobia dubia Gabb, 1864',1,'Halobia dubia','Halobia dubia','Halobia dub',2,0,'','','Gabb','d6927499-abd7-5fe1-a35d-10234e26f110','Halobia dubia Gabb, 1864','Gabb, 1864','UNRANKED','','Halobia','','dubia','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_09997','','','Nerinea dubia Piette, 1855',1,'Nerinea dubia','Nerinea dubia','Nerinea dub',2,0,'','','Piette','de07f7b0-2ec6-5e7d-938c-8d9a013573fc','Nerinea dubia Piette, 1855','Piette, 1855','UNRANKED','','Nerinea','','dubia','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10004','','','Tellina dubia Michelotti, 1861',1,'Tellina dubia','Tellina dubia','Tellina dub',2,0,'','','Michelotti','8e9dd8e9-031f-5564-a843-d31823641c52','Tellina dubia Michelotti, 1861','Michelotti, 1861','UNRANKED','','Tellina','','dubia','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10007','','','Venus dubia Hupe, 1854',1,'Venus dubia','Venus dubia','Venus dub',2,0,'','','Hupe','b9a89c1b-d587-5ca9-9602-6b8b5894590a','Venus dubia Hupe, 1854','Hupe, 1854','UNRANKED','','Venus','','dubia','','','',NULL,'','','','','','Hupe','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10010','','','Ostrea dubiensis Contejean, 1857',1,'Ostrea dubiensis','Ostrea dubiensis','Ostrea dubiens',2,0,'','','Contejean','d5ff90c1-b268-5877-8436-5255eb3f1f86','Ostrea dubiensis Contejean, 1857','Contejean, 1857','UNRANKED','','Ostrea','','dubiensis','','','',NULL,'','','','','','Contejean','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10017','','','Arca dubisiensis Pictet and Campiche, 1866',1,'Arca dubisiensis','Arca dubisiensis','Arca dubisiens',2,0,'','','Pictet|Campiche','fe105c04-a877-5101-9276-bd35d7df231e','Arca dubisiensis Pictet and Campiche, 1866','Pictet and Campiche, 1866','UNRANKED','','Arca','','dubisiensis','','','',NULL,'','','','','','Pictet & Campiche','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10022','','','Turbo dubisiensis Pictet and Campiche, 1863',1,'Turbo dubisiensis','Turbo dubisiensis','Turbo dubisiens',2,0,'','','Pictet|Campiche','e53ebdd2-0149-528c-8a44-9458cb5ea716','Turbo dubisiensis Pictet and Campiche, 1863','Pictet and Campiche, 1863','UNRANKED','','Turbo','','dubisiensis','','','',NULL,'','','','','','Pictet & Campiche','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10028','','','Bulimus dubius Pfeiffer, 1851',1,'Bulimus dubius','Bulimus dubius','Bulimus dub',2,0,'','','Pfeiffer','64e0c0a5-cd09-5ac8-977e-b4eea0fccf3a','Bulimus dubius Pfeiffer, 1851','Pfeiffer, 1851','UNRANKED','','Bulimus','','dubius','','','',NULL,'','','','','','Pfeiffer','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10033','','','Unio dubocquii Coquand, 1854',1,'Unio dubocquii','Unio dubocquii','Unio dubocqu',2,0,'','','Coquand','75823b90-bff6-5bdd-b098-21347c21e4f7','Unio dubocquii Coquand, 1854','Coquand, 1854','UNRANKED','','Unio','','dubocquii','','','',NULL,'','','','','','Coquand','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10036','','','Cerithium duboisi Hörnes, 1855',1,'Cerithium duboisi','Cerithium duboisi','Cerithium dubois',2,0,'','','Hörnes','5c12b46b-6023-5fbc-800b-7ca5cbe05d9c','Cerithium duboisi Hörnes, 1855','Hörnes, 1855','UNRANKED','','Cerithium','','duboisi','','','',NULL,'','','','','','Hörnes','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10040','','','Paludina duboisi Mayer, 1856',1,'Paludina duboisi','Paludina duboisi','Paludina dubois',2,0,'','','Mayer','95548d91-2066-5e6f-bc0f-22dca6d19fab','Paludina duboisi Mayer, 1856','Mayer, 1856','UNRANKED','','Paludina','','duboisi','','','',NULL,'','','','','','Mayer','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10046','','','Zonites duboisi Charpentier, in Mousson, 1863',2,'Zonites duboisi','Zonites duboisi','Zonites dubois',2,0,'','','Charpentier|Mousson','e2006d34-a8a9-5499-9fb1-d9a1a29f1673','Zonites duboisi Charpentier, in Mousson, 1863','Charpentier, in Mousson, 1863','UNRANKED','','Zonites','','duboisi','','','',NULL,'','','','','','Charpentier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10054','','','Fusus duboisianus Orbigny, 1852',1,'Fusus duboisianus','Fusus duboisianus','Fusus duboisian',2,0,'','','Orbigny','40ed4db2-758d-52a4-9fdf-2d75ba6ec5fa','Fusus duboisianus Orbigny, 1852','Orbigny, 1852','UNRANKED','','Fusus','','duboisianus','','','',NULL,'','','','','','Orbigny','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10060','','','Turbinella duchassaingi Michelotti, 1861',1,'Turbinella duchassaingi','Turbinella duchassaingi','Turbinella duchassaing',2,0,'','','Michelotti','cb273c18-4fe3-5d55-b4dc-9ef91b16239b','Turbinella duchassaingi Michelotti, 1861','Michelotti, 1861','UNRANKED','','Turbinella','','duchassaingi','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10063','','','Avicula duclosiana M. Rouault, 1851',1,'Avicula duclosiana','Avicula duclosiana','Avicula duclosian',2,0,'','','M. Rouault','93d9e4b8-c991-5014-b3c2-2c117c069744','Avicula duclosiana M. Rouault, 1851','M. Rouault, 1851','UNRANKED','','Avicula','','duclosiana','','','',NULL,'','','','','','M. Rouault','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10066','','','Cardium dufrenoycum Buvignier, 1852',1,'Cardium dufrenoycum','Cardium dufrenoycum','Cardium dufrenoyc',2,0,'','','Buvignier','942011f2-876a-582d-ab9c-445fb07761be','Cardium dufrenoycum Buvignier, 1852','Buvignier, 1852','UNRANKED','','Cardium','','dufrenoycum','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10074','','','Turbinella dujardini Hörnes, 1854',1,'Turbinella dujardini','Turbinella dujardini','Turbinella duiardin',2,0,'','','Hörnes','9b0dca7d-ac8c-5726-b59d-060d48ad31d7','Turbinella dujardini Hörnes, 1854','Hörnes, 1854','UNRANKED','','Turbinella','','dujardini','','','',NULL,'','','','','','Hörnes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10077','','','Cardium dulce Deshayes, 1863',1,'Cardium dulce','Cardium dulce','Cardium dulc',2,0,'','','Deshayes','eb36c38c-b617-54f5-9da6-6a008b663dc8','Cardium dulce Deshayes, 1863','Deshayes, 1863','UNRANKED','','Cardium','','dulce','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10082','','','Helix splendida dumasia A. Moquin-Tandon, 1855',1,'Helix splendida dumasia','Helix splendida dumasia','Helix splendid dumas',3,0,'','','A. Moquin-Tandon','299cab4c-b68e-5690-afe2-d2d779e0f5c8','Helix splendida dumasia A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','splendida','dumasia','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10087','','','Cerithium dumonti Chapuis and Dewalque, 1853',1,'Cerithium dumonti','Cerithium dumonti','Cerithium dumont',2,0,'','','Chapuis|Dewalque','b2730957-5c00-52ae-9d2c-594611a9dc58','Cerithium dumonti Chapuis and Dewalque, 1853','Chapuis and Dewalque, 1853','UNRANKED','','Cerithium','','dumonti','','','',NULL,'','','','','','Chapuis & Dewalque','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10092','','','Arca dumortieri Archiac, 1854',1,'Arca dumortieri','Arca dumortieri','Arca dumortier',2,0,'','','Archiac','72908cdf-cbf5-58ff-8157-8c7a3037f939','Arca dumortieri Archiac, 1854','Archiac, 1854','UNRANKED','','Arca','','dumortieri','','','',NULL,'','','','','','Archiac','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10097','','','Triton dumortieri Baudon, 1853',1,'Triton dumortieri','Triton dumortieri','Triton dumortier',2,0,'','','Baudon','3e7a3c75-f58c-509a-89d5-4ac4d1acc68d','Triton dumortieri Baudon, 1853','Baudon, 1853','UNRANKED','','Triton','','dumortieri','','','',NULL,'','','','','','Baudon','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10103','','','Bythinia brevis dunalina A. Moquin-Tandon, 1855',1,'Bythinia brevis dunalina','Bythinia brevis dunalina','Bythinia breu dunalin',3,0,'','','A. Moquin-Tandon','c987fc01-e76b-5293-825e-85537b35d6ec','Bythinia brevis dunalina A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Bythinia','','brevis','dunalina','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10106','','','Achatina dunkeri Pfeiffer, 1851',1,'Achatina dunkeri','Achatina dunkeri','Achatina dunker',2,0,'','','Pfeiffer','2ab12e0b-33c5-5608-b672-a07a4aa07dcd','Achatina dunkeri Pfeiffer, 1851','Pfeiffer, 1851','UNRANKED','','Achatina','','dunkeri','','','',NULL,'','','','','','Pfeiffer','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10109','','','Avicula dunkeri Terquem, 1855',1,'Avicula dunkeri','Avicula dunkeri','Avicula dunker',2,0,'','','Terquem','a567867b-19e2-5623-9e01-eb34fcecd3bd','Avicula dunkeri Terquem, 1855','Terquem, 1855','UNRANKED','','Avicula','','dunkeri','','','',NULL,'','','','','','Terquem','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10115','','','Cyclotus dunkeri Pfeiffer, 1857',1,'Cyclotus dunkeri','Cyclotus dunkeri','Cyclotus dunker',2,0,'','','Pfeiffer','dc3c4f91-31d6-519c-8fbb-5f249992c590','Cyclotus dunkeri Pfeiffer, 1857','Pfeiffer, 1857','UNRANKED','','Cyclotus','','dunkeri','','','',NULL,'','','','','','Pfeiffer','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10119','','','Ennea dunkeri Pfeiffer, 1855',1,'Ennea dunkeri','Ennea dunkeri','Ennea dunker',2,0,'','','Pfeiffer','e360ccd9-28c4-5af3-87e0-b8ad4669ca7b','Ennea dunkeri Pfeiffer, 1855','Pfeiffer, 1855','UNRANKED','','Ennea','','dunkeri','','','',NULL,'','','','','','Pfeiffer','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10122','','','Helix dunkeri Pfeiffer, 1852',1,'Helix dunkeri','Helix dunkeri','Helix dunker',2,0,'','','Pfeiffer','f1bdb8bc-059c-5315-b53a-374319305c93','Helix dunkeri Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Helix','','dunkeri','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10127','','','Paludinella dunkeri Frauenfeld, 1863',1,'Paludinella dunkeri','Paludinella dunkeri','Paludinella dunker',2,0,'','','Frauenfeld','3a8c5bc6-e642-5605-9493-9f4ed50270d8','Paludinella dunkeri Frauenfeld, 1863','Frauenfeld, 1863','UNRANKED','','Paludinella','','dunkeri','','','',NULL,'','','','','','Frauenfeld','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10135','','','Terebra dunkeri Deshayes, 1859',1,'Terebra dunkeri','Terebra dunkeri','Terebra dunker',2,0,'','','Deshayes','ceca720f-91d9-5571-b91d-852e87e64202','Terebra dunkeri Deshayes, 1859','Deshayes, 1859','UNRANKED','','Terebra','','dunkeri','','','',NULL,'','','','','','Deshayes','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10139','','','Turritella dunkeri Terquem, 1855',1,'Turritella dunkeri','Turritella dunkeri','Turritella dunker',2,0,'','','Terquem','b90b523f-2c65-5d0e-a931-71dae5ae790c','Turritella dunkeri Terquem, 1855','Terquem, 1855','UNRANKED','','Turritella','','dunkeri','','','',NULL,'','','','','','Terquem','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10146','','','Olivia duplex Ryckholt, 1861',1,'Olivia duplex','Olivia duplex','Olivia duplex',2,0,'','','Ryckholt','e5b2ad7d-8f04-5f9b-b3e1-adbae4ae90b1','Olivia duplex Ryckholt, 1861','Ryckholt, 1861','UNRANKED','','Olivia','','duplex','','','',NULL,'','','','','','Ryckholt','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10150','','','Semele duplicata Gould, 1861',1,'Semele duplicata','Semele duplicata','Semele duplicat',2,0,'','','Gould','88393503-343d-577b-99df-a436855dd1b2','Semele duplicata Gould, 1861','Gould, 1861','UNRANKED','','Semele','','duplicata','','','',NULL,'','','','','','Gould','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10156','','','Ziziphinus duplicatus A. Adams, 1851',1,'Ziziphinus duplicatus','Ziziphinus duplicatus','Ziziphinus duplicat',2,0,'','','A. Adams','6d4a4802-b836-5880-b92f-59983dbfbafc','Ziziphinus duplicatus A. Adams, 1851','A. Adams, 1851','UNRANKED','','Ziziphinus','','duplicatus','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10163','','','Pisidium dupuyanum Normand, 1854',1,'Pisidium dupuyanum','Pisidium dupuyanum','Pisidium dupuyan',2,0,'','','Normand','862ad9ec-4b7a-56db-a48e-c27fe3b46697','Pisidium dupuyanum Normand, 1854','Normand, 1854','UNRANKED','','Pisidium','','dupuyanum','','','',NULL,'','','','','','Normand','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10169','','','Melania dura Reeve, 1860',1,'Melania dura','Melania dura','Melania dur',2,0,'','','Reeve','fbb266e8-c172-5fea-9d1a-7e019eecc8c7','Melania dura Reeve, 1860','Reeve, 1860','UNRANKED','','Melania','','dura','','','',NULL,'','','','','','Reeve','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10177','','','Helix dussertiana Bourguignat, 1867',1,'Helix dussertiana','Helix dussertiana','Helix dussertian',2,0,'','','Bourguignat','50960c3b-17da-5b72-a135-87e33a032cb3','Helix dussertiana Bourguignat, 1867','Bourguignat, 1867','UNRANKED','','Helix','','dussertiana','','','',NULL,'','','','','','Bourguignat','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10183','','','Auricula dutemplei Deshayes, 1863',1,'Auricula dutemplei','Auricula dutemplei','Auricula dutemple',2,0,'','','Deshayes','1c99c731-55a0-5e4f-88ad-0f1f797eca12','Auricula dutemplei Deshayes, 1863','Deshayes, 1863','UNRANKED','','Auricula','','dutemplei','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10185','','','Cyrena dutemplei Deshayes, 1857',1,'Cyrena dutemplei','Cyrena dutemplei','Cyrena dutemple',2,0,'','','Deshayes','512623e2-dcf9-5262-8f90-d09305864b22','Cyrena dutemplei Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cyrena','','dutemplei','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10189','','','Neritina dutemplei Deshayes, 1864',1,'Neritina dutemplei','Neritina dutemplei','Neritina dutemple',2,0,'','','Deshayes','3121c861-484e-5bfa-bfcf-ea02fa3a9c1a','Neritina dutemplei Deshayes, 1864','Deshayes, 1864','UNRANKED','','Neritina','','dutemplei','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10192','','','Psammobia dutemplei Deshayes, 1857',1,'Psammobia dutemplei','Psammobia dutemplei','Psammobia dutemple',2,0,'','','Deshayes','2b764ac7-47be-5622-a041-b3a2b71823a7','Psammobia dutemplei Deshayes, 1857','Deshayes, 1857','UNRANKED','','Psammobia','','dutemplei','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10195','','','Janira dutrugei Coquand, 1862',1,'Janira dutrugei','Janira dutrugei','Janira dutruge',2,0,'','','Coquand','7a9d83b9-ad2e-5fb9-84bc-c15ebd3a35d3','Janira dutrugei Coquand, 1862','Coquand, 1862','UNRANKED','','Janira','','dutrugei','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10199','','','Conus duvali Bernardi, 1862',1,'Conus duvali','Conus duvali','Conus duual',2,0,'','','Bernardi','24c8a911-57a9-5d89-98d6-8284325ae71a','Conus duvali Bernardi, 1862','Bernardi, 1862','UNRANKED','','Conus','','duvali','','','',NULL,'','','','','','Bernardi','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10207','','','Nanina dvitija O. Semper, 1866',1,'Nanina dvitija','Nanina dvitija','Nanina duiti',2,0,'','','O. Semper','4b5e0f80-5689-5f27-9b95-d5648982459b','Nanina dvitija O. Semper, 1866','O. Semper, 1866','UNRANKED','','Nanina','','dvitija','','','',NULL,'','','','','','O. Semper','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10216','','','Ampullaria dysoni Hanley, 1854',1,'Ampullaria dysoni','Ampullaria dysoni','Ampullaria dyson',2,0,'','','Hanley','534bb3c6-92dd-5611-b505-4d261af2d118','Ampullaria dysoni Hanley, 1854','Hanley, 1854','UNRANKED','','Ampullaria','','dysoni','','','',NULL,'','','','','','Hanley','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10222','','','Unio dysonii Lea, 1859',1,'Unio dysonii','Unio dysonii','Unio dyson',2,0,'','','Lea','ece1c366-d3fd-5b65-9624-62a1388dd748','Unio dysonii Lea, 1859','Lea, 1859','UNRANKED','','Unio','','dysonii','','','',NULL,'','','','','','Lea','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10225','','','Patella earlii Reeve, 1855',1,'Patella earlii','Patella earlii','Patella earl',2,0,'','','Reeve','6a2bee53-b1ad-5dc5-afb9-76cceae74121','Patella earlii Reeve, 1855','Reeve, 1855','UNRANKED','','Patella','','earlii','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10232','','','Yoldia eborea Conrad, 1862',1,'Yoldia eborea','Yoldia eborea','Yoldia ebore',2,0,'','','Conrad','aef40c94-e4e3-5c3a-96b3-458a2fd5b646','Yoldia eborea Conrad, 1862','Conrad, 1862','UNRANKED','','Yoldia','','eborea','','','',NULL,'','','','','','Conrad','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10239','','','Caecilianella eburnea Bourguignat, 1861',1,'Caecilianella eburnea','Caecilianella eburnea','Caecilianella eburne',2,0,'','','Bourguignat','9c1c1c9b-4578-5b86-b7ca-46478c49549b','Caecilianella eburnea Bourguignat, 1861','Bourguignat, 1861','UNRANKED','','Caecilianella','','eburnea','','','',NULL,'','','','','','Bourguignat','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10244','','','Eulima eburnea A. Adams, 1861',1,'Eulima eburnea','Eulima eburnea','Eulima eburne',2,0,'','','A. Adams','0479d2d4-355c-5aa8-9317-515a27ba0e85','Eulima eburnea A. Adams, 1861','A. Adams, 1861','UNRANKED','','Eulima','','eburnea','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10251','','','Streptaxis eburnea Pfeiffer, 1861',1,'Streptaxis eburnea','Streptaxis eburnea','Streptaxis eburne',2,0,'','','Pfeiffer','9ff5ade9-cd13-56e7-bac3-fb3250c2d257','Streptaxis eburnea Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Streptaxis','','eburnea','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10255','','','Tellina (Angulus) eburneopsis Conrad, 1865',1,'Tellina eburneopsis','Tellina eburneopsis','Tellina eburneops',2,0,'','','Conrad','58438c3b-4026-51e4-aa2e-711e5ea16f8a','Tellina (Angulus) eburneopsis Conrad, 1865','Conrad, 1865','UNRANKED','','Tellina','Angulus','eburneopsis','','','',NULL,'','','','','','Conrad','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10259','','','Stylifer eburneus Deshayes, 1863',1,'Stylifer eburneus','Stylifer eburneus','Stylifer eburne',2,0,'','','Deshayes','807f5736-c4c3-5c4c-a369-a084f05dfb8e','Stylifer eburneus Deshayes, 1863','Deshayes, 1863','UNRANKED','','Stylifer','','eburneus','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10263','','','Castalia ecarinata Mousson, 1869',1,'Castalia ecarinata','Castalia ecarinata','Castalia ecarinat',2,0,'','','Mousson','e10968c9-14b5-56ff-824a-f95a58d261d8','Castalia ecarinata Mousson, 1869','Mousson, 1869','UNRANKED','','Castalia','','ecarinata','','','',NULL,'','','','','','Mousson','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10266','','','Pleurotoma ecaudata Deshayes, 1865',1,'Pleurotoma ecaudata','Pleurotoma ecaudata','Pleurotoma ecaudat',2,0,'','','Deshayes','fb4345cf-875c-5288-a741-f4af68c07146','Pleurotoma ecaudata Deshayes, 1865','Deshayes, 1865','UNRANKED','','Pleurotoma','','ecaudata','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10272','','','Nassa echinata A. Adams, 1851',1,'Nassa echinata','Nassa echinata','Nassa echinat',2,0,'','','A. Adams','dcfe37de-ba96-59b4-a0d4-adea130fa394','Nassa echinata A. Adams, 1851','A. Adams, 1851','UNRANKED','','Nassa','','echinata','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10279','','','Chondropoma echinulatum Wright, in Pfeiffer, 1863',2,'Chondropoma echinulatum','Chondropoma echinulatum','Chondropoma echinulat',2,0,'','','Wright|Pfeiffer','d0893e1d-e776-5424-a289-75b2ea23e0e2','Chondropoma echinulatum Wright, in Pfeiffer, 1863','Wright, in Pfeiffer, 1863','UNRANKED','','Chondropoma','','echinulatum','','','',NULL,'','','','','','Wright','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10283','','','Cyclostoma (Choanopoma) echinus Wright, in Pfeiffer, 1864',2,'Cyclostoma echinus','Cyclostoma echinus','Cyclostoma echin',2,0,'','','Wright|Pfeiffer','9d90abd6-f01e-5324-9c82-090ac0f61cdb','Cyclostoma (Choanopoma) echinus Wright, in Pfeiffer, 1864','Wright, in Pfeiffer, 1864','UNRANKED','','Cyclostoma','Choanopoma','echinus','','','',NULL,'','','','','','Wright','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10285','','','Pupa ectina Bourguignat, 1862',1,'Pupa ectina','Pupa ectina','Pupa ectin',2,0,'','','Bourguignat','27f041a9-0328-5cad-80dc-c899c0a1e767','Pupa ectina Bourguignat, 1862','Bourguignat, 1862','UNRANKED','','Pupa','','ectina','','','',NULL,'','','','','','Bourguignat','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10290','','','Avellana edentula Eichwald, 1868',1,'Avellana edentula','Avellana edentula','Avellana edentul',2,0,'','','Eichwald','9db36f13-a514-5642-8c3e-d39b67a7b73e','Avellana edentula Eichwald, 1868','Eichwald, 1868','UNRANKED','','Avellana','','edentula','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10291','','','Cypricardia edentula Deshayes, 1858',1,'Cypricardia edentula','Cypricardia edentula','Cypricardia edentul',2,0,'','','Deshayes','81e71a8d-405c-5ab8-8958-8378cc6afd22','Cypricardia edentula Deshayes, 1858','Deshayes, 1858','UNRANKED','','Cypricardia','','edentula','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10296','','','Pupa muscorum edentula A. Moquin-Tandon, 1855',1,'Pupa muscorum edentula','Pupa muscorum edentula','Pupa muscor edentul',3,0,'','','A. Moquin-Tandon','1014951e-3934-5fa4-a951-e114a5df34df','Pupa muscorum edentula A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Pupa','','muscorum','edentula','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10299','','','Clanculus edentulus A. Adams, 1851',1,'Clanculus edentulus','Clanculus edentulus','Clanculus edentul',2,0,'','','A. Adams','9c94b501-23ea-59b3-8288-c4f37ca6e3e0','Clanculus edentulus A. Adams, 1851','A. Adams, 1851','UNRANKED','','Clanculus','','edentulus','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10303','','','Pecten edgecomensis Conrad, 1862',1,'Pecten edgecomensis','Pecten edgecomensis','Pecten edgecomens',2,0,'','','Conrad','493a86b0-2dfc-5132-a301-aa80399a9438','Pecten edgecomensis Conrad, 1862','Conrad, 1862','UNRANKED','','Pecten','','edgecomensis','','','',NULL,'','','','','','Conrad','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10311','','','Sanguinolaria edvardsii Morris, 1852',1,'Sanguinolaria edvardsii','Sanguinolaria edvardsii','Sanguinolaria eduards',2,0,'','','Morris','b8eceb19-1f99-5821-a0b7-f328a69cf4a4','Sanguinolaria edvardsii Morris, 1852','Morris, 1852','UNRANKED','','Sanguinolaria','','edvardsii','','','',NULL,'','','','','','Morris','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10316','','','Borsonia edwardsi Deshayes, 1865',1,'Borsonia edwardsi','Borsonia edwardsi','Borsonia edwards',2,0,'','','Deshayes','94905c74-477e-5b5d-8b71-fc8951f111f9','Borsonia edwardsi Deshayes, 1865','Deshayes, 1865','UNRANKED','','Borsonia','','edwardsi','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10322','','','Fissurella edwardsii J. Sowerby, in Dixon, 1850',2,'Fissurella edwardsii','Fissurella edwardsii','Fissurella edwards',2,0,'','','J. Sowerby|Dixon','8eb3ffa8-24c6-5b5b-b50d-44a3b906d30b','Fissurella edwardsii J. Sowerby, in Dixon, 1850','J. Sowerby, in Dixon, 1850','UNRANKED','','Fissurella','','edwardsii','','','',NULL,'','','','','','J. Sowerby','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10329','','','Tellina edwardsi Deshayes, 1857',1,'Tellina edwardsi','Tellina edwardsi','Tellina edwards',2,0,'','','Deshayes','b5d322eb-0278-523a-b157-d1a3db233f22','Tellina edwardsi Deshayes, 1857','Deshayes, 1857','UNRANKED','','Tellina','','edwardsi','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10337','','','Eolis effulgens Kelaart, 1859',1,'Eolis effulgens','Eolis effulgens','Eolis effulgens',2,0,'','','Kelaart','ac82bafb-b1f9-544b-a95d-c947800fa1ad','Eolis effulgens Kelaart, 1859','Kelaart, 1859','UNRANKED','','Eolis','','effulgens','','','',NULL,'','','','','','Kelaart','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10344','','','Dunkeria effusa Gould, 1861',1,'Dunkeria effusa','Dunkeria effusa','Dunkeria effus',2,0,'','','Gould','a3fc3066-791d-524b-9d7a-fe32813e1f87','Dunkeria effusa Gould, 1861','Gould, 1861','UNRANKED','','Dunkeria','','effusa','','','',NULL,'','','','','','Gould','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10347','','','Lacuna porrecta effusa P. Carpenter, 1864',1,'Lacuna porrecta effusa','Lacuna porrecta effusa','Lacuna porrect effus',3,0,'','','P. Carpenter','731544a2-ee06-50f8-94b2-4ae95b7d2242','Lacuna porrecta effusa P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Lacuna','','porrecta','effusa','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10351','','','Rissoina effusa Mörch, 1860',1,'Rissoina effusa','Rissoina effusa','Rissoina effus',2,0,'','','Mörch','76afd899-5beb-5ac6-ade2-ee4f38c8d9a0','Rissoina effusa Mörch, 1860','Mörch, 1860','UNRANKED','','Rissoina','','effusa','','','',NULL,'','','','','','Mörch','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10352','','','Succinea effusa Shuttleworth, in Pfeiffer, 1853',2,'Succinea effusa','Succinea effusa','Succinea effus',2,0,'','','Shuttleworth|Pfeiffer','0c058093-f352-5468-bf43-02361ad66a07','Succinea effusa Shuttleworth, in Pfeiffer, 1853','Shuttleworth, in Pfeiffer, 1853','UNRANKED','','Succinea','','effusa','','','',NULL,'','','','','','Shuttleworth','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10357','','','Amnicola egena Gould, 1851',1,'Amnicola egena','Amnicola egena','Amnicola egen',2,0,'','','Gould','f185ab56-289b-590c-ae92-6a21b18746d0','Amnicola egena Gould, 1851','Gould, 1851','UNRANKED','','Amnicola','','egena','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10362','','','Cardium egmontianum Shuttleworth, 1856',1,'Cardium egmontianum','Cardium egmontianum','Cardium egmontian',2,0,'','','Shuttleworth','0d4104a5-c61d-5597-a597-637be345f114','Cardium egmontianum Shuttleworth, 1856','Shuttleworth, 1856','UNRANKED','','Cardium','','egmontianum','','','',NULL,'','','','','','Shuttleworth','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10364','','','Frembleya egregia H. Adams, 1866',1,'Frembleya egregia','Frembleya egregia','Frembleya egreg',2,0,'','','H. Adams','a1a3af25-c67c-5bf0-8481-09e5aa6d29d6','Frembleya egregia H. Adams, 1866','H. Adams, 1866','UNRANKED','','Frembleya','','egregia','','','',NULL,'','','','','','H. Adams','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10369','','','Cyclostoma egregium Gundlach, 1856',1,'Cyclostoma egregium','Cyclostoma egregium','Cyclostoma egregi',2,0,'','','Gundlach','35f4c47c-e317-59ee-bf6a-219458673ca9','Cyclostoma egregium Gundlach, 1856','Gundlach, 1856','UNRANKED','','Cyclostoma','','egregium','','','',NULL,'','','','','','Gundlach','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10374','','','Crenella ehrenbergi Issel, 1869',1,'Crenella ehrenbergi','Crenella ehrenbergi','Crenella ehrenberg',2,0,'','','Issel','03cd734e-0fc2-50a8-9633-7eba303e1743','Crenella ehrenbergi Issel, 1869','Issel, 1869','UNRANKED','','Crenella','','ehrenbergi','','','',NULL,'','','','','','Issel','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10376','','','Krynickillus eichealdii Kaleniczenko, 1851',1,'Krynickillus eichealdii','Krynickillus eichealdii','Krynickillus eicheald',2,0,'','','Kaleniczenko','fa026ef4-878b-5caf-8bb4-9015ea71f7d8','Krynickillus eichealdii Kaleniczenko, 1851','Kaleniczenko, 1851','UNRANKED','','Krynickillus','','eichealdii','','','',NULL,'','','','','','Kaleniczenko','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10382','','','Coralliophila elaborata H. Adams and A. Adams, 1863',1,'Coralliophila elaborata','Coralliophila elaborata','Coralliophila elaborat',2,0,'','','H. Adams|A. Adams','49150864-751b-54d2-a6e9-2f1ff461657b','Coralliophila elaborata H. Adams and A. Adams, 1863','H. Adams and A. Adams, 1863','UNRANKED','','Coralliophila','','elaborata','','','',NULL,'','','','','','H. Adams & A. Adams','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10391','','','Emarginula fissura elata Jeffreys, 1865',1,'Emarginula fissura elata','Emarginula fissura elata','Emarginula fissur elat',3,0,'','','Jeffreys','8cae8eed-7467-5077-89ef-2fdbd55e6137','Emarginula fissura elata Jeffreys, 1865','Jeffreys, 1865','UNRANKED','','Emarginula','','fissura','elata','','',NULL,'','','','','','Jeffreys','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10394','','','Limnaea elata Deshayes, 1863',1,'Limnaea elata','Limnaea elata','Limnaea elat',2,0,'','','Deshayes','db13152f-260c-5521-9598-11f62ac91f71','Limnaea elata Deshayes, 1863','Deshayes, 1863','UNRANKED','','Limnaea','','elata','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10397','','','Odostomia unidentata elata Jeffreys, 1867',1,'Odostomia unidentata elata','Odostomia unidentata elata','Odostomia unidentat elat',3,0,'','','Jeffreys','e243ebeb-cb5f-5e6d-8089-d3969a3bfd50','Odostomia unidentata elata Jeffreys, 1867','Jeffreys, 1867','UNRANKED','','Odostomia','','unidentata','elata','','',NULL,'','','','','','Jeffreys','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10402','','','Stomatella elata H. Adams and A. Adams, 1863',1,'Stomatella elata','Stomatella elata','Stomatella elat',2,0,'','','H. Adams|A. Adams','a1f34919-6f45-5ec7-9823-f610dfa3da1a','Stomatella elata H. Adams and A. Adams, 1863','H. Adams and A. Adams, 1863','UNRANKED','','Stomatella','','elata','','','',NULL,'','','','','','H. Adams & A. Adams','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10409','','','Helix terrestris elatior Bourguignat, 1864',1,'Helix terrestris elatior','Helix terrestris elatior','Helix terrestr elatior',3,0,'','','Bourguignat','99db8979-cb1f-5d44-b164-ec72df8f47d2','Helix terrestris elatior Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','terrestris','elatior','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10412','','','Natica elatior Coquand, 1862',1,'Natica elatior','Natica elatior','Natica elatior',2,0,'','','Coquand','02eeccea-7bb3-588a-a376-cd94f883abcd','Natica elatior Coquand, 1862','Coquand, 1862','UNRANKED','','Natica','','elatior','','','',NULL,'','','','','','Coquand','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10416','','','Turbo elatus Fuchs, 1870',1,'Turbo elatus','Turbo elatus','Turbo elat',2,0,'','','Fuchs','7a29064c-564f-5949-8fbf-d07d47abbb73','Turbo elatus Fuchs, 1870','Fuchs, 1870','UNRANKED','','Turbo','','elatus','','','',NULL,'','','','','','Fuchs','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10422','','','Diala electrina P. Carpenter, 1864',1,'Diala electrina','Diala electrina','Diala electrin',2,0,'','','P. Carpenter','993aabc0-c197-5527-948e-87334796bf40','Diala electrina P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Diala','','electrina','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10429','','','Unio electrinus G. Sowerby, 1865',1,'Unio electrinus','Unio electrinus','Unio electrin',2,0,'','','G. Sowerby','10fd9ea8-0e08-507c-8cff-438960b55b12','Unio electrinus G. Sowerby, 1865','G. Sowerby, 1865','UNRANKED','','Unio','','electrinus','','','',NULL,'','','','','','G. Sowerby','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10435','','','Anculosa elegans Anthony, 1860',1,'Anculosa elegans','Anculosa elegans','Anculosa elegans',2,0,'','','Anthony','cd417da8-c18c-55c4-8589-b9effc41aad0','Anculosa elegans Anthony, 1860','Anthony, 1860','UNRANKED','','Anculosa','','elegans','','','',NULL,'','','','','','Anthony','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10441','','','Caecum elegans Folin, 1867',1,'Caecum elegans','Caecum elegans','Caecum elegans',2,0,'','','Folin','5a175d06-948f-54a3-8add-c5631cab369e','Caecum elegans Folin, 1867','Folin, 1867','UNRANKED','','Caecum','','elegans','','','',NULL,'','','','','','Folin','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10445','','','Clausilia elegans Bielz, 1852',1,'Clausilia elegans','Clausilia elegans','Clausilia elegans',2,0,'','','Bielz','bed272ef-c037-5f7c-8384-8e10eac76457','Clausilia elegans Bielz, 1852','Bielz, 1852','UNRANKED','','Clausilia','','elegans','','','',NULL,'','','','','','Bielz','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10452','','','Eulimella elegans Issel, 1869',1,'Eulimella elegans','Eulimella elegans','Eulimella elegans',2,0,'','','Issel','fdb74357-73ee-5e30-bf74-b0b95c31561a','Eulimella elegans Issel, 1869','Issel, 1869','UNRANKED','','Eulimella','','elegans','','','',NULL,'','','','','','Issel','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10459','','','Helix stauropolitana elegans Issel, 1865',1,'Helix stauropolitana elegans','Helix stauropolitana elegans','Helix stauropolitan elegans',3,0,'','','Issel','53c4f831-b959-5f4a-a29e-3eac2d6f5844','Helix stauropolitana elegans Issel, 1865','Issel, 1865','UNRANKED','','Helix','','stauropolitana','elegans','','',NULL,'','','','','','Issel','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10465','','','Limnaea truncatula elegans Jeffreys, 1862',1,'Limnaea truncatula elegans','Limnaea truncatula elegans','Limnaea truncatul elegans',3,0,'','','Jeffreys','2bb2a766-1735-592e-b2b6-b3c73d1389af','Limnaea truncatula elegans Jeffreys, 1862','Jeffreys, 1862','UNRANKED','','Limnaea','','truncatula','elegans','','',NULL,'','','','','','Jeffreys','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10467','','','Loxonema elegans Hörnes, 1855',1,'Loxonema elegans','Loxonema elegans','Loxonema elegans',2,0,'','','Hörnes','abc542e9-dd05-5783-a36a-72191dbe0799','Loxonema elegans Hörnes, 1855','Hörnes, 1855','UNRANKED','','Loxonema','','elegans','','','',NULL,'','','','','','Hörnes','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10472','','','Mathilda elegans Folin, 1870',1,'Mathilda elegans','Mathilda elegans','Mathilda elegans',2,0,'','','Folin','e792eb24-0edd-598e-8715-599e60a441ac','Mathilda elegans Folin, 1870','Folin, 1870','UNRANKED','','Mathilda','','elegans','','','',NULL,'','','','','','Folin','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10474','','','Melania elegans Mayer, in Gümbel, 1861',2,'Melania elegans','Melania elegans','Melania elegans',2,0,'','','Mayer|Gümbel','4f023fdc-5e1b-5e95-bb0f-fbc2b9ce295c','Melania elegans Mayer, in Gümbel, 1861','Mayer, in Gümbel, 1861','UNRANKED','','Melania','','elegans','','','',NULL,'','','','','','Mayer','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10482','','','Obeliscus elegans A. Adams, 1854',1,'Obeliscus elegans','Obeliscus elegans','Obeliscus elegans',2,0,'','','A. Adams','fe49c660-55b5-5440-b8ff-0bd61c56ef85','Obeliscus elegans A. Adams, 1854','A. Adams, 1854','UNRANKED','','Obeliscus','','elegans','','','',NULL,'','','','','','A. Adams','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10485','','','Phasianella elegans Morris and Lycett, 1854',1,'Phasianella elegans','Phasianella elegans','Phasianella elegans',2,0,'','','Morris|Lycett','f7ffa5cb-4917-5bc2-8ac4-bb58b557de67','Phasianella elegans Morris and Lycett, 1854','Morris and Lycett, 1854','UNRANKED','','Phasianella','','elegans','','','',NULL,'','','','','','Morris & Lycett','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10495','','','Rostellaria elegans Loriol, 1861',1,'Rostellaria elegans','Rostellaria elegans','Rostellaria elegans',2,0,'','','Loriol','ee0960f1-b72c-5222-bdba-36d0ff307427','Rostellaria elegans Loriol, 1861','Loriol, 1861','UNRANKED','','Rostellaria','','elegans','','','',NULL,'','','','','','Loriol','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10498','','','Stagnicola elegans Leach, in J. Gray, 1852',2,'Stagnicola elegans','Stagnicola elegans','Stagnicola elegans',2,0,'','','Leach|J. Gray','27bae9a5-c2fb-51ef-a5cd-046e23ca40e3','Stagnicola elegans Leach, in J. Gray, 1852','Leach, in J. Gray, 1852','UNRANKED','','Stagnicola','','elegans','','','',NULL,'','','','','','Leach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10504','','','Trigonia elegans Baily, 1855',1,'Trigonia elegans','Trigonia elegans','Trigonia elegans',2,0,'','','Baily','62fc1ead-29b8-571a-abb7-2192340e7f39','Trigonia elegans Baily, 1855','Baily, 1855','UNRANKED','','Trigonia','','elegans','','','',NULL,'','','','','','Baily','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10509','','','Hydrobia elegantissima Frauenfeld, 1864',1,'Hydrobia elegantissima','Hydrobia elegantissima','Hydrobia elegantissim',2,0,'','','Frauenfeld','a6d99a46-f0ad-55e8-afe4-f40bfd0fc3bf','Hydrobia elegantissima Frauenfeld, 1864','Frauenfeld, 1864','UNRANKED','','Hydrobia','','elegantissima','','','',NULL,'','','','','','Frauenfeld','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10515','','','Turbo elegantissima C. Moore, 1866',1,'Turbo elegantissima','Turbo elegantissima','Turbo elegantissim',2,0,'','','C. Moore','87f5da8b-777c-5653-bf0e-0fbb958cba23','Turbo elegantissima C. Moore, 1866','C. Moore, 1866','UNRANKED','','Turbo','','elegantissima','','','',NULL,'','','','','','C. Moore','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10519','','','Trochus elegantissimus Orbigny, 1852',1,'Trochus elegantissimus','Trochus elegantissimus','Trochus elegantissim',2,0,'','','Orbigny','b7f68bec-8fbc-5e81-8df7-2dcacbb99b70','Trochus elegantissimus Orbigny, 1852','Orbigny, 1852','UNRANKED','','Trochus','','elegantissimus','','','',NULL,'','','','','','Orbigny','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10521','','','Artemis elegantula Sharpe, 1850',1,'Artemis elegantula','Artemis elegantula','Artemis elegantul',2,0,'','','Sharpe','62b72879-5ae8-5352-ba3d-4cfd3c897699','Artemis elegantula Sharpe, 1850','Sharpe, 1850','UNRANKED','','Artemis','','elegantula','','','',NULL,'','','','','','Sharpe','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10527','','','Cytherea elegantula Deshayes, 1857',1,'Cytherea elegantula','Cytherea elegantula','Cytherea elegantul',2,0,'','','Deshayes','985668cd-d867-59b0-94eb-2dceabda01f7','Cytherea elegantula Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cytherea','','elegantula','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10532','','','Nerinea elegantula Piette, 1855',1,'Nerinea elegantula','Nerinea elegantula','Nerinea elegantul',2,0,'','','Piette','d2e85ea1-6b41-517c-9c66-e4f866598477','Nerinea elegantula Piette, 1855','Piette, 1855','UNRANKED','','Nerinea','','elegantula','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10537','','','Xylophaga elegantula Meek and Hayden, 1857',1,'Xylophaga elegantula','Xylophaga elegantula','Xylophaga elegantul',2,0,'','','Meek|Hayden','aaf5d4ea-0e47-5a47-b348-331af0156cd2','Xylophaga elegantula Meek and Hayden, 1857','Meek and Hayden, 1857','UNRANKED','','Xylophaga','','elegantula','','','',NULL,'','','','','','Meek & Hayden','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10541','','','Cerithium elegantulum Piette, 1857',1,'Cerithium elegantulum','Cerithium elegantulum','Cerithium elegantul',2,0,'','','Piette','c0fb1b46-9803-5c37-8143-e69beda5b74f','Cerithium elegantulum Piette, 1857','Piette, 1857','UNRANKED','','Cerithium','','elegantulum','','','',NULL,'','','','','','Piette','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10544','','','Modiolopsis elegantulus Sharpe, 1853',1,'Modiolopsis elegantulus','Modiolopsis elegantulus','Modiolopsis elegantul',2,0,'','','Sharpe','1802e3cb-d0bd-5f4b-893c-224446f82007','Modiolopsis elegantulus Sharpe, 1853','Sharpe, 1853','UNRANKED','','Modiolopsis','','elegantulus','','','',NULL,'','','','','','Sharpe','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10548','','','Ostrea elephantopus J. Sowerby, in Dixon, 1850',2,'Ostrea elephantopus','Ostrea elephantopus','Ostrea elephantop',2,0,'','','J. Sowerby|Dixon','e8a620da-7271-5c09-87d0-a3120f7c83e8','Ostrea elephantopus J. Sowerby, in Dixon, 1850','J. Sowerby, in Dixon, 1850','UNRANKED','','Ostrea','','elephantopus','','','',NULL,'','','','','','J. Sowerby','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10553','','','Dosinia elevata Gabb, 1864',1,'Dosinia elevata','Dosinia elevata','Dosinia eleuat',2,0,'','','Gabb','58ce7be5-b4a2-5f45-97be-2a9ba7a306d4','Dosinia elevata Gabb, 1864','Gabb, 1864','UNRANKED','','Dosinia','','elevata','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10557','','','Tellina elevata G. Sowerby, 1868',1,'Tellina elevata','Tellina elevata','Tellina eleuat',2,0,'','','G. Sowerby','ac16f952-dcda-558e-bb16-15abff2e2147','Tellina elevata G. Sowerby, 1868','G. Sowerby, 1868','UNRANKED','','Tellina','','elevata','','','',NULL,'','','','','','G. Sowerby','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10561','','','Baroda (Icanotia) elicita Stoliczka, 1870',1,'Baroda elicita','Baroda elicita','Baroda elicit',2,0,'','','Stoliczka','94844702-3d67-5edd-bd4a-d298fcc2ea11','Baroda (Icanotia) elicita Stoliczka, 1870','Stoliczka, 1870','UNRANKED','','Baroda','Icanotia','elicita','','','',NULL,'','','','','','Stoliczka','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10564','','','Streptaxis elisa Gould, 1856',1,'Streptaxis elisa','Streptaxis elisa','Streptaxis elis',2,0,'','','Gould','da8a8f5e-f69f-58e1-b230-85220d906c04','Streptaxis elisa Gould, 1856','Gould, 1856','UNRANKED','','Streptaxis','','elisa','','','',NULL,'','','','','','Gould','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10569','','','Trochus elizae C. Moore, 1867',1,'Trochus elizae','Trochus elizae','Trochus eliz',2,0,'','','C. Moore','7ce0b64e-5c05-586b-95bd-4a5468e58b57','Trochus elizae C. Moore, 1867','C. Moore, 1867','UNRANKED','','Trochus','','elizae','','','',NULL,'','','','','','C. Moore','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10570','','','Cancellaria ellapsa Conrad, 1865',1,'Cancellaria ellapsa','Cancellaria ellapsa','Cancellaria ellaps',2,0,'','','Conrad','b162e035-9045-51cb-a444-71c4749a3af5','Cancellaria ellapsa Conrad, 1865','Conrad, 1865','UNRANKED','','Cancellaria','','ellapsa','','','',NULL,'','','','','','Conrad','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10575','','','Goniobasis elliottii Lea, 1862',1,'Goniobasis elliottii','Goniobasis elliottii','Goniobasis elliott',2,0,'','','Lea','5e246df7-a1a1-5562-831f-3937256a3d50','Goniobasis elliottii Lea, 1862','Lea, 1862','UNRANKED','','Goniobasis','','elliottii','','','',NULL,'','','','','','Lea','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10576','','','Helix elliotti Redfield, 1856',1,'Helix elliotti','Helix elliotti','Helix elliott',2,0,'','','Redfield','6e6703b2-b781-50da-9fd4-6baa793db8ca','Helix elliotti Redfield, 1856','Redfield, 1856','UNRANKED','','Helix','','elliotti','','','',NULL,'','','','','','Redfield','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10581','','','Trichotropis ellipsoidea Gould, 1860',1,'Trichotropis ellipsoidea','Trichotropis ellipsoidea','Trichotropis ellipsoide',2,0,'','','Gould','ea73eb72-f5f3-5c72-b425-c911b323f456','Trichotropis ellipsoidea Gould, 1860','Gould, 1860','UNRANKED','','Trichotropis','','ellipsoidea','','','',NULL,'','','','','','Gould','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10582','','','Goniobasis ellipsoides Lea, 1863',1,'Goniobasis ellipsoides','Goniobasis ellipsoides','Goniobasis ellipsoid',2,0,'','','Lea','8c0b6335-5e28-51e1-b95f-a6dee223209b','Goniobasis ellipsoides Lea, 1863','Lea, 1863','UNRANKED','','Goniobasis','','ellipsoides','','','',NULL,'','','','','','Lea','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10587','','','Atys (Sao) elliptica A. Adams, 1862',1,'Atys elliptica','Atys elliptica','Atys elliptic',2,0,'','','A. Adams','1fdac63c-9707-5026-a146-f7b3f83355a5','Atys (Sao) elliptica A. Adams, 1862','A. Adams, 1862','UNRANKED','','Atys','Sao','elliptica','','','',NULL,'','','','','','A. Adams','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10588','','','Clidophorus goldfussii elliptica Schauroth, 1857',1,'Clidophorus goldfussii elliptica','Clidophorus goldfussii elliptica','Clidophorus goldfuss elliptic',3,0,'','','Schauroth','44cf8e67-4067-5d57-a26b-615d074f9b41','Clidophorus goldfussii elliptica Schauroth, 1857','Schauroth, 1857','UNRANKED','','Clidophorus','','goldfussii','elliptica','','',NULL,'','','','','','Schauroth','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10593','','','Edmondia elliptica Winchell, 1863',1,'Edmondia elliptica','Edmondia elliptica','Edmondia elliptic',2,0,'','','Winchell','fac6986b-54ef-5f4d-af64-2b3103c5dd26','Edmondia elliptica Winchell, 1863','Winchell, 1863','UNRANKED','','Edmondia','','elliptica','','','',NULL,'','','','','','Winchell','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10597','','','Melania elliptica Lea, 1861',1,'Melania elliptica','Melania elliptica','Melania elliptic',2,0,'','','Lea','5aabaee3-b266-504d-97ce-c205fd3ad4aa','Melania elliptica Lea, 1861','Lea, 1861','UNRANKED','','Melania','','elliptica','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10603','','','Tornatella elliptica Trask, 1855',1,'Tornatella elliptica','Tornatella elliptica','Tornatella elliptic',2,0,'','','Trask','406526a6-afc5-564e-b1b4-628ff6a20625','Tornatella elliptica Trask, 1855','Trask, 1855','UNRANKED','','Tornatella','','elliptica','','','',NULL,'','','','','','Trask','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10606','','','Melatoma ellipticum Anthony, in Reeve, 1861',2,'Melatoma ellipticum','Melatoma ellipticum','Melatoma elliptic',2,0,'','','Anthony|Reeve','8b5c3f48-3e68-58ef-ba60-175fd67c8315','Melatoma ellipticum Anthony, in Reeve, 1861','Anthony, in Reeve, 1861','UNRANKED','','Melatoma','','ellipticum','','','',NULL,'','','','','','Anthony','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10615','','','Eulima elodia Folin, 1867',1,'Eulima elodia','Eulima elodia','Eulima elod',2,0,'','','Folin','3c4f44db-e8d2-58cb-9425-70441abd14f0','Eulima elodia Folin, 1867','Folin, 1867','UNRANKED','','Eulima','','elodia','','','',NULL,'','','','','','Folin','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10618','','','Anodonta anatina elongata Brot, 1867',1,'Anodonta anatina elongata','Anodonta anatina elongata','Anodonta anatin elongat',3,0,'','','Brot','ee0f27d3-8109-581f-a730-7e2bea36756d','Anodonta anatina elongata Brot, 1867','Brot, 1867','UNRANKED','','Anodonta','','anatina','elongata','','',NULL,'','','','','','Brot','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10621','','','Batissa elongata Prime, 1860',1,'Batissa elongata','Batissa elongata','Batissa elongat',2,0,'','','Prime','910b6e30-8e17-527d-a2f8-7fbbcb51403f','Batissa elongata Prime, 1860','Prime, 1860','UNRANKED','','Batissa','','elongata','','','',NULL,'','','','','','Prime','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10627','','','Clausilia plicata elongata Roffiaen, 1868',1,'Clausilia plicata elongata','Clausilia plicata elongata','Clausilia plicat elongat',3,0,'','','Roffiaen','61ef68df-f032-52fd-b056-869627945995','Clausilia plicata elongata Roffiaen, 1868','Roffiaen, 1868','UNRANKED','','Clausilia','','plicata','elongata','','',NULL,'','','','','','Roffiaen','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10634','','','Dolabella elongata G. Sowerby, 1868',1,'Dolabella elongata','Dolabella elongata','Dolabella elongat',2,0,'','','G. Sowerby','a59b42ea-72a6-5add-88f6-25d5a6d0471e','Dolabella elongata G. Sowerby, 1868','G. Sowerby, 1868','UNRANKED','','Dolabella','','elongata','','','',NULL,'','','','','','G. Sowerby','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10641','','','Limnaea palustris elongata Jeffreys, 1862',1,'Limnaea palustris elongata','Limnaea palustris elongata','Limnaea palustr elongat',3,0,'','','Jeffreys','f03d390b-ef21-5503-a1b7-6dae5631f07c','Limnaea palustris elongata Jeffreys, 1862','Jeffreys, 1862','UNRANKED','','Limnaea','','palustris','elongata','','',NULL,'','','','','','Jeffreys','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10644','','','Mya binghami elongata Jeffreys, 1865',1,'Mya binghami elongata','Mya binghami elongata','Mya bingham elongat',3,0,'','','Jeffreys','7cfb8edd-6ab5-5b41-9ce8-35628fe697e2','Mya binghami elongata Jeffreys, 1865','Jeffreys, 1865','UNRANKED','','Mya','','binghami','elongata','','',NULL,'','','','','','Jeffreys','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10646','','','Natica elongata Michelotti, 1861',1,'Natica elongata','Natica elongata','Natica elongat',2,0,'','','Michelotti','93127eef-9e84-5518-9e62-68f93018ff37','Natica elongata Michelotti, 1861','Michelotti, 1861','UNRANKED','','Natica','','elongata','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10652','','','Pecten opercularis elongata Jeffreys, 1863',1,'Pecten opercularis elongata','Pecten opercularis elongata','Pecten opercular elongat',3,0,'','','Jeffreys','681ae7c9-a83d-59d1-8e35-11fefc36fc90','Pecten opercularis elongata Jeffreys, 1863','Jeffreys, 1863','UNRANKED','','Pecten','','opercularis','elongata','','',NULL,'','','','','','Jeffreys','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10657','','','Posidonomya elongata Fried. Roemer, 1850',1,'Posidonomya elongata','Posidonomya elongata','Posidonomya elongat',2,0,'','','Fried. Roemer','6ec3f758-13c3-5863-8452-309969dc4f84','Posidonomya elongata Fried. Roemer, 1850','Fried. Roemer, 1850','UNRANKED','','Posidonomya','','elongata','','','',NULL,'','','','','','Fried. Roemer','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10667','','','Rissoa elongata Piette, 1857',1,'Rissoa elongata','Rissoa elongata','Rissoa elongat',2,0,'','','Piette','4a298267-3937-5cdd-8246-c8a0f5f0da1a','Rissoa elongata Piette, 1857','Piette, 1857','UNRANKED','','Rissoa','','elongata','','','',NULL,'','','','','','Piette','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10670','','','Tapes virgineus elongata Jeffreys, 1863',1,'Tapes virgineus elongata','Tapes virgineus elongata','Tapes uirgine elongat',3,0,'','','Jeffreys','0e46db1f-6213-5508-acd5-721d16a56b10','Tapes virgineus elongata Jeffreys, 1863','Jeffreys, 1863','UNRANKED','','Tapes','','virgineus','elongata','','',NULL,'','','','','','Jeffreys','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10673','','','Trigonia costata elongata Morris and Lycett, 1853',1,'Trigonia costata elongata','Trigonia costata elongata','Trigonia costat elongat',3,0,'','','Morris|Lycett','6e01d23c-1d01-5219-a57a-22cdb32241cc','Trigonia costata elongata Morris and Lycett, 1853','Morris and Lycett, 1853','UNRANKED','','Trigonia','','costata','elongata','','',NULL,'','','','','','Morris & Lycett','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10679','','','Physa elongatina Lewis, 1855',1,'Physa elongatina','Physa elongatina','Physa elongatin',2,0,'','','Lewis','e6eddfd7-5556-5fd5-85e4-72e9333f8473','Physa elongatina Lewis, 1855','Lewis, 1855','UNRANKED','','Physa','','elongatina','','','',NULL,'','','','','','Lewis','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10683','','','Cerithium elongatum G. Sowerby, 1855',1,'Cerithium elongatum','Cerithium elongatum','Cerithium elongat',2,0,'','','G. Sowerby','7161f1be-c622-530e-9e00-b0f0f4d65f96','Cerithium elongatum G. Sowerby, 1855','G. Sowerby, 1855','UNRANKED','','Cerithium','','elongatum','','','',NULL,'','','','','','G. Sowerby','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10688','','','Acteon elongatus Coquand, 1859',1,'Acteon elongatus','Acteon elongatus','Acteon elongat',2,0,'','','Coquand','4e670bec-c3fd-557f-a9a2-7e4029583a6e','Acteon elongatus Coquand, 1859','Coquand, 1859','UNRANKED','','Acteon','','elongatus','','','',NULL,'','','','','','Coquand','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10693','','','Opis elongatus Lycett, 1850',1,'Opis elongatus','Opis elongatus','Opis elongat',2,0,'','','Lycett','7e1aeef4-c090-5ce8-b52c-a558301f11dc','Opis elongatus Lycett, 1850','Lycett, 1850','UNRANKED','','Opis','','elongatus','','','',NULL,'','','','','','Lycett','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10699','','','Solen elongatus Gümbel, 1861',1,'Solen elongatus','Solen elongatus','Solen elongat',2,0,'','','Gümbel','a0c27c62-3730-5e39-a930-34d6cca24590','Solen elongatus Gümbel, 1861','Gümbel, 1861','UNRANKED','','Solen','','elongatus','','','',NULL,'','','','','','Gümbel','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10701','','','Limnaea elophila Bourguignat, 1862',1,'Limnaea elophila','Limnaea elophila','Limnaea elophil',2,0,'','','Bourguignat','005940a7-69b0-56db-9a83-980218bbafb7','Limnaea elophila Bourguignat, 1862','Bourguignat, 1862','UNRANKED','','Limnaea','','elophila','','','',NULL,'','','','','','Bourguignat','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10706','','','Nerinea elsgaudiae Thurmann, in Thurmann and Etallon, 1862',2,'Nerinea elsgaudiae','Nerinea elsgaudiae','Nerinea elsgaudi',2,0,'','','Thurmann|Etallon','a2cd67af-1fd3-513c-9f11-8c496e6de6ed','Nerinea elsgaudiae Thurmann, in Thurmann and Etallon, 1862','Thurmann, in Thurmann and Etallon, 1862','UNRANKED','','Nerinea','','elsgaudiae','','','',NULL,'','','','','','Thurmann','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10712','','','Cyclas emarginata Prime, 1852',1,'Cyclas emarginata','Cyclas emarginata','Cyclas emarginat',2,0,'','','Prime','df807950-cbf6-59f6-95a4-e6be29055ed1','Cyclas emarginata Prime, 1852','Prime, 1852','UNRANKED','','Cyclas','','emarginata','','','',NULL,'','','','','','Prime','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10717','','','Venus emarginata Danilo and Sandri, 1856',1,'Venus emarginata','Venus emarginata','Venus emarginat',2,0,'','','Danilo|Sandri','d01cd30c-8231-5012-b847-9660b1c21d63','Venus emarginata Danilo and Sandri, 1856','Danilo and Sandri, 1856','UNRANKED','','Venus','','emarginata','','','',NULL,'','','','','','Danilo & Sandri','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10719','','','Mycetopus emarginatus Lea, 1860',1,'Mycetopus emarginatus','Mycetopus emarginatus','Mycetopus emarginat',2,0,'','','Lea','ca71e013-4c50-5dd8-a5ff-eea5b8a2cf21','Mycetopus emarginatus Lea, 1860','Lea, 1860','UNRANKED','','Mycetopus','','emarginatus','','','',NULL,'','','','','','Lea','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10726','','','Emarginula emendata G. Sowerby, in A. Adams and Sowerby, 1863',2,'Emarginula emendata','Emarginula emendata','Emarginula emendat',2,0,'','','G. Sowerby|A. Adams|Sowerby','d7004947-0c6d-53c0-9771-0b588cbedc68','Emarginula emendata G. Sowerby, in A. Adams and Sowerby, 1863','G. Sowerby, in A. Adams and Sowerby, 1863','UNRANKED','','Emarginula','','emendata','','','',NULL,'','','','','','G. Sowerby','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10734','','','Achatina emiliana Benoit, 1862',1,'Achatina emiliana','Achatina emiliana','Achatina emilian',2,0,'','','Benoit','36a7d3ac-ea75-5bc2-9e06-cbcc7a72b7d6','Achatina emiliana Benoit, 1862','Benoit, 1862','UNRANKED','','Achatina','','emiliana','','','',NULL,'','','','','','Benoit','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10739','','','Voluta eminens Schafhäutl, 1863',1,'Voluta eminens','Voluta eminens','Voluta eminens',2,0,'','','Schafhäutl','c250b55e-4726-5909-a162-e6e2a633f788','Voluta eminens Schafhäutl, 1863','Schafhäutl, 1863','UNRANKED','','Voluta','','eminens','','','',NULL,'','','','','','Schafhäutl','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10745','','','Achatinella emmersonii Newcomb, 1853',1,'Achatinella emmersonii','Achatinella emmersonii','Achatinella emmerson',2,0,'','','Newcomb','737b0b28-7678-5ca9-b5e8-327ee9cd8971','Achatinella emmersonii Newcomb, 1853','Newcomb, 1853','UNRANKED','','Achatinella','','emmersonii','','','',NULL,'','','','','','Newcomb','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10753','','','Trigonia emoryi Conrad, 1857',1,'Trigonia emoryi','Trigonia emoryi','Trigonia emory',2,0,'','','Conrad','60b69b1b-c729-54e4-a457-27f3d67e65da','Trigonia emoryi Conrad, 1857','Conrad, 1857','UNRANKED','','Trigonia','','emoryi','','','',NULL,'','','','','','Conrad','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10757','','','Unio encarpus Lea, 1868',1,'Unio encarpus','Unio encarpus','Unio encarp',2,0,'','','Lea','a00190cb-bd1c-5316-ba6d-6fde095b5a0c','Unio encarpus Lea, 1868','Lea, 1868','UNRANKED','','Unio','','encarpus','','','',NULL,'','','','','','Lea','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10762','','','Nassa encaustica Brusina, 1869',1,'Nassa encaustica','Nassa encaustica','Nassa encaustic',2,0,'','','Brusina','6fd25f79-0173-580b-acfb-7f0f77541fa4','Nassa encaustica Brusina, 1869','Brusina, 1869','UNRANKED','','Nassa','','encaustica','','','',NULL,'','','','','','Brusina','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10767','','','Helix endoptycha Martens, 1864',1,'Helix endoptycha','Helix endoptycha','Helix endoptych',2,0,'','','Martens','0e7f8ce1-76b0-5d0a-823b-56219f1c2205','Helix endoptycha Martens, 1864','Martens, 1864','UNRANKED','','Helix','','endoptycha','','','',NULL,'','','','','','Martens','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10771','','','Lima engelhardti Rolle, 1860',1,'Lima engelhardti','Lima engelhardti','Lima engelhardt',2,0,'','','Rolle','0d8286c3-2ba3-53eb-8e5b-eb2dcbd63100','Lima engelhardti Rolle, 1860','Rolle, 1860','UNRANKED','','Lima','','engelhardti','','','',NULL,'','','','','','Rolle','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10777','','','Surcula engonata Conrad, 1862',1,'Surcula engonata','Surcula engonata','Surcula engonat',2,0,'','','Conrad','059df50e-09d3-5a87-8bcc-18a16df1cf35','Surcula engonata Conrad, 1862','Conrad, 1862','UNRANKED','','Surcula','','engonata','','','',NULL,'','','','','','Conrad','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10780','','','Pomatias enhalius Mabille, 1869',1,'Pomatias enhalius','Pomatias enhalius','Pomatias enhal',2,0,'','','Mabille','cbe40691-6df3-57a5-9eea-8a22ce16042d','Pomatias enhalius Mabille, 1869','Mabille, 1869','UNRANKED','','Pomatias','','enhalius','','','',NULL,'','','','','','Mabille','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10784','','','Ferussacia ennychia Bourguignat, 1856',1,'Ferussacia ennychia','Ferussacia ennychia','Ferussacia ennych',2,0,'','','Bourguignat','44f20610-2f12-5fa8-b42f-42d8534eabae','Ferussacia ennychia Bourguignat, 1856','Bourguignat, 1856','UNRANKED','','Ferussacia','','ennychia','','','',NULL,'','','','','','Bourguignat','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10787','','','Cassidaria enodis Deshayes, 1865',1,'Cassidaria enodis','Cassidaria enodis','Cassidaria enod',2,0,'','','Deshayes','358f0699-8617-5275-9305-65a2316ddd9b','Cassidaria enodis Deshayes, 1865','Deshayes, 1865','UNRANKED','','Cassidaria','','enodis','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10791','','','Allorisma ensiformis Swallow, 1860',1,'Allorisma ensiformis','Allorisma ensiformis','Allorisma ensiform',2,0,'','','Swallow','bfa741f2-2a06-5a97-99a2-ee62f48d30c2','Allorisma ensiformis Swallow, 1860','Swallow, 1860','UNRANKED','','Allorisma','','ensiformis','','','',NULL,'','','','','','Swallow','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10800','','','Tiphys eocenicus Schauroth, 1865',1,'Tiphys eocenicus','Tiphys eocenicus','Tiphys eocenic',2,0,'','','Schauroth','6e46500b-5f3a-5bf8-bb94-2ae623d358f6','Tiphys eocenicus Schauroth, 1865','Schauroth, 1865','UNRANKED','','Tiphys','','eocenicus','','','',NULL,'','','','','','Schauroth','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10803','','','Turbo epaphus Laube, 1870',1,'Turbo epaphus','Turbo epaphus','Turbo epaph',2,0,'','','Laube','a30cee91-a5bc-5858-998f-a6efe56ffff1','Turbo epaphus Laube, 1870','Laube, 1870','UNRANKED','','Turbo','','epaphus','','','',NULL,'','','','','','Laube','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10811','','','Soletellina epidermia Deshayes, in Reeve, 1857',2,'Soletellina epidermia','Soletellina epidermia','Soletellina epiderm',2,0,'','','Deshayes|Reeve','a55788b4-7cd6-5a4b-b44a-6f0c09d8bf14','Soletellina epidermia Deshayes, in Reeve, 1857','Deshayes, in Reeve, 1857','UNRANKED','','Soletellina','','epidermia','','','',NULL,'','','','','','Deshayes','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10817','','','Clausilia senilis epirotica Mousson, 1859',1,'Clausilia senilis epirotica','Clausilia senilis epirotica','Clausilia senil epirotic',3,0,'','','Mousson','01f285fd-4123-5386-8b51-7ae20ae6c2e6','Clausilia senilis epirotica Mousson, 1859','Mousson, 1859','UNRANKED','','Clausilia','','senilis','epirotica','','',NULL,'','','','','','Mousson','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10822','','','Corbicula episcopalis Prime, 1870',1,'Corbicula episcopalis','Corbicula episcopalis','Corbicula episcopal',2,0,'','','Prime','3cae928c-e6b0-5bca-81b8-93a633a4a387','Corbicula episcopalis Prime, 1870','Prime, 1870','UNRANKED','','Corbicula','','episcopalis','','','',NULL,'','','','','','Prime','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10828','','','Carychium episonmum Bourguignat, 1857',1,'Carychium episonmum','Carychium episonmum','Carychium episonm',2,0,'','','Bourguignat','4fa9c3d1-5341-5b65-95b1-d7a0ab1c1959','Carychium episonmum Bourguignat, 1857','Bourguignat, 1857','UNRANKED','','Carychium','','episonmum','','','',NULL,'','','','','','Bourguignat','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10831','','','Helix epsilon Pfeiffer, 1852',1,'Helix epsilon','Helix epsilon','Helix epsilon',2,0,'','','Pfeiffer','ca3f6321-61ee-5052-be6b-f45d1664386c','Helix epsilon Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Helix','','epsilon','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10840','','','Tellina equilateralis Meek and Hayden, 1856',1,'Tellina equilateralis','Tellina equilateralis','Tellina equilateral',2,0,'','','Meek|Hayden','73c09cd7-623c-5208-870c-1f85f50dbf72','Tellina equilateralis Meek and Hayden, 1856','Meek and Hayden, 1856','UNRANKED','','Tellina','','equilateralis','','','',NULL,'','','','','','Meek & Hayden','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10843','','','Scalaria erasa Deshayes, 1861',1,'Scalaria erasa','Scalaria erasa','Scalaria eras',2,0,'','','Deshayes','20fa620c-8281-5d19-a9e2-00a883e8e650','Scalaria erasa Deshayes, 1861','Deshayes, 1861','UNRANKED','','Scalaria','','erasa','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10854','','','Ferussacia eremiophila Bourguignat, 1856',1,'Ferussacia eremiophila','Ferussacia eremiophila','Ferussacia eremiophil',2,0,'','','Bourguignat','ee2b6900-8c78-5b00-9132-cf8a5239fa65','Ferussacia eremiophila Bourguignat, 1856','Bourguignat, 1856','UNRANKED','','Ferussacia','','eremiophila','','','',NULL,'','','','','','Bourguignat','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10856','','','Clausilia eremita Parrcyss, in Charpentier, 1852',2,'Clausilia eremita','Clausilia eremita','Clausilia eremit',2,0,'','','Parrcyss|Charpentier','c42af648-7db6-5f58-94f0-3b216c04d93b','Clausilia eremita Parrcyss, in Charpentier, 1852','Parrcyss, in Charpentier, 1852','UNRANKED','','Clausilia','','eremita','','','',NULL,'','','','','','Parrcyss','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10862','','','Eunema erigone Billings, 1865',1,'Eunema erigone','Eunema erigone','Eunema erigon',2,0,'','','Billings','ea581718-e560-50f2-8e82-a7770b169de1','Eunema erigone Billings, 1865','Billings, 1865','UNRANKED','','Eunema','','erigone','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10866','','','Pecten erinaceus Buvignier, 1852',1,'Pecten erinaceus','Pecten erinaceus','Pecten erinace',2,0,'','','Buvignier','0eef9fab-846e-554e-8d6b-9bdaedb4406e','Pecten erinaceus Buvignier, 1852','Buvignier, 1852','UNRANKED','','Pecten','','erinaceus','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10872','','','Odostomia erjaveciana Brusina, 1869',1,'Odostomia erjaveciana','Odostomia erjaveciana','Odostomia eriauecian',2,0,'','','Brusina','c7f8594d-3dee-5978-9559-245d3cc6873d','Odostomia erjaveciana Brusina, 1869','Brusina, 1869','UNRANKED','','Odostomia','','erjaveciana','','','',NULL,'','','','','','Brusina','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10874','','','Trochus ermontianus Thurmann, in Thurmann and Etallon, 1862',2,'Trochus ermontianus','Trochus ermontianus','Trochus ermontian',2,0,'','','Thurmann|Etallon','2ce2c30d-bd0f-558c-95be-93a9302c04a7','Trochus ermontianus Thurmann, in Thurmann and Etallon, 1862','Thurmann, in Thurmann and Etallon, 1862','UNRANKED','','Trochus','','ermontianus','','','',NULL,'','','','','','Thurmann','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10880','','','Pleurotoma (Clavatula) erosa Schrenck, 1862',1,'Pleurotoma erosa','Pleurotoma erosa','Pleurotoma eros',2,0,'','','Schrenck','b530c467-309d-5d7a-8864-4057a9dde4d3','Pleurotoma (Clavatula) erosa Schrenck, 1862','Schrenck, 1862','UNRANKED','','Pleurotoma','Clavatula','erosa','','','',NULL,'','','','','','Schrenck','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10889','','','Nerita erubescens Reeve, 1855',1,'Nerita erubescens','Nerita erubescens','Nerita erubescens',2,0,'','','Reeve','e60c7441-4a6e-572a-b7f7-4038825ffff6','Nerita erubescens Reeve, 1855','Reeve, 1855','UNRANKED','','Nerita','','erubescens','','','',NULL,'','','','','','Reeve','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10895','','','Nerinea erycina Gemmellaro, 1865',1,'Nerinea erycina','Nerinea erycina','Nerinea erycin',2,0,'','','Gemmellaro','45ef7dea-6fd3-5400-9454-825dc0b6e587','Nerinea erycina Gemmellaro, 1865','Gemmellaro, 1865','UNRANKED','','Nerinea','','erycina','','','',NULL,'','','','','','Gemmellaro','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10898','','','Turritella eryna Orbigny, 1852',1,'Turritella eryna','Turritella eryna','Turritella eryn',2,0,'','','Orbigny','1edd9f87-a82d-5f13-ad30-fdd9e9a23c1c','Turritella eryna Orbigny, 1852','Orbigny, 1852','UNRANKED','','Turritella','','eryna','','','',NULL,'','','','','','Orbigny','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10901','','','Dosinia erythraea E. Römer, 1860',1,'Dosinia erythraea','Dosinia erythraea','Dosinia erythrae',2,0,'','','E. Römer','adaf72c1-23c7-5cb0-89cc-b331c8e02c73','Dosinia erythraea E. Römer, 1860','E. Römer, 1860','UNRANKED','','Dosinia','','erythraea','','','',NULL,'','','','','','E. Römer','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10905','','','Corbula erythraeensis H. Adams, 1870',1,'Corbula erythraeensis','Corbula erythraeensis','Corbula erythraeens',2,0,'','','H. Adams','676311ac-d8b4-558c-b422-6a2e4e3ba83e','Corbula erythraeensis H. Adams, 1870','H. Adams, 1870','UNRANKED','','Corbula','','erythraeensis','','','',NULL,'','','','','','H. Adams','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10908','','','Tellina erythraeensis H. Adams, 1870',1,'Tellina erythraeensis','Tellina erythraeensis','Tellina erythraeens',2,0,'','','H. Adams','18388f41-8a80-5bb5-8453-67248c45cb0e','Tellina erythraeensis H. Adams, 1870','H. Adams, 1870','UNRANKED','','Tellina','','erythraeensis','','','',NULL,'','','','','','H. Adams','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10916','','','Pecten escharoides Deshayes, 1858',1,'Pecten escharoides','Pecten escharoides','Pecten escharoid',2,0,'','','Deshayes','50b12745-d2a8-59a9-8429-12ef83ddd4d8','Pecten escharoides Deshayes, 1858','Deshayes, 1858','UNRANKED','','Pecten','','escharoides','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10918','','','Buccinum escheri Mayer, 1858',1,'Buccinum escheri','Buccinum escheri','Buccinum escher',2,0,'','','Mayer','3e962488-02eb-5e8a-a534-1d7899660512','Buccinum escheri Mayer, 1858','Mayer, 1858','UNRANKED','','Buccinum','','escheri','','','',NULL,'','','','','','Mayer','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10922','','','Lucina escheri Mayer, 1870',1,'Lucina escheri','Lucina escheri','Lucina escher',2,0,'','','Mayer','74df511c-ee18-5c58-b191-1b122fe486ee','Lucina escheri Mayer, 1870','Mayer, 1870','UNRANKED','','Lucina','','escheri','','','',NULL,'','','','','','Mayer','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10924','','','Modulus escheri Mayer, in Studer, 1853',2,'Modulus escheri','Modulus escheri','Modulus escher',2,0,'','','Mayer|Studer','389d7732-1fb4-52a5-b696-ce00e25d2c97','Modulus escheri Mayer, in Studer, 1853','Mayer, in Studer, 1853','UNRANKED','','Modulus','','escheri','','','',NULL,'','','','','','Mayer','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10932','','','Venus escheri Loriol, 1861',1,'Venus escheri','Venus escheri','Venus escher',2,0,'','','Loriol','2caee091-5149-5e4d-ba16-90a5878ff80b','Venus escheri Loriol, 1861','Loriol, 1861','UNRANKED','','Venus','','escheri','','','',NULL,'','','','','','Loriol','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10938','','','Leda escosurae Sharpe, 1853',1,'Leda escosurae','Leda escosurae','Leda escosur',2,0,'','','Sharpe','527fbf40-9e12-5dca-bd4b-4c1412bea6a1','Leda escosurae Sharpe, 1853','Sharpe, 1853','UNRANKED','','Leda','','escosurae','','','',NULL,'','','','','','Sharpe','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10942','','','Crassatella esquimalti Baird, 1863',1,'Crassatella esquimalti','Crassatella esquimalti','Crassatella esquimalt',2,0,'','','Baird','354cb955-2ca7-5c1d-bfb7-9900f9d67c5d','Crassatella esquimalti Baird, 1863','Baird, 1863','UNRANKED','','Crassatella','','esquimalti','','','',NULL,'','','','','','Baird','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10947','','','Columbella essingtonensis Reeve, 1859',1,'Columbella essingtonensis','Columbella essingtonensis','Columbella essingtonens',2,0,'','','Reeve','56fdaaa3-d194-58ad-a3b0-b08ac83dfb9f','Columbella essingtonensis Reeve, 1859','Reeve, 1859','UNRANKED','','Columbella','','essingtonensis','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10955','','','Cypricardia esthona Eichwald, 1857',1,'Cypricardia esthona','Cypricardia esthona','Cypricardia esthon',2,0,'','','Eichwald','c7acb9cf-f920-5762-bbfa-324b99a7e459','Cypricardia esthona Eichwald, 1857','Eichwald, 1857','UNRANKED','','Cypricardia','','esthona','','','',NULL,'','','','','','Eichwald','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10958','','','Glycimeris estrellanus Conrad, 1857',1,'Glycimeris estrellanus','Glycimeris estrellanus','Glycimeris estrellan',2,0,'','','Conrad','cc3bc9dc-07f8-5330-a298-8c5112043f92','Glycimeris estrellanus Conrad, 1857','Conrad, 1857','UNRANKED','','Glycimeris','','estrellanus','','','',NULL,'','','','','','Conrad','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10966','','','Lima etalloni Pictet and Campiche, 1870',1,'Lima etalloni','Lima etalloni','Lima etallon',2,0,'','','Pictet|Campiche','fca714eb-69f6-52e5-bb36-a5dab35b4cc3','Lima etalloni Pictet and Campiche, 1870','Pictet and Campiche, 1870','UNRANKED','','Lima','','etalloni','','','',NULL,'','','','','','Pictet & Campiche','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10970','','','Actaeon etheridgii Bell, 1870',1,'Actaeon etheridgii','Actaeon etheridgii','Actaeon etheridg',2,0,'','','Bell','2f227a55-9420-59a0-b18b-9905674c15a0','Actaeon etheridgii Bell, 1870','Bell, 1870','UNRANKED','','Actaeon','','etheridgii','','','',NULL,'','','','','','Bell','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10973','','','Turbo etheridgii Lycett, 1857',1,'Turbo etheridgii','Turbo etheridgii','Turbo etheridg',2,0,'','','Lycett','3a28c01c-8d66-5369-a4e4-b325aadc9b6f','Turbo etheridgii Lycett, 1857','Lycett, 1857','UNRANKED','','Turbo','','etheridgii','','','',NULL,'','','','','','Lycett','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10977','','','Margaritana etowahensis Lea, 1858',1,'Margaritana etowahensis','Margaritana etowahensis','Margaritana etowahens',2,0,'','','Lea','e45501aa-15b3-548d-be03-1c17ffede2ae','Margaritana etowahensis Lea, 1858','Lea, 1858','UNRANKED','','Margaritana','','etowahensis','','','',NULL,'','','','','','Lea','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10981','','','Adeorbis etruscus Rolle, 1861',1,'Adeorbis etruscus','Adeorbis etruscus','Adeorbis etrusc',2,0,'','','Rolle','959706cd-7590-51d4-b8dd-113137468988','Adeorbis etruscus Rolle, 1861','Rolle, 1861','UNRANKED','','Adeorbis','','etruscus','','','',NULL,'','','','','','Rolle','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10986','','','Metoptoma eubule Billings, 1865',1,'Metoptoma eubule','Metoptoma eubule','Metoptoma eubul',2,0,'','','Billings','f3dbe41d-bb6a-5bdf-a8a8-15ae1048a618','Metoptoma eubule Billings, 1865','Billings, 1865','UNRANKED','','Metoptoma','','eubule','','','',NULL,'','','','','','Billings','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10991','','','Ferussacia eucharista Bourguignat, 1864',1,'Ferussacia eucharista','Ferussacia eucharista','Ferussacia eucharist',2,0,'','','Bourguignat','8d1bad15-fc01-5ec2-be9a-05bf59f9b90c','Ferussacia eucharista Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Ferussacia','','eucharista','','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_10996','','','Helix euchromia Bourguignat, 1857',1,'Helix euchromia','Helix euchromia','Helix euchrom',2,0,'','','Bourguignat','b02ddb8b-3734-5a42-8371-9ee753ed343f','Helix euchromia Bourguignat, 1857','Bourguignat, 1857','UNRANKED','','Helix','','euchromia','','','',NULL,'','','','','','Bourguignat','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11002','','','Turritella eucycla Laube, 1870',1,'Turritella eucycla','Turritella eucycla','Turritella eucycl',2,0,'','','Laube','f90b3aad-1ebe-5509-88d0-b85065e18391','Turritella eucycla Laube, 1870','Laube, 1870','UNRANKED','','Turritella','','eucycla','','','',NULL,'','','','','','Laube','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11008','','','Trochus (Margarita) eudeli Deshayes, 1863',1,'Trochus eudeli','Trochus eudeli','Trochus eudel',2,0,'','','Deshayes','86aa07f3-8413-5196-ab3d-368dca09eaa9','Trochus (Margarita) eudeli Deshayes, 1863','Deshayes, 1863','UNRANKED','','Trochus','Margarita','eudeli','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11015','','','Pleurotomaria euendyma Ryckholt, 1861',1,'Pleurotomaria euendyma','Pleurotomaria euendyma','Pleurotomaria euendym',2,0,'','','Ryckholt','b58b7184-2048-5c40-8df2-b9da6256d754','Pleurotomaria euendyma Ryckholt, 1861','Ryckholt, 1861','UNRANKED','','Pleurotomaria','','euendyma','','','',NULL,'','','','','','Ryckholt','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11022','','','Cardium (Trachycardium) eufaulense Conrad, 1860',1,'Cardium eufaulense','Cardium eufaulense','Cardium eufaulens',2,0,'','','Conrad','8d0722d2-9ca0-5df9-8675-5c26699acedf','Cardium (Trachycardium) eufaulense Conrad, 1860','Conrad, 1860','UNRANKED','','Cardium','Trachycardium','eufaulense','','','',NULL,'','','','','','Conrad','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11024','','','Corbula eufaulensis Conrad, 1860',1,'Corbula eufaulensis','Corbula eufaulensis','Corbula eufaulens',2,0,'','','Conrad','172c8872-3963-5006-b29d-933a70fc4f1b','Corbula eufaulensis Conrad, 1860','Conrad, 1860','UNRANKED','','Corbula','','eufaulensis','','','',NULL,'','','','','','Conrad','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11029','','','Deslongchampsia eugenei McCoy, in Morris and Lycett, 1854',2,'Deslongchampsia eugenei','Deslongchampsia eugenei','Deslongchampsia eugene',2,0,'','','McCoy|Morris|Lycett','e1808eae-e763-5184-b60f-be5444470002','Deslongchampsia eugenei McCoy, in Morris and Lycett, 1854','McCoy, in Morris and Lycett, 1854','UNRANKED','','Deslongchampsia','','eugenei','','','',NULL,'','','','','','McCoy','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11034','','','Scalaria eugenii Deshayes, 1861',1,'Scalaria eugenii','Scalaria eugenii','Scalaria eugen',2,0,'','','Deshayes','daa01315-b4cb-5d8e-9fb6-349f963cf755','Scalaria eugenii Deshayes, 1861','Deshayes, 1861','UNRANKED','','Scalaria','','eugenii','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11036','','','Helix eugenia Pfeiffer, 1853',1,'Helix eugenia','Helix eugenia','Helix eugen',2,0,'','','Pfeiffer','8d08b278-c5a3-5c2e-8b75-b36e35ab0bc0','Helix eugenia Pfeiffer, 1853','Pfeiffer, 1853','UNRANKED','','Helix','','eugenia','','','',NULL,'','','','','','Pfeiffer','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11041','','','Trochoceras eugenium Hall, 1861',1,'Trochoceras eugenium','Trochoceras eugenium','Trochoceras eugeni',2,0,'','','Hall','885e78b9-adc2-521c-9891-6dedb8872972','Trochoceras eugenium Hall, 1861','Hall, 1861','UNRANKED','','Trochoceras','','eugenium','','','',NULL,'','','','','','Hall','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11043','','','Mathilda euglypha Laube, 1866',1,'Mathilda euglypha','Mathilda euglypha','Mathilda euglyph',2,0,'','','Laube','ea89c857-5833-5ca6-9718-3b12fdac9f2d','Mathilda euglypha Laube, 1866','Laube, 1866','UNRANKED','','Mathilda','','euglypha','','','',NULL,'','','','','','Laube','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11050','','','Turbonilla eulimoides Folin, 1870',1,'Turbonilla eulimoides','Turbonilla eulimoides','Turbonilla eulimoid',2,0,'','','Folin','a0ff4619-3be0-5fd3-85b8-84640db15aa9','Turbonilla eulimoides Folin, 1870','Folin, 1870','UNRANKED','','Turbonilla','','eulimoides','','','',NULL,'','','','','','Folin','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11053','','','Ostrea eumenides Coquand, 1869',1,'Ostrea eumenides','Ostrea eumenides','Ostrea eumenid',2,0,'','','Coquand','752557b5-47cf-5436-9b36-ce83eaae5a62','Ostrea eumenides Coquand, 1869','Coquand, 1869','UNRANKED','','Ostrea','','eumenides','','','',NULL,'','','','','','Coquand','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11055','','','Vertigo eumicra Bourguignat, 1862',1,'Vertigo eumicra','Vertigo eumicra','Vertigo eumicr',2,0,'','','Bourguignat','83503565-5a18-5df9-ba61-83d1ca83fbdd','Vertigo eumicra Bourguignat, 1862','Bourguignat, 1862','UNRANKED','','Vertigo','','eumicra','','','',NULL,'','','','','','Bourguignat','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11062','','','Helix euomphalus Blanford and Blanford, 1861',1,'Helix euomphalus','Helix euomphalus','Helix euomphal',2,0,'','','Blanford','ac453b60-2edf-56a9-8b36-a152ff796a57','Helix euomphalus Blanford and Blanford, 1861','Blanford and Blanford, 1861','UNRANKED','','Helix','','euomphalus','','','',NULL,'','','','','','Blanford & Blanford','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11067','','','Carychium euphaeum Bourguignat, 1857',1,'Carychium euphaeum','Carychium euphaeum','Carychium euphae',2,0,'','','Bourguignat','1e645bbb-585b-533a-adc1-5b360a9a6390','Carychium euphaeum Bourguignat, 1857','Bourguignat, 1857','UNRANKED','','Carychium','','euphaeum','','','',NULL,'','','','','','Bourguignat','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11069','','','Helix euphorca Bourguignat, 1864',1,'Helix euphorca','Helix euphorca','Helix euphorc',2,0,'','','Bourguignat','f22a4256-d5d1-57bc-adb8-7de498863d5f','Helix euphorca Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','euphorca','','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11075','','','Zonites eurabdotus Bourguignat, 1867',1,'Zonites eurabdotus','Zonites eurabdotus','Zonites eurabdot',2,0,'','','Bourguignat','34cd3e33-bd94-551d-84db-798a8d3dbbdd','Zonites eurabdotus Bourguignat, 1867','Bourguignat, 1867','UNRANKED','','Zonites','','eurabdotus','','','',NULL,'','','','','','Bourguignat','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11082','','','Cardium euryalus Coquand, 1865',1,'Cardium euryalus','Cardium euryalus','Cardium euryal',2,0,'','','Coquand','a67f4c03-1593-52fa-b93c-e62d6abb5571','Cardium euryalus Coquand, 1865','Coquand, 1865','UNRANKED','','Cardium','','euryalus','','','',NULL,'','','','','','Coquand','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11088','','','Rostellaria euryptera Buvignier, 1852',1,'Rostellaria euryptera','Rostellaria euryptera','Rostellaria eurypter',2,0,'','','Buvignier','32ca3a51-5666-5de5-bb51-9d518926145a','Rostellaria euryptera Buvignier, 1852','Buvignier, 1852','UNRANKED','','Rostellaria','','euryptera','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11091','','','Bulimus eurystomus Philippi, 1867',1,'Bulimus eurystomus','Bulimus eurystomus','Bulimus eurystom',2,0,'','','Philippi','c6543a60-415c-5339-bbee-3c8d76904ad1','Bulimus eurystomus Philippi, 1867','Philippi, 1867','UNRANKED','','Bulimus','','eurystomus','','','',NULL,'','','','','','Philippi','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11094','','','Cataulus eurytrema Pfeiffer, 1852',1,'Cataulus eurytrema','Cataulus eurytrema','Cataulus eurytrem',2,0,'','','Pfeiffer','7ddd9bf6-91a1-5846-90c4-8bc5f79ceb01','Cataulus eurytrema Pfeiffer, 1852','Pfeiffer, 1852','UNRANKED','','Cataulus','','eurytrema','','','',NULL,'','','','','','Pfeiffer','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11100','','','Helix eustricta Bourguignat, 1864',1,'Helix eustricta','Helix eustricta','Helix eustrict',2,0,'','','Bourguignat','b3eb02f9-d35a-545b-ae53-7586478f2146','Helix eustricta Bourguignat, 1864','Bourguignat, 1864','UNRANKED','','Helix','','eustricta','','','',NULL,'','','','','','Bourguignat','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11107','','','Hydrobia eutrepha Paladilhe, 1867',1,'Hydrobia eutrepha','Hydrobia eutrepha','Hydrobia eutreph',2,0,'','','Paladilhe','ff6720d4-df3a-5cd2-bee5-c4eace8649d0','Hydrobia eutrepha Paladilhe, 1867','Paladilhe, 1867','UNRANKED','','Hydrobia','','eutrepha','','','',NULL,'','','','','','Paladilhe','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11111','','','Clausilia euzieriana Bourguignat, 1870',1,'Clausilia euzieriana','Clausilia euzieriana','Clausilia euzierian',2,0,'','','Bourguignat','4092043c-b07a-562b-b8fc-b150e3ad2d71','Clausilia euzieriana Bourguignat, 1870','Bourguignat, 1870','UNRANKED','','Clausilia','','euzieriana','','','',NULL,'','','','','','Bourguignat','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11116','','','Corbula evansana Shumard, 1858',1,'Corbula evansana','Corbula evansana','Corbula euansan',2,0,'','','Shumard','c343646b-3d41-5400-bce2-4563f6fc819f','Corbula evansana Shumard, 1858','Shumard, 1858','UNRANKED','','Corbula','','evansana','','','',NULL,'','','','','','Shumard','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11122','','','Unio (Alasmodon) evansi A. Adams and Angas, 1864',1,'Unio evansi','Unio evansi','Unio euans',2,0,'','','A. Adams|Angas','835b670a-22f6-5555-a1c4-0322b0615085','Unio (Alasmodon) evansi A. Adams and Angas, 1864','A. Adams and Angas, 1864','UNRANKED','','Unio','Alasmodon','evansi','','','',NULL,'','','','','','A. Adams & Angas','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11124','','','Cardinia eveni Terquem, 1855',1,'Cardinia eveni','Cardinia eveni','Cardinia euen',2,0,'','','Terquem','f49c51c3-6c8d-5c46-9d3d-353da548e157','Cardinia eveni Terquem, 1855','Terquem, 1855','UNRANKED','','Cardinia','','eveni','','','',NULL,'','','','','','Terquem','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11128','','','Natica evoluta Ryckholt, 1860',1,'Natica evoluta','Natica evoluta','Natica euolut',2,0,'','','Ryckholt','6ec8c61d-ef1a-577f-9e3f-586a58afaf66','Natica evoluta Ryckholt, 1860','Ryckholt, 1860','UNRANKED','','Natica','','evoluta','','','',NULL,'','','','','','Ryckholt','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11131','','','Pleurotoma evulsa Deshayes, 1865',1,'Pleurotoma evulsa','Pleurotoma evulsa','Pleurotoma euuls',2,0,'','','Deshayes','09d7cc48-dfc0-58b3-928d-01711c227858','Pleurotoma evulsa Deshayes, 1865','Deshayes, 1865','UNRANKED','','Pleurotoma','','evulsa','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11139','','','Helix aspersa exalbida A. Moquin-Tandon, 1855',1,'Helix aspersa exalbida','Helix aspersa exalbida','Helix aspers exalbid',3,0,'','','A. Moquin-Tandon','1216e38e-eace-5102-a061-7ffd0095a92c','Helix aspersa exalbida A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','aspersa','exalbida','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11144','','','Neritina exaltata Recluz, 1850',1,'Neritina exaltata','Neritina exaltata','Neritina exaltat',2,0,'','','Recluz','61cbb3e9-dae9-57c7-b363-c761dfe47022','Neritina exaltata Recluz, 1850','Recluz, 1850','UNRANKED','','Neritina','','exaltata','','','',NULL,'','','','','','Recluz','','','','1850','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11150','','','Unio exanthematicus Küster, 1861',1,'Unio exanthematicus','Unio exanthematicus','Unio exanthematic',2,0,'','','Küster','a0d31ac9-1faf-580a-84e3-e672e8f5c59a','Unio exanthematicus Küster, 1861','Küster, 1861','UNRANKED','','Unio','','exanthematicus','','','',NULL,'','','','','','Küster','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11162','','','Melampus (Tralia) exaratus H. Adams and A. Adams, 1854',1,'Melampus exaratus','Melampus exaratus','Melampus exarat',2,0,'','','H. Adams|A. Adams','594fbb55-e09c-59ab-af66-f6b00e524ed6','Melampus (Tralia) exaratus H. Adams and A. Adams, 1854','H. Adams and A. Adams, 1854','UNRANKED','','Melampus','Tralia','exaratus','','','',NULL,'','','','','','H. Adams & A. Adams','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11165','','','Stylifer exaratus A. Adams, 1855',1,'Stylifer exaratus','Stylifer exaratus','Stylifer exarat',2,0,'','','A. Adams','2e97db4f-412f-5cb5-be02-c6a3a079eb30','Stylifer exaratus A. Adams, 1855','A. Adams, 1855','UNRANKED','','Stylifer','','exaratus','','','',NULL,'','','','','','A. Adams','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11170','','','Cerithium excalptum Lycett, 1863',1,'Cerithium excalptum','Cerithium excalptum','Cerithium excalpt',2,0,'','','Lycett','e01ca767-cb53-50aa-889f-72d3459603c8','Cerithium excalptum Lycett, 1863','Lycett, 1863','UNRANKED','','Cerithium','','excalptum','','','',NULL,'','','','','','Lycett','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11174','','','Cardita excavata Deshayes, 1852',1,'Cardita excavata','Cardita excavata','Cardita excauat',2,0,'','','Deshayes','7146af04-6e42-5bbc-80b7-be7a5a3f6500','Cardita excavata Deshayes, 1852','Deshayes, 1852','UNRANKED','','Cardita','','excavata','','','',NULL,'','','','','','Deshayes','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11181','','','Melania muricata excavata Morris, 1856',1,'Melania muricata excavata','Melania muricata excavata','Melania muricat excauat',3,0,'','','Morris','8b52b0d0-e1fe-5acc-841d-183c8fe566cd','Melania muricata excavata Morris, 1856','Morris, 1856','UNRANKED','','Melania','','muricata','excavata','','',NULL,'','','','','','Morris','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11187','','','Tellina excavata G. Sowerby, 1867',1,'Tellina excavata','Tellina excavata','Tellina excauat',2,0,'','','G. Sowerby','6c908d10-12d3-582d-ab67-5f5085728521','Tellina excavata G. Sowerby, 1867','G. Sowerby, 1867','UNRANKED','','Tellina','','excavata','','','',NULL,'','','','','','G. Sowerby','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11193','','','Venus (Chione) excavata P. Carpenter, 1856',1,'Venus excavata','Venus excavata','Venus excauat',2,0,'','','P. Carpenter','fc77b7bc-227b-5c6f-abf3-4e77402889b5','Venus (Chione) excavata P. Carpenter, 1856','P. Carpenter, 1856','UNRANKED','','Venus','Chione','excavata','','','',NULL,'','','','','','P. Carpenter','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11198','','','Murex excavatus A. Adams, 1851',1,'Murex excavatus','Murex excavatus','Murex excauat',2,0,'','','A. Adams','e49aed25-6c27-5bed-b77f-ffcb1f15c994','Murex excavatus A. Adams, 1851','A. Adams, 1851','UNRANKED','','Murex','','excavatus','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11205','','','Posidonomya excellens Eichwald, 1857',1,'Posidonomya excellens','Posidonomya excellens','Posidonomya excellens',2,0,'','','Eichwald','35a98e5f-ddf3-5279-b649-c781a625ae4e','Posidonomya excellens Eichwald, 1857','Eichwald, 1857','UNRANKED','','Posidonomya','','excellens','','','',NULL,'','','','','','Eichwald','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11209','','','Arcopagia excentrica Bellardi, 1852',1,'Arcopagia excentrica','Arcopagia excentrica','Arcopagia excentric',2,0,'','','Bellardi','73659c2b-0c30-524e-959a-21824ef732e9','Arcopagia excentrica Bellardi, 1852','Bellardi, 1852','UNRANKED','','Arcopagia','','excentrica','','','',NULL,'','','','','','Bellardi','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11211','','','Gadinia excentrica Tiberi, 1855',1,'Gadinia excentrica','Gadinia excentrica','Gadinia excentric',2,0,'','','Tiberi','a73f4b3f-f0e4-5cf4-9f4c-b3bc98502f22','Gadinia excentrica Tiberi, 1855','Tiberi, 1855','UNRANKED','','Gadinia','','excentrica','','','',NULL,'','','','','','Tiberi','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11217','','','Fusus exceptiunculus Deshayes, 1864',1,'Fusus exceptiunculus','Fusus exceptiunculus','Fusus exceptiuncul',2,0,'','','Deshayes','991ef849-d22b-5f5b-86ce-bc5ef04ac458','Fusus exceptiunculus Deshayes, 1864','Deshayes, 1864','UNRANKED','','Fusus','','exceptiunculus','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11221','','','Pomatias excisus Mousson, 1859',1,'Pomatias excisus','Pomatias excisus','Pomatias excis',2,0,'','','Mousson','6c350d00-dbba-5b91-b1a0-0e08dbee7337','Pomatias excisus Mousson, 1859','Mousson, 1859','UNRANKED','','Pomatias','','excisus','','','',NULL,'','','','','','Mousson','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11227','','','Clausilia excurrens Martens, 1864',1,'Clausilia excurrens','Clausilia excurrens','Clausilia excurrens',2,0,'','','Martens','839fdb18-d468-55da-b2fe-37bc62cd3712','Clausilia excurrens Martens, 1864','Martens, 1864','UNRANKED','','Clausilia','','excurrens','','','',NULL,'','','','','','Martens','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11231','','','Bela excurvata P. Carpenter, 1864',1,'Bela excurvata','Bela excurvata','Bela excuruat',2,0,'','','P. Carpenter','45a074e7-1c58-5dbb-a204-7a9925be6cc3','Bela excurvata P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Bela','','excurvata','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11233','','','Bullina exerta Deshayes, 1862',1,'Bullina exerta','Bullina exerta','Bullina exert',2,0,'','','Deshayes','2f55d50c-53e4-56a1-a836-276d2435113e','Bullina exerta Deshayes, 1862','Deshayes, 1862','UNRANKED','','Bullina','','exerta','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11238','','','Clavagella exigua Zittel, 1865',1,'Clavagella exigua','Clavagella exigua','Clavagella exigu',2,0,'','','Zittel','55b3d58f-3ec9-5b98-b710-6b5fa2a0880a','Clavagella exigua Zittel, 1865','Zittel, 1865','UNRANKED','','Clavagella','','exigua','','','',NULL,'','','','','','Zittel','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11243','','','Gervillea exigua Eichwald, 1865',1,'Gervillea exigua','Gervillea exigua','Gervillea exigu',2,0,'','','Eichwald','3167b20a-0d30-5910-a1b3-1cc2b1aeba7f','Gervillea exigua Eichwald, 1865','Eichwald, 1865','UNRANKED','','Gervillea','','exigua','','','',NULL,'','','','','','Eichwald','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11244','','','Helix exigua Philippi, 1855',1,'Helix exigua','Helix exigua','Helix exigu',2,0,'','','Philippi','3735ef5d-d341-5f81-91fa-b6ce922111d7','Helix exigua Philippi, 1855','Philippi, 1855','UNRANKED','','Helix','','exigua','','','',NULL,'','','','','','Philippi','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11248','','','Litorina exigua Dunker, 1860',1,'Litorina exigua','Litorina exigua','Litorina exigu',2,0,'','','Dunker','0961cf08-1850-5535-acb2-491a54ca2cbe','Litorina exigua Dunker, 1860','Dunker, 1860','UNRANKED','','Litorina','','exigua','','','',NULL,'','','','','','Dunker','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11251','','','Monodonta (Aradasia) exigua A. Adams, 1851',1,'Monodonta exigua','Monodonta exigua','Monodonta exigu',2,0,'','','A. Adams','a4e81768-eff7-57fb-be24-3cb96571d26d','Monodonta (Aradasia) exigua A. Adams, 1851','A. Adams, 1851','UNRANKED','','Monodonta','Aradasia','exigua','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11255','','','Neritopsis exigua Terquem, 1855',1,'Neritopsis exigua','Neritopsis exigua','Neritopsis exigu',2,0,'','','Terquem','6c8b42e2-06ae-507a-b0d9-bbe39916b413','Neritopsis exigua Terquem, 1855','Terquem, 1855','UNRANKED','','Neritopsis','','exigua','','','',NULL,'','','','','','Terquem','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11260','','','Plecotrema exigua H. Adams, 1867',1,'Plecotrema exigua','Plecotrema exigua','Plecotrema exigu',2,0,'','','H. Adams','6b3cf7b1-4325-57fe-9449-60772dfc2581','Plecotrema exigua H. Adams, 1867','H. Adams, 1867','UNRANKED','','Plecotrema','','exigua','','','',NULL,'','','','','','H. Adams','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11261','','','Pleurotoma exigua C.B. Adams, 1852',1,'Pleurotoma exigua','Pleurotoma exigua','Pleurotoma exigu',2,0,'','','C. B. Adams','17f66655-8699-5a7c-b5bc-81942bd347bb','Pleurotoma exigua C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Pleurotoma','','exigua','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11266','','','Semele exigua H. Adams, 1861',1,'Semele exigua','Semele exigua','Semele exigu',2,0,'','','H. Adams','68a6608f-9cc2-5f30-8e44-fb910bc1a1e6','Semele exigua H. Adams, 1861','H. Adams, 1861','UNRANKED','','Semele','','exigua','','','',NULL,'','','','','','H. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11271','','','Cerithium exiguum Piette, 1855',1,'Cerithium exiguum','Cerithium exiguum','Cerithium exigu',2,0,'','','Piette','c776f770-24ea-5117-b307-d01473343e55','Cerithium exiguum Piette, 1855','Piette, 1855','UNRANKED','','Cerithium','','exiguum','','','',NULL,'','','','','','Piette','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11280','','','Achatinella exilis Gulick, 1856',1,'Achatinella exilis','Achatinella exilis','Achatinella exil',2,0,'','','Gulick','e60ecf30-fb1c-5625-874e-abda1127c00f','Achatinella exilis Gulick, 1856','Gulick, 1856','UNRANKED','','Achatinella','','exilis','','','',NULL,'','','','','','Gulick','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11286','','','Clathurella exilis Pease, 1860',1,'Clathurella exilis','Clathurella exilis','Clathurella exil',2,0,'','','Pease','19c3700b-5e03-5036-8633-1d037b88e61b','Clathurella exilis Pease, 1860','Pease, 1860','UNRANKED','','Clathurella','','exilis','','','',NULL,'','','','','','Pease','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11294','','','Melania exilis Terquem and Jourdy, 1869',1,'Melania exilis','Melania exilis','Melania exil',2,0,'','','Terquem|Jourdy','25269fb2-66c5-5b1b-a76f-03b2e87b8813','Melania exilis Terquem and Jourdy, 1869','Terquem and Jourdy, 1869','UNRANKED','','Melania','','exilis','','','',NULL,'','','','','','Terquem & Jourdy','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11299','','','Oliva exilis Eichwald, 1868',1,'Oliva exilis','Oliva exilis','Oliva exil',2,0,'','','Eichwald','431d33f4-f7d6-52c5-b235-50e6e60e1024','Oliva exilis Eichwald, 1868','Eichwald, 1868','UNRANKED','','Oliva','','exilis','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11301','','','Paludina exilis Anthony, 1860',1,'Paludina exilis','Paludina exilis','Paludina exil',2,0,'','','Anthony','b8b57328-24cf-5e26-9cf0-2d2fd4d1d3ee','Paludina exilis Anthony, 1860','Anthony, 1860','UNRANKED','','Paludina','','exilis','','','',NULL,'','','','','','Anthony','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11310','','','Triforis exilis Dunker, 1860',1,'Triforis exilis','Triforis exilis','Triforis exil',2,0,'','','Dunker','25ee7cfa-3958-50cd-877b-b54b01f3c4e9','Triforis exilis Dunker, 1860','Dunker, 1860','UNRANKED','','Triforis','','exilis','','','',NULL,'','','','','','Dunker','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11316','','','Columbella exima Reeve, 1859',1,'Columbella exima','Columbella exima','Columbella exim',2,0,'','','Reeve','11c83d45-d4f4-5cd8-8d1e-5a35e04c97e4','Columbella exima Reeve, 1859','Reeve, 1859','UNRANKED','','Columbella','','exima','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11320','','','Barbatia eximia Dunker, 1866',1,'Barbatia eximia','Barbatia eximia','Barbatia exim',2,0,'','','Dunker','4274f185-62ff-586d-ad14-2c8dc80de09c','Barbatia eximia Dunker, 1866','Dunker, 1866','UNRANKED','','Barbatia','','eximia','','','',NULL,'','','','','','Dunker','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11325','','','Circe eximia Hörnes, 1862',1,'Circe eximia','Circe eximia','Circe exim',2,0,'','','Hörnes','9bbe3a11-9c3f-5880-9624-e0c10be6c1f8','Circe eximia Hörnes, 1862','Hörnes, 1862','UNRANKED','','Circe','','eximia','','','',NULL,'','','','','','Hörnes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11327','','','Cyprina eximia Eichwald, 1868',1,'Cyprina eximia','Cyprina eximia','Cyprina exim',2,0,'','','Eichwald','77ee7918-6148-5738-836c-44c420e29f25','Cyprina eximia Eichwald, 1868','Eichwald, 1868','UNRANKED','','Cyprina','','eximia','','','',NULL,'','','','','','Eichwald','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11335','','','Modiola eximia Wood, 1861',1,'Modiola eximia','Modiola eximia','Modiola exim',2,0,'','','Wood','d2e88366-ee8c-53e6-be66-470941b7b2a9','Modiola eximia Wood, 1861','Wood, 1861','UNRANKED','','Modiola','','eximia','','','',NULL,'','','','','','Wood','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11341','','','Tapes eximia Zittel, 1865',1,'Tapes eximia','Tapes eximia','Tapes exim',2,0,'','','Zittel','9809dd10-8707-53a5-9ce6-855dde13ea4a','Tapes eximia Zittel, 1865','Zittel, 1865','UNRANKED','','Tapes','','eximia','','','',NULL,'','','','','','Zittel','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11347','','','Voluta eximia Beyrich, 1853',1,'Voluta eximia','Voluta eximia','Voluta exim',2,0,'','','Beyrich','b4ab5ec9-ef40-5fbb-b8d3-fd275897b064','Voluta eximia Beyrich, 1853','Beyrich, 1853','UNRANKED','','Voluta','','eximia','','','',NULL,'','','','','','Beyrich','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11351','','','Bulimus eximius Albers, 1857',1,'Bulimus eximius','Bulimus eximius','Bulimus exim',2,0,'','','Albers','983226b9-c01b-5343-976e-bf58485ceacc','Bulimus eximius Albers, 1857','Albers, 1857','UNRANKED','','Bulimus','','eximius','','','',NULL,'','','','','','Albers','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11360','','','Arca exornata Deshayes, 1858',1,'Arca exornata','Arca exornata','Arca exornat',2,0,'','','Deshayes','40e462c5-72bf-59c4-a450-c660168889b1','Arca exornata Deshayes, 1858','Deshayes, 1858','UNRANKED','','Arca','','exornata','','','',NULL,'','','','','','Deshayes','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11363','','','Anodon exoticus Gray, in G. Sowerby, 1867',2,'Anodon exoticus','Anodon exoticus','Anodon exotic',2,0,'','','Gray|G. Sowerby','19571d10-015a-5fd9-9896-1ac820d09363','Anodon exoticus Gray, in G. Sowerby, 1867','Gray, in G. Sowerby, 1867','UNRANKED','','Anodon','','exoticus','','','',NULL,'','','','','','Gray','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11371','','','Cyprina expansa Coquand, 1865',1,'Cyprina expansa','Cyprina expansa','Cyprina expans',2,0,'','','Coquand','ad1d5db7-20cf-55a8-ae03-e79f829865b2','Cyprina expansa Coquand, 1865','Coquand, 1865','UNRANKED','','Cyprina','','expansa','','','',NULL,'','','','','','Coquand','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11376','','','Lima expansa J. Sowerby, in Dixon, 1850',2,'Lima expansa','Lima expansa','Lima expans',2,0,'','','J. Sowerby|Dixon','224feca6-f7bd-5868-b574-bc6ead2829c6','Lima expansa J. Sowerby, in Dixon, 1850','J. Sowerby, in Dixon, 1850','UNRANKED','','Lima','','expansa','','','',NULL,'','','','','','J. Sowerby','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11383','','','Ostrea lurida expansa P. Carpenter, 1864',1,'Ostrea lurida expansa','Ostrea lurida expansa','Ostrea lurid expans',3,0,'','','P. Carpenter','6e57ffd2-b9bd-571a-9d52-03eb1e3a8bbb','Ostrea lurida expansa P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Ostrea','','lurida','expansa','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11385','','','Rissoina expansa P. Carpenter, 1865',1,'Rissoina expansa','Rissoina expansa','Rissoina expans',2,0,'','','P. Carpenter','9bb9d25c-455d-57fe-b7b2-9f26f43a63a8','Rissoina expansa P. Carpenter, 1865','P. Carpenter, 1865','UNRANKED','','Rissoina','','expansa','','','',NULL,'','','','','','P. Carpenter','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11390','','','Helix expansilabris F. Sandberger, 1863',1,'Helix expansilabris','Helix expansilabris','Helix expansilabr',2,0,'','','F. Sandberger','61606a2a-8b84-5b2d-afca-3e2eb6e6699b','Helix expansilabris F. Sandberger, 1863','F. Sandberger, 1863','UNRANKED','','Helix','','expansilabris','','','',NULL,'','','','','','F. Sandberger','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11395','','','Cyrtolites expansus Hall, 1859',1,'Cyrtolites expansus','Cyrtolites expansus','Cyrtolites expans',2,0,'','','Hall','2ff857ca-d89f-5ab5-bc42-b8c0e6c6a529','Cyrtolites expansus Hall, 1859','Hall, 1859','UNRANKED','','Cyrtolites','','expansus','','','',NULL,'','','','','','Hall','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11401','','','Unio expansus Charpentier, in Küster, 1856',2,'Unio expansus','Unio expansus','Unio expans',2,0,'','','Charpentier|Küster','d86b67d7-8684-50e9-835c-3c7eb3232197','Unio expansus Charpentier, in Küster, 1856','Charpentier, in Küster, 1856','UNRANKED','','Unio','','expansus','','','',NULL,'','','','','','Charpentier','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11410','','','Modiolaria expleta Gould, 1861',1,'Modiolaria expleta','Modiolaria expleta','Modiolaria explet',2,0,'','','Gould','d9564745-a5ac-5e7c-be4b-dc476cd1adf9','Modiolaria expleta Gould, 1861','Gould, 1861','UNRANKED','','Modiolaria','','expleta','','','',NULL,'','','','','','Gould','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11415','','','Hydrocena exquisita Pfeiffer, 1854',1,'Hydrocena exquisita','Hydrocena exquisita','Hydrocena exquisit',2,0,'','','Pfeiffer','c6e73b25-fafc-5545-9c29-be7b180c83fd','Hydrocena exquisita Pfeiffer, 1854','Pfeiffer, 1854','UNRANKED','','Hydrocena','','exquisita','','','',NULL,'','','','','','Pfeiffer','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11419','','','Rimula exquisita A. Adams, 1851',1,'Rimula exquisita','Rimula exquisita','Rimula exquisit',2,0,'','','A. Adams','b061c78c-fa5c-5261-bee6-7da1725954c7','Rimula exquisita A. Adams, 1851','A. Adams, 1851','UNRANKED','','Rimula','','exquisita','','','',NULL,'','','','','','A. Adams','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11426','','','Limnaeus natalensis exsertus Martens, 1866',1,'Limnaeus natalensis exsertus','Limnaeus natalensis exsertus','Limnaeus natalens exsert',3,0,'','','Martens','7bf7641a-4ba2-5960-9b80-ae4f05d5ebbe','Limnaeus natalensis exsertus Martens, 1866','Martens, 1866','UNRANKED','','Limnaeus','','natalensis','exsertus','','',NULL,'','','','','','Martens','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11428','','','Dione exspinata Reeve, 1863',1,'Dione exspinata','Dione exspinata','Dione exspinat',2,0,'','','Reeve','81078fb2-df2f-5fc9-875e-e668af78969a','Dione exspinata Reeve, 1863','Reeve, 1863','UNRANKED','','Dione','','exspinata','','','',NULL,'','','','','','Reeve','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11433','','','Bulla extensa J. Sowerby, in Dixon, 1850',2,'Bulla extensa','Bulla extensa','Bulla extens',2,0,'','','J. Sowerby|Dixon','901de8c6-acc1-56cd-b7a3-dcb4e9938e90','Bulla extensa J. Sowerby, in Dixon, 1850','J. Sowerby, in Dixon, 1850','UNRANKED','','Bulla','','extensa','','','',NULL,'','','','','','J. Sowerby','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11441','','','Unio extensus Lea, 1857',1,'Unio extensus','Unio extensus','Unio extens',2,0,'','','Lea','23b078ea-d11b-530e-ae1c-5817fd8310f1','Unio extensus Lea, 1857','Lea, 1857','UNRANKED','','Unio','','extensus','','','',NULL,'','','','','','Lea','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11448','','','Mitra extranea Deshayes, 1865',1,'Mitra extranea','Mitra extranea','Mitra extrane',2,0,'','','Deshayes','d5d2b26e-c63a-5692-982a-c242009c2f7d','Mitra extranea Deshayes, 1865','Deshayes, 1865','UNRANKED','','Mitra','','extranea','','','',NULL,'','','','','','Deshayes','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11451','','','Cardium (Trachycardium) exulans Stoliczka, 1870',1,'Cardium exulans','Cardium exulans','Cardium exulans',2,0,'','','Stoliczka','d8393d88-9cf7-5e06-beed-b3f9c7c4ce8c','Cardium (Trachycardium) exulans Stoliczka, 1870','Stoliczka, 1870','UNRANKED','','Cardium','Trachycardium','exulans','','','',NULL,'','','','','','Stoliczka','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11454','','','Melania exusta Reeve, 1859',1,'Melania exusta','Melania exusta','Melania exust',2,0,'','','Reeve','56bba5c7-e7e7-5e12-9792-56184dd0051c','Melania exusta Reeve, 1859','Reeve, 1859','UNRANKED','','Melania','','exusta','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11459','','','Nucula ezquerrae Sharpe, 1853',1,'Nucula ezquerrae','Nucula ezquerrae','Nucula ezquerr',2,0,'','','Sharpe','c6a795b8-35e7-5168-a5cf-8a2c414387ee','Nucula ezquerrae Sharpe, 1853','Sharpe, 1853','UNRANKED','','Nucula','','ezquerrae','','','',NULL,'','','','','','Sharpe','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11465','','','Scintilla faba Deshayes, 1855',1,'Scintilla faba','Scintilla faba','Scintilla fab',2,0,'','','Deshayes','06e453af-d587-5491-a83d-29be30f5adc4','Scintilla faba Deshayes, 1855','Deshayes, 1855','UNRANKED','','Scintilla','','faba','','','',NULL,'','','','','','Deshayes','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11472','','','Heterocardia fabagella Deshayes, 1854',1,'Heterocardia fabagella','Heterocardia fabagella','Heterocardia fabagell',2,0,'','','Deshayes','baab1b16-2be9-5d5f-acfc-ad61e7fa71c7','Heterocardia fabagella Deshayes, 1854','Deshayes, 1854','UNRANKED','','Heterocardia','','fabagella','','','',NULL,'','','','','','Deshayes','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11474','','','Tapes fabagella Deshayes, 1853',1,'Tapes fabagella','Tapes fabagella','Tapes fabagell',2,0,'','','Deshayes','763a287d-5591-54d6-8ce1-8bf50731ffd8','Tapes fabagella Deshayes, 1853','Deshayes, 1853','UNRANKED','','Tapes','','fabagella','','','',NULL,'','','','','','Deshayes','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11480','','','Goniobasis fabalis Lea, 1862',1,'Goniobasis fabalis','Goniobasis fabalis','Goniobasis fabal',2,0,'','','Lea','a78ee240-64fc-5f81-b82d-9b29b9796164','Goniobasis fabalis Lea, 1862','Lea, 1862','UNRANKED','','Goniobasis','','fabalis','','','',NULL,'','','','','','Lea','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11484','','','Gastrochaena fabiformis Terquem and Jourdy, 1869',1,'Gastrochaena fabiformis','Gastrochaena fabiformis','Gastrochaena fabiform',2,0,'','','Terquem|Jourdy','623372f1-b38f-51a9-8b49-687eb079139e','Gastrochaena fabiformis Terquem and Jourdy, 1869','Terquem and Jourdy, 1869','UNRANKED','','Gastrochaena','','fabiformis','','','',NULL,'','','','','','Terquem & Jourdy','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11488','','','Voluta fabri Deshayes, 1866',1,'Voluta fabri','Voluta fabri','Voluta fabr',2,0,'','','Deshayes','bd6b4398-1fcf-5dc7-9d27-7e64bd446836','Voluta fabri Deshayes, 1866','Deshayes, 1866','UNRANKED','','Voluta','','fabri','','','',NULL,'','','','','','Deshayes','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11493','','','Scrobicularia fabula Brusina, 1865',1,'Scrobicularia fabula','Scrobicularia fabula','Scrobicularia fabul',2,0,'','','Brusina','5d403861-e72b-5604-be0f-cdbd5323208b','Scrobicularia fabula Brusina, 1865','Brusina, 1865','UNRANKED','','Scrobicularia','','fabula','','','',NULL,'','','','','','Brusina','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11494','','','Thracia fabula Reeve, 1859',1,'Thracia fabula','Thracia fabula','Thracia fabul',2,0,'','','Reeve','8a8175b9-19bd-5474-9e24-194c4b708f15','Thracia fabula Reeve, 1859','Reeve, 1859','UNRANKED','','Thracia','','fabula','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11499','','','Achatina facula Benson, 1860',1,'Achatina facula','Achatina facula','Achatina facul',2,0,'','','Benson','57b56f09-2491-5bf0-a857-8bd2b9761842','Achatina facula Benson, 1860','Benson, 1860','UNRANKED','','Achatina','','facula','','','',NULL,'','','','','','Benson','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11503','','','Diplommatina (Nicida) fairbanki W. Blanford, 1868',1,'Diplommatina fairbanki','Diplommatina fairbanki','Diplommatina fairbank',2,0,'','','W. Blanford','374e30fe-ee72-5ecc-a7a8-7fa74bbfd059','Diplommatina (Nicida) fairbanki W. Blanford, 1868','W. Blanford, 1868','UNRANKED','','Diplommatina','Nicida','fairbanki','','','',NULL,'','','','','','W. Blanford','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11506','','','Bulimus fairmaireanus Petit, 1853',1,'Bulimus fairmaireanus','Bulimus fairmaireanus','Bulimus fairmairean',2,0,'','','Petit','7bc7c68c-f77a-5af2-8888-01486e06a396','Bulimus fairmaireanus Petit, 1853','Petit, 1853','UNRANKED','','Bulimus','','fairmaireanus','','','',NULL,'','','','','','Petit','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11511','','','Mactra falcata Gould, 1851',1,'Mactra falcata','Mactra falcata','Mactra falcat',2,0,'','','Gould','80f66db7-1193-5ede-acb8-d3f3adc6e1fa','Mactra falcata Gould, 1851','Gould, 1851','UNRANKED','','Mactra','','falcata','','','',NULL,'','','','','','Gould','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11512','','','Nanina falcata W. Blanford, 1870',1,'Nanina falcata','Nanina falcata','Nanina falcat',2,0,'','','W. Blanford','c24bd959-5044-51c2-9d26-9c52705696fe','Nanina falcata W. Blanford, 1870','W. Blanford, 1870','UNRANKED','','Nanina','','falcata','','','',NULL,'','','','','','W. Blanford','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11517','','','Murex falcatus Danilo and Sandri, 1856',1,'Murex falcatus','Murex falcatus','Murex falcat',2,0,'','','Danilo|Sandri','c7af7827-bf15-5e48-9ed2-3cebfa65e52a','Murex falcatus Danilo and Sandri, 1856','Danilo and Sandri, 1856','UNRANKED','','Murex','','falcatus','','','',NULL,'','','','','','Danilo & Sandri','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11522','','','Ostrea falciformis Conrad, 1862',1,'Ostrea falciformis','Ostrea falciformis','Ostrea falciform',2,0,'','','Conrad','a9964c04-25b9-5b52-875a-e8a0e6f4f8d2','Ostrea falciformis Conrad, 1862','Conrad, 1862','UNRANKED','','Ostrea','','falciformis','','','',NULL,'','','','','','Conrad','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11529','','','Limnaea palustris fallaciosa RofTiaen, 1868',1,'Limnaea palustris fallaciosa','Limnaea palustris fallaciosa','Limnaea palustr fallacios',3,0,'','','Rof Tiaen','c38fe373-9f16-52e4-8ea0-00d622d7af84','Limnaea palustris fallaciosa RofTiaen, 1868','RofTiaen, 1868','UNRANKED','','Limnaea','','palustris','fallaciosa','','',NULL,'','','','','','Rof Tiaen','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11533','','','Buccinum fallax Favre, 1869',1,'Buccinum fallax','Buccinum fallax','Buccinum fallax',2,0,'','','Favre','4a44d4a9-4d1a-54c5-b0b9-b0b24cada72c','Buccinum fallax Favre, 1869','Favre, 1869','UNRANKED','','Buccinum','','fallax','','','',NULL,'','','','','','Favre','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11535','','','Cardium fallax Michelotti, 1861',1,'Cardium fallax','Cardium fallax','Cardium fallax',2,0,'','','Michelotti','20b0f3a1-7a3a-5b4c-831c-58e92b5afe88','Cardium fallax Michelotti, 1861','Michelotti, 1861','UNRANKED','','Cardium','','fallax','','','',NULL,'','','','','','Michelotti','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11540','','','Cytherea fallax Deshayes, 1857',1,'Cytherea fallax','Cytherea fallax','Cytherea fallax',2,0,'','','Deshayes','c82b4d31-368c-5d6f-9603-49877d1e0e53','Cytherea fallax Deshayes, 1857','Deshayes, 1857','UNRANKED','','Cytherea','','fallax','','','',NULL,'','','','','','Deshayes','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11545','','','Melania fallax Lea, 1861',1,'Melania fallax','Melania fallax','Melania fallax',2,0,'','','Lea','64f5e155-e9e7-56fc-8b18-f7c8ce2ef18a','Melania fallax Lea, 1861','Lea, 1861','UNRANKED','','Melania','','fallax','','','',NULL,'','','','','','Lea','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11551','','','Rissoina fallax Deshayes, 1861',1,'Rissoina fallax','Rissoina fallax','Rissoina fallax',2,0,'','','Deshayes','0ac6142f-fec2-5d16-aea9-ac9f02bd9d48','Rissoina fallax Deshayes, 1861','Deshayes, 1861','UNRANKED','','Rissoina','','fallax','','','',NULL,'','','','','','Deshayes','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11554','','','Vivipara fallax Frauenfeld, 1862',1,'Vivipara fallax','Vivipara fallax','Vivipara fallax',2,0,'','','Frauenfeld','c91bec47-f912-5d9e-a7de-aa45a514fa1e','Vivipara fallax Frauenfeld, 1862','Frauenfeld, 1862','UNRANKED','','Vivipara','','fallax','','','',NULL,'','','','','','Frauenfeld','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11558','','','Cerithium famelicum C.B. Adams, 1852',1,'Cerithium famelicum','Cerithium famelicum','Cerithium famelic',2,0,'','','C. B. Adams','2d8bbb56-7794-5301-86d1-378822a8cde7','Cerithium famelicum C.B. Adams, 1852','C.B. Adams, 1852','UNRANKED','','Cerithium','','famelicum','','','',NULL,'','','','','','C. B. Adams','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11565','','','Helix faradensis Pfeiffer, 1861',1,'Helix faradensis','Helix faradensis','Helix faradens',2,0,'','','Pfeiffer','ab557884-7ffd-5612-a8a0-21f51ca9aafd','Helix faradensis Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Helix','','faradensis','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11568','','','Zonites farinesianus Bourguignat, 1870',1,'Zonites farinesianus','Zonites farinesianus','Zonites farinesian',2,0,'','','Bourguignat','81f55b11-4bf2-5b70-beb4-e583b0b970b7','Zonites farinesianus Bourguignat, 1870','Bourguignat, 1870','UNRANKED','','Zonites','','farinesianus','','','',NULL,'','','','','','Bourguignat','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11576','','','Acteonina fasciata Lycett, 1863',1,'Acteonina fasciata','Acteonina fasciata','Acteonina fasciat',2,0,'','','Lycett','5c50981c-7db5-508d-9bfe-1e9b0e1234de','Acteonina fasciata Lycett, 1863','Lycett, 1863','UNRANKED','','Acteonina','','fasciata','','','',NULL,'','','','','','Lycett','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11583','','','Helix cinctella fasciata A. Moquin-Tandon, 1855',1,'Helix cinctella fasciata','Helix cinctella fasciata','Helix cinctell fasciat',3,0,'','','A. Moquin-Tandon','63b05ad4-409c-5098-8469-dd154c2dfb69','Helix cinctella fasciata A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','cinctella','fasciata','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11585','','','Helix ericetorum fasciata A. Moquin-Tandon, 1855',1,'Helix ericetorum fasciata','Helix ericetorum fasciata','Helix ericetor fasciat',3,0,'','','A. Moquin-Tandon','0da1d442-569a-53f3-9745-91ed72c853f8','Helix ericetorum fasciata A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','ericetorum','fasciata','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11590','','','Helix nemoralis fasciata A. Moquin-Tandon, 1855',1,'Helix nemoralis fasciata','Helix nemoralis fasciata','Helix nemoral fasciat',3,0,'','','A. Moquin-Tandon','eaa9fd67-5d5e-5cad-b833-47cf7da68efe','Helix nemoralis fasciata A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','nemoralis','fasciata','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11591','','','Helix provinciate fasciata Benoit, 1859',1,'Helix provinciate fasciata','Helix provinciate fasciata','Helix prouinciat fasciat',3,0,'','','Benoit','afbfda62-90d2-5ecd-9254-171b331fd8a5','Helix provinciate fasciata Benoit, 1859','Benoit, 1859','UNRANKED','','Helix','','provinciate','fasciata','','',NULL,'','','','','','Benoit','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11596','','','Helix variabilis fasciata A. Moquin-Tandon, 1855',1,'Helix variabilis fasciata','Helix variabilis fasciata','Helix uariabil fasciat',3,0,'','','A. Moquin-Tandon','acefeeaf-4ebe-5df7-9b68-dc65b850b495','Helix variabilis fasciata A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','variabilis','fasciata','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11597','','','Linteria fasciata G. Sowerby, 1870',1,'Linteria fasciata','Linteria fasciata','Linteria fasciat',2,0,'','','G. Sowerby','c9c3a202-b8a4-50de-a3cd-47b2679a89ec','Linteria fasciata G. Sowerby, 1870','G. Sowerby, 1870','UNRANKED','','Linteria','','fasciata','','','',NULL,'','','','','','G. Sowerby','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11602','','','Purpura fasciata Dunker, 1856',1,'Purpura fasciata','Purpura fasciata','Purpura fasciat',2,0,'','','Dunker','9d1b699e-e266-5702-818f-c6c778ad2197','Purpura fasciata Dunker, 1856','Dunker, 1856','UNRANKED','','Purpura','','fasciata','','','',NULL,'','','','','','Dunker','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11605','','','Trochus helicinus fasciata Jeffreys, 1865',1,'Trochus helicinus fasciata','Trochus helicinus fasciata','Trochus helicin fasciat',3,0,'','','Jeffreys','08e7b253-ab31-55c2-ba20-33fbe1fe91b3','Trochus helicinus fasciata Jeffreys, 1865','Jeffreys, 1865','UNRANKED','','Trochus','','helicinus','fasciata','','',NULL,'','','','','','Jeffreys','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11610','','','Bulimus schomburgki fasciatus Martens, 1867',1,'Bulimus schomburgki fasciatus','Bulimus schomburgki fasciatus','Bulimus schomburgk fasciat',3,0,'','','Martens','26cfd6fc-384b-5dcb-832f-a7629d62c9c4','Bulimus schomburgki fasciatus Martens, 1867','Martens, 1867','UNRANKED','','Bulimus','','schomburgki','fasciatus','','',NULL,'','','','','','Martens','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11618','','','Cardinia fascicularis Buvignier, 1852',1,'Cardinia fascicularis','Cardinia fascicularis','Cardinia fascicular',2,0,'','','Buvignier','ab8afa22-d03c-588e-a744-5a8d389f6a5a','Cardinia fascicularis Buvignier, 1852','Buvignier, 1852','UNRANKED','','Cardinia','','fascicularis','','','',NULL,'','','','','','Buvignier','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11624','','','Hydrocena fasciolata Morelet, 1862',1,'Hydrocena fasciolata','Hydrocena fasciolata','Hydrocena fasciolat',2,0,'','','Morelet','ff708c51-6ab2-5340-bd3f-5c4b983880e4','Hydrocena fasciolata Morelet, 1862','Morelet, 1862','UNRANKED','','Hydrocena','','fasciolata','','','',NULL,'','','','','','Morelet','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11628','','','Pleurotoma fasciolata F. Edwards, 1860',1,'Pleurotoma fasciolata','Pleurotoma fasciolata','Pleurotoma fasciolat',2,0,'','','F. Edwards','9b4af677-f3b0-5da2-b582-13c7afdc4ef7','Pleurotoma fasciolata F. Edwards, 1860','F. Edwards, 1860','UNRANKED','','Pleurotoma','','fasciolata','','','',NULL,'','','','','','F. Edwards','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11633','','','Leda fastidiosa A. Adams, 1856',1,'Leda fastidiosa','Leda fastidiosa','Leda fastidios',2,0,'','','A. Adams','0b2319ca-4fab-57dd-9b31-1701c4a2b4f7','Leda fastidiosa A. Adams, 1856','A. Adams, 1856','UNRANKED','','Leda','','fastidiosa','','','',NULL,'','','','','','A. Adams','','','','1856','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11638','','','Melania fastigiata Anthony, 1854',1,'Melania fastigiata','Melania fastigiata','Melania fastigiat',2,0,'','','Anthony','edd0a1de-91e8-522e-a87b-8bcf33cbf9cd','Melania fastigiata Anthony, 1854','Anthony, 1854','UNRANKED','','Melania','','fastigiata','','','',NULL,'','','','','','Anthony','','','','1854','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11643','','','Melania fastigiella Reeve, 1860',1,'Melania fastigiella','Melania fastigiella','Melania fastigiell',2,0,'','','Reeve','5b945693-54ac-5b02-acc1-fe91c0bcddfb','Melania fastigiella Reeve, 1860','Reeve, 1860','UNRANKED','','Melania','','fastigiella','','','',NULL,'','','','','','Reeve','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11647','','','Trochonema (Eunema) fatua Hall, 1868',1,'Trochonema fatua','Trochonema fatua','Trochonema fatu',2,0,'','','Hall','d1088795-fb41-55da-8e74-a7ffd82ffbde','Trochonema (Eunema) fatua Hall, 1868','Hall, 1868','UNRANKED','','Trochonema','Eunema','fatua','','','',NULL,'','','','','','Hall','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11652','','','Helicina faustini Weinland, 1862',1,'Helicina faustini','Helicina faustini','Helicina faustin',2,0,'','','Weinland','c952baa2-bac4-5106-b384-e313903823f3','Helicina faustini Weinland, 1862','Weinland, 1862','UNRANKED','','Helicina','','faustini','','','',NULL,'','','','','','Weinland','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11655','','','Nerita favarottaensis Gemmellaro, 1866',1,'Nerita favarottaensis','Nerita favarottaensis','Nerita fauarottaens',2,0,'','','Gemmellaro','3b228628-ae0d-555b-b6e5-578c8c0823c5','Nerita favarottaensis Gemmellaro, 1866','Gemmellaro, 1866','UNRANKED','','Nerita','','favarottaensis','','','',NULL,'','','','','','Gemmellaro','','','','1866','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11659','','','Nautilus favranus Verchere, in Vemeuil, 1867',2,'Nautilus favranus','Nautilus favranus','Nautilus fauran',2,0,'','','Verchere|Vemeuil','1af2087e-1f40-5e1f-9ccf-57442971762c','Nautilus favranus Verchere, in Vemeuil, 1867','Verchere, in Vemeuil, 1867','UNRANKED','','Nautilus','','favranus','','','',NULL,'','','','','','Verchere','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11666','','','Cerithium fayellense Deshayes, 1864',1,'Cerithium fayellense','Cerithium fayellense','Cerithium fayellens',2,0,'','','Deshayes','f16d7ed0-6235-5403-acb5-83bafeb7ec7c','Cerithium fayellense Deshayes, 1864','Deshayes, 1864','UNRANKED','','Cerithium','','fayellense','','','',NULL,'','','','','','Deshayes','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11671','','','Pterocyclos feddeni Wr. Blanford, 1865',1,'Pterocyclos feddeni','Pterocyclos feddeni','Pterocyclos fedden',2,0,'','','Wr. Blanford','0c12b0c4-af93-554e-b1d4-ba5bdb9172a8','Pterocyclos feddeni Wr. Blanford, 1865','Wr. Blanford, 1865','UNRANKED','','Pterocyclos','','feddeni','','','',NULL,'','','','','','Wr. Blanford','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11679','','','Bulimus felix Pfeiffer, 1861',1,'Bulimus felix','Bulimus felix','Bulimus felix',2,0,'','','Pfeiffer','239506ce-a6f7-5192-9bae-57279f22cb82','Bulimus felix Pfeiffer, 1861','Pfeiffer, 1861','UNRANKED','','Bulimus','','felix','','','',NULL,'','','','','','Pfeiffer','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11681','','','Trochus felix Deshayes, 1863',1,'Trochus felix','Trochus felix','Trochus felix',2,0,'','','Deshayes','7e42b51a-6409-5916-a78e-4e60437b8676','Trochus felix Deshayes, 1863','Deshayes, 1863','UNRANKED','','Trochus','','felix','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11685','','','Arcopagia fenestrata Zittel, 1865',1,'Arcopagia fenestrata','Arcopagia fenestrata','Arcopagia fenestrat',2,0,'','','Zittel','947d6c6d-6784-5797-9cf1-9909c1502352','Arcopagia fenestrata Zittel, 1865','Zittel, 1865','UNRANKED','','Arcopagia','','fenestrata','','','',NULL,'','','','','','Zittel','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11691','','','Parthenia fenestrata A. Adams, 1860',1,'Parthenia fenestrata','Parthenia fenestrata','Parthenia fenestrat',2,0,'','','A. Adams','799b81dd-8324-57c0-af45-8238d69750ea','Parthenia fenestrata A. Adams, 1860','A. Adams, 1860','UNRANKED','','Parthenia','','fenestrata','','','',NULL,'','','','','','A. Adams','','','','1860','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11697','','','Cerithium fenestratum Laube, 1870',1,'Cerithium fenestratum','Cerithium fenestratum','Cerithium fenestrat',2,0,'','','Laube','b5ab4df4-9323-5c34-ada3-1f088db4e1ea','Cerithium fenestratum Laube, 1870','Laube, 1870','UNRANKED','','Cerithium','','fenestratum','','','',NULL,'','','','','','Laube','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11698','','','Cerithium fenestratum G. Sowerby, 1855',1,'Cerithium fenestratum','Cerithium fenestratum','Cerithium fenestrat',2,0,'','','G. Sowerby','fd67b4ee-6fdd-5985-b8dc-f2edf1be87ff','Cerithium fenestratum G. Sowerby, 1855','G. Sowerby, 1855','UNRANKED','','Cerithium','','fenestratum','','','',NULL,'','','','','','G. Sowerby','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11701','','','Fossar fenestratus A. Adams, 1863',1,'Fossar fenestratus','Fossar fenestratus','Fossar fenestrat',2,0,'','','A. Adams','bd3900e7-b24f-5b72-92e7-6b73b7c1a592','Fossar fenestratus A. Adams, 1863','A. Adams, 1863','UNRANKED','','Fossar','','fenestratus','','','',NULL,'','','','','','A. Adams','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11706','','','Helix ferculum Deshayes, 1863',1,'Helix ferculum','Helix ferculum','Helix fercul',2,0,'','','Deshayes','ac689d11-881a-5ac0-82eb-a654747a5fef','Helix ferculum Deshayes, 1863','Deshayes, 1863','UNRANKED','','Helix','','ferculum','','','',NULL,'','','','','','Deshayes','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11709','','','Succinea fernandeziana Philippi, 1858',1,'Succinea fernandeziana','Succinea fernandeziana','Succinea fernandezian',2,0,'','','Philippi','c9bad536-4d3d-50ca-a133-281d22f4aa09','Succinea fernandeziana Philippi, 1858','Philippi, 1858','UNRANKED','','Succinea','','fernandeziana','','','',NULL,'','','','','','Philippi','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11717','','','Myoconcha ferreti Gueranger, 1853',1,'Myoconcha ferreti','Myoconcha ferreti','Myoconcha ferret',2,0,'','','Gueranger','dc0be0a3-4e77-5d33-ba7c-808da911a568','Myoconcha ferreti Gueranger, 1853','Gueranger, 1853','UNRANKED','','Myoconcha','','ferreti','','','',NULL,'','','','','','Gueranger','','','','1853','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11720','','','Alvania ferruginea A. Adams, 1861',1,'Alvania ferruginea','Alvania ferruginea','Alvania ferrugine',2,0,'','','A. Adams','3f6d068e-a333-55b5-b13d-ecfd0bede9ce','Alvania ferruginea A. Adams, 1861','A. Adams, 1861','UNRANKED','','Alvania','','ferruginea','','','',NULL,'','','','','','A. Adams','','','','1861','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11725','','','Helix pisana ferruginea A. Moquin-Tandon, 1855',1,'Helix pisana ferruginea','Helix pisana ferruginea','Helix pisan ferrugine',3,0,'','','A. Moquin-Tandon','3b1fd3d7-7067-5940-8cb3-aeaa1d62798e','Helix pisana ferruginea A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Helix','','pisana','ferruginea','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11728','','','Physa ferruginea A. Adams and Angas, 1863',1,'Physa ferruginea','Physa ferruginea','Physa ferrugine',2,0,'','','A. Adams|Angas','7c1565fb-3f36-5381-bdce-c3686fd4cca6','Physa ferruginea A. Adams and Angas, 1863','A. Adams and Angas, 1863','UNRANKED','','Physa','','ferruginea','','','',NULL,'','','','','','A. Adams & Angas','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11733','','','Truncatella ferruginea Cox, 1868',1,'Truncatella ferruginea','Truncatella ferruginea','Truncatella ferrugine',2,0,'','','Cox','8cd9b74c-4b18-57a9-a464-773f7a045abb','Truncatella ferruginea Cox, 1868','Cox, 1868','UNRANKED','','Truncatella','','ferruginea','','','',NULL,'','','','','','Cox','','','','1868','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11740','','','Opis ferryi Dumortier, 1869',1,'Opis ferryi','Opis ferryi','Opis ferry',2,0,'','','Dumortier','9a64d805-0463-50c0-981e-9287abc66bc9','Opis ferryi Dumortier, 1869','Dumortier, 1869','UNRANKED','','Opis','','ferryi','','','',NULL,'','','','','','Dumortier','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11746','','','Achatinella ferussaci Pfeiffer, 1859',1,'Achatinella ferussaci','Achatinella ferussaci','Achatinella ferussac',2,0,'','','Pfeiffer','49132f81-83c6-5e82-a3fc-e417f05ff019','Achatinella ferussaci Pfeiffer, 1859','Pfeiffer, 1859','UNRANKED','','Achatinella','','ferussaci','','','',NULL,'','','','','','Pfeiffer','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11748','','','Orthalicus ferussaci Martens, 1863',1,'Orthalicus ferussaci','Orthalicus ferussaci','Orthalicus ferussac',2,0,'','','Martens','cb7a4518-857a-5126-b805-a076b6e9c409','Orthalicus ferussaci Martens, 1863','Martens, 1863','UNRANKED','','Orthalicus','','ferussaci','','','',NULL,'','','','','','Martens','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11753','','','Succinea putris ferussina A. Moquin-Tandon, 1855',1,'Succinea putris ferussina','Succinea putris ferussina','Succinea putr ferussin',3,0,'','','A. Moquin-Tandon','254b0101-76ca-5704-8fac-4fa3c5e59571','Succinea putris ferussina A. Moquin-Tandon, 1855','A. Moquin-Tandon, 1855','UNRANKED','','Succinea','','putris','ferussina','','',NULL,'','','','','','A. Moquin-Tandon','','','','1855','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11756','','','Zonites festinans Shuttleworth, 1852',1,'Zonites festinans','Zonites festinans','Zonites festinans',2,0,'','','Shuttleworth','026ba6e1-c748-5fa9-b06d-3af6b5ac7e7f','Zonites festinans Shuttleworth, 1852','Shuttleworth, 1852','UNRANKED','','Zonites','','festinans','','','',NULL,'','','','','','Shuttleworth','','','','1852','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11762','','','Turbo festiva nil la Folin, 1867',1,'Turbo festiva nil','Turbo festiva nil','Turbo festiu nil',3,0,'','','la Folin','c8a0e60a-bc69-5849-b234-e4a536f6c010','Turbo festiva nil la Folin, 1867','la Folin, 1867','UNRANKED','','Turbo','','festiva','nil','','',NULL,'','','','','','la Folin','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11766','','','Cerithium festuca Issel, 1869',1,'Cerithium festuca','Cerithium festuca','Cerithium festuc',2,0,'','','Issel','cf0a77a9-b0bc-5b72-b0ec-57bc646f1e28','Cerithium festuca Issel, 1869','Issel, 1869','UNRANKED','','Cerithium','','festuca','','','',NULL,'','','','','','Issel','','','','1869','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11771','','','Avicula fibrosa Reeve, 1857',1,'Avicula fibrosa','Avicula fibrosa','Avicula fibros',2,0,'','','Reeve','360615b9-0faf-5520-b416-c4f71b807e90','Avicula fibrosa Reeve, 1857','Reeve, 1857','UNRANKED','','Avicula','','fibrosa','','','',NULL,'','','','','','Reeve','','','','1857','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11773','','','Lucina fibrosa Shumard, 1858',1,'Lucina fibrosa','Lucina fibrosa','Lucina fibros',2,0,'','','Shumard','21aee329-2b26-53cf-8a33-9c57313c2bb1','Lucina fibrosa Shumard, 1858','Shumard, 1858','UNRANKED','','Lucina','','fibrosa','','','',NULL,'','','','','','Shumard','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11779','','','Melania fibula Deshayes, 1862',1,'Melania fibula','Melania fibula','Melania fibul',2,0,'','','Deshayes','b419b2e8-3b8d-5162-8f9c-7fe76a29f937','Melania fibula Deshayes, 1862','Deshayes, 1862','UNRANKED','','Melania','','fibula','','','',NULL,'','','','','','Deshayes','','','','1862','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11786','','','Helix ficta Pease, 1864',1,'Helix ficta','Helix ficta','Helix fict',2,0,'','','Pease','c3000afa-e6ab-51a7-85f1-ec889b323dad','Helix ficta Pease, 1864','Pease, 1864','UNRANKED','','Helix','','ficta','','','',NULL,'','','','','','Pease','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11789','','','Whitneya ficus Gabb, 1864',1,'Whitneya ficus','Whitneya ficus','Whitneya fic',2,0,'','','Gabb','7cbbdd8d-ac25-5f25-b7e2-e080f952856a','Whitneya ficus Gabb, 1864','Gabb, 1864','UNRANKED','','Whitneya','','ficus','','','',NULL,'','','','','','Gabb','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11797','','','Lucina fieldingi H. Adams, 1870',1,'Lucina fieldingi','Lucina fieldingi','Lucina fielding',2,0,'','','H. Adams','86660c36-f382-53ec-bca8-681358985286','Lucina fieldingi H. Adams, 1870','H. Adams, 1870','UNRANKED','','Lucina','','fieldingi','','','',NULL,'','','','','','H. Adams','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11804','','','Pecten gemmellari filii Giunti, in Biondi, 1859',2,'Pecten gemmellari filii','Pecten gemmellari filii','Pecten gemmellar fil',3,0,'','','Giunti|Biondi','14bb8246-2caa-5ec5-b2f1-ae8e53b461ba','Pecten gemmellari filii Giunti, in Biondi, 1859','Giunti, in Biondi, 1859','UNRANKED','','Pecten','','gemmellari','filii','','',NULL,'','','','','','Giunti','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11809','','','Truncatella filicosta Gundlach, in Pfeiffer and Gundlach, 1860',2,'Truncatella filicosta','Truncatella filicosta','Truncatella filicost',2,0,'','','Gundlach|Pfeiffer','975bcaba-435f-5026-8866-6cccbc41e72a','Truncatella filicosta Gundlach, in Pfeiffer and Gundlach, 1860','Gundlach, in Pfeiffer and Gundlach, 1860','UNRANKED','','Truncatella','','filicosta','','','',NULL,'','','','','','Gundlach','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11816','','','Cypraea filiola Mayer, 1870',1,'Cypraea filiola','Cypraea filiola','Cypraea filiol',2,0,'','','Mayer','4c030996-8c2a-574a-b28d-01c4e98018da','Cypraea filiola Mayer, 1870','Mayer, 1870','UNRANKED','','Cypraea','','filiola','','','',NULL,'','','','','','Mayer','','','','1870','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11820','','','Cyclostoma filocinctum Benson, 1851',1,'Cyclostoma filocinctum','Cyclostoma filocinctum','Cyclostoma filocinct',2,0,'','','Benson','270d2e5b-b070-53fa-95ed-cbd6e7b38e8f','Cyclostoma filocinctum Benson, 1851','Benson, 1851','UNRANKED','','Cyclostoma','','filocinctum','','','',NULL,'','','','','','Benson','','','','1851','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11827','','','Arcoperna filosa Conrad, 1865',1,'Arcoperna filosa','Arcoperna filosa','Arcoperna filos',2,0,'','','Conrad','4e790451-0c7a-5896-af72-fccd345a243c','Arcoperna filosa Conrad, 1865','Conrad, 1865','UNRANKED','','Arcoperna','','filosa','','','',NULL,'','','','','','Conrad','','','','1865','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11834','','','Kennerlia filosa P. Carpenter, 1864',1,'Kennerlia filosa','Kennerlia filosa','Kennerlia filos',2,0,'','','P. Carpenter','79830bc1-774e-56ea-a3d8-1600329e67c0','Kennerlia filosa P. Carpenter, 1864','P. Carpenter, 1864','UNRANKED','','Kennerlia','','filosa','','','',NULL,'','','','','','P. Carpenter','','','','1864','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11841','','','Siphonalia filosa A. Adams, 1863',1,'Siphonalia filosa','Siphonalia filosa','Siphonalia filos',2,0,'','','A. Adams','9a32848a-ea07-5778-bc8d-eb0c8eed3151','Siphonalia filosa A. Adams, 1863','A. Adams, 1863','UNRANKED','','Siphonalia','','filosa','','','',NULL,'','','','','','A. Adams','','','','1863','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11846','','','Aesopus filosus Angas, 1867',1,'Aesopus filosus','Aesopus filosus','Aesopus filos',2,0,'','','Angas','5b8e7c60-c9ae-5621-95fc-f760550547cd','Aesopus filosus Angas, 1867','Angas, 1867','UNRANKED','','Aesopus','','filosus','','','',NULL,'','','','','','Angas','','','','1867','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11852','','','Aplysia fimbriata Adams and Reeve, in G. Sowerby, 1869',2,'Aplysia fimbriata','Aplysia fimbriata','Aplysia fimbriat',2,0,'','','Adams|Reeve|G. Sowerby','0fce718a-ffd8-568b-b92d-913982c3db7f','Aplysia fimbriata Adams and Reeve, in G. Sowerby, 1869','Adams and Reeve, in G. Sowerby, 1869','UNRANKED','','Aplysia','','fimbriata','','','',NULL,'','','','','','Adams & Reeve','','','','','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11858','','','Crepidula fimbriata Reeve, 1859',1,'Crepidula fimbriata','Crepidula fimbriata','Crepidula fimbriat',2,0,'','','Reeve','ca00bd37-8383-5711-8b7b-c6f7a5cf4be8','Crepidula fimbriata Reeve, 1859','Reeve, 1859','UNRANKED','','Crepidula','','fimbriata','','','',NULL,'','','','','','Reeve','','','','1859','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11866','','','Perna fimbriata Reeve, 1858',1,'Perna fimbriata','Perna fimbriata','Perna fimbriat',2,0,'','','Reeve','25a9f5dd-25f7-5ed4-8138-8335ae661ce1','Perna fimbriata Reeve, 1858','Reeve, 1858','UNRANKED','','Perna','','fimbriata','','','',NULL,'','','','','','Reeve','','','','1858','ZOOLOGICAL','ESTABLISHED','','','','','',NULL,'','','','','');
INSERT INTO name VALUES('gn_11870','','','Terebra fimbriata Deshayes, 1857',1,'Terebra fimbriata','Terebra fimbriata','Terebra fimbriat',2,0,'','','Deshayes','ce70b45f-41b4-58a5-ba0c-45343420ed49','Terebra fimbriata Deshayes, 1857','Deshayes, 1857','UNRANKED','','Terebra','','fimbria