PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE version (id TEXT NOT NULL) STRICT;
INSERT INTO version VALUES('v0.3.33');
CREATE TABLE metadata (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__doi TEXT DEFAULT '',
  col__title TEXT NOT NULL,
  col__alias TEXT DEFAULT '',
  col__description TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__version TEXT DEFAULT '',
  col__keywords TEXT DEFAULT '',
  col__geographic_scope TEXT DEFAULT '',
  col__taxonomic_scope TEXT DEFAULT '',
  col__temporal_scope TEXT DEFAULT '',
  col__confidence INTEGER DEFAULT NULL,
  col__completeness INTEGER DEFAULT NULL,
  col__license TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__logo TEXT DEFAULT '',
  col__label TEXT DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__private INTEGER DEFAULT NULL -- bool 
) STRICT;
INSERT INTO metadata VALUES(1,'','USDA National Plant Germplasm System','GRIN Plant Taxonomy',unistr('The USDA National Plant Germplasm System (NPGS), often referred to through its associated database, the Germplasm Resources Information Network (GRIN), is a vital resource for preserving and providing access to plant genetic diversity.\u000a\u000aThe Germplasm Resources Information Network (GRIN) provides information about the United States Department of Agriculture (USDA national collections of animal, microbial, and plant genetic resources (germplasm) important for food and agricultural production. GRIN documents these collections through informational pages, searchable databases, and links to USDA-ARS projects that curate the collections. '),'2025-10-04','','','','','',0,0,'','https://npgsweb.ars-grin.gov/gringlobal/taxon/abouttaxonomy','','','',0);
CREATE TABLE contact (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT NOT NULL,
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE editor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE creator (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE publisher (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT DEFAULT '',
  col__family TEXT DEFAULT '',
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE contributor (
  col__id INTEGER PRIMARY KEY AUTOINCREMENT,
  col__metadata_id INTEGER DEFAULT 1,
  col__orcid TEXT DEFAULT '',
  col__given TEXT NOT NULL,
  col__family TEXT NOT NULL,
  col__rorid TEXT DEFAULT '',
  col__department TEXT DEFAULT '',
  col__organisation TEXT DEFAULT '',
  col__city TEXT DEFAULT '',
  col__state TEXT DEFAULT '',
  col__country TEXT DEFAULT '',
  col__email TEXT DEFAULT '',
  col__url TEXT DEFAULT '',
  col__note TEXT DEFAULT ''
) STRICT;
CREATE TABLE source (
  col__id TEXT PRIMARY KEY,
  col__metadata_id INTEGER DEFAULT 1,
  col__type TEXT DEFAULT '',
  col__title TEXT DEFAULT '',
  col__authors TEXT DEFAULT '',
  col__issued TEXT DEFAULT '',
  col__isbn TEXT DEFAULT ''
) STRICT;
CREATE TABLE author (
  col__id TEXT PRIMARY KEY,
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__alternative_id TEXT DEFAULT '', -- sep by ','
  col__given TEXT DEFAULT '',
  col__family TEXT NOT NULL,
  -- f. for filius,  Jr., etc
  col__suffix TEXT DEFAULT '',
  col__abbreviation_botany TEXT DEFAULT '',
  col__alternative_names TEXT DEFAULT '', -- separated by '|'
  col__sex_id TEXT REFERENCES sex DEFAULT '',
  col__country TEXT DEFAULT '',
  col__birth TEXT DEFAULT '',
  col__birth_place TEXT DEFAULT '',
  col__death TEXT DEFAULT '',
  col__affiliation TEXT DEFAULT '',
  col__interest TEXT DEFAULT '',
  col__reference_id TEXT DEFAULT '', -- sep by ','
  -- url
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
CREATE TABLE reference (
  col__id TEXT PRIMARY KEY,
  col__alternative_id TEXT DEFAULT '', -- sep by ',', scope:id, id, URI/URN
  col__source_id TEXT REFERENCES source DEFAULT '',
  col__citation TEXT DEFAULT '',
  col__type_id TEXT REFERENCES reference_type DEFAULT '',
  -- author/s in format of either
  -- family1, given1; family2, given2; ..
  -- or
  -- given1 family1, given2 family2, ...
  col__author TEXT DEFAULT '',
  col__author_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor TEXT DEFAULT '', -- 'ref' author, sep ','
  col__editor_id TEXT DEFAULT '', -- 'ref' author, sep ','
  col__title TEXT DEFAULT '',
  col__title_short TEXT DEFAULT '',
  -- container_author is an author or a parent volume (book, journal) 
  col__container_author TEXT DEFAULT '',
  -- container_title of the parent container
  col__container_title TEXT DEFAULT '',
  -- container_title_short of the parent container
  col__container_title_short TEXT DEFAULT '',
  col__issued TEXT DEFAULT '', -- yyyy-mm-dd
  col__accessed TEXT DEFAULT '', -- yyyy-mm-dd
  -- collection_title of the parent volume
  col__collection_title TEXT DEFAULT '',
  -- collection_editor of the parent volume
  col__collection_editor TEXT DEFAULT '',
  col__volume TEXT DEFAULT '',
  col__issue TEXT DEFAULT '',
  -- edition number
  col__edition TEXT DEFAULT '',
  -- page number
  col__page TEXT DEFAULT '',
  col__publisher TEXT DEFAULT '',
  col__publisher_place TEXT DEFAULT '',
  -- version of the reference
  col__version TEXT DEFAULT '',
  col__isbn TEXT DEFAULT '',
  col__issn TEXT DEFAULT '',
  col__doi TEXT DEFAULT '',
  col__link TEXT DEFAULT '',
  col__remarks TEXT DEFAULT '',
  col__modified TEXT DEFAULT '',
  col__modified_by TEXT DEFAULT ''
) STRICT;
INSERT INTO reference VALUES('ad2bdd97-79bb-5880-a0f8-00e4613f87fc','','','Rosac. monogr. 1:57.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34a9607d-51c8-5766-8777-01a4db4ce829','','','Fl. austral. 2:179.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6294db99-6419-59f4-8553-425a36c2bf59','','','Fl. cochinch. 1:105.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb7746b4-853c-5d3f-8050-f15996340a16','','','Phytologia 44:241.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae5bcd43-8663-5f25-b1c6-eea065c142fb','','','Gard. Chron. ser. 2, 4:36.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed1b5154-5d6b-5037-a1f0-7ea967a21318','','','Willdenowia 20:108.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afa1d599-d7f0-5ad8-becc-3fdc1e80b7dd','','','Asiat. Res. 11:334.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05209746-2515-5ea1-bcd9-898ee2256214','','','Rumphia 3:178.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('341f9d50-29f7-58b8-af3c-73e688575394','','','J. M. J. de Wet et al., Amer. J. Bot. 68:274, fig. 6.  1981 as "<I>cundinamarce</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f880104-0e26-5cdf-9c94-de99bbec6903','','','Muhlenbergia 1:108.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('826d5c54-ddd6-59ec-9930-742458a84b59','','','Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 27:508.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3ff8e77-d22d-503b-9751-387c2f32615c','','','Guihaia 7:220.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5099b2ed-1be3-5803-9440-b107d344191d','','','Kew Bull. 17:120.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3956d073-09ee-58fe-928e-d710649e082f','','','Enum. pl. 2:328.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c1f0812-2fdb-5f08-8e5b-ba6b970b3b35','','','J. S. African Bot. 41:109.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc73f83f-eb73-5a0a-a621-52b948ed304c','','','Gard. Chron. ser. 2, 20:262.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('500c4e42-7594-5593-a91e-91c3c4e2c118','','','Bull. Torrey Bot. Club 19:221.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f676c123-ac2d-5e47-ae59-b94b41e9cf1a','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 3:439.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8439f558-5f4b-57f9-971d-2b3b7a520bf7','','','Comp. fl. philadelph. 2:178.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c489db8a-b7b0-5186-beac-1afc542ea8c7','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:179[folio]; 6:227[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab40a69b-9fb9-5b0d-b82e-ba6dc4b4468e','','','Sp. pl. 2:1085.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89137783-fe71-5de0-8cdb-3c585dc90143','','','Fl. bor.-amer. 1:173.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88790e5b-f9ca-58d7-b72d-e1fce4900091','','','Arch. Bot. Mém. 7:82.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc04bd18-063f-5053-a697-93e63b0b18e2','','','Pittonia 2:68.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c129a786-3e8a-50d1-bbab-b058e6125ec0','','','Deut. Fl. 790.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fc266a7-90d5-5fc8-a308-ce16268bee8c','','','Trudy Prikl. Bot. 51:224.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2addf21f-a323-5770-a8ac-6da00d1b239d','','','Ann. Bot. (Usteri) 10:46.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dddbffca-e96a-57aa-8471-6724abe1fdd7','','','Amer. J. Bot. 3:581.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e698a706-5014-5959-8db3-98d9db577b4a','','','Mem. New York Bot. Gard. 65:751.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ea7c675-83b8-561a-befe-6e3e36b795e8','','','O. C. E. M. G. de Kerchove de Denterghem, Palmiers 244.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b28e73fe-f078-50cc-95de-c75934f8a93f','','','Prodr. stirp. Chap. Allerton 40(43).  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('101f924a-29c5-56da-88b3-31050e838509','','','K. B. Presl, Reliq. haenk. 1:271.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('203bfad7-3b00-5222-9b6a-19c807a93396','','','Prodr. 6:366.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a61567cd-0e30-5045-98af-fcfac708a1cc','','','Bull. Torrey Bot. Club 26:131.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('709f522b-01f8-5a99-b713-2be8aa60ee03','','','J. Bot. (Morot) 8:294.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f31b61e-84fa-54cb-bf00-83635c834b0e','','','Encycl. 6:408.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36c2f75e-c1b6-53df-b354-5e9b23709f03','','','Bot. Jahrb. Syst. 4:23.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa9de860-a446-52bb-abca-14d6d26eddf4','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 26:385.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acf8acb5-babe-59a2-b69f-f744181bc763','','','C. S. Sargent, Pl. wilson. 1:192.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b4beb42-f0fb-5f4f-9494-21e738b21811','','','J. Arnold Arbor. 26:480.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a09810cd-ccbc-5c90-94ec-6c1a9d634204','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 3:536.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e973325-c479-5352-a586-080396731c9d','','','Linnaea 26:613.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f4b1cbd-0542-52f8-b658-43ebba34ddf7','','','N. Amer. fl. 24:3.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6497a6bc-fa7a-53de-9dba-35d30a364f7b','','','Bull. Sci. Acad. Imp. Sci. Saint-Pétersbourg 2:813.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57628b5d-9730-53d7-811e-a444b9c8a851','','','Phytogr. Lusit. select. 2:198.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('395b83c5-ade7-563a-a6d8-fac4fe2f17ec','','','Kew Bull. 44:714.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47a309ec-c370-50d9-bab5-abe4cbd4f055','','','Herb. raf. 72.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c2ed6c1-ae64-5cc2-be43-14f954e51a32','','','Bull. Torrey Bot. Club 69:154.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88df2fc9-3ea3-5494-ac8e-fcc8d57fd71f','','','Repert. Spec. Nov. Regni Veg. 23:359.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa372370-f62b-507a-81a1-33c42f83b2f6','','','Calcutta J. Nat. Hist. 8:174.  1847 (Icon. pl. Ind. orient.t. 1192.  1848)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('351be0f3-b746-5803-9ee3-922c199b7d68','','','Bull. Torrey Bot. Club 17:14, t. 99.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5ffaccb-53f7-568d-8e7c-1bf7d6946820','','','E. Nasir & S. I. Ali, Fl. W. Pakistan 59:15.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0d82fe5-d825-5d08-bcaa-6f8d3f7d6e2a','','','Bull. Misc. Inform. Kew 1928:239.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5344b44-9afd-55d9-b25e-97156e36c7fa','','','Bull. Herb. Boissier 6:729.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb058891-8697-5e8e-a23a-bc40f89df217','','','Fl. Brit. India 1:515.  1875, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d043199-bcb7-56c5-8273-5998acf32ae3','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 5:631.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fa6a40a-3c8f-5f9a-b425-a3a9a6cbe180','','','Prodr. 4:138.  1830 (W. Roxburgh, Hort. bengal. 21.  1814, nom. nud. "<I>Pellandrium stoloniferum</I> Roxb.")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a913d69c-b1ef-5d4c-aa68-dd608fb1523b','','','Bull. Herb. Boissier sér. 2, 8:739.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90d4540e-2026-56f5-bd1a-e676d28b47a5','','','Kew Bull. 21:480.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf9c50f2-5d50-54b1-9617-172856520410','','','Opera Bot. 88:108.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dda3e76c-0084-5a1f-b738-d99e53aa428a','','','Bull. Seoul Nat. Univ. For. 2:25.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4671ebbe-4789-56cd-b239-85354ff12835','','','W. G. Walpers, Ann. bot. syst. 3:660.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81bd717d-37fe-5a87-bef7-3b91cb7703bc','','','Prodr. 534.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9339194d-1f55-5b0e-8223-cf1ee0c9ebdc','','','Bull. Bur. Pl. Industr. U.S.D.A. 179:20.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('157d27d0-2708-5a3c-a104-8908b06e8e57','','','Bull. Soc. Bot. France 18:140.  1872 ("1871")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12c57ca1-3d92-53e0-8864-3c87568b5c9f','','','Nov. stirp. bras. 72.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('622baa49-216c-52c9-a59c-737963af748d','','','Fl. bor.-amer. 1:73.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66b60060-0156-532a-b5de-9033ccfad4fc','','','Collectanea 2:307.  1789 ("1788"); Icon. pl. rar. 3: t. 551.  1792 ("1786-1793")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c151a59-da2f-56a1-8ce8-b324cee4f51f','','','Ann. Mus. Bot. Lugduno-Batavi 2:91.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22d2cda8-7fd9-5427-8f88-6935e1b95f34','','','Fl. germ. excurs. 733.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec5d3a03-5402-5198-bdfa-1ea832bc3839','','','Flora 38:196.  1855 "<I>serraefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a753146-872e-55da-a2d6-8ea5bdbb5009','','','Syst. Bot. 37:633.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76588bf2-24ed-546d-8a10-6f27fa182ae2','','','Bull. Mus. Natl. Hist. Nat., B, Adansonia sér. 4, 18:211.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af7293c8-32d1-5572-99c0-b6b98748c07e','','','Bull. Soc. Bot. Genève sér. 2, 5:309.  1914 ','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b48c289-bd19-5370-90b3-4c98f93d78b2','','','Fl. bor.-amer. 1:74.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e3616fa-1e66-5361-8be0-d8bba7ece3e5','','','Interpr. Herb. amboin. 211.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7dc448d8-0c51-5233-98fe-91ee32bab56f','','','Hist. nat. Iles Canaries 3(2,1):112.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a31fab8-009c-5f5f-bd96-e6dc226fa5fa','','','Monatsschr. Kakteenk. 6:96.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cd02a1b-6f17-5f93-9600-9b86df361244','','','Estud. tax. <I>Lonchocarpus</I> e <I>Deguelia</I> no Brasil. Ph.D. Diss., Univ. Est. Campinas 52.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a7265bc-e61c-5f5a-aa9b-4ee0a50e7976','','','J. Bot. 12:294.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7cd984f-ad41-5b60-ac23-226741a8a4e3','','','Flora 25(2, Beibl.):23.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd92429f-a10b-5880-9dec-51b092951235','','','Bijdr. 873.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('374da75f-0ec5-591e-b082-790d90931a30','','','Pl. wright. 1:70.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe210686-38ba-5d8e-9272-7d0a3a1981ca','','','Encycl. 1:424.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf57197f-78aa-522b-96ae-8fba08a2fe3f','','','Bull. Soc. Bot. France 44:269.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b97ac639-70de-5c76-99cf-b54282b5e608','','','S. L. Endlicher et al., Enum. pl. 56.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3a27212-5c38-54bd-93e4-5a4623bfd8be','','','Mitt. Deutsch. Dendrol. Ges. 15:180.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e757fa9d-f0b3-571a-87cf-e44ea1715527','','','Nachr. Königl. Ges. Wiss. Georg-Augusts-Univ. 3:77.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e6e1a0c-a12f-5d14-b11b-a4f9ca27f4d9','','','J. Arnold Arbor. 7:25.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55fccc84-58dc-5c84-b4d2-02f3af86999f','','','J. Jap. Bot. 11:687.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f69cbd7-3c8f-5efe-ace9-45bdeae34c7d','','','Math. Term. Közl. 24:105.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43b65227-0eb9-5b04-95a6-2656dc41f4c3','','','Enum. pl. Jap. 1:144.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70a119b0-12d0-523a-88cd-9a4c3a9215ce','','','Rev. Bot. Appl. Agric. Colon. 5:206.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da381de4-aeb5-5868-9a8a-3487d8b0622f','','','Traité bot. méd. phan. 2:841.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4eb9cdc7-3dca-5da8-984c-cb9d07ef078e','','','Bot. gall. 124.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2cff839-14b5-55ee-9985-77379db31002','','','Sp. pl. 2:893.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9aa65312-b0e0-5994-a0f3-482e3feb26d7','','','Artemis. 29.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ace1d0ae-48ea-57ce-ac07-bf7d120ced73','','','New Fl. 2:63.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6568f420-af45-51b9-9c8c-bfb25c74665f','','','Proc. Biol. Soc. Washington 48:39.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e3854f5-1cf0-5808-8366-a1216fecfb41','','','Suppl. prodr. fl. Nov. Holl. 24.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8493fd6a-21da-57a8-98de-0254497af4e2','','','Bull. Misc. Inform. Kew 1910:197.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c4920b6-9394-54a4-99a3-1773fd54bf2b','','','Notul. Syst. (Paris) 6:47.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a97ca21-0c24-52c6-a7e0-be66b03a7e3d','','','Trans. Hort. Soc. London 5:446.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c199987-c61d-51da-b263-051a53a44982','','','Sp. pl. 2:992.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0351584-763e-5a1b-8967-9c90315502fd','','','Torrey Bot. Club 55:316.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9211f853-cfc9-51aa-a751-cdfb93a8762c','','','Descr. pl. nouv. ad t. 76.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e034de2-b808-5252-adb5-70c0cc78bb05','','','C. F. von Ledebour, Fl. altaic. 2:272.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ece0ead5-abe3-5523-b3d8-751f258b90dc','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 16: 676.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbe18cb9-f8e0-5644-a3fa-73b6f42bae1f','','','C. F. P. von Martius et al., Fl. bras. enum. pl. 2(1):84.  1829 (Agrost. bras.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d68d63dc-dd6a-5b06-949e-211ee4e6eede','','','Reise russ. Reich. 3:730.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97a4ca5c-d884-5cc3-bd7c-22d7c85a9817','','','Encycl. 1:695.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2285538f-595a-5034-92ea-3815ae1f61a6','','','Acta Phytotax. Sin. 27:399.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23fb6935-2634-58e0-8498-24e090c8ebcd','','','S. Watson et al., Botany [fortieth parallel] 64, t. 10.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d983782-0395-55ad-ada2-9eb5bd204930','','','Novon 12:325.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1785b2bc-d0e4-5ec3-8df8-841743a141f6','','','Trans. Acad. Sci. St. Louis 12:60.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('239ec487-db72-5b1e-b63c-a3cf3e57b704','','','Fl. ind. ed. 1832, 3:290.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d774366d-a3d6-5c5f-b720-b2fac1b2cfc9','','','Ann. Mus. Bot. Lugduno-Batavi 1:211.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64b95fb3-93c4-5716-a251-46842eee77bd','','','Mem. Amer. Acad. Arts ser. 2, 4:110.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35a1d7c4-0070-568c-99b0-6c188952b77a','','','Magyar Növényt. Lapok 13:79.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('525f288c-66c5-557b-88a7-cc0a9b7644b8','','','Bot. Jahrb. Syst. 18:103.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb50e7d0-1df0-5265-b301-50d92ce01cc5','','','Observ. bot. 3:56.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fbfc5ed-1d5f-51f4-be36-7160136fbc45','','','Fl. franç. 2:651.  1779 ("1778")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('407d964a-c2da-545a-b2b8-8eebaa3b1b78','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:82[folio]; 5:106[quarto], t. 440.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('152e3334-a7a2-57c8-ad28-62affbb95d15','','','Handbuch 2:140.  1831 "<I>marylandica</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bdcaa8a-2db3-5985-aea0-671953b96dbf','','','Cat. afr. pl. 1:94.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eae8c244-c499-5d7c-a3d3-0b78342c4d16','','','Kulturnaya Fl. SSSR 1:368.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02b97dcc-f413-5402-9bff-fad5848bde0e','','','23rd. Congr. Nac. Bot., Garanhuns 109.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7144466e-dd96-5f2b-8a05-7a1213cfb66c','','','Ferns S. E. States 279.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45cb7dab-d4ef-597b-aa96-affd2bfca0c8','','','H. G. A. Engler, Pflanzenr. IV. 147. VII(Heft 63):245.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90f79476-0c73-55ca-a74b-f5e7949351bc','','','Syn. mitteleur. Fl. 3:105.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92396d2e-9683-5395-b125-e236fd1b5d09','','','Ann. Mus. Bot. Lugduno-Batavi 3:128.  1867 (A. L. P. P. de Candolle, Prodr. 16(1):20.  1869)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c992acf6-ebb4-5e6b-ab73-5e5c15659c41','','','G. Hegi, Ill. Fl. Mitt.-Eur. 5(3):1753.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c57bbce4-d780-55e8-817c-f70d1040d745','','','J. Amer. Soc. Agron. 6:84.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bc44aa5-4daa-5f07-81ab-84e263e731f8','','','Bonplandia 7:337.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b0ddfe5-c2b2-5128-b0e6-b8f66aaad3cf','','','Kew Bull. 62:647.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfb9d50a-27c8-5490-8e52-6b9ca34c6cfa','','','Rumphia 3:57.  1849 ("1847")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01d08d35-3fa9-54c6-91c7-26d8a8e9abe0','','','Sp. pl. 3(2):1058.  1802, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80907113-14b9-5f3f-a902-2f9f9fdfb2b3','','','Telopea 6:227.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60527cfc-78b3-541d-96b0-8b3019564d3e','','','J. Elisha Mitchell Sci. Soc. 72:149.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d8b1e52-e155-5a2d-b3b8-80b3481b509c','','','J. Coll. Sci. Imp. Univ. Tokyo 25:105.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9b2ece8-1383-58a5-8753-99b2b9010e84','','','Hist. pl. Guiane 784, t. 311.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f632734e-790b-561e-a04c-fbd0835b1119','','','Neue Schriften Ges. Naturf. Freunde Berlin 4:198.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1be26dc8-0199-56b5-91aa-fb958f7575df','','','Hooker''s Icon. Pl. 19: t. 1863.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee8cc1f9-1f77-5b13-a29a-e086ff63546a','','','Gesamtbeschr. Kakt. 754.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c4a472b-26bb-5f86-ad85-7fa891cc119e','','','Enum. pl. hort. hafn. suppl. 2 [1806]:12.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b263f33a-5c41-5501-b52a-0613fad4a19f','','','Feddes Repert. 95:435.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3eed951-3920-5fc8-8282-1fcaa2300e98','','','Bot. Jahrb. Syst. 37:545.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c05f613-7a5f-5670-a075-b81f8e388dff','','','Bot. Jahrb. Syst. 43:120.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f300b591-4026-576f-98ef-bed7ae2124fe','','','J. Bot. (Morot) 8:289.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8657aa94-8362-5378-97ad-cfed31475b00','','','J. Bot. 13:229.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2963a63-49b3-532c-a846-edf263ca3895','','','Fl. trop. Afr. 1:105.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9de4ce86-db8e-512e-9947-98fcfc6d4d7c','','','Contr. U.S. Natl. Herb. 20:78.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f064896f-ae36-5b5f-b09a-f295a5b1a670','','','Med. fl. 1:210.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3739391d-d041-552c-abf2-213455a7927d','','','Adansonia sér. 2. 15:202.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de0cc8b6-c5de-5254-8ca8-fb2cc8394fd1','','','Gen. hist. 4:32.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6cac2f6-edaf-5ea9-a609-45dde79132de','','','Rhodora 10:49.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f63e9dfd-fe43-57a8-9c7e-89fc95426274','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:278[folio]; 2:345[quarto], t. 182.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce026bed-17a8-5dce-b1b4-c2dfdb904f27','','','Bull. Mus. Natl. Hist. Nat., B, Adansonia 6:373.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b0d6a35-313b-5b96-b64a-10d73cb13784','','','Fl. N. Amer. 2:200.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('157aeb11-6fe6-5ad9-abd3-2cf233402476','','','Catal. prix-courante 149:24.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7558aa72-2513-542d-ac56-b017aa497287','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:39[folio]; 2:48[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('671048af-9627-5129-a8d5-d5a58dabf170','','','Sp. pl. 3(1):141.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('925df098-4b34-5289-bacf-cd8d8eee50cf','','','Syst. nat. ed. 10, 2:1237.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9e35c34-3995-50e0-a494-a19aeaad5607','','','Cacti Trans-Pecos 263.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6b0a0ab-6747-5fe2-ae40-6b4a9cbc3fcb','','','Lagascalia 19:832.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c9d8631-ad8e-5e3a-9af2-455868c7df99','','','Bot. Jahrb. Syst. 7:279.  1886 "<I>krausei</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcf0c039-2eb8-5f59-987d-441b5aacdf38','','','J. Bot. 18:4.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bec46447-8882-5ad8-aa3c-59c9ab066370','','','Syst. nat. 1:456.  1817, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e4be7e2-a500-53e6-ab27-4191bad33998','','','W. Roxburgh, Fl. ind. 2:21.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1497c8f-a1eb-5f18-80eb-95284d49f698','','','Nomencl. bot., ed. 1, 1:328.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcad4055-7487-5268-8fc7-50f6016005d4','','','Enum. pl. 2:287.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69caaa3d-3de0-57e2-8b2e-2f819696ad5f','','','Candollea 45:168.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('545a44d2-fe93-521d-a857-7c33008e6631','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 13(3):264.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04f8f2ee-9824-5784-a6aa-a7650750d309','','','used for unnamed material determined for cytological studies','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14d79b35-1af3-5c4d-a03a-4db47cb43bfc','','','A. Gray, Mem. Amer. Acad. Arts ser. 2, 4:109.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b4a056e-1965-5647-8a1e-d0f20175c99e','','','G. Schweinfurth, Beitr. Fl. Aethiop. 294.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c231db2-46a2-5d15-b258-c836763ceffc','','','Trans. Linn. Soc. London 13:103.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c57a9e3-ff7f-5ed7-9cee-9209513dfa5e','','','Proc. Acad. Nat. Sci. Philadelphia 1863[15]:347.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f65d9c07-0c0a-559d-bee9-2f0c1783ff6b','','','Syn. pl. glumac. 1:209.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd7b485a-7f9b-5026-9f03-3b27956a24e2','','','J. D. Hooker, Fl. Brit. India 4:242.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('537c4c15-f92d-5a16-8c24-d92f43655560','','','Prodr. 10:593.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8347d30-00ef-56fd-8d60-93ab4e3769e5','','','Sida 19:817.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af341f4f-d90b-523e-af82-0a1f3ed1a15d','','','Ann. Bot. (Oxford) 20:356, t. 24, fig. 12.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45d35c4a-cd21-5b73-a193-9f4075f3b774','','','Man. Brit. bot. 212.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3b9bcca-20fb-5832-a988-335c2adc9dcb','','','Farnkr. Erde 167.  1897 ("<I>lydgatei</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('299ff5d0-5452-5c04-a2ec-3558424031c6','','','Syst. Verz. Munden Pfl. 14.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f2a6f0b-4ac7-598e-8b5e-ff85c0691c4d','','','J. Bot. 67:259.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc68fb49-ff0c-5f65-98b1-5530a7ea992d','','','A. Gray, Manual ed. 2:430.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96bd3319-132a-5aea-b564-5d3d5dd3317e','','','Fl. N. Amer. 1(2):296.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be10fecc-03db-5414-8563-0db89f83e23a','','','Fl. Jamaica 1:193.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d12784c3-2705-5cca-879e-6df02a0bc363','','','Fl. Amer. sept. 1:81.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91b0b395-afb6-55ca-8ec7-e42d2054740d','','','J. Bot. (Hooker) 2:82.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52059387-13e7-52a6-8147-dbddff183c5a','','','Linnaea 25:22.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f22371e-9c32-5770-a36a-63a1d6ad2f2c','','','Fl. Brit. W. I. 147.  1859 (non Torr. & A. Gray 1848)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21ac9529-e2ec-5a28-aaf3-289f670fb52b','','','Gard. Chron. ser. 2, 3:301.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d953782e-4307-5946-bf37-47e8df2de47f','','','Fl. caucasi 157.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f549ae8-8d06-5769-8af7-55a9ceaf654e','','','Acta Bot. Yunnan. 5:148.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b609cc09-8e28-54d3-a50a-f055ea4d24df','','','Contr. U.S. Natl. Herb. 14:401.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3420399-d5e0-58af-aee0-71cf853ec71a','','','Ann. Sci. Nat., Bot. sér. 2, 19:120.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6aa8d37d-814c-5e03-9536-5322ad6524e0','','','J. A. Murray, Syst. veg. ed. 14:463.  1784 May-Jun (Fl. jap. 200.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00a7ff51-6b91-5839-9493-65ffc2a0f6e9','','','Zametki Sist. Geogr. Rast. 15:10.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3900e55-ceca-55bd-aa29-b5e290fad4bc','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:254.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a366dc5-19ad-51b1-864c-cd66c2895dcb','','','Prodr. 13(1):64.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bb30c48-069f-59cc-b1d8-7652398f9c14','','','Denkschr. Königl. Akad. Wiss. München 9:144.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b082860a-5e45-5ea6-9974-cc4272374806','','','Abh. Königl. Ges. Wiss. Göttingen 24:123.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7e503d8-7e75-5756-b8fd-7eae17ca0e62','','','Phytologia 19:216.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3521aab3-2443-54b7-acd4-cab834ff1654','','','S. Watson et al., Botany [fortieth parallel] 24.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2dc39db9-26ba-5f1a-a727-a3a9e942186a','','','Pl. horti univ. rar. progr. 7.  1773','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e467d9ac-4b03-5be6-81bb-3247d2e3af4f','','','Bot. Jahrb. Syst. 76:89.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0267cf4-60fd-58a8-880f-33acf42cc6ea','','','Byull. Moskovsk. Obshch. Isp. Prir., Otd. Biol. 74:77.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d7a92e9-2692-5820-b151-e72be644d5d5','','','S. L. Endlicher et al., Enum. pl. 33.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69a63c0d-6817-53eb-bc2d-4017f9da45f7','','','Bot. Jahrb. Syst. 19:133.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06c35d15-980b-5689-a273-aab0739a428f','','','Gen. hist. 4:267.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b2bbbdd-2b1f-59a1-bb57-bb6bc4dbf7f4','','','Bull. Torrey Bot. Club 80:412.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b1aee38-83b4-540c-b8e2-0e9c9b7dbdce','','','Nat. Sci. Mus. 7(2):21.  1936 "<I>matsudai</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc2e3f30-29d5-5f6b-bd37-fa1c1f920044','','','Gard. Chron. ser. 3, 39:161.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e6dfcda-37cd-5399-bdb9-89cf89f74908','','','Oesterr. Bot. Z. 42:123.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ce04757-f778-577a-9a60-c23675c09165','','','Proc. Roy. Hort. Soc. 3:149.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('270a33db-93bf-55dc-9879-8a2d3116d70f','','','Bonplandia 7:239.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94e4511e-db56-522e-ae26-4c7e0b13e140','','','A. L. P. P. de Candolle, Prodr. 10:324.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd3b8e45-e4f9-5d25-b9b9-3d3a00d81c89','','','Pl. hort. schoenbr. 1:59, t. 113.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3efeca64-df51-56e6-a3e3-56844daf02cd','','','P. R. Reitz, Fl. ilustr. catarin. 1. Acanthác. 43.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4f79f8d-009d-5df9-bfcc-64c711f73725','','','Huitieme Congr. Int. Bot. Paris, Compt. Rend. Séances Rapp. & Commun. sect. 4:73.  1956 ("1954")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6bbba9fb-8c40-5ffd-aab1-030b3ee6ea0d','','','Sci. Bull. Agric. Div. Univ. Ryukyus 4:99.  1957, nom. nud. "<I>luteo-turgida</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7641f8c4-93b0-5e24-a3b7-2a82724afd1f','','','Fl. austral. 2:287.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04c76f4f-33ce-5367-ac66-769d16dc7f27','','','Sp. pl. 2(2):960.  1799 (non Lam. 1789)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f291c0f-66d9-5090-8448-b6437da6fe6c','','','Amer. Midl. Naturalist 40:101.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9eebbe0-a81c-539f-900c-9de283f9af97','','','Rhodora 43:649.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d47d2b8a-93d8-5c9a-b673-4f316258cb7d','','','Mem. Inst. Franc. Afrique Noire 35:193.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d48b55e-a8bc-5723-a40a-6228f72c816e','','','A. L. P. P. de Candolle, Prodr. 10:236.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('468e841e-a274-5121-8bfa-d3909b6d77ba','','','J. D. Hooker, Fl. Brit. India 1:428.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa50743c-abcf-5d65-849c-dfaf5e2fd799','','','Revis. gen. pl. 2:741.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f209edd-76ec-5fad-b42f-548047659095','','','Enum. pl. Jap. 2:108.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4362b095-a7b4-556f-af55-7a97d937e3f4','','','Edwards''s Bot. Reg. 28: misc. 51.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a4e1dfb-8132-596c-b660-638301c8625d','','','O. Beccari, Malesia 3:153.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99d14c0e-5ff2-5ad8-8a69-11a1bdd0d2e5','','','Chenop. monogr. enum. 16.1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e38de72-1dad-51e8-b468-ab62c167bc0a','','','Revis. gen. pl. 1:173.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31a4fe44-429e-5a0e-a3fe-8fdd6bb5fa8d','','','Rhodora 60:272.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36c26911-20a0-5ff8-af8d-642383b87291','','','Ill. Handb. Laubholzk. 2:140.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dee7139e-c7e8-5876-a8c9-77ff4cf2ae7e','','','Ann. Missouri Bot. Gard. 27:172.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78a440bb-920f-5e37-9f0f-d344831888e6','','','Syst. Verz. 151.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cf536a9-e408-5a6d-80e7-2d4dc409184c','','','Select. stirp. amer. hist. 83.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06b613f1-8925-576a-af6c-c1e68e8f3237','','','Fl. bor.-amer. 1:319.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5619b99a-095c-54ab-85d6-3fc38d0ceecf','','','Leafl. West. Bot. 8:109.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62b3352d-9a84-57e5-9813-b4e16bfba9fb','','','Nuytsia 2:39.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12307abe-9cda-5821-8c60-15b59e12f34b','','','Bot. Gaz. 56:53.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a6b8657-f541-5977-9dc9-7443023bd03d','','','Pakistan Syst. 2:4, t. 4.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5eb02833-d67c-54a6-b2dd-8d7a7e632ff5','','','J. Jap. Bot. 31:122.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2624760b-5854-564e-b1ca-1c4b084b8a27','','','Rhodora 22:102.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e042076-526a-564f-b20d-c43bb60bd6d1','','','J. Torrey & A. Gray, Fl. N. Amer. 1:380.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e680244-1203-5c0b-a6e2-a950be050cc3','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 11(16):119.  1868; 15(1):205.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53dc5b68-e681-5dc2-b85e-ab414005853e','','','Fl. N. Amer. 2:127.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b62872eb-b054-53c8-a1f3-e38704ef76b3','','','Bull. Soc. Imp. Naturalistes Moscou 14:397.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84c5aaad-42d0-5b54-8ff4-0101bde2e2df','','','A. A. Orlov, Kulturnaya Fl. SSSR 2:164.  1936, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5630fbb5-ae84-5d4d-83a1-84190e5abfe6','','','Hooker''s Icon. Pl. 14: t. 1351.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7cf93c1e-44b1-54be-90e9-9dbad9ac00a4','','','Fl. carol. 194.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37ce669e-de96-50ef-8c60-08e9b56ffc06','','','Pacif. Railr. Rep. 5(2):363.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44e54864-ad8a-54b0-8952-11fa93e54deb','','','Gartenflora 19:321, t. 667.  1870 ("<I>roezli</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2bec636-8ce4-5c01-b63b-61a2b1ff8b5b','','','Prodr. 2:456.  1825 "<I>haematoma</I>" (Mém. Légum. 448, t. 68.  1827)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('679478ca-2ee1-5324-b06a-fccc55923a08','','','Bull. Organ. Natuurw. Onderz. Indonesie 20:34.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('611a4988-60ba-507c-bd97-a346bcf31eb5','','','Icon. Pl. 8: t. 714.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60ddb989-d31d-58b5-84ad-56b825f6cb85','','','Bol. Soc. Brot. 23:81.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('223fbee4-362d-5f32-a2a8-91073f45855b','','','Fl. Ned. Ind., Eerste bijv. 377.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b1c533d-8331-5437-ba1f-78135c00e8d9','','','Sp. pl. 1:536.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4655255-5d49-5b49-8fcb-027041533110','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 23:318; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 9:726.  1877 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9bbac84-5bae-55fd-8811-5b4e342542df','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 74(2):196.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cd8015d-3280-5383-872f-d640d71804b0','','','Abhängigk. Pflanzengest. 8.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9132cc5d-2cdd-53e2-926a-e5bb9c7526c0','','','Reinwardtia 5:117.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bf9bbec-d677-5c70-8a8f-7c2dab6279c3','','','Syst. nat. ed. 10, 2:1166.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae25a44f-8438-516a-a260-2f80f098b9c3','','','Ann. Mus. Bot. Lugduno-Batavi 3:119.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('027de6cc-600b-5123-93a3-c259aca04b22','','','Kew Bull. 42:44.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49a94247-d7dc-5cca-b695-eb59893b824b','','','Summa veg. Scand. 1:42.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('703aed7c-b0d8-5adf-a0ce-e323ddcaa116','','','Mem. Amer. Acad. Arts ser. 2, 4:80.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8732a183-573c-5060-92e5-11dce4de8e68','','','Edinburgh J. Sci. 1:251.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d7963e3-39df-566d-bbd9-efffcf6c9d78','','','A. Cronquist et al., Intermountain fl. 5:291.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('356d80d0-6f13-5a82-a9c8-54c10ec95789','','','C. F. von Ledebour, Fl. ross. 4:331.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4044410-12c3-5647-885f-95f8412bec1e','','','T.Smith, Newry, Ireland, Cat. 70:1.  1924?','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a690f93-64a8-5433-9b5c-2238ce2d6bfb','','','A monographic revision of the genus <I>Tamarix</I> 58.  1966 "<I>karelini</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a9af454-d668-573a-90fe-79df18befd96','','','Bot. Cab. 15: t. 1408.  1829 "<I>zamiaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('088ecadf-1777-50f6-84c4-16539d2f11dd','','','Univ. Calif. Publ. Bot. 10:200.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb624b8c-9917-5306-b4e2-95af5c790861','','','Contr. W. Bot. 12:19.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7e2fba5-5642-57b1-a839-8bea34bc2992','','','H. G. A. Engler, Pflanzenr. IV. 50(Heft 12):73.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed482472-02a9-5350-b966-283c731b148c','','','J. S. African Bot. 30:209.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b03e1f0-6771-59f4-bae2-6438b5152e8d','','','Bull. Herb. Boissier 6:525.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('441631be-f182-520c-b88a-dea224e3aa14','','','J. Sci. Arts (London) 2:88.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa3b2e42-3e8c-5b58-815a-62c3f029c66a','','','Ann. Missouri Bot. Gard. 64:472.  1978 ("1977")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77363d74-679d-56b9-af65-aad1d1b7181d','','','Linnaea 23:139.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c64fce65-431a-5a99-8a22-36a699d73018','','','Mem. New York Bot. Gard. 27:231.  1977 (S. L. Welsh, Great Basin Naturalist 31:90.  1871, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cb5d4b3-cace-5315-9393-1d66999183e1','','','Syst. veg. 5:190.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b2977da-2abd-577f-a018-761b0cd236ce','','','Nouv. Mém. Soc. Imp. Naturalistes Moscou 12:172.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74d62171-8db5-5985-855f-8230fbf84b74','','','Ill. Hort. 27:68, t. 380.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f33e9edd-7402-5e83-b952-4fa38e2a0d38','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 2:68.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47cb86c7-7905-531a-b7b1-ea6709375113','','','Novosti Sist. Vyssh. Rast. 16:178.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30e8ebd4-8b01-56ff-b9c0-18ca352e3d3d','','','Malesia 3:243.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e351553c-b6b5-50df-80ed-9d95a607578c','','','Ital. botanist 9:66.  2020','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c410ba54-7898-519f-9246-57f31c270b46','','','Tent. fl. abyss. 1:25.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b61caa68-c2ba-5d7a-a67f-f24661fe2552','','','Trans. Linn. Soc. London 20:38.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c33f0765-7808-597e-94c3-7c1b74c29dfc','','','Erythea 1:110.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfa3fc34-9764-55ce-bdfe-a254ce14fead','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:27[folio]; 2:33[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb907bdb-2ed8-5bfc-82bf-f242e53b096c','','','Kew Bull. add. ser., 1:104.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ab74760-584e-5a29-8967-c1c3a08c4d90','','','London J. Bot. 5:557.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d174a72f-973e-55bd-8a23-cd2a68405f7f','','','Fl. S. Austral. 502. 1926 [Dec]; Trans. & Proc. Roy. Soc. South Australia 50:286.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3df411d3-37b5-5a8b-ba16-c4b3ae95ee1b','','','Rev. Hort. (Paris) sér. 4, 3:107.  1854 "<I>cuneatum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46b40ba6-ccd6-5a31-a1e2-2d9a4e972458','','','Trees & shrubs 2:167.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c102a55-e7de-51bb-a0bf-5ffcc502b1f9','','','Repert. Spec. Nov. Regni Veg. 3:181.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfb18a77-6629-5e91-bcbb-c9ec0b77520f','','','Bol. Soc. Bot. México 17:4.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('565c948a-0952-5f93-a5d0-c9dde3e3205e','','','Bull. Soc. Bot. France 5:327, pl. 1.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bba417f-73e3-5918-ac8a-d5343fa87096','','','Acta Phytotax. Geobot. 55:80.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1387d126-42f1-5e83-b00d-542638e8a8f3','','','Hort. kew. 3:304.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fc89b20-d08e-5751-8c0a-4ecebab8ccac','','','C. S. Sargent, Pl. wilson. 1:178.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37bdb4dd-5e97-5dc0-82be-d57efb32d974','','','Bot. Misc. 1:166.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49df45e3-a3f5-509c-b7aa-e7bb49ab03e0','','','Blumea 14:307.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('989723e7-e52d-506c-814e-392c8ae02ecd','','','Prodr. 1:424.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c133f0e1-d8db-5d3c-8c3f-5767fad9e4e1','','','Proc. Acad. Nat. Sci. Philadelphia 1861[13]:448.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('819cb75a-8394-53b4-b82c-7f8f000089ca','','','W. W. Saunders, Refug. bot. 1: t. 50.  1869 "<I>thymaefolia</I>" (non hort. ex G. Don & Wooster 1855)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7d1c8e1-9807-5ee5-adf5-4445434b804d','','','Edwards''s Bot. Reg. 19: t. 1639.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('713fa499-2a81-5f90-b99c-83393aa92891','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 1:390.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac7f6021-5c1e-51d2-adf6-ae4bb015acae','','','Piante Grasse 15:8.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f6f956a-f981-50ff-84f7-f01201cac4d3','','','Mem. Amer. Acad. Arts ser. 2, 4:41.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c0dc278-de93-566f-b129-f985c1b11c66','','','Ann. Soc. Linn. Lyon sér. 2, 17:147.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6beeea5c-28ae-5ade-bfbc-5fe665de8fc1','','','Syst. Bot. 42:295.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0523e9b3-a4eb-5b23-8db5-5f872acb47b2','','','J. L. M. Poiret, Encycl. suppl. 3:558.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6becd976-8488-52b3-80ae-eb831d66214a','','','Fl. bor.-amer. 1:228.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afd9eb6a-e106-5d5b-8df1-006d1a6ab8c7','','','Sp. pl. 2:1029.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4647783-6984-576f-a1d4-c146a87d4f1d','','','Fl. taur.-caucas. 1:161.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c83e9898-7941-533a-86e2-33d4cb94d63d','','','Willdenowia 28:65.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5ca2449-48b0-5cfa-a20f-9128d962fe9f','','','Univ. Colorado Stud., Ser. D, Phys. Sci. 2:179.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ee66917-17be-5e2c-9646-2bf6cdad072a','','','Hist. nat. palm. 2:100.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6217ea89-9a54-5fa5-b813-87be70f6cee5','','','Webbia 13:493.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('921ec8ea-f146-5e2b-bc07-793cb025f829','','','W. Roxburgh, Fl. ind. 2:417.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4737c0da-bac8-50c5-8448-9e1353758aa1','','','Ann. Nat. Hist. 2:357.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce886c09-6296-5b55-8790-64264f8f8666','','','Nuytsia 1:197.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32ded532-f47c-51ae-9813-65b3d3008ac3','','','Bot. Jahrb. Syst. 37(Beibl. 85):40.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32555b48-369c-520f-a047-284d38395e74','','','Bull. Soc. Bot. France 2:282.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8145eede-648d-54c2-ad52-da1db9f43ce2','','','A. Fedstch., Putesh. Turkestan 18.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cad34ac0-0ace-5dff-93aa-1d1e131af643','','','Bot. Jahrb. Syst. 76:94.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1ad6205-dd71-59e5-91b4-80924799b72d','','','Kew Bull. 29:396.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fa97877-9cf8-56cf-8b55-d8a3e9a37729','','','Rev. Bot. Appl. Agric. Trop. 12:1028.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f161542-6ca7-5a82-9dce-214ec4296180','','','Prodr. 7:241.  1838 ("<I>bootii</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01392eed-a60c-510d-9f20-36b26aa041d3','','','Trudy Prikl. Bot. 42(2):296.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ffe6d15-9204-532c-bee6-b980dafd7254','','','Beitr. Phytotax. 10:47.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bce02117-83b9-5ad4-b961-b432897e12cb','','','Bot. Mag. 46: t. 2043.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9bdc035-9398-5b33-8c0e-6631cb09c7d3','','','Fl. cochinch. 1:233.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4040ef6-64e0-5ed7-8969-863280a2a1c6','','','Proc. Amer. Acad. Arts 5:173.  1861 ("1862")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25015b0f-295e-5b4f-b8ce-a7709b7f8bd8','','','Bothalia 3:149.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fadd6913-e0ef-54ff-bc15-8ec3e7f5ec55','','','Fl. Afr. austral. ill. 408.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08e9b51f-d57e-5958-a347-38ea7c05d4b8','','','C. F. Otto & A. Dietrich, Allg. Gartenzeitung 4:105.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92aa86fa-d97a-525a-b1bf-59b21f2d004a','','','Sched. fl. exs. Roman. no. 1278.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74560c8c-0bbf-5feb-9c07-f742c16e49a3','','','Encycl. 6:686.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36f6896e-4119-503f-adb5-f51adb331dc2','','','Ref. Naucno-Issl. Rabot, Otd. Biol. Nauk 1945:7.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f35d22f0-4b52-5d61-a875-43999b71bd92','','','Handb. Sukk. Pfl. 2:835.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('622fbc8b-9671-519b-b7af-52e3804afd0e','','','Lesquerella in N. Amer. 164.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8acce86c-6b50-587e-b826-f002b51506ec','','','J. Adelaide Bot. Gard. 6:79.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8466ef56-3ef1-514a-9593-3153f1ed1d46','','','Kew Bull. add. ser., 1:47.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d76fc93a-8253-5944-8d4f-e7dc67720d17','','','Fl. Amer. sept. 1:356.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83af2665-9d1a-5808-8cb2-305c2d32e1fb','','','Nov. Holl. pl. 1:66, t. 91.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('130b7527-008c-5024-9461-34d4e395e955','','','Aquatic Bot. 72:171.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31128096-d05f-5365-bff9-54b376db91c4','','','Caldasia 4:179, t. 14.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08d47391-84b4-5f62-b13f-a2307f7f821c','','','Sp. pl. 1(2):873.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7301e859-83e4-5c37-8b95-5bf313e98e81','','','H. G. A. Engler, Pflanzenr. IV. 250(Heft 27):67.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68d9036e-c54a-5c4d-93dd-037ccd01d33d','','','Kew Bull. 1949:441.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80217ad4-1b4e-5a30-a0d7-e8921f2224af','','','Verh. Naturf. Vereins Brünn 10:80.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac28801d-6ab1-5525-9aeb-461cae996a2c','','','C. F. P. von Martius, Fl. bras. 3(2):78.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1abc5981-48d9-5107-be18-22e796603a76','','','Amaryllidaceae 129, t. 33, fig. 14.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bc6a690-41e3-5e84-b694-71aa5e26546f','','','J. Washington Acad. Sci. 34:19.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09c53881-3fd3-50d9-87b1-93b0e14db6be','','','Gard. Chron. ser. 3, 15:590.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb95e8e1-6f28-5fb6-a0eb-36fb6bc09db9','','','Mitt. Deutsch. Dendrol Ges. 15:60.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c12545bb-3b0a-51ce-87f8-f722147567d3','','','S. Watson, Proc. Amer. Acad. Arts 18:124.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23cf189b-d9a4-5eeb-bab0-94b738fb8042','','','Syn. Queensl. fl. 500.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89be55bf-4f28-56ab-a96e-13114f2b032b','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 72:210.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52697fdb-1219-5125-9b08-7e2e7590c975','','','Bull. Soc. Natl. Acclim. France sér. 3, 5:797.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e441b11-40ae-5dbe-a1a6-b7db65cd07c2','','','J. D. Hooker, Fl. Brit. India 2:517.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8963548-aa5f-5a21-9ae1-34fe2cf03e81','','','Selbyana 2:95, t. 28D.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34f1ae06-a9e6-50e2-b152-b2b2aeb9fa74','','','Crabappl. nectar. Jap. 41.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed0d5c6d-d548-5498-8f5a-d6912587b6a2','','','Kulturpflanze, Beih. 2:137.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20affd01-1164-5e84-86eb-985e3f60a31e','','','C. G. G. J. van Steenis, Fl. malesiana ser. 1, 6:241.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f6aadd0-490a-5887-b481-c37cdd3bb9f5','','','Bot. Zeitung (Berlin) 3:334.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('532e1628-3475-5ffa-930f-4b18749854c1','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:62[folio]; 3:78[quarto].  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee981bf4-f965-5164-b548-7222cb9a51a0','','','C. F. P. von Martius, Fl. bras. 15(2):70.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ac55cea-5d20-5bf4-860a-c96b3e902cf9','','','Trans. & Proc. New Zealand Inst. 23:444.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ea25c35-6fa0-5707-93f2-60eaa5ac6865','','','Trans. & Proc. Victorian Inst. Advancem. Sci. 1854-1855:46.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcc10fa3-d6ae-58c0-a931-933dce0a635c','','','Notes Roy. Bot. Gard. Edinburgh 33:432.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff431f08-b7a8-5971-9c04-8c01e56bbb8b','','','Mitt. Inst. Allg. Bot. Hamburg 10:547, t. 16.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f1249fc-f03c-5f71-9b0c-b08275c3b8d0','','','Castanea 10:67.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e24c5af-231e-5da3-a3c0-70ddb53dba1b','','','J. Linn. Soc., Bot. 17:170.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9862bb9-b36b-5e68-b5fa-b7e86a3c6c1d','','','Ann. Missouri Bot. Gard. 83:239.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('270a47dd-97d5-586a-9187-0a04c75e18b8','','','N. Amer. Sylv. suppl. 1:34, t. 10.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8ee1694-c0fa-501b-94dd-1b27163c8541','','','Bull. Soc. Bot. France 34:283.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6de27bb6-617f-5186-8ba9-bd76504ae1dc','','','Gard. Chron. ser. 3, 56:46.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('440ec5f4-fcdb-5189-8da8-74ccfe73fe6a','','','Linnaea 5:584.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e57713cb-93e1-528f-b8ac-29181a7a06f9','','','Bull. Soc. Bot. France 36:25.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b0bcbbc-5196-53ec-ad8c-7fb3ee592da6','','','Gentes Herbarum 8:191.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38312bfa-2f03-524f-92f8-38049cc16ece','','','Contr. W. Bot. 13:4.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3aa90bb7-6c7c-5b52-90a7-b3eb02cefb2d','','','Leafl. W. Bot. 2:128.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db484327-fa92-5aef-9915-200bd1f75261','','','Fl. cochinch. 2:630.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d80bad49-26b7-5108-b23b-2565ea6b89ec','','','Proc. Amer. Acad. Arts 34:567.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ab49e07-89fb-5282-ad18-55780fdb019d','','','J. A. Murray, Syst. veg. ed. 14:602.  1784 May-Jun (Fl. jap. 262.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9614d427-e3a9-5b8e-8da5-cc1e25e739e7','','','Austrobaileya 2:242.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67fdade0-0a43-5b60-9ba7-6081354a7d2b','','','Enum. pl. 5:201.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6481436b-bd73-518c-b54a-6d36dc2329cd','','','Fl. Gabon 49:139.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e3b0346-ddca-5163-9971-34be54ca13b0','','','J. Jap. Bot. 71:270.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('389db8b3-7ba4-57d2-b391-f93c3d3e1898','','','Symb. bot. 3:94.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('066b66c8-b47f-55cf-bcaf-1edb7f31853d','','','Syn. pl. glumac. 1:328.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7f59e40-405f-506e-8853-8146cf2091b7','','','Fl. australas. t. 18.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b98bea04-b216-5cd4-920e-bc0d99fd8fe5','','','Trans. Linn. Soc. London, Bot. 9:140.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f767eb85-d4f7-5113-bd51-a6ab3eb52fd4','','','Fl. austral. 7:530.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e42718a9-8afb-5498-8c19-bb92b454f9dc','','','Fl. germ. excurs. 421.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53900d42-7db7-5010-b9db-1825234b4a30','','','Cactaceae Syst. Init. 14:7.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ad6ba07-a96c-52a3-bf7b-d2703ce658d3','','','Cat. gén. 16:2.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37e14b78-d7fd-5b36-8894-c3ba12803c08','','','Bot. Reg. 14: t. 1149.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e837b78-7147-50ad-916c-1f855f8f94f8','','','Notes Roy. Bot. Gard. Edinburgh 15:20.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7795982a-3135-5d6d-8ff7-1d576870aecf','','','Notul. Syst. (Paris) 2:293.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4027bdf6-0bd0-50de-88bb-49a03a40729f','','','Monatsschr. Kakteenk. 5:6.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb44081a-aa15-5039-9626-2c1bb93ab404','','','Bull. Soc. Agric. Sarthe 59:322.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39776157-3f8c-5967-8d3d-177a31d01473','','','Bot. Mag. 135: t. 8256.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78257500-fb8b-57c6-bee8-bdd72b2c4349','','','Darwiniana 14:450.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1cfaad5-8d97-5a69-b266-866bfb7cf2c1','','','Bonplandia 8:84.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aa40b77-e7d5-5bdc-b80f-d608c3fddcc7','','','Contr. U.S. Natl. Herb. 1:60.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10068528-632b-5673-b90e-d77ee9f60e3d','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:225[folio]; 5:289[quarto].  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8404a7b4-4cc9-5121-a004-8ce600d77b36','','','Queensland Agric. J. 7:441.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06352b96-40a7-58d2-abb7-2ca7d022a225','','','Index Fl. 199.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2010528e-6009-5012-bbd8-a89c58a5f8e8','','','Proc. Acad. Nat. Sci. Philadelphia 1860[12]:444.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7004653b-3b06-5661-9eb2-a3e567dd2480','','','Madroño 7:112.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81fafb44-f357-5aeb-a6fa-3a1eebfbf553','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(4):349.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b238804-4b60-5dbe-a607-d09d90d07215','','','Mus. bot. 1:48, t. 16.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d6f107a-d007-5a15-b495-089dde436f0e','','','Exot. fl. 3: t. 189.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6ff8612-434d-5bd0-9ff5-7eaad6c90388','','','Fl. Hawaiiensis: fam. 68.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e0b7771-d3b9-5ac4-b7ff-d78af56097ba','','','Gen. hist. 2:347.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1f635fb-765f-51bb-9e31-7bd532139a2f','','','Fl. cap. 1:243.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4dd8a15f-8fcb-5935-b99d-4d5a993a1aa0','','','J. B. A. P. M. de Lamarck, Encycl. 3:636.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c0e5d99-d4c4-589b-a172-6fce04fa8d70','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 3:618.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5d533ba-c82f-51cb-a967-74ccea32316d','','','Sp. pl. 1:419.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fe9927b-ee8f-5bd0-954a-59f804d591d9','','','Bull. Torrey Bot. Club 15:48.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f064381-7cd3-5a95-a1f3-734d35f02944','','','Pfl.-Gatt. 85.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4e8b78d-74dc-5189-a7e5-b9a877c76b4b','','','Madroño 10:94.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9e7efe5-6bf6-5b3c-a914-464d1d2dba3c','','','Bot. Repos. 9: t. 566.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16a9e472-02cd-5599-b295-dffedbe811fc','','','Catalogue 143:ix.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fb66d93-b770-59f6-b9d6-93acc985d5f1','','','Bot. Mag. 153: t. 9183, fig. c.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2de3acbf-a37b-5437-8727-c77db6413f0a','','','Austrobaileya 2:344.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('299e3521-7c58-59ab-b629-6fd94932eb5e','','','Opusc. sci. phys. nat. 54; Mém. Soc. Agric. Angers 1:158.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08c0688c-223f-5e1f-8c62-1169722df0d5','','','Fl. helv. 6:311.  1830 "A. <I>virescens</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bc05d37-38d1-5ec7-b2a9-03cee1a4002c','','','Ann. Mus. Bot. Lugduno-Batavi 1:32.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ae92ce5-5d65-5aab-a4b1-089e78205a2f','','','Fl. čech. 94.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7ba07f8-103b-5bc4-b2f3-c485fe763231','','','Ann. Missouri Bot. Gard. 37:302.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63339ce3-10c5-5833-88b3-d88796e138ea','','','Mém. Soc. Phys. Genève 6:475.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57ae57ab-b38f-557e-b4c0-9bd582665959','','','Kew Mag. 4:184.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52160085-0eba-520b-bd91-3a890338d606','','','Fl. austral. 5:187.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6841daee-68e0-562a-85b5-a0c8c206e6ff','','','Cat. hort. dyck. 174.  1850 "<I>odierii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6755d649-e927-525b-806e-9d7eea6af883','','','Syst. Uebers Cereal 23.  1873, nom. subnud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f80dcdea-0c61-5981-9b7b-906531333692','','','Pl. min. cogn. pug. 2:23.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1af5921-9dc4-54f0-aac5-55bd9804a773','','','T. B. Croat, Novon 9:496.  2000 ("1999")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfab4caf-f546-5927-b523-bb9dfc5aa6d0','','','Sp. fil. 3:51.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b83dc46-6862-52ee-9446-fdbd720e7b2c','','','London J. Bot. 5:552.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5c398ab-fd2b-5f89-a13c-af7719f938eb','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 2:181, t. 111.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e60e025-f8f7-5502-9e8d-ccf6e9bf1bec','','','Ill. bot. Himal. Mts. 1(8):260; 2(8): t. 63, fig. 3.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ed093de-5ada-553d-8edc-e7bdd4c06f70','','','Mém. Acad. Imp. Sci. St.-Pétersbourg, Sér. 6, Sci. Math. 1(4):369.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9e66df9-682b-5f81-9d1a-57d2297c6133','','','Ill. dict. gard. cent. suppl. 591.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d812dd5-12b9-525d-a90c-0e95de68cf3b','','','Cat. hort. dyck. 165.  1850 "<I>haynii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc435078-bf97-59bc-969c-180b0c759a0a','','','Oberm. & Immelman, Flora of southern Africa 5(3):65.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('933cb303-765a-517b-b5cc-79f2365bc537','','','Bol. Acad. Nac. Ci. Republ. Argent. 3:337.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44e5218e-3052-5a6c-a24a-d8645c4dedb2','','','Sandakania 4:60.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00a1388e-2b15-5f84-8e94-2ea66ef865cb','','','Gard. dict. ed. 8: <I>Ananas</I> no. 4.  1768, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c98e1b60-9a6d-5eca-9380-599edda7178a','','','Diss. 6:345, t. 191, fig. 2.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('891751f7-eb08-5787-a95c-dcc94ad3cf4b','','','Linnaea 21:452.  1848 (non Vell. 1829)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54fd97a7-195d-5b84-97f5-ba0daf764970','','','Pl. imag. descr. fl. russ. 7:48, t. 32.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89f0b5cb-8d06-5f15-81c9-578eba21c48c','','','Fam. nat. syn. monogr. 1:139.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('114f96eb-d6ae-53d0-acf1-3f484f275e71','','','Fl. taur.-caucas. 2:179.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe8baf6d-9071-5e0d-94ef-a0204925ff84','','','Bull. Torrey Bot. Club 31:572.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea3613a2-dc1c-5ab2-b462-5421910fbfba','','','Fl. intramongolica 3:287.  1978 ("1977")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f6aa415-6acf-5fd8-9556-67bc7ee21a06','','','Astragalogia 83.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5182886c-062b-5fe3-b671-645bbbede896','','','Notes Roy. Bot. Gard. Edinburgh 5:268.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21dac2ba-6598-5cfd-a1e5-a039c5eb51c1','','','Notes Roy. Bot. Gard. Edinburgh 37:332.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d653ec42-dfad-5e28-8b32-1faf0d3da09c','','','Trans. & Proc. New Zealand Inst. 57:40.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdcd24c8-1698-5cb8-ac3e-53d27466ff61','','','Sp. pl. 2:934.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5ae9596-85fa-5840-aa0d-d96c67646196','','','Spisok Rast. Gerb. Fl. S.S.S.R. 18:27.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81ad6a57-a487-5920-bafc-630190390ae1','','','Philipp. J. Sci., C 10:13.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95788e63-eb58-567e-840d-f8512a1b0a54','','','J. Arnold Arbor. 3:206.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbf45bcb-a345-5fb7-a89a-96686b87bf4f','','','Notizbl. Bot. Gart. Berlin-Dahlem 15:431.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6b59fe1-53f8-5455-83da-ba515eb11416','','','Proc. Biol. Soc. Washington 17:99.  1904 "matamorencis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b34c9f3-bda3-5d52-a7d6-0065aa219982','','','J. Bamboo Res. 6(2):16.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0dfae423-9879-5004-8bb6-dc9dfeed9932','','','London J. Bot. 1:363.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c3a9c2c-bac9-574e-9534-c58e18ccf597','','','Nouv. Arch. Mus. Hist. Nat. sér. 4, 10:249.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d117cb4-d568-5c30-b0bc-730292fb82f8','','','Herb. amb. 14.  1754 [corr. L., Syst. nat. ed. 10:1277.  1759]','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37aa0b0a-ff6c-5da6-bd1e-b6f67dc87eb9','','','Symb. fl. argent. 214.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e03824d-b29d-590e-8e9f-6dfe8d6a7e87','','','Webbia 3:153.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53a096d2-35c8-503b-8829-51f230262be1','','','Notas Mus. La Plata, Bot. 2(16):186.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35e994fc-36b8-5c75-b6c8-ff413dc09bbf','','','Syn. fl. N. Amer. 2(1):363.  1878 "<I>reverchoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('697f264e-0f62-5c1d-8af6-e221f9d86516','','','Collect. Bot. (Barcelona) 1:300.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c6b9503-fe5a-534c-8ca5-e2d0fdbee64d','','','Phytologia 99:86.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('344dfa78-4e95-5849-bc01-86b940e6cb52','','','Linnaea 25:370.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a101f2a-5aad-5deb-b770-89ee10fc5ba9','','','Diagn. pl. orient. ser. 2, 3:155.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bade8ea-a49c-5d71-88cf-c61e54c06555','','','I. Urban, Bot. Jahrb. Syst. 15:308.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1143e9b-fe1c-5131-8eeb-e8043a4620bc','','','Sp. pl. 4(2):1035.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f99b1f7b-77cf-5872-b725-72f36b93709d','','','N. Amer. fl. 24:192.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adde3769-3513-5a69-9975-6eb432ba2873','','','Fl. ind. ed. 1832, 2:66.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('398fd171-149f-5b94-bc16-6fb1d4605934','','','F. B. Forbes & W. B. Hemsley, J. Linn. Soc., Bot. 36:389.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55014bb7-7b5a-589a-8ef2-68bd41155ba7','','','Cult. Prot. 50.  1809 "<I>subulaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('101551f2-c51d-5c75-86f0-5b0d6897d4fa','','','Bull. Mus. Natl. Hist. Nat., B, Adansonia sér. 4, 18:184.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27e42b68-717f-5882-bbb2-6ce3df328629','','','Amer. J. Sci. Arts ser. 2,24:47.  1857 "<I>laevi-conica</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('183c082e-6cad-509e-9997-c32df807e73f','','','Ess. Agrostogr. 51, 171, 178, t. 13, fig. 3.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbe1498a-436b-5781-8c6d-c9a5b49bb579','','','V. L. Komarov, Fl. URSS 9:461, addenda 8.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92adaddf-8e92-55ac-bb3f-03734da9ecb8','','','J. G. C. Lehmann, Pl. Preiss. 1:54.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('962c861a-6baa-5e2b-b1cb-accf68d33442','','','G. Bentham & J. D. Hooker, Gen. pl. 1:528.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d86a20f-aea0-5d4b-8177-7bf9c006a158','','','Prodr. 258.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2de2f8a3-fcda-5a4d-b867-69a2990b46a4','','','Allg. Gartenzeitung 15:177.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c929b52-d49f-5069-9ce0-ba99a9a1bdd5','','','Gen. Cass. syn. 60.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e49830f-5b3d-52c5-bcf1-aaa6880d6ade','','','Bull. Torrey Bot. Club 13:219, t. 60.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('061bbce4-ee78-5e42-8426-d0b7093cdb3f','','','Mem. Dipsac. 32.  1823, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7357f6af-fabf-597c-924a-5a59c2244325','','','Sert. hannov. 3:27, in adnot.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de089c1c-23f6-5d4f-bb1f-cf0bd57251f5','','','Doane Coll. Nat. Hist. Stud. 1:6.  1891 (Nebraska fl. pl.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1083dd5-fb93-551d-9287-c323ee381957','','','Feddes Repert. 101:342.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d74277d9-16e2-5779-b6af-881bccf28e4a','','','Denkschr. Königl.-Baier. Bot. Ges. Regensburg 2:26.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('735af6eb-e06d-5b8a-a1bf-bbfe0e0f8138','','','S. African J. Bot. 112:414.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f70b0d62-ff09-54c4-a156-ce5e6d2de0c4','','','Proc. Amer. Acad. Arts 5:332.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b85e1e1c-96e7-505d-b787-bf2503e52c07','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 4(2):541.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a465175-b52e-5834-b616-c7a24c7033e1','','','L. H. Bailey, Stand. cycl. hort. 4:1555.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd55dd1f-0a5f-5517-9c5b-72e599733a66','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 10:43.  1887-1888 (Pl. david. 2:81.  1888)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee52700f-c49f-5d32-956d-1148b3e68ef1','','','Fl. austral. 3:252.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8cd5709-28df-5c80-997d-606a800bf7ec','','','A. L. P. P. de Candolle, Prodr. 16(2):342.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2fae8dc3-5607-50a5-bec3-4b8eaeb18e1b','','','Bull. Brit. Mus. (Nat. Hist.), Bot. 3:166.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2dbd4732-066d-548f-baff-f3b2de636094','','','Diss. 5:272, t. 125, fig. 1.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('099ebe22-b650-55ab-9506-fa7c3defb379','','','Enum. pl. 1:238.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ae10f8f-63b4-5dbc-a700-2c2c921a7da8','','','Syst. Bot. Monogr. 35:93.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('975c1f57-3692-58b7-9f4f-2f9df8d4dffc','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 10:393.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c0fa1cf-34f0-5487-a99b-51f12a3e59d8','','','Torreya 34:9.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e017fbbc-43ff-586a-98c5-5536901678a5','','','Notizbl. Bot. Gart. Berlin-Dahlem 13:622.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2286bda1-1eac-500b-b90b-e600732bfda2','','','Fl. altaic. 3:367.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02786e6a-2687-5f64-b615-5cf37cecd69b','','','J. Arnold Arbor. 5:74.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8653cbb7-0a75-5dda-a9d1-0d826e007bfa','','','Magyar Bot. Lapok 2:245.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff1e3a0f-5d4d-55b3-8a8b-5526e5fea7af','','','Pl. david. 1:342.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff9388a3-ee9f-529c-88c9-d507296cebcd','','','Syn. fl. N. Amer. 2(1):337.  1878 "<I>neo-mexicana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94c2b8c8-9d14-58ed-bddd-2f62026ea811','','','Bull. Soc. Imp. Naturalistes Moscou 33(1):485.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31dd2162-506a-5080-b5d7-db0d130f423e','','','J. Jap. Bot. 14:230.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('311d51a2-6f3e-53e6-b661-2ca337c5cfe4','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(2):208.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e40ba675-9565-5d87-8a08-db21bc50f82a','','','Syn. fl. N. Amer. 2(1):260.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb51ffed-71ac-5d1f-b1a5-a8633f2376ab','','','Contr. Gray Herb. 114:42.  1936 "<I>albo-marginata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba34b12f-09ba-5f6d-9024-0a89665bacf4','','','J. Acad. Nat. Sci. Philadelphia 7:80.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('964b4907-8d1c-5de9-bed2-97d29a708684','','','Bol. Soc. Venez. Ci. Nat. 8:135.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23096f66-9b18-5e16-9a99-625bfe8a24d4','','','Enum. pl. Jap. 1:191.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('949b1d6b-a7a7-5fe5-8418-ab7386ac3084','','','Bull. Jard. Bot. Buitenzorg sér. 3, 6:228.  1924 "<I>mansoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c35e4d6b-0df1-592f-9b3a-cee0e3d559fd','','','Syst. nat. ed. 10, 2:1234.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c759217e-2f40-5664-8a52-9b85e38c6491','','','Ejsz. Magyar. 76.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2963744-ae91-5dde-aa92-c9ba5397aa8b','','','J. Proc. Roy. Soc. New South Wales 52:504.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6fb0e73-de5f-5fee-9198-d56148f8d83a','','','Amer. Fern J. 24:15.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54432e2f-6a4c-5c04-acec-5cce46cd60d7','','','W. T. Aiton, Hortus kew. ed. 2, 5:82.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2be9ad29-d26b-5281-9291-628ed7ab28c8','','','Abh. Naturwiss. Verein Bremen 24:432.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('430b1f06-09bd-5263-9f14-d1da08d7504b','','','Malesia 3:4, 12, t. 3.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f2f1531-5563-542a-99d5-6cf095840581','','','Adansonia 8:52.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10ec1515-8241-506f-8e8d-59897d36264f','','','Fl. ind. ed. 1832, 2:196.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64e7b05e-682b-551b-bfe6-0be31f236031','','','Flora 12:468.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4001851a-ddac-553d-853d-f05b582fb0b6','','','Bot. Mag. 65: t. 3663.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fecaab6-d3ca-5da4-952b-ef96e12e7cfd','','','Phytologia 27:214, t. 3.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06f2513c-9dca-540d-8525-133301c68e36','','','Trans. Roy. Soc. South Africa 21:94.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c14ef99-1128-56a6-aa3d-b6c952708a94','','','Repert. Spec. Nov. Regni Veg. 9:33.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73b12a20-fad5-57d1-8df8-14e127f12c04','','','Repert. Spec. Nov. Regni Veg. Beih. 89:203.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1daa4d47-0ef0-518c-88bd-ff468642eae7','','','Bot. Mag. 47: t. 2113.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03599c3a-043f-5728-bc31-4b0f2e8e974d','','','C. S. Sargent, Trees & shrubs 193, t. 92.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4ecec61-65cf-5909-840a-5b1e9e608265','','','Contr. Gray Herb. 53:18.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1225eae-be93-5331-825d-8a3c1c43ae70','','','C. F. P. von Martius, Fl. bras. 14(1):398.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e549310-d84a-5ab3-903d-e554ff949515','','','Pl. Syst. Evol. 240:31.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5675d8ad-5d89-5629-ae04-36b0e32dcd19','','','Ench. bot. 67-68.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55c9193a-efdb-550a-940a-99a42ee97dbe','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:103[folio]; 3:132[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f151b331-bade-5f03-b470-bc86abc23851','','','Mem. Junta Invest. Ultramar, 2 Ser. 19:49.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74535a68-b728-5d37-8c0c-4378357e5f55','','','G. F. Freytag & D. G. Debouck, Sida Bot. Misc. 23:67.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d00af5e7-dbd5-54f9-841e-9ed1f2fd085e','','','Enum. pl. 1:99.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('711f861b-e761-5a37-94b6-448314c15773','','','Phytotaxa 162:175.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84e2a774-434d-5b55-b97b-91e16049dab7','','','Contr. U.S. Natl. Herb. 18:296.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d48d078-c867-56f9-9d66-3e6276b5e1b1','','','J. Bot. 11:365.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1822f7d9-ea66-547b-be68-e32df7d125e3','','','Ann. Sci. Nat., Bot. sér. 4, 11:122.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('986965c9-a180-5f73-819a-ef073c5d5268','','','Bull. Soc. Roy. Bot. Belgique 38:122.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c1547f1-f260-5073-bbaf-cad06247a08d','','','Sp. pl. 3(3):2288.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10bd39a4-9b01-5683-96bb-c669924ca115','','','Kew Bull. 15:356.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d2e8992-5b9e-5cc9-aeaf-2ce9de2a098f','','','Ill. Handb. Laubholzk. 2:251.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2300c83c-3a72-5b48-be8f-fe5f9e540d2f','','','Voy. Indes orient. 2:237, t. 134 [folio].  1782','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42afb880-c335-5085-88b1-83a5337516a4','','','Contr. U.S. Natl. Herb. 18:166.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0558cd8d-64c4-51e2-8463-713b176c7885','','','Kew Bull. 33:641.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a5f6d58-690e-59f2-a37c-da8cd1500031','','','Boston J. Nat. Hist. 4:63, t. 6.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19e07e74-3f47-53d9-bcc2-2a3437586dc5','','','Util. biotechnol. genet. cult. approaches N. Amer. & Asian ginseng improv.  73.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9cfbb18-db15-575d-98a3-f92f99e0e0c2','','','J. Bot. Res. Inst. Texas 4:598, fig. 2.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30901a9a-4f6e-504e-908c-3ff2f27ea1c7','','','Cent. pl. I:6.  1755 (Amoen. acad. 4:266.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('710ea64f-face-59dd-a6a0-7183093a7aaf','','','Fl. & Sylva 2:253.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4057ae7d-1879-50ac-8730-7495f956d0aa','','','Revis. gen. pl. 2:673.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('750a594c-9049-5b65-8e67-07df3f4f68a2','','','Enum. pl. 2:1047.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3e61130-f147-5a82-8b85-843f13f96302','','','Acta Bot. Malac. 37:224.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50d9f99f-598a-51f4-ae27-42190767b396','','','Fl. orient. 5:713.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e37cd6c6-5f1e-528a-93ac-f43f42390b6f','','','A. B. Lambert, Descr. <I>Pinus</I> 2:21.  1824 "<I>nereifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('682a91c0-457f-5e98-b260-8d9775537ddb','','','Fl. orient. 5:145.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b06b9228-b1d8-5b89-880f-f49fc7d2f86c','','','Dendrologia florestal 56.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87a9a4f4-dd30-5fc2-82af-5cab43b047ac','','','Nov. pl. sp. 150.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ada6c13b-8e0d-5ad7-b1d5-4e02b7e9042f','','','Fl. austral. 2:242.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7cced786-69cf-58ab-8c01-95ae5adca111','','','Fl. jap. 1:79, t. 36.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdc074e4-6cb4-55a7-a572-d4ced775f883','','','Syst. Bot. 41:679.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c48b7c1-8369-553d-b3af-ef658b7b6dde','','','Monogr. Bignon., Atlas t. 15.  1864 (B. Seemann, J. Bot. 8:210-211.  1870)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a7126c4-8e6d-5ff3-84cd-659e6d78f471','','','Jahreskat. Wiener Bot. Tauschvereins 1894:6.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b880ab17-f2ae-5844-b4c6-b8a41bfb611a','','','Thunb., Fl. japonica 275.  1784','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a67468a-09b4-5bf3-b82a-fcd4146093f4','','','D. Oliver, Fl. trop. Afr. 2:199.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72b0bff8-c275-5232-9bd8-06809d8487d6','','','Man. pl. usual. Venez. 276.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e868dd9c-c761-549e-931f-bb69ee640082','','','Orchid Rev. 11:292.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55a0ec4a-a5a4-5bb3-be38-e9a966231bb7','','','Enum. pl. 2:957.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7424af29-8338-58f7-9094-ba285593efcc','','','Phytologia 42:219.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0c566c2-d428-5461-bb76-17212d0619b4','','','Enum. pl. nov. 1:1.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e38e4907-1910-54d6-9f6c-74f87f928049','','','Linnaea 9:132.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62434219-843c-58a9-92fd-42bb01e08d1e','','','Contr. Bolus Herb. 14:138.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d7019e4-1e09-5e03-85c2-6a5e3d28fb38','','','Kosmos 38:1297.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9809e611-cb6a-5007-bccb-ea7ede92bc32','','','J. Linn. Soc., Bot. 17:124.  1878 "<I>scorzoneraefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47422aa6-ff4e-5072-a9e1-79fe60c1cb01','','','Bot. Reg. 5: t. 387.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47b33d0e-d8b9-51c3-922a-39feb328fa94','','','Edwards''s Bot. Reg. 30: t. 10.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('244c8401-4d8d-5184-adfb-90d3ad151efd','','','PhytoKeys 32:57.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7c685a3-4fd6-59e4-9c33-c7b98858ed76','','','J. Bot. (Morot) 9:370.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cae3adbc-c03f-57b4-8392-e8f196f09c51','','','H. Lorentz, Nova Guinea 8:758.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b293ab5f-6396-55cb-8210-0e41ac4d96dd','','','Icon. pl. med. 6:29, t. 534.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a374bbf3-5430-56c8-b006-d5663d4b6d17','','','Contr. Gray Herb. 59:4.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7593207-bef9-5a0f-ad6f-48c1f3fa190d','','','Symb. Sin. 7:324.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0990fa5-3c64-5edd-ae9a-fed5b1638eb7','','','Compt. Rend. Hebd. Séances Acad. Sci. 136:400.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac86a6d3-2acb-52bb-92ca-86c0e1bc285f','','','Trans. Linn. Soc. London 10:69.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('130afd14-fd3a-59e5-b852-0b1af6f09952','','','W. C. H. Peters, Naturw. Reise Mossambique 6(1):57.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d7b41bf-010a-570c-be25-25fffa6e1d78','','','"<I>Biscutella laevigata</I> prol. <I>vincentina</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c98ed89-51fd-5269-a9e8-35ccaa2d5f56','','','Repert. Spec. Nov. Regni Veg. 12:295.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e793e44-276b-51cc-8cbb-7772a0d8b8b0','','','Select. stirp. amer. hist. ed 2:135.  1781 (ed. 1:279.  1763, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('997a386e-a4c4-56f0-aed8-d72a9c0a06c4','','','Pl. hort. schoenbr. 2:15.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('facd18e1-9b01-5814-81aa-e7b5ac36b60d','','','Cact. 3:227.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2de28d0f-f8b4-5b3f-9158-f4676841a3fa','','','Fund. Agrost. 133.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4adea190-f98f-5375-9fcc-9a0e42d454a5','','','S. Watson et al., Botany [fortieth parallel] 496.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('546198a0-145b-5cd6-90f4-322bbb795754','','','C. F. P. von Martius, Fl. bras. 6(1):41.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fa3e431-ae59-5762-9eb4-a12fd720b6cd','','','E. H. F. Meyer & J. F. Drège, Comm. pl. Afr. austr. 9.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e5fb936-1282-521c-a849-a2cf2d59f105','','','Feddes Repert. 79:51.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0fe1faa-03f7-5a32-8590-0373ee04ea9c','','','Summa pl. 1:388.  1789-1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef861d79-823e-5e23-9a46-3d926ae56c0a','','','Fl. lusit. 2:312.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5864edfb-a0ae-5495-8daa-b65203b83c9a','','','Prodr. pl. cap. 136.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b09551fe-8dc1-55d7-8f09-14493efd03e9','','','Acta Phytotax. Sin. 33:611, fig. 2.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bcb6897-771e-5378-ba47-9d7ea000cf47','','','Descr. S. Amer. pl. 3.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73a1830e-061b-5b81-ac3a-f29ce7999727','','','Philos. Mag. Ann. Chem. 10:419.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58b4c8fd-2ee0-52e6-aed8-6e7a51edf149','','','Ann. Missouri Bot. Gard. 64:545.  1978 ("1977")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86595884-4552-57be-82a3-781489526f01','','','Bot. Mag. (Tokyo) 22:65.  1908 "<I>Pirus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45b6a381-fddc-5c4c-8b40-3b951adfed05','','','Arq. Serv. Florest. 2:23.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cff80669-27fa-5aef-8f0a-aca527110261','','','H. C. Andrews, Col. engr. heaths 1: t. 67.  1794-1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7727170f-3105-504e-93a7-04be5cc6cddb','','','J. Torrey & A. Gray, Fl. N. Amer. 1:379.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efc17845-45b9-558e-9598-d3666341ecb9','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 9:72.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5870f86f-f63f-5960-a515-099b5435a77a','','','Ann. Missouri Bot. Gard. 53:339.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77b3707d-c3a2-5b39-a645-d4578980ac77','','','Bull. Soc. Sci. Phys. Algérie 11:187.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a06c5e6a-b013-552f-9347-dcf5506bd689','','','Notes <I>Mesembrianthemum</I> 3:138.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d4405db-3051-51f2-b61f-62b64037dd17','','','H. Lecomte, Fl. Indo-Chine 7:332.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce2ddc31-6aa3-5378-a5f7-abb915dd68eb','','','J. Phytogeogr. Taxon. 39:5.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3a1118a-746a-559a-b946-ea0c0954ded0','','','Acta Bot. Yunnan. 22:132, t. 3.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db1db08e-0b3d-526c-b2e8-0c1bdd912272','','','N. I. Kusnezow et al., Fl. caucas. crit. 3(4):294.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7be23eb1-5db2-5a61-b7fa-1e9e7c767c07','','','R. de la Sagra, Hist. phys. Cuba, Bot. Pl. vasc. 138, t. 15.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e877e4c5-4fc6-557d-bb19-c88452c3dcce','','','Syst. nat. 2:22.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46a1b7d7-38ce-5894-a4b5-63bfc42bebd3','','','Sp. pl. 1:479.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92ea1528-b13f-5276-98d7-6aced72a3255','','','C. S. Sargent, Pl. wilson. 2:320.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72fa743e-11ce-5908-afb9-be8c2361ea4d','','','Pittonia 1:286.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a326cb95-bcd6-599b-b95d-39f649af2cfc','','','Contr. U.S. Natl. Herb. 18:211.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9d50b23-13d7-5d57-9376-5faffa2aa7d2','','','A. J. G. H. Kostermans & J. M. Bompard, The mangoes: their botany, nomenclature, horticulture, and utilization 183.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d887b52-d804-52f9-8318-8dcbc6e67b52','','','Garcia de Orta 5:12.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('132b0f8a-4d60-5582-9a88-e6a917ed31e9','','','J. Proc. Roy. Soc. Western Australia 3:108.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1590e0f8-ab92-5797-b9cd-7faf9a97caf5','','','Kew Bull. 35:261.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a75eedd-84ab-5156-922c-91b626ab0233','','','Bull. Torrey Bot. Club 25:118, pl. 330.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a2017b3-c482-5d76-a953-35f606e89f69','','','Pl. Ecol. Evol. 149:362.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('188789ca-13ec-54bf-965d-a0e6a0e612a0','','','Repert. Spec. Nov. Regni Veg. 41:232.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92606330-b60d-5469-b201-a6f910aa31a5','','','Proc. Phodesia Sci. Assoc. 7(2):68.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('658ab470-7017-57a5-93fe-d086639f19ef','','','Rec. Albany Mus. 4:92.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99d605e2-ad97-57fa-bc9d-8acc9e2b8de7','','','Bot. Zhurn. (Moscow & Leningrad) 56:1255.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('655d20c7-2dcb-54fb-8921-9aff9d64c259','','','Fragm. 1:84.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c315ebf-4e7c-5cea-853d-f42d48c5115b','','','Hort. dendrol. 81.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cba354d-45a0-58bb-9252-e440893f72e5','','','Bot. Mag. (Tokyo) 30:332.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cae6f9f0-0218-59d7-9fdb-c4a0aa64b236','','','Voy. Uranie 480.  1830; t. 69.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5abf891f-0eb7-5c19-805d-a3f72a4726fa','','','Fl. Würtemberg 513.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff5ede4f-5b43-57b9-bccc-5e65be5631de','','','Gard. dict. ed. 8: <I>Pastinaca</I> no. 1.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8e3d760-706b-5dc5-b0bf-bd8be2ce76ac','','','Contr. U.S. Natl. Herb. 7:196.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46b198c4-0721-58cd-a3d8-34a068adc3c2','','','Fl. Brit. India 2:28.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f484d437-0bbb-5166-b477-b7bb8ad6385f','','','Webbia 5:137.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8326d0bf-4a23-5886-8ba3-702a2faf7162','','','Pittonia 4:129.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67c382fe-10a7-5959-b908-7219add8a624','','','Elench. pl. nov. 38.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d6148e7-f30c-5e79-a60d-970b9b7a3e02','','','Rev. Hort. (Paris) 98:173.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e695178-1d4c-56d6-8401-1e6666fd55cf','','','Sitzungsber. Kaiserl. Akad. Wiss., Wien, Math.-Naturwiss. Cl., Abt. 1, 116:1943.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e56242f0-ce66-5a39-886b-c091ad4e4363','','','Bull. Torrey Bot. Club 24:302.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c57c73a-6e4b-5270-b27b-c4a597a11a26','','','Verh. Zool.-Bot. Vereins Wien 3, Abh.:130.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2068fd03-eae7-5276-86f3-3cf2b396f947','','','Lankesteriana 7:528.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e493d30-1a21-57b6-a608-53abf517e62c','','','SAPIA News 19:5.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30e11b36-da16-5808-9e69-2e8c65525920','','','Biosyst. monogr. Cucumis 56.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b69d242-7af5-55e1-aa6f-20b01b99969b','','','Man. fl. n. states 1045.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf3f3cf8-626c-5a30-b331-f60cd1e52f7f','','','Rhodora 45:301.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3d51d91-dbd4-56fc-b517-84a7ec1c0fdf','','','Nauchni Trudove Selskost. Inst. "Vasil Kolarov" 1:129.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edd9a1c5-d285-5c32-93d9-a2b61def03c4','','','Syst. Biodivers. 1:45.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdcafa0d-957c-59b5-bef8-e24eadd21d36','','','Brittonia 37:152.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28b3a1b0-12f1-5418-8c32-d84e9e1df708','','','Ann. Missouri Bot. Gard. 25:413.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0353fc99-f4d0-51fb-8e1e-34433828e64c','','','Pl. tinn. 25, t. 11.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4c96d38-8a69-52a6-ab2b-4813ce223695','','','Ann. Sci. Nat., Bot. sér. 2, 17:64.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de727b26-3b66-5fac-a853-bee5813169a7','','','Ann. Bot. (Oxford) ser. 2, 6:101.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af0e9d2e-4c16-505c-94d6-e18ccfc3441e','','','Trans. Roy. Soc. South Africa 3:297.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cac1359-6a83-5e38-b770-e97bed5068da','','','Contr. Arnold Arbor.  3:68.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5b0921f-a038-5641-b217-b22102c53523','','','Kew Bull. 42:456.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('314e10ad-666c-57bc-948c-873659676e56','','','Fl. bras. 13(1):561, 599.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f15d9bfb-53e1-5647-b5f6-ed66bb85c4d6','','','Fl. ludov. 13.  1817 "<I>prealtum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03ec9af6-1c98-5f43-978c-da42aa47f2fc','','','Edinburgh New Philos. J. 4:175.  1827 Dec','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40f516d8-adff-5616-a653-2d991f83abff','','','Aliso 3:237.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9b27661-fa48-5f06-9e96-1f76553a608b','','','Cact. Succ. J. (Los Angeles) 38:54.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a796244-3879-5ec9-97ed-30044bf7c4bb','','','Telopea 1:380.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('861d128a-f1f9-5d4e-9589-9cf74e556f11','','','Bot. Jahrb. Syst. 7:212.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c93ad04-77ed-5e01-8f18-d3971dd08d7e','','','Flora 47:41.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2078f64d-df87-5658-8c19-ccc91af2a734','','','Reinwardtia 6:192.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b91b4ae-977d-569d-8ae2-ab81c7a34a72','','','Ann. Sci. Nat., Bot. sér. 3, 11:81.  1849 "<I>ulvaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1acfc7ce-edd6-5b04-acb3-585a087035c9','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 31:102; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 12:545.  1886 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b332f4ec-466a-52c5-9f91-64a3406914db','','','Candollea 2:140.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f7ea3f6-301f-5073-a47e-38d2f1d4f2c2','','','J. Bot. 5:298.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b1dfbaf-38ab-5592-b5ed-a9b294107265','','','H. J. Riddelsdell et al., Fl. Gloucestershire 611.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e280d4d-b87c-5b12-92d5-b2f1decf896f','','','Mem. New York Bot. Gard. 74(1):193.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afd688f3-0fbb-5489-bf49-fa80b5d2de2e','','','Encycl. 3:24.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('029c3974-afd0-532a-b76c-790e34cba2af','','','Bot. Mag. (Tokyo) 24:149.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fb8bda0-551e-58d5-95bd-1a189ca0e6fb','','','Choix  pl. t. 17.  1803-1804 (non Aiton 1789)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b3ea3de-c026-5e33-97b6-802a9335be8a','','','Akad. Nauk S.S.S.R. Bot. Inst. Komarova, Rast. Tsentral. Azii 4:205.  1968 (Plantae asiae centralis)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('448b3495-5489-590f-ba5e-895ffca71ba1','','','Fl. bor.-amer. 1:70, t. 25.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57b015af-f999-5208-a1b8-8f062af4ab30','','','Syn. pl. glumac. 1:247.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('750fa2be-f322-542e-9f70-03dd0044114a','','','Fl. ross. 3:84.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0601cfd8-64f8-57c5-982c-a89794609d45','','','J. Bot. (Morot) 5:154.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c08f0a2f-0999-5d67-a6de-a8940bb25716','','','Amer. Fern J. 92:97.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('058f62cd-49fa-53df-8670-e456c43393bc','','','Gard. & Forest 10:245, fig. 32.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99d67981-0238-5bb4-a881-b55d9ffb69ac','','','Bull. Fan Mem. Inst. Biol. ser. 2, 1:252.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7a862a5-bb98-5f55-9252-863e9a41a787','','','Bot. Zhurn. (Moscow & Leningrad) 81(8):80.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6140fe14-20d9-53cd-9e4b-4452e21db813','','','Kaktus-ABC 127, 411.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1f95d1c-a43f-5a22-948d-2566655ceb61','','','Cult. Prot. 80.  1809 "<I>artemisiaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c64be74-4b65-57a8-a98d-490a4bbf50fb','','','Bull. Mus. Natl. Hist. Nat. sér. 2, 3:523.  1931 "<I>prieuri</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cd114f5-80d8-5126-9ba2-972de08a5977','','','Gen. hist. 2:215.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f56b759-44c4-5c07-b788-723d0a7aba7f','','','Euphorb. gen. 80, 111, t. 9, fig. 30.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e46db82-d539-5506-ad16-0381245c5907','','','Bot. Gaz. 78:276.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c908f02-83ff-519c-8ef7-aa0a5d95a5a3','','','Bull. Torrey Bot. Club 30:648.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dad4fda-701d-5fa6-be1e-94fefc20884e','','','W. P. Hiern, Cat. afr. pl. 2(1):232.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26ccdb2a-db2b-5f24-bc4b-b7501bd5ef52','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 13:101.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('212fb075-57c0-5473-8bbe-4ce2efd5e506','','','Icon. pl. rar. 3: t. 574.  1788 ("1786-1793"); Collectanea 2:292.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40d5c383-5be8-5c51-9fde-5a399fe81419','','','Phytologia 77:293.  1995 ("1994")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6b5d687-a882-538c-ba32-698c039a318c','','','Proc. Calif. Acad. Sci. ser. 2, 5:625.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b4d6aa7-bad4-595a-b2b6-02e211f2c9ba','','','Trans. Linn. Soc. London 8:348.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b90a224-67c7-5a93-af6b-4350f62ea0a2','','','Phytologia 3:176.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a8ba8c5-a9b2-5ca1-976e-66ba085f7707','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 70:123.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53076d83-d2b4-589c-97d5-2421f2d567dc','','','F. Berchtold & J. S. Presl, Prir. rostlin 3:99.  1830-1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3229d295-4348-5cb7-a627-31f24df68f86','','','T. E. Post & C. E. O. Kuntze, Lex. gen. phan. 532.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec6fcbb0-d0d3-5216-8470-81012fe73750','','','Brittonia 3:165.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('179e4ea1-553e-55dd-b52b-a89458695333','','','Proc. Amer. Acad. Arts 14:233.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87f3eda4-5fe7-53a8-bb8e-94ebd7632072','','','Bradleya 12:5.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54c879e9-a9f6-519c-9f1c-9d1ba57a2150','','','Linnaea 5:174.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5824e7bd-5db7-5d68-9551-bfd2da773221','','','Andr. Murray, Bot. Exped. Oregon 8:2.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('472d1aa5-9a33-5898-ad82-8401678caf1c','','','S. Watson, Proc. Amer. Acad. Arts 22:441.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55f71be4-cb9b-53b6-84f4-2c072b49ee81','','','Syn. fl. N. Amer. 1(2):183.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6eb9226-ab69-555e-8f92-b1e0d9e49211','','','Repert. Spec. Nov. Regni Veg. Beih. 30(2):257.  1929 (Prodr. fl. penins. Balcan.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b054605-b445-5605-a212-0b4cc5994353','','','Suppl. pl. 231.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59ea8fdb-d0cf-552b-9fb8-a64a87a9a3a4','','','Grass. N. Amer. 2:130.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c98a9d1-5657-55b9-9866-f67273092d1f','','','Fl. pedem. 2:264.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10e336fe-e35a-5e2e-80f9-4a8684110015','','','Asclepiadeae 65.  1810 (Mem. Wern. Nat. Hist. Soc. 1:76.  1811)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27c717ec-610e-5e7a-9636-835d75a0cb86','','','D. Prain, Fl. trop. Afr. 9:301.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82c108b4-3e27-5b64-8b84-ef72dd47f145','','','Sp. pl. 3:1846.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85af373f-58c8-531a-b3a1-a4446fac2fe8','','','Phytologia 91:181.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('176ba0e1-02e4-56ec-a123-89fb3e78f63c','','','Nuytsia 8:455.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c645bcf-e4e0-519c-b44c-53748e98ac75','','','Spisok Rast. Gerb. Russk. Fl. Bot. Muz. Rossijsk. Akad. Nauk 8:2.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27e5ddba-fd91-594d-9cca-3fd366e62720','','','Bot. Mag. (Tokyo) 40:492.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('272014f3-36cd-5be9-b513-6fcbfb7fcd38','','','Madroño 20:255.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dff47150-be38-553f-ac57-7aaa32513376','','','Proc. Amer. Acad. Arts 4:63; öfvers. Kongl. Vetensk.-Akad. Förh. 15:125.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c528de4e-ba71-5fe1-a5fb-ccfb1d7f4438','','','Mitt. Deutsch. Dendrol. Ges. 17:137.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fa0400e-f8e5-59f5-b2bd-67926b20d69a','','','Syst. Bot. 3:63.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('211e6a29-b5fe-53b7-82f9-86c86240f0c1','','','Anales Jard. Bot. Madrid 50:146.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('860f7c2c-de0d-588f-a507-a991b549e67a','','','Fl. bor.-amer. 2:192.  1803 (non Lam. 1798)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7c79f35-7a02-5a5d-86cd-f479a61a64ed','','','Bot. Bull. Acad. Sin. ser. 2, 33:216.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efb3e4c4-3439-5c93-a704-702d072020d1','','','Taxon 41:523.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b34386fa-5913-5433-bb64-08d35b3030fd','','','Univ. Washington Publ. Biol. 15:44.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e27897f-831a-5756-b69b-ca2c70b96e46','','','Bull. Mus. Natl. Hist. Nat. sér. 2, 4:734.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74f5b3ea-b0a0-5bd7-bf2e-4bd7f32a9531','','','Contr. Gray Herb. 127:78.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3eb40e42-1158-5718-aa51-174e44bad5ee','','','Fl. Australia 4:324.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96e878a6-e374-5fdf-8fab-60b0c57b4cf6','','','Sp. pl. 4(1):231.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63083ea6-cd26-5426-9179-6650c7e86fe6','','','Succulenta (Netherlands) 29:65.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecea698a-745b-5762-b13b-fd026690e1d0','','','Techn. Bull. U.S.D.A. 1268:19.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c54e498-a013-509f-a389-b2c4dc976994','','','Hooker''s Icon. Pl. 27: t. 2670.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83fdbb53-91cb-5764-bcb4-56fdf7cbb61c','','','Metasp. Minnesota valley 268.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51adaab5-0e66-531b-8545-300ac66418bd','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 11:186.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('def54e38-9f76-5e09-8f40-8e7830fbb0b9','','','Repert. Spec. Nov. Regni Veg. 20:151.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa042115-3d25-5923-97e7-560f5adbc95a','','','Acta Bot. Yunnan. 14(2):141.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9bedacd-8337-5359-8434-e72e5169c323','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:371[folio]; 6:474 [quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e746ac4-32a3-5cfb-8eb1-432f1013b98e','','','Biblioth. Bot. 20(Heft 85):504.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33f7ba09-c668-5a1a-89c2-87185753b995','','','Gard. Chron. ser. 2, 8:648.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d698041-271c-5ce2-b5e4-f0152cc24226','','','Sp. pl. 1:111.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8403baa2-a89d-5284-acda-c4ab18ae69e9','','','Prodr. 1:561.  1824 (W. Roxburgh, Fl. ind. 2:622.  1832)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f2af034-c9b6-548b-a6ac-0aa675aa9746','','','Hort. suburb. Lond. 67.  1818 (Hortus cantabrig. ed. 4:76.  1807, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0649c37-5aa3-5e7e-814f-c4bc0d3d1635','','','J. F. M. Valls & C. E. Simpson, Bonplandia 14:43.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ae3a89e-fd32-5564-bbc0-201375fb2663','','','Thai Forest Bull., Bot. 31:28.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93b0bae9-ddde-53b0-a0e4-682040d21d00','','','Prodr. 175.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95a4023f-9067-5d28-a7e1-4de7bc2ceaa8','','','Contr. Bolus Herb. 3:356.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6f83d4e-4f10-55e2-bb04-a953c1e75cc8','','','Meded. Bot. Mus. Herb. Rijks Univ. Utrecht 67:536; Recueil Trav. Bot. Néerl. 36:536.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fec458b-437c-50c9-8167-92d72719052b','','','Tent. fl. napal. 62, t. 46.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9e940f5-f833-5f61-a387-5b2b9672b109','','','Fl. bor.-amer. 2:76.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73487f66-0f3d-55ad-ad11-6890e001f045','','','Sp. pl. 2:1086-1087.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8a1bf39-d6ee-55c6-9e31-b0478c4283b5','','','Arch. Bot. Bull. Mens. 5:62.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f0a08c5-9ff6-5bae-84a9-fe46955afb33','','','Handb. Amaryll. 51.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42875ef6-254f-5066-9925-9028586f4c56','','','W. Roxburgh, Fl. ind. 2:457.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1a5eaac-f797-50cc-b355-2ffd7a88593d','','','E. E. Silva Tarouca & C. K. Schneider, Freiland-Laubgehölz. ed. 2:388.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a6e9baf-a1b8-50d1-a75e-c9b5f25ace08','','','A. Cronquist et al., Intermountain fl. 3A:278.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eeaf238b-e07d-593d-8c53-27072ce6b7a3','','','A. Rees, Cycl. 11: <I>Dicksonia</I> no. 1.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8ddb1a1-cb80-5d27-be04-ecbab87752ba','','','Acta Phytotax. Sin. 19:378.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('658aded6-0d47-5274-91d7-9c322ceb8d29','','','Amer. J. Bot. 3:61.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76a6aa3f-8871-5b05-a7d3-8164844bbd35','','','A. Rees, Cycl. 27: <I>Pimelea</I> no. 4.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7fd5059-6390-52c0-978b-e424a2893c69','','','Fl. peruv. 3:77, t. 314.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d277086-80ea-5a9b-8f37-67923d716e3d','','','Anales Jard. Bot. Madrid 60:259-300.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d4293a6-0f03-56c3-8b5a-3753ad4b7787','','','Bull. Soc. Bot. France 54:407.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c96c73c0-a0c6-5390-a55e-5128a02df504','','','Gard. Bull. Singapore 11:329.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5f2196c-e1f2-506a-b247-2f8b325c4d15','','','Fl. sylv. kor. 19:26, t. 9.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('621489b0-4492-59b0-8bc5-4997878c1636','','','Handb. field. bot. 55.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47001de3-898a-568f-bef6-3cf24aa8ea5e','','','Fl. carol. 89.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74956fa2-80d3-5234-9a24-87616ce8bd30','','','A. J. G. H. Kostermans & J. M. Bompard, The mangoes: their botany, nomenclature, horticulture, and utilization 138.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56c3ced9-3371-5686-a608-d6df52f76d96','','','Fl. Pl. South Africa 14: t. 521.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f66a0855-e97d-5d1c-be06-c3266adf1faf','','','Kakteen Südamerika 3:877.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b04a5d4-5d57-50e3-8e3a-c90bf29a5f80','','','Acta Phytotax. Geobot. 4:18.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5427c4bc-8c2e-5844-a3ac-f0a6d18dee1e','','','Mém. Soc. Phys. Genève 28(7):31.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2698e5e5-b99d-5b7a-a273-bd28c1fec154','','','Diagn. pl. orient. ser. 2, 1:18.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('941fbae4-5c76-5f90-83dc-e5492cb7c62a','','','Prim. fl. werth. 125.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5df71fa7-ec61-5692-936c-b80716fa01ef','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 259, t. 28.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7b85363-ebcf-5be0-b595-96474daf6c5e','','','Estud. tax. <I>Lonchocarpus</I> e <I>Deguelia</I> no Brasil. Ph.D. Diss., Univ. Est. Campinas 100.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e5cfe3c-6ca3-5070-96a5-1f1d148f351e','','','Ann. Sci. Nat., Bot. sér. 4, 11:137.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc734a93-c85e-5104-9617-b829d517e786','','','Fragm. 3:140.  1863, in obs.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddb632d3-455f-5cd1-82af-70beaed7bedf','','','Arch. Biontol. 2:425.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b9c28af-fbde-51bd-817a-039978ec188d','','','Orchidaceae 2:164.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf53bed0-8484-51af-9b6f-ea5cdc84d3ae','','','Fl. Italia 2:105.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d88e8317-73f5-521c-8fcb-730d3c0070aa','','','J. B. A. P. M. de Lamarck, Encycl. 3:637.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8021c8d4-19cf-57bf-a61c-4f47ca13431b','','','Bull. Soc. Bot. France 53(Mém. 4(2)):121.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae74f86e-9cb4-5fca-be33-5f54f7b745fe','','','J. Linn. Soc., Bot. 19:214.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82fc14b0-b03c-52dc-aa6e-eb5c9b818798','','','J. D. Hooker, Fl. Brit. India 2:734.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c2fe270-847c-51b2-8750-7b676ae79d00','','','Mauritius Inst. Bull. 8(4):85.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bf5a95d-9be0-51ff-b89d-032f15bc6123','','','Repert. Spec. Nov. Regni Veg. 22:268.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f02f5adf-99de-5974-bd34-be24751a22ea','','','Handb. Bromel. 53.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('336981a8-5605-556b-b7d8-21650c322229','','','Hortus kew. ed. 2, 3:32.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2ecb7eb-a409-55f6-bfb0-d6e9a12fe276','','','Fragm. 3:134.  1863, in obs.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6df03306-a909-5ed1-aa43-bd59b5992327','','','Fl. N. Amer. 1:386.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4dce752a-bda2-5037-84eb-29bc7ba9a1d3','','','Syst. Bot. Monogr. 83:206.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51c4117b-d233-55cb-97fe-2a733016e7fc','','','Taxon 61:948.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33785b82-2fbd-5c9c-931d-94cb7fc81d34','','','Voy. bot. Espagne 2:490, t. 139B.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48132ef6-faef-501f-94ec-e0af2921bc47','','','Notes Roy. Bot. Gard. Edinburgh 41:308.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26c3a6e5-a595-5f5a-b957-b1b1145bf047','','','Beskr. Guin. pl. 42.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44453ded-9572-561c-b208-46c14911e673','','','C. Gay, Fl. chil. 4:235.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43a4f6f8-a6cd-5e20-8dc3-c41f2fe18f1f','','','<I>Phalaenopsis</I> monogr. 128.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1265d5ec-83f8-51bc-8eb7-4a4ef11a8132','','','Amer. Monthly Mag. & Crit. Rev. 2:344.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f411cbd8-b87f-5d9c-b635-d2dba3a1e651','','','Syst. Bot. 41:43.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aed167f7-9f21-5816-b710-795d440872cd','','','Bull. Soc. Imp. Naturalistes Moscou 11(2):259.  1838 (Enum. pl. Talysch 29.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d061ee0-63e7-5c24-9bd3-07c798459a7b','','','Linnaea 12:311.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3a2595b-1b85-5bad-b6a0-02a2ec69c033','','','Blumea 46:226.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8b274d2-ee10-55d3-8510-7923f0eeeaa5','','','Fl. Lyon. 90.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0206a1b-16ec-593d-aec3-6b50b58d4bf4','','','Sp. pl. 1:239.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8533318-d1f1-5745-b921-334d612eb3a1','','','Edwards''s Bot. Reg. 26: misc. 89.  1840 "<I>Bolbophyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c88784b1-4e09-59f9-8920-567a82d30fe3','','','C. F. P. von Martius, Fl. bras. 11(1):224, t. 65, fig. 1.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c02d58c-55c5-526a-bef0-05eec1953c63','','','I. C. Nielsen et al., Opera Bot. 76:73.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5674fc25-4933-54bd-8e7d-70fa4bde2d8d','','','Giorn. Fis. Chim. Storia Nat. Med. Arti dec. 2, 7:44.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7de00df7-43b7-5674-8113-07aab0eb9f8d','','','Proc. Amer. Acad. Arts 22:471.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93ed3321-92d8-5242-b45f-bd1931d55476','','','Repert. Spec. Nov. Regni Veg. 7:312.  1909 "<I>jürgensii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('827acc99-a2fe-5ed6-bf45-9928e60feb6e','','','Icon. pl. formos. 3:179, fig. 26.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2eb05afd-fb6d-5257-9290-1617222f3308','','','Mus. bot. 2:59.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('811ad7e4-42a8-5589-afc8-0835ae19a753','','','Bot. Mag. (Tokyo) 29:313.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37cd53a3-5f3e-57be-ad13-019f61f25f80','','','Kongl. Svenska Vetensk. Akad. Handl. ser. 2, 46:37.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14662557-fe80-55f9-afc5-aa798e0cd769','','','Taxon 29:601.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b97a8eeb-56ee-5f01-9c05-6daecebb0cca','','','Trans. & Proc. Roy. Soc. South Australia 46:568.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13c85190-bcb1-5244-9eaa-6a36dfd381c8','','','Bull. Montana State Univ., Biol. Ser. 15:69.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a645786c-f39e-50b2-b98e-bf72a7308b3c','','','Ann. Missouri Bot. Gard. 23:450.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8ca0695-2cfc-5d54-9fda-6dcb34d1ed8f','','','Ann. Sci. Nat., Bot. sér. 3, 16:248.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aad2ed51-0270-567c-8d57-52a52a9afeef','','','Trans. Linn. Soc. London 10:95.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('293c7063-7f70-5c04-a1fe-fc438f73d5ac','','','Hortus kew. ed. 2, 4:120.  1812 "<I>Mathiola</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09237a5f-90bc-59f5-ba82-a18b0b30080c','','','London J. Bot. 6:585.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a040c991-ab4b-5846-acc5-ef52e943f82d','','','Fl. aegypt.-arab. 214.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4ecc9db-ab62-56dd-8e82-37ca7e3c5da8','','','Linnaea 21:383.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7d34247-97d3-58d4-ae3b-c1d12c04e047','','','Cat. hort. neapol. 1813 app. 1:35.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7aa53134-7e9e-5be7-8509-e7888f53a376','','','P. H. Davis, Fl. Turkey 6:749.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('708d73be-466b-5f27-a229-25e3562c2455','','','Bot. Jahrb. Syst. 36(Beibl. 82):103.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb5b4544-3fa2-5b2c-a8c3-48b86b08abdf','','','Contr. U.S. Natl. Herb. 35:534.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b06908f-6e28-5e29-bf05-b631380f2aee','','','Dansk Bot. Ark. 33(3):80.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba74ae37-81d2-5e60-bbf4-8bc712e4cbbc','','','Suppl. Calif. fl. 110.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1912e4fb-d236-5a72-9c9c-de2a23959f8e','','','J. Franklin, Narr. journey Polar Sea 734.  1823 (Bot. App. ed. 2:6)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34e1ad03-e744-53e6-81c3-9d07d476bba6','','','D. Prain, Fl. trop. Afr. 9:909.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6592a107-8c26-52ff-b91c-02fc80e7492f','','','Fl. flumin. icon. 10: t. 39.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a21598e-a2bd-5978-99f7-1f2fda3c282c','','','Proc. Acad. Nat. Sci. Philadelphia 85:89.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5b8234e-6e43-52a0-be68-b76f3dea76e4','','','Four Seasons 2(3):17.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55856b11-026c-5755-85e6-e908f38dd161','','','Fl. ins. austr. 24.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b26ce48-a7bc-5dba-85e9-44023bdb6aee','','','J. A. Battandier & L. C. Trabut, Fl. Algérie 1(1):268.  1889 (P. F. A. Ascherson & K. O. R. P. P. Graebner, Syn. mitteleur. Fl. 6(2):974.  1909)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03e06493-2633-5977-b12f-6be5af5938fd','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 7:107.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcfdc5c7-a273-59bc-b7a5-b04b56853e24','','','Nordic J. Bot. 20:522.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5525761-07e8-5c91-90d2-85e9d061f1ba','','','Brittonia 48:238.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61a0ab49-bd3e-5fc6-bee4-456a2069db4b','','','Mém. Acad. Imp. Sci. St.-Pétersbourg, Sér. 6, Sci. Math. 1(4):397.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f288761e-bc75-586e-9731-11c6bd055d25','','','Repert. Spec. Nov. Regni Veg. 41:196.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e6dc40a-3697-5c1c-9af8-65e2a831a6d4','','','Proc. Amer. Acad. Arts 18:191.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35388afa-95f4-5cf9-bc5a-925bdbd002f5','','','Index sem. hort. bot. Charjkov 8.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f861457-c1fb-512f-b51c-5cd6100e73d5','','','Mem. New York Bot. Gard. 8:314.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd5f0f12-1782-5a9e-8b4a-f31980ff8535','','','Fl. ins. austr. 35.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53f4608b-5aee-5631-aeb9-b2f2516907f0','','','Phytologia 49:47.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f8e1ee4-a2f9-50be-a539-98a5f025eb9b','','','Kongl. Svenska Vetensk. Akad. Handl. ser. 2, 43(4):48, t. 4, 6.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f920688c-1456-50fe-a552-4bdccd018cf6','','','Bot. Mag. (Tokyo) 18:73.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('385fa2bf-6a4d-5c77-a9d7-23ece63396fc','','','Nov. gen. sp. pl. 1:7, t. 12.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0219acc9-6a1d-5704-8db3-aee54a9f2f2f','','','G. Engelman & J. Bigelow, Descr. Cact. 4(5):50.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f20abe5-84d1-5c6b-88ac-75941427746d','','','Stud. fl. New Zealand 44.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e4e2d47-1340-5548-818a-ff1ba4f0c73d','','','Bull. Jard. Bot. Natl. Belg. 44:444.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffedd48a-65fe-5fd9-84ad-b5522450b42b','','','Folia Geobot. Phytotax. 8:110.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c602505-b46e-5163-908f-c0434c4e0485','','','Ann. Missouri Bot. Gard. 20:731.  1933 (non K. Schum. 1895)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d254c32-033e-554a-905d-6b12a4fb9ea6','','','Trans. Linn. Soc. London, Bot. 9:62.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27548961-6242-5f0b-8b3f-30046e8f7b01','','','Hort. kew. 2:135.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f747512-bd54-590f-a84b-e0112b8741e1','','','Revis. gen. pl. 3(3):375.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22151447-e463-5044-a4b2-f502d03c8699','','','Kongl. Svenska Vetensk. Akad. Handl. ser. 3, 8(2):35.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33285ba9-02ee-58cd-9bf8-1c5de2a87e49','','','Bot. Mag. 106: t. 6524.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59fa6a8a-9a5f-5237-86ea-e898a0c5e5f1','','','J. Linn. Soc., Bot. 21:398.  1885 (non Hook. f. 1860)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('067188a9-9bb5-590e-9d8f-e11c17179bb8','','','Trans. Hort. Soc. London 7:242.  1828 ("1830")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d83e5dd-9584-58c7-9c2c-9f7027cd1d60','','','Bull. Bot. Res., Harbin 8:19.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('837160fe-d41a-5f31-9b23-b4a83f3e86eb','','','Ann. Sci. Nat., Bot. sér. 3, 11:113.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e93f7a5e-cee9-5716-8aa2-087ab393958d','','','Phytologia 69:272.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff91e574-beb6-538a-96d6-6ef6a538c86a','','','Ann. Bot. (Rome) 9:56.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ea2d962-ff03-5881-bcb4-0caa2f46c9ba','','','Rodriguésia 18:19.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14fe27c7-55ae-5e34-960a-d0a3c3e43c00','','','Erythea 2:95.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('403ba82b-114c-5fef-8ecd-f974b1d1ca33','','','Fl. peruv. 1:2, t. 3.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9dfd5e2-d799-54de-8b8e-bd5db9d4ae0a','','','Linnaea 41:102.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('223e7ca6-4380-5e94-b176-46d958c4919f','','','Addisonia 9:31  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08c0fd23-c221-52b6-bfaf-c8c0e67ba909','','','Flora 68:543.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e689194-dd39-5cf0-8d76-f4e8d1d59e5c','','','Syst. nat. 2(2):1269.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8c97e35-8b65-5e87-a4ca-bc8909520af6','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1858:46.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d49505d-1d2f-554a-8663-f11eb305553b','','','Bull. Herb. Boissier sér. 2, 5:849.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f18659c8-35ae-55b1-933f-275c6d7651d7','','','Lloydia 6:243.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66549968-9ed2-529b-88c1-e9638434248d','','','Castanea 4:60.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7461e2fb-af56-5610-a3b3-6a74266414d3','','','Pfl. Exkurs. Fl. ed. 4, 359.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('649afcb1-ef82-5042-8393-cad610460877','','','Phytologia 75:29.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5412b4e6-0022-5dc8-a41a-ff5114af75a2','','','Notes Roy. Bot. Gard. Edinburgh 29:318.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b28281c-2367-5e2d-87ee-89d3481f858a','','','Gard. Chron. ser. 3, 37:138, 228, fig. 97-100.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0dc12937-4e26-596f-88d6-f920d047ec74','','','Manual ed. 2:252.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6c32a2f-16ef-5ea0-9949-8494425b43eb','','','Gard. dict. ed. 8: <I>Linum</I> no. 7.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba380a03-b5e1-5620-8911-9b339dede098','','','Observ. bot. 14.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12d5a7a6-7ef4-53d7-9f89-87251938bdaa','','','Bot. Jahrb. Syst. 76:67, t. 4.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e95ac508-6607-5bad-b258-783c1582d380','','','Bull. Div. Forest. U.S.D.A. 14:248.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef6bee4c-4bee-5683-b691-bbb87d06355e','','','Orchid. Mexico Guatemala t. 18.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c5df592-cd20-5f5f-ab93-e354a1ce151b','','','Icon. filic. 2:162.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4e219af-b1d2-5e12-8899-05439645c08b','','','Contr. U.S. Natl. Herb. 10:499.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57f7db03-5843-5c6a-8177-9f581b839a71','','','London J. Bot. 7:336.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05d5f90c-164f-5d6b-ab3c-c788ed8d714d','','','Nova Acta Acad. Caes. Leop.-Carol. German. Nat. Cur. 76:174, t. 4, fig 28-30.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac6115b2-f67c-5b25-8af8-a2a5cf8713d5','','','Révis. gramin. 2:411, t. 119.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a20aa01b-0d15-5f55-8a63-fccca4ff5ba0','','','Bull. Calif. Acad. Sci. 2:494.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35d3647a-c226-5abd-91ce-52fb4fc82559','','','Gard. dict. ed. 8: <I>Cereus</I> no. 1.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72c9ae54-3997-5598-82b3-9c9a7c1e20fc','','','J. Bot. (Hooker) 2:152, t. 7.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a4418a9-24b8-5d68-9176-71a32092ad89','','','Hist. pl. 8:303.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a1f4599-00f8-5239-a111-a6f3f2642956','','','Trans. Amer. Philos. Soc. ser. 2, 8:270.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b91c300e-728b-5fd6-894e-9d41a0217fef','','','I. Urban, Symb. antill. 4:108.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c142c30c-25a8-598f-83b9-88fcdebd3880','','','Prim. fl. Galiciae austriac. 2:27.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('212686b6-c05f-5ef7-b84d-3070b8cc748a','','','Fl. forest. Cochinch. 1(fasc. 1): t. 3.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('635f3689-8456-5c52-ae7b-566ac6415f32','','','Legum. Caatinga 124.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b19a0a5-a7e7-5533-a212-20e6ae5cf8e9','','','Enum. pl. 1:468.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b6d0c52-846f-5bcb-895c-6f6271804383','','','Vilm. Blumenengártn. ed. 3, 1:810.  1894 (Lindau in H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3b):351.  1895)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b75e1997-97d1-5e9c-beff-26d1eba09346','','','Amoen. Acad. 3:404.  1756','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('842e2ddf-94a8-5a9e-98e3-8c589e758817','','','Fl. cochinch. 2:574.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2793c060-caa6-5f5f-85c7-65fe51142683','','','Fl. ind. ed. 1832, 2:608.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cc8e2a6-58e6-5f59-8214-ccd51151183e','','','Fl. orient. 3:287.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('219dae6b-a5d2-50a1-900b-b857456806be','','','Ziraat Vekâleti Yayın 716:113.  1955, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e772e70-401c-534a-adc6-f14034682c53','','','Butl. Inst. Catalana Hist. Nat. 25:100.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9f4092b-d592-5202-9a50-cfa5857dc0ef','','','Bijdr. 1097.  1826-1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9943bcb7-9265-55fb-acc9-91ccd35bf7ff','','','H. Schinz, Verh. Bot. Vereins Prov. Brandenburg 31:223.  1890 (Beitr. Fl. Deut. Südw.-Afr.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34cc66dd-d34f-5a4a-87ce-dc8cb87bfca3','','','Wrightia 2:184.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf4216f3-0ab5-5891-8356-773694c26982','','','Bot. Mag. 62: t. 3448.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bfdb9e2-714c-5d28-bd16-835dc938d1c8','','','J. Linn. Soc., Bot. 11:400.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f941ab5d-c8a8-5006-94d9-a45ee514f2fe','','','Fl. antarct. 548.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb79cf48-088e-58d7-944f-b6089d3868b8','','','J. Bot. (Hooker) 2:99.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc7cd854-a3db-5f2e-ac82-6f657937dc03','','','Mem. New York Bot. Gard. 65:299.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9e7600d-7fbb-5f6a-a6ee-32ec3eed11b1','','','Bull. Soc. Bot. France 47:139.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('949cdd47-18ac-5766-b3ec-e737b5cabb76','','','Harvard Pap. Bot. 16:161.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('060fa7e0-2abf-54b9-8c1e-4c8d212d43c6','','','Soobshch. Gruzinsk. Fil. Akad. Nauk S.S.S.R. 1:689.  1940 "<I>palaeo-colchicum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbc93d81-1f71-5b67-895c-b1c3e1637303','','','Mimoses 196, t. 55.  28 Jun 1824; F. W. H. A. Humboldt et al., Nov. gen. sp. 6:336[folio].  12 July 1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bda71955-f727-5e25-8553-01c71861c41d','','','C. F. P. von Martius, Fl. bras. 13(2):452.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47451726-bb47-59a5-bcfa-b083076f0304','','','Fl. South. U.S. ed. 3:425.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8066e184-0e6a-59eb-b19e-8aa3a4f63703','','','Contr. Gray Herb. 214:9.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f01ee89-efbf-5880-9dd5-166ca7694780','','','Opera Bot. 95:188.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf4a8b42-378a-5f18-acc2-7be109f11228','','','Notizbl. Königl. Bot. Gart. Berlin 3:55.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d1b28a9-1b04-5427-b0c8-90c85d52c149','','','Iagttag. Vextrig. Marokko 198, t. 6.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82e28043-896c-5439-8366-173dafd86499','','','Prodr. 578.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ebdf69a-1c92-5648-8d33-81a544f1d328','','','W. Roxburgh, Fl. ind. 2:22.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58ef8e79-52ed-51c0-96bd-5aed84b9d228','','','Zemledel''cheskaia Turtsiia 274.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1d6f0db-a5ea-57eb-8ca0-e1d96a2b44f4','','','J. B. G. M. Bory de Saint-Vincent, Dict. class. hist. nat. 3:351.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b2a12aa-c6fd-5692-97b2-b57bc8c18c42','','','Notes Roy. Bot. Gard. Edinburgh 21:36.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('458aff38-a776-5045-8817-10efc7c55685','','','Fl. columb. 2:19, t. 110.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('026e6eaa-5983-5683-8c3b-184b3f2cfdba','','','Bot. Mag. 82: t. 4908.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d75682ae-347b-528c-9a5f-c831134f31ab','','','London J. Bot. 4:143.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c61d0f3c-d2b2-55ef-b4d9-1a4d7748dc91','','','Cat. pl. horti monsp. 154.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a8d08ed-01bc-5d39-937a-5a130d8536ef','','','Gard. Chron. ser. 3, 9:117.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('032e8831-4a24-583b-863a-e684fd152710','','','Prodr. 8:161.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc7deb4a-7c2b-51ed-90fc-47e087d9ad9f','','','J. Linn. Soc., Bot. 55:168.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0240760-eaf1-5456-a3c2-98e9d45c1d6b','','','Elench. pl. nov. 74.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efde9164-315b-5362-bf75-8c15d3ae61f9','','','Bot. Jahrb. Syst. 1:327.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0991edc0-91cb-524d-9ac9-760867bab781','','','Lingnan Univ. Sci. Bull. 9:63.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29f867a8-5b3c-5417-9579-ebf9bde9d8e5','','','Exot. bot. 2:105, t. 112.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('475e43dd-9375-5878-a04b-1533fd485028','','','Tent. fl. bohem. 1:32.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbea24b4-9df0-51ec-9d30-b2b8729cd9e2','','','Syst. nat. ed. 10, 2:1323.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3b1cc6c-e1fa-5501-9162-5587bd85403a','','','Biota 11:97.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62538f2b-fff2-5e02-bc6c-7b9eabd05381','','','Fl. orient. 1:494.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11ddce0b-4383-565c-b2f6-e5299b9b07bd','','','Edinburgh J. Bot. 60:547.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5eaf13b8-3f8b-5a93-98fd-8a7ac9bc27a4','','','PhytoKeys 39:57.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66fce513-13d4-5c97-9889-6508493db6ca','','','Rev. Zool. Bot. Africaines 21:304.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1c3dc29-69ef-5773-97c8-2934756c3d3d','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 14:14.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0a30d80-8f04-5f59-a5ad-2164c25ab48c','','','Farrnkrauter 2:65, t. 127.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54a63e33-ae4d-54d0-98cc-89b70ae6cd74','','','Bot. Reg. t. 237.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('995b8327-09fb-5918-8b25-c400743edc2f','','','Prodr. fl. nepal. 73.  1825 Jan 26 - Feb 1','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b4ee22b-02c9-5132-b9da-36c712b96aa8','','','Revis. gen. pl. 1:353.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('150ba3b2-5d7b-51bb-909b-b00bf348b5b1','','','Pittonia 2:218.  1891 "<I>Pentstemon</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7483f5c-5cd9-5601-a35e-d63c74bb0f13','','','Bot. Mag. (Tokyo) 9:72.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('008dde02-ca36-54cd-a595-1fbb6ed13c49','','','Hooker''s J. Bot. Kew Gard. Misc. 7:125, t. 3.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c15f093f-9a04-5a9a-a5d8-a83e8daffdd3','','','<I>Ficus</I> 6, 11.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a074baa-415b-5122-8a82-28eedd5a7ac0','','','Revis. gen. pl. 2:579.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d6faa3e-99b9-564a-b13e-0f3d71730d43','','','C. F. Hornschuch, Syll. pl. nov. 2:6.  1825 (C. L. Blume, Catalogus 110.  1823, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b015003-d3a4-5891-bf31-598a3dcdf197','','','Spec. bot. New Holland 48.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38529193-88e2-5681-9c40-df2b8838a906','','','Torreya 33:70.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9350a00-a4f4-5c95-a5f2-f0bbb65be850','','','Trudy Tiflissk. Bot. Sada ser. 2,  1:42.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2070e08f-f9fe-5a07-a811-a27bb27c658f','','','Blumea 30:307.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b394879-d4ca-5f74-bfde-1ff4e66d61f9','','','Ges. Naturf. Freunde Berlin Mag. Neuesten Entdeck. Gesammten Naturk. 5:401.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc670223-d3e9-53c6-acfa-72b21e57bb3d','','','Bull. Misc. Inform. Kew 1913:120.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4febbfa8-81d8-5ba3-af6c-be21543558d4','','','W. H. Harvey & O. W. Sonder, Fl. cap. 3:545.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('053438ff-0b2c-54be-8895-2cf9666faaf1','','','Mus. bot. 1:297.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ee8a42e-71c5-5b46-acac-d431044995f2','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 3(2):125.  1875 (Allior. monogr.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7018ee0-3f90-5e8f-a184-caff07b4b3da','','','Bot. Misc. 3:145, t. 98.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('986037f8-0bdc-51ec-954a-ae6d091dd69a','','','Ann. Transvaal Mus. 14:402.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e23e06e4-9f3f-5435-a6ba-4e49fa3b82ff','','','Trans. Linn. Soc. London 2:337.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea247790-78ee-5c0b-8b30-d2760e43fbe3','','','Fl. ross. 4:93.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('776274f6-65fe-5a9e-bec3-604bd1a5c29a','','','Bull. Jard. Bot. État Bruxelles 24:436.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80bf34d8-3760-5af5-bdf6-acd621cd0e8f','','','Fl. austral. 3:488.  1867 (F. Mueller, Fragm. 5:79.  1865, pro syn.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0046e271-6320-5a4f-af12-6380fc740ba4','','','Fl. dan. 12(35): t. 2044.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75a5acf9-1dc2-5bdf-9284-de4b7cd5e07e','','','Kew Bull. 1953:98.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b17c2f39-9cfb-5a4c-b627-73e1c03f17da','','','Engl. bot. ed. 3[B] ? (actual place of publication not yet determined)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d567dc0-3c3c-5095-8fe0-7c4f146d610b','','','Bot. Jahrb. Syst. 25:24.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41568208-ded3-51db-b333-10e07558c7c6','','','Proc. Calif. Acad. Sci. 3:4.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85695f99-754e-5d05-98c3-f2284e3d8b96','','','Canad. J. Bot. 37:667.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e55c3f25-8d35-569b-ba4a-474d94bf63fe','','','Rural reconstruction, ecosystem & forestry 187.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d361c0c5-783a-5e0d-9b07-47271ee34bcb','','','Bull. Misc. Inform. Kew 1920:280.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b81850e7-530e-522f-9f1a-3c31bc5d1515','','','J. D. Hooker, Fl. Brit. India 3:453.  1882 "<I>gualtheriaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88f24462-7067-5ec3-a1df-656a436df88e','','','Fl. ross. 4:183.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9a4f6b0-d861-5b3c-b76c-f26320d0e286','','','C. S. Sargent, Pl. wilson. 1:194.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27959f94-4802-5648-8e1e-457e75fe519a','','','Actes Soc. Linn. Bordeaux 11:323.  1839 [1840]','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6212cb4-ca71-5ddf-8fad-6b18232e7fbb','','','C. S. Sargent, Pl. wilson. 1:180.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79cb282d-7a60-5094-a454-bdd7d163d2cd','','','Bol. Soc. Brot. sér. 2, 31:139.  1957 "<I>taylori</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f4adfb3-b6e9-54cd-969e-4e1f365d0c44','','','Flora 34:630.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e783dc7b-5f8f-5793-acb1-88457c96d509','','','Gentes Herbarum 3:88.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d868979f-001e-52a7-a809-b1f6b25bb440','','','Descr. pl. Cap. 123.  1767 "<I>polystachia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15949b22-1f64-5bf8-9a3b-a38fc2323c41','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 2:336.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72f7cdd3-a1f3-5d8d-ad8a-fa021c85dba9','','','Bull. New York Bot. Gard. 4:164.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee0e2ed7-02ff-5b44-9f22-17f27aa2b851','','','A. L. P. P. de Candolle, Prodr. 14:18.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d62d5e16-c9a5-5453-a186-9718dd317e1e','','','Novon 25:138.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22f2784c-7bd9-52da-aa1a-a54f7689d92f','','','Bot. Jahrb. Syst. 35:477.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7191712-2493-5a99-b690-c72ff9c5b934','','','H. M. Willkomm & J. M. C. Lange, Prodr. fl. hispan. 1:111.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('870c5d77-c2c3-55e7-aad8-132c81059a02','','','Proc. Amer. Acad. Arts 22:469.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8be86174-3be3-5d0d-9f90-4fdeac80102a','','','Prodr. 1:580.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d59f430-f946-5388-aa71-a387f1349574','','','Icon. pl. select. 39, t. 16.  1820 (Link, Enum. hort. berol. alt. 1:301.  1821)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d96fdf0-19f6-517a-a543-3972315050bf','','','Cycl. Amer. hort. 2:904.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bbcbb52-15e6-5197-a066-7879bf3ca5df','','','Fl. angl. 364.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad0ddc2a-3a48-58f5-a202-d86a526598be','','','Prodr. 2:89.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('671d7846-c669-5a2e-865c-0080e0dcc06e','','','Bot. Jahrb. Syst. 25:23.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f3998fe-5994-5582-9e76-6aabc61ecd4f','','','Botanist S. Afr. 170.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f32d72d-2e17-5aa8-972c-b8c823d31437','','','Mem. Mus. Ci. Nat. Barcelona, Ser. Bot. 1(3):16.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c7d3be8-1861-5abe-9cb9-f41183425d9d','','','V. L. Komarov, Fl. URSS 7:610, 749.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7270314f-211a-57a8-9a3f-ed1f76874d69','','','Anales Soc. Ci. Argent. 10:219.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19fa63a2-b125-5fc6-bd79-c10c4be246a6','','','Bull. Soc. Hist. Nat. Afrique N. 13:183.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2e5df8b-a06d-591c-a3ef-efeb7b6fae8c','','','Pittonia 4:38.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a998209d-7864-5c49-99c1-c779071a8269','','','J. Arnold Arbor. 5:239.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26504cad-c0c4-5f2f-9c30-4f96154f015c','','','Linnaea 28:427.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f13f0b4-5001-5f3a-bb0d-d4d08876f312','','','Oesterr. Bot. Z. 51:198.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('818a5a20-e02f-598a-9b7c-5aabc2b04cc2','','','Lloydia 7:273.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5e54cb8-51c5-5eb9-9374-e88276ef8f94','','','Bull. Bot. Res., Harbin 4(3):108.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9dfb5c8-9012-53e8-ad23-195da4e130a6','','','Hymenophyllaceae 34.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea06c6a6-3068-5c7e-a7f8-e72eec2e59d9','','','Bot. voy. Sulphur 153.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90bb3107-0077-52b5-8303-f53ae667a146','','','Bull. Torrey Bot. Club 23:100.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53f4280e-9a9e-5f8e-b282-79e1b22830d4','','','Fl. bor.-amer. 2:254.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('667e01d7-f2e6-5a77-bae3-c4218ad6205f','','','Revista Mus. La Plata, Secc. Bot. 1:240.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4fd8c2d-ac71-5d2c-8269-a7f0c30edd15','','','Ann. Mus. Goulandris 4:184.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90635710-66e3-525c-ad87-3a24d564790f','','','Suppl. pl. 112.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('600b137e-fcdc-53f8-b66f-0bd0bd2f0741','','','J. Washington Acad. Sci. 17:314.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f714d7f2-69fa-5845-ba96-29fbef326b55','','','Sitzungsber. Kaiserl. Akad. Wiss., Wien, Math.-Naturwiss. Cl., Abt. 1, 51:366, t. 7.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d37b8762-97ba-5c19-9a2a-3b6649db0eab','','','Acta Phytotax. Sin. 23:392.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6656401a-c704-5a38-9e67-63020f43f023','','','Linnaea 3:134.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('232d2f44-f938-54c0-b580-042c9624147f','','','Flore du Congo Belge et du Ruanda-Urundi 6:96.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e337e10f-9761-54c6-8dab-9cc3a9ddb32d','','','Linnaea 26:359.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6b5a9e2-ce4c-57d4-ab16-22a4459fcfc3','','','Bull. Soc. Bot. France 39:287.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9c8941b-4750-50a8-915a-95113b3e8beb','','','Bot. Mag. 18: t. 678.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d677fad-a420-5ece-a5af-2270736032ba','','','Syst. veg. ed. 14:443.  1784','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61d60521-7cfa-52d7-b9e5-f9a6e9ef14d3','','','Kew Bull. 24:419.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eedc54ba-0a0e-5292-84ce-d6216395892b','','','Nova Acta Acad. Caes. Leop.-Carol. German. Nat. Cur. 77:120.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e02126d5-c966-54fc-93e0-f0032b32a2c8','','','Bull. S. Calif. Acad. Sci. 33:109.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38b4d5ed-136e-53f9-a5fc-f0e98908e25c','','','Char. gen. pl. 76, t. 38.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8944f001-ee89-524d-83bf-e2f5420cd067','','','Trans. Linn. Soc. London 17:73.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7463b6f-a35e-58ec-a8a7-7f7906addd98','','','Rep. (Annual) Missouri Bot. Gard. 4:76.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f159fb03-7bde-5abb-bfc3-4213ea30f2b1','','','Syn. fl. germ. helv. 812.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22a75474-1a42-5fa4-aaa0-64ff016d0769','','','Not. pl. asiat. 4:287, t. 423, fig. 1.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8c36c92-e057-52a9-9ad3-538107ba82e7','','','Fl. Kavkaza 4:69.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3354fc41-d84b-5cc6-8e55-90a4ce711c08','','','I. Urban, Symb. antill. 3:485.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f40e3d1a-e4a5-5e3f-84a6-293e3a441175','','','Agric. Colon. 10:465.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d82d9c20-b05a-56b1-a2ae-545235eb0642','','','Sp. pl. 2:942.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0edc6624-acf7-548d-bf9f-609510048a3b','','','T. L. Mitchell, J. exped. trop. Australia 397.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e170dc49-dddc-5747-ad95-161c11c50076','','','Fl. Visakhapatnam Distr. 2:266.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afe3302d-9116-5f83-9160-11e4913e9c1a','','','Contr. New South Wales Natl. Herb. 4:288.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15695261-e537-5ffc-b5d2-a46c163e03ad','','','PhytoKeys 167:70.  2020','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa342b34-a22c-5700-b59c-655b85e17d82','','','Monatsschr. Kakteenk. 13:117.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('498c8b82-80e7-59bf-bbeb-61742c66ef51','','','Bull. Torrey Bot. Club 13:27.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('026d1452-4aea-5493-a437-223a3a30d565','','','Encycl. 1:128.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25a8edcc-3ee1-5bbe-aeb5-a40af655db10','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:141.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed1026df-5af7-560b-bbc8-78d2165609f3','','','Willdenowia 36:195.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('455ee25d-984d-5546-8a64-09a80130b467','','','Revis. gen. pl. 2:544.  1891 "<I>Uretia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bedd9da2-2b40-5322-8ab5-e1cefeb8c39d','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 6:356.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04ce37f2-55f3-58eb-b59f-e24962c6f839','','','Bull. Misc. Inform. Kew 1897:264.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8456ac1c-3601-5f54-8ede-dd355eb0415c','','','Bull. Misc. Inform. Kew 1906:74.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('062405ac-0356-5727-b864-f85de9781a2f','','','Fl. Ned. Ind. 1(1):26.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6b1fc4a-c49f-5440-babb-8b3d5c60bad0','','','Deut. Dendrol. 293.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3be4a406-9e0d-57cb-b0ca-23724bdf1053','','','Mant. pl. 2:204.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df5aa8c5-b774-5094-b3fc-96d25666055a','','','Icon. pl. formos. 5:141.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80752a44-480a-5aec-9271-2252922ce9a1','','','Sida 17:551.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4145cb89-eabc-56ea-8929-e4f930eeace8','','','Malayan Misc. 2(7):48.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffd2596a-6123-50ab-adad-fa0663230219','','','Prodr. 1:535.  1824, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7823ed27-17c1-586e-bd70-1da90743b99d','','','Isis (Oken) 1818:34; Gen Nicot. hist. 28.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f11de0a-7e6f-5d69-be83-2fb6c8b6d13f','','','Sp. pl. ed. 2, 1:427.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f069f056-98eb-542e-aa3a-41e671da8b37','','','J. Nat. Hist. Sci. Soc. Western Australia 3:175.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a2eb0be-77cd-5c29-8d6c-5e8217ec4015','','','Ill. sp. Acon. gen. t. 53.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7714a26f-ac31-5653-ae64-3cc8253eb75f','','','Prodr. 5:233.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c65a07dc-13de-50a0-b612-5cd53edaa6cf','','','Erythea 6:69.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afd429a5-c8fd-5c9b-8411-5dce3f65a108','','','Bot. Mag. 120: t. 7333.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fee3e7f-166a-5d16-874f-aa21832ecf5b','','','Sun. pl. succ. 89.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f188995d-4cae-5e2c-9cd3-17828eb639ea','','','Nov. stirp. pug. 6:13.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc0cbd53-cd7a-53b5-a0c5-cea540a08f65','','','Bot. Gaz. 27:437.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b52a7790-3965-52d5-8039-46d775a567b6','','','Contr. U.S. Natl. Herb. 25:537.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('093e6199-bd9e-5aa0-bdf3-dae1ef2dab56','','','Nordic J. Bot. 16:271.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebaa502a-c7de-5244-80f3-7e1296e4867f','','','J. Linn. Soc., Bot. 20:214.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('764d5a3e-9861-5bb5-b21e-76a6e0f08174','','','Pl. delavay. 1:206.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ce2f160-850d-54af-9287-459f2aec2ff8','','','Fl. portug. 2:428.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c18d285b-a230-5026-8ee4-f19163784d16','','','Meded. Lands Plantentuin 19:522.  1898 (non Hemsl. 1895)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7625ee22-e2f5-5309-ae8b-277020b933fd','','','W. H. Brewer et al., Bot. California 1:167.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe4eafa6-c02c-565a-a169-cc618505e301','','','Mem. Wern. Nat. Hist. Soc. 4:305.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5523b914-510b-5a75-9d8a-c34f68c04c25','','','Syn. fl. N. Amer. ed. 2, 2(1):443.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5e50eee-5c35-55f6-9368-0be8cc4a9e2d','','','Brittonia 50:343.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c753d1d-39bb-52e4-a258-44d965918d54','','','Ann. Roy. Bot. Gard. (Calcutta) 3:306.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14852b6a-9f2b-5862-a4b3-09b2627e3422','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 2:290.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('179d300a-0038-5938-9838-e93cf70f2fe5','','','Rep. Exped. Bellenden-Ker 70.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('431db834-b6af-5376-80ca-02ea7bc273dc','','','J. Proc. Roy. Soc. New South Wales 52:489.  1919 ("1918")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09e0b0e6-3dfb-591c-ad3e-a0b0e6ee3908','','','Révis. gramin. 1:367, t. 97.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f765c6d-1557-5b3d-949f-f3d9ce6c76c4','','','A. L. P. P. de Candolle, 15(2):108.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51dac132-4ad4-5e16-a571-31b1a231600d','','','Nov. Holl. pl. t. 7.  1804; 1:10.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3136b178-f0e0-5eca-bc77-fea4f2580e36','','','Succulentes ser. 4, 22(3):7.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('121059d3-b121-5bb3-bdde-3b8a63697d22','','','Phytologia 88:77.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18642001-b18f-5e68-bb3f-b9cf438a0159','','','Repert. Spec. Nov. Regni Veg. 16:78.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a2abd32-fad1-50ce-a176-2fcb032b7497','','','Pittonia 3:176.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c5d94c3-7f11-5342-b3bf-83be673616e8','','','Bijdr. 184.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52e6bf65-e0ea-52e1-97d3-0653158cfeb5','','','Symb. bot. 2:33.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f2df032-3e66-5213-8a82-40d8c5b3c5f2','','','A. L. P. P. de Candolle, Prodr. 9:380.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd9336c3-8c3c-5718-bc43-679cc6b5903d','','','Agric. Univ. Wageningen Pap. 97-2:71.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22882ef5-519e-5539-8d0f-6077b5307482','','','New Zealand J. Bot. 30:233.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9330d2c7-4cba-5159-bbcb-6cb0f443db59','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 11:89.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a47271fb-5bb9-55a3-be06-f69f8f332429','','','S. Watson et al., Botany [fortieth parallel] 70.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78d4c136-c160-5797-876b-b48493ecfa42','','','Bijdr. 529.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce5f9805-57f2-5add-a9c2-faacfa122785','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:87[folio]; 6:110[quarto].  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28f25c34-0085-5b73-a4a9-733cb1edcf43','','','Enum. pl. Jap. 2:283.  1878 "<I>hederaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad27a8fb-249d-56d6-bee1-0821c3fbffb7','','','Révis. gramin. 1:154.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf76da2d-1bbe-58d3-9acf-1569103900ec','','','Studies in the Calenduleae I. 244.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73b0f565-ff93-5d0e-807b-9abdf24584e8','','','Willdenowia 19:291.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cb401f9-6e40-52db-8d73-fc0f4993722a','','','Mem. New York Bot. Gard. 35:884.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bbede98-3293-5d50-ac69-aac4a5387551','','','Prodr. 4:631.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb2e3f83-b6d5-50b9-a1f9-9598eaf6cd5b','','','Linnaea 7:712.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b1d9da7-25d9-5fbc-9ff0-26d59a93fb95','','','Gram. panic. 193.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8011330-0066-5ad9-a63f-d9c224bfcc1d','','','Gard. Chron. ser. 3, 82:327.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a666c7a5-5e5b-5dc4-b3f8-af9101f79d4f','','','Ann. Sci. Nat., Bot. sér. 4, 18:320.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58027f10-6a04-5062-b4e7-af5c8b867ed5','','','Cinnam. disp. 35, 57, t. 4.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57314fa1-9b90-5576-8b2b-b498ae035442','','','Gentes Herbarum 2:224.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1910de65-2b67-54e0-b542-db753029a045','','','Sida 21:1637.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aea6d95-df8b-54ab-ad95-b7e0aa3cbd48','','','Fl. bor.-amer. 1:61.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fa2e519-25f4-5b6d-b7a3-c5b330eb7a06','','','Anat. Charakt. Dalberg. 40.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40d19891-9caf-51f2-a0de-14a60c58a8a8','','','Bull. Misc. Inform. Kew 1913:354.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('324e4bdb-9fa0-551e-9c8c-2fa5dc9f8b5a','','','Allg. Bot. Z. Syst. 12:178.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7eebbcc-e017-5e23-a895-17e0041febe0','','','Bull. Torrey Bot. Club 36:602.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1a0a9f9-d196-59ec-a4dc-f3c19a1d21b6','','','Diagn. pl. orient. ser. 1, 11:47.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eba8eadb-2022-5aea-b3be-4cb06181191c','','','Verh. Batav. Benootsch. Kunsten 11:164.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e851b777-df74-534b-ad01-d4b6c5a1319e','','','Acta Phytotax. Geobot. 5:53.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47c235c0-f852-5c75-8bcc-859edb1f11c2','','','Edwards''s Bot. Reg. 29: sub t. 49.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7b0884b-38ae-5a7c-9131-7db8a976f5a9','','','J. Proc. Linn. Soc., Bot. 7:28.  1863 ("1864")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40f9cef4-0d54-56b0-8a05-e8079a648a10','','','Notes Roy. Bot. Gard. Edinburgh 45:440.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26f522f9-bb45-544a-a8a1-63a0e1dc8751','','','V. L. Komarov, Fl. URSS 16:552.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38d66395-4113-5d5f-bae8-cf69615fa939','','','Čas. Nár. Mus., Odd. Přír. 140:129.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f452a8c0-d9f0-5957-9167-98fa564a0f95','','','Molec. Phylogen. Evol. 37:42.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b508034c-7b6b-567a-bbaf-197d19237c9f','','','Nov. gen. pl. 5:96.  1784','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83ec9f9e-ebba-58fd-944f-dd11e5ecf48d','','','Mem. Wern. Nat. Hist. Soc. 5:310.  1826 (W. Roxburgh, Hort. bengal. 68.  1814, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be9240db-14bb-53a2-b1c4-d950ff98c5ff','','','C. F. P. von Martius, Fl. bras. 11(1):78.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9770c55b-79f7-53fa-9e8c-0f07a2f5a05b','','','Repert. bot. syst. 2:767.  1843 "<I>Jonidium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d4f9a93-30a2-52bc-a2a2-f5cef3aceecb','','','Arbust. amer. 111.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63e6a44d-04b5-54ea-88f2-2bacf3e419ff','','','Torreya 34:116.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01410bdb-4e6a-55e0-8c19-e0fe2037de7b','','','B. Seemann, Fl. vit. 372, adnot.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1085bab-6356-58b2-891d-8cde5854b3fb','','','Mém. Acad. Roy. Sci. Lyon, Sect. Sci. sér. 2, 1:353.  1851 (Pugillus plantarum novarum 142.  1852)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6580baf4-e364-5d40-bf48-78abda82cbea','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:3[folio]; 2:3[quarto].  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d172624-47c0-5db6-85a1-ce4b79928d84','','','Sp. pl. 2(1):487.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33805bf5-3e32-50e2-bb6d-8e31190a7edc','','','Trans. New York Acad. Sci. 14:37.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('470b0df7-ad24-5f8f-a028-3523de00c4b2','','','Verh. Bot. Vereins Prov. Brandenburg 48:170.  1907 (Bot. Jahrb. Syst. 37:346.  1906, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b278472e-12a8-525e-b4de-4afb977eb1f1','','','Zap. Kievsk. Obshch. Estestvoisp. 11(2):7.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bf69f2a-9500-57ae-90f7-dc60f3c262a5','','','F. W. H. A. von Humboldt & A. J. A. Bonpland, Monogr. Melast. 2:38, t. 15.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da706e3e-9caf-5415-bedf-f255dfb1da63','','','Fragm. 5:180.  1866 "<I>benthami</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e61b4c0-0d7c-5746-9a0f-3889da5b49f5','','','Fl. Algérie 1(2):232.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f089d6b3-a115-5893-805d-ae39b1cddc90','','','Syst. nat. 2:577.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6f9e029-59ba-58ec-8353-68c38fc9dd7a','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:65[folio]; 5:83[quarto].  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d65059fb-442a-5ba3-8a06-732dda9f252c','','','Pacif. Railr. Rep. 4(5,1):98.  1857 ("1856")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a92dbeea-ce63-56a4-a728-bcae99010807','','','A. Aubréville & Tardieu-Blot, Flore du Cambodge du Laos et du Viêtnam 7:32.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51b7c4c0-416f-54d9-becf-efe0212d6cdf','','','Consp. regn. veg. 192.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6a14115-56d2-5cdc-a16d-2d534c8de42e','','','Pittonia 4:13.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1760c2c8-43ac-583d-a4f7-596cc7f8a65a','','','Ann. Inst. Bot.-Géol. Colon. Marseille 1(2):2.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bd2a326-30c3-5ed6-9ed9-59be2ffeb50c','','','Seznam 80.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0850bd69-388c-5316-8c5c-9eb674f1daa2','','','J. Arnold Arbor. 19:348.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1aef95ab-d92a-56c1-a121-5fed1422f4d1','','','Gard. dict. ed. 8: <I>Melastoma</I> no. 10.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('daac1d80-3010-5e5c-8147-68fd32595b3e','','','Choix pl. t. 35.  1807 (Gen. pl. 329.  1789, nom. inval.) "<I>virusana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f35248fc-a002-51f5-97b2-79629bd9c573','','','Mant. pl. 2:313.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('690d709a-b890-544d-bdea-53f34221421f','','','Gen. pl. ed. 6:578.  1764','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10800f12-d855-5a0f-a6f4-4bd6a60e12f7','','','Linnaea 13:268.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa5f7f9b-0b0f-5fb8-9c84-1b25ce9be452','','','Sp. pl. 2:936.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b377b92-1d8d-5f2c-b79e-3e01a30d0746','','','Rhodora 34:25.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d59d02e5-62ac-56bd-a019-2aa30ce96008','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:259[folio]; 2:322[quarto]; t. 160.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5450f18-e370-572b-884f-59528d24e2c7','','','Mem. Real Acad. Ci. Exact. Madrid 5:233.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d0f3286-71bc-5217-b830-4df3ef369764','','','Pl. asiat. rar. 3:67, t. 289.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f9109dd-0f5b-5625-b530-486167a32779','','','J. Elisha Mitchell Sci. Soc. 16:73.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0087b7ce-9b65-5924-914f-8b566a83c8ad','','','Fl. bor.-amer. 2:24.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a496c4e7-bdd0-571d-852b-952b3bb24a78','','','Notizbl. Bot. Gart. Berlin-Dahlem 10:872.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f64aa48b-477c-597f-8931-fcd1c9456bf4','','','Kew Bull. 19:291.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06e6a5d0-9fc7-54f8-a25a-3cc25bec9b7c','','','J. Straits Branch Roy. Asiat. Soc. 46:252.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e35292f9-6623-5e14-9767-674265b3ee51','','','Contr. U.S. Natl. Herb. 22:679.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efd81e22-5d6f-531a-83c4-e24bc55d9b2c','','','Bull. Misc. Inform. Kew 1906:160.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57f27a61-0928-5704-a190-157dff5a1321','','','Pacific Sci. 13:163.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cff0b15c-8c0b-5bb9-9fb2-a38de4ebb012','','','Bull. Torrey Bot. Club 39:310.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21314137-519a-55c7-829d-9a39a8a98443','','','Univ. Calif. Publ. Bot. 3:388.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('433bdaf0-a936-5168-a789-87cb5f58acdb','','','Char. gen. pl. 92.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cebcc47a-53b9-5b50-9024-b01b7b4de252','','','Prodr. 4:225.  1830 (N. Wallich, Numer. List 17, no. 558.  1829, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a1deed1-dfd7-5e27-9eb1-b82b8b9a43b8','','','Bot. Mag. 53: t. 2698.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df99d97e-52b0-533d-80bf-1d5bf40ff279','','','Bull. Cl. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 15:219.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e555434f-282f-5d8e-86b3-0257f69f09ca','','','Hortus kew. ed. 2, 2:202.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9738c855-2736-534e-8592-af3891e9b659','','','Prodr. 355.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7304c20e-a002-5f7a-bac5-b73380e79d7f','','','Proc. Amer. Acad. Arts 18:192.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81e1a51a-b4f2-5d1a-959f-f49de1f8d58a','','','Opredelit. Rast. Kavkaza 205.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fd3c97a-cc29-50b4-9764-7470a00f3520','','','Revis. gen. pl. 2:506.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd91c4b2-cf16-5554-bf79-ebac35708325','','','A. A. Bullock, Bull. Misc. Inform. Kew 1933:105.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1a19e48-14fd-5b33-b0fb-fbb3c9850b74','','','Willdenowia 19:42.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1286b470-ec5d-5e89-b635-07e1dfc00dbd','','','Fl. bor.-amer. 2:99.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c0f0a5b-f3f6-5f09-b23b-a9879d1a5e48','','','Cat. pl. horti monsp. 124.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a52bccfe-b97a-59b3-9921-72e0bae03a76','','','Biblioth. Bot. 17(Heft 72):207.  1911 (Sp. rub. 207)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d05b7816-a105-5b6a-a3b7-480c55e2d4e1','','','Fl. orient. 3:367.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf233ebc-586b-5535-b00c-f6509ae4c6f8','','','Gen. hist. 3:845.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('924773da-d4a1-5740-9958-18680b0f207c','','','L. I. Duperrey, Voy. monde 2(Phanérogamie):70.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a84de0e-30d3-5a5b-9fec-472e657d11bf','','','Trans. Linn. Soc. London, Bot. 3:383.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72dd4917-4fb9-5c12-a88d-acdd1f40f294','','','Icon. descr. gram. austriac. 2:18.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1906ad79-f106-5ba0-accc-f6d129bb294e','','','Iconograph of Japanese Citrus fruits (Nippon Kankitsu Zufu) 1:246.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16ed8369-5fcf-5d19-997b-a81e7dde45e3','','','Bol. Soc. Brot. sér. 2, 41:292.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1268dc37-1d40-5ee4-b8ce-07e88ca55b92','','','Fl. n. middle United States 310.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee217aac-1f5e-5fb0-812d-a16ea7fa51ce','','','Gard. Chron. ser. 2, 15:626.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5f20e25-7291-53ba-86d1-f31598b02073','','','Fl. Rocky Mts. 770, 1066.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9af0db8a-56c2-59db-9e4d-63c2ea2cb993','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:167[folio]; 1:207[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef7a0d17-0062-51df-b506-a6316b1d2ac4','','','Icon. 3:29, t. 257.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0bd61db-be48-5577-bbe1-29d1f936f462','','','Eclog. Amer. 2:55.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbe8dd04-7a0b-571c-bf68-cf290ffdc9bb','','','London J. Bot. 1:373.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('840c8b35-5c60-55c5-96b2-7d3cc00bd303','','','Bull. Herb. Boissier 4:816.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e3269b1-0b89-5fca-a178-42a181c4f27e','','','Contr. New South Wales Natl. Herb. 1:316.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97400b92-f85d-55ee-85e3-27d374bbd545','','','Fl. Ned. Ind., Eerste bijv. 421.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3859646-6f19-5416-9c44-f26191e9f8c5','','','Icon. pl. rar. 2: t. 329.  1788 ("1786-1793"); Collectanea 2:286.  1789 ("1788") "<I>lanceaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7545a734-b306-50d5-89b3-1b96cf69eb27','','','Linnaea 11:393.  1837 Jun-Jul','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0aa89746-0987-52ce-9149-758bbfed64f3','','','Kew Bull. 1950:294.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('917b19b7-4ee5-5e79-bf66-b8c321762a45','','','W. J. Hooker & J. G. Baker, Syn. fil. 273.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0274280-d881-529e-ba82-6a7a1eb9c5b0','','','Anales Soc. Ci. Argent. 99:97.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52e2830f-0ad8-58df-9f10-c2f5dc6a15a0','','','Revis. gen. pl. 1:46.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4623a024-2822-5d4a-8e56-f2a0a28c9037','','','Svensk Bot. Tidskr. 37:169.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39c55c07-ffc6-50b0-959f-47d456a80fa0','','','Proc. Amer. Acad. Arts 42:547.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d87cc186-1ff5-5aab-a028-9f1495d9458f','','','Rumphia 1:149.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2fe767f-7eaa-5260-971d-5e6d5a750527','','','Cat. afr. pl. 1:767.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6344ca02-11d5-53ec-98d4-8b02a5a2f00e','','','Prodr. pl. cap. 62.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f5b0c33-e406-556a-99fa-f8a64de96470','','','Enum. pl. afric. austral. 371.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afcdb215-7c8c-5b6d-a845-4e9ed6512a6d','','','Phytotaxa 161:67.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22b1e4f0-eb2d-5987-8e54-ce30fcba2c0c','','','Flora 25(2, Beibl.):77.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('beb377aa-9909-5c56-85a0-8f3676da7f78','','','Fl. Hawaiian Isl. 75.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db092494-1462-5830-abf4-9483d27185e7','','','J. Linn. Soc., Bot. 4(Suppl.):100.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d02265a9-2ecc-5a91-90d6-f5ea89622e1d','','','Voy. Bonite, Bot. (Atlas) 3: t. 47.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc356d11-e1bf-5899-a454-0743d8a7c74d','','','J. Linn. Soc., Bot. 45:110.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92f312e7-80de-599d-ae41-1aa1c4579270','','','Fl. Cambodge, Laos & Vietnam 3:64.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d329e2e-ac45-5e00-b0a9-2b4ada294d72','','','Bull. Jard. Bot. Buitenzorg sér. 3, 8:315.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18e3647e-e1ac-5398-ab62-eebe00ba9d84','','','D. W. Stev. et al., Brittonia 38:17.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea35afb0-24c6-5aa0-8503-4a670e53bfa9','','','Bull. Misc. Inform. Kew 1928:139.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f127075-0d2e-5d33-817f-b5a879d99bec','','','Crotalaria in Africa and Madagascar 375.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70c11d57-f140-5ef8-a400-4478de4fe3a9','','','Cact. Succ. J. (Los Angeles) 63:246.  1991 "<I>herman-schwartzii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7ddb4ab-d816-5495-aa97-9b774464194a','','','Smithsonian Misc. Collect. 50:518.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('547bec95-b54d-509b-a932-711490baf4e5','','','Flora 28:312.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d099a174-4242-531d-86b1-73e82f765488','','','Milwaukee Public Mus. Publ. Bot. 3:199.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f71eb650-ad3e-5af2-9470-128d5cdf1112','','','Pittiera 17:312.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1ab64dd-9a5a-5368-b95e-b4603582b6af','','','Rec. Albany Mus. 1:51.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a730d5f4-a9c2-511d-b58f-129343ebb301','','','J. S. African Bot. 36:251.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a634ffba-fa25-5e49-a125-63925f2bd816','','','Sp. pl. 2:1024.  1753 "<I>asplenifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa25e1c1-f67a-58ed-bce7-bac6571c43c1','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1852:8.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5613b86-96fc-52c5-95fb-a518157a67c8','','','Fl. carniol. 572.  1760','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65ccefe4-fdc1-59a9-ac3d-ee253ea4788b','','','Fl. austral. 6:171.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdae4482-9a11-5c3c-a504-910ff63c309d','','','Bull. Int. Acad. Sci. Cracovie, Cl. Sci. Math. 1910:72.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0337828-f9fc-5fda-b6e1-52ac4f176ad0','','','Ess. Agrostogr. 75, Atlas 11, t. 15, fig. 7.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78748341-e22a-5828-8c6f-69be9924fb35','','','Cat. pl. Pyrenees 102.  1826 (non All. 1785)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82fabdc7-2b94-55bd-b3be-3759539bb102','','','Trop. Woods 31:10.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('670eb689-3f31-525d-8dd2-034c0aac882f','','','Gen. <I>Lavandula</I> 363, 390.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c81ca72c-905a-5c0e-bb20-baa6af1e8baa','','','Kew Bull. 47:729.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b87bd51-f87d-5190-9782-987cb3325057','','','D. Oliver, Fl. trop. Afr. 3:459.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7857456c-550b-5563-a808-4a794eb45f83','','','Sp. pl. 2:1003.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22b79202-6e0f-5f92-9ddf-696e261ca3a0','','','Bot. Mag. 90: t. 5422.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f72c09e-287c-5717-85e4-458b54f1ec49','','','Stud. fl. New Zealand 219.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17c68ef3-ba8b-58a4-98cc-1dd8418cf1e9','','','Addisonia 2:55.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('319d3714-f2ff-57e1-887a-dcc0e9bd1996','','','Icon. aroid. t. 39.  1857-1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acbdb21d-4ac7-5534-ab73-e147df3c5586','','','Bull. Torrey Bot. Club 61:446.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ec7a540-5433-5c90-8386-c92565fc84b7','','','Pacif. Rail. Rep. 5:360.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe9b565d-b3d4-5438-9c38-713d42b2e32d','','','Anales Soc. Ci. Argent. 99:142.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10331804-89e2-5869-a4ab-c6b9e1d93e81','','','J. R. Perkins et al., Fragm. fl. Philipp. 48.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('891a4c7c-3e49-59d3-9f9c-1fe423d33260','','','F. Cuvier, Dict. sci. nat. 12:68.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('971fd1de-06d7-5f8f-a13a-a92f9cd0113a','','','Fl. bor.-amer. 1:162.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d11d3696-dd16-5115-ac6d-47077d468612','','','Mém. Inst. Sci. Madagascar, Sér. B, Biol. Vég. 5:170.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e70a27a3-5ff7-5879-a2e1-48eddc563288','','','Ann. Missouri Bot. Gard. 95:649.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10e2d5d7-1cab-50e2-bc4b-9680c9390f1a','','','Wiss. Ergebn. Deut. Zentr.-Afr. Exped. (1907-1908), Bot. 2:66.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dff65112-e004-5596-b8d2-ed158e920353','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 8:665, t. 20.  late 1884-1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e07e69fa-9d6b-5791-9ed4-04624e2c0ea6','','','Boll. Soc. Bot. Ital. 1923:115.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c70ff611-3a1d-530b-8c81-e1eb7a0333e9','','','Acta Horti Gothob. 1:253.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3a11e6d-e667-5610-9883-7235dc8062c7','','','Arq. Inst. Biol. Veg. 2:37.  1935 "<I>Pithecolobium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4781c26c-a723-5398-baaa-224e1d5467d7','','','Contr. U.S. Natl. Herb. 16:269, t. 89.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83f1f89f-2f1c-5a94-ba8e-4dc47bf53b3d','','','Fl. Neotrop. Monogr. 71:24.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6dbaf94-db30-56c8-acb9-6c489bff4895','','','Mitt. Bot. Staatssamml. München 30:462.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a770591e-90d2-5095-9f78-02e5901f822a','','','Cact. Phantast. 1:4.  2018','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14a86949-6f0e-5197-8c40-a3a6c6bb1ee8','','','Trans. & Proc. New Zealand Inst. 12:394.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94d79e29-0229-5eb4-b6bc-ca641b46f289','','','Brev. pl. nov. 1:52.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f47b906f-9cff-590f-8f54-420f863fcc32','','','Gard. Chron. ser. 3, 83:343, fig. 165.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c0329a5-00f9-566f-9f6d-6f106cac075e','','','Pinaceae 84.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e45962b-fd49-51bf-b17a-b74190182f75','','','Austrobaileya 2:348.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad7f3cd1-8f3c-59ec-9eea-a7f7c09eeb90','','','Fl. Brit. India 2:25.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50ab6554-74b2-579b-aafb-375fe1181b90','','','Bull. Herb. Boissier sér. 2, 3:818.  1903 (emend. Repert. Spec. Nov. Regni Veg. 42:19.  1937)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04b180a5-b8bf-5271-ba4e-44c34c6e092b','','','Proc. Roy. Soc. Queensland 60:59.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5348722b-27ae-561a-b446-01915e98fe60','','','Gentes Herbarum 8:304.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8db8f2cf-104d-5179-a1ed-7e4c3260dbf3','','','Revis. gen. pl. 3(3):365.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e738a9a-6103-560a-b0ef-e31430834140','','','Wald. Nordamer. 487.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b01f6f5d-3353-548f-bfa1-5591ab8aed87','','','Fl. carol. 213.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b82d36fe-de9a-5da7-bb1b-d623c68a42ea','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 9:22.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('145273b4-f205-5690-9b28-cb5c3bc17b7f','','','Prodr. 2:227.  1825 (non Lam. 1789)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d8b68ec-66c5-5db0-a527-e96fc6accdca','','','W. T. Thiselton-Dyer, Fl. cap. 7:599.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('435efbb4-1262-5fa5-8814-4a4f979b1d8d','','','Fl. angl. 110.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('097c2889-1b21-52b1-b08f-5adb1840b380','','','Proc. Linn. Soc. New South Wales 37:568.  1913 ("1912")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64000f6a-281e-565a-8355-9cadd804def6','','','Smithsonian Misc. Collect. 69(12):3.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c8f39e9-b4e2-525b-9ed3-d4ddd9488169','','','Man. s.e. fl. 1815.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7067093f-c4b9-5809-ae1b-6c6a8d2eca54','','','Madroño 3:12.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b239523-8330-5974-975a-cf0243d9e32f','','','H. G. A. Engler, Pflanzenr. IV. 250(Heft 27):38.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e840092-85ab-5953-b2ff-553fdd0a7c03','','','Acta Univ. Lund., 2, 39:465.  1943 (Fl. Alaska & Yukon 3:465.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0360de77-6e1c-5077-b040-9d3f8a77cae9','','','K. H. Rechinger, Fl. iranica 112:32.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97c68678-1dd0-50d7-b7a9-486267e5b088','','','Syn. pl. glumac. 1:67.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e4d551a-b290-5104-beef-f24d5cd75e60','','','Cact. Succ. J. (Los Angeles) 51:123.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51b146de-4e79-518b-a088-f9d8be98130e','','','Gard. Bull. Straits Settlem. ser. 3, 7:184.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6aa024e-ce0f-58b7-b5ca-76a42f5eede3','','','Contr. U.S. Natl. Herb. 5:135.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d61f2e6f-c05b-5bc0-8fc7-d1ed68185f4e','','','Phytologia 80:348.  1997 ("1996")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8888e786-3fe1-5797-a47c-3ca2768f2927','','','A. L. P. P. de Candolle, Prodr. 11:33.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9c3394e-4ef5-5377-96c3-530b8405a459','','','Canad. J. Bot. 56:2092.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8a76300-8e23-56f2-b838-31c15b33189b','','','Prael. ord. nat. pl. 199, 226.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0254b18-4151-5d25-9967-03d9a3ffda93','','','Reinwardtia 5:214.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ac75a07-32e9-510a-b67b-956d02e803f1','','','Bull. Mus. Natl. Hist. Nat. 30:108.  1924 (non Raddi 1823)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86d9ae50-c7e4-547e-ac97-82d78ef5a970','','','EPAMIG.  O genero Stylosanthes Sw. no Brasil 46.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3245ac34-9d39-5771-86b4-84d19faf6f2f','','','Fam. nat. syn. monogr. 3:90.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0381fb6b-2c46-5347-95ae-b34a7092695b','','','Gard. Chron. 1868:814; Bot. Mag. 94: t. 5739.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28f8ec3c-f021-549b-b728-f1c91f8e4513','','','Contr. U.S. Natl. Herb. 20:14.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a386631-e579-5861-bac5-16c2c627e81a','','','Candollea 9:389.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56dccbc4-9aed-55d2-aeff-2335522a1f39','','','J. Hort. Cottage Gard. n.s. 6:111.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa428a51-f3cf-5d6f-9f1c-157c0621334b','','','Erythea 7:60.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdf5a9bf-0c56-50bb-a8e8-c648dacfa1b3','','','Monogr. Campan. 340.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1deceae0-8263-5267-881d-b4c8cbe6f4a1','','','Bull. Soc. Hist. Nat. Afrique N. 16:93.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93c2e7e1-eeab-5964-9590-c0095c1dc35a','','','Bull. Misc. Inform. Kew 1894:22.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('929f02a5-5041-5f47-834b-68e7ceb061bc','','','Ann. Missouri Bot. Gard. 83:224.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('898750bf-53e3-5337-a8a7-2c8ea7d3ad3b','','','Bull. Misc. Inform. Kew 1915:210.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('987f492d-a1f6-5750-8ea8-9dc4f772f26f','','','J. D. Hooker, Fl. Brit. India 2:742.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c53bc01e-d854-5977-a68a-f73efbf6010b','','','Rev. Hort. (Paris) 87:434.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e44df2ab-c3a5-54ee-9cc5-9766d6719c05','','','Bothalia 2:277, 285.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e25fb47-fff7-5d7c-9431-26383f5d5fa9','','','Trudy Prikl. Bot. Prilož. 53:172.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4d7c241-05fd-5c66-aaba-5bba3fda0a4a','','','J. Bot. 33:329.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bc7bfcd-285f-5d97-bb5f-734dc6f0dc9e','','','Fl. portug. 1:253.  1811, t. 47.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d29ba4af-8955-52ac-9bf3-0bfec6d02a65','','','Icon. descr. pl. 11, t. 6.  1766','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db3bfcd8-7233-589b-8a1f-c41286fc63f7','','','Ann. Bolus Herb. 3:124.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b68cd8e-603b-502e-9926-d66382766ad7','','','Revisio critica Casuarinarum 70, t. 10.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa69e682-d74c-589f-bf9f-22cab3c2674f','','','Fl. Würtemberg 630.  1834 (Arcangeli, Comp. fl. ital. 626.  1882)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fc79e80-f663-5862-96ad-dd8b01173f20','','','Methodus 629.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e23f02b2-f38b-5465-a527-d56c4e34ad51','','','Eclog. amer. 2:11.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('078540d4-8e10-57c8-8e30-88c2355c25fc','','','Icon. pl. rar. 2:9, t. 306.  1795 ("1786-1793"); Collectanea 5:35.  1797 ("1796")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b66c8d59-5271-57cf-bfcd-922c983c5c81','','','Hooker''s J. Bot. Kew Gard. Misc. 5:228.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2e585e7-99a1-59ab-b06b-f72a91dbfd78','','','Fl. Hawaiian Isl. 386.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5db201f-02a1-591e-b0d4-00b61c9ceb98','','','Bijdr. 1101.  Oct 1826-Nov 1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c71217e-dbda-5925-9e21-609788487788','','','Symb. antill. 5:426.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('087a5a83-bcf1-506c-9bb6-b01fa878e0b8','','','Ill. observ. bot. 3.  1773','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c7e2dde-72c9-52b4-a9e5-52adfccae530','','','C. F. P. von Martius, Fl. bras. 6(4):116.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf514732-df5f-5d3e-87c8-c0a990d5cb50','','','Repert. Spec. Nov. Regni Veg. 21:216.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5aa32609-8976-5a52-938d-a57a035c1ce2','','','W. H. Brewer et al., Bot. California 1:540.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca5db567-aec6-5bf1-8bad-60a970249c40','','','Bot. Jahrb. Syst. 40:305.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75e6f1e5-cb3a-5dd0-a9e4-2468c02a1155','','','Edwards''s Bot. Reg. 15: sub t. 1273.  1829 (Hort. bengal. 20.  1814, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4688f3b-725a-5fc9-8996-3521282a4b42','','','Bull. Misc. Inform. Kew 1938:324.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1326984-2907-5016-b5b1-2f46c7f54b23','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(2):190.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d7ac957-3ac9-5213-a88d-35e54420365e','','','Pl. Coromandel 1:47, t. 67.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9f9ae7c-6d46-5c35-bda9-79df4aca132b','','','Mem. Mus. Natl. Hist. Nat. new ser., 27:220.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbdc6f10-e00d-5a86-bcff-f1534a31f8b7','','','Gard. Bull. Singapore 17:426.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a7abf6f-59dc-5ee4-b9f7-0a1fcbd917a7','','','Philipp. J. Sci., C 3:261.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d198883-3c48-5e93-9d80-e16494744896','','','Ewart & O. B. Davies, Fl. N. Territory 340.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d52cbc80-f13c-5aa9-b4a8-a075830c42f7','','','Arq. Bot. Estado São Paulo 1:116, t. 121.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ec65d50-e2d2-5f86-81f5-93b5ce3b7e8c','','','Monogr. Aquifol. 1:269.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab0570a4-57d4-5402-9421-cc8ae69df6be','','','Bull. S. Calif. Acad. Sci. 7:24.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('224be4d2-da5c-5f64-bde8-16a4f0ce41b0','','','Syn. pl. glumac. 1:256.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd475f3e-9afd-59c6-abe2-9dbc9b99f5c5','','','Caldasia 4:23, t. 5.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1373626e-9d9b-5f40-8d5b-116ba730773e','','','Bot. Mater. Gerb. Glavn. Bot. Sada R.S.F.S.R. 5:27.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c3f3581-e133-569e-970e-199dd5a05855','','','Flora 4:301.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37763dae-e308-5cca-a345-d52e156d4d01','','','Orchidaceae 5:176.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3625be9-be0c-564e-85bd-25d0b54ff333','','','Notes Roy. Bot. Gard. Edinburgh 13:238.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('311cce82-f8b6-50f2-a925-9a3c5ec5eb78','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 26:158.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68333029-9688-5c34-bf3f-4eda437267d8','','','Prodr. 6:444.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df6ebbf0-3cd5-5a01-93f2-0903212cde41','','','Man. fl. pl. Calif. 715.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0da9187-228b-5cb8-9ee1-888f330e33af','','','Sida 3:347.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e9aa942-4f28-5ba9-8973-5de12c6393f8','','','Züchter 20(1/2):15.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3828fa56-d273-54b6-9a95-3fdec2c909d9','','','C. Gay, Fl. chil. 6:174.  1854 "<I>Heleocharis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('218977c7-df26-5e7c-b327-1adcca91e843','','','Sp. pl. 1:383.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2d90b62-54d4-5823-ae8e-3210560c1972','','','Boston J. Nat. Hist. 5:246.  1845 (G. Engelmann et al., Pl. lindheim. 1:38.  1845)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ed1f3bc-13bc-5b33-adea-553eb9cf0638','','','J. Bot. Res. Inst. Texas 1:1015.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5aa75987-272a-53cd-9b78-74ef93f17cde','','','Tent. suppl. 11.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f8e3877-c0e8-5d15-b41a-f7829e13cb4f','','','Bull. Mus. Hist. Nat. (Paris) 9:173.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9382b04-9edf-5f33-b13c-c5f2d009f13a','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:174[folio].  1823; 6:220[quarto].  1824 "<I>nubigena</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('879b680f-91a8-547a-9ecc-0dc5e22b8d8d','','','Amer. Naturalist 7:301.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6114fb4-efa5-565e-a229-e4f156296a5e','','','Notul. Syst. (Paris) 2:124.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('009ad81e-75ed-595b-9f4b-60fd13c4dc68','','','Suppl. pl. 394.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9af68fe-865d-5ba4-bef2-cb2c0d88995f','','','Fl. bor.-amer. 1:195.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09357e4e-b02b-5f9c-9c26-1ce87ac5f427','','','Symb. bot. 1:1.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7a63dee-4e3d-5617-902a-0935e5a68618','','','Bull. Torrey Bot. Club 25:178.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f647a8f-9f92-52b5-a321-c319ab06c058','','','Ann. Bolus Herb. 3:9.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f048a0a-4dd3-57d4-a747-d2c47779e69d','','','Hist. nat. Iles Canaries 3(2,1):184.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d71eca70-a96a-5ecd-a00c-9473535aa10c','','','Hist. nat. palm. 2:137.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5725d61b-507c-578c-80dc-ac77c8b314a8','','','Gen. N. Amer. pl. 2:87.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a5f085f-fc9e-59b1-9622-aadcb728bfd1','','','J. F. Mota et al., Div. veg. yeseras Ibéricas 277.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c1a8fae-8008-58e6-8dab-44f622006f64','','','Bol. Mus. Paraense Hist. Nat. 4:543.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb51c8af-4586-560f-9109-2b7f9a214269','','','Mém. Soc. Linn. Paris 3:109.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ef4ea5d-b094-547c-b5c9-e75c7e22e013','','','J. Arnold Arbor. 5:8.  1924 "<I>evodiaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75657b2f-005b-5269-9791-976fdc77324c','','','Növényvéd. Közl. 6:154.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('940a2f00-323f-5d4f-b6e8-64c8f9b06da9','','','Methodus 409.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75e1510d-4705-5c6f-9f79-8cd529a6c0de','','','Fl. Neotrop. Monogr.13:236.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5a74360-8b81-535c-a2f1-8692fe7a4db1','','','Izv. Imp. S.-Peterburgsk. Bot. Sada 30:490.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('faaf7937-7ff9-59d9-95e8-303968033ca8','','','Sp. pl. 1:417.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cdebd93-f84e-5cb1-bdd4-7ea64f191683','','','Fl. atacam. 20; Viage al desierto de Atacama 194.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('078af160-bc9f-5e6f-a8df-361dad293923','','','Rhodora 41:441.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed8070db-c571-5ad0-a9a7-50aaee1a4495','','','Sarawak Mus. J. 59(80, spec. issue 6):71.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e71fa2f5-d1d3-52f1-ba84-0832000bac31','','','Phytologia 88:219.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('215e4cc2-76fd-5f70-b597-3f54d5846118','','','Bot. Mag. 89: t. 5358.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a50a776d-0ab8-519e-8de1-07649813c34f','','','Diversity Phylogeny Evol. Monocotyledons 73.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9f15394-3644-55f6-84c1-1980487ba36c','','','Fl. Halens. 175.  1761','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a32ac7f-14c6-53df-9afa-7312ee91657c','','','Linnaea 8:47.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa7ad4a9-d3de-5234-af6c-5a646ffb901f','','','Sp. pl. 1:65.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('373b1241-a879-50a9-8727-af0864b11356','','','Syst. veg. 3:127.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0914dda-521b-57d9-a42c-b5b764bf36dc','','','Dendrologie 1:593.  1869 "<I>illinoensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94246e0a-47f4-5c5e-9e5c-e14d220a21c8','','','Man. bot. San Francisco 93.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08d1af62-3363-5b0b-b40a-dc021b16b8bc','','','Brittonia 46:178.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab83630a-33a5-57b2-ad47-57aaed1c2f03','','','Acta Horti Bot. Prag. 1963:53.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38f099c9-b5a7-5617-bc1e-e951417ea755','','','Trans. Linn. Soc. London 10:66.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('594c9f14-2d68-53a1-aebb-39ab3a4be051','','','Malayan Misc. 2(7):50.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67ec535e-66c2-5541-b66e-de0bbf764342','','','Nova Guinea ser. 2, 6:280.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d24ad44-b8e2-5c29-86c0-b9442bb8f4e0','','','K. Koch & G. A. Fintelmann, Wochenschr. Gärtnerei Pflanzenk. 2:259.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f77d9163-cf3b-547d-8325-b81d12dd8b43','','','Diss. 10:453, t. 281.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('004d8f0d-a122-5733-abff-8eb4173e03d1','','','C. F. von Ledebour, Fl. ross 4:469.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e94aefb-617c-5bae-93b0-e631584394f3','','','London J. Bot. 3:219.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbc5372d-47d7-54dc-9fdc-29e0c95eee6a','','','Spisok Rast. Gerb. Fl. S.S.S.R. Bot. Inst. Vsesoyuzn. Akad. Nauk 18:15.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('562a0788-6d7c-52de-8b26-288372e43015','','','Repert. Spec. Nov. Regni Veg. Beih. 89(3):134.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('652c5d28-eded-5264-ae2f-17b91808a6c1','','','Enum. pl. Mongolia 81.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('577361f8-1393-57af-81a3-4fe25d8a315f','','','Fragm. syn. pl. 4.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d8fd5b6-5963-58c2-b062-1a0aa3a33a84','','','Bonplandia 8:286.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abaf7008-64e8-5409-920c-546ca825f61e','','','Esquisse Fl. Tristan d''Acugna 43.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcc8890e-4521-592b-9e3a-c232153f4dfd','','','Fl. Serres Jard. Eur. 3: t. 258.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6bb0d59-2423-5d48-bd9c-c46a33dcb4b6','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1858:47.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2967d2e0-449b-5fd9-ab90-9e5f59718a23','','','Bot. Reg. 12: t. 1009.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cf6148c-d188-5614-a5b3-f705ae3005cb','','','Notes Roy. Bot. Gard. Edinburgh 5:190.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf2ee8ff-956c-5e17-8dea-a2c8edd2d054','','','Sp. pl. 1(2):1267.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9f66404-4762-51f0-a399-c753ab42dac2','','','Gard. Bull. Straits Settlem. ser. 3, 8:30.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aec6428f-1d1a-585d-8bde-51638e44d267','','','Feddes Repert. 79:47.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c92c95c9-8896-5312-b606-39b8517ca7bb','','','Gard. dict. ed. 8: <I>Opuntia</I> no. 5.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c83dd7f-b012-5336-bc31-210f43bffa4e','','','Kongl. Gotheborgska Wetensk. Samhallets Handl., Wetensk.Afd. 2:32.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2898753-4aca-5e09-8dcb-bbb832d4f36a','','','Anales Jard. Bot. Madrid 40:68.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1eeb61a7-1ff2-5c8b-8ac4-d8837b21dfe9','','','Bull. Torrey Bot. Club 59:156.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da898a75-3be4-5e8f-9b33-b1e74603854a','','','Syst. Bot. 21:11.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3515b1d5-273c-59fc-b097-47d9dd56c8b8','','','J. Linn. Soc., Bot. 19:62.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aded145b-0bbb-5ec9-9407-492ba68332f7','','','Proc. Amer. Acad. Arts 11:115.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa86a3bc-5142-55f4-a8ab-0666060210ef','','','Species lupinorum 29:457.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec1df9bb-85c9-5480-9afb-3fb11aa0e37d','','','N. Wallich, Pl. asiat. rar. 3:98.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a1c91e5-a284-57a8-8ef3-022d50d5da3c','','','Prodr. 100.  1788 "<I>sessiliflorum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb1980f5-1507-5761-a60d-ec41515705f4','','','Linnaea 8:48.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e3b719a-30b1-5330-abe1-7cd84f095115','','','Bragantia 28:274.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8405fa6-0dce-5092-9b5c-fcce455b2ae9','','','Linnaea 17:252.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f78e9c5e-4098-591c-9a2d-af68bfbb14b6','','','J. Shanghai Sci. Inst. 3:123.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00c17a05-e3cc-5406-a5a9-76c1dcda2898','','','Chron. Bot. 16:425.  1954 (Gen. Nicotiana)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ab49e6a-ea40-5212-aa67-dfc3bc41a0bf','','','Trans. & Proc. New Zealand Inst. 13:339.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2b859b0-78e4-5054-891b-90a2e3eb2ab4','','','Amer. J. Bot. 27:66.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c45e5f2-b9f3-5762-a840-27e9aaa42819','','','J. A. Schultes & J. H. Schultes, Mant. 3:626.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83384dd1-e9d0-53b8-82ca-4a0914302b98','','','N. Amer. fl. 24:37.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5e5b058-bd8f-5256-9266-7c28028e5388','','','Symb. antill. 3:329.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8db69563-5b90-5bd8-ba1f-4806a97e49bb','','','Prodr. 409.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f829a03-c0b5-5fdb-95fe-58d04e51eaff','','','J. Arnold Arbor. 45:422.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15e9f4e0-0536-5af9-8a46-098d4da29336','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 6:355.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea8d3e78-3b6e-5aee-975d-e0398fbfe2e2','','','Hist. pl. Guiane 756, t. 303.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('084d9dd2-6152-5c4f-9395-ffd1c6de9565','','','Castanea 56:304.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('313d5648-09bc-5548-8f34-7cd812176d12','','','Sp. pl. ed. 2, 2:1664.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cac05ea-dd2c-531c-8b01-852c6bad910e','','','Philipp. J. Sci., C 5:33.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fc5d677-3c81-5b41-8088-9319043dc845','','','Contr. U.S. Natl. Herb. 1:61.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b53baea-515d-5a24-9b11-50447f81efcb','','','Bot. J. Linn. Soc. 111:269.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3306beda-8d04-5850-8487-733471655b55','','','Pittonia 2:80.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e2cc536-5d53-51ee-bed2-d9e8f467d616','','','Flora 25 (Beibl. 2):2.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ce6c433-344d-5817-9333-a0b354086aa2','','','Syn. pl. 1:524.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5525bb73-7c92-5a44-88aa-28d47782b90a','','','Revis. gen. pl. 2:704.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3544bf4c-5fd8-5348-b2b4-31f8a31c3d92','','','Repert. Spec. Nov. Regni Veg. 13:319.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58dfea90-363d-569b-aed8-c1d6783b407c','','','Austrobaileya 1:342.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21015811-7588-54ec-9a3f-c861d7c9ae01','','','Diagn. nouv. 191.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07c3b86b-741f-55a6-af7a-6b9a82ab6a27','','','Rar. pl. Sicilia 2:20.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a96d6e5c-3f34-5f69-83c8-5df6fc5a18b3','','','Fl. taur.-caucas. 1:81.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2cd9d01-a342-5242-a9f6-643576f17ffd','','','Ill. Hort. 16: t. 591.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fe72922-7f12-5a9f-be13-1d801a987cd6','','','Acta Phytotax. Geobot. 25:3.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a3ab275-7fd9-5469-aa45-0245805916f6','','','Notes Roy. Bot. Gard. Edinburgh 24:170.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efc11180-0377-5792-bb32-39b51f83549b','','','Index sem. hort. petrop. 2:42.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('496aa177-01d6-5132-9d3d-d4c103c63dfb','','','J. Sibthorp & J. E. Smith, Fl. Graec. prodr. 1:224.  1809 (non Moench 1802)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e77b3086-626a-56bf-96b3-1df3bade3421','','','Prodr. fl. Ind. orient. 301.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28c7b40e-484f-558b-b868-a3798d065fda','','','J. Arnold Arbor. 27:234.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09e80074-86ea-5552-ba22-53b9a645403c','','','Indian Forest Rec., Bot. 1:85.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abe71644-664f-544f-b8f7-50c560a673f6','','','C. F. P. von Martius, Fl. bras. 8(2):321.  1897 (H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3b):238.  1895, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fe7c601-4ef0-562a-8619-14771e5c6374','','','A. D. d''Orbigny, Voy. Amérique mér. 7(3). Palmiers 123.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b80c1632-e7fc-59cd-97a2-ac3209d88beb','','','PhytoKeys 205:133.  2022','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fd4de8f-93f7-54eb-8448-fd6a69210613','','','Trans. Philos. Inst. Victoria 3:25.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ec9fb08-a5b1-5e2a-9cc2-21e3e5f4e718','','','Ill. Handb. Laubholzk. 1:752.  1906 "<I>laxiflora</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7dd4658b-19d1-59aa-a175-5395bcdcb99a','','','Hist. nat. méd. Casses 125, t. 20.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5742201-933c-50e4-87b9-ce3846a9de41','','','Mem. Torrey Bot. Club 5:169.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fa63d13-611d-57f0-a7b4-e0a2b34cca38','','','Repert. Spec. Nov. Regni Veg. Beih. 27:252.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('954e1a68-27bf-5473-9349-31773dab557d','','','Fl. novo-galiciana 14:153.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98467dfa-a162-5e51-9b05-1ac862850b95','','','Gard. Bull. Straits Settlem. ser. 3, 5:133.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54547b97-dcef-5efb-9d56-9a7893a4a301','','','Ann. Bot. (Rome) 54:769.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d7a7a4b-b059-572b-9706-8f18ac83af85','','','Diagn. pl. orient. ser. 2, 5:71.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('733c59a1-c38f-57fe-ab7e-b2fca10d69e2','','','Trans. Linn. Soc. London 12:357, t. 15.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ada8c898-9244-5414-b907-916dbd86a001','','','London J. Bot. 1:504.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cdb8910-18eb-524e-b4eb-cf0a0ce1c0cb','','','K. M. Schumann & U. M. Hollrung, Fl. Kais. Wilh. Land 13.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01025aac-21e1-5b33-8cea-e467a9e48574','','','Phytologia 70:82.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e8aab3b-3207-57fc-b4d2-df7793f4c7b4','','','Ann. Lyceum Nat. Hist. New York 3:318.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eea5338d-24ac-5b51-ac8b-7512ea088d25','','','C. A. Meyer, Verz. Pfl. Casp. Meer. 24.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('213d8b0c-eb11-56cf-9e86-d4936c4d4cee','','','Fl. Amer. sept. 1:312.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a80db834-bebb-5feb-9d34-d80b1cda901b','','','J. A. Murray, Syst. veg. ed. 14:57.  1784 May-Jun (Fl. jap. 19, t. 3.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('509dc575-aee4-590a-ac39-ca2f22c78802','','','J. D. Hooker, Fl. Brit. India 2:446.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb4ab03a-f0e4-53fb-93cf-815cf250c13a','','','Ann. Gén. Sci. Phys. 7:295.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a610526d-afea-51aa-883d-0989a5f005b4','','','Hort. bogor. descr. 198.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9abf02b3-d9c9-5c98-9d83-b216616f31f4','','','J. Linn. Soc., Bot. 17:379, t. 16, fig. 6.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f4e684b-a609-5419-bc17-f44c5ad4ed05','','','Pittonia 4:167.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e70c690f-ecc1-55aa-9c63-35556690551e','','','Notul. Syst. (Paris) 3:25.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54f06d23-0505-5006-9337-9d745dcbd648','','','New crit. Mal. pl. 3:15.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb8de61f-2a7b-50bf-a9b2-20844f73f6b9','','','Bull. Sta. rech. forest. N. Afr. 1:118, t. 6, 7.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53fba975-ebd7-59bd-b09d-3b0fa8cc6dc3','','','Pl. hartw. 303.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acf50713-ad76-5ad5-a6a1-83131e19026f','','','Novon 8:8.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3feefe34-7f88-5d49-888c-fe3759625db4','','','Prodr. 224.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d299cabd-bce7-5ff6-a0b1-ace80025002d','','','Enum. pl. 3: 51.  1841 (S. L. Endlicher, Gen. pl. 238.  1837, nom. nud.; H. W. Schott, Wiener Z. Kunst 1829(3):780.  1829, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60b28507-5051-5da3-b5dc-6d586995ab86','','','Bot. J. Linn. Soc. 131:161.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb563e16-5e82-5950-b71c-77fafce9cafd','','','Ned. Kruidk. Arch. 2:155.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81d80dab-6ad8-5ef7-b198-044a896ec949','','','Bull. Herb. Boissier sér. 2, 8:637.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('518ca32a-3aab-5ab2-bed1-8aedc42439b9','','','Prodr. fl. nepal. 110.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ffbffcc-0212-5466-8140-a64c7fcc0731','','','Repert. Spec. Nov. Regni Veg. 13:235.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60830314-5f7b-5985-b7d3-4a88541a86da','','','Fl. Rocky Mts. 1067.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62c7c1a5-9f77-5e83-bdd8-236c65d195e4','','','W. T. Aiton, Hortus kew. ed. 2, 3:4.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba924c11-9ede-57ae-9153-8641e8cf046b','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:373[folio]; 6:477[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f877037-385d-5b1b-9fb3-6bbc74bd5e5e','','','Trans. Linn. Soc. London 17:105.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb963d6f-4564-570e-aa88-699d68372103','','','Leafl. W. Bot. 2:248.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed76576f-6a9c-5af1-b2ec-8001a33f2e7d','','','Pap. Michigan Acad. Sci. 19:159.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9639175e-1883-5bbc-b4b1-7169bb69f32f','','','Jard. Fleur. 2(Misc.):60.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('506abfe9-926f-5893-92f8-712de2e8d049','','','Ann. Missouri Bot. Gard. 74:283.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c208c01-30ad-524d-b9bc-246e00805639','','','Fl. Brit. India 7:305.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc67b132-d1a1-5577-ac76-969ae414a683','','','C. S. Sargent, Trees & shrubs 2:111.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('881dc462-df3d-5f26-bcf9-7bf7d62b2ed4','','','Fam. Bromel. 97.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14686b38-d1b5-5535-a56e-5f92487ac8c0','','','Bot. voy. Sulphur 53, t. 26.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('437f973b-41f1-57e4-b2f7-2d955a533f8b','','','Willdenowia 17:173.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('374ec235-d08f-5d2d-bf21-718d8263cd1d','','','C. F. von Ledebour, Fl. altaic. 2:460.  1830 Jul-Dec?','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f30dfa6-0217-5f7f-9e5b-a30b187352df','','','Mus. bot. 2:181.  1856 "<I>Phajus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f579dc4-1384-53b4-bfaa-cce1ceb06963','','','Belgique Hort. 36:105, t. 7-8.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b28a803-1a43-5791-bb76-97475864831a','','','Contr. Biol. Lab. Sci. Soc. China, Bot. Ser. 7(6):175.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c452c4bd-cdbb-574a-b464-91e935eeb0f3','','','Rhein. Fl. 293.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b47ad1c-46e6-55ec-93ac-081840eea6f3','','','Edinburgh J. Bot. 49:229.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56f60023-660f-5ba7-ad61-4302466251e9','','','Encycl. 3:40.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87ad6cce-895f-5f09-ada4-2f7745f1de71','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1880:369.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29c6b47e-9786-50f0-b0a0-335985e7e704','','','Gymnocalycium 21:777.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('301b0fe2-bda0-581a-81a8-bdc804a8fc6a','','','J. Jap. Bot. 11:822.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8d0af47-fd5d-5f22-a82e-e73772850737','','','I. Urban, Symb. antill. 3:459.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('532fb39b-2acb-5e50-9876-ce047eaa67dd','','','Ann. nat. 14.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f943d37-8c7b-5b68-a337-69d1938b1d75','','','Icon. pl. formos. 3:185, fig. 33.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a4d3872-9b87-54a9-9f3b-726df02f5f28','','','Index sem. hort. bot. berol. 1874:18.  1875?','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a96b640-0f6a-5e61-b430-9ef929ac5be2','','','Syst. Bot. 7:298.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55325519-0172-52f7-be4d-13933e6e8ae2','','','Fl. Australia 8:372, 392.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c28976f-a183-5a3b-8d75-0fa529bfe325','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3a):300.  1897 "<I>Satureia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a1278d2-a379-5476-89cb-7e611dd14c7b','','','Elench. pl. 2.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26bd34fe-8912-50c6-b1dc-b4db0680d857','','','Fl. orient. 2:940.  1872-1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23799274-055d-5c17-af22-5547719a0e64','','','Austrobaileya 2:22.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ced8db72-8561-5c7c-92f6-cd5c2aece0b8','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 4:185[folio].  1818; 4:235[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7f508e5-c0bc-53e4-9142-4101009efb6d','','','Muelleria 15:11.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be538907-de78-59eb-93a3-954c5013b763','','','S. L. Endlicher et al., Enum. pl. 35.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('875ebc24-4536-5ef6-9762-ecec618c7c78','','','Sp. pl. 2:758.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afa01476-d72e-57c5-8024-647283f62cda','','','Bot. Mag. 79: t. 4689.  1853 "<I>rubro-venia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c81c8e1-efbf-55bd-aa37-5184f1c5fa3c','','','Acta Phytotax. Geobot. 7:37.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48343695-c917-56ba-a73c-72066be34a72','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3a):235.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3dcade95-a99e-5ca7-ac75-17578d66e032','','','Ann. Sci. Nat., Bot. sér. 4, 11:139.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d191d9d-3e3c-5d44-a30b-693936a86545','','','N. Amer. fl. 24:119.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('578e7f0e-ce5e-5755-8ad6-a180967ce942','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 4:32[folio].  1818; 4:40[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7cfa194-8623-53b9-a9af-243be23544fa','','','Bot. Mag. 131: t. 8004.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73adfa34-f296-55c9-9938-2c51b8cecad6','','','Bot. Mag. 156: t. 9330.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fdae4eb-653f-599c-91a6-5bd93ea3356e','','','Fl. Brit. India 2:357.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d54be62-c887-5051-98ae-f7665216b7b1','','','A. P. de Candolle, Prodr. 1:365.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75af8341-35a5-5de1-9d42-ec5653329c0d','','','Acta Horti Berg. 10(2):264.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7799de27-6051-55a6-9602-58c7f167bc2b','','','Bot. Mag. (Tokyo) 23:138.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6322050-0c03-5318-80b7-a4d28aef8c3f','','','J. D. Hooker & G. Bentham in W. J. Hooker, Niger Fl. 573.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1a9602e-ca14-5e4e-b970-bc7a96eb38e2','','','Key Eucalypts 214.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6e83075-d379-55fd-873f-0dc7753981d2','','','<I>Lespedeza</I> Japan Korea 94.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83d0318e-89bb-5e40-ad8f-ad853c1c086c','','','Fl. sylv. kor. 17:86, t. 22.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68f5989e-4e02-5307-a60d-7479e4a11050','','','Brittonia 33:552.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af42f66b-a0ff-5525-b5c6-e08ae54af95b','','','Nova Fl. Portugal 2:43, 564.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37dbb1e7-9915-5dbb-973c-87bfb87ef09d','','','Asiat. Res. 13:372.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31e4aaa0-6a0f-5154-bd66-9fdc48c7b967','','','Bot. Jahrb. Syst. 19(Beibl. 47):31.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf3d419f-2341-5122-9584-33acd6f0d15c','','','E. A. Christenson, <I>Phalaenopsis</I> monogr. 135.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ab59d98-9249-56d3-856e-94f7fe6fbe2d','','','Man. pl. Transvaal 2:409.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6922ca9b-a18d-5215-bebe-8a23c729d7e6','','','Symb. antill. 5:364.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aef04a4-f6e9-5241-bfd9-8ed4a2b8b3eb','','','V. L. Komarov, Fl. URSS 2:716.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8332b35-6bb9-5561-a6fa-9ec0edbaafb3','','','Fl. Brit. India 2:373.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12c706ff-bd48-5a2d-b098-c4c4ca048de0','','','Mus. bot. 1:211.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bcb41ad-27ca-50ac-bd43-a24ada2884b8','','','London J. Bot. 1:499.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55c39e95-5736-53f9-a421-14076252c6d5','','','Flora 22:53.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4eddcd4-10f5-58fe-8694-94a10fbf8311','','','J. Bot. 5:104.  1867 (non Miq. 1851)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1422aae-7654-5f89-bf18-d7b21549a790','','','Fl. austral. 2:213.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a55d9045-a259-5d81-a82c-f01361355943','','','J. Bot. (Hooker) 4:391.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58cbe36e-a397-5e93-879b-dc7cfcf3c25a','','','Flora 26(45):759.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5f4126e-f107-53e5-857e-0f4408cb9ad8','','','C. S. Sargent, Pl. wilson. 1:37.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e70bb240-820e-5673-a365-0282fc8f5e2b','','','Revis. gen. pl. 1:190.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f3ef626-4e52-5e86-a73e-eb8f442f31ba','','','Enum. pl. 2:681.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a240a15-1887-5ad2-88c5-55b37e753638','','','Contr. Biol. Lab. Sci. Soc. China, Bot. Ser. 10:80.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd8592de-4c76-5adf-b585-f05354fae53b','','','Bot. Repos. 8: t. 527.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab6f48d3-474d-588f-87e9-e0f8e896bf74','','','D. Oliver, Fl. trop. Afr. 1:418.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1441563e-7168-5646-b68d-358064dfa9b4','','','Rep. (Annual) Missouri Bot. Gard. 14:70.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e0eee88-9f58-584c-89d9-440b63cbba0a','','','Contr. U.S. Natl. Herb. 12:434.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f2acac6-ba50-5229-89ec-9a6ac6c8feee','','','Fl. Amer. sept. 2:540.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5faecf4e-42f2-57ea-a2fb-674c68738727','','','Sp. pl. 2:1068.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('baed6629-f70c-5fcc-af72-fc6d1a2b9384','','','Suppl. pl. 364.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd150613-d5a2-5e30-bfe0-77e49284914a','','','Stirp. sard. elench. 3:1.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('543c8939-89fd-5422-8427-a1fee0faf529','','','Bull. Misc. Inform. Kew append. 1:24.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97a768bb-fa93-5986-bc13-19642a513ea1','','','Occas. Pap. Bernice Pauahi Bishop Mus. 23:67.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df157490-1eaa-5305-8aa7-8a3233215062','','','Bull. Soc. Hist. Nat. Afrique N. 23:168.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92d8d056-e7d5-5c9b-b526-c3588c194a18','','','Austral. Syst. Bot. 20:326.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a292c4bf-2e0e-5143-8e78-25d162f799e5','','','Bull. Div. Agrostol. U.S.D.A. 4:34.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d19b0bb3-a681-5907-ab25-88cd381082b1','','','Prodr. 7:144.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2155a1b-6c59-54d3-8c15-bdc204ddfb23','','','Gard. Bull. Singapore 15:335.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd97c484-9f58-513c-b81e-bdbfde329bbd','','','Nov. pl. sp. 262.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5647722-de2c-5d52-b683-454ecb24d991','','','Fl. reipubl. popularis sin. 67(2):402.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0cd2e20d-e106-59d8-9cae-55b7e40e3324','','','Thes. cap. 1:52.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c915166-dd53-577c-8974-af1abd301989','','','Bull. Soc. Hist. Nat. Afrique N. 31:110.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('499cc8f2-561d-5d0d-98ea-285898c9a916','','','Fl. francisc. 261.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca7ebfe2-7a45-5bde-a23f-b157bf9cebcd','','','A. L. P. P. de Candolle, Prodr. 16(2):265.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54254011-f3de-5bdf-bd07-0b805510cf4a','','','Sp. pl. 2:685.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5f07de2-7e71-5a7f-8978-8911268a6afe','','','Fl. cochinch. 1:347.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afc2d381-7b2e-5127-b57c-fa84f78f83d4','','','A. P. de Candolle, Prodr. 5:232.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('295d4c6b-14a2-5c50-b45b-45cd9d09a00e','','','Linnaea 10:591.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc21913e-b76b-550e-9b56-8959848c4dc8','','','D. Oliver, Fl. trop. Afr. 3:459.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3a7c5e8-2f4b-524a-ac7e-76152794fc77','','','Fl. Hawaiian Isl. 242.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28dcb7a2-0ee3-5b8a-a3f8-838dce31f133','','','Fl. germ. excurs. 582.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c60f7ba1-089e-5cd6-87c1-e973e5b9291e','','','Bull. Soc. Imp. Naturalistes Moscou 15(3):509.  1842 (Enum. pl. desert. Songor.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88f5bf13-4b28-58ec-a5e2-f8e4517afd5f','','','Enum. pl. 5:387.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccec8962-43ae-5cb9-bef6-372f971881cf','','','Bull. Jard. Bot. État Bruxelles 32:216.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0e73031-3b19-567b-9c94-23bb5ecb2110','','','Observ. Mesembryanthemum 2:257.  1795  "<I>purpureo-croceum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c41a9d1-cea6-58a8-9a2d-d21123c1bab7','','','Svensk Bot. Tidskr. 6:717.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d6dc729-6877-5484-b44a-a5e25b6110d6','','','Bot. Jahrb. Syst. 37:590.  1906 (non Vell. 1831)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64ecd324-79f6-5dc5-b189-24d447daab54','','','Not. pl. asiat. 4:293.  1854 "<I>obovatis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d911b7dc-d6db-541e-83e4-f9a3ee11e451','','','Tent. pterid. 158.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e4dd3fa-6e2f-5f6c-9b7e-8ce03c4416d5','','','Bot. Jahrb. Syst. 49:550.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f031bb2-3d9b-560b-8e34-16d8a4a09ea6','','','Brittonia 6:214.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ce7d7aa-c513-5a80-ab2b-dc0315fb53e5','','','Bull. Soc. Bot. France 16:237.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('450318ac-465d-5cff-83c0-16cfbc413ab0','','','Mitt. Bot. Staatssamml. München 17:485.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2482c356-eb59-534c-9140-00551311c2f3','','','S. African Gard. 18:370.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72a1a926-5fb2-5ec0-8a7a-a785d7402c10','','','Trudy. Imp. S.-Peterburgsk. Bot. Sada 3(2):294.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55e44121-66ae-53d3-a940-f84b3fa4de19','','','Bull. Soc. Bot. France 32:9.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecf1d478-ac74-565d-bc07-13814da4e535','','','Philipp. J. Sci., C 4:606, t. 30, 31.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('788bba47-b845-5849-ae99-ad850c16a0e7','','','Madroño 14:236.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5023b86-eb37-5262-ac4f-f4ed54069e83','','','Phytotaxa 146:15.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ea9c716-b893-5ae9-a7fc-31f12cc659ab','','','Bot. Jahrb. Syst. 14:307.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6776a82e-ed96-5e77-a0a1-c3367da4f7d8','','','Mem. Reale Accad. Sci. Torino ser. 2, 39:33.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9141b4cb-e97a-5b18-8294-894c98d60e81','','','Khvoin. Por. 50:489.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('811c5c23-dadc-58a0-ae78-708c8af84f47','','','Landw. Fl. 322.  1866 "var.-gr. <I>nuda</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56f88559-2553-5951-8a49-5f480f9c4232','','','Proc. Amer. Philos. Soc. 50:432.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('957b4cde-3116-5ee9-9fc6-8e87f7efa7ac','','','Icon. Pl. 5: t. 405-407.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('885ed8d1-614e-59e0-a520-411be454d550','','','Icon. pl. rar. 2: t. 389.  1795 ("1786-1793"); Collectanea 5:61.  1797 ("1796")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e3f1897-177f-5c06-9502-00cf6d8a22db','','','J. Bellenden Ker, Bot. Reg. 6: t. 495.  1820 (Hort. bengal. 45.  1814, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5604625-5a1b-5b3f-bbbf-75a3847512f1','','','Trans. & Proc. New Zealand Inst. 55:96.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('defd6748-663a-5ee6-9cfe-14056b337fa5','','','Trudy Moskovsk. Sel''skohoz. Akad. 6(Genet.):53.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52e5d66f-a2cb-5ec2-99fc-f6992449501e','','','Notes Roy. Bot. Gard. Edinburgh 37:334.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5ad74f0-eaff-59aa-9cb7-899a64e14864','','','Contr. U.S. Natl. Herb. 10:88.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12ece7a1-7029-5326-8c77-77c5848dd672','','','Arch. Bot. Mém. 7:91.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87c7bd60-a5ea-5715-bba3-51433184762e','','','Bull. Misc. Inform. Kew 1933:197.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14003bf0-1319-5a67-979d-8fc5a7269d39','','','P. E. Boissier, Diagn. pl. orient. ser. 1, 2:15.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6454f1e-5d2e-5067-b2d6-b89ea4ae84c8','','','Bot. Bull. Dept. Agric. Queensland 5:12.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('213babfb-4000-55de-9251-44691c8e0570','','','Ill. bot. Himal. Mts. 1(7):245; 2(6): t. 55, fig. 2.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('574b2407-e70e-5af2-a6bd-1bad72899e92','','','Bot. Zhurn. (Moscow & Leningrad) 57:1038.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bed623a8-602e-5ba6-8397-c785a0eba4e8','','','Notes Roy. Bot. Gard. Edinburgh 31:2.  1971 "<I>pulvillus-gigantis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0034e244-abcd-5601-99b9-cc2ef73e5e12','','','Sp. pl. 4(1):414.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a0aac5c-b471-5003-8609-d687f07acf43','','','Bot. Zeitung (Berlin) 10:692.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62494a03-00f3-5bf4-907a-3940b5720377','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 1:224, t. 13.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('470a8b0e-876e-57fa-9a6f-08cf5d26281d','','','Fl. orient. 1:503.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a6314f9-7045-5d70-9757-3d7535e01099','','','Publ. Carnegie Inst. Washington 504:148.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12306183-f04d-5125-92c7-aa0f09ea22b6','','','C. F. P. von Martius, Fl. bras. 12(3):451.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fd56ccc-a693-5f8e-8b4d-9f55a0438755','','','Ges. Naturf. Freunde Berlin Mag. Neuesten Entdeck. Gesammten Naturk. 7:196.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('925e3e75-6e89-5922-8bbd-f6c634dc718f','','','Contr. Biol. Lab. Sci. Soc. China, Bot. Ser. 9:135.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9146d2cc-f7f4-546c-a641-506836645fcc','','','Darwiniana 5:70, fig. 5.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2ed114b-cfa6-5bf9-9053-62669745a2fd','','','Bot. J. Linn. Soc. 76:364.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0661b751-d431-563b-a46d-305dfdc9bfb1','','','Meddel. Grønland, Biosci. 15:12.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a50b0696-90be-5a49-a8c6-87fb403d71be','','','Anales Jard. Bot. Madrid 56:379.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be19e499-dc0b-5721-9460-53d341e9a7af','','','Proc. Biol. Soc. Washington 13:65.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d621dfe-5d87-57fb-b305-dc375058de09','','','Nov. gen. pl. 3:67.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2359077d-d749-59d1-bdf1-a50c66c5640f','','','J. Linn. Soc., Bot. 21:443.  1885, nom. cons. "<I>tiliaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27597469-cad9-5c73-8a6d-dab63e36699e','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 65:118.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('273a3701-6745-526d-80c7-76a348bfbad7','','','Fl. Filip. 451.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5611c9a1-fa68-518e-89f8-22acd36a03ad','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 10:202.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21a3cd55-d7d5-5e69-ab63-32a26e96b3e6','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1881:96.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19b246f9-284e-527b-aee6-976572919b25','','','Anales Mus. Nac. Buenos Aires ser. 3, 4:495.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f13f8a65-6078-5462-9402-eb9203bad003','','','Ornam. S. Dakota 178.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77f4b5a6-4ffd-52fa-8472-c3518a8822a4','','','Fl. atlant. 2:388.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3837f3a1-8f0c-5d09-b6fb-52a0f9e7ae9c','','','Bot. Mag. (Tokyo) 40:162.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f775abc-6ca4-58b6-bb18-2392c64ee420','','','Descr. icon. pl. Hung. 1:62, t. 61.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3e735fa-a097-5307-818f-08f0bc3dc2be','','','Fl. N. Amer. 2:334.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7109d1cf-0af2-52fb-b0d3-c6f89866dbc3','','','Fl. Pl. South Africa 57: t. 2176.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12239649-80db-5135-80d9-f9b91be271cb','','','C. S. Sargent, Pl. wilson. 3:286.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6266938-c1d4-5573-8dd4-2c4cdb035c81','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 1:322, t. 67 bis.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d92c3d06-4771-52cf-bfc5-d98b66f38f8b','','','Encycl. 2:428.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aff674e8-0949-55f4-b71d-40d02b4b3d36','','','Enum. hort. berol. alt. 1:377.  1821 "<I>striata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('750e9fa4-3308-55cf-a699-a265d40fb80c','','','Proc. Amer. Acad. Arts 20:369.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc8cc446-ff8f-54c3-8852-4f9d4565bfd4','','','Bot. Jahrb. Syst. 46:220, t. 3.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72f9e2ef-ef24-5dcb-b607-fec9ed615b95','','','H. G. A. Engler, Monogr. afrik. Pflanzen-Fam. 6:42, t. 16/C.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cb07852-bbfd-5b5b-9b51-9070725107f2','','','Trudy Byuro Prikl. Bot. 7(5):328.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47baab2e-73c9-527c-8425-0db11f2f0ef7','','','Mém. Acad. Imp. Sci. St. Pétersbourg Hist. Acad. 5:551.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99812a78-c72f-5da9-ae23-bc541b9d93df','','','N. L. Britton, Man. fl. n. states 497.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99920ebb-4308-5521-9c39-f431d08b427c','','','Fl. bor.-amer. 1:295.  1833 (Edinburgh New Philos. J. 6:311.  1829, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9df4b706-0fb8-5f3a-91e7-23716d05263e','','','Notizbl. Königl. Bot. Gart. Berlin 5:284.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df34d9a2-551a-56aa-97ce-1e07c7dd0187','','','Contr. U.S. Natl. Herb. 16:240.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70210a51-b717-5ae1-9b52-5eb4c453694a','','','Revis. Potentill. 54.  1856 (ex W. J. Hooker, Bot. Mag. 53: t. 2700.  1826, pro syn. under P. splendens D. Don)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3ae06a5-db41-5cda-bc3a-5fef93474ef3','','','Bot. Mag. (Tokyo) 25:74.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7c5f686-477c-5000-8493-3e63987c38af','','','Repert. Spec. Nov. Regni Veg. 11:4.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b632d9a-d486-53f0-8854-7b175e3b8f7c','','','Bull. Misc. Inform. Kew 1917:197.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f81d134a-c296-536a-9f82-77eef0bc4a8c','','','Hooker''s Icon. Pl. 37:30, t. 3613.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1789d937-de14-5757-bb86-dbce26197033','','','Bot. J. Linn. Soc. 183:569.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3725436-b414-5f8b-b9f9-8fd53533e06b','','','Pittonia 3:108.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('152fe6af-6b6d-5eaf-8ee2-4e2aabfe03fb','','','Webbia 23:166.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('524762dc-ff6c-5412-b344-aec8dce804e5','','','Proc. Linn. Soc. New South Wales 20:337.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('010fd7bb-9b15-57c4-a19b-63591c322f31','','','Ill. Handb. Laubholzk. 1:761; Repert. Spec. Nov. Regni Veg. 3:222.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67ebb83f-69e1-586a-8716-6496bb99384f','','','Fl. Calif. 2:210.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ade8870e-9b38-5bf1-9d7c-2cb3743a1d44','','','Linnaea 6:370.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f768607a-fef2-58cd-b355-cb203a5de088','','','Enum. pl. afric. austral. 212.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cf3d05b-e73c-5a06-8549-d0dd1b05d43e','','','Feddes Repert. 79:409.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9b06a22-45b7-5db6-b9c9-dadf8b5909c5','','','Trans. Amer. Philos. Soc. ser. 2, 5:165.  1835 "<I>Corispernum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3398962-f6fd-53d2-974f-1c5e9dd1f49a','','','Gen. N. Amer. pl. 2:148.  1818 "<I>pusillum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4dd9dea7-5c8a-5349-8db2-09985a728394','','','Syst. veg. 3:208.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a73f6dd-6064-589e-b264-f73bca814491','','','Syst. nat. 2(2):925.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5850490f-452f-56d4-82b2-8ddda065dc26','','','Z. Sukkulentenk. 2:25.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46f9dc49-b2c6-5aad-b5f8-16df6a084e90','','','Bibl. cult. trees 43.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a6f1866-59e2-59b8-bb28-622ee1dce023','','','Sp. pl. 2:657.  1753 "<I>nasturtium</I> Δ"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc9cb627-553c-573e-b3ea-94e7d324f7ad','','','Bot. Mag. 63: sub t. 3461.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6eda7ce-c7e3-5d0a-8f34-704005a4df3c','','','A. Gray, Pl. wright. 1:63.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca1eb0ea-01cf-5b72-a4c5-ac57df7f7e8b','','','Ann. Sci. Nat., Bot. sér. 4, 8:54.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d238ea7a-0d6d-58e8-8d00-b90f16bfc8f4','','','Landw. Fl. 314.  1866 "<I>Panicum miliaceum</I> var.-gr. <I>contractum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aabfc489-13f5-5c59-ad0c-0c8f6abe2f80','','','Kakteen And. Sukk. 60:64.  2009 "<I>alex-bragae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e91bb21-f73c-5d95-8d05-53e87fbe245c','','','J. Coll. Sci. Imp. Univ. Tokyo 31:251.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffe62431-36ba-58fb-b71a-a1ba6eaeeb0a','','','Fl. austral. 2:279.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fa39972-ac64-5456-a5d3-5a38a4c3ba87','','','C. S. Sargent, Pl. wilson. 1:351.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af782c21-67cd-5a3f-9d32-80d7bfcb95a1','','','Man. s.e. fl. 789.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba5f7ceb-514b-5dee-a807-7d060745613c','','','Ill. fl. atlant. 1:32.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75dd812c-898a-5fe8-9e6b-5ac301b84ca8','','','J. Proc. Roy. Soc. New South Wales 48:418.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5160a595-a2c0-52e8-b8af-50dedc495415','','','Ann. Bot. Fenn. 30:190.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('554604bd-d5fa-5a56-8f8d-a330e5b9ceed','','','Fl. nov.-zel. 1:284.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b0c8353-b4d7-5ef0-b562-334f6e357d1d','','','Kongl. Vetensk. Acad. Nya Handl. 24:165.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cacbc59c-0709-5597-bdc4-8d1d5aba4d90','','','Anales Univ. Chile, I, Mem. Ci. Lit. 85:499.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e400a98e-1fb1-59d3-861f-63912eab7b5d','','','Suppl. pl. 109.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e505b78-ab7e-5ce2-8058-6c8de967529e','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 18:163.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1dede75a-2061-53e4-884d-d3c224e5ca87','','','J. Arnold Arbor. 18(4):337.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbd85198-3fce-5b71-8071-bcead8eda147','','','Kew Bull. add. ser., 1:74.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5b8d675-2837-5eba-8c38-2ef48764dd83','','','Balaton Tavának Partmellékének Növényföldr. 315.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb9e30bd-463e-52cf-bb9e-2b8c518682f6','','','Nomencl. bot. ed. 2, 1:564.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab437a7b-fc04-5738-824b-696dde796979','','','V. L. Komarov, Fl. URSS 2:714.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('192f6be2-4141-54e9-a2e7-5a823c3a7cfb','','','D. Oliver, Fl. trop. Afr. 2:90.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8165d96a-f7ac-54cd-9c86-97ab1ce970df','','','Zoë 2:243.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acb2a559-dd91-55c1-b642-0cc2535baf5b','','','Bull. Herb. Boissier 4(app. 3):39.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3dbb6c2-411c-585a-a254-d390db2495ca','','','K. M. Schumann & U. M. Hollrung, Fl. Kais. Wilh. Land 29.  1889 (non (Blume) D. Dietr. 1839)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e79671a0-6f07-5b49-9fcd-a027f5465c98','','','W. J. Hooker, Fl. Brit. India 6:223.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61557ed3-b271-55f1-9599-2d61c7fac7b0','','','Mitt. Bot. Staatssamml. München 12:315.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('479f6f67-6266-5849-8790-15403e5a92e2','','','Prodr. 5:628.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('856479fa-7267-5d66-b285-bd278371c62f','','','Gen. sp. orchid. pl. 53.  1830 "<I>Bolbophyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('accbd56d-4fc9-573a-aaac-87e256912674','','','Index sem. hort. bot. haun. 1872:5 (note)..  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac1ea372-1b0d-56ba-856b-0e21b0fd7a8f','','','Contr. New South Wales Natl. Herb. 3:108.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b17326fe-31e7-5fcb-9b08-4e428e5f537c','','','Prodr. 5:343.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecc02df0-6775-573e-9d9c-e24cd45b13a0','','','Encycl. 5:520.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd49a4cf-6128-5252-a215-ab43d984bb90','','','Acta Phytotax. Geobot. 22:159.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('894fd50c-5916-5a17-b596-6b832c28db6f','','','Flora 25(2, Beibl.):44.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e4895da-f087-50d4-886c-3853036335a6','','','Acta Bot. Neerl. 4(2):167.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('908dbb2d-8b73-5bc8-8308-944d9acfe29d','','','Brit. herb. 48:484, t. 69.  1756','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ae1e7be-47b1-5c54-9501-6baef5c4b1b5','','','Just''s Bot. Jahresber. 26(1):353.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a83f9a5-2fee-51b9-978b-bca87d405226','','','Bull. Torrey Bot. Club 26:588.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d4a46a5-92f4-56b9-8aed-990fbc67662e','','','Acta Phytotax. Geobot. 38:53.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8494f3e4-43d0-5f72-8fe1-0989a2f7cdfc','','','Baileya 19:65.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ead49692-1ed9-5b08-b100-3dd91b897eee','','','Vierteljahrsschr. Naturf. Ges. Zürich 51:182.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf860a9d-8ad2-5c35-9573-349616459ec7','','','Descr. icon. pl. Hung. 2:154, t. 144.  1803-1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63d0a5a4-2054-554f-8b78-74697b75f344','','','Pl. bequaert. 1:362.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7cac780b-eeff-57d6-8190-888e44b517cb','','','Abh. Königl. Ges. Wiss. Göttingen 24:331.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cc40392-1e5c-5b4f-8902-905b808b9c59','','','Encycl. suppl. 4:222.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e8b0948-1aba-5ca6-b990-086460696226','','','World Checklist Seed pl. 3:17.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95dd7ec3-4ac6-55a3-9353-ef94336f5b9b','','','Trans. Amer. Philos. Soc. ser. 2, 7:451.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf5bd785-b9b9-5758-80c1-0c0c84c9cca6','','','W. T. Aiton, Hortus kew. ed. 2, 5:211.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc894273-ca7e-53f3-8724-949efa83528d','','','N. Amer. fl. 21:19.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f28b7e06-e20a-51b1-8ab2-e986951e0418','','','Syn. fl. germ. helv. 188.  1836 ("1835")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25ea180f-e0c3-59dc-b348-f2576ed0bb7d','','','Eclog. amer. 3:9.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae2336c9-9a99-5516-8142-10058bfb32cc','','','Abh. Königl. Ges. Wiss. Göttingen 24:217.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('472bddd8-2d92-5d16-9fe9-4620134f939a','','','J. Jap. Bot. 10:207.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a83ac345-5ee8-5b42-81c8-3f83db831d44','','','J. Jap. Bot. 17:21.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b492e45-004b-5f21-bf18-5e04ecf78ec0','','','Bot. Jahrb. Syst. 73:462.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccf59974-d0d0-528a-b977-604e1c18fed6','','','Acta Bot. Yunnan. 11:46.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd23ded9-3d39-5253-b7af-4029093b1d32','','','Tent. fl. abyss. 2:458.  1850-1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a505781f-0df6-56ae-ad52-24454a0ecbc4','','','J. Proc. Linn. Soc., Bot. 1:172.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a04a899-1518-5472-8330-ee760f0cfa9c','','','Just''s Bot. Jahresber. 27(1):496.  1901 (non DC. 1825)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5eb145c1-d4bd-500b-ba1f-1c4e7b09fb77','','','Darwiniana 9:20.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1764b5e9-4989-5684-92f3-df6394ee4b06','','','G. P. Yakovlev & O. A. Sviazeva, Bot. Zhurn. (Moscow & Leningrad) 71:481.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bcaf979-6a35-5792-b5ee-e64be550f732','','','Bot. Jahrb. Syst. 26:285.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7522330-d2ec-540a-a640-2970c08842b1','','','Gard. Bull. Singapore 51:94.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f487520-02ef-5736-b661-1028078ecbd6','','','Nuytsia 1:401, 404, fig. 4A-C.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('538ae6fa-04d1-59f8-8d70-db497927ca09','','','Bot. Gaz. 31:223.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ea7be6b-e975-58f2-9c74-1b171025b859','','','Rep. Bot. Soc. Exch. Club Brit. Isles 4:634.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51fc77cc-fed0-5a62-930e-1fa51fafb201','','','Bol. Tecn. Inst. Agron. N. 2:31.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89a9e7a9-b300-500d-860b-c4729ed0bb71','','','Trans. Linn. Soc. London 8:351.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6904afe-0971-5678-88ac-7ccf231d5c33','','','Syst. veg. fl. peruv. chil. 183.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0cfbfc9-5ed3-5887-be30-da105ed25640','','','Collectanea 1:86.  1787 Jan-Sep ("1786"); Icon. pl. rar. 1:15, t. 156.  1787 ("1781-1786")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e370c12-9dd3-5b3f-937e-f695001f45a6','','','Prodr. 4:379.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2b2ce07-2c8f-5e8d-a729-bff3b0e484b4','','','Fl. nordwestdeut. Tiefebene 496.  1894 (non L. 1755)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5215ad2b-929b-5699-8a3c-0152fe752219','','','Proc. Linn. Soc. New South Wales 83:93.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4ab07f1-55c8-52d4-aafd-12cad2951991','','','Harvard Pap. Bot. 10:50.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('556fa0c6-1877-5e8b-b998-7329bcc57ba8','','','Nova fl. Portugal 1:551.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('095c75e3-94be-508f-b551-f14f27d07996','','','Monatsschr. Kakteenk. 12:9.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bb24fe5-4803-5256-ab96-49c633af8a02','','','Byull. Sredne-Aziatsk. Gosud. Univ. 19:121.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e3c832f-a6f7-53b8-9c06-a0e09e3d575b','','','Kakteen And. Sukk. 42:37.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cee128e-80a3-584c-b9a0-13539b026bfa','','','C. F. P. von Martius, Fl. bras. 8(2):179.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca046fce-e719-5751-aa9c-85da230ee174','','','Lejeunia 120:104.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ada27db-2506-59f1-b2b3-546bab28faa3','','','Jahrb. Königl. Bot. Gart. Berlin 4:245.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90ceca91-8ea2-560c-b080-527aa7a69136','','','Contr. New South Wales Natl. Herb. 4:454.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e76106d-3f38-5019-b8eb-7898a3481803','','','Mem. New York Bot. Gard. 27:33.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ec4c9de-9dbe-54e8-a16a-ac59b9d90081','','','Bijdr. 318.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('883a63c3-4b20-51de-bde1-2f952665d896','','','J. J. Roemer & J. A. Schultes, Syst. veg. 2:474.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d797801-e217-56e9-838c-4902f891fe56','','','W. H. Emory, Rep. U.S. Mex. bound. 2(1):177.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d00dea21-e1b7-51d1-b034-ef1c68e695da','','','Acta Phytotax. Sin. 36:552.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('327a9b7c-6e8e-52c8-b78c-30f10beaeacf','','','Cruciferae cont. N. Amer. 525.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5c614a2-f5d6-53fa-af9d-269f6771e53b','','','Pacif. Railr. Rep. 2(2):128.  1857 ("1855") "<I>gunnisoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67c3d678-67c8-5e29-9ea4-fb3253a1f25a','','','Proc. Amer. Acad. Arts 21:408.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f58d138-0e0c-5a35-a9bf-c90350fd1e32','','','Prosv. Glasn. 22:1246.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1c51ed8-f72d-56fc-8639-8f339ca2a2ac','','','Mus. Senckenberg. 1:166.  1833 (non Dunal 1813)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89e6f357-b4df-5f0b-8ed8-c2527b5a36ee','','','Bull. Acad. Roy. Sci. Bruxelles 11(1):242.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4a24280-dd4c-575c-bd06-d2618ffedce1','','','Fl. belg. 62.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59620917-af93-5a1c-a0b2-247d968dd32e','','','Rhodora 38:418.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82f59ce4-97ea-5d56-abce-5d731e081a48','','','Fl. Brit. India 1:473.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d4e397f-a145-52c3-90a3-d40e59ebc0aa','','','Bot. Not. 124:290.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0c35def-5e92-533f-8dc7-5d0cecd0a9cf','','','C. F. P. von Martius, Fl. bras. 2(3):103.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('480f4f7f-aa1a-5384-b427-263dd476e889','','','Prodr. 6:426.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('579866ba-a099-51d0-8472-69f1f4aef55d','','','T. Makino & K. Nemoto, Fl. Japan ed. 2:880.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87f2a607-55b3-504c-b67c-8349e0a614cc','','','Prodr. 1:347.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a384e32-4602-5532-9eaf-630524a8d061','','','Fragm. 3:147.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d20ebfcf-cfce-5686-8cdc-f75fb4e8c481','','','N. Amer. fl. 22:26.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19a7200c-2d08-5f5e-851f-de50ee0b2bb5','','','J. Bot. (Hooker) 4:362.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a8b23aa-4dcf-5759-99f3-a501d5d3aaff','','','Proc. Biol. Soc. Washington 15:19.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31071f64-7204-53a0-b6dc-64c73b1797d4','','','Bull. Misc. Inform. Kew 1912:89.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a23fe7d-9a0a-5390-a4b6-766337461e87','','','Sp. pl. 1:542.  1753, nom. cons. "<I>uarcissifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c36dd1a7-deef-51cd-9c3d-9d99b52de05b','','','Ann. Missouri Bot. Gard. 25:283.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e22b3e5-d360-5972-9035-867900408168','','','Flora of West Pakistan 55:24.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d16c59d-05cd-520e-9a2d-715dbe87448e','','','J. Jap. Bot. 14:339.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6836b11b-2183-533d-8d98-09a5cb86cfb2','','','Kew Bull. 57:617.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40ca3cd4-222a-525e-a5cb-165fd9313c06','','','Bull. Misc. Inform. Kew 1913:136, 138.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce28dde1-7c2e-56f5-bac0-41dafd85b4c6','','','Hooker''s J. Bot. Kew Gard. Misc. 4:145.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c386d87b-9819-5c41-b298-23abd019e8fe','','','Rev. Hort. (Paris) 72:210.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcc33f26-5a0e-5b12-ad88-b0b3f6867179','','','C. F. P. von Martius, Fl. bras. 15(2):234.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('770e5d69-4def-5c91-accf-2ee648846642','','','J. Acad. Nat. Sci. Philadelphia 2:115.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3308d366-712c-5b18-9f2c-9867ff46a45b','','','A. L. P. P. de Candolle, Prodr. 12:560.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d02432a5-27d7-519f-9ffd-137d15db58fe','','','Anales Mus. Nac. Montevideo 4(2):49-50, fig. 7.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93cd516b-a7b8-523d-83ed-40a9befcfdcf','','','Gartenflora 24:1, t. 817.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1495bec8-8e26-5d43-ad3a-d424315dda1a','','','Edwards''s Bot. Reg. 26: t. 20.  1840, pro sp.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7c59a9a-453b-5c3d-a86b-067339032808','','','Pittonia 1:61.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64bf903d-9df9-5e49-bd1e-09d5587f7c61','','','D. Prain, Fl. trop. Afr. 9:583.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28cf5b79-28de-5c4b-9ef2-2403fb279cbc','','','Kurtziana 1:213.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('940612a2-dc5b-57cd-9910-cfe274fb9de2','','','Publ. Carnegie Inst. Washington 4:211.  1905, pro syn. (Waterlilies)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b472788-b469-58ee-b006-8493dcb5dcbc','','','Notes Roy. Bot. Gard. Edinburgh 16:13.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18201a46-3375-5403-a3ed-f470063573ec','','','Fl. francisc. 424.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e704b7be-d8a4-5e01-bbc8-3d5f6db257af','','','Hist. arbr. France 2:27.  1809 (Tabl. école bot. 150.  1804, nom.  nudum)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a739fcb5-13a8-5920-b846-284f61060c47','','','Linnaea 4:32.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1dfd2e76-eb10-5ec9-94af-b4159c7c2db4','','','Fl. bor.-amer. 1:147.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('240ff312-3239-5990-b2dd-83fd9d455b9e','','','Bull. New York Bot. Gard. 2:165.  1903 (non Royle 1839)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32fc9b76-aed3-562d-9b73-906da2fa5494','','','Bot. Centralbl. 45:106.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3d7a4f5-da21-5a41-b900-e0538b7c485e','','','Asie min., Bot. 1:457.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('644c4277-80d1-562a-97fb-d41adb226ce5','','','Contr. Gray Herb. 56:7.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b18c1edc-06f3-5491-9931-f072b9df7d58','','','Trans. Roy. Soc. South Africa 3:123.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d768bbef-d2d3-550d-859d-93e3637dced5','','','Ashingtonia 3(1):12.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('633083cf-8813-5748-a8fd-8793a56bb1dd','','','Hist. pl. 2:167.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02a90b12-9dbf-5717-962d-a9b0e7affbce','','','Nov. gen. sp. pl. 2:68, t. 195.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39ac7913-ba9f-5fbc-b32f-5d59de8606dd','','','Linnaea 21:455.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2966afca-63d3-5ec3-aac6-d534474b1e56','','','Encycl. 3:88.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('344465ee-aa34-5b1b-a997-e66a2990200c','','','Hooker''s J. Bot. Kew Gard. Misc. 5:353.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b7c3694-fc47-5824-bb21-5a71c8d6a3f6','','','Phytologia 71:274.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83e0b016-27ec-5003-b1b4-d5201df94fbe','','','Nova Acta Acad. Sci. Imp. Petrop. Hist. Acad. 10:374.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40e4d73a-3ee2-52bd-b807-eb28bf80ed4f','','','Pl. Life (Stanford) 6:95.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab47d679-5d84-5c8b-8e83-ef906cee2fdf','','','Hort. universel 5:33.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd037939-495a-57e7-8be7-1f3fda7b6635','','','Wimmer & Grab., Fl. Siles. 2(1):51.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf3cb949-2ce0-5deb-9086-3c59ece4dedc','','','Madroño 1:141.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e18357cd-62ff-5280-8ed1-1ffffb7d2b47','','','Bot. Jahrb. Syst. 78:183.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c6e4bfd-1408-5dd1-b47c-f47a3e8ea36c','','','Bull. Torrey Bot. Club 49:266.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e469b888-96b2-5193-b3a8-3dd7a07803d6','','','Gard. Chron. 1867:25.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('156f24fa-9659-5b49-99b2-7a14fd160f40','','','Cact. Succ. J. (Los Angeles) 63:67.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14a5a82b-c7bb-5b7a-a77f-c615396c4371','','','Bot. Mater. Gerb. Glavn. Bot. Sada R.S.F.S.R. 5:78.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5fc6a77-024c-5f6d-9abc-a0194ae6c4b8','','','Oesterr. Bot. Wochenbl. 7:341.  1857 (Gen. Aroid. 4.  1858)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3fcd498-118c-5fe8-9e12-627c61cd07d2','','','Möller''s Deutsche Gärtn.-Zeitung 48:146.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfc5d62e-466f-59d2-9c0c-277bd3f6ee5b','','','Sp. pl. 3(1):729.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34f8043e-25a0-5c59-ad45-3fd0a65f1a95','','','Edinburgh J. Bot. 56:355.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b33da0be-90bf-5de5-b08c-0064ba3cdd5c','','','Consp. fl. eur. suppl. 2:237.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e57361c-dfd1-548a-8878-855e248a52b9','','','Cat. pl. hort. panorm. 18, 275.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('801a4969-195e-5815-9b08-75a4a6795fce','','','Philipp. J. Sci. 14:426.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c92b155-1379-5494-b9a4-33637fa9b13f','','','Descr. pl. Cap. 177. 1767 "<I>hermaniaefolium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2927a48e-6a3a-589e-aef3-808eda574ce0','','','Bull. Soc. Hist. Nat. Afrique N. 13:180.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('180757e1-c9e3-58d7-a0f0-54cc22a76fe3','','','Byull. Vsesoyuzn. Inst. Rasteniev. 84:71.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f483af69-2887-59c7-b24f-50ecf9779151','','','Bull. Brit. Mus. (Nat. Hist.), Bot. 5:225.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bef6678-88d6-53a4-9546-528dc55a1638','','','Fragm. 7:99.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b9685d9-ceeb-54fb-a61e-3e604eafe15e','','','Fl. germ. excurs. 795.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b6e5d8d-4949-5d34-bff0-970e59a860f6','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 12:229.  1867 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('300e7a3e-f5a4-5629-b69d-c530def5c116','','','Enum. pl. 4:408.  1843 (non Ledeb. 1833)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('451b4e68-9df9-5397-858e-b5d87c9e7583','','','Arbust. amer. 129.  1785 (non Miller 1768)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ead7fe4-72ae-51d8-8c2a-38570db924be','','','Leafl. W. Bot. 5:50.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d45393b9-a382-5616-bfba-ccd315204af7','','','Sp. pl. 1:399.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6c300d0-bb7e-539e-8e28-8d0820f85ede','','','Pl. hartw. 13.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1acd5779-b4a4-588e-ac6e-7b04ef155806','','','J. Arnold Arbor. 29:18.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('582e368a-5adb-539d-83cf-254da1748379','','','Monencl. bot. ed. 2, 1:540.  1840 "<I>manubriata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b25749ea-6920-5073-ac07-ec7594d9dc7a','','','J. Linn. Soc., Bot. 19:150.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9413a0ab-f724-5955-ac1e-a488d37f0af6','','','Syst. veg. 5:258.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79f1cd66-2fa3-5470-b3ca-b178df921de3','','','Philipp. J. Sci., C 7:394.  1913 ("1912")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab5ab357-d811-5a5e-96f0-297ededb847f','','','Abh. Königl. Ges. Wiss. Göttingen 24:178.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90c757c2-0d28-5a71-96bf-ae0c3801294b','','','Fl. Amer. sept. 2:388.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e595084-a32b-558e-8c27-ed59320f77c5','','','Bol. Soc. Peruana Bot. 5:37, t. 3f, fig. 1-6.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b72764cf-9e18-58ef-822c-7fefeecbc3ed','','','Fl. bor.-amer. 1:100.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb4e30df-9e3a-53bc-a316-93b5751531cd','','','Notizbl. Bot. Gart. Berlin-Dahlem 15:622.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81979aa3-ea6c-50be-bd8f-9a7e5dd0f58c','','','Pl. hartw. 74.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a04c1b6a-1a1a-53e9-ae3b-7f5deeb71997','','','Ill. Hort. 17:72,  t. 13.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1bb6d36-5ae4-5857-89f4-b859392e84fc','','','Amer. Fern J. 45:13.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9761bd4f-0bf3-52e4-a7aa-a2f5c1e6d1a7','','','E. Blatter & W. S. Millard, Beautiful Indian trees, ed. 2:79.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6250cf80-5e6b-5a6c-9e6f-798117aead2f','','','Madroño 8:79.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c73d5320-1224-516c-b0cd-f3bb36551fe1','','','Dendrologie 2(2):356.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8c87190-2142-5431-8536-ec884157513c','','','Syn. fl. N. Amer. ed. 2, 2(1):396.  1886 "<I>reverchoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf0f792a-d76a-5c70-8406-ce1cf9495336','','','Indian Forester 80:41.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54b56dfe-7548-5a5b-ae55-2cdfdd6f6507','','','Gen. hist. 3:490.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('711482c5-d90c-5f31-bc00-ca96c8cad9cc','','','Boenn., Prodr. fl. monast. 152.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f849224c-be22-5290-a77f-3748bd0e29e6','','','Trans. & Proc. Bot. Soc. Edinburgh 27:253.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06979119-9511-5a60-a1e2-eec483854d25','','','Prodr. fl. Ind. orient. 72.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5de6632f-a356-505b-be81-d7a10ef7227b','','','Pl. nov. herb. Spreng. 11.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9879fe94-8f1c-5848-87d3-6705cf163664','','','Hist. Phys. Madagascar 30:174.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b766102-89ee-59e4-8fbf-f6122e4588b9','','','Contr. Gray Herb. 161:26, t. 3.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95d82588-7122-5c09-a9e6-91aa09f872d5','','','Bot. Jahrb. Syst. 11:325.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae46a5a8-ca9d-5bd7-93ca-0ce570032592','','','Syn. mitteleur. Fl. 2(1):325.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5727bf59-722a-56c8-abaf-c407f07faf7f','','','A. P. de Candolle, Prodr. 2:174.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('822ddb3b-0c0f-50ff-830d-5642d084aac1','','','Linnaea 28:274.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ac31f0b-dc47-516b-a0cd-d6f34c589487','','','Notes Roy. Bot. Gard. Edinburgh 42:522.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b3db710-b3b4-5c7c-a68f-ffd59f8002fe','','','Notul. Syst. (Paris) 9:56.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0424cea-ccb7-51a1-8b0c-23fcc4ada4cc','','','Hortus kew. ed. 2, 2:303.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90bba2d9-cc3b-5f9a-94d2-57de2147a122','','','J. Jap. Bot. 5(8):32.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4d30a9d-d3e4-5924-b8cf-5827b6b9d46c','','','Mus. bot. 2:32, t. 8.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('02643599-6108-5436-b125-135407b9116d','','','A. L. P. P. de Candolle, Prodr. 9:232.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32142801-074f-5160-b095-7ba917506321','','','Comp. fl. ital. 424.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60acd10e-a413-56d9-bbf2-b8c55d807e3f','','','Nov. gen. sp. pl. 3:75, t. 287.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5665de03-db41-59e7-98e4-7b774cdf34a0','','','Icon. 2:28.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cef2ff42-4ba8-5498-9d0b-e0e356960491','','','Tent. fl. abyss. 1:212.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c224da9-f2d9-5bdc-98a3-5c3f0c22216e','','','D. Oliver, Fl. trop. Afr. 2:28.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccf7f9a1-ad01-56bb-b6a1-928f5c8a4120','','','Bot. Repos. 9: t. 574.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4c34d36-374e-5ea2-a3f0-2be9e4edb22f','','','J. Linn. Soc., Bot. 40:39.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb2ce1bf-566b-5283-aba6-29f44d35f9f2','','','Sp. fil. 1:4, t. 3b.  1846 ("1844") (non Sw. 1806)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('391f9760-a58c-5333-aed6-5131f84cd944','','','Bot. Jahrb. Syst. 49:68.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9df1be1-dc85-570f-a7ab-42c52d3e8540','','','Kew Bull. 52:961.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5eff3693-7b4b-582a-bab6-282fb6cefa7e','','','C. F. P. von Martius, Fl. bras. 11(1):72.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50bf1220-dfcd-52ac-b8fd-b1809ab67fc3','','','Hooker''s Icon. Pl. 18: t. 1754.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5621c11c-63d7-5ebd-be06-97b9e3a4698c','','','Sp. pl. 4(2):771.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbce0e23-3632-5132-b1c9-de9dce965291','','','J. Linn. Soc., Bot. 13:233.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e81a734-37ad-5c38-97d9-586c5a9f1882','','','Meded. Rijks-Herb. 61:13.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa2366ff-0b46-52f1-80f5-83c3dcc1f3c4','','','Austral. Syst. Bot. 10:636.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('434dc733-1609-5d3d-8b89-3641525008b7','','','A. L. P. P. de Candolle, Prodr. 15(2):451.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b86441b-604f-52c1-aa59-a4a4171bf31e','','','Byull. Glavn. Bot. Sada 130:35.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f9f08e3-50bb-5d89-9d35-e0baa02a0c83','','','Bull. Torrey Bot. Club 35:268.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67142833-2d86-5fcc-b4d7-ee5e592dbb25','','','Gard. Mag. (New York) 27:22.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91d30a76-3b48-5065-b6f7-921e3a18038e','','','J. Linn. Soc., Bot. 42:319.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33e33313-3523-52db-89d9-46f4da358fc7','','','Tent. pterid. 79.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3e3227d-052a-5961-bff8-bfb6d1263a9b','','','H. G. A. Engler, Pflanzenr. IV. 147. V(Heft 52):154.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8553138d-0e97-5a30-9505-6b19c0d40bda','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 6:250.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8074d357-2911-58dc-b4bd-67d47183c64e','','','J. Adelaide Bot. Gard. 5:223.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6976bb7a-d83c-51bc-959d-ae2dbe7b4994','','','Univ. Calif. Publ. Bot. 4:225.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fb2d550-82bb-5333-b6d4-c3acbf8a5e10','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 3:936.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e132169-ff01-519a-af5d-af47d012f9a0','','','Gard. Bull. Singapore 21:201.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a72cad35-bcf2-51ae-bb67-4338c7b37340','','','Agaven 111.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4772796e-727f-5606-8df0-c06539b549aa','','','Fl. Filip. ed. 2:265.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd60185a-614c-55d9-84d5-cb1fa6d40073','','','Madroño 6:56.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fbe6739-8e63-50a1-bc2d-a29428a31e16','','','Fl. atlant. 1:244, t. 64.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5d6075b-4047-562f-9b16-3b45b401c61d','','','Fl. cochinch. 1:132.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('638f2628-f190-5576-8697-a97f437b58d3','','','Symb. bot. 3:67.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51076f10-a744-51a4-9319-e1c40a7f82ed','','','Anz. Akad. Wiss. Wien, Math.-Naturwiss. Kl. 61:133.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1dd26f51-b363-57ed-abaf-bb1be3ef19b6','','','Gard. dict. ed. 8: <I>Cornus</I> no. 4.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8019678e-88b6-51ee-9d16-94c09fee989a','','','Candollea 3:393.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11c67993-7079-5fb4-9511-1149652d1887','','','Kakteen And. Sukk. 13:4.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a262c79-25f8-5513-9f4d-76d9351af5fe','','','Fl. Turkey 4:123.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a625641-cbf6-5ed5-998c-12e21a9b01bf','','','Bot. Jahrb. Syst. 19:193.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('747e4bda-c237-5296-b529-370e07288687','','','Abbild. Beschr. Cact. 2: sub t. 14.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e157d491-b4c1-51f0-be6a-9f91391bde9c','','','Fragm. 1:15.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e0513b0-10c8-5eb6-985e-92079021040d','','','Kulturpflanze, Beih. 2:422.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7320ab5e-82e8-5219-9632-db054cc213c8','','','Monogr. Campan. 346.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd0e68d7-15c1-5619-951a-b11a399be4db','','','Leafl. W. Bot. 3(6):125.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d012f245-12c6-58d8-b60b-401969c3e545','','','Sida 18:817.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc663806-c332-5117-be2c-4ea1cfae70ff','','','Notizbl. Königl. Bot. Gart. Berlin 6:298.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b47c771-a024-50a5-98f7-c07cb52d6977','','','J. Nanjing Univ., Nat. Sci. Ed. 22:416.  1986, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57d29e46-48e1-5425-b90f-1781381eefc7','','','J. Straits Branch Roy. Asiat. Soc. 44:177.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c917f1fe-e019-5ab2-97d8-58f68f08551d','','','Diagn. pl. orient. ser. 1, 13:51.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eccd0071-930a-5766-88ab-6455da39cc80','','','Sp. pl. ed. 2, 1:522.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bee8e174-d978-584b-93ee-1c84b4e87278','','','Man. New Zealand fl. 517.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17bef4b6-5a1e-565f-8172-64cd17ca7312','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:183[folio]; 5:236[quarto].  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74700234-b447-52bd-8180-a7c800713be9','','','N. Amer. fl. 21:107.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('960d5dca-8e68-537e-a173-f0840be1a3b6','','','Contr. U.S. Natl. Herb. 23:1305.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9683e442-99c9-5b96-91fe-ea29b7e2b103','','','Phytologia 58:384.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ea13339-f7ab-51fd-a547-bfcb460cdfde','','','Pflanzenreich 444, t. 118, fig. 665.  1838-1845 (S. L. Endlicher, Gen. pl. 512. 1838,  nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a1be5fd-80d2-5d30-924c-13366d82af20','','','Icon. fl. germ. helv. 2:20.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2aed0d4-bc7e-53d0-85b6-c87373bdcd5e','','','Prodr. 6:174.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('482128a1-a1c6-5bab-aae2-b9cc1ace9ba2','','','Begonian 15:20.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0c0040e-8edd-50c1-ad4a-981a6575a394','','','Bot. Gaz. 31:405.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2414f2b2-4d99-5eb7-ab9e-7ca3dbe650b9','','','Ill. pl. orient. 1:151, t. 82B.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d5ac754-5a9f-5075-94b2-1efaba9c15ad','','','Syst. nat. 1:145.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64f5bca2-f1ce-593c-8d1c-f917de25c9fc','','','Prodr. 4:333.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a54e1807-da80-540d-a14a-d5e2c233c86b','','','Kirkia 3:135.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1caf730e-4b89-5889-9041-7d7fc2a1464a','','','Repert. Spec. Nov. Regni Veg. 10:181.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f4849d6-0565-5672-aa92-b8847a905db5','','','Gard. Chron. 1868:1138.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b228d18d-fa03-5c96-ba17-b42c8b4468d8','','','Fl. Ned. Ind. 1(1):431.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30e54e08-b0fe-59dc-b113-11654e71f2da','','','Spic. fl. Lips. 163.  1771, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f44c15ab-706e-572c-b0e8-eaddb9592773','','','Icon. descr. gram. austriac. 2:2, t. 3.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67c2bdd8-e8c3-553c-895e-5913fa0f0413','','','J. G. C. Lehmann, Pl. Preiss. 1:162.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcfbb271-6503-5f25-86d2-22343c91bd00','','','H. G. A. Engler, Pflanzenr. IV. 32(Heft 100):103.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e55dacd-5d93-5dd1-8737-7b8ad45e5e12','','','Fl. bor.-amer. 1:65.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f6af6fc-0b52-5290-880a-c633b5a4ec26','','','Trans. Hort. Soc. London 7:516.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48c506fe-8af7-5aca-ae52-fe4ab2565ca2','','','Nova Acta Phys.-Med. Acad. Caes. Leop.-Carol. Nat. Cur. 6:319, 338.  1778','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c93de1f-1065-5f6a-8098-7c757be24a00','','','Kew Bull. 46:519.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('687bb311-b921-5b90-8c7b-d30778298609','','','C. K. Sargent, Pl. wilson. 1:379.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('036c0be6-5d23-56b8-9738-f19003dc2839','','','Mem. Coll. Sci. Kyoto Imp. Univ., Ser. B, Biol. 5:260.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('872ef253-c531-50b7-a927-affda5aa7459','','','Fl. bor.-amer. 1:258.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c5ed0d8-6f12-5837-a581-e7a789406fc1','','','Blumea 4:520.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5f6c40e-abff-5820-a18f-60ec88d49402','','','Trudy Prikl. Bot. 22(3):339.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f313b6d0-8c3d-51f8-96e8-5b19e94117dc','','','Hort. kew. 3:12.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d43af4d9-fadf-5369-86c6-4c247f6572a2','','','Syst. nat. ed. 10, 2:864.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d98ff7c5-18c7-5f6a-9b89-93aa2884f3a2','','','Mag. Encycl. 4:471.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51d37a1d-5a37-5bc5-888e-0343eae2063e','','','Encycl. 2:715.  1788 "<I>pinnatum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4596c630-848e-5feb-9a77-9ffa1e2ba749','','','Proc. Acad. Nat. Sci. Philadelphia 99:185.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e2a43cb-0da5-5fcd-ab61-b401a72a24d4','','','Verh. Naturf. Ges. Basel 61:176.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a858a35-e5c8-57ae-9b3b-31a3547bd702','','','Mem. Dipsac. 31.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f745e6b8-a730-5dc5-84c4-4adc887055e4','','','Repert. Spec. Nov. Regni Veg. 10:291.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('245cae8a-7e69-52c6-a601-1fe2591926eb','','','Mitth. Thüring. Bot. Vereins 23:15.  1908 (Beih. Bot.Centralbl. 27(2):339.  1910)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e6cc54a-2869-5d2f-9038-ec87cd8b833a','','','Telopea 4:637.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35d070c0-c6c2-5e69-88e6-382c9a721350','','','Mant. pl. 2:300.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b915184-dcee-56de-b06f-e800ba6ffd28','','','Syst. Bot. 29:515.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8bcafcc-4170-5fdf-ad8c-9fae6249525d','','','Procès-Verbaux Soc. Hist. Nat. Ile Maurice 150.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2eaadd8-79eb-572d-8681-62e31edabac1','','','J. Acad. Nat. Sci. Philadelphia 7:58.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2910912e-1f9f-5959-8759-43acea8fcf49','','','Edwards''s Bot. Reg. 26: t. 7.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('256525c2-b4ac-5cdf-a669-cde1676a7e53','','','Kongl. Vetensk. Acad. Handl. 1825:431.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('977da7b4-2aea-54f7-bf71-bd05f570dfc9','','','Trans. Amer. Philos. Soc. ser. 2, 7:432.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25073fd0-7c20-587a-9686-9f6e1994ae40','','','Trans. Acad. Sci. St. Louis 1:486.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c884d0c-8b25-5e00-8cac-2c4a6d97de87','','','J. Bot. (Morot) 3:273.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45a51423-1eff-5e14-95da-4409460573df','','','Adansonia sér. 2, 18:225.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87cf3e69-5ca4-5a8c-9580-5ae3d65da3af','','','Mem. New York Bot. Gard. 74(3):110.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('279636d1-9308-5462-b28d-752e31df1ae1','','','Prodr. 1:454.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bb8c776-38fd-50e2-9bdd-046443f5fd3b','','','Anz. Akad. Wiss. Wien, Math.-Naturwiss. Kl. 60:96.  1924 ("1923") "<I>Pirus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a7494a8-d650-5623-9ae7-295f4ce5de3e','','','Gen. aroid. 45.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f6934f5-82e0-5913-b78a-c4bc268c8d84','','','Repert. Spec. Nov. Regni Veg. 12:2.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2fd3c1c-f14d-59da-ac84-7e527ddea99f','','','Adansonia sér. 3, 26:46.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b58f0b6c-c804-5268-b160-83bf20105e78','','','Enum. syst. pl. 16.  1760 (Select. stirp. amer. hist.  65, t. 174, fig. 22.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('705424f1-5b2b-564c-82e4-bed261421a67','','','Gard. dict. ed. 8: <I>Hibiscus</I> no. 2.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e73bb34-d0c6-5bb6-90d4-afbff51eb475','','','Acta Phytotax. Geobot. 19:28.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4426bce4-2f3a-55e0-b11c-7b23511febdc','','','Consp. fl. eur. 161.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('850c8bc9-7402-5b89-aa7d-9dce3a2863cd','','','J. Jap. Bot. 9:178.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4427b7ed-0fd2-5b61-927c-d42431b4ba1e','','','Denkschr. Kaiserl. Akad. Wiss. Wien, Math.-Naturwiss. Kl. 56:56.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('608752f9-13bc-5c41-b8c4-ceace5d20335','','','Vict. Naturalist 73:74.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c69e8b06-90da-5eda-a0cd-092961cc27e3','','','Madroño 2:89.  1933 "<I>ferrisae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('556c2e7a-0099-592a-baf3-8ae06f6a9828','','','Ann. Roy. Bot. Gard. (Calcutta) 5:110.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('805c9152-25ab-5e2f-b922-032d8cef7d93','','','Hist. pl. Guiane 470, t. 188.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a16355ee-882b-5904-86ec-bde0e8ccae56','','','Pakistan J. Bot. 40:1648.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7ba76e2-56fe-539c-ba4c-24af3bc7d7cc','','','K. M. Schumann & C. A. G. Lauterbach, Fl. Schutzgeb. Südsee Nachtr. 204.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b7a2248-ec63-51a4-8c0f-60e2ec48a47c','','','Gard. Chron. ser. 3, 16:592.  1894 "<I>Bolbophyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe2aa70d-a0a6-5265-a994-c9ae11cd7c12','','','Publ. Carnegie Inst. Washington  527:94.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8045788f-c4d1-5087-a34f-6a802732429a','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 6:239.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f070838-11d0-55d3-b830-0b5131a8568b','','','Rec. Scott. Pl. Breed. Sta. 1963:95.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8aa4a422-e548-567d-b34a-b02470227ea7','','','J. Elisha Mitchell Sci. Soc. 68:69.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f18e3fc2-3906-5a27-abf6-b7fe7d14c549','','','Allg. Gartenzeitung 6:330.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5659d798-f8f8-5f68-92d9-173ded08b5ca','','','J. Jap. Bot. 50(2):52.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0eebf60-31f1-50be-a87a-dbe5955ad45a','','','Ann. Mus. Natl. Hist. Nat. 7:219, t. 12, fig. 5.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1088baf-939f-5e06-a297-434a69164745','','','Bot. Reg. 13: t. 1068.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bdbb484-0762-50a4-bcac-cda83eadfdd0','','','Fl. ind. 1:241.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d513326e-1c67-5598-9a06-a80ac2f216f1','','','Belgique Hort. 33:13, t. 1-2.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f225d6f3-091e-5233-af0a-b18b38a4ee7f','','','Bull. Torrey Bot. Club 42:377.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8941c1b7-3d11-511d-b9b0-a35e4b0825c8','','','Abh. Königl. Böhm. Ges. Wiss. ser. 5, 6:416; Epimel. bot. 56.  1851 ("1849")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2f4d057-2644-5de3-a67c-95e2b05c4b84','','','Novon 8:377.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66982df7-dd7c-568e-957a-99ab2395c702','','','Fl. orient. 1:502.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ecc68da-aceb-51ef-848a-be7cbfabcc2d','','','Prodr. 6:15.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('838f8d26-43ba-5163-89e7-d72b002b45d8','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 22:213.  1876 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c76a316-630c-5171-9156-499a9208495b','','','Tent. fl. abyss. 1:193.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98ac70af-00c7-5dd5-b881-7b815577a861','','','Syst. nat. 2:294.  1821 "<I>Aubrietia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6dd8a04a-1bdb-56f5-8f94-4e12ef4ab4ff','','','Fl. Würtemberg 48.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54530ba2-6c84-5875-8500-56b5811f937c','','','Cact. 2:24, t. 23.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31deef9d-dcdb-5714-87f3-07c9ef347108','','','Acta Soc. Sci. Fenn., Ser. B, Opera Biol. 1:112.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae5063cb-2f17-556d-94f8-eb9e23643298','','','Amer. Midl. Naturalist 46:506.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43d802a8-2a91-5676-b447-472e0fdcb18d','','','Gartenflora 10:85.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0b81d1c-4144-5e41-97e9-420aad9fef41','','','Proc. Biol. Soc. Washington 48:139.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e221d92-8c72-5253-9584-52696c27bc29','','','Cherries Japan 28.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72aa5229-dc3c-569e-8a10-af19feb70acb','','','Uppsala Univ. Årsskr. 1862:154.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7de72bbf-666b-5b92-8c64-f8a86763215e','','','S. Watson et al., Botany [fortieth parallel] 280.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52af2388-3058-5cc3-aaf3-4d05e6b99222','','','W. T. Aiton, Hortus kew. ed. 2, 5:192.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afa15666-dbc5-55bc-bf0b-6a94e7a8736d','','','Mem. New York Bot. Gard. 35:886.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08393e8b-04b5-5313-9976-ce04f121c87a','','','Fl. sicul. 29.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab579314-9d99-515f-9d74-80bd9cdce738','','','Bot. Jahrb. Syst. 30:91.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61ce0c7e-8112-51a1-ad21-d6a107b2d9ba','','','B. E. Smith, Cent. dict., rev. ed. 10:6708 sub <I>Veatchia</I>.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b771936-b83b-5198-85a4-c8d45d248cba','','','Bull. Torrey Bot. Club 31:643.  1905 ("1904")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66210ce0-8427-5f9c-bf43-2c21a3ff028b','','','Trans. Linn. Soc. London, Bot. 1:172.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba84e851-ef7c-5c6a-a204-8472b8298dbd','','','Queensl. fl. 5:1423.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5cb65ce-52b2-500b-aca5-fcd041cb3fd9','','','Sp. pl. 3(1):121.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f94cf6b2-1b07-596e-8df7-29e436556a7b','','','Index sem. hort. petrop. 1868:14.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb93ce48-9efe-5877-8ea1-f76391f55a89','','','Trans. Roy. Hort. Soc. London 5:452.  1824 "<I>Parinarium macrophyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce1d5c45-1664-517b-b41f-639f88c3c457','','','C. Gay, Fl. chil. 4:500.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62fb29a5-5ca1-5a78-a73b-0cc1471c4c63','','','Oesterr. Bot. Z. 45:317.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbc1bf8c-951c-5020-b08e-57386479d54f','','','Sp. pl. 1(2):925.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('523be1ea-49af-5f6f-99dc-e39aa91eaa81','','','Repert. Spec. Nov. Regni Veg. 23:222.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78515c03-6889-52a5-9118-e87cdc92fb1d','','','Minnesota Stud. Pl. Sci. 2:110.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb9ebef5-a67a-5b77-8fcf-e225a5c34a89','','','Fl. nov.-zel. 1:173, t. 45.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ae4fd8e-dccb-5040-ab82-d1b4f9f6eeda','','','Tabl. encycl. 2:42.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74d4d3b2-ca46-5332-b626-a319f1947b9f','','','Ann. Sci. Nat., Bot. sér. 2, 7:360.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4086a8e-f249-5185-97ee-693208e1d45a','','','Bull. Univ. Osaka Prefect., Ser. B., Agric. 9:33.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6696898e-feca-54bf-91ab-0d257d7c4ede','','','Repert. Spec. Nov. Regni Veg. 20:5.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f019688-a9fa-5e89-98c5-c24c342e4595','','','Izv. Tomsk. Gosud. Univ. 81:452.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6efa910b-2876-5450-985f-93f5455ce3fb','','','The genus <I>Inga</I> botany 234.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19ff82e5-4783-5667-92fe-0ff520b818b5','','','Formes Grecques de Blé 36.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aece5b2-5f68-500a-b3f7-64417518766f','','','Syst. laur. 376.  1836 "<I>Haasia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c9faa63-8523-515e-bfb7-4364fe7340e9','','','Hooker''s Icon. Pl. 34: t. 3320.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aca67c4e-63e3-5972-a8a8-26471f83fe12','','','Prodr. 3:409.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c3f18d1-221d-5493-8fc9-dcb43a191b68','','','Flora saghalin. no. 314.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48a27abb-507b-5637-b5ae-0887cfd26501','','','J. Linn. Soc., Bot. 16:109.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b7f9ebe-374c-5622-8602-74469b9c3643','','','Trans. Linn. Soc. London, Bot. 4:166.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a982c13-b02e-53ee-9993-480136e3b98f','','','Eriogonum 64.  1936 "<I>westoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d38f06d-8a67-52f1-951f-3f801aa78054','','','N. Amer. fl. 23:116.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46e03b3c-c994-59bf-8948-f0663dcb75db','','','Bot. Mag. (Tokyo) 32:34.  1918, pro sp.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bdfd4361-0c66-5282-be3d-92a09adf9833','','','Fl. Brit. India 5:370.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85b37bd9-f7c5-5d02-92e8-ecf5f50687c2','','','Gard. Chron. 1871:479.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c2fa6a6-eb57-5745-a47b-1aa6b57cb2a4','','','Syn. pl. 2(1):180.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9f8e9f2-a047-55a2-aef0-2dde3d47ff45','','','Bull. Soc. Hist. Nat. Afrique N. 12:186, t. 12.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86beae33-aa1f-5026-a0cc-d73b2f9b0c2a','','','Sida 8:94.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1e24a0c-4436-59ab-9f7b-f906e4bd593b','','','Bull. Soc. Imp. Naturalistes Moscou 13(1):60.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d2b2f60-c757-598a-9a65-b0b317f5c0f8','','','G. Bentham, Pl. hartw. 315.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e8c394f-31b9-57e5-af84-3cc6a04ee379','','','J. Linn. Soc., Bot. 38:265.  1908 "<I>wollastoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8abdf0f3-4ea6-5037-b902-3773bef91541','','','Phytoneuron 2015-53:2.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b74f94f-d95c-504e-9e7b-74575931dbcb','','','Ann. Mus. Bot. Lugduno-Batavi 2:86.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cbe6884-bfce-5bf1-8375-875cb4d5a4e3','','','Fl. Javae 19-20(Magnoliaceae):8.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9175f53c-ef8a-5999-a202-1d7447f5790b','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 13(3):375.  1943 "<I>carthaginensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09bd86fc-efed-5b1b-9239-3debd35bdf1d','','','H. G. A. Engler, Pflanzenr. IV. 250(Heft 27):72.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b836b995-8707-5071-b93c-9b0a172f6b2b','','','Sketch bot. S. Carolina 1:184.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22d78088-f9a3-5354-82fd-80026992825e','','','Rhodora 7:146.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eed9e180-7c53-56a7-b3ec-eeadaffa0522','','','S. Watson et al., Botany [fortieth parallel] 239.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa7eb6f0-9039-5cd7-bcb5-0f9666a70230','','','Gram. unifl. sesquifl. 157.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9eea602e-2e5a-5152-a4ad-c57addaaf43d','','','Observ. bot. 5:22.  1788 ("1789") "<I>aciculatum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('848456ad-f30e-56ac-9f44-9dceeab8bddf','','','A. L. P. P. de Candolle, Prodr. 14:184.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('781e55cb-6466-5807-8a7b-4676f9aa343e','','','Fl. ind. ed. 1832, 3:549.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b31792e1-90e9-548f-a193-f74a91d48a24','','','Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 6,4(1-2):110.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b90d60ca-d615-5b7d-bdca-ad7528019718','','','Fl. sicul. prodr. 2:438.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6d55d3d-2d05-5f2f-a9bf-98f1d912c6c9','','','Nordic J. Bot. 3:458.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6369977-01b6-5eb1-8fc4-5e5ca3a237f2','','','Beitr. Fl. Russl. 155.  1852 (preprint); Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 7:331.  1854 "<I>salviaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8815b44a-e520-5788-b234-3c5f60731339','','','Bot. Jahrb. Syst. 11:335.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8bc9d7a-f955-5f74-9313-c78b1f553f38','','','Proc. Amer. Acad. Arts 8:368.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98ce50d4-8f2e-5076-a98e-a676b15fdc67','','','Prodr. 3:178.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f60fe4ae-ca6b-57e6-b9c1-3a998d3e1a9a','','','Bull. Torrey Bot. Club 32:206.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df7b28c9-cd0f-5159-b207-5497bd1bc8a7','','','Oesterr. Bot. Z. 28:262.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16d8345c-34ab-5e89-ab3d-8b18b7a3dcc1','','','Sci. Bull. Agric. Div. Univ. Ryukyus 4:96.  1957, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('747dbb8d-ff02-5c80-8aef-750eec15c8e5','','','Notes Roy. Bot. Gard. Edinburgh 22:156.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e728ae9-e2fb-5e3f-81ed-451e428f69ff','','','Nov. app. 73.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ac92dd3-e73a-5167-b925-39264bb5c676','','','M. M. A. Lesson & A. Richard in J. S. C. Dumont d''Urville, Voy. Astrolabe 1:96, t. 15.  1832 (Ess. fl. Nouv.-Zél.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50faf345-e522-5d07-8228-fccf41cf64b9','','','Webbia 2:170.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0cae5ab-4e5d-5d34-b128-720354002763','','','J. Jap. Bot. 48:256.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('370d3dc7-574f-5be4-89ec-bdbc5b811877','','','Enum. pl. China bor. 2.  1833 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 2:76.  1835)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57fc6f3d-4971-59b4-b5d0-37af94c5dd1c','','','D. Prain, Fl. trop. Afr. 9:535.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64d93f66-ccfb-52aa-b56e-f99bad18c0ab','','','Encycl. 3:376, 440.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4d393bb-4959-51a0-92a5-cc429b95ddd4','','','J. Linn. Soc., Bot. 37:65.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa15d97b-e51b-550c-ae27-5d080bbd418c','','','Rev. Bot. Appl. Agric. Trop. 18:829.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17a9e76a-4d84-5949-a106-e519dc3a0632','','','Austrobaileya 2:87, fig. 1B.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35f7a63e-fae1-5465-973b-f82877557a0b','','','Man. New Zealand fl. 921.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3259c3a2-35e9-5ac9-931d-55243a29a4bd','','','Invent. Seeds U.S.D.A. Bur. Pl. Industr. 31:87.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a1dc9f8-0582-5e95-a4f1-8ee82f447de2','','','Ill. observ. bot. 1.  1773','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b0cb520-6504-5248-b36e-a7efb1b10306','','','Austral. Syst. Bot. 1:315.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('659beae4-b7ea-5549-b2f1-1e9df2c57c3b','','','J. P. Jessop & H. R. Toelken, Fl. S. Australia ed. 4, 4:323.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e347fdf0-c68e-52cc-a8ad-1a9d9d78d646','','','Proc. Acad. Nat. Sci. Philadelphia 15:69.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59f988ea-3e24-596e-9008-6ac0b135001d','','','Aliso 7:417.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('612528cb-a9e7-5084-bbee-ca3045849aff','','','Monogr. Digitaria 459.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c847fe1-02ff-59be-9bfd-6a27d2b959fe','','','Rep. Bot. Exch. Club Brit. Isles 1880:240.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91a1bcc1-8ade-57e0-95d2-4cc9419aec70','','','D. Oliver, Fl. trop. Afr. 2:218.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06883c44-0709-5c12-a7f5-03c21e48d938','','','Taxon 56:576.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ae60703-e6b8-55f5-a6b7-2cc9c4115bd3','','','Descr. pl. Cap. 5.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c38d5db-81b1-5529-b24c-2119f6351616','','','Sketch bot. S. Carolina 2:605.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5ecdaf0-ac20-59e7-9f62-c941dfc59cd2','','','Kew Bull. 50:385.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7ed14c8-4400-5eef-a105-58819118d23a','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 2:526.  1835 (A. A. von Bunge, Verz. Altai Pfl. 8.  1836, repr.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d72e957-173c-5c1e-a21c-249e8a2711ba','','','H. G. A. Engler, Pflanzenr. IV. 129(Heft 53):386.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a62c9ad-6e7d-5ca5-a0d3-e10506de5a96','','','J. G. C. Lehmann, Pl. Preiss. 1:641.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65ece0c2-0f22-53f8-92a0-5fe5d34953f2','','','Bot. Mag. (Tokyo) 30:274.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1a037df-7e1a-56fc-b226-e091134abeff','','','Gard. dict. ed. 8: <I>Asarina</I> no. 1.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee41f340-2225-5da0-87a5-0ffd88f6aba7','','','Sist. Zametki Mater. Gerb. Krylova Tomsk. Gosud. Univ. Kuybysheva 84:19.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('099ca53f-4631-5d43-b763-0dab4f850c13','','','Verz. Pfl.-Kult. 119.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cef9159-8df6-5caf-a728-1044c264377f','','','Bot. Jahrb. Syst. 81:176.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0204169e-2404-5759-ad54-3a5a2022276d','','','Bull. Sci. Fak. Terkult. Kjusu Imp. Univ. 1:194, 207.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7534d7b-85ff-5915-80d1-9f4ffc328ce6','','','Encycl. 1:725.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d57c9ed-87bd-51d9-a223-e915a4a7daa9','','','Symb. bot. 2:45.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4554ca30-dde6-5e80-ac6a-ab3face7e7e1','','','Fl. France 5:208.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d86752dd-21be-51ba-b64e-1eb181f03508','','','Contr. U.S. Natl. Herb. 12:419.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea5aec9f-0c25-5beb-a918-73a887ad6592','','','Sp. pl. 2:575.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb8ab0db-6b16-5137-aa11-c31c5ee88980','','','J. Proc. Roy. Soc. New South Wales 54:230.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3713ae48-e9f4-5722-b5da-c5b57521533a','','','Mem. Amer. Acad. Arts ser. 2, 5:327.  1854 (Pl. nov. thurb.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adc288e9-3c3f-5f40-99c7-ab12c0653f0f','','','Contr. Gray Herb. 49:16.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('026c6124-5b83-5549-853c-64c7448309f3','','','Mitt. Bot. Staatssamml. München 22:587.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f166eb97-ef68-51d4-bbcf-900600b91dd3','','','J. Linn. Soc., Bot. 45:103.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('101ad695-3048-5db6-853f-c11c7ca4a5cc','','','Calcutta J. Nat. Hist. 5:115.  1845 ("1844")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('479d1009-d984-5f8e-8592-77a6578b54bd','','','Fl. bor.-amer. 1:300.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31b906e7-5abd-5a90-a145-c6be8a41707d','','','Prodr. 3:269.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('714afc54-ef04-53de-b9d2-b758bebf42ec','','','J. Linn. Soc., Bot. 22:466.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8180571-79c2-5622-8852-719fcf39e039','','','C. F. von Ledebour, Fl. altaic. 3:173.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c55f9a4e-f797-56ee-870a-5d4b9e303afa','','','Bradleya 14:14.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d1df44d-7952-55a9-b184-9010256c6d37','','','Spisok Rast. Gerb. Russk. Fl. Bot. Muz. Imp. Acad. Nauk 5:12.  1905 (Sched. herb. fl. ross.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3dd26857-00e2-520e-85ce-692921e9cf47','','','A. Gray, Syn. fl. N. Amer. 1(1):428.  1897 (T. V. Munson, Proc. Amer. Pomol. Soc. 20:97.  1886 "<I>Lincecummi</I>", nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be7319e9-a7ee-5e84-8814-23b4ceb39488','','','Syst. veg. fl. peruv. chil. 229.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07a6fe7c-4c34-5459-8eb2-2fc858adf815','','','Oesterr. Bot. Z. 9:99.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78a999d4-08c7-58b4-8b1b-b2270563a26e','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 60(1):51.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61b4af07-d645-5ed6-91e7-90633b918caf','','','Sp. pl. 2:720.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b2076ee-272b-51c5-89af-d29d2f5386e5','','','Fl. Amer. sept. 1:240.  1813 "<I>hystris</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('966334f2-95f7-57cf-af88-d3a3f0ed5e47','','','Mitt. Deutsch. Dendr. Ges. 1913(22):255.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df68a5d3-5d30-5f8f-bf30-4311a4855489','','','J. S. African Bot. 44:402.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('859464e3-7491-5a3c-a512-d4d0e06140d6','','','Prodr. 2:101.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2509bab-32ab-5dec-8cd6-72363d3d9fad','','','Syst. veg. 3:466.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24996045-fcac-5c71-8dce-7ac06dc266f0','','','Byull. Moskovsk. Obshch. Isp. Prir., Otd. Biol. 78(3):139.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d07e7c4a-210c-5919-94ef-29b2d30832e6','','','Consp. fl. Asiae Mediae 2:135.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc7f48c2-ac74-5c9d-aaef-d6a8173037b3','','','P. A. Rydberg, Fl. Rocky Mts. 139.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9881b75-ee06-511c-a08f-474e6439a49a','','','Pl. hartw. 78.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1134b319-0fd2-5cad-8e62-7d27b689221f','','','Bull. Calif. Acad. Sci. 1(2-4):81.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('410b4cbf-731c-5efb-a7a5-cf33009efde3','','','Brotéria, Sér. Bot. 22:24.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0dcc88f3-cba3-59bb-aa56-7c4bc22af80c','','','Icon. pl. formos. 6:1.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6244f86e-17dd-5ce4-89d6-eebdd379abb7','','','Bull. Fan Mem. Inst. Biol. 10:160.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f46a3cdd-5551-5d98-aeed-3b6e086de157','','','Fl. vit. 36.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1754ba9-aa10-5939-81b6-e35775d2574e','','','Cat. coll. pl. rar. 7.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('903fb249-4540-5cc0-95f7-9f94518b63f2','','','Sp. pl. 2:762.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6f8806b-7bcf-5f0e-91f6-8ca484ea5910','','','Bull. Misc. Inform. Kew 1892:126.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd724057-e9bf-55ff-838a-5bb7cea120ca','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 11(16):120.  1868; 15(1):205.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c5c79bd-2228-50b7-9d5e-1ef8dd8506c8','','','Compan. Bot. Mag. 1:322.  1836 (non Royle 1834)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8aacb894-aa55-5edf-9a91-f01adb123264','','','A. Gray, Mem. Amer. Acad. Arts ser. 2, 4:51.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eed26f1f-3d22-524f-be45-3e7cd6e449ad','','','Contr. U.S. Natl. Herb. 10:126, t. 43.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7240be31-f754-514b-8eae-15c0b52ba077','','','Bijdr. 245.  1825 "<I>Evodia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54fa35b9-8e45-590e-b726-4881d0829c45','','','Byull. Obshch. Estestvoisp. Voronezhsk. Gosud. Univ.2:46.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d427c092-8e37-543f-baab-1cc045d116e6','','','Fl. germ. 1:217.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c400967c-75be-5c8e-b5dd-ac40e7a319b2','','','Fl. dan. 3(7): t. 409.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cabf4550-f1a8-59bc-ba2d-cb210eb020c7','','','Kongel. Danske Vidensk. Selsk. Skr., Naturvidensk. Math. Afd. ser. 5, 1:280.  1849 (Mexic. bregn.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a04ba09b-5324-5e74-8706-58a65465decf','','','Notizbl. Bot. Gart. Berlin-Dahlem 15:334.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76799268-409f-59e8-9fe9-24ddee5eabcf','','','Stand. cycl. hort. 6:3045.  1917, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26823d3b-6646-5594-8204-4f572b575ed7','','','Contr. Gray Herb. 212:96.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4427ddf-9819-5336-bc91-f3d5e92609c6','','','Lingnan Univ. Sci. Bull. 9:57.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07b4597d-70c1-539a-8c0c-8e514d18c646','','','J. Acad. Nat. Sci. Philadelphia 7:77.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbe5faf3-53d8-5aee-9c30-84bec47e8afe','','','Fl. ind. ed. 1832, 3:807.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec0bac79-f02d-5692-a257-20c80516faf4','','','Cavanillesia 3:61.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba7512af-8239-51f5-b645-15b5481ca9c2','','','Fl. Filip. 741.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21e7a0ce-b8ec-5abe-8e90-21f857aaa368','','','Syn. pl. 2:296.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d6a7217-4d8a-5e23-a509-b97776e4166c','','','Seznam 20.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adf56124-26bd-5f22-84d1-c316b1e9282e','','','Cact. Succ. J. (Los Angeles) 30(4):105.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70c38bb4-5a21-5b65-8cea-2d320c7619ab','','','Belgique Hort. 32:381, t. 14-16.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93404a88-3d01-55c5-bc3a-0dd5f0405f7b','','','Fl. bor.-amer. 2:248, t. 229.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce3d4659-da36-5cb7-8a15-3e5260678406','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 5:179[folio]; 5:231[quarto].  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab2d4ac2-1a31-5803-bf56-36b7ea084dc0','','','Bot. J. Linn. Soc. 142:115.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8948daa0-f4d8-5f5f-bf9e-2f4bc0a7b6a3','','','Thai Forest Bull., Bot. 32:24, fig. 3.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d37732b-5d37-50aa-928f-149e0665f27e','','','Mém. Acad. Imp. Sci. Saint Pétersbourg 16(9):38.  1870 (Rhododendr. As. orient. 38.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('803877ed-e5fc-5375-b18f-f33b21127aad','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 2(1):213.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6adc4c9a-dfe1-561e-bab3-10111dfa99f3','','','Bot. Jahrb. Syst. 28:162.  1900 "<I>Bolbophyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a01cd0c4-9561-5ae1-a3bc-523d84b7b016','','','Ann. Sci. Nat., Bot. sér. 4, 11:10.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('224693eb-be5c-528b-b33e-f14a5bb9f1e1','','','Sida 2:335.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d39887cb-6276-541b-856e-c6212bc5a2f3','','','Memoranda Soc. Fauna Fl. Fenn. 89:131.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f94f9b6a-6185-564b-8e56-249ac5f4f397','','','Fl. W. trop. Afr. 2:91.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5aec063a-8817-56de-82b5-435e4b449e96','','','Naturhist. Briefe Oestreich 2:202.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d3f6133-428a-56f1-a39f-bb7ded13ecd0','','','Enum. pl. afric. austral. 187.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdfb65e5-b145-5f80-be3f-8206c0886ea2','','','A discourse on Japanese names of trees (Jumoku Wamei Ko) 114, index 8.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8be39396-0ce1-5262-938b-80f79ae04bc1','','','Syn. Queensl. fl. suppl. 1:8.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('147caee1-8a5a-50a5-bddc-fd671a569eed','','','Pl. rar. Sicil. 1:13.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ed06907-888c-5d8a-8af1-94a9fb0cff09','','','Zhurn. Russk. Bot. Obshch. 14:311.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('194b5687-8346-54f8-9a16-2f230178f796','','','Prodr. 146.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e44a320f-5d78-586c-8ca7-1f37ae2ba6a2','','','Arch. Biontol. 2:409.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1d0dcab-a93b-5633-aaba-77834e09ca0b','','','Bot. Jahrb. Syst. 56(Beibl. 125):2.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b739ca96-a5e9-599c-b148-74b5c113fc5f','','','Prodr. monogr. Hypéric. 42, t. 4.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('784b07c8-756f-53c8-a33e-9cc6014875df','','','Pug. pl. nov. Syr. 18.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a68267ef-be3b-57a8-9023-e7d73a783159','','','J. Linn. Soc., Bot. 51:483.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25526068-3053-546d-b7b3-3e3b28c62f93','','','Rev. Hortus Malab. 6:28.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d656633e-d069-5011-91e2-be356e73d29c','','','J. Yunnan Forest Coll. 1:33.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7877fee4-7f59-52ba-bd8c-f4f395ddde46','','','W. J. Hooker, Niger Fl. 137.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad8075db-66e6-51c4-8e1e-171ef26bbcbf','','','Legum. Caatinga 123.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('807e5c9b-d72d-569b-a6ec-93e9021ce1d1','','','Ann. Missouri Bot. Gard. 14:317.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba5028bc-a3e4-5d68-9a2b-c7c3711a5785','','','Hooker''s J. Bot. Kew Gard. Misc. 7:117.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdcec4f2-61c6-503b-9288-f1e4a55e64f3','','','Sp. pl. 2:1102.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2194c95-a044-5971-8fcd-c81d182ef287','','','V. L. Komarov & E. N. Klobukova-Alisova, Key pl. Far East. USSR 1:385.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('439f51d5-a6f1-5a68-a6bb-256840fbb24d','','','W. G. Craib & A. F. G. Kerr, Fl. siam. 3(2):5.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56b135a2-0c9e-5fd6-ba4d-dd4a0c51f981','','','Fl. reipubl. popularis sin. 74:355.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88ff4390-f868-5090-abb7-6889ff208f71','','','Bull. Mus. Natl. Hist. Nat., B, Adansonia 18:58.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64842f91-2821-5665-bf4a-ca58e53cbddb','','','Sp. Pl., ed. 4, 4:306.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9555ad8e-07d9-5ed8-ba0a-2f6735606c85','','','Mém. Acad. Imp. Sci. St.-Pétersbourg, Sér. 6, Sci. Math. 1(1):92.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45178afc-4b5b-57c9-8680-99b30044fd6e','','','Voy. North Pole 200.  1774','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c54c31e7-b6dd-5ecf-93d7-c8bca4ebde18','','','G. Schweinfurth, Beitr. Fl. Aethiop. 268.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54b36ced-eec6-5f2b-a809-0f8b96500bc3','','','Bull. Soc. Bot. France 58(Mém. 8d):233.  1912 ("1911")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2f1e887-a7a9-599e-b197-16070e6a0ff7','','','Enum. hort. berol. alt. 1:97.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c1b9f25-93e3-52e4-96d9-457200492753','','','Taxon 31:742.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b828dd0c-b7f6-5fa9-8ad5-0a17265f69f5','','','Proc. Roy. Hort. Soc. London 3:227.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5031ff2-0354-5766-916f-c1996aa67a5e','','','K. H. Rechinger, Repert. Spec. Nov. Regni Veg. 50:260.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11058469-e124-5d5a-aaf4-7228b18d4282','','','Iranian J. Bot. 3:40.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7f706ea-9745-51ee-b7f2-691b55850c0d','','','Notes Roy. Bot. Gard. Edinburgh 45:378.  1989 "<I>amara</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('667be5df-435a-5716-b0c0-37e068f6f4d4','','','Brunonia 7:39.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bb593cc-a22a-5af5-9e82-4ff3a46a2e42','','','Field & Lab. 19(2):71.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8cfbb72-210d-5a48-a323-9458c0b5f740','','','Univ. Calif. Publ. Bot. 81:57.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56942557-0e2a-53ab-b867-dae79b468f3c','','','Sida 6:192.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0fdd715-7403-5a98-856b-b310eaabe739','','','Erythea 1:247.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1f6b6a3-086b-5a0c-a5d7-20c6e868e6da','','','Field & Lab. 19:166.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b092de5-20e5-508a-918f-06a2b7ce6b75','','','Trans. New Zealand Inst. 43:175.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c4ac18b-845e-5260-8e4f-a2e6782394fd','','','Annuaire Conserv. Jard. Bot. Genève 11/12:21.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c834e1a9-a557-5b4c-8004-a3979c6e431a','','','J. Bot. (Morot) 4:80.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39081c9c-9045-5008-80ff-8f7d658103fc','','','J. Richardson in J. Franklin, Narr. journey Polar Sea 766, t. 29.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9920ffb-b8ca-523f-97d0-f14f115fbbc3','','','Prodr. pl. cap. 13.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16ac8dcd-7564-5b1c-96c8-16330fb06fa1','','','D. Oliver, Fl. trop. Afr. 2:61.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('663a9996-0bb7-5529-82df-d0f2407200aa','','','Gard. Chron. 1869:1012.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1656f8e3-58bb-5484-99d0-cf98ac3e00b8','','','Ann. Lyceum Nat. Hist. New York 2:211.  1827 "<I>baldwini</I>" (Acct. pl. Rocky Mts.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cfb4236-deb2-58d5-98ad-3a01290a5f9d','','','Syst. nat. ed. 10, 2:1175.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38651c6a-8a82-5b42-868f-ad722fe2432e','','','Prodr. stirp. Chap. Allerton 2.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82c2b51d-ad79-5168-88ce-1bb932625fb8','','','Proc. Amer. Acad. Arts 7:353.  1868 "<I>Aplopappus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8802b090-d54f-514d-b849-31ca6e5712ef','','','J. Linn. Soc., Bot. 14:246.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f38aaba-a974-54ad-a8c9-16e5478ed9cb','','','Beih. Bot. Centralbl., Abt. 2, 34:241.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e61839e8-4e8b-590c-a9bd-1b6d740ece63','','','Defin. Austral. pl. 52.  1855 Jun 28-Jul 12 (Trans. & Proc. Victorian Inst. Advancem. Sci. 1854-1855:134.  1855 Jun 7-Sep 14; Hooker''s J. Bot. Kew Gard. Misc. 8:205.  1856)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7694954-a1c8-5989-b9e9-19b8e5329bde','','','A. P. de Candolle, Prodr. 2:557.  1825 (Fl. ind. ed. 1832, 2:519.  1832) (non J. S. Presl & C. Presl 1822)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('118bfbe5-47de-56ab-ba8e-b5660530ff3b','','','F. A. Wislizenus, Mem. tour. N. Mexico 111.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a29dbca4-1eb5-57be-b2f9-21f75f318c6a','','','J. Bot. Agric. 3:177.  1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5113887-d053-5508-bb6a-24938ac378af','','','Beschr. Gatt. Art. Heid. 91.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4932aa14-d4df-558b-b3a8-7ae7cfc44abf','','','Ann. Missouri Bot. Gard. 16:407.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d604bf16-963d-5f67-8c0a-b9257f0de023','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 8:124.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef676a09-efb1-5016-bc11-a2b6db28db98','','','L. Beissner et al., Handb. Laubholzben. 193.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('108cfdfb-291b-53b2-9281-10bac9644427','','','Bull. Torrey Bot. Club 33:147.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('103979f0-0dd9-568e-a2f6-45a0e22f080d','','','Prodr. 2:285.  1825 "<I>dahuricus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9ffd695-c939-503d-b2f0-dfe28c3dacc4','','','D. Oliver, Fl. trop. Afr. 1:302.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aaa1c965-7587-5c7d-8c01-cbe365dc5a1d','','','Handb. Coniferae 45, 47.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('398eb840-8e92-5f11-a1c3-016c10f50ee4','','','Syst. pl. 1:271.  1779','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc8da132-7ee8-5237-a2ba-41e5c6da1b0f','','','E. H. F. Meyer & J. F. Drège, Comm. pl. Afr. austr. 49.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5340b426-ee85-5824-a223-b8a445f1ecb0','','','Bull. Misc. Inform. Kew 1939:262.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7739f786-efa3-5513-a80d-821bbae58f8d','','','Leiden Bot. Ser. 4:112.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d6abd10-236c-5d59-af70-a7ca0d0ecfa3','','','Nouv. Arch. Mus. Hist. Nat. sér. 4, 10:245.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3243595-99be-596d-882d-c9c2f4917246','','','Fl. N. Amer. 2:16.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9d7331e-aecb-5edc-9699-3f21c07a7094','','','Cattaneo, Not. Nat. Civ. Lombardia 1: 302.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('880decb9-c4a0-593e-82e9-a10b4df4063e','','','Denkschr. Kaiserl. Akad. Wiss. Wien, Math.-Naturwiss. Kl. 94:154.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a72cb89-4e4d-5bf3-9c76-dbea16811ba1','','','Bull. Calif. Acad. Sci. 2:491.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('598eff4a-87f9-5a39-8708-3dae2456f966','','','Trans. Philos. Soc. Victoria 1:19.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2a7106c-dcd2-5f52-b3a2-668cecfc52f1','','','Beitr. Pflanzenk. Russ. Reiches 11:8.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e957156-643c-5e94-a41a-e383622f03de','','','Index sem. hort. petrop. 7:47.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6c0dcd5-94e9-5786-9339-0621c802eb89','','','Fl. zambes. 3(3):175.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('463d1c0f-755b-5516-858e-e61e45a0dae4','','','Sp. pl. 1:130.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9606350b-fe12-5ef2-9fe3-eb3ec1b1f64c','','','Animad. bot. spec. alt. 14, t. 4.  1764','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41396fd0-47a1-5384-bf2e-5ecaa220a16b','','','Diss. 4:263.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5015df02-ad7f-5829-b3a5-0de35d2631ee','','','J. Western Australia Nat. Hist. Soc. 2[1]:6.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0690aa9f-4f15-5382-84c4-1411ff11f00b','','','Bot. Mag. (Tokyo) 33:205.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d17c502-b5b3-5c83-a16b-3adc159c00b2','','','Kew Bull. 42:380.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0124f6a-70ca-59cc-81b7-a7d7e362906f','','','Bull. Tokyo Sci. Mus. 18:4.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f471ee0b-5378-5445-a269-60c84cfd44da','','','Repert. Spec. Nov. Regni Veg. 10:127.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc934eec-11c6-5267-afee-dc9ab3c23f53','','','Sp. pl. 4(2):1025.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6982f820-6ae9-5e53-b2b1-719acfb82afd','','','Bijdr. 575.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c9b3f26-eea9-5e35-8b93-87fc79329f39','','','Fl. sylv. S. India 1, t. 1.  1870 (J. D. Hooker & T. Thomson, Fl. Brit. India 1:63.  1872)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c04f4ae9-ecaf-5fe9-a085-d068680f8b72','','','Philipp. J. Sci., C 9:83.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('146040b1-904a-5ccb-991c-cf272b42f7ab','','','H. L. Duhamel du Monceau, Traité arbr. arbust. nouv. ed., 5:6.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7911d02e-ae1c-5652-bcc4-47938984bd56','','','Notes Roy. Bot. Gard. Edinburgh 29:353.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68d83e0d-316b-589c-bb6d-21a899fb8b9f','','','J. S. Presl & C. Presl, Delic. prag. 46.  1822 (non Burm. f. 1768)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88f35052-a715-5f5d-8fc5-e6c35fb20e39','','','Bot. Mag. (Tokyo) 47:263.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1aba02b-73f3-51d6-a11e-ecb22cd438e7','','','Zoë 4:47.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('867fa2d8-b8a3-58af-8c75-8b776f26d639','','','Tent. fl. abyss. 2:412.  1850-1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51c97ba5-b198-57f2-85f3-affe0f976a1d','','','Ann. Sci. Nat., Bot. sér. 2, 17:201.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a63d9c7-084d-5071-b16e-c7c1e4835e07','','','Contr. U.S. Natl. Herb. 20:32.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61dc7924-aff8-50b0-8796-aeac2058ebb7','','','Hist. pl. Guiane 1:550, t. 218.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d19bd02b-c9de-5502-8709-4f9f217eaa13','','','Bot. Mag. (Tokyo) 29:261.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79aee073-76f5-5830-85ef-c8afd18a0474','','','Handb. Irid. 15.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65116258-7ece-5240-a9f0-f3f31e7f4ddb','','','Tent. fl. abyss. 1:312.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7842853d-6612-583d-9c27-180b5c4e7623','','','Ill. Handb. Laubholzk. 1:658.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba263eff-e4d7-5f3f-b66c-7c379509c46b','','','Fl. bulg. suppl. 40.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8cba8e5-b682-5fe1-8592-fd10ad934ea0','','','Bot. J. Linn. Soc. 67:281.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc5fd0ed-92e7-5a5a-bc52-f14f77393292','','','Rhodora 26:105.  1924 "<I>griscomi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f170699d-33ff-5223-8ab1-707216482ee5','','','Brittonia 49:3.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('187c0e14-74c8-5aca-a6bc-da0a65548a5a','','','Contr. U.S. Natl. Herb. 12:329.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('229a5d25-ba6b-5a1c-8914-573cabfcc83a','','','Diagn. pl. orient. ser. 2, 4:113.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1547e86f-31cb-5d48-a961-5fe74e0da838','','','Succulenta (Netherlands) 38:109.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efc00cf0-99f5-516d-87be-87c3f602514a','','','Bull. Herb. Boissier sér. 2, 4:772.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('761aff8f-c33a-5b1e-b916-c7bd1ca8eec1','','','Mem. New York Bot. Gard. 35:744.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6b44aba-93c6-57b5-86ae-6e6e72b4ecc2','','','Fl. Oware 1:67, t. 40.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba83e64f-46c0-5125-a14f-8c79213f6102','','','Nordic J. Bot. 20:517.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04b2e0e6-c6ab-51b6-8ce2-ca8a7d260c54','','','Zoll., Systematisches Verzeichniss 2:86.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4c844eb-92dc-5c0b-83a0-4b3ba7279ed2','','','F. E. L. Fischer et al., Index sem. hort. petrop. 8:64.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36e275cb-aa27-50b9-973b-e5dc63c3e475','','','Fl. forest. Cochinch. 1(fasc. 6):12, t. 79, (fasc. 5) fig. D-F, J.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5f11e63-6206-58a2-88c4-473474c3e772','','','Bot. Jahrb. Syst. 20:474.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f7e4bef-6b0e-5822-b2cc-9bbb9ae9695f','','','P. E. Boissier, Diagn. pl. orient. ser. 2, 4:96.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8b63f02-c50f-5809-8d0f-3739444ae730','','','J. Bombay Nat. Hist. Soc. 67(1):66.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4bfd68c3-8c14-5a90-8816-9133a1c31dbe','','','De Junco 38, t. 2, fig. 3.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb8c7916-ba2c-5e3f-b07b-bd7e4c91764e','','','Naturaliste Canad. 79:252.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('232d3e75-59e2-54e1-be95-0b8ce39fff35','','','Notes Roy. Bot. Gard. Edinburgh 9:82.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddb9425a-b0e2-534b-b64a-faea784d871e','','','C. S. Sargent, Pl. wilson. 3:6.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6811d16-56d2-5cbd-b2fd-2a97c7405389','','','Prodr. 426.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a74e94c-a85c-5b39-875b-4b364e43dc62','','','Notes <I>Mesembrianthemum</I> 2:128.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f7d4030-010d-5906-ae1c-692ef1911ed7','','','Illinois Biol. Monogr. 6:28.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0b481d8-e268-520f-bd9b-cd456e01a8d3','','','Syst. veg. 3:794.  1826 "<I>berteriana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0ef57c1-8dc8-5a9d-96dd-7c74a0f298cd','','','A. Pulle, Meded. Bot. Mus. Herb. Rijks Univ. Utrecht 41:478; Recueil Trav. Bot. Néerl. 34:478.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdd56d17-d8e9-57a6-8714-af90c6a404e6','','','Fl. dan. 4(10):5, t. 566.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ef86442-8380-5fbd-8d9a-f3cdf300e98a','','','Mém. Soc. Linn. Paris 4:304.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75e6e020-b5bf-57ab-a0a5-2c4c1bdfe31b','','','Prodr. 5:180.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86071764-c62a-5beb-a1fa-4af3d3b828af','','','Syst. veg. 3:592.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('117f35c4-c4ea-53f7-95ad-6663b910e5a3','','','Bot. Mag. (Römer & Usteri) 4(10):21.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e72f72d-87f1-54ca-a6fd-e98d5c07ada3','','','Encycl. 1:550.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bb9f093-0962-5649-a2be-bedcd2187ec0','','','J. A. Murray, Syst. veg. ed. 14:256.  1784 May-Jun (Fl. jap. 111.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('082780e7-2519-59e6-b66d-2b6d4900643e','','','Sp. pl. 2:1041.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b473ac86-16b0-5c01-8d80-0bd3a0f02338','','','Van Heurck, Observ. bot. 215.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('536d58df-b918-5800-8459-c507b22c6670','','','J. D. Hooker, Fl. Brit. India 3:558.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fcd51d4-6a30-5f1a-9e05-2885dc7fc93a','','','Coll. bot. sub t. 33, t. 37.  1821?','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4337515c-a18a-505f-92fd-f6cd9e813015','','','Orchideen 210.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72662f1e-661f-5f01-97bc-d87f63741213','','','Brittonia 47:168.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd1fbbb3-5eba-52d3-957b-6f65d9e1d79b','','','Arch. Jard. Bot. Rio de Janeiro 12:10, t. 3, 5.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4225770-9c31-5701-b80e-7bd8262b3296','','','Fl. bor.-amer. 1:300, t. 104.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('299a4a56-1bd8-5db3-859b-5b511cbd2559','','','Telopea 4:60.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82b43eb9-f3f0-5f80-8bde-fcdb136e04a8','','','Oesterr. Bot. Z. 106:368.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0a29234-2f50-5d93-8a42-f2b3c9950389','','','Bot. Mag. 59: t. 3131.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4267cba-fb4b-5a6f-820e-d0dcddcd77f9','','','Syst. nat. 1:427.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7812172b-569b-5d94-86e5-85196f9995bb','','','Bot. Beechey Voy. 16.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9426a36f-a6e4-5f6f-a906-994a4d956ab3','','','H. G. A. Engler, Pflanzenr. IV. 275(Heft 66):171.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b97ac001-8095-5965-b196-50dd39e24223','','','H. G. A. Engler, Pflanzenr. IV. 251(Heft 59):91.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ac8a77b-ea01-53a4-8165-558a870811af','','','Trudy Prikl. Bot. 32(3):28.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b04a953-b216-5b99-8421-9f84203dbc94','','','Leafl. W. Bot. 1:179.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c8fd9d9-73e8-53a6-8bf8-9c0c20891c79','','','J. Linn. Soc., Bot. 40:226.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c068f076-10a7-5795-a550-3140c9a728af','','','Paxton''s Fl. Gard. 1:170.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c011830-a8a1-56a9-8e42-1c37321e353c','','','Ann. Bolus Herb. 1:89.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('788501a3-35d6-5d06-870b-91551c3165ee','','','Mem. New York Bot. Gard. 65:340.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d83c8c5-9196-56a3-b076-d06e0b90b9b1','','','Brittonia 12:40.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b5aac4e-f0d4-51ec-be03-ec8e9fab7b4d','','','Fl. s.e. U.S. 1182, 1339.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8090176f-06a5-5b33-9b4f-bff285ac7c54','','','Fl. ind. ed. 1832, 2:360.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e109c30e-7810-5bc8-816f-8bf40321d289','','','Icon. sel. arb. 21, t. 7.  1880 "<I>lavallei</I>','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73331741-60f5-5221-bc70-1bab05c98bac','','','Gard. Chron. ser. 3, 150:159, fig. 77.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edf2536e-2e4c-5633-9560-992721eeabfa','','','Enum. pl. 5:339.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22c47e29-7159-5c62-93c6-1778d0523ff0','','','Fl. flumin. 297.  1829 ("1825"); icon. 7:83.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9087277-7ede-56b0-a5b1-9961d178c0a6','','','Tent. fl. napal. 51, t. 39.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d415de7-50fd-56ed-9911-17632830203d','','','Diagn. pl. orient. ser. 2, 1:33.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe483ca2-500b-509d-873e-81fe1a2a8d04','','','C. J. Maximowicz, Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 9:234.  1859 (Prim. fl. amur.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f92b9595-a842-577a-8123-45aa7a64a00f','','','Zlaki SSSR 157.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8215ad17-557b-5621-8d43-0f377db16fb6','','','Descr. icon. pl. Hung. 1: t. 24.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fb5363b-3463-5e46-aa17-431f862995f0','','','Bull. Soc. Bot. France 27:328.  1881 ("1880")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3db4bdee-1a2a-5ef8-b9ff-31574d718940','','','L. Sitgreaves, Rep. exped. Zuni & Colorado Rivers 162.  1853 "<I>Aplopappus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('364df294-e376-5f29-be4f-e2f8331c26a0','','','Madroño 3:304.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('141a88d7-1c63-5bde-bdce-2e14cf0b7d95','','','Z. Sukkulentenk. 3:97.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01d06e88-d5b7-5502-94e8-34fb15c8b49d','','','Bol. Soc. Brot. sér. 2, 41:251.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efd90523-eb22-52c8-baa6-ec990352fb43','','','I. Urban, Symb. antill. 4:182.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a1d8f51-745a-5471-a5ec-8496c724e214','','','Bot. Mag. 17:16.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5eb6efb5-b23a-5496-9b24-d2b400920456','','','Fl. South. U.S. 47.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b3b4cd2-b984-5312-8e8c-d41446018415','','','Verh. Batav. Genootsch. Kunsten 12:56.  1830, nom. nud. "<I>Sooja</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57567ef6-610e-5394-9f41-d92431e9e0ea','','','Fl. s.-e. Washington 237.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bde35ded-8a3c-587a-abb2-b8da6d3b9167','','','Fl. Neotrop. Monogr. 13:245.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('390854b4-2dd7-5758-8504-5f96bfdf7969','','','H. M. Willkomm & J. M. C. Lange, Prodr. fl. hispan. 3:525.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ca08b77-5970-5030-8926-7f2e8b3ca140','','','Forest fl. Port. E. Afr. 98, t. 40.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91179102-f199-591a-a0a2-7aaf2f661ad5','','','Bot. Gaz. 23:6.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72913efd-aeb6-53b4-a400-2a60514beb95','','','Phytologia 61:441.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b63c397-cba5-5b4d-a381-5cbead99073a','','','Sp. pl. 1:92.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff2e8301-f33d-5d9e-8eaa-a79c72bd72b0','','','Fl. Brit. India 4:694.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bc8273f-be87-5c0d-af98-d1920e9c3124','','','Bibl. cult. trees 257.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa4e9390-587e-5eb9-9958-ec4d4e143e45','','','R. Buser, Fl. orient. suppl. 255.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbf370d2-d7cd-57e2-a032-fbad575ea018','','','J. Fac. Sci. Univ. Tokyo, Sect. 3, Bot. 6:62.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bce489b3-b4d6-57ba-b655-93300af20a9d','','','Bot. Mag. (Tokyo) 55:311.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64caca74-42ae-5326-abb6-218f84f0d5a3','','','Fl. carniol. ed. 2, 2:130.  1772 (non Hill 1769)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('357c1a70-b986-557a-bd85-bf8c1398672c','','','Edwards''s Bot. Reg. 17: t. 1469.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69cd0412-1795-5d6b-ab42-b54db9dbb2b8','','','Notizbl. Bot. Gart. Berlin-Dahlem 7:202.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('faf22ad8-0b8f-5184-bdd6-c3a7e15348c5','','','Crit. revis. Eucalyptus 6:514.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('331ece95-8a21-5843-9f0d-a310bdea3d54','','','P. F. A. Ascherson & K. O. R. P. P. Graebner, Syn. mitteleur. Fl. 6(2):431.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('197a9a65-e5dc-54e7-90b5-0e61c10ced28','','','Gram. monogr., <I>Paspalum</I> 62.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff406ae0-1a93-5e9a-ab84-bff61f30abf7','','','J. Washington Acad. Sci. 14:415.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('059f4c92-d0e5-526f-a19e-3c29a35ff0ba','','','N. L. Britton & A. Brown, Ill. fl. n. U.S. ed. 2, 3:114.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac652301-91a5-52c5-ac69-6865542e44bf','','','R. Govaerts & D. G. Frodin, World checkl. bibliogr. Araceae 388.  2002  (Ann. Missouri Bot. Gard. 84:464.  1997, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d0a4f85-c936-55e7-a139-9b1ed1dcfaf6','','','Rhodora 63:32.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24dca92b-c505-5da0-bd59-f0947c1c830c','','','Sp. pl. 1:72.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ada4ba5f-8e07-5a72-ae4f-47b52e945813','','','Sp. pl. 1:337.  1753, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b5dcba5-6d90-5038-97dd-d1466f7153cc','','','Bot. J. Linn. Soc. 76:358.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efd11993-87a8-52ce-9c7b-06ed498ea9ed','','','Bot. Gaz. 34:357.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b07d454d-ebd4-5705-bfb6-d21e42acd1f4','','','Four Seasons 5(2):20.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f61a116-0448-5800-a0a5-c39f75fc3723','','','Fl. dan. 11(32):5, t. 1879.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e7b8a48-2c64-5119-88a4-9e63585e4854','','','Bot. Reg. 10: t. 857.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbff8a66-5619-5484-9c9f-f92723bd58d3','','','Trans. Linn. Soc. London 10:179.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cca341e-e1f4-5f19-b8b8-1353cd97cba5','','','Linnaea 3:32.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15eea623-26c9-5dd9-8c84-749e5753e74f','','','Amer. J. Bot. 31:151.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1d180fd-111b-5935-8f35-689611ec12f9','','','J. Bot. 36:188.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aed08c9f-fce9-50a3-bf90-3135d2955789','','','Kew Bull. 24:545.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62d0914d-ac3a-58d4-966e-1a28cf67ecfb','','','Bull. Reale Soc. Tosc. Ortic. 3:271.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0ec92b3-dd50-5fe9-ad0a-e9fb6541487e','','','Pl. bras. icon. descr. 1:3, t. 2.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a754a7b-3372-5441-be25-a4a568c1383c','','','Reinwardtia 3:434.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('176bfc6a-d42f-5023-a7b9-836f302072d9','','','Univ. Wyoming Publ. Bot. 1:159.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8b556f5-7596-503b-b328-961429b534e5','','','Fl. neapol. prodr. app. 5:16.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd6c70d8-6b29-526c-ac2b-83b3f1e20b52','','','Prodr. 25.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f464024-924c-5f83-b370-878cbc4b3014','','','S. African J. Sci. 37:184.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c8cc7db-d228-5ba8-89c8-f670a5407a29','','','Nat. Hist. Misc. no. 88:8.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aa49b0e-a198-5d2b-a915-f3e11ae7fb64','','','H. G. A. Engler & C. G. O. Drude, Veg. Erde 9(III,2):620.  1921 (Pflanzenw. Afrikas)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d68ae26c-0aa0-514c-9578-0ef01968c9ce','','','Austral. Syst. Bot. 10:615.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e73f0485-9deb-5929-99bd-954828b69a91','','','J. G. C. Lehmann, Pl. Preiss. 1:53.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d208dec-0cdf-5404-87a8-81be169d4613','','','A. L. P. P. de Candolle, Prodr. 13(1):291.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d3fd16d-4be4-53df-b306-1f0178653198','','','Ann. Missouri Bot. Gard. 77:579.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c29316ea-ccc5-579e-8c96-c9a6509e1d3d','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 42:288, t. 18.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33ff9aae-e2d7-5a13-b2b7-7b2fe643f6a9','','','Trans. Amer. Philos. Soc. ser. 2, 5:145.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('417d3df1-f1fd-5620-895a-d94c10c813ae','','','Syn. conif. 137.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38b85d96-c103-5a35-8026-a2d2b79882ef','','','Bull. Misc. Inform. Kew 1934:222.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d41163b-de4c-5ff1-8cfe-0f1ef4c646e0','','','Eclog. amer. 2:2.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd91546f-5e6f-5707-ab5a-aecc67d441ca','','','J. Adelaide Bot. Gard. 21:93.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0a640da-8d91-554f-a548-d6c657db45b9','','','Austral. Syst. Bot. 1:263.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77917ce9-0930-542c-98d8-63efb802e67c','','','Bot. Mag. 102: t. 6216.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d919ac8c-f99d-57f9-8e31-262311787670','','','Syst. nat. 1:151.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8221853-bdb0-53d4-b001-b4f6b97d47ae','','','Ess. Agrostogr. 15, 152, 157.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('192cd128-9dd8-5bee-b373-cff7b3761d18','','','Encycl. 3:233.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b0e214f-5e79-58c4-b2d6-0260dca6b83a','','','J. Linn. Soc., Bot. 16:140.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc9929d9-0202-5648-a2ce-21398d3e530e','','','Syn. fl. germ. helv. ed. 2:200.  1843 (Del. sem. hort. Dorpat. 1840:8.  1840, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff75b728-da8e-597f-859b-c2038efc7771','','','Ann. Missouri Bot. Gard. 59:456.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3992653a-9287-5f25-a534-1e970f925e95','','','Philipp. J. Sci. 18:50.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f70744e6-6bd2-5ee4-bde9-3357db0b6509','','','Syst. Bot. 42:741.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2b5421a-e21b-524c-bc0f-b3e025f24a2f','','','Sp. pl. 2:964.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af0c66a3-459b-5076-8831-e834c49606dd','','','Sp. pl. 3(1):837.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cc97fad-716b-5eb4-824c-e3704ddd7e0b','','','Bull. Torrey Bot. Club 26:590.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8445ce30-1e22-5f77-bf2f-df7b730e3e60','','','Acta Phytotax. Sin. 16:94.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf4ee6b2-22ab-57b7-9730-05846d5ad8e5','','','Bot. Mag. (Tokyo) 16:34.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07462fc2-528a-59b1-81ef-a5552b607df9','','','Ref. Nauchno-Issl. Rabot, Otdelenie Biol. Nauk 3.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4bb0d52-37a3-58c2-9e3b-7158d1af62e8','','','Enum. diagn. Cact. 108.  1837 "<I>bomplandii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3dc1fa96-8e77-516c-bb6b-17b5ea90af47','','','Cactaceae 1:70.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f646238e-cdec-5d1b-8a9b-582602553661','','','C. F. P. von Martius et al., Fl. bras. enum. pl. 2(1):497.  1829 (Agrost. bras.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('152eba9b-8efb-55a9-9b2b-5e2e6f093a80','','','Mém. Acad. Imp. Sci. St.-Pétersbourg, Sér. 6, Sci. Math. 2(2):163.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09b544ff-cb2e-5a9b-bb4d-15285a6ae6e9','','','A. P. de Candolle, Prodr. 1:368.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70ab19eb-1b09-5e92-a8b8-d13f7143ce1e','','','Rhodora 22(258):104.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e73c536-8ba4-5dce-a75f-f6128bef8ec8','','','Brittonia 46:10.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e9fae03-5033-599d-ab66-ce71ee7da950','','','Trudy Soveta Izuch. Prir. Resursov., Ser. Sibirsk. 1:35.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79484687-e02b-5eab-8d1b-e3b7d24c1ab0','','','J. Arnold Arbor. 25:389.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93d2ebf2-4d6c-59d6-9202-bf47024ed589','','','A. Cariot, Étude fl. ed. 8, 2:908.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30e7083b-60ab-5f88-9ac8-eb67f49f8786','','','J. A. Murray, Syst. veg. ed. 14:564.  1784 May-Jun (Fl. jap. 253.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db4b4811-9e50-5933-a68c-917d660d04a1','','','Stirp. surinam. select. 12.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cacb7fc0-4269-5ed4-9240-df585dd69d99','','','Folia Geobot. Phytotax. 2:120.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('731b840b-3a87-565c-84b1-7115ab04791d','','','Ill. bot. Himal. Mts. 1(2):51.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0edd906-3b71-55b6-99ed-8aabe14f68ce','','','Bot. Jahrb. Syst. 34:97.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('085d3733-4110-5c23-88d1-2e42e8451566','','','Nachtr. Bot. Gart. Halle 1:20.  1801','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3edc9b58-6f01-5761-8862-ba2885736570','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 2:484.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4ce574e-3d56-5a76-80b5-d5a3959e8287','','','Pl. labrador. 20.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dc5c625-0cea-575d-9317-f78bd6ad8c2c','','','N. T. Liou et al., Fl. pl. herb. Chin. bor.-orient. 3:228, t. 59, fig. 4-6.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a48c7ca-27af-5a0c-9c7f-d5cddcae44ed','','','Voy. Uranie 456.  1829; t. 79.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25c1b171-a76e-5fc1-b972-708e1a11796a','','','Bull. Torrey Bot. Club 9:15.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a6ec39e-9a3b-53c9-8243-d58faea18d03','','','Bot. Mag. (Tokyo) 39:277.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('571776ca-3a9a-54f0-9514-7500e8b60e04','','','Hist. nat. palm. 2:29, t. 28-30.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fde54d2f-e591-5e34-b939-fe0c8e92c4e8','','','Trans. Linn. Soc. London 10:180.  1810 (Nat. order Proteac.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('893dfa43-e790-5c2f-b105-61f82c5ee82d','','','Rev. Hort. (Paris) 74:497.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a859e96f-9699-5859-9a18-a5107926e24c','','','Nova Acta Acad. Sci. Imp. Petrop. Hist. Acad. 7:355, t. 10.  1793','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0306dc39-8514-55dd-b64e-051768ba88ee','','','P. R. Reitz, Fl. ilustr. catarin. 1. Oxalidác. 79.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9955e552-7820-5eef-8db0-d05e450599f8','','','Bull. Misc. Inform. Kew 1910:390.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b54f360c-4cef-556d-b7c7-c376a183712c','','','Prodr. 3:181.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b012553-da52-5b0f-aaf9-e5573d199737','','','Icon. 4:57, t. 382.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('864e1c9a-847c-536c-9eb2-9e33835658fd','','','Rhodora 46:31.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9377262-fe66-5e89-9cd2-da4c9c7b47c7','','','Enum. syst. pl. 18.  1760 (Select. stirp. amer. hist. 89, t. 111.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2796a89d-6ced-5bbf-b629-4171c5f0d471','','','Čas. Nár. Muz. Praze, Rada Přír. 152:19.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16d0c424-a4cf-5d3b-ba68-925a7db691e6','','','Acta Horti Berg. 12:152.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe1970c5-3507-5741-8d33-ca6bf9306a5f','','','C. F. von Ledebour, Fl. ross. 4:434.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a90b863-8793-5e14-b7f6-c755aecdedf2','','','Encycl. suppl. 3:460.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('399c7154-3ec8-5913-87a6-ad76b624c3e9','','','Pl. hartw. 169.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2dc3201-365f-53d3-bf4d-e14ac5e2bf72','','','Rhodora 39:446.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('047372fd-df5f-5823-9e41-6f819db80420','','','K. M. Schumann & C. A. G. Lauterbach, Fl. Schutzgeb. Südsee Nachtr. 321.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25b72239-690b-54ab-a68c-e15196e5f655','','','Revista Argent. Agron. 11:89.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4591ee41-9be3-5863-af34-c2b565fc9c5c','','','Enum. pl. afric. austral. 244.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('130da8b6-3987-527f-9b83-6a9819e813e9','','','Spec. bot. Geran. 52.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('351b2836-b123-514f-8967-095d43ea56e0','','','Syst. nat. 2:8.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddfbf4df-67c7-5899-ade2-54712eb83991','','','Char. gen. pl. 72, t. 36.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d05b0439-7c89-571d-9ac2-29a61f93bcdb','','','Naturf. 20:2.  1784','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee7abb9a-a011-57f7-8f06-9c1fe56c25a8','','','Orchid.-Buch 466.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88673d82-411a-5c47-899b-9db2b75d86a3','','','Mem. Torrey Bot. Club 6:31.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('493e9d13-79c8-5427-aea6-efd5a3ede516','','','Bull. Div. Agrostol. U.S.D.A. 17:236.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dd2b45a-663a-55a1-ad90-7e030a5a2747','','','Sp. pl. 1:640.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a4a930b-71ac-58b0-8143-f628f97f5205','','','J. Bot. 2:50.  1864 (S. Parkinson, J. voy. South Seas 44.  1773, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3966ee12-892c-5c7b-a45c-b5d7e73b9f3f','','','J. Linn. Soc., Bot. 18:54.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14c3ec0d-1f1e-5fde-a9c1-bd18229815f3','','','E. E. Silva Tarouca, Freiland-Nadelgehölz. 282.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ea44b36-5e8c-508c-b593-d6c716acadb6','','','Garden (London) 74:645.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba9d0130-d2cc-5e75-8a43-01cfb281f438','','','Voy. Uranie 469.  1830; t. 84.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c4bc058-2b08-5c95-8bcc-2f8083bc9fba','','','A. Gray, <I>Thermopsis mollis</I> [plate 9].  1846 (Mem. Amer. Acad. Arts 3:47.  1848)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b991f9be-2771-5e33-8077-91a64f2ec49d','','','Ann. Missouri Bot. Gard. 72:545.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a7b2b0d-d730-5fa3-9907-749d90c492cf','','','Gard. & Forest 2:471.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c6cd93f-00bb-54dc-bb48-f7b394db9917','','','Proc. Amer. Acad. Arts 6:533.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad904a6e-9049-5650-8222-a66d0f94f401','','','Bull. Natl. Sci. Mus. Tokyo 33:82.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('beae6089-60a0-5c06-b68a-e2148e90d7d2','','','Bull. Torrey Bot. Club 26:544.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff45a4d0-6588-5ecf-babf-c48dca34c3c7','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 3:78.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c59ac258-cf82-56df-8c1c-10e718b14c3a','','','M. J. Bluff & C. A. Fingerhuth, Comp. fl. German. sect. 1, 1:560.  1825 May','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b322e4b2-9692-5781-81db-99cc7380e25f','','','Bot. Jahrb. Syst. 15:479, t. 20.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47a30ccd-4232-5b2c-bc4a-c6fccaa0506f','','','Syn. pl. 2(1):195.  1806 "<I>chenopodifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b6577b2-e73d-5fe8-a8f7-58f66a31371b','','','H. G. A. Engler & C. G. O. Drude, Veg. Erde 9(III,2):579.  1921 (Pflanzenw. Afrikas)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42b48246-9e92-5c3c-8c5b-c6cc61ac5a32','','','Monogr. Aquifol. 1:345.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f38ef38b-6956-5cd1-8e9e-36d77bde7ea5','','','Bot. Not. 1950:52.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0da5763-bb2d-5ac0-a37d-f98930fed1a7','','','Contr. Arnold Arbor. 8:47.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82b55d90-c35a-50e3-adc2-b0e02e99c71c','','','Blumea 44:301.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9eac9084-5cff-52cb-8881-b5f902a20e41','','','Eur. J. Tax. 360:23.  2017','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d99f66e-b71c-5080-8a56-b2a3f1a1f865','','','Pugill. Pl. Afr. Bor. Hispan. 107.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21549c5c-3b5d-5d85-9394-f9e1d2128018','','','Sp. pl. 1(1):37.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ffab69c-25fd-54a3-b937-abc84a321981','','','Bull. Mus. Hist. Nat. (Paris) 1:63.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01fe1b1a-7a74-5f6d-bc3c-385f6a830e3c','','','Pl. Aequinoct. 1(6):140, pl. 40.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ef7a507-f42d-5a5f-be16-991c2231fd3a','','','Zoe 5:74.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b43b782a-92af-57bf-a9c1-a37bc7110e11','','','J. Adelaide Bot. Gard. 21:89.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dd7e89c-eb62-5d29-9d66-557a386e75da','','','Bull. Herb. Boissier sér. 2, 5:666.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b20dfc6a-728f-5df8-8b18-e44b51038310','','','I. Urban, Bot. Jahrb. Syst. 15:293.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16af9504-f9a8-5c95-be90-0e9a21036948','','','Gard. Chron. ser. 3, 1:574, fig. 108.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('496991e4-1d43-5a92-a996-35f690d7f287','','','Sp. pl. 2:737.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95f4f344-31ca-5121-9921-1bfbabdae507','','','Trudy Sredne-Aziatsk. Gosud. Univ., Ser. 8C, 16:61.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09c434b4-bb58-5ea2-8e9c-cb30dc297c00','','','Enum. pl. 1:312.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbe74d48-d2da-5dea-afd4-eda4cc7a640f','','','Kew Bull. 53:966.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee82983a-3de7-546c-aff1-205ab60a089e','','','C. Wilkes, U.S. Expl. Exped., Filic. 16:131.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd77e6ea-f143-5ab7-972c-7e9a5fb82faf','','','Consp. fl. afric. 5:822.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31566d1f-0e35-5256-ba41-47bb058c65bb','','','Sp. pl. 1:250.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4bb0b69-2c65-5a8a-b97b-16280340ddc3','','','Gen. pl. 3:651.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f41b315d-c0ca-51f6-b9bd-5e28b5c93449','','','Oesterr. Bot. Z. 25:232.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('015b6169-9956-53d0-b772-0645d4c69480','','','K. B. Presl, Reliq. haenk. 1:329.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0b0d8d6-c8d7-5c16-9187-c7755420be6d','','','J. Linn. Soc., Bot. 57:215.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('525babdf-27ed-5f02-9b9a-e562c993ea56','','','Syn. pl. 2(1):195.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92ea42b4-8b5c-57a5-97fd-8d11eef05274','','','J. A. Schultes, Syst. veg. 6:185.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2dbda0b-4974-5b83-a527-de972e5eae0e','','','Ann. Mus. Bot. Lugduno-Batavi 2:118.  1865 "<I>iaponica</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f209a3b-8af5-5f31-9892-8bcfb63d753a','','','Nouv. Bull. Sci. Soc. Philom. Paris 1:117.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eec5911d-b16f-55c0-974a-2c8f26babfd9','','','Prodr. 29.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('246fa033-03bc-55de-9ec2-ed87ce7ac8bf','','','Proc. Acad. Nat. Sci. Philadelphia 137:21.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2f8d588-a779-5066-8e0f-e59c39695634','','','Bot. Mag. 19: t. 717.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2150f7f6-650e-5066-81a5-044c9d44c954','','','A. L. P. P. de Candolle, Prodr. 12:686.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7829a05b-149b-5798-bec7-2d074edc5e22','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3a):328.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03cbacba-5095-54c9-a8df-289d129b8101','','','G. Schweinfurth, Beitr. Fl. Aethiop. 187.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91031a40-3779-564e-908e-1ef889bfde55','','','Fl. napol. 1:xxvi.  1811-1815','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2759fa4c-b634-541d-ad7f-80c30b72e8d2','','','Bot. Mag. 17: t. 622.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e184615-ba89-539b-9ebd-4e4af21e5e30','','','Fl. Spa 2:317.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('101c9bcf-079c-5fe9-b03a-6e9e39b25d85','','','Enum. pl. 5:352.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa74530b-de9e-5612-a370-4a7491b21ff4','','','Geophytology 11(2):262.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a620c1e9-3a45-59aa-8ae0-75a270ecf353','','','World checkl. seed pl. 3:15.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98968206-7f0d-578b-a47b-7d90104a7a4c','','','Syn. gen. Compos. 143.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b49486a-319c-5194-9503-f9810f62e911','','','Sida 21:95.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa68e18b-ff45-5403-bf11-772129ded01b','','','Stirp. austr. fasc. 2:129.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50a42a4f-4573-595d-8586-428046c8e73f','','','J. Bot. (Hooker) 2:127.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5693a00e-b7e5-54dd-8e8e-d8dc4cbe26b7','','','C. F. P. von Martius, Fl. bras. 13(1):537.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f652f737-951b-5e71-9523-6e44ec2ea72f','','','Spring fl. Wasatch ed. 4:106.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6ed75f5-5710-5be8-a806-fcb73a835dd8','','','Kulturpflanze 35:142.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecc0b68d-e6f4-5e26-8684-a7570359d4b2','','','Fl. orient. 2:921.  1872-1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('999817dd-ba00-57b9-b5a2-7f49e6d4e321','','','Index filic. 354.  1905; 465.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a45a3b39-f3e1-50c5-aa04-9a32cdddd4e5','','','Magyar Bot. Lapok 5:246.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e036d8a0-6c59-5a33-888e-e4b4b9d86ad5','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 2:427.  1873 Jul (Gartenflora 22:259.  1873 Sep)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44a8a741-10d2-53c7-a799-d0584964fcfe','','','Sert. angl. 17.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2302e0b8-de85-5e63-afeb-7436e4a98cc9','','','Bot. Mag. 61: t. 3315.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('379db78d-0854-562b-b0e8-e597d527a558','','','Ann. Mag. Nat. Hist. ser. 1, 15:257.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acc92a5a-ca87-5b8a-aafc-ce61b99e6b49','','','J. Arnold Arbor. 34:25.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3737e34-3bd8-5690-9c2d-a37d69031fa6','','','Willdenowia 10:110.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92963a4c-35ab-59d6-a96f-ca375d640642','','','Bull. Torrey Bot. Club 233.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b14c1658-3cf7-5fef-9a64-bf76894015cc','','','W. T. Thiselton-Dyer, Fl. cap. 5(2):333.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c862d3c-9ddd-5d6b-acc2-9b3ec9079145','','','Rhododendr. Sikkim-Himalaya t. 21.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9135180-92cb-5aea-b17c-432cd0bb2561','','','Pap. Dept. Biol. Univ. Queensland 2(3):55.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d14ab8bb-2cf3-56ce-80d0-8a85c18ecf19','','','Bibl. cult. trees 362.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('526b8b5b-cd2f-5935-9f83-f36c2888d0b5','','','Pacif. Railr. Rep. 4(5,1):142.  1857 ("1856")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cac0b72-0d82-57bb-b92f-e5aed566ab9a','','','Arbust amer. 139.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73505ad1-98af-53cf-b1ec-b4c11df6536e','','','Notes. Roy. Bot. Gard. Edinburgh 22:393.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78958187-e700-54c1-8e6e-bc2cfb32650c','','','Hooker''s Icon. Pl. 26: t. 2531.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58dceac6-5c72-523a-90d5-328110149308','','','Rhodora 62:321.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87e87867-5b37-58ad-9649-3e84d7a762a2','','','Stand. cycl. hort. 2:1766.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3629aa9a-0497-5818-b2db-ed73e887af6a','','','Mém. Acad. Roy. Sci. (Turin) 5:226.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53c4e425-0df9-53ab-9b8d-2324a0dc0674','','','J. Washington Acad. Sci. 30:212, fig. 2.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50706cc0-5579-55cb-b048-c8f9368ed518','','','Pflanzenvers. 354.  1773','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6c0248b-5e1f-5d81-bc95-7cb6457504e4','','','Iconogr. Austral. Acacia 11: t. 4.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8283f4e-bfa9-52c3-be67-2a0a96da6aae','','','Reliq. haenk. 1:79.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d80dc128-7895-59ce-a883-c896954243d0','','','Bot. Mag. (Tokyo) 48:330.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5980972-7903-512f-ad34-908a97953d85','','','Fl. austral. 2:408.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff98498c-24ac-5ec9-a4b5-9cb58312980d','','','J. Bot. 11:298.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf52cb52-e2c4-5311-987c-6e5b76079aa7','','','J. Jap. Bot. 45:91.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a44430cc-2dad-546b-95d9-eaea25cdb936','','','Austral. Syst. Bot. 7:554.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19da0cb3-ff2e-559e-b2cc-c0e9080779a0','','','Pl. Victoria 1:86.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0d03509-b473-5c36-bd37-942835b71317','','','Arktich. fl. SSSR 2:523.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d3d0d89-57be-5733-a491-34610961f9c5','','','Proc. Davenport Acad. Nat. Sci. 5:192.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04c9f103-8f61-5ff9-8ca7-c8ea82061dd6','','','Asia Life Sci. 20:264.  2011 "<I>ilagii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7366d75-c76f-5f2d-a7ee-def22c7a95bb','','','Natl. Cact. Succ. J. 28:4.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ee004d2-3f1f-5563-b847-008862150f0f','','','Verh. Kon. Ned. Akad. Wetensch., Afd. Natuurk., Tweede Sect. 2, 45(2):10.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a90af6d0-d86e-586f-8373-d1853ea3f090','','','Bot. Gaz. 87:277.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aec6baab-8f0d-5eff-921d-41425670dcdc','','','Bot. Mag. (Tokyo) 43:539.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc704a04-bee1-5b83-b187-8bd7af6f9772','','','Syst. veg. 2:754.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9f774fe-fcf7-5575-918f-1449726fc86d','','','Thes. cap. 2:11.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df28f6fb-bdf4-5894-931b-3c7605ab358c','','','Mem. New York Bot. Gard. 35:834.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3c612e3-95a9-54c5-825a-03c31a15cc0a','','','Die Gattung <I>Alstroemeria</I> in Chile, Diss. Univ. München 88.  1986 Aug (Mitt. Bot. Staatssuml. München 24:79.  1987)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29e21a88-8926-586b-866f-a6d1d3302129','','','Syst. nat. 2(2):1029.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2b01e0d-8e13-5a04-a1cf-35b8efe5ab0b','','','H. G. A. Engler, Pflanzenr. IV. 129(Heft 53):580.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78d6ac39-4d89-5010-ac04-8805736ec60a','','','Acta Phytotax. Sin. 35:53, fig. 31.  1997 (non A. DC. 1859)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24f5a669-2b8a-5647-9b0b-db4875bcee8a','','','Linnaea 17:740.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ae6c08c-38bd-5535-b67e-72503bc2f550','','','J. Arnold Arbor. 64:500.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22ef884a-002f-52fd-8c8a-af1caa8d2433','','','Mant. pl. 2:255.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f65458d-cc40-55e5-a9b8-325f1e9bc3af','','','Gard. Chron. ser. 3. 1:177.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5b1a301-d20a-5318-a884-e218e8dbf851','','','Madroño 4:233.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0def8de4-c0c9-584f-ac80-9e3d687312f5','','','Reliq. haenk. 1:14, t. 2, fig. 1.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('406aabe4-b142-5e5b-8ed6-71b0f7920078','','','Phytologia 44:244.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5e806ec-2a16-5e96-9971-c43fa0de700b','','','J. Elisha Mitchell Sci. Soc. 80:173.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d89ad27-b700-5f46-8dc9-cd1f33fc530a','','','Alsterworthia Int. 13(2):25.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4127ccce-6db7-539e-901d-1013091395f2','','','Muhlenbergia 2:186.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eca47f2f-15fc-57fe-a1b6-1a7c6117842d','','','Conif. taxads Japan 58.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3be59e8-d7f9-557e-b28b-0f396eac931d','','','Phytologia 73:457.  1993 ("1992")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36c82823-9016-5698-adfe-37d7a957068f','','','Gard. Chron. 1855:53.  1855 "<I>Bolbophyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('999ee246-8e7b-545d-8728-b13976e3ee1a','','','Ann. Sci. Nat., Bot. sér. 4, 15:273.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8affe73-7ef2-55b0-92fa-acece9225a72','','','Prodr. 184.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fcd1a806-bad7-50ef-babc-ebfc4ec14d2f','','','Bull. Torrey Bot. Club 35:561.  1909 ("1908")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2564f81c-5ef2-5077-8876-a25c4603cc2e','','','Bot. Jahrb. Syst. 23:194.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b61eaa5-fc32-5cd3-929a-7a4c40e79009','','','Correa, Fl. patag. 3:458.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4712faa5-3ec0-5f5b-bffa-2900bbe896b3','','','Ann. Sci. Nat., Bot. sér. 2, 16:91, t. 7.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e70c7b70-d474-50fc-a52b-8a7d5047e66b','','','Proc. Amer. Acad. Arts 14:243.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a1dc564-f03e-5876-bd53-4d05a327a205','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:166[folio]; 1:206[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc3e303e-a0f4-5643-8f41-f1e220cc6937','','','C. F. von Ledebour, Fl. ross. 4:326.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('150e0675-ea5f-567a-b8c1-705a6559b23f','','','Ann. Missouri Bot. Gard. 74:150.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e901131-0644-597c-9d0c-1bd29c9850b1','','','Taxon 44:584.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e4d0ad3-31f6-50bc-8686-c2ad6c866c08','','','J. Linn. Soc., Bot. 42:260.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36770a4d-de5d-53fc-9c34-35ae318d167d','','','<I>Polpoda</I> 1.  1829 (Symb. bot. 1: 2, t. 1.  1830)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0620e48b-a23b-580c-9ed9-845b78269b14','','','Gard. dict. ed. 8: <I>Psoralea</I> no. 4.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e696a06-23e8-5668-b985-1182b65619a6','','','Bot. Mag. 71: t. 4181.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0690651-e48d-5695-b8ba-58ae39941c63','','','Aliso 19:81.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('128cf91d-4a35-5aba-97ab-fb045f31d3bf','','','Prodr. 6:46.  1838 ("1837"), pro syn.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12371797-7d94-5ca9-970a-247d441b0b46','','','Gard. Chron. ser. 2, 25:298.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75e272f2-4fa0-5c65-bb33-366963b15fb4','','','Vég. util. Afr. trop. franç. 5:178.  1909 (Bois Côte Ivoire)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('603b25c3-b189-57c2-a20b-7e6b1c90ffd6','','','Candollea 9:273.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11ffde90-62ec-500b-8b0d-ea5277056f14','','','Trudy Bot. Inst. Akad. Nauk Armjansk. SSR 7:27.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('205f2050-2764-5f7c-ba05-283ff6766c9a','','','Willdenowia 12:186.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26c3540f-e6bf-52aa-8dad-da785f701007','','','N. L. Britton, Man. fl. n. states 407.  1901 (non Gand. 1884)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65751b10-14f8-598a-9988-c763560e8b61','','','N. Amer. fl. 25:246.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17f2d76c-2850-5bed-8118-cda0394b5852','','','Bull. Bot. Res., Harbin 8:20.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('627c83f1-3f2a-5791-8de2-f4c86c9811bf','','','Bot. Not. 133:483.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc43bcce-5436-5a7d-9d07-65cb20d68668','','','J. Banks & D. Solander, Ill. Austral. pl. Cook''s voy. 2:56, t. 182.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e2cc8c5-ecbd-5fef-a06c-4f309848c60e','','','J. Hort. Soc. London 4:263.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3ada64c-9b12-579b-89b0-5c6ad6ff43cc','','','Mant. pl. 1:103.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af6e86bf-981a-577c-807a-28a6a7aa31c8','','','Notizbl. Bot. Gart. Berlin-Dahlem 11:104.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d9928d1-0beb-57f4-ad7a-c20c3fd1a8af','','','Brittonia 45:6.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2606445-f29b-5f31-a550-287e514eecc9','','','Landw. Fl. 31.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98ab0304-6253-5ec4-937d-03a07862ae65','','','Kew Bull. 8:273.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('785fa6cf-b152-5e5a-8405-9555d639d8f4','','','Fl. s.e. U.S. 824, 1335.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('610b5026-3a1a-5c7f-bbb2-6f99fe838e1e','','','Sp. pl. 3(1):687.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99a46b04-b159-5e16-a59c-8c3394e10c31','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 17:386.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e0092d2-1199-56eb-8cd9-cf149e3a6193','','','Enum. syst. pl. 29.  1760 (Select. stirp. amer. hist. 225, t. 139.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6f03135-c8ca-5136-b325-316e3154ff24','','','Encycl. suppl. 4:76.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ac4fc31-474e-5a72-9c1c-3d6a07d39770','','','Caldasia 4:90, t. 10.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d4856db-714b-593a-9707-ef6208bd0df7','','','Bonplandia 6:369.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9627cd0-12b5-573a-9622-359bccd1ca62','','','V. L. Komarov & E. N. Klobukova-Alisova, Key pl. Far East. USSR 2:994.  1932 (Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 7, 42(2):35.  1897)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99ee32d3-8ee1-5b61-aa12-78ec85159497','','','J. Sibthorp & J. E. Smith, Fl. graec. 1:59, t. 75.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e874acb0-693f-5a8c-901a-99ab652e1995','','','Acta Phytotax. Geobot. 10:137.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a8a40f7-55af-50b0-a626-7bf70c358b5b','','','T. L. Mitchell, J. exped. trop. Australia 361.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c071a99-44ea-5c5b-b117-d76cceb87419','','','Fl. ins. austr. 89.  1786, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c6b5d40-75a7-5e61-aa73-f047cf5042f9','','','Bot. Mag. 131: t. 8008.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83948714-82d1-5eaf-8efa-2751af57b69d','','','Nova Acta Regiae Soc. Sci. Upsal. 3:201.  1780','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49a143cd-5191-566b-a8df-5a32f2346970','','','Mem. Mat. Fis. Soc. Ital. Sci. Modena, Pt. Mem. Fis. 18:403.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61b919c9-463c-5186-881b-f4d4bc28eab2','','','Mém. Acad. Imp. Sci. Saint-Pétersbourg, Sér. 6, Sci. Math., Seconde Pt. Sci. Nat. 4,2(1):6.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e3226be-87e0-5f6b-a46e-513381d2aca2','','','J. Proc. Linn. Soc., Bot. 4(suppl.):89.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('021a260d-e9a3-59d7-8a02-937b2e16992c','','','Ill. bot. Himal. Mts. 1(7):245.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c30d6b08-bbdd-59eb-8446-c43e32fd48cd','','','Fl. Miami 190.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e1bca98-0c9f-561e-ba37-dfefb393b1da','','','Encycl. suppl. 4:7.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0388ce7-5dae-562b-b3a4-6a270a52a055','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3b):76.  1891 "<I>Monniera</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9abdec7-16d6-52e9-a669-251d41d7ed16','','','Prodr. 5:402.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22807f87-3764-5b0f-a12a-ba43d968601b','','','Anales Mus. Nac. Montevideo 1:388, t. 44.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3d7eae7-6628-59e1-8510-9c3860a0efbf','','','F. Cuvier, Dict. sci. nat. 13: 110.  1819 (N. A. Desvaux, J. Bot. Agric. 1:122, t. 5, fig. 15.  1813, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e97ee0a9-17f6-531a-8298-47dcd539a9ae','','','J. Fac. Sci. Univ. Tokyo, Sect. 3, Bot. 5:356.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc182888-80dd-5699-859c-fc645592de3c','','','Trudy Prikl. Bot. 40(2):42.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30835c1a-cc8d-545c-a542-0ee335b5391e','','','Prodr. 3:41.  1828 "<I>billardierianum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5d9b0205-9cfb-5b7b-b778-d87625ea23f9','','','Fl. altaic. 1:204.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('878c83d6-06ae-5038-aa79-bb43ad869282','','','C. F. P. von Martius, Fl. bras. 6(6):265.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8a7ba08-c32c-5db6-b471-c6cece25132e','','','Kew Bull. 29:510.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66fab468-9db6-50ce-a081-edaa06200f6b','','','E. Graham, Ann. Carnegie Mus. 26:224.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2034d773-6789-521a-ac64-45c4b4bfa869','','','Enum. pl. 3:51.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11eda3ef-c2bf-527a-a051-eac38f4cbeb8','','','S. African J. Bot. 55:658.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b643d6f-db02-5157-9de0-53d0ec1311eb','','','Fragm. 1:49.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf120f4c-c218-5d11-bce3-fbca03a52c91','','','Renss. & McMinn, Ceanothus 212.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7e3d4a8-4bca-5b3d-9658-f351f91c8cb6','','','J. A. Murray, Syst. veg. ed. 14:858.  1784 May-Jun (Fl. jap. 175.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23ea7052-e5b8-5c57-b996-f810ccea1b08','','','Rhododendron Soc. Notes 3:284.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('675faca4-9f82-5368-b4bc-7bedb1286929','','','J. Bot. 22:365.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd1a1b14-20b2-5c60-b3ad-907f87f40028','','','Das Buch der Nymphaeaceen oder Seerosengewächse 53.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4facc7a8-c815-5178-97b3-d4ab232a8108','','','Fragm. 8:163.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09a9951b-1073-58b3-95f3-397ed9133e4a','','','Syn. pl. 2:269.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f870589-7a24-5bd2-8526-e8b84807823c','','','Fl. N. Amer. 2:438.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e647fc95-f6da-5c67-808f-b5e8d1d6eae9','','','Bot. voy. Sulphur 39. 1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17c37c6b-62a1-5a46-b7ad-95f82c49ad2a','','','Fl. ross. 2:323.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09124548-364a-5af4-a140-610f78b6c10a','','','Nouv. Fl. Algerie 504.  1962, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc827b80-5e11-5e6a-a1a3-2862bc4047e5','','','Encycl. 1:678.  1785 "<I>pilulifera</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b01ea8e-f49b-5624-8ee5-e722cef4940d','','','K. B. Presl, Reliq. haenk. 1:260.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84daa2dd-459e-5fb7-9aa0-468335df5c61','','','Syst. nat. 2:509.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('240b4fee-2a2a-5ca8-9348-262c0b28f5b4','','','J. Bot. 80:85.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99ac915e-fb32-5862-bda7-4537b40c1331','','','V. L. Komarov, Fl. URSS 2:430.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('334bdde2-d06a-5fff-ad3a-9684e3b5b99b','','','Symb. sin. 7:155.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f85501c-0f0a-5227-bf0e-2e06fe1cc143','','','Symb. Syn. 7:1306.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69824801-8949-58c3-bf23-4504f5597c04','','','Fl. austral. 3:372.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c644a0f8-3c99-52d3-b3fe-218853339cdb','','','Actes Soc. Hist. Nat. Paris 1:112.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9154a518-df07-5a90-aed8-98c5aba7d00c','','','Anales Ci., Univ. Nac. Agrar., Lima 1(3):216.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('926dd46c-851b-59e2-a348-e5deaeb2f9b7','','','Ann. Sci. Nat., Bot. sér. 3, 12:170.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('775f4aad-288b-5589-83ea-b7cf9a5a7655','','','Brittonia 38:335.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29327b98-b13c-52db-83c2-0413e23d861c','','','N. Amer. fl. 22:260.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68025a49-766d-5863-8dc1-497e0cc534ba','','','Trans. Acad. Sci. St. Louis 2:484.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e939cef4-499e-5fb4-b8ee-bb3619db13ad','','','J. Jap. Bot. 52:31.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01dbd286-6867-5b42-b6d7-701d12bc1201','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 3(2):171.  1875 (Allior. monogr.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb07047c-3e64-5dfe-a15d-497523801a95','','','Bull. Jard. Bot. Buitenzorg sér. 3, 9:344, fig. 15.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10e6894f-7395-5e47-aa89-9ce52d798888','','','Rhodora 23:54.  1921 "<I>macera</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3768c3a-6f32-511c-95c1-ef2a3235105c','','','Acta Phytotax. Sin. 28:322.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bd66a5f-e09c-5cc2-9fea-ce33d6987846','','','Oesterr. Bot. Z. 22:179.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75aabff6-41e2-55fd-a09a-94fcaf77a88c','','','Bull. Div. Agrostol. U.S.D.A. 11:52, t. 8.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0d18ba2-8613-5370-82f7-6dad11c56535','','','Agrost. helv. 2:240.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08cc0ed7-7d62-5102-a47b-df5936d96992','','','Hist. pl. Guiane 385, t. 148.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('862b088a-d4ff-578c-bae3-45e460b53098','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:222.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9da00341-3c56-5ba9-aeaf-11544e3caa7c','','','Gram. urug. 341.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cfe852c-4f0d-50a8-b09a-0d97435a6249','','','Blumea 27:327.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('197955e5-a956-58c2-9608-9f8af048d299','','','Fl. sichuan. 2:113.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31540283-f642-53a2-83df-a5db4b9c2c8a','','','Svensk Bot. Tidskr. 16:401.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0e4f7be-4f61-538e-b3e0-597a988cf51c','','','Bull. Soc. Bot. France 48:xvi.  1902 ("1901")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab0b5a14-56cd-58bf-93aa-54a922fbe213','','','Bull. Herb. Boissier sér. 2, 4:1108.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee7c1aa8-c090-5e7a-b1f6-15a452a34133','','','Labiat. gen. spec. 45.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb3eef79-ab78-55cc-b34b-d31f86370bbd','','','Itin. pl. Khasyah mts. 187.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6fe81d9-114a-5bfa-afcf-1baa808497a3','','','A. Gray, Boston J. Nat. Hist. 6:207.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea7033d6-f4e0-53a7-9914-ca845d5aedee','','','Pl. wright. 2:52.  1853 (Smithsonian Contr. Knowl. 5, Art. 6)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f912fea-59d9-523b-a12b-19f7b9d141d1','','','H. Jaeger & L. Beissner, Die ziergeholze der garten und parkanlagen  ed. 2:6.  1884 (C. S. Sargent, Gard. & Forest 4:148.  1891)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c2cbf67-5ef6-598f-ac28-ff4904779c76','','','New Zealand J. Bot. 3:338.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40385764-a758-59a9-977b-74a5eae8bb4d','','','Saxifrag. enum. 2:35.  1821 (Revis. pl. succ.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb983888-249a-5a29-80c6-426ee09404ce','','','C. F. von Ledebour, Fl. altaic. 1:375.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d1f28da-9004-596d-aaf7-c7cb91e8635e','','','C. F. P. von Martius, Fl. bras. 7:125.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a95f15b2-0033-54ec-912f-2e6818314b57','','','Prodr. 33.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b3ef50a-92ca-53bb-ae3e-5de7add5f8e3','','','Nov. Holl. pl. 1:15, t. 12.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7f3e5b0-d199-5c92-b283-bb553bbef4d0','','','Sida 4:72.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec999ce3-ab5c-5ec9-9749-23a0f0568e30','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 74(2):166.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acdbf0cc-386a-51ea-adf4-6a74db0a2ba3','','','Ill. bot. Himal. Mts. 1(10):350.  1839; 2(9): t. 86, figs. a-c.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20a20a49-169d-51d7-ab27-2476fa30751d','','','Mem. Reale Accad. Sci. Torino 25:384.  1820 (Mem. gen. <I>Musa</I> 56)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a560a6a7-a30e-5ee9-8546-d2ab7d45664d','','','S. African J. Bot. 52:184.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('372de8be-d5f7-58ef-9597-c483f0ccda70','','','Cactaceae Consensus Init. 2:9.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c277e579-5a78-5f54-b5d7-7ba74d8c8ef6','','','Contr. U.S. Natl. Herb. 16:239.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('137f1bb1-231c-5126-adeb-49c127026eef','','','Blumea 18:18.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aad4084-e3fa-59e0-a222-bdb5a5bb7632','','','Hooker''s J. Bot. Kew Gard. Misc. 7:119.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20733f67-074d-5b39-84c1-9dfb2f2a96f0','','','Flora 17:76, t. 1.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52564d7d-14e8-59c4-929c-9a7fb01cd3b4','','','Gard. & Forest 10:184.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('217c2bf6-9314-5b77-bff9-6853d4bf8f3b','','','Proc. Amer. Acad. Arts 21:364.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91bf7ee5-bc03-58f9-9471-fbe2ca5a298f','','','Phytoneuron 2012-51:9.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbd1c052-1356-5976-a061-c579eb4afbdb','','','Ann. Sci. Nat., Bot. sér. 4, 1:76.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('243ebf65-a3d4-5c7a-9247-0ba1dc7976ec','','','Sp. pl. ed. 2, 2:939.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1de2225e-5ccb-5577-9eaa-4838e6aa0527','','','J. Jap. Hort. Soc. 75:2.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93f19aa7-6509-538b-9b96-89df68f94572','','','Pl. rar. hort. monac. t. 91.  1821 (F. E. L. Fischer, Cat. jard. Gorenki ed. 1812:8.  1812, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8c60880-26af-5ae7-9773-7fbbc91c8aea','','','Pl. asiat. rar. 1:49, t. 61.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2ebcc97-5c79-59e2-b68f-66e13ef7c793','','','Ann. Lyceum Nat. Hist. New York 2:217.  1827 (Acct. pl. Rocky Mts.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9be2d3f9-d891-5ef3-90ae-4726f13b80aa','','','Fl. plant. herb. chinae bor.-or. 6:291.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('411318e3-5299-59ff-9f2b-cf4a3404b838','','','V. L. Komarov, Fl. URSS 22:493.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc17797c-38ef-5e61-bac3-85a6aa3579d2','','','Kew Bull. 1953:95, fig. 3.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c65dcfe8-18c2-572c-b785-1b236ccbb667','','','Wochenschr. Vereines Beförd. Gartenbaues Königl. Preuss. Staaten 5:83.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc795347-d641-5c12-bb71-47d3d7c2a356','','','C. F. P. von Martius, Fl. bras. 3(3):427, t. 80, fig. 1.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93fb1573-e2bb-5be4-b927-da0ee31da1ec','','','Prodr. fl. Ind. orient. 279.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7ef7f54-9bb3-5e25-896b-456f3265a91e','','','Bull. Soc. Dendrol. France 38:30.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2efd6fe9-4eb8-5299-b6cd-ef71ff9887f2','','','C. F. P. von Martius, Fl. bras. 2(2):8.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5dbc25a-c84b-52f3-a96d-4de662f443e9','','','Enum. pl. 2:884.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('693d248c-b08a-5eab-91b0-03f4b484bc3f','','','Repert. Spec. Nov. Regni Veg. 20:284.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90b5cdde-4b8d-5e6a-ba90-8bfcf46c1f9b','','','Intr. oryctogr. Aragon. 158.  1784','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39874942-0940-5893-9bd2-0a72481294ee','','','Consp. fl. afric. 5:774.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69c59ef2-e825-58de-ac38-4588d40f9df4','','','J. D. Hooker, Fl. Brit. India 2:699.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea2cadac-b472-5464-b145-55451d5e4a40','','','Bot. Mag. 52: t. 2587.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de9c50fb-3dd3-55c3-bdf9-758bdd486a3f','','','Fl. URSR 8:266.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae70765f-db19-5186-8caf-7b47e969ec3d','','','Bull. Torrey Bot. Club 32:215.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57444915-c70d-5625-a3de-ecf3462dc58f','','','Syst. veg. 5:93.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42a3033a-6fe9-5d97-8b60-5b4bc46092a6','','','Mém. Mus. Hist. Nat. 4:246, t. 10.  1818 "<I>Mezonevron</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db9c9c5f-faeb-53de-963d-23de71406bb4','','','Fl. taur.-caucas. 3:267.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9be2610-cdcf-5067-9c2e-9c673c7920af','','','Encycl. suppl. 3:746.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('329038b3-b87a-5d1c-89f7-8ab643b9475f','','','Fl. Mag. (London) 5: t. 263.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9cec5f38-4510-5053-b464-b4007ca6727c','','','Bull. Torrey Bot. Club 24:296.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b70900f4-3d52-560c-b78f-f43621d2e134','','','<I>Oxalis</I> 9.  1781 (Linnaeus f., Suppl. pl. 243.  1782 ("1781"))','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d633166f-92f9-5395-95f4-3d0077d7beb8','','','Prodr. 543.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d0974e3-48f6-5966-a353-a30391bc41ac','','','A. L. P. P. de Candolle, Prodr. 9:318.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6afe6570-51a9-551b-a6cd-ac461b94b134','','','Fl. reipubl. popularis sin. 49(2):206, 309.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4fcc73c-2a76-5497-adc6-6fe2df1fdcb6','','','Fl. Pl. South Africa 22: t. 860.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5756f929-3016-5c0d-bf8b-7f60de1eeaab','','','Rheedea 1:72.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bee7a738-50fa-5e51-91e3-d950af50638c','','','Bibl. cult. trees 655.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe1361d6-3e12-58ee-903d-bd1eedbe089d','','','Bijdr. 669.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23543245-6eeb-520f-9952-264955be0769','','','Notes Roy. Bot. Gard. Edinburgh 34:52.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f130d4ca-bc09-5e59-9c52-58aef3d552b3','','','London J. Bot. 6:568.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d104a5a-39bd-5d5f-bdc1-9a11a3e45d87','','','J. Linn. Soc., Bot. 37:95.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9b1aec5-186d-5eb5-888b-de1a800c14c6','','','Flora 38:323.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('647cf7c3-36f1-5136-87e7-7f5da5ed88e5','','','Madroño 3:207.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c9c75ce-e742-5534-84fb-0592f6cadeda','','','Sitzungsber. Ges. Naturf. Freunde Berlin 1867:15.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dbe729c7-0690-5ffe-806a-a1927f1ec0a8','','','Trudy Prikl. Bot. 23(4):104, 137, 338.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfb1dbb8-5080-5018-b5a4-d9dfaf9b2273','','','Trudy Prikl. Bot. 45:25-26.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f77b184-dba7-53c3-b777-d2eeea20ae53','','','Cact. Suc. Mex. 27:16.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('959a7e47-e215-5f94-b86a-0ea8b7e59c45','','','C. S. Sargent, Pl. wilson. 1:169.  1912 "<I>microcarpa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19b30ea5-9a99-5ebc-93eb-20439e576b3c','','','Monatsber. Königl. Preuss. Akad. Wiss. Berlin 1857:48.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('512d78f2-8e9b-514f-937d-699fe785cf23','','','Man. fl. n. states 757.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('284e305b-ea3b-5871-951d-74d1568c7d9f','','','Bot. Jahrb. Syst. 25:399.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa337f45-ce6d-5f24-9db2-d49e1ac21f90','','','Prodr. fl. nepal. 198.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e59b5130-4baf-5e10-a5fe-3a872b2143e7','','','Sp. pl. 1:161.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dac5022b-383f-5942-a14b-27f35082dd8a','','','Revista  Agric. Trop. (San Salvador) 1:73.  1921 "<I>Rensoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8748bd81-a5cd-58ff-ad71-bec148ef3291','','','Hickenia 1:113.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67c72b81-5950-5b83-8503-27931caa000a','','','Bot. Jahrb. Syst. 36(Beibl. 82):75.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f72d7c6d-bbdf-5020-823c-c8aa1cf21f15','','','Flora 47:435.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5116098e-2c5a-51c4-8413-15b31af64101','','','London J. Bot. 4:592.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f80467a-07ac-527d-89e7-31cccce65ea7','','','Bot. Jahrb. Syst. 12(Beibl. 27):4.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8dc50417-d8ad-542f-bee9-602844f921fc','','','Rev. Hort. (Paris) 40:370.  1869 (O. Kuntze, Revis. gen. pl. 2:800.  1891)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b20edc3-3887-53c7-b248-8a397006f495','','','Med. Repos. ser. 2, 5:354.  1808, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('838f045a-112e-5fac-b663-0121837985ae','','','Meded. Rijks-Herb. 46:20.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66b1575d-88e6-5388-8447-f56bdca0dbcf','','','Fl. Neotrop. Monogr. 52:641.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cff7b11a-fdd7-55a6-974e-12cd4d6fb378','','','Publ. Carnegie Inst. Washington 504:154.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e95db1d-d8c7-528f-b9de-401e17e294e6','','','Syst. Bot. 36:384.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b25ffef6-18b6-575b-9dfc-7e35ec2c60a6','','','Trans. Acad. Sci. St. Louis 1:479.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30640b4d-c88a-53ea-8e71-c137c4efaca0','','','Mem. Reale Accad. Sci. Torino. ser. 2, 14:329, t. 8.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af7c1e11-0d50-562d-9fa4-5effa3002bc9','','','Syst. Bot. 11:128.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e34be84d-6d2b-53cc-baef-f323e827d68e','','','Proc. Amer. Acad. Arts 17:339.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e288f434-3105-53fc-80f4-50180a8e7619','','','Taxon 26:284.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56f903ae-9978-593c-8354-848fbb52ff76','','','Dokl. VASHNIL 1:46.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb0b5f9a-53b4-5373-aca6-ecbb5d2e03d7','','','J. Proc. Linn. Soc., Bot. 4:169.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfead542-cd7c-55b8-b439-912d1c6dbb5e','','','Cactaceae Consensus Init. 3:25.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3f134a2-78aa-5b27-9927-340ca6deb863','','','Gen. hist. 4:275.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36931802-f592-56b3-b021-783086cb7d8f','','','Cat. fl. Rif orient. 6.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39f0165e-f36c-5b67-8e94-402fd460d281','','','Gartenflora 28:289.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e2de078-27ba-5c2d-8297-2ca1023fc4f9','','','Trudy Prikl. Bot. 19:69.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56ff331d-a2ba-506f-a380-4e14480aac84','','','Notes Roy. Bot. Gard. Edinburgh 28:21.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1d0d544-1a02-51a4-afa4-7f94f9733b9c','','','Estud. tax. <I>Lonchocarpus</I> e <I>Deguelia</I> no Brasil. Ph.D. Diss., Univ. Est. Campinas 65.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('707c0b4c-3541-50a6-b966-42edcd8aeae1','','','Austral. Syst Bot. 13:34.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a023049-0cfb-5cb0-81c7-c9f9ee45df8d','','','Hooker''s Icon. Pl. 13:19, t. 1225.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d39ffeb-8671-5a42-b064-6c7e6d6c0c00','','','Byull. Vsesoyuzn. Inst. Rasteniev. 81:37.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5aa1ecf-d409-585e-a809-cfb006dea5a5','','','Prodr. 1:690.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d37512ea-2553-55ef-b358-4bdc461fc6ea','','','Fl. Würtemberg 437.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f367bc15-39bf-56cb-bac8-128f10234aae','','','Sida 20:1463.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f6b74d6-d30f-5262-aefd-fbed17e43f9c','','','Gen. hist. 4:3.  1837 (Wallich, Num. list no. 4414.  1831, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3247d4d1-3479-50c7-843c-36b41756457e','','','Gentes Herbarum 8:501.  1957','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b9e1bba-10ac-552d-8a92-74df8ea44a3b','','','Sp. pl. 3(2):1343.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('965ce0e0-7d48-505e-91ce-0fe5da5fa334','','','Aroideana 9:140.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b965b4e-a5c0-515d-bbef-a4396190fb70','','','Index sem. hort. petrop. 4:36.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2543e210-4c11-5ab6-a698-194f3a644212','','','Sp. pl. 1:343.  1753 "<I>flava</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('692704bf-d141-5541-bf43-d669b6027369','','','C. S. Sargent, Pl. wilson. 2:143.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85b9635c-544c-5d5a-8f0c-ef3c981ee2a3','','','Cult. Prot. 93.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de22f7e4-c288-57f9-b230-ddb9b8aeb2db','','','J. Bot. Agric. 3:82.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b38ba6f-e033-59cd-8046-6f1192ad7c92','','','Icon. pl. formos. 6:63.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52929f52-4509-5feb-8455-8d1bf56f0721','','','Enum. syst. pl. 37.  1760','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c1f5a02-f6d4-538c-a328-d32b824259e8','','','Fl. taur.-caucas. 2:325.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec33a5fc-cbee-51ca-8bcb-59985919eb36','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(3a):121.  1894 "<I>guilielmi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43a288d3-0e86-588f-b74c-15ecc4830bc6','','','Pl. Coromandel 1:43, t. 59.  1796 (non Jacq. 1760)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01334f5b-4e1c-5f2a-8248-599764527795','','','Rec. Bot. Surv. India 4:15.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e37aed34-af1b-5f4c-af7a-57a2389f27b7','','','Acta Phytotax. Sin. 16:73.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3c9dcab-dd47-580f-8ffb-9f02cd66930f','','','J. Linn. Soc., Bot. 26:507.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('30b8165d-8f06-5ab4-a4f2-c0e9ab626b59','','','Fl. cab. 3:113.  1839-1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d78802d-8389-5d58-a4ab-e0e64141c13a','','','Abh. Naturwiss. Vereine Bremen 4:197.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3f9b566-e2d0-5b69-bfa4-3edf6daec648','','','Linnaea 11:419.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31959387-cb63-5e8e-91d2-37aa9cf7760c','','','Kulturnaya Fl. SSSR 1:289.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb007a75-642c-5384-8016-34be0d7aa3e6','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 9:173.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8603b63-6533-5f55-93e4-bc9fd7e7e215','','','Bol. Soc. Bot. México 18:1.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6684faa-39eb-5a12-89be-7ab24edb61d6','','','Bot. Jahrb. Syst. 40:213.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcf89d0e-52ab-505a-a6e3-1340d5f9a3a1','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 10:180.  1887, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0e79569-947b-5473-b9b0-b26760011f7d','','','Fl. ind. 2:475.  1824 Mar-June','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b002f6b-235a-5179-9aec-4f51a8fe874c','','','Hort. kew. 3:353.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e599e455-daca-5643-bfb7-979e350e87f6','','','Phytologia 21:281.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10ec55ea-3625-5762-b823-f025f8e1f379','','','Fl. N. Amer. 2:194.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9774d80d-66f5-551f-b049-0e365986b658','','','Proc. Amer. Acad. Arts 24:375.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db5ad963-d866-56e6-ad07-ca251802cd8d','','','Strand-Steppengeb. Iber. Halbins. 110.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19b6ce95-97cb-5c05-9f6b-de6657b5bfee','','','Monogr. Cupressaceae <I>Sciadopitys</I> 346.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01e58b2d-3362-56df-b750-61fc9d56e4c7','','','Mem. Bernice Pauahi Bishop Mus. 8:149.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0a5126e-35ea-53ed-84b2-4b92347a4924','','','Fl. pis. 2:241.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7433c6d8-147d-590c-80ff-53f41f87c7b5','','','Methodus 424.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c68f17c4-a008-5713-b05a-9fcfd0eaaf02','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. ed. 2, 13:327.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7878374e-000c-57b2-84a0-04a894f58c8b','','','Symb. bot. 1:53.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2287b811-3ee0-58ac-bb9a-1d6ec433b2d5','','','Mém. Soc. Phys. Genève 1:420.  1823 ("1822")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('275f56b2-d140-5258-8c00-75729c9005fd','','','C. S. Sargent, Pl. wilson. 1:113.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('920e7b7a-2adb-5f0e-9717-ce19b7f809ec','','','Cat. pl. Boccadif. 65, 82, no. 18.  1821 (non Lapeyr. 1818)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('093e5a61-f467-55fd-97be-3e4055877406','','','Edwards''s Bot. Reg. 19: t. 1575.  1833 (non Poir. 1817)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ea5314c-79de-5a1b-b003-c0f0133c0467','','','Kew Bull. 18:526.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8860cff7-e887-563c-bb2e-1e0302dc12a6','','','Ann. Mus. Hist. Nat. 20:201.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6a1839f-59ed-539e-80ac-9fefb63de68c','','','J. Linn. Soc., Bot. 37:419.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25d1a576-cfa1-5ce4-8adb-27fc7c4f3584','','','A. L. P. P. de Candolle, Prodr. 13(1):230.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('137b2d5c-8e3d-5397-8436-fd9e1fe33d38','','','Prodr. fl. Ind. orient. 262.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9e97dc7-f4b0-5391-8ec4-dbdc2df182d6','','','Bull. Mus. Natl. Hist. Nat., B, Adansonia 11:316.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d6651fd-9a08-52ab-8f32-afcdd18c9fd9','','','Fl. bor.-amer. 1:30.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a15a487e-b1a0-5cda-8afb-00e2150ebe38','','','S. L. Endlicher et al., Enum. pl. 24.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5544825e-040a-530e-998d-061b08c30fb6','','','Observ. bot. 2:23, t. 45.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e6aab57-7398-563d-8bc5-0b2ffcb5acdb','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:53[folio]; 3:67[quarto].  1818 "<I>Beurreria</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da3a46c3-b573-59dc-892f-aec0de573802','','','C. F. von Ledebour, Fl. altaic. 3:204.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1806970-bd01-55cf-b72e-c8e705bc0937','','','J. Bot. 66(suppl. 1):115.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ac30804-c41f-5e19-bdf9-adfd9ce913ba','','','Prodr. 2:387.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01cbbcd6-ef92-5627-90ad-9e5fbb4e431f','','','Syst. nat. 2:129.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cff21a6-543f-555c-93d6-162304875386','','','Pl. hartw. 58.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60c5a18b-6736-5a62-a9ad-0fc6879bfc8e','','','Bot. Mater. Gerb. Glavn. Bot. Sada R.S.F.S.R. 2:135.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e60b52f8-db6c-5163-9c64-c5fd7b716ca4','','','Nov. Holl. pl. 1:75, t. 102.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90dc78b9-01fe-5fcc-b3e2-ad36e9176454','','','J. Arnold Arbor. 29:115.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8df3dcc-7dc3-5402-ae0d-b39e705d50fa','','','Pflanzenr. IV. 23Dc(Heft 64):16.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('671b2ecd-e395-5885-ba1a-ee8476ca78d5','','','Kakteen Südamerika 4:1394.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8135858e-e1a5-576c-b46f-367f3f401621','','','J. Proc. Roy. Soc. New South Wales 59:178.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12e0c935-81ef-53ed-b98b-40a04b3cfef6','','','Ann. Sci. Nat., Bot. sér. 4, 8:249.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('723d0068-ef09-5e14-89da-51d9077e894f','','','Bot. univ. 2:325(no. 3); 326(no. 12).  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3509a91-65cd-5478-bae0-e3ffe19a26a8','','','Ann. Missouri Bot. Gard. 65:1127.  1979 ("1978")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be94c19f-701b-5972-b250-c2eeaf3c70c5','','','S. Snogerup et al., Preslia 74:262.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f907af71-ab02-5102-ae87-361949028cb3','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 4:91.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2f027ae-1084-5cd9-840a-4dece84e6101','','','Prodr. 9:263.  1845 "<I>acuminata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8facbe6-da21-508d-97b4-d555d400ddf5','','','Bot. Misc. 3:373.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('decd9697-381a-5deb-b491-f97018c0549a','','','Vict. Naturalist 21:114.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fe3660a-06d4-53b7-af25-4882024c4e97','','','Bothalia 22:168.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('613fec7c-9ae5-51c1-af74-2ab15ccf2a3e','','','Encycl. 3:421.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d56da9e2-0a9b-5ef8-bc1f-540f66914764','','','Gard. Chron. ser. 3, 32:171.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25ca1f84-a028-5f2c-b8ee-c54f53092c78','','','Ann. Missouri Bot. Gard. 108:165.  2023','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc3c18b7-aa03-51b8-a518-2089641bc3b6','','','Revis. gen. pl. 2:777.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c88484ea-950f-5e6c-b43d-cba5be565304','','','Notes Roy. Bot. Gard. Edinburgh 9:139.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7eb2f621-cda3-5a8d-813d-712a15c7dcd7','','','Proc. Linn. Soc. New South Wales 92:265.  1968 "<I>pinonianus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ccf8330-4054-5fe9-92f1-fdee4f35102b','','','Phytologia 17:367.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4117c7ae-0b94-507d-a335-7d157ab4e19e','','','Prodr. pl. cap. 97.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37c1498e-bfbd-5b79-bec7-6bbd37bfeb86','','','J. Arnold Arbor. 61:109.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7a11651-1fb3-5523-9107-e7fa92694b10','','','Spisok Rast. Gerb. Fl. S.S.S.R. Bot. Inst. Vsesojuzn. Akad. Nauk 9:47.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8cfc3b6-94b9-5eb3-955d-a50759fc9c76','','','Syst. Bot. Monogr. 75:156.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcffc77f-7053-526b-aca8-5b4805d2bb64','','','Bothalia 8:12.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b22379e-5317-5d7b-9aa0-b5b9b82d7909','','','Trans. & Proc. New Zealand Inst. 49:139.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa94e628-9485-5557-80a2-e3daf7a3fbf1','','','Palms of Madagascar 176.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('128f29fd-eae1-5a92-8513-93f763ae305b','','','Pinet 155.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('859ab956-ecbd-5796-845e-ea59f059ea9c','','','Mém. Acad. Roy. Sci. Lyon, Sect. Sci. sér. 2, 1:235.  1851 (Pugillus plantarum novarum 24.  1852)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a9ac963-ac51-5ab7-86e4-b405a2807c26','','','H. G. A. Engler, Pflanzenr. IV. 129(Heft 53):439.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c248e74f-741f-5176-9f50-fbb0471e4cbc','','','Proc. Amer. Acad. Arts 8:169.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c6da578-1768-5985-9af8-fb4d87ef7fae','','','Brunonia 4:252.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1384caf-d4ad-56e2-afd6-5467238f01c8','','','Acta Phytotax. Geobot. 22:41.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('664bf8d0-597a-5259-91bb-7d9957046ec9','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 8:184.  1886 (Pl. david. 2:2.  1888)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8aa295f0-d05e-5fd0-8e6a-6f8e1e9ac521','','','W. J. Hooker, Fl. bor.-amer. 1:203.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5d2bf18-573a-520b-b368-86192139105f','','','Bot. Not. 120:98.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('867cfe4c-c3b1-5f78-a4db-4146fd67e538','','','T. A. Durand & É. A. J. De Wildeman, Bull. Soc. Roy. Bot. Belgique 36:59.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4eb1b702-a1d1-53b8-946c-f45092161370','','','Catalogus 77.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93ab9237-737d-50df-bfad-ebbfeca1c779','','','Pl. bras. icon. descr. 1:22, t. 15.  1826 ("1827") "<I>sagittato-partita</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7486bf1-9b08-5dd3-82f8-7c94c3305a9f','','','Revis. gen. pl. 2:597.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6dd6efc3-ddbd-51ca-9e4d-e6a1afc8c564','','','Allg. med-pharm. Fl. 5:1896.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c3736f1-aa69-56ff-be7e-74a26025731b','','','C. F. P. von Martius, Fl. bras. 6(2):333.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a3cb1f7-aa40-5e9c-b843-faa8122368a2','','','Trees & Shrubs Japan, ed. 2:227.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('491c5691-b3f2-5a04-8ddb-ec5c53ffdf88','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:190[folio]; 3:242[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8efa2b14-c41b-50c4-b809-fef2045ef9aa','','','Fl. austral. 1:13.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96ac430b-05b0-5613-a17d-431d44d2b343','','','Anbau Huelsenfr. 254.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82d401e4-44b9-5a76-81a2-3e42553e71c5','','','Linnaea 8:139.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fc3daed-dc80-5ab1-9dcc-e00fbd838212','','','Rhodora 10:80.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eee2e9af-6385-57ec-b667-be08d7ae9737','','','Fl. Kavkaza, ed. 2, 1:331.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d684dad-51e9-54c4-8853-7acbb1b66c23','','','Suppl. pl. 309.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9307a3fd-45ae-573b-9465-7d178f1fb99d','','','J. J. Bennett & R. Brown, Pl. jav. rar. 15, t. 4.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9961b6f7-286a-5617-a06d-c86ee703113a','','','Bull. Jard. Bot. Buitenzorg sér. 3, 4:178.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73afff75-d968-5474-a1e8-15647009abcc','','','Flora of New Zealand 1:360.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49d1956a-e05e-532f-af1b-10a720a44366','','','Allg. Bot. Z. Syst. 10:22.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fda7e49-c17a-5168-8ab6-1628fdc7e799','','','Great Basin Naturalist 45:408.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb8a70d6-a18e-5eb6-b059-31a9db7bc922','','','A. L. P. P. de Candolle, Prodr. 10:488.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c1f7a67-51bf-566e-88d7-7ba909e57d2d','','','Bull. Soc. Imp. Naturalistes Moscou 15(4):781.  1842 (Fl. baical.-dahur. 1:337.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0b13fb5-f6b5-5162-a203-ed4b11f926e4','','','Magyar Bot. Lapok 7:131.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a93a16dc-f6d1-573d-9db0-479b6ac917c9','','','Comm. legum. gen. 70.  1837 (Ann. Wiener Mus. Naturgesch. 2:134.  1839)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('333a2d54-7f03-59d8-a42d-cccaf9ff5975','','','Pittonia 4:226.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6404790-d19a-5b73-bb77-6136f4b76bdc','','','Mem. New York Bot. Gard. 74(2):120.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49ed6e3d-b15e-5742-9361-a7edcbcbb75a','','','A. L. P. P. de Candolle, Prodr. 13(1):435.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c790927d-1729-5804-b39e-c2d104e9a980','','','Kew Bull. 15:203.  1961, in adnot.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('024f93c2-d7dd-5440-b132-59e362a8de69','','','Diagn. pl. orient. ser. 2, 3:18.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fa0f2a3-4f3a-5be3-8d13-9774e0959954','','','J. Bot. (Morot) 13:257.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13fe2899-001a-5c7d-8f90-e103a11f31ab','','','Gard. Chron. ser. 3, 16:336.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c973f154-8578-53fd-9a4d-88379bbce27c','','','Repert. Spec. Nov. Regni Veg. Beih. 30(1):787.  1926 (Prodr. fl. penins. Balcan.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee1c0e12-355a-5f4d-81e7-602637e12fb1','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:54[folio]; 1:66[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3efaff3-74f2-53e2-833d-81a2ad563a5c','','','Preslia 43:185.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57ca53c5-9ee2-59ac-9c65-8b1b906a6a07','','','Univ. Calif. Publ. Bot. 81:63.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b83368e-301a-504e-8d6a-7ecfbdd8aaee','','','Muhlenbergia 7:9, figs. 3-4.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdc4b51b-a7f8-56ad-b87f-5a13ac2767b9','','','Blumea 51:29.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8ae76b3-46ab-51e4-83e9-b1a13e88d00e','','','Meded. Bot. Mus. Herb. Rijks Univ. Utrecht 80:298; Recueil Trav. Bot. Néerl. 37:298.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('229b3d88-3ee2-586e-8e26-862567cb87df','','','Repert. Spec. Nov. Regni Veg. 24:109.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('feb16e0a-1241-5d33-9903-a23fe68b7564','','','J. Bot. 23:347.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('046b4942-8818-5e02-8776-8a75dababecb','','','Autik. bot. 27.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e79f630-47e6-5191-8fa1-d8deff5e6126','','','Telopea 6:586.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dce43293-4f4b-5125-af8a-ab8513f75e24','','','Prodr. 354.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e748850f-3135-5cc2-9c98-dc78ee805d92','','','Kakteen Südamerika 4:1393.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bf0fb84-4920-5236-88b3-a6b1a6e8710e','','','Fl. Bras. merid. 1:178.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d308f85-11bf-5118-8229-303d793c0950','','','D. Prain, Fl. trop. Afr. 9:112.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2990e6f-49ab-5d95-b227-133ea36027e7','','','Bot. Mag. (Tokyo) 8:215.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6e4cf6e-231d-55d7-8d6e-d5754a59c114','','','Madroño 30:93.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cb79c26-78d9-53f8-89aa-c2f7023b4779','','','Sp. pl. 3(1):685.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9572db7d-5413-545e-96f2-b817ed8bacad','','','Fl. francisc. 298.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc93a31c-7b0f-5c99-89a8-f69000732738','','','Encycl. 2:61.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62d35ed7-eaa9-50c7-afd0-892691330046','','','Cact. Succ. J. (Los Angeles) 53:292.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ddf454a-a262-5871-97e5-f461d8ee66c0','','','Bot. Zeitung (Berlin) 4:276.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0d92253-5763-5a95-961b-8a9bfb1ea7cd','','','Bull. Jard. Bot. Buitenzorg sér. 2, 8:12.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc0f985a-0527-5766-91e8-09b5af563425','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 6:492.  1889 "<I>hügelii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4308d27-30ca-56ab-bf7e-2576e810253f','','','W. G. Walpers, Ann. bot. syst. 6:258.  1861 "<I>Bolbophyllum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84a39a0f-a5c2-5a89-979b-09a182f41557','','','Voy. Bonite, Bot. (Atlas) 3: t. 115.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59ea4380-0c41-5be0-8963-8bffab4431c7','','','Fl. ind. 1(2):153.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e095cbe-b654-5b83-b668-b8a2b301453b','','','Gard. Chron. ser. 2, 16:656.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39fdb1f7-cd56-554a-a5c4-4f2321d7b62d','','','Expos. fam. nat. pl. 2:300; Ann. Mus. Hist. Nat. 6:393.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdf2e7a9-f971-54be-a8b8-c579c4401811','','','J. D. Hooker, Fl. Brit. India 4:178.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17d8a5d2-d12d-57ed-aa80-1ac6508af9f8','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 16:280.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b49cd132-d7a5-5158-baef-b94046ac7488','','','Candollea 65:328.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f86c205-9103-5997-afd5-22c9782f9cc3','','','Hist. Fis. Cuba 11:113.  1850 "<I>cassinefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3d2130e-921f-527a-838f-461ba5d511c3','','','J. J. Bennett & R. Brown, Pl. jav. rar. 192.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a32c78c-190a-5c75-9bed-452590d17d17','','','Gartenflora 57:294.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4081a78b-01d9-578c-a1f0-1525a5bb5792','','','Bull. Misc. Inform. Kew 1895:289.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98aa5c34-d5fb-58bf-a087-1af31adc0596','','','Prodr. 2:259.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94789172-84a9-542d-b5c2-65c4a98444ff','','','Gard. Bull. Straits Settlem. ser. 3, 6:10.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e52bebd0-8594-53f6-b251-cbbc4269b124','','','Fl. austriac. 4:29.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76afdb78-501a-5baa-9f36-bf3662e7f989','','','Bot. Jahrb. Syst. 74:609.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('118fee55-ce20-5936-a094-5dee3f146928','','','Oesterr. Bot. Z. 29:251.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b794a0d2-45e4-5a69-a1dc-cbf171919e85','','','Prodr. 512.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4260ef1d-933f-5973-a483-5ba15f3ec22a','','','Bot. Jahrb. Syst. 40:304.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('671f7b64-a38a-50a9-9944-569fc4ad3b6a','','','Proc. Linn. Soc. New South Wales 73:164, t. vi, fig. 18, 28.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2baaabf-6059-5b8a-a1fb-bc12e7058bcf','','','Kew Bull. 10:59.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f035222-2270-59d6-aa99-db829b72e1f7','','','Taxon 70:968.  2021','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9b1dd36-e537-5032-9eb8-34a7ce4e9cfd','','','Fl. boëm. 3:88.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dec1070c-8be4-5766-8ae2-0ecc528749b3','','','Bull. Cl. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 15:376.  1857 (Turczaninow, Cat. Baical. n. 1064.  1838, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc3dda4b-316e-54c0-a7ad-55f941f58853','','','Nov. gen. pl. 60.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cce5c074-4035-5421-aec0-7c59b7ee5ee3','','','Enum. pl. Jap. 2:275.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48f817d5-5871-5c50-bf26-33d649f4321f','','','W. J. Hooker, Engl. bot. suppl. vol. 2: t. 2693.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79505a44-d806-5d07-bed2-ba2a5831ab2d','','','Bull. Jard. Bot. État Bruxelles 19:401.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f870342f-fa39-5302-a3bc-21f8abbb0653','','','Bull. Mus. Natl. Hist. Nat. sér. 2, 2:146.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a461199-2a8d-53c0-9be5-4603ffc6d57a','','','Prodr. Fl. Böhmen 3:507.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2daced1-95f3-504d-80d4-12e2e8ec462d','','','Naturaliste Canad. 116:47.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d08faaf3-d64e-59f9-b511-b2ccaec314e7','','','Tabl. école bot. ed. 3:31.  1829, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b542b61-2c2d-50f5-91fa-0962a1c8830a','','','Fl. New York 1:444.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a503722d-eccf-53a5-842d-a02a5058d307','','','Prodr. 10:174.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1342a68-2841-59b9-beb6-3a39b37b3b02','','','Bull. Torrey Bot. Club 25:260.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bc73837-2264-59d9-99e5-0bfd16d2147c','','','Ceiba 3:150.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e816111-591b-5d11-9c0b-9f8db529d961','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:353[folio]; 6:451[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d17c5831-070f-5302-a031-42babd699903','','','Rep. Roy. Bot. Gard. Kew 1882: app. 57.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8e1f5d0-d764-5c60-9243-72c5d0e3ecca','','','Edwards''s Bot. Reg. 30: misc. 30.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a97d395-96f1-5046-90b7-58fa93164a06','','','Kirkia 5:265.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba97ab89-75cc-505d-b943-7dfbe841e8eb','','','Bull. Jard. Bot. Buitenzorg sér. 2, 13:68.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10364340-305d-556e-80fc-226cab49dbca','','','Sp. pl. 1:138.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7be74cb9-bf84-59d6-b973-1c0ad1776f03','','','Bull. Bur. Pl. Industr. U.S.D.A. 27::76.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39ebfb0d-56df-52df-bc01-789110e206f4','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:262[folio]; 3:336[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a18fbacd-e6d3-5bad-9196-3b4fec7c4044','','','Kew Bull. 33:363.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecad542c-f934-5da0-ad7c-5c761333a72f','','','Cact. Suc. Mex. 17:48.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b1b12ed-ee3f-5590-9297-d28f9c4b7ce8','','','Fl. forest. Cochinch. 3: t. 285.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01b39702-5a9d-5c76-a7fa-822583b622f4','','','Annuaire Conserv. Jard. Bot. Genève 7-8:301.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d5fe6da-af9f-5eb7-aa82-64fa26cad02b','','','J. Jap. Bot. 57:126.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f5c4df7-05ee-5f0f-a5c9-5ed3ec91b589','','','Bot. Jahrb. Syst. 49:62.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fccd1fab-3ab9-5839-9157-04921877329b','','','Proc. & Trans. Roy. Soc. Canada 6:117.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5db5a6de-06fd-51e9-b562-2f00f4675e1f','','','Fl. bor.-amer. 2:83.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8647116-57dd-50b6-8d61-2404a207fe8f','','','Schtscheglov, Ind. publ. 8-1:404.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae55014f-7867-59f9-8a26-202478f4cb2c','','','Fl. Vermont ed. 3:210.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee95d2d4-d208-57de-bfb8-42faf19f287b','','','Phytologia 68:459.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1acede8-5fe4-5f9e-9dcb-48d267adf75d','','','Fl. Alsace 1:81.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c4d1c48-9128-512d-87e0-a18f9b485090','','','Syst. Beschr. Kohlart. 51.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22ef76fb-108b-56b3-85de-d76e6e1a621f','','','Anales Univ. Chile, I, Mem. Ci. Lit. 91:140.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e59368c7-06dd-554a-8329-81f259535c22','','','J. Linn. Soc., Bot. 48:278.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3484832a-303d-5c7e-9554-b4f8ebd2e19e','','','Fl. bor.-amer. 1:284, t. 100.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9e3923f-00c8-5ca6-8876-da9d78602f42','','','Svensk Bot. Tidskr. 83:86.  1989 (Greuter & Burdet, Willdenowia 16:443.  1987, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20bec390-88d7-56f5-b876-284db74b0e6f','','','Fl. iberica 3:353.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9924738-30d8-5b7c-8867-3bcac232d51b','','','Zoë 3:288.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0c7c457-adcf-5121-8f2c-84345e6dd81d','','','Proc. Amer. Acad. Arts 7:350.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9296163a-9fef-5b20-9fc3-fa53bee347e7','','','A. L. P. P. de Candolle, Prodr. 10:423.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('021ac93d-ac3b-5c4d-9188-94f8cf0c8d79','','','Lingnan Sci. J. 7:214.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb4f3378-1660-53e6-a745-f9b7cd1afe5b','','','Fruct. sem. pl. 1:171, t. 34, fig. 5.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84754adb-a037-51ef-ac11-2bb6109c16cc','','','Nat. Pflanzenfam. ed. 2, 21:217.  1925 (non Buch.-Ham. 1826)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a2e20f4-9cf9-55e2-ad42-d9d03d1bee2a','','','Bull. Herb. Boissier sér. 2, 4:1000.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8ff4fad-be80-5e22-9fab-f1c741d63f5b','','','Fl. Brit. W. I. 711.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb90e621-692e-5626-a055-31e56d58db6b','','','Descr. <I>Pinus</I> ed. 3, 1:39, t. 22.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb0b17c3-1791-5cfc-90f1-8fc1801167a1','','','Syn. pl. glumac. 1:101.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0de9174a-72e8-5b6d-9d89-4d582b2021ca','','','Fl. dalmat. 3:164.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5bc9e2b-7fb1-5f51-94cf-cb3978164fec','','','J. Coll. Sci. Imp. Univ. Tokyo 30(1):265.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c344be7-ae31-5cda-9667-f9394bf28f17','','','Repert. Spec. Nov. Regni Veg. Beih. 1:824.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c4c5844-3eb8-524c-9803-05a2a8cdabbb','','','Natuurw. Tijdschr. Ned.-Indië 23:214.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9293e95e-d3bb-550d-9d52-54e982e1d3b5','','','Ann. Lyceum Nat. Hist. New York 4:88.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d022544a-a131-5f1b-af1f-8069b355ef6c','','','E. D. Merrill, Interpr. Herb. amboin. 183.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e8528c1-79a6-50c6-9383-90853a64fe5d','','','Bull. Jard. Bot. Buitenzorg sér. 3, 6:227.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('198c1b96-2f67-5252-956b-f76df637c904','','','Gram. panic. 114.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bcc88b6f-0c8c-583d-9f7b-84707332b13a','','','Ill. observ. bot. 42.  1773','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e4e4999-1b2d-5347-9cc3-e9bfc777cf2c','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 21:144.  1903 (non Sm. 1804)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('874638f0-f490-50d3-aca9-bf8e76c4d565','','','Fl. reipubl. popularis sin. 39:193.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0862612a-f962-5a10-8f5b-7e76e133c6f3','','','Eclog. Amer. 2:50, t. 18.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a65a1a8-4ae8-5d35-a615-f9a9ccdc8b17','','','Publ. Cairo Univ. Herb. 5:69.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a67514bc-2233-510e-acc1-fcae468fb0c7','','','Bol. Acad. Nac. Ci. Republ. Argent. 26:272.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6bdbe31f-4042-518e-b953-ec6f1bc3d25d','','','Byull. Vsesoyuzn. Inst. Rasteniev. 13:74.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ab44e46-eaa3-5e76-b028-51827df4eb90','','','Repert. Spec. Nov. Regni Veg. 6:99.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3508eabe-15b8-5b40-a983-8ab970207899','','','L. Bailey, Cycl. Amer. hort. 4:1671.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f904954-56af-5ef1-a539-b540c80829fe','','','Nordic J. Bot. 6:742.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c818c1cc-c0e7-52e7-858b-7db166ce1425','','','K. Iwatsuki et al., Fl. Jap. 2B:8.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8702686-c2f1-5a61-95ed-dada47a090db','','','Ann. Mus. Bot. Lugduno-Batavi 2:76.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5698383b-d823-5e40-9f95-3f17fe9e0e4a','','','Sketch bot. S. Carolina 1:230.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99ed23a6-ed32-5aff-87b4-86c1db0bb9c9','','','Prim. fl. esseq. 153.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57bf1907-b56e-54c8-9e32-388665142797','','','Alpine fl. New Guinea 2:215.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1375fb0a-5846-5d62-abe7-6f21f481fc5a','','','Kew Hand-list of trees and shrubs ed. 2, 189.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('269f8169-f81a-5c8d-bfec-934f895c4543','','','Ann. Mus. Bot. Lugduno-Batavi 3:250.  1867-1868 ("1867")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90583943-fb5d-50be-8883-b542317c458b','','','Fl. aegypt.-arab. 103.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a6f96ca-675b-5a5a-b8cf-1eac7dd8de28','','','Index sem. hort. bot. berol. 1867(app. 1):6.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('916be9a6-ff4f-576a-83a6-04a1c344f797','','','Traité gén. conif. ed. 2:641.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4dc5f065-640f-5827-b307-58551360d00f','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 3:420.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19bddf82-91d1-55c6-ac51-26c0d5584ce8','','','Muelleria 1:131.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d54c21b8-5d57-54b5-9da3-ea617358b221','','','Syst. Bot. 32:195.  2007 "<I>lorenciana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fa2e5fd-aafd-5f86-bfb2-ebb479b5819e','','','J. Straits Branch Roy. Asiat. Soc. 75:153.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b154c09-ff38-5099-8d22-212c8b4d27fb','','','Gram. unifl. sesquifl. 190, 297.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82e6ab7d-20d2-55cd-8a7e-18b558612acc','','','Gen. hist. 2:355.  1832 (non Lour. 1790)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c4ece3e-b4e0-5ae7-9a3e-099915639444','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 23:235.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26ff0ac7-27c1-563d-a204-2de94e50c829','','','Contr. U.S. Natl. Herb. 16:121.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad36ba4c-6055-58e7-9dc5-c7b36014a75a','','','Fl. reipubl. popularis sin. 74:145.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd537aef-46aa-5003-b0c0-4d2df18b74ef','','','Austrobaileya 2:1.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dc45453-d3a5-56ea-9751-763c6ddb5dc0','','','Collectanea 1:102.  1787 Jan-Sep ("1786"); Icon. pl. rar. 1: t. 114.  1787 ("1781-1786")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b980fe1-d10a-518b-95f3-1da9e03237f8','','','Bull. Soc. Bot. France 44:148.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9b7064d-7333-5562-9687-7c129a0b8417','','','Liliac. 6: t. 336.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba5a5006-ef4a-5638-a56e-c0e4cd7548de','','','H. G. A. Engler, Pflanzenr. IV. 111(Heft 36):51.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4207b5d4-afc8-560b-8e7b-cec034d4ff88','','','Nov. Holl. pl. 1:25, t. 32.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ec72cbd-5d18-5301-a316-933ecbe9a636','','','Florist & Pomol. 187.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae39957a-a7b3-5848-887d-0df95d58dc9c','','','Proc. Amer. Acad. Arts 70:153.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5d08aa7-2058-5cf0-8829-ac43d2c58be7','','','Enum. pl. China bor. 13.  1833 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 2:87.  1835)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20f73c7a-3fec-5346-b448-160d14b98385','','','Enum. pl. 1:111.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40f7e2ac-df69-5b2c-9b2f-463c970ad83b','','','A. Rees, Cycl. 18: <I>Jacksonia</I> no. 2.  1811 Aug (W. T. Aiton, Hortus kew. ed. 2, 3:13.  1811 Oct)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0db46bf4-5436-5c94-b62e-dfa5c1c61c80','','','Compt. Rend. Hebd. Séances Acad. Sci. 1909:1651.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fc0b1f0-60d4-594d-9a08-939867d6fe71','','','Proc. Amer. Acad. Arts 22:466.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94123c14-303e-5249-a160-ecf7c0cb1bbb','','','Mitt. Bot. Mus. Univ. Zürich 213:148.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3c5da16-b435-513e-a59e-4cfb1676570b','','','Agric. Técn. 8(2):78, fig. 1-5.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cadc7df0-c553-5f83-843c-1f16e821ce4b','','','Observ. bot. 3:11.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b91564d-34fa-5627-b748-283f9286eca6','','','A. Guillemin et al., Fl. Seneg. tent. 1:9.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf92a16c-3f00-5fd9-83c1-00187a62b863','','','Syst. Bot. 30:772.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43f6fd86-6302-51e8-aa6d-b6553c28e90c','','','Sert. angl. 25. 1789 ("1788"); 15, t. 30 (repr. post 1800)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf60c25b-dae3-5a78-8a61-9bd9d9b933ac','','','Proc. Acad. Nat. Sci. Philadelphia 1848[4]:16.  1848 Mar-Apr (J. Acad. Nat. Sci. Philadelphia ser. 2, 1:165.  1848 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bce5c3a-fd07-560c-97da-d7374244ce64','','','I. Urban et al., Festschr. Ascherson 192.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ee983fe-5460-5f40-987d-03bbfb9e1790','','','Belgique Hort. 17:105.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04f63504-156f-59dc-bd43-77652e3a2340','','','Nuytsia 2:33.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('235bfa6d-2ea6-5fea-bb01-792f050daded','','','Bot. Gaz. 65:60.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa8a6a19-a005-5635-a0ba-c55d1712c53c','','','Bull. Calif. Acad. Sci. 1(2-4):140.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('086b142a-a10b-575c-a29f-cb12c59addf5','','','Linnaea 9:186.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6f6da16-acb4-5f63-8672-690885e1cda8','','','Cactaceae 5:2719.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1167db67-794a-529c-a07c-af66397f60bc','','','Observ. bot. 3:6.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afa519bd-5568-537e-9250-fdafc4b5fc00','','','Mant. pl. 2:305.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5dd8d7d6-c34a-5ad4-a39c-7d221a2271f6','','','Char. gen. pl. 66, t. 33.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('090242aa-6b48-5fbd-b2fe-8d3519dbd1b8','','','Bot. Mag. (Tokyo) 37:78.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21393f11-0ffc-57a4-91c5-c32e63e4c249','','','Philipp. J. Sci. 26:481.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b57f888-66f0-5095-80dd-ff5d114d90ad','','','Contr. U.S. Natl. Herb. 18:121.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc3d3b0a-e9a8-5cb5-8c63-9e72d231f8da','','','W. T. Thiselton-Dyer, Fl. cap. 5(2):322.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f11848b7-2ea0-5d5d-953c-bf57aba1fb8e','','','Fl. petrop. 16.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c8a5c49-69dd-5f21-a2cc-7dc0cbba2c20','','','Trudy Bot. Muz. Imp. Akad. Nauk 1:19.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bfc8d5e-5e7b-5b28-aefb-bf7e00eff2b0','','','Pl. asiat. rar. 2:40, t. 148.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a42fca5a-eaa1-5aba-96df-323ae3c98d52','','','Taxon 17:742.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00bc6b02-61dd-59cf-ba4e-93aa8373f27d','','','Sp. pl. 2:592.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('901c7bb1-5287-5fad-9d82-dc4f52ff13a0','','','Sp. pl. 1:556.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9c63c75-689c-59e9-9432-34abc3f63052','','','Fl. Ned. Ind. 2:193.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3102808-7bc0-5f44-80b6-2dbca15b42ff','','','Repert. Spec. Nov. Regni Veg. 34:144.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66727967-68cd-523c-b57b-cb74763bed67','','','J. Econ. Taxon. Bot. 15:450.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3c0de6c-0617-55e6-b71f-8a03ef8e59cb','','','Phillip. J. Sci. 60:234.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d51ffa8-19ff-5d37-9006-8f82f148a783','','','Bull. Soc. Imp. Naturalistes Moscou 17(4):736.  1844 (Fl. baical.-dahur. 1:495.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eada06fc-bc22-5459-957c-5d7a78354bc9','','','Voy. distr. diam. 2:439.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40fc8ab4-c779-5f41-9172-2d4f38407ee0','','','Flora 7(1, Beil.):130. May-Jun 1824 (Nov. gen. sp. pl. 1:43.  1 Oct 1824)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('127b788a-3f65-5fa9-a1bf-b168dc6add97','','','Pittonia 4:51.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa3cd43f-4d15-551d-a875-40152308370d','','','Fl. France 1:134, in adnota.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('363293c4-41cf-5c0e-b445-d90c42b118a9','','','Nomencl. bot. ed. 2, 1:292.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a04c0b1e-ae23-539f-87e7-50a515557071','','','J. B. von Spix & C. F. P. von Martius, Reise Bras. 2:612.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f8bf2e4-45a2-5653-998f-974d6c83fb6b','','','J. Bot. 25:173.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1adff875-5665-53a0-a849-20dec420a313','','','Torreya 1:26.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('daad9dab-07e8-5b62-861b-90ed1b4971fb','','','J. G. C. Lehmann, Pl. Preiss. 1:266.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a0d768e-a490-53e0-aeab-6b382a788fd9','','','Ann. Mag. Nat. Hist. ser. 4, 3:203.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8645f865-0b7f-518f-93b6-956b929b1211','','','Suppl. pl. 154.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5e0c4c4-848d-55c8-b8cf-047a6e546458','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 7:149.  1884 (Pl. david. 1:339.  1884), nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('560f7dc8-f20b-5bf1-938a-44f8bb6d3619','','','J. Acad. Nat. Sci. Philadelphia 7:41.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('386430d3-d87d-506c-8165-fe3e8fa2e173','','','J. Fac. Sci. Univ. Tokyo, Sect. 3, Bot. 6:221.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4eee206-f8d2-5585-9d7f-15f23484a61b','','','Gard. Chron. ser. 3, 9:552.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18a94fba-441d-5fd1-892a-38d6e84973d8','','','Jahrb. Deutsch. Kakteen-Ges. 1:104.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7f3b1aa-6da5-5c16-a543-a80fe7bc863d','','','A. L. P. P. de Candolle, Prodr. 8:167.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90150384-7ddf-5bbc-9cbc-048d140ab801','','','Bol. Secr. Agric. (Porto Alegre) 100:36.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f77cb54c-d535-5f66-9ddb-66a356e30146','','','H. G. A. Engler, Pflanzenr. IV. 147. II(Heft 44):71.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60c62b83-6a4f-5a75-af8f-886f99343f4f','','','Bull. Misc. Inform. Kew 1920:134.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea2badd2-c335-588a-a594-a112b587e0ae','','','Oberm. & Immelman, Flora of southern Africa 5(3):27.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('290ac7cf-51bd-5498-a7d8-1f1b46265a14','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 22:31.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5d40e49-dcb8-52f6-9e0a-84bcb20966ee','','','Macoun, Cat. Canad. pl. 5:396.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e084c955-3ea9-523d-998b-c82eefd702c8','','','Hist. nat. palm. 2:51.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2259917-89f5-5472-883a-1dc0819cdd9a','','','Fl. jap. 2:19, t. 110.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe7140b4-8893-57bb-aeec-9b33a9ac7da6','','','Hamburger Garten- Blumenzeitung 19:30.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f302a10-599a-5db3-a824-9b1f79f3d538','','','Věstn. Tiflissk. Bot. Sada ser. 2, 3-4:7-8.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('920fff76-5786-57aa-9654-513031d9ff0c','','','Bull. Jard. Bot. État Bruxelles 25:94.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95ce0174-bdde-52ab-8fdb-ed089bb4fc8a','','','Proc. Amer. Acad. Arts 42:13.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ded1a0c0-e67f-50e9-91e4-048f063edb84','','','14:332-334.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8747fae1-5c1a-5fff-b33e-3eddfe44f5c9','','','Madras J. Lit. Sci. 5:13.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09c7acf5-9fdb-559f-9bac-d29056a1704a','','','Handl. fl. Ned. Ind. 11:136.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0182f47-55d8-5403-b936-717f8528e838','','','Hist. nat. palm. 2:45, t. 41-43.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6bab9891-fdaf-56a7-893a-facbfef2c0f3','','','Contr. fl. Sierra Vent. 68.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10f61384-a115-5c40-af1d-b30f629ae362','','','Orchidee (Hamburg) 26:62.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57c549e8-9ff5-5611-afb3-ca976d9032b4','','','Cact. Succ. J. Gr. Brit. 27:57.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a412e1f9-65a4-50dd-a02e-e75f3dec8bfc','','','Blumea 8:193.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a853dfd9-ad92-5bbe-ae6d-92fc65692e08','','','Fl. nouv. caled. 4:161.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c440b4d-725b-5d05-acaa-2912f455b85b','','','Syn. fl. N. Amer. 1(2):445.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e85fd4e-0de6-5169-bc9c-a68c344d0b80','','','Fam. nat. syn. monogr. 4:223.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19286a75-2a7c-53c7-8f41-422b1af10dca','','','Bull. Misc. Inform. Kew 1928:247.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11cb647b-9088-59f0-a367-48e6498f76fc','','','J. Bot. (Hooker) 2:93.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6fc805b-69ea-5fd7-bafe-89db218220e7','','','Bull. Misc. Inform. Kew 1926:477.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('526cc541-2b10-520e-806d-7bf08a40e612','','','Ann. Jard. Bot. Buitenzorg 13:303, t. 26.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c468dd68-5457-55c8-ad25-0aedd4e75077','','','Bot. Mag. (Tokyo) 31:27.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a313fb3-a0ba-534f-be04-163d7e781f7e','','','Fl. Chile 2:190.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0aa5819-6792-5c0f-8f6d-48fd62a138b4','','','Trudy Prikl. Bot. 18:554.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3795643f-e9df-5ba4-927b-615946361638','','','Ann. Lyceum Nat. Hist. New York 2:248, t. 4.  1827 (Acct. pl. Rocky Mts.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56f8e967-0975-5f77-9b1b-e4a9b7b78d86','','','Notizbl. Bot. Gart. Berlin-Dahlem 8:51.  1921 "<I>Pithecolobium</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58f545be-d93d-5c69-9a2b-610695b94b04','','','Encycl. 4:504.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b357ff71-9bb2-509a-b356-9a742e548c1b','','','Hist. pl. Guiane 260, t. 102.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56ad949a-6bd3-59e9-816c-d1520b3b145d','','','Agric. Ledger 5:45.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50cb27c1-3b8d-52ba-87df-d835411d6a5c','','','Prodr. 8:336.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27f5f9b9-60ae-5a01-a5cc-4bfea14109e7','','','Not. pl. asiat. 3:342, nomen; Icon. pl. asiat. 3: t. 321.  1851 (non Sw. 1799)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('faa606ee-2cca-582a-ac45-09362ab64eb5','','','Bot. Mag. (Tokyo) 26:166.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0869778d-d3c1-5b8e-95aa-04a031a4be7a','','','Willdenowia, Beih. 8:93.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39a7c8e5-93c6-5aa7-a71a-7fc121113426','','','Möller''s Deutsche Gärtn.-Zeitung 24:27, 2 fig.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('132f7362-cb8d-58a1-8a9e-91ab0dd3c1cf','','','Fl. flumin. 306.  1829 ("1825"); icon. 7:105.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c9efdb2-7ba4-5e07-b74a-b7f9ba17759a','','','Dendrologie 1:598.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6dab790-b2c0-50cb-8411-29863309007b','','','L. H. Bailey, Stand. cycl. hort. 4:1968.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fed817ac-cbdc-5220-a8e2-91f1f13c6ea8','','','Fragm. 1:82.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2ab7db1-b178-54b8-a9c2-5101fea440ad','','','Phytologia 55:8.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fd48616-c9a3-5a9a-b215-f3115650970b','','','Trees shrubs Japan rev. ed. 642.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dfbffd7-c507-5d4a-ac20-9f538faef329','','','Bull. Jard. Bot. Natl. Belg. 47:310.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8bdb0c6c-016d-5760-a7c4-74f869b98e64','','','Fl. Hongk. 138.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f4dab42-d0b9-5558-8c3a-105690dff087','','','F. A. Wislizenus, Mem. tour N. Mexico 106.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83bc92d5-f85c-558c-8486-e09739ec7fa1','','','J. A. Murray, Syst. veg. ed. 14:211.  1784 May-Jun (Fl. jap. 88.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa7b416f-b42a-5c9e-8050-7933263bd6b5','','','J. Bot. 11:167.  1873 "<I>christinae</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eba8e059-48a6-54b3-88db-6ebad64dedad','','','Man. s.e. fl. 1138, 1508.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('065b6471-4be1-5bba-a8f5-ab2c53563744','','','Prodr. 16.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e526309a-f65a-5e08-b40c-5eaa25eed3cb','','','Gartenflora 35:565, t. 1233.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e78a9ed2-f831-5a04-a577-19a05db1ada7','','','Nuytsia 7:93.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea92b4a8-2c01-58b6-ba09-5232301b870a','','','J. Straits Branch Roy. Asiat. Soc. 75:16.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be4aa9ad-c31c-5c96-a023-0dd1e93ee126','','','Paxton''s Fl. Gard. 1:63.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f93c0b89-81ef-548a-8f3f-f1fe8e4864bd','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 27:502; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 11:266.  1882 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('188344d3-fcfa-5aa5-9b84-c444fb9fb33c','','','Fl. ind. 1(2):41.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecf03916-da3d-5e0b-8e7c-094fb3e6a403','','','Edwards''s Bot. Reg. 15: t. 1299.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0b707cd-5b8e-51a2-80e0-a380a71ee1a6','','','Pacif. Railr. Rep. 4(5,1):84.  1857 ("1856")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d4abcb4-2d57-50a7-86d1-9fdfc5628fed','','','Mem. New York Bot. Gard. 21:87.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c055f79-a650-56bb-b7c8-9e4dae177915','','','Kulturnaya Fl. SSSR 2(3):44.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ec54660-eb7b-5ed3-b10e-9200cc8bf06a','','','Philipp. J. Sci., C 5:118.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7eae229-5ad0-5c59-a043-285add37ae38','','','K. B. Presl, Reliq. haenk. 1:216.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7112efd-02d2-5709-b9a9-f1e91210c4e1','','','S. African Gard. 24:101, 106.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebd89881-b7ac-5531-b11b-17347a12be13','','','New plants for 1897:18, 20, fig.  1897 (Cat. Orchid. 44.  1899)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fbfe336-a919-5178-b914-1f533b3310cc','','','Ill. Handb. Laubholzk. 1:396.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6af6494-6ddf-5b7d-a95e-3d53089c98dc','','','Ann. Missouri Bot. Gard. 57:243.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b52da6f0-11b0-56d6-9661-cc8be0ec98f0','','','Anales Soc. Esp. Hist. Nat. 10:255.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1e5dd7b-2629-5d57-8eb1-ba7a7287e3c5','','','Notizbl. Bot. Gart. Berlin-Dahlem 13:635.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41a86665-5139-5754-9bf4-ee2db76915f4','','','Syn. fil. 157.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6884dc56-cdec-5d97-8a43-0c366aea0d35','','','P. E. Boissier, Voy. bot. Espagne 2:450.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8ef0c7b7-297f-5bce-b475-741c9e8116fd','','','J. Chosen Nat. Hist. Soc. 2:91.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42e95106-8171-58f4-9d22-600b66b43d09','','','Pl. delavay. 113.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81789536-97f4-54c8-97ab-853fef50b6af','','','J. Jap. Bot. 63:159.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93ac77fc-60da-5216-bada-0b8265f20d51','','','Sida 21:210.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aad24e66-49d1-5330-a94b-2dd696fe3dca','','','J. D. Hooker, Fl. Brit. India 6:468.  1893 "<I>didymophyllus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49135802-0ad1-582e-924d-23fe01bdcdbc','','','Fl. altaic. 2:44.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c65ba50c-e1d2-56f6-871f-cbf177e0970a','','','D. Oliver, Fl. trop. Afr. 1:400.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3efe2883-77f7-5848-a351-f7bec6016c9e','','','Prodr. 5:125.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a4fd531-730f-59ec-bd1d-bb669602601f','','','Excursionsfl. Oesterreich 80.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c51ca5e-a394-56d8-9808-2e7d23a1ee35','','','Arch. Jard. Bot. Rio de Janeiro 3:231.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2f0d174-bbcd-5baf-9037-d15e02a5f5db','','','Proc. Amer. Acad. Arts 37:469, t. 1, figs. 12-14.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9185dbe9-6d17-51dc-8b3e-e0e262019136','','','Linnaea 22:811.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cd8cb93-48d2-5912-928d-9936c6117c24','','','Opera Bot. 88:32.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d82d21aa-cbe9-5412-8aae-ed3d6a65d76c','','','Fl. Neotrop. Monogr. 76:252.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b20ea240-2762-52a0-a557-d0be57b1dd92','','','Z.-Y. Wu & P. H. Raven, Fl. China 12:266.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7800801-f013-5996-85c2-f81e8c9a1c01','','','Philipp. J. Sci. 15:256.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('553bfdd9-ff58-5856-88f0-b3edb1f4f029','','','Gard. Bull. Singapore 55:134.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05b64e5e-5571-590a-abd5-a026eaf31e53','','','Amaryllidaceae 118.  1837 "<I>bredmeyerana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b565f50-43e2-58d9-b77b-2dd7b1c5a6d3','','','Mém. Mus. Hist. Nat. 19:221, t. 2, fig. 5.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af1cfb8d-9975-503e-87ef-6c54019b7c44','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 18:398.  1873 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cfde4fe-22ea-53a3-8bf0-82d0e27784d9','','','Bijdr. 554.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12c3a870-b97a-5a27-995c-e44ac8d5858d','','','Icon. 5:52, t. 478, fig. 1.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76a4ed82-7c43-5006-9353-0cc722149e15','','','Collect. Bot. (Barcelona) 21:76.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('939ec187-4d01-52b3-b0ba-a725f7a374cb','','','H. G. A. Engler, Pflanzenr. IV. 23E(Heft 71):132.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca4caabb-1967-52c6-ac06-5ad3851767dd','','','Diagn. pl. orient. ser. 1, 7:74.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e68fb47d-8eed-5dfa-aa3e-b6a893900b21','','','Fragm. 10:61.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f17284dd-14ef-5854-aa36-8fcb9c83309d','','','Encycl. 2:1.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e4d50ba-a7fc-5286-bd5f-329f59184200','','','Sp. pl. 2:797.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de5147db-44d8-525e-9344-627bb6e09b66','','','Britton & Rose, Cact. 2:157.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86571ee4-37ca-5dbe-990d-9ba2e712397c','','','Pl. eur. 1:78.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8c3dc7f-70ca-53ba-825d-9065aa3268a2','','','Fl. Malay Penins. 1:117.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ae81c34-f1bb-5ee2-97c1-f39221f0d666','','','Syn. pl. glumac. 1:383.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e192122f-ddef-5774-9f29-14b82e4db612','','','Bull. Bot. Res., Harbin 11(3):33, t. 2.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e61371f-6050-580c-a7f0-fcc7522fb8af','','','Trans. Amer. Philos. Soc. ser. 2, 24(2):186.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ec6d18f-75a3-5c5c-8c3d-d1f2dff18ad6','','','Ess. Agrostogr. 90, 149, 159,  t. 18, fig. 2.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d08917e-95e1-5b7f-8721-a9cce8a1d939','','','Sp. pl. 4(2):683.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82a8fa97-afd2-5a95-be7d-84c1b8daeb06','','','Adansonia 6:222.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d40eaaf8-89a0-5d08-b77e-37cdb07f1372','','','Acta Sci. Nat. Univ. Sunyatseni 47:129.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10a50019-45ea-5601-bbbd-6153c0c9ff22','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:63[folio]; 6:78[quarto].  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bfe73ea-6055-5c8f-a84a-09b451acbe28','','','Bull. Torrey Bot. Club 32:209.  1905 "<I>Pentstemon</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8badeb23-437c-587b-922f-3c268476ca67','','','Stand.-sp. nom. conserv. 29, 63.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b801e7b-fc62-5de3-b283-869eb957a800','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:301[folio]; 3:386[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6eb34691-fc73-558d-bcd8-eddf0fa11d9e','','','H. G. A. Engler, Pflanzenr. IV. 228(Heft 90):129.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebd35ba3-7194-5b29-be8b-7e60a6ca0e2b','','','E. M. Durand, J. Acad. Nat. Sci. Philadelphia ser. 2, 3:91.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f25505db-807d-5634-9e16-3829f9c15ed6','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:177[folio]; 3:227[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fec2bc6a-6a17-573a-86e0-08eba30b79c1','','','Acta Horti Berg. 4(5):12.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66354f3e-fbef-57ae-ad70-20359083357d','','','Ann. Sci. Nat. (Paris) 9:420.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c416ffb2-2775-5117-b37d-7d2ad7e09f2d','','','Grasses of Japan and its neighboring regions 503.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1bcc2c66-0c9b-51bd-9ac6-079993cc6489','','','Mem. New York Bot. Gard. 35:655.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7a2f780-1dcb-5f69-9311-32e31db10dd7','','','Man. pl. Transvaal 2:xxxv, 421.  1932 (non Harms 1911)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('69ee1c6e-cbf9-51b4-bbfe-a420d2c3b7d8','','','J. Roy. Hort. Soc. 84:327.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edf9b909-d232-5704-a03d-f6eb8665323d','','','Fl. austral. 1:429.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e37528a8-44b0-5b23-b773-81558535b977','','','Trans. Linn. Soc. London 20:212.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7b883f8-9918-52e1-8c06-b9e06d9b51ae','','','Bull. Torrey Bot. Club 49:252.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70175e4a-5c1d-50e0-ab79-0fa0e3b9776e','','','Syst. veg. 2:796.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd0600d7-3221-59aa-a413-abdd929dbc2e','','','Gen. sp. orchid. pl. 157.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72fa3448-eca1-51f5-aab8-7cdb251d288f','','','Bull. Jard. Bot. Buitenzorg sér. 2, 13:67.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('802d225a-c39f-5bb0-872a-a0b0d22738b6','','','Hort. berol. 1:229.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6f12600-83d5-5af4-953b-88a40ca33ade','','','Fl. reipubl. popularis sin. 67(1):158.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1f234b4-82a9-5481-b51a-0416f06b686c','','','Philos. Mag. J. 66:282.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08d549c4-f861-5630-a5cf-fd392d006ee6','','','Bot. Jahrb. Syst. 39:240.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7001e3b-8868-5f6b-8c08-e4169bb96543','','','Prodr. 3:267.  1828 "<I>punicaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3bdab2d4-e44e-51a9-ab8c-7a6cd71d965b','','','H. G. A. Engler, Pflanzenr. IV. 20(Heft 38):311.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('799dcf59-001b-5f80-ad12-39618331171a','','','Byull. Moskovsk. Obshch. Isp. Prir., Otd. Biol. 74:76.  1969','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('125fa838-ecb2-53b6-8f72-e62731ec0860','','','Cact. Succ. J. (Los Angeles) 5:489, fig. s.n.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('322127c4-5cf9-56ef-813d-d8b4e12f5a01','','','Kew Bull. 37:60.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fe164ed-50d4-5292-8d10-86c42030d216','','','Trudy Obshch. Estestvoisp. Imp. Kazansk. Univ. 9:202.  1881 (Mater. fl. Permsk. Gub. 2)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c90552a-f29a-5ab4-b08a-0ffca1df54bf','','','London J. Bot. 1:495.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('afdd7e62-c836-50e0-b53e-172a5a65f17c','','','Bot. Mater. Gerb. Glavn. Bot. Sada R.S.F.S.R. 4:18.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ecad37f5-f24f-51a5-8f73-43116a074715','','','Prodr. 2:260.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca711cf5-0b15-52c0-814f-ea186d9a6d62','','','Fl. lapp. 272.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab7a9164-95cb-52e2-b90f-dca12da16d01','','','Bibl. cult. trees 254.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8e859d1-5006-5add-b845-1412fab713f3','','','Bull. Torrey Bot. Club 44:345.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d262c69-0aa3-5201-b66b-6619e16b8699','','','Sp. pl. ed. 2, 1:131.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33ef6d6d-0fef-5088-bca4-1dbd48778145','','','Telopea 4:38.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ced13c1-fbb4-566f-9802-176b5f007d89','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. ed. 2, 18a:117.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f4932a5-9d4d-55cd-b24e-553213b9dc67','','','Enum. Philipp. fl. pl. 1:53.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b716dfb-2106-5c44-9742-df314d5feaba','','','Notes Roy. Bot. Gard. Edinburgh 10:83.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b2e9ed4-5037-522b-aa45-bf7240e5b1ec','','','Fl. aegypt.-arab. 80.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3c242c7-8ef4-5dd4-975f-b81a3eb4e906','','','Natl. Cact. Succ. J. 33:8.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ae4846f-19db-5297-934e-ad0f8fa3527e','','','Fl. austriac. 4:2.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4edf4c47-bb31-59b2-8b80-8e8bc42d96ec','','','Bot. Taschenb. (Weber) 60, 447. 1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c7a7b9b-64fc-5d20-a9f2-81916c2c4dfb','','','N. L. Britton, Man. fl. n. states 577.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e548b7dd-4d2b-5f94-9894-cfc6fbdf0948','','','Rep. (Annual) Missouri Bot. Gard. 22:49.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9c4f7f4-183a-5ece-a250-c0d295db59b3','','','Observ. bot. 3:41.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fdd4294-9c45-5b95-8cd4-a3e784a8eba2','','','Hist. nat. palm. 2:115, t. 80, 81, figs. 8-17.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('363f3b83-319d-543b-ac3d-e57d1294bed5','','','Bot. Mag. (Tokyo) 27:151.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fc03066-109f-5c3c-91a0-375a6d3a6819','','','Biotica 12:149.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8a3153f-386b-5d09-9c45-f46e5859e5a4','','','Verh. Batav. Genootsch. Kunsten 12:15.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('530238b6-a670-5944-949a-603e136b8ca6','','','Trans. Philos. Inst. Victoria 3:55.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3631661e-fc7b-5af6-b979-42364dc44cee','','','Interpr. Herb. amboin. 466.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce58c0ff-1f64-50f7-abb0-0876e620ce2a','','','Bothalia 13:431.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5b63fc2-fe97-5e64-86eb-50292627d1d3','','','Monatsschr. Kakteenk. 18:70.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fdbfb31-0380-5908-b19d-fce5eab4b977','','','Mant. pl. 1:125.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea5a2b0f-ec99-5d16-8696-78aba672db09','','','C. S. Sargent, Pl. wilson. 1:243.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('321e2c3f-2504-5626-9d7d-8b8c436e5040','','','Adansonia sér. 2, 5:227.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18218dbe-6c1d-518f-84e8-610e3cb676f4','','','Bot. Zeitung (Berlin) 23:146.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('987acf29-027f-59ce-8c92-f1771f73bff8','','','Byull. Glavn. Bot. Sada 49:58.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9554550-e645-5a9b-ba86-2d5c20617ad4','','','London J. Bot. 2:581.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f5d62c4-bb12-55de-9313-e6c882e6e8d3','','','Abh. Naturwiss. Vereine Bremen 2:20.  1869 ("1871")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae453307-d276-51be-8a69-b41933be6e9a','','','Diagn. pl. orient. ser. 1, 8:117.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ddb0113-9195-5b94-a14b-b5593652d809','','','Fl. atlant. 2:69, t. 148.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('822fd16a-b255-5424-a25f-6c216a2ec013','','','Scroph. ind. 49.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4790213-6c2a-54b9-afee-556ce411cd92','','','J. S. African Bot. 39:3.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5151465e-b196-5494-99c8-e00dc121d725','','','C. S. Sargent, Pl. wilson. 2:304.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ddf8638-2653-564a-8053-c7b48d65e65f','','','Prodr. 1:615.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80a1df80-ff2f-5ecf-9761-92201e551a51','','','J. Franklin, Narr. journey Polar Sea 737.  1823 (Bot. App. 9)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('938d4c9a-3239-5052-8a29-ffb0f4d72db0','','','Rheedea 5:93.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3291b135-319d-527e-8f36-f847a2d7a6e4','','','Hooker''s Icon. Pl. 14: t. 1317.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5edeb3b-6746-5898-8ebf-024717478dcc','','','Proc. Amer. Acad. Arts 19:48.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52c628a0-c574-5884-8961-52252de8f667','','','Anales Mus. Nac. Montevideo 1:50.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d2b6e88-1e7e-54d3-8ab1-2d13de81d945','','','Bot. Jahrb. Syst. 54(Beibl. 119):6.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7dc767f3-6b46-5973-becf-7b777f5e9dd1','','','Proc. Amer. Acad. Arts 8:377.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('793a4ea1-a58e-5875-b435-871b8033a01d','','','Novosti Sist. Vyssh. Rast. 10:34.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7cf6bf3e-a114-5609-93c2-2933c4849b03','','','Bot. Mag. 99: t. 6056.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c457784-5062-55fd-9fe1-f88074581b7a','','','Bibl. index N. Amer. bot. 166.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bedc1133-28a5-5bab-969d-e9ec2cf065c4','','','Philipp. J. Sci., C 13:149.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22635be4-1c9c-5718-9a62-35bbbb0a042c','','','Bothalia 7:142.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96917285-4ebe-5127-95d8-ad8f05e06472','','','Ann. Inst. Bot.-Géol. Colon. Marseille, sér. 2, 6:227.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b75ed31-f522-5b78-8eab-696ec779abd3','','','Prodr. 5:631.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8534d98c-5301-5d98-99f0-32011f15f059','','','London J. Bot. 1:513.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e263b1c5-2aac-5b27-b85c-b408ed0dfd74','','','Vorles. Churpfälz. Phys.-öcon. Ges. 2:382.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89b53003-0143-5e43-82a7-082851aef352','','','Reinwardtia 6:279.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c81b1bb4-ae5e-5af8-b332-e5108f81fd6a','','','Aliso 4:109.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f2de2565-911f-5819-ad31-65f322b087b1','','','Ann. Rep. New Jersey Agric. Exp. Sta. 27:293.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d96cbd2-52ed-5492-b08e-da5d36bd2012','','','Gard. Bull. Singapore 36:135.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('217f8b4d-8f04-5a97-a972-915e89a73589','','','J. Jap. Bot. 5:17.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5229fe03-8eda-5e15-907f-9c05e380fe08','','','Bot. Reg. 12: t. 983.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5622ff3-e386-5d80-a47e-7de52b29d5b6','','','Fl. flumin. icon. 10: t. 117.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cd7a216-67bb-5ec8-b05f-5001f2e082c1','','','Madroño 11:159.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f6529f7-6a0a-5e1b-bbcc-e4adc5de76bc','','','Fl. pedem. 1:151.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0610868e-7952-5f82-8f95-4cdb88693838','','','Enum. pl. 491.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d845d190-934b-54e1-913b-004345e57e2e','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1903:165.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52d1d19c-abff-5154-bc52-055c35ff1e88','','','Ark. Bot. 22A(3):4.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cbdd368-a34c-536f-8da6-8c45a2aca8cd','','','Gen. <I>Lavandula</I> 294, 390.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff766a36-f82c-512f-9d06-5db27f78feaf','','','Phytologia 70:93.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eb88e718-17c3-5b92-837e-84f68930d315','','','Canad. J. Bot. 49:1216.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f85d2729-4aba-56ab-942c-edf4e93aacfb','','','Edwards''s Bot. Reg. 22: t. 1850.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aab9739a-8f1d-57a2-b890-bf895c79313c','','','Bot. Not. 129:167.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28ce1e5b-cf9f-5d8e-9dbb-a115f76a1faf','','','Prodr. 7:48.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64e4e82c-a77a-5445-86cc-94ffcf1ae51c','','','Bartonia 14:34.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cfb6eae-7bce-5950-961d-82ada5aa6f5d','','','Font Quer, Iter. marocc. 1927: no. 281.  1928 [in sched.]','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f222d94a-445b-5b48-a830-2f7a87ba8193','','','Rep. Inst. Sci. Res. Manchoukuo 2:288.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf98e7de-dc89-580c-860d-9a5b15801b59','','','Acta Phytotax. Sin. 21:65.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('697b90c3-e949-514f-b861-95ed96beae93','','','M. J. E. Coode et al., Checklist fl. pl. & gymnosperms Brunei Darussalam 435.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f8217da-71e5-5b31-9cb3-771b7dcd3ba8','','','Fl. bor.-amer. 2:201.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08c58f6e-8744-5576-8dd1-ccbafada47e7','','','Ann. Roy. Bot. Gard. (Calcutta) 1:20, t. 15.  1887 (Sp. <I>Ficus</I>)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61ea3088-860f-50f8-95d7-e82477da6746','','','Proc. Acad. Nat. Sci. Philadelphia 1862[14]:95.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef8aa426-d14b-56c8-91ed-db222c17cbd3','','','H. G. A. Engler, Pflanzenr. IV. 5(Heft 18):84.  1903 "<I>Podocarpus totarra</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19a77056-e9dd-57ac-811d-9a764d9598e3','','','Ill. Handb. Laubholzk. 1:600.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d69f24c-ab29-5521-ae87-c5a81fdd4147','','','Pittonia 2:7.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f8ca478-61f3-5c88-bce8-b18ea9361454','','','Ostenia 179.  1933 (H. Pfeiffer, Repert. Spec. Nov. Regni Veg. 29:174.  1931, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c57bd10-ec54-5327-9180-04d03c90c82d','','','Retzia 1:158.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfb3ea0c-66d0-5ff5-999c-94ad10df9d9a','','','Prodr. stirp. Chap. Allerton 392.  1796','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('baa791fb-67cb-5974-987e-50eda4ce9c73','','','Bothalia 1:47.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbdd20d7-3083-5b18-9ce6-ff37d500ba30','','','Bot. J. Linn. Soc. 71:271.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3f3a588-7bf9-5e14-8ac6-8062f44cd8f1','','','Madroño 11:174.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc410d69-5947-509f-90dd-5c543df5fb64','','','Sp. pl. 3(2):1194.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8d86849-7f31-50e5-96e2-5dc088b5cb66','','','Gen. N. Amer. pl. 2:96.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e707275e-74d9-5804-95a2-2b2fb9641054','','','Symb. bot. 1:78.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa1a8e95-5659-5ff6-9054-1db0bde90b23','','','Syn. pl. 2(1):99.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f0e886fa-f717-5061-b75f-1dba164959e9','','','Verh. Batav. Genootsch. Kunsten 9:214.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad6d5512-5e6c-5477-b086-e9350b40468b','','','Paxton''s Fl. Gard. 3:62, fig. 263.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65651205-39d9-5436-8c35-6bfef2620cb8','','','D. Prain, Fl. trop. Afr. 9:531.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d43809b3-8ea8-5258-b718-8fdc1ed138fc','','','Mant. pl. 1:98.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('816b85fe-052a-5e5a-b251-388eceb217c5','','','Pacific Sci. 12:141.  1958 "<I>St.-Johnii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1689801e-c8e9-514a-aa0c-e0ec8dbc6ed5','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 6:385.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f20a7897-82c5-57d5-bcd6-90f30ec90a65','','','Rhodora 49:119.  1947','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15f14eb8-2e76-5895-b056-393c2aa56792','','','Man. fl. n. states 627.  1901 (B. F. Bush, Trans. Acad. Sci. St. Louis 12:83, t. 14.  1902)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1b532ec-6d80-5cb7-88d8-2ac159a2ad1f','','','Cact. hort. dyck. 1849:208.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1251d35b-fc36-5c53-9b87-97ffcd5f954f','','','Trans. & Proc. New Zealand Inst. 46:33.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10a08111-83da-5ba9-a815-422bfb2b4a5b','','','A. L. P. P. de Candolle, Prodr. 10:199.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e44dbcc-7fff-5e00-9406-514b492c22a9','','','Prodr. 2:107.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5b8d798-284f-5c1a-ac65-83038a8f532e','','','Herb. pedem. 1:417.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('020048f6-ede1-5c6f-89b7-62c45028259c','','','Sp. pl. 2:1047.  1753, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fac6f4fe-a0c1-58b9-b328-facee7722091','','','Bot. Mag. 96: t. 5846.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b601d60-2603-5fec-96d3-47f1da154037','','','Contr. U.S. Natl. Herb. 35:130.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7e5f743-7922-500b-87a3-eba6c0a79633','','','M. Quinn, Endang. sp. threats conserv. 48.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8dcad62-8147-5920-ae46-f08dec1fbd04','','','Malayan Misc. 2(7):33.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7820522b-efc6-550d-9538-8626ccffb80a','','','Fl. N. Amer. 1:10.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('781df6c1-d0c5-5591-bc93-cf9e5e6cc28e','','','C. S. Sargent, Pl. wilson. 1:428.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f05d21c0-a837-5d4c-b82b-16fccec2b07b','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 3:35.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a087cc00-d904-59c1-b4bf-6c4845c9aee9','','','Ann. Sci. Nat., Bot. sér. 4, 4:282.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64099c85-2497-594f-879f-44ce7fd78775','','','Amer. J. Sci. ser. 4, 14:422, figs. 1-6.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('238b811e-da1d-5941-a2a2-9a82e87367cc','','','Mem. New York Bot. Gard. 74(2):71-73, map. 22.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53c68ffc-06e1-5bf7-8ee6-cc6508b2239a','','','Novosti Sist. Vyssh. Rast. 8:68.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13005968-6461-584e-b9fe-da2bb634a8b8','','','Prodr. 2:343.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ad58a8f-b5f4-5975-b2d2-4639d915e074','','','Verh. Bot. Vereins Prov. Brandenburg 18:94.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25769f39-730c-5b69-b704-deb719298ff6','','','Gartenflora 27:361, t. 959.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b994894c-a38c-55ef-8cee-6931f0da6a11','','','Fragm. 2:170.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8fcb8ef8-40b2-50eb-a4a4-f01ecf421639','','','Ann. Sci. Nat., Bot. sér. 3, 18:105.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8c8104d-7fbb-5212-8ed9-105689d066dd','','','Fl. altaic. 4:201.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7633c99f-bd2e-538b-8329-09df9d4b1dca','','','Fl. bor.-amer. 1:110.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27a97f09-d5b3-54a1-919d-f32818b4de3e','','','Adansonia 10:71.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac2b474a-fc0e-5569-90fc-f472ae5dc78a','','','Rep. (Annual) Michigan Acad. Sci. 21:356.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3ec3cf7-f58a-55f9-b5f2-11746c840910','','','Indig. trees Haw. Isl. 231.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54573fb9-d19f-5b39-a53d-8ce50fd661e3','','','Candollea 48:494.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78efc787-781a-5a7a-8319-c296b1c17e35','','','Biocosme Mésogéen 27:122.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0114fba-f914-56da-96a4-5541a452efec','','','Sukkulenty 1998:22.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0fd4fef-b01e-5f40-92f5-4b409a4a17cb','','','Enum. syst. pl. 13.  1760 "<I>corymbosa</I>" (Select. stirp. amer. hist. 34, t. 30.  1763 "<I>corymbosa</I>")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0993fe4-9e50-5be0-a193-810bef5b60d3','','','Syll. Pl. Nov. 1:140.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10bd76e0-a33a-5418-921d-c0d92b8eca97','','','Pl. Marocc. nov. 2:1.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf8fbd2c-2adf-592c-ac14-a8b1a6539339','','','Nov. pl. sp. 261.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85cef1c9-1420-5012-b183-5467640b0507','','','Icon. 4:33, t. 355.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dfe30fb-b4f1-50e6-975b-6f2a76f77ba4','','','Acta Phytotax. Sin. 23:236.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a255ef9f-bbee-59ff-99dd-f28e1d45c897','','','C. F. P. von Martius, Fl. bras. 14(1):472.  1858 (Linnaea 27:442.  1856, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9afde473-2cab-5d75-b9bb-e86fd25ebc64','','','Nova Acta Regiae Soc. Sci. Upsal. ser. 4, 1:122.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('537e69f5-98ac-5504-acd4-2044881f077f','','','Bull. Herb. Boissier 3:387.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51d4caac-aaee-5a31-84d5-bb466fed8437','','','Amer. J. Sci. ser. 3, 50:141.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4146c117-19a8-5d83-aa3e-25b93d0a3d56','','','J. Jap. Bot. 28:294.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('239db21a-12fd-5a9d-af80-29ba63dd7c3b','','','Monogr. Acad. Nat. Sci. Philadelphia 5:87, t. 10B.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62d2b42a-1d52-5c5a-b806-9306dfffae2a','','','Kew Bull. 36:827.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15eb3723-3973-585b-81fa-b0e648a69ba5','','','Revista Acad. Colomb. Ci. Exact. 16:70.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e7a256c-6571-50ac-ac0b-3079947bc992','','','Proc. Biol. Soc. Wash. 48:42.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56312ecd-7e9c-5018-916e-850d170cbe10','','','Fl. Tasman. 1:95.  1856; t. 16.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46fecd87-a28c-5bd5-b1fa-b922844becb2','','','Comm. legum. gen. 71.  1837 (Ann. Wiener Mus. Naturgesch. 2:135.  1839)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('514cc357-2cd3-5631-b7f3-6b1ded151438','','','Bull. New York Bot. Gard. 2:215, t. 30, fig. 2.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aeea44aa-e594-5ba5-a4ee-fa330a80e344','','','Sp. pl. 1:321.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2997ba8-974f-5431-971b-5d850f8c671a','','','Ill. Handb. Laubholzk. 1:16.  1904, pro syn.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92e8388d-f837-5537-ab5c-2d3f30d226cb','','','Mem. Amer. Acad. Arts ser. 2, 4:116.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e56652c9-9d18-5536-8f6d-e6b3d6617ddf','','','Kew Bull. 32:1.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28684686-9c6d-54f5-a4d9-67dbbeecb855','','','Blumea 16:249.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('077e7c42-09ff-5f60-87c0-cd134b5867c8','','','Fontqueria 4:27.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff78ce4b-a2f7-5b45-9fe1-485cea2402aa','','','Hist. pl. remarq. Brésil 220, t. 20.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13cb4639-cc70-57d5-941d-6263a6128d60','','','Lilloa 23:23.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec0ddd7e-1c58-5c28-8eac-08ce016e6ea0','','','Char. gen. pl. 54, t. 27.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fdb56cb-bb6f-51bb-bc34-62dfd7d80956','','','W. T. Thiselton-Dyer, Fl. trop. Afr. 5:423.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb827d96-2a19-5c98-a25d-e8ae970a53e4','','','Linnaea 6:47.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b6ec6c6-e3da-591a-868a-c16b8f3ffbd7','','','Ann. Bolus Herb. 4:114.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc6909b7-644b-5c2e-bcd9-3d97206fb651','','','Fl. pis. 2:63.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5a02855-2162-5a52-98a0-653ea8ec522e','','','Candollea 40:165.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34a2ec74-4ee5-50f9-b0d7-9b93c76a2733','','','Proc. Amer. Acad. Arts 9:114.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2355add0-b9f0-5844-800f-d2c8f58b7346','','','Edwards''s Bot. Reg. 21: t. 1791.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('725c9043-274d-54f5-a77e-20a63c885552','','','London J. Bot. 1:353.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('539f7722-d77f-59aa-8798-7c6f21f8f44e','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:277[folio]; 1:345[quarto], t. 80.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b57fdb5f-f040-5066-810d-b2acfa8042d4','','','Prodr. fl. nepal. 72.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2fb246e9-bb17-5b5a-9684-45e720e79f8f','','','Engl. bot. 35: t. 2490.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f59deca-948b-50d2-b633-1f6a3a043d1e','','','Journey China 329.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78e8cf26-85af-5ca1-80a8-b8869f21ba76','','','J. S. African Bot. 41:115.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a7f24c8-1a67-5886-9b71-49a7cdc2064b','','','Nova Acta Acad. Caes. Leop.-Carol. German. Nat. Cur. 68:222.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7537da0f-a489-5746-85d3-b42e7e377440','','','Notul. Syst. (Paris) 4:95.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bf3dcff-9577-5082-ad9e-24822ae2e30a','','','W. G. Walpers, Repert. bot. syst. 2:55.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('324e845d-30a9-59e3-8ec4-1e1b864adb55','','','Fl. ind. ed. 1832, 2:367.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f2ec829-4d27-5796-b6c4-4981df028f54','','','Mitth. Thüring. Bot. Vereins 20:31.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e8509a9-74e0-5e90-b887-00a8e7a7282d','','','J. Bot. Suppl. 62:27.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d796144f-989e-534c-8b86-1310db69ac64','','','Repert. Spec. Nov. Regni Veg. 15:244.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d116a42d-2022-5271-8234-3498bdcbe223','','','Descr. Cact. nov. 1:30.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d171014-8265-553a-b1b6-cc935efd07e9','','','Amer. Naturalist 8:202.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fcc552e-1636-513a-8ae6-db69693a1c6e','','','Revis. gen. pl. 2:780.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ed65af6-5f12-51ca-b727-238fa32d8cb7','','','Nordic J. Bot. 8:561.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54b7d5e6-1991-5fee-b985-1ad154750d3d','','','Cat. graines Jard. Genève 1865:4.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76cb79a3-b83c-57b6-84a4-150f98498aa8','','','Gen. pl. 2:100.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c0d0413-2385-54d7-900e-d0000c8e550e','','','Opera Bot. 44:53.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f86152b-f53e-5cdc-99bb-2a05d3914705','','','Mitt. Bot. Staatssamml. München 14:516.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('135e3264-eb3f-526a-8447-446648405aa6','','','Proc. Amer. Acad. Arts 38:118.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8cb3f515-0342-50e7-8ea3-895a1373134b','','','A. L. P. P. de Candolle, Prodr. 14:12.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e84611ac-ef3e-5c70-be8d-1bd2f55021bd','','','Bot. Mag. 53: sub. t. 2637.  Mar 1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b116d5cf-18a6-5f01-8184-b44660f8e4aa','','','Enum. pl. 5:8.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a65ec906-5322-55d5-bdd3-879df36480b9','','','Mitt. Deutsch. Dendrol. Ges. 17:159.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8c4dc87-8266-5566-99c1-9092c92926cf','','','Revis. gen. pl. 1:114.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3a486dc-0212-5562-ab74-6d5cca50f6b0','','','Fl. baical.-dahur. 1:352.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b74b0eb9-ffa4-5766-bbdf-7279bec5e7b2','','','Trans. Amer. Philos. Soc. ser. 2, 7:299.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('698a3d15-aac1-5f43-8dcf-82dbb6cedf52','','','New Fl. 4:58.  1838 "<I>americanum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a761c350-42bb-517b-a71f-172fd8e486f6','','','Nouv. Arch. Mus. Hist. Nat. sér. 2, 7:110.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e47a252-c824-5fd7-973c-6031f8e56307','','','Trans. Agric. Soc. Jamaica 1825:5.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4217a051-5750-5974-810f-b6e516fa288b','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 2:111.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d48e25f-7a82-55b3-92f3-8c2b1a2a28bf','','','Rhodora 39:157.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('658f7cef-7855-5521-b1a5-3fa450e450b7','','','Trans. Linn. Soc. London 25:304.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('339ec386-4980-5072-b043-332d4e2cbf32','','','Sp. pl. 2:1100.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b52644fc-ff41-5d18-8d68-6e6c2f71072e','','','Nova Acta Acad. Caes. Leop.-Carol. German. Nat. Cur. 68:252.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56a9dbaa-0763-517b-9297-b8f92418b997','','','Occas. Pap. Bernice Pauahi Bishop Mus. 4:218.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc02e657-cd06-5dd9-b252-07e36c764641','','','Syst. nat. 2:626.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edb95968-c129-5888-9a72-daab84a49a47','','','Contr. Gray Herb. 146:78.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f0f08b0-a451-5cfd-a913-46e76badd17d','','','Hort. kew. 453.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('862a105e-334a-5ce9-a3cc-81c5fca9b952','','','Anales Mus. Nac. Buenos Aires ser. 3, 4:519.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('183d8886-995f-5736-8c14-c991586f1b80','','','Sp. pl. 1:227.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a723efe3-a119-599e-9b06-9b50168abd20','','','Sem. rar. hort. patav. 1836:4.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d64182a3-5630-5724-86eb-319260260c1a','','','Bull. Torrey Bot. Club 28:230.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a4466cb-4047-5ee7-a44d-9c8b2466c4ba','','','Bot. J. Linn. Soc. 172:517.  2013','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef42ebe1-2dce-5299-88e8-08ad2ae51403','','','Syst. Bot. 39:485.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64f3893b-fcb0-5d8c-af0f-f07ab3820d77','','','Abh. Königl. Ges. Wiss. Göttingen 19:218; Pl. lorentz. 170.  1874 "<I>Jochroma</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d86745f-7fdc-53aa-a6dd-2aa47911e75d','','','Fl. taur.-caucas. 3:489.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4833fdde-b249-516d-b574-1a24d68815fb','','','Mant. 3:229.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('336f6a1c-ac22-5933-ab65-b9c2b44d7b61','','','J. C. M. Grenier & D. A. Godron, Fl. France 2:736.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f26393e1-4ffc-5d54-88ed-b7e18ba27bbb','','','Fl. orient. 1:878.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15087c91-d42a-58e4-9dad-f89844e4c31f','','','Fl. bor.-amer. 2:109.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76bb042a-0b63-53b7-8977-f138388af5f0','','','Diagn. pl. orient. ser. 1, 2:26.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5383e5d8-3aff-5a48-9c28-5c325493e6fa','','','Fl. orient. 4:566.  1879 "<I>Satureia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6296a49-e993-552a-9c01-1ff21ff08c03','','','Revis. gen. pl. 2:692.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbc2aa3e-9ede-5388-9840-50b9c6d74e56','','','Bull. Misc. Inform. Kew 1911:96.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e72bf73-1305-5e9c-96a2-c334535aaa3b','','','Sp. pl. 4(2):1011.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04f930a5-3cf8-5f7a-bd82-d754d39f42bf','','','Crane & Carmen (pers. comm. to PIO)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('803bcf0a-9aa8-5930-a405-39007f707308','','','Mém. Soc. Linn. Paris 4:325.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cfb58b2-d0e2-5cd3-854d-153e1d9adac6','','','F. Cuvier, Dict. sci. nat. 35:171.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b23dfd8-6217-5603-8b9b-4c54f56ddb21','','','Misc. nat. 59.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93607741-7138-5e7f-86f1-c5d68711049a','','','A. J. G. H. Kostermans & J. M. Bompard, The mangoes: their botany, nomenclature, horticulture, and utilization 78.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d2798d8-55ee-5bee-a0e4-36c44d315d9a','','','E. H. Wilson & A. Rehder, Monogr. Azaleas 32.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4fc04b1e-0d05-5e21-b8a9-d8d056813e9e','','','Bot. Jahrb. Syst. 32:159.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d439885-66bb-5e5e-84db-c041a4f1e974','','','Enum. stirp. Vindob. 128.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('107e2a35-c4aa-58b5-9e90-df70b4a018e6','','','Encycl. 1:255.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('280603b2-5a80-534c-b116-111a9190667c','','','Manual ed. 5:261.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b429071a-5472-5198-9be3-c091debd640f','','','Bull. Misc. Inform. Kew 1926:162.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97942c43-bca1-530e-9631-1f77c3ba6a69','','','Bijdr. 545.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dcd6c668-9e60-5d56-9c8b-798306ea5208','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 11:22.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3360a098-eb07-53d5-bf77-35bc2557e09f','','','Prosp. fl. Eugan. 26.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f14f478d-2519-5c6c-a835-dc1187a6dbbd','','','C. F. P. von Martius, Fl. bras. 14(2):208.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65a7914c-6436-50e6-b200-5a23cebab929','','','Pittonia 4:82.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b18d8a4-bab0-5fc4-a7c5-190aadc1d9fa','','','Tabl. encycl. 1:432.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8226e6af-488f-51a2-a89a-cb7168274bb7','','','C. F. P. von Martius, Fl. bras. 14(2):210.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05420501-f211-572a-b304-b5566d586470','','','Repert. Spec. Nov. Regni Veg. 21:42.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8e0c69a-59a6-56b1-9173-7c2ff3329a7c','','','Hist. pl. Dauphiné 2:98.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3484a2d7-b284-5b3d-91df-9ce62e511e16','','','Repert. bot. syst. 1:402.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4619379-bf8a-5f48-9ee8-08d23feafdb9','','','Monogr. Campan. 297.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b154bb2c-5837-5abe-a1e1-879f9c133b27','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 12:103.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c6ec389-6078-5237-8fd0-607020d81469','','','Fl. peruv. 2:63, t. 211, fig. 6.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65b0c539-080d-5753-baa8-6ed8c0a87313','','','J. Bot. Res. Inst. Texas 1:1020.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1133afba-5f06-5879-96bf-5c546a09adaf','','','Encycl. 1:723.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e30c43f3-2b2d-5a46-b663-b4380b211cbd','','','Stepn. fl. baik. Sib. 45.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3171dd42-9149-5c39-9668-cdc49781fd8d','','','Osnabrucker Naturwiss. Mitt. 15:53.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e36bf75b-a68c-5947-ac40-fdcc6fc69c1b','','','Adansonia 6:201.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('456259b6-3228-5046-83f8-d81ac9864add','','','Syst. veg. 3:460.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6e81d710-5d8e-596e-94bd-cc342d37a548','','','Bull. Torrey Bot. Club 100:83.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d822a220-aef1-5099-8ed8-053b72536638','','','Bull. Torrey Bot. Club 25:258.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79f77f27-a5f6-5c1b-b6df-289281769d05','','','Hooker''s J. Bot. Kew Gard. Misc. 3:152.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c9ea706-7f6a-5e88-b717-9d97715ca25a','','','J. Bot. (Morot) 13:326.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c2beed3-0d03-542b-ab90-bbd0e09cbd20','','','Bot. Jahrb. Syst. 50(Beibl. 110):19.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('52eae9f8-1a2f-5ff2-a48a-d3fac6fc82fd','','','E. Regel, Izv. Imp. Obshch. Lyubit. Estestv. Moskovsk. Univ. 34(2):6.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72f84a84-0b20-593f-970d-db55a6ce36fc','','','Opera Bot. 91:82.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97505513-bd1e-5cf8-b9e4-3ee4b84336c3','','','Repert. Spec. Nov. Regni Veg. 24:301.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1dfd576e-94f5-5915-95cc-b045a71c1e06','','','Anales Inst. Biol. Univ. Nac. Autón. México, Bot. 65:149.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfb1fca9-7458-5562-b28c-3c4868cd73be','','','Bull. Misc. Inform. Kew 1912:145.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c2a7d02-91a0-5607-81c5-8bccc07295ec','','','Mém. Soc. Imp. Naturalistes Moscou 3:267.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66106798-aefa-5b89-9d83-bd15d86e67ae','','','Sched. crit. 391.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cc317bd-a7b7-58ba-a3f8-d323dd60716f','','','A. J. G. H. Kostermans & J. M. Bompard, The mangoes: their botany, nomenclature, horticulture, and utilization 64.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ef725b1-2989-5f6a-8788-df56977fe07e','','','Cactaceae 5:2856.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5144ef67-8fff-5c76-b719-2a9e8cb2395b','','','Bull. Acad. Roy. Sci. Bruxelles 3:174.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58e86bb0-30c2-5461-8ee0-713b9947dbac','','','Ann. Missouri Bot. Gard. 36:543.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20904a86-5f6a-5365-b6c7-6b4e42755e92','','','J. S. Presl & C. Presl, Delic. prag. 72.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39d1aec0-b2f5-5ba2-b87f-b5a7b6db1072','','','Gram. Unifl. Sesquifl.:174.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9dbffce0-7326-56f0-a3fb-b2ab4a15e724','','','Ark. Bot. 13(10):54.  1913 "<I>lindmani</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b60eb5a9-58dd-5935-a6e2-d008338c6a50','','','Repert. Spec. Nov. Regni Veg. 45:159.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d99734b-1406-5855-93d2-045dbec1f4ce','','','Bull. Torrey Bot. Club 26:5.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa6a67f1-5067-5049-b78d-aae9a0cbb1c7','','','Ill. pl. orient. 5:93, t. 483.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbd67640-ff7c-566f-88b3-250da25766a7','','','Phytotaxa 156:34.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d61001f2-5066-5bcc-9791-b9c73fb04c40','','','J. A. Murray, Syst. veg. ed. 14:72.  1784 May-Jun (Fl. jap. 22, t. 5.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf86b593-40d6-5fcd-9fff-db1cef6c0ded','','','Rev. Hort. (Paris) 1861:352.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aef81165-854d-55a3-a292-efbb887e6dbb','','','Sugimoto, New keys Jap. trees 467.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9db54463-8669-5ab0-bf20-b2e447a5ae04','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 5:119.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ee6c2a2-7049-5e6a-a5fd-ff434924c5dc','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas 3(1):591.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('614475ce-7502-5121-a1ad-54f8c746ca94','','','F. A. Sauvalle, Anales Acad. Ci. Méd. Habana 5:337.  1869 (Fl. cub. 30)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4725e260-224f-5114-bd9d-2da45645c01b','','','Phytologia 38:219.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2ba240dd-ac90-5831-8e25-1fe867bb6e9c','','','Syn. pl. glumac. 1:231.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f0e2bb8-c6e3-51e5-ab93-8ac55382d94a','','','Fl. taur.-caucas. 2:155.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7f449e0-4d75-5854-ab9e-adbaa3203902','','','C. S. Sargent, Pl. wilson. 1:29.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90590700-185b-5956-8bff-2fe5008b0692','','','Compan. Bot. Mag. 1:373.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a184414-e12c-564c-a514-9f807bee3596','','','Fl. N. Mitt. Deutschl. ed. 4, 222.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d9a409c-9a3b-522c-9cc8-c106e92501e7','','','D. Kenfack et al., Novon 13:447.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea540245-2462-5571-8f2b-5a547e0b3c9c','','','Trans. Roy. Soc. South Australia 95:229.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('129b1b60-8299-55da-b115-3ee09664de9e','','','PhytoKeys 129:13.  2019','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ceaf121-20e4-5eab-9361-29d263b29fcd','','','Ann. Mus. Bot. Lugduno-Batavi 1:127.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2922c125-1db3-5ec5-849a-cf424ad93d4b','','','Bot. Mag. 108: t. 6644.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00f3a31b-bc93-59cb-9d1b-6aa02b75d033','','','Gard. dict. ed. 8: <I>Physalis</I> no. 15.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9664283-2b13-5a49-b5f9-f97017b2d61d','','','Oesterr. Bot. Z. 110:340.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10e6a9b3-c021-5843-a294-ed25f8a5e08d','','','J. J. Roemer & J. A. Schultes, Syst. veg. 3:530.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7589e1cd-fff3-56a1-8b1d-754f59283d3d','','','Sp. pl. 3(1):75.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55a61f7a-3d65-531d-aa91-0852c41f9942','','','Mus. bot. 1:342.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cb96452-47b0-5850-b1ef-d16a339e3085','','','Denkschr. Königl.-Baier. Bot. Ges. Regensburg 2:55.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('507acd64-db9b-50a0-80ef-cdf7a4e5de83','','','Garden 46:547.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bc613bc4-a4c6-5ba9-89a6-08818d7f0fe4','','','Cent. pl. II:25.  1756 (Amoen. acad. 4:323.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fbcd93c-748c-528a-bad2-570c2345e7e8','','','Trudy Prikl. Bot. 58(2):158.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18daab21-e2da-5a0f-a987-a3f90afda54a','','','Kew Bull. 71(1)-11:3.  2016','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61a7653f-6912-5979-b0ba-9cb4a77f8970','','','Enum. pl. 5:386.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b393990-71dc-5df1-9941-b320f52af9ac','','','Spruces of Tian-Shan 22.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af6eb1c6-83e2-5904-adb4-a20e178e940e','','','Brittonia 1:82.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7885c3f7-4a4d-538c-9142-addc8ac71968','','','Fl. čech. 101.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f11ffa58-097a-5370-94e1-ed4da1dbd29f','','','Contr. arb. Argent. 43.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47142aa4-7903-5845-965f-64cefb9f344f','','','O. Beccari & J. D. Hooker, Fl. Brit. India 6:427.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e55de735-7e78-5760-b1f7-e973c297a5fb','','','J. L. Stewart & D. Brandis, Forest fl. N.W. India 168.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35069cbe-f6e6-597a-ae02-d363f089e166','','','Bull. Herb. Boissier 7:33.  1899 (non (Thunb.) D. Dietr. 1847)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d9eefb8-c90b-54af-8822-991b1e54ee29','','','Trans. Linn. Soc. London 17:413.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19f06af1-1add-58d9-96cc-8cb7668b8959','','','Syst. Bot. 29:382.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a69bf1cc-6bc8-5d7e-a61a-705f76e42137','','','Fl. Gabon 4:28, t. vi.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb0ce8f0-a2a0-5d0f-b0a0-2a5e2d4e53d0','','','Kew Bull. 11:133.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9be69121-4f4a-59b5-833d-45710fbf5e80','','','Tabl. prov. Mer casp. 58.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7f4dfd9-9935-5141-a4b3-32c1d4860d3b','','','Neue Schriften Ges. Naturf. Freunde Berlin 2:111.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0b3af30-4073-5323-b234-530b2df39c37','','','Icon. Pl. 2: t. 122.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab48010f-44be-5524-b32c-0ba39420f633','','','PhytoKeys 146:64.  2020','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9efff7c2-6d5f-5f53-9534-18071dc37b7e','','','Monatsschr. Kakteenk. 18:85.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e54c279-5ff7-53fa-94b2-2b5b0125213a','','','J. Burtt Davy & A. C. Hoyle, Check-lists for. trees & shrubs Brit. Emp. 3, draft descr. check-list Gold Coast 110, 115.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd2bb542-1442-50ed-9f7f-6d6cd68fb58d','','','Meyrat et al., Pacific Sci. 37:224.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9317221e-c729-5bf8-bb22-59c916780999','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 18:61.  1872 (Diagn. pl. nov. jap.) (non Goeppert -a fossil name)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('933417df-0635-5fdb-ad41-e84abc732f14','','','Aliso 2:14.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08b5dad7-805e-5d53-bbd0-215e066e3b6a','','','J. Jap. Bot. 41:191.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('619857af-af94-5209-b76f-4313b88d789a','','','Bull. S. Calif. Acad. Sci. 17(2):63.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27a9b408-929c-5481-8e69-4278c3e38d31','','','Proc. Amer. Acad. Arts 8:372.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cddd8f3e-78c6-58a2-95bb-0804bb46dd2b','','','Elench. pl. nov. 91.  1838 "<I>pseudoeskia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58ef90c6-ebfc-5055-9520-32a40bf86550','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 3:173[folio]; 3:221[quarto].  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abf56808-6bbc-5649-9472-dc8983f2d9de','','','Phytologia 1:289.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85029c1e-5041-5312-8358-28fc4ea45536','','','J. Acad. Nat. Sci. Philadelphia 7:34.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4952d833-877d-59cb-a670-0928b694ab90','','','C. F. P. von Martius, Fl. bras. 4(1):150.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f743c8ef-7719-5555-9d8a-5e7adb47e198','','','N. L. Britton & J. N. Rose, N. Amer. fl. 23:295.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3950c84-364d-5d07-8679-815f598ae3ff','','','Syst. laur. 437.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e9e9888-1d51-5eb9-9964-8774db17a716','','','Amoen. ital. 8.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f353905c-552c-55be-9006-3e3460d933ef','','','Prodr. 6:658.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa627fa3-932c-55fa-88f9-5c53f2cb97cb','','','C. F. Schumacher, Beskr. Guin. pl. 129.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fcad40b-9396-5a50-bc94-c68bcaaa8631','','','Tanaceteen 56.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f747c047-50d0-5673-b0aa-39e0c303e1f6','','','Linnaea 21:585.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec01853c-e3f9-53f5-bae8-0c44b6183e73','','','London J. Bot. 4:150.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbae08fd-4ed9-5cda-9f27-f5639d87fd18','','','Nova Acta Acad. Sci. Imp. Petrop. Hist. Acad. 14:166.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9e5f33e-6e64-5f00-a761-249cafaefaa8','','','H. L. Duhamel du Monceau, Traité arbr. arbust. nouv. ed., 5:9.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b5d96e1-b3ca-50a8-9402-80bba5dc5895','','','Kew Bull. 24:483.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b2dcbd7-fb19-537d-8f08-4d947d1ea90f','','','Proc. Calif. Acad. Sci. ser. 2, 5:626.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95b17727-6be0-5a91-9ba7-5c397610318e','','','Pl. wright. 1:101.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('009ffc71-c16a-5d76-a2a1-42fcda3a80f7','','','Ser. inconf. pl. Aragon. 79.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('deb02088-b518-54b2-a574-6862ac3b6f20','','','Bot. Gaz. 85:5.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39ae644d-005b-5934-bf44-b68d2b4a7bfb','','','C. S. Sargent, Pl. wilson. 2:286.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9eb1ec8d-782e-5931-9b1f-e8cc7f7ca82c','','','Exot. fl. 2: t. 148.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70b8b70d-c475-5613-bab9-90830bfc2df7','','','Trans. Amer. Philos. Soc. ser. 2, 5:159.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e3416fd-0018-587c-9bfa-a6fa540c0268','','','Trans. Linn. Soc. London 25:303, t. 38.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7457bd8-49b6-504a-8c7f-b819c12df121','','','Hort. berol. 1:59.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3792b67a-9c2b-56f6-9360-5a397041dc92','','','Rhodora 42:116.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa55af54-4fa1-53e7-bf96-4dc7d98135c8','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 4(2):98.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e7bb4b6-15bc-599c-9f9f-e5a8e3670e57','','','Fl. pis. 2:159.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40b76888-8d85-58e4-9520-fbeefa7eeb82','','','Bot. Jahrb. Syst. 34:327.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00e19f67-b47c-5230-95ff-f156e5254e2b','','','Trans. Linn. Soc. London, Bot. 9:58.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('868bd4d2-b4a5-531e-ac27-af49970855ac','','','P. Tchihatcheff, Asie min., Bot. 1:221.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b54f0c62-bef4-5f27-868d-b2271c514aab','','','Bot. Jahrb. Syst. 18:63.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82cbc404-9bc4-5a05-b4d2-521eeb9796bc','','','A. Cronquist et al., Intermountain fl. 4:362.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7dd34f46-8bce-52fb-821a-987514c7a231','','','Diss. 4:240, t. 117, fig. 3.  1787','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('795ef640-ca4e-567e-a960-fdd81f3b8e6a','','','J. Washington Acad. Sci. 15:393.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82bc9852-ded5-531c-93a3-03ee10e083af','','','Bull. Herb. Boissier 2(app. 2):41.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72982e90-6bc0-541a-bc90-5f15719c919c','','','A flora of North America 2:294.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c93d9f94-f8a2-5885-92dd-1e48a2441f92','','','Jalas, Ann. Bot. Soc. Zool.-Bot. Fenn. "Vanamo" 24:49.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ff67405-ad3f-5a33-9fc3-5f8523a244d1','','','Nordic J. Bot. 12:346.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50251bf5-2fa0-584c-ac2f-52db4dc4add7','','','Nuytsia 4:53.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fda9c186-81a1-58fd-9d94-abc4628bd495','','','Ill. Handb. Laubholzk. 2:139.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5010356e-5844-53be-9377-c7d08dd28bf6','','','Fl. Afr. austral. ill. 95.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6217d142-0751-5623-bcf9-9f329e375f49','','','Publ. Field Columbian Mus., Bot. Ser. 2(1):88.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44a0509a-6ae2-5c45-9b78-78f18aef4289','','','D. G. J. M. Bois, Dict. hort. 2:957.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed88169c-0b45-5500-a588-f60b14817968','','','Fl. Brit. W. I. 592.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e453a12d-0db9-55a5-a4f1-138fa6975d99','','','Trans. Nat. Hist. Soc. Taiwan 25:249.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('353cced8-e4db-55d2-87cf-f20860ddfcf6','','','Verh. K. K. Zool.-Bot. Ges. Wien 8:68.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98c42fd7-cb4d-5de7-962f-beea8bd99c1f','','','Stud. fl. tasman. 2:334, 463.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36e2edfb-6bae-5c32-87db-9b34a0b9c313','','','Sag. stor. nat. Chili 147.  1782','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3356dff0-d6ba-5bfb-8fb6-00e72b49f05d','','','Enum. pl. 2:1053.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8991c236-8641-505f-867f-11b4e60dc36c','','','Bull. Misc. Inform. Kew 1895:99.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c266c9e3-e396-58cb-a521-5566d1615416','','','Contr. U.S. Natl. Herb. 18:165.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('129dbcb9-027b-5064-916b-7907d0c80206','','','Prodr. 15:561.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d10fed10-3c2f-5cb3-903b-2ccce2da524d','','','Nov. gen. pl. 3:59.  1783','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a54ff82-4018-5c5b-9f8f-d6fecb68661d','','','Fl. flumin. 250.  1829 ("1825"); icon. 6: t. 43.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81fcbefb-e65e-5b20-a819-c59d260b0c6c','','','Proc. Calif. Acad. Sci. ser. 2, 5:673.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('877ed4fc-6f63-587e-8b02-7f175fe99fca','','','J. B. P. A. M. de Lamarck & A. P. de Candolle, Fl. franç. ed. 3, 4(2):146.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('026cfce5-c096-5617-81ec-021bb29dbe1f','','','Sunyatsenia 4:20, t. 8, fig. 4.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d00bf6be-45a2-51fe-8a5d-cb7702f6cf6d','','','Amer. Fern J. 80:16.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d088807-d785-579f-8e04-9667904762ac','','','Bull. Soc. Imp. Naturalistes Moscou 34:91.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8621d63-f779-5700-85c3-256f50ffa16f','','','Bot. Jahrb. Syst. 13:145.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db342c11-aaa8-574f-a2fc-b4e17c4893d1','','','Seznam 824.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71b6170f-4a14-5e17-b630-d9cc52fcdd21','','','Hort. kew. 1:373.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46492453-c60d-5dd1-8a38-5cc9c9e70d6e','','','Sp. pl. 2:973.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('014aa9ad-6312-52bd-9248-9014456ab2cb','','','London J. Bot. 2:377.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc0c2bf7-5396-5c04-8a5f-f21dc2f43b6c','','','Mem. New York Bot. Gard. 74(1):255.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0df96ce-ce67-5c93-a1b7-e8d38866f15f','','','Nachr. Königl. Ges. Wiss. Georg-Augusts-Univ. 1868:80.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a26da0cd-9c88-5831-b3fa-93d2c446ca65','','','Bot. Mag. 166: t. 73.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('170df60c-76df-5f44-a139-452fa5fc62ca','','','Bot. Zeitung (Berlin) 39:94.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80e069e0-171f-521b-8e83-018379e03ca2','','','Linnaea 7:658.  1833 ("1832")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a59b9307-6b24-5741-acf5-80487a5b4ee8','','','J. Washington Acad. Sci. 5:236.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f28f3a2-3af6-5e57-850f-8df653566448','','','Linnaea 2:156.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5389c873-a83b-5e03-b75d-fb3a0f7f46e1','','','Cat. pl. Bombay 47.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c4f9598-c31c-5cc2-8d3e-2e8f47e12fcd','','','PhytoKeys 126:104.  2019','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e37f5c2-ac36-592d-bc9d-6f51d1378a4e','','','Ann. Sci. Nat., Bot. sér. 2, 6:279.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d28bb03-fc6f-5528-abf7-1ed68027077a','','','Bull. Misc. Inform. Kew 1927:133.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4c1ba93-34a4-5e3e-906e-abc6fd3ee695','','','Rec. Bot. Surv. India 4:27, 33.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d1751f1-fba1-5024-b87e-10e39f800829','','','Bul. Acad. Stud. Agron. Cluj 5:97.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4e13c79-793c-5e8b-a960-2b33048d8d6b','','','Hooker''s Icon. Pl. 23: t. 2267.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfc025c0-e41e-5492-acfa-a61e4e7c58f7','','','Trans. Hort. Soc. London ser. 2, 1:412,  t. 15. fig. 3.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('187d0337-2172-5420-bb97-acc09564fcd0','','','Ann. Sci. Nat., Bot. sér. 2, 2:162.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a901d47-a3af-54c2-872c-6d7dd678b194','','','Arq. Bot. Estado São Paulo 4:179.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41c5050b-80c1-5950-8fe2-85ad67f47006','','','Syst. veg. 4:798.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d507e902-c226-51dd-a40d-1047c6f68b71','','','A. L. P. P. de Candolle, Prodr. 10:325.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('481fb0d1-8d56-5a16-a0f3-76430f3d6ce2','','','Torreya 24:8.  1924 "<I>abyssinicum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97533399-c110-502d-b603-51ef73c832ba','','','Fl. env. Paris ed. 2:367.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9f629ce-fda7-597b-a017-7bcaf23b76c8','','','A. L. P. P. de Candolle, Prodr. 16(1):330.  1869','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72c6b14d-7584-5529-b855-5ab58bf465bc','','','Arch. Jard. Bot. Rio de Janeiro 5:126.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b92029f2-9260-538c-8cab-685b143cc089','','','Mem. Dipsac. 29.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7459c067-2b20-5ab2-bed7-652d31bee71c','','','Suppl. pl. 158.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e9679346-738d-52bc-8293-ea38f3cf21b2','','','Fl. ind. ed. 1832, 3:241.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2044d5b7-4974-5449-822b-b1f98a404be3','','','Feddes Repert. 89:108.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ddd8421-ba90-58db-8d11-92ded532485a','','','Alsogr. amer. 60.  1838 (G. Don in J. C. Loudon, Hort. brit. ed. 1:50.  1830, nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bae23c93-fb6a-5177-a210-09f2f8e22834','','','Repert. Spec. Nov. Regni Veg. 17:352.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f5f96d8d-e0a7-5e74-81da-7325a405f909','','','Enum. pl. afric. austral. 184.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b727b1f5-0d86-5abf-a2e2-109a253db2c8','','','Madroño 8:74.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c82e75be-828d-5567-bba3-c2a098c8d1e8','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:497.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41dd514d-c6ec-5895-81e7-f527fa325bc7','','','J. Bot. Agric. 3:81.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68b46380-5c02-591c-b395-00744b751ad3','','','Acta Bot. Yunnan. 4(2):169.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2547529-989a-5672-9f8a-1d49cc131ae5','','','Fl. trop. Afr. 9:443.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('379a7823-91d6-5f2c-a07b-c1beeed90ef7','','','Ann. Mag. Nat. Hist. ser. 3, 4:362.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('539d763e-115b-57e0-8e17-90354af412b0','','','L. Diels, Bot. Jahrb. Syst. 29:479.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b63a2711-e3a7-530a-8e12-c5e77f6fb516','','','Malesia 1:239, t. 9.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6105772b-07c5-5e1d-806c-d7ae95ab84ba','','','Israel J. Bot. 25:216.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79f588c3-422e-57fb-be19-705582b8e2dc','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:348.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42c5bfc7-c95a-58aa-80c7-4108f1da03dd','','','Bot. Közlem. 14:104.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bba7d2bb-f467-5150-8f2f-38eaa621252c','','','Jahrb. Deutsch. Kakteen-Ges. 1:47.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8364e700-5d80-58f7-a2bb-9ceec78532c8','','','Encycl. 2:15.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6214cf2-0528-5593-89d9-9fb5c5c80bca','','','Bot. Zhurn. S.S.S.R. 17:481.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('debfa296-2ce4-52e6-a375-2dbb42686304','','','Természetrajzi Füz. 3:157.  1878 (Exp. Asiae orient. 2:24.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b915613-f584-5674-98a0-0d546021a986','','','A. Rees, Cycl. 35: <I>Thuarea</I>.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df03e0a4-682a-527f-8563-d1484876105d','','','Pl. wright. 1:111.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a02d05b-4e34-58fc-90d8-d3ab08bbc7d8','','','Bol. Soc. Argent. Bot. 9:377.  1961, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d0930b6-f140-5536-ba57-75ec1f67d557','','','Prodr. 4:14.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5820a8f5-d4a8-53f8-a649-0820cd59731a','','','Ann. Mag. Nat. Hist. 7:457.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fb1aae6-07c6-5773-a259-9f86b01d3f2d','','','Gen. hist. 2:138.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53760ba6-ba7f-5517-9c5d-b435dfd1891f','','','Sp. pl. 3(2):1047.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ef5b2ae-92e8-567e-8d4b-0229291d8e71','','','J. A. Murray, Syst. veg. ed. 14:168.  1784 May-Jun (Fl. jap. 77.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('feb11a2a-9142-5279-a48e-d7d2ff0298dc','','','Kew Mag. 1:42.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46496ace-9147-510e-b1f0-e47ebca320e6','','','Phytologia 14:211.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('847186a0-74b2-5075-8f78-7eff76eae157','','','Mant. 1:238.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a526a372-d3e1-5474-b284-f944f2337a46','','','Sida 20:1397.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77da6d35-d47f-57d4-9b07-ce7de19bcf1a','','','C. S. Sargent, Pl. wilson. 2:540.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c72739f-8cf8-5ed2-92b2-460db89c0429','','','Trudy Prikl. Bot. 23(4):127, 139, 339.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4526322-0d49-5b24-9357-a014d8f06db9','','','V. L. Komarov, Fl. URSS 3:581.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f79b350-d0a9-54d4-b0fd-92811665930f','','','Repert. Spec. Nov. Regni Veg. 18:234.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67c2f3dc-f727-5c41-b441-3117554cd00b','','','Proc. Amer. Acad. Arts 22:479.  1887 "<I>hendersoni</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e643eb38-4e15-5b5f-a328-9f715b563c90','','','Proc. Linn. Soc. New South Wales 23:12.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c41acc8-6015-5f60-bd15-adf23db68f69','','','J. Fed. Malay. States Mus. 4:59.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f1941825-ba91-5017-b5be-072054d2bca4','','','Sp. pl. ed. 2, 1:354.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf2fe40c-132a-538c-b46e-0b3380d4dbc6','','','Ann. Missouri Bot. Gard. 41:240.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d00603bd-5bc1-5ac2-ba65-7f61c78ff8e5','','','Brittonia 34:181.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e52e6dcd-6b60-5d7a-8c1a-85dc4751bb8c','','','Rev. Hort. (Paris) 85:204.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04a6b140-0fe6-58b2-bc97-6952b3526ec8','','','Fl. flumin. 214.  1829 ("1825"); icon. 5: t. 62.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32d1925a-ba5f-541a-b4bd-5f8dd4b10a63','','','Mant. pl. 2:290.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d490af5-4c1a-510f-8dcc-4af7ba5e9c8a','','','E. H. F. Meyer & J. F. Drège, Comm. pl. Afr. austr. 78.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d18e245-d27f-5c45-a842-22388d3cd5f2','','','C. F. von Ledebour, Fl. altaic. 2:455.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36b65679-df05-5a18-af11-36aefe787fe8','','','Novon 19:304.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b569cdd0-f99b-5d4e-b39b-ed46c29ebd4a','','','Kulturnaya Fl. SSSR 1:284.  1935, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2b86e8c-86e6-5198-a4e6-f0975d288c94','','','Fl. Bras. merid. 3:83.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c540092-f075-5410-ac8d-c48d18990ad7','','','Econ. Bot. 31:318.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7cbede1-6860-501c-b575-818a2b2e4ca9','','','Fl. N. Amer. 2:125.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93033d6f-4ede-5bec-8937-b4b9cbbdc4c2','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 6, Sci. Math. 1(4):378.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2f0cefc-5d71-5bd8-ba8a-419574743315','','','Novon 7:13.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60d09915-43a0-5474-aa7f-2243b3ab14f7','','','Enum. stirp. Transsilv. 2:215.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('654cab04-c4b1-5702-8c69-416672d4ef81','','','Rhodora 10:51.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('baa842bc-2c89-5697-a0c4-8b1d37c6cbb2','','','Bothalia 11:282.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a479e50d-9510-5d2a-a16a-ed2664295d0b','','','Fl. Franç. 3:633.  1778','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90fea127-802b-529e-bdbe-27ec0e4169c4','','','Encycl. suppl. 4:282.  1816 (non Koenig 1788)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('041371d0-9c5f-5c86-b65d-74971c5c0294','','','Smithsonian Contr. Knowl. 3(5):61. 1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c71b0fa-8c80-52e2-8ff3-b81ef01176d7','','','Gram. panic. 171.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9073698-3fef-5e58-9cec-aba377346027','','','Anales Jard. Bot. Madrid 59:374.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('35768ebd-f84f-55c4-b0eb-7405167057cc','','','Bot. Cook''s Voy. 3:95.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e9e08bb-6854-5eef-b253-8c9696d9b2bc','','','Annot. checkl. Ital. vasc. fl. 20.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf2d6a27-e494-5431-b868-a69d83090a12','','','Allg. Naturgesch. 3(2):1299.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09216565-5182-5ce6-b1e0-2bf913e742ea','','','Bot. Mag. 36: t. 1483.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44ef3d1e-f055-50ef-992a-ea17b7e4a039','','','Gard. dict. ed. 8: <I>Diervilla</I>.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62d106bc-5e09-5e78-aedc-f2f8d0817e0f','','','Hort. bengal. 33.  1814 (Fl. ind. ed. 1832, 2:401.  1824)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03d73d4f-84f2-5595-ba9d-257ab82d05e9','','','Bot. Jahrb. Syst. 21:612.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75f688aa-0942-5da6-a844-42d6063cafea','','','Phytologia 77:251.  1995 ("1994")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62f88343-9abb-5152-9fd2-cb2913914825','','','Notul. Syst. (Paris) 2:244.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d210fbc-09cb-50de-8e8d-31f8d799fe1a','','','Fl. w. Calif. 412.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa88ed6b-9631-5ae0-8612-040add4f8b53','','','Char. gen. pl. 2, t. 1.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a996704a-b64c-5a1e-8b52-72d8b4a84e7f','','','Fl. Jamaica 4:124.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af935e1d-def9-57f2-a0e3-3f7eef696508','','','Ann. Mus. Bot. Lugduno-Batavi 1:16.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf8f0cce-d112-5399-85c9-2cc3957ed785','','','Scripta Hierosolymitana 12:89.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f315b40b-6073-56c7-9ab5-5e2b99d202b7','','','N. Amer. fl. 25:95.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76b5e019-7bf1-561f-96b7-c434b697b393','','','Phytologia 67:130.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3eb87652-5c39-592d-9341-8a7abbca4454','','','J. Washington Acad. Sci. 17:395.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c60f1dd-45b4-517d-b3b4-74c465711195','','','Bol. Soc. Argent. Bot. 8:207.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccea58a1-d347-5205-92dd-c112d4011158','','','Cact. Succ. J. (Los Angeles) 17:114.  1945 "<I>chlorocarpus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a79a76bc-4813-5574-9068-dd1a97c41a2a','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 6:334.  1879 "<I>walujewi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84967209-da74-598f-8dab-b7278e86ea55','','','Flora 27:782.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('139e1036-620a-5466-b9ed-603558a1b55d','','','W. Aiton, Hort. kew. 2:424.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8460625-a0de-5707-a576-d8c77a8419ed','','','Fl. atlant. 2:245.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9fc63409-63c1-56a5-ba76-38aaf608e9c0','','','Cat. horti Vindob. 2:402.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd998f2c-a305-593e-ae2a-43b31430a851','','','F. E. L. Fischer et al., Index sem. hort. petrop. 4:41.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9e92ed4f-ef9d-5314-8b17-8bd8e0f5f2f4','','','Observ. bot. 314.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1aaf1279-cf17-5c0f-9bf8-ee326175f9b5','','','Icon. pl. rar. 3: t. 560.  1788 ("1786-1793"); Collectanea 2:276.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('365d45e9-4909-5300-96f8-2eea6e10ee8d','','','Syn. pl. 2(1):4.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da0a3470-6b39-59f2-b9b8-46246bc2ac20','','','Gartenflora 38:525.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('865662e6-eacf-56f8-aa24-cf655ec10395','','','Pittonia 3:296.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95596c81-c15d-58e3-b8b5-34bb248b2f04','','','S. L. Endlicher et al., Enum. pl. 29.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91bc0a59-aa96-52fe-a349-77e7a4153757','','','Fl. Amer. sept. 2:368.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('494580ea-f3a7-517b-8a24-98f46e05dddd','','','Mem. New York Bot. Gard. 1:257.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c982ba8b-b41d-5bb1-bee8-9b1363abd045','','','Notizbl. Bot. Gart. Berlin-Dahlem 14:195.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40e47205-60b9-5b64-a88e-ef0ded157233','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 22:29.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6819cc0f-b30c-5f61-9942-c5b629a6b926','','','Mitt. Bot. Staatssamml. München 8:216.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee5cfbf6-3f0c-5e61-9d72-8ccf792aa9ad','','','Gard. Bull. Singapore 17:478.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('80ffa61b-e9bb-517c-95d6-ccfcb224b8f6','','','Cact. Succ. J. (Los Angeles) 71:324.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08b3efb6-7da5-5253-b91b-4902d3683867','','','Linnaea 2:155.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('92cfa4aa-f9fc-5a48-8e41-8bbee52482ac','','','A. L. P. P. de Candolle, Prodr. 9:261.  1845 "<I>bracteata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce40ec60-58e3-512d-9f04-e78fbd06a07a','','','Pl. Arnem. 2: t. 47.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c948a91-0038-5220-bd93-b0fe49e2bd55','','','Mem. New York Bot. Gard. 35:87.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c40cbbf2-c249-59a2-aada-71ae8cf4a8aa','','','Novon 2:188.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('006fffb6-c7b5-57d8-bc37-8428c87fd056','','','Hooker''s Icon. Pl. 19: t. 1823.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cf91e8b9-e095-572c-9cd0-87e0924a9959','','','Ess. Agrostogr. 162, 177.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('97fa37e1-30c1-51b4-afe4-ea2ef79b1f07','','','Prodr. pl. cap. 65.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c835497f-625e-5bc5-8b18-a21ff4e1ffd0','','','Gentes Herbarum 10:210.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2505abb2-e7c6-5d47-8a05-934303c69c5b','','','Syst. Bot. 25:429.  2000','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1e5a7d3-02f8-57d1-b37c-075442aff126','','','A. L. Takhtajan & A. A. Fedorov, Fl. Erevana 330.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9adc3f0-da91-5675-8aaf-535834cf3fe3','','','J. Western Australia Nat. Hist. Soc. 2:10.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc0eeed1-5a04-59c8-b61f-9aa34731bb33','','','Gard. Chron. ser. 3, 12:369.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c64996e1-81e4-50ac-96ee-f9af92995d38','','','Cact. 2:29.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('093e2f4b-d0d6-59fa-b36a-dbb421904c10','','','Fl. orient. 2:168.  1872-1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2ab3ebc-530f-553a-ba21-15d89949592f','','','Ziergeh. Gärt. Parkanl. 400.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0de3fab4-ffef-51fb-b19e-c4432ca00eaf','','','A. Braun et al., App. gen. sp. nov. 1854:7.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('830eda1a-8888-56c4-851a-66ddd3adb967','','','Repert. Spec. Nov. Regni Veg. Beih. 16:40.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7ecf240-f602-53ed-add4-9cdfb431b598','','','Notul. Syst. (Paris) 3:292.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47066ab3-af20-5dcf-a777-dfb915ad89c4','','','Sp. pl. ed. 2, 1:20.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11873b6b-a2ae-53b5-9834-d5e42207793e','','','Kakteenkunde 1943:54.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c24748f9-7db3-57ca-a12f-02726e0caee6','','','Sp. pl. 2:1042.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a5317fa-36d2-5e3f-9c3b-2d013e433510','','','S. African J. Bot. 54:156.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f3f505e7-c0c6-5e82-9ec9-3c234c06a8f1','','','Contr. Biol. Lab. Sci. Soc. China, Bot. Ser. 10:201.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c1e9911-28f9-5bc1-bf2c-b743a08db407','','','Malesia 1:265.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a67d1d7e-23cf-5bae-b224-841a62e30a4b','','','Beih. Bot. Centralbl., Abt. 2, 57(2):258.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82045575-169a-599f-a6f9-4839058b0b9c','','','D. Jordanov, Fl. nar. rep. balg. 3:243.  1966 (non S. F. Gray 1821)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3650aa8c-29f0-5fc2-873c-bbb9af2edde4','','','Ann. Roy. Bot. Gard. (Calcutta) 10(1):109.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e21b6f4-b29e-52ee-b561-693f2c78c287','','','Monatsschr. Kakteenk. 13:130.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c71bab07-3b35-55fd-8b76-f387918b5a1d','','','Gard. Chron. ser. 3, 12:364.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf903188-fbd7-5cfa-a3e1-9e96cdfe5db6','','','Flora 25(2, Beibl.):43.  1842 "<I>chrysocarpus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bf573d00-efaf-50c2-bff9-9b89c0181ca2','','','Gard. dict. ed. 8: <I>Abies</I> no. 1.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19b1873c-5f3d-5876-8f15-0145ed9fb40c','','','Notes Roy. Bot. Gard. Edinburgh 5:271.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8db7f20-2ace-5dc9-a9c9-66f57a471124','','','J. Int. Conifer Preserv. Soc. 16:40.  2009','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f160f1a6-f2cc-52a5-91fa-b80451787311','','','Gentes Herbarum 3:207.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('742536ed-7b55-5771-ad2c-708fd413e67c','','','Prodr. 7:266.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d784fc27-1670-5217-9986-813c70404c82','','','Fl. aegypt.-arab. 146.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6477b15a-50e0-5b67-91d3-65b65321b90c','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 6:267[folio]; 6:340[quarto].  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da4794ef-70a8-5a48-aea5-f957e7a5a874','','','Bot. Mag. (Tokyo) 20:12.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('049380d9-27d3-5822-9fae-2226abbc47ce','','','Bot. J. Linn. Soc. 179:293.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec686cda-0d8c-50f3-b7f7-fcd21622fe3c','','','Bibl. cult. trees 55.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57aeee39-2555-5730-ae05-78dd55f2a7af','','','Sp. pl. 2:782.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41f43f83-3f1b-5c91-bbf9-c18fdfdf103a','','','Izv. Bot. Sada Akad. Nauk S.S.S.R. 30:202.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46a3bd4f-49a0-5aff-ab81-be03c415a1db','','','De Rosa 16.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fac97420-a4ad-5adc-b93b-0cd69db1f42b','','','Fl. jap. (Engl. ed.) 532.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ca7fa542-7f97-5b63-96f2-3df39a141420','','','J. Torrey & A. Gray, Fl. N. Amer. 1:95.  1838 (non Pers. 1807)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('892c2fab-b868-5464-82f9-00000d45efe8','','','M. D. Dassanayake & F. R. Fosberg, Flora of Ceylon 3:384.  1981 "subsp. <I>barbulata</I> Cufod."','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cae56158-3a90-5d59-8fd3-77e7ec12cd91','','','Bull. Misc. Inform. Kew 1926:160.  1926','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f39c5f8-07b4-5c7d-8c5f-6210b60b5680','','','Agric. Colon. 10(2):496.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('55db9788-c7ea-5f65-8315-86fc4511e823','','','Comm. legum. gen. 68.  1837 (Ann. Wiener Mus. Naturgesch. 2:132.  1839)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ed661cc-967c-5f7f-b05d-e62008d3410b','','','J. Arnold Arbor. 4:110.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('252cbf05-d09e-5f2d-a5b9-b816271bc2da','','','Flora 27:780.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d05d40a3-3fdc-5c2f-b3be-bbc976207c43','','','Fl. Arct. USSR 2:238.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12d3cd55-0fa2-5072-99ed-a7ae2a55dd24','','','J. Proc. Linn. Soc., Bot. 3:134.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab852cd6-49c3-5ccf-ae04-635dd273c30b','','','Handb. N. Zeal. fl. 1:128.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b4f4d4d-1ba8-5184-b555-41aaec83c735','','','Austral. Syst. Bot. 1:377.  1989 ("1988")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('049b1d36-f01f-538f-b3f1-f47805bbe5ab','','','Suppl. pl. 373.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d88687fe-1a70-5fd7-9c1c-95adf6a85333','','','Syn. mitteleur. Fl. 1:261.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('248a8d51-ef7b-5717-9796-43d7bc92609c','','','Rast. Turk. 250.  1915 (J. F. Macbr., Contr. Gray Herb. 56:14.  1918)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bdfaaab-a0ff-5b02-a7cd-6a725bef4911','','','Trans. & Proc. Bot. Soc. Edinburgh 23:258, t. 2.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('484c7d85-1007-50d5-b233-e7e7f9b486fe','','','Proc. Amer. Acad. Arts 8:525.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('173adc0b-be3e-53ba-845a-67af52240275','','','Contr. U.S. Natl. Herb. 18:110.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5dce14c-3029-5537-bf08-c898913216e9','','','J. Bamboo Res. 14(3):1.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e1d393bf-8311-5092-969c-55ca85aed34a','','','Jahresber. Schles. Ges. Vaterl. Cult. 41:97.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('285fd87a-72b1-58c9-8da8-69260ccd54af','','','Fl. austral. 3:421.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43b13a11-6433-52df-a520-8c5b3bc68a27','','','Fl. austral. 1:220.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('131426c1-cf11-57f5-b82b-8c3fdd3a6cf4','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 1:364.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f2874c7-8b23-534c-a0b8-99d22fb340d1','','','Bull. Soc. Bot. France 12:81.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('572a9e78-44b3-5b05-a563-f637f8adf443','','','Fl. URSS 2:605.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae468a70-b66a-594f-b00e-9d26f178f620','','','Mem. Amer. Acad. Arts ser. 2, 6:399.  1858-1859 (non (Cham.) DC. 1839)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c10fb012-8e42-5c09-b6a4-d6b7736f7f63','','','Repert. Pl. Succ. 26:10.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b46880c5-5aa5-506c-9e56-a664dee4c434','','','Int. J. Pl. Sci. 169:961.  2008','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6a47f36-fe43-5e7e-83a2-17fbcac88ec3','','','Bull. Div. Agrostol. U.S.D.A. 23:37.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de627ef3-788c-5326-a2d4-aa17252b0e1a','','','Biblioth. Bot. 22(Heft 89):434(988).  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('635e7629-2c73-5ace-80d7-26ab704e874e','','','Garden (London) 75:192.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4cc92baf-73d4-5c6c-9339-cbb6e50da1ae','','','Descr. pl. aliq. nov. 20.  1766','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f72547a8-3bda-5848-8f11-d35147c53e3c','','','P. E. Boissier, Diagn. pl. orient. ser. 2, 1:30.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('940e1486-bdd6-59bd-8c55-e70ba5d8bc01','','','Wrightia 3:128.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d3b87f96-8160-5db1-8270-1afeb96f264b','','','N. Amer. fl. 23:94.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7245e7a-8d97-54de-80ab-a8719d003439','','','Ann. Hist.-Nat. Mus. Natl. Hung. 6:167.  1907-1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1828ca83-265b-5c34-b425-37d7bfc1e5ce','','','Fl. ins. austr. 67.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f13f86d6-ae24-5ebf-8e48-8d73949c6257','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 17:196.  1955 "<I>mongolica</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('af22af7f-a983-56b0-9ae6-394a02e05d2e','','','Prodr. 390.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e055d66e-82be-5e45-9e1f-5862c048c345','','','J. Washington Acad. Sci. 15:460.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9df12762-aec1-5d67-9bcb-1a3517c1017d','','','Philipp. J. Sci. 26:477.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9ec155f-919d-548e-9072-949688b56179','','','Syst. nat. 1:517.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62f7baf1-b2ec-5a23-afc5-f5e491df2d3c','','','Fl. N. Amer. 2:141.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4588ad24-b1fa-531a-b6cc-365fd0f71583','','','J. Arnold Arbor. 25:314.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c969210e-6aec-5beb-9772-339394c9f9b1','','','Novon 12:327.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef22d178-6057-5ee7-87de-cb55dc991916','','','Bull. Herb. Boissier sér. 2, 1:876.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6f0aa45-171d-5a54-b029-d3ba3b2c2024','','','Nomencl. bot. ed. 2, 1:562.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('751f6852-a20f-5eb6-b352-b77f365bb30a','','','Allg. Gartenzeitung 25:147.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4381957c-a9fe-5c4b-9d1a-db8db4757de0','','','Sp. pl. 2:866.  1753 "<I>hieracifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32290cfb-f927-57d9-a3fa-71767b36b0f9','','','Feddes Repert. 95:447.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1daa56b-a939-595f-a6be-6b0034becbfa','','','Amer. J. Bot. 98:1706.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('729427a1-a467-56a4-a320-976866873f97','','','Icon. fl. germ. helv. 6:46.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5d72c1f-b486-5096-a381-db1154f5af6e','','','Bull. Soc. Bot. France 82:154.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('79b16072-bb84-5836-9bf3-f5dd2459ca47','','','Encycl. 1:382.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ebf986fa-1a28-5ed8-bf42-c97cfe57f2e2','','','J. Bot. 69:238.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7f5d1b18-aa80-56d8-9259-c9e133f383e7','','','Verh. Bot. Vereins Prov. Brandenburg 30:166.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9bd20903-3935-54fa-a646-753963c327d8','','','Ann. Missouri Bot. Gard. 74:284.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('291567d8-57f8-5ec2-8626-cc7e58e715b3','','','Oesterr. Bot. Z. 54:286.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1495a376-eafa-51d0-beb5-16d3e7408252','','','Syst. veg. 4(2):404.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44cc84fd-1e7e-514f-a488-6a24fc353407','','','Bot. Jahrb. Syst. 32:124.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('47b09fbe-4ac2-5a18-95b2-eae6b30c6083','','','Man. cult. pl. 374.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df129754-8cde-54a2-a660-7a9c5b9cfa2a','','','J. Proc. Linn. Soc., Bot. 1:42.  1857 (Hooker''s J. Bot. Kew Gard. Misc. 5:119.  1853)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd0c87b9-aa32-5147-b4af-fb509048058c','','','Darwiniana 31:69.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('031857ae-7691-5d22-a35a-bc1684c76432','','','K. B. Presl, Reliq. haenk. 1:241.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4b076d7-c507-5fa6-aa45-0f9b104d027f','','','Proc. Amer. Acad. Arts 29:384.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce1dc0c5-a1bf-5a93-b698-f41696114a60','','','Netraditsĭni plodoy kulʼturi 27.  2012','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65c5c40e-f3ed-5cf1-bd28-d5dca9c5d40b','','','C. Backeberg & F. M. Knuth, Kaktus-ABC 355.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f6a27bc-19a0-5ea3-8053-f93487539140','','','Bot. Mag. (Tokyo) 44:516.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aae8f06c-4120-5e0a-bd87-5a351115bf1e','','','Stapelieen U. Kleinen 293.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e542e3e5-9dd1-5b9a-b528-e1dc14cce170','','','Mem. Amer. Acad. Arts ser. 2, 4:59.  1849 (Pl. fendler.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8135406c-39a1-59e3-b426-402409189bae','','','Ann. Cryptog. Phytopathol. 5:185.  1947 (Gen. fil.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e71cf76-8861-51de-a507-9c3eeb30be4f','','','Beih. Bot. Centralbl., Abt. 2, 36:37.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5953428-00fc-5160-b980-a1bf3fecb7ea','','','Reise Russland 1:160, t. 37.  1770','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea55a3ca-4d33-5a23-8420-e2355ce8aea9','','','Enum. hort. berol. alt. 1:166.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63843044-606c-5465-b01f-8593905a5a6b','','','J. Roy. Soc. Western Australia 27:185.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57d0f596-51b0-5dfa-8785-5253bb89b71f','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 19:528.  1874 (Diagn. pl. nov. jap.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bb8f003-4d43-5fda-90fa-6c8868a9bd76','','','Bijdr. 134.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aeed1c18-8569-5ba1-a69c-435d50ba6eaa','','','Bot. Mag. (Tokyo) 34:156.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7b46102-dbcd-5239-9847-1ee9374402b0','','','J. A. Steyermark et al., Fl. Venez. Guayana 4:116.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bcc1a78-27fb-56f5-8d68-3b2bc13045b4','','','Linnaea 6:522.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56630470-a2be-56c6-babd-30673df6080e','','','Fl. Bras. merid. 3:158.  1833 "<I>nummularifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6488598-7f5b-5a15-b5a8-d17a8ffcb94d','','','Fl. ind. ed. 1832, 3:534.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aeebedef-8c3b-520a-9f94-ab83c78e5ad7','','','Contr. Conoc. Arb. Argent. 20.1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('680f2589-a8df-5547-b3e8-9108159ef8b3','','','Fl. ross. 1(2):79.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37a4e85a-0047-5448-b9f6-2476b9f861f3','','','Queensland Agric. J. new ser., 49:112.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b798f83-9d5a-5658-afe4-a0a4a98f0e18','','','J. G. C. Lehmann, Pl. Preiss. 2:99.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d962382a-47e8-5489-a087-df3753102d92','','','Verh. Mitth. Siebenbürg. Vereins Naturwiss. Hermannstadt 10:177.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8ee2b29-bb5d-5dbb-8679-000dbb3197aa','','','Fl. Ned. Ind., Eerste bijv. 383.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('869c1c70-99b0-5ec3-bc3c-cb0b0c399640','','','Syst. nat. 2(1):110.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cefb5abf-8555-5262-9be8-21a42cae970d','','','Kulturnaya Fl. SSSR 1:144.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ef97e0d-e015-5ff2-86e1-afb37938f6d9','','','Willdenowia 14:301.  1985','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1140e62e-7da0-54cd-be5c-4e8de42906a0','','','Blumea 52:13.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acf906b4-43e4-5d44-987a-33ad2f755231','','','Bull. Torrey Bot. Club 24:150.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3fe295e5-c2e8-58a9-bca9-1e4b93741041','','','Neues J. Bot. 1(2):38, 49.  1805 ("1806")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb459ef8-62e4-576a-bfe6-03e5aecf8b0d','','','Kew Bull. 24:259.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f4d7c1d-3d23-5bab-9476-f9c8e4796d4b','','','Bull. Soc. Hist. Nat. Afrique N. 34:136.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2a89883-3dfb-5a2c-a0bd-d31c6aba060a','','','G. H. K. Thwaites & J. D. Hooker, Enum. pl. zeyl. 411.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4d180f5-8ca0-56e9-826d-e11f64d6f6e4','','','Publ. Field Mus. Nat. Hist., Bot. Ser. 18:140.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('42181afc-a1c8-5064-879f-8e5450bfe0bb','','','J. Bot. (Hooker) 4:368.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f805d079-6631-54a2-8cc0-f8c278719a59','','','J. Bot. (Hooker) 4:230, t. 22.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('167d9c49-4ddd-55ab-b205-f8a81058d9fe','','','Sp. pl. 1:546.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc89d882-b6cf-5977-9b86-0ffc369d76b3','','','Vég. util. Afr. trop. franç. 5:154.  1909 (Bois Côte Ivoire)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('975aa2f1-1eb0-5389-8357-f5c55fc8d38d','','','Bot. Jahrb. Syst. 9:147.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3f7eecd-c6f0-56f4-b942-40aa6fec9d44','','','Phytologia 47:381.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ce04611a-fec9-538b-b023-a56fb5c2a544','','','Trudy Prikl. Bot. 22:223, t. 7-9.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c6448bb-ec75-58e4-8bfe-c8dec24c09dd','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:66[folio]; 1:77[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32806f08-6a03-5424-a2e9-c1ff6d3b2391','','','Ann. Missouri Bot. Gard. 68:467.  1982 ("1981")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23c82885-b89d-5aa4-b545-b7f264ca6ba4','','','Enum. pl. Inarim. 339.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b3bd285-921b-593d-8b15-a979908dce2b','','','Erythea 5:38.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('88eeab63-f3bd-5836-8405-e8e0ef7da228','','','Bull. Brit. Mus. (Nat. Hist.), Bot. 1(8):233.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('697c166e-2c34-54ca-968c-e637586df6bd','','','Nouv. Fl. Italia 1:867.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efe6ac68-daf7-5560-bfd1-af8dd561af2b','','','Bot. Mus. Leafl. 27:56.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a864c4f-d082-5e68-bcbd-e1e848145d46','','','Arch. Bot. Mém. 7:101.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a79270a9-7f6f-5d9f-8c25-464f63b83a5b','','','Rep. Bot. Soc. Exch. Club Brit. Isles 4:639.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a54e11be-fdaa-58d2-a463-5856747f2ffc','','','Fl. Brit. India 7:267.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ba82c4a-2bbc-5fbe-ab06-4bbcfc6148b6','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:159.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ae98c3b-2975-571a-b741-013dff638ef6','','','A. Cronquist et al., Intermountain fl. 5:384.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e657e2d-7c79-505e-8e1d-c2d263a4461a','','','J. Jap. Bot. 11:527.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45d40c33-ad9f-5247-a622-b85508cc92ee','','','Cat. Graines Jard. Dijon 1848:32.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe043496-c394-5cd7-bbf6-388b58e5b624','','','Cactus (Paris) 62:119.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b24e625b-ffd9-5de6-985e-cfe02aef79a3','','','Gen. hist. 4:49.  1837 (N. Wallich, Numer. List 96, no. 2817.  1831, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfd400e2-6188-58a9-a576-f9e1dd17e77c','','','Gard. Chron. ser. 3, 12:124.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29791b23-4a27-5f71-90a1-924ad56444b8','','','Repert. Spec. Nov. Regni Veg. 10:133.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('15194c9a-7cf9-5cb0-8481-2bd1dd982e71','','','Gard. Chron. ser. 3, 78:468.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ac21bf2-940d-5c4a-829e-a92da3d59ac5','','','Syst. Bot. 6:50.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4a6a285-20a5-567c-a866-33975d8a1743','','','Vellosia ed. 2, 1:64, t. 18.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd47e20a-51dc-5177-aca5-82844a7db8cb','','','Acta Univ. Lund., 2, 38:226, map 163b.  1942 (Fl. Alaska & Yukon 2:226.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9749530f-0063-50ca-9c2a-5e177f77edfa','','','J. Proc. Linn. Soc., Bot. 4(suppl.):37.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ab68f26-7687-50b8-8735-480b62f93d2e','','','Icon. Pl. 1: t. 100.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2da4d3c2-775d-5239-addc-e83ce4daaac7','','','Syst. veg. 7(2):1262.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db04bbc7-eca8-5bac-affc-bceb2ed66d3d','','','Allg. Gartenzeitung 14:202.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8b745f49-7283-5245-b158-df29f47af264','','','J. Adelaide Bot. Gard. 18:6.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('823a3561-eec9-5191-847a-fe0f16c48f61','','','Gentes Herbarum 11:340.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2ccda7d-253c-5d29-9cb9-1ff2008a4095','','','Prodr. 4:109.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d846af9e-e2e4-5990-83a3-6d581da83d4c','','','Trans. Linn. Soc. London 23:171.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('990409d8-6574-55d5-96b6-64620842c5f7','','','Ann. Roy. Bot. Gard. (Calcutta) 1: t. 178.  1888 (Sp. <I>Ficus</I>)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa2f5659-b567-5ffb-80d7-c3eb82465a89','','','Fl. Amer. sept. 1:163.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17a709f8-8344-5aa7-b45e-41d8fe65c8d2','','','Rhodora 22:104.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ad83b85-9027-58cc-9dc4-02da20e32ed4','','','Descr. pl. 2:453.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00ea51e3-bdbb-54e1-8d56-3bcbfccf6874','','','H. G. A. Engler, Pflanzenw. Ost-Afrikas C:96.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f52cf686-9de0-5887-87bb-93095c0e2b92','','','Bull. Soc. Bot. France 40:299.  1894 ("1893") (non Haw. ex Wall. 1831)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fa9c67a-42a5-57c8-8b8f-da722d1a6852','','','Taxon 17(6):742.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b9f8cde-a563-51ea-bc5c-485003a72eb2','','','Verh. K. K. Zool.-Bot. Ges. Wien 103-104:228.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a451b52f-eda2-51cb-b3ac-546bea34e1ad','','','Trudy Bot. Inst. Akad. Nauk S.S.S.R., Ser. 1, Fl. Sist. Vyssh. Rast. 1:223.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c0ce543-66da-5f8d-a215-8b4e4a3864d3','','','Opredelit. Rast. Kavkaza 441.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2dd59dd9-5472-57f6-99dd-c7bfcfe9675a','','','Fl. jap. (Engl. ed.) 513.  1953','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9799cbd-7ffc-5c22-89e4-b4d5b2ab3c2d','','','Bot. Reg. 6: t. 436.  1820 (non Willd. 1797)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0824bf4-50d7-56a1-8ba3-61ddb11ac020','','','Collectanea 1:110.  1787 Jan-Sep ("1786"); Icon. pl. rar. 1:3, t. 14.  1787 ("1781-1786")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95dff724-b542-51ff-8e48-45965a2c9e5e','','','Syst. nat. ed. 10, 2:874.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe2b198e-957a-5573-ba27-17f780977bd6','','','Bonplandia 8:76.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9a1754f-f8b7-5ce8-842e-b6d8c027d679','','','Gartenflora 20:257.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6dbc6740-37cc-5c29-8597-df790f7f28d7','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:374.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50fbbc5d-df47-5c6f-93f5-678e938f3b34','','','Contr. Dudley Herb. 4:316.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2ecd82e-1241-52fb-8cd9-f6db490b78d4','','','Jahresber. Pollichia 22-24:309.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cd4802e-176a-545f-b975-baa7ed8123ee','','','Cat. pl. horti monsp. 143.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a0544b96-77f9-507e-9be1-ac93f12a3c2c','','','Bull. Bur. Pl. Industr. U.S.D.A. 179:15.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9975b69a-2931-5f2f-926b-617cf4ade590','','','Arbust. amer. 140.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0230ed02-7fdf-5005-9be6-138f34820657','','','Rhein. Fl. 92.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f51af87-5531-533e-840f-7c533e9a8c64','','','Deut. Fl. 657.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6808db21-16e8-545f-8b22-5f86d0152095','','','Fl. pedem. 2:40.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9326ec2-5621-5dba-a578-7601f1ccbc24','','','J. Torrey & A. Gray, Fl. N. Amer. 1:81.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad76e049-7614-55fd-ba5e-6587780147b0','','','Ann. Sci. Nat., Bot. sér. 3, 2:120.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad2ffd4d-f172-5f25-8598-024bb78b3715','','','Fl. orient. 5:691.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa02dc6c-7503-5f5f-998b-c8a2fcd85b90','','','Collectanea 2:104, t. 3, fig. 1.  1789 ("1788")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2e7b072-a09c-580e-9411-45ecb5391761','','','Cat. pl. hort. panorm. 283.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e12aba60-814b-5f58-bad2-9a6578ed6365','','','Enum. syst. pl. 5, 22.  1760 (Select. stirp. amer. hist. 148, t. 91.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cab904a-2917-5440-92fc-5578b03a6870','','','J. Agric. Trop. Bot. Appl. 9:525.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6be04354-4271-52ad-a2f3-8b2ed944c457','','','Trudy Prikl. Bot. 5(2):157.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8e02965-8817-55a7-aca2-f47334d117cf','','','Gard. Year Book 1865:39.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('36be08d4-4a7e-5352-9ea1-b2842d88c405','','','Sitzungsber. Königl. Böhm. Ges. Wiss., Math.-Naturwiss. Cl. 1885:90.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('681d8f1b-f2ba-593e-b3da-bce592b89cc0','','','Mitt. Bot. Staatssamml. München 19:5.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6a59ce0e-ec17-5dbd-a887-72f6dc70e969','','','Prodr. 6:296.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb752290-759e-5310-a013-0ce3ced1e5f6','','','Commentat. Soc. Regiae Sci. Gott. 3:11.  1781','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e8031207-f5ed-59f7-b0de-e4ba33d9c1e5','','','J. Coll. Sci. Imp. Univ. Tokyo 30:326.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f44a7b95-4838-5e78-b1de-a8aa95269222','','','Orchids 67:261.  1998','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4eaff49f-7461-5aa1-900c-c6a7a9407203','','','Trop. Woods 76:18.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6906963e-2f7d-560f-8491-f220678e6588','','','Crit. Rev. Eucalyptus 6:427.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b494c73e-d92c-5ce5-a1e5-8298a9686b5c','','','Bot. Jahrb. Syst. 41:102.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cea31107-564b-5601-b002-b35b2327e947','','','Ill. Handb. Laubholzk. 1:715.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2687b565-1279-5971-b928-f53d15a7f6e1','','','Brittonia 16:282.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b2c9a4a-2504-5439-8f10-979f91801330','','','Mém. Acad. Sci. Turin, Sci. Phys. 1:13.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('df630c13-4952-544e-b51f-60ad15419cb6','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 20:325.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fec0abf1-ebb6-5473-a471-61f2ba079430','','','Syst. Bot. 12:406.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdf61fa9-0042-5526-96cd-76feffad3add','','','Bull. Soc. Bot. France 72:194.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fe01331-a55f-5f96-9526-845be5b8f086','','','Bull. Torrey Bot. Club 22:354.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a67dcd7b-424e-53c3-a76d-1844d3bfbc6e','','','Index sem. hort. bot. panorm. 1876:46.  1876; Hort. bot. panorm. 1:70, t. 16.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0348b7f4-e1c5-566b-851f-007129ea7b08','','','Syst. nat. ed. 10, 2:1268.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89315a6b-80f6-55d5-9bf8-03400820084d','','','Bull. Int. Acad. Sci. Cracovie, Cl. Sci. Math. 1905:762.  1905; Mém. Soc. Phys. Genève 35:436.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('432d8fda-306b-5087-8198-3a928ecfc416','','','Sp. pl. 2:1066.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94e3924f-a0a5-5d2b-aac8-6713837f8e87','','','Reise um die Erde 2:45.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e02a4cf3-1b05-5e4c-ac95-a8879f778ec4','','','Fl. francisc. 479.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('168fcc8e-9989-59e9-b7f5-062ad4a2f76a','','','Proc. Calif. Acad. Sci. 3:101.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('26c0964c-006e-5593-8c4a-e092f00b3452','','','Repert. Spec. Nov. Regni Veg. 17:378.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9729c692-21f7-57f5-8bf9-0db50b4205e6','','','Compt.-Rend. Séances Soc. Roy. Bot. Belgique 21(2):16.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('832d1662-3ba6-5671-b17c-0e1cdd4dcb47','','','Acta Bot. Yunnan. 11:26-27.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c20ec3f-403b-5ad0-824a-93d37f512fde','','','Bot. Mag. (Tokyo) 1:14, fig.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01806b06-b6dc-5e4f-a612-14033eb5493e','','','F. A. W. Miquel, Pl. jungh. 252.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc9a00d4-6738-56fb-b6ca-a8f6453b44f5','','','J. Proc. Roy. Soc. New South Wales 52:495.  1919 ("1918")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('421c9512-2264-57c6-be55-12ab2952a7a6','','','C. F. von Ledebour, Fl. altaic. 2:257.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7a861233-aa2a-57b2-a2ef-979c6c2a8020','','','Mem. Acad. Sci. (Paris) 1790:395.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6246786-663e-50d5-8614-ed59a7f3a0bc','','','Anales Ci., Univ. Nac. Agrar., Lima 2(3):245-247.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31bd78e3-d109-5db8-8d70-b08fe926ad6e','','','Bot. voy. Sulphur 50.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b314aea1-c630-5e2a-a8e9-4d95f92f0112','','','Bot. Gaz. 47:427.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a179e124-2a9e-567c-9b6e-f65b1cd75e8f','','','Byull. Vsesoyuzn. Inst. Rasteniev. 65:74.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3605f894-8987-5017-996e-b685c5375587','','','Ann. S. African Mus. 9:120.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('412373c3-fca7-5f8b-8849-7814151bf928','','','Gen. N. Amer. pl. 1:273.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05e0f650-88f4-5432-be00-9efd9e4be32d','','','N. L. Britton & C. F. Millspaugh, Bahama fl. 333.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a93cdab-ef49-5eba-ace3-b3c764a78f8b','','','Indian trees 671.  1906 "<I>copelandi</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68907a37-6467-5a77-aba8-c8ae5cb9d25f','','','Austral. Paniceae 248.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('135ec952-07a5-5978-a1bd-8ae7a5ec003b','','','Jard. Malmaison 2: ad t. 115.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03c5f5dc-38bd-501f-b3db-ed012d85a9b8','','','Field & Lab. 18:123.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee94cd38-c72a-5062-8012-e76616d29548','','','Proc. Amer. Acad. Arts 17:362.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33e7e0a0-cd0b-55e5-bff4-03c09dca98da','','','Bot. Jahrb. Syst. 57:188.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de9a407c-540e-5e4e-abeb-98defd2a24ce','','','J. B. A. P. M. de Lamarck, Encycl. 7:7.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4536e7e2-cdc7-5806-aa92-c9f279908a3b','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 43:132.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59fb8aa1-b62c-5212-8b97-cd63d5d4487e','','','Trans. Linn. Soc. London 13:102.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d90f27fa-eaba-597b-8fae-c5af0b4842c4','','','Hort. bengal. 66.  1814 (Fl. ind. ed. 1832, 3:518.  1832)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34fc1e2a-633b-5c71-8864-5d8a2247d878','','','Repert. Spec. Nov. Regni Veg. 50:374.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('084bb77d-4ccb-56e1-a12d-c09ed6002791','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1852:5.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09919526-7725-5013-aada-c867d6fadf7a','','','Bull. Jard. Bot. État Bruxelles 32(2):216.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ea2309a-c276-559e-8437-260d95d7dc6c','','','G. F. Freytag & D. G. Debouck, Sida Bot. Misc. 23:71.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3466a984-1af7-516b-8f21-cd60c12ce54d','','','Bot. Bull. Dept. Agric. 18:, t. 2.  1916 (Queensland Agric. J. new ser., 5:161, t. 2.  1916, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34ce4668-da0b-5819-9f36-64c6ab1c5fdb','','','J. D. Hooker, Fl. Brit. India 2:608.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('deda6809-a476-560d-9409-ea735d53bda9','','','S. Watson et al., Botany [fortieth parallel] 66, t. 10, fig. 4-7.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('707dea66-7f71-5bef-b91e-479c0c94dc3f','','','Mus. bot. 1:283.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ef73082d-1f0d-5508-a1b1-7aa20c421b62','','','Bot. Repos. 4: t. 254.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('75d25e51-601c-557c-b22a-0a4a67b80cc1','','','Feddes Repert. Spec. Nov. Regni Veg. 67:122.  1963','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9700fcdb-3e27-5fa8-bcb9-1457422409be','','','Ill. Handb. Laubholzk. 1:418.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b0209ce0-5cea-5825-90b0-a12a51dbc343','','','Gartenflora 9:2, t. 278, fig. 1.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7742ad9-22bc-5a67-93b1-c5fb8a9ff7c2','','','Izv. Imp. Bot. Sada Petra Velikago 16:179.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b440ce0b-41a4-513c-9865-4d0396f3c3ec','','','Canad. J. Bot. 52:1577.  1974','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbfc9972-9b3b-56a8-b285-4cd21b8ed08d','','','Monogr. Polyg. 74.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3026b888-3f55-599d-9a70-9df99c972e93','','','J. A. Murray, Syst. veg. ed. 14:111.  1784 May-Jun (Fl. jap. 49.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64c5e227-9848-5e8f-b260-2291e7dedb09','','','Abh. Königl. Ges. Wiss. Göttingen 24:155.  1879 (Symb. fl. argent.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f739d91a-06a2-58e0-8f42-9b2924270e35','','','Fl. gall. 167.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a171027-d5d5-525e-89fb-4b50198b44c3','','','Revista Jard. Bot. Nac. Univ. Habana 10(2):104.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f41f411-5364-5c2e-a24e-0a2f71a0cac7','','','Fl. aegypt.-arab. cxv, 109.  1775 "<I>Ocymum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ae65a12-969f-5fd2-a329-79218dbdddb3','','','Philos. Mag. J. 64:300.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65934539-a4b6-544e-a72e-96fd1ad1dfe2','','','Sp. pl. 2:1321.1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd6f713d-fb12-54a2-a8e8-2ed48b467f02','','','Ann. Mus. Bot. Lugduno-Batavi 2:270.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea77cb40-a51b-5526-994a-88d91083ecc1','','','Notul. Syst. (Paris) 2:162.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1fe8f3ed-29ca-5557-8958-5c5336ec6eae','','','Nordic J. Bot. 12:405.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5582e719-a32d-5109-8c4a-88efaebe39b3','','','Gard. dict. ed. 7: <I>Corylus</I> no. 3.  1759','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('656b11f6-f1aa-5909-873d-8f7b085e5fce','','','Bull. Soc. Bot. France 21:18.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('48ad5990-2132-57f0-82ec-7de6be6d8ee3','','','J. Hutchinson & J. M. Dalziel, Fl. W. trop. Afr. 2:338.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fed1f2b6-23e0-5208-98be-a06f34da366e','','','Gard. Chron. 1854:119, 149.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00431b57-9ad8-55f3-bf7d-2ff1f1f43e2c','','','Fl. Pl. Africa 27: t. 1053, 1054.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7438b16-baf8-5055-a3a3-2e169ead2264','','','Bull. Natl. Sci. Mus. Tokyo 29:96.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90dbc7bd-082d-5b2e-aef6-08e08af99f84','','','Prodr. 5:254.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7aa1241-f762-5534-99f9-0e1969766332','','','Bot. Mag. 36: t. 1496.  1812','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fcf2310-2b5e-559d-8ff4-8bff66da266f','','','Tent. pterid. 86, t. 2, fig. 26.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c95ed80-7c55-5716-80e2-57ebaa346744','','','Mem. Torrey Bot. Club 5:225.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f19b837d-06ab-5539-928a-07756de03d3e','','','Ann. Sci. Nat. (Paris) 30:111.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44e7bf7a-c946-5a7a-a8cb-1b7369758559','','','H. F. Van Heurck, Observ. bot. 2:209.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('898732dd-c509-5b68-b936-1c70014b3135','','','Trans. Nat. Hist. Soc. Formosa 3:62.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f11eee95-2254-5b2f-8011-abb526dee187','','','Pl. hartw. 225.  1846 "<I>Befaria phillyriaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c76b9e15-b00a-5338-9e68-43942c953a9c','','','Cacti of the Southwest 92.  1970, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e6feef4-4a94-5f32-a0ce-f1180e371c59','','','Blumea 27:288.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6da2a305-376c-5418-96fa-e24a8d82c7d5','','','Neolin. fl. manshur. 237.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53a0bd18-e428-537a-816e-fa35cc1d2124','','','Sp. pl. 1:255.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1431d1f5-c629-53f5-afdb-fc4f85ced2fd','','','Pacific Sci. 36:501.  [1982] 1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1b8e92a2-6a35-56b7-ae41-05df0d42158b','','','Bull. Imp. Inst. Gr. Brit. 11:460.  1913 "<I>montana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ccc76b03-aa0d-5a6a-9a6b-cc6e60b9c237','','','Trudy Sredne-Aziatsk. Gosud. Univ., Ser. 8b, Bot. 17:5.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('32709d95-6186-56de-b381-177fd192aabb','','','Hort. brit. ed. 2:591.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e437ee1e-6591-5fa0-893b-ce58470f295d','','','Kew Bull. 1955:179.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d93c8272-c3d6-58fa-bc00-60f24a51cdad','','','Ann. Missouri Bot. Gard. 73:757.  1987 ("1986")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('58b41765-22ff-5fb9-a66a-303377b48d62','','','Descr. pl. 1:247.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3858ac2-ed0f-5457-aadb-f14e07444b0a','','','A. L. P. P. de Candolle, Prodr. 11:15.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('896d6846-7077-5c9a-b5db-b7e1c33650f2','','','Lingnan Sci. J. 19:27.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f49eff3-b5e1-509a-af0d-a71537f56d8b','','','Fl. Bras. merid. 1:199.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17fd5ca2-ffe4-5f50-93ae-bf75b72fbb29','','','Hooker''s J. Bot. Kew Gard. Misc. 5:368.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6d2a68da-820e-507e-9252-a90cc3005142','','','Ill. Handb. Laubholzk. 1:632.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1116f98e-ee97-5669-ac43-84d5e300302b','','','Hortus maurit. 224.  1837 "<I>pinnata</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9ea50cc-4e54-5214-81ec-5389b72f7bba','','','K. H. Rechinger, Fl. iranica 172:183.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('515a293f-4411-512c-a794-8da005ff8e64','','','Rhodora 36:266.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ed486fe-1923-5e3c-89b2-12622b50d6b0','','','Syn. fl. N. Amer. ed. 2, 2(1):395.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1318f75-1bec-55cf-bf09-08ed7cf0fe85','','','Brittonia 39:268.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('790f6a72-82b7-5ab7-8162-73b4762dc6f6','','','Amer. J. Sci. Arts 11:170.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57d7d412-ed4f-5dcf-9f15-0b39d6dd9276','','','Tabl. encycl. 2:28.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('015c6b23-40c6-5b96-86d9-ceb72b1311bd','','','Voy. Uranie 498.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5b0ed85-a800-5f84-8e94-214e3ac3e6bf','','','Bot. Bihar Orissa 5:1034.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65fb0059-b5ca-585b-a57a-d46df5c3701d','','','Abh. Königl. Akad. Wiss. Berlin 1894:17.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d85bfeaa-5403-508b-88bd-96e62e36eb6e','','','<I>Phalaenopsis</I> monogr. 197.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17cc971a-484e-5274-a79f-0d3975fe4350','','','New N. Amer. Crassul. 13.  1903 Sep (Bull. New York Bot. Gard. 3:13.  1903 Nov)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('824c3844-befe-5324-bae2-a66094db85e8','','','Torreya 42:9.  1942','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('722bbc63-e2ab-5a33-ba43-3cfe03a43957','','','R. Sweet, Brit. fl. gard. ser. 2, 4(= 7): t. 374.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a754804b-3fd9-50f6-aca7-ba1304568e2b','','','Beitr. Fl. Russl. 211.  1852 (Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 7:387.  1854)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c99bc143-76dd-5b7e-a0b7-fac3657a977f','','','Man. s.e. fl. 184.  1933 "<I>Rynchospora</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('657586c7-4d82-5908-a861-6bce986ae84d','','','S. African Gard. 18:16.  1928 (Notes <I>Mesembrianthemum</I> 1:135.  1928)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0c07a7b-c625-56f8-b311-d969523f47ad','','','Prodr. 6:659.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67c4aa78-7bba-5903-96c7-dd35bb2d076c','','','Oesterr. Bot. Z. 42:345.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3f52e15-4aa9-55f2-9f7a-5e477143f9ef','','','J. Linn. Soc., Bot. 20:142.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('09e888ee-51cd-5a40-99b8-e2d31da3b9f4','','','J. A. Schultes, Syst. veg. 5:258.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d22dd54-3c0b-584a-8991-c2864b2c6e04','','','G. Bentham & J. D. Hook, Gen. pl. 2:655.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0236d5c3-513b-51b4-9de4-b90e83b66d15','','','Neue Entdeck. Pflanzenk. 3:18.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96d4b2f9-c0ce-52ac-b7bc-65c95ae318c0','','','Verh. K. K. Zool.-Bot. Ges. Wien 41:240.  1891, pro syn.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e90ff7d-9e13-5adc-9d14-83b18cef5bb8','','','Proc. Iowa Acad. Sci. 23:621.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d29aed2-dc2c-5053-96e8-9362a10a1866','','','A. L. P. P. de Candolle, Prodr. 12:33.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a9746c1f-ee24-5c1c-8e99-9040798481e6','','','Bull. Soc. Imp. Naturalistes Moscou 27(2):332.  1854','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16cb7810-0704-58dd-8328-57717dfcab9a','','','Fl. Filip. 473.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('281c6162-22da-5055-b373-2ed4ba14d430','','','Biol. cent.-amer., Bot. 2:168, t. 47.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b97734aa-4757-51bf-a290-95562009445f','','','Bull. Nat. Sci. Mus. 33:81.  1953 "<I>yakusimanum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('114d224e-2b1f-5365-a1af-89eaf93cf59c','','','Notes Roy. Bot. Gard. Edinburgh 26:115.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61c67a4a-834a-596f-8ca1-a7df75277d61','','','Bull. Torrey Bot. Club 63:312.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b137f13-6a34-5457-8748-39db91065752','','','J. Bot. 13:292.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4ed921a-4a7e-5edc-82c6-f63fce5d03a9','','','Folia Geobot. Phytotax. 34:365.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c767c21e-4e46-5270-a5d5-a4b544639936','','','Comp. fl. ital. 560.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd49da61-f530-5ad4-a8d8-10e22ff7a90e','','','Sp. pl. 4(2):1083.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4339cd96-73d7-57a2-8a72-e625bb7f5c38','','','Sp. pl. 2:639.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a6bea530-4958-5916-aa20-9df8475054cf','','','Encycl. 2:201.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5f665f68-2c87-5694-9ce0-d3da72f94d68','','','Symb. sin. 7:640.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72e75cc4-4b6b-52c2-bd5a-2ebc83748924','','','F. A. Körnicke & H. Werner, Handb. Getreideb. 1:234.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2ba2e50-bf39-5028-a3cb-f45e90534ea9','','','Rep. Bot. Soc. Exch. Club Brit. Isles 4:632.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eed4d44c-261f-5f64-9a26-a21687983d30','','','S. Watson et al., Botany [fortieth parallel] 154.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33a3813a-26d0-5239-a0c7-961429486536','','','Bot. Mag. 92: t. 5580.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99ccc510-5c15-5ac4-8ea5-bb5894608c47','','','Fl. atlant. 1:96.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b4a17252-7a3e-56e1-a018-eb5f20766767','','','Bull. Misc. Inform. Kew 1892:83.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57215c03-6ffa-51d6-9167-fe9b210c0333','','','Icon. pl. rar. 1:1, t. 1.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62f50f9f-f7fe-53fc-838f-1a04316923d7','','','Phytologia 87:79.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7c8c0cc9-9492-50db-883b-f34019123660','','','C. A. Flaksberger, Kulturnaya Fl. SSSR 1:252.  1935, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7db5ec9-2e42-5e2a-a2e2-b33e4f0d6c09','','','Syn. pl. 2:276.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('724dc61c-4d77-522e-8209-9d9f712c82c4','','','H. G. A. Engler & C. G. O. Drude, Veg. Erde 9(III,2):262.  1921 (Pflanzenw. Afrikas)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8085d71a-a638-5475-93f7-fea4fba30264','','','Fl. Senegal, ed. 2, 427.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c03f5b94-63c5-5d19-a3f0-e182f4177e80','','','Bull. Misc. Inform. Kew 1906:151.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8951512-a549-5fa0-85e9-9fc5f7c3067d','','','Fl. ssredn. jushn. Rossii 1:80.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('252f441d-2f77-586a-9410-b1f7af0c9df5','','','W. J. Hooker, Niger Fl. 119, t. 3.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c07acf95-0239-55cc-bd8b-99a218163f0c','','','Fl. E. Himalaya 1:67.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d38ed0bb-8eb6-5699-b8c8-75d657aa7755','','','Nuovo Giorn. Bot. Ital. n.s., 2:94.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddec70d1-e401-5891-9d02-bfc6441da4c5','','','Repert. Pharm. 35:23.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfc57d45-794c-5e95-81ea-c3de9791ec73','','','Monogr. Salicum 97.  1867','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b67c32d-2f3c-5ec6-a77e-4fc718d44598','','','Contrib. Univ. Michigan Herb. 22:147.  1999','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ef65a94-0b7f-5ce7-84ae-31ddc82f92a0','','','Hooker''s Icon. Pl. 33:4, t, 3261.  1935','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7bb11dc0-67cd-5bbd-b2d9-75b99208d19a','','','Contr. U.S. Natl. Herb. 20:18.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfca1060-ea83-5d49-bd4d-2bb5153e531c','','','Syn. pl. 1:183.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('646ef307-9086-59a4-99dd-e85afe5808de','','','Rev. Hort. (Paris) 75:12.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('929ab08a-9031-5892-89f5-aa26cd164d38','','','Sketch bot. S. Carolina 1:211.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d76c1c01-0ef3-5731-88d3-1f7ad6827272','','','Consp. fl. eur. 616.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b477d91b-ce03-50fb-8ce1-e918ca7057a2','','','Revista Mus. La Plata 33:215.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64ec8887-615b-512f-bd84-9230cc0931a0','','','Proc. Roy. Soc. Queensland 38:117.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81eed4a5-5345-5dd1-9d95-6168be0a4b22','','','Gard. Chron. ser. 3, 66:47.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a798c6e-aea1-597b-857c-55b567215c6c','','','Pl. wright. 1:53.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f09f030f-a116-5422-819c-353d354c0ce6','','','Proc. Acad. Nat. Sci. Philadelphia 1848[4]:25.  1848 Mar-Apr (J. Acad. Nat. Sci. Philadelphia ser. 2, 1:183.  1848 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd3b9cd1-a634-5f44-b476-9fe61b1c7457','','','J. Linn. Soc., Bot. 40:56.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1aa2c695-e57d-5049-9b41-4e16581d1bb1','','','Čas. Nár. Muz. Praze, Rada Přír. 152:120.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5481d79a-9035-5a95-a399-bc4e5297b735','','','Ann. Missouri Bot. Gard. 22:550.  1935 "<I>Roripa</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('869e418d-6a43-5924-b6df-5964688d52f0','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(2):183.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b6c04e6-83b4-577c-85db-dccbea3161a0','','','Encycl. 1:421.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7187d6f2-33d0-5267-8b65-0484f8c464f9','','','Cent. pl. II:31.  1756 (Amoen. acad. 4:330.  1759)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed5b1841-843a-55d8-bcf9-b2bb2cee9096','','','Proc. Amer. Acad. Arts 21:406.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99b05b4b-b91e-554e-892a-ab55d9a15f14','','','Rhodora 42:299.  1940','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('584b61b2-33d5-542e-9827-7049e21a7662','','','Bot. Mag. 29: t. 1154.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('68075633-62ea-5f9e-a70f-474ce678f4af','','','J. Washington Acad. Sci. 15:457.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('542104cf-1ae2-53f9-9c61-6db2b2716eb6','','','Enum. pl. 4:308.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('562a3b5b-b547-58ab-8ef3-afc4d9972174','','','Diagn. pl. orient. ser. 1, 8:11.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdda9cad-b72e-5e05-b7bb-eb9cff8cd2e5','','','Bull. Herb. Boissier 4:759.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb051750-2d03-542d-b6f3-e2b128828513','','','Linnaea 7:116.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70530536-6442-59df-8122-dd98fccfa44a','','','Bull. Soc. Imp. Naturalistes Moscou 36(1,2):603.  1863, nom. cons.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a11b5368-603c-5401-9b9c-55007d424f29','','','Index sem. hort. acad. gotting. 1803:23.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed91d7d7-5101-5d90-9090-41ee57955f48','','','A. L. P. P. de Candolle, Prodr. 13(1):50.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5721fcc-5a3d-56e3-84f2-f28e9c06ceb4','','','Proc. Calif. Acad. Sci. 7:49.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6876e899-877a-5364-911d-c60730cfdbbb','','','Bot. Mag. (Tokyo) 8:213.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4debc9de-ba6f-586a-83c0-0139c4e39be8','','','Fl. jurass. 235.  1865 (ex Christ, Rosen Schweiz 132.  1873)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ace07af-c618-57ef-aa38-f9ce9d0d9f79','','','Baileya 19:168.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fbfaf184-6c46-502d-b7e2-41a5e7e06814','','','Paphiopedilum 119.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8d44c804-ff17-5241-b6a8-ac4cc7b308ae','','','Bull. Torrey Bot. Club 37:234.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25f8211c-739a-5fe9-b655-4c7fde51171a','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 5(1):39.  1883 "<I>leptoclada</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03a86f3f-d3a1-5925-93e2-5b9c8bd1e82a','','','Supp. carp. 2(2):130, t. 204.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e4eb2d26-a126-5047-9944-c0b039f91e63','','','Bot. Jahrb. Syst. 6:79.  1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70ad3bb8-48d2-5c01-8d07-142811e980af','','','Sp. pl. 2:963.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ffa592bf-5c72-5dea-931b-60f1c5a57750','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(3):208.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1477a6a8-10e9-5abf-9180-48be05a6c98a','','','Bull. Cornell Univ. Agric. Exp. Sta. 67:191.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28be1eed-4ede-583a-9c95-6c2430b856e0','','','C. Gay, Fl. chil. 2:381.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c7edef2d-1404-5ec2-874b-e043401b9a79','','','Repert. Spec. Nov. Regni Veg. Beih. 5:123.  1920','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23c6ec4c-30d2-5c9d-948d-2c81e02bd245','','','Sp. pl. 1:186.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa6791f5-eeed-5ae0-b789-32bfabbcb65c','','','Fl. E. Himalaya 1:68.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fdd8fcdd-47da-56ed-981e-e08e26879083','','','Ill. fl. n. U.S. 3:375.  1898','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7190f1eb-514a-5bce-a178-4f4dd23d7ac4','','','Icon. pl. Omeiensium 2: t. 171.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31182b87-f205-53c1-97bf-9c31e94d5344','','','Gram. panic. 138.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c1a28e14-9009-5bcf-b759-182eba2acfc4','','','Linnaea 13:392.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dee7b603-9530-52b5-8b28-0e2dd4118e91','','','Lilloa 23:435.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b4efaed-e3e1-59c5-85b3-65b8497aa1e8','','','Malesia 1:184.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('03f4768b-aa3e-5560-b996-c78aa547c7c5','','','Cyper. Jap. 2:100.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57bcb813-4589-5e1c-ad20-6a8183557d0d','','','V. L. Komarov & E. N. Klobukova-Alisova, Key pl. Far East. USSR 2:767.  1932 "<I>austro-ussuriensis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b5bde1e4-dfda-57a4-95e2-c3cb641a0be4','','','Acta Phytotax. Geobot. 8:268.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a36f7a59-4b00-5628-8634-c31c01898c4a','','','Bull. Jard. Bot. État Bruxelles 19:398.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d05e701f-fcdb-5f64-963b-d6974ff457c0','','','Révis. gramin. 138.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8da40132-1394-537b-a8d7-82115177eb6f','','','Contr. Gray Herb. 59:19.  1919','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9929ce71-bd5e-5eda-994f-7d2c9d65f804','','','Kakteen And. Sukk. 38:284.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66490b6d-14f3-57c2-9999-727420e10042','','','Syn. fl. N. Amer. 1(2):318.  1884','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c4f43d0-9bf4-5e7c-9e43-2a36eb864867','','','C. F. P. von Martius, Fl. bras. 15(2):222.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f63324ee-35a6-57e6-ab24-383c59994cf4','','','Nuytsia 10:396.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b96fd5c5-2a49-539c-8ba5-2778bbebf5e6','','','Notizbl. Bot. Gart. Berlin-Dahlem 11:264.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d77e897-a0f5-577c-9b03-cf1bc8fd20d4','','','Syst. veg. 3:248.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f359633f-6f61-51d6-9356-4bfea9a8d4d1','','','Pittonia 3:148.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('613c01bf-207a-5f15-ae90-8e3fbcdfae6a','','','Monogr. Anonac. 69, t. 5.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e1cfdb8-1d68-52be-b8d0-4ed5426a4906','','','Pl. delavay. 1:36.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f263c3d8-30ed-5927-a731-753ef2a02f83','','','N. Amer. fl. 25:159.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f70839e-a379-5ccc-95a5-73de528b8859','','','Ill. Handb. Laubholzk. 1:94.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3c6862b9-e275-53e1-9b5b-ca40e2d09346','','','Gard. Chron. ser. 3, 70:336.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56d8bd42-80f1-54e4-86d1-576f4b9aa331','','','Enum. pl. afric. austral. 79.  1834-1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edc34818-899a-57bd-8bdf-f4d9006c4a99','','','S. Watson et al., Botany [fortieth parallel] 458.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('adbe6cb3-6c12-528a-bcc9-ee923c8e16fd','','','Fl. ind. ed. 1832, 3:108.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('140868c7-db62-5545-a705-9607d7a424df','','','Kew Bull. 46(3):496.  1991','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59d18764-4984-571c-b14e-8cab8f3eb34e','','','Field Mus. Publ. Bot. 13(V-B, no. 1): 209.  1962','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c50db180-5bae-51cc-9e45-7247e80ba035','','','Cat. pl. Amer. sept. 14.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a750ddab-3a69-58b6-bbca-9484c64db8bc','','','A. B. Lambert, Descr. <I>Pinus</I> ed. 3, 2: unnumbered page between 144 & 145.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ab00bcd-348b-5f56-ad37-b570d2999558','','','Allg. Gartenzeitung 6:233.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e252eb7-f16a-5eb7-b70d-078442830f8d','','','Fl. austral. 2:104.  1864','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab4f428e-ec50-5a45-b89d-ea831eb3376d','','','Acta Phytotax. Sin. 1:159.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('73e15d52-000f-5777-a96c-aeb10d196881','','','D. Oliver, Fl. trop. Afr. 2:529.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('323b914f-c0d4-5c9a-9e02-0dc280a6b490','','','Reis. Amur-Land., Bot. 185.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b01c04b-bf15-5eaa-9c5b-46dbc73fd251','','','J. C. Röhling, Deutschl. Fl. ed. 3, 5:124.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('297a62a2-5647-5322-abb8-611458469d48','','','Mem. New York Bot. Gard. 74(1):25.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aedd2998-56c5-5edc-82fa-c83cca11f775','','','Fl. Filip. 256.  1837 (non (L.) Mill. 1771)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b75417a-f6da-5d83-bf8b-a95518f9d93b','','','Repert. Spec. Nov. Regni Veg. Beih. 1:538.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6cc749df-6489-53f9-ab99-c8328ad45ac5','','','Encycl. 1:669.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b01e223e-833e-579d-92bb-fd8e1485e3e4','','','Notes Roy. Bot. Gard. Edinburgh 36:330.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('beef2813-e03a-54a9-8996-b7baeb84907d','','','Neue Entdeck. Pflanzenk. 2:142.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc080ef1-8cc8-5ce7-b552-f20063ec369c','','','Ann. S. African Mus. 9:215.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('313e0609-ebd8-503a-8127-3bdd7ec51a6c','','','Ill. bot. Himal. Mts. 1(6):215; 2(6): t. 61.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7fb6cf5-3c58-5ba4-987e-eebc537cfe33','','','Mem. New York Bot. Gard. 35:592.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7c96b78-1058-5130-addb-3c6558ede5dd','','','S. African J. Bot. 62:76.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c422d40-f0e3-5c80-964e-e9022577a058','','','R. Sweet, Hort. brit. ed. 3:350.  1839','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('651b7e87-08a6-50b4-a808-03efe01e31e5','','','Fl. francisc. 249.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8083ebf-882f-5bae-93cc-b08d9376a6e3','','','D. Oliver, Fl. trop. Afr. 2:173.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('71fc9a75-04e9-5dce-958a-e7b0053b1b59','','','Bull. Misc. Inform. Kew 1915:409.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cea2816b-b562-51b1-9f90-e337ea56a80b','','','Linnaea 12:312.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6148ac9-05a6-5361-9302-e50af9f127d6','','','J. K. Small, Man. s.e. fl. 1382.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17f5c9ab-bace-53be-bd6d-6225d0c62b41','','','Aroideana 27:139.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab07edcd-15ce-59e8-bafb-8ddd61cad234','','','Bull. Torrey Bot. Club 27:118.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('000369bd-0ab7-5cc8-98c2-9d164596a8f4','','','C. F. P. von Martius. Fl. bras. 14(2):274.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8a9d915-0088-5682-92bd-701b4f7dc6d8','','','Proc. Amer. Acad. Arts 11:100.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd177f50-8d51-5275-9f0e-93f011e599bb','','','Fl. bor.-amer. 2:152.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3283ca31-ac11-54c6-9127-46b736b9c9aa','','','Bot. Mag. (Tokyo) 26:282.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f99ed74-7656-5f14-9fb4-252fdb21147d','','','Pl. Coromandel 2:12.  1799 ("1798")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e82d4038-4b5a-517b-9d3e-2f5ae6dbf976','','','Demonstr. pl. 18.  1753 (Amoen. acad. 3:416.  1756)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a52b622-e7fa-554f-b2eb-cfd098601811','','','Bull. Fan Mem. Inst. Biol. ser. 2, 1:234.  1949','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2aa3ceb5-0ecc-5731-ae60-c484bad73d43','','','Hooker''s J. Bot. Kew Gard. Misc. 2:52.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('262a5613-4815-5229-8edb-15d0d3151d3c','','','J. Adelaide Bot. Gard. 2:163.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('38cad0f8-4e24-5f35-8e81-6c1709cb6379','','','Linnaea 43:535.  1882 (R. Br. in H. Salt, Voy. Abyss. app. lxv.  1814, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40d783b9-262b-57ae-b86b-8b0ac66b750a','','','Sp. pl. 1:205.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6db4ee66-1a63-5f88-b552-e7c8349c4c00','','','Man. fl. n. states 878.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('00d52adc-2c6f-53ef-90d8-f9c0005e8e7f','','','J. S. Gamble et al., Fl. Madras 3(10):1863.  1934 (Bull. Misc. Inform. 1935:149, in observ. 1935)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('965f4d7f-4dbe-5ee2-8cc3-b48579ca8f51','','','Torreya 3:88.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('056ec28c-6e28-588a-9f02-cbd02fb617d2','','','L. H. Bailey, Stand. cycl. hort. 4:1971.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94038ded-4e99-5a7a-82ea-00b9df805849','','','Orchid Rev. 84:134.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2388b2b1-9856-58bd-bc9a-81491c397997','','','J. Arnold Arbor. 18:131.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c1a8dc4-0c53-5143-afc3-3005dfbcab2f','','','Tabl. encycl. 1:237.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee988fcb-5a71-5757-ab09-5492807ae10b','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 22:736.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a8d1d733-ab1b-54a8-9197-fd2d151eea4d','','','Izv. Imp. S.-Peterburgsk. Bot. Sada 5:43.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c9fd88f6-527a-5249-a443-767783ef2a39','','','Prodr. 7:586.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1d7514af-9dd0-5455-9d9e-f574a47b711b','','','Fl. aegypt.-arab. 165.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f8c502f5-0c1d-5c98-82ca-cb4ca8f2cff9','','','Bull. Soc. Bot. France 53:573.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('185e3637-4b2e-5e70-a905-8dfa2d34b319','','','Mém. Acad. Imp. Sci. St.-Pétersbourg Divers Savans 9:177.  1859 (Prim. fl. amur.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c3cf43ca-0625-5a76-bd7d-1e717ddacf0f','','','Rhodora 73:206.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59aadc6a-7497-5e90-ae91-e7d318f5a03f','','','J. Jap. Bot. 93:109.  2018 "<I>dimorphum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f72f6164-445d-5f65-9be7-b7a207b2b238','','','Meded. Proefstat. Thee 40:71, 130.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfed0ebe-9570-5a14-9f55-2eed72b94a79','','','Fl. nov.-zel. 1:151.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62fef4ca-7289-5719-9f3b-abf50f0db32c','','','Mitt. Bot. Staatssamml. München 28:394.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44fae17e-1b79-57d9-a50c-bf5e32748077','','','Oesterr. Bot. Z. 80:337.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16984458-a665-5128-99f0-99d8b4dc475f','','','Fl. ind. ed. 1832, 3:780.  1832 "<I>tenuius</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b370a404-8795-5d31-ae59-62ff57bf8103','','','Fragm. 1:223.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06e46b7f-5af0-51bc-9360-f8cb5c0c8967','','','Bot. Beob. 49.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed902969-9400-5356-a8a3-d55177d0973f','','','Sp. pl. 1:152.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29fabcc2-7a6d-51f5-9d23-12804266693b','','','Gard. Chron. ser. 2, 6:323.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40106211-9674-5af0-a07e-91e334d8221c','','','J. Linn. Soc., Bot. 24:159.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9eee5819-8dea-5313-8049-253b2cbc8a7c','','','Abh. Königl. Ges. Wiss. Göttingen 19:176; Pl. lorentz. 128.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3c70b46-8c1e-5ced-aaaa-8df149e727b4','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(2):187.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65b45e15-d657-5147-8798-ee335e5fd425','','','Hist. pl. 4:229.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23744d10-2a48-53d6-8a73-2be113726938','','','Cact. 4:2027.  1960','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f62d258c-5aef-5a2d-8337-f0d17c6df31a','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 1:23.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f695126-76d7-5114-bc01-a360f587cfcc','','','Bot. Jahrb. Syst. 2:459.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70971d9e-ade4-59db-81ca-8107949ecf26','','','Prodr. 5:258.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7d3e881e-a7c4-5b77-9675-b5daac5c2e24','','','Meded. Dept. Landb. Ned.-Indië 11:201.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c099bf0f-c528-54e3-bd8b-64db8f659d8f','','','Fl. pedem. 1:115, t. 7, fig. 3.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37535060-e1e0-5995-9401-513233b92e36','','','Prix-courant de plantes de serre chaude et de serre tempérée 98.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0171e1ef-4ba9-57d0-b577-783db917d3ae','','','J. Linn. Soc., Bot. 55:258.  1955','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('49d8136c-8959-5891-a8e5-d42968b47c4d','','','Pl. Coromandel 3:7, t. 210.  1811 ("1819")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12dfbe53-e294-5ea9-ab93-92ea19a31e32','','','Phytologia 65:216, fig. 1g-k.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76a6bae3-a609-5401-a7ed-7e6c09f516a3','','','Fl. taur.-caucas. 2:176.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('978915ac-069e-5fc4-b55c-7a22606d909e','','','Enum. pl. 1:577.  1809','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d526390c-2b5e-5f19-a4b2-485a64bd5fbf','','','Linnaea 7:105("150").  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77451ca4-74c1-5775-af9d-f4184a78bf64','','','Contr. U.S. Natl. Herb. 20:240.  1919 "<I>parahybum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1433eb8-f6f0-5642-9950-efcc9d01e5d1','','','Bull. Torrey Bot. Club 113:173.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('77ba66c3-97dd-5ef0-925d-8aa4a34a4372','','','Brittonia 32:225.  1980','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06645621-846f-5b31-a2bf-607fb9436b02','','','Cult. conif. N. Amer. 108.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('915372d1-c3e7-56d2-9b31-71f4ed0e7541','','','J. P. Jessop & H. R. Toelken, Fl. S. Australia ed. 4, 2:658.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20084ebe-1307-5541-a587-851714a96865','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 70:48.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec8dd1cf-da17-561d-a800-f1cb1677b4f2','','','Icon. 4:4, t. 308.  1797','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('61daed06-2fce-5890-89d9-b15ca9663433','','','Gard. Chron. ser. 3, 6:492, 493, fig. 69.  1889 "<I>burkeii</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('edb0576c-9e08-531c-a8af-06a50f45a926','','','Leafl. W. Bot. 1:228.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8374f6b4-2538-54a3-a7da-c173790428e7','','','Fl. sicul. prodr. 2:184.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7b00e64c-95bb-5098-9ec8-eca4364f5095','','','Izv. Azerbaidzhansk. Fil. 10:38.  1944','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18f2ffa2-7175-5f19-a0af-14de6c084111','','','Coll. pl. 2:31, t. 48.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('45b98dcb-dfbf-5fb6-83d8-3c83f75a0c48','','','Cat. pl. Yun-Nan 43.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('12e81db3-6b87-5109-837a-e0b37106665c','','','Amer. Midl. Naturalist 22:515.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e22330b-5858-5da0-8c2d-41e70e6c794f','','','Kew Bull. 70(3)-31:24.  2015','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8757440-6cba-52fa-98b2-b935d61fc5b3','','','J. S. African Bot. 36:270.  1970','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('31c9a078-782b-517f-bb93-ce41365976d8','','','Repert. Spec. Nov. Regni Veg. Beih. 1:840.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff7e743e-ffd2-5d51-9afa-2c0883ae0bfd','','','Mem. Inst. Oswaldo Cruz 20:113.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e46f9a13-1cce-5f05-92f9-853bac23c0e4','','','Ark. Bot. 24:11, 16, fig. 1b, 2b, 3c, d.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('63ae8317-315f-5264-ad65-79cecfb95894','','','Proc. Boston Soc. Nat. Hist. 10:314.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba321f99-9b03-5ebd-832c-e9ad2d734afc','','','Begonian 17:12.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2f4a18db-817b-5bb5-a552-76628872bfc3','','','Curtis''s Bot. Mag. 29:265.  2014','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6443339c-942e-50a9-bcbc-8258da42c838','','','J. Torrey, Pacif. Railr. Rep. 4(5,1):106.  1857 ("1856")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('05bba7ff-472c-5f9c-8823-4671b647b8c3','','','Bull. Jard. Bot. Natl. Belg. 45:418-419.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0a0e2aa-d346-5b0f-b6fb-a41942ad5b0a','','','D. Prain, Fl. trop. Afr. 9:101.  1917','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bb0a9f1-f195-5ce3-8f87-2f6d7f010c9d','','','Icon. descr. gram. austriac. 2:69, t. 97.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('012b35ba-27ae-5478-93bd-d3656c09c86e','','','Ill. Handb. Laubholzk. 1: fig. 365a-l.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f54ab1cc-15ea-5aeb-aaeb-5dffe13251e4','','','Proc. Roy. Hort. Soc. London 3:199.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46eb80cc-e299-5c4f-8479-faa53edd06f3','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 11:82.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e77d657-7db9-5b8e-b361-6bce40b7e590','','','J. A. Murray, Syst. veg. ed. 14:109.  1784 May-Jun (Fl. jap. 49.  1784 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('333bcf61-10b9-56c3-ae92-5dfd0a3306c9','','','Contr. Univ. Michigan Herb. 19:52.  1993','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2f8f304-1b0a-5124-adee-a6b617035688','','','Ann. Bolus Herb. 3:173.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('beb6960e-1c65-5f8c-ae6b-b0b81684b99b','','','Gard. Chron. ser. 2, 6:773, 774.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56c8a2b6-f5f6-5abf-8d86-7471871ea416','','','Contr. U.S. Natl. Herb. 1:280.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea82da55-2dba-539a-a5a0-801ef6d72abe','','','Diagn. pl. orient. ser. 1, 9:64.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1274ecd2-6d36-5824-8851-0a7482a871fd','','','Proc. Amer. Acad. Arts 25:150.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59b2ecb1-86fb-511a-8e95-3baa3d06ba7a','','','The potato: evol. biodivers. genet. res. 188.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1511c618-d90c-55fc-a9f0-6fa421e17750','','','Ann. Roy. Bot. Gard. (Calcutta) 9:22, t. 29.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9c9d0c6a-993a-515a-b37e-74529c5b40a3','','','S. Watson et al., Botany [fortieth parallel] 37, 442.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ef4f935-ad43-5004-a6e6-5eb0541aaa8f','','','Révis. gramin. 1:261, t. 42.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a354a858-912a-5ed8-9636-98b0da66a1d7','','','Cat. horti Vindob. 1:209.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7e860f15-4926-5bfd-aba9-d87a73a5c832','','','Proc. Calif. Acad. Sci. 1:62.  1855','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d039dbdc-10fa-5265-815c-dd6b8c9c3139','','','Syn. gen. Compos. 53.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cff18fb-7bbb-5b5e-9e93-3fa2ee34f678','','','Philipp. J. Sci., C 7:135.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a00ab9b-485c-51c3-b091-3d587e9de5c4','','','Proc. Amer. Acad. Arts 12:272.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad8a0de4-0c97-5f2b-9c83-7bfe03976a2e','','','Class-book bot. ed. 1868:723.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('41427f3d-0450-5ff5-a73d-a0e39b891f02','','','Icon. 5:31, t. 452.  1799','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('23ea8925-a32f-5a00-a841-e54143836b4e','','','Mus. bot. 1:216.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('265f5fe5-d149-5a2d-9e5f-6d42bc43fcc1','','','Enum. syst. pl. 16.  1760 (Select. stirp. amer. hist. 70, t. 48.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82fd7a33-f0be-51f1-a0b0-1625e710c405','','','Sp. pl. 2:771.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a6dfd79-261b-5e9e-9939-d6de9aad6418','','','Gen. pl. 2:598.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6849d5d-1e34-571b-8345-999d6c9ebf42','','','Arch. Jard. Bot. Rio de Janeiro 5:139, 192.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81b14686-71a7-5e68-8d9c-1e8bd2876ed9','','','Bull. Jard. Bot. État Bruxelles 24:67.  1954','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('efe1a601-afbe-5a2b-81da-023451a64c22','','','D.-Y. Hong & S.-L. Zhou, Bot. J. Linn. Soc. 143:146.  2003','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40c4c262-3d45-5be4-9c58-44f4fd0f7df0','','','Fl. flumin. icon. 10: t. 53.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11e75bf7-5a00-5ca0-b677-3b4a9ec8fb8e','','','J. Jap. Bot. 6:113.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e594b5d2-e15f-5d0a-a988-de424980f221','','','Jahrb. Hamburg. Wiss. Anst. 31(Beih. 3):23.  1914, nom. nud.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('201078b5-9df7-5b4f-b6d9-80a02ce38176','','','J. Bot. 44:343.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2dd12ad1-d0e9-51c8-8c53-ca0a563d9046','','','Tabl. encycl. 2:44.  1794','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90cab78f-dade-56c7-b06b-c6a928de3ab1','','','Willdenowia 41:249.  2011','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2dadfc0-d9c4-5457-85a5-c9a4366b74c4','','','Sp. pl. 3(1):543.  1800','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ac45b98-2fdf-5fab-80d3-96604bf6a833','','','J. D. Hooker, Fl. Brit. India 3:481.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ca27ba6-0b4d-5f02-ac49-8f91ab8bbf1e','','','J. Washington Acad. Sci. 5:575.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd325f50-570b-55d4-827f-28f5d25bebe1','','','Fl. Würtemberg 437.  1834 "<I>Brassica campestris</I> a. <I>biennis</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa7f8b26-0b6d-5c95-b3c9-93f3723efc7a','','','Bull. Soc. Bot. France 47:251.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8470a636-4952-51b6-97b0-d4a49d6fa52d','','','H. G. A. Engler, Pflanzenr. IV. 250(Heft 27):119.  1907','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acd0bb8e-f8cf-58a6-bae8-19ca3284d1c9','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 65:482.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57f2aefd-948b-534c-83a3-6dd9cf625e6d','','','W. T. Aiton, Hortus kew. ed. 2, 3:10.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0672339-69c3-5f7f-8eef-9d4ef9ad3d12','','','C. F. P. von Martius, Fl. bras. 14(1):394.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9aa86924-d2b7-578c-847e-fe4150c68202','','','S. Watson et al., Botany [fortieth parallel] 201.  1871 (in C. King, U.S. geol. explor. 40th Parallel vol. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87ea80e7-a762-53ba-8d92-24101d9e10ab','','','Opred. hlebn. zlakov kolos. 194.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6db19e79-88e0-5b36-a71b-5f1b7c453267','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 1:24.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da807642-1866-5d7b-bf19-f7bf4d6a5152','','','J. Washington Acad. Sci. 13:442.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3054b8c2-0a91-5913-8feb-08cdeee1c380','','','Bradleya 13:100.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d1c1fa02-8604-5ed6-96a5-5a0796bb82be','','','Bot. Mag. 154: t. 9248.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('64a77ecb-133b-54b6-9611-91e155051d70','','','Syst. nat. ed. 12, 2: 509; Mant. pl. 1:105.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('122ebb2a-87d8-5c55-81aa-4089bb3c4d89','','','Trans. Linn. Soc. London 27:96, t. 26.  1870','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8a9a3d6c-ccf7-5798-b4bf-238add656174','','','W. J. Hooker, Bot. Mag. 55: t. 2873.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b631f497-702c-5fbb-b7bf-6636c04a4624','','','Cact. Succ. J. (Los Angeles) 51:28.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c4b7d143-3fe7-5a3c-9ab7-98c97ea43b80','','','Occas. Pap. Bernice Pauahi Bishop Mus. 5:12.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60328de3-dcb2-53e8-8ac7-82c630f51863','','','Encycl. 2:600.  1788','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9a4ad14a-d4e3-5168-9be5-384283e8a701','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 2:268.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96be7600-83fc-53ef-ae2e-8565708416ba','','','Index sem. hort. boccad. 1825:3.  1825-1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('27a578b7-0fe7-5f5f-86ca-c96ad0b70745','','','Gard. dict. ed. 8: <I>Cynoglossum</I> no. 3.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56b2b7fa-7610-5754-bc28-17984074d005','','','Linnaea 32:339.  1864 (non G. Don 1827)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6827423f-48bb-5a73-b7a8-786823ad9062','','','Labiat. gen. spec. 600.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c73db71c-b1be-59dd-abea-0edcd9970a8a','','','Select. stirp. amer. hist. 278, t. 169.  1763 "<I>aculeatus</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8e043d8b-4df6-530c-b933-5601b68e8625','','','Pubbl. Reale Ist. Stud. Super. Pract. Perfez. 38:68.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2deeb5e-f9f6-58d3-9812-215198df44dc','','','Prodr. 8:152.  1844 (J. P. B. Delessert, Icon. sel pl. 5:15. t. 35.  1846)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a35b968c-b75a-59d4-bff2-43c02f9e7047','','','C. F. von Ledebour, Fl. ross. 4:358.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aabdd0b1-c8d1-51da-b0a4-35d44d016640','','','Blumea 15:393.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c91fc39-070c-5ae5-9305-6b3fd5e39752','','','Leafl. W. Bot. 4:117.  1945','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e2693ade-a745-5f0e-993c-491c13bdbff8','','','Bot. Jahrb. Syst. 26:314.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3022753a-7acd-530a-8697-99a69ab8e59f','','','Mém. Soc. Phys. Genève 11:445.  1848','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62f10b12-2e91-54d7-b7b3-725bdaf730f7','','','Kew Bull. 41:25.  1986','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ddc4b1f9-9a57-5e28-8f9a-080f1eab4de8','','','A. T. Middendorff, Reise Sibir. 1, 2(3):39.  1856 (Fl. ochot. phan.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2683b832-928c-5942-8f5a-0e022c12d501','','','Bot. Jahrb. Syst. 34:7.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65b086e5-00db-5f72-967f-b917f87a889a','','','Ark. Bot. 24A(4):5.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da3055b9-6218-5d9c-987e-806f9ba0ffb4','','','Bot. Gaz. 20:539.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04ab9aca-087c-5f59-a02f-555237dbed8d','','','C. L. Hitchcock et al., Univ. Washington Publ. Biol. 17(3):315.  1961 (Vasc. pl. Pacif. N.W.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a4c07bd-df4a-5c8d-b416-41def25a3861','','','Phytologia 55:384.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7cac7ae7-a629-5f47-9f8a-1cfaaf9706db','','','J. Jap. Bot. 46:72.  1971','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14d4f192-0544-533f-b59c-7ee1cc46c0da','','','Syn. gen. Compos. 286.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb6c531a-f4ef-5f9f-8253-ac9ce6239ce2','','','Cact. 4:79.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('345c8719-ef9a-5c99-af8a-5d90f0e51270','','','Repert. Spec. Nov. Regni Veg. 9:219.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86992a36-6835-5651-8a3a-7414f1b7471e','','','P. R. Reitz, Fl. ilustr. catarin. 1. Amarantác. 93.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3cfa6bf-8a53-5376-bd2f-883843f6001b','','','Ann. Mus. Congo Belge, Bot. sér. 5, 1:294.  1906 (Études fl. Bas- Moyen-Congo)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87fccc90-568e-525c-a35a-4289ca4e4fd3','','','Mem. New York Bot. Gard. 61:47.  1990','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1318f25b-a808-506b-b232-121c44f5bf61','','','Bot. Rev. 70:142.  2004','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('664d87e7-8798-5a6b-8a8b-ebe91d83eea3','','','Denkschr. Kaiserl. Akad. Wiss. Wien, Math.-Naturwiss. Kl. 51:336.  1886','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37bbb4ad-d10d-5eec-a5ca-8a447012fd70','','','Hist. pl. Guiane 1:480.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('223f226b-4fa7-5596-b2e9-47bd0f32f1fa','','','Handb. Skand. fl. ed. 3:17.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfdba578-6765-5d86-88f0-2f23351fffb4','','','Gram. unifl. sesquifl. 242.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22c5cab7-6d79-5f16-808d-777f8dc78014','','','J. S. C. Dumont d''Urville, Voy. Pôle Sud 38, t. 5.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d6c37f70-0825-50d8-86aa-753654958bc4','','','Fl. Manchur. 2:628.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6068be14-6aef-5ebd-8554-7bea4c748179','','','Enum. Myrt. Bras. 89.  1893 (H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(7):7.  1893)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c42b7ca6-373e-50d6-afb1-da302f485a64','','','W. S. J. G. von Besser, Enum. pl. 83.  1821','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('99682dd9-5465-5e94-a764-5bd64270ddab','','','Trudy Prikl. Bot. 19(2):568.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('acf21def-8374-5854-918f-82ca0cfd0921','','','Amer. J. Bot. 66:205.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b9b16911-7003-5b49-88a1-919229606bfc','','','Enum. hort. berol. alt. 2:25.  1822','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5274771-f466-508a-b199-a9b787fe6b85','','','Sketch bot. S. Carolina 1:109, t. 6, fig. 4.  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c5026558-2fb0-5f23-8bc5-695756a42589','','','H. G. A. Engler, Pflanzenr. IV. 252(Heft 78):134.  1921 (Lehmann, Neue Schriften Naturf. Ges. Halle 3(2):20.  1817, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51d6d8b1-2b82-5b9a-8332-ee0a278e84c7','','','Ann. Naturhist. Mus. Wien 57:86.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d89ffadf-ec78-530b-bf8f-614109944b1e','','','Austral. Syst. Bot. 8:694.  1995','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7848a5f9-7d40-5cca-bc57-9c08f538d281','','','Blumea 50:378.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('62371fff-2bff-5665-a69d-4f5852531a70','','','C. S. Sargent, Pl. wilson. 1:364.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25536680-d8ab-52aa-9e8c-53bb7f54d98c','','','Encycl. 2:296.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('485583df-becc-5b3a-b157-fd21b3f333e6','','','C. F. P. von Martius et al., Fl. bras. enum. pl. 2(1):162.  1829 (Agrost. bras.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d69bd0f-6485-5bb2-8a53-67637a9e2c69','','','J. Linn. Soc., Bot. 38:320.  1908','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8804753c-c117-50bb-a9dd-7b6069612b13','','','Descr. Egypte, Hist. nat. 107, t. 37, fig. 2,2.  1813 ("1812")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90851db9-f114-5d3f-a30b-5149367090fe','','','Linnaea 15:460.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a593f959-0649-59fe-98d7-46a79215452a','','','J. Arnold Arbor. 29:135.  1948','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cb35aa89-23a2-539d-a0c0-ab8c5be34ce5','','','Proc. Amer. Acad. Arts 35:323.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0fbeda50-e317-50fa-af18-8b4762bcbebc','','','Linnaea 5:247.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('739669ce-b00e-59a5-a9bb-0739b0f2c43e','','','Webbia 36:72.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ec76789e-ac01-5b12-90da-bd6bf7e59e7f','','','Kakteen And. Sukk. 9:25.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04ec7b59-e42f-5fb2-85dc-08a5fa103c8d','','','Proc. Amer. Acad. Arts 14:242.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('882bced3-2293-5887-a832-71344842a856','','','Linnaea 4:183.  1829','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a700eda-51a3-5002-8edd-bf6df479d4aa','','','Hort. bengal. 69.  1814 (Fl. ind. ed. 1832, 3:693.  1832)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b7b82cc-480f-595b-b30b-82ba067539dd','','','Observ. Gramin. belg. 100.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd0c6d5d-4f49-5c9f-9ede-cc3eab13dbb7','','','Bijdr. 859.  1826','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('007b70a6-206d-55a6-9e8a-c6d76a0a6125','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 65:470.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04e17dfc-1679-545e-8fd0-d6b060662433','','','Beskr. Guin. Pl. 45.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3d5482f9-0940-5b7e-8367-a44a0ed0fe8a','','','J. Bot. Res. Inst. Texas 1:163.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4e598a3-ac0d-532e-87be-940a24f96b20','','','Tabl. prov. Mer casp. 118.  1789','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0ace50fc-c3fd-5559-91fd-4f6daaa92b78','','','Prodr. 7:168.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('08a0158c-cb1d-5cee-b92d-c197062ab7e9','','','Ann. Rep. Minnesota State Agric. Exp. Stat. 1893:293.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b928483-724b-55fb-830d-c9d1079b7b27','','','Ann. Mus. Goulandris 4:204.  1978','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c6a2ce0-b333-5a97-a42a-d4d750bd4a41','','','Bull. Soc. Hist. Nat. Afrique N. 20:188.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ac8bbb07-b3ab-5a60-a3f1-3327d38131bb','','','Fl. peruv. 1:69.  1798','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b6caed5-6c30-5279-9c2e-33e3bd1ea43e','','','London J. Bot. 2:217.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9d4ad675-ccbc-5b1a-a409-ce90031f5148','','','Bull. Techn. Serv. Ohio Agric. Exp. Sta. 1:239.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('495a5678-1f41-5cc1-869e-80160854b311','','','London J. Bot. 1:377.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('54b89d0a-bcb5-5e8a-b921-2f6ab5126df7','','','R. H. Chodat & É. Hassler, Bull. Herb. Boissier sér. 2, 4:269.  1904 ( Pl. hassler. 2:365.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba585c7d-6092-5992-8a0b-db497cfcba3c','','','Bull. Jard. Bot. Buitenzorg sér. 3, 10:345.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1808a451-ccd7-58d4-9c8c-f325ebfbe518','','','Ber. Deutsch. Bot. Ges. 28:522.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0e731509-7f34-545d-bc8b-a65eba752709','','','Phillip. J. Sci. 5:17.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3cc96459-5490-501e-9a67-5ff99fcdb16b','','','H. G. A. Engler, Pflanzenr. IV. 20(Heft 38):197.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e49d4232-5059-51a8-ade5-4ddddad1fe22','','','A. L. P. P. de Candolle, Prodr. 13(2):49.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('981a410b-f046-59a0-a7f5-10b88cd710e3','','','Bot. Gaz. 19:316.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d7b06e81-e741-54f2-bf66-b16fba92aecd','','','Rhodora 54:190.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9646f014-679a-5064-9921-f1e06a40f8d2','','','Abh. Königl. Ges. Wiss. Göttingen, Math.-Phys. Kl. ser. 2, 13(2):59, 74, t. 18, fig. 12.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c41cedba-7b92-5759-8a76-b3e048919a3a','','','A. Cronquist et al., Intermountain fl. 4:539.  1984','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44755004-4be7-5e89-baa0-63b788412608','','','Ashingtonia 1(2):21.  1973 "<I>narvaecense</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4ce834c7-f5e7-5000-a9be-522b9329953d','','','Quart. J. Sci. Lit. Arts 19:7.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('04d76227-320c-52ac-bd98-56ec5b13f50e','','','Hist. pl. Palat. 1:30.  1776','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('db5fa911-77e5-59bc-9cd5-d10236acc115','','','Revision der Sektion Corylifolii 107.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f4df3e1-d821-58d7-8f51-7be6e4bb3376','','','Austrobaileya 1(4):422.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('501a8988-b01c-533a-8808-ec853eb5d1a4','','','Repert. Spec. Nov. Regni Veg. 11:165.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d9625754-69e5-55ee-a87f-60c67f6a2cab','','','Bot. Gaz. 96:138.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84dda51b-8bd8-50de-92e0-9f7f0df8d2b0','','','Mus. bot. 1:381.  1851','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fefc57e0-9a09-5da4-a33a-e4ed09f6f3a7','','','Ostenia 1933:98.  1933','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b3b68b4-c0e6-5fcc-95d9-247ad058dc0c','','','Repert. Spec. Nov. Regni Veg. Beih. 30(1):1057.  1927 (Prodr. fl. penins. Balcan.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9b94cfbb-ba3d-5b95-9ec0-25c7e6e3bd58','','','Sp. pl. 3(3):1838.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed57cedd-8db2-50af-adb7-e0aed8d90530','','','Observ. bot. 15, t. 2.  1785','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fb1bac3d-3d82-5a8d-9bed-fc60d606eb9d','','','Bamboo World Intro. ed. 4:18.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('694d9522-7fa8-5caa-ba14-2ac354ec8c38','','','Suppl. pl. succ. 42.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fd44188c-09eb-576e-93e6-4949e047bf91','','','M. D. Crisp & P. H. Weston, Advances in legume systematics 3:126.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('607c9265-e107-53fd-9d09-cc976c9e3b4a','','','Bull. Hiroshima Bot. Gard. 5:57.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('19fce708-e6bf-5fa2-8f55-0353c91e0eb4','','','Tent. fl. abyss. 1:118.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dfce74f4-e8b9-5fa0-b07a-df68402c282c','','','S. Kitamura et al., Col. illus. pl. Jap. 142.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1939c21-b29c-5c5f-9eab-4ef6762a20a1','','','Proc. Amer. Acad. Arts 11:123.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f84d8bd3-a67d-5714-a430-47ea01e58de5','','','Bull. Soc. Bot. France 118:741, t. 3.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('578942cc-2016-5430-bcc3-cd4da8239c4a','','','C. Meyer, Vers. Monogr. Ephedra 88.  1846','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46a596aa-3d86-57a1-a77e-a0b6d30ff64a','','','Bot. Mag. 135: t. 8239.  1909','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c89e8f9d-5124-54c2-b1d1-e6a830d3aa50','','','Sci. Mem. Off. Med. Gov. India 12:14.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a47aea2e-b39b-5fda-a1b7-3bb5f45d4e78','','','Linnaea 11:399.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('062fd500-431a-5935-aa97-6d8e86e47b6e','','','Syst. veg. ed. 13:368.  1774','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f128a40-6389-5d88-9c8a-2aa03ff0bcf5','','','Kew Bull. 37:604.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b439fad-a786-56f2-af5c-f192223150bb','','','Hist. pl. 11:45.  1891 (N. L. Britton, Mem. Torrey Bot. Club 5:285.  1894)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3246b0bb-6fc8-54af-957b-ddb54b3e597e','','','Contr. W. Bot. 13:7.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc3b93bc-a40c-5bb0-a47e-a121d19dfe97','','','C. F. P. von Martius, Fl. bras. 3(3):293.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e9e7092-37bb-535d-8404-29bd2e36c18a','','','Prodr. 6:115.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa971150-6ed7-5000-a878-21af06bca131','','','Gard. Chron. ser. 3, 91:438.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f3942b9-6539-5344-81b2-7ae0432e8053','','','C. S. Sargent, Pl. wilson. 2:141.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e8a524f-914c-5beb-914e-1d1df1efee16','','','J. Gén. Hort. 12: t. 1205.  1857','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72e82ff1-5f5c-5800-abfc-14e96ab25ea5','','','Revis. gen. pl. 2:483.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5a86af5f-e94f-5282-8462-8f09d5cde44c','','','Bull. Torrey Bot. Club 20:428.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f11df73-b58f-502e-b570-be85a572fb65','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1881:99.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('74694feb-5941-5233-93bc-f13d4583a9f1','','','Rosac. monogr. 1:87.  1823','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ca67fdf-7241-5ec4-a8d8-db609a6a9fe0','','','J. Phys. Chim. Hist. Nat. Arts 46.  1790','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('eedaf533-8f26-5587-b3eb-7d5b74cfa2ef','','','Hist. pl. Guiane 807.  1775','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0b40ef7a-6440-52fb-987a-f49296431353','','','J. Proc. Linn. Soc., Bot. 2:40.  1858  "<I>cajanaefolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f518ac69-6acc-50e9-be5e-9704e038cfe1','','','Abh. Math.-Phys. Cl. Königl. Bayer. Akad. Wiss. 4(2):119.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c28db2c6-59de-5485-99c9-a709c9876101','','','Rev. Hort. Belge Etrangère 29:268.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('91b6b6b2-087f-50b9-94f2-2bf91b581bda','','','W. H. Harvey & O. W. Sonder, Fl. cap. 2:268.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b41814df-f554-5fd8-8dd3-b84aecfae6b3','','','Herb. pedem. 6:191.  1836 "<I>berteriana</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f6183555-e958-5727-9fa3-7babad8bb82b','','','J. Adelaide Bot. Gard. 12:234.  1989','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6572f732-bfa6-5f0c-a4db-244338de32f1','','','Sida 20:495.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24549eeb-af4b-5e15-88ad-e8236d544741','','','Del. sem. hort. bot. univ. parm. 1864:4.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('16d30aec-bd69-5f85-aa1e-7594354e1d53','','','Belgique Hort. 13:3.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d5fa3c44-1bb3-5ef3-9807-dd0de1e44b97','','','Anales Mus. Nac. Montevideo 1:63.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('abaef531-bbc4-5def-98d4-3c4d3611bed7','','','J. D. Hooker, Fl. Brit. India 3:218.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bb074f0a-6c27-5391-985d-2db8e5466259','','','Monogr. Serjania 324.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6df22798-9342-5a4f-a4de-bde1da4bc632','','','Ann. Missouri Bot. Gard. 9(2):135.  1922','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a838363-bc8a-5931-a806-9dc10960c9d2','','','Muelleria 10:21.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('108135ee-432b-54f2-a251-b205fa250131','','','Syst. Bot. 32:609.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bca6a6d-28a3-5c96-9e2f-a161b9212f29','','','Monatsschr. Deutsch. Kakteen-Ges. 1929:215-216.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('be79c92b-a3d2-59b2-a1f2-44725ddb43e9','','','Austrobaileya 4:279.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2c82ed97-1b44-576f-95e2-ed915bb6b002','','','E. Jahandiez & R. Maire, Cat. pl. Maroc 3:817.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b6f7559-6cc5-5a38-9add-f321e314a231','','','Notes <I>Mesembrianthemum</I> 2:134.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33065332-b6d0-5a93-a979-1ae5faa8d069','','','Result. Sci. Miss. Stef.-Paoli, Coll. Bot. 1:225.  1916','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bfe3295a-5cd4-5bff-8c03-0646fad6c617','','','Darwiniana 17:427.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('537379c0-819c-598e-9be6-a4b0492f06c5','','','Bot. Jahrb. Syst. 97:567.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f4d34711-76aa-59bc-bb4a-e4d63699238e','','','Adansonia sér. 3, 24:286, fig. 11.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cfa24d68-1ebc-5fd8-9ae0-d622c5a9534e','','','Pl. hartw. 295.  1849 "<I>alismaefolius</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('697a2946-15de-5db4-8141-3118eb7eb0b0','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 11:41.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a620cbbb-22b4-572f-92f7-3ac9c8570dd4','','','Hamburger Garten- Blumenzeitung 16:116.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56aff544-18f4-52c0-a9d5-ab414808700a','','','Vidensk. Meddel. Naturhist. Foren. Kjøbenhavn 1849:24.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('117c97c7-1a6d-541e-b001-a8f63f5ee201','','','Fl. reipubl. popularis sin. 61:19.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('125c7cee-6592-5a1b-93e3-cc4cea3c83ac','','','J. Phys. Chim. Hist. Nat. Arts 91:70.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4958ca79-c824-5795-b8c0-6056ee79f639','','','J. Asiat. Soc. Bengal, Pt. 2, Nat. Hist. 61:76.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cbe45d76-4675-579e-974d-75cc5f44b8f3','','','Sp. pl. 1:264.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('966eabbb-64cc-5e93-a2c0-45ebf33cab5f','','','Sitzungsber. Königl. Böhm. Ges. Wiss., Math.-Naturwiss. Cl. 1890(1):215.  1890','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd61c339-8104-55e8-b9f9-2b0fafc075fa','','','Verh. Mitth. Siebenbürg. Vereins Naturwiss. Hermannstadt 1:83.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ca6794b-7193-5a08-b129-1efc5adc735d','','','Bull. Bot. Surv. India 5:108.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aca8e661-0cc6-50c8-940b-c3782ff2898c','','','Phyton (Horn) 38:56.  1998 Aug (P. Ravenna, Onira 3(14):40.  1998 Nov)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b92ee704-c406-5cc7-b74c-ad2a5da48688','','','A. F. C. P. de Saint-Hilaire, Fl. Bras. merid. 2:363.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('56b0eba5-b6fa-58af-893a-7a0ad600ab13','','','Hooker''s Icon. Pl. 4: t. 2537.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e0a552b5-28b9-5628-9847-95ef4bce8023','','','Vasc. pl. Wyoming 295.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('87ed428b-ca2c-57b5-830b-14c9a0fc646e','','','W. T. Thiselton-Dyer, Fl. cap. 5(2):274.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ca72955-8c72-55b9-8cd4-f7f947059033','','','Feddes Repert. 84:462.  1973','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('112899c7-2ca6-5e2d-a210-f1c49b9f5638','','','Tent. fl. abyss. 1:136.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a7e013a0-5a41-5ba8-a25d-e6932922a3d9','','','Bot. Mag. (Tokyo) 15:62.  1901','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8df15cf3-3b13-5e8c-b7e7-a6248c90a544','','','Cact. Succ. J. (Los Angeles) 44:222.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4df91d0c-1892-597a-b264-689e538c44e0','','','Herb. fl. bras. 123.  1837 Nov','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4e7c5dfc-25b7-5cb9-8b75-a58b9b85b793','','','Zametki Sist. Geogr. Rast. 19:10.  1956','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f323b287-7bc7-5b5f-800a-b3b4e7c7e6c6','','','Kew Bull. 47:274, fig. 8.  1992','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2d82e59d-601c-5338-a94f-80a497694c81','','','Trans. Linn. Soc. London 8:346.  1807','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('893d3e36-c055-55f4-8f96-6a6e348166d4','','','Ann. Sci. Nat., Bot. sér. 3, 19:45.  1853','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2bf648ac-2021-5d97-bb73-dad12826a6f6','','','Fl. Amer. sept. 2:548.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3010ad26-2d42-51fe-82f7-c64006ac3e77','','','Flora 49:166.  1866','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3e06c15-d3db-5a21-b338-fa2c4cf3ffa5','','','Fl. flumin. 37.  1829 ("1825"); icon. 8:91.  1831 ("1827")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ed696202-afbf-5894-8adf-842ca8fdb5b7','','','Bot. Jahrb. Syst. 81:155.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('72c57401-b02c-5855-83ea-891fc230ce01','','','W. T. Thiselton-Dyer, Fl. cap. 6:465.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b8d8390f-24e6-5789-ab31-7db1fa26263c','','','Man. Vasc. Pl. Wyoming 2:1343.  1977','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e113fcf-4605-5be0-adac-cdadf3835cd4','','','Brittonia 16:148.  1964','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a00108c5-e03e-5a53-8e02-6ecd80e5682d','','','Mant. pl. 1:96.  1767','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5b488db4-637d-5a23-9f82-de97f422fbd0','','','Gard. Chron. ser. 3, 33:370.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5e6775b5-d146-5fb9-a9eb-6113cdafcdee','','','Crit. revis. Eucalyptus 7:58.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('94cdb68c-ca42-5aa9-a819-a0b4b5dde784','','','Bot. Mag. 73: t. 4320.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7707fef-b12e-5281-87a9-78bedb2dd504','','','Bot. Mater. Gerb. Bot. Inst. Komarova Akad. Nauk S.S.S.R. 8:7-9.  1938','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0236f1bf-1160-5e59-a80e-f2cbd4f6466d','','','Linnaea 7:269.  1832','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22041714-97b8-5a23-a782-430176475666','','','Repert. Spec. Nov. Regni Veg. Beih. 1:847.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8b19472-3ba0-51d2-abd3-5533c909dcd1','','','Adansonia 10:115.  1871','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7e92fb3-acc9-5739-b321-0ae0608d471a','','','Samml. phys.-okon. Aufs. 1:270.  1795','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b208a55f-429f-5e5d-b621-bc429531bebf','','','Fl. lusit. 1:105.  1804','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59316ef1-aa86-502c-b451-bb077b27f1e5','','','Descr. pl. nouv. ad t. 94.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d079910-09f3-5b8b-ab02-7a82095316bb','','','Index sem. hort. petrop. 1:39.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5fc0557a-8d13-580c-9064-43d08d7f23a9','','','Mem. New York Bot. Gard. 1:196.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1993d5fc-d95a-5318-b518-98dcfb2d2556','','','Fl. germ. 1:336, t. 5, fig. 5.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85897111-1107-55b7-8b41-124167571a0d','','','Bull. Mus. Natl. Hist. Nat., Sér. 3, Bot. 47:76, t. 1.  1972','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('06574e45-5074-5140-93be-0245b2738d45','','','Fl. Senegal ed. 2:427.  1967','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bbd430ca-9e66-5827-aa9d-592f6f0a5652','','','Enum. pl. 2:142.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d513fcaa-7183-51e0-b37f-0b6ea7f757c9','','','Trudy Prikl. Bot. 40(2):40.  1969 (non Mansf. 1951)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f9634e47-5919-5634-b65c-d09ebc9d7a11','','','de Acere n. 8.  1781','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b2c45427-6854-5815-a868-d9bf9671533b','','','Ill. Handb. Laubholzk. 2:499.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f7f7b7ed-478c-5888-ab72-7de6da72fa0e','','','Enum. syst. pl. 19.  1760 (Select. stirp. amer. hist. 14, t. 76.  1763)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('65159d09-176b-5e1c-9441-7bc9d3ca0e96','','','Gard. Chron. ser. 3, 90:473.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67e93ffa-1c69-5dda-be8e-1af8101e5d6e','','','Principes 10:45.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e80715ab-7322-509e-b450-9406f55310ca','','','Sp. pl. 4(2):695.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b7924eea-712b-593e-b413-46002cb97a00','','','Bot. Mag. (Tokyo) 46:570.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('213cc37c-f902-5dd3-8674-091be68923d1','','','S. African J. Bot. 67:141.  2001','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67b2cc35-afb6-50e7-96e2-7fd68e80f8e1','','','C. F. P. von Martius, Fl. bras. 6(4):92, t. 28.  1878 "<I>diversifolia</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8184b067-ecbc-55e6-a72e-5f3f00e31d99','','','Proc. Amer. Acad. Arts 19:55.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6d8e359-84d0-5628-bb51-0cf471379423','','','Ann. Transvaal Mus. 3:121.  1912','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96c61dea-977b-5d3a-b678-1417aab8176d','','','Studies in the Calenduleae I. 259.  1943','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('96c4440c-22f1-5fc8-aedc-8af961a4dd55','','','Prodr. fl. cap. 7.  1768 1 Mar-6 Apr','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('90e77479-6e62-5fa2-a02a-7aee550a68e2','','','A. A. Grossheim, Fl. Kavkaza 2:9.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('decf2681-6e6b-5885-843d-5c25a905ede9','','','J. New York Bot. Gard. 26:220.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b38b7f48-2ebb-585f-ac93-4b94b0cd67cc','','','Syn. pl. 4:961.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4f5d3dae-8a8f-581f-a500-371f2a7c21e0','','','Rep. (Annual) Missouri Bot. Gard. 4:208.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('60adbbd2-0629-5a7e-a0ca-c5c657d9ab79','','','Fl. bor.-amer. 1:160.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3c8d6dd-3c41-5722-b53d-ff00a465b353','','','W. L. Jepson, Man. fl. pl. Calif. 783.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81f4f9b0-c445-5b67-99c9-f6455119f2ea','','','Bot. Gaz. 30:342.  1900','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('95644e28-ffa8-55e3-aa27-c193a52f5f2e','','','Věstn. Tiflissk. Bot. Sada 11:2.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('98958a19-53fa-543b-b572-1ec706b45836','','','Rhodora 41:429.  1939','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f776c4e3-3504-5b52-bbf3-ce3452444927','','','Kulturnaya Fl. SSSR 1:262.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bd98a19a-dbfc-5bed-a320-32fef4a1e5e9','','','Bull. Acad. Int. Géogr. Bot. 23:21.  1913','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d516bd30-9730-53a0-b9df-1236d7abda99','','','Bull. Acad. Int. Géogr. Bot. 14:212.  1904','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4c3d2151-9e58-58c9-bb46-75c39b3b0dec','','','Mém. Acad. Imp. Sci. Saint Pétersbourg, Sér. 7, 11(16):127.  1868; 15(1):223.  1869)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b3d59a01-e6b2-5ea7-8ba1-e8272fc31c76','','','Acta Phytotax. Sin. 17(4):92.  1979','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7326d388-69fd-53a5-bf74-5f33676f4fe3','','','Ann. Mus. Bot. Lugduno-Batavi 2:118.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f1d698c-bfd3-5632-ad4f-b118795298f3','','','Deut. Dendrol. 400.  1893','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('78ece89e-668f-5138-8e57-e22eb44c316f','','','Trans. Linn. Soc. London 26:152, t. 6.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e515e3d7-2c84-5762-bbfa-b7c04c0a872e','','','S. U. Sci. Res. J. 2:4.  1966','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c07c15d1-1b28-5491-bdbd-4f8641968b83','','','Acta Bot. Venez. 10:329.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c6dbfd54-8d98-5e8d-b06d-0e6d0ccb3906','','','Nov. Holl. pl. 1:57, t. 81.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1a2c664a-3053-5114-917a-853bf8a4a491','','','Bothalia 3:150.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa301a9d-47cc-5c5f-8f3f-67d4d554763c','','','I. Urban, Symb. antill. 3:479.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fc604943-8ee5-5e5a-8969-d096485fc073','','','V. L. Komarov, Fl. URSS 6:851, 897.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ab1c5f08-897c-56ed-ad65-2023546552fa','','','Descr. pl. 1:226.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ad442ca-0962-5d86-8c2b-d49eaf5ceea5','','','Gard. dict. ed. 8: <I>Helianthemum</I> no. 24.  1768','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5681f608-7d4e-5a5a-8088-fbf27e56d7af','','','Spic. fl. rumel. 2:144.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3f2697cc-2ef5-596d-9ccb-019009bdbcad','','','Prodr. 8:352.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a266c6c0-799f-520c-9439-0ae547535efa','','','Fl. ind. 2:126.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f95bb55-6eff-5284-b65d-9ce4d07f8b2f','','','C. F. P. von Martius, Fl. bras. 13(2):229, 293, t. 53, fig. 2.  1877','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c2294ac-cdc9-5ef8-9dd7-6859f76b61f3','','','Enum. filic. 273.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3ee16d0b-fa38-5e32-a9ee-508625647697','','','Cact. Succ. J. (Los Angeles) 69:227.  1997','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ac80903-2ef8-5c47-b463-263f08259ec2','','','Rhodora 48:401.  1946','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82318223-376b-52c8-a67a-290c03d4f283','','','Bol. Soc. Brot. sér. 2, 41:380.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c71b47d4-8c6b-56ee-b7b6-35cdf70a32a0','','','T. L. Mitchell, Three exped. Australia 2:9.  1838','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c2c73493-9185-54b5-ab48-012c948aa026','','','J. Jap. Bot. 13:781.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd7f70fa-8d87-5ae3-8472-e57130c473d8','','','Consp. fl. eur. suppl. 2:13.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b6b9d80f-b77a-518b-b5e4-dbb6ed45ee34','','','Cat. pl. exot. 16:1-7.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('101eb3ab-ec17-5095-9a6d-b8d5c2abb2ff','','','Proc. Amer. Acad. Arts 12:69.  1876','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('756166a0-7c26-507f-9c85-4ee9e1e51de6','','','Bot. Mater. Gerb. Glavn. Bot. Sada R.S.F.S.R. 5:89.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('364a245b-3131-5103-995c-4b7f6134ed17','','','Alpina 3:36.  1808','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('365ebfdc-e96f-5713-af82-30fa769118a1','','','Sp. pl. ed. 2, 1:703.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5bb910ed-1da2-5d66-8d56-2a491b4119c8','','','Novosti Sist. Vyssh. Rast. 12:234.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('350dbe49-2cfd-50b0-916e-349711cc0758','','','Mitt. Inst. Allg. Bot. Hamburg 8:112.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('70c6f35b-99b9-5de7-8272-4213b1f76ba1','','','J. Elisha Mitchell Sci. Soc. 15:113.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('173b3742-bd67-522e-b3fe-e85233b97c62','','','Encycl. suppl. 1:66.  1810','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ee98fed5-4f69-5e1d-8212-d2f568ad5d22','','','Rodriguésia 56:125.  2006','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('43fa0dcc-961b-5d35-8a18-63309d15cd8c','','','Ann. Mus. Bot. Lugduno-Batavi 2:69.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8a85b93-77fe-5421-9fa9-985bfdb32f5e','','','Hortus kew. ed. 2, 2:78.  1811','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8c8887c3-013e-5e35-b48c-3415d6e92131','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 1:130[folio]; 1:161[quarto].  1816','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c624a949-7bf8-56fe-8dd2-bab7144a7d16','','','W. T. Thiselton-Dyer, Fl. cap. 5(2):275.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a5597233-6d45-5ba6-95c1-1b4ae0b9b18e','','','Fl. N. Amer. 2:47.  1842','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c8e6a16e-87a2-5bb6-88b2-7f852fb63406','','','Sp. pl. ed 2, 2:1664.  1763','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1e01869c-7f63-5444-a889-e3c54c7b41e8','','','Bull. Soc. Bot. France 78:4.  1931','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('20be7b1f-3389-5f22-b93d-41b911a0258a','','','K. M. Schumann & C. A. G. Lauterbach, Fl. Schutzgeb. Südsee Nachtr. 200.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('39205d8a-d4e2-56af-ad98-1dcdbafaaa4f','','','Astragalogia 35.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('526e7d3a-f639-5ca7-a281-0b88c78393ab','','','Pl. Syst. Evol. 142:241.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6ca58a77-9828-5ff4-8005-a9a8fc25ac1b','','','A. P. de Candolle, Prodr. 1:566.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a1183c59-2a4b-56c5-b1b5-153ac0b11fca','','','Svensk Bot. Tidskr. 30:720.  1936','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea161894-fcfa-5b25-9eb5-4d2db9057449','','','Sp. pl. 4(2):1049.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b41673a4-35ac-53a8-b41b-fa69e9aacdec','','','Syst. veg. 4:473.  1819','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0d2c8e38-5fcd-5db4-a0a1-b6f2a68f525e','','','Rhodora 30:179.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6fef70b5-da00-516a-a8b3-5e8dcdeb64b9','','','Erythea 3:104.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a2912ff4-4947-56b9-838d-2ce0a5ea1eea','','','Trans. Amer. Philos. Soc. ser. 2, 7:294.  1840, pro sp.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82aeb1cf-2ee6-5ac7-aeb1-0b013ab35750','','','Bull. S. Calif. Acad. Sci. 9:71.  1910','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4a71cf28-1943-5686-b351-dcb2f5cf0dbf','','','Ann. Sci. Nat., Bot. sér. 2, 2:341.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('40857e0e-bfd1-5325-8e4f-b7007a03b532','','','Sp. pl. 1:203.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2202a4ee-bd00-5e94-9e3f-bf23600d2a9c','','','Tabl. encycl. 1:176.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d18a708-36c6-5a48-8aa9-21b20e69380a','','','Bot. Mag. 23: t. 929.  1806','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fafdef86-c993-5532-b2c5-135ee3a986b9','','','Encycl. 8:799.  1808 "<I>Winterania</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('29b58da6-8458-54c6-a29e-ce42a2cb7732','','','Izv. Imp. Obshch. Lyubit. Estestv. Moskovsk. Univ. 26(2):209.  1880','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5ebaa1ef-91cf-515d-804b-06053e07e02c','','','Mém. Couronnés Autres Mém. Acad. Roy Sci. Belgique 53:190.  1896 (Études fl. Congo)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de62f720-d722-54c1-8130-e2c80186a75a','','','J. Linn. Soc., Bot. 55:758.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('deddf597-1a8a-57d4-8f64-747a56569ef3','','','Sp. pl. 4(1):302.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('86f1a8f3-677c-5e09-9825-adcecb4f038c','','','Enum. pl. 5:277.  1850','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9992c1db-00e5-565f-a08f-1933026ef3d2','','','Prchid.-Buch 490.  1892','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('85299b7c-5260-5a4a-bb62-f458b99ab7b5','','','S. African J. Bot. 2:243.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b056caf-1f9f-5213-b585-0e77bd38127f','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 2:292[folio]; 2:363[quarto], t. 172.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ea47a696-7794-51ff-bca4-07e11cbebc66','','','Austral. Paniceae 96.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('01d9aada-f714-5f6a-b03c-2156fa6ae953','','','Gen. N. Amer. pl. 2:203.  1818','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('094b2a76-1fa9-581d-a134-17ee331a2862','','','Proc. Amer. Acad. Arts Sci. 11:134. Feb 1876, Ad nota [S. Watson et al., Bot. California 1:158.  May-June 1876]','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('44038670-f38c-569c-8edf-91e3732dbb8b','','','Rhodora 63:24.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14a07a10-8a62-5692-8170-b66aa2e45505','','','Index fil. 348.  1862','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6c069ed8-a57b-5b55-8a8a-1b782eda52c7','','','Bull. Mus. Natl. Hist. Nat. 27:118.  1921','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13679f55-8836-5fb5-871c-d1456b552d28','','','Icon. Pl. 5: t. 889.  1852','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2b10d194-da02-5351-96bb-83fe588842f0','','','A. Rees, Cycl. 37: <I>Viola</I> no. 16.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0add12b9-522a-5cae-b3a1-0ebb89b5992b','','','Ill. Handb. Laubholzk. 1:739.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f26afd76-cf2a-579f-a3f0-4d366996cfa0','','','G. Gussone, Fl. sicul. syn. 2:867.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89b29a97-0623-5fb0-a5d4-14e513cf6e73','','','Biol. cent.-amer., Bot. 3:150.  1883','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33e722dd-6795-5299-a53c-49916ae91faf','','','Enum. pl. Austral. occ. 3.  1930','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2df0315-fe71-58b8-9b4e-6769b9f074d1','','','Trans. Linn. Soc. London 1:195.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('708297e6-2928-5606-9682-418b59237d79','','','Mem. Mat. Fis. Soc. Ital. Sci. Modena, Pt. Mem. Fis. 18:409.  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21edc2a2-d9d2-5bcf-b446-89ac2bb24dcb','','','Suppl. pl. 369.  1782 ("1781")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bed5ebef-a721-5465-8c76-944fa0a3a22b','','','Webbia 19:716.  1965','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83d3d465-bdd2-58d3-8848-a0edda34d598','','','J. Adelaide Bot. Gard. 5:230.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9781c216-9cf2-519c-b042-5daf3540ac24','','','A. L. P. P. de Candolle, Prodr. 17:243.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1cf5df23-33ad-5824-a348-c7d33ad846cf','','','Orchid Rev. 11:200.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e44d7b6-deb8-536d-9d71-f47e2bf29191','','','Anales Mus. Nac. Buenos Aires ser. 3, 4:492.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d97ad938-04d2-5030-9444-4c31f43c0b32','','','Hamburger Garten- Blumenzeitung 16:424.  1860','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e3e402c3-b8c4-5e22-a112-3097409ac784','','','Fl. Filip. ed. 2. 266. 1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3007b835-55ad-53ea-97f3-731395413734','','','J. Lindley, Edwards''s Bot. Reg. 29: t. 52.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('33668e80-8d93-55c9-a160-020bd0554254','','','Bot. Jahrb. Syst. 26:306.  1899','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('307667eb-e67b-5f1d-adbc-9e4ae9e237dc','','','Bull. Mus. Natl. Hist. Nat., B, Adansonia sér. 4, 18:172.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a727839e-5d68-5aec-b546-8387fc2d09ed','','','Contrib. Biol. Lab. Sc. Soc. China, Bot. Ser. 9:202.  1934','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5999f3e6-d73b-5131-90d2-4176fcc4665e','','','Repert. Spec. Nov. Regni Veg. Beih. 33:178.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e7dcce11-8e33-5b84-8ca0-8f24158277d1','','','Rev. N. Amer. Umbell. 129.  1888','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ff34e803-02c2-58b5-a819-d6a606f0da77','','','Linnaea 6:423.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('28d0324c-9e93-5e85-b18a-54f599d7e573','','','J. Bombay Nat. Hist. Soc. 26:304.  1918','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ae64c4ab-4a6d-522c-92f1-a4d6f000131a','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 5(2):450.  1887','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fe5b0c23-ea0a-500e-aa6c-3a0603a6a473','','','Bull. Brit. Mus. (Nat. Hist.), Bot. 5:230.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2235a8aa-fcc3-5b2f-9387-726872c169c8','','','Symb. bot. 2:22, t. 68.  1834','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c26afc19-b733-5010-b057-5c1b8a8aff0b','','','Diagn. pl. orient. ser. 1, 9:127.  1849','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1de09b4b-b7dd-58ee-9b47-ef800b3c1f45','','','Index sem. hort. petrop. 1861:45.  1861','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('84dcd940-ec18-56c4-b83d-db5cc96d6e94','','','Bull. Acad. Imp. Sci. Saint-Pétersbourg 27:444; Mélanges Biol. Bull. Phys.-Math. Acad. Imp. Sci. Saint-Pétersbourg 11:187.  1882 (Diagn. pl. nov. asiat.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('76c14a77-0d98-5b75-8f76-3606fb3c7006','','','Boston J. Nat. Hist. 5:108.  1845','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d0bf4243-6b63-57ed-bf92-721ba51b3b0e','','','Compan. Bot. Mag. 1:375.  1836','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa985ede-f725-58fc-a0ea-8e75003c83fc','','','A. L. P. P. de Candolle, Prodr. 14:81.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d4a36e7c-e842-5b88-9861-18be6672872f','','','Fl. jap. 1:176, t. 93.  1841','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('368dfc65-0dee-5961-aba3-dc0d97fc1f5b','','','F. W. H. A. von Humboldt et al., Nov. gen. sp. 4:72[folio].  1818; 4:92[quarto].  1820','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3da3258f-1864-5cf1-8ee9-c9b323eaa1bc','','','Fl. Neotrop. Monogr. 94:167.  2005','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53cd74cc-423d-5e2f-a3ed-fed23b3f4d47','','','W. Roxburgh, Fl. ind. 2:15.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aab35b03-2a0e-5572-a68e-0ef1ea8d4256','','','Notizbl. Königl. Bot. Gart. Berlin 1:27.  1895','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cd306a9d-19da-57c9-a4fa-a9d177733ce2','','','Fl. austral. 7:649.  1878 (F. v. Mueller, 1st gen. report. govt. bot. 20.  1853, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('033fec66-6335-5e32-ad3d-8b4cc785fda0','','','Hand-list Trees Shrubs 1:67.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e5daddc6-2674-5c52-a1fa-1a261bd5f060','','','Austrobaileya 2:354.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2a0996ad-bb14-5201-b363-b4b69ffac132','','','Fl. francisc. 134.  1891','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f32c7e0-7d6c-5ab3-98d9-81de5bbee3eb','','','Fl. vit. 61.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a3c4a317-b2e7-5fe7-94f9-f16f8e684a92','','','N. Amer. fl. 22:143.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7430febd-6e8a-5740-b12e-06f0b44ef171','','','Collectanea 3:217.  1791 ("1789"); Icon. pl. rar. 3: t. 613.  1792 ("1786-1793")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ad5bc4d9-dd82-59b7-bada-f649d909e722','','','Amer. Midl. Naturalist 45:127.  1951','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('544040b9-35b2-55ae-9ff4-01c403da3613','','','Sp. pl. 1:371.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('89680dcd-8eec-5540-89d2-3aa73e27f805','','','Edwards''s Bot. Reg. 21: t. 1765.  1835','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('24b04a0e-b608-5d91-9c44-5e63a9c6846b','','','Byull. Sredne-Aziatsk. Gosud. Univ. 15(suppl.):16.  1927','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('11c6284f-d983-5f24-96f3-6dba36513180','','','Proc. Biol. Soc. Washington 123:190.  2010','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8256679-5160-55e9-939a-f5c0cb7c0c8c','','','Flora 30:66.  1847','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c043f683-dfe5-5fac-9543-459bc2140565','','','Bull. Soc. Imp. Naturalistes Moscou 38(2):392.  1865','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3e049513-1cac-5058-a59f-0a794d6b2849','','','Mant. pl. 2:244.  1771','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ff90a03-4173-5efa-b463-989417cebe31','','','Syn. pl. 1:494.  1805','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57fc48aa-5ace-5320-b4af-138d1685dd6e','','','Bull. Misc. Inform. Kew 1928:273.  1928','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a728ddb2-7d3c-5e1d-b860-8edb0ae375ba','','','Fl. orient. 5:175.  1882','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17b2e7db-70f4-5ade-9ce1-0875fb118eea','','','Phytonom. univ. 3:29.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9ed28a65-0c3d-5950-b617-da46f22dcc1b','','','Nova Guinea 14:456.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a38bf85f-a401-538b-8832-a676d3a24207','','','J. Linn. Soc., Bot. 26:70.  1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('13115ff9-8fa3-5cc8-a53d-2dc3466ca89a','','','J. Linn. Soc., Bot. 32:276.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5c39a3e8-acc7-5d51-806c-78721ccf5e63','','','Brit. fl. gard. ser. 2, 1(= 4): t. 94.  1831','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5cb7d8e5-c52f-5f0e-8b7f-e583a53715e6','','','Edwards''s Bot. Reg. 19: sub t. 1622.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c379ec75-b5fd-5533-9c38-a1051389b17f','','','Trudy Inst. Bot. (Alma-Ata) 11:176.  1961','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd77c0f9-5cf7-5b89-8917-f05554dadb2c','','','Proc. Amer. Acad. Arts 8:625.  1873','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b32ec633-d016-5faa-b383-8a7e07deccec','','','Cat. pl. horti monsp. 81.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('14264590-dcb5-5be7-a403-ff89ad1af2c2','','','Bot. Mag. (Tokyo) 20:85.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('ba13c9a1-e203-58bc-9802-fd98509e8f27','','','C. F. P. von Martius, Fl. bras. 13(2):84.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59be439b-51d0-5200-b05c-91b7f5fae7fc','','','V. L. Komarov, Fl. URSS 7:28.  1937','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('341c6639-2e70-583c-98c8-e53f3d981ef5','','','Prodr. 8:344.  1844','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b700ee78-53fc-53b7-b473-ffbcd7113dfa','','','Abh. Königl. Ges. Wiss. Göttingen 19:163; Pl. lorentz. 119.  1874','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f69b2da0-1a6a-5077-84ed-ddf2454e4117','','','Landw. Fl. 185.  1866 "var.-gr. <I>secalina</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('18d6ee0b-d052-5ab7-bdba-fe711c516d18','','','Notes Roy. Bot. Gard. Edinburgh 34:74.  1975','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5763e299-1681-5296-a12e-b4bb96c840c2','','','Fl. ludov. 86.  1817','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b75174fb-26aa-5a79-b665-beccbed41f2f','','','Sp. pl. 1:477.  1753, nom. utique rej.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('383e1f6a-0b18-5272-86a1-e5aef8481799','','','Bot. Jahrb. Syst. 22:739.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('9f33480f-3372-5b79-b1db-d2e28a04e321','','','Ann. Bot. Fenn. 39:183.  2002','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0f58487f-e5f1-56d7-8bf7-256c139a82d0','','','Contr. Dudley Herb. 3:174, t. 46, fig. 3.  1941','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('93bb9ceb-e969-5839-9830-de113b30397f','','','Ceiba 3:38.  1952','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('022a98d6-9cbd-5ca9-8d62-6605808c5334','','','R. Sweet, Brit. fl. gard. 7: t. 407.  1837','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d1eca69-d65b-5ce6-b1db-fee2d15a07f1','','','Orchid Digest 40:143.  1976','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e664e8df-ab41-5af2-936b-d952c2b2b9c9','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 5:591.  1878','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('757656ba-8952-504c-b9ef-93cc87343cf8','','','A. L. P. P. de Candolle & A. C. de Candolle, Monogr. phan. 3:728.  1881','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d2cecd73-d785-5699-94f4-5a767a13ef22','','','Ann. Sci. Nat., Bot. sér. 4, 11:142.  1859','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('81f4818e-fc1c-554e-83ae-d13e72eb6dd8','','','Syst. veg. 1:951.  1824 ("1825")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c0666c03-8eba-5124-a5d6-eeeed7ed509d','','','Pittonia 5:39.  1902','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cafb19f6-830d-5237-81a0-bf0e5c0788a0','','','Abh. Böhm. Ges. Wiss. 1786:238.  1786','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d51a8d37-303c-57e7-ad41-c3801bc664a7','','','Fl. bor.-amer. 2:111.  1803','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('51bc474d-35b4-59db-8719-8734aea20c06','','','Proc. Acad. Nat. Sci. Philadelphia 1848[4]:22.  1848 Mar-Apr (J. Acad. Nat. Sci. Philadelphia ser. 2, 1:178.  1848 Aug)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f89850e1-adaf-5534-b662-e76995afa558','','','W. T. Thiselton-Dyer, Fl. trop. Afr. 4(2):370.  1906','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d8bd7849-de89-534a-be5c-c0417aaef509','','','Mem. New York Bot. Gard. 35:500.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('636c84f0-90b2-53d3-b342-3877b759cb6f','','','Bot. Reg. 13: t. 1094.  1827','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('10a060ee-4a59-5880-abb7-a6532fdf02f9','','','Fl. Australia 8:390.  1982','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dc3c0f1d-e563-5e61-9b20-ed2f711649ff','','','Sched. Orchid. 6:84.  1923','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bdcae3c-dc07-57ce-b52d-c321ab61aca6','','','Beitr. Bot. 1:102.  1824','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7ce82b0c-9ee2-5899-b381-c3799c84bfd7','','','V. L. Komarov, Fl. URSS 16:15-16, 587.  1950','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a4b00f93-7648-5a72-b839-2c39580c59bd','','','Fruct. sem. pl. 2:237.  1791 "<I>physaloides</I>" (Scopoli, Intr. hist. nat. 182.  1777 , nom. inval.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('34687a78-6c71-5b9c-a9a9-27088ee56fa0','','','Syn. Aroid. 85.  1856 (Mathieu, Catal. 1854, nom. nud.)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cc4e033c-aafe-55f0-96d8-e3d863a65288','','','Descr. Gram. 189.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('7fd09adf-9f86-51be-9dbe-8654e3d55052','','','Monogr. Hort. Pl. Bulbeuses 84.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('67da530b-157d-5976-a944-92e340383f46','','','Proc. Amer. Acad. Arts 3:271.  1856','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0bf54621-72cb-5ffd-96b7-fc77d906ee67','','','C. F. P. von Martius, Fl. bras. 8(2):130.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('46682901-4bfc-5fc6-a2d8-c38ad732b5d9','','','S. W. Naturalist 3:212.  1959','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1f54f29e-579f-589e-8768-36d52ffc53f1','','','Proc. Linn. Soc. New South Wales 29:774.  1905','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('22f65c64-7fad-5cdf-83bf-3c5ef0557851','','','Icon. 1:18, t. 29.  1791','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('25627deb-8d84-53d5-b244-2cf50c7fb2ad','','','Pittonia 3:225.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6b05dd57-e3f9-5d82-8747-9390d61a4126','','','Möller''s Deutsche Gärtn.-Zeitung 47:111.  1932','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2845f11b-79e1-564e-a89b-03d3d9b1322b','','','Austral. Paniceae 235.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('57321944-3ed2-58b7-945c-0c21b7e399a3','','','Candollea 43:717.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('594d916c-78ed-5d5a-b100-198f6a3f49a9','','','Sp. pl. ed. 2, 1:562.  1762','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e6a6d7b-a5bd-5be0-8f7f-8c119ca6a12a','','','H. G. A. Engler & K. A. E. Prantl, Nat. Pflanzenfam. 3(3):344.  1894','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f13a90d-306b-5ff1-9947-751ee714c371','','','Bot. Gaz. 21:133.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f39bf901-2aab-5ceb-9839-5a514045ca2a','','','Carniflora Australis 7:8.  2009 Mar','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('368f20a5-790c-52c1-9508-efd09dc9b783','','','Hortus bengal. 60.  1814','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3801dd9d-1061-5d3b-92ae-7a9e38972f71','','','Trans. New York Acad. Sci. 9:182.  1890 "<I>Thelysperma</I>','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('82660330-8156-5b3c-beb3-9ea57184e351','','','J. Arnold Arbor. 49:38, fig. 1, 2.  1968','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('aa73d7e1-7fe4-5b4c-ae43-a3c267eafcf6','','','Fl. s.e. U.S. 712, 1333.  1903','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4d619f7c-ab82-54bd-aa31-55a33afe4ddc','','','H. S. Kiu & Y. R. Ling, Fl. reipubl. popularis sin. 24:180.  1988','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3b4fcf85-04bd-5780-a604-9ab328a56a8b','','','Contr. U.S. Natl. Herb. 25:546.  1925','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('21bd6e74-9da1-5aa0-9c24-bb9e5dbc48eb','','','Prodr. 6:301.  1838 ("1837")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1ae82f7b-34fc-5b93-8e22-51d654ce4333','','','Repert. Spec. Nov. Regni Veg. 14:196.  1915','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('50c3c79f-39b3-5c3e-975b-fb8ce974d31e','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 8:659, t. 7.  late 1884-1885','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f69338cd-8507-59de-ac08-2f0cd57c641e','','','Desert Pl. Life 2:20.  1936, nom. inval.','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('cdd2216c-f221-5ab1-a253-1995a0f9e187','','','Prodr. Fl. Böhmen 3:508.  1875','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('07878edc-3d4e-57f5-8549-dabd58d45406','','','Index sem. hort. petrop. 5:38.  1839 "<I>albo-roseum</I>"','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d29cb59e-17fc-52c0-bcc6-53e343da4d08','','','Austral. Syst. Bot. 7:553.  1994','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2cd90f94-02ac-5920-b512-d0eb0519581f','','','Brittonia 39:412.  1987','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('965d6501-ec4a-5556-9c87-5d0eb051cd75','','','Adansonia sér. 3, 29:291.  2007','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e6485b6d-f774-51ec-ac50-7a20de6d162c','','','Bot. Jahrb. Syst. 45(Beibl. 104):48.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c359d38f-9c70-5f2a-8fa3-df918e81d3c2','','','Ill. bot. Himal. Mts. 1(2):56.  1834; 2(1): t. 13.  1833','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e2bb5e8-83dc-54b1-8099-c95d693c2380','','','C. F. P. von Martius, Fl. bras. 8(2):128.  1896','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('fa678c7f-73d1-5961-868e-bbddcefd7d24','','','J. B. A. P. M. de Lamarck, Encycl. 3:625.  1792','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c424325-397c-5e5e-9704-339c2e98f374','','','Bull. Torrey Bot. Club 108:202.  1981','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('c26ebde1-3164-5f06-b7f1-6f1905bd2dcb','','','Fragm. 1:30.  1858','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('6f4623d6-1a4b-59e8-a693-829231d95fc4','','','Sp. pl. 3(2):1065.  1802','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e54fc8ee-d6dd-5b66-be78-c32eaba0b6fe','','','Aliso 14:202.  1996','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('dd9b62cc-56fa-5e6d-82b2-2111f6377dbc','','','Bot. Jahrb. Syst. 50:477.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('66e18fe6-2a81-5405-9572-44823aeff99d','','','Trudy Imp. S.-Peterburgsk. Bot. Sada 6:389.  1879','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('d349379a-1242-5b7f-a8b8-35d8ec6c60d1','','','Prodr. 3:220.  1828','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2137fca2-5a72-5ea0-aa7a-f4b5bc42da33','','','W. W. Saunders, Refug. bot. 2: t. 131.  1872','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('1c86c856-a59f-5c3f-be42-5a8e7f1e857c','','','J. Bot. 6:333.  1868','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de9ae0a0-7059-559e-84ab-f72a43589bd2','','','Wiss. Ergebn. Deut. Zentr.-Afr. Exped., Bot. 2:267.  1911','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('37005712-75bd-5e37-a76c-fcf514bd94c4','','','Bull. Torrey Bot. Club 51:382.  1924 Sep','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('8f95c988-4ed4-5144-8d7c-82ebcd0b4551','','','Prodr. 2:258.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('da041acf-7f7c-50f9-a90f-d3f302c2e98b','','','Nomencl. bot. ed. 2, 1:132.  1840','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0a9d9eca-d98e-55c8-8f93-e5b6950466ce','','','Bijdr. 478.  1825','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('5074330c-6cab-5f02-bd92-0f08c02d4850','','','Torreya 24:9.  1924','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('4b2667ca-875e-5dd0-b62f-f3001b942531','','','Amer. Potato J. 60:433.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('de4e700f-faff-51f6-bb99-ecbb8022c86e','','','A. Gray, Pl. wright. 1:66.  1852 (Smithsonian Contr. Knowl. 3, Art. 5)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('322b4fa7-37e2-5053-bf5b-b4f37c6d045b','','','Syst. Bot. 8:423.  1983','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('a74fcfdc-d939-5e5b-aea5-3f7c3a12d6fd','','','Spic. fl. rumel. 1:187.  1843','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('f135d415-31ed-59dc-9a99-ae12ea55394e','','','Descr. Egypte, Hist. nat. 254, t. 38.  1813-1814 ("1812")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('0c24a768-6246-5d7d-9cf6-7a83d29015c0','','','Fuhrer deut. Pfl. 535.  1863','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('2e1e7fb9-3ae1-589f-9c10-53d980bed901','','','Trees shrubs hardy Brit. Isles 2:621.  1914','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('59e1c4ae-8ccc-5cac-8306-ce9d864b9b1b','','','A. Cariot, Étude fl. ed. 8, 2:495.  1888-1889','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('83e77ce1-85d0-5e03-92e1-3a4efbba341e','','','Catal. pl. Banda 47. 1851 (J. Asiat. Soc. Bengal 21:170.  1852)','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1f3a0c4-9831-5fa8-b438-990a090e8c8c','','','Syst. veg. 1:166.  1824 ("1825")','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('3a2ba528-92a7-54c1-9cc3-79e26c61cce4','','','Brittonia 10:54.  1958','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('b1a5bb67-3856-5744-96e2-8d462dffefc7','','','Prodr. 4:509.  1830','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('e13d063a-6adb-55a8-8c5e-37959fa552f9','','','Nova Acta Acad. Caes. Leop.-Carol. German. Nat. Cur. 68:322.  1897','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('53456182-b276-5b7c-810f-63eadf5dc7e1','','','Sp. pl. 1:2.  1753','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('bee9804b-a8fb-5796-ae50-24fb3ddf51eb','','','Bot. Mag. (Tokyo) 43:537.  1929','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('087349d2-1973-5ca7-bf7d-057540799593','','','Hort. bot. hafn. 1:231.  1813','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
INSERT INTO reference VALUES('17da8cbc-2449-5cfd-91ca-b45a34ab78fe','','